/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};

static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;
static ValaCallableExpressionIface * vala_method_call_vala_callable_expression_parent_iface = NULL;

static void vala_method_call_set_call (ValaMethodCall* self,
                                ValaExpression* value);
static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self,
                                      gboolean value);
static void vala_method_call_real_add_argument (ValaCallableExpression* base,
                                         ValaExpression* arg);
static ValaList* vala_method_call_real_get_argument_list (ValaCallableExpression* base);
static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static void vala_method_call_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);
static GType vala_method_call_get_type_once (void);

static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}

ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_method_call_set_call (ValaMethodCall* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_method_call_real_get_is_yield_expression (ValaCallableExpression* base)
{
	gboolean result;
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	result = self->priv->_is_yield_expression;
	return result;
}

static void
vala_method_call_real_set_is_yield_expression (ValaCallableExpression* base,
                                               gboolean value)
{
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	self->priv->_is_yield_expression = value;
}

gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_assert;
	return result;
}

static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}

gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_constructv_chainup;
	return result;
}

static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}

gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_method_call_set_is_chainup (ValaMethodCall* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}

/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}

ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
static void
vala_method_call_real_add_argument (ValaCallableExpression* base,
                                    ValaExpression* arg)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
static ValaList*
vala_method_call_real_get_argument_list (ValaCallableExpression* base)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	ValaList* result = NULL;
	self = (ValaMethodCall*) base;
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		gint _expr_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_expr_list = _tmp2_;
		_tmp3_ = _expr_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_expr_size = _tmp5_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_expr_index = _expr_index + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = vala_list_get (_tmp8_, _expr_index);
			expr = (ValaExpression*) _tmp9_;
			_tmp10_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (expr);
		}
	}
}

static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	if (index >= 0) {
		ValaList* _tmp3_;
		_tmp3_ = self->priv->argument_list;
		vala_list_set (_tmp3_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = method_type;
	if (_tmp4_ != NULL) {
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = method_type;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strcmp0 (_tmp9_, "GLib.N_") == 0;
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			gboolean _tmp14_;
			_tmp11_ = self->priv->argument_list;
			_tmp12_ = vala_list_get (_tmp11_, 0);
			_tmp13_ = (ValaExpression*) _tmp12_;
			_tmp14_ = vala_expression_is_constant (_tmp13_);
			_vala_code_node_unref0 (_tmp13_);
			result = _tmp14_;
			return result;
		} else {
			ValaMethodType* _tmp15_;
			ValaMethod* _tmp16_;
			ValaMethod* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp15_ = method_type;
			_tmp16_ = vala_method_type_get_method_symbol (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp19_, "GLib.NC_") == 0;
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				gboolean _tmp21_ = FALSE;
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 0);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				if (_tmp25_) {
					ValaList* _tmp26_;
					gpointer _tmp27_;
					ValaExpression* _tmp28_;
					_tmp26_ = self->priv->argument_list;
					_tmp27_ = vala_list_get (_tmp26_, 1);
					_tmp28_ = (ValaExpression*) _tmp27_;
					_tmp21_ = vala_expression_is_constant (_tmp28_);
					_vala_code_node_unref0 (_tmp28_);
				} else {
					_tmp21_ = FALSE;
				}
				result = _tmp21_;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			if (!vala_expression_is_accessible (_tmp8_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp9_ = vala_method_call_get_call (self);
	_tmp10_ = _tmp9_;
	result = vala_expression_is_accessible (_tmp10_, sym);
	return result;
}

static void
vala_method_call_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference)
{
	ValaMethodCall * self;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_method_call_get_call (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_value_type (_tmp3_);
	_tmp5_ = _tmp4_;
	mtype = _tmp5_;
	_tmp6_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp6_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp7_ = mtype;
		_tmp8_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp9_ = _tmp8_;
		m = _tmp9_;
		_tmp12_ = m;
		_tmp13_ = vala_method_get_coroutine (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp15_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp16_ = _tmp15_;
			_tmp11_ = !_tmp16_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp20_ = _tmp19_;
			_tmp10_ = g_strcmp0 (_tmp20_, "end") != 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			ValaMethod* _tmp21_;
			_tmp21_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp21_, collection, source_reference);
		}
	} else {
		gboolean _tmp22_ = FALSE;
		ValaDataType* _tmp23_;
		_tmp23_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp23_)) {
			ValaDataType* _tmp24_;
			ValaTypeSymbol* _tmp25_;
			ValaTypeSymbol* _tmp26_;
			_tmp24_ = mtype;
			_tmp25_ = vala_data_type_get_type_symbol (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp22_ = VALA_IS_CLASS (_tmp26_);
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp27_;
			ValaTypeSymbol* _tmp28_;
			ValaTypeSymbol* _tmp29_;
			ValaMethod* m = NULL;
			ValaClass* _tmp30_;
			ValaCreationMethod* _tmp31_;
			ValaCreationMethod* _tmp32_;
			ValaMethod* _tmp33_;
			_tmp27_ = mtype;
			_tmp28_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp29_ = _tmp28_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_CLASS, ValaClass);
			_tmp30_ = cl;
			_tmp31_ = vala_class_get_default_construction_method (_tmp30_);
			_tmp32_ = _tmp31_;
			m = (ValaMethod*) _tmp32_;
			_tmp33_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp33_, collection, source_reference);
		} else {
			ValaDataType* _tmp34_;
			_tmp34_ = mtype;
			if (VALA_IS_DELEGATE_TYPE (_tmp34_)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp35_;
				ValaDelegate* _tmp36_;
				ValaDelegate* _tmp37_;
				ValaDelegate* _tmp38_;
				_tmp35_ = mtype;
				_tmp36_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp37_ = _tmp36_;
				d = _tmp37_;
				_tmp38_ = d;
				vala_code_node_get_error_types ((ValaCodeNode*) _tmp38_, collection, source_reference);
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp39_;
		gint _expr_size = 0;
		ValaList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _expr_index = 0;
		_tmp39_ = self->priv->argument_list;
		_expr_list = _tmp39_;
		_tmp40_ = _expr_list;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_expr_size = _tmp42_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			ValaExpression* expr = NULL;
			ValaList* _tmp45_;
			gpointer _tmp46_;
			ValaExpression* _tmp47_;
			_expr_index = _expr_index + 1;
			_tmp43_ = _expr_index;
			_tmp44_ = _expr_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _expr_list;
			_tmp46_ = vala_list_get (_tmp45_, _expr_index);
			expr = (ValaExpression*) _tmp46_;
			_tmp47_ = expr;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp47_, collection, source_reference);
			_vala_code_node_unref0 (expr);
		}
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp13_;
	ValaExpression* _tmp14_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp15_;
	ValaExpression* _tmp16_;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp111_;
	ValaExpression* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp114_;
	ValaDataType* _tmp115_;
	gboolean _tmp116_ = FALSE;
	ValaProfile _tmp117_;
	ValaProfile _tmp118_;
	gboolean gobject_chainup = FALSE;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp144_;
	gboolean _tmp230_ = FALSE;
	ValaExpression* _tmp231_;
	ValaExpression* _tmp232_;
	gboolean _tmp305_ = FALSE;
	gboolean _tmp306_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp321_;
	ValaDataType* _tmp322_;
	ValaDataType* _tmp323_;
	ValaList* params = NULL;
	ValaDataType* _tmp324_;
	ValaList* _tmp325_;
	ValaList* _tmp326_;
	ValaDataType* _tmp327_;
	ValaExpression* last_arg = NULL;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp383_;
	ValaIterator* _tmp384_;
	gboolean _tmp434_ = FALSE;
	ValaDataType* _tmp435_;
	gboolean _tmp456_ = FALSE;
	ValaDataType* _tmp457_;
	gboolean force_lambda_method_closure = FALSE;
	gboolean _tmp537_ = FALSE;
	gboolean _tmp538_;
	gboolean _tmp539_;
	ValaDataType* _tmp559_;
	ValaDataType* _tmp570_;
	ValaDataType* _tmp571_;
	ValaDataType* _tmp572_;
	ValaDataType* _tmp573_;
	ValaDataType* _tmp574_;
	ValaDataType* _tmp575_;
	ValaList* _tmp576_;
	ValaDataType* _tmp577_;
	ValaDataType* _tmp578_;
	gboolean _tmp579_;
	gboolean _tmp580_;
	ValaDataType* _tmp603_;
	ValaSemanticAnalyzer* _tmp852_;
	ValaSemanticAnalyzer* _tmp853_;
	ValaDataType* _tmp854_;
	ValaList* _tmp855_;
	ValaList* _tmp856_;
	gboolean _tmp883_ = FALSE;
	gboolean _tmp884_ = FALSE;
	ValaCreationMethod* _tmp885_;
	ValaDataType* _tmp913_;
	ValaDataType* _tmp914_;
	gboolean _tmp915_;
	gboolean _tmp916_;
	gboolean _tmp977_;
	gboolean _tmp978_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	if (VALA_IS_MEMBER_ACCESS (_tmp6_)) {
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = vala_method_call_get_call (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_member_access_get_null_safe_access (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp10_ = _tmp9_;
		_tmp4_ = _tmp10_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp11_;
		gboolean _tmp12_;
		vala_code_node_set_error ((ValaCodeNode*) self, !VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression), context));
		_tmp11_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		result = !_tmp12_;
		return result;
	}
	_tmp13_ = vala_method_call_get_call (self);
	_tmp14_ = _tmp13_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp14_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp15_ = vala_method_call_get_call (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_expression_get_value_type (_tmp16_);
	_tmp18_ = _tmp17_;
	if (VALA_IS_DELEGATE_TYPE (_tmp18_)) {
		ValaExpression* _tmp19_;
		ValaExpression* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		_tmp19_ = vala_method_call_get_call (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_expression_get_value_type (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _vala_code_node_ref0 (_tmp22_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp23_;
	} else {
		ValaExpression* _tmp24_;
		ValaExpression* _tmp25_;
		_tmp24_ = vala_method_call_get_call (self);
		_tmp25_ = _tmp24_;
		if (VALA_IS_MEMBER_ACCESS (_tmp25_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp26_;
			ValaExpression* _tmp27_;
			ValaMemberAccess* _tmp28_;
			gboolean _tmp29_;
			gboolean _tmp30_;
			ValaMemberAccess* _tmp39_;
			ValaList* _tmp40_;
			ValaList* _tmp41_;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			gboolean _tmp95_ = FALSE;
			ValaMemberAccess* _tmp96_;
			ValaSymbol* _tmp97_;
			ValaSymbol* _tmp98_;
			_tmp26_ = vala_method_call_get_call (self);
			_tmp27_ = _tmp26_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp28_ = ma;
			_tmp29_ = vala_member_access_get_prototype_access (_tmp28_);
			_tmp30_ = _tmp29_;
			if (_tmp30_) {
				ValaSourceReference* _tmp31_;
				ValaSourceReference* _tmp32_;
				ValaExpression* _tmp33_;
				ValaExpression* _tmp34_;
				ValaSymbol* _tmp35_;
				ValaSymbol* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_method_call_get_call (self);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_expression_get_symbol_reference (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_symbol_get_full_name (_tmp36_);
				_tmp38_ = _tmp37_;
				vala_report_error (_tmp32_, "Access to instance member `%s' denied", _tmp38_);
				_g_free0 (_tmp38_);
				result = FALSE;
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp39_ = ma;
			_tmp40_ = vala_member_access_get_type_arguments (_tmp39_);
			_tmp41_ = _vala_iterable_ref0 (_tmp40_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp41_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			if (_tmp44_ != NULL) {
				ValaMemberAccess* _tmp45_;
				ValaExpression* _tmp46_;
				ValaExpression* _tmp47_;
				ValaDataType* _tmp48_;
				ValaDataType* _tmp49_;
				ValaDataType* _tmp50_;
				ValaMemberAccess* _tmp51_;
				ValaExpression* _tmp52_;
				ValaExpression* _tmp53_;
				ValaSymbol* _tmp54_;
				ValaSymbol* _tmp55_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp66_;
				ValaSymbol* _tmp67_;
				ValaSymbol* _tmp68_;
				gboolean _tmp69_ = FALSE;
				ValaMethod* _tmp70_;
				_tmp45_ = ma;
				_tmp46_ = vala_member_access_get_inner (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = vala_expression_get_value_type (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = _vala_code_node_ref0 (_tmp49_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp50_;
				_tmp51_ = ma;
				_tmp52_ = vala_member_access_get_inner (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = vala_expression_get_symbol_reference (_tmp53_);
				_tmp55_ = _tmp54_;
				if (VALA_IS_SIGNAL (_tmp55_)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp56_;
					ValaExpression* _tmp57_;
					ValaExpression* _tmp58_;
					ValaMemberAccess* _tmp59_;
					_tmp56_ = ma;
					_tmp57_ = vala_member_access_get_inner (_tmp56_);
					_tmp58_ = _tmp57_;
					sig = VALA_IS_MEMBER_ACCESS (_tmp58_) ? ((ValaMemberAccess*) _tmp58_) : NULL;
					_tmp59_ = sig;
					if (_tmp59_ != NULL) {
						ValaMemberAccess* _tmp60_;
						ValaExpression* _tmp61_;
						ValaExpression* _tmp62_;
						ValaDataType* _tmp63_;
						ValaDataType* _tmp64_;
						ValaDataType* _tmp65_;
						_tmp60_ = sig;
						_tmp61_ = vala_member_access_get_inner (_tmp60_);
						_tmp62_ = _tmp61_;
						_tmp63_ = vala_expression_get_value_type (_tmp62_);
						_tmp64_ = _tmp63_;
						_tmp65_ = _vala_code_node_ref0 (_tmp64_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp65_;
					}
				}
				_tmp66_ = ma;
				_tmp67_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp66_);
				_tmp68_ = _tmp67_;
				m = VALA_IS_METHOD (_tmp68_) ? ((ValaMethod*) _tmp68_) : NULL;
				_tmp70_ = m;
				if (_tmp70_ != NULL) {
					ValaMethod* _tmp71_;
					gboolean _tmp72_;
					gboolean _tmp73_;
					_tmp71_ = m;
					_tmp72_ = vala_method_get_coroutine (_tmp71_);
					_tmp73_ = _tmp72_;
					_tmp69_ = _tmp73_;
				} else {
					_tmp69_ = FALSE;
				}
				if (_tmp69_) {
					gboolean _tmp74_ = FALSE;
					ValaMemberAccess* _tmp75_;
					const gchar* _tmp76_;
					const gchar* _tmp77_;
					_tmp75_ = ma;
					_tmp76_ = vala_member_access_get_member_name (_tmp75_);
					_tmp77_ = _tmp76_;
					if (g_strcmp0 (_tmp77_, "begin") == 0) {
						_tmp74_ = TRUE;
					} else {
						ValaMemberAccess* _tmp78_;
						const gchar* _tmp79_;
						const gchar* _tmp80_;
						_tmp78_ = ma;
						_tmp79_ = vala_member_access_get_member_name (_tmp78_);
						_tmp80_ = _tmp79_;
						_tmp74_ = g_strcmp0 (_tmp80_, "end") == 0;
					}
					if (_tmp74_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp81_;
						ValaExpression* _tmp82_;
						ValaExpression* _tmp83_;
						gboolean _tmp84_ = FALSE;
						ValaMemberAccess* _tmp85_;
						_tmp81_ = ma;
						_tmp82_ = vala_member_access_get_inner (_tmp81_);
						_tmp83_ = _tmp82_;
						method_access = VALA_IS_MEMBER_ACCESS (_tmp83_) ? ((ValaMemberAccess*) _tmp83_) : NULL;
						_tmp85_ = method_access;
						if (_tmp85_ != NULL) {
							ValaMemberAccess* _tmp86_;
							ValaExpression* _tmp87_;
							ValaExpression* _tmp88_;
							_tmp86_ = method_access;
							_tmp87_ = vala_member_access_get_inner (_tmp86_);
							_tmp88_ = _tmp87_;
							_tmp84_ = _tmp88_ != NULL;
						} else {
							_tmp84_ = FALSE;
						}
						if (_tmp84_) {
							ValaMemberAccess* _tmp89_;
							ValaExpression* _tmp90_;
							ValaExpression* _tmp91_;
							ValaDataType* _tmp92_;
							ValaDataType* _tmp93_;
							ValaDataType* _tmp94_;
							_tmp89_ = method_access;
							_tmp90_ = vala_member_access_get_inner (_tmp89_);
							_tmp91_ = _tmp90_;
							_tmp92_ = vala_expression_get_value_type (_tmp91_);
							_tmp93_ = _tmp92_;
							_tmp94_ = _vala_code_node_ref0 (_tmp93_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp94_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
					}
				}
			}
			_tmp96_ = ma;
			_tmp97_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp96_);
			_tmp98_ = _tmp97_;
			if (_tmp98_ != NULL) {
				ValaMemberAccess* _tmp99_;
				ValaSymbol* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaAttribute* _tmp102_;
				_tmp99_ = ma;
				_tmp100_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp99_);
				_tmp101_ = _tmp100_;
				_tmp102_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp101_, "Assert");
				_tmp95_ = _tmp102_ != NULL;
			} else {
				_tmp95_ = FALSE;
			}
			if (_tmp95_) {
				ValaList* _tmp103_;
				gint _tmp104_;
				gint _tmp105_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp103_ = self->priv->argument_list;
				_tmp104_ = vala_collection_get_size ((ValaCollection*) _tmp103_);
				_tmp105_ = _tmp104_;
				if (_tmp105_ == 1) {
					ValaList* _tmp106_;
					gpointer _tmp107_;
					ValaExpression* _tmp108_;
					ValaSourceReference* _tmp109_;
					ValaSourceReference* _tmp110_;
					_tmp106_ = self->priv->argument_list;
					_tmp107_ = vala_list_get (_tmp106_, 0);
					_tmp108_ = (ValaExpression*) _tmp107_;
					_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp108_);
					_tmp110_ = _tmp109_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp110_);
					_vala_code_node_unref0 (_tmp108_);
				}
			}
		}
	}
	_tmp111_ = vala_method_call_get_call (self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vala_expression_get_value_type (_tmp112_);
	_tmp114_ = _tmp113_;
	_tmp115_ = _vala_code_node_ref0 (_tmp114_);
	mtype = _tmp115_;
	_tmp117_ = vala_code_context_get_profile (context);
	_tmp118_ = _tmp117_;
	if (_tmp118_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp119_;
		ValaExpression* _tmp120_;
		ValaSymbol* _tmp121_;
		ValaSymbol* _tmp122_;
		ValaSemanticAnalyzer* _tmp123_;
		ValaSemanticAnalyzer* _tmp124_;
		ValaClass* _tmp125_;
		_tmp119_ = vala_method_call_get_call (self);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_expression_get_symbol_reference (_tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_code_context_get_analyzer (context);
		_tmp124_ = _tmp123_;
		_tmp125_ = _tmp124_->object_type;
		_tmp116_ = _tmp122_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp116_ = FALSE;
	}
	gobject_chainup = _tmp116_;
	vala_method_call_set_is_chainup (self, gobject_chainup);
	if (!gobject_chainup) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp126_;
		ValaExpression* _tmp127_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp128_;
		gboolean _tmp129_ = FALSE;
		ValaMemberAccess* _tmp130_;
		gboolean _tmp138_ = FALSE;
		ValaMemberAccess* _tmp139_;
		_tmp126_ = vala_method_call_get_call (self);
		_tmp127_ = _tmp126_;
		expr = _tmp127_;
		_tmp128_ = expr;
		ma = VALA_IS_MEMBER_ACCESS (_tmp128_) ? ((ValaMemberAccess*) _tmp128_) : NULL;
		_tmp130_ = ma;
		if (_tmp130_ != NULL) {
			ValaMemberAccess* _tmp131_;
			ValaSymbol* _tmp132_;
			ValaSymbol* _tmp133_;
			_tmp131_ = ma;
			_tmp132_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp131_);
			_tmp133_ = _tmp132_;
			_tmp129_ = VALA_IS_CREATION_METHOD (_tmp133_);
		} else {
			_tmp129_ = FALSE;
		}
		if (_tmp129_) {
			ValaMemberAccess* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			_tmp134_ = ma;
			_tmp135_ = vala_member_access_get_inner (_tmp134_);
			_tmp136_ = _tmp135_;
			expr = _tmp136_;
			_tmp137_ = expr;
			ma = VALA_IS_MEMBER_ACCESS (_tmp137_) ? ((ValaMemberAccess*) _tmp137_) : NULL;
		}
		_tmp139_ = ma;
		if (_tmp139_ != NULL) {
			ValaMemberAccess* _tmp140_;
			const gchar* _tmp141_;
			const gchar* _tmp142_;
			_tmp140_ = ma;
			_tmp141_ = vala_member_access_get_member_name (_tmp140_);
			_tmp142_ = _tmp141_;
			_tmp138_ = g_strcmp0 (_tmp142_, "this") == 0;
		} else {
			_tmp138_ = FALSE;
		}
		if (_tmp138_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp143_;
			_tmp143_ = expr;
			if (VALA_IS_BASE_ACCESS (_tmp143_)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
	}
	base_cm = NULL;
	_tmp144_ = self->priv->_is_chainup;
	if (_tmp144_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp145_;
		ValaSemanticAnalyzer* _tmp146_;
		ValaMethod* _tmp147_;
		ValaCreationMethod* _tmp148_;
		ValaCreationMethod* _tmp156_;
		ValaDataType* _tmp157_;
		_tmp145_ = vala_code_context_get_analyzer (context);
		_tmp146_ = _tmp145_;
		_tmp147_ = vala_semantic_analyzer_find_current_method (_tmp146_);
		cm = VALA_IS_CREATION_METHOD (_tmp147_) ? ((ValaCreationMethod*) _tmp147_) : NULL;
		_tmp148_ = cm;
		if (_tmp148_ == NULL) {
			ValaSourceReference* _tmp149_;
			ValaSourceReference* _tmp150_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp150_ = _tmp149_;
			vala_report_error (_tmp150_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp151_;
			gboolean _tmp152_;
			gboolean _tmp153_;
			_tmp151_ = cm;
			_tmp152_ = vala_creation_method_get_chain_up (_tmp151_);
			_tmp153_ = _tmp152_;
			if (_tmp153_) {
				ValaSourceReference* _tmp154_;
				ValaSourceReference* _tmp155_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp154_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp155_ = _tmp154_;
				vala_report_error (_tmp155_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp156_ = cm;
		vala_creation_method_set_chain_up (_tmp156_, TRUE);
		_tmp157_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp157_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp158_;
			ValaTypeSymbol* _tmp159_;
			ValaTypeSymbol* _tmp160_;
			ValaClass* _tmp161_;
			ValaCreationMethod* _tmp162_;
			ValaCreationMethod* _tmp163_;
			ValaCreationMethod* _tmp164_;
			_tmp158_ = mtype;
			_tmp159_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp158_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp160_ = _tmp159_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_CLASS, ValaClass);
			_tmp161_ = cl;
			_tmp162_ = vala_class_get_default_construction_method (_tmp161_);
			_tmp163_ = _tmp162_;
			base_cm = _tmp163_;
			_tmp164_ = base_cm;
			if (_tmp164_ == NULL) {
				ValaSourceReference* _tmp165_;
				ValaSourceReference* _tmp166_;
				ValaClass* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp165_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp166_ = _tmp165_;
				_tmp167_ = cl;
				_tmp168_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp167_);
				_tmp169_ = _tmp168_;
				vala_report_error (_tmp166_, "chain up to `%s' not supported", _tmp169_);
				_g_free0 (_tmp169_);
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp170_;
				gboolean _tmp171_;
				gboolean _tmp172_;
				_tmp170_ = base_cm;
				_tmp171_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp170_);
				_tmp172_ = _tmp171_;
				if (!_tmp172_) {
					ValaSourceReference* _tmp173_;
					ValaSourceReference* _tmp174_;
					ValaCreationMethod* _tmp175_;
					gchar* _tmp176_;
					gchar* _tmp177_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp173_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp174_ = _tmp173_;
					_tmp175_ = base_cm;
					_tmp176_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp175_);
					_tmp177_ = _tmp176_;
					vala_report_error (_tmp174_, "chain up to `%s' not supported", _tmp177_);
					_g_free0 (_tmp177_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
		} else {
			gboolean _tmp178_ = FALSE;
			ValaExpression* _tmp179_;
			ValaExpression* _tmp180_;
			ValaSymbol* _tmp181_;
			ValaSymbol* _tmp182_;
			_tmp179_ = vala_method_call_get_call (self);
			_tmp180_ = _tmp179_;
			_tmp181_ = vala_expression_get_symbol_reference (_tmp180_);
			_tmp182_ = _tmp181_;
			if (VALA_IS_CREATION_METHOD (_tmp182_)) {
				ValaExpression* _tmp183_;
				ValaExpression* _tmp184_;
				ValaSymbol* _tmp185_;
				ValaSymbol* _tmp186_;
				ValaSymbol* _tmp187_;
				ValaSymbol* _tmp188_;
				_tmp183_ = vala_method_call_get_call (self);
				_tmp184_ = _tmp183_;
				_tmp185_ = vala_expression_get_symbol_reference (_tmp184_);
				_tmp186_ = _tmp185_;
				_tmp187_ = vala_symbol_get_parent_symbol (_tmp186_);
				_tmp188_ = _tmp187_;
				_tmp178_ = VALA_IS_CLASS (_tmp188_);
			} else {
				_tmp178_ = FALSE;
			}
			if (_tmp178_) {
				ValaExpression* _tmp189_;
				ValaExpression* _tmp190_;
				ValaSymbol* _tmp191_;
				ValaSymbol* _tmp192_;
				ValaCreationMethod* _tmp193_;
				gboolean _tmp194_;
				gboolean _tmp195_;
				_tmp189_ = vala_method_call_get_call (self);
				_tmp190_ = _tmp189_;
				_tmp191_ = vala_expression_get_symbol_reference (_tmp190_);
				_tmp192_ = _tmp191_;
				base_cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp192_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
				_tmp193_ = base_cm;
				_tmp194_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp193_);
				_tmp195_ = _tmp194_;
				if (!_tmp195_) {
					ValaSourceReference* _tmp196_;
					ValaSourceReference* _tmp197_;
					ValaCreationMethod* _tmp198_;
					gchar* _tmp199_;
					gchar* _tmp200_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp196_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp197_ = _tmp196_;
					_tmp198_ = base_cm;
					_tmp199_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp198_);
					_tmp200_ = _tmp199_;
					vala_report_error (_tmp197_, "chain up to `%s' not supported", _tmp200_);
					_g_free0 (_tmp200_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				if (gobject_chainup) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp201_;
					ValaSymbol* _tmp202_;
					ValaSymbol* _tmp203_;
					gboolean _tmp204_ = FALSE;
					ValaClass* _tmp205_;
					ValaExpression* _tmp212_;
					ValaExpression* _tmp213_;
					ValaSemanticAnalyzer* _tmp214_;
					ValaSemanticAnalyzer* _tmp215_;
					ValaClass* _tmp216_;
					ValaObjectType* _tmp217_;
					ValaObjectType* _tmp218_;
					ValaExpression* _tmp219_;
					ValaExpression* _tmp220_;
					ValaDataType* _tmp221_;
					ValaDataType* _tmp222_;
					ValaSourceReference* _tmp223_;
					ValaSourceReference* _tmp224_;
					ValaExpression* _tmp225_;
					ValaExpression* _tmp226_;
					ValaDataType* _tmp227_;
					ValaDataType* _tmp228_;
					ValaDataType* _tmp229_;
					_tmp201_ = cm;
					_tmp202_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp201_);
					_tmp203_ = _tmp202_;
					cl = VALA_IS_CLASS (_tmp203_) ? ((ValaClass*) _tmp203_) : NULL;
					_tmp205_ = cl;
					if (_tmp205_ == NULL) {
						_tmp204_ = TRUE;
					} else {
						ValaClass* _tmp206_;
						ValaSemanticAnalyzer* _tmp207_;
						ValaSemanticAnalyzer* _tmp208_;
						ValaClass* _tmp209_;
						_tmp206_ = cl;
						_tmp207_ = vala_code_context_get_analyzer (context);
						_tmp208_ = _tmp207_;
						_tmp209_ = _tmp208_->object_type;
						_tmp204_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp206_, (ValaTypeSymbol*) _tmp209_);
					}
					if (_tmp204_) {
						ValaSourceReference* _tmp210_;
						ValaSourceReference* _tmp211_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp210_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp211_ = _tmp210_;
						vala_report_error (_tmp211_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp212_ = vala_method_call_get_call (self);
					_tmp213_ = _tmp212_;
					_tmp214_ = vala_code_context_get_analyzer (context);
					_tmp215_ = _tmp214_;
					_tmp216_ = _tmp215_->object_type;
					_tmp217_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp216_);
					_tmp218_ = _tmp217_;
					vala_expression_set_value_type (_tmp213_, (ValaDataType*) _tmp218_);
					_vala_code_node_unref0 (_tmp218_);
					_tmp219_ = vala_method_call_get_call (self);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_expression_get_value_type (_tmp220_);
					_tmp222_ = _tmp221_;
					_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp224_ = _tmp223_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp222_, _tmp224_);
					_tmp225_ = vala_method_call_get_call (self);
					_tmp226_ = _tmp225_;
					_tmp227_ = vala_expression_get_value_type (_tmp226_);
					_tmp228_ = _tmp227_;
					_tmp229_ = _vala_code_node_ref0 (_tmp228_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp229_;
				}
			}
		}
	}
	_tmp231_ = vala_method_call_get_call (self);
	_tmp232_ = _tmp231_;
	if (VALA_IS_MEMBER_ACCESS (_tmp232_)) {
		gboolean _tmp233_ = FALSE;
		gboolean _tmp234_ = FALSE;
		ValaExpression* _tmp235_;
		ValaExpression* _tmp236_;
		ValaSymbol* _tmp237_;
		ValaSymbol* _tmp238_;
		_tmp235_ = vala_method_call_get_call (self);
		_tmp236_ = _tmp235_;
		_tmp237_ = vala_expression_get_symbol_reference (_tmp236_);
		_tmp238_ = _tmp237_;
		if (VALA_IS_CREATION_METHOD (_tmp238_)) {
			ValaExpression* _tmp239_;
			ValaExpression* _tmp240_;
			ValaSymbol* _tmp241_;
			ValaSymbol* _tmp242_;
			ValaSymbol* _tmp243_;
			ValaSymbol* _tmp244_;
			_tmp239_ = vala_method_call_get_call (self);
			_tmp240_ = _tmp239_;
			_tmp241_ = vala_expression_get_symbol_reference (_tmp240_);
			_tmp242_ = _tmp241_;
			_tmp243_ = vala_symbol_get_parent_symbol (_tmp242_);
			_tmp244_ = _tmp243_;
			_tmp234_ = VALA_IS_STRUCT (_tmp244_);
		} else {
			_tmp234_ = FALSE;
		}
		if (_tmp234_) {
			_tmp233_ = TRUE;
		} else {
			ValaExpression* _tmp245_;
			ValaExpression* _tmp246_;
			ValaSymbol* _tmp247_;
			ValaSymbol* _tmp248_;
			_tmp245_ = vala_method_call_get_call (self);
			_tmp246_ = _tmp245_;
			_tmp247_ = vala_expression_get_symbol_reference (_tmp246_);
			_tmp248_ = _tmp247_;
			_tmp233_ = VALA_IS_STRUCT (_tmp248_);
		}
		_tmp230_ = _tmp233_;
	} else {
		_tmp230_ = FALSE;
	}
	if (_tmp230_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp249_;
		ValaExpression* _tmp250_;
		ValaSymbol* _tmp251_;
		ValaSymbol* _tmp252_;
		gboolean _tmp253_ = FALSE;
		gboolean _tmp254_ = FALSE;
		ValaStruct* _tmp255_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp266_;
		ValaExpression* _tmp267_;
		ValaSourceReference* _tmp268_;
		ValaSourceReference* _tmp269_;
		ValaObjectCreationExpression* _tmp270_;
		ValaObjectCreationExpression* _tmp271_;
		ValaObjectCreationExpression* _tmp272_;
		gboolean _tmp273_;
		ValaObjectCreationExpression* _tmp284_;
		ValaDataType* _tmp285_;
		ValaDataType* _tmp286_;
		ValaSemanticAnalyzer* _tmp287_;
		ValaSemanticAnalyzer* _tmp288_;
		ValaList* _tmp289_;
		ValaCodeNode* _tmp290_;
		ValaCodeNode* _tmp291_;
		ValaObjectCreationExpression* _tmp292_;
		ValaObjectCreationExpression* _tmp293_;
		_tmp249_ = vala_method_call_get_call (self);
		_tmp250_ = _tmp249_;
		_tmp251_ = vala_expression_get_symbol_reference (_tmp250_);
		_tmp252_ = _tmp251_;
		st = VALA_IS_STRUCT (_tmp252_) ? ((ValaStruct*) _tmp252_) : NULL;
		_tmp255_ = st;
		if (_tmp255_ != NULL) {
			ValaStruct* _tmp256_;
			ValaCreationMethod* _tmp257_;
			ValaCreationMethod* _tmp258_;
			_tmp256_ = st;
			_tmp257_ = vala_struct_get_default_construction_method (_tmp256_);
			_tmp258_ = _tmp257_;
			_tmp254_ = _tmp258_ == NULL;
		} else {
			_tmp254_ = FALSE;
		}
		if (_tmp254_) {
			gboolean _tmp259_ = FALSE;
			gboolean _tmp260_ = FALSE;
			ValaStruct* _tmp261_;
			_tmp261_ = st;
			if (vala_struct_is_boolean_type (_tmp261_)) {
				_tmp260_ = TRUE;
			} else {
				ValaStruct* _tmp262_;
				_tmp262_ = st;
				_tmp260_ = vala_struct_is_integer_type (_tmp262_);
			}
			if (_tmp260_) {
				_tmp259_ = TRUE;
			} else {
				ValaStruct* _tmp263_;
				_tmp263_ = st;
				_tmp259_ = vala_struct_is_floating_type (_tmp263_);
			}
			_tmp253_ = _tmp259_;
		} else {
			_tmp253_ = FALSE;
		}
		if (_tmp253_) {
			ValaSourceReference* _tmp264_;
			ValaSourceReference* _tmp265_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp265_ = _tmp264_;
			vala_report_error (_tmp265_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp266_ = vala_method_call_get_call (self);
		_tmp267_ = _tmp266_;
		_tmp268_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp269_ = _tmp268_;
		_tmp270_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp267_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp269_);
		struct_creation_expression = _tmp270_;
		_tmp271_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp271_, TRUE);
		_tmp272_ = struct_creation_expression;
		_tmp273_ = self->priv->_is_chainup;
		vala_object_creation_expression_set_is_chainup (_tmp272_, _tmp273_);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp274_;
			gint _arg_size = 0;
			ValaList* _tmp275_;
			gint _tmp276_;
			gint _tmp277_;
			gint _arg_index = 0;
			_tmp274_ = self->priv->argument_list;
			_arg_list = _tmp274_;
			_tmp275_ = _arg_list;
			_tmp276_ = vala_collection_get_size ((ValaCollection*) _tmp275_);
			_tmp277_ = _tmp276_;
			_arg_size = _tmp277_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp278_;
				gint _tmp279_;
				ValaExpression* arg = NULL;
				ValaList* _tmp280_;
				gpointer _tmp281_;
				ValaObjectCreationExpression* _tmp282_;
				ValaExpression* _tmp283_;
				_arg_index = _arg_index + 1;
				_tmp278_ = _arg_index;
				_tmp279_ = _arg_size;
				if (!(_tmp278_ < _tmp279_)) {
					break;
				}
				_tmp280_ = _arg_list;
				_tmp281_ = vala_list_get (_tmp280_, _arg_index);
				arg = (ValaExpression*) _tmp281_;
				_tmp282_ = struct_creation_expression;
				_tmp283_ = arg;
				vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp282_, _tmp283_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp284_ = struct_creation_expression;
		_tmp285_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp286_ = _tmp285_;
		vala_expression_set_target_type ((ValaExpression*) _tmp284_, _tmp286_);
		_tmp287_ = vala_code_context_get_analyzer (context);
		_tmp288_ = _tmp287_;
		_tmp289_ = _tmp288_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp289_, (ValaCodeNode*) self);
		_tmp290_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp291_ = _tmp290_;
		_tmp292_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp291_, (ValaExpression*) self, (ValaExpression*) _tmp292_);
		_tmp293_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp293_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp294_ = FALSE;
		gboolean _tmp295_ = FALSE;
		gboolean _tmp296_;
		_tmp296_ = self->priv->_is_chainup;
		if (!_tmp296_) {
			ValaExpression* _tmp297_;
			ValaExpression* _tmp298_;
			_tmp297_ = vala_method_call_get_call (self);
			_tmp298_ = _tmp297_;
			_tmp295_ = VALA_IS_MEMBER_ACCESS (_tmp298_);
		} else {
			_tmp295_ = FALSE;
		}
		if (_tmp295_) {
			ValaExpression* _tmp299_;
			ValaExpression* _tmp300_;
			ValaSymbol* _tmp301_;
			ValaSymbol* _tmp302_;
			_tmp299_ = vala_method_call_get_call (self);
			_tmp300_ = _tmp299_;
			_tmp301_ = vala_expression_get_symbol_reference (_tmp300_);
			_tmp302_ = _tmp301_;
			_tmp294_ = VALA_IS_CREATION_METHOD (_tmp302_);
		} else {
			_tmp294_ = FALSE;
		}
		if (_tmp294_) {
			ValaSourceReference* _tmp303_;
			ValaSourceReference* _tmp304_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp303_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp304_ = _tmp303_;
			vala_report_error (_tmp304_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp306_ = self->priv->_is_chainup;
	if (!_tmp306_) {
		ValaDataType* _tmp307_;
		_tmp307_ = mtype;
		_tmp305_ = VALA_IS_OBJECT_TYPE (_tmp307_);
	} else {
		_tmp305_ = FALSE;
	}
	if (_tmp305_) {
		ValaSourceReference* _tmp308_;
		ValaSourceReference* _tmp309_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp308_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp309_ = _tmp308_;
		vala_report_error (_tmp309_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp310_ = FALSE;
		ValaDataType* _tmp311_;
		_tmp311_ = mtype;
		if (_tmp311_ != NULL) {
			ValaDataType* _tmp312_;
			_tmp312_ = mtype;
			_tmp310_ = vala_data_type_is_invokable (_tmp312_);
		} else {
			_tmp310_ = FALSE;
		}
		if (_tmp310_) {
		} else {
			ValaExpression* _tmp313_;
			ValaExpression* _tmp314_;
			ValaSymbol* _tmp315_;
			ValaSymbol* _tmp316_;
			_tmp313_ = vala_method_call_get_call (self);
			_tmp314_ = _tmp313_;
			_tmp315_ = vala_expression_get_symbol_reference (_tmp314_);
			_tmp316_ = _tmp315_;
			if (VALA_IS_CLASS (_tmp316_)) {
				ValaSourceReference* _tmp317_;
				ValaSourceReference* _tmp318_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp317_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp318_ = _tmp317_;
				vala_report_error (_tmp318_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp319_;
				ValaSourceReference* _tmp320_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp319_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp320_ = _tmp319_;
				vala_report_error (_tmp320_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp321_ = mtype;
	_tmp322_ = vala_data_type_get_return_type (_tmp321_);
	_tmp323_ = _vala_code_node_ref0 (_tmp322_);
	ret_type = _tmp323_;
	_tmp324_ = mtype;
	_tmp325_ = vala_data_type_get_parameters (_tmp324_);
	_tmp326_ = _vala_iterable_ref0 (_tmp325_);
	params = _tmp326_;
	_tmp327_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp327_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp328_;
		ValaExpression* _tmp329_;
		ValaMethod* m = NULL;
		ValaDataType* _tmp330_;
		ValaMethod* _tmp331_;
		ValaMethod* _tmp332_;
		ValaMethod* _tmp333_;
		gboolean _tmp334_;
		gboolean _tmp335_;
		gint n_type_params = 0;
		ValaMethod* _tmp367_;
		ValaList* _tmp368_;
		gint _tmp369_;
		gint _tmp370_;
		gint n_type_args = 0;
		ValaMemberAccess* _tmp371_;
		ValaList* _tmp372_;
		gint _tmp373_;
		gint _tmp374_;
		gboolean _tmp375_ = FALSE;
		_tmp328_ = vala_method_call_get_call (self);
		_tmp329_ = _tmp328_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp329_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp330_ = mtype;
		_tmp331_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp330_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp332_ = _tmp331_;
		m = _tmp332_;
		_tmp333_ = m;
		_tmp334_ = vala_method_get_coroutine (_tmp333_);
		_tmp335_ = _tmp334_;
		if (_tmp335_) {
			gboolean _tmp336_;
			gboolean _tmp337_;
			_tmp336_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp337_ = _tmp336_;
			if (!_tmp337_) {
				ValaMemberAccess* _tmp338_;
				const gchar* _tmp339_;
				const gchar* _tmp340_;
				_tmp338_ = ma;
				_tmp339_ = vala_member_access_get_member_name (_tmp338_);
				_tmp340_ = _tmp339_;
				if (g_strcmp0 (_tmp340_, "end") != 0) {
					ValaMemberAccess* _tmp341_;
					const gchar* _tmp342_;
					const gchar* _tmp343_;
					ValaMethod* _tmp347_;
					ValaList* _tmp348_;
					ValaList* _tmp349_;
					ValaVoidType* _tmp350_;
					_tmp341_ = ma;
					_tmp342_ = vala_member_access_get_member_name (_tmp341_);
					_tmp343_ = _tmp342_;
					if (g_strcmp0 (_tmp343_, "begin") != 0) {
						ValaMemberAccess* _tmp344_;
						ValaSourceReference* _tmp345_;
						ValaSourceReference* _tmp346_;
						_tmp344_ = ma;
						_tmp345_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp344_);
						_tmp346_ = _tmp345_;
						vala_report_deprecated (_tmp346_, "implicit .begin is deprecated");
					}
					_tmp347_ = m;
					_tmp348_ = vala_method_get_async_begin_parameters (_tmp347_);
					_tmp349_ = _vala_iterable_ref0 (_tmp348_);
					_vala_iterable_unref0 (params);
					params = _tmp349_;
					_tmp350_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp350_;
				} else {
					ValaMethod* _tmp351_;
					ValaList* _tmp352_;
					ValaList* _tmp353_;
					_tmp351_ = m;
					_tmp352_ = vala_method_get_async_end_parameters (_tmp351_);
					_tmp353_ = _vala_iterable_ref0 (_tmp352_);
					_vala_iterable_unref0 (params);
					params = _tmp353_;
				}
			} else {
				gboolean _tmp354_ = FALSE;
				ValaMemberAccess* _tmp355_;
				const gchar* _tmp356_;
				const gchar* _tmp357_;
				_tmp355_ = ma;
				_tmp356_ = vala_member_access_get_member_name (_tmp355_);
				_tmp357_ = _tmp356_;
				if (g_strcmp0 (_tmp357_, "begin") == 0) {
					_tmp354_ = TRUE;
				} else {
					ValaMemberAccess* _tmp358_;
					const gchar* _tmp359_;
					const gchar* _tmp360_;
					_tmp358_ = ma;
					_tmp359_ = vala_member_access_get_member_name (_tmp358_);
					_tmp360_ = _tmp359_;
					_tmp354_ = g_strcmp0 (_tmp360_, "end") == 0;
				}
				if (_tmp354_) {
					ValaMemberAccess* _tmp361_;
					ValaSourceReference* _tmp362_;
					ValaSourceReference* _tmp363_;
					ValaMemberAccess* _tmp364_;
					const gchar* _tmp365_;
					const gchar* _tmp366_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp361_ = ma;
					_tmp362_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp361_);
					_tmp363_ = _tmp362_;
					_tmp364_ = ma;
					_tmp365_ = vala_member_access_get_member_name (_tmp364_);
					_tmp366_ = _tmp365_;
					vala_report_error (_tmp363_, "use of `%s' not allowed in yield statement", _tmp366_);
				}
			}
		}
		_tmp367_ = m;
		_tmp368_ = vala_method_get_type_parameters (_tmp367_);
		_tmp369_ = vala_collection_get_size ((ValaCollection*) _tmp368_);
		_tmp370_ = _tmp369_;
		n_type_params = _tmp370_;
		_tmp371_ = ma;
		_tmp372_ = vala_member_access_get_type_arguments (_tmp371_);
		_tmp373_ = vala_collection_get_size ((ValaCollection*) _tmp372_);
		_tmp374_ = _tmp373_;
		n_type_args = _tmp374_;
		if (n_type_args > 0) {
			_tmp375_ = n_type_args < n_type_params;
		} else {
			_tmp375_ = FALSE;
		}
		if (_tmp375_) {
			ValaMemberAccess* _tmp376_;
			ValaSourceReference* _tmp377_;
			ValaSourceReference* _tmp378_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp376_ = ma;
			_tmp377_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp376_);
			_tmp378_ = _tmp377_;
			vala_report_error (_tmp378_, "too few type arguments");
			result = FALSE;
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			gboolean _tmp379_ = FALSE;
			if (n_type_args > 0) {
				_tmp379_ = n_type_args > n_type_params;
			} else {
				_tmp379_ = FALSE;
			}
			if (_tmp379_) {
				ValaMemberAccess* _tmp380_;
				ValaSourceReference* _tmp381_;
				ValaSourceReference* _tmp382_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp380_ = ma;
				_tmp381_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp380_);
				_tmp382_ = _tmp381_;
				vala_report_error (_tmp382_, "too many type arguments");
				result = FALSE;
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	last_arg = NULL;
	_tmp383_ = self->priv->argument_list;
	_tmp384_ = vala_iterable_iterator ((ValaIterable*) _tmp383_);
	arg_it = _tmp384_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp385_;
		gint _param_size = 0;
		ValaList* _tmp386_;
		gint _tmp387_;
		gint _tmp388_;
		gint _param_index = 0;
		_tmp385_ = params;
		_param_list = _tmp385_;
		_tmp386_ = _param_list;
		_tmp387_ = vala_collection_get_size ((ValaCollection*) _tmp386_);
		_tmp388_ = _tmp387_;
		_param_size = _tmp388_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp389_;
			gint _tmp390_;
			ValaParameter* param = NULL;
			ValaList* _tmp391_;
			gpointer _tmp392_;
			ValaParameter* _tmp393_;
			ValaParameter* _tmp394_;
			gboolean _tmp395_;
			gboolean _tmp396_;
			ValaParameter* _tmp397_;
			gboolean _tmp398_;
			gboolean _tmp399_;
			ValaIterator* _tmp417_;
			_param_index = _param_index + 1;
			_tmp389_ = _param_index;
			_tmp390_ = _param_size;
			if (!(_tmp389_ < _tmp390_)) {
				break;
			}
			_tmp391_ = _param_list;
			_tmp392_ = vala_list_get (_tmp391_, _param_index);
			param = (ValaParameter*) _tmp392_;
			_tmp393_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp393_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp394_ = param;
			_tmp395_ = vala_parameter_get_ellipsis (_tmp394_);
			_tmp396_ = _tmp395_;
			if (_tmp396_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp397_ = param;
			_tmp398_ = vala_parameter_get_params_array (_tmp397_);
			_tmp399_ = _tmp398_;
			if (_tmp399_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp400_;
				ValaDataType* _tmp401_;
				ValaDataType* _tmp402_;
				ValaArrayType* _tmp403_;
				_tmp400_ = param;
				_tmp401_ = vala_variable_get_variable_type ((ValaVariable*) _tmp400_);
				_tmp402_ = _tmp401_;
				_tmp403_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp402_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp403_;
				while (TRUE) {
					ValaIterator* _tmp404_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp405_;
					gpointer _tmp406_;
					ValaExpression* _tmp407_;
					ValaArrayType* _tmp408_;
					ValaDataType* _tmp409_;
					ValaDataType* _tmp410_;
					ValaExpression* _tmp411_;
					ValaDataType* _tmp412_;
					ValaDataType* _tmp413_;
					ValaArrayType* _tmp414_;
					gboolean _tmp415_;
					gboolean _tmp416_;
					_tmp404_ = arg_it;
					if (!vala_iterator_next (_tmp404_)) {
						break;
					}
					_tmp405_ = arg_it;
					_tmp406_ = vala_iterator_get (_tmp405_);
					arg = (ValaExpression*) _tmp406_;
					_tmp407_ = arg;
					_tmp408_ = array_type;
					_tmp409_ = vala_array_type_get_element_type (_tmp408_);
					_tmp410_ = _tmp409_;
					vala_expression_set_target_type (_tmp407_, _tmp410_);
					_tmp411_ = arg;
					_tmp412_ = vala_expression_get_target_type (_tmp411_);
					_tmp413_ = _tmp412_;
					_tmp414_ = array_type;
					_tmp415_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp414_);
					_tmp416_ = _tmp415_;
					vala_data_type_set_value_owned (_tmp413_, _tmp416_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp417_ = arg_it;
			if (vala_iterator_next (_tmp417_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp418_;
				gpointer _tmp419_;
				ValaExpression* _tmp420_;
				ValaParameter* _tmp421_;
				ValaDataType* _tmp422_;
				ValaDataType* _tmp423_;
				ValaExpression* _tmp424_;
				ValaExpression* _tmp425_;
				ValaDataType* _tmp426_;
				ValaDataType* _tmp427_;
				ValaDataType* _tmp428_;
				ValaList* _tmp429_;
				ValaDataType* _tmp430_;
				ValaDataType* _tmp431_;
				ValaExpression* _tmp432_;
				ValaExpression* _tmp433_;
				_tmp418_ = arg_it;
				_tmp419_ = vala_iterator_get (_tmp418_);
				arg = (ValaExpression*) _tmp419_;
				_tmp420_ = arg;
				_tmp421_ = param;
				_tmp422_ = vala_variable_get_variable_type ((ValaVariable*) _tmp421_);
				_tmp423_ = _tmp422_;
				vala_expression_set_formal_target_type (_tmp420_, _tmp423_);
				_tmp424_ = arg;
				_tmp425_ = arg;
				_tmp426_ = vala_expression_get_formal_target_type (_tmp425_);
				_tmp427_ = _tmp426_;
				_tmp428_ = target_object_type;
				_tmp429_ = method_type_args;
				_tmp430_ = vala_data_type_get_actual_type (_tmp427_, _tmp428_, _tmp429_, (ValaCodeNode*) self);
				_tmp431_ = _tmp430_;
				vala_expression_set_target_type (_tmp424_, _tmp431_);
				_vala_code_node_unref0 (_tmp431_);
				_tmp432_ = arg;
				_tmp433_ = _vala_code_node_ref0 (_tmp432_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp433_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp435_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp435_)) {
		ValaDataType* _tmp436_;
		ValaMethod* _tmp437_;
		ValaMethod* _tmp438_;
		ValaAttribute* _tmp439_;
		_tmp436_ = mtype;
		_tmp437_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp436_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp438_ = _tmp437_;
		_tmp439_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp438_, "Print");
		_tmp434_ = _tmp439_ != NULL;
	} else {
		_tmp434_ = FALSE;
	}
	if (_tmp434_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp440_;
		ValaSourceReference* _tmp441_;
		ValaTemplate* _tmp442_;
		ValaList* _tmp454_;
		ValaTemplate* _tmp455_;
		_tmp440_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp441_ = _tmp440_;
		_tmp442_ = vala_template_new (_tmp441_);
		template = _tmp442_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp443_;
			gint _arg_size = 0;
			ValaList* _tmp444_;
			gint _tmp445_;
			gint _tmp446_;
			gint _arg_index = 0;
			_tmp443_ = self->priv->argument_list;
			_arg_list = _tmp443_;
			_tmp444_ = _arg_list;
			_tmp445_ = vala_collection_get_size ((ValaCollection*) _tmp444_);
			_tmp446_ = _tmp445_;
			_arg_size = _tmp446_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp447_;
				gint _tmp448_;
				ValaExpression* arg = NULL;
				ValaList* _tmp449_;
				gpointer _tmp450_;
				ValaExpression* _tmp451_;
				ValaTemplate* _tmp452_;
				ValaExpression* _tmp453_;
				_arg_index = _arg_index + 1;
				_tmp447_ = _arg_index;
				_tmp448_ = _arg_size;
				if (!(_tmp447_ < _tmp448_)) {
					break;
				}
				_tmp449_ = _arg_list;
				_tmp450_ = vala_list_get (_tmp449_, _arg_index);
				arg = (ValaExpression*) _tmp450_;
				_tmp451_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp451_, NULL);
				_tmp452_ = template;
				_tmp453_ = arg;
				vala_template_add_expression (_tmp452_, _tmp453_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp454_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp454_);
		_tmp455_ = template;
		vala_callable_expression_add_argument ((ValaCallableExpression*) self, (ValaExpression*) _tmp455_);
		_vala_code_node_unref0 (template);
	}
	_tmp457_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp457_)) {
		ValaDataType* _tmp458_;
		ValaMethod* _tmp459_;
		ValaMethod* _tmp460_;
		gboolean _tmp461_;
		gboolean _tmp462_;
		_tmp458_ = mtype;
		_tmp459_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp458_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp460_ = _tmp459_;
		_tmp461_ = vala_method_get_printf_format (_tmp460_);
		_tmp462_ = _tmp461_;
		_tmp456_ = _tmp462_;
	} else {
		_tmp456_ = FALSE;
	}
	if (_tmp456_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp463_;
		ValaStringLiteral* _tmp512_;
		format_literal = NULL;
		_tmp463_ = last_arg;
		if (VALA_IS_NULL_LITERAL (_tmp463_)) {
		} else {
			ValaExpression* _tmp464_;
			_tmp464_ = last_arg;
			if (_tmp464_ != NULL) {
				ValaExpression* _tmp465_;
				ValaStringLiteral* _tmp466_;
				gboolean _tmp467_ = FALSE;
				ValaStringLiteral* _tmp468_;
				_tmp465_ = last_arg;
				_tmp466_ = vala_string_literal_get_format_literal (_tmp465_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp466_;
				_tmp468_ = format_literal;
				if (_tmp468_ == NULL) {
					ValaList* _tmp469_;
					gint _tmp470_;
					gint _tmp471_;
					ValaList* _tmp472_;
					gint _tmp473_;
					gint _tmp474_;
					_tmp469_ = self->priv->argument_list;
					_tmp470_ = vala_collection_get_size ((ValaCollection*) _tmp469_);
					_tmp471_ = _tmp470_;
					_tmp472_ = params;
					_tmp473_ = vala_collection_get_size ((ValaCollection*) _tmp472_);
					_tmp474_ = _tmp473_;
					_tmp467_ = _tmp471_ == (_tmp474_ - 1);
				} else {
					_tmp467_ = FALSE;
				}
				if (_tmp467_) {
					ValaStringLiteral* _tmp475_;
					ValaStringLiteral* _tmp476_;
					ValaSemanticAnalyzer* _tmp477_;
					ValaSemanticAnalyzer* _tmp478_;
					ValaDataType* _tmp479_;
					ValaDataType* _tmp480_;
					ValaDataType* _tmp481_;
					ValaList* _tmp482_;
					ValaList* _tmp483_;
					gint _tmp484_;
					gint _tmp485_;
					ValaStringLiteral* _tmp486_;
					ValaList* _tmp487_;
					ValaIterator* _tmp488_;
					_tmp475_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp475_;
					_tmp476_ = format_literal;
					_tmp477_ = vala_code_context_get_analyzer (context);
					_tmp478_ = _tmp477_;
					_tmp479_ = _tmp478_->string_type;
					_tmp480_ = vala_data_type_copy (_tmp479_);
					_tmp481_ = _tmp480_;
					vala_expression_set_target_type ((ValaExpression*) _tmp476_, _tmp481_);
					_vala_code_node_unref0 (_tmp481_);
					_tmp482_ = self->priv->argument_list;
					_tmp483_ = self->priv->argument_list;
					_tmp484_ = vala_collection_get_size ((ValaCollection*) _tmp483_);
					_tmp485_ = _tmp484_;
					_tmp486_ = format_literal;
					vala_list_insert (_tmp482_, _tmp485_ - 1, (ValaExpression*) _tmp486_);
					_tmp487_ = self->priv->argument_list;
					_tmp488_ = vala_iterable_iterator ((ValaIterable*) _tmp487_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp488_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp489_;
						gint _param_size = 0;
						ValaList* _tmp490_;
						gint _tmp491_;
						gint _tmp492_;
						gint _param_index = 0;
						_tmp489_ = params;
						_param_list = _tmp489_;
						_tmp490_ = _param_list;
						_tmp491_ = vala_collection_get_size ((ValaCollection*) _tmp490_);
						_tmp492_ = _tmp491_;
						_param_size = _tmp492_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp493_;
							gint _tmp494_;
							ValaParameter* param = NULL;
							ValaList* _tmp495_;
							gpointer _tmp496_;
							gboolean _tmp497_ = FALSE;
							ValaParameter* _tmp498_;
							gboolean _tmp499_;
							gboolean _tmp500_;
							ValaIterator* _tmp504_;
							_param_index = _param_index + 1;
							_tmp493_ = _param_index;
							_tmp494_ = _param_size;
							if (!(_tmp493_ < _tmp494_)) {
								break;
							}
							_tmp495_ = _param_list;
							_tmp496_ = vala_list_get (_tmp495_, _param_index);
							param = (ValaParameter*) _tmp496_;
							_tmp498_ = param;
							_tmp499_ = vala_parameter_get_ellipsis (_tmp498_);
							_tmp500_ = _tmp499_;
							if (_tmp500_) {
								_tmp497_ = TRUE;
							} else {
								ValaParameter* _tmp501_;
								gboolean _tmp502_;
								gboolean _tmp503_;
								_tmp501_ = param;
								_tmp502_ = vala_parameter_get_params_array (_tmp501_);
								_tmp503_ = _tmp502_;
								_tmp497_ = _tmp503_;
							}
							if (_tmp497_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp504_ = arg_it;
							vala_iterator_next (_tmp504_);
							_vala_code_node_unref0 (param);
						}
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp505_;
				ValaExpression* _tmp506_;
				ValaMemberAccess* _tmp507_;
				_tmp505_ = vala_method_call_get_call (self);
				_tmp506_ = _tmp505_;
				ma = VALA_IS_MEMBER_ACCESS (_tmp506_) ? ((ValaMemberAccess*) _tmp506_) : NULL;
				_tmp507_ = ma;
				if (_tmp507_ != NULL) {
					ValaMemberAccess* _tmp508_;
					ValaExpression* _tmp509_;
					ValaExpression* _tmp510_;
					ValaStringLiteral* _tmp511_;
					_tmp508_ = ma;
					_tmp509_ = vala_member_access_get_inner (_tmp508_);
					_tmp510_ = _tmp509_;
					_tmp511_ = vala_string_literal_get_format_literal (_tmp510_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp511_;
				}
			}
		}
		_tmp512_ = format_literal;
		if (_tmp512_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp513_;
			gchar* _tmp514_;
			ValaSemanticAnalyzer* _tmp515_;
			ValaSemanticAnalyzer* _tmp516_;
			const gchar* _tmp517_;
			ValaIterator* _tmp518_;
			ValaSourceReference* _tmp519_;
			ValaSourceReference* _tmp520_;
			_tmp513_ = format_literal;
			_tmp514_ = vala_string_literal_eval (_tmp513_);
			format = _tmp514_;
			_tmp515_ = vala_code_context_get_analyzer (context);
			_tmp516_ = _tmp515_;
			_tmp517_ = format;
			_tmp518_ = arg_it;
			_tmp519_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp520_ = _tmp519_;
			if (!vala_semantic_analyzer_check_print_format (_tmp516_, _tmp517_, _tmp518_, _tmp520_)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	force_lambda_method_closure = FALSE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp521_;
		gint _arg_size = 0;
		ValaList* _tmp522_;
		gint _tmp523_;
		gint _tmp524_;
		gint _arg_index = 0;
		_tmp521_ = self->priv->argument_list;
		_arg_list = _tmp521_;
		_tmp522_ = _arg_list;
		_tmp523_ = vala_collection_get_size ((ValaCollection*) _tmp522_);
		_tmp524_ = _tmp523_;
		_arg_size = _tmp524_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp525_;
			gint _tmp526_;
			ValaExpression* arg = NULL;
			ValaList* _tmp527_;
			gpointer _tmp528_;
			ValaExpression* _tmp529_;
			gboolean _tmp530_ = FALSE;
			ValaExpression* _tmp531_;
			_arg_index = _arg_index + 1;
			_tmp525_ = _arg_index;
			_tmp526_ = _arg_size;
			if (!(_tmp525_ < _tmp526_)) {
				break;
			}
			_tmp527_ = _arg_list;
			_tmp528_ = vala_list_get (_tmp527_, _arg_index);
			arg = (ValaExpression*) _tmp528_;
			_tmp529_ = arg;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp529_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp531_ = arg;
			if (VALA_IS_LAMBDA_EXPRESSION (_tmp531_)) {
				ValaExpression* _tmp532_;
				ValaMethod* _tmp533_;
				ValaMethod* _tmp534_;
				gboolean _tmp535_;
				gboolean _tmp536_;
				_tmp532_ = arg;
				_tmp533_ = vala_lambda_expression_get_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp532_, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression));
				_tmp534_ = _tmp533_;
				_tmp535_ = vala_method_get_closure (_tmp534_);
				_tmp536_ = _tmp535_;
				_tmp530_ = _tmp536_;
			} else {
				_tmp530_ = FALSE;
			}
			if (_tmp530_) {
				force_lambda_method_closure = TRUE;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp538_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp539_ = _tmp538_;
	if (!_tmp539_) {
		_tmp537_ = force_lambda_method_closure;
	} else {
		_tmp537_ = FALSE;
	}
	if (_tmp537_) {
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp540_;
			gint _arg_size = 0;
			ValaList* _tmp541_;
			gint _tmp542_;
			gint _tmp543_;
			gint _arg_index = 0;
			_tmp540_ = self->priv->argument_list;
			_arg_list = _tmp540_;
			_tmp541_ = _arg_list;
			_tmp542_ = vala_collection_get_size ((ValaCollection*) _tmp541_);
			_tmp543_ = _tmp542_;
			_arg_size = _tmp543_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp544_;
				gint _tmp545_;
				ValaExpression* arg = NULL;
				ValaList* _tmp546_;
				gpointer _tmp547_;
				ValaLambdaExpression* lambda = NULL;
				ValaExpression* _tmp548_;
				gboolean _tmp549_ = FALSE;
				ValaLambdaExpression* _tmp550_;
				_arg_index = _arg_index + 1;
				_tmp544_ = _arg_index;
				_tmp545_ = _arg_size;
				if (!(_tmp544_ < _tmp545_)) {
					break;
				}
				_tmp546_ = _arg_list;
				_tmp547_ = vala_list_get (_tmp546_, _arg_index);
				arg = (ValaExpression*) _tmp547_;
				_tmp548_ = arg;
				lambda = VALA_IS_LAMBDA_EXPRESSION (_tmp548_) ? ((ValaLambdaExpression*) _tmp548_) : NULL;
				_tmp550_ = lambda;
				if (_tmp550_ != NULL) {
					ValaLambdaExpression* _tmp551_;
					ValaMethod* _tmp552_;
					ValaMethod* _tmp553_;
					ValaMemberBinding _tmp554_;
					ValaMemberBinding _tmp555_;
					_tmp551_ = lambda;
					_tmp552_ = vala_lambda_expression_get_method (_tmp551_);
					_tmp553_ = _tmp552_;
					_tmp554_ = vala_method_get_binding (_tmp553_);
					_tmp555_ = _tmp554_;
					_tmp549_ = _tmp555_ != VALA_MEMBER_BINDING_STATIC;
				} else {
					_tmp549_ = FALSE;
				}
				if (_tmp549_) {
					ValaLambdaExpression* _tmp556_;
					ValaMethod* _tmp557_;
					ValaMethod* _tmp558_;
					_tmp556_ = lambda;
					_tmp557_ = vala_lambda_expression_get_method (_tmp556_);
					_tmp558_ = _tmp557_;
					vala_method_set_closure (_tmp558_, TRUE);
				}
				_vala_code_node_unref0 (arg);
			}
		}
	}
	_tmp559_ = ret_type;
	if (VALA_IS_VOID_TYPE (_tmp559_)) {
		gboolean _tmp560_ = FALSE;
		gboolean _tmp561_ = FALSE;
		ValaCodeNode* _tmp562_;
		ValaCodeNode* _tmp563_;
		_tmp562_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp563_ = _tmp562_;
		if (!VALA_IS_EXPRESSION_STATEMENT (_tmp563_)) {
			ValaCodeNode* _tmp564_;
			ValaCodeNode* _tmp565_;
			_tmp564_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp565_ = _tmp564_;
			_tmp561_ = !VALA_IS_FOR_STATEMENT (_tmp565_);
		} else {
			_tmp561_ = FALSE;
		}
		if (_tmp561_) {
			ValaCodeNode* _tmp566_;
			ValaCodeNode* _tmp567_;
			_tmp566_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp567_ = _tmp566_;
			_tmp560_ = !VALA_IS_YIELD_STATEMENT (_tmp567_);
		} else {
			_tmp560_ = FALSE;
		}
		if (_tmp560_) {
			ValaSourceReference* _tmp568_;
			ValaSourceReference* _tmp569_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp568_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp569_ = _tmp568_;
			vala_report_error (_tmp569_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp570_ = ret_type;
	_tmp571_ = vala_data_type_copy (_tmp570_);
	_tmp572_ = _tmp571_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp572_);
	_vala_code_node_unref0 (_tmp572_);
	_tmp573_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp574_ = _tmp573_;
	_tmp575_ = target_object_type;
	_tmp576_ = method_type_args;
	_tmp577_ = vala_data_type_get_actual_type (_tmp574_, _tmp575_, _tmp576_, (ValaCodeNode*) self);
	_tmp578_ = _tmp577_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp578_);
	_vala_code_node_unref0 (_tmp578_);
	_tmp579_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp580_ = _tmp579_;
	if (_tmp580_) {
		gboolean _tmp581_ = FALSE;
		ValaDataType* _tmp582_;
		gboolean _tmp590_ = FALSE;
		ValaSemanticAnalyzer* _tmp591_;
		ValaSemanticAnalyzer* _tmp592_;
		ValaMethod* _tmp593_;
		ValaMethod* _tmp594_;
		_tmp582_ = mtype;
		if (!VALA_IS_METHOD_TYPE (_tmp582_)) {
			_tmp581_ = TRUE;
		} else {
			ValaDataType* _tmp583_;
			ValaMethod* _tmp584_;
			ValaMethod* _tmp585_;
			gboolean _tmp586_;
			gboolean _tmp587_;
			_tmp583_ = mtype;
			_tmp584_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp583_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
			_tmp585_ = _tmp584_;
			_tmp586_ = vala_method_get_coroutine (_tmp585_);
			_tmp587_ = _tmp586_;
			_tmp581_ = !_tmp587_;
		}
		if (_tmp581_) {
			ValaSourceReference* _tmp588_;
			ValaSourceReference* _tmp589_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp588_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp589_ = _tmp588_;
			vala_report_error (_tmp589_, "yield expression requires async method");
		}
		_tmp591_ = vala_code_context_get_analyzer (context);
		_tmp592_ = _tmp591_;
		_tmp593_ = vala_semantic_analyzer_get_current_method (_tmp592_);
		_tmp594_ = _tmp593_;
		if (_tmp594_ == NULL) {
			_tmp590_ = TRUE;
		} else {
			ValaSemanticAnalyzer* _tmp595_;
			ValaSemanticAnalyzer* _tmp596_;
			ValaMethod* _tmp597_;
			ValaMethod* _tmp598_;
			gboolean _tmp599_;
			gboolean _tmp600_;
			_tmp595_ = vala_code_context_get_analyzer (context);
			_tmp596_ = _tmp595_;
			_tmp597_ = vala_semantic_analyzer_get_current_method (_tmp596_);
			_tmp598_ = _tmp597_;
			_tmp599_ = vala_method_get_coroutine (_tmp598_);
			_tmp600_ = _tmp599_;
			_tmp590_ = !_tmp600_;
		}
		if (_tmp590_) {
			ValaSourceReference* _tmp601_;
			ValaSourceReference* _tmp602_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp601_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp602_ = _tmp601_;
			vala_report_error (_tmp602_, "yield expression not available outside async method");
		}
	}
	_tmp603_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp603_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp604_;
		ValaMethod* _tmp605_;
		ValaMethod* _tmp606_;
		ValaMethod* _tmp607_;
		gboolean _tmp608_;
		gboolean _tmp609_;
		ValaMethod* _tmp612_;
		gboolean _tmp613_;
		gboolean _tmp614_;
		gboolean _tmp640_ = FALSE;
		gboolean _tmp641_ = FALSE;
		gboolean _tmp642_ = FALSE;
		gboolean _tmp643_;
		gboolean _tmp644_;
		ValaSignal* sig = NULL;
		ValaMethod* _tmp656_;
		ValaSymbol* _tmp657_;
		ValaSymbol* _tmp658_;
		gboolean _tmp659_ = FALSE;
		ValaSignal* _tmp660_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp673_;
		ValaSymbol* _tmp674_;
		ValaSymbol* _tmp675_;
		gboolean _tmp676_ = FALSE;
		ValaDynamicSignal* _tmp677_;
		gboolean _tmp727_ = FALSE;
		ValaMethod* _tmp728_;
		gboolean _tmp836_ = FALSE;
		ValaMethod* _tmp837_;
		_tmp604_ = mtype;
		_tmp605_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp604_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp606_ = _tmp605_;
		m = _tmp606_;
		_tmp607_ = m;
		_tmp608_ = vala_method_get_returns_floating_reference (_tmp607_);
		_tmp609_ = _tmp608_;
		if (_tmp609_) {
			ValaDataType* _tmp610_;
			ValaDataType* _tmp611_;
			_tmp610_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp611_ = _tmp610_;
			vala_data_type_set_floating_reference (_tmp611_, TRUE);
		}
		_tmp612_ = m;
		_tmp613_ = vala_method_get_returns_modified_pointer (_tmp612_);
		_tmp614_ = _tmp613_;
		if (_tmp614_) {
			ValaExpression* inner = NULL;
			ValaExpression* _tmp615_;
			ValaExpression* _tmp616_;
			ValaExpression* _tmp617_;
			ValaExpression* _tmp618_;
			ValaExpression* _tmp619_;
			ValaProperty* prop = NULL;
			ValaExpression* _tmp620_;
			ValaSymbol* _tmp621_;
			ValaSymbol* _tmp622_;
			gboolean _tmp623_ = FALSE;
			ValaProperty* _tmp624_;
			_tmp615_ = vala_method_call_get_call (self);
			_tmp616_ = _tmp615_;
			_tmp617_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp616_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp618_ = _tmp617_;
			inner = _tmp618_;
			_tmp619_ = inner;
			vala_expression_set_lvalue (_tmp619_, TRUE);
			_tmp620_ = inner;
			_tmp621_ = vala_expression_get_symbol_reference (_tmp620_);
			_tmp622_ = _tmp621_;
			prop = VALA_IS_PROPERTY (_tmp622_) ? ((ValaProperty*) _tmp622_) : NULL;
			_tmp624_ = prop;
			if (_tmp624_ != NULL) {
				gboolean _tmp625_ = FALSE;
				ValaProperty* _tmp626_;
				ValaPropertyAccessor* _tmp627_;
				ValaPropertyAccessor* _tmp628_;
				_tmp626_ = prop;
				_tmp627_ = vala_property_get_set_accessor (_tmp626_);
				_tmp628_ = _tmp627_;
				if (_tmp628_ == NULL) {
					_tmp625_ = TRUE;
				} else {
					ValaProperty* _tmp629_;
					ValaPropertyAccessor* _tmp630_;
					ValaPropertyAccessor* _tmp631_;
					gboolean _tmp632_;
					gboolean _tmp633_;
					_tmp629_ = prop;
					_tmp630_ = vala_property_get_set_accessor (_tmp629_);
					_tmp631_ = _tmp630_;
					_tmp632_ = vala_property_accessor_get_writable (_tmp631_);
					_tmp633_ = _tmp632_;
					_tmp625_ = !_tmp633_;
				}
				_tmp623_ = _tmp625_;
			} else {
				_tmp623_ = FALSE;
			}
			if (_tmp623_) {
				ValaExpression* _tmp634_;
				ValaSourceReference* _tmp635_;
				ValaSourceReference* _tmp636_;
				ValaProperty* _tmp637_;
				gchar* _tmp638_;
				gchar* _tmp639_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp634_ = inner;
				_tmp635_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp634_);
				_tmp636_ = _tmp635_;
				_tmp637_ = prop;
				_tmp638_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp637_);
				_tmp639_ = _tmp638_;
				vala_report_error (_tmp636_, "Property `%s' is read-only", _tmp639_);
				_g_free0 (_tmp639_);
			}
		}
		_tmp643_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp644_ = _tmp643_;
		if (_tmp644_) {
			ValaDataType* _tmp645_;
			ValaDataType* _tmp646_;
			gboolean _tmp647_;
			gboolean _tmp648_;
			_tmp645_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp646_ = _tmp645_;
			_tmp647_ = vala_data_type_get_nullable (_tmp646_);
			_tmp648_ = _tmp647_;
			_tmp642_ = !_tmp648_;
		} else {
			_tmp642_ = FALSE;
		}
		if (_tmp642_) {
			ValaDataType* _tmp649_;
			ValaDataType* _tmp650_;
			gboolean _tmp651_;
			gboolean _tmp652_;
			_tmp649_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp650_ = _tmp649_;
			_tmp651_ = vala_data_type_get_floating_reference (_tmp650_);
			_tmp652_ = _tmp651_;
			_tmp641_ = _tmp652_;
		} else {
			_tmp641_ = FALSE;
		}
		if (_tmp641_) {
			ValaDataType* _tmp653_;
			_tmp653_ = ret_type;
			_tmp640_ = VALA_IS_OBJECT_TYPE (_tmp653_);
		} else {
			_tmp640_ = FALSE;
		}
		if (_tmp640_) {
			ValaDataType* _tmp654_;
			ValaDataType* _tmp655_;
			_tmp654_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp655_ = _tmp654_;
			vala_data_type_set_nullable (_tmp655_, TRUE);
		}
		_tmp656_ = m;
		_tmp657_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp656_);
		_tmp658_ = _tmp657_;
		sig = VALA_IS_SIGNAL (_tmp658_) ? ((ValaSignal*) _tmp658_) : NULL;
		_tmp660_ = sig;
		if (_tmp660_ != NULL) {
			ValaMethod* _tmp661_;
			const gchar* _tmp662_;
			const gchar* _tmp663_;
			_tmp661_ = m;
			_tmp662_ = vala_symbol_get_name ((ValaSymbol*) _tmp661_);
			_tmp663_ = _tmp662_;
			_tmp659_ = g_strcmp0 (_tmp663_, "disconnect") == 0;
		} else {
			_tmp659_ = FALSE;
		}
		if (_tmp659_) {
			gboolean _tmp664_ = FALSE;
			ValaList* _tmp665_;
			gboolean _tmp666_;
			gboolean _tmp667_;
			_tmp665_ = self->priv->argument_list;
			_tmp666_ = vala_collection_get_is_empty ((ValaCollection*) _tmp665_);
			_tmp667_ = _tmp666_;
			if (!_tmp667_) {
				ValaList* _tmp668_;
				gpointer _tmp669_;
				ValaExpression* _tmp670_;
				_tmp668_ = self->priv->argument_list;
				_tmp669_ = vala_list_get (_tmp668_, 0);
				_tmp670_ = (ValaExpression*) _tmp669_;
				_tmp664_ = VALA_IS_LAMBDA_EXPRESSION (_tmp670_);
				_vala_code_node_unref0 (_tmp670_);
			} else {
				_tmp664_ = FALSE;
			}
			if (_tmp664_) {
				ValaSourceReference* _tmp671_;
				ValaSourceReference* _tmp672_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp671_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp672_ = _tmp671_;
				vala_report_error (_tmp672_, "Cannot disconnect lambda expression from signal");
				result = FALSE;
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp673_ = m;
		_tmp674_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp673_);
		_tmp675_ = _tmp674_;
		dynamic_sig = VALA_IS_DYNAMIC_SIGNAL (_tmp675_) ? ((ValaDynamicSignal*) _tmp675_) : NULL;
		_tmp677_ = dynamic_sig;
		if (_tmp677_ != NULL) {
			ValaDynamicSignal* _tmp678_;
			ValaExpression* _tmp679_;
			ValaExpression* _tmp680_;
			_tmp678_ = dynamic_sig;
			_tmp679_ = vala_dynamic_signal_get_handler (_tmp678_);
			_tmp680_ = _tmp679_;
			_tmp676_ = _tmp680_ != NULL;
		} else {
			_tmp676_ = FALSE;
		}
		if (_tmp676_) {
			ValaDynamicSignal* _tmp681_;
			ValaDynamicSignal* _tmp682_;
			ValaExpression* _tmp683_;
			ValaExpression* _tmp684_;
			ValaDataType* _tmp685_;
			ValaDataType* _tmp686_;
			ValaDataType* _tmp687_;
			ValaDataType* _tmp688_;
			ValaDataType* _tmp689_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp707_;
			ValaExpression* _tmp708_;
			ValaExpression* _tmp709_;
			ValaDynamicSignal* _tmp710_;
			ValaDynamicSignal* _tmp711_;
			ValaSymbol* _tmp712_;
			ValaSymbol* _tmp713_;
			ValaObjectType* _tmp714_;
			ValaObjectType* _tmp715_;
			ValaDelegate* _tmp716_;
			ValaDelegate* _tmp717_;
			ValaDelegateType* _tmp718_;
			ValaDelegateType* _tmp719_;
			ValaDynamicSignal* _tmp720_;
			ValaExpression* _tmp721_;
			ValaExpression* _tmp722_;
			ValaDataType* _tmp723_;
			ValaDataType* _tmp724_;
			ValaSourceReference* _tmp725_;
			ValaSourceReference* _tmp726_;
			_tmp681_ = dynamic_sig;
			_tmp682_ = dynamic_sig;
			_tmp683_ = vala_dynamic_signal_get_handler (_tmp682_);
			_tmp684_ = _tmp683_;
			_tmp685_ = vala_expression_get_value_type (_tmp684_);
			_tmp686_ = _tmp685_;
			_tmp687_ = vala_data_type_get_return_type (_tmp686_);
			_tmp688_ = vala_data_type_copy (_tmp687_);
			_tmp689_ = _tmp688_;
			vala_callable_set_return_type ((ValaCallable*) _tmp681_, _tmp689_);
			_vala_code_node_unref0 (_tmp689_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp690_;
				ValaExpression* _tmp691_;
				ValaExpression* _tmp692_;
				ValaDataType* _tmp693_;
				ValaDataType* _tmp694_;
				ValaList* _tmp695_;
				gint _param_size = 0;
				ValaList* _tmp696_;
				gint _tmp697_;
				gint _tmp698_;
				gint _param_index = 0;
				_tmp690_ = dynamic_sig;
				_tmp691_ = vala_dynamic_signal_get_handler (_tmp690_);
				_tmp692_ = _tmp691_;
				_tmp693_ = vala_expression_get_value_type (_tmp692_);
				_tmp694_ = _tmp693_;
				_tmp695_ = vala_data_type_get_parameters (_tmp694_);
				_param_list = _tmp695_;
				_tmp696_ = _param_list;
				_tmp697_ = vala_collection_get_size ((ValaCollection*) _tmp696_);
				_tmp698_ = _tmp697_;
				_param_size = _tmp698_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp699_;
					gint _tmp700_;
					ValaParameter* param = NULL;
					ValaList* _tmp701_;
					gpointer _tmp702_;
					_param_index = _param_index + 1;
					_tmp699_ = _param_index;
					_tmp700_ = _param_size;
					if (!(_tmp699_ < _tmp700_)) {
						break;
					}
					_tmp701_ = _param_list;
					_tmp702_ = vala_list_get (_tmp701_, _param_index);
					param = (ValaParameter*) _tmp702_;
					if (first) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp703_;
						ValaParameter* _tmp704_;
						ValaParameter* _tmp705_;
						ValaParameter* _tmp706_;
						_tmp703_ = dynamic_sig;
						_tmp704_ = param;
						_tmp705_ = vala_parameter_copy (_tmp704_);
						_tmp706_ = _tmp705_;
						vala_callable_add_parameter ((ValaCallable*) _tmp703_, _tmp706_);
						_vala_code_node_unref0 (_tmp706_);
					}
					_vala_code_node_unref0 (param);
				}
			}
			_tmp707_ = dynamic_sig;
			_tmp708_ = vala_dynamic_signal_get_handler (_tmp707_);
			_tmp709_ = _tmp708_;
			_tmp710_ = dynamic_sig;
			_tmp711_ = dynamic_sig;
			_tmp712_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp711_);
			_tmp713_ = _tmp712_;
			_tmp714_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp713_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp715_ = _tmp714_;
			_tmp716_ = vala_signal_get_delegate ((ValaSignal*) _tmp710_, (ValaDataType*) _tmp715_, (ValaCodeNode*) self);
			_tmp717_ = _tmp716_;
			_tmp718_ = vala_delegate_type_new (_tmp717_);
			_tmp719_ = _tmp718_;
			vala_expression_set_target_type (_tmp709_, (ValaDataType*) _tmp719_);
			_vala_code_node_unref0 (_tmp719_);
			_vala_code_node_unref0 (_tmp717_);
			_vala_code_node_unref0 (_tmp715_);
			_tmp720_ = dynamic_sig;
			_tmp721_ = vala_dynamic_signal_get_handler (_tmp720_);
			_tmp722_ = _tmp721_;
			_tmp723_ = vala_expression_get_target_type (_tmp722_);
			_tmp724_ = _tmp723_;
			_tmp725_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp726_ = _tmp725_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp724_, _tmp726_);
		}
		_tmp728_ = m;
		if (_tmp728_ != NULL) {
			ValaMethod* _tmp729_;
			_tmp729_ = m;
			_tmp727_ = vala_method_has_type_parameters (_tmp729_);
		} else {
			_tmp727_ = FALSE;
		}
		if (_tmp727_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp730_;
			ValaExpression* _tmp731_;
			ValaMemberAccess* _tmp732_;
			ValaList* _tmp733_;
			gint _tmp734_;
			gint _tmp735_;
			_tmp730_ = vala_method_call_get_call (self);
			_tmp731_ = _tmp730_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp731_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp732_ = ma;
			_tmp733_ = vala_member_access_get_type_arguments (_tmp732_);
			_tmp734_ = vala_collection_get_size ((ValaCollection*) _tmp733_);
			_tmp735_ = _tmp734_;
			if (_tmp735_ == 0) {
				ValaList* _tmp802_;
				ValaIterator* _tmp803_;
				ValaDataType* _tmp830_;
				ValaDataType* _tmp831_;
				ValaDataType* _tmp832_;
				ValaList* _tmp833_;
				ValaDataType* _tmp834_;
				ValaDataType* _tmp835_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp736_;
					ValaList* _tmp737_;
					gint _type_param_size = 0;
					ValaList* _tmp738_;
					gint _tmp739_;
					gint _tmp740_;
					gint _type_param_index = 0;
					_tmp736_ = m;
					_tmp737_ = vala_method_get_type_parameters (_tmp736_);
					_type_param_list = _tmp737_;
					_tmp738_ = _type_param_list;
					_tmp739_ = vala_collection_get_size ((ValaCollection*) _tmp738_);
					_tmp740_ = _tmp739_;
					_type_param_size = _tmp740_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp741_;
						gint _tmp742_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp743_;
						gpointer _tmp744_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp745_;
						ValaIterator* _tmp746_;
						gboolean _tmp782_ = FALSE;
						ValaDataType* _tmp783_;
						ValaDataType* _tmp793_;
						ValaMemberAccess* _tmp800_;
						ValaDataType* _tmp801_;
						_type_param_index = _type_param_index + 1;
						_tmp741_ = _type_param_index;
						_tmp742_ = _type_param_size;
						if (!(_tmp741_ < _tmp742_)) {
							break;
						}
						_tmp743_ = _type_param_list;
						_tmp744_ = vala_list_get (_tmp743_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp744_;
						type_arg = NULL;
						_tmp745_ = self->priv->argument_list;
						_tmp746_ = vala_iterable_iterator ((ValaIterable*) _tmp745_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp746_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp747_;
							gint _param_size = 0;
							ValaList* _tmp748_;
							gint _tmp749_;
							gint _tmp750_;
							gint _param_index = 0;
							_tmp747_ = params;
							_param_list = _tmp747_;
							_tmp748_ = _param_list;
							_tmp749_ = vala_collection_get_size ((ValaCollection*) _tmp748_);
							_tmp750_ = _tmp749_;
							_param_size = _tmp750_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp751_;
								gint _tmp752_;
								ValaParameter* param = NULL;
								ValaList* _tmp753_;
								gpointer _tmp754_;
								gboolean _tmp755_ = FALSE;
								ValaParameter* _tmp756_;
								gboolean _tmp757_;
								gboolean _tmp758_;
								ValaIterator* _tmp762_;
								_param_index = _param_index + 1;
								_tmp751_ = _param_index;
								_tmp752_ = _param_size;
								if (!(_tmp751_ < _tmp752_)) {
									break;
								}
								_tmp753_ = _param_list;
								_tmp754_ = vala_list_get (_tmp753_, _param_index);
								param = (ValaParameter*) _tmp754_;
								_tmp756_ = param;
								_tmp757_ = vala_parameter_get_ellipsis (_tmp756_);
								_tmp758_ = _tmp757_;
								if (_tmp758_) {
									_tmp755_ = TRUE;
								} else {
									ValaParameter* _tmp759_;
									gboolean _tmp760_;
									gboolean _tmp761_;
									_tmp759_ = param;
									_tmp760_ = vala_parameter_get_params_array (_tmp759_);
									_tmp761_ = _tmp760_;
									_tmp755_ = _tmp761_;
								}
								if (_tmp755_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp762_ = arg_it;
								if (vala_iterator_next (_tmp762_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp763_;
									gpointer _tmp764_;
									ValaParameter* _tmp765_;
									ValaDataType* _tmp766_;
									ValaDataType* _tmp767_;
									ValaTypeParameter* _tmp768_;
									ValaExpression* _tmp769_;
									ValaDataType* _tmp770_;
									ValaDataType* _tmp771_;
									ValaDataType* _tmp772_;
									ValaDataType* _tmp773_;
									ValaExpression* _tmp774_;
									ValaExpression* _tmp775_;
									ValaDataType* _tmp776_;
									ValaDataType* _tmp777_;
									ValaDataType* _tmp778_;
									ValaList* _tmp779_;
									ValaDataType* _tmp780_;
									ValaDataType* _tmp781_;
									_tmp763_ = arg_it;
									_tmp764_ = vala_iterator_get (_tmp763_);
									arg = (ValaExpression*) _tmp764_;
									_tmp765_ = param;
									_tmp766_ = vala_variable_get_variable_type ((ValaVariable*) _tmp765_);
									_tmp767_ = _tmp766_;
									_tmp768_ = type_param;
									_tmp769_ = arg;
									_tmp770_ = vala_expression_get_value_type (_tmp769_);
									_tmp771_ = _tmp770_;
									_tmp772_ = vala_data_type_infer_type_argument (_tmp767_, _tmp768_, _tmp771_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp772_;
									_tmp773_ = type_arg;
									if (_tmp773_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp774_ = arg;
									_tmp775_ = arg;
									_tmp776_ = vala_expression_get_formal_target_type (_tmp775_);
									_tmp777_ = _tmp776_;
									_tmp778_ = target_object_type;
									_tmp779_ = method_type_args;
									_tmp780_ = vala_data_type_get_actual_type (_tmp777_, _tmp778_, _tmp779_, (ValaCodeNode*) self);
									_tmp781_ = _tmp780_;
									vala_expression_set_target_type (_tmp774_, _tmp781_);
									_vala_code_node_unref0 (_tmp781_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp783_ = type_arg;
						if (_tmp783_ == NULL) {
							ValaDataType* _tmp784_;
							ValaDataType* _tmp785_;
							_tmp784_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp785_ = _tmp784_;
							_tmp782_ = _tmp785_ != NULL;
						} else {
							_tmp782_ = FALSE;
						}
						if (_tmp782_) {
							ValaMethod* _tmp786_;
							ValaDataType* _tmp787_;
							ValaDataType* _tmp788_;
							ValaTypeParameter* _tmp789_;
							ValaDataType* _tmp790_;
							ValaDataType* _tmp791_;
							ValaDataType* _tmp792_;
							_tmp786_ = m;
							_tmp787_ = vala_callable_get_return_type ((ValaCallable*) _tmp786_);
							_tmp788_ = _tmp787_;
							_tmp789_ = type_param;
							_tmp790_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp791_ = _tmp790_;
							_tmp792_ = vala_data_type_infer_type_argument (_tmp788_, _tmp789_, _tmp791_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp792_;
						}
						_tmp793_ = type_arg;
						if (_tmp793_ == NULL) {
							ValaMemberAccess* _tmp794_;
							ValaSourceReference* _tmp795_;
							ValaSourceReference* _tmp796_;
							ValaTypeParameter* _tmp797_;
							gchar* _tmp798_;
							gchar* _tmp799_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp794_ = ma;
							_tmp795_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp794_);
							_tmp796_ = _tmp795_;
							_tmp797_ = type_param;
							_tmp798_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp797_);
							_tmp799_ = _tmp798_;
							vala_report_error (_tmp796_, "cannot infer generic type argument for type parameter `%s'", _tmp799_);
							_g_free0 (_tmp799_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterator_unref0 (arg_it);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp800_ = ma;
						_tmp801_ = type_arg;
						vala_member_access_add_type_argument (_tmp800_, _tmp801_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
				}
				_tmp802_ = self->priv->argument_list;
				_tmp803_ = vala_iterable_iterator ((ValaIterable*) _tmp802_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp803_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp804_;
					gint _param_size = 0;
					ValaList* _tmp805_;
					gint _tmp806_;
					gint _tmp807_;
					gint _param_index = 0;
					_tmp804_ = params;
					_param_list = _tmp804_;
					_tmp805_ = _param_list;
					_tmp806_ = vala_collection_get_size ((ValaCollection*) _tmp805_);
					_tmp807_ = _tmp806_;
					_param_size = _tmp807_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp808_;
						gint _tmp809_;
						ValaParameter* param = NULL;
						ValaList* _tmp810_;
						gpointer _tmp811_;
						gboolean _tmp812_ = FALSE;
						ValaParameter* _tmp813_;
						gboolean _tmp814_;
						gboolean _tmp815_;
						ValaIterator* _tmp819_;
						_param_index = _param_index + 1;
						_tmp808_ = _param_index;
						_tmp809_ = _param_size;
						if (!(_tmp808_ < _tmp809_)) {
							break;
						}
						_tmp810_ = _param_list;
						_tmp811_ = vala_list_get (_tmp810_, _param_index);
						param = (ValaParameter*) _tmp811_;
						_tmp813_ = param;
						_tmp814_ = vala_parameter_get_ellipsis (_tmp813_);
						_tmp815_ = _tmp814_;
						if (_tmp815_) {
							_tmp812_ = TRUE;
						} else {
							ValaParameter* _tmp816_;
							gboolean _tmp817_;
							gboolean _tmp818_;
							_tmp816_ = param;
							_tmp817_ = vala_parameter_get_params_array (_tmp816_);
							_tmp818_ = _tmp817_;
							_tmp812_ = _tmp818_;
						}
						if (_tmp812_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp819_ = arg_it;
						if (vala_iterator_next (_tmp819_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp820_;
							gpointer _tmp821_;
							ValaExpression* _tmp822_;
							ValaExpression* _tmp823_;
							ValaDataType* _tmp824_;
							ValaDataType* _tmp825_;
							ValaDataType* _tmp826_;
							ValaList* _tmp827_;
							ValaDataType* _tmp828_;
							ValaDataType* _tmp829_;
							_tmp820_ = arg_it;
							_tmp821_ = vala_iterator_get (_tmp820_);
							arg = (ValaExpression*) _tmp821_;
							_tmp822_ = arg;
							_tmp823_ = arg;
							_tmp824_ = vala_expression_get_formal_target_type (_tmp823_);
							_tmp825_ = _tmp824_;
							_tmp826_ = target_object_type;
							_tmp827_ = method_type_args;
							_tmp828_ = vala_data_type_get_actual_type (_tmp825_, _tmp826_, _tmp827_, (ValaCodeNode*) self);
							_tmp829_ = _tmp828_;
							vala_expression_set_target_type (_tmp822_, _tmp829_);
							_vala_code_node_unref0 (_tmp829_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
				}
				_tmp830_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp831_ = _tmp830_;
				_tmp832_ = target_object_type;
				_tmp833_ = method_type_args;
				_tmp834_ = vala_data_type_get_actual_type (_tmp831_, _tmp832_, _tmp833_, (ValaCodeNode*) self);
				_tmp835_ = _tmp834_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp835_);
				_vala_code_node_unref0 (_tmp835_);
			}
		}
		_tmp837_ = m;
		if (_tmp837_ != NULL) {
			ValaMethod* _tmp838_;
			gboolean _tmp839_;
			gboolean _tmp840_;
			_tmp838_ = m;
			_tmp839_ = vala_method_get_coroutine (_tmp838_);
			_tmp840_ = _tmp839_;
			_tmp836_ = _tmp840_;
		} else {
			_tmp836_ = FALSE;
		}
		if (_tmp836_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp841_;
			ValaExpression* _tmp842_;
			ValaMemberAccess* _tmp843_;
			const gchar* _tmp844_;
			const gchar* _tmp845_;
			_tmp841_ = vala_method_call_get_call (self);
			_tmp842_ = _tmp841_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp842_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp843_ = ma;
			_tmp844_ = vala_member_access_get_member_name (_tmp843_);
			_tmp845_ = _tmp844_;
			if (g_strcmp0 (_tmp845_, "end") == 0) {
				ValaMethod* _tmp846_;
				ValaMethod* _tmp847_;
				ValaMethodType* _tmp848_;
				ValaDataType* _tmp849_;
				ValaSourceReference* _tmp850_;
				ValaSourceReference* _tmp851_;
				_tmp846_ = m;
				_tmp847_ = vala_method_get_end_method (_tmp846_);
				_tmp848_ = vala_method_type_new (_tmp847_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp848_;
				_tmp849_ = mtype;
				_tmp850_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp851_ = _tmp850_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp849_, _tmp851_);
			}
		}
	}
	_tmp852_ = vala_code_context_get_analyzer (context);
	_tmp853_ = _tmp852_;
	_tmp854_ = mtype;
	_tmp855_ = params;
	_tmp856_ = self->priv->argument_list;
	if (!vala_semantic_analyzer_check_arguments (_tmp853_, (ValaExpression*) self, _tmp854_, _tmp855_, _tmp856_)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp857_;
		gint _arg_size = 0;
		ValaList* _tmp858_;
		gint _tmp859_;
		gint _tmp860_;
		gint _arg_index = 0;
		_tmp857_ = self->priv->argument_list;
		_arg_list = _tmp857_;
		_tmp858_ = _arg_list;
		_tmp859_ = vala_collection_get_size ((ValaCollection*) _tmp858_);
		_tmp860_ = _tmp859_;
		_arg_size = _tmp860_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp861_;
			gint _tmp862_;
			ValaExpression* arg = NULL;
			ValaList* _tmp863_;
			gpointer _tmp864_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp865_;
			gboolean _tmp866_ = FALSE;
			ValaSizeofExpression* _tmp867_;
			_arg_index = _arg_index + 1;
			_tmp861_ = _arg_index;
			_tmp862_ = _arg_size;
			if (!(_tmp861_ < _tmp862_)) {
				break;
			}
			_tmp863_ = _arg_list;
			_tmp864_ = vala_list_get (_tmp863_, _arg_index);
			arg = (ValaExpression*) _tmp864_;
			_tmp865_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp865_) ? ((ValaSizeofExpression*) _tmp865_) : NULL;
			_tmp867_ = sizeof_expr;
			if (_tmp867_ != NULL) {
				ValaSizeofExpression* _tmp868_;
				ValaDataType* _tmp869_;
				ValaDataType* _tmp870_;
				_tmp868_ = sizeof_expr;
				_tmp869_ = vala_sizeof_expression_get_type_reference (_tmp868_);
				_tmp870_ = _tmp869_;
				_tmp866_ = VALA_IS_GENERIC_TYPE (_tmp870_);
			} else {
				_tmp866_ = FALSE;
			}
			if (_tmp866_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp871_;
				ValaDataType* _tmp872_;
				ValaDataType* _tmp873_;
				ValaDataType* _tmp874_;
				ValaList* _tmp875_;
				ValaDataType* _tmp876_;
				ValaExpression* _tmp877_;
				ValaDataType* _tmp878_;
				ValaSourceReference* _tmp879_;
				ValaSourceReference* _tmp880_;
				ValaSizeofExpression* _tmp881_;
				ValaSizeofExpression* _tmp882_;
				_tmp871_ = sizeof_expr;
				_tmp872_ = vala_sizeof_expression_get_type_reference (_tmp871_);
				_tmp873_ = _tmp872_;
				_tmp874_ = target_object_type;
				_tmp875_ = method_type_args;
				_tmp876_ = vala_data_type_get_actual_type (_tmp873_, _tmp874_, _tmp875_, (ValaCodeNode*) self);
				sizeof_type = _tmp876_;
				_tmp877_ = arg;
				_tmp878_ = sizeof_type;
				_tmp879_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp880_ = _tmp879_;
				_tmp881_ = vala_sizeof_expression_new (_tmp878_, _tmp880_);
				_tmp882_ = _tmp881_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp877_, (ValaExpression*) _tmp882_);
				_vala_code_node_unref0 (_tmp882_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp885_ = base_cm;
	if (_tmp885_ != NULL) {
		ValaCreationMethod* _tmp886_;
		_tmp886_ = base_cm;
		_tmp884_ = vala_method_is_variadic ((ValaMethod*) _tmp886_);
	} else {
		_tmp884_ = FALSE;
	}
	if (_tmp884_) {
		ValaList* _tmp887_;
		gint _tmp888_;
		gint _tmp889_;
		ValaCreationMethod* _tmp890_;
		ValaList* _tmp891_;
		gint _tmp892_;
		gint _tmp893_;
		_tmp887_ = self->priv->argument_list;
		_tmp888_ = vala_collection_get_size ((ValaCollection*) _tmp887_);
		_tmp889_ = _tmp888_;
		_tmp890_ = base_cm;
		_tmp891_ = vala_callable_get_parameters ((ValaCallable*) _tmp890_);
		_tmp892_ = vala_collection_get_size ((ValaCollection*) _tmp891_);
		_tmp893_ = _tmp892_;
		_tmp883_ = _tmp889_ == _tmp893_;
	} else {
		_tmp883_ = FALSE;
	}
	if (_tmp883_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp894_;
		ValaList* _tmp895_;
		gint _tmp896_;
		gint _tmp897_;
		gpointer _tmp898_;
		gboolean _tmp899_ = FALSE;
		ValaExpression* _tmp900_;
		ValaDataType* _tmp901_;
		ValaDataType* _tmp902_;
		_tmp894_ = self->priv->argument_list;
		_tmp895_ = self->priv->argument_list;
		_tmp896_ = vala_collection_get_size ((ValaCollection*) _tmp895_);
		_tmp897_ = _tmp896_;
		_tmp898_ = vala_list_get (_tmp894_, _tmp897_ - 1);
		this_last_arg = (ValaExpression*) _tmp898_;
		_tmp900_ = this_last_arg;
		_tmp901_ = vala_expression_get_value_type (_tmp900_);
		_tmp902_ = _tmp901_;
		if (VALA_IS_STRUCT_VALUE_TYPE (_tmp902_)) {
			ValaExpression* _tmp903_;
			ValaDataType* _tmp904_;
			ValaDataType* _tmp905_;
			ValaTypeSymbol* _tmp906_;
			ValaTypeSymbol* _tmp907_;
			ValaSemanticAnalyzer* _tmp908_;
			ValaSemanticAnalyzer* _tmp909_;
			ValaDataType* _tmp910_;
			ValaTypeSymbol* _tmp911_;
			ValaTypeSymbol* _tmp912_;
			_tmp903_ = this_last_arg;
			_tmp904_ = vala_expression_get_value_type (_tmp903_);
			_tmp905_ = _tmp904_;
			_tmp906_ = vala_data_type_get_type_symbol (_tmp905_);
			_tmp907_ = _tmp906_;
			_tmp908_ = vala_code_context_get_analyzer (context);
			_tmp909_ = _tmp908_;
			_tmp910_ = _tmp909_->va_list_type;
			_tmp911_ = vala_data_type_get_type_symbol (_tmp910_);
			_tmp912_ = _tmp911_;
			_tmp899_ = _tmp907_ == _tmp912_;
		} else {
			_tmp899_ = FALSE;
		}
		if (_tmp899_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp913_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp914_ = _tmp913_;
	vala_code_node_check ((ValaCodeNode*) _tmp914_, context);
	_tmp915_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp916_ = _tmp915_;
	if (_tmp916_) {
		gboolean _tmp917_ = FALSE;
		ValaCodeNode* _tmp918_;
		ValaCodeNode* _tmp919_;
		_tmp918_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp919_ = _tmp918_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp919_)) {
			_tmp917_ = TRUE;
		} else {
			ValaCodeNode* _tmp920_;
			ValaCodeNode* _tmp921_;
			_tmp920_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp921_ = _tmp920_;
			_tmp917_ = VALA_IS_EXPRESSION_STATEMENT (_tmp921_);
		}
		if (_tmp917_) {
		} else {
			ValaSemanticAnalyzer* _tmp922_;
			ValaSemanticAnalyzer* _tmp923_;
			ValaSymbol* _tmp924_;
			ValaSymbol* _tmp925_;
			_tmp922_ = vala_code_context_get_analyzer (context);
			_tmp923_ = _tmp922_;
			_tmp924_ = vala_semantic_analyzer_get_current_symbol (_tmp923_);
			_tmp925_ = _tmp924_;
			if (!VALA_IS_BLOCK (_tmp925_)) {
				ValaSourceReference* _tmp926_;
				ValaSourceReference* _tmp927_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp926_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp927_ = _tmp926_;
				vala_report_error (_tmp927_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp928_;
				ValaCodeNode* _tmp929_;
				ValaCodeNode* _tmp930_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp931_;
				ValaDataType* _tmp932_;
				ValaDataType* _tmp933_;
				ValaDataType* _tmp934_;
				gchar* _tmp935_;
				gchar* _tmp936_;
				ValaSourceReference* _tmp937_;
				ValaSourceReference* _tmp938_;
				ValaLocalVariable* _tmp939_;
				ValaLocalVariable* _tmp940_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp941_;
				ValaSourceReference* _tmp942_;
				ValaSourceReference* _tmp943_;
				ValaDeclarationStatement* _tmp944_;
				ValaDataType* _tmp945_;
				ValaDataType* _tmp946_;
				ValaSemanticAnalyzer* _tmp950_;
				ValaSemanticAnalyzer* _tmp951_;
				ValaBlock* _tmp952_;
				ValaDeclarationStatement* _tmp953_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp954_;
				ValaDataType* _tmp955_;
				ValaDataType* _tmp956_;
				ValaExpression* _tmp957_;
				ValaExpression* _tmp958_;
				ValaDataType* _tmp959_;
				ValaDataType* _tmp960_;
				ValaLocalVariable* _tmp961_;
				ValaDeclarationStatement* _tmp962_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp963_;
				ValaSemanticAnalyzer* _tmp964_;
				ValaSymbol* _tmp965_;
				ValaSymbol* _tmp966_;
				ValaBlock* _tmp967_;
				ValaBlock* _tmp968_;
				ValaLocalVariable* _tmp969_;
				ValaSemanticAnalyzer* _tmp970_;
				ValaSemanticAnalyzer* _tmp971_;
				ValaBlock* _tmp972_;
				ValaLocalVariable* _tmp973_;
				ValaCodeNode* _tmp974_;
				ValaExpression* _tmp975_;
				ValaExpression* _tmp976_;
				_tmp928_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp929_ = _tmp928_;
				_tmp930_ = _vala_code_node_ref0 (_tmp929_);
				old_parent_node = _tmp930_;
				_tmp931_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp932_ = _tmp931_;
				_tmp933_ = vala_data_type_copy (_tmp932_);
				_tmp934_ = _tmp933_;
				_tmp935_ = vala_code_node_get_temp_name ();
				_tmp936_ = _tmp935_;
				_tmp937_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp938_ = _tmp937_;
				_tmp939_ = vala_local_variable_new (_tmp934_, _tmp936_, NULL, _tmp938_);
				_tmp940_ = _tmp939_;
				_g_free0 (_tmp936_);
				_vala_code_node_unref0 (_tmp934_);
				local = _tmp940_;
				_tmp941_ = local;
				_tmp942_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp943_ = _tmp942_;
				_tmp944_ = vala_declaration_statement_new ((ValaSymbol*) _tmp941_, _tmp943_);
				decl = _tmp944_;
				_tmp945_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp946_ = _tmp945_;
				if (_tmp946_ == NULL) {
					ValaLocalVariable* _tmp947_;
					ValaDataType* _tmp948_;
					ValaDataType* _tmp949_;
					_tmp947_ = local;
					_tmp948_ = vala_variable_get_variable_type ((ValaVariable*) _tmp947_);
					_tmp949_ = _tmp948_;
					vala_data_type_set_floating_reference (_tmp949_, FALSE);
				}
				_tmp950_ = vala_code_context_get_analyzer (context);
				_tmp951_ = _tmp950_;
				_tmp952_ = _tmp951_->insert_block;
				_tmp953_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp952_, (ValaStatement*) _tmp953_);
				_tmp954_ = local;
				_tmp955_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp956_ = _tmp955_;
				_tmp957_ = vala_semantic_analyzer_create_temp_access (_tmp954_, _tmp956_);
				temp_access = _tmp957_;
				_tmp958_ = temp_access;
				_tmp959_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp960_ = _tmp959_;
				vala_expression_set_formal_target_type (_tmp958_, _tmp960_);
				_tmp961_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp961_, (ValaExpression*) self);
				_tmp962_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp962_, context);
				_tmp963_ = vala_code_context_get_analyzer (context);
				_tmp964_ = _tmp963_;
				_tmp965_ = vala_semantic_analyzer_get_current_symbol (_tmp964_);
				_tmp966_ = _tmp965_;
				_tmp967_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp966_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp967_;
				_tmp968_ = block;
				_tmp969_ = local;
				vala_block_remove_local_variable (_tmp968_, _tmp969_);
				_tmp970_ = vala_code_context_get_analyzer (context);
				_tmp971_ = _tmp970_;
				_tmp972_ = _tmp971_->insert_block;
				_tmp973_ = local;
				vala_block_add_local_variable (_tmp972_, _tmp973_);
				_tmp974_ = old_parent_node;
				_tmp975_ = temp_access;
				vala_code_node_replace_expression (_tmp974_, (ValaExpression*) self, _tmp975_);
				_tmp976_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp976_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp977_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp978_ = _tmp977_;
	result = !_tmp978_;
	_vala_iterator_unref0 (arg_it);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}

static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_SIGNAL (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		_tmp11_ = vala_method_call_get_call (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp14_ = _tmp13_;
		vala_code_node_emit ((ValaCodeNode*) _tmp14_, codegen);
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		vala_code_node_emit ((ValaCodeNode*) _tmp16_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp17_;
		gint _expr_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _expr_index = 0;
		_tmp17_ = self->priv->argument_list;
		_expr_list = _tmp17_;
		_tmp18_ = _expr_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_expr_size = _tmp20_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaExpression* expr = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaExpression* _tmp25_;
			_expr_index = _expr_index + 1;
			_tmp21_ = _expr_index;
			_tmp22_ = _expr_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _expr_list;
			_tmp24_ = vala_list_get (_tmp23_, _expr_index);
			expr = (ValaExpression*) _tmp24_;
			_tmp25_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp25_, codegen);
			_vala_code_node_unref0 (expr);
		}
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaStringLiteral* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	mtype = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = mtype;
	if (_tmp4_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = mtype;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		format_arg = vala_method_get_format_arg_index (_tmp7_);
		if (format_arg >= 0) {
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = self->priv->argument_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp8_ = format_arg < _tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaStringLiteral* _tmp15_;
			ValaStringLiteral* _tmp16_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, format_arg);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_string_literal_get_format_literal (_tmp14_);
			_tmp16_ = _tmp15_;
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp16_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp23_;
	GString* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* result = NULL;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		gint _expr_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_expr_list = _tmp10_;
		_tmp11_ = _expr_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_expr_size = _tmp13_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			ValaExpression* expr = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			GString* _tmp19_;
			ValaExpression* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_expr_index = _expr_index + 1;
			_tmp14_ = _expr_index;
			_tmp15_ = _expr_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _expr_list;
			_tmp17_ = vala_list_get (_tmp16_, _expr_index);
			expr = (ValaExpression*) _tmp17_;
			if (!first) {
				GString* _tmp18_;
				_tmp18_ = b;
				g_string_append (_tmp18_, ", ");
			}
			_tmp19_ = b;
			_tmp20_ = expr;
			_tmp21_ = vala_code_node_to_string ((ValaCodeNode*) _tmp20_);
			_tmp22_ = _tmp21_;
			g_string_append (_tmp19_, _tmp22_);
			_g_free0 (_tmp22_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp23_ = b;
	g_string_append_c (_tmp23_, ')');
	_tmp24_ = b;
	_tmp25_ = _tmp24_->str;
	_tmp26_ = g_strdup (_tmp25_);
	result = _tmp26_;
	_g_string_free0 (b);
	return result;
}

static void
vala_method_call_class_init (ValaMethodCallClass * klass,
                             gpointer klass_data)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_call_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}

static void
vala_method_call_vala_callable_expression_interface_init (ValaCallableExpressionIface * iface,
                                                          gpointer iface_data)
{
	vala_method_call_vala_callable_expression_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_argument = (void (*) (ValaCallableExpression*, ValaExpression*)) vala_method_call_real_add_argument;
	iface->get_argument_list = (ValaList* (*) (ValaCallableExpression*)) vala_method_call_real_get_argument_list;
	iface->get_is_yield_expression = vala_method_call_real_get_is_yield_expression;
	iface->set_is_yield_expression = vala_method_call_real_set_is_yield_expression;
}

static void
vala_method_call_instance_init (ValaMethodCall * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}

static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}

/**
 * Represents an invocation expression in the source code.
 */
static GType
vala_method_call_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
	static const GInterfaceInfo vala_callable_expression_info = { (GInterfaceInitFunc) vala_method_call_vala_callable_expression_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_method_call_type_id;
	vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
	g_type_add_interface_static (vala_method_call_type_id, VALA_TYPE_CALLABLE_EXPRESSION, &vala_callable_expression_info);
	ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
	return vala_method_call_type_id;
}

GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		GType vala_method_call_type_id;
		vala_method_call_type_id = vala_method_call_get_type_once ();
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}

