/* valamemberinitializer.c generated by valac, the Vala compiler
 * generated from valamemberinitializer.vala, do not modify */

/* valamemberinitializer.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaMemberInitializerPrivate {
	gchar* _name;
	ValaExpression* _initializer;
};

static gint ValaMemberInitializer_private_offset;
static gpointer vala_member_initializer_parent_class = NULL;

static void vala_member_initializer_set_name (ValaMemberInitializer* self,
                                       const gchar* value);
static void vala_member_initializer_set_initializer (ValaMemberInitializer* self,
                                              ValaExpression* value);
static gboolean vala_member_initializer_real_is_pure (ValaExpression* base);
static void vala_member_initializer_real_accept (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_member_initializer_real_check (ValaCodeNode* base,
                                             ValaCodeContext* context);
static void vala_member_initializer_real_emit (ValaCodeNode* base,
                                        ValaCodeGenerator* codegen);
static void vala_member_initializer_real_get_used_variables (ValaCodeNode* base,
                                                      ValaCollection* collection);
static void vala_member_initializer_real_replace_expression (ValaCodeNode* base,
                                                      ValaExpression* old_node,
                                                      ValaExpression* new_node);
static void vala_member_initializer_finalize (ValaCodeNode * obj);
static GType vala_member_initializer_get_type_once (void);

static inline gpointer
vala_member_initializer_get_instance_private (ValaMemberInitializer* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberInitializer_private_offset);
}

const gchar*
vala_member_initializer_get_name (ValaMemberInitializer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
vala_member_initializer_set_name (ValaMemberInitializer* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}

ValaExpression*
vala_member_initializer_get_initializer (ValaMemberInitializer* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_initializer;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_member_initializer_set_initializer (ValaMemberInitializer* self,
                                         ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_initializer);
	self->priv->_initializer = _tmp0_;
	_tmp1_ = self->priv->_initializer;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

/**
 * Creates a new member initializer.
 *
 * @param name             member name
 * @param initializer      initializer expression
 * @param source_reference reference to source code
 * @return                 newly created member initializer
 */
ValaMemberInitializer*
vala_member_initializer_construct (GType object_type,
                                   const gchar* name,
                                   ValaExpression* initializer,
                                   ValaSourceReference* source_reference)
{
	ValaMemberInitializer* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (initializer != NULL, NULL);
	self = (ValaMemberInitializer*) vala_expression_construct (object_type);
	vala_member_initializer_set_initializer (self, initializer);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_initializer_set_name (self, name);
	return self;
}

ValaMemberInitializer*
vala_member_initializer_new (const gchar* name,
                             ValaExpression* initializer,
                             ValaSourceReference* source_reference)
{
	return vala_member_initializer_construct (VALA_TYPE_MEMBER_INITIALIZER, name, initializer, source_reference);
}

static gboolean
vala_member_initializer_real_is_pure (ValaExpression* base)
{
	ValaMemberInitializer * self;
	gboolean result = FALSE;
	self = (ValaMemberInitializer*) base;
	result = FALSE;
	return result;
}

static void
vala_member_initializer_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaMemberInitializer * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberInitializer*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_initializer_get_initializer (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
}

static gboolean
vala_member_initializer_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context)
{
	ValaMemberInitializer * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaObjectCreationExpression* oce = NULL;
	ValaCodeNode* _tmp4_;
	ValaCodeNode* _tmp5_;
	ValaObjectCreationExpression* _tmp6_;
	ValaDataType* type = NULL;
	ValaObjectCreationExpression* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaTypeSymbol* _tmp13_;
	ValaTypeSymbol* _tmp14_;
	const gchar* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaSymbol* _tmp17_;
	gboolean _tmp18_ = FALSE;
	ValaSymbol* _tmp19_;
	ValaSymbol* _tmp20_;
	gboolean _tmp31_ = FALSE;
	ValaSymbol* _tmp32_;
	ValaSymbol* _tmp33_;
	ValaSymbolAccessibility _tmp34_;
	ValaSymbolAccessibility _tmp35_;
	ValaDataType* member_type = NULL;
	ValaSymbol* _tmp95_;
	ValaSymbol* _tmp96_;
	ValaExpression* _tmp125_;
	ValaExpression* _tmp126_;
	ValaDataType* _tmp127_;
	ValaExpression* _tmp128_;
	ValaExpression* _tmp129_;
	ValaExpression* _tmp130_;
	ValaExpression* _tmp131_;
	ValaDataType* _tmp132_;
	ValaDataType* _tmp133_;
	ValaDataType* _tmp134_;
	ValaDataType* _tmp135_;
	ValaDataType* _tmp136_;
	ValaExpression* _tmp137_;
	ValaExpression* _tmp138_;
	gboolean _tmp139_ = FALSE;
	ValaExpression* _tmp140_;
	ValaExpression* _tmp141_;
	ValaDataType* _tmp142_;
	ValaDataType* _tmp143_;
	gboolean _tmp155_;
	gboolean _tmp156_;
	gboolean result = FALSE;
	self = (ValaMemberInitializer*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp5_ = _tmp4_;
	oce = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp5_) ? ((ValaObjectCreationExpression*) _tmp5_) : NULL;
	_tmp6_ = oce;
	if (_tmp6_ == NULL) {
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp8_ = _tmp7_;
		vala_report_error (_tmp8_, "internal: Invalid member initializer");
		result = FALSE;
		return result;
	}
	_tmp9_ = oce;
	_tmp10_ = vala_object_creation_expression_get_type_reference (_tmp9_);
	_tmp11_ = _tmp10_;
	type = _tmp11_;
	_tmp12_ = type;
	_tmp13_ = vala_data_type_get_type_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->_name;
	_tmp16_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp14_, _tmp15_);
	_tmp17_ = _tmp16_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp17_);
	_vala_code_node_unref0 (_tmp17_);
	_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp20_ = _tmp19_;
	if (VALA_IS_FIELD (_tmp20_)) {
		_tmp18_ = TRUE;
	} else {
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		_tmp21_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp22_ = _tmp21_;
		_tmp18_ = VALA_IS_PROPERTY (_tmp22_);
	}
	if (!_tmp18_) {
		ValaSourceReference* _tmp23_;
		ValaSourceReference* _tmp24_;
		const gchar* _tmp25_;
		ValaDataType* _tmp26_;
		ValaTypeSymbol* _tmp27_;
		ValaTypeSymbol* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->_name;
		_tmp26_ = type;
		_tmp27_ = vala_data_type_get_type_symbol (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp28_);
		_tmp30_ = _tmp29_;
		vala_report_error (_tmp24_, "Invalid member `%s' in `%s'", _tmp25_, _tmp30_);
		_g_free0 (_tmp30_);
		result = FALSE;
		return result;
	}
	_tmp32_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_symbol_get_access (_tmp33_);
	_tmp35_ = _tmp34_;
	if (_tmp35_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp36_;
		ValaSymbol* _tmp37_;
		ValaSymbol* _tmp38_;
		ValaSymbol* _tmp39_;
		_tmp36_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_symbol_get_parent_symbol (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp31_ = VALA_IS_TYPESYMBOL (_tmp39_);
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp40_;
		ValaSymbol* _tmp41_;
		ValaSymbol* _tmp42_;
		ValaSymbol* _tmp43_;
		gboolean in_subtype = FALSE;
		_tmp40_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_symbol_get_parent_symbol (_tmp41_);
		_tmp43_ = _tmp42_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp44_;
			ValaSemanticAnalyzer* _tmp45_;
			ValaSymbol* _tmp46_;
			ValaSymbol* _tmp47_;
			ValaSymbol* _tmp48_;
			_tmp44_ = vala_code_context_get_analyzer (context);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_semantic_analyzer_get_current_symbol (_tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = _vala_code_node_ref0 (_tmp47_);
			this_symbol = _tmp48_;
			{
				gboolean _tmp49_ = FALSE;
				_tmp49_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp54_;
					ValaSymbol* _tmp55_;
					ValaTypeSymbol* _tmp56_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp57_;
					gboolean _tmp58_ = FALSE;
					ValaClass* _tmp59_;
					if (!_tmp49_) {
						ValaSymbol* _tmp50_;
						ValaSymbol* _tmp51_;
						ValaSymbol* _tmp52_;
						ValaSymbol* _tmp53_;
						_tmp50_ = this_symbol;
						_tmp51_ = vala_symbol_get_parent_symbol (_tmp50_);
						_tmp52_ = _tmp51_;
						_tmp53_ = _vala_code_node_ref0 (_tmp52_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp53_;
					}
					_tmp49_ = FALSE;
					_tmp54_ = this_symbol;
					if (!(_tmp54_ != NULL)) {
						break;
					}
					_tmp55_ = this_symbol;
					_tmp56_ = target_type;
					if (_tmp55_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp57_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp57_) ? ((ValaClass*) _tmp57_) : NULL;
					_tmp59_ = cl;
					if (_tmp59_ != NULL) {
						ValaClass* _tmp60_;
						ValaTypeSymbol* _tmp61_;
						_tmp60_ = cl;
						_tmp61_ = target_type;
						_tmp58_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp60_, _tmp61_);
					} else {
						_tmp58_ = FALSE;
					}
					if (_tmp58_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp62_;
			ValaSourceReference* _tmp63_;
			ValaSymbol* _tmp64_;
			ValaSymbol* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp63_ = _tmp62_;
			_tmp64_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp65_ = _tmp64_;
			_tmp66_ = vala_symbol_get_full_name (_tmp65_);
			_tmp67_ = _tmp66_;
			vala_report_error (_tmp63_, "Access to protected member `%s' denied", _tmp67_);
			_g_free0 (_tmp67_);
			result = FALSE;
			return result;
		}
	} else {
		ValaSymbol* _tmp68_;
		ValaSymbol* _tmp69_;
		ValaSymbolAccessibility _tmp70_;
		ValaSymbolAccessibility _tmp71_;
		_tmp68_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_symbol_get_access (_tmp69_);
		_tmp71_ = _tmp70_;
		if (_tmp71_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp72_;
			ValaSymbol* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			gboolean in_target_type = FALSE;
			_tmp72_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp73_ = _tmp72_;
			_tmp74_ = vala_symbol_get_parent_symbol (_tmp73_);
			_tmp75_ = _tmp74_;
			target_type = _tmp75_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp76_;
				ValaSemanticAnalyzer* _tmp77_;
				ValaSymbol* _tmp78_;
				ValaSymbol* _tmp79_;
				ValaSymbol* _tmp80_;
				_tmp76_ = vala_code_context_get_analyzer (context);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_semantic_analyzer_get_current_symbol (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = _vala_code_node_ref0 (_tmp79_);
				this_symbol = _tmp80_;
				{
					gboolean _tmp81_ = FALSE;
					_tmp81_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp86_;
						ValaSymbol* _tmp87_;
						ValaSymbol* _tmp88_;
						if (!_tmp81_) {
							ValaSymbol* _tmp82_;
							ValaSymbol* _tmp83_;
							ValaSymbol* _tmp84_;
							ValaSymbol* _tmp85_;
							_tmp82_ = this_symbol;
							_tmp83_ = vala_symbol_get_parent_symbol (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp85_ = _vala_code_node_ref0 (_tmp84_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp85_;
						}
						_tmp81_ = FALSE;
						_tmp86_ = this_symbol;
						if (!(_tmp86_ != NULL)) {
							break;
						}
						_tmp87_ = target_type;
						_tmp88_ = this_symbol;
						if (_tmp87_ == _tmp88_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp89_;
				ValaSourceReference* _tmp90_;
				ValaSymbol* _tmp91_;
				ValaSymbol* _tmp92_;
				gchar* _tmp93_;
				gchar* _tmp94_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp90_ = _tmp89_;
				_tmp91_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp92_ = _tmp91_;
				_tmp93_ = vala_symbol_get_full_name (_tmp92_);
				_tmp94_ = _tmp93_;
				vala_report_error (_tmp90_, "Access to private member `%s' denied", _tmp94_);
				_g_free0 (_tmp94_);
				result = FALSE;
				return result;
			}
		}
	}
	member_type = NULL;
	_tmp95_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp96_ = _tmp95_;
	if (VALA_IS_FIELD (_tmp96_)) {
		ValaField* f = NULL;
		ValaSymbol* _tmp97_;
		ValaSymbol* _tmp98_;
		ValaField* _tmp99_;
		ValaDataType* _tmp100_;
		ValaDataType* _tmp101_;
		ValaDataType* _tmp102_;
		_tmp97_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp98_ = _tmp97_;
		f = G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_FIELD, ValaField);
		_tmp99_ = f;
		_tmp100_ = vala_variable_get_variable_type ((ValaVariable*) _tmp99_);
		_tmp101_ = _tmp100_;
		_tmp102_ = _vala_code_node_ref0 (_tmp101_);
		_vala_code_node_unref0 (member_type);
		member_type = _tmp102_;
	} else {
		ValaSymbol* _tmp103_;
		ValaSymbol* _tmp104_;
		_tmp103_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp104_ = _tmp103_;
		if (VALA_IS_PROPERTY (_tmp104_)) {
			ValaProperty* prop = NULL;
			ValaSymbol* _tmp105_;
			ValaSymbol* _tmp106_;
			ValaProperty* _tmp107_;
			ValaDataType* _tmp108_;
			ValaDataType* _tmp109_;
			ValaDataType* _tmp110_;
			gboolean _tmp111_ = FALSE;
			ValaProperty* _tmp112_;
			ValaPropertyAccessor* _tmp113_;
			ValaPropertyAccessor* _tmp114_;
			_tmp105_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp106_ = _tmp105_;
			prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp106_, VALA_TYPE_PROPERTY, ValaProperty);
			_tmp107_ = prop;
			_tmp108_ = vala_property_get_property_type (_tmp107_);
			_tmp109_ = _tmp108_;
			_tmp110_ = _vala_code_node_ref0 (_tmp109_);
			_vala_code_node_unref0 (member_type);
			member_type = _tmp110_;
			_tmp112_ = prop;
			_tmp113_ = vala_property_get_set_accessor (_tmp112_);
			_tmp114_ = _tmp113_;
			if (_tmp114_ == NULL) {
				_tmp111_ = TRUE;
			} else {
				ValaProperty* _tmp115_;
				ValaPropertyAccessor* _tmp116_;
				ValaPropertyAccessor* _tmp117_;
				gboolean _tmp118_;
				gboolean _tmp119_;
				_tmp115_ = prop;
				_tmp116_ = vala_property_get_set_accessor (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = vala_property_accessor_get_writable (_tmp117_);
				_tmp119_ = _tmp118_;
				_tmp111_ = !_tmp119_;
			}
			if (_tmp111_) {
				ValaSourceReference* _tmp120_;
				ValaSourceReference* _tmp121_;
				ValaProperty* _tmp122_;
				gchar* _tmp123_;
				gchar* _tmp124_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp121_ = _tmp120_;
				_tmp122_ = prop;
				_tmp123_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp122_);
				_tmp124_ = _tmp123_;
				vala_report_error (_tmp121_, "Property `%s' is read-only", _tmp124_);
				_g_free0 (_tmp124_);
				result = FALSE;
				_vala_code_node_unref0 (member_type);
				return result;
			}
		}
	}
	_tmp125_ = vala_member_initializer_get_initializer (self);
	_tmp126_ = _tmp125_;
	_tmp127_ = member_type;
	vala_expression_set_formal_target_type (_tmp126_, _tmp127_);
	_tmp128_ = vala_member_initializer_get_initializer (self);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_member_initializer_get_initializer (self);
	_tmp131_ = _tmp130_;
	_tmp132_ = vala_expression_get_formal_target_type (_tmp131_);
	_tmp133_ = _tmp132_;
	_tmp134_ = type;
	_tmp135_ = vala_data_type_get_actual_type (_tmp133_, _tmp134_, NULL, (ValaCodeNode*) self);
	_tmp136_ = _tmp135_;
	vala_expression_set_target_type (_tmp129_, _tmp136_);
	_vala_code_node_unref0 (_tmp136_);
	_tmp137_ = vala_member_initializer_get_initializer (self);
	_tmp138_ = _tmp137_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp138_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (member_type);
		return result;
	}
	_tmp140_ = vala_member_initializer_get_initializer (self);
	_tmp141_ = _tmp140_;
	_tmp142_ = vala_expression_get_value_type (_tmp141_);
	_tmp143_ = _tmp142_;
	if (_tmp143_ == NULL) {
		_tmp139_ = TRUE;
	} else {
		ValaExpression* _tmp144_;
		ValaExpression* _tmp145_;
		ValaDataType* _tmp146_;
		ValaDataType* _tmp147_;
		ValaExpression* _tmp148_;
		ValaExpression* _tmp149_;
		ValaDataType* _tmp150_;
		ValaDataType* _tmp151_;
		_tmp144_ = vala_member_initializer_get_initializer (self);
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_expression_get_value_type (_tmp145_);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_member_initializer_get_initializer (self);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_expression_get_target_type (_tmp149_);
		_tmp151_ = _tmp150_;
		_tmp139_ = !vala_data_type_compatible (_tmp147_, _tmp151_);
	}
	if (_tmp139_) {
		ValaSourceReference* _tmp152_;
		ValaSourceReference* _tmp153_;
		const gchar* _tmp154_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp152_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp153_ = _tmp152_;
		_tmp154_ = self->priv->_name;
		vala_report_error (_tmp153_, "Invalid type for member `%s'", _tmp154_);
		result = FALSE;
		_vala_code_node_unref0 (member_type);
		return result;
	}
	_tmp155_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp156_ = _tmp155_;
	result = !_tmp156_;
	_vala_code_node_unref0 (member_type);
	return result;
}

static void
vala_member_initializer_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen)
{
	ValaMemberInitializer * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberInitializer*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_initializer_get_initializer (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
}

static void
vala_member_initializer_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection)
{
	ValaMemberInitializer * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberInitializer*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_initializer_get_initializer (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
}

static void
vala_member_initializer_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node)
{
	ValaMemberInitializer * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberInitializer*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_initializer_get_initializer (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_initializer_set_initializer (self, new_node);
	}
}

static void
vala_member_initializer_class_init (ValaMemberInitializerClass * klass,
                                    gpointer klass_data)
{
	vala_member_initializer_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_initializer_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberInitializer_private_offset);
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_initializer_real_is_pure;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_initializer_real_accept;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_initializer_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_initializer_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_initializer_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_initializer_real_replace_expression;
}

static void
vala_member_initializer_instance_init (ValaMemberInitializer * self,
                                       gpointer klass)
{
	self->priv = vala_member_initializer_get_instance_private (self);
}

static void
vala_member_initializer_finalize (ValaCodeNode * obj)
{
	ValaMemberInitializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer);
	_g_free0 (self->priv->_name);
	_vala_code_node_unref0 (self->priv->_initializer);
	VALA_CODE_NODE_CLASS (vala_member_initializer_parent_class)->finalize (obj);
}

/**
 * Represents a member initializer, i.e. an element of an object initializer, in
 * the source code.
 */
static GType
vala_member_initializer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberInitializerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_initializer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberInitializer), 0, (GInstanceInitFunc) vala_member_initializer_instance_init, NULL };
	GType vala_member_initializer_type_id;
	vala_member_initializer_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberInitializer", &g_define_type_info, 0);
	ValaMemberInitializer_private_offset = g_type_add_instance_private (vala_member_initializer_type_id, sizeof (ValaMemberInitializerPrivate));
	return vala_member_initializer_type_id;
}

GType
vala_member_initializer_get_type (void)
{
	static volatile gsize vala_member_initializer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_initializer_type_id__volatile)) {
		GType vala_member_initializer_type_id;
		vala_member_initializer_type_id = vala_member_initializer_get_type_once ();
		g_once_init_leave (&vala_member_initializer_type_id__volatile, vala_member_initializer_type_id);
	}
	return vala_member_initializer_type_id__volatile;
}

