/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaObjectCreationExpressionPrivate {
	gboolean _is_yield_expression;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
	ValaMemberAccess* _member_name;
};

static gint ValaObjectCreationExpression_private_offset;
static gpointer vala_object_creation_expression_parent_class = NULL;
static ValaCallableExpressionIface * vala_object_creation_expression_vala_callable_expression_parent_iface = NULL;

static void vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                         ValaDataType* value);
static void vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                      ValaMemberAccess* value);
static void vala_object_creation_expression_real_add_argument (ValaCallableExpression* base,
                                                        ValaExpression* arg);
static ValaList* vala_object_creation_expression_real_get_argument_list (ValaCallableExpression* base);
static void vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                              ValaExpression* old_node,
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                        ValaDataType* old_type,
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base,
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                           ValaCollection* collection,
                                                           ValaSourceReference* source_reference);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                              ValaCollection* collection);
static gchar* vala_object_creation_expression_real_to_string (ValaCodeNode* base);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);
static GType vala_object_creation_expression_get_type_once (void);

static inline gpointer
vala_object_creation_expression_get_instance_private (ValaObjectCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaObjectCreationExpression_private_offset);
}

ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
	_tmp1_ = self->priv->_member_name;
	if (_tmp1_ != NULL) {
		ValaMemberAccess* _tmp2_;
		_tmp2_ = self->priv->_member_name;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

static gboolean
vala_object_creation_expression_real_get_is_yield_expression (ValaCallableExpression* base)
{
	gboolean result;
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	result = self->priv->_is_yield_expression;
	return result;
}

static void
vala_object_creation_expression_real_set_is_yield_expression (ValaCallableExpression* base,
                                                              gboolean value)
{
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	self->priv->_is_yield_expression = value;
}

gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_struct_creation;
	return result;
}

void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}

/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type,
                                           ValaMemberAccess* member_name,
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}

ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name,
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
static void
vala_object_creation_expression_real_add_argument (ValaCallableExpression* base,
                                                   ValaExpression* arg)
{
	ValaObjectCreationExpression * self;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
static ValaList*
vala_object_creation_expression_real_get_argument_list (ValaCallableExpression* base)
{
	ValaObjectCreationExpression * self;
	ValaList* _tmp0_;
	ValaList* result = NULL;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self,
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}

/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp8_;
		gint _arg_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _arg_index = 0;
		_tmp8_ = self->priv->argument_list;
		_arg_list = _tmp8_;
		_tmp9_ = _arg_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_arg_size = _tmp11_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaExpression* arg = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValaExpression* _tmp16_;
			_arg_index = _arg_index + 1;
			_tmp12_ = _arg_index;
			_tmp13_ = _arg_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _arg_list;
			_tmp15_ = vala_list_get (_tmp14_, _arg_index);
			arg = (ValaExpression*) _tmp15_;
			_tmp16_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp17_;
		gint _init_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _init_index = 0;
		_tmp17_ = self->priv->object_initializer;
		_init_list = _tmp17_;
		_tmp18_ = _init_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_init_size = _tmp20_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaMemberInitializer* _tmp25_;
			_init_index = _init_index + 1;
			_tmp21_ = _init_index;
			_tmp22_ = _init_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _init_list;
			_tmp24_ = vala_list_get (_tmp23_, _init_index);
			init = (ValaMemberInitializer*) _tmp24_;
			_tmp25_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp25_, visitor);
			_vala_code_node_unref0 (init);
		}
	}
}

static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                         ValaExpression* old_node,
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	if (index >= 0) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->argument_list;
		vala_list_set (_tmp1_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* _tmp2_;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_object_creation_expression_get_member_name (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaMemberAccess* _tmp3_;
		ValaMemberAccess* _tmp4_;
		_tmp3_ = vala_object_creation_expression_get_member_name (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp5_;
		gint _arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _arg_index = 0;
		_tmp5_ = self->priv->argument_list;
		_arg_list = _tmp5_;
		_tmp6_ = _arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_arg_size = _tmp8_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* arg = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_arg_index = _arg_index + 1;
			_tmp9_ = _arg_index;
			_tmp10_ = _arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _arg_list;
			_tmp12_ = vala_list_get (_tmp11_, _arg_index);
			arg = (ValaExpression*) _tmp12_;
			_tmp13_ = arg;
			if (!vala_expression_is_accessible (_tmp13_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp14_;
		gint _init_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _init_index = 0;
		_tmp14_ = self->priv->object_initializer;
		_init_list = _tmp14_;
		_tmp15_ = _init_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_init_size = _tmp17_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaMemberInitializer* _tmp22_;
			ValaExpression* _tmp23_;
			ValaExpression* _tmp24_;
			_init_index = _init_index + 1;
			_tmp18_ = _init_index;
			_tmp19_ = _init_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _init_list;
			_tmp21_ = vala_list_get (_tmp20_, _init_index);
			init = (ValaMemberInitializer*) _tmp21_;
			_tmp22_ = init;
			_tmp23_ = vala_member_initializer_get_initializer (_tmp22_);
			_tmp24_ = _tmp23_;
			if (!vala_expression_is_accessible (_tmp24_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
	}
	result = TRUE;
	return result;
}

static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                   ValaDataType* old_type,
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaTypeSymbol* type = NULL;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp106_;
	ValaDataType* _tmp107_;
	ValaDataType* _tmp108_;
	ValaDataType* _tmp109_;
	ValaDataType* _tmp110_;
	ValaDataType* _tmp111_;
	gint given_num_type_args = 0;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	ValaList* _tmp114_;
	gint _tmp115_;
	gint _tmp116_;
	gint expected_num_type_args = 0;
	ValaTypeSymbol* _tmp117_;
	gboolean _tmp235_ = FALSE;
	ValaSymbol* _tmp236_;
	ValaSymbol* _tmp237_;
	ValaSymbol* _tmp246_;
	ValaSymbol* _tmp247_;
	ValaTypeSymbol* _tmp500_;
	gboolean _tmp501_;
	gboolean _tmp502_;
	gboolean _tmp590_;
	gboolean _tmp591_;
	gboolean _tmp647_;
	gboolean _tmp648_;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp7_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp8_ = vala_object_creation_expression_get_type_reference (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaMemberAccess* _tmp10_;
		ValaMemberAccess* _tmp11_;
		ValaMemberAccess* _tmp14_;
		ValaMemberAccess* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* constructor_sym = NULL;
		ValaMemberAccess* _tmp18_;
		ValaMemberAccess* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* type_sym = NULL;
		ValaMemberAccess* _tmp23_;
		ValaMemberAccess* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaList* type_args = NULL;
		ValaMemberAccess* _tmp28_;
		ValaMemberAccess* _tmp29_;
		ValaList* _tmp30_;
		ValaList* _tmp31_;
		ValaSymbol* _tmp32_;
		ValaSymbol* _tmp54_;
		_tmp10_ = vala_object_creation_expression_get_member_name (self);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp13_, "Incomplete object creation expression");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp14_ = vala_object_creation_expression_get_member_name (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp18_ = vala_object_creation_expression_get_member_name (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 (_tmp21_);
		constructor_sym = _tmp22_;
		_tmp23_ = vala_object_creation_expression_get_member_name (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _vala_code_node_ref0 (_tmp26_);
		type_sym = _tmp27_;
		_tmp28_ = vala_object_creation_expression_get_member_name (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_member_access_get_type_arguments (_tmp29_);
		_tmp31_ = _vala_iterable_ref0 (_tmp30_);
		type_args = _tmp31_;
		_tmp32_ = constructor_sym;
		if (VALA_IS_METHOD (_tmp32_)) {
			ValaSymbol* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaMethod* constructor = NULL;
			ValaSymbol* _tmp37_;
			ValaMethod* _tmp38_;
			ValaSymbol* _tmp39_;
			ValaMethod* _tmp45_;
			ValaMemberAccess* ma = NULL;
			ValaMemberAccess* _tmp46_;
			ValaMemberAccess* _tmp47_;
			ValaExpression* _tmp48_;
			ValaExpression* _tmp49_;
			ValaMemberAccess* _tmp50_;
			_tmp33_ = constructor_sym;
			_tmp34_ = vala_symbol_get_parent_symbol (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = _vala_code_node_ref0 (_tmp35_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp36_;
			_tmp37_ = constructor_sym;
			_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_METHOD, ValaMethod));
			constructor = _tmp38_;
			_tmp39_ = constructor_sym;
			if (!VALA_IS_CREATION_METHOD (_tmp39_)) {
				ValaSourceReference* _tmp40_;
				ValaSourceReference* _tmp41_;
				ValaMethod* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp41_ = _tmp40_;
				_tmp42_ = constructor;
				_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
				_tmp44_ = _tmp43_;
				vala_report_error (_tmp41_, "`%s' is not a creation method", _tmp44_);
				_g_free0 (_tmp44_);
				result = FALSE;
				_vala_code_node_unref0 (constructor);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp45_ = constructor;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp45_);
			_tmp46_ = vala_object_creation_expression_get_member_name (self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_member_access_get_inner (_tmp47_);
			_tmp49_ = _tmp48_;
			ma = VALA_IS_MEMBER_ACCESS (_tmp49_) ? ((ValaMemberAccess*) _tmp49_) : NULL;
			_tmp50_ = ma;
			if (_tmp50_ != NULL) {
				ValaMemberAccess* _tmp51_;
				ValaList* _tmp52_;
				ValaList* _tmp53_;
				_tmp51_ = ma;
				_tmp52_ = vala_member_access_get_type_arguments (_tmp51_);
				_tmp53_ = _vala_iterable_ref0 (_tmp52_);
				_vala_iterable_unref0 (type_args);
				type_args = _tmp53_;
			}
			_vala_code_node_unref0 (constructor);
		}
		_tmp54_ = type_sym;
		if (VALA_IS_CLASS (_tmp54_)) {
			ValaSymbol* _tmp55_;
			ValaTypeSymbol* _tmp56_;
			ValaTypeSymbol* _tmp57_;
			gboolean _tmp58_;
			gboolean _tmp59_;
			_tmp55_ = type_sym;
			_tmp56_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp56_;
			_tmp57_ = type;
			_tmp58_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_CLASS, ValaClass));
			_tmp59_ = _tmp58_;
			if (_tmp59_) {
				ValaSourceReference* _tmp60_;
				ValaSourceReference* _tmp61_;
				ValaErrorType* _tmp62_;
				ValaErrorType* _tmp63_;
				_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_error_type_new (NULL, NULL, _tmp61_);
				_tmp63_ = _tmp62_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp63_);
				_vala_code_node_unref0 (_tmp63_);
			} else {
				ValaTypeSymbol* _tmp64_;
				ValaObjectType* _tmp65_;
				ValaObjectType* _tmp66_;
				_tmp64_ = type;
				_tmp65_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_CLASS, ValaClass));
				_tmp66_ = _tmp65_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp66_);
				_vala_code_node_unref0 (_tmp66_);
			}
		} else {
			ValaSymbol* _tmp67_;
			_tmp67_ = type_sym;
			if (VALA_IS_STRUCT (_tmp67_)) {
				ValaSymbol* _tmp68_;
				ValaTypeSymbol* _tmp69_;
				ValaTypeSymbol* _tmp70_;
				ValaStructValueType* _tmp71_;
				ValaStructValueType* _tmp72_;
				_tmp68_ = type_sym;
				_tmp69_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp69_;
				_tmp70_ = type;
				_tmp71_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_STRUCT, ValaStruct));
				_tmp72_ = _tmp71_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp72_);
				_vala_code_node_unref0 (_tmp72_);
			} else {
				ValaSymbol* _tmp73_;
				_tmp73_ = type_sym;
				if (VALA_IS_ERROR_CODE (_tmp73_)) {
					ValaSymbol* _tmp74_;
					ValaTypeSymbol* _tmp75_;
					ValaSymbol* _tmp76_;
					ValaSymbol* _tmp77_;
					ValaSymbol* _tmp78_;
					ValaSymbol* _tmp79_;
					ValaSourceReference* _tmp80_;
					ValaSourceReference* _tmp81_;
					ValaErrorType* _tmp82_;
					ValaErrorType* _tmp83_;
					ValaSymbol* _tmp84_;
					_tmp74_ = type_sym;
					_tmp75_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
					_vala_code_node_unref0 (type);
					type = _tmp75_;
					_tmp76_ = type_sym;
					_tmp77_ = vala_symbol_get_parent_symbol (_tmp76_);
					_tmp78_ = _tmp77_;
					_tmp79_ = type_sym;
					_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp81_ = _tmp80_;
					_tmp82_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp81_);
					_tmp83_ = _tmp82_;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp83_);
					_vala_code_node_unref0 (_tmp83_);
					_tmp84_ = type_sym;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp84_);
				} else {
					ValaSourceReference* _tmp85_;
					ValaSourceReference* _tmp86_;
					ValaSymbol* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp86_ = _tmp85_;
					_tmp87_ = type_sym;
					_tmp88_ = vala_symbol_get_full_name (_tmp87_);
					_tmp89_ = _tmp88_;
					vala_report_error (_tmp86_, "`%s' is not a class, struct, or error code", _tmp89_);
					_g_free0 (_tmp89_);
					result = FALSE;
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
			}
		}
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp90_;
			gint _type_arg_size = 0;
			ValaList* _tmp91_;
			gint _tmp92_;
			gint _tmp93_;
			gint _type_arg_index = 0;
			_tmp90_ = type_args;
			_type_arg_list = _tmp90_;
			_tmp91_ = _type_arg_list;
			_tmp92_ = vala_collection_get_size ((ValaCollection*) _tmp91_);
			_tmp93_ = _tmp92_;
			_type_arg_size = _tmp93_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp94_;
				gint _tmp95_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp96_;
				gpointer _tmp97_;
				ValaDataType* _tmp98_;
				ValaDataType* _tmp99_;
				ValaDataType* _tmp100_;
				_type_arg_index = _type_arg_index + 1;
				_tmp94_ = _type_arg_index;
				_tmp95_ = _type_arg_size;
				if (!(_tmp94_ < _tmp95_)) {
					break;
				}
				_tmp96_ = _type_arg_list;
				_tmp97_ = vala_list_get (_tmp96_, _type_arg_index);
				type_arg = (ValaDataType*) _tmp97_;
				_tmp98_ = vala_object_creation_expression_get_type_reference (self);
				_tmp99_ = _tmp98_;
				_tmp100_ = type_arg;
				vala_data_type_add_type_argument (_tmp99_, _tmp100_);
				_vala_code_node_unref0 (type_arg);
			}
		}
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
	} else {
		ValaDataType* _tmp101_;
		ValaDataType* _tmp102_;
		ValaTypeSymbol* _tmp103_;
		ValaTypeSymbol* _tmp104_;
		ValaTypeSymbol* _tmp105_;
		_tmp101_ = vala_object_creation_expression_get_type_reference (self);
		_tmp102_ = _tmp101_;
		_tmp103_ = vala_data_type_get_type_symbol (_tmp102_);
		_tmp104_ = _tmp103_;
		_tmp105_ = _vala_code_node_ref0 (_tmp104_);
		_vala_code_node_unref0 (type);
		type = _tmp105_;
	}
	_tmp106_ = vala_object_creation_expression_get_type_reference (self);
	_tmp107_ = _tmp106_;
	_tmp108_ = vala_data_type_copy (_tmp107_);
	_tmp109_ = _tmp108_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp109_);
	_vala_code_node_unref0 (_tmp109_);
	_tmp110_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp111_ = _tmp110_;
	vala_data_type_set_value_owned (_tmp111_, TRUE);
	_tmp112_ = vala_object_creation_expression_get_type_reference (self);
	_tmp113_ = _tmp112_;
	_tmp114_ = vala_data_type_get_type_arguments (_tmp113_);
	_tmp115_ = vala_collection_get_size ((ValaCollection*) _tmp114_);
	_tmp116_ = _tmp115_;
	given_num_type_args = _tmp116_;
	expected_num_type_args = 0;
	_tmp117_ = type;
	if (VALA_IS_CLASS (_tmp117_)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp118_;
		ValaClass* _tmp119_;
		ValaClass* _tmp120_;
		ValaList* _tmp121_;
		gint _tmp122_;
		gint _tmp123_;
		gboolean _tmp124_;
		ValaClass* _tmp127_;
		gboolean _tmp128_;
		gboolean _tmp129_;
		ValaSymbol* _tmp135_;
		ValaSymbol* _tmp136_;
		gboolean _tmp155_ = FALSE;
		ValaSymbol* _tmp156_;
		ValaSymbol* _tmp157_;
		_tmp118_ = type;
		_tmp119_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp118_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp119_;
		_tmp120_ = cl;
		_tmp121_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp120_);
		_tmp122_ = vala_collection_get_size ((ValaCollection*) _tmp121_);
		_tmp123_ = _tmp122_;
		expected_num_type_args = _tmp123_;
		_tmp124_ = self->priv->_struct_creation;
		if (_tmp124_) {
			ValaSourceReference* _tmp125_;
			ValaSourceReference* _tmp126_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp125_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp126_ = _tmp125_;
			vala_report_error (_tmp126_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp127_ = cl;
		_tmp128_ = vala_class_get_is_abstract (_tmp127_);
		_tmp129_ = _tmp128_;
		if (_tmp129_) {
			ValaSourceReference* _tmp130_;
			ValaSourceReference* _tmp131_;
			ValaClass* _tmp132_;
			gchar* _tmp133_;
			gchar* _tmp134_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp131_ = _tmp130_;
			_tmp132_ = cl;
			_tmp133_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp132_);
			_tmp134_ = _tmp133_;
			vala_report_error (_tmp131_, "Can't create instance of abstract class `%s'", _tmp134_);
			_g_free0 (_tmp134_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp135_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp136_ = _tmp135_;
		if (_tmp136_ == NULL) {
			ValaClass* _tmp137_;
			ValaCreationMethod* _tmp138_;
			ValaCreationMethod* _tmp139_;
			ValaSymbol* _tmp140_;
			ValaSymbol* _tmp141_;
			ValaSymbol* _tmp147_;
			ValaSymbol* _tmp148_;
			ValaSymbol* _tmp149_;
			ValaSymbol* _tmp150_;
			ValaVersionAttribute* _tmp151_;
			ValaVersionAttribute* _tmp152_;
			ValaSourceReference* _tmp153_;
			ValaSourceReference* _tmp154_;
			_tmp137_ = cl;
			_tmp138_ = vala_class_get_default_construction_method (_tmp137_);
			_tmp139_ = _tmp138_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp139_);
			_tmp140_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp141_ = _tmp140_;
			if (_tmp141_ == NULL) {
				ValaSourceReference* _tmp142_;
				ValaSourceReference* _tmp143_;
				ValaClass* _tmp144_;
				gchar* _tmp145_;
				gchar* _tmp146_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp143_ = _tmp142_;
				_tmp144_ = cl;
				_tmp145_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp144_);
				_tmp146_ = _tmp145_;
				vala_report_error (_tmp143_, "`%s' does not have a default constructor", _tmp146_);
				_g_free0 (_tmp146_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp147_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp148_ = _tmp147_;
			vala_symbol_set_used (_tmp148_, TRUE);
			_tmp149_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_symbol_get_version (_tmp150_);
			_tmp152_ = _tmp151_;
			_tmp153_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp154_ = _tmp153_;
			vala_version_attribute_check (_tmp152_, context, _tmp154_);
		}
		_tmp156_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp157_ = _tmp156_;
		if (_tmp157_ != NULL) {
			gboolean _tmp158_ = FALSE;
			ValaSymbol* _tmp159_;
			ValaSymbol* _tmp160_;
			ValaSymbolAccessibility _tmp161_;
			ValaSymbolAccessibility _tmp162_;
			_tmp159_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp160_ = _tmp159_;
			_tmp161_ = vala_symbol_get_access (_tmp160_);
			_tmp162_ = _tmp161_;
			if (_tmp162_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp158_ = TRUE;
			} else {
				ValaSymbol* _tmp163_;
				ValaSymbol* _tmp164_;
				ValaSymbolAccessibility _tmp165_;
				ValaSymbolAccessibility _tmp166_;
				_tmp163_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp164_ = _tmp163_;
				_tmp165_ = vala_symbol_get_access (_tmp164_);
				_tmp166_ = _tmp165_;
				_tmp158_ = _tmp166_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp155_ = _tmp158_;
		} else {
			_tmp155_ = FALSE;
		}
		if (_tmp155_) {
			gboolean in_target_type = FALSE;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp167_;
				ValaSemanticAnalyzer* _tmp168_;
				ValaSymbol* _tmp169_;
				ValaSymbol* _tmp170_;
				ValaSymbol* _tmp171_;
				_tmp167_ = vala_code_context_get_analyzer (context);
				_tmp168_ = _tmp167_;
				_tmp169_ = vala_semantic_analyzer_get_current_symbol (_tmp168_);
				_tmp170_ = _tmp169_;
				_tmp171_ = _vala_code_node_ref0 (_tmp170_);
				this_symbol = _tmp171_;
				{
					gboolean _tmp172_ = FALSE;
					_tmp172_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp177_;
						ValaSymbol* _tmp178_;
						ValaClass* _tmp179_;
						if (!_tmp172_) {
							ValaSymbol* _tmp173_;
							ValaSymbol* _tmp174_;
							ValaSymbol* _tmp175_;
							ValaSymbol* _tmp176_;
							_tmp173_ = this_symbol;
							_tmp174_ = vala_symbol_get_parent_symbol (_tmp173_);
							_tmp175_ = _tmp174_;
							_tmp176_ = _vala_code_node_ref0 (_tmp175_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp176_;
						}
						_tmp172_ = FALSE;
						_tmp177_ = this_symbol;
						if (!(_tmp177_ != NULL)) {
							break;
						}
						_tmp178_ = this_symbol;
						_tmp179_ = cl;
						if (_tmp178_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp179_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp180_;
				ValaSourceReference* _tmp181_;
				ValaSymbol* _tmp182_;
				ValaSymbol* _tmp183_;
				gchar* _tmp184_;
				gchar* _tmp185_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp180_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp181_ = _tmp180_;
				_tmp182_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp183_ = _tmp182_;
				_tmp184_ = vala_symbol_get_full_name (_tmp183_);
				_tmp185_ = _tmp184_;
				vala_report_error (_tmp181_, "Access to non-public constructor `%s' denied", _tmp185_);
				_g_free0 (_tmp185_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp186_;
			ValaClass* _tmp187_;
			gchar* _tmp188_;
			gchar* _tmp189_;
			gboolean _tmp190_;
			ValaClass* _tmp193_;
			ValaClass* _tmp194_;
			ValaClass* _tmp195_;
			ValaClass* _tmp196_;
			_tmp186_ = cl;
			if (!(_tmp186_ != NULL)) {
				break;
			}
			_tmp187_ = cl;
			_tmp188_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp187_, "CCode", "ref_sink_function", NULL);
			_tmp189_ = _tmp188_;
			_tmp190_ = _tmp189_ != NULL;
			_g_free0 (_tmp189_);
			if (_tmp190_) {
				ValaDataType* _tmp191_;
				ValaDataType* _tmp192_;
				_tmp191_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp192_ = _tmp191_;
				vala_data_type_set_floating_reference (_tmp192_, TRUE);
				break;
			}
			_tmp193_ = cl;
			_tmp194_ = vala_class_get_base_class (_tmp193_);
			_tmp195_ = _tmp194_;
			_tmp196_ = _vala_code_node_ref0 (_tmp195_);
			_vala_code_node_unref0 (cl);
			cl = _tmp196_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp197_;
		_tmp197_ = type;
		if (VALA_IS_STRUCT (_tmp197_)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp198_;
			ValaStruct* _tmp199_;
			ValaStruct* _tmp200_;
			ValaList* _tmp201_;
			gint _tmp202_;
			gint _tmp203_;
			gboolean _tmp204_ = FALSE;
			gboolean _tmp205_;
			ValaSymbol* _tmp210_;
			ValaSymbol* _tmp211_;
			gboolean _tmp215_ = FALSE;
			gboolean _tmp216_ = FALSE;
			gboolean _tmp217_ = FALSE;
			ValaProfile _tmp218_;
			ValaProfile _tmp219_;
			_tmp198_ = type;
			_tmp199_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp198_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp199_;
			_tmp200_ = st;
			_tmp201_ = vala_struct_get_type_parameters (_tmp200_);
			_tmp202_ = vala_collection_get_size ((ValaCollection*) _tmp201_);
			_tmp203_ = _tmp202_;
			expected_num_type_args = _tmp203_;
			_tmp205_ = self->priv->_struct_creation;
			if (!_tmp205_) {
				gboolean _tmp206_;
				gboolean _tmp207_;
				_tmp206_ = vala_code_context_get_deprecated (context);
				_tmp207_ = _tmp206_;
				_tmp204_ = !_tmp207_;
			} else {
				_tmp204_ = FALSE;
			}
			if (_tmp204_) {
				ValaSourceReference* _tmp208_;
				ValaSourceReference* _tmp209_;
				_tmp208_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp209_ = _tmp208_;
				vala_report_warning (_tmp209_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp210_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp211_ = _tmp210_;
			if (_tmp211_ == NULL) {
				ValaStruct* _tmp212_;
				ValaCreationMethod* _tmp213_;
				ValaCreationMethod* _tmp214_;
				_tmp212_ = st;
				_tmp213_ = vala_struct_get_default_construction_method (_tmp212_);
				_tmp214_ = _tmp213_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp214_);
			}
			_tmp218_ = vala_code_context_get_profile (context);
			_tmp219_ = _tmp218_;
			if (_tmp219_ == VALA_PROFILE_GOBJECT) {
				ValaStruct* _tmp220_;
				_tmp220_ = st;
				_tmp217_ = vala_struct_is_simple_type (_tmp220_);
			} else {
				_tmp217_ = FALSE;
			}
			if (_tmp217_) {
				ValaSymbol* _tmp221_;
				ValaSymbol* _tmp222_;
				_tmp221_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp222_ = _tmp221_;
				_tmp216_ = _tmp222_ == NULL;
			} else {
				_tmp216_ = FALSE;
			}
			if (_tmp216_) {
				ValaList* _tmp223_;
				gint _tmp224_;
				gint _tmp225_;
				_tmp223_ = self->priv->object_initializer;
				_tmp224_ = vala_collection_get_size ((ValaCollection*) _tmp223_);
				_tmp225_ = _tmp224_;
				_tmp215_ = _tmp225_ == 0;
			} else {
				_tmp215_ = FALSE;
			}
			if (_tmp215_) {
				ValaSourceReference* _tmp226_;
				ValaSourceReference* _tmp227_;
				ValaStruct* _tmp228_;
				gchar* _tmp229_;
				gchar* _tmp230_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp226_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp227_ = _tmp226_;
				_tmp228_ = st;
				_tmp229_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp228_);
				_tmp230_ = _tmp229_;
				vala_report_error (_tmp227_, "`%s' does not have a default constructor", _tmp230_);
				_g_free0 (_tmp230_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	if (expected_num_type_args > given_num_type_args) {
		ValaSourceReference* _tmp231_;
		ValaSourceReference* _tmp232_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp231_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp232_ = _tmp231_;
		vala_report_error (_tmp232_, "too few type arguments");
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	} else {
		if (expected_num_type_args < given_num_type_args) {
			ValaSourceReference* _tmp233_;
			ValaSourceReference* _tmp234_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp233_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp234_ = _tmp233_;
			vala_report_error (_tmp234_, "too many type arguments");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
	}
	_tmp236_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp237_ = _tmp236_;
	if (_tmp237_ == NULL) {
		ValaList* _tmp238_;
		gint _tmp239_;
		gint _tmp240_;
		_tmp238_ = self->priv->argument_list;
		_tmp239_ = vala_collection_get_size ((ValaCollection*) _tmp238_);
		_tmp240_ = _tmp239_;
		_tmp235_ = _tmp240_ != 0;
	} else {
		_tmp235_ = FALSE;
	}
	if (_tmp235_) {
		ValaSourceReference* _tmp241_;
		ValaSourceReference* _tmp242_;
		ValaTypeSymbol* _tmp243_;
		gchar* _tmp244_;
		gchar* _tmp245_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp241_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp242_ = _tmp241_;
		_tmp243_ = type;
		_tmp244_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp243_);
		_tmp245_ = _tmp244_;
		vala_report_error (_tmp242_, "No arguments allowed when constructing type `%s'", _tmp245_);
		_g_free0 (_tmp245_);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp246_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp247_ = _tmp246_;
	if (VALA_IS_METHOD (_tmp247_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp248_;
		ValaSymbol* _tmp249_;
		ValaMethod* _tmp250_;
		gboolean _tmp251_;
		gboolean _tmp252_;
		ValaExpression* last_arg = NULL;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp277_;
		ValaIterator* _tmp278_;
		ValaMethod* _tmp329_;
		gboolean _tmp330_;
		gboolean _tmp331_;
		ValaSemanticAnalyzer* _tmp394_;
		ValaSemanticAnalyzer* _tmp395_;
		ValaMethod* _tmp396_;
		ValaMethodType* _tmp397_;
		ValaMethodType* _tmp398_;
		ValaMethod* _tmp399_;
		ValaList* _tmp400_;
		ValaList* _tmp401_;
		_tmp248_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp249_ = _tmp248_;
		_tmp250_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp249_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp250_;
		_tmp251_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
		_tmp252_ = _tmp251_;
		if (_tmp252_) {
			ValaMethod* _tmp253_;
			gboolean _tmp254_;
			gboolean _tmp255_;
			gboolean _tmp258_ = FALSE;
			ValaSemanticAnalyzer* _tmp259_;
			ValaSemanticAnalyzer* _tmp260_;
			ValaMethod* _tmp261_;
			ValaMethod* _tmp262_;
			_tmp253_ = m;
			_tmp254_ = vala_method_get_coroutine (_tmp253_);
			_tmp255_ = _tmp254_;
			if (!_tmp255_) {
				ValaSourceReference* _tmp256_;
				ValaSourceReference* _tmp257_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp256_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp257_ = _tmp256_;
				vala_report_error (_tmp257_, "yield expression requires async method");
			}
			_tmp259_ = vala_code_context_get_analyzer (context);
			_tmp260_ = _tmp259_;
			_tmp261_ = vala_semantic_analyzer_get_current_method (_tmp260_);
			_tmp262_ = _tmp261_;
			if (_tmp262_ == NULL) {
				_tmp258_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp263_;
				ValaSemanticAnalyzer* _tmp264_;
				ValaMethod* _tmp265_;
				ValaMethod* _tmp266_;
				gboolean _tmp267_;
				gboolean _tmp268_;
				_tmp263_ = vala_code_context_get_analyzer (context);
				_tmp264_ = _tmp263_;
				_tmp265_ = vala_semantic_analyzer_get_current_method (_tmp264_);
				_tmp266_ = _tmp265_;
				_tmp267_ = vala_method_get_coroutine (_tmp266_);
				_tmp268_ = _tmp267_;
				_tmp258_ = !_tmp268_;
			}
			if (_tmp258_) {
				ValaSourceReference* _tmp269_;
				ValaSourceReference* _tmp270_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp269_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp270_ = _tmp269_;
				vala_report_error (_tmp270_, "yield expression not available outside async method");
			}
		} else {
			ValaMethod* _tmp271_;
			_tmp271_ = m;
			if (VALA_IS_CREATION_METHOD (_tmp271_)) {
				ValaMethod* _tmp272_;
				gboolean _tmp273_;
				gboolean _tmp274_;
				_tmp272_ = m;
				_tmp273_ = vala_method_get_coroutine (_tmp272_);
				_tmp274_ = _tmp273_;
				if (_tmp274_) {
					ValaSourceReference* _tmp275_;
					ValaSourceReference* _tmp276_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp275_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp276_ = _tmp275_;
					vala_report_error (_tmp276_, "missing `yield' before async creation expression");
				}
			}
		}
		last_arg = NULL;
		_tmp277_ = self->priv->argument_list;
		_tmp278_ = vala_iterable_iterator ((ValaIterable*) _tmp277_);
		arg_it = _tmp278_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp279_;
			ValaList* _tmp280_;
			gint _param_size = 0;
			ValaList* _tmp281_;
			gint _tmp282_;
			gint _tmp283_;
			gint _param_index = 0;
			_tmp279_ = m;
			_tmp280_ = vala_callable_get_parameters ((ValaCallable*) _tmp279_);
			_param_list = _tmp280_;
			_tmp281_ = _param_list;
			_tmp282_ = vala_collection_get_size ((ValaCollection*) _tmp281_);
			_tmp283_ = _tmp282_;
			_param_size = _tmp283_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp284_;
				gint _tmp285_;
				ValaParameter* param = NULL;
				ValaList* _tmp286_;
				gpointer _tmp287_;
				ValaParameter* _tmp288_;
				ValaParameter* _tmp289_;
				gboolean _tmp290_;
				gboolean _tmp291_;
				ValaParameter* _tmp292_;
				gboolean _tmp293_;
				gboolean _tmp294_;
				ValaIterator* _tmp312_;
				_param_index = _param_index + 1;
				_tmp284_ = _param_index;
				_tmp285_ = _param_size;
				if (!(_tmp284_ < _tmp285_)) {
					break;
				}
				_tmp286_ = _param_list;
				_tmp287_ = vala_list_get (_tmp286_, _param_index);
				param = (ValaParameter*) _tmp287_;
				_tmp288_ = param;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp288_, context)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp289_ = param;
				_tmp290_ = vala_parameter_get_ellipsis (_tmp289_);
				_tmp291_ = _tmp290_;
				if (_tmp291_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp292_ = param;
				_tmp293_ = vala_parameter_get_params_array (_tmp292_);
				_tmp294_ = _tmp293_;
				if (_tmp294_) {
					ValaArrayType* array_type = NULL;
					ValaParameter* _tmp295_;
					ValaDataType* _tmp296_;
					ValaDataType* _tmp297_;
					ValaArrayType* _tmp298_;
					_tmp295_ = param;
					_tmp296_ = vala_variable_get_variable_type ((ValaVariable*) _tmp295_);
					_tmp297_ = _tmp296_;
					_tmp298_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp297_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					array_type = _tmp298_;
					while (TRUE) {
						ValaIterator* _tmp299_;
						ValaExpression* arg = NULL;
						ValaIterator* _tmp300_;
						gpointer _tmp301_;
						ValaExpression* _tmp302_;
						ValaArrayType* _tmp303_;
						ValaDataType* _tmp304_;
						ValaDataType* _tmp305_;
						ValaExpression* _tmp306_;
						ValaDataType* _tmp307_;
						ValaDataType* _tmp308_;
						ValaArrayType* _tmp309_;
						gboolean _tmp310_;
						gboolean _tmp311_;
						_tmp299_ = arg_it;
						if (!vala_iterator_next (_tmp299_)) {
							break;
						}
						_tmp300_ = arg_it;
						_tmp301_ = vala_iterator_get (_tmp300_);
						arg = (ValaExpression*) _tmp301_;
						_tmp302_ = arg;
						_tmp303_ = array_type;
						_tmp304_ = vala_array_type_get_element_type (_tmp303_);
						_tmp305_ = _tmp304_;
						vala_expression_set_target_type (_tmp302_, _tmp305_);
						_tmp306_ = arg;
						_tmp307_ = vala_expression_get_target_type (_tmp306_);
						_tmp308_ = _tmp307_;
						_tmp309_ = array_type;
						_tmp310_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp309_);
						_tmp311_ = _tmp310_;
						vala_data_type_set_value_owned (_tmp308_, _tmp311_);
						_vala_code_node_unref0 (arg);
					}
					_vala_code_node_unref0 (array_type);
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp312_ = arg_it;
				if (vala_iterator_next (_tmp312_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp313_;
					gpointer _tmp314_;
					ValaExpression* _tmp315_;
					ValaParameter* _tmp316_;
					ValaDataType* _tmp317_;
					ValaDataType* _tmp318_;
					ValaExpression* _tmp319_;
					ValaExpression* _tmp320_;
					ValaDataType* _tmp321_;
					ValaDataType* _tmp322_;
					ValaDataType* _tmp323_;
					ValaDataType* _tmp324_;
					ValaDataType* _tmp325_;
					ValaDataType* _tmp326_;
					ValaExpression* _tmp327_;
					ValaExpression* _tmp328_;
					_tmp313_ = arg_it;
					_tmp314_ = vala_iterator_get (_tmp313_);
					arg = (ValaExpression*) _tmp314_;
					_tmp315_ = arg;
					_tmp316_ = param;
					_tmp317_ = vala_variable_get_variable_type ((ValaVariable*) _tmp316_);
					_tmp318_ = _tmp317_;
					vala_expression_set_formal_target_type (_tmp315_, _tmp318_);
					_tmp319_ = arg;
					_tmp320_ = arg;
					_tmp321_ = vala_expression_get_formal_target_type (_tmp320_);
					_tmp322_ = _tmp321_;
					_tmp323_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp324_ = _tmp323_;
					_tmp325_ = vala_data_type_get_actual_type (_tmp322_, _tmp324_, NULL, (ValaCodeNode*) self);
					_tmp326_ = _tmp325_;
					vala_expression_set_target_type (_tmp319_, _tmp326_);
					_vala_code_node_unref0 (_tmp326_);
					_tmp327_ = arg;
					_tmp328_ = _vala_code_node_ref0 (_tmp327_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp328_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
		}
		_tmp329_ = m;
		_tmp330_ = vala_method_get_printf_format (_tmp329_);
		_tmp331_ = _tmp330_;
		if (_tmp331_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp332_;
			ValaStringLiteral* _tmp376_;
			format_literal = NULL;
			_tmp332_ = last_arg;
			if (VALA_IS_NULL_LITERAL (_tmp332_)) {
			} else {
				ValaExpression* _tmp333_;
				_tmp333_ = last_arg;
				if (_tmp333_ != NULL) {
					ValaExpression* _tmp334_;
					ValaStringLiteral* _tmp335_;
					gboolean _tmp336_ = FALSE;
					ValaStringLiteral* _tmp337_;
					_tmp334_ = last_arg;
					_tmp335_ = vala_string_literal_get_format_literal (_tmp334_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp335_;
					_tmp337_ = format_literal;
					if (_tmp337_ == NULL) {
						ValaList* _tmp338_;
						gint _tmp339_;
						gint _tmp340_;
						ValaMethod* _tmp341_;
						ValaList* _tmp342_;
						gint _tmp343_;
						gint _tmp344_;
						_tmp338_ = self->priv->argument_list;
						_tmp339_ = vala_collection_get_size ((ValaCollection*) _tmp338_);
						_tmp340_ = _tmp339_;
						_tmp341_ = m;
						_tmp342_ = vala_callable_get_parameters ((ValaCallable*) _tmp341_);
						_tmp343_ = vala_collection_get_size ((ValaCollection*) _tmp342_);
						_tmp344_ = _tmp343_;
						_tmp336_ = _tmp340_ == (_tmp344_ - 1);
					} else {
						_tmp336_ = FALSE;
					}
					if (_tmp336_) {
						ValaStringLiteral* _tmp345_;
						ValaStringLiteral* _tmp346_;
						ValaSemanticAnalyzer* _tmp347_;
						ValaSemanticAnalyzer* _tmp348_;
						ValaDataType* _tmp349_;
						ValaDataType* _tmp350_;
						ValaDataType* _tmp351_;
						ValaList* _tmp352_;
						ValaList* _tmp353_;
						gint _tmp354_;
						gint _tmp355_;
						ValaStringLiteral* _tmp356_;
						ValaList* _tmp357_;
						ValaIterator* _tmp358_;
						_tmp345_ = vala_string_literal_new ("\"%s\"", NULL);
						_vala_code_node_unref0 (format_literal);
						format_literal = _tmp345_;
						_tmp346_ = format_literal;
						_tmp347_ = vala_code_context_get_analyzer (context);
						_tmp348_ = _tmp347_;
						_tmp349_ = _tmp348_->string_type;
						_tmp350_ = vala_data_type_copy (_tmp349_);
						_tmp351_ = _tmp350_;
						vala_expression_set_target_type ((ValaExpression*) _tmp346_, _tmp351_);
						_vala_code_node_unref0 (_tmp351_);
						_tmp352_ = self->priv->argument_list;
						_tmp353_ = self->priv->argument_list;
						_tmp354_ = vala_collection_get_size ((ValaCollection*) _tmp353_);
						_tmp355_ = _tmp354_;
						_tmp356_ = format_literal;
						vala_list_insert (_tmp352_, _tmp355_ - 1, (ValaExpression*) _tmp356_);
						_tmp357_ = self->priv->argument_list;
						_tmp358_ = vala_iterable_iterator ((ValaIterable*) _tmp357_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp358_;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp359_;
							ValaList* _tmp360_;
							gint _param_size = 0;
							ValaList* _tmp361_;
							gint _tmp362_;
							gint _tmp363_;
							gint _param_index = 0;
							_tmp359_ = m;
							_tmp360_ = vala_callable_get_parameters ((ValaCallable*) _tmp359_);
							_param_list = _tmp360_;
							_tmp361_ = _param_list;
							_tmp362_ = vala_collection_get_size ((ValaCollection*) _tmp361_);
							_tmp363_ = _tmp362_;
							_param_size = _tmp363_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp364_;
								gint _tmp365_;
								ValaParameter* param = NULL;
								ValaList* _tmp366_;
								gpointer _tmp367_;
								gboolean _tmp368_ = FALSE;
								ValaParameter* _tmp369_;
								gboolean _tmp370_;
								gboolean _tmp371_;
								ValaIterator* _tmp375_;
								_param_index = _param_index + 1;
								_tmp364_ = _param_index;
								_tmp365_ = _param_size;
								if (!(_tmp364_ < _tmp365_)) {
									break;
								}
								_tmp366_ = _param_list;
								_tmp367_ = vala_list_get (_tmp366_, _param_index);
								param = (ValaParameter*) _tmp367_;
								_tmp369_ = param;
								_tmp370_ = vala_parameter_get_ellipsis (_tmp369_);
								_tmp371_ = _tmp370_;
								if (_tmp371_) {
									_tmp368_ = TRUE;
								} else {
									ValaParameter* _tmp372_;
									gboolean _tmp373_;
									gboolean _tmp374_;
									_tmp372_ = param;
									_tmp373_ = vala_parameter_get_params_array (_tmp372_);
									_tmp374_ = _tmp373_;
									_tmp368_ = _tmp374_;
								}
								if (_tmp368_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp375_ = arg_it;
								vala_iterator_next (_tmp375_);
								_vala_code_node_unref0 (param);
							}
						}
					}
				}
			}
			_tmp376_ = format_literal;
			if (_tmp376_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp377_;
				gchar* _tmp378_;
				ValaSemanticAnalyzer* _tmp379_;
				ValaSemanticAnalyzer* _tmp380_;
				const gchar* _tmp381_;
				ValaIterator* _tmp382_;
				ValaSourceReference* _tmp383_;
				ValaSourceReference* _tmp384_;
				_tmp377_ = format_literal;
				_tmp378_ = vala_string_literal_eval (_tmp377_);
				format = _tmp378_;
				_tmp379_ = vala_code_context_get_analyzer (context);
				_tmp380_ = _tmp379_;
				_tmp381_ = format;
				_tmp382_ = arg_it;
				_tmp383_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp384_ = _tmp383_;
				if (!vala_semantic_analyzer_check_print_format (_tmp380_, _tmp381_, _tmp382_, _tmp384_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp385_;
			gint _arg_size = 0;
			ValaList* _tmp386_;
			gint _tmp387_;
			gint _tmp388_;
			gint _arg_index = 0;
			_tmp385_ = self->priv->argument_list;
			_arg_list = _tmp385_;
			_tmp386_ = _arg_list;
			_tmp387_ = vala_collection_get_size ((ValaCollection*) _tmp386_);
			_tmp388_ = _tmp387_;
			_arg_size = _tmp388_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp389_;
				gint _tmp390_;
				ValaExpression* arg = NULL;
				ValaList* _tmp391_;
				gpointer _tmp392_;
				ValaExpression* _tmp393_;
				_arg_index = _arg_index + 1;
				_tmp389_ = _arg_index;
				_tmp390_ = _arg_size;
				if (!(_tmp389_ < _tmp390_)) {
					break;
				}
				_tmp391_ = _arg_list;
				_tmp392_ = vala_list_get (_tmp391_, _arg_index);
				arg = (ValaExpression*) _tmp392_;
				_tmp393_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp393_, context);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp394_ = vala_code_context_get_analyzer (context);
		_tmp395_ = _tmp394_;
		_tmp396_ = m;
		_tmp397_ = vala_method_type_new (_tmp396_);
		_tmp398_ = _tmp397_;
		_tmp399_ = m;
		_tmp400_ = vala_callable_get_parameters ((ValaCallable*) _tmp399_);
		_tmp401_ = self->priv->argument_list;
		vala_semantic_analyzer_check_arguments (_tmp395_, (ValaExpression*) self, (ValaDataType*) _tmp398_, _tmp400_, _tmp401_);
		_vala_code_node_unref0 (_tmp398_);
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp402_;
		ValaDataType* _tmp403_;
		_tmp402_ = vala_object_creation_expression_get_type_reference (self);
		_tmp403_ = _tmp402_;
		if (VALA_IS_ERROR_TYPE (_tmp403_)) {
			ValaDataType* _tmp404_;
			ValaDataType* _tmp405_;
			ValaMemberAccess* _tmp408_;
			ValaMemberAccess* _tmp409_;
			ValaList* _tmp430_;
			gint _tmp431_;
			gint _tmp432_;
			_tmp404_ = vala_object_creation_expression_get_type_reference (self);
			_tmp405_ = _tmp404_;
			if (_tmp405_ != NULL) {
				ValaDataType* _tmp406_;
				ValaDataType* _tmp407_;
				_tmp406_ = vala_object_creation_expression_get_type_reference (self);
				_tmp407_ = _tmp406_;
				vala_code_node_check ((ValaCodeNode*) _tmp407_, context);
			}
			_tmp408_ = vala_object_creation_expression_get_member_name (self);
			_tmp409_ = _tmp408_;
			if (_tmp409_ != NULL) {
				ValaMemberAccess* _tmp410_;
				ValaMemberAccess* _tmp411_;
				_tmp410_ = vala_object_creation_expression_get_member_name (self);
				_tmp411_ = _tmp410_;
				vala_code_node_check ((ValaCodeNode*) _tmp411_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp412_;
				gint _arg_size = 0;
				ValaList* _tmp413_;
				gint _tmp414_;
				gint _tmp415_;
				gint _arg_index = 0;
				_tmp412_ = self->priv->argument_list;
				_arg_list = _tmp412_;
				_tmp413_ = _arg_list;
				_tmp414_ = vala_collection_get_size ((ValaCollection*) _tmp413_);
				_tmp415_ = _tmp414_;
				_arg_size = _tmp415_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp416_;
					gint _tmp417_;
					ValaExpression* arg = NULL;
					ValaList* _tmp418_;
					gpointer _tmp419_;
					ValaExpression* _tmp420_;
					_arg_index = _arg_index + 1;
					_tmp416_ = _arg_index;
					_tmp417_ = _arg_size;
					if (!(_tmp416_ < _tmp417_)) {
						break;
					}
					_tmp418_ = _arg_list;
					_tmp419_ = vala_list_get (_tmp418_, _arg_index);
					arg = (ValaExpression*) _tmp419_;
					_tmp420_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp420_, context);
					_vala_code_node_unref0 (arg);
				}
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp421_;
				gint _init_size = 0;
				ValaList* _tmp422_;
				gint _tmp423_;
				gint _tmp424_;
				gint _init_index = 0;
				_tmp421_ = self->priv->object_initializer;
				_init_list = _tmp421_;
				_tmp422_ = _init_list;
				_tmp423_ = vala_collection_get_size ((ValaCollection*) _tmp422_);
				_tmp424_ = _tmp423_;
				_init_size = _tmp424_;
				_init_index = -1;
				while (TRUE) {
					gint _tmp425_;
					gint _tmp426_;
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp427_;
					gpointer _tmp428_;
					ValaMemberInitializer* _tmp429_;
					_init_index = _init_index + 1;
					_tmp425_ = _init_index;
					_tmp426_ = _init_size;
					if (!(_tmp425_ < _tmp426_)) {
						break;
					}
					_tmp427_ = _init_list;
					_tmp428_ = vala_list_get (_tmp427_, _init_index);
					init = (ValaMemberInitializer*) _tmp428_;
					_tmp429_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp429_, context);
					_vala_code_node_unref0 (init);
				}
			}
			_tmp430_ = self->priv->argument_list;
			_tmp431_ = vala_collection_get_size ((ValaCollection*) _tmp430_);
			_tmp432_ = _tmp431_;
			if (_tmp432_ == 0) {
				ValaSourceReference* _tmp433_;
				ValaSourceReference* _tmp434_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp433_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp434_ = _tmp433_;
				vala_report_error (_tmp434_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp435_;
				ValaIterator* _tmp436_;
				ValaIterator* _tmp437_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp438_;
				gpointer _tmp439_;
				gboolean _tmp440_ = FALSE;
				ValaExpression* _tmp441_;
				ValaDataType* _tmp442_;
				ValaDataType* _tmp443_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp452_;
				ValaStringLiteral* _tmp453_;
				ValaStringLiteral* _tmp454_;
				ValaList* _tmp463_;
				ValaIterator* _tmp464_;
				ValaIterator* _tmp465_;
				ValaSemanticAnalyzer* _tmp466_;
				ValaSemanticAnalyzer* _tmp467_;
				ValaIterator* _tmp468_;
				ValaSourceReference* _tmp469_;
				ValaSourceReference* _tmp470_;
				_tmp435_ = self->priv->argument_list;
				_tmp436_ = vala_iterable_iterator ((ValaIterable*) _tmp435_);
				arg_it = _tmp436_;
				_tmp437_ = arg_it;
				vala_iterator_next (_tmp437_);
				_tmp438_ = arg_it;
				_tmp439_ = vala_iterator_get (_tmp438_);
				ex = (ValaExpression*) _tmp439_;
				_tmp441_ = ex;
				_tmp442_ = vala_expression_get_value_type (_tmp441_);
				_tmp443_ = _tmp442_;
				if (_tmp443_ == NULL) {
					_tmp440_ = TRUE;
				} else {
					ValaExpression* _tmp444_;
					ValaDataType* _tmp445_;
					ValaDataType* _tmp446_;
					ValaSemanticAnalyzer* _tmp447_;
					ValaSemanticAnalyzer* _tmp448_;
					ValaDataType* _tmp449_;
					_tmp444_ = ex;
					_tmp445_ = vala_expression_get_value_type (_tmp444_);
					_tmp446_ = _tmp445_;
					_tmp447_ = vala_code_context_get_analyzer (context);
					_tmp448_ = _tmp447_;
					_tmp449_ = _tmp448_->string_type;
					_tmp440_ = !vala_data_type_compatible (_tmp446_, _tmp449_);
				}
				if (_tmp440_) {
					ValaSourceReference* _tmp450_;
					ValaSourceReference* _tmp451_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp450_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp451_ = _tmp450_;
					vala_report_error (_tmp451_, "Invalid type for argument 1");
				}
				_tmp452_ = ex;
				_tmp453_ = vala_string_literal_get_format_literal (_tmp452_);
				format_literal = _tmp453_;
				_tmp454_ = format_literal;
				if (_tmp454_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp455_;
					gchar* _tmp456_;
					ValaSemanticAnalyzer* _tmp457_;
					ValaSemanticAnalyzer* _tmp458_;
					const gchar* _tmp459_;
					ValaIterator* _tmp460_;
					ValaSourceReference* _tmp461_;
					ValaSourceReference* _tmp462_;
					_tmp455_ = format_literal;
					_tmp456_ = vala_string_literal_eval (_tmp455_);
					format = _tmp456_;
					_tmp457_ = vala_code_context_get_analyzer (context);
					_tmp458_ = _tmp457_;
					_tmp459_ = format;
					_tmp460_ = arg_it;
					_tmp461_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp462_ = _tmp461_;
					if (!vala_semantic_analyzer_check_print_format (_tmp458_, _tmp459_, _tmp460_, _tmp462_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp463_ = self->priv->argument_list;
				_tmp464_ = vala_iterable_iterator ((ValaIterable*) _tmp463_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp464_;
				_tmp465_ = arg_it;
				vala_iterator_next (_tmp465_);
				_tmp466_ = vala_code_context_get_analyzer (context);
				_tmp467_ = _tmp466_;
				_tmp468_ = arg_it;
				_tmp469_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp470_ = _tmp469_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp467_, _tmp468_, 1, _tmp470_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp471_;
		gint _arg_size = 0;
		ValaList* _tmp472_;
		gint _tmp473_;
		gint _tmp474_;
		gint _arg_index = 0;
		_tmp471_ = self->priv->argument_list;
		_arg_list = _tmp471_;
		_tmp472_ = _arg_list;
		_tmp473_ = vala_collection_get_size ((ValaCollection*) _tmp472_);
		_tmp474_ = _tmp473_;
		_arg_size = _tmp474_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp475_;
			gint _tmp476_;
			ValaExpression* arg = NULL;
			ValaList* _tmp477_;
			gpointer _tmp478_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp479_;
			gboolean _tmp480_ = FALSE;
			ValaSizeofExpression* _tmp481_;
			_arg_index = _arg_index + 1;
			_tmp475_ = _arg_index;
			_tmp476_ = _arg_size;
			if (!(_tmp475_ < _tmp476_)) {
				break;
			}
			_tmp477_ = _arg_list;
			_tmp478_ = vala_list_get (_tmp477_, _arg_index);
			arg = (ValaExpression*) _tmp478_;
			_tmp479_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp479_) ? ((ValaSizeofExpression*) _tmp479_) : NULL;
			_tmp481_ = sizeof_expr;
			if (_tmp481_ != NULL) {
				ValaSizeofExpression* _tmp482_;
				ValaDataType* _tmp483_;
				ValaDataType* _tmp484_;
				_tmp482_ = sizeof_expr;
				_tmp483_ = vala_sizeof_expression_get_type_reference (_tmp482_);
				_tmp484_ = _tmp483_;
				_tmp480_ = VALA_IS_GENERIC_TYPE (_tmp484_);
			} else {
				_tmp480_ = FALSE;
			}
			if (_tmp480_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp485_;
				ValaDataType* _tmp486_;
				ValaDataType* _tmp487_;
				ValaDataType* _tmp488_;
				ValaDataType* _tmp489_;
				ValaDataType* _tmp490_;
				ValaDataType* _tmp491_;
				ValaList* _tmp492_;
				ValaDataType* _tmp493_;
				ValaExpression* _tmp494_;
				ValaDataType* _tmp495_;
				ValaSourceReference* _tmp496_;
				ValaSourceReference* _tmp497_;
				ValaSizeofExpression* _tmp498_;
				ValaSizeofExpression* _tmp499_;
				_tmp485_ = sizeof_expr;
				_tmp486_ = vala_sizeof_expression_get_type_reference (_tmp485_);
				_tmp487_ = _tmp486_;
				_tmp488_ = vala_object_creation_expression_get_type_reference (self);
				_tmp489_ = _tmp488_;
				_tmp490_ = vala_object_creation_expression_get_type_reference (self);
				_tmp491_ = _tmp490_;
				_tmp492_ = vala_data_type_get_type_arguments (_tmp491_);
				_tmp493_ = vala_data_type_get_actual_type (_tmp487_, _tmp489_, _tmp492_, (ValaCodeNode*) self);
				sizeof_type = _tmp493_;
				_tmp494_ = arg;
				_tmp495_ = sizeof_type;
				_tmp496_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp497_ = _tmp496_;
				_tmp498_ = vala_sizeof_expression_new (_tmp495_, _tmp497_);
				_tmp499_ = _tmp498_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp494_, (ValaExpression*) _tmp499_);
				_vala_code_node_unref0 (_tmp499_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp500_ = type;
	_tmp501_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp500_);
	_tmp502_ = _tmp501_;
	if (!_tmp502_) {
		ValaSemanticAnalyzer* _tmp503_;
		ValaSemanticAnalyzer* _tmp504_;
		ValaDataType* _tmp505_;
		ValaDataType* _tmp506_;
		_tmp503_ = vala_code_context_get_analyzer (context);
		_tmp504_ = _tmp503_;
		_tmp505_ = vala_object_creation_expression_get_type_reference (self);
		_tmp506_ = _tmp505_;
		vala_semantic_analyzer_check_type (_tmp504_, _tmp506_);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp507_;
		gint _init_size = 0;
		ValaList* _tmp508_;
		gint _tmp509_;
		gint _tmp510_;
		gint _init_index = 0;
		_tmp507_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp507_;
		_tmp508_ = _init_list;
		_tmp509_ = vala_collection_get_size ((ValaCollection*) _tmp508_);
		_tmp510_ = _tmp509_;
		_init_size = _tmp510_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp511_;
			gint _tmp512_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp513_;
			gpointer _tmp514_;
			ValaMemberInitializer* _tmp515_;
			ValaExpression* _tmp516_;
			ValaExpression* _tmp517_;
			gint index = 0;
			ValaList* _tmp518_;
			ValaMemberInitializer* _tmp519_;
			ValaList* _tmp520_;
			gpointer _tmp521_;
			ValaMemberInitializer* _tmp522_;
			ValaMemberInitializer* inner_mi = NULL;
			ValaMemberInitializer* _tmp523_;
			ValaExpression* _tmp524_;
			ValaExpression* _tmp525_;
			ValaLocalVariable* local = NULL;
			gchar* _tmp532_;
			gchar* _tmp533_;
			ValaMemberInitializer* _tmp534_;
			ValaExpression* _tmp535_;
			ValaExpression* _tmp536_;
			ValaMemberInitializer* _tmp537_;
			ValaExpression* _tmp538_;
			ValaExpression* _tmp539_;
			ValaSourceReference* _tmp540_;
			ValaSourceReference* _tmp541_;
			ValaLocalVariable* _tmp542_;
			ValaLocalVariable* _tmp543_;
			ValaDeclarationStatement* decl = NULL;
			ValaLocalVariable* _tmp544_;
			ValaMemberInitializer* _tmp545_;
			ValaExpression* _tmp546_;
			ValaExpression* _tmp547_;
			ValaSourceReference* _tmp548_;
			ValaSourceReference* _tmp549_;
			ValaDeclarationStatement* _tmp550_;
			ValaDeclarationStatement* _tmp551_;
			ValaSemanticAnalyzer* _tmp552_;
			ValaSemanticAnalyzer* _tmp553_;
			ValaBlock* _tmp554_;
			ValaDeclarationStatement* _tmp555_;
			_init_index = _init_index + 1;
			_tmp511_ = _init_index;
			_tmp512_ = _init_size;
			if (!(_tmp511_ < _tmp512_)) {
				break;
			}
			_tmp513_ = _init_list;
			_tmp514_ = vala_list_get (_tmp513_, _init_index);
			init = (ValaMemberInitializer*) _tmp514_;
			_tmp515_ = init;
			_tmp516_ = vala_member_initializer_get_initializer (_tmp515_);
			_tmp517_ = _tmp516_;
			if (!VALA_IS_MEMBER_INITIALIZER (_tmp517_)) {
				_vala_code_node_unref0 (init);
				continue;
			}
			_tmp518_ = self->priv->object_initializer;
			_tmp519_ = init;
			index = vala_list_index_of (_tmp518_, _tmp519_);
			_tmp520_ = self->priv->object_initializer;
			_tmp521_ = vala_list_remove_at (_tmp520_, index);
			_tmp522_ = (ValaMemberInitializer*) _tmp521_;
			_vala_code_node_unref0 (_tmp522_);
			_vala_assert (index >= 0, "index >= 0");
			_tmp523_ = init;
			_tmp524_ = vala_member_initializer_get_initializer (_tmp523_);
			_tmp525_ = _tmp524_;
			inner_mi = G_TYPE_CHECK_INSTANCE_CAST (_tmp525_, VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer);
			while (TRUE) {
				ValaMemberInitializer* _tmp526_;
				ValaExpression* _tmp527_;
				ValaExpression* _tmp528_;
				ValaMemberInitializer* _tmp529_;
				ValaExpression* _tmp530_;
				ValaExpression* _tmp531_;
				_tmp526_ = inner_mi;
				_tmp527_ = vala_member_initializer_get_initializer (_tmp526_);
				_tmp528_ = _tmp527_;
				if (!VALA_IS_MEMBER_INITIALIZER (_tmp528_)) {
					break;
				}
				_tmp529_ = inner_mi;
				_tmp530_ = vala_member_initializer_get_initializer (_tmp529_);
				_tmp531_ = _tmp530_;
				inner_mi = G_TYPE_CHECK_INSTANCE_CAST (_tmp531_, VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer);
			}
			_tmp532_ = vala_code_node_get_temp_name ();
			_tmp533_ = _tmp532_;
			_tmp534_ = inner_mi;
			_tmp535_ = vala_member_initializer_get_initializer (_tmp534_);
			_tmp536_ = _tmp535_;
			_tmp537_ = inner_mi;
			_tmp538_ = vala_member_initializer_get_initializer (_tmp537_);
			_tmp539_ = _tmp538_;
			_tmp540_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp539_);
			_tmp541_ = _tmp540_;
			_tmp542_ = vala_local_variable_new (NULL, _tmp533_, _tmp536_, _tmp541_);
			_tmp543_ = _tmp542_;
			_g_free0 (_tmp533_);
			local = _tmp543_;
			_tmp544_ = local;
			_tmp545_ = inner_mi;
			_tmp546_ = vala_member_initializer_get_initializer (_tmp545_);
			_tmp547_ = _tmp546_;
			_tmp548_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp547_);
			_tmp549_ = _tmp548_;
			_tmp550_ = vala_declaration_statement_new ((ValaSymbol*) _tmp544_, _tmp549_);
			decl = _tmp550_;
			_tmp551_ = decl;
			vala_code_node_check ((ValaCodeNode*) _tmp551_, context);
			_tmp552_ = vala_code_context_get_analyzer (context);
			_tmp553_ = _tmp552_;
			_tmp554_ = _tmp553_->insert_block;
			_tmp555_ = decl;
			vala_expression_insert_statement ((ValaExpression*) self, _tmp554_, (ValaStatement*) _tmp555_);
			{
				gboolean _tmp556_ = FALSE;
				_tmp556_ = TRUE;
				while (TRUE) {
					ValaMemberInitializer* member_init = NULL;
					ValaMemberInitializer* _tmp558_;
					const gchar* _tmp559_;
					const gchar* _tmp560_;
					ValaLocalVariable* _tmp561_;
					const gchar* _tmp562_;
					const gchar* _tmp563_;
					ValaMemberInitializer* _tmp564_;
					ValaSourceReference* _tmp565_;
					ValaSourceReference* _tmp566_;
					ValaMemberAccess* _tmp567_;
					ValaMemberAccess* _tmp568_;
					ValaMemberInitializer* _tmp569_;
					ValaSourceReference* _tmp570_;
					ValaSourceReference* _tmp571_;
					ValaMemberInitializer* _tmp572_;
					ValaMemberInitializer* _tmp573_;
					ValaList* _tmp574_;
					gint _tmp575_;
					ValaMemberInitializer* _tmp576_;
					ValaMemberInitializer* _tmp577_;
					ValaCodeNode* _tmp578_;
					ValaCodeNode* _tmp579_;
					if (!_tmp556_) {
						ValaMemberInitializer* _tmp557_;
						_tmp557_ = inner_mi;
						if (!(_tmp557_ != NULL)) {
							break;
						}
					}
					_tmp556_ = FALSE;
					_tmp558_ = inner_mi;
					_tmp559_ = vala_member_initializer_get_name (_tmp558_);
					_tmp560_ = _tmp559_;
					_tmp561_ = local;
					_tmp562_ = vala_symbol_get_name ((ValaSymbol*) _tmp561_);
					_tmp563_ = _tmp562_;
					_tmp564_ = inner_mi;
					_tmp565_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp564_);
					_tmp566_ = _tmp565_;
					_tmp567_ = vala_member_access_new (NULL, _tmp563_, _tmp566_);
					_tmp568_ = _tmp567_;
					_tmp569_ = inner_mi;
					_tmp570_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp569_);
					_tmp571_ = _tmp570_;
					_tmp572_ = vala_member_initializer_new (_tmp560_, (ValaExpression*) _tmp568_, _tmp571_);
					_tmp573_ = _tmp572_;
					_vala_code_node_unref0 (_tmp568_);
					member_init = _tmp573_;
					_tmp574_ = self->priv->object_initializer;
					_tmp575_ = index;
					index = _tmp575_ + 1;
					_tmp576_ = member_init;
					vala_list_insert (_tmp574_, _tmp575_, _tmp576_);
					_tmp577_ = inner_mi;
					_tmp578_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp577_);
					_tmp579_ = _tmp578_;
					inner_mi = VALA_IS_MEMBER_INITIALIZER (_tmp579_) ? ((ValaMemberInitializer*) _tmp579_) : NULL;
					_vala_code_node_unref0 (member_init);
				}
			}
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (init);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp580_;
		gint _init_size = 0;
		ValaList* _tmp581_;
		gint _tmp582_;
		gint _tmp583_;
		gint _init_index = 0;
		_tmp580_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp580_;
		_tmp581_ = _init_list;
		_tmp582_ = vala_collection_get_size ((ValaCollection*) _tmp581_);
		_tmp583_ = _tmp582_;
		_init_size = _tmp583_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp584_;
			gint _tmp585_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp586_;
			gpointer _tmp587_;
			ValaMemberInitializer* _tmp588_;
			ValaMemberInitializer* _tmp589_;
			_init_index = _init_index + 1;
			_tmp584_ = _init_index;
			_tmp585_ = _init_size;
			if (!(_tmp584_ < _tmp585_)) {
				break;
			}
			_tmp586_ = _init_list;
			_tmp587_ = vala_list_get (_tmp586_, _init_index);
			init = (ValaMemberInitializer*) _tmp587_;
			_tmp588_ = init;
			vala_code_node_set_parent_node ((ValaCodeNode*) _tmp588_, (ValaCodeNode*) self);
			_tmp589_ = init;
			vala_code_node_check ((ValaCodeNode*) _tmp589_, context);
			_vala_code_node_unref0 (init);
		}
	}
	_tmp590_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp591_ = _tmp590_;
	if (_tmp591_) {
		gboolean _tmp592_ = FALSE;
		ValaCodeNode* _tmp593_;
		ValaCodeNode* _tmp594_;
		_tmp593_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp594_ = _tmp593_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp594_)) {
			_tmp592_ = TRUE;
		} else {
			ValaCodeNode* _tmp595_;
			ValaCodeNode* _tmp596_;
			_tmp595_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp596_ = _tmp595_;
			_tmp592_ = VALA_IS_EXPRESSION_STATEMENT (_tmp596_);
		}
		if (_tmp592_) {
		} else {
			ValaSemanticAnalyzer* _tmp597_;
			ValaSemanticAnalyzer* _tmp598_;
			ValaSymbol* _tmp599_;
			ValaSymbol* _tmp600_;
			_tmp597_ = vala_code_context_get_analyzer (context);
			_tmp598_ = _tmp597_;
			_tmp599_ = vala_semantic_analyzer_get_current_symbol (_tmp598_);
			_tmp600_ = _tmp599_;
			if (!VALA_IS_BLOCK (_tmp600_)) {
				ValaSourceReference* _tmp601_;
				ValaSourceReference* _tmp602_;
				_tmp601_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp602_ = _tmp601_;
				vala_report_error (_tmp602_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp603_;
				ValaCodeNode* _tmp604_;
				ValaCodeNode* _tmp605_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp606_;
				ValaDataType* _tmp607_;
				ValaDataType* _tmp608_;
				ValaDataType* _tmp609_;
				gchar* _tmp610_;
				gchar* _tmp611_;
				ValaSourceReference* _tmp612_;
				ValaSourceReference* _tmp613_;
				ValaLocalVariable* _tmp614_;
				ValaLocalVariable* _tmp615_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp616_;
				ValaSourceReference* _tmp617_;
				ValaSourceReference* _tmp618_;
				ValaDeclarationStatement* _tmp619_;
				ValaSemanticAnalyzer* _tmp620_;
				ValaSemanticAnalyzer* _tmp621_;
				ValaBlock* _tmp622_;
				ValaDeclarationStatement* _tmp623_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp624_;
				ValaDataType* _tmp625_;
				ValaDataType* _tmp626_;
				ValaExpression* _tmp627_;
				ValaExpression* _tmp628_;
				ValaDataType* _tmp629_;
				ValaDataType* _tmp630_;
				ValaLocalVariable* _tmp631_;
				ValaDeclarationStatement* _tmp632_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp633_;
				ValaSemanticAnalyzer* _tmp634_;
				ValaSymbol* _tmp635_;
				ValaSymbol* _tmp636_;
				ValaBlock* _tmp637_;
				ValaBlock* _tmp638_;
				ValaLocalVariable* _tmp639_;
				ValaSemanticAnalyzer* _tmp640_;
				ValaSemanticAnalyzer* _tmp641_;
				ValaBlock* _tmp642_;
				ValaLocalVariable* _tmp643_;
				ValaCodeNode* _tmp644_;
				ValaExpression* _tmp645_;
				ValaExpression* _tmp646_;
				_tmp603_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp604_ = _tmp603_;
				_tmp605_ = _vala_code_node_ref0 (_tmp604_);
				old_parent_node = _tmp605_;
				_tmp606_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp607_ = _tmp606_;
				_tmp608_ = vala_data_type_copy (_tmp607_);
				_tmp609_ = _tmp608_;
				_tmp610_ = vala_code_node_get_temp_name ();
				_tmp611_ = _tmp610_;
				_tmp612_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp613_ = _tmp612_;
				_tmp614_ = vala_local_variable_new (_tmp609_, _tmp611_, NULL, _tmp613_);
				_tmp615_ = _tmp614_;
				_g_free0 (_tmp611_);
				_vala_code_node_unref0 (_tmp609_);
				local = _tmp615_;
				_tmp616_ = local;
				_tmp617_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp618_ = _tmp617_;
				_tmp619_ = vala_declaration_statement_new ((ValaSymbol*) _tmp616_, _tmp618_);
				decl = _tmp619_;
				_tmp620_ = vala_code_context_get_analyzer (context);
				_tmp621_ = _tmp620_;
				_tmp622_ = _tmp621_->insert_block;
				_tmp623_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp622_, (ValaStatement*) _tmp623_);
				_tmp624_ = local;
				_tmp625_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp626_ = _tmp625_;
				_tmp627_ = vala_semantic_analyzer_create_temp_access (_tmp624_, _tmp626_);
				temp_access = _tmp627_;
				_tmp628_ = temp_access;
				_tmp629_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp630_ = _tmp629_;
				vala_expression_set_formal_target_type (_tmp628_, _tmp630_);
				_tmp631_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp631_, (ValaExpression*) self);
				_tmp632_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp632_, context);
				_tmp633_ = vala_code_context_get_analyzer (context);
				_tmp634_ = _tmp633_;
				_tmp635_ = vala_semantic_analyzer_get_current_symbol (_tmp634_);
				_tmp636_ = _tmp635_;
				_tmp637_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp636_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp637_;
				_tmp638_ = block;
				_tmp639_ = local;
				vala_block_remove_local_variable (_tmp638_, _tmp639_);
				_tmp640_ = vala_code_context_get_analyzer (context);
				_tmp641_ = _tmp640_;
				_tmp642_ = _tmp641_->insert_block;
				_tmp643_ = local;
				vala_block_add_local_variable (_tmp642_, _tmp643_);
				_tmp644_ = old_parent_node;
				_tmp645_ = temp_access;
				vala_code_node_replace_expression (_tmp644_, (ValaExpression*) self, _tmp645_);
				_tmp646_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp646_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp647_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp648_ = _tmp647_;
	result = !_tmp648_;
	_vala_code_node_unref0 (type);
	return result;
}

static void
vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                      ValaCollection* collection,
                                                      ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_METHOD (_tmp1_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		if (source_reference == NULL) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			source_reference = _tmp3_;
		}
		_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp6_;
		_tmp7_ = m;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp7_, collection, source_reference);
		_vala_code_node_unref0 (m);
	}
}

static void
vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp8_, codegen);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp9_ = self->priv->object_initializer;
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaMemberInitializer* _tmp17_;
			_init_index = _init_index + 1;
			_tmp13_ = _init_index;
			_tmp14_ = _init_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _init_list;
			_tmp16_ = vala_list_get (_tmp15_, _init_index);
			init = (ValaMemberInitializer*) _tmp16_;
			_tmp17_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp17_, codegen);
			_vala_code_node_unref0 (init);
		}
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp8_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp8_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp9_ = self->priv->object_initializer;
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaMemberInitializer* _tmp17_;
			_init_index = _init_index + 1;
			_tmp13_ = _init_index;
			_tmp14_ = _init_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _init_list;
			_tmp16_ = vala_list_get (_tmp15_, _init_index);
			init = (ValaMemberInitializer*) _tmp16_;
			_tmp17_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp17_, collection);
			_vala_code_node_unref0 (init);
		}
	}
}

static gchar*
vala_object_creation_expression_real_to_string (ValaCodeNode* base)
{
	ValaObjectCreationExpression * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp4_;
	ValaMemberAccess* _tmp6_;
	ValaMemberAccess* _tmp7_;
	GString* _tmp13_;
	gboolean first = FALSE;
	GString* _tmp27_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* result = NULL;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = self->priv->_struct_creation;
	if (!_tmp4_) {
		GString* _tmp5_;
		_tmp5_ = b;
		g_string_append (_tmp5_, "new ");
	}
	_tmp6_ = vala_object_creation_expression_get_member_name (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		GString* _tmp8_;
		ValaMemberAccess* _tmp9_;
		ValaMemberAccess* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp8_ = b;
		_tmp9_ = vala_object_creation_expression_get_member_name (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_node_to_string ((ValaCodeNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		g_string_append (_tmp8_, _tmp12_);
		_g_free0 (_tmp12_);
	}
	_tmp13_ = b;
	g_string_append_c (_tmp13_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp14_;
		gint _expr_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _expr_index = 0;
		_tmp14_ = self->priv->argument_list;
		_expr_list = _tmp14_;
		_tmp15_ = _expr_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_expr_size = _tmp17_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaExpression* expr = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			GString* _tmp23_;
			ValaExpression* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_expr_index = _expr_index + 1;
			_tmp18_ = _expr_index;
			_tmp19_ = _expr_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _expr_list;
			_tmp21_ = vala_list_get (_tmp20_, _expr_index);
			expr = (ValaExpression*) _tmp21_;
			if (!first) {
				GString* _tmp22_;
				_tmp22_ = b;
				g_string_append (_tmp22_, ", ");
			}
			_tmp23_ = b;
			_tmp24_ = expr;
			_tmp25_ = vala_code_node_to_string ((ValaCodeNode*) _tmp24_);
			_tmp26_ = _tmp25_;
			g_string_append (_tmp23_, _tmp26_);
			_g_free0 (_tmp26_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp27_ = b;
	g_string_append_c (_tmp27_, ')');
	_tmp28_ = b;
	_tmp29_ = _tmp28_->str;
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	_g_string_free0 (b);
	return result;
}

static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass,
                                            gpointer klass_data)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaObjectCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_object_creation_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_object_creation_expression_real_to_string;
}

static void
vala_object_creation_expression_vala_callable_expression_interface_init (ValaCallableExpressionIface * iface,
                                                                         gpointer iface_data)
{
	vala_object_creation_expression_vala_callable_expression_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_argument = (void (*) (ValaCallableExpression*, ValaExpression*)) vala_object_creation_expression_real_add_argument;
	iface->get_argument_list = (ValaList* (*) (ValaCallableExpression*)) vala_object_creation_expression_real_get_argument_list;
	iface->get_is_yield_expression = vala_object_creation_expression_real_get_is_yield_expression;
	iface->set_is_yield_expression = vala_object_creation_expression_real_set_is_yield_expression;
}

static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self,
                                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_object_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}

static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_member_name);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}

/**
 * Represents an object creation expression in the source code.
 */
static GType
vala_object_creation_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
	static const GInterfaceInfo vala_callable_expression_info = { (GInterfaceInitFunc) vala_object_creation_expression_vala_callable_expression_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_object_creation_expression_type_id;
	vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
	g_type_add_interface_static (vala_object_creation_expression_type_id, VALA_TYPE_CALLABLE_EXPRESSION, &vala_callable_expression_info);
	ValaObjectCreationExpression_private_offset = g_type_add_instance_private (vala_object_creation_expression_type_id, sizeof (ValaObjectCreationExpressionPrivate));
	return vala_object_creation_expression_type_id;
}

GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__volatile)) {
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = vala_object_creation_expression_get_type_once ();
		g_once_init_leave (&vala_object_creation_expression_type_id__volatile, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__volatile;
}

