/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <glib.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static GType vala_ccode_method_call_module_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	ValaDataType* _tmp15_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp166_;
	GEqualFunc _tmp167_;
	GEqualFunc _tmp168_;
	ValaHashMap* _tmp169_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp170_;
	ValaHashMap* _tmp171_;
	gboolean _tmp172_ = FALSE;
	ValaMethod* _tmp173_;
	gboolean _tmp417_ = FALSE;
	ValaMethod* _tmp418_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp586_;
	ValaCCodeExpression* _tmp587_;
	gboolean _tmp588_ = FALSE;
	ValaMethod* _tmp589_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp617_ = FALSE;
	ValaMethod* _tmp618_;
	gboolean _tmp775_ = FALSE;
	ValaMethod* _tmp776_;
	ValaMethod* _tmp830_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp1024_;
	ValaIterator* _tmp1025_;
	ValaIterator* _tmp1436_;
	gboolean _tmp1446_ = FALSE;
	gboolean _tmp1447_ = FALSE;
	ValaMethod* _tmp1448_;
	gboolean _tmp1569_ = FALSE;
	ValaDelegate* _tmp1570_;
	gboolean _tmp1666_ = FALSE;
	ValaMethod* _tmp1667_;
	gboolean _tmp1683_;
	gboolean _tmp1684_;
	gboolean _tmp1727_ = FALSE;
	ValaDelegate* _tmp1728_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1746_;
	ValaDataType* _tmp1747_;
	gboolean _tmp1748_ = FALSE;
	ValaDataType* _tmp1749_;
	ValaCCodeFunctionCall* _tmp1777_;
	ValaCCodeFunctionCall* _tmp1778_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1791_;
	ValaCCodeFunctionCall* _tmp1792_;
	ValaCCodeFunctionCall* _tmp1807_;
	gboolean _tmp1822_;
	gboolean _tmp1823_;
	gboolean _tmp1847_;
	gboolean _tmp1848_;
	gboolean _tmp1883_ = FALSE;
	gboolean _tmp1884_ = FALSE;
	ValaMethod* _tmp1885_;
	gboolean _tmp1923_ = FALSE;
	gboolean _tmp1924_ = FALSE;
	gboolean _tmp1925_ = FALSE;
	gboolean _tmp1926_ = FALSE;
	gboolean _tmp1927_ = FALSE;
	ValaMethod* _tmp1928_;
	gboolean _tmp1945_ = FALSE;
	gboolean _tmp1946_ = FALSE;
	ValaMethod* _tmp1947_;
	ValaMethod* _tmp1966_;
	gboolean _tmp2076_ = FALSE;
	ValaCodeNode* _tmp2077_;
	ValaCodeNode* _tmp2078_;
	ValaList* _tmp2178_;
	ValaIterator* _tmp2179_;
	gboolean _tmp2333_ = FALSE;
	gboolean _tmp2334_ = FALSE;
	ValaMethod* _tmp2335_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_get_cvalue (_tmp1_);
	_tmp3_ = vala_ccode_function_call_new (_tmp2_);
	ccall = _tmp3_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp4_ = vala_method_call_get_call (expr);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp5_) : NULL);
	ma = _tmp6_;
	_tmp7_ = vala_method_call_get_call (expr);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_expression_get_value_type (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (_tmp10_);
	itype = _tmp11_;
	_tmp12_ = itype;
	_tmp13_ = vala_data_type_get_parameters (_tmp12_);
	_tmp14_ = _vala_iterable_ref0 (_tmp13_);
	_vala_iterable_unref0 (params);
	params = _tmp14_;
	_tmp15_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp16_;
		ValaDataType* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		ValaMemberAccess* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp16_ = ma;
		_vala_assert (_tmp16_ != NULL, "ma != null");
		_tmp17_ = itype;
		_tmp18_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp19_ = _tmp18_;
		_tmp20_ = _vala_code_node_ref0 (_tmp19_);
		_vala_code_node_unref0 (m);
		m = _tmp20_;
		_tmp21_ = m;
		if (!vala_get_ccode_simple_generics (_tmp21_)) {
			ValaCodeContext* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaSemanticAnalyzer* _tmp24_;
			ValaSemanticAnalyzer* _tmp25_;
			ValaMemberAccess* _tmp26_;
			_tmp22_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_code_context_get_analyzer (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = ma;
			vala_semantic_analyzer_check_type_arguments (_tmp25_, _tmp26_);
		}
		_tmp29_ = ma;
		_tmp30_ = vala_member_access_get_inner (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaMemberAccess* _tmp32_;
			ValaExpression* _tmp33_;
			ValaExpression* _tmp34_;
			ValaDataType* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp32_ = ma;
			_tmp33_ = vala_member_access_get_inner (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_expression_get_value_type (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp28_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaMemberAccess* _tmp37_;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			ValaDataType* _tmp40_;
			ValaDataType* _tmp41_;
			ValaMethod* _tmp42_;
			ValaMethod* _tmp43_;
			_tmp37_ = ma;
			_tmp38_ = vala_member_access_get_inner (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_expression_get_value_type (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp43_ = m;
			_tmp27_ = _tmp42_ == _tmp43_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp44_;
			ValaExpression* _tmp45_;
			ValaExpression* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			ValaTypeSymbol* _tmp49_;
			ValaTypeSymbol* _tmp50_;
			ValaCCodeFunctionCall* _tmp51_;
			ValaEnum* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			ValaCCodeIdentifier* _tmp56_;
			_tmp44_ = ma;
			_tmp45_ = vala_member_access_get_inner (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_expression_get_value_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_data_type_get_type_symbol (_tmp48_);
			_tmp50_ = _tmp49_;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_ENUM, ValaEnum);
			_tmp51_ = ccall;
			_tmp52_ = en;
			_tmp53_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_ccode_identifier_new (_tmp54_);
			_tmp56_ = _tmp55_;
			vala_ccode_function_call_set_call (_tmp51_, (ValaCCodeExpression*) _tmp56_);
			_vala_ccode_node_unref0 (_tmp56_);
			_g_free0 (_tmp54_);
		} else {
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			gboolean _tmp60_ = FALSE;
			ValaCodeContext* _tmp61_;
			ValaCodeContext* _tmp62_;
			ValaProfile _tmp63_;
			ValaProfile _tmp64_;
			_tmp61_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_code_context_get_profile (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp65_;
				ValaExpression* _tmp66_;
				ValaExpression* _tmp67_;
				_tmp65_ = ma;
				_tmp66_ = vala_member_access_get_inner (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp60_ = _tmp67_ != NULL;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaMemberAccess* _tmp68_;
				ValaExpression* _tmp69_;
				ValaExpression* _tmp70_;
				ValaDataType* _tmp71_;
				ValaDataType* _tmp72_;
				_tmp68_ = ma;
				_tmp69_ = vala_member_access_get_inner (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_expression_get_value_type (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp59_ = _tmp72_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp73_;
				ValaExpression* _tmp74_;
				ValaExpression* _tmp75_;
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaTypeSymbol* _tmp79_;
				ValaDataType* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				ValaTypeSymbol* _tmp82_;
				_tmp73_ = ma;
				_tmp74_ = vala_member_access_get_inner (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_expression_get_value_type (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_data_type_get_type_symbol (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp81_ = vala_data_type_get_type_symbol (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp58_ = _tmp79_ == _tmp82_;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp83_;
				const gchar* _tmp84_;
				const gchar* _tmp85_;
				_tmp83_ = ma;
				_tmp84_ = vala_member_access_get_member_name (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp57_ = g_strcmp0 (_tmp85_, "printf") == 0;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				ValaCCodeIdentifier* _tmp90_;
				_tmp86_ = ccall;
				_tmp87_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_ccode_identifier_new (_tmp88_);
				_tmp90_ = _tmp89_;
				vala_ccode_function_call_set_call (_tmp86_, (ValaCCodeExpression*) _tmp90_);
				_vala_ccode_node_unref0 (_tmp90_);
				_g_free0 (_tmp88_);
			} else {
				gboolean _tmp91_;
				gboolean _tmp92_;
				_tmp91_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp92_ = _tmp91_;
				if (_tmp92_) {
					ValaCCodeFunctionCall* _tmp93_;
					ValaMethod* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					ValaCCodeIdentifier* _tmp98_;
					_tmp93_ = ccall;
					_tmp94_ = m;
					_tmp95_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_ccode_identifier_new (_tmp96_);
					_tmp98_ = _tmp97_;
					vala_ccode_function_call_set_call (_tmp93_, (ValaCCodeExpression*) _tmp98_);
					_vala_ccode_node_unref0 (_tmp98_);
					_g_free0 (_tmp96_);
				}
			}
		}
	} else {
		ValaDataType* _tmp99_;
		_tmp99_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp100_;
			ValaSignalType* _tmp101_;
			gboolean _tmp102_ = FALSE;
			gboolean _tmp103_ = FALSE;
			ValaMemberAccess* _tmp104_;
			_tmp100_ = itype;
			_tmp101_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp101_;
			_tmp104_ = ma;
			if (_tmp104_ != NULL) {
				ValaMemberAccess* _tmp105_;
				ValaExpression* _tmp106_;
				ValaExpression* _tmp107_;
				_tmp105_ = ma;
				_tmp106_ = vala_member_access_get_inner (_tmp105_);
				_tmp107_ = _tmp106_;
				_tmp103_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp103_ = FALSE;
			}
			if (_tmp103_) {
				ValaSignalType* _tmp108_;
				ValaSignal* _tmp109_;
				ValaSignal* _tmp110_;
				gboolean _tmp111_;
				gboolean _tmp112_;
				_tmp108_ = sig_type;
				_tmp109_ = vala_signal_type_get_signal_symbol (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = vala_signal_get_is_virtual (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp102_ = _tmp112_;
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp113_;
				ValaSignal* _tmp114_;
				ValaSignal* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				ValaMethod* _tmp118_;
				_tmp113_ = sig_type;
				_tmp114_ = vala_signal_type_get_signal_symbol (_tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = vala_signal_get_default_handler (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = _vala_code_node_ref0 (_tmp117_);
				_vala_code_node_unref0 (m);
				m = _tmp118_;
			} else {
				ValaExpression* _tmp119_;
				ValaExpression* _tmp120_;
				ValaCCodeExpression* _tmp121_;
				ValaCCodeFunctionCall* _tmp122_;
				_tmp119_ = vala_method_call_get_call (expr);
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_get_cvalue (_tmp120_);
				_tmp122_ = _vala_ccode_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall));
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp122_;
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp123_;
			_tmp123_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp123_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp124_;
				ValaTypeSymbol* _tmp125_;
				ValaTypeSymbol* _tmp126_;
				ValaClass* _tmp127_;
				ValaClass* _tmp128_;
				ValaCreationMethod* _tmp129_;
				ValaCreationMethod* _tmp130_;
				ValaMethod* _tmp131_;
				ValaMethod* _tmp132_;
				ValaCCodeFile* _tmp133_;
				gchar* real_name = NULL;
				ValaMethod* _tmp134_;
				gchar* _tmp135_;
				gboolean _tmp136_;
				gboolean _tmp137_;
				const gchar* _tmp140_;
				ValaCCodeIdentifier* _tmp141_;
				ValaCCodeIdentifier* _tmp142_;
				ValaCCodeFunctionCall* _tmp143_;
				_tmp124_ = itype;
				_tmp125_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp126_ = _tmp125_;
				_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp127_;
				_tmp128_ = cl;
				_tmp129_ = vala_class_get_default_construction_method (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = _vala_code_node_ref0 ((ValaMethod*) _tmp130_);
				_vala_code_node_unref0 (m);
				m = _tmp131_;
				_tmp132_ = m;
				_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp132_, _tmp133_);
				_tmp134_ = m;
				_tmp135_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp134_);
				real_name = _tmp135_;
				_tmp136_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp137_ = _tmp136_;
				if (_tmp137_) {
					ValaMethod* _tmp138_;
					gchar* _tmp139_;
					_tmp138_ = m;
					_tmp139_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp139_;
				}
				_tmp140_ = real_name;
				_tmp141_ = vala_ccode_identifier_new (_tmp140_);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp142_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp143_;
				_vala_ccode_node_unref0 (_tmp142_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp144_;
				_tmp144_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp145_;
					ValaTypeSymbol* _tmp146_;
					ValaTypeSymbol* _tmp147_;
					ValaStruct* _tmp148_;
					ValaStruct* _tmp149_;
					ValaCreationMethod* _tmp150_;
					ValaCreationMethod* _tmp151_;
					ValaMethod* _tmp152_;
					ValaMethod* _tmp153_;
					ValaCCodeFile* _tmp154_;
					ValaMethod* _tmp155_;
					gchar* _tmp156_;
					gchar* _tmp157_;
					ValaCCodeIdentifier* _tmp158_;
					ValaCCodeIdentifier* _tmp159_;
					ValaCCodeFunctionCall* _tmp160_;
					_tmp145_ = itype;
					_tmp146_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp147_ = _tmp146_;
					_tmp148_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp148_;
					_tmp149_ = st;
					_tmp150_ = vala_struct_get_default_construction_method (_tmp149_);
					_tmp151_ = _tmp150_;
					_tmp152_ = _vala_code_node_ref0 ((ValaMethod*) _tmp151_);
					_vala_code_node_unref0 (m);
					m = _tmp152_;
					_tmp153_ = m;
					_tmp154_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp153_, _tmp154_);
					_tmp155_ = m;
					_tmp156_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_identifier_new (_tmp157_);
					_tmp159_ = _tmp158_;
					_tmp160_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp159_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp160_;
					_vala_ccode_node_unref0 (_tmp159_);
					_g_free0 (_tmp157_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp161_;
					_tmp161_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp162_;
						ValaDelegate* _tmp163_;
						ValaDelegate* _tmp164_;
						ValaDelegate* _tmp165_;
						_tmp162_ = itype;
						_tmp163_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp164_ = _tmp163_;
						_tmp165_ = _vala_code_node_ref0 (_tmp164_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp165_;
					}
				}
			}
		}
	}
	_tmp166_ = g_direct_hash;
	_tmp167_ = g_direct_equal;
	_tmp168_ = g_direct_equal;
	_tmp169_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp166_, _tmp167_, _tmp168_);
	in_arg_map = _tmp169_;
	_tmp170_ = in_arg_map;
	_tmp171_ = _vala_map_ref0 (_tmp170_);
	out_arg_map = _tmp171_;
	_tmp173_ = m;
	if (_tmp173_ != NULL) {
		ValaMethod* _tmp174_;
		gboolean _tmp175_;
		gboolean _tmp176_;
		_tmp174_ = m;
		_tmp175_ = vala_method_get_coroutine (_tmp174_);
		_tmp176_ = _tmp175_;
		_tmp172_ = _tmp176_;
	} else {
		_tmp172_ = FALSE;
	}
	if (_tmp172_) {
		ValaMethod* _tmp177_;
		gchar* _tmp178_;
		gchar* _tmp179_;
		ValaCCodeIdentifier* _tmp180_;
		ValaCCodeIdentifier* _tmp181_;
		ValaCCodeFunctionCall* _tmp182_;
		ValaMethod* _tmp183_;
		gchar* _tmp184_;
		gchar* _tmp185_;
		ValaCCodeIdentifier* _tmp186_;
		ValaCCodeIdentifier* _tmp187_;
		ValaCCodeFunctionCall* _tmp188_;
		ValaMemberAccess* _tmp189_;
		ValaExpression* _tmp190_;
		ValaExpression* _tmp191_;
		gboolean _tmp367_ = FALSE;
		ValaMemberAccess* _tmp368_;
		const gchar* _tmp369_;
		const gchar* _tmp370_;
		_tmp177_ = m;
		_tmp178_ = vala_get_ccode_name ((ValaCodeNode*) _tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_identifier_new (_tmp179_);
		_tmp181_ = _tmp180_;
		_tmp182_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp181_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp182_;
		_vala_ccode_node_unref0 (_tmp181_);
		_g_free0 (_tmp179_);
		_tmp183_ = m;
		_tmp184_ = vala_get_ccode_finish_name (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_identifier_new (_tmp185_);
		_tmp187_ = _tmp186_;
		_tmp188_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp187_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp188_;
		_vala_ccode_node_unref0 (_tmp187_);
		_g_free0 (_tmp185_);
		_tmp189_ = ma;
		_tmp190_ = vala_member_access_get_inner (_tmp189_);
		_tmp191_ = _tmp190_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp191_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp192_;
			ValaMethod* _tmp193_;
			ValaMethod* _tmp194_;
			ValaCCodeExpression* _tmp225_;
			vcast = NULL;
			_tmp192_ = m;
			_tmp193_ = vala_method_get_base_method (_tmp192_);
			_tmp194_ = _tmp193_;
			if (_tmp194_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp195_;
				ValaMethod* _tmp196_;
				ValaMethod* _tmp197_;
				ValaSymbol* _tmp198_;
				ValaSymbol* _tmp199_;
				ValaClass* _tmp200_;
				gchar* _tmp201_;
				gchar* _tmp202_;
				ValaCCodeIdentifier* _tmp203_;
				ValaCCodeIdentifier* _tmp204_;
				ValaCCodeFunctionCall* _tmp205_;
				ValaCCodeExpression* _tmp206_;
				ValaClass* _tmp207_;
				ValaClass* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				ValaCCodeIdentifier* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				_tmp195_ = m;
				_tmp196_ = vala_method_get_base_method (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp197_);
				_tmp199_ = _tmp198_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, VALA_TYPE_CLASS, ValaClass);
				_tmp200_ = base_class;
				_tmp201_ = vala_get_ccode_class_type_function (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = vala_ccode_identifier_new (_tmp202_);
				_tmp204_ = _tmp203_;
				_tmp205_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp204_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp205_;
				_vala_ccode_node_unref0 (_tmp204_);
				_g_free0 (_tmp202_);
				_tmp206_ = vcast;
				_tmp207_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp208_, NULL);
				_tmp210_ = _tmp209_;
				_tmp211_ = g_strdup_printf ("%s_parent_class", _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_ccode_identifier_new (_tmp212_);
				_tmp214_ = _tmp213_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp206_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp214_);
				_vala_ccode_node_unref0 (_tmp214_);
				_g_free0 (_tmp212_);
				_g_free0 (_tmp210_);
			} else {
				ValaMethod* _tmp215_;
				ValaMethod* _tmp216_;
				ValaMethod* _tmp217_;
				_tmp215_ = m;
				_tmp216_ = vala_method_get_base_interface_method (_tmp215_);
				_tmp217_ = _tmp216_;
				if (_tmp217_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp218_;
					ValaMethod* _tmp219_;
					ValaMethod* _tmp220_;
					ValaSymbol* _tmp221_;
					ValaSymbol* _tmp222_;
					ValaInterface* _tmp223_;
					ValaCCodeExpression* _tmp224_;
					_tmp218_ = m;
					_tmp219_ = vala_method_get_base_interface_method (_tmp218_);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp220_);
					_tmp222_ = _tmp221_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp222_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp223_ = base_iface;
					_tmp224_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp223_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp224_;
				}
			}
			_tmp225_ = vcast;
			if (_tmp225_ != NULL) {
				ValaCCodeFunctionCall* _tmp226_;
				ValaCCodeExpression* _tmp227_;
				ValaMethod* _tmp228_;
				gchar* _tmp229_;
				gchar* _tmp230_;
				ValaCCodeMemberAccess* _tmp231_;
				ValaCCodeMemberAccess* _tmp232_;
				ValaCCodeFunctionCall* _tmp233_;
				ValaCCodeExpression* _tmp234_;
				ValaMethod* _tmp235_;
				gchar* _tmp236_;
				gchar* _tmp237_;
				ValaCCodeMemberAccess* _tmp238_;
				ValaCCodeMemberAccess* _tmp239_;
				_tmp226_ = async_call;
				_tmp227_ = vcast;
				_tmp228_ = m;
				_tmp229_ = vala_get_ccode_vfunc_name (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp231_ = vala_ccode_member_access_new_pointer (_tmp227_, _tmp230_);
				_tmp232_ = _tmp231_;
				vala_ccode_function_call_set_call (_tmp226_, (ValaCCodeExpression*) _tmp232_);
				_vala_ccode_node_unref0 (_tmp232_);
				_g_free0 (_tmp230_);
				_tmp233_ = finish_call;
				_tmp234_ = vcast;
				_tmp235_ = m;
				_tmp236_ = vala_get_ccode_finish_vfunc_name (_tmp235_);
				_tmp237_ = _tmp236_;
				_tmp238_ = vala_ccode_member_access_new_pointer (_tmp234_, _tmp237_);
				_tmp239_ = _tmp238_;
				vala_ccode_function_call_set_call (_tmp233_, (ValaCCodeExpression*) _tmp239_);
				_vala_ccode_node_unref0 (_tmp239_);
				_g_free0 (_tmp237_);
			}
			_vala_ccode_node_unref0 (vcast);
		} else {
			gboolean _tmp240_ = FALSE;
			gboolean _tmp241_ = FALSE;
			gboolean _tmp242_ = FALSE;
			ValaMethod* _tmp243_;
			_tmp243_ = m;
			if (_tmp243_ != NULL) {
				ValaMethod* _tmp244_;
				_tmp244_ = m;
				_tmp242_ = vala_get_ccode_no_wrapper (_tmp244_);
			} else {
				_tmp242_ = FALSE;
			}
			if (_tmp242_) {
				ValaMethod* _tmp245_;
				ValaMemberBinding _tmp246_;
				ValaMemberBinding _tmp247_;
				_tmp245_ = m;
				_tmp246_ = vala_method_get_binding (_tmp245_);
				_tmp247_ = _tmp246_;
				_tmp241_ = _tmp247_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp241_ = FALSE;
			}
			if (_tmp241_) {
				ValaMethod* _tmp248_;
				_tmp248_ = m;
				_tmp240_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp248_, VALA_TYPE_CREATION_METHOD);
			} else {
				_tmp240_ = FALSE;
			}
			if (_tmp240_) {
				ValaTargetValue* instance_value = NULL;
				ValaMemberAccess* _tmp249_;
				ValaExpression* _tmp250_;
				ValaExpression* _tmp251_;
				ValaTargetValue* _tmp252_;
				ValaTargetValue* _tmp253_;
				ValaTargetValue* _tmp254_;
				gboolean _tmp255_ = FALSE;
				gboolean _tmp256_ = FALSE;
				ValaMemberAccess* _tmp257_;
				const gchar* _tmp258_;
				const gchar* _tmp259_;
				ValaCCodeExpression* pub_inst = NULL;
				ValaTargetValue* _tmp281_;
				ValaCCodeExpression* _tmp282_;
				ValaCCodeExpression* _tmp283_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaMethod* _tmp284_;
				ValaSymbol* _tmp285_;
				ValaSymbol* _tmp286_;
				ValaCCodeFunctionCall* _tmp352_;
				_tmp249_ = ma;
				_tmp250_ = vala_member_access_get_inner (_tmp249_);
				_tmp251_ = _tmp250_;
				_tmp252_ = vala_expression_get_target_value (_tmp251_);
				_tmp253_ = _tmp252_;
				_tmp254_ = _vala_target_value_ref0 (_tmp253_);
				instance_value = _tmp254_;
				_tmp257_ = ma;
				_tmp258_ = vala_member_access_get_member_name (_tmp257_);
				_tmp259_ = _tmp258_;
				if (g_strcmp0 (_tmp259_, "begin") == 0) {
					_tmp256_ = TRUE;
				} else {
					ValaMemberAccess* _tmp260_;
					const gchar* _tmp261_;
					const gchar* _tmp262_;
					_tmp260_ = ma;
					_tmp261_ = vala_member_access_get_member_name (_tmp260_);
					_tmp262_ = _tmp261_;
					_tmp256_ = g_strcmp0 (_tmp262_, "end") == 0;
				}
				if (_tmp256_) {
					ValaMemberAccess* _tmp263_;
					ValaExpression* _tmp264_;
					ValaExpression* _tmp265_;
					ValaSymbol* _tmp266_;
					ValaSymbol* _tmp267_;
					ValaMemberAccess* _tmp268_;
					ValaSymbol* _tmp269_;
					ValaSymbol* _tmp270_;
					_tmp263_ = ma;
					_tmp264_ = vala_member_access_get_inner (_tmp263_);
					_tmp265_ = _tmp264_;
					_tmp266_ = vala_expression_get_symbol_reference (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp268_ = ma;
					_tmp269_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp268_);
					_tmp270_ = _tmp269_;
					_tmp255_ = _tmp267_ == _tmp270_;
				} else {
					_tmp255_ = FALSE;
				}
				if (_tmp255_) {
					ValaMemberAccess* inner_ma = NULL;
					ValaMemberAccess* _tmp271_;
					ValaExpression* _tmp272_;
					ValaExpression* _tmp273_;
					ValaMemberAccess* _tmp274_;
					ValaMemberAccess* _tmp275_;
					ValaExpression* _tmp276_;
					ValaExpression* _tmp277_;
					ValaTargetValue* _tmp278_;
					ValaTargetValue* _tmp279_;
					ValaTargetValue* _tmp280_;
					_tmp271_ = ma;
					_tmp272_ = vala_member_access_get_inner (_tmp271_);
					_tmp273_ = _tmp272_;
					_tmp274_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp273_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
					inner_ma = _tmp274_;
					_tmp275_ = inner_ma;
					_tmp276_ = vala_member_access_get_inner (_tmp275_);
					_tmp277_ = _tmp276_;
					_tmp278_ = vala_expression_get_target_value (_tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = _vala_target_value_ref0 (_tmp279_);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp280_;
					_vala_code_node_unref0 (inner_ma);
				}
				_tmp281_ = instance_value;
				_tmp282_ = vala_get_cvalue_ (_tmp281_);
				_tmp283_ = _vala_ccode_node_ref0 (_tmp282_);
				pub_inst = _tmp283_;
				vcast = NULL;
				_tmp284_ = m;
				_tmp285_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp284_);
				_tmp286_ = _tmp285_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp286_, VALA_TYPE_CLASS)) {
					ValaClass* base_class = NULL;
					ValaMethod* _tmp287_;
					ValaSymbol* _tmp288_;
					ValaSymbol* _tmp289_;
					ValaClass* _tmp290_;
					gboolean _tmp291_;
					gboolean _tmp292_;
					_tmp287_ = m;
					_tmp288_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp287_);
					_tmp289_ = _tmp288_;
					base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp289_, VALA_TYPE_CLASS, ValaClass);
					_tmp290_ = base_class;
					_tmp291_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp290_);
					_tmp292_ = _tmp291_;
					if (_tmp292_) {
						ValaCCodeIdentifier* _tmp293_;
						ValaCCodeIdentifier* _tmp294_;
						ValaCCodeFunctionCall* _tmp295_;
						ValaCCodeFunctionCall* _tmp296_;
						ValaCCodeExpression* _tmp297_;
						ValaCCodeFunctionCall* _tmp298_;
						ValaClass* _tmp299_;
						gchar* _tmp300_;
						gchar* _tmp301_;
						ValaCCodeIdentifier* _tmp302_;
						ValaCCodeIdentifier* _tmp303_;
						ValaCCodeFunctionCall* _tmp304_;
						ValaClass* _tmp305_;
						gchar* _tmp306_;
						gchar* _tmp307_;
						ValaCCodeIdentifier* _tmp308_;
						ValaCCodeIdentifier* _tmp309_;
						_tmp293_ = vala_ccode_identifier_new ("G_TYPE_INSTANCE_GET_CLASS");
						_tmp294_ = _tmp293_;
						_tmp295_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp294_);
						_vala_ccode_node_unref0 (vcast);
						vcast = _tmp295_;
						_vala_ccode_node_unref0 (_tmp294_);
						_tmp296_ = vcast;
						_tmp297_ = pub_inst;
						vala_ccode_function_call_add_argument (_tmp296_, _tmp297_);
						_tmp298_ = vcast;
						_tmp299_ = base_class;
						_tmp300_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp299_);
						_tmp301_ = _tmp300_;
						_tmp302_ = vala_ccode_identifier_new (_tmp301_);
						_tmp303_ = _tmp302_;
						vala_ccode_function_call_add_argument (_tmp298_, (ValaCCodeExpression*) _tmp303_);
						_vala_ccode_node_unref0 (_tmp303_);
						_g_free0 (_tmp301_);
						_tmp304_ = vcast;
						_tmp305_ = base_class;
						_tmp306_ = vala_get_ccode_type_name ((ValaObjectTypeSymbol*) _tmp305_);
						_tmp307_ = _tmp306_;
						_tmp308_ = vala_ccode_identifier_new (_tmp307_);
						_tmp309_ = _tmp308_;
						vala_ccode_function_call_add_argument (_tmp304_, (ValaCCodeExpression*) _tmp309_);
						_vala_ccode_node_unref0 (_tmp309_);
						_g_free0 (_tmp307_);
					} else {
						ValaClass* _tmp310_;
						gchar* _tmp311_;
						gchar* _tmp312_;
						ValaCCodeIdentifier* _tmp313_;
						ValaCCodeIdentifier* _tmp314_;
						ValaCCodeFunctionCall* _tmp315_;
						ValaCCodeFunctionCall* _tmp316_;
						ValaCCodeExpression* _tmp317_;
						_tmp310_ = base_class;
						_tmp311_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp310_);
						_tmp312_ = _tmp311_;
						_tmp313_ = vala_ccode_identifier_new (_tmp312_);
						_tmp314_ = _tmp313_;
						_tmp315_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp314_);
						_vala_ccode_node_unref0 (vcast);
						vcast = _tmp315_;
						_vala_ccode_node_unref0 (_tmp314_);
						_g_free0 (_tmp312_);
						_tmp316_ = vcast;
						_tmp317_ = pub_inst;
						vala_ccode_function_call_add_argument (_tmp316_, _tmp317_);
					}
				} else {
					ValaMethod* _tmp318_;
					ValaSymbol* _tmp319_;
					ValaSymbol* _tmp320_;
					_tmp318_ = m;
					_tmp319_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp318_);
					_tmp320_ = _tmp319_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp320_, VALA_TYPE_INTERFACE)) {
						ValaInterface* base_iface = NULL;
						ValaMethod* _tmp321_;
						ValaSymbol* _tmp322_;
						ValaSymbol* _tmp323_;
						ValaInterface* _tmp324_;
						gboolean _tmp325_;
						gboolean _tmp326_;
						_tmp321_ = m;
						_tmp322_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp321_);
						_tmp323_ = _tmp322_;
						base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp323_, VALA_TYPE_INTERFACE, ValaInterface);
						_tmp324_ = base_iface;
						_tmp325_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp324_);
						_tmp326_ = _tmp325_;
						if (_tmp326_) {
							ValaCCodeIdentifier* _tmp327_;
							ValaCCodeIdentifier* _tmp328_;
							ValaCCodeFunctionCall* _tmp329_;
							ValaCCodeFunctionCall* _tmp330_;
							ValaCCodeExpression* _tmp331_;
							ValaCCodeFunctionCall* _tmp332_;
							ValaInterface* _tmp333_;
							gchar* _tmp334_;
							gchar* _tmp335_;
							ValaCCodeIdentifier* _tmp336_;
							ValaCCodeIdentifier* _tmp337_;
							ValaCCodeFunctionCall* _tmp338_;
							ValaInterface* _tmp339_;
							gchar* _tmp340_;
							gchar* _tmp341_;
							ValaCCodeIdentifier* _tmp342_;
							ValaCCodeIdentifier* _tmp343_;
							_tmp327_ = vala_ccode_identifier_new ("G_TYPE_INSTANCE_GET_INTERFACE");
							_tmp328_ = _tmp327_;
							_tmp329_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp328_);
							_vala_ccode_node_unref0 (vcast);
							vcast = _tmp329_;
							_vala_ccode_node_unref0 (_tmp328_);
							_tmp330_ = vcast;
							_tmp331_ = pub_inst;
							vala_ccode_function_call_add_argument (_tmp330_, _tmp331_);
							_tmp332_ = vcast;
							_tmp333_ = base_iface;
							_tmp334_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp333_);
							_tmp335_ = _tmp334_;
							_tmp336_ = vala_ccode_identifier_new (_tmp335_);
							_tmp337_ = _tmp336_;
							vala_ccode_function_call_add_argument (_tmp332_, (ValaCCodeExpression*) _tmp337_);
							_vala_ccode_node_unref0 (_tmp337_);
							_g_free0 (_tmp335_);
							_tmp338_ = vcast;
							_tmp339_ = base_iface;
							_tmp340_ = vala_get_ccode_type_name ((ValaObjectTypeSymbol*) _tmp339_);
							_tmp341_ = _tmp340_;
							_tmp342_ = vala_ccode_identifier_new (_tmp341_);
							_tmp343_ = _tmp342_;
							vala_ccode_function_call_add_argument (_tmp338_, (ValaCCodeExpression*) _tmp343_);
							_vala_ccode_node_unref0 (_tmp343_);
							_g_free0 (_tmp341_);
						} else {
							ValaInterface* _tmp344_;
							gchar* _tmp345_;
							gchar* _tmp346_;
							ValaCCodeIdentifier* _tmp347_;
							ValaCCodeIdentifier* _tmp348_;
							ValaCCodeFunctionCall* _tmp349_;
							ValaCCodeFunctionCall* _tmp350_;
							ValaCCodeExpression* _tmp351_;
							_tmp344_ = base_iface;
							_tmp345_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp344_);
							_tmp346_ = _tmp345_;
							_tmp347_ = vala_ccode_identifier_new (_tmp346_);
							_tmp348_ = _tmp347_;
							_tmp349_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp348_);
							_vala_ccode_node_unref0 (vcast);
							vcast = _tmp349_;
							_vala_ccode_node_unref0 (_tmp348_);
							_g_free0 (_tmp346_);
							_tmp350_ = vcast;
							_tmp351_ = pub_inst;
							vala_ccode_function_call_add_argument (_tmp350_, _tmp351_);
						}
					}
				}
				_tmp352_ = vcast;
				if (_tmp352_ != NULL) {
					ValaCCodeFunctionCall* _tmp353_;
					ValaCCodeFunctionCall* _tmp354_;
					ValaMethod* _tmp355_;
					gchar* _tmp356_;
					gchar* _tmp357_;
					ValaCCodeMemberAccess* _tmp358_;
					ValaCCodeMemberAccess* _tmp359_;
					ValaCCodeFunctionCall* _tmp360_;
					ValaCCodeFunctionCall* _tmp361_;
					ValaMethod* _tmp362_;
					gchar* _tmp363_;
					gchar* _tmp364_;
					ValaCCodeMemberAccess* _tmp365_;
					ValaCCodeMemberAccess* _tmp366_;
					_tmp353_ = async_call;
					_tmp354_ = vcast;
					_tmp355_ = m;
					_tmp356_ = vala_get_ccode_vfunc_name (_tmp355_);
					_tmp357_ = _tmp356_;
					_tmp358_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp354_, _tmp357_);
					_tmp359_ = _tmp358_;
					vala_ccode_function_call_set_call (_tmp353_, (ValaCCodeExpression*) _tmp359_);
					_vala_ccode_node_unref0 (_tmp359_);
					_g_free0 (_tmp357_);
					_tmp360_ = finish_call;
					_tmp361_ = vcast;
					_tmp362_ = m;
					_tmp363_ = vala_get_ccode_finish_vfunc_name (_tmp362_);
					_tmp364_ = _tmp363_;
					_tmp365_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp361_, _tmp364_);
					_tmp366_ = _tmp365_;
					vala_ccode_function_call_set_call (_tmp360_, (ValaCCodeExpression*) _tmp366_);
					_vala_ccode_node_unref0 (_tmp366_);
					_g_free0 (_tmp364_);
				}
				_vala_ccode_node_unref0 (vcast);
				_vala_ccode_node_unref0 (pub_inst);
				_vala_target_value_unref0 (instance_value);
			}
		}
		_tmp368_ = ma;
		_tmp369_ = vala_member_access_get_member_name (_tmp368_);
		_tmp370_ = _tmp369_;
		if (g_strcmp0 (_tmp370_, "begin") == 0) {
			ValaMemberAccess* _tmp371_;
			ValaExpression* _tmp372_;
			ValaExpression* _tmp373_;
			ValaSymbol* _tmp374_;
			ValaSymbol* _tmp375_;
			ValaMemberAccess* _tmp376_;
			ValaSymbol* _tmp377_;
			ValaSymbol* _tmp378_;
			_tmp371_ = ma;
			_tmp372_ = vala_member_access_get_inner (_tmp371_);
			_tmp373_ = _tmp372_;
			_tmp374_ = vala_expression_get_symbol_reference (_tmp373_);
			_tmp375_ = _tmp374_;
			_tmp376_ = ma;
			_tmp377_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp376_);
			_tmp378_ = _tmp377_;
			_tmp367_ = _tmp375_ == _tmp378_;
		} else {
			_tmp367_ = FALSE;
		}
		if (_tmp367_) {
			ValaCCodeFunctionCall* _tmp379_;
			ValaCCodeFunctionCall* _tmp380_;
			ValaMethod* _tmp381_;
			ValaList* _tmp382_;
			_tmp379_ = async_call;
			_tmp380_ = _vala_ccode_node_ref0 (_tmp379_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp380_;
			_tmp381_ = m;
			_tmp382_ = vala_method_get_async_begin_parameters (_tmp381_);
			_vala_iterable_unref0 (params);
			params = _tmp382_;
		} else {
			gboolean _tmp383_ = FALSE;
			ValaMemberAccess* _tmp384_;
			const gchar* _tmp385_;
			const gchar* _tmp386_;
			_tmp384_ = ma;
			_tmp385_ = vala_member_access_get_member_name (_tmp384_);
			_tmp386_ = _tmp385_;
			if (g_strcmp0 (_tmp386_, "end") == 0) {
				ValaMemberAccess* _tmp387_;
				ValaExpression* _tmp388_;
				ValaExpression* _tmp389_;
				ValaSymbol* _tmp390_;
				ValaSymbol* _tmp391_;
				ValaMemberAccess* _tmp392_;
				ValaSymbol* _tmp393_;
				ValaSymbol* _tmp394_;
				_tmp387_ = ma;
				_tmp388_ = vala_member_access_get_inner (_tmp387_);
				_tmp389_ = _tmp388_;
				_tmp390_ = vala_expression_get_symbol_reference (_tmp389_);
				_tmp391_ = _tmp390_;
				_tmp392_ = ma;
				_tmp393_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp392_);
				_tmp394_ = _tmp393_;
				_tmp383_ = _tmp391_ == _tmp394_;
			} else {
				_tmp383_ = FALSE;
			}
			if (_tmp383_) {
				ValaCCodeFunctionCall* _tmp395_;
				ValaCCodeFunctionCall* _tmp396_;
				ValaMethod* _tmp397_;
				ValaList* _tmp398_;
				_tmp395_ = finish_call;
				_tmp396_ = _vala_ccode_node_ref0 (_tmp395_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp396_;
				_tmp397_ = m;
				_tmp398_ = vala_method_get_async_end_parameters (_tmp397_);
				_vala_iterable_unref0 (params);
				params = _tmp398_;
			} else {
				gboolean _tmp399_;
				gboolean _tmp400_;
				_tmp399_ = vala_method_call_get_is_yield_expression (expr);
				_tmp400_ = _tmp399_;
				if (!_tmp400_) {
					ValaCCodeFunctionCall* _tmp401_;
					ValaCCodeFunctionCall* _tmp402_;
					ValaMethod* _tmp403_;
					ValaList* _tmp404_;
					_tmp401_ = async_call;
					_tmp402_ = _vala_ccode_node_ref0 (_tmp401_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp402_;
					_tmp403_ = m;
					_tmp404_ = vala_method_get_async_begin_parameters (_tmp403_);
					_vala_iterable_unref0 (params);
					params = _tmp404_;
				} else {
					ValaCCodeFunctionCall* _tmp405_;
					ValaCCodeFunctionCall* _tmp406_;
					GHashFunc _tmp407_;
					GEqualFunc _tmp408_;
					GEqualFunc _tmp409_;
					ValaHashMap* _tmp410_;
					ValaHashMap* _tmp411_;
					ValaMethod* _tmp412_;
					ValaCCodeIdentifier* _tmp413_;
					ValaCCodeIdentifier* _tmp414_;
					ValaCCodeMemberAccess* _tmp415_;
					ValaCCodeMemberAccess* _tmp416_;
					_tmp405_ = finish_call;
					_tmp406_ = _vala_ccode_node_ref0 (_tmp405_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp406_;
					_tmp407_ = g_direct_hash;
					_tmp408_ = g_direct_equal;
					_tmp409_ = g_direct_equal;
					_tmp410_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp407_, _tmp408_, _tmp409_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp410_;
					_tmp411_ = out_arg_map;
					_tmp412_ = m;
					_tmp413_ = vala_ccode_identifier_new ("_data_");
					_tmp414_ = _tmp413_;
					_tmp415_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp414_, "_res_");
					_tmp416_ = _tmp415_;
					vala_map_set ((ValaMap*) _tmp411_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp412_), FALSE)), (ValaCCodeExpression*) _tmp416_);
					_vala_ccode_node_unref0 (_tmp416_);
					_vala_ccode_node_unref0 (_tmp414_);
				}
			}
		}
	}
	_tmp418_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp418_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp419_;
		ValaSymbol* _tmp420_;
		ValaSymbol* _tmp421_;
		_tmp419_ = m;
		_tmp420_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp419_);
		_tmp421_ = _tmp420_;
		_tmp417_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp421_, VALA_TYPE_CLASS);
	} else {
		_tmp417_ = FALSE;
	}
	if (_tmp417_) {
		ValaCodeContext* _tmp422_;
		ValaCodeContext* _tmp423_;
		ValaProfile _tmp424_;
		ValaProfile _tmp425_;
		ValaClass* _tmp437_;
		ValaClass* _tmp438_;
		gboolean _tmp439_;
		gboolean _tmp440_;
		_tmp422_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp423_ = _tmp422_;
		_tmp424_ = vala_code_context_get_profile (_tmp423_);
		_tmp425_ = _tmp424_;
		if (_tmp425_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp426_;
			ValaSymbol* _tmp427_;
			ValaSymbol* _tmp428_;
			gboolean _tmp429_;
			gboolean _tmp430_;
			_tmp426_ = m;
			_tmp427_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp426_);
			_tmp428_ = _tmp427_;
			_tmp429_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp428_, VALA_TYPE_CLASS, ValaClass));
			_tmp430_ = _tmp429_;
			if (!_tmp430_) {
				ValaCCodeFunctionCall* _tmp431_;
				ValaCCodeExpression* _tmp432_;
				ValaCCodeExpression* _tmp433_;
				_tmp431_ = ccall;
				_tmp432_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp433_ = _tmp432_;
				vala_ccode_function_call_add_argument (_tmp431_, _tmp433_);
				_vala_ccode_node_unref0 (_tmp433_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp434_;
			ValaCCodeExpression* _tmp435_;
			ValaCCodeExpression* _tmp436_;
			_tmp434_ = ccall;
			_tmp435_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp436_ = _tmp435_;
			vala_ccode_function_call_add_argument (_tmp434_, _tmp436_);
			_vala_ccode_node_unref0 (_tmp436_);
		}
		_tmp437_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp438_ = _tmp437_;
		_tmp439_ = vala_class_get_is_compact (_tmp438_);
		_tmp440_ = _tmp439_;
		if (!_tmp440_) {
			ValaClass* _tmp441_;
			ValaClass* _tmp442_;
			ValaMethod* _tmp443_;
			ValaSymbol* _tmp444_;
			ValaSymbol* _tmp445_;
			_tmp441_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp442_ = _tmp441_;
			_tmp443_ = m;
			_tmp444_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp443_);
			_tmp445_ = _tmp444_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp442_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp445_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp446_;
					ValaClass* _tmp447_;
					ValaList* _tmp448_;
					ValaList* _tmp449_;
					gint _base_type_size = 0;
					ValaList* _tmp450_;
					gint _tmp451_;
					gint _tmp452_;
					gint _base_type_index = 0;
					_tmp446_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp447_ = _tmp446_;
					_tmp448_ = vala_class_get_base_types (_tmp447_);
					_tmp449_ = _vala_iterable_ref0 (_tmp448_);
					_base_type_list = _tmp449_;
					_tmp450_ = _base_type_list;
					_tmp451_ = vala_collection_get_size ((ValaCollection*) _tmp450_);
					_tmp452_ = _tmp451_;
					_base_type_size = _tmp452_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp453_;
						gint _tmp454_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp455_;
						gpointer _tmp456_;
						ValaDataType* _tmp457_;
						ValaTypeSymbol* _tmp458_;
						ValaTypeSymbol* _tmp459_;
						_base_type_index = _base_type_index + 1;
						_tmp453_ = _base_type_index;
						_tmp454_ = _base_type_size;
						if (!(_tmp453_ < _tmp454_)) {
							break;
						}
						_tmp455_ = _base_type_list;
						_tmp456_ = vala_list_get (_tmp455_, _base_type_index);
						base_type = (ValaDataType*) _tmp456_;
						_tmp457_ = base_type;
						_tmp458_ = vala_data_type_get_type_symbol (_tmp457_);
						_tmp459_ = _tmp458_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp459_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp460_;
							gchar* _tmp461_;
							gchar* _tmp462_;
							gboolean _tmp463_;
							ValaHashMap* _tmp469_;
							ValaDataType* _tmp470_;
							ValaList* _tmp471_;
							ValaList* _tmp472_;
							type_parameters = NULL;
							_tmp460_ = m;
							_tmp461_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp460_);
							_tmp462_ = _tmp461_;
							_tmp463_ = g_strcmp0 (_tmp462_, "g_object_new") == 0;
							_g_free0 (_tmp462_);
							if (_tmp463_) {
								ValaDataType* _tmp464_;
								ValaTypeSymbol* _tmp465_;
								ValaTypeSymbol* _tmp466_;
								ValaList* _tmp467_;
								ValaList* _tmp468_;
								_tmp464_ = base_type;
								_tmp465_ = vala_data_type_get_type_symbol (_tmp464_);
								_tmp466_ = _tmp465_;
								_tmp467_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp466_, VALA_TYPE_CLASS, ValaClass));
								_tmp468_ = _vala_iterable_ref0 (_tmp467_);
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp468_;
							}
							_tmp469_ = in_arg_map;
							_tmp470_ = base_type;
							_tmp471_ = vala_data_type_get_type_arguments (_tmp470_);
							_tmp472_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp469_, _tmp471_, (ValaCodeNode*) expr, TRUE, _tmp472_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp473_;
				ValaSymbol* _tmp474_;
				ValaSymbol* _tmp475_;
				ValaClass* _tmp476_;
				type_param_index = 0;
				_tmp473_ = m;
				_tmp474_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp473_);
				_tmp475_ = _tmp474_;
				_tmp476_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp475_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp476_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp477_;
					ValaList* _tmp478_;
					ValaList* _tmp479_;
					gint _type_param_size = 0;
					ValaList* _tmp480_;
					gint _tmp481_;
					gint _tmp482_;
					gint _type_param_index = 0;
					_tmp477_ = cl;
					_tmp478_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp477_);
					_tmp479_ = _vala_iterable_ref0 (_tmp478_);
					_type_param_list = _tmp479_;
					_tmp480_ = _type_param_list;
					_tmp481_ = vala_collection_get_size ((ValaCollection*) _tmp480_);
					_tmp482_ = _tmp481_;
					_type_param_size = _tmp482_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp483_;
						gint _tmp484_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp485_;
						gpointer _tmp486_;
						ValaHashMap* _tmp487_;
						ValaTypeParameter* _tmp488_;
						const gchar* _tmp489_;
						const gchar* _tmp490_;
						gchar* _tmp491_;
						gchar* _tmp492_;
						gchar* _tmp493_;
						gchar* _tmp494_;
						ValaCCodeIdentifier* _tmp495_;
						ValaCCodeIdentifier* _tmp496_;
						ValaHashMap* _tmp497_;
						ValaTypeParameter* _tmp498_;
						const gchar* _tmp499_;
						const gchar* _tmp500_;
						gchar* _tmp501_;
						gchar* _tmp502_;
						gchar* _tmp503_;
						gchar* _tmp504_;
						ValaCCodeIdentifier* _tmp505_;
						ValaCCodeIdentifier* _tmp506_;
						ValaHashMap* _tmp507_;
						ValaTypeParameter* _tmp508_;
						const gchar* _tmp509_;
						const gchar* _tmp510_;
						gchar* _tmp511_;
						gchar* _tmp512_;
						gchar* _tmp513_;
						gchar* _tmp514_;
						ValaCCodeIdentifier* _tmp515_;
						ValaCCodeIdentifier* _tmp516_;
						gint _tmp517_;
						_type_param_index = _type_param_index + 1;
						_tmp483_ = _type_param_index;
						_tmp484_ = _type_param_size;
						if (!(_tmp483_ < _tmp484_)) {
							break;
						}
						_tmp485_ = _type_param_list;
						_tmp486_ = vala_list_get (_tmp485_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp486_;
						_tmp487_ = in_arg_map;
						_tmp488_ = type_param;
						_tmp489_ = vala_symbol_get_name ((ValaSymbol*) _tmp488_);
						_tmp490_ = _tmp489_;
						_tmp491_ = g_ascii_strdown (_tmp490_, (gssize) -1);
						_tmp492_ = _tmp491_;
						_tmp493_ = g_strdup_printf ("%s_type", _tmp492_);
						_tmp494_ = _tmp493_;
						_tmp495_ = vala_ccode_identifier_new (_tmp494_);
						_tmp496_ = _tmp495_;
						vala_map_set ((ValaMap*) _tmp487_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp496_);
						_vala_ccode_node_unref0 (_tmp496_);
						_g_free0 (_tmp494_);
						_g_free0 (_tmp492_);
						_tmp497_ = in_arg_map;
						_tmp498_ = type_param;
						_tmp499_ = vala_symbol_get_name ((ValaSymbol*) _tmp498_);
						_tmp500_ = _tmp499_;
						_tmp501_ = g_ascii_strdown (_tmp500_, (gssize) -1);
						_tmp502_ = _tmp501_;
						_tmp503_ = g_strdup_printf ("%s_dup_func", _tmp502_);
						_tmp504_ = _tmp503_;
						_tmp505_ = vala_ccode_identifier_new (_tmp504_);
						_tmp506_ = _tmp505_;
						vala_map_set ((ValaMap*) _tmp497_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp506_);
						_vala_ccode_node_unref0 (_tmp506_);
						_g_free0 (_tmp504_);
						_g_free0 (_tmp502_);
						_tmp507_ = in_arg_map;
						_tmp508_ = type_param;
						_tmp509_ = vala_symbol_get_name ((ValaSymbol*) _tmp508_);
						_tmp510_ = _tmp509_;
						_tmp511_ = g_ascii_strdown (_tmp510_, (gssize) -1);
						_tmp512_ = _tmp511_;
						_tmp513_ = g_strdup_printf ("%s_destroy_func", _tmp512_);
						_tmp514_ = _tmp513_;
						_tmp515_ = vala_ccode_identifier_new (_tmp514_);
						_tmp516_ = _tmp515_;
						vala_map_set ((ValaMap*) _tmp507_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp516_);
						_vala_ccode_node_unref0 (_tmp516_);
						_g_free0 (_tmp514_);
						_g_free0 (_tmp512_);
						_tmp517_ = type_param_index;
						type_param_index = _tmp517_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp518_;
			ValaClass* _tmp519_;
			ValaClass* _tmp520_;
			ValaClass* _tmp521_;
			ValaClass* _tmp522_;
			_tmp518_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp519_ = _tmp518_;
			_tmp520_ = vala_class_get_base_class (_tmp519_);
			_tmp521_ = _tmp520_;
			_tmp522_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp521_ == _tmp522_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp523_;
				ValaClass* _tmp524_;
				gchar* _tmp525_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp526_;
				ValaCCodeDeclaration* _tmp527_;
				ValaCCodeDeclaration* _tmp528_;
				const gchar* _tmp529_;
				const gchar* _tmp530_;
				const gchar* _tmp531_;
				const gchar* _tmp532_;
				gchar* _tmp533_;
				gchar* _tmp534_;
				ValaCCodeConstant* _tmp535_;
				ValaCCodeConstant* _tmp536_;
				ValaCCodeVariableDeclarator* _tmp537_;
				ValaCCodeVariableDeclarator* _tmp538_;
				ValaCCodeFunction* _tmp539_;
				ValaCCodeFunction* _tmp540_;
				ValaCCodeDeclaration* _tmp541_;
				ValaCCodeFunctionCall* _tmp542_;
				ValaCCodeIdentifier* _tmp543_;
				ValaCCodeIdentifier* _tmp544_;
				ValaCCodeUnaryExpression* _tmp545_;
				ValaCCodeUnaryExpression* _tmp546_;
				ValaCCodeCastExpression* _tmp547_;
				ValaCCodeCastExpression* _tmp548_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp549_;
				ValaCCodeIdentifier* _tmp550_;
				ValaCCodeFunctionCall* _tmp551_;
				ValaCCodeFunctionCall* _tmp552_;
				ValaCCodeFunctionCall* _tmp553_;
				ValaClass* _tmp554_;
				ValaClass* _tmp555_;
				gchar* _tmp556_;
				gchar* _tmp557_;
				ValaCCodeIdentifier* _tmp558_;
				ValaCCodeIdentifier* _tmp559_;
				ValaCCodeFunctionCall* _tmp560_;
				ValaCCodeFunctionCall* _tmp561_;
				_tmp523_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp524_ = _tmp523_;
				_tmp525_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp524_, NULL);
				class_prefix = _tmp525_;
				_tmp526_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp526_;
				_tmp527_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp527_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp528_ = funcs;
				_tmp529_ = class_prefix;
				_tmp530_ = class_prefix;
				_tmp531_ = class_prefix;
				_tmp532_ = class_prefix;
				_tmp533_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp529_, _tmp530_, _tmp531_, _tmp532_);
				_tmp534_ = _tmp533_;
				_tmp535_ = vala_ccode_constant_new (_tmp534_);
				_tmp536_ = _tmp535_;
				_tmp537_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp536_, NULL);
				_tmp538_ = _tmp537_;
				vala_ccode_declaration_add_declarator (_tmp528_, (ValaCCodeDeclarator*) _tmp538_);
				_vala_ccode_node_unref0 (_tmp538_);
				_vala_ccode_node_unref0 (_tmp536_);
				_g_free0 (_tmp534_);
				_tmp539_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp540_ = _tmp539_;
				_tmp541_ = funcs;
				vala_ccode_function_add_statement (_tmp540_, (ValaCCodeNode*) _tmp541_);
				_tmp542_ = ccall;
				_tmp543_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp544_ = _tmp543_;
				_tmp545_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp544_);
				_tmp546_ = _tmp545_;
				_tmp547_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp546_, "GSourceFuncs *");
				_tmp548_ = _tmp547_;
				vala_ccode_function_call_add_argument (_tmp542_, (ValaCCodeExpression*) _tmp548_);
				_vala_ccode_node_unref0 (_tmp548_);
				_vala_ccode_node_unref0 (_tmp546_);
				_vala_ccode_node_unref0 (_tmp544_);
				_tmp549_ = vala_ccode_identifier_new ("sizeof");
				_tmp550_ = _tmp549_;
				_tmp551_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp550_);
				_tmp552_ = _tmp551_;
				_vala_ccode_node_unref0 (_tmp550_);
				csizeof = _tmp552_;
				_tmp553_ = csizeof;
				_tmp554_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp555_ = _tmp554_;
				_tmp556_ = vala_get_ccode_name ((ValaCodeNode*) _tmp555_);
				_tmp557_ = _tmp556_;
				_tmp558_ = vala_ccode_identifier_new (_tmp557_);
				_tmp559_ = _tmp558_;
				vala_ccode_function_call_add_argument (_tmp553_, (ValaCCodeExpression*) _tmp559_);
				_vala_ccode_node_unref0 (_tmp559_);
				_g_free0 (_tmp557_);
				_tmp560_ = ccall;
				_tmp561_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp560_, (ValaCCodeExpression*) _tmp561_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp562_ = FALSE;
		ValaMethod* _tmp563_;
		_tmp563_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp563_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp564_;
			ValaSymbol* _tmp565_;
			ValaSymbol* _tmp566_;
			_tmp564_ = m;
			_tmp565_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp564_);
			_tmp566_ = _tmp565_;
			_tmp562_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp566_, VALA_TYPE_STRUCT);
		} else {
			_tmp562_ = FALSE;
		}
		if (_tmp562_) {
			ValaCCodeFunctionCall* _tmp567_;
			ValaCCodeExpression* _tmp568_;
			ValaCCodeExpression* _tmp569_;
			_tmp567_ = ccall;
			_tmp568_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp569_ = _tmp568_;
			vala_ccode_function_call_add_argument (_tmp567_, _tmp569_);
			_vala_ccode_node_unref0 (_tmp569_);
		} else {
			gboolean _tmp570_ = FALSE;
			gboolean _tmp571_ = FALSE;
			gboolean _tmp572_ = FALSE;
			gboolean _tmp573_ = FALSE;
			ValaMethod* _tmp574_;
			_tmp574_ = m;
			if (_tmp574_ != NULL) {
				ValaMethod* _tmp575_;
				_tmp575_ = m;
				_tmp573_ = vala_method_has_type_parameters (_tmp575_);
			} else {
				_tmp573_ = FALSE;
			}
			if (_tmp573_) {
				ValaMethod* _tmp576_;
				_tmp576_ = m;
				_tmp572_ = !vala_get_ccode_has_generic_type_parameter (_tmp576_);
			} else {
				_tmp572_ = FALSE;
			}
			if (_tmp572_) {
				ValaMethod* _tmp577_;
				_tmp577_ = m;
				_tmp571_ = !vala_get_ccode_simple_generics (_tmp577_);
			} else {
				_tmp571_ = FALSE;
			}
			if (_tmp571_) {
				gboolean _tmp578_ = FALSE;
				ValaCCodeFunctionCall* _tmp579_;
				ValaCCodeFunctionCall* _tmp580_;
				_tmp579_ = ccall;
				_tmp580_ = finish_call;
				if (_tmp579_ != _tmp580_) {
					_tmp578_ = TRUE;
				} else {
					gboolean _tmp581_;
					gboolean _tmp582_;
					_tmp581_ = vala_method_call_get_is_yield_expression (expr);
					_tmp582_ = _tmp581_;
					_tmp578_ = _tmp582_;
				}
				_tmp570_ = _tmp578_;
			} else {
				_tmp570_ = FALSE;
			}
			if (_tmp570_) {
				ValaHashMap* _tmp583_;
				ValaMemberAccess* _tmp584_;
				ValaList* _tmp585_;
				_tmp583_ = in_arg_map;
				_tmp584_ = ma;
				_tmp585_ = vala_member_access_get_type_arguments (_tmp584_);
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp583_, _tmp585_, (ValaCodeNode*) expr, FALSE, NULL);
			}
		}
	}
	_tmp586_ = ccall;
	_tmp587_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp586_);
	ccall_expr = _tmp587_;
	_tmp589_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp589_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaCodeContext* _tmp590_;
		ValaCodeContext* _tmp591_;
		ValaProfile _tmp592_;
		ValaProfile _tmp593_;
		_tmp590_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp591_ = _tmp590_;
		_tmp592_ = vala_code_context_get_profile (_tmp591_);
		_tmp593_ = _tmp592_;
		_tmp588_ = _tmp593_ != VALA_PROFILE_POSIX;
	} else {
		_tmp588_ = FALSE;
	}
	if (_tmp588_) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp594_;
		ValaExpression* _tmp595_;
		ValaExpression* _tmp596_;
		ValaDataType* _tmp597_;
		ValaDataType* _tmp598_;
		ValaArrayType* _tmp599_;
		ValaHashMap* _tmp600_;
		ValaArrayType* _tmp601_;
		ValaDataType* _tmp602_;
		ValaDataType* _tmp603_;
		gchar* _tmp604_;
		gchar* _tmp605_;
		ValaCCodeIdentifier* _tmp606_;
		ValaCCodeIdentifier* _tmp607_;
		_tmp594_ = ma;
		_tmp595_ = vala_member_access_get_inner (_tmp594_);
		_tmp596_ = _tmp595_;
		_tmp597_ = vala_expression_get_value_type (_tmp596_);
		_tmp598_ = _tmp597_;
		_tmp599_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp598_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp599_;
		_tmp600_ = in_arg_map;
		_tmp601_ = array_type;
		_tmp602_ = vala_array_type_get_element_type (_tmp601_);
		_tmp603_ = _tmp602_;
		_tmp604_ = vala_get_ccode_name ((ValaCodeNode*) _tmp603_);
		_tmp605_ = _tmp604_;
		_tmp606_ = vala_ccode_identifier_new (_tmp605_);
		_tmp607_ = _tmp606_;
		vala_map_set ((ValaMap*) _tmp600_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp607_);
		_vala_ccode_node_unref0 (_tmp607_);
		_g_free0 (_tmp605_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp608_;
		_tmp608_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp608_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp609_;
			_tmp609_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp609_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp610_;
				ValaExpression* _tmp611_;
				ValaExpression* _tmp612_;
				ValaTargetValue* _tmp613_;
				ValaTargetValue* _tmp614_;
				ValaTargetValue* _tmp615_;
				ValaTargetValue* _tmp616_;
				_tmp610_ = ma;
				_tmp611_ = vala_member_access_get_inner (_tmp610_);
				_tmp612_ = _tmp611_;
				_tmp613_ = vala_expression_get_target_value (_tmp612_);
				_tmp614_ = _tmp613_;
				_tmp615_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp614_, (ValaCodeNode*) expr);
				_tmp616_ = _tmp615_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp616_);
				_vala_target_value_unref0 (_tmp616_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp618_ = m;
	if (_tmp618_ != NULL) {
		ValaMethod* _tmp619_;
		gboolean _tmp620_;
		gboolean _tmp621_;
		_tmp619_ = m;
		_tmp620_ = vala_method_get_is_async_callback (_tmp619_);
		_tmp621_ = _tmp620_;
		_tmp617_ = _tmp621_;
	} else {
		_tmp617_ = FALSE;
	}
	if (_tmp617_) {
		ValaMethod* _tmp622_;
		ValaMethod* _tmp623_;
		gboolean _tmp624_;
		gboolean _tmp625_;
		ValaHashMap* _tmp639_;
		ValaMethod* _tmp640_;
		ValaCCodeExpression* _tmp641_;
		ValaHashMap* _tmp642_;
		ValaMethod* _tmp643_;
		ValaCCodeExpression* _tmp644_;
		_tmp622_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp623_ = _tmp622_;
		_tmp624_ = vala_method_get_closure (_tmp623_);
		_tmp625_ = _tmp624_;
		if (_tmp625_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp626_;
			ValaSymbol* _tmp627_;
			ValaSymbol* _tmp628_;
			ValaBlock* _tmp629_;
			ValaBlock* _tmp630_;
			ValaBlock* _tmp631_;
			ValaBlock* _tmp632_;
			gchar* _tmp633_;
			gchar* _tmp634_;
			ValaCCodeExpression* _tmp635_;
			ValaCCodeExpression* _tmp636_;
			ValaCCodeMemberAccess* _tmp637_;
			_tmp626_ = m;
			_tmp627_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp626_);
			_tmp628_ = _tmp627_;
			_tmp629_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp628_, VALA_TYPE_METHOD, ValaMethod));
			_tmp630_ = _tmp629_;
			_tmp631_ = _vala_code_node_ref0 (_tmp630_);
			block = _tmp631_;
			_tmp632_ = block;
			_tmp633_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp632_));
			_tmp634_ = _tmp633_;
			_tmp635_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp634_);
			_tmp636_ = _tmp635_;
			_tmp637_ = vala_ccode_member_access_new_pointer (_tmp636_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp637_;
			_vala_ccode_node_unref0 (_tmp636_);
			_g_free0 (_tmp634_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp638_;
			_tmp638_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp638_;
		}
		_tmp639_ = in_arg_map;
		_tmp640_ = m;
		_tmp641_ = instance;
		vala_map_set ((ValaMap*) _tmp639_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp640_), FALSE)), _tmp641_);
		_tmp642_ = out_arg_map;
		_tmp643_ = m;
		_tmp644_ = instance;
		vala_map_set ((ValaMap*) _tmp642_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp643_), FALSE)), _tmp644_);
	} else {
		gboolean _tmp645_ = FALSE;
		gboolean _tmp646_ = FALSE;
		ValaMethod* _tmp647_;
		_tmp647_ = m;
		if (_tmp647_ != NULL) {
			ValaMethod* _tmp648_;
			ValaMemberBinding _tmp649_;
			ValaMemberBinding _tmp650_;
			_tmp648_ = m;
			_tmp649_ = vala_method_get_binding (_tmp648_);
			_tmp650_ = _tmp649_;
			_tmp646_ = _tmp650_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp646_ = FALSE;
		}
		if (_tmp646_) {
			ValaMethod* _tmp651_;
			_tmp651_ = m;
			_tmp645_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp651_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp645_ = FALSE;
		}
		if (_tmp645_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp652_;
			ValaExpression* _tmp653_;
			ValaExpression* _tmp654_;
			ValaTargetValue* _tmp655_;
			ValaTargetValue* _tmp656_;
			ValaTargetValue* _tmp657_;
			gboolean _tmp658_ = FALSE;
			gboolean _tmp659_ = FALSE;
			ValaMemberAccess* _tmp660_;
			const gchar* _tmp661_;
			const gchar* _tmp662_;
			ValaTargetValue* _tmp684_;
			ValaCCodeExpression* _tmp685_;
			ValaCCodeExpression* _tmp686_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp687_;
			ValaSymbol* _tmp688_;
			ValaSymbol* _tmp689_;
			ValaStruct* _tmp690_;
			gboolean _tmp691_ = FALSE;
			ValaStruct* _tmp692_;
			ValaMethod* _tmp700_;
			gboolean _tmp701_;
			gboolean _tmp702_;
			_tmp652_ = ma;
			_tmp653_ = vala_member_access_get_inner (_tmp652_);
			_tmp654_ = _tmp653_;
			_tmp655_ = vala_expression_get_target_value (_tmp654_);
			_tmp656_ = _tmp655_;
			_tmp657_ = _vala_target_value_ref0 (_tmp656_);
			instance_value = _tmp657_;
			_tmp660_ = ma;
			_tmp661_ = vala_member_access_get_member_name (_tmp660_);
			_tmp662_ = _tmp661_;
			if (g_strcmp0 (_tmp662_, "begin") == 0) {
				_tmp659_ = TRUE;
			} else {
				ValaMemberAccess* _tmp663_;
				const gchar* _tmp664_;
				const gchar* _tmp665_;
				_tmp663_ = ma;
				_tmp664_ = vala_member_access_get_member_name (_tmp663_);
				_tmp665_ = _tmp664_;
				_tmp659_ = g_strcmp0 (_tmp665_, "end") == 0;
			}
			if (_tmp659_) {
				ValaMemberAccess* _tmp666_;
				ValaExpression* _tmp667_;
				ValaExpression* _tmp668_;
				ValaSymbol* _tmp669_;
				ValaSymbol* _tmp670_;
				ValaMemberAccess* _tmp671_;
				ValaSymbol* _tmp672_;
				ValaSymbol* _tmp673_;
				_tmp666_ = ma;
				_tmp667_ = vala_member_access_get_inner (_tmp666_);
				_tmp668_ = _tmp667_;
				_tmp669_ = vala_expression_get_symbol_reference (_tmp668_);
				_tmp670_ = _tmp669_;
				_tmp671_ = ma;
				_tmp672_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp671_);
				_tmp673_ = _tmp672_;
				_tmp658_ = _tmp670_ == _tmp673_;
			} else {
				_tmp658_ = FALSE;
			}
			if (_tmp658_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp674_;
				ValaExpression* _tmp675_;
				ValaExpression* _tmp676_;
				ValaMemberAccess* _tmp677_;
				ValaMemberAccess* _tmp678_;
				ValaExpression* _tmp679_;
				ValaExpression* _tmp680_;
				ValaTargetValue* _tmp681_;
				ValaTargetValue* _tmp682_;
				ValaTargetValue* _tmp683_;
				_tmp674_ = ma;
				_tmp675_ = vala_member_access_get_inner (_tmp674_);
				_tmp676_ = _tmp675_;
				_tmp677_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp676_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp677_;
				_tmp678_ = inner_ma;
				_tmp679_ = vala_member_access_get_inner (_tmp678_);
				_tmp680_ = _tmp679_;
				_tmp681_ = vala_expression_get_target_value (_tmp680_);
				_tmp682_ = _tmp681_;
				_tmp683_ = _vala_target_value_ref0 (_tmp682_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp683_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp684_ = instance_value;
			_tmp685_ = vala_get_cvalue_ (_tmp684_);
			_tmp686_ = _vala_ccode_node_ref0 (_tmp685_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp686_;
			_tmp687_ = m;
			_tmp688_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp687_);
			_tmp689_ = _tmp688_;
			_tmp690_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp689_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp689_) : NULL);
			st = _tmp690_;
			_tmp692_ = st;
			if (_tmp692_ != NULL) {
				ValaStruct* _tmp693_;
				_tmp693_ = st;
				_tmp691_ = !vala_struct_is_simple_type (_tmp693_);
			} else {
				_tmp691_ = FALSE;
			}
			if (_tmp691_) {
				ValaTargetValue* _tmp694_;
				ValaTargetValue* _tmp697_;
				ValaCCodeExpression* _tmp698_;
				ValaCCodeUnaryExpression* _tmp699_;
				_tmp694_ = instance_value;
				if (!vala_get_lvalue (_tmp694_)) {
					ValaTargetValue* _tmp695_;
					ValaTargetValue* _tmp696_;
					_tmp695_ = instance_value;
					_tmp696_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp695_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp696_;
				}
				_tmp697_ = instance_value;
				_tmp698_ = vala_get_cvalue_ (_tmp697_);
				_tmp699_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp698_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp699_;
			}
			_tmp700_ = m;
			_tmp701_ = vala_method_get_coroutine (_tmp700_);
			_tmp702_ = _tmp701_;
			if (!_tmp702_) {
				ValaHashMap* _tmp703_;
				ValaMethod* _tmp704_;
				ValaCCodeExpression* _tmp705_;
				_tmp703_ = in_arg_map;
				_tmp704_ = m;
				_tmp705_ = instance;
				vala_map_set ((ValaMap*) _tmp703_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp704_), FALSE)), _tmp705_);
			} else {
				gboolean _tmp706_;
				gboolean _tmp707_;
				_tmp706_ = vala_method_call_get_is_yield_expression (expr);
				_tmp707_ = _tmp706_;
				if (_tmp707_) {
					ValaHashMap* _tmp708_;
					ValaMethod* _tmp709_;
					ValaCCodeExpression* _tmp710_;
					ValaMethod* _tmp711_;
					_tmp708_ = in_arg_map;
					_tmp709_ = m;
					_tmp710_ = instance;
					vala_map_set ((ValaMap*) _tmp708_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp709_), FALSE)), _tmp710_);
					_tmp711_ = m;
					if (vala_get_ccode_finish_instance (_tmp711_)) {
						ValaHashMap* _tmp712_;
						ValaMethod* _tmp713_;
						ValaCCodeExpression* _tmp714_;
						_tmp712_ = out_arg_map;
						_tmp713_ = m;
						_tmp714_ = instance;
						vala_map_set ((ValaMap*) _tmp712_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp713_), FALSE)), _tmp714_);
					}
				} else {
					gboolean _tmp715_ = FALSE;
					ValaMemberAccess* _tmp716_;
					const gchar* _tmp717_;
					const gchar* _tmp718_;
					_tmp716_ = ma;
					_tmp717_ = vala_member_access_get_member_name (_tmp716_);
					_tmp718_ = _tmp717_;
					if (g_strcmp0 (_tmp718_, "end") != 0) {
						_tmp715_ = TRUE;
					} else {
						ValaMethod* _tmp719_;
						_tmp719_ = m;
						_tmp715_ = vala_get_ccode_finish_instance (_tmp719_);
					}
					if (_tmp715_) {
						ValaHashMap* _tmp720_;
						ValaMethod* _tmp721_;
						ValaCCodeExpression* _tmp722_;
						ValaHashMap* _tmp723_;
						ValaMethod* _tmp724_;
						ValaCCodeExpression* _tmp725_;
						_tmp720_ = out_arg_map;
						_tmp721_ = m;
						_tmp722_ = instance;
						vala_map_set ((ValaMap*) _tmp720_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp721_), FALSE)), _tmp722_);
						_tmp723_ = in_arg_map;
						_tmp724_ = m;
						_tmp725_ = instance;
						vala_map_set ((ValaMap*) _tmp723_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp724_), FALSE)), _tmp725_);
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp726_ = FALSE;
			ValaMethod* _tmp727_;
			_tmp727_ = m;
			if (_tmp727_ != NULL) {
				ValaMethod* _tmp728_;
				ValaMemberBinding _tmp729_;
				ValaMemberBinding _tmp730_;
				_tmp728_ = m;
				_tmp729_ = vala_method_get_binding (_tmp728_);
				_tmp730_ = _tmp729_;
				_tmp726_ = _tmp730_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp726_ = FALSE;
			}
			if (_tmp726_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp731_;
				ValaSymbol* _tmp732_;
				ValaSymbol* _tmp733_;
				ValaClass* _tmp734_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp735_;
				gchar* _tmp736_;
				gchar* _tmp737_;
				ValaCCodeIdentifier* _tmp738_;
				ValaCCodeIdentifier* _tmp739_;
				ValaCCodeFunctionCall* _tmp740_;
				ValaCCodeFunctionCall* _tmp741_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp742_;
				ValaExpression* _tmp743_;
				ValaExpression* _tmp744_;
				ValaCCodeFunctionCall* _tmp767_;
				ValaCCodeExpression* _tmp768_;
				ValaHashMap* _tmp769_;
				ValaMethod* _tmp770_;
				ValaCCodeFunctionCall* _tmp771_;
				ValaHashMap* _tmp772_;
				ValaMethod* _tmp773_;
				ValaCCodeFunctionCall* _tmp774_;
				_tmp731_ = m;
				_tmp732_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp731_);
				_tmp733_ = _tmp732_;
				_tmp734_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp733_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp734_;
				_tmp735_ = cl;
				_tmp736_ = vala_get_ccode_class_type_function (_tmp735_);
				_tmp737_ = _tmp736_;
				_tmp738_ = vala_ccode_identifier_new (_tmp737_);
				_tmp739_ = _tmp738_;
				_tmp740_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp739_);
				_tmp741_ = _tmp740_;
				_vala_ccode_node_unref0 (_tmp739_);
				_g_free0 (_tmp737_);
				cast = _tmp741_;
				_tmp742_ = ma;
				_tmp743_ = vala_member_access_get_inner (_tmp742_);
				_tmp744_ = _tmp743_;
				if (_tmp744_ == NULL) {
					ValaDataType* _tmp745_;
					_tmp745_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					if (_tmp745_ == NULL) {
						ValaCCodeIdentifier* _tmp746_;
						_tmp746_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp746_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp747_;
						ValaCCodeIdentifier* _tmp748_;
						ValaCCodeFunctionCall* _tmp749_;
						ValaCCodeFunctionCall* _tmp750_;
						ValaCCodeFunctionCall* _tmp751_;
						ValaCCodeExpression* _tmp752_;
						ValaCCodeExpression* _tmp753_;
						ValaCCodeFunctionCall* _tmp754_;
						ValaCCodeExpression* _tmp755_;
						_tmp747_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp748_ = _tmp747_;
						_tmp749_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp748_);
						_tmp750_ = _tmp749_;
						_vala_ccode_node_unref0 (_tmp748_);
						k = _tmp750_;
						_tmp751_ = k;
						_tmp752_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp753_ = _tmp752_;
						vala_ccode_function_call_add_argument (_tmp751_, _tmp753_);
						_vala_ccode_node_unref0 (_tmp753_);
						_tmp754_ = k;
						_tmp755_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp754_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp755_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp756_;
					ValaCCodeIdentifier* _tmp757_;
					ValaCCodeFunctionCall* _tmp758_;
					ValaCCodeFunctionCall* _tmp759_;
					ValaCCodeFunctionCall* _tmp760_;
					ValaMemberAccess* _tmp761_;
					ValaExpression* _tmp762_;
					ValaExpression* _tmp763_;
					ValaCCodeExpression* _tmp764_;
					ValaCCodeFunctionCall* _tmp765_;
					ValaCCodeExpression* _tmp766_;
					_tmp756_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp757_ = _tmp756_;
					_tmp758_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp757_);
					_tmp759_ = _tmp758_;
					_vala_ccode_node_unref0 (_tmp757_);
					k = _tmp759_;
					_tmp760_ = k;
					_tmp761_ = ma;
					_tmp762_ = vala_member_access_get_inner (_tmp761_);
					_tmp763_ = _tmp762_;
					_tmp764_ = vala_get_cvalue (_tmp763_);
					vala_ccode_function_call_add_argument (_tmp760_, _tmp764_);
					_tmp765_ = k;
					_tmp766_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp765_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp766_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp767_ = cast;
				_tmp768_ = klass;
				vala_ccode_function_call_add_argument (_tmp767_, _tmp768_);
				_tmp769_ = in_arg_map;
				_tmp770_ = m;
				_tmp771_ = cast;
				vala_map_set ((ValaMap*) _tmp769_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp770_), FALSE)), (ValaCCodeExpression*) _tmp771_);
				_tmp772_ = out_arg_map;
				_tmp773_ = m;
				_tmp774_ = cast;
				vala_map_set ((ValaMap*) _tmp772_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp773_), FALSE)), (ValaCCodeExpression*) _tmp774_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp776_ = m;
	if (_tmp776_ != NULL) {
		ValaMethod* _tmp777_;
		_tmp777_ = m;
		_tmp775_ = vala_get_ccode_has_generic_type_parameter (_tmp777_);
	} else {
		_tmp775_ = FALSE;
	}
	if (_tmp775_) {
		ValaMethod* _tmp778_;
		_tmp778_ = m;
		if (vala_method_has_type_parameters (_tmp778_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp779_;
				ValaList* _tmp780_;
				ValaList* _tmp781_;
				gint _type_arg_size = 0;
				ValaList* _tmp782_;
				gint _tmp783_;
				gint _tmp784_;
				gint _type_arg_index = 0;
				_tmp779_ = ma;
				_tmp780_ = vala_member_access_get_type_arguments (_tmp779_);
				_tmp781_ = _vala_iterable_ref0 (_tmp780_);
				_type_arg_list = _tmp781_;
				_tmp782_ = _type_arg_list;
				_tmp783_ = vala_collection_get_size ((ValaCollection*) _tmp782_);
				_tmp784_ = _tmp783_;
				_type_arg_size = _tmp784_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp785_;
					gint _tmp786_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp787_;
					gpointer _tmp788_;
					gboolean _tmp789_ = FALSE;
					gboolean _tmp790_ = FALSE;
					gboolean _tmp791_ = FALSE;
					ValaMethod* _tmp792_;
					ValaHashMap* _tmp800_;
					ValaMethod* _tmp801_;
					ValaDataType* _tmp802_;
					gchar* _tmp803_;
					gchar* _tmp804_;
					ValaCCodeIdentifier* _tmp805_;
					ValaCCodeIdentifier* _tmp806_;
					gint _tmp807_;
					_type_arg_index = _type_arg_index + 1;
					_tmp785_ = _type_arg_index;
					_tmp786_ = _type_arg_size;
					if (!(_tmp785_ < _tmp786_)) {
						break;
					}
					_tmp787_ = _type_arg_list;
					_tmp788_ = vala_list_get (_tmp787_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp788_;
					_tmp792_ = m;
					if (vala_get_ccode_simple_generics (_tmp792_)) {
						ValaDataType* _tmp793_;
						_tmp793_ = type_arg;
						_tmp791_ = vala_data_type_is_real_struct_type (_tmp793_);
					} else {
						_tmp791_ = FALSE;
					}
					if (_tmp791_) {
						ValaDataType* _tmp794_;
						gboolean _tmp795_;
						gboolean _tmp796_;
						_tmp794_ = type_arg;
						_tmp795_ = vala_data_type_get_nullable (_tmp794_);
						_tmp796_ = _tmp795_;
						_tmp790_ = !_tmp796_;
					} else {
						_tmp790_ = FALSE;
					}
					if (_tmp790_) {
						ValaDataType* _tmp797_;
						_tmp797_ = type_arg;
						_tmp789_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp797_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp789_ = FALSE;
					}
					if (_tmp789_) {
						ValaDataType* _tmp798_;
						ValaPointerType* _tmp799_;
						_tmp798_ = type_arg;
						_tmp799_ = vala_pointer_type_new (_tmp798_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp799_;
					}
					_tmp800_ = in_arg_map;
					_tmp801_ = m;
					_tmp802_ = type_arg;
					_tmp803_ = vala_get_ccode_name ((ValaCodeNode*) _tmp802_);
					_tmp804_ = _tmp803_;
					_tmp805_ = vala_ccode_identifier_new (_tmp804_);
					_tmp806_ = _tmp805_;
					vala_map_set ((ValaMap*) _tmp800_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp801_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp806_);
					_vala_ccode_node_unref0 (_tmp806_);
					_g_free0 (_tmp804_);
					_tmp807_ = type_param_index;
					type_param_index = _tmp807_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp808_;
				ValaExpression* _tmp809_;
				ValaExpression* _tmp810_;
				ValaDataType* _tmp811_;
				ValaDataType* _tmp812_;
				ValaList* _tmp813_;
				ValaList* _tmp814_;
				gint _type_arg_size = 0;
				ValaList* _tmp815_;
				gint _tmp816_;
				gint _tmp817_;
				gint _type_arg_index = 0;
				_tmp808_ = ma;
				_tmp809_ = vala_member_access_get_inner (_tmp808_);
				_tmp810_ = _tmp809_;
				_tmp811_ = vala_expression_get_value_type (_tmp810_);
				_tmp812_ = _tmp811_;
				_tmp813_ = vala_data_type_get_type_arguments (_tmp812_);
				_tmp814_ = _vala_iterable_ref0 (_tmp813_);
				_type_arg_list = _tmp814_;
				_tmp815_ = _type_arg_list;
				_tmp816_ = vala_collection_get_size ((ValaCollection*) _tmp815_);
				_tmp817_ = _tmp816_;
				_type_arg_size = _tmp817_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp818_;
					gint _tmp819_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp820_;
					gpointer _tmp821_;
					ValaHashMap* _tmp822_;
					ValaMethod* _tmp823_;
					ValaDataType* _tmp824_;
					gchar* _tmp825_;
					gchar* _tmp826_;
					ValaCCodeIdentifier* _tmp827_;
					ValaCCodeIdentifier* _tmp828_;
					gint _tmp829_;
					_type_arg_index = _type_arg_index + 1;
					_tmp818_ = _type_arg_index;
					_tmp819_ = _type_arg_size;
					if (!(_tmp818_ < _tmp819_)) {
						break;
					}
					_tmp820_ = _type_arg_list;
					_tmp821_ = vala_list_get (_tmp820_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp821_;
					_tmp822_ = in_arg_map;
					_tmp823_ = m;
					_tmp824_ = type_arg;
					_tmp825_ = vala_get_ccode_name ((ValaCodeNode*) _tmp824_);
					_tmp826_ = _tmp825_;
					_tmp827_ = vala_ccode_identifier_new (_tmp826_);
					_tmp828_ = _tmp827_;
					vala_map_set ((ValaMap*) _tmp822_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp823_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp828_);
					_vala_ccode_node_unref0 (_tmp828_);
					_g_free0 (_tmp826_);
					_tmp829_ = type_param_index;
					type_param_index = _tmp829_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp830_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp830_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp831_;
		ValaExpression* _tmp832_;
		ValaExpression* _tmp833_;
		ValaDataType* _tmp834_;
		ValaDataType* _tmp835_;
		ValaArrayType* _tmp836_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp837_;
		ValaCCodeIdentifier* _tmp838_;
		ValaCCodeFunctionCall* _tmp839_;
		ValaCCodeFunctionCall* _tmp840_;
		ValaCCodeFunctionCall* _tmp841_;
		ValaArrayType* _tmp842_;
		ValaDataType* _tmp843_;
		ValaDataType* _tmp844_;
		gchar* _tmp845_;
		gchar* _tmp846_;
		ValaCCodeIdentifier* _tmp847_;
		ValaCCodeIdentifier* _tmp848_;
		ValaHashMap* _tmp849_;
		ValaCCodeFunctionCall* _tmp850_;
		_tmp831_ = ma;
		_tmp832_ = vala_member_access_get_inner (_tmp831_);
		_tmp833_ = _tmp832_;
		_tmp834_ = vala_expression_get_value_type (_tmp833_);
		_tmp835_ = _tmp834_;
		_tmp836_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp835_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp836_;
		_tmp837_ = vala_ccode_identifier_new ("sizeof");
		_tmp838_ = _tmp837_;
		_tmp839_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp838_);
		_tmp840_ = _tmp839_;
		_vala_ccode_node_unref0 (_tmp838_);
		csizeof = _tmp840_;
		_tmp841_ = csizeof;
		_tmp842_ = array_type;
		_tmp843_ = vala_array_type_get_element_type (_tmp842_);
		_tmp844_ = _tmp843_;
		_tmp845_ = vala_get_ccode_name ((ValaCodeNode*) _tmp844_);
		_tmp846_ = _tmp845_;
		_tmp847_ = vala_ccode_identifier_new (_tmp846_);
		_tmp848_ = _tmp847_;
		vala_ccode_function_call_add_argument (_tmp841_, (ValaCCodeExpression*) _tmp848_);
		_vala_ccode_node_unref0 (_tmp848_);
		_g_free0 (_tmp846_);
		_tmp849_ = in_arg_map;
		_tmp850_ = csizeof;
		vala_map_set ((ValaMap*) _tmp849_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp850_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp851_;
		_tmp851_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp851_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp852_;
			ValaMethod* _tmp853_;
			ValaMethod* _tmp854_;
			gint param_nr = 0;
			ValaMethod* _tmp920_;
			ValaCCodeBaseModuleEmitContext* _tmp921_;
			_tmp852_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp853_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp852_, (ValaSymbol*) _tmp853_);
			_tmp854_ = m;
			vala_method_clear_parameters (_tmp854_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp855_;
				ValaList* _tmp856_;
				gint _arg_size = 0;
				ValaList* _tmp857_;
				gint _tmp858_;
				gint _tmp859_;
				gint _arg_index = 0;
				_tmp855_ = vala_method_call_get_argument_list (expr);
				_tmp856_ = _vala_iterable_ref0 (_tmp855_);
				_arg_list = _tmp856_;
				_tmp857_ = _arg_list;
				_tmp858_ = vala_collection_get_size ((ValaCollection*) _tmp857_);
				_tmp859_ = _tmp858_;
				_arg_size = _tmp859_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp860_;
					gint _tmp861_;
					ValaExpression* arg = NULL;
					ValaList* _tmp862_;
					gpointer _tmp863_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp864_;
					ValaUnaryExpression* _tmp865_;
					gboolean _tmp866_ = FALSE;
					ValaUnaryExpression* _tmp867_;
					gint _tmp908_;
					_arg_index = _arg_index + 1;
					_tmp860_ = _arg_index;
					_tmp861_ = _arg_size;
					if (!(_tmp860_ < _tmp861_)) {
						break;
					}
					_tmp862_ = _arg_list;
					_tmp863_ = vala_list_get (_tmp862_, _arg_index);
					arg = (ValaExpression*) _tmp863_;
					_tmp864_ = arg;
					_tmp865_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp864_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp864_) : NULL);
					unary = _tmp865_;
					_tmp867_ = unary;
					if (_tmp867_ != NULL) {
						ValaUnaryExpression* _tmp868_;
						ValaUnaryOperator _tmp869_;
						ValaUnaryOperator _tmp870_;
						_tmp868_ = unary;
						_tmp869_ = vala_unary_expression_get_operator (_tmp868_);
						_tmp870_ = _tmp869_;
						_tmp866_ = _tmp870_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp866_ = FALSE;
					}
					if (_tmp866_) {
						ValaParameter* param = NULL;
						gchar* _tmp871_;
						gchar* _tmp872_;
						ValaUnaryExpression* _tmp873_;
						ValaExpression* _tmp874_;
						ValaExpression* _tmp875_;
						ValaDataType* _tmp876_;
						ValaDataType* _tmp877_;
						ValaParameter* _tmp878_;
						ValaParameter* _tmp879_;
						ValaParameter* _tmp880_;
						ValaMethod* _tmp881_;
						ValaParameter* _tmp882_;
						_tmp871_ = g_strdup_printf ("param%d", param_nr);
						_tmp872_ = _tmp871_;
						_tmp873_ = unary;
						_tmp874_ = vala_unary_expression_get_inner (_tmp873_);
						_tmp875_ = _tmp874_;
						_tmp876_ = vala_expression_get_value_type (_tmp875_);
						_tmp877_ = _tmp876_;
						_tmp878_ = vala_parameter_new (_tmp872_, _tmp877_, NULL);
						_tmp879_ = _tmp878_;
						_g_free0 (_tmp872_);
						param = _tmp879_;
						_tmp880_ = param;
						vala_parameter_set_direction (_tmp880_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp881_ = m;
						_tmp882_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp881_, _tmp882_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp883_ = FALSE;
						ValaUnaryExpression* _tmp884_;
						_tmp884_ = unary;
						if (_tmp884_ != NULL) {
							ValaUnaryExpression* _tmp885_;
							ValaUnaryOperator _tmp886_;
							ValaUnaryOperator _tmp887_;
							_tmp885_ = unary;
							_tmp886_ = vala_unary_expression_get_operator (_tmp885_);
							_tmp887_ = _tmp886_;
							_tmp883_ = _tmp887_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp883_ = FALSE;
						}
						if (_tmp883_) {
							ValaParameter* param = NULL;
							gchar* _tmp888_;
							gchar* _tmp889_;
							ValaUnaryExpression* _tmp890_;
							ValaExpression* _tmp891_;
							ValaExpression* _tmp892_;
							ValaDataType* _tmp893_;
							ValaDataType* _tmp894_;
							ValaParameter* _tmp895_;
							ValaParameter* _tmp896_;
							ValaParameter* _tmp897_;
							ValaMethod* _tmp898_;
							ValaParameter* _tmp899_;
							_tmp888_ = g_strdup_printf ("param%d", param_nr);
							_tmp889_ = _tmp888_;
							_tmp890_ = unary;
							_tmp891_ = vala_unary_expression_get_inner (_tmp890_);
							_tmp892_ = _tmp891_;
							_tmp893_ = vala_expression_get_value_type (_tmp892_);
							_tmp894_ = _tmp893_;
							_tmp895_ = vala_parameter_new (_tmp889_, _tmp894_, NULL);
							_tmp896_ = _tmp895_;
							_g_free0 (_tmp889_);
							param = _tmp896_;
							_tmp897_ = param;
							vala_parameter_set_direction (_tmp897_, VALA_PARAMETER_DIRECTION_REF);
							_tmp898_ = m;
							_tmp899_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp898_, _tmp899_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp900_;
							gchar* _tmp901_;
							gchar* _tmp902_;
							ValaExpression* _tmp903_;
							ValaDataType* _tmp904_;
							ValaDataType* _tmp905_;
							ValaParameter* _tmp906_;
							ValaParameter* _tmp907_;
							_tmp900_ = m;
							_tmp901_ = g_strdup_printf ("param%d", param_nr);
							_tmp902_ = _tmp901_;
							_tmp903_ = arg;
							_tmp904_ = vala_expression_get_value_type (_tmp903_);
							_tmp905_ = _tmp904_;
							_tmp906_ = vala_parameter_new (_tmp902_, _tmp905_, NULL);
							_tmp907_ = _tmp906_;
							vala_callable_add_parameter ((ValaCallable*) _tmp900_, _tmp907_);
							_vala_code_node_unref0 (_tmp907_);
							_g_free0 (_tmp902_);
						}
					}
					_tmp908_ = param_nr;
					param_nr = _tmp908_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp909_;
				ValaList* _tmp910_;
				ValaList* _tmp911_;
				gint _param_size = 0;
				ValaList* _tmp912_;
				gint _tmp913_;
				gint _tmp914_;
				gint _param_index = 0;
				_tmp909_ = m;
				_tmp910_ = vala_callable_get_parameters ((ValaCallable*) _tmp909_);
				_tmp911_ = _vala_iterable_ref0 (_tmp910_);
				_param_list = _tmp911_;
				_tmp912_ = _param_list;
				_tmp913_ = vala_collection_get_size ((ValaCollection*) _tmp912_);
				_tmp914_ = _tmp913_;
				_param_size = _tmp914_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp915_;
					gint _tmp916_;
					ValaParameter* param = NULL;
					ValaList* _tmp917_;
					gpointer _tmp918_;
					ValaParameter* _tmp919_;
					_param_index = _param_index + 1;
					_tmp915_ = _param_index;
					_tmp916_ = _param_size;
					if (!(_tmp915_ < _tmp916_)) {
						break;
					}
					_tmp917_ = _param_list;
					_tmp918_ = vala_list_get (_tmp917_, _param_index);
					param = (ValaParameter*) _tmp918_;
					_tmp919_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp919_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp920_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp920_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp921_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp921_);
		} else {
			gboolean _tmp922_ = FALSE;
			gboolean _tmp923_ = FALSE;
			ValaMethod* _tmp924_;
			_tmp924_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp924_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp925_;
				ValaCodeContext* _tmp926_;
				ValaProfile _tmp927_;
				ValaProfile _tmp928_;
				_tmp925_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp926_ = _tmp925_;
				_tmp927_ = vala_code_context_get_profile (_tmp926_);
				_tmp928_ = _tmp927_;
				_tmp923_ = _tmp928_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp923_ = FALSE;
			}
			if (_tmp923_) {
				ValaMethod* _tmp929_;
				ValaSymbol* _tmp930_;
				ValaSymbol* _tmp931_;
				_tmp929_ = m;
				_tmp930_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp929_);
				_tmp931_ = _tmp930_;
				_tmp922_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp931_, VALA_TYPE_CLASS);
			} else {
				_tmp922_ = FALSE;
			}
			if (_tmp922_) {
				ValaCCodeFunction* _tmp932_;
				ValaCCodeFunction* _tmp933_;
				ValaCCodeExpression* _tmp934_;
				ValaCCodeExpression* _tmp935_;
				ValaCCodeFunctionCall* _tmp936_;
				ValaClass* _tmp937_;
				ValaClass* _tmp938_;
				gchar* _tmp939_;
				gchar* _tmp940_;
				gchar* _tmp941_;
				gchar* _tmp942_;
				ValaCCodeCastExpression* _tmp943_;
				ValaCCodeCastExpression* _tmp944_;
				ValaMethod* _tmp945_;
				ValaMethod* _tmp946_;
				ValaBlock* _tmp947_;
				ValaBlock* _tmp948_;
				gboolean _tmp949_;
				gboolean _tmp950_;
				gboolean _tmp977_ = FALSE;
				ValaClass* _tmp978_;
				ValaClass* _tmp979_;
				gboolean _tmp980_;
				gboolean _tmp981_;
				_tmp932_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp933_ = _tmp932_;
				_tmp934_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp935_ = _tmp934_;
				_tmp936_ = ccall;
				_tmp937_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp938_ = _tmp937_;
				_tmp939_ = vala_get_ccode_name ((ValaCodeNode*) _tmp938_);
				_tmp940_ = _tmp939_;
				_tmp941_ = g_strconcat (_tmp940_, "*", NULL);
				_tmp942_ = _tmp941_;
				_tmp943_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp936_, _tmp942_);
				_tmp944_ = _tmp943_;
				vala_ccode_function_add_assignment (_tmp933_, _tmp935_, (ValaCCodeExpression*) _tmp944_);
				_vala_ccode_node_unref0 (_tmp944_);
				_g_free0 (_tmp942_);
				_g_free0 (_tmp940_);
				_vala_ccode_node_unref0 (_tmp935_);
				_tmp945_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp946_ = _tmp945_;
				_tmp947_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp946_);
				_tmp948_ = _tmp947_;
				_tmp949_ = vala_block_get_captured (_tmp948_);
				_tmp950_ = _tmp949_;
				if (_tmp950_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp951_;
					ValaClass* _tmp952_;
					ValaObjectType* _tmp953_;
					ValaObjectType* _tmp954_;
					ValaSourceReference* _tmp955_;
					ValaSourceReference* _tmp956_;
					ValaCCodeExpression* _tmp957_;
					ValaCCodeExpression* _tmp958_;
					ValaCCodeFunctionCall* _tmp959_;
					ValaCCodeFunctionCall* _tmp960_;
					ValaCCodeFunctionCall* _tmp961_;
					ValaCCodeExpression* _tmp962_;
					ValaCCodeExpression* _tmp963_;
					ValaCCodeFunction* _tmp964_;
					ValaCCodeFunction* _tmp965_;
					ValaMethod* _tmp966_;
					ValaMethod* _tmp967_;
					ValaBlock* _tmp968_;
					ValaBlock* _tmp969_;
					gchar* _tmp970_;
					gchar* _tmp971_;
					ValaCCodeExpression* _tmp972_;
					ValaCCodeExpression* _tmp973_;
					ValaCCodeMemberAccess* _tmp974_;
					ValaCCodeMemberAccess* _tmp975_;
					ValaCCodeFunctionCall* _tmp976_;
					_tmp951_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp952_ = _tmp951_;
					_tmp953_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp952_);
					_tmp954_ = _tmp953_;
					_tmp955_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp956_ = _tmp955_;
					_tmp957_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp954_, _tmp956_, FALSE);
					_tmp958_ = _tmp957_;
					_tmp959_ = vala_ccode_function_call_new (_tmp958_);
					_tmp960_ = _tmp959_;
					_vala_ccode_node_unref0 (_tmp958_);
					_vala_code_node_unref0 (_tmp954_);
					ref_call = _tmp960_;
					_tmp961_ = ref_call;
					_tmp962_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp963_ = _tmp962_;
					vala_ccode_function_call_add_argument (_tmp961_, _tmp963_);
					_vala_ccode_node_unref0 (_tmp963_);
					_tmp964_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp965_ = _tmp964_;
					_tmp966_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp967_ = _tmp966_;
					_tmp968_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp967_);
					_tmp969_ = _tmp968_;
					_tmp970_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp969_));
					_tmp971_ = _tmp970_;
					_tmp972_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp971_);
					_tmp973_ = _tmp972_;
					_tmp974_ = vala_ccode_member_access_new_pointer (_tmp973_, "self");
					_tmp975_ = _tmp974_;
					_tmp976_ = ref_call;
					vala_ccode_function_add_assignment (_tmp965_, (ValaCCodeExpression*) _tmp975_, (ValaCCodeExpression*) _tmp976_);
					_vala_ccode_node_unref0 (_tmp975_);
					_vala_ccode_node_unref0 (_tmp973_);
					_g_free0 (_tmp971_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp978_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp979_ = _tmp978_;
				_tmp980_ = vala_class_get_is_compact (_tmp979_);
				_tmp981_ = _tmp980_;
				if (!_tmp981_) {
					ValaClass* _tmp982_;
					ValaClass* _tmp983_;
					_tmp982_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp983_ = _tmp982_;
					_tmp977_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp983_);
				} else {
					_tmp977_ = FALSE;
				}
				if (_tmp977_) {
					gchar** suffices = NULL;
					gchar* _tmp984_;
					gchar* _tmp985_;
					gchar* _tmp986_;
					gchar** _tmp987_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp984_ = g_strdup ("type");
					_tmp985_ = g_strdup ("dup_func");
					_tmp986_ = g_strdup ("destroy_func");
					_tmp987_ = g_new0 (gchar*, 3 + 1);
					_tmp987_[0] = _tmp984_;
					_tmp987_[1] = _tmp985_;
					_tmp987_[2] = _tmp986_;
					suffices = _tmp987_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp988_;
						ValaClass* _tmp989_;
						ValaList* _tmp990_;
						ValaList* _tmp991_;
						gint _type_param_size = 0;
						ValaList* _tmp992_;
						gint _tmp993_;
						gint _tmp994_;
						gint _type_param_index = 0;
						_tmp988_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp989_ = _tmp988_;
						_tmp990_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp989_);
						_tmp991_ = _vala_iterable_ref0 (_tmp990_);
						_type_param_list = _tmp991_;
						_tmp992_ = _type_param_list;
						_tmp993_ = vala_collection_get_size ((ValaCollection*) _tmp992_);
						_tmp994_ = _tmp993_;
						_type_param_size = _tmp994_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp995_;
							gint _tmp996_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp997_;
							gpointer _tmp998_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp999_;
							ValaCCodeIdentifier* _tmp1000_;
							ValaCCodeMemberAccess* _tmp1001_;
							ValaCCodeMemberAccess* _tmp1002_;
							gchar** _tmp1003_;
							gint _tmp1003__length1;
							_type_param_index = _type_param_index + 1;
							_tmp995_ = _type_param_index;
							_tmp996_ = _type_param_size;
							if (!(_tmp995_ < _tmp996_)) {
								break;
							}
							_tmp997_ = _type_param_list;
							_tmp998_ = vala_list_get (_tmp997_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp998_;
							_tmp999_ = vala_ccode_identifier_new ("self");
							_tmp1000_ = _tmp999_;
							_tmp1001_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1000_, "priv");
							_tmp1002_ = _tmp1001_;
							_vala_ccode_node_unref0 (_tmp1000_);
							priv_access = _tmp1002_;
							_tmp1003_ = suffices;
							_tmp1003__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp1003_;
								suffix_collection_length1 = _tmp1003__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp1004_;
									gchar* suffix = NULL;
									_tmp1004_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp1004_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp1005_;
										const gchar* _tmp1006_;
										const gchar* _tmp1007_;
										gchar* _tmp1008_;
										gchar* _tmp1009_;
										const gchar* _tmp1010_;
										gchar* _tmp1011_;
										gchar* _tmp1012_;
										ValaCCodeIdentifier* _tmp1013_;
										ValaCCodeIdentifier* _tmp1014_;
										ValaCCodeFunction* _tmp1015_;
										ValaCCodeFunction* _tmp1016_;
										ValaCCodeMemberAccess* _tmp1017_;
										ValaCCodeIdentifier* _tmp1018_;
										const gchar* _tmp1019_;
										const gchar* _tmp1020_;
										ValaCCodeMemberAccess* _tmp1021_;
										ValaCCodeMemberAccess* _tmp1022_;
										ValaCCodeIdentifier* _tmp1023_;
										_tmp1005_ = type_param;
										_tmp1006_ = vala_symbol_get_name ((ValaSymbol*) _tmp1005_);
										_tmp1007_ = _tmp1006_;
										_tmp1008_ = g_ascii_strdown (_tmp1007_, (gssize) -1);
										_tmp1009_ = _tmp1008_;
										_tmp1010_ = suffix;
										_tmp1011_ = g_strdup_printf ("%s_%s", _tmp1009_, _tmp1010_);
										_tmp1012_ = _tmp1011_;
										_tmp1013_ = vala_ccode_identifier_new (_tmp1012_);
										_tmp1014_ = _tmp1013_;
										_g_free0 (_tmp1012_);
										_g_free0 (_tmp1009_);
										param_name = _tmp1014_;
										_tmp1015_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp1016_ = _tmp1015_;
										_tmp1017_ = priv_access;
										_tmp1018_ = param_name;
										_tmp1019_ = vala_ccode_identifier_get_name (_tmp1018_);
										_tmp1020_ = _tmp1019_;
										_tmp1021_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1017_, _tmp1020_);
										_tmp1022_ = _tmp1021_;
										_tmp1023_ = param_name;
										vala_ccode_function_add_assignment (_tmp1016_, (ValaCCodeExpression*) _tmp1022_, (ValaCCodeExpression*) _tmp1023_);
										_vala_ccode_node_unref0 (_tmp1022_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp1024_ = params;
	_tmp1025_ = vala_iterable_iterator ((ValaIterable*) _tmp1024_);
	params_it = _tmp1025_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1026_;
		ValaList* _tmp1027_;
		gint _arg_size = 0;
		ValaList* _tmp1028_;
		gint _tmp1029_;
		gint _tmp1030_;
		gint _arg_index = 0;
		_tmp1026_ = vala_method_call_get_argument_list (expr);
		_tmp1027_ = _vala_iterable_ref0 (_tmp1026_);
		_arg_list = _tmp1027_;
		_tmp1028_ = _arg_list;
		_tmp1029_ = vala_collection_get_size ((ValaCollection*) _tmp1028_);
		_tmp1030_ = _tmp1029_;
		_arg_size = _tmp1030_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp1031_;
			gint _tmp1032_;
			ValaExpression* arg = NULL;
			ValaList* _tmp1033_;
			gpointer _tmp1034_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp1035_;
			ValaCCodeExpression* _tmp1036_;
			ValaCCodeExpression* _tmp1037_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp1038_;
			ValaHashMap* _tmp1039_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1040_;
			gboolean _tmp1050_ = FALSE;
			ValaParameter* _tmp1051_;
			gdouble _tmp1385_ = 0.0;
			gboolean _tmp1386_ = FALSE;
			ValaParameter* _tmp1387_;
			ValaHashMap* _tmp1389_;
			ValaCCodeExpression* _tmp1390_;
			gboolean _tmp1391_ = FALSE;
			ValaMethod* _tmp1392_;
			gboolean _tmp1417_ = FALSE;
			ValaExpression* _tmp1418_;
			gint _tmp1435_;
			_arg_index = _arg_index + 1;
			_tmp1031_ = _arg_index;
			_tmp1032_ = _arg_size;
			if (!(_tmp1031_ < _tmp1032_)) {
				break;
			}
			_tmp1033_ = _arg_list;
			_tmp1034_ = vala_list_get (_tmp1033_, _arg_index);
			arg = (ValaExpression*) _tmp1034_;
			_tmp1035_ = arg;
			_tmp1036_ = vala_get_cvalue (_tmp1035_);
			_tmp1037_ = _vala_ccode_node_ref0 (_tmp1036_);
			cexpr = _tmp1037_;
			_tmp1038_ = in_arg_map;
			_tmp1039_ = _vala_map_ref0 (_tmp1038_);
			carg_map = _tmp1039_;
			param = NULL;
			_tmp1040_ = params_it;
			if (vala_iterator_next (_tmp1040_)) {
				ValaIterator* _tmp1041_;
				gpointer _tmp1042_;
				gboolean _tmp1043_ = FALSE;
				ValaParameter* _tmp1044_;
				gboolean _tmp1045_;
				gboolean _tmp1046_;
				_tmp1041_ = params_it;
				_tmp1042_ = vala_iterator_get (_tmp1041_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1042_;
				_tmp1044_ = param;
				_tmp1045_ = vala_parameter_get_params_array (_tmp1044_);
				_tmp1046_ = _tmp1045_;
				if (_tmp1046_) {
					_tmp1043_ = TRUE;
				} else {
					ValaParameter* _tmp1047_;
					gboolean _tmp1048_;
					gboolean _tmp1049_;
					_tmp1047_ = param;
					_tmp1048_ = vala_parameter_get_ellipsis (_tmp1047_);
					_tmp1049_ = _tmp1048_;
					_tmp1043_ = _tmp1049_;
				}
				ellipsis = _tmp1043_;
			}
			_tmp1051_ = param;
			if (_tmp1051_ != NULL) {
				_tmp1050_ = !ellipsis;
			} else {
				_tmp1050_ = FALSE;
			}
			if (_tmp1050_) {
				ValaParameter* _tmp1052_;
				ValaParameterDirection _tmp1053_;
				ValaParameterDirection _tmp1054_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1057_;
				ValaUnaryExpression* _tmp1058_;
				gboolean _tmp1059_ = FALSE;
				ValaUnaryExpression* _tmp1060_;
				ValaParameter* _tmp1315_;
				gchar* _tmp1316_;
				gchar* _tmp1317_;
				gboolean _tmp1318_;
				_tmp1052_ = param;
				_tmp1053_ = vala_parameter_get_direction (_tmp1052_);
				_tmp1054_ = _tmp1053_;
				if (_tmp1054_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp1055_;
					ValaHashMap* _tmp1056_;
					_tmp1055_ = out_arg_map;
					_tmp1056_ = _vala_map_ref0 (_tmp1055_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1056_;
				}
				_tmp1057_ = arg;
				_tmp1058_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1057_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1057_) : NULL);
				unary = _tmp1058_;
				_tmp1060_ = unary;
				if (_tmp1060_ == NULL) {
					_tmp1059_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp1061_;
					ValaUnaryOperator _tmp1062_;
					ValaUnaryOperator _tmp1063_;
					_tmp1061_ = unary;
					_tmp1062_ = vala_unary_expression_get_operator (_tmp1061_);
					_tmp1063_ = _tmp1062_;
					_tmp1059_ = _tmp1063_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp1059_) {
					gboolean _tmp1064_ = FALSE;
					gboolean _tmp1065_ = FALSE;
					ValaParameter* _tmp1066_;
					ValaParameter* _tmp1198_;
					ValaExpression* _tmp1199_;
					ValaCCodeExpression* _tmp1200_;
					ValaCCodeExpression* _tmp1201_;
					_tmp1066_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1066_)) {
						ValaParameter* _tmp1067_;
						ValaDataType* _tmp1068_;
						ValaDataType* _tmp1069_;
						_tmp1067_ = param;
						_tmp1068_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1067_);
						_tmp1069_ = _tmp1068_;
						_tmp1065_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1069_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1065_ = FALSE;
					}
					if (_tmp1065_) {
						ValaParameter* _tmp1070_;
						ValaDataType* _tmp1071_;
						ValaDataType* _tmp1072_;
						gboolean _tmp1073_;
						gboolean _tmp1074_;
						_tmp1070_ = param;
						_tmp1071_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1070_);
						_tmp1072_ = _tmp1071_;
						_tmp1073_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1072_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1074_ = _tmp1073_;
						_tmp1064_ = !_tmp1074_;
					} else {
						_tmp1064_ = FALSE;
					}
					if (_tmp1064_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1075_;
						ValaDataType* _tmp1076_;
						ValaDataType* _tmp1077_;
						ValaArrayType* _tmp1078_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1079_;
						gchar* _tmp1080_;
						gboolean _tmp1081_ = FALSE;
						ValaUnaryExpression* _tmp1082_;
						_tmp1075_ = param;
						_tmp1076_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1075_);
						_tmp1077_ = _tmp1076_;
						_tmp1078_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1077_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1078_;
						_tmp1079_ = param;
						_tmp1080_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1079_);
						length_ctype = _tmp1080_;
						_tmp1082_ = unary;
						if (_tmp1082_ != NULL) {
							ValaUnaryExpression* _tmp1083_;
							ValaUnaryOperator _tmp1084_;
							ValaUnaryOperator _tmp1085_;
							_tmp1083_ = unary;
							_tmp1084_ = vala_unary_expression_get_operator (_tmp1083_);
							_tmp1085_ = _tmp1084_;
							_tmp1081_ = _tmp1085_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp1081_ = FALSE;
						}
						if (_tmp1081_) {
							const gchar* _tmp1086_;
							gchar* _tmp1087_;
							_tmp1086_ = length_ctype;
							_tmp1087_ = g_strdup_printf ("%s*", _tmp1086_);
							_g_free0 (length_ctype);
							length_ctype = _tmp1087_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1088_ = FALSE;
								_tmp1088_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1090_;
									gint _tmp1091_;
									gint _tmp1092_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp1093_;
									ValaCCodeExpression* _tmp1094_;
									ValaCCodeExpression* _tmp1095_;
									const gchar* _tmp1096_;
									ValaCCodeCastExpression* _tmp1097_;
									ValaCCodeCastExpression* _tmp1098_;
									ValaHashMap* _tmp1099_;
									ValaParameter* _tmp1100_;
									ValaCCodeCastExpression* _tmp1101_;
									if (!_tmp1088_) {
										gint _tmp1089_;
										_tmp1089_ = dim;
										dim = _tmp1089_ + 1;
									}
									_tmp1088_ = FALSE;
									_tmp1090_ = array_type;
									_tmp1091_ = vala_array_type_get_rank (_tmp1090_);
									_tmp1092_ = _tmp1091_;
									if (!(dim <= _tmp1092_)) {
										break;
									}
									_tmp1093_ = arg;
									_tmp1094_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1093_, dim);
									_tmp1095_ = _tmp1094_;
									_tmp1096_ = length_ctype;
									_tmp1097_ = vala_ccode_cast_expression_new (_tmp1095_, _tmp1096_);
									_tmp1098_ = _tmp1097_;
									_vala_ccode_node_unref0 (_tmp1095_);
									array_length_expr = _tmp1098_;
									_tmp1099_ = carg_map;
									_tmp1100_ = param;
									_tmp1101_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp1099_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1100_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1101_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1102_ = FALSE;
						ValaParameter* _tmp1103_;
						_tmp1103_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1103_)) {
							ValaParameter* _tmp1104_;
							ValaDataType* _tmp1105_;
							ValaDataType* _tmp1106_;
							_tmp1104_ = param;
							_tmp1105_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1104_);
							_tmp1106_ = _tmp1105_;
							_tmp1102_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1106_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1102_ = FALSE;
						}
						if (_tmp1102_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1107_;
							ValaDataType* _tmp1108_;
							ValaDataType* _tmp1109_;
							ValaDelegateType* _tmp1110_;
							ValaDelegateType* _tmp1111_;
							ValaDelegate* _tmp1112_;
							ValaDelegate* _tmp1113_;
							gboolean _tmp1114_;
							gboolean _tmp1115_;
							_tmp1107_ = param;
							_tmp1108_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1107_);
							_tmp1109_ = _tmp1108_;
							_tmp1110_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1109_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1110_;
							_tmp1111_ = deleg_type;
							_tmp1112_ = vala_delegate_type_get_delegate_symbol (_tmp1111_);
							_tmp1113_ = _tmp1112_;
							_tmp1114_ = vala_delegate_get_has_target (_tmp1113_);
							_tmp1115_ = _tmp1114_;
							if (_tmp1115_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp1116_;
								ValaCCodeExpression* _tmp1117_ = NULL;
								ValaCCodeExpression* _tmp1118_;
								ValaCCodeExpression* _tmp1119_;
								ValaParameter* _tmp1120_;
								gchar* _tmp1121_;
								gchar* _tmp1122_;
								gboolean _tmp1123_;
								_tmp1116_ = arg;
								_tmp1118_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1116_, &_tmp1117_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1117_;
								delegate_target = _tmp1118_;
								_tmp1119_ = delegate_target;
								_vala_assert (_tmp1119_ != NULL, "delegate_target != null");
								_tmp1120_ = param;
								_tmp1121_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1120_);
								_tmp1122_ = _tmp1121_;
								_tmp1123_ = g_strcmp0 (_tmp1122_, "GClosure*") == 0;
								_g_free0 (_tmp1122_);
								if (_tmp1123_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp1124_;
									ValaCCodeIdentifier* _tmp1125_;
									ValaCCodeFunctionCall* _tmp1126_;
									ValaCCodeFunctionCall* _tmp1127_;
									ValaCCodeFunctionCall* _tmp1128_;
									ValaCCodeExpression* _tmp1129_;
									ValaCCodeCastExpression* _tmp1130_;
									ValaCCodeCastExpression* _tmp1131_;
									ValaCCodeFunctionCall* _tmp1132_;
									ValaCCodeExpression* _tmp1133_;
									ValaCCodeFunctionCall* _tmp1134_;
									ValaCCodeExpression* _tmp1135_;
									ValaCCodeCastExpression* _tmp1136_;
									ValaCCodeCastExpression* _tmp1137_;
									ValaCCodeExpression* _tmp1138_;
									ValaCCodeIdentifier* _tmp1139_;
									ValaCCodeIdentifier* _tmp1140_;
									ValaCCodeBinaryExpression* _tmp1141_;
									ValaCCodeBinaryExpression* _tmp1142_;
									ValaCCodeIdentifier* _tmp1143_;
									ValaCCodeIdentifier* _tmp1144_;
									ValaCCodeFunctionCall* _tmp1145_;
									ValaCCodeConditionalExpression* _tmp1146_;
									_tmp1124_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp1125_ = _tmp1124_;
									_tmp1126_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1125_);
									_tmp1127_ = _tmp1126_;
									_vala_ccode_node_unref0 (_tmp1125_);
									closure_new = _tmp1127_;
									_tmp1128_ = closure_new;
									_tmp1129_ = cexpr;
									_tmp1130_ = vala_ccode_cast_expression_new (_tmp1129_, "GCallback");
									_tmp1131_ = _tmp1130_;
									vala_ccode_function_call_add_argument (_tmp1128_, (ValaCCodeExpression*) _tmp1131_);
									_vala_ccode_node_unref0 (_tmp1131_);
									_tmp1132_ = closure_new;
									_tmp1133_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp1132_, _tmp1133_);
									_tmp1134_ = closure_new;
									_tmp1135_ = delegate_target_destroy_notify;
									_tmp1136_ = vala_ccode_cast_expression_new (_tmp1135_, "GClosureNotify");
									_tmp1137_ = _tmp1136_;
									vala_ccode_function_call_add_argument (_tmp1134_, (ValaCCodeExpression*) _tmp1137_);
									_vala_ccode_node_unref0 (_tmp1137_);
									_tmp1138_ = cexpr;
									_tmp1139_ = vala_ccode_identifier_new ("NULL");
									_tmp1140_ = _tmp1139_;
									_tmp1141_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1138_, (ValaCCodeExpression*) _tmp1140_);
									_tmp1142_ = _tmp1141_;
									_tmp1143_ = vala_ccode_identifier_new ("NULL");
									_tmp1144_ = _tmp1143_;
									_tmp1145_ = closure_new;
									_tmp1146_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1142_, (ValaCCodeExpression*) _tmp1144_, (ValaCCodeExpression*) _tmp1145_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1146_;
									_vala_ccode_node_unref0 (_tmp1144_);
									_vala_ccode_node_unref0 (_tmp1142_);
									_vala_ccode_node_unref0 (_tmp1140_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaHashMap* _tmp1147_;
									ValaParameter* _tmp1148_;
									ValaCCodeExpression* _tmp1149_;
									ValaDelegateType* _tmp1150_;
									_tmp1147_ = carg_map;
									_tmp1148_ = param;
									_tmp1149_ = delegate_target;
									vala_map_set ((ValaMap*) _tmp1147_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1148_), FALSE)), _tmp1149_);
									_tmp1150_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1150_)) {
										ValaCCodeExpression* _tmp1151_;
										ValaHashMap* _tmp1152_;
										ValaParameter* _tmp1153_;
										ValaCCodeExpression* _tmp1154_;
										_tmp1151_ = delegate_target_destroy_notify;
										_vala_assert (_tmp1151_ != NULL, "delegate_target_destroy_notify != null");
										_tmp1152_ = carg_map;
										_tmp1153_ = param;
										_tmp1154_ = delegate_target_destroy_notify;
										vala_map_set ((ValaMap*) _tmp1152_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1153_) + 0.01, FALSE)), _tmp1154_);
									}
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1155_;
							ValaDataType* _tmp1156_;
							ValaDataType* _tmp1157_;
							_tmp1155_ = param;
							_tmp1156_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1155_);
							_tmp1157_ = _tmp1156_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1157_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1158_;
								ValaParameter* _tmp1159_;
								ValaExpression* _tmp1160_;
								ValaCCodeExpression* _tmp1161_ = NULL;
								ValaCCodeExpression* _tmp1162_;
								ValaCCodeExpression* _tmp1163_;
								_tmp1158_ = carg_map;
								_tmp1159_ = param;
								_tmp1160_ = arg;
								_tmp1162_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1160_, &_tmp1161_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1161_;
								_tmp1163_ = _tmp1162_;
								vala_map_set ((ValaMap*) _tmp1158_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1159_), FALSE)), _tmp1163_);
								_vala_ccode_node_unref0 (_tmp1163_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1164_;
								ValaDataType* _tmp1165_;
								ValaDataType* _tmp1166_;
								_tmp1164_ = param;
								_tmp1165_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1164_);
								_tmp1166_ = _tmp1165_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1166_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1167_ = FALSE;
									ValaMethod* _tmp1168_;
									_tmp1168_ = m;
									if (_tmp1168_ != NULL) {
										ValaMethod* _tmp1169_;
										_tmp1169_ = m;
										_tmp1167_ = vala_get_ccode_simple_generics (_tmp1169_);
									} else {
										_tmp1167_ = FALSE;
									}
									if (_tmp1167_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1170_;
										ValaDataType* _tmp1171_;
										ValaDataType* _tmp1172_;
										ValaGenericType* _tmp1173_;
										gint type_param_index = 0;
										ValaMethod* _tmp1174_;
										ValaGenericType* _tmp1175_;
										ValaTypeParameter* _tmp1176_;
										ValaTypeParameter* _tmp1177_;
										const gchar* _tmp1178_;
										const gchar* _tmp1179_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1180_;
										ValaList* _tmp1181_;
										gpointer _tmp1182_;
										ValaParameter* _tmp1183_;
										ValaDataType* _tmp1184_;
										ValaDataType* _tmp1185_;
										gboolean _tmp1186_;
										gboolean _tmp1187_;
										_tmp1170_ = param;
										_tmp1171_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1170_);
										_tmp1172_ = _tmp1171_;
										_tmp1173_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1172_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1173_;
										_tmp1174_ = m;
										_tmp1175_ = generic_type;
										_tmp1176_ = vala_generic_type_get_type_parameter (_tmp1175_);
										_tmp1177_ = _tmp1176_;
										_tmp1178_ = vala_symbol_get_name ((ValaSymbol*) _tmp1177_);
										_tmp1179_ = _tmp1178_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1174_, _tmp1179_);
										_tmp1180_ = ma;
										_tmp1181_ = vala_member_access_get_type_arguments (_tmp1180_);
										_tmp1182_ = vala_list_get (_tmp1181_, type_param_index);
										type_arg = (ValaDataType*) _tmp1182_;
										_tmp1183_ = param;
										_tmp1184_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1183_);
										_tmp1185_ = _tmp1184_;
										_tmp1186_ = vala_data_type_get_value_owned (_tmp1185_);
										_tmp1187_ = _tmp1186_;
										if (_tmp1187_) {
											ValaDataType* _tmp1188_;
											_tmp1188_ = type_arg;
											if (vala_ccode_base_module_requires_copy (_tmp1188_)) {
												ValaHashMap* _tmp1189_;
												ValaParameter* _tmp1190_;
												ValaDataType* _tmp1191_;
												ValaCCodeExpression* _tmp1192_;
												ValaCCodeExpression* _tmp1193_;
												_tmp1189_ = carg_map;
												_tmp1190_ = param;
												_tmp1191_ = type_arg;
												_tmp1192_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1191_, FALSE);
												_tmp1193_ = _tmp1192_;
												vala_map_set ((ValaMap*) _tmp1189_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1190_), FALSE)), _tmp1193_);
												_vala_ccode_node_unref0 (_tmp1193_);
											} else {
												ValaHashMap* _tmp1194_;
												ValaParameter* _tmp1195_;
												ValaCCodeConstant* _tmp1196_;
												ValaCCodeConstant* _tmp1197_;
												_tmp1194_ = carg_map;
												_tmp1195_ = param;
												_tmp1196_ = vala_ccode_constant_new ("NULL");
												_tmp1197_ = _tmp1196_;
												vala_map_set ((ValaMap*) _tmp1194_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1195_), FALSE)), (ValaCCodeExpression*) _tmp1197_);
												_vala_ccode_node_unref0 (_tmp1197_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1198_ = param;
					_tmp1199_ = arg;
					_tmp1200_ = cexpr;
					_tmp1201_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1198_, _tmp1199_, _tmp1200_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1201_;
				} else {
					ValaExpression* _tmp1202_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1203_;
					ValaDataType* _tmp1204_;
					ValaDataType* _tmp1205_;
					ValaParameter* _tmp1206_;
					ValaDataType* _tmp1207_;
					ValaDataType* _tmp1208_;
					gboolean _tmp1209_;
					gboolean _tmp1210_;
					ValaLocalVariable* _tmp1211_;
					ValaLocalVariable* _tmp1212_;
					ValaExpression* _tmp1213_;
					ValaLocalVariable* _tmp1214_;
					const gchar* _tmp1215_;
					const gchar* _tmp1216_;
					ValaCCodeExpression* _tmp1217_;
					ValaCCodeExpression* _tmp1218_;
					ValaExpression* _tmp1219_;
					ValaTargetValue* _tmp1220_;
					ValaTargetValue* _tmp1221_;
					ValaExpression* _tmp1222_;
					ValaDataType* _tmp1223_;
					ValaDataType* _tmp1224_;
					ValaExpression* _tmp1225_;
					ValaCCodeExpression* _tmp1226_;
					ValaCCodeUnaryExpression* _tmp1227_;
					gboolean _tmp1228_ = FALSE;
					gboolean _tmp1229_ = FALSE;
					ValaParameter* _tmp1230_;
					_tmp1202_ = arg;
					vala_expression_set_target_value (_tmp1202_, NULL);
					_tmp1203_ = param;
					_tmp1204_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1203_);
					_tmp1205_ = _tmp1204_;
					_tmp1206_ = param;
					_tmp1207_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1206_);
					_tmp1208_ = _tmp1207_;
					_tmp1209_ = vala_data_type_get_value_owned (_tmp1208_);
					_tmp1210_ = _tmp1209_;
					_tmp1211_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1205_, _tmp1210_, NULL, TRUE);
					temp_var = _tmp1211_;
					_tmp1212_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1212_, FALSE);
					_tmp1213_ = arg;
					_tmp1214_ = temp_var;
					_tmp1215_ = vala_symbol_get_name ((ValaSymbol*) _tmp1214_);
					_tmp1216_ = _tmp1215_;
					_tmp1217_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1216_);
					_tmp1218_ = _tmp1217_;
					vala_set_cvalue (_tmp1213_, _tmp1218_);
					_vala_ccode_node_unref0 (_tmp1218_);
					_tmp1219_ = arg;
					_tmp1220_ = vala_expression_get_target_value (_tmp1219_);
					_tmp1221_ = _tmp1220_;
					_tmp1222_ = arg;
					_tmp1223_ = vala_expression_get_target_type (_tmp1222_);
					_tmp1224_ = _tmp1223_;
					vala_target_value_set_value_type (_tmp1221_, _tmp1224_);
					_tmp1225_ = arg;
					_tmp1226_ = vala_get_cvalue (_tmp1225_);
					_tmp1227_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1226_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1227_;
					_tmp1230_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1230_)) {
						ValaParameter* _tmp1231_;
						ValaDataType* _tmp1232_;
						ValaDataType* _tmp1233_;
						_tmp1231_ = param;
						_tmp1232_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1231_);
						_tmp1233_ = _tmp1232_;
						_tmp1229_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1233_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1229_ = FALSE;
					}
					if (_tmp1229_) {
						ValaParameter* _tmp1234_;
						ValaDataType* _tmp1235_;
						ValaDataType* _tmp1236_;
						gboolean _tmp1237_;
						gboolean _tmp1238_;
						_tmp1234_ = param;
						_tmp1235_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1234_);
						_tmp1236_ = _tmp1235_;
						_tmp1237_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1236_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1238_ = _tmp1237_;
						_tmp1228_ = !_tmp1238_;
					} else {
						_tmp1228_ = FALSE;
					}
					if (_tmp1228_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1239_;
						ValaDataType* _tmp1240_;
						ValaDataType* _tmp1241_;
						ValaArrayType* _tmp1242_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1243_;
						gchar* _tmp1244_;
						_tmp1239_ = param;
						_tmp1240_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1239_);
						_tmp1241_ = _tmp1240_;
						_tmp1242_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1241_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1242_;
						_tmp1243_ = param;
						_tmp1244_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1243_);
						length_ctype = _tmp1244_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1245_ = FALSE;
								_tmp1245_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1247_;
									gint _tmp1248_;
									gint _tmp1249_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1250_;
									ValaCType* _tmp1251_;
									ValaCType* _tmp1252_;
									ValaLocalVariable* _tmp1253_;
									ValaLocalVariable* _tmp1254_;
									ValaLocalVariable* _tmp1255_;
									ValaExpression* _tmp1256_;
									ValaLocalVariable* _tmp1257_;
									const gchar* _tmp1258_;
									const gchar* _tmp1259_;
									ValaCCodeExpression* _tmp1260_;
									ValaCCodeExpression* _tmp1261_;
									ValaHashMap* _tmp1262_;
									ValaParameter* _tmp1263_;
									ValaExpression* _tmp1264_;
									ValaList* _tmp1265_;
									gpointer _tmp1266_;
									ValaCCodeExpression* _tmp1267_;
									ValaCCodeUnaryExpression* _tmp1268_;
									ValaCCodeUnaryExpression* _tmp1269_;
									if (!_tmp1245_) {
										gint _tmp1246_;
										_tmp1246_ = dim;
										dim = _tmp1246_ + 1;
									}
									_tmp1245_ = FALSE;
									_tmp1247_ = array_type;
									_tmp1248_ = vala_array_type_get_rank (_tmp1247_);
									_tmp1249_ = _tmp1248_;
									if (!(dim <= _tmp1249_)) {
										break;
									}
									_tmp1250_ = length_ctype;
									_tmp1251_ = vala_ctype_new (_tmp1250_, "0");
									_tmp1252_ = _tmp1251_;
									_tmp1253_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1252_, TRUE, NULL, TRUE);
									_tmp1254_ = _tmp1253_;
									_vala_code_node_unref0 (_tmp1252_);
									temp_array_length = _tmp1254_;
									_tmp1255_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1255_, FALSE);
									_tmp1256_ = arg;
									_tmp1257_ = temp_array_length;
									_tmp1258_ = vala_symbol_get_name ((ValaSymbol*) _tmp1257_);
									_tmp1259_ = _tmp1258_;
									_tmp1260_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1259_);
									_tmp1261_ = _tmp1260_;
									vala_append_array_length (_tmp1256_, _tmp1261_);
									_vala_ccode_node_unref0 (_tmp1261_);
									_tmp1262_ = carg_map;
									_tmp1263_ = param;
									_tmp1264_ = arg;
									_tmp1265_ = vala_get_array_lengths (_tmp1264_);
									_tmp1266_ = vala_list_get (_tmp1265_, dim - 1);
									_tmp1267_ = (ValaCCodeExpression*) _tmp1266_;
									_tmp1268_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1267_);
									_tmp1269_ = _tmp1268_;
									vala_map_set ((ValaMap*) _tmp1262_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1263_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1269_);
									_vala_ccode_node_unref0 (_tmp1269_);
									_vala_ccode_node_unref0 (_tmp1267_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1270_ = FALSE;
						ValaParameter* _tmp1271_;
						_tmp1271_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1271_)) {
							ValaParameter* _tmp1272_;
							ValaDataType* _tmp1273_;
							ValaDataType* _tmp1274_;
							_tmp1272_ = param;
							_tmp1273_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1272_);
							_tmp1274_ = _tmp1273_;
							_tmp1270_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1274_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1270_ = FALSE;
						}
						if (_tmp1270_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1275_;
							ValaDataType* _tmp1276_;
							ValaDataType* _tmp1277_;
							ValaDelegateType* _tmp1278_;
							ValaDelegateType* _tmp1279_;
							ValaDelegate* _tmp1280_;
							ValaDelegate* _tmp1281_;
							gboolean _tmp1282_;
							gboolean _tmp1283_;
							_tmp1275_ = param;
							_tmp1276_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1275_);
							_tmp1277_ = _tmp1276_;
							_tmp1278_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1277_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1278_;
							_tmp1279_ = deleg_type;
							_tmp1280_ = vala_delegate_type_get_delegate_symbol (_tmp1279_);
							_tmp1281_ = _tmp1280_;
							_tmp1282_ = vala_delegate_get_has_target (_tmp1281_);
							_tmp1283_ = _tmp1282_;
							if (_tmp1283_) {
								ValaDataType* _tmp1284_;
								ValaLocalVariable* _tmp1285_;
								ValaLocalVariable* _tmp1286_;
								ValaExpression* _tmp1287_;
								ValaLocalVariable* _tmp1288_;
								const gchar* _tmp1289_;
								const gchar* _tmp1290_;
								ValaCCodeExpression* _tmp1291_;
								ValaCCodeExpression* _tmp1292_;
								ValaHashMap* _tmp1293_;
								ValaParameter* _tmp1294_;
								ValaExpression* _tmp1295_;
								ValaCCodeExpression* _tmp1296_;
								ValaCCodeUnaryExpression* _tmp1297_;
								ValaCCodeUnaryExpression* _tmp1298_;
								ValaDelegateType* _tmp1299_;
								_tmp1284_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
								_tmp1285_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1284_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1285_;
								_tmp1286_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1286_, FALSE);
								_tmp1287_ = arg;
								_tmp1288_ = temp_var;
								_tmp1289_ = vala_symbol_get_name ((ValaSymbol*) _tmp1288_);
								_tmp1290_ = _tmp1289_;
								_tmp1291_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1290_);
								_tmp1292_ = _tmp1291_;
								vala_set_delegate_target (_tmp1287_, _tmp1292_);
								_vala_ccode_node_unref0 (_tmp1292_);
								_tmp1293_ = carg_map;
								_tmp1294_ = param;
								_tmp1295_ = arg;
								_tmp1296_ = vala_get_delegate_target (_tmp1295_);
								_tmp1297_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1296_);
								_tmp1298_ = _tmp1297_;
								vala_map_set ((ValaMap*) _tmp1293_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1294_), FALSE)), (ValaCCodeExpression*) _tmp1298_);
								_vala_ccode_node_unref0 (_tmp1298_);
								_tmp1299_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1299_)) {
									ValaDelegateType* _tmp1300_;
									ValaLocalVariable* _tmp1301_;
									ValaLocalVariable* _tmp1302_;
									ValaExpression* _tmp1303_;
									ValaLocalVariable* _tmp1304_;
									const gchar* _tmp1305_;
									const gchar* _tmp1306_;
									ValaCCodeExpression* _tmp1307_;
									ValaCCodeExpression* _tmp1308_;
									ValaHashMap* _tmp1309_;
									ValaParameter* _tmp1310_;
									ValaExpression* _tmp1311_;
									ValaCCodeExpression* _tmp1312_;
									ValaCCodeUnaryExpression* _tmp1313_;
									ValaCCodeUnaryExpression* _tmp1314_;
									_tmp1300_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
									_tmp1301_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1300_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1301_;
									_tmp1302_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1302_, FALSE);
									_tmp1303_ = arg;
									_tmp1304_ = temp_var;
									_tmp1305_ = vala_symbol_get_name ((ValaSymbol*) _tmp1304_);
									_tmp1306_ = _tmp1305_;
									_tmp1307_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1306_);
									_tmp1308_ = _tmp1307_;
									vala_set_delegate_target_destroy_notify (_tmp1303_, _tmp1308_);
									_vala_ccode_node_unref0 (_tmp1308_);
									_tmp1309_ = carg_map;
									_tmp1310_ = param;
									_tmp1311_ = arg;
									_tmp1312_ = vala_get_delegate_target_destroy_notify (_tmp1311_);
									_tmp1313_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1312_);
									_tmp1314_ = _tmp1313_;
									vala_map_set ((ValaMap*) _tmp1309_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1310_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1314_);
									_vala_ccode_node_unref0 (_tmp1314_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1315_ = param;
				_tmp1316_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1315_);
				_tmp1317_ = _tmp1316_;
				_tmp1318_ = _tmp1317_ != NULL;
				_g_free0 (_tmp1317_);
				if (_tmp1318_) {
					ValaCCodeExpression* _tmp1319_;
					ValaParameter* _tmp1320_;
					gchar* _tmp1321_;
					gchar* _tmp1322_;
					ValaCCodeCastExpression* _tmp1323_;
					_tmp1319_ = cexpr;
					_tmp1320_ = param;
					_tmp1321_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1320_);
					_tmp1322_ = _tmp1321_;
					_tmp1323_ = vala_ccode_cast_expression_new (_tmp1319_, _tmp1322_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1323_;
					_g_free0 (_tmp1322_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1324_;
				ValaUnaryExpression* _tmp1325_;
				gboolean _tmp1326_ = FALSE;
				gboolean _tmp1327_ = FALSE;
				_tmp1324_ = arg;
				_tmp1325_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1324_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1324_) : NULL);
				unary = _tmp1325_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1328_;
					_tmp1328_ = unary;
					_tmp1327_ = _tmp1328_ != NULL;
				} else {
					_tmp1327_ = FALSE;
				}
				if (_tmp1327_) {
					ValaUnaryExpression* _tmp1329_;
					ValaUnaryOperator _tmp1330_;
					ValaUnaryOperator _tmp1331_;
					_tmp1329_ = unary;
					_tmp1330_ = vala_unary_expression_get_operator (_tmp1329_);
					_tmp1331_ = _tmp1330_;
					_tmp1326_ = _tmp1331_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1326_ = FALSE;
				}
				if (_tmp1326_) {
					ValaHashMap* _tmp1332_;
					ValaHashMap* _tmp1333_;
					ValaExpression* _tmp1334_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1335_;
					ValaDataType* _tmp1336_;
					ValaDataType* _tmp1337_;
					ValaExpression* _tmp1338_;
					ValaDataType* _tmp1339_;
					ValaDataType* _tmp1340_;
					gboolean _tmp1341_;
					gboolean _tmp1342_;
					ValaLocalVariable* _tmp1343_;
					ValaLocalVariable* _tmp1344_;
					ValaExpression* _tmp1345_;
					ValaLocalVariable* _tmp1346_;
					const gchar* _tmp1347_;
					const gchar* _tmp1348_;
					ValaCCodeExpression* _tmp1349_;
					ValaCCodeExpression* _tmp1350_;
					ValaExpression* _tmp1351_;
					ValaTargetValue* _tmp1352_;
					ValaTargetValue* _tmp1353_;
					ValaExpression* _tmp1354_;
					ValaDataType* _tmp1355_;
					ValaDataType* _tmp1356_;
					gboolean _tmp1357_ = FALSE;
					ValaExpression* _tmp1358_;
					ValaDataType* _tmp1359_;
					ValaDataType* _tmp1360_;
					ValaExpression* _tmp1379_;
					ValaCCodeExpression* _tmp1380_;
					ValaCCodeUnaryExpression* _tmp1381_;
					_tmp1332_ = out_arg_map;
					_tmp1333_ = _vala_map_ref0 (_tmp1332_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1333_;
					_tmp1334_ = arg;
					vala_expression_set_target_value (_tmp1334_, NULL);
					_tmp1335_ = arg;
					_tmp1336_ = vala_expression_get_value_type (_tmp1335_);
					_tmp1337_ = _tmp1336_;
					_tmp1338_ = arg;
					_tmp1339_ = vala_expression_get_value_type (_tmp1338_);
					_tmp1340_ = _tmp1339_;
					_tmp1341_ = vala_data_type_get_value_owned (_tmp1340_);
					_tmp1342_ = _tmp1341_;
					_tmp1343_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1337_, _tmp1342_, NULL, TRUE);
					temp_var = _tmp1343_;
					_tmp1344_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1344_, FALSE);
					_tmp1345_ = arg;
					_tmp1346_ = temp_var;
					_tmp1347_ = vala_symbol_get_name ((ValaSymbol*) _tmp1346_);
					_tmp1348_ = _tmp1347_;
					_tmp1349_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1348_);
					_tmp1350_ = _tmp1349_;
					vala_set_cvalue (_tmp1345_, _tmp1350_);
					_vala_ccode_node_unref0 (_tmp1350_);
					_tmp1351_ = arg;
					_tmp1352_ = vala_expression_get_target_value (_tmp1351_);
					_tmp1353_ = _tmp1352_;
					_tmp1354_ = arg;
					_tmp1355_ = vala_expression_get_value_type (_tmp1354_);
					_tmp1356_ = _tmp1355_;
					vala_target_value_set_value_type (_tmp1353_, _tmp1356_);
					_tmp1358_ = arg;
					_tmp1359_ = vala_expression_get_value_type (_tmp1358_);
					_tmp1360_ = _tmp1359_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1360_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaExpression* _tmp1361_;
						ValaDataType* _tmp1362_;
						ValaDataType* _tmp1363_;
						ValaDelegate* _tmp1364_;
						ValaDelegate* _tmp1365_;
						gboolean _tmp1366_;
						gboolean _tmp1367_;
						_tmp1361_ = arg;
						_tmp1362_ = vala_expression_get_value_type (_tmp1361_);
						_tmp1363_ = _tmp1362_;
						_tmp1364_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1363_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp1365_ = _tmp1364_;
						_tmp1366_ = vala_delegate_get_has_target (_tmp1365_);
						_tmp1367_ = _tmp1366_;
						_tmp1357_ = _tmp1367_;
					} else {
						_tmp1357_ = FALSE;
					}
					if (_tmp1357_) {
						ValaGLibValue* arg_value = NULL;
						ValaExpression* _tmp1368_;
						ValaTargetValue* _tmp1369_;
						ValaTargetValue* _tmp1370_;
						ValaGLibValue* _tmp1371_;
						ValaCCodeExpression* _tmp1372_;
						ValaGLibValue* _tmp1375_;
						ValaCCodeExpression* _tmp1376_;
						_tmp1368_ = arg;
						_tmp1369_ = vala_expression_get_target_value (_tmp1368_);
						_tmp1370_ = _tmp1369_;
						arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp1370_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
						_tmp1371_ = arg_value;
						_tmp1372_ = _tmp1371_->delegate_target_cvalue;
						if (_tmp1372_ == NULL) {
							ValaGLibValue* _tmp1373_;
							ValaCCodeConstant* _tmp1374_;
							_tmp1373_ = arg_value;
							_tmp1374_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1373_->delegate_target_cvalue);
							_tmp1373_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp1374_;
						}
						_tmp1375_ = arg_value;
						_tmp1376_ = _tmp1375_->delegate_target_destroy_notify_cvalue;
						if (_tmp1376_ == NULL) {
							ValaGLibValue* _tmp1377_;
							ValaCCodeConstant* _tmp1378_;
							_tmp1377_ = arg_value;
							_tmp1378_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1377_->delegate_target_destroy_notify_cvalue);
							_tmp1377_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp1378_;
						}
					}
					_tmp1379_ = arg;
					_tmp1380_ = vala_get_cvalue (_tmp1379_);
					_tmp1381_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1380_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1381_;
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1382_;
					ValaCCodeExpression* _tmp1383_;
					ValaCCodeExpression* _tmp1384_;
					_tmp1382_ = arg;
					_tmp1383_ = cexpr;
					_tmp1384_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1382_, _tmp1383_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1384_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1387_ = param;
			if (_tmp1387_ != NULL) {
				_tmp1386_ = !ellipsis;
			} else {
				_tmp1386_ = FALSE;
			}
			if (_tmp1386_) {
				ValaParameter* _tmp1388_;
				_tmp1388_ = param;
				_tmp1385_ = vala_get_ccode_pos (_tmp1388_);
			} else {
				_tmp1385_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1385_, ellipsis);
			_tmp1389_ = carg_map;
			_tmp1390_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1389_, (gpointer) ((gintptr) arg_pos), _tmp1390_);
			_tmp1392_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1392_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
				ValaCodeContext* _tmp1393_;
				ValaCodeContext* _tmp1394_;
				ValaProfile _tmp1395_;
				ValaProfile _tmp1396_;
				_tmp1393_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp1394_ = _tmp1393_;
				_tmp1395_ = vala_code_context_get_profile (_tmp1394_);
				_tmp1396_ = _tmp1395_;
				_tmp1391_ = _tmp1396_ == VALA_PROFILE_POSIX;
			} else {
				_tmp1391_ = FALSE;
			}
			if (_tmp1391_) {
				ValaCCodeIdentifier* csizeof = NULL;
				ValaMemberAccess* _tmp1397_;
				ValaExpression* _tmp1398_;
				ValaExpression* _tmp1399_;
				ValaDataType* _tmp1400_;
				ValaDataType* _tmp1401_;
				ValaDataType* _tmp1402_;
				ValaDataType* _tmp1403_;
				gchar* _tmp1404_;
				gchar* _tmp1405_;
				gchar* _tmp1406_;
				gchar* _tmp1407_;
				ValaCCodeIdentifier* _tmp1408_;
				ValaCCodeIdentifier* _tmp1409_;
				ValaHashMap* _tmp1410_;
				ValaCCodeIdentifier* _tmp1411_;
				ValaCCodeExpression* _tmp1412_;
				ValaCCodeBinaryExpression* _tmp1413_;
				ValaCCodeBinaryExpression* _tmp1414_;
				_tmp1397_ = ma;
				_tmp1398_ = vala_member_access_get_inner (_tmp1397_);
				_tmp1399_ = _tmp1398_;
				_tmp1400_ = vala_expression_get_value_type (_tmp1399_);
				_tmp1401_ = _tmp1400_;
				_tmp1402_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1401_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp1403_ = _tmp1402_;
				_tmp1404_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1403_);
				_tmp1405_ = _tmp1404_;
				_tmp1406_ = g_strdup_printf ("sizeof (%s)", _tmp1405_);
				_tmp1407_ = _tmp1406_;
				_tmp1408_ = vala_ccode_identifier_new (_tmp1407_);
				_tmp1409_ = _tmp1408_;
				_g_free0 (_tmp1407_);
				_g_free0 (_tmp1405_);
				csizeof = _tmp1409_;
				_tmp1410_ = carg_map;
				_tmp1411_ = csizeof;
				_tmp1412_ = cexpr;
				_tmp1413_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1411_, _tmp1412_);
				_tmp1414_ = _tmp1413_;
				vala_map_set ((ValaMap*) _tmp1410_, (gpointer) ((gintptr) arg_pos), (ValaCCodeExpression*) _tmp1414_);
				_vala_ccode_node_unref0 (_tmp1414_);
				_vala_ccode_node_unref0 (csizeof);
			} else {
				ValaHashMap* _tmp1415_;
				ValaCCodeExpression* _tmp1416_;
				_tmp1415_ = carg_map;
				_tmp1416_ = cexpr;
				vala_map_set ((ValaMap*) _tmp1415_, (gpointer) ((gintptr) arg_pos), _tmp1416_);
			}
			_tmp1418_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1418_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1417_ = ellipsis;
			} else {
				_tmp1417_ = FALSE;
			}
			if (_tmp1417_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1419_;
				ValaNamedArgument* _tmp1420_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1421_;
				const gchar* _tmp1422_;
				const gchar* _tmp1423_;
				gchar** _tmp1424_;
				gchar** _tmp1425_;
				gchar** _tmp1426_;
				gint _tmp1426__length1;
				gchar* _tmp1427_;
				gchar* _tmp1428_;
				ValaHashMap* _tmp1429_;
				const gchar* _tmp1430_;
				gchar* _tmp1431_;
				gchar* _tmp1432_;
				ValaCCodeConstant* _tmp1433_;
				ValaCCodeConstant* _tmp1434_;
				_tmp1419_ = arg;
				_tmp1420_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1419_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1420_;
				_tmp1421_ = named_arg;
				_tmp1422_ = vala_named_argument_get_name (_tmp1421_);
				_tmp1423_ = _tmp1422_;
				_tmp1425_ = _tmp1424_ = g_strsplit (_tmp1423_, "_", 0);
				_tmp1426_ = _tmp1425_;
				_tmp1426__length1 = _vala_array_length (_tmp1424_);
				_tmp1427_ = _vala_g_strjoinv ("-", _tmp1426_, (gint) _vala_array_length (_tmp1424_));
				_tmp1428_ = _tmp1427_;
				_tmp1426_ = (_vala_array_free (_tmp1426_, _tmp1426__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1428_;
				_tmp1429_ = carg_map;
				_tmp1430_ = name;
				_tmp1431_ = g_strdup_printf ("\"%s\"", _tmp1430_);
				_tmp1432_ = _tmp1431_;
				_tmp1433_ = vala_ccode_constant_new (_tmp1432_);
				_tmp1434_ = _tmp1433_;
				vala_map_set ((ValaMap*) _tmp1429_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1434_);
				_vala_ccode_node_unref0 (_tmp1434_);
				_g_free0 (_tmp1432_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1435_ = i;
			i = _tmp1435_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1436_ = params_it;
	if (vala_iterator_next (_tmp1436_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1437_;
		gpointer _tmp1438_;
		gboolean _tmp1439_ = FALSE;
		ValaParameter* _tmp1440_;
		gboolean _tmp1441_;
		gboolean _tmp1442_;
		_tmp1437_ = params_it;
		_tmp1438_ = vala_iterator_get (_tmp1437_);
		param = (ValaParameter*) _tmp1438_;
		_tmp1440_ = param;
		_tmp1441_ = vala_parameter_get_params_array (_tmp1440_);
		_tmp1442_ = _tmp1441_;
		if (_tmp1442_) {
			_tmp1439_ = TRUE;
		} else {
			ValaParameter* _tmp1443_;
			gboolean _tmp1444_;
			gboolean _tmp1445_;
			_tmp1443_ = param;
			_tmp1444_ = vala_parameter_get_ellipsis (_tmp1443_);
			_tmp1445_ = _tmp1444_;
			_tmp1439_ = _tmp1445_;
		}
		_vala_assert (_tmp1439_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1448_ = m;
	if (_tmp1448_ != NULL) {
		ValaMethod* _tmp1449_;
		ValaDataType* _tmp1450_;
		ValaDataType* _tmp1451_;
		_tmp1449_ = m;
		_tmp1450_ = vala_callable_get_return_type ((ValaCallable*) _tmp1449_);
		_tmp1451_ = _tmp1450_;
		_tmp1447_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1451_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1447_ = FALSE;
	}
	if (_tmp1447_) {
		ValaCCodeFunctionCall* _tmp1452_;
		ValaCCodeFunctionCall* _tmp1453_;
		_tmp1452_ = async_call;
		_tmp1453_ = ccall;
		_tmp1446_ = _tmp1452_ != _tmp1453_;
	} else {
		_tmp1446_ = FALSE;
	}
	if (_tmp1446_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1454_;
		ValaDataType* _tmp1455_;
		ValaDataType* _tmp1456_;
		ValaArrayType* _tmp1457_;
		_tmp1454_ = m;
		_tmp1455_ = vala_callable_get_return_type ((ValaCallable*) _tmp1454_);
		_tmp1456_ = _tmp1455_;
		_tmp1457_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1456_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1457_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1458_ = FALSE;
				_tmp1458_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1460_;
					gint _tmp1461_;
					gint _tmp1462_;
					ValaMethod* _tmp1463_;
					if (!_tmp1458_) {
						gint _tmp1459_;
						_tmp1459_ = dim;
						dim = _tmp1459_ + 1;
					}
					_tmp1458_ = FALSE;
					_tmp1460_ = array_type;
					_tmp1461_ = vala_array_type_get_rank (_tmp1460_);
					_tmp1462_ = _tmp1461_;
					if (!(dim <= _tmp1462_)) {
						break;
					}
					_tmp1463_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1463_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1464_;
						ValaDataType* _tmp1465_;
						ValaLocalVariable* _tmp1466_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1467_;
						const gchar* _tmp1468_;
						const gchar* _tmp1469_;
						ValaCCodeExpression* _tmp1470_;
						ValaLocalVariable* _tmp1471_;
						ValaCCodeExpression* _tmp1472_;
						ValaCCodeExpression* _tmp1473_;
						ValaCCodeAssignment* _tmp1474_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1475_;
						ValaCCodeIdentifier* _tmp1476_;
						ValaCCodeFunctionCall* _tmp1477_;
						ValaCCodeFunctionCall* _tmp1478_;
						ValaCCodeFunctionCall* _tmp1479_;
						ValaCCodeExpression* _tmp1480_;
						ValaCCodeFunctionCall* _tmp1481_;
						_tmp1464_ = itype;
						_tmp1465_ = vala_data_type_get_return_type (_tmp1464_);
						_tmp1466_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1465_, TRUE, NULL, FALSE);
						temp_var = _tmp1466_;
						_tmp1467_ = temp_var;
						_tmp1468_ = vala_symbol_get_name ((ValaSymbol*) _tmp1467_);
						_tmp1469_ = _tmp1468_;
						_tmp1470_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1469_);
						temp_ref = _tmp1470_;
						_tmp1471_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1471_, FALSE);
						_tmp1472_ = temp_ref;
						_tmp1473_ = ccall_expr;
						_tmp1474_ = vala_ccode_assignment_new (_tmp1472_, _tmp1473_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1474_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1475_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1476_ = _tmp1475_;
						_tmp1477_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1476_);
						_tmp1478_ = _tmp1477_;
						_vala_ccode_node_unref0 (_tmp1476_);
						len_call = _tmp1478_;
						_tmp1479_ = len_call;
						_tmp1480_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1479_, _tmp1480_);
						_tmp1481_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1481_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1482_;
						_tmp1482_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1482_)) {
							gchar* length_ctype = NULL;
							ValaMethod* _tmp1483_;
							gchar* _tmp1484_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1485_;
							ValaCType* _tmp1486_;
							ValaCType* _tmp1487_;
							ValaLocalVariable* _tmp1488_;
							ValaLocalVariable* _tmp1489_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1490_;
							const gchar* _tmp1491_;
							const gchar* _tmp1492_;
							ValaCCodeExpression* _tmp1493_;
							ValaLocalVariable* _tmp1494_;
							ValaHashMap* _tmp1495_;
							ValaMethod* _tmp1496_;
							ValaCCodeExpression* _tmp1497_;
							ValaCCodeUnaryExpression* _tmp1498_;
							ValaCCodeUnaryExpression* _tmp1499_;
							ValaCCodeExpression* _tmp1500_;
							_tmp1483_ = m;
							_tmp1484_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1483_);
							length_ctype = _tmp1484_;
							_tmp1485_ = length_ctype;
							_tmp1486_ = vala_ctype_new (_tmp1485_, "0");
							_tmp1487_ = _tmp1486_;
							_tmp1488_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1487_, TRUE, NULL, TRUE);
							_tmp1489_ = _tmp1488_;
							_vala_code_node_unref0 (_tmp1487_);
							temp_var = _tmp1489_;
							_tmp1490_ = temp_var;
							_tmp1491_ = vala_symbol_get_name ((ValaSymbol*) _tmp1490_);
							_tmp1492_ = _tmp1491_;
							_tmp1493_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1492_);
							temp_ref = _tmp1493_;
							_tmp1494_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1494_, FALSE);
							_tmp1495_ = out_arg_map;
							_tmp1496_ = m;
							_tmp1497_ = temp_ref;
							_tmp1498_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1497_);
							_tmp1499_ = _tmp1498_;
							vala_map_set ((ValaMap*) _tmp1495_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1496_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1499_);
							_vala_ccode_node_unref0 (_tmp1499_);
							_tmp1500_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1500_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaMethod* _tmp1501_;
							gchar* _tmp1502_;
							gchar* _tmp1503_;
							gboolean _tmp1504_;
							_tmp1501_ = m;
							_tmp1502_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1501_);
							_tmp1503_ = _tmp1502_;
							_tmp1504_ = _tmp1503_ != NULL;
							_g_free0 (_tmp1503_);
							if (_tmp1504_) {
								ValaMethod* _tmp1505_;
								gchar* _tmp1506_;
								gchar* _tmp1507_;
								ValaCCodeConstant* _tmp1508_;
								ValaCCodeConstant* _tmp1509_;
								_tmp1505_ = m;
								_tmp1506_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1505_);
								_tmp1507_ = _tmp1506_;
								_tmp1508_ = vala_ccode_constant_new (_tmp1507_);
								_tmp1509_ = _tmp1508_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1509_);
								_vala_ccode_node_unref0 (_tmp1509_);
								_g_free0 (_tmp1507_);
							} else {
								ValaCCodeConstant* _tmp1510_;
								ValaCCodeConstant* _tmp1511_;
								_tmp1510_ = vala_ccode_constant_new ("-1");
								_tmp1511_ = _tmp1510_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1511_);
								_vala_ccode_node_unref0 (_tmp1511_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1512_ = FALSE;
		gboolean _tmp1513_ = FALSE;
		ValaMethod* _tmp1514_;
		_tmp1514_ = m;
		if (_tmp1514_ != NULL) {
			ValaMethod* _tmp1515_;
			ValaDataType* _tmp1516_;
			ValaDataType* _tmp1517_;
			_tmp1515_ = m;
			_tmp1516_ = vala_callable_get_return_type ((ValaCallable*) _tmp1515_);
			_tmp1517_ = _tmp1516_;
			_tmp1513_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1517_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1513_ = FALSE;
		}
		if (_tmp1513_) {
			ValaCCodeFunctionCall* _tmp1518_;
			ValaCCodeFunctionCall* _tmp1519_;
			_tmp1518_ = async_call;
			_tmp1519_ = ccall;
			_tmp1512_ = _tmp1518_ != _tmp1519_;
		} else {
			_tmp1512_ = FALSE;
		}
		if (_tmp1512_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1520_;
			ValaDataType* _tmp1521_;
			ValaDataType* _tmp1522_;
			ValaDelegateType* _tmp1523_;
			gboolean _tmp1524_ = FALSE;
			ValaMethod* _tmp1525_;
			_tmp1520_ = m;
			_tmp1521_ = vala_callable_get_return_type ((ValaCallable*) _tmp1520_);
			_tmp1522_ = _tmp1521_;
			_tmp1523_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1522_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1523_;
			_tmp1525_ = m;
			if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1525_)) {
				ValaDelegateType* _tmp1526_;
				ValaDelegate* _tmp1527_;
				ValaDelegate* _tmp1528_;
				gboolean _tmp1529_;
				gboolean _tmp1530_;
				_tmp1526_ = deleg_type;
				_tmp1527_ = vala_delegate_type_get_delegate_symbol (_tmp1526_);
				_tmp1528_ = _tmp1527_;
				_tmp1529_ = vala_delegate_get_has_target (_tmp1528_);
				_tmp1530_ = _tmp1529_;
				_tmp1524_ = _tmp1530_;
			} else {
				_tmp1524_ = FALSE;
			}
			if (_tmp1524_) {
				ValaLocalVariable* temp_var = NULL;
				ValaDataType* _tmp1531_;
				ValaLocalVariable* _tmp1532_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1533_;
				const gchar* _tmp1534_;
				const gchar* _tmp1535_;
				ValaCCodeExpression* _tmp1536_;
				ValaLocalVariable* _tmp1537_;
				ValaHashMap* _tmp1538_;
				ValaMethod* _tmp1539_;
				ValaCCodeExpression* _tmp1540_;
				ValaCCodeUnaryExpression* _tmp1541_;
				ValaCCodeUnaryExpression* _tmp1542_;
				ValaCCodeExpression* _tmp1543_;
				ValaDelegateType* _tmp1544_;
				_tmp1531_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
				_tmp1532_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1531_, TRUE, NULL, TRUE);
				temp_var = _tmp1532_;
				_tmp1533_ = temp_var;
				_tmp1534_ = vala_symbol_get_name ((ValaSymbol*) _tmp1533_);
				_tmp1535_ = _tmp1534_;
				_tmp1536_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1535_);
				temp_ref = _tmp1536_;
				_tmp1537_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1537_, FALSE);
				_tmp1538_ = out_arg_map;
				_tmp1539_ = m;
				_tmp1540_ = temp_ref;
				_tmp1541_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1540_);
				_tmp1542_ = _tmp1541_;
				vala_map_set ((ValaMap*) _tmp1538_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1539_), FALSE)), (ValaCCodeExpression*) _tmp1542_);
				_vala_ccode_node_unref0 (_tmp1542_);
				_tmp1543_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1543_);
				_tmp1544_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1544_)) {
					ValaDelegateType* _tmp1545_;
					ValaLocalVariable* _tmp1546_;
					ValaLocalVariable* _tmp1547_;
					const gchar* _tmp1548_;
					const gchar* _tmp1549_;
					ValaCCodeExpression* _tmp1550_;
					ValaLocalVariable* _tmp1551_;
					ValaHashMap* _tmp1552_;
					ValaMethod* _tmp1553_;
					ValaCCodeExpression* _tmp1554_;
					ValaCCodeUnaryExpression* _tmp1555_;
					ValaCCodeUnaryExpression* _tmp1556_;
					ValaCCodeExpression* _tmp1557_;
					_tmp1545_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
					_tmp1546_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1545_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1546_;
					_tmp1547_ = temp_var;
					_tmp1548_ = vala_symbol_get_name ((ValaSymbol*) _tmp1547_);
					_tmp1549_ = _tmp1548_;
					_tmp1550_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1549_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1550_;
					_tmp1551_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1551_, FALSE);
					_tmp1552_ = out_arg_map;
					_tmp1553_ = m;
					_tmp1554_ = temp_ref;
					_tmp1555_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1554_);
					_tmp1556_ = _tmp1555_;
					vala_map_set ((ValaMap*) _tmp1552_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1553_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1556_);
					_vala_ccode_node_unref0 (_tmp1556_);
					_tmp1557_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1557_);
				} else {
					ValaCCodeConstant* _tmp1558_;
					ValaCCodeConstant* _tmp1559_;
					_tmp1558_ = vala_ccode_constant_new ("NULL");
					_tmp1559_ = _tmp1558_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1559_);
					_vala_ccode_node_unref0 (_tmp1559_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1560_;
				ValaCCodeConstant* _tmp1561_;
				ValaDelegateType* _tmp1562_;
				ValaDelegate* _tmp1563_;
				ValaDelegate* _tmp1564_;
				gboolean _tmp1565_;
				gboolean _tmp1566_;
				_tmp1560_ = vala_ccode_constant_new ("NULL");
				_tmp1561_ = _tmp1560_;
				vala_set_delegate_target ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1561_);
				_vala_ccode_node_unref0 (_tmp1561_);
				_tmp1562_ = deleg_type;
				_tmp1563_ = vala_delegate_type_get_delegate_symbol (_tmp1562_);
				_tmp1564_ = _tmp1563_;
				_tmp1565_ = vala_delegate_get_has_target (_tmp1564_);
				_tmp1566_ = _tmp1565_;
				if (_tmp1566_) {
					ValaCCodeConstant* _tmp1567_;
					ValaCCodeConstant* _tmp1568_;
					_tmp1567_ = vala_ccode_constant_new ("NULL");
					_tmp1568_ = _tmp1567_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1568_);
					_vala_ccode_node_unref0 (_tmp1568_);
				}
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1570_ = deleg;
	if (_tmp1570_ != NULL) {
		ValaDelegate* _tmp1571_;
		ValaDataType* _tmp1572_;
		ValaDataType* _tmp1573_;
		_tmp1571_ = deleg;
		_tmp1572_ = vala_callable_get_return_type ((ValaCallable*) _tmp1571_);
		_tmp1573_ = _tmp1572_;
		_tmp1569_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1573_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1569_ = FALSE;
	}
	if (_tmp1569_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1574_;
		ValaDataType* _tmp1575_;
		ValaDataType* _tmp1576_;
		ValaArrayType* _tmp1577_;
		_tmp1574_ = deleg;
		_tmp1575_ = vala_callable_get_return_type ((ValaCallable*) _tmp1574_);
		_tmp1576_ = _tmp1575_;
		_tmp1577_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1576_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1577_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1578_ = FALSE;
				_tmp1578_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1580_;
					gint _tmp1581_;
					gint _tmp1582_;
					ValaDelegate* _tmp1583_;
					if (!_tmp1578_) {
						gint _tmp1579_;
						_tmp1579_ = dim;
						dim = _tmp1579_ + 1;
					}
					_tmp1578_ = FALSE;
					_tmp1580_ = array_type;
					_tmp1581_ = vala_array_type_get_rank (_tmp1580_);
					_tmp1582_ = _tmp1581_;
					if (!(dim <= _tmp1582_)) {
						break;
					}
					_tmp1583_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1583_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1584_;
						ValaDataType* _tmp1585_;
						ValaLocalVariable* _tmp1586_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1587_;
						const gchar* _tmp1588_;
						const gchar* _tmp1589_;
						ValaCCodeExpression* _tmp1590_;
						ValaLocalVariable* _tmp1591_;
						ValaCCodeExpression* _tmp1592_;
						ValaCCodeExpression* _tmp1593_;
						ValaCCodeAssignment* _tmp1594_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1595_;
						ValaCCodeIdentifier* _tmp1596_;
						ValaCCodeFunctionCall* _tmp1597_;
						ValaCCodeFunctionCall* _tmp1598_;
						ValaCCodeFunctionCall* _tmp1599_;
						ValaCCodeExpression* _tmp1600_;
						ValaCCodeFunctionCall* _tmp1601_;
						_tmp1584_ = itype;
						_tmp1585_ = vala_data_type_get_return_type (_tmp1584_);
						_tmp1586_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1585_, TRUE, NULL, FALSE);
						temp_var = _tmp1586_;
						_tmp1587_ = temp_var;
						_tmp1588_ = vala_symbol_get_name ((ValaSymbol*) _tmp1587_);
						_tmp1589_ = _tmp1588_;
						_tmp1590_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1589_);
						temp_ref = _tmp1590_;
						_tmp1591_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1591_, FALSE);
						_tmp1592_ = temp_ref;
						_tmp1593_ = ccall_expr;
						_tmp1594_ = vala_ccode_assignment_new (_tmp1592_, _tmp1593_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1594_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1595_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1596_ = _tmp1595_;
						_tmp1597_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1596_);
						_tmp1598_ = _tmp1597_;
						_vala_ccode_node_unref0 (_tmp1596_);
						len_call = _tmp1598_;
						_tmp1599_ = len_call;
						_tmp1600_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1599_, _tmp1600_);
						_tmp1601_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1601_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1602_;
						_tmp1602_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1602_)) {
							gchar* length_ctype = NULL;
							ValaDelegate* _tmp1603_;
							gchar* _tmp1604_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1605_;
							ValaCType* _tmp1606_;
							ValaCType* _tmp1607_;
							ValaLocalVariable* _tmp1608_;
							ValaLocalVariable* _tmp1609_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1610_;
							const gchar* _tmp1611_;
							const gchar* _tmp1612_;
							ValaCCodeExpression* _tmp1613_;
							ValaLocalVariable* _tmp1614_;
							ValaHashMap* _tmp1615_;
							ValaDelegate* _tmp1616_;
							ValaCCodeExpression* _tmp1617_;
							ValaCCodeUnaryExpression* _tmp1618_;
							ValaCCodeUnaryExpression* _tmp1619_;
							ValaCCodeExpression* _tmp1620_;
							_tmp1603_ = deleg;
							_tmp1604_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1603_);
							length_ctype = _tmp1604_;
							_tmp1605_ = length_ctype;
							_tmp1606_ = vala_ctype_new (_tmp1605_, "0");
							_tmp1607_ = _tmp1606_;
							_tmp1608_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1607_, TRUE, NULL, TRUE);
							_tmp1609_ = _tmp1608_;
							_vala_code_node_unref0 (_tmp1607_);
							temp_var = _tmp1609_;
							_tmp1610_ = temp_var;
							_tmp1611_ = vala_symbol_get_name ((ValaSymbol*) _tmp1610_);
							_tmp1612_ = _tmp1611_;
							_tmp1613_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1612_);
							temp_ref = _tmp1613_;
							_tmp1614_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1614_, FALSE);
							_tmp1615_ = out_arg_map;
							_tmp1616_ = deleg;
							_tmp1617_ = temp_ref;
							_tmp1618_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1617_);
							_tmp1619_ = _tmp1618_;
							vala_map_set ((ValaMap*) _tmp1615_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1616_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1619_);
							_vala_ccode_node_unref0 (_tmp1619_);
							_tmp1620_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1620_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaCCodeConstant* _tmp1621_;
							ValaCCodeConstant* _tmp1622_;
							_tmp1621_ = vala_ccode_constant_new ("-1");
							_tmp1622_ = _tmp1621_;
							vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1622_);
							_vala_ccode_node_unref0 (_tmp1622_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1623_ = FALSE;
		gboolean _tmp1624_ = FALSE;
		ValaDelegate* _tmp1625_;
		_tmp1625_ = deleg;
		if (_tmp1625_ != NULL) {
			ValaDelegate* _tmp1626_;
			ValaDataType* _tmp1627_;
			ValaDataType* _tmp1628_;
			_tmp1626_ = deleg;
			_tmp1627_ = vala_callable_get_return_type ((ValaCallable*) _tmp1626_);
			_tmp1628_ = _tmp1627_;
			_tmp1624_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1628_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1624_ = FALSE;
		}
		if (_tmp1624_) {
			ValaDelegate* _tmp1629_;
			_tmp1629_ = deleg;
			_tmp1623_ = vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1629_);
		} else {
			_tmp1623_ = FALSE;
		}
		if (_tmp1623_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1630_;
			ValaDataType* _tmp1631_;
			ValaDataType* _tmp1632_;
			ValaDelegateType* _tmp1633_;
			ValaDelegateType* _tmp1634_;
			ValaDelegate* _tmp1635_;
			ValaDelegate* _tmp1636_;
			gboolean _tmp1637_;
			gboolean _tmp1638_;
			_tmp1630_ = deleg;
			_tmp1631_ = vala_callable_get_return_type ((ValaCallable*) _tmp1630_);
			_tmp1632_ = _tmp1631_;
			_tmp1633_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1632_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1633_;
			_tmp1634_ = deleg_type;
			_tmp1635_ = vala_delegate_type_get_delegate_symbol (_tmp1634_);
			_tmp1636_ = _tmp1635_;
			_tmp1637_ = vala_delegate_get_has_target (_tmp1636_);
			_tmp1638_ = _tmp1637_;
			if (_tmp1638_) {
				ValaLocalVariable* temp_var = NULL;
				ValaDataType* _tmp1639_;
				ValaLocalVariable* _tmp1640_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1641_;
				const gchar* _tmp1642_;
				const gchar* _tmp1643_;
				ValaCCodeExpression* _tmp1644_;
				ValaLocalVariable* _tmp1645_;
				ValaHashMap* _tmp1646_;
				ValaDelegate* _tmp1647_;
				ValaCCodeExpression* _tmp1648_;
				ValaCCodeUnaryExpression* _tmp1649_;
				ValaCCodeUnaryExpression* _tmp1650_;
				ValaCCodeExpression* _tmp1651_;
				ValaDelegateType* _tmp1652_;
				_tmp1639_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
				_tmp1640_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1639_, TRUE, NULL, TRUE);
				temp_var = _tmp1640_;
				_tmp1641_ = temp_var;
				_tmp1642_ = vala_symbol_get_name ((ValaSymbol*) _tmp1641_);
				_tmp1643_ = _tmp1642_;
				_tmp1644_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1643_);
				temp_ref = _tmp1644_;
				_tmp1645_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1645_, FALSE);
				_tmp1646_ = out_arg_map;
				_tmp1647_ = deleg;
				_tmp1648_ = temp_ref;
				_tmp1649_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1648_);
				_tmp1650_ = _tmp1649_;
				vala_map_set ((ValaMap*) _tmp1646_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1647_), FALSE)), (ValaCCodeExpression*) _tmp1650_);
				_vala_ccode_node_unref0 (_tmp1650_);
				_tmp1651_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1651_);
				_tmp1652_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1652_)) {
					ValaDelegateType* _tmp1653_;
					ValaLocalVariable* _tmp1654_;
					ValaLocalVariable* _tmp1655_;
					const gchar* _tmp1656_;
					const gchar* _tmp1657_;
					ValaCCodeExpression* _tmp1658_;
					ValaLocalVariable* _tmp1659_;
					ValaHashMap* _tmp1660_;
					ValaDelegate* _tmp1661_;
					ValaCCodeExpression* _tmp1662_;
					ValaCCodeUnaryExpression* _tmp1663_;
					ValaCCodeUnaryExpression* _tmp1664_;
					ValaCCodeExpression* _tmp1665_;
					_tmp1653_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
					_tmp1654_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1653_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1654_;
					_tmp1655_ = temp_var;
					_tmp1656_ = vala_symbol_get_name ((ValaSymbol*) _tmp1655_);
					_tmp1657_ = _tmp1656_;
					_tmp1658_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1657_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1658_;
					_tmp1659_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1659_, FALSE);
					_tmp1660_ = out_arg_map;
					_tmp1661_ = deleg;
					_tmp1662_ = temp_ref;
					_tmp1663_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1662_);
					_tmp1664_ = _tmp1663_;
					vala_map_set ((ValaMap*) _tmp1660_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1661_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1664_);
					_vala_ccode_node_unref0 (_tmp1664_);
					_tmp1665_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1665_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1667_ = m;
	if (_tmp1667_ != NULL) {
		ValaMethod* _tmp1668_;
		gboolean _tmp1669_;
		gboolean _tmp1670_;
		_tmp1668_ = m;
		_tmp1669_ = vala_method_get_coroutine (_tmp1668_);
		_tmp1670_ = _tmp1669_;
		_tmp1666_ = _tmp1670_;
	} else {
		_tmp1666_ = FALSE;
	}
	if (_tmp1666_) {
		gboolean _tmp1671_;
		gboolean _tmp1672_;
		_tmp1671_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1672_ = _tmp1671_;
		if (_tmp1672_) {
			ValaHashMap* _tmp1673_;
			ValaMethod* _tmp1674_;
			ValaMethod* _tmp1675_;
			gchar* _tmp1676_;
			gchar* _tmp1677_;
			ValaCCodeIdentifier* _tmp1678_;
			ValaCCodeIdentifier* _tmp1679_;
			ValaHashMap* _tmp1680_;
			ValaCCodeIdentifier* _tmp1681_;
			ValaCCodeIdentifier* _tmp1682_;
			_tmp1673_ = in_arg_map;
			_tmp1674_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1675_ = _tmp1674_;
			_tmp1676_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1675_);
			_tmp1677_ = _tmp1676_;
			_tmp1678_ = vala_ccode_identifier_new (_tmp1677_);
			_tmp1679_ = _tmp1678_;
			vala_map_set ((ValaMap*) _tmp1673_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1679_);
			_vala_ccode_node_unref0 (_tmp1679_);
			_g_free0 (_tmp1677_);
			_tmp1680_ = in_arg_map;
			_tmp1681_ = vala_ccode_identifier_new ("_data_");
			_tmp1682_ = _tmp1681_;
			vala_map_set ((ValaMap*) _tmp1680_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1682_);
			_vala_ccode_node_unref0 (_tmp1682_);
		}
	}
	_tmp1683_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1684_ = _tmp1683_;
	if (_tmp1684_) {
		ValaCallable* _tmp1685_ = NULL;
		ValaMethod* _tmp1686_;
		ValaHashMap* _tmp1688_;
		ValaCCodeExpression* _tmp1689_;
		ValaCCodeExpression* _tmp1690_;
		ValaCCodeUnaryExpression* _tmp1691_;
		ValaCCodeUnaryExpression* _tmp1692_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1686_ = m;
		_tmp1685_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1686_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1685_ == NULL) {
			ValaDelegate* _tmp1687_;
			_tmp1687_ = deleg;
			_tmp1685_ = (ValaCallable*) _tmp1687_;
		}
		_tmp1688_ = out_arg_map;
		_tmp1689_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1690_ = _tmp1689_;
		_tmp1691_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1690_);
		_tmp1692_ = _tmp1691_;
		vala_map_set ((ValaMap*) _tmp1688_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1685_), FALSE)), (ValaCCodeExpression*) _tmp1692_);
		_vala_ccode_node_unref0 (_tmp1692_);
		_vala_ccode_node_unref0 (_tmp1690_);
	} else {
		gboolean _tmp1693_ = FALSE;
		gboolean _tmp1694_ = FALSE;
		ValaMethod* _tmp1695_;
		_tmp1695_ = m;
		if (_tmp1695_ != NULL) {
			ValaMethod* _tmp1696_;
			_tmp1696_ = m;
			_tmp1694_ = vala_method_has_error_type_parameter (_tmp1696_);
		} else {
			_tmp1694_ = FALSE;
		}
		if (_tmp1694_) {
			ValaCCodeFunctionCall* _tmp1697_;
			ValaCCodeFunctionCall* _tmp1698_;
			_tmp1697_ = async_call;
			_tmp1698_ = ccall;
			_tmp1693_ = _tmp1697_ != _tmp1698_;
		} else {
			_tmp1693_ = FALSE;
		}
		if (_tmp1693_) {
			ValaHashMap* _tmp1699_;
			ValaMethod* _tmp1700_;
			ValaCCodeConstant* _tmp1701_;
			ValaCCodeConstant* _tmp1702_;
			_tmp1699_ = out_arg_map;
			_tmp1700_ = m;
			_tmp1701_ = vala_ccode_constant_new ("NULL");
			_tmp1702_ = _tmp1701_;
			vala_map_set ((ValaMap*) _tmp1699_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1700_), FALSE)), (ValaCCodeExpression*) _tmp1702_);
			_vala_ccode_node_unref0 (_tmp1702_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1703_;
		_tmp1703_ = m;
		if (_tmp1703_ == NULL) {
			ValaHashMap* _tmp1704_;
			ValaCCodeConstant* _tmp1705_;
			ValaCCodeConstant* _tmp1706_;
			_tmp1704_ = in_arg_map;
			_tmp1705_ = vala_ccode_constant_new ("NULL");
			_tmp1706_ = _tmp1705_;
			vala_map_set ((ValaMap*) _tmp1704_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1706_);
			_vala_ccode_node_unref0 (_tmp1706_);
		} else {
			gboolean _tmp1707_ = FALSE;
			gboolean _tmp1708_ = FALSE;
			gboolean _tmp1709_ = FALSE;
			ValaMethod* _tmp1710_;
			gboolean _tmp1711_;
			gboolean _tmp1712_;
			_tmp1710_ = m;
			_tmp1711_ = vala_method_get_printf_format (_tmp1710_);
			_tmp1712_ = _tmp1711_;
			if (!_tmp1712_) {
				ValaMethod* _tmp1713_;
				gboolean _tmp1714_;
				gboolean _tmp1715_;
				_tmp1713_ = m;
				_tmp1714_ = vala_method_get_scanf_format (_tmp1713_);
				_tmp1715_ = _tmp1714_;
				_tmp1709_ = !_tmp1715_;
			} else {
				_tmp1709_ = FALSE;
			}
			if (_tmp1709_) {
				ValaMethod* _tmp1716_;
				gchar* _tmp1717_;
				gchar* _tmp1718_;
				_tmp1716_ = m;
				_tmp1717_ = vala_get_ccode_sentinel (_tmp1716_);
				_tmp1718_ = _tmp1717_;
				_tmp1708_ = g_strcmp0 (_tmp1718_, "") != 0;
				_g_free0 (_tmp1718_);
			} else {
				_tmp1708_ = FALSE;
			}
			if (_tmp1708_) {
				gboolean _tmp1719_;
				gboolean _tmp1720_;
				_tmp1719_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1720_ = _tmp1719_;
				_tmp1707_ = !_tmp1720_;
			} else {
				_tmp1707_ = FALSE;
			}
			if (_tmp1707_) {
				ValaHashMap* _tmp1721_;
				ValaMethod* _tmp1722_;
				gchar* _tmp1723_;
				gchar* _tmp1724_;
				ValaCCodeConstant* _tmp1725_;
				ValaCCodeConstant* _tmp1726_;
				_tmp1721_ = in_arg_map;
				_tmp1722_ = m;
				_tmp1723_ = vala_get_ccode_sentinel (_tmp1722_);
				_tmp1724_ = _tmp1723_;
				_tmp1725_ = vala_ccode_constant_new (_tmp1724_);
				_tmp1726_ = _tmp1725_;
				vala_map_set ((ValaMap*) _tmp1721_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1726_);
				_vala_ccode_node_unref0 (_tmp1726_);
				_g_free0 (_tmp1724_);
			}
		}
	}
	_tmp1728_ = deleg;
	if (_tmp1728_ != NULL) {
		ValaDelegate* _tmp1729_;
		gboolean _tmp1730_;
		gboolean _tmp1731_;
		_tmp1729_ = deleg;
		_tmp1730_ = vala_delegate_get_has_target (_tmp1729_);
		_tmp1731_ = _tmp1730_;
		_tmp1727_ = _tmp1731_;
	} else {
		_tmp1727_ = FALSE;
	}
	if (_tmp1727_) {
		ValaCCodeExpression* delegate_target_destroy_notify = NULL;
		ValaHashMap* _tmp1732_;
		ValaDelegate* _tmp1733_;
		ValaExpression* _tmp1734_;
		ValaExpression* _tmp1735_;
		ValaCCodeExpression* _tmp1736_ = NULL;
		ValaCCodeExpression* _tmp1737_;
		ValaCCodeExpression* _tmp1738_;
		ValaHashMap* _tmp1739_;
		ValaDelegate* _tmp1740_;
		ValaExpression* _tmp1741_;
		ValaExpression* _tmp1742_;
		ValaCCodeExpression* _tmp1743_ = NULL;
		ValaCCodeExpression* _tmp1744_;
		ValaCCodeExpression* _tmp1745_;
		_tmp1732_ = in_arg_map;
		_tmp1733_ = deleg;
		_tmp1734_ = vala_method_call_get_call (expr);
		_tmp1735_ = _tmp1734_;
		_tmp1737_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1735_, &_tmp1736_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1736_;
		_tmp1738_ = _tmp1737_;
		vala_map_set ((ValaMap*) _tmp1732_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1733_), FALSE)), _tmp1738_);
		_vala_ccode_node_unref0 (_tmp1738_);
		_tmp1739_ = out_arg_map;
		_tmp1740_ = deleg;
		_tmp1741_ = vala_method_call_get_call (expr);
		_tmp1742_ = _tmp1741_;
		_tmp1744_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1742_, &_tmp1743_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1743_;
		_tmp1745_ = _tmp1744_;
		vala_map_set ((ValaMap*) _tmp1739_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1740_), FALSE)), _tmp1745_);
		_vala_ccode_node_unref0 (_tmp1745_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
	}
	_tmp1746_ = itype;
	_tmp1747_ = vala_data_type_get_return_type (_tmp1746_);
	return_result_via_out_param = vala_data_type_is_real_non_null_struct_type (_tmp1747_);
	_tmp1749_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1749_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1750_;
		ValaDataType* _tmp1751_;
		_tmp1750_ = itype;
		_tmp1751_ = vala_data_type_get_return_type (_tmp1750_);
		_tmp1748_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1751_, VALA_TYPE_VOID_TYPE);
	} else {
		_tmp1748_ = FALSE;
	}
	if (_tmp1748_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1752_;
		ValaSignal* _tmp1753_;
		ValaSignal* _tmp1754_;
		ValaSignal* _tmp1755_;
		gboolean _tmp1756_ = FALSE;
		gboolean _tmp1757_ = FALSE;
		ValaMemberAccess* _tmp1758_;
		_tmp1752_ = itype;
		_tmp1753_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1752_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1754_ = _tmp1753_;
		_tmp1755_ = _vala_code_node_ref0 (_tmp1754_);
		sig = _tmp1755_;
		_tmp1758_ = ma;
		if (_tmp1758_ != NULL) {
			ValaMemberAccess* _tmp1759_;
			ValaExpression* _tmp1760_;
			ValaExpression* _tmp1761_;
			_tmp1759_ = ma;
			_tmp1760_ = vala_member_access_get_inner (_tmp1759_);
			_tmp1761_ = _tmp1760_;
			_tmp1757_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1761_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1757_ = FALSE;
		}
		if (_tmp1757_) {
			ValaSignal* _tmp1762_;
			gboolean _tmp1763_;
			gboolean _tmp1764_;
			_tmp1762_ = sig;
			_tmp1763_ = vala_signal_get_is_virtual (_tmp1762_);
			_tmp1764_ = _tmp1763_;
			_tmp1756_ = _tmp1764_;
		} else {
			_tmp1756_ = FALSE;
		}
		if (_tmp1756_) {
		} else {
			gboolean _tmp1765_ = FALSE;
			ValaSignal* _tmp1766_;
			_tmp1766_ = sig;
			if (!vala_get_ccode_has_emitter (_tmp1766_)) {
				_tmp1765_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1767_;
				ValaSourceReference* _tmp1768_;
				ValaSourceReference* _tmp1769_;
				ValaSourceFile* _tmp1770_;
				ValaSourceFile* _tmp1771_;
				ValaSignal* _tmp1772_;
				ValaSourceReference* _tmp1773_;
				ValaSourceReference* _tmp1774_;
				ValaSourceFile* _tmp1775_;
				ValaSourceFile* _tmp1776_;
				_tmp1767_ = ma;
				_tmp1768_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1767_);
				_tmp1769_ = _tmp1768_;
				_tmp1770_ = vala_source_reference_get_file (_tmp1769_);
				_tmp1771_ = _tmp1770_;
				_tmp1772_ = sig;
				_tmp1773_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1772_);
				_tmp1774_ = _tmp1773_;
				_tmp1775_ = vala_source_reference_get_file (_tmp1774_);
				_tmp1776_ = _tmp1775_;
				_tmp1765_ = _tmp1771_ == _tmp1776_;
			}
			if (_tmp1765_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1777_ = async_call;
	_tmp1778_ = ccall;
	if (_tmp1777_ == _tmp1778_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1779_;
		ValaDataType* _tmp1780_;
		ValaLocalVariable* _tmp1781_;
		ValaLocalVariable* _tmp1782_;
		const gchar* _tmp1783_;
		const gchar* _tmp1784_;
		ValaCCodeExpression* _tmp1785_;
		ValaLocalVariable* _tmp1786_;
		ValaHashMap* _tmp1787_;
		ValaCCodeExpression* _tmp1788_;
		ValaCCodeUnaryExpression* _tmp1789_;
		ValaCCodeUnaryExpression* _tmp1790_;
		_tmp1779_ = itype;
		_tmp1780_ = vala_data_type_get_return_type (_tmp1779_);
		_tmp1781_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1780_, TRUE, NULL, TRUE);
		out_param_var = _tmp1781_;
		_tmp1782_ = out_param_var;
		_tmp1783_ = vala_symbol_get_name ((ValaSymbol*) _tmp1782_);
		_tmp1784_ = _tmp1783_;
		_tmp1785_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1784_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1785_;
		_tmp1786_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1786_, FALSE);
		_tmp1787_ = out_arg_map;
		_tmp1788_ = out_param_ref;
		_tmp1789_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1788_);
		_tmp1790_ = _tmp1789_;
		vala_map_set ((ValaMap*) _tmp1787_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1790_);
		_vala_ccode_node_unref0 (_tmp1790_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1791_ = async_call;
	_tmp1792_ = ccall;
	if (_tmp1791_ != _tmp1792_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1803_;
			ValaHashMap* _tmp1804_;
			gpointer _tmp1805_;
			ValaCCodeExpression* _tmp1806_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1793_;
				ValaSet* _tmp1794_;
				ValaSet* _tmp1795_;
				ValaIterator* _tmp1796_;
				ValaIterator* _tmp1797_;
				_tmp1793_ = out_arg_map;
				_tmp1794_ = vala_map_get_keys ((ValaMap*) _tmp1793_);
				_tmp1795_ = _tmp1794_;
				_tmp1796_ = vala_iterable_iterator ((ValaIterable*) _tmp1795_);
				_tmp1797_ = _tmp1796_;
				_vala_iterable_unref0 (_tmp1795_);
				_pos_it = _tmp1797_;
				while (TRUE) {
					ValaIterator* _tmp1798_;
					gint pos = 0;
					ValaIterator* _tmp1799_;
					gpointer _tmp1800_;
					gboolean _tmp1801_ = FALSE;
					_tmp1798_ = _pos_it;
					if (!vala_iterator_next (_tmp1798_)) {
						break;
					}
					_tmp1799_ = _pos_it;
					_tmp1800_ = vala_iterator_get (_tmp1799_);
					pos = (gint) ((gintptr) _tmp1800_);
					if (pos > last_pos) {
						gboolean _tmp1802_ = FALSE;
						if (min_pos == -1) {
							_tmp1802_ = TRUE;
						} else {
							_tmp1802_ = pos < min_pos;
						}
						_tmp1801_ = _tmp1802_;
					} else {
						_tmp1801_ = FALSE;
					}
					if (_tmp1801_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1803_ = ccall;
			_tmp1804_ = out_arg_map;
			_tmp1805_ = vala_map_get ((ValaMap*) _tmp1804_, (gpointer) ((gintptr) min_pos));
			_tmp1806_ = (ValaCCodeExpression*) _tmp1805_;
			vala_ccode_function_call_add_argument (_tmp1803_, _tmp1806_);
			_vala_ccode_node_unref0 (_tmp1806_);
			last_pos = min_pos;
		}
	}
	_tmp1807_ = async_call;
	if (_tmp1807_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1818_;
			ValaHashMap* _tmp1819_;
			gpointer _tmp1820_;
			ValaCCodeExpression* _tmp1821_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1808_;
				ValaSet* _tmp1809_;
				ValaSet* _tmp1810_;
				ValaIterator* _tmp1811_;
				ValaIterator* _tmp1812_;
				_tmp1808_ = in_arg_map;
				_tmp1809_ = vala_map_get_keys ((ValaMap*) _tmp1808_);
				_tmp1810_ = _tmp1809_;
				_tmp1811_ = vala_iterable_iterator ((ValaIterable*) _tmp1810_);
				_tmp1812_ = _tmp1811_;
				_vala_iterable_unref0 (_tmp1810_);
				_pos_it = _tmp1812_;
				while (TRUE) {
					ValaIterator* _tmp1813_;
					gint pos = 0;
					ValaIterator* _tmp1814_;
					gpointer _tmp1815_;
					gboolean _tmp1816_ = FALSE;
					_tmp1813_ = _pos_it;
					if (!vala_iterator_next (_tmp1813_)) {
						break;
					}
					_tmp1814_ = _pos_it;
					_tmp1815_ = vala_iterator_get (_tmp1814_);
					pos = (gint) ((gintptr) _tmp1815_);
					if (pos > last_pos) {
						gboolean _tmp1817_ = FALSE;
						if (min_pos == -1) {
							_tmp1817_ = TRUE;
						} else {
							_tmp1817_ = pos < min_pos;
						}
						_tmp1816_ = _tmp1817_;
					} else {
						_tmp1816_ = FALSE;
					}
					if (_tmp1816_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1818_ = async_call;
			_tmp1819_ = in_arg_map;
			_tmp1820_ = vala_map_get ((ValaMap*) _tmp1819_, (gpointer) ((gintptr) min_pos));
			_tmp1821_ = (ValaCCodeExpression*) _tmp1820_;
			vala_ccode_function_call_add_argument (_tmp1818_, _tmp1821_);
			_vala_ccode_node_unref0 (_tmp1821_);
			last_pos = min_pos;
		}
	}
	_tmp1822_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1823_ = _tmp1822_;
	if (_tmp1823_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1824_;
		gint _tmp1825_;
		ValaCCodeFunction* _tmp1826_;
		ValaCCodeFunction* _tmp1827_;
		ValaCCodeIdentifier* _tmp1828_;
		ValaCCodeIdentifier* _tmp1829_;
		ValaCCodeMemberAccess* _tmp1830_;
		ValaCCodeMemberAccess* _tmp1831_;
		gchar* _tmp1832_;
		gchar* _tmp1833_;
		ValaCCodeConstant* _tmp1834_;
		ValaCCodeConstant* _tmp1835_;
		ValaCCodeFunction* _tmp1836_;
		ValaCCodeFunction* _tmp1837_;
		ValaCCodeFunctionCall* _tmp1838_;
		ValaCCodeFunction* _tmp1839_;
		ValaCCodeFunction* _tmp1840_;
		ValaCCodeConstant* _tmp1841_;
		ValaCCodeConstant* _tmp1842_;
		ValaCCodeFunction* _tmp1843_;
		ValaCCodeFunction* _tmp1844_;
		gchar* _tmp1845_;
		gchar* _tmp1846_;
		_tmp1824_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1825_ = _tmp1824_->next_coroutine_state;
		_tmp1824_->next_coroutine_state = _tmp1825_ + 1;
		state = _tmp1825_;
		_tmp1826_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1827_ = _tmp1826_;
		_tmp1828_ = vala_ccode_identifier_new ("_data_");
		_tmp1829_ = _tmp1828_;
		_tmp1830_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1829_, "_state_");
		_tmp1831_ = _tmp1830_;
		_tmp1832_ = g_strdup_printf ("%i", state);
		_tmp1833_ = _tmp1832_;
		_tmp1834_ = vala_ccode_constant_new (_tmp1833_);
		_tmp1835_ = _tmp1834_;
		vala_ccode_function_add_assignment (_tmp1827_, (ValaCCodeExpression*) _tmp1831_, (ValaCCodeExpression*) _tmp1835_);
		_vala_ccode_node_unref0 (_tmp1835_);
		_g_free0 (_tmp1833_);
		_vala_ccode_node_unref0 (_tmp1831_);
		_vala_ccode_node_unref0 (_tmp1829_);
		_tmp1836_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1837_ = _tmp1836_;
		_tmp1838_ = async_call;
		vala_ccode_function_add_expression (_tmp1837_, (ValaCCodeExpression*) _tmp1838_);
		_tmp1839_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1840_ = _tmp1839_;
		_tmp1841_ = vala_ccode_constant_new ("FALSE");
		_tmp1842_ = _tmp1841_;
		vala_ccode_function_add_return (_tmp1840_, (ValaCCodeExpression*) _tmp1842_);
		_vala_ccode_node_unref0 (_tmp1842_);
		_tmp1843_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1844_ = _tmp1843_;
		_tmp1845_ = g_strdup_printf ("_state_%d", state);
		_tmp1846_ = _tmp1845_;
		vala_ccode_function_add_label (_tmp1844_, _tmp1846_);
		_g_free0 (_tmp1846_);
	}
	_tmp1847_ = vala_method_call_get_is_assert (expr);
	_tmp1848_ = _tmp1847_;
	if (_tmp1848_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1849_;
		ValaSourceReference* _tmp1850_;
		ValaSourceLocation _tmp1851_ = {0};
		ValaSourceLocation _tmp1852_;
		gchar* _tmp1853_;
		ValaSourceReference* _tmp1854_;
		ValaSourceReference* _tmp1855_;
		ValaSourceLocation _tmp1856_ = {0};
		ValaSourceLocation _tmp1857_;
		gchar* _tmp1858_;
		ValaSourceReference* _tmp1859_;
		ValaSourceReference* _tmp1860_;
		ValaSourceLocation _tmp1861_ = {0};
		ValaSourceLocation _tmp1862_;
		gchar* _tmp1863_;
		gchar* _tmp1864_;
		ValaCCodeFunctionCall* _tmp1865_;
		ValaCCodeIdentifier* _tmp1866_;
		ValaCCodeIdentifier* _tmp1867_;
		ValaCCodeFunctionCall* _tmp1868_;
		const gchar* _tmp1869_;
		gchar* _tmp1870_;
		gchar* _tmp1871_;
		gchar* _tmp1872_;
		gchar* _tmp1873_;
		gchar* _tmp1874_;
		gchar* _tmp1875_;
		ValaCCodeConstant* _tmp1876_;
		ValaCCodeConstant* _tmp1877_;
		_tmp1849_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1850_ = _tmp1849_;
		vala_source_reference_get_begin (_tmp1850_, &_tmp1851_);
		_tmp1852_ = _tmp1851_;
		_tmp1853_ = _tmp1852_.pos;
		_tmp1854_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1855_ = _tmp1854_;
		vala_source_reference_get_end (_tmp1855_, &_tmp1856_);
		_tmp1857_ = _tmp1856_;
		_tmp1858_ = _tmp1857_.pos;
		_tmp1859_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1860_ = _tmp1859_;
		vala_source_reference_get_begin (_tmp1860_, &_tmp1861_);
		_tmp1862_ = _tmp1861_;
		_tmp1863_ = _tmp1862_.pos;
		_tmp1864_ = string_substring ((const gchar*) _tmp1853_, (glong) 0, (glong) ((gint) (_tmp1858_ - _tmp1863_)));
		message = _tmp1864_;
		_tmp1865_ = ccall;
		_tmp1866_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1867_ = _tmp1866_;
		vala_ccode_function_call_set_call (_tmp1865_, (ValaCCodeExpression*) _tmp1867_);
		_vala_ccode_node_unref0 (_tmp1867_);
		_tmp1868_ = ccall;
		_tmp1869_ = message;
		_tmp1870_ = string_replace (_tmp1869_, "\n", " ");
		_tmp1871_ = _tmp1870_;
		_tmp1872_ = g_strescape (_tmp1871_, "");
		_tmp1873_ = _tmp1872_;
		_tmp1874_ = g_strdup_printf ("\"%s\"", _tmp1873_);
		_tmp1875_ = _tmp1874_;
		_tmp1876_ = vala_ccode_constant_new (_tmp1875_);
		_tmp1877_ = _tmp1876_;
		vala_ccode_function_call_add_argument (_tmp1868_, (ValaCCodeExpression*) _tmp1877_);
		_vala_ccode_node_unref0 (_tmp1877_);
		_g_free0 (_tmp1875_);
		_g_free0 (_tmp1873_);
		_g_free0 (_tmp1871_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1878_;
		ValaCCodeFunction* _tmp1879_;
		ValaCCodeExpression* _tmp1880_;
		ValaCCodeExpression* _tmp1881_;
		ValaCCodeExpression* _tmp1882_;
		_tmp1878_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1879_ = _tmp1878_;
		_tmp1880_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1879_, _tmp1880_);
		_tmp1881_ = out_param_ref;
		_tmp1882_ = _vala_ccode_node_ref0 (_tmp1881_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1882_;
	}
	_tmp1885_ = m;
	if (_tmp1885_ != NULL) {
		ValaMethod* _tmp1886_;
		ValaMemberBinding _tmp1887_;
		ValaMemberBinding _tmp1888_;
		_tmp1886_ = m;
		_tmp1887_ = vala_method_get_binding (_tmp1886_);
		_tmp1888_ = _tmp1887_;
		_tmp1884_ = _tmp1888_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1884_ = FALSE;
	}
	if (_tmp1884_) {
		ValaMethod* _tmp1889_;
		gboolean _tmp1890_;
		gboolean _tmp1891_;
		_tmp1889_ = m;
		_tmp1890_ = vala_method_get_returns_modified_pointer (_tmp1889_);
		_tmp1891_ = _tmp1890_;
		_tmp1883_ = _tmp1891_;
	} else {
		_tmp1883_ = FALSE;
	}
	if (_tmp1883_) {
		gboolean _tmp1892_ = FALSE;
		gboolean _tmp1893_ = FALSE;
		ValaMemberAccess* _tmp1894_;
		_tmp1894_ = ma;
		if (_tmp1894_ != NULL) {
			ValaMemberAccess* _tmp1895_;
			ValaExpression* _tmp1896_;
			ValaExpression* _tmp1897_;
			ValaSymbol* _tmp1898_;
			ValaSymbol* _tmp1899_;
			_tmp1895_ = ma;
			_tmp1896_ = vala_member_access_get_inner (_tmp1895_);
			_tmp1897_ = _tmp1896_;
			_tmp1898_ = vala_expression_get_symbol_reference (_tmp1897_);
			_tmp1899_ = _tmp1898_;
			_tmp1893_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1899_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1893_ = FALSE;
		}
		if (_tmp1893_) {
			ValaMemberAccess* _tmp1900_;
			ValaExpression* _tmp1901_;
			ValaExpression* _tmp1902_;
			_tmp1900_ = ma;
			_tmp1901_ = vala_member_access_get_inner (_tmp1900_);
			_tmp1902_ = _tmp1901_;
			_tmp1892_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1902_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1892_ = FALSE;
		}
		if (_tmp1892_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1903_;
			ValaExpression* _tmp1904_;
			ValaExpression* _tmp1905_;
			ValaSymbol* _tmp1906_;
			ValaSymbol* _tmp1907_;
			ValaProperty* _tmp1908_;
			ValaProperty* _tmp1909_;
			ValaMemberAccess* _tmp1910_;
			ValaExpression* _tmp1911_;
			ValaExpression* _tmp1912_;
			ValaExpression* _tmp1913_;
			ValaExpression* _tmp1914_;
			ValaDataType* _tmp1915_;
			ValaDataType* _tmp1916_;
			ValaCCodeExpression* _tmp1917_;
			ValaGLibValue* _tmp1918_;
			ValaGLibValue* _tmp1919_;
			_tmp1903_ = ma;
			_tmp1904_ = vala_member_access_get_inner (_tmp1903_);
			_tmp1905_ = _tmp1904_;
			_tmp1906_ = vala_expression_get_symbol_reference (_tmp1905_);
			_tmp1907_ = _tmp1906_;
			_tmp1908_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1907_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1908_;
			_tmp1909_ = prop;
			_tmp1910_ = ma;
			_tmp1911_ = vala_member_access_get_inner (_tmp1910_);
			_tmp1912_ = _tmp1911_;
			_tmp1913_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1912_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1914_ = _tmp1913_;
			_tmp1915_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1916_ = _tmp1915_;
			_tmp1917_ = ccall_expr;
			_tmp1918_ = vala_glib_value_new (_tmp1916_, _tmp1917_, FALSE);
			_tmp1919_ = _tmp1918_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1909_, _tmp1914_, (ValaTargetValue*) _tmp1919_);
			_vala_target_value_unref0 (_tmp1919_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1920_;
			ValaCCodeExpression* _tmp1921_;
			ValaCCodeAssignment* _tmp1922_;
			_tmp1920_ = instance;
			_tmp1921_ = ccall_expr;
			_tmp1922_ = vala_ccode_assignment_new (_tmp1920_, _tmp1921_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1922_;
		}
	}
	_tmp1928_ = m;
	if (_tmp1928_ != NULL) {
		ValaMethod* _tmp1929_;
		_tmp1929_ = m;
		_tmp1927_ = vala_get_ccode_simple_generics (_tmp1929_);
	} else {
		_tmp1927_ = FALSE;
	}
	if (_tmp1927_) {
		ValaMethod* _tmp1930_;
		ValaDataType* _tmp1931_;
		ValaDataType* _tmp1932_;
		_tmp1930_ = m;
		_tmp1931_ = vala_callable_get_return_type ((ValaCallable*) _tmp1930_);
		_tmp1932_ = _tmp1931_;
		_tmp1926_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1932_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1926_ = FALSE;
	}
	if (_tmp1926_) {
		ValaDataType* _tmp1933_;
		ValaDataType* _tmp1934_;
		_tmp1933_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1934_ = _tmp1933_;
		_tmp1925_ = vala_data_type_is_real_struct_type (_tmp1934_);
	} else {
		_tmp1925_ = FALSE;
	}
	if (_tmp1925_) {
		ValaDataType* _tmp1935_;
		ValaDataType* _tmp1936_;
		gboolean _tmp1937_;
		gboolean _tmp1938_;
		_tmp1935_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1936_ = _tmp1935_;
		_tmp1937_ = vala_data_type_get_nullable (_tmp1936_);
		_tmp1938_ = _tmp1937_;
		_tmp1924_ = !_tmp1938_;
	} else {
		_tmp1924_ = FALSE;
	}
	if (_tmp1924_) {
		ValaDataType* _tmp1939_;
		ValaDataType* _tmp1940_;
		_tmp1939_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1940_ = _tmp1939_;
		_tmp1923_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1940_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1923_ = FALSE;
	}
	if (_tmp1923_) {
		ValaCCodeExpression* _tmp1941_;
		ValaCCodeParenthesizedExpression* _tmp1942_;
		ValaCCodeParenthesizedExpression* _tmp1943_;
		ValaCCodeUnaryExpression* _tmp1944_;
		_tmp1941_ = ccall_expr;
		_tmp1942_ = vala_ccode_parenthesized_expression_new (_tmp1941_);
		_tmp1943_ = _tmp1942_;
		_tmp1944_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1943_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1944_;
		_vala_ccode_node_unref0 (_tmp1943_);
	}
	_tmp1947_ = m;
	if (_tmp1947_ != NULL) {
		ValaMethod* _tmp1948_;
		gchar* _tmp1949_;
		gchar* _tmp1950_;
		_tmp1948_ = m;
		_tmp1949_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1948_);
		_tmp1950_ = _tmp1949_;
		_tmp1946_ = _tmp1950_ != NULL;
		_g_free0 (_tmp1950_);
	} else {
		_tmp1946_ = FALSE;
	}
	if (_tmp1946_) {
		ValaMethod* _tmp1951_;
		gchar* _tmp1952_;
		gchar* _tmp1953_;
		ValaMethod* _tmp1954_;
		ValaDataType* _tmp1955_;
		ValaDataType* _tmp1956_;
		gchar* _tmp1957_;
		gchar* _tmp1958_;
		_tmp1951_ = m;
		_tmp1952_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1951_);
		_tmp1953_ = _tmp1952_;
		_tmp1954_ = m;
		_tmp1955_ = vala_callable_get_return_type ((ValaCallable*) _tmp1954_);
		_tmp1956_ = _tmp1955_;
		_tmp1957_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1956_);
		_tmp1958_ = _tmp1957_;
		_tmp1945_ = g_strcmp0 (_tmp1953_, _tmp1958_) != 0;
		_g_free0 (_tmp1958_);
		_g_free0 (_tmp1953_);
	} else {
		_tmp1945_ = FALSE;
	}
	if (_tmp1945_) {
		ValaCCodeExpression* _tmp1959_;
		ValaMethod* _tmp1960_;
		ValaDataType* _tmp1961_;
		ValaDataType* _tmp1962_;
		gchar* _tmp1963_;
		gchar* _tmp1964_;
		ValaCCodeCastExpression* _tmp1965_;
		_tmp1959_ = ccall_expr;
		_tmp1960_ = m;
		_tmp1961_ = vala_callable_get_return_type ((ValaCallable*) _tmp1960_);
		_tmp1962_ = _tmp1961_;
		_tmp1963_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1962_);
		_tmp1964_ = _tmp1963_;
		_tmp1965_ = vala_ccode_cast_expression_new (_tmp1959_, _tmp1964_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1965_;
		_g_free0 (_tmp1964_);
	}
	_tmp1966_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1966_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1967_;
		ValaIterator* _tmp1968_;
		ValaIterator* _tmp1969_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1970_;
		gpointer _tmp1971_;
		ValaExpression* _tmp1972_;
		ValaCCodeExpression* _tmp1973_;
		ValaCCodeExpression* _tmp1974_;
		ValaCCodeExpression* _tmp1975_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1976_;
		ValaLocalVariable* _tmp1977_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1978_;
		const gchar* _tmp1979_;
		const gchar* _tmp1980_;
		ValaCCodeExpression* _tmp1981_;
		ValaLocalVariable* _tmp1982_;
		ValaCCodeFile* _tmp1983_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1984_;
		ValaExpression* _tmp1985_;
		ValaExpression* _tmp1986_;
		ValaCCodeExpression* _tmp1987_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1988_;
		ValaExpression* _tmp1989_;
		ValaExpression* _tmp1990_;
		ValaCCodeExpression* _tmp1991_;
		ValaCCodeExpression* _tmp1992_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1993_;
		ValaExpression* _tmp1994_;
		ValaExpression* _tmp1995_;
		ValaDataType* _tmp1996_;
		ValaDataType* _tmp1997_;
		ValaArrayType* _tmp1998_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1999_;
		ValaDataType* _tmp2000_;
		ValaDataType* _tmp2001_;
		gchar* _tmp2002_;
		gchar* _tmp2003_;
		gchar* _tmp2004_;
		gchar* _tmp2005_;
		ValaCCodeIdentifier* _tmp2006_;
		ValaCCodeIdentifier* _tmp2007_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp2008_;
		ValaCCodeExpression* _tmp2009_;
		ValaCCodeBinaryExpression* _tmp2010_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp2011_;
		ValaCCodeExpression* _tmp2012_;
		ValaCCodeBinaryExpression* _tmp2013_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp2014_;
		ValaCCodeIdentifier* _tmp2015_;
		ValaCCodeFunctionCall* _tmp2016_;
		ValaCCodeFunctionCall* _tmp2017_;
		ValaCCodeFunctionCall* _tmp2018_;
		ValaCCodeExpression* _tmp2019_;
		ValaCCodeExpression* _tmp2020_;
		ValaCCodeBinaryExpression* _tmp2021_;
		ValaCCodeBinaryExpression* _tmp2022_;
		ValaCCodeFunctionCall* _tmp2023_;
		ValaCCodeConstant* _tmp2024_;
		ValaCCodeConstant* _tmp2025_;
		ValaCCodeFunctionCall* _tmp2026_;
		ValaCCodeIdentifier* _tmp2027_;
		ValaCCodeBinaryExpression* _tmp2028_;
		ValaCCodeBinaryExpression* _tmp2029_;
		ValaCCodeBinaryExpression* _tmp2030_;
		ValaCCodeFunction* _tmp2031_;
		ValaCCodeFunction* _tmp2032_;
		ValaCCodeExpression* _tmp2033_;
		ValaCCodeExpression* _tmp2034_;
		ValaCCodeFunction* _tmp2035_;
		ValaCCodeFunction* _tmp2036_;
		ValaCCodeExpression* _tmp2037_;
		ValaCCodeFunction* _tmp2038_;
		ValaCCodeFunction* _tmp2039_;
		ValaCCodeBinaryExpression* _tmp2040_;
		ValaCCodeFunctionCall* _tmp2041_;
		ValaCCodeConstant* _tmp2042_;
		ValaCCodeConstant* _tmp2043_;
		ValaCCodeConditionalExpression* _tmp2044_;
		ValaCCodeConditionalExpression* _tmp2045_;
		ValaCCodeFunction* _tmp2046_;
		ValaCCodeFunction* _tmp2047_;
		ValaMemberAccess* _tmp2048_;
		ValaExpression* _tmp2049_;
		ValaExpression* _tmp2050_;
		ValaCCodeExpression* _tmp2051_;
		ValaCCodeExpression* _tmp2052_;
		ValaCCodeExpression* _tmp2053_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp2054_;
		ValaExpression* _tmp2055_;
		ValaExpression* _tmp2056_;
		ValaSymbol* _tmp2057_;
		ValaSymbol* _tmp2058_;
		ValaSymbol* _tmp2059_;
		gboolean _tmp2060_ = FALSE;
		gboolean _tmp2061_ = FALSE;
		ValaSymbol* _tmp2062_;
		_tmp1967_ = vala_method_call_get_argument_list (expr);
		_tmp1968_ = vala_iterable_iterator ((ValaIterable*) _tmp1967_);
		arg_it = _tmp1968_;
		_tmp1969_ = arg_it;
		vala_iterator_next (_tmp1969_);
		_tmp1970_ = arg_it;
		_tmp1971_ = vala_iterator_get (_tmp1970_);
		_tmp1972_ = (ValaExpression*) _tmp1971_;
		_tmp1973_ = vala_get_cvalue (_tmp1972_);
		_tmp1974_ = _vala_ccode_node_ref0 (_tmp1973_);
		_tmp1975_ = _tmp1974_;
		_vala_code_node_unref0 (_tmp1972_);
		new_size = _tmp1975_;
		_tmp1976_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1977_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1976_, TRUE, NULL, FALSE);
		temp_decl = _tmp1977_;
		_tmp1978_ = temp_decl;
		_tmp1979_ = vala_symbol_get_name ((ValaSymbol*) _tmp1978_);
		_tmp1980_ = _tmp1979_;
		_tmp1981_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1980_);
		temp_ref = _tmp1981_;
		_tmp1982_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1982_, FALSE);
		_tmp1983_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1983_, "string.h", FALSE);
		_tmp1984_ = ma;
		_tmp1985_ = vala_member_access_get_inner (_tmp1984_);
		_tmp1986_ = _tmp1985_;
		_tmp1987_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1986_, 1);
		clen = _tmp1987_;
		_tmp1988_ = ma;
		_tmp1989_ = vala_member_access_get_inner (_tmp1988_);
		_tmp1990_ = _tmp1989_;
		_tmp1991_ = vala_get_cvalue (_tmp1990_);
		_tmp1992_ = _vala_ccode_node_ref0 (_tmp1991_);
		celems = _tmp1992_;
		_tmp1993_ = ma;
		_tmp1994_ = vala_member_access_get_inner (_tmp1993_);
		_tmp1995_ = _tmp1994_;
		_tmp1996_ = vala_expression_get_value_type (_tmp1995_);
		_tmp1997_ = _tmp1996_;
		_tmp1998_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1997_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1998_;
		_tmp1999_ = array_type;
		_tmp2000_ = vala_array_type_get_element_type (_tmp1999_);
		_tmp2001_ = _tmp2000_;
		_tmp2002_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2001_);
		_tmp2003_ = _tmp2002_;
		_tmp2004_ = g_strdup_printf ("sizeof (%s)", _tmp2003_);
		_tmp2005_ = _tmp2004_;
		_tmp2006_ = vala_ccode_identifier_new (_tmp2005_);
		_tmp2007_ = _tmp2006_;
		_g_free0 (_tmp2005_);
		_g_free0 (_tmp2003_);
		csizeof = _tmp2007_;
		_tmp2008_ = temp_ref;
		_tmp2009_ = clen;
		_tmp2010_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp2008_, _tmp2009_);
		cdelta = _tmp2010_;
		_tmp2011_ = temp_ref;
		_tmp2012_ = clen;
		_tmp2013_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp2011_, _tmp2012_);
		ccheck = _tmp2013_;
		_tmp2014_ = vala_ccode_identifier_new ("memset");
		_tmp2015_ = _tmp2014_;
		_tmp2016_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2015_);
		_tmp2017_ = _tmp2016_;
		_vala_ccode_node_unref0 (_tmp2015_);
		czero = _tmp2017_;
		_tmp2018_ = czero;
		_tmp2019_ = celems;
		_tmp2020_ = clen;
		_tmp2021_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp2019_, _tmp2020_);
		_tmp2022_ = _tmp2021_;
		vala_ccode_function_call_add_argument (_tmp2018_, (ValaCCodeExpression*) _tmp2022_);
		_vala_ccode_node_unref0 (_tmp2022_);
		_tmp2023_ = czero;
		_tmp2024_ = vala_ccode_constant_new ("0");
		_tmp2025_ = _tmp2024_;
		vala_ccode_function_call_add_argument (_tmp2023_, (ValaCCodeExpression*) _tmp2025_);
		_vala_ccode_node_unref0 (_tmp2025_);
		_tmp2026_ = czero;
		_tmp2027_ = csizeof;
		_tmp2028_ = cdelta;
		_tmp2029_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp2027_, (ValaCCodeExpression*) _tmp2028_);
		_tmp2030_ = _tmp2029_;
		vala_ccode_function_call_add_argument (_tmp2026_, (ValaCCodeExpression*) _tmp2030_);
		_vala_ccode_node_unref0 (_tmp2030_);
		_tmp2031_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2032_ = _tmp2031_;
		_tmp2033_ = temp_ref;
		_tmp2034_ = new_size;
		vala_ccode_function_add_assignment (_tmp2032_, _tmp2033_, _tmp2034_);
		_tmp2035_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2036_ = _tmp2035_;
		_tmp2037_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp2036_, _tmp2037_);
		_tmp2038_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2039_ = _tmp2038_;
		_tmp2040_ = ccheck;
		_tmp2041_ = czero;
		_tmp2042_ = vala_ccode_constant_new ("NULL");
		_tmp2043_ = _tmp2042_;
		_tmp2044_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp2040_, (ValaCCodeExpression*) _tmp2041_, (ValaCCodeExpression*) _tmp2043_);
		_tmp2045_ = _tmp2044_;
		vala_ccode_function_add_expression (_tmp2039_, (ValaCCodeExpression*) _tmp2045_);
		_vala_ccode_node_unref0 (_tmp2045_);
		_vala_ccode_node_unref0 (_tmp2043_);
		_tmp2046_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2047_ = _tmp2046_;
		_tmp2048_ = ma;
		_tmp2049_ = vala_member_access_get_inner (_tmp2048_);
		_tmp2050_ = _tmp2049_;
		_tmp2051_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp2050_, 1);
		_tmp2052_ = _tmp2051_;
		_tmp2053_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp2047_, _tmp2052_, _tmp2053_);
		_vala_ccode_node_unref0 (_tmp2052_);
		_tmp2054_ = ma;
		_tmp2055_ = vala_member_access_get_inner (_tmp2054_);
		_tmp2056_ = _tmp2055_;
		_tmp2057_ = vala_expression_get_symbol_reference (_tmp2056_);
		_tmp2058_ = _tmp2057_;
		_tmp2059_ = _vala_code_node_ref0 (_tmp2058_);
		array_var = _tmp2059_;
		_tmp2062_ = array_var;
		if (_tmp2062_ != NULL) {
			ValaSymbol* _tmp2063_;
			_tmp2063_ = array_var;
			_tmp2061_ = vala_symbol_is_internal_symbol (_tmp2063_);
		} else {
			_tmp2061_ = FALSE;
		}
		if (_tmp2061_) {
			gboolean _tmp2064_ = FALSE;
			ValaSymbol* _tmp2065_;
			_tmp2065_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2065_, VALA_TYPE_LOCAL_VARIABLE)) {
				_tmp2064_ = TRUE;
			} else {
				ValaSymbol* _tmp2066_;
				_tmp2066_ = array_var;
				_tmp2064_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2066_, VALA_TYPE_FIELD);
			}
			_tmp2060_ = _tmp2064_;
		} else {
			_tmp2060_ = FALSE;
		}
		if (_tmp2060_) {
			ValaCCodeFunction* _tmp2067_;
			ValaCCodeFunction* _tmp2068_;
			ValaMemberAccess* _tmp2069_;
			ValaExpression* _tmp2070_;
			ValaExpression* _tmp2071_;
			ValaTargetValue* _tmp2072_;
			ValaTargetValue* _tmp2073_;
			ValaCCodeExpression* _tmp2074_;
			ValaCCodeExpression* _tmp2075_;
			_tmp2067_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp2068_ = _tmp2067_;
			_tmp2069_ = ma;
			_tmp2070_ = vala_member_access_get_inner (_tmp2069_);
			_tmp2071_ = _tmp2070_;
			_tmp2072_ = vala_expression_get_target_value (_tmp2071_);
			_tmp2073_ = _tmp2072_;
			_tmp2074_ = vala_get_array_size_cvalue (_tmp2073_);
			_tmp2075_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp2068_, _tmp2074_, _tmp2075_);
		}
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp2077_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp2078_ = _tmp2077_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2078_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp2079_;
		ValaDataType* _tmp2080_;
		_tmp2079_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp2080_ = _tmp2079_;
		_tmp2076_ = !vala_data_type_is_disposable (_tmp2080_);
	} else {
		_tmp2076_ = FALSE;
	}
	if (_tmp2076_) {
		gboolean _tmp2081_ = FALSE;
		ValaCCodeExpression* _tmp2082_;
		_tmp2082_ = ccall_expr;
		if (_tmp2082_ != NULL) {
			_tmp2081_ = !return_result_via_out_param;
		} else {
			_tmp2081_ = FALSE;
		}
		if (_tmp2081_) {
			ValaCCodeFunction* _tmp2083_;
			ValaCCodeFunction* _tmp2084_;
			ValaCCodeExpression* _tmp2085_;
			_tmp2083_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp2084_ = _tmp2083_;
			_tmp2085_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp2084_, _tmp2085_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp2086_;
		ValaDataType* _tmp2087_;
		ValaDataType* _tmp2088_;
		gboolean _tmp2089_ = FALSE;
		ValaDataType* _tmp2090_;
		ValaDataType* _tmp2091_;
		gboolean _tmp2144_ = FALSE;
		ValaMethod* _tmp2145_;
		_tmp2086_ = itype;
		_tmp2087_ = vala_data_type_get_return_type (_tmp2086_);
		_tmp2088_ = _vala_code_node_ref0 (_tmp2087_);
		result_type = _tmp2088_;
		_tmp2090_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp2091_ = _tmp2090_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2091_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp2092_;
			ValaDataType* _tmp2093_;
			_tmp2092_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp2093_ = _tmp2092_;
			_tmp2089_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp2093_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp2089_ = FALSE;
		}
		if (_tmp2089_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp2094_;
			ValaDataType* _tmp2095_;
			ValaTypeParameter* _tmp2096_;
			ValaTypeParameter* _tmp2097_;
			ValaTypeParameter* _tmp2098_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp2099_;
			ValaSymbol* _tmp2100_;
			ValaSymbol* _tmp2101_;
			ValaSymbol* _tmp2102_;
			ValaSymbol* _tmp2103_;
			ValaStruct* _tmp2104_;
			gboolean _tmp2105_ = FALSE;
			ValaTypeParameter* _tmp2106_;
			ValaSymbol* _tmp2107_;
			ValaSymbol* _tmp2108_;
			ValaTypeSymbol* _tmp2109_;
			gboolean _tmp2118_ = FALSE;
			gboolean _tmp2119_ = FALSE;
			ValaStruct* _tmp2120_;
			_tmp2094_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp2095_ = _tmp2094_;
			_tmp2096_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp2095_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp2097_ = _tmp2096_;
			_tmp2098_ = _vala_code_node_ref0 (_tmp2097_);
			type_parameter = _tmp2098_;
			_tmp2099_ = type_parameter;
			_tmp2100_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2099_);
			_tmp2101_ = _tmp2100_;
			_tmp2102_ = vala_symbol_get_parent_symbol (_tmp2101_);
			_tmp2103_ = _tmp2102_;
			_tmp2104_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2103_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp2103_) : NULL);
			st = _tmp2104_;
			_tmp2106_ = type_parameter;
			_tmp2107_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2106_);
			_tmp2108_ = _tmp2107_;
			_tmp2109_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp2108_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2109_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp2105_ = TRUE;
			} else {
				gboolean _tmp2110_ = FALSE;
				ValaStruct* _tmp2111_;
				_tmp2111_ = st;
				if (_tmp2111_ != NULL) {
					ValaStruct* _tmp2112_;
					gchar* _tmp2113_;
					gchar* _tmp2114_;
					_tmp2112_ = st;
					_tmp2113_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2112_);
					_tmp2114_ = _tmp2113_;
					_tmp2110_ = g_strcmp0 (_tmp2114_, "va_list") == 0;
					_g_free0 (_tmp2114_);
				} else {
					_tmp2110_ = FALSE;
				}
				_tmp2105_ = _tmp2110_;
			}
			if (_tmp2105_) {
				ValaDataType* _tmp2115_;
				ValaDataType* _tmp2116_;
				ValaDataType* _tmp2117_;
				_tmp2115_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp2116_ = _tmp2115_;
				_tmp2117_ = _vala_code_node_ref0 (_tmp2116_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp2117_;
			}
			_tmp2120_ = st;
			if (_tmp2120_ != NULL) {
				ValaStruct* _tmp2121_;
				gchar* _tmp2122_;
				gchar* _tmp2123_;
				_tmp2121_ = st;
				_tmp2122_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2121_);
				_tmp2123_ = _tmp2122_;
				_tmp2119_ = g_strcmp0 (_tmp2123_, "va_list") == 0;
				_g_free0 (_tmp2123_);
			} else {
				_tmp2119_ = FALSE;
			}
			if (_tmp2119_) {
				ValaMemberAccess* _tmp2124_;
				const gchar* _tmp2125_;
				const gchar* _tmp2126_;
				_tmp2124_ = ma;
				_tmp2125_ = vala_member_access_get_member_name (_tmp2124_);
				_tmp2126_ = _tmp2125_;
				_tmp2118_ = g_strcmp0 (_tmp2126_, "arg") == 0;
			} else {
				_tmp2118_ = FALSE;
			}
			if (_tmp2118_) {
				gboolean _tmp2127_ = FALSE;
				ValaDataType* _tmp2128_;
				_tmp2128_ = result_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2128_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDataType* _tmp2129_;
					ValaDelegate* _tmp2130_;
					ValaDelegate* _tmp2131_;
					gboolean _tmp2132_;
					gboolean _tmp2133_;
					_tmp2129_ = result_type;
					_tmp2130_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp2129_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp2131_ = _tmp2130_;
					_tmp2132_ = vala_delegate_get_has_target (_tmp2131_);
					_tmp2133_ = _tmp2132_;
					_tmp2127_ = _tmp2133_;
				} else {
					_tmp2127_ = FALSE;
				}
				if (_tmp2127_) {
					ValaGLibValue* arg_value = NULL;
					ValaTargetValue* _tmp2134_;
					ValaTargetValue* _tmp2135_;
					ValaGLibValue* _tmp2136_;
					ValaCCodeExpression* _tmp2137_;
					ValaGLibValue* _tmp2140_;
					ValaCCodeExpression* _tmp2141_;
					vala_set_cvalue ((ValaExpression*) expr, NULL);
					_tmp2134_ = vala_expression_get_target_value ((ValaExpression*) expr);
					_tmp2135_ = _tmp2134_;
					arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp2135_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
					_tmp2136_ = arg_value;
					_tmp2137_ = _tmp2136_->delegate_target_cvalue;
					if (_tmp2137_ == NULL) {
						ValaGLibValue* _tmp2138_;
						ValaCCodeConstant* _tmp2139_;
						_tmp2138_ = arg_value;
						_tmp2139_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2138_->delegate_target_cvalue);
						_tmp2138_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp2139_;
					}
					_tmp2140_ = arg_value;
					_tmp2141_ = _tmp2140_->delegate_target_destroy_notify_cvalue;
					if (_tmp2141_ == NULL) {
						ValaGLibValue* _tmp2142_;
						ValaCCodeConstant* _tmp2143_;
						_tmp2142_ = arg_value;
						_tmp2143_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2142_->delegate_target_destroy_notify_cvalue);
						_tmp2142_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp2143_;
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp2145_ = m;
		if (_tmp2145_ != NULL) {
			ValaMethod* _tmp2146_;
			_tmp2146_ = m;
			_tmp2144_ = vala_method_get_format_arg_index (_tmp2146_) >= 0;
		} else {
			_tmp2144_ = FALSE;
		}
		if (_tmp2144_) {
			ValaCCodeExpression* _tmp2147_;
			_tmp2147_ = ccall_expr;
			vala_set_cvalue ((ValaExpression*) expr, _tmp2147_);
		} else {
			gboolean _tmp2148_ = FALSE;
			ValaMethod* _tmp2149_;
			_tmp2149_ = m;
			if (_tmp2149_ != NULL) {
				ValaMethod* _tmp2150_;
				_tmp2150_ = m;
				_tmp2148_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp2150_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp2148_ = FALSE;
			}
			if (_tmp2148_) {
				ValaCCodeExpression* _tmp2151_;
				_tmp2151_ = ccall_expr;
				vala_set_cvalue ((ValaExpression*) expr, _tmp2151_);
			} else {
				gboolean _tmp2152_ = FALSE;
				gboolean _tmp2153_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp2153_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp2153_ = FALSE;
				}
				if (_tmp2153_) {
					gboolean _tmp2154_ = FALSE;
					ValaDataType* _tmp2155_;
					_tmp2155_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2155_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2156_;
						_tmp2156_ = result_type;
						_tmp2154_ = !vala_data_type_is_disposable (_tmp2156_);
					} else {
						_tmp2154_ = FALSE;
					}
					_tmp2152_ = _tmp2154_;
				} else {
					_tmp2152_ = FALSE;
				}
				if (_tmp2152_) {
					ValaCCodeExpression* _tmp2157_;
					_tmp2157_ = ccall_expr;
					vala_set_cvalue ((ValaExpression*) expr, _tmp2157_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2158_;
						ValaDataType* _tmp2159_;
						gboolean _tmp2160_;
						gboolean _tmp2161_;
						ValaLocalVariable* _tmp2162_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2163_;
						const gchar* _tmp2164_;
						const gchar* _tmp2165_;
						ValaCCodeExpression* _tmp2166_;
						ValaLocalVariable* _tmp2167_;
						ValaCCodeFunction* _tmp2168_;
						ValaCCodeFunction* _tmp2169_;
						ValaCCodeExpression* _tmp2170_;
						ValaCCodeExpression* _tmp2171_;
						ValaCCodeExpression* _tmp2172_;
						ValaTargetValue* _tmp2173_;
						ValaTargetValue* _tmp2174_;
						_tmp2158_ = result_type;
						_tmp2159_ = result_type;
						_tmp2160_ = vala_data_type_get_value_owned (_tmp2159_);
						_tmp2161_ = _tmp2160_;
						_tmp2162_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2158_, _tmp2161_, NULL, FALSE);
						temp_var = _tmp2162_;
						_tmp2163_ = temp_var;
						_tmp2164_ = vala_symbol_get_name ((ValaSymbol*) _tmp2163_);
						_tmp2165_ = _tmp2164_;
						_tmp2166_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2165_);
						temp_ref = _tmp2166_;
						_tmp2167_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2167_, FALSE);
						_tmp2168_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2169_ = _tmp2168_;
						_tmp2170_ = temp_ref;
						_tmp2171_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2169_, _tmp2170_, _tmp2171_);
						_tmp2172_ = temp_ref;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2172_);
						_tmp2173_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2174_ = _tmp2173_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2174_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2175_;
						ValaTargetValue* _tmp2176_;
						ValaTargetValue* _tmp2177_;
						_tmp2175_ = ccall_expr;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2175_);
						_tmp2176_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2177_ = _tmp2176_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2177_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2178_ = params;
	_tmp2179_ = vala_iterable_iterator ((ValaIterable*) _tmp2178_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2179_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2180_;
		ValaList* _tmp2181_;
		gint _arg_size = 0;
		ValaList* _tmp2182_;
		gint _tmp2183_;
		gint _tmp2184_;
		gint _arg_index = 0;
		_tmp2180_ = vala_method_call_get_argument_list (expr);
		_tmp2181_ = _vala_iterable_ref0 (_tmp2180_);
		_arg_list = _tmp2181_;
		_tmp2182_ = _arg_list;
		_tmp2183_ = vala_collection_get_size ((ValaCollection*) _tmp2182_);
		_tmp2184_ = _tmp2183_;
		_arg_size = _tmp2184_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp2185_;
			gint _tmp2186_;
			ValaExpression* arg = NULL;
			ValaList* _tmp2187_;
			gpointer _tmp2188_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2189_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2192_;
			ValaUnaryExpression* _tmp2193_;
			gboolean _tmp2194_ = FALSE;
			ValaUnaryExpression* _tmp2195_;
			gboolean _tmp2253_ = FALSE;
			ValaUnaryExpression* _tmp2254_;
			ValaUnaryExpression* _tmp2258_;
			ValaExpression* _tmp2259_;
			ValaExpression* _tmp2260_;
			ValaDataType* _tmp2261_;
			ValaDataType* _tmp2262_;
			gboolean _tmp2272_ = FALSE;
			ValaMemberAccess* _tmp2273_;
			ValaSymbol* _tmp2274_;
			ValaSymbol* _tmp2275_;
			ValaUnaryExpression* _tmp2291_;
			ValaExpression* _tmp2292_;
			ValaExpression* _tmp2293_;
			ValaTargetValue* _tmp2294_;
			ValaTargetValue* _tmp2295_;
			ValaUnaryExpression* _tmp2296_;
			ValaTargetValue* _tmp2297_;
			ValaTargetValue* _tmp2298_;
			ValaUnaryExpression* _tmp2299_;
			ValaExpression* _tmp2300_;
			ValaExpression* _tmp2301_;
			ValaDataType* _tmp2302_;
			ValaDataType* _tmp2303_;
			ValaExpression* _tmp2304_;
			ValaTargetValue* _tmp2305_;
			ValaTargetValue* _tmp2306_;
			ValaSourceReference* _tmp2307_;
			ValaSourceReference* _tmp2308_;
			gboolean _tmp2309_ = FALSE;
			ValaParameter* _tmp2310_;
			_arg_index = _arg_index + 1;
			_tmp2185_ = _arg_index;
			_tmp2186_ = _arg_size;
			if (!(_tmp2185_ < _tmp2186_)) {
				break;
			}
			_tmp2187_ = _arg_list;
			_tmp2188_ = vala_list_get (_tmp2187_, _arg_index);
			arg = (ValaExpression*) _tmp2188_;
			param = NULL;
			_tmp2189_ = params_it;
			if (vala_iterator_next (_tmp2189_)) {
				ValaIterator* _tmp2190_;
				gpointer _tmp2191_;
				_tmp2190_ = params_it;
				_tmp2191_ = vala_iterator_get (_tmp2190_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2191_;
			}
			_tmp2192_ = arg;
			_tmp2193_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2192_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2192_) : NULL);
			unary = _tmp2193_;
			_tmp2195_ = unary;
			if (_tmp2195_ != NULL) {
				ValaUnaryExpression* _tmp2196_;
				ValaUnaryOperator _tmp2197_;
				ValaUnaryOperator _tmp2198_;
				_tmp2196_ = unary;
				_tmp2197_ = vala_unary_expression_get_operator (_tmp2196_);
				_tmp2198_ = _tmp2197_;
				_tmp2194_ = _tmp2198_ == VALA_UNARY_OPERATOR_REF;
			} else {
				_tmp2194_ = FALSE;
			}
			if (_tmp2194_) {
				gboolean _tmp2199_ = FALSE;
				gboolean _tmp2200_ = FALSE;
				gboolean _tmp2201_ = FALSE;
				gboolean _tmp2202_ = FALSE;
				ValaParameter* _tmp2203_;
				_tmp2203_ = param;
				if (_tmp2203_ != NULL) {
					ValaParameter* _tmp2204_;
					_tmp2204_ = param;
					_tmp2202_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp2204_);
				} else {
					_tmp2202_ = FALSE;
				}
				if (_tmp2202_) {
					ValaParameter* _tmp2205_;
					ValaDataType* _tmp2206_;
					ValaDataType* _tmp2207_;
					_tmp2205_ = param;
					_tmp2206_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2205_);
					_tmp2207_ = _tmp2206_;
					_tmp2201_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2207_, VALA_TYPE_ARRAY_TYPE);
				} else {
					_tmp2201_ = FALSE;
				}
				if (_tmp2201_) {
					ValaParameter* _tmp2208_;
					ValaDataType* _tmp2209_;
					ValaDataType* _tmp2210_;
					gboolean _tmp2211_;
					gboolean _tmp2212_;
					_tmp2208_ = param;
					_tmp2209_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2208_);
					_tmp2210_ = _tmp2209_;
					_tmp2211_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2210_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2212_ = _tmp2211_;
					_tmp2200_ = !_tmp2212_;
				} else {
					_tmp2200_ = FALSE;
				}
				if (_tmp2200_) {
					ValaParameter* _tmp2213_;
					ValaDataType* _tmp2214_;
					ValaDataType* _tmp2215_;
					gint _tmp2216_;
					gint _tmp2217_;
					_tmp2213_ = param;
					_tmp2214_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2213_);
					_tmp2215_ = _tmp2214_;
					_tmp2216_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp2215_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2217_ = _tmp2216_;
					_tmp2199_ = _tmp2217_ == 1;
				} else {
					_tmp2199_ = FALSE;
				}
				if (_tmp2199_) {
					ValaVariable* array_var = NULL;
					ValaUnaryExpression* _tmp2218_;
					ValaExpression* _tmp2219_;
					ValaExpression* _tmp2220_;
					ValaSymbol* _tmp2221_;
					ValaSymbol* _tmp2222_;
					gboolean _tmp2223_ = FALSE;
					gboolean _tmp2224_ = FALSE;
					gboolean _tmp2225_ = FALSE;
					gboolean _tmp2226_ = FALSE;
					ValaVariable* _tmp2227_;
					_tmp2218_ = unary;
					_tmp2219_ = vala_unary_expression_get_inner (_tmp2218_);
					_tmp2220_ = _tmp2219_;
					_tmp2221_ = vala_expression_get_symbol_reference (_tmp2220_);
					_tmp2222_ = _tmp2221_;
					array_var = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2222_, VALA_TYPE_VARIABLE) ? ((ValaVariable*) _tmp2222_) : NULL;
					_tmp2227_ = array_var;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2227_, VALA_TYPE_LOCAL_VARIABLE)) {
						_tmp2226_ = TRUE;
					} else {
						ValaVariable* _tmp2228_;
						_tmp2228_ = array_var;
						_tmp2226_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2228_, VALA_TYPE_FIELD);
					}
					if (_tmp2226_) {
						ValaVariable* _tmp2229_;
						_tmp2229_ = array_var;
						_tmp2225_ = vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp2229_);
					} else {
						_tmp2225_ = FALSE;
					}
					if (_tmp2225_) {
						ValaVariable* _tmp2230_;
						ValaDataType* _tmp2231_;
						ValaDataType* _tmp2232_;
						_tmp2230_ = array_var;
						_tmp2231_ = vala_variable_get_variable_type (_tmp2230_);
						_tmp2232_ = _tmp2231_;
						_tmp2224_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2232_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp2224_ = FALSE;
					}
					if (_tmp2224_) {
						ValaVariable* _tmp2233_;
						ValaDataType* _tmp2234_;
						ValaDataType* _tmp2235_;
						gboolean _tmp2236_;
						gboolean _tmp2237_;
						_tmp2233_ = array_var;
						_tmp2234_ = vala_variable_get_variable_type (_tmp2233_);
						_tmp2235_ = _tmp2234_;
						_tmp2236_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2235_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp2237_ = _tmp2236_;
						_tmp2223_ = !_tmp2237_;
					} else {
						_tmp2223_ = FALSE;
					}
					if (_tmp2223_) {
						ValaCCodeFunction* _tmp2238_;
						ValaCCodeFunction* _tmp2239_;
						ValaUnaryExpression* _tmp2240_;
						ValaExpression* _tmp2241_;
						ValaExpression* _tmp2242_;
						ValaTargetValue* _tmp2243_;
						ValaTargetValue* _tmp2244_;
						ValaCCodeExpression* _tmp2245_;
						ValaUnaryExpression* _tmp2246_;
						ValaExpression* _tmp2247_;
						ValaExpression* _tmp2248_;
						ValaTargetValue* _tmp2249_;
						ValaTargetValue* _tmp2250_;
						ValaCCodeExpression* _tmp2251_;
						ValaCCodeExpression* _tmp2252_;
						_tmp2238_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2239_ = _tmp2238_;
						_tmp2240_ = unary;
						_tmp2241_ = vala_unary_expression_get_inner (_tmp2240_);
						_tmp2242_ = _tmp2241_;
						_tmp2243_ = vala_expression_get_target_value (_tmp2242_);
						_tmp2244_ = _tmp2243_;
						_tmp2245_ = vala_get_array_size_cvalue (_tmp2244_);
						_tmp2246_ = unary;
						_tmp2247_ = vala_unary_expression_get_inner (_tmp2246_);
						_tmp2248_ = _tmp2247_;
						_tmp2249_ = vala_expression_get_target_value (_tmp2248_);
						_tmp2250_ = _tmp2249_;
						_tmp2251_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2250_, 1);
						_tmp2252_ = _tmp2251_;
						vala_ccode_function_add_assignment (_tmp2239_, _tmp2245_, _tmp2252_);
						_vala_ccode_node_unref0 (_tmp2252_);
					}
				}
			}
			_tmp2254_ = unary;
			if (_tmp2254_ == NULL) {
				_tmp2253_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2255_;
				ValaUnaryOperator _tmp2256_;
				ValaUnaryOperator _tmp2257_;
				_tmp2255_ = unary;
				_tmp2256_ = vala_unary_expression_get_operator (_tmp2255_);
				_tmp2257_ = _tmp2256_;
				_tmp2253_ = _tmp2257_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2253_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2258_ = unary;
			_tmp2259_ = vala_unary_expression_get_inner (_tmp2258_);
			_tmp2260_ = _tmp2259_;
			_tmp2261_ = vala_expression_get_value_type (_tmp2260_);
			_tmp2262_ = _tmp2261_;
			if (vala_ccode_base_module_requires_destroy (_tmp2262_)) {
				ValaCCodeFunction* _tmp2263_;
				ValaCCodeFunction* _tmp2264_;
				ValaUnaryExpression* _tmp2265_;
				ValaExpression* _tmp2266_;
				ValaExpression* _tmp2267_;
				ValaTargetValue* _tmp2268_;
				ValaTargetValue* _tmp2269_;
				ValaCCodeExpression* _tmp2270_;
				ValaCCodeExpression* _tmp2271_;
				_tmp2263_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2264_ = _tmp2263_;
				_tmp2265_ = unary;
				_tmp2266_ = vala_unary_expression_get_inner (_tmp2265_);
				_tmp2267_ = _tmp2266_;
				_tmp2268_ = vala_expression_get_target_value (_tmp2267_);
				_tmp2269_ = _tmp2268_;
				_tmp2270_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2269_, FALSE);
				_tmp2271_ = _tmp2270_;
				vala_ccode_function_add_expression (_tmp2264_, _tmp2271_);
				_vala_ccode_node_unref0 (_tmp2271_);
			}
			_tmp2273_ = ma;
			_tmp2274_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2273_);
			_tmp2275_ = _tmp2274_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2275_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2276_;
				ValaTargetValue* _tmp2277_;
				ValaTargetValue* _tmp2278_;
				ValaDataType* _tmp2279_;
				ValaDataType* _tmp2280_;
				_tmp2276_ = unary;
				_tmp2277_ = vala_expression_get_target_value ((ValaExpression*) _tmp2276_);
				_tmp2278_ = _tmp2277_;
				_tmp2279_ = vala_target_value_get_value_type (_tmp2278_);
				_tmp2280_ = _tmp2279_;
				_tmp2272_ = _tmp2280_ == NULL;
			} else {
				_tmp2272_ = FALSE;
			}
			if (_tmp2272_) {
				ValaUnaryExpression* _tmp2281_;
				ValaTargetValue* _tmp2282_;
				ValaTargetValue* _tmp2283_;
				ValaUnaryExpression* _tmp2284_;
				ValaExpression* _tmp2285_;
				ValaExpression* _tmp2286_;
				ValaDataType* _tmp2287_;
				ValaDataType* _tmp2288_;
				ValaDataType* _tmp2289_;
				ValaDataType* _tmp2290_;
				_tmp2281_ = unary;
				_tmp2282_ = vala_expression_get_target_value ((ValaExpression*) _tmp2281_);
				_tmp2283_ = _tmp2282_;
				_tmp2284_ = unary;
				_tmp2285_ = vala_unary_expression_get_inner (_tmp2284_);
				_tmp2286_ = _tmp2285_;
				_tmp2287_ = vala_expression_get_value_type (_tmp2286_);
				_tmp2288_ = _tmp2287_;
				_tmp2289_ = vala_data_type_copy (_tmp2288_);
				_tmp2290_ = _tmp2289_;
				vala_target_value_set_value_type (_tmp2283_, _tmp2290_);
				_vala_code_node_unref0 (_tmp2290_);
			}
			_tmp2291_ = unary;
			_tmp2292_ = vala_unary_expression_get_inner (_tmp2291_);
			_tmp2293_ = _tmp2292_;
			_tmp2294_ = vala_expression_get_target_value (_tmp2293_);
			_tmp2295_ = _tmp2294_;
			_tmp2296_ = unary;
			_tmp2297_ = vala_expression_get_target_value ((ValaExpression*) _tmp2296_);
			_tmp2298_ = _tmp2297_;
			_tmp2299_ = unary;
			_tmp2300_ = vala_unary_expression_get_inner (_tmp2299_);
			_tmp2301_ = _tmp2300_;
			_tmp2302_ = vala_expression_get_value_type (_tmp2301_);
			_tmp2303_ = _tmp2302_;
			_tmp2304_ = arg;
			_tmp2305_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2298_, _tmp2303_, (ValaCodeNode*) _tmp2304_);
			_tmp2306_ = _tmp2305_;
			_tmp2307_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2308_ = _tmp2307_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2295_, _tmp2306_, _tmp2308_);
			_vala_target_value_unref0 (_tmp2306_);
			_tmp2310_ = param;
			if (_tmp2310_ != NULL) {
				ValaParameter* _tmp2311_;
				_tmp2311_ = param;
				_tmp2309_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2311_);
			} else {
				_tmp2309_ = FALSE;
			}
			if (_tmp2309_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2312_;
				ValaCCodeIdentifier* _tmp2313_;
				ValaCCodeFunctionCall* _tmp2314_;
				ValaCCodeFunctionCall* _tmp2315_;
				ValaCCodeFunctionCall* _tmp2316_;
				ValaUnaryExpression* _tmp2317_;
				ValaExpression* _tmp2318_;
				ValaExpression* _tmp2319_;
				ValaTargetValue* _tmp2320_;
				ValaTargetValue* _tmp2321_;
				ValaCCodeExpression* _tmp2322_;
				ValaCCodeFunction* _tmp2323_;
				ValaCCodeFunction* _tmp2324_;
				ValaUnaryExpression* _tmp2325_;
				ValaExpression* _tmp2326_;
				ValaExpression* _tmp2327_;
				ValaTargetValue* _tmp2328_;
				ValaTargetValue* _tmp2329_;
				ValaCCodeExpression* _tmp2330_;
				ValaCCodeExpression* _tmp2331_;
				ValaCCodeFunctionCall* _tmp2332_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2312_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2313_ = _tmp2312_;
				_tmp2314_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2313_);
				_tmp2315_ = _tmp2314_;
				_vala_ccode_node_unref0 (_tmp2313_);
				len_call = _tmp2315_;
				_tmp2316_ = len_call;
				_tmp2317_ = unary;
				_tmp2318_ = vala_unary_expression_get_inner (_tmp2317_);
				_tmp2319_ = _tmp2318_;
				_tmp2320_ = vala_expression_get_target_value (_tmp2319_);
				_tmp2321_ = _tmp2320_;
				_tmp2322_ = vala_get_cvalue_ (_tmp2321_);
				vala_ccode_function_call_add_argument (_tmp2316_, _tmp2322_);
				_tmp2323_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2324_ = _tmp2323_;
				_tmp2325_ = unary;
				_tmp2326_ = vala_unary_expression_get_inner (_tmp2325_);
				_tmp2327_ = _tmp2326_;
				_tmp2328_ = vala_expression_get_target_value (_tmp2327_);
				_tmp2329_ = _tmp2328_;
				_tmp2330_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2329_, 1);
				_tmp2331_ = _tmp2330_;
				_tmp2332_ = len_call;
				vala_ccode_function_add_assignment (_tmp2324_, _tmp2331_, (ValaCCodeExpression*) _tmp2332_);
				_vala_ccode_node_unref0 (_tmp2331_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2335_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2335_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2336_;
		ValaSymbol* _tmp2337_;
		ValaSymbol* _tmp2338_;
		_tmp2336_ = m;
		_tmp2337_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2336_);
		_tmp2338_ = _tmp2337_;
		_tmp2334_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2338_, VALA_TYPE_CLASS);
	} else {
		_tmp2334_ = FALSE;
	}
	if (_tmp2334_) {
		gboolean _tmp2339_ = FALSE;
		gboolean _tmp2340_ = FALSE;
		ValaClass* _tmp2341_;
		ValaClass* _tmp2342_;
		gboolean _tmp2343_;
		gboolean _tmp2344_;
		_tmp2341_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2342_ = _tmp2341_;
		_tmp2343_ = vala_class_get_is_compact (_tmp2342_);
		_tmp2344_ = _tmp2343_;
		if (_tmp2344_) {
			ValaClass* _tmp2345_;
			ValaClass* _tmp2346_;
			ValaClass* _tmp2347_;
			ValaClass* _tmp2348_;
			_tmp2345_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2346_ = _tmp2345_;
			_tmp2347_ = vala_class_get_base_class (_tmp2346_);
			_tmp2348_ = _tmp2347_;
			_tmp2340_ = _tmp2348_ != NULL;
		} else {
			_tmp2340_ = FALSE;
		}
		if (_tmp2340_) {
			_tmp2339_ = TRUE;
		} else {
			ValaClass* _tmp2349_;
			ValaClass* _tmp2350_;
			ValaClass* _tmp2351_;
			ValaClass* _tmp2352_;
			ValaClass* _tmp2353_;
			_tmp2349_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2350_ = _tmp2349_;
			_tmp2351_ = vala_class_get_base_class (_tmp2350_);
			_tmp2352_ = _tmp2351_;
			_tmp2353_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2339_ = _tmp2352_ == _tmp2353_;
		}
		_tmp2333_ = _tmp2339_;
	} else {
		_tmp2333_ = FALSE;
	}
	if (_tmp2333_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2354_;
		ValaClass* _tmp2355_;
		gchar* _tmp2356_;
		gchar* _tmp2357_;
		gchar* _tmp2358_;
		gchar* _tmp2359_;
		ValaCCodeIdentifier* _tmp2360_;
		ValaCCodeIdentifier* _tmp2361_;
		ValaCCodeFunctionCall* _tmp2362_;
		ValaCCodeFunctionCall* _tmp2363_;
		ValaCCodeFunctionCall* _tmp2364_;
		ValaCCodeExpression* _tmp2365_;
		ValaCCodeExpression* _tmp2366_;
		ValaClass* _tmp2367_;
		ValaClass* _tmp2368_;
		gboolean _tmp2369_;
		gboolean _tmp2370_;
		ValaCCodeFunction* _tmp2374_;
		ValaCCodeFunction* _tmp2375_;
		ValaCCodeFunctionCall* _tmp2376_;
		_tmp2354_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2355_ = _tmp2354_;
		_tmp2356_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2355_, NULL);
		_tmp2357_ = _tmp2356_;
		_tmp2358_ = g_strdup_printf ("%s_instance_init", _tmp2357_);
		_tmp2359_ = _tmp2358_;
		_tmp2360_ = vala_ccode_identifier_new (_tmp2359_);
		_tmp2361_ = _tmp2360_;
		_tmp2362_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2361_);
		_tmp2363_ = _tmp2362_;
		_vala_ccode_node_unref0 (_tmp2361_);
		_g_free0 (_tmp2359_);
		_g_free0 (_tmp2357_);
		cinitcall = _tmp2363_;
		_tmp2364_ = cinitcall;
		_tmp2365_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2366_ = _tmp2365_;
		vala_ccode_function_call_add_argument (_tmp2364_, _tmp2366_);
		_vala_ccode_node_unref0 (_tmp2366_);
		_tmp2367_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2368_ = _tmp2367_;
		_tmp2369_ = vala_class_get_is_compact (_tmp2368_);
		_tmp2370_ = _tmp2369_;
		if (!_tmp2370_) {
			ValaCCodeFunctionCall* _tmp2371_;
			ValaCCodeConstant* _tmp2372_;
			ValaCCodeConstant* _tmp2373_;
			_tmp2371_ = cinitcall;
			_tmp2372_ = vala_ccode_constant_new ("NULL");
			_tmp2373_ = _tmp2372_;
			vala_ccode_function_call_add_argument (_tmp2371_, (ValaCCodeExpression*) _tmp2373_);
			_vala_ccode_node_unref0 (_tmp2373_);
		}
		_tmp2374_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2375_ = _tmp2374_;
		_tmp2376_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2375_, (ValaCCodeExpression*) _tmp2376_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeFile* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	ValaCCodeFile* _tmp55_;
	ValaCCodeFunction* _tmp56_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _enum_value_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_enum_value_list = _tmp21_;
		_tmp22_ = _enum_value_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_enum_value_size = _tmp24_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp27_;
			gpointer _tmp28_;
			ValaCCodeFunction* _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaEnumValue* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeFunction* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaEnumValue* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			ValaCCodeConstant* _tmp45_;
			ValaCCodeConstant* _tmp46_;
			_enum_value_index = _enum_value_index + 1;
			_tmp25_ = _enum_value_index;
			_tmp26_ = _enum_value_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _enum_value_list;
			_tmp28_ = vala_list_get (_tmp27_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp28_;
			_tmp29_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp30_ = _tmp29_;
			_tmp31_ = enum_value;
			_tmp32_ = vala_get_ccode_name ((ValaCodeNode*) _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_ccode_identifier_new (_tmp33_);
			_tmp35_ = _tmp34_;
			vala_ccode_function_add_case (_tmp30_, (ValaCCodeExpression*) _tmp35_);
			_vala_ccode_node_unref0 (_tmp35_);
			_g_free0 (_tmp33_);
			_tmp36_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = enum_value;
			_tmp39_ = vala_get_ccode_name ((ValaCodeNode*) _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat ("\"", _tmp40_, NULL);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat (_tmp42_, "\"", NULL);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_ccode_constant_new (_tmp44_);
			_tmp46_ = _tmp45_;
			vala_ccode_function_add_return (_tmp37_, (ValaCCodeExpression*) _tmp46_);
			_vala_ccode_node_unref0 (_tmp46_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp47_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp48_ = _tmp47_;
	vala_ccode_function_close (_tmp48_);
	_tmp49_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_ccode_constant_new ("NULL");
	_tmp52_ = _tmp51_;
	vala_ccode_function_add_return (_tmp50_, (ValaCCodeExpression*) _tmp52_);
	_vala_ccode_node_unref0 (_tmp52_);
	_tmp53_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp54_ = function;
	vala_ccode_file_add_function_declaration (_tmp53_, _tmp54_);
	_tmp55_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp56_ = function;
	vala_ccode_file_add_function (_tmp55_, _tmp56_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp9_;
			gboolean _tmp10_ = FALSE;
			ValaUnaryExpression* _tmp11_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp9_) : NULL;
			_tmp11_ = unary;
			if (_tmp11_ != NULL) {
				gboolean _tmp12_ = FALSE;
				ValaUnaryExpression* _tmp13_;
				ValaUnaryOperator _tmp14_;
				ValaUnaryOperator _tmp15_;
				_tmp13_ = unary;
				_tmp14_ = vala_unary_expression_get_operator (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp12_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp16_;
					ValaUnaryOperator _tmp17_;
					ValaUnaryOperator _tmp18_;
					_tmp16_ = unary;
					_tmp17_ = vala_unary_expression_get_operator (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp10_ = _tmp12_;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaProfile _tmp39_;
	ValaProfile _tmp40_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeConstant* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeFunctionCall* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeIdentifier* _tmp60_;
	ValaCCodeIdentifier* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeConstant* _tmp63_;
	ValaCCodeConstant* _tmp64_;
	ValaCCodeBinaryExpression* _tmp65_;
	ValaCCodeBinaryExpression* _tmp66_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunctionCall* _tmp69_;
	ValaCCodeFunctionCall* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunction* _tmp74_;
	ValaCCodeFunction* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeFunctionCall* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeIdentifier* _tmp83_;
	ValaCCodeFunction* _tmp84_;
	ValaCCodeFunction* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeFunctionCall* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeIdentifier* _tmp90_;
	ValaCCodeFunctionCall* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunction* _tmp98_;
	ValaCCodeFunction* _tmp99_;
	ValaCCodeFunctionCall* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeFunctionCall* _tmp103_;
	ValaCCodeFunctionCall* _tmp104_;
	ValaCCodeIdentifier* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeIdentifier* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeFunctionCall* _tmp110_;
	ValaCCodeIdentifier* _tmp111_;
	ValaCCodeIdentifier* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunction* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	ValaCCodeFunctionCall* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeFunctionCall* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeFunction* _tmp125_;
	ValaCCodeFunction* _tmp126_;
	ValaCCodeFunctionCall* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeIdentifier* _tmp131_;
	ValaCCodeFile* _tmp132_;
	ValaCCodeFile* _tmp133_;
	ValaCCodeFunction* _tmp134_;
	ValaCCodeFile* _tmp135_;
	ValaCCodeFunction* _tmp136_;
	gchar* _tmp137_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_code_context_get_profile (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PROFILE_POSIX) {
		ValaCCodeFile* _tmp41_;
		_tmp41_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp41_, "stdio.h", FALSE);
	}
	_tmp42_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	vsnprintf = _tmp45_;
	_tmp46_ = vsnprintf;
	_tmp47_ = vala_ccode_constant_new ("NULL");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = vsnprintf;
	_tmp50_ = vala_ccode_constant_new ("0");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vsnprintf;
	_tmp53_ = vala_ccode_identifier_new ("format");
	_tmp54_ = _tmp53_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp54_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp55_ = vsnprintf;
	_tmp56_ = vala_ccode_identifier_new ("ap");
	_tmp57_ = _tmp56_;
	vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp57_);
	_vala_ccode_node_unref0 (_tmp57_);
	_tmp58_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_identifier_new ("length");
	_tmp61_ = _tmp60_;
	_tmp62_ = vsnprintf;
	_tmp63_ = vala_ccode_constant_new ("1");
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp62_, (ValaCCodeExpression*) _tmp64_);
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_assignment (_tmp59_, (ValaCCodeExpression*) _tmp61_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	_vala_ccode_node_unref0 (_tmp64_);
	_vala_ccode_node_unref0 (_tmp61_);
	_tmp67_ = vala_ccode_identifier_new ("va_end");
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp68_);
	_tmp70_ = _tmp69_;
	_vala_ccode_node_unref0 (_tmp68_);
	va_end = _tmp70_;
	_tmp71_ = va_end;
	_tmp72_ = vala_ccode_identifier_new ("ap");
	_tmp73_ = _tmp72_;
	vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
	_vala_ccode_node_unref0 (_tmp73_);
	_tmp74_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = va_end;
	vala_ccode_function_add_expression (_tmp75_, (ValaCCodeExpression*) _tmp76_);
	_tmp77_ = vala_ccode_identifier_new ("malloc");
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp78_);
	_tmp80_ = _tmp79_;
	_vala_ccode_node_unref0 (_tmp78_);
	malloc = _tmp80_;
	_tmp81_ = malloc;
	_tmp82_ = vala_ccode_identifier_new ("length");
	_tmp83_ = _tmp82_;
	vala_ccode_function_call_add_argument (_tmp81_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp83_);
	_tmp84_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_identifier_new ("result");
	_tmp87_ = _tmp86_;
	_tmp88_ = malloc;
	vala_ccode_function_add_assignment (_tmp85_, (ValaCCodeExpression*) _tmp87_, (ValaCCodeExpression*) _tmp88_);
	_vala_ccode_node_unref0 (_tmp87_);
	_tmp89_ = vala_ccode_identifier_new ("va_start");
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp90_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp91_;
	_vala_ccode_node_unref0 (_tmp90_);
	_tmp92_ = va_start;
	_tmp93_ = vala_ccode_identifier_new ("ap");
	_tmp94_ = _tmp93_;
	vala_ccode_function_call_add_argument (_tmp92_, (ValaCCodeExpression*) _tmp94_);
	_vala_ccode_node_unref0 (_tmp94_);
	_tmp95_ = va_start;
	_tmp96_ = vala_ccode_identifier_new ("format");
	_tmp97_ = _tmp96_;
	vala_ccode_function_call_add_argument (_tmp95_, (ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp98_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = va_start;
	vala_ccode_function_add_expression (_tmp99_, (ValaCCodeExpression*) _tmp100_);
	_tmp101_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp103_;
	_vala_ccode_node_unref0 (_tmp102_);
	_tmp104_ = vsnprintf;
	_tmp105_ = vala_ccode_identifier_new ("result");
	_tmp106_ = _tmp105_;
	vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp106_);
	_vala_ccode_node_unref0 (_tmp106_);
	_tmp107_ = vsnprintf;
	_tmp108_ = vala_ccode_identifier_new ("length");
	_tmp109_ = _tmp108_;
	vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp109_);
	_vala_ccode_node_unref0 (_tmp109_);
	_tmp110_ = vsnprintf;
	_tmp111_ = vala_ccode_identifier_new ("format");
	_tmp112_ = _tmp111_;
	vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp112_);
	_vala_ccode_node_unref0 (_tmp112_);
	_tmp113_ = vsnprintf;
	_tmp114_ = vala_ccode_identifier_new ("ap");
	_tmp115_ = _tmp114_;
	vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp117_, (ValaCCodeExpression*) _tmp118_);
	_tmp119_ = vala_ccode_identifier_new ("va_end");
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp120_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp121_;
	_vala_ccode_node_unref0 (_tmp120_);
	_tmp122_ = va_end;
	_tmp123_ = vala_ccode_identifier_new ("ap");
	_tmp124_ = _tmp123_;
	vala_ccode_function_call_add_argument (_tmp122_, (ValaCCodeExpression*) _tmp124_);
	_vala_ccode_node_unref0 (_tmp124_);
	_tmp125_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp126_ = _tmp125_;
	_tmp127_ = va_end;
	vala_ccode_function_add_expression (_tmp126_, (ValaCCodeExpression*) _tmp127_);
	_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_ccode_identifier_new ("result");
	_tmp131_ = _tmp130_;
	vala_ccode_function_add_return (_tmp129_, (ValaCCodeExpression*) _tmp131_);
	_vala_ccode_node_unref0 (_tmp131_);
	_tmp132_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp132_, "stdarg.h", FALSE);
	_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp134_ = function;
	vala_ccode_file_add_function_declaration (_tmp133_, _tmp134_);
	_tmp135_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp136_ = function;
	vala_ccode_file_add_function (_tmp135_, _tmp136_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp137_ = g_strdup ("string_printf");
	result = _tmp137_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

static GType
vala_ccode_method_call_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
	GType vala_ccode_method_call_module_type_id;
	vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	return vala_ccode_method_call_module_type_id;
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = vala_ccode_method_call_module_get_type_once ();
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

