/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <glib.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static GType vala_ccode_method_call_module_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	ValaDataType* _tmp15_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp166_;
	GEqualFunc _tmp167_;
	GEqualFunc _tmp168_;
	ValaHashMap* _tmp169_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp170_;
	ValaHashMap* _tmp171_;
	gboolean _tmp172_ = FALSE;
	ValaMethod* _tmp173_;
	gboolean _tmp417_ = FALSE;
	ValaMethod* _tmp418_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp610_;
	ValaCCodeExpression* _tmp611_;
	gboolean _tmp612_ = FALSE;
	ValaMethod* _tmp613_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp641_ = FALSE;
	ValaMethod* _tmp642_;
	gboolean _tmp805_ = FALSE;
	ValaMethod* _tmp806_;
	ValaMethod* _tmp860_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp1054_;
	ValaIterator* _tmp1055_;
	ValaIterator* _tmp1476_;
	gboolean _tmp1486_ = FALSE;
	gboolean _tmp1487_ = FALSE;
	ValaMethod* _tmp1488_;
	gboolean _tmp1609_ = FALSE;
	ValaDelegate* _tmp1610_;
	gboolean _tmp1706_ = FALSE;
	ValaMethod* _tmp1707_;
	gboolean _tmp1723_;
	gboolean _tmp1724_;
	gboolean _tmp1767_ = FALSE;
	ValaDelegate* _tmp1768_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1786_;
	ValaDataType* _tmp1787_;
	gboolean _tmp1788_ = FALSE;
	ValaDataType* _tmp1789_;
	ValaCCodeFunctionCall* _tmp1817_;
	ValaCCodeFunctionCall* _tmp1818_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1831_;
	ValaCCodeFunctionCall* _tmp1832_;
	ValaCCodeFunctionCall* _tmp1847_;
	gboolean _tmp1862_;
	gboolean _tmp1863_;
	gboolean _tmp1887_;
	gboolean _tmp1888_;
	gboolean _tmp1923_ = FALSE;
	gboolean _tmp1924_ = FALSE;
	ValaMethod* _tmp1925_;
	gboolean _tmp1963_ = FALSE;
	gboolean _tmp1964_ = FALSE;
	gboolean _tmp1965_ = FALSE;
	gboolean _tmp1966_ = FALSE;
	gboolean _tmp1967_ = FALSE;
	ValaMethod* _tmp1968_;
	gboolean _tmp1985_ = FALSE;
	gboolean _tmp1986_ = FALSE;
	ValaMethod* _tmp1987_;
	ValaMethod* _tmp2006_;
	gboolean _tmp2116_ = FALSE;
	ValaCodeNode* _tmp2117_;
	ValaCodeNode* _tmp2118_;
	ValaList* _tmp2218_;
	ValaIterator* _tmp2219_;
	gboolean _tmp2373_ = FALSE;
	gboolean _tmp2374_ = FALSE;
	ValaMethod* _tmp2375_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_get_cvalue (_tmp1_);
	_tmp3_ = vala_ccode_function_call_new (_tmp2_);
	ccall = _tmp3_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp4_ = vala_method_call_get_call (expr);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp5_) : NULL);
	ma = _tmp6_;
	_tmp7_ = vala_method_call_get_call (expr);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_expression_get_value_type (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (_tmp10_);
	itype = _tmp11_;
	_tmp12_ = itype;
	_tmp13_ = vala_data_type_get_parameters (_tmp12_);
	_tmp14_ = _vala_iterable_ref0 (_tmp13_);
	_vala_iterable_unref0 (params);
	params = _tmp14_;
	_tmp15_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp16_;
		ValaDataType* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		ValaMemberAccess* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp16_ = ma;
		_vala_assert (_tmp16_ != NULL, "ma != null");
		_tmp17_ = itype;
		_tmp18_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp19_ = _tmp18_;
		_tmp20_ = _vala_code_node_ref0 (_tmp19_);
		_vala_code_node_unref0 (m);
		m = _tmp20_;
		_tmp21_ = m;
		if (!vala_get_ccode_simple_generics (_tmp21_)) {
			ValaCodeContext* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaSemanticAnalyzer* _tmp24_;
			ValaSemanticAnalyzer* _tmp25_;
			ValaMemberAccess* _tmp26_;
			_tmp22_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_code_context_get_analyzer (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = ma;
			vala_semantic_analyzer_check_type_arguments (_tmp25_, _tmp26_);
		}
		_tmp29_ = ma;
		_tmp30_ = vala_member_access_get_inner (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaMemberAccess* _tmp32_;
			ValaExpression* _tmp33_;
			ValaExpression* _tmp34_;
			ValaDataType* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp32_ = ma;
			_tmp33_ = vala_member_access_get_inner (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_expression_get_value_type (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp28_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaMemberAccess* _tmp37_;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			ValaDataType* _tmp40_;
			ValaDataType* _tmp41_;
			ValaMethod* _tmp42_;
			ValaMethod* _tmp43_;
			_tmp37_ = ma;
			_tmp38_ = vala_member_access_get_inner (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_expression_get_value_type (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp43_ = m;
			_tmp27_ = _tmp42_ == _tmp43_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp44_;
			ValaExpression* _tmp45_;
			ValaExpression* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			ValaTypeSymbol* _tmp49_;
			ValaTypeSymbol* _tmp50_;
			ValaCCodeFunctionCall* _tmp51_;
			ValaEnum* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			ValaCCodeIdentifier* _tmp56_;
			_tmp44_ = ma;
			_tmp45_ = vala_member_access_get_inner (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_expression_get_value_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_data_type_get_type_symbol (_tmp48_);
			_tmp50_ = _tmp49_;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_ENUM, ValaEnum);
			_tmp51_ = ccall;
			_tmp52_ = en;
			_tmp53_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_ccode_identifier_new (_tmp54_);
			_tmp56_ = _tmp55_;
			vala_ccode_function_call_set_call (_tmp51_, (ValaCCodeExpression*) _tmp56_);
			_vala_ccode_node_unref0 (_tmp56_);
			_g_free0 (_tmp54_);
		} else {
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			gboolean _tmp60_ = FALSE;
			ValaCodeContext* _tmp61_;
			ValaCodeContext* _tmp62_;
			ValaProfile _tmp63_;
			ValaProfile _tmp64_;
			_tmp61_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_code_context_get_profile (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp65_;
				ValaExpression* _tmp66_;
				ValaExpression* _tmp67_;
				_tmp65_ = ma;
				_tmp66_ = vala_member_access_get_inner (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp60_ = _tmp67_ != NULL;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaMemberAccess* _tmp68_;
				ValaExpression* _tmp69_;
				ValaExpression* _tmp70_;
				ValaDataType* _tmp71_;
				ValaDataType* _tmp72_;
				_tmp68_ = ma;
				_tmp69_ = vala_member_access_get_inner (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_expression_get_value_type (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp59_ = _tmp72_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp73_;
				ValaExpression* _tmp74_;
				ValaExpression* _tmp75_;
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaTypeSymbol* _tmp79_;
				ValaDataType* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				ValaTypeSymbol* _tmp82_;
				_tmp73_ = ma;
				_tmp74_ = vala_member_access_get_inner (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_expression_get_value_type (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_data_type_get_type_symbol (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp81_ = vala_data_type_get_type_symbol (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp58_ = _tmp79_ == _tmp82_;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp83_;
				const gchar* _tmp84_;
				const gchar* _tmp85_;
				_tmp83_ = ma;
				_tmp84_ = vala_member_access_get_member_name (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp57_ = g_strcmp0 (_tmp85_, "printf") == 0;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				ValaCCodeIdentifier* _tmp90_;
				_tmp86_ = ccall;
				_tmp87_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_ccode_identifier_new (_tmp88_);
				_tmp90_ = _tmp89_;
				vala_ccode_function_call_set_call (_tmp86_, (ValaCCodeExpression*) _tmp90_);
				_vala_ccode_node_unref0 (_tmp90_);
				_g_free0 (_tmp88_);
			} else {
				gboolean _tmp91_;
				gboolean _tmp92_;
				_tmp91_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp92_ = _tmp91_;
				if (_tmp92_) {
					ValaCCodeFunctionCall* _tmp93_;
					ValaMethod* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					ValaCCodeIdentifier* _tmp98_;
					_tmp93_ = ccall;
					_tmp94_ = m;
					_tmp95_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_ccode_identifier_new (_tmp96_);
					_tmp98_ = _tmp97_;
					vala_ccode_function_call_set_call (_tmp93_, (ValaCCodeExpression*) _tmp98_);
					_vala_ccode_node_unref0 (_tmp98_);
					_g_free0 (_tmp96_);
				}
			}
		}
	} else {
		ValaDataType* _tmp99_;
		_tmp99_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp100_;
			ValaSignalType* _tmp101_;
			gboolean _tmp102_ = FALSE;
			gboolean _tmp103_ = FALSE;
			ValaMemberAccess* _tmp104_;
			_tmp100_ = itype;
			_tmp101_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp101_;
			_tmp104_ = ma;
			if (_tmp104_ != NULL) {
				ValaMemberAccess* _tmp105_;
				ValaExpression* _tmp106_;
				ValaExpression* _tmp107_;
				_tmp105_ = ma;
				_tmp106_ = vala_member_access_get_inner (_tmp105_);
				_tmp107_ = _tmp106_;
				_tmp103_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp103_ = FALSE;
			}
			if (_tmp103_) {
				ValaSignalType* _tmp108_;
				ValaSignal* _tmp109_;
				ValaSignal* _tmp110_;
				gboolean _tmp111_;
				gboolean _tmp112_;
				_tmp108_ = sig_type;
				_tmp109_ = vala_signal_type_get_signal_symbol (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = vala_signal_get_is_virtual (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp102_ = _tmp112_;
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp113_;
				ValaSignal* _tmp114_;
				ValaSignal* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				ValaMethod* _tmp118_;
				_tmp113_ = sig_type;
				_tmp114_ = vala_signal_type_get_signal_symbol (_tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = vala_signal_get_default_handler (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = _vala_code_node_ref0 (_tmp117_);
				_vala_code_node_unref0 (m);
				m = _tmp118_;
			} else {
				ValaExpression* _tmp119_;
				ValaExpression* _tmp120_;
				ValaCCodeExpression* _tmp121_;
				ValaCCodeFunctionCall* _tmp122_;
				_tmp119_ = vala_method_call_get_call (expr);
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_get_cvalue (_tmp120_);
				_tmp122_ = _vala_ccode_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall));
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp122_;
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp123_;
			_tmp123_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp123_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp124_;
				ValaTypeSymbol* _tmp125_;
				ValaTypeSymbol* _tmp126_;
				ValaClass* _tmp127_;
				ValaClass* _tmp128_;
				ValaCreationMethod* _tmp129_;
				ValaCreationMethod* _tmp130_;
				ValaMethod* _tmp131_;
				ValaMethod* _tmp132_;
				ValaCCodeFile* _tmp133_;
				gchar* real_name = NULL;
				ValaMethod* _tmp134_;
				gchar* _tmp135_;
				gboolean _tmp136_;
				gboolean _tmp137_;
				const gchar* _tmp140_;
				ValaCCodeIdentifier* _tmp141_;
				ValaCCodeIdentifier* _tmp142_;
				ValaCCodeFunctionCall* _tmp143_;
				_tmp124_ = itype;
				_tmp125_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp126_ = _tmp125_;
				_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp127_;
				_tmp128_ = cl;
				_tmp129_ = vala_class_get_default_construction_method (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = _vala_code_node_ref0 ((ValaMethod*) _tmp130_);
				_vala_code_node_unref0 (m);
				m = _tmp131_;
				_tmp132_ = m;
				_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp132_, _tmp133_);
				_tmp134_ = m;
				_tmp135_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp134_);
				real_name = _tmp135_;
				_tmp136_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp137_ = _tmp136_;
				if (_tmp137_) {
					ValaMethod* _tmp138_;
					gchar* _tmp139_;
					_tmp138_ = m;
					_tmp139_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp139_;
				}
				_tmp140_ = real_name;
				_tmp141_ = vala_ccode_identifier_new (_tmp140_);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp142_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp143_;
				_vala_ccode_node_unref0 (_tmp142_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp144_;
				_tmp144_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp145_;
					ValaTypeSymbol* _tmp146_;
					ValaTypeSymbol* _tmp147_;
					ValaStruct* _tmp148_;
					ValaStruct* _tmp149_;
					ValaCreationMethod* _tmp150_;
					ValaCreationMethod* _tmp151_;
					ValaMethod* _tmp152_;
					ValaMethod* _tmp153_;
					ValaCCodeFile* _tmp154_;
					ValaMethod* _tmp155_;
					gchar* _tmp156_;
					gchar* _tmp157_;
					ValaCCodeIdentifier* _tmp158_;
					ValaCCodeIdentifier* _tmp159_;
					ValaCCodeFunctionCall* _tmp160_;
					_tmp145_ = itype;
					_tmp146_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp147_ = _tmp146_;
					_tmp148_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp148_;
					_tmp149_ = st;
					_tmp150_ = vala_struct_get_default_construction_method (_tmp149_);
					_tmp151_ = _tmp150_;
					_tmp152_ = _vala_code_node_ref0 ((ValaMethod*) _tmp151_);
					_vala_code_node_unref0 (m);
					m = _tmp152_;
					_tmp153_ = m;
					_tmp154_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp153_, _tmp154_);
					_tmp155_ = m;
					_tmp156_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_identifier_new (_tmp157_);
					_tmp159_ = _tmp158_;
					_tmp160_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp159_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp160_;
					_vala_ccode_node_unref0 (_tmp159_);
					_g_free0 (_tmp157_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp161_;
					_tmp161_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp162_;
						ValaDelegate* _tmp163_;
						ValaDelegate* _tmp164_;
						ValaDelegate* _tmp165_;
						_tmp162_ = itype;
						_tmp163_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp164_ = _tmp163_;
						_tmp165_ = _vala_code_node_ref0 (_tmp164_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp165_;
					}
				}
			}
		}
	}
	_tmp166_ = g_direct_hash;
	_tmp167_ = g_direct_equal;
	_tmp168_ = g_direct_equal;
	_tmp169_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp166_, _tmp167_, _tmp168_);
	in_arg_map = _tmp169_;
	_tmp170_ = in_arg_map;
	_tmp171_ = _vala_map_ref0 (_tmp170_);
	out_arg_map = _tmp171_;
	_tmp173_ = m;
	if (_tmp173_ != NULL) {
		ValaMethod* _tmp174_;
		gboolean _tmp175_;
		gboolean _tmp176_;
		_tmp174_ = m;
		_tmp175_ = vala_method_get_coroutine (_tmp174_);
		_tmp176_ = _tmp175_;
		_tmp172_ = _tmp176_;
	} else {
		_tmp172_ = FALSE;
	}
	if (_tmp172_) {
		ValaMethod* _tmp177_;
		gchar* _tmp178_;
		gchar* _tmp179_;
		ValaCCodeIdentifier* _tmp180_;
		ValaCCodeIdentifier* _tmp181_;
		ValaCCodeFunctionCall* _tmp182_;
		ValaMethod* _tmp183_;
		gchar* _tmp184_;
		gchar* _tmp185_;
		ValaCCodeIdentifier* _tmp186_;
		ValaCCodeIdentifier* _tmp187_;
		ValaCCodeFunctionCall* _tmp188_;
		ValaMemberAccess* _tmp189_;
		ValaExpression* _tmp190_;
		ValaExpression* _tmp191_;
		gboolean _tmp367_ = FALSE;
		ValaMemberAccess* _tmp368_;
		const gchar* _tmp369_;
		const gchar* _tmp370_;
		_tmp177_ = m;
		_tmp178_ = vala_get_ccode_name ((ValaCodeNode*) _tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_identifier_new (_tmp179_);
		_tmp181_ = _tmp180_;
		_tmp182_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp181_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp182_;
		_vala_ccode_node_unref0 (_tmp181_);
		_g_free0 (_tmp179_);
		_tmp183_ = m;
		_tmp184_ = vala_get_ccode_finish_name (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_identifier_new (_tmp185_);
		_tmp187_ = _tmp186_;
		_tmp188_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp187_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp188_;
		_vala_ccode_node_unref0 (_tmp187_);
		_g_free0 (_tmp185_);
		_tmp189_ = ma;
		_tmp190_ = vala_member_access_get_inner (_tmp189_);
		_tmp191_ = _tmp190_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp191_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp192_;
			ValaMethod* _tmp193_;
			ValaMethod* _tmp194_;
			ValaCCodeExpression* _tmp225_;
			vcast = NULL;
			_tmp192_ = m;
			_tmp193_ = vala_method_get_base_method (_tmp192_);
			_tmp194_ = _tmp193_;
			if (_tmp194_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp195_;
				ValaMethod* _tmp196_;
				ValaMethod* _tmp197_;
				ValaSymbol* _tmp198_;
				ValaSymbol* _tmp199_;
				ValaClass* _tmp200_;
				gchar* _tmp201_;
				gchar* _tmp202_;
				ValaCCodeIdentifier* _tmp203_;
				ValaCCodeIdentifier* _tmp204_;
				ValaCCodeFunctionCall* _tmp205_;
				ValaCCodeExpression* _tmp206_;
				ValaClass* _tmp207_;
				ValaClass* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				ValaCCodeIdentifier* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				_tmp195_ = m;
				_tmp196_ = vala_method_get_base_method (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp197_);
				_tmp199_ = _tmp198_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, VALA_TYPE_CLASS, ValaClass);
				_tmp200_ = base_class;
				_tmp201_ = vala_get_ccode_class_type_function (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = vala_ccode_identifier_new (_tmp202_);
				_tmp204_ = _tmp203_;
				_tmp205_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp204_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp205_;
				_vala_ccode_node_unref0 (_tmp204_);
				_g_free0 (_tmp202_);
				_tmp206_ = vcast;
				_tmp207_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp208_, NULL);
				_tmp210_ = _tmp209_;
				_tmp211_ = g_strdup_printf ("%s_parent_class", _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_ccode_identifier_new (_tmp212_);
				_tmp214_ = _tmp213_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp206_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp214_);
				_vala_ccode_node_unref0 (_tmp214_);
				_g_free0 (_tmp212_);
				_g_free0 (_tmp210_);
			} else {
				ValaMethod* _tmp215_;
				ValaMethod* _tmp216_;
				ValaMethod* _tmp217_;
				_tmp215_ = m;
				_tmp216_ = vala_method_get_base_interface_method (_tmp215_);
				_tmp217_ = _tmp216_;
				if (_tmp217_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp218_;
					ValaMethod* _tmp219_;
					ValaMethod* _tmp220_;
					ValaSymbol* _tmp221_;
					ValaSymbol* _tmp222_;
					ValaInterface* _tmp223_;
					ValaCCodeExpression* _tmp224_;
					_tmp218_ = m;
					_tmp219_ = vala_method_get_base_interface_method (_tmp218_);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp220_);
					_tmp222_ = _tmp221_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp222_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp223_ = base_iface;
					_tmp224_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp223_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp224_;
				}
			}
			_tmp225_ = vcast;
			if (_tmp225_ != NULL) {
				ValaCCodeFunctionCall* _tmp226_;
				ValaCCodeExpression* _tmp227_;
				ValaMethod* _tmp228_;
				gchar* _tmp229_;
				gchar* _tmp230_;
				ValaCCodeMemberAccess* _tmp231_;
				ValaCCodeMemberAccess* _tmp232_;
				ValaCCodeFunctionCall* _tmp233_;
				ValaCCodeExpression* _tmp234_;
				ValaMethod* _tmp235_;
				gchar* _tmp236_;
				gchar* _tmp237_;
				ValaCCodeMemberAccess* _tmp238_;
				ValaCCodeMemberAccess* _tmp239_;
				_tmp226_ = async_call;
				_tmp227_ = vcast;
				_tmp228_ = m;
				_tmp229_ = vala_get_ccode_vfunc_name (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp231_ = vala_ccode_member_access_new_pointer (_tmp227_, _tmp230_);
				_tmp232_ = _tmp231_;
				vala_ccode_function_call_set_call (_tmp226_, (ValaCCodeExpression*) _tmp232_);
				_vala_ccode_node_unref0 (_tmp232_);
				_g_free0 (_tmp230_);
				_tmp233_ = finish_call;
				_tmp234_ = vcast;
				_tmp235_ = m;
				_tmp236_ = vala_get_ccode_finish_vfunc_name (_tmp235_);
				_tmp237_ = _tmp236_;
				_tmp238_ = vala_ccode_member_access_new_pointer (_tmp234_, _tmp237_);
				_tmp239_ = _tmp238_;
				vala_ccode_function_call_set_call (_tmp233_, (ValaCCodeExpression*) _tmp239_);
				_vala_ccode_node_unref0 (_tmp239_);
				_g_free0 (_tmp237_);
			}
			_vala_ccode_node_unref0 (vcast);
		} else {
			gboolean _tmp240_ = FALSE;
			gboolean _tmp241_ = FALSE;
			gboolean _tmp242_ = FALSE;
			ValaMethod* _tmp243_;
			_tmp243_ = m;
			if (_tmp243_ != NULL) {
				ValaMethod* _tmp244_;
				_tmp244_ = m;
				_tmp242_ = vala_get_ccode_no_wrapper (_tmp244_);
			} else {
				_tmp242_ = FALSE;
			}
			if (_tmp242_) {
				ValaMethod* _tmp245_;
				ValaMemberBinding _tmp246_;
				ValaMemberBinding _tmp247_;
				_tmp245_ = m;
				_tmp246_ = vala_method_get_binding (_tmp245_);
				_tmp247_ = _tmp246_;
				_tmp241_ = _tmp247_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp241_ = FALSE;
			}
			if (_tmp241_) {
				ValaMethod* _tmp248_;
				_tmp248_ = m;
				_tmp240_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp248_, VALA_TYPE_CREATION_METHOD);
			} else {
				_tmp240_ = FALSE;
			}
			if (_tmp240_) {
				ValaTargetValue* instance_value = NULL;
				ValaMemberAccess* _tmp249_;
				ValaExpression* _tmp250_;
				ValaExpression* _tmp251_;
				ValaTargetValue* _tmp252_;
				ValaTargetValue* _tmp253_;
				ValaTargetValue* _tmp254_;
				gboolean _tmp255_ = FALSE;
				gboolean _tmp256_ = FALSE;
				ValaMemberAccess* _tmp257_;
				const gchar* _tmp258_;
				const gchar* _tmp259_;
				ValaCCodeExpression* pub_inst = NULL;
				ValaTargetValue* _tmp281_;
				ValaCCodeExpression* _tmp282_;
				ValaCCodeExpression* _tmp283_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaMethod* _tmp284_;
				ValaSymbol* _tmp285_;
				ValaSymbol* _tmp286_;
				ValaCCodeFunctionCall* _tmp352_;
				_tmp249_ = ma;
				_tmp250_ = vala_member_access_get_inner (_tmp249_);
				_tmp251_ = _tmp250_;
				_tmp252_ = vala_expression_get_target_value (_tmp251_);
				_tmp253_ = _tmp252_;
				_tmp254_ = _vala_target_value_ref0 (_tmp253_);
				instance_value = _tmp254_;
				_tmp257_ = ma;
				_tmp258_ = vala_member_access_get_member_name (_tmp257_);
				_tmp259_ = _tmp258_;
				if (g_strcmp0 (_tmp259_, "begin") == 0) {
					_tmp256_ = TRUE;
				} else {
					ValaMemberAccess* _tmp260_;
					const gchar* _tmp261_;
					const gchar* _tmp262_;
					_tmp260_ = ma;
					_tmp261_ = vala_member_access_get_member_name (_tmp260_);
					_tmp262_ = _tmp261_;
					_tmp256_ = g_strcmp0 (_tmp262_, "end") == 0;
				}
				if (_tmp256_) {
					ValaMemberAccess* _tmp263_;
					ValaExpression* _tmp264_;
					ValaExpression* _tmp265_;
					ValaSymbol* _tmp266_;
					ValaSymbol* _tmp267_;
					ValaMemberAccess* _tmp268_;
					ValaSymbol* _tmp269_;
					ValaSymbol* _tmp270_;
					_tmp263_ = ma;
					_tmp264_ = vala_member_access_get_inner (_tmp263_);
					_tmp265_ = _tmp264_;
					_tmp266_ = vala_expression_get_symbol_reference (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp268_ = ma;
					_tmp269_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp268_);
					_tmp270_ = _tmp269_;
					_tmp255_ = _tmp267_ == _tmp270_;
				} else {
					_tmp255_ = FALSE;
				}
				if (_tmp255_) {
					ValaMemberAccess* inner_ma = NULL;
					ValaMemberAccess* _tmp271_;
					ValaExpression* _tmp272_;
					ValaExpression* _tmp273_;
					ValaMemberAccess* _tmp274_;
					ValaMemberAccess* _tmp275_;
					ValaExpression* _tmp276_;
					ValaExpression* _tmp277_;
					ValaTargetValue* _tmp278_;
					ValaTargetValue* _tmp279_;
					ValaTargetValue* _tmp280_;
					_tmp271_ = ma;
					_tmp272_ = vala_member_access_get_inner (_tmp271_);
					_tmp273_ = _tmp272_;
					_tmp274_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp273_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
					inner_ma = _tmp274_;
					_tmp275_ = inner_ma;
					_tmp276_ = vala_member_access_get_inner (_tmp275_);
					_tmp277_ = _tmp276_;
					_tmp278_ = vala_expression_get_target_value (_tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = _vala_target_value_ref0 (_tmp279_);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp280_;
					_vala_code_node_unref0 (inner_ma);
				}
				_tmp281_ = instance_value;
				_tmp282_ = vala_get_cvalue_ (_tmp281_);
				_tmp283_ = _vala_ccode_node_ref0 (_tmp282_);
				pub_inst = _tmp283_;
				vcast = NULL;
				_tmp284_ = m;
				_tmp285_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp284_);
				_tmp286_ = _tmp285_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp286_, VALA_TYPE_CLASS)) {
					ValaClass* base_class = NULL;
					ValaMethod* _tmp287_;
					ValaSymbol* _tmp288_;
					ValaSymbol* _tmp289_;
					ValaClass* _tmp290_;
					gboolean _tmp291_;
					gboolean _tmp292_;
					_tmp287_ = m;
					_tmp288_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp287_);
					_tmp289_ = _tmp288_;
					base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp289_, VALA_TYPE_CLASS, ValaClass);
					_tmp290_ = base_class;
					_tmp291_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp290_);
					_tmp292_ = _tmp291_;
					if (_tmp292_) {
						ValaCCodeIdentifier* _tmp293_;
						ValaCCodeIdentifier* _tmp294_;
						ValaCCodeFunctionCall* _tmp295_;
						ValaCCodeFunctionCall* _tmp296_;
						ValaCCodeExpression* _tmp297_;
						ValaCCodeFunctionCall* _tmp298_;
						ValaClass* _tmp299_;
						gchar* _tmp300_;
						gchar* _tmp301_;
						ValaCCodeIdentifier* _tmp302_;
						ValaCCodeIdentifier* _tmp303_;
						ValaCCodeFunctionCall* _tmp304_;
						ValaClass* _tmp305_;
						gchar* _tmp306_;
						gchar* _tmp307_;
						ValaCCodeIdentifier* _tmp308_;
						ValaCCodeIdentifier* _tmp309_;
						_tmp293_ = vala_ccode_identifier_new ("G_TYPE_INSTANCE_GET_CLASS");
						_tmp294_ = _tmp293_;
						_tmp295_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp294_);
						_vala_ccode_node_unref0 (vcast);
						vcast = _tmp295_;
						_vala_ccode_node_unref0 (_tmp294_);
						_tmp296_ = vcast;
						_tmp297_ = pub_inst;
						vala_ccode_function_call_add_argument (_tmp296_, _tmp297_);
						_tmp298_ = vcast;
						_tmp299_ = base_class;
						_tmp300_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp299_);
						_tmp301_ = _tmp300_;
						_tmp302_ = vala_ccode_identifier_new (_tmp301_);
						_tmp303_ = _tmp302_;
						vala_ccode_function_call_add_argument (_tmp298_, (ValaCCodeExpression*) _tmp303_);
						_vala_ccode_node_unref0 (_tmp303_);
						_g_free0 (_tmp301_);
						_tmp304_ = vcast;
						_tmp305_ = base_class;
						_tmp306_ = vala_get_ccode_type_name ((ValaObjectTypeSymbol*) _tmp305_);
						_tmp307_ = _tmp306_;
						_tmp308_ = vala_ccode_identifier_new (_tmp307_);
						_tmp309_ = _tmp308_;
						vala_ccode_function_call_add_argument (_tmp304_, (ValaCCodeExpression*) _tmp309_);
						_vala_ccode_node_unref0 (_tmp309_);
						_g_free0 (_tmp307_);
					} else {
						ValaClass* _tmp310_;
						gchar* _tmp311_;
						gchar* _tmp312_;
						ValaCCodeIdentifier* _tmp313_;
						ValaCCodeIdentifier* _tmp314_;
						ValaCCodeFunctionCall* _tmp315_;
						ValaCCodeFunctionCall* _tmp316_;
						ValaCCodeExpression* _tmp317_;
						_tmp310_ = base_class;
						_tmp311_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp310_);
						_tmp312_ = _tmp311_;
						_tmp313_ = vala_ccode_identifier_new (_tmp312_);
						_tmp314_ = _tmp313_;
						_tmp315_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp314_);
						_vala_ccode_node_unref0 (vcast);
						vcast = _tmp315_;
						_vala_ccode_node_unref0 (_tmp314_);
						_g_free0 (_tmp312_);
						_tmp316_ = vcast;
						_tmp317_ = pub_inst;
						vala_ccode_function_call_add_argument (_tmp316_, _tmp317_);
					}
				} else {
					ValaMethod* _tmp318_;
					ValaSymbol* _tmp319_;
					ValaSymbol* _tmp320_;
					_tmp318_ = m;
					_tmp319_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp318_);
					_tmp320_ = _tmp319_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp320_, VALA_TYPE_INTERFACE)) {
						ValaInterface* base_iface = NULL;
						ValaMethod* _tmp321_;
						ValaSymbol* _tmp322_;
						ValaSymbol* _tmp323_;
						ValaInterface* _tmp324_;
						gboolean _tmp325_;
						gboolean _tmp326_;
						_tmp321_ = m;
						_tmp322_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp321_);
						_tmp323_ = _tmp322_;
						base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp323_, VALA_TYPE_INTERFACE, ValaInterface);
						_tmp324_ = base_iface;
						_tmp325_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp324_);
						_tmp326_ = _tmp325_;
						if (_tmp326_) {
							ValaCCodeIdentifier* _tmp327_;
							ValaCCodeIdentifier* _tmp328_;
							ValaCCodeFunctionCall* _tmp329_;
							ValaCCodeFunctionCall* _tmp330_;
							ValaCCodeExpression* _tmp331_;
							ValaCCodeFunctionCall* _tmp332_;
							ValaInterface* _tmp333_;
							gchar* _tmp334_;
							gchar* _tmp335_;
							ValaCCodeIdentifier* _tmp336_;
							ValaCCodeIdentifier* _tmp337_;
							ValaCCodeFunctionCall* _tmp338_;
							ValaInterface* _tmp339_;
							gchar* _tmp340_;
							gchar* _tmp341_;
							ValaCCodeIdentifier* _tmp342_;
							ValaCCodeIdentifier* _tmp343_;
							_tmp327_ = vala_ccode_identifier_new ("G_TYPE_INSTANCE_GET_INTERFACE");
							_tmp328_ = _tmp327_;
							_tmp329_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp328_);
							_vala_ccode_node_unref0 (vcast);
							vcast = _tmp329_;
							_vala_ccode_node_unref0 (_tmp328_);
							_tmp330_ = vcast;
							_tmp331_ = pub_inst;
							vala_ccode_function_call_add_argument (_tmp330_, _tmp331_);
							_tmp332_ = vcast;
							_tmp333_ = base_iface;
							_tmp334_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp333_);
							_tmp335_ = _tmp334_;
							_tmp336_ = vala_ccode_identifier_new (_tmp335_);
							_tmp337_ = _tmp336_;
							vala_ccode_function_call_add_argument (_tmp332_, (ValaCCodeExpression*) _tmp337_);
							_vala_ccode_node_unref0 (_tmp337_);
							_g_free0 (_tmp335_);
							_tmp338_ = vcast;
							_tmp339_ = base_iface;
							_tmp340_ = vala_get_ccode_type_name ((ValaObjectTypeSymbol*) _tmp339_);
							_tmp341_ = _tmp340_;
							_tmp342_ = vala_ccode_identifier_new (_tmp341_);
							_tmp343_ = _tmp342_;
							vala_ccode_function_call_add_argument (_tmp338_, (ValaCCodeExpression*) _tmp343_);
							_vala_ccode_node_unref0 (_tmp343_);
							_g_free0 (_tmp341_);
						} else {
							ValaInterface* _tmp344_;
							gchar* _tmp345_;
							gchar* _tmp346_;
							ValaCCodeIdentifier* _tmp347_;
							ValaCCodeIdentifier* _tmp348_;
							ValaCCodeFunctionCall* _tmp349_;
							ValaCCodeFunctionCall* _tmp350_;
							ValaCCodeExpression* _tmp351_;
							_tmp344_ = base_iface;
							_tmp345_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp344_);
							_tmp346_ = _tmp345_;
							_tmp347_ = vala_ccode_identifier_new (_tmp346_);
							_tmp348_ = _tmp347_;
							_tmp349_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp348_);
							_vala_ccode_node_unref0 (vcast);
							vcast = _tmp349_;
							_vala_ccode_node_unref0 (_tmp348_);
							_g_free0 (_tmp346_);
							_tmp350_ = vcast;
							_tmp351_ = pub_inst;
							vala_ccode_function_call_add_argument (_tmp350_, _tmp351_);
						}
					}
				}
				_tmp352_ = vcast;
				if (_tmp352_ != NULL) {
					ValaCCodeFunctionCall* _tmp353_;
					ValaCCodeFunctionCall* _tmp354_;
					ValaMethod* _tmp355_;
					gchar* _tmp356_;
					gchar* _tmp357_;
					ValaCCodeMemberAccess* _tmp358_;
					ValaCCodeMemberAccess* _tmp359_;
					ValaCCodeFunctionCall* _tmp360_;
					ValaCCodeFunctionCall* _tmp361_;
					ValaMethod* _tmp362_;
					gchar* _tmp363_;
					gchar* _tmp364_;
					ValaCCodeMemberAccess* _tmp365_;
					ValaCCodeMemberAccess* _tmp366_;
					_tmp353_ = async_call;
					_tmp354_ = vcast;
					_tmp355_ = m;
					_tmp356_ = vala_get_ccode_vfunc_name (_tmp355_);
					_tmp357_ = _tmp356_;
					_tmp358_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp354_, _tmp357_);
					_tmp359_ = _tmp358_;
					vala_ccode_function_call_set_call (_tmp353_, (ValaCCodeExpression*) _tmp359_);
					_vala_ccode_node_unref0 (_tmp359_);
					_g_free0 (_tmp357_);
					_tmp360_ = finish_call;
					_tmp361_ = vcast;
					_tmp362_ = m;
					_tmp363_ = vala_get_ccode_finish_vfunc_name (_tmp362_);
					_tmp364_ = _tmp363_;
					_tmp365_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp361_, _tmp364_);
					_tmp366_ = _tmp365_;
					vala_ccode_function_call_set_call (_tmp360_, (ValaCCodeExpression*) _tmp366_);
					_vala_ccode_node_unref0 (_tmp366_);
					_g_free0 (_tmp364_);
				}
				_vala_ccode_node_unref0 (vcast);
				_vala_ccode_node_unref0 (pub_inst);
				_vala_target_value_unref0 (instance_value);
			}
		}
		_tmp368_ = ma;
		_tmp369_ = vala_member_access_get_member_name (_tmp368_);
		_tmp370_ = _tmp369_;
		if (g_strcmp0 (_tmp370_, "begin") == 0) {
			ValaMemberAccess* _tmp371_;
			ValaExpression* _tmp372_;
			ValaExpression* _tmp373_;
			ValaSymbol* _tmp374_;
			ValaSymbol* _tmp375_;
			ValaMemberAccess* _tmp376_;
			ValaSymbol* _tmp377_;
			ValaSymbol* _tmp378_;
			_tmp371_ = ma;
			_tmp372_ = vala_member_access_get_inner (_tmp371_);
			_tmp373_ = _tmp372_;
			_tmp374_ = vala_expression_get_symbol_reference (_tmp373_);
			_tmp375_ = _tmp374_;
			_tmp376_ = ma;
			_tmp377_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp376_);
			_tmp378_ = _tmp377_;
			_tmp367_ = _tmp375_ == _tmp378_;
		} else {
			_tmp367_ = FALSE;
		}
		if (_tmp367_) {
			ValaCCodeFunctionCall* _tmp379_;
			ValaCCodeFunctionCall* _tmp380_;
			ValaMethod* _tmp381_;
			ValaList* _tmp382_;
			_tmp379_ = async_call;
			_tmp380_ = _vala_ccode_node_ref0 (_tmp379_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp380_;
			_tmp381_ = m;
			_tmp382_ = vala_method_get_async_begin_parameters (_tmp381_);
			_vala_iterable_unref0 (params);
			params = _tmp382_;
		} else {
			gboolean _tmp383_ = FALSE;
			ValaMemberAccess* _tmp384_;
			const gchar* _tmp385_;
			const gchar* _tmp386_;
			_tmp384_ = ma;
			_tmp385_ = vala_member_access_get_member_name (_tmp384_);
			_tmp386_ = _tmp385_;
			if (g_strcmp0 (_tmp386_, "end") == 0) {
				ValaMemberAccess* _tmp387_;
				ValaExpression* _tmp388_;
				ValaExpression* _tmp389_;
				ValaSymbol* _tmp390_;
				ValaSymbol* _tmp391_;
				ValaMemberAccess* _tmp392_;
				ValaSymbol* _tmp393_;
				ValaSymbol* _tmp394_;
				_tmp387_ = ma;
				_tmp388_ = vala_member_access_get_inner (_tmp387_);
				_tmp389_ = _tmp388_;
				_tmp390_ = vala_expression_get_symbol_reference (_tmp389_);
				_tmp391_ = _tmp390_;
				_tmp392_ = ma;
				_tmp393_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp392_);
				_tmp394_ = _tmp393_;
				_tmp383_ = _tmp391_ == _tmp394_;
			} else {
				_tmp383_ = FALSE;
			}
			if (_tmp383_) {
				ValaCCodeFunctionCall* _tmp395_;
				ValaCCodeFunctionCall* _tmp396_;
				ValaMethod* _tmp397_;
				ValaList* _tmp398_;
				_tmp395_ = finish_call;
				_tmp396_ = _vala_ccode_node_ref0 (_tmp395_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp396_;
				_tmp397_ = m;
				_tmp398_ = vala_method_get_async_end_parameters (_tmp397_);
				_vala_iterable_unref0 (params);
				params = _tmp398_;
			} else {
				gboolean _tmp399_;
				gboolean _tmp400_;
				_tmp399_ = vala_method_call_get_is_yield_expression (expr);
				_tmp400_ = _tmp399_;
				if (!_tmp400_) {
					ValaCCodeFunctionCall* _tmp401_;
					ValaCCodeFunctionCall* _tmp402_;
					ValaMethod* _tmp403_;
					ValaList* _tmp404_;
					_tmp401_ = async_call;
					_tmp402_ = _vala_ccode_node_ref0 (_tmp401_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp402_;
					_tmp403_ = m;
					_tmp404_ = vala_method_get_async_begin_parameters (_tmp403_);
					_vala_iterable_unref0 (params);
					params = _tmp404_;
				} else {
					ValaCCodeFunctionCall* _tmp405_;
					ValaCCodeFunctionCall* _tmp406_;
					GHashFunc _tmp407_;
					GEqualFunc _tmp408_;
					GEqualFunc _tmp409_;
					ValaHashMap* _tmp410_;
					ValaHashMap* _tmp411_;
					ValaMethod* _tmp412_;
					ValaCCodeIdentifier* _tmp413_;
					ValaCCodeIdentifier* _tmp414_;
					ValaCCodeMemberAccess* _tmp415_;
					ValaCCodeMemberAccess* _tmp416_;
					_tmp405_ = finish_call;
					_tmp406_ = _vala_ccode_node_ref0 (_tmp405_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp406_;
					_tmp407_ = g_direct_hash;
					_tmp408_ = g_direct_equal;
					_tmp409_ = g_direct_equal;
					_tmp410_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp407_, _tmp408_, _tmp409_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp410_;
					_tmp411_ = out_arg_map;
					_tmp412_ = m;
					_tmp413_ = vala_ccode_identifier_new ("_data_");
					_tmp414_ = _tmp413_;
					_tmp415_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp414_, "_res_");
					_tmp416_ = _tmp415_;
					vala_map_set ((ValaMap*) _tmp411_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp412_), FALSE)), (ValaCCodeExpression*) _tmp416_);
					_vala_ccode_node_unref0 (_tmp416_);
					_vala_ccode_node_unref0 (_tmp414_);
				}
			}
		}
	}
	_tmp418_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp418_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp419_;
		ValaSymbol* _tmp420_;
		ValaSymbol* _tmp421_;
		_tmp419_ = m;
		_tmp420_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp419_);
		_tmp421_ = _tmp420_;
		_tmp417_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp421_, VALA_TYPE_CLASS);
	} else {
		_tmp417_ = FALSE;
	}
	if (_tmp417_) {
		ValaCodeContext* _tmp422_;
		ValaCodeContext* _tmp423_;
		ValaProfile _tmp424_;
		ValaProfile _tmp425_;
		ValaClass* _tmp437_;
		ValaClass* _tmp438_;
		gboolean _tmp439_;
		gboolean _tmp440_;
		_tmp422_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp423_ = _tmp422_;
		_tmp424_ = vala_code_context_get_profile (_tmp423_);
		_tmp425_ = _tmp424_;
		if (_tmp425_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp426_;
			ValaSymbol* _tmp427_;
			ValaSymbol* _tmp428_;
			gboolean _tmp429_;
			gboolean _tmp430_;
			_tmp426_ = m;
			_tmp427_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp426_);
			_tmp428_ = _tmp427_;
			_tmp429_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp428_, VALA_TYPE_CLASS, ValaClass));
			_tmp430_ = _tmp429_;
			if (!_tmp430_) {
				ValaCCodeFunctionCall* _tmp431_;
				ValaCCodeExpression* _tmp432_;
				ValaCCodeExpression* _tmp433_;
				_tmp431_ = ccall;
				_tmp432_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp433_ = _tmp432_;
				vala_ccode_function_call_add_argument (_tmp431_, _tmp433_);
				_vala_ccode_node_unref0 (_tmp433_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp434_;
			ValaCCodeExpression* _tmp435_;
			ValaCCodeExpression* _tmp436_;
			_tmp434_ = ccall;
			_tmp435_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp436_ = _tmp435_;
			vala_ccode_function_call_add_argument (_tmp434_, _tmp436_);
			_vala_ccode_node_unref0 (_tmp436_);
		}
		_tmp437_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp438_ = _tmp437_;
		_tmp439_ = vala_class_get_is_compact (_tmp438_);
		_tmp440_ = _tmp439_;
		if (!_tmp440_) {
			ValaClass* _tmp441_;
			ValaClass* _tmp442_;
			ValaMethod* _tmp443_;
			ValaSymbol* _tmp444_;
			ValaSymbol* _tmp445_;
			_tmp441_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp442_ = _tmp441_;
			_tmp443_ = m;
			_tmp444_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp443_);
			_tmp445_ = _tmp444_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp442_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp445_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp446_;
					ValaClass* _tmp447_;
					ValaList* _tmp448_;
					ValaList* _tmp449_;
					gint _base_type_size = 0;
					ValaList* _tmp450_;
					gint _tmp451_;
					gint _tmp452_;
					gint _base_type_index = 0;
					_tmp446_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp447_ = _tmp446_;
					_tmp448_ = vala_class_get_base_types (_tmp447_);
					_tmp449_ = _vala_iterable_ref0 (_tmp448_);
					_base_type_list = _tmp449_;
					_tmp450_ = _base_type_list;
					_tmp451_ = vala_collection_get_size ((ValaCollection*) _tmp450_);
					_tmp452_ = _tmp451_;
					_base_type_size = _tmp452_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp453_;
						gint _tmp454_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp455_;
						gpointer _tmp456_;
						ValaDataType* _tmp457_;
						ValaTypeSymbol* _tmp458_;
						ValaTypeSymbol* _tmp459_;
						_base_type_index = _base_type_index + 1;
						_tmp453_ = _base_type_index;
						_tmp454_ = _base_type_size;
						if (!(_tmp453_ < _tmp454_)) {
							break;
						}
						_tmp455_ = _base_type_list;
						_tmp456_ = vala_list_get (_tmp455_, _base_type_index);
						base_type = (ValaDataType*) _tmp456_;
						_tmp457_ = base_type;
						_tmp458_ = vala_data_type_get_type_symbol (_tmp457_);
						_tmp459_ = _tmp458_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp459_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp460_;
							gchar* _tmp461_;
							gchar* _tmp462_;
							gboolean _tmp463_;
							ValaHashMap* _tmp469_;
							ValaDataType* _tmp470_;
							ValaList* _tmp471_;
							ValaList* _tmp472_;
							type_parameters = NULL;
							_tmp460_ = m;
							_tmp461_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp460_);
							_tmp462_ = _tmp461_;
							_tmp463_ = g_strcmp0 (_tmp462_, "g_object_new") == 0;
							_g_free0 (_tmp462_);
							if (_tmp463_) {
								ValaDataType* _tmp464_;
								ValaTypeSymbol* _tmp465_;
								ValaTypeSymbol* _tmp466_;
								ValaList* _tmp467_;
								ValaList* _tmp468_;
								_tmp464_ = base_type;
								_tmp465_ = vala_data_type_get_type_symbol (_tmp464_);
								_tmp466_ = _tmp465_;
								_tmp467_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp466_, VALA_TYPE_CLASS, ValaClass));
								_tmp468_ = _vala_iterable_ref0 (_tmp467_);
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp468_;
							}
							_tmp469_ = in_arg_map;
							_tmp470_ = base_type;
							_tmp471_ = vala_data_type_get_type_arguments (_tmp470_);
							_tmp472_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp469_, _tmp471_, (ValaCodeNode*) expr, TRUE, _tmp472_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp473_;
				ValaSymbol* _tmp474_;
				ValaSymbol* _tmp475_;
				ValaClass* _tmp476_;
				type_param_index = 0;
				_tmp473_ = m;
				_tmp474_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp473_);
				_tmp475_ = _tmp474_;
				_tmp476_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp475_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp476_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp477_;
					ValaList* _tmp478_;
					ValaList* _tmp479_;
					gint _type_param_size = 0;
					ValaList* _tmp480_;
					gint _tmp481_;
					gint _tmp482_;
					gint _type_param_index = 0;
					_tmp477_ = cl;
					_tmp478_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp477_);
					_tmp479_ = _vala_iterable_ref0 (_tmp478_);
					_type_param_list = _tmp479_;
					_tmp480_ = _type_param_list;
					_tmp481_ = vala_collection_get_size ((ValaCollection*) _tmp480_);
					_tmp482_ = _tmp481_;
					_type_param_size = _tmp482_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp483_;
						gint _tmp484_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp485_;
						gpointer _tmp486_;
						ValaHashMap* _tmp487_;
						ValaTypeParameter* _tmp488_;
						const gchar* _tmp489_;
						const gchar* _tmp490_;
						gchar* _tmp491_;
						gchar* _tmp492_;
						gchar* _tmp493_;
						gchar* _tmp494_;
						ValaCCodeIdentifier* _tmp495_;
						ValaCCodeIdentifier* _tmp496_;
						ValaHashMap* _tmp497_;
						ValaTypeParameter* _tmp498_;
						const gchar* _tmp499_;
						const gchar* _tmp500_;
						gchar* _tmp501_;
						gchar* _tmp502_;
						gchar* _tmp503_;
						gchar* _tmp504_;
						ValaCCodeIdentifier* _tmp505_;
						ValaCCodeIdentifier* _tmp506_;
						ValaHashMap* _tmp507_;
						ValaTypeParameter* _tmp508_;
						const gchar* _tmp509_;
						const gchar* _tmp510_;
						gchar* _tmp511_;
						gchar* _tmp512_;
						gchar* _tmp513_;
						gchar* _tmp514_;
						ValaCCodeIdentifier* _tmp515_;
						ValaCCodeIdentifier* _tmp516_;
						gint _tmp517_;
						_type_param_index = _type_param_index + 1;
						_tmp483_ = _type_param_index;
						_tmp484_ = _type_param_size;
						if (!(_tmp483_ < _tmp484_)) {
							break;
						}
						_tmp485_ = _type_param_list;
						_tmp486_ = vala_list_get (_tmp485_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp486_;
						_tmp487_ = in_arg_map;
						_tmp488_ = type_param;
						_tmp489_ = vala_symbol_get_name ((ValaSymbol*) _tmp488_);
						_tmp490_ = _tmp489_;
						_tmp491_ = g_ascii_strdown (_tmp490_, (gssize) -1);
						_tmp492_ = _tmp491_;
						_tmp493_ = g_strdup_printf ("%s_type", _tmp492_);
						_tmp494_ = _tmp493_;
						_tmp495_ = vala_ccode_identifier_new (_tmp494_);
						_tmp496_ = _tmp495_;
						vala_map_set ((ValaMap*) _tmp487_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp496_);
						_vala_ccode_node_unref0 (_tmp496_);
						_g_free0 (_tmp494_);
						_g_free0 (_tmp492_);
						_tmp497_ = in_arg_map;
						_tmp498_ = type_param;
						_tmp499_ = vala_symbol_get_name ((ValaSymbol*) _tmp498_);
						_tmp500_ = _tmp499_;
						_tmp501_ = g_ascii_strdown (_tmp500_, (gssize) -1);
						_tmp502_ = _tmp501_;
						_tmp503_ = g_strdup_printf ("%s_dup_func", _tmp502_);
						_tmp504_ = _tmp503_;
						_tmp505_ = vala_ccode_identifier_new (_tmp504_);
						_tmp506_ = _tmp505_;
						vala_map_set ((ValaMap*) _tmp497_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp506_);
						_vala_ccode_node_unref0 (_tmp506_);
						_g_free0 (_tmp504_);
						_g_free0 (_tmp502_);
						_tmp507_ = in_arg_map;
						_tmp508_ = type_param;
						_tmp509_ = vala_symbol_get_name ((ValaSymbol*) _tmp508_);
						_tmp510_ = _tmp509_;
						_tmp511_ = g_ascii_strdown (_tmp510_, (gssize) -1);
						_tmp512_ = _tmp511_;
						_tmp513_ = g_strdup_printf ("%s_destroy_func", _tmp512_);
						_tmp514_ = _tmp513_;
						_tmp515_ = vala_ccode_identifier_new (_tmp514_);
						_tmp516_ = _tmp515_;
						vala_map_set ((ValaMap*) _tmp507_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp516_);
						_vala_ccode_node_unref0 (_tmp516_);
						_g_free0 (_tmp514_);
						_g_free0 (_tmp512_);
						_tmp517_ = type_param_index;
						type_param_index = _tmp517_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp518_;
			ValaClass* _tmp519_;
			ValaClass* _tmp520_;
			_tmp518_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp519_ = _tmp518_;
			_tmp520_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp519_, (ValaTypeSymbol*) _tmp520_)) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp521_;
				ValaClass* _tmp522_;
				gchar* _tmp523_;
				gchar* prepare_func = NULL;
				gchar* _tmp524_;
				gchar* check_func = NULL;
				gchar* _tmp525_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp550_;
				ValaCCodeDeclaration* _tmp551_;
				ValaCCodeDeclaration* _tmp552_;
				const gchar* _tmp553_;
				const gchar* _tmp554_;
				const gchar* _tmp555_;
				const gchar* _tmp556_;
				gchar* _tmp557_;
				gchar* _tmp558_;
				ValaCCodeConstant* _tmp559_;
				ValaCCodeConstant* _tmp560_;
				ValaCCodeVariableDeclarator* _tmp561_;
				ValaCCodeVariableDeclarator* _tmp562_;
				ValaCCodeFunction* _tmp563_;
				ValaCCodeFunction* _tmp564_;
				ValaCCodeDeclaration* _tmp565_;
				ValaCCodeFunctionCall* _tmp566_;
				ValaCCodeIdentifier* _tmp567_;
				ValaCCodeIdentifier* _tmp568_;
				ValaCCodeUnaryExpression* _tmp569_;
				ValaCCodeUnaryExpression* _tmp570_;
				ValaCCodeCastExpression* _tmp571_;
				ValaCCodeCastExpression* _tmp572_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp573_;
				ValaCCodeIdentifier* _tmp574_;
				ValaCCodeFunctionCall* _tmp575_;
				ValaCCodeFunctionCall* _tmp576_;
				ValaCCodeFunctionCall* _tmp577_;
				ValaClass* _tmp578_;
				ValaClass* _tmp579_;
				gchar* _tmp580_;
				gchar* _tmp581_;
				ValaCCodeIdentifier* _tmp582_;
				ValaCCodeIdentifier* _tmp583_;
				ValaCCodeFunctionCall* _tmp584_;
				ValaCCodeFunctionCall* _tmp585_;
				_tmp521_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp522_ = _tmp521_;
				_tmp523_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp522_, NULL);
				class_prefix = _tmp523_;
				_tmp524_ = g_strdup ("NULL");
				prepare_func = _tmp524_;
				_tmp525_ = g_strdup ("NULL");
				check_func = _tmp525_;
				{
					ValaList* _impl_list = NULL;
					ValaClass* _tmp526_;
					ValaClass* _tmp527_;
					ValaList* _tmp528_;
					ValaList* _tmp529_;
					gint _impl_size = 0;
					ValaList* _tmp530_;
					gint _tmp531_;
					gint _tmp532_;
					gint _impl_index = 0;
					_tmp526_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp527_ = _tmp526_;
					_tmp528_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp527_);
					_tmp529_ = _vala_iterable_ref0 (_tmp528_);
					_impl_list = _tmp529_;
					_tmp530_ = _impl_list;
					_tmp531_ = vala_collection_get_size ((ValaCollection*) _tmp530_);
					_tmp532_ = _tmp531_;
					_impl_size = _tmp532_;
					_impl_index = -1;
					while (TRUE) {
						gint _tmp533_;
						gint _tmp534_;
						ValaMethod* impl = NULL;
						ValaList* _tmp535_;
						gpointer _tmp536_;
						ValaMethod* _tmp537_;
						gboolean _tmp538_;
						gboolean _tmp539_;
						ValaMethod* _tmp540_;
						const gchar* _tmp541_;
						const gchar* _tmp542_;
						const gchar* _tmp543_;
						GQuark _tmp545_ = 0U;
						static GQuark _tmp544_label0 = 0;
						static GQuark _tmp544_label1 = 0;
						_impl_index = _impl_index + 1;
						_tmp533_ = _impl_index;
						_tmp534_ = _impl_size;
						if (!(_tmp533_ < _tmp534_)) {
							break;
						}
						_tmp535_ = _impl_list;
						_tmp536_ = vala_list_get (_tmp535_, _impl_index);
						impl = (ValaMethod*) _tmp536_;
						_tmp537_ = impl;
						_tmp538_ = vala_method_get_overrides (_tmp537_);
						_tmp539_ = _tmp538_;
						if (!_tmp539_) {
							_vala_code_node_unref0 (impl);
							continue;
						}
						_tmp540_ = impl;
						_tmp541_ = vala_symbol_get_name ((ValaSymbol*) _tmp540_);
						_tmp542_ = _tmp541_;
						_tmp543_ = _tmp542_;
						_tmp545_ = (NULL == _tmp543_) ? 0 : g_quark_from_string (_tmp543_);
						if (_tmp545_ == ((0 != _tmp544_label0) ? _tmp544_label0 : (_tmp544_label0 = g_quark_from_static_string ("prepare")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp546_;
									gchar* _tmp547_;
									_tmp546_ = class_prefix;
									_tmp547_ = g_strdup_printf ("%s_real_prepare", _tmp546_);
									_g_free0 (prepare_func);
									prepare_func = _tmp547_;
									break;
								}
							}
						} else if (_tmp545_ == ((0 != _tmp544_label1) ? _tmp544_label1 : (_tmp544_label1 = g_quark_from_static_string ("check")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp548_;
									gchar* _tmp549_;
									_tmp548_ = class_prefix;
									_tmp549_ = g_strdup_printf ("%s_real_check", _tmp548_);
									_g_free0 (check_func);
									check_func = _tmp549_;
									break;
								}
							}
						} else {
							switch (0) {
								default:
								{
									break;
								}
							}
						}
						_vala_code_node_unref0 (impl);
					}
					_vala_iterable_unref0 (_impl_list);
				}
				_tmp550_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp550_;
				_tmp551_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp551_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp552_ = funcs;
				_tmp553_ = prepare_func;
				_tmp554_ = check_func;
				_tmp555_ = class_prefix;
				_tmp556_ = class_prefix;
				_tmp557_ = g_strdup_printf ("{ %s, %s, %s_real_dispatch, %s_finalize}", _tmp553_, _tmp554_, _tmp555_, _tmp556_);
				_tmp558_ = _tmp557_;
				_tmp559_ = vala_ccode_constant_new (_tmp558_);
				_tmp560_ = _tmp559_;
				_tmp561_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp560_, NULL);
				_tmp562_ = _tmp561_;
				vala_ccode_declaration_add_declarator (_tmp552_, (ValaCCodeDeclarator*) _tmp562_);
				_vala_ccode_node_unref0 (_tmp562_);
				_vala_ccode_node_unref0 (_tmp560_);
				_g_free0 (_tmp558_);
				_tmp563_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp564_ = _tmp563_;
				_tmp565_ = funcs;
				vala_ccode_function_add_statement (_tmp564_, (ValaCCodeNode*) _tmp565_);
				_tmp566_ = ccall;
				_tmp567_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp568_ = _tmp567_;
				_tmp569_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp568_);
				_tmp570_ = _tmp569_;
				_tmp571_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp570_, "GSourceFuncs *");
				_tmp572_ = _tmp571_;
				vala_ccode_function_call_add_argument (_tmp566_, (ValaCCodeExpression*) _tmp572_);
				_vala_ccode_node_unref0 (_tmp572_);
				_vala_ccode_node_unref0 (_tmp570_);
				_vala_ccode_node_unref0 (_tmp568_);
				_tmp573_ = vala_ccode_identifier_new ("sizeof");
				_tmp574_ = _tmp573_;
				_tmp575_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp574_);
				_tmp576_ = _tmp575_;
				_vala_ccode_node_unref0 (_tmp574_);
				csizeof = _tmp576_;
				_tmp577_ = csizeof;
				_tmp578_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp579_ = _tmp578_;
				_tmp580_ = vala_get_ccode_name ((ValaCodeNode*) _tmp579_);
				_tmp581_ = _tmp580_;
				_tmp582_ = vala_ccode_identifier_new (_tmp581_);
				_tmp583_ = _tmp582_;
				vala_ccode_function_call_add_argument (_tmp577_, (ValaCCodeExpression*) _tmp583_);
				_vala_ccode_node_unref0 (_tmp583_);
				_g_free0 (_tmp581_);
				_tmp584_ = ccall;
				_tmp585_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp584_, (ValaCCodeExpression*) _tmp585_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (check_func);
				_g_free0 (prepare_func);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp586_ = FALSE;
		ValaMethod* _tmp587_;
		_tmp587_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp587_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp588_;
			ValaSymbol* _tmp589_;
			ValaSymbol* _tmp590_;
			_tmp588_ = m;
			_tmp589_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp588_);
			_tmp590_ = _tmp589_;
			_tmp586_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp590_, VALA_TYPE_STRUCT);
		} else {
			_tmp586_ = FALSE;
		}
		if (_tmp586_) {
			ValaCCodeFunctionCall* _tmp591_;
			ValaCCodeExpression* _tmp592_;
			ValaCCodeExpression* _tmp593_;
			_tmp591_ = ccall;
			_tmp592_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp593_ = _tmp592_;
			vala_ccode_function_call_add_argument (_tmp591_, _tmp593_);
			_vala_ccode_node_unref0 (_tmp593_);
		} else {
			gboolean _tmp594_ = FALSE;
			gboolean _tmp595_ = FALSE;
			gboolean _tmp596_ = FALSE;
			gboolean _tmp597_ = FALSE;
			ValaMethod* _tmp598_;
			_tmp598_ = m;
			if (_tmp598_ != NULL) {
				ValaMethod* _tmp599_;
				_tmp599_ = m;
				_tmp597_ = vala_method_has_type_parameters (_tmp599_);
			} else {
				_tmp597_ = FALSE;
			}
			if (_tmp597_) {
				ValaMethod* _tmp600_;
				_tmp600_ = m;
				_tmp596_ = !vala_get_ccode_has_generic_type_parameter (_tmp600_);
			} else {
				_tmp596_ = FALSE;
			}
			if (_tmp596_) {
				ValaMethod* _tmp601_;
				_tmp601_ = m;
				_tmp595_ = !vala_get_ccode_simple_generics (_tmp601_);
			} else {
				_tmp595_ = FALSE;
			}
			if (_tmp595_) {
				gboolean _tmp602_ = FALSE;
				ValaCCodeFunctionCall* _tmp603_;
				ValaCCodeFunctionCall* _tmp604_;
				_tmp603_ = ccall;
				_tmp604_ = finish_call;
				if (_tmp603_ != _tmp604_) {
					_tmp602_ = TRUE;
				} else {
					gboolean _tmp605_;
					gboolean _tmp606_;
					_tmp605_ = vala_method_call_get_is_yield_expression (expr);
					_tmp606_ = _tmp605_;
					_tmp602_ = _tmp606_;
				}
				_tmp594_ = _tmp602_;
			} else {
				_tmp594_ = FALSE;
			}
			if (_tmp594_) {
				ValaHashMap* _tmp607_;
				ValaMemberAccess* _tmp608_;
				ValaList* _tmp609_;
				_tmp607_ = in_arg_map;
				_tmp608_ = ma;
				_tmp609_ = vala_member_access_get_type_arguments (_tmp608_);
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp607_, _tmp609_, (ValaCodeNode*) expr, FALSE, NULL);
			}
		}
	}
	_tmp610_ = ccall;
	_tmp611_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp610_);
	ccall_expr = _tmp611_;
	_tmp613_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp613_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaCodeContext* _tmp614_;
		ValaCodeContext* _tmp615_;
		ValaProfile _tmp616_;
		ValaProfile _tmp617_;
		_tmp614_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp615_ = _tmp614_;
		_tmp616_ = vala_code_context_get_profile (_tmp615_);
		_tmp617_ = _tmp616_;
		_tmp612_ = _tmp617_ != VALA_PROFILE_POSIX;
	} else {
		_tmp612_ = FALSE;
	}
	if (_tmp612_) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp618_;
		ValaExpression* _tmp619_;
		ValaExpression* _tmp620_;
		ValaDataType* _tmp621_;
		ValaDataType* _tmp622_;
		ValaArrayType* _tmp623_;
		ValaHashMap* _tmp624_;
		ValaArrayType* _tmp625_;
		ValaDataType* _tmp626_;
		ValaDataType* _tmp627_;
		gchar* _tmp628_;
		gchar* _tmp629_;
		ValaCCodeIdentifier* _tmp630_;
		ValaCCodeIdentifier* _tmp631_;
		_tmp618_ = ma;
		_tmp619_ = vala_member_access_get_inner (_tmp618_);
		_tmp620_ = _tmp619_;
		_tmp621_ = vala_expression_get_value_type (_tmp620_);
		_tmp622_ = _tmp621_;
		_tmp623_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp622_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp623_;
		_tmp624_ = in_arg_map;
		_tmp625_ = array_type;
		_tmp626_ = vala_array_type_get_element_type (_tmp625_);
		_tmp627_ = _tmp626_;
		_tmp628_ = vala_get_ccode_name ((ValaCodeNode*) _tmp627_);
		_tmp629_ = _tmp628_;
		_tmp630_ = vala_ccode_identifier_new (_tmp629_);
		_tmp631_ = _tmp630_;
		vala_map_set ((ValaMap*) _tmp624_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp631_);
		_vala_ccode_node_unref0 (_tmp631_);
		_g_free0 (_tmp629_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp632_;
		_tmp632_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp632_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp633_;
			_tmp633_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp633_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp634_;
				ValaExpression* _tmp635_;
				ValaExpression* _tmp636_;
				ValaTargetValue* _tmp637_;
				ValaTargetValue* _tmp638_;
				ValaTargetValue* _tmp639_;
				ValaTargetValue* _tmp640_;
				_tmp634_ = ma;
				_tmp635_ = vala_member_access_get_inner (_tmp634_);
				_tmp636_ = _tmp635_;
				_tmp637_ = vala_expression_get_target_value (_tmp636_);
				_tmp638_ = _tmp637_;
				_tmp639_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp638_, (ValaCodeNode*) expr);
				_tmp640_ = _tmp639_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp640_);
				_vala_target_value_unref0 (_tmp640_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp642_ = m;
	if (_tmp642_ != NULL) {
		ValaMethod* _tmp643_;
		gboolean _tmp644_;
		gboolean _tmp645_;
		_tmp643_ = m;
		_tmp644_ = vala_method_get_is_async_callback (_tmp643_);
		_tmp645_ = _tmp644_;
		_tmp641_ = _tmp645_;
	} else {
		_tmp641_ = FALSE;
	}
	if (_tmp641_) {
		ValaMethod* _tmp646_;
		ValaMethod* _tmp647_;
		gboolean _tmp648_;
		gboolean _tmp649_;
		ValaHashMap* _tmp663_;
		ValaMethod* _tmp664_;
		ValaCCodeExpression* _tmp665_;
		ValaHashMap* _tmp666_;
		ValaMethod* _tmp667_;
		ValaCCodeExpression* _tmp668_;
		_tmp646_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp647_ = _tmp646_;
		_tmp648_ = vala_method_get_closure (_tmp647_);
		_tmp649_ = _tmp648_;
		if (_tmp649_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp650_;
			ValaSymbol* _tmp651_;
			ValaSymbol* _tmp652_;
			ValaBlock* _tmp653_;
			ValaBlock* _tmp654_;
			ValaBlock* _tmp655_;
			ValaBlock* _tmp656_;
			gchar* _tmp657_;
			gchar* _tmp658_;
			ValaCCodeExpression* _tmp659_;
			ValaCCodeExpression* _tmp660_;
			ValaCCodeMemberAccess* _tmp661_;
			_tmp650_ = m;
			_tmp651_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp650_);
			_tmp652_ = _tmp651_;
			_tmp653_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp652_, VALA_TYPE_METHOD, ValaMethod));
			_tmp654_ = _tmp653_;
			_tmp655_ = _vala_code_node_ref0 (_tmp654_);
			block = _tmp655_;
			_tmp656_ = block;
			_tmp657_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp656_));
			_tmp658_ = _tmp657_;
			_tmp659_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp658_);
			_tmp660_ = _tmp659_;
			_tmp661_ = vala_ccode_member_access_new_pointer (_tmp660_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp661_;
			_vala_ccode_node_unref0 (_tmp660_);
			_g_free0 (_tmp658_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp662_;
			_tmp662_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp662_;
		}
		_tmp663_ = in_arg_map;
		_tmp664_ = m;
		_tmp665_ = instance;
		vala_map_set ((ValaMap*) _tmp663_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp664_), FALSE)), _tmp665_);
		_tmp666_ = out_arg_map;
		_tmp667_ = m;
		_tmp668_ = instance;
		vala_map_set ((ValaMap*) _tmp666_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp667_), FALSE)), _tmp668_);
	} else {
		gboolean _tmp669_ = FALSE;
		gboolean _tmp670_ = FALSE;
		ValaMethod* _tmp671_;
		_tmp671_ = m;
		if (_tmp671_ != NULL) {
			ValaMethod* _tmp672_;
			ValaMemberBinding _tmp673_;
			ValaMemberBinding _tmp674_;
			_tmp672_ = m;
			_tmp673_ = vala_method_get_binding (_tmp672_);
			_tmp674_ = _tmp673_;
			_tmp670_ = _tmp674_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp670_ = FALSE;
		}
		if (_tmp670_) {
			ValaMethod* _tmp675_;
			_tmp675_ = m;
			_tmp669_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp675_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp669_ = FALSE;
		}
		if (_tmp669_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp676_;
			ValaExpression* _tmp677_;
			ValaExpression* _tmp678_;
			ValaTargetValue* _tmp679_;
			ValaTargetValue* _tmp680_;
			ValaTargetValue* _tmp681_;
			gboolean _tmp682_ = FALSE;
			gboolean _tmp683_ = FALSE;
			ValaMemberAccess* _tmp684_;
			const gchar* _tmp685_;
			const gchar* _tmp686_;
			ValaTargetValue* _tmp708_;
			ValaCCodeExpression* _tmp709_;
			ValaCCodeExpression* _tmp710_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp711_;
			ValaSymbol* _tmp712_;
			ValaSymbol* _tmp713_;
			ValaStruct* _tmp714_;
			gboolean _tmp715_ = FALSE;
			ValaStruct* _tmp716_;
			ValaMethod* _tmp724_;
			gboolean _tmp725_;
			gboolean _tmp726_;
			_tmp676_ = ma;
			_tmp677_ = vala_member_access_get_inner (_tmp676_);
			_tmp678_ = _tmp677_;
			_tmp679_ = vala_expression_get_target_value (_tmp678_);
			_tmp680_ = _tmp679_;
			_tmp681_ = _vala_target_value_ref0 (_tmp680_);
			instance_value = _tmp681_;
			_tmp684_ = ma;
			_tmp685_ = vala_member_access_get_member_name (_tmp684_);
			_tmp686_ = _tmp685_;
			if (g_strcmp0 (_tmp686_, "begin") == 0) {
				_tmp683_ = TRUE;
			} else {
				ValaMemberAccess* _tmp687_;
				const gchar* _tmp688_;
				const gchar* _tmp689_;
				_tmp687_ = ma;
				_tmp688_ = vala_member_access_get_member_name (_tmp687_);
				_tmp689_ = _tmp688_;
				_tmp683_ = g_strcmp0 (_tmp689_, "end") == 0;
			}
			if (_tmp683_) {
				ValaMemberAccess* _tmp690_;
				ValaExpression* _tmp691_;
				ValaExpression* _tmp692_;
				ValaSymbol* _tmp693_;
				ValaSymbol* _tmp694_;
				ValaMemberAccess* _tmp695_;
				ValaSymbol* _tmp696_;
				ValaSymbol* _tmp697_;
				_tmp690_ = ma;
				_tmp691_ = vala_member_access_get_inner (_tmp690_);
				_tmp692_ = _tmp691_;
				_tmp693_ = vala_expression_get_symbol_reference (_tmp692_);
				_tmp694_ = _tmp693_;
				_tmp695_ = ma;
				_tmp696_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp695_);
				_tmp697_ = _tmp696_;
				_tmp682_ = _tmp694_ == _tmp697_;
			} else {
				_tmp682_ = FALSE;
			}
			if (_tmp682_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp698_;
				ValaExpression* _tmp699_;
				ValaExpression* _tmp700_;
				ValaMemberAccess* _tmp701_;
				ValaMemberAccess* _tmp702_;
				ValaExpression* _tmp703_;
				ValaExpression* _tmp704_;
				ValaTargetValue* _tmp705_;
				ValaTargetValue* _tmp706_;
				ValaTargetValue* _tmp707_;
				_tmp698_ = ma;
				_tmp699_ = vala_member_access_get_inner (_tmp698_);
				_tmp700_ = _tmp699_;
				_tmp701_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp700_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp701_;
				_tmp702_ = inner_ma;
				_tmp703_ = vala_member_access_get_inner (_tmp702_);
				_tmp704_ = _tmp703_;
				_tmp705_ = vala_expression_get_target_value (_tmp704_);
				_tmp706_ = _tmp705_;
				_tmp707_ = _vala_target_value_ref0 (_tmp706_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp707_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp708_ = instance_value;
			_tmp709_ = vala_get_cvalue_ (_tmp708_);
			_tmp710_ = _vala_ccode_node_ref0 (_tmp709_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp710_;
			_tmp711_ = m;
			_tmp712_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp711_);
			_tmp713_ = _tmp712_;
			_tmp714_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp713_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp713_) : NULL);
			st = _tmp714_;
			_tmp716_ = st;
			if (_tmp716_ != NULL) {
				ValaStruct* _tmp717_;
				_tmp717_ = st;
				_tmp715_ = !vala_struct_is_simple_type (_tmp717_);
			} else {
				_tmp715_ = FALSE;
			}
			if (_tmp715_) {
				ValaTargetValue* _tmp718_;
				ValaTargetValue* _tmp721_;
				ValaCCodeExpression* _tmp722_;
				ValaCCodeUnaryExpression* _tmp723_;
				_tmp718_ = instance_value;
				if (!vala_get_lvalue (_tmp718_)) {
					ValaTargetValue* _tmp719_;
					ValaTargetValue* _tmp720_;
					_tmp719_ = instance_value;
					_tmp720_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp719_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp720_;
				}
				_tmp721_ = instance_value;
				_tmp722_ = vala_get_cvalue_ (_tmp721_);
				_tmp723_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp722_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp723_;
			}
			_tmp724_ = m;
			_tmp725_ = vala_method_get_coroutine (_tmp724_);
			_tmp726_ = _tmp725_;
			if (!_tmp726_) {
				ValaHashMap* _tmp727_;
				ValaMethod* _tmp728_;
				ValaCCodeExpression* _tmp729_;
				_tmp727_ = in_arg_map;
				_tmp728_ = m;
				_tmp729_ = instance;
				vala_map_set ((ValaMap*) _tmp727_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp728_), FALSE)), _tmp729_);
			} else {
				gboolean _tmp730_;
				gboolean _tmp731_;
				_tmp730_ = vala_method_call_get_is_yield_expression (expr);
				_tmp731_ = _tmp730_;
				if (_tmp731_) {
					ValaHashMap* _tmp732_;
					ValaMethod* _tmp733_;
					ValaCCodeExpression* _tmp734_;
					ValaMethod* _tmp735_;
					_tmp732_ = in_arg_map;
					_tmp733_ = m;
					_tmp734_ = instance;
					vala_map_set ((ValaMap*) _tmp732_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp733_), FALSE)), _tmp734_);
					_tmp735_ = m;
					if (vala_get_ccode_finish_instance (_tmp735_)) {
						ValaHashMap* _tmp736_;
						ValaMethod* _tmp737_;
						ValaCCodeExpression* _tmp738_;
						_tmp736_ = out_arg_map;
						_tmp737_ = m;
						_tmp738_ = instance;
						vala_map_set ((ValaMap*) _tmp736_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp737_), FALSE)), _tmp738_);
					}
				} else {
					gboolean _tmp739_ = FALSE;
					ValaMemberAccess* _tmp740_;
					const gchar* _tmp741_;
					const gchar* _tmp742_;
					_tmp740_ = ma;
					_tmp741_ = vala_member_access_get_member_name (_tmp740_);
					_tmp742_ = _tmp741_;
					if (g_strcmp0 (_tmp742_, "end") != 0) {
						_tmp739_ = TRUE;
					} else {
						ValaMethod* _tmp743_;
						_tmp743_ = m;
						_tmp739_ = vala_get_ccode_finish_instance (_tmp743_);
					}
					if (_tmp739_) {
						ValaHashMap* _tmp744_;
						ValaMethod* _tmp745_;
						ValaCCodeExpression* _tmp746_;
						ValaHashMap* _tmp747_;
						ValaMethod* _tmp748_;
						ValaCCodeExpression* _tmp749_;
						_tmp744_ = out_arg_map;
						_tmp745_ = m;
						_tmp746_ = instance;
						vala_map_set ((ValaMap*) _tmp744_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp745_), FALSE)), _tmp746_);
						_tmp747_ = in_arg_map;
						_tmp748_ = m;
						_tmp749_ = instance;
						vala_map_set ((ValaMap*) _tmp747_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp748_), FALSE)), _tmp749_);
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp750_ = FALSE;
			ValaMethod* _tmp751_;
			_tmp751_ = m;
			if (_tmp751_ != NULL) {
				ValaMethod* _tmp752_;
				ValaMemberBinding _tmp753_;
				ValaMemberBinding _tmp754_;
				_tmp752_ = m;
				_tmp753_ = vala_method_get_binding (_tmp752_);
				_tmp754_ = _tmp753_;
				_tmp750_ = _tmp754_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp750_ = FALSE;
			}
			if (_tmp750_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp755_;
				ValaSymbol* _tmp756_;
				ValaSymbol* _tmp757_;
				ValaClass* _tmp758_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp759_;
				gchar* _tmp760_;
				gchar* _tmp761_;
				ValaCCodeIdentifier* _tmp762_;
				ValaCCodeIdentifier* _tmp763_;
				ValaCCodeFunctionCall* _tmp764_;
				ValaCCodeFunctionCall* _tmp765_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp766_;
				ValaExpression* _tmp767_;
				ValaExpression* _tmp768_;
				ValaCCodeFunctionCall* _tmp797_;
				ValaCCodeExpression* _tmp798_;
				ValaHashMap* _tmp799_;
				ValaMethod* _tmp800_;
				ValaCCodeFunctionCall* _tmp801_;
				ValaHashMap* _tmp802_;
				ValaMethod* _tmp803_;
				ValaCCodeFunctionCall* _tmp804_;
				_tmp755_ = m;
				_tmp756_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp755_);
				_tmp757_ = _tmp756_;
				_tmp758_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp757_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp758_;
				_tmp759_ = cl;
				_tmp760_ = vala_get_ccode_class_type_function (_tmp759_);
				_tmp761_ = _tmp760_;
				_tmp762_ = vala_ccode_identifier_new (_tmp761_);
				_tmp763_ = _tmp762_;
				_tmp764_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp763_);
				_tmp765_ = _tmp764_;
				_vala_ccode_node_unref0 (_tmp763_);
				_g_free0 (_tmp761_);
				cast = _tmp765_;
				_tmp766_ = ma;
				_tmp767_ = vala_member_access_get_inner (_tmp766_);
				_tmp768_ = _tmp767_;
				if (_tmp768_ == NULL) {
					ValaDataType* _tmp769_;
					_tmp769_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					if (_tmp769_ == NULL) {
						ValaCCodeIdentifier* _tmp770_;
						_tmp770_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp770_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaClass* _tmp771_;
						gchar* _tmp772_;
						gchar* _tmp773_;
						ValaCCodeIdentifier* _tmp774_;
						ValaCCodeIdentifier* _tmp775_;
						ValaCCodeFunctionCall* _tmp776_;
						ValaCCodeFunctionCall* _tmp777_;
						ValaCCodeFunctionCall* _tmp778_;
						ValaCCodeExpression* _tmp779_;
						ValaCCodeExpression* _tmp780_;
						ValaCCodeFunctionCall* _tmp781_;
						ValaCCodeExpression* _tmp782_;
						_tmp771_ = cl;
						_tmp772_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp771_);
						_tmp773_ = _tmp772_;
						_tmp774_ = vala_ccode_identifier_new (_tmp773_);
						_tmp775_ = _tmp774_;
						_tmp776_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp775_);
						_tmp777_ = _tmp776_;
						_vala_ccode_node_unref0 (_tmp775_);
						_g_free0 (_tmp773_);
						k = _tmp777_;
						_tmp778_ = k;
						_tmp779_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp780_ = _tmp779_;
						vala_ccode_function_call_add_argument (_tmp778_, _tmp780_);
						_vala_ccode_node_unref0 (_tmp780_);
						_tmp781_ = k;
						_tmp782_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp781_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp782_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaClass* _tmp783_;
					gchar* _tmp784_;
					gchar* _tmp785_;
					ValaCCodeIdentifier* _tmp786_;
					ValaCCodeIdentifier* _tmp787_;
					ValaCCodeFunctionCall* _tmp788_;
					ValaCCodeFunctionCall* _tmp789_;
					ValaCCodeFunctionCall* _tmp790_;
					ValaMemberAccess* _tmp791_;
					ValaExpression* _tmp792_;
					ValaExpression* _tmp793_;
					ValaCCodeExpression* _tmp794_;
					ValaCCodeFunctionCall* _tmp795_;
					ValaCCodeExpression* _tmp796_;
					_tmp783_ = cl;
					_tmp784_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp783_);
					_tmp785_ = _tmp784_;
					_tmp786_ = vala_ccode_identifier_new (_tmp785_);
					_tmp787_ = _tmp786_;
					_tmp788_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp787_);
					_tmp789_ = _tmp788_;
					_vala_ccode_node_unref0 (_tmp787_);
					_g_free0 (_tmp785_);
					k = _tmp789_;
					_tmp790_ = k;
					_tmp791_ = ma;
					_tmp792_ = vala_member_access_get_inner (_tmp791_);
					_tmp793_ = _tmp792_;
					_tmp794_ = vala_get_cvalue (_tmp793_);
					vala_ccode_function_call_add_argument (_tmp790_, _tmp794_);
					_tmp795_ = k;
					_tmp796_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp795_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp796_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp797_ = cast;
				_tmp798_ = klass;
				vala_ccode_function_call_add_argument (_tmp797_, _tmp798_);
				_tmp799_ = in_arg_map;
				_tmp800_ = m;
				_tmp801_ = cast;
				vala_map_set ((ValaMap*) _tmp799_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp800_), FALSE)), (ValaCCodeExpression*) _tmp801_);
				_tmp802_ = out_arg_map;
				_tmp803_ = m;
				_tmp804_ = cast;
				vala_map_set ((ValaMap*) _tmp802_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp803_), FALSE)), (ValaCCodeExpression*) _tmp804_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp806_ = m;
	if (_tmp806_ != NULL) {
		ValaMethod* _tmp807_;
		_tmp807_ = m;
		_tmp805_ = vala_get_ccode_has_generic_type_parameter (_tmp807_);
	} else {
		_tmp805_ = FALSE;
	}
	if (_tmp805_) {
		ValaMethod* _tmp808_;
		_tmp808_ = m;
		if (vala_method_has_type_parameters (_tmp808_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp809_;
				ValaList* _tmp810_;
				ValaList* _tmp811_;
				gint _type_arg_size = 0;
				ValaList* _tmp812_;
				gint _tmp813_;
				gint _tmp814_;
				gint _type_arg_index = 0;
				_tmp809_ = ma;
				_tmp810_ = vala_member_access_get_type_arguments (_tmp809_);
				_tmp811_ = _vala_iterable_ref0 (_tmp810_);
				_type_arg_list = _tmp811_;
				_tmp812_ = _type_arg_list;
				_tmp813_ = vala_collection_get_size ((ValaCollection*) _tmp812_);
				_tmp814_ = _tmp813_;
				_type_arg_size = _tmp814_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp815_;
					gint _tmp816_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp817_;
					gpointer _tmp818_;
					gboolean _tmp819_ = FALSE;
					gboolean _tmp820_ = FALSE;
					gboolean _tmp821_ = FALSE;
					ValaMethod* _tmp822_;
					ValaHashMap* _tmp830_;
					ValaMethod* _tmp831_;
					ValaDataType* _tmp832_;
					gchar* _tmp833_;
					gchar* _tmp834_;
					ValaCCodeIdentifier* _tmp835_;
					ValaCCodeIdentifier* _tmp836_;
					gint _tmp837_;
					_type_arg_index = _type_arg_index + 1;
					_tmp815_ = _type_arg_index;
					_tmp816_ = _type_arg_size;
					if (!(_tmp815_ < _tmp816_)) {
						break;
					}
					_tmp817_ = _type_arg_list;
					_tmp818_ = vala_list_get (_tmp817_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp818_;
					_tmp822_ = m;
					if (vala_get_ccode_simple_generics (_tmp822_)) {
						ValaDataType* _tmp823_;
						_tmp823_ = type_arg;
						_tmp821_ = vala_data_type_is_real_struct_type (_tmp823_);
					} else {
						_tmp821_ = FALSE;
					}
					if (_tmp821_) {
						ValaDataType* _tmp824_;
						gboolean _tmp825_;
						gboolean _tmp826_;
						_tmp824_ = type_arg;
						_tmp825_ = vala_data_type_get_nullable (_tmp824_);
						_tmp826_ = _tmp825_;
						_tmp820_ = !_tmp826_;
					} else {
						_tmp820_ = FALSE;
					}
					if (_tmp820_) {
						ValaDataType* _tmp827_;
						_tmp827_ = type_arg;
						_tmp819_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp827_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp819_ = FALSE;
					}
					if (_tmp819_) {
						ValaDataType* _tmp828_;
						ValaPointerType* _tmp829_;
						_tmp828_ = type_arg;
						_tmp829_ = vala_pointer_type_new (_tmp828_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp829_;
					}
					_tmp830_ = in_arg_map;
					_tmp831_ = m;
					_tmp832_ = type_arg;
					_tmp833_ = vala_get_ccode_name ((ValaCodeNode*) _tmp832_);
					_tmp834_ = _tmp833_;
					_tmp835_ = vala_ccode_identifier_new (_tmp834_);
					_tmp836_ = _tmp835_;
					vala_map_set ((ValaMap*) _tmp830_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp831_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp836_);
					_vala_ccode_node_unref0 (_tmp836_);
					_g_free0 (_tmp834_);
					_tmp837_ = type_param_index;
					type_param_index = _tmp837_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp838_;
				ValaExpression* _tmp839_;
				ValaExpression* _tmp840_;
				ValaDataType* _tmp841_;
				ValaDataType* _tmp842_;
				ValaList* _tmp843_;
				ValaList* _tmp844_;
				gint _type_arg_size = 0;
				ValaList* _tmp845_;
				gint _tmp846_;
				gint _tmp847_;
				gint _type_arg_index = 0;
				_tmp838_ = ma;
				_tmp839_ = vala_member_access_get_inner (_tmp838_);
				_tmp840_ = _tmp839_;
				_tmp841_ = vala_expression_get_value_type (_tmp840_);
				_tmp842_ = _tmp841_;
				_tmp843_ = vala_data_type_get_type_arguments (_tmp842_);
				_tmp844_ = _vala_iterable_ref0 (_tmp843_);
				_type_arg_list = _tmp844_;
				_tmp845_ = _type_arg_list;
				_tmp846_ = vala_collection_get_size ((ValaCollection*) _tmp845_);
				_tmp847_ = _tmp846_;
				_type_arg_size = _tmp847_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp848_;
					gint _tmp849_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp850_;
					gpointer _tmp851_;
					ValaHashMap* _tmp852_;
					ValaMethod* _tmp853_;
					ValaDataType* _tmp854_;
					gchar* _tmp855_;
					gchar* _tmp856_;
					ValaCCodeIdentifier* _tmp857_;
					ValaCCodeIdentifier* _tmp858_;
					gint _tmp859_;
					_type_arg_index = _type_arg_index + 1;
					_tmp848_ = _type_arg_index;
					_tmp849_ = _type_arg_size;
					if (!(_tmp848_ < _tmp849_)) {
						break;
					}
					_tmp850_ = _type_arg_list;
					_tmp851_ = vala_list_get (_tmp850_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp851_;
					_tmp852_ = in_arg_map;
					_tmp853_ = m;
					_tmp854_ = type_arg;
					_tmp855_ = vala_get_ccode_name ((ValaCodeNode*) _tmp854_);
					_tmp856_ = _tmp855_;
					_tmp857_ = vala_ccode_identifier_new (_tmp856_);
					_tmp858_ = _tmp857_;
					vala_map_set ((ValaMap*) _tmp852_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp853_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp858_);
					_vala_ccode_node_unref0 (_tmp858_);
					_g_free0 (_tmp856_);
					_tmp859_ = type_param_index;
					type_param_index = _tmp859_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp860_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp860_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp861_;
		ValaExpression* _tmp862_;
		ValaExpression* _tmp863_;
		ValaDataType* _tmp864_;
		ValaDataType* _tmp865_;
		ValaArrayType* _tmp866_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp867_;
		ValaCCodeIdentifier* _tmp868_;
		ValaCCodeFunctionCall* _tmp869_;
		ValaCCodeFunctionCall* _tmp870_;
		ValaCCodeFunctionCall* _tmp871_;
		ValaArrayType* _tmp872_;
		ValaDataType* _tmp873_;
		ValaDataType* _tmp874_;
		gchar* _tmp875_;
		gchar* _tmp876_;
		ValaCCodeIdentifier* _tmp877_;
		ValaCCodeIdentifier* _tmp878_;
		ValaHashMap* _tmp879_;
		ValaCCodeFunctionCall* _tmp880_;
		_tmp861_ = ma;
		_tmp862_ = vala_member_access_get_inner (_tmp861_);
		_tmp863_ = _tmp862_;
		_tmp864_ = vala_expression_get_value_type (_tmp863_);
		_tmp865_ = _tmp864_;
		_tmp866_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp865_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp866_;
		_tmp867_ = vala_ccode_identifier_new ("sizeof");
		_tmp868_ = _tmp867_;
		_tmp869_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp868_);
		_tmp870_ = _tmp869_;
		_vala_ccode_node_unref0 (_tmp868_);
		csizeof = _tmp870_;
		_tmp871_ = csizeof;
		_tmp872_ = array_type;
		_tmp873_ = vala_array_type_get_element_type (_tmp872_);
		_tmp874_ = _tmp873_;
		_tmp875_ = vala_get_ccode_name ((ValaCodeNode*) _tmp874_);
		_tmp876_ = _tmp875_;
		_tmp877_ = vala_ccode_identifier_new (_tmp876_);
		_tmp878_ = _tmp877_;
		vala_ccode_function_call_add_argument (_tmp871_, (ValaCCodeExpression*) _tmp878_);
		_vala_ccode_node_unref0 (_tmp878_);
		_g_free0 (_tmp876_);
		_tmp879_ = in_arg_map;
		_tmp880_ = csizeof;
		vala_map_set ((ValaMap*) _tmp879_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp880_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp881_;
		_tmp881_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp881_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp882_;
			ValaMethod* _tmp883_;
			ValaMethod* _tmp884_;
			gint param_nr = 0;
			ValaMethod* _tmp950_;
			ValaCCodeBaseModuleEmitContext* _tmp951_;
			_tmp882_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp883_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp882_, (ValaSymbol*) _tmp883_);
			_tmp884_ = m;
			vala_method_clear_parameters (_tmp884_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp885_;
				ValaList* _tmp886_;
				gint _arg_size = 0;
				ValaList* _tmp887_;
				gint _tmp888_;
				gint _tmp889_;
				gint _arg_index = 0;
				_tmp885_ = vala_method_call_get_argument_list (expr);
				_tmp886_ = _vala_iterable_ref0 (_tmp885_);
				_arg_list = _tmp886_;
				_tmp887_ = _arg_list;
				_tmp888_ = vala_collection_get_size ((ValaCollection*) _tmp887_);
				_tmp889_ = _tmp888_;
				_arg_size = _tmp889_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp890_;
					gint _tmp891_;
					ValaExpression* arg = NULL;
					ValaList* _tmp892_;
					gpointer _tmp893_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp894_;
					ValaUnaryExpression* _tmp895_;
					gboolean _tmp896_ = FALSE;
					ValaUnaryExpression* _tmp897_;
					gint _tmp938_;
					_arg_index = _arg_index + 1;
					_tmp890_ = _arg_index;
					_tmp891_ = _arg_size;
					if (!(_tmp890_ < _tmp891_)) {
						break;
					}
					_tmp892_ = _arg_list;
					_tmp893_ = vala_list_get (_tmp892_, _arg_index);
					arg = (ValaExpression*) _tmp893_;
					_tmp894_ = arg;
					_tmp895_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp894_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp894_) : NULL);
					unary = _tmp895_;
					_tmp897_ = unary;
					if (_tmp897_ != NULL) {
						ValaUnaryExpression* _tmp898_;
						ValaUnaryOperator _tmp899_;
						ValaUnaryOperator _tmp900_;
						_tmp898_ = unary;
						_tmp899_ = vala_unary_expression_get_operator (_tmp898_);
						_tmp900_ = _tmp899_;
						_tmp896_ = _tmp900_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp896_ = FALSE;
					}
					if (_tmp896_) {
						ValaParameter* param = NULL;
						gchar* _tmp901_;
						gchar* _tmp902_;
						ValaUnaryExpression* _tmp903_;
						ValaExpression* _tmp904_;
						ValaExpression* _tmp905_;
						ValaDataType* _tmp906_;
						ValaDataType* _tmp907_;
						ValaParameter* _tmp908_;
						ValaParameter* _tmp909_;
						ValaParameter* _tmp910_;
						ValaMethod* _tmp911_;
						ValaParameter* _tmp912_;
						_tmp901_ = g_strdup_printf ("param%d", param_nr);
						_tmp902_ = _tmp901_;
						_tmp903_ = unary;
						_tmp904_ = vala_unary_expression_get_inner (_tmp903_);
						_tmp905_ = _tmp904_;
						_tmp906_ = vala_expression_get_value_type (_tmp905_);
						_tmp907_ = _tmp906_;
						_tmp908_ = vala_parameter_new (_tmp902_, _tmp907_, NULL);
						_tmp909_ = _tmp908_;
						_g_free0 (_tmp902_);
						param = _tmp909_;
						_tmp910_ = param;
						vala_parameter_set_direction (_tmp910_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp911_ = m;
						_tmp912_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp911_, _tmp912_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp913_ = FALSE;
						ValaUnaryExpression* _tmp914_;
						_tmp914_ = unary;
						if (_tmp914_ != NULL) {
							ValaUnaryExpression* _tmp915_;
							ValaUnaryOperator _tmp916_;
							ValaUnaryOperator _tmp917_;
							_tmp915_ = unary;
							_tmp916_ = vala_unary_expression_get_operator (_tmp915_);
							_tmp917_ = _tmp916_;
							_tmp913_ = _tmp917_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp913_ = FALSE;
						}
						if (_tmp913_) {
							ValaParameter* param = NULL;
							gchar* _tmp918_;
							gchar* _tmp919_;
							ValaUnaryExpression* _tmp920_;
							ValaExpression* _tmp921_;
							ValaExpression* _tmp922_;
							ValaDataType* _tmp923_;
							ValaDataType* _tmp924_;
							ValaParameter* _tmp925_;
							ValaParameter* _tmp926_;
							ValaParameter* _tmp927_;
							ValaMethod* _tmp928_;
							ValaParameter* _tmp929_;
							_tmp918_ = g_strdup_printf ("param%d", param_nr);
							_tmp919_ = _tmp918_;
							_tmp920_ = unary;
							_tmp921_ = vala_unary_expression_get_inner (_tmp920_);
							_tmp922_ = _tmp921_;
							_tmp923_ = vala_expression_get_value_type (_tmp922_);
							_tmp924_ = _tmp923_;
							_tmp925_ = vala_parameter_new (_tmp919_, _tmp924_, NULL);
							_tmp926_ = _tmp925_;
							_g_free0 (_tmp919_);
							param = _tmp926_;
							_tmp927_ = param;
							vala_parameter_set_direction (_tmp927_, VALA_PARAMETER_DIRECTION_REF);
							_tmp928_ = m;
							_tmp929_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp928_, _tmp929_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp930_;
							gchar* _tmp931_;
							gchar* _tmp932_;
							ValaExpression* _tmp933_;
							ValaDataType* _tmp934_;
							ValaDataType* _tmp935_;
							ValaParameter* _tmp936_;
							ValaParameter* _tmp937_;
							_tmp930_ = m;
							_tmp931_ = g_strdup_printf ("param%d", param_nr);
							_tmp932_ = _tmp931_;
							_tmp933_ = arg;
							_tmp934_ = vala_expression_get_value_type (_tmp933_);
							_tmp935_ = _tmp934_;
							_tmp936_ = vala_parameter_new (_tmp932_, _tmp935_, NULL);
							_tmp937_ = _tmp936_;
							vala_callable_add_parameter ((ValaCallable*) _tmp930_, _tmp937_);
							_vala_code_node_unref0 (_tmp937_);
							_g_free0 (_tmp932_);
						}
					}
					_tmp938_ = param_nr;
					param_nr = _tmp938_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp939_;
				ValaList* _tmp940_;
				ValaList* _tmp941_;
				gint _param_size = 0;
				ValaList* _tmp942_;
				gint _tmp943_;
				gint _tmp944_;
				gint _param_index = 0;
				_tmp939_ = m;
				_tmp940_ = vala_callable_get_parameters ((ValaCallable*) _tmp939_);
				_tmp941_ = _vala_iterable_ref0 (_tmp940_);
				_param_list = _tmp941_;
				_tmp942_ = _param_list;
				_tmp943_ = vala_collection_get_size ((ValaCollection*) _tmp942_);
				_tmp944_ = _tmp943_;
				_param_size = _tmp944_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp945_;
					gint _tmp946_;
					ValaParameter* param = NULL;
					ValaList* _tmp947_;
					gpointer _tmp948_;
					ValaParameter* _tmp949_;
					_param_index = _param_index + 1;
					_tmp945_ = _param_index;
					_tmp946_ = _param_size;
					if (!(_tmp945_ < _tmp946_)) {
						break;
					}
					_tmp947_ = _param_list;
					_tmp948_ = vala_list_get (_tmp947_, _param_index);
					param = (ValaParameter*) _tmp948_;
					_tmp949_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp949_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp950_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp950_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp951_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp951_);
		} else {
			gboolean _tmp952_ = FALSE;
			gboolean _tmp953_ = FALSE;
			ValaMethod* _tmp954_;
			_tmp954_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp954_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp955_;
				ValaCodeContext* _tmp956_;
				ValaProfile _tmp957_;
				ValaProfile _tmp958_;
				_tmp955_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp956_ = _tmp955_;
				_tmp957_ = vala_code_context_get_profile (_tmp956_);
				_tmp958_ = _tmp957_;
				_tmp953_ = _tmp958_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp953_ = FALSE;
			}
			if (_tmp953_) {
				ValaMethod* _tmp959_;
				ValaSymbol* _tmp960_;
				ValaSymbol* _tmp961_;
				_tmp959_ = m;
				_tmp960_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp959_);
				_tmp961_ = _tmp960_;
				_tmp952_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp961_, VALA_TYPE_CLASS);
			} else {
				_tmp952_ = FALSE;
			}
			if (_tmp952_) {
				ValaCCodeFunction* _tmp962_;
				ValaCCodeFunction* _tmp963_;
				ValaCCodeExpression* _tmp964_;
				ValaCCodeExpression* _tmp965_;
				ValaCCodeFunctionCall* _tmp966_;
				ValaClass* _tmp967_;
				ValaClass* _tmp968_;
				gchar* _tmp969_;
				gchar* _tmp970_;
				gchar* _tmp971_;
				gchar* _tmp972_;
				ValaCCodeCastExpression* _tmp973_;
				ValaCCodeCastExpression* _tmp974_;
				ValaMethod* _tmp975_;
				ValaMethod* _tmp976_;
				ValaBlock* _tmp977_;
				ValaBlock* _tmp978_;
				gboolean _tmp979_;
				gboolean _tmp980_;
				gboolean _tmp1007_ = FALSE;
				ValaClass* _tmp1008_;
				ValaClass* _tmp1009_;
				gboolean _tmp1010_;
				gboolean _tmp1011_;
				_tmp962_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp963_ = _tmp962_;
				_tmp964_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp965_ = _tmp964_;
				_tmp966_ = ccall;
				_tmp967_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp968_ = _tmp967_;
				_tmp969_ = vala_get_ccode_name ((ValaCodeNode*) _tmp968_);
				_tmp970_ = _tmp969_;
				_tmp971_ = g_strconcat (_tmp970_, "*", NULL);
				_tmp972_ = _tmp971_;
				_tmp973_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp966_, _tmp972_);
				_tmp974_ = _tmp973_;
				vala_ccode_function_add_assignment (_tmp963_, _tmp965_, (ValaCCodeExpression*) _tmp974_);
				_vala_ccode_node_unref0 (_tmp974_);
				_g_free0 (_tmp972_);
				_g_free0 (_tmp970_);
				_vala_ccode_node_unref0 (_tmp965_);
				_tmp975_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp976_ = _tmp975_;
				_tmp977_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp976_);
				_tmp978_ = _tmp977_;
				_tmp979_ = vala_block_get_captured (_tmp978_);
				_tmp980_ = _tmp979_;
				if (_tmp980_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp981_;
					ValaClass* _tmp982_;
					ValaObjectType* _tmp983_;
					ValaObjectType* _tmp984_;
					ValaSourceReference* _tmp985_;
					ValaSourceReference* _tmp986_;
					ValaCCodeExpression* _tmp987_;
					ValaCCodeExpression* _tmp988_;
					ValaCCodeFunctionCall* _tmp989_;
					ValaCCodeFunctionCall* _tmp990_;
					ValaCCodeFunctionCall* _tmp991_;
					ValaCCodeExpression* _tmp992_;
					ValaCCodeExpression* _tmp993_;
					ValaCCodeFunction* _tmp994_;
					ValaCCodeFunction* _tmp995_;
					ValaMethod* _tmp996_;
					ValaMethod* _tmp997_;
					ValaBlock* _tmp998_;
					ValaBlock* _tmp999_;
					gchar* _tmp1000_;
					gchar* _tmp1001_;
					ValaCCodeExpression* _tmp1002_;
					ValaCCodeExpression* _tmp1003_;
					ValaCCodeMemberAccess* _tmp1004_;
					ValaCCodeMemberAccess* _tmp1005_;
					ValaCCodeFunctionCall* _tmp1006_;
					_tmp981_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp982_ = _tmp981_;
					_tmp983_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp982_);
					_tmp984_ = _tmp983_;
					_tmp985_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp986_ = _tmp985_;
					_tmp987_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp984_, _tmp986_, FALSE);
					_tmp988_ = _tmp987_;
					_tmp989_ = vala_ccode_function_call_new (_tmp988_);
					_tmp990_ = _tmp989_;
					_vala_ccode_node_unref0 (_tmp988_);
					_vala_code_node_unref0 (_tmp984_);
					ref_call = _tmp990_;
					_tmp991_ = ref_call;
					_tmp992_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp993_ = _tmp992_;
					vala_ccode_function_call_add_argument (_tmp991_, _tmp993_);
					_vala_ccode_node_unref0 (_tmp993_);
					_tmp994_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp995_ = _tmp994_;
					_tmp996_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp997_ = _tmp996_;
					_tmp998_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp997_);
					_tmp999_ = _tmp998_;
					_tmp1000_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp999_));
					_tmp1001_ = _tmp1000_;
					_tmp1002_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1001_);
					_tmp1003_ = _tmp1002_;
					_tmp1004_ = vala_ccode_member_access_new_pointer (_tmp1003_, "self");
					_tmp1005_ = _tmp1004_;
					_tmp1006_ = ref_call;
					vala_ccode_function_add_assignment (_tmp995_, (ValaCCodeExpression*) _tmp1005_, (ValaCCodeExpression*) _tmp1006_);
					_vala_ccode_node_unref0 (_tmp1005_);
					_vala_ccode_node_unref0 (_tmp1003_);
					_g_free0 (_tmp1001_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp1008_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp1009_ = _tmp1008_;
				_tmp1010_ = vala_class_get_is_compact (_tmp1009_);
				_tmp1011_ = _tmp1010_;
				if (!_tmp1011_) {
					ValaClass* _tmp1012_;
					ValaClass* _tmp1013_;
					_tmp1012_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp1013_ = _tmp1012_;
					_tmp1007_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp1013_);
				} else {
					_tmp1007_ = FALSE;
				}
				if (_tmp1007_) {
					gchar** suffices = NULL;
					gchar* _tmp1014_;
					gchar* _tmp1015_;
					gchar* _tmp1016_;
					gchar** _tmp1017_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp1014_ = g_strdup ("type");
					_tmp1015_ = g_strdup ("dup_func");
					_tmp1016_ = g_strdup ("destroy_func");
					_tmp1017_ = g_new0 (gchar*, 3 + 1);
					_tmp1017_[0] = _tmp1014_;
					_tmp1017_[1] = _tmp1015_;
					_tmp1017_[2] = _tmp1016_;
					suffices = _tmp1017_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp1018_;
						ValaClass* _tmp1019_;
						ValaList* _tmp1020_;
						ValaList* _tmp1021_;
						gint _type_param_size = 0;
						ValaList* _tmp1022_;
						gint _tmp1023_;
						gint _tmp1024_;
						gint _type_param_index = 0;
						_tmp1018_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp1019_ = _tmp1018_;
						_tmp1020_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp1019_);
						_tmp1021_ = _vala_iterable_ref0 (_tmp1020_);
						_type_param_list = _tmp1021_;
						_tmp1022_ = _type_param_list;
						_tmp1023_ = vala_collection_get_size ((ValaCollection*) _tmp1022_);
						_tmp1024_ = _tmp1023_;
						_type_param_size = _tmp1024_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp1025_;
							gint _tmp1026_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp1027_;
							gpointer _tmp1028_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp1029_;
							ValaCCodeIdentifier* _tmp1030_;
							ValaCCodeMemberAccess* _tmp1031_;
							ValaCCodeMemberAccess* _tmp1032_;
							gchar** _tmp1033_;
							gint _tmp1033__length1;
							_type_param_index = _type_param_index + 1;
							_tmp1025_ = _type_param_index;
							_tmp1026_ = _type_param_size;
							if (!(_tmp1025_ < _tmp1026_)) {
								break;
							}
							_tmp1027_ = _type_param_list;
							_tmp1028_ = vala_list_get (_tmp1027_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp1028_;
							_tmp1029_ = vala_ccode_identifier_new ("self");
							_tmp1030_ = _tmp1029_;
							_tmp1031_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1030_, "priv");
							_tmp1032_ = _tmp1031_;
							_vala_ccode_node_unref0 (_tmp1030_);
							priv_access = _tmp1032_;
							_tmp1033_ = suffices;
							_tmp1033__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp1033_;
								suffix_collection_length1 = _tmp1033__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp1034_;
									gchar* suffix = NULL;
									_tmp1034_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp1034_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp1035_;
										const gchar* _tmp1036_;
										const gchar* _tmp1037_;
										gchar* _tmp1038_;
										gchar* _tmp1039_;
										const gchar* _tmp1040_;
										gchar* _tmp1041_;
										gchar* _tmp1042_;
										ValaCCodeIdentifier* _tmp1043_;
										ValaCCodeIdentifier* _tmp1044_;
										ValaCCodeFunction* _tmp1045_;
										ValaCCodeFunction* _tmp1046_;
										ValaCCodeMemberAccess* _tmp1047_;
										ValaCCodeIdentifier* _tmp1048_;
										const gchar* _tmp1049_;
										const gchar* _tmp1050_;
										ValaCCodeMemberAccess* _tmp1051_;
										ValaCCodeMemberAccess* _tmp1052_;
										ValaCCodeIdentifier* _tmp1053_;
										_tmp1035_ = type_param;
										_tmp1036_ = vala_symbol_get_name ((ValaSymbol*) _tmp1035_);
										_tmp1037_ = _tmp1036_;
										_tmp1038_ = g_ascii_strdown (_tmp1037_, (gssize) -1);
										_tmp1039_ = _tmp1038_;
										_tmp1040_ = suffix;
										_tmp1041_ = g_strdup_printf ("%s_%s", _tmp1039_, _tmp1040_);
										_tmp1042_ = _tmp1041_;
										_tmp1043_ = vala_ccode_identifier_new (_tmp1042_);
										_tmp1044_ = _tmp1043_;
										_g_free0 (_tmp1042_);
										_g_free0 (_tmp1039_);
										param_name = _tmp1044_;
										_tmp1045_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp1046_ = _tmp1045_;
										_tmp1047_ = priv_access;
										_tmp1048_ = param_name;
										_tmp1049_ = vala_ccode_identifier_get_name (_tmp1048_);
										_tmp1050_ = _tmp1049_;
										_tmp1051_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1047_, _tmp1050_);
										_tmp1052_ = _tmp1051_;
										_tmp1053_ = param_name;
										vala_ccode_function_add_assignment (_tmp1046_, (ValaCCodeExpression*) _tmp1052_, (ValaCCodeExpression*) _tmp1053_);
										_vala_ccode_node_unref0 (_tmp1052_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp1054_ = params;
	_tmp1055_ = vala_iterable_iterator ((ValaIterable*) _tmp1054_);
	params_it = _tmp1055_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1056_;
		ValaList* _tmp1057_;
		gint _arg_size = 0;
		ValaList* _tmp1058_;
		gint _tmp1059_;
		gint _tmp1060_;
		gint _arg_index = 0;
		_tmp1056_ = vala_method_call_get_argument_list (expr);
		_tmp1057_ = _vala_iterable_ref0 (_tmp1056_);
		_arg_list = _tmp1057_;
		_tmp1058_ = _arg_list;
		_tmp1059_ = vala_collection_get_size ((ValaCollection*) _tmp1058_);
		_tmp1060_ = _tmp1059_;
		_arg_size = _tmp1060_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp1061_;
			gint _tmp1062_;
			ValaExpression* arg = NULL;
			ValaList* _tmp1063_;
			gpointer _tmp1064_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp1065_;
			ValaCCodeExpression* _tmp1066_;
			ValaCCodeExpression* _tmp1067_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp1068_;
			ValaHashMap* _tmp1069_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1070_;
			gboolean _tmp1080_ = FALSE;
			ValaParameter* _tmp1081_;
			gdouble _tmp1425_ = 0.0;
			gboolean _tmp1426_ = FALSE;
			ValaParameter* _tmp1427_;
			ValaHashMap* _tmp1429_;
			ValaCCodeExpression* _tmp1430_;
			gboolean _tmp1431_ = FALSE;
			ValaMethod* _tmp1432_;
			gboolean _tmp1457_ = FALSE;
			ValaExpression* _tmp1458_;
			gint _tmp1475_;
			_arg_index = _arg_index + 1;
			_tmp1061_ = _arg_index;
			_tmp1062_ = _arg_size;
			if (!(_tmp1061_ < _tmp1062_)) {
				break;
			}
			_tmp1063_ = _arg_list;
			_tmp1064_ = vala_list_get (_tmp1063_, _arg_index);
			arg = (ValaExpression*) _tmp1064_;
			_tmp1065_ = arg;
			_tmp1066_ = vala_get_cvalue (_tmp1065_);
			_tmp1067_ = _vala_ccode_node_ref0 (_tmp1066_);
			cexpr = _tmp1067_;
			_tmp1068_ = in_arg_map;
			_tmp1069_ = _vala_map_ref0 (_tmp1068_);
			carg_map = _tmp1069_;
			param = NULL;
			_tmp1070_ = params_it;
			if (vala_iterator_next (_tmp1070_)) {
				ValaIterator* _tmp1071_;
				gpointer _tmp1072_;
				gboolean _tmp1073_ = FALSE;
				ValaParameter* _tmp1074_;
				gboolean _tmp1075_;
				gboolean _tmp1076_;
				_tmp1071_ = params_it;
				_tmp1072_ = vala_iterator_get (_tmp1071_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1072_;
				_tmp1074_ = param;
				_tmp1075_ = vala_parameter_get_params_array (_tmp1074_);
				_tmp1076_ = _tmp1075_;
				if (_tmp1076_) {
					_tmp1073_ = TRUE;
				} else {
					ValaParameter* _tmp1077_;
					gboolean _tmp1078_;
					gboolean _tmp1079_;
					_tmp1077_ = param;
					_tmp1078_ = vala_parameter_get_ellipsis (_tmp1077_);
					_tmp1079_ = _tmp1078_;
					_tmp1073_ = _tmp1079_;
				}
				ellipsis = _tmp1073_;
			}
			_tmp1081_ = param;
			if (_tmp1081_ != NULL) {
				_tmp1080_ = !ellipsis;
			} else {
				_tmp1080_ = FALSE;
			}
			if (_tmp1080_) {
				ValaParameter* _tmp1082_;
				ValaParameterDirection _tmp1083_;
				ValaParameterDirection _tmp1084_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1087_;
				ValaUnaryExpression* _tmp1088_;
				gboolean _tmp1089_ = FALSE;
				ValaUnaryExpression* _tmp1090_;
				ValaParameter* _tmp1355_;
				gchar* _tmp1356_;
				gchar* _tmp1357_;
				gboolean _tmp1358_;
				_tmp1082_ = param;
				_tmp1083_ = vala_parameter_get_direction (_tmp1082_);
				_tmp1084_ = _tmp1083_;
				if (_tmp1084_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp1085_;
					ValaHashMap* _tmp1086_;
					_tmp1085_ = out_arg_map;
					_tmp1086_ = _vala_map_ref0 (_tmp1085_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1086_;
				}
				_tmp1087_ = arg;
				_tmp1088_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1087_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1087_) : NULL);
				unary = _tmp1088_;
				_tmp1090_ = unary;
				if (_tmp1090_ == NULL) {
					_tmp1089_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp1091_;
					ValaUnaryOperator _tmp1092_;
					ValaUnaryOperator _tmp1093_;
					_tmp1091_ = unary;
					_tmp1092_ = vala_unary_expression_get_operator (_tmp1091_);
					_tmp1093_ = _tmp1092_;
					_tmp1089_ = _tmp1093_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp1089_) {
					gboolean _tmp1094_ = FALSE;
					gboolean _tmp1095_ = FALSE;
					ValaParameter* _tmp1096_;
					ValaParameter* _tmp1238_;
					ValaExpression* _tmp1239_;
					ValaCCodeExpression* _tmp1240_;
					ValaCCodeExpression* _tmp1241_;
					_tmp1096_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1096_)) {
						ValaParameter* _tmp1097_;
						ValaDataType* _tmp1098_;
						ValaDataType* _tmp1099_;
						_tmp1097_ = param;
						_tmp1098_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1097_);
						_tmp1099_ = _tmp1098_;
						_tmp1095_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1099_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1095_ = FALSE;
					}
					if (_tmp1095_) {
						ValaParameter* _tmp1100_;
						ValaDataType* _tmp1101_;
						ValaDataType* _tmp1102_;
						gboolean _tmp1103_;
						gboolean _tmp1104_;
						_tmp1100_ = param;
						_tmp1101_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1100_);
						_tmp1102_ = _tmp1101_;
						_tmp1103_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1102_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1104_ = _tmp1103_;
						_tmp1094_ = !_tmp1104_;
					} else {
						_tmp1094_ = FALSE;
					}
					if (_tmp1094_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1105_;
						ValaDataType* _tmp1106_;
						ValaDataType* _tmp1107_;
						ValaArrayType* _tmp1108_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1109_;
						gchar* _tmp1110_;
						gboolean _tmp1111_ = FALSE;
						ValaUnaryExpression* _tmp1112_;
						_tmp1105_ = param;
						_tmp1106_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1105_);
						_tmp1107_ = _tmp1106_;
						_tmp1108_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1107_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1108_;
						_tmp1109_ = param;
						_tmp1110_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1109_);
						length_ctype = _tmp1110_;
						_tmp1112_ = unary;
						if (_tmp1112_ != NULL) {
							ValaUnaryExpression* _tmp1113_;
							ValaUnaryOperator _tmp1114_;
							ValaUnaryOperator _tmp1115_;
							_tmp1113_ = unary;
							_tmp1114_ = vala_unary_expression_get_operator (_tmp1113_);
							_tmp1115_ = _tmp1114_;
							_tmp1111_ = _tmp1115_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp1111_ = FALSE;
						}
						if (_tmp1111_) {
							const gchar* _tmp1116_;
							gchar* _tmp1117_;
							_tmp1116_ = length_ctype;
							_tmp1117_ = g_strdup_printf ("%s*", _tmp1116_);
							_g_free0 (length_ctype);
							length_ctype = _tmp1117_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1118_ = FALSE;
								_tmp1118_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1120_;
									gint _tmp1121_;
									gint _tmp1122_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp1123_;
									ValaCCodeExpression* _tmp1124_;
									ValaCCodeExpression* _tmp1125_;
									const gchar* _tmp1126_;
									ValaCCodeCastExpression* _tmp1127_;
									ValaCCodeCastExpression* _tmp1128_;
									ValaHashMap* _tmp1129_;
									ValaParameter* _tmp1130_;
									ValaCCodeCastExpression* _tmp1131_;
									if (!_tmp1118_) {
										gint _tmp1119_;
										_tmp1119_ = dim;
										dim = _tmp1119_ + 1;
									}
									_tmp1118_ = FALSE;
									_tmp1120_ = array_type;
									_tmp1121_ = vala_array_type_get_rank (_tmp1120_);
									_tmp1122_ = _tmp1121_;
									if (!(dim <= _tmp1122_)) {
										break;
									}
									_tmp1123_ = arg;
									_tmp1124_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1123_, dim);
									_tmp1125_ = _tmp1124_;
									_tmp1126_ = length_ctype;
									_tmp1127_ = vala_ccode_cast_expression_new (_tmp1125_, _tmp1126_);
									_tmp1128_ = _tmp1127_;
									_vala_ccode_node_unref0 (_tmp1125_);
									array_length_expr = _tmp1128_;
									_tmp1129_ = carg_map;
									_tmp1130_ = param;
									_tmp1131_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp1129_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1130_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1131_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1132_ = FALSE;
						ValaParameter* _tmp1133_;
						_tmp1133_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1133_)) {
							ValaParameter* _tmp1134_;
							ValaDataType* _tmp1135_;
							ValaDataType* _tmp1136_;
							_tmp1134_ = param;
							_tmp1135_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1134_);
							_tmp1136_ = _tmp1135_;
							_tmp1132_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1136_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1132_ = FALSE;
						}
						if (_tmp1132_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1137_;
							ValaDataType* _tmp1138_;
							ValaDataType* _tmp1139_;
							ValaDelegateType* _tmp1140_;
							ValaDelegateType* _tmp1141_;
							ValaDelegate* _tmp1142_;
							ValaDelegate* _tmp1143_;
							gboolean _tmp1144_;
							gboolean _tmp1145_;
							_tmp1137_ = param;
							_tmp1138_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1137_);
							_tmp1139_ = _tmp1138_;
							_tmp1140_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1139_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1140_;
							_tmp1141_ = deleg_type;
							_tmp1142_ = vala_delegate_type_get_delegate_symbol (_tmp1141_);
							_tmp1143_ = _tmp1142_;
							_tmp1144_ = vala_delegate_get_has_target (_tmp1143_);
							_tmp1145_ = _tmp1144_;
							if (_tmp1145_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp1146_;
								ValaCCodeExpression* _tmp1147_ = NULL;
								ValaCCodeExpression* _tmp1148_;
								ValaCCodeExpression* _tmp1149_;
								ValaParameter* _tmp1150_;
								gchar* _tmp1151_;
								gchar* _tmp1152_;
								gboolean _tmp1153_;
								_tmp1146_ = arg;
								_tmp1148_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1146_, &_tmp1147_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1147_;
								delegate_target = _tmp1148_;
								_tmp1149_ = delegate_target;
								_vala_assert (_tmp1149_ != NULL, "delegate_target != null");
								_tmp1150_ = param;
								_tmp1151_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1150_);
								_tmp1152_ = _tmp1151_;
								_tmp1153_ = g_strcmp0 (_tmp1152_, "GClosure*") == 0;
								_g_free0 (_tmp1152_);
								if (_tmp1153_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp1154_;
									ValaCCodeIdentifier* _tmp1155_;
									ValaCCodeFunctionCall* _tmp1156_;
									ValaCCodeFunctionCall* _tmp1157_;
									ValaCCodeFunctionCall* _tmp1158_;
									ValaCCodeExpression* _tmp1159_;
									ValaCCodeCastExpression* _tmp1160_;
									ValaCCodeCastExpression* _tmp1161_;
									ValaCCodeFunctionCall* _tmp1162_;
									ValaCCodeExpression* _tmp1163_;
									ValaCCodeFunctionCall* _tmp1164_;
									ValaCCodeExpression* _tmp1165_;
									ValaCCodeCastExpression* _tmp1166_;
									ValaCCodeCastExpression* _tmp1167_;
									ValaCCodeExpression* _tmp1168_;
									ValaCCodeConstant* _tmp1169_;
									ValaCCodeConstant* _tmp1170_;
									ValaCCodeBinaryExpression* _tmp1171_;
									ValaCCodeBinaryExpression* _tmp1172_;
									ValaCCodeConstant* _tmp1173_;
									ValaCCodeConstant* _tmp1174_;
									ValaCCodeFunctionCall* _tmp1175_;
									ValaCCodeConditionalExpression* _tmp1176_;
									_tmp1154_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp1155_ = _tmp1154_;
									_tmp1156_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1155_);
									_tmp1157_ = _tmp1156_;
									_vala_ccode_node_unref0 (_tmp1155_);
									closure_new = _tmp1157_;
									_tmp1158_ = closure_new;
									_tmp1159_ = cexpr;
									_tmp1160_ = vala_ccode_cast_expression_new (_tmp1159_, "GCallback");
									_tmp1161_ = _tmp1160_;
									vala_ccode_function_call_add_argument (_tmp1158_, (ValaCCodeExpression*) _tmp1161_);
									_vala_ccode_node_unref0 (_tmp1161_);
									_tmp1162_ = closure_new;
									_tmp1163_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp1162_, _tmp1163_);
									_tmp1164_ = closure_new;
									_tmp1165_ = delegate_target_destroy_notify;
									_tmp1166_ = vala_ccode_cast_expression_new (_tmp1165_, "GClosureNotify");
									_tmp1167_ = _tmp1166_;
									vala_ccode_function_call_add_argument (_tmp1164_, (ValaCCodeExpression*) _tmp1167_);
									_vala_ccode_node_unref0 (_tmp1167_);
									_tmp1168_ = cexpr;
									_tmp1169_ = vala_ccode_constant_new ("NULL");
									_tmp1170_ = _tmp1169_;
									_tmp1171_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1168_, (ValaCCodeExpression*) _tmp1170_);
									_tmp1172_ = _tmp1171_;
									_tmp1173_ = vala_ccode_constant_new ("NULL");
									_tmp1174_ = _tmp1173_;
									_tmp1175_ = closure_new;
									_tmp1176_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1172_, (ValaCCodeExpression*) _tmp1174_, (ValaCCodeExpression*) _tmp1175_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1176_;
									_vala_ccode_node_unref0 (_tmp1174_);
									_vala_ccode_node_unref0 (_tmp1172_);
									_vala_ccode_node_unref0 (_tmp1170_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaCCodeExpression* node = NULL;
									ValaHashMap* _tmp1177_;
									ValaParameter* _tmp1178_;
									gpointer _tmp1179_;
									gboolean _tmp1180_ = FALSE;
									ValaCCodeExpression* _tmp1181_;
									_tmp1177_ = carg_map;
									_tmp1178_ = param;
									_tmp1179_ = vala_map_get ((ValaMap*) _tmp1177_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1178_), FALSE)));
									node = (ValaCCodeExpression*) _tmp1179_;
									_tmp1181_ = node;
									if (_tmp1181_ == NULL) {
										_tmp1180_ = TRUE;
									} else {
										gboolean _tmp1182_ = FALSE;
										ValaCCodeExpression* _tmp1183_;
										_tmp1183_ = node;
										if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1183_, VALA_TYPE_CCODE_CONSTANT)) {
											ValaCCodeExpression* _tmp1184_;
											const gchar* _tmp1185_;
											const gchar* _tmp1186_;
											_tmp1184_ = node;
											_tmp1185_ = vala_ccode_constant_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1184_, VALA_TYPE_CCODE_CONSTANT, ValaCCodeConstant));
											_tmp1186_ = _tmp1185_;
											_tmp1182_ = g_strcmp0 (_tmp1186_, "NULL") == 0;
										} else {
											_tmp1182_ = FALSE;
										}
										_tmp1180_ = _tmp1182_;
									}
									if (_tmp1180_) {
										ValaHashMap* _tmp1187_;
										ValaParameter* _tmp1188_;
										ValaCCodeExpression* _tmp1189_;
										ValaDelegateType* _tmp1190_;
										_tmp1187_ = carg_map;
										_tmp1188_ = param;
										_tmp1189_ = delegate_target;
										vala_map_set ((ValaMap*) _tmp1187_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1188_), FALSE)), _tmp1189_);
										_tmp1190_ = deleg_type;
										if (vala_data_type_is_disposable ((ValaDataType*) _tmp1190_)) {
											ValaCCodeExpression* _tmp1191_;
											ValaHashMap* _tmp1192_;
											ValaParameter* _tmp1193_;
											ValaCCodeExpression* _tmp1194_;
											_tmp1191_ = delegate_target_destroy_notify;
											_vala_assert (_tmp1191_ != NULL, "delegate_target_destroy_notify != null");
											_tmp1192_ = carg_map;
											_tmp1193_ = param;
											_tmp1194_ = delegate_target_destroy_notify;
											vala_map_set ((ValaMap*) _tmp1192_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1193_), FALSE)), _tmp1194_);
										}
									}
									_vala_ccode_node_unref0 (node);
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1195_;
							ValaDataType* _tmp1196_;
							ValaDataType* _tmp1197_;
							_tmp1195_ = param;
							_tmp1196_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1195_);
							_tmp1197_ = _tmp1196_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1197_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1198_;
								ValaParameter* _tmp1199_;
								ValaExpression* _tmp1200_;
								ValaCCodeExpression* _tmp1201_ = NULL;
								ValaCCodeExpression* _tmp1202_;
								ValaCCodeExpression* _tmp1203_;
								_tmp1198_ = carg_map;
								_tmp1199_ = param;
								_tmp1200_ = arg;
								_tmp1202_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1200_, &_tmp1201_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1201_;
								_tmp1203_ = _tmp1202_;
								vala_map_set ((ValaMap*) _tmp1198_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1199_), FALSE)), _tmp1203_);
								_vala_ccode_node_unref0 (_tmp1203_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1204_;
								ValaDataType* _tmp1205_;
								ValaDataType* _tmp1206_;
								_tmp1204_ = param;
								_tmp1205_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1204_);
								_tmp1206_ = _tmp1205_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1206_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1207_ = FALSE;
									ValaMethod* _tmp1208_;
									_tmp1208_ = m;
									if (_tmp1208_ != NULL) {
										ValaMethod* _tmp1209_;
										_tmp1209_ = m;
										_tmp1207_ = vala_get_ccode_simple_generics (_tmp1209_);
									} else {
										_tmp1207_ = FALSE;
									}
									if (_tmp1207_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1210_;
										ValaDataType* _tmp1211_;
										ValaDataType* _tmp1212_;
										ValaGenericType* _tmp1213_;
										gint type_param_index = 0;
										ValaMethod* _tmp1214_;
										ValaGenericType* _tmp1215_;
										ValaTypeParameter* _tmp1216_;
										ValaTypeParameter* _tmp1217_;
										const gchar* _tmp1218_;
										const gchar* _tmp1219_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1220_;
										ValaList* _tmp1221_;
										gpointer _tmp1222_;
										ValaParameter* _tmp1223_;
										ValaDataType* _tmp1224_;
										ValaDataType* _tmp1225_;
										gboolean _tmp1226_;
										gboolean _tmp1227_;
										_tmp1210_ = param;
										_tmp1211_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1210_);
										_tmp1212_ = _tmp1211_;
										_tmp1213_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1212_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1213_;
										_tmp1214_ = m;
										_tmp1215_ = generic_type;
										_tmp1216_ = vala_generic_type_get_type_parameter (_tmp1215_);
										_tmp1217_ = _tmp1216_;
										_tmp1218_ = vala_symbol_get_name ((ValaSymbol*) _tmp1217_);
										_tmp1219_ = _tmp1218_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1214_, _tmp1219_);
										_tmp1220_ = ma;
										_tmp1221_ = vala_member_access_get_type_arguments (_tmp1220_);
										_tmp1222_ = vala_list_get (_tmp1221_, type_param_index);
										type_arg = (ValaDataType*) _tmp1222_;
										_tmp1223_ = param;
										_tmp1224_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1223_);
										_tmp1225_ = _tmp1224_;
										_tmp1226_ = vala_data_type_get_value_owned (_tmp1225_);
										_tmp1227_ = _tmp1226_;
										if (_tmp1227_) {
											ValaDataType* _tmp1228_;
											_tmp1228_ = type_arg;
											if (vala_ccode_base_module_requires_copy (_tmp1228_)) {
												ValaHashMap* _tmp1229_;
												ValaParameter* _tmp1230_;
												ValaDataType* _tmp1231_;
												ValaCCodeExpression* _tmp1232_;
												ValaCCodeExpression* _tmp1233_;
												_tmp1229_ = carg_map;
												_tmp1230_ = param;
												_tmp1231_ = type_arg;
												_tmp1232_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1231_, FALSE);
												_tmp1233_ = _tmp1232_;
												vala_map_set ((ValaMap*) _tmp1229_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1230_), FALSE)), _tmp1233_);
												_vala_ccode_node_unref0 (_tmp1233_);
											} else {
												ValaHashMap* _tmp1234_;
												ValaParameter* _tmp1235_;
												ValaCCodeConstant* _tmp1236_;
												ValaCCodeConstant* _tmp1237_;
												_tmp1234_ = carg_map;
												_tmp1235_ = param;
												_tmp1236_ = vala_ccode_constant_new ("NULL");
												_tmp1237_ = _tmp1236_;
												vala_map_set ((ValaMap*) _tmp1234_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1235_), FALSE)), (ValaCCodeExpression*) _tmp1237_);
												_vala_ccode_node_unref0 (_tmp1237_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1238_ = param;
					_tmp1239_ = arg;
					_tmp1240_ = cexpr;
					_tmp1241_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1238_, _tmp1239_, _tmp1240_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1241_;
				} else {
					ValaExpression* _tmp1242_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1243_;
					ValaDataType* _tmp1244_;
					ValaDataType* _tmp1245_;
					ValaParameter* _tmp1246_;
					ValaDataType* _tmp1247_;
					ValaDataType* _tmp1248_;
					gboolean _tmp1249_;
					gboolean _tmp1250_;
					ValaLocalVariable* _tmp1251_;
					ValaLocalVariable* _tmp1252_;
					ValaExpression* _tmp1253_;
					ValaLocalVariable* _tmp1254_;
					const gchar* _tmp1255_;
					const gchar* _tmp1256_;
					ValaCCodeExpression* _tmp1257_;
					ValaCCodeExpression* _tmp1258_;
					ValaExpression* _tmp1259_;
					ValaTargetValue* _tmp1260_;
					ValaTargetValue* _tmp1261_;
					ValaExpression* _tmp1262_;
					ValaDataType* _tmp1263_;
					ValaDataType* _tmp1264_;
					ValaExpression* _tmp1265_;
					ValaCCodeExpression* _tmp1266_;
					ValaCCodeUnaryExpression* _tmp1267_;
					gboolean _tmp1268_ = FALSE;
					gboolean _tmp1269_ = FALSE;
					ValaParameter* _tmp1270_;
					_tmp1242_ = arg;
					vala_expression_set_target_value (_tmp1242_, NULL);
					_tmp1243_ = param;
					_tmp1244_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1243_);
					_tmp1245_ = _tmp1244_;
					_tmp1246_ = param;
					_tmp1247_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1246_);
					_tmp1248_ = _tmp1247_;
					_tmp1249_ = vala_data_type_get_value_owned (_tmp1248_);
					_tmp1250_ = _tmp1249_;
					_tmp1251_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1245_, _tmp1250_, NULL, TRUE);
					temp_var = _tmp1251_;
					_tmp1252_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1252_, FALSE);
					_tmp1253_ = arg;
					_tmp1254_ = temp_var;
					_tmp1255_ = vala_symbol_get_name ((ValaSymbol*) _tmp1254_);
					_tmp1256_ = _tmp1255_;
					_tmp1257_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1256_);
					_tmp1258_ = _tmp1257_;
					vala_set_cvalue (_tmp1253_, _tmp1258_);
					_vala_ccode_node_unref0 (_tmp1258_);
					_tmp1259_ = arg;
					_tmp1260_ = vala_expression_get_target_value (_tmp1259_);
					_tmp1261_ = _tmp1260_;
					_tmp1262_ = arg;
					_tmp1263_ = vala_expression_get_target_type (_tmp1262_);
					_tmp1264_ = _tmp1263_;
					vala_target_value_set_value_type (_tmp1261_, _tmp1264_);
					_tmp1265_ = arg;
					_tmp1266_ = vala_get_cvalue (_tmp1265_);
					_tmp1267_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1266_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1267_;
					_tmp1270_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1270_)) {
						ValaParameter* _tmp1271_;
						ValaDataType* _tmp1272_;
						ValaDataType* _tmp1273_;
						_tmp1271_ = param;
						_tmp1272_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1271_);
						_tmp1273_ = _tmp1272_;
						_tmp1269_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1273_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1269_ = FALSE;
					}
					if (_tmp1269_) {
						ValaParameter* _tmp1274_;
						ValaDataType* _tmp1275_;
						ValaDataType* _tmp1276_;
						gboolean _tmp1277_;
						gboolean _tmp1278_;
						_tmp1274_ = param;
						_tmp1275_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1274_);
						_tmp1276_ = _tmp1275_;
						_tmp1277_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1276_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1278_ = _tmp1277_;
						_tmp1268_ = !_tmp1278_;
					} else {
						_tmp1268_ = FALSE;
					}
					if (_tmp1268_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1279_;
						ValaDataType* _tmp1280_;
						ValaDataType* _tmp1281_;
						ValaArrayType* _tmp1282_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1283_;
						gchar* _tmp1284_;
						_tmp1279_ = param;
						_tmp1280_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1279_);
						_tmp1281_ = _tmp1280_;
						_tmp1282_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1281_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1282_;
						_tmp1283_ = param;
						_tmp1284_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1283_);
						length_ctype = _tmp1284_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1285_ = FALSE;
								_tmp1285_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1287_;
									gint _tmp1288_;
									gint _tmp1289_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1290_;
									ValaCType* _tmp1291_;
									ValaCType* _tmp1292_;
									ValaLocalVariable* _tmp1293_;
									ValaLocalVariable* _tmp1294_;
									ValaLocalVariable* _tmp1295_;
									ValaExpression* _tmp1296_;
									ValaLocalVariable* _tmp1297_;
									const gchar* _tmp1298_;
									const gchar* _tmp1299_;
									ValaCCodeExpression* _tmp1300_;
									ValaCCodeExpression* _tmp1301_;
									ValaHashMap* _tmp1302_;
									ValaParameter* _tmp1303_;
									ValaExpression* _tmp1304_;
									ValaList* _tmp1305_;
									gpointer _tmp1306_;
									ValaCCodeExpression* _tmp1307_;
									ValaCCodeUnaryExpression* _tmp1308_;
									ValaCCodeUnaryExpression* _tmp1309_;
									if (!_tmp1285_) {
										gint _tmp1286_;
										_tmp1286_ = dim;
										dim = _tmp1286_ + 1;
									}
									_tmp1285_ = FALSE;
									_tmp1287_ = array_type;
									_tmp1288_ = vala_array_type_get_rank (_tmp1287_);
									_tmp1289_ = _tmp1288_;
									if (!(dim <= _tmp1289_)) {
										break;
									}
									_tmp1290_ = length_ctype;
									_tmp1291_ = vala_ctype_new (_tmp1290_, "0");
									_tmp1292_ = _tmp1291_;
									_tmp1293_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1292_, TRUE, NULL, TRUE);
									_tmp1294_ = _tmp1293_;
									_vala_code_node_unref0 (_tmp1292_);
									temp_array_length = _tmp1294_;
									_tmp1295_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1295_, FALSE);
									_tmp1296_ = arg;
									_tmp1297_ = temp_array_length;
									_tmp1298_ = vala_symbol_get_name ((ValaSymbol*) _tmp1297_);
									_tmp1299_ = _tmp1298_;
									_tmp1300_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1299_);
									_tmp1301_ = _tmp1300_;
									vala_append_array_length (_tmp1296_, _tmp1301_);
									_vala_ccode_node_unref0 (_tmp1301_);
									_tmp1302_ = carg_map;
									_tmp1303_ = param;
									_tmp1304_ = arg;
									_tmp1305_ = vala_get_array_lengths (_tmp1304_);
									_tmp1306_ = vala_list_get (_tmp1305_, dim - 1);
									_tmp1307_ = (ValaCCodeExpression*) _tmp1306_;
									_tmp1308_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1307_);
									_tmp1309_ = _tmp1308_;
									vala_map_set ((ValaMap*) _tmp1302_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1303_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1309_);
									_vala_ccode_node_unref0 (_tmp1309_);
									_vala_ccode_node_unref0 (_tmp1307_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1310_ = FALSE;
						ValaParameter* _tmp1311_;
						_tmp1311_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1311_)) {
							ValaParameter* _tmp1312_;
							ValaDataType* _tmp1313_;
							ValaDataType* _tmp1314_;
							_tmp1312_ = param;
							_tmp1313_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1312_);
							_tmp1314_ = _tmp1313_;
							_tmp1310_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1314_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1310_ = FALSE;
						}
						if (_tmp1310_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1315_;
							ValaDataType* _tmp1316_;
							ValaDataType* _tmp1317_;
							ValaDelegateType* _tmp1318_;
							ValaDelegateType* _tmp1319_;
							ValaDelegate* _tmp1320_;
							ValaDelegate* _tmp1321_;
							gboolean _tmp1322_;
							gboolean _tmp1323_;
							_tmp1315_ = param;
							_tmp1316_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1315_);
							_tmp1317_ = _tmp1316_;
							_tmp1318_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1317_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1318_;
							_tmp1319_ = deleg_type;
							_tmp1320_ = vala_delegate_type_get_delegate_symbol (_tmp1319_);
							_tmp1321_ = _tmp1320_;
							_tmp1322_ = vala_delegate_get_has_target (_tmp1321_);
							_tmp1323_ = _tmp1322_;
							if (_tmp1323_) {
								ValaDataType* _tmp1324_;
								ValaLocalVariable* _tmp1325_;
								ValaLocalVariable* _tmp1326_;
								ValaExpression* _tmp1327_;
								ValaLocalVariable* _tmp1328_;
								const gchar* _tmp1329_;
								const gchar* _tmp1330_;
								ValaCCodeExpression* _tmp1331_;
								ValaCCodeExpression* _tmp1332_;
								ValaHashMap* _tmp1333_;
								ValaParameter* _tmp1334_;
								ValaExpression* _tmp1335_;
								ValaCCodeExpression* _tmp1336_;
								ValaCCodeUnaryExpression* _tmp1337_;
								ValaCCodeUnaryExpression* _tmp1338_;
								ValaDelegateType* _tmp1339_;
								_tmp1324_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
								_tmp1325_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1324_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1325_;
								_tmp1326_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1326_, FALSE);
								_tmp1327_ = arg;
								_tmp1328_ = temp_var;
								_tmp1329_ = vala_symbol_get_name ((ValaSymbol*) _tmp1328_);
								_tmp1330_ = _tmp1329_;
								_tmp1331_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1330_);
								_tmp1332_ = _tmp1331_;
								vala_set_delegate_target (_tmp1327_, _tmp1332_);
								_vala_ccode_node_unref0 (_tmp1332_);
								_tmp1333_ = carg_map;
								_tmp1334_ = param;
								_tmp1335_ = arg;
								_tmp1336_ = vala_get_delegate_target (_tmp1335_);
								_tmp1337_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1336_);
								_tmp1338_ = _tmp1337_;
								vala_map_set ((ValaMap*) _tmp1333_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1334_), FALSE)), (ValaCCodeExpression*) _tmp1338_);
								_vala_ccode_node_unref0 (_tmp1338_);
								_tmp1339_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1339_)) {
									ValaDelegateType* _tmp1340_;
									ValaLocalVariable* _tmp1341_;
									ValaLocalVariable* _tmp1342_;
									ValaExpression* _tmp1343_;
									ValaLocalVariable* _tmp1344_;
									const gchar* _tmp1345_;
									const gchar* _tmp1346_;
									ValaCCodeExpression* _tmp1347_;
									ValaCCodeExpression* _tmp1348_;
									ValaHashMap* _tmp1349_;
									ValaParameter* _tmp1350_;
									ValaExpression* _tmp1351_;
									ValaCCodeExpression* _tmp1352_;
									ValaCCodeUnaryExpression* _tmp1353_;
									ValaCCodeUnaryExpression* _tmp1354_;
									_tmp1340_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
									_tmp1341_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1340_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1341_;
									_tmp1342_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1342_, FALSE);
									_tmp1343_ = arg;
									_tmp1344_ = temp_var;
									_tmp1345_ = vala_symbol_get_name ((ValaSymbol*) _tmp1344_);
									_tmp1346_ = _tmp1345_;
									_tmp1347_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1346_);
									_tmp1348_ = _tmp1347_;
									vala_set_delegate_target_destroy_notify (_tmp1343_, _tmp1348_);
									_vala_ccode_node_unref0 (_tmp1348_);
									_tmp1349_ = carg_map;
									_tmp1350_ = param;
									_tmp1351_ = arg;
									_tmp1352_ = vala_get_delegate_target_destroy_notify (_tmp1351_);
									_tmp1353_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1352_);
									_tmp1354_ = _tmp1353_;
									vala_map_set ((ValaMap*) _tmp1349_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1350_), FALSE)), (ValaCCodeExpression*) _tmp1354_);
									_vala_ccode_node_unref0 (_tmp1354_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1355_ = param;
				_tmp1356_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1355_);
				_tmp1357_ = _tmp1356_;
				_tmp1358_ = _tmp1357_ != NULL;
				_g_free0 (_tmp1357_);
				if (_tmp1358_) {
					ValaCCodeExpression* _tmp1359_;
					ValaParameter* _tmp1360_;
					gchar* _tmp1361_;
					gchar* _tmp1362_;
					ValaCCodeCastExpression* _tmp1363_;
					_tmp1359_ = cexpr;
					_tmp1360_ = param;
					_tmp1361_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1360_);
					_tmp1362_ = _tmp1361_;
					_tmp1363_ = vala_ccode_cast_expression_new (_tmp1359_, _tmp1362_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1363_;
					_g_free0 (_tmp1362_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1364_;
				ValaUnaryExpression* _tmp1365_;
				gboolean _tmp1366_ = FALSE;
				gboolean _tmp1367_ = FALSE;
				_tmp1364_ = arg;
				_tmp1365_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1364_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1364_) : NULL);
				unary = _tmp1365_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1368_;
					_tmp1368_ = unary;
					_tmp1367_ = _tmp1368_ != NULL;
				} else {
					_tmp1367_ = FALSE;
				}
				if (_tmp1367_) {
					ValaUnaryExpression* _tmp1369_;
					ValaUnaryOperator _tmp1370_;
					ValaUnaryOperator _tmp1371_;
					_tmp1369_ = unary;
					_tmp1370_ = vala_unary_expression_get_operator (_tmp1369_);
					_tmp1371_ = _tmp1370_;
					_tmp1366_ = _tmp1371_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1366_ = FALSE;
				}
				if (_tmp1366_) {
					ValaHashMap* _tmp1372_;
					ValaHashMap* _tmp1373_;
					ValaExpression* _tmp1374_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1375_;
					ValaDataType* _tmp1376_;
					ValaDataType* _tmp1377_;
					ValaExpression* _tmp1378_;
					ValaDataType* _tmp1379_;
					ValaDataType* _tmp1380_;
					gboolean _tmp1381_;
					gboolean _tmp1382_;
					ValaLocalVariable* _tmp1383_;
					ValaLocalVariable* _tmp1384_;
					ValaExpression* _tmp1385_;
					ValaLocalVariable* _tmp1386_;
					const gchar* _tmp1387_;
					const gchar* _tmp1388_;
					ValaCCodeExpression* _tmp1389_;
					ValaCCodeExpression* _tmp1390_;
					ValaExpression* _tmp1391_;
					ValaTargetValue* _tmp1392_;
					ValaTargetValue* _tmp1393_;
					ValaExpression* _tmp1394_;
					ValaDataType* _tmp1395_;
					ValaDataType* _tmp1396_;
					gboolean _tmp1397_ = FALSE;
					ValaExpression* _tmp1398_;
					ValaDataType* _tmp1399_;
					ValaDataType* _tmp1400_;
					ValaExpression* _tmp1419_;
					ValaCCodeExpression* _tmp1420_;
					ValaCCodeUnaryExpression* _tmp1421_;
					_tmp1372_ = out_arg_map;
					_tmp1373_ = _vala_map_ref0 (_tmp1372_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1373_;
					_tmp1374_ = arg;
					vala_expression_set_target_value (_tmp1374_, NULL);
					_tmp1375_ = arg;
					_tmp1376_ = vala_expression_get_value_type (_tmp1375_);
					_tmp1377_ = _tmp1376_;
					_tmp1378_ = arg;
					_tmp1379_ = vala_expression_get_value_type (_tmp1378_);
					_tmp1380_ = _tmp1379_;
					_tmp1381_ = vala_data_type_get_value_owned (_tmp1380_);
					_tmp1382_ = _tmp1381_;
					_tmp1383_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1377_, _tmp1382_, NULL, TRUE);
					temp_var = _tmp1383_;
					_tmp1384_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1384_, FALSE);
					_tmp1385_ = arg;
					_tmp1386_ = temp_var;
					_tmp1387_ = vala_symbol_get_name ((ValaSymbol*) _tmp1386_);
					_tmp1388_ = _tmp1387_;
					_tmp1389_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1388_);
					_tmp1390_ = _tmp1389_;
					vala_set_cvalue (_tmp1385_, _tmp1390_);
					_vala_ccode_node_unref0 (_tmp1390_);
					_tmp1391_ = arg;
					_tmp1392_ = vala_expression_get_target_value (_tmp1391_);
					_tmp1393_ = _tmp1392_;
					_tmp1394_ = arg;
					_tmp1395_ = vala_expression_get_value_type (_tmp1394_);
					_tmp1396_ = _tmp1395_;
					vala_target_value_set_value_type (_tmp1393_, _tmp1396_);
					_tmp1398_ = arg;
					_tmp1399_ = vala_expression_get_value_type (_tmp1398_);
					_tmp1400_ = _tmp1399_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1400_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaExpression* _tmp1401_;
						ValaDataType* _tmp1402_;
						ValaDataType* _tmp1403_;
						ValaDelegate* _tmp1404_;
						ValaDelegate* _tmp1405_;
						gboolean _tmp1406_;
						gboolean _tmp1407_;
						_tmp1401_ = arg;
						_tmp1402_ = vala_expression_get_value_type (_tmp1401_);
						_tmp1403_ = _tmp1402_;
						_tmp1404_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1403_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp1405_ = _tmp1404_;
						_tmp1406_ = vala_delegate_get_has_target (_tmp1405_);
						_tmp1407_ = _tmp1406_;
						_tmp1397_ = _tmp1407_;
					} else {
						_tmp1397_ = FALSE;
					}
					if (_tmp1397_) {
						ValaGLibValue* arg_value = NULL;
						ValaExpression* _tmp1408_;
						ValaTargetValue* _tmp1409_;
						ValaTargetValue* _tmp1410_;
						ValaGLibValue* _tmp1411_;
						ValaCCodeExpression* _tmp1412_;
						ValaGLibValue* _tmp1415_;
						ValaCCodeExpression* _tmp1416_;
						_tmp1408_ = arg;
						_tmp1409_ = vala_expression_get_target_value (_tmp1408_);
						_tmp1410_ = _tmp1409_;
						arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp1410_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
						_tmp1411_ = arg_value;
						_tmp1412_ = _tmp1411_->delegate_target_cvalue;
						if (_tmp1412_ == NULL) {
							ValaGLibValue* _tmp1413_;
							ValaCCodeConstant* _tmp1414_;
							_tmp1413_ = arg_value;
							_tmp1414_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1413_->delegate_target_cvalue);
							_tmp1413_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp1414_;
						}
						_tmp1415_ = arg_value;
						_tmp1416_ = _tmp1415_->delegate_target_destroy_notify_cvalue;
						if (_tmp1416_ == NULL) {
							ValaGLibValue* _tmp1417_;
							ValaCCodeConstant* _tmp1418_;
							_tmp1417_ = arg_value;
							_tmp1418_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1417_->delegate_target_destroy_notify_cvalue);
							_tmp1417_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp1418_;
						}
					}
					_tmp1419_ = arg;
					_tmp1420_ = vala_get_cvalue (_tmp1419_);
					_tmp1421_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1420_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1421_;
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1422_;
					ValaCCodeExpression* _tmp1423_;
					ValaCCodeExpression* _tmp1424_;
					_tmp1422_ = arg;
					_tmp1423_ = cexpr;
					_tmp1424_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1422_, _tmp1423_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1424_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1427_ = param;
			if (_tmp1427_ != NULL) {
				_tmp1426_ = !ellipsis;
			} else {
				_tmp1426_ = FALSE;
			}
			if (_tmp1426_) {
				ValaParameter* _tmp1428_;
				_tmp1428_ = param;
				_tmp1425_ = vala_get_ccode_pos (_tmp1428_);
			} else {
				_tmp1425_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1425_, ellipsis);
			_tmp1429_ = carg_map;
			_tmp1430_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1429_, (gpointer) ((gintptr) arg_pos), _tmp1430_);
			_tmp1432_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1432_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
				ValaCodeContext* _tmp1433_;
				ValaCodeContext* _tmp1434_;
				ValaProfile _tmp1435_;
				ValaProfile _tmp1436_;
				_tmp1433_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp1434_ = _tmp1433_;
				_tmp1435_ = vala_code_context_get_profile (_tmp1434_);
				_tmp1436_ = _tmp1435_;
				_tmp1431_ = _tmp1436_ == VALA_PROFILE_POSIX;
			} else {
				_tmp1431_ = FALSE;
			}
			if (_tmp1431_) {
				ValaCCodeIdentifier* csizeof = NULL;
				ValaMemberAccess* _tmp1437_;
				ValaExpression* _tmp1438_;
				ValaExpression* _tmp1439_;
				ValaDataType* _tmp1440_;
				ValaDataType* _tmp1441_;
				ValaDataType* _tmp1442_;
				ValaDataType* _tmp1443_;
				gchar* _tmp1444_;
				gchar* _tmp1445_;
				gchar* _tmp1446_;
				gchar* _tmp1447_;
				ValaCCodeIdentifier* _tmp1448_;
				ValaCCodeIdentifier* _tmp1449_;
				ValaHashMap* _tmp1450_;
				ValaCCodeIdentifier* _tmp1451_;
				ValaCCodeExpression* _tmp1452_;
				ValaCCodeBinaryExpression* _tmp1453_;
				ValaCCodeBinaryExpression* _tmp1454_;
				_tmp1437_ = ma;
				_tmp1438_ = vala_member_access_get_inner (_tmp1437_);
				_tmp1439_ = _tmp1438_;
				_tmp1440_ = vala_expression_get_value_type (_tmp1439_);
				_tmp1441_ = _tmp1440_;
				_tmp1442_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1441_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp1443_ = _tmp1442_;
				_tmp1444_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1443_);
				_tmp1445_ = _tmp1444_;
				_tmp1446_ = g_strdup_printf ("sizeof (%s)", _tmp1445_);
				_tmp1447_ = _tmp1446_;
				_tmp1448_ = vala_ccode_identifier_new (_tmp1447_);
				_tmp1449_ = _tmp1448_;
				_g_free0 (_tmp1447_);
				_g_free0 (_tmp1445_);
				csizeof = _tmp1449_;
				_tmp1450_ = carg_map;
				_tmp1451_ = csizeof;
				_tmp1452_ = cexpr;
				_tmp1453_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1451_, _tmp1452_);
				_tmp1454_ = _tmp1453_;
				vala_map_set ((ValaMap*) _tmp1450_, (gpointer) ((gintptr) arg_pos), (ValaCCodeExpression*) _tmp1454_);
				_vala_ccode_node_unref0 (_tmp1454_);
				_vala_ccode_node_unref0 (csizeof);
			} else {
				ValaHashMap* _tmp1455_;
				ValaCCodeExpression* _tmp1456_;
				_tmp1455_ = carg_map;
				_tmp1456_ = cexpr;
				vala_map_set ((ValaMap*) _tmp1455_, (gpointer) ((gintptr) arg_pos), _tmp1456_);
			}
			_tmp1458_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1458_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1457_ = ellipsis;
			} else {
				_tmp1457_ = FALSE;
			}
			if (_tmp1457_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1459_;
				ValaNamedArgument* _tmp1460_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1461_;
				const gchar* _tmp1462_;
				const gchar* _tmp1463_;
				gchar** _tmp1464_;
				gchar** _tmp1465_;
				gchar** _tmp1466_;
				gint _tmp1466__length1;
				gchar* _tmp1467_;
				gchar* _tmp1468_;
				ValaHashMap* _tmp1469_;
				const gchar* _tmp1470_;
				gchar* _tmp1471_;
				gchar* _tmp1472_;
				ValaCCodeConstant* _tmp1473_;
				ValaCCodeConstant* _tmp1474_;
				_tmp1459_ = arg;
				_tmp1460_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1459_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1460_;
				_tmp1461_ = named_arg;
				_tmp1462_ = vala_named_argument_get_name (_tmp1461_);
				_tmp1463_ = _tmp1462_;
				_tmp1465_ = _tmp1464_ = g_strsplit (_tmp1463_, "_", 0);
				_tmp1466_ = _tmp1465_;
				_tmp1466__length1 = _vala_array_length (_tmp1464_);
				_tmp1467_ = _vala_g_strjoinv ("-", _tmp1466_, (gint) _vala_array_length (_tmp1464_));
				_tmp1468_ = _tmp1467_;
				_tmp1466_ = (_vala_array_free (_tmp1466_, _tmp1466__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1468_;
				_tmp1469_ = carg_map;
				_tmp1470_ = name;
				_tmp1471_ = g_strdup_printf ("\"%s\"", _tmp1470_);
				_tmp1472_ = _tmp1471_;
				_tmp1473_ = vala_ccode_constant_new (_tmp1472_);
				_tmp1474_ = _tmp1473_;
				vala_map_set ((ValaMap*) _tmp1469_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1474_);
				_vala_ccode_node_unref0 (_tmp1474_);
				_g_free0 (_tmp1472_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1475_ = i;
			i = _tmp1475_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1476_ = params_it;
	if (vala_iterator_next (_tmp1476_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1477_;
		gpointer _tmp1478_;
		gboolean _tmp1479_ = FALSE;
		ValaParameter* _tmp1480_;
		gboolean _tmp1481_;
		gboolean _tmp1482_;
		_tmp1477_ = params_it;
		_tmp1478_ = vala_iterator_get (_tmp1477_);
		param = (ValaParameter*) _tmp1478_;
		_tmp1480_ = param;
		_tmp1481_ = vala_parameter_get_params_array (_tmp1480_);
		_tmp1482_ = _tmp1481_;
		if (_tmp1482_) {
			_tmp1479_ = TRUE;
		} else {
			ValaParameter* _tmp1483_;
			gboolean _tmp1484_;
			gboolean _tmp1485_;
			_tmp1483_ = param;
			_tmp1484_ = vala_parameter_get_ellipsis (_tmp1483_);
			_tmp1485_ = _tmp1484_;
			_tmp1479_ = _tmp1485_;
		}
		_vala_assert (_tmp1479_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1488_ = m;
	if (_tmp1488_ != NULL) {
		ValaMethod* _tmp1489_;
		ValaDataType* _tmp1490_;
		ValaDataType* _tmp1491_;
		_tmp1489_ = m;
		_tmp1490_ = vala_callable_get_return_type ((ValaCallable*) _tmp1489_);
		_tmp1491_ = _tmp1490_;
		_tmp1487_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1491_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1487_ = FALSE;
	}
	if (_tmp1487_) {
		ValaCCodeFunctionCall* _tmp1492_;
		ValaCCodeFunctionCall* _tmp1493_;
		_tmp1492_ = async_call;
		_tmp1493_ = ccall;
		_tmp1486_ = _tmp1492_ != _tmp1493_;
	} else {
		_tmp1486_ = FALSE;
	}
	if (_tmp1486_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1494_;
		ValaDataType* _tmp1495_;
		ValaDataType* _tmp1496_;
		ValaArrayType* _tmp1497_;
		_tmp1494_ = m;
		_tmp1495_ = vala_callable_get_return_type ((ValaCallable*) _tmp1494_);
		_tmp1496_ = _tmp1495_;
		_tmp1497_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1496_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1497_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1498_ = FALSE;
				_tmp1498_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1500_;
					gint _tmp1501_;
					gint _tmp1502_;
					ValaMethod* _tmp1503_;
					if (!_tmp1498_) {
						gint _tmp1499_;
						_tmp1499_ = dim;
						dim = _tmp1499_ + 1;
					}
					_tmp1498_ = FALSE;
					_tmp1500_ = array_type;
					_tmp1501_ = vala_array_type_get_rank (_tmp1500_);
					_tmp1502_ = _tmp1501_;
					if (!(dim <= _tmp1502_)) {
						break;
					}
					_tmp1503_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1503_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1504_;
						ValaDataType* _tmp1505_;
						ValaLocalVariable* _tmp1506_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1507_;
						const gchar* _tmp1508_;
						const gchar* _tmp1509_;
						ValaCCodeExpression* _tmp1510_;
						ValaLocalVariable* _tmp1511_;
						ValaCCodeExpression* _tmp1512_;
						ValaCCodeExpression* _tmp1513_;
						ValaCCodeAssignment* _tmp1514_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1515_;
						ValaCCodeIdentifier* _tmp1516_;
						ValaCCodeFunctionCall* _tmp1517_;
						ValaCCodeFunctionCall* _tmp1518_;
						ValaCCodeFunctionCall* _tmp1519_;
						ValaCCodeExpression* _tmp1520_;
						ValaCCodeFunctionCall* _tmp1521_;
						_tmp1504_ = itype;
						_tmp1505_ = vala_data_type_get_return_type (_tmp1504_);
						_tmp1506_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1505_, TRUE, NULL, FALSE);
						temp_var = _tmp1506_;
						_tmp1507_ = temp_var;
						_tmp1508_ = vala_symbol_get_name ((ValaSymbol*) _tmp1507_);
						_tmp1509_ = _tmp1508_;
						_tmp1510_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1509_);
						temp_ref = _tmp1510_;
						_tmp1511_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1511_, FALSE);
						_tmp1512_ = temp_ref;
						_tmp1513_ = ccall_expr;
						_tmp1514_ = vala_ccode_assignment_new (_tmp1512_, _tmp1513_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1514_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1515_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1516_ = _tmp1515_;
						_tmp1517_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1516_);
						_tmp1518_ = _tmp1517_;
						_vala_ccode_node_unref0 (_tmp1516_);
						len_call = _tmp1518_;
						_tmp1519_ = len_call;
						_tmp1520_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1519_, _tmp1520_);
						_tmp1521_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1521_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1522_;
						_tmp1522_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1522_)) {
							gchar* length_ctype = NULL;
							ValaMethod* _tmp1523_;
							gchar* _tmp1524_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1525_;
							ValaCType* _tmp1526_;
							ValaCType* _tmp1527_;
							ValaLocalVariable* _tmp1528_;
							ValaLocalVariable* _tmp1529_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1530_;
							const gchar* _tmp1531_;
							const gchar* _tmp1532_;
							ValaCCodeExpression* _tmp1533_;
							ValaLocalVariable* _tmp1534_;
							ValaHashMap* _tmp1535_;
							ValaMethod* _tmp1536_;
							ValaCCodeExpression* _tmp1537_;
							ValaCCodeUnaryExpression* _tmp1538_;
							ValaCCodeUnaryExpression* _tmp1539_;
							ValaCCodeExpression* _tmp1540_;
							_tmp1523_ = m;
							_tmp1524_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1523_);
							length_ctype = _tmp1524_;
							_tmp1525_ = length_ctype;
							_tmp1526_ = vala_ctype_new (_tmp1525_, "0");
							_tmp1527_ = _tmp1526_;
							_tmp1528_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1527_, TRUE, NULL, TRUE);
							_tmp1529_ = _tmp1528_;
							_vala_code_node_unref0 (_tmp1527_);
							temp_var = _tmp1529_;
							_tmp1530_ = temp_var;
							_tmp1531_ = vala_symbol_get_name ((ValaSymbol*) _tmp1530_);
							_tmp1532_ = _tmp1531_;
							_tmp1533_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1532_);
							temp_ref = _tmp1533_;
							_tmp1534_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1534_, FALSE);
							_tmp1535_ = out_arg_map;
							_tmp1536_ = m;
							_tmp1537_ = temp_ref;
							_tmp1538_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1537_);
							_tmp1539_ = _tmp1538_;
							vala_map_set ((ValaMap*) _tmp1535_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1536_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1539_);
							_vala_ccode_node_unref0 (_tmp1539_);
							_tmp1540_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1540_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaMethod* _tmp1541_;
							gchar* _tmp1542_;
							gchar* _tmp1543_;
							gboolean _tmp1544_;
							_tmp1541_ = m;
							_tmp1542_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1541_);
							_tmp1543_ = _tmp1542_;
							_tmp1544_ = _tmp1543_ != NULL;
							_g_free0 (_tmp1543_);
							if (_tmp1544_) {
								ValaMethod* _tmp1545_;
								gchar* _tmp1546_;
								gchar* _tmp1547_;
								ValaCCodeConstant* _tmp1548_;
								ValaCCodeConstant* _tmp1549_;
								_tmp1545_ = m;
								_tmp1546_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1545_);
								_tmp1547_ = _tmp1546_;
								_tmp1548_ = vala_ccode_constant_new (_tmp1547_);
								_tmp1549_ = _tmp1548_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1549_);
								_vala_ccode_node_unref0 (_tmp1549_);
								_g_free0 (_tmp1547_);
							} else {
								ValaCCodeConstant* _tmp1550_;
								ValaCCodeConstant* _tmp1551_;
								_tmp1550_ = vala_ccode_constant_new ("-1");
								_tmp1551_ = _tmp1550_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1551_);
								_vala_ccode_node_unref0 (_tmp1551_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1552_ = FALSE;
		gboolean _tmp1553_ = FALSE;
		ValaMethod* _tmp1554_;
		_tmp1554_ = m;
		if (_tmp1554_ != NULL) {
			ValaMethod* _tmp1555_;
			ValaDataType* _tmp1556_;
			ValaDataType* _tmp1557_;
			_tmp1555_ = m;
			_tmp1556_ = vala_callable_get_return_type ((ValaCallable*) _tmp1555_);
			_tmp1557_ = _tmp1556_;
			_tmp1553_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1557_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1553_ = FALSE;
		}
		if (_tmp1553_) {
			ValaCCodeFunctionCall* _tmp1558_;
			ValaCCodeFunctionCall* _tmp1559_;
			_tmp1558_ = async_call;
			_tmp1559_ = ccall;
			_tmp1552_ = _tmp1558_ != _tmp1559_;
		} else {
			_tmp1552_ = FALSE;
		}
		if (_tmp1552_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1560_;
			ValaDataType* _tmp1561_;
			ValaDataType* _tmp1562_;
			ValaDelegateType* _tmp1563_;
			gboolean _tmp1564_ = FALSE;
			ValaMethod* _tmp1565_;
			_tmp1560_ = m;
			_tmp1561_ = vala_callable_get_return_type ((ValaCallable*) _tmp1560_);
			_tmp1562_ = _tmp1561_;
			_tmp1563_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1562_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1563_;
			_tmp1565_ = m;
			if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1565_)) {
				ValaDelegateType* _tmp1566_;
				ValaDelegate* _tmp1567_;
				ValaDelegate* _tmp1568_;
				gboolean _tmp1569_;
				gboolean _tmp1570_;
				_tmp1566_ = deleg_type;
				_tmp1567_ = vala_delegate_type_get_delegate_symbol (_tmp1566_);
				_tmp1568_ = _tmp1567_;
				_tmp1569_ = vala_delegate_get_has_target (_tmp1568_);
				_tmp1570_ = _tmp1569_;
				_tmp1564_ = _tmp1570_;
			} else {
				_tmp1564_ = FALSE;
			}
			if (_tmp1564_) {
				ValaLocalVariable* temp_var = NULL;
				ValaDataType* _tmp1571_;
				ValaLocalVariable* _tmp1572_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1573_;
				const gchar* _tmp1574_;
				const gchar* _tmp1575_;
				ValaCCodeExpression* _tmp1576_;
				ValaLocalVariable* _tmp1577_;
				ValaHashMap* _tmp1578_;
				ValaMethod* _tmp1579_;
				ValaCCodeExpression* _tmp1580_;
				ValaCCodeUnaryExpression* _tmp1581_;
				ValaCCodeUnaryExpression* _tmp1582_;
				ValaCCodeExpression* _tmp1583_;
				ValaDelegateType* _tmp1584_;
				_tmp1571_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
				_tmp1572_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1571_, TRUE, NULL, TRUE);
				temp_var = _tmp1572_;
				_tmp1573_ = temp_var;
				_tmp1574_ = vala_symbol_get_name ((ValaSymbol*) _tmp1573_);
				_tmp1575_ = _tmp1574_;
				_tmp1576_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1575_);
				temp_ref = _tmp1576_;
				_tmp1577_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1577_, FALSE);
				_tmp1578_ = out_arg_map;
				_tmp1579_ = m;
				_tmp1580_ = temp_ref;
				_tmp1581_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1580_);
				_tmp1582_ = _tmp1581_;
				vala_map_set ((ValaMap*) _tmp1578_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1579_), FALSE)), (ValaCCodeExpression*) _tmp1582_);
				_vala_ccode_node_unref0 (_tmp1582_);
				_tmp1583_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1583_);
				_tmp1584_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1584_)) {
					ValaDelegateType* _tmp1585_;
					ValaLocalVariable* _tmp1586_;
					ValaLocalVariable* _tmp1587_;
					const gchar* _tmp1588_;
					const gchar* _tmp1589_;
					ValaCCodeExpression* _tmp1590_;
					ValaLocalVariable* _tmp1591_;
					ValaHashMap* _tmp1592_;
					ValaMethod* _tmp1593_;
					ValaCCodeExpression* _tmp1594_;
					ValaCCodeUnaryExpression* _tmp1595_;
					ValaCCodeUnaryExpression* _tmp1596_;
					ValaCCodeExpression* _tmp1597_;
					_tmp1585_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
					_tmp1586_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1585_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1586_;
					_tmp1587_ = temp_var;
					_tmp1588_ = vala_symbol_get_name ((ValaSymbol*) _tmp1587_);
					_tmp1589_ = _tmp1588_;
					_tmp1590_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1589_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1590_;
					_tmp1591_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1591_, FALSE);
					_tmp1592_ = out_arg_map;
					_tmp1593_ = m;
					_tmp1594_ = temp_ref;
					_tmp1595_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1594_);
					_tmp1596_ = _tmp1595_;
					vala_map_set ((ValaMap*) _tmp1592_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1593_), FALSE)), (ValaCCodeExpression*) _tmp1596_);
					_vala_ccode_node_unref0 (_tmp1596_);
					_tmp1597_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1597_);
				} else {
					ValaCCodeConstant* _tmp1598_;
					ValaCCodeConstant* _tmp1599_;
					_tmp1598_ = vala_ccode_constant_new ("NULL");
					_tmp1599_ = _tmp1598_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1599_);
					_vala_ccode_node_unref0 (_tmp1599_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1600_;
				ValaCCodeConstant* _tmp1601_;
				ValaDelegateType* _tmp1602_;
				ValaDelegate* _tmp1603_;
				ValaDelegate* _tmp1604_;
				gboolean _tmp1605_;
				gboolean _tmp1606_;
				_tmp1600_ = vala_ccode_constant_new ("NULL");
				_tmp1601_ = _tmp1600_;
				vala_set_delegate_target ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1601_);
				_vala_ccode_node_unref0 (_tmp1601_);
				_tmp1602_ = deleg_type;
				_tmp1603_ = vala_delegate_type_get_delegate_symbol (_tmp1602_);
				_tmp1604_ = _tmp1603_;
				_tmp1605_ = vala_delegate_get_has_target (_tmp1604_);
				_tmp1606_ = _tmp1605_;
				if (_tmp1606_) {
					ValaCCodeConstant* _tmp1607_;
					ValaCCodeConstant* _tmp1608_;
					_tmp1607_ = vala_ccode_constant_new ("NULL");
					_tmp1608_ = _tmp1607_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1608_);
					_vala_ccode_node_unref0 (_tmp1608_);
				}
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1610_ = deleg;
	if (_tmp1610_ != NULL) {
		ValaDelegate* _tmp1611_;
		ValaDataType* _tmp1612_;
		ValaDataType* _tmp1613_;
		_tmp1611_ = deleg;
		_tmp1612_ = vala_callable_get_return_type ((ValaCallable*) _tmp1611_);
		_tmp1613_ = _tmp1612_;
		_tmp1609_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1613_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1609_ = FALSE;
	}
	if (_tmp1609_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1614_;
		ValaDataType* _tmp1615_;
		ValaDataType* _tmp1616_;
		ValaArrayType* _tmp1617_;
		_tmp1614_ = deleg;
		_tmp1615_ = vala_callable_get_return_type ((ValaCallable*) _tmp1614_);
		_tmp1616_ = _tmp1615_;
		_tmp1617_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1616_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1617_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1618_ = FALSE;
				_tmp1618_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1620_;
					gint _tmp1621_;
					gint _tmp1622_;
					ValaDelegate* _tmp1623_;
					if (!_tmp1618_) {
						gint _tmp1619_;
						_tmp1619_ = dim;
						dim = _tmp1619_ + 1;
					}
					_tmp1618_ = FALSE;
					_tmp1620_ = array_type;
					_tmp1621_ = vala_array_type_get_rank (_tmp1620_);
					_tmp1622_ = _tmp1621_;
					if (!(dim <= _tmp1622_)) {
						break;
					}
					_tmp1623_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1623_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1624_;
						ValaDataType* _tmp1625_;
						ValaLocalVariable* _tmp1626_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1627_;
						const gchar* _tmp1628_;
						const gchar* _tmp1629_;
						ValaCCodeExpression* _tmp1630_;
						ValaLocalVariable* _tmp1631_;
						ValaCCodeExpression* _tmp1632_;
						ValaCCodeExpression* _tmp1633_;
						ValaCCodeAssignment* _tmp1634_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1635_;
						ValaCCodeIdentifier* _tmp1636_;
						ValaCCodeFunctionCall* _tmp1637_;
						ValaCCodeFunctionCall* _tmp1638_;
						ValaCCodeFunctionCall* _tmp1639_;
						ValaCCodeExpression* _tmp1640_;
						ValaCCodeFunctionCall* _tmp1641_;
						_tmp1624_ = itype;
						_tmp1625_ = vala_data_type_get_return_type (_tmp1624_);
						_tmp1626_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1625_, TRUE, NULL, FALSE);
						temp_var = _tmp1626_;
						_tmp1627_ = temp_var;
						_tmp1628_ = vala_symbol_get_name ((ValaSymbol*) _tmp1627_);
						_tmp1629_ = _tmp1628_;
						_tmp1630_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1629_);
						temp_ref = _tmp1630_;
						_tmp1631_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1631_, FALSE);
						_tmp1632_ = temp_ref;
						_tmp1633_ = ccall_expr;
						_tmp1634_ = vala_ccode_assignment_new (_tmp1632_, _tmp1633_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1634_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1635_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1636_ = _tmp1635_;
						_tmp1637_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1636_);
						_tmp1638_ = _tmp1637_;
						_vala_ccode_node_unref0 (_tmp1636_);
						len_call = _tmp1638_;
						_tmp1639_ = len_call;
						_tmp1640_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1639_, _tmp1640_);
						_tmp1641_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1641_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1642_;
						_tmp1642_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1642_)) {
							gchar* length_ctype = NULL;
							ValaDelegate* _tmp1643_;
							gchar* _tmp1644_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1645_;
							ValaCType* _tmp1646_;
							ValaCType* _tmp1647_;
							ValaLocalVariable* _tmp1648_;
							ValaLocalVariable* _tmp1649_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1650_;
							const gchar* _tmp1651_;
							const gchar* _tmp1652_;
							ValaCCodeExpression* _tmp1653_;
							ValaLocalVariable* _tmp1654_;
							ValaHashMap* _tmp1655_;
							ValaDelegate* _tmp1656_;
							ValaCCodeExpression* _tmp1657_;
							ValaCCodeUnaryExpression* _tmp1658_;
							ValaCCodeUnaryExpression* _tmp1659_;
							ValaCCodeExpression* _tmp1660_;
							_tmp1643_ = deleg;
							_tmp1644_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1643_);
							length_ctype = _tmp1644_;
							_tmp1645_ = length_ctype;
							_tmp1646_ = vala_ctype_new (_tmp1645_, "0");
							_tmp1647_ = _tmp1646_;
							_tmp1648_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1647_, TRUE, NULL, TRUE);
							_tmp1649_ = _tmp1648_;
							_vala_code_node_unref0 (_tmp1647_);
							temp_var = _tmp1649_;
							_tmp1650_ = temp_var;
							_tmp1651_ = vala_symbol_get_name ((ValaSymbol*) _tmp1650_);
							_tmp1652_ = _tmp1651_;
							_tmp1653_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1652_);
							temp_ref = _tmp1653_;
							_tmp1654_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1654_, FALSE);
							_tmp1655_ = out_arg_map;
							_tmp1656_ = deleg;
							_tmp1657_ = temp_ref;
							_tmp1658_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1657_);
							_tmp1659_ = _tmp1658_;
							vala_map_set ((ValaMap*) _tmp1655_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1656_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1659_);
							_vala_ccode_node_unref0 (_tmp1659_);
							_tmp1660_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1660_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaCCodeConstant* _tmp1661_;
							ValaCCodeConstant* _tmp1662_;
							_tmp1661_ = vala_ccode_constant_new ("-1");
							_tmp1662_ = _tmp1661_;
							vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1662_);
							_vala_ccode_node_unref0 (_tmp1662_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1663_ = FALSE;
		gboolean _tmp1664_ = FALSE;
		ValaDelegate* _tmp1665_;
		_tmp1665_ = deleg;
		if (_tmp1665_ != NULL) {
			ValaDelegate* _tmp1666_;
			ValaDataType* _tmp1667_;
			ValaDataType* _tmp1668_;
			_tmp1666_ = deleg;
			_tmp1667_ = vala_callable_get_return_type ((ValaCallable*) _tmp1666_);
			_tmp1668_ = _tmp1667_;
			_tmp1664_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1668_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1664_ = FALSE;
		}
		if (_tmp1664_) {
			ValaDelegate* _tmp1669_;
			_tmp1669_ = deleg;
			_tmp1663_ = vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1669_);
		} else {
			_tmp1663_ = FALSE;
		}
		if (_tmp1663_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1670_;
			ValaDataType* _tmp1671_;
			ValaDataType* _tmp1672_;
			ValaDelegateType* _tmp1673_;
			ValaDelegateType* _tmp1674_;
			ValaDelegate* _tmp1675_;
			ValaDelegate* _tmp1676_;
			gboolean _tmp1677_;
			gboolean _tmp1678_;
			_tmp1670_ = deleg;
			_tmp1671_ = vala_callable_get_return_type ((ValaCallable*) _tmp1670_);
			_tmp1672_ = _tmp1671_;
			_tmp1673_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1672_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1673_;
			_tmp1674_ = deleg_type;
			_tmp1675_ = vala_delegate_type_get_delegate_symbol (_tmp1674_);
			_tmp1676_ = _tmp1675_;
			_tmp1677_ = vala_delegate_get_has_target (_tmp1676_);
			_tmp1678_ = _tmp1677_;
			if (_tmp1678_) {
				ValaLocalVariable* temp_var = NULL;
				ValaDataType* _tmp1679_;
				ValaLocalVariable* _tmp1680_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1681_;
				const gchar* _tmp1682_;
				const gchar* _tmp1683_;
				ValaCCodeExpression* _tmp1684_;
				ValaLocalVariable* _tmp1685_;
				ValaHashMap* _tmp1686_;
				ValaDelegate* _tmp1687_;
				ValaCCodeExpression* _tmp1688_;
				ValaCCodeUnaryExpression* _tmp1689_;
				ValaCCodeUnaryExpression* _tmp1690_;
				ValaCCodeExpression* _tmp1691_;
				ValaDelegateType* _tmp1692_;
				_tmp1679_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
				_tmp1680_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1679_, TRUE, NULL, TRUE);
				temp_var = _tmp1680_;
				_tmp1681_ = temp_var;
				_tmp1682_ = vala_symbol_get_name ((ValaSymbol*) _tmp1681_);
				_tmp1683_ = _tmp1682_;
				_tmp1684_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1683_);
				temp_ref = _tmp1684_;
				_tmp1685_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1685_, FALSE);
				_tmp1686_ = out_arg_map;
				_tmp1687_ = deleg;
				_tmp1688_ = temp_ref;
				_tmp1689_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1688_);
				_tmp1690_ = _tmp1689_;
				vala_map_set ((ValaMap*) _tmp1686_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1687_), FALSE)), (ValaCCodeExpression*) _tmp1690_);
				_vala_ccode_node_unref0 (_tmp1690_);
				_tmp1691_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1691_);
				_tmp1692_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1692_)) {
					ValaDelegateType* _tmp1693_;
					ValaLocalVariable* _tmp1694_;
					ValaLocalVariable* _tmp1695_;
					const gchar* _tmp1696_;
					const gchar* _tmp1697_;
					ValaCCodeExpression* _tmp1698_;
					ValaLocalVariable* _tmp1699_;
					ValaHashMap* _tmp1700_;
					ValaDelegate* _tmp1701_;
					ValaCCodeExpression* _tmp1702_;
					ValaCCodeUnaryExpression* _tmp1703_;
					ValaCCodeUnaryExpression* _tmp1704_;
					ValaCCodeExpression* _tmp1705_;
					_tmp1693_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
					_tmp1694_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1693_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1694_;
					_tmp1695_ = temp_var;
					_tmp1696_ = vala_symbol_get_name ((ValaSymbol*) _tmp1695_);
					_tmp1697_ = _tmp1696_;
					_tmp1698_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1697_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1698_;
					_tmp1699_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1699_, FALSE);
					_tmp1700_ = out_arg_map;
					_tmp1701_ = deleg;
					_tmp1702_ = temp_ref;
					_tmp1703_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1702_);
					_tmp1704_ = _tmp1703_;
					vala_map_set ((ValaMap*) _tmp1700_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1701_), FALSE)), (ValaCCodeExpression*) _tmp1704_);
					_vala_ccode_node_unref0 (_tmp1704_);
					_tmp1705_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1705_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1707_ = m;
	if (_tmp1707_ != NULL) {
		ValaMethod* _tmp1708_;
		gboolean _tmp1709_;
		gboolean _tmp1710_;
		_tmp1708_ = m;
		_tmp1709_ = vala_method_get_coroutine (_tmp1708_);
		_tmp1710_ = _tmp1709_;
		_tmp1706_ = _tmp1710_;
	} else {
		_tmp1706_ = FALSE;
	}
	if (_tmp1706_) {
		gboolean _tmp1711_;
		gboolean _tmp1712_;
		_tmp1711_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1712_ = _tmp1711_;
		if (_tmp1712_) {
			ValaHashMap* _tmp1713_;
			ValaMethod* _tmp1714_;
			ValaMethod* _tmp1715_;
			gchar* _tmp1716_;
			gchar* _tmp1717_;
			ValaCCodeIdentifier* _tmp1718_;
			ValaCCodeIdentifier* _tmp1719_;
			ValaHashMap* _tmp1720_;
			ValaCCodeIdentifier* _tmp1721_;
			ValaCCodeIdentifier* _tmp1722_;
			_tmp1713_ = in_arg_map;
			_tmp1714_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1715_ = _tmp1714_;
			_tmp1716_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1715_);
			_tmp1717_ = _tmp1716_;
			_tmp1718_ = vala_ccode_identifier_new (_tmp1717_);
			_tmp1719_ = _tmp1718_;
			vala_map_set ((ValaMap*) _tmp1713_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1719_);
			_vala_ccode_node_unref0 (_tmp1719_);
			_g_free0 (_tmp1717_);
			_tmp1720_ = in_arg_map;
			_tmp1721_ = vala_ccode_identifier_new ("_data_");
			_tmp1722_ = _tmp1721_;
			vala_map_set ((ValaMap*) _tmp1720_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1722_);
			_vala_ccode_node_unref0 (_tmp1722_);
		}
	}
	_tmp1723_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1724_ = _tmp1723_;
	if (_tmp1724_) {
		ValaCallable* _tmp1725_ = NULL;
		ValaMethod* _tmp1726_;
		ValaHashMap* _tmp1728_;
		ValaCCodeExpression* _tmp1729_;
		ValaCCodeExpression* _tmp1730_;
		ValaCCodeUnaryExpression* _tmp1731_;
		ValaCCodeUnaryExpression* _tmp1732_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1726_ = m;
		_tmp1725_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1726_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1725_ == NULL) {
			ValaDelegate* _tmp1727_;
			_tmp1727_ = deleg;
			_tmp1725_ = (ValaCallable*) _tmp1727_;
		}
		_tmp1728_ = out_arg_map;
		_tmp1729_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1730_ = _tmp1729_;
		_tmp1731_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1730_);
		_tmp1732_ = _tmp1731_;
		vala_map_set ((ValaMap*) _tmp1728_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1725_), FALSE)), (ValaCCodeExpression*) _tmp1732_);
		_vala_ccode_node_unref0 (_tmp1732_);
		_vala_ccode_node_unref0 (_tmp1730_);
	} else {
		gboolean _tmp1733_ = FALSE;
		gboolean _tmp1734_ = FALSE;
		ValaMethod* _tmp1735_;
		_tmp1735_ = m;
		if (_tmp1735_ != NULL) {
			ValaMethod* _tmp1736_;
			_tmp1736_ = m;
			_tmp1734_ = vala_method_has_error_type_parameter (_tmp1736_);
		} else {
			_tmp1734_ = FALSE;
		}
		if (_tmp1734_) {
			ValaCCodeFunctionCall* _tmp1737_;
			ValaCCodeFunctionCall* _tmp1738_;
			_tmp1737_ = async_call;
			_tmp1738_ = ccall;
			_tmp1733_ = _tmp1737_ != _tmp1738_;
		} else {
			_tmp1733_ = FALSE;
		}
		if (_tmp1733_) {
			ValaHashMap* _tmp1739_;
			ValaMethod* _tmp1740_;
			ValaCCodeConstant* _tmp1741_;
			ValaCCodeConstant* _tmp1742_;
			_tmp1739_ = out_arg_map;
			_tmp1740_ = m;
			_tmp1741_ = vala_ccode_constant_new ("NULL");
			_tmp1742_ = _tmp1741_;
			vala_map_set ((ValaMap*) _tmp1739_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1740_), FALSE)), (ValaCCodeExpression*) _tmp1742_);
			_vala_ccode_node_unref0 (_tmp1742_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1743_;
		_tmp1743_ = m;
		if (_tmp1743_ == NULL) {
			ValaHashMap* _tmp1744_;
			ValaCCodeConstant* _tmp1745_;
			ValaCCodeConstant* _tmp1746_;
			_tmp1744_ = in_arg_map;
			_tmp1745_ = vala_ccode_constant_new ("NULL");
			_tmp1746_ = _tmp1745_;
			vala_map_set ((ValaMap*) _tmp1744_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1746_);
			_vala_ccode_node_unref0 (_tmp1746_);
		} else {
			gboolean _tmp1747_ = FALSE;
			gboolean _tmp1748_ = FALSE;
			gboolean _tmp1749_ = FALSE;
			ValaMethod* _tmp1750_;
			gboolean _tmp1751_;
			gboolean _tmp1752_;
			_tmp1750_ = m;
			_tmp1751_ = vala_method_get_printf_format (_tmp1750_);
			_tmp1752_ = _tmp1751_;
			if (!_tmp1752_) {
				ValaMethod* _tmp1753_;
				gboolean _tmp1754_;
				gboolean _tmp1755_;
				_tmp1753_ = m;
				_tmp1754_ = vala_method_get_scanf_format (_tmp1753_);
				_tmp1755_ = _tmp1754_;
				_tmp1749_ = !_tmp1755_;
			} else {
				_tmp1749_ = FALSE;
			}
			if (_tmp1749_) {
				ValaMethod* _tmp1756_;
				gchar* _tmp1757_;
				gchar* _tmp1758_;
				_tmp1756_ = m;
				_tmp1757_ = vala_get_ccode_sentinel (_tmp1756_);
				_tmp1758_ = _tmp1757_;
				_tmp1748_ = g_strcmp0 (_tmp1758_, "") != 0;
				_g_free0 (_tmp1758_);
			} else {
				_tmp1748_ = FALSE;
			}
			if (_tmp1748_) {
				gboolean _tmp1759_;
				gboolean _tmp1760_;
				_tmp1759_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1760_ = _tmp1759_;
				_tmp1747_ = !_tmp1760_;
			} else {
				_tmp1747_ = FALSE;
			}
			if (_tmp1747_) {
				ValaHashMap* _tmp1761_;
				ValaMethod* _tmp1762_;
				gchar* _tmp1763_;
				gchar* _tmp1764_;
				ValaCCodeConstant* _tmp1765_;
				ValaCCodeConstant* _tmp1766_;
				_tmp1761_ = in_arg_map;
				_tmp1762_ = m;
				_tmp1763_ = vala_get_ccode_sentinel (_tmp1762_);
				_tmp1764_ = _tmp1763_;
				_tmp1765_ = vala_ccode_constant_new (_tmp1764_);
				_tmp1766_ = _tmp1765_;
				vala_map_set ((ValaMap*) _tmp1761_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1766_);
				_vala_ccode_node_unref0 (_tmp1766_);
				_g_free0 (_tmp1764_);
			}
		}
	}
	_tmp1768_ = deleg;
	if (_tmp1768_ != NULL) {
		ValaDelegate* _tmp1769_;
		gboolean _tmp1770_;
		gboolean _tmp1771_;
		_tmp1769_ = deleg;
		_tmp1770_ = vala_delegate_get_has_target (_tmp1769_);
		_tmp1771_ = _tmp1770_;
		_tmp1767_ = _tmp1771_;
	} else {
		_tmp1767_ = FALSE;
	}
	if (_tmp1767_) {
		ValaCCodeExpression* delegate_target_destroy_notify = NULL;
		ValaHashMap* _tmp1772_;
		ValaDelegate* _tmp1773_;
		ValaExpression* _tmp1774_;
		ValaExpression* _tmp1775_;
		ValaCCodeExpression* _tmp1776_ = NULL;
		ValaCCodeExpression* _tmp1777_;
		ValaCCodeExpression* _tmp1778_;
		ValaHashMap* _tmp1779_;
		ValaDelegate* _tmp1780_;
		ValaExpression* _tmp1781_;
		ValaExpression* _tmp1782_;
		ValaCCodeExpression* _tmp1783_ = NULL;
		ValaCCodeExpression* _tmp1784_;
		ValaCCodeExpression* _tmp1785_;
		_tmp1772_ = in_arg_map;
		_tmp1773_ = deleg;
		_tmp1774_ = vala_method_call_get_call (expr);
		_tmp1775_ = _tmp1774_;
		_tmp1777_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1775_, &_tmp1776_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1776_;
		_tmp1778_ = _tmp1777_;
		vala_map_set ((ValaMap*) _tmp1772_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1773_), FALSE)), _tmp1778_);
		_vala_ccode_node_unref0 (_tmp1778_);
		_tmp1779_ = out_arg_map;
		_tmp1780_ = deleg;
		_tmp1781_ = vala_method_call_get_call (expr);
		_tmp1782_ = _tmp1781_;
		_tmp1784_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1782_, &_tmp1783_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1783_;
		_tmp1785_ = _tmp1784_;
		vala_map_set ((ValaMap*) _tmp1779_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1780_), FALSE)), _tmp1785_);
		_vala_ccode_node_unref0 (_tmp1785_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
	}
	_tmp1786_ = itype;
	_tmp1787_ = vala_data_type_get_return_type (_tmp1786_);
	return_result_via_out_param = vala_data_type_is_real_non_null_struct_type (_tmp1787_);
	_tmp1789_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1789_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1790_;
		ValaDataType* _tmp1791_;
		_tmp1790_ = itype;
		_tmp1791_ = vala_data_type_get_return_type (_tmp1790_);
		_tmp1788_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1791_, VALA_TYPE_VOID_TYPE);
	} else {
		_tmp1788_ = FALSE;
	}
	if (_tmp1788_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1792_;
		ValaSignal* _tmp1793_;
		ValaSignal* _tmp1794_;
		ValaSignal* _tmp1795_;
		gboolean _tmp1796_ = FALSE;
		gboolean _tmp1797_ = FALSE;
		ValaMemberAccess* _tmp1798_;
		_tmp1792_ = itype;
		_tmp1793_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1792_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1794_ = _tmp1793_;
		_tmp1795_ = _vala_code_node_ref0 (_tmp1794_);
		sig = _tmp1795_;
		_tmp1798_ = ma;
		if (_tmp1798_ != NULL) {
			ValaMemberAccess* _tmp1799_;
			ValaExpression* _tmp1800_;
			ValaExpression* _tmp1801_;
			_tmp1799_ = ma;
			_tmp1800_ = vala_member_access_get_inner (_tmp1799_);
			_tmp1801_ = _tmp1800_;
			_tmp1797_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1801_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1797_ = FALSE;
		}
		if (_tmp1797_) {
			ValaSignal* _tmp1802_;
			gboolean _tmp1803_;
			gboolean _tmp1804_;
			_tmp1802_ = sig;
			_tmp1803_ = vala_signal_get_is_virtual (_tmp1802_);
			_tmp1804_ = _tmp1803_;
			_tmp1796_ = _tmp1804_;
		} else {
			_tmp1796_ = FALSE;
		}
		if (_tmp1796_) {
		} else {
			gboolean _tmp1805_ = FALSE;
			ValaSignal* _tmp1806_;
			_tmp1806_ = sig;
			if (!vala_get_ccode_has_emitter (_tmp1806_)) {
				_tmp1805_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1807_;
				ValaSourceReference* _tmp1808_;
				ValaSourceReference* _tmp1809_;
				ValaSourceFile* _tmp1810_;
				ValaSourceFile* _tmp1811_;
				ValaSignal* _tmp1812_;
				ValaSourceReference* _tmp1813_;
				ValaSourceReference* _tmp1814_;
				ValaSourceFile* _tmp1815_;
				ValaSourceFile* _tmp1816_;
				_tmp1807_ = ma;
				_tmp1808_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1807_);
				_tmp1809_ = _tmp1808_;
				_tmp1810_ = vala_source_reference_get_file (_tmp1809_);
				_tmp1811_ = _tmp1810_;
				_tmp1812_ = sig;
				_tmp1813_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1812_);
				_tmp1814_ = _tmp1813_;
				_tmp1815_ = vala_source_reference_get_file (_tmp1814_);
				_tmp1816_ = _tmp1815_;
				_tmp1805_ = _tmp1811_ == _tmp1816_;
			}
			if (_tmp1805_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1817_ = async_call;
	_tmp1818_ = ccall;
	if (_tmp1817_ == _tmp1818_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1819_;
		ValaDataType* _tmp1820_;
		ValaLocalVariable* _tmp1821_;
		ValaLocalVariable* _tmp1822_;
		const gchar* _tmp1823_;
		const gchar* _tmp1824_;
		ValaCCodeExpression* _tmp1825_;
		ValaLocalVariable* _tmp1826_;
		ValaHashMap* _tmp1827_;
		ValaCCodeExpression* _tmp1828_;
		ValaCCodeUnaryExpression* _tmp1829_;
		ValaCCodeUnaryExpression* _tmp1830_;
		_tmp1819_ = itype;
		_tmp1820_ = vala_data_type_get_return_type (_tmp1819_);
		_tmp1821_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1820_, TRUE, NULL, TRUE);
		out_param_var = _tmp1821_;
		_tmp1822_ = out_param_var;
		_tmp1823_ = vala_symbol_get_name ((ValaSymbol*) _tmp1822_);
		_tmp1824_ = _tmp1823_;
		_tmp1825_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1824_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1825_;
		_tmp1826_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1826_, FALSE);
		_tmp1827_ = out_arg_map;
		_tmp1828_ = out_param_ref;
		_tmp1829_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1828_);
		_tmp1830_ = _tmp1829_;
		vala_map_set ((ValaMap*) _tmp1827_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1830_);
		_vala_ccode_node_unref0 (_tmp1830_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1831_ = async_call;
	_tmp1832_ = ccall;
	if (_tmp1831_ != _tmp1832_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1843_;
			ValaHashMap* _tmp1844_;
			gpointer _tmp1845_;
			ValaCCodeExpression* _tmp1846_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1833_;
				ValaSet* _tmp1834_;
				ValaSet* _tmp1835_;
				ValaIterator* _tmp1836_;
				ValaIterator* _tmp1837_;
				_tmp1833_ = out_arg_map;
				_tmp1834_ = vala_map_get_keys ((ValaMap*) _tmp1833_);
				_tmp1835_ = _tmp1834_;
				_tmp1836_ = vala_iterable_iterator ((ValaIterable*) _tmp1835_);
				_tmp1837_ = _tmp1836_;
				_vala_iterable_unref0 (_tmp1835_);
				_pos_it = _tmp1837_;
				while (TRUE) {
					ValaIterator* _tmp1838_;
					gint pos = 0;
					ValaIterator* _tmp1839_;
					gpointer _tmp1840_;
					gboolean _tmp1841_ = FALSE;
					_tmp1838_ = _pos_it;
					if (!vala_iterator_next (_tmp1838_)) {
						break;
					}
					_tmp1839_ = _pos_it;
					_tmp1840_ = vala_iterator_get (_tmp1839_);
					pos = (gint) ((gintptr) _tmp1840_);
					if (pos > last_pos) {
						gboolean _tmp1842_ = FALSE;
						if (min_pos == -1) {
							_tmp1842_ = TRUE;
						} else {
							_tmp1842_ = pos < min_pos;
						}
						_tmp1841_ = _tmp1842_;
					} else {
						_tmp1841_ = FALSE;
					}
					if (_tmp1841_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1843_ = ccall;
			_tmp1844_ = out_arg_map;
			_tmp1845_ = vala_map_get ((ValaMap*) _tmp1844_, (gpointer) ((gintptr) min_pos));
			_tmp1846_ = (ValaCCodeExpression*) _tmp1845_;
			vala_ccode_function_call_add_argument (_tmp1843_, _tmp1846_);
			_vala_ccode_node_unref0 (_tmp1846_);
			last_pos = min_pos;
		}
	}
	_tmp1847_ = async_call;
	if (_tmp1847_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1858_;
			ValaHashMap* _tmp1859_;
			gpointer _tmp1860_;
			ValaCCodeExpression* _tmp1861_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1848_;
				ValaSet* _tmp1849_;
				ValaSet* _tmp1850_;
				ValaIterator* _tmp1851_;
				ValaIterator* _tmp1852_;
				_tmp1848_ = in_arg_map;
				_tmp1849_ = vala_map_get_keys ((ValaMap*) _tmp1848_);
				_tmp1850_ = _tmp1849_;
				_tmp1851_ = vala_iterable_iterator ((ValaIterable*) _tmp1850_);
				_tmp1852_ = _tmp1851_;
				_vala_iterable_unref0 (_tmp1850_);
				_pos_it = _tmp1852_;
				while (TRUE) {
					ValaIterator* _tmp1853_;
					gint pos = 0;
					ValaIterator* _tmp1854_;
					gpointer _tmp1855_;
					gboolean _tmp1856_ = FALSE;
					_tmp1853_ = _pos_it;
					if (!vala_iterator_next (_tmp1853_)) {
						break;
					}
					_tmp1854_ = _pos_it;
					_tmp1855_ = vala_iterator_get (_tmp1854_);
					pos = (gint) ((gintptr) _tmp1855_);
					if (pos > last_pos) {
						gboolean _tmp1857_ = FALSE;
						if (min_pos == -1) {
							_tmp1857_ = TRUE;
						} else {
							_tmp1857_ = pos < min_pos;
						}
						_tmp1856_ = _tmp1857_;
					} else {
						_tmp1856_ = FALSE;
					}
					if (_tmp1856_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1858_ = async_call;
			_tmp1859_ = in_arg_map;
			_tmp1860_ = vala_map_get ((ValaMap*) _tmp1859_, (gpointer) ((gintptr) min_pos));
			_tmp1861_ = (ValaCCodeExpression*) _tmp1860_;
			vala_ccode_function_call_add_argument (_tmp1858_, _tmp1861_);
			_vala_ccode_node_unref0 (_tmp1861_);
			last_pos = min_pos;
		}
	}
	_tmp1862_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1863_ = _tmp1862_;
	if (_tmp1863_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1864_;
		gint _tmp1865_;
		ValaCCodeFunction* _tmp1866_;
		ValaCCodeFunction* _tmp1867_;
		ValaCCodeIdentifier* _tmp1868_;
		ValaCCodeIdentifier* _tmp1869_;
		ValaCCodeMemberAccess* _tmp1870_;
		ValaCCodeMemberAccess* _tmp1871_;
		gchar* _tmp1872_;
		gchar* _tmp1873_;
		ValaCCodeConstant* _tmp1874_;
		ValaCCodeConstant* _tmp1875_;
		ValaCCodeFunction* _tmp1876_;
		ValaCCodeFunction* _tmp1877_;
		ValaCCodeFunctionCall* _tmp1878_;
		ValaCCodeFunction* _tmp1879_;
		ValaCCodeFunction* _tmp1880_;
		ValaCCodeConstant* _tmp1881_;
		ValaCCodeConstant* _tmp1882_;
		ValaCCodeFunction* _tmp1883_;
		ValaCCodeFunction* _tmp1884_;
		gchar* _tmp1885_;
		gchar* _tmp1886_;
		_tmp1864_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1865_ = _tmp1864_->next_coroutine_state;
		_tmp1864_->next_coroutine_state = _tmp1865_ + 1;
		state = _tmp1865_;
		_tmp1866_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1867_ = _tmp1866_;
		_tmp1868_ = vala_ccode_identifier_new ("_data_");
		_tmp1869_ = _tmp1868_;
		_tmp1870_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1869_, "_state_");
		_tmp1871_ = _tmp1870_;
		_tmp1872_ = g_strdup_printf ("%i", state);
		_tmp1873_ = _tmp1872_;
		_tmp1874_ = vala_ccode_constant_new (_tmp1873_);
		_tmp1875_ = _tmp1874_;
		vala_ccode_function_add_assignment (_tmp1867_, (ValaCCodeExpression*) _tmp1871_, (ValaCCodeExpression*) _tmp1875_);
		_vala_ccode_node_unref0 (_tmp1875_);
		_g_free0 (_tmp1873_);
		_vala_ccode_node_unref0 (_tmp1871_);
		_vala_ccode_node_unref0 (_tmp1869_);
		_tmp1876_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1877_ = _tmp1876_;
		_tmp1878_ = async_call;
		vala_ccode_function_add_expression (_tmp1877_, (ValaCCodeExpression*) _tmp1878_);
		_tmp1879_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1880_ = _tmp1879_;
		_tmp1881_ = vala_ccode_constant_new ("FALSE");
		_tmp1882_ = _tmp1881_;
		vala_ccode_function_add_return (_tmp1880_, (ValaCCodeExpression*) _tmp1882_);
		_vala_ccode_node_unref0 (_tmp1882_);
		_tmp1883_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1884_ = _tmp1883_;
		_tmp1885_ = g_strdup_printf ("_state_%d", state);
		_tmp1886_ = _tmp1885_;
		vala_ccode_function_add_label (_tmp1884_, _tmp1886_);
		_g_free0 (_tmp1886_);
	}
	_tmp1887_ = vala_method_call_get_is_assert (expr);
	_tmp1888_ = _tmp1887_;
	if (_tmp1888_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1889_;
		ValaSourceReference* _tmp1890_;
		ValaSourceLocation _tmp1891_ = {0};
		ValaSourceLocation _tmp1892_;
		gchar* _tmp1893_;
		ValaSourceReference* _tmp1894_;
		ValaSourceReference* _tmp1895_;
		ValaSourceLocation _tmp1896_ = {0};
		ValaSourceLocation _tmp1897_;
		gchar* _tmp1898_;
		ValaSourceReference* _tmp1899_;
		ValaSourceReference* _tmp1900_;
		ValaSourceLocation _tmp1901_ = {0};
		ValaSourceLocation _tmp1902_;
		gchar* _tmp1903_;
		gchar* _tmp1904_;
		ValaCCodeFunctionCall* _tmp1905_;
		ValaCCodeIdentifier* _tmp1906_;
		ValaCCodeIdentifier* _tmp1907_;
		ValaCCodeFunctionCall* _tmp1908_;
		const gchar* _tmp1909_;
		gchar* _tmp1910_;
		gchar* _tmp1911_;
		gchar* _tmp1912_;
		gchar* _tmp1913_;
		gchar* _tmp1914_;
		gchar* _tmp1915_;
		ValaCCodeConstant* _tmp1916_;
		ValaCCodeConstant* _tmp1917_;
		_tmp1889_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1890_ = _tmp1889_;
		vala_source_reference_get_begin (_tmp1890_, &_tmp1891_);
		_tmp1892_ = _tmp1891_;
		_tmp1893_ = _tmp1892_.pos;
		_tmp1894_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1895_ = _tmp1894_;
		vala_source_reference_get_end (_tmp1895_, &_tmp1896_);
		_tmp1897_ = _tmp1896_;
		_tmp1898_ = _tmp1897_.pos;
		_tmp1899_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1900_ = _tmp1899_;
		vala_source_reference_get_begin (_tmp1900_, &_tmp1901_);
		_tmp1902_ = _tmp1901_;
		_tmp1903_ = _tmp1902_.pos;
		_tmp1904_ = string_substring ((const gchar*) _tmp1893_, (glong) 0, (glong) ((gint) (_tmp1898_ - _tmp1903_)));
		message = _tmp1904_;
		_tmp1905_ = ccall;
		_tmp1906_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1907_ = _tmp1906_;
		vala_ccode_function_call_set_call (_tmp1905_, (ValaCCodeExpression*) _tmp1907_);
		_vala_ccode_node_unref0 (_tmp1907_);
		_tmp1908_ = ccall;
		_tmp1909_ = message;
		_tmp1910_ = string_replace (_tmp1909_, "\n", " ");
		_tmp1911_ = _tmp1910_;
		_tmp1912_ = g_strescape (_tmp1911_, "");
		_tmp1913_ = _tmp1912_;
		_tmp1914_ = g_strdup_printf ("\"%s\"", _tmp1913_);
		_tmp1915_ = _tmp1914_;
		_tmp1916_ = vala_ccode_constant_new (_tmp1915_);
		_tmp1917_ = _tmp1916_;
		vala_ccode_function_call_add_argument (_tmp1908_, (ValaCCodeExpression*) _tmp1917_);
		_vala_ccode_node_unref0 (_tmp1917_);
		_g_free0 (_tmp1915_);
		_g_free0 (_tmp1913_);
		_g_free0 (_tmp1911_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1918_;
		ValaCCodeFunction* _tmp1919_;
		ValaCCodeExpression* _tmp1920_;
		ValaCCodeExpression* _tmp1921_;
		ValaCCodeExpression* _tmp1922_;
		_tmp1918_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1919_ = _tmp1918_;
		_tmp1920_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1919_, _tmp1920_);
		_tmp1921_ = out_param_ref;
		_tmp1922_ = _vala_ccode_node_ref0 (_tmp1921_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1922_;
	}
	_tmp1925_ = m;
	if (_tmp1925_ != NULL) {
		ValaMethod* _tmp1926_;
		ValaMemberBinding _tmp1927_;
		ValaMemberBinding _tmp1928_;
		_tmp1926_ = m;
		_tmp1927_ = vala_method_get_binding (_tmp1926_);
		_tmp1928_ = _tmp1927_;
		_tmp1924_ = _tmp1928_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1924_ = FALSE;
	}
	if (_tmp1924_) {
		ValaMethod* _tmp1929_;
		gboolean _tmp1930_;
		gboolean _tmp1931_;
		_tmp1929_ = m;
		_tmp1930_ = vala_method_get_returns_modified_pointer (_tmp1929_);
		_tmp1931_ = _tmp1930_;
		_tmp1923_ = _tmp1931_;
	} else {
		_tmp1923_ = FALSE;
	}
	if (_tmp1923_) {
		gboolean _tmp1932_ = FALSE;
		gboolean _tmp1933_ = FALSE;
		ValaMemberAccess* _tmp1934_;
		_tmp1934_ = ma;
		if (_tmp1934_ != NULL) {
			ValaMemberAccess* _tmp1935_;
			ValaExpression* _tmp1936_;
			ValaExpression* _tmp1937_;
			ValaSymbol* _tmp1938_;
			ValaSymbol* _tmp1939_;
			_tmp1935_ = ma;
			_tmp1936_ = vala_member_access_get_inner (_tmp1935_);
			_tmp1937_ = _tmp1936_;
			_tmp1938_ = vala_expression_get_symbol_reference (_tmp1937_);
			_tmp1939_ = _tmp1938_;
			_tmp1933_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1939_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1933_ = FALSE;
		}
		if (_tmp1933_) {
			ValaMemberAccess* _tmp1940_;
			ValaExpression* _tmp1941_;
			ValaExpression* _tmp1942_;
			_tmp1940_ = ma;
			_tmp1941_ = vala_member_access_get_inner (_tmp1940_);
			_tmp1942_ = _tmp1941_;
			_tmp1932_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1942_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1932_ = FALSE;
		}
		if (_tmp1932_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1943_;
			ValaExpression* _tmp1944_;
			ValaExpression* _tmp1945_;
			ValaSymbol* _tmp1946_;
			ValaSymbol* _tmp1947_;
			ValaProperty* _tmp1948_;
			ValaProperty* _tmp1949_;
			ValaMemberAccess* _tmp1950_;
			ValaExpression* _tmp1951_;
			ValaExpression* _tmp1952_;
			ValaExpression* _tmp1953_;
			ValaExpression* _tmp1954_;
			ValaDataType* _tmp1955_;
			ValaDataType* _tmp1956_;
			ValaCCodeExpression* _tmp1957_;
			ValaGLibValue* _tmp1958_;
			ValaGLibValue* _tmp1959_;
			_tmp1943_ = ma;
			_tmp1944_ = vala_member_access_get_inner (_tmp1943_);
			_tmp1945_ = _tmp1944_;
			_tmp1946_ = vala_expression_get_symbol_reference (_tmp1945_);
			_tmp1947_ = _tmp1946_;
			_tmp1948_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1947_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1948_;
			_tmp1949_ = prop;
			_tmp1950_ = ma;
			_tmp1951_ = vala_member_access_get_inner (_tmp1950_);
			_tmp1952_ = _tmp1951_;
			_tmp1953_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1952_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1954_ = _tmp1953_;
			_tmp1955_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1956_ = _tmp1955_;
			_tmp1957_ = ccall_expr;
			_tmp1958_ = vala_glib_value_new (_tmp1956_, _tmp1957_, FALSE);
			_tmp1959_ = _tmp1958_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1949_, _tmp1954_, (ValaTargetValue*) _tmp1959_);
			_vala_target_value_unref0 (_tmp1959_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1960_;
			ValaCCodeExpression* _tmp1961_;
			ValaCCodeAssignment* _tmp1962_;
			_tmp1960_ = instance;
			_tmp1961_ = ccall_expr;
			_tmp1962_ = vala_ccode_assignment_new (_tmp1960_, _tmp1961_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1962_;
		}
	}
	_tmp1968_ = m;
	if (_tmp1968_ != NULL) {
		ValaMethod* _tmp1969_;
		_tmp1969_ = m;
		_tmp1967_ = vala_get_ccode_simple_generics (_tmp1969_);
	} else {
		_tmp1967_ = FALSE;
	}
	if (_tmp1967_) {
		ValaMethod* _tmp1970_;
		ValaDataType* _tmp1971_;
		ValaDataType* _tmp1972_;
		_tmp1970_ = m;
		_tmp1971_ = vala_callable_get_return_type ((ValaCallable*) _tmp1970_);
		_tmp1972_ = _tmp1971_;
		_tmp1966_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1972_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1966_ = FALSE;
	}
	if (_tmp1966_) {
		ValaDataType* _tmp1973_;
		ValaDataType* _tmp1974_;
		_tmp1973_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1974_ = _tmp1973_;
		_tmp1965_ = vala_data_type_is_real_struct_type (_tmp1974_);
	} else {
		_tmp1965_ = FALSE;
	}
	if (_tmp1965_) {
		ValaDataType* _tmp1975_;
		ValaDataType* _tmp1976_;
		gboolean _tmp1977_;
		gboolean _tmp1978_;
		_tmp1975_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1976_ = _tmp1975_;
		_tmp1977_ = vala_data_type_get_nullable (_tmp1976_);
		_tmp1978_ = _tmp1977_;
		_tmp1964_ = !_tmp1978_;
	} else {
		_tmp1964_ = FALSE;
	}
	if (_tmp1964_) {
		ValaDataType* _tmp1979_;
		ValaDataType* _tmp1980_;
		_tmp1979_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1980_ = _tmp1979_;
		_tmp1963_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1980_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1963_ = FALSE;
	}
	if (_tmp1963_) {
		ValaCCodeExpression* _tmp1981_;
		ValaCCodeParenthesizedExpression* _tmp1982_;
		ValaCCodeParenthesizedExpression* _tmp1983_;
		ValaCCodeUnaryExpression* _tmp1984_;
		_tmp1981_ = ccall_expr;
		_tmp1982_ = vala_ccode_parenthesized_expression_new (_tmp1981_);
		_tmp1983_ = _tmp1982_;
		_tmp1984_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1983_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1984_;
		_vala_ccode_node_unref0 (_tmp1983_);
	}
	_tmp1987_ = m;
	if (_tmp1987_ != NULL) {
		ValaMethod* _tmp1988_;
		gchar* _tmp1989_;
		gchar* _tmp1990_;
		_tmp1988_ = m;
		_tmp1989_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1988_);
		_tmp1990_ = _tmp1989_;
		_tmp1986_ = _tmp1990_ != NULL;
		_g_free0 (_tmp1990_);
	} else {
		_tmp1986_ = FALSE;
	}
	if (_tmp1986_) {
		ValaMethod* _tmp1991_;
		gchar* _tmp1992_;
		gchar* _tmp1993_;
		ValaMethod* _tmp1994_;
		ValaDataType* _tmp1995_;
		ValaDataType* _tmp1996_;
		gchar* _tmp1997_;
		gchar* _tmp1998_;
		_tmp1991_ = m;
		_tmp1992_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1991_);
		_tmp1993_ = _tmp1992_;
		_tmp1994_ = m;
		_tmp1995_ = vala_callable_get_return_type ((ValaCallable*) _tmp1994_);
		_tmp1996_ = _tmp1995_;
		_tmp1997_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1996_);
		_tmp1998_ = _tmp1997_;
		_tmp1985_ = g_strcmp0 (_tmp1993_, _tmp1998_) != 0;
		_g_free0 (_tmp1998_);
		_g_free0 (_tmp1993_);
	} else {
		_tmp1985_ = FALSE;
	}
	if (_tmp1985_) {
		ValaCCodeExpression* _tmp1999_;
		ValaMethod* _tmp2000_;
		ValaDataType* _tmp2001_;
		ValaDataType* _tmp2002_;
		gchar* _tmp2003_;
		gchar* _tmp2004_;
		ValaCCodeCastExpression* _tmp2005_;
		_tmp1999_ = ccall_expr;
		_tmp2000_ = m;
		_tmp2001_ = vala_callable_get_return_type ((ValaCallable*) _tmp2000_);
		_tmp2002_ = _tmp2001_;
		_tmp2003_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2002_);
		_tmp2004_ = _tmp2003_;
		_tmp2005_ = vala_ccode_cast_expression_new (_tmp1999_, _tmp2004_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp2005_;
		_g_free0 (_tmp2004_);
	}
	_tmp2006_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2006_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp2007_;
		ValaIterator* _tmp2008_;
		ValaIterator* _tmp2009_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp2010_;
		gpointer _tmp2011_;
		ValaExpression* _tmp2012_;
		ValaCCodeExpression* _tmp2013_;
		ValaCCodeExpression* _tmp2014_;
		ValaCCodeExpression* _tmp2015_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp2016_;
		ValaLocalVariable* _tmp2017_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp2018_;
		const gchar* _tmp2019_;
		const gchar* _tmp2020_;
		ValaCCodeExpression* _tmp2021_;
		ValaLocalVariable* _tmp2022_;
		ValaCCodeFile* _tmp2023_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp2024_;
		ValaExpression* _tmp2025_;
		ValaExpression* _tmp2026_;
		ValaCCodeExpression* _tmp2027_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp2028_;
		ValaExpression* _tmp2029_;
		ValaExpression* _tmp2030_;
		ValaCCodeExpression* _tmp2031_;
		ValaCCodeExpression* _tmp2032_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp2033_;
		ValaExpression* _tmp2034_;
		ValaExpression* _tmp2035_;
		ValaDataType* _tmp2036_;
		ValaDataType* _tmp2037_;
		ValaArrayType* _tmp2038_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp2039_;
		ValaDataType* _tmp2040_;
		ValaDataType* _tmp2041_;
		gchar* _tmp2042_;
		gchar* _tmp2043_;
		gchar* _tmp2044_;
		gchar* _tmp2045_;
		ValaCCodeIdentifier* _tmp2046_;
		ValaCCodeIdentifier* _tmp2047_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp2048_;
		ValaCCodeExpression* _tmp2049_;
		ValaCCodeBinaryExpression* _tmp2050_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp2051_;
		ValaCCodeExpression* _tmp2052_;
		ValaCCodeBinaryExpression* _tmp2053_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp2054_;
		ValaCCodeIdentifier* _tmp2055_;
		ValaCCodeFunctionCall* _tmp2056_;
		ValaCCodeFunctionCall* _tmp2057_;
		ValaCCodeFunctionCall* _tmp2058_;
		ValaCCodeExpression* _tmp2059_;
		ValaCCodeExpression* _tmp2060_;
		ValaCCodeBinaryExpression* _tmp2061_;
		ValaCCodeBinaryExpression* _tmp2062_;
		ValaCCodeFunctionCall* _tmp2063_;
		ValaCCodeConstant* _tmp2064_;
		ValaCCodeConstant* _tmp2065_;
		ValaCCodeFunctionCall* _tmp2066_;
		ValaCCodeIdentifier* _tmp2067_;
		ValaCCodeBinaryExpression* _tmp2068_;
		ValaCCodeBinaryExpression* _tmp2069_;
		ValaCCodeBinaryExpression* _tmp2070_;
		ValaCCodeFunction* _tmp2071_;
		ValaCCodeFunction* _tmp2072_;
		ValaCCodeExpression* _tmp2073_;
		ValaCCodeExpression* _tmp2074_;
		ValaCCodeFunction* _tmp2075_;
		ValaCCodeFunction* _tmp2076_;
		ValaCCodeExpression* _tmp2077_;
		ValaCCodeFunction* _tmp2078_;
		ValaCCodeFunction* _tmp2079_;
		ValaCCodeBinaryExpression* _tmp2080_;
		ValaCCodeFunctionCall* _tmp2081_;
		ValaCCodeConstant* _tmp2082_;
		ValaCCodeConstant* _tmp2083_;
		ValaCCodeConditionalExpression* _tmp2084_;
		ValaCCodeConditionalExpression* _tmp2085_;
		ValaCCodeFunction* _tmp2086_;
		ValaCCodeFunction* _tmp2087_;
		ValaMemberAccess* _tmp2088_;
		ValaExpression* _tmp2089_;
		ValaExpression* _tmp2090_;
		ValaCCodeExpression* _tmp2091_;
		ValaCCodeExpression* _tmp2092_;
		ValaCCodeExpression* _tmp2093_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp2094_;
		ValaExpression* _tmp2095_;
		ValaExpression* _tmp2096_;
		ValaSymbol* _tmp2097_;
		ValaSymbol* _tmp2098_;
		ValaSymbol* _tmp2099_;
		gboolean _tmp2100_ = FALSE;
		gboolean _tmp2101_ = FALSE;
		ValaSymbol* _tmp2102_;
		_tmp2007_ = vala_method_call_get_argument_list (expr);
		_tmp2008_ = vala_iterable_iterator ((ValaIterable*) _tmp2007_);
		arg_it = _tmp2008_;
		_tmp2009_ = arg_it;
		vala_iterator_next (_tmp2009_);
		_tmp2010_ = arg_it;
		_tmp2011_ = vala_iterator_get (_tmp2010_);
		_tmp2012_ = (ValaExpression*) _tmp2011_;
		_tmp2013_ = vala_get_cvalue (_tmp2012_);
		_tmp2014_ = _vala_ccode_node_ref0 (_tmp2013_);
		_tmp2015_ = _tmp2014_;
		_vala_code_node_unref0 (_tmp2012_);
		new_size = _tmp2015_;
		_tmp2016_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp2017_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2016_, TRUE, NULL, FALSE);
		temp_decl = _tmp2017_;
		_tmp2018_ = temp_decl;
		_tmp2019_ = vala_symbol_get_name ((ValaSymbol*) _tmp2018_);
		_tmp2020_ = _tmp2019_;
		_tmp2021_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2020_);
		temp_ref = _tmp2021_;
		_tmp2022_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2022_, FALSE);
		_tmp2023_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp2023_, "string.h", FALSE);
		_tmp2024_ = ma;
		_tmp2025_ = vala_member_access_get_inner (_tmp2024_);
		_tmp2026_ = _tmp2025_;
		_tmp2027_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp2026_, 1);
		clen = _tmp2027_;
		_tmp2028_ = ma;
		_tmp2029_ = vala_member_access_get_inner (_tmp2028_);
		_tmp2030_ = _tmp2029_;
		_tmp2031_ = vala_get_cvalue (_tmp2030_);
		_tmp2032_ = _vala_ccode_node_ref0 (_tmp2031_);
		celems = _tmp2032_;
		_tmp2033_ = ma;
		_tmp2034_ = vala_member_access_get_inner (_tmp2033_);
		_tmp2035_ = _tmp2034_;
		_tmp2036_ = vala_expression_get_value_type (_tmp2035_);
		_tmp2037_ = _tmp2036_;
		_tmp2038_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2037_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp2038_;
		_tmp2039_ = array_type;
		_tmp2040_ = vala_array_type_get_element_type (_tmp2039_);
		_tmp2041_ = _tmp2040_;
		_tmp2042_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2041_);
		_tmp2043_ = _tmp2042_;
		_tmp2044_ = g_strdup_printf ("sizeof (%s)", _tmp2043_);
		_tmp2045_ = _tmp2044_;
		_tmp2046_ = vala_ccode_identifier_new (_tmp2045_);
		_tmp2047_ = _tmp2046_;
		_g_free0 (_tmp2045_);
		_g_free0 (_tmp2043_);
		csizeof = _tmp2047_;
		_tmp2048_ = temp_ref;
		_tmp2049_ = clen;
		_tmp2050_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp2048_, _tmp2049_);
		cdelta = _tmp2050_;
		_tmp2051_ = temp_ref;
		_tmp2052_ = clen;
		_tmp2053_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp2051_, _tmp2052_);
		ccheck = _tmp2053_;
		_tmp2054_ = vala_ccode_identifier_new ("memset");
		_tmp2055_ = _tmp2054_;
		_tmp2056_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2055_);
		_tmp2057_ = _tmp2056_;
		_vala_ccode_node_unref0 (_tmp2055_);
		czero = _tmp2057_;
		_tmp2058_ = czero;
		_tmp2059_ = celems;
		_tmp2060_ = clen;
		_tmp2061_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp2059_, _tmp2060_);
		_tmp2062_ = _tmp2061_;
		vala_ccode_function_call_add_argument (_tmp2058_, (ValaCCodeExpression*) _tmp2062_);
		_vala_ccode_node_unref0 (_tmp2062_);
		_tmp2063_ = czero;
		_tmp2064_ = vala_ccode_constant_new ("0");
		_tmp2065_ = _tmp2064_;
		vala_ccode_function_call_add_argument (_tmp2063_, (ValaCCodeExpression*) _tmp2065_);
		_vala_ccode_node_unref0 (_tmp2065_);
		_tmp2066_ = czero;
		_tmp2067_ = csizeof;
		_tmp2068_ = cdelta;
		_tmp2069_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp2067_, (ValaCCodeExpression*) _tmp2068_);
		_tmp2070_ = _tmp2069_;
		vala_ccode_function_call_add_argument (_tmp2066_, (ValaCCodeExpression*) _tmp2070_);
		_vala_ccode_node_unref0 (_tmp2070_);
		_tmp2071_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2072_ = _tmp2071_;
		_tmp2073_ = temp_ref;
		_tmp2074_ = new_size;
		vala_ccode_function_add_assignment (_tmp2072_, _tmp2073_, _tmp2074_);
		_tmp2075_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2076_ = _tmp2075_;
		_tmp2077_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp2076_, _tmp2077_);
		_tmp2078_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2079_ = _tmp2078_;
		_tmp2080_ = ccheck;
		_tmp2081_ = czero;
		_tmp2082_ = vala_ccode_constant_new ("NULL");
		_tmp2083_ = _tmp2082_;
		_tmp2084_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp2080_, (ValaCCodeExpression*) _tmp2081_, (ValaCCodeExpression*) _tmp2083_);
		_tmp2085_ = _tmp2084_;
		vala_ccode_function_add_expression (_tmp2079_, (ValaCCodeExpression*) _tmp2085_);
		_vala_ccode_node_unref0 (_tmp2085_);
		_vala_ccode_node_unref0 (_tmp2083_);
		_tmp2086_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2087_ = _tmp2086_;
		_tmp2088_ = ma;
		_tmp2089_ = vala_member_access_get_inner (_tmp2088_);
		_tmp2090_ = _tmp2089_;
		_tmp2091_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp2090_, 1);
		_tmp2092_ = _tmp2091_;
		_tmp2093_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp2087_, _tmp2092_, _tmp2093_);
		_vala_ccode_node_unref0 (_tmp2092_);
		_tmp2094_ = ma;
		_tmp2095_ = vala_member_access_get_inner (_tmp2094_);
		_tmp2096_ = _tmp2095_;
		_tmp2097_ = vala_expression_get_symbol_reference (_tmp2096_);
		_tmp2098_ = _tmp2097_;
		_tmp2099_ = _vala_code_node_ref0 (_tmp2098_);
		array_var = _tmp2099_;
		_tmp2102_ = array_var;
		if (_tmp2102_ != NULL) {
			ValaSymbol* _tmp2103_;
			_tmp2103_ = array_var;
			_tmp2101_ = vala_symbol_is_internal_symbol (_tmp2103_);
		} else {
			_tmp2101_ = FALSE;
		}
		if (_tmp2101_) {
			gboolean _tmp2104_ = FALSE;
			ValaSymbol* _tmp2105_;
			_tmp2105_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2105_, VALA_TYPE_LOCAL_VARIABLE)) {
				_tmp2104_ = TRUE;
			} else {
				ValaSymbol* _tmp2106_;
				_tmp2106_ = array_var;
				_tmp2104_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2106_, VALA_TYPE_FIELD);
			}
			_tmp2100_ = _tmp2104_;
		} else {
			_tmp2100_ = FALSE;
		}
		if (_tmp2100_) {
			ValaCCodeFunction* _tmp2107_;
			ValaCCodeFunction* _tmp2108_;
			ValaMemberAccess* _tmp2109_;
			ValaExpression* _tmp2110_;
			ValaExpression* _tmp2111_;
			ValaTargetValue* _tmp2112_;
			ValaTargetValue* _tmp2113_;
			ValaCCodeExpression* _tmp2114_;
			ValaCCodeExpression* _tmp2115_;
			_tmp2107_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp2108_ = _tmp2107_;
			_tmp2109_ = ma;
			_tmp2110_ = vala_member_access_get_inner (_tmp2109_);
			_tmp2111_ = _tmp2110_;
			_tmp2112_ = vala_expression_get_target_value (_tmp2111_);
			_tmp2113_ = _tmp2112_;
			_tmp2114_ = vala_get_array_size_cvalue (_tmp2113_);
			_tmp2115_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp2108_, _tmp2114_, _tmp2115_);
		}
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp2117_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp2118_ = _tmp2117_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2118_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp2119_;
		ValaDataType* _tmp2120_;
		_tmp2119_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp2120_ = _tmp2119_;
		_tmp2116_ = !vala_data_type_is_disposable (_tmp2120_);
	} else {
		_tmp2116_ = FALSE;
	}
	if (_tmp2116_) {
		gboolean _tmp2121_ = FALSE;
		ValaCCodeExpression* _tmp2122_;
		_tmp2122_ = ccall_expr;
		if (_tmp2122_ != NULL) {
			_tmp2121_ = !return_result_via_out_param;
		} else {
			_tmp2121_ = FALSE;
		}
		if (_tmp2121_) {
			ValaCCodeFunction* _tmp2123_;
			ValaCCodeFunction* _tmp2124_;
			ValaCCodeExpression* _tmp2125_;
			_tmp2123_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp2124_ = _tmp2123_;
			_tmp2125_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp2124_, _tmp2125_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp2126_;
		ValaDataType* _tmp2127_;
		ValaDataType* _tmp2128_;
		gboolean _tmp2129_ = FALSE;
		ValaDataType* _tmp2130_;
		ValaDataType* _tmp2131_;
		gboolean _tmp2184_ = FALSE;
		ValaMethod* _tmp2185_;
		_tmp2126_ = itype;
		_tmp2127_ = vala_data_type_get_return_type (_tmp2126_);
		_tmp2128_ = _vala_code_node_ref0 (_tmp2127_);
		result_type = _tmp2128_;
		_tmp2130_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp2131_ = _tmp2130_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2131_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp2132_;
			ValaDataType* _tmp2133_;
			_tmp2132_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp2133_ = _tmp2132_;
			_tmp2129_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp2133_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp2129_ = FALSE;
		}
		if (_tmp2129_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp2134_;
			ValaDataType* _tmp2135_;
			ValaTypeParameter* _tmp2136_;
			ValaTypeParameter* _tmp2137_;
			ValaTypeParameter* _tmp2138_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp2139_;
			ValaSymbol* _tmp2140_;
			ValaSymbol* _tmp2141_;
			ValaSymbol* _tmp2142_;
			ValaSymbol* _tmp2143_;
			ValaStruct* _tmp2144_;
			gboolean _tmp2145_ = FALSE;
			ValaTypeParameter* _tmp2146_;
			ValaSymbol* _tmp2147_;
			ValaSymbol* _tmp2148_;
			ValaTypeSymbol* _tmp2149_;
			gboolean _tmp2158_ = FALSE;
			gboolean _tmp2159_ = FALSE;
			ValaStruct* _tmp2160_;
			_tmp2134_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp2135_ = _tmp2134_;
			_tmp2136_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp2135_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp2137_ = _tmp2136_;
			_tmp2138_ = _vala_code_node_ref0 (_tmp2137_);
			type_parameter = _tmp2138_;
			_tmp2139_ = type_parameter;
			_tmp2140_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2139_);
			_tmp2141_ = _tmp2140_;
			_tmp2142_ = vala_symbol_get_parent_symbol (_tmp2141_);
			_tmp2143_ = _tmp2142_;
			_tmp2144_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2143_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp2143_) : NULL);
			st = _tmp2144_;
			_tmp2146_ = type_parameter;
			_tmp2147_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2146_);
			_tmp2148_ = _tmp2147_;
			_tmp2149_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp2148_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2149_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp2145_ = TRUE;
			} else {
				gboolean _tmp2150_ = FALSE;
				ValaStruct* _tmp2151_;
				_tmp2151_ = st;
				if (_tmp2151_ != NULL) {
					ValaStruct* _tmp2152_;
					gchar* _tmp2153_;
					gchar* _tmp2154_;
					_tmp2152_ = st;
					_tmp2153_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2152_);
					_tmp2154_ = _tmp2153_;
					_tmp2150_ = g_strcmp0 (_tmp2154_, "va_list") == 0;
					_g_free0 (_tmp2154_);
				} else {
					_tmp2150_ = FALSE;
				}
				_tmp2145_ = _tmp2150_;
			}
			if (_tmp2145_) {
				ValaDataType* _tmp2155_;
				ValaDataType* _tmp2156_;
				ValaDataType* _tmp2157_;
				_tmp2155_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp2156_ = _tmp2155_;
				_tmp2157_ = _vala_code_node_ref0 (_tmp2156_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp2157_;
			}
			_tmp2160_ = st;
			if (_tmp2160_ != NULL) {
				ValaStruct* _tmp2161_;
				gchar* _tmp2162_;
				gchar* _tmp2163_;
				_tmp2161_ = st;
				_tmp2162_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2161_);
				_tmp2163_ = _tmp2162_;
				_tmp2159_ = g_strcmp0 (_tmp2163_, "va_list") == 0;
				_g_free0 (_tmp2163_);
			} else {
				_tmp2159_ = FALSE;
			}
			if (_tmp2159_) {
				ValaMemberAccess* _tmp2164_;
				const gchar* _tmp2165_;
				const gchar* _tmp2166_;
				_tmp2164_ = ma;
				_tmp2165_ = vala_member_access_get_member_name (_tmp2164_);
				_tmp2166_ = _tmp2165_;
				_tmp2158_ = g_strcmp0 (_tmp2166_, "arg") == 0;
			} else {
				_tmp2158_ = FALSE;
			}
			if (_tmp2158_) {
				gboolean _tmp2167_ = FALSE;
				ValaDataType* _tmp2168_;
				_tmp2168_ = result_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2168_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDataType* _tmp2169_;
					ValaDelegate* _tmp2170_;
					ValaDelegate* _tmp2171_;
					gboolean _tmp2172_;
					gboolean _tmp2173_;
					_tmp2169_ = result_type;
					_tmp2170_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp2169_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp2171_ = _tmp2170_;
					_tmp2172_ = vala_delegate_get_has_target (_tmp2171_);
					_tmp2173_ = _tmp2172_;
					_tmp2167_ = _tmp2173_;
				} else {
					_tmp2167_ = FALSE;
				}
				if (_tmp2167_) {
					ValaGLibValue* arg_value = NULL;
					ValaTargetValue* _tmp2174_;
					ValaTargetValue* _tmp2175_;
					ValaGLibValue* _tmp2176_;
					ValaCCodeExpression* _tmp2177_;
					ValaGLibValue* _tmp2180_;
					ValaCCodeExpression* _tmp2181_;
					vala_set_cvalue ((ValaExpression*) expr, NULL);
					_tmp2174_ = vala_expression_get_target_value ((ValaExpression*) expr);
					_tmp2175_ = _tmp2174_;
					arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp2175_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
					_tmp2176_ = arg_value;
					_tmp2177_ = _tmp2176_->delegate_target_cvalue;
					if (_tmp2177_ == NULL) {
						ValaGLibValue* _tmp2178_;
						ValaCCodeConstant* _tmp2179_;
						_tmp2178_ = arg_value;
						_tmp2179_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2178_->delegate_target_cvalue);
						_tmp2178_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp2179_;
					}
					_tmp2180_ = arg_value;
					_tmp2181_ = _tmp2180_->delegate_target_destroy_notify_cvalue;
					if (_tmp2181_ == NULL) {
						ValaGLibValue* _tmp2182_;
						ValaCCodeConstant* _tmp2183_;
						_tmp2182_ = arg_value;
						_tmp2183_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2182_->delegate_target_destroy_notify_cvalue);
						_tmp2182_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp2183_;
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp2185_ = m;
		if (_tmp2185_ != NULL) {
			ValaMethod* _tmp2186_;
			_tmp2186_ = m;
			_tmp2184_ = vala_method_get_format_arg_index (_tmp2186_) >= 0;
		} else {
			_tmp2184_ = FALSE;
		}
		if (_tmp2184_) {
			ValaCCodeExpression* _tmp2187_;
			_tmp2187_ = ccall_expr;
			vala_set_cvalue ((ValaExpression*) expr, _tmp2187_);
		} else {
			gboolean _tmp2188_ = FALSE;
			ValaMethod* _tmp2189_;
			_tmp2189_ = m;
			if (_tmp2189_ != NULL) {
				ValaMethod* _tmp2190_;
				_tmp2190_ = m;
				_tmp2188_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp2190_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp2188_ = FALSE;
			}
			if (_tmp2188_) {
				ValaCCodeExpression* _tmp2191_;
				_tmp2191_ = ccall_expr;
				vala_set_cvalue ((ValaExpression*) expr, _tmp2191_);
			} else {
				gboolean _tmp2192_ = FALSE;
				gboolean _tmp2193_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp2193_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp2193_ = FALSE;
				}
				if (_tmp2193_) {
					gboolean _tmp2194_ = FALSE;
					ValaDataType* _tmp2195_;
					_tmp2195_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2195_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2196_;
						_tmp2196_ = result_type;
						_tmp2194_ = !vala_data_type_is_disposable (_tmp2196_);
					} else {
						_tmp2194_ = FALSE;
					}
					_tmp2192_ = _tmp2194_;
				} else {
					_tmp2192_ = FALSE;
				}
				if (_tmp2192_) {
					ValaCCodeExpression* _tmp2197_;
					_tmp2197_ = ccall_expr;
					vala_set_cvalue ((ValaExpression*) expr, _tmp2197_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2198_;
						ValaDataType* _tmp2199_;
						gboolean _tmp2200_;
						gboolean _tmp2201_;
						ValaLocalVariable* _tmp2202_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2203_;
						const gchar* _tmp2204_;
						const gchar* _tmp2205_;
						ValaCCodeExpression* _tmp2206_;
						ValaLocalVariable* _tmp2207_;
						ValaCCodeFunction* _tmp2208_;
						ValaCCodeFunction* _tmp2209_;
						ValaCCodeExpression* _tmp2210_;
						ValaCCodeExpression* _tmp2211_;
						ValaCCodeExpression* _tmp2212_;
						ValaTargetValue* _tmp2213_;
						ValaTargetValue* _tmp2214_;
						_tmp2198_ = result_type;
						_tmp2199_ = result_type;
						_tmp2200_ = vala_data_type_get_value_owned (_tmp2199_);
						_tmp2201_ = _tmp2200_;
						_tmp2202_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2198_, _tmp2201_, NULL, FALSE);
						temp_var = _tmp2202_;
						_tmp2203_ = temp_var;
						_tmp2204_ = vala_symbol_get_name ((ValaSymbol*) _tmp2203_);
						_tmp2205_ = _tmp2204_;
						_tmp2206_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2205_);
						temp_ref = _tmp2206_;
						_tmp2207_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2207_, FALSE);
						_tmp2208_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2209_ = _tmp2208_;
						_tmp2210_ = temp_ref;
						_tmp2211_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2209_, _tmp2210_, _tmp2211_);
						_tmp2212_ = temp_ref;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2212_);
						_tmp2213_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2214_ = _tmp2213_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2214_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2215_;
						ValaTargetValue* _tmp2216_;
						ValaTargetValue* _tmp2217_;
						_tmp2215_ = ccall_expr;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2215_);
						_tmp2216_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2217_ = _tmp2216_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2217_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2218_ = params;
	_tmp2219_ = vala_iterable_iterator ((ValaIterable*) _tmp2218_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2219_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2220_;
		ValaList* _tmp2221_;
		gint _arg_size = 0;
		ValaList* _tmp2222_;
		gint _tmp2223_;
		gint _tmp2224_;
		gint _arg_index = 0;
		_tmp2220_ = vala_method_call_get_argument_list (expr);
		_tmp2221_ = _vala_iterable_ref0 (_tmp2220_);
		_arg_list = _tmp2221_;
		_tmp2222_ = _arg_list;
		_tmp2223_ = vala_collection_get_size ((ValaCollection*) _tmp2222_);
		_tmp2224_ = _tmp2223_;
		_arg_size = _tmp2224_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp2225_;
			gint _tmp2226_;
			ValaExpression* arg = NULL;
			ValaList* _tmp2227_;
			gpointer _tmp2228_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2229_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2232_;
			ValaUnaryExpression* _tmp2233_;
			gboolean _tmp2234_ = FALSE;
			ValaUnaryExpression* _tmp2235_;
			gboolean _tmp2293_ = FALSE;
			ValaUnaryExpression* _tmp2294_;
			ValaUnaryExpression* _tmp2298_;
			ValaExpression* _tmp2299_;
			ValaExpression* _tmp2300_;
			ValaDataType* _tmp2301_;
			ValaDataType* _tmp2302_;
			gboolean _tmp2312_ = FALSE;
			ValaMemberAccess* _tmp2313_;
			ValaSymbol* _tmp2314_;
			ValaSymbol* _tmp2315_;
			ValaUnaryExpression* _tmp2331_;
			ValaExpression* _tmp2332_;
			ValaExpression* _tmp2333_;
			ValaTargetValue* _tmp2334_;
			ValaTargetValue* _tmp2335_;
			ValaUnaryExpression* _tmp2336_;
			ValaTargetValue* _tmp2337_;
			ValaTargetValue* _tmp2338_;
			ValaUnaryExpression* _tmp2339_;
			ValaExpression* _tmp2340_;
			ValaExpression* _tmp2341_;
			ValaDataType* _tmp2342_;
			ValaDataType* _tmp2343_;
			ValaExpression* _tmp2344_;
			ValaTargetValue* _tmp2345_;
			ValaTargetValue* _tmp2346_;
			ValaSourceReference* _tmp2347_;
			ValaSourceReference* _tmp2348_;
			gboolean _tmp2349_ = FALSE;
			ValaParameter* _tmp2350_;
			_arg_index = _arg_index + 1;
			_tmp2225_ = _arg_index;
			_tmp2226_ = _arg_size;
			if (!(_tmp2225_ < _tmp2226_)) {
				break;
			}
			_tmp2227_ = _arg_list;
			_tmp2228_ = vala_list_get (_tmp2227_, _arg_index);
			arg = (ValaExpression*) _tmp2228_;
			param = NULL;
			_tmp2229_ = params_it;
			if (vala_iterator_next (_tmp2229_)) {
				ValaIterator* _tmp2230_;
				gpointer _tmp2231_;
				_tmp2230_ = params_it;
				_tmp2231_ = vala_iterator_get (_tmp2230_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2231_;
			}
			_tmp2232_ = arg;
			_tmp2233_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2232_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2232_) : NULL);
			unary = _tmp2233_;
			_tmp2235_ = unary;
			if (_tmp2235_ != NULL) {
				ValaUnaryExpression* _tmp2236_;
				ValaUnaryOperator _tmp2237_;
				ValaUnaryOperator _tmp2238_;
				_tmp2236_ = unary;
				_tmp2237_ = vala_unary_expression_get_operator (_tmp2236_);
				_tmp2238_ = _tmp2237_;
				_tmp2234_ = _tmp2238_ == VALA_UNARY_OPERATOR_REF;
			} else {
				_tmp2234_ = FALSE;
			}
			if (_tmp2234_) {
				gboolean _tmp2239_ = FALSE;
				gboolean _tmp2240_ = FALSE;
				gboolean _tmp2241_ = FALSE;
				gboolean _tmp2242_ = FALSE;
				ValaParameter* _tmp2243_;
				_tmp2243_ = param;
				if (_tmp2243_ != NULL) {
					ValaParameter* _tmp2244_;
					_tmp2244_ = param;
					_tmp2242_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp2244_);
				} else {
					_tmp2242_ = FALSE;
				}
				if (_tmp2242_) {
					ValaParameter* _tmp2245_;
					ValaDataType* _tmp2246_;
					ValaDataType* _tmp2247_;
					_tmp2245_ = param;
					_tmp2246_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2245_);
					_tmp2247_ = _tmp2246_;
					_tmp2241_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2247_, VALA_TYPE_ARRAY_TYPE);
				} else {
					_tmp2241_ = FALSE;
				}
				if (_tmp2241_) {
					ValaParameter* _tmp2248_;
					ValaDataType* _tmp2249_;
					ValaDataType* _tmp2250_;
					gboolean _tmp2251_;
					gboolean _tmp2252_;
					_tmp2248_ = param;
					_tmp2249_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2248_);
					_tmp2250_ = _tmp2249_;
					_tmp2251_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2250_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2252_ = _tmp2251_;
					_tmp2240_ = !_tmp2252_;
				} else {
					_tmp2240_ = FALSE;
				}
				if (_tmp2240_) {
					ValaParameter* _tmp2253_;
					ValaDataType* _tmp2254_;
					ValaDataType* _tmp2255_;
					gint _tmp2256_;
					gint _tmp2257_;
					_tmp2253_ = param;
					_tmp2254_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2253_);
					_tmp2255_ = _tmp2254_;
					_tmp2256_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp2255_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2257_ = _tmp2256_;
					_tmp2239_ = _tmp2257_ == 1;
				} else {
					_tmp2239_ = FALSE;
				}
				if (_tmp2239_) {
					ValaVariable* array_var = NULL;
					ValaUnaryExpression* _tmp2258_;
					ValaExpression* _tmp2259_;
					ValaExpression* _tmp2260_;
					ValaSymbol* _tmp2261_;
					ValaSymbol* _tmp2262_;
					gboolean _tmp2263_ = FALSE;
					gboolean _tmp2264_ = FALSE;
					gboolean _tmp2265_ = FALSE;
					gboolean _tmp2266_ = FALSE;
					ValaVariable* _tmp2267_;
					_tmp2258_ = unary;
					_tmp2259_ = vala_unary_expression_get_inner (_tmp2258_);
					_tmp2260_ = _tmp2259_;
					_tmp2261_ = vala_expression_get_symbol_reference (_tmp2260_);
					_tmp2262_ = _tmp2261_;
					array_var = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2262_, VALA_TYPE_VARIABLE) ? ((ValaVariable*) _tmp2262_) : NULL;
					_tmp2267_ = array_var;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2267_, VALA_TYPE_LOCAL_VARIABLE)) {
						_tmp2266_ = TRUE;
					} else {
						ValaVariable* _tmp2268_;
						_tmp2268_ = array_var;
						_tmp2266_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2268_, VALA_TYPE_FIELD);
					}
					if (_tmp2266_) {
						ValaVariable* _tmp2269_;
						_tmp2269_ = array_var;
						_tmp2265_ = vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp2269_);
					} else {
						_tmp2265_ = FALSE;
					}
					if (_tmp2265_) {
						ValaVariable* _tmp2270_;
						ValaDataType* _tmp2271_;
						ValaDataType* _tmp2272_;
						_tmp2270_ = array_var;
						_tmp2271_ = vala_variable_get_variable_type (_tmp2270_);
						_tmp2272_ = _tmp2271_;
						_tmp2264_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2272_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp2264_ = FALSE;
					}
					if (_tmp2264_) {
						ValaVariable* _tmp2273_;
						ValaDataType* _tmp2274_;
						ValaDataType* _tmp2275_;
						gboolean _tmp2276_;
						gboolean _tmp2277_;
						_tmp2273_ = array_var;
						_tmp2274_ = vala_variable_get_variable_type (_tmp2273_);
						_tmp2275_ = _tmp2274_;
						_tmp2276_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2275_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp2277_ = _tmp2276_;
						_tmp2263_ = !_tmp2277_;
					} else {
						_tmp2263_ = FALSE;
					}
					if (_tmp2263_) {
						ValaCCodeFunction* _tmp2278_;
						ValaCCodeFunction* _tmp2279_;
						ValaUnaryExpression* _tmp2280_;
						ValaExpression* _tmp2281_;
						ValaExpression* _tmp2282_;
						ValaTargetValue* _tmp2283_;
						ValaTargetValue* _tmp2284_;
						ValaCCodeExpression* _tmp2285_;
						ValaUnaryExpression* _tmp2286_;
						ValaExpression* _tmp2287_;
						ValaExpression* _tmp2288_;
						ValaTargetValue* _tmp2289_;
						ValaTargetValue* _tmp2290_;
						ValaCCodeExpression* _tmp2291_;
						ValaCCodeExpression* _tmp2292_;
						_tmp2278_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2279_ = _tmp2278_;
						_tmp2280_ = unary;
						_tmp2281_ = vala_unary_expression_get_inner (_tmp2280_);
						_tmp2282_ = _tmp2281_;
						_tmp2283_ = vala_expression_get_target_value (_tmp2282_);
						_tmp2284_ = _tmp2283_;
						_tmp2285_ = vala_get_array_size_cvalue (_tmp2284_);
						_tmp2286_ = unary;
						_tmp2287_ = vala_unary_expression_get_inner (_tmp2286_);
						_tmp2288_ = _tmp2287_;
						_tmp2289_ = vala_expression_get_target_value (_tmp2288_);
						_tmp2290_ = _tmp2289_;
						_tmp2291_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2290_, 1);
						_tmp2292_ = _tmp2291_;
						vala_ccode_function_add_assignment (_tmp2279_, _tmp2285_, _tmp2292_);
						_vala_ccode_node_unref0 (_tmp2292_);
					}
				}
			}
			_tmp2294_ = unary;
			if (_tmp2294_ == NULL) {
				_tmp2293_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2295_;
				ValaUnaryOperator _tmp2296_;
				ValaUnaryOperator _tmp2297_;
				_tmp2295_ = unary;
				_tmp2296_ = vala_unary_expression_get_operator (_tmp2295_);
				_tmp2297_ = _tmp2296_;
				_tmp2293_ = _tmp2297_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2293_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2298_ = unary;
			_tmp2299_ = vala_unary_expression_get_inner (_tmp2298_);
			_tmp2300_ = _tmp2299_;
			_tmp2301_ = vala_expression_get_value_type (_tmp2300_);
			_tmp2302_ = _tmp2301_;
			if (vala_ccode_base_module_requires_destroy (_tmp2302_)) {
				ValaCCodeFunction* _tmp2303_;
				ValaCCodeFunction* _tmp2304_;
				ValaUnaryExpression* _tmp2305_;
				ValaExpression* _tmp2306_;
				ValaExpression* _tmp2307_;
				ValaTargetValue* _tmp2308_;
				ValaTargetValue* _tmp2309_;
				ValaCCodeExpression* _tmp2310_;
				ValaCCodeExpression* _tmp2311_;
				_tmp2303_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2304_ = _tmp2303_;
				_tmp2305_ = unary;
				_tmp2306_ = vala_unary_expression_get_inner (_tmp2305_);
				_tmp2307_ = _tmp2306_;
				_tmp2308_ = vala_expression_get_target_value (_tmp2307_);
				_tmp2309_ = _tmp2308_;
				_tmp2310_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2309_, FALSE);
				_tmp2311_ = _tmp2310_;
				vala_ccode_function_add_expression (_tmp2304_, _tmp2311_);
				_vala_ccode_node_unref0 (_tmp2311_);
			}
			_tmp2313_ = ma;
			_tmp2314_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2313_);
			_tmp2315_ = _tmp2314_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2315_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2316_;
				ValaTargetValue* _tmp2317_;
				ValaTargetValue* _tmp2318_;
				ValaDataType* _tmp2319_;
				ValaDataType* _tmp2320_;
				_tmp2316_ = unary;
				_tmp2317_ = vala_expression_get_target_value ((ValaExpression*) _tmp2316_);
				_tmp2318_ = _tmp2317_;
				_tmp2319_ = vala_target_value_get_value_type (_tmp2318_);
				_tmp2320_ = _tmp2319_;
				_tmp2312_ = _tmp2320_ == NULL;
			} else {
				_tmp2312_ = FALSE;
			}
			if (_tmp2312_) {
				ValaUnaryExpression* _tmp2321_;
				ValaTargetValue* _tmp2322_;
				ValaTargetValue* _tmp2323_;
				ValaUnaryExpression* _tmp2324_;
				ValaExpression* _tmp2325_;
				ValaExpression* _tmp2326_;
				ValaDataType* _tmp2327_;
				ValaDataType* _tmp2328_;
				ValaDataType* _tmp2329_;
				ValaDataType* _tmp2330_;
				_tmp2321_ = unary;
				_tmp2322_ = vala_expression_get_target_value ((ValaExpression*) _tmp2321_);
				_tmp2323_ = _tmp2322_;
				_tmp2324_ = unary;
				_tmp2325_ = vala_unary_expression_get_inner (_tmp2324_);
				_tmp2326_ = _tmp2325_;
				_tmp2327_ = vala_expression_get_value_type (_tmp2326_);
				_tmp2328_ = _tmp2327_;
				_tmp2329_ = vala_data_type_copy (_tmp2328_);
				_tmp2330_ = _tmp2329_;
				vala_target_value_set_value_type (_tmp2323_, _tmp2330_);
				_vala_code_node_unref0 (_tmp2330_);
			}
			_tmp2331_ = unary;
			_tmp2332_ = vala_unary_expression_get_inner (_tmp2331_);
			_tmp2333_ = _tmp2332_;
			_tmp2334_ = vala_expression_get_target_value (_tmp2333_);
			_tmp2335_ = _tmp2334_;
			_tmp2336_ = unary;
			_tmp2337_ = vala_expression_get_target_value ((ValaExpression*) _tmp2336_);
			_tmp2338_ = _tmp2337_;
			_tmp2339_ = unary;
			_tmp2340_ = vala_unary_expression_get_inner (_tmp2339_);
			_tmp2341_ = _tmp2340_;
			_tmp2342_ = vala_expression_get_value_type (_tmp2341_);
			_tmp2343_ = _tmp2342_;
			_tmp2344_ = arg;
			_tmp2345_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2338_, _tmp2343_, (ValaCodeNode*) _tmp2344_);
			_tmp2346_ = _tmp2345_;
			_tmp2347_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2348_ = _tmp2347_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2335_, _tmp2346_, _tmp2348_);
			_vala_target_value_unref0 (_tmp2346_);
			_tmp2350_ = param;
			if (_tmp2350_ != NULL) {
				ValaParameter* _tmp2351_;
				_tmp2351_ = param;
				_tmp2349_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2351_);
			} else {
				_tmp2349_ = FALSE;
			}
			if (_tmp2349_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2352_;
				ValaCCodeIdentifier* _tmp2353_;
				ValaCCodeFunctionCall* _tmp2354_;
				ValaCCodeFunctionCall* _tmp2355_;
				ValaCCodeFunctionCall* _tmp2356_;
				ValaUnaryExpression* _tmp2357_;
				ValaExpression* _tmp2358_;
				ValaExpression* _tmp2359_;
				ValaTargetValue* _tmp2360_;
				ValaTargetValue* _tmp2361_;
				ValaCCodeExpression* _tmp2362_;
				ValaCCodeFunction* _tmp2363_;
				ValaCCodeFunction* _tmp2364_;
				ValaUnaryExpression* _tmp2365_;
				ValaExpression* _tmp2366_;
				ValaExpression* _tmp2367_;
				ValaTargetValue* _tmp2368_;
				ValaTargetValue* _tmp2369_;
				ValaCCodeExpression* _tmp2370_;
				ValaCCodeExpression* _tmp2371_;
				ValaCCodeFunctionCall* _tmp2372_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2352_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2353_ = _tmp2352_;
				_tmp2354_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2353_);
				_tmp2355_ = _tmp2354_;
				_vala_ccode_node_unref0 (_tmp2353_);
				len_call = _tmp2355_;
				_tmp2356_ = len_call;
				_tmp2357_ = unary;
				_tmp2358_ = vala_unary_expression_get_inner (_tmp2357_);
				_tmp2359_ = _tmp2358_;
				_tmp2360_ = vala_expression_get_target_value (_tmp2359_);
				_tmp2361_ = _tmp2360_;
				_tmp2362_ = vala_get_cvalue_ (_tmp2361_);
				vala_ccode_function_call_add_argument (_tmp2356_, _tmp2362_);
				_tmp2363_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2364_ = _tmp2363_;
				_tmp2365_ = unary;
				_tmp2366_ = vala_unary_expression_get_inner (_tmp2365_);
				_tmp2367_ = _tmp2366_;
				_tmp2368_ = vala_expression_get_target_value (_tmp2367_);
				_tmp2369_ = _tmp2368_;
				_tmp2370_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2369_, 1);
				_tmp2371_ = _tmp2370_;
				_tmp2372_ = len_call;
				vala_ccode_function_add_assignment (_tmp2364_, _tmp2371_, (ValaCCodeExpression*) _tmp2372_);
				_vala_ccode_node_unref0 (_tmp2371_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2375_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2375_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2376_;
		ValaSymbol* _tmp2377_;
		ValaSymbol* _tmp2378_;
		_tmp2376_ = m;
		_tmp2377_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2376_);
		_tmp2378_ = _tmp2377_;
		_tmp2374_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2378_, VALA_TYPE_CLASS);
	} else {
		_tmp2374_ = FALSE;
	}
	if (_tmp2374_) {
		gboolean _tmp2379_ = FALSE;
		gboolean _tmp2380_ = FALSE;
		ValaClass* _tmp2381_;
		ValaClass* _tmp2382_;
		gboolean _tmp2383_;
		gboolean _tmp2384_;
		_tmp2381_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2382_ = _tmp2381_;
		_tmp2383_ = vala_class_get_is_compact (_tmp2382_);
		_tmp2384_ = _tmp2383_;
		if (_tmp2384_) {
			ValaClass* _tmp2385_;
			ValaClass* _tmp2386_;
			ValaClass* _tmp2387_;
			ValaClass* _tmp2388_;
			_tmp2385_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2386_ = _tmp2385_;
			_tmp2387_ = vala_class_get_base_class (_tmp2386_);
			_tmp2388_ = _tmp2387_;
			_tmp2380_ = _tmp2388_ != NULL;
		} else {
			_tmp2380_ = FALSE;
		}
		if (_tmp2380_) {
			_tmp2379_ = TRUE;
		} else {
			ValaClass* _tmp2389_;
			ValaClass* _tmp2390_;
			ValaClass* _tmp2391_;
			_tmp2389_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2390_ = _tmp2389_;
			_tmp2391_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2379_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp2390_, (ValaTypeSymbol*) _tmp2391_);
		}
		_tmp2373_ = _tmp2379_;
	} else {
		_tmp2373_ = FALSE;
	}
	if (_tmp2373_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2392_;
		ValaClass* _tmp2393_;
		gchar* _tmp2394_;
		gchar* _tmp2395_;
		gchar* _tmp2396_;
		gchar* _tmp2397_;
		ValaCCodeIdentifier* _tmp2398_;
		ValaCCodeIdentifier* _tmp2399_;
		ValaCCodeFunctionCall* _tmp2400_;
		ValaCCodeFunctionCall* _tmp2401_;
		ValaCCodeFunctionCall* _tmp2402_;
		ValaCCodeExpression* _tmp2403_;
		ValaCCodeExpression* _tmp2404_;
		ValaClass* _tmp2405_;
		ValaClass* _tmp2406_;
		gboolean _tmp2407_;
		gboolean _tmp2408_;
		ValaCCodeFunction* _tmp2412_;
		ValaCCodeFunction* _tmp2413_;
		ValaCCodeFunctionCall* _tmp2414_;
		_tmp2392_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2393_ = _tmp2392_;
		_tmp2394_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2393_, NULL);
		_tmp2395_ = _tmp2394_;
		_tmp2396_ = g_strdup_printf ("%s_instance_init", _tmp2395_);
		_tmp2397_ = _tmp2396_;
		_tmp2398_ = vala_ccode_identifier_new (_tmp2397_);
		_tmp2399_ = _tmp2398_;
		_tmp2400_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2399_);
		_tmp2401_ = _tmp2400_;
		_vala_ccode_node_unref0 (_tmp2399_);
		_g_free0 (_tmp2397_);
		_g_free0 (_tmp2395_);
		cinitcall = _tmp2401_;
		_tmp2402_ = cinitcall;
		_tmp2403_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2404_ = _tmp2403_;
		vala_ccode_function_call_add_argument (_tmp2402_, _tmp2404_);
		_vala_ccode_node_unref0 (_tmp2404_);
		_tmp2405_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2406_ = _tmp2405_;
		_tmp2407_ = vala_class_get_is_compact (_tmp2406_);
		_tmp2408_ = _tmp2407_;
		if (!_tmp2408_) {
			ValaCCodeFunctionCall* _tmp2409_;
			ValaCCodeConstant* _tmp2410_;
			ValaCCodeConstant* _tmp2411_;
			_tmp2409_ = cinitcall;
			_tmp2410_ = vala_ccode_constant_new ("NULL");
			_tmp2411_ = _tmp2410_;
			vala_ccode_function_call_add_argument (_tmp2409_, (ValaCCodeExpression*) _tmp2411_);
			_vala_ccode_node_unref0 (_tmp2411_);
		}
		_tmp2412_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2413_ = _tmp2412_;
		_tmp2414_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2413_, (ValaCCodeExpression*) _tmp2414_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeFile* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	ValaCCodeFile* _tmp55_;
	ValaCCodeFunction* _tmp56_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _enum_value_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_enum_value_list = _tmp21_;
		_tmp22_ = _enum_value_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_enum_value_size = _tmp24_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp27_;
			gpointer _tmp28_;
			ValaCCodeFunction* _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaEnumValue* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeFunction* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaEnumValue* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			ValaCCodeConstant* _tmp45_;
			ValaCCodeConstant* _tmp46_;
			_enum_value_index = _enum_value_index + 1;
			_tmp25_ = _enum_value_index;
			_tmp26_ = _enum_value_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _enum_value_list;
			_tmp28_ = vala_list_get (_tmp27_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp28_;
			_tmp29_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp30_ = _tmp29_;
			_tmp31_ = enum_value;
			_tmp32_ = vala_get_ccode_name ((ValaCodeNode*) _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_ccode_identifier_new (_tmp33_);
			_tmp35_ = _tmp34_;
			vala_ccode_function_add_case (_tmp30_, (ValaCCodeExpression*) _tmp35_);
			_vala_ccode_node_unref0 (_tmp35_);
			_g_free0 (_tmp33_);
			_tmp36_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = enum_value;
			_tmp39_ = vala_get_ccode_name ((ValaCodeNode*) _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat ("\"", _tmp40_, NULL);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat (_tmp42_, "\"", NULL);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_ccode_constant_new (_tmp44_);
			_tmp46_ = _tmp45_;
			vala_ccode_function_add_return (_tmp37_, (ValaCCodeExpression*) _tmp46_);
			_vala_ccode_node_unref0 (_tmp46_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp47_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp48_ = _tmp47_;
	vala_ccode_function_close (_tmp48_);
	_tmp49_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_ccode_constant_new ("NULL");
	_tmp52_ = _tmp51_;
	vala_ccode_function_add_return (_tmp50_, (ValaCCodeExpression*) _tmp52_);
	_vala_ccode_node_unref0 (_tmp52_);
	_tmp53_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp54_ = function;
	vala_ccode_file_add_function_declaration (_tmp53_, _tmp54_);
	_tmp55_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp56_ = function;
	vala_ccode_file_add_function (_tmp55_, _tmp56_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp9_;
			gboolean _tmp10_ = FALSE;
			ValaUnaryExpression* _tmp11_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp9_) : NULL;
			_tmp11_ = unary;
			if (_tmp11_ != NULL) {
				gboolean _tmp12_ = FALSE;
				ValaUnaryExpression* _tmp13_;
				ValaUnaryOperator _tmp14_;
				ValaUnaryOperator _tmp15_;
				_tmp13_ = unary;
				_tmp14_ = vala_unary_expression_get_operator (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp12_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp16_;
					ValaUnaryOperator _tmp17_;
					ValaUnaryOperator _tmp18_;
					_tmp16_ = unary;
					_tmp17_ = vala_unary_expression_get_operator (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp10_ = _tmp12_;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaProfile _tmp39_;
	ValaProfile _tmp40_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeConstant* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeFunctionCall* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeIdentifier* _tmp60_;
	ValaCCodeIdentifier* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeConstant* _tmp63_;
	ValaCCodeConstant* _tmp64_;
	ValaCCodeBinaryExpression* _tmp65_;
	ValaCCodeBinaryExpression* _tmp66_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunctionCall* _tmp69_;
	ValaCCodeFunctionCall* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunction* _tmp74_;
	ValaCCodeFunction* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeFunctionCall* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeIdentifier* _tmp83_;
	ValaCCodeFunction* _tmp84_;
	ValaCCodeFunction* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeFunctionCall* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeIdentifier* _tmp90_;
	ValaCCodeFunctionCall* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunction* _tmp98_;
	ValaCCodeFunction* _tmp99_;
	ValaCCodeFunctionCall* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeFunctionCall* _tmp103_;
	ValaCCodeFunctionCall* _tmp104_;
	ValaCCodeIdentifier* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeIdentifier* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeFunctionCall* _tmp110_;
	ValaCCodeIdentifier* _tmp111_;
	ValaCCodeIdentifier* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunction* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	ValaCCodeFunctionCall* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeFunctionCall* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeFunction* _tmp125_;
	ValaCCodeFunction* _tmp126_;
	ValaCCodeFunctionCall* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeIdentifier* _tmp131_;
	ValaCCodeFile* _tmp132_;
	ValaCCodeFile* _tmp133_;
	ValaCCodeFunction* _tmp134_;
	ValaCCodeFile* _tmp135_;
	ValaCCodeFunction* _tmp136_;
	gchar* _tmp137_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_code_context_get_profile (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PROFILE_POSIX) {
		ValaCCodeFile* _tmp41_;
		_tmp41_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp41_, "stdio.h", FALSE);
	}
	_tmp42_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	vsnprintf = _tmp45_;
	_tmp46_ = vsnprintf;
	_tmp47_ = vala_ccode_constant_new ("NULL");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = vsnprintf;
	_tmp50_ = vala_ccode_constant_new ("0");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vsnprintf;
	_tmp53_ = vala_ccode_identifier_new ("format");
	_tmp54_ = _tmp53_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp54_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp55_ = vsnprintf;
	_tmp56_ = vala_ccode_identifier_new ("ap");
	_tmp57_ = _tmp56_;
	vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp57_);
	_vala_ccode_node_unref0 (_tmp57_);
	_tmp58_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_identifier_new ("length");
	_tmp61_ = _tmp60_;
	_tmp62_ = vsnprintf;
	_tmp63_ = vala_ccode_constant_new ("1");
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp62_, (ValaCCodeExpression*) _tmp64_);
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_assignment (_tmp59_, (ValaCCodeExpression*) _tmp61_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	_vala_ccode_node_unref0 (_tmp64_);
	_vala_ccode_node_unref0 (_tmp61_);
	_tmp67_ = vala_ccode_identifier_new ("va_end");
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp68_);
	_tmp70_ = _tmp69_;
	_vala_ccode_node_unref0 (_tmp68_);
	va_end = _tmp70_;
	_tmp71_ = va_end;
	_tmp72_ = vala_ccode_identifier_new ("ap");
	_tmp73_ = _tmp72_;
	vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
	_vala_ccode_node_unref0 (_tmp73_);
	_tmp74_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = va_end;
	vala_ccode_function_add_expression (_tmp75_, (ValaCCodeExpression*) _tmp76_);
	_tmp77_ = vala_ccode_identifier_new ("malloc");
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp78_);
	_tmp80_ = _tmp79_;
	_vala_ccode_node_unref0 (_tmp78_);
	malloc = _tmp80_;
	_tmp81_ = malloc;
	_tmp82_ = vala_ccode_identifier_new ("length");
	_tmp83_ = _tmp82_;
	vala_ccode_function_call_add_argument (_tmp81_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp83_);
	_tmp84_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_identifier_new ("result");
	_tmp87_ = _tmp86_;
	_tmp88_ = malloc;
	vala_ccode_function_add_assignment (_tmp85_, (ValaCCodeExpression*) _tmp87_, (ValaCCodeExpression*) _tmp88_);
	_vala_ccode_node_unref0 (_tmp87_);
	_tmp89_ = vala_ccode_identifier_new ("va_start");
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp90_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp91_;
	_vala_ccode_node_unref0 (_tmp90_);
	_tmp92_ = va_start;
	_tmp93_ = vala_ccode_identifier_new ("ap");
	_tmp94_ = _tmp93_;
	vala_ccode_function_call_add_argument (_tmp92_, (ValaCCodeExpression*) _tmp94_);
	_vala_ccode_node_unref0 (_tmp94_);
	_tmp95_ = va_start;
	_tmp96_ = vala_ccode_identifier_new ("format");
	_tmp97_ = _tmp96_;
	vala_ccode_function_call_add_argument (_tmp95_, (ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp98_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = va_start;
	vala_ccode_function_add_expression (_tmp99_, (ValaCCodeExpression*) _tmp100_);
	_tmp101_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp103_;
	_vala_ccode_node_unref0 (_tmp102_);
	_tmp104_ = vsnprintf;
	_tmp105_ = vala_ccode_identifier_new ("result");
	_tmp106_ = _tmp105_;
	vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp106_);
	_vala_ccode_node_unref0 (_tmp106_);
	_tmp107_ = vsnprintf;
	_tmp108_ = vala_ccode_identifier_new ("length");
	_tmp109_ = _tmp108_;
	vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp109_);
	_vala_ccode_node_unref0 (_tmp109_);
	_tmp110_ = vsnprintf;
	_tmp111_ = vala_ccode_identifier_new ("format");
	_tmp112_ = _tmp111_;
	vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp112_);
	_vala_ccode_node_unref0 (_tmp112_);
	_tmp113_ = vsnprintf;
	_tmp114_ = vala_ccode_identifier_new ("ap");
	_tmp115_ = _tmp114_;
	vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp117_, (ValaCCodeExpression*) _tmp118_);
	_tmp119_ = vala_ccode_identifier_new ("va_end");
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp120_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp121_;
	_vala_ccode_node_unref0 (_tmp120_);
	_tmp122_ = va_end;
	_tmp123_ = vala_ccode_identifier_new ("ap");
	_tmp124_ = _tmp123_;
	vala_ccode_function_call_add_argument (_tmp122_, (ValaCCodeExpression*) _tmp124_);
	_vala_ccode_node_unref0 (_tmp124_);
	_tmp125_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp126_ = _tmp125_;
	_tmp127_ = va_end;
	vala_ccode_function_add_expression (_tmp126_, (ValaCCodeExpression*) _tmp127_);
	_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_ccode_identifier_new ("result");
	_tmp131_ = _tmp130_;
	vala_ccode_function_add_return (_tmp129_, (ValaCCodeExpression*) _tmp131_);
	_vala_ccode_node_unref0 (_tmp131_);
	_tmp132_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp132_, "stdarg.h", FALSE);
	_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp134_ = function;
	vala_ccode_file_add_function_declaration (_tmp133_, _tmp134_);
	_tmp135_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp136_ = function;
	vala_ccode_file_add_function (_tmp135_, _tmp136_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp137_ = g_strdup ("string_printf");
	result = _tmp137_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

static GType
vala_ccode_method_call_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
	GType vala_ccode_method_call_module_type_id;
	vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	return vala_ccode_method_call_module_type_id;
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = vala_ccode_method_call_module_get_type_once ();
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

