/* valaccodedelegatemodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodedelegatemodule.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <vala/valatypesymbol.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valaformalparameter.h>
#include <ccode/valaccodeformalparameter.h>
#include <vala/valaarraytype.h>
#include <vala/valasymbol.h>
#include <gee/collection.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <vala/valaunaryexpression.h>
#include <vala/valamethodcall.h>
#include <vala/valalambdaexpression.h>
#include <vala/valamethod.h>
#include <vala/valamember.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeunaryexpression.h>
#include <vala/valalocalvariable.h>
#include <vala/valafield.h>
#include <vala/valamemberaccess.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valadelegatetype.h>
#include <vala/valamethodtype.h>
#include <vala/valasignal.h>
#include <vala/valadynamicsignal.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodemodifiers.h>
#include <gee/hashmap.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <gee/list.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeblock.h>
#include <vala/valavoidtype.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodereturnstatement.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_CCODE_DELEGATE_MODULE_DUMMY_PROPERTY
};
static void vala_ccode_delegate_module_real_visit_delegate (ValaCCodeModule* base, ValaDelegate* d);
static char* vala_ccode_delegate_module_real_get_delegate_target_cname (ValaCCodeBaseModule* base, const char* delegate_cname);
static ValaCCodeExpression* vala_ccode_delegate_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* base, ValaExpression* delegate_expr);
static char* vala_ccode_delegate_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* base, const char* delegate_cname);
static ValaCCodeExpression* vala_ccode_delegate_module_real_get_implicit_cast_expression (ValaCCodeBaseModule* base, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
static char* vala_ccode_delegate_module_generate_delegate_wrapper (ValaCCodeDelegateModule* self, ValaMethod* m, ValaDelegate* d);
static gpointer vala_ccode_delegate_module_parent_class = NULL;



ValaCCodeDelegateModule* vala_ccode_delegate_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeDelegateModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeDelegateModule*) vala_ccode_array_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeDelegateModule* vala_ccode_delegate_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_delegate_module_construct (VALA_TYPE_CCODE_DELEGATE_MODULE, codegen, next);
}


static void vala_ccode_delegate_module_real_visit_delegate (ValaCCodeModule* base, ValaDelegate* d) {
	ValaCCodeDelegateModule * self;
	char* _tmp0;
	ValaCCodeFunctionDeclarator* _tmp1;
	ValaCCodeFunctionDeclarator* cfundecl;
	gboolean _tmp9;
	GeeList* _tmp13;
	gboolean _tmp14;
	char* _tmp15;
	ValaCCodeTypeDefinition* _tmp16;
	ValaCCodeTypeDefinition* ctypedef;
	self = (ValaCCodeDelegateModule*) base;
	g_return_if_fail (d != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) d, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp0 = NULL;
	_tmp1 = NULL;
	cfundecl = (_tmp1 = vala_ccode_function_declarator_new (_tmp0 = vala_typesymbol_get_cname ((ValaTypeSymbol*) d, FALSE)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	{
		GeeList* _tmp2;
		GeeIterator* _tmp3;
		GeeIterator* _param_it;
		_tmp2 = NULL;
		_tmp3 = NULL;
		_param_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_delegate_get_parameters (d))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			gboolean _tmp4;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			vala_ccode_function_declarator_add_parameter (cfundecl, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode ((ValaCodeNode*) param)));
			_tmp4 = FALSE;
			if (!vala_formal_parameter_get_no_array_length (param)) {
				_tmp4 = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
			} else {
				_tmp4 = FALSE;
			}
			/* handle array parameters*/
			if (_tmp4) {
				ValaArrayType* _tmp5;
				ValaArrayType* array_type;
				char* length_ctype;
				_tmp5 = NULL;
				array_type = (_tmp5 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
				length_ctype = g_strdup ("int");
				if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
					char* _tmp6;
					_tmp6 = NULL;
					length_ctype = (_tmp6 = g_strdup ("int*"), length_ctype = (g_free (length_ctype), NULL), _tmp6);
				}
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						char* _tmp7;
						ValaCCodeFormalParameter* _tmp8;
						ValaCCodeFormalParameter* cparam;
						_tmp7 = NULL;
						_tmp8 = NULL;
						cparam = (_tmp8 = vala_ccode_formal_parameter_new (_tmp7 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) param), dim), length_ctype), _tmp7 = (g_free (_tmp7), NULL), _tmp8);
						vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
						(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				length_ctype = (g_free (length_ctype), NULL);
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp9 = FALSE;
	if (!vala_delegate_get_no_array_length (d)) {
		_tmp9 = VALA_IS_ARRAY_TYPE (vala_delegate_get_return_type (d));
	} else {
		_tmp9 = FALSE;
	}
	if (_tmp9) {
		ValaArrayType* _tmp10;
		ValaArrayType* array_type;
		/* return array length if appropriate*/
		_tmp10 = NULL;
		array_type = (_tmp10 = VALA_ARRAY_TYPE (vala_delegate_get_return_type (d)), (_tmp10 == NULL) ? NULL : vala_code_node_ref (_tmp10));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				char* _tmp11;
				ValaCCodeFormalParameter* _tmp12;
				ValaCCodeFormalParameter* cparam;
				_tmp11 = NULL;
				_tmp12 = NULL;
				cparam = (_tmp12 = vala_ccode_formal_parameter_new (_tmp11 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim), "int*"), _tmp11 = (g_free (_tmp11), NULL), _tmp12);
				vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
				(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	}
	if (vala_delegate_get_has_target (d)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("user_data", "void*");
		vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
		(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
	}
	_tmp13 = NULL;
	if ((_tmp14 = gee_collection_get_size ((GeeCollection*) (_tmp13 = vala_code_node_get_error_types ((ValaCodeNode*) d))) > 0, (_tmp13 == NULL) ? NULL : (_tmp13 = (gee_collection_object_unref (_tmp13), NULL)), _tmp14)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
		(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
	}
	_tmp15 = NULL;
	_tmp16 = NULL;
	ctypedef = (_tmp16 = vala_ccode_type_definition_new (_tmp15 = vala_data_type_get_cname (vala_delegate_get_return_type (d)), (ValaCCodeDeclarator*) cfundecl), _tmp15 = (g_free (_tmp15), NULL), _tmp16);
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) d)) {
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_declaration, (ValaCCodeNode*) ctypedef);
	} else {
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_declaration, (ValaCCodeNode*) ctypedef);
	}
	(cfundecl == NULL) ? NULL : (cfundecl = (vala_ccode_node_unref (cfundecl), NULL));
	(ctypedef == NULL) ? NULL : (ctypedef = (vala_ccode_node_unref (ctypedef), NULL));
}


static char* vala_ccode_delegate_module_real_get_delegate_target_cname (ValaCCodeBaseModule* base, const char* delegate_cname) {
	ValaCCodeDelegateModule * self;
	self = (ValaCCodeDelegateModule*) base;
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	return g_strdup_printf ("%s_target", delegate_cname);
}


static ValaCCodeExpression* vala_ccode_delegate_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* base, ValaExpression* delegate_expr) {
	ValaCCodeDelegateModule * self;
	gboolean is_out;
	self = (ValaCCodeDelegateModule*) base;
	g_return_val_if_fail (delegate_expr != NULL, NULL);
	is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (delegate_expr)) {
		ValaUnaryExpression* _tmp0;
		ValaUnaryExpression* unary_expr;
		gboolean _tmp1;
		_tmp0 = NULL;
		unary_expr = (_tmp0 = VALA_UNARY_EXPRESSION (delegate_expr), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
		_tmp1 = FALSE;
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT) {
			_tmp1 = TRUE;
		} else {
			_tmp1 = vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_REF;
		}
		if (_tmp1) {
			delegate_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		(unary_expr == NULL) ? NULL : (unary_expr = (vala_code_node_unref (unary_expr), NULL));
	}
	if (VALA_IS_METHOD_CALL (delegate_expr)) {
		ValaMethodCall* _tmp2;
		ValaMethodCall* invocation_expr;
		ValaCCodeExpression* _tmp3;
		ValaCCodeExpression* _tmp4;
		_tmp2 = NULL;
		invocation_expr = (_tmp2 = VALA_METHOD_CALL (delegate_expr), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
		_tmp3 = NULL;
		_tmp4 = NULL;
		return (_tmp4 = (_tmp3 = vala_method_call_get_delegate_target (invocation_expr), (_tmp3 == NULL) ? NULL : vala_ccode_node_ref (_tmp3)), (invocation_expr == NULL) ? NULL : (invocation_expr = (vala_code_node_unref (invocation_expr), NULL)), _tmp4);
	} else {
		if (VALA_IS_LAMBDA_EXPRESSION (delegate_expr)) {
			gboolean _tmp5;
			gboolean _tmp6;
			_tmp5 = FALSE;
			_tmp6 = FALSE;
			if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
				_tmp6 = vala_method_get_binding (((ValaCCodeBaseModule*) self)->current_method) == MEMBER_BINDING_INSTANCE;
			} else {
				_tmp6 = FALSE;
			}
			if ((_tmp6)) {
				_tmp5 = TRUE;
			} else {
				_tmp5 = ((ValaCCodeBaseModule*) self)->in_constructor;
			}
			if (_tmp5) {
				return (ValaCCodeExpression*) vala_ccode_identifier_new ("self");
			} else {
				return (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
			}
		} else {
			if (vala_expression_get_symbol_reference (delegate_expr) != NULL) {
				if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (delegate_expr))) {
					ValaFormalParameter* _tmp9;
					ValaFormalParameter* param;
					char* _tmp10;
					ValaCCodeExpression* _tmp11;
					ValaCCodeExpression* target_expr;
					_tmp9 = NULL;
					param = (_tmp9 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (delegate_expr)), (_tmp9 == NULL) ? NULL : vala_code_node_ref (_tmp9));
					_tmp10 = NULL;
					_tmp11 = NULL;
					target_expr = (_tmp11 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp10 = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param))), _tmp10 = (g_free (_tmp10), NULL), _tmp11);
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						ValaCCodeExpression* _tmp12;
						/* accessing argument of out/ref param*/
						_tmp12 = NULL;
						target_expr = (_tmp12 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, target_expr), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp12);
					}
					if (is_out) {
						ValaCCodeExpression* _tmp13;
						/* passing array as out/ref*/
						_tmp13 = NULL;
						return (_tmp13 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, target_expr), (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp13);
					} else {
						ValaCCodeExpression* _tmp14;
						_tmp14 = NULL;
						return (_tmp14 = target_expr, (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), _tmp14);
					}
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					(target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL));
				} else {
					if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (delegate_expr))) {
						ValaLocalVariable* _tmp15;
						ValaLocalVariable* local;
						char* _tmp16;
						ValaCCodeIdentifier* _tmp17;
						ValaCCodeIdentifier* target_expr;
						_tmp15 = NULL;
						local = (_tmp15 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (delegate_expr)), (_tmp15 == NULL) ? NULL : vala_code_node_ref (_tmp15));
						_tmp16 = NULL;
						_tmp17 = NULL;
						target_expr = (_tmp17 = vala_ccode_identifier_new (_tmp16 = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local))), _tmp16 = (g_free (_tmp16), NULL), _tmp17);
						if (is_out) {
							ValaCCodeExpression* _tmp18;
							_tmp18 = NULL;
							return (_tmp18 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) target_expr), (local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL)), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp18);
						} else {
							ValaCCodeExpression* _tmp19;
							_tmp19 = NULL;
							return (_tmp19 = (ValaCCodeExpression*) target_expr, (local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL)), _tmp19);
						}
						(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
						(target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL));
					} else {
						if (VALA_IS_FIELD (vala_expression_get_symbol_reference (delegate_expr))) {
							ValaField* _tmp20;
							ValaField* field;
							char* target_cname;
							ValaMemberAccess* _tmp21;
							ValaMemberAccess* ma;
							ValaCCodeExpression* target_expr;
							_tmp20 = NULL;
							field = (_tmp20 = VALA_FIELD (vala_expression_get_symbol_reference (delegate_expr)), (_tmp20 == NULL) ? NULL : vala_code_node_ref (_tmp20));
							target_cname = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) field));
							_tmp21 = NULL;
							ma = (_tmp21 = VALA_MEMBER_ACCESS (delegate_expr), (_tmp21 == NULL) ? NULL : vala_code_node_ref (_tmp21));
							target_expr = NULL;
							if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
								ValaDataType* _tmp22;
								ValaDataType* instance_expression_type;
								ValaDataType* instance_target_type;
								ValaCCodeExpression* pub_inst;
								ValaCCodeExpression* typed_inst;
								ValaCCodeExpression* inst;
								_tmp22 = NULL;
								instance_expression_type = (_tmp22 = vala_expression_get_value_type (vala_member_access_get_inner (ma)), (_tmp22 == NULL) ? NULL : vala_code_node_ref (_tmp22));
								instance_target_type = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) field)));
								pub_inst = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma)));
								typed_inst = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, pub_inst, instance_expression_type, instance_target_type, NULL);
								inst = NULL;
								if (vala_symbol_get_access ((ValaSymbol*) field) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
									ValaCCodeExpression* _tmp23;
									_tmp23 = NULL;
									inst = (_tmp23 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp23);
								} else {
									ValaCCodeExpression* _tmp25;
									ValaCCodeExpression* _tmp24;
									_tmp25 = NULL;
									_tmp24 = NULL;
									inst = (_tmp25 = (_tmp24 = typed_inst, (_tmp24 == NULL) ? NULL : vala_ccode_node_ref (_tmp24)), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp25);
								}
								if (vala_typesymbol_is_reference_type ((VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) field))))) {
									ValaCCodeExpression* _tmp26;
									_tmp26 = NULL;
									target_expr = (_tmp26 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (inst, target_cname), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp26);
								} else {
									ValaCCodeExpression* _tmp27;
									_tmp27 = NULL;
									target_expr = (_tmp27 = (ValaCCodeExpression*) vala_ccode_member_access_new (inst, target_cname, FALSE), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp27);
								}
								(instance_expression_type == NULL) ? NULL : (instance_expression_type = (vala_code_node_unref (instance_expression_type), NULL));
								(instance_target_type == NULL) ? NULL : (instance_target_type = (vala_code_node_unref (instance_target_type), NULL));
								(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
								(typed_inst == NULL) ? NULL : (typed_inst = (vala_ccode_node_unref (typed_inst), NULL));
								(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
							} else {
								ValaCCodeExpression* _tmp28;
								_tmp28 = NULL;
								target_expr = (_tmp28 = (ValaCCodeExpression*) vala_ccode_identifier_new (target_cname), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp28);
							}
							if (is_out) {
								ValaCCodeExpression* _tmp29;
								_tmp29 = NULL;
								return (_tmp29 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, target_expr), (field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL)), target_cname = (g_free (target_cname), NULL), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp29);
							} else {
								ValaCCodeExpression* _tmp30;
								_tmp30 = NULL;
								return (_tmp30 = target_expr, (field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL)), target_cname = (g_free (target_cname), NULL), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp30);
							}
							(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
							target_cname = (g_free (target_cname), NULL);
							(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
							(target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL));
						} else {
							if (VALA_IS_METHOD (vala_expression_get_symbol_reference (delegate_expr))) {
								ValaMethod* _tmp31;
								ValaMethod* m;
								ValaMemberAccess* _tmp32;
								ValaMemberAccess* ma;
								_tmp31 = NULL;
								m = (_tmp31 = VALA_METHOD (vala_expression_get_symbol_reference (delegate_expr)), (_tmp31 == NULL) ? NULL : vala_code_node_ref (_tmp31));
								_tmp32 = NULL;
								ma = (_tmp32 = VALA_MEMBER_ACCESS (delegate_expr), (_tmp32 == NULL) ? NULL : vala_code_node_ref (_tmp32));
								if (vala_method_get_binding (m) == MEMBER_BINDING_STATIC) {
									ValaCCodeExpression* _tmp33;
									_tmp33 = NULL;
									return (_tmp33 = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp33);
								} else {
									ValaCCodeExpression* _tmp34;
									_tmp34 = NULL;
									return (_tmp34 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma))), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp34);
								}
								(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
								(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
							}
						}
					}
				}
			}
		}
	}
	return (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
}


static char* vala_ccode_delegate_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* base, const char* delegate_cname) {
	ValaCCodeDelegateModule * self;
	self = (ValaCCodeDelegateModule*) base;
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	return g_strdup_printf ("%s_target_destroy_notify", delegate_cname);
}


static ValaCCodeExpression* vala_ccode_delegate_module_real_get_implicit_cast_expression (ValaCCodeBaseModule* base, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr) {
	ValaCCodeDelegateModule * self;
	gboolean _tmp0;
	self = (ValaCCodeDelegateModule*) base;
	g_return_val_if_fail (source_cexpr != NULL, NULL);
	_tmp0 = FALSE;
	if (VALA_IS_DELEGATE_TYPE (target_type)) {
		_tmp0 = VALA_IS_METHOD_TYPE (expression_type);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		ValaDelegateType* _tmp1;
		ValaDelegateType* dt;
		ValaMethodType* _tmp2;
		ValaMethodType* mt;
		ValaMethod* _tmp3;
		ValaMethod* method;
		char* _tmp8;
		ValaCCodeExpression* _tmp9;
		ValaCCodeExpression* _tmp10;
		_tmp1 = NULL;
		dt = (_tmp1 = VALA_DELEGATE_TYPE (target_type), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
		_tmp2 = NULL;
		mt = (_tmp2 = VALA_METHOD_TYPE (expression_type), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
		_tmp3 = NULL;
		method = (_tmp3 = vala_method_type_get_method_symbol (mt), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
		if (vala_method_get_base_method (method) != NULL) {
			ValaMethod* _tmp5;
			ValaMethod* _tmp4;
			_tmp5 = NULL;
			_tmp4 = NULL;
			method = (_tmp5 = (_tmp4 = vala_method_get_base_method (method), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4)), (method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL)), _tmp5);
		} else {
			if (vala_method_get_base_interface_method (method) != NULL) {
				ValaMethod* _tmp7;
				ValaMethod* _tmp6;
				_tmp7 = NULL;
				_tmp6 = NULL;
				method = (_tmp7 = (_tmp6 = vala_method_get_base_interface_method (method), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6)), (method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL)), _tmp7);
			}
		}
		_tmp8 = NULL;
		_tmp9 = NULL;
		_tmp10 = NULL;
		return (_tmp10 = (_tmp9 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp8 = vala_ccode_delegate_module_generate_delegate_wrapper (self, method, vala_delegate_type_get_delegate_symbol (dt))), _tmp8 = (g_free (_tmp8), NULL), _tmp9), (dt == NULL) ? NULL : (dt = (vala_code_node_unref (dt), NULL)), (mt == NULL) ? NULL : (mt = (vala_code_node_unref (mt), NULL)), (method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL)), _tmp10);
	} else {
		return VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_delegate_module_parent_class)->get_implicit_cast_expression ((ValaCCodeBaseModule*) VALA_CCODE_ARRAY_MODULE (self), source_cexpr, expression_type, target_type, expr);
	}
}


static char* vala_ccode_delegate_module_generate_delegate_wrapper (ValaCCodeDelegateModule* self, ValaMethod* m, ValaDelegate* d) {
	char* delegate_name;
	ValaSignal* _tmp1;
	ValaSymbol* _tmp0;
	ValaSignal* sig;
	ValaDynamicSignal* _tmp3;
	ValaSignal* _tmp2;
	ValaDynamicSignal* dynamic_sig;
	char* _tmp10;
	char* _tmp11;
	char* wrapper_name;
	char* _tmp13;
	ValaCCodeFunction* _tmp14;
	ValaCCodeFunction* function;
	GeeHashMap* cparam_map;
	GeeList* d_params;
	gboolean _tmp20;
	GeeList* _tmp24;
	gboolean _tmp25;
	gint last_pos;
	gint min_pos;
	GeeHashMap* carg_map;
	gint i;
	gboolean _tmp56;
	GeeList* _tmp61;
	gboolean _tmp62;
	ValaCCodeIdentifier* _tmp65;
	char* _tmp64;
	ValaCCodeFunctionCall* _tmp66;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp74;
	char* _tmp75;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (d != NULL, NULL);
	delegate_name = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	sig = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol ((ValaSymbol*) d), VALA_IS_SIGNAL (_tmp0) ? ((ValaSignal*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp3 = NULL;
	_tmp2 = NULL;
	dynamic_sig = (_tmp3 = (_tmp2 = sig, VALA_IS_DYNAMIC_SIGNAL (_tmp2) ? ((ValaDynamicSignal*) _tmp2) : NULL), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
	if (dynamic_sig != NULL) {
		char* _tmp4;
		_tmp4 = NULL;
		delegate_name = (_tmp4 = vala_ccode_module_get_dynamic_signal_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), dynamic_sig), delegate_name = (g_free (delegate_name), NULL), _tmp4);
	} else {
		if (sig != NULL) {
			char* _tmp7;
			char* _tmp6;
			char* _tmp5;
			_tmp7 = NULL;
			_tmp6 = NULL;
			_tmp5 = NULL;
			delegate_name = (_tmp7 = g_strconcat (_tmp5 = vala_symbol_get_lower_case_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) sig)), _tmp6 = vala_signal_get_cname (sig), NULL), delegate_name = (g_free (delegate_name), NULL), _tmp7);
			_tmp6 = (g_free (_tmp6), NULL);
			_tmp5 = (g_free (_tmp5), NULL);
		} else {
			char* _tmp9;
			char* _tmp8;
			_tmp9 = NULL;
			_tmp8 = NULL;
			delegate_name = (_tmp9 = vala_symbol_camel_case_to_lower_case (_tmp8 = vala_typesymbol_get_cname ((ValaTypeSymbol*) d, FALSE)), delegate_name = (g_free (delegate_name), NULL), _tmp9);
			_tmp8 = (g_free (_tmp8), NULL);
		}
	}
	_tmp10 = NULL;
	_tmp11 = NULL;
	wrapper_name = (_tmp11 = g_strdup_printf ("_%s_%s", _tmp10 = vala_method_get_cname (m), delegate_name), _tmp10 = (g_free (_tmp10), NULL), _tmp11);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, wrapper_name)) {
		char* _tmp12;
		/* wrapper already defined*/
		_tmp12 = NULL;
		return (_tmp12 = wrapper_name, delegate_name = (g_free (delegate_name), NULL), (sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL)), (dynamic_sig == NULL) ? NULL : (dynamic_sig = (vala_code_node_unref (dynamic_sig), NULL)), _tmp12);
	}
	/* declaration*/
	_tmp13 = NULL;
	_tmp14 = NULL;
	function = (_tmp14 = vala_ccode_function_new (wrapper_name, _tmp13 = vala_data_type_get_cname (vala_method_get_return_type (m))), _tmp13 = (g_free (_tmp13), NULL), _tmp14);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	vala_code_node_set_ccodenode ((ValaCodeNode*) m, (ValaCCodeNode*) function);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	if (vala_delegate_get_has_target (d)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("self", "gpointer");
		gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), cparam);
		(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
	}
	d_params = vala_delegate_get_parameters (d);
	{
		GeeIterator* _param_it;
		_param_it = gee_iterable_iterator ((GeeIterable*) d_params);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			gboolean _tmp15;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			/* ensure that C code node has been generated*/
			vala_code_node_accept ((ValaCodeNode*) param, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
			gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode ((ValaCodeNode*) param)));
			_tmp15 = FALSE;
			if (!vala_formal_parameter_get_no_array_length (param)) {
				_tmp15 = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
			} else {
				_tmp15 = FALSE;
			}
			/* handle array parameters*/
			if (_tmp15) {
				ValaArrayType* _tmp16;
				ValaArrayType* array_type;
				char* length_ctype;
				_tmp16 = NULL;
				array_type = (_tmp16 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp16 == NULL) ? NULL : vala_code_node_ref (_tmp16));
				length_ctype = g_strdup ("int");
				if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
					char* _tmp17;
					_tmp17 = NULL;
					length_ctype = (_tmp17 = g_strdup ("int*"), length_ctype = (g_free (length_ctype), NULL), _tmp17);
				}
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						char* _tmp18;
						ValaCCodeFormalParameter* _tmp19;
						ValaCCodeFormalParameter* cparam;
						_tmp18 = NULL;
						_tmp19 = NULL;
						cparam = (_tmp19 = vala_ccode_formal_parameter_new (_tmp18 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) param), dim), length_ctype), _tmp18 = (g_free (_tmp18), NULL), _tmp19);
						gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), cparam);
						(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				length_ctype = (g_free (length_ctype), NULL);
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp20 = FALSE;
	if (!vala_delegate_get_no_array_length (d)) {
		_tmp20 = VALA_IS_ARRAY_TYPE (vala_delegate_get_return_type (d));
	} else {
		_tmp20 = FALSE;
	}
	if (_tmp20) {
		ValaArrayType* _tmp21;
		ValaArrayType* array_type;
		/* return array length if appropriate*/
		_tmp21 = NULL;
		array_type = (_tmp21 = VALA_ARRAY_TYPE (vala_delegate_get_return_type (d)), (_tmp21 == NULL) ? NULL : vala_code_node_ref (_tmp21));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				char* _tmp22;
				ValaCCodeFormalParameter* _tmp23;
				ValaCCodeFormalParameter* cparam;
				_tmp22 = NULL;
				_tmp23 = NULL;
				cparam = (_tmp23 = vala_ccode_formal_parameter_new (_tmp22 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim), "int*"), _tmp22 = (g_free (_tmp22), NULL), _tmp23);
				gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_carray_length_parameter_position (d) + (0.01 * dim), FALSE)), cparam);
				(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	}
	_tmp24 = NULL;
	if ((_tmp25 = gee_collection_get_size ((GeeCollection*) (_tmp24 = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0, (_tmp24 == NULL) ? NULL : (_tmp24 = (gee_collection_object_unref (_tmp24), NULL)), _tmp25)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), cparam);
		(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
	}
	/* append C parameters in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeFormalParameter* _tmp30;
		min_pos = -1;
		{
			GeeSet* _tmp26;
			GeeIterator* _tmp27;
			GeeIterator* _pos_it;
			_tmp26 = NULL;
			_tmp27 = NULL;
			_pos_it = (_tmp27 = gee_iterable_iterator ((GeeIterable*) (_tmp26 = gee_map_get_keys ((GeeMap*) cparam_map))), (_tmp26 == NULL) ? NULL : (_tmp26 = (gee_collection_object_unref (_tmp26), NULL)), _tmp27);
			while (gee_iterator_next (_pos_it)) {
				gint pos;
				gboolean _tmp28;
				pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
				_tmp28 = FALSE;
				if (pos > last_pos) {
					gboolean _tmp29;
					_tmp29 = FALSE;
					if (min_pos == (-1)) {
						_tmp29 = TRUE;
					} else {
						_tmp29 = pos < min_pos;
					}
					_tmp28 = (_tmp29);
				} else {
					_tmp28 = FALSE;
				}
				if (_tmp28) {
					min_pos = pos;
				}
			}
			(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
		}
		if (min_pos == (-1)) {
			break;
		}
		_tmp30 = NULL;
		vala_ccode_function_add_parameter (function, _tmp30 = (ValaCCodeFormalParameter*) gee_map_get ((GeeMap*) cparam_map, GINT_TO_POINTER (min_pos)));
		(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
		last_pos = min_pos;
	}
	/* definition*/
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	i = 0;
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeExpression* arg;
		arg = NULL;
		if (vala_delegate_get_has_target (d)) {
			ValaCCodeExpression* _tmp31;
			_tmp31 = NULL;
			arg = (_tmp31 = (ValaCCodeExpression*) vala_ccode_identifier_new ("self"), (arg == NULL) ? NULL : (arg = (vala_ccode_node_unref (arg), NULL)), _tmp31);
		} else {
			ValaCCodeExpression* _tmp34;
			ValaFormalParameter* _tmp32;
			ValaCCodeNode* _tmp33;
			/* use first delegate parameter as instance*/
			_tmp34 = NULL;
			_tmp32 = NULL;
			_tmp33 = NULL;
			arg = (_tmp34 = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (((_tmp33 = vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp32 = (ValaFormalParameter*) gee_list_get (d_params, 0))), VALA_IS_CCODE_FORMAL_PARAMETER (_tmp33) ? ((ValaCCodeFormalParameter*) _tmp33) : NULL)))), (arg == NULL) ? NULL : (arg = (vala_ccode_node_unref (arg), NULL)), _tmp34);
			(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_code_node_unref (_tmp32), NULL));
			i = 1;
		}
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), arg);
		(arg == NULL) ? NULL : (arg = (vala_ccode_node_unref (arg), NULL));
	}
	{
		GeeList* _tmp35;
		GeeIterator* _tmp36;
		GeeIterator* _param_it;
		_tmp35 = NULL;
		_tmp36 = NULL;
		_param_it = (_tmp36 = gee_iterable_iterator ((GeeIterable*) (_tmp35 = vala_method_get_parameters (m))), (_tmp35 == NULL) ? NULL : (_tmp35 = (gee_collection_object_unref (_tmp35), NULL)), _tmp36);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			ValaCCodeExpression* arg;
			ValaCCodeExpression* _tmp39;
			ValaFormalParameter* _tmp37;
			ValaCCodeNode* _tmp38;
			gboolean _tmp40;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			arg = NULL;
			_tmp39 = NULL;
			_tmp37 = NULL;
			_tmp38 = NULL;
			arg = (_tmp39 = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (((_tmp38 = vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp37 = (ValaFormalParameter*) gee_list_get (d_params, i))), VALA_IS_CCODE_FORMAL_PARAMETER (_tmp38) ? ((ValaCCodeFormalParameter*) _tmp38) : NULL)))), (arg == NULL) ? NULL : (arg = (vala_ccode_node_unref (arg), NULL)), _tmp39);
			(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_code_node_unref (_tmp37), NULL));
			gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), arg);
			_tmp40 = FALSE;
			if (!vala_formal_parameter_get_no_array_length (param)) {
				_tmp40 = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
			} else {
				_tmp40 = FALSE;
			}
			/* handle array arguments*/
			if (_tmp40) {
				ValaArrayType* _tmp41;
				ValaArrayType* array_type;
				_tmp41 = NULL;
				array_type = (_tmp41 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp41 == NULL) ? NULL : vala_code_node_ref (_tmp41));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						ValaCCodeExpression* clength;
						ValaFormalParameter* _tmp42;
						gboolean _tmp43;
						clength = NULL;
						_tmp42 = NULL;
						if ((_tmp43 = vala_formal_parameter_get_array_null_terminated (_tmp42 = (ValaFormalParameter*) gee_list_get (d_params, i)), (_tmp42 == NULL) ? NULL : (_tmp42 = (vala_code_node_unref (_tmp42), NULL)), _tmp43)) {
							ValaCCodeIdentifier* _tmp44;
							ValaCCodeFunctionCall* _tmp45;
							ValaCCodeFunctionCall* len_call;
							ValaCCodeIdentifier* _tmp47;
							ValaFormalParameter* _tmp46;
							ValaCCodeExpression* _tmp49;
							ValaCCodeExpression* _tmp48;
							((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
							_tmp44 = NULL;
							_tmp45 = NULL;
							len_call = (_tmp45 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp44 = vala_ccode_identifier_new ("_vala_array_length"))), (_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)), _tmp45);
							_tmp47 = NULL;
							_tmp46 = NULL;
							vala_ccode_function_call_add_argument (len_call, (ValaCCodeExpression*) (_tmp47 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) (_tmp46 = (ValaFormalParameter*) gee_list_get (d_params, i))))));
							(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
							(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_code_node_unref (_tmp46), NULL));
							_tmp49 = NULL;
							_tmp48 = NULL;
							clength = (_tmp49 = (_tmp48 = (ValaCCodeExpression*) len_call, (_tmp48 == NULL) ? NULL : vala_ccode_node_ref (_tmp48)), (clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL)), _tmp49);
							(len_call == NULL) ? NULL : (len_call = (vala_ccode_node_unref (len_call), NULL));
						} else {
							ValaFormalParameter* _tmp50;
							gboolean _tmp51;
							_tmp50 = NULL;
							if ((_tmp51 = vala_formal_parameter_get_no_array_length (_tmp50 = (ValaFormalParameter*) gee_list_get (d_params, i)), (_tmp50 == NULL) ? NULL : (_tmp50 = (vala_code_node_unref (_tmp50), NULL)), _tmp51)) {
								ValaCCodeExpression* _tmp52;
								_tmp52 = NULL;
								clength = (_tmp52 = (ValaCCodeExpression*) vala_ccode_constant_new ("-1"), (clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL)), _tmp52);
							} else {
								ValaCCodeExpression* _tmp55;
								char* _tmp54;
								ValaFormalParameter* _tmp53;
								_tmp55 = NULL;
								_tmp54 = NULL;
								_tmp53 = NULL;
								clength = (_tmp55 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp54 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) (_tmp53 = (ValaFormalParameter*) gee_list_get (d_params, i))), dim)), (clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL)), _tmp55);
								_tmp54 = (g_free (_tmp54), NULL);
								(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_code_node_unref (_tmp53), NULL));
							}
						}
						gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), clength);
						(clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL));
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			}
			i++;
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			(arg == NULL) ? NULL : (arg = (vala_ccode_node_unref (arg), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp56 = FALSE;
	if (!vala_method_get_no_array_length (m)) {
		_tmp56 = VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m));
	} else {
		_tmp56 = FALSE;
	}
	if (_tmp56) {
		ValaArrayType* _tmp57;
		ValaArrayType* array_type;
		_tmp57 = NULL;
		array_type = (_tmp57 = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp57 == NULL) ? NULL : vala_code_node_ref (_tmp57));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				ValaCCodeExpression* clength;
				clength = NULL;
				if (vala_delegate_get_no_array_length (d)) {
					ValaCCodeExpression* _tmp58;
					_tmp58 = NULL;
					clength = (_tmp58 = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL)), _tmp58);
				} else {
					ValaCCodeExpression* _tmp60;
					char* _tmp59;
					_tmp60 = NULL;
					_tmp59 = NULL;
					clength = (_tmp60 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp59 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim)), (clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL)), _tmp60);
					_tmp59 = (g_free (_tmp59), NULL);
				}
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), clength);
				(clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL));
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	}
	_tmp61 = NULL;
	if ((_tmp62 = gee_collection_get_size ((GeeCollection*) (_tmp61 = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0, (_tmp61 == NULL) ? NULL : (_tmp61 = (gee_collection_object_unref (_tmp61), NULL)), _tmp62)) {
		ValaCCodeIdentifier* _tmp63;
		_tmp63 = NULL;
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp63 = vala_ccode_identifier_new ("error")));
		(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
	}
	_tmp65 = NULL;
	_tmp64 = NULL;
	_tmp66 = NULL;
	ccall = (_tmp66 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp65 = vala_ccode_identifier_new (_tmp64 = vala_method_get_cname (m)))), (_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL)), _tmp64 = (g_free (_tmp64), NULL), _tmp66);
	/* append C arguments in the right order*/
	last_pos = -1;
	while (TRUE) {
		ValaCCodeExpression* _tmp71;
		min_pos = -1;
		{
			GeeSet* _tmp67;
			GeeIterator* _tmp68;
			GeeIterator* _pos_it;
			_tmp67 = NULL;
			_tmp68 = NULL;
			_pos_it = (_tmp68 = gee_iterable_iterator ((GeeIterable*) (_tmp67 = gee_map_get_keys ((GeeMap*) carg_map))), (_tmp67 == NULL) ? NULL : (_tmp67 = (gee_collection_object_unref (_tmp67), NULL)), _tmp68);
			while (gee_iterator_next (_pos_it)) {
				gint pos;
				gboolean _tmp69;
				pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
				_tmp69 = FALSE;
				if (pos > last_pos) {
					gboolean _tmp70;
					_tmp70 = FALSE;
					if (min_pos == (-1)) {
						_tmp70 = TRUE;
					} else {
						_tmp70 = pos < min_pos;
					}
					_tmp69 = (_tmp70);
				} else {
					_tmp69 = FALSE;
				}
				if (_tmp69) {
					min_pos = pos;
				}
			}
			(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
		}
		if (min_pos == (-1)) {
			break;
		}
		_tmp71 = NULL;
		vala_ccode_function_call_add_argument (ccall, _tmp71 = (ValaCCodeExpression*) gee_map_get ((GeeMap*) carg_map, GINT_TO_POINTER (min_pos)));
		(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
		last_pos = min_pos;
	}
	block = vala_ccode_block_new ();
	if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaCCodeExpressionStatement* _tmp72;
		_tmp72 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp72 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
	} else {
		ValaCCodeReturnStatement* _tmp73;
		_tmp73 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp73 = vala_ccode_return_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL));
	}
	/* append to file*/
	_tmp74 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp74 = vala_ccode_function_copy (function)));
	(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp75 = NULL;
	return (_tmp75 = wrapper_name, delegate_name = (g_free (delegate_name), NULL), (sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL)), (dynamic_sig == NULL) ? NULL : (dynamic_sig = (vala_code_node_unref (dynamic_sig), NULL)), (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)), (d_params == NULL) ? NULL : (d_params = (gee_collection_object_unref (d_params), NULL)), (carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp75);
}


static void vala_ccode_delegate_module_class_init (ValaCCodeDelegateModuleClass * klass) {
	vala_ccode_delegate_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_delegate = vala_ccode_delegate_module_real_visit_delegate;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cname = vala_ccode_delegate_module_real_get_delegate_target_cname;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cexpression = vala_ccode_delegate_module_real_get_delegate_target_cexpression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_destroy_notify_cname = vala_ccode_delegate_module_real_get_delegate_target_destroy_notify_cname;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_implicit_cast_expression = vala_ccode_delegate_module_real_get_implicit_cast_expression;
}


static void vala_ccode_delegate_module_instance_init (ValaCCodeDelegateModule * self) {
}


GType vala_ccode_delegate_module_get_type (void) {
	static GType vala_ccode_delegate_module_type_id = 0;
	if (vala_ccode_delegate_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDelegateModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_delegate_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDelegateModule), 0, (GInstanceInitFunc) vala_ccode_delegate_module_instance_init, NULL };
		vala_ccode_delegate_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ARRAY_MODULE, "ValaCCodeDelegateModule", &g_define_type_info, 0);
	}
	return vala_ccode_delegate_module_type_id;
}




