/* libepc-1.0.vapi generated by lt-vapigen, do not modify. */

[CCode (cprefix = "Epc", lower_case_cprefix = "epc_")]
namespace Epc {
	[CCode (cprefix = "EPC_ADDRESS_", cheader_filename = "libepc/enums.h")]
	public enum AddressFamily {
		UNSPEC,
		IPV4,
		IPV6
	}
	[CCode (cprefix = "EPC_COLLISIONS_", cheader_filename = "libepc/enums.h")]
	public enum CollisionHandling {
		IGNORE,
		CHANGE_NAME,
		UNIQUE_SERVICE
	}
	[CCode (cprefix = "EPC_PROTOCOL_", cheader_filename = "libepc/enums.h")]
	public enum Protocol {
		UNKNOWN,
		HTTP,
		HTTPS
	}
	[CCode (cprefix = "EPC_AUTH_", cheader_filename = "libepc/enums.h")]
	[Flags]
	public enum AuthFlags {
		DEFAULT,
		PASSWORD_TEXT_NEEDED
	}
	[Compact]
	[CCode (cheader_filename = "libepc/publisher.h")]
	public class AuthContext {
		public bool check_password (string password);
		public weak string get_key ();
		public weak string get_password ();
		public weak Epc.Publisher get_publisher ();
	}
	[Compact]
	[CCode (ref_function = "epc_contents_ref", unref_function = "epc_contents_unref", cheader_filename = "libepc/contents.h")]
	public class Contents {
		public void* get_data (ulong length);
		public weak string get_mime_type ();
		public bool is_stream ();
		public Contents (string type, void* data, long length, GLib.DestroyNotify destroy_data);
		public Contents.dup (string type, void* data, long length);
		public static weak Epc.Contents stream_new (string type, Epc.ContentsReadFunc callback, GLib.DestroyNotify destroy_data);
		public void* stream_read (ulong length);
	}
	[Compact]
	[CCode (ref_function = "epc_service_info_ref", unref_function = "epc_service_info_unref", cheader_filename = "libepc/service-info.h")]
	public class ServiceInfo : GLib.Boxed {
		public Epc.AddressFamily get_address_family ();
		public weak string get_detail (string name);
		public weak string get_host ();
		public weak string get_interface ();
		public uint get_port ();
		public weak string get_service_type ();
	}
	[CCode (cheader_filename = "libepc/consumer.h")]
	public class Consumer : GLib.Object {
		public weak string get_password ();
		public Epc.Protocol get_protocol ();
		public weak string get_username ();
		public bool is_publisher_resolved ();
		public weak GLib.List list (string pattern) throws GLib.Error;
		public void* lookup (string key, out weak ulong? length) throws GLib.Error;
		public Consumer (Epc.ServiceInfo service);
		public Consumer.for_name (string name);
		public Consumer.for_name_full (string name, string application, string domain);
		public bool resolve_publisher (uint timeout);
		public void set_password (string password);
		public void set_protocol (Epc.Protocol protocol);
		public void set_username (string username);
		[NoAccessorMethod]
		public string application { get; construct; }
		[NoAccessorMethod]
		public string domain { get; construct; }
		[NoAccessorMethod]
		public string hostname { get; construct; }
		[NoAccessorMethod]
		public string name { get; construct; }
		public string password { get; set construct; }
		[NoAccessorMethod]
		public string path { get; construct; }
		[NoAccessorMethod]
		public int port { get; construct; }
		public Epc.Protocol protocol { get; set construct; }
		public string username { get; set construct; }
		public virtual signal bool authenticate (string realm);
		public virtual signal void publisher_resolved (Epc.Protocol protocol, string hostname, uint port);
	}
	[CCode (cheader_filename = "libepc/dispatcher.h")]
	public class Dispatcher : GLib.Object {
		public void add_service (Epc.AddressFamily protocol, string type, string domain, string host, ushort port);
		public void add_service_subtype (string type, string subtype);
		public Epc.CollisionHandling get_collision_handling ();
		public weak string get_cookie ();
		public weak string get_name ();
		public Dispatcher (string name);
		public void reset ();
		public bool run () throws GLib.Error;
		public void set_collision_handling (Epc.CollisionHandling method);
		public void set_cookie (string cookie);
		public void set_name (string name);
		public void set_service_details (string type);
		public Epc.CollisionHandling collision_handling { get; set construct; }
		public string cookie { get; set construct; }
		public string name { get; set construct; }
	}
	[CCode (cheader_filename = "libepc/publisher.h")]
	public class Publisher : GLib.Object {
		public void add (string key, void* data, long length);
		public void add_bookmark (string key, string label);
		public void add_file (string key, string filename);
		public void add_handler (string key, Epc.ContentsHandler handler, GLib.DestroyNotify destroy_data);
		public static weak string expand_name (string name) throws GLib.Error;
		public Epc.AuthFlags get_auth_flags ();
		public weak string get_certificate_file ();
		public Epc.CollisionHandling get_collision_handling ();
		public weak string get_contents_path ();
		public weak string get_path (string key);
		public weak string get_private_key_file ();
		public Epc.Protocol get_protocol ();
		public weak string get_service_cookie ();
		public weak string get_service_domain ();
		public weak string get_service_name ();
		public weak string get_uri (string key) throws GLib.Error;
		public bool has_key (string key);
		public weak GLib.List list (string pattern);
		public void* lookup (string key);
		public Publisher (string? name, string application, string? domain);
		public bool quit ();
		public bool remove (string key);
		public bool run () throws GLib.Error;
		public bool run_async () throws GLib.Error;
		public void set_auth_flags (Epc.AuthFlags flags);
		public void set_auth_handler (string key, Epc.AuthHandler handler, GLib.DestroyNotify destroy_data);
		public void set_collision_handling (Epc.CollisionHandling method);
		public void set_contents_path (string path);
		public void set_credentials (string certfile, string keyfile);
		public void set_protocol (Epc.Protocol protocol);
		public void set_service_cookie (string cookie);
		public void set_service_name (string name);
		[NoAccessorMethod]
		public string application { get; set construct; }
		public Epc.AuthFlags auth_flags { get; set construct; }
		[NoAccessorMethod]
		public string certificate_file { get; set construct; }
		public Epc.CollisionHandling collision_handling { get; set construct; }
		public string contents_path { get; set construct; }
		[NoAccessorMethod]
		public string private_key_file { get; set construct; }
		public Epc.Protocol protocol { get; set construct; }
		public string service_cookie { get; set construct; }
		[NoAccessorMethod]
		public string service_domain { get; set construct; }
		public string service_name { get; set construct; }
	}
	[CCode (cheader_filename = "libepc/service-monitor.h")]
	public class ServiceMonitor : GLib.Object {
		public bool get_skip_our_own ();
		public ServiceMonitor (string? application, string? domain, ...);
		public ServiceMonitor.for_types (string? domain, ...);
		public ServiceMonitor.for_types_strv (string? domain, string types);
		public void set_skip_our_own (bool setting);
		[NoAccessorMethod]
		public string application { get; construct; }
		[NoAccessorMethod]
		public string domain { get; construct; }
		[NoAccessorMethod]
		public string[] service_types { get; construct; }
		public bool skip_our_own { get; set construct; }
		public virtual signal void scanning_done (string type);
		public virtual signal void service_found (string name, Epc.ServiceInfo info);
		public virtual signal void service_removed (string name, string type);
	}
	[CCode (cheader_filename = "libepc/service-type.h")]
	public delegate bool AuthHandler (Epc.AuthContext context, string username);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public delegate weak Epc.Contents ContentsHandler (Epc.Publisher publisher, string key);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public delegate bool ContentsReadFunc (Epc.Contents contents, void* buffer, ulong length);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public const string SERVICE_TYPE_HTTP;
	[CCode (cheader_filename = "libepc/service-type.h")]
	public const string SERVICE_TYPE_HTTPS;
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static weak GLib.EnumClass address_family_get_class ();
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static weak GLib.FlagsClass auth_flags_get_class ();
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static weak string auth_flags_to_string (Epc.AuthFlags value);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static weak GLib.EnumClass collision_handling_get_class ();
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static weak string collision_handling_to_string (Epc.CollisionHandling value);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static GLib.Quark http_error_quark ();
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static weak string protocol_build_uri (Epc.Protocol protocol, string hostname, ushort port, string path);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static Epc.Protocol protocol_from_name (string name, Epc.Protocol fallback);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static weak GLib.EnumClass protocol_get_class ();
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static weak string protocol_get_service_type (Epc.Protocol protocol);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static weak string protocol_get_uri_scheme (Epc.Protocol protocol);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static weak string protocol_to_string (Epc.Protocol value);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static weak string service_type_get_base (string type);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static Epc.Protocol service_type_get_protocol (string service_type);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static weak string service_type_list_supported (string application);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static weak string service_type_new (Epc.Protocol protocol, string application);
}
