/* valaccodeconstant.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeconstant.h>




struct _ValaCCodeConstantPrivate {
	char* _name;
};

#define VALA_CCODE_CONSTANT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_CONSTANT, ValaCCodeConstantPrivate))
enum  {
	VALA_CCODE_CONSTANT_DUMMY_PROPERTY
};
static void vala_ccode_constant_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_constant_parent_class = NULL;
static void vala_ccode_constant_finalize (ValaCCodeNode* obj);



ValaCCodeConstant* vala_ccode_constant_construct (GType object_type, const char* _name) {
	ValaCCodeConstant* self;
	g_return_val_if_fail (_name != NULL, NULL);
	self = (ValaCCodeConstant*) g_type_create_instance (object_type);
	vala_ccode_constant_set_name (self, _name);
	return self;
}


ValaCCodeConstant* vala_ccode_constant_new (const char* _name) {
	return vala_ccode_constant_construct (VALA_TYPE_CCODE_CONSTANT, _name);
}


static void vala_ccode_constant_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeConstant * self;
	self = (ValaCCodeConstant*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, self->priv->_name);
}


const char* vala_ccode_constant_get_name (ValaCCodeConstant* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_name;
}


void vala_ccode_constant_set_name (ValaCCodeConstant* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_name = (g_free (self->priv->_name), NULL), _tmp2);
}


static void vala_ccode_constant_class_init (ValaCCodeConstantClass * klass) {
	vala_ccode_constant_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_constant_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeConstantPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_constant_real_write;
}


static void vala_ccode_constant_instance_init (ValaCCodeConstant * self) {
	self->priv = VALA_CCODE_CONSTANT_GET_PRIVATE (self);
}


static void vala_ccode_constant_finalize (ValaCCodeNode* obj) {
	ValaCCodeConstant * self;
	self = VALA_CCODE_CONSTANT (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	VALA_CCODE_NODE_CLASS (vala_ccode_constant_parent_class)->finalize (obj);
}


GType vala_ccode_constant_get_type (void) {
	static GType vala_ccode_constant_type_id = 0;
	if (vala_ccode_constant_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeConstantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_constant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeConstant), 0, (GInstanceInitFunc) vala_ccode_constant_instance_init, NULL };
		vala_ccode_constant_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeConstant", &g_define_type_info, 0);
	}
	return vala_ccode_constant_type_id;
}




