/* valaccodefunctioncall.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodefunctioncall.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/readonlylist.h>
#include <stdlib.h>
#include <string.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <ccode/valaccodenode.h>




struct _ValaCCodeFunctionCallPrivate {
	ValaCCodeExpression* _call;
	GeeList* arguments;
};

#define VALA_CCODE_FUNCTION_CALL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCallPrivate))
enum  {
	VALA_CCODE_FUNCTION_CALL_DUMMY_PROPERTY
};
static void vala_ccode_function_call_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_function_call_parent_class = NULL;
static void vala_ccode_function_call_finalize (ValaCCodeNode* obj);



ValaCCodeFunctionCall* vala_ccode_function_call_construct (GType object_type, ValaCCodeExpression* call) {
	ValaCCodeFunctionCall* self;
	self = (ValaCCodeFunctionCall*) g_type_create_instance (object_type);
	vala_ccode_function_call_set_call (self, call);
	return self;
}


ValaCCodeFunctionCall* vala_ccode_function_call_new (ValaCCodeExpression* call) {
	return vala_ccode_function_call_construct (VALA_TYPE_CCODE_FUNCTION_CALL, call);
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param expr a C code expression
 */
void vala_ccode_function_call_add_argument (ValaCCodeFunctionCall* self, ValaCCodeExpression* expr) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	gee_collection_add ((GeeCollection*) self->priv->arguments, expr);
}


void vala_ccode_function_call_insert_argument (ValaCCodeFunctionCall* self, gint index, ValaCCodeExpression* expr) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	gee_list_insert (self->priv->arguments, index, expr);
}


/**
 * Returns a copy of the list of arguments.
 *
 * @return list of arguments
 */
GeeList* vala_ccode_function_call_get_arguments (ValaCCodeFunctionCall* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return (GeeList*) gee_read_only_list_new (VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, self->priv->arguments);
}


static void vala_ccode_function_call_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeFunctionCall * self;
	gboolean first;
	self = (ValaCCodeFunctionCall*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_node_write ((ValaCCodeNode*) self->priv->_call, writer);
	vala_ccode_writer_write_string (writer, " (");
	first = TRUE;
	{
		GeeIterator* expr_it;
		expr_it = gee_iterable_iterator ((GeeIterable*) self->priv->arguments);
		while (gee_iterator_next (expr_it)) {
			ValaCCodeExpression* expr;
			expr = (ValaCCodeExpression*) gee_iterator_get (expr_it);
			if (!first) {
				vala_ccode_writer_write_string (writer, ", ");
			} else {
				first = FALSE;
			}
			if (expr != NULL) {
				vala_ccode_node_write ((ValaCCodeNode*) expr, writer);
			}
			(expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL));
		}
		(expr_it == NULL) ? NULL : (expr_it = (gee_collection_object_unref (expr_it), NULL));
	}
	vala_ccode_writer_write_string (writer, ")");
}


ValaCCodeExpression* vala_ccode_function_call_get_call (ValaCCodeFunctionCall* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_call;
}


void vala_ccode_function_call_set_call (ValaCCodeFunctionCall* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_call = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1)), (self->priv->_call == NULL) ? NULL : (self->priv->_call = (vala_ccode_node_unref (self->priv->_call), NULL)), _tmp2);
}


static void vala_ccode_function_call_class_init (ValaCCodeFunctionCallClass * klass) {
	vala_ccode_function_call_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_function_call_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeFunctionCallPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_function_call_real_write;
}


static void vala_ccode_function_call_instance_init (ValaCCodeFunctionCall * self) {
	self->priv = VALA_CCODE_FUNCTION_CALL_GET_PRIVATE (self);
	self->priv->arguments = (GeeList*) gee_array_list_new (VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_equal);
}


static void vala_ccode_function_call_finalize (ValaCCodeNode* obj) {
	ValaCCodeFunctionCall * self;
	self = VALA_CCODE_FUNCTION_CALL (obj);
	(self->priv->_call == NULL) ? NULL : (self->priv->_call = (vala_ccode_node_unref (self->priv->_call), NULL));
	(self->priv->arguments == NULL) ? NULL : (self->priv->arguments = (gee_collection_object_unref (self->priv->arguments), NULL));
	VALA_CCODE_NODE_CLASS (vala_ccode_function_call_parent_class)->finalize (obj);
}


GType vala_ccode_function_call_get_type (void) {
	static GType vala_ccode_function_call_type_id = 0;
	if (vala_ccode_function_call_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeFunctionCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_function_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeFunctionCall), 0, (GInstanceInitFunc) vala_ccode_function_call_instance_init, NULL };
		vala_ccode_function_call_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeFunctionCall", &g_define_type_info, 0);
	}
	return vala_ccode_function_call_type_id;
}




