/* valatokentype.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valatokentype.h>







const char* vala_token_type_to_string (ValaTokenType self) {
	switch (self) {
		case VALA_TOKEN_TYPE_ABSTRACT:
		{
			return "`abstract'";
		}
		case VALA_TOKEN_TYPE_AS:
		{
			return "`as'";
		}
		case VALA_TOKEN_TYPE_ASSIGN:
		{
			return "`='";
		}
		case VALA_TOKEN_TYPE_ASSIGN_ADD:
		{
			return "`+='";
		}
		case VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND:
		{
			return "`&='";
		}
		case VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR:
		{
			return "`|='";
		}
		case VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR:
		{
			return "`^='";
		}
		case VALA_TOKEN_TYPE_ASSIGN_DIV:
		{
			return "`/='";
		}
		case VALA_TOKEN_TYPE_ASSIGN_MUL:
		{
			return "`*='";
		}
		case VALA_TOKEN_TYPE_ASSIGN_PERCENT:
		{
			return "`%='";
		}
		case VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT:
		{
			return "`<<='";
		}
		case VALA_TOKEN_TYPE_ASSIGN_SUB:
		{
			return "`-='";
		}
		case VALA_TOKEN_TYPE_BASE:
		{
			return "`base'";
		}
		case VALA_TOKEN_TYPE_BITWISE_AND:
		{
			return "`&'";
		}
		case VALA_TOKEN_TYPE_BITWISE_OR:
		{
			return "`|'";
		}
		case VALA_TOKEN_TYPE_BREAK:
		{
			return "`break'";
		}
		case VALA_TOKEN_TYPE_CARRET:
		{
			return "`^'";
		}
		case VALA_TOKEN_TYPE_CASE:
		{
			return "`case'";
		}
		case VALA_TOKEN_TYPE_CATCH:
		{
			return "`catch'";
		}
		case VALA_TOKEN_TYPE_CHARACTER_LITERAL:
		{
			return "character literal";
		}
		case VALA_TOKEN_TYPE_CLASS:
		{
			return "`class'";
		}
		case VALA_TOKEN_TYPE_CLOSE_BRACE:
		{
			return "`}'";
		}
		case VALA_TOKEN_TYPE_CLOSE_BRACKET:
		{
			return "`]'";
		}
		case VALA_TOKEN_TYPE_CLOSE_PARENS:
		{
			return "`)'";
		}
		case VALA_TOKEN_TYPE_COLON:
		{
			return "`:'";
		}
		case VALA_TOKEN_TYPE_COMMA:
		{
			return "`,'";
		}
		case VALA_TOKEN_TYPE_CONST:
		{
			return "`const'";
		}
		case VALA_TOKEN_TYPE_CONSTRUCT:
		{
			return "`construct'";
		}
		case VALA_TOKEN_TYPE_CONTINUE:
		{
			return "`continue'";
		}
		case VALA_TOKEN_TYPE_DEFAULT:
		{
			return "`default'";
		}
		case VALA_TOKEN_TYPE_DELEGATE:
		{
			return "`delegate'";
		}
		case VALA_TOKEN_TYPE_DELETE:
		{
			return "`delete'";
		}
		case VALA_TOKEN_TYPE_DIV:
		{
			return "`/'";
		}
		case VALA_TOKEN_TYPE_DO:
		{
			return "`do'";
		}
		case VALA_TOKEN_TYPE_DOT:
		{
			return "`.'";
		}
		case VALA_TOKEN_TYPE_ELLIPSIS:
		{
			return "`...'";
		}
		case VALA_TOKEN_TYPE_ELSE:
		{
			return "`else'";
		}
		case VALA_TOKEN_TYPE_ENUM:
		{
			return "`enum'";
		}
		case VALA_TOKEN_TYPE_ENSURES:
		{
			return "`ensures'";
		}
		case VALA_TOKEN_TYPE_ERRORDOMAIN:
		{
			return "`errordomain'";
		}
		case VALA_TOKEN_TYPE_EOF:
		{
			return "end of file";
		}
		case VALA_TOKEN_TYPE_FALSE:
		{
			return "`false'";
		}
		case VALA_TOKEN_TYPE_FINALLY:
		{
			return "`finally'";
		}
		case VALA_TOKEN_TYPE_FOR:
		{
			return "`for'";
		}
		case VALA_TOKEN_TYPE_FOREACH:
		{
			return "`foreach'";
		}
		case VALA_TOKEN_TYPE_GET:
		{
			return "`get'";
		}
		case VALA_TOKEN_TYPE_HASH:
		{
			return "`hash'";
		}
		case VALA_TOKEN_TYPE_IDENTIFIER:
		{
			return "identifier";
		}
		case VALA_TOKEN_TYPE_IF:
		{
			return "`if'";
		}
		case VALA_TOKEN_TYPE_IN:
		{
			return "`in'";
		}
		case VALA_TOKEN_TYPE_INLINE:
		{
			return "`inline'";
		}
		case VALA_TOKEN_TYPE_INTEGER_LITERAL:
		{
			return "integer literal";
		}
		case VALA_TOKEN_TYPE_INTERFACE:
		{
			return "`interface'";
		}
		case VALA_TOKEN_TYPE_INTERNAL:
		{
			return "`internal'";
		}
		case VALA_TOKEN_TYPE_INTERR:
		{
			return "`?'";
		}
		case VALA_TOKEN_TYPE_IS:
		{
			return "`is'";
		}
		case VALA_TOKEN_TYPE_LAMBDA:
		{
			return "`=>'";
		}
		case VALA_TOKEN_TYPE_LOCK:
		{
			return "`lock'";
		}
		case VALA_TOKEN_TYPE_MINUS:
		{
			return "`-'";
		}
		case VALA_TOKEN_TYPE_NAMESPACE:
		{
			return "`namespace'";
		}
		case VALA_TOKEN_TYPE_NEW:
		{
			return "`new'";
		}
		case VALA_TOKEN_TYPE_NULL:
		{
			return "`null'";
		}
		case VALA_TOKEN_TYPE_OUT:
		{
			return "`out'";
		}
		case VALA_TOKEN_TYPE_OP_AND:
		{
			return "`&&'";
		}
		case VALA_TOKEN_TYPE_OP_DEC:
		{
			return "`--'";
		}
		case VALA_TOKEN_TYPE_OP_EQ:
		{
			return "`=='";
		}
		case VALA_TOKEN_TYPE_OP_GE:
		{
			return "`>='";
		}
		case VALA_TOKEN_TYPE_OP_GT:
		{
			return "`>'";
		}
		case VALA_TOKEN_TYPE_OP_INC:
		{
			return "`++'";
		}
		case VALA_TOKEN_TYPE_OP_LE:
		{
			return "`<='";
		}
		case VALA_TOKEN_TYPE_OP_LT:
		{
			return "`<'";
		}
		case VALA_TOKEN_TYPE_OP_NE:
		{
			return "`!='";
		}
		case VALA_TOKEN_TYPE_OP_NEG:
		{
			return "`!'";
		}
		case VALA_TOKEN_TYPE_OP_OR:
		{
			return "`||'";
		}
		case VALA_TOKEN_TYPE_OP_PTR:
		{
			return "`->'";
		}
		case VALA_TOKEN_TYPE_OP_SHIFT_LEFT:
		{
			return "`<<'";
		}
		case VALA_TOKEN_TYPE_OPEN_BRACE:
		{
			return "`{'";
		}
		case VALA_TOKEN_TYPE_OPEN_BRACKET:
		{
			return "`['";
		}
		case VALA_TOKEN_TYPE_OPEN_PARENS:
		{
			return "`('";
		}
		case VALA_TOKEN_TYPE_OVERRIDE:
		{
			return "`override'";
		}
		case VALA_TOKEN_TYPE_PERCENT:
		{
			return "`%'";
		}
		case VALA_TOKEN_TYPE_PLUS:
		{
			return "`+'";
		}
		case VALA_TOKEN_TYPE_PRIVATE:
		{
			return "`private'";
		}
		case VALA_TOKEN_TYPE_PROTECTED:
		{
			return "`protected'";
		}
		case VALA_TOKEN_TYPE_PUBLIC:
		{
			return "`public'";
		}
		case VALA_TOKEN_TYPE_REAL_LITERAL:
		{
			return "real literal";
		}
		case VALA_TOKEN_TYPE_REF:
		{
			return "`ref'";
		}
		case VALA_TOKEN_TYPE_REQUIRES:
		{
			return "`requires'";
		}
		case VALA_TOKEN_TYPE_RETURN:
		{
			return "`return'";
		}
		case VALA_TOKEN_TYPE_SEMICOLON:
		{
			return "`;'";
		}
		case VALA_TOKEN_TYPE_SET:
		{
			return "`set'";
		}
		case VALA_TOKEN_TYPE_SIGNAL:
		{
			return "`signal'";
		}
		case VALA_TOKEN_TYPE_SIZEOF:
		{
			return "`sizeof'";
		}
		case VALA_TOKEN_TYPE_STAR:
		{
			return "`*'";
		}
		case VALA_TOKEN_TYPE_STATIC:
		{
			return "`static'";
		}
		case VALA_TOKEN_TYPE_STRING_LITERAL:
		{
			return "string literal";
		}
		case VALA_TOKEN_TYPE_STRUCT:
		{
			return "`struct'";
		}
		case VALA_TOKEN_TYPE_SWITCH:
		{
			return "`switch'";
		}
		case VALA_TOKEN_TYPE_THIS:
		{
			return "`this'";
		}
		case VALA_TOKEN_TYPE_THROW:
		{
			return "`throw'";
		}
		case VALA_TOKEN_TYPE_THROWS:
		{
			return "`throws'";
		}
		case VALA_TOKEN_TYPE_TILDE:
		{
			return "`~'";
		}
		case VALA_TOKEN_TYPE_TRUE:
		{
			return "`true'";
		}
		case VALA_TOKEN_TYPE_TRY:
		{
			return "`try'";
		}
		case VALA_TOKEN_TYPE_TYPEOF:
		{
			return "`typeof'";
		}
		case VALA_TOKEN_TYPE_USING:
		{
			return "`using'";
		}
		case VALA_TOKEN_TYPE_VAR:
		{
			return "`var'";
		}
		case VALA_TOKEN_TYPE_VIRTUAL:
		{
			return "`virtual'";
		}
		case VALA_TOKEN_TYPE_VOID:
		{
			return "`void'";
		}
		case VALA_TOKEN_TYPE_VOLATILE:
		{
			return "`volatile'";
		}
		case VALA_TOKEN_TYPE_WEAK:
		{
			return "`weak'";
		}
		case VALA_TOKEN_TYPE_WHILE:
		{
			return "`while'";
		}
		case VALA_TOKEN_TYPE_YIELD:
		{
			return "`yield'";
		}
		case VALA_TOKEN_TYPE_YIELDS:
		{
			return "`yields'";
		}
		default:
		{
			return "unknown token";
		}
	}
}



GType vala_token_type_get_type (void) {
	static GType vala_token_type_type_id = 0;
	if (G_UNLIKELY (vala_token_type_type_id == 0)) {
		static const GEnumValue values[] = {{VALA_TOKEN_TYPE_NONE, "VALA_TOKEN_TYPE_NONE", "none"}, {VALA_TOKEN_TYPE_ABSTRACT, "VALA_TOKEN_TYPE_ABSTRACT", "abstract"}, {VALA_TOKEN_TYPE_AS, "VALA_TOKEN_TYPE_AS", "as"}, {VALA_TOKEN_TYPE_ASSIGN, "VALA_TOKEN_TYPE_ASSIGN", "assign"}, {VALA_TOKEN_TYPE_ASSIGN_ADD, "VALA_TOKEN_TYPE_ASSIGN_ADD", "assign-add"}, {VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND, "VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND", "assign-bitwise-and"}, {VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR, "VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR", "assign-bitwise-or"}, {VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR, "VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR", "assign-bitwise-xor"}, {VALA_TOKEN_TYPE_ASSIGN_DIV, "VALA_TOKEN_TYPE_ASSIGN_DIV", "assign-div"}, {VALA_TOKEN_TYPE_ASSIGN_MUL, "VALA_TOKEN_TYPE_ASSIGN_MUL", "assign-mul"}, {VALA_TOKEN_TYPE_ASSIGN_PERCENT, "VALA_TOKEN_TYPE_ASSIGN_PERCENT", "assign-percent"}, {VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT, "VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT", "assign-shift-left"}, {VALA_TOKEN_TYPE_ASSIGN_SUB, "VALA_TOKEN_TYPE_ASSIGN_SUB", "assign-sub"}, {VALA_TOKEN_TYPE_BASE, "VALA_TOKEN_TYPE_BASE", "base"}, {VALA_TOKEN_TYPE_BITWISE_AND, "VALA_TOKEN_TYPE_BITWISE_AND", "bitwise-and"}, {VALA_TOKEN_TYPE_BITWISE_OR, "VALA_TOKEN_TYPE_BITWISE_OR", "bitwise-or"}, {VALA_TOKEN_TYPE_BREAK, "VALA_TOKEN_TYPE_BREAK", "break"}, {VALA_TOKEN_TYPE_CARRET, "VALA_TOKEN_TYPE_CARRET", "carret"}, {VALA_TOKEN_TYPE_CASE, "VALA_TOKEN_TYPE_CASE", "case"}, {VALA_TOKEN_TYPE_CATCH, "VALA_TOKEN_TYPE_CATCH", "catch"}, {VALA_TOKEN_TYPE_CHARACTER_LITERAL, "VALA_TOKEN_TYPE_CHARACTER_LITERAL", "character-literal"}, {VALA_TOKEN_TYPE_CLASS, "VALA_TOKEN_TYPE_CLASS", "class"}, {VALA_TOKEN_TYPE_CLOSE_BRACE, "VALA_TOKEN_TYPE_CLOSE_BRACE", "close-brace"}, {VALA_TOKEN_TYPE_CLOSE_BRACKET, "VALA_TOKEN_TYPE_CLOSE_BRACKET", "close-bracket"}, {VALA_TOKEN_TYPE_CLOSE_PARENS, "VALA_TOKEN_TYPE_CLOSE_PARENS", "close-parens"}, {VALA_TOKEN_TYPE_COLON, "VALA_TOKEN_TYPE_COLON", "colon"}, {VALA_TOKEN_TYPE_COMMA, "VALA_TOKEN_TYPE_COMMA", "comma"}, {VALA_TOKEN_TYPE_CONST, "VALA_TOKEN_TYPE_CONST", "const"}, {VALA_TOKEN_TYPE_CONSTRUCT, "VALA_TOKEN_TYPE_CONSTRUCT", "construct"}, {VALA_TOKEN_TYPE_CONTINUE, "VALA_TOKEN_TYPE_CONTINUE", "continue"}, {VALA_TOKEN_TYPE_DEFAULT, "VALA_TOKEN_TYPE_DEFAULT", "default"}, {VALA_TOKEN_TYPE_DELEGATE, "VALA_TOKEN_TYPE_DELEGATE", "delegate"}, {VALA_TOKEN_TYPE_DELETE, "VALA_TOKEN_TYPE_DELETE", "delete"}, {VALA_TOKEN_TYPE_DIV, "VALA_TOKEN_TYPE_DIV", "div"}, {VALA_TOKEN_TYPE_DO, "VALA_TOKEN_TYPE_DO", "do"}, {VALA_TOKEN_TYPE_DOUBLE_COLON, "VALA_TOKEN_TYPE_DOUBLE_COLON", "double-colon"}, {VALA_TOKEN_TYPE_DOT, "VALA_TOKEN_TYPE_DOT", "dot"}, {VALA_TOKEN_TYPE_DYNAMIC, "VALA_TOKEN_TYPE_DYNAMIC", "dynamic"}, {VALA_TOKEN_TYPE_ELLIPSIS, "VALA_TOKEN_TYPE_ELLIPSIS", "ellipsis"}, {VALA_TOKEN_TYPE_ELSE, "VALA_TOKEN_TYPE_ELSE", "else"}, {VALA_TOKEN_TYPE_ENUM, "VALA_TOKEN_TYPE_ENUM", "enum"}, {VALA_TOKEN_TYPE_ENSURES, "VALA_TOKEN_TYPE_ENSURES", "ensures"}, {VALA_TOKEN_TYPE_ERRORDOMAIN, "VALA_TOKEN_TYPE_ERRORDOMAIN", "errordomain"}, {VALA_TOKEN_TYPE_EOF, "VALA_TOKEN_TYPE_EOF", "eof"}, {VALA_TOKEN_TYPE_EXTERN, "VALA_TOKEN_TYPE_EXTERN", "extern"}, {VALA_TOKEN_TYPE_FALSE, "VALA_TOKEN_TYPE_FALSE", "false"}, {VALA_TOKEN_TYPE_FINALLY, "VALA_TOKEN_TYPE_FINALLY", "finally"}, {VALA_TOKEN_TYPE_FOR, "VALA_TOKEN_TYPE_FOR", "for"}, {VALA_TOKEN_TYPE_FOREACH, "VALA_TOKEN_TYPE_FOREACH", "foreach"}, {VALA_TOKEN_TYPE_GET, "VALA_TOKEN_TYPE_GET", "get"}, {VALA_TOKEN_TYPE_HASH, "VALA_TOKEN_TYPE_HASH", "hash"}, {VALA_TOKEN_TYPE_IDENTIFIER, "VALA_TOKEN_TYPE_IDENTIFIER", "identifier"}, {VALA_TOKEN_TYPE_IF, "VALA_TOKEN_TYPE_IF", "if"}, {VALA_TOKEN_TYPE_IN, "VALA_TOKEN_TYPE_IN", "in"}, {VALA_TOKEN_TYPE_INLINE, "VALA_TOKEN_TYPE_INLINE", "inline"}, {VALA_TOKEN_TYPE_INTEGER_LITERAL, "VALA_TOKEN_TYPE_INTEGER_LITERAL", "integer-literal"}, {VALA_TOKEN_TYPE_INTERFACE, "VALA_TOKEN_TYPE_INTERFACE", "interface"}, {VALA_TOKEN_TYPE_INTERNAL, "VALA_TOKEN_TYPE_INTERNAL", "internal"}, {VALA_TOKEN_TYPE_INTERR, "VALA_TOKEN_TYPE_INTERR", "interr"}, {VALA_TOKEN_TYPE_IS, "VALA_TOKEN_TYPE_IS", "is"}, {VALA_TOKEN_TYPE_LAMBDA, "VALA_TOKEN_TYPE_LAMBDA", "lambda"}, {VALA_TOKEN_TYPE_LOCK, "VALA_TOKEN_TYPE_LOCK", "lock"}, {VALA_TOKEN_TYPE_MINUS, "VALA_TOKEN_TYPE_MINUS", "minus"}, {VALA_TOKEN_TYPE_NAMESPACE, "VALA_TOKEN_TYPE_NAMESPACE", "namespace"}, {VALA_TOKEN_TYPE_NEW, "VALA_TOKEN_TYPE_NEW", "new"}, {VALA_TOKEN_TYPE_NULL, "VALA_TOKEN_TYPE_NULL", "null"}, {VALA_TOKEN_TYPE_OUT, "VALA_TOKEN_TYPE_OUT", "out"}, {VALA_TOKEN_TYPE_OP_AND, "VALA_TOKEN_TYPE_OP_AND", "op-and"}, {VALA_TOKEN_TYPE_OP_DEC, "VALA_TOKEN_TYPE_OP_DEC", "op-dec"}, {VALA_TOKEN_TYPE_OP_EQ, "VALA_TOKEN_TYPE_OP_EQ", "op-eq"}, {VALA_TOKEN_TYPE_OP_GE, "VALA_TOKEN_TYPE_OP_GE", "op-ge"}, {VALA_TOKEN_TYPE_OP_GT, "VALA_TOKEN_TYPE_OP_GT", "op-gt"}, {VALA_TOKEN_TYPE_OP_INC, "VALA_TOKEN_TYPE_OP_INC", "op-inc"}, {VALA_TOKEN_TYPE_OP_LE, "VALA_TOKEN_TYPE_OP_LE", "op-le"}, {VALA_TOKEN_TYPE_OP_LT, "VALA_TOKEN_TYPE_OP_LT", "op-lt"}, {VALA_TOKEN_TYPE_OP_NE, "VALA_TOKEN_TYPE_OP_NE", "op-ne"}, {VALA_TOKEN_TYPE_OP_NEG, "VALA_TOKEN_TYPE_OP_NEG", "op-neg"}, {VALA_TOKEN_TYPE_OP_OR, "VALA_TOKEN_TYPE_OP_OR", "op-or"}, {VALA_TOKEN_TYPE_OP_PTR, "VALA_TOKEN_TYPE_OP_PTR", "op-ptr"}, {VALA_TOKEN_TYPE_OP_SHIFT_LEFT, "VALA_TOKEN_TYPE_OP_SHIFT_LEFT", "op-shift-left"}, {VALA_TOKEN_TYPE_OPEN_BRACE, "VALA_TOKEN_TYPE_OPEN_BRACE", "open-brace"}, {VALA_TOKEN_TYPE_OPEN_BRACKET, "VALA_TOKEN_TYPE_OPEN_BRACKET", "open-bracket"}, {VALA_TOKEN_TYPE_OPEN_PARENS, "VALA_TOKEN_TYPE_OPEN_PARENS", "open-parens"}, {VALA_TOKEN_TYPE_OVERRIDE, "VALA_TOKEN_TYPE_OVERRIDE", "override"}, {VALA_TOKEN_TYPE_PERCENT, "VALA_TOKEN_TYPE_PERCENT", "percent"}, {VALA_TOKEN_TYPE_PLUS, "VALA_TOKEN_TYPE_PLUS", "plus"}, {VALA_TOKEN_TYPE_PRIVATE, "VALA_TOKEN_TYPE_PRIVATE", "private"}, {VALA_TOKEN_TYPE_PROTECTED, "VALA_TOKEN_TYPE_PROTECTED", "protected"}, {VALA_TOKEN_TYPE_PUBLIC, "VALA_TOKEN_TYPE_PUBLIC", "public"}, {VALA_TOKEN_TYPE_REAL_LITERAL, "VALA_TOKEN_TYPE_REAL_LITERAL", "real-literal"}, {VALA_TOKEN_TYPE_REF, "VALA_TOKEN_TYPE_REF", "ref"}, {VALA_TOKEN_TYPE_REQUIRES, "VALA_TOKEN_TYPE_REQUIRES", "requires"}, {VALA_TOKEN_TYPE_RETURN, "VALA_TOKEN_TYPE_RETURN", "return"}, {VALA_TOKEN_TYPE_SEMICOLON, "VALA_TOKEN_TYPE_SEMICOLON", "semicolon"}, {VALA_TOKEN_TYPE_SET, "VALA_TOKEN_TYPE_SET", "set"}, {VALA_TOKEN_TYPE_SIGNAL, "VALA_TOKEN_TYPE_SIGNAL", "signal"}, {VALA_TOKEN_TYPE_SIZEOF, "VALA_TOKEN_TYPE_SIZEOF", "sizeof"}, {VALA_TOKEN_TYPE_STAR, "VALA_TOKEN_TYPE_STAR", "star"}, {VALA_TOKEN_TYPE_STATIC, "VALA_TOKEN_TYPE_STATIC", "static"}, {VALA_TOKEN_TYPE_STRING_LITERAL, "VALA_TOKEN_TYPE_STRING_LITERAL", "string-literal"}, {VALA_TOKEN_TYPE_STRUCT, "VALA_TOKEN_TYPE_STRUCT", "struct"}, {VALA_TOKEN_TYPE_SWITCH, "VALA_TOKEN_TYPE_SWITCH", "switch"}, {VALA_TOKEN_TYPE_THIS, "VALA_TOKEN_TYPE_THIS", "this"}, {VALA_TOKEN_TYPE_THROW, "VALA_TOKEN_TYPE_THROW", "throw"}, {VALA_TOKEN_TYPE_THROWS, "VALA_TOKEN_TYPE_THROWS", "throws"}, {VALA_TOKEN_TYPE_TILDE, "VALA_TOKEN_TYPE_TILDE", "tilde"}, {VALA_TOKEN_TYPE_TRUE, "VALA_TOKEN_TYPE_TRUE", "true"}, {VALA_TOKEN_TYPE_TRY, "VALA_TOKEN_TYPE_TRY", "try"}, {VALA_TOKEN_TYPE_TYPEOF, "VALA_TOKEN_TYPE_TYPEOF", "typeof"}, {VALA_TOKEN_TYPE_USING, "VALA_TOKEN_TYPE_USING", "using"}, {VALA_TOKEN_TYPE_VAR, "VALA_TOKEN_TYPE_VAR", "var"}, {VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL, "VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL", "verbatim-string-literal"}, {VALA_TOKEN_TYPE_VIRTUAL, "VALA_TOKEN_TYPE_VIRTUAL", "virtual"}, {VALA_TOKEN_TYPE_VOID, "VALA_TOKEN_TYPE_VOID", "void"}, {VALA_TOKEN_TYPE_VOLATILE, "VALA_TOKEN_TYPE_VOLATILE", "volatile"}, {VALA_TOKEN_TYPE_WEAK, "VALA_TOKEN_TYPE_WEAK", "weak"}, {VALA_TOKEN_TYPE_WHILE, "VALA_TOKEN_TYPE_WHILE", "while"}, {VALA_TOKEN_TYPE_YIELD, "VALA_TOKEN_TYPE_YIELD", "yield"}, {VALA_TOKEN_TYPE_YIELDS, "VALA_TOKEN_TYPE_YIELDS", "yields"}, {0, NULL, NULL}};
		vala_token_type_type_id = g_enum_register_static ("ValaTokenType", values);
	}
	return vala_token_type_type_id;
}




