/* valainitializerlist.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __VALA_VALAINITIALIZERLIST_H__
#define __VALA_VALAINITIALIZERLIST_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include <vala/valaexpression.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_INITIALIZER_LIST (vala_initializer_list_get_type ())
#define VALA_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerList))
#define VALA_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))
#define VALA_IS_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INITIALIZER_LIST))
#define VALA_IS_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INITIALIZER_LIST))
#define VALA_INITIALIZER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))

typedef struct _ValaInitializerListPrivate ValaInitializerListPrivate;

/**
 * Represents an array or struct initializer list in the source code.
 */
struct _ValaInitializerList {
	ValaExpression parent_instance;
	ValaInitializerListPrivate * priv;
};

struct _ValaInitializerListClass {
	ValaExpressionClass parent_class;
};


void vala_initializer_list_append (ValaInitializerList* self, ValaExpression* expr);
GeeList* vala_initializer_list_get_initializers (ValaInitializerList* self);
ValaInitializerList* vala_initializer_list_construct (GType object_type, ValaSourceReference* source_reference);
ValaInitializerList* vala_initializer_list_new (ValaSourceReference* source_reference);
gint vala_initializer_list_get_size (ValaInitializerList* self);
GType vala_initializer_list_get_type (void);


G_END_DECLS

#endif
