/* valaemptystatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaemptystatement.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




enum  {
	VALA_EMPTY_STATEMENT_DUMMY_PROPERTY
};
static void vala_empty_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_empty_statement_parent_class = NULL;
static ValaStatementIface* vala_empty_statement_vala_statement_parent_iface = NULL;



/**
 * Creates a new empty statement.
 *
 * @param source reference to source code
 * @return       newly created empty statement
 */
ValaEmptyStatement* vala_empty_statement_construct (GType object_type, ValaSourceReference* source) {
	ValaEmptyStatement* self;
	g_return_val_if_fail (source != NULL, NULL);
	self = ((ValaEmptyStatement*) (g_type_create_instance (object_type)));
	vala_code_node_set_source_reference (((ValaCodeNode*) (self)), source);
	return self;
}


ValaEmptyStatement* vala_empty_statement_new (ValaSourceReference* source) {
	return vala_empty_statement_construct (VALA_TYPE_EMPTY_STATEMENT, source);
}


static void vala_empty_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaEmptyStatement * self;
	self = ((ValaEmptyStatement*) (base));
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_empty_statement (visitor, self);
}


static void vala_empty_statement_class_init (ValaEmptyStatementClass * klass) {
	vala_empty_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->accept = vala_empty_statement_real_accept;
}


static void vala_empty_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_empty_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_empty_statement_instance_init (ValaEmptyStatement * self) {
}


GType vala_empty_statement_get_type (void) {
	static GType vala_empty_statement_type_id = 0;
	if (vala_empty_statement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaEmptyStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_empty_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaEmptyStatement), 0, (GInstanceInitFunc) vala_empty_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_empty_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_empty_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaEmptyStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_empty_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_empty_statement_type_id;
}




