/* valadbusclientmodule.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
*  Copyright (C) 2008  Philip Van Hoof
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Philip Van Hoof <pvanhoof@gnome.org>
 */

#include <gobject/valadbusclientmodule.h>
#include <ccode/valaccodefunction.h>
#include <vala/valamethod.h>
#include <vala/valadatatype.h>
#include <stdlib.h>
#include <string.h>
#include <gee/hashmap.h>
#include <ccode/valaccodeformalparameter.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeblock.h>
#include <vala/valareport.h>
#include <vala/valacodenode.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <vala/valainvocationexpression.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valaexpression.h>
#include <vala/valaunaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodeunaryexpression.h>
#include <gee/collection.h>
#include <vala/valaformalparameter.h>
#include <vala/valaerrortype.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <vala/valavoidtype.h>
#include <vala/valamethodtype.h>
#include <vala/valadelegatetype.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valastruct.h>
#include <vala/valafield.h>
#include <vala/valamember.h>
#include <ccode/valaccodeinitializerlist.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodeelementaccess.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodecastexpression.h>
#include <gee/list.h>
#include <gobject/valaccodebasemodule.h>
#include <gobject/valaccodemethodmodule.h>




enum  {
	VALA_DBUS_CLIENT_MODULE_DUMMY_PROPERTY
};
static void vala_dbus_client_module_real_generate_dynamic_method_wrapper (ValaCCodeModule* base, ValaDynamicMethod* method);
static void vala_dbus_client_module_generate_dbus_method_wrapper (ValaDBusClientModule* self, ValaMethod* method, ValaCCodeBlock* block);
static ValaCCodeExpression* vala_dbus_client_module_get_dbus_g_type (ValaDBusClientModule* self, ValaDataType* data_type);
static gpointer vala_dbus_client_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaDBusClientModule* vala_dbus_client_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaDBusClientModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = ((ValaDBusClientModule*) (g_type_create_instance (object_type)));
	self = ((ValaDBusClientModule*) (vala_gasync_module_construct (object_type, codegen, next)));
	return self;
}


ValaDBusClientModule* vala_dbus_client_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_dbus_client_module_construct (VALA_TYPE_DBUS_CLIENT_MODULE, codegen, next);
}


static void vala_dbus_client_module_real_generate_dynamic_method_wrapper (ValaCCodeModule* base, ValaDynamicMethod* method) {
	ValaDBusClientModule * self;
	ValaDynamicMethod* _tmp0;
	ValaDynamicMethod* dynamic_method;
	char* _tmp2;
	char* _tmp1;
	ValaCCodeFunction* _tmp3;
	ValaCCodeFunction* func;
	GeeHashMap* cparam_map;
	char* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* instance_param;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp8;
	self = ((ValaDBusClientModule*) (base));
	g_return_if_fail (method != NULL);
	_tmp0 = NULL;
	dynamic_method = (_tmp0 = VALA_DYNAMIC_METHOD (method), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp3 = NULL;
	func = (_tmp3 = vala_ccode_function_new ((_tmp1 = vala_method_get_cname (((ValaMethod*) (method)))), (_tmp2 = vala_data_type_get_cname (vala_method_get_return_type (((ValaMethod*) (method)))))), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), _tmp3);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	_tmp4 = NULL;
	_tmp5 = NULL;
	instance_param = (_tmp5 = vala_ccode_formal_parameter_new ("obj", (_tmp4 = vala_data_type_get_cname (vala_dynamic_method_get_dynamic_type (dynamic_method)))), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5);
	gee_map_set (((GeeMap*) (cparam_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_method_get_cinstance_parameter_position (((ValaMethod*) (method))), FALSE)), instance_param);
	vala_ccode_module_generate_cparameters (((ValaCCodeModule*) (self)), ((ValaMethod*) (method)), vala_method_get_return_type (((ValaMethod*) (method))), FALSE, ((GeeMap*) (cparam_map)), func, NULL, NULL, NULL, 3);
	block = vala_ccode_block_new ();
	if (vala_data_type_get_data_type (vala_dynamic_method_get_dynamic_type (dynamic_method)) == ((ValaCCodeBaseModule*) (self))->dbus_object_type) {
		vala_dbus_client_module_generate_dbus_method_wrapper (self, ((ValaMethod*) (method)), block);
	} else {
		char* _tmp7;
		char* _tmp6;
		_tmp7 = NULL;
		_tmp6 = NULL;
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (method))), (_tmp7 = g_strdup_printf ("dynamic methods are not supported for `%s'", (_tmp6 = vala_code_node_to_string (((ValaCodeNode*) (vala_dynamic_method_get_dynamic_type (dynamic_method))))))));
		_tmp7 = (g_free (_tmp7), NULL);
		_tmp6 = (g_free (_tmp6), NULL);
	}
	/* append to C source file*/
	_tmp8 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp8 = vala_ccode_function_copy (func)))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) (func)));
	(dynamic_method == NULL ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL)));
	(func == NULL ? NULL : (func = (vala_ccode_node_unref (func), NULL)));
	(cparam_map == NULL ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)));
	(instance_param == NULL ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL)));
	(block == NULL ? NULL : (block = (vala_ccode_node_unref (block), NULL)));
}


static void vala_dbus_client_module_generate_dbus_method_wrapper (ValaDBusClientModule* self, ValaMethod* method, ValaCCodeBlock* block) {
	ValaDynamicMethod* _tmp0;
	ValaDynamicMethod* dynamic_method;
	ValaInvocationExpression* _tmp1;
	ValaInvocationExpression* expr;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeFunctionCall* _tmp3;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp4;
	gboolean found_out;
	ValaExpression* callback;
	gint callback_index;
	gint arg_index;
	ValaCCodeConstant* _tmp9;
	char* _tmp8;
	char* _tmp7;
	ValaCCodeIdentifier* _tmp148;
	ValaCCodeFragment* out_marshalling_fragment;
	g_return_if_fail (self != NULL);
	g_return_if_fail (method != NULL);
	g_return_if_fail (block != NULL);
	_tmp0 = NULL;
	dynamic_method = (_tmp0 = VALA_DYNAMIC_METHOD (method), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	_tmp1 = NULL;
	expr = (_tmp1 = vala_dynamic_method_get_invocation (dynamic_method), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	_tmp2 = NULL;
	_tmp3 = NULL;
	ccall = (_tmp3 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp2 = vala_ccode_identifier_new ("dbus_g_proxy_begin_call"))))), (_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL))), _tmp3);
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp4 = vala_ccode_identifier_new ("obj")))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	found_out = FALSE;
	callback = NULL;
	callback_index = -1;
	arg_index = 1;
	{
		GeeList* arg_collection;
		int arg_it;
		arg_collection = vala_invocation_expression_get_argument_list (expr);
		for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
			ValaExpression* arg;
			arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
			{
				if (VALA_IS_METHOD (vala_expression_get_symbol_reference (arg))) {
					ValaExpression* _tmp6;
					ValaExpression* _tmp5;
					/* callback*/
					if (callback != NULL) {
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "only one reply callback may be specified in invocation of DBus method");
						vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
						(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
						(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
						(dynamic_method == NULL ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL)));
						(expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL)));
						(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
						(callback == NULL ? NULL : (callback = (vala_code_node_unref (callback), NULL)));
						return;
					} else {
						if (found_out) {
							vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "out argument and reply callback conflict in invocation of DBus method");
							vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
							(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
							(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
							(dynamic_method == NULL ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL)));
							(expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL)));
							(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
							(callback == NULL ? NULL : (callback = (vala_code_node_unref (callback), NULL)));
							return;
						}
					}
					_tmp6 = NULL;
					_tmp5 = NULL;
					callback = (_tmp6 = (_tmp5 = arg, (_tmp5 == NULL ? NULL : vala_code_node_ref (_tmp5))), (callback == NULL ? NULL : (callback = (vala_code_node_unref (callback), NULL))), _tmp6);
					callback_index = arg_index;
				} else {
					if (VALA_IS_UNARY_EXPRESSION (arg) && vala_unary_expression_get_operator ((VALA_UNARY_EXPRESSION (arg))) == VALA_UNARY_OPERATOR_OUT) {
						/* out arg*/
						if (callback != NULL) {
							vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "out argument and reply callback conflict in invocation of DBus method");
							vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
							(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
							(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
							(dynamic_method == NULL ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL)));
							(expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL)));
							(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
							(callback == NULL ? NULL : (callback = (vala_code_node_unref (callback), NULL)));
							return;
						}
						found_out = TRUE;
					} else {
						/* in arg*/
						if (callback != NULL || found_out) {
							vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "in argument must not follow out argument or reply callback in invocation of DBus method");
							vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
							(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
							(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
							(dynamic_method == NULL ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL)));
							(expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL)));
							(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
							(callback == NULL ? NULL : (callback = (vala_code_node_unref (callback), NULL)));
							return;
						}
					}
				}
				arg_index++;
				(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
	}
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp9 = vala_ccode_constant_new ((_tmp8 = g_strdup_printf ("\"%s\"", (_tmp7 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name (((ValaSymbol*) (method))))))))))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
	_tmp8 = (g_free (_tmp8), NULL);
	_tmp7 = (g_free (_tmp7), NULL);
	if (callback != NULL) {
		ValaMethod* _tmp10;
		ValaMethod* reply_method;
		char* _tmp12;
		char* _tmp11;
		ValaCCodeFunction* _tmp13;
		ValaCCodeFunction* cb_fun;
		ValaCCodeFormalParameter* _tmp14;
		ValaCCodeFormalParameter* _tmp15;
		ValaCCodeFormalParameter* _tmp16;
		ValaCCodeBlock* _tmp17;
		ValaCCodeDeclaration* cerrdecl;
		ValaCCodeVariableDeclarator* _tmp19;
		ValaCCodeConstant* _tmp18;
		ValaCCodeIdentifier* _tmp20;
		ValaCCodeFunctionCall* _tmp21;
		ValaCCodeFunctionCall* cend_call;
		ValaCCodeIdentifier* _tmp22;
		ValaCCodeIdentifier* _tmp23;
		ValaCCodeUnaryExpression* _tmp25;
		ValaCCodeIdentifier* _tmp24;
		ValaCCodeFunctionCall* creply_call;
		ValaCCodeIdentifier* _tmp26;
		GeeList* _tmp27;
		gint _tmp28;
		gint param_count;
		gint i;
		ValaCCodeIdentifier* _tmp51;
		ValaCCodeExpressionStatement* _tmp52;
		ValaCCodeIdentifier* _tmp53;
		ValaCCodeExpressionStatement* _tmp54;
		ValaCCodeIdentifier* _tmp55;
		ValaCCodeConstant* _tmp57;
		char* _tmp56;
		ValaCCodeConstant* _tmp58;
		_tmp10 = NULL;
		reply_method = (_tmp10 = VALA_METHOD (vala_expression_get_symbol_reference (callback)), (_tmp10 == NULL ? NULL : vala_code_node_ref (_tmp10)));
		_tmp12 = NULL;
		_tmp11 = NULL;
		_tmp13 = NULL;
		cb_fun = (_tmp13 = vala_ccode_function_new ((_tmp12 = g_strdup_printf ("_%s_cb", (_tmp11 = vala_method_get_cname (reply_method)))), "void"), (_tmp12 = (g_free (_tmp12), NULL)), (_tmp11 = (g_free (_tmp11), NULL)), _tmp13);
		vala_ccode_function_set_modifiers (cb_fun, VALA_CCODE_MODIFIERS_STATIC);
		_tmp14 = NULL;
		vala_ccode_function_add_parameter (cb_fun, (_tmp14 = vala_ccode_formal_parameter_new ("proxy", "DBusGProxy*")));
		(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
		_tmp15 = NULL;
		vala_ccode_function_add_parameter (cb_fun, (_tmp15 = vala_ccode_formal_parameter_new ("call", "DBusGProxyCall*")));
		(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
		_tmp16 = NULL;
		vala_ccode_function_add_parameter (cb_fun, (_tmp16 = vala_ccode_formal_parameter_new ("user_data", "void*")));
		(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
		_tmp17 = NULL;
		vala_ccode_function_set_block (cb_fun, (_tmp17 = vala_ccode_block_new ()));
		(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
		cerrdecl = vala_ccode_declaration_new ("GError*");
		_tmp19 = NULL;
		_tmp18 = NULL;
		vala_ccode_declaration_add_declarator (cerrdecl, ((ValaCCodeDeclarator*) ((_tmp19 = vala_ccode_variable_declarator_new_with_initializer ("error", ((ValaCCodeExpression*) ((_tmp18 = vala_ccode_constant_new ("NULL")))))))));
		(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
		(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), ((ValaCCodeNode*) (cerrdecl)));
		_tmp20 = NULL;
		_tmp21 = NULL;
		cend_call = (_tmp21 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp20 = vala_ccode_identifier_new ("dbus_g_proxy_end_call"))))), (_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL))), _tmp21);
		_tmp22 = NULL;
		vala_ccode_function_call_add_argument (cend_call, ((ValaCCodeExpression*) ((_tmp22 = vala_ccode_identifier_new ("proxy")))));
		(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
		_tmp23 = NULL;
		vala_ccode_function_call_add_argument (cend_call, ((ValaCCodeExpression*) ((_tmp23 = vala_ccode_identifier_new ("call")))));
		(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
		_tmp25 = NULL;
		_tmp24 = NULL;
		vala_ccode_function_call_add_argument (cend_call, ((ValaCCodeExpression*) ((_tmp25 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp24 = vala_ccode_identifier_new ("error")))))))));
		(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
		(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
		creply_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (callback)))));
		_tmp26 = NULL;
		vala_ccode_function_call_add_argument (creply_call, ((ValaCCodeExpression*) ((_tmp26 = vala_ccode_identifier_new ("user_data")))));
		(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
		_tmp27 = NULL;
		param_count = (_tmp28 = gee_collection_get_size (((GeeCollection*) ((_tmp27 = vala_method_get_parameters (reply_method))))), (_tmp27 == NULL ? NULL : (_tmp27 = (gee_collection_object_unref (_tmp27), NULL))), _tmp28);
		i = 0;
		{
			GeeList* param_collection;
			int param_it;
			param_collection = vala_method_get_parameters (reply_method);
			for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
				ValaFormalParameter* param;
				param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
				{
					if (((i = i + 1)) == param_count) {
						if (!(VALA_IS_ERROR_TYPE (vala_formal_parameter_get_parameter_type (param)))) {
							vala_report_error (NULL, "DBus reply callbacks must end with GLib.Error argument");
							(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
							(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
							(reply_method == NULL ? NULL : (reply_method = (vala_code_node_unref (reply_method), NULL)));
							(cb_fun == NULL ? NULL : (cb_fun = (vala_ccode_node_unref (cb_fun), NULL)));
							(cerrdecl == NULL ? NULL : (cerrdecl = (vala_ccode_node_unref (cerrdecl), NULL)));
							(cend_call == NULL ? NULL : (cend_call = (vala_ccode_node_unref (cend_call), NULL)));
							(creply_call == NULL ? NULL : (creply_call = (vala_ccode_node_unref (creply_call), NULL)));
							(dynamic_method == NULL ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL)));
							(expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL)));
							(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
							(callback == NULL ? NULL : (callback = (vala_code_node_unref (callback), NULL)));
							return;
						}
						(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
						break;
					}
					if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)) && vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))))) != vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->string_type)) {
						ValaArrayType* _tmp29;
						ValaArrayType* array_type;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp32;
						ValaCCodeExpression* _tmp33;
						ValaCCodeUnaryExpression* _tmp35;
						ValaCCodeIdentifier* _tmp34;
						ValaCCodeMemberAccess* _tmp37;
						ValaCCodeIdentifier* _tmp36;
						ValaCCodeMemberAccess* _tmp39;
						ValaCCodeIdentifier* _tmp38;
						_tmp29 = NULL;
						array_type = (_tmp29 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp29 == NULL ? NULL : vala_code_node_ref (_tmp29)));
						cdecl_ = NULL;
						if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
							ValaCCodeDeclaration* _tmp30;
							_tmp30 = NULL;
							cdecl_ = (_tmp30 = vala_ccode_declaration_new ("GPtrArray*"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp30);
						} else {
							ValaCCodeDeclaration* _tmp31;
							_tmp31 = NULL;
							cdecl_ = (_tmp31 = vala_ccode_declaration_new ("GArray*"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp31);
						}
						_tmp32 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp32 = vala_ccode_variable_declarator_new (vala_symbol_get_name (((ValaSymbol*) (param))))))));
						(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
						vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), ((ValaCCodeNode*) (cdecl_)));
						_tmp33 = NULL;
						vala_ccode_function_call_add_argument (cend_call, (_tmp33 = vala_dbus_client_module_get_dbus_g_type (self, ((ValaDataType*) (array_type)))));
						(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
						_tmp35 = NULL;
						_tmp34 = NULL;
						vala_ccode_function_call_add_argument (cend_call, ((ValaCCodeExpression*) ((_tmp35 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp34 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (param))))))))))));
						(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
						(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
						_tmp37 = NULL;
						_tmp36 = NULL;
						vala_ccode_function_call_add_argument (creply_call, ((ValaCCodeExpression*) ((_tmp37 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp36 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (param))))))), (vala_dbus_client_module_dbus_use_ptr_array (self, array_type) ? "pdata" : "data"))))));
						(_tmp37 == NULL ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)));
						(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
						_tmp39 = NULL;
						_tmp38 = NULL;
						vala_ccode_function_call_add_argument (creply_call, ((ValaCCodeExpression*) ((_tmp39 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp38 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (param))))))), "len")))));
						(_tmp39 == NULL ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL)));
						(_tmp38 == NULL ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)));
						(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
					} else {
						char* _tmp40;
						ValaCCodeDeclaration* _tmp41;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp42;
						ValaCCodeUnaryExpression* _tmp46;
						ValaCCodeIdentifier* _tmp45;
						ValaCCodeIdentifier* _tmp47;
						_tmp40 = NULL;
						_tmp41 = NULL;
						cdecl_ = (_tmp41 = vala_ccode_declaration_new ((_tmp40 = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param)))), (_tmp40 = (g_free (_tmp40), NULL)), _tmp41);
						_tmp42 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp42 = vala_ccode_variable_declarator_new (vala_symbol_get_name (((ValaSymbol*) (param))))))));
						(_tmp42 == NULL ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)));
						vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), ((ValaCCodeNode*) (cdecl_)));
						if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)) && vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))))) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->string_type)) {
							ValaCCodeIdentifier* _tmp43;
							/* special case string array*/
							_tmp43 = NULL;
							vala_ccode_function_call_add_argument (cend_call, ((ValaCCodeExpression*) ((_tmp43 = vala_ccode_identifier_new ("G_TYPE_STRV")))));
							(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
						} else {
							ValaCCodeExpression* _tmp44;
							_tmp44 = NULL;
							vala_ccode_function_call_add_argument (cend_call, (_tmp44 = vala_dbus_client_module_get_dbus_g_type (self, vala_formal_parameter_get_parameter_type (param))));
							(_tmp44 == NULL ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)));
						}
						_tmp46 = NULL;
						_tmp45 = NULL;
						vala_ccode_function_call_add_argument (cend_call, ((ValaCCodeExpression*) ((_tmp46 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp45 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (param))))))))))));
						(_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)));
						(_tmp45 == NULL ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL)));
						_tmp47 = NULL;
						vala_ccode_function_call_add_argument (creply_call, ((ValaCCodeExpression*) ((_tmp47 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (param))))))));
						(_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)));
						if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)) && vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))))) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->string_type)) {
							ValaCCodeIdentifier* _tmp48;
							ValaCCodeFunctionCall* _tmp49;
							ValaCCodeFunctionCall* cstrvlen;
							ValaCCodeIdentifier* _tmp50;
							_tmp48 = NULL;
							_tmp49 = NULL;
							cstrvlen = (_tmp49 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp48 = vala_ccode_identifier_new ("g_strv_length"))))), (_tmp48 == NULL ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL))), _tmp49);
							_tmp50 = NULL;
							vala_ccode_function_call_add_argument (cstrvlen, ((ValaCCodeExpression*) ((_tmp50 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (param))))))));
							(_tmp50 == NULL ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL)));
							vala_ccode_function_call_add_argument (creply_call, ((ValaCCodeExpression*) (cstrvlen)));
							(cstrvlen == NULL ? NULL : (cstrvlen = (vala_ccode_node_unref (cstrvlen), NULL)));
						}
						(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
					}
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
				}
			}
			(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
		}
		_tmp51 = NULL;
		vala_ccode_function_call_add_argument (cend_call, ((ValaCCodeExpression*) ((_tmp51 = vala_ccode_identifier_new ("G_TYPE_INVALID")))));
		(_tmp51 == NULL ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL)));
		_tmp52 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), ((ValaCCodeNode*) ((_tmp52 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cend_call)))))));
		(_tmp52 == NULL ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)));
		_tmp53 = NULL;
		vala_ccode_function_call_add_argument (creply_call, ((ValaCCodeExpression*) ((_tmp53 = vala_ccode_identifier_new ("error")))));
		(_tmp53 == NULL ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL)));
		_tmp54 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), ((ValaCCodeNode*) ((_tmp54 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (creply_call)))))));
		(_tmp54 == NULL ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL)));
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) (cb_fun)));
		_tmp55 = NULL;
		vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp55 = vala_ccode_identifier_new (vala_ccode_function_get_name (cb_fun))))));
		(_tmp55 == NULL ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL)));
		_tmp57 = NULL;
		_tmp56 = NULL;
		vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp57 = vala_ccode_constant_new ((_tmp56 = g_strdup_printf ("param%d_target", callback_index)))))));
		(_tmp57 == NULL ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL)));
		_tmp56 = (g_free (_tmp56), NULL);
		_tmp58 = NULL;
		vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp58 = vala_ccode_constant_new ("NULL")))));
		(_tmp58 == NULL ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL)));
		(reply_method == NULL ? NULL : (reply_method = (vala_code_node_unref (reply_method), NULL)));
		(cb_fun == NULL ? NULL : (cb_fun = (vala_ccode_node_unref (cb_fun), NULL)));
		(cerrdecl == NULL ? NULL : (cerrdecl = (vala_ccode_node_unref (cerrdecl), NULL)));
		(cend_call == NULL ? NULL : (cend_call = (vala_ccode_node_unref (cend_call), NULL)));
		(creply_call == NULL ? NULL : (creply_call = (vala_ccode_node_unref (creply_call), NULL)));
	} else {
		if (found_out || !(VALA_IS_VOID_TYPE (vala_method_get_return_type (method)))) {
			ValaCCodeIdentifier* _tmp59;
			ValaCCodeIdentifier* _tmp60;
			_tmp59 = NULL;
			vala_ccode_function_call_set_call (ccall, ((ValaCCodeExpression*) ((_tmp59 = vala_ccode_identifier_new ("dbus_g_proxy_call")))));
			(_tmp59 == NULL ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL)));
			_tmp60 = NULL;
			vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp60 = vala_ccode_identifier_new ("error")))));
			(_tmp60 == NULL ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL)));
		} else {
			ValaCCodeIdentifier* _tmp61;
			_tmp61 = NULL;
			vala_ccode_function_call_set_call (ccall, ((ValaCCodeExpression*) ((_tmp61 = vala_ccode_identifier_new ("dbus_g_proxy_call_no_reply")))));
			(_tmp61 == NULL ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL)));
		}
	}
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (method);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				ValaArrayType* _tmp63;
				ValaDataType* _tmp62;
				ValaArrayType* array_type;
				if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param)) || VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					/* callback parameter*/
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					break;
				}
				if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					continue;
				}
				_tmp63 = NULL;
				_tmp62 = NULL;
				array_type = (_tmp63 = (_tmp62 = vala_formal_parameter_get_parameter_type (param), (VALA_IS_ARRAY_TYPE (_tmp62) ? ((ValaArrayType*) (_tmp62)) : NULL)), (_tmp63 == NULL ? NULL : vala_code_node_ref (_tmp63)));
				if (array_type != NULL) {
					/* array parameter*/
					if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->string_type)) {
						ValaCCodeExpression* _tmp64;
						ValaCCodeIdentifier* _tmp65;
						ValaCCodeFunctionCall* _tmp66;
						ValaCCodeFunctionCall* sizeof_call;
						ValaCCodeIdentifier* _tmp68;
						char* _tmp67;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeFunctionCall* array_construct;
						ValaCCodeVariableDeclarator* _tmp80;
						char* _tmp79;
						ValaCCodeIdentifier* _tmp107;
						char* _tmp106;
						/* non-string arrays (use GArray)*/
						_tmp64 = NULL;
						vala_ccode_function_call_add_argument (ccall, (_tmp64 = vala_dbus_client_module_get_dbus_g_type (self, ((ValaDataType*) (array_type)))));
						(_tmp64 == NULL ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL)));
						_tmp65 = NULL;
						_tmp66 = NULL;
						sizeof_call = (_tmp66 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp65 = vala_ccode_identifier_new ("sizeof"))))), (_tmp65 == NULL ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL))), _tmp66);
						_tmp68 = NULL;
						_tmp67 = NULL;
						vala_ccode_function_call_add_argument (sizeof_call, ((ValaCCodeExpression*) ((_tmp68 = vala_ccode_identifier_new ((_tmp67 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type))))))));
						(_tmp68 == NULL ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL)));
						_tmp67 = (g_free (_tmp67), NULL);
						cdecl_ = NULL;
						array_construct = NULL;
						if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
							ValaCCodeDeclaration* _tmp69;
							ValaCCodeFunctionCall* _tmp71;
							ValaCCodeIdentifier* _tmp70;
							ValaCCodeIdentifier* _tmp73;
							char* _tmp72;
							_tmp69 = NULL;
							cdecl_ = (_tmp69 = vala_ccode_declaration_new ("GPtrArray*"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp69);
							_tmp71 = NULL;
							_tmp70 = NULL;
							array_construct = (_tmp71 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp70 = vala_ccode_identifier_new ("g_ptr_array_sized_new"))))), (array_construct == NULL ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL))), _tmp71);
							(_tmp70 == NULL ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL)));
							_tmp73 = NULL;
							_tmp72 = NULL;
							vala_ccode_function_call_add_argument (array_construct, ((ValaCCodeExpression*) ((_tmp73 = vala_ccode_identifier_new ((_tmp72 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_symbol_get_name (((ValaSymbol*) (param))), 1)))))));
							(_tmp73 == NULL ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL)));
							_tmp72 = (g_free (_tmp72), NULL);
						} else {
							ValaCCodeDeclaration* _tmp74;
							ValaCCodeFunctionCall* _tmp76;
							ValaCCodeIdentifier* _tmp75;
							ValaCCodeConstant* _tmp77;
							ValaCCodeConstant* _tmp78;
							_tmp74 = NULL;
							cdecl_ = (_tmp74 = vala_ccode_declaration_new ("GArray*"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp74);
							_tmp76 = NULL;
							_tmp75 = NULL;
							array_construct = (_tmp76 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp75 = vala_ccode_identifier_new ("g_array_new"))))), (array_construct == NULL ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL))), _tmp76);
							(_tmp75 == NULL ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL)));
							_tmp77 = NULL;
							vala_ccode_function_call_add_argument (array_construct, ((ValaCCodeExpression*) ((_tmp77 = vala_ccode_constant_new ("TRUE")))));
							(_tmp77 == NULL ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL)));
							_tmp78 = NULL;
							vala_ccode_function_call_add_argument (array_construct, ((ValaCCodeExpression*) ((_tmp78 = vala_ccode_constant_new ("TRUE")))));
							(_tmp78 == NULL ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL)));
							vala_ccode_function_call_add_argument (array_construct, ((ValaCCodeExpression*) (sizeof_call)));
						}
						_tmp80 = NULL;
						_tmp79 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp80 = vala_ccode_variable_declarator_new_with_initializer ((_tmp79 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (((ValaSymbol*) (param))))), ((ValaCCodeExpression*) (array_construct)))))));
						(_tmp80 == NULL ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL)));
						_tmp79 = (g_free (_tmp79), NULL);
						vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (cdecl_)));
						if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
							ValaCCodeIdentifier* _tmp81;
							ValaCCodeFunctionCall* _tmp82;
							ValaCCodeFunctionCall* memcpy_call;
							ValaCCodeMemberAccess* _tmp85;
							ValaCCodeIdentifier* _tmp84;
							char* _tmp83;
							ValaCCodeIdentifier* _tmp86;
							ValaCCodeBinaryExpression* _tmp89;
							ValaCCodeIdentifier* _tmp88;
							char* _tmp87;
							ValaCCodeExpressionStatement* _tmp90;
							ValaCCodeIdentifier* _tmp95;
							char* _tmp94;
							ValaCCodeMemberAccess* _tmp93;
							ValaCCodeIdentifier* _tmp92;
							char* _tmp91;
							ValaCCodeAssignment* _tmp96;
							ValaCCodeAssignment* len_assignment;
							ValaCCodeExpressionStatement* _tmp97;
							_tmp81 = NULL;
							_tmp82 = NULL;
							memcpy_call = (_tmp82 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp81 = vala_ccode_identifier_new ("memcpy"))))), (_tmp81 == NULL ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL))), _tmp82);
							_tmp85 = NULL;
							_tmp84 = NULL;
							_tmp83 = NULL;
							vala_ccode_function_call_add_argument (memcpy_call, ((ValaCCodeExpression*) ((_tmp85 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp84 = vala_ccode_identifier_new ((_tmp83 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (((ValaSymbol*) (param))))))))), "pdata")))));
							(_tmp85 == NULL ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL)));
							(_tmp84 == NULL ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL)));
							_tmp83 = (g_free (_tmp83), NULL);
							_tmp86 = NULL;
							vala_ccode_function_call_add_argument (memcpy_call, ((ValaCCodeExpression*) ((_tmp86 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (param))))))));
							(_tmp86 == NULL ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL)));
							_tmp89 = NULL;
							_tmp88 = NULL;
							_tmp87 = NULL;
							vala_ccode_function_call_add_argument (memcpy_call, ((ValaCCodeExpression*) ((_tmp89 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, ((ValaCCodeExpression*) ((_tmp88 = vala_ccode_identifier_new ((_tmp87 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_symbol_get_name (((ValaSymbol*) (param))), 1)))))), ((ValaCCodeExpression*) (sizeof_call)))))));
							(_tmp89 == NULL ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL)));
							(_tmp88 == NULL ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL)));
							_tmp87 = (g_free (_tmp87), NULL);
							_tmp90 = NULL;
							vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp90 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (memcpy_call)))))));
							(_tmp90 == NULL ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL)));
							_tmp95 = NULL;
							_tmp94 = NULL;
							_tmp93 = NULL;
							_tmp92 = NULL;
							_tmp91 = NULL;
							_tmp96 = NULL;
							len_assignment = (_tmp96 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp93 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp92 = vala_ccode_identifier_new ((_tmp91 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (((ValaSymbol*) (param))))))))), "len")))), ((ValaCCodeExpression*) ((_tmp95 = vala_ccode_identifier_new ((_tmp94 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_symbol_get_name (((ValaSymbol*) (param))), 1)))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp95 == NULL ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL))), (_tmp94 = (g_free (_tmp94), NULL)), (_tmp93 == NULL ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL))), (_tmp92 == NULL ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL))), (_tmp91 = (g_free (_tmp91), NULL)), _tmp96);
							_tmp97 = NULL;
							vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp97 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (len_assignment)))))));
							(_tmp97 == NULL ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL)));
							(memcpy_call == NULL ? NULL : (memcpy_call = (vala_ccode_node_unref (memcpy_call), NULL)));
							(len_assignment == NULL ? NULL : (len_assignment = (vala_ccode_node_unref (len_assignment), NULL)));
						} else {
							ValaCCodeIdentifier* _tmp98;
							ValaCCodeFunctionCall* _tmp99;
							ValaCCodeFunctionCall* cappend_call;
							ValaCCodeIdentifier* _tmp101;
							char* _tmp100;
							ValaCCodeIdentifier* _tmp102;
							ValaCCodeIdentifier* _tmp104;
							char* _tmp103;
							ValaCCodeExpressionStatement* _tmp105;
							_tmp98 = NULL;
							_tmp99 = NULL;
							cappend_call = (_tmp99 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp98 = vala_ccode_identifier_new ("g_array_append_vals"))))), (_tmp98 == NULL ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL))), _tmp99);
							_tmp101 = NULL;
							_tmp100 = NULL;
							vala_ccode_function_call_add_argument (cappend_call, ((ValaCCodeExpression*) ((_tmp101 = vala_ccode_identifier_new ((_tmp100 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (((ValaSymbol*) (param))))))))));
							(_tmp101 == NULL ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL)));
							_tmp100 = (g_free (_tmp100), NULL);
							_tmp102 = NULL;
							vala_ccode_function_call_add_argument (cappend_call, ((ValaCCodeExpression*) ((_tmp102 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (param))))))));
							(_tmp102 == NULL ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL)));
							_tmp104 = NULL;
							_tmp103 = NULL;
							vala_ccode_function_call_add_argument (cappend_call, ((ValaCCodeExpression*) ((_tmp104 = vala_ccode_identifier_new ((_tmp103 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_symbol_get_name (((ValaSymbol*) (param))), 1)))))));
							(_tmp104 == NULL ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL)));
							_tmp103 = (g_free (_tmp103), NULL);
							_tmp105 = NULL;
							vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp105 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cappend_call)))))));
							(_tmp105 == NULL ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL)));
							(cappend_call == NULL ? NULL : (cappend_call = (vala_ccode_node_unref (cappend_call), NULL)));
						}
						_tmp107 = NULL;
						_tmp106 = NULL;
						vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp107 = vala_ccode_identifier_new ((_tmp106 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (((ValaSymbol*) (param))))))))));
						(_tmp107 == NULL ? NULL : (_tmp107 = (vala_ccode_node_unref (_tmp107), NULL)));
						_tmp106 = (g_free (_tmp106), NULL);
						(sizeof_call == NULL ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
						(array_construct == NULL ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL)));
					} else {
						ValaCCodeIdentifier* _tmp108;
						ValaCCodeIdentifier* _tmp109;
						/* string arrays*/
						_tmp108 = NULL;
						vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp108 = vala_ccode_identifier_new ("G_TYPE_STRV")))));
						(_tmp108 == NULL ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL)));
						_tmp109 = NULL;
						vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp109 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (param))))))));
						(_tmp109 == NULL ? NULL : (_tmp109 = (vala_ccode_node_unref (_tmp109), NULL)));
					}
				} else {
					char* _tmp110;
					gboolean _tmp111;
					_tmp110 = NULL;
					if ((_tmp111 = g_str_has_prefix ((_tmp110 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))), "("), (_tmp110 = (g_free (_tmp110), NULL)), _tmp111)) {
						ValaStruct* _tmp112;
						ValaStruct* st;
						ValaCCodeIdentifier* _tmp113;
						ValaCCodeFunctionCall* _tmp114;
						ValaCCodeFunctionCall* array_construct;
						ValaCCodeConstant* _tmp115;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp117;
						char* _tmp116;
						ValaCCodeIdentifier* _tmp118;
						ValaCCodeFunctionCall* _tmp119;
						ValaCCodeFunctionCall* type_call;
						ValaCCodeConstant* _tmp120;
						ValaCCodeConstant* _tmp143;
						ValaCCodeIdentifier* _tmp145;
						char* _tmp144;
						/* struct parameter*/
						_tmp112 = NULL;
						st = (_tmp112 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), (_tmp112 == NULL ? NULL : vala_code_node_ref (_tmp112)));
						_tmp113 = NULL;
						_tmp114 = NULL;
						array_construct = (_tmp114 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp113 = vala_ccode_identifier_new ("g_value_array_new"))))), (_tmp113 == NULL ? NULL : (_tmp113 = (vala_ccode_node_unref (_tmp113), NULL))), _tmp114);
						_tmp115 = NULL;
						vala_ccode_function_call_add_argument (array_construct, ((ValaCCodeExpression*) ((_tmp115 = vala_ccode_constant_new ("0")))));
						(_tmp115 == NULL ? NULL : (_tmp115 = (vala_ccode_node_unref (_tmp115), NULL)));
						cdecl_ = vala_ccode_declaration_new ("GValueArray*");
						_tmp117 = NULL;
						_tmp116 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp117 = vala_ccode_variable_declarator_new_with_initializer ((_tmp116 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (((ValaSymbol*) (param))))), ((ValaCCodeExpression*) (array_construct)))))));
						(_tmp117 == NULL ? NULL : (_tmp117 = (vala_ccode_node_unref (_tmp117), NULL)));
						_tmp116 = (g_free (_tmp116), NULL);
						vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (cdecl_)));
						_tmp118 = NULL;
						_tmp119 = NULL;
						type_call = (_tmp119 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp118 = vala_ccode_identifier_new ("dbus_g_type_get_struct"))))), (_tmp118 == NULL ? NULL : (_tmp118 = (vala_ccode_node_unref (_tmp118), NULL))), _tmp119);
						_tmp120 = NULL;
						vala_ccode_function_call_add_argument (type_call, ((ValaCCodeExpression*) ((_tmp120 = vala_ccode_constant_new ("\"GValueArray\"")))));
						(_tmp120 == NULL ? NULL : (_tmp120 = (vala_ccode_node_unref (_tmp120), NULL)));
						{
							GeeList* f_collection;
							int f_it;
							f_collection = vala_struct_get_fields (st);
							for (f_it = 0; f_it < gee_collection_get_size (GEE_COLLECTION (f_collection)); f_it = f_it + 1) {
								ValaField* f;
								f = ((ValaField*) (gee_list_get (GEE_LIST (f_collection), f_it)));
								{
									char* val_name;
									ValaCCodeInitializerList* cvalinit;
									ValaCCodeConstant* _tmp121;
									ValaCCodeDeclaration* cval_decl;
									ValaCCodeVariableDeclarator* _tmp122;
									ValaCCodeIdentifier* _tmp123;
									ValaCCodeUnaryExpression* _tmp124;
									ValaCCodeUnaryExpression* val_ptr;
									ValaCCodeIdentifier* _tmp125;
									ValaCCodeFunctionCall* _tmp126;
									ValaCCodeFunctionCall* cinit_call;
									ValaCCodeIdentifier* _tmp128;
									char* _tmp127;
									ValaCCodeExpressionStatement* _tmp129;
									ValaCCodeIdentifier* _tmp131;
									char* _tmp130;
									ValaCCodeFunctionCall* _tmp132;
									ValaCCodeFunctionCall* cset_call;
									ValaCCodeMemberAccess* _tmp134;
									ValaCCodeIdentifier* _tmp133;
									ValaCCodeExpressionStatement* _tmp135;
									ValaCCodeIdentifier* _tmp136;
									ValaCCodeFunctionCall* _tmp137;
									ValaCCodeFunctionCall* cappend_call;
									ValaCCodeIdentifier* _tmp139;
									char* _tmp138;
									ValaCCodeExpressionStatement* _tmp140;
									ValaCCodeIdentifier* _tmp142;
									char* _tmp141;
									if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
										(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
										continue;
									}
									val_name = g_strdup_printf ("val_%s_%s", vala_symbol_get_name (((ValaSymbol*) (param))), vala_symbol_get_name (((ValaSymbol*) (f))));
									/* 0-initialize struct with struct initializer { 0 }*/
									cvalinit = vala_ccode_initializer_list_new ();
									_tmp121 = NULL;
									vala_ccode_initializer_list_append (cvalinit, ((ValaCCodeExpression*) ((_tmp121 = vala_ccode_constant_new ("0")))));
									(_tmp121 == NULL ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL)));
									cval_decl = vala_ccode_declaration_new ("GValue");
									_tmp122 = NULL;
									vala_ccode_declaration_add_declarator (cval_decl, ((ValaCCodeDeclarator*) ((_tmp122 = vala_ccode_variable_declarator_new_with_initializer (val_name, ((ValaCCodeExpression*) (cvalinit)))))));
									(_tmp122 == NULL ? NULL : (_tmp122 = (vala_ccode_node_unref (_tmp122), NULL)));
									vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (cval_decl)));
									_tmp123 = NULL;
									_tmp124 = NULL;
									val_ptr = (_tmp124 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp123 = vala_ccode_identifier_new (val_name))))), (_tmp123 == NULL ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL))), _tmp124);
									_tmp125 = NULL;
									_tmp126 = NULL;
									cinit_call = (_tmp126 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp125 = vala_ccode_identifier_new ("g_value_init"))))), (_tmp125 == NULL ? NULL : (_tmp125 = (vala_ccode_node_unref (_tmp125), NULL))), _tmp126);
									vala_ccode_function_call_add_argument (cinit_call, ((ValaCCodeExpression*) (val_ptr)));
									_tmp128 = NULL;
									_tmp127 = NULL;
									vala_ccode_function_call_add_argument (cinit_call, ((ValaCCodeExpression*) ((_tmp128 = vala_ccode_identifier_new ((_tmp127 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_field_get_field_type (f)))))))));
									(_tmp128 == NULL ? NULL : (_tmp128 = (vala_ccode_node_unref (_tmp128), NULL)));
									_tmp127 = (g_free (_tmp127), NULL);
									_tmp129 = NULL;
									vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp129 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cinit_call)))))));
									(_tmp129 == NULL ? NULL : (_tmp129 = (vala_ccode_node_unref (_tmp129), NULL)));
									_tmp131 = NULL;
									_tmp130 = NULL;
									_tmp132 = NULL;
									cset_call = (_tmp132 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp131 = vala_ccode_identifier_new ((_tmp130 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (vala_field_get_field_type (f))))))))), (_tmp131 == NULL ? NULL : (_tmp131 = (vala_ccode_node_unref (_tmp131), NULL))), (_tmp130 = (g_free (_tmp130), NULL)), _tmp132);
									vala_ccode_function_call_add_argument (cset_call, ((ValaCCodeExpression*) (val_ptr)));
									_tmp134 = NULL;
									_tmp133 = NULL;
									vala_ccode_function_call_add_argument (cset_call, ((ValaCCodeExpression*) ((_tmp134 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp133 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (param))))))), vala_symbol_get_name (((ValaSymbol*) (f))))))));
									(_tmp134 == NULL ? NULL : (_tmp134 = (vala_ccode_node_unref (_tmp134), NULL)));
									(_tmp133 == NULL ? NULL : (_tmp133 = (vala_ccode_node_unref (_tmp133), NULL)));
									_tmp135 = NULL;
									vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp135 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cset_call)))))));
									(_tmp135 == NULL ? NULL : (_tmp135 = (vala_ccode_node_unref (_tmp135), NULL)));
									_tmp136 = NULL;
									_tmp137 = NULL;
									cappend_call = (_tmp137 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp136 = vala_ccode_identifier_new ("g_value_array_append"))))), (_tmp136 == NULL ? NULL : (_tmp136 = (vala_ccode_node_unref (_tmp136), NULL))), _tmp137);
									_tmp139 = NULL;
									_tmp138 = NULL;
									vala_ccode_function_call_add_argument (cappend_call, ((ValaCCodeExpression*) ((_tmp139 = vala_ccode_identifier_new ((_tmp138 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (((ValaSymbol*) (param))))))))));
									(_tmp139 == NULL ? NULL : (_tmp139 = (vala_ccode_node_unref (_tmp139), NULL)));
									_tmp138 = (g_free (_tmp138), NULL);
									vala_ccode_function_call_add_argument (cappend_call, ((ValaCCodeExpression*) (val_ptr)));
									_tmp140 = NULL;
									vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp140 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cappend_call)))))));
									(_tmp140 == NULL ? NULL : (_tmp140 = (vala_ccode_node_unref (_tmp140), NULL)));
									_tmp142 = NULL;
									_tmp141 = NULL;
									vala_ccode_function_call_add_argument (type_call, ((ValaCCodeExpression*) ((_tmp142 = vala_ccode_identifier_new ((_tmp141 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_field_get_field_type (f)))))))));
									(_tmp142 == NULL ? NULL : (_tmp142 = (vala_ccode_node_unref (_tmp142), NULL)));
									_tmp141 = (g_free (_tmp141), NULL);
									(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
									val_name = (g_free (val_name), NULL);
									(cvalinit == NULL ? NULL : (cvalinit = (vala_ccode_node_unref (cvalinit), NULL)));
									(cval_decl == NULL ? NULL : (cval_decl = (vala_ccode_node_unref (cval_decl), NULL)));
									(val_ptr == NULL ? NULL : (val_ptr = (vala_ccode_node_unref (val_ptr), NULL)));
									(cinit_call == NULL ? NULL : (cinit_call = (vala_ccode_node_unref (cinit_call), NULL)));
									(cset_call == NULL ? NULL : (cset_call = (vala_ccode_node_unref (cset_call), NULL)));
									(cappend_call == NULL ? NULL : (cappend_call = (vala_ccode_node_unref (cappend_call), NULL)));
								}
							}
							(f_collection == NULL ? NULL : (f_collection = (gee_collection_object_unref (f_collection), NULL)));
						}
						_tmp143 = NULL;
						vala_ccode_function_call_add_argument (type_call, ((ValaCCodeExpression*) ((_tmp143 = vala_ccode_constant_new ("G_TYPE_INVALID")))));
						(_tmp143 == NULL ? NULL : (_tmp143 = (vala_ccode_node_unref (_tmp143), NULL)));
						vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) (type_call)));
						_tmp145 = NULL;
						_tmp144 = NULL;
						vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp145 = vala_ccode_identifier_new ((_tmp144 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (((ValaSymbol*) (param))))))))));
						(_tmp145 == NULL ? NULL : (_tmp145 = (vala_ccode_node_unref (_tmp145), NULL)));
						_tmp144 = (g_free (_tmp144), NULL);
						(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
						(array_construct == NULL ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
						(type_call == NULL ? NULL : (type_call = (vala_ccode_node_unref (type_call), NULL)));
					} else {
						ValaCCodeExpression* _tmp146;
						ValaCCodeIdentifier* _tmp147;
						_tmp146 = NULL;
						vala_ccode_function_call_add_argument (ccall, (_tmp146 = vala_dbus_client_module_get_dbus_g_type (self, vala_formal_parameter_get_parameter_type (param))));
						(_tmp146 == NULL ? NULL : (_tmp146 = (vala_ccode_node_unref (_tmp146), NULL)));
						_tmp147 = NULL;
						vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp147 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (param))))))));
						(_tmp147 == NULL ? NULL : (_tmp147 = (vala_ccode_node_unref (_tmp147), NULL)));
					}
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
				(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
	_tmp148 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp148 = vala_ccode_identifier_new ("G_TYPE_INVALID")))));
	(_tmp148 == NULL ? NULL : (_tmp148 = (vala_ccode_node_unref (_tmp148), NULL)));
	out_marshalling_fragment = vala_ccode_fragment_new ();
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (method);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				char* _tmp149;
				gboolean _tmp150;
				if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					/* callback parameter*/
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					break;
				}
				if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					continue;
				}
				_tmp149 = NULL;
				if ((_tmp150 = g_str_has_prefix ((_tmp149 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))), "("), (_tmp149 = (g_free (_tmp149), NULL)), _tmp150)) {
					ValaStruct* _tmp151;
					ValaStruct* st;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp153;
					char* _tmp152;
					ValaCCodeIdentifier* _tmp154;
					ValaCCodeFunctionCall* _tmp155;
					ValaCCodeFunctionCall* type_call;
					ValaCCodeConstant* _tmp156;
					gint i;
					ValaCCodeConstant* _tmp173;
					ValaCCodeUnaryExpression* _tmp176;
					ValaCCodeIdentifier* _tmp175;
					char* _tmp174;
					/* struct output parameter*/
					_tmp151 = NULL;
					st = (_tmp151 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), (_tmp151 == NULL ? NULL : vala_code_node_ref (_tmp151)));
					cdecl_ = vala_ccode_declaration_new ("GValueArray*");
					_tmp153 = NULL;
					_tmp152 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp153 = vala_ccode_variable_declarator_new ((_tmp152 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (((ValaSymbol*) (param))))))))));
					(_tmp153 == NULL ? NULL : (_tmp153 = (vala_ccode_node_unref (_tmp153), NULL)));
					_tmp152 = (g_free (_tmp152), NULL);
					vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (cdecl_)));
					_tmp154 = NULL;
					_tmp155 = NULL;
					type_call = (_tmp155 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp154 = vala_ccode_identifier_new ("dbus_g_type_get_struct"))))), (_tmp154 == NULL ? NULL : (_tmp154 = (vala_ccode_node_unref (_tmp154), NULL))), _tmp155);
					_tmp156 = NULL;
					vala_ccode_function_call_add_argument (type_call, ((ValaCCodeExpression*) ((_tmp156 = vala_ccode_constant_new ("\"GValueArray\"")))));
					(_tmp156 == NULL ? NULL : (_tmp156 = (vala_ccode_node_unref (_tmp156), NULL)));
					i = 0;
					{
						GeeList* f_collection;
						int f_it;
						f_collection = vala_struct_get_fields (st);
						for (f_it = 0; f_it < gee_collection_get_size (GEE_COLLECTION (f_collection)); f_it = f_it + 1) {
							ValaField* f;
							f = ((ValaField*) (gee_list_get (GEE_LIST (f_collection), f_it)));
							{
								ValaCCodeIdentifier* _tmp158;
								char* _tmp157;
								ValaCCodeFunctionCall* _tmp159;
								ValaCCodeFunctionCall* cget_call;
								ValaCCodeUnaryExpression* _tmp166;
								ValaCCodeElementAccess* _tmp165;
								ValaCCodeConstant* _tmp164;
								char* _tmp163;
								ValaCCodeMemberAccess* _tmp162;
								ValaCCodeIdentifier* _tmp161;
								char* _tmp160;
								ValaCCodeMemberAccess* _tmp168;
								ValaCCodeIdentifier* _tmp167;
								ValaCCodeAssignment* _tmp169;
								ValaCCodeAssignment* assign;
								ValaCCodeExpressionStatement* _tmp170;
								ValaCCodeIdentifier* _tmp172;
								char* _tmp171;
								if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
									(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
									continue;
								}
								_tmp158 = NULL;
								_tmp157 = NULL;
								_tmp159 = NULL;
								cget_call = (_tmp159 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp158 = vala_ccode_identifier_new ((_tmp157 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_field_get_field_type (f))))))))), (_tmp158 == NULL ? NULL : (_tmp158 = (vala_ccode_node_unref (_tmp158), NULL))), (_tmp157 = (g_free (_tmp157), NULL)), _tmp159);
								_tmp166 = NULL;
								_tmp165 = NULL;
								_tmp164 = NULL;
								_tmp163 = NULL;
								_tmp162 = NULL;
								_tmp161 = NULL;
								_tmp160 = NULL;
								vala_ccode_function_call_add_argument (cget_call, ((ValaCCodeExpression*) ((_tmp166 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp165 = vala_ccode_element_access_new (((ValaCCodeExpression*) ((_tmp162 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp161 = vala_ccode_identifier_new ((_tmp160 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (((ValaSymbol*) (param))))))))), "values")))), ((ValaCCodeExpression*) ((_tmp164 = vala_ccode_constant_new ((_tmp163 = g_strdup_printf ("%i", i)))))))))))))));
								(_tmp166 == NULL ? NULL : (_tmp166 = (vala_ccode_node_unref (_tmp166), NULL)));
								(_tmp165 == NULL ? NULL : (_tmp165 = (vala_ccode_node_unref (_tmp165), NULL)));
								(_tmp164 == NULL ? NULL : (_tmp164 = (vala_ccode_node_unref (_tmp164), NULL)));
								_tmp163 = (g_free (_tmp163), NULL);
								(_tmp162 == NULL ? NULL : (_tmp162 = (vala_ccode_node_unref (_tmp162), NULL)));
								(_tmp161 == NULL ? NULL : (_tmp161 = (vala_ccode_node_unref (_tmp161), NULL)));
								_tmp160 = (g_free (_tmp160), NULL);
								_tmp168 = NULL;
								_tmp167 = NULL;
								_tmp169 = NULL;
								assign = (_tmp169 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp168 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp167 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (param))))))), vala_symbol_get_name (((ValaSymbol*) (f))))))), ((ValaCCodeExpression*) (cget_call)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp168 == NULL ? NULL : (_tmp168 = (vala_ccode_node_unref (_tmp168), NULL))), (_tmp167 == NULL ? NULL : (_tmp167 = (vala_ccode_node_unref (_tmp167), NULL))), _tmp169);
								_tmp170 = NULL;
								vala_ccode_fragment_append (out_marshalling_fragment, ((ValaCCodeNode*) ((_tmp170 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (assign)))))));
								(_tmp170 == NULL ? NULL : (_tmp170 = (vala_ccode_node_unref (_tmp170), NULL)));
								_tmp172 = NULL;
								_tmp171 = NULL;
								vala_ccode_function_call_add_argument (type_call, ((ValaCCodeExpression*) ((_tmp172 = vala_ccode_identifier_new ((_tmp171 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_field_get_field_type (f)))))))));
								(_tmp172 == NULL ? NULL : (_tmp172 = (vala_ccode_node_unref (_tmp172), NULL)));
								_tmp171 = (g_free (_tmp171), NULL);
								i++;
								(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
								(cget_call == NULL ? NULL : (cget_call = (vala_ccode_node_unref (cget_call), NULL)));
								(assign == NULL ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)));
							}
						}
						(f_collection == NULL ? NULL : (f_collection = (gee_collection_object_unref (f_collection), NULL)));
					}
					_tmp173 = NULL;
					vala_ccode_function_call_add_argument (type_call, ((ValaCCodeExpression*) ((_tmp173 = vala_ccode_constant_new ("G_TYPE_INVALID")))));
					(_tmp173 == NULL ? NULL : (_tmp173 = (vala_ccode_node_unref (_tmp173), NULL)));
					vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) (type_call)));
					_tmp176 = NULL;
					_tmp175 = NULL;
					_tmp174 = NULL;
					vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp176 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp175 = vala_ccode_identifier_new ((_tmp174 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (((ValaSymbol*) (param))))))))))))));
					(_tmp176 == NULL ? NULL : (_tmp176 = (vala_ccode_node_unref (_tmp176), NULL)));
					(_tmp175 == NULL ? NULL : (_tmp175 = (vala_ccode_node_unref (_tmp175), NULL)));
					_tmp174 = (g_free (_tmp174), NULL);
					(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
					(type_call == NULL ? NULL : (type_call = (vala_ccode_node_unref (type_call), NULL)));
				} else {
					ValaCCodeIdentifier* _tmp178;
					char* _tmp177;
					ValaCCodeUnaryExpression* _tmp180;
					ValaCCodeIdentifier* _tmp179;
					_tmp178 = NULL;
					_tmp177 = NULL;
					vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp178 = vala_ccode_identifier_new ((_tmp177 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)))))))));
					(_tmp178 == NULL ? NULL : (_tmp178 = (vala_ccode_node_unref (_tmp178), NULL)));
					_tmp177 = (g_free (_tmp177), NULL);
					_tmp180 = NULL;
					_tmp179 = NULL;
					vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp180 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp179 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (param))))))))))));
					(_tmp180 == NULL ? NULL : (_tmp180 = (vala_ccode_node_unref (_tmp180), NULL)));
					(_tmp179 == NULL ? NULL : (_tmp179 = (vala_ccode_node_unref (_tmp179), NULL)));
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
	if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (method)))) {
		ValaArrayType* _tmp182;
		ValaDataType* _tmp181;
		ValaArrayType* array_type;
		/* synchronous D-Bus method call with reply*/
		_tmp182 = NULL;
		_tmp181 = NULL;
		array_type = (_tmp182 = (_tmp181 = vala_method_get_return_type (method), (VALA_IS_ARRAY_TYPE (_tmp181) ? ((ValaArrayType*) (_tmp181)) : NULL)), (_tmp182 == NULL ? NULL : vala_code_node_ref (_tmp182)));
		if (array_type != NULL && vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->string_type)) {
			ValaCCodeExpression* _tmp183;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp186;
			ValaCCodeUnaryExpression* _tmp188;
			ValaCCodeIdentifier* _tmp187;
			ValaCCodeIdentifier* _tmp189;
			ValaCCodeExpressionStatement* _tmp190;
			ValaCCodeBlock* creturnblock;
			ValaCCodeReturnStatement* _tmp192;
			ValaCCodeExpression* _tmp191;
			ValaCCodeUnaryExpression* _tmp194;
			ValaCCodeIdentifier* _tmp193;
			ValaCCodeIfStatement* _tmp195;
			ValaCCodeIfStatement* cerrorif;
			ValaCCodeIdentifier* _tmp196;
			ValaCCodeMemberAccess* _tmp197;
			ValaCCodeMemberAccess* garray_length;
			ValaCCodeIdentifier* _tmp198;
			ValaCCodeUnaryExpression* _tmp199;
			ValaCCodeUnaryExpression* result_length;
			ValaCCodeAssignment* assign;
			ValaCCodeExpressionStatement* _tmp200;
			ValaCCodeReturnStatement* _tmp205;
			ValaCCodeCastExpression* _tmp204;
			char* _tmp203;
			ValaCCodeMemberAccess* _tmp202;
			ValaCCodeIdentifier* _tmp201;
			/* non-string arrays (use GArray)*/
			_tmp183 = NULL;
			vala_ccode_function_call_add_argument (ccall, (_tmp183 = vala_dbus_client_module_get_dbus_g_type (self, ((ValaDataType*) (array_type)))));
			(_tmp183 == NULL ? NULL : (_tmp183 = (vala_ccode_node_unref (_tmp183), NULL)));
			cdecl_ = NULL;
			if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
				ValaCCodeDeclaration* _tmp184;
				_tmp184 = NULL;
				cdecl_ = (_tmp184 = vala_ccode_declaration_new ("GPtrArray*"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp184);
			} else {
				ValaCCodeDeclaration* _tmp185;
				_tmp185 = NULL;
				cdecl_ = (_tmp185 = vala_ccode_declaration_new ("GArray*"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp185);
			}
			_tmp186 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp186 = vala_ccode_variable_declarator_new ("result")))));
			(_tmp186 == NULL ? NULL : (_tmp186 = (vala_ccode_node_unref (_tmp186), NULL)));
			vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (cdecl_)));
			_tmp188 = NULL;
			_tmp187 = NULL;
			vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp188 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp187 = vala_ccode_identifier_new ("result")))))))));
			(_tmp188 == NULL ? NULL : (_tmp188 = (vala_ccode_node_unref (_tmp188), NULL)));
			(_tmp187 == NULL ? NULL : (_tmp187 = (vala_ccode_node_unref (_tmp187), NULL)));
			_tmp189 = NULL;
			vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp189 = vala_ccode_identifier_new ("G_TYPE_INVALID")))));
			(_tmp189 == NULL ? NULL : (_tmp189 = (vala_ccode_node_unref (_tmp189), NULL)));
			_tmp190 = NULL;
			vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp190 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (ccall)))))));
			(_tmp190 == NULL ? NULL : (_tmp190 = (vala_ccode_node_unref (_tmp190), NULL)));
			/* don't access result when error occured*/
			creturnblock = vala_ccode_block_new ();
			_tmp192 = NULL;
			_tmp191 = NULL;
			vala_ccode_block_add_statement (creturnblock, ((ValaCCodeNode*) ((_tmp192 = vala_ccode_return_statement_new ((_tmp191 = vala_ccode_base_module_default_value_for_type (((ValaCCodeBaseModule*) (self)), vala_method_get_return_type (method), FALSE)))))));
			(_tmp192 == NULL ? NULL : (_tmp192 = (vala_ccode_node_unref (_tmp192), NULL)));
			(_tmp191 == NULL ? NULL : (_tmp191 = (vala_ccode_node_unref (_tmp191), NULL)));
			_tmp194 = NULL;
			_tmp193 = NULL;
			_tmp195 = NULL;
			cerrorif = (_tmp195 = vala_ccode_if_statement_new (((ValaCCodeExpression*) ((_tmp194 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, ((ValaCCodeExpression*) ((_tmp193 = vala_ccode_identifier_new ("error")))))))), ((ValaCCodeStatement*) (creturnblock)), NULL), (_tmp194 == NULL ? NULL : (_tmp194 = (vala_ccode_node_unref (_tmp194), NULL))), (_tmp193 == NULL ? NULL : (_tmp193 = (vala_ccode_node_unref (_tmp193), NULL))), _tmp195);
			vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (cerrorif)));
			vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (out_marshalling_fragment)));
			/* *result_length1 = result->len;*/
			_tmp196 = NULL;
			_tmp197 = NULL;
			garray_length = (_tmp197 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp196 = vala_ccode_identifier_new ("result")))), "len"), (_tmp196 == NULL ? NULL : (_tmp196 = (vala_ccode_node_unref (_tmp196), NULL))), _tmp197);
			_tmp198 = NULL;
			_tmp199 = NULL;
			result_length = (_tmp199 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, ((ValaCCodeExpression*) ((_tmp198 = vala_ccode_identifier_new ("result_length1"))))), (_tmp198 == NULL ? NULL : (_tmp198 = (vala_ccode_node_unref (_tmp198), NULL))), _tmp199);
			assign = vala_ccode_assignment_new (((ValaCCodeExpression*) (result_length)), ((ValaCCodeExpression*) (garray_length)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_tmp200 = NULL;
			vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp200 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (assign)))))));
			(_tmp200 == NULL ? NULL : (_tmp200 = (vala_ccode_node_unref (_tmp200), NULL)));
			/* return result->data;*/
			_tmp205 = NULL;
			_tmp204 = NULL;
			_tmp203 = NULL;
			_tmp202 = NULL;
			_tmp201 = NULL;
			vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp205 = vala_ccode_return_statement_new (((ValaCCodeExpression*) ((_tmp204 = vala_ccode_cast_expression_new (((ValaCCodeExpression*) ((_tmp202 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp201 = vala_ccode_identifier_new ("result")))), (vala_dbus_client_module_dbus_use_ptr_array (self, array_type) ? "pdata" : "data"))))), (_tmp203 = vala_data_type_get_cname (vala_method_get_return_type (method))))))))))));
			(_tmp205 == NULL ? NULL : (_tmp205 = (vala_ccode_node_unref (_tmp205), NULL)));
			(_tmp204 == NULL ? NULL : (_tmp204 = (vala_ccode_node_unref (_tmp204), NULL)));
			_tmp203 = (g_free (_tmp203), NULL);
			(_tmp202 == NULL ? NULL : (_tmp202 = (vala_ccode_node_unref (_tmp202), NULL)));
			(_tmp201 == NULL ? NULL : (_tmp201 = (vala_ccode_node_unref (_tmp201), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
			(creturnblock == NULL ? NULL : (creturnblock = (vala_ccode_node_unref (creturnblock), NULL)));
			(cerrorif == NULL ? NULL : (cerrorif = (vala_ccode_node_unref (cerrorif), NULL)));
			(garray_length == NULL ? NULL : (garray_length = (vala_ccode_node_unref (garray_length), NULL)));
			(result_length == NULL ? NULL : (result_length = (vala_ccode_node_unref (result_length), NULL)));
			(assign == NULL ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)));
		} else {
			ValaCCodeExpression* _tmp206;
			char* _tmp207;
			ValaCCodeDeclaration* _tmp208;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp209;
			ValaCCodeUnaryExpression* _tmp211;
			ValaCCodeIdentifier* _tmp210;
			ValaCCodeIdentifier* _tmp212;
			ValaCCodeExpressionStatement* _tmp213;
			ValaCCodeBlock* creturnblock;
			ValaCCodeReturnStatement* _tmp215;
			ValaCCodeExpression* _tmp214;
			ValaCCodeUnaryExpression* _tmp217;
			ValaCCodeIdentifier* _tmp216;
			ValaCCodeIfStatement* _tmp218;
			ValaCCodeIfStatement* cerrorif;
			ValaCCodeReturnStatement* _tmp226;
			ValaCCodeIdentifier* _tmp225;
			/* string arrays or other datatypes*/
			_tmp206 = NULL;
			vala_ccode_function_call_add_argument (ccall, (_tmp206 = vala_dbus_client_module_get_dbus_g_type (self, vala_method_get_return_type (method))));
			(_tmp206 == NULL ? NULL : (_tmp206 = (vala_ccode_node_unref (_tmp206), NULL)));
			_tmp207 = NULL;
			_tmp208 = NULL;
			cdecl_ = (_tmp208 = vala_ccode_declaration_new ((_tmp207 = vala_data_type_get_cname (vala_method_get_return_type (method)))), (_tmp207 = (g_free (_tmp207), NULL)), _tmp208);
			_tmp209 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp209 = vala_ccode_variable_declarator_new ("result")))));
			(_tmp209 == NULL ? NULL : (_tmp209 = (vala_ccode_node_unref (_tmp209), NULL)));
			vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (cdecl_)));
			_tmp211 = NULL;
			_tmp210 = NULL;
			vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp211 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp210 = vala_ccode_identifier_new ("result")))))))));
			(_tmp211 == NULL ? NULL : (_tmp211 = (vala_ccode_node_unref (_tmp211), NULL)));
			(_tmp210 == NULL ? NULL : (_tmp210 = (vala_ccode_node_unref (_tmp210), NULL)));
			_tmp212 = NULL;
			vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp212 = vala_ccode_identifier_new ("G_TYPE_INVALID")))));
			(_tmp212 == NULL ? NULL : (_tmp212 = (vala_ccode_node_unref (_tmp212), NULL)));
			_tmp213 = NULL;
			vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp213 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (ccall)))))));
			(_tmp213 == NULL ? NULL : (_tmp213 = (vala_ccode_node_unref (_tmp213), NULL)));
			/* don't access result when error occured*/
			creturnblock = vala_ccode_block_new ();
			_tmp215 = NULL;
			_tmp214 = NULL;
			vala_ccode_block_add_statement (creturnblock, ((ValaCCodeNode*) ((_tmp215 = vala_ccode_return_statement_new ((_tmp214 = vala_ccode_base_module_default_value_for_type (((ValaCCodeBaseModule*) (self)), vala_method_get_return_type (method), FALSE)))))));
			(_tmp215 == NULL ? NULL : (_tmp215 = (vala_ccode_node_unref (_tmp215), NULL)));
			(_tmp214 == NULL ? NULL : (_tmp214 = (vala_ccode_node_unref (_tmp214), NULL)));
			_tmp217 = NULL;
			_tmp216 = NULL;
			_tmp218 = NULL;
			cerrorif = (_tmp218 = vala_ccode_if_statement_new (((ValaCCodeExpression*) ((_tmp217 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, ((ValaCCodeExpression*) ((_tmp216 = vala_ccode_identifier_new ("error")))))))), ((ValaCCodeStatement*) (creturnblock)), NULL), (_tmp217 == NULL ? NULL : (_tmp217 = (vala_ccode_node_unref (_tmp217), NULL))), (_tmp216 == NULL ? NULL : (_tmp216 = (vala_ccode_node_unref (_tmp216), NULL))), _tmp218);
			vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (cerrorif)));
			vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (out_marshalling_fragment)));
			if (array_type != NULL) {
				ValaCCodeIdentifier* _tmp219;
				ValaCCodeFunctionCall* _tmp220;
				ValaCCodeFunctionCall* cstrvlen;
				ValaCCodeIdentifier* _tmp221;
				ValaCCodeIdentifier* _tmp222;
				ValaCCodeUnaryExpression* _tmp223;
				ValaCCodeUnaryExpression* result_length;
				ValaCCodeAssignment* assign;
				ValaCCodeExpressionStatement* _tmp224;
				/* special case string array
				 *result_length1 = g_strv_length (result);*/
				_tmp219 = NULL;
				_tmp220 = NULL;
				cstrvlen = (_tmp220 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp219 = vala_ccode_identifier_new ("g_strv_length"))))), (_tmp219 == NULL ? NULL : (_tmp219 = (vala_ccode_node_unref (_tmp219), NULL))), _tmp220);
				_tmp221 = NULL;
				vala_ccode_function_call_add_argument (cstrvlen, ((ValaCCodeExpression*) ((_tmp221 = vala_ccode_identifier_new ("result")))));
				(_tmp221 == NULL ? NULL : (_tmp221 = (vala_ccode_node_unref (_tmp221), NULL)));
				_tmp222 = NULL;
				_tmp223 = NULL;
				result_length = (_tmp223 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, ((ValaCCodeExpression*) ((_tmp222 = vala_ccode_identifier_new ("result_length1"))))), (_tmp222 == NULL ? NULL : (_tmp222 = (vala_ccode_node_unref (_tmp222), NULL))), _tmp223);
				assign = vala_ccode_assignment_new (((ValaCCodeExpression*) (result_length)), ((ValaCCodeExpression*) (cstrvlen)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
				_tmp224 = NULL;
				vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp224 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (assign)))))));
				(_tmp224 == NULL ? NULL : (_tmp224 = (vala_ccode_node_unref (_tmp224), NULL)));
				(cstrvlen == NULL ? NULL : (cstrvlen = (vala_ccode_node_unref (cstrvlen), NULL)));
				(result_length == NULL ? NULL : (result_length = (vala_ccode_node_unref (result_length), NULL)));
				(assign == NULL ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)));
			}
			_tmp226 = NULL;
			_tmp225 = NULL;
			vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp226 = vala_ccode_return_statement_new (((ValaCCodeExpression*) ((_tmp225 = vala_ccode_identifier_new ("result")))))))));
			(_tmp226 == NULL ? NULL : (_tmp226 = (vala_ccode_node_unref (_tmp226), NULL)));
			(_tmp225 == NULL ? NULL : (_tmp225 = (vala_ccode_node_unref (_tmp225), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
			(creturnblock == NULL ? NULL : (creturnblock = (vala_ccode_node_unref (creturnblock), NULL)));
			(cerrorif == NULL ? NULL : (cerrorif = (vala_ccode_node_unref (cerrorif), NULL)));
		}
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
	} else {
		ValaCCodeExpressionStatement* _tmp227;
		ValaCCodeBlock* creturnblock;
		ValaCCodeReturnStatement* _tmp228;
		ValaCCodeUnaryExpression* _tmp230;
		ValaCCodeIdentifier* _tmp229;
		ValaCCodeIfStatement* _tmp231;
		ValaCCodeIfStatement* cerrorif;
		_tmp227 = NULL;
		vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp227 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (ccall)))))));
		(_tmp227 == NULL ? NULL : (_tmp227 = (vala_ccode_node_unref (_tmp227), NULL)));
		/* don't access result when error occured*/
		creturnblock = vala_ccode_block_new ();
		_tmp228 = NULL;
		vala_ccode_block_add_statement (creturnblock, ((ValaCCodeNode*) ((_tmp228 = vala_ccode_return_statement_new (NULL)))));
		(_tmp228 == NULL ? NULL : (_tmp228 = (vala_ccode_node_unref (_tmp228), NULL)));
		_tmp230 = NULL;
		_tmp229 = NULL;
		_tmp231 = NULL;
		cerrorif = (_tmp231 = vala_ccode_if_statement_new (((ValaCCodeExpression*) ((_tmp230 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, ((ValaCCodeExpression*) ((_tmp229 = vala_ccode_identifier_new ("error")))))))), ((ValaCCodeStatement*) (creturnblock)), NULL), (_tmp230 == NULL ? NULL : (_tmp230 = (vala_ccode_node_unref (_tmp230), NULL))), (_tmp229 == NULL ? NULL : (_tmp229 = (vala_ccode_node_unref (_tmp229), NULL))), _tmp231);
		vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (cerrorif)));
		vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (out_marshalling_fragment)));
		(creturnblock == NULL ? NULL : (creturnblock = (vala_ccode_node_unref (creturnblock), NULL)));
		(cerrorif == NULL ? NULL : (cerrorif = (vala_ccode_node_unref (cerrorif), NULL)));
	}
	(dynamic_method == NULL ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL)));
	(expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	(callback == NULL ? NULL : (callback = (vala_code_node_unref (callback), NULL)));
	(out_marshalling_fragment == NULL ? NULL : (out_marshalling_fragment = (vala_ccode_node_unref (out_marshalling_fragment), NULL)));
}


static ValaCCodeExpression* vala_dbus_client_module_get_dbus_g_type (ValaDBusClientModule* self, ValaDataType* data_type) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data_type != NULL, NULL);
	if (VALA_IS_ARRAY_TYPE (data_type)) {
		ValaArrayType* _tmp1;
		ValaDataType* _tmp0;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeFunctionCall* _tmp4;
		ValaCCodeFunctionCall* carray_type;
		ValaCCodeExpression* _tmp7;
		ValaCCodeExpression* _tmp8;
		_tmp1 = NULL;
		_tmp0 = NULL;
		array_type = (_tmp1 = (_tmp0 = data_type, (VALA_IS_ARRAY_TYPE (_tmp0) ? ((ValaArrayType*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
		if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->string_type)) {
			ValaCCodeExpression* _tmp2;
			_tmp2 = NULL;
			return (_tmp2 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ("G_TYPE_STRV"))), (array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL))), _tmp2);
		}
		_tmp3 = NULL;
		_tmp4 = NULL;
		carray_type = (_tmp4 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp3 = vala_ccode_identifier_new ("dbus_g_type_get_collection"))))), (_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL))), _tmp4);
		if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
			ValaCCodeConstant* _tmp5;
			_tmp5 = NULL;
			vala_ccode_function_call_add_argument (carray_type, ((ValaCCodeExpression*) ((_tmp5 = vala_ccode_constant_new ("\"GPtrArray\"")))));
			(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
		} else {
			ValaCCodeConstant* _tmp6;
			_tmp6 = NULL;
			vala_ccode_function_call_add_argument (carray_type, ((ValaCCodeExpression*) ((_tmp6 = vala_ccode_constant_new ("\"GArray\"")))));
			(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
		}
		_tmp7 = NULL;
		vala_ccode_function_call_add_argument (carray_type, (_tmp7 = vala_dbus_client_module_get_dbus_g_type (self, vala_array_type_get_element_type (array_type))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
		_tmp8 = NULL;
		return (_tmp8 = ((ValaCCodeExpression*) (carray_type)), (array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL))), _tmp8);
	} else {
		if (vala_data_type_get_data_type (data_type) == NULL) {
			char* _tmp9;
			_tmp9 = NULL;
			g_critical ("valadbusclientmodule.vala:464: Internal error during DBus type generation with: %s", (_tmp9 = vala_code_node_to_string (((ValaCodeNode*) (data_type)))));
			_tmp9 = (g_free (_tmp9), NULL);
			return ((ValaCCodeExpression*) (vala_ccode_identifier_new ("G_TYPE_NONE")));
		} else {
			char* _tmp11;
			gboolean _tmp12;
			_tmp11 = NULL;
			if ((_tmp12 = _vala_strcmp0 ((_tmp11 = vala_symbol_get_full_name (((ValaSymbol*) (vala_data_type_get_data_type (data_type))))), "GLib.HashTable") == 0, (_tmp11 = (g_free (_tmp11), NULL)), _tmp12)) {
				ValaCCodeIdentifier* _tmp13;
				ValaCCodeFunctionCall* _tmp14;
				ValaCCodeFunctionCall* cmap_type;
				GeeList* type_args;
				ValaCCodeConstant* _tmp15;
				ValaCCodeExpression* _tmp17;
				_tmp13 = NULL;
				_tmp14 = NULL;
				cmap_type = (_tmp14 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp13 = vala_ccode_identifier_new ("dbus_g_type_get_map"))))), (_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL))), _tmp14);
				type_args = vala_data_type_get_type_arguments (data_type);
				_tmp15 = NULL;
				vala_ccode_function_call_add_argument (cmap_type, ((ValaCCodeExpression*) ((_tmp15 = vala_ccode_constant_new ("\"GHashTable\"")))));
				(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
				{
					GeeList* type_arg_collection;
					int type_arg_it;
					type_arg_collection = type_args;
					for (type_arg_it = 0; type_arg_it < gee_collection_get_size (GEE_COLLECTION (type_arg_collection)); type_arg_it = type_arg_it + 1) {
						ValaDataType* type_arg;
						type_arg = ((ValaDataType*) (gee_list_get (GEE_LIST (type_arg_collection), type_arg_it)));
						{
							ValaCCodeExpression* _tmp16;
							_tmp16 = NULL;
							vala_ccode_function_call_add_argument (cmap_type, (_tmp16 = vala_dbus_client_module_get_dbus_g_type (self, type_arg)));
							(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
							(type_arg == NULL ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL)));
						}
					}
				}
				_tmp17 = NULL;
				return (_tmp17 = ((ValaCCodeExpression*) (cmap_type)), (type_args == NULL ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL))), _tmp17);
			} else {
				char* _tmp18;
				ValaCCodeExpression* _tmp19;
				_tmp18 = NULL;
				_tmp19 = NULL;
				return (_tmp19 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ((_tmp18 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (data_type)))))), (_tmp18 = (g_free (_tmp18), NULL)), _tmp19);
			}
		}
	}
}


gboolean vala_dbus_client_module_dbus_use_ptr_array (ValaDBusClientModule* self, ValaArrayType* array_type) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (array_type != NULL, FALSE);
	if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->string_type)) {
		/* use char***/
		return FALSE;
	} else {
		if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->bool_type) || vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->char_type) || vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->uchar_type) || vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->int_type) || vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->uint_type) || vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->long_type) || vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->ulong_type) || vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->int8_type) || vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->uint8_type) || vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->int32_type) || vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->uint32_type) || vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->int64_type) || vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->uint64_type) || vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->double_type)) {
			/* use GArray*/
			return FALSE;
		} else {
			/* use GPtrArray*/
			return TRUE;
		}
	}
}


static void vala_dbus_client_module_class_init (ValaDBusClientModuleClass * klass) {
	vala_dbus_client_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->generate_dynamic_method_wrapper = vala_dbus_client_module_real_generate_dynamic_method_wrapper;
}


static void vala_dbus_client_module_instance_init (ValaDBusClientModule * self) {
}


GType vala_dbus_client_module_get_type (void) {
	static GType vala_dbus_client_module_type_id = 0;
	if (vala_dbus_client_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDBusClientModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dbus_client_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDBusClientModule), 0, (GInstanceInitFunc) vala_dbus_client_module_instance_init, NULL };
		vala_dbus_client_module_type_id = g_type_register_static (VALA_TYPE_GASYNC_MODULE, "ValaDBusClientModule", &g_define_type_info, 0);
	}
	return vala_dbus_client_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




