/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp16_;
	ValaArrayList* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp662_ = FALSE;
	gboolean _tmp663_ = FALSE;
	gboolean _tmp664_ = FALSE;
	ValaExpression* _tmp665_;
	ValaExpression* _tmp666_;
	ValaSymbol* _tmp692_;
	ValaSymbol* _tmp693_;
	ValaSymbol* _tmp763_;
	ValaSymbol* _tmp764_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp802_;
	ValaSymbol* _tmp803_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp804_;
	ValaSymbol* _tmp805_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1192_;
	ValaSymbol* _tmp1193_;
	ValaSymbol* _tmp1195_;
	ValaVersionAttribute* _tmp1196_;
	ValaVersionAttribute* _tmp1197_;
	ValaSourceReference* _tmp1198_;
	ValaSourceReference* _tmp1199_;
	gboolean _tmp1200_ = FALSE;
	ValaSymbolAccessibility _tmp1201_;
	gboolean _tmp1257_ = FALSE;
	gboolean _tmp1284_ = FALSE;
	gboolean _tmp1285_ = FALSE;
	ValaDataType* _tmp1562_;
	ValaDataType* _tmp1563_;
	gboolean _tmp1566_;
	gboolean _tmp1567_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp16_ = g_direct_equal;
	_tmp17_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp16_);
	visited_types = _tmp17_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp18_ = self->priv->_qualified;
	if (_tmp18_) {
		ValaNamespace* _tmp19_;
		ValaNamespace* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaScope* _tmp22_;
		ValaScope* _tmp23_;
		const gchar* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		_tmp19_ = vala_code_context_get_root (context);
		_tmp20_ = _tmp19_;
		base_symbol = (ValaSymbol*) _tmp20_;
		_tmp21_ = base_symbol;
		_tmp22_ = vala_symbol_get_scope (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = self->priv->_member_name;
		_tmp25_ = vala_scope_lookup (_tmp23_, _tmp24_);
		_tmp26_ = _tmp25_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp26_);
		_vala_code_node_unref0 (_tmp26_);
	} else {
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp27_ = vala_member_access_get_inner (self);
		_tmp28_ = _tmp27_;
		if (_tmp28_ == NULL) {
			const gchar* _tmp29_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSemanticAnalyzer* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			gboolean _tmp198_ = FALSE;
			ValaSymbol* _tmp199_;
			ValaSymbol* _tmp200_;
			_tmp29_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp29_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp30_;
				ValaSemanticAnalyzer* _tmp31_;
				_tmp30_ = vala_code_context_get_analyzer (context);
				_tmp31_ = _tmp30_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp31_)) {
					ValaSourceReference* _tmp32_;
					ValaSourceReference* _tmp33_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp33_ = _tmp32_;
					vala_report_error (_tmp33_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp34_ = vala_code_context_get_analyzer (context);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_semantic_analyzer_get_current_symbol (_tmp35_);
			_tmp37_ = _tmp36_;
			base_symbol = _tmp37_;
			method_found = FALSE;
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			sym = _tmp41_;
			while (TRUE) {
				gboolean _tmp42_ = FALSE;
				ValaSymbol* _tmp43_;
				ValaSymbol* _tmp89_;
				const gchar* _tmp90_;
				ValaSymbol* _tmp91_;
				ValaSymbol* _tmp92_;
				gboolean _tmp93_ = FALSE;
				ValaSymbol* _tmp94_;
				ValaSymbol* _tmp95_;
				gboolean _tmp151_ = FALSE;
				gboolean _tmp152_ = FALSE;
				ValaSymbol* _tmp153_;
				ValaSymbol* _tmp154_;
				ValaSymbol* _tmp192_;
				ValaSymbol* _tmp193_;
				ValaSymbol* _tmp195_;
				ValaSymbol* _tmp196_;
				ValaSymbol* _tmp197_;
				_tmp43_ = sym;
				if (_tmp43_ != NULL) {
					ValaSymbol* _tmp44_;
					ValaSymbol* _tmp45_;
					_tmp44_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp45_ = _tmp44_;
					_tmp42_ = _tmp45_ == NULL;
				} else {
					_tmp42_ = FALSE;
				}
				if (!_tmp42_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp46_;
					_tmp46_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp46_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp47_;
						ValaCreationMethod* _tmp48_;
						ValaParameter* _tmp49_;
						ValaParameter* _tmp50_;
						_tmp47_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp48_ = cm;
						_tmp49_ = vala_method_get_this_parameter ((ValaMethod*) _tmp48_);
						_tmp50_ = _tmp49_;
						this_parameter = _tmp50_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp51_;
						_tmp51_ = sym;
						if (VALA_IS_PROPERTY (_tmp51_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp52_;
							ValaProperty* _tmp53_;
							ValaParameter* _tmp54_;
							ValaParameter* _tmp55_;
							ValaProperty* _tmp56_;
							ValaMemberBinding _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaProperty* _tmp59_;
							ValaMemberBinding _tmp60_;
							ValaMemberBinding _tmp61_;
							_tmp52_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp53_ = prop;
							_tmp54_ = vala_property_get_this_parameter (_tmp53_);
							_tmp55_ = _tmp54_;
							this_parameter = _tmp55_;
							_tmp56_ = prop;
							_tmp57_ = vala_property_get_binding (_tmp56_);
							_tmp58_ = _tmp57_;
							may_access_instance_members = _tmp58_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp59_ = prop;
							_tmp60_ = vala_property_get_binding (_tmp59_);
							_tmp61_ = _tmp60_;
							may_access_klass_members = _tmp61_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp62_;
							_tmp62_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp62_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp63_;
								ValaConstructor* _tmp64_;
								ValaParameter* _tmp65_;
								ValaParameter* _tmp66_;
								ValaConstructor* _tmp67_;
								ValaMemberBinding _tmp68_;
								ValaMemberBinding _tmp69_;
								_tmp63_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp64_ = c;
								_tmp65_ = vala_constructor_get_this_parameter (_tmp64_);
								_tmp66_ = _tmp65_;
								this_parameter = _tmp66_;
								_tmp67_ = c;
								_tmp68_ = vala_constructor_get_binding (_tmp67_);
								_tmp69_ = _tmp68_;
								may_access_instance_members = _tmp69_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp70_;
								_tmp70_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp70_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp71_;
									ValaDestructor* _tmp72_;
									ValaParameter* _tmp73_;
									ValaParameter* _tmp74_;
									ValaDestructor* _tmp75_;
									ValaMemberBinding _tmp76_;
									ValaMemberBinding _tmp77_;
									_tmp71_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp72_ = d;
									_tmp73_ = vala_destructor_get_this_parameter (_tmp72_);
									_tmp74_ = _tmp73_;
									this_parameter = _tmp74_;
									_tmp75_ = d;
									_tmp76_ = vala_destructor_get_binding (_tmp75_);
									_tmp77_ = _tmp76_;
									may_access_instance_members = _tmp77_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp78_;
									_tmp78_ = sym;
									if (VALA_IS_METHOD (_tmp78_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp79_;
										ValaMethod* _tmp80_;
										ValaParameter* _tmp81_;
										ValaParameter* _tmp82_;
										ValaMethod* _tmp83_;
										ValaMemberBinding _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMethod* _tmp86_;
										ValaMemberBinding _tmp87_;
										ValaMemberBinding _tmp88_;
										_tmp79_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALA_TYPE_METHOD, ValaMethod);
										_tmp80_ = m;
										_tmp81_ = vala_method_get_this_parameter (_tmp80_);
										_tmp82_ = _tmp81_;
										this_parameter = _tmp82_;
										_tmp83_ = m;
										_tmp84_ = vala_method_get_binding (_tmp83_);
										_tmp85_ = _tmp84_;
										may_access_instance_members = _tmp85_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp86_ = m;
										_tmp87_ = vala_method_get_binding (_tmp86_);
										_tmp88_ = _tmp87_;
										may_access_klass_members = _tmp88_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp89_ = sym;
				_tmp90_ = self->priv->_member_name;
				_tmp91_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp89_, _tmp90_);
				_tmp92_ = _tmp91_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp92_);
				_vala_code_node_unref0 (_tmp92_);
				_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp95_ = _tmp94_;
				if (_tmp95_ == NULL) {
					ValaSymbol* _tmp96_;
					_tmp96_ = sym;
					_tmp93_ = VALA_IS_WITH_STATEMENT (_tmp96_);
				} else {
					_tmp93_ = FALSE;
				}
				if (_tmp93_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp97_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp98_;
					ValaLocalVariable* _tmp99_;
					ValaLocalVariable* _tmp100_;
					ValaDataType* _tmp101_;
					ValaDataType* _tmp102_;
					ValaDataType* _tmp103_;
					ValaDataType* _tmp104_;
					ValaArrayList* _tmp109_;
					ValaDataType* _tmp110_;
					ValaDataType* _tmp111_;
					const gchar* _tmp112_;
					ValaSymbol* _tmp113_;
					ValaSymbol* _tmp114_;
					ValaSymbol* _tmp115_;
					ValaSymbol* _tmp116_;
					_tmp97_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp98_ = w;
					_tmp99_ = vala_with_statement_get_with_variable (_tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = vala_variable_get_variable_type ((ValaVariable*) _tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = _vala_code_node_ref0 (_tmp102_);
					variable_type = _tmp103_;
					_tmp104_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp104_)) {
						ValaDataType* _tmp105_;
						ValaDataType* _tmp106_;
						ValaDataType* _tmp107_;
						ValaDataType* _tmp108_;
						_tmp105_ = variable_type;
						_tmp106_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp105_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp107_ = _tmp106_;
						_tmp108_ = _vala_code_node_ref0 (_tmp107_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp108_;
					}
					_tmp109_ = visited_types;
					_tmp110_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp109_, _tmp110_);
					_tmp111_ = variable_type;
					_tmp112_ = self->priv->_member_name;
					_tmp113_ = vala_data_type_get_member (_tmp111_, _tmp112_);
					_tmp114_ = _tmp113_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp114_);
					_vala_code_node_unref0 (_tmp114_);
					_tmp115_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp116_ = _tmp115_;
					if (_tmp116_ != NULL) {
						ValaWithStatement* _tmp117_;
						ValaLocalVariable* _tmp118_;
						ValaLocalVariable* _tmp119_;
						const gchar* _tmp120_;
						const gchar* _tmp121_;
						ValaSourceReference* _tmp122_;
						ValaSourceReference* _tmp123_;
						ValaMemberAccess* _tmp124_;
						ValaMemberAccess* _tmp125_;
						ValaWithStatement* _tmp126_;
						ValaLocalVariable* _tmp127_;
						ValaLocalVariable* _tmp128_;
						ValaSymbol* _tmp129_;
						ValaSymbol* _tmp130_;
						ValaWithStatement* _tmp131_;
						ValaBlock* _tmp132_;
						ValaBlock* _tmp133_;
						_tmp117_ = w;
						_tmp118_ = vala_with_statement_get_with_variable (_tmp117_);
						_tmp119_ = _tmp118_;
						_tmp120_ = vala_symbol_get_name ((ValaSymbol*) _tmp119_);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp123_ = _tmp122_;
						_tmp124_ = vala_member_access_new (NULL, _tmp121_, _tmp123_);
						_tmp125_ = _tmp124_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp125_);
						_vala_code_node_unref0 (_tmp125_);
						_tmp126_ = w;
						_tmp127_ = vala_with_statement_get_with_variable (_tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp128_);
						_tmp130_ = _tmp129_;
						_tmp131_ = w;
						_tmp132_ = vala_with_statement_get_body (_tmp131_);
						_tmp133_ = _tmp132_;
						if (_tmp130_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp133_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							ValaExpression* _tmp134_;
							ValaExpression* _tmp135_;
							_tmp134_ = vala_member_access_get_inner (self);
							_tmp135_ = _tmp134_;
							vala_code_node_check ((ValaCodeNode*) _tmp135_, context);
						} else {
							ValaSymbol* old_symbol = NULL;
							ValaSemanticAnalyzer* _tmp136_;
							ValaSemanticAnalyzer* _tmp137_;
							ValaSymbol* _tmp138_;
							ValaSymbol* _tmp139_;
							ValaSymbol* _tmp140_;
							ValaSemanticAnalyzer* _tmp141_;
							ValaSemanticAnalyzer* _tmp142_;
							ValaWithStatement* _tmp143_;
							ValaSymbol* _tmp144_;
							ValaSymbol* _tmp145_;
							ValaExpression* _tmp146_;
							ValaExpression* _tmp147_;
							ValaSemanticAnalyzer* _tmp148_;
							ValaSemanticAnalyzer* _tmp149_;
							ValaSymbol* _tmp150_;
							_tmp136_ = vala_code_context_get_analyzer (context);
							_tmp137_ = _tmp136_;
							_tmp138_ = vala_semantic_analyzer_get_current_symbol (_tmp137_);
							_tmp139_ = _tmp138_;
							_tmp140_ = _vala_code_node_ref0 (_tmp139_);
							old_symbol = _tmp140_;
							_tmp141_ = vala_code_context_get_analyzer (context);
							_tmp142_ = _tmp141_;
							_tmp143_ = w;
							_tmp144_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp143_);
							_tmp145_ = _tmp144_;
							vala_semantic_analyzer_set_current_symbol (_tmp142_, _tmp145_);
							_tmp146_ = vala_member_access_get_inner (self);
							_tmp147_ = _tmp146_;
							vala_code_node_check ((ValaCodeNode*) _tmp147_, context);
							_tmp148_ = vala_code_context_get_analyzer (context);
							_tmp149_ = _tmp148_;
							_tmp150_ = old_symbol;
							vala_semantic_analyzer_set_current_symbol (_tmp149_, _tmp150_);
							_vala_code_node_unref0 (old_symbol);
						}
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp153_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp154_ = _tmp153_;
				if (_tmp154_ == NULL) {
					ValaSymbol* _tmp155_;
					_tmp155_ = sym;
					_tmp152_ = VALA_IS_TYPESYMBOL (_tmp155_);
				} else {
					_tmp152_ = FALSE;
				}
				if (_tmp152_) {
					_tmp151_ = may_access_instance_members;
				} else {
					_tmp151_ = FALSE;
				}
				if (_tmp151_) {
					ValaParameter* _tmp156_;
					ValaDataType* _tmp157_;
					ValaDataType* _tmp158_;
					const gchar* _tmp159_;
					ValaSymbol* _tmp160_;
					ValaSymbol* _tmp161_;
					gboolean _tmp162_ = FALSE;
					ValaSymbol* _tmp163_;
					ValaSymbol* _tmp164_;
					_tmp156_ = this_parameter;
					_tmp157_ = vala_variable_get_variable_type ((ValaVariable*) _tmp156_);
					_tmp158_ = _tmp157_;
					_tmp159_ = self->priv->_member_name;
					_tmp160_ = vala_data_type_get_member (_tmp158_, _tmp159_);
					_tmp161_ = _tmp160_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp161_);
					_vala_code_node_unref0 (_tmp161_);
					_tmp163_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp164_ = _tmp163_;
					if (_tmp164_ != NULL) {
						ValaSymbol* _tmp165_;
						ValaSymbol* _tmp166_;
						_tmp165_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp166_ = _tmp165_;
						_tmp162_ = vala_member_access_is_instance_symbol (_tmp166_);
					} else {
						_tmp162_ = FALSE;
					}
					if (_tmp162_) {
						ValaSourceReference* _tmp167_;
						ValaSourceReference* _tmp168_;
						ValaMemberAccess* _tmp169_;
						ValaMemberAccess* _tmp170_;
						ValaExpression* _tmp171_;
						ValaExpression* _tmp172_;
						ValaParameter* _tmp173_;
						ValaDataType* _tmp174_;
						ValaDataType* _tmp175_;
						ValaDataType* _tmp176_;
						ValaDataType* _tmp177_;
						ValaExpression* _tmp178_;
						ValaExpression* _tmp179_;
						ValaDataType* _tmp180_;
						ValaDataType* _tmp181_;
						ValaExpression* _tmp182_;
						ValaExpression* _tmp183_;
						ValaParameter* _tmp184_;
						ValaExpression* _tmp185_;
						ValaExpression* _tmp186_;
						ValaDataType* _tmp187_;
						ValaDataType* _tmp188_;
						const gchar* _tmp189_;
						ValaSymbol* _tmp190_;
						ValaSymbol* _tmp191_;
						_tmp167_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp168_ = _tmp167_;
						_tmp169_ = vala_member_access_new (NULL, "this", _tmp168_);
						_tmp170_ = _tmp169_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp170_);
						_vala_code_node_unref0 (_tmp170_);
						_tmp171_ = vala_member_access_get_inner (self);
						_tmp172_ = _tmp171_;
						_tmp173_ = this_parameter;
						_tmp174_ = vala_variable_get_variable_type ((ValaVariable*) _tmp173_);
						_tmp175_ = _tmp174_;
						_tmp176_ = vala_data_type_copy (_tmp175_);
						_tmp177_ = _tmp176_;
						vala_expression_set_value_type (_tmp172_, _tmp177_);
						_vala_code_node_unref0 (_tmp177_);
						_tmp178_ = vala_member_access_get_inner (self);
						_tmp179_ = _tmp178_;
						_tmp180_ = vala_expression_get_value_type (_tmp179_);
						_tmp181_ = _tmp180_;
						vala_data_type_set_value_owned (_tmp181_, FALSE);
						_tmp182_ = vala_member_access_get_inner (self);
						_tmp183_ = _tmp182_;
						_tmp184_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp183_, (ValaSymbol*) _tmp184_);
						_tmp185_ = vala_member_access_get_inner (self);
						_tmp186_ = _tmp185_;
						_tmp187_ = vala_expression_get_value_type (_tmp186_);
						_tmp188_ = _tmp187_;
						_tmp189_ = self->priv->_member_name;
						_tmp190_ = vala_data_type_get_member (_tmp188_, _tmp189_);
						_tmp191_ = _tmp190_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp191_);
						_vala_code_node_unref0 (_tmp191_);
					}
				}
				_tmp192_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp193_ = _tmp192_;
				if (_tmp193_ == NULL) {
					ValaSymbol* _tmp194_;
					_tmp194_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp194_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp195_ = sym;
				_tmp196_ = vala_symbol_get_parent_symbol (_tmp195_);
				_tmp197_ = _tmp196_;
				sym = _tmp197_;
			}
			_tmp199_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp200_ = _tmp199_;
			if (_tmp200_ == NULL) {
				ValaSourceReference* _tmp201_;
				ValaSourceReference* _tmp202_;
				_tmp201_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp202_ = _tmp201_;
				_tmp198_ = _tmp202_ != NULL;
			} else {
				_tmp198_ = FALSE;
			}
			if (_tmp198_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp203_;
					ValaSourceReference* _tmp204_;
					ValaList* _tmp205_;
					ValaList* _tmp206_;
					ValaList* _tmp207_;
					gint _ns_size = 0;
					ValaList* _tmp208_;
					gint _tmp209_;
					gint _tmp210_;
					gint _ns_index = 0;
					_tmp203_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp204_ = _tmp203_;
					_tmp205_ = vala_source_reference_get_using_directives (_tmp204_);
					_tmp206_ = _tmp205_;
					_tmp207_ = _vala_iterable_ref0 (_tmp206_);
					_ns_list = _tmp207_;
					_tmp208_ = _ns_list;
					_tmp209_ = vala_collection_get_size ((ValaCollection*) _tmp208_);
					_tmp210_ = _tmp209_;
					_ns_size = _tmp210_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp211_;
						gpointer _tmp212_;
						ValaUsingDirective* _tmp213_;
						gboolean _tmp214_;
						gboolean _tmp215_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp216_;
						ValaSymbol* _tmp217_;
						ValaSymbol* _tmp218_;
						ValaScope* _tmp219_;
						ValaScope* _tmp220_;
						const gchar* _tmp221_;
						ValaSymbol* _tmp222_;
						ValaSymbol* _tmp223_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp211_ = _ns_list;
						_tmp212_ = vala_list_get (_tmp211_, _ns_index);
						ns = (ValaUsingDirective*) _tmp212_;
						_tmp213_ = ns;
						_tmp214_ = vala_code_node_get_error ((ValaCodeNode*) _tmp213_);
						_tmp215_ = _tmp214_;
						if (_tmp215_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp216_ = ns;
						_tmp217_ = vala_using_directive_get_namespace_symbol (_tmp216_);
						_tmp218_ = _tmp217_;
						_tmp219_ = vala_symbol_get_scope (_tmp218_);
						_tmp220_ = _tmp219_;
						_tmp221_ = self->priv->_member_name;
						_tmp222_ = vala_scope_lookup (_tmp220_, _tmp221_);
						local_sym = _tmp222_;
						_tmp223_ = local_sym;
						if (_tmp223_ != NULL) {
							gboolean _tmp224_ = FALSE;
							ValaSymbol* _tmp225_;
							ValaSymbol* _tmp226_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp242_;
							ValaSymbol* _tmp243_;
							ValaSymbol* _tmp244_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp264_;
							ValaExpression* _tmp265_;
							ValaExpression* _tmp266_;
							ValaSymbol* _tmp267_;
							_tmp225_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp226_ = _tmp225_;
							if (_tmp226_ != NULL) {
								ValaSymbol* _tmp227_;
								ValaSymbol* _tmp228_;
								ValaSymbol* _tmp229_;
								_tmp227_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp228_ = _tmp227_;
								_tmp229_ = local_sym;
								_tmp224_ = _tmp228_ != _tmp229_;
							} else {
								_tmp224_ = FALSE;
							}
							if (_tmp224_) {
								ValaSourceReference* _tmp230_;
								ValaSourceReference* _tmp231_;
								const gchar* _tmp232_;
								ValaSymbol* _tmp233_;
								ValaSymbol* _tmp234_;
								gchar* _tmp235_;
								gchar* _tmp236_;
								ValaSymbol* _tmp237_;
								gchar* _tmp238_;
								gchar* _tmp239_;
								gchar* _tmp240_;
								gchar* _tmp241_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp230_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp231_ = _tmp230_;
								_tmp232_ = self->priv->_member_name;
								_tmp233_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp234_ = _tmp233_;
								_tmp235_ = vala_symbol_get_full_name (_tmp234_);
								_tmp236_ = _tmp235_;
								_tmp237_ = local_sym;
								_tmp238_ = vala_symbol_get_full_name (_tmp237_);
								_tmp239_ = _tmp238_;
								_tmp240_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp232_, _tmp236_, _tmp239_);
								_tmp241_ = _tmp240_;
								vala_report_error (_tmp231_, _tmp241_);
								_g_free0 (_tmp241_);
								_g_free0 (_tmp239_);
								_g_free0 (_tmp236_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp242_ = local_sym;
							_tmp243_ = vala_symbol_get_parent_symbol (_tmp242_);
							_tmp244_ = _tmp243_;
							inner_sym = _tmp244_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp245_ = FALSE;
								ValaSymbol* _tmp246_;
								ValaMemberAccess* _tmp250_;
								ValaSymbol* _tmp251_;
								const gchar* _tmp252_;
								const gchar* _tmp253_;
								ValaSourceReference* _tmp254_;
								ValaSourceReference* _tmp255_;
								ValaMemberAccess* _tmp256_;
								ValaMemberAccess* _tmp257_;
								ValaMemberAccess* _tmp258_;
								ValaExpression* _tmp259_;
								ValaExpression* _tmp260_;
								ValaSymbol* _tmp261_;
								ValaSymbol* _tmp262_;
								ValaSymbol* _tmp263_;
								_tmp246_ = inner_sym;
								if (_tmp246_ != NULL) {
									ValaSymbol* _tmp247_;
									const gchar* _tmp248_;
									const gchar* _tmp249_;
									_tmp247_ = inner_sym;
									_tmp248_ = vala_symbol_get_name (_tmp247_);
									_tmp249_ = _tmp248_;
									_tmp245_ = _tmp249_ != NULL;
								} else {
									_tmp245_ = FALSE;
								}
								if (!_tmp245_) {
									break;
								}
								_tmp250_ = inner_ma;
								_tmp251_ = inner_sym;
								_tmp252_ = vala_symbol_get_name (_tmp251_);
								_tmp253_ = _tmp252_;
								_tmp254_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp255_ = _tmp254_;
								_tmp256_ = vala_member_access_new (NULL, _tmp253_, _tmp255_);
								_tmp257_ = _tmp256_;
								vala_member_access_set_inner (_tmp250_, (ValaExpression*) _tmp257_);
								_vala_code_node_unref0 (_tmp257_);
								_tmp258_ = inner_ma;
								_tmp259_ = vala_member_access_get_inner (_tmp258_);
								_tmp260_ = _tmp259_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp260_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp261_ = inner_sym;
								_tmp262_ = vala_symbol_get_parent_symbol (_tmp261_);
								_tmp263_ = _tmp262_;
								inner_sym = _tmp263_;
							}
							_tmp264_ = inner_ma;
							vala_member_access_set_qualified (_tmp264_, TRUE);
							_tmp265_ = vala_member_access_get_inner (self);
							_tmp266_ = _tmp265_;
							vala_code_node_check ((ValaCodeNode*) _tmp266_, context);
							_tmp267_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp267_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
		} else {
			ValaExpression* _tmp268_;
			ValaExpression* _tmp269_;
			gboolean _tmp270_;
			gboolean _tmp271_;
			ValaExpression* _tmp272_;
			ValaExpression* _tmp273_;
			ValaDataType* _tmp274_;
			ValaDataType* _tmp275_;
			ValaExpression* _tmp293_;
			ValaExpression* _tmp294_;
			gboolean _tmp309_ = FALSE;
			ValaExpression* _tmp310_;
			ValaExpression* _tmp311_;
			gboolean _tmp318_ = FALSE;
			ValaExpression* _tmp319_;
			ValaExpression* _tmp320_;
			gboolean _tmp341_ = FALSE;
			ValaExpression* _tmp342_;
			ValaExpression* _tmp343_;
			gboolean _tmp362_ = FALSE;
			ValaSymbol* _tmp363_;
			ValaSymbol* _tmp364_;
			gboolean _tmp398_ = FALSE;
			gboolean _tmp399_ = FALSE;
			ValaSymbol* _tmp400_;
			ValaSymbol* _tmp401_;
			gboolean _tmp633_ = FALSE;
			ValaSymbol* _tmp634_;
			ValaSymbol* _tmp635_;
			_tmp268_ = vala_member_access_get_inner (self);
			_tmp269_ = _tmp268_;
			_tmp270_ = vala_code_node_get_error ((ValaCodeNode*) _tmp269_);
			_tmp271_ = _tmp270_;
			if (_tmp271_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp272_ = vala_member_access_get_inner (self);
			_tmp273_ = _tmp272_;
			_tmp274_ = vala_expression_get_value_type (_tmp273_);
			_tmp275_ = _tmp274_;
			if (VALA_IS_POINTER_TYPE (_tmp275_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp276_;
				ValaExpression* _tmp277_;
				ValaDataType* _tmp278_;
				ValaDataType* _tmp279_;
				gboolean _tmp280_ = FALSE;
				ValaPointerType* _tmp281_;
				_tmp276_ = vala_member_access_get_inner (self);
				_tmp277_ = _tmp276_;
				_tmp278_ = vala_expression_get_value_type (_tmp277_);
				_tmp279_ = _tmp278_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp279_) ? ((ValaPointerType*) _tmp279_) : NULL;
				_tmp281_ = pointer_type;
				if (_tmp281_ != NULL) {
					ValaPointerType* _tmp282_;
					ValaDataType* _tmp283_;
					ValaDataType* _tmp284_;
					_tmp282_ = pointer_type;
					_tmp283_ = vala_pointer_type_get_base_type (_tmp282_);
					_tmp284_ = _tmp283_;
					_tmp280_ = VALA_IS_VALUE_TYPE (_tmp284_);
				} else {
					_tmp280_ = FALSE;
				}
				if (_tmp280_) {
					ValaExpression* _tmp285_;
					ValaExpression* _tmp286_;
					ValaSourceReference* _tmp287_;
					ValaSourceReference* _tmp288_;
					ValaPointerIndirection* _tmp289_;
					ValaPointerIndirection* _tmp290_;
					ValaExpression* _tmp291_;
					ValaExpression* _tmp292_;
					_tmp285_ = vala_member_access_get_inner (self);
					_tmp286_ = _tmp285_;
					_tmp287_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp288_ = _tmp287_;
					_tmp289_ = vala_pointer_indirection_new (_tmp286_, _tmp288_);
					_tmp290_ = _tmp289_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp290_);
					_vala_code_node_unref0 (_tmp290_);
					_tmp291_ = vala_member_access_get_inner (self);
					_tmp292_ = _tmp291_;
					vala_code_node_check ((ValaCodeNode*) _tmp292_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp293_ = vala_member_access_get_inner (self);
			_tmp294_ = _tmp293_;
			if (VALA_IS_MEMBER_ACCESS (_tmp294_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp295_;
				ValaExpression* _tmp296_;
				ValaMemberAccess* _tmp297_;
				gboolean _tmp298_;
				_tmp295_ = vala_member_access_get_inner (self);
				_tmp296_ = _tmp295_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp296_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp297_ = ma;
				_tmp298_ = _tmp297_->priv->_prototype_access;
				if (_tmp298_) {
					ValaSourceReference* _tmp299_;
					ValaSourceReference* _tmp300_;
					ValaExpression* _tmp301_;
					ValaExpression* _tmp302_;
					ValaSymbol* _tmp303_;
					ValaSymbol* _tmp304_;
					gchar* _tmp305_;
					gchar* _tmp306_;
					gchar* _tmp307_;
					gchar* _tmp308_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp299_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp300_ = _tmp299_;
					_tmp301_ = vala_member_access_get_inner (self);
					_tmp302_ = _tmp301_;
					_tmp303_ = vala_expression_get_symbol_reference (_tmp302_);
					_tmp304_ = _tmp303_;
					_tmp305_ = vala_symbol_get_full_name (_tmp304_);
					_tmp306_ = _tmp305_;
					_tmp307_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp306_);
					_tmp308_ = _tmp307_;
					vala_report_error (_tmp300_, _tmp308_);
					_g_free0 (_tmp308_);
					_g_free0 (_tmp306_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp310_ = vala_member_access_get_inner (self);
			_tmp311_ = _tmp310_;
			if (VALA_IS_CAST_EXPRESSION (_tmp311_)) {
				ValaExpression* _tmp312_;
				ValaExpression* _tmp313_;
				gboolean _tmp314_;
				gboolean _tmp315_;
				_tmp312_ = vala_member_access_get_inner (self);
				_tmp313_ = _tmp312_;
				_tmp314_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp313_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp315_ = _tmp314_;
				_tmp309_ = _tmp315_;
			} else {
				_tmp309_ = FALSE;
			}
			if (_tmp309_) {
				ValaSourceReference* _tmp316_;
				ValaSourceReference* _tmp317_;
				_tmp316_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp317_ = _tmp316_;
				vala_report_warning (_tmp317_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp319_ = vala_member_access_get_inner (self);
			_tmp320_ = _tmp319_;
			if (VALA_IS_MEMBER_ACCESS (_tmp320_)) {
				_tmp318_ = TRUE;
			} else {
				ValaExpression* _tmp321_;
				ValaExpression* _tmp322_;
				_tmp321_ = vala_member_access_get_inner (self);
				_tmp322_ = _tmp321_;
				_tmp318_ = VALA_IS_BASE_ACCESS (_tmp322_);
			}
			if (_tmp318_) {
				ValaExpression* _tmp323_;
				ValaExpression* _tmp324_;
				ValaSymbol* _tmp325_;
				ValaSymbol* _tmp326_;
				gboolean _tmp327_ = FALSE;
				ValaSymbol* _tmp328_;
				ValaSymbol* _tmp329_;
				_tmp323_ = vala_member_access_get_inner (self);
				_tmp324_ = _tmp323_;
				_tmp325_ = vala_expression_get_symbol_reference (_tmp324_);
				_tmp326_ = _tmp325_;
				base_symbol = _tmp326_;
				_tmp328_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp329_ = _tmp328_;
				if (_tmp329_ == NULL) {
					gboolean _tmp330_ = FALSE;
					ValaSymbol* _tmp331_;
					_tmp331_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp331_)) {
						_tmp330_ = TRUE;
					} else {
						ValaSymbol* _tmp332_;
						_tmp332_ = base_symbol;
						_tmp330_ = VALA_IS_TYPESYMBOL (_tmp332_);
					}
					_tmp327_ = _tmp330_;
				} else {
					_tmp327_ = FALSE;
				}
				if (_tmp327_) {
					ValaSymbol* _tmp333_;
					ValaScope* _tmp334_;
					ValaScope* _tmp335_;
					const gchar* _tmp336_;
					ValaSymbol* _tmp337_;
					ValaSymbol* _tmp338_;
					ValaExpression* _tmp339_;
					ValaExpression* _tmp340_;
					_tmp333_ = base_symbol;
					_tmp334_ = vala_symbol_get_scope (_tmp333_);
					_tmp335_ = _tmp334_;
					_tmp336_ = self->priv->_member_name;
					_tmp337_ = vala_scope_lookup (_tmp335_, _tmp336_);
					_tmp338_ = _tmp337_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp338_);
					_vala_code_node_unref0 (_tmp338_);
					_tmp339_ = vala_member_access_get_inner (self);
					_tmp340_ = _tmp339_;
					if (VALA_IS_BASE_ACCESS (_tmp340_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp342_ = vala_member_access_get_inner (self);
			_tmp343_ = _tmp342_;
			if (VALA_IS_MEMBER_ACCESS (_tmp343_)) {
				ValaExpression* _tmp344_;
				ValaExpression* _tmp345_;
				ValaSymbol* _tmp346_;
				ValaSymbol* _tmp347_;
				_tmp344_ = vala_member_access_get_inner (self);
				_tmp345_ = _tmp344_;
				_tmp346_ = vala_expression_get_symbol_reference (_tmp345_);
				_tmp347_ = _tmp346_;
				_tmp341_ = VALA_IS_TYPEPARAMETER (_tmp347_);
			} else {
				_tmp341_ = FALSE;
			}
			if (_tmp341_) {
				ValaExpression* _tmp348_;
				ValaExpression* _tmp349_;
				ValaExpression* _tmp350_;
				ValaExpression* _tmp351_;
				ValaSymbol* _tmp352_;
				ValaSymbol* _tmp353_;
				ValaGenericType* _tmp354_;
				ValaGenericType* _tmp355_;
				ValaExpression* _tmp356_;
				ValaExpression* _tmp357_;
				ValaDataType* _tmp358_;
				ValaDataType* _tmp359_;
				ValaSourceReference* _tmp360_;
				ValaSourceReference* _tmp361_;
				_tmp348_ = vala_member_access_get_inner (self);
				_tmp349_ = _tmp348_;
				_tmp350_ = vala_member_access_get_inner (self);
				_tmp351_ = _tmp350_;
				_tmp352_ = vala_expression_get_symbol_reference (_tmp351_);
				_tmp353_ = _tmp352_;
				_tmp354_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp353_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp355_ = _tmp354_;
				vala_expression_set_value_type (_tmp349_, (ValaDataType*) _tmp355_);
				_vala_code_node_unref0 (_tmp355_);
				_tmp356_ = vala_member_access_get_inner (self);
				_tmp357_ = _tmp356_;
				_tmp358_ = vala_expression_get_value_type (_tmp357_);
				_tmp359_ = _tmp358_;
				_tmp360_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp361_ = _tmp360_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp359_, _tmp361_);
			}
			_tmp363_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp364_ = _tmp363_;
			if (_tmp364_ == NULL) {
				ValaExpression* _tmp365_;
				ValaExpression* _tmp366_;
				ValaDataType* _tmp367_;
				ValaDataType* _tmp368_;
				_tmp365_ = vala_member_access_get_inner (self);
				_tmp366_ = _tmp365_;
				_tmp367_ = vala_expression_get_value_type (_tmp366_);
				_tmp368_ = _tmp367_;
				_tmp362_ = _tmp368_ != NULL;
			} else {
				_tmp362_ = FALSE;
			}
			if (_tmp362_) {
				gboolean _tmp369_;
				ValaSymbol* _tmp396_;
				ValaSymbol* _tmp397_;
				_tmp369_ = self->priv->_pointer_member_access;
				if (_tmp369_) {
					ValaExpression* _tmp370_;
					ValaExpression* _tmp371_;
					ValaDataType* _tmp372_;
					ValaDataType* _tmp373_;
					const gchar* _tmp374_;
					ValaSymbol* _tmp375_;
					ValaSymbol* _tmp376_;
					_tmp370_ = vala_member_access_get_inner (self);
					_tmp371_ = _tmp370_;
					_tmp372_ = vala_expression_get_value_type (_tmp371_);
					_tmp373_ = _tmp372_;
					_tmp374_ = self->priv->_member_name;
					_tmp375_ = vala_data_type_get_pointer_member (_tmp373_, _tmp374_);
					_tmp376_ = _tmp375_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp376_);
					_vala_code_node_unref0 (_tmp376_);
				} else {
					ValaExpression* _tmp377_;
					ValaExpression* _tmp378_;
					ValaDataType* _tmp379_;
					ValaDataType* _tmp380_;
					ValaTypeSymbol* _tmp381_;
					ValaTypeSymbol* _tmp382_;
					ValaExpression* _tmp389_;
					ValaExpression* _tmp390_;
					ValaDataType* _tmp391_;
					ValaDataType* _tmp392_;
					const gchar* _tmp393_;
					ValaSymbol* _tmp394_;
					ValaSymbol* _tmp395_;
					_tmp377_ = vala_member_access_get_inner (self);
					_tmp378_ = _tmp377_;
					_tmp379_ = vala_expression_get_value_type (_tmp378_);
					_tmp380_ = _tmp379_;
					_tmp381_ = vala_data_type_get_type_symbol (_tmp380_);
					_tmp382_ = _tmp381_;
					if (_tmp382_ != NULL) {
						ValaExpression* _tmp383_;
						ValaExpression* _tmp384_;
						ValaDataType* _tmp385_;
						ValaDataType* _tmp386_;
						ValaTypeSymbol* _tmp387_;
						ValaTypeSymbol* _tmp388_;
						_tmp383_ = vala_member_access_get_inner (self);
						_tmp384_ = _tmp383_;
						_tmp385_ = vala_expression_get_value_type (_tmp384_);
						_tmp386_ = _tmp385_;
						_tmp387_ = vala_data_type_get_type_symbol (_tmp386_);
						_tmp388_ = _tmp387_;
						base_symbol = (ValaSymbol*) _tmp388_;
					}
					_tmp389_ = vala_member_access_get_inner (self);
					_tmp390_ = _tmp389_;
					_tmp391_ = vala_expression_get_value_type (_tmp390_);
					_tmp392_ = _tmp391_;
					_tmp393_ = self->priv->_member_name;
					_tmp394_ = vala_data_type_get_member (_tmp392_, _tmp393_);
					_tmp395_ = _tmp394_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp395_);
					_vala_code_node_unref0 (_tmp395_);
				}
				_tmp396_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp397_ = _tmp396_;
				if (_tmp397_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp400_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp401_ = _tmp400_;
			if (_tmp401_ == NULL) {
				ValaExpression* _tmp402_;
				ValaExpression* _tmp403_;
				ValaDataType* _tmp404_;
				ValaDataType* _tmp405_;
				_tmp402_ = vala_member_access_get_inner (self);
				_tmp403_ = _tmp402_;
				_tmp404_ = vala_expression_get_value_type (_tmp403_);
				_tmp405_ = _tmp404_;
				_tmp399_ = _tmp405_ != NULL;
			} else {
				_tmp399_ = FALSE;
			}
			if (_tmp399_) {
				ValaExpression* _tmp406_;
				ValaExpression* _tmp407_;
				ValaDataType* _tmp408_;
				ValaDataType* _tmp409_;
				gboolean _tmp410_;
				gboolean _tmp411_;
				_tmp406_ = vala_member_access_get_inner (self);
				_tmp407_ = _tmp406_;
				_tmp408_ = vala_expression_get_value_type (_tmp407_);
				_tmp409_ = _tmp408_;
				_tmp410_ = vala_data_type_get_is_dynamic (_tmp409_);
				_tmp411_ = _tmp410_;
				_tmp398_ = _tmp411_;
			} else {
				_tmp398_ = FALSE;
			}
			if (_tmp398_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp412_;
				ValaExpression* _tmp413_;
				ValaDataType* _tmp414_;
				ValaDataType* _tmp415_;
				ValaObjectType* _tmp416_;
				ValaCodeNode* _tmp417_;
				ValaCodeNode* _tmp418_;
				ValaSymbol* _tmp581_;
				ValaSymbol* _tmp582_;
				ValaSymbol* _tmp631_;
				ValaSymbol* _tmp632_;
				_tmp412_ = vala_member_access_get_inner (self);
				_tmp413_ = _tmp412_;
				_tmp414_ = vala_expression_get_value_type (_tmp413_);
				_tmp415_ = _tmp414_;
				_tmp416_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp415_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp416_;
				_tmp417_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp418_ = _tmp417_;
				if (VALA_IS_METHOD_CALL (_tmp418_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp419_;
					ValaCodeNode* _tmp420_;
					ValaMethodCall* _tmp421_;
					ValaExpression* _tmp422_;
					ValaExpression* _tmp423_;
					_tmp419_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp420_ = _tmp419_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp420_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp421_ = invoc;
					_tmp422_ = vala_method_call_get_call (_tmp421_);
					_tmp423_ = _tmp422_;
					if (_tmp423_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp424_;
						ValaDataType* _tmp425_;
						ValaDataType* _tmp426_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp441_;
						ValaExpression* _tmp442_;
						ValaDataType* _tmp443_;
						ValaDataType* _tmp444_;
						const gchar* _tmp445_;
						ValaDataType* _tmp446_;
						ValaSourceReference* _tmp447_;
						ValaSourceReference* _tmp448_;
						ValaDynamicMethod* _tmp449_;
						ValaDynamicMethod* _tmp450_;
						ValaMethodCall* _tmp451_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp452_;
						ValaErrorType* _tmp453_;
						ValaDynamicMethod* _tmp454_;
						ValaErrorType* _tmp455_;
						ValaDynamicMethod* _tmp456_;
						ValaDynamicMethod* _tmp457_;
						ValaParameter* _tmp458_;
						ValaParameter* _tmp459_;
						ValaDynamicMethod* _tmp460_;
						ValaObjectType* _tmp461_;
						ValaDataType* _tmp462_;
						ValaDataType* _tmp463_;
						ValaParameter* _tmp464_;
						ValaParameter* _tmp465_;
						ValaObjectType* _tmp466_;
						ValaTypeSymbol* _tmp467_;
						ValaTypeSymbol* _tmp468_;
						ValaScope* _tmp469_;
						ValaScope* _tmp470_;
						ValaDynamicMethod* _tmp471_;
						ValaDynamicMethod* _tmp472_;
						_tmp424_ = invoc;
						_tmp425_ = vala_expression_get_target_type ((ValaExpression*) _tmp424_);
						_tmp426_ = _tmp425_;
						if (_tmp426_ != NULL) {
							ValaMethodCall* _tmp427_;
							ValaDataType* _tmp428_;
							ValaDataType* _tmp429_;
							ValaDataType* _tmp430_;
							ValaDataType* _tmp431_;
							_tmp427_ = invoc;
							_tmp428_ = vala_expression_get_target_type ((ValaExpression*) _tmp427_);
							_tmp429_ = _tmp428_;
							_tmp430_ = vala_data_type_copy (_tmp429_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp430_;
							_tmp431_ = ret_type;
							vala_data_type_set_value_owned (_tmp431_, TRUE);
						} else {
							ValaMethodCall* _tmp432_;
							ValaCodeNode* _tmp433_;
							ValaCodeNode* _tmp434_;
							_tmp432_ = invoc;
							_tmp433_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp432_);
							_tmp434_ = _tmp433_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp434_)) {
								ValaVoidType* _tmp435_;
								_tmp435_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp435_;
							} else {
								ValaExpression* _tmp436_;
								ValaExpression* _tmp437_;
								ValaDataType* _tmp438_;
								ValaDataType* _tmp439_;
								ValaDataType* _tmp440_;
								_tmp436_ = vala_member_access_get_inner (self);
								_tmp437_ = _tmp436_;
								_tmp438_ = vala_expression_get_value_type (_tmp437_);
								_tmp439_ = _tmp438_;
								_tmp440_ = vala_data_type_copy (_tmp439_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp440_;
							}
						}
						_tmp441_ = vala_member_access_get_inner (self);
						_tmp442_ = _tmp441_;
						_tmp443_ = vala_expression_get_value_type (_tmp442_);
						_tmp444_ = _tmp443_;
						_tmp445_ = self->priv->_member_name;
						_tmp446_ = ret_type;
						_tmp447_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp448_ = _tmp447_;
						_tmp449_ = vala_dynamic_method_new (_tmp444_, _tmp445_, _tmp446_, _tmp448_, NULL);
						m = _tmp449_;
						_tmp450_ = m;
						_tmp451_ = invoc;
						vala_dynamic_method_set_invocation (_tmp450_, _tmp451_);
						_tmp452_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp452_;
						_tmp453_ = err;
						vala_error_type_set_dynamic_error (_tmp453_, TRUE);
						_tmp454_ = m;
						_tmp455_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp454_, (ValaDataType*) _tmp455_);
						_tmp456_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp456_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp457_ = m;
						_tmp458_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp459_ = _tmp458_;
						vala_callable_add_parameter ((ValaCallable*) _tmp457_, _tmp459_);
						_vala_code_node_unref0 (_tmp459_);
						_tmp460_ = m;
						_tmp461_ = dynamic_object_type;
						_tmp462_ = vala_data_type_copy ((ValaDataType*) _tmp461_);
						_tmp463_ = _tmp462_;
						_tmp464_ = vala_parameter_new ("this", _tmp463_, NULL);
						_tmp465_ = _tmp464_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp460_, _tmp465_);
						_vala_code_node_unref0 (_tmp465_);
						_vala_code_node_unref0 (_tmp463_);
						_tmp466_ = dynamic_object_type;
						_tmp467_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp466_);
						_tmp468_ = _tmp467_;
						_tmp469_ = vala_symbol_get_scope ((ValaSymbol*) _tmp468_);
						_tmp470_ = _tmp469_;
						_tmp471_ = m;
						vala_scope_add (_tmp470_, NULL, (ValaSymbol*) _tmp471_);
						_tmp472_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp472_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp473_;
					ValaCodeNode* _tmp474_;
					_tmp473_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp474_ = _tmp473_;
					if (VALA_IS_ASSIGNMENT (_tmp474_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp475_;
						ValaCodeNode* _tmp476_;
						ValaAssignment* _tmp477_;
						ValaExpression* _tmp478_;
						ValaExpression* _tmp479_;
						_tmp475_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp476_ = _tmp475_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp476_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp477_ = a;
						_tmp478_ = vala_assignment_get_left (_tmp477_);
						_tmp479_ = _tmp478_;
						if (_tmp479_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp480_;
							ValaExpression* _tmp481_;
							ValaDataType* _tmp482_;
							ValaDataType* _tmp483_;
							const gchar* _tmp484_;
							ValaSourceReference* _tmp485_;
							ValaSourceReference* _tmp486_;
							ValaDynamicProperty* _tmp487_;
							ValaDynamicProperty* _tmp488_;
							ValaDynamicProperty* _tmp489_;
							ValaDynamicProperty* _tmp490_;
							ValaSourceReference* _tmp491_;
							ValaSourceReference* _tmp492_;
							ValaPropertyAccessor* _tmp493_;
							ValaPropertyAccessor* _tmp494_;
							ValaDynamicProperty* _tmp495_;
							ValaExpression* _tmp496_;
							ValaExpression* _tmp497_;
							ValaDataType* _tmp498_;
							ValaDataType* _tmp499_;
							ValaTypeSymbol* _tmp500_;
							ValaTypeSymbol* _tmp501_;
							ValaScope* _tmp502_;
							ValaScope* _tmp503_;
							ValaObjectType* _tmp504_;
							ValaTypeSymbol* _tmp505_;
							ValaTypeSymbol* _tmp506_;
							ValaScope* _tmp507_;
							ValaScope* _tmp508_;
							ValaDynamicProperty* _tmp509_;
							ValaDynamicProperty* _tmp510_;
							_tmp480_ = vala_member_access_get_inner (self);
							_tmp481_ = _tmp480_;
							_tmp482_ = vala_expression_get_value_type (_tmp481_);
							_tmp483_ = _tmp482_;
							_tmp484_ = self->priv->_member_name;
							_tmp485_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp486_ = _tmp485_;
							_tmp487_ = vala_dynamic_property_new (_tmp483_, _tmp484_, _tmp486_, NULL);
							prop = _tmp487_;
							_tmp488_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp488_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp489_ = prop;
							_tmp490_ = prop;
							_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp490_);
							_tmp492_ = _tmp491_;
							_tmp493_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp492_, NULL);
							_tmp494_ = _tmp493_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp489_, _tmp494_);
							_vala_code_node_unref0 (_tmp494_);
							_tmp495_ = prop;
							_tmp496_ = vala_member_access_get_inner (self);
							_tmp497_ = _tmp496_;
							_tmp498_ = vala_expression_get_value_type (_tmp497_);
							_tmp499_ = _tmp498_;
							_tmp500_ = vala_data_type_get_type_symbol (_tmp499_);
							_tmp501_ = _tmp500_;
							_tmp502_ = vala_symbol_get_scope ((ValaSymbol*) _tmp501_);
							_tmp503_ = _tmp502_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp495_, _tmp503_);
							_tmp504_ = dynamic_object_type;
							_tmp505_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp504_);
							_tmp506_ = _tmp505_;
							_tmp507_ = vala_symbol_get_scope ((ValaSymbol*) _tmp506_);
							_tmp508_ = _tmp507_;
							_tmp509_ = prop;
							vala_scope_add (_tmp508_, NULL, (ValaSymbol*) _tmp509_);
							_tmp510_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp510_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp511_ = FALSE;
						gboolean _tmp512_ = FALSE;
						ValaCodeNode* _tmp513_;
						ValaCodeNode* _tmp514_;
						_tmp513_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp514_ = _tmp513_;
						if (VALA_IS_MEMBER_ACCESS (_tmp514_)) {
							ValaExpression* _tmp515_;
							ValaExpression* _tmp516_;
							_tmp515_ = vala_member_access_get_inner (self);
							_tmp516_ = _tmp515_;
							_tmp512_ = VALA_IS_MEMBER_ACCESS (_tmp516_);
						} else {
							_tmp512_ = FALSE;
						}
						if (_tmp512_) {
							ValaCodeNode* _tmp517_;
							ValaCodeNode* _tmp518_;
							ValaCodeNode* _tmp519_;
							ValaCodeNode* _tmp520_;
							_tmp517_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp518_ = _tmp517_;
							_tmp519_ = vala_code_node_get_parent_node (_tmp518_);
							_tmp520_ = _tmp519_;
							_tmp511_ = VALA_IS_METHOD_CALL (_tmp520_);
						} else {
							_tmp511_ = FALSE;
						}
						if (_tmp511_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp521_;
							ValaCodeNode* _tmp522_;
							gboolean _tmp523_ = FALSE;
							ValaMemberAccess* _tmp524_;
							const gchar* _tmp525_;
							_tmp521_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp522_ = _tmp521_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp522_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp524_ = ma;
							_tmp525_ = _tmp524_->priv->_member_name;
							if (g_strcmp0 (_tmp525_, "connect") == 0) {
								_tmp523_ = TRUE;
							} else {
								ValaMemberAccess* _tmp526_;
								const gchar* _tmp527_;
								_tmp526_ = ma;
								_tmp527_ = _tmp526_->priv->_member_name;
								_tmp523_ = g_strcmp0 (_tmp527_, "connect_after") == 0;
							}
							if (_tmp523_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp528_;
								ValaExpression* _tmp529_;
								ValaDataType* _tmp530_;
								ValaDataType* _tmp531_;
								const gchar* _tmp532_;
								ValaVoidType* _tmp533_;
								ValaVoidType* _tmp534_;
								ValaSourceReference* _tmp535_;
								ValaSourceReference* _tmp536_;
								ValaDynamicSignal* _tmp537_;
								ValaDynamicSignal* _tmp538_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp539_;
								ValaCodeNode* _tmp540_;
								ValaCodeNode* _tmp541_;
								ValaCodeNode* _tmp542_;
								ValaMethodCall* _tmp543_;
								ValaMethodCall* _tmp544_;
								ValaList* _tmp545_;
								gint _tmp546_;
								gint _tmp547_;
								ValaDynamicSignal* _tmp573_;
								ValaObjectType* _tmp574_;
								ValaTypeSymbol* _tmp575_;
								ValaTypeSymbol* _tmp576_;
								ValaScope* _tmp577_;
								ValaScope* _tmp578_;
								ValaDynamicSignal* _tmp579_;
								ValaDynamicSignal* _tmp580_;
								_tmp528_ = vala_member_access_get_inner (self);
								_tmp529_ = _tmp528_;
								_tmp530_ = vala_expression_get_value_type (_tmp529_);
								_tmp531_ = _tmp530_;
								_tmp532_ = self->priv->_member_name;
								_tmp533_ = vala_void_type_new (NULL);
								_tmp534_ = _tmp533_;
								_tmp535_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp536_ = _tmp535_;
								_tmp537_ = vala_dynamic_signal_new (_tmp531_, _tmp532_, (ValaDataType*) _tmp534_, _tmp536_, NULL);
								_tmp538_ = _tmp537_;
								_vala_code_node_unref0 (_tmp534_);
								s = _tmp538_;
								_tmp539_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp540_ = _tmp539_;
								_tmp541_ = vala_code_node_get_parent_node (_tmp540_);
								_tmp542_ = _tmp541_;
								_tmp543_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp542_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp543_;
								_tmp544_ = mcall;
								_tmp545_ = vala_method_call_get_argument_list (_tmp544_);
								_tmp546_ = vala_collection_get_size ((ValaCollection*) _tmp545_);
								_tmp547_ = _tmp546_;
								if (_tmp547_ > 0) {
									ValaDynamicSignal* _tmp548_;
									ValaMethodCall* _tmp549_;
									ValaList* _tmp550_;
									gpointer _tmp551_;
									ValaExpression* _tmp552_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp553_;
									ValaExpression* _tmp554_;
									ValaExpression* _tmp555_;
									gboolean _tmp556_ = FALSE;
									gboolean _tmp557_ = FALSE;
									ValaMemberAccess* _tmp558_;
									_tmp548_ = s;
									_tmp549_ = mcall;
									_tmp550_ = vala_method_call_get_argument_list (_tmp549_);
									_tmp551_ = vala_list_get (_tmp550_, 0);
									_tmp552_ = (ValaExpression*) _tmp551_;
									vala_dynamic_signal_set_handler (_tmp548_, _tmp552_);
									_vala_code_node_unref0 (_tmp552_);
									_tmp553_ = s;
									_tmp554_ = vala_dynamic_signal_get_handler (_tmp553_);
									_tmp555_ = _tmp554_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp555_) ? ((ValaMemberAccess*) _tmp555_) : NULL;
									_tmp558_ = arg;
									if (_tmp558_ == NULL) {
										_tmp557_ = TRUE;
									} else {
										ValaMemberAccess* _tmp559_;
										_tmp559_ = arg;
										_tmp557_ = !vala_code_node_check ((ValaCodeNode*) _tmp559_, context);
									}
									if (_tmp557_) {
										_tmp556_ = TRUE;
									} else {
										ValaMemberAccess* _tmp560_;
										ValaSymbol* _tmp561_;
										ValaSymbol* _tmp562_;
										_tmp560_ = arg;
										_tmp561_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp560_);
										_tmp562_ = _tmp561_;
										_tmp556_ = !VALA_IS_METHOD (_tmp562_);
									}
									if (_tmp556_) {
										ValaDynamicSignal* _tmp563_;
										ValaExpression* _tmp564_;
										ValaExpression* _tmp565_;
										ValaSourceReference* _tmp566_;
										ValaSourceReference* _tmp567_;
										ValaDynamicSignal* _tmp568_;
										gchar* _tmp569_;
										gchar* _tmp570_;
										gchar* _tmp571_;
										gchar* _tmp572_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp563_ = s;
										_tmp564_ = vala_dynamic_signal_get_handler (_tmp563_);
										_tmp565_ = _tmp564_;
										_tmp566_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp565_);
										_tmp567_ = _tmp566_;
										_tmp568_ = s;
										_tmp569_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp568_);
										_tmp570_ = _tmp569_;
										_tmp571_ = g_strdup_printf ("Invalid handler for `%s'", _tmp570_);
										_tmp572_ = _tmp571_;
										vala_report_error (_tmp567_, _tmp572_);
										_g_free0 (_tmp572_);
										_g_free0 (_tmp570_);
									}
								}
								_tmp573_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp573_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp574_ = dynamic_object_type;
								_tmp575_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp574_);
								_tmp576_ = _tmp575_;
								_tmp577_ = vala_symbol_get_scope ((ValaSymbol*) _tmp576_);
								_tmp578_ = _tmp577_;
								_tmp579_ = s;
								vala_scope_add (_tmp578_, NULL, (ValaSymbol*) _tmp579_);
								_tmp580_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp580_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp581_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp582_ = _tmp581_;
				if (_tmp582_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp583_;
					ValaExpression* _tmp584_;
					ValaDataType* _tmp585_;
					ValaDataType* _tmp586_;
					const gchar* _tmp587_;
					ValaSourceReference* _tmp588_;
					ValaSourceReference* _tmp589_;
					ValaDynamicProperty* _tmp590_;
					ValaDataType* _tmp591_;
					ValaDataType* _tmp592_;
					ValaDynamicProperty* _tmp603_;
					ValaDynamicProperty* _tmp604_;
					ValaDynamicProperty* _tmp605_;
					ValaDataType* _tmp606_;
					ValaDataType* _tmp607_;
					ValaDataType* _tmp608_;
					ValaDataType* _tmp609_;
					ValaDynamicProperty* _tmp610_;
					ValaSourceReference* _tmp611_;
					ValaSourceReference* _tmp612_;
					ValaPropertyAccessor* _tmp613_;
					ValaPropertyAccessor* _tmp614_;
					ValaDynamicProperty* _tmp615_;
					ValaExpression* _tmp616_;
					ValaExpression* _tmp617_;
					ValaDataType* _tmp618_;
					ValaDataType* _tmp619_;
					ValaTypeSymbol* _tmp620_;
					ValaTypeSymbol* _tmp621_;
					ValaScope* _tmp622_;
					ValaScope* _tmp623_;
					ValaObjectType* _tmp624_;
					ValaTypeSymbol* _tmp625_;
					ValaTypeSymbol* _tmp626_;
					ValaScope* _tmp627_;
					ValaScope* _tmp628_;
					ValaDynamicProperty* _tmp629_;
					ValaDynamicProperty* _tmp630_;
					_tmp583_ = vala_member_access_get_inner (self);
					_tmp584_ = _tmp583_;
					_tmp585_ = vala_expression_get_value_type (_tmp584_);
					_tmp586_ = _tmp585_;
					_tmp587_ = self->priv->_member_name;
					_tmp588_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp589_ = _tmp588_;
					_tmp590_ = vala_dynamic_property_new (_tmp586_, _tmp587_, _tmp589_, NULL);
					prop = _tmp590_;
					_tmp591_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp592_ = _tmp591_;
					if (_tmp592_ != NULL) {
						ValaDynamicProperty* _tmp593_;
						ValaDataType* _tmp594_;
						ValaDataType* _tmp595_;
						_tmp593_ = prop;
						_tmp594_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp595_ = _tmp594_;
						vala_property_set_property_type ((ValaProperty*) _tmp593_, _tmp595_);
					} else {
						ValaDynamicProperty* _tmp596_;
						ValaExpression* _tmp597_;
						ValaExpression* _tmp598_;
						ValaDataType* _tmp599_;
						ValaDataType* _tmp600_;
						ValaDataType* _tmp601_;
						ValaDataType* _tmp602_;
						_tmp596_ = prop;
						_tmp597_ = vala_member_access_get_inner (self);
						_tmp598_ = _tmp597_;
						_tmp599_ = vala_expression_get_value_type (_tmp598_);
						_tmp600_ = _tmp599_;
						_tmp601_ = vala_data_type_copy (_tmp600_);
						_tmp602_ = _tmp601_;
						vala_property_set_property_type ((ValaProperty*) _tmp596_, _tmp602_);
						_vala_code_node_unref0 (_tmp602_);
					}
					_tmp603_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp603_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp604_ = prop;
					_tmp605_ = prop;
					_tmp606_ = vala_property_get_property_type ((ValaProperty*) _tmp605_);
					_tmp607_ = _tmp606_;
					_tmp608_ = vala_data_type_copy (_tmp607_);
					_tmp609_ = _tmp608_;
					_tmp610_ = prop;
					_tmp611_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp610_);
					_tmp612_ = _tmp611_;
					_tmp613_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp609_, NULL, _tmp612_, NULL);
					_tmp614_ = _tmp613_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp604_, _tmp614_);
					_vala_code_node_unref0 (_tmp614_);
					_vala_code_node_unref0 (_tmp609_);
					_tmp615_ = prop;
					_tmp616_ = vala_member_access_get_inner (self);
					_tmp617_ = _tmp616_;
					_tmp618_ = vala_expression_get_value_type (_tmp617_);
					_tmp619_ = _tmp618_;
					_tmp620_ = vala_data_type_get_type_symbol (_tmp619_);
					_tmp621_ = _tmp620_;
					_tmp622_ = vala_symbol_get_scope ((ValaSymbol*) _tmp621_);
					_tmp623_ = _tmp622_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp615_, _tmp623_);
					_tmp624_ = dynamic_object_type;
					_tmp625_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp624_);
					_tmp626_ = _tmp625_;
					_tmp627_ = vala_symbol_get_scope ((ValaSymbol*) _tmp626_);
					_tmp628_ = _tmp627_;
					_tmp629_ = prop;
					vala_scope_add (_tmp628_, NULL, (ValaSymbol*) _tmp629_);
					_tmp630_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp630_);
					_vala_code_node_unref0 (prop);
				}
				_tmp631_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp632_ = _tmp631_;
				if (_tmp632_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp634_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp635_ = _tmp634_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp635_)) {
				ValaExpression* _tmp636_;
				ValaExpression* _tmp637_;
				ValaSymbol* _tmp638_;
				ValaSymbol* _tmp639_;
				_tmp636_ = vala_member_access_get_inner (self);
				_tmp637_ = _tmp636_;
				_tmp638_ = vala_expression_get_symbol_reference (_tmp637_);
				_tmp639_ = _tmp638_;
				_tmp633_ = VALA_IS_VARIABLE (_tmp639_);
			} else {
				_tmp633_ = FALSE;
			}
			if (_tmp633_) {
				ValaArrayType* inner_type = NULL;
				ValaSemanticAnalyzer* _tmp640_;
				ValaSemanticAnalyzer* _tmp641_;
				ValaExpression* _tmp642_;
				ValaExpression* _tmp643_;
				ValaSymbol* _tmp644_;
				ValaSymbol* _tmp645_;
				ValaDataType* _tmp646_;
				ValaArrayType* _tmp647_;
				gboolean _tmp648_ = FALSE;
				ValaArrayType* _tmp649_;
				_tmp640_ = vala_code_context_get_analyzer (context);
				_tmp641_ = _tmp640_;
				_tmp642_ = vala_member_access_get_inner (self);
				_tmp643_ = _tmp642_;
				_tmp644_ = vala_expression_get_symbol_reference (_tmp643_);
				_tmp645_ = _tmp644_;
				_tmp646_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp641_, _tmp645_, TRUE);
				_tmp647_ = VALA_IS_ARRAY_TYPE (_tmp646_) ? ((ValaArrayType*) _tmp646_) : NULL;
				if (_tmp647_ == NULL) {
					_vala_code_node_unref0 (_tmp646_);
				}
				inner_type = _tmp647_;
				_tmp649_ = inner_type;
				if (_tmp649_ != NULL) {
					ValaArrayType* _tmp650_;
					gboolean _tmp651_;
					gboolean _tmp652_;
					_tmp650_ = inner_type;
					_tmp651_ = vala_array_type_get_inline_allocated (_tmp650_);
					_tmp652_ = _tmp651_;
					_tmp648_ = _tmp652_;
				} else {
					_tmp648_ = FALSE;
				}
				if (_tmp648_) {
					ValaSourceReference* _tmp653_;
					ValaSourceReference* _tmp654_;
					_tmp653_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp654_ = _tmp653_;
					vala_report_error (_tmp654_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				} else {
					gboolean _tmp655_ = FALSE;
					ValaArrayType* _tmp656_;
					_tmp656_ = inner_type;
					if (_tmp656_ != NULL) {
						ValaArrayType* _tmp657_;
						gboolean _tmp658_;
						gboolean _tmp659_;
						_tmp657_ = inner_type;
						_tmp658_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp657_);
						_tmp659_ = _tmp658_;
						_tmp655_ = !_tmp659_;
					} else {
						_tmp655_ = FALSE;
					}
					if (_tmp655_) {
						ValaSourceReference* _tmp660_;
						ValaSourceReference* _tmp661_;
						_tmp660_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp661_ = _tmp660_;
						vala_report_error (_tmp661_, "`resize' is not allowed for unowned array references");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
				_vala_code_node_unref0 (inner_type);
			}
		}
	}
	_tmp665_ = vala_member_access_get_inner (self);
	_tmp666_ = _tmp665_;
	if (_tmp666_ == NULL) {
		ValaSymbol* _tmp667_;
		ValaSymbol* _tmp668_;
		_tmp667_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp668_ = _tmp667_;
		_tmp664_ = _tmp668_ == NULL;
	} else {
		_tmp664_ = FALSE;
	}
	if (_tmp664_) {
		ValaDataType* _tmp669_;
		ValaDataType* _tmp670_;
		_tmp669_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp670_ = _tmp669_;
		_tmp663_ = _tmp670_ != NULL;
	} else {
		_tmp663_ = FALSE;
	}
	if (_tmp663_) {
		ValaDataType* _tmp671_;
		ValaDataType* _tmp672_;
		ValaTypeSymbol* _tmp673_;
		ValaTypeSymbol* _tmp674_;
		_tmp671_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp672_ = _tmp671_;
		_tmp673_ = vala_data_type_get_type_symbol (_tmp672_);
		_tmp674_ = _tmp673_;
		_tmp662_ = VALA_IS_ENUM (_tmp674_);
	} else {
		_tmp662_ = FALSE;
	}
	if (_tmp662_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp675_;
		ValaDataType* _tmp676_;
		ValaTypeSymbol* _tmp677_;
		ValaTypeSymbol* _tmp678_;
		_tmp675_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp676_ = _tmp675_;
		_tmp677_ = vala_data_type_get_type_symbol (_tmp676_);
		_tmp678_ = _tmp677_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp678_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp679_;
			ValaList* _tmp680_;
			ValaList* _tmp681_;
			gint _val_size = 0;
			ValaList* _tmp682_;
			gint _tmp683_;
			gint _tmp684_;
			gint _val_index = 0;
			_tmp679_ = enum_type;
			_tmp680_ = vala_enum_get_values (_tmp679_);
			_tmp681_ = _vala_iterable_ref0 (_tmp680_);
			_val_list = _tmp681_;
			_tmp682_ = _val_list;
			_tmp683_ = vala_collection_get_size ((ValaCollection*) _tmp682_);
			_tmp684_ = _tmp683_;
			_val_size = _tmp684_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp685_;
				gpointer _tmp686_;
				const gchar* _tmp687_;
				ValaEnumValue* _tmp688_;
				const gchar* _tmp689_;
				const gchar* _tmp690_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp685_ = _val_list;
				_tmp686_ = vala_list_get (_tmp685_, _val_index);
				val = (ValaEnumValue*) _tmp686_;
				_tmp687_ = self->priv->_member_name;
				_tmp688_ = val;
				_tmp689_ = vala_symbol_get_name ((ValaSymbol*) _tmp688_);
				_tmp690_ = _tmp689_;
				if (g_strcmp0 (_tmp687_, _tmp690_) == 0) {
					ValaEnumValue* _tmp691_;
					_tmp691_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp691_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
	}
	_tmp692_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp693_ = _tmp692_;
	if (_tmp693_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp694_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp695_ = FALSE;
		ValaExpression* _tmp696_;
		ValaExpression* _tmp697_;
		gchar* base_type_package = NULL;
		gchar* _tmp717_;
		gboolean _tmp718_ = FALSE;
		ValaSymbol* _tmp719_;
		gchar* visited_types_string = NULL;
		gchar* _tmp734_;
		ValaSourceReference* _tmp749_;
		ValaSourceReference* _tmp750_;
		const gchar* _tmp751_;
		const gchar* _tmp752_;
		const gchar* _tmp753_;
		const gchar* _tmp754_;
		gchar* _tmp755_;
		gchar* _tmp756_;
		ValaInvalidType* _tmp757_;
		ValaInvalidType* _tmp758_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp694_ = g_strdup ("(null)");
		base_type_name = _tmp694_;
		base_type = NULL;
		_tmp696_ = vala_member_access_get_inner (self);
		_tmp697_ = _tmp696_;
		if (_tmp697_ != NULL) {
			ValaExpression* _tmp698_;
			ValaExpression* _tmp699_;
			ValaDataType* _tmp700_;
			ValaDataType* _tmp701_;
			_tmp698_ = vala_member_access_get_inner (self);
			_tmp699_ = _tmp698_;
			_tmp700_ = vala_expression_get_value_type (_tmp699_);
			_tmp701_ = _tmp700_;
			_tmp695_ = _tmp701_ != NULL;
		} else {
			_tmp695_ = FALSE;
		}
		if (_tmp695_) {
			ValaExpression* _tmp702_;
			ValaExpression* _tmp703_;
			ValaDataType* _tmp704_;
			ValaDataType* _tmp705_;
			gchar* _tmp706_;
			ValaExpression* _tmp707_;
			ValaExpression* _tmp708_;
			ValaDataType* _tmp709_;
			ValaDataType* _tmp710_;
			ValaTypeSymbol* _tmp711_;
			ValaTypeSymbol* _tmp712_;
			_tmp702_ = vala_member_access_get_inner (self);
			_tmp703_ = _tmp702_;
			_tmp704_ = vala_expression_get_value_type (_tmp703_);
			_tmp705_ = _tmp704_;
			_tmp706_ = vala_code_node_to_string ((ValaCodeNode*) _tmp705_);
			_g_free0 (base_type_name);
			base_type_name = _tmp706_;
			_tmp707_ = vala_member_access_get_inner (self);
			_tmp708_ = _tmp707_;
			_tmp709_ = vala_expression_get_value_type (_tmp708_);
			_tmp710_ = _tmp709_;
			_tmp711_ = vala_data_type_get_type_symbol (_tmp710_);
			_tmp712_ = _tmp711_;
			base_type = (ValaSymbol*) _tmp712_;
		} else {
			ValaSymbol* _tmp713_;
			_tmp713_ = base_symbol;
			if (_tmp713_ != NULL) {
				ValaSymbol* _tmp714_;
				gchar* _tmp715_;
				ValaSymbol* _tmp716_;
				_tmp714_ = base_symbol;
				_tmp715_ = vala_symbol_get_full_name (_tmp714_);
				_g_free0 (base_type_name);
				base_type_name = _tmp715_;
				_tmp716_ = base_symbol;
				base_type = _tmp716_;
			}
		}
		_tmp717_ = g_strdup ("");
		base_type_package = _tmp717_;
		_tmp719_ = base_type;
		if (_tmp719_ != NULL) {
			ValaSymbol* _tmp720_;
			gboolean _tmp721_;
			gboolean _tmp722_;
			_tmp720_ = base_type;
			_tmp721_ = vala_symbol_get_external_package (_tmp720_);
			_tmp722_ = _tmp721_;
			_tmp718_ = _tmp722_;
		} else {
			_tmp718_ = FALSE;
		}
		if (_tmp718_) {
			ValaSymbol* _tmp723_;
			ValaSourceReference* _tmp724_;
			ValaSourceReference* _tmp725_;
			ValaSourceFile* _tmp726_;
			ValaSourceFile* _tmp727_;
			const gchar* _tmp728_;
			const gchar* _tmp729_;
			gchar* _tmp730_;
			const gchar* _tmp731_;
			_tmp723_ = base_symbol;
			_tmp724_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp723_);
			_tmp725_ = _tmp724_;
			_tmp726_ = vala_source_reference_get_file (_tmp725_);
			_tmp727_ = _tmp726_;
			_tmp728_ = vala_source_file_get_package_name (_tmp727_);
			_tmp729_ = _tmp728_;
			_tmp730_ = g_strdup (_tmp729_);
			_g_free0 (base_type_package);
			base_type_package = _tmp730_;
			_tmp731_ = base_type_package;
			if (_tmp731_ != NULL) {
				const gchar* _tmp732_;
				gchar* _tmp733_;
				_tmp732_ = base_type_package;
				_tmp733_ = g_strdup_printf (" (%s)", _tmp732_);
				_g_free0 (base_type_package);
				base_type_package = _tmp733_;
			}
		}
		_tmp734_ = g_strdup ("");
		visited_types_string = _tmp734_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp735_;
			ValaArrayList* _tmp736_;
			gint _type_size = 0;
			ValaArrayList* _tmp737_;
			gint _tmp738_;
			gint _tmp739_;
			gint _type_index = 0;
			_tmp735_ = visited_types;
			_tmp736_ = _vala_iterable_ref0 (_tmp735_);
			_type_list = _tmp736_;
			_tmp737_ = _type_list;
			_tmp738_ = vala_collection_get_size ((ValaCollection*) _tmp737_);
			_tmp739_ = _tmp738_;
			_type_size = _tmp739_;
			_type_index = -1;
			while (TRUE) {
				ValaDataType* type = NULL;
				ValaArrayList* _tmp740_;
				gpointer _tmp741_;
				const gchar* _tmp742_;
				ValaDataType* _tmp743_;
				gchar* _tmp744_;
				gchar* _tmp745_;
				gchar* _tmp746_;
				gchar* _tmp747_;
				gchar* _tmp748_;
				_type_index = _type_index + 1;
				if (!(_type_index < _type_size)) {
					break;
				}
				_tmp740_ = _type_list;
				_tmp741_ = vala_list_get ((ValaList*) _tmp740_, _type_index);
				type = (ValaDataType*) _tmp741_;
				_tmp742_ = visited_types_string;
				_tmp743_ = type;
				_tmp744_ = vala_code_node_to_string ((ValaCodeNode*) _tmp743_);
				_tmp745_ = _tmp744_;
				_tmp746_ = g_strdup_printf (" or `%s'", _tmp745_);
				_tmp747_ = _tmp746_;
				_tmp748_ = g_strconcat (_tmp742_, _tmp747_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp748_;
				_g_free0 (_tmp747_);
				_g_free0 (_tmp745_);
				_vala_code_node_unref0 (type);
			}
			_vala_iterable_unref0 (_type_list);
		}
		_tmp749_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp750_ = _tmp749_;
		_tmp751_ = self->priv->_member_name;
		_tmp752_ = base_type_name;
		_tmp753_ = base_type_package;
		_tmp754_ = visited_types_string;
		_tmp755_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'%s%s", _tmp751_, _tmp752_, _tmp753_, _tmp754_);
		_tmp756_ = _tmp755_;
		vala_report_error (_tmp750_, _tmp756_);
		_g_free0 (_tmp756_);
		_tmp757_ = vala_invalid_type_new ();
		_tmp758_ = _tmp757_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp758_);
		_vala_code_node_unref0 (_tmp758_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp759_;
		ValaSymbol* _tmp760_;
		gboolean _tmp761_;
		gboolean _tmp762_;
		_tmp759_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp760_ = _tmp759_;
		_tmp761_ = vala_code_node_get_error ((ValaCodeNode*) _tmp760_);
		_tmp762_ = _tmp761_;
		if (_tmp762_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp763_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp764_ = _tmp763_;
	if (VALA_IS_SIGNAL (_tmp764_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp765_;
		ValaSymbol* _tmp766_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp773_;
		ValaCodeNode* _tmp774_;
		ValaCodeNode* _tmp775_;
		gboolean _tmp776_ = FALSE;
		gboolean _tmp777_ = FALSE;
		gboolean _tmp778_ = FALSE;
		ValaCodeNode* _tmp779_;
		_tmp765_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp766_ = _tmp765_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp766_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp767_;
			ValaCodeNode* _tmp768_;
			ValaCodeNode* _tmp769_;
			ValaCodeNode* _tmp770_;
			ValaCodeNode* _tmp771_;
			ValaCodeNode* _tmp772_;
			_tmp767_ = ma;
			_tmp768_ = vala_code_node_get_parent_node (_tmp767_);
			_tmp769_ = _tmp768_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp769_)) {
				break;
			}
			_tmp770_ = ma;
			_tmp771_ = vala_code_node_get_parent_node (_tmp770_);
			_tmp772_ = _tmp771_;
			ma = _tmp772_;
		}
		_tmp773_ = ma;
		_tmp774_ = vala_code_node_get_parent_node (_tmp773_);
		_tmp775_ = _tmp774_;
		parent = _tmp775_;
		_tmp779_ = parent;
		if (_tmp779_ != NULL) {
			ValaCodeNode* _tmp780_;
			_tmp780_ = parent;
			_tmp778_ = !VALA_IS_ELEMENT_ACCESS (_tmp780_);
		} else {
			_tmp778_ = FALSE;
		}
		if (_tmp778_) {
			ValaCodeNode* _tmp781_;
			ValaExpression* _tmp782_;
			ValaExpression* _tmp783_;
			_tmp781_ = ma;
			_tmp782_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp781_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp783_ = _tmp782_;
			_tmp777_ = !VALA_IS_BASE_ACCESS (_tmp783_);
		} else {
			_tmp777_ = FALSE;
		}
		if (_tmp777_) {
			gboolean _tmp784_ = FALSE;
			ValaCodeNode* _tmp785_;
			_tmp785_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp785_)) {
				_tmp784_ = TRUE;
			} else {
				ValaCodeNode* _tmp786_;
				ValaList* _tmp787_;
				_tmp786_ = parent;
				_tmp787_ = vala_method_call_get_argument_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp786_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp784_ = vala_collection_contains ((ValaCollection*) _tmp787_, (ValaExpression*) self);
			}
			_tmp776_ = _tmp784_;
		} else {
			_tmp776_ = FALSE;
		}
		if (_tmp776_) {
			ValaSignal* _tmp788_;
			ValaAttribute* _tmp789_;
			_tmp788_ = sig;
			_tmp789_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp788_, "HasEmitter");
			if (_tmp789_ != NULL) {
				ValaSignal* _tmp790_;
				ValaSignal* _tmp791_;
				ValaMethod* _tmp792_;
				ValaMethod* _tmp793_;
				_tmp790_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp790_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp791_ = sig;
				_tmp792_ = vala_signal_get_emitter (_tmp791_);
				_tmp793_ = _tmp792_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp793_);
			} else {
				ValaSourceReference* _tmp794_;
				ValaSourceReference* _tmp795_;
				ValaSymbol* _tmp796_;
				ValaSymbol* _tmp797_;
				gchar* _tmp798_;
				gchar* _tmp799_;
				gchar* _tmp800_;
				gchar* _tmp801_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp794_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp795_ = _tmp794_;
				_tmp796_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp797_ = _tmp796_;
				_tmp798_ = vala_symbol_get_full_name (_tmp797_);
				_tmp799_ = _tmp798_;
				_tmp800_ = g_strdup_printf ("Signal `%s' requires emitter in this context", _tmp799_);
				_tmp801_ = _tmp800_;
				vala_report_error (_tmp795_, _tmp801_);
				_g_free0 (_tmp801_);
				_g_free0 (_tmp799_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp802_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp803_ = _tmp802_;
	member = _tmp803_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp804_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp804_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp805_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp805_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp806_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp807_;
		ValaSymbol* _tmp808_;
		ValaSymbol* _tmp809_;
		gboolean _tmp810_ = FALSE;
		ValaBlock* _tmp811_;
		_tmp806_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp806_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp807_ = local;
		_tmp808_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp807_);
		_tmp809_ = _tmp808_;
		block = VALA_IS_BLOCK (_tmp809_) ? ((ValaBlock*) _tmp809_) : NULL;
		_tmp811_ = block;
		if (_tmp811_ != NULL) {
			ValaBlock* _tmp812_;
			ValaSymbol* _tmp813_;
			ValaSemanticAnalyzer* _tmp814_;
			ValaSemanticAnalyzer* _tmp815_;
			ValaSymbol* _tmp816_;
			ValaSymbol* _tmp817_;
			_tmp812_ = block;
			_tmp813_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp812_);
			_tmp814_ = vala_code_context_get_analyzer (context);
			_tmp815_ = _tmp814_;
			_tmp816_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp815_);
			_tmp817_ = _tmp816_;
			_tmp810_ = _tmp813_ != _tmp817_;
		} else {
			_tmp810_ = FALSE;
		}
		if (_tmp810_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp818_;
			ValaSemanticAnalyzer* _tmp819_;
			ValaSymbol* _tmp820_;
			ValaSymbol* _tmp821_;
			ValaLocalVariable* _tmp832_;
			ValaBlock* _tmp833_;
			_tmp818_ = vala_code_context_get_analyzer (context);
			_tmp819_ = _tmp818_;
			_tmp820_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp819_);
			_tmp821_ = _tmp820_;
			sym = _tmp821_;
			while (TRUE) {
				ValaSymbol* _tmp822_;
				ValaBlock* _tmp823_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp824_;
				ValaMethod* _tmp825_;
				ValaSymbol* _tmp829_;
				ValaSymbol* _tmp830_;
				ValaSymbol* _tmp831_;
				_tmp822_ = sym;
				_tmp823_ = block;
				if (!(_tmp822_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp823_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp824_ = sym;
				method = VALA_IS_METHOD (_tmp824_) ? ((ValaMethod*) _tmp824_) : NULL;
				_tmp825_ = method;
				if (_tmp825_ != NULL) {
					ValaMethod* _tmp826_;
					ValaMethod* _tmp827_;
					ValaLocalVariable* _tmp828_;
					_tmp826_ = method;
					vala_method_set_closure (_tmp826_, TRUE);
					_tmp827_ = method;
					_tmp828_ = local;
					vala_method_add_captured_variable (_tmp827_, _tmp828_);
				}
				_tmp829_ = sym;
				_tmp830_ = vala_symbol_get_parent_symbol (_tmp829_);
				_tmp831_ = _tmp830_;
				sym = _tmp831_;
			}
			_tmp832_ = local;
			vala_local_variable_set_captured (_tmp832_, TRUE);
			_tmp833_ = block;
			vala_block_set_captured (_tmp833_, TRUE);
		}
	} else {
		ValaSymbol* _tmp834_;
		_tmp834_ = member;
		if (VALA_IS_PARAMETER (_tmp834_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp835_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp836_;
			ValaSymbol* _tmp837_;
			ValaSymbol* _tmp838_;
			gboolean _tmp839_ = FALSE;
			gboolean _tmp840_ = FALSE;
			ValaMethod* _tmp841_;
			_tmp835_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp835_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp836_ = param;
			_tmp837_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp836_);
			_tmp838_ = _tmp837_;
			m = VALA_IS_METHOD (_tmp838_) ? ((ValaMethod*) _tmp838_) : NULL;
			_tmp841_ = m;
			if (_tmp841_ != NULL) {
				ValaMethod* _tmp842_;
				ValaSemanticAnalyzer* _tmp843_;
				ValaSemanticAnalyzer* _tmp844_;
				ValaSymbol* _tmp845_;
				ValaSymbol* _tmp846_;
				_tmp842_ = m;
				_tmp843_ = vala_code_context_get_analyzer (context);
				_tmp844_ = _tmp843_;
				_tmp845_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp844_);
				_tmp846_ = _tmp845_;
				_tmp840_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp842_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp846_;
			} else {
				_tmp840_ = FALSE;
			}
			if (_tmp840_) {
				ValaParameter* _tmp847_;
				ValaMethod* _tmp848_;
				ValaParameter* _tmp849_;
				ValaParameter* _tmp850_;
				_tmp847_ = param;
				_tmp848_ = m;
				_tmp849_ = vala_method_get_this_parameter (_tmp848_);
				_tmp850_ = _tmp849_;
				_tmp839_ = _tmp847_ != _tmp850_;
			} else {
				_tmp839_ = FALSE;
			}
			if (_tmp839_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp851_;
				ValaSemanticAnalyzer* _tmp852_;
				ValaSymbol* _tmp853_;
				ValaSymbol* _tmp854_;
				ValaParameter* _tmp863_;
				ValaMethod* _tmp864_;
				ValaBlock* _tmp865_;
				ValaBlock* _tmp866_;
				ValaParameter* _tmp867_;
				ValaParameterDirection _tmp868_;
				ValaParameterDirection _tmp869_;
				_tmp851_ = vala_code_context_get_analyzer (context);
				_tmp852_ = _tmp851_;
				_tmp853_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp852_);
				_tmp854_ = _tmp853_;
				sym = _tmp854_;
				while (TRUE) {
					ValaSymbol* _tmp855_;
					ValaMethod* _tmp856_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp857_;
					ValaMethod* _tmp858_;
					ValaSymbol* _tmp860_;
					ValaSymbol* _tmp861_;
					ValaSymbol* _tmp862_;
					_tmp855_ = sym;
					_tmp856_ = m;
					if (!(_tmp855_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp856_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp857_ = sym;
					method = VALA_IS_METHOD (_tmp857_) ? ((ValaMethod*) _tmp857_) : NULL;
					_tmp858_ = method;
					if (_tmp858_ != NULL) {
						ValaMethod* _tmp859_;
						_tmp859_ = method;
						vala_method_set_closure (_tmp859_, TRUE);
					}
					_tmp860_ = sym;
					_tmp861_ = vala_symbol_get_parent_symbol (_tmp860_);
					_tmp862_ = _tmp861_;
					sym = _tmp862_;
				}
				_tmp863_ = param;
				vala_parameter_set_captured (_tmp863_, TRUE);
				_tmp864_ = m;
				_tmp865_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp864_);
				_tmp866_ = _tmp865_;
				vala_block_set_captured (_tmp866_, TRUE);
				_tmp867_ = param;
				_tmp868_ = vala_parameter_get_direction (_tmp867_);
				_tmp869_ = _tmp868_;
				if (_tmp869_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp870_;
					ValaSourceReference* _tmp871_;
					ValaParameter* _tmp872_;
					gchar* _tmp873_;
					gchar* _tmp874_;
					gchar* _tmp875_;
					gchar* _tmp876_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp870_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp871_ = _tmp870_;
					_tmp872_ = param;
					_tmp873_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp872_);
					_tmp874_ = _tmp873_;
					_tmp875_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp874_);
					_tmp876_ = _tmp875_;
					vala_report_error (_tmp871_, _tmp876_);
					_g_free0 (_tmp876_);
					_g_free0 (_tmp874_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp877_;
				ValaSymbol* _tmp878_;
				ValaSymbol* _tmp879_;
				ValaSymbol* _tmp880_;
				ValaSymbol* _tmp881_;
				gboolean _tmp882_ = FALSE;
				gboolean _tmp883_ = FALSE;
				ValaPropertyAccessor* _tmp884_;
				_tmp877_ = param;
				_tmp878_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp877_);
				_tmp879_ = _tmp878_;
				_tmp880_ = vala_symbol_get_parent_symbol (_tmp879_);
				_tmp881_ = _tmp880_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp881_) ? ((ValaPropertyAccessor*) _tmp881_) : NULL;
				_tmp884_ = acc;
				if (_tmp884_ != NULL) {
					ValaPropertyAccessor* _tmp885_;
					ValaSemanticAnalyzer* _tmp886_;
					ValaSemanticAnalyzer* _tmp887_;
					ValaSymbol* _tmp888_;
					ValaSymbol* _tmp889_;
					_tmp885_ = acc;
					_tmp886_ = vala_code_context_get_analyzer (context);
					_tmp887_ = _tmp886_;
					_tmp888_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp887_);
					_tmp889_ = _tmp888_;
					_tmp883_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp885_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp889_;
				} else {
					_tmp883_ = FALSE;
				}
				if (_tmp883_) {
					ValaParameter* _tmp890_;
					ValaPropertyAccessor* _tmp891_;
					ValaProperty* _tmp892_;
					ValaProperty* _tmp893_;
					ValaParameter* _tmp894_;
					ValaParameter* _tmp895_;
					_tmp890_ = param;
					_tmp891_ = acc;
					_tmp892_ = vala_property_accessor_get_prop (_tmp891_);
					_tmp893_ = _tmp892_;
					_tmp894_ = vala_property_get_this_parameter (_tmp893_);
					_tmp895_ = _tmp894_;
					_tmp882_ = _tmp890_ != _tmp895_;
				} else {
					_tmp882_ = FALSE;
				}
				if (_tmp882_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp896_;
					ValaSemanticAnalyzer* _tmp897_;
					ValaSymbol* _tmp898_;
					ValaSymbol* _tmp899_;
					ValaParameter* _tmp908_;
					ValaPropertyAccessor* _tmp909_;
					ValaBlock* _tmp910_;
					ValaBlock* _tmp911_;
					_tmp896_ = vala_code_context_get_analyzer (context);
					_tmp897_ = _tmp896_;
					_tmp898_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp897_);
					_tmp899_ = _tmp898_;
					sym = _tmp899_;
					while (TRUE) {
						ValaSymbol* _tmp900_;
						ValaMethod* _tmp901_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp902_;
						ValaMethod* _tmp903_;
						ValaSymbol* _tmp905_;
						ValaSymbol* _tmp906_;
						ValaSymbol* _tmp907_;
						_tmp900_ = sym;
						_tmp901_ = m;
						if (!(_tmp900_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp901_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp902_ = sym;
						method = VALA_IS_METHOD (_tmp902_) ? ((ValaMethod*) _tmp902_) : NULL;
						_tmp903_ = method;
						if (_tmp903_ != NULL) {
							ValaMethod* _tmp904_;
							_tmp904_ = method;
							vala_method_set_closure (_tmp904_, TRUE);
						}
						_tmp905_ = sym;
						_tmp906_ = vala_symbol_get_parent_symbol (_tmp905_);
						_tmp907_ = _tmp906_;
						sym = _tmp907_;
					}
					_tmp908_ = param;
					vala_parameter_set_captured (_tmp908_, TRUE);
					_tmp909_ = acc;
					_tmp910_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp909_);
					_tmp911_ = _tmp910_;
					vala_block_set_captured (_tmp911_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp912_;
			_tmp912_ = member;
			if (VALA_IS_FIELD (_tmp912_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp913_;
				ValaField* _tmp914_;
				ValaSymbolAccessibility _tmp915_;
				ValaSymbolAccessibility _tmp916_;
				ValaField* _tmp917_;
				ValaMemberBinding _tmp918_;
				ValaMemberBinding _tmp919_;
				ValaField* _tmp920_;
				ValaMemberBinding _tmp921_;
				ValaMemberBinding _tmp922_;
				ValaField* _tmp923_;
				ValaDataType* _tmp924_;
				ValaDataType* _tmp925_;
				_tmp913_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp913_, VALA_TYPE_FIELD, ValaField);
				_tmp914_ = f;
				_tmp915_ = vala_symbol_get_access ((ValaSymbol*) _tmp914_);
				_tmp916_ = _tmp915_;
				access = _tmp916_;
				_tmp917_ = f;
				_tmp918_ = vala_field_get_binding (_tmp917_);
				_tmp919_ = _tmp918_;
				instance = _tmp919_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp920_ = f;
				_tmp921_ = vala_field_get_binding (_tmp920_);
				_tmp922_ = _tmp921_;
				klass = _tmp922_ == VALA_MEMBER_BINDING_CLASS;
				_tmp923_ = f;
				_tmp924_ = vala_variable_get_variable_type ((ValaVariable*) _tmp923_);
				_tmp925_ = _tmp924_;
				if (VALA_IS_GENERIC_TYPE (_tmp925_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp926_;
				_tmp926_ = member;
				if (VALA_IS_CONSTANT (_tmp926_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp927_;
					ValaConstant* _tmp928_;
					ValaSymbolAccessibility _tmp929_;
					ValaSymbolAccessibility _tmp930_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp931_;
					ValaSymbol* _tmp932_;
					ValaSymbol* _tmp933_;
					gboolean _tmp934_ = FALSE;
					ValaBlock* _tmp935_;
					_tmp927_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp927_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp928_ = c;
					_tmp929_ = vala_symbol_get_access ((ValaSymbol*) _tmp928_);
					_tmp930_ = _tmp929_;
					access = _tmp930_;
					_tmp931_ = c;
					_tmp932_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp931_);
					_tmp933_ = _tmp932_;
					block = VALA_IS_BLOCK (_tmp933_) ? ((ValaBlock*) _tmp933_) : NULL;
					_tmp935_ = block;
					if (_tmp935_ != NULL) {
						ValaBlock* _tmp936_;
						ValaSymbol* _tmp937_;
						ValaSemanticAnalyzer* _tmp938_;
						ValaSemanticAnalyzer* _tmp939_;
						ValaSymbol* _tmp940_;
						ValaSymbol* _tmp941_;
						_tmp936_ = block;
						_tmp937_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp936_);
						_tmp938_ = vala_code_context_get_analyzer (context);
						_tmp939_ = _tmp938_;
						_tmp940_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp939_);
						_tmp941_ = _tmp940_;
						_tmp934_ = _tmp937_ != _tmp941_;
					} else {
						_tmp934_ = FALSE;
					}
					if (_tmp934_) {
						ValaSourceReference* _tmp942_;
						ValaSourceReference* _tmp943_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp942_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp943_ = _tmp942_;
						vala_report_error (_tmp943_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp944_;
					_tmp944_ = member;
					if (VALA_IS_METHOD (_tmp944_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp945_;
						ValaMethod* _tmp946_;
						gboolean _tmp947_;
						gboolean _tmp948_;
						ValaMethod* _tmp1037_;
						ValaSymbolAccessibility _tmp1038_;
						ValaSymbolAccessibility _tmp1039_;
						ValaMethod* _tmp1040_;
						ValaMethod* _tmp1044_;
						ValaMemberBinding _tmp1045_;
						ValaMemberBinding _tmp1046_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1065_;
						ValaDataType* _tmp1066_;
						ValaDataType* _tmp1067_;
						gboolean _tmp1068_ = FALSE;
						ValaGenericType* _tmp1069_;
						_tmp945_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp945_, VALA_TYPE_METHOD, ValaMethod);
						_tmp946_ = m;
						_tmp947_ = vala_method_get_is_async_callback (_tmp946_);
						_tmp948_ = _tmp947_;
						if (_tmp948_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp949_;
							ValaSemanticAnalyzer* _tmp950_;
							ValaMethod* _tmp951_;
							ValaMethod* _tmp952_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp953_;
							ValaMethod* _tmp982_;
							ValaSemanticAnalyzer* _tmp983_;
							ValaSemanticAnalyzer* _tmp984_;
							ValaMethod* _tmp985_;
							ValaMethod* _tmp986_;
							ValaMethod* _tmp1002_;
							ValaMethod* _tmp1003_;
							ValaMethod* _tmp1004_;
							ValaSymbol* _tmp1005_;
							ValaSymbol* _tmp1006_;
							_tmp949_ = vala_code_context_get_analyzer (context);
							_tmp950_ = _tmp949_;
							_tmp951_ = vala_semantic_analyzer_get_current_async_method (_tmp950_);
							_tmp952_ = _tmp951_;
							async_method = _tmp952_;
							is_valid_access = FALSE;
							_tmp953_ = async_method;
							if (_tmp953_ != NULL) {
								ValaMethod* _tmp954_;
								ValaMethod* _tmp955_;
								ValaMethod* _tmp956_;
								_tmp954_ = m;
								_tmp955_ = async_method;
								_tmp956_ = vala_method_get_callback_method (_tmp955_);
								if (_tmp954_ == _tmp956_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp957_ = FALSE;
									ValaMethod* _tmp958_;
									ValaMethod* _tmp959_;
									ValaMethod* _tmp960_;
									_tmp958_ = async_method;
									_tmp959_ = vala_method_get_base_method (_tmp958_);
									_tmp960_ = _tmp959_;
									if (_tmp960_ != NULL) {
										ValaMethod* _tmp961_;
										ValaMethod* _tmp962_;
										ValaMethod* _tmp963_;
										ValaMethod* _tmp964_;
										ValaMethod* _tmp965_;
										_tmp961_ = m;
										_tmp962_ = async_method;
										_tmp963_ = vala_method_get_base_method (_tmp962_);
										_tmp964_ = _tmp963_;
										_tmp965_ = vala_method_get_callback_method (_tmp964_);
										_tmp957_ = _tmp961_ == _tmp965_;
									} else {
										_tmp957_ = FALSE;
									}
									if (_tmp957_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp966_ = FALSE;
										ValaMethod* _tmp967_;
										ValaMethod* _tmp968_;
										ValaMethod* _tmp969_;
										_tmp967_ = async_method;
										_tmp968_ = vala_method_get_base_interface_method (_tmp967_);
										_tmp969_ = _tmp968_;
										if (_tmp969_ != NULL) {
											ValaMethod* _tmp970_;
											ValaMethod* _tmp971_;
											ValaMethod* _tmp972_;
											ValaMethod* _tmp973_;
											ValaMethod* _tmp974_;
											_tmp970_ = m;
											_tmp971_ = async_method;
											_tmp972_ = vala_method_get_base_interface_method (_tmp971_);
											_tmp973_ = _tmp972_;
											_tmp974_ = vala_method_get_callback_method (_tmp973_);
											_tmp966_ = _tmp970_ == _tmp974_;
										} else {
											_tmp966_ = FALSE;
										}
										if (_tmp966_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp975_;
								ValaSourceReference* _tmp976_;
								ValaMethod* _tmp977_;
								gchar* _tmp978_;
								gchar* _tmp979_;
								gchar* _tmp980_;
								gchar* _tmp981_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp975_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp976_ = _tmp975_;
								_tmp977_ = m;
								_tmp978_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp977_);
								_tmp979_ = _tmp978_;
								_tmp980_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp979_);
								_tmp981_ = _tmp980_;
								vala_report_error (_tmp976_, _tmp981_);
								_g_free0 (_tmp981_);
								_g_free0 (_tmp979_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp982_ = async_method;
							_tmp983_ = vala_code_context_get_analyzer (context);
							_tmp984_ = _tmp983_;
							_tmp985_ = vala_semantic_analyzer_get_current_method (_tmp984_);
							_tmp986_ = _tmp985_;
							if (_tmp982_ != _tmp986_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp987_;
								ValaSemanticAnalyzer* _tmp988_;
								ValaMethod* _tmp989_;
								ValaMethod* _tmp990_;
								ValaMethod* _tmp999_;
								ValaBlock* _tmp1000_;
								ValaBlock* _tmp1001_;
								_tmp987_ = vala_code_context_get_analyzer (context);
								_tmp988_ = _tmp987_;
								_tmp989_ = vala_semantic_analyzer_get_current_method (_tmp988_);
								_tmp990_ = _tmp989_;
								sym = (ValaSymbol*) _tmp990_;
								while (TRUE) {
									ValaSymbol* _tmp991_;
									ValaMethod* _tmp992_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp993_;
									ValaMethod* _tmp994_;
									ValaSymbol* _tmp996_;
									ValaSymbol* _tmp997_;
									ValaSymbol* _tmp998_;
									_tmp991_ = sym;
									_tmp992_ = async_method;
									if (!(_tmp991_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp992_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp993_ = sym;
									method = VALA_IS_METHOD (_tmp993_) ? ((ValaMethod*) _tmp993_) : NULL;
									_tmp994_ = method;
									if (_tmp994_ != NULL) {
										ValaMethod* _tmp995_;
										_tmp995_ = method;
										vala_method_set_closure (_tmp995_, TRUE);
									}
									_tmp996_ = sym;
									_tmp997_ = vala_symbol_get_parent_symbol (_tmp996_);
									_tmp998_ = _tmp997_;
									sym = _tmp998_;
								}
								_tmp999_ = async_method;
								_tmp1000_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp999_);
								_tmp1001_ = _tmp1000_;
								vala_block_set_captured (_tmp1001_, TRUE);
							}
							_tmp1002_ = async_method;
							_tmp1003_ = vala_method_get_callback_method (_tmp1002_);
							m = _tmp1003_;
							_tmp1004_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1004_);
							_tmp1005_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1006_ = _tmp1005_;
							member = _tmp1006_;
						} else {
							ValaMethod* _tmp1007_;
							ValaMethod* _tmp1008_;
							ValaMethod* _tmp1009_;
							_tmp1007_ = m;
							_tmp1008_ = vala_method_get_base_method (_tmp1007_);
							_tmp1009_ = _tmp1008_;
							if (_tmp1009_ != NULL) {
								ValaMethod* _tmp1010_;
								ValaMethod* _tmp1011_;
								ValaMethod* _tmp1012_;
								ValaMethod* _tmp1013_;
								ValaSignal* _tmp1014_;
								ValaSignal* _tmp1015_;
								ValaSymbol* _tmp1020_;
								ValaSymbol* _tmp1021_;
								_tmp1010_ = m;
								_tmp1011_ = vala_method_get_base_method (_tmp1010_);
								_tmp1012_ = _tmp1011_;
								m = _tmp1012_;
								_tmp1013_ = m;
								_tmp1014_ = vala_method_get_signal_reference (_tmp1013_);
								_tmp1015_ = _tmp1014_;
								if (_tmp1015_ != NULL) {
									ValaMethod* _tmp1016_;
									ValaSignal* _tmp1017_;
									ValaSignal* _tmp1018_;
									_tmp1016_ = m;
									_tmp1017_ = vala_method_get_signal_reference (_tmp1016_);
									_tmp1018_ = _tmp1017_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1018_);
								} else {
									ValaMethod* _tmp1019_;
									_tmp1019_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1019_);
								}
								_tmp1020_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1021_ = _tmp1020_;
								member = _tmp1021_;
							} else {
								ValaMethod* _tmp1022_;
								ValaMethod* _tmp1023_;
								ValaMethod* _tmp1024_;
								_tmp1022_ = m;
								_tmp1023_ = vala_method_get_base_interface_method (_tmp1022_);
								_tmp1024_ = _tmp1023_;
								if (_tmp1024_ != NULL) {
									ValaMethod* _tmp1025_;
									ValaMethod* _tmp1026_;
									ValaMethod* _tmp1027_;
									ValaMethod* _tmp1028_;
									ValaSignal* _tmp1029_;
									ValaSignal* _tmp1030_;
									ValaSymbol* _tmp1035_;
									ValaSymbol* _tmp1036_;
									_tmp1025_ = m;
									_tmp1026_ = vala_method_get_base_interface_method (_tmp1025_);
									_tmp1027_ = _tmp1026_;
									m = _tmp1027_;
									_tmp1028_ = m;
									_tmp1029_ = vala_method_get_signal_reference (_tmp1028_);
									_tmp1030_ = _tmp1029_;
									if (_tmp1030_ != NULL) {
										ValaMethod* _tmp1031_;
										ValaSignal* _tmp1032_;
										ValaSignal* _tmp1033_;
										_tmp1031_ = m;
										_tmp1032_ = vala_method_get_signal_reference (_tmp1031_);
										_tmp1033_ = _tmp1032_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1033_);
									} else {
										ValaMethod* _tmp1034_;
										_tmp1034_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1034_);
									}
									_tmp1035_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1036_ = _tmp1035_;
									member = _tmp1036_;
								}
							}
						}
						_tmp1037_ = m;
						_tmp1038_ = vala_symbol_get_access ((ValaSymbol*) _tmp1037_);
						_tmp1039_ = _tmp1038_;
						access = _tmp1039_;
						_tmp1040_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1040_)) {
							ValaMethod* _tmp1041_;
							ValaMemberBinding _tmp1042_;
							ValaMemberBinding _tmp1043_;
							_tmp1041_ = m;
							_tmp1042_ = vala_method_get_binding (_tmp1041_);
							_tmp1043_ = _tmp1042_;
							instance = _tmp1043_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1044_ = m;
						_tmp1045_ = vala_method_get_binding (_tmp1044_);
						_tmp1046_ = _tmp1045_;
						klass = _tmp1046_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1047_;
							ValaList* _tmp1048_;
							ValaList* _tmp1049_;
							gint _param_size = 0;
							ValaList* _tmp1050_;
							gint _tmp1051_;
							gint _tmp1052_;
							gint _param_index = 0;
							_tmp1047_ = m;
							_tmp1048_ = vala_callable_get_parameters ((ValaCallable*) _tmp1047_);
							_tmp1049_ = _vala_iterable_ref0 (_tmp1048_);
							_param_list = _tmp1049_;
							_tmp1050_ = _param_list;
							_tmp1051_ = vala_collection_get_size ((ValaCollection*) _tmp1050_);
							_tmp1052_ = _tmp1051_;
							_param_size = _tmp1052_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp1053_;
								gpointer _tmp1054_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1055_;
								ValaDataType* _tmp1056_;
								ValaDataType* _tmp1057_;
								gboolean _tmp1058_ = FALSE;
								ValaGenericType* _tmp1059_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp1053_ = _param_list;
								_tmp1054_ = vala_list_get (_tmp1053_, _param_index);
								param = (ValaParameter*) _tmp1054_;
								_tmp1055_ = param;
								_tmp1056_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1055_);
								_tmp1057_ = _tmp1056_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1057_) ? ((ValaGenericType*) _tmp1057_) : NULL;
								_tmp1059_ = generic_type;
								if (_tmp1059_ != NULL) {
									ValaGenericType* _tmp1060_;
									ValaTypeParameter* _tmp1061_;
									ValaTypeParameter* _tmp1062_;
									ValaSymbol* _tmp1063_;
									ValaSymbol* _tmp1064_;
									_tmp1060_ = generic_type;
									_tmp1061_ = vala_generic_type_get_type_parameter (_tmp1060_);
									_tmp1062_ = _tmp1061_;
									_tmp1063_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1062_);
									_tmp1064_ = _tmp1063_;
									_tmp1058_ = VALA_IS_TYPESYMBOL (_tmp1064_);
								} else {
									_tmp1058_ = FALSE;
								}
								if (_tmp1058_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp1065_ = m;
						_tmp1066_ = vala_callable_get_return_type ((ValaCallable*) _tmp1065_);
						_tmp1067_ = _tmp1066_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1067_) ? ((ValaGenericType*) _tmp1067_) : NULL;
						_tmp1069_ = generic_type;
						if (_tmp1069_ != NULL) {
							ValaGenericType* _tmp1070_;
							ValaTypeParameter* _tmp1071_;
							ValaTypeParameter* _tmp1072_;
							ValaSymbol* _tmp1073_;
							ValaSymbol* _tmp1074_;
							_tmp1070_ = generic_type;
							_tmp1071_ = vala_generic_type_get_type_parameter (_tmp1070_);
							_tmp1072_ = _tmp1071_;
							_tmp1073_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1072_);
							_tmp1074_ = _tmp1073_;
							_tmp1068_ = VALA_IS_TYPESYMBOL (_tmp1074_);
						} else {
							_tmp1068_ = FALSE;
						}
						if (_tmp1068_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1075_;
						_tmp1075_ = member;
						if (VALA_IS_PROPERTY (_tmp1075_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1076_;
							ValaProperty* _tmp1077_;
							ValaProperty* _tmp1078_;
							ValaProperty* _tmp1079_;
							ValaProperty* _tmp1080_;
							ValaProperty* _tmp1096_;
							ValaSymbolAccessibility _tmp1097_;
							ValaSymbolAccessibility _tmp1098_;
							gboolean _tmp1099_;
							gboolean _tmp1100_;
							ValaProperty* _tmp1165_;
							ValaMemberBinding _tmp1166_;
							ValaMemberBinding _tmp1167_;
							ValaProperty* _tmp1168_;
							ValaDataType* _tmp1169_;
							ValaDataType* _tmp1170_;
							_tmp1076_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1076_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1077_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1077_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1078_ = prop;
							_tmp1079_ = vala_property_get_base_property (_tmp1078_);
							_tmp1080_ = _tmp1079_;
							if (_tmp1080_ != NULL) {
								ValaProperty* _tmp1081_;
								ValaProperty* _tmp1082_;
								ValaProperty* _tmp1083_;
								ValaProperty* _tmp1084_;
								ValaSymbol* _tmp1085_;
								ValaSymbol* _tmp1086_;
								_tmp1081_ = prop;
								_tmp1082_ = vala_property_get_base_property (_tmp1081_);
								_tmp1083_ = _tmp1082_;
								prop = _tmp1083_;
								_tmp1084_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1084_);
								_tmp1085_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1086_ = _tmp1085_;
								member = _tmp1086_;
							} else {
								ValaProperty* _tmp1087_;
								ValaProperty* _tmp1088_;
								ValaProperty* _tmp1089_;
								_tmp1087_ = prop;
								_tmp1088_ = vala_property_get_base_interface_property (_tmp1087_);
								_tmp1089_ = _tmp1088_;
								if (_tmp1089_ != NULL) {
									ValaProperty* _tmp1090_;
									ValaProperty* _tmp1091_;
									ValaProperty* _tmp1092_;
									ValaProperty* _tmp1093_;
									ValaSymbol* _tmp1094_;
									ValaSymbol* _tmp1095_;
									_tmp1090_ = prop;
									_tmp1091_ = vala_property_get_base_interface_property (_tmp1090_);
									_tmp1092_ = _tmp1091_;
									prop = _tmp1092_;
									_tmp1093_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1093_);
									_tmp1094_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1095_ = _tmp1094_;
									member = _tmp1095_;
								}
							}
							_tmp1096_ = prop;
							_tmp1097_ = vala_symbol_get_access ((ValaSymbol*) _tmp1096_);
							_tmp1098_ = _tmp1097_;
							access = _tmp1098_;
							_tmp1099_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1100_ = _tmp1099_;
							if (_tmp1100_) {
								ValaProperty* _tmp1101_;
								ValaPropertyAccessor* _tmp1102_;
								ValaPropertyAccessor* _tmp1103_;
								ValaProperty* _tmp1111_;
								ValaSymbolAccessibility _tmp1112_;
								ValaSymbolAccessibility _tmp1113_;
								_tmp1101_ = prop;
								_tmp1102_ = vala_property_get_set_accessor (_tmp1101_);
								_tmp1103_ = _tmp1102_;
								if (_tmp1103_ == NULL) {
									ValaSourceReference* _tmp1104_;
									ValaSourceReference* _tmp1105_;
									ValaProperty* _tmp1106_;
									gchar* _tmp1107_;
									gchar* _tmp1108_;
									gchar* _tmp1109_;
									gchar* _tmp1110_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1104_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1105_ = _tmp1104_;
									_tmp1106_ = prop;
									_tmp1107_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1106_);
									_tmp1108_ = _tmp1107_;
									_tmp1109_ = g_strdup_printf ("Property `%s' is read-only", _tmp1108_);
									_tmp1110_ = _tmp1109_;
									vala_report_error (_tmp1105_, _tmp1110_);
									_g_free0 (_tmp1110_);
									_g_free0 (_tmp1108_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1111_ = prop;
								_tmp1112_ = vala_symbol_get_access ((ValaSymbol*) _tmp1111_);
								_tmp1113_ = _tmp1112_;
								if (_tmp1113_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1114_;
									ValaPropertyAccessor* _tmp1115_;
									ValaPropertyAccessor* _tmp1116_;
									ValaSymbolAccessibility _tmp1117_;
									ValaSymbolAccessibility _tmp1118_;
									_tmp1114_ = prop;
									_tmp1115_ = vala_property_get_set_accessor (_tmp1114_);
									_tmp1116_ = _tmp1115_;
									_tmp1117_ = vala_symbol_get_access ((ValaSymbol*) _tmp1116_);
									_tmp1118_ = _tmp1117_;
									access = _tmp1118_;
								} else {
									gboolean _tmp1119_ = FALSE;
									ValaProperty* _tmp1120_;
									ValaSymbolAccessibility _tmp1121_;
									ValaSymbolAccessibility _tmp1122_;
									_tmp1120_ = prop;
									_tmp1121_ = vala_symbol_get_access ((ValaSymbol*) _tmp1120_);
									_tmp1122_ = _tmp1121_;
									if (_tmp1122_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1123_;
										ValaPropertyAccessor* _tmp1124_;
										ValaPropertyAccessor* _tmp1125_;
										ValaSymbolAccessibility _tmp1126_;
										ValaSymbolAccessibility _tmp1127_;
										_tmp1123_ = prop;
										_tmp1124_ = vala_property_get_set_accessor (_tmp1123_);
										_tmp1125_ = _tmp1124_;
										_tmp1126_ = vala_symbol_get_access ((ValaSymbol*) _tmp1125_);
										_tmp1127_ = _tmp1126_;
										_tmp1119_ = _tmp1127_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1119_ = FALSE;
									}
									if (_tmp1119_) {
										ValaProperty* _tmp1128_;
										ValaPropertyAccessor* _tmp1129_;
										ValaPropertyAccessor* _tmp1130_;
										ValaSymbolAccessibility _tmp1131_;
										ValaSymbolAccessibility _tmp1132_;
										_tmp1128_ = prop;
										_tmp1129_ = vala_property_get_set_accessor (_tmp1128_);
										_tmp1130_ = _tmp1129_;
										_tmp1131_ = vala_symbol_get_access ((ValaSymbol*) _tmp1130_);
										_tmp1132_ = _tmp1131_;
										access = _tmp1132_;
									}
								}
							} else {
								ValaProperty* _tmp1133_;
								ValaPropertyAccessor* _tmp1134_;
								ValaPropertyAccessor* _tmp1135_;
								ValaProperty* _tmp1143_;
								ValaSymbolAccessibility _tmp1144_;
								ValaSymbolAccessibility _tmp1145_;
								_tmp1133_ = prop;
								_tmp1134_ = vala_property_get_get_accessor (_tmp1133_);
								_tmp1135_ = _tmp1134_;
								if (_tmp1135_ == NULL) {
									ValaSourceReference* _tmp1136_;
									ValaSourceReference* _tmp1137_;
									ValaProperty* _tmp1138_;
									gchar* _tmp1139_;
									gchar* _tmp1140_;
									gchar* _tmp1141_;
									gchar* _tmp1142_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1136_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1137_ = _tmp1136_;
									_tmp1138_ = prop;
									_tmp1139_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1138_);
									_tmp1140_ = _tmp1139_;
									_tmp1141_ = g_strdup_printf ("Property `%s' is write-only", _tmp1140_);
									_tmp1142_ = _tmp1141_;
									vala_report_error (_tmp1137_, _tmp1142_);
									_g_free0 (_tmp1142_);
									_g_free0 (_tmp1140_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1143_ = prop;
								_tmp1144_ = vala_symbol_get_access ((ValaSymbol*) _tmp1143_);
								_tmp1145_ = _tmp1144_;
								if (_tmp1145_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1146_;
									ValaPropertyAccessor* _tmp1147_;
									ValaPropertyAccessor* _tmp1148_;
									ValaSymbolAccessibility _tmp1149_;
									ValaSymbolAccessibility _tmp1150_;
									_tmp1146_ = prop;
									_tmp1147_ = vala_property_get_get_accessor (_tmp1146_);
									_tmp1148_ = _tmp1147_;
									_tmp1149_ = vala_symbol_get_access ((ValaSymbol*) _tmp1148_);
									_tmp1150_ = _tmp1149_;
									access = _tmp1150_;
								} else {
									gboolean _tmp1151_ = FALSE;
									ValaProperty* _tmp1152_;
									ValaSymbolAccessibility _tmp1153_;
									ValaSymbolAccessibility _tmp1154_;
									_tmp1152_ = prop;
									_tmp1153_ = vala_symbol_get_access ((ValaSymbol*) _tmp1152_);
									_tmp1154_ = _tmp1153_;
									if (_tmp1154_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1155_;
										ValaPropertyAccessor* _tmp1156_;
										ValaPropertyAccessor* _tmp1157_;
										ValaSymbolAccessibility _tmp1158_;
										ValaSymbolAccessibility _tmp1159_;
										_tmp1155_ = prop;
										_tmp1156_ = vala_property_get_get_accessor (_tmp1155_);
										_tmp1157_ = _tmp1156_;
										_tmp1158_ = vala_symbol_get_access ((ValaSymbol*) _tmp1157_);
										_tmp1159_ = _tmp1158_;
										_tmp1151_ = _tmp1159_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1151_ = FALSE;
									}
									if (_tmp1151_) {
										ValaProperty* _tmp1160_;
										ValaPropertyAccessor* _tmp1161_;
										ValaPropertyAccessor* _tmp1162_;
										ValaSymbolAccessibility _tmp1163_;
										ValaSymbolAccessibility _tmp1164_;
										_tmp1160_ = prop;
										_tmp1161_ = vala_property_get_get_accessor (_tmp1160_);
										_tmp1162_ = _tmp1161_;
										_tmp1163_ = vala_symbol_get_access ((ValaSymbol*) _tmp1162_);
										_tmp1164_ = _tmp1163_;
										access = _tmp1164_;
									}
								}
							}
							_tmp1165_ = prop;
							_tmp1166_ = vala_property_get_binding (_tmp1165_);
							_tmp1167_ = _tmp1166_;
							instance = _tmp1167_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1168_ = prop;
							_tmp1169_ = vala_property_get_property_type (_tmp1168_);
							_tmp1170_ = _tmp1169_;
							if (VALA_IS_GENERIC_TYPE (_tmp1170_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1171_;
							_tmp1171_ = member;
							if (VALA_IS_SIGNAL (_tmp1171_)) {
								ValaSymbol* _tmp1172_;
								ValaSymbolAccessibility _tmp1173_;
								ValaSymbolAccessibility _tmp1174_;
								instance = TRUE;
								_tmp1172_ = member;
								_tmp1173_ = vala_symbol_get_access (_tmp1172_);
								_tmp1174_ = _tmp1173_;
								access = _tmp1174_;
							} else {
								gboolean _tmp1175_ = FALSE;
								gboolean _tmp1176_;
								_tmp1176_ = self->priv->_creation_member;
								if (!_tmp1176_) {
									ValaSymbol* _tmp1177_;
									_tmp1177_ = member;
									_tmp1175_ = VALA_IS_ERROR_CODE (_tmp1177_);
								} else {
									_tmp1175_ = FALSE;
								}
								if (_tmp1175_) {
									ValaSymbol* _tmp1178_;
									ValaConstant* _tmp1179_;
									ValaConstant* _tmp1180_;
									ValaSymbol* _tmp1181_;
									ValaSymbol* _tmp1182_;
									_tmp1178_ = member;
									_tmp1179_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1178_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1180_ = _tmp1179_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1180_);
									_tmp1181_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1182_ = _tmp1181_;
									member = _tmp1182_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1183_;
		ValaSymbol* _tmp1184_;
		ValaCodeNode* _tmp1185_;
		ValaCodeNode* _tmp1186_;
		ValaCodeNode* _tmp1187_;
		gboolean _tmp1188_ = FALSE;
		ValaCodeNode* _tmp1189_;
		_tmp1183_ = parent;
		_tmp1184_ = member;
		if (!(_tmp1183_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1184_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1185_ = parent;
		_tmp1186_ = vala_code_node_get_parent_node (_tmp1185_);
		_tmp1187_ = _tmp1186_;
		parent = _tmp1187_;
		_tmp1189_ = parent;
		if (_tmp1189_ == NULL) {
			_tmp1188_ = TRUE;
		} else {
			ValaCodeNode* _tmp1190_;
			ValaSymbol* _tmp1191_;
			_tmp1190_ = parent;
			_tmp1191_ = member;
			_tmp1188_ = _tmp1190_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1191_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1188_) {
			break;
		}
	}
	_tmp1192_ = parent;
	_tmp1193_ = member;
	if (_tmp1192_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1193_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1194_;
		_tmp1194_ = member;
		vala_symbol_set_used (_tmp1194_, TRUE);
	}
	_tmp1195_ = member;
	_tmp1196_ = vala_symbol_get_version (_tmp1195_);
	_tmp1197_ = _tmp1196_;
	_tmp1198_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1199_ = _tmp1198_;
	vala_version_attribute_check (_tmp1197_, context, _tmp1199_);
	_tmp1201_ = access;
	if (_tmp1201_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1202_;
		ValaSymbol* _tmp1203_;
		ValaSymbol* _tmp1204_;
		_tmp1202_ = member;
		_tmp1203_ = vala_symbol_get_parent_symbol (_tmp1202_);
		_tmp1204_ = _tmp1203_;
		_tmp1200_ = VALA_IS_TYPESYMBOL (_tmp1204_);
	} else {
		_tmp1200_ = FALSE;
	}
	if (_tmp1200_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1205_;
		ValaSymbol* _tmp1206_;
		ValaSymbol* _tmp1207_;
		gboolean in_subtype = FALSE;
		_tmp1205_ = member;
		_tmp1206_ = vala_symbol_get_parent_symbol (_tmp1205_);
		_tmp1207_ = _tmp1206_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1207_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1208_;
			ValaSemanticAnalyzer* _tmp1209_;
			ValaSymbol* _tmp1210_;
			ValaSymbol* _tmp1211_;
			ValaSymbol* _tmp1212_;
			_tmp1208_ = vala_code_context_get_analyzer (context);
			_tmp1209_ = _tmp1208_;
			_tmp1210_ = vala_semantic_analyzer_get_current_symbol (_tmp1209_);
			_tmp1211_ = _tmp1210_;
			_tmp1212_ = _vala_code_node_ref0 (_tmp1211_);
			this_symbol = _tmp1212_;
			{
				gboolean _tmp1213_ = FALSE;
				_tmp1213_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1218_;
					ValaSymbol* _tmp1219_;
					ValaTypeSymbol* _tmp1220_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1221_;
					gboolean _tmp1222_ = FALSE;
					ValaClass* _tmp1223_;
					if (!_tmp1213_) {
						ValaSymbol* _tmp1214_;
						ValaSymbol* _tmp1215_;
						ValaSymbol* _tmp1216_;
						ValaSymbol* _tmp1217_;
						_tmp1214_ = this_symbol;
						_tmp1215_ = vala_symbol_get_parent_symbol (_tmp1214_);
						_tmp1216_ = _tmp1215_;
						_tmp1217_ = _vala_code_node_ref0 (_tmp1216_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1217_;
					}
					_tmp1213_ = FALSE;
					_tmp1218_ = this_symbol;
					if (!(_tmp1218_ != NULL)) {
						break;
					}
					_tmp1219_ = this_symbol;
					_tmp1220_ = target_type;
					if (_tmp1219_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1220_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1221_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1221_) ? ((ValaClass*) _tmp1221_) : NULL;
					_tmp1223_ = cl;
					if (_tmp1223_ != NULL) {
						ValaClass* _tmp1224_;
						ValaTypeSymbol* _tmp1225_;
						_tmp1224_ = cl;
						_tmp1225_ = target_type;
						_tmp1222_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1224_, _tmp1225_);
					} else {
						_tmp1222_ = FALSE;
					}
					if (_tmp1222_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1226_;
			ValaSourceReference* _tmp1227_;
			ValaSymbol* _tmp1228_;
			gchar* _tmp1229_;
			gchar* _tmp1230_;
			gchar* _tmp1231_;
			gchar* _tmp1232_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1226_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1227_ = _tmp1226_;
			_tmp1228_ = member;
			_tmp1229_ = vala_symbol_get_full_name (_tmp1228_);
			_tmp1230_ = _tmp1229_;
			_tmp1231_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1230_);
			_tmp1232_ = _tmp1231_;
			vala_report_error (_tmp1227_, _tmp1232_);
			_g_free0 (_tmp1232_);
			_g_free0 (_tmp1230_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1233_;
		_tmp1233_ = access;
		if (_tmp1233_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1234_;
			ValaSymbol* _tmp1235_;
			ValaSymbol* _tmp1236_;
			gboolean in_target_type = FALSE;
			_tmp1234_ = member;
			_tmp1235_ = vala_symbol_get_parent_symbol (_tmp1234_);
			_tmp1236_ = _tmp1235_;
			target_type = _tmp1236_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1237_;
				ValaSemanticAnalyzer* _tmp1238_;
				ValaSymbol* _tmp1239_;
				ValaSymbol* _tmp1240_;
				ValaSymbol* _tmp1241_;
				_tmp1237_ = vala_code_context_get_analyzer (context);
				_tmp1238_ = _tmp1237_;
				_tmp1239_ = vala_semantic_analyzer_get_current_symbol (_tmp1238_);
				_tmp1240_ = _tmp1239_;
				_tmp1241_ = _vala_code_node_ref0 (_tmp1240_);
				this_symbol = _tmp1241_;
				{
					gboolean _tmp1242_ = FALSE;
					_tmp1242_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1247_;
						ValaSymbol* _tmp1248_;
						ValaSymbol* _tmp1249_;
						if (!_tmp1242_) {
							ValaSymbol* _tmp1243_;
							ValaSymbol* _tmp1244_;
							ValaSymbol* _tmp1245_;
							ValaSymbol* _tmp1246_;
							_tmp1243_ = this_symbol;
							_tmp1244_ = vala_symbol_get_parent_symbol (_tmp1243_);
							_tmp1245_ = _tmp1244_;
							_tmp1246_ = _vala_code_node_ref0 (_tmp1245_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1246_;
						}
						_tmp1242_ = FALSE;
						_tmp1247_ = this_symbol;
						if (!(_tmp1247_ != NULL)) {
							break;
						}
						_tmp1248_ = target_type;
						_tmp1249_ = this_symbol;
						if (_tmp1248_ == _tmp1249_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1250_;
				ValaSourceReference* _tmp1251_;
				ValaSymbol* _tmp1252_;
				gchar* _tmp1253_;
				gchar* _tmp1254_;
				gchar* _tmp1255_;
				gchar* _tmp1256_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1250_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1251_ = _tmp1250_;
				_tmp1252_ = member;
				_tmp1253_ = vala_symbol_get_full_name (_tmp1252_);
				_tmp1254_ = _tmp1253_;
				_tmp1255_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1254_);
				_tmp1256_ = _tmp1255_;
				vala_report_error (_tmp1251_, _tmp1256_);
				_g_free0 (_tmp1256_);
				_g_free0 (_tmp1254_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1258_;
		ValaExpression* _tmp1259_;
		_tmp1258_ = vala_member_access_get_inner (self);
		_tmp1259_ = _tmp1258_;
		_tmp1257_ = _tmp1259_ != NULL;
	} else {
		_tmp1257_ = FALSE;
	}
	if (_tmp1257_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1260_;
		ValaExpression* _tmp1261_;
		ValaDataType* _tmp1262_;
		ValaDataType* _tmp1263_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1264_;
		ValaExpression* _tmp1265_;
		ValaDataType* _tmp1266_;
		ValaDataType* _tmp1267_;
		ValaPointerType* _tmp1268_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1272_;
		gboolean _tmp1273_ = FALSE;
		gboolean _tmp1274_ = FALSE;
		ValaObjectType* _tmp1275_;
		_tmp1260_ = vala_member_access_get_inner (self);
		_tmp1261_ = _tmp1260_;
		_tmp1262_ = vala_expression_get_value_type (_tmp1261_);
		_tmp1263_ = _tmp1262_;
		instance_type = _tmp1263_;
		_tmp1264_ = vala_member_access_get_inner (self);
		_tmp1265_ = _tmp1264_;
		_tmp1266_ = vala_expression_get_value_type (_tmp1265_);
		_tmp1267_ = _tmp1266_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1267_) ? ((ValaPointerType*) _tmp1267_) : NULL;
		_tmp1268_ = pointer_type;
		if (_tmp1268_ != NULL) {
			ValaPointerType* _tmp1269_;
			ValaDataType* _tmp1270_;
			ValaDataType* _tmp1271_;
			_tmp1269_ = pointer_type;
			_tmp1270_ = vala_pointer_type_get_base_type (_tmp1269_);
			_tmp1271_ = _tmp1270_;
			instance_type = _tmp1271_;
		}
		_tmp1272_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1272_) ? ((ValaObjectType*) _tmp1272_) : NULL;
		_tmp1275_ = object_type;
		if (_tmp1275_ != NULL) {
			ValaObjectType* _tmp1276_;
			ValaObjectTypeSymbol* _tmp1277_;
			ValaObjectTypeSymbol* _tmp1278_;
			_tmp1276_ = object_type;
			_tmp1277_ = vala_object_type_get_object_type_symbol (_tmp1276_);
			_tmp1278_ = _tmp1277_;
			_tmp1274_ = vala_object_type_symbol_has_type_parameters (_tmp1278_);
		} else {
			_tmp1274_ = FALSE;
		}
		if (_tmp1274_) {
			ValaDataType* _tmp1279_;
			_tmp1279_ = instance_type;
			_tmp1273_ = !vala_data_type_has_type_arguments (_tmp1279_);
		} else {
			_tmp1273_ = FALSE;
		}
		if (_tmp1273_) {
			ValaExpression* _tmp1280_;
			ValaExpression* _tmp1281_;
			ValaSourceReference* _tmp1282_;
			ValaSourceReference* _tmp1283_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1280_ = vala_member_access_get_inner (self);
			_tmp1281_ = _tmp1280_;
			_tmp1282_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1281_);
			_tmp1283_ = _tmp1282_;
			vala_report_error (_tmp1283_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1285_ = !may_access_instance_members;
	} else {
		_tmp1285_ = FALSE;
	}
	if (_tmp1285_) {
		_tmp1284_ = TRUE;
	} else {
		gboolean _tmp1286_ = FALSE;
		if (klass) {
			_tmp1286_ = !may_access_klass_members;
		} else {
			_tmp1286_ = FALSE;
		}
		_tmp1284_ = _tmp1286_;
	}
	if (_tmp1284_) {
		ValaSymbol* _tmp1287_;
		ValaSymbol* _tmp1288_;
		ValaDataType* _tmp1311_;
		ValaDataType* _tmp1312_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1287_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1288_ = _tmp1287_;
		if (VALA_IS_METHOD (_tmp1288_)) {
			ValaSemanticAnalyzer* _tmp1289_;
			ValaSemanticAnalyzer* _tmp1290_;
			ValaSymbol* _tmp1291_;
			ValaSymbol* _tmp1292_;
			gboolean _tmp1293_;
			gboolean _tmp1294_;
			ValaDataType* _tmp1295_;
			ValaDataType* _tmp1296_;
			_tmp1289_ = vala_code_context_get_analyzer (context);
			_tmp1290_ = _tmp1289_;
			_tmp1291_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1292_ = _tmp1291_;
			_tmp1293_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1294_ = _tmp1293_;
			_tmp1295_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1290_, _tmp1292_, _tmp1294_);
			_tmp1296_ = _tmp1295_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1296_);
			_vala_code_node_unref0 (_tmp1296_);
		} else {
			ValaSymbol* _tmp1297_;
			ValaSymbol* _tmp1298_;
			_tmp1297_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1298_ = _tmp1297_;
			if (VALA_IS_FIELD (_tmp1298_)) {
				ValaSymbol* _tmp1299_;
				ValaSymbol* _tmp1300_;
				ValaFieldPrototype* _tmp1301_;
				ValaFieldPrototype* _tmp1302_;
				_tmp1299_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1300_ = _tmp1299_;
				_tmp1301_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1300_, VALA_TYPE_FIELD, ValaField));
				_tmp1302_ = _tmp1301_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1302_);
				_vala_code_node_unref0 (_tmp1302_);
			} else {
				ValaSymbol* _tmp1303_;
				ValaSymbol* _tmp1304_;
				_tmp1303_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1304_ = _tmp1303_;
				if (VALA_IS_PROPERTY (_tmp1304_)) {
					ValaSymbol* _tmp1305_;
					ValaSymbol* _tmp1306_;
					ValaPropertyPrototype* _tmp1307_;
					ValaPropertyPrototype* _tmp1308_;
					_tmp1305_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1306_ = _tmp1305_;
					_tmp1307_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1306_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1308_ = _tmp1307_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1308_);
					_vala_code_node_unref0 (_tmp1308_);
				} else {
					ValaInvalidType* _tmp1309_;
					ValaInvalidType* _tmp1310_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1309_ = vala_invalid_type_new ();
					_tmp1310_ = _tmp1309_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1310_);
					_vala_code_node_unref0 (_tmp1310_);
				}
			}
		}
		_tmp1311_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1312_ = _tmp1311_;
		if (_tmp1312_ != NULL) {
			ValaDataType* _tmp1313_;
			ValaDataType* _tmp1314_;
			ValaDataType* _tmp1315_;
			ValaDataType* _tmp1316_;
			gboolean _tmp1317_;
			gboolean _tmp1318_;
			_tmp1313_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1314_ = _tmp1313_;
			_tmp1315_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1316_ = _tmp1315_;
			_tmp1317_ = vala_data_type_get_value_owned (_tmp1316_);
			_tmp1318_ = _tmp1317_;
			vala_data_type_set_value_owned (_tmp1314_, _tmp1318_);
		}
	} else {
		gboolean _tmp1319_ = FALSE;
		gboolean _tmp1340_ = FALSE;
		gboolean _tmp1341_ = FALSE;
		gboolean _tmp1342_ = FALSE;
		gboolean _tmp1343_ = FALSE;
		gboolean _tmp1385_ = FALSE;
		gboolean _tmp1386_ = FALSE;
		gboolean _tmp1387_ = FALSE;
		gboolean _tmp1388_ = FALSE;
		gboolean _tmp1389_ = FALSE;
		gboolean _tmp1390_;
		gboolean _tmp1391_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1418_;
		ValaSymbol* _tmp1419_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1420_;
		ValaExpression* _tmp1421_;
		gboolean _tmp1422_ = FALSE;
		gboolean _tmp1423_ = FALSE;
		gboolean _tmp1424_ = FALSE;
		gboolean _tmp1425_ = FALSE;
		gboolean _tmp1426_ = FALSE;
		ValaMethod* _tmp1427_;
		ValaSemanticAnalyzer* _tmp1464_;
		ValaSemanticAnalyzer* _tmp1465_;
		ValaSymbol* _tmp1466_;
		ValaSymbol* _tmp1467_;
		gboolean _tmp1468_;
		gboolean _tmp1469_;
		ValaDataType* _tmp1470_;
		ValaDataType* _tmp1471_;
		gboolean _tmp1472_ = FALSE;
		ValaExpression* _tmp1473_;
		ValaExpression* _tmp1474_;
		ValaSymbol* _tmp1487_;
		ValaSymbol* _tmp1488_;
		if (instance) {
			ValaExpression* _tmp1320_;
			ValaExpression* _tmp1321_;
			_tmp1320_ = vala_member_access_get_inner (self);
			_tmp1321_ = _tmp1320_;
			_tmp1319_ = _tmp1321_ == NULL;
		} else {
			_tmp1319_ = FALSE;
		}
		if (_tmp1319_) {
			ValaSourceReference* _tmp1322_;
			ValaSourceReference* _tmp1323_;
			ValaMemberAccess* _tmp1324_;
			ValaMemberAccess* _tmp1325_;
			ValaExpression* _tmp1326_;
			ValaExpression* _tmp1327_;
			ValaParameter* _tmp1328_;
			ValaDataType* _tmp1329_;
			ValaDataType* _tmp1330_;
			ValaDataType* _tmp1331_;
			ValaDataType* _tmp1332_;
			ValaExpression* _tmp1333_;
			ValaExpression* _tmp1334_;
			ValaDataType* _tmp1335_;
			ValaDataType* _tmp1336_;
			ValaExpression* _tmp1337_;
			ValaExpression* _tmp1338_;
			ValaParameter* _tmp1339_;
			_tmp1322_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1323_ = _tmp1322_;
			_tmp1324_ = vala_member_access_new (NULL, "this", _tmp1323_);
			_tmp1325_ = _tmp1324_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1325_);
			_vala_code_node_unref0 (_tmp1325_);
			_tmp1326_ = vala_member_access_get_inner (self);
			_tmp1327_ = _tmp1326_;
			_tmp1328_ = this_parameter;
			_tmp1329_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1328_);
			_tmp1330_ = _tmp1329_;
			_tmp1331_ = vala_data_type_copy (_tmp1330_);
			_tmp1332_ = _tmp1331_;
			vala_expression_set_value_type (_tmp1327_, _tmp1332_);
			_vala_code_node_unref0 (_tmp1332_);
			_tmp1333_ = vala_member_access_get_inner (self);
			_tmp1334_ = _tmp1333_;
			_tmp1335_ = vala_expression_get_value_type (_tmp1334_);
			_tmp1336_ = _tmp1335_;
			vala_data_type_set_value_owned (_tmp1336_, FALSE);
			_tmp1337_ = vala_member_access_get_inner (self);
			_tmp1338_ = _tmp1337_;
			_tmp1339_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1338_, (ValaSymbol*) _tmp1339_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1343_ = !klass;
		} else {
			_tmp1343_ = FALSE;
		}
		if (_tmp1343_) {
			ValaSymbol* _tmp1344_;
			ValaSymbol* _tmp1345_;
			_tmp1344_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1345_ = _tmp1344_;
			_tmp1342_ = !VALA_IS_CREATION_METHOD (_tmp1345_);
		} else {
			_tmp1342_ = FALSE;
		}
		if (_tmp1342_) {
			_tmp1341_ = may_access_instance_members;
		} else {
			_tmp1341_ = FALSE;
		}
		if (_tmp1341_) {
			ValaExpression* _tmp1346_;
			ValaExpression* _tmp1347_;
			_tmp1346_ = vala_member_access_get_inner (self);
			_tmp1347_ = _tmp1346_;
			_tmp1340_ = _tmp1347_ != NULL;
		} else {
			_tmp1340_ = FALSE;
		}
		if (_tmp1340_) {
			ValaExpression* _tmp1348_;
			ValaExpression* _tmp1349_;
			ValaSymbol* _tmp1350_;
			ValaSymbol* _tmp1351_;
			_tmp1348_ = vala_member_access_get_inner (self);
			_tmp1349_ = _tmp1348_;
			_tmp1350_ = vala_expression_get_symbol_reference (_tmp1349_);
			_tmp1351_ = _tmp1350_;
			if (VALA_IS_METHOD (_tmp1351_)) {
			} else {
				ValaSourceReference* _tmp1352_;
				ValaSourceReference* _tmp1353_;
				ValaSymbol* _tmp1354_;
				ValaSymbol* _tmp1355_;
				gchar* _tmp1356_;
				gchar* _tmp1357_;
				gchar* _tmp1358_;
				gchar* _tmp1359_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1360_;
				ValaSymbol* _tmp1361_;
				ValaSymbol* _tmp1362_;
				ValaSymbol* _tmp1363_;
				ValaMemberAccess* inner_ma = NULL;
				ValaExpression* _tmp1383_;
				ValaExpression* _tmp1384_;
				_tmp1352_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1353_ = _tmp1352_;
				_tmp1354_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1355_ = _tmp1354_;
				_tmp1356_ = vala_symbol_get_full_name (_tmp1355_);
				_tmp1357_ = _tmp1356_;
				_tmp1358_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1357_);
				_tmp1359_ = _tmp1358_;
				vala_report_warning (_tmp1353_, _tmp1359_);
				_g_free0 (_tmp1359_);
				_g_free0 (_tmp1357_);
				_tmp1360_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1361_ = _tmp1360_;
				_tmp1362_ = vala_symbol_get_parent_symbol (_tmp1361_);
				_tmp1363_ = _tmp1362_;
				inner_sym = _tmp1363_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1364_ = FALSE;
					ValaSymbol* _tmp1365_;
					ValaMemberAccess* _tmp1369_;
					ValaSymbol* _tmp1370_;
					const gchar* _tmp1371_;
					const gchar* _tmp1372_;
					ValaSourceReference* _tmp1373_;
					ValaSourceReference* _tmp1374_;
					ValaMemberAccess* _tmp1375_;
					ValaMemberAccess* _tmp1376_;
					ValaMemberAccess* _tmp1377_;
					ValaExpression* _tmp1378_;
					ValaExpression* _tmp1379_;
					ValaSymbol* _tmp1380_;
					ValaSymbol* _tmp1381_;
					ValaSymbol* _tmp1382_;
					_tmp1365_ = inner_sym;
					if (_tmp1365_ != NULL) {
						ValaSymbol* _tmp1366_;
						const gchar* _tmp1367_;
						const gchar* _tmp1368_;
						_tmp1366_ = inner_sym;
						_tmp1367_ = vala_symbol_get_name (_tmp1366_);
						_tmp1368_ = _tmp1367_;
						_tmp1364_ = _tmp1368_ != NULL;
					} else {
						_tmp1364_ = FALSE;
					}
					if (!_tmp1364_) {
						break;
					}
					_tmp1369_ = inner_ma;
					_tmp1370_ = inner_sym;
					_tmp1371_ = vala_symbol_get_name (_tmp1370_);
					_tmp1372_ = _tmp1371_;
					_tmp1373_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1374_ = _tmp1373_;
					_tmp1375_ = vala_member_access_new (NULL, _tmp1372_, _tmp1374_);
					_tmp1376_ = _tmp1375_;
					vala_member_access_set_inner (_tmp1369_, (ValaExpression*) _tmp1376_);
					_vala_code_node_unref0 (_tmp1376_);
					_tmp1377_ = inner_ma;
					_tmp1378_ = vala_member_access_get_inner (_tmp1377_);
					_tmp1379_ = _tmp1378_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1379_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1380_ = inner_sym;
					_tmp1381_ = vala_symbol_get_parent_symbol (_tmp1380_);
					_tmp1382_ = _tmp1381_;
					inner_sym = _tmp1382_;
				}
				_tmp1383_ = vala_member_access_get_inner (self);
				_tmp1384_ = _tmp1383_;
				vala_code_node_check ((ValaCodeNode*) _tmp1384_, context);
			}
		}
		_tmp1390_ = vala_code_context_get_experimental_non_null (context);
		_tmp1391_ = _tmp1390_;
		if (_tmp1391_) {
			_tmp1389_ = instance;
		} else {
			_tmp1389_ = FALSE;
		}
		if (_tmp1389_) {
			ValaExpression* _tmp1392_;
			ValaExpression* _tmp1393_;
			ValaDataType* _tmp1394_;
			ValaDataType* _tmp1395_;
			gboolean _tmp1396_;
			gboolean _tmp1397_;
			_tmp1392_ = vala_member_access_get_inner (self);
			_tmp1393_ = _tmp1392_;
			_tmp1394_ = vala_expression_get_value_type (_tmp1393_);
			_tmp1395_ = _tmp1394_;
			_tmp1396_ = vala_data_type_get_nullable (_tmp1395_);
			_tmp1397_ = _tmp1396_;
			_tmp1388_ = _tmp1397_;
		} else {
			_tmp1388_ = FALSE;
		}
		if (_tmp1388_) {
			ValaExpression* _tmp1398_;
			ValaExpression* _tmp1399_;
			ValaDataType* _tmp1400_;
			ValaDataType* _tmp1401_;
			_tmp1398_ = vala_member_access_get_inner (self);
			_tmp1399_ = _tmp1398_;
			_tmp1400_ = vala_expression_get_value_type (_tmp1399_);
			_tmp1401_ = _tmp1400_;
			_tmp1387_ = !VALA_IS_POINTER_TYPE (_tmp1401_);
		} else {
			_tmp1387_ = FALSE;
		}
		if (_tmp1387_) {
			ValaExpression* _tmp1402_;
			ValaExpression* _tmp1403_;
			ValaDataType* _tmp1404_;
			ValaDataType* _tmp1405_;
			_tmp1402_ = vala_member_access_get_inner (self);
			_tmp1403_ = _tmp1402_;
			_tmp1404_ = vala_expression_get_value_type (_tmp1403_);
			_tmp1405_ = _tmp1404_;
			_tmp1386_ = !VALA_IS_GENERIC_TYPE (_tmp1405_);
		} else {
			_tmp1386_ = FALSE;
		}
		if (_tmp1386_) {
			ValaExpression* _tmp1406_;
			ValaExpression* _tmp1407_;
			ValaDataType* _tmp1408_;
			ValaDataType* _tmp1409_;
			_tmp1406_ = vala_member_access_get_inner (self);
			_tmp1407_ = _tmp1406_;
			_tmp1408_ = vala_expression_get_value_type (_tmp1407_);
			_tmp1409_ = _tmp1408_;
			_tmp1385_ = !VALA_IS_ARRAY_TYPE (_tmp1409_);
		} else {
			_tmp1385_ = FALSE;
		}
		if (_tmp1385_) {
			ValaSourceReference* _tmp1410_;
			ValaSourceReference* _tmp1411_;
			ValaSymbol* _tmp1412_;
			ValaSymbol* _tmp1413_;
			gchar* _tmp1414_;
			gchar* _tmp1415_;
			gchar* _tmp1416_;
			gchar* _tmp1417_;
			_tmp1410_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1411_ = _tmp1410_;
			_tmp1412_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1413_ = _tmp1412_;
			_tmp1414_ = vala_symbol_get_full_name (_tmp1413_);
			_tmp1415_ = _tmp1414_;
			_tmp1416_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1415_);
			_tmp1417_ = _tmp1416_;
			vala_report_error (_tmp1411_, _tmp1417_);
			_g_free0 (_tmp1417_);
			_g_free0 (_tmp1415_);
		}
		_tmp1418_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1419_ = _tmp1418_;
		m = VALA_IS_METHOD (_tmp1419_) ? ((ValaMethod*) _tmp1419_) : NULL;
		_tmp1420_ = vala_member_access_get_inner (self);
		_tmp1421_ = _tmp1420_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1421_) ? ((ValaMemberAccess*) _tmp1421_) : NULL;
		_tmp1427_ = m;
		if (_tmp1427_ != NULL) {
			ValaMethod* _tmp1428_;
			ValaMemberBinding _tmp1429_;
			ValaMemberBinding _tmp1430_;
			_tmp1428_ = m;
			_tmp1429_ = vala_method_get_binding (_tmp1428_);
			_tmp1430_ = _tmp1429_;
			_tmp1426_ = _tmp1430_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1426_ = FALSE;
		}
		if (_tmp1426_) {
			ValaMethod* _tmp1431_;
			ValaSymbol* _tmp1432_;
			ValaSymbol* _tmp1433_;
			_tmp1431_ = m;
			_tmp1432_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1431_);
			_tmp1433_ = _tmp1432_;
			_tmp1425_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1433_);
		} else {
			_tmp1425_ = FALSE;
		}
		if (_tmp1425_) {
			ValaExpression* _tmp1434_;
			ValaExpression* _tmp1435_;
			_tmp1434_ = vala_member_access_get_inner (self);
			_tmp1435_ = _tmp1434_;
			_tmp1424_ = _tmp1435_ != NULL;
		} else {
			_tmp1424_ = FALSE;
		}
		if (_tmp1424_) {
			ValaExpression* _tmp1436_;
			ValaExpression* _tmp1437_;
			ValaDataType* _tmp1438_;
			ValaDataType* _tmp1439_;
			_tmp1436_ = vala_member_access_get_inner (self);
			_tmp1437_ = _tmp1436_;
			_tmp1438_ = vala_expression_get_value_type (_tmp1437_);
			_tmp1439_ = _tmp1438_;
			_tmp1423_ = _tmp1439_ == NULL;
		} else {
			_tmp1423_ = FALSE;
		}
		if (_tmp1423_) {
			ValaMemberAccess* _tmp1440_;
			ValaList* _tmp1441_;
			gint _tmp1442_;
			gint _tmp1443_;
			_tmp1440_ = inner_ma;
			_tmp1441_ = _tmp1440_->priv->type_argument_list;
			_tmp1442_ = vala_collection_get_size ((ValaCollection*) _tmp1441_);
			_tmp1443_ = _tmp1442_;
			_tmp1422_ = _tmp1443_ > 0;
		} else {
			_tmp1422_ = FALSE;
		}
		if (_tmp1422_) {
			ValaExpression* _tmp1444_;
			ValaExpression* _tmp1445_;
			ValaMethod* _tmp1446_;
			ValaSymbol* _tmp1447_;
			ValaSymbol* _tmp1448_;
			ValaObjectType* _tmp1449_;
			ValaObjectType* _tmp1450_;
			_tmp1444_ = vala_member_access_get_inner (self);
			_tmp1445_ = _tmp1444_;
			_tmp1446_ = m;
			_tmp1447_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1446_);
			_tmp1448_ = _tmp1447_;
			_tmp1449_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1448_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1450_ = _tmp1449_;
			vala_expression_set_value_type (_tmp1445_, (ValaDataType*) _tmp1450_);
			_vala_code_node_unref0 (_tmp1450_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1451_;
				ValaList* _tmp1452_;
				ValaList* _tmp1453_;
				gint _type_argument_size = 0;
				ValaList* _tmp1454_;
				gint _tmp1455_;
				gint _tmp1456_;
				gint _type_argument_index = 0;
				_tmp1451_ = inner_ma;
				_tmp1452_ = _tmp1451_->priv->type_argument_list;
				_tmp1453_ = _vala_iterable_ref0 (_tmp1452_);
				_type_argument_list = _tmp1453_;
				_tmp1454_ = _type_argument_list;
				_tmp1455_ = vala_collection_get_size ((ValaCollection*) _tmp1454_);
				_tmp1456_ = _tmp1455_;
				_type_argument_size = _tmp1456_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1457_;
					gpointer _tmp1458_;
					ValaExpression* _tmp1459_;
					ValaExpression* _tmp1460_;
					ValaDataType* _tmp1461_;
					ValaDataType* _tmp1462_;
					ValaDataType* _tmp1463_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1457_ = _type_argument_list;
					_tmp1458_ = vala_list_get (_tmp1457_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1458_;
					_tmp1459_ = vala_member_access_get_inner (self);
					_tmp1460_ = _tmp1459_;
					_tmp1461_ = vala_expression_get_value_type (_tmp1460_);
					_tmp1462_ = _tmp1461_;
					_tmp1463_ = type_argument;
					vala_data_type_add_type_argument (_tmp1462_, _tmp1463_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1464_ = vala_code_context_get_analyzer (context);
		_tmp1465_ = _tmp1464_;
		_tmp1466_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1467_ = _tmp1466_;
		_tmp1468_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1469_ = _tmp1468_;
		_tmp1470_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1465_, _tmp1467_, _tmp1469_);
		_tmp1471_ = _tmp1470_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1471_);
		_vala_code_node_unref0 (_tmp1471_);
		_tmp1473_ = vala_member_access_get_inner (self);
		_tmp1474_ = _tmp1473_;
		if (_tmp1474_ != NULL) {
			ValaDataType* _tmp1475_;
			ValaDataType* _tmp1476_;
			_tmp1475_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1476_ = _tmp1475_;
			_tmp1472_ = _tmp1476_ != NULL;
		} else {
			_tmp1472_ = FALSE;
		}
		if (_tmp1472_) {
			ValaDataType* _tmp1477_;
			ValaDataType* _tmp1478_;
			ValaExpression* _tmp1479_;
			ValaExpression* _tmp1480_;
			ValaDataType* _tmp1481_;
			ValaDataType* _tmp1482_;
			ValaDataType* _tmp1483_;
			ValaDataType* _tmp1484_;
			_tmp1477_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1478_ = _tmp1477_;
			_tmp1479_ = vala_member_access_get_inner (self);
			_tmp1480_ = _tmp1479_;
			_tmp1481_ = vala_expression_get_value_type (_tmp1480_);
			_tmp1482_ = _tmp1481_;
			_tmp1483_ = vala_data_type_get_actual_type (_tmp1478_, _tmp1482_, NULL, (ValaCodeNode*) self);
			_tmp1484_ = _tmp1483_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1484_);
			_vala_code_node_unref0 (_tmp1484_);
		} else {
			ValaDataType* _tmp1485_;
			ValaDataType* _tmp1486_;
			_tmp1485_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1486_ = _tmp1485_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1486_);
		}
		_tmp1487_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1488_ = _tmp1487_;
		if (VALA_IS_METHOD (_tmp1488_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1489_;
			ValaSymbol* _tmp1490_;
			ValaDataType* _tmp1491_;
			ValaDataType* _tmp1492_;
			gboolean _tmp1499_ = FALSE;
			_tmp1489_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1490_ = _tmp1489_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1490_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1491_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1492_ = _tmp1491_;
			if (_tmp1492_ != NULL) {
				ValaDataType* _tmp1493_;
				ValaDataType* _tmp1494_;
				ValaDataType* _tmp1495_;
				ValaDataType* _tmp1496_;
				gboolean _tmp1497_;
				gboolean _tmp1498_;
				_tmp1493_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1494_ = _tmp1493_;
				_tmp1495_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1496_ = _tmp1495_;
				_tmp1497_ = vala_data_type_get_value_owned (_tmp1496_);
				_tmp1498_ = _tmp1497_;
				vala_data_type_set_value_owned (_tmp1494_, _tmp1498_);
			}
			if (instance) {
				ValaMethod* _tmp1500_;
				ValaSymbol* _tmp1501_;
				ValaSymbol* _tmp1502_;
				_tmp1500_ = method;
				_tmp1501_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1500_);
				_tmp1502_ = _tmp1501_;
				_tmp1499_ = VALA_IS_TYPESYMBOL (_tmp1502_);
			} else {
				_tmp1499_ = FALSE;
			}
			if (_tmp1499_) {
				ValaExpression* _tmp1503_;
				ValaExpression* _tmp1504_;
				ValaMethod* _tmp1505_;
				ValaSymbol* _tmp1506_;
				ValaSymbol* _tmp1507_;
				ValaDataType* _tmp1508_;
				ValaDataType* _tmp1509_;
				ValaExpression* _tmp1510_;
				ValaExpression* _tmp1511_;
				ValaDataType* _tmp1512_;
				ValaDataType* _tmp1513_;
				ValaMethod* _tmp1514_;
				ValaParameter* _tmp1515_;
				ValaParameter* _tmp1516_;
				ValaDataType* _tmp1517_;
				ValaDataType* _tmp1518_;
				gboolean _tmp1519_;
				gboolean _tmp1520_;
				_tmp1503_ = vala_member_access_get_inner (self);
				_tmp1504_ = _tmp1503_;
				_tmp1505_ = method;
				_tmp1506_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1505_);
				_tmp1507_ = _tmp1506_;
				_tmp1508_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1507_);
				_tmp1509_ = _tmp1508_;
				vala_expression_set_target_type (_tmp1504_, _tmp1509_);
				_vala_code_node_unref0 (_tmp1509_);
				_tmp1510_ = vala_member_access_get_inner (self);
				_tmp1511_ = _tmp1510_;
				_tmp1512_ = vala_expression_get_target_type (_tmp1511_);
				_tmp1513_ = _tmp1512_;
				_tmp1514_ = method;
				_tmp1515_ = vala_method_get_this_parameter (_tmp1514_);
				_tmp1516_ = _tmp1515_;
				_tmp1517_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1516_);
				_tmp1518_ = _tmp1517_;
				_tmp1519_ = vala_data_type_get_value_owned (_tmp1518_);
				_tmp1520_ = _tmp1519_;
				vala_data_type_set_value_owned (_tmp1513_, _tmp1520_);
			}
		} else {
			gboolean _tmp1521_ = FALSE;
			gboolean _tmp1522_ = FALSE;
			ValaSymbol* _tmp1523_;
			ValaSymbol* _tmp1524_;
			_tmp1523_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1524_ = _tmp1523_;
			if (VALA_IS_PROPERTY (_tmp1524_)) {
				_tmp1522_ = instance;
			} else {
				_tmp1522_ = FALSE;
			}
			if (_tmp1522_) {
				ValaSymbol* _tmp1525_;
				ValaSymbol* _tmp1526_;
				ValaSymbol* _tmp1527_;
				ValaSymbol* _tmp1528_;
				_tmp1525_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1526_ = _tmp1525_;
				_tmp1527_ = vala_symbol_get_parent_symbol (_tmp1526_);
				_tmp1528_ = _tmp1527_;
				_tmp1521_ = _tmp1528_ != NULL;
			} else {
				_tmp1521_ = FALSE;
			}
			if (_tmp1521_) {
				ValaExpression* _tmp1529_;
				ValaExpression* _tmp1530_;
				ValaSymbol* _tmp1531_;
				ValaSymbol* _tmp1532_;
				ValaSymbol* _tmp1533_;
				ValaSymbol* _tmp1534_;
				ValaDataType* _tmp1535_;
				ValaDataType* _tmp1536_;
				_tmp1529_ = vala_member_access_get_inner (self);
				_tmp1530_ = _tmp1529_;
				_tmp1531_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1532_ = _tmp1531_;
				_tmp1533_ = vala_symbol_get_parent_symbol (_tmp1532_);
				_tmp1534_ = _tmp1533_;
				_tmp1535_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1534_);
				_tmp1536_ = _tmp1535_;
				vala_expression_set_target_type (_tmp1530_, _tmp1536_);
				_vala_code_node_unref0 (_tmp1536_);
			} else {
				gboolean _tmp1537_ = FALSE;
				gboolean _tmp1538_ = FALSE;
				gboolean _tmp1539_ = FALSE;
				ValaSymbol* _tmp1540_;
				ValaSymbol* _tmp1541_;
				_tmp1540_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1541_ = _tmp1540_;
				if (VALA_IS_FIELD (_tmp1541_)) {
					_tmp1539_ = TRUE;
				} else {
					ValaSymbol* _tmp1542_;
					ValaSymbol* _tmp1543_;
					_tmp1542_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1543_ = _tmp1542_;
					_tmp1539_ = VALA_IS_SIGNAL (_tmp1543_);
				}
				if (_tmp1539_) {
					_tmp1538_ = instance;
				} else {
					_tmp1538_ = FALSE;
				}
				if (_tmp1538_) {
					ValaSymbol* _tmp1544_;
					ValaSymbol* _tmp1545_;
					ValaSymbol* _tmp1546_;
					ValaSymbol* _tmp1547_;
					_tmp1544_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1545_ = _tmp1544_;
					_tmp1546_ = vala_symbol_get_parent_symbol (_tmp1545_);
					_tmp1547_ = _tmp1546_;
					_tmp1537_ = _tmp1547_ != NULL;
				} else {
					_tmp1537_ = FALSE;
				}
				if (_tmp1537_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1548_;
					ValaSymbol* _tmp1549_;
					ValaSymbol* _tmp1550_;
					ValaSymbol* _tmp1551_;
					ValaDataType* _tmp1552_;
					ValaExpression* _tmp1553_;
					ValaExpression* _tmp1554_;
					ValaDataType* _tmp1555_;
					ValaExpression* _tmp1556_;
					ValaExpression* _tmp1557_;
					ValaDataType* _tmp1558_;
					ValaDataType* _tmp1559_;
					ValaDataType* _tmp1560_;
					ValaDataType* _tmp1561_;
					_tmp1548_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1549_ = _tmp1548_;
					_tmp1550_ = vala_symbol_get_parent_symbol (_tmp1549_);
					_tmp1551_ = _tmp1550_;
					_tmp1552_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1551_);
					parent_type = _tmp1552_;
					_tmp1553_ = vala_member_access_get_inner (self);
					_tmp1554_ = _tmp1553_;
					_tmp1555_ = parent_type;
					_tmp1556_ = vala_member_access_get_inner (self);
					_tmp1557_ = _tmp1556_;
					_tmp1558_ = vala_expression_get_value_type (_tmp1557_);
					_tmp1559_ = _tmp1558_;
					_tmp1560_ = vala_data_type_get_actual_type (_tmp1555_, _tmp1559_, NULL, (ValaCodeNode*) self);
					_tmp1561_ = _tmp1560_;
					vala_expression_set_target_type (_tmp1554_, _tmp1561_);
					_vala_code_node_unref0 (_tmp1561_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
	}
	_tmp1562_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1563_ = _tmp1562_;
	if (_tmp1563_ != NULL) {
		ValaDataType* _tmp1564_;
		ValaDataType* _tmp1565_;
		_tmp1564_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1565_ = _tmp1564_;
		vala_code_node_check ((ValaCodeNode*) _tmp1565_, context);
	}
	_tmp1566_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1567_ = _tmp1566_;
	result = !_tmp1567_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

