/* valaarraycreationexpression.c generated by valac, the Vala compiler
 * generated from valaarraycreationexpression.vala, do not modify */

/* valaarraycreationexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaArrayCreationExpressionPrivate {
	gint _rank;
	ValaList* sizes;
	ValaDataType* _element_type;
	ValaDataType* _length_type;
	ValaInitializerList* _initializer_list;
};

static gint ValaArrayCreationExpression_private_offset;
static gpointer vala_array_creation_expression_parent_class = NULL;

static void vala_array_creation_expression_real_accept_children (ValaCodeNode* base,
                                                          ValaCodeVisitor* visitor);
static void vala_array_creation_expression_real_accept (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static gboolean vala_array_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_array_creation_expression_real_is_accessible (ValaExpression* base,
                                                            ValaSymbol* sym);
static gchar* vala_array_creation_expression_real_to_string (ValaCodeNode* base);
static void vala_array_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                             ValaExpression* old_node,
                                                             ValaExpression* new_node);
static void vala_array_creation_expression_real_replace_type (ValaCodeNode* base,
                                                       ValaDataType* old_type,
                                                       ValaDataType* new_type);
static gint vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self,
                                                                        ValaCodeContext* context,
                                                                        ValaInitializerList* il,
                                                                        gint rank,
                                                                        ValaList* sl);
static gboolean vala_array_creation_expression_real_check (ValaCodeNode* base,
                                                    ValaCodeContext* context);
static void vala_array_creation_expression_real_emit (ValaCodeNode* base,
                                               ValaCodeGenerator* codegen);
static void vala_array_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                             ValaCollection* collection);
static void vala_array_creation_expression_finalize (ValaCodeNode * obj);
static GType vala_array_creation_expression_get_type_once (void);

static inline gpointer
vala_array_creation_expression_get_instance_private (ValaArrayCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaArrayCreationExpression_private_offset);
}

ValaDataType*
vala_array_creation_expression_get_element_type (ValaArrayCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_element_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_array_creation_expression_set_element_type (ValaArrayCreationExpression* self,
                                                 ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_element_type);
	self->priv->_element_type = _tmp0_;
	_tmp1_ = self->priv->_element_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaDataType*
vala_array_creation_expression_get_length_type (ValaArrayCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_length_type;
	result = _tmp0_;
	return result;
}

void
vala_array_creation_expression_set_length_type (ValaArrayCreationExpression* self,
                                                ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_length_type);
	self->priv->_length_type = _tmp0_;
	_tmp1_ = self->priv->_length_type;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		_tmp2_ = self->priv->_length_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

gint
vala_array_creation_expression_get_rank (ValaArrayCreationExpression* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_rank;
	return result;
}

void
vala_array_creation_expression_set_rank (ValaArrayCreationExpression* self,
                                         gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_rank = value;
}

ValaInitializerList*
vala_array_creation_expression_get_initializer_list (ValaArrayCreationExpression* self)
{
	ValaInitializerList* result;
	ValaInitializerList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_initializer_list;
	result = _tmp0_;
	return result;
}

void
vala_array_creation_expression_set_initializer_list (ValaArrayCreationExpression* self,
                                                     ValaInitializerList* value)
{
	ValaInitializerList* _tmp0_;
	ValaInitializerList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_initializer_list);
	self->priv->_initializer_list = _tmp0_;
	_tmp1_ = self->priv->_initializer_list;
	if (_tmp1_ != NULL) {
		ValaInitializerList* _tmp2_;
		_tmp2_ = self->priv->_initializer_list;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

/**
 * Add a size expression.
 */
void
vala_array_creation_expression_append_size (ValaArrayCreationExpression* self,
                                            ValaExpression* size)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (size != NULL);
	_tmp0_ = self->priv->sizes;
	vala_collection_add ((ValaCollection*) _tmp0_, size);
	if (size != NULL) {
		vala_code_node_set_parent_node ((ValaCodeNode*) size, (ValaCodeNode*) self);
	}
}

/**
 * Get the sizes for all dimensions ascending from left to right.
 */
ValaList*
vala_array_creation_expression_get_sizes (ValaArrayCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sizes;
	result = _tmp0_;
	return result;
}

ValaArrayCreationExpression*
vala_array_creation_expression_construct (GType object_type,
                                          ValaDataType* element_type,
                                          gint rank,
                                          ValaInitializerList* initializer_list,
                                          ValaSourceReference* source_reference)
{
	ValaArrayCreationExpression* self = NULL;
	g_return_val_if_fail (element_type != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaArrayCreationExpression*) vala_expression_construct (object_type);
	vala_array_creation_expression_set_element_type (self, element_type);
	vala_array_creation_expression_set_rank (self, rank);
	vala_array_creation_expression_set_initializer_list (self, initializer_list);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaArrayCreationExpression*
vala_array_creation_expression_new (ValaDataType* element_type,
                                    gint rank,
                                    ValaInitializerList* initializer_list,
                                    ValaSourceReference* source_reference)
{
	return vala_array_creation_expression_construct (VALA_TYPE_ARRAY_CREATION_EXPRESSION, element_type, rank, initializer_list, source_reference);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_array_creation_expression_real_accept_children (ValaCodeNode* base,
                                                     ValaCodeVisitor* visitor)
{
	ValaArrayCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaInitializerList* _tmp16_;
	ValaInitializerList* _tmp17_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_array_creation_expression_get_element_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_array_creation_expression_get_element_type (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_array_creation_expression_get_length_type (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp6_ = vala_array_creation_expression_get_length_type (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _e_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _e_index = 0;
		_tmp8_ = self->priv->sizes;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_e_list = _tmp9_;
		_tmp10_ = _e_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_e_size = _tmp12_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaExpression* _tmp15_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp13_ = _e_list;
			_tmp14_ = vala_list_get (_tmp13_, _e_index);
			e = (ValaExpression*) _tmp14_;
			_tmp15_ = e;
			vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp16_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaInitializerList* _tmp18_;
		ValaInitializerList* _tmp19_;
		_tmp18_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp19_ = _tmp18_;
		vala_code_node_accept ((ValaCodeNode*) _tmp19_, visitor);
	}
}

static void
vala_array_creation_expression_real_accept (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_array_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gboolean
vala_array_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaArrayCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaArrayCreationExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_array_creation_expression_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym)
{
	ValaArrayCreationExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	gboolean _tmp5_ = FALSE;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaInitializerList* _tmp18_;
	ValaInitializerList* _tmp19_;
	gboolean result = FALSE;
	self = (ValaArrayCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_array_creation_expression_get_element_type (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		_tmp3_ = vala_array_creation_expression_get_element_type (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_data_type_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_array_creation_expression_get_length_type (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_array_creation_expression_get_length_type (self);
		_tmp9_ = _tmp8_;
		_tmp5_ = !vala_data_type_is_accessible (_tmp9_, sym);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _e_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _e_index = 0;
		_tmp10_ = self->priv->sizes;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_e_list = _tmp11_;
		_tmp12_ = _e_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_e_size = _tmp14_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaExpression* _tmp17_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp15_ = _e_list;
			_tmp16_ = vala_list_get (_tmp15_, _e_index);
			e = (ValaExpression*) _tmp16_;
			_tmp17_ = e;
			if (!vala_expression_is_accessible (_tmp17_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (e);
				_vala_iterable_unref0 (_e_list);
				return result;
			}
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp18_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		ValaInitializerList* _tmp20_;
		ValaInitializerList* _tmp21_;
		_tmp20_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp21_ = _tmp20_;
		result = vala_expression_is_accessible ((ValaExpression*) _tmp21_, sym);
		return result;
	}
	result = TRUE;
	return result;
}

static gchar*
vala_array_creation_expression_real_to_string (ValaCodeNode* base)
{
	ValaArrayCreationExpression * self;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean first = FALSE;
	GString* _tmp21_;
	ValaInitializerList* _tmp22_;
	ValaInitializerList* _tmp23_;
	GString* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* result = NULL;
	self = (ValaArrayCreationExpression*) base;
	_tmp0_ = g_string_new ("new ");
	builder = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = vala_array_creation_expression_get_element_type (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_code_node_to_string ((ValaCodeNode*) _tmp3_);
	_tmp5_ = _tmp4_;
	g_string_append_printf (_tmp1_, "%s[", _tmp5_);
	_g_free0 (_tmp5_);
	first = TRUE;
	{
		ValaList* _size_list = NULL;
		ValaList* _tmp6_;
		ValaList* _tmp7_;
		gint _size_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _size_index = 0;
		_tmp6_ = self->priv->sizes;
		_tmp7_ = _vala_iterable_ref0 (_tmp6_);
		_size_list = _tmp7_;
		_tmp8_ = _size_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_size_size = _tmp10_;
		_size_index = -1;
		while (TRUE) {
			ValaExpression* size = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			_size_index = _size_index + 1;
			if (!(_size_index < _size_size)) {
				break;
			}
			_tmp11_ = _size_list;
			_tmp12_ = vala_list_get (_tmp11_, _size_index);
			size = (ValaExpression*) _tmp12_;
			if (first) {
				GString* _tmp13_;
				ValaExpression* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp13_ = builder;
				_tmp14_ = size;
				_tmp15_ = vala_code_node_to_string ((ValaCodeNode*) _tmp14_);
				_tmp16_ = _tmp15_;
				g_string_append (_tmp13_, _tmp16_);
				_g_free0 (_tmp16_);
				first = FALSE;
			} else {
				GString* _tmp17_;
				ValaExpression* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp17_ = builder;
				_tmp18_ = size;
				_tmp19_ = vala_code_node_to_string ((ValaCodeNode*) _tmp18_);
				_tmp20_ = _tmp19_;
				g_string_append_printf (_tmp17_, ", %s", _tmp20_);
				_g_free0 (_tmp20_);
			}
			_vala_code_node_unref0 (size);
		}
		_vala_iterable_unref0 (_size_list);
	}
	_tmp21_ = builder;
	g_string_append_c (_tmp21_, ']');
	_tmp22_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp23_ = _tmp22_;
	if (_tmp23_ != NULL) {
		GString* _tmp24_;
		ValaInitializerList* _tmp25_;
		ValaInitializerList* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp24_ = builder;
		_tmp25_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_code_node_to_string ((ValaCodeNode*) _tmp26_);
		_tmp28_ = _tmp27_;
		g_string_append (_tmp24_, _tmp28_);
		_g_free0 (_tmp28_);
	}
	_tmp29_ = builder;
	_tmp30_ = _tmp29_->str;
	_tmp31_ = g_strdup (_tmp30_);
	result = _tmp31_;
	_g_string_free0 (builder);
	return result;
}

static void
vala_array_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                        ValaExpression* old_node,
                                                        ValaExpression* new_node)
{
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaExpression* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->sizes;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->sizes;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaExpression*) _tmp6_;
				_tmp8_ = _tmp7_ == old_node;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->sizes;
					vala_list_set (_tmp9_, i, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static void
vala_array_creation_expression_real_replace_type (ValaCodeNode* base,
                                                  ValaDataType* old_type,
                                                  ValaDataType* new_type)
{
	ValaArrayCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_array_creation_expression_get_element_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_array_creation_expression_set_element_type (self, new_type);
	}
	_tmp2_ = vala_array_creation_expression_get_length_type (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_array_creation_expression_set_length_type (self, new_type);
	}
}

static gint
vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self,
                                                                   ValaCodeContext* context,
                                                                   ValaInitializerList* il,
                                                                   gint rank,
                                                                   ValaList* sl)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint subsize = 0;
	gint _tmp39_;
	gint _tmp40_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (context != NULL, 0);
	g_return_val_if_fail (il != NULL, 0);
	g_return_val_if_fail (sl != NULL, 0);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) sl);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_rank;
	if (_tmp1_ == (_tmp2_ - rank)) {
		ValaIntegerLiteral* init = NULL;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaIntegerLiteral* _tmp9_;
		ValaIntegerLiteral* _tmp10_;
		ValaIntegerLiteral* _tmp11_;
		ValaIntegerLiteral* _tmp12_;
		_tmp3_ = vala_initializer_list_get_size (il);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("%i", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) il);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_integer_literal_new (_tmp6_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp6_);
		init = _tmp10_;
		_tmp11_ = init;
		vala_code_node_check ((ValaCodeNode*) _tmp11_, context);
		_tmp12_ = init;
		vala_collection_add ((ValaCollection*) sl, (ValaLiteral*) _tmp12_);
		_vala_code_node_unref0 (init);
	}
	subsize = -1;
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _e_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _e_index = 0;
		_tmp13_ = vala_initializer_list_get_initializers (il);
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_e_list = _tmp14_;
		_tmp15_ = _e_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_e_size = _tmp17_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp18_;
			gpointer _tmp19_;
			gboolean _tmp20_ = FALSE;
			ValaExpression* _tmp21_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp18_ = _e_list;
			_tmp19_ = vala_list_get (_tmp18_, _e_index);
			e = (ValaExpression*) _tmp19_;
			_tmp21_ = e;
			if (VALA_IS_INITIALIZER_LIST (_tmp21_)) {
				ValaExpression* _tmp22_;
				ValaDataType* _tmp23_;
				ValaDataType* _tmp24_;
				_tmp22_ = e;
				_tmp23_ = vala_expression_get_target_type (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp20_ = VALA_IS_ARRAY_TYPE (_tmp24_);
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				gint size = 0;
				ValaExpression* _tmp29_;
				gboolean _tmp30_ = FALSE;
				if (rank == 1) {
					ValaExpression* _tmp25_;
					ValaExpression* _tmp26_;
					ValaSourceReference* _tmp27_;
					ValaSourceReference* _tmp28_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp25_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp25_, TRUE);
					_tmp26_ = e;
					_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp26_);
					_tmp28_ = _tmp27_;
					vala_report_error (_tmp28_, "Expected array element, got array initializer list");
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
				_tmp29_ = e;
				size = vala_array_creation_expression_create_sizes_from_initializer_list (self, context, G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList), rank - 1, sl);
				if (size == -1) {
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
				if (subsize >= 0) {
					_tmp30_ = subsize != size;
				} else {
					_tmp30_ = FALSE;
				}
				if (_tmp30_) {
					ValaSourceReference* _tmp31_;
					ValaSourceReference* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) il);
					_tmp32_ = _tmp31_;
					_tmp33_ = g_strdup_printf ("Expected initializer list of size %d, got size %d", subsize, size);
					_tmp34_ = _tmp33_;
					vala_report_error (_tmp32_, _tmp34_);
					_g_free0 (_tmp34_);
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				} else {
					subsize = size;
				}
			} else {
				if (rank != 1) {
					ValaExpression* _tmp35_;
					ValaExpression* _tmp36_;
					ValaSourceReference* _tmp37_;
					ValaSourceReference* _tmp38_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp35_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp35_, TRUE);
					_tmp36_ = e;
					_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp36_);
					_tmp38_ = _tmp37_;
					vala_report_error (_tmp38_, "Expected array initializer list, got array element");
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
			}
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp39_ = vala_initializer_list_get_size (il);
	_tmp40_ = _tmp39_;
	result = _tmp40_;
	return result;
}

static gboolean
vala_array_creation_expression_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context)
{
	ValaArrayCreationExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaList* sizes = NULL;
	ValaList* _tmp4_;
	ValaList* _tmp5_;
	ValaInitializerList* initlist = NULL;
	ValaInitializerList* _tmp6_;
	ValaInitializerList* _tmp7_;
	ValaInitializerList* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaArrayList* calc_sizes = NULL;
	GEqualFunc _tmp36_;
	ValaArrayList* _tmp37_;
	ValaInitializerList* _tmp38_;
	ValaList* _tmp85_;
	gint _tmp86_;
	gint _tmp87_;
	gboolean _tmp119_;
	gboolean _tmp120_;
	gboolean _tmp121_ = FALSE;
	ValaInitializerList* _tmp122_;
	ValaInitializerList* _tmp123_;
	ValaDataType* _tmp128_;
	ValaDataType* _tmp129_;
	ValaDataType* _tmp132_;
	ValaDataType* _tmp133_;
	gint _tmp134_;
	ValaSourceReference* _tmp135_;
	ValaSourceReference* _tmp136_;
	ValaArrayType* _tmp137_;
	ValaArrayType* _tmp138_;
	ValaDataType* _tmp139_;
	ValaDataType* _tmp140_;
	ValaDataType* _tmp141_;
	ValaDataType* _tmp142_;
	ValaDataType* _tmp143_;
	ValaDataType* _tmp144_;
	ValaDataType* _tmp145_;
	ValaDataType* _tmp146_;
	ValaDataType* _tmp147_;
	ValaDataType* _tmp148_;
	gboolean _tmp149_;
	gboolean _tmp150_;
	gboolean result = FALSE;
	self = (ValaArrayCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_array_creation_expression_get_sizes (self);
	_tmp5_ = _vala_iterable_ref0 (_tmp4_);
	sizes = _tmp5_;
	_tmp6_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (_tmp7_);
	initlist = _tmp8_;
	_tmp9_ = vala_array_creation_expression_get_element_type (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		_tmp11_ = vala_array_creation_expression_get_element_type (self);
		_tmp12_ = _tmp11_;
		vala_code_node_check ((ValaCodeNode*) _tmp12_, context);
	}
	_tmp13_ = vala_array_creation_expression_get_length_type (self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ == NULL) {
		ValaSemanticAnalyzer* _tmp15_;
		ValaSemanticAnalyzer* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaDataType* _tmp19_;
		_tmp15_ = vala_code_context_get_analyzer (context);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_->int_type;
		_tmp18_ = vala_data_type_copy (_tmp17_);
		_tmp19_ = _tmp18_;
		vala_array_creation_expression_set_length_type (self, _tmp19_);
		_vala_code_node_unref0 (_tmp19_);
	} else {
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		_tmp20_ = vala_array_creation_expression_get_length_type (self);
		_tmp21_ = _tmp20_;
		vala_code_node_check ((ValaCodeNode*) _tmp21_, context);
		_tmp22_ = vala_array_creation_expression_get_length_type (self);
		_tmp23_ = _tmp22_;
		if (!VALA_IS_INTEGER_TYPE (_tmp23_)) {
			ValaDataType* _tmp24_;
			ValaDataType* _tmp25_;
			ValaSourceReference* _tmp26_;
			ValaSourceReference* _tmp27_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp24_ = vala_array_creation_expression_get_length_type (self);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp25_);
			_tmp27_ = _tmp26_;
			vala_report_error (_tmp27_, "Expected integer type as length type of array");
		}
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp28_;
		ValaList* _tmp29_;
		gint _e_size = 0;
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _e_index = 0;
		_tmp28_ = sizes;
		_tmp29_ = _vala_iterable_ref0 (_tmp28_);
		_e_list = _tmp29_;
		_tmp30_ = _e_list;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_e_size = _tmp32_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp33_;
			gpointer _tmp34_;
			ValaExpression* _tmp35_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp33_ = _e_list;
			_tmp34_ = vala_list_get (_tmp33_, _e_index);
			e = (ValaExpression*) _tmp34_;
			_tmp35_ = e;
			vala_code_node_check ((ValaCodeNode*) _tmp35_, context);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp36_ = g_direct_equal;
	_tmp37_ = vala_array_list_new (VALA_TYPE_LITERAL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp36_);
	calc_sizes = _tmp37_;
	_tmp38_ = initlist;
	if (_tmp38_ != NULL) {
		ValaInitializerList* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		gint _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaSourceReference* _tmp44_;
		ValaArrayType* _tmp45_;
		ValaArrayType* _tmp46_;
		ValaInitializerList* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		ValaDataType* _tmp50_;
		ValaDataType* _tmp51_;
		ValaDataType* _tmp52_;
		ValaDataType* _tmp53_;
		ValaInitializerList* _tmp54_;
		gint ret = 0;
		ValaInitializerList* _tmp55_;
		gint _tmp56_;
		ValaArrayList* _tmp57_;
		ValaArrayList* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		_tmp39_ = initlist;
		_tmp40_ = vala_array_creation_expression_get_element_type (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = self->priv->_rank;
		_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_array_type_new (_tmp41_, _tmp42_, _tmp44_);
		_tmp46_ = _tmp45_;
		vala_expression_set_target_type ((ValaExpression*) _tmp39_, (ValaDataType*) _tmp46_);
		_vala_code_node_unref0 (_tmp46_);
		_tmp47_ = initlist;
		_tmp48_ = vala_expression_get_target_type ((ValaExpression*) _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_array_creation_expression_get_length_type (self);
		_tmp51_ = _tmp50_;
		_tmp52_ = vala_data_type_copy (_tmp51_);
		_tmp53_ = _tmp52_;
		vala_array_type_set_length_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp53_);
		_vala_code_node_unref0 (_tmp53_);
		_tmp54_ = initlist;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp54_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
		_tmp55_ = initlist;
		_tmp56_ = self->priv->_rank;
		_tmp57_ = calc_sizes;
		ret = vala_array_creation_expression_create_sizes_from_initializer_list (self, context, _tmp55_, _tmp56_, (ValaList*) _tmp57_);
		if (ret == -1) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
		_tmp58_ = calc_sizes;
		_tmp59_ = vala_collection_get_size ((ValaCollection*) _tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = self->priv->_rank;
		if (_tmp60_ != _tmp61_) {
			ValaArrayType* actual_type = NULL;
			ValaDataType* _tmp62_;
			ValaDataType* _tmp63_;
			ValaArrayList* _tmp64_;
			gint _tmp65_;
			gint _tmp66_;
			ValaSourceReference* _tmp67_;
			ValaSourceReference* _tmp68_;
			ValaArrayType* _tmp69_;
			ValaArrayType* _tmp70_;
			ValaDataType* _tmp71_;
			ValaDataType* _tmp72_;
			ValaInitializerList* _tmp73_;
			ValaSourceReference* _tmp74_;
			ValaSourceReference* _tmp75_;
			ValaDataType* _tmp76_;
			ValaDataType* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			ValaArrayType* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			gchar* _tmp84_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp62_ = vala_array_creation_expression_get_element_type (self);
			_tmp63_ = _tmp62_;
			_tmp64_ = calc_sizes;
			_tmp65_ = vala_collection_get_size ((ValaCollection*) _tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp68_ = _tmp67_;
			_tmp69_ = vala_array_type_new (_tmp63_, _tmp66_, _tmp68_);
			actual_type = _tmp69_;
			_tmp70_ = actual_type;
			_tmp71_ = vala_array_creation_expression_get_length_type (self);
			_tmp72_ = _tmp71_;
			vala_array_type_set_length_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp72_);
			_tmp73_ = initlist;
			_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp77_ = _tmp76_;
			_tmp78_ = vala_code_node_to_string ((ValaCodeNode*) _tmp77_);
			_tmp79_ = _tmp78_;
			_tmp80_ = actual_type;
			_tmp81_ = vala_code_node_to_string ((ValaCodeNode*) _tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = g_strdup_printf ("Expected initializer for `%s' but got `%s'", _tmp79_, _tmp82_);
			_tmp84_ = _tmp83_;
			vala_report_error (_tmp75_, _tmp84_);
			_g_free0 (_tmp84_);
			_g_free0 (_tmp82_);
			_g_free0 (_tmp79_);
			_vala_code_node_unref0 (actual_type);
		}
	}
	_tmp85_ = sizes;
	_tmp86_ = vala_collection_get_size ((ValaCollection*) _tmp85_);
	_tmp87_ = _tmp86_;
	if (_tmp87_ > 0) {
		{
			ValaList* _e_list = NULL;
			ValaList* _tmp88_;
			ValaList* _tmp89_;
			gint _e_size = 0;
			ValaList* _tmp90_;
			gint _tmp91_;
			gint _tmp92_;
			gint _e_index = 0;
			_tmp88_ = sizes;
			_tmp89_ = _vala_iterable_ref0 (_tmp88_);
			_e_list = _tmp89_;
			_tmp90_ = _e_list;
			_tmp91_ = vala_collection_get_size ((ValaCollection*) _tmp90_);
			_tmp92_ = _tmp91_;
			_e_size = _tmp92_;
			_e_index = -1;
			while (TRUE) {
				ValaExpression* e = NULL;
				ValaList* _tmp93_;
				gpointer _tmp94_;
				ValaExpression* _tmp95_;
				ValaDataType* _tmp96_;
				ValaDataType* _tmp97_;
				_e_index = _e_index + 1;
				if (!(_e_index < _e_size)) {
					break;
				}
				_tmp93_ = _e_list;
				_tmp94_ = vala_list_get (_tmp93_, _e_index);
				e = (ValaExpression*) _tmp94_;
				_tmp95_ = e;
				_tmp96_ = vala_expression_get_value_type (_tmp95_);
				_tmp97_ = _tmp96_;
				if (_tmp97_ == NULL) {
					result = FALSE;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					_vala_iterable_unref0 (calc_sizes);
					_vala_code_node_unref0 (initlist);
					_vala_iterable_unref0 (sizes);
					return result;
				} else {
					gboolean _tmp98_ = FALSE;
					ValaExpression* _tmp99_;
					ValaDataType* _tmp100_;
					ValaDataType* _tmp101_;
					_tmp99_ = e;
					_tmp100_ = vala_expression_get_value_type (_tmp99_);
					_tmp101_ = _tmp100_;
					if (VALA_IS_INTEGER_TYPE (_tmp101_)) {
						_tmp98_ = TRUE;
					} else {
						ValaExpression* _tmp102_;
						ValaDataType* _tmp103_;
						ValaDataType* _tmp104_;
						_tmp102_ = e;
						_tmp103_ = vala_expression_get_value_type (_tmp102_);
						_tmp104_ = _tmp103_;
						_tmp98_ = VALA_IS_ENUM_VALUE_TYPE (_tmp104_);
					}
					if (!_tmp98_) {
						ValaExpression* _tmp105_;
						ValaSourceReference* _tmp106_;
						ValaSourceReference* _tmp107_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp105_ = e;
						_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp105_);
						_tmp107_ = _tmp106_;
						vala_report_error (_tmp107_, "Expression of integer type expected");
					}
				}
				_vala_code_node_unref0 (e);
			}
			_vala_iterable_unref0 (_e_list);
		}
	} else {
		ValaInitializerList* _tmp108_;
		_tmp108_ = initlist;
		if (_tmp108_ == NULL) {
			ValaSourceReference* _tmp109_;
			ValaSourceReference* _tmp110_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp110_ = _tmp109_;
			vala_report_error (_tmp110_, "internal error: initializer list expected");
		} else {
			{
				ValaArrayList* _size_list = NULL;
				ValaArrayList* _tmp111_;
				ValaArrayList* _tmp112_;
				gint _size_size = 0;
				ValaArrayList* _tmp113_;
				gint _tmp114_;
				gint _tmp115_;
				gint _size_index = 0;
				_tmp111_ = calc_sizes;
				_tmp112_ = _vala_iterable_ref0 (_tmp111_);
				_size_list = _tmp112_;
				_tmp113_ = _size_list;
				_tmp114_ = vala_collection_get_size ((ValaCollection*) _tmp113_);
				_tmp115_ = _tmp114_;
				_size_size = _tmp115_;
				_size_index = -1;
				while (TRUE) {
					ValaExpression* size = NULL;
					ValaArrayList* _tmp116_;
					gpointer _tmp117_;
					ValaExpression* _tmp118_;
					_size_index = _size_index + 1;
					if (!(_size_index < _size_size)) {
						break;
					}
					_tmp116_ = _size_list;
					_tmp117_ = vala_list_get ((ValaList*) _tmp116_, _size_index);
					size = (ValaExpression*) ((ValaLiteral*) _tmp117_);
					_tmp118_ = size;
					vala_array_creation_expression_append_size (self, _tmp118_);
					_vala_code_node_unref0 (size);
				}
				_vala_iterable_unref0 (_size_list);
			}
		}
	}
	_tmp119_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp120_ = _tmp119_;
	if (_tmp120_) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp122_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp123_ = _tmp122_;
	if (_tmp123_ != NULL) {
		ValaInitializerList* _tmp124_;
		ValaInitializerList* _tmp125_;
		ValaDataType* _tmp126_;
		ValaDataType* _tmp127_;
		_tmp124_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp125_ = _tmp124_;
		_tmp126_ = vala_expression_get_value_type ((ValaExpression*) _tmp125_);
		_tmp127_ = _tmp126_;
		_tmp121_ = _tmp127_ == NULL;
	} else {
		_tmp121_ = FALSE;
	}
	if (_tmp121_) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp128_ = vala_array_creation_expression_get_element_type (self);
	_tmp129_ = _tmp128_;
	if (_tmp129_ == NULL) {
		ValaSourceReference* _tmp130_;
		ValaSourceReference* _tmp131_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp131_ = _tmp130_;
		vala_report_error (_tmp131_, "Cannot determine the element type of the created array");
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp132_ = vala_array_creation_expression_get_element_type (self);
	_tmp133_ = _tmp132_;
	_tmp134_ = self->priv->_rank;
	_tmp135_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp136_ = _tmp135_;
	_tmp137_ = vala_array_type_new (_tmp133_, _tmp134_, _tmp136_);
	_tmp138_ = _tmp137_;
	vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp138_);
	_vala_code_node_unref0 (_tmp138_);
	_tmp139_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp140_ = _tmp139_;
	_tmp141_ = vala_array_creation_expression_get_length_type (self);
	_tmp142_ = _tmp141_;
	_tmp143_ = vala_data_type_copy (_tmp142_);
	_tmp144_ = _tmp143_;
	vala_array_type_set_length_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp140_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp144_);
	_vala_code_node_unref0 (_tmp144_);
	_tmp145_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp146_ = _tmp145_;
	vala_data_type_set_value_owned (_tmp146_, TRUE);
	_tmp147_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp148_ = _tmp147_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp148_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp149_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp150_ = _tmp149_;
	result = !_tmp150_;
	_vala_iterable_unref0 (calc_sizes);
	_vala_code_node_unref0 (initlist);
	_vala_iterable_unref0 (sizes);
	return result;
}

static void
vala_array_creation_expression_real_emit (ValaCodeNode* base,
                                          ValaCodeGenerator* codegen)
{
	ValaArrayCreationExpression * self;
	ValaInitializerList* _tmp8_;
	ValaInitializerList* _tmp9_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _e_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = self->priv->sizes;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp5_ = _e_list;
			_tmp6_ = vala_list_get (_tmp5_, _e_index);
			e = (ValaExpression*) _tmp6_;
			_tmp7_ = e;
			vala_code_node_emit ((ValaCodeNode*) _tmp7_, codegen);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp8_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaInitializerList* _tmp10_;
		ValaInitializerList* _tmp11_;
		_tmp10_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp11_ = _tmp10_;
		vala_code_node_emit ((ValaCodeNode*) _tmp11_, codegen);
	}
	vala_code_visitor_visit_array_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_array_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                        ValaCollection* collection)
{
	ValaArrayCreationExpression * self;
	ValaInitializerList* _tmp8_;
	ValaInitializerList* _tmp9_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _e_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = self->priv->sizes;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp5_ = _e_list;
			_tmp6_ = vala_list_get (_tmp5_, _e_index);
			e = (ValaExpression*) _tmp6_;
			_tmp7_ = e;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp7_, collection);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp8_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaInitializerList* _tmp10_;
		ValaInitializerList* _tmp11_;
		_tmp10_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp11_ = _tmp10_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
	}
}

static void
vala_array_creation_expression_class_init (ValaArrayCreationExpressionClass * klass,
                                           gpointer klass_data)
{
	vala_array_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_array_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaArrayCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_array_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_array_creation_expression_real_accept;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_array_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_array_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_array_creation_expression_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_array_creation_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_array_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_array_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_array_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_array_creation_expression_real_get_used_variables;
}

static void
vala_array_creation_expression_instance_init (ValaArrayCreationExpression * self,
                                              gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_array_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->sizes = (ValaList*) _tmp1_;
}

static void
vala_array_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaArrayCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression);
	_vala_iterable_unref0 (self->priv->sizes);
	_vala_code_node_unref0 (self->priv->_element_type);
	_vala_code_node_unref0 (self->priv->_length_type);
	_vala_code_node_unref0 (self->priv->_initializer_list);
	VALA_CODE_NODE_CLASS (vala_array_creation_expression_parent_class)->finalize (obj);
}

/**
 * Represents an array creation expression e.g. {{{ new int[] {1,2,3} }}}.
 */
static GType
vala_array_creation_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaArrayCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayCreationExpression), 0, (GInstanceInitFunc) vala_array_creation_expression_instance_init, NULL };
	GType vala_array_creation_expression_type_id;
	vala_array_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaArrayCreationExpression", &g_define_type_info, 0);
	ValaArrayCreationExpression_private_offset = g_type_add_instance_private (vala_array_creation_expression_type_id, sizeof (ValaArrayCreationExpressionPrivate));
	return vala_array_creation_expression_type_id;
}

GType
vala_array_creation_expression_get_type (void)
{
	static volatile gsize vala_array_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_array_creation_expression_type_id__volatile)) {
		GType vala_array_creation_expression_type_id;
		vala_array_creation_expression_type_id = vala_array_creation_expression_get_type_once ();
		g_once_init_leave (&vala_array_creation_expression_type_id__volatile, vala_array_creation_expression_type_id);
	}
	return vala_array_creation_expression_type_id__volatile;
}

