/* gcomment.c generated by valac, the Vala compiler
 * generated from gcomment.vala, do not modify */

/* gcomment.vala
 *
 * Copyright (C) 2010 Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lethalman88@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>
#include <valagee.h>
#include <valadoc.h>

#define GTKDOC_TYPE_HEADER (gtkdoc_header_get_type ())
#define GTKDOC_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_HEADER, GtkdocHeader))
#define GTKDOC_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_HEADER, GtkdocHeaderClass))
#define GTKDOC_IS_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_HEADER))
#define GTKDOC_IS_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_HEADER))
#define GTKDOC_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_HEADER, GtkdocHeaderClass))

typedef struct _GtkdocHeader GtkdocHeader;
typedef struct _GtkdocHeaderClass GtkdocHeaderClass;
typedef struct _GtkdocHeaderPrivate GtkdocHeaderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GtkdocParamSpecHeader GtkdocParamSpecHeader;

#define GTKDOC_TYPE_GCOMMENT (gtkdoc_gcomment_get_type ())
#define GTKDOC_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGComment))
#define GTKDOC_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))
#define GTKDOC_IS_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_IS_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_GCOMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))

typedef struct _GtkdocGComment GtkdocGComment;
typedef struct _GtkdocGCommentClass GtkdocGCommentClass;
typedef struct _GtkdocGCommentPrivate GtkdocGCommentPrivate;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _gtkdoc_header_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_header_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _GtkdocParamSpecGComment GtkdocParamSpecGComment;

struct _GtkdocHeader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* name;
	gchar** annotations;
	gint annotations_length1;
	gchar* value;
	gdouble pos;
	gboolean block;
	GtkdocHeaderPrivate * priv;
};

struct _GtkdocHeaderClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocHeader *self);
};

struct _GtkdocParamSpecHeader {
	GParamSpec parent_instance;
};

struct _GtkdocGComment {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* symbol;
	gchar** symbol_annotations;
	gint symbol_annotations_length1;
	ValaList* headers;
	gboolean short_description;
	gchar* brief_comment;
	gchar* long_comment;
	gchar* returns;
	gchar** returns_annotations;
	gint returns_annotations_length1;
	ValaList* versioning;
	gchar** see_also;
	gint see_also_length1;
	gboolean is_section;
	GtkdocGCommentPrivate * priv;
};

struct _GtkdocGCommentClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocGComment *self);
};

struct _GtkdocParamSpecGComment {
	GParamSpec parent_instance;
};

static gpointer gtkdoc_header_parent_class = NULL;
static gpointer gtkdoc_gcomment_parent_class = NULL;

gpointer gtkdoc_header_ref (gpointer instance);
void gtkdoc_header_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_header (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void gtkdoc_value_set_header (GValue* value,
                              gpointer v_object);
void gtkdoc_value_take_header (GValue* value,
                               gpointer v_object);
gpointer gtkdoc_value_get_header (const GValue* value);
GType gtkdoc_header_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocHeader, gtkdoc_header_unref)
GtkdocHeader* gtkdoc_header_new (const gchar* name,
                                 const gchar* value,
                                 gdouble pos,
                                 gboolean block);
GtkdocHeader* gtkdoc_header_construct (GType object_type,
                                       const gchar* name,
                                       const gchar* value,
                                       gdouble pos,
                                       gboolean block);
gint gtkdoc_header_cmp (GtkdocHeader* self,
                        GtkdocHeader* header);
static void gtkdoc_header_finalize (GtkdocHeader * obj);
static GType gtkdoc_header_get_type_once (void);
gpointer gtkdoc_gcomment_ref (gpointer instance);
void gtkdoc_gcomment_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_gcomment (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void gtkdoc_value_set_gcomment (GValue* value,
                                gpointer v_object);
void gtkdoc_value_take_gcomment (GValue* value,
                                 gpointer v_object);
gpointer gtkdoc_value_get_gcomment (const GValue* value);
GType gtkdoc_gcomment_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocGComment, gtkdoc_gcomment_unref)
gchar* gtkdoc_gcomment_to_string (GtkdocGComment* self);
gchar* gtkdoc_commentize (const gchar* comment);
gchar* gtkdoc_gcomment_to_docbook (GtkdocGComment* self,
                                   ValadocErrorReporter* reporter);
GtkdocGComment* gtkdoc_gcomment_new (void);
GtkdocGComment* gtkdoc_gcomment_construct (GType object_type);
static void gtkdoc_gcomment_finalize (GtkdocGComment * obj);
static GType gtkdoc_gcomment_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

GtkdocHeader*
gtkdoc_header_construct (GType object_type,
                         const gchar* name,
                         const gchar* value,
                         gdouble pos,
                         gboolean block)
{
	GtkdocHeader* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GtkdocHeader*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	_tmp1_ = g_strdup (value);
	_g_free0 (self->value);
	self->value = _tmp1_;
	self->pos = pos;
	self->block = block;
	return self;
}

GtkdocHeader*
gtkdoc_header_new (const gchar* name,
                   const gchar* value,
                   gdouble pos,
                   gboolean block)
{
	return gtkdoc_header_construct (GTKDOC_TYPE_HEADER, name, value, pos, block);
}

gint
gtkdoc_header_cmp (GtkdocHeader* self,
                   GtkdocHeader* header)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (header != NULL, 0);
	if (self->pos > header->pos) {
		result = 1;
		return result;
	} else {
		if (self->pos < header->pos) {
			result = -1;
			return result;
		}
	}
	result = 0;
	return result;
}

static void
gtkdoc_value_header_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gtkdoc_value_header_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_header_unref (value->data[0].v_pointer);
	}
}

static void
gtkdoc_value_header_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_header_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gtkdoc_value_header_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gtkdoc_value_header_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocHeader * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_header_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gtkdoc_value_header_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	GtkdocHeader ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_header_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gtkdoc_param_spec_header (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	GtkdocParamSpecHeader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_TYPE_HEADER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gtkdoc_value_get_header (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_HEADER), NULL);
	return value->data[0].v_pointer;
}

void
gtkdoc_value_set_header (GValue* value,
                         gpointer v_object)
{
	GtkdocHeader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_HEADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_HEADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_header_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_header_unref (old);
	}
}

void
gtkdoc_value_take_header (GValue* value,
                          gpointer v_object)
{
	GtkdocHeader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_HEADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_HEADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_header_unref (old);
	}
}

static void
gtkdoc_header_class_init (GtkdocHeaderClass * klass,
                          gpointer klass_data)
{
	gtkdoc_header_parent_class = g_type_class_peek_parent (klass);
	((GtkdocHeaderClass *) klass)->finalize = gtkdoc_header_finalize;
}

static void
gtkdoc_header_instance_init (GtkdocHeader * self,
                             gpointer klass)
{
	self->ref_count = 1;
}

static void
gtkdoc_header_finalize (GtkdocHeader * obj)
{
	GtkdocHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_TYPE_HEADER, GtkdocHeader);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	self->annotations = (_vala_array_free (self->annotations, self->annotations_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->value);
}

static GType
gtkdoc_header_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gtkdoc_value_header_init, gtkdoc_value_header_free_value, gtkdoc_value_header_copy_value, gtkdoc_value_header_peek_pointer, "p", gtkdoc_value_header_collect_value, "p", gtkdoc_value_header_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GtkdocHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocHeader), 0, (GInstanceInitFunc) gtkdoc_header_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gtkdoc_header_type_id;
	gtkdoc_header_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocHeader", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gtkdoc_header_type_id;
}

GType
gtkdoc_header_get_type (void)
{
	static volatile gsize gtkdoc_header_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_header_type_id__volatile)) {
		GType gtkdoc_header_type_id;
		gtkdoc_header_type_id = gtkdoc_header_get_type_once ();
		g_once_init_leave (&gtkdoc_header_type_id__volatile, gtkdoc_header_type_id);
	}
	return gtkdoc_header_type_id__volatile;
}

gpointer
gtkdoc_header_ref (gpointer instance)
{
	GtkdocHeader * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gtkdoc_header_unref (gpointer instance)
{
	GtkdocHeader * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_HEADER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
gtkdoc_gcomment_to_string (GtkdocGComment* self)
{
	GString* builder = NULL;
	GString* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GString* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gboolean _tmp13_ = FALSE;
	ValaList* _tmp19_;
	gboolean _tmp51_ = FALSE;
	const gchar* _tmp57_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	gboolean _tmp67_ = FALSE;
	const gchar* _tmp68_;
	ValaList* _tmp84_;
	gint _tmp85_;
	gint _tmp86_;
	GString* _tmp107_;
	GString* _tmp108_;
	const gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	if (self->is_section) {
		_tmp1_ = "SECTION:%s";
	} else {
		_tmp1_ = "%s:";
	}
	_tmp2_ = builder;
	_tmp3_ = self->symbol;
	_tmp4_ = g_strdup_printf (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	g_string_append_printf (_tmp2_, "/**\n * %s", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp7_ = self->symbol_annotations;
	_tmp7__length1 = self->symbol_annotations_length1;
	if (_tmp7_ != NULL) {
		gchar** _tmp8_;
		gint _tmp8__length1;
		_tmp8_ = self->symbol_annotations;
		_tmp8__length1 = self->symbol_annotations_length1;
		_tmp6_ = _tmp8__length1 > 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gchar** _tmp9_;
		gint _tmp9__length1;
		_tmp9_ = self->symbol_annotations;
		_tmp9__length1 = self->symbol_annotations_length1;
		{
			gchar** annotation_collection = NULL;
			gint annotation_collection_length1 = 0;
			gint _annotation_collection_size_ = 0;
			gint annotation_it = 0;
			annotation_collection = _tmp9_;
			annotation_collection_length1 = _tmp9__length1;
			for (annotation_it = 0; annotation_it < annotation_collection_length1; annotation_it = annotation_it + 1) {
				gchar* _tmp10_;
				gchar* annotation = NULL;
				_tmp10_ = g_strdup (annotation_collection[annotation_it]);
				annotation = _tmp10_;
				{
					GString* _tmp11_;
					const gchar* _tmp12_;
					_tmp11_ = builder;
					_tmp12_ = annotation;
					g_string_append_printf (_tmp11_, " (%s)", _tmp12_);
					_g_free0 (annotation);
				}
			}
		}
	}
	if (self->short_description) {
		const gchar* _tmp14_;
		_tmp14_ = self->brief_comment;
		_tmp13_ = _tmp14_ != NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GString* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp15_ = builder;
		_tmp16_ = self->brief_comment;
		_tmp17_ = gtkdoc_commentize (_tmp16_);
		_tmp18_ = _tmp17_;
		g_string_append_printf (_tmp15_, "\n * @short_description: %s", _tmp18_);
		_g_free0 (_tmp18_);
	}
	_tmp19_ = self->headers;
	vala_list_sort (_tmp19_, (GCompareDataFunc) gtkdoc_header_cmp, NULL, NULL);
	{
		ValaList* _header_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _header_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _header_index = 0;
		_tmp20_ = self->headers;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_header_list = _tmp21_;
		_tmp22_ = _header_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_header_size = _tmp24_;
		_header_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			GtkdocHeader* header = NULL;
			ValaList* _tmp27_;
			gpointer _tmp28_;
			GString* _tmp29_;
			GtkdocHeader* _tmp30_;
			const gchar* _tmp31_;
			gboolean _tmp32_ = FALSE;
			GtkdocHeader* _tmp33_;
			gchar** _tmp34_;
			gint _tmp34__length1;
			GtkdocHeader* _tmp43_;
			const gchar* _tmp44_;
			_header_index = _header_index + 1;
			_tmp25_ = _header_index;
			_tmp26_ = _header_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _header_list;
			_tmp28_ = vala_list_get (_tmp27_, _header_index);
			header = (GtkdocHeader*) _tmp28_;
			_tmp29_ = builder;
			_tmp30_ = header;
			_tmp31_ = _tmp30_->name;
			g_string_append_printf (_tmp29_, "\n * @%s:", _tmp31_);
			_tmp33_ = header;
			_tmp34_ = _tmp33_->annotations;
			_tmp34__length1 = _tmp33_->annotations_length1;
			if (_tmp34_ != NULL) {
				GtkdocHeader* _tmp35_;
				gchar** _tmp36_;
				gint _tmp36__length1;
				_tmp35_ = header;
				_tmp36_ = _tmp35_->annotations;
				_tmp36__length1 = _tmp35_->annotations_length1;
				_tmp32_ = _tmp36__length1 > 0;
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				GtkdocHeader* _tmp37_;
				gchar** _tmp38_;
				gint _tmp38__length1;
				GString* _tmp42_;
				_tmp37_ = header;
				_tmp38_ = _tmp37_->annotations;
				_tmp38__length1 = _tmp37_->annotations_length1;
				{
					gchar** annotation_collection = NULL;
					gint annotation_collection_length1 = 0;
					gint _annotation_collection_size_ = 0;
					gint annotation_it = 0;
					annotation_collection = _tmp38_;
					annotation_collection_length1 = _tmp38__length1;
					for (annotation_it = 0; annotation_it < annotation_collection_length1; annotation_it = annotation_it + 1) {
						gchar* _tmp39_;
						gchar* annotation = NULL;
						_tmp39_ = g_strdup (annotation_collection[annotation_it]);
						annotation = _tmp39_;
						{
							GString* _tmp40_;
							const gchar* _tmp41_;
							_tmp40_ = builder;
							_tmp41_ = annotation;
							g_string_append_printf (_tmp40_, " (%s)", _tmp41_);
							_g_free0 (annotation);
						}
					}
				}
				_tmp42_ = builder;
				g_string_append_c (_tmp42_, ':');
			}
			_tmp43_ = header;
			_tmp44_ = _tmp43_->value;
			if (_tmp44_ != NULL) {
				GString* _tmp45_;
				GString* _tmp46_;
				GtkdocHeader* _tmp47_;
				const gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				_tmp45_ = builder;
				g_string_append_c (_tmp45_, ' ');
				_tmp46_ = builder;
				_tmp47_ = header;
				_tmp48_ = _tmp47_->value;
				_tmp49_ = gtkdoc_commentize (_tmp48_);
				_tmp50_ = _tmp49_;
				g_string_append (_tmp46_, _tmp50_);
				_g_free0 (_tmp50_);
			}
			_gtkdoc_header_unref0 (header);
		}
		_vala_iterable_unref0 (_header_list);
	}
	if (!self->short_description) {
		const gchar* _tmp52_;
		_tmp52_ = self->brief_comment;
		_tmp51_ = _tmp52_ != NULL;
	} else {
		_tmp51_ = FALSE;
	}
	if (_tmp51_) {
		GString* _tmp53_;
		const gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		_tmp53_ = builder;
		_tmp54_ = self->brief_comment;
		_tmp55_ = gtkdoc_commentize (_tmp54_);
		_tmp56_ = _tmp55_;
		g_string_append_printf (_tmp53_, "\n * \n * %s", _tmp56_);
		_g_free0 (_tmp56_);
	}
	_tmp57_ = self->long_comment;
	if (_tmp57_ != NULL) {
		GString* _tmp58_;
		const gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		_tmp58_ = builder;
		_tmp59_ = self->long_comment;
		_tmp60_ = gtkdoc_commentize (_tmp59_);
		_tmp61_ = _tmp60_;
		g_string_append_printf (_tmp58_, "\n * \n * %s", _tmp61_);
		_g_free0 (_tmp61_);
	}
	_tmp62_ = self->see_also;
	_tmp62__length1 = self->see_also_length1;
	if (_tmp62__length1 > 0) {
		GString* _tmp63_;
		gchar** _tmp64_;
		gint _tmp64__length1;
		gchar* _tmp65_;
		gchar* _tmp66_;
		_tmp63_ = builder;
		_tmp64_ = self->see_also;
		_tmp64__length1 = self->see_also_length1;
		_tmp65_ = _vala_g_strjoinv (", ", _tmp64_, (gint) _tmp64__length1);
		_tmp66_ = _tmp65_;
		g_string_append_printf (_tmp63_, "\n * \n * <emphasis>See also</emphasis>: %s", _tmp66_);
		_g_free0 (_tmp66_);
	}
	_tmp68_ = self->returns;
	if (_tmp68_ != NULL) {
		_tmp67_ = TRUE;
	} else {
		gchar** _tmp69_;
		gint _tmp69__length1;
		_tmp69_ = self->returns_annotations;
		_tmp69__length1 = self->returns_annotations_length1;
		_tmp67_ = _tmp69__length1 > 0;
	}
	if (_tmp67_) {
		GString* _tmp70_;
		gchar** _tmp71_;
		gint _tmp71__length1;
		GString* _tmp78_;
		const gchar* _tmp79_;
		_tmp70_ = builder;
		g_string_append (_tmp70_, "\n * \n * Returns:");
		_tmp71_ = self->returns_annotations;
		_tmp71__length1 = self->returns_annotations_length1;
		if (_tmp71_ != NULL) {
			gchar** _tmp72_;
			gint _tmp72__length1;
			gchar** _tmp76_;
			gint _tmp76__length1;
			_tmp72_ = self->returns_annotations;
			_tmp72__length1 = self->returns_annotations_length1;
			{
				gchar** annotation_collection = NULL;
				gint annotation_collection_length1 = 0;
				gint _annotation_collection_size_ = 0;
				gint annotation_it = 0;
				annotation_collection = _tmp72_;
				annotation_collection_length1 = _tmp72__length1;
				for (annotation_it = 0; annotation_it < annotation_collection_length1; annotation_it = annotation_it + 1) {
					gchar* _tmp73_;
					gchar* annotation = NULL;
					_tmp73_ = g_strdup (annotation_collection[annotation_it]);
					annotation = _tmp73_;
					{
						GString* _tmp74_;
						const gchar* _tmp75_;
						_tmp74_ = builder;
						_tmp75_ = annotation;
						g_string_append_printf (_tmp74_, " (%s)", _tmp75_);
						_g_free0 (annotation);
					}
				}
			}
			_tmp76_ = self->returns_annotations;
			_tmp76__length1 = self->returns_annotations_length1;
			if (_tmp76__length1 > 0) {
				GString* _tmp77_;
				_tmp77_ = builder;
				g_string_append_c (_tmp77_, ':');
			}
		}
		_tmp78_ = builder;
		g_string_append_c (_tmp78_, ' ');
		_tmp79_ = self->returns;
		if (_tmp79_ != NULL) {
			GString* _tmp80_;
			const gchar* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			_tmp80_ = builder;
			_tmp81_ = self->returns;
			_tmp82_ = gtkdoc_commentize (_tmp81_);
			_tmp83_ = _tmp82_;
			g_string_append (_tmp80_, _tmp83_);
			_g_free0 (_tmp83_);
		}
	}
	_tmp84_ = self->versioning;
	_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
	_tmp86_ = _tmp85_;
	if (_tmp86_ > 0) {
		GString* _tmp87_;
		_tmp87_ = builder;
		g_string_append (_tmp87_, "\n *");
		{
			ValaList* _version_list = NULL;
			ValaList* _tmp88_;
			ValaList* _tmp89_;
			gint _version_size = 0;
			ValaList* _tmp90_;
			gint _tmp91_;
			gint _tmp92_;
			gint _version_index = 0;
			_tmp88_ = self->versioning;
			_tmp89_ = _vala_iterable_ref0 (_tmp88_);
			_version_list = _tmp89_;
			_tmp90_ = _version_list;
			_tmp91_ = vala_collection_get_size ((ValaCollection*) _tmp90_);
			_tmp92_ = _tmp91_;
			_version_size = _tmp92_;
			_version_index = -1;
			while (TRUE) {
				gint _tmp93_;
				gint _tmp94_;
				GtkdocHeader* version = NULL;
				ValaList* _tmp95_;
				gpointer _tmp96_;
				GString* _tmp97_;
				GtkdocHeader* _tmp98_;
				const gchar* _tmp99_;
				GtkdocHeader* _tmp100_;
				const gchar* _tmp101_;
				_version_index = _version_index + 1;
				_tmp93_ = _version_index;
				_tmp94_ = _version_size;
				if (!(_tmp93_ < _tmp94_)) {
					break;
				}
				_tmp95_ = _version_list;
				_tmp96_ = vala_list_get (_tmp95_, _version_index);
				version = (GtkdocHeader*) _tmp96_;
				_tmp97_ = builder;
				_tmp98_ = version;
				_tmp99_ = _tmp98_->name;
				g_string_append_printf (_tmp97_, "\n * %s:", _tmp99_);
				_tmp100_ = version;
				_tmp101_ = _tmp100_->value;
				if (_tmp101_ != NULL) {
					GString* _tmp102_;
					GtkdocHeader* _tmp103_;
					const gchar* _tmp104_;
					gchar* _tmp105_;
					gchar* _tmp106_;
					_tmp102_ = builder;
					_tmp103_ = version;
					_tmp104_ = _tmp103_->value;
					_tmp105_ = gtkdoc_commentize (_tmp104_);
					_tmp106_ = _tmp105_;
					g_string_append_printf (_tmp102_, " %s", _tmp106_);
					_g_free0 (_tmp106_);
				}
				_gtkdoc_header_unref0 (version);
			}
			_vala_iterable_unref0 (_version_list);
		}
	}
	_tmp107_ = builder;
	g_string_append (_tmp107_, "\n */");
	_tmp108_ = builder;
	_tmp109_ = _tmp108_->str;
	_tmp110_ = g_strdup (_tmp109_);
	result = _tmp110_;
	_g_string_free0 (builder);
	return result;
}

gchar*
gtkdoc_gcomment_to_docbook (GtkdocGComment* self,
                            ValadocErrorReporter* reporter)
{
	gchar* deprecated = NULL;
	gchar* since = NULL;
	GString* builder = NULL;
	GString* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp26_;
	const gchar* _tmp29_;
	ValaList* _tmp32_;
	gboolean _tmp33_ = FALSE;
	ValaList* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	const gchar* _tmp57_;
	GString* _tmp60_;
	const gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	deprecated = NULL;
	since = NULL;
	{
		ValaList* _header_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _header_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _header_index = 0;
		_tmp0_ = self->versioning;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_header_list = _tmp1_;
		_tmp2_ = _header_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_header_size = _tmp4_;
		_header_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			GtkdocHeader* header = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			GtkdocHeader* _tmp9_;
			const gchar* _tmp10_;
			_header_index = _header_index + 1;
			_tmp5_ = _header_index;
			_tmp6_ = _header_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _header_list;
			_tmp8_ = vala_list_get (_tmp7_, _header_index);
			header = (GtkdocHeader*) _tmp8_;
			_tmp9_ = header;
			_tmp10_ = _tmp9_->name;
			if (g_strcmp0 (_tmp10_, "Deprecated") == 0) {
				GtkdocHeader* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = header;
				_tmp12_ = _tmp11_->value;
				_tmp13_ = g_strdup (_tmp12_);
				_g_free0 (deprecated);
				deprecated = _tmp13_;
			} else {
				GtkdocHeader* _tmp14_;
				const gchar* _tmp15_;
				_tmp14_ = header;
				_tmp15_ = _tmp14_->name;
				if (g_strcmp0 (_tmp15_, "Since") == 0) {
					GtkdocHeader* _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp16_ = header;
					_tmp17_ = _tmp16_->value;
					_tmp18_ = g_strdup (_tmp17_);
					_g_free0 (since);
					since = _tmp18_;
				} else {
					GtkdocHeader* _tmp19_;
					const gchar* _tmp20_;
					_tmp19_ = header;
					_tmp20_ = _tmp19_->name;
					valadoc_error_reporter_simple_warning (reporter, "GtkDoc", "Unknown versioning tag '%s'", _tmp20_);
				}
			}
			_gtkdoc_header_unref0 (header);
		}
		_vala_iterable_unref0 (_header_list);
	}
	_tmp21_ = g_string_new ("");
	builder = _tmp21_;
	_tmp22_ = deprecated;
	if (_tmp22_ != NULL) {
		GString* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		_tmp23_ = builder;
		_tmp24_ = self->symbol;
		_tmp25_ = deprecated;
		g_string_append_printf (_tmp23_, "<warning><para><literal>%s</literal> is deprecated and should not be u" \
"sed in newly-written code. %s</para></warning>", _tmp24_, _tmp25_);
	}
	_tmp26_ = self->brief_comment;
	if (_tmp26_ != NULL) {
		GString* _tmp27_;
		const gchar* _tmp28_;
		_tmp27_ = builder;
		_tmp28_ = self->brief_comment;
		g_string_append_printf (_tmp27_, "<para>%s</para>", _tmp28_);
	}
	_tmp29_ = self->long_comment;
	if (_tmp29_ != NULL) {
		GString* _tmp30_;
		const gchar* _tmp31_;
		_tmp30_ = builder;
		_tmp31_ = self->long_comment;
		g_string_append (_tmp30_, _tmp31_);
	}
	_tmp32_ = self->headers;
	vala_list_sort (_tmp32_, (GCompareDataFunc) gtkdoc_header_cmp, NULL, NULL);
	_tmp34_ = self->headers;
	_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp36_ > 0) {
		_tmp33_ = TRUE;
	} else {
		const gchar* _tmp37_;
		_tmp37_ = self->returns;
		_tmp33_ = _tmp37_ != NULL;
	}
	if (_tmp33_) {
		GString* _tmp38_;
		const gchar* _tmp53_;
		GString* _tmp56_;
		_tmp38_ = builder;
		g_string_append (_tmp38_, "<variablelist role=\"params\">");
		{
			ValaList* _header_list = NULL;
			ValaList* _tmp39_;
			ValaList* _tmp40_;
			gint _header_size = 0;
			ValaList* _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			gint _header_index = 0;
			_tmp39_ = self->headers;
			_tmp40_ = _vala_iterable_ref0 (_tmp39_);
			_header_list = _tmp40_;
			_tmp41_ = _header_list;
			_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
			_tmp43_ = _tmp42_;
			_header_size = _tmp43_;
			_header_index = -1;
			while (TRUE) {
				gint _tmp44_;
				gint _tmp45_;
				GtkdocHeader* header = NULL;
				ValaList* _tmp46_;
				gpointer _tmp47_;
				GString* _tmp48_;
				GtkdocHeader* _tmp49_;
				const gchar* _tmp50_;
				GtkdocHeader* _tmp51_;
				const gchar* _tmp52_;
				_header_index = _header_index + 1;
				_tmp44_ = _header_index;
				_tmp45_ = _header_size;
				if (!(_tmp44_ < _tmp45_)) {
					break;
				}
				_tmp46_ = _header_list;
				_tmp47_ = vala_list_get (_tmp46_, _header_index);
				header = (GtkdocHeader*) _tmp47_;
				_tmp48_ = builder;
				_tmp49_ = header;
				_tmp50_ = _tmp49_->name;
				_tmp51_ = header;
				_tmp52_ = _tmp51_->value;
				g_string_append_printf (_tmp48_, "<varlistentry><term><parameter>%s</parameter>&#160;:</term>\n" \
"<listitem><simpara> %s </simpara></listitem></varlistentry>", _tmp50_, _tmp52_);
				_gtkdoc_header_unref0 (header);
			}
			_vala_iterable_unref0 (_header_list);
		}
		_tmp53_ = self->returns;
		if (_tmp53_ != NULL) {
			GString* _tmp54_;
			const gchar* _tmp55_;
			_tmp54_ = builder;
			_tmp55_ = self->returns;
			g_string_append_printf (_tmp54_, "<varlistentry><term><emphasis>Returns</emphasis>&#160;:</term>\n" \
"<listitem><simpara> %s </simpara></listitem></varlistentry>", _tmp55_);
		}
		_tmp56_ = builder;
		g_string_append (_tmp56_, "</variablelist>");
	}
	_tmp57_ = since;
	if (_tmp57_ != NULL) {
		GString* _tmp58_;
		const gchar* _tmp59_;
		_tmp58_ = builder;
		_tmp59_ = since;
		g_string_append_printf (_tmp58_, "<para role=\"since\">Since %s</para>", _tmp59_);
	}
	_tmp60_ = builder;
	_tmp61_ = _tmp60_->str;
	_tmp62_ = g_strdup (_tmp61_);
	result = _tmp62_;
	_g_string_free0 (builder);
	_g_free0 (since);
	_g_free0 (deprecated);
	return result;
}

GtkdocGComment*
gtkdoc_gcomment_construct (GType object_type)
{
	GtkdocGComment* self = NULL;
	self = (GtkdocGComment*) g_type_create_instance (object_type);
	return self;
}

GtkdocGComment*
gtkdoc_gcomment_new (void)
{
	return gtkdoc_gcomment_construct (GTKDOC_TYPE_GCOMMENT);
}

static void
gtkdoc_value_gcomment_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gtkdoc_value_gcomment_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_gcomment_unref (value->data[0].v_pointer);
	}
}

static void
gtkdoc_value_gcomment_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_gcomment_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gtkdoc_value_gcomment_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gtkdoc_value_gcomment_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocGComment * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_gcomment_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gtkdoc_value_gcomment_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	GtkdocGComment ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_gcomment_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gtkdoc_param_spec_gcomment (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	GtkdocParamSpecGComment* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_TYPE_GCOMMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gtkdoc_value_get_gcomment (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_GCOMMENT), NULL);
	return value->data[0].v_pointer;
}

void
gtkdoc_value_set_gcomment (GValue* value,
                           gpointer v_object)
{
	GtkdocGComment * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_GCOMMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_GCOMMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_gcomment_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_gcomment_unref (old);
	}
}

void
gtkdoc_value_take_gcomment (GValue* value,
                            gpointer v_object)
{
	GtkdocGComment * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_GCOMMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_GCOMMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_gcomment_unref (old);
	}
}

static void
gtkdoc_gcomment_class_init (GtkdocGCommentClass * klass,
                            gpointer klass_data)
{
	gtkdoc_gcomment_parent_class = g_type_class_peek_parent (klass);
	((GtkdocGCommentClass *) klass)->finalize = gtkdoc_gcomment_finalize;
}

static void
gtkdoc_gcomment_instance_init (GtkdocGComment * self,
                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp0_);
	self->headers = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp2_);
	self->versioning = (ValaList*) _tmp3_;
	self->ref_count = 1;
}

static void
gtkdoc_gcomment_finalize (GtkdocGComment * obj)
{
	GtkdocGComment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_TYPE_GCOMMENT, GtkdocGComment);
	g_signal_handlers_destroy (self);
	_g_free0 (self->symbol);
	self->symbol_annotations = (_vala_array_free (self->symbol_annotations, self->symbol_annotations_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->headers);
	_g_free0 (self->brief_comment);
	_g_free0 (self->long_comment);
	_g_free0 (self->returns);
	self->returns_annotations = (_vala_array_free (self->returns_annotations, self->returns_annotations_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->versioning);
	self->see_also = (_vala_array_free (self->see_also, self->see_also_length1, (GDestroyNotify) g_free), NULL);
}

static GType
gtkdoc_gcomment_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gtkdoc_value_gcomment_init, gtkdoc_value_gcomment_free_value, gtkdoc_value_gcomment_copy_value, gtkdoc_value_gcomment_peek_pointer, "p", gtkdoc_value_gcomment_collect_value, "p", gtkdoc_value_gcomment_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GtkdocGCommentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_gcomment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocGComment), 0, (GInstanceInitFunc) gtkdoc_gcomment_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gtkdoc_gcomment_type_id;
	gtkdoc_gcomment_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocGComment", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gtkdoc_gcomment_type_id;
}

GType
gtkdoc_gcomment_get_type (void)
{
	static volatile gsize gtkdoc_gcomment_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_gcomment_type_id__volatile)) {
		GType gtkdoc_gcomment_type_id;
		gtkdoc_gcomment_type_id = gtkdoc_gcomment_get_type_once ();
		g_once_init_leave (&gtkdoc_gcomment_type_id__volatile, gtkdoc_gcomment_type_id);
	}
	return gtkdoc_gcomment_type_id__volatile;
}

gpointer
gtkdoc_gcomment_ref (gpointer instance)
{
	GtkdocGComment * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gtkdoc_gcomment_unref (gpointer instance)
{
	GtkdocGComment * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_GCOMMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

