/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaDataType* _tmp13_;
			_type_arg_index = _type_arg_index + 1;
			_tmp9_ = _type_arg_index;
			_tmp10_ = _type_arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _type_arg_list;
			_tmp12_ = vala_list_get (_tmp11_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp12_;
			_tmp13_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaLocalVariable* l = NULL;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaConstant* _tmp6_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	l = VALA_IS_LOCAL_VARIABLE (_tmp3_) ? ((ValaLocalVariable*) _tmp3_) : NULL;
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	m = VALA_IS_METHOD (_tmp5_) ? ((ValaMethod*) _tmp5_) : NULL;
	_tmp6_ = c;
	if (_tmp6_ != NULL) {
		gboolean _tmp7_ = FALSE;
		ValaConstant* _tmp8_;
		_tmp8_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp8_)) {
			_tmp7_ = TRUE;
		} else {
			ValaConstant* _tmp9_;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp9_ = c;
			_tmp10_ = vala_constant_get_type_reference (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_data_type_get_nullable (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp7_ = !_tmp13_;
		}
		result = _tmp7_;
		return result;
	} else {
		ValaLocalVariable* _tmp14_;
		_tmp14_ = l;
		if (_tmp14_ != NULL) {
			ValaDataType* type = NULL;
			ValaLocalVariable* _tmp15_;
			ValaDataType* _tmp16_;
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			_tmp15_ = l;
			_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) _tmp15_);
			_tmp17_ = _tmp16_;
			type = _tmp17_;
			_tmp18_ = type;
			if (VALA_IS_ARRAY_TYPE (_tmp18_)) {
				ValaDataType* _tmp19_;
				gboolean _tmp20_;
				gboolean _tmp21_;
				_tmp19_ = type;
				_tmp20_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp21_ = _tmp20_;
				result = _tmp21_;
				return result;
			} else {
				gboolean _tmp22_ = FALSE;
				ValaDataType* _tmp23_;
				_tmp23_ = type;
				if (vala_data_type_is_real_non_null_struct_type (_tmp23_)) {
					_tmp22_ = TRUE;
				} else {
					ValaDataType* _tmp24_;
					_tmp24_ = type;
					_tmp22_ = vala_data_type_is_non_null_simple_type (_tmp24_);
				}
				result = _tmp22_;
				return result;
			}
		} else {
			ValaMethod* _tmp25_;
			_tmp25_ = m;
			if (_tmp25_ != NULL) {
				gboolean _tmp26_ = FALSE;
				ValaMethod* _tmp27_;
				ValaMemberBinding _tmp28_;
				ValaMemberBinding _tmp29_;
				_tmp27_ = m;
				_tmp28_ = vala_method_get_binding (_tmp27_);
				_tmp29_ = _tmp28_;
				if (_tmp29_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp26_ = TRUE;
				} else {
					gboolean _tmp30_;
					_tmp30_ = self->priv->_prototype_access;
					_tmp26_ = _tmp30_;
				}
				result = _tmp26_;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp18_;
	gboolean _tmp673_ = FALSE;
	gboolean _tmp674_ = FALSE;
	gboolean _tmp675_ = FALSE;
	ValaExpression* _tmp676_;
	ValaExpression* _tmp677_;
	ValaSymbol* _tmp705_;
	ValaSymbol* _tmp706_;
	ValaSymbol* _tmp760_;
	ValaSymbol* _tmp761_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp799_;
	ValaSymbol* _tmp800_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp801_;
	ValaSymbol* _tmp802_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1265_;
	ValaSymbol* _tmp1266_;
	ValaSymbol* _tmp1268_;
	ValaVersionAttribute* _tmp1269_;
	ValaVersionAttribute* _tmp1270_;
	ValaSourceReference* _tmp1271_;
	ValaSourceReference* _tmp1272_;
	gboolean _tmp1273_ = FALSE;
	gboolean _tmp1328_ = FALSE;
	gboolean _tmp1355_ = FALSE;
	gboolean _tmp1356_ = FALSE;
	ValaDataType* _tmp1654_;
	ValaDataType* _tmp1655_;
	gboolean _tmp1658_;
	gboolean _tmp1659_;
	gboolean _tmp1660_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaDataType* _tmp17_;
			_type_arg_index = _type_arg_index + 1;
			_tmp13_ = _type_arg_index;
			_tmp14_ = _type_arg_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _type_arg_list;
			_tmp16_ = vala_list_get (_tmp15_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp16_;
			_tmp17_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp17_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp18_ = self->priv->_qualified;
	if (_tmp18_) {
		ValaNamespace* _tmp19_;
		ValaNamespace* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaScope* _tmp22_;
		ValaScope* _tmp23_;
		const gchar* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		_tmp19_ = vala_code_context_get_root (context);
		_tmp20_ = _tmp19_;
		base_symbol = (ValaSymbol*) _tmp20_;
		_tmp21_ = base_symbol;
		_tmp22_ = vala_symbol_get_scope (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = self->priv->_member_name;
		_tmp25_ = vala_scope_lookup (_tmp23_, _tmp24_);
		_tmp26_ = _tmp25_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp26_);
		_vala_code_node_unref0 (_tmp26_);
	} else {
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp27_ = vala_member_access_get_inner (self);
		_tmp28_ = _tmp27_;
		if (_tmp28_ == NULL) {
			const gchar* _tmp29_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSemanticAnalyzer* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			gboolean _tmp140_ = FALSE;
			ValaSymbol* _tmp141_;
			ValaSymbol* _tmp142_;
			_tmp29_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp29_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp30_;
				ValaSemanticAnalyzer* _tmp31_;
				_tmp30_ = vala_code_context_get_analyzer (context);
				_tmp31_ = _tmp30_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp31_)) {
					ValaSourceReference* _tmp32_;
					ValaSourceReference* _tmp33_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp33_ = _tmp32_;
					vala_report_error (_tmp33_, "This access invalid outside of instance methods");
					result = FALSE;
					return result;
				}
			}
			_tmp34_ = vala_code_context_get_analyzer (context);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_semantic_analyzer_get_current_symbol (_tmp35_);
			_tmp37_ = _tmp36_;
			base_symbol = _tmp37_;
			method_found = FALSE;
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			sym = _tmp41_;
			while (TRUE) {
				gboolean _tmp42_ = FALSE;
				ValaSymbol* _tmp43_;
				ValaSymbol* _tmp89_;
				const gchar* _tmp90_;
				ValaSymbol* _tmp91_;
				ValaSymbol* _tmp92_;
				gboolean _tmp93_ = FALSE;
				gboolean _tmp94_ = FALSE;
				ValaSymbol* _tmp95_;
				ValaSymbol* _tmp96_;
				ValaSymbol* _tmp134_;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp137_;
				ValaSymbol* _tmp138_;
				ValaSymbol* _tmp139_;
				_tmp43_ = sym;
				if (_tmp43_ != NULL) {
					ValaSymbol* _tmp44_;
					ValaSymbol* _tmp45_;
					_tmp44_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp45_ = _tmp44_;
					_tmp42_ = _tmp45_ == NULL;
				} else {
					_tmp42_ = FALSE;
				}
				if (!_tmp42_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp46_;
					_tmp46_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp46_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp47_;
						ValaCreationMethod* _tmp48_;
						ValaParameter* _tmp49_;
						ValaParameter* _tmp50_;
						_tmp47_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp48_ = cm;
						_tmp49_ = vala_method_get_this_parameter ((ValaMethod*) _tmp48_);
						_tmp50_ = _tmp49_;
						this_parameter = _tmp50_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp51_;
						_tmp51_ = sym;
						if (VALA_IS_PROPERTY (_tmp51_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp52_;
							ValaProperty* _tmp53_;
							ValaParameter* _tmp54_;
							ValaParameter* _tmp55_;
							ValaProperty* _tmp56_;
							ValaMemberBinding _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaProperty* _tmp59_;
							ValaMemberBinding _tmp60_;
							ValaMemberBinding _tmp61_;
							_tmp52_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp53_ = prop;
							_tmp54_ = vala_property_get_this_parameter (_tmp53_);
							_tmp55_ = _tmp54_;
							this_parameter = _tmp55_;
							_tmp56_ = prop;
							_tmp57_ = vala_property_get_binding (_tmp56_);
							_tmp58_ = _tmp57_;
							may_access_instance_members = _tmp58_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp59_ = prop;
							_tmp60_ = vala_property_get_binding (_tmp59_);
							_tmp61_ = _tmp60_;
							may_access_klass_members = _tmp61_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp62_;
							_tmp62_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp62_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp63_;
								ValaConstructor* _tmp64_;
								ValaParameter* _tmp65_;
								ValaParameter* _tmp66_;
								ValaConstructor* _tmp67_;
								ValaMemberBinding _tmp68_;
								ValaMemberBinding _tmp69_;
								_tmp63_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp64_ = c;
								_tmp65_ = vala_constructor_get_this_parameter (_tmp64_);
								_tmp66_ = _tmp65_;
								this_parameter = _tmp66_;
								_tmp67_ = c;
								_tmp68_ = vala_constructor_get_binding (_tmp67_);
								_tmp69_ = _tmp68_;
								may_access_instance_members = _tmp69_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp70_;
								_tmp70_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp70_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp71_;
									ValaDestructor* _tmp72_;
									ValaParameter* _tmp73_;
									ValaParameter* _tmp74_;
									ValaDestructor* _tmp75_;
									ValaMemberBinding _tmp76_;
									ValaMemberBinding _tmp77_;
									_tmp71_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp72_ = d;
									_tmp73_ = vala_destructor_get_this_parameter (_tmp72_);
									_tmp74_ = _tmp73_;
									this_parameter = _tmp74_;
									_tmp75_ = d;
									_tmp76_ = vala_destructor_get_binding (_tmp75_);
									_tmp77_ = _tmp76_;
									may_access_instance_members = _tmp77_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp78_;
									_tmp78_ = sym;
									if (VALA_IS_METHOD (_tmp78_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp79_;
										ValaMethod* _tmp80_;
										ValaParameter* _tmp81_;
										ValaParameter* _tmp82_;
										ValaMethod* _tmp83_;
										ValaMemberBinding _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMethod* _tmp86_;
										ValaMemberBinding _tmp87_;
										ValaMemberBinding _tmp88_;
										_tmp79_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALA_TYPE_METHOD, ValaMethod);
										_tmp80_ = m;
										_tmp81_ = vala_method_get_this_parameter (_tmp80_);
										_tmp82_ = _tmp81_;
										this_parameter = _tmp82_;
										_tmp83_ = m;
										_tmp84_ = vala_method_get_binding (_tmp83_);
										_tmp85_ = _tmp84_;
										may_access_instance_members = _tmp85_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp86_ = m;
										_tmp87_ = vala_method_get_binding (_tmp86_);
										_tmp88_ = _tmp87_;
										may_access_klass_members = _tmp88_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp89_ = sym;
				_tmp90_ = self->priv->_member_name;
				_tmp91_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp89_, _tmp90_);
				_tmp92_ = _tmp91_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp92_);
				_vala_code_node_unref0 (_tmp92_);
				_tmp95_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp96_ = _tmp95_;
				if (_tmp96_ == NULL) {
					ValaSymbol* _tmp97_;
					_tmp97_ = sym;
					_tmp94_ = VALA_IS_TYPESYMBOL (_tmp97_);
				} else {
					_tmp94_ = FALSE;
				}
				if (_tmp94_) {
					_tmp93_ = may_access_instance_members;
				} else {
					_tmp93_ = FALSE;
				}
				if (_tmp93_) {
					ValaParameter* _tmp98_;
					ValaDataType* _tmp99_;
					ValaDataType* _tmp100_;
					const gchar* _tmp101_;
					ValaSymbol* _tmp102_;
					ValaSymbol* _tmp103_;
					gboolean _tmp104_ = FALSE;
					ValaSymbol* _tmp105_;
					ValaSymbol* _tmp106_;
					_tmp98_ = this_parameter;
					_tmp99_ = vala_variable_get_variable_type ((ValaVariable*) _tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = self->priv->_member_name;
					_tmp102_ = vala_data_type_get_member (_tmp100_, _tmp101_);
					_tmp103_ = _tmp102_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp103_);
					_vala_code_node_unref0 (_tmp103_);
					_tmp105_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp106_ = _tmp105_;
					if (_tmp106_ != NULL) {
						ValaSymbol* _tmp107_;
						ValaSymbol* _tmp108_;
						_tmp107_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp108_ = _tmp107_;
						_tmp104_ = vala_member_access_is_instance_symbol (_tmp108_);
					} else {
						_tmp104_ = FALSE;
					}
					if (_tmp104_) {
						ValaSourceReference* _tmp109_;
						ValaSourceReference* _tmp110_;
						ValaMemberAccess* _tmp111_;
						ValaMemberAccess* _tmp112_;
						ValaExpression* _tmp113_;
						ValaExpression* _tmp114_;
						ValaParameter* _tmp115_;
						ValaDataType* _tmp116_;
						ValaDataType* _tmp117_;
						ValaDataType* _tmp118_;
						ValaDataType* _tmp119_;
						ValaExpression* _tmp120_;
						ValaExpression* _tmp121_;
						ValaDataType* _tmp122_;
						ValaDataType* _tmp123_;
						ValaExpression* _tmp124_;
						ValaExpression* _tmp125_;
						ValaParameter* _tmp126_;
						ValaExpression* _tmp127_;
						ValaExpression* _tmp128_;
						ValaDataType* _tmp129_;
						ValaDataType* _tmp130_;
						const gchar* _tmp131_;
						ValaSymbol* _tmp132_;
						ValaSymbol* _tmp133_;
						_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp110_ = _tmp109_;
						_tmp111_ = vala_member_access_new (NULL, "this", _tmp110_);
						_tmp112_ = _tmp111_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp112_);
						_vala_code_node_unref0 (_tmp112_);
						_tmp113_ = vala_member_access_get_inner (self);
						_tmp114_ = _tmp113_;
						_tmp115_ = this_parameter;
						_tmp116_ = vala_variable_get_variable_type ((ValaVariable*) _tmp115_);
						_tmp117_ = _tmp116_;
						_tmp118_ = vala_data_type_copy (_tmp117_);
						_tmp119_ = _tmp118_;
						vala_expression_set_value_type (_tmp114_, _tmp119_);
						_vala_code_node_unref0 (_tmp119_);
						_tmp120_ = vala_member_access_get_inner (self);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_expression_get_value_type (_tmp121_);
						_tmp123_ = _tmp122_;
						vala_data_type_set_value_owned (_tmp123_, FALSE);
						_tmp124_ = vala_member_access_get_inner (self);
						_tmp125_ = _tmp124_;
						_tmp126_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp125_, (ValaSymbol*) _tmp126_);
						_tmp127_ = vala_member_access_get_inner (self);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_expression_get_value_type (_tmp128_);
						_tmp130_ = _tmp129_;
						_tmp131_ = self->priv->_member_name;
						_tmp132_ = vala_data_type_get_member (_tmp130_, _tmp131_);
						_tmp133_ = _tmp132_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp133_);
						_vala_code_node_unref0 (_tmp133_);
					}
				}
				_tmp134_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp135_ = _tmp134_;
				if (_tmp135_ == NULL) {
					ValaSymbol* _tmp136_;
					_tmp136_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp136_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp137_ = sym;
				_tmp138_ = vala_symbol_get_parent_symbol (_tmp137_);
				_tmp139_ = _tmp138_;
				sym = _tmp139_;
			}
			_tmp141_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp142_ = _tmp141_;
			if (_tmp142_ == NULL) {
				ValaSourceReference* _tmp143_;
				ValaSourceReference* _tmp144_;
				_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp144_ = _tmp143_;
				_tmp140_ = _tmp144_ != NULL;
			} else {
				_tmp140_ = FALSE;
			}
			if (_tmp140_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp145_;
					ValaSourceReference* _tmp146_;
					ValaList* _tmp147_;
					ValaList* _tmp148_;
					ValaList* _tmp149_;
					gint _ns_size = 0;
					ValaList* _tmp150_;
					gint _tmp151_;
					gint _tmp152_;
					gint _ns_index = 0;
					_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp146_ = _tmp145_;
					_tmp147_ = vala_source_reference_get_using_directives (_tmp146_);
					_tmp148_ = _tmp147_;
					_tmp149_ = _vala_iterable_ref0 (_tmp148_);
					_ns_list = _tmp149_;
					_tmp150_ = _ns_list;
					_tmp151_ = vala_collection_get_size ((ValaCollection*) _tmp150_);
					_tmp152_ = _tmp151_;
					_ns_size = _tmp152_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp153_;
						gint _tmp154_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp155_;
						gpointer _tmp156_;
						ValaUsingDirective* _tmp157_;
						gboolean _tmp158_;
						gboolean _tmp159_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp160_;
						ValaSymbol* _tmp161_;
						ValaSymbol* _tmp162_;
						ValaScope* _tmp163_;
						ValaScope* _tmp164_;
						const gchar* _tmp165_;
						ValaSymbol* _tmp166_;
						ValaSymbol* _tmp167_;
						_ns_index = _ns_index + 1;
						_tmp153_ = _ns_index;
						_tmp154_ = _ns_size;
						if (!(_tmp153_ < _tmp154_)) {
							break;
						}
						_tmp155_ = _ns_list;
						_tmp156_ = vala_list_get (_tmp155_, _ns_index);
						ns = (ValaUsingDirective*) _tmp156_;
						_tmp157_ = ns;
						_tmp158_ = vala_code_node_get_error ((ValaCodeNode*) _tmp157_);
						_tmp159_ = _tmp158_;
						if (_tmp159_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp160_ = ns;
						_tmp161_ = vala_using_directive_get_namespace_symbol (_tmp160_);
						_tmp162_ = _tmp161_;
						_tmp163_ = vala_symbol_get_scope (_tmp162_);
						_tmp164_ = _tmp163_;
						_tmp165_ = self->priv->_member_name;
						_tmp166_ = vala_scope_lookup (_tmp164_, _tmp165_);
						local_sym = _tmp166_;
						_tmp167_ = local_sym;
						if (_tmp167_ != NULL) {
							gboolean _tmp168_ = FALSE;
							ValaSymbol* _tmp169_;
							ValaSymbol* _tmp170_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp186_;
							ValaSymbol* _tmp187_;
							ValaSymbol* _tmp188_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp208_;
							ValaExpression* _tmp209_;
							ValaExpression* _tmp210_;
							ValaSymbol* _tmp211_;
							_tmp169_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp170_ = _tmp169_;
							if (_tmp170_ != NULL) {
								ValaSymbol* _tmp171_;
								ValaSymbol* _tmp172_;
								ValaSymbol* _tmp173_;
								_tmp171_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp172_ = _tmp171_;
								_tmp173_ = local_sym;
								_tmp168_ = _tmp172_ != _tmp173_;
							} else {
								_tmp168_ = FALSE;
							}
							if (_tmp168_) {
								ValaSourceReference* _tmp174_;
								ValaSourceReference* _tmp175_;
								const gchar* _tmp176_;
								ValaSymbol* _tmp177_;
								ValaSymbol* _tmp178_;
								gchar* _tmp179_;
								gchar* _tmp180_;
								ValaSymbol* _tmp181_;
								gchar* _tmp182_;
								gchar* _tmp183_;
								gchar* _tmp184_;
								gchar* _tmp185_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp174_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp175_ = _tmp174_;
								_tmp176_ = self->priv->_member_name;
								_tmp177_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp178_ = _tmp177_;
								_tmp179_ = vala_symbol_get_full_name (_tmp178_);
								_tmp180_ = _tmp179_;
								_tmp181_ = local_sym;
								_tmp182_ = vala_symbol_get_full_name (_tmp181_);
								_tmp183_ = _tmp182_;
								_tmp184_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp176_, _tmp180_, _tmp183_);
								_tmp185_ = _tmp184_;
								vala_report_error (_tmp175_, _tmp185_);
								_g_free0 (_tmp185_);
								_g_free0 (_tmp183_);
								_g_free0 (_tmp180_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								return result;
							}
							_tmp186_ = local_sym;
							_tmp187_ = vala_symbol_get_parent_symbol (_tmp186_);
							_tmp188_ = _tmp187_;
							inner_sym = _tmp188_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp189_ = FALSE;
								ValaSymbol* _tmp190_;
								ValaMemberAccess* _tmp194_;
								ValaSymbol* _tmp195_;
								const gchar* _tmp196_;
								const gchar* _tmp197_;
								ValaSourceReference* _tmp198_;
								ValaSourceReference* _tmp199_;
								ValaMemberAccess* _tmp200_;
								ValaMemberAccess* _tmp201_;
								ValaMemberAccess* _tmp202_;
								ValaExpression* _tmp203_;
								ValaExpression* _tmp204_;
								ValaSymbol* _tmp205_;
								ValaSymbol* _tmp206_;
								ValaSymbol* _tmp207_;
								_tmp190_ = inner_sym;
								if (_tmp190_ != NULL) {
									ValaSymbol* _tmp191_;
									const gchar* _tmp192_;
									const gchar* _tmp193_;
									_tmp191_ = inner_sym;
									_tmp192_ = vala_symbol_get_name (_tmp191_);
									_tmp193_ = _tmp192_;
									_tmp189_ = _tmp193_ != NULL;
								} else {
									_tmp189_ = FALSE;
								}
								if (!_tmp189_) {
									break;
								}
								_tmp194_ = inner_ma;
								_tmp195_ = inner_sym;
								_tmp196_ = vala_symbol_get_name (_tmp195_);
								_tmp197_ = _tmp196_;
								_tmp198_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp199_ = _tmp198_;
								_tmp200_ = vala_member_access_new (NULL, _tmp197_, _tmp199_);
								_tmp201_ = _tmp200_;
								vala_member_access_set_inner (_tmp194_, (ValaExpression*) _tmp201_);
								_vala_code_node_unref0 (_tmp201_);
								_tmp202_ = inner_ma;
								_tmp203_ = vala_member_access_get_inner (_tmp202_);
								_tmp204_ = _tmp203_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp205_ = inner_sym;
								_tmp206_ = vala_symbol_get_parent_symbol (_tmp205_);
								_tmp207_ = _tmp206_;
								inner_sym = _tmp207_;
							}
							_tmp208_ = inner_ma;
							vala_member_access_set_qualified (_tmp208_, TRUE);
							_tmp209_ = vala_member_access_get_inner (self);
							_tmp210_ = _tmp209_;
							vala_code_node_check ((ValaCodeNode*) _tmp210_, context);
							_tmp211_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp211_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
		} else {
			ValaExpression* _tmp212_;
			ValaExpression* _tmp213_;
			gboolean _tmp214_;
			gboolean _tmp215_;
			ValaExpression* _tmp216_;
			ValaExpression* _tmp217_;
			ValaDataType* _tmp218_;
			ValaDataType* _tmp219_;
			ValaExpression* _tmp250_;
			ValaExpression* _tmp251_;
			gboolean _tmp266_ = FALSE;
			ValaExpression* _tmp267_;
			ValaExpression* _tmp268_;
			gboolean _tmp275_ = FALSE;
			ValaExpression* _tmp276_;
			ValaExpression* _tmp277_;
			gboolean _tmp298_ = FALSE;
			ValaExpression* _tmp299_;
			ValaExpression* _tmp300_;
			gboolean _tmp319_ = FALSE;
			ValaSymbol* _tmp320_;
			ValaSymbol* _tmp321_;
			gboolean _tmp355_ = FALSE;
			gboolean _tmp356_ = FALSE;
			ValaSymbol* _tmp357_;
			ValaSymbol* _tmp358_;
			ValaSymbol* _tmp639_;
			ValaSymbol* _tmp640_;
			_tmp212_ = vala_member_access_get_inner (self);
			_tmp213_ = _tmp212_;
			_tmp214_ = vala_code_node_get_error ((ValaCodeNode*) _tmp213_);
			_tmp215_ = _tmp214_;
			if (_tmp215_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				return result;
			}
			_tmp216_ = vala_member_access_get_inner (self);
			_tmp217_ = _tmp216_;
			_tmp218_ = vala_expression_get_value_type (_tmp217_);
			_tmp219_ = _tmp218_;
			if (VALA_IS_POINTER_TYPE (_tmp219_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp220_;
				ValaExpression* _tmp221_;
				ValaDataType* _tmp222_;
				ValaDataType* _tmp223_;
				gboolean _tmp224_ = FALSE;
				ValaPointerType* _tmp225_;
				_tmp220_ = vala_member_access_get_inner (self);
				_tmp221_ = _tmp220_;
				_tmp222_ = vala_expression_get_value_type (_tmp221_);
				_tmp223_ = _tmp222_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp223_) ? ((ValaPointerType*) _tmp223_) : NULL;
				_tmp225_ = pointer_type;
				if (_tmp225_ != NULL) {
					ValaPointerType* _tmp226_;
					ValaDataType* _tmp227_;
					ValaDataType* _tmp228_;
					_tmp226_ = pointer_type;
					_tmp227_ = vala_pointer_type_get_base_type (_tmp226_);
					_tmp228_ = _tmp227_;
					_tmp224_ = VALA_IS_VALUE_TYPE (_tmp228_);
				} else {
					_tmp224_ = FALSE;
				}
				if (_tmp224_) {
					ValaExpression* _tmp229_;
					ValaExpression* _tmp230_;
					ValaDataType* _tmp231_;
					ValaDataType* _tmp232_;
					ValaExpression* _tmp242_;
					ValaExpression* _tmp243_;
					ValaSourceReference* _tmp244_;
					ValaSourceReference* _tmp245_;
					ValaPointerIndirection* _tmp246_;
					ValaPointerIndirection* _tmp247_;
					ValaExpression* _tmp248_;
					ValaExpression* _tmp249_;
					_tmp229_ = vala_member_access_get_inner (self);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_expression_get_formal_value_type (_tmp230_);
					_tmp232_ = _tmp231_;
					if (VALA_IS_GENERIC_TYPE (_tmp232_)) {
						ValaExpression* _tmp233_;
						ValaExpression* _tmp234_;
						ValaPointerType* _tmp235_;
						ValaDataType* _tmp236_;
						ValaDataType* _tmp237_;
						ValaSourceReference* _tmp238_;
						ValaSourceReference* _tmp239_;
						ValaCastExpression* _tmp240_;
						ValaCastExpression* _tmp241_;
						_tmp233_ = vala_member_access_get_inner (self);
						_tmp234_ = _tmp233_;
						_tmp235_ = pointer_type;
						_tmp236_ = vala_data_type_copy ((ValaDataType*) _tmp235_);
						_tmp237_ = _tmp236_;
						_tmp238_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp239_ = _tmp238_;
						_tmp240_ = vala_cast_expression_new (_tmp234_, _tmp237_, _tmp239_);
						_tmp241_ = _tmp240_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp241_);
						_vala_code_node_unref0 (_tmp241_);
						_vala_code_node_unref0 (_tmp237_);
					}
					_tmp242_ = vala_member_access_get_inner (self);
					_tmp243_ = _tmp242_;
					_tmp244_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp245_ = _tmp244_;
					_tmp246_ = vala_pointer_indirection_new (_tmp243_, _tmp245_);
					_tmp247_ = _tmp246_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp247_);
					_vala_code_node_unref0 (_tmp247_);
					_tmp248_ = vala_member_access_get_inner (self);
					_tmp249_ = _tmp248_;
					vala_code_node_check ((ValaCodeNode*) _tmp249_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp250_ = vala_member_access_get_inner (self);
			_tmp251_ = _tmp250_;
			if (VALA_IS_MEMBER_ACCESS (_tmp251_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp252_;
				ValaExpression* _tmp253_;
				ValaMemberAccess* _tmp254_;
				gboolean _tmp255_;
				_tmp252_ = vala_member_access_get_inner (self);
				_tmp253_ = _tmp252_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp253_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp254_ = ma;
				_tmp255_ = _tmp254_->priv->_prototype_access;
				if (_tmp255_) {
					ValaSourceReference* _tmp256_;
					ValaSourceReference* _tmp257_;
					ValaExpression* _tmp258_;
					ValaExpression* _tmp259_;
					ValaSymbol* _tmp260_;
					ValaSymbol* _tmp261_;
					gchar* _tmp262_;
					gchar* _tmp263_;
					gchar* _tmp264_;
					gchar* _tmp265_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp256_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp257_ = _tmp256_;
					_tmp258_ = vala_member_access_get_inner (self);
					_tmp259_ = _tmp258_;
					_tmp260_ = vala_expression_get_symbol_reference (_tmp259_);
					_tmp261_ = _tmp260_;
					_tmp262_ = vala_symbol_get_full_name (_tmp261_);
					_tmp263_ = _tmp262_;
					_tmp264_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp263_);
					_tmp265_ = _tmp264_;
					vala_report_error (_tmp257_, _tmp265_);
					_g_free0 (_tmp265_);
					_g_free0 (_tmp263_);
					result = FALSE;
					return result;
				}
			}
			_tmp267_ = vala_member_access_get_inner (self);
			_tmp268_ = _tmp267_;
			if (VALA_IS_CAST_EXPRESSION (_tmp268_)) {
				ValaExpression* _tmp269_;
				ValaExpression* _tmp270_;
				gboolean _tmp271_;
				gboolean _tmp272_;
				_tmp269_ = vala_member_access_get_inner (self);
				_tmp270_ = _tmp269_;
				_tmp271_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp270_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp272_ = _tmp271_;
				_tmp266_ = _tmp272_;
			} else {
				_tmp266_ = FALSE;
			}
			if (_tmp266_) {
				ValaSourceReference* _tmp273_;
				ValaSourceReference* _tmp274_;
				_tmp273_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp274_ = _tmp273_;
				vala_report_warning (_tmp274_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp276_ = vala_member_access_get_inner (self);
			_tmp277_ = _tmp276_;
			if (VALA_IS_MEMBER_ACCESS (_tmp277_)) {
				_tmp275_ = TRUE;
			} else {
				ValaExpression* _tmp278_;
				ValaExpression* _tmp279_;
				_tmp278_ = vala_member_access_get_inner (self);
				_tmp279_ = _tmp278_;
				_tmp275_ = VALA_IS_BASE_ACCESS (_tmp279_);
			}
			if (_tmp275_) {
				ValaExpression* _tmp280_;
				ValaExpression* _tmp281_;
				ValaSymbol* _tmp282_;
				ValaSymbol* _tmp283_;
				gboolean _tmp284_ = FALSE;
				ValaSymbol* _tmp285_;
				ValaSymbol* _tmp286_;
				_tmp280_ = vala_member_access_get_inner (self);
				_tmp281_ = _tmp280_;
				_tmp282_ = vala_expression_get_symbol_reference (_tmp281_);
				_tmp283_ = _tmp282_;
				base_symbol = _tmp283_;
				_tmp285_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp286_ = _tmp285_;
				if (_tmp286_ == NULL) {
					gboolean _tmp287_ = FALSE;
					ValaSymbol* _tmp288_;
					_tmp288_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp288_)) {
						_tmp287_ = TRUE;
					} else {
						ValaSymbol* _tmp289_;
						_tmp289_ = base_symbol;
						_tmp287_ = VALA_IS_TYPESYMBOL (_tmp289_);
					}
					_tmp284_ = _tmp287_;
				} else {
					_tmp284_ = FALSE;
				}
				if (_tmp284_) {
					ValaSymbol* _tmp290_;
					ValaScope* _tmp291_;
					ValaScope* _tmp292_;
					const gchar* _tmp293_;
					ValaSymbol* _tmp294_;
					ValaSymbol* _tmp295_;
					ValaExpression* _tmp296_;
					ValaExpression* _tmp297_;
					_tmp290_ = base_symbol;
					_tmp291_ = vala_symbol_get_scope (_tmp290_);
					_tmp292_ = _tmp291_;
					_tmp293_ = self->priv->_member_name;
					_tmp294_ = vala_scope_lookup (_tmp292_, _tmp293_);
					_tmp295_ = _tmp294_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp295_);
					_vala_code_node_unref0 (_tmp295_);
					_tmp296_ = vala_member_access_get_inner (self);
					_tmp297_ = _tmp296_;
					if (VALA_IS_BASE_ACCESS (_tmp297_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp299_ = vala_member_access_get_inner (self);
			_tmp300_ = _tmp299_;
			if (VALA_IS_MEMBER_ACCESS (_tmp300_)) {
				ValaExpression* _tmp301_;
				ValaExpression* _tmp302_;
				ValaSymbol* _tmp303_;
				ValaSymbol* _tmp304_;
				_tmp301_ = vala_member_access_get_inner (self);
				_tmp302_ = _tmp301_;
				_tmp303_ = vala_expression_get_symbol_reference (_tmp302_);
				_tmp304_ = _tmp303_;
				_tmp298_ = VALA_IS_TYPEPARAMETER (_tmp304_);
			} else {
				_tmp298_ = FALSE;
			}
			if (_tmp298_) {
				ValaExpression* _tmp305_;
				ValaExpression* _tmp306_;
				ValaExpression* _tmp307_;
				ValaExpression* _tmp308_;
				ValaSymbol* _tmp309_;
				ValaSymbol* _tmp310_;
				ValaGenericType* _tmp311_;
				ValaGenericType* _tmp312_;
				ValaExpression* _tmp313_;
				ValaExpression* _tmp314_;
				ValaDataType* _tmp315_;
				ValaDataType* _tmp316_;
				ValaSourceReference* _tmp317_;
				ValaSourceReference* _tmp318_;
				_tmp305_ = vala_member_access_get_inner (self);
				_tmp306_ = _tmp305_;
				_tmp307_ = vala_member_access_get_inner (self);
				_tmp308_ = _tmp307_;
				_tmp309_ = vala_expression_get_symbol_reference (_tmp308_);
				_tmp310_ = _tmp309_;
				_tmp311_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp310_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp312_ = _tmp311_;
				vala_expression_set_value_type (_tmp306_, (ValaDataType*) _tmp312_);
				_vala_code_node_unref0 (_tmp312_);
				_tmp313_ = vala_member_access_get_inner (self);
				_tmp314_ = _tmp313_;
				_tmp315_ = vala_expression_get_value_type (_tmp314_);
				_tmp316_ = _tmp315_;
				_tmp317_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp318_ = _tmp317_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp316_, _tmp318_);
			}
			_tmp320_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp321_ = _tmp320_;
			if (_tmp321_ == NULL) {
				ValaExpression* _tmp322_;
				ValaExpression* _tmp323_;
				ValaDataType* _tmp324_;
				ValaDataType* _tmp325_;
				_tmp322_ = vala_member_access_get_inner (self);
				_tmp323_ = _tmp322_;
				_tmp324_ = vala_expression_get_value_type (_tmp323_);
				_tmp325_ = _tmp324_;
				_tmp319_ = _tmp325_ != NULL;
			} else {
				_tmp319_ = FALSE;
			}
			if (_tmp319_) {
				gboolean _tmp326_;
				ValaSymbol* _tmp353_;
				ValaSymbol* _tmp354_;
				_tmp326_ = self->priv->_pointer_member_access;
				if (_tmp326_) {
					ValaExpression* _tmp327_;
					ValaExpression* _tmp328_;
					ValaDataType* _tmp329_;
					ValaDataType* _tmp330_;
					const gchar* _tmp331_;
					ValaSymbol* _tmp332_;
					ValaSymbol* _tmp333_;
					_tmp327_ = vala_member_access_get_inner (self);
					_tmp328_ = _tmp327_;
					_tmp329_ = vala_expression_get_value_type (_tmp328_);
					_tmp330_ = _tmp329_;
					_tmp331_ = self->priv->_member_name;
					_tmp332_ = vala_data_type_get_pointer_member (_tmp330_, _tmp331_);
					_tmp333_ = _tmp332_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp333_);
					_vala_code_node_unref0 (_tmp333_);
				} else {
					ValaExpression* _tmp334_;
					ValaExpression* _tmp335_;
					ValaDataType* _tmp336_;
					ValaDataType* _tmp337_;
					ValaTypeSymbol* _tmp338_;
					ValaTypeSymbol* _tmp339_;
					ValaExpression* _tmp346_;
					ValaExpression* _tmp347_;
					ValaDataType* _tmp348_;
					ValaDataType* _tmp349_;
					const gchar* _tmp350_;
					ValaSymbol* _tmp351_;
					ValaSymbol* _tmp352_;
					_tmp334_ = vala_member_access_get_inner (self);
					_tmp335_ = _tmp334_;
					_tmp336_ = vala_expression_get_value_type (_tmp335_);
					_tmp337_ = _tmp336_;
					_tmp338_ = vala_data_type_get_type_symbol (_tmp337_);
					_tmp339_ = _tmp338_;
					if (_tmp339_ != NULL) {
						ValaExpression* _tmp340_;
						ValaExpression* _tmp341_;
						ValaDataType* _tmp342_;
						ValaDataType* _tmp343_;
						ValaTypeSymbol* _tmp344_;
						ValaTypeSymbol* _tmp345_;
						_tmp340_ = vala_member_access_get_inner (self);
						_tmp341_ = _tmp340_;
						_tmp342_ = vala_expression_get_value_type (_tmp341_);
						_tmp343_ = _tmp342_;
						_tmp344_ = vala_data_type_get_type_symbol (_tmp343_);
						_tmp345_ = _tmp344_;
						base_symbol = (ValaSymbol*) _tmp345_;
					}
					_tmp346_ = vala_member_access_get_inner (self);
					_tmp347_ = _tmp346_;
					_tmp348_ = vala_expression_get_value_type (_tmp347_);
					_tmp349_ = _tmp348_;
					_tmp350_ = self->priv->_member_name;
					_tmp351_ = vala_data_type_get_member (_tmp349_, _tmp350_);
					_tmp352_ = _tmp351_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp352_);
					_vala_code_node_unref0 (_tmp352_);
				}
				_tmp353_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp354_ = _tmp353_;
				if (_tmp354_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp357_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp358_ = _tmp357_;
			if (_tmp358_ == NULL) {
				ValaExpression* _tmp359_;
				ValaExpression* _tmp360_;
				ValaDataType* _tmp361_;
				ValaDataType* _tmp362_;
				_tmp359_ = vala_member_access_get_inner (self);
				_tmp360_ = _tmp359_;
				_tmp361_ = vala_expression_get_value_type (_tmp360_);
				_tmp362_ = _tmp361_;
				_tmp356_ = _tmp362_ != NULL;
			} else {
				_tmp356_ = FALSE;
			}
			if (_tmp356_) {
				ValaExpression* _tmp363_;
				ValaExpression* _tmp364_;
				ValaDataType* _tmp365_;
				ValaDataType* _tmp366_;
				gboolean _tmp367_;
				gboolean _tmp368_;
				_tmp363_ = vala_member_access_get_inner (self);
				_tmp364_ = _tmp363_;
				_tmp365_ = vala_expression_get_value_type (_tmp364_);
				_tmp366_ = _tmp365_;
				_tmp367_ = vala_data_type_get_is_dynamic (_tmp366_);
				_tmp368_ = _tmp367_;
				_tmp355_ = _tmp368_;
			} else {
				_tmp355_ = FALSE;
			}
			if (_tmp355_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp369_;
				ValaExpression* _tmp370_;
				ValaDataType* _tmp371_;
				ValaDataType* _tmp372_;
				ValaObjectType* _tmp373_;
				ValaCodeNode* _tmp374_;
				ValaCodeNode* _tmp375_;
				ValaSymbol* _tmp572_;
				ValaSymbol* _tmp573_;
				ValaSymbol* _tmp637_;
				ValaSymbol* _tmp638_;
				_tmp369_ = vala_member_access_get_inner (self);
				_tmp370_ = _tmp369_;
				_tmp371_ = vala_expression_get_value_type (_tmp370_);
				_tmp372_ = _tmp371_;
				_tmp373_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp372_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp373_;
				_tmp374_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp375_ = _tmp374_;
				if (VALA_IS_METHOD_CALL (_tmp375_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp376_;
					ValaCodeNode* _tmp377_;
					ValaMethodCall* _tmp378_;
					ValaExpression* _tmp379_;
					ValaExpression* _tmp380_;
					_tmp376_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp377_ = _tmp376_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp377_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp378_ = invoc;
					_tmp379_ = vala_method_call_get_call (_tmp378_);
					_tmp380_ = _tmp379_;
					if (_tmp380_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp381_;
						ValaDataType* _tmp382_;
						ValaDataType* _tmp383_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp398_;
						ValaExpression* _tmp399_;
						ValaDataType* _tmp400_;
						ValaDataType* _tmp401_;
						const gchar* _tmp402_;
						ValaDataType* _tmp403_;
						ValaSourceReference* _tmp404_;
						ValaSourceReference* _tmp405_;
						ValaDynamicMethod* _tmp406_;
						ValaDynamicMethod* _tmp407_;
						ValaMethodCall* _tmp408_;
						ValaErrorType* err = NULL;
						ValaDynamicMethod* _tmp409_;
						ValaSourceReference* _tmp410_;
						ValaSourceReference* _tmp411_;
						ValaErrorType* _tmp412_;
						ValaErrorType* _tmp413_;
						ValaDynamicMethod* _tmp414_;
						ValaErrorType* _tmp415_;
						ValaDynamicMethod* _tmp416_;
						ValaDynamicMethod* _tmp417_;
						ValaParameter* _tmp418_;
						ValaParameter* _tmp419_;
						ValaDynamicMethod* _tmp420_;
						ValaObjectType* _tmp421_;
						ValaDataType* _tmp422_;
						ValaDataType* _tmp423_;
						ValaDynamicMethod* _tmp424_;
						ValaSourceReference* _tmp425_;
						ValaSourceReference* _tmp426_;
						ValaParameter* _tmp427_;
						ValaParameter* _tmp428_;
						ValaObjectType* _tmp429_;
						ValaTypeSymbol* _tmp430_;
						ValaTypeSymbol* _tmp431_;
						ValaScope* _tmp432_;
						ValaScope* _tmp433_;
						ValaDynamicMethod* _tmp434_;
						ValaDynamicMethod* _tmp435_;
						_tmp381_ = invoc;
						_tmp382_ = vala_expression_get_target_type ((ValaExpression*) _tmp381_);
						_tmp383_ = _tmp382_;
						if (_tmp383_ != NULL) {
							ValaMethodCall* _tmp384_;
							ValaDataType* _tmp385_;
							ValaDataType* _tmp386_;
							ValaDataType* _tmp387_;
							ValaDataType* _tmp388_;
							_tmp384_ = invoc;
							_tmp385_ = vala_expression_get_target_type ((ValaExpression*) _tmp384_);
							_tmp386_ = _tmp385_;
							_tmp387_ = vala_data_type_copy (_tmp386_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp387_;
							_tmp388_ = ret_type;
							vala_data_type_set_value_owned (_tmp388_, TRUE);
						} else {
							ValaMethodCall* _tmp389_;
							ValaCodeNode* _tmp390_;
							ValaCodeNode* _tmp391_;
							_tmp389_ = invoc;
							_tmp390_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp389_);
							_tmp391_ = _tmp390_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp391_)) {
								ValaVoidType* _tmp392_;
								_tmp392_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp392_;
							} else {
								ValaExpression* _tmp393_;
								ValaExpression* _tmp394_;
								ValaDataType* _tmp395_;
								ValaDataType* _tmp396_;
								ValaDataType* _tmp397_;
								_tmp393_ = vala_member_access_get_inner (self);
								_tmp394_ = _tmp393_;
								_tmp395_ = vala_expression_get_value_type (_tmp394_);
								_tmp396_ = _tmp395_;
								_tmp397_ = vala_data_type_copy (_tmp396_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp397_;
							}
						}
						_tmp398_ = vala_member_access_get_inner (self);
						_tmp399_ = _tmp398_;
						_tmp400_ = vala_expression_get_value_type (_tmp399_);
						_tmp401_ = _tmp400_;
						_tmp402_ = self->priv->_member_name;
						_tmp403_ = ret_type;
						_tmp404_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp405_ = _tmp404_;
						_tmp406_ = vala_dynamic_method_new (_tmp401_, _tmp402_, _tmp403_, _tmp405_, NULL);
						m = _tmp406_;
						_tmp407_ = m;
						_tmp408_ = invoc;
						vala_dynamic_method_set_invocation (_tmp407_, _tmp408_);
						_tmp409_ = m;
						_tmp410_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp409_);
						_tmp411_ = _tmp410_;
						_tmp412_ = vala_error_type_new (NULL, NULL, _tmp411_);
						err = _tmp412_;
						_tmp413_ = err;
						vala_error_type_set_dynamic_error (_tmp413_, TRUE);
						_tmp414_ = m;
						_tmp415_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp414_, (ValaDataType*) _tmp415_);
						_tmp416_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp416_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp417_ = m;
						_tmp418_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp419_ = _tmp418_;
						vala_callable_add_parameter ((ValaCallable*) _tmp417_, _tmp419_);
						_vala_code_node_unref0 (_tmp419_);
						_tmp420_ = m;
						_tmp421_ = dynamic_object_type;
						_tmp422_ = vala_data_type_copy ((ValaDataType*) _tmp421_);
						_tmp423_ = _tmp422_;
						_tmp424_ = m;
						_tmp425_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp424_);
						_tmp426_ = _tmp425_;
						_tmp427_ = vala_parameter_new ("this", _tmp423_, _tmp426_);
						_tmp428_ = _tmp427_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp420_, _tmp428_);
						_vala_code_node_unref0 (_tmp428_);
						_vala_code_node_unref0 (_tmp423_);
						_tmp429_ = dynamic_object_type;
						_tmp430_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp429_);
						_tmp431_ = _tmp430_;
						_tmp432_ = vala_symbol_get_scope ((ValaSymbol*) _tmp431_);
						_tmp433_ = _tmp432_;
						_tmp434_ = m;
						vala_scope_add (_tmp433_, NULL, (ValaSymbol*) _tmp434_);
						_tmp435_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp435_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp436_;
					ValaCodeNode* _tmp437_;
					_tmp436_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp437_ = _tmp436_;
					if (VALA_IS_ASSIGNMENT (_tmp437_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp438_;
						ValaCodeNode* _tmp439_;
						ValaAssignment* _tmp440_;
						ValaExpression* _tmp441_;
						ValaExpression* _tmp442_;
						_tmp438_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp439_ = _tmp438_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp439_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp440_ = a;
						_tmp441_ = vala_assignment_get_left (_tmp440_);
						_tmp442_ = _tmp441_;
						if (_tmp442_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp443_;
							ValaExpression* _tmp444_;
							ValaDataType* _tmp445_;
							ValaDataType* _tmp446_;
							const gchar* _tmp447_;
							ValaSourceReference* _tmp448_;
							ValaSourceReference* _tmp449_;
							ValaDynamicProperty* _tmp450_;
							ValaDynamicProperty* _tmp451_;
							ValaDynamicProperty* _tmp452_;
							ValaDynamicProperty* _tmp453_;
							ValaSourceReference* _tmp454_;
							ValaSourceReference* _tmp455_;
							ValaPropertyAccessor* _tmp456_;
							ValaPropertyAccessor* _tmp457_;
							ValaDynamicProperty* _tmp458_;
							ValaExpression* _tmp459_;
							ValaExpression* _tmp460_;
							ValaDataType* _tmp461_;
							ValaDataType* _tmp462_;
							ValaTypeSymbol* _tmp463_;
							ValaTypeSymbol* _tmp464_;
							ValaScope* _tmp465_;
							ValaScope* _tmp466_;
							ValaObjectType* _tmp467_;
							ValaTypeSymbol* _tmp468_;
							ValaTypeSymbol* _tmp469_;
							ValaScope* _tmp470_;
							ValaScope* _tmp471_;
							ValaDynamicProperty* _tmp472_;
							ValaDynamicProperty* _tmp473_;
							ValaObjectType* _tmp474_;
							ValaTypeSymbol* _tmp475_;
							ValaTypeSymbol* _tmp476_;
							ValaSemanticAnalyzer* _tmp477_;
							ValaSemanticAnalyzer* _tmp478_;
							ValaClass* _tmp479_;
							_tmp443_ = vala_member_access_get_inner (self);
							_tmp444_ = _tmp443_;
							_tmp445_ = vala_expression_get_value_type (_tmp444_);
							_tmp446_ = _tmp445_;
							_tmp447_ = self->priv->_member_name;
							_tmp448_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp449_ = _tmp448_;
							_tmp450_ = vala_dynamic_property_new (_tmp446_, _tmp447_, _tmp449_, NULL);
							prop = _tmp450_;
							_tmp451_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp451_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp452_ = prop;
							_tmp453_ = prop;
							_tmp454_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp453_);
							_tmp455_ = _tmp454_;
							_tmp456_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp455_, NULL);
							_tmp457_ = _tmp456_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp452_, _tmp457_);
							_vala_code_node_unref0 (_tmp457_);
							_tmp458_ = prop;
							_tmp459_ = vala_member_access_get_inner (self);
							_tmp460_ = _tmp459_;
							_tmp461_ = vala_expression_get_value_type (_tmp460_);
							_tmp462_ = _tmp461_;
							_tmp463_ = vala_data_type_get_type_symbol (_tmp462_);
							_tmp464_ = _tmp463_;
							_tmp465_ = vala_symbol_get_scope ((ValaSymbol*) _tmp464_);
							_tmp466_ = _tmp465_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp458_, _tmp466_);
							_tmp467_ = dynamic_object_type;
							_tmp468_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp467_);
							_tmp469_ = _tmp468_;
							_tmp470_ = vala_symbol_get_scope ((ValaSymbol*) _tmp469_);
							_tmp471_ = _tmp470_;
							_tmp472_ = prop;
							vala_scope_add (_tmp471_, NULL, (ValaSymbol*) _tmp472_);
							_tmp473_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp473_);
							_tmp474_ = dynamic_object_type;
							_tmp475_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp474_);
							_tmp476_ = _tmp475_;
							_tmp477_ = vala_code_context_get_analyzer (context);
							_tmp478_ = _tmp477_;
							_tmp479_ = _tmp478_->object_type;
							if (!vala_typesymbol_is_subtype_of (_tmp476_, (ValaTypeSymbol*) _tmp479_)) {
								ValaSourceReference* _tmp480_;
								ValaSourceReference* _tmp481_;
								ValaObjectType* _tmp482_;
								ValaTypeSymbol* _tmp483_;
								ValaTypeSymbol* _tmp484_;
								gchar* _tmp485_;
								gchar* _tmp486_;
								gchar* _tmp487_;
								gchar* _tmp488_;
								_tmp480_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp481_ = _tmp480_;
								_tmp482_ = dynamic_object_type;
								_tmp483_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp482_);
								_tmp484_ = _tmp483_;
								_tmp485_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp484_);
								_tmp486_ = _tmp485_;
								_tmp487_ = g_strdup_printf ("dynamic properties are not supported for `%s'", _tmp486_);
								_tmp488_ = _tmp487_;
								vala_report_error (_tmp481_, _tmp488_);
								_g_free0 (_tmp488_);
								_g_free0 (_tmp486_);
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							}
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp489_ = FALSE;
						gboolean _tmp490_ = FALSE;
						ValaCodeNode* _tmp491_;
						ValaCodeNode* _tmp492_;
						_tmp491_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp492_ = _tmp491_;
						if (VALA_IS_MEMBER_ACCESS (_tmp492_)) {
							ValaExpression* _tmp493_;
							ValaExpression* _tmp494_;
							_tmp493_ = vala_member_access_get_inner (self);
							_tmp494_ = _tmp493_;
							_tmp490_ = VALA_IS_MEMBER_ACCESS (_tmp494_);
						} else {
							_tmp490_ = FALSE;
						}
						if (_tmp490_) {
							ValaCodeNode* _tmp495_;
							ValaCodeNode* _tmp496_;
							ValaCodeNode* _tmp497_;
							ValaCodeNode* _tmp498_;
							_tmp495_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp496_ = _tmp495_;
							_tmp497_ = vala_code_node_get_parent_node (_tmp496_);
							_tmp498_ = _tmp497_;
							_tmp489_ = VALA_IS_METHOD_CALL (_tmp498_);
						} else {
							_tmp489_ = FALSE;
						}
						if (_tmp489_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp499_;
							ValaCodeNode* _tmp500_;
							gboolean _tmp501_ = FALSE;
							ValaMemberAccess* _tmp502_;
							const gchar* _tmp503_;
							_tmp499_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp500_ = _tmp499_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp500_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp502_ = ma;
							_tmp503_ = _tmp502_->priv->_member_name;
							if (g_strcmp0 (_tmp503_, "connect") == 0) {
								_tmp501_ = TRUE;
							} else {
								ValaMemberAccess* _tmp504_;
								const gchar* _tmp505_;
								_tmp504_ = ma;
								_tmp505_ = _tmp504_->priv->_member_name;
								_tmp501_ = g_strcmp0 (_tmp505_, "connect_after") == 0;
							}
							if (_tmp501_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp506_;
								ValaExpression* _tmp507_;
								ValaDataType* _tmp508_;
								ValaDataType* _tmp509_;
								const gchar* _tmp510_;
								ValaVoidType* _tmp511_;
								ValaVoidType* _tmp512_;
								ValaSourceReference* _tmp513_;
								ValaSourceReference* _tmp514_;
								ValaDynamicSignal* _tmp515_;
								ValaDynamicSignal* _tmp516_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp517_;
								ValaCodeNode* _tmp518_;
								ValaCodeNode* _tmp519_;
								ValaCodeNode* _tmp520_;
								ValaMethodCall* _tmp521_;
								ValaMethodCall* _tmp522_;
								ValaList* _tmp523_;
								gint _tmp524_;
								gint _tmp525_;
								ValaDynamicSignal* _tmp559_;
								ValaObjectType* _tmp560_;
								ValaTypeSymbol* _tmp561_;
								ValaTypeSymbol* _tmp562_;
								ValaScope* _tmp563_;
								ValaScope* _tmp564_;
								ValaDynamicSignal* _tmp565_;
								ValaDynamicSignal* _tmp566_;
								_tmp506_ = vala_member_access_get_inner (self);
								_tmp507_ = _tmp506_;
								_tmp508_ = vala_expression_get_value_type (_tmp507_);
								_tmp509_ = _tmp508_;
								_tmp510_ = self->priv->_member_name;
								_tmp511_ = vala_void_type_new (NULL);
								_tmp512_ = _tmp511_;
								_tmp513_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp514_ = _tmp513_;
								_tmp515_ = vala_dynamic_signal_new (_tmp509_, _tmp510_, (ValaDataType*) _tmp512_, _tmp514_, NULL);
								_tmp516_ = _tmp515_;
								_vala_code_node_unref0 (_tmp512_);
								s = _tmp516_;
								_tmp517_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp518_ = _tmp517_;
								_tmp519_ = vala_code_node_get_parent_node (_tmp518_);
								_tmp520_ = _tmp519_;
								_tmp521_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp520_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp521_;
								_tmp522_ = mcall;
								_tmp523_ = vala_method_call_get_argument_list (_tmp522_);
								_tmp524_ = vala_collection_get_size ((ValaCollection*) _tmp523_);
								_tmp525_ = _tmp524_;
								if (_tmp525_ > 0) {
									ValaDynamicSignal* _tmp526_;
									ValaMethodCall* _tmp527_;
									ValaList* _tmp528_;
									gpointer _tmp529_;
									ValaExpression* _tmp530_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp531_;
									ValaExpression* _tmp532_;
									ValaExpression* _tmp533_;
									gboolean _tmp534_ = FALSE;
									gboolean _tmp535_ = FALSE;
									ValaMemberAccess* _tmp536_;
									_tmp526_ = s;
									_tmp527_ = mcall;
									_tmp528_ = vala_method_call_get_argument_list (_tmp527_);
									_tmp529_ = vala_list_get (_tmp528_, 0);
									_tmp530_ = (ValaExpression*) _tmp529_;
									vala_dynamic_signal_set_handler (_tmp526_, _tmp530_);
									_vala_code_node_unref0 (_tmp530_);
									_tmp531_ = s;
									_tmp532_ = vala_dynamic_signal_get_handler (_tmp531_);
									_tmp533_ = _tmp532_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp533_) ? ((ValaMemberAccess*) _tmp533_) : NULL;
									_tmp536_ = arg;
									if (_tmp536_ == NULL) {
										_tmp535_ = TRUE;
									} else {
										ValaMemberAccess* _tmp537_;
										_tmp537_ = arg;
										_tmp535_ = !vala_code_node_check ((ValaCodeNode*) _tmp537_, context);
									}
									if (_tmp535_) {
										_tmp534_ = TRUE;
									} else {
										ValaMemberAccess* _tmp538_;
										ValaSymbol* _tmp539_;
										ValaSymbol* _tmp540_;
										_tmp538_ = arg;
										_tmp539_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp538_);
										_tmp540_ = _tmp539_;
										_tmp534_ = !VALA_IS_METHOD (_tmp540_);
									}
									if (_tmp534_) {
										ValaDynamicSignal* _tmp541_;
										ValaExpression* _tmp542_;
										ValaExpression* _tmp543_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp541_ = s;
										_tmp542_ = vala_dynamic_signal_get_handler (_tmp541_);
										_tmp543_ = _tmp542_;
										if (VALA_IS_LAMBDA_EXPRESSION (_tmp543_)) {
											ValaDynamicSignal* _tmp544_;
											ValaExpression* _tmp545_;
											ValaExpression* _tmp546_;
											ValaSourceReference* _tmp547_;
											ValaSourceReference* _tmp548_;
											_tmp544_ = s;
											_tmp545_ = vala_dynamic_signal_get_handler (_tmp544_);
											_tmp546_ = _tmp545_;
											_tmp547_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp546_);
											_tmp548_ = _tmp547_;
											vala_report_error (_tmp548_, "Lambdas are not allowed for dynamic signals");
										} else {
											ValaDynamicSignal* _tmp549_;
											ValaExpression* _tmp550_;
											ValaExpression* _tmp551_;
											ValaSourceReference* _tmp552_;
											ValaSourceReference* _tmp553_;
											ValaDynamicSignal* _tmp554_;
											gchar* _tmp555_;
											gchar* _tmp556_;
											gchar* _tmp557_;
											gchar* _tmp558_;
											_tmp549_ = s;
											_tmp550_ = vala_dynamic_signal_get_handler (_tmp549_);
											_tmp551_ = _tmp550_;
											_tmp552_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp551_);
											_tmp553_ = _tmp552_;
											_tmp554_ = s;
											_tmp555_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp554_);
											_tmp556_ = _tmp555_;
											_tmp557_ = g_strdup_printf ("Cannot infer call signature for dynamic signal `%s' from given express" \
"ion", _tmp556_);
											_tmp558_ = _tmp557_;
											vala_report_error (_tmp553_, _tmp558_);
											_g_free0 (_tmp558_);
											_g_free0 (_tmp556_);
										}
									}
								}
								_tmp559_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp559_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp560_ = dynamic_object_type;
								_tmp561_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp560_);
								_tmp562_ = _tmp561_;
								_tmp563_ = vala_symbol_get_scope ((ValaSymbol*) _tmp562_);
								_tmp564_ = _tmp563_;
								_tmp565_ = s;
								vala_scope_add (_tmp564_, NULL, (ValaSymbol*) _tmp565_);
								_tmp566_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp566_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							} else {
								ValaMemberAccess* _tmp567_;
								const gchar* _tmp568_;
								_tmp567_ = ma;
								_tmp568_ = _tmp567_->priv->_member_name;
								if (g_strcmp0 (_tmp568_, "disconnect") == 0) {
									ValaMemberAccess* _tmp569_;
									ValaSourceReference* _tmp570_;
									ValaSourceReference* _tmp571_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp569_ = ma;
									_tmp570_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp569_);
									_tmp571_ = _tmp570_;
									vala_report_error (_tmp571_, "Use SignalHandler.disconnect() to disconnect from dynamic signal");
								}
							}
						}
					}
				}
				_tmp572_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp573_ = _tmp572_;
				if (_tmp573_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp574_;
					ValaExpression* _tmp575_;
					ValaDataType* _tmp576_;
					ValaDataType* _tmp577_;
					const gchar* _tmp578_;
					ValaSourceReference* _tmp579_;
					ValaSourceReference* _tmp580_;
					ValaDynamicProperty* _tmp581_;
					ValaDataType* _tmp582_;
					ValaDataType* _tmp583_;
					ValaDynamicProperty* _tmp594_;
					ValaDynamicProperty* _tmp595_;
					ValaDynamicProperty* _tmp596_;
					ValaDataType* _tmp597_;
					ValaDataType* _tmp598_;
					ValaDataType* _tmp599_;
					ValaDataType* _tmp600_;
					ValaDynamicProperty* _tmp601_;
					ValaSourceReference* _tmp602_;
					ValaSourceReference* _tmp603_;
					ValaPropertyAccessor* _tmp604_;
					ValaPropertyAccessor* _tmp605_;
					ValaDynamicProperty* _tmp606_;
					ValaExpression* _tmp607_;
					ValaExpression* _tmp608_;
					ValaDataType* _tmp609_;
					ValaDataType* _tmp610_;
					ValaTypeSymbol* _tmp611_;
					ValaTypeSymbol* _tmp612_;
					ValaScope* _tmp613_;
					ValaScope* _tmp614_;
					ValaObjectType* _tmp615_;
					ValaTypeSymbol* _tmp616_;
					ValaTypeSymbol* _tmp617_;
					ValaScope* _tmp618_;
					ValaScope* _tmp619_;
					ValaDynamicProperty* _tmp620_;
					ValaDynamicProperty* _tmp621_;
					ValaObjectType* _tmp622_;
					ValaTypeSymbol* _tmp623_;
					ValaTypeSymbol* _tmp624_;
					ValaSemanticAnalyzer* _tmp625_;
					ValaSemanticAnalyzer* _tmp626_;
					ValaClass* _tmp627_;
					_tmp574_ = vala_member_access_get_inner (self);
					_tmp575_ = _tmp574_;
					_tmp576_ = vala_expression_get_value_type (_tmp575_);
					_tmp577_ = _tmp576_;
					_tmp578_ = self->priv->_member_name;
					_tmp579_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp580_ = _tmp579_;
					_tmp581_ = vala_dynamic_property_new (_tmp577_, _tmp578_, _tmp580_, NULL);
					prop = _tmp581_;
					_tmp582_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp583_ = _tmp582_;
					if (_tmp583_ != NULL) {
						ValaDynamicProperty* _tmp584_;
						ValaDataType* _tmp585_;
						ValaDataType* _tmp586_;
						_tmp584_ = prop;
						_tmp585_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp586_ = _tmp585_;
						vala_property_set_property_type ((ValaProperty*) _tmp584_, _tmp586_);
					} else {
						ValaDynamicProperty* _tmp587_;
						ValaExpression* _tmp588_;
						ValaExpression* _tmp589_;
						ValaDataType* _tmp590_;
						ValaDataType* _tmp591_;
						ValaDataType* _tmp592_;
						ValaDataType* _tmp593_;
						_tmp587_ = prop;
						_tmp588_ = vala_member_access_get_inner (self);
						_tmp589_ = _tmp588_;
						_tmp590_ = vala_expression_get_value_type (_tmp589_);
						_tmp591_ = _tmp590_;
						_tmp592_ = vala_data_type_copy (_tmp591_);
						_tmp593_ = _tmp592_;
						vala_property_set_property_type ((ValaProperty*) _tmp587_, _tmp593_);
						_vala_code_node_unref0 (_tmp593_);
					}
					_tmp594_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp594_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp595_ = prop;
					_tmp596_ = prop;
					_tmp597_ = vala_property_get_property_type ((ValaProperty*) _tmp596_);
					_tmp598_ = _tmp597_;
					_tmp599_ = vala_data_type_copy (_tmp598_);
					_tmp600_ = _tmp599_;
					_tmp601_ = prop;
					_tmp602_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp601_);
					_tmp603_ = _tmp602_;
					_tmp604_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp600_, NULL, _tmp603_, NULL);
					_tmp605_ = _tmp604_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp595_, _tmp605_);
					_vala_code_node_unref0 (_tmp605_);
					_vala_code_node_unref0 (_tmp600_);
					_tmp606_ = prop;
					_tmp607_ = vala_member_access_get_inner (self);
					_tmp608_ = _tmp607_;
					_tmp609_ = vala_expression_get_value_type (_tmp608_);
					_tmp610_ = _tmp609_;
					_tmp611_ = vala_data_type_get_type_symbol (_tmp610_);
					_tmp612_ = _tmp611_;
					_tmp613_ = vala_symbol_get_scope ((ValaSymbol*) _tmp612_);
					_tmp614_ = _tmp613_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp606_, _tmp614_);
					_tmp615_ = dynamic_object_type;
					_tmp616_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp615_);
					_tmp617_ = _tmp616_;
					_tmp618_ = vala_symbol_get_scope ((ValaSymbol*) _tmp617_);
					_tmp619_ = _tmp618_;
					_tmp620_ = prop;
					vala_scope_add (_tmp619_, NULL, (ValaSymbol*) _tmp620_);
					_tmp621_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp621_);
					_tmp622_ = dynamic_object_type;
					_tmp623_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp622_);
					_tmp624_ = _tmp623_;
					_tmp625_ = vala_code_context_get_analyzer (context);
					_tmp626_ = _tmp625_;
					_tmp627_ = _tmp626_->object_type;
					if (!vala_typesymbol_is_subtype_of (_tmp624_, (ValaTypeSymbol*) _tmp627_)) {
						ValaSourceReference* _tmp628_;
						ValaSourceReference* _tmp629_;
						ValaObjectType* _tmp630_;
						ValaTypeSymbol* _tmp631_;
						ValaTypeSymbol* _tmp632_;
						gchar* _tmp633_;
						gchar* _tmp634_;
						gchar* _tmp635_;
						gchar* _tmp636_;
						_tmp628_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp629_ = _tmp628_;
						_tmp630_ = dynamic_object_type;
						_tmp631_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp630_);
						_tmp632_ = _tmp631_;
						_tmp633_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp632_);
						_tmp634_ = _tmp633_;
						_tmp635_ = g_strdup_printf ("dynamic properties are not supported for %s", _tmp634_);
						_tmp636_ = _tmp635_;
						vala_report_error (_tmp629_, _tmp636_);
						_g_free0 (_tmp636_);
						_g_free0 (_tmp634_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_vala_code_node_unref0 (prop);
				}
				_tmp637_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp638_ = _tmp637_;
				if (_tmp638_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp639_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp640_ = _tmp639_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp640_)) {
				ValaExpression* _tmp641_;
				ValaExpression* _tmp642_;
				ValaSymbol* _tmp643_;
				ValaSymbol* _tmp644_;
				_tmp641_ = vala_member_access_get_inner (self);
				_tmp642_ = _tmp641_;
				_tmp643_ = vala_expression_get_symbol_reference (_tmp642_);
				_tmp644_ = _tmp643_;
				if (VALA_IS_VARIABLE (_tmp644_)) {
					ValaArrayType* inner_type = NULL;
					ValaSemanticAnalyzer* _tmp645_;
					ValaSemanticAnalyzer* _tmp646_;
					ValaExpression* _tmp647_;
					ValaExpression* _tmp648_;
					ValaSymbol* _tmp649_;
					ValaSymbol* _tmp650_;
					ValaDataType* _tmp651_;
					ValaArrayType* _tmp652_;
					gboolean _tmp653_ = FALSE;
					ValaArrayType* _tmp654_;
					_tmp645_ = vala_code_context_get_analyzer (context);
					_tmp646_ = _tmp645_;
					_tmp647_ = vala_member_access_get_inner (self);
					_tmp648_ = _tmp647_;
					_tmp649_ = vala_expression_get_symbol_reference (_tmp648_);
					_tmp650_ = _tmp649_;
					_tmp651_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp646_, _tmp650_, TRUE);
					_tmp652_ = VALA_IS_ARRAY_TYPE (_tmp651_) ? ((ValaArrayType*) _tmp651_) : NULL;
					if (_tmp652_ == NULL) {
						_vala_code_node_unref0 (_tmp651_);
					}
					inner_type = _tmp652_;
					_tmp654_ = inner_type;
					if (_tmp654_ != NULL) {
						ValaArrayType* _tmp655_;
						gboolean _tmp656_;
						gboolean _tmp657_;
						_tmp655_ = inner_type;
						_tmp656_ = vala_array_type_get_inline_allocated (_tmp655_);
						_tmp657_ = _tmp656_;
						_tmp653_ = _tmp657_;
					} else {
						_tmp653_ = FALSE;
					}
					if (_tmp653_) {
						ValaSourceReference* _tmp658_;
						ValaSourceReference* _tmp659_;
						_tmp658_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp659_ = _tmp658_;
						vala_report_error (_tmp659_, "`resize' is not supported for arrays with fixed length");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					} else {
						gboolean _tmp660_ = FALSE;
						ValaArrayType* _tmp661_;
						_tmp661_ = inner_type;
						if (_tmp661_ != NULL) {
							ValaArrayType* _tmp662_;
							gboolean _tmp663_;
							gboolean _tmp664_;
							_tmp662_ = inner_type;
							_tmp663_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp662_);
							_tmp664_ = _tmp663_;
							_tmp660_ = !_tmp664_;
						} else {
							_tmp660_ = FALSE;
						}
						if (_tmp660_) {
							ValaSourceReference* _tmp665_;
							ValaSourceReference* _tmp666_;
							_tmp665_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp666_ = _tmp665_;
							vala_report_error (_tmp666_, "`resize' is not allowed for unowned array references");
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						}
					}
					_vala_code_node_unref0 (inner_type);
				} else {
					ValaExpression* _tmp667_;
					ValaExpression* _tmp668_;
					ValaSymbol* _tmp669_;
					ValaSymbol* _tmp670_;
					_tmp667_ = vala_member_access_get_inner (self);
					_tmp668_ = _tmp667_;
					_tmp669_ = vala_expression_get_symbol_reference (_tmp668_);
					_tmp670_ = _tmp669_;
					if (VALA_IS_CONSTANT (_tmp670_)) {
						ValaSourceReference* _tmp671_;
						ValaSourceReference* _tmp672_;
						_tmp671_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp672_ = _tmp671_;
						vala_report_error (_tmp672_, "`resize' is not allowed for constant arrays");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
			}
		}
	}
	_tmp676_ = vala_member_access_get_inner (self);
	_tmp677_ = _tmp676_;
	if (_tmp677_ == NULL) {
		ValaSymbol* _tmp678_;
		ValaSymbol* _tmp679_;
		_tmp678_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp679_ = _tmp678_;
		_tmp675_ = _tmp679_ == NULL;
	} else {
		_tmp675_ = FALSE;
	}
	if (_tmp675_) {
		ValaDataType* _tmp680_;
		ValaDataType* _tmp681_;
		_tmp680_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp681_ = _tmp680_;
		_tmp674_ = _tmp681_ != NULL;
	} else {
		_tmp674_ = FALSE;
	}
	if (_tmp674_) {
		ValaDataType* _tmp682_;
		ValaDataType* _tmp683_;
		ValaTypeSymbol* _tmp684_;
		ValaTypeSymbol* _tmp685_;
		_tmp682_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp683_ = _tmp682_;
		_tmp684_ = vala_data_type_get_type_symbol (_tmp683_);
		_tmp685_ = _tmp684_;
		_tmp673_ = VALA_IS_ENUM (_tmp685_);
	} else {
		_tmp673_ = FALSE;
	}
	if (_tmp673_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp686_;
		ValaDataType* _tmp687_;
		ValaTypeSymbol* _tmp688_;
		ValaTypeSymbol* _tmp689_;
		_tmp686_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp687_ = _tmp686_;
		_tmp688_ = vala_data_type_get_type_symbol (_tmp687_);
		_tmp689_ = _tmp688_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp689_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp690_;
			ValaList* _tmp691_;
			ValaList* _tmp692_;
			gint _val_size = 0;
			ValaList* _tmp693_;
			gint _tmp694_;
			gint _tmp695_;
			gint _val_index = 0;
			_tmp690_ = enum_type;
			_tmp691_ = vala_enum_get_values (_tmp690_);
			_tmp692_ = _vala_iterable_ref0 (_tmp691_);
			_val_list = _tmp692_;
			_tmp693_ = _val_list;
			_tmp694_ = vala_collection_get_size ((ValaCollection*) _tmp693_);
			_tmp695_ = _tmp694_;
			_val_size = _tmp695_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp696_;
				gint _tmp697_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp698_;
				gpointer _tmp699_;
				const gchar* _tmp700_;
				ValaEnumValue* _tmp701_;
				const gchar* _tmp702_;
				const gchar* _tmp703_;
				_val_index = _val_index + 1;
				_tmp696_ = _val_index;
				_tmp697_ = _val_size;
				if (!(_tmp696_ < _tmp697_)) {
					break;
				}
				_tmp698_ = _val_list;
				_tmp699_ = vala_list_get (_tmp698_, _val_index);
				val = (ValaEnumValue*) _tmp699_;
				_tmp700_ = self->priv->_member_name;
				_tmp701_ = val;
				_tmp702_ = vala_symbol_get_name ((ValaSymbol*) _tmp701_);
				_tmp703_ = _tmp702_;
				if (g_strcmp0 (_tmp700_, _tmp703_) == 0) {
					ValaEnumValue* _tmp704_;
					_tmp704_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp704_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
	}
	_tmp705_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp706_ = _tmp705_;
	if (_tmp706_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp707_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp708_ = FALSE;
		ValaExpression* _tmp709_;
		ValaExpression* _tmp710_;
		gchar* base_type_package = NULL;
		gchar* _tmp730_;
		gboolean _tmp731_ = FALSE;
		ValaSymbol* _tmp732_;
		ValaSourceReference* _tmp747_;
		ValaSourceReference* _tmp748_;
		const gchar* _tmp749_;
		const gchar* _tmp750_;
		const gchar* _tmp751_;
		gchar* _tmp752_;
		gchar* _tmp753_;
		ValaInvalidType* _tmp754_;
		ValaInvalidType* _tmp755_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp707_ = g_strdup ("(null)");
		base_type_name = _tmp707_;
		base_type = NULL;
		_tmp709_ = vala_member_access_get_inner (self);
		_tmp710_ = _tmp709_;
		if (_tmp710_ != NULL) {
			ValaExpression* _tmp711_;
			ValaExpression* _tmp712_;
			ValaDataType* _tmp713_;
			ValaDataType* _tmp714_;
			_tmp711_ = vala_member_access_get_inner (self);
			_tmp712_ = _tmp711_;
			_tmp713_ = vala_expression_get_value_type (_tmp712_);
			_tmp714_ = _tmp713_;
			_tmp708_ = _tmp714_ != NULL;
		} else {
			_tmp708_ = FALSE;
		}
		if (_tmp708_) {
			ValaExpression* _tmp715_;
			ValaExpression* _tmp716_;
			ValaDataType* _tmp717_;
			ValaDataType* _tmp718_;
			gchar* _tmp719_;
			ValaExpression* _tmp720_;
			ValaExpression* _tmp721_;
			ValaDataType* _tmp722_;
			ValaDataType* _tmp723_;
			ValaTypeSymbol* _tmp724_;
			ValaTypeSymbol* _tmp725_;
			_tmp715_ = vala_member_access_get_inner (self);
			_tmp716_ = _tmp715_;
			_tmp717_ = vala_expression_get_value_type (_tmp716_);
			_tmp718_ = _tmp717_;
			_tmp719_ = vala_code_node_to_string ((ValaCodeNode*) _tmp718_);
			_g_free0 (base_type_name);
			base_type_name = _tmp719_;
			_tmp720_ = vala_member_access_get_inner (self);
			_tmp721_ = _tmp720_;
			_tmp722_ = vala_expression_get_value_type (_tmp721_);
			_tmp723_ = _tmp722_;
			_tmp724_ = vala_data_type_get_type_symbol (_tmp723_);
			_tmp725_ = _tmp724_;
			base_type = (ValaSymbol*) _tmp725_;
		} else {
			ValaSymbol* _tmp726_;
			_tmp726_ = base_symbol;
			if (_tmp726_ != NULL) {
				ValaSymbol* _tmp727_;
				gchar* _tmp728_;
				ValaSymbol* _tmp729_;
				_tmp727_ = base_symbol;
				_tmp728_ = vala_symbol_get_full_name (_tmp727_);
				_g_free0 (base_type_name);
				base_type_name = _tmp728_;
				_tmp729_ = base_symbol;
				base_type = _tmp729_;
			}
		}
		_tmp730_ = g_strdup ("");
		base_type_package = _tmp730_;
		_tmp732_ = base_type;
		if (_tmp732_ != NULL) {
			ValaSymbol* _tmp733_;
			gboolean _tmp734_;
			gboolean _tmp735_;
			_tmp733_ = base_type;
			_tmp734_ = vala_symbol_get_external_package (_tmp733_);
			_tmp735_ = _tmp734_;
			_tmp731_ = _tmp735_;
		} else {
			_tmp731_ = FALSE;
		}
		if (_tmp731_) {
			ValaSymbol* _tmp736_;
			ValaSourceReference* _tmp737_;
			ValaSourceReference* _tmp738_;
			ValaSourceFile* _tmp739_;
			ValaSourceFile* _tmp740_;
			const gchar* _tmp741_;
			const gchar* _tmp742_;
			gchar* _tmp743_;
			const gchar* _tmp744_;
			_tmp736_ = base_symbol;
			_tmp737_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp736_);
			_tmp738_ = _tmp737_;
			_tmp739_ = vala_source_reference_get_file (_tmp738_);
			_tmp740_ = _tmp739_;
			_tmp741_ = vala_source_file_get_package_name (_tmp740_);
			_tmp742_ = _tmp741_;
			_tmp743_ = g_strdup (_tmp742_);
			_g_free0 (base_type_package);
			base_type_package = _tmp743_;
			_tmp744_ = base_type_package;
			if (_tmp744_ != NULL) {
				const gchar* _tmp745_;
				gchar* _tmp746_;
				_tmp745_ = base_type_package;
				_tmp746_ = g_strdup_printf (" (%s)", _tmp745_);
				_g_free0 (base_type_package);
				base_type_package = _tmp746_;
			}
		}
		_tmp747_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp748_ = _tmp747_;
		_tmp749_ = self->priv->_member_name;
		_tmp750_ = base_type_name;
		_tmp751_ = base_type_package;
		_tmp752_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'%s", _tmp749_, _tmp750_, _tmp751_);
		_tmp753_ = _tmp752_;
		vala_report_error (_tmp748_, _tmp753_);
		_g_free0 (_tmp753_);
		_tmp754_ = vala_invalid_type_new ();
		_tmp755_ = _tmp754_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp755_);
		_vala_code_node_unref0 (_tmp755_);
		result = FALSE;
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		return result;
	} else {
		ValaSymbol* _tmp756_;
		ValaSymbol* _tmp757_;
		gboolean _tmp758_;
		gboolean _tmp759_;
		_tmp756_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp757_ = _tmp756_;
		_tmp758_ = vala_code_node_get_error ((ValaCodeNode*) _tmp757_);
		_tmp759_ = _tmp758_;
		if (_tmp759_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp760_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp761_ = _tmp760_;
	if (VALA_IS_SIGNAL (_tmp761_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp762_;
		ValaSymbol* _tmp763_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp770_;
		ValaCodeNode* _tmp771_;
		ValaCodeNode* _tmp772_;
		gboolean _tmp773_ = FALSE;
		gboolean _tmp774_ = FALSE;
		gboolean _tmp775_ = FALSE;
		ValaCodeNode* _tmp776_;
		_tmp762_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp763_ = _tmp762_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp763_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp764_;
			ValaCodeNode* _tmp765_;
			ValaCodeNode* _tmp766_;
			ValaCodeNode* _tmp767_;
			ValaCodeNode* _tmp768_;
			ValaCodeNode* _tmp769_;
			_tmp764_ = ma;
			_tmp765_ = vala_code_node_get_parent_node (_tmp764_);
			_tmp766_ = _tmp765_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp766_)) {
				break;
			}
			_tmp767_ = ma;
			_tmp768_ = vala_code_node_get_parent_node (_tmp767_);
			_tmp769_ = _tmp768_;
			ma = _tmp769_;
		}
		_tmp770_ = ma;
		_tmp771_ = vala_code_node_get_parent_node (_tmp770_);
		_tmp772_ = _tmp771_;
		parent = _tmp772_;
		_tmp776_ = parent;
		if (_tmp776_ != NULL) {
			ValaCodeNode* _tmp777_;
			_tmp777_ = parent;
			_tmp775_ = !VALA_IS_ELEMENT_ACCESS (_tmp777_);
		} else {
			_tmp775_ = FALSE;
		}
		if (_tmp775_) {
			ValaCodeNode* _tmp778_;
			ValaExpression* _tmp779_;
			ValaExpression* _tmp780_;
			_tmp778_ = ma;
			_tmp779_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp778_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp780_ = _tmp779_;
			_tmp774_ = !VALA_IS_BASE_ACCESS (_tmp780_);
		} else {
			_tmp774_ = FALSE;
		}
		if (_tmp774_) {
			gboolean _tmp781_ = FALSE;
			ValaCodeNode* _tmp782_;
			_tmp782_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp782_)) {
				_tmp781_ = TRUE;
			} else {
				ValaCodeNode* _tmp783_;
				ValaList* _tmp784_;
				_tmp783_ = parent;
				_tmp784_ = vala_method_call_get_argument_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp783_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp781_ = vala_collection_contains ((ValaCollection*) _tmp784_, (ValaExpression*) self);
			}
			_tmp773_ = _tmp781_;
		} else {
			_tmp773_ = FALSE;
		}
		if (_tmp773_) {
			ValaSignal* _tmp785_;
			ValaAttribute* _tmp786_;
			_tmp785_ = sig;
			_tmp786_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp785_, "HasEmitter");
			if (_tmp786_ != NULL) {
				ValaSignal* _tmp787_;
				ValaSignal* _tmp788_;
				ValaMethod* _tmp789_;
				ValaMethod* _tmp790_;
				_tmp787_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp787_, context)) {
					result = FALSE;
					return result;
				}
				_tmp788_ = sig;
				_tmp789_ = vala_signal_get_emitter (_tmp788_);
				_tmp790_ = _tmp789_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp790_);
			} else {
				ValaSourceReference* _tmp791_;
				ValaSourceReference* _tmp792_;
				ValaSymbol* _tmp793_;
				ValaSymbol* _tmp794_;
				gchar* _tmp795_;
				gchar* _tmp796_;
				gchar* _tmp797_;
				gchar* _tmp798_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp791_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp792_ = _tmp791_;
				_tmp793_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp794_ = _tmp793_;
				_tmp795_ = vala_symbol_get_full_name (_tmp794_);
				_tmp796_ = _tmp795_;
				_tmp797_ = g_strdup_printf ("Signal `%s' requires emitter in this context", _tmp796_);
				_tmp798_ = _tmp797_;
				vala_report_error (_tmp792_, _tmp798_);
				_g_free0 (_tmp798_);
				_g_free0 (_tmp796_);
				result = FALSE;
				return result;
			}
		}
	}
	_tmp799_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp800_ = _tmp799_;
	member = _tmp800_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp801_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp801_, context)) {
		result = FALSE;
		return result;
	}
	_tmp802_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp802_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp803_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp804_;
		ValaSymbol* _tmp805_;
		ValaSymbol* _tmp806_;
		gboolean _tmp807_ = FALSE;
		ValaBlock* _tmp808_;
		_tmp803_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp803_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp804_ = local;
		_tmp805_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp804_);
		_tmp806_ = _tmp805_;
		block = VALA_IS_BLOCK (_tmp806_) ? ((ValaBlock*) _tmp806_) : NULL;
		_tmp808_ = block;
		if (_tmp808_ != NULL) {
			ValaBlock* _tmp809_;
			ValaSymbol* _tmp810_;
			ValaSemanticAnalyzer* _tmp811_;
			ValaSemanticAnalyzer* _tmp812_;
			ValaSymbol* _tmp813_;
			ValaSymbol* _tmp814_;
			_tmp809_ = block;
			_tmp810_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp809_);
			_tmp811_ = vala_code_context_get_analyzer (context);
			_tmp812_ = _tmp811_;
			_tmp813_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp812_);
			_tmp814_ = _tmp813_;
			_tmp807_ = _tmp810_ != _tmp814_;
		} else {
			_tmp807_ = FALSE;
		}
		if (_tmp807_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp815_;
			ValaSemanticAnalyzer* _tmp816_;
			ValaSymbol* _tmp817_;
			ValaSymbol* _tmp818_;
			ValaLocalVariable* _tmp829_;
			ValaBlock* _tmp830_;
			ValaLocalVariable* _tmp831_;
			ValaDataType* _tmp832_;
			ValaDataType* _tmp833_;
			ValaTypeSymbol* _tmp834_;
			ValaTypeSymbol* _tmp835_;
			ValaSemanticAnalyzer* _tmp836_;
			ValaSemanticAnalyzer* _tmp837_;
			ValaDataType* _tmp838_;
			ValaTypeSymbol* _tmp839_;
			ValaTypeSymbol* _tmp840_;
			_tmp815_ = vala_code_context_get_analyzer (context);
			_tmp816_ = _tmp815_;
			_tmp817_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp816_);
			_tmp818_ = _tmp817_;
			sym = _tmp818_;
			while (TRUE) {
				ValaSymbol* _tmp819_;
				ValaBlock* _tmp820_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp821_;
				ValaMethod* _tmp822_;
				ValaSymbol* _tmp826_;
				ValaSymbol* _tmp827_;
				ValaSymbol* _tmp828_;
				_tmp819_ = sym;
				_tmp820_ = block;
				if (!(_tmp819_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp820_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp821_ = sym;
				method = VALA_IS_METHOD (_tmp821_) ? ((ValaMethod*) _tmp821_) : NULL;
				_tmp822_ = method;
				if (_tmp822_ != NULL) {
					ValaMethod* _tmp823_;
					ValaMethod* _tmp824_;
					ValaLocalVariable* _tmp825_;
					_tmp823_ = method;
					vala_method_set_closure (_tmp823_, TRUE);
					_tmp824_ = method;
					_tmp825_ = local;
					vala_method_add_captured_variable (_tmp824_, _tmp825_);
				}
				_tmp826_ = sym;
				_tmp827_ = vala_symbol_get_parent_symbol (_tmp826_);
				_tmp828_ = _tmp827_;
				sym = _tmp828_;
			}
			_tmp829_ = local;
			vala_local_variable_set_captured (_tmp829_, TRUE);
			_tmp830_ = block;
			vala_block_set_captured (_tmp830_, TRUE);
			_tmp831_ = local;
			_tmp832_ = vala_variable_get_variable_type ((ValaVariable*) _tmp831_);
			_tmp833_ = _tmp832_;
			_tmp834_ = vala_data_type_get_type_symbol (_tmp833_);
			_tmp835_ = _tmp834_;
			_tmp836_ = vala_code_context_get_analyzer (context);
			_tmp837_ = _tmp836_;
			_tmp838_ = _tmp837_->va_list_type;
			_tmp839_ = vala_data_type_get_type_symbol (_tmp838_);
			_tmp840_ = _tmp839_;
			if (_tmp835_ == _tmp840_) {
				ValaSourceReference* _tmp841_;
				ValaSourceReference* _tmp842_;
				ValaLocalVariable* _tmp843_;
				gchar* _tmp844_;
				gchar* _tmp845_;
				gchar* _tmp846_;
				gchar* _tmp847_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp841_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp842_ = _tmp841_;
				_tmp843_ = local;
				_tmp844_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp843_);
				_tmp845_ = _tmp844_;
				_tmp846_ = g_strdup_printf ("Capturing `va_list' variable `%s' is not allowed", _tmp845_);
				_tmp847_ = _tmp846_;
				vala_report_error (_tmp842_, _tmp847_);
				_g_free0 (_tmp847_);
				_g_free0 (_tmp845_);
			}
		}
	} else {
		ValaSymbol* _tmp848_;
		_tmp848_ = member;
		if (VALA_IS_PARAMETER (_tmp848_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp849_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp850_;
			ValaSymbol* _tmp851_;
			ValaSymbol* _tmp852_;
			gboolean _tmp853_ = FALSE;
			gboolean _tmp854_ = FALSE;
			ValaMethod* _tmp855_;
			_tmp849_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp849_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp850_ = param;
			_tmp851_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp850_);
			_tmp852_ = _tmp851_;
			m = VALA_IS_METHOD (_tmp852_) ? ((ValaMethod*) _tmp852_) : NULL;
			_tmp855_ = m;
			if (_tmp855_ != NULL) {
				ValaMethod* _tmp856_;
				ValaSemanticAnalyzer* _tmp857_;
				ValaSemanticAnalyzer* _tmp858_;
				ValaSymbol* _tmp859_;
				ValaSymbol* _tmp860_;
				_tmp856_ = m;
				_tmp857_ = vala_code_context_get_analyzer (context);
				_tmp858_ = _tmp857_;
				_tmp859_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp858_);
				_tmp860_ = _tmp859_;
				_tmp854_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp856_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp860_;
			} else {
				_tmp854_ = FALSE;
			}
			if (_tmp854_) {
				ValaParameter* _tmp861_;
				ValaMethod* _tmp862_;
				ValaParameter* _tmp863_;
				ValaParameter* _tmp864_;
				_tmp861_ = param;
				_tmp862_ = m;
				_tmp863_ = vala_method_get_this_parameter (_tmp862_);
				_tmp864_ = _tmp863_;
				_tmp853_ = _tmp861_ != _tmp864_;
			} else {
				_tmp853_ = FALSE;
			}
			if (_tmp853_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp865_;
				ValaSemanticAnalyzer* _tmp866_;
				ValaSymbol* _tmp867_;
				ValaSymbol* _tmp868_;
				ValaParameter* _tmp877_;
				ValaMethod* _tmp878_;
				ValaBlock* _tmp879_;
				ValaBlock* _tmp880_;
				ValaParameter* _tmp881_;
				ValaParameterDirection _tmp882_;
				ValaParameterDirection _tmp883_;
				ValaParameter* _tmp891_;
				ValaDataType* _tmp892_;
				ValaDataType* _tmp893_;
				ValaTypeSymbol* _tmp894_;
				ValaTypeSymbol* _tmp895_;
				ValaSemanticAnalyzer* _tmp896_;
				ValaSemanticAnalyzer* _tmp897_;
				ValaDataType* _tmp898_;
				ValaTypeSymbol* _tmp899_;
				ValaTypeSymbol* _tmp900_;
				_tmp865_ = vala_code_context_get_analyzer (context);
				_tmp866_ = _tmp865_;
				_tmp867_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp866_);
				_tmp868_ = _tmp867_;
				sym = _tmp868_;
				while (TRUE) {
					ValaSymbol* _tmp869_;
					ValaMethod* _tmp870_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp871_;
					ValaMethod* _tmp872_;
					ValaSymbol* _tmp874_;
					ValaSymbol* _tmp875_;
					ValaSymbol* _tmp876_;
					_tmp869_ = sym;
					_tmp870_ = m;
					if (!(_tmp869_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp870_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp871_ = sym;
					method = VALA_IS_METHOD (_tmp871_) ? ((ValaMethod*) _tmp871_) : NULL;
					_tmp872_ = method;
					if (_tmp872_ != NULL) {
						ValaMethod* _tmp873_;
						_tmp873_ = method;
						vala_method_set_closure (_tmp873_, TRUE);
					}
					_tmp874_ = sym;
					_tmp875_ = vala_symbol_get_parent_symbol (_tmp874_);
					_tmp876_ = _tmp875_;
					sym = _tmp876_;
				}
				_tmp877_ = param;
				vala_parameter_set_captured (_tmp877_, TRUE);
				_tmp878_ = m;
				_tmp879_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp878_);
				_tmp880_ = _tmp879_;
				vala_block_set_captured (_tmp880_, TRUE);
				_tmp881_ = param;
				_tmp882_ = vala_parameter_get_direction (_tmp881_);
				_tmp883_ = _tmp882_;
				if (_tmp883_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp884_;
					ValaSourceReference* _tmp885_;
					ValaParameter* _tmp886_;
					gchar* _tmp887_;
					gchar* _tmp888_;
					gchar* _tmp889_;
					gchar* _tmp890_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp884_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp885_ = _tmp884_;
					_tmp886_ = param;
					_tmp887_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp886_);
					_tmp888_ = _tmp887_;
					_tmp889_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp888_);
					_tmp890_ = _tmp889_;
					vala_report_error (_tmp885_, _tmp890_);
					_g_free0 (_tmp890_);
					_g_free0 (_tmp888_);
				}
				_tmp891_ = param;
				_tmp892_ = vala_variable_get_variable_type ((ValaVariable*) _tmp891_);
				_tmp893_ = _tmp892_;
				_tmp894_ = vala_data_type_get_type_symbol (_tmp893_);
				_tmp895_ = _tmp894_;
				_tmp896_ = vala_code_context_get_analyzer (context);
				_tmp897_ = _tmp896_;
				_tmp898_ = _tmp897_->va_list_type;
				_tmp899_ = vala_data_type_get_type_symbol (_tmp898_);
				_tmp900_ = _tmp899_;
				if (_tmp895_ == _tmp900_) {
					ValaSourceReference* _tmp901_;
					ValaSourceReference* _tmp902_;
					ValaParameter* _tmp903_;
					gchar* _tmp904_;
					gchar* _tmp905_;
					gchar* _tmp906_;
					gchar* _tmp907_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp901_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp902_ = _tmp901_;
					_tmp903_ = param;
					_tmp904_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp903_);
					_tmp905_ = _tmp904_;
					_tmp906_ = g_strdup_printf ("Capturing `va_list' parameter `%s' is not allowed", _tmp905_);
					_tmp907_ = _tmp906_;
					vala_report_error (_tmp902_, _tmp907_);
					_g_free0 (_tmp907_);
					_g_free0 (_tmp905_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp908_;
				ValaSymbol* _tmp909_;
				ValaSymbol* _tmp910_;
				ValaSymbol* _tmp911_;
				ValaSymbol* _tmp912_;
				gboolean _tmp913_ = FALSE;
				gboolean _tmp914_ = FALSE;
				ValaPropertyAccessor* _tmp915_;
				_tmp908_ = param;
				_tmp909_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp908_);
				_tmp910_ = _tmp909_;
				_tmp911_ = vala_symbol_get_parent_symbol (_tmp910_);
				_tmp912_ = _tmp911_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp912_) ? ((ValaPropertyAccessor*) _tmp912_) : NULL;
				_tmp915_ = acc;
				if (_tmp915_ != NULL) {
					ValaPropertyAccessor* _tmp916_;
					ValaSemanticAnalyzer* _tmp917_;
					ValaSemanticAnalyzer* _tmp918_;
					ValaSymbol* _tmp919_;
					ValaSymbol* _tmp920_;
					_tmp916_ = acc;
					_tmp917_ = vala_code_context_get_analyzer (context);
					_tmp918_ = _tmp917_;
					_tmp919_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp918_);
					_tmp920_ = _tmp919_;
					_tmp914_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp916_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp920_;
				} else {
					_tmp914_ = FALSE;
				}
				if (_tmp914_) {
					ValaParameter* _tmp921_;
					ValaPropertyAccessor* _tmp922_;
					ValaProperty* _tmp923_;
					ValaProperty* _tmp924_;
					ValaParameter* _tmp925_;
					ValaParameter* _tmp926_;
					_tmp921_ = param;
					_tmp922_ = acc;
					_tmp923_ = vala_property_accessor_get_prop (_tmp922_);
					_tmp924_ = _tmp923_;
					_tmp925_ = vala_property_get_this_parameter (_tmp924_);
					_tmp926_ = _tmp925_;
					_tmp913_ = _tmp921_ != _tmp926_;
				} else {
					_tmp913_ = FALSE;
				}
				if (_tmp913_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp927_;
					ValaSemanticAnalyzer* _tmp928_;
					ValaSymbol* _tmp929_;
					ValaSymbol* _tmp930_;
					ValaParameter* _tmp939_;
					ValaPropertyAccessor* _tmp940_;
					ValaBlock* _tmp941_;
					ValaBlock* _tmp942_;
					_tmp927_ = vala_code_context_get_analyzer (context);
					_tmp928_ = _tmp927_;
					_tmp929_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp928_);
					_tmp930_ = _tmp929_;
					sym = _tmp930_;
					while (TRUE) {
						ValaSymbol* _tmp931_;
						ValaMethod* _tmp932_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp933_;
						ValaMethod* _tmp934_;
						ValaSymbol* _tmp936_;
						ValaSymbol* _tmp937_;
						ValaSymbol* _tmp938_;
						_tmp931_ = sym;
						_tmp932_ = m;
						if (!(_tmp931_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp932_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp933_ = sym;
						method = VALA_IS_METHOD (_tmp933_) ? ((ValaMethod*) _tmp933_) : NULL;
						_tmp934_ = method;
						if (_tmp934_ != NULL) {
							ValaMethod* _tmp935_;
							_tmp935_ = method;
							vala_method_set_closure (_tmp935_, TRUE);
						}
						_tmp936_ = sym;
						_tmp937_ = vala_symbol_get_parent_symbol (_tmp936_);
						_tmp938_ = _tmp937_;
						sym = _tmp938_;
					}
					_tmp939_ = param;
					vala_parameter_set_captured (_tmp939_, TRUE);
					_tmp940_ = acc;
					_tmp941_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp940_);
					_tmp942_ = _tmp941_;
					vala_block_set_captured (_tmp942_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp943_;
			_tmp943_ = member;
			if (VALA_IS_FIELD (_tmp943_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp944_;
				ValaField* _tmp945_;
				ValaSymbolAccessibility _tmp946_;
				ValaSymbolAccessibility _tmp947_;
				ValaField* _tmp948_;
				ValaMemberBinding _tmp949_;
				ValaMemberBinding _tmp950_;
				ValaField* _tmp951_;
				ValaMemberBinding _tmp952_;
				ValaMemberBinding _tmp953_;
				ValaField* _tmp954_;
				ValaDataType* _tmp955_;
				ValaDataType* _tmp956_;
				_tmp944_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp944_, VALA_TYPE_FIELD, ValaField);
				_tmp945_ = f;
				_tmp946_ = vala_symbol_get_access ((ValaSymbol*) _tmp945_);
				_tmp947_ = _tmp946_;
				access = _tmp947_;
				_tmp948_ = f;
				_tmp949_ = vala_field_get_binding (_tmp948_);
				_tmp950_ = _tmp949_;
				instance = _tmp950_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp951_ = f;
				_tmp952_ = vala_field_get_binding (_tmp951_);
				_tmp953_ = _tmp952_;
				klass = _tmp953_ == VALA_MEMBER_BINDING_CLASS;
				_tmp954_ = f;
				_tmp955_ = vala_variable_get_variable_type ((ValaVariable*) _tmp954_);
				_tmp956_ = _tmp955_;
				if (VALA_IS_GENERIC_TYPE (_tmp956_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp957_;
				_tmp957_ = member;
				if (VALA_IS_CONSTANT (_tmp957_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp958_;
					ValaConstant* _tmp959_;
					ValaSymbolAccessibility _tmp960_;
					ValaSymbolAccessibility _tmp961_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp962_;
					ValaSymbol* _tmp963_;
					ValaSymbol* _tmp964_;
					gboolean _tmp965_ = FALSE;
					ValaBlock* _tmp966_;
					_tmp958_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp958_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp959_ = c;
					_tmp960_ = vala_symbol_get_access ((ValaSymbol*) _tmp959_);
					_tmp961_ = _tmp960_;
					access = _tmp961_;
					_tmp962_ = c;
					_tmp963_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp962_);
					_tmp964_ = _tmp963_;
					block = VALA_IS_BLOCK (_tmp964_) ? ((ValaBlock*) _tmp964_) : NULL;
					_tmp966_ = block;
					if (_tmp966_ != NULL) {
						ValaBlock* _tmp967_;
						ValaSymbol* _tmp968_;
						ValaSemanticAnalyzer* _tmp969_;
						ValaSemanticAnalyzer* _tmp970_;
						ValaSymbol* _tmp971_;
						ValaSymbol* _tmp972_;
						_tmp967_ = block;
						_tmp968_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp967_);
						_tmp969_ = vala_code_context_get_analyzer (context);
						_tmp970_ = _tmp969_;
						_tmp971_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp970_);
						_tmp972_ = _tmp971_;
						_tmp965_ = _tmp968_ != _tmp972_;
					} else {
						_tmp965_ = FALSE;
					}
					if (_tmp965_) {
						ValaSourceReference* _tmp973_;
						ValaSourceReference* _tmp974_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp973_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp974_ = _tmp973_;
						vala_report_error (_tmp974_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						return result;
					}
				} else {
					ValaSymbol* _tmp975_;
					_tmp975_ = member;
					if (VALA_IS_METHOD (_tmp975_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp976_;
						ValaMethod* _tmp977_;
						gboolean _tmp978_;
						gboolean _tmp979_;
						ValaMethod* _tmp1068_;
						ValaSymbolAccessibility _tmp1069_;
						ValaSymbolAccessibility _tmp1070_;
						ValaMethod* _tmp1071_;
						ValaMethod* _tmp1075_;
						ValaMemberBinding _tmp1076_;
						ValaMemberBinding _tmp1077_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1098_;
						ValaDataType* _tmp1099_;
						ValaDataType* _tmp1100_;
						gboolean _tmp1101_ = FALSE;
						ValaGenericType* _tmp1102_;
						_tmp976_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp976_, VALA_TYPE_METHOD, ValaMethod);
						_tmp977_ = m;
						_tmp978_ = vala_method_get_is_async_callback (_tmp977_);
						_tmp979_ = _tmp978_;
						if (_tmp979_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp980_;
							ValaSemanticAnalyzer* _tmp981_;
							ValaMethod* _tmp982_;
							ValaMethod* _tmp983_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp984_;
							ValaMethod* _tmp1013_;
							ValaSemanticAnalyzer* _tmp1014_;
							ValaSemanticAnalyzer* _tmp1015_;
							ValaMethod* _tmp1016_;
							ValaMethod* _tmp1017_;
							ValaMethod* _tmp1033_;
							ValaMethod* _tmp1034_;
							ValaMethod* _tmp1035_;
							ValaSymbol* _tmp1036_;
							ValaSymbol* _tmp1037_;
							_tmp980_ = vala_code_context_get_analyzer (context);
							_tmp981_ = _tmp980_;
							_tmp982_ = vala_semantic_analyzer_get_current_async_method (_tmp981_);
							_tmp983_ = _tmp982_;
							async_method = _tmp983_;
							is_valid_access = FALSE;
							_tmp984_ = async_method;
							if (_tmp984_ != NULL) {
								ValaMethod* _tmp985_;
								ValaMethod* _tmp986_;
								ValaMethod* _tmp987_;
								_tmp985_ = m;
								_tmp986_ = async_method;
								_tmp987_ = vala_method_get_callback_method (_tmp986_);
								if (_tmp985_ == _tmp987_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp988_ = FALSE;
									ValaMethod* _tmp989_;
									ValaMethod* _tmp990_;
									ValaMethod* _tmp991_;
									_tmp989_ = async_method;
									_tmp990_ = vala_method_get_base_method (_tmp989_);
									_tmp991_ = _tmp990_;
									if (_tmp991_ != NULL) {
										ValaMethod* _tmp992_;
										ValaMethod* _tmp993_;
										ValaMethod* _tmp994_;
										ValaMethod* _tmp995_;
										ValaMethod* _tmp996_;
										_tmp992_ = m;
										_tmp993_ = async_method;
										_tmp994_ = vala_method_get_base_method (_tmp993_);
										_tmp995_ = _tmp994_;
										_tmp996_ = vala_method_get_callback_method (_tmp995_);
										_tmp988_ = _tmp992_ == _tmp996_;
									} else {
										_tmp988_ = FALSE;
									}
									if (_tmp988_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp997_ = FALSE;
										ValaMethod* _tmp998_;
										ValaMethod* _tmp999_;
										ValaMethod* _tmp1000_;
										_tmp998_ = async_method;
										_tmp999_ = vala_method_get_base_interface_method (_tmp998_);
										_tmp1000_ = _tmp999_;
										if (_tmp1000_ != NULL) {
											ValaMethod* _tmp1001_;
											ValaMethod* _tmp1002_;
											ValaMethod* _tmp1003_;
											ValaMethod* _tmp1004_;
											ValaMethod* _tmp1005_;
											_tmp1001_ = m;
											_tmp1002_ = async_method;
											_tmp1003_ = vala_method_get_base_interface_method (_tmp1002_);
											_tmp1004_ = _tmp1003_;
											_tmp1005_ = vala_method_get_callback_method (_tmp1004_);
											_tmp997_ = _tmp1001_ == _tmp1005_;
										} else {
											_tmp997_ = FALSE;
										}
										if (_tmp997_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp1006_;
								ValaSourceReference* _tmp1007_;
								ValaMethod* _tmp1008_;
								gchar* _tmp1009_;
								gchar* _tmp1010_;
								gchar* _tmp1011_;
								gchar* _tmp1012_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp1006_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp1007_ = _tmp1006_;
								_tmp1008_ = m;
								_tmp1009_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1008_);
								_tmp1010_ = _tmp1009_;
								_tmp1011_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp1010_);
								_tmp1012_ = _tmp1011_;
								vala_report_error (_tmp1007_, _tmp1012_);
								_g_free0 (_tmp1012_);
								_g_free0 (_tmp1010_);
								result = FALSE;
								return result;
							}
							_tmp1013_ = async_method;
							_tmp1014_ = vala_code_context_get_analyzer (context);
							_tmp1015_ = _tmp1014_;
							_tmp1016_ = vala_semantic_analyzer_get_current_method (_tmp1015_);
							_tmp1017_ = _tmp1016_;
							if (_tmp1013_ != _tmp1017_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp1018_;
								ValaSemanticAnalyzer* _tmp1019_;
								ValaMethod* _tmp1020_;
								ValaMethod* _tmp1021_;
								ValaMethod* _tmp1030_;
								ValaBlock* _tmp1031_;
								ValaBlock* _tmp1032_;
								_tmp1018_ = vala_code_context_get_analyzer (context);
								_tmp1019_ = _tmp1018_;
								_tmp1020_ = vala_semantic_analyzer_get_current_method (_tmp1019_);
								_tmp1021_ = _tmp1020_;
								sym = (ValaSymbol*) _tmp1021_;
								while (TRUE) {
									ValaSymbol* _tmp1022_;
									ValaMethod* _tmp1023_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp1024_;
									ValaMethod* _tmp1025_;
									ValaSymbol* _tmp1027_;
									ValaSymbol* _tmp1028_;
									ValaSymbol* _tmp1029_;
									_tmp1022_ = sym;
									_tmp1023_ = async_method;
									if (!(_tmp1022_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1023_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp1024_ = sym;
									method = VALA_IS_METHOD (_tmp1024_) ? ((ValaMethod*) _tmp1024_) : NULL;
									_tmp1025_ = method;
									if (_tmp1025_ != NULL) {
										ValaMethod* _tmp1026_;
										_tmp1026_ = method;
										vala_method_set_closure (_tmp1026_, TRUE);
									}
									_tmp1027_ = sym;
									_tmp1028_ = vala_symbol_get_parent_symbol (_tmp1027_);
									_tmp1029_ = _tmp1028_;
									sym = _tmp1029_;
								}
								_tmp1030_ = async_method;
								_tmp1031_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1030_);
								_tmp1032_ = _tmp1031_;
								vala_block_set_captured (_tmp1032_, TRUE);
							}
							_tmp1033_ = async_method;
							_tmp1034_ = vala_method_get_callback_method (_tmp1033_);
							m = _tmp1034_;
							_tmp1035_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1035_);
							_tmp1036_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1037_ = _tmp1036_;
							member = _tmp1037_;
						} else {
							ValaMethod* _tmp1038_;
							ValaMethod* _tmp1039_;
							ValaMethod* _tmp1040_;
							_tmp1038_ = m;
							_tmp1039_ = vala_method_get_base_method (_tmp1038_);
							_tmp1040_ = _tmp1039_;
							if (_tmp1040_ != NULL) {
								ValaMethod* _tmp1041_;
								ValaMethod* _tmp1042_;
								ValaMethod* _tmp1043_;
								ValaMethod* _tmp1044_;
								ValaSignal* _tmp1045_;
								ValaSignal* _tmp1046_;
								ValaSymbol* _tmp1051_;
								ValaSymbol* _tmp1052_;
								_tmp1041_ = m;
								_tmp1042_ = vala_method_get_base_method (_tmp1041_);
								_tmp1043_ = _tmp1042_;
								m = _tmp1043_;
								_tmp1044_ = m;
								_tmp1045_ = vala_method_get_signal_reference (_tmp1044_);
								_tmp1046_ = _tmp1045_;
								if (_tmp1046_ != NULL) {
									ValaMethod* _tmp1047_;
									ValaSignal* _tmp1048_;
									ValaSignal* _tmp1049_;
									_tmp1047_ = m;
									_tmp1048_ = vala_method_get_signal_reference (_tmp1047_);
									_tmp1049_ = _tmp1048_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1049_);
								} else {
									ValaMethod* _tmp1050_;
									_tmp1050_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1050_);
								}
								_tmp1051_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1052_ = _tmp1051_;
								member = _tmp1052_;
							} else {
								ValaMethod* _tmp1053_;
								ValaMethod* _tmp1054_;
								ValaMethod* _tmp1055_;
								_tmp1053_ = m;
								_tmp1054_ = vala_method_get_base_interface_method (_tmp1053_);
								_tmp1055_ = _tmp1054_;
								if (_tmp1055_ != NULL) {
									ValaMethod* _tmp1056_;
									ValaMethod* _tmp1057_;
									ValaMethod* _tmp1058_;
									ValaMethod* _tmp1059_;
									ValaSignal* _tmp1060_;
									ValaSignal* _tmp1061_;
									ValaSymbol* _tmp1066_;
									ValaSymbol* _tmp1067_;
									_tmp1056_ = m;
									_tmp1057_ = vala_method_get_base_interface_method (_tmp1056_);
									_tmp1058_ = _tmp1057_;
									m = _tmp1058_;
									_tmp1059_ = m;
									_tmp1060_ = vala_method_get_signal_reference (_tmp1059_);
									_tmp1061_ = _tmp1060_;
									if (_tmp1061_ != NULL) {
										ValaMethod* _tmp1062_;
										ValaSignal* _tmp1063_;
										ValaSignal* _tmp1064_;
										_tmp1062_ = m;
										_tmp1063_ = vala_method_get_signal_reference (_tmp1062_);
										_tmp1064_ = _tmp1063_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1064_);
									} else {
										ValaMethod* _tmp1065_;
										_tmp1065_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1065_);
									}
									_tmp1066_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1067_ = _tmp1066_;
									member = _tmp1067_;
								}
							}
						}
						_tmp1068_ = m;
						_tmp1069_ = vala_symbol_get_access ((ValaSymbol*) _tmp1068_);
						_tmp1070_ = _tmp1069_;
						access = _tmp1070_;
						_tmp1071_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1071_)) {
							ValaMethod* _tmp1072_;
							ValaMemberBinding _tmp1073_;
							ValaMemberBinding _tmp1074_;
							_tmp1072_ = m;
							_tmp1073_ = vala_method_get_binding (_tmp1072_);
							_tmp1074_ = _tmp1073_;
							instance = _tmp1074_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1075_ = m;
						_tmp1076_ = vala_method_get_binding (_tmp1075_);
						_tmp1077_ = _tmp1076_;
						klass = _tmp1077_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1078_;
							ValaList* _tmp1079_;
							ValaList* _tmp1080_;
							gint _param_size = 0;
							ValaList* _tmp1081_;
							gint _tmp1082_;
							gint _tmp1083_;
							gint _param_index = 0;
							_tmp1078_ = m;
							_tmp1079_ = vala_callable_get_parameters ((ValaCallable*) _tmp1078_);
							_tmp1080_ = _vala_iterable_ref0 (_tmp1079_);
							_param_list = _tmp1080_;
							_tmp1081_ = _param_list;
							_tmp1082_ = vala_collection_get_size ((ValaCollection*) _tmp1081_);
							_tmp1083_ = _tmp1082_;
							_param_size = _tmp1083_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1084_;
								gint _tmp1085_;
								ValaParameter* param = NULL;
								ValaList* _tmp1086_;
								gpointer _tmp1087_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1088_;
								ValaDataType* _tmp1089_;
								ValaDataType* _tmp1090_;
								gboolean _tmp1091_ = FALSE;
								ValaGenericType* _tmp1092_;
								_param_index = _param_index + 1;
								_tmp1084_ = _param_index;
								_tmp1085_ = _param_size;
								if (!(_tmp1084_ < _tmp1085_)) {
									break;
								}
								_tmp1086_ = _param_list;
								_tmp1087_ = vala_list_get (_tmp1086_, _param_index);
								param = (ValaParameter*) _tmp1087_;
								_tmp1088_ = param;
								_tmp1089_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1088_);
								_tmp1090_ = _tmp1089_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1090_) ? ((ValaGenericType*) _tmp1090_) : NULL;
								_tmp1092_ = generic_type;
								if (_tmp1092_ != NULL) {
									ValaGenericType* _tmp1093_;
									ValaTypeParameter* _tmp1094_;
									ValaTypeParameter* _tmp1095_;
									ValaSymbol* _tmp1096_;
									ValaSymbol* _tmp1097_;
									_tmp1093_ = generic_type;
									_tmp1094_ = vala_generic_type_get_type_parameter (_tmp1093_);
									_tmp1095_ = _tmp1094_;
									_tmp1096_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1095_);
									_tmp1097_ = _tmp1096_;
									_tmp1091_ = VALA_IS_TYPESYMBOL (_tmp1097_);
								} else {
									_tmp1091_ = FALSE;
								}
								if (_tmp1091_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp1098_ = m;
						_tmp1099_ = vala_callable_get_return_type ((ValaCallable*) _tmp1098_);
						_tmp1100_ = _tmp1099_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1100_) ? ((ValaGenericType*) _tmp1100_) : NULL;
						_tmp1102_ = generic_type;
						if (_tmp1102_ != NULL) {
							ValaGenericType* _tmp1103_;
							ValaTypeParameter* _tmp1104_;
							ValaTypeParameter* _tmp1105_;
							ValaSymbol* _tmp1106_;
							ValaSymbol* _tmp1107_;
							_tmp1103_ = generic_type;
							_tmp1104_ = vala_generic_type_get_type_parameter (_tmp1103_);
							_tmp1105_ = _tmp1104_;
							_tmp1106_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1105_);
							_tmp1107_ = _tmp1106_;
							_tmp1101_ = VALA_IS_TYPESYMBOL (_tmp1107_);
						} else {
							_tmp1101_ = FALSE;
						}
						if (_tmp1101_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1108_;
						_tmp1108_ = member;
						if (VALA_IS_PROPERTY (_tmp1108_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1109_;
							ValaProperty* _tmp1110_;
							ValaProperty* _tmp1111_;
							ValaProperty* _tmp1112_;
							ValaProperty* _tmp1113_;
							ValaProperty* _tmp1129_;
							ValaSymbolAccessibility _tmp1130_;
							ValaSymbolAccessibility _tmp1131_;
							gboolean _tmp1132_;
							gboolean _tmp1133_;
							ValaProperty* _tmp1238_;
							ValaMemberBinding _tmp1239_;
							ValaMemberBinding _tmp1240_;
							ValaProperty* _tmp1241_;
							ValaDataType* _tmp1242_;
							ValaDataType* _tmp1243_;
							_tmp1109_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1109_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1110_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1110_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								return result;
							}
							_tmp1111_ = prop;
							_tmp1112_ = vala_property_get_base_property (_tmp1111_);
							_tmp1113_ = _tmp1112_;
							if (_tmp1113_ != NULL) {
								ValaProperty* _tmp1114_;
								ValaProperty* _tmp1115_;
								ValaProperty* _tmp1116_;
								ValaProperty* _tmp1117_;
								ValaSymbol* _tmp1118_;
								ValaSymbol* _tmp1119_;
								_tmp1114_ = prop;
								_tmp1115_ = vala_property_get_base_property (_tmp1114_);
								_tmp1116_ = _tmp1115_;
								prop = _tmp1116_;
								_tmp1117_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1117_);
								_tmp1118_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1119_ = _tmp1118_;
								member = _tmp1119_;
							} else {
								ValaProperty* _tmp1120_;
								ValaProperty* _tmp1121_;
								ValaProperty* _tmp1122_;
								_tmp1120_ = prop;
								_tmp1121_ = vala_property_get_base_interface_property (_tmp1120_);
								_tmp1122_ = _tmp1121_;
								if (_tmp1122_ != NULL) {
									ValaProperty* _tmp1123_;
									ValaProperty* _tmp1124_;
									ValaProperty* _tmp1125_;
									ValaProperty* _tmp1126_;
									ValaSymbol* _tmp1127_;
									ValaSymbol* _tmp1128_;
									_tmp1123_ = prop;
									_tmp1124_ = vala_property_get_base_interface_property (_tmp1123_);
									_tmp1125_ = _tmp1124_;
									prop = _tmp1125_;
									_tmp1126_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1126_);
									_tmp1127_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1128_ = _tmp1127_;
									member = _tmp1128_;
								}
							}
							_tmp1129_ = prop;
							_tmp1130_ = vala_symbol_get_access ((ValaSymbol*) _tmp1129_);
							_tmp1131_ = _tmp1130_;
							access = _tmp1131_;
							_tmp1132_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1133_ = _tmp1132_;
							if (_tmp1133_) {
								ValaProperty* _tmp1134_;
								ValaPropertyAccessor* _tmp1135_;
								ValaPropertyAccessor* _tmp1136_;
								ValaProperty* _tmp1184_;
								ValaSymbolAccessibility _tmp1185_;
								ValaSymbolAccessibility _tmp1186_;
								_tmp1134_ = prop;
								_tmp1135_ = vala_property_get_set_accessor (_tmp1134_);
								_tmp1136_ = _tmp1135_;
								if (_tmp1136_ == NULL) {
									ValaSourceReference* _tmp1137_;
									ValaSourceReference* _tmp1138_;
									ValaProperty* _tmp1139_;
									gchar* _tmp1140_;
									gchar* _tmp1141_;
									gchar* _tmp1142_;
									gchar* _tmp1143_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1138_ = _tmp1137_;
									_tmp1139_ = prop;
									_tmp1140_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1139_);
									_tmp1141_ = _tmp1140_;
									_tmp1142_ = g_strdup_printf ("Property `%s' is read-only", _tmp1141_);
									_tmp1143_ = _tmp1142_;
									vala_report_error (_tmp1138_, _tmp1143_);
									_g_free0 (_tmp1143_);
									_g_free0 (_tmp1141_);
									result = FALSE;
									return result;
								} else {
									gboolean _tmp1144_ = FALSE;
									ValaProperty* _tmp1145_;
									ValaPropertyAccessor* _tmp1146_;
									ValaPropertyAccessor* _tmp1147_;
									gboolean _tmp1148_;
									gboolean _tmp1149_;
									_tmp1145_ = prop;
									_tmp1146_ = vala_property_get_set_accessor (_tmp1145_);
									_tmp1147_ = _tmp1146_;
									_tmp1148_ = vala_property_accessor_get_writable (_tmp1147_);
									_tmp1149_ = _tmp1148_;
									if (!_tmp1149_) {
										ValaProperty* _tmp1150_;
										ValaPropertyAccessor* _tmp1151_;
										ValaPropertyAccessor* _tmp1152_;
										gboolean _tmp1153_;
										gboolean _tmp1154_;
										_tmp1150_ = prop;
										_tmp1151_ = vala_property_get_set_accessor (_tmp1150_);
										_tmp1152_ = _tmp1151_;
										_tmp1153_ = vala_property_accessor_get_construction (_tmp1152_);
										_tmp1154_ = _tmp1153_;
										_tmp1144_ = _tmp1154_;
									} else {
										_tmp1144_ = FALSE;
									}
									if (_tmp1144_) {
										ValaSemanticAnalyzer* _tmp1155_;
										ValaSemanticAnalyzer* _tmp1156_;
										ValaMethod* _tmp1157_;
										_tmp1155_ = vala_code_context_get_analyzer (context);
										_tmp1156_ = _tmp1155_;
										_tmp1157_ = vala_semantic_analyzer_find_current_method (_tmp1156_);
										if (VALA_IS_CREATION_METHOD (_tmp1157_)) {
											ValaSourceReference* _tmp1158_;
											ValaSourceReference* _tmp1159_;
											vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
											_tmp1158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
											_tmp1159_ = _tmp1158_;
											vala_report_error (_tmp1159_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
											result = FALSE;
											return result;
										} else {
											ValaSemanticAnalyzer* _tmp1160_;
											ValaSemanticAnalyzer* _tmp1161_;
											_tmp1160_ = vala_code_context_get_analyzer (context);
											_tmp1161_ = _tmp1160_;
											if (vala_semantic_analyzer_is_in_constructor (_tmp1161_)) {
												ValaSemanticAnalyzer* _tmp1162_;
												ValaSemanticAnalyzer* _tmp1163_;
												ValaTypeSymbol* _tmp1164_;
												ValaTypeSymbol* _tmp1165_;
												ValaProperty* _tmp1166_;
												ValaSymbol* _tmp1167_;
												ValaSymbol* _tmp1168_;
												_tmp1162_ = vala_code_context_get_analyzer (context);
												_tmp1163_ = _tmp1162_;
												_tmp1164_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1163_);
												_tmp1165_ = _tmp1164_;
												_tmp1166_ = prop;
												_tmp1167_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1166_);
												_tmp1168_ = _tmp1167_;
												if (!vala_typesymbol_is_subtype_of (_tmp1165_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1168_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))) {
													ValaSourceReference* _tmp1169_;
													ValaSourceReference* _tmp1170_;
													ValaProperty* _tmp1171_;
													gchar* _tmp1172_;
													gchar* _tmp1173_;
													ValaSemanticAnalyzer* _tmp1174_;
													ValaSemanticAnalyzer* _tmp1175_;
													ValaTypeSymbol* _tmp1176_;
													ValaTypeSymbol* _tmp1177_;
													gchar* _tmp1178_;
													gchar* _tmp1179_;
													gchar* _tmp1180_;
													gchar* _tmp1181_;
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													_tmp1169_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1170_ = _tmp1169_;
													_tmp1171_ = prop;
													_tmp1172_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1171_);
													_tmp1173_ = _tmp1172_;
													_tmp1174_ = vala_code_context_get_analyzer (context);
													_tmp1175_ = _tmp1174_;
													_tmp1176_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1175_);
													_tmp1177_ = _tmp1176_;
													_tmp1178_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1177_);
													_tmp1179_ = _tmp1178_;
													_tmp1180_ = g_strdup_printf ("Cannot assign to construct-only property `%s' in `construct' of `%s'", _tmp1173_, _tmp1179_);
													_tmp1181_ = _tmp1180_;
													vala_report_error (_tmp1170_, _tmp1181_);
													_g_free0 (_tmp1181_);
													_g_free0 (_tmp1179_);
													_g_free0 (_tmp1173_);
													result = FALSE;
													return result;
												}
											} else {
												ValaSourceReference* _tmp1182_;
												ValaSourceReference* _tmp1183_;
												vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
												_tmp1182_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1183_ = _tmp1182_;
												vala_report_error (_tmp1183_, "Cannot assign to construct-only property in this context");
												result = FALSE;
												return result;
											}
										}
									}
								}
								_tmp1184_ = prop;
								_tmp1185_ = vala_symbol_get_access ((ValaSymbol*) _tmp1184_);
								_tmp1186_ = _tmp1185_;
								if (_tmp1186_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1187_;
									ValaPropertyAccessor* _tmp1188_;
									ValaPropertyAccessor* _tmp1189_;
									ValaSymbolAccessibility _tmp1190_;
									ValaSymbolAccessibility _tmp1191_;
									_tmp1187_ = prop;
									_tmp1188_ = vala_property_get_set_accessor (_tmp1187_);
									_tmp1189_ = _tmp1188_;
									_tmp1190_ = vala_symbol_get_access ((ValaSymbol*) _tmp1189_);
									_tmp1191_ = _tmp1190_;
									access = _tmp1191_;
								} else {
									gboolean _tmp1192_ = FALSE;
									ValaProperty* _tmp1193_;
									ValaSymbolAccessibility _tmp1194_;
									ValaSymbolAccessibility _tmp1195_;
									_tmp1193_ = prop;
									_tmp1194_ = vala_symbol_get_access ((ValaSymbol*) _tmp1193_);
									_tmp1195_ = _tmp1194_;
									if (_tmp1195_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1196_;
										ValaPropertyAccessor* _tmp1197_;
										ValaPropertyAccessor* _tmp1198_;
										ValaSymbolAccessibility _tmp1199_;
										ValaSymbolAccessibility _tmp1200_;
										_tmp1196_ = prop;
										_tmp1197_ = vala_property_get_set_accessor (_tmp1196_);
										_tmp1198_ = _tmp1197_;
										_tmp1199_ = vala_symbol_get_access ((ValaSymbol*) _tmp1198_);
										_tmp1200_ = _tmp1199_;
										_tmp1192_ = _tmp1200_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1192_ = FALSE;
									}
									if (_tmp1192_) {
										ValaProperty* _tmp1201_;
										ValaPropertyAccessor* _tmp1202_;
										ValaPropertyAccessor* _tmp1203_;
										ValaSymbolAccessibility _tmp1204_;
										ValaSymbolAccessibility _tmp1205_;
										_tmp1201_ = prop;
										_tmp1202_ = vala_property_get_set_accessor (_tmp1201_);
										_tmp1203_ = _tmp1202_;
										_tmp1204_ = vala_symbol_get_access ((ValaSymbol*) _tmp1203_);
										_tmp1205_ = _tmp1204_;
										access = _tmp1205_;
									}
								}
							} else {
								ValaProperty* _tmp1206_;
								ValaPropertyAccessor* _tmp1207_;
								ValaPropertyAccessor* _tmp1208_;
								ValaProperty* _tmp1216_;
								ValaSymbolAccessibility _tmp1217_;
								ValaSymbolAccessibility _tmp1218_;
								_tmp1206_ = prop;
								_tmp1207_ = vala_property_get_get_accessor (_tmp1206_);
								_tmp1208_ = _tmp1207_;
								if (_tmp1208_ == NULL) {
									ValaSourceReference* _tmp1209_;
									ValaSourceReference* _tmp1210_;
									ValaProperty* _tmp1211_;
									gchar* _tmp1212_;
									gchar* _tmp1213_;
									gchar* _tmp1214_;
									gchar* _tmp1215_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1210_ = _tmp1209_;
									_tmp1211_ = prop;
									_tmp1212_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1211_);
									_tmp1213_ = _tmp1212_;
									_tmp1214_ = g_strdup_printf ("Property `%s' is write-only", _tmp1213_);
									_tmp1215_ = _tmp1214_;
									vala_report_error (_tmp1210_, _tmp1215_);
									_g_free0 (_tmp1215_);
									_g_free0 (_tmp1213_);
									result = FALSE;
									return result;
								}
								_tmp1216_ = prop;
								_tmp1217_ = vala_symbol_get_access ((ValaSymbol*) _tmp1216_);
								_tmp1218_ = _tmp1217_;
								if (_tmp1218_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1219_;
									ValaPropertyAccessor* _tmp1220_;
									ValaPropertyAccessor* _tmp1221_;
									ValaSymbolAccessibility _tmp1222_;
									ValaSymbolAccessibility _tmp1223_;
									_tmp1219_ = prop;
									_tmp1220_ = vala_property_get_get_accessor (_tmp1219_);
									_tmp1221_ = _tmp1220_;
									_tmp1222_ = vala_symbol_get_access ((ValaSymbol*) _tmp1221_);
									_tmp1223_ = _tmp1222_;
									access = _tmp1223_;
								} else {
									gboolean _tmp1224_ = FALSE;
									ValaProperty* _tmp1225_;
									ValaSymbolAccessibility _tmp1226_;
									ValaSymbolAccessibility _tmp1227_;
									_tmp1225_ = prop;
									_tmp1226_ = vala_symbol_get_access ((ValaSymbol*) _tmp1225_);
									_tmp1227_ = _tmp1226_;
									if (_tmp1227_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1228_;
										ValaPropertyAccessor* _tmp1229_;
										ValaPropertyAccessor* _tmp1230_;
										ValaSymbolAccessibility _tmp1231_;
										ValaSymbolAccessibility _tmp1232_;
										_tmp1228_ = prop;
										_tmp1229_ = vala_property_get_get_accessor (_tmp1228_);
										_tmp1230_ = _tmp1229_;
										_tmp1231_ = vala_symbol_get_access ((ValaSymbol*) _tmp1230_);
										_tmp1232_ = _tmp1231_;
										_tmp1224_ = _tmp1232_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1224_ = FALSE;
									}
									if (_tmp1224_) {
										ValaProperty* _tmp1233_;
										ValaPropertyAccessor* _tmp1234_;
										ValaPropertyAccessor* _tmp1235_;
										ValaSymbolAccessibility _tmp1236_;
										ValaSymbolAccessibility _tmp1237_;
										_tmp1233_ = prop;
										_tmp1234_ = vala_property_get_get_accessor (_tmp1233_);
										_tmp1235_ = _tmp1234_;
										_tmp1236_ = vala_symbol_get_access ((ValaSymbol*) _tmp1235_);
										_tmp1237_ = _tmp1236_;
										access = _tmp1237_;
									}
								}
							}
							_tmp1238_ = prop;
							_tmp1239_ = vala_property_get_binding (_tmp1238_);
							_tmp1240_ = _tmp1239_;
							instance = _tmp1240_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1241_ = prop;
							_tmp1242_ = vala_property_get_property_type (_tmp1241_);
							_tmp1243_ = _tmp1242_;
							if (VALA_IS_GENERIC_TYPE (_tmp1243_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1244_;
							_tmp1244_ = member;
							if (VALA_IS_SIGNAL (_tmp1244_)) {
								ValaSymbol* _tmp1245_;
								ValaSymbolAccessibility _tmp1246_;
								ValaSymbolAccessibility _tmp1247_;
								instance = TRUE;
								_tmp1245_ = member;
								_tmp1246_ = vala_symbol_get_access (_tmp1245_);
								_tmp1247_ = _tmp1246_;
								access = _tmp1247_;
							} else {
								gboolean _tmp1248_ = FALSE;
								gboolean _tmp1249_;
								_tmp1249_ = self->priv->_creation_member;
								if (!_tmp1249_) {
									ValaSymbol* _tmp1250_;
									_tmp1250_ = member;
									_tmp1248_ = VALA_IS_ERROR_CODE (_tmp1250_);
								} else {
									_tmp1248_ = FALSE;
								}
								if (_tmp1248_) {
									ValaSymbol* _tmp1251_;
									ValaConstant* _tmp1252_;
									ValaConstant* _tmp1253_;
									ValaSymbol* _tmp1254_;
									ValaSymbol* _tmp1255_;
									_tmp1251_ = member;
									_tmp1252_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1251_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1253_ = _tmp1252_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1253_);
									_tmp1254_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1255_ = _tmp1254_;
									member = _tmp1255_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1256_;
		ValaSymbol* _tmp1257_;
		ValaCodeNode* _tmp1258_;
		ValaCodeNode* _tmp1259_;
		ValaCodeNode* _tmp1260_;
		gboolean _tmp1261_ = FALSE;
		ValaCodeNode* _tmp1262_;
		_tmp1256_ = parent;
		_tmp1257_ = member;
		if (!(_tmp1256_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1257_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1258_ = parent;
		_tmp1259_ = vala_code_node_get_parent_node (_tmp1258_);
		_tmp1260_ = _tmp1259_;
		parent = _tmp1260_;
		_tmp1262_ = parent;
		if (_tmp1262_ == NULL) {
			_tmp1261_ = TRUE;
		} else {
			ValaCodeNode* _tmp1263_;
			ValaSymbol* _tmp1264_;
			_tmp1263_ = parent;
			_tmp1264_ = member;
			_tmp1261_ = _tmp1263_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1264_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1261_) {
			break;
		}
	}
	_tmp1265_ = parent;
	_tmp1266_ = member;
	if (_tmp1265_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1266_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1267_;
		_tmp1267_ = member;
		vala_symbol_set_used (_tmp1267_, TRUE);
	}
	_tmp1268_ = member;
	_tmp1269_ = vala_symbol_get_version (_tmp1268_);
	_tmp1270_ = _tmp1269_;
	_tmp1271_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1272_ = _tmp1271_;
	vala_version_attribute_check (_tmp1270_, _tmp1272_);
	if (access == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1274_;
		ValaSymbol* _tmp1275_;
		ValaSymbol* _tmp1276_;
		_tmp1274_ = member;
		_tmp1275_ = vala_symbol_get_parent_symbol (_tmp1274_);
		_tmp1276_ = _tmp1275_;
		_tmp1273_ = VALA_IS_TYPESYMBOL (_tmp1276_);
	} else {
		_tmp1273_ = FALSE;
	}
	if (_tmp1273_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1277_;
		ValaSymbol* _tmp1278_;
		ValaSymbol* _tmp1279_;
		gboolean in_subtype = FALSE;
		_tmp1277_ = member;
		_tmp1278_ = vala_symbol_get_parent_symbol (_tmp1277_);
		_tmp1279_ = _tmp1278_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1279_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1280_;
			ValaSemanticAnalyzer* _tmp1281_;
			ValaSymbol* _tmp1282_;
			ValaSymbol* _tmp1283_;
			ValaSymbol* _tmp1284_;
			_tmp1280_ = vala_code_context_get_analyzer (context);
			_tmp1281_ = _tmp1280_;
			_tmp1282_ = vala_semantic_analyzer_get_current_symbol (_tmp1281_);
			_tmp1283_ = _tmp1282_;
			_tmp1284_ = _vala_code_node_ref0 (_tmp1283_);
			this_symbol = _tmp1284_;
			{
				gboolean _tmp1285_ = FALSE;
				_tmp1285_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1290_;
					ValaSymbol* _tmp1291_;
					ValaTypeSymbol* _tmp1292_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1293_;
					gboolean _tmp1294_ = FALSE;
					ValaClass* _tmp1295_;
					if (!_tmp1285_) {
						ValaSymbol* _tmp1286_;
						ValaSymbol* _tmp1287_;
						ValaSymbol* _tmp1288_;
						ValaSymbol* _tmp1289_;
						_tmp1286_ = this_symbol;
						_tmp1287_ = vala_symbol_get_parent_symbol (_tmp1286_);
						_tmp1288_ = _tmp1287_;
						_tmp1289_ = _vala_code_node_ref0 (_tmp1288_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1289_;
					}
					_tmp1285_ = FALSE;
					_tmp1290_ = this_symbol;
					if (!(_tmp1290_ != NULL)) {
						break;
					}
					_tmp1291_ = this_symbol;
					_tmp1292_ = target_type;
					if (_tmp1291_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1292_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1293_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1293_) ? ((ValaClass*) _tmp1293_) : NULL;
					_tmp1295_ = cl;
					if (_tmp1295_ != NULL) {
						ValaClass* _tmp1296_;
						ValaTypeSymbol* _tmp1297_;
						_tmp1296_ = cl;
						_tmp1297_ = target_type;
						_tmp1294_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1296_, _tmp1297_);
					} else {
						_tmp1294_ = FALSE;
					}
					if (_tmp1294_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1298_;
			ValaSourceReference* _tmp1299_;
			ValaSymbol* _tmp1300_;
			gchar* _tmp1301_;
			gchar* _tmp1302_;
			gchar* _tmp1303_;
			gchar* _tmp1304_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1298_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1299_ = _tmp1298_;
			_tmp1300_ = member;
			_tmp1301_ = vala_symbol_get_full_name (_tmp1300_);
			_tmp1302_ = _tmp1301_;
			_tmp1303_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1302_);
			_tmp1304_ = _tmp1303_;
			vala_report_error (_tmp1299_, _tmp1304_);
			_g_free0 (_tmp1304_);
			_g_free0 (_tmp1302_);
			result = FALSE;
			return result;
		}
	} else {
		if (access == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1305_;
			ValaSymbol* _tmp1306_;
			ValaSymbol* _tmp1307_;
			gboolean in_target_type = FALSE;
			_tmp1305_ = member;
			_tmp1306_ = vala_symbol_get_parent_symbol (_tmp1305_);
			_tmp1307_ = _tmp1306_;
			target_type = _tmp1307_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1308_;
				ValaSemanticAnalyzer* _tmp1309_;
				ValaSymbol* _tmp1310_;
				ValaSymbol* _tmp1311_;
				ValaSymbol* _tmp1312_;
				_tmp1308_ = vala_code_context_get_analyzer (context);
				_tmp1309_ = _tmp1308_;
				_tmp1310_ = vala_semantic_analyzer_get_current_symbol (_tmp1309_);
				_tmp1311_ = _tmp1310_;
				_tmp1312_ = _vala_code_node_ref0 (_tmp1311_);
				this_symbol = _tmp1312_;
				{
					gboolean _tmp1313_ = FALSE;
					_tmp1313_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1318_;
						ValaSymbol* _tmp1319_;
						ValaSymbol* _tmp1320_;
						if (!_tmp1313_) {
							ValaSymbol* _tmp1314_;
							ValaSymbol* _tmp1315_;
							ValaSymbol* _tmp1316_;
							ValaSymbol* _tmp1317_;
							_tmp1314_ = this_symbol;
							_tmp1315_ = vala_symbol_get_parent_symbol (_tmp1314_);
							_tmp1316_ = _tmp1315_;
							_tmp1317_ = _vala_code_node_ref0 (_tmp1316_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1317_;
						}
						_tmp1313_ = FALSE;
						_tmp1318_ = this_symbol;
						if (!(_tmp1318_ != NULL)) {
							break;
						}
						_tmp1319_ = target_type;
						_tmp1320_ = this_symbol;
						if (_tmp1319_ == _tmp1320_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1321_;
				ValaSourceReference* _tmp1322_;
				ValaSymbol* _tmp1323_;
				gchar* _tmp1324_;
				gchar* _tmp1325_;
				gchar* _tmp1326_;
				gchar* _tmp1327_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1321_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1322_ = _tmp1321_;
				_tmp1323_ = member;
				_tmp1324_ = vala_symbol_get_full_name (_tmp1323_);
				_tmp1325_ = _tmp1324_;
				_tmp1326_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1325_);
				_tmp1327_ = _tmp1326_;
				vala_report_error (_tmp1322_, _tmp1327_);
				_g_free0 (_tmp1327_);
				_g_free0 (_tmp1325_);
				result = FALSE;
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1329_;
		ValaExpression* _tmp1330_;
		_tmp1329_ = vala_member_access_get_inner (self);
		_tmp1330_ = _tmp1329_;
		_tmp1328_ = _tmp1330_ != NULL;
	} else {
		_tmp1328_ = FALSE;
	}
	if (_tmp1328_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1331_;
		ValaExpression* _tmp1332_;
		ValaDataType* _tmp1333_;
		ValaDataType* _tmp1334_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1335_;
		ValaExpression* _tmp1336_;
		ValaDataType* _tmp1337_;
		ValaDataType* _tmp1338_;
		ValaPointerType* _tmp1339_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1343_;
		gboolean _tmp1344_ = FALSE;
		gboolean _tmp1345_ = FALSE;
		ValaObjectType* _tmp1346_;
		_tmp1331_ = vala_member_access_get_inner (self);
		_tmp1332_ = _tmp1331_;
		_tmp1333_ = vala_expression_get_value_type (_tmp1332_);
		_tmp1334_ = _tmp1333_;
		instance_type = _tmp1334_;
		_tmp1335_ = vala_member_access_get_inner (self);
		_tmp1336_ = _tmp1335_;
		_tmp1337_ = vala_expression_get_value_type (_tmp1336_);
		_tmp1338_ = _tmp1337_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1338_) ? ((ValaPointerType*) _tmp1338_) : NULL;
		_tmp1339_ = pointer_type;
		if (_tmp1339_ != NULL) {
			ValaPointerType* _tmp1340_;
			ValaDataType* _tmp1341_;
			ValaDataType* _tmp1342_;
			_tmp1340_ = pointer_type;
			_tmp1341_ = vala_pointer_type_get_base_type (_tmp1340_);
			_tmp1342_ = _tmp1341_;
			instance_type = _tmp1342_;
		}
		_tmp1343_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1343_) ? ((ValaObjectType*) _tmp1343_) : NULL;
		_tmp1346_ = object_type;
		if (_tmp1346_ != NULL) {
			ValaObjectType* _tmp1347_;
			ValaObjectTypeSymbol* _tmp1348_;
			ValaObjectTypeSymbol* _tmp1349_;
			_tmp1347_ = object_type;
			_tmp1348_ = vala_object_type_get_object_type_symbol (_tmp1347_);
			_tmp1349_ = _tmp1348_;
			_tmp1345_ = vala_object_type_symbol_has_type_parameters (_tmp1349_);
		} else {
			_tmp1345_ = FALSE;
		}
		if (_tmp1345_) {
			ValaDataType* _tmp1350_;
			_tmp1350_ = instance_type;
			_tmp1344_ = !vala_data_type_has_type_arguments (_tmp1350_);
		} else {
			_tmp1344_ = FALSE;
		}
		if (_tmp1344_) {
			ValaExpression* _tmp1351_;
			ValaExpression* _tmp1352_;
			ValaSourceReference* _tmp1353_;
			ValaSourceReference* _tmp1354_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1351_ = vala_member_access_get_inner (self);
			_tmp1352_ = _tmp1351_;
			_tmp1353_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1352_);
			_tmp1354_ = _tmp1353_;
			vala_report_error (_tmp1354_, "missing generic type arguments");
			result = FALSE;
			return result;
		}
	}
	if (instance) {
		_tmp1356_ = !may_access_instance_members;
	} else {
		_tmp1356_ = FALSE;
	}
	if (_tmp1356_) {
		_tmp1355_ = TRUE;
	} else {
		gboolean _tmp1357_ = FALSE;
		if (klass) {
			_tmp1357_ = !may_access_klass_members;
		} else {
			_tmp1357_ = FALSE;
		}
		_tmp1355_ = _tmp1357_;
	}
	if (_tmp1355_) {
		ValaSymbol* _tmp1358_;
		ValaSymbol* _tmp1359_;
		ValaDataType* _tmp1394_;
		ValaDataType* _tmp1395_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1358_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1359_ = _tmp1358_;
		if (VALA_IS_METHOD (_tmp1359_)) {
			ValaSemanticAnalyzer* _tmp1360_;
			ValaSemanticAnalyzer* _tmp1361_;
			ValaSymbol* _tmp1362_;
			ValaSymbol* _tmp1363_;
			gboolean _tmp1364_;
			gboolean _tmp1365_;
			ValaDataType* _tmp1366_;
			ValaDataType* _tmp1367_;
			ValaDataType* _tmp1368_;
			ValaDataType* _tmp1369_;
			ValaSourceReference* _tmp1370_;
			ValaSourceReference* _tmp1371_;
			_tmp1360_ = vala_code_context_get_analyzer (context);
			_tmp1361_ = _tmp1360_;
			_tmp1362_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1363_ = _tmp1362_;
			_tmp1364_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1365_ = _tmp1364_;
			_tmp1366_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1361_, _tmp1363_, _tmp1365_);
			_tmp1367_ = _tmp1366_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1367_);
			_vala_code_node_unref0 (_tmp1367_);
			_tmp1368_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1369_ = _tmp1368_;
			_tmp1370_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1371_ = _tmp1370_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1369_, _tmp1371_);
		} else {
			ValaSymbol* _tmp1372_;
			ValaSymbol* _tmp1373_;
			_tmp1372_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1373_ = _tmp1372_;
			if (VALA_IS_FIELD (_tmp1373_)) {
				ValaSymbol* _tmp1374_;
				ValaSymbol* _tmp1375_;
				ValaFieldPrototype* _tmp1376_;
				ValaFieldPrototype* _tmp1377_;
				ValaDataType* _tmp1378_;
				ValaDataType* _tmp1379_;
				ValaSourceReference* _tmp1380_;
				ValaSourceReference* _tmp1381_;
				_tmp1374_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1375_ = _tmp1374_;
				_tmp1376_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1375_, VALA_TYPE_FIELD, ValaField));
				_tmp1377_ = _tmp1376_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1377_);
				_vala_code_node_unref0 (_tmp1377_);
				_tmp1378_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1379_ = _tmp1378_;
				_tmp1380_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1381_ = _tmp1380_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1379_, _tmp1381_);
			} else {
				ValaSymbol* _tmp1382_;
				ValaSymbol* _tmp1383_;
				_tmp1382_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1383_ = _tmp1382_;
				if (VALA_IS_PROPERTY (_tmp1383_)) {
					ValaSymbol* _tmp1384_;
					ValaSymbol* _tmp1385_;
					ValaPropertyPrototype* _tmp1386_;
					ValaPropertyPrototype* _tmp1387_;
					ValaDataType* _tmp1388_;
					ValaDataType* _tmp1389_;
					ValaSourceReference* _tmp1390_;
					ValaSourceReference* _tmp1391_;
					_tmp1384_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1385_ = _tmp1384_;
					_tmp1386_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1385_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1387_ = _tmp1386_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1387_);
					_vala_code_node_unref0 (_tmp1387_);
					_tmp1388_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp1389_ = _tmp1388_;
					_tmp1390_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1391_ = _tmp1390_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1389_, _tmp1391_);
				} else {
					ValaInvalidType* _tmp1392_;
					ValaInvalidType* _tmp1393_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1392_ = vala_invalid_type_new ();
					_tmp1393_ = _tmp1392_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1393_);
					_vala_code_node_unref0 (_tmp1393_);
				}
			}
		}
		_tmp1394_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1395_ = _tmp1394_;
		if (_tmp1395_ != NULL) {
			ValaDataType* _tmp1396_;
			ValaDataType* _tmp1397_;
			ValaDataType* _tmp1398_;
			ValaDataType* _tmp1399_;
			gboolean _tmp1400_;
			gboolean _tmp1401_;
			_tmp1396_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1397_ = _tmp1396_;
			_tmp1398_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1399_ = _tmp1398_;
			_tmp1400_ = vala_data_type_get_value_owned (_tmp1399_);
			_tmp1401_ = _tmp1400_;
			vala_data_type_set_value_owned (_tmp1397_, _tmp1401_);
		}
	} else {
		gboolean _tmp1402_ = FALSE;
		gboolean _tmp1423_ = FALSE;
		gboolean _tmp1424_ = FALSE;
		gboolean _tmp1425_ = FALSE;
		gboolean _tmp1426_ = FALSE;
		gboolean _tmp1469_ = FALSE;
		gboolean _tmp1470_ = FALSE;
		gboolean _tmp1471_ = FALSE;
		gboolean _tmp1472_ = FALSE;
		gboolean _tmp1473_ = FALSE;
		gboolean _tmp1474_;
		gboolean _tmp1475_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1502_;
		ValaSymbol* _tmp1503_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1504_;
		ValaExpression* _tmp1505_;
		gboolean _tmp1506_ = FALSE;
		gboolean _tmp1507_ = FALSE;
		gboolean _tmp1508_ = FALSE;
		gboolean _tmp1509_ = FALSE;
		gboolean _tmp1510_ = FALSE;
		ValaMethod* _tmp1511_;
		ValaSemanticAnalyzer* _tmp1556_;
		ValaSemanticAnalyzer* _tmp1557_;
		ValaSymbol* _tmp1558_;
		ValaSymbol* _tmp1559_;
		gboolean _tmp1560_;
		gboolean _tmp1561_;
		ValaDataType* _tmp1562_;
		ValaDataType* _tmp1563_;
		gboolean _tmp1564_ = FALSE;
		ValaExpression* _tmp1565_;
		ValaExpression* _tmp1566_;
		ValaSymbol* _tmp1579_;
		ValaSymbol* _tmp1580_;
		if (instance) {
			ValaExpression* _tmp1403_;
			ValaExpression* _tmp1404_;
			_tmp1403_ = vala_member_access_get_inner (self);
			_tmp1404_ = _tmp1403_;
			_tmp1402_ = _tmp1404_ == NULL;
		} else {
			_tmp1402_ = FALSE;
		}
		if (_tmp1402_) {
			ValaSourceReference* _tmp1405_;
			ValaSourceReference* _tmp1406_;
			ValaMemberAccess* _tmp1407_;
			ValaMemberAccess* _tmp1408_;
			ValaExpression* _tmp1409_;
			ValaExpression* _tmp1410_;
			ValaParameter* _tmp1411_;
			ValaDataType* _tmp1412_;
			ValaDataType* _tmp1413_;
			ValaDataType* _tmp1414_;
			ValaDataType* _tmp1415_;
			ValaExpression* _tmp1416_;
			ValaExpression* _tmp1417_;
			ValaDataType* _tmp1418_;
			ValaDataType* _tmp1419_;
			ValaExpression* _tmp1420_;
			ValaExpression* _tmp1421_;
			ValaParameter* _tmp1422_;
			_tmp1405_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1406_ = _tmp1405_;
			_tmp1407_ = vala_member_access_new (NULL, "this", _tmp1406_);
			_tmp1408_ = _tmp1407_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1408_);
			_vala_code_node_unref0 (_tmp1408_);
			_tmp1409_ = vala_member_access_get_inner (self);
			_tmp1410_ = _tmp1409_;
			_tmp1411_ = this_parameter;
			_tmp1412_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1411_);
			_tmp1413_ = _tmp1412_;
			_tmp1414_ = vala_data_type_copy (_tmp1413_);
			_tmp1415_ = _tmp1414_;
			vala_expression_set_value_type (_tmp1410_, _tmp1415_);
			_vala_code_node_unref0 (_tmp1415_);
			_tmp1416_ = vala_member_access_get_inner (self);
			_tmp1417_ = _tmp1416_;
			_tmp1418_ = vala_expression_get_value_type (_tmp1417_);
			_tmp1419_ = _tmp1418_;
			vala_data_type_set_value_owned (_tmp1419_, FALSE);
			_tmp1420_ = vala_member_access_get_inner (self);
			_tmp1421_ = _tmp1420_;
			_tmp1422_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1421_, (ValaSymbol*) _tmp1422_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1426_ = !klass;
		} else {
			_tmp1426_ = FALSE;
		}
		if (_tmp1426_) {
			ValaSymbol* _tmp1427_;
			ValaSymbol* _tmp1428_;
			_tmp1427_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1428_ = _tmp1427_;
			_tmp1425_ = !VALA_IS_CREATION_METHOD (_tmp1428_);
		} else {
			_tmp1425_ = FALSE;
		}
		if (_tmp1425_) {
			_tmp1424_ = may_access_instance_members;
		} else {
			_tmp1424_ = FALSE;
		}
		if (_tmp1424_) {
			ValaExpression* _tmp1429_;
			ValaExpression* _tmp1430_;
			_tmp1429_ = vala_member_access_get_inner (self);
			_tmp1430_ = _tmp1429_;
			_tmp1423_ = _tmp1430_ != NULL;
		} else {
			_tmp1423_ = FALSE;
		}
		if (_tmp1423_) {
			ValaExpression* _tmp1431_;
			ValaExpression* _tmp1432_;
			ValaSymbol* _tmp1433_;
			ValaSymbol* _tmp1434_;
			_tmp1431_ = vala_member_access_get_inner (self);
			_tmp1432_ = _tmp1431_;
			_tmp1433_ = vala_expression_get_symbol_reference (_tmp1432_);
			_tmp1434_ = _tmp1433_;
			if (VALA_IS_METHOD (_tmp1434_)) {
			} else {
				ValaSourceReference* _tmp1435_;
				ValaSourceReference* _tmp1436_;
				ValaSymbol* _tmp1437_;
				ValaSymbol* _tmp1438_;
				gchar* _tmp1439_;
				gchar* _tmp1440_;
				gchar* _tmp1441_;
				gchar* _tmp1442_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1443_;
				ValaSymbol* _tmp1444_;
				ValaSymbol* _tmp1445_;
				ValaSymbol* _tmp1446_;
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp1466_;
				ValaExpression* _tmp1467_;
				ValaExpression* _tmp1468_;
				_tmp1435_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1436_ = _tmp1435_;
				_tmp1437_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1438_ = _tmp1437_;
				_tmp1439_ = vala_symbol_get_full_name (_tmp1438_);
				_tmp1440_ = _tmp1439_;
				_tmp1441_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1440_);
				_tmp1442_ = _tmp1441_;
				vala_report_warning (_tmp1436_, _tmp1442_);
				_g_free0 (_tmp1442_);
				_g_free0 (_tmp1440_);
				_tmp1443_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1444_ = _tmp1443_;
				_tmp1445_ = vala_symbol_get_parent_symbol (_tmp1444_);
				_tmp1446_ = _tmp1445_;
				inner_sym = _tmp1446_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1447_ = FALSE;
					ValaSymbol* _tmp1448_;
					ValaMemberAccess* _tmp1452_;
					ValaSymbol* _tmp1453_;
					const gchar* _tmp1454_;
					const gchar* _tmp1455_;
					ValaSourceReference* _tmp1456_;
					ValaSourceReference* _tmp1457_;
					ValaMemberAccess* _tmp1458_;
					ValaMemberAccess* _tmp1459_;
					ValaMemberAccess* _tmp1460_;
					ValaExpression* _tmp1461_;
					ValaExpression* _tmp1462_;
					ValaSymbol* _tmp1463_;
					ValaSymbol* _tmp1464_;
					ValaSymbol* _tmp1465_;
					_tmp1448_ = inner_sym;
					if (_tmp1448_ != NULL) {
						ValaSymbol* _tmp1449_;
						const gchar* _tmp1450_;
						const gchar* _tmp1451_;
						_tmp1449_ = inner_sym;
						_tmp1450_ = vala_symbol_get_name (_tmp1449_);
						_tmp1451_ = _tmp1450_;
						_tmp1447_ = _tmp1451_ != NULL;
					} else {
						_tmp1447_ = FALSE;
					}
					if (!_tmp1447_) {
						break;
					}
					_tmp1452_ = inner_ma;
					_tmp1453_ = inner_sym;
					_tmp1454_ = vala_symbol_get_name (_tmp1453_);
					_tmp1455_ = _tmp1454_;
					_tmp1456_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1457_ = _tmp1456_;
					_tmp1458_ = vala_member_access_new (NULL, _tmp1455_, _tmp1457_);
					_tmp1459_ = _tmp1458_;
					vala_member_access_set_inner (_tmp1452_, (ValaExpression*) _tmp1459_);
					_vala_code_node_unref0 (_tmp1459_);
					_tmp1460_ = inner_ma;
					_tmp1461_ = vala_member_access_get_inner (_tmp1460_);
					_tmp1462_ = _tmp1461_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1462_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1463_ = inner_sym;
					_tmp1464_ = vala_symbol_get_parent_symbol (_tmp1463_);
					_tmp1465_ = _tmp1464_;
					inner_sym = _tmp1465_;
				}
				_tmp1466_ = inner_ma;
				vala_member_access_set_qualified (_tmp1466_, TRUE);
				_tmp1467_ = vala_member_access_get_inner (self);
				_tmp1468_ = _tmp1467_;
				vala_code_node_check ((ValaCodeNode*) _tmp1468_, context);
			}
		}
		_tmp1474_ = vala_code_context_get_experimental_non_null (context);
		_tmp1475_ = _tmp1474_;
		if (_tmp1475_) {
			_tmp1473_ = instance;
		} else {
			_tmp1473_ = FALSE;
		}
		if (_tmp1473_) {
			ValaExpression* _tmp1476_;
			ValaExpression* _tmp1477_;
			ValaDataType* _tmp1478_;
			ValaDataType* _tmp1479_;
			gboolean _tmp1480_;
			gboolean _tmp1481_;
			_tmp1476_ = vala_member_access_get_inner (self);
			_tmp1477_ = _tmp1476_;
			_tmp1478_ = vala_expression_get_value_type (_tmp1477_);
			_tmp1479_ = _tmp1478_;
			_tmp1480_ = vala_data_type_get_nullable (_tmp1479_);
			_tmp1481_ = _tmp1480_;
			_tmp1472_ = _tmp1481_;
		} else {
			_tmp1472_ = FALSE;
		}
		if (_tmp1472_) {
			ValaExpression* _tmp1482_;
			ValaExpression* _tmp1483_;
			ValaDataType* _tmp1484_;
			ValaDataType* _tmp1485_;
			_tmp1482_ = vala_member_access_get_inner (self);
			_tmp1483_ = _tmp1482_;
			_tmp1484_ = vala_expression_get_value_type (_tmp1483_);
			_tmp1485_ = _tmp1484_;
			_tmp1471_ = !VALA_IS_POINTER_TYPE (_tmp1485_);
		} else {
			_tmp1471_ = FALSE;
		}
		if (_tmp1471_) {
			ValaExpression* _tmp1486_;
			ValaExpression* _tmp1487_;
			ValaDataType* _tmp1488_;
			ValaDataType* _tmp1489_;
			_tmp1486_ = vala_member_access_get_inner (self);
			_tmp1487_ = _tmp1486_;
			_tmp1488_ = vala_expression_get_value_type (_tmp1487_);
			_tmp1489_ = _tmp1488_;
			_tmp1470_ = !VALA_IS_GENERIC_TYPE (_tmp1489_);
		} else {
			_tmp1470_ = FALSE;
		}
		if (_tmp1470_) {
			ValaExpression* _tmp1490_;
			ValaExpression* _tmp1491_;
			ValaDataType* _tmp1492_;
			ValaDataType* _tmp1493_;
			_tmp1490_ = vala_member_access_get_inner (self);
			_tmp1491_ = _tmp1490_;
			_tmp1492_ = vala_expression_get_value_type (_tmp1491_);
			_tmp1493_ = _tmp1492_;
			_tmp1469_ = !VALA_IS_ARRAY_TYPE (_tmp1493_);
		} else {
			_tmp1469_ = FALSE;
		}
		if (_tmp1469_) {
			ValaSourceReference* _tmp1494_;
			ValaSourceReference* _tmp1495_;
			ValaSymbol* _tmp1496_;
			ValaSymbol* _tmp1497_;
			gchar* _tmp1498_;
			gchar* _tmp1499_;
			gchar* _tmp1500_;
			gchar* _tmp1501_;
			_tmp1494_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1495_ = _tmp1494_;
			_tmp1496_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1497_ = _tmp1496_;
			_tmp1498_ = vala_symbol_get_full_name (_tmp1497_);
			_tmp1499_ = _tmp1498_;
			_tmp1500_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1499_);
			_tmp1501_ = _tmp1500_;
			vala_report_error (_tmp1495_, _tmp1501_);
			_g_free0 (_tmp1501_);
			_g_free0 (_tmp1499_);
		}
		_tmp1502_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1503_ = _tmp1502_;
		m = VALA_IS_METHOD (_tmp1503_) ? ((ValaMethod*) _tmp1503_) : NULL;
		_tmp1504_ = vala_member_access_get_inner (self);
		_tmp1505_ = _tmp1504_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1505_) ? ((ValaMemberAccess*) _tmp1505_) : NULL;
		_tmp1511_ = m;
		if (_tmp1511_ != NULL) {
			ValaMethod* _tmp1512_;
			ValaMemberBinding _tmp1513_;
			ValaMemberBinding _tmp1514_;
			_tmp1512_ = m;
			_tmp1513_ = vala_method_get_binding (_tmp1512_);
			_tmp1514_ = _tmp1513_;
			_tmp1510_ = _tmp1514_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1510_ = FALSE;
		}
		if (_tmp1510_) {
			ValaMethod* _tmp1515_;
			ValaSymbol* _tmp1516_;
			ValaSymbol* _tmp1517_;
			_tmp1515_ = m;
			_tmp1516_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1515_);
			_tmp1517_ = _tmp1516_;
			_tmp1509_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1517_);
		} else {
			_tmp1509_ = FALSE;
		}
		if (_tmp1509_) {
			ValaExpression* _tmp1518_;
			ValaExpression* _tmp1519_;
			_tmp1518_ = vala_member_access_get_inner (self);
			_tmp1519_ = _tmp1518_;
			_tmp1508_ = _tmp1519_ != NULL;
		} else {
			_tmp1508_ = FALSE;
		}
		if (_tmp1508_) {
			ValaExpression* _tmp1520_;
			ValaExpression* _tmp1521_;
			ValaDataType* _tmp1522_;
			ValaDataType* _tmp1523_;
			_tmp1520_ = vala_member_access_get_inner (self);
			_tmp1521_ = _tmp1520_;
			_tmp1522_ = vala_expression_get_value_type (_tmp1521_);
			_tmp1523_ = _tmp1522_;
			_tmp1507_ = _tmp1523_ == NULL;
		} else {
			_tmp1507_ = FALSE;
		}
		if (_tmp1507_) {
			ValaMemberAccess* _tmp1524_;
			ValaList* _tmp1525_;
			gint _tmp1526_;
			gint _tmp1527_;
			_tmp1524_ = inner_ma;
			_tmp1525_ = _tmp1524_->priv->type_argument_list;
			_tmp1526_ = vala_collection_get_size ((ValaCollection*) _tmp1525_);
			_tmp1527_ = _tmp1526_;
			_tmp1506_ = _tmp1527_ > 0;
		} else {
			_tmp1506_ = FALSE;
		}
		if (_tmp1506_) {
			ValaExpression* _tmp1528_;
			ValaExpression* _tmp1529_;
			ValaMethod* _tmp1530_;
			ValaSymbol* _tmp1531_;
			ValaSymbol* _tmp1532_;
			ValaObjectType* _tmp1533_;
			ValaObjectType* _tmp1534_;
			ValaExpression* _tmp1535_;
			ValaExpression* _tmp1536_;
			ValaDataType* _tmp1537_;
			ValaDataType* _tmp1538_;
			ValaSourceReference* _tmp1539_;
			ValaSourceReference* _tmp1540_;
			_tmp1528_ = vala_member_access_get_inner (self);
			_tmp1529_ = _tmp1528_;
			_tmp1530_ = m;
			_tmp1531_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1530_);
			_tmp1532_ = _tmp1531_;
			_tmp1533_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1532_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1534_ = _tmp1533_;
			vala_expression_set_value_type (_tmp1529_, (ValaDataType*) _tmp1534_);
			_vala_code_node_unref0 (_tmp1534_);
			_tmp1535_ = vala_member_access_get_inner (self);
			_tmp1536_ = _tmp1535_;
			_tmp1537_ = vala_expression_get_value_type (_tmp1536_);
			_tmp1538_ = _tmp1537_;
			_tmp1539_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1540_ = _tmp1539_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1538_, _tmp1540_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1541_;
				ValaList* _tmp1542_;
				ValaList* _tmp1543_;
				gint _type_argument_size = 0;
				ValaList* _tmp1544_;
				gint _tmp1545_;
				gint _tmp1546_;
				gint _type_argument_index = 0;
				_tmp1541_ = inner_ma;
				_tmp1542_ = _tmp1541_->priv->type_argument_list;
				_tmp1543_ = _vala_iterable_ref0 (_tmp1542_);
				_type_argument_list = _tmp1543_;
				_tmp1544_ = _type_argument_list;
				_tmp1545_ = vala_collection_get_size ((ValaCollection*) _tmp1544_);
				_tmp1546_ = _tmp1545_;
				_type_argument_size = _tmp1546_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1547_;
					gint _tmp1548_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1549_;
					gpointer _tmp1550_;
					ValaExpression* _tmp1551_;
					ValaExpression* _tmp1552_;
					ValaDataType* _tmp1553_;
					ValaDataType* _tmp1554_;
					ValaDataType* _tmp1555_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1547_ = _type_argument_index;
					_tmp1548_ = _type_argument_size;
					if (!(_tmp1547_ < _tmp1548_)) {
						break;
					}
					_tmp1549_ = _type_argument_list;
					_tmp1550_ = vala_list_get (_tmp1549_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1550_;
					_tmp1551_ = vala_member_access_get_inner (self);
					_tmp1552_ = _tmp1551_;
					_tmp1553_ = vala_expression_get_value_type (_tmp1552_);
					_tmp1554_ = _tmp1553_;
					_tmp1555_ = type_argument;
					vala_data_type_add_type_argument (_tmp1554_, _tmp1555_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1556_ = vala_code_context_get_analyzer (context);
		_tmp1557_ = _tmp1556_;
		_tmp1558_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1559_ = _tmp1558_;
		_tmp1560_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1561_ = _tmp1560_;
		_tmp1562_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1557_, _tmp1559_, _tmp1561_);
		_tmp1563_ = _tmp1562_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1563_);
		_vala_code_node_unref0 (_tmp1563_);
		_tmp1565_ = vala_member_access_get_inner (self);
		_tmp1566_ = _tmp1565_;
		if (_tmp1566_ != NULL) {
			ValaDataType* _tmp1567_;
			ValaDataType* _tmp1568_;
			_tmp1567_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1568_ = _tmp1567_;
			_tmp1564_ = _tmp1568_ != NULL;
		} else {
			_tmp1564_ = FALSE;
		}
		if (_tmp1564_) {
			ValaDataType* _tmp1569_;
			ValaDataType* _tmp1570_;
			ValaExpression* _tmp1571_;
			ValaExpression* _tmp1572_;
			ValaDataType* _tmp1573_;
			ValaDataType* _tmp1574_;
			ValaDataType* _tmp1575_;
			ValaDataType* _tmp1576_;
			_tmp1569_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1570_ = _tmp1569_;
			_tmp1571_ = vala_member_access_get_inner (self);
			_tmp1572_ = _tmp1571_;
			_tmp1573_ = vala_expression_get_value_type (_tmp1572_);
			_tmp1574_ = _tmp1573_;
			_tmp1575_ = vala_data_type_get_actual_type (_tmp1570_, _tmp1574_, NULL, (ValaCodeNode*) self);
			_tmp1576_ = _tmp1575_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1576_);
			_vala_code_node_unref0 (_tmp1576_);
		} else {
			ValaDataType* _tmp1577_;
			ValaDataType* _tmp1578_;
			_tmp1577_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1578_ = _tmp1577_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1578_);
		}
		_tmp1579_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1580_ = _tmp1579_;
		if (VALA_IS_METHOD (_tmp1580_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1581_;
			ValaSymbol* _tmp1582_;
			ValaDataType* _tmp1583_;
			ValaDataType* _tmp1584_;
			gboolean _tmp1591_ = FALSE;
			_tmp1581_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1582_ = _tmp1581_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1582_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1583_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1584_ = _tmp1583_;
			if (_tmp1584_ != NULL) {
				ValaDataType* _tmp1585_;
				ValaDataType* _tmp1586_;
				ValaDataType* _tmp1587_;
				ValaDataType* _tmp1588_;
				gboolean _tmp1589_;
				gboolean _tmp1590_;
				_tmp1585_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1586_ = _tmp1585_;
				_tmp1587_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1588_ = _tmp1587_;
				_tmp1589_ = vala_data_type_get_value_owned (_tmp1588_);
				_tmp1590_ = _tmp1589_;
				vala_data_type_set_value_owned (_tmp1586_, _tmp1590_);
			}
			if (instance) {
				ValaMethod* _tmp1592_;
				ValaSymbol* _tmp1593_;
				ValaSymbol* _tmp1594_;
				_tmp1592_ = method;
				_tmp1593_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1592_);
				_tmp1594_ = _tmp1593_;
				_tmp1591_ = VALA_IS_TYPESYMBOL (_tmp1594_);
			} else {
				_tmp1591_ = FALSE;
			}
			if (_tmp1591_) {
				ValaExpression* _tmp1595_;
				ValaExpression* _tmp1596_;
				ValaMethod* _tmp1597_;
				ValaSymbol* _tmp1598_;
				ValaSymbol* _tmp1599_;
				ValaDataType* _tmp1600_;
				ValaDataType* _tmp1601_;
				ValaExpression* _tmp1602_;
				ValaExpression* _tmp1603_;
				ValaDataType* _tmp1604_;
				ValaDataType* _tmp1605_;
				ValaMethod* _tmp1606_;
				ValaParameter* _tmp1607_;
				ValaParameter* _tmp1608_;
				ValaDataType* _tmp1609_;
				ValaDataType* _tmp1610_;
				gboolean _tmp1611_;
				gboolean _tmp1612_;
				_tmp1595_ = vala_member_access_get_inner (self);
				_tmp1596_ = _tmp1595_;
				_tmp1597_ = method;
				_tmp1598_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1597_);
				_tmp1599_ = _tmp1598_;
				_tmp1600_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1599_);
				_tmp1601_ = _tmp1600_;
				vala_expression_set_target_type (_tmp1596_, _tmp1601_);
				_vala_code_node_unref0 (_tmp1601_);
				_tmp1602_ = vala_member_access_get_inner (self);
				_tmp1603_ = _tmp1602_;
				_tmp1604_ = vala_expression_get_target_type (_tmp1603_);
				_tmp1605_ = _tmp1604_;
				_tmp1606_ = method;
				_tmp1607_ = vala_method_get_this_parameter (_tmp1606_);
				_tmp1608_ = _tmp1607_;
				_tmp1609_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1608_);
				_tmp1610_ = _tmp1609_;
				_tmp1611_ = vala_data_type_get_value_owned (_tmp1610_);
				_tmp1612_ = _tmp1611_;
				vala_data_type_set_value_owned (_tmp1605_, _tmp1612_);
			}
		} else {
			gboolean _tmp1613_ = FALSE;
			gboolean _tmp1614_ = FALSE;
			ValaSymbol* _tmp1615_;
			ValaSymbol* _tmp1616_;
			_tmp1615_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1616_ = _tmp1615_;
			if (VALA_IS_PROPERTY (_tmp1616_)) {
				_tmp1614_ = instance;
			} else {
				_tmp1614_ = FALSE;
			}
			if (_tmp1614_) {
				ValaSymbol* _tmp1617_;
				ValaSymbol* _tmp1618_;
				ValaSymbol* _tmp1619_;
				ValaSymbol* _tmp1620_;
				_tmp1617_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1618_ = _tmp1617_;
				_tmp1619_ = vala_symbol_get_parent_symbol (_tmp1618_);
				_tmp1620_ = _tmp1619_;
				_tmp1613_ = _tmp1620_ != NULL;
			} else {
				_tmp1613_ = FALSE;
			}
			if (_tmp1613_) {
				ValaExpression* _tmp1621_;
				ValaExpression* _tmp1622_;
				ValaSymbol* _tmp1623_;
				ValaSymbol* _tmp1624_;
				ValaSymbol* _tmp1625_;
				ValaSymbol* _tmp1626_;
				ValaDataType* _tmp1627_;
				ValaDataType* _tmp1628_;
				_tmp1621_ = vala_member_access_get_inner (self);
				_tmp1622_ = _tmp1621_;
				_tmp1623_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1624_ = _tmp1623_;
				_tmp1625_ = vala_symbol_get_parent_symbol (_tmp1624_);
				_tmp1626_ = _tmp1625_;
				_tmp1627_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1626_);
				_tmp1628_ = _tmp1627_;
				vala_expression_set_target_type (_tmp1622_, _tmp1628_);
				_vala_code_node_unref0 (_tmp1628_);
			} else {
				gboolean _tmp1629_ = FALSE;
				gboolean _tmp1630_ = FALSE;
				gboolean _tmp1631_ = FALSE;
				ValaSymbol* _tmp1632_;
				ValaSymbol* _tmp1633_;
				_tmp1632_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1633_ = _tmp1632_;
				if (VALA_IS_FIELD (_tmp1633_)) {
					_tmp1631_ = TRUE;
				} else {
					ValaSymbol* _tmp1634_;
					ValaSymbol* _tmp1635_;
					_tmp1634_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1635_ = _tmp1634_;
					_tmp1631_ = VALA_IS_SIGNAL (_tmp1635_);
				}
				if (_tmp1631_) {
					_tmp1630_ = instance;
				} else {
					_tmp1630_ = FALSE;
				}
				if (_tmp1630_) {
					ValaSymbol* _tmp1636_;
					ValaSymbol* _tmp1637_;
					ValaSymbol* _tmp1638_;
					ValaSymbol* _tmp1639_;
					_tmp1636_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1637_ = _tmp1636_;
					_tmp1638_ = vala_symbol_get_parent_symbol (_tmp1637_);
					_tmp1639_ = _tmp1638_;
					_tmp1629_ = _tmp1639_ != NULL;
				} else {
					_tmp1629_ = FALSE;
				}
				if (_tmp1629_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1640_;
					ValaSymbol* _tmp1641_;
					ValaSymbol* _tmp1642_;
					ValaSymbol* _tmp1643_;
					ValaDataType* _tmp1644_;
					ValaExpression* _tmp1645_;
					ValaExpression* _tmp1646_;
					ValaDataType* _tmp1647_;
					ValaExpression* _tmp1648_;
					ValaExpression* _tmp1649_;
					ValaDataType* _tmp1650_;
					ValaDataType* _tmp1651_;
					ValaDataType* _tmp1652_;
					ValaDataType* _tmp1653_;
					_tmp1640_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1641_ = _tmp1640_;
					_tmp1642_ = vala_symbol_get_parent_symbol (_tmp1641_);
					_tmp1643_ = _tmp1642_;
					_tmp1644_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1643_);
					parent_type = _tmp1644_;
					_tmp1645_ = vala_member_access_get_inner (self);
					_tmp1646_ = _tmp1645_;
					_tmp1647_ = parent_type;
					_tmp1648_ = vala_member_access_get_inner (self);
					_tmp1649_ = _tmp1648_;
					_tmp1650_ = vala_expression_get_value_type (_tmp1649_);
					_tmp1651_ = _tmp1650_;
					_tmp1652_ = vala_data_type_get_actual_type (_tmp1647_, _tmp1651_, NULL, (ValaCodeNode*) self);
					_tmp1653_ = _tmp1652_;
					vala_expression_set_target_type (_tmp1646_, _tmp1653_);
					_vala_code_node_unref0 (_tmp1653_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
	}
	_tmp1654_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1655_ = _tmp1654_;
	if (_tmp1655_ != NULL) {
		ValaDataType* _tmp1656_;
		ValaDataType* _tmp1657_;
		_tmp1656_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1657_ = _tmp1656_;
		vala_code_node_check ((ValaCodeNode*) _tmp1657_, context);
	}
	_tmp1658_ = self->priv->_tainted_access;
	if (!_tmp1658_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1659_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1660_ = _tmp1659_;
	result = !_tmp1660_;
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	gboolean _tmp93_ = FALSE;
	ValaSymbol* _tmp94_;
	ValaSymbol* _tmp95_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_DELEGATE_TARGET_FIELD (_tmp85_)) {
		_tmp83_ = TRUE;
	} else {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp83_ = VALA_IS_DELEGATE_DESTROY_FIELD (_tmp87_);
	}
	if (_tmp83_) {
		ValaExpression* _tmp88_;
		ValaExpression* _tmp89_;
		ValaMemberAccess* _tmp90_;
		_tmp88_ = vala_member_access_get_inner (self);
		_tmp89_ = _tmp88_;
		vala_expression_set_lvalue (_tmp89_, TRUE);
		_tmp90_ = ma;
		if (_tmp90_ != NULL) {
			ValaMemberAccess* _tmp91_;
			ValaMemberAccess* _tmp92_;
			_tmp91_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp91_, TRUE);
			_tmp92_ = ma;
			vala_member_access_check_lvalue_access (_tmp92_);
		}
	}
	_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp95_ = _tmp94_;
	if (VALA_IS_METHOD (_tmp95_)) {
		ValaSymbol* _tmp96_;
		ValaSymbol* _tmp97_;
		ValaAttribute* _tmp98_;
		_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp97_ = _tmp96_;
		_tmp98_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp93_ = _tmp98_ != NULL;
	} else {
		_tmp93_ = FALSE;
	}
	if (_tmp93_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp99_;
		ValaSymbol* _tmp100_;
		ValaSymbol* _tmp101_;
		ValaSymbol* _tmp102_;
		gboolean _tmp103_ = FALSE;
		gboolean _tmp104_ = FALSE;
		ValaClass* _tmp105_;
		_tmp99_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp100_ = _tmp99_;
		_tmp101_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_METHOD, ValaMethod));
		_tmp102_ = _tmp101_;
		cl = VALA_IS_CLASS (_tmp102_) ? ((ValaClass*) _tmp102_) : NULL;
		_tmp105_ = cl;
		if (_tmp105_ != NULL) {
			ValaClass* _tmp106_;
			gboolean _tmp107_;
			gboolean _tmp108_;
			_tmp106_ = cl;
			_tmp107_ = vala_class_get_is_compact (_tmp106_);
			_tmp108_ = _tmp107_;
			_tmp104_ = _tmp108_;
		} else {
			_tmp104_ = FALSE;
		}
		if (_tmp104_) {
			ValaMemberAccess* _tmp109_;
			_tmp109_ = ma;
			_tmp103_ = _tmp109_ != NULL;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			ValaMemberAccess* _tmp110_;
			ValaMemberAccess* _tmp111_;
			_tmp110_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp110_, TRUE);
			_tmp111_ = ma;
			vala_member_access_check_lvalue_access (_tmp111_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result = 0;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

