/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaObjectCreationExpressionPrivate {
	gboolean _is_yield_expression;
	gboolean _is_chainup;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
	ValaMemberAccess* _member_name;
};

static gint ValaObjectCreationExpression_private_offset;
static gpointer vala_object_creation_expression_parent_class = NULL;

static void vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                              ValaExpression* old_node,
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                        ValaDataType* old_type,
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base,
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                           ValaCollection* collection,
                                                           ValaSourceReference* source_reference);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                              ValaCollection* collection);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);
static GType vala_object_creation_expression_get_type_once (void);

static inline gpointer
vala_object_creation_expression_get_instance_private (ValaObjectCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaObjectCreationExpression_private_offset);
}

ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
	_tmp1_ = self->priv->_member_name;
	if (_tmp1_ != NULL) {
		ValaMemberAccess* _tmp2_;
		_tmp2_ = self->priv->_member_name;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

gboolean
vala_object_creation_expression_get_is_yield_expression (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_yield_expression;
	return result;
}

void
vala_object_creation_expression_set_is_yield_expression (ValaObjectCreationExpression* self,
                                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}

gboolean
vala_object_creation_expression_get_is_chainup (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chainup;
	return result;
}

void
vala_object_creation_expression_set_is_chainup (ValaObjectCreationExpression* self,
                                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}

gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_struct_creation;
	return result;
}

void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}

/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type,
                                           ValaMemberAccess* member_name,
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}

ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name,
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self,
                                              ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
ValaList*
vala_object_creation_expression_get_argument_list (ValaObjectCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self,
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}

/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _arg_index = 0;
		_tmp8_ = self->priv->argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_arg_list = _tmp9_;
		_tmp10_ = _arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_arg_size = _tmp12_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaExpression* arg = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaExpression* _tmp17_;
			_arg_index = _arg_index + 1;
			_tmp13_ = _arg_index;
			_tmp14_ = _arg_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _arg_list;
			_tmp16_ = vala_list_get (_tmp15_, _arg_index);
			arg = (ValaExpression*) _tmp16_;
			_tmp17_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp17_, visitor);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp18_;
		ValaList* _tmp19_;
		gint _init_size = 0;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _init_index = 0;
		_tmp18_ = self->priv->object_initializer;
		_tmp19_ = _vala_iterable_ref0 (_tmp18_);
		_init_list = _tmp19_;
		_tmp20_ = _init_list;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_init_size = _tmp22_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaMemberInitializer* _tmp27_;
			_init_index = _init_index + 1;
			_tmp23_ = _init_index;
			_tmp24_ = _init_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _init_list;
			_tmp26_ = vala_list_get (_tmp25_, _init_index);
			init = (ValaMemberInitializer*) _tmp26_;
			_tmp27_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp27_, visitor);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}

static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                         ValaExpression* old_node,
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	if (index >= 0) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->argument_list;
		vala_list_set (_tmp1_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* _tmp2_;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_object_creation_expression_get_member_name (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaMemberAccess* _tmp3_;
		ValaMemberAccess* _tmp4_;
		_tmp3_ = vala_object_creation_expression_get_member_name (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		gint _arg_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _arg_index = 0;
		_tmp5_ = self->priv->argument_list;
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_arg_list = _tmp6_;
		_tmp7_ = _arg_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_arg_size = _tmp9_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			ValaExpression* arg = NULL;
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			_arg_index = _arg_index + 1;
			_tmp10_ = _arg_index;
			_tmp11_ = _arg_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _arg_list;
			_tmp13_ = vala_list_get (_tmp12_, _arg_index);
			arg = (ValaExpression*) _tmp13_;
			_tmp14_ = arg;
			if (!vala_expression_is_accessible (_tmp14_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp15_;
		ValaList* _tmp16_;
		gint _init_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _init_index = 0;
		_tmp15_ = self->priv->object_initializer;
		_tmp16_ = _vala_iterable_ref0 (_tmp15_);
		_init_list = _tmp16_;
		_tmp17_ = _init_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_init_size = _tmp19_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp22_;
			gpointer _tmp23_;
			ValaMemberInitializer* _tmp24_;
			ValaExpression* _tmp25_;
			ValaExpression* _tmp26_;
			_init_index = _init_index + 1;
			_tmp20_ = _init_index;
			_tmp21_ = _init_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _init_list;
			_tmp23_ = vala_list_get (_tmp22_, _init_index);
			init = (ValaMemberInitializer*) _tmp23_;
			_tmp24_ = init;
			_tmp25_ = vala_member_initializer_get_initializer (_tmp24_);
			_tmp26_ = _tmp25_;
			if (!vala_expression_is_accessible (_tmp26_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				_vala_iterable_unref0 (_init_list);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	result = TRUE;
	return result;
}

static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                   ValaDataType* old_type,
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}

static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaTypeSymbol* type = NULL;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp119_;
	ValaDataType* _tmp120_;
	ValaDataType* _tmp121_;
	ValaDataType* _tmp122_;
	ValaDataType* _tmp123_;
	ValaDataType* _tmp124_;
	ValaTypeSymbol* _tmp125_;
	ValaDataType* _tmp239_;
	ValaDataType* _tmp240_;
	gboolean _tmp241_ = FALSE;
	ValaSymbol* _tmp242_;
	ValaSymbol* _tmp243_;
	ValaSymbol* _tmp254_;
	ValaSymbol* _tmp255_;
	ValaTypeSymbol* _tmp513_;
	gboolean _tmp514_;
	gboolean _tmp515_;
	gboolean _tmp534_;
	gboolean _tmp535_;
	gboolean _tmp591_;
	gboolean _tmp592_;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp7_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp8_ = vala_object_creation_expression_get_type_reference (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaMemberAccess* _tmp10_;
		ValaMemberAccess* _tmp11_;
		ValaMemberAccess* _tmp14_;
		ValaMemberAccess* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* constructor_sym = NULL;
		ValaMemberAccess* _tmp18_;
		ValaMemberAccess* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* type_sym = NULL;
		ValaMemberAccess* _tmp23_;
		ValaMemberAccess* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaList* type_args = NULL;
		ValaMemberAccess* _tmp28_;
		ValaMemberAccess* _tmp29_;
		ValaList* _tmp30_;
		ValaList* _tmp31_;
		ValaSymbol* _tmp32_;
		ValaSymbol* _tmp56_;
		_tmp10_ = vala_object_creation_expression_get_member_name (self);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp13_, "Incomplete object creation expression");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp14_ = vala_object_creation_expression_get_member_name (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp18_ = vala_object_creation_expression_get_member_name (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 (_tmp21_);
		constructor_sym = _tmp22_;
		_tmp23_ = vala_object_creation_expression_get_member_name (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _vala_code_node_ref0 (_tmp26_);
		type_sym = _tmp27_;
		_tmp28_ = vala_object_creation_expression_get_member_name (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_member_access_get_type_arguments (_tmp29_);
		_tmp31_ = _vala_iterable_ref0 (_tmp30_);
		type_args = _tmp31_;
		_tmp32_ = constructor_sym;
		if (VALA_IS_METHOD (_tmp32_)) {
			ValaSymbol* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaMethod* constructor = NULL;
			ValaSymbol* _tmp37_;
			ValaMethod* _tmp38_;
			ValaSymbol* _tmp39_;
			ValaMethod* _tmp47_;
			ValaMemberAccess* ma = NULL;
			ValaMemberAccess* _tmp48_;
			ValaMemberAccess* _tmp49_;
			ValaExpression* _tmp50_;
			ValaExpression* _tmp51_;
			ValaMemberAccess* _tmp52_;
			_tmp33_ = constructor_sym;
			_tmp34_ = vala_symbol_get_parent_symbol (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = _vala_code_node_ref0 (_tmp35_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp36_;
			_tmp37_ = constructor_sym;
			_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_METHOD, ValaMethod));
			constructor = _tmp38_;
			_tmp39_ = constructor_sym;
			if (!VALA_IS_CREATION_METHOD (_tmp39_)) {
				ValaSourceReference* _tmp40_;
				ValaSourceReference* _tmp41_;
				ValaMethod* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp41_ = _tmp40_;
				_tmp42_ = constructor;
				_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = g_strdup_printf ("`%s' is not a creation method", _tmp44_);
				_tmp46_ = _tmp45_;
				vala_report_error (_tmp41_, _tmp46_);
				_g_free0 (_tmp46_);
				_g_free0 (_tmp44_);
				result = FALSE;
				_vala_code_node_unref0 (constructor);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp47_ = constructor;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp47_);
			_tmp48_ = vala_object_creation_expression_get_member_name (self);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_member_access_get_inner (_tmp49_);
			_tmp51_ = _tmp50_;
			ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
			_tmp52_ = ma;
			if (_tmp52_ != NULL) {
				ValaMemberAccess* _tmp53_;
				ValaList* _tmp54_;
				ValaList* _tmp55_;
				_tmp53_ = ma;
				_tmp54_ = vala_member_access_get_type_arguments (_tmp53_);
				_tmp55_ = _vala_iterable_ref0 (_tmp54_);
				_vala_iterable_unref0 (type_args);
				type_args = _tmp55_;
			}
			_vala_code_node_unref0 (constructor);
		}
		_tmp56_ = type_sym;
		if (VALA_IS_CLASS (_tmp56_)) {
			ValaSymbol* _tmp57_;
			ValaTypeSymbol* _tmp58_;
			ValaTypeSymbol* _tmp59_;
			gboolean _tmp60_;
			gboolean _tmp61_;
			_tmp57_ = type_sym;
			_tmp58_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp58_;
			_tmp59_ = type;
			_tmp60_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_CLASS, ValaClass));
			_tmp61_ = _tmp60_;
			if (_tmp61_) {
				ValaSourceReference* _tmp62_;
				ValaSourceReference* _tmp63_;
				ValaErrorType* _tmp64_;
				ValaErrorType* _tmp65_;
				_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp63_ = _tmp62_;
				_tmp64_ = vala_error_type_new (NULL, NULL, _tmp63_);
				_tmp65_ = _tmp64_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp65_);
				_vala_code_node_unref0 (_tmp65_);
			} else {
				ValaTypeSymbol* _tmp66_;
				ValaObjectType* _tmp67_;
				ValaObjectType* _tmp68_;
				ValaDataType* _tmp69_;
				ValaDataType* _tmp70_;
				ValaSourceReference* _tmp71_;
				ValaSourceReference* _tmp72_;
				_tmp66_ = type;
				_tmp67_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, VALA_TYPE_CLASS, ValaClass));
				_tmp68_ = _tmp67_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp68_);
				_vala_code_node_unref0 (_tmp68_);
				_tmp69_ = vala_object_creation_expression_get_type_reference (self);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp72_ = _tmp71_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp70_, _tmp72_);
			}
		} else {
			ValaSymbol* _tmp73_;
			_tmp73_ = type_sym;
			if (VALA_IS_STRUCT (_tmp73_)) {
				ValaSymbol* _tmp74_;
				ValaTypeSymbol* _tmp75_;
				ValaTypeSymbol* _tmp76_;
				ValaStructValueType* _tmp77_;
				ValaStructValueType* _tmp78_;
				ValaDataType* _tmp79_;
				ValaDataType* _tmp80_;
				ValaSourceReference* _tmp81_;
				ValaSourceReference* _tmp82_;
				_tmp74_ = type_sym;
				_tmp75_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp75_;
				_tmp76_ = type;
				_tmp77_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALA_TYPE_STRUCT, ValaStruct));
				_tmp78_ = _tmp77_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp78_);
				_vala_code_node_unref0 (_tmp78_);
				_tmp79_ = vala_object_creation_expression_get_type_reference (self);
				_tmp80_ = _tmp79_;
				_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp82_ = _tmp81_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp80_, _tmp82_);
			} else {
				ValaSymbol* _tmp83_;
				_tmp83_ = type_sym;
				if (VALA_IS_ERROR_CODE (_tmp83_)) {
					ValaSymbol* _tmp84_;
					ValaTypeSymbol* _tmp85_;
					ValaSymbol* _tmp86_;
					ValaSymbol* _tmp87_;
					ValaSymbol* _tmp88_;
					ValaSymbol* _tmp89_;
					ValaSourceReference* _tmp90_;
					ValaSourceReference* _tmp91_;
					ValaErrorType* _tmp92_;
					ValaErrorType* _tmp93_;
					ValaSymbol* _tmp94_;
					_tmp84_ = type_sym;
					_tmp85_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
					_vala_code_node_unref0 (type);
					type = _tmp85_;
					_tmp86_ = type_sym;
					_tmp87_ = vala_symbol_get_parent_symbol (_tmp86_);
					_tmp88_ = _tmp87_;
					_tmp89_ = type_sym;
					_tmp90_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp91_ = _tmp90_;
					_tmp92_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp91_);
					_tmp93_ = _tmp92_;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp93_);
					_vala_code_node_unref0 (_tmp93_);
					_tmp94_ = type_sym;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp94_);
				} else {
					ValaSourceReference* _tmp95_;
					ValaSourceReference* _tmp96_;
					ValaSymbol* _tmp97_;
					gchar* _tmp98_;
					gchar* _tmp99_;
					gchar* _tmp100_;
					gchar* _tmp101_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp95_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp96_ = _tmp95_;
					_tmp97_ = type_sym;
					_tmp98_ = vala_symbol_get_full_name (_tmp97_);
					_tmp99_ = _tmp98_;
					_tmp100_ = g_strdup_printf ("`%s' is not a class, struct, or error code", _tmp99_);
					_tmp101_ = _tmp100_;
					vala_report_error (_tmp96_, _tmp101_);
					_g_free0 (_tmp101_);
					_g_free0 (_tmp99_);
					result = FALSE;
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
			}
		}
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp102_;
			ValaList* _tmp103_;
			gint _type_arg_size = 0;
			ValaList* _tmp104_;
			gint _tmp105_;
			gint _tmp106_;
			gint _type_arg_index = 0;
			_tmp102_ = type_args;
			_tmp103_ = _vala_iterable_ref0 (_tmp102_);
			_type_arg_list = _tmp103_;
			_tmp104_ = _type_arg_list;
			_tmp105_ = vala_collection_get_size ((ValaCollection*) _tmp104_);
			_tmp106_ = _tmp105_;
			_type_arg_size = _tmp106_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp107_;
				gint _tmp108_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp109_;
				gpointer _tmp110_;
				ValaDataType* _tmp111_;
				ValaDataType* _tmp112_;
				ValaDataType* _tmp113_;
				_type_arg_index = _type_arg_index + 1;
				_tmp107_ = _type_arg_index;
				_tmp108_ = _type_arg_size;
				if (!(_tmp107_ < _tmp108_)) {
					break;
				}
				_tmp109_ = _type_arg_list;
				_tmp110_ = vala_list_get (_tmp109_, _type_arg_index);
				type_arg = (ValaDataType*) _tmp110_;
				_tmp111_ = vala_object_creation_expression_get_type_reference (self);
				_tmp112_ = _tmp111_;
				_tmp113_ = type_arg;
				vala_data_type_add_type_argument (_tmp112_, _tmp113_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
	} else {
		ValaDataType* _tmp114_;
		ValaDataType* _tmp115_;
		ValaTypeSymbol* _tmp116_;
		ValaTypeSymbol* _tmp117_;
		ValaTypeSymbol* _tmp118_;
		_tmp114_ = vala_object_creation_expression_get_type_reference (self);
		_tmp115_ = _tmp114_;
		_tmp116_ = vala_data_type_get_type_symbol (_tmp115_);
		_tmp117_ = _tmp116_;
		_tmp118_ = _vala_code_node_ref0 (_tmp117_);
		_vala_code_node_unref0 (type);
		type = _tmp118_;
	}
	_tmp119_ = vala_object_creation_expression_get_type_reference (self);
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_data_type_copy (_tmp120_);
	_tmp122_ = _tmp121_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp122_);
	_vala_code_node_unref0 (_tmp122_);
	_tmp123_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp124_ = _tmp123_;
	vala_data_type_set_value_owned (_tmp124_, TRUE);
	_tmp125_ = type;
	if (VALA_IS_CLASS (_tmp125_)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp126_;
		ValaClass* _tmp127_;
		gboolean _tmp128_;
		ValaClass* _tmp131_;
		gboolean _tmp132_;
		gboolean _tmp133_;
		ValaSymbol* _tmp141_;
		ValaSymbol* _tmp142_;
		gboolean _tmp163_ = FALSE;
		ValaSymbol* _tmp164_;
		ValaSymbol* _tmp165_;
		_tmp126_ = type;
		_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp127_;
		_tmp128_ = self->priv->_struct_creation;
		if (_tmp128_) {
			ValaSourceReference* _tmp129_;
			ValaSourceReference* _tmp130_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp129_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp130_ = _tmp129_;
			vala_report_error (_tmp130_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp131_ = cl;
		_tmp132_ = vala_class_get_is_abstract (_tmp131_);
		_tmp133_ = _tmp132_;
		if (_tmp133_) {
			ValaSourceReference* _tmp134_;
			ValaSourceReference* _tmp135_;
			ValaClass* _tmp136_;
			gchar* _tmp137_;
			gchar* _tmp138_;
			gchar* _tmp139_;
			gchar* _tmp140_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp134_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp135_ = _tmp134_;
			_tmp136_ = cl;
			_tmp137_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp136_);
			_tmp138_ = _tmp137_;
			_tmp139_ = g_strdup_printf ("Can't create instance of abstract class `%s'", _tmp138_);
			_tmp140_ = _tmp139_;
			vala_report_error (_tmp135_, _tmp140_);
			_g_free0 (_tmp140_);
			_g_free0 (_tmp138_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp141_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp142_ = _tmp141_;
		if (_tmp142_ == NULL) {
			ValaClass* _tmp143_;
			ValaCreationMethod* _tmp144_;
			ValaCreationMethod* _tmp145_;
			ValaSymbol* _tmp146_;
			ValaSymbol* _tmp147_;
			ValaSymbol* _tmp155_;
			ValaSymbol* _tmp156_;
			ValaSymbol* _tmp157_;
			ValaSymbol* _tmp158_;
			ValaVersionAttribute* _tmp159_;
			ValaVersionAttribute* _tmp160_;
			ValaSourceReference* _tmp161_;
			ValaSourceReference* _tmp162_;
			_tmp143_ = cl;
			_tmp144_ = vala_class_get_default_construction_method (_tmp143_);
			_tmp145_ = _tmp144_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp145_);
			_tmp146_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp147_ = _tmp146_;
			if (_tmp147_ == NULL) {
				ValaSourceReference* _tmp148_;
				ValaSourceReference* _tmp149_;
				ValaClass* _tmp150_;
				gchar* _tmp151_;
				gchar* _tmp152_;
				gchar* _tmp153_;
				gchar* _tmp154_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp149_ = _tmp148_;
				_tmp150_ = cl;
				_tmp151_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp150_);
				_tmp152_ = _tmp151_;
				_tmp153_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp152_);
				_tmp154_ = _tmp153_;
				vala_report_error (_tmp149_, _tmp154_);
				_g_free0 (_tmp154_);
				_g_free0 (_tmp152_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp155_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp156_ = _tmp155_;
			vala_symbol_set_used (_tmp156_, TRUE);
			_tmp157_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp158_ = _tmp157_;
			_tmp159_ = vala_symbol_get_version (_tmp158_);
			_tmp160_ = _tmp159_;
			_tmp161_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp162_ = _tmp161_;
			vala_version_attribute_check (_tmp160_, _tmp162_);
		}
		_tmp164_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp165_ = _tmp164_;
		if (_tmp165_ != NULL) {
			gboolean _tmp166_ = FALSE;
			ValaSymbol* _tmp167_;
			ValaSymbol* _tmp168_;
			ValaSymbolAccessibility _tmp169_;
			ValaSymbolAccessibility _tmp170_;
			_tmp167_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp168_ = _tmp167_;
			_tmp169_ = vala_symbol_get_access (_tmp168_);
			_tmp170_ = _tmp169_;
			if (_tmp170_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp166_ = TRUE;
			} else {
				ValaSymbol* _tmp171_;
				ValaSymbol* _tmp172_;
				ValaSymbolAccessibility _tmp173_;
				ValaSymbolAccessibility _tmp174_;
				_tmp171_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp172_ = _tmp171_;
				_tmp173_ = vala_symbol_get_access (_tmp172_);
				_tmp174_ = _tmp173_;
				_tmp166_ = _tmp174_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp163_ = _tmp166_;
		} else {
			_tmp163_ = FALSE;
		}
		if (_tmp163_) {
			gboolean in_target_type = FALSE;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp175_;
				ValaSemanticAnalyzer* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp178_;
				ValaSymbol* _tmp179_;
				_tmp175_ = vala_code_context_get_analyzer (context);
				_tmp176_ = _tmp175_;
				_tmp177_ = vala_semantic_analyzer_get_current_symbol (_tmp176_);
				_tmp178_ = _tmp177_;
				_tmp179_ = _vala_code_node_ref0 (_tmp178_);
				this_symbol = _tmp179_;
				{
					gboolean _tmp180_ = FALSE;
					_tmp180_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp185_;
						ValaSymbol* _tmp186_;
						ValaClass* _tmp187_;
						if (!_tmp180_) {
							ValaSymbol* _tmp181_;
							ValaSymbol* _tmp182_;
							ValaSymbol* _tmp183_;
							ValaSymbol* _tmp184_;
							_tmp181_ = this_symbol;
							_tmp182_ = vala_symbol_get_parent_symbol (_tmp181_);
							_tmp183_ = _tmp182_;
							_tmp184_ = _vala_code_node_ref0 (_tmp183_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp184_;
						}
						_tmp180_ = FALSE;
						_tmp185_ = this_symbol;
						if (!(_tmp185_ != NULL)) {
							break;
						}
						_tmp186_ = this_symbol;
						_tmp187_ = cl;
						if (_tmp186_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp187_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp188_;
				ValaSourceReference* _tmp189_;
				ValaSymbol* _tmp190_;
				ValaSymbol* _tmp191_;
				gchar* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				gchar* _tmp195_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp188_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp189_ = _tmp188_;
				_tmp190_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp191_ = _tmp190_;
				_tmp192_ = vala_symbol_get_full_name (_tmp191_);
				_tmp193_ = _tmp192_;
				_tmp194_ = g_strdup_printf ("Access to non-public constructor `%s' denied", _tmp193_);
				_tmp195_ = _tmp194_;
				vala_report_error (_tmp189_, _tmp195_);
				_g_free0 (_tmp195_);
				_g_free0 (_tmp193_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp196_;
			ValaClass* _tmp197_;
			gchar* _tmp198_;
			gchar* _tmp199_;
			gboolean _tmp200_;
			ValaClass* _tmp203_;
			ValaClass* _tmp204_;
			ValaClass* _tmp205_;
			ValaClass* _tmp206_;
			_tmp196_ = cl;
			if (!(_tmp196_ != NULL)) {
				break;
			}
			_tmp197_ = cl;
			_tmp198_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp197_, "CCode", "ref_sink_function", NULL);
			_tmp199_ = _tmp198_;
			_tmp200_ = _tmp199_ != NULL;
			_g_free0 (_tmp199_);
			if (_tmp200_) {
				ValaDataType* _tmp201_;
				ValaDataType* _tmp202_;
				_tmp201_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp202_ = _tmp201_;
				vala_data_type_set_floating_reference (_tmp202_, TRUE);
				break;
			}
			_tmp203_ = cl;
			_tmp204_ = vala_class_get_base_class (_tmp203_);
			_tmp205_ = _tmp204_;
			_tmp206_ = _vala_code_node_ref0 (_tmp205_);
			_vala_code_node_unref0 (cl);
			cl = _tmp206_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp207_;
		_tmp207_ = type;
		if (VALA_IS_STRUCT (_tmp207_)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp208_;
			ValaStruct* _tmp209_;
			gboolean _tmp210_ = FALSE;
			gboolean _tmp211_;
			ValaSymbol* _tmp216_;
			ValaSymbol* _tmp217_;
			gboolean _tmp221_ = FALSE;
			gboolean _tmp222_ = FALSE;
			gboolean _tmp223_ = FALSE;
			ValaProfile _tmp224_;
			ValaProfile _tmp225_;
			_tmp208_ = type;
			_tmp209_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp208_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp209_;
			_tmp211_ = self->priv->_struct_creation;
			if (!_tmp211_) {
				gboolean _tmp212_;
				gboolean _tmp213_;
				_tmp212_ = vala_code_context_get_deprecated (context);
				_tmp213_ = _tmp212_;
				_tmp210_ = !_tmp213_;
			} else {
				_tmp210_ = FALSE;
			}
			if (_tmp210_) {
				ValaSourceReference* _tmp214_;
				ValaSourceReference* _tmp215_;
				_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp215_ = _tmp214_;
				vala_report_warning (_tmp215_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp216_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp217_ = _tmp216_;
			if (_tmp217_ == NULL) {
				ValaStruct* _tmp218_;
				ValaCreationMethod* _tmp219_;
				ValaCreationMethod* _tmp220_;
				_tmp218_ = st;
				_tmp219_ = vala_struct_get_default_construction_method (_tmp218_);
				_tmp220_ = _tmp219_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp220_);
			}
			_tmp224_ = vala_code_context_get_profile (context);
			_tmp225_ = _tmp224_;
			if (_tmp225_ == VALA_PROFILE_GOBJECT) {
				ValaStruct* _tmp226_;
				_tmp226_ = st;
				_tmp223_ = vala_struct_is_simple_type (_tmp226_);
			} else {
				_tmp223_ = FALSE;
			}
			if (_tmp223_) {
				ValaSymbol* _tmp227_;
				ValaSymbol* _tmp228_;
				_tmp227_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp228_ = _tmp227_;
				_tmp222_ = _tmp228_ == NULL;
			} else {
				_tmp222_ = FALSE;
			}
			if (_tmp222_) {
				ValaList* _tmp229_;
				gint _tmp230_;
				gint _tmp231_;
				_tmp229_ = self->priv->object_initializer;
				_tmp230_ = vala_collection_get_size ((ValaCollection*) _tmp229_);
				_tmp231_ = _tmp230_;
				_tmp221_ = _tmp231_ == 0;
			} else {
				_tmp221_ = FALSE;
			}
			if (_tmp221_) {
				ValaSourceReference* _tmp232_;
				ValaSourceReference* _tmp233_;
				ValaStruct* _tmp234_;
				gchar* _tmp235_;
				gchar* _tmp236_;
				gchar* _tmp237_;
				gchar* _tmp238_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp232_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp233_ = _tmp232_;
				_tmp234_ = st;
				_tmp235_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp234_);
				_tmp236_ = _tmp235_;
				_tmp237_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp236_);
				_tmp238_ = _tmp237_;
				vala_report_error (_tmp233_, _tmp238_);
				_g_free0 (_tmp238_);
				_g_free0 (_tmp236_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	_tmp239_ = vala_object_creation_expression_get_type_reference (self);
	_tmp240_ = _tmp239_;
	if (!vala_data_type_check_type_arguments (_tmp240_, context, FALSE)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp242_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp243_ = _tmp242_;
	if (_tmp243_ == NULL) {
		ValaList* _tmp244_;
		gint _tmp245_;
		gint _tmp246_;
		_tmp244_ = self->priv->argument_list;
		_tmp245_ = vala_collection_get_size ((ValaCollection*) _tmp244_);
		_tmp246_ = _tmp245_;
		_tmp241_ = _tmp246_ != 0;
	} else {
		_tmp241_ = FALSE;
	}
	if (_tmp241_) {
		ValaSourceReference* _tmp247_;
		ValaSourceReference* _tmp248_;
		ValaTypeSymbol* _tmp249_;
		gchar* _tmp250_;
		gchar* _tmp251_;
		gchar* _tmp252_;
		gchar* _tmp253_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp247_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp248_ = _tmp247_;
		_tmp249_ = type;
		_tmp250_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp249_);
		_tmp251_ = _tmp250_;
		_tmp252_ = g_strdup_printf ("No arguments allowed when constructing type `%s'", _tmp251_);
		_tmp253_ = _tmp252_;
		vala_report_error (_tmp248_, _tmp253_);
		_g_free0 (_tmp253_);
		_g_free0 (_tmp251_);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp254_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp255_ = _tmp254_;
	if (VALA_IS_METHOD (_tmp255_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp256_;
		ValaSymbol* _tmp257_;
		ValaMethod* _tmp258_;
		gboolean _tmp259_;
		ValaExpression* last_arg = NULL;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp284_;
		ValaIterator* _tmp285_;
		ValaMethod* _tmp337_;
		gboolean _tmp338_;
		gboolean _tmp339_;
		ValaSemanticAnalyzer* _tmp404_;
		ValaSemanticAnalyzer* _tmp405_;
		ValaMethod* _tmp406_;
		ValaMethodType* _tmp407_;
		ValaMethodType* _tmp408_;
		ValaMethod* _tmp409_;
		ValaList* _tmp410_;
		ValaList* _tmp411_;
		_tmp256_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp257_ = _tmp256_;
		_tmp258_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp257_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp258_;
		_tmp259_ = self->priv->_is_yield_expression;
		if (_tmp259_) {
			ValaMethod* _tmp260_;
			gboolean _tmp261_;
			gboolean _tmp262_;
			gboolean _tmp265_ = FALSE;
			ValaSemanticAnalyzer* _tmp266_;
			ValaSemanticAnalyzer* _tmp267_;
			ValaMethod* _tmp268_;
			ValaMethod* _tmp269_;
			_tmp260_ = m;
			_tmp261_ = vala_method_get_coroutine (_tmp260_);
			_tmp262_ = _tmp261_;
			if (!_tmp262_) {
				ValaSourceReference* _tmp263_;
				ValaSourceReference* _tmp264_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp263_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp264_ = _tmp263_;
				vala_report_error (_tmp264_, "yield expression requires async method");
			}
			_tmp266_ = vala_code_context_get_analyzer (context);
			_tmp267_ = _tmp266_;
			_tmp268_ = vala_semantic_analyzer_get_current_method (_tmp267_);
			_tmp269_ = _tmp268_;
			if (_tmp269_ == NULL) {
				_tmp265_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp270_;
				ValaSemanticAnalyzer* _tmp271_;
				ValaMethod* _tmp272_;
				ValaMethod* _tmp273_;
				gboolean _tmp274_;
				gboolean _tmp275_;
				_tmp270_ = vala_code_context_get_analyzer (context);
				_tmp271_ = _tmp270_;
				_tmp272_ = vala_semantic_analyzer_get_current_method (_tmp271_);
				_tmp273_ = _tmp272_;
				_tmp274_ = vala_method_get_coroutine (_tmp273_);
				_tmp275_ = _tmp274_;
				_tmp265_ = !_tmp275_;
			}
			if (_tmp265_) {
				ValaSourceReference* _tmp276_;
				ValaSourceReference* _tmp277_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp276_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp277_ = _tmp276_;
				vala_report_error (_tmp277_, "yield expression not available outside async method");
			}
		} else {
			ValaMethod* _tmp278_;
			_tmp278_ = m;
			if (VALA_IS_CREATION_METHOD (_tmp278_)) {
				ValaMethod* _tmp279_;
				gboolean _tmp280_;
				gboolean _tmp281_;
				_tmp279_ = m;
				_tmp280_ = vala_method_get_coroutine (_tmp279_);
				_tmp281_ = _tmp280_;
				if (_tmp281_) {
					ValaSourceReference* _tmp282_;
					ValaSourceReference* _tmp283_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp282_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp283_ = _tmp282_;
					vala_report_error (_tmp283_, "missing `yield' before async creation expression");
				}
			}
		}
		last_arg = NULL;
		_tmp284_ = self->priv->argument_list;
		_tmp285_ = vala_iterable_iterator ((ValaIterable*) _tmp284_);
		arg_it = _tmp285_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp286_;
			ValaList* _tmp287_;
			ValaList* _tmp288_;
			gint _param_size = 0;
			ValaList* _tmp289_;
			gint _tmp290_;
			gint _tmp291_;
			gint _param_index = 0;
			_tmp286_ = m;
			_tmp287_ = vala_callable_get_parameters ((ValaCallable*) _tmp286_);
			_tmp288_ = _vala_iterable_ref0 (_tmp287_);
			_param_list = _tmp288_;
			_tmp289_ = _param_list;
			_tmp290_ = vala_collection_get_size ((ValaCollection*) _tmp289_);
			_tmp291_ = _tmp290_;
			_param_size = _tmp291_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp292_;
				gint _tmp293_;
				ValaParameter* param = NULL;
				ValaList* _tmp294_;
				gpointer _tmp295_;
				ValaParameter* _tmp296_;
				ValaParameter* _tmp297_;
				gboolean _tmp298_;
				gboolean _tmp299_;
				ValaParameter* _tmp300_;
				gboolean _tmp301_;
				gboolean _tmp302_;
				ValaIterator* _tmp320_;
				_param_index = _param_index + 1;
				_tmp292_ = _param_index;
				_tmp293_ = _param_size;
				if (!(_tmp292_ < _tmp293_)) {
					break;
				}
				_tmp294_ = _param_list;
				_tmp295_ = vala_list_get (_tmp294_, _param_index);
				param = (ValaParameter*) _tmp295_;
				_tmp296_ = param;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp296_, context)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp297_ = param;
				_tmp298_ = vala_parameter_get_ellipsis (_tmp297_);
				_tmp299_ = _tmp298_;
				if (_tmp299_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp300_ = param;
				_tmp301_ = vala_parameter_get_params_array (_tmp300_);
				_tmp302_ = _tmp301_;
				if (_tmp302_) {
					ValaArrayType* array_type = NULL;
					ValaParameter* _tmp303_;
					ValaDataType* _tmp304_;
					ValaDataType* _tmp305_;
					ValaArrayType* _tmp306_;
					_tmp303_ = param;
					_tmp304_ = vala_variable_get_variable_type ((ValaVariable*) _tmp303_);
					_tmp305_ = _tmp304_;
					_tmp306_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp305_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					array_type = _tmp306_;
					while (TRUE) {
						ValaIterator* _tmp307_;
						ValaExpression* arg = NULL;
						ValaIterator* _tmp308_;
						gpointer _tmp309_;
						ValaExpression* _tmp310_;
						ValaArrayType* _tmp311_;
						ValaDataType* _tmp312_;
						ValaDataType* _tmp313_;
						ValaExpression* _tmp314_;
						ValaDataType* _tmp315_;
						ValaDataType* _tmp316_;
						ValaArrayType* _tmp317_;
						gboolean _tmp318_;
						gboolean _tmp319_;
						_tmp307_ = arg_it;
						if (!vala_iterator_next (_tmp307_)) {
							break;
						}
						_tmp308_ = arg_it;
						_tmp309_ = vala_iterator_get (_tmp308_);
						arg = (ValaExpression*) _tmp309_;
						_tmp310_ = arg;
						_tmp311_ = array_type;
						_tmp312_ = vala_array_type_get_element_type (_tmp311_);
						_tmp313_ = _tmp312_;
						vala_expression_set_target_type (_tmp310_, _tmp313_);
						_tmp314_ = arg;
						_tmp315_ = vala_expression_get_target_type (_tmp314_);
						_tmp316_ = _tmp315_;
						_tmp317_ = array_type;
						_tmp318_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp317_);
						_tmp319_ = _tmp318_;
						vala_data_type_set_value_owned (_tmp316_, _tmp319_);
						_vala_code_node_unref0 (arg);
					}
					_vala_code_node_unref0 (array_type);
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp320_ = arg_it;
				if (vala_iterator_next (_tmp320_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp321_;
					gpointer _tmp322_;
					ValaExpression* _tmp323_;
					ValaParameter* _tmp324_;
					ValaDataType* _tmp325_;
					ValaDataType* _tmp326_;
					ValaExpression* _tmp327_;
					ValaExpression* _tmp328_;
					ValaDataType* _tmp329_;
					ValaDataType* _tmp330_;
					ValaDataType* _tmp331_;
					ValaDataType* _tmp332_;
					ValaDataType* _tmp333_;
					ValaDataType* _tmp334_;
					ValaExpression* _tmp335_;
					ValaExpression* _tmp336_;
					_tmp321_ = arg_it;
					_tmp322_ = vala_iterator_get (_tmp321_);
					arg = (ValaExpression*) _tmp322_;
					_tmp323_ = arg;
					_tmp324_ = param;
					_tmp325_ = vala_variable_get_variable_type ((ValaVariable*) _tmp324_);
					_tmp326_ = _tmp325_;
					vala_expression_set_formal_target_type (_tmp323_, _tmp326_);
					_tmp327_ = arg;
					_tmp328_ = arg;
					_tmp329_ = vala_expression_get_formal_target_type (_tmp328_);
					_tmp330_ = _tmp329_;
					_tmp331_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp332_ = _tmp331_;
					_tmp333_ = vala_data_type_get_actual_type (_tmp330_, _tmp332_, NULL, (ValaCodeNode*) self);
					_tmp334_ = _tmp333_;
					vala_expression_set_target_type (_tmp327_, _tmp334_);
					_vala_code_node_unref0 (_tmp334_);
					_tmp335_ = arg;
					_tmp336_ = _vala_code_node_ref0 (_tmp335_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp336_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp337_ = m;
		_tmp338_ = vala_method_get_printf_format (_tmp337_);
		_tmp339_ = _tmp338_;
		if (_tmp339_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp340_;
			ValaStringLiteral* _tmp385_;
			format_literal = NULL;
			_tmp340_ = last_arg;
			if (VALA_IS_NULL_LITERAL (_tmp340_)) {
			} else {
				ValaExpression* _tmp341_;
				_tmp341_ = last_arg;
				if (_tmp341_ != NULL) {
					ValaExpression* _tmp342_;
					ValaStringLiteral* _tmp343_;
					gboolean _tmp344_ = FALSE;
					ValaStringLiteral* _tmp345_;
					_tmp342_ = last_arg;
					_tmp343_ = vala_string_literal_get_format_literal (_tmp342_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp343_;
					_tmp345_ = format_literal;
					if (_tmp345_ == NULL) {
						ValaList* _tmp346_;
						gint _tmp347_;
						gint _tmp348_;
						ValaMethod* _tmp349_;
						ValaList* _tmp350_;
						gint _tmp351_;
						gint _tmp352_;
						_tmp346_ = self->priv->argument_list;
						_tmp347_ = vala_collection_get_size ((ValaCollection*) _tmp346_);
						_tmp348_ = _tmp347_;
						_tmp349_ = m;
						_tmp350_ = vala_callable_get_parameters ((ValaCallable*) _tmp349_);
						_tmp351_ = vala_collection_get_size ((ValaCollection*) _tmp350_);
						_tmp352_ = _tmp351_;
						_tmp344_ = _tmp348_ == (_tmp352_ - 1);
					} else {
						_tmp344_ = FALSE;
					}
					if (_tmp344_) {
						ValaStringLiteral* _tmp353_;
						ValaStringLiteral* _tmp354_;
						ValaSemanticAnalyzer* _tmp355_;
						ValaSemanticAnalyzer* _tmp356_;
						ValaDataType* _tmp357_;
						ValaDataType* _tmp358_;
						ValaDataType* _tmp359_;
						ValaList* _tmp360_;
						ValaList* _tmp361_;
						gint _tmp362_;
						gint _tmp363_;
						ValaStringLiteral* _tmp364_;
						ValaList* _tmp365_;
						ValaIterator* _tmp366_;
						_tmp353_ = vala_string_literal_new ("\"%s\"", NULL);
						_vala_code_node_unref0 (format_literal);
						format_literal = _tmp353_;
						_tmp354_ = format_literal;
						_tmp355_ = vala_code_context_get_analyzer (context);
						_tmp356_ = _tmp355_;
						_tmp357_ = _tmp356_->string_type;
						_tmp358_ = vala_data_type_copy (_tmp357_);
						_tmp359_ = _tmp358_;
						vala_expression_set_target_type ((ValaExpression*) _tmp354_, _tmp359_);
						_vala_code_node_unref0 (_tmp359_);
						_tmp360_ = self->priv->argument_list;
						_tmp361_ = self->priv->argument_list;
						_tmp362_ = vala_collection_get_size ((ValaCollection*) _tmp361_);
						_tmp363_ = _tmp362_;
						_tmp364_ = format_literal;
						vala_list_insert (_tmp360_, _tmp363_ - 1, (ValaExpression*) _tmp364_);
						_tmp365_ = self->priv->argument_list;
						_tmp366_ = vala_iterable_iterator ((ValaIterable*) _tmp365_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp366_;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp367_;
							ValaList* _tmp368_;
							ValaList* _tmp369_;
							gint _param_size = 0;
							ValaList* _tmp370_;
							gint _tmp371_;
							gint _tmp372_;
							gint _param_index = 0;
							_tmp367_ = m;
							_tmp368_ = vala_callable_get_parameters ((ValaCallable*) _tmp367_);
							_tmp369_ = _vala_iterable_ref0 (_tmp368_);
							_param_list = _tmp369_;
							_tmp370_ = _param_list;
							_tmp371_ = vala_collection_get_size ((ValaCollection*) _tmp370_);
							_tmp372_ = _tmp371_;
							_param_size = _tmp372_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp373_;
								gint _tmp374_;
								ValaParameter* param = NULL;
								ValaList* _tmp375_;
								gpointer _tmp376_;
								gboolean _tmp377_ = FALSE;
								ValaParameter* _tmp378_;
								gboolean _tmp379_;
								gboolean _tmp380_;
								ValaIterator* _tmp384_;
								_param_index = _param_index + 1;
								_tmp373_ = _param_index;
								_tmp374_ = _param_size;
								if (!(_tmp373_ < _tmp374_)) {
									break;
								}
								_tmp375_ = _param_list;
								_tmp376_ = vala_list_get (_tmp375_, _param_index);
								param = (ValaParameter*) _tmp376_;
								_tmp378_ = param;
								_tmp379_ = vala_parameter_get_ellipsis (_tmp378_);
								_tmp380_ = _tmp379_;
								if (_tmp380_) {
									_tmp377_ = TRUE;
								} else {
									ValaParameter* _tmp381_;
									gboolean _tmp382_;
									gboolean _tmp383_;
									_tmp381_ = param;
									_tmp382_ = vala_parameter_get_params_array (_tmp381_);
									_tmp383_ = _tmp382_;
									_tmp377_ = _tmp383_;
								}
								if (_tmp377_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp384_ = arg_it;
								vala_iterator_next (_tmp384_);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
					}
				}
			}
			_tmp385_ = format_literal;
			if (_tmp385_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp386_;
				gchar* _tmp387_;
				ValaSemanticAnalyzer* _tmp388_;
				ValaSemanticAnalyzer* _tmp389_;
				const gchar* _tmp390_;
				ValaIterator* _tmp391_;
				ValaSourceReference* _tmp392_;
				ValaSourceReference* _tmp393_;
				_tmp386_ = format_literal;
				_tmp387_ = vala_string_literal_eval (_tmp386_);
				format = _tmp387_;
				_tmp388_ = vala_code_context_get_analyzer (context);
				_tmp389_ = _tmp388_;
				_tmp390_ = format;
				_tmp391_ = arg_it;
				_tmp392_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp393_ = _tmp392_;
				if (!vala_semantic_analyzer_check_print_format (_tmp389_, _tmp390_, _tmp391_, _tmp393_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp394_;
			ValaList* _tmp395_;
			gint _arg_size = 0;
			ValaList* _tmp396_;
			gint _tmp397_;
			gint _tmp398_;
			gint _arg_index = 0;
			_tmp394_ = self->priv->argument_list;
			_tmp395_ = _vala_iterable_ref0 (_tmp394_);
			_arg_list = _tmp395_;
			_tmp396_ = _arg_list;
			_tmp397_ = vala_collection_get_size ((ValaCollection*) _tmp396_);
			_tmp398_ = _tmp397_;
			_arg_size = _tmp398_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp399_;
				gint _tmp400_;
				ValaExpression* arg = NULL;
				ValaList* _tmp401_;
				gpointer _tmp402_;
				ValaExpression* _tmp403_;
				_arg_index = _arg_index + 1;
				_tmp399_ = _arg_index;
				_tmp400_ = _arg_size;
				if (!(_tmp399_ < _tmp400_)) {
					break;
				}
				_tmp401_ = _arg_list;
				_tmp402_ = vala_list_get (_tmp401_, _arg_index);
				arg = (ValaExpression*) _tmp402_;
				_tmp403_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp403_, context);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp404_ = vala_code_context_get_analyzer (context);
		_tmp405_ = _tmp404_;
		_tmp406_ = m;
		_tmp407_ = vala_method_type_new (_tmp406_);
		_tmp408_ = _tmp407_;
		_tmp409_ = m;
		_tmp410_ = vala_callable_get_parameters ((ValaCallable*) _tmp409_);
		_tmp411_ = self->priv->argument_list;
		vala_semantic_analyzer_check_arguments (_tmp405_, (ValaExpression*) self, (ValaDataType*) _tmp408_, _tmp410_, _tmp411_);
		_vala_code_node_unref0 (_tmp408_);
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp412_;
		ValaDataType* _tmp413_;
		_tmp412_ = vala_object_creation_expression_get_type_reference (self);
		_tmp413_ = _tmp412_;
		if (VALA_IS_ERROR_TYPE (_tmp413_)) {
			ValaDataType* _tmp414_;
			ValaDataType* _tmp415_;
			ValaMemberAccess* _tmp418_;
			ValaMemberAccess* _tmp419_;
			ValaList* _tmp442_;
			gint _tmp443_;
			gint _tmp444_;
			_tmp414_ = vala_object_creation_expression_get_type_reference (self);
			_tmp415_ = _tmp414_;
			if (_tmp415_ != NULL) {
				ValaDataType* _tmp416_;
				ValaDataType* _tmp417_;
				_tmp416_ = vala_object_creation_expression_get_type_reference (self);
				_tmp417_ = _tmp416_;
				vala_code_node_check ((ValaCodeNode*) _tmp417_, context);
			}
			_tmp418_ = vala_object_creation_expression_get_member_name (self);
			_tmp419_ = _tmp418_;
			if (_tmp419_ != NULL) {
				ValaMemberAccess* _tmp420_;
				ValaMemberAccess* _tmp421_;
				_tmp420_ = vala_object_creation_expression_get_member_name (self);
				_tmp421_ = _tmp420_;
				vala_code_node_check ((ValaCodeNode*) _tmp421_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp422_;
				ValaList* _tmp423_;
				gint _arg_size = 0;
				ValaList* _tmp424_;
				gint _tmp425_;
				gint _tmp426_;
				gint _arg_index = 0;
				_tmp422_ = self->priv->argument_list;
				_tmp423_ = _vala_iterable_ref0 (_tmp422_);
				_arg_list = _tmp423_;
				_tmp424_ = _arg_list;
				_tmp425_ = vala_collection_get_size ((ValaCollection*) _tmp424_);
				_tmp426_ = _tmp425_;
				_arg_size = _tmp426_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp427_;
					gint _tmp428_;
					ValaExpression* arg = NULL;
					ValaList* _tmp429_;
					gpointer _tmp430_;
					ValaExpression* _tmp431_;
					_arg_index = _arg_index + 1;
					_tmp427_ = _arg_index;
					_tmp428_ = _arg_size;
					if (!(_tmp427_ < _tmp428_)) {
						break;
					}
					_tmp429_ = _arg_list;
					_tmp430_ = vala_list_get (_tmp429_, _arg_index);
					arg = (ValaExpression*) _tmp430_;
					_tmp431_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp431_, context);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp432_;
				ValaList* _tmp433_;
				gint _init_size = 0;
				ValaList* _tmp434_;
				gint _tmp435_;
				gint _tmp436_;
				gint _init_index = 0;
				_tmp432_ = self->priv->object_initializer;
				_tmp433_ = _vala_iterable_ref0 (_tmp432_);
				_init_list = _tmp433_;
				_tmp434_ = _init_list;
				_tmp435_ = vala_collection_get_size ((ValaCollection*) _tmp434_);
				_tmp436_ = _tmp435_;
				_init_size = _tmp436_;
				_init_index = -1;
				while (TRUE) {
					gint _tmp437_;
					gint _tmp438_;
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp439_;
					gpointer _tmp440_;
					ValaMemberInitializer* _tmp441_;
					_init_index = _init_index + 1;
					_tmp437_ = _init_index;
					_tmp438_ = _init_size;
					if (!(_tmp437_ < _tmp438_)) {
						break;
					}
					_tmp439_ = _init_list;
					_tmp440_ = vala_list_get (_tmp439_, _init_index);
					init = (ValaMemberInitializer*) _tmp440_;
					_tmp441_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp441_, context);
					_vala_code_node_unref0 (init);
				}
				_vala_iterable_unref0 (_init_list);
			}
			_tmp442_ = self->priv->argument_list;
			_tmp443_ = vala_collection_get_size ((ValaCollection*) _tmp442_);
			_tmp444_ = _tmp443_;
			if (_tmp444_ == 0) {
				ValaSourceReference* _tmp445_;
				ValaSourceReference* _tmp446_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp445_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp446_ = _tmp445_;
				vala_report_error (_tmp446_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp447_;
				ValaIterator* _tmp448_;
				ValaIterator* _tmp449_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp450_;
				gpointer _tmp451_;
				gboolean _tmp452_ = FALSE;
				ValaExpression* _tmp453_;
				ValaDataType* _tmp454_;
				ValaDataType* _tmp455_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp464_;
				ValaStringLiteral* _tmp465_;
				ValaStringLiteral* _tmp466_;
				ValaList* _tmp475_;
				ValaIterator* _tmp476_;
				ValaIterator* _tmp477_;
				ValaSemanticAnalyzer* _tmp478_;
				ValaSemanticAnalyzer* _tmp479_;
				ValaIterator* _tmp480_;
				ValaSourceReference* _tmp481_;
				ValaSourceReference* _tmp482_;
				_tmp447_ = self->priv->argument_list;
				_tmp448_ = vala_iterable_iterator ((ValaIterable*) _tmp447_);
				arg_it = _tmp448_;
				_tmp449_ = arg_it;
				vala_iterator_next (_tmp449_);
				_tmp450_ = arg_it;
				_tmp451_ = vala_iterator_get (_tmp450_);
				ex = (ValaExpression*) _tmp451_;
				_tmp453_ = ex;
				_tmp454_ = vala_expression_get_value_type (_tmp453_);
				_tmp455_ = _tmp454_;
				if (_tmp455_ == NULL) {
					_tmp452_ = TRUE;
				} else {
					ValaExpression* _tmp456_;
					ValaDataType* _tmp457_;
					ValaDataType* _tmp458_;
					ValaSemanticAnalyzer* _tmp459_;
					ValaSemanticAnalyzer* _tmp460_;
					ValaDataType* _tmp461_;
					_tmp456_ = ex;
					_tmp457_ = vala_expression_get_value_type (_tmp456_);
					_tmp458_ = _tmp457_;
					_tmp459_ = vala_code_context_get_analyzer (context);
					_tmp460_ = _tmp459_;
					_tmp461_ = _tmp460_->string_type;
					_tmp452_ = !vala_data_type_compatible (_tmp458_, _tmp461_);
				}
				if (_tmp452_) {
					ValaSourceReference* _tmp462_;
					ValaSourceReference* _tmp463_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp462_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp463_ = _tmp462_;
					vala_report_error (_tmp463_, "Invalid type for argument 1");
				}
				_tmp464_ = ex;
				_tmp465_ = vala_string_literal_get_format_literal (_tmp464_);
				format_literal = _tmp465_;
				_tmp466_ = format_literal;
				if (_tmp466_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp467_;
					gchar* _tmp468_;
					ValaSemanticAnalyzer* _tmp469_;
					ValaSemanticAnalyzer* _tmp470_;
					const gchar* _tmp471_;
					ValaIterator* _tmp472_;
					ValaSourceReference* _tmp473_;
					ValaSourceReference* _tmp474_;
					_tmp467_ = format_literal;
					_tmp468_ = vala_string_literal_eval (_tmp467_);
					format = _tmp468_;
					_tmp469_ = vala_code_context_get_analyzer (context);
					_tmp470_ = _tmp469_;
					_tmp471_ = format;
					_tmp472_ = arg_it;
					_tmp473_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp474_ = _tmp473_;
					if (!vala_semantic_analyzer_check_print_format (_tmp470_, _tmp471_, _tmp472_, _tmp474_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp475_ = self->priv->argument_list;
				_tmp476_ = vala_iterable_iterator ((ValaIterable*) _tmp475_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp476_;
				_tmp477_ = arg_it;
				vala_iterator_next (_tmp477_);
				_tmp478_ = vala_code_context_get_analyzer (context);
				_tmp479_ = _tmp478_;
				_tmp480_ = arg_it;
				_tmp481_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp482_ = _tmp481_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp479_, _tmp480_, 1, _tmp482_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp483_;
		ValaList* _tmp484_;
		gint _arg_size = 0;
		ValaList* _tmp485_;
		gint _tmp486_;
		gint _tmp487_;
		gint _arg_index = 0;
		_tmp483_ = self->priv->argument_list;
		_tmp484_ = _vala_iterable_ref0 (_tmp483_);
		_arg_list = _tmp484_;
		_tmp485_ = _arg_list;
		_tmp486_ = vala_collection_get_size ((ValaCollection*) _tmp485_);
		_tmp487_ = _tmp486_;
		_arg_size = _tmp487_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp488_;
			gint _tmp489_;
			ValaExpression* arg = NULL;
			ValaList* _tmp490_;
			gpointer _tmp491_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp492_;
			gboolean _tmp493_ = FALSE;
			ValaSizeofExpression* _tmp494_;
			_arg_index = _arg_index + 1;
			_tmp488_ = _arg_index;
			_tmp489_ = _arg_size;
			if (!(_tmp488_ < _tmp489_)) {
				break;
			}
			_tmp490_ = _arg_list;
			_tmp491_ = vala_list_get (_tmp490_, _arg_index);
			arg = (ValaExpression*) _tmp491_;
			_tmp492_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp492_) ? ((ValaSizeofExpression*) _tmp492_) : NULL;
			_tmp494_ = sizeof_expr;
			if (_tmp494_ != NULL) {
				ValaSizeofExpression* _tmp495_;
				ValaDataType* _tmp496_;
				ValaDataType* _tmp497_;
				_tmp495_ = sizeof_expr;
				_tmp496_ = vala_sizeof_expression_get_type_reference (_tmp495_);
				_tmp497_ = _tmp496_;
				_tmp493_ = VALA_IS_GENERIC_TYPE (_tmp497_);
			} else {
				_tmp493_ = FALSE;
			}
			if (_tmp493_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp498_;
				ValaDataType* _tmp499_;
				ValaDataType* _tmp500_;
				ValaDataType* _tmp501_;
				ValaDataType* _tmp502_;
				ValaDataType* _tmp503_;
				ValaDataType* _tmp504_;
				ValaList* _tmp505_;
				ValaDataType* _tmp506_;
				ValaExpression* _tmp507_;
				ValaDataType* _tmp508_;
				ValaSourceReference* _tmp509_;
				ValaSourceReference* _tmp510_;
				ValaSizeofExpression* _tmp511_;
				ValaSizeofExpression* _tmp512_;
				_tmp498_ = sizeof_expr;
				_tmp499_ = vala_sizeof_expression_get_type_reference (_tmp498_);
				_tmp500_ = _tmp499_;
				_tmp501_ = vala_object_creation_expression_get_type_reference (self);
				_tmp502_ = _tmp501_;
				_tmp503_ = vala_object_creation_expression_get_type_reference (self);
				_tmp504_ = _tmp503_;
				_tmp505_ = vala_data_type_get_type_arguments (_tmp504_);
				_tmp506_ = vala_data_type_get_actual_type (_tmp500_, _tmp502_, _tmp505_, (ValaCodeNode*) self);
				sizeof_type = _tmp506_;
				_tmp507_ = arg;
				_tmp508_ = sizeof_type;
				_tmp509_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp510_ = _tmp509_;
				_tmp511_ = vala_sizeof_expression_new (_tmp508_, _tmp510_);
				_tmp512_ = _tmp511_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp507_, (ValaExpression*) _tmp512_);
				_vala_code_node_unref0 (_tmp512_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp513_ = type;
	_tmp514_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp513_);
	_tmp515_ = _tmp514_;
	if (!_tmp515_) {
		ValaSemanticAnalyzer* _tmp516_;
		ValaSemanticAnalyzer* _tmp517_;
		ValaDataType* _tmp518_;
		ValaDataType* _tmp519_;
		_tmp516_ = vala_code_context_get_analyzer (context);
		_tmp517_ = _tmp516_;
		_tmp518_ = vala_object_creation_expression_get_type_reference (self);
		_tmp519_ = _tmp518_;
		vala_semantic_analyzer_check_type (_tmp517_, _tmp519_);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp520_;
		ValaList* _tmp521_;
		gint _init_size = 0;
		ValaList* _tmp522_;
		gint _tmp523_;
		gint _tmp524_;
		gint _init_index = 0;
		_tmp520_ = vala_object_creation_expression_get_object_initializer (self);
		_tmp521_ = _vala_iterable_ref0 (_tmp520_);
		_init_list = _tmp521_;
		_tmp522_ = _init_list;
		_tmp523_ = vala_collection_get_size ((ValaCollection*) _tmp522_);
		_tmp524_ = _tmp523_;
		_init_size = _tmp524_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp525_;
			gint _tmp526_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp527_;
			gpointer _tmp528_;
			ValaSemanticAnalyzer* _tmp529_;
			ValaSemanticAnalyzer* _tmp530_;
			ValaMemberInitializer* _tmp531_;
			ValaDataType* _tmp532_;
			ValaDataType* _tmp533_;
			_init_index = _init_index + 1;
			_tmp525_ = _init_index;
			_tmp526_ = _init_size;
			if (!(_tmp525_ < _tmp526_)) {
				break;
			}
			_tmp527_ = _init_list;
			_tmp528_ = vala_list_get (_tmp527_, _init_index);
			init = (ValaMemberInitializer*) _tmp528_;
			_tmp529_ = vala_code_context_get_analyzer (context);
			_tmp530_ = _tmp529_;
			_tmp531_ = init;
			_tmp532_ = vala_object_creation_expression_get_type_reference (self);
			_tmp533_ = _tmp532_;
			vala_semantic_analyzer_visit_member_initializer (_tmp530_, _tmp531_, _tmp533_);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	_tmp534_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp535_ = _tmp534_;
	if (_tmp535_) {
		gboolean _tmp536_ = FALSE;
		ValaCodeNode* _tmp537_;
		ValaCodeNode* _tmp538_;
		_tmp537_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp538_ = _tmp537_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp538_)) {
			_tmp536_ = TRUE;
		} else {
			ValaCodeNode* _tmp539_;
			ValaCodeNode* _tmp540_;
			_tmp539_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp540_ = _tmp539_;
			_tmp536_ = VALA_IS_EXPRESSION_STATEMENT (_tmp540_);
		}
		if (_tmp536_) {
		} else {
			ValaSemanticAnalyzer* _tmp541_;
			ValaSemanticAnalyzer* _tmp542_;
			ValaSymbol* _tmp543_;
			ValaSymbol* _tmp544_;
			_tmp541_ = vala_code_context_get_analyzer (context);
			_tmp542_ = _tmp541_;
			_tmp543_ = vala_semantic_analyzer_get_current_symbol (_tmp542_);
			_tmp544_ = _tmp543_;
			if (!VALA_IS_BLOCK (_tmp544_)) {
				ValaSourceReference* _tmp545_;
				ValaSourceReference* _tmp546_;
				_tmp545_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp546_ = _tmp545_;
				vala_report_error (_tmp546_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp547_;
				ValaCodeNode* _tmp548_;
				ValaCodeNode* _tmp549_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp550_;
				ValaDataType* _tmp551_;
				ValaDataType* _tmp552_;
				ValaDataType* _tmp553_;
				gchar* _tmp554_;
				gchar* _tmp555_;
				ValaSourceReference* _tmp556_;
				ValaSourceReference* _tmp557_;
				ValaLocalVariable* _tmp558_;
				ValaLocalVariable* _tmp559_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp560_;
				ValaSourceReference* _tmp561_;
				ValaSourceReference* _tmp562_;
				ValaDeclarationStatement* _tmp563_;
				ValaSemanticAnalyzer* _tmp564_;
				ValaSemanticAnalyzer* _tmp565_;
				ValaBlock* _tmp566_;
				ValaDeclarationStatement* _tmp567_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp568_;
				ValaDataType* _tmp569_;
				ValaDataType* _tmp570_;
				ValaExpression* _tmp571_;
				ValaExpression* _tmp572_;
				ValaDataType* _tmp573_;
				ValaDataType* _tmp574_;
				ValaLocalVariable* _tmp575_;
				ValaDeclarationStatement* _tmp576_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp577_;
				ValaSemanticAnalyzer* _tmp578_;
				ValaSymbol* _tmp579_;
				ValaSymbol* _tmp580_;
				ValaBlock* _tmp581_;
				ValaBlock* _tmp582_;
				ValaLocalVariable* _tmp583_;
				ValaSemanticAnalyzer* _tmp584_;
				ValaSemanticAnalyzer* _tmp585_;
				ValaBlock* _tmp586_;
				ValaLocalVariable* _tmp587_;
				ValaCodeNode* _tmp588_;
				ValaExpression* _tmp589_;
				ValaExpression* _tmp590_;
				_tmp547_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp548_ = _tmp547_;
				_tmp549_ = _vala_code_node_ref0 (_tmp548_);
				old_parent_node = _tmp549_;
				_tmp550_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp551_ = _tmp550_;
				_tmp552_ = vala_data_type_copy (_tmp551_);
				_tmp553_ = _tmp552_;
				_tmp554_ = vala_code_node_get_temp_name ();
				_tmp555_ = _tmp554_;
				_tmp556_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp557_ = _tmp556_;
				_tmp558_ = vala_local_variable_new (_tmp553_, _tmp555_, NULL, _tmp557_);
				_tmp559_ = _tmp558_;
				_g_free0 (_tmp555_);
				_vala_code_node_unref0 (_tmp553_);
				local = _tmp559_;
				_tmp560_ = local;
				_tmp561_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp562_ = _tmp561_;
				_tmp563_ = vala_declaration_statement_new ((ValaSymbol*) _tmp560_, _tmp562_);
				decl = _tmp563_;
				_tmp564_ = vala_code_context_get_analyzer (context);
				_tmp565_ = _tmp564_;
				_tmp566_ = _tmp565_->insert_block;
				_tmp567_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp566_, (ValaStatement*) _tmp567_);
				_tmp568_ = local;
				_tmp569_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp570_ = _tmp569_;
				_tmp571_ = vala_semantic_analyzer_create_temp_access (_tmp568_, _tmp570_);
				temp_access = _tmp571_;
				_tmp572_ = temp_access;
				_tmp573_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp574_ = _tmp573_;
				vala_expression_set_formal_target_type (_tmp572_, _tmp574_);
				_tmp575_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp575_, (ValaExpression*) self);
				_tmp576_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp576_, context);
				_tmp577_ = vala_code_context_get_analyzer (context);
				_tmp578_ = _tmp577_;
				_tmp579_ = vala_semantic_analyzer_get_current_symbol (_tmp578_);
				_tmp580_ = _tmp579_;
				_tmp581_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp580_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp581_;
				_tmp582_ = block;
				_tmp583_ = local;
				vala_block_remove_local_variable (_tmp582_, _tmp583_);
				_tmp584_ = vala_code_context_get_analyzer (context);
				_tmp585_ = _tmp584_;
				_tmp586_ = _tmp585_->insert_block;
				_tmp587_ = local;
				vala_block_add_local_variable (_tmp586_, _tmp587_);
				_tmp588_ = old_parent_node;
				_tmp589_ = temp_access;
				vala_code_node_replace_expression (_tmp588_, (ValaExpression*) self, _tmp589_);
				_tmp590_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp590_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp591_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp592_ = _tmp591_;
	result = !_tmp592_;
	_vala_code_node_unref0 (type);
	return result;
}

static void
vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                      ValaCollection* collection,
                                                      ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_METHOD (_tmp1_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		if (source_reference == NULL) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			source_reference = _tmp3_;
		}
		_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp6_;
		_tmp7_ = m;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp7_, collection, source_reference);
		_vala_code_node_unref0 (m);
	}
}

static void
vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp9_, codegen);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _init_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _init_index = 0;
		_tmp10_ = self->priv->object_initializer;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_init_list = _tmp11_;
		_tmp12_ = _init_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_init_size = _tmp14_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaMemberInitializer* _tmp19_;
			_init_index = _init_index + 1;
			_tmp15_ = _init_index;
			_tmp16_ = _init_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _init_list;
			_tmp18_ = vala_list_get (_tmp17_, _init_index);
			init = (ValaMemberInitializer*) _tmp18_;
			_tmp19_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp19_, codegen);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _init_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _init_index = 0;
		_tmp10_ = self->priv->object_initializer;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_init_list = _tmp11_;
		_tmp12_ = _init_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_init_size = _tmp14_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaMemberInitializer* _tmp19_;
			_init_index = _init_index + 1;
			_tmp15_ = _init_index;
			_tmp16_ = _init_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _init_list;
			_tmp18_ = vala_list_get (_tmp17_, _init_index);
			init = (ValaMemberInitializer*) _tmp18_;
			_tmp19_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp19_, collection);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}

static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass,
                                            gpointer klass_data)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaObjectCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_object_creation_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
}

static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self,
                                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_object_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}

static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_member_name);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}

/**
 * Represents an object creation expression in the source code.
 */
static GType
vala_object_creation_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
	GType vala_object_creation_expression_type_id;
	vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
	ValaObjectCreationExpression_private_offset = g_type_add_instance_private (vala_object_creation_expression_type_id, sizeof (ValaObjectCreationExpressionPrivate));
	return vala_object_creation_expression_type_id;
}

GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__volatile)) {
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = vala_object_creation_expression_get_type_once ();
		g_once_init_leave (&vala_object_creation_expression_type_id__volatile, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__volatile;
}

