/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaDataType* _tmp13_;
			_type_arg_index = _type_arg_index + 1;
			_tmp9_ = _type_arg_index;
			_tmp10_ = _type_arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _type_arg_list;
			_tmp12_ = vala_list_get (_tmp11_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp12_;
			_tmp13_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp18_;
	gboolean _tmp643_ = FALSE;
	gboolean _tmp644_ = FALSE;
	gboolean _tmp645_ = FALSE;
	ValaExpression* _tmp646_;
	ValaExpression* _tmp647_;
	ValaSymbol* _tmp675_;
	ValaSymbol* _tmp676_;
	ValaSymbol* _tmp730_;
	ValaSymbol* _tmp731_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp769_;
	ValaSymbol* _tmp770_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp771_;
	ValaSymbol* _tmp772_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1235_;
	ValaSymbol* _tmp1236_;
	ValaSymbol* _tmp1238_;
	ValaVersionAttribute* _tmp1239_;
	ValaVersionAttribute* _tmp1240_;
	ValaSourceReference* _tmp1241_;
	ValaSourceReference* _tmp1242_;
	gboolean _tmp1243_ = FALSE;
	gboolean _tmp1298_ = FALSE;
	gboolean _tmp1325_ = FALSE;
	gboolean _tmp1326_ = FALSE;
	ValaDataType* _tmp1624_;
	ValaDataType* _tmp1625_;
	gboolean _tmp1628_;
	gboolean _tmp1629_;
	gboolean _tmp1630_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaDataType* _tmp17_;
			_type_arg_index = _type_arg_index + 1;
			_tmp13_ = _type_arg_index;
			_tmp14_ = _type_arg_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _type_arg_list;
			_tmp16_ = vala_list_get (_tmp15_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp16_;
			_tmp17_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp17_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp18_ = self->priv->_qualified;
	if (_tmp18_) {
		ValaNamespace* _tmp19_;
		ValaNamespace* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaScope* _tmp22_;
		ValaScope* _tmp23_;
		const gchar* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		_tmp19_ = vala_code_context_get_root (context);
		_tmp20_ = _tmp19_;
		base_symbol = (ValaSymbol*) _tmp20_;
		_tmp21_ = base_symbol;
		_tmp22_ = vala_symbol_get_scope (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = self->priv->_member_name;
		_tmp25_ = vala_scope_lookup (_tmp23_, _tmp24_);
		_tmp26_ = _tmp25_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp26_);
		_vala_code_node_unref0 (_tmp26_);
	} else {
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp27_ = vala_member_access_get_inner (self);
		_tmp28_ = _tmp27_;
		if (_tmp28_ == NULL) {
			const gchar* _tmp29_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSemanticAnalyzer* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			gboolean _tmp140_ = FALSE;
			ValaSymbol* _tmp141_;
			ValaSymbol* _tmp142_;
			_tmp29_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp29_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp30_;
				ValaSemanticAnalyzer* _tmp31_;
				_tmp30_ = vala_code_context_get_analyzer (context);
				_tmp31_ = _tmp30_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp31_)) {
					ValaSourceReference* _tmp32_;
					ValaSourceReference* _tmp33_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp33_ = _tmp32_;
					vala_report_error (_tmp33_, "This access invalid outside of instance methods");
					result = FALSE;
					return result;
				}
			}
			_tmp34_ = vala_code_context_get_analyzer (context);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_semantic_analyzer_get_current_symbol (_tmp35_);
			_tmp37_ = _tmp36_;
			base_symbol = _tmp37_;
			method_found = FALSE;
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			sym = _tmp41_;
			while (TRUE) {
				gboolean _tmp42_ = FALSE;
				ValaSymbol* _tmp43_;
				ValaSymbol* _tmp89_;
				const gchar* _tmp90_;
				ValaSymbol* _tmp91_;
				ValaSymbol* _tmp92_;
				gboolean _tmp93_ = FALSE;
				gboolean _tmp94_ = FALSE;
				ValaSymbol* _tmp95_;
				ValaSymbol* _tmp96_;
				ValaSymbol* _tmp134_;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp137_;
				ValaSymbol* _tmp138_;
				ValaSymbol* _tmp139_;
				_tmp43_ = sym;
				if (_tmp43_ != NULL) {
					ValaSymbol* _tmp44_;
					ValaSymbol* _tmp45_;
					_tmp44_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp45_ = _tmp44_;
					_tmp42_ = _tmp45_ == NULL;
				} else {
					_tmp42_ = FALSE;
				}
				if (!_tmp42_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp46_;
					_tmp46_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp46_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp47_;
						ValaCreationMethod* _tmp48_;
						ValaParameter* _tmp49_;
						ValaParameter* _tmp50_;
						_tmp47_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp48_ = cm;
						_tmp49_ = vala_method_get_this_parameter ((ValaMethod*) _tmp48_);
						_tmp50_ = _tmp49_;
						this_parameter = _tmp50_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp51_;
						_tmp51_ = sym;
						if (VALA_IS_PROPERTY (_tmp51_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp52_;
							ValaProperty* _tmp53_;
							ValaParameter* _tmp54_;
							ValaParameter* _tmp55_;
							ValaProperty* _tmp56_;
							ValaMemberBinding _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaProperty* _tmp59_;
							ValaMemberBinding _tmp60_;
							ValaMemberBinding _tmp61_;
							_tmp52_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp53_ = prop;
							_tmp54_ = vala_property_get_this_parameter (_tmp53_);
							_tmp55_ = _tmp54_;
							this_parameter = _tmp55_;
							_tmp56_ = prop;
							_tmp57_ = vala_property_get_binding (_tmp56_);
							_tmp58_ = _tmp57_;
							may_access_instance_members = _tmp58_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp59_ = prop;
							_tmp60_ = vala_property_get_binding (_tmp59_);
							_tmp61_ = _tmp60_;
							may_access_klass_members = _tmp61_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp62_;
							_tmp62_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp62_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp63_;
								ValaConstructor* _tmp64_;
								ValaParameter* _tmp65_;
								ValaParameter* _tmp66_;
								ValaConstructor* _tmp67_;
								ValaMemberBinding _tmp68_;
								ValaMemberBinding _tmp69_;
								_tmp63_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp64_ = c;
								_tmp65_ = vala_constructor_get_this_parameter (_tmp64_);
								_tmp66_ = _tmp65_;
								this_parameter = _tmp66_;
								_tmp67_ = c;
								_tmp68_ = vala_constructor_get_binding (_tmp67_);
								_tmp69_ = _tmp68_;
								may_access_instance_members = _tmp69_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp70_;
								_tmp70_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp70_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp71_;
									ValaDestructor* _tmp72_;
									ValaParameter* _tmp73_;
									ValaParameter* _tmp74_;
									ValaDestructor* _tmp75_;
									ValaMemberBinding _tmp76_;
									ValaMemberBinding _tmp77_;
									_tmp71_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp72_ = d;
									_tmp73_ = vala_destructor_get_this_parameter (_tmp72_);
									_tmp74_ = _tmp73_;
									this_parameter = _tmp74_;
									_tmp75_ = d;
									_tmp76_ = vala_destructor_get_binding (_tmp75_);
									_tmp77_ = _tmp76_;
									may_access_instance_members = _tmp77_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp78_;
									_tmp78_ = sym;
									if (VALA_IS_METHOD (_tmp78_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp79_;
										ValaMethod* _tmp80_;
										ValaParameter* _tmp81_;
										ValaParameter* _tmp82_;
										ValaMethod* _tmp83_;
										ValaMemberBinding _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMethod* _tmp86_;
										ValaMemberBinding _tmp87_;
										ValaMemberBinding _tmp88_;
										_tmp79_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALA_TYPE_METHOD, ValaMethod);
										_tmp80_ = m;
										_tmp81_ = vala_method_get_this_parameter (_tmp80_);
										_tmp82_ = _tmp81_;
										this_parameter = _tmp82_;
										_tmp83_ = m;
										_tmp84_ = vala_method_get_binding (_tmp83_);
										_tmp85_ = _tmp84_;
										may_access_instance_members = _tmp85_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp86_ = m;
										_tmp87_ = vala_method_get_binding (_tmp86_);
										_tmp88_ = _tmp87_;
										may_access_klass_members = _tmp88_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp89_ = sym;
				_tmp90_ = self->priv->_member_name;
				_tmp91_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp89_, _tmp90_);
				_tmp92_ = _tmp91_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp92_);
				_vala_code_node_unref0 (_tmp92_);
				_tmp95_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp96_ = _tmp95_;
				if (_tmp96_ == NULL) {
					ValaSymbol* _tmp97_;
					_tmp97_ = sym;
					_tmp94_ = VALA_IS_TYPESYMBOL (_tmp97_);
				} else {
					_tmp94_ = FALSE;
				}
				if (_tmp94_) {
					_tmp93_ = may_access_instance_members;
				} else {
					_tmp93_ = FALSE;
				}
				if (_tmp93_) {
					ValaParameter* _tmp98_;
					ValaDataType* _tmp99_;
					ValaDataType* _tmp100_;
					const gchar* _tmp101_;
					ValaSymbol* _tmp102_;
					ValaSymbol* _tmp103_;
					gboolean _tmp104_ = FALSE;
					ValaSymbol* _tmp105_;
					ValaSymbol* _tmp106_;
					_tmp98_ = this_parameter;
					_tmp99_ = vala_variable_get_variable_type ((ValaVariable*) _tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = self->priv->_member_name;
					_tmp102_ = vala_data_type_get_member (_tmp100_, _tmp101_);
					_tmp103_ = _tmp102_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp103_);
					_vala_code_node_unref0 (_tmp103_);
					_tmp105_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp106_ = _tmp105_;
					if (_tmp106_ != NULL) {
						ValaSymbol* _tmp107_;
						ValaSymbol* _tmp108_;
						_tmp107_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp108_ = _tmp107_;
						_tmp104_ = vala_member_access_is_instance_symbol (_tmp108_);
					} else {
						_tmp104_ = FALSE;
					}
					if (_tmp104_) {
						ValaSourceReference* _tmp109_;
						ValaSourceReference* _tmp110_;
						ValaMemberAccess* _tmp111_;
						ValaMemberAccess* _tmp112_;
						ValaExpression* _tmp113_;
						ValaExpression* _tmp114_;
						ValaParameter* _tmp115_;
						ValaDataType* _tmp116_;
						ValaDataType* _tmp117_;
						ValaDataType* _tmp118_;
						ValaDataType* _tmp119_;
						ValaExpression* _tmp120_;
						ValaExpression* _tmp121_;
						ValaDataType* _tmp122_;
						ValaDataType* _tmp123_;
						ValaExpression* _tmp124_;
						ValaExpression* _tmp125_;
						ValaParameter* _tmp126_;
						ValaExpression* _tmp127_;
						ValaExpression* _tmp128_;
						ValaDataType* _tmp129_;
						ValaDataType* _tmp130_;
						const gchar* _tmp131_;
						ValaSymbol* _tmp132_;
						ValaSymbol* _tmp133_;
						_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp110_ = _tmp109_;
						_tmp111_ = vala_member_access_new (NULL, "this", _tmp110_);
						_tmp112_ = _tmp111_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp112_);
						_vala_code_node_unref0 (_tmp112_);
						_tmp113_ = vala_member_access_get_inner (self);
						_tmp114_ = _tmp113_;
						_tmp115_ = this_parameter;
						_tmp116_ = vala_variable_get_variable_type ((ValaVariable*) _tmp115_);
						_tmp117_ = _tmp116_;
						_tmp118_ = vala_data_type_copy (_tmp117_);
						_tmp119_ = _tmp118_;
						vala_expression_set_value_type (_tmp114_, _tmp119_);
						_vala_code_node_unref0 (_tmp119_);
						_tmp120_ = vala_member_access_get_inner (self);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_expression_get_value_type (_tmp121_);
						_tmp123_ = _tmp122_;
						vala_data_type_set_value_owned (_tmp123_, FALSE);
						_tmp124_ = vala_member_access_get_inner (self);
						_tmp125_ = _tmp124_;
						_tmp126_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp125_, (ValaSymbol*) _tmp126_);
						_tmp127_ = vala_member_access_get_inner (self);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_expression_get_value_type (_tmp128_);
						_tmp130_ = _tmp129_;
						_tmp131_ = self->priv->_member_name;
						_tmp132_ = vala_data_type_get_member (_tmp130_, _tmp131_);
						_tmp133_ = _tmp132_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp133_);
						_vala_code_node_unref0 (_tmp133_);
					}
				}
				_tmp134_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp135_ = _tmp134_;
				if (_tmp135_ == NULL) {
					ValaSymbol* _tmp136_;
					_tmp136_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp136_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp137_ = sym;
				_tmp138_ = vala_symbol_get_parent_symbol (_tmp137_);
				_tmp139_ = _tmp138_;
				sym = _tmp139_;
			}
			_tmp141_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp142_ = _tmp141_;
			if (_tmp142_ == NULL) {
				ValaSourceReference* _tmp143_;
				ValaSourceReference* _tmp144_;
				_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp144_ = _tmp143_;
				_tmp140_ = _tmp144_ != NULL;
			} else {
				_tmp140_ = FALSE;
			}
			if (_tmp140_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp145_;
					ValaSourceReference* _tmp146_;
					ValaList* _tmp147_;
					ValaList* _tmp148_;
					ValaList* _tmp149_;
					gint _ns_size = 0;
					ValaList* _tmp150_;
					gint _tmp151_;
					gint _tmp152_;
					gint _ns_index = 0;
					_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp146_ = _tmp145_;
					_tmp147_ = vala_source_reference_get_using_directives (_tmp146_);
					_tmp148_ = _tmp147_;
					_tmp149_ = _vala_iterable_ref0 (_tmp148_);
					_ns_list = _tmp149_;
					_tmp150_ = _ns_list;
					_tmp151_ = vala_collection_get_size ((ValaCollection*) _tmp150_);
					_tmp152_ = _tmp151_;
					_ns_size = _tmp152_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp153_;
						gint _tmp154_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp155_;
						gpointer _tmp156_;
						ValaUsingDirective* _tmp157_;
						gboolean _tmp158_;
						gboolean _tmp159_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp160_;
						ValaSymbol* _tmp161_;
						ValaSymbol* _tmp162_;
						ValaScope* _tmp163_;
						ValaScope* _tmp164_;
						const gchar* _tmp165_;
						ValaSymbol* _tmp166_;
						ValaSymbol* _tmp167_;
						_ns_index = _ns_index + 1;
						_tmp153_ = _ns_index;
						_tmp154_ = _ns_size;
						if (!(_tmp153_ < _tmp154_)) {
							break;
						}
						_tmp155_ = _ns_list;
						_tmp156_ = vala_list_get (_tmp155_, _ns_index);
						ns = (ValaUsingDirective*) _tmp156_;
						_tmp157_ = ns;
						_tmp158_ = vala_code_node_get_error ((ValaCodeNode*) _tmp157_);
						_tmp159_ = _tmp158_;
						if (_tmp159_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp160_ = ns;
						_tmp161_ = vala_using_directive_get_namespace_symbol (_tmp160_);
						_tmp162_ = _tmp161_;
						_tmp163_ = vala_symbol_get_scope (_tmp162_);
						_tmp164_ = _tmp163_;
						_tmp165_ = self->priv->_member_name;
						_tmp166_ = vala_scope_lookup (_tmp164_, _tmp165_);
						local_sym = _tmp166_;
						_tmp167_ = local_sym;
						if (_tmp167_ != NULL) {
							gboolean _tmp168_ = FALSE;
							ValaSymbol* _tmp169_;
							ValaSymbol* _tmp170_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp186_;
							ValaSymbol* _tmp187_;
							ValaSymbol* _tmp188_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp208_;
							ValaExpression* _tmp209_;
							ValaExpression* _tmp210_;
							ValaSymbol* _tmp211_;
							_tmp169_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp170_ = _tmp169_;
							if (_tmp170_ != NULL) {
								ValaSymbol* _tmp171_;
								ValaSymbol* _tmp172_;
								ValaSymbol* _tmp173_;
								_tmp171_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp172_ = _tmp171_;
								_tmp173_ = local_sym;
								_tmp168_ = _tmp172_ != _tmp173_;
							} else {
								_tmp168_ = FALSE;
							}
							if (_tmp168_) {
								ValaSourceReference* _tmp174_;
								ValaSourceReference* _tmp175_;
								const gchar* _tmp176_;
								ValaSymbol* _tmp177_;
								ValaSymbol* _tmp178_;
								gchar* _tmp179_;
								gchar* _tmp180_;
								ValaSymbol* _tmp181_;
								gchar* _tmp182_;
								gchar* _tmp183_;
								gchar* _tmp184_;
								gchar* _tmp185_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp174_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp175_ = _tmp174_;
								_tmp176_ = self->priv->_member_name;
								_tmp177_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp178_ = _tmp177_;
								_tmp179_ = vala_symbol_get_full_name (_tmp178_);
								_tmp180_ = _tmp179_;
								_tmp181_ = local_sym;
								_tmp182_ = vala_symbol_get_full_name (_tmp181_);
								_tmp183_ = _tmp182_;
								_tmp184_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp176_, _tmp180_, _tmp183_);
								_tmp185_ = _tmp184_;
								vala_report_error (_tmp175_, _tmp185_);
								_g_free0 (_tmp185_);
								_g_free0 (_tmp183_);
								_g_free0 (_tmp180_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								return result;
							}
							_tmp186_ = local_sym;
							_tmp187_ = vala_symbol_get_parent_symbol (_tmp186_);
							_tmp188_ = _tmp187_;
							inner_sym = _tmp188_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp189_ = FALSE;
								ValaSymbol* _tmp190_;
								ValaMemberAccess* _tmp194_;
								ValaSymbol* _tmp195_;
								const gchar* _tmp196_;
								const gchar* _tmp197_;
								ValaSourceReference* _tmp198_;
								ValaSourceReference* _tmp199_;
								ValaMemberAccess* _tmp200_;
								ValaMemberAccess* _tmp201_;
								ValaMemberAccess* _tmp202_;
								ValaExpression* _tmp203_;
								ValaExpression* _tmp204_;
								ValaSymbol* _tmp205_;
								ValaSymbol* _tmp206_;
								ValaSymbol* _tmp207_;
								_tmp190_ = inner_sym;
								if (_tmp190_ != NULL) {
									ValaSymbol* _tmp191_;
									const gchar* _tmp192_;
									const gchar* _tmp193_;
									_tmp191_ = inner_sym;
									_tmp192_ = vala_symbol_get_name (_tmp191_);
									_tmp193_ = _tmp192_;
									_tmp189_ = _tmp193_ != NULL;
								} else {
									_tmp189_ = FALSE;
								}
								if (!_tmp189_) {
									break;
								}
								_tmp194_ = inner_ma;
								_tmp195_ = inner_sym;
								_tmp196_ = vala_symbol_get_name (_tmp195_);
								_tmp197_ = _tmp196_;
								_tmp198_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp199_ = _tmp198_;
								_tmp200_ = vala_member_access_new (NULL, _tmp197_, _tmp199_);
								_tmp201_ = _tmp200_;
								vala_member_access_set_inner (_tmp194_, (ValaExpression*) _tmp201_);
								_vala_code_node_unref0 (_tmp201_);
								_tmp202_ = inner_ma;
								_tmp203_ = vala_member_access_get_inner (_tmp202_);
								_tmp204_ = _tmp203_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp205_ = inner_sym;
								_tmp206_ = vala_symbol_get_parent_symbol (_tmp205_);
								_tmp207_ = _tmp206_;
								inner_sym = _tmp207_;
							}
							_tmp208_ = inner_ma;
							vala_member_access_set_qualified (_tmp208_, TRUE);
							_tmp209_ = vala_member_access_get_inner (self);
							_tmp210_ = _tmp209_;
							vala_code_node_check ((ValaCodeNode*) _tmp210_, context);
							_tmp211_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp211_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
		} else {
			ValaExpression* _tmp212_;
			ValaExpression* _tmp213_;
			gboolean _tmp214_;
			gboolean _tmp215_;
			ValaExpression* _tmp216_;
			ValaExpression* _tmp217_;
			ValaDataType* _tmp218_;
			ValaDataType* _tmp219_;
			ValaExpression* _tmp250_;
			ValaExpression* _tmp251_;
			gboolean _tmp266_ = FALSE;
			ValaExpression* _tmp267_;
			ValaExpression* _tmp268_;
			gboolean _tmp275_ = FALSE;
			ValaExpression* _tmp276_;
			ValaExpression* _tmp277_;
			gboolean _tmp298_ = FALSE;
			ValaExpression* _tmp299_;
			ValaExpression* _tmp300_;
			gboolean _tmp319_ = FALSE;
			ValaSymbol* _tmp320_;
			ValaSymbol* _tmp321_;
			gboolean _tmp355_ = FALSE;
			gboolean _tmp356_ = FALSE;
			ValaSymbol* _tmp357_;
			ValaSymbol* _tmp358_;
			ValaSymbol* _tmp609_;
			ValaSymbol* _tmp610_;
			_tmp212_ = vala_member_access_get_inner (self);
			_tmp213_ = _tmp212_;
			_tmp214_ = vala_code_node_get_error ((ValaCodeNode*) _tmp213_);
			_tmp215_ = _tmp214_;
			if (_tmp215_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				return result;
			}
			_tmp216_ = vala_member_access_get_inner (self);
			_tmp217_ = _tmp216_;
			_tmp218_ = vala_expression_get_value_type (_tmp217_);
			_tmp219_ = _tmp218_;
			if (VALA_IS_POINTER_TYPE (_tmp219_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp220_;
				ValaExpression* _tmp221_;
				ValaDataType* _tmp222_;
				ValaDataType* _tmp223_;
				gboolean _tmp224_ = FALSE;
				ValaPointerType* _tmp225_;
				_tmp220_ = vala_member_access_get_inner (self);
				_tmp221_ = _tmp220_;
				_tmp222_ = vala_expression_get_value_type (_tmp221_);
				_tmp223_ = _tmp222_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp223_) ? ((ValaPointerType*) _tmp223_) : NULL;
				_tmp225_ = pointer_type;
				if (_tmp225_ != NULL) {
					ValaPointerType* _tmp226_;
					ValaDataType* _tmp227_;
					ValaDataType* _tmp228_;
					_tmp226_ = pointer_type;
					_tmp227_ = vala_pointer_type_get_base_type (_tmp226_);
					_tmp228_ = _tmp227_;
					_tmp224_ = VALA_IS_VALUE_TYPE (_tmp228_);
				} else {
					_tmp224_ = FALSE;
				}
				if (_tmp224_) {
					ValaExpression* _tmp229_;
					ValaExpression* _tmp230_;
					ValaDataType* _tmp231_;
					ValaDataType* _tmp232_;
					ValaExpression* _tmp242_;
					ValaExpression* _tmp243_;
					ValaSourceReference* _tmp244_;
					ValaSourceReference* _tmp245_;
					ValaPointerIndirection* _tmp246_;
					ValaPointerIndirection* _tmp247_;
					ValaExpression* _tmp248_;
					ValaExpression* _tmp249_;
					_tmp229_ = vala_member_access_get_inner (self);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_expression_get_formal_value_type (_tmp230_);
					_tmp232_ = _tmp231_;
					if (VALA_IS_GENERIC_TYPE (_tmp232_)) {
						ValaExpression* _tmp233_;
						ValaExpression* _tmp234_;
						ValaPointerType* _tmp235_;
						ValaDataType* _tmp236_;
						ValaDataType* _tmp237_;
						ValaSourceReference* _tmp238_;
						ValaSourceReference* _tmp239_;
						ValaCastExpression* _tmp240_;
						ValaCastExpression* _tmp241_;
						_tmp233_ = vala_member_access_get_inner (self);
						_tmp234_ = _tmp233_;
						_tmp235_ = pointer_type;
						_tmp236_ = vala_data_type_copy ((ValaDataType*) _tmp235_);
						_tmp237_ = _tmp236_;
						_tmp238_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp239_ = _tmp238_;
						_tmp240_ = vala_cast_expression_new (_tmp234_, _tmp237_, _tmp239_);
						_tmp241_ = _tmp240_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp241_);
						_vala_code_node_unref0 (_tmp241_);
						_vala_code_node_unref0 (_tmp237_);
					}
					_tmp242_ = vala_member_access_get_inner (self);
					_tmp243_ = _tmp242_;
					_tmp244_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp245_ = _tmp244_;
					_tmp246_ = vala_pointer_indirection_new (_tmp243_, _tmp245_);
					_tmp247_ = _tmp246_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp247_);
					_vala_code_node_unref0 (_tmp247_);
					_tmp248_ = vala_member_access_get_inner (self);
					_tmp249_ = _tmp248_;
					vala_code_node_check ((ValaCodeNode*) _tmp249_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp250_ = vala_member_access_get_inner (self);
			_tmp251_ = _tmp250_;
			if (VALA_IS_MEMBER_ACCESS (_tmp251_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp252_;
				ValaExpression* _tmp253_;
				ValaMemberAccess* _tmp254_;
				gboolean _tmp255_;
				_tmp252_ = vala_member_access_get_inner (self);
				_tmp253_ = _tmp252_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp253_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp254_ = ma;
				_tmp255_ = _tmp254_->priv->_prototype_access;
				if (_tmp255_) {
					ValaSourceReference* _tmp256_;
					ValaSourceReference* _tmp257_;
					ValaExpression* _tmp258_;
					ValaExpression* _tmp259_;
					ValaSymbol* _tmp260_;
					ValaSymbol* _tmp261_;
					gchar* _tmp262_;
					gchar* _tmp263_;
					gchar* _tmp264_;
					gchar* _tmp265_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp256_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp257_ = _tmp256_;
					_tmp258_ = vala_member_access_get_inner (self);
					_tmp259_ = _tmp258_;
					_tmp260_ = vala_expression_get_symbol_reference (_tmp259_);
					_tmp261_ = _tmp260_;
					_tmp262_ = vala_symbol_get_full_name (_tmp261_);
					_tmp263_ = _tmp262_;
					_tmp264_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp263_);
					_tmp265_ = _tmp264_;
					vala_report_error (_tmp257_, _tmp265_);
					_g_free0 (_tmp265_);
					_g_free0 (_tmp263_);
					result = FALSE;
					return result;
				}
			}
			_tmp267_ = vala_member_access_get_inner (self);
			_tmp268_ = _tmp267_;
			if (VALA_IS_CAST_EXPRESSION (_tmp268_)) {
				ValaExpression* _tmp269_;
				ValaExpression* _tmp270_;
				gboolean _tmp271_;
				gboolean _tmp272_;
				_tmp269_ = vala_member_access_get_inner (self);
				_tmp270_ = _tmp269_;
				_tmp271_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp270_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp272_ = _tmp271_;
				_tmp266_ = _tmp272_;
			} else {
				_tmp266_ = FALSE;
			}
			if (_tmp266_) {
				ValaSourceReference* _tmp273_;
				ValaSourceReference* _tmp274_;
				_tmp273_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp274_ = _tmp273_;
				vala_report_warning (_tmp274_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp276_ = vala_member_access_get_inner (self);
			_tmp277_ = _tmp276_;
			if (VALA_IS_MEMBER_ACCESS (_tmp277_)) {
				_tmp275_ = TRUE;
			} else {
				ValaExpression* _tmp278_;
				ValaExpression* _tmp279_;
				_tmp278_ = vala_member_access_get_inner (self);
				_tmp279_ = _tmp278_;
				_tmp275_ = VALA_IS_BASE_ACCESS (_tmp279_);
			}
			if (_tmp275_) {
				ValaExpression* _tmp280_;
				ValaExpression* _tmp281_;
				ValaSymbol* _tmp282_;
				ValaSymbol* _tmp283_;
				gboolean _tmp284_ = FALSE;
				ValaSymbol* _tmp285_;
				ValaSymbol* _tmp286_;
				_tmp280_ = vala_member_access_get_inner (self);
				_tmp281_ = _tmp280_;
				_tmp282_ = vala_expression_get_symbol_reference (_tmp281_);
				_tmp283_ = _tmp282_;
				base_symbol = _tmp283_;
				_tmp285_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp286_ = _tmp285_;
				if (_tmp286_ == NULL) {
					gboolean _tmp287_ = FALSE;
					ValaSymbol* _tmp288_;
					_tmp288_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp288_)) {
						_tmp287_ = TRUE;
					} else {
						ValaSymbol* _tmp289_;
						_tmp289_ = base_symbol;
						_tmp287_ = VALA_IS_TYPESYMBOL (_tmp289_);
					}
					_tmp284_ = _tmp287_;
				} else {
					_tmp284_ = FALSE;
				}
				if (_tmp284_) {
					ValaSymbol* _tmp290_;
					ValaScope* _tmp291_;
					ValaScope* _tmp292_;
					const gchar* _tmp293_;
					ValaSymbol* _tmp294_;
					ValaSymbol* _tmp295_;
					ValaExpression* _tmp296_;
					ValaExpression* _tmp297_;
					_tmp290_ = base_symbol;
					_tmp291_ = vala_symbol_get_scope (_tmp290_);
					_tmp292_ = _tmp291_;
					_tmp293_ = self->priv->_member_name;
					_tmp294_ = vala_scope_lookup (_tmp292_, _tmp293_);
					_tmp295_ = _tmp294_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp295_);
					_vala_code_node_unref0 (_tmp295_);
					_tmp296_ = vala_member_access_get_inner (self);
					_tmp297_ = _tmp296_;
					if (VALA_IS_BASE_ACCESS (_tmp297_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp299_ = vala_member_access_get_inner (self);
			_tmp300_ = _tmp299_;
			if (VALA_IS_MEMBER_ACCESS (_tmp300_)) {
				ValaExpression* _tmp301_;
				ValaExpression* _tmp302_;
				ValaSymbol* _tmp303_;
				ValaSymbol* _tmp304_;
				_tmp301_ = vala_member_access_get_inner (self);
				_tmp302_ = _tmp301_;
				_tmp303_ = vala_expression_get_symbol_reference (_tmp302_);
				_tmp304_ = _tmp303_;
				_tmp298_ = VALA_IS_TYPEPARAMETER (_tmp304_);
			} else {
				_tmp298_ = FALSE;
			}
			if (_tmp298_) {
				ValaExpression* _tmp305_;
				ValaExpression* _tmp306_;
				ValaExpression* _tmp307_;
				ValaExpression* _tmp308_;
				ValaSymbol* _tmp309_;
				ValaSymbol* _tmp310_;
				ValaGenericType* _tmp311_;
				ValaGenericType* _tmp312_;
				ValaExpression* _tmp313_;
				ValaExpression* _tmp314_;
				ValaDataType* _tmp315_;
				ValaDataType* _tmp316_;
				ValaSourceReference* _tmp317_;
				ValaSourceReference* _tmp318_;
				_tmp305_ = vala_member_access_get_inner (self);
				_tmp306_ = _tmp305_;
				_tmp307_ = vala_member_access_get_inner (self);
				_tmp308_ = _tmp307_;
				_tmp309_ = vala_expression_get_symbol_reference (_tmp308_);
				_tmp310_ = _tmp309_;
				_tmp311_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp310_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp312_ = _tmp311_;
				vala_expression_set_value_type (_tmp306_, (ValaDataType*) _tmp312_);
				_vala_code_node_unref0 (_tmp312_);
				_tmp313_ = vala_member_access_get_inner (self);
				_tmp314_ = _tmp313_;
				_tmp315_ = vala_expression_get_value_type (_tmp314_);
				_tmp316_ = _tmp315_;
				_tmp317_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp318_ = _tmp317_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp316_, _tmp318_);
			}
			_tmp320_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp321_ = _tmp320_;
			if (_tmp321_ == NULL) {
				ValaExpression* _tmp322_;
				ValaExpression* _tmp323_;
				ValaDataType* _tmp324_;
				ValaDataType* _tmp325_;
				_tmp322_ = vala_member_access_get_inner (self);
				_tmp323_ = _tmp322_;
				_tmp324_ = vala_expression_get_value_type (_tmp323_);
				_tmp325_ = _tmp324_;
				_tmp319_ = _tmp325_ != NULL;
			} else {
				_tmp319_ = FALSE;
			}
			if (_tmp319_) {
				gboolean _tmp326_;
				ValaSymbol* _tmp353_;
				ValaSymbol* _tmp354_;
				_tmp326_ = self->priv->_pointer_member_access;
				if (_tmp326_) {
					ValaExpression* _tmp327_;
					ValaExpression* _tmp328_;
					ValaDataType* _tmp329_;
					ValaDataType* _tmp330_;
					const gchar* _tmp331_;
					ValaSymbol* _tmp332_;
					ValaSymbol* _tmp333_;
					_tmp327_ = vala_member_access_get_inner (self);
					_tmp328_ = _tmp327_;
					_tmp329_ = vala_expression_get_value_type (_tmp328_);
					_tmp330_ = _tmp329_;
					_tmp331_ = self->priv->_member_name;
					_tmp332_ = vala_data_type_get_pointer_member (_tmp330_, _tmp331_);
					_tmp333_ = _tmp332_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp333_);
					_vala_code_node_unref0 (_tmp333_);
				} else {
					ValaExpression* _tmp334_;
					ValaExpression* _tmp335_;
					ValaDataType* _tmp336_;
					ValaDataType* _tmp337_;
					ValaTypeSymbol* _tmp338_;
					ValaTypeSymbol* _tmp339_;
					ValaExpression* _tmp346_;
					ValaExpression* _tmp347_;
					ValaDataType* _tmp348_;
					ValaDataType* _tmp349_;
					const gchar* _tmp350_;
					ValaSymbol* _tmp351_;
					ValaSymbol* _tmp352_;
					_tmp334_ = vala_member_access_get_inner (self);
					_tmp335_ = _tmp334_;
					_tmp336_ = vala_expression_get_value_type (_tmp335_);
					_tmp337_ = _tmp336_;
					_tmp338_ = vala_data_type_get_type_symbol (_tmp337_);
					_tmp339_ = _tmp338_;
					if (_tmp339_ != NULL) {
						ValaExpression* _tmp340_;
						ValaExpression* _tmp341_;
						ValaDataType* _tmp342_;
						ValaDataType* _tmp343_;
						ValaTypeSymbol* _tmp344_;
						ValaTypeSymbol* _tmp345_;
						_tmp340_ = vala_member_access_get_inner (self);
						_tmp341_ = _tmp340_;
						_tmp342_ = vala_expression_get_value_type (_tmp341_);
						_tmp343_ = _tmp342_;
						_tmp344_ = vala_data_type_get_type_symbol (_tmp343_);
						_tmp345_ = _tmp344_;
						base_symbol = (ValaSymbol*) _tmp345_;
					}
					_tmp346_ = vala_member_access_get_inner (self);
					_tmp347_ = _tmp346_;
					_tmp348_ = vala_expression_get_value_type (_tmp347_);
					_tmp349_ = _tmp348_;
					_tmp350_ = self->priv->_member_name;
					_tmp351_ = vala_data_type_get_member (_tmp349_, _tmp350_);
					_tmp352_ = _tmp351_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp352_);
					_vala_code_node_unref0 (_tmp352_);
				}
				_tmp353_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp354_ = _tmp353_;
				if (_tmp354_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp357_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp358_ = _tmp357_;
			if (_tmp358_ == NULL) {
				ValaExpression* _tmp359_;
				ValaExpression* _tmp360_;
				ValaDataType* _tmp361_;
				ValaDataType* _tmp362_;
				_tmp359_ = vala_member_access_get_inner (self);
				_tmp360_ = _tmp359_;
				_tmp361_ = vala_expression_get_value_type (_tmp360_);
				_tmp362_ = _tmp361_;
				_tmp356_ = _tmp362_ != NULL;
			} else {
				_tmp356_ = FALSE;
			}
			if (_tmp356_) {
				ValaExpression* _tmp363_;
				ValaExpression* _tmp364_;
				ValaDataType* _tmp365_;
				ValaDataType* _tmp366_;
				gboolean _tmp367_;
				gboolean _tmp368_;
				_tmp363_ = vala_member_access_get_inner (self);
				_tmp364_ = _tmp363_;
				_tmp365_ = vala_expression_get_value_type (_tmp364_);
				_tmp366_ = _tmp365_;
				_tmp367_ = vala_data_type_get_is_dynamic (_tmp366_);
				_tmp368_ = _tmp367_;
				_tmp355_ = _tmp368_;
			} else {
				_tmp355_ = FALSE;
			}
			if (_tmp355_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp369_;
				ValaExpression* _tmp370_;
				ValaDataType* _tmp371_;
				ValaDataType* _tmp372_;
				ValaObjectType* _tmp373_;
				ValaCodeNode* _tmp374_;
				ValaCodeNode* _tmp375_;
				ValaSymbol* _tmp557_;
				ValaSymbol* _tmp558_;
				ValaSymbol* _tmp607_;
				ValaSymbol* _tmp608_;
				_tmp369_ = vala_member_access_get_inner (self);
				_tmp370_ = _tmp369_;
				_tmp371_ = vala_expression_get_value_type (_tmp370_);
				_tmp372_ = _tmp371_;
				_tmp373_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp372_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp373_;
				_tmp374_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp375_ = _tmp374_;
				if (VALA_IS_METHOD_CALL (_tmp375_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp376_;
					ValaCodeNode* _tmp377_;
					ValaMethodCall* _tmp378_;
					ValaExpression* _tmp379_;
					ValaExpression* _tmp380_;
					_tmp376_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp377_ = _tmp376_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp377_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp378_ = invoc;
					_tmp379_ = vala_method_call_get_call (_tmp378_);
					_tmp380_ = _tmp379_;
					if (_tmp380_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp381_;
						ValaDataType* _tmp382_;
						ValaDataType* _tmp383_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp398_;
						ValaExpression* _tmp399_;
						ValaDataType* _tmp400_;
						ValaDataType* _tmp401_;
						const gchar* _tmp402_;
						ValaDataType* _tmp403_;
						ValaSourceReference* _tmp404_;
						ValaSourceReference* _tmp405_;
						ValaDynamicMethod* _tmp406_;
						ValaDynamicMethod* _tmp407_;
						ValaMethodCall* _tmp408_;
						ValaErrorType* err = NULL;
						ValaDynamicMethod* _tmp409_;
						ValaSourceReference* _tmp410_;
						ValaSourceReference* _tmp411_;
						ValaErrorType* _tmp412_;
						ValaErrorType* _tmp413_;
						ValaDynamicMethod* _tmp414_;
						ValaErrorType* _tmp415_;
						ValaDynamicMethod* _tmp416_;
						ValaDynamicMethod* _tmp417_;
						ValaParameter* _tmp418_;
						ValaParameter* _tmp419_;
						ValaDynamicMethod* _tmp420_;
						ValaObjectType* _tmp421_;
						ValaDataType* _tmp422_;
						ValaDataType* _tmp423_;
						ValaDynamicMethod* _tmp424_;
						ValaSourceReference* _tmp425_;
						ValaSourceReference* _tmp426_;
						ValaParameter* _tmp427_;
						ValaParameter* _tmp428_;
						ValaObjectType* _tmp429_;
						ValaTypeSymbol* _tmp430_;
						ValaTypeSymbol* _tmp431_;
						ValaScope* _tmp432_;
						ValaScope* _tmp433_;
						ValaDynamicMethod* _tmp434_;
						ValaDynamicMethod* _tmp435_;
						_tmp381_ = invoc;
						_tmp382_ = vala_expression_get_target_type ((ValaExpression*) _tmp381_);
						_tmp383_ = _tmp382_;
						if (_tmp383_ != NULL) {
							ValaMethodCall* _tmp384_;
							ValaDataType* _tmp385_;
							ValaDataType* _tmp386_;
							ValaDataType* _tmp387_;
							ValaDataType* _tmp388_;
							_tmp384_ = invoc;
							_tmp385_ = vala_expression_get_target_type ((ValaExpression*) _tmp384_);
							_tmp386_ = _tmp385_;
							_tmp387_ = vala_data_type_copy (_tmp386_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp387_;
							_tmp388_ = ret_type;
							vala_data_type_set_value_owned (_tmp388_, TRUE);
						} else {
							ValaMethodCall* _tmp389_;
							ValaCodeNode* _tmp390_;
							ValaCodeNode* _tmp391_;
							_tmp389_ = invoc;
							_tmp390_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp389_);
							_tmp391_ = _tmp390_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp391_)) {
								ValaVoidType* _tmp392_;
								_tmp392_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp392_;
							} else {
								ValaExpression* _tmp393_;
								ValaExpression* _tmp394_;
								ValaDataType* _tmp395_;
								ValaDataType* _tmp396_;
								ValaDataType* _tmp397_;
								_tmp393_ = vala_member_access_get_inner (self);
								_tmp394_ = _tmp393_;
								_tmp395_ = vala_expression_get_value_type (_tmp394_);
								_tmp396_ = _tmp395_;
								_tmp397_ = vala_data_type_copy (_tmp396_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp397_;
							}
						}
						_tmp398_ = vala_member_access_get_inner (self);
						_tmp399_ = _tmp398_;
						_tmp400_ = vala_expression_get_value_type (_tmp399_);
						_tmp401_ = _tmp400_;
						_tmp402_ = self->priv->_member_name;
						_tmp403_ = ret_type;
						_tmp404_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp405_ = _tmp404_;
						_tmp406_ = vala_dynamic_method_new (_tmp401_, _tmp402_, _tmp403_, _tmp405_, NULL);
						m = _tmp406_;
						_tmp407_ = m;
						_tmp408_ = invoc;
						vala_dynamic_method_set_invocation (_tmp407_, _tmp408_);
						_tmp409_ = m;
						_tmp410_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp409_);
						_tmp411_ = _tmp410_;
						_tmp412_ = vala_error_type_new (NULL, NULL, _tmp411_);
						err = _tmp412_;
						_tmp413_ = err;
						vala_error_type_set_dynamic_error (_tmp413_, TRUE);
						_tmp414_ = m;
						_tmp415_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp414_, (ValaDataType*) _tmp415_);
						_tmp416_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp416_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp417_ = m;
						_tmp418_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp419_ = _tmp418_;
						vala_callable_add_parameter ((ValaCallable*) _tmp417_, _tmp419_);
						_vala_code_node_unref0 (_tmp419_);
						_tmp420_ = m;
						_tmp421_ = dynamic_object_type;
						_tmp422_ = vala_data_type_copy ((ValaDataType*) _tmp421_);
						_tmp423_ = _tmp422_;
						_tmp424_ = m;
						_tmp425_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp424_);
						_tmp426_ = _tmp425_;
						_tmp427_ = vala_parameter_new ("this", _tmp423_, _tmp426_);
						_tmp428_ = _tmp427_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp420_, _tmp428_);
						_vala_code_node_unref0 (_tmp428_);
						_vala_code_node_unref0 (_tmp423_);
						_tmp429_ = dynamic_object_type;
						_tmp430_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp429_);
						_tmp431_ = _tmp430_;
						_tmp432_ = vala_symbol_get_scope ((ValaSymbol*) _tmp431_);
						_tmp433_ = _tmp432_;
						_tmp434_ = m;
						vala_scope_add (_tmp433_, NULL, (ValaSymbol*) _tmp434_);
						_tmp435_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp435_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp436_;
					ValaCodeNode* _tmp437_;
					_tmp436_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp437_ = _tmp436_;
					if (VALA_IS_ASSIGNMENT (_tmp437_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp438_;
						ValaCodeNode* _tmp439_;
						ValaAssignment* _tmp440_;
						ValaExpression* _tmp441_;
						ValaExpression* _tmp442_;
						_tmp438_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp439_ = _tmp438_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp439_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp440_ = a;
						_tmp441_ = vala_assignment_get_left (_tmp440_);
						_tmp442_ = _tmp441_;
						if (_tmp442_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp443_;
							ValaExpression* _tmp444_;
							ValaDataType* _tmp445_;
							ValaDataType* _tmp446_;
							const gchar* _tmp447_;
							ValaSourceReference* _tmp448_;
							ValaSourceReference* _tmp449_;
							ValaDynamicProperty* _tmp450_;
							ValaDynamicProperty* _tmp451_;
							ValaDynamicProperty* _tmp452_;
							ValaDynamicProperty* _tmp453_;
							ValaSourceReference* _tmp454_;
							ValaSourceReference* _tmp455_;
							ValaPropertyAccessor* _tmp456_;
							ValaPropertyAccessor* _tmp457_;
							ValaDynamicProperty* _tmp458_;
							ValaExpression* _tmp459_;
							ValaExpression* _tmp460_;
							ValaDataType* _tmp461_;
							ValaDataType* _tmp462_;
							ValaTypeSymbol* _tmp463_;
							ValaTypeSymbol* _tmp464_;
							ValaScope* _tmp465_;
							ValaScope* _tmp466_;
							ValaObjectType* _tmp467_;
							ValaTypeSymbol* _tmp468_;
							ValaTypeSymbol* _tmp469_;
							ValaScope* _tmp470_;
							ValaScope* _tmp471_;
							ValaDynamicProperty* _tmp472_;
							ValaDynamicProperty* _tmp473_;
							_tmp443_ = vala_member_access_get_inner (self);
							_tmp444_ = _tmp443_;
							_tmp445_ = vala_expression_get_value_type (_tmp444_);
							_tmp446_ = _tmp445_;
							_tmp447_ = self->priv->_member_name;
							_tmp448_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp449_ = _tmp448_;
							_tmp450_ = vala_dynamic_property_new (_tmp446_, _tmp447_, _tmp449_, NULL);
							prop = _tmp450_;
							_tmp451_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp451_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp452_ = prop;
							_tmp453_ = prop;
							_tmp454_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp453_);
							_tmp455_ = _tmp454_;
							_tmp456_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp455_, NULL);
							_tmp457_ = _tmp456_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp452_, _tmp457_);
							_vala_code_node_unref0 (_tmp457_);
							_tmp458_ = prop;
							_tmp459_ = vala_member_access_get_inner (self);
							_tmp460_ = _tmp459_;
							_tmp461_ = vala_expression_get_value_type (_tmp460_);
							_tmp462_ = _tmp461_;
							_tmp463_ = vala_data_type_get_type_symbol (_tmp462_);
							_tmp464_ = _tmp463_;
							_tmp465_ = vala_symbol_get_scope ((ValaSymbol*) _tmp464_);
							_tmp466_ = _tmp465_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp458_, _tmp466_);
							_tmp467_ = dynamic_object_type;
							_tmp468_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp467_);
							_tmp469_ = _tmp468_;
							_tmp470_ = vala_symbol_get_scope ((ValaSymbol*) _tmp469_);
							_tmp471_ = _tmp470_;
							_tmp472_ = prop;
							vala_scope_add (_tmp471_, NULL, (ValaSymbol*) _tmp472_);
							_tmp473_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp473_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp474_ = FALSE;
						gboolean _tmp475_ = FALSE;
						ValaCodeNode* _tmp476_;
						ValaCodeNode* _tmp477_;
						_tmp476_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp477_ = _tmp476_;
						if (VALA_IS_MEMBER_ACCESS (_tmp477_)) {
							ValaExpression* _tmp478_;
							ValaExpression* _tmp479_;
							_tmp478_ = vala_member_access_get_inner (self);
							_tmp479_ = _tmp478_;
							_tmp475_ = VALA_IS_MEMBER_ACCESS (_tmp479_);
						} else {
							_tmp475_ = FALSE;
						}
						if (_tmp475_) {
							ValaCodeNode* _tmp480_;
							ValaCodeNode* _tmp481_;
							ValaCodeNode* _tmp482_;
							ValaCodeNode* _tmp483_;
							_tmp480_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp481_ = _tmp480_;
							_tmp482_ = vala_code_node_get_parent_node (_tmp481_);
							_tmp483_ = _tmp482_;
							_tmp474_ = VALA_IS_METHOD_CALL (_tmp483_);
						} else {
							_tmp474_ = FALSE;
						}
						if (_tmp474_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp484_;
							ValaCodeNode* _tmp485_;
							gboolean _tmp486_ = FALSE;
							ValaMemberAccess* _tmp487_;
							const gchar* _tmp488_;
							_tmp484_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp485_ = _tmp484_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp485_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp487_ = ma;
							_tmp488_ = _tmp487_->priv->_member_name;
							if (g_strcmp0 (_tmp488_, "connect") == 0) {
								_tmp486_ = TRUE;
							} else {
								ValaMemberAccess* _tmp489_;
								const gchar* _tmp490_;
								_tmp489_ = ma;
								_tmp490_ = _tmp489_->priv->_member_name;
								_tmp486_ = g_strcmp0 (_tmp490_, "connect_after") == 0;
							}
							if (_tmp486_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp491_;
								ValaExpression* _tmp492_;
								ValaDataType* _tmp493_;
								ValaDataType* _tmp494_;
								const gchar* _tmp495_;
								ValaVoidType* _tmp496_;
								ValaVoidType* _tmp497_;
								ValaSourceReference* _tmp498_;
								ValaSourceReference* _tmp499_;
								ValaDynamicSignal* _tmp500_;
								ValaDynamicSignal* _tmp501_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp502_;
								ValaCodeNode* _tmp503_;
								ValaCodeNode* _tmp504_;
								ValaCodeNode* _tmp505_;
								ValaMethodCall* _tmp506_;
								ValaMethodCall* _tmp507_;
								ValaList* _tmp508_;
								gint _tmp509_;
								gint _tmp510_;
								ValaDynamicSignal* _tmp544_;
								ValaObjectType* _tmp545_;
								ValaTypeSymbol* _tmp546_;
								ValaTypeSymbol* _tmp547_;
								ValaScope* _tmp548_;
								ValaScope* _tmp549_;
								ValaDynamicSignal* _tmp550_;
								ValaDynamicSignal* _tmp551_;
								_tmp491_ = vala_member_access_get_inner (self);
								_tmp492_ = _tmp491_;
								_tmp493_ = vala_expression_get_value_type (_tmp492_);
								_tmp494_ = _tmp493_;
								_tmp495_ = self->priv->_member_name;
								_tmp496_ = vala_void_type_new (NULL);
								_tmp497_ = _tmp496_;
								_tmp498_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp499_ = _tmp498_;
								_tmp500_ = vala_dynamic_signal_new (_tmp494_, _tmp495_, (ValaDataType*) _tmp497_, _tmp499_, NULL);
								_tmp501_ = _tmp500_;
								_vala_code_node_unref0 (_tmp497_);
								s = _tmp501_;
								_tmp502_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp503_ = _tmp502_;
								_tmp504_ = vala_code_node_get_parent_node (_tmp503_);
								_tmp505_ = _tmp504_;
								_tmp506_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp505_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp506_;
								_tmp507_ = mcall;
								_tmp508_ = vala_method_call_get_argument_list (_tmp507_);
								_tmp509_ = vala_collection_get_size ((ValaCollection*) _tmp508_);
								_tmp510_ = _tmp509_;
								if (_tmp510_ > 0) {
									ValaDynamicSignal* _tmp511_;
									ValaMethodCall* _tmp512_;
									ValaList* _tmp513_;
									gpointer _tmp514_;
									ValaExpression* _tmp515_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp516_;
									ValaExpression* _tmp517_;
									ValaExpression* _tmp518_;
									gboolean _tmp519_ = FALSE;
									gboolean _tmp520_ = FALSE;
									ValaMemberAccess* _tmp521_;
									_tmp511_ = s;
									_tmp512_ = mcall;
									_tmp513_ = vala_method_call_get_argument_list (_tmp512_);
									_tmp514_ = vala_list_get (_tmp513_, 0);
									_tmp515_ = (ValaExpression*) _tmp514_;
									vala_dynamic_signal_set_handler (_tmp511_, _tmp515_);
									_vala_code_node_unref0 (_tmp515_);
									_tmp516_ = s;
									_tmp517_ = vala_dynamic_signal_get_handler (_tmp516_);
									_tmp518_ = _tmp517_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp518_) ? ((ValaMemberAccess*) _tmp518_) : NULL;
									_tmp521_ = arg;
									if (_tmp521_ == NULL) {
										_tmp520_ = TRUE;
									} else {
										ValaMemberAccess* _tmp522_;
										_tmp522_ = arg;
										_tmp520_ = !vala_code_node_check ((ValaCodeNode*) _tmp522_, context);
									}
									if (_tmp520_) {
										_tmp519_ = TRUE;
									} else {
										ValaMemberAccess* _tmp523_;
										ValaSymbol* _tmp524_;
										ValaSymbol* _tmp525_;
										_tmp523_ = arg;
										_tmp524_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp523_);
										_tmp525_ = _tmp524_;
										_tmp519_ = !VALA_IS_METHOD (_tmp525_);
									}
									if (_tmp519_) {
										ValaDynamicSignal* _tmp526_;
										ValaExpression* _tmp527_;
										ValaExpression* _tmp528_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp526_ = s;
										_tmp527_ = vala_dynamic_signal_get_handler (_tmp526_);
										_tmp528_ = _tmp527_;
										if (VALA_IS_LAMBDA_EXPRESSION (_tmp528_)) {
											ValaDynamicSignal* _tmp529_;
											ValaExpression* _tmp530_;
											ValaExpression* _tmp531_;
											ValaSourceReference* _tmp532_;
											ValaSourceReference* _tmp533_;
											_tmp529_ = s;
											_tmp530_ = vala_dynamic_signal_get_handler (_tmp529_);
											_tmp531_ = _tmp530_;
											_tmp532_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp531_);
											_tmp533_ = _tmp532_;
											vala_report_error (_tmp533_, "Lambdas are not allowed for dynamic signals");
										} else {
											ValaDynamicSignal* _tmp534_;
											ValaExpression* _tmp535_;
											ValaExpression* _tmp536_;
											ValaSourceReference* _tmp537_;
											ValaSourceReference* _tmp538_;
											ValaDynamicSignal* _tmp539_;
											gchar* _tmp540_;
											gchar* _tmp541_;
											gchar* _tmp542_;
											gchar* _tmp543_;
											_tmp534_ = s;
											_tmp535_ = vala_dynamic_signal_get_handler (_tmp534_);
											_tmp536_ = _tmp535_;
											_tmp537_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp536_);
											_tmp538_ = _tmp537_;
											_tmp539_ = s;
											_tmp540_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp539_);
											_tmp541_ = _tmp540_;
											_tmp542_ = g_strdup_printf ("Cannot infer call signature for dynamic signal `%s' from given express" \
"ion", _tmp541_);
											_tmp543_ = _tmp542_;
											vala_report_error (_tmp538_, _tmp543_);
											_g_free0 (_tmp543_);
											_g_free0 (_tmp541_);
										}
									}
								}
								_tmp544_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp544_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp545_ = dynamic_object_type;
								_tmp546_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp545_);
								_tmp547_ = _tmp546_;
								_tmp548_ = vala_symbol_get_scope ((ValaSymbol*) _tmp547_);
								_tmp549_ = _tmp548_;
								_tmp550_ = s;
								vala_scope_add (_tmp549_, NULL, (ValaSymbol*) _tmp550_);
								_tmp551_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp551_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							} else {
								ValaMemberAccess* _tmp552_;
								const gchar* _tmp553_;
								_tmp552_ = ma;
								_tmp553_ = _tmp552_->priv->_member_name;
								if (g_strcmp0 (_tmp553_, "disconnect") == 0) {
									ValaMemberAccess* _tmp554_;
									ValaSourceReference* _tmp555_;
									ValaSourceReference* _tmp556_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp554_ = ma;
									_tmp555_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp554_);
									_tmp556_ = _tmp555_;
									vala_report_error (_tmp556_, "Use SignalHandler.disconnect() to disconnect from dynamic signal");
								}
							}
						}
					}
				}
				_tmp557_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp558_ = _tmp557_;
				if (_tmp558_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp559_;
					ValaExpression* _tmp560_;
					ValaDataType* _tmp561_;
					ValaDataType* _tmp562_;
					const gchar* _tmp563_;
					ValaSourceReference* _tmp564_;
					ValaSourceReference* _tmp565_;
					ValaDynamicProperty* _tmp566_;
					ValaDataType* _tmp567_;
					ValaDataType* _tmp568_;
					ValaDynamicProperty* _tmp579_;
					ValaDynamicProperty* _tmp580_;
					ValaDynamicProperty* _tmp581_;
					ValaDataType* _tmp582_;
					ValaDataType* _tmp583_;
					ValaDataType* _tmp584_;
					ValaDataType* _tmp585_;
					ValaDynamicProperty* _tmp586_;
					ValaSourceReference* _tmp587_;
					ValaSourceReference* _tmp588_;
					ValaPropertyAccessor* _tmp589_;
					ValaPropertyAccessor* _tmp590_;
					ValaDynamicProperty* _tmp591_;
					ValaExpression* _tmp592_;
					ValaExpression* _tmp593_;
					ValaDataType* _tmp594_;
					ValaDataType* _tmp595_;
					ValaTypeSymbol* _tmp596_;
					ValaTypeSymbol* _tmp597_;
					ValaScope* _tmp598_;
					ValaScope* _tmp599_;
					ValaObjectType* _tmp600_;
					ValaTypeSymbol* _tmp601_;
					ValaTypeSymbol* _tmp602_;
					ValaScope* _tmp603_;
					ValaScope* _tmp604_;
					ValaDynamicProperty* _tmp605_;
					ValaDynamicProperty* _tmp606_;
					_tmp559_ = vala_member_access_get_inner (self);
					_tmp560_ = _tmp559_;
					_tmp561_ = vala_expression_get_value_type (_tmp560_);
					_tmp562_ = _tmp561_;
					_tmp563_ = self->priv->_member_name;
					_tmp564_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp565_ = _tmp564_;
					_tmp566_ = vala_dynamic_property_new (_tmp562_, _tmp563_, _tmp565_, NULL);
					prop = _tmp566_;
					_tmp567_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp568_ = _tmp567_;
					if (_tmp568_ != NULL) {
						ValaDynamicProperty* _tmp569_;
						ValaDataType* _tmp570_;
						ValaDataType* _tmp571_;
						_tmp569_ = prop;
						_tmp570_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp571_ = _tmp570_;
						vala_property_set_property_type ((ValaProperty*) _tmp569_, _tmp571_);
					} else {
						ValaDynamicProperty* _tmp572_;
						ValaExpression* _tmp573_;
						ValaExpression* _tmp574_;
						ValaDataType* _tmp575_;
						ValaDataType* _tmp576_;
						ValaDataType* _tmp577_;
						ValaDataType* _tmp578_;
						_tmp572_ = prop;
						_tmp573_ = vala_member_access_get_inner (self);
						_tmp574_ = _tmp573_;
						_tmp575_ = vala_expression_get_value_type (_tmp574_);
						_tmp576_ = _tmp575_;
						_tmp577_ = vala_data_type_copy (_tmp576_);
						_tmp578_ = _tmp577_;
						vala_property_set_property_type ((ValaProperty*) _tmp572_, _tmp578_);
						_vala_code_node_unref0 (_tmp578_);
					}
					_tmp579_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp579_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp580_ = prop;
					_tmp581_ = prop;
					_tmp582_ = vala_property_get_property_type ((ValaProperty*) _tmp581_);
					_tmp583_ = _tmp582_;
					_tmp584_ = vala_data_type_copy (_tmp583_);
					_tmp585_ = _tmp584_;
					_tmp586_ = prop;
					_tmp587_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp586_);
					_tmp588_ = _tmp587_;
					_tmp589_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp585_, NULL, _tmp588_, NULL);
					_tmp590_ = _tmp589_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp580_, _tmp590_);
					_vala_code_node_unref0 (_tmp590_);
					_vala_code_node_unref0 (_tmp585_);
					_tmp591_ = prop;
					_tmp592_ = vala_member_access_get_inner (self);
					_tmp593_ = _tmp592_;
					_tmp594_ = vala_expression_get_value_type (_tmp593_);
					_tmp595_ = _tmp594_;
					_tmp596_ = vala_data_type_get_type_symbol (_tmp595_);
					_tmp597_ = _tmp596_;
					_tmp598_ = vala_symbol_get_scope ((ValaSymbol*) _tmp597_);
					_tmp599_ = _tmp598_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp591_, _tmp599_);
					_tmp600_ = dynamic_object_type;
					_tmp601_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp600_);
					_tmp602_ = _tmp601_;
					_tmp603_ = vala_symbol_get_scope ((ValaSymbol*) _tmp602_);
					_tmp604_ = _tmp603_;
					_tmp605_ = prop;
					vala_scope_add (_tmp604_, NULL, (ValaSymbol*) _tmp605_);
					_tmp606_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp606_);
					_vala_code_node_unref0 (prop);
				}
				_tmp607_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp608_ = _tmp607_;
				if (_tmp608_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp609_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp610_ = _tmp609_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp610_)) {
				ValaExpression* _tmp611_;
				ValaExpression* _tmp612_;
				ValaSymbol* _tmp613_;
				ValaSymbol* _tmp614_;
				_tmp611_ = vala_member_access_get_inner (self);
				_tmp612_ = _tmp611_;
				_tmp613_ = vala_expression_get_symbol_reference (_tmp612_);
				_tmp614_ = _tmp613_;
				if (VALA_IS_VARIABLE (_tmp614_)) {
					ValaArrayType* inner_type = NULL;
					ValaSemanticAnalyzer* _tmp615_;
					ValaSemanticAnalyzer* _tmp616_;
					ValaExpression* _tmp617_;
					ValaExpression* _tmp618_;
					ValaSymbol* _tmp619_;
					ValaSymbol* _tmp620_;
					ValaDataType* _tmp621_;
					ValaArrayType* _tmp622_;
					gboolean _tmp623_ = FALSE;
					ValaArrayType* _tmp624_;
					_tmp615_ = vala_code_context_get_analyzer (context);
					_tmp616_ = _tmp615_;
					_tmp617_ = vala_member_access_get_inner (self);
					_tmp618_ = _tmp617_;
					_tmp619_ = vala_expression_get_symbol_reference (_tmp618_);
					_tmp620_ = _tmp619_;
					_tmp621_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp616_, _tmp620_, TRUE);
					_tmp622_ = VALA_IS_ARRAY_TYPE (_tmp621_) ? ((ValaArrayType*) _tmp621_) : NULL;
					if (_tmp622_ == NULL) {
						_vala_code_node_unref0 (_tmp621_);
					}
					inner_type = _tmp622_;
					_tmp624_ = inner_type;
					if (_tmp624_ != NULL) {
						ValaArrayType* _tmp625_;
						gboolean _tmp626_;
						gboolean _tmp627_;
						_tmp625_ = inner_type;
						_tmp626_ = vala_array_type_get_inline_allocated (_tmp625_);
						_tmp627_ = _tmp626_;
						_tmp623_ = _tmp627_;
					} else {
						_tmp623_ = FALSE;
					}
					if (_tmp623_) {
						ValaSourceReference* _tmp628_;
						ValaSourceReference* _tmp629_;
						_tmp628_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp629_ = _tmp628_;
						vala_report_error (_tmp629_, "`resize' is not supported for arrays with fixed length");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					} else {
						gboolean _tmp630_ = FALSE;
						ValaArrayType* _tmp631_;
						_tmp631_ = inner_type;
						if (_tmp631_ != NULL) {
							ValaArrayType* _tmp632_;
							gboolean _tmp633_;
							gboolean _tmp634_;
							_tmp632_ = inner_type;
							_tmp633_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp632_);
							_tmp634_ = _tmp633_;
							_tmp630_ = !_tmp634_;
						} else {
							_tmp630_ = FALSE;
						}
						if (_tmp630_) {
							ValaSourceReference* _tmp635_;
							ValaSourceReference* _tmp636_;
							_tmp635_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp636_ = _tmp635_;
							vala_report_error (_tmp636_, "`resize' is not allowed for unowned array references");
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						}
					}
					_vala_code_node_unref0 (inner_type);
				} else {
					ValaExpression* _tmp637_;
					ValaExpression* _tmp638_;
					ValaSymbol* _tmp639_;
					ValaSymbol* _tmp640_;
					_tmp637_ = vala_member_access_get_inner (self);
					_tmp638_ = _tmp637_;
					_tmp639_ = vala_expression_get_symbol_reference (_tmp638_);
					_tmp640_ = _tmp639_;
					if (VALA_IS_CONSTANT (_tmp640_)) {
						ValaSourceReference* _tmp641_;
						ValaSourceReference* _tmp642_;
						_tmp641_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp642_ = _tmp641_;
						vala_report_error (_tmp642_, "`resize' is not allowed for constant arrays");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
			}
		}
	}
	_tmp646_ = vala_member_access_get_inner (self);
	_tmp647_ = _tmp646_;
	if (_tmp647_ == NULL) {
		ValaSymbol* _tmp648_;
		ValaSymbol* _tmp649_;
		_tmp648_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp649_ = _tmp648_;
		_tmp645_ = _tmp649_ == NULL;
	} else {
		_tmp645_ = FALSE;
	}
	if (_tmp645_) {
		ValaDataType* _tmp650_;
		ValaDataType* _tmp651_;
		_tmp650_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp651_ = _tmp650_;
		_tmp644_ = _tmp651_ != NULL;
	} else {
		_tmp644_ = FALSE;
	}
	if (_tmp644_) {
		ValaDataType* _tmp652_;
		ValaDataType* _tmp653_;
		ValaTypeSymbol* _tmp654_;
		ValaTypeSymbol* _tmp655_;
		_tmp652_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp653_ = _tmp652_;
		_tmp654_ = vala_data_type_get_type_symbol (_tmp653_);
		_tmp655_ = _tmp654_;
		_tmp643_ = VALA_IS_ENUM (_tmp655_);
	} else {
		_tmp643_ = FALSE;
	}
	if (_tmp643_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp656_;
		ValaDataType* _tmp657_;
		ValaTypeSymbol* _tmp658_;
		ValaTypeSymbol* _tmp659_;
		_tmp656_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp657_ = _tmp656_;
		_tmp658_ = vala_data_type_get_type_symbol (_tmp657_);
		_tmp659_ = _tmp658_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp659_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp660_;
			ValaList* _tmp661_;
			ValaList* _tmp662_;
			gint _val_size = 0;
			ValaList* _tmp663_;
			gint _tmp664_;
			gint _tmp665_;
			gint _val_index = 0;
			_tmp660_ = enum_type;
			_tmp661_ = vala_enum_get_values (_tmp660_);
			_tmp662_ = _vala_iterable_ref0 (_tmp661_);
			_val_list = _tmp662_;
			_tmp663_ = _val_list;
			_tmp664_ = vala_collection_get_size ((ValaCollection*) _tmp663_);
			_tmp665_ = _tmp664_;
			_val_size = _tmp665_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp666_;
				gint _tmp667_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp668_;
				gpointer _tmp669_;
				const gchar* _tmp670_;
				ValaEnumValue* _tmp671_;
				const gchar* _tmp672_;
				const gchar* _tmp673_;
				_val_index = _val_index + 1;
				_tmp666_ = _val_index;
				_tmp667_ = _val_size;
				if (!(_tmp666_ < _tmp667_)) {
					break;
				}
				_tmp668_ = _val_list;
				_tmp669_ = vala_list_get (_tmp668_, _val_index);
				val = (ValaEnumValue*) _tmp669_;
				_tmp670_ = self->priv->_member_name;
				_tmp671_ = val;
				_tmp672_ = vala_symbol_get_name ((ValaSymbol*) _tmp671_);
				_tmp673_ = _tmp672_;
				if (g_strcmp0 (_tmp670_, _tmp673_) == 0) {
					ValaEnumValue* _tmp674_;
					_tmp674_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp674_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
	}
	_tmp675_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp676_ = _tmp675_;
	if (_tmp676_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp677_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp678_ = FALSE;
		ValaExpression* _tmp679_;
		ValaExpression* _tmp680_;
		gchar* base_type_package = NULL;
		gchar* _tmp700_;
		gboolean _tmp701_ = FALSE;
		ValaSymbol* _tmp702_;
		ValaSourceReference* _tmp717_;
		ValaSourceReference* _tmp718_;
		const gchar* _tmp719_;
		const gchar* _tmp720_;
		const gchar* _tmp721_;
		gchar* _tmp722_;
		gchar* _tmp723_;
		ValaInvalidType* _tmp724_;
		ValaInvalidType* _tmp725_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp677_ = g_strdup ("(null)");
		base_type_name = _tmp677_;
		base_type = NULL;
		_tmp679_ = vala_member_access_get_inner (self);
		_tmp680_ = _tmp679_;
		if (_tmp680_ != NULL) {
			ValaExpression* _tmp681_;
			ValaExpression* _tmp682_;
			ValaDataType* _tmp683_;
			ValaDataType* _tmp684_;
			_tmp681_ = vala_member_access_get_inner (self);
			_tmp682_ = _tmp681_;
			_tmp683_ = vala_expression_get_value_type (_tmp682_);
			_tmp684_ = _tmp683_;
			_tmp678_ = _tmp684_ != NULL;
		} else {
			_tmp678_ = FALSE;
		}
		if (_tmp678_) {
			ValaExpression* _tmp685_;
			ValaExpression* _tmp686_;
			ValaDataType* _tmp687_;
			ValaDataType* _tmp688_;
			gchar* _tmp689_;
			ValaExpression* _tmp690_;
			ValaExpression* _tmp691_;
			ValaDataType* _tmp692_;
			ValaDataType* _tmp693_;
			ValaTypeSymbol* _tmp694_;
			ValaTypeSymbol* _tmp695_;
			_tmp685_ = vala_member_access_get_inner (self);
			_tmp686_ = _tmp685_;
			_tmp687_ = vala_expression_get_value_type (_tmp686_);
			_tmp688_ = _tmp687_;
			_tmp689_ = vala_code_node_to_string ((ValaCodeNode*) _tmp688_);
			_g_free0 (base_type_name);
			base_type_name = _tmp689_;
			_tmp690_ = vala_member_access_get_inner (self);
			_tmp691_ = _tmp690_;
			_tmp692_ = vala_expression_get_value_type (_tmp691_);
			_tmp693_ = _tmp692_;
			_tmp694_ = vala_data_type_get_type_symbol (_tmp693_);
			_tmp695_ = _tmp694_;
			base_type = (ValaSymbol*) _tmp695_;
		} else {
			ValaSymbol* _tmp696_;
			_tmp696_ = base_symbol;
			if (_tmp696_ != NULL) {
				ValaSymbol* _tmp697_;
				gchar* _tmp698_;
				ValaSymbol* _tmp699_;
				_tmp697_ = base_symbol;
				_tmp698_ = vala_symbol_get_full_name (_tmp697_);
				_g_free0 (base_type_name);
				base_type_name = _tmp698_;
				_tmp699_ = base_symbol;
				base_type = _tmp699_;
			}
		}
		_tmp700_ = g_strdup ("");
		base_type_package = _tmp700_;
		_tmp702_ = base_type;
		if (_tmp702_ != NULL) {
			ValaSymbol* _tmp703_;
			gboolean _tmp704_;
			gboolean _tmp705_;
			_tmp703_ = base_type;
			_tmp704_ = vala_symbol_get_external_package (_tmp703_);
			_tmp705_ = _tmp704_;
			_tmp701_ = _tmp705_;
		} else {
			_tmp701_ = FALSE;
		}
		if (_tmp701_) {
			ValaSymbol* _tmp706_;
			ValaSourceReference* _tmp707_;
			ValaSourceReference* _tmp708_;
			ValaSourceFile* _tmp709_;
			ValaSourceFile* _tmp710_;
			const gchar* _tmp711_;
			const gchar* _tmp712_;
			gchar* _tmp713_;
			const gchar* _tmp714_;
			_tmp706_ = base_symbol;
			_tmp707_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp706_);
			_tmp708_ = _tmp707_;
			_tmp709_ = vala_source_reference_get_file (_tmp708_);
			_tmp710_ = _tmp709_;
			_tmp711_ = vala_source_file_get_package_name (_tmp710_);
			_tmp712_ = _tmp711_;
			_tmp713_ = g_strdup (_tmp712_);
			_g_free0 (base_type_package);
			base_type_package = _tmp713_;
			_tmp714_ = base_type_package;
			if (_tmp714_ != NULL) {
				const gchar* _tmp715_;
				gchar* _tmp716_;
				_tmp715_ = base_type_package;
				_tmp716_ = g_strdup_printf (" (%s)", _tmp715_);
				_g_free0 (base_type_package);
				base_type_package = _tmp716_;
			}
		}
		_tmp717_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp718_ = _tmp717_;
		_tmp719_ = self->priv->_member_name;
		_tmp720_ = base_type_name;
		_tmp721_ = base_type_package;
		_tmp722_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'%s", _tmp719_, _tmp720_, _tmp721_);
		_tmp723_ = _tmp722_;
		vala_report_error (_tmp718_, _tmp723_);
		_g_free0 (_tmp723_);
		_tmp724_ = vala_invalid_type_new ();
		_tmp725_ = _tmp724_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp725_);
		_vala_code_node_unref0 (_tmp725_);
		result = FALSE;
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		return result;
	} else {
		ValaSymbol* _tmp726_;
		ValaSymbol* _tmp727_;
		gboolean _tmp728_;
		gboolean _tmp729_;
		_tmp726_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp727_ = _tmp726_;
		_tmp728_ = vala_code_node_get_error ((ValaCodeNode*) _tmp727_);
		_tmp729_ = _tmp728_;
		if (_tmp729_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp730_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp731_ = _tmp730_;
	if (VALA_IS_SIGNAL (_tmp731_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp732_;
		ValaSymbol* _tmp733_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp740_;
		ValaCodeNode* _tmp741_;
		ValaCodeNode* _tmp742_;
		gboolean _tmp743_ = FALSE;
		gboolean _tmp744_ = FALSE;
		gboolean _tmp745_ = FALSE;
		ValaCodeNode* _tmp746_;
		_tmp732_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp733_ = _tmp732_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp733_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp734_;
			ValaCodeNode* _tmp735_;
			ValaCodeNode* _tmp736_;
			ValaCodeNode* _tmp737_;
			ValaCodeNode* _tmp738_;
			ValaCodeNode* _tmp739_;
			_tmp734_ = ma;
			_tmp735_ = vala_code_node_get_parent_node (_tmp734_);
			_tmp736_ = _tmp735_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp736_)) {
				break;
			}
			_tmp737_ = ma;
			_tmp738_ = vala_code_node_get_parent_node (_tmp737_);
			_tmp739_ = _tmp738_;
			ma = _tmp739_;
		}
		_tmp740_ = ma;
		_tmp741_ = vala_code_node_get_parent_node (_tmp740_);
		_tmp742_ = _tmp741_;
		parent = _tmp742_;
		_tmp746_ = parent;
		if (_tmp746_ != NULL) {
			ValaCodeNode* _tmp747_;
			_tmp747_ = parent;
			_tmp745_ = !VALA_IS_ELEMENT_ACCESS (_tmp747_);
		} else {
			_tmp745_ = FALSE;
		}
		if (_tmp745_) {
			ValaCodeNode* _tmp748_;
			ValaExpression* _tmp749_;
			ValaExpression* _tmp750_;
			_tmp748_ = ma;
			_tmp749_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp748_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp750_ = _tmp749_;
			_tmp744_ = !VALA_IS_BASE_ACCESS (_tmp750_);
		} else {
			_tmp744_ = FALSE;
		}
		if (_tmp744_) {
			gboolean _tmp751_ = FALSE;
			ValaCodeNode* _tmp752_;
			_tmp752_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp752_)) {
				_tmp751_ = TRUE;
			} else {
				ValaCodeNode* _tmp753_;
				ValaList* _tmp754_;
				_tmp753_ = parent;
				_tmp754_ = vala_method_call_get_argument_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp753_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp751_ = vala_collection_contains ((ValaCollection*) _tmp754_, (ValaExpression*) self);
			}
			_tmp743_ = _tmp751_;
		} else {
			_tmp743_ = FALSE;
		}
		if (_tmp743_) {
			ValaSignal* _tmp755_;
			ValaAttribute* _tmp756_;
			_tmp755_ = sig;
			_tmp756_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp755_, "HasEmitter");
			if (_tmp756_ != NULL) {
				ValaSignal* _tmp757_;
				ValaSignal* _tmp758_;
				ValaMethod* _tmp759_;
				ValaMethod* _tmp760_;
				_tmp757_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp757_, context)) {
					result = FALSE;
					return result;
				}
				_tmp758_ = sig;
				_tmp759_ = vala_signal_get_emitter (_tmp758_);
				_tmp760_ = _tmp759_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp760_);
			} else {
				ValaSourceReference* _tmp761_;
				ValaSourceReference* _tmp762_;
				ValaSymbol* _tmp763_;
				ValaSymbol* _tmp764_;
				gchar* _tmp765_;
				gchar* _tmp766_;
				gchar* _tmp767_;
				gchar* _tmp768_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp761_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp762_ = _tmp761_;
				_tmp763_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp764_ = _tmp763_;
				_tmp765_ = vala_symbol_get_full_name (_tmp764_);
				_tmp766_ = _tmp765_;
				_tmp767_ = g_strdup_printf ("Signal `%s' requires emitter in this context", _tmp766_);
				_tmp768_ = _tmp767_;
				vala_report_error (_tmp762_, _tmp768_);
				_g_free0 (_tmp768_);
				_g_free0 (_tmp766_);
				result = FALSE;
				return result;
			}
		}
	}
	_tmp769_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp770_ = _tmp769_;
	member = _tmp770_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp771_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp771_, context)) {
		result = FALSE;
		return result;
	}
	_tmp772_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp772_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp773_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp774_;
		ValaSymbol* _tmp775_;
		ValaSymbol* _tmp776_;
		gboolean _tmp777_ = FALSE;
		ValaBlock* _tmp778_;
		_tmp773_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp773_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp774_ = local;
		_tmp775_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp774_);
		_tmp776_ = _tmp775_;
		block = VALA_IS_BLOCK (_tmp776_) ? ((ValaBlock*) _tmp776_) : NULL;
		_tmp778_ = block;
		if (_tmp778_ != NULL) {
			ValaBlock* _tmp779_;
			ValaSymbol* _tmp780_;
			ValaSemanticAnalyzer* _tmp781_;
			ValaSemanticAnalyzer* _tmp782_;
			ValaSymbol* _tmp783_;
			ValaSymbol* _tmp784_;
			_tmp779_ = block;
			_tmp780_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp779_);
			_tmp781_ = vala_code_context_get_analyzer (context);
			_tmp782_ = _tmp781_;
			_tmp783_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp782_);
			_tmp784_ = _tmp783_;
			_tmp777_ = _tmp780_ != _tmp784_;
		} else {
			_tmp777_ = FALSE;
		}
		if (_tmp777_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp785_;
			ValaSemanticAnalyzer* _tmp786_;
			ValaSymbol* _tmp787_;
			ValaSymbol* _tmp788_;
			ValaLocalVariable* _tmp799_;
			ValaBlock* _tmp800_;
			ValaLocalVariable* _tmp801_;
			ValaDataType* _tmp802_;
			ValaDataType* _tmp803_;
			ValaTypeSymbol* _tmp804_;
			ValaTypeSymbol* _tmp805_;
			ValaSemanticAnalyzer* _tmp806_;
			ValaSemanticAnalyzer* _tmp807_;
			ValaDataType* _tmp808_;
			ValaTypeSymbol* _tmp809_;
			ValaTypeSymbol* _tmp810_;
			_tmp785_ = vala_code_context_get_analyzer (context);
			_tmp786_ = _tmp785_;
			_tmp787_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp786_);
			_tmp788_ = _tmp787_;
			sym = _tmp788_;
			while (TRUE) {
				ValaSymbol* _tmp789_;
				ValaBlock* _tmp790_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp791_;
				ValaMethod* _tmp792_;
				ValaSymbol* _tmp796_;
				ValaSymbol* _tmp797_;
				ValaSymbol* _tmp798_;
				_tmp789_ = sym;
				_tmp790_ = block;
				if (!(_tmp789_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp790_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp791_ = sym;
				method = VALA_IS_METHOD (_tmp791_) ? ((ValaMethod*) _tmp791_) : NULL;
				_tmp792_ = method;
				if (_tmp792_ != NULL) {
					ValaMethod* _tmp793_;
					ValaMethod* _tmp794_;
					ValaLocalVariable* _tmp795_;
					_tmp793_ = method;
					vala_method_set_closure (_tmp793_, TRUE);
					_tmp794_ = method;
					_tmp795_ = local;
					vala_method_add_captured_variable (_tmp794_, _tmp795_);
				}
				_tmp796_ = sym;
				_tmp797_ = vala_symbol_get_parent_symbol (_tmp796_);
				_tmp798_ = _tmp797_;
				sym = _tmp798_;
			}
			_tmp799_ = local;
			vala_local_variable_set_captured (_tmp799_, TRUE);
			_tmp800_ = block;
			vala_block_set_captured (_tmp800_, TRUE);
			_tmp801_ = local;
			_tmp802_ = vala_variable_get_variable_type ((ValaVariable*) _tmp801_);
			_tmp803_ = _tmp802_;
			_tmp804_ = vala_data_type_get_type_symbol (_tmp803_);
			_tmp805_ = _tmp804_;
			_tmp806_ = vala_code_context_get_analyzer (context);
			_tmp807_ = _tmp806_;
			_tmp808_ = _tmp807_->va_list_type;
			_tmp809_ = vala_data_type_get_type_symbol (_tmp808_);
			_tmp810_ = _tmp809_;
			if (_tmp805_ == _tmp810_) {
				ValaSourceReference* _tmp811_;
				ValaSourceReference* _tmp812_;
				ValaLocalVariable* _tmp813_;
				gchar* _tmp814_;
				gchar* _tmp815_;
				gchar* _tmp816_;
				gchar* _tmp817_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp811_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp812_ = _tmp811_;
				_tmp813_ = local;
				_tmp814_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp813_);
				_tmp815_ = _tmp814_;
				_tmp816_ = g_strdup_printf ("Capturing `va_list' variable `%s' is not allowed", _tmp815_);
				_tmp817_ = _tmp816_;
				vala_report_error (_tmp812_, _tmp817_);
				_g_free0 (_tmp817_);
				_g_free0 (_tmp815_);
			}
		}
	} else {
		ValaSymbol* _tmp818_;
		_tmp818_ = member;
		if (VALA_IS_PARAMETER (_tmp818_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp819_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp820_;
			ValaSymbol* _tmp821_;
			ValaSymbol* _tmp822_;
			gboolean _tmp823_ = FALSE;
			gboolean _tmp824_ = FALSE;
			ValaMethod* _tmp825_;
			_tmp819_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp819_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp820_ = param;
			_tmp821_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp820_);
			_tmp822_ = _tmp821_;
			m = VALA_IS_METHOD (_tmp822_) ? ((ValaMethod*) _tmp822_) : NULL;
			_tmp825_ = m;
			if (_tmp825_ != NULL) {
				ValaMethod* _tmp826_;
				ValaSemanticAnalyzer* _tmp827_;
				ValaSemanticAnalyzer* _tmp828_;
				ValaSymbol* _tmp829_;
				ValaSymbol* _tmp830_;
				_tmp826_ = m;
				_tmp827_ = vala_code_context_get_analyzer (context);
				_tmp828_ = _tmp827_;
				_tmp829_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp828_);
				_tmp830_ = _tmp829_;
				_tmp824_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp826_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp830_;
			} else {
				_tmp824_ = FALSE;
			}
			if (_tmp824_) {
				ValaParameter* _tmp831_;
				ValaMethod* _tmp832_;
				ValaParameter* _tmp833_;
				ValaParameter* _tmp834_;
				_tmp831_ = param;
				_tmp832_ = m;
				_tmp833_ = vala_method_get_this_parameter (_tmp832_);
				_tmp834_ = _tmp833_;
				_tmp823_ = _tmp831_ != _tmp834_;
			} else {
				_tmp823_ = FALSE;
			}
			if (_tmp823_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp835_;
				ValaSemanticAnalyzer* _tmp836_;
				ValaSymbol* _tmp837_;
				ValaSymbol* _tmp838_;
				ValaParameter* _tmp847_;
				ValaMethod* _tmp848_;
				ValaBlock* _tmp849_;
				ValaBlock* _tmp850_;
				ValaParameter* _tmp851_;
				ValaParameterDirection _tmp852_;
				ValaParameterDirection _tmp853_;
				ValaParameter* _tmp861_;
				ValaDataType* _tmp862_;
				ValaDataType* _tmp863_;
				ValaTypeSymbol* _tmp864_;
				ValaTypeSymbol* _tmp865_;
				ValaSemanticAnalyzer* _tmp866_;
				ValaSemanticAnalyzer* _tmp867_;
				ValaDataType* _tmp868_;
				ValaTypeSymbol* _tmp869_;
				ValaTypeSymbol* _tmp870_;
				_tmp835_ = vala_code_context_get_analyzer (context);
				_tmp836_ = _tmp835_;
				_tmp837_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp836_);
				_tmp838_ = _tmp837_;
				sym = _tmp838_;
				while (TRUE) {
					ValaSymbol* _tmp839_;
					ValaMethod* _tmp840_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp841_;
					ValaMethod* _tmp842_;
					ValaSymbol* _tmp844_;
					ValaSymbol* _tmp845_;
					ValaSymbol* _tmp846_;
					_tmp839_ = sym;
					_tmp840_ = m;
					if (!(_tmp839_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp840_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp841_ = sym;
					method = VALA_IS_METHOD (_tmp841_) ? ((ValaMethod*) _tmp841_) : NULL;
					_tmp842_ = method;
					if (_tmp842_ != NULL) {
						ValaMethod* _tmp843_;
						_tmp843_ = method;
						vala_method_set_closure (_tmp843_, TRUE);
					}
					_tmp844_ = sym;
					_tmp845_ = vala_symbol_get_parent_symbol (_tmp844_);
					_tmp846_ = _tmp845_;
					sym = _tmp846_;
				}
				_tmp847_ = param;
				vala_parameter_set_captured (_tmp847_, TRUE);
				_tmp848_ = m;
				_tmp849_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp848_);
				_tmp850_ = _tmp849_;
				vala_block_set_captured (_tmp850_, TRUE);
				_tmp851_ = param;
				_tmp852_ = vala_parameter_get_direction (_tmp851_);
				_tmp853_ = _tmp852_;
				if (_tmp853_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp854_;
					ValaSourceReference* _tmp855_;
					ValaParameter* _tmp856_;
					gchar* _tmp857_;
					gchar* _tmp858_;
					gchar* _tmp859_;
					gchar* _tmp860_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp854_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp855_ = _tmp854_;
					_tmp856_ = param;
					_tmp857_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp856_);
					_tmp858_ = _tmp857_;
					_tmp859_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp858_);
					_tmp860_ = _tmp859_;
					vala_report_error (_tmp855_, _tmp860_);
					_g_free0 (_tmp860_);
					_g_free0 (_tmp858_);
				}
				_tmp861_ = param;
				_tmp862_ = vala_variable_get_variable_type ((ValaVariable*) _tmp861_);
				_tmp863_ = _tmp862_;
				_tmp864_ = vala_data_type_get_type_symbol (_tmp863_);
				_tmp865_ = _tmp864_;
				_tmp866_ = vala_code_context_get_analyzer (context);
				_tmp867_ = _tmp866_;
				_tmp868_ = _tmp867_->va_list_type;
				_tmp869_ = vala_data_type_get_type_symbol (_tmp868_);
				_tmp870_ = _tmp869_;
				if (_tmp865_ == _tmp870_) {
					ValaSourceReference* _tmp871_;
					ValaSourceReference* _tmp872_;
					ValaParameter* _tmp873_;
					gchar* _tmp874_;
					gchar* _tmp875_;
					gchar* _tmp876_;
					gchar* _tmp877_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp871_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp872_ = _tmp871_;
					_tmp873_ = param;
					_tmp874_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp873_);
					_tmp875_ = _tmp874_;
					_tmp876_ = g_strdup_printf ("Capturing `va_list' parameter `%s' is not allowed", _tmp875_);
					_tmp877_ = _tmp876_;
					vala_report_error (_tmp872_, _tmp877_);
					_g_free0 (_tmp877_);
					_g_free0 (_tmp875_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp878_;
				ValaSymbol* _tmp879_;
				ValaSymbol* _tmp880_;
				ValaSymbol* _tmp881_;
				ValaSymbol* _tmp882_;
				gboolean _tmp883_ = FALSE;
				gboolean _tmp884_ = FALSE;
				ValaPropertyAccessor* _tmp885_;
				_tmp878_ = param;
				_tmp879_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp878_);
				_tmp880_ = _tmp879_;
				_tmp881_ = vala_symbol_get_parent_symbol (_tmp880_);
				_tmp882_ = _tmp881_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp882_) ? ((ValaPropertyAccessor*) _tmp882_) : NULL;
				_tmp885_ = acc;
				if (_tmp885_ != NULL) {
					ValaPropertyAccessor* _tmp886_;
					ValaSemanticAnalyzer* _tmp887_;
					ValaSemanticAnalyzer* _tmp888_;
					ValaSymbol* _tmp889_;
					ValaSymbol* _tmp890_;
					_tmp886_ = acc;
					_tmp887_ = vala_code_context_get_analyzer (context);
					_tmp888_ = _tmp887_;
					_tmp889_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp888_);
					_tmp890_ = _tmp889_;
					_tmp884_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp886_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp890_;
				} else {
					_tmp884_ = FALSE;
				}
				if (_tmp884_) {
					ValaParameter* _tmp891_;
					ValaPropertyAccessor* _tmp892_;
					ValaProperty* _tmp893_;
					ValaProperty* _tmp894_;
					ValaParameter* _tmp895_;
					ValaParameter* _tmp896_;
					_tmp891_ = param;
					_tmp892_ = acc;
					_tmp893_ = vala_property_accessor_get_prop (_tmp892_);
					_tmp894_ = _tmp893_;
					_tmp895_ = vala_property_get_this_parameter (_tmp894_);
					_tmp896_ = _tmp895_;
					_tmp883_ = _tmp891_ != _tmp896_;
				} else {
					_tmp883_ = FALSE;
				}
				if (_tmp883_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp897_;
					ValaSemanticAnalyzer* _tmp898_;
					ValaSymbol* _tmp899_;
					ValaSymbol* _tmp900_;
					ValaParameter* _tmp909_;
					ValaPropertyAccessor* _tmp910_;
					ValaBlock* _tmp911_;
					ValaBlock* _tmp912_;
					_tmp897_ = vala_code_context_get_analyzer (context);
					_tmp898_ = _tmp897_;
					_tmp899_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp898_);
					_tmp900_ = _tmp899_;
					sym = _tmp900_;
					while (TRUE) {
						ValaSymbol* _tmp901_;
						ValaMethod* _tmp902_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp903_;
						ValaMethod* _tmp904_;
						ValaSymbol* _tmp906_;
						ValaSymbol* _tmp907_;
						ValaSymbol* _tmp908_;
						_tmp901_ = sym;
						_tmp902_ = m;
						if (!(_tmp901_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp902_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp903_ = sym;
						method = VALA_IS_METHOD (_tmp903_) ? ((ValaMethod*) _tmp903_) : NULL;
						_tmp904_ = method;
						if (_tmp904_ != NULL) {
							ValaMethod* _tmp905_;
							_tmp905_ = method;
							vala_method_set_closure (_tmp905_, TRUE);
						}
						_tmp906_ = sym;
						_tmp907_ = vala_symbol_get_parent_symbol (_tmp906_);
						_tmp908_ = _tmp907_;
						sym = _tmp908_;
					}
					_tmp909_ = param;
					vala_parameter_set_captured (_tmp909_, TRUE);
					_tmp910_ = acc;
					_tmp911_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp910_);
					_tmp912_ = _tmp911_;
					vala_block_set_captured (_tmp912_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp913_;
			_tmp913_ = member;
			if (VALA_IS_FIELD (_tmp913_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp914_;
				ValaField* _tmp915_;
				ValaSymbolAccessibility _tmp916_;
				ValaSymbolAccessibility _tmp917_;
				ValaField* _tmp918_;
				ValaMemberBinding _tmp919_;
				ValaMemberBinding _tmp920_;
				ValaField* _tmp921_;
				ValaMemberBinding _tmp922_;
				ValaMemberBinding _tmp923_;
				ValaField* _tmp924_;
				ValaDataType* _tmp925_;
				ValaDataType* _tmp926_;
				_tmp914_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp914_, VALA_TYPE_FIELD, ValaField);
				_tmp915_ = f;
				_tmp916_ = vala_symbol_get_access ((ValaSymbol*) _tmp915_);
				_tmp917_ = _tmp916_;
				access = _tmp917_;
				_tmp918_ = f;
				_tmp919_ = vala_field_get_binding (_tmp918_);
				_tmp920_ = _tmp919_;
				instance = _tmp920_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp921_ = f;
				_tmp922_ = vala_field_get_binding (_tmp921_);
				_tmp923_ = _tmp922_;
				klass = _tmp923_ == VALA_MEMBER_BINDING_CLASS;
				_tmp924_ = f;
				_tmp925_ = vala_variable_get_variable_type ((ValaVariable*) _tmp924_);
				_tmp926_ = _tmp925_;
				if (VALA_IS_GENERIC_TYPE (_tmp926_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp927_;
				_tmp927_ = member;
				if (VALA_IS_CONSTANT (_tmp927_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp928_;
					ValaConstant* _tmp929_;
					ValaSymbolAccessibility _tmp930_;
					ValaSymbolAccessibility _tmp931_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp932_;
					ValaSymbol* _tmp933_;
					ValaSymbol* _tmp934_;
					gboolean _tmp935_ = FALSE;
					ValaBlock* _tmp936_;
					_tmp928_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp928_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp929_ = c;
					_tmp930_ = vala_symbol_get_access ((ValaSymbol*) _tmp929_);
					_tmp931_ = _tmp930_;
					access = _tmp931_;
					_tmp932_ = c;
					_tmp933_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp932_);
					_tmp934_ = _tmp933_;
					block = VALA_IS_BLOCK (_tmp934_) ? ((ValaBlock*) _tmp934_) : NULL;
					_tmp936_ = block;
					if (_tmp936_ != NULL) {
						ValaBlock* _tmp937_;
						ValaSymbol* _tmp938_;
						ValaSemanticAnalyzer* _tmp939_;
						ValaSemanticAnalyzer* _tmp940_;
						ValaSymbol* _tmp941_;
						ValaSymbol* _tmp942_;
						_tmp937_ = block;
						_tmp938_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp937_);
						_tmp939_ = vala_code_context_get_analyzer (context);
						_tmp940_ = _tmp939_;
						_tmp941_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp940_);
						_tmp942_ = _tmp941_;
						_tmp935_ = _tmp938_ != _tmp942_;
					} else {
						_tmp935_ = FALSE;
					}
					if (_tmp935_) {
						ValaSourceReference* _tmp943_;
						ValaSourceReference* _tmp944_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp943_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp944_ = _tmp943_;
						vala_report_error (_tmp944_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						return result;
					}
				} else {
					ValaSymbol* _tmp945_;
					_tmp945_ = member;
					if (VALA_IS_METHOD (_tmp945_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp946_;
						ValaMethod* _tmp947_;
						gboolean _tmp948_;
						gboolean _tmp949_;
						ValaMethod* _tmp1038_;
						ValaSymbolAccessibility _tmp1039_;
						ValaSymbolAccessibility _tmp1040_;
						ValaMethod* _tmp1041_;
						ValaMethod* _tmp1045_;
						ValaMemberBinding _tmp1046_;
						ValaMemberBinding _tmp1047_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1068_;
						ValaDataType* _tmp1069_;
						ValaDataType* _tmp1070_;
						gboolean _tmp1071_ = FALSE;
						ValaGenericType* _tmp1072_;
						_tmp946_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp946_, VALA_TYPE_METHOD, ValaMethod);
						_tmp947_ = m;
						_tmp948_ = vala_method_get_is_async_callback (_tmp947_);
						_tmp949_ = _tmp948_;
						if (_tmp949_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp950_;
							ValaSemanticAnalyzer* _tmp951_;
							ValaMethod* _tmp952_;
							ValaMethod* _tmp953_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp954_;
							ValaMethod* _tmp983_;
							ValaSemanticAnalyzer* _tmp984_;
							ValaSemanticAnalyzer* _tmp985_;
							ValaMethod* _tmp986_;
							ValaMethod* _tmp987_;
							ValaMethod* _tmp1003_;
							ValaMethod* _tmp1004_;
							ValaMethod* _tmp1005_;
							ValaSymbol* _tmp1006_;
							ValaSymbol* _tmp1007_;
							_tmp950_ = vala_code_context_get_analyzer (context);
							_tmp951_ = _tmp950_;
							_tmp952_ = vala_semantic_analyzer_get_current_async_method (_tmp951_);
							_tmp953_ = _tmp952_;
							async_method = _tmp953_;
							is_valid_access = FALSE;
							_tmp954_ = async_method;
							if (_tmp954_ != NULL) {
								ValaMethod* _tmp955_;
								ValaMethod* _tmp956_;
								ValaMethod* _tmp957_;
								_tmp955_ = m;
								_tmp956_ = async_method;
								_tmp957_ = vala_method_get_callback_method (_tmp956_);
								if (_tmp955_ == _tmp957_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp958_ = FALSE;
									ValaMethod* _tmp959_;
									ValaMethod* _tmp960_;
									ValaMethod* _tmp961_;
									_tmp959_ = async_method;
									_tmp960_ = vala_method_get_base_method (_tmp959_);
									_tmp961_ = _tmp960_;
									if (_tmp961_ != NULL) {
										ValaMethod* _tmp962_;
										ValaMethod* _tmp963_;
										ValaMethod* _tmp964_;
										ValaMethod* _tmp965_;
										ValaMethod* _tmp966_;
										_tmp962_ = m;
										_tmp963_ = async_method;
										_tmp964_ = vala_method_get_base_method (_tmp963_);
										_tmp965_ = _tmp964_;
										_tmp966_ = vala_method_get_callback_method (_tmp965_);
										_tmp958_ = _tmp962_ == _tmp966_;
									} else {
										_tmp958_ = FALSE;
									}
									if (_tmp958_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp967_ = FALSE;
										ValaMethod* _tmp968_;
										ValaMethod* _tmp969_;
										ValaMethod* _tmp970_;
										_tmp968_ = async_method;
										_tmp969_ = vala_method_get_base_interface_method (_tmp968_);
										_tmp970_ = _tmp969_;
										if (_tmp970_ != NULL) {
											ValaMethod* _tmp971_;
											ValaMethod* _tmp972_;
											ValaMethod* _tmp973_;
											ValaMethod* _tmp974_;
											ValaMethod* _tmp975_;
											_tmp971_ = m;
											_tmp972_ = async_method;
											_tmp973_ = vala_method_get_base_interface_method (_tmp972_);
											_tmp974_ = _tmp973_;
											_tmp975_ = vala_method_get_callback_method (_tmp974_);
											_tmp967_ = _tmp971_ == _tmp975_;
										} else {
											_tmp967_ = FALSE;
										}
										if (_tmp967_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp976_;
								ValaSourceReference* _tmp977_;
								ValaMethod* _tmp978_;
								gchar* _tmp979_;
								gchar* _tmp980_;
								gchar* _tmp981_;
								gchar* _tmp982_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp976_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp977_ = _tmp976_;
								_tmp978_ = m;
								_tmp979_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp978_);
								_tmp980_ = _tmp979_;
								_tmp981_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp980_);
								_tmp982_ = _tmp981_;
								vala_report_error (_tmp977_, _tmp982_);
								_g_free0 (_tmp982_);
								_g_free0 (_tmp980_);
								result = FALSE;
								return result;
							}
							_tmp983_ = async_method;
							_tmp984_ = vala_code_context_get_analyzer (context);
							_tmp985_ = _tmp984_;
							_tmp986_ = vala_semantic_analyzer_get_current_method (_tmp985_);
							_tmp987_ = _tmp986_;
							if (_tmp983_ != _tmp987_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp988_;
								ValaSemanticAnalyzer* _tmp989_;
								ValaMethod* _tmp990_;
								ValaMethod* _tmp991_;
								ValaMethod* _tmp1000_;
								ValaBlock* _tmp1001_;
								ValaBlock* _tmp1002_;
								_tmp988_ = vala_code_context_get_analyzer (context);
								_tmp989_ = _tmp988_;
								_tmp990_ = vala_semantic_analyzer_get_current_method (_tmp989_);
								_tmp991_ = _tmp990_;
								sym = (ValaSymbol*) _tmp991_;
								while (TRUE) {
									ValaSymbol* _tmp992_;
									ValaMethod* _tmp993_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp994_;
									ValaMethod* _tmp995_;
									ValaSymbol* _tmp997_;
									ValaSymbol* _tmp998_;
									ValaSymbol* _tmp999_;
									_tmp992_ = sym;
									_tmp993_ = async_method;
									if (!(_tmp992_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp993_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp994_ = sym;
									method = VALA_IS_METHOD (_tmp994_) ? ((ValaMethod*) _tmp994_) : NULL;
									_tmp995_ = method;
									if (_tmp995_ != NULL) {
										ValaMethod* _tmp996_;
										_tmp996_ = method;
										vala_method_set_closure (_tmp996_, TRUE);
									}
									_tmp997_ = sym;
									_tmp998_ = vala_symbol_get_parent_symbol (_tmp997_);
									_tmp999_ = _tmp998_;
									sym = _tmp999_;
								}
								_tmp1000_ = async_method;
								_tmp1001_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1000_);
								_tmp1002_ = _tmp1001_;
								vala_block_set_captured (_tmp1002_, TRUE);
							}
							_tmp1003_ = async_method;
							_tmp1004_ = vala_method_get_callback_method (_tmp1003_);
							m = _tmp1004_;
							_tmp1005_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1005_);
							_tmp1006_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1007_ = _tmp1006_;
							member = _tmp1007_;
						} else {
							ValaMethod* _tmp1008_;
							ValaMethod* _tmp1009_;
							ValaMethod* _tmp1010_;
							_tmp1008_ = m;
							_tmp1009_ = vala_method_get_base_method (_tmp1008_);
							_tmp1010_ = _tmp1009_;
							if (_tmp1010_ != NULL) {
								ValaMethod* _tmp1011_;
								ValaMethod* _tmp1012_;
								ValaMethod* _tmp1013_;
								ValaMethod* _tmp1014_;
								ValaSignal* _tmp1015_;
								ValaSignal* _tmp1016_;
								ValaSymbol* _tmp1021_;
								ValaSymbol* _tmp1022_;
								_tmp1011_ = m;
								_tmp1012_ = vala_method_get_base_method (_tmp1011_);
								_tmp1013_ = _tmp1012_;
								m = _tmp1013_;
								_tmp1014_ = m;
								_tmp1015_ = vala_method_get_signal_reference (_tmp1014_);
								_tmp1016_ = _tmp1015_;
								if (_tmp1016_ != NULL) {
									ValaMethod* _tmp1017_;
									ValaSignal* _tmp1018_;
									ValaSignal* _tmp1019_;
									_tmp1017_ = m;
									_tmp1018_ = vala_method_get_signal_reference (_tmp1017_);
									_tmp1019_ = _tmp1018_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1019_);
								} else {
									ValaMethod* _tmp1020_;
									_tmp1020_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1020_);
								}
								_tmp1021_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1022_ = _tmp1021_;
								member = _tmp1022_;
							} else {
								ValaMethod* _tmp1023_;
								ValaMethod* _tmp1024_;
								ValaMethod* _tmp1025_;
								_tmp1023_ = m;
								_tmp1024_ = vala_method_get_base_interface_method (_tmp1023_);
								_tmp1025_ = _tmp1024_;
								if (_tmp1025_ != NULL) {
									ValaMethod* _tmp1026_;
									ValaMethod* _tmp1027_;
									ValaMethod* _tmp1028_;
									ValaMethod* _tmp1029_;
									ValaSignal* _tmp1030_;
									ValaSignal* _tmp1031_;
									ValaSymbol* _tmp1036_;
									ValaSymbol* _tmp1037_;
									_tmp1026_ = m;
									_tmp1027_ = vala_method_get_base_interface_method (_tmp1026_);
									_tmp1028_ = _tmp1027_;
									m = _tmp1028_;
									_tmp1029_ = m;
									_tmp1030_ = vala_method_get_signal_reference (_tmp1029_);
									_tmp1031_ = _tmp1030_;
									if (_tmp1031_ != NULL) {
										ValaMethod* _tmp1032_;
										ValaSignal* _tmp1033_;
										ValaSignal* _tmp1034_;
										_tmp1032_ = m;
										_tmp1033_ = vala_method_get_signal_reference (_tmp1032_);
										_tmp1034_ = _tmp1033_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1034_);
									} else {
										ValaMethod* _tmp1035_;
										_tmp1035_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1035_);
									}
									_tmp1036_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1037_ = _tmp1036_;
									member = _tmp1037_;
								}
							}
						}
						_tmp1038_ = m;
						_tmp1039_ = vala_symbol_get_access ((ValaSymbol*) _tmp1038_);
						_tmp1040_ = _tmp1039_;
						access = _tmp1040_;
						_tmp1041_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1041_)) {
							ValaMethod* _tmp1042_;
							ValaMemberBinding _tmp1043_;
							ValaMemberBinding _tmp1044_;
							_tmp1042_ = m;
							_tmp1043_ = vala_method_get_binding (_tmp1042_);
							_tmp1044_ = _tmp1043_;
							instance = _tmp1044_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1045_ = m;
						_tmp1046_ = vala_method_get_binding (_tmp1045_);
						_tmp1047_ = _tmp1046_;
						klass = _tmp1047_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1048_;
							ValaList* _tmp1049_;
							ValaList* _tmp1050_;
							gint _param_size = 0;
							ValaList* _tmp1051_;
							gint _tmp1052_;
							gint _tmp1053_;
							gint _param_index = 0;
							_tmp1048_ = m;
							_tmp1049_ = vala_callable_get_parameters ((ValaCallable*) _tmp1048_);
							_tmp1050_ = _vala_iterable_ref0 (_tmp1049_);
							_param_list = _tmp1050_;
							_tmp1051_ = _param_list;
							_tmp1052_ = vala_collection_get_size ((ValaCollection*) _tmp1051_);
							_tmp1053_ = _tmp1052_;
							_param_size = _tmp1053_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1054_;
								gint _tmp1055_;
								ValaParameter* param = NULL;
								ValaList* _tmp1056_;
								gpointer _tmp1057_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1058_;
								ValaDataType* _tmp1059_;
								ValaDataType* _tmp1060_;
								gboolean _tmp1061_ = FALSE;
								ValaGenericType* _tmp1062_;
								_param_index = _param_index + 1;
								_tmp1054_ = _param_index;
								_tmp1055_ = _param_size;
								if (!(_tmp1054_ < _tmp1055_)) {
									break;
								}
								_tmp1056_ = _param_list;
								_tmp1057_ = vala_list_get (_tmp1056_, _param_index);
								param = (ValaParameter*) _tmp1057_;
								_tmp1058_ = param;
								_tmp1059_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1058_);
								_tmp1060_ = _tmp1059_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1060_) ? ((ValaGenericType*) _tmp1060_) : NULL;
								_tmp1062_ = generic_type;
								if (_tmp1062_ != NULL) {
									ValaGenericType* _tmp1063_;
									ValaTypeParameter* _tmp1064_;
									ValaTypeParameter* _tmp1065_;
									ValaSymbol* _tmp1066_;
									ValaSymbol* _tmp1067_;
									_tmp1063_ = generic_type;
									_tmp1064_ = vala_generic_type_get_type_parameter (_tmp1063_);
									_tmp1065_ = _tmp1064_;
									_tmp1066_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1065_);
									_tmp1067_ = _tmp1066_;
									_tmp1061_ = VALA_IS_TYPESYMBOL (_tmp1067_);
								} else {
									_tmp1061_ = FALSE;
								}
								if (_tmp1061_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp1068_ = m;
						_tmp1069_ = vala_callable_get_return_type ((ValaCallable*) _tmp1068_);
						_tmp1070_ = _tmp1069_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1070_) ? ((ValaGenericType*) _tmp1070_) : NULL;
						_tmp1072_ = generic_type;
						if (_tmp1072_ != NULL) {
							ValaGenericType* _tmp1073_;
							ValaTypeParameter* _tmp1074_;
							ValaTypeParameter* _tmp1075_;
							ValaSymbol* _tmp1076_;
							ValaSymbol* _tmp1077_;
							_tmp1073_ = generic_type;
							_tmp1074_ = vala_generic_type_get_type_parameter (_tmp1073_);
							_tmp1075_ = _tmp1074_;
							_tmp1076_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1075_);
							_tmp1077_ = _tmp1076_;
							_tmp1071_ = VALA_IS_TYPESYMBOL (_tmp1077_);
						} else {
							_tmp1071_ = FALSE;
						}
						if (_tmp1071_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1078_;
						_tmp1078_ = member;
						if (VALA_IS_PROPERTY (_tmp1078_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1079_;
							ValaProperty* _tmp1080_;
							ValaProperty* _tmp1081_;
							ValaProperty* _tmp1082_;
							ValaProperty* _tmp1083_;
							ValaProperty* _tmp1099_;
							ValaSymbolAccessibility _tmp1100_;
							ValaSymbolAccessibility _tmp1101_;
							gboolean _tmp1102_;
							gboolean _tmp1103_;
							ValaProperty* _tmp1208_;
							ValaMemberBinding _tmp1209_;
							ValaMemberBinding _tmp1210_;
							ValaProperty* _tmp1211_;
							ValaDataType* _tmp1212_;
							ValaDataType* _tmp1213_;
							_tmp1079_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1079_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1080_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1080_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								return result;
							}
							_tmp1081_ = prop;
							_tmp1082_ = vala_property_get_base_property (_tmp1081_);
							_tmp1083_ = _tmp1082_;
							if (_tmp1083_ != NULL) {
								ValaProperty* _tmp1084_;
								ValaProperty* _tmp1085_;
								ValaProperty* _tmp1086_;
								ValaProperty* _tmp1087_;
								ValaSymbol* _tmp1088_;
								ValaSymbol* _tmp1089_;
								_tmp1084_ = prop;
								_tmp1085_ = vala_property_get_base_property (_tmp1084_);
								_tmp1086_ = _tmp1085_;
								prop = _tmp1086_;
								_tmp1087_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1087_);
								_tmp1088_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1089_ = _tmp1088_;
								member = _tmp1089_;
							} else {
								ValaProperty* _tmp1090_;
								ValaProperty* _tmp1091_;
								ValaProperty* _tmp1092_;
								_tmp1090_ = prop;
								_tmp1091_ = vala_property_get_base_interface_property (_tmp1090_);
								_tmp1092_ = _tmp1091_;
								if (_tmp1092_ != NULL) {
									ValaProperty* _tmp1093_;
									ValaProperty* _tmp1094_;
									ValaProperty* _tmp1095_;
									ValaProperty* _tmp1096_;
									ValaSymbol* _tmp1097_;
									ValaSymbol* _tmp1098_;
									_tmp1093_ = prop;
									_tmp1094_ = vala_property_get_base_interface_property (_tmp1093_);
									_tmp1095_ = _tmp1094_;
									prop = _tmp1095_;
									_tmp1096_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1096_);
									_tmp1097_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1098_ = _tmp1097_;
									member = _tmp1098_;
								}
							}
							_tmp1099_ = prop;
							_tmp1100_ = vala_symbol_get_access ((ValaSymbol*) _tmp1099_);
							_tmp1101_ = _tmp1100_;
							access = _tmp1101_;
							_tmp1102_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1103_ = _tmp1102_;
							if (_tmp1103_) {
								ValaProperty* _tmp1104_;
								ValaPropertyAccessor* _tmp1105_;
								ValaPropertyAccessor* _tmp1106_;
								ValaProperty* _tmp1154_;
								ValaSymbolAccessibility _tmp1155_;
								ValaSymbolAccessibility _tmp1156_;
								_tmp1104_ = prop;
								_tmp1105_ = vala_property_get_set_accessor (_tmp1104_);
								_tmp1106_ = _tmp1105_;
								if (_tmp1106_ == NULL) {
									ValaSourceReference* _tmp1107_;
									ValaSourceReference* _tmp1108_;
									ValaProperty* _tmp1109_;
									gchar* _tmp1110_;
									gchar* _tmp1111_;
									gchar* _tmp1112_;
									gchar* _tmp1113_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1107_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1108_ = _tmp1107_;
									_tmp1109_ = prop;
									_tmp1110_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1109_);
									_tmp1111_ = _tmp1110_;
									_tmp1112_ = g_strdup_printf ("Property `%s' is read-only", _tmp1111_);
									_tmp1113_ = _tmp1112_;
									vala_report_error (_tmp1108_, _tmp1113_);
									_g_free0 (_tmp1113_);
									_g_free0 (_tmp1111_);
									result = FALSE;
									return result;
								} else {
									gboolean _tmp1114_ = FALSE;
									ValaProperty* _tmp1115_;
									ValaPropertyAccessor* _tmp1116_;
									ValaPropertyAccessor* _tmp1117_;
									gboolean _tmp1118_;
									gboolean _tmp1119_;
									_tmp1115_ = prop;
									_tmp1116_ = vala_property_get_set_accessor (_tmp1115_);
									_tmp1117_ = _tmp1116_;
									_tmp1118_ = vala_property_accessor_get_writable (_tmp1117_);
									_tmp1119_ = _tmp1118_;
									if (!_tmp1119_) {
										ValaProperty* _tmp1120_;
										ValaPropertyAccessor* _tmp1121_;
										ValaPropertyAccessor* _tmp1122_;
										gboolean _tmp1123_;
										gboolean _tmp1124_;
										_tmp1120_ = prop;
										_tmp1121_ = vala_property_get_set_accessor (_tmp1120_);
										_tmp1122_ = _tmp1121_;
										_tmp1123_ = vala_property_accessor_get_construction (_tmp1122_);
										_tmp1124_ = _tmp1123_;
										_tmp1114_ = _tmp1124_;
									} else {
										_tmp1114_ = FALSE;
									}
									if (_tmp1114_) {
										ValaSemanticAnalyzer* _tmp1125_;
										ValaSemanticAnalyzer* _tmp1126_;
										ValaMethod* _tmp1127_;
										_tmp1125_ = vala_code_context_get_analyzer (context);
										_tmp1126_ = _tmp1125_;
										_tmp1127_ = vala_semantic_analyzer_find_current_method (_tmp1126_);
										if (VALA_IS_CREATION_METHOD (_tmp1127_)) {
											ValaSourceReference* _tmp1128_;
											ValaSourceReference* _tmp1129_;
											vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
											_tmp1128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
											_tmp1129_ = _tmp1128_;
											vala_report_error (_tmp1129_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
											result = FALSE;
											return result;
										} else {
											ValaSemanticAnalyzer* _tmp1130_;
											ValaSemanticAnalyzer* _tmp1131_;
											_tmp1130_ = vala_code_context_get_analyzer (context);
											_tmp1131_ = _tmp1130_;
											if (vala_semantic_analyzer_is_in_constructor (_tmp1131_)) {
												ValaSemanticAnalyzer* _tmp1132_;
												ValaSemanticAnalyzer* _tmp1133_;
												ValaTypeSymbol* _tmp1134_;
												ValaTypeSymbol* _tmp1135_;
												ValaProperty* _tmp1136_;
												ValaSymbol* _tmp1137_;
												ValaSymbol* _tmp1138_;
												_tmp1132_ = vala_code_context_get_analyzer (context);
												_tmp1133_ = _tmp1132_;
												_tmp1134_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1133_);
												_tmp1135_ = _tmp1134_;
												_tmp1136_ = prop;
												_tmp1137_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1136_);
												_tmp1138_ = _tmp1137_;
												if (!vala_typesymbol_is_subtype_of (_tmp1135_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1138_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))) {
													ValaSourceReference* _tmp1139_;
													ValaSourceReference* _tmp1140_;
													ValaProperty* _tmp1141_;
													gchar* _tmp1142_;
													gchar* _tmp1143_;
													ValaSemanticAnalyzer* _tmp1144_;
													ValaSemanticAnalyzer* _tmp1145_;
													ValaTypeSymbol* _tmp1146_;
													ValaTypeSymbol* _tmp1147_;
													gchar* _tmp1148_;
													gchar* _tmp1149_;
													gchar* _tmp1150_;
													gchar* _tmp1151_;
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													_tmp1139_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1140_ = _tmp1139_;
													_tmp1141_ = prop;
													_tmp1142_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1141_);
													_tmp1143_ = _tmp1142_;
													_tmp1144_ = vala_code_context_get_analyzer (context);
													_tmp1145_ = _tmp1144_;
													_tmp1146_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1145_);
													_tmp1147_ = _tmp1146_;
													_tmp1148_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1147_);
													_tmp1149_ = _tmp1148_;
													_tmp1150_ = g_strdup_printf ("Cannot assign to construct-only property `%s' in `construct' of `%s'", _tmp1143_, _tmp1149_);
													_tmp1151_ = _tmp1150_;
													vala_report_error (_tmp1140_, _tmp1151_);
													_g_free0 (_tmp1151_);
													_g_free0 (_tmp1149_);
													_g_free0 (_tmp1143_);
													result = FALSE;
													return result;
												}
											} else {
												ValaSourceReference* _tmp1152_;
												ValaSourceReference* _tmp1153_;
												vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
												_tmp1152_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1153_ = _tmp1152_;
												vala_report_error (_tmp1153_, "Cannot assign to construct-only property in this context");
												result = FALSE;
												return result;
											}
										}
									}
								}
								_tmp1154_ = prop;
								_tmp1155_ = vala_symbol_get_access ((ValaSymbol*) _tmp1154_);
								_tmp1156_ = _tmp1155_;
								if (_tmp1156_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1157_;
									ValaPropertyAccessor* _tmp1158_;
									ValaPropertyAccessor* _tmp1159_;
									ValaSymbolAccessibility _tmp1160_;
									ValaSymbolAccessibility _tmp1161_;
									_tmp1157_ = prop;
									_tmp1158_ = vala_property_get_set_accessor (_tmp1157_);
									_tmp1159_ = _tmp1158_;
									_tmp1160_ = vala_symbol_get_access ((ValaSymbol*) _tmp1159_);
									_tmp1161_ = _tmp1160_;
									access = _tmp1161_;
								} else {
									gboolean _tmp1162_ = FALSE;
									ValaProperty* _tmp1163_;
									ValaSymbolAccessibility _tmp1164_;
									ValaSymbolAccessibility _tmp1165_;
									_tmp1163_ = prop;
									_tmp1164_ = vala_symbol_get_access ((ValaSymbol*) _tmp1163_);
									_tmp1165_ = _tmp1164_;
									if (_tmp1165_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1166_;
										ValaPropertyAccessor* _tmp1167_;
										ValaPropertyAccessor* _tmp1168_;
										ValaSymbolAccessibility _tmp1169_;
										ValaSymbolAccessibility _tmp1170_;
										_tmp1166_ = prop;
										_tmp1167_ = vala_property_get_set_accessor (_tmp1166_);
										_tmp1168_ = _tmp1167_;
										_tmp1169_ = vala_symbol_get_access ((ValaSymbol*) _tmp1168_);
										_tmp1170_ = _tmp1169_;
										_tmp1162_ = _tmp1170_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1162_ = FALSE;
									}
									if (_tmp1162_) {
										ValaProperty* _tmp1171_;
										ValaPropertyAccessor* _tmp1172_;
										ValaPropertyAccessor* _tmp1173_;
										ValaSymbolAccessibility _tmp1174_;
										ValaSymbolAccessibility _tmp1175_;
										_tmp1171_ = prop;
										_tmp1172_ = vala_property_get_set_accessor (_tmp1171_);
										_tmp1173_ = _tmp1172_;
										_tmp1174_ = vala_symbol_get_access ((ValaSymbol*) _tmp1173_);
										_tmp1175_ = _tmp1174_;
										access = _tmp1175_;
									}
								}
							} else {
								ValaProperty* _tmp1176_;
								ValaPropertyAccessor* _tmp1177_;
								ValaPropertyAccessor* _tmp1178_;
								ValaProperty* _tmp1186_;
								ValaSymbolAccessibility _tmp1187_;
								ValaSymbolAccessibility _tmp1188_;
								_tmp1176_ = prop;
								_tmp1177_ = vala_property_get_get_accessor (_tmp1176_);
								_tmp1178_ = _tmp1177_;
								if (_tmp1178_ == NULL) {
									ValaSourceReference* _tmp1179_;
									ValaSourceReference* _tmp1180_;
									ValaProperty* _tmp1181_;
									gchar* _tmp1182_;
									gchar* _tmp1183_;
									gchar* _tmp1184_;
									gchar* _tmp1185_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1179_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1180_ = _tmp1179_;
									_tmp1181_ = prop;
									_tmp1182_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1181_);
									_tmp1183_ = _tmp1182_;
									_tmp1184_ = g_strdup_printf ("Property `%s' is write-only", _tmp1183_);
									_tmp1185_ = _tmp1184_;
									vala_report_error (_tmp1180_, _tmp1185_);
									_g_free0 (_tmp1185_);
									_g_free0 (_tmp1183_);
									result = FALSE;
									return result;
								}
								_tmp1186_ = prop;
								_tmp1187_ = vala_symbol_get_access ((ValaSymbol*) _tmp1186_);
								_tmp1188_ = _tmp1187_;
								if (_tmp1188_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1189_;
									ValaPropertyAccessor* _tmp1190_;
									ValaPropertyAccessor* _tmp1191_;
									ValaSymbolAccessibility _tmp1192_;
									ValaSymbolAccessibility _tmp1193_;
									_tmp1189_ = prop;
									_tmp1190_ = vala_property_get_get_accessor (_tmp1189_);
									_tmp1191_ = _tmp1190_;
									_tmp1192_ = vala_symbol_get_access ((ValaSymbol*) _tmp1191_);
									_tmp1193_ = _tmp1192_;
									access = _tmp1193_;
								} else {
									gboolean _tmp1194_ = FALSE;
									ValaProperty* _tmp1195_;
									ValaSymbolAccessibility _tmp1196_;
									ValaSymbolAccessibility _tmp1197_;
									_tmp1195_ = prop;
									_tmp1196_ = vala_symbol_get_access ((ValaSymbol*) _tmp1195_);
									_tmp1197_ = _tmp1196_;
									if (_tmp1197_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1198_;
										ValaPropertyAccessor* _tmp1199_;
										ValaPropertyAccessor* _tmp1200_;
										ValaSymbolAccessibility _tmp1201_;
										ValaSymbolAccessibility _tmp1202_;
										_tmp1198_ = prop;
										_tmp1199_ = vala_property_get_get_accessor (_tmp1198_);
										_tmp1200_ = _tmp1199_;
										_tmp1201_ = vala_symbol_get_access ((ValaSymbol*) _tmp1200_);
										_tmp1202_ = _tmp1201_;
										_tmp1194_ = _tmp1202_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1194_ = FALSE;
									}
									if (_tmp1194_) {
										ValaProperty* _tmp1203_;
										ValaPropertyAccessor* _tmp1204_;
										ValaPropertyAccessor* _tmp1205_;
										ValaSymbolAccessibility _tmp1206_;
										ValaSymbolAccessibility _tmp1207_;
										_tmp1203_ = prop;
										_tmp1204_ = vala_property_get_get_accessor (_tmp1203_);
										_tmp1205_ = _tmp1204_;
										_tmp1206_ = vala_symbol_get_access ((ValaSymbol*) _tmp1205_);
										_tmp1207_ = _tmp1206_;
										access = _tmp1207_;
									}
								}
							}
							_tmp1208_ = prop;
							_tmp1209_ = vala_property_get_binding (_tmp1208_);
							_tmp1210_ = _tmp1209_;
							instance = _tmp1210_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1211_ = prop;
							_tmp1212_ = vala_property_get_property_type (_tmp1211_);
							_tmp1213_ = _tmp1212_;
							if (VALA_IS_GENERIC_TYPE (_tmp1213_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1214_;
							_tmp1214_ = member;
							if (VALA_IS_SIGNAL (_tmp1214_)) {
								ValaSymbol* _tmp1215_;
								ValaSymbolAccessibility _tmp1216_;
								ValaSymbolAccessibility _tmp1217_;
								instance = TRUE;
								_tmp1215_ = member;
								_tmp1216_ = vala_symbol_get_access (_tmp1215_);
								_tmp1217_ = _tmp1216_;
								access = _tmp1217_;
							} else {
								gboolean _tmp1218_ = FALSE;
								gboolean _tmp1219_;
								_tmp1219_ = self->priv->_creation_member;
								if (!_tmp1219_) {
									ValaSymbol* _tmp1220_;
									_tmp1220_ = member;
									_tmp1218_ = VALA_IS_ERROR_CODE (_tmp1220_);
								} else {
									_tmp1218_ = FALSE;
								}
								if (_tmp1218_) {
									ValaSymbol* _tmp1221_;
									ValaConstant* _tmp1222_;
									ValaConstant* _tmp1223_;
									ValaSymbol* _tmp1224_;
									ValaSymbol* _tmp1225_;
									_tmp1221_ = member;
									_tmp1222_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1221_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1223_ = _tmp1222_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1223_);
									_tmp1224_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1225_ = _tmp1224_;
									member = _tmp1225_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1226_;
		ValaSymbol* _tmp1227_;
		ValaCodeNode* _tmp1228_;
		ValaCodeNode* _tmp1229_;
		ValaCodeNode* _tmp1230_;
		gboolean _tmp1231_ = FALSE;
		ValaCodeNode* _tmp1232_;
		_tmp1226_ = parent;
		_tmp1227_ = member;
		if (!(_tmp1226_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1227_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1228_ = parent;
		_tmp1229_ = vala_code_node_get_parent_node (_tmp1228_);
		_tmp1230_ = _tmp1229_;
		parent = _tmp1230_;
		_tmp1232_ = parent;
		if (_tmp1232_ == NULL) {
			_tmp1231_ = TRUE;
		} else {
			ValaCodeNode* _tmp1233_;
			ValaSymbol* _tmp1234_;
			_tmp1233_ = parent;
			_tmp1234_ = member;
			_tmp1231_ = _tmp1233_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1234_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1231_) {
			break;
		}
	}
	_tmp1235_ = parent;
	_tmp1236_ = member;
	if (_tmp1235_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1236_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1237_;
		_tmp1237_ = member;
		vala_symbol_set_used (_tmp1237_, TRUE);
	}
	_tmp1238_ = member;
	_tmp1239_ = vala_symbol_get_version (_tmp1238_);
	_tmp1240_ = _tmp1239_;
	_tmp1241_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1242_ = _tmp1241_;
	vala_version_attribute_check (_tmp1240_, _tmp1242_);
	if (access == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1244_;
		ValaSymbol* _tmp1245_;
		ValaSymbol* _tmp1246_;
		_tmp1244_ = member;
		_tmp1245_ = vala_symbol_get_parent_symbol (_tmp1244_);
		_tmp1246_ = _tmp1245_;
		_tmp1243_ = VALA_IS_TYPESYMBOL (_tmp1246_);
	} else {
		_tmp1243_ = FALSE;
	}
	if (_tmp1243_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1247_;
		ValaSymbol* _tmp1248_;
		ValaSymbol* _tmp1249_;
		gboolean in_subtype = FALSE;
		_tmp1247_ = member;
		_tmp1248_ = vala_symbol_get_parent_symbol (_tmp1247_);
		_tmp1249_ = _tmp1248_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1249_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1250_;
			ValaSemanticAnalyzer* _tmp1251_;
			ValaSymbol* _tmp1252_;
			ValaSymbol* _tmp1253_;
			ValaSymbol* _tmp1254_;
			_tmp1250_ = vala_code_context_get_analyzer (context);
			_tmp1251_ = _tmp1250_;
			_tmp1252_ = vala_semantic_analyzer_get_current_symbol (_tmp1251_);
			_tmp1253_ = _tmp1252_;
			_tmp1254_ = _vala_code_node_ref0 (_tmp1253_);
			this_symbol = _tmp1254_;
			{
				gboolean _tmp1255_ = FALSE;
				_tmp1255_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1260_;
					ValaSymbol* _tmp1261_;
					ValaTypeSymbol* _tmp1262_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1263_;
					gboolean _tmp1264_ = FALSE;
					ValaClass* _tmp1265_;
					if (!_tmp1255_) {
						ValaSymbol* _tmp1256_;
						ValaSymbol* _tmp1257_;
						ValaSymbol* _tmp1258_;
						ValaSymbol* _tmp1259_;
						_tmp1256_ = this_symbol;
						_tmp1257_ = vala_symbol_get_parent_symbol (_tmp1256_);
						_tmp1258_ = _tmp1257_;
						_tmp1259_ = _vala_code_node_ref0 (_tmp1258_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1259_;
					}
					_tmp1255_ = FALSE;
					_tmp1260_ = this_symbol;
					if (!(_tmp1260_ != NULL)) {
						break;
					}
					_tmp1261_ = this_symbol;
					_tmp1262_ = target_type;
					if (_tmp1261_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1262_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1263_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1263_) ? ((ValaClass*) _tmp1263_) : NULL;
					_tmp1265_ = cl;
					if (_tmp1265_ != NULL) {
						ValaClass* _tmp1266_;
						ValaTypeSymbol* _tmp1267_;
						_tmp1266_ = cl;
						_tmp1267_ = target_type;
						_tmp1264_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1266_, _tmp1267_);
					} else {
						_tmp1264_ = FALSE;
					}
					if (_tmp1264_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1268_;
			ValaSourceReference* _tmp1269_;
			ValaSymbol* _tmp1270_;
			gchar* _tmp1271_;
			gchar* _tmp1272_;
			gchar* _tmp1273_;
			gchar* _tmp1274_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1268_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1269_ = _tmp1268_;
			_tmp1270_ = member;
			_tmp1271_ = vala_symbol_get_full_name (_tmp1270_);
			_tmp1272_ = _tmp1271_;
			_tmp1273_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1272_);
			_tmp1274_ = _tmp1273_;
			vala_report_error (_tmp1269_, _tmp1274_);
			_g_free0 (_tmp1274_);
			_g_free0 (_tmp1272_);
			result = FALSE;
			return result;
		}
	} else {
		if (access == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1275_;
			ValaSymbol* _tmp1276_;
			ValaSymbol* _tmp1277_;
			gboolean in_target_type = FALSE;
			_tmp1275_ = member;
			_tmp1276_ = vala_symbol_get_parent_symbol (_tmp1275_);
			_tmp1277_ = _tmp1276_;
			target_type = _tmp1277_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1278_;
				ValaSemanticAnalyzer* _tmp1279_;
				ValaSymbol* _tmp1280_;
				ValaSymbol* _tmp1281_;
				ValaSymbol* _tmp1282_;
				_tmp1278_ = vala_code_context_get_analyzer (context);
				_tmp1279_ = _tmp1278_;
				_tmp1280_ = vala_semantic_analyzer_get_current_symbol (_tmp1279_);
				_tmp1281_ = _tmp1280_;
				_tmp1282_ = _vala_code_node_ref0 (_tmp1281_);
				this_symbol = _tmp1282_;
				{
					gboolean _tmp1283_ = FALSE;
					_tmp1283_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1288_;
						ValaSymbol* _tmp1289_;
						ValaSymbol* _tmp1290_;
						if (!_tmp1283_) {
							ValaSymbol* _tmp1284_;
							ValaSymbol* _tmp1285_;
							ValaSymbol* _tmp1286_;
							ValaSymbol* _tmp1287_;
							_tmp1284_ = this_symbol;
							_tmp1285_ = vala_symbol_get_parent_symbol (_tmp1284_);
							_tmp1286_ = _tmp1285_;
							_tmp1287_ = _vala_code_node_ref0 (_tmp1286_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1287_;
						}
						_tmp1283_ = FALSE;
						_tmp1288_ = this_symbol;
						if (!(_tmp1288_ != NULL)) {
							break;
						}
						_tmp1289_ = target_type;
						_tmp1290_ = this_symbol;
						if (_tmp1289_ == _tmp1290_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1291_;
				ValaSourceReference* _tmp1292_;
				ValaSymbol* _tmp1293_;
				gchar* _tmp1294_;
				gchar* _tmp1295_;
				gchar* _tmp1296_;
				gchar* _tmp1297_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1291_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1292_ = _tmp1291_;
				_tmp1293_ = member;
				_tmp1294_ = vala_symbol_get_full_name (_tmp1293_);
				_tmp1295_ = _tmp1294_;
				_tmp1296_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1295_);
				_tmp1297_ = _tmp1296_;
				vala_report_error (_tmp1292_, _tmp1297_);
				_g_free0 (_tmp1297_);
				_g_free0 (_tmp1295_);
				result = FALSE;
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1299_;
		ValaExpression* _tmp1300_;
		_tmp1299_ = vala_member_access_get_inner (self);
		_tmp1300_ = _tmp1299_;
		_tmp1298_ = _tmp1300_ != NULL;
	} else {
		_tmp1298_ = FALSE;
	}
	if (_tmp1298_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1301_;
		ValaExpression* _tmp1302_;
		ValaDataType* _tmp1303_;
		ValaDataType* _tmp1304_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1305_;
		ValaExpression* _tmp1306_;
		ValaDataType* _tmp1307_;
		ValaDataType* _tmp1308_;
		ValaPointerType* _tmp1309_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1313_;
		gboolean _tmp1314_ = FALSE;
		gboolean _tmp1315_ = FALSE;
		ValaObjectType* _tmp1316_;
		_tmp1301_ = vala_member_access_get_inner (self);
		_tmp1302_ = _tmp1301_;
		_tmp1303_ = vala_expression_get_value_type (_tmp1302_);
		_tmp1304_ = _tmp1303_;
		instance_type = _tmp1304_;
		_tmp1305_ = vala_member_access_get_inner (self);
		_tmp1306_ = _tmp1305_;
		_tmp1307_ = vala_expression_get_value_type (_tmp1306_);
		_tmp1308_ = _tmp1307_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1308_) ? ((ValaPointerType*) _tmp1308_) : NULL;
		_tmp1309_ = pointer_type;
		if (_tmp1309_ != NULL) {
			ValaPointerType* _tmp1310_;
			ValaDataType* _tmp1311_;
			ValaDataType* _tmp1312_;
			_tmp1310_ = pointer_type;
			_tmp1311_ = vala_pointer_type_get_base_type (_tmp1310_);
			_tmp1312_ = _tmp1311_;
			instance_type = _tmp1312_;
		}
		_tmp1313_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1313_) ? ((ValaObjectType*) _tmp1313_) : NULL;
		_tmp1316_ = object_type;
		if (_tmp1316_ != NULL) {
			ValaObjectType* _tmp1317_;
			ValaObjectTypeSymbol* _tmp1318_;
			ValaObjectTypeSymbol* _tmp1319_;
			_tmp1317_ = object_type;
			_tmp1318_ = vala_object_type_get_object_type_symbol (_tmp1317_);
			_tmp1319_ = _tmp1318_;
			_tmp1315_ = vala_object_type_symbol_has_type_parameters (_tmp1319_);
		} else {
			_tmp1315_ = FALSE;
		}
		if (_tmp1315_) {
			ValaDataType* _tmp1320_;
			_tmp1320_ = instance_type;
			_tmp1314_ = !vala_data_type_has_type_arguments (_tmp1320_);
		} else {
			_tmp1314_ = FALSE;
		}
		if (_tmp1314_) {
			ValaExpression* _tmp1321_;
			ValaExpression* _tmp1322_;
			ValaSourceReference* _tmp1323_;
			ValaSourceReference* _tmp1324_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1321_ = vala_member_access_get_inner (self);
			_tmp1322_ = _tmp1321_;
			_tmp1323_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1322_);
			_tmp1324_ = _tmp1323_;
			vala_report_error (_tmp1324_, "missing generic type arguments");
			result = FALSE;
			return result;
		}
	}
	if (instance) {
		_tmp1326_ = !may_access_instance_members;
	} else {
		_tmp1326_ = FALSE;
	}
	if (_tmp1326_) {
		_tmp1325_ = TRUE;
	} else {
		gboolean _tmp1327_ = FALSE;
		if (klass) {
			_tmp1327_ = !may_access_klass_members;
		} else {
			_tmp1327_ = FALSE;
		}
		_tmp1325_ = _tmp1327_;
	}
	if (_tmp1325_) {
		ValaSymbol* _tmp1328_;
		ValaSymbol* _tmp1329_;
		ValaDataType* _tmp1364_;
		ValaDataType* _tmp1365_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1328_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1329_ = _tmp1328_;
		if (VALA_IS_METHOD (_tmp1329_)) {
			ValaSemanticAnalyzer* _tmp1330_;
			ValaSemanticAnalyzer* _tmp1331_;
			ValaSymbol* _tmp1332_;
			ValaSymbol* _tmp1333_;
			gboolean _tmp1334_;
			gboolean _tmp1335_;
			ValaDataType* _tmp1336_;
			ValaDataType* _tmp1337_;
			ValaDataType* _tmp1338_;
			ValaDataType* _tmp1339_;
			ValaSourceReference* _tmp1340_;
			ValaSourceReference* _tmp1341_;
			_tmp1330_ = vala_code_context_get_analyzer (context);
			_tmp1331_ = _tmp1330_;
			_tmp1332_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1333_ = _tmp1332_;
			_tmp1334_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1335_ = _tmp1334_;
			_tmp1336_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1331_, _tmp1333_, _tmp1335_);
			_tmp1337_ = _tmp1336_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1337_);
			_vala_code_node_unref0 (_tmp1337_);
			_tmp1338_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1339_ = _tmp1338_;
			_tmp1340_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1341_ = _tmp1340_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1339_, _tmp1341_);
		} else {
			ValaSymbol* _tmp1342_;
			ValaSymbol* _tmp1343_;
			_tmp1342_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1343_ = _tmp1342_;
			if (VALA_IS_FIELD (_tmp1343_)) {
				ValaSymbol* _tmp1344_;
				ValaSymbol* _tmp1345_;
				ValaFieldPrototype* _tmp1346_;
				ValaFieldPrototype* _tmp1347_;
				ValaDataType* _tmp1348_;
				ValaDataType* _tmp1349_;
				ValaSourceReference* _tmp1350_;
				ValaSourceReference* _tmp1351_;
				_tmp1344_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1345_ = _tmp1344_;
				_tmp1346_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1345_, VALA_TYPE_FIELD, ValaField));
				_tmp1347_ = _tmp1346_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1347_);
				_vala_code_node_unref0 (_tmp1347_);
				_tmp1348_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1349_ = _tmp1348_;
				_tmp1350_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1351_ = _tmp1350_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1349_, _tmp1351_);
			} else {
				ValaSymbol* _tmp1352_;
				ValaSymbol* _tmp1353_;
				_tmp1352_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1353_ = _tmp1352_;
				if (VALA_IS_PROPERTY (_tmp1353_)) {
					ValaSymbol* _tmp1354_;
					ValaSymbol* _tmp1355_;
					ValaPropertyPrototype* _tmp1356_;
					ValaPropertyPrototype* _tmp1357_;
					ValaDataType* _tmp1358_;
					ValaDataType* _tmp1359_;
					ValaSourceReference* _tmp1360_;
					ValaSourceReference* _tmp1361_;
					_tmp1354_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1355_ = _tmp1354_;
					_tmp1356_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1355_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1357_ = _tmp1356_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1357_);
					_vala_code_node_unref0 (_tmp1357_);
					_tmp1358_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp1359_ = _tmp1358_;
					_tmp1360_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1361_ = _tmp1360_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1359_, _tmp1361_);
				} else {
					ValaInvalidType* _tmp1362_;
					ValaInvalidType* _tmp1363_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1362_ = vala_invalid_type_new ();
					_tmp1363_ = _tmp1362_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1363_);
					_vala_code_node_unref0 (_tmp1363_);
				}
			}
		}
		_tmp1364_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1365_ = _tmp1364_;
		if (_tmp1365_ != NULL) {
			ValaDataType* _tmp1366_;
			ValaDataType* _tmp1367_;
			ValaDataType* _tmp1368_;
			ValaDataType* _tmp1369_;
			gboolean _tmp1370_;
			gboolean _tmp1371_;
			_tmp1366_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1367_ = _tmp1366_;
			_tmp1368_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1369_ = _tmp1368_;
			_tmp1370_ = vala_data_type_get_value_owned (_tmp1369_);
			_tmp1371_ = _tmp1370_;
			vala_data_type_set_value_owned (_tmp1367_, _tmp1371_);
		}
	} else {
		gboolean _tmp1372_ = FALSE;
		gboolean _tmp1393_ = FALSE;
		gboolean _tmp1394_ = FALSE;
		gboolean _tmp1395_ = FALSE;
		gboolean _tmp1396_ = FALSE;
		gboolean _tmp1439_ = FALSE;
		gboolean _tmp1440_ = FALSE;
		gboolean _tmp1441_ = FALSE;
		gboolean _tmp1442_ = FALSE;
		gboolean _tmp1443_ = FALSE;
		gboolean _tmp1444_;
		gboolean _tmp1445_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1472_;
		ValaSymbol* _tmp1473_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1474_;
		ValaExpression* _tmp1475_;
		gboolean _tmp1476_ = FALSE;
		gboolean _tmp1477_ = FALSE;
		gboolean _tmp1478_ = FALSE;
		gboolean _tmp1479_ = FALSE;
		gboolean _tmp1480_ = FALSE;
		ValaMethod* _tmp1481_;
		ValaSemanticAnalyzer* _tmp1526_;
		ValaSemanticAnalyzer* _tmp1527_;
		ValaSymbol* _tmp1528_;
		ValaSymbol* _tmp1529_;
		gboolean _tmp1530_;
		gboolean _tmp1531_;
		ValaDataType* _tmp1532_;
		ValaDataType* _tmp1533_;
		gboolean _tmp1534_ = FALSE;
		ValaExpression* _tmp1535_;
		ValaExpression* _tmp1536_;
		ValaSymbol* _tmp1549_;
		ValaSymbol* _tmp1550_;
		if (instance) {
			ValaExpression* _tmp1373_;
			ValaExpression* _tmp1374_;
			_tmp1373_ = vala_member_access_get_inner (self);
			_tmp1374_ = _tmp1373_;
			_tmp1372_ = _tmp1374_ == NULL;
		} else {
			_tmp1372_ = FALSE;
		}
		if (_tmp1372_) {
			ValaSourceReference* _tmp1375_;
			ValaSourceReference* _tmp1376_;
			ValaMemberAccess* _tmp1377_;
			ValaMemberAccess* _tmp1378_;
			ValaExpression* _tmp1379_;
			ValaExpression* _tmp1380_;
			ValaParameter* _tmp1381_;
			ValaDataType* _tmp1382_;
			ValaDataType* _tmp1383_;
			ValaDataType* _tmp1384_;
			ValaDataType* _tmp1385_;
			ValaExpression* _tmp1386_;
			ValaExpression* _tmp1387_;
			ValaDataType* _tmp1388_;
			ValaDataType* _tmp1389_;
			ValaExpression* _tmp1390_;
			ValaExpression* _tmp1391_;
			ValaParameter* _tmp1392_;
			_tmp1375_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1376_ = _tmp1375_;
			_tmp1377_ = vala_member_access_new (NULL, "this", _tmp1376_);
			_tmp1378_ = _tmp1377_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1378_);
			_vala_code_node_unref0 (_tmp1378_);
			_tmp1379_ = vala_member_access_get_inner (self);
			_tmp1380_ = _tmp1379_;
			_tmp1381_ = this_parameter;
			_tmp1382_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1381_);
			_tmp1383_ = _tmp1382_;
			_tmp1384_ = vala_data_type_copy (_tmp1383_);
			_tmp1385_ = _tmp1384_;
			vala_expression_set_value_type (_tmp1380_, _tmp1385_);
			_vala_code_node_unref0 (_tmp1385_);
			_tmp1386_ = vala_member_access_get_inner (self);
			_tmp1387_ = _tmp1386_;
			_tmp1388_ = vala_expression_get_value_type (_tmp1387_);
			_tmp1389_ = _tmp1388_;
			vala_data_type_set_value_owned (_tmp1389_, FALSE);
			_tmp1390_ = vala_member_access_get_inner (self);
			_tmp1391_ = _tmp1390_;
			_tmp1392_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1391_, (ValaSymbol*) _tmp1392_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1396_ = !klass;
		} else {
			_tmp1396_ = FALSE;
		}
		if (_tmp1396_) {
			ValaSymbol* _tmp1397_;
			ValaSymbol* _tmp1398_;
			_tmp1397_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1398_ = _tmp1397_;
			_tmp1395_ = !VALA_IS_CREATION_METHOD (_tmp1398_);
		} else {
			_tmp1395_ = FALSE;
		}
		if (_tmp1395_) {
			_tmp1394_ = may_access_instance_members;
		} else {
			_tmp1394_ = FALSE;
		}
		if (_tmp1394_) {
			ValaExpression* _tmp1399_;
			ValaExpression* _tmp1400_;
			_tmp1399_ = vala_member_access_get_inner (self);
			_tmp1400_ = _tmp1399_;
			_tmp1393_ = _tmp1400_ != NULL;
		} else {
			_tmp1393_ = FALSE;
		}
		if (_tmp1393_) {
			ValaExpression* _tmp1401_;
			ValaExpression* _tmp1402_;
			ValaSymbol* _tmp1403_;
			ValaSymbol* _tmp1404_;
			_tmp1401_ = vala_member_access_get_inner (self);
			_tmp1402_ = _tmp1401_;
			_tmp1403_ = vala_expression_get_symbol_reference (_tmp1402_);
			_tmp1404_ = _tmp1403_;
			if (VALA_IS_METHOD (_tmp1404_)) {
			} else {
				ValaSourceReference* _tmp1405_;
				ValaSourceReference* _tmp1406_;
				ValaSymbol* _tmp1407_;
				ValaSymbol* _tmp1408_;
				gchar* _tmp1409_;
				gchar* _tmp1410_;
				gchar* _tmp1411_;
				gchar* _tmp1412_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1413_;
				ValaSymbol* _tmp1414_;
				ValaSymbol* _tmp1415_;
				ValaSymbol* _tmp1416_;
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp1436_;
				ValaExpression* _tmp1437_;
				ValaExpression* _tmp1438_;
				_tmp1405_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1406_ = _tmp1405_;
				_tmp1407_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1408_ = _tmp1407_;
				_tmp1409_ = vala_symbol_get_full_name (_tmp1408_);
				_tmp1410_ = _tmp1409_;
				_tmp1411_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1410_);
				_tmp1412_ = _tmp1411_;
				vala_report_warning (_tmp1406_, _tmp1412_);
				_g_free0 (_tmp1412_);
				_g_free0 (_tmp1410_);
				_tmp1413_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1414_ = _tmp1413_;
				_tmp1415_ = vala_symbol_get_parent_symbol (_tmp1414_);
				_tmp1416_ = _tmp1415_;
				inner_sym = _tmp1416_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1417_ = FALSE;
					ValaSymbol* _tmp1418_;
					ValaMemberAccess* _tmp1422_;
					ValaSymbol* _tmp1423_;
					const gchar* _tmp1424_;
					const gchar* _tmp1425_;
					ValaSourceReference* _tmp1426_;
					ValaSourceReference* _tmp1427_;
					ValaMemberAccess* _tmp1428_;
					ValaMemberAccess* _tmp1429_;
					ValaMemberAccess* _tmp1430_;
					ValaExpression* _tmp1431_;
					ValaExpression* _tmp1432_;
					ValaSymbol* _tmp1433_;
					ValaSymbol* _tmp1434_;
					ValaSymbol* _tmp1435_;
					_tmp1418_ = inner_sym;
					if (_tmp1418_ != NULL) {
						ValaSymbol* _tmp1419_;
						const gchar* _tmp1420_;
						const gchar* _tmp1421_;
						_tmp1419_ = inner_sym;
						_tmp1420_ = vala_symbol_get_name (_tmp1419_);
						_tmp1421_ = _tmp1420_;
						_tmp1417_ = _tmp1421_ != NULL;
					} else {
						_tmp1417_ = FALSE;
					}
					if (!_tmp1417_) {
						break;
					}
					_tmp1422_ = inner_ma;
					_tmp1423_ = inner_sym;
					_tmp1424_ = vala_symbol_get_name (_tmp1423_);
					_tmp1425_ = _tmp1424_;
					_tmp1426_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1427_ = _tmp1426_;
					_tmp1428_ = vala_member_access_new (NULL, _tmp1425_, _tmp1427_);
					_tmp1429_ = _tmp1428_;
					vala_member_access_set_inner (_tmp1422_, (ValaExpression*) _tmp1429_);
					_vala_code_node_unref0 (_tmp1429_);
					_tmp1430_ = inner_ma;
					_tmp1431_ = vala_member_access_get_inner (_tmp1430_);
					_tmp1432_ = _tmp1431_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1432_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1433_ = inner_sym;
					_tmp1434_ = vala_symbol_get_parent_symbol (_tmp1433_);
					_tmp1435_ = _tmp1434_;
					inner_sym = _tmp1435_;
				}
				_tmp1436_ = inner_ma;
				vala_member_access_set_qualified (_tmp1436_, TRUE);
				_tmp1437_ = vala_member_access_get_inner (self);
				_tmp1438_ = _tmp1437_;
				vala_code_node_check ((ValaCodeNode*) _tmp1438_, context);
			}
		}
		_tmp1444_ = vala_code_context_get_experimental_non_null (context);
		_tmp1445_ = _tmp1444_;
		if (_tmp1445_) {
			_tmp1443_ = instance;
		} else {
			_tmp1443_ = FALSE;
		}
		if (_tmp1443_) {
			ValaExpression* _tmp1446_;
			ValaExpression* _tmp1447_;
			ValaDataType* _tmp1448_;
			ValaDataType* _tmp1449_;
			gboolean _tmp1450_;
			gboolean _tmp1451_;
			_tmp1446_ = vala_member_access_get_inner (self);
			_tmp1447_ = _tmp1446_;
			_tmp1448_ = vala_expression_get_value_type (_tmp1447_);
			_tmp1449_ = _tmp1448_;
			_tmp1450_ = vala_data_type_get_nullable (_tmp1449_);
			_tmp1451_ = _tmp1450_;
			_tmp1442_ = _tmp1451_;
		} else {
			_tmp1442_ = FALSE;
		}
		if (_tmp1442_) {
			ValaExpression* _tmp1452_;
			ValaExpression* _tmp1453_;
			ValaDataType* _tmp1454_;
			ValaDataType* _tmp1455_;
			_tmp1452_ = vala_member_access_get_inner (self);
			_tmp1453_ = _tmp1452_;
			_tmp1454_ = vala_expression_get_value_type (_tmp1453_);
			_tmp1455_ = _tmp1454_;
			_tmp1441_ = !VALA_IS_POINTER_TYPE (_tmp1455_);
		} else {
			_tmp1441_ = FALSE;
		}
		if (_tmp1441_) {
			ValaExpression* _tmp1456_;
			ValaExpression* _tmp1457_;
			ValaDataType* _tmp1458_;
			ValaDataType* _tmp1459_;
			_tmp1456_ = vala_member_access_get_inner (self);
			_tmp1457_ = _tmp1456_;
			_tmp1458_ = vala_expression_get_value_type (_tmp1457_);
			_tmp1459_ = _tmp1458_;
			_tmp1440_ = !VALA_IS_GENERIC_TYPE (_tmp1459_);
		} else {
			_tmp1440_ = FALSE;
		}
		if (_tmp1440_) {
			ValaExpression* _tmp1460_;
			ValaExpression* _tmp1461_;
			ValaDataType* _tmp1462_;
			ValaDataType* _tmp1463_;
			_tmp1460_ = vala_member_access_get_inner (self);
			_tmp1461_ = _tmp1460_;
			_tmp1462_ = vala_expression_get_value_type (_tmp1461_);
			_tmp1463_ = _tmp1462_;
			_tmp1439_ = !VALA_IS_ARRAY_TYPE (_tmp1463_);
		} else {
			_tmp1439_ = FALSE;
		}
		if (_tmp1439_) {
			ValaSourceReference* _tmp1464_;
			ValaSourceReference* _tmp1465_;
			ValaSymbol* _tmp1466_;
			ValaSymbol* _tmp1467_;
			gchar* _tmp1468_;
			gchar* _tmp1469_;
			gchar* _tmp1470_;
			gchar* _tmp1471_;
			_tmp1464_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1465_ = _tmp1464_;
			_tmp1466_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1467_ = _tmp1466_;
			_tmp1468_ = vala_symbol_get_full_name (_tmp1467_);
			_tmp1469_ = _tmp1468_;
			_tmp1470_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1469_);
			_tmp1471_ = _tmp1470_;
			vala_report_error (_tmp1465_, _tmp1471_);
			_g_free0 (_tmp1471_);
			_g_free0 (_tmp1469_);
		}
		_tmp1472_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1473_ = _tmp1472_;
		m = VALA_IS_METHOD (_tmp1473_) ? ((ValaMethod*) _tmp1473_) : NULL;
		_tmp1474_ = vala_member_access_get_inner (self);
		_tmp1475_ = _tmp1474_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1475_) ? ((ValaMemberAccess*) _tmp1475_) : NULL;
		_tmp1481_ = m;
		if (_tmp1481_ != NULL) {
			ValaMethod* _tmp1482_;
			ValaMemberBinding _tmp1483_;
			ValaMemberBinding _tmp1484_;
			_tmp1482_ = m;
			_tmp1483_ = vala_method_get_binding (_tmp1482_);
			_tmp1484_ = _tmp1483_;
			_tmp1480_ = _tmp1484_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1480_ = FALSE;
		}
		if (_tmp1480_) {
			ValaMethod* _tmp1485_;
			ValaSymbol* _tmp1486_;
			ValaSymbol* _tmp1487_;
			_tmp1485_ = m;
			_tmp1486_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1485_);
			_tmp1487_ = _tmp1486_;
			_tmp1479_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1487_);
		} else {
			_tmp1479_ = FALSE;
		}
		if (_tmp1479_) {
			ValaExpression* _tmp1488_;
			ValaExpression* _tmp1489_;
			_tmp1488_ = vala_member_access_get_inner (self);
			_tmp1489_ = _tmp1488_;
			_tmp1478_ = _tmp1489_ != NULL;
		} else {
			_tmp1478_ = FALSE;
		}
		if (_tmp1478_) {
			ValaExpression* _tmp1490_;
			ValaExpression* _tmp1491_;
			ValaDataType* _tmp1492_;
			ValaDataType* _tmp1493_;
			_tmp1490_ = vala_member_access_get_inner (self);
			_tmp1491_ = _tmp1490_;
			_tmp1492_ = vala_expression_get_value_type (_tmp1491_);
			_tmp1493_ = _tmp1492_;
			_tmp1477_ = _tmp1493_ == NULL;
		} else {
			_tmp1477_ = FALSE;
		}
		if (_tmp1477_) {
			ValaMemberAccess* _tmp1494_;
			ValaList* _tmp1495_;
			gint _tmp1496_;
			gint _tmp1497_;
			_tmp1494_ = inner_ma;
			_tmp1495_ = _tmp1494_->priv->type_argument_list;
			_tmp1496_ = vala_collection_get_size ((ValaCollection*) _tmp1495_);
			_tmp1497_ = _tmp1496_;
			_tmp1476_ = _tmp1497_ > 0;
		} else {
			_tmp1476_ = FALSE;
		}
		if (_tmp1476_) {
			ValaExpression* _tmp1498_;
			ValaExpression* _tmp1499_;
			ValaMethod* _tmp1500_;
			ValaSymbol* _tmp1501_;
			ValaSymbol* _tmp1502_;
			ValaObjectType* _tmp1503_;
			ValaObjectType* _tmp1504_;
			ValaExpression* _tmp1505_;
			ValaExpression* _tmp1506_;
			ValaDataType* _tmp1507_;
			ValaDataType* _tmp1508_;
			ValaSourceReference* _tmp1509_;
			ValaSourceReference* _tmp1510_;
			_tmp1498_ = vala_member_access_get_inner (self);
			_tmp1499_ = _tmp1498_;
			_tmp1500_ = m;
			_tmp1501_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1500_);
			_tmp1502_ = _tmp1501_;
			_tmp1503_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1502_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1504_ = _tmp1503_;
			vala_expression_set_value_type (_tmp1499_, (ValaDataType*) _tmp1504_);
			_vala_code_node_unref0 (_tmp1504_);
			_tmp1505_ = vala_member_access_get_inner (self);
			_tmp1506_ = _tmp1505_;
			_tmp1507_ = vala_expression_get_value_type (_tmp1506_);
			_tmp1508_ = _tmp1507_;
			_tmp1509_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1510_ = _tmp1509_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1508_, _tmp1510_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1511_;
				ValaList* _tmp1512_;
				ValaList* _tmp1513_;
				gint _type_argument_size = 0;
				ValaList* _tmp1514_;
				gint _tmp1515_;
				gint _tmp1516_;
				gint _type_argument_index = 0;
				_tmp1511_ = inner_ma;
				_tmp1512_ = _tmp1511_->priv->type_argument_list;
				_tmp1513_ = _vala_iterable_ref0 (_tmp1512_);
				_type_argument_list = _tmp1513_;
				_tmp1514_ = _type_argument_list;
				_tmp1515_ = vala_collection_get_size ((ValaCollection*) _tmp1514_);
				_tmp1516_ = _tmp1515_;
				_type_argument_size = _tmp1516_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1517_;
					gint _tmp1518_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1519_;
					gpointer _tmp1520_;
					ValaExpression* _tmp1521_;
					ValaExpression* _tmp1522_;
					ValaDataType* _tmp1523_;
					ValaDataType* _tmp1524_;
					ValaDataType* _tmp1525_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1517_ = _type_argument_index;
					_tmp1518_ = _type_argument_size;
					if (!(_tmp1517_ < _tmp1518_)) {
						break;
					}
					_tmp1519_ = _type_argument_list;
					_tmp1520_ = vala_list_get (_tmp1519_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1520_;
					_tmp1521_ = vala_member_access_get_inner (self);
					_tmp1522_ = _tmp1521_;
					_tmp1523_ = vala_expression_get_value_type (_tmp1522_);
					_tmp1524_ = _tmp1523_;
					_tmp1525_ = type_argument;
					vala_data_type_add_type_argument (_tmp1524_, _tmp1525_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1526_ = vala_code_context_get_analyzer (context);
		_tmp1527_ = _tmp1526_;
		_tmp1528_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1529_ = _tmp1528_;
		_tmp1530_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1531_ = _tmp1530_;
		_tmp1532_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1527_, _tmp1529_, _tmp1531_);
		_tmp1533_ = _tmp1532_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1533_);
		_vala_code_node_unref0 (_tmp1533_);
		_tmp1535_ = vala_member_access_get_inner (self);
		_tmp1536_ = _tmp1535_;
		if (_tmp1536_ != NULL) {
			ValaDataType* _tmp1537_;
			ValaDataType* _tmp1538_;
			_tmp1537_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1538_ = _tmp1537_;
			_tmp1534_ = _tmp1538_ != NULL;
		} else {
			_tmp1534_ = FALSE;
		}
		if (_tmp1534_) {
			ValaDataType* _tmp1539_;
			ValaDataType* _tmp1540_;
			ValaExpression* _tmp1541_;
			ValaExpression* _tmp1542_;
			ValaDataType* _tmp1543_;
			ValaDataType* _tmp1544_;
			ValaDataType* _tmp1545_;
			ValaDataType* _tmp1546_;
			_tmp1539_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1540_ = _tmp1539_;
			_tmp1541_ = vala_member_access_get_inner (self);
			_tmp1542_ = _tmp1541_;
			_tmp1543_ = vala_expression_get_value_type (_tmp1542_);
			_tmp1544_ = _tmp1543_;
			_tmp1545_ = vala_data_type_get_actual_type (_tmp1540_, _tmp1544_, NULL, (ValaCodeNode*) self);
			_tmp1546_ = _tmp1545_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1546_);
			_vala_code_node_unref0 (_tmp1546_);
		} else {
			ValaDataType* _tmp1547_;
			ValaDataType* _tmp1548_;
			_tmp1547_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1548_ = _tmp1547_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1548_);
		}
		_tmp1549_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1550_ = _tmp1549_;
		if (VALA_IS_METHOD (_tmp1550_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1551_;
			ValaSymbol* _tmp1552_;
			ValaDataType* _tmp1553_;
			ValaDataType* _tmp1554_;
			gboolean _tmp1561_ = FALSE;
			_tmp1551_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1552_ = _tmp1551_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1552_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1553_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1554_ = _tmp1553_;
			if (_tmp1554_ != NULL) {
				ValaDataType* _tmp1555_;
				ValaDataType* _tmp1556_;
				ValaDataType* _tmp1557_;
				ValaDataType* _tmp1558_;
				gboolean _tmp1559_;
				gboolean _tmp1560_;
				_tmp1555_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1556_ = _tmp1555_;
				_tmp1557_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1558_ = _tmp1557_;
				_tmp1559_ = vala_data_type_get_value_owned (_tmp1558_);
				_tmp1560_ = _tmp1559_;
				vala_data_type_set_value_owned (_tmp1556_, _tmp1560_);
			}
			if (instance) {
				ValaMethod* _tmp1562_;
				ValaSymbol* _tmp1563_;
				ValaSymbol* _tmp1564_;
				_tmp1562_ = method;
				_tmp1563_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1562_);
				_tmp1564_ = _tmp1563_;
				_tmp1561_ = VALA_IS_TYPESYMBOL (_tmp1564_);
			} else {
				_tmp1561_ = FALSE;
			}
			if (_tmp1561_) {
				ValaExpression* _tmp1565_;
				ValaExpression* _tmp1566_;
				ValaMethod* _tmp1567_;
				ValaSymbol* _tmp1568_;
				ValaSymbol* _tmp1569_;
				ValaDataType* _tmp1570_;
				ValaDataType* _tmp1571_;
				ValaExpression* _tmp1572_;
				ValaExpression* _tmp1573_;
				ValaDataType* _tmp1574_;
				ValaDataType* _tmp1575_;
				ValaMethod* _tmp1576_;
				ValaParameter* _tmp1577_;
				ValaParameter* _tmp1578_;
				ValaDataType* _tmp1579_;
				ValaDataType* _tmp1580_;
				gboolean _tmp1581_;
				gboolean _tmp1582_;
				_tmp1565_ = vala_member_access_get_inner (self);
				_tmp1566_ = _tmp1565_;
				_tmp1567_ = method;
				_tmp1568_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1567_);
				_tmp1569_ = _tmp1568_;
				_tmp1570_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1569_);
				_tmp1571_ = _tmp1570_;
				vala_expression_set_target_type (_tmp1566_, _tmp1571_);
				_vala_code_node_unref0 (_tmp1571_);
				_tmp1572_ = vala_member_access_get_inner (self);
				_tmp1573_ = _tmp1572_;
				_tmp1574_ = vala_expression_get_target_type (_tmp1573_);
				_tmp1575_ = _tmp1574_;
				_tmp1576_ = method;
				_tmp1577_ = vala_method_get_this_parameter (_tmp1576_);
				_tmp1578_ = _tmp1577_;
				_tmp1579_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1578_);
				_tmp1580_ = _tmp1579_;
				_tmp1581_ = vala_data_type_get_value_owned (_tmp1580_);
				_tmp1582_ = _tmp1581_;
				vala_data_type_set_value_owned (_tmp1575_, _tmp1582_);
			}
		} else {
			gboolean _tmp1583_ = FALSE;
			gboolean _tmp1584_ = FALSE;
			ValaSymbol* _tmp1585_;
			ValaSymbol* _tmp1586_;
			_tmp1585_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1586_ = _tmp1585_;
			if (VALA_IS_PROPERTY (_tmp1586_)) {
				_tmp1584_ = instance;
			} else {
				_tmp1584_ = FALSE;
			}
			if (_tmp1584_) {
				ValaSymbol* _tmp1587_;
				ValaSymbol* _tmp1588_;
				ValaSymbol* _tmp1589_;
				ValaSymbol* _tmp1590_;
				_tmp1587_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1588_ = _tmp1587_;
				_tmp1589_ = vala_symbol_get_parent_symbol (_tmp1588_);
				_tmp1590_ = _tmp1589_;
				_tmp1583_ = _tmp1590_ != NULL;
			} else {
				_tmp1583_ = FALSE;
			}
			if (_tmp1583_) {
				ValaExpression* _tmp1591_;
				ValaExpression* _tmp1592_;
				ValaSymbol* _tmp1593_;
				ValaSymbol* _tmp1594_;
				ValaSymbol* _tmp1595_;
				ValaSymbol* _tmp1596_;
				ValaDataType* _tmp1597_;
				ValaDataType* _tmp1598_;
				_tmp1591_ = vala_member_access_get_inner (self);
				_tmp1592_ = _tmp1591_;
				_tmp1593_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1594_ = _tmp1593_;
				_tmp1595_ = vala_symbol_get_parent_symbol (_tmp1594_);
				_tmp1596_ = _tmp1595_;
				_tmp1597_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1596_);
				_tmp1598_ = _tmp1597_;
				vala_expression_set_target_type (_tmp1592_, _tmp1598_);
				_vala_code_node_unref0 (_tmp1598_);
			} else {
				gboolean _tmp1599_ = FALSE;
				gboolean _tmp1600_ = FALSE;
				gboolean _tmp1601_ = FALSE;
				ValaSymbol* _tmp1602_;
				ValaSymbol* _tmp1603_;
				_tmp1602_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1603_ = _tmp1602_;
				if (VALA_IS_FIELD (_tmp1603_)) {
					_tmp1601_ = TRUE;
				} else {
					ValaSymbol* _tmp1604_;
					ValaSymbol* _tmp1605_;
					_tmp1604_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1605_ = _tmp1604_;
					_tmp1601_ = VALA_IS_SIGNAL (_tmp1605_);
				}
				if (_tmp1601_) {
					_tmp1600_ = instance;
				} else {
					_tmp1600_ = FALSE;
				}
				if (_tmp1600_) {
					ValaSymbol* _tmp1606_;
					ValaSymbol* _tmp1607_;
					ValaSymbol* _tmp1608_;
					ValaSymbol* _tmp1609_;
					_tmp1606_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1607_ = _tmp1606_;
					_tmp1608_ = vala_symbol_get_parent_symbol (_tmp1607_);
					_tmp1609_ = _tmp1608_;
					_tmp1599_ = _tmp1609_ != NULL;
				} else {
					_tmp1599_ = FALSE;
				}
				if (_tmp1599_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1610_;
					ValaSymbol* _tmp1611_;
					ValaSymbol* _tmp1612_;
					ValaSymbol* _tmp1613_;
					ValaDataType* _tmp1614_;
					ValaExpression* _tmp1615_;
					ValaExpression* _tmp1616_;
					ValaDataType* _tmp1617_;
					ValaExpression* _tmp1618_;
					ValaExpression* _tmp1619_;
					ValaDataType* _tmp1620_;
					ValaDataType* _tmp1621_;
					ValaDataType* _tmp1622_;
					ValaDataType* _tmp1623_;
					_tmp1610_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1611_ = _tmp1610_;
					_tmp1612_ = vala_symbol_get_parent_symbol (_tmp1611_);
					_tmp1613_ = _tmp1612_;
					_tmp1614_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1613_);
					parent_type = _tmp1614_;
					_tmp1615_ = vala_member_access_get_inner (self);
					_tmp1616_ = _tmp1615_;
					_tmp1617_ = parent_type;
					_tmp1618_ = vala_member_access_get_inner (self);
					_tmp1619_ = _tmp1618_;
					_tmp1620_ = vala_expression_get_value_type (_tmp1619_);
					_tmp1621_ = _tmp1620_;
					_tmp1622_ = vala_data_type_get_actual_type (_tmp1617_, _tmp1621_, NULL, (ValaCodeNode*) self);
					_tmp1623_ = _tmp1622_;
					vala_expression_set_target_type (_tmp1616_, _tmp1623_);
					_vala_code_node_unref0 (_tmp1623_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
	}
	_tmp1624_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1625_ = _tmp1624_;
	if (_tmp1625_ != NULL) {
		ValaDataType* _tmp1626_;
		ValaDataType* _tmp1627_;
		_tmp1626_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1627_ = _tmp1626_;
		vala_code_node_check ((ValaCodeNode*) _tmp1627_, context);
	}
	_tmp1628_ = self->priv->_tainted_access;
	if (!_tmp1628_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1629_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1630_ = _tmp1629_;
	result = !_tmp1630_;
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result = 0;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

