/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};

static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;

static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self,
                                      gboolean value);
static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static void vala_method_call_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);
static GType vala_method_call_get_type_once (void);

static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}

ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_method_call_set_call (ValaMethodCall* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_call_get_is_yield_expression (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_yield_expression;
	return result;
}

void
vala_method_call_set_is_yield_expression (ValaMethodCall* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}

gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_assert;
	return result;
}

static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}

gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_constructv_chainup;
	return result;
}

static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}

gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_method_call_set_is_chainup (ValaMethodCall* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}

/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}

ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_method_call_add_argument (ValaMethodCall* self,
                               ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
ValaList*
vala_method_call_get_argument_list (ValaMethodCall* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _expr_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_expr_list = _tmp3_;
		_tmp4_ = _expr_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_expr_size = _tmp6_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaExpression* expr = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_expr_index = _expr_index + 1;
			_tmp7_ = _expr_index;
			_tmp8_ = _expr_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _expr_list;
			_tmp10_ = vala_list_get (_tmp9_, _expr_index);
			expr = (ValaExpression*) _tmp10_;
			_tmp11_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	if (index >= 0) {
		ValaList* _tmp3_;
		_tmp3_ = self->priv->argument_list;
		vala_list_set (_tmp3_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = method_type;
	if (_tmp4_ != NULL) {
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = method_type;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strcmp0 (_tmp9_, "GLib.N_") == 0;
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			gboolean _tmp14_;
			_tmp11_ = self->priv->argument_list;
			_tmp12_ = vala_list_get (_tmp11_, 0);
			_tmp13_ = (ValaExpression*) _tmp12_;
			_tmp14_ = vala_expression_is_constant (_tmp13_);
			_vala_code_node_unref0 (_tmp13_);
			result = _tmp14_;
			return result;
		} else {
			ValaMethodType* _tmp15_;
			ValaMethod* _tmp16_;
			ValaMethod* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp15_ = method_type;
			_tmp16_ = vala_method_type_get_method_symbol (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp19_, "GLib.NC_") == 0;
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				gboolean _tmp21_ = FALSE;
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 0);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				if (_tmp25_) {
					ValaList* _tmp26_;
					gpointer _tmp27_;
					ValaExpression* _tmp28_;
					_tmp26_ = self->priv->argument_list;
					_tmp27_ = vala_list_get (_tmp26_, 1);
					_tmp28_ = (ValaExpression*) _tmp27_;
					_tmp21_ = vala_expression_is_constant (_tmp28_);
					_vala_code_node_unref0 (_tmp28_);
				} else {
					_tmp21_ = FALSE;
				}
				result = _tmp21_;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	ValaExpression* _tmp10_;
	ValaExpression* _tmp11_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			if (!vala_expression_is_accessible (_tmp9_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp10_ = vala_method_call_get_call (self);
	_tmp11_ = _tmp10_;
	result = vala_expression_is_accessible (_tmp11_, sym);
	return result;
}

static void
vala_method_call_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference)
{
	ValaMethodCall * self;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_method_call_get_call (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_value_type (_tmp3_);
	_tmp5_ = _tmp4_;
	mtype = _tmp5_;
	_tmp6_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp6_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp7_ = mtype;
		_tmp8_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp9_ = _tmp8_;
		m = _tmp9_;
		_tmp12_ = m;
		_tmp13_ = vala_method_get_coroutine (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			gboolean _tmp15_;
			_tmp15_ = self->priv->_is_yield_expression;
			_tmp11_ = !_tmp15_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaExpression* _tmp16_;
			ValaExpression* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			_tmp16_ = vala_method_call_get_call (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp19_ = _tmp18_;
			_tmp10_ = g_strcmp0 (_tmp19_, "end") != 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			ValaMethod* _tmp20_;
			_tmp20_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp20_, collection, source_reference);
		}
	} else {
		ValaDataType* _tmp21_;
		_tmp21_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp21_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp22_;
			ValaTypeSymbol* _tmp23_;
			ValaTypeSymbol* _tmp24_;
			ValaMethod* m = NULL;
			ValaClass* _tmp25_;
			ValaCreationMethod* _tmp26_;
			ValaCreationMethod* _tmp27_;
			ValaMethod* _tmp28_;
			_tmp22_ = mtype;
			_tmp23_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp24_ = _tmp23_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALA_TYPE_CLASS, ValaClass);
			_tmp25_ = cl;
			_tmp26_ = vala_class_get_default_construction_method (_tmp25_);
			_tmp27_ = _tmp26_;
			m = (ValaMethod*) _tmp27_;
			_tmp28_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp28_, collection, source_reference);
		} else {
			ValaDataType* _tmp29_;
			_tmp29_ = mtype;
			if (VALA_IS_DELEGATE_TYPE (_tmp29_)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp30_;
				ValaDelegate* _tmp31_;
				ValaDelegate* _tmp32_;
				ValaDelegate* _tmp33_;
				_tmp30_ = mtype;
				_tmp31_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp32_ = _tmp31_;
				d = _tmp32_;
				_tmp33_ = d;
				vala_code_node_get_error_types ((ValaCodeNode*) _tmp33_, collection, source_reference);
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp34_;
		ValaList* _tmp35_;
		gint _expr_size = 0;
		ValaList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _expr_index = 0;
		_tmp34_ = self->priv->argument_list;
		_tmp35_ = _vala_iterable_ref0 (_tmp34_);
		_expr_list = _tmp35_;
		_tmp36_ = _expr_list;
		_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_expr_size = _tmp38_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp39_;
			gint _tmp40_;
			ValaExpression* expr = NULL;
			ValaList* _tmp41_;
			gpointer _tmp42_;
			ValaExpression* _tmp43_;
			_expr_index = _expr_index + 1;
			_tmp39_ = _expr_index;
			_tmp40_ = _expr_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _expr_list;
			_tmp42_ = vala_list_get (_tmp41_, _expr_index);
			expr = (ValaExpression*) _tmp42_;
			_tmp43_ = expr;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp43_, collection, source_reference);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp104_;
	ValaExpression* _tmp105_;
	ValaDataType* _tmp106_;
	ValaDataType* _tmp107_;
	ValaDataType* _tmp108_;
	gboolean _tmp109_ = FALSE;
	ValaProfile _tmp110_;
	ValaProfile _tmp111_;
	gboolean gobject_chainup = FALSE;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp137_;
	gboolean _tmp229_ = FALSE;
	ValaExpression* _tmp230_;
	ValaExpression* _tmp231_;
	gboolean _tmp303_ = FALSE;
	gboolean _tmp304_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp319_;
	ValaDataType* _tmp320_;
	ValaDataType* _tmp321_;
	ValaList* params = NULL;
	ValaDataType* _tmp322_;
	ValaList* _tmp323_;
	ValaList* _tmp324_;
	ValaDataType* _tmp325_;
	ValaExpression* last_arg = NULL;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp380_;
	ValaIterator* _tmp381_;
	gboolean _tmp432_ = FALSE;
	ValaDataType* _tmp433_;
	gboolean _tmp455_ = FALSE;
	ValaDataType* _tmp456_;
	gboolean force_lambda_method_closure = FALSE;
	gboolean _tmp538_ = FALSE;
	gboolean _tmp539_;
	gboolean _tmp540_;
	ValaDataType* _tmp561_;
	ValaDataType* _tmp572_;
	ValaDataType* _tmp573_;
	ValaDataType* _tmp574_;
	ValaDataType* _tmp575_;
	ValaDataType* _tmp576_;
	ValaDataType* _tmp577_;
	ValaList* _tmp578_;
	ValaDataType* _tmp579_;
	ValaDataType* _tmp580_;
	gboolean _tmp581_;
	ValaDataType* _tmp604_;
	ValaSemanticAnalyzer* _tmp861_;
	ValaSemanticAnalyzer* _tmp862_;
	ValaDataType* _tmp863_;
	ValaList* _tmp864_;
	ValaList* _tmp865_;
	gboolean _tmp893_ = FALSE;
	gboolean _tmp894_ = FALSE;
	ValaCreationMethod* _tmp895_;
	ValaDataType* _tmp923_;
	ValaDataType* _tmp924_;
	gboolean _tmp925_;
	gboolean _tmp926_;
	gboolean _tmp987_;
	gboolean _tmp988_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_method_call_get_call (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp6_ = vala_method_call_get_call (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (VALA_IS_DELEGATE_TYPE (_tmp9_)) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp10_ = vala_method_call_get_call (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_value_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (_tmp13_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp14_;
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		if (VALA_IS_MEMBER_ACCESS (_tmp16_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaMemberAccess* _tmp19_;
			gboolean _tmp20_;
			gboolean _tmp21_;
			ValaMemberAccess* _tmp32_;
			ValaList* _tmp33_;
			ValaList* _tmp34_;
			ValaMemberAccess* _tmp35_;
			ValaExpression* _tmp36_;
			ValaExpression* _tmp37_;
			gboolean _tmp88_ = FALSE;
			ValaMemberAccess* _tmp89_;
			ValaSymbol* _tmp90_;
			ValaSymbol* _tmp91_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp19_ = ma;
			_tmp20_ = vala_member_access_get_prototype_access (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_) {
				ValaSourceReference* _tmp22_;
				ValaSourceReference* _tmp23_;
				ValaExpression* _tmp24_;
				ValaExpression* _tmp25_;
				ValaSymbol* _tmp26_;
				ValaSymbol* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_method_call_get_call (self);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_symbol_get_full_name (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp29_);
				_tmp31_ = _tmp30_;
				vala_report_error (_tmp23_, _tmp31_);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp29_);
				result = FALSE;
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp32_ = ma;
			_tmp33_ = vala_member_access_get_type_arguments (_tmp32_);
			_tmp34_ = _vala_iterable_ref0 (_tmp33_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp34_;
			_tmp35_ = ma;
			_tmp36_ = vala_member_access_get_inner (_tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_ != NULL) {
				ValaMemberAccess* _tmp38_;
				ValaExpression* _tmp39_;
				ValaExpression* _tmp40_;
				ValaDataType* _tmp41_;
				ValaDataType* _tmp42_;
				ValaDataType* _tmp43_;
				ValaMemberAccess* _tmp44_;
				ValaExpression* _tmp45_;
				ValaExpression* _tmp46_;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp48_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp59_;
				ValaSymbol* _tmp60_;
				ValaSymbol* _tmp61_;
				gboolean _tmp62_ = FALSE;
				ValaMethod* _tmp63_;
				_tmp38_ = ma;
				_tmp39_ = vala_member_access_get_inner (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_expression_get_value_type (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _vala_code_node_ref0 (_tmp42_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp43_;
				_tmp44_ = ma;
				_tmp45_ = vala_member_access_get_inner (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_expression_get_symbol_reference (_tmp46_);
				_tmp48_ = _tmp47_;
				if (VALA_IS_SIGNAL (_tmp48_)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp49_;
					ValaExpression* _tmp50_;
					ValaExpression* _tmp51_;
					ValaMemberAccess* _tmp52_;
					_tmp49_ = ma;
					_tmp50_ = vala_member_access_get_inner (_tmp49_);
					_tmp51_ = _tmp50_;
					sig = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
					_tmp52_ = sig;
					if (_tmp52_ != NULL) {
						ValaMemberAccess* _tmp53_;
						ValaExpression* _tmp54_;
						ValaExpression* _tmp55_;
						ValaDataType* _tmp56_;
						ValaDataType* _tmp57_;
						ValaDataType* _tmp58_;
						_tmp53_ = sig;
						_tmp54_ = vala_member_access_get_inner (_tmp53_);
						_tmp55_ = _tmp54_;
						_tmp56_ = vala_expression_get_value_type (_tmp55_);
						_tmp57_ = _tmp56_;
						_tmp58_ = _vala_code_node_ref0 (_tmp57_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp58_;
					}
				}
				_tmp59_ = ma;
				_tmp60_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp59_);
				_tmp61_ = _tmp60_;
				m = VALA_IS_METHOD (_tmp61_) ? ((ValaMethod*) _tmp61_) : NULL;
				_tmp63_ = m;
				if (_tmp63_ != NULL) {
					ValaMethod* _tmp64_;
					gboolean _tmp65_;
					gboolean _tmp66_;
					_tmp64_ = m;
					_tmp65_ = vala_method_get_coroutine (_tmp64_);
					_tmp66_ = _tmp65_;
					_tmp62_ = _tmp66_;
				} else {
					_tmp62_ = FALSE;
				}
				if (_tmp62_) {
					gboolean _tmp67_ = FALSE;
					ValaMemberAccess* _tmp68_;
					const gchar* _tmp69_;
					const gchar* _tmp70_;
					_tmp68_ = ma;
					_tmp69_ = vala_member_access_get_member_name (_tmp68_);
					_tmp70_ = _tmp69_;
					if (g_strcmp0 (_tmp70_, "begin") == 0) {
						_tmp67_ = TRUE;
					} else {
						ValaMemberAccess* _tmp71_;
						const gchar* _tmp72_;
						const gchar* _tmp73_;
						_tmp71_ = ma;
						_tmp72_ = vala_member_access_get_member_name (_tmp71_);
						_tmp73_ = _tmp72_;
						_tmp67_ = g_strcmp0 (_tmp73_, "end") == 0;
					}
					if (_tmp67_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp74_;
						ValaExpression* _tmp75_;
						ValaExpression* _tmp76_;
						gboolean _tmp77_ = FALSE;
						ValaMemberAccess* _tmp78_;
						_tmp74_ = ma;
						_tmp75_ = vala_member_access_get_inner (_tmp74_);
						_tmp76_ = _tmp75_;
						method_access = VALA_IS_MEMBER_ACCESS (_tmp76_) ? ((ValaMemberAccess*) _tmp76_) : NULL;
						_tmp78_ = method_access;
						if (_tmp78_ != NULL) {
							ValaMemberAccess* _tmp79_;
							ValaExpression* _tmp80_;
							ValaExpression* _tmp81_;
							_tmp79_ = method_access;
							_tmp80_ = vala_member_access_get_inner (_tmp79_);
							_tmp81_ = _tmp80_;
							_tmp77_ = _tmp81_ != NULL;
						} else {
							_tmp77_ = FALSE;
						}
						if (_tmp77_) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							ValaDataType* _tmp85_;
							ValaDataType* _tmp86_;
							ValaDataType* _tmp87_;
							_tmp82_ = method_access;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp85_ = vala_expression_get_value_type (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp87_ = _vala_code_node_ref0 (_tmp86_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp87_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
					}
				}
			}
			_tmp89_ = ma;
			_tmp90_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp89_);
			_tmp91_ = _tmp90_;
			if (_tmp91_ != NULL) {
				ValaMemberAccess* _tmp92_;
				ValaSymbol* _tmp93_;
				ValaSymbol* _tmp94_;
				ValaAttribute* _tmp95_;
				_tmp92_ = ma;
				_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp94_, "Assert");
				_tmp88_ = _tmp95_ != NULL;
			} else {
				_tmp88_ = FALSE;
			}
			if (_tmp88_) {
				ValaList* _tmp96_;
				gint _tmp97_;
				gint _tmp98_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp96_ = self->priv->argument_list;
				_tmp97_ = vala_collection_get_size ((ValaCollection*) _tmp96_);
				_tmp98_ = _tmp97_;
				if (_tmp98_ == 1) {
					ValaList* _tmp99_;
					gpointer _tmp100_;
					ValaExpression* _tmp101_;
					ValaSourceReference* _tmp102_;
					ValaSourceReference* _tmp103_;
					_tmp99_ = self->priv->argument_list;
					_tmp100_ = vala_list_get (_tmp99_, 0);
					_tmp101_ = (ValaExpression*) _tmp100_;
					_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp101_);
					_tmp103_ = _tmp102_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp103_);
					_vala_code_node_unref0 (_tmp101_);
				}
			}
		}
	}
	_tmp104_ = vala_method_call_get_call (self);
	_tmp105_ = _tmp104_;
	_tmp106_ = vala_expression_get_value_type (_tmp105_);
	_tmp107_ = _tmp106_;
	_tmp108_ = _vala_code_node_ref0 (_tmp107_);
	mtype = _tmp108_;
	_tmp110_ = vala_code_context_get_profile (context);
	_tmp111_ = _tmp110_;
	if (_tmp111_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp112_;
		ValaExpression* _tmp113_;
		ValaSymbol* _tmp114_;
		ValaSymbol* _tmp115_;
		ValaSemanticAnalyzer* _tmp116_;
		ValaSemanticAnalyzer* _tmp117_;
		ValaClass* _tmp118_;
		_tmp112_ = vala_method_call_get_call (self);
		_tmp113_ = _tmp112_;
		_tmp114_ = vala_expression_get_symbol_reference (_tmp113_);
		_tmp115_ = _tmp114_;
		_tmp116_ = vala_code_context_get_analyzer (context);
		_tmp117_ = _tmp116_;
		_tmp118_ = _tmp117_->object_type;
		_tmp109_ = _tmp115_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp118_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp109_ = FALSE;
	}
	gobject_chainup = _tmp109_;
	vala_method_call_set_is_chainup (self, gobject_chainup);
	if (!gobject_chainup) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp119_;
		ValaExpression* _tmp120_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp121_;
		gboolean _tmp122_ = FALSE;
		ValaMemberAccess* _tmp123_;
		gboolean _tmp131_ = FALSE;
		ValaMemberAccess* _tmp132_;
		_tmp119_ = vala_method_call_get_call (self);
		_tmp120_ = _tmp119_;
		expr = _tmp120_;
		_tmp121_ = expr;
		ma = VALA_IS_MEMBER_ACCESS (_tmp121_) ? ((ValaMemberAccess*) _tmp121_) : NULL;
		_tmp123_ = ma;
		if (_tmp123_ != NULL) {
			ValaMemberAccess* _tmp124_;
			ValaSymbol* _tmp125_;
			ValaSymbol* _tmp126_;
			_tmp124_ = ma;
			_tmp125_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp124_);
			_tmp126_ = _tmp125_;
			_tmp122_ = VALA_IS_CREATION_METHOD (_tmp126_);
		} else {
			_tmp122_ = FALSE;
		}
		if (_tmp122_) {
			ValaMemberAccess* _tmp127_;
			ValaExpression* _tmp128_;
			ValaExpression* _tmp129_;
			ValaExpression* _tmp130_;
			_tmp127_ = ma;
			_tmp128_ = vala_member_access_get_inner (_tmp127_);
			_tmp129_ = _tmp128_;
			expr = _tmp129_;
			_tmp130_ = expr;
			ma = VALA_IS_MEMBER_ACCESS (_tmp130_) ? ((ValaMemberAccess*) _tmp130_) : NULL;
		}
		_tmp132_ = ma;
		if (_tmp132_ != NULL) {
			ValaMemberAccess* _tmp133_;
			const gchar* _tmp134_;
			const gchar* _tmp135_;
			_tmp133_ = ma;
			_tmp134_ = vala_member_access_get_member_name (_tmp133_);
			_tmp135_ = _tmp134_;
			_tmp131_ = g_strcmp0 (_tmp135_, "this") == 0;
		} else {
			_tmp131_ = FALSE;
		}
		if (_tmp131_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp136_;
			_tmp136_ = expr;
			if (VALA_IS_BASE_ACCESS (_tmp136_)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
	}
	base_cm = NULL;
	_tmp137_ = self->priv->_is_chainup;
	if (_tmp137_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp138_;
		ValaSemanticAnalyzer* _tmp139_;
		ValaMethod* _tmp140_;
		ValaCreationMethod* _tmp141_;
		ValaCreationMethod* _tmp149_;
		ValaDataType* _tmp150_;
		_tmp138_ = vala_code_context_get_analyzer (context);
		_tmp139_ = _tmp138_;
		_tmp140_ = vala_semantic_analyzer_find_current_method (_tmp139_);
		cm = VALA_IS_CREATION_METHOD (_tmp140_) ? ((ValaCreationMethod*) _tmp140_) : NULL;
		_tmp141_ = cm;
		if (_tmp141_ == NULL) {
			ValaSourceReference* _tmp142_;
			ValaSourceReference* _tmp143_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp143_ = _tmp142_;
			vala_report_error (_tmp143_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp144_;
			gboolean _tmp145_;
			gboolean _tmp146_;
			_tmp144_ = cm;
			_tmp145_ = vala_creation_method_get_chain_up (_tmp144_);
			_tmp146_ = _tmp145_;
			if (_tmp146_) {
				ValaSourceReference* _tmp147_;
				ValaSourceReference* _tmp148_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp148_ = _tmp147_;
				vala_report_error (_tmp148_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp149_ = cm;
		vala_creation_method_set_chain_up (_tmp149_, TRUE);
		_tmp150_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp150_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp151_;
			ValaTypeSymbol* _tmp152_;
			ValaTypeSymbol* _tmp153_;
			ValaClass* _tmp154_;
			ValaCreationMethod* _tmp155_;
			ValaCreationMethod* _tmp156_;
			ValaCreationMethod* _tmp157_;
			_tmp151_ = mtype;
			_tmp152_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp151_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp153_ = _tmp152_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp153_, VALA_TYPE_CLASS, ValaClass);
			_tmp154_ = cl;
			_tmp155_ = vala_class_get_default_construction_method (_tmp154_);
			_tmp156_ = _tmp155_;
			base_cm = _tmp156_;
			_tmp157_ = base_cm;
			if (_tmp157_ == NULL) {
				ValaSourceReference* _tmp158_;
				ValaSourceReference* _tmp159_;
				ValaClass* _tmp160_;
				gchar* _tmp161_;
				gchar* _tmp162_;
				gchar* _tmp163_;
				gchar* _tmp164_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp159_ = _tmp158_;
				_tmp160_ = cl;
				_tmp161_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp160_);
				_tmp162_ = _tmp161_;
				_tmp163_ = g_strdup_printf ("chain up to `%s' not supported", _tmp162_);
				_tmp164_ = _tmp163_;
				vala_report_error (_tmp159_, _tmp164_);
				_g_free0 (_tmp164_);
				_g_free0 (_tmp162_);
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp165_;
				gboolean _tmp166_;
				gboolean _tmp167_;
				_tmp165_ = base_cm;
				_tmp166_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp165_);
				_tmp167_ = _tmp166_;
				if (!_tmp167_) {
					ValaSourceReference* _tmp168_;
					ValaSourceReference* _tmp169_;
					ValaCreationMethod* _tmp170_;
					gchar* _tmp171_;
					gchar* _tmp172_;
					gchar* _tmp173_;
					gchar* _tmp174_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp168_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp169_ = _tmp168_;
					_tmp170_ = base_cm;
					_tmp171_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp170_);
					_tmp172_ = _tmp171_;
					_tmp173_ = g_strdup_printf ("chain up to `%s' not supported", _tmp172_);
					_tmp174_ = _tmp173_;
					vala_report_error (_tmp169_, _tmp174_);
					_g_free0 (_tmp174_);
					_g_free0 (_tmp172_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
		} else {
			gboolean _tmp175_ = FALSE;
			ValaExpression* _tmp176_;
			ValaExpression* _tmp177_;
			ValaSymbol* _tmp178_;
			ValaSymbol* _tmp179_;
			_tmp176_ = vala_method_call_get_call (self);
			_tmp177_ = _tmp176_;
			_tmp178_ = vala_expression_get_symbol_reference (_tmp177_);
			_tmp179_ = _tmp178_;
			if (VALA_IS_CREATION_METHOD (_tmp179_)) {
				ValaExpression* _tmp180_;
				ValaExpression* _tmp181_;
				ValaSymbol* _tmp182_;
				ValaSymbol* _tmp183_;
				ValaSymbol* _tmp184_;
				ValaSymbol* _tmp185_;
				_tmp180_ = vala_method_call_get_call (self);
				_tmp181_ = _tmp180_;
				_tmp182_ = vala_expression_get_symbol_reference (_tmp181_);
				_tmp183_ = _tmp182_;
				_tmp184_ = vala_symbol_get_parent_symbol (_tmp183_);
				_tmp185_ = _tmp184_;
				_tmp175_ = VALA_IS_CLASS (_tmp185_);
			} else {
				_tmp175_ = FALSE;
			}
			if (_tmp175_) {
				ValaExpression* _tmp186_;
				ValaExpression* _tmp187_;
				ValaSymbol* _tmp188_;
				ValaSymbol* _tmp189_;
				ValaCreationMethod* _tmp190_;
				gboolean _tmp191_;
				gboolean _tmp192_;
				_tmp186_ = vala_method_call_get_call (self);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_expression_get_symbol_reference (_tmp187_);
				_tmp189_ = _tmp188_;
				base_cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp189_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
				_tmp190_ = base_cm;
				_tmp191_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp190_);
				_tmp192_ = _tmp191_;
				if (!_tmp192_) {
					ValaSourceReference* _tmp193_;
					ValaSourceReference* _tmp194_;
					ValaCreationMethod* _tmp195_;
					gchar* _tmp196_;
					gchar* _tmp197_;
					gchar* _tmp198_;
					gchar* _tmp199_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp193_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp194_ = _tmp193_;
					_tmp195_ = base_cm;
					_tmp196_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp195_);
					_tmp197_ = _tmp196_;
					_tmp198_ = g_strdup_printf ("chain up to `%s' not supported", _tmp197_);
					_tmp199_ = _tmp198_;
					vala_report_error (_tmp194_, _tmp199_);
					_g_free0 (_tmp199_);
					_g_free0 (_tmp197_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				if (gobject_chainup) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp200_;
					ValaSymbol* _tmp201_;
					ValaSymbol* _tmp202_;
					gboolean _tmp203_ = FALSE;
					ValaClass* _tmp204_;
					ValaExpression* _tmp211_;
					ValaExpression* _tmp212_;
					ValaSemanticAnalyzer* _tmp213_;
					ValaSemanticAnalyzer* _tmp214_;
					ValaClass* _tmp215_;
					ValaObjectType* _tmp216_;
					ValaObjectType* _tmp217_;
					ValaExpression* _tmp218_;
					ValaExpression* _tmp219_;
					ValaDataType* _tmp220_;
					ValaDataType* _tmp221_;
					ValaSourceReference* _tmp222_;
					ValaSourceReference* _tmp223_;
					ValaExpression* _tmp224_;
					ValaExpression* _tmp225_;
					ValaDataType* _tmp226_;
					ValaDataType* _tmp227_;
					ValaDataType* _tmp228_;
					_tmp200_ = cm;
					_tmp201_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp200_);
					_tmp202_ = _tmp201_;
					cl = VALA_IS_CLASS (_tmp202_) ? ((ValaClass*) _tmp202_) : NULL;
					_tmp204_ = cl;
					if (_tmp204_ == NULL) {
						_tmp203_ = TRUE;
					} else {
						ValaClass* _tmp205_;
						ValaSemanticAnalyzer* _tmp206_;
						ValaSemanticAnalyzer* _tmp207_;
						ValaClass* _tmp208_;
						_tmp205_ = cl;
						_tmp206_ = vala_code_context_get_analyzer (context);
						_tmp207_ = _tmp206_;
						_tmp208_ = _tmp207_->object_type;
						_tmp203_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp205_, (ValaTypeSymbol*) _tmp208_);
					}
					if (_tmp203_) {
						ValaSourceReference* _tmp209_;
						ValaSourceReference* _tmp210_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp210_ = _tmp209_;
						vala_report_error (_tmp210_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp211_ = vala_method_call_get_call (self);
					_tmp212_ = _tmp211_;
					_tmp213_ = vala_code_context_get_analyzer (context);
					_tmp214_ = _tmp213_;
					_tmp215_ = _tmp214_->object_type;
					_tmp216_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp215_);
					_tmp217_ = _tmp216_;
					vala_expression_set_value_type (_tmp212_, (ValaDataType*) _tmp217_);
					_vala_code_node_unref0 (_tmp217_);
					_tmp218_ = vala_method_call_get_call (self);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_expression_get_value_type (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp223_ = _tmp222_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp221_, _tmp223_);
					_tmp224_ = vala_method_call_get_call (self);
					_tmp225_ = _tmp224_;
					_tmp226_ = vala_expression_get_value_type (_tmp225_);
					_tmp227_ = _tmp226_;
					_tmp228_ = _vala_code_node_ref0 (_tmp227_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp228_;
				}
			}
		}
	}
	_tmp230_ = vala_method_call_get_call (self);
	_tmp231_ = _tmp230_;
	if (VALA_IS_MEMBER_ACCESS (_tmp231_)) {
		gboolean _tmp232_ = FALSE;
		gboolean _tmp233_ = FALSE;
		ValaExpression* _tmp234_;
		ValaExpression* _tmp235_;
		ValaSymbol* _tmp236_;
		ValaSymbol* _tmp237_;
		_tmp234_ = vala_method_call_get_call (self);
		_tmp235_ = _tmp234_;
		_tmp236_ = vala_expression_get_symbol_reference (_tmp235_);
		_tmp237_ = _tmp236_;
		if (VALA_IS_CREATION_METHOD (_tmp237_)) {
			ValaExpression* _tmp238_;
			ValaExpression* _tmp239_;
			ValaSymbol* _tmp240_;
			ValaSymbol* _tmp241_;
			ValaSymbol* _tmp242_;
			ValaSymbol* _tmp243_;
			_tmp238_ = vala_method_call_get_call (self);
			_tmp239_ = _tmp238_;
			_tmp240_ = vala_expression_get_symbol_reference (_tmp239_);
			_tmp241_ = _tmp240_;
			_tmp242_ = vala_symbol_get_parent_symbol (_tmp241_);
			_tmp243_ = _tmp242_;
			_tmp233_ = VALA_IS_STRUCT (_tmp243_);
		} else {
			_tmp233_ = FALSE;
		}
		if (_tmp233_) {
			_tmp232_ = TRUE;
		} else {
			ValaExpression* _tmp244_;
			ValaExpression* _tmp245_;
			ValaSymbol* _tmp246_;
			ValaSymbol* _tmp247_;
			_tmp244_ = vala_method_call_get_call (self);
			_tmp245_ = _tmp244_;
			_tmp246_ = vala_expression_get_symbol_reference (_tmp245_);
			_tmp247_ = _tmp246_;
			_tmp232_ = VALA_IS_STRUCT (_tmp247_);
		}
		_tmp229_ = _tmp232_;
	} else {
		_tmp229_ = FALSE;
	}
	if (_tmp229_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp248_;
		ValaExpression* _tmp249_;
		ValaSymbol* _tmp250_;
		ValaSymbol* _tmp251_;
		gboolean _tmp252_ = FALSE;
		gboolean _tmp253_ = FALSE;
		ValaStruct* _tmp254_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp265_;
		ValaExpression* _tmp266_;
		ValaSourceReference* _tmp267_;
		ValaSourceReference* _tmp268_;
		ValaObjectCreationExpression* _tmp269_;
		ValaObjectCreationExpression* _tmp270_;
		ValaObjectCreationExpression* _tmp282_;
		ValaDataType* _tmp283_;
		ValaDataType* _tmp284_;
		ValaSemanticAnalyzer* _tmp285_;
		ValaSemanticAnalyzer* _tmp286_;
		ValaList* _tmp287_;
		ValaCodeNode* _tmp288_;
		ValaCodeNode* _tmp289_;
		ValaObjectCreationExpression* _tmp290_;
		ValaObjectCreationExpression* _tmp291_;
		_tmp248_ = vala_method_call_get_call (self);
		_tmp249_ = _tmp248_;
		_tmp250_ = vala_expression_get_symbol_reference (_tmp249_);
		_tmp251_ = _tmp250_;
		st = VALA_IS_STRUCT (_tmp251_) ? ((ValaStruct*) _tmp251_) : NULL;
		_tmp254_ = st;
		if (_tmp254_ != NULL) {
			ValaStruct* _tmp255_;
			ValaCreationMethod* _tmp256_;
			ValaCreationMethod* _tmp257_;
			_tmp255_ = st;
			_tmp256_ = vala_struct_get_default_construction_method (_tmp255_);
			_tmp257_ = _tmp256_;
			_tmp253_ = _tmp257_ == NULL;
		} else {
			_tmp253_ = FALSE;
		}
		if (_tmp253_) {
			gboolean _tmp258_ = FALSE;
			gboolean _tmp259_ = FALSE;
			ValaStruct* _tmp260_;
			_tmp260_ = st;
			if (vala_struct_is_boolean_type (_tmp260_)) {
				_tmp259_ = TRUE;
			} else {
				ValaStruct* _tmp261_;
				_tmp261_ = st;
				_tmp259_ = vala_struct_is_integer_type (_tmp261_);
			}
			if (_tmp259_) {
				_tmp258_ = TRUE;
			} else {
				ValaStruct* _tmp262_;
				_tmp262_ = st;
				_tmp258_ = vala_struct_is_floating_type (_tmp262_);
			}
			_tmp252_ = _tmp258_;
		} else {
			_tmp252_ = FALSE;
		}
		if (_tmp252_) {
			ValaSourceReference* _tmp263_;
			ValaSourceReference* _tmp264_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp263_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp264_ = _tmp263_;
			vala_report_error (_tmp264_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp265_ = vala_method_call_get_call (self);
		_tmp266_ = _tmp265_;
		_tmp267_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp268_ = _tmp267_;
		_tmp269_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp266_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp268_);
		struct_creation_expression = _tmp269_;
		_tmp270_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp270_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp271_;
			ValaList* _tmp272_;
			gint _arg_size = 0;
			ValaList* _tmp273_;
			gint _tmp274_;
			gint _tmp275_;
			gint _arg_index = 0;
			_tmp271_ = self->priv->argument_list;
			_tmp272_ = _vala_iterable_ref0 (_tmp271_);
			_arg_list = _tmp272_;
			_tmp273_ = _arg_list;
			_tmp274_ = vala_collection_get_size ((ValaCollection*) _tmp273_);
			_tmp275_ = _tmp274_;
			_arg_size = _tmp275_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp276_;
				gint _tmp277_;
				ValaExpression* arg = NULL;
				ValaList* _tmp278_;
				gpointer _tmp279_;
				ValaObjectCreationExpression* _tmp280_;
				ValaExpression* _tmp281_;
				_arg_index = _arg_index + 1;
				_tmp276_ = _arg_index;
				_tmp277_ = _arg_size;
				if (!(_tmp276_ < _tmp277_)) {
					break;
				}
				_tmp278_ = _arg_list;
				_tmp279_ = vala_list_get (_tmp278_, _arg_index);
				arg = (ValaExpression*) _tmp279_;
				_tmp280_ = struct_creation_expression;
				_tmp281_ = arg;
				vala_object_creation_expression_add_argument (_tmp280_, _tmp281_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp282_ = struct_creation_expression;
		_tmp283_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp284_ = _tmp283_;
		vala_expression_set_target_type ((ValaExpression*) _tmp282_, _tmp284_);
		_tmp285_ = vala_code_context_get_analyzer (context);
		_tmp286_ = _tmp285_;
		_tmp287_ = _tmp286_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp287_, (ValaCodeNode*) self);
		_tmp288_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp289_ = _tmp288_;
		_tmp290_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp289_, (ValaExpression*) self, (ValaExpression*) _tmp290_);
		_tmp291_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp291_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp292_ = FALSE;
		gboolean _tmp293_ = FALSE;
		gboolean _tmp294_;
		_tmp294_ = self->priv->_is_chainup;
		if (!_tmp294_) {
			ValaExpression* _tmp295_;
			ValaExpression* _tmp296_;
			_tmp295_ = vala_method_call_get_call (self);
			_tmp296_ = _tmp295_;
			_tmp293_ = VALA_IS_MEMBER_ACCESS (_tmp296_);
		} else {
			_tmp293_ = FALSE;
		}
		if (_tmp293_) {
			ValaExpression* _tmp297_;
			ValaExpression* _tmp298_;
			ValaSymbol* _tmp299_;
			ValaSymbol* _tmp300_;
			_tmp297_ = vala_method_call_get_call (self);
			_tmp298_ = _tmp297_;
			_tmp299_ = vala_expression_get_symbol_reference (_tmp298_);
			_tmp300_ = _tmp299_;
			_tmp292_ = VALA_IS_CREATION_METHOD (_tmp300_);
		} else {
			_tmp292_ = FALSE;
		}
		if (_tmp292_) {
			ValaSourceReference* _tmp301_;
			ValaSourceReference* _tmp302_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp301_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp302_ = _tmp301_;
			vala_report_error (_tmp302_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp304_ = self->priv->_is_chainup;
	if (!_tmp304_) {
		ValaDataType* _tmp305_;
		_tmp305_ = mtype;
		_tmp303_ = VALA_IS_OBJECT_TYPE (_tmp305_);
	} else {
		_tmp303_ = FALSE;
	}
	if (_tmp303_) {
		ValaSourceReference* _tmp306_;
		ValaSourceReference* _tmp307_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp306_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp307_ = _tmp306_;
		vala_report_error (_tmp307_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp308_ = FALSE;
		ValaDataType* _tmp309_;
		_tmp309_ = mtype;
		if (_tmp309_ != NULL) {
			ValaDataType* _tmp310_;
			_tmp310_ = mtype;
			_tmp308_ = vala_data_type_is_invokable (_tmp310_);
		} else {
			_tmp308_ = FALSE;
		}
		if (_tmp308_) {
		} else {
			ValaExpression* _tmp311_;
			ValaExpression* _tmp312_;
			ValaSymbol* _tmp313_;
			ValaSymbol* _tmp314_;
			_tmp311_ = vala_method_call_get_call (self);
			_tmp312_ = _tmp311_;
			_tmp313_ = vala_expression_get_symbol_reference (_tmp312_);
			_tmp314_ = _tmp313_;
			if (VALA_IS_CLASS (_tmp314_)) {
				ValaSourceReference* _tmp315_;
				ValaSourceReference* _tmp316_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp315_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp316_ = _tmp315_;
				vala_report_error (_tmp316_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp317_;
				ValaSourceReference* _tmp318_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp317_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp318_ = _tmp317_;
				vala_report_error (_tmp318_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp319_ = mtype;
	_tmp320_ = vala_data_type_get_return_type (_tmp319_);
	_tmp321_ = _vala_code_node_ref0 (_tmp320_);
	ret_type = _tmp321_;
	_tmp322_ = mtype;
	_tmp323_ = vala_data_type_get_parameters (_tmp322_);
	_tmp324_ = _vala_iterable_ref0 (_tmp323_);
	params = _tmp324_;
	_tmp325_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp325_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp326_;
		ValaExpression* _tmp327_;
		ValaMethod* m = NULL;
		ValaDataType* _tmp328_;
		ValaMethod* _tmp329_;
		ValaMethod* _tmp330_;
		ValaMethod* _tmp331_;
		gboolean _tmp332_;
		gboolean _tmp333_;
		gint n_type_params = 0;
		ValaMethod* _tmp364_;
		ValaList* _tmp365_;
		gint _tmp366_;
		gint _tmp367_;
		gint n_type_args = 0;
		ValaMemberAccess* _tmp368_;
		ValaList* _tmp369_;
		gint _tmp370_;
		gint _tmp371_;
		gboolean _tmp372_ = FALSE;
		_tmp326_ = vala_method_call_get_call (self);
		_tmp327_ = _tmp326_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp327_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp328_ = mtype;
		_tmp329_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp328_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp330_ = _tmp329_;
		m = _tmp330_;
		_tmp331_ = m;
		_tmp332_ = vala_method_get_coroutine (_tmp331_);
		_tmp333_ = _tmp332_;
		if (_tmp333_) {
			gboolean _tmp334_;
			_tmp334_ = self->priv->_is_yield_expression;
			if (!_tmp334_) {
				ValaMemberAccess* _tmp335_;
				const gchar* _tmp336_;
				const gchar* _tmp337_;
				_tmp335_ = ma;
				_tmp336_ = vala_member_access_get_member_name (_tmp335_);
				_tmp337_ = _tmp336_;
				if (g_strcmp0 (_tmp337_, "end") != 0) {
					ValaMemberAccess* _tmp338_;
					const gchar* _tmp339_;
					const gchar* _tmp340_;
					ValaMethod* _tmp344_;
					ValaList* _tmp345_;
					ValaVoidType* _tmp346_;
					_tmp338_ = ma;
					_tmp339_ = vala_member_access_get_member_name (_tmp338_);
					_tmp340_ = _tmp339_;
					if (g_strcmp0 (_tmp340_, "begin") != 0) {
						ValaMemberAccess* _tmp341_;
						ValaSourceReference* _tmp342_;
						ValaSourceReference* _tmp343_;
						_tmp341_ = ma;
						_tmp342_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp341_);
						_tmp343_ = _tmp342_;
						vala_report_deprecated (_tmp343_, "implicit .begin is deprecated");
					}
					_tmp344_ = m;
					_tmp345_ = vala_method_get_async_begin_parameters (_tmp344_);
					_vala_iterable_unref0 (params);
					params = _tmp345_;
					_tmp346_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp346_;
				} else {
					ValaMethod* _tmp347_;
					ValaList* _tmp348_;
					_tmp347_ = m;
					_tmp348_ = vala_method_get_async_end_parameters (_tmp347_);
					_vala_iterable_unref0 (params);
					params = _tmp348_;
				}
			} else {
				gboolean _tmp349_ = FALSE;
				ValaMemberAccess* _tmp350_;
				const gchar* _tmp351_;
				const gchar* _tmp352_;
				_tmp350_ = ma;
				_tmp351_ = vala_member_access_get_member_name (_tmp350_);
				_tmp352_ = _tmp351_;
				if (g_strcmp0 (_tmp352_, "begin") == 0) {
					_tmp349_ = TRUE;
				} else {
					ValaMemberAccess* _tmp353_;
					const gchar* _tmp354_;
					const gchar* _tmp355_;
					_tmp353_ = ma;
					_tmp354_ = vala_member_access_get_member_name (_tmp353_);
					_tmp355_ = _tmp354_;
					_tmp349_ = g_strcmp0 (_tmp355_, "end") == 0;
				}
				if (_tmp349_) {
					ValaMemberAccess* _tmp356_;
					ValaSourceReference* _tmp357_;
					ValaSourceReference* _tmp358_;
					ValaMemberAccess* _tmp359_;
					const gchar* _tmp360_;
					const gchar* _tmp361_;
					gchar* _tmp362_;
					gchar* _tmp363_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp356_ = ma;
					_tmp357_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp356_);
					_tmp358_ = _tmp357_;
					_tmp359_ = ma;
					_tmp360_ = vala_member_access_get_member_name (_tmp359_);
					_tmp361_ = _tmp360_;
					_tmp362_ = g_strdup_printf ("use of `%s' not allowed in yield statement", _tmp361_);
					_tmp363_ = _tmp362_;
					vala_report_error (_tmp358_, _tmp363_);
					_g_free0 (_tmp363_);
				}
			}
		}
		_tmp364_ = m;
		_tmp365_ = vala_method_get_type_parameters (_tmp364_);
		_tmp366_ = vala_collection_get_size ((ValaCollection*) _tmp365_);
		_tmp367_ = _tmp366_;
		n_type_params = _tmp367_;
		_tmp368_ = ma;
		_tmp369_ = vala_member_access_get_type_arguments (_tmp368_);
		_tmp370_ = vala_collection_get_size ((ValaCollection*) _tmp369_);
		_tmp371_ = _tmp370_;
		n_type_args = _tmp371_;
		if (n_type_args > 0) {
			_tmp372_ = n_type_args < n_type_params;
		} else {
			_tmp372_ = FALSE;
		}
		if (_tmp372_) {
			ValaMemberAccess* _tmp373_;
			ValaSourceReference* _tmp374_;
			ValaSourceReference* _tmp375_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp373_ = ma;
			_tmp374_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp373_);
			_tmp375_ = _tmp374_;
			vala_report_error (_tmp375_, "too few type arguments");
			result = FALSE;
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			gboolean _tmp376_ = FALSE;
			if (n_type_args > 0) {
				_tmp376_ = n_type_args > n_type_params;
			} else {
				_tmp376_ = FALSE;
			}
			if (_tmp376_) {
				ValaMemberAccess* _tmp377_;
				ValaSourceReference* _tmp378_;
				ValaSourceReference* _tmp379_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp377_ = ma;
				_tmp378_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp377_);
				_tmp379_ = _tmp378_;
				vala_report_error (_tmp379_, "too many type arguments");
				result = FALSE;
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	last_arg = NULL;
	_tmp380_ = self->priv->argument_list;
	_tmp381_ = vala_iterable_iterator ((ValaIterable*) _tmp380_);
	arg_it = _tmp381_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp382_;
		ValaList* _tmp383_;
		gint _param_size = 0;
		ValaList* _tmp384_;
		gint _tmp385_;
		gint _tmp386_;
		gint _param_index = 0;
		_tmp382_ = params;
		_tmp383_ = _vala_iterable_ref0 (_tmp382_);
		_param_list = _tmp383_;
		_tmp384_ = _param_list;
		_tmp385_ = vala_collection_get_size ((ValaCollection*) _tmp384_);
		_tmp386_ = _tmp385_;
		_param_size = _tmp386_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp387_;
			gint _tmp388_;
			ValaParameter* param = NULL;
			ValaList* _tmp389_;
			gpointer _tmp390_;
			ValaParameter* _tmp391_;
			ValaParameter* _tmp392_;
			gboolean _tmp393_;
			gboolean _tmp394_;
			ValaParameter* _tmp395_;
			gboolean _tmp396_;
			gboolean _tmp397_;
			ValaIterator* _tmp415_;
			_param_index = _param_index + 1;
			_tmp387_ = _param_index;
			_tmp388_ = _param_size;
			if (!(_tmp387_ < _tmp388_)) {
				break;
			}
			_tmp389_ = _param_list;
			_tmp390_ = vala_list_get (_tmp389_, _param_index);
			param = (ValaParameter*) _tmp390_;
			_tmp391_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp391_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp392_ = param;
			_tmp393_ = vala_parameter_get_ellipsis (_tmp392_);
			_tmp394_ = _tmp393_;
			if (_tmp394_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp395_ = param;
			_tmp396_ = vala_parameter_get_params_array (_tmp395_);
			_tmp397_ = _tmp396_;
			if (_tmp397_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp398_;
				ValaDataType* _tmp399_;
				ValaDataType* _tmp400_;
				ValaArrayType* _tmp401_;
				_tmp398_ = param;
				_tmp399_ = vala_variable_get_variable_type ((ValaVariable*) _tmp398_);
				_tmp400_ = _tmp399_;
				_tmp401_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp400_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp401_;
				while (TRUE) {
					ValaIterator* _tmp402_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp403_;
					gpointer _tmp404_;
					ValaExpression* _tmp405_;
					ValaArrayType* _tmp406_;
					ValaDataType* _tmp407_;
					ValaDataType* _tmp408_;
					ValaExpression* _tmp409_;
					ValaDataType* _tmp410_;
					ValaDataType* _tmp411_;
					ValaArrayType* _tmp412_;
					gboolean _tmp413_;
					gboolean _tmp414_;
					_tmp402_ = arg_it;
					if (!vala_iterator_next (_tmp402_)) {
						break;
					}
					_tmp403_ = arg_it;
					_tmp404_ = vala_iterator_get (_tmp403_);
					arg = (ValaExpression*) _tmp404_;
					_tmp405_ = arg;
					_tmp406_ = array_type;
					_tmp407_ = vala_array_type_get_element_type (_tmp406_);
					_tmp408_ = _tmp407_;
					vala_expression_set_target_type (_tmp405_, _tmp408_);
					_tmp409_ = arg;
					_tmp410_ = vala_expression_get_target_type (_tmp409_);
					_tmp411_ = _tmp410_;
					_tmp412_ = array_type;
					_tmp413_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp412_);
					_tmp414_ = _tmp413_;
					vala_data_type_set_value_owned (_tmp411_, _tmp414_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp415_ = arg_it;
			if (vala_iterator_next (_tmp415_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp416_;
				gpointer _tmp417_;
				ValaExpression* _tmp418_;
				ValaParameter* _tmp419_;
				ValaDataType* _tmp420_;
				ValaDataType* _tmp421_;
				ValaExpression* _tmp422_;
				ValaExpression* _tmp423_;
				ValaDataType* _tmp424_;
				ValaDataType* _tmp425_;
				ValaDataType* _tmp426_;
				ValaList* _tmp427_;
				ValaDataType* _tmp428_;
				ValaDataType* _tmp429_;
				ValaExpression* _tmp430_;
				ValaExpression* _tmp431_;
				_tmp416_ = arg_it;
				_tmp417_ = vala_iterator_get (_tmp416_);
				arg = (ValaExpression*) _tmp417_;
				_tmp418_ = arg;
				_tmp419_ = param;
				_tmp420_ = vala_variable_get_variable_type ((ValaVariable*) _tmp419_);
				_tmp421_ = _tmp420_;
				vala_expression_set_formal_target_type (_tmp418_, _tmp421_);
				_tmp422_ = arg;
				_tmp423_ = arg;
				_tmp424_ = vala_expression_get_formal_target_type (_tmp423_);
				_tmp425_ = _tmp424_;
				_tmp426_ = target_object_type;
				_tmp427_ = method_type_args;
				_tmp428_ = vala_data_type_get_actual_type (_tmp425_, _tmp426_, _tmp427_, (ValaCodeNode*) self);
				_tmp429_ = _tmp428_;
				vala_expression_set_target_type (_tmp422_, _tmp429_);
				_vala_code_node_unref0 (_tmp429_);
				_tmp430_ = arg;
				_tmp431_ = _vala_code_node_ref0 (_tmp430_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp431_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp433_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp433_)) {
		ValaDataType* _tmp434_;
		ValaMethod* _tmp435_;
		ValaMethod* _tmp436_;
		ValaAttribute* _tmp437_;
		_tmp434_ = mtype;
		_tmp435_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp434_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp436_ = _tmp435_;
		_tmp437_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp436_, "Print");
		_tmp432_ = _tmp437_ != NULL;
	} else {
		_tmp432_ = FALSE;
	}
	if (_tmp432_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp438_;
		ValaSourceReference* _tmp439_;
		ValaTemplate* _tmp440_;
		ValaList* _tmp453_;
		ValaTemplate* _tmp454_;
		_tmp438_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp439_ = _tmp438_;
		_tmp440_ = vala_template_new (_tmp439_);
		template = _tmp440_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp441_;
			ValaList* _tmp442_;
			gint _arg_size = 0;
			ValaList* _tmp443_;
			gint _tmp444_;
			gint _tmp445_;
			gint _arg_index = 0;
			_tmp441_ = self->priv->argument_list;
			_tmp442_ = _vala_iterable_ref0 (_tmp441_);
			_arg_list = _tmp442_;
			_tmp443_ = _arg_list;
			_tmp444_ = vala_collection_get_size ((ValaCollection*) _tmp443_);
			_tmp445_ = _tmp444_;
			_arg_size = _tmp445_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp446_;
				gint _tmp447_;
				ValaExpression* arg = NULL;
				ValaList* _tmp448_;
				gpointer _tmp449_;
				ValaExpression* _tmp450_;
				ValaTemplate* _tmp451_;
				ValaExpression* _tmp452_;
				_arg_index = _arg_index + 1;
				_tmp446_ = _arg_index;
				_tmp447_ = _arg_size;
				if (!(_tmp446_ < _tmp447_)) {
					break;
				}
				_tmp448_ = _arg_list;
				_tmp449_ = vala_list_get (_tmp448_, _arg_index);
				arg = (ValaExpression*) _tmp449_;
				_tmp450_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp450_, NULL);
				_tmp451_ = template;
				_tmp452_ = arg;
				vala_template_add_expression (_tmp451_, _tmp452_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp453_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp453_);
		_tmp454_ = template;
		vala_method_call_add_argument (self, (ValaExpression*) _tmp454_);
		_vala_code_node_unref0 (template);
	}
	_tmp456_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp456_)) {
		ValaDataType* _tmp457_;
		ValaMethod* _tmp458_;
		ValaMethod* _tmp459_;
		gboolean _tmp460_;
		gboolean _tmp461_;
		_tmp457_ = mtype;
		_tmp458_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp457_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp459_ = _tmp458_;
		_tmp460_ = vala_method_get_printf_format (_tmp459_);
		_tmp461_ = _tmp460_;
		_tmp455_ = _tmp461_;
	} else {
		_tmp455_ = FALSE;
	}
	if (_tmp455_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp462_;
		ValaStringLiteral* _tmp512_;
		format_literal = NULL;
		_tmp462_ = last_arg;
		if (VALA_IS_NULL_LITERAL (_tmp462_)) {
		} else {
			ValaExpression* _tmp463_;
			_tmp463_ = last_arg;
			if (_tmp463_ != NULL) {
				ValaExpression* _tmp464_;
				ValaStringLiteral* _tmp465_;
				gboolean _tmp466_ = FALSE;
				ValaStringLiteral* _tmp467_;
				_tmp464_ = last_arg;
				_tmp465_ = vala_string_literal_get_format_literal (_tmp464_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp465_;
				_tmp467_ = format_literal;
				if (_tmp467_ == NULL) {
					ValaList* _tmp468_;
					gint _tmp469_;
					gint _tmp470_;
					ValaList* _tmp471_;
					gint _tmp472_;
					gint _tmp473_;
					_tmp468_ = self->priv->argument_list;
					_tmp469_ = vala_collection_get_size ((ValaCollection*) _tmp468_);
					_tmp470_ = _tmp469_;
					_tmp471_ = params;
					_tmp472_ = vala_collection_get_size ((ValaCollection*) _tmp471_);
					_tmp473_ = _tmp472_;
					_tmp466_ = _tmp470_ == (_tmp473_ - 1);
				} else {
					_tmp466_ = FALSE;
				}
				if (_tmp466_) {
					ValaStringLiteral* _tmp474_;
					ValaStringLiteral* _tmp475_;
					ValaSemanticAnalyzer* _tmp476_;
					ValaSemanticAnalyzer* _tmp477_;
					ValaDataType* _tmp478_;
					ValaDataType* _tmp479_;
					ValaDataType* _tmp480_;
					ValaList* _tmp481_;
					ValaList* _tmp482_;
					gint _tmp483_;
					gint _tmp484_;
					ValaStringLiteral* _tmp485_;
					ValaList* _tmp486_;
					ValaIterator* _tmp487_;
					_tmp474_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp474_;
					_tmp475_ = format_literal;
					_tmp476_ = vala_code_context_get_analyzer (context);
					_tmp477_ = _tmp476_;
					_tmp478_ = _tmp477_->string_type;
					_tmp479_ = vala_data_type_copy (_tmp478_);
					_tmp480_ = _tmp479_;
					vala_expression_set_target_type ((ValaExpression*) _tmp475_, _tmp480_);
					_vala_code_node_unref0 (_tmp480_);
					_tmp481_ = self->priv->argument_list;
					_tmp482_ = self->priv->argument_list;
					_tmp483_ = vala_collection_get_size ((ValaCollection*) _tmp482_);
					_tmp484_ = _tmp483_;
					_tmp485_ = format_literal;
					vala_list_insert (_tmp481_, _tmp484_ - 1, (ValaExpression*) _tmp485_);
					_tmp486_ = self->priv->argument_list;
					_tmp487_ = vala_iterable_iterator ((ValaIterable*) _tmp486_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp487_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp488_;
						ValaList* _tmp489_;
						gint _param_size = 0;
						ValaList* _tmp490_;
						gint _tmp491_;
						gint _tmp492_;
						gint _param_index = 0;
						_tmp488_ = params;
						_tmp489_ = _vala_iterable_ref0 (_tmp488_);
						_param_list = _tmp489_;
						_tmp490_ = _param_list;
						_tmp491_ = vala_collection_get_size ((ValaCollection*) _tmp490_);
						_tmp492_ = _tmp491_;
						_param_size = _tmp492_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp493_;
							gint _tmp494_;
							ValaParameter* param = NULL;
							ValaList* _tmp495_;
							gpointer _tmp496_;
							gboolean _tmp497_ = FALSE;
							ValaParameter* _tmp498_;
							gboolean _tmp499_;
							gboolean _tmp500_;
							ValaIterator* _tmp504_;
							_param_index = _param_index + 1;
							_tmp493_ = _param_index;
							_tmp494_ = _param_size;
							if (!(_tmp493_ < _tmp494_)) {
								break;
							}
							_tmp495_ = _param_list;
							_tmp496_ = vala_list_get (_tmp495_, _param_index);
							param = (ValaParameter*) _tmp496_;
							_tmp498_ = param;
							_tmp499_ = vala_parameter_get_ellipsis (_tmp498_);
							_tmp500_ = _tmp499_;
							if (_tmp500_) {
								_tmp497_ = TRUE;
							} else {
								ValaParameter* _tmp501_;
								gboolean _tmp502_;
								gboolean _tmp503_;
								_tmp501_ = param;
								_tmp502_ = vala_parameter_get_params_array (_tmp501_);
								_tmp503_ = _tmp502_;
								_tmp497_ = _tmp503_;
							}
							if (_tmp497_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp504_ = arg_it;
							vala_iterator_next (_tmp504_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp505_;
				ValaExpression* _tmp506_;
				ValaMemberAccess* _tmp507_;
				_tmp505_ = vala_method_call_get_call (self);
				_tmp506_ = _tmp505_;
				ma = VALA_IS_MEMBER_ACCESS (_tmp506_) ? ((ValaMemberAccess*) _tmp506_) : NULL;
				_tmp507_ = ma;
				if (_tmp507_ != NULL) {
					ValaMemberAccess* _tmp508_;
					ValaExpression* _tmp509_;
					ValaExpression* _tmp510_;
					ValaStringLiteral* _tmp511_;
					_tmp508_ = ma;
					_tmp509_ = vala_member_access_get_inner (_tmp508_);
					_tmp510_ = _tmp509_;
					_tmp511_ = vala_string_literal_get_format_literal (_tmp510_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp511_;
				}
			}
		}
		_tmp512_ = format_literal;
		if (_tmp512_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp513_;
			gchar* _tmp514_;
			ValaSemanticAnalyzer* _tmp515_;
			ValaSemanticAnalyzer* _tmp516_;
			const gchar* _tmp517_;
			ValaIterator* _tmp518_;
			ValaSourceReference* _tmp519_;
			ValaSourceReference* _tmp520_;
			_tmp513_ = format_literal;
			_tmp514_ = vala_string_literal_eval (_tmp513_);
			format = _tmp514_;
			_tmp515_ = vala_code_context_get_analyzer (context);
			_tmp516_ = _tmp515_;
			_tmp517_ = format;
			_tmp518_ = arg_it;
			_tmp519_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp520_ = _tmp519_;
			if (!vala_semantic_analyzer_check_print_format (_tmp516_, _tmp517_, _tmp518_, _tmp520_)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	force_lambda_method_closure = FALSE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp521_;
		ValaList* _tmp522_;
		gint _arg_size = 0;
		ValaList* _tmp523_;
		gint _tmp524_;
		gint _tmp525_;
		gint _arg_index = 0;
		_tmp521_ = self->priv->argument_list;
		_tmp522_ = _vala_iterable_ref0 (_tmp521_);
		_arg_list = _tmp522_;
		_tmp523_ = _arg_list;
		_tmp524_ = vala_collection_get_size ((ValaCollection*) _tmp523_);
		_tmp525_ = _tmp524_;
		_arg_size = _tmp525_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp526_;
			gint _tmp527_;
			ValaExpression* arg = NULL;
			ValaList* _tmp528_;
			gpointer _tmp529_;
			ValaExpression* _tmp530_;
			gboolean _tmp531_ = FALSE;
			ValaExpression* _tmp532_;
			_arg_index = _arg_index + 1;
			_tmp526_ = _arg_index;
			_tmp527_ = _arg_size;
			if (!(_tmp526_ < _tmp527_)) {
				break;
			}
			_tmp528_ = _arg_list;
			_tmp529_ = vala_list_get (_tmp528_, _arg_index);
			arg = (ValaExpression*) _tmp529_;
			_tmp530_ = arg;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp530_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp532_ = arg;
			if (VALA_IS_LAMBDA_EXPRESSION (_tmp532_)) {
				ValaExpression* _tmp533_;
				ValaMethod* _tmp534_;
				ValaMethod* _tmp535_;
				gboolean _tmp536_;
				gboolean _tmp537_;
				_tmp533_ = arg;
				_tmp534_ = vala_lambda_expression_get_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp533_, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression));
				_tmp535_ = _tmp534_;
				_tmp536_ = vala_method_get_closure (_tmp535_);
				_tmp537_ = _tmp536_;
				_tmp531_ = _tmp537_;
			} else {
				_tmp531_ = FALSE;
			}
			if (_tmp531_) {
				force_lambda_method_closure = TRUE;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp539_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp540_ = _tmp539_;
	if (!_tmp540_) {
		_tmp538_ = force_lambda_method_closure;
	} else {
		_tmp538_ = FALSE;
	}
	if (_tmp538_) {
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp541_;
			ValaList* _tmp542_;
			gint _arg_size = 0;
			ValaList* _tmp543_;
			gint _tmp544_;
			gint _tmp545_;
			gint _arg_index = 0;
			_tmp541_ = self->priv->argument_list;
			_tmp542_ = _vala_iterable_ref0 (_tmp541_);
			_arg_list = _tmp542_;
			_tmp543_ = _arg_list;
			_tmp544_ = vala_collection_get_size ((ValaCollection*) _tmp543_);
			_tmp545_ = _tmp544_;
			_arg_size = _tmp545_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp546_;
				gint _tmp547_;
				ValaExpression* arg = NULL;
				ValaList* _tmp548_;
				gpointer _tmp549_;
				ValaLambdaExpression* lambda = NULL;
				ValaExpression* _tmp550_;
				gboolean _tmp551_ = FALSE;
				ValaLambdaExpression* _tmp552_;
				_arg_index = _arg_index + 1;
				_tmp546_ = _arg_index;
				_tmp547_ = _arg_size;
				if (!(_tmp546_ < _tmp547_)) {
					break;
				}
				_tmp548_ = _arg_list;
				_tmp549_ = vala_list_get (_tmp548_, _arg_index);
				arg = (ValaExpression*) _tmp549_;
				_tmp550_ = arg;
				lambda = VALA_IS_LAMBDA_EXPRESSION (_tmp550_) ? ((ValaLambdaExpression*) _tmp550_) : NULL;
				_tmp552_ = lambda;
				if (_tmp552_ != NULL) {
					ValaLambdaExpression* _tmp553_;
					ValaMethod* _tmp554_;
					ValaMethod* _tmp555_;
					ValaMemberBinding _tmp556_;
					ValaMemberBinding _tmp557_;
					_tmp553_ = lambda;
					_tmp554_ = vala_lambda_expression_get_method (_tmp553_);
					_tmp555_ = _tmp554_;
					_tmp556_ = vala_method_get_binding (_tmp555_);
					_tmp557_ = _tmp556_;
					_tmp551_ = _tmp557_ != VALA_MEMBER_BINDING_STATIC;
				} else {
					_tmp551_ = FALSE;
				}
				if (_tmp551_) {
					ValaLambdaExpression* _tmp558_;
					ValaMethod* _tmp559_;
					ValaMethod* _tmp560_;
					_tmp558_ = lambda;
					_tmp559_ = vala_lambda_expression_get_method (_tmp558_);
					_tmp560_ = _tmp559_;
					vala_method_set_closure (_tmp560_, TRUE);
				}
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
	}
	_tmp561_ = ret_type;
	if (VALA_IS_VOID_TYPE (_tmp561_)) {
		gboolean _tmp562_ = FALSE;
		gboolean _tmp563_ = FALSE;
		ValaCodeNode* _tmp564_;
		ValaCodeNode* _tmp565_;
		_tmp564_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp565_ = _tmp564_;
		if (!VALA_IS_EXPRESSION_STATEMENT (_tmp565_)) {
			ValaCodeNode* _tmp566_;
			ValaCodeNode* _tmp567_;
			_tmp566_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp567_ = _tmp566_;
			_tmp563_ = !VALA_IS_FOR_STATEMENT (_tmp567_);
		} else {
			_tmp563_ = FALSE;
		}
		if (_tmp563_) {
			ValaCodeNode* _tmp568_;
			ValaCodeNode* _tmp569_;
			_tmp568_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp569_ = _tmp568_;
			_tmp562_ = !VALA_IS_YIELD_STATEMENT (_tmp569_);
		} else {
			_tmp562_ = FALSE;
		}
		if (_tmp562_) {
			ValaSourceReference* _tmp570_;
			ValaSourceReference* _tmp571_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp570_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp571_ = _tmp570_;
			vala_report_error (_tmp571_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp572_ = ret_type;
	_tmp573_ = vala_data_type_copy (_tmp572_);
	_tmp574_ = _tmp573_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp574_);
	_vala_code_node_unref0 (_tmp574_);
	_tmp575_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp576_ = _tmp575_;
	_tmp577_ = target_object_type;
	_tmp578_ = method_type_args;
	_tmp579_ = vala_data_type_get_actual_type (_tmp576_, _tmp577_, _tmp578_, (ValaCodeNode*) self);
	_tmp580_ = _tmp579_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp580_);
	_vala_code_node_unref0 (_tmp580_);
	_tmp581_ = self->priv->_is_yield_expression;
	if (_tmp581_) {
		gboolean _tmp582_ = FALSE;
		ValaDataType* _tmp583_;
		gboolean _tmp591_ = FALSE;
		ValaSemanticAnalyzer* _tmp592_;
		ValaSemanticAnalyzer* _tmp593_;
		ValaMethod* _tmp594_;
		ValaMethod* _tmp595_;
		_tmp583_ = mtype;
		if (!VALA_IS_METHOD_TYPE (_tmp583_)) {
			_tmp582_ = TRUE;
		} else {
			ValaDataType* _tmp584_;
			ValaMethod* _tmp585_;
			ValaMethod* _tmp586_;
			gboolean _tmp587_;
			gboolean _tmp588_;
			_tmp584_ = mtype;
			_tmp585_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp584_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
			_tmp586_ = _tmp585_;
			_tmp587_ = vala_method_get_coroutine (_tmp586_);
			_tmp588_ = _tmp587_;
			_tmp582_ = !_tmp588_;
		}
		if (_tmp582_) {
			ValaSourceReference* _tmp589_;
			ValaSourceReference* _tmp590_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp589_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp590_ = _tmp589_;
			vala_report_error (_tmp590_, "yield expression requires async method");
		}
		_tmp592_ = vala_code_context_get_analyzer (context);
		_tmp593_ = _tmp592_;
		_tmp594_ = vala_semantic_analyzer_get_current_method (_tmp593_);
		_tmp595_ = _tmp594_;
		if (_tmp595_ == NULL) {
			_tmp591_ = TRUE;
		} else {
			ValaSemanticAnalyzer* _tmp596_;
			ValaSemanticAnalyzer* _tmp597_;
			ValaMethod* _tmp598_;
			ValaMethod* _tmp599_;
			gboolean _tmp600_;
			gboolean _tmp601_;
			_tmp596_ = vala_code_context_get_analyzer (context);
			_tmp597_ = _tmp596_;
			_tmp598_ = vala_semantic_analyzer_get_current_method (_tmp597_);
			_tmp599_ = _tmp598_;
			_tmp600_ = vala_method_get_coroutine (_tmp599_);
			_tmp601_ = _tmp600_;
			_tmp591_ = !_tmp601_;
		}
		if (_tmp591_) {
			ValaSourceReference* _tmp602_;
			ValaSourceReference* _tmp603_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp602_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp603_ = _tmp602_;
			vala_report_error (_tmp603_, "yield expression not available outside async method");
		}
	}
	_tmp604_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp604_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp605_;
		ValaMethod* _tmp606_;
		ValaMethod* _tmp607_;
		ValaMethod* _tmp608_;
		gboolean _tmp609_;
		gboolean _tmp610_;
		ValaMethod* _tmp613_;
		gboolean _tmp614_;
		gboolean _tmp615_;
		gboolean _tmp643_ = FALSE;
		gboolean _tmp644_ = FALSE;
		gboolean _tmp645_ = FALSE;
		gboolean _tmp646_;
		gboolean _tmp647_;
		ValaSignal* sig = NULL;
		ValaMethod* _tmp659_;
		ValaSymbol* _tmp660_;
		ValaSymbol* _tmp661_;
		gboolean _tmp662_ = FALSE;
		ValaSignal* _tmp663_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp676_;
		ValaSymbol* _tmp677_;
		ValaSymbol* _tmp678_;
		gboolean _tmp679_ = FALSE;
		ValaDynamicSignal* _tmp680_;
		gboolean _tmp731_ = FALSE;
		ValaMethod* _tmp732_;
		gboolean _tmp845_ = FALSE;
		ValaMethod* _tmp846_;
		_tmp605_ = mtype;
		_tmp606_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp605_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp607_ = _tmp606_;
		m = _tmp607_;
		_tmp608_ = m;
		_tmp609_ = vala_method_get_returns_floating_reference (_tmp608_);
		_tmp610_ = _tmp609_;
		if (_tmp610_) {
			ValaDataType* _tmp611_;
			ValaDataType* _tmp612_;
			_tmp611_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp612_ = _tmp611_;
			vala_data_type_set_floating_reference (_tmp612_, TRUE);
		}
		_tmp613_ = m;
		_tmp614_ = vala_method_get_returns_modified_pointer (_tmp613_);
		_tmp615_ = _tmp614_;
		if (_tmp615_) {
			ValaExpression* inner = NULL;
			ValaExpression* _tmp616_;
			ValaExpression* _tmp617_;
			ValaExpression* _tmp618_;
			ValaExpression* _tmp619_;
			ValaExpression* _tmp620_;
			ValaProperty* prop = NULL;
			ValaExpression* _tmp621_;
			ValaSymbol* _tmp622_;
			ValaSymbol* _tmp623_;
			gboolean _tmp624_ = FALSE;
			ValaProperty* _tmp625_;
			_tmp616_ = vala_method_call_get_call (self);
			_tmp617_ = _tmp616_;
			_tmp618_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp617_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp619_ = _tmp618_;
			inner = _tmp619_;
			_tmp620_ = inner;
			vala_expression_set_lvalue (_tmp620_, TRUE);
			_tmp621_ = inner;
			_tmp622_ = vala_expression_get_symbol_reference (_tmp621_);
			_tmp623_ = _tmp622_;
			prop = VALA_IS_PROPERTY (_tmp623_) ? ((ValaProperty*) _tmp623_) : NULL;
			_tmp625_ = prop;
			if (_tmp625_ != NULL) {
				gboolean _tmp626_ = FALSE;
				ValaProperty* _tmp627_;
				ValaPropertyAccessor* _tmp628_;
				ValaPropertyAccessor* _tmp629_;
				_tmp627_ = prop;
				_tmp628_ = vala_property_get_set_accessor (_tmp627_);
				_tmp629_ = _tmp628_;
				if (_tmp629_ == NULL) {
					_tmp626_ = TRUE;
				} else {
					ValaProperty* _tmp630_;
					ValaPropertyAccessor* _tmp631_;
					ValaPropertyAccessor* _tmp632_;
					gboolean _tmp633_;
					gboolean _tmp634_;
					_tmp630_ = prop;
					_tmp631_ = vala_property_get_set_accessor (_tmp630_);
					_tmp632_ = _tmp631_;
					_tmp633_ = vala_property_accessor_get_writable (_tmp632_);
					_tmp634_ = _tmp633_;
					_tmp626_ = !_tmp634_;
				}
				_tmp624_ = _tmp626_;
			} else {
				_tmp624_ = FALSE;
			}
			if (_tmp624_) {
				ValaExpression* _tmp635_;
				ValaSourceReference* _tmp636_;
				ValaSourceReference* _tmp637_;
				ValaProperty* _tmp638_;
				gchar* _tmp639_;
				gchar* _tmp640_;
				gchar* _tmp641_;
				gchar* _tmp642_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp635_ = inner;
				_tmp636_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp635_);
				_tmp637_ = _tmp636_;
				_tmp638_ = prop;
				_tmp639_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp638_);
				_tmp640_ = _tmp639_;
				_tmp641_ = g_strdup_printf ("Property `%s' is read-only", _tmp640_);
				_tmp642_ = _tmp641_;
				vala_report_error (_tmp637_, _tmp642_);
				_g_free0 (_tmp642_);
				_g_free0 (_tmp640_);
			}
		}
		_tmp646_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp647_ = _tmp646_;
		if (_tmp647_) {
			ValaDataType* _tmp648_;
			ValaDataType* _tmp649_;
			gboolean _tmp650_;
			gboolean _tmp651_;
			_tmp648_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp649_ = _tmp648_;
			_tmp650_ = vala_data_type_get_nullable (_tmp649_);
			_tmp651_ = _tmp650_;
			_tmp645_ = !_tmp651_;
		} else {
			_tmp645_ = FALSE;
		}
		if (_tmp645_) {
			ValaDataType* _tmp652_;
			ValaDataType* _tmp653_;
			gboolean _tmp654_;
			gboolean _tmp655_;
			_tmp652_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp653_ = _tmp652_;
			_tmp654_ = vala_data_type_get_floating_reference (_tmp653_);
			_tmp655_ = _tmp654_;
			_tmp644_ = _tmp655_;
		} else {
			_tmp644_ = FALSE;
		}
		if (_tmp644_) {
			ValaDataType* _tmp656_;
			_tmp656_ = ret_type;
			_tmp643_ = VALA_IS_OBJECT_TYPE (_tmp656_);
		} else {
			_tmp643_ = FALSE;
		}
		if (_tmp643_) {
			ValaDataType* _tmp657_;
			ValaDataType* _tmp658_;
			_tmp657_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp658_ = _tmp657_;
			vala_data_type_set_nullable (_tmp658_, TRUE);
		}
		_tmp659_ = m;
		_tmp660_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp659_);
		_tmp661_ = _tmp660_;
		sig = VALA_IS_SIGNAL (_tmp661_) ? ((ValaSignal*) _tmp661_) : NULL;
		_tmp663_ = sig;
		if (_tmp663_ != NULL) {
			ValaMethod* _tmp664_;
			const gchar* _tmp665_;
			const gchar* _tmp666_;
			_tmp664_ = m;
			_tmp665_ = vala_symbol_get_name ((ValaSymbol*) _tmp664_);
			_tmp666_ = _tmp665_;
			_tmp662_ = g_strcmp0 (_tmp666_, "disconnect") == 0;
		} else {
			_tmp662_ = FALSE;
		}
		if (_tmp662_) {
			gboolean _tmp667_ = FALSE;
			ValaList* _tmp668_;
			gboolean _tmp669_;
			gboolean _tmp670_;
			_tmp668_ = self->priv->argument_list;
			_tmp669_ = vala_collection_get_is_empty ((ValaCollection*) _tmp668_);
			_tmp670_ = _tmp669_;
			if (!_tmp670_) {
				ValaList* _tmp671_;
				gpointer _tmp672_;
				ValaExpression* _tmp673_;
				_tmp671_ = self->priv->argument_list;
				_tmp672_ = vala_list_get (_tmp671_, 0);
				_tmp673_ = (ValaExpression*) _tmp672_;
				_tmp667_ = VALA_IS_LAMBDA_EXPRESSION (_tmp673_);
				_vala_code_node_unref0 (_tmp673_);
			} else {
				_tmp667_ = FALSE;
			}
			if (_tmp667_) {
				ValaSourceReference* _tmp674_;
				ValaSourceReference* _tmp675_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp674_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp675_ = _tmp674_;
				vala_report_error (_tmp675_, "Cannot disconnect lambda expression from signal");
				result = FALSE;
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp676_ = m;
		_tmp677_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp676_);
		_tmp678_ = _tmp677_;
		dynamic_sig = VALA_IS_DYNAMIC_SIGNAL (_tmp678_) ? ((ValaDynamicSignal*) _tmp678_) : NULL;
		_tmp680_ = dynamic_sig;
		if (_tmp680_ != NULL) {
			ValaDynamicSignal* _tmp681_;
			ValaExpression* _tmp682_;
			ValaExpression* _tmp683_;
			_tmp681_ = dynamic_sig;
			_tmp682_ = vala_dynamic_signal_get_handler (_tmp681_);
			_tmp683_ = _tmp682_;
			_tmp679_ = _tmp683_ != NULL;
		} else {
			_tmp679_ = FALSE;
		}
		if (_tmp679_) {
			ValaDynamicSignal* _tmp684_;
			ValaDynamicSignal* _tmp685_;
			ValaExpression* _tmp686_;
			ValaExpression* _tmp687_;
			ValaDataType* _tmp688_;
			ValaDataType* _tmp689_;
			ValaDataType* _tmp690_;
			ValaDataType* _tmp691_;
			ValaDataType* _tmp692_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp711_;
			ValaExpression* _tmp712_;
			ValaExpression* _tmp713_;
			ValaDynamicSignal* _tmp714_;
			ValaDynamicSignal* _tmp715_;
			ValaSymbol* _tmp716_;
			ValaSymbol* _tmp717_;
			ValaObjectType* _tmp718_;
			ValaObjectType* _tmp719_;
			ValaDelegate* _tmp720_;
			ValaDelegate* _tmp721_;
			ValaDelegateType* _tmp722_;
			ValaDelegateType* _tmp723_;
			ValaDynamicSignal* _tmp724_;
			ValaExpression* _tmp725_;
			ValaExpression* _tmp726_;
			ValaDataType* _tmp727_;
			ValaDataType* _tmp728_;
			ValaSourceReference* _tmp729_;
			ValaSourceReference* _tmp730_;
			_tmp684_ = dynamic_sig;
			_tmp685_ = dynamic_sig;
			_tmp686_ = vala_dynamic_signal_get_handler (_tmp685_);
			_tmp687_ = _tmp686_;
			_tmp688_ = vala_expression_get_value_type (_tmp687_);
			_tmp689_ = _tmp688_;
			_tmp690_ = vala_data_type_get_return_type (_tmp689_);
			_tmp691_ = vala_data_type_copy (_tmp690_);
			_tmp692_ = _tmp691_;
			vala_callable_set_return_type ((ValaCallable*) _tmp684_, _tmp692_);
			_vala_code_node_unref0 (_tmp692_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp693_;
				ValaExpression* _tmp694_;
				ValaExpression* _tmp695_;
				ValaDataType* _tmp696_;
				ValaDataType* _tmp697_;
				ValaList* _tmp698_;
				ValaList* _tmp699_;
				gint _param_size = 0;
				ValaList* _tmp700_;
				gint _tmp701_;
				gint _tmp702_;
				gint _param_index = 0;
				_tmp693_ = dynamic_sig;
				_tmp694_ = vala_dynamic_signal_get_handler (_tmp693_);
				_tmp695_ = _tmp694_;
				_tmp696_ = vala_expression_get_value_type (_tmp695_);
				_tmp697_ = _tmp696_;
				_tmp698_ = vala_data_type_get_parameters (_tmp697_);
				_tmp699_ = _vala_iterable_ref0 (_tmp698_);
				_param_list = _tmp699_;
				_tmp700_ = _param_list;
				_tmp701_ = vala_collection_get_size ((ValaCollection*) _tmp700_);
				_tmp702_ = _tmp701_;
				_param_size = _tmp702_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp703_;
					gint _tmp704_;
					ValaParameter* param = NULL;
					ValaList* _tmp705_;
					gpointer _tmp706_;
					_param_index = _param_index + 1;
					_tmp703_ = _param_index;
					_tmp704_ = _param_size;
					if (!(_tmp703_ < _tmp704_)) {
						break;
					}
					_tmp705_ = _param_list;
					_tmp706_ = vala_list_get (_tmp705_, _param_index);
					param = (ValaParameter*) _tmp706_;
					if (first) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp707_;
						ValaParameter* _tmp708_;
						ValaParameter* _tmp709_;
						ValaParameter* _tmp710_;
						_tmp707_ = dynamic_sig;
						_tmp708_ = param;
						_tmp709_ = vala_parameter_copy (_tmp708_);
						_tmp710_ = _tmp709_;
						vala_callable_add_parameter ((ValaCallable*) _tmp707_, _tmp710_);
						_vala_code_node_unref0 (_tmp710_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp711_ = dynamic_sig;
			_tmp712_ = vala_dynamic_signal_get_handler (_tmp711_);
			_tmp713_ = _tmp712_;
			_tmp714_ = dynamic_sig;
			_tmp715_ = dynamic_sig;
			_tmp716_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp715_);
			_tmp717_ = _tmp716_;
			_tmp718_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp717_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp719_ = _tmp718_;
			_tmp720_ = vala_signal_get_delegate ((ValaSignal*) _tmp714_, (ValaDataType*) _tmp719_, (ValaCodeNode*) self);
			_tmp721_ = _tmp720_;
			_tmp722_ = vala_delegate_type_new (_tmp721_);
			_tmp723_ = _tmp722_;
			vala_expression_set_target_type (_tmp713_, (ValaDataType*) _tmp723_);
			_vala_code_node_unref0 (_tmp723_);
			_vala_code_node_unref0 (_tmp721_);
			_vala_code_node_unref0 (_tmp719_);
			_tmp724_ = dynamic_sig;
			_tmp725_ = vala_dynamic_signal_get_handler (_tmp724_);
			_tmp726_ = _tmp725_;
			_tmp727_ = vala_expression_get_target_type (_tmp726_);
			_tmp728_ = _tmp727_;
			_tmp729_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp730_ = _tmp729_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp728_, _tmp730_);
		}
		_tmp732_ = m;
		if (_tmp732_ != NULL) {
			ValaMethod* _tmp733_;
			_tmp733_ = m;
			_tmp731_ = vala_method_has_type_parameters (_tmp733_);
		} else {
			_tmp731_ = FALSE;
		}
		if (_tmp731_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp734_;
			ValaExpression* _tmp735_;
			ValaMemberAccess* _tmp736_;
			ValaList* _tmp737_;
			gint _tmp738_;
			gint _tmp739_;
			_tmp734_ = vala_method_call_get_call (self);
			_tmp735_ = _tmp734_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp735_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp736_ = ma;
			_tmp737_ = vala_member_access_get_type_arguments (_tmp736_);
			_tmp738_ = vala_collection_get_size ((ValaCollection*) _tmp737_);
			_tmp739_ = _tmp738_;
			if (_tmp739_ == 0) {
				ValaList* _tmp810_;
				ValaIterator* _tmp811_;
				ValaDataType* _tmp839_;
				ValaDataType* _tmp840_;
				ValaDataType* _tmp841_;
				ValaList* _tmp842_;
				ValaDataType* _tmp843_;
				ValaDataType* _tmp844_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp740_;
					ValaList* _tmp741_;
					ValaList* _tmp742_;
					gint _type_param_size = 0;
					ValaList* _tmp743_;
					gint _tmp744_;
					gint _tmp745_;
					gint _type_param_index = 0;
					_tmp740_ = m;
					_tmp741_ = vala_method_get_type_parameters (_tmp740_);
					_tmp742_ = _vala_iterable_ref0 (_tmp741_);
					_type_param_list = _tmp742_;
					_tmp743_ = _type_param_list;
					_tmp744_ = vala_collection_get_size ((ValaCollection*) _tmp743_);
					_tmp745_ = _tmp744_;
					_type_param_size = _tmp745_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp746_;
						gint _tmp747_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp748_;
						gpointer _tmp749_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp750_;
						ValaIterator* _tmp751_;
						gboolean _tmp788_ = FALSE;
						ValaDataType* _tmp789_;
						ValaDataType* _tmp799_;
						ValaMemberAccess* _tmp808_;
						ValaDataType* _tmp809_;
						_type_param_index = _type_param_index + 1;
						_tmp746_ = _type_param_index;
						_tmp747_ = _type_param_size;
						if (!(_tmp746_ < _tmp747_)) {
							break;
						}
						_tmp748_ = _type_param_list;
						_tmp749_ = vala_list_get (_tmp748_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp749_;
						type_arg = NULL;
						_tmp750_ = self->priv->argument_list;
						_tmp751_ = vala_iterable_iterator ((ValaIterable*) _tmp750_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp751_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp752_;
							ValaList* _tmp753_;
							gint _param_size = 0;
							ValaList* _tmp754_;
							gint _tmp755_;
							gint _tmp756_;
							gint _param_index = 0;
							_tmp752_ = params;
							_tmp753_ = _vala_iterable_ref0 (_tmp752_);
							_param_list = _tmp753_;
							_tmp754_ = _param_list;
							_tmp755_ = vala_collection_get_size ((ValaCollection*) _tmp754_);
							_tmp756_ = _tmp755_;
							_param_size = _tmp756_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp757_;
								gint _tmp758_;
								ValaParameter* param = NULL;
								ValaList* _tmp759_;
								gpointer _tmp760_;
								gboolean _tmp761_ = FALSE;
								ValaParameter* _tmp762_;
								gboolean _tmp763_;
								gboolean _tmp764_;
								ValaIterator* _tmp768_;
								_param_index = _param_index + 1;
								_tmp757_ = _param_index;
								_tmp758_ = _param_size;
								if (!(_tmp757_ < _tmp758_)) {
									break;
								}
								_tmp759_ = _param_list;
								_tmp760_ = vala_list_get (_tmp759_, _param_index);
								param = (ValaParameter*) _tmp760_;
								_tmp762_ = param;
								_tmp763_ = vala_parameter_get_ellipsis (_tmp762_);
								_tmp764_ = _tmp763_;
								if (_tmp764_) {
									_tmp761_ = TRUE;
								} else {
									ValaParameter* _tmp765_;
									gboolean _tmp766_;
									gboolean _tmp767_;
									_tmp765_ = param;
									_tmp766_ = vala_parameter_get_params_array (_tmp765_);
									_tmp767_ = _tmp766_;
									_tmp761_ = _tmp767_;
								}
								if (_tmp761_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp768_ = arg_it;
								if (vala_iterator_next (_tmp768_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp769_;
									gpointer _tmp770_;
									ValaParameter* _tmp771_;
									ValaDataType* _tmp772_;
									ValaDataType* _tmp773_;
									ValaTypeParameter* _tmp774_;
									ValaExpression* _tmp775_;
									ValaDataType* _tmp776_;
									ValaDataType* _tmp777_;
									ValaDataType* _tmp778_;
									ValaDataType* _tmp779_;
									ValaExpression* _tmp780_;
									ValaExpression* _tmp781_;
									ValaDataType* _tmp782_;
									ValaDataType* _tmp783_;
									ValaDataType* _tmp784_;
									ValaList* _tmp785_;
									ValaDataType* _tmp786_;
									ValaDataType* _tmp787_;
									_tmp769_ = arg_it;
									_tmp770_ = vala_iterator_get (_tmp769_);
									arg = (ValaExpression*) _tmp770_;
									_tmp771_ = param;
									_tmp772_ = vala_variable_get_variable_type ((ValaVariable*) _tmp771_);
									_tmp773_ = _tmp772_;
									_tmp774_ = type_param;
									_tmp775_ = arg;
									_tmp776_ = vala_expression_get_value_type (_tmp775_);
									_tmp777_ = _tmp776_;
									_tmp778_ = vala_data_type_infer_type_argument (_tmp773_, _tmp774_, _tmp777_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp778_;
									_tmp779_ = type_arg;
									if (_tmp779_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp780_ = arg;
									_tmp781_ = arg;
									_tmp782_ = vala_expression_get_formal_target_type (_tmp781_);
									_tmp783_ = _tmp782_;
									_tmp784_ = target_object_type;
									_tmp785_ = method_type_args;
									_tmp786_ = vala_data_type_get_actual_type (_tmp783_, _tmp784_, _tmp785_, (ValaCodeNode*) self);
									_tmp787_ = _tmp786_;
									vala_expression_set_target_type (_tmp780_, _tmp787_);
									_vala_code_node_unref0 (_tmp787_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp789_ = type_arg;
						if (_tmp789_ == NULL) {
							ValaDataType* _tmp790_;
							ValaDataType* _tmp791_;
							_tmp790_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp791_ = _tmp790_;
							_tmp788_ = _tmp791_ != NULL;
						} else {
							_tmp788_ = FALSE;
						}
						if (_tmp788_) {
							ValaMethod* _tmp792_;
							ValaDataType* _tmp793_;
							ValaDataType* _tmp794_;
							ValaTypeParameter* _tmp795_;
							ValaDataType* _tmp796_;
							ValaDataType* _tmp797_;
							ValaDataType* _tmp798_;
							_tmp792_ = m;
							_tmp793_ = vala_callable_get_return_type ((ValaCallable*) _tmp792_);
							_tmp794_ = _tmp793_;
							_tmp795_ = type_param;
							_tmp796_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp797_ = _tmp796_;
							_tmp798_ = vala_data_type_infer_type_argument (_tmp794_, _tmp795_, _tmp797_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp798_;
						}
						_tmp799_ = type_arg;
						if (_tmp799_ == NULL) {
							ValaMemberAccess* _tmp800_;
							ValaSourceReference* _tmp801_;
							ValaSourceReference* _tmp802_;
							ValaTypeParameter* _tmp803_;
							gchar* _tmp804_;
							gchar* _tmp805_;
							gchar* _tmp806_;
							gchar* _tmp807_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp800_ = ma;
							_tmp801_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp800_);
							_tmp802_ = _tmp801_;
							_tmp803_ = type_param;
							_tmp804_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp803_);
							_tmp805_ = _tmp804_;
							_tmp806_ = g_strdup_printf ("cannot infer generic type argument for type parameter `%s'", _tmp805_);
							_tmp807_ = _tmp806_;
							vala_report_error (_tmp802_, _tmp807_);
							_g_free0 (_tmp807_);
							_g_free0 (_tmp805_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterable_unref0 (_type_param_list);
							_vala_iterator_unref0 (arg_it);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp808_ = ma;
						_tmp809_ = type_arg;
						vala_member_access_add_type_argument (_tmp808_, _tmp809_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_tmp810_ = self->priv->argument_list;
				_tmp811_ = vala_iterable_iterator ((ValaIterable*) _tmp810_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp811_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp812_;
					ValaList* _tmp813_;
					gint _param_size = 0;
					ValaList* _tmp814_;
					gint _tmp815_;
					gint _tmp816_;
					gint _param_index = 0;
					_tmp812_ = params;
					_tmp813_ = _vala_iterable_ref0 (_tmp812_);
					_param_list = _tmp813_;
					_tmp814_ = _param_list;
					_tmp815_ = vala_collection_get_size ((ValaCollection*) _tmp814_);
					_tmp816_ = _tmp815_;
					_param_size = _tmp816_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp817_;
						gint _tmp818_;
						ValaParameter* param = NULL;
						ValaList* _tmp819_;
						gpointer _tmp820_;
						gboolean _tmp821_ = FALSE;
						ValaParameter* _tmp822_;
						gboolean _tmp823_;
						gboolean _tmp824_;
						ValaIterator* _tmp828_;
						_param_index = _param_index + 1;
						_tmp817_ = _param_index;
						_tmp818_ = _param_size;
						if (!(_tmp817_ < _tmp818_)) {
							break;
						}
						_tmp819_ = _param_list;
						_tmp820_ = vala_list_get (_tmp819_, _param_index);
						param = (ValaParameter*) _tmp820_;
						_tmp822_ = param;
						_tmp823_ = vala_parameter_get_ellipsis (_tmp822_);
						_tmp824_ = _tmp823_;
						if (_tmp824_) {
							_tmp821_ = TRUE;
						} else {
							ValaParameter* _tmp825_;
							gboolean _tmp826_;
							gboolean _tmp827_;
							_tmp825_ = param;
							_tmp826_ = vala_parameter_get_params_array (_tmp825_);
							_tmp827_ = _tmp826_;
							_tmp821_ = _tmp827_;
						}
						if (_tmp821_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp828_ = arg_it;
						if (vala_iterator_next (_tmp828_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp829_;
							gpointer _tmp830_;
							ValaExpression* _tmp831_;
							ValaExpression* _tmp832_;
							ValaDataType* _tmp833_;
							ValaDataType* _tmp834_;
							ValaDataType* _tmp835_;
							ValaList* _tmp836_;
							ValaDataType* _tmp837_;
							ValaDataType* _tmp838_;
							_tmp829_ = arg_it;
							_tmp830_ = vala_iterator_get (_tmp829_);
							arg = (ValaExpression*) _tmp830_;
							_tmp831_ = arg;
							_tmp832_ = arg;
							_tmp833_ = vala_expression_get_formal_target_type (_tmp832_);
							_tmp834_ = _tmp833_;
							_tmp835_ = target_object_type;
							_tmp836_ = method_type_args;
							_tmp837_ = vala_data_type_get_actual_type (_tmp834_, _tmp835_, _tmp836_, (ValaCodeNode*) self);
							_tmp838_ = _tmp837_;
							vala_expression_set_target_type (_tmp831_, _tmp838_);
							_vala_code_node_unref0 (_tmp838_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
					_vala_iterable_unref0 (_param_list);
				}
				_tmp839_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp840_ = _tmp839_;
				_tmp841_ = target_object_type;
				_tmp842_ = method_type_args;
				_tmp843_ = vala_data_type_get_actual_type (_tmp840_, _tmp841_, _tmp842_, (ValaCodeNode*) self);
				_tmp844_ = _tmp843_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp844_);
				_vala_code_node_unref0 (_tmp844_);
			}
		}
		_tmp846_ = m;
		if (_tmp846_ != NULL) {
			ValaMethod* _tmp847_;
			gboolean _tmp848_;
			gboolean _tmp849_;
			_tmp847_ = m;
			_tmp848_ = vala_method_get_coroutine (_tmp847_);
			_tmp849_ = _tmp848_;
			_tmp845_ = _tmp849_;
		} else {
			_tmp845_ = FALSE;
		}
		if (_tmp845_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp850_;
			ValaExpression* _tmp851_;
			ValaMemberAccess* _tmp852_;
			const gchar* _tmp853_;
			const gchar* _tmp854_;
			_tmp850_ = vala_method_call_get_call (self);
			_tmp851_ = _tmp850_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp851_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp852_ = ma;
			_tmp853_ = vala_member_access_get_member_name (_tmp852_);
			_tmp854_ = _tmp853_;
			if (g_strcmp0 (_tmp854_, "end") == 0) {
				ValaMethod* _tmp855_;
				ValaMethod* _tmp856_;
				ValaMethodType* _tmp857_;
				ValaDataType* _tmp858_;
				ValaSourceReference* _tmp859_;
				ValaSourceReference* _tmp860_;
				_tmp855_ = m;
				_tmp856_ = vala_method_get_end_method (_tmp855_);
				_tmp857_ = vala_method_type_new (_tmp856_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp857_;
				_tmp858_ = mtype;
				_tmp859_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp860_ = _tmp859_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp858_, _tmp860_);
			}
		}
	}
	_tmp861_ = vala_code_context_get_analyzer (context);
	_tmp862_ = _tmp861_;
	_tmp863_ = mtype;
	_tmp864_ = params;
	_tmp865_ = self->priv->argument_list;
	if (!vala_semantic_analyzer_check_arguments (_tmp862_, (ValaExpression*) self, _tmp863_, _tmp864_, _tmp865_)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp866_;
		ValaList* _tmp867_;
		gint _arg_size = 0;
		ValaList* _tmp868_;
		gint _tmp869_;
		gint _tmp870_;
		gint _arg_index = 0;
		_tmp866_ = self->priv->argument_list;
		_tmp867_ = _vala_iterable_ref0 (_tmp866_);
		_arg_list = _tmp867_;
		_tmp868_ = _arg_list;
		_tmp869_ = vala_collection_get_size ((ValaCollection*) _tmp868_);
		_tmp870_ = _tmp869_;
		_arg_size = _tmp870_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp871_;
			gint _tmp872_;
			ValaExpression* arg = NULL;
			ValaList* _tmp873_;
			gpointer _tmp874_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp875_;
			gboolean _tmp876_ = FALSE;
			ValaSizeofExpression* _tmp877_;
			_arg_index = _arg_index + 1;
			_tmp871_ = _arg_index;
			_tmp872_ = _arg_size;
			if (!(_tmp871_ < _tmp872_)) {
				break;
			}
			_tmp873_ = _arg_list;
			_tmp874_ = vala_list_get (_tmp873_, _arg_index);
			arg = (ValaExpression*) _tmp874_;
			_tmp875_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp875_) ? ((ValaSizeofExpression*) _tmp875_) : NULL;
			_tmp877_ = sizeof_expr;
			if (_tmp877_ != NULL) {
				ValaSizeofExpression* _tmp878_;
				ValaDataType* _tmp879_;
				ValaDataType* _tmp880_;
				_tmp878_ = sizeof_expr;
				_tmp879_ = vala_sizeof_expression_get_type_reference (_tmp878_);
				_tmp880_ = _tmp879_;
				_tmp876_ = VALA_IS_GENERIC_TYPE (_tmp880_);
			} else {
				_tmp876_ = FALSE;
			}
			if (_tmp876_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp881_;
				ValaDataType* _tmp882_;
				ValaDataType* _tmp883_;
				ValaDataType* _tmp884_;
				ValaList* _tmp885_;
				ValaDataType* _tmp886_;
				ValaExpression* _tmp887_;
				ValaDataType* _tmp888_;
				ValaSourceReference* _tmp889_;
				ValaSourceReference* _tmp890_;
				ValaSizeofExpression* _tmp891_;
				ValaSizeofExpression* _tmp892_;
				_tmp881_ = sizeof_expr;
				_tmp882_ = vala_sizeof_expression_get_type_reference (_tmp881_);
				_tmp883_ = _tmp882_;
				_tmp884_ = target_object_type;
				_tmp885_ = method_type_args;
				_tmp886_ = vala_data_type_get_actual_type (_tmp883_, _tmp884_, _tmp885_, (ValaCodeNode*) self);
				sizeof_type = _tmp886_;
				_tmp887_ = arg;
				_tmp888_ = sizeof_type;
				_tmp889_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp890_ = _tmp889_;
				_tmp891_ = vala_sizeof_expression_new (_tmp888_, _tmp890_);
				_tmp892_ = _tmp891_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp887_, (ValaExpression*) _tmp892_);
				_vala_code_node_unref0 (_tmp892_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp895_ = base_cm;
	if (_tmp895_ != NULL) {
		ValaCreationMethod* _tmp896_;
		_tmp896_ = base_cm;
		_tmp894_ = vala_method_is_variadic ((ValaMethod*) _tmp896_);
	} else {
		_tmp894_ = FALSE;
	}
	if (_tmp894_) {
		ValaList* _tmp897_;
		gint _tmp898_;
		gint _tmp899_;
		ValaCreationMethod* _tmp900_;
		ValaList* _tmp901_;
		gint _tmp902_;
		gint _tmp903_;
		_tmp897_ = self->priv->argument_list;
		_tmp898_ = vala_collection_get_size ((ValaCollection*) _tmp897_);
		_tmp899_ = _tmp898_;
		_tmp900_ = base_cm;
		_tmp901_ = vala_callable_get_parameters ((ValaCallable*) _tmp900_);
		_tmp902_ = vala_collection_get_size ((ValaCollection*) _tmp901_);
		_tmp903_ = _tmp902_;
		_tmp893_ = _tmp899_ == _tmp903_;
	} else {
		_tmp893_ = FALSE;
	}
	if (_tmp893_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp904_;
		ValaList* _tmp905_;
		gint _tmp906_;
		gint _tmp907_;
		gpointer _tmp908_;
		gboolean _tmp909_ = FALSE;
		ValaExpression* _tmp910_;
		ValaDataType* _tmp911_;
		ValaDataType* _tmp912_;
		_tmp904_ = self->priv->argument_list;
		_tmp905_ = self->priv->argument_list;
		_tmp906_ = vala_collection_get_size ((ValaCollection*) _tmp905_);
		_tmp907_ = _tmp906_;
		_tmp908_ = vala_list_get (_tmp904_, _tmp907_ - 1);
		this_last_arg = (ValaExpression*) _tmp908_;
		_tmp910_ = this_last_arg;
		_tmp911_ = vala_expression_get_value_type (_tmp910_);
		_tmp912_ = _tmp911_;
		if (VALA_IS_STRUCT_VALUE_TYPE (_tmp912_)) {
			ValaExpression* _tmp913_;
			ValaDataType* _tmp914_;
			ValaDataType* _tmp915_;
			ValaTypeSymbol* _tmp916_;
			ValaTypeSymbol* _tmp917_;
			ValaSemanticAnalyzer* _tmp918_;
			ValaSemanticAnalyzer* _tmp919_;
			ValaDataType* _tmp920_;
			ValaTypeSymbol* _tmp921_;
			ValaTypeSymbol* _tmp922_;
			_tmp913_ = this_last_arg;
			_tmp914_ = vala_expression_get_value_type (_tmp913_);
			_tmp915_ = _tmp914_;
			_tmp916_ = vala_data_type_get_type_symbol (_tmp915_);
			_tmp917_ = _tmp916_;
			_tmp918_ = vala_code_context_get_analyzer (context);
			_tmp919_ = _tmp918_;
			_tmp920_ = _tmp919_->va_list_type;
			_tmp921_ = vala_data_type_get_type_symbol (_tmp920_);
			_tmp922_ = _tmp921_;
			_tmp909_ = _tmp917_ == _tmp922_;
		} else {
			_tmp909_ = FALSE;
		}
		if (_tmp909_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp923_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp924_ = _tmp923_;
	vala_code_node_check ((ValaCodeNode*) _tmp924_, context);
	_tmp925_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp926_ = _tmp925_;
	if (_tmp926_) {
		gboolean _tmp927_ = FALSE;
		ValaCodeNode* _tmp928_;
		ValaCodeNode* _tmp929_;
		_tmp928_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp929_ = _tmp928_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp929_)) {
			_tmp927_ = TRUE;
		} else {
			ValaCodeNode* _tmp930_;
			ValaCodeNode* _tmp931_;
			_tmp930_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp931_ = _tmp930_;
			_tmp927_ = VALA_IS_EXPRESSION_STATEMENT (_tmp931_);
		}
		if (_tmp927_) {
		} else {
			ValaSemanticAnalyzer* _tmp932_;
			ValaSemanticAnalyzer* _tmp933_;
			ValaSymbol* _tmp934_;
			ValaSymbol* _tmp935_;
			_tmp932_ = vala_code_context_get_analyzer (context);
			_tmp933_ = _tmp932_;
			_tmp934_ = vala_semantic_analyzer_get_current_symbol (_tmp933_);
			_tmp935_ = _tmp934_;
			if (!VALA_IS_BLOCK (_tmp935_)) {
				ValaSourceReference* _tmp936_;
				ValaSourceReference* _tmp937_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp936_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp937_ = _tmp936_;
				vala_report_error (_tmp937_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp938_;
				ValaCodeNode* _tmp939_;
				ValaCodeNode* _tmp940_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp941_;
				ValaDataType* _tmp942_;
				ValaDataType* _tmp943_;
				ValaDataType* _tmp944_;
				gchar* _tmp945_;
				gchar* _tmp946_;
				ValaSourceReference* _tmp947_;
				ValaSourceReference* _tmp948_;
				ValaLocalVariable* _tmp949_;
				ValaLocalVariable* _tmp950_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp951_;
				ValaSourceReference* _tmp952_;
				ValaSourceReference* _tmp953_;
				ValaDeclarationStatement* _tmp954_;
				ValaDataType* _tmp955_;
				ValaDataType* _tmp956_;
				ValaSemanticAnalyzer* _tmp960_;
				ValaSemanticAnalyzer* _tmp961_;
				ValaBlock* _tmp962_;
				ValaDeclarationStatement* _tmp963_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp964_;
				ValaDataType* _tmp965_;
				ValaDataType* _tmp966_;
				ValaExpression* _tmp967_;
				ValaExpression* _tmp968_;
				ValaDataType* _tmp969_;
				ValaDataType* _tmp970_;
				ValaLocalVariable* _tmp971_;
				ValaDeclarationStatement* _tmp972_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp973_;
				ValaSemanticAnalyzer* _tmp974_;
				ValaSymbol* _tmp975_;
				ValaSymbol* _tmp976_;
				ValaBlock* _tmp977_;
				ValaBlock* _tmp978_;
				ValaLocalVariable* _tmp979_;
				ValaSemanticAnalyzer* _tmp980_;
				ValaSemanticAnalyzer* _tmp981_;
				ValaBlock* _tmp982_;
				ValaLocalVariable* _tmp983_;
				ValaCodeNode* _tmp984_;
				ValaExpression* _tmp985_;
				ValaExpression* _tmp986_;
				_tmp938_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp939_ = _tmp938_;
				_tmp940_ = _vala_code_node_ref0 (_tmp939_);
				old_parent_node = _tmp940_;
				_tmp941_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp942_ = _tmp941_;
				_tmp943_ = vala_data_type_copy (_tmp942_);
				_tmp944_ = _tmp943_;
				_tmp945_ = vala_code_node_get_temp_name ();
				_tmp946_ = _tmp945_;
				_tmp947_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp948_ = _tmp947_;
				_tmp949_ = vala_local_variable_new (_tmp944_, _tmp946_, NULL, _tmp948_);
				_tmp950_ = _tmp949_;
				_g_free0 (_tmp946_);
				_vala_code_node_unref0 (_tmp944_);
				local = _tmp950_;
				_tmp951_ = local;
				_tmp952_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp953_ = _tmp952_;
				_tmp954_ = vala_declaration_statement_new ((ValaSymbol*) _tmp951_, _tmp953_);
				decl = _tmp954_;
				_tmp955_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp956_ = _tmp955_;
				if (_tmp956_ == NULL) {
					ValaLocalVariable* _tmp957_;
					ValaDataType* _tmp958_;
					ValaDataType* _tmp959_;
					_tmp957_ = local;
					_tmp958_ = vala_variable_get_variable_type ((ValaVariable*) _tmp957_);
					_tmp959_ = _tmp958_;
					vala_data_type_set_floating_reference (_tmp959_, FALSE);
				}
				_tmp960_ = vala_code_context_get_analyzer (context);
				_tmp961_ = _tmp960_;
				_tmp962_ = _tmp961_->insert_block;
				_tmp963_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp962_, (ValaStatement*) _tmp963_);
				_tmp964_ = local;
				_tmp965_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp966_ = _tmp965_;
				_tmp967_ = vala_semantic_analyzer_create_temp_access (_tmp964_, _tmp966_);
				temp_access = _tmp967_;
				_tmp968_ = temp_access;
				_tmp969_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp970_ = _tmp969_;
				vala_expression_set_formal_target_type (_tmp968_, _tmp970_);
				_tmp971_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp971_, (ValaExpression*) self);
				_tmp972_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp972_, context);
				_tmp973_ = vala_code_context_get_analyzer (context);
				_tmp974_ = _tmp973_;
				_tmp975_ = vala_semantic_analyzer_get_current_symbol (_tmp974_);
				_tmp976_ = _tmp975_;
				_tmp977_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp976_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp977_;
				_tmp978_ = block;
				_tmp979_ = local;
				vala_block_remove_local_variable (_tmp978_, _tmp979_);
				_tmp980_ = vala_code_context_get_analyzer (context);
				_tmp981_ = _tmp980_;
				_tmp982_ = _tmp981_->insert_block;
				_tmp983_ = local;
				vala_block_add_local_variable (_tmp982_, _tmp983_);
				_tmp984_ = old_parent_node;
				_tmp985_ = temp_access;
				vala_code_node_replace_expression (_tmp984_, (ValaExpression*) self, _tmp985_);
				_tmp986_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp986_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp987_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp988_ = _tmp987_;
	result = !_tmp988_;
	_vala_iterator_unref0 (arg_it);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}

static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_SIGNAL (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		_tmp11_ = vala_method_call_get_call (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp14_ = _tmp13_;
		vala_code_node_emit ((ValaCodeNode*) _tmp14_, codegen);
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		vala_code_node_emit ((ValaCodeNode*) _tmp16_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		gint _expr_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _expr_index = 0;
		_tmp17_ = self->priv->argument_list;
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_expr_list = _tmp18_;
		_tmp19_ = _expr_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_expr_size = _tmp21_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			ValaExpression* expr = NULL;
			ValaList* _tmp24_;
			gpointer _tmp25_;
			ValaExpression* _tmp26_;
			_expr_index = _expr_index + 1;
			_tmp22_ = _expr_index;
			_tmp23_ = _expr_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _expr_list;
			_tmp25_ = vala_list_get (_tmp24_, _expr_index);
			expr = (ValaExpression*) _tmp25_;
			_tmp26_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp26_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaExpression* arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_arg_index = _arg_index + 1;
			_tmp7_ = _arg_index;
			_tmp8_ = _arg_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _arg_index);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaExpression* arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_arg_index = _arg_index + 1;
			_tmp7_ = _arg_index;
			_tmp8_ = _arg_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _arg_index);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaStringLiteral* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	mtype = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = mtype;
	if (_tmp4_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = mtype;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		format_arg = vala_method_get_format_arg_index (_tmp7_);
		if (format_arg >= 0) {
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = self->priv->argument_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp8_ = format_arg < _tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaStringLiteral* _tmp15_;
			ValaStringLiteral* _tmp16_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, format_arg);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_string_literal_get_format_literal (_tmp14_);
			_tmp16_ = _tmp15_;
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp16_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	GString* b = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp24_;
	GString* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* result = NULL;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = b;
	g_string_append_c (_tmp1_, '(');
	_tmp2_ = self->priv->_is_yield_expression;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _expr_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_expr_list = _tmp11_;
		_tmp12_ = _expr_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_expr_size = _tmp14_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaExpression* expr = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			GString* _tmp20_;
			ValaExpression* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_expr_index = _expr_index + 1;
			_tmp15_ = _expr_index;
			_tmp16_ = _expr_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _expr_list;
			_tmp18_ = vala_list_get (_tmp17_, _expr_index);
			expr = (ValaExpression*) _tmp18_;
			if (!first) {
				GString* _tmp19_;
				_tmp19_ = b;
				g_string_append (_tmp19_, ", ");
			}
			_tmp20_ = b;
			_tmp21_ = expr;
			_tmp22_ = vala_code_node_to_string ((ValaCodeNode*) _tmp21_);
			_tmp23_ = _tmp22_;
			g_string_append (_tmp20_, _tmp23_);
			_g_free0 (_tmp23_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp24_ = b;
	g_string_append (_tmp24_, "))");
	_tmp25_ = b;
	_tmp26_ = _tmp25_->str;
	_tmp27_ = g_strdup (_tmp26_);
	result = _tmp27_;
	_g_string_free0 (b);
	return result;
}

static void
vala_method_call_class_init (ValaMethodCallClass * klass,
                             gpointer klass_data)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_call_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}

static void
vala_method_call_instance_init (ValaMethodCall * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}

static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}

/**
 * Represents an invocation expression in the source code.
 */
static GType
vala_method_call_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
	GType vala_method_call_type_id;
	vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
	ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
	return vala_method_call_type_id;
}

GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		GType vala_method_call_type_id;
		vala_method_call_type_id = vala_method_call_get_type_once ();
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}

