/* gtkdoccommentscanner.c generated by valac, the Vala compiler
 * generated from gtkdoccommentscanner.vala, do not modify */

/* gtkcommentscanner.vala
 *
 * Copyright (C) 2011  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
typedef struct _ValadocGtkdocParamSpecToken ValadocGtkdocParamSpecToken;
#define _valadoc_gtkdoc_token_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_gtkdoc_token_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ValadocGtkdocParamSpecScanner ValadocGtkdocParamSpecScanner;

struct _ValadocGtkdocParamSpecToken {
	GParamSpec parent_instance;
};

struct _ValadocGtkdocScannerPrivate {
	const gchar* content;
	const gchar* pos;
	gint column;
	gint line;
	ValadocGtkdocToken* tmp_token;
};

struct _ValadocGtkdocParamSpecScanner {
	GParamSpec parent_instance;
};

static gpointer valadoc_gtkdoc_token_parent_class = NULL;
static gint ValadocGtkdocScanner_private_offset;
static gpointer valadoc_gtkdoc_scanner_parent_class = NULL;

static void valadoc_gtkdoc_token_finalize (ValadocGtkdocToken * obj);
static GType valadoc_gtkdoc_token_get_type_once (void);
static inline gunichar valadoc_gtkdoc_scanner_next_char (ValadocGtkdocScanner* self);
static inline gunichar valadoc_gtkdoc_scanner_get (ValadocGtkdocScanner* self);
static inline gboolean valadoc_gtkdoc_scanner_letter (ValadocGtkdocScanner* self,
                                        gunichar c);
static inline gboolean valadoc_gtkdoc_scanner_letter_or_number (ValadocGtkdocScanner* self,
                                                  gunichar c);
static inline gboolean valadoc_gtkdoc_scanner_space (ValadocGtkdocScanner* self,
                                       gunichar c);
static inline gboolean valadoc_gtkdoc_scanner_space_or_newline (ValadocGtkdocScanner* self,
                                                  gunichar c);
static inline gint valadoc_gtkdoc_scanner_offset (ValadocGtkdocScanner* self,
                                    const gchar* a,
                                    const gchar* b);
static inline gint valadoc_gtkdoc_scanner_vararg_prefix (ValadocGtkdocScanner* self);
static inline gint valadoc_gtkdoc_scanner_id_prefix (ValadocGtkdocScanner* self);
static inline gint valadoc_gtkdoc_scanner_g_id_prefix (ValadocGtkdocScanner* self);
static inline gint valadoc_gtkdoc_scanner_skip_spaces_and_newlines (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_function_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_space_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_symbolic_link_prefix (ValadocGtkdocScanner* self,
                                                                        gunichar c,
                                                                        ValadocGtkdocTokenType type);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_property_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_signal_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_const_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_param_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_type_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_xml_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_newline_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_eof_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_word_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_source_open_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_source_close_prefix (ValadocGtkdocScanner* self);
static void valadoc_gtkdoc_scanner_finalize (ValadocGtkdocScanner * obj);
static GType valadoc_gtkdoc_scanner_get_type_once (void);

static GType
valadoc_gtkdoc_token_type_get_type_once (void)
{
	static const GEnumValue values[] = {{VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN, "VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN", "xml-open"}, {VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE, "VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE", "xml-close"}, {VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT, "VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT", "xml-comment"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION", "gtkdoc-function"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST", "gtkdoc-const"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE", "gtkdoc-type"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM", "gtkdoc-param"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN", "gtkdoc-source-open"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE", "gtkdoc-source-close"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL", "gtkdoc-signal"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY", "gtkdoc-property"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH", "gtkdoc-paragraph"}, {VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE, "VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE", "newline"}, {VALADOC_GTKDOC_TOKEN_TYPE_SPACE, "VALADOC_GTKDOC_TOKEN_TYPE_SPACE", "space"}, {VALADOC_GTKDOC_TOKEN_TYPE_WORD, "VALADOC_GTKDOC_TOKEN_TYPE_WORD", "word"}, {VALADOC_GTKDOC_TOKEN_TYPE_EOF, "VALADOC_GTKDOC_TOKEN_TYPE_EOF", "eof"}, {0, NULL, NULL}};
	GType valadoc_gtkdoc_token_type_type_id;
	valadoc_gtkdoc_token_type_type_id = g_enum_register_static ("ValadocGtkdocTokenType", values);
	return valadoc_gtkdoc_token_type_type_id;
}

GType
valadoc_gtkdoc_token_type_get_type (void)
{
	static volatile gsize valadoc_gtkdoc_token_type_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_token_type_type_id__volatile)) {
		GType valadoc_gtkdoc_token_type_type_id;
		valadoc_gtkdoc_token_type_type_id = valadoc_gtkdoc_token_type_get_type_once ();
		g_once_init_leave (&valadoc_gtkdoc_token_type_type_id__volatile, valadoc_gtkdoc_token_type_type_id);
	}
	return valadoc_gtkdoc_token_type_type_id__volatile;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

ValadocGtkdocToken*
valadoc_gtkdoc_token_construct (GType object_type,
                                ValadocGtkdocTokenType type,
                                const gchar* content,
                                ValaHashMap* attributes,
                                const gchar* start,
                                gint length,
                                gint line,
                                gint first_column,
                                gint last_column)
{
	ValadocGtkdocToken* self = NULL;
	ValaHashMap* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (content != NULL, NULL);
	g_return_val_if_fail (start != NULL, NULL);
	self = (ValadocGtkdocToken*) g_type_create_instance (object_type);
	_tmp0_ = _vala_map_ref0 (attributes);
	_vala_map_unref0 (self->attributes);
	self->attributes = _tmp0_;
	_tmp1_ = g_strdup (content);
	_g_free0 (self->content);
	self->content = _tmp1_;
	self->length = length;
	self->start = start;
	self->type = type;
	self->line = line;
	self->first_column = first_column;
	self->last_column = last_column;
	return self;
}

ValadocGtkdocToken*
valadoc_gtkdoc_token_new (ValadocGtkdocTokenType type,
                          const gchar* content,
                          ValaHashMap* attributes,
                          const gchar* start,
                          gint length,
                          gint line,
                          gint first_column,
                          gint last_column)
{
	return valadoc_gtkdoc_token_construct (VALADOC_GTKDOC_TYPE_TOKEN, type, content, attributes, start, length, line, first_column, last_column);
}

gchar*
valadoc_gtkdoc_token_to_string (ValadocGtkdocToken* self)
{
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (self->type) {
		case VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN:
		{
			const gchar* _tmp0_;
			gchar* _tmp1_;
			_tmp0_ = self->content;
			_tmp1_ = g_strdup_printf ("`<%s>'", _tmp0_);
			result = _tmp1_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE:
		{
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->content;
			_tmp3_ = g_strdup_printf ("`</%s>'", _tmp2_);
			result = _tmp3_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("<XML-COMMENT>");
			result = _tmp4_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION:
		{
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = self->content;
			_tmp6_ = g_strdup_printf ("`%s ()'", _tmp5_);
			result = _tmp6_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST:
		{
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->content;
			_tmp8_ = g_strdup_printf ("`%%%s'", _tmp7_);
			result = _tmp8_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE:
		{
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = self->content;
			_tmp10_ = g_strdup_printf ("`#%s'", _tmp9_);
			result = _tmp10_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("<GTKDOC-PARAM>");
			result = _tmp11_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strdup ("[|");
			result = _tmp12_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE:
		{
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("|]");
			result = _tmp13_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL:
		{
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp14_ = self->content;
			_tmp15_ = g_strdup_printf ("`::%s'", _tmp14_);
			result = _tmp15_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY:
		{
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp16_ = self->content;
			_tmp17_ = g_strdup_printf ("`:%s'", _tmp16_);
			result = _tmp17_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH:
		{
			gchar* _tmp18_;
			_tmp18_ = g_strdup ("<GKTDOC-PARAGRAPH>");
			result = _tmp18_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE:
		{
			gchar* _tmp19_;
			_tmp19_ = g_strdup ("<NEWLNIE>");
			result = _tmp19_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_SPACE:
		{
			gchar* _tmp20_;
			_tmp20_ = g_strdup ("<SPACE>");
			result = _tmp20_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_WORD:
		{
			const gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp21_ = self->content;
			_tmp22_ = g_strdup_printf ("`%s'", _tmp21_);
			result = _tmp22_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_EOF:
		{
			gchar* _tmp23_;
			_tmp23_ = g_strdup ("<EOF>");
			result = _tmp23_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static void
valadoc_gtkdoc_value_token_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
valadoc_gtkdoc_value_token_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		valadoc_gtkdoc_token_unref (value->data[0].v_pointer);
	}
}

static void
valadoc_gtkdoc_value_token_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = valadoc_gtkdoc_token_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
valadoc_gtkdoc_value_token_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
valadoc_gtkdoc_value_token_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValadocGtkdocToken * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = valadoc_gtkdoc_token_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
valadoc_gtkdoc_value_token_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	ValadocGtkdocToken ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = valadoc_gtkdoc_token_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
valadoc_gtkdoc_param_spec_token (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	ValadocGtkdocParamSpecToken* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALADOC_GTKDOC_TYPE_TOKEN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
valadoc_gtkdoc_value_get_token (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_TOKEN), NULL);
	return value->data[0].v_pointer;
}

void
valadoc_gtkdoc_value_set_token (GValue* value,
                                gpointer v_object)
{
	ValadocGtkdocToken * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_TOKEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_GTKDOC_TYPE_TOKEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		valadoc_gtkdoc_token_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_gtkdoc_token_unref (old);
	}
}

void
valadoc_gtkdoc_value_take_token (GValue* value,
                                 gpointer v_object)
{
	ValadocGtkdocToken * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_TOKEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_GTKDOC_TYPE_TOKEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_gtkdoc_token_unref (old);
	}
}

static void
valadoc_gtkdoc_token_class_init (ValadocGtkdocTokenClass * klass,
                                 gpointer klass_data)
{
	valadoc_gtkdoc_token_parent_class = g_type_class_peek_parent (klass);
	((ValadocGtkdocTokenClass *) klass)->finalize = valadoc_gtkdoc_token_finalize;
}

static void
valadoc_gtkdoc_token_instance_init (ValadocGtkdocToken * self,
                                    gpointer klass)
{
	self->ref_count = 1;
}

static void
valadoc_gtkdoc_token_finalize (ValadocGtkdocToken * obj)
{
	ValadocGtkdocToken * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_GTKDOC_TYPE_TOKEN, ValadocGtkdocToken);
	g_signal_handlers_destroy (self);
	_g_free0 (self->content);
	_vala_map_unref0 (self->attributes);
}

static GType
valadoc_gtkdoc_token_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { valadoc_gtkdoc_value_token_init, valadoc_gtkdoc_value_token_free_value, valadoc_gtkdoc_value_token_copy_value, valadoc_gtkdoc_value_token_peek_pointer, "p", valadoc_gtkdoc_value_token_collect_value, "p", valadoc_gtkdoc_value_token_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValadocGtkdocTokenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_gtkdoc_token_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocGtkdocToken), 0, (GInstanceInitFunc) valadoc_gtkdoc_token_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType valadoc_gtkdoc_token_type_id;
	valadoc_gtkdoc_token_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValadocGtkdocToken", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return valadoc_gtkdoc_token_type_id;
}

GType
valadoc_gtkdoc_token_get_type (void)
{
	static volatile gsize valadoc_gtkdoc_token_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_token_type_id__volatile)) {
		GType valadoc_gtkdoc_token_type_id;
		valadoc_gtkdoc_token_type_id = valadoc_gtkdoc_token_get_type_once ();
		g_once_init_leave (&valadoc_gtkdoc_token_type_id__volatile, valadoc_gtkdoc_token_type_id);
	}
	return valadoc_gtkdoc_token_type_id__volatile;
}

gpointer
valadoc_gtkdoc_token_ref (gpointer instance)
{
	ValadocGtkdocToken * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
valadoc_gtkdoc_token_unref (gpointer instance)
{
	ValadocGtkdocToken * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALADOC_GTKDOC_TOKEN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
valadoc_gtkdoc_scanner_get_instance_private (ValadocGtkdocScanner* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocGtkdocScanner_private_offset);
}

ValadocGtkdocScanner*
valadoc_gtkdoc_scanner_construct (GType object_type)
{
	ValadocGtkdocScanner* self = NULL;
	self = (ValadocGtkdocScanner*) g_type_create_instance (object_type);
	return self;
}

ValadocGtkdocScanner*
valadoc_gtkdoc_scanner_new (void)
{
	return valadoc_gtkdoc_scanner_construct (VALADOC_GTKDOC_TYPE_SCANNER);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

gchar*
valadoc_gtkdoc_scanner_unescape (const gchar* txt)
{
	GString* builder = NULL;
	GString* _tmp0_;
	const gchar* start = NULL;
	const gchar* pos = NULL;
	gunichar c = 0U;
	gchar* result = NULL;
	g_return_val_if_fail (txt != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	start = txt;
	{
		gboolean _tmp1_ = FALSE;
		pos = txt;
		_tmp1_ = TRUE;
		while (TRUE) {
			const gchar* _tmp4_;
			if (!_tmp1_) {
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				_tmp2_ = pos;
				_tmp3_ = g_utf8_next_char (_tmp2_);
				pos = _tmp3_;
			}
			_tmp1_ = FALSE;
			_tmp4_ = pos;
			c = string_get_char (_tmp4_, (glong) 0);
			if (!(c != ((gunichar) '\0'))) {
				break;
			}
			if (c == ((gunichar) '&')) {
				const gchar* _tmp5_;
				_tmp5_ = pos;
				if (g_str_has_prefix (_tmp5_, "&solidus;")) {
					GString* _tmp6_;
					const gchar* _tmp7_;
					const gchar* _tmp8_;
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					GString* _tmp12_;
					_tmp6_ = builder;
					_tmp7_ = start;
					_tmp8_ = pos;
					_tmp9_ = start;
					g_string_append_len (_tmp6_, _tmp7_, (gssize) (((gchar*) _tmp8_) - ((gchar*) _tmp9_)));
					_tmp10_ = pos;
					start = (const gchar*) (((gchar*) _tmp10_) + 9);
					_tmp11_ = pos;
					pos = (const gchar*) (((gchar*) _tmp11_) + 8);
					_tmp12_ = builder;
					g_string_append_unichar (_tmp12_, 8260U);
				} else {
					const gchar* _tmp13_;
					_tmp13_ = pos;
					if (g_str_has_prefix (_tmp13_, "&percnt;")) {
						GString* _tmp14_;
						const gchar* _tmp15_;
						const gchar* _tmp16_;
						const gchar* _tmp17_;
						const gchar* _tmp18_;
						const gchar* _tmp19_;
						GString* _tmp20_;
						_tmp14_ = builder;
						_tmp15_ = start;
						_tmp16_ = pos;
						_tmp17_ = start;
						g_string_append_len (_tmp14_, _tmp15_, (gssize) (((gchar*) _tmp16_) - ((gchar*) _tmp17_)));
						_tmp18_ = pos;
						start = (const gchar*) (((gchar*) _tmp18_) + 8);
						_tmp19_ = pos;
						pos = (const gchar*) (((gchar*) _tmp19_) + 7);
						_tmp20_ = builder;
						g_string_append_c (_tmp20_, '%');
					} else {
						const gchar* _tmp21_;
						_tmp21_ = pos;
						if (g_str_has_prefix (_tmp21_, "&commat;")) {
							GString* _tmp22_;
							const gchar* _tmp23_;
							const gchar* _tmp24_;
							const gchar* _tmp25_;
							const gchar* _tmp26_;
							const gchar* _tmp27_;
							GString* _tmp28_;
							_tmp22_ = builder;
							_tmp23_ = start;
							_tmp24_ = pos;
							_tmp25_ = start;
							g_string_append_len (_tmp22_, _tmp23_, (gssize) (((gchar*) _tmp24_) - ((gchar*) _tmp25_)));
							_tmp26_ = pos;
							start = (const gchar*) (((gchar*) _tmp26_) + 8);
							_tmp27_ = pos;
							pos = (const gchar*) (((gchar*) _tmp27_) + 7);
							_tmp28_ = builder;
							g_string_append_c (_tmp28_, '@');
						} else {
							const gchar* _tmp29_;
							_tmp29_ = pos;
							if (g_str_has_prefix (_tmp29_, "&nbsp;")) {
								GString* _tmp30_;
								const gchar* _tmp31_;
								const gchar* _tmp32_;
								const gchar* _tmp33_;
								const gchar* _tmp34_;
								const gchar* _tmp35_;
								GString* _tmp36_;
								_tmp30_ = builder;
								_tmp31_ = start;
								_tmp32_ = pos;
								_tmp33_ = start;
								g_string_append_len (_tmp30_, _tmp31_, (gssize) (((gchar*) _tmp32_) - ((gchar*) _tmp33_)));
								_tmp34_ = pos;
								start = (const gchar*) (((gchar*) _tmp34_) + 6);
								_tmp35_ = pos;
								pos = (const gchar*) (((gchar*) _tmp35_) + 5);
								_tmp36_ = builder;
								g_string_append_c (_tmp36_, ' ');
							} else {
								const gchar* _tmp37_;
								_tmp37_ = pos;
								if (g_str_has_prefix (_tmp37_, "&quot;")) {
									GString* _tmp38_;
									const gchar* _tmp39_;
									const gchar* _tmp40_;
									const gchar* _tmp41_;
									const gchar* _tmp42_;
									const gchar* _tmp43_;
									GString* _tmp44_;
									_tmp38_ = builder;
									_tmp39_ = start;
									_tmp40_ = pos;
									_tmp41_ = start;
									g_string_append_len (_tmp38_, _tmp39_, (gssize) (((gchar*) _tmp40_) - ((gchar*) _tmp41_)));
									_tmp42_ = pos;
									start = (const gchar*) (((gchar*) _tmp42_) + 6);
									_tmp43_ = pos;
									pos = (const gchar*) (((gchar*) _tmp43_) + 5);
									_tmp44_ = builder;
									g_string_append_c (_tmp44_, '"');
								} else {
									const gchar* _tmp45_;
									_tmp45_ = pos;
									if (g_str_has_prefix (_tmp45_, "&apos;")) {
										GString* _tmp46_;
										const gchar* _tmp47_;
										const gchar* _tmp48_;
										const gchar* _tmp49_;
										const gchar* _tmp50_;
										const gchar* _tmp51_;
										GString* _tmp52_;
										_tmp46_ = builder;
										_tmp47_ = start;
										_tmp48_ = pos;
										_tmp49_ = start;
										g_string_append_len (_tmp46_, _tmp47_, (gssize) (((gchar*) _tmp48_) - ((gchar*) _tmp49_)));
										_tmp50_ = pos;
										start = (const gchar*) (((gchar*) _tmp50_) + 6);
										_tmp51_ = pos;
										pos = (const gchar*) (((gchar*) _tmp51_) + 5);
										_tmp52_ = builder;
										g_string_append_c (_tmp52_, '\'');
									} else {
										const gchar* _tmp53_;
										_tmp53_ = pos;
										if (g_str_has_prefix (_tmp53_, "&lpar;")) {
											GString* _tmp54_;
											const gchar* _tmp55_;
											const gchar* _tmp56_;
											const gchar* _tmp57_;
											const gchar* _tmp58_;
											const gchar* _tmp59_;
											GString* _tmp60_;
											_tmp54_ = builder;
											_tmp55_ = start;
											_tmp56_ = pos;
											_tmp57_ = start;
											g_string_append_len (_tmp54_, _tmp55_, (gssize) (((gchar*) _tmp56_) - ((gchar*) _tmp57_)));
											_tmp58_ = pos;
											start = (const gchar*) (((gchar*) _tmp58_) + 6);
											_tmp59_ = pos;
											pos = (const gchar*) (((gchar*) _tmp59_) + 5);
											_tmp60_ = builder;
											g_string_append_c (_tmp60_, '(');
										} else {
											const gchar* _tmp61_;
											_tmp61_ = pos;
											if (g_str_has_prefix (_tmp61_, "&rpar;")) {
												GString* _tmp62_;
												const gchar* _tmp63_;
												const gchar* _tmp64_;
												const gchar* _tmp65_;
												const gchar* _tmp66_;
												const gchar* _tmp67_;
												GString* _tmp68_;
												_tmp62_ = builder;
												_tmp63_ = start;
												_tmp64_ = pos;
												_tmp65_ = start;
												g_string_append_len (_tmp62_, _tmp63_, (gssize) (((gchar*) _tmp64_) - ((gchar*) _tmp65_)));
												_tmp66_ = pos;
												start = (const gchar*) (((gchar*) _tmp66_) + 6);
												_tmp67_ = pos;
												pos = (const gchar*) (((gchar*) _tmp67_) + 5);
												_tmp68_ = builder;
												g_string_append_c (_tmp68_, ')');
											} else {
												const gchar* _tmp69_;
												_tmp69_ = pos;
												if (g_str_has_prefix (_tmp69_, "&num;")) {
													GString* _tmp70_;
													const gchar* _tmp71_;
													const gchar* _tmp72_;
													const gchar* _tmp73_;
													const gchar* _tmp74_;
													const gchar* _tmp75_;
													GString* _tmp76_;
													_tmp70_ = builder;
													_tmp71_ = start;
													_tmp72_ = pos;
													_tmp73_ = start;
													g_string_append_len (_tmp70_, _tmp71_, (gssize) (((gchar*) _tmp72_) - ((gchar*) _tmp73_)));
													_tmp74_ = pos;
													start = (const gchar*) (((gchar*) _tmp74_) + 5);
													_tmp75_ = pos;
													pos = (const gchar*) (((gchar*) _tmp75_) + 4);
													_tmp76_ = builder;
													g_string_append_c (_tmp76_, '#');
												} else {
													const gchar* _tmp77_;
													_tmp77_ = pos;
													if (g_str_has_prefix (_tmp77_, "&amp;")) {
														GString* _tmp78_;
														const gchar* _tmp79_;
														const gchar* _tmp80_;
														const gchar* _tmp81_;
														const gchar* _tmp82_;
														const gchar* _tmp83_;
														GString* _tmp84_;
														_tmp78_ = builder;
														_tmp79_ = start;
														_tmp80_ = pos;
														_tmp81_ = start;
														g_string_append_len (_tmp78_, _tmp79_, (gssize) (((gchar*) _tmp80_) - ((gchar*) _tmp81_)));
														_tmp82_ = pos;
														start = (const gchar*) (((gchar*) _tmp82_) + 5);
														_tmp83_ = pos;
														pos = (const gchar*) (((gchar*) _tmp83_) + 4);
														_tmp84_ = builder;
														g_string_append_c (_tmp84_, '&');
													} else {
														const gchar* _tmp85_;
														_tmp85_ = pos;
														if (g_str_has_prefix (_tmp85_, "&ast;")) {
															GString* _tmp86_;
															const gchar* _tmp87_;
															const gchar* _tmp88_;
															const gchar* _tmp89_;
															const gchar* _tmp90_;
															const gchar* _tmp91_;
															GString* _tmp92_;
															_tmp86_ = builder;
															_tmp87_ = start;
															_tmp88_ = pos;
															_tmp89_ = start;
															g_string_append_len (_tmp86_, _tmp87_, (gssize) (((gchar*) _tmp88_) - ((gchar*) _tmp89_)));
															_tmp90_ = pos;
															start = (const gchar*) (((gchar*) _tmp90_) + 5);
															_tmp91_ = pos;
															pos = (const gchar*) (((gchar*) _tmp91_) + 4);
															_tmp92_ = builder;
															g_string_append_c (_tmp92_, '*');
														} else {
															const gchar* _tmp93_;
															_tmp93_ = pos;
															if (g_str_has_prefix (_tmp93_, "&pi;")) {
																GString* _tmp94_;
																const gchar* _tmp95_;
																const gchar* _tmp96_;
																const gchar* _tmp97_;
																const gchar* _tmp98_;
																const gchar* _tmp99_;
																GString* _tmp100_;
																_tmp94_ = builder;
																_tmp95_ = start;
																_tmp96_ = pos;
																_tmp97_ = start;
																g_string_append_len (_tmp94_, _tmp95_, (gssize) (((gchar*) _tmp96_) - ((gchar*) _tmp97_)));
																_tmp98_ = pos;
																start = (const gchar*) (((gchar*) _tmp98_) + 4);
																_tmp99_ = pos;
																pos = (const gchar*) (((gchar*) _tmp99_) + 3);
																_tmp100_ = builder;
																g_string_append_unichar (_tmp100_, 960U);
															} else {
																const gchar* _tmp101_;
																_tmp101_ = pos;
																if (g_str_has_prefix (_tmp101_, "&lt;")) {
																	GString* _tmp102_;
																	const gchar* _tmp103_;
																	const gchar* _tmp104_;
																	const gchar* _tmp105_;
																	const gchar* _tmp106_;
																	const gchar* _tmp107_;
																	GString* _tmp108_;
																	_tmp102_ = builder;
																	_tmp103_ = start;
																	_tmp104_ = pos;
																	_tmp105_ = start;
																	g_string_append_len (_tmp102_, _tmp103_, (gssize) (((gchar*) _tmp104_) - ((gchar*) _tmp105_)));
																	_tmp106_ = pos;
																	start = (const gchar*) (((gchar*) _tmp106_) + 4);
																	_tmp107_ = pos;
																	pos = (const gchar*) (((gchar*) _tmp107_) + 3);
																	_tmp108_ = builder;
																	g_string_append_c (_tmp108_, '<');
																} else {
																	const gchar* _tmp109_;
																	_tmp109_ = pos;
																	if (g_str_has_prefix (_tmp109_, "&gt;")) {
																		GString* _tmp110_;
																		const gchar* _tmp111_;
																		const gchar* _tmp112_;
																		const gchar* _tmp113_;
																		const gchar* _tmp114_;
																		const gchar* _tmp115_;
																		GString* _tmp116_;
																		_tmp110_ = builder;
																		_tmp111_ = start;
																		_tmp112_ = pos;
																		_tmp113_ = start;
																		g_string_append_len (_tmp110_, _tmp111_, (gssize) (((gchar*) _tmp112_) - ((gchar*) _tmp113_)));
																		_tmp114_ = pos;
																		start = (const gchar*) (((gchar*) _tmp114_) + 4);
																		_tmp115_ = pos;
																		pos = (const gchar*) (((gchar*) _tmp115_) + 3);
																		_tmp116_ = builder;
																		g_string_append_c (_tmp116_, '>');
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if ((&txt) == (&start)) {
		gchar* _tmp117_;
		_tmp117_ = g_strdup (txt);
		result = _tmp117_;
		_g_string_free0 (builder);
		return result;
	} else {
		GString* _tmp118_;
		const gchar* _tmp119_;
		const gchar* _tmp120_;
		const gchar* _tmp121_;
		GString* _tmp122_;
		gchar* _tmp123_;
		_tmp118_ = builder;
		_tmp119_ = start;
		_tmp120_ = pos;
		_tmp121_ = start;
		g_string_append_len (_tmp118_, _tmp119_, (gssize) (((gchar*) _tmp120_) - ((gchar*) _tmp121_)));
		_tmp122_ = builder;
		_tmp123_ = _tmp122_->str;
		_tmp122_->str = NULL;
		result = _tmp123_;
		_g_string_free0 (builder);
		return result;
	}
	_g_string_free0 (builder);
}

void
valadoc_gtkdoc_scanner_reset (ValadocGtkdocScanner* self,
                              const gchar* content)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (content != NULL);
	self->priv->content = content;
	_valadoc_gtkdoc_token_unref0 (self->priv->tmp_token);
	self->priv->tmp_token = NULL;
	self->priv->pos = content;
	self->priv->column = 0;
	self->priv->line = 0;
}

static inline gunichar
valadoc_gtkdoc_scanner_next_char (ValadocGtkdocScanner* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->pos;
	_tmp1_ = g_utf8_next_char (_tmp0_);
	self->priv->pos = _tmp1_;
	_tmp2_ = self->priv->column;
	self->priv->column = _tmp2_ + 1;
	_tmp3_ = self->priv->pos;
	result = string_get_char (_tmp3_, (glong) 0);
	return result;
}

static inline gunichar
valadoc_gtkdoc_scanner_get (ValadocGtkdocScanner* self)
{
	const gchar* _tmp0_;
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->pos;
	result = string_get_char (_tmp0_, (glong) 0);
	return result;
}

static inline gboolean
valadoc_gtkdoc_scanner_letter (ValadocGtkdocScanner* self,
                               gunichar c)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (c >= ((gunichar) 'a')) {
		_tmp1_ = c <= ((gunichar) 'z');
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (c >= ((gunichar) 'A')) {
			_tmp2_ = c <= ((gunichar) 'Z');
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}

static inline gboolean
valadoc_gtkdoc_scanner_letter_or_number (ValadocGtkdocScanner* self,
                                         gunichar c)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (c >= ((gunichar) 'a')) {
		_tmp2_ = c <= ((gunichar) 'z');
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (c >= ((gunichar) 'A')) {
			_tmp3_ = c <= ((gunichar) 'Z');
		} else {
			_tmp3_ = FALSE;
		}
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		if (c >= ((gunichar) '0')) {
			_tmp4_ = c <= ((gunichar) '9');
		} else {
			_tmp4_ = FALSE;
		}
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

static inline gboolean
valadoc_gtkdoc_scanner_space (ValadocGtkdocScanner* self,
                              gunichar c)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (c == ((gunichar) ' ')) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c == ((gunichar) '\t');
	}
	result = _tmp0_;
	return result;
}

static inline gboolean
valadoc_gtkdoc_scanner_space_or_newline (ValadocGtkdocScanner* self,
                                         gunichar c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (c == ((gunichar) '\n')) {
		gint _tmp0_;
		_tmp0_ = self->priv->line;
		self->priv->line = _tmp0_ + 1;
		self->priv->column = 0;
		result = TRUE;
		return result;
	}
	result = valadoc_gtkdoc_scanner_space (self, c);
	return result;
}

static inline gint
valadoc_gtkdoc_scanner_offset (ValadocGtkdocScanner* self,
                               const gchar* a,
                               const gchar* b)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = (gint) (((gchar*) a) - ((gchar*) b));
	return result;
}

static inline gint
valadoc_gtkdoc_scanner_vararg_prefix (ValadocGtkdocScanner* self)
{
	const gchar* _tmp0_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->pos;
	if (g_str_has_prefix (_tmp0_, "...")) {
		valadoc_gtkdoc_scanner_next_char (self);
		valadoc_gtkdoc_scanner_next_char (self);
		valadoc_gtkdoc_scanner_next_char (self);
		result = 3;
		return result;
	}
	result = 0;
	return result;
}

static inline gint
valadoc_gtkdoc_scanner_id_prefix (ValadocGtkdocScanner* self)
{
	gunichar c = 0U;
	gboolean _tmp0_ = FALSE;
	gint start = 0;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	c = valadoc_gtkdoc_scanner_get (self);
	if (!valadoc_gtkdoc_scanner_letter (self, c)) {
		_tmp0_ = c != ((gunichar) '_');
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	start = self->priv->column;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		c = valadoc_gtkdoc_scanner_next_char (self);
		if (c == ((gunichar) '_')) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = valadoc_gtkdoc_scanner_letter_or_number (self, c);
		}
		if (!_tmp1_) {
			break;
		}
	}
	result = self->priv->column - start;
	return result;
}

static inline gint
valadoc_gtkdoc_scanner_g_id_prefix (ValadocGtkdocScanner* self)
{
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gunichar c = 0U;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	c = valadoc_gtkdoc_scanner_get (self);
	if (!valadoc_gtkdoc_scanner_letter (self, c)) {
		result = 0;
		return result;
	}
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		c = valadoc_gtkdoc_scanner_next_char (self);
		if (c == ((gunichar) '_')) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = c == ((gunichar) '-');
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = valadoc_gtkdoc_scanner_letter_or_number (self, c);
		}
		if (!_tmp1_) {
			break;
		}
	}
	_tmp3_ = self->priv->pos;
	_tmp4_ = start;
	result = valadoc_gtkdoc_scanner_offset (self, _tmp3_, _tmp4_);
	return result;
}

static inline gint
valadoc_gtkdoc_scanner_skip_spaces_and_newlines (ValadocGtkdocScanner* self)
{
	const gchar* start = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	if (valadoc_gtkdoc_scanner_space_or_newline (self, valadoc_gtkdoc_scanner_get (self))) {
		while (TRUE) {
			if (!valadoc_gtkdoc_scanner_space_or_newline (self, valadoc_gtkdoc_scanner_next_char (self))) {
				break;
			}
		}
	}
	_tmp1_ = self->priv->pos;
	_tmp2_ = start;
	result = valadoc_gtkdoc_scanner_offset (self, _tmp1_, _tmp2_);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static inline ValadocGtkdocToken*
valadoc_gtkdoc_scanner_function_prefix (ValadocGtkdocScanner* self)
{
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint column_start = 0;
	gint id_len = 0;
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp4_;
	ValadocGtkdocToken* _tmp5_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	ValadocGtkdocToken* _tmp13_;
	ValadocGtkdocToken* _tmp14_;
	ValadocGtkdocToken* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	column_start = self->priv->column;
	id_len = 0;
	id_len = valadoc_gtkdoc_scanner_id_prefix (self);
	if (id_len == 0) {
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_scanner_space_prefix (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) '(')) {
		const gchar* _tmp3_;
		self->priv->column = column_start;
		_tmp3_ = start;
		self->priv->pos = _tmp3_;
		result = NULL;
		return result;
	}
	valadoc_gtkdoc_scanner_next_char (self);
	_tmp4_ = valadoc_gtkdoc_scanner_space_prefix (self);
	_tmp5_ = _tmp4_;
	_valadoc_gtkdoc_token_unref0 (_tmp5_);
	if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) ')')) {
		const gchar* _tmp6_;
		self->priv->column = column_start;
		_tmp6_ = start;
		self->priv->pos = _tmp6_;
		result = NULL;
		return result;
	}
	valadoc_gtkdoc_scanner_next_char (self);
	_tmp7_ = start;
	_tmp8_ = string_substring (_tmp7_, (glong) 0, (glong) id_len);
	_tmp9_ = _tmp8_;
	_tmp10_ = start;
	_tmp11_ = self->priv->pos;
	_tmp12_ = start;
	_tmp13_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION, _tmp9_, NULL, _tmp10_, valadoc_gtkdoc_scanner_offset (self, _tmp11_, _tmp12_), self->priv->line, column_start, self->priv->column);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp9_);
	result = _tmp14_;
	return result;
}

static inline ValadocGtkdocToken*
valadoc_gtkdoc_scanner_gtkdoc_symbolic_link_prefix (ValadocGtkdocScanner* self,
                                                    gunichar c,
                                                    ValadocGtkdocTokenType type)
{
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint column_start = 0;
	gint id_len = 0;
	const gchar* separator = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	ValadocGtkdocToken* _tmp24_;
	ValadocGtkdocToken* _tmp25_;
	ValadocGtkdocToken* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (valadoc_gtkdoc_scanner_get (self) != c) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	column_start = self->priv->column;
	valadoc_gtkdoc_scanner_next_char (self);
	id_len = 0;
	id_len = valadoc_gtkdoc_scanner_id_prefix (self);
	if (id_len == 0) {
		gboolean _tmp1_ = FALSE;
		if (type == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM) {
			id_len = valadoc_gtkdoc_scanner_vararg_prefix (self);
			_tmp1_ = id_len == 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			const gchar* _tmp2_;
			self->priv->column = column_start;
			_tmp2_ = start;
			self->priv->pos = _tmp2_;
			result = NULL;
			return result;
		}
	}
	_tmp3_ = self->priv->pos;
	separator = _tmp3_;
	if (valadoc_gtkdoc_scanner_get (self) == ((gunichar) ':')) {
		gint separator_len = 0;
		gint id_len2 = 0;
		separator_len = 1;
		if (valadoc_gtkdoc_scanner_next_char (self) == ((gunichar) ':')) {
			gint _tmp4_;
			valadoc_gtkdoc_scanner_next_char (self);
			_tmp4_ = separator_len;
			separator_len = _tmp4_ + 1;
		}
		id_len2 = valadoc_gtkdoc_scanner_g_id_prefix (self);
		if (id_len2 == 0) {
			const gchar* _tmp5_;
			_tmp5_ = separator;
			self->priv->pos = _tmp5_;
		} else {
			id_len += id_len2 + separator_len;
		}
	} else {
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		_tmp7_ = self->priv->pos;
		if (g_str_has_prefix (_tmp7_, "->")) {
			_tmp6_ = TRUE;
		} else {
			const gchar* _tmp8_;
			_tmp8_ = self->priv->pos;
			_tmp6_ = g_str_has_prefix (_tmp8_, ".");
		}
		if (_tmp6_) {
			const gchar* sep_start = NULL;
			const gchar* _tmp9_;
			gint sep_column_start = 0;
			gint separator_len = 0;
			const gchar* _tmp10_;
			ValadocGtkdocToken* func_token = NULL;
			ValadocGtkdocToken* _tmp11_;
			ValadocGtkdocToken* _tmp12_;
			_tmp9_ = self->priv->pos;
			sep_start = _tmp9_;
			sep_column_start = self->priv->column;
			separator_len = 1;
			_tmp10_ = self->priv->pos;
			if (g_str_has_prefix (_tmp10_, "->")) {
				separator_len = 2;
				valadoc_gtkdoc_scanner_next_char (self);
			}
			valadoc_gtkdoc_scanner_next_char (self);
			_tmp11_ = valadoc_gtkdoc_scanner_function_prefix (self);
			func_token = _tmp11_;
			_tmp12_ = func_token;
			if (_tmp12_ == NULL) {
				gint id_len2 = 0;
				id_len2 = valadoc_gtkdoc_scanner_id_prefix (self);
				if (id_len2 > 0) {
					id_len += separator_len + id_len2;
				} else {
					const gchar* _tmp13_;
					self->priv->column = sep_column_start;
					_tmp13_ = sep_start;
					self->priv->pos = _tmp13_;
				}
			} else {
				ValadocGtkdocToken* _tmp14_;
				const gchar* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				_tmp14_ = func_token;
				_tmp15_ = _tmp14_->content;
				_tmp16_ = strlen (_tmp15_);
				_tmp17_ = _tmp16_;
				id_len += separator_len + _tmp17_;
			}
			_valadoc_gtkdoc_token_unref0 (func_token);
		}
	}
	_tmp18_ = start;
	_tmp19_ = string_substring (_tmp18_, (glong) 1, (glong) id_len);
	_tmp20_ = _tmp19_;
	_tmp21_ = start;
	_tmp22_ = self->priv->pos;
	_tmp23_ = start;
	_tmp24_ = valadoc_gtkdoc_token_new (type, _tmp20_, NULL, _tmp21_, valadoc_gtkdoc_scanner_offset (self, _tmp22_, _tmp23_), self->priv->line, column_start, self->priv->column);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp20_);
	result = _tmp25_;
	return result;
}

static inline ValadocGtkdocToken*
valadoc_gtkdoc_scanner_gtkdoc_property_prefix (ValadocGtkdocScanner* self)
{
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint column_start = 0;
	gint id_len = 0;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	ValadocGtkdocToken* _tmp8_;
	ValadocGtkdocToken* _tmp9_;
	ValadocGtkdocToken* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) ':')) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	column_start = self->priv->column;
	valadoc_gtkdoc_scanner_next_char (self);
	id_len = 0;
	id_len = valadoc_gtkdoc_scanner_g_id_prefix (self);
	if (id_len == 0) {
		const gchar* _tmp1_;
		self->priv->column = column_start;
		_tmp1_ = start;
		self->priv->pos = _tmp1_;
		result = NULL;
		return result;
	}
	_tmp2_ = start;
	_tmp3_ = string_substring (_tmp2_, (glong) 1, (glong) id_len);
	_tmp4_ = _tmp3_;
	_tmp5_ = start;
	_tmp6_ = self->priv->pos;
	_tmp7_ = start;
	_tmp8_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY, _tmp4_, NULL, _tmp5_, valadoc_gtkdoc_scanner_offset (self, _tmp6_, _tmp7_), self->priv->line, column_start, self->priv->column);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp4_);
	result = _tmp9_;
	return result;
}

static inline ValadocGtkdocToken*
valadoc_gtkdoc_scanner_gtkdoc_signal_prefix (ValadocGtkdocScanner* self)
{
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint column_start = 0;
	const gchar* _tmp2_;
	gint id_len = 0;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	ValadocGtkdocToken* _tmp10_;
	ValadocGtkdocToken* _tmp11_;
	ValadocGtkdocToken* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) ':')) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	column_start = self->priv->column;
	if (valadoc_gtkdoc_scanner_next_char (self) != ((gunichar) ':')) {
		const gchar* _tmp1_;
		self->priv->column = column_start;
		_tmp1_ = start;
		self->priv->pos = _tmp1_;
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->pos;
	start = _tmp2_;
	valadoc_gtkdoc_scanner_next_char (self);
	id_len = 0;
	id_len = valadoc_gtkdoc_scanner_g_id_prefix (self);
	if (id_len == 0) {
		const gchar* _tmp3_;
		self->priv->column = column_start;
		_tmp3_ = start;
		self->priv->pos = _tmp3_;
		result = NULL;
		return result;
	}
	_tmp4_ = start;
	_tmp5_ = string_substring (_tmp4_, (glong) 1, (glong) id_len);
	_tmp6_ = _tmp5_;
	_tmp7_ = start;
	_tmp8_ = self->priv->pos;
	_tmp9_ = start;
	_tmp10_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL, _tmp6_, NULL, _tmp7_, valadoc_gtkdoc_scanner_offset (self, _tmp8_, _tmp9_), self->priv->line, column_start, self->priv->column);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp6_);
	result = _tmp11_;
	return result;
}

static inline ValadocGtkdocToken*
valadoc_gtkdoc_scanner_gtkdoc_const_prefix (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocToken* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_scanner_gtkdoc_symbolic_link_prefix (self, (gunichar) '%', VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST);
	result = _tmp0_;
	return result;
}

static inline ValadocGtkdocToken*
valadoc_gtkdoc_scanner_gtkdoc_param_prefix (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocToken* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_scanner_gtkdoc_symbolic_link_prefix (self, (gunichar) '@', VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM);
	result = _tmp0_;
	return result;
}

static inline ValadocGtkdocToken*
valadoc_gtkdoc_scanner_gtkdoc_type_prefix (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocToken* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_scanner_gtkdoc_symbolic_link_prefix (self, (gunichar) '#', VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE);
	result = _tmp0_;
	return result;
}

static inline ValadocGtkdocToken*
valadoc_gtkdoc_scanner_xml_prefix (ValadocGtkdocScanner* self)
{
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint line_start = 0;
	gint column_start = 0;
	gboolean close = FALSE;
	const gchar* id_start = NULL;
	const gchar* _tmp26_;
	gint id_len = 0;
	ValaHashMap* map = NULL;
	GHashFunc _tmp28_;
	GEqualFunc _tmp29_;
	GEqualFunc _tmp30_;
	ValaHashMap* _tmp31_;
	gboolean open_and_close = FALSE;
	gboolean _tmp47_ = FALSE;
	ValadocGtkdocToken* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) '<')) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	line_start = self->priv->line;
	column_start = self->priv->column;
	valadoc_gtkdoc_scanner_next_char (self);
	if (valadoc_gtkdoc_scanner_get (self) == ((gunichar) '!')) {
		const gchar* _tmp25_;
		if (valadoc_gtkdoc_scanner_next_char (self) == ((gunichar) '-')) {
			if (valadoc_gtkdoc_scanner_next_char (self) != ((gunichar) '-')) {
				const gchar* _tmp1_;
				self->priv->column = column_start;
				_tmp1_ = start;
				self->priv->pos = _tmp1_;
				result = NULL;
				return result;
			}
			{
				gunichar c = 0U;
				c = valadoc_gtkdoc_scanner_next_char (self);
				{
					gboolean _tmp2_ = FALSE;
					_tmp2_ = TRUE;
					while (TRUE) {
						if (!_tmp2_) {
							c = valadoc_gtkdoc_scanner_next_char (self);
						}
						_tmp2_ = FALSE;
						if (!(c != ((gunichar) '\0'))) {
							break;
						}
						if (c == ((gunichar) '\n')) {
							gint _tmp3_;
							_tmp3_ = self->priv->line;
							self->priv->line = _tmp3_ + 1;
							self->priv->column = 0;
						} else {
							const gchar* _tmp4_;
							_tmp4_ = self->priv->pos;
							if (g_str_has_prefix (_tmp4_, "-->")) {
								const gchar* _tmp5_;
								const gchar* _tmp6_;
								const gchar* _tmp7_;
								ValadocGtkdocToken* _tmp8_;
								valadoc_gtkdoc_scanner_next_char (self);
								valadoc_gtkdoc_scanner_next_char (self);
								valadoc_gtkdoc_scanner_next_char (self);
								_tmp5_ = start;
								_tmp6_ = self->priv->pos;
								_tmp7_ = start;
								_tmp8_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT, "", NULL, _tmp5_, valadoc_gtkdoc_scanner_offset (self, _tmp6_, _tmp7_), self->priv->line, column_start, self->priv->column);
								result = _tmp8_;
								return result;
							}
						}
					}
				}
			}
		} else {
			const gchar* _tmp9_;
			_tmp9_ = self->priv->pos;
			if (g_str_has_prefix (_tmp9_, "[CDATA[")) {
				valadoc_gtkdoc_scanner_next_char (self);
				valadoc_gtkdoc_scanner_next_char (self);
				valadoc_gtkdoc_scanner_next_char (self);
				valadoc_gtkdoc_scanner_next_char (self);
				valadoc_gtkdoc_scanner_next_char (self);
				valadoc_gtkdoc_scanner_next_char (self);
				{
					gunichar c = 0U;
					c = valadoc_gtkdoc_scanner_next_char (self);
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							if (!_tmp10_) {
								c = valadoc_gtkdoc_scanner_next_char (self);
							}
							_tmp10_ = FALSE;
							if (!(c != ((gunichar) '\0'))) {
								break;
							}
							if (c == ((gunichar) '\n')) {
								gint _tmp11_;
								_tmp11_ = self->priv->line;
								self->priv->line = _tmp11_ + 1;
								self->priv->column = 0;
							} else {
								const gchar* _tmp12_;
								_tmp12_ = self->priv->pos;
								if (g_str_has_prefix (_tmp12_, "]]>")) {
									gchar* content = NULL;
									const gchar* _tmp13_;
									const gchar* _tmp14_;
									const gchar* _tmp15_;
									gchar* _tmp16_;
									const gchar* _tmp17_;
									gchar* _tmp18_;
									gchar* _tmp19_;
									const gchar* _tmp20_;
									const gchar* _tmp21_;
									const gchar* _tmp22_;
									ValadocGtkdocToken* _tmp23_;
									ValadocGtkdocToken* _tmp24_;
									_tmp13_ = start;
									_tmp14_ = self->priv->pos;
									_tmp15_ = start;
									_tmp16_ = string_substring (_tmp13_, (glong) 9, (glong) (valadoc_gtkdoc_scanner_offset (self, _tmp14_, _tmp15_) - 9));
									content = _tmp16_;
									valadoc_gtkdoc_scanner_next_char (self);
									valadoc_gtkdoc_scanner_next_char (self);
									valadoc_gtkdoc_scanner_next_char (self);
									_tmp17_ = content;
									_tmp18_ = valadoc_gtkdoc_scanner_unescape (_tmp17_);
									_tmp19_ = _tmp18_;
									_tmp20_ = start;
									_tmp21_ = self->priv->pos;
									_tmp22_ = start;
									_tmp23_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_WORD, _tmp19_, NULL, _tmp20_, valadoc_gtkdoc_scanner_offset (self, _tmp21_, _tmp22_), self->priv->line, column_start, self->priv->column);
									_tmp24_ = _tmp23_;
									_g_free0 (_tmp19_);
									result = _tmp24_;
									_g_free0 (content);
									return result;
								}
							}
						}
					}
				}
			}
		}
		_tmp25_ = start;
		self->priv->pos = _tmp25_;
		self->priv->column = column_start;
		self->priv->line = line_start;
		result = NULL;
		return result;
	}
	close = FALSE;
	if (valadoc_gtkdoc_scanner_get (self) == ((gunichar) '/')) {
		valadoc_gtkdoc_scanner_next_char (self);
		close = TRUE;
	}
	_tmp26_ = self->priv->pos;
	id_start = _tmp26_;
	id_len = 0;
	id_len = valadoc_gtkdoc_scanner_id_prefix (self);
	if (id_len == 0) {
		const gchar* _tmp27_;
		self->priv->column = column_start;
		_tmp27_ = start;
		self->priv->pos = _tmp27_;
		result = NULL;
		return result;
	}
	_tmp28_ = g_str_hash;
	_tmp29_ = g_str_equal;
	_tmp30_ = g_direct_equal;
	_tmp31_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp28_, _tmp29_, _tmp30_);
	map = _tmp31_;
	while (TRUE) {
		gboolean _tmp32_ = FALSE;
		gchar* name = NULL;
		gchar* val = NULL;
		const gchar* att_pos = NULL;
		const gchar* _tmp33_;
		gint att_id_len = 0;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gunichar c = 0U;
		const gchar* _tmp36_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		ValaHashMap* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp46_;
		if (close == FALSE) {
			_tmp32_ = valadoc_gtkdoc_scanner_skip_spaces_and_newlines (self) > 0;
		} else {
			_tmp32_ = FALSE;
		}
		if (!_tmp32_) {
			break;
		}
		_tmp33_ = self->priv->pos;
		att_pos = _tmp33_;
		att_id_len = 0;
		att_id_len = valadoc_gtkdoc_scanner_id_prefix (self);
		if (att_id_len == 0) {
			_g_free0 (val);
			_g_free0 (name);
			break;
		}
		_tmp34_ = att_pos;
		_tmp35_ = string_substring (_tmp34_, (glong) 0, (glong) att_id_len);
		_g_free0 (name);
		name = _tmp35_;
		if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) '=')) {
			_g_free0 (val);
			_g_free0 (name);
			break;
		}
		valadoc_gtkdoc_scanner_next_char (self);
		valadoc_gtkdoc_scanner_skip_spaces_and_newlines (self);
		if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) '"')) {
			_g_free0 (val);
			_g_free0 (name);
			break;
		}
		c = valadoc_gtkdoc_scanner_next_char (self);
		_tmp36_ = self->priv->pos;
		att_pos = _tmp36_;
		{
			gboolean _tmp37_ = FALSE;
			_tmp37_ = TRUE;
			while (TRUE) {
				gboolean _tmp38_ = FALSE;
				gboolean _tmp39_ = FALSE;
				if (!_tmp37_) {
					c = valadoc_gtkdoc_scanner_next_char (self);
				}
				_tmp37_ = FALSE;
				if (c != ((gunichar) '\0')) {
					_tmp39_ = c != ((gunichar) '\n');
				} else {
					_tmp39_ = FALSE;
				}
				if (_tmp39_) {
					_tmp38_ = c != ((gunichar) '"');
				} else {
					_tmp38_ = FALSE;
				}
				if (!_tmp38_) {
					break;
				}
			}
		}
		_tmp40_ = att_pos;
		_tmp41_ = self->priv->pos;
		_tmp42_ = att_pos;
		_tmp43_ = string_substring (_tmp40_, (glong) 0, (glong) valadoc_gtkdoc_scanner_offset (self, _tmp41_, _tmp42_));
		_g_free0 (val);
		val = _tmp43_;
		if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) '"')) {
			_g_free0 (val);
			_g_free0 (name);
			break;
		}
		valadoc_gtkdoc_scanner_next_char (self);
		_tmp44_ = map;
		_tmp45_ = name;
		_tmp46_ = val;
		vala_map_set ((ValaMap*) _tmp44_, _tmp45_, _tmp46_);
		_g_free0 (val);
		_g_free0 (name);
	}
	valadoc_gtkdoc_scanner_skip_spaces_and_newlines (self);
	open_and_close = FALSE;
	if (!close) {
		_tmp47_ = valadoc_gtkdoc_scanner_get (self) == ((gunichar) '/');
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		open_and_close = TRUE;
		valadoc_gtkdoc_scanner_next_char (self);
	}
	if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) '>')) {
		const gchar* _tmp48_;
		self->priv->line = line_start;
		self->priv->column = column_start;
		_tmp48_ = start;
		self->priv->pos = _tmp48_;
		result = NULL;
		_vala_map_unref0 (map);
		return result;
	}
	valadoc_gtkdoc_scanner_next_char (self);
	if (open_and_close) {
		const gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		ValadocGtkdocToken* _tmp55_;
		_tmp49_ = id_start;
		_tmp50_ = string_substring (_tmp49_, (glong) 0, (glong) id_len);
		_tmp51_ = _tmp50_;
		_tmp52_ = start;
		_tmp53_ = self->priv->pos;
		_tmp54_ = start;
		_tmp55_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE, _tmp51_, NULL, _tmp52_, valadoc_gtkdoc_scanner_offset (self, _tmp53_, _tmp54_), self->priv->line, column_start, self->priv->column);
		_valadoc_gtkdoc_token_unref0 (self->priv->tmp_token);
		self->priv->tmp_token = _tmp55_;
		_g_free0 (_tmp51_);
	}
	if (close) {
		const gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		const gchar* _tmp59_;
		const gchar* _tmp60_;
		const gchar* _tmp61_;
		ValadocGtkdocToken* _tmp62_;
		ValadocGtkdocToken* _tmp63_;
		_tmp56_ = id_start;
		_tmp57_ = string_substring (_tmp56_, (glong) 0, (glong) id_len);
		_tmp58_ = _tmp57_;
		_tmp59_ = start;
		_tmp60_ = self->priv->pos;
		_tmp61_ = start;
		_tmp62_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE, _tmp58_, NULL, _tmp59_, valadoc_gtkdoc_scanner_offset (self, _tmp60_, _tmp61_), self->priv->line, column_start, self->priv->column);
		_tmp63_ = _tmp62_;
		_g_free0 (_tmp58_);
		result = _tmp63_;
		_vala_map_unref0 (map);
		return result;
	} else {
		const gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		ValaHashMap* _tmp67_;
		const gchar* _tmp68_;
		const gchar* _tmp69_;
		const gchar* _tmp70_;
		ValadocGtkdocToken* _tmp71_;
		ValadocGtkdocToken* _tmp72_;
		_tmp64_ = id_start;
		_tmp65_ = string_substring (_tmp64_, (glong) 0, (glong) id_len);
		_tmp66_ = _tmp65_;
		_tmp67_ = map;
		_tmp68_ = start;
		_tmp69_ = self->priv->pos;
		_tmp70_ = start;
		_tmp71_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN, _tmp66_, _tmp67_, _tmp68_, valadoc_gtkdoc_scanner_offset (self, _tmp69_, _tmp70_), self->priv->line, column_start, self->priv->column);
		_tmp72_ = _tmp71_;
		_g_free0 (_tmp66_);
		result = _tmp72_;
		_vala_map_unref0 (map);
		return result;
	}
	_vala_map_unref0 (map);
}

static ValadocGtkdocToken*
valadoc_gtkdoc_scanner_newline_prefix (ValadocGtkdocScanner* self)
{
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	ValadocGtkdocToken* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) '\n')) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->line;
	self->priv->line = _tmp1_ + 1;
	self->priv->column = 0;
	{
		gunichar c = 0U;
		c = valadoc_gtkdoc_scanner_next_char (self);
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				if (!_tmp2_) {
					c = valadoc_gtkdoc_scanner_next_char (self);
				}
				_tmp2_ = FALSE;
				if (c == ((gunichar) ' ')) {
					_tmp3_ = TRUE;
				} else {
					_tmp3_ = c == ((gunichar) '\t');
				}
				if (!_tmp3_) {
					break;
				}
			}
		}
	}
	if (valadoc_gtkdoc_scanner_get (self) == ((gunichar) '\n')) {
		gint _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		ValadocGtkdocToken* _tmp8_;
		valadoc_gtkdoc_scanner_next_char (self);
		_tmp4_ = self->priv->line;
		self->priv->line = _tmp4_ + 1;
		self->priv->column = 0;
		_tmp5_ = start;
		_tmp6_ = self->priv->pos;
		_tmp7_ = start;
		_tmp8_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH, "\n\n", NULL, _tmp5_, valadoc_gtkdoc_scanner_offset (self, _tmp6_, _tmp7_), self->priv->line, self->priv->column, self->priv->column);
		result = _tmp8_;
		return result;
	} else {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		ValadocGtkdocToken* _tmp12_;
		_tmp9_ = start;
		_tmp10_ = self->priv->pos;
		_tmp11_ = start;
		_tmp12_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE, "\n", NULL, _tmp9_, valadoc_gtkdoc_scanner_offset (self, _tmp10_, _tmp11_), self->priv->line, self->priv->column, self->priv->column);
		result = _tmp12_;
		return result;
	}
}

static ValadocGtkdocToken*
valadoc_gtkdoc_scanner_eof_prefix (ValadocGtkdocScanner* self)
{
	const gchar* _tmp0_;
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) '\0')) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->pos;
	_tmp1_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_EOF, "", NULL, _tmp0_, 1, self->priv->line, self->priv->column, self->priv->column);
	result = _tmp1_;
	return result;
}

static ValadocGtkdocToken*
valadoc_gtkdoc_scanner_space_prefix (ValadocGtkdocScanner* self)
{
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint column_start = 0;
	gint len = 0;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ValadocGtkdocToken* _tmp12_;
	ValadocGtkdocToken* _tmp13_;
	ValadocGtkdocToken* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	column_start = self->priv->column;
	{
		gunichar c = 0U;
		c = valadoc_gtkdoc_scanner_get (self);
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_ = FALSE;
				if (!_tmp1_) {
					c = valadoc_gtkdoc_scanner_next_char (self);
				}
				_tmp1_ = FALSE;
				if (c == ((gunichar) ' ')) {
					_tmp2_ = TRUE;
				} else {
					_tmp2_ = c == ((gunichar) '\t');
				}
				if (!_tmp2_) {
					break;
				}
			}
		}
	}
	_tmp3_ = self->priv->pos;
	_tmp4_ = start;
	len = valadoc_gtkdoc_scanner_offset (self, _tmp3_, _tmp4_);
	if (len == 0) {
		const gchar* _tmp5_;
		self->priv->column = column_start;
		_tmp5_ = start;
		self->priv->pos = _tmp5_;
		result = NULL;
		return result;
	}
	_tmp6_ = start;
	_tmp7_ = string_substring (_tmp6_, (glong) 0, (glong) len);
	_tmp8_ = _tmp7_;
	_tmp9_ = start;
	_tmp10_ = self->priv->pos;
	_tmp11_ = start;
	_tmp12_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_SPACE, _tmp8_, NULL, _tmp9_, valadoc_gtkdoc_scanner_offset (self, _tmp10_, _tmp11_), self->priv->line, column_start, self->priv->column);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp8_);
	result = _tmp13_;
	return result;
}

static ValadocGtkdocToken*
valadoc_gtkdoc_scanner_word_prefix (ValadocGtkdocScanner* self)
{
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint column_start = 0;
	gunichar c = 0U;
	gboolean _tmp1_ = FALSE;
	gint len = 0;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	ValadocGtkdocToken* _tmp19_;
	ValadocGtkdocToken* _tmp20_;
	ValadocGtkdocToken* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	column_start = self->priv->column;
	c = valadoc_gtkdoc_scanner_get (self);
	if (c == ((gunichar) '<')) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = c == ((gunichar) '@');
	}
	if (_tmp1_) {
		valadoc_gtkdoc_scanner_next_char (self);
	}
	{
		gboolean _tmp2_ = FALSE;
		c = valadoc_gtkdoc_scanner_get (self);
		_tmp2_ = TRUE;
		while (TRUE) {
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			if (!_tmp2_) {
				c = valadoc_gtkdoc_scanner_next_char (self);
			}
			_tmp2_ = FALSE;
			if (c != ((gunichar) ' ')) {
				_tmp7_ = c != ((gunichar) '\t');
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				_tmp6_ = c != ((gunichar) '\n');
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				_tmp5_ = c != ((gunichar) '\0');
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				_tmp4_ = c != ((gunichar) '<');
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				_tmp3_ = c != ((gunichar) '@');
			} else {
				_tmp3_ = FALSE;
			}
			if (!_tmp3_) {
				break;
			}
		}
	}
	_tmp8_ = self->priv->pos;
	_tmp9_ = start;
	len = valadoc_gtkdoc_scanner_offset (self, _tmp8_, _tmp9_);
	if (len == 0) {
		const gchar* _tmp10_;
		self->priv->column = column_start;
		_tmp10_ = start;
		self->priv->pos = _tmp10_;
		result = NULL;
		return result;
	}
	_tmp11_ = start;
	_tmp12_ = string_substring (_tmp11_, (glong) 0, (glong) len);
	_tmp13_ = _tmp12_;
	_tmp14_ = valadoc_gtkdoc_scanner_unescape (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = start;
	_tmp17_ = self->priv->pos;
	_tmp18_ = start;
	_tmp19_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_WORD, _tmp15_, NULL, _tmp16_, valadoc_gtkdoc_scanner_offset (self, _tmp17_, _tmp18_), self->priv->line, column_start, self->priv->column);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	result = _tmp20_;
	return result;
}

static ValadocGtkdocToken*
valadoc_gtkdoc_scanner_gtkdoc_source_open_prefix (ValadocGtkdocScanner* self)
{
	const gchar* _tmp0_;
	const gchar* start = NULL;
	const gchar* _tmp1_;
	gint column_start = 0;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValadocGtkdocToken* _tmp5_;
	ValadocGtkdocToken* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pos;
	if (!g_str_has_prefix (_tmp0_, "|[")) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->pos;
	start = _tmp1_;
	column_start = self->priv->column;
	valadoc_gtkdoc_scanner_next_char (self);
	valadoc_gtkdoc_scanner_next_char (self);
	_tmp2_ = start;
	_tmp3_ = self->priv->pos;
	_tmp4_ = start;
	_tmp5_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN, "|[", NULL, _tmp2_, valadoc_gtkdoc_scanner_offset (self, _tmp3_, _tmp4_), self->priv->line, column_start, self->priv->column);
	result = _tmp5_;
	return result;
}

static ValadocGtkdocToken*
valadoc_gtkdoc_scanner_gtkdoc_source_close_prefix (ValadocGtkdocScanner* self)
{
	const gchar* _tmp0_;
	const gchar* start = NULL;
	const gchar* _tmp1_;
	gint column_start = 0;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValadocGtkdocToken* _tmp5_;
	ValadocGtkdocToken* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pos;
	if (!g_str_has_prefix (_tmp0_, "]|")) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->pos;
	start = _tmp1_;
	column_start = self->priv->column;
	valadoc_gtkdoc_scanner_next_char (self);
	valadoc_gtkdoc_scanner_next_char (self);
	_tmp2_ = start;
	_tmp3_ = self->priv->pos;
	_tmp4_ = start;
	_tmp5_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE, "]|", NULL, _tmp2_, valadoc_gtkdoc_scanner_offset (self, _tmp3_, _tmp4_), self->priv->line, column_start, self->priv->column);
	result = _tmp5_;
	return result;
}

static gpointer
_valadoc_gtkdoc_token_ref0 (gpointer self)
{
	return self ? valadoc_gtkdoc_token_ref (self) : NULL;
}

ValadocGtkdocToken*
valadoc_gtkdoc_scanner_next (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocToken* token = NULL;
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocGtkdocToken* _tmp5_;
	ValadocGtkdocToken* _tmp6_;
	ValadocGtkdocToken* _tmp7_;
	ValadocGtkdocToken* _tmp8_;
	ValadocGtkdocToken* _tmp9_;
	ValadocGtkdocToken* _tmp10_;
	ValadocGtkdocToken* _tmp11_;
	ValadocGtkdocToken* _tmp12_;
	ValadocGtkdocToken* _tmp13_;
	ValadocGtkdocToken* _tmp14_;
	ValadocGtkdocToken* _tmp15_;
	ValadocGtkdocToken* _tmp16_;
	ValadocGtkdocToken* _tmp17_;
	ValadocGtkdocToken* _tmp18_;
	ValadocGtkdocToken* _tmp19_;
	ValadocGtkdocToken* _tmp20_;
	ValadocGtkdocToken* _tmp21_;
	ValadocGtkdocToken* _tmp22_;
	ValadocGtkdocToken* _tmp23_;
	ValadocGtkdocToken* _tmp24_;
	ValadocGtkdocToken* _tmp25_;
	ValadocGtkdocToken* _tmp26_;
	ValadocGtkdocToken* _tmp27_;
	ValadocGtkdocToken* _tmp28_;
	ValadocGtkdocToken* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tmp_token;
	if (_tmp0_ != NULL) {
		ValadocGtkdocToken* tmp = NULL;
		ValadocGtkdocToken* _tmp1_;
		ValadocGtkdocToken* _tmp2_;
		_tmp1_ = self->priv->tmp_token;
		_tmp2_ = _valadoc_gtkdoc_token_ref0 (_tmp1_);
		tmp = _tmp2_;
		_valadoc_gtkdoc_token_unref0 (self->priv->tmp_token);
		self->priv->tmp_token = NULL;
		result = tmp;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_scanner_function_prefix (self);
	token = _tmp3_;
	_tmp4_ = token;
	if (_tmp4_ != NULL) {
		result = token;
		return result;
	}
	_tmp5_ = valadoc_gtkdoc_scanner_xml_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp5_;
	_tmp6_ = token;
	if (_tmp6_ != NULL) {
		result = token;
		return result;
	}
	_tmp7_ = valadoc_gtkdoc_scanner_gtkdoc_param_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp7_;
	_tmp8_ = token;
	if (_tmp8_ != NULL) {
		result = token;
		return result;
	}
	_tmp9_ = valadoc_gtkdoc_scanner_gtkdoc_const_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp9_;
	_tmp10_ = token;
	if (_tmp10_ != NULL) {
		result = token;
		return result;
	}
	_tmp11_ = valadoc_gtkdoc_scanner_gtkdoc_type_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp11_;
	_tmp12_ = token;
	if (_tmp12_ != NULL) {
		result = token;
		return result;
	}
	_tmp13_ = valadoc_gtkdoc_scanner_space_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp13_;
	_tmp14_ = token;
	if (_tmp14_ != NULL) {
		result = token;
		return result;
	}
	_tmp15_ = valadoc_gtkdoc_scanner_newline_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp15_;
	_tmp16_ = token;
	if (_tmp16_ != NULL) {
		result = token;
		return result;
	}
	_tmp17_ = valadoc_gtkdoc_scanner_gtkdoc_signal_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp17_;
	_tmp18_ = token;
	if (_tmp18_ != NULL) {
		result = token;
		return result;
	}
	_tmp19_ = valadoc_gtkdoc_scanner_gtkdoc_property_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp19_;
	_tmp20_ = token;
	if (_tmp20_ != NULL) {
		result = token;
		return result;
	}
	_tmp21_ = valadoc_gtkdoc_scanner_gtkdoc_source_open_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp21_;
	_tmp22_ = token;
	if (_tmp22_ != NULL) {
		result = token;
		return result;
	}
	_tmp23_ = valadoc_gtkdoc_scanner_gtkdoc_source_close_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp23_;
	_tmp24_ = token;
	if (_tmp24_ != NULL) {
		result = token;
		return result;
	}
	_tmp25_ = valadoc_gtkdoc_scanner_eof_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp25_;
	_tmp26_ = token;
	if (_tmp26_ != NULL) {
		result = token;
		return result;
	}
	_tmp27_ = valadoc_gtkdoc_scanner_word_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp27_;
	_tmp28_ = token;
	if (_tmp28_ != NULL) {
		result = token;
		return result;
	}
	g_assert_not_reached ();
	_valadoc_gtkdoc_token_unref0 (token);
}

static void
valadoc_gtkdoc_value_scanner_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
valadoc_gtkdoc_value_scanner_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		valadoc_gtkdoc_scanner_unref (value->data[0].v_pointer);
	}
}

static void
valadoc_gtkdoc_value_scanner_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = valadoc_gtkdoc_scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
valadoc_gtkdoc_value_scanner_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
valadoc_gtkdoc_value_scanner_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValadocGtkdocScanner * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = valadoc_gtkdoc_scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
valadoc_gtkdoc_value_scanner_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	ValadocGtkdocScanner ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = valadoc_gtkdoc_scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
valadoc_gtkdoc_param_spec_scanner (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	ValadocGtkdocParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALADOC_GTKDOC_TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
valadoc_gtkdoc_value_get_scanner (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}

void
valadoc_gtkdoc_value_set_scanner (GValue* value,
                                  gpointer v_object)
{
	ValadocGtkdocScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_GTKDOC_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		valadoc_gtkdoc_scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_gtkdoc_scanner_unref (old);
	}
}

void
valadoc_gtkdoc_value_take_scanner (GValue* value,
                                   gpointer v_object)
{
	ValadocGtkdocScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_GTKDOC_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_gtkdoc_scanner_unref (old);
	}
}

static void
valadoc_gtkdoc_scanner_class_init (ValadocGtkdocScannerClass * klass,
                                   gpointer klass_data)
{
	valadoc_gtkdoc_scanner_parent_class = g_type_class_peek_parent (klass);
	((ValadocGtkdocScannerClass *) klass)->finalize = valadoc_gtkdoc_scanner_finalize;
	g_type_class_adjust_private_offset (klass, &ValadocGtkdocScanner_private_offset);
}

static void
valadoc_gtkdoc_scanner_instance_init (ValadocGtkdocScanner * self,
                                      gpointer klass)
{
	self->priv = valadoc_gtkdoc_scanner_get_instance_private (self);
	self->ref_count = 1;
}

static void
valadoc_gtkdoc_scanner_finalize (ValadocGtkdocScanner * obj)
{
	ValadocGtkdocScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_GTKDOC_TYPE_SCANNER, ValadocGtkdocScanner);
	g_signal_handlers_destroy (self);
	_valadoc_gtkdoc_token_unref0 (self->priv->tmp_token);
}

static GType
valadoc_gtkdoc_scanner_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { valadoc_gtkdoc_value_scanner_init, valadoc_gtkdoc_value_scanner_free_value, valadoc_gtkdoc_value_scanner_copy_value, valadoc_gtkdoc_value_scanner_peek_pointer, "p", valadoc_gtkdoc_value_scanner_collect_value, "p", valadoc_gtkdoc_value_scanner_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValadocGtkdocScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_gtkdoc_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocGtkdocScanner), 0, (GInstanceInitFunc) valadoc_gtkdoc_scanner_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType valadoc_gtkdoc_scanner_type_id;
	valadoc_gtkdoc_scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValadocGtkdocScanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValadocGtkdocScanner_private_offset = g_type_add_instance_private (valadoc_gtkdoc_scanner_type_id, sizeof (ValadocGtkdocScannerPrivate));
	return valadoc_gtkdoc_scanner_type_id;
}

GType
valadoc_gtkdoc_scanner_get_type (void)
{
	static volatile gsize valadoc_gtkdoc_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_scanner_type_id__volatile)) {
		GType valadoc_gtkdoc_scanner_type_id;
		valadoc_gtkdoc_scanner_type_id = valadoc_gtkdoc_scanner_get_type_once ();
		g_once_init_leave (&valadoc_gtkdoc_scanner_type_id__volatile, valadoc_gtkdoc_scanner_type_id);
	}
	return valadoc_gtkdoc_scanner_type_id__volatile;
}

gpointer
valadoc_gtkdoc_scanner_ref (gpointer instance)
{
	ValadocGtkdocScanner * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
valadoc_gtkdoc_scanner_unref (gpointer instance)
{
	ValadocGtkdocScanner * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALADOC_GTKDOC_SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

