/* valacreationmethod.c generated by valac, the Vala compiler
 * generated from valacreationmethod.vala, do not modify */

/* valacreationmethod.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 * Copyright (C) 2007-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCreationMethodPrivate {
	gchar* _class_name;
	gboolean _chain_up;
};

static gint ValaCreationMethod_private_offset;
static gpointer vala_creation_method_parent_class = NULL;

static void vala_creation_method_real_accept (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base,
                                                ValaCodeVisitor* visitor);
static gboolean vala_creation_method_real_check (ValaCodeNode* base,
                                          ValaCodeContext* context);
static void vala_creation_method_finalize (ValaCodeNode * obj);
static GType vala_creation_method_get_type_once (void);

static inline gpointer
vala_creation_method_get_instance_private (ValaCreationMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCreationMethod_private_offset);
}

const gchar*
vala_creation_method_get_class_name (ValaCreationMethod* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_name;
	result = _tmp0_;
	return result;
}

void
vala_creation_method_set_class_name (ValaCreationMethod* self,
                                     const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_class_name);
	self->priv->_class_name = _tmp0_;
}

gboolean
vala_creation_method_get_chain_up (ValaCreationMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_chain_up;
	return result;
}

void
vala_creation_method_set_chain_up (ValaCreationMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_chain_up = value;
}

/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod*
vala_creation_method_construct (GType object_type,
                                const gchar* class_name,
                                const gchar* name,
                                ValaSourceReference* source_reference,
                                ValaComment* comment)
{
	ValaCreationMethod* self = NULL;
	ValaVoidType* _tmp0_;
	ValaVoidType* _tmp1_;
	_tmp0_ = vala_void_type_new (NULL);
	_tmp1_ = _tmp0_;
	self = (ValaCreationMethod*) vala_method_construct (object_type, name, (ValaDataType*) _tmp1_, source_reference, comment);
	_vala_code_node_unref0 (_tmp1_);
	vala_creation_method_set_class_name (self, class_name);
	return self;
}

ValaCreationMethod*
vala_creation_method_new (const gchar* class_name,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	return vala_creation_method_construct (VALA_TYPE_CREATION_METHOD, class_name, name, source_reference, comment);
}

static void
vala_creation_method_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_creation_method (visitor, self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_creation_method_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	ValaList* _tmp10_;
	ValaBlock* _tmp41_;
	ValaBlock* _tmp42_;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters ((ValaCallable*) self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaParameter* _tmp9_;
			_param_index = _param_index + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = vala_list_get (_tmp7_, _param_index);
			param = (ValaParameter*) _tmp8_;
			_tmp9_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp10_ = ((ValaMethod*) self)->error_types;
	if (_tmp10_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp11_;
			ValaList* _tmp12_;
			gint _error_type_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _error_type_index = 0;
			_tmp11_ = ((ValaMethod*) self)->error_types;
			_tmp12_ = _vala_iterable_ref0 (_tmp11_);
			_error_type_list = _tmp12_;
			_tmp13_ = _error_type_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_error_type_size = _tmp15_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp18_;
				gpointer _tmp19_;
				ValaDataType* _tmp20_;
				_error_type_index = _error_type_index + 1;
				_tmp16_ = _error_type_index;
				_tmp17_ = _error_type_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _error_type_list;
				_tmp19_ = vala_list_get (_tmp18_, _error_type_index);
				error_type = (ValaDataType*) _tmp19_;
				_tmp20_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp20_, visitor);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp21_;
		ValaList* _tmp22_;
		gint _precondition_size = 0;
		ValaList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _precondition_index = 0;
		_tmp21_ = vala_method_get_preconditions ((ValaMethod*) self);
		_tmp22_ = _vala_iterable_ref0 (_tmp21_);
		_precondition_list = _tmp22_;
		_tmp23_ = _precondition_list;
		_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_precondition_size = _tmp25_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp26_;
			gint _tmp27_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp28_;
			gpointer _tmp29_;
			ValaExpression* _tmp30_;
			_precondition_index = _precondition_index + 1;
			_tmp26_ = _precondition_index;
			_tmp27_ = _precondition_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _precondition_list;
			_tmp29_ = vala_list_get (_tmp28_, _precondition_index);
			precondition = (ValaExpression*) _tmp29_;
			_tmp30_ = precondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp30_, visitor);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp31_;
		ValaList* _tmp32_;
		gint _postcondition_size = 0;
		ValaList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _postcondition_index = 0;
		_tmp31_ = vala_method_get_postconditions ((ValaMethod*) self);
		_tmp32_ = _vala_iterable_ref0 (_tmp31_);
		_postcondition_list = _tmp32_;
		_tmp33_ = _postcondition_list;
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_postcondition_size = _tmp35_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp38_;
			gpointer _tmp39_;
			ValaExpression* _tmp40_;
			_postcondition_index = _postcondition_index + 1;
			_tmp36_ = _postcondition_index;
			_tmp37_ = _postcondition_size;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = _postcondition_list;
			_tmp39_ = vala_list_get (_tmp38_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp39_;
			_tmp40_ = postcondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp40_, visitor);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp41_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp42_ = _tmp41_;
	if (_tmp42_ != NULL) {
		ValaBlock* _tmp43_;
		ValaBlock* _tmp44_;
		_tmp43_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp44_ = _tmp43_;
		vala_code_node_accept ((ValaCodeNode*) _tmp44_, visitor);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_creation_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context)
{
	ValaCreationMethod * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	ValaParameter* _tmp22_;
	ValaParameter* _tmp23_;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_;
	gboolean _tmp29_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp34_;
	ValaSemanticAnalyzer* _tmp35_;
	ValaSourceFile* _tmp36_;
	ValaSourceFile* _tmp37_;
	ValaSourceFile* _tmp38_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp39_;
	ValaSemanticAnalyzer* _tmp40_;
	ValaSymbol* _tmp41_;
	ValaSymbol* _tmp42_;
	ValaSymbol* _tmp43_;
	ValaSourceReference* _tmp44_;
	ValaSourceReference* _tmp45_;
	ValaSemanticAnalyzer* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	gint i = 0;
	ValaList* _tmp138_;
	ValaBlock* _tmp181_;
	ValaBlock* _tmp182_;
	ValaSemanticAnalyzer* _tmp306_;
	ValaSemanticAnalyzer* _tmp307_;
	ValaSourceFile* _tmp308_;
	ValaSemanticAnalyzer* _tmp309_;
	ValaSemanticAnalyzer* _tmp310_;
	ValaSymbol* _tmp311_;
	gboolean _tmp312_ = FALSE;
	gboolean _tmp313_ = FALSE;
	gboolean _tmp314_;
	gboolean _tmp315_;
	gboolean _tmp326_ = FALSE;
	ValaBlock* _tmp327_;
	ValaBlock* _tmp328_;
	gboolean _tmp371_;
	gboolean _tmp372_;
	gboolean result = FALSE;
	self = (ValaCreationMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_class_name;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = self->priv->_class_name;
		_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = g_strcmp0 (_tmp6_, _tmp10_) != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaSemanticAnalyzer* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_context_get_analyzer (context);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_semantic_analyzer_get_current_symbol (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_symbol_get_full_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->_class_name;
		_tmp20_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_report_error (_tmp12_, _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp18_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp22_ = vala_method_get_this_parameter ((ValaMethod*) self);
	_tmp23_ = _tmp22_;
	if (_tmp23_ != NULL) {
		ValaParameter* _tmp24_;
		ValaParameter* _tmp25_;
		_tmp24_ = vala_method_get_this_parameter ((ValaMethod*) self);
		_tmp25_ = _tmp24_;
		vala_code_node_check ((ValaCodeNode*) _tmp25_, context);
	}
	_tmp28_ = vala_method_get_coroutine ((ValaMethod*) self);
	_tmp29_ = _tmp28_;
	if (_tmp29_) {
		gboolean _tmp30_;
		gboolean _tmp31_;
		_tmp30_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp31_ = _tmp30_;
		_tmp27_ = !_tmp31_;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		_tmp26_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp33_ = _tmp32_;
		vala_report_error (_tmp33_, "gio-2.0 package required for async constructors");
		result = FALSE;
		return result;
	}
	_tmp34_ = vala_code_context_get_analyzer (context);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_semantic_analyzer_get_current_source_file (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = _vala_source_file_ref0 (_tmp37_);
	old_source_file = _tmp38_;
	_tmp39_ = vala_code_context_get_analyzer (context);
	_tmp40_ = _tmp39_;
	_tmp41_ = vala_semantic_analyzer_get_current_symbol (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = _vala_code_node_ref0 (_tmp42_);
	old_symbol = _tmp43_;
	_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp45_ = _tmp44_;
	if (_tmp45_ != NULL) {
		ValaSemanticAnalyzer* _tmp46_;
		ValaSemanticAnalyzer* _tmp47_;
		ValaSourceReference* _tmp48_;
		ValaSourceReference* _tmp49_;
		ValaSourceFile* _tmp50_;
		ValaSourceFile* _tmp51_;
		_tmp46_ = vala_code_context_get_analyzer (context);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_source_reference_get_file (_tmp49_);
		_tmp51_ = _tmp50_;
		vala_semantic_analyzer_set_current_source_file (_tmp47_, _tmp51_);
	}
	_tmp52_ = vala_code_context_get_analyzer (context);
	_tmp53_ = _tmp52_;
	vala_semantic_analyzer_set_current_symbol (_tmp53_, (ValaSymbol*) self);
	i = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp54_;
		ValaList* _tmp55_;
		gint _param_size = 0;
		ValaList* _tmp56_;
		gint _tmp57_;
		gint _tmp58_;
		gint _param_index = 0;
		_tmp54_ = vala_callable_get_parameters ((ValaCallable*) self);
		_tmp55_ = _vala_iterable_ref0 (_tmp54_);
		_param_list = _tmp55_;
		_tmp56_ = _param_list;
		_tmp57_ = vala_collection_get_size ((ValaCollection*) _tmp56_);
		_tmp58_ = _tmp57_;
		_param_size = _tmp58_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp59_;
			gint _tmp60_;
			ValaParameter* param = NULL;
			ValaList* _tmp61_;
			gpointer _tmp62_;
			ValaParameter* _tmp63_;
			gboolean _tmp64_ = FALSE;
			gboolean _tmp65_ = FALSE;
			gint _tmp74_;
			gboolean _tmp75_ = FALSE;
			ValaParameter* _tmp76_;
			gboolean _tmp77_;
			gboolean _tmp78_;
			_param_index = _param_index + 1;
			_tmp59_ = _param_index;
			_tmp60_ = _param_size;
			if (!(_tmp59_ < _tmp60_)) {
				break;
			}
			_tmp61_ = _param_list;
			_tmp62_ = vala_list_get (_tmp61_, _param_index);
			param = (ValaParameter*) _tmp62_;
			_tmp63_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp63_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (i == 0) {
				ValaParameter* _tmp66_;
				gboolean _tmp67_;
				gboolean _tmp68_;
				_tmp66_ = param;
				_tmp67_ = vala_parameter_get_ellipsis (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp65_ = _tmp68_;
			} else {
				_tmp65_ = FALSE;
			}
			if (_tmp65_) {
				ValaBlock* _tmp69_;
				ValaBlock* _tmp70_;
				_tmp69_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp70_ = _tmp69_;
				_tmp64_ = _tmp70_ != NULL;
			} else {
				_tmp64_ = FALSE;
			}
			if (_tmp64_) {
				ValaParameter* _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaSourceReference* _tmp73_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp71_ = param;
				_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp71_);
				_tmp73_ = _tmp72_;
				vala_report_error (_tmp73_, "Named parameter required before `...'");
			}
			_tmp74_ = i;
			i = _tmp74_ + 1;
			_tmp76_ = param;
			_tmp77_ = vala_parameter_get_params_array (_tmp76_);
			_tmp78_ = _tmp77_;
			if (_tmp78_) {
				ValaBlock* _tmp79_;
				ValaBlock* _tmp80_;
				_tmp79_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp80_ = _tmp79_;
				_tmp75_ = _tmp80_ != NULL;
			} else {
				_tmp75_ = FALSE;
			}
			if (_tmp75_) {
				ValaLocalVariable* _tmp81_;
				ValaLocalVariable* _tmp82_;
				gboolean _tmp86_;
				gboolean _tmp87_;
				ValaArrayType* type = NULL;
				ValaParameter* _tmp91_;
				ValaDataType* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaArrayType* _tmp95_;
				ValaDataType* _tmp96_;
				ValaDataType* _tmp97_;
				ValaArrayType* _tmp98_;
				gboolean _tmp99_;
				gboolean _tmp100_;
				ValaArrayType* _tmp101_;
				gboolean _tmp102_ = FALSE;
				ValaArrayType* _tmp103_;
				ValaDataType* _tmp104_;
				ValaDataType* _tmp105_;
				ValaArrayType* _tmp114_;
				ValaExpression* _tmp115_;
				ValaExpression* _tmp116_;
				ValaArrayType* _tmp120_;
				ValaParameter* _tmp121_;
				const gchar* _tmp122_;
				const gchar* _tmp123_;
				ValaParameter* _tmp124_;
				ValaSourceReference* _tmp125_;
				ValaSourceReference* _tmp126_;
				ValaLocalVariable* _tmp127_;
				ValaLocalVariable* _tmp128_;
				ValaBlock* _tmp129_;
				ValaBlock* _tmp130_;
				ValaLocalVariable* _tmp131_;
				ValaLocalVariable* _tmp132_;
				ValaParameter* _tmp133_;
				ValaSourceReference* _tmp134_;
				ValaSourceReference* _tmp135_;
				ValaDeclarationStatement* _tmp136_;
				ValaDeclarationStatement* _tmp137_;
				_tmp81_ = vala_method_get_params_array_var ((ValaMethod*) self);
				_tmp82_ = _tmp81_;
				if (_tmp82_ != NULL) {
					ValaParameter* _tmp83_;
					ValaSourceReference* _tmp84_;
					ValaSourceReference* _tmp85_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp83_ = param;
					_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp83_);
					_tmp85_ = _tmp84_;
					vala_report_error (_tmp85_, "Only one params-array parameter is allowed");
					_vala_code_node_unref0 (param);
					continue;
				}
				_tmp86_ = vala_code_context_get_experimental (context);
				_tmp87_ = _tmp86_;
				if (!_tmp87_) {
					ValaParameter* _tmp88_;
					ValaSourceReference* _tmp89_;
					ValaSourceReference* _tmp90_;
					_tmp88_ = param;
					_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp88_);
					_tmp90_ = _tmp89_;
					vala_report_warning (_tmp90_, "Support of params-arrays is experimental");
				}
				_tmp91_ = param;
				_tmp92_ = vala_variable_get_variable_type ((ValaVariable*) _tmp91_);
				_tmp93_ = _tmp92_;
				_tmp94_ = vala_data_type_copy (_tmp93_);
				type = G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp95_ = type;
				_tmp96_ = vala_array_type_get_element_type (_tmp95_);
				_tmp97_ = _tmp96_;
				_tmp98_ = type;
				_tmp99_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp98_);
				_tmp100_ = _tmp99_;
				vala_data_type_set_value_owned (_tmp97_, _tmp100_);
				_tmp101_ = type;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp101_, TRUE);
				_tmp103_ = type;
				_tmp104_ = vala_array_type_get_element_type (_tmp103_);
				_tmp105_ = _tmp104_;
				if (vala_data_type_is_real_struct_type (_tmp105_)) {
					ValaArrayType* _tmp106_;
					ValaDataType* _tmp107_;
					ValaDataType* _tmp108_;
					gboolean _tmp109_;
					gboolean _tmp110_;
					_tmp106_ = type;
					_tmp107_ = vala_array_type_get_element_type (_tmp106_);
					_tmp108_ = _tmp107_;
					_tmp109_ = vala_data_type_get_nullable (_tmp108_);
					_tmp110_ = _tmp109_;
					_tmp102_ = !_tmp110_;
				} else {
					_tmp102_ = FALSE;
				}
				if (_tmp102_) {
					ValaParameter* _tmp111_;
					ValaSourceReference* _tmp112_;
					ValaSourceReference* _tmp113_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp111_ = param;
					_tmp112_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp111_);
					_tmp113_ = _tmp112_;
					vala_report_error (_tmp113_, "Only nullable struct elements are supported in params-array");
				}
				_tmp114_ = type;
				_tmp115_ = vala_array_type_get_length (_tmp114_);
				_tmp116_ = _tmp115_;
				if (_tmp116_ != NULL) {
					ValaParameter* _tmp117_;
					ValaSourceReference* _tmp118_;
					ValaSourceReference* _tmp119_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp117_ = param;
					_tmp118_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp117_);
					_tmp119_ = _tmp118_;
					vala_report_error (_tmp119_, "Passing length to params-array is not supported yet");
				}
				_tmp120_ = type;
				_tmp121_ = param;
				_tmp122_ = vala_symbol_get_name ((ValaSymbol*) _tmp121_);
				_tmp123_ = _tmp122_;
				_tmp124_ = param;
				_tmp125_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp124_);
				_tmp126_ = _tmp125_;
				_tmp127_ = vala_local_variable_new ((ValaDataType*) _tmp120_, _tmp123_, NULL, _tmp126_);
				_tmp128_ = _tmp127_;
				vala_method_set_params_array_var ((ValaMethod*) self, _tmp128_);
				_vala_code_node_unref0 (_tmp128_);
				_tmp129_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp130_ = _tmp129_;
				_tmp131_ = vala_method_get_params_array_var ((ValaMethod*) self);
				_tmp132_ = _tmp131_;
				_tmp133_ = param;
				_tmp134_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp133_);
				_tmp135_ = _tmp134_;
				_tmp136_ = vala_declaration_statement_new ((ValaSymbol*) _tmp132_, _tmp135_);
				_tmp137_ = _tmp136_;
				vala_block_insert_statement (_tmp130_, 0, (ValaStatement*) _tmp137_);
				_vala_code_node_unref0 (_tmp137_);
				_vala_code_node_unref0 (type);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp138_ = ((ValaMethod*) self)->error_types;
	if (_tmp138_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp139_;
			ValaList* _tmp140_;
			gint _error_type_size = 0;
			ValaList* _tmp141_;
			gint _tmp142_;
			gint _tmp143_;
			gint _error_type_index = 0;
			_tmp139_ = ((ValaMethod*) self)->error_types;
			_tmp140_ = _vala_iterable_ref0 (_tmp139_);
			_error_type_list = _tmp140_;
			_tmp141_ = _error_type_list;
			_tmp142_ = vala_collection_get_size ((ValaCollection*) _tmp141_);
			_tmp143_ = _tmp142_;
			_error_type_size = _tmp143_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp144_;
				gint _tmp145_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp146_;
				gpointer _tmp147_;
				ValaDataType* _tmp148_;
				ValaSemanticAnalyzer* _tmp149_;
				ValaSemanticAnalyzer* _tmp150_;
				ValaDataType* _tmp151_;
				_error_type_index = _error_type_index + 1;
				_tmp144_ = _error_type_index;
				_tmp145_ = _error_type_size;
				if (!(_tmp144_ < _tmp145_)) {
					break;
				}
				_tmp146_ = _error_type_list;
				_tmp147_ = vala_list_get (_tmp146_, _error_type_index);
				error_type = (ValaDataType*) _tmp147_;
				_tmp148_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp148_, context);
				_tmp149_ = vala_code_context_get_analyzer (context);
				_tmp150_ = _tmp149_;
				_tmp151_ = error_type;
				if (!vala_semantic_analyzer_is_type_accessible (_tmp150_, (ValaSymbol*) self, _tmp151_)) {
					ValaSourceReference* _tmp152_;
					ValaSourceReference* _tmp153_;
					ValaDataType* _tmp154_;
					gchar* _tmp155_;
					gchar* _tmp156_;
					gchar* _tmp157_;
					gchar* _tmp158_;
					gchar* _tmp159_;
					gchar* _tmp160_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp152_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp153_ = _tmp152_;
					_tmp154_ = error_type;
					_tmp155_ = vala_code_node_to_string ((ValaCodeNode*) _tmp154_);
					_tmp156_ = _tmp155_;
					_tmp157_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp158_ = _tmp157_;
					_tmp159_ = g_strdup_printf ("error type `%s' is less accessible than creation method `%s'", _tmp156_, _tmp158_);
					_tmp160_ = _tmp159_;
					vala_report_error (_tmp153_, _tmp160_);
					_g_free0 (_tmp160_);
					_g_free0 (_tmp158_);
					_g_free0 (_tmp156_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_iterable_unref0 (_error_type_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp161_;
		ValaList* _tmp162_;
		gint _precondition_size = 0;
		ValaList* _tmp163_;
		gint _tmp164_;
		gint _tmp165_;
		gint _precondition_index = 0;
		_tmp161_ = vala_method_get_preconditions ((ValaMethod*) self);
		_tmp162_ = _vala_iterable_ref0 (_tmp161_);
		_precondition_list = _tmp162_;
		_tmp163_ = _precondition_list;
		_tmp164_ = vala_collection_get_size ((ValaCollection*) _tmp163_);
		_tmp165_ = _tmp164_;
		_precondition_size = _tmp165_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp166_;
			gint _tmp167_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp168_;
			gpointer _tmp169_;
			ValaExpression* _tmp170_;
			_precondition_index = _precondition_index + 1;
			_tmp166_ = _precondition_index;
			_tmp167_ = _precondition_size;
			if (!(_tmp166_ < _tmp167_)) {
				break;
			}
			_tmp168_ = _precondition_list;
			_tmp169_ = vala_list_get (_tmp168_, _precondition_index);
			precondition = (ValaExpression*) _tmp169_;
			_tmp170_ = precondition;
			vala_code_node_check ((ValaCodeNode*) _tmp170_, context);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp171_;
		ValaList* _tmp172_;
		gint _postcondition_size = 0;
		ValaList* _tmp173_;
		gint _tmp174_;
		gint _tmp175_;
		gint _postcondition_index = 0;
		_tmp171_ = vala_method_get_postconditions ((ValaMethod*) self);
		_tmp172_ = _vala_iterable_ref0 (_tmp171_);
		_postcondition_list = _tmp172_;
		_tmp173_ = _postcondition_list;
		_tmp174_ = vala_collection_get_size ((ValaCollection*) _tmp173_);
		_tmp175_ = _tmp174_;
		_postcondition_size = _tmp175_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp176_;
			gint _tmp177_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp178_;
			gpointer _tmp179_;
			ValaExpression* _tmp180_;
			_postcondition_index = _postcondition_index + 1;
			_tmp176_ = _postcondition_index;
			_tmp177_ = _postcondition_size;
			if (!(_tmp176_ < _tmp177_)) {
				break;
			}
			_tmp178_ = _postcondition_list;
			_tmp179_ = vala_list_get (_tmp178_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp179_;
			_tmp180_ = postcondition;
			vala_code_node_check ((ValaCodeNode*) _tmp180_, context);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp181_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp182_ = _tmp181_;
	if (_tmp182_ != NULL) {
		ValaBlock* _tmp183_;
		ValaBlock* _tmp184_;
		ValaClass* cl = NULL;
		ValaSymbol* _tmp185_;
		ValaSymbol* _tmp186_;
		gboolean _tmp187_ = FALSE;
		gboolean _tmp188_ = FALSE;
		gboolean _tmp189_;
		_tmp183_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp184_ = _tmp183_;
		vala_code_node_check ((ValaCodeNode*) _tmp184_, context);
		_tmp185_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp186_ = _tmp185_;
		cl = VALA_IS_CLASS (_tmp186_) ? ((ValaClass*) _tmp186_) : NULL;
		_tmp189_ = self->priv->_chain_up;
		if (!_tmp189_) {
			ValaClass* _tmp190_;
			_tmp190_ = cl;
			_tmp188_ = _tmp190_ != NULL;
		} else {
			_tmp188_ = FALSE;
		}
		if (_tmp188_) {
			ValaClass* _tmp191_;
			ValaClass* _tmp192_;
			ValaClass* _tmp193_;
			_tmp191_ = cl;
			_tmp192_ = vala_class_get_base_class (_tmp191_);
			_tmp193_ = _tmp192_;
			_tmp187_ = _tmp193_ != NULL;
		} else {
			_tmp187_ = FALSE;
		}
		if (_tmp187_) {
			gboolean _tmp194_ = FALSE;
			gboolean _tmp195_ = FALSE;
			ValaProfile _tmp196_;
			ValaProfile _tmp197_;
			_tmp196_ = vala_code_context_get_profile (context);
			_tmp197_ = _tmp196_;
			if (_tmp197_ == VALA_PROFILE_GOBJECT) {
				ValaClass* _tmp198_;
				ValaClass* _tmp199_;
				ValaClass* _tmp200_;
				ValaCreationMethod* _tmp201_;
				ValaCreationMethod* _tmp202_;
				_tmp198_ = cl;
				_tmp199_ = vala_class_get_base_class (_tmp198_);
				_tmp200_ = _tmp199_;
				_tmp201_ = vala_class_get_default_construction_method (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp195_ = _tmp202_ != NULL;
			} else {
				_tmp195_ = FALSE;
			}
			if (_tmp195_) {
				ValaClass* _tmp203_;
				ValaClass* _tmp204_;
				ValaClass* _tmp205_;
				ValaCreationMethod* _tmp206_;
				ValaCreationMethod* _tmp207_;
				gboolean _tmp208_;
				gboolean _tmp209_;
				_tmp203_ = cl;
				_tmp204_ = vala_class_get_base_class (_tmp203_);
				_tmp205_ = _tmp204_;
				_tmp206_ = vala_class_get_default_construction_method (_tmp205_);
				_tmp207_ = _tmp206_;
				_tmp208_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp207_);
				_tmp209_ = _tmp208_;
				_tmp194_ = !_tmp209_;
			} else {
				_tmp194_ = FALSE;
			}
			if (_tmp194_) {
				ValaBlock* old_insert_block = NULL;
				ValaSemanticAnalyzer* _tmp210_;
				ValaSemanticAnalyzer* _tmp211_;
				ValaBlock* _tmp212_;
				ValaBlock* _tmp213_;
				ValaSemanticAnalyzer* _tmp214_;
				ValaSemanticAnalyzer* _tmp215_;
				ValaBlock* _tmp216_;
				ValaBlock* _tmp217_;
				ValaSemanticAnalyzer* _tmp218_;
				ValaSemanticAnalyzer* _tmp219_;
				ValaBlock* _tmp220_;
				ValaBlock* _tmp221_;
				ValaBlock* _tmp222_;
				ValaExpressionStatement* stmt = NULL;
				ValaSourceReference* _tmp223_;
				ValaSourceReference* _tmp224_;
				ValaMemberAccess* _tmp225_;
				ValaMemberAccess* _tmp226_;
				ValaSourceReference* _tmp227_;
				ValaSourceReference* _tmp228_;
				ValaMemberAccess* _tmp229_;
				ValaMemberAccess* _tmp230_;
				ValaSourceReference* _tmp231_;
				ValaSourceReference* _tmp232_;
				ValaMethodCall* _tmp233_;
				ValaMethodCall* _tmp234_;
				ValaSourceReference* _tmp235_;
				ValaSourceReference* _tmp236_;
				ValaExpressionStatement* _tmp237_;
				ValaExpressionStatement* _tmp238_;
				ValaBlock* _tmp239_;
				ValaBlock* _tmp240_;
				ValaExpressionStatement* _tmp241_;
				ValaExpressionStatement* _tmp242_;
				ValaSemanticAnalyzer* _tmp243_;
				ValaSemanticAnalyzer* _tmp244_;
				ValaSemanticAnalyzer* _tmp245_;
				ValaSemanticAnalyzer* _tmp246_;
				ValaBlock* _tmp247_;
				ValaBlock* _tmp248_;
				_tmp210_ = vala_code_context_get_analyzer (context);
				_tmp211_ = _tmp210_;
				_tmp212_ = _tmp211_->insert_block;
				_tmp213_ = _vala_code_node_ref0 (_tmp212_);
				old_insert_block = _tmp213_;
				_tmp214_ = vala_code_context_get_analyzer (context);
				_tmp215_ = _tmp214_;
				_tmp216_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp217_ = _tmp216_;
				vala_semantic_analyzer_set_current_symbol (_tmp215_, (ValaSymbol*) _tmp217_);
				_tmp218_ = vala_code_context_get_analyzer (context);
				_tmp219_ = _tmp218_;
				_tmp220_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp221_ = _tmp220_;
				_tmp222_ = _vala_code_node_ref0 (_tmp221_);
				_vala_code_node_unref0 (_tmp219_->insert_block);
				_tmp219_->insert_block = _tmp222_;
				_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp224_ = _tmp223_;
				_tmp225_ = vala_member_access_new_simple ("GLib", _tmp224_);
				_tmp226_ = _tmp225_;
				_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp228_ = _tmp227_;
				_tmp229_ = vala_member_access_new ((ValaExpression*) _tmp226_, "Object", _tmp228_);
				_tmp230_ = _tmp229_;
				_tmp231_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp232_ = _tmp231_;
				_tmp233_ = vala_method_call_new ((ValaExpression*) _tmp230_, _tmp232_);
				_tmp234_ = _tmp233_;
				_tmp235_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp236_ = _tmp235_;
				_tmp237_ = vala_expression_statement_new ((ValaExpression*) _tmp234_, _tmp236_);
				_tmp238_ = _tmp237_;
				_vala_code_node_unref0 (_tmp234_);
				_vala_code_node_unref0 (_tmp230_);
				_vala_code_node_unref0 (_tmp226_);
				stmt = _tmp238_;
				_tmp239_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp240_ = _tmp239_;
				_tmp241_ = stmt;
				vala_block_insert_statement (_tmp240_, 0, (ValaStatement*) _tmp241_);
				_tmp242_ = stmt;
				vala_code_node_check ((ValaCodeNode*) _tmp242_, context);
				_tmp243_ = vala_code_context_get_analyzer (context);
				_tmp244_ = _tmp243_;
				vala_semantic_analyzer_set_current_symbol (_tmp244_, (ValaSymbol*) self);
				_tmp245_ = vala_code_context_get_analyzer (context);
				_tmp246_ = _tmp245_;
				_tmp247_ = old_insert_block;
				_tmp248_ = _vala_code_node_ref0 (_tmp247_);
				_vala_code_node_unref0 (_tmp246_->insert_block);
				_tmp246_->insert_block = _tmp248_;
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (old_insert_block);
			} else {
				gboolean _tmp249_ = FALSE;
				ValaClass* _tmp250_;
				ValaClass* _tmp251_;
				ValaClass* _tmp252_;
				ValaCreationMethod* _tmp253_;
				ValaCreationMethod* _tmp254_;
				_tmp250_ = cl;
				_tmp251_ = vala_class_get_base_class (_tmp250_);
				_tmp252_ = _tmp251_;
				_tmp253_ = vala_class_get_default_construction_method (_tmp252_);
				_tmp254_ = _tmp253_;
				if (_tmp254_ == NULL) {
					_tmp249_ = TRUE;
				} else {
					ValaClass* _tmp255_;
					ValaClass* _tmp256_;
					ValaClass* _tmp257_;
					ValaCreationMethod* _tmp258_;
					ValaCreationMethod* _tmp259_;
					ValaSymbolAccessibility _tmp260_;
					ValaSymbolAccessibility _tmp261_;
					_tmp255_ = cl;
					_tmp256_ = vala_class_get_base_class (_tmp255_);
					_tmp257_ = _tmp256_;
					_tmp258_ = vala_class_get_default_construction_method (_tmp257_);
					_tmp259_ = _tmp258_;
					_tmp260_ = vala_symbol_get_access ((ValaSymbol*) _tmp259_);
					_tmp261_ = _tmp260_;
					_tmp249_ = _tmp261_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				}
				if (_tmp249_) {
					ValaSourceReference* _tmp262_;
					ValaSourceReference* _tmp263_;
					_tmp262_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp263_ = _tmp262_;
					vala_report_error (_tmp263_, "unable to chain up to private base constructor");
				} else {
					ValaClass* _tmp264_;
					ValaClass* _tmp265_;
					ValaClass* _tmp266_;
					ValaCreationMethod* _tmp267_;
					ValaCreationMethod* _tmp268_;
					_tmp264_ = cl;
					_tmp265_ = vala_class_get_base_class (_tmp264_);
					_tmp266_ = _tmp265_;
					_tmp267_ = vala_class_get_default_construction_method (_tmp266_);
					_tmp268_ = _tmp267_;
					if (vala_method_get_required_arguments ((ValaMethod*) _tmp268_) > 0) {
						ValaSourceReference* _tmp269_;
						ValaSourceReference* _tmp270_;
						_tmp269_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp270_ = _tmp269_;
						vala_report_error (_tmp270_, "unable to chain up to base constructor requiring arguments");
					} else {
						ValaBlock* old_insert_block = NULL;
						ValaSemanticAnalyzer* _tmp271_;
						ValaSemanticAnalyzer* _tmp272_;
						ValaBlock* _tmp273_;
						ValaBlock* _tmp274_;
						ValaSemanticAnalyzer* _tmp275_;
						ValaSemanticAnalyzer* _tmp276_;
						ValaBlock* _tmp277_;
						ValaBlock* _tmp278_;
						ValaSemanticAnalyzer* _tmp279_;
						ValaSemanticAnalyzer* _tmp280_;
						ValaBlock* _tmp281_;
						ValaBlock* _tmp282_;
						ValaBlock* _tmp283_;
						ValaExpressionStatement* stmt = NULL;
						ValaSourceReference* _tmp284_;
						ValaSourceReference* _tmp285_;
						ValaBaseAccess* _tmp286_;
						ValaBaseAccess* _tmp287_;
						ValaSourceReference* _tmp288_;
						ValaSourceReference* _tmp289_;
						ValaMethodCall* _tmp290_;
						ValaMethodCall* _tmp291_;
						ValaSourceReference* _tmp292_;
						ValaSourceReference* _tmp293_;
						ValaExpressionStatement* _tmp294_;
						ValaExpressionStatement* _tmp295_;
						ValaBlock* _tmp296_;
						ValaBlock* _tmp297_;
						ValaExpressionStatement* _tmp298_;
						ValaExpressionStatement* _tmp299_;
						ValaSemanticAnalyzer* _tmp300_;
						ValaSemanticAnalyzer* _tmp301_;
						ValaSemanticAnalyzer* _tmp302_;
						ValaSemanticAnalyzer* _tmp303_;
						ValaBlock* _tmp304_;
						ValaBlock* _tmp305_;
						_tmp271_ = vala_code_context_get_analyzer (context);
						_tmp272_ = _tmp271_;
						_tmp273_ = _tmp272_->insert_block;
						_tmp274_ = _vala_code_node_ref0 (_tmp273_);
						old_insert_block = _tmp274_;
						_tmp275_ = vala_code_context_get_analyzer (context);
						_tmp276_ = _tmp275_;
						_tmp277_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp278_ = _tmp277_;
						vala_semantic_analyzer_set_current_symbol (_tmp276_, (ValaSymbol*) _tmp278_);
						_tmp279_ = vala_code_context_get_analyzer (context);
						_tmp280_ = _tmp279_;
						_tmp281_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp282_ = _tmp281_;
						_tmp283_ = _vala_code_node_ref0 (_tmp282_);
						_vala_code_node_unref0 (_tmp280_->insert_block);
						_tmp280_->insert_block = _tmp283_;
						_tmp284_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp285_ = _tmp284_;
						_tmp286_ = vala_base_access_new (_tmp285_);
						_tmp287_ = _tmp286_;
						_tmp288_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp289_ = _tmp288_;
						_tmp290_ = vala_method_call_new ((ValaExpression*) _tmp287_, _tmp289_);
						_tmp291_ = _tmp290_;
						_tmp292_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp293_ = _tmp292_;
						_tmp294_ = vala_expression_statement_new ((ValaExpression*) _tmp291_, _tmp293_);
						_tmp295_ = _tmp294_;
						_vala_code_node_unref0 (_tmp291_);
						_vala_code_node_unref0 (_tmp287_);
						stmt = _tmp295_;
						_tmp296_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp297_ = _tmp296_;
						_tmp298_ = stmt;
						vala_block_insert_statement (_tmp297_, 0, (ValaStatement*) _tmp298_);
						_tmp299_ = stmt;
						vala_code_node_check ((ValaCodeNode*) _tmp299_, context);
						_tmp300_ = vala_code_context_get_analyzer (context);
						_tmp301_ = _tmp300_;
						vala_semantic_analyzer_set_current_symbol (_tmp301_, (ValaSymbol*) self);
						_tmp302_ = vala_code_context_get_analyzer (context);
						_tmp303_ = _tmp302_;
						_tmp304_ = old_insert_block;
						_tmp305_ = _vala_code_node_ref0 (_tmp304_);
						_vala_code_node_unref0 (_tmp303_->insert_block);
						_tmp303_->insert_block = _tmp305_;
						_vala_code_node_unref0 (stmt);
						_vala_code_node_unref0 (old_insert_block);
					}
				}
			}
		}
	}
	_tmp306_ = vala_code_context_get_analyzer (context);
	_tmp307_ = _tmp306_;
	_tmp308_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp307_, _tmp308_);
	_tmp309_ = vala_code_context_get_analyzer (context);
	_tmp310_ = _tmp309_;
	_tmp311_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp310_, _tmp311_);
	_tmp314_ = vala_method_get_is_abstract ((ValaMethod*) self);
	_tmp315_ = _tmp314_;
	if (_tmp315_) {
		_tmp313_ = TRUE;
	} else {
		gboolean _tmp316_;
		gboolean _tmp317_;
		_tmp316_ = vala_method_get_is_virtual ((ValaMethod*) self);
		_tmp317_ = _tmp316_;
		_tmp313_ = _tmp317_;
	}
	if (_tmp313_) {
		_tmp312_ = TRUE;
	} else {
		gboolean _tmp318_;
		gboolean _tmp319_;
		_tmp318_ = vala_method_get_overrides ((ValaMethod*) self);
		_tmp319_ = _tmp318_;
		_tmp312_ = _tmp319_;
	}
	if (_tmp312_) {
		ValaSourceReference* _tmp320_;
		ValaSourceReference* _tmp321_;
		gchar* _tmp322_;
		gchar* _tmp323_;
		gchar* _tmp324_;
		gchar* _tmp325_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp320_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp321_ = _tmp320_;
		_tmp322_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp323_ = _tmp322_;
		_tmp324_ = g_strdup_printf ("The creation method `%s' cannot be marked as override, virtual, or abs" \
"tract", _tmp323_);
		_tmp325_ = _tmp324_;
		vala_report_error (_tmp321_, _tmp325_);
		_g_free0 (_tmp325_);
		_g_free0 (_tmp323_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp327_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp328_ = _tmp327_;
	if (_tmp328_ != NULL) {
		ValaBlock* _tmp329_;
		ValaBlock* _tmp330_;
		gboolean _tmp331_;
		gboolean _tmp332_;
		_tmp329_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp330_ = _tmp329_;
		_tmp331_ = vala_code_node_get_error ((ValaCodeNode*) _tmp330_);
		_tmp332_ = _tmp331_;
		_tmp326_ = !_tmp332_;
	} else {
		_tmp326_ = FALSE;
	}
	if (_tmp326_) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp333_;
		ValaArrayList* _tmp334_;
		ValaBlock* _tmp335_;
		ValaBlock* _tmp336_;
		ValaArrayList* _tmp337_;
		_tmp333_ = g_direct_equal;
		_tmp334_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp333_);
		body_errors = _tmp334_;
		_tmp335_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp336_ = _tmp335_;
		_tmp337_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp336_, (ValaCollection*) _tmp337_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp338_;
			ValaArrayList* _tmp339_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp340_;
			gint _tmp341_;
			gint _tmp342_;
			gint _body_error_type_index = 0;
			_tmp338_ = body_errors;
			_tmp339_ = _vala_iterable_ref0 (_tmp338_);
			_body_error_type_list = _tmp339_;
			_tmp340_ = _body_error_type_list;
			_tmp341_ = vala_collection_get_size ((ValaCollection*) _tmp340_);
			_tmp342_ = _tmp341_;
			_body_error_type_size = _tmp342_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp343_;
				gint _tmp344_;
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp345_;
				gpointer _tmp346_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp347_;
				gboolean _tmp359_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				_tmp343_ = _body_error_type_index;
				_tmp344_ = _body_error_type_size;
				if (!(_tmp343_ < _tmp344_)) {
					break;
				}
				_tmp345_ = _body_error_type_list;
				_tmp346_ = vala_list_get ((ValaList*) _tmp345_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp346_;
				can_propagate_error = FALSE;
				_tmp347_ = ((ValaMethod*) self)->error_types;
				if (_tmp347_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp348_;
						ValaList* _tmp349_;
						gint _method_error_type_size = 0;
						ValaList* _tmp350_;
						gint _tmp351_;
						gint _tmp352_;
						gint _method_error_type_index = 0;
						_tmp348_ = ((ValaMethod*) self)->error_types;
						_tmp349_ = _vala_iterable_ref0 (_tmp348_);
						_method_error_type_list = _tmp349_;
						_tmp350_ = _method_error_type_list;
						_tmp351_ = vala_collection_get_size ((ValaCollection*) _tmp350_);
						_tmp352_ = _tmp351_;
						_method_error_type_size = _tmp352_;
						_method_error_type_index = -1;
						while (TRUE) {
							gint _tmp353_;
							gint _tmp354_;
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp355_;
							gpointer _tmp356_;
							ValaDataType* _tmp357_;
							ValaDataType* _tmp358_;
							_method_error_type_index = _method_error_type_index + 1;
							_tmp353_ = _method_error_type_index;
							_tmp354_ = _method_error_type_size;
							if (!(_tmp353_ < _tmp354_)) {
								break;
							}
							_tmp355_ = _method_error_type_list;
							_tmp356_ = vala_list_get (_tmp355_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp356_;
							_tmp357_ = body_error_type;
							_tmp358_ = method_error_type;
							if (vala_data_type_compatible (_tmp357_, _tmp358_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
						_vala_iterable_unref0 (_method_error_type_list);
					}
				}
				if (!can_propagate_error) {
					ValaDataType* _tmp360_;
					gboolean _tmp361_;
					gboolean _tmp362_;
					_tmp360_ = body_error_type;
					_tmp361_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp360_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp362_ = _tmp361_;
					_tmp359_ = !_tmp362_;
				} else {
					_tmp359_ = FALSE;
				}
				if (_tmp359_) {
					ValaDataType* _tmp363_;
					ValaSourceReference* _tmp364_;
					ValaSourceReference* _tmp365_;
					ValaDataType* _tmp366_;
					gchar* _tmp367_;
					gchar* _tmp368_;
					gchar* _tmp369_;
					gchar* _tmp370_;
					_tmp363_ = body_error_type;
					_tmp364_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp363_);
					_tmp365_ = _tmp364_;
					_tmp366_ = body_error_type;
					_tmp367_ = vala_code_node_to_string ((ValaCodeNode*) _tmp366_);
					_tmp368_ = _tmp367_;
					_tmp369_ = g_strdup_printf ("unhandled error `%s'", _tmp368_);
					_tmp370_ = _tmp369_;
					vala_report_warning (_tmp365_, _tmp370_);
					_g_free0 (_tmp370_);
					_g_free0 (_tmp368_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (body_errors);
	}
	_tmp371_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp372_ = _tmp371_;
	result = !_tmp372_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_creation_method_class_init (ValaCreationMethodClass * klass,
                                 gpointer klass_data)
{
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_creation_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCreationMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_creation_method_real_check;
}

static void
vala_creation_method_instance_init (ValaCreationMethod * self,
                                    gpointer klass)
{
	self->priv = vala_creation_method_get_instance_private (self);
}

static void
vala_creation_method_finalize (ValaCodeNode * obj)
{
	ValaCreationMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
	_g_free0 (self->priv->_class_name);
	VALA_CODE_NODE_CLASS (vala_creation_method_parent_class)->finalize (obj);
}

/**
 * Represents a type creation method.
 */
static GType
vala_creation_method_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_instance_init, NULL };
	GType vala_creation_method_type_id;
	vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
	ValaCreationMethod_private_offset = g_type_add_instance_private (vala_creation_method_type_id, sizeof (ValaCreationMethodPrivate));
	return vala_creation_method_type_id;
}

GType
vala_creation_method_get_type (void)
{
	static volatile gsize vala_creation_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_creation_method_type_id__volatile)) {
		GType vala_creation_method_type_id;
		vala_creation_method_type_id = vala_creation_method_get_type_once ();
		g_once_init_leave (&vala_creation_method_type_id__volatile, vala_creation_method_type_id);
	}
	return vala_creation_method_type_id__volatile;
}

