/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaAssignment_private_offset;
static gpointer vala_assignment_parent_class = NULL;

static void vala_assignment_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor);
static gchar* vala_assignment_real_to_string (ValaCodeNode* base);
static void vala_assignment_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base,
                                             ValaSymbol* sym);
static void vala_assignment_real_get_error_types (ValaCodeNode* base,
                                           ValaCollection* collection,
                                           ValaSourceReference* source_reference);
static gboolean vala_assignment_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static void vala_assignment_check_constant_assignment (ValaAssignment* self,
                                                ValaMemberAccess* inner);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                              ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);
static GType vala_assignment_get_type_once (void);

static inline gpointer
vala_assignment_get_instance_private (ValaAssignment* self)
{
	return G_STRUCT_MEMBER_P (self, ValaAssignment_private_offset);
}

ValaExpression*
vala_assignment_get_left (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_assignment_set_left (ValaAssignment* self,
                          ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaAssignmentOperator
vala_assignment_get_operator (ValaAssignment* self)
{
	ValaAssignmentOperator result;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_operator (ValaAssignment* self,
                              ValaAssignmentOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_assignment_get_right (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_right (ValaAssignment* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment*
vala_assignment_construct (GType object_type,
                           ValaExpression* left,
                           ValaExpression* right,
                           ValaAssignmentOperator operator,
                           ValaSourceReference* source_reference)
{
	ValaAssignment* self = NULL;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	vala_assignment_set_right (self, right);
	vala_assignment_set_operator (self, operator);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_assignment_set_left (self, left);
	return self;
}

ValaAssignment*
vala_assignment_new (ValaExpression* left,
                     ValaExpression* right,
                     ValaAssignmentOperator operator,
                     ValaSourceReference* source_reference)
{
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}

static void
vala_assignment_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_assignment (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_assignment_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static gchar*
vala_assignment_real_to_string (ValaCodeNode* base)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaAssignmentOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result = NULL;
	self = (ValaAssignment*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_assignment_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static void
vala_assignment_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_assignment_set_left (self, new_node);
	}
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_assignment_set_right (self, new_node);
	}
}

static gboolean
vala_assignment_real_is_pure (ValaExpression* base)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_assignment_real_is_accessible (ValaExpression* base,
                                    ValaSymbol* sym)
{
	ValaAssignment * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_assignment_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_assignment_real_get_error_types (ValaCodeNode* base,
                                      ValaCollection* collection,
                                      ValaSourceReference* source_reference)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_assignment_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaAssignment * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp93_;
	ValaExpression* _tmp94_;
	ValaExpression* _tmp95_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp97_;
	ValaExpression* _tmp98_;
	ValaExpression* _tmp242_;
	ValaExpression* _tmp243_;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp244_;
	ValaExpression* _tmp245_;
	gboolean _tmp246_ = FALSE;
	gboolean _tmp247_ = FALSE;
	ValaAssignmentOperator _tmp248_;
	ValaMemberAccess* _tmp297_;
	ValaExpression* _tmp606_;
	ValaExpression* _tmp607_;
	ValaDataType* _tmp608_;
	ValaDataType* _tmp609_;
	ValaDataType* _tmp618_;
	ValaDataType* _tmp619_;
	gboolean _tmp622_;
	gboolean _tmp623_;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (VALA_IS_TUPLE (_tmp7_)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_EXPRESSION_STATEMENT (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLocalVariable* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaDeclarationStatement* _tmp26_;
		ValaSemanticAnalyzer* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaBlock* _tmp29_;
		ValaDeclarationStatement* _tmp30_;
		ValaDeclarationStatement* _tmp31_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaSemanticAnalyzer* _tmp82_;
		ValaSemanticAnalyzer* _tmp83_;
		ValaList* _tmp84_;
		ValaCodeNode* _tmp85_;
		ValaCodeNode* _tmp86_;
		ValaExpressionStatement* _tmp87_;
		ValaExpression* _tmp88_;
		ValaExpression* _tmp89_;
		ValaExpressionStatement* _tmp90_;
		ValaExpression* _tmp91_;
		ValaExpression* _tmp92_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		tuple = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple);
		_tmp13_ = vala_code_node_get_temp_name ();
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_assignment_get_right (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_assignment_get_right (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_local_variable_new (NULL, _tmp14_, _tmp16_, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp14_);
		local = _tmp22_;
		_tmp23_ = local;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp25_);
		decl = _tmp26_;
		_tmp27_ = vala_code_context_get_analyzer (context);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_->insert_block;
		_tmp30_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp29_, (ValaStatement*) _tmp30_);
		_tmp31_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp31_, context);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp32_;
			ValaList* _tmp33_;
			ValaList* _tmp34_;
			gint _expr_size = 0;
			ValaList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _expr_index = 0;
			_tmp32_ = tuple;
			_tmp33_ = vala_tuple_get_expressions (_tmp32_);
			_tmp34_ = _vala_iterable_ref0 (_tmp33_);
			_expr_list = _tmp34_;
			_tmp35_ = _expr_list;
			_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_expr_size = _tmp37_;
			_expr_index = -1;
			while (TRUE) {
				gint _tmp38_;
				gint _tmp39_;
				ValaExpression* expr = NULL;
				ValaList* _tmp40_;
				gpointer _tmp41_;
				ValaExpressionStatement* _tmp42_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				ValaExpression* _tmp51_;
				ValaExpression* _tmp52_;
				ValaSourceReference* _tmp53_;
				ValaSourceReference* _tmp54_;
				ValaMemberAccess* _tmp55_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp56_;
				ValaExpression* _tmp57_;
				ValaSourceReference* _tmp58_;
				ValaSourceReference* _tmp59_;
				ValaElementAccess* _tmp60_;
				ValaElementAccess* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				ValaExpression* _tmp64_;
				ValaSourceReference* _tmp65_;
				ValaSourceReference* _tmp66_;
				ValaIntegerLiteral* _tmp67_;
				ValaIntegerLiteral* _tmp68_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp69_;
				ValaElementAccess* _tmp70_;
				ValaAssignmentOperator _tmp71_;
				ValaExpression* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaSourceReference* _tmp74_;
				ValaAssignment* _tmp75_;
				ValaAssignment* _tmp76_;
				ValaExpression* _tmp77_;
				ValaSourceReference* _tmp78_;
				ValaSourceReference* _tmp79_;
				ValaExpressionStatement* _tmp80_;
				gint _tmp81_;
				_expr_index = _expr_index + 1;
				_tmp38_ = _expr_index;
				_tmp39_ = _expr_size;
				if (!(_tmp38_ < _tmp39_)) {
					break;
				}
				_tmp40_ = _expr_list;
				_tmp41_ = vala_list_get (_tmp40_, _expr_index);
				expr = (ValaExpression*) _tmp41_;
				_tmp42_ = stmt;
				if (_tmp42_ != NULL) {
					ValaSemanticAnalyzer* _tmp43_;
					ValaSemanticAnalyzer* _tmp44_;
					ValaBlock* _tmp45_;
					ValaExpressionStatement* _tmp46_;
					ValaExpressionStatement* _tmp47_;
					_tmp43_ = vala_code_context_get_analyzer (context);
					_tmp44_ = _tmp43_;
					_tmp45_ = _tmp44_->insert_block;
					_tmp46_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp45_, (ValaStatement*) _tmp46_);
					_tmp47_ = stmt;
					vala_code_node_check ((ValaCodeNode*) _tmp47_, context);
				}
				_tmp48_ = local;
				_tmp49_ = vala_symbol_get_name ((ValaSymbol*) _tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = vala_assignment_get_right (self);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_member_access_new_simple (_tmp50_, _tmp54_);
				temp_access = _tmp55_;
				_tmp56_ = temp_access;
				_tmp57_ = expr;
				_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = vala_element_access_new ((ValaExpression*) _tmp56_, _tmp59_);
				ea = _tmp60_;
				_tmp61_ = ea;
				_tmp62_ = g_strdup_printf ("%i", i);
				_tmp63_ = _tmp62_;
				_tmp64_ = expr;
				_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = vala_integer_literal_new (_tmp63_, _tmp66_);
				_tmp68_ = _tmp67_;
				vala_element_access_append_index (_tmp61_, (ValaExpression*) _tmp68_);
				_vala_code_node_unref0 (_tmp68_);
				_g_free0 (_tmp63_);
				_tmp69_ = expr;
				_tmp70_ = ea;
				_tmp71_ = self->priv->_operator;
				_tmp72_ = expr;
				_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = vala_assignment_new (_tmp69_, (ValaExpression*) _tmp70_, _tmp71_, _tmp74_);
				assign = _tmp75_;
				_tmp76_ = assign;
				_tmp77_ = expr;
				_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = vala_expression_statement_new ((ValaExpression*) _tmp76_, _tmp79_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp80_;
				_tmp81_ = i;
				i = _tmp81_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		_tmp82_ = vala_code_context_get_analyzer (context);
		_tmp83_ = _tmp82_;
		_tmp84_ = _tmp83_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp84_, (ValaCodeNode*) self);
		_tmp85_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp86_ = _tmp85_;
		_tmp87_ = stmt;
		_tmp88_ = vala_expression_statement_get_expression (_tmp87_);
		_tmp89_ = _tmp88_;
		vala_code_node_replace_expression (_tmp86_, (ValaExpression*) self, _tmp89_);
		_tmp90_ = stmt;
		_tmp91_ = vala_expression_statement_get_expression (_tmp90_);
		_tmp92_ = _tmp91_;
		result = vala_code_node_check ((ValaCodeNode*) _tmp92_, context);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp93_ = vala_assignment_get_left (self);
	_tmp94_ = _tmp93_;
	vala_expression_set_lvalue (_tmp94_, TRUE);
	_tmp95_ = vala_assignment_get_left (self);
	_tmp96_ = _tmp95_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp96_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp97_ = vala_assignment_get_left (self);
	_tmp98_ = _tmp97_;
	if (VALA_IS_MEMBER_ACCESS (_tmp98_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp99_;
		ValaExpression* _tmp100_;
		ValaMemberAccess* _tmp101_;
		gboolean _tmp102_ = FALSE;
		gboolean _tmp103_ = FALSE;
		ValaMemberAccess* _tmp104_;
		ValaSymbol* _tmp105_;
		ValaSymbol* _tmp106_;
		ValaMemberAccess* _tmp122_;
		gboolean _tmp123_;
		gboolean _tmp124_;
		gboolean _tmp134_ = FALSE;
		ValaMemberAccess* _tmp135_;
		gboolean _tmp136_;
		gboolean _tmp137_;
		ValaMemberAccess* _tmp141_;
		ValaSymbol* _tmp142_;
		ValaSymbol* _tmp143_;
		_tmp99_ = vala_assignment_get_left (self);
		_tmp100_ = _tmp99_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp101_ = ma;
		vala_assignment_check_constant_assignment (self, _tmp101_);
		_tmp104_ = ma;
		_tmp105_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp104_);
		_tmp106_ = _tmp105_;
		if (!VALA_IS_DYNAMIC_PROPERTY (_tmp106_)) {
			ValaMemberAccess* _tmp107_;
			ValaDataType* _tmp108_;
			ValaDataType* _tmp109_;
			_tmp107_ = ma;
			_tmp108_ = vala_expression_get_value_type ((ValaExpression*) _tmp107_);
			_tmp109_ = _tmp108_;
			_tmp103_ = _tmp109_ == NULL;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			_tmp102_ = TRUE;
		} else {
			gboolean _tmp110_ = FALSE;
			gboolean _tmp111_ = FALSE;
			ValaMemberAccess* _tmp112_;
			ValaExpression* _tmp113_;
			ValaExpression* _tmp114_;
			_tmp112_ = ma;
			_tmp113_ = vala_member_access_get_inner (_tmp112_);
			_tmp114_ = _tmp113_;
			if (_tmp114_ == NULL) {
				ValaMemberAccess* _tmp115_;
				const gchar* _tmp116_;
				const gchar* _tmp117_;
				_tmp115_ = ma;
				_tmp116_ = vala_member_access_get_member_name (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp111_ = g_strcmp0 (_tmp117_, "this") == 0;
			} else {
				_tmp111_ = FALSE;
			}
			if (_tmp111_) {
				ValaSemanticAnalyzer* _tmp118_;
				ValaSemanticAnalyzer* _tmp119_;
				_tmp118_ = vala_code_context_get_analyzer (context);
				_tmp119_ = _tmp118_;
				_tmp110_ = vala_semantic_analyzer_is_in_instance_method (_tmp119_);
			} else {
				_tmp110_ = FALSE;
			}
			_tmp102_ = _tmp110_;
		}
		if (_tmp102_) {
			ValaSourceReference* _tmp120_;
			ValaSourceReference* _tmp121_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp121_ = _tmp120_;
			vala_report_error (_tmp121_, "unsupported lvalue in assignment");
			result = FALSE;
			return result;
		}
		_tmp122_ = ma;
		_tmp123_ = vala_member_access_get_prototype_access (_tmp122_);
		_tmp124_ = _tmp123_;
		if (_tmp124_) {
			ValaSourceReference* _tmp125_;
			ValaSourceReference* _tmp126_;
			ValaMemberAccess* _tmp127_;
			ValaSymbol* _tmp128_;
			ValaSymbol* _tmp129_;
			gchar* _tmp130_;
			gchar* _tmp131_;
			gchar* _tmp132_;
			gchar* _tmp133_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp125_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp126_ = _tmp125_;
			_tmp127_ = ma;
			_tmp128_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp127_);
			_tmp129_ = _tmp128_;
			_tmp130_ = vala_symbol_get_full_name (_tmp129_);
			_tmp131_ = _tmp130_;
			_tmp132_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp131_);
			_tmp133_ = _tmp132_;
			vala_report_error (_tmp126_, _tmp133_);
			_g_free0 (_tmp133_);
			_g_free0 (_tmp131_);
			result = FALSE;
			return result;
		}
		_tmp135_ = ma;
		_tmp136_ = vala_code_node_get_error ((ValaCodeNode*) _tmp135_);
		_tmp137_ = _tmp136_;
		if (_tmp137_) {
			_tmp134_ = TRUE;
		} else {
			ValaMemberAccess* _tmp138_;
			ValaSymbol* _tmp139_;
			ValaSymbol* _tmp140_;
			_tmp138_ = ma;
			_tmp139_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp138_);
			_tmp140_ = _tmp139_;
			_tmp134_ = _tmp140_ == NULL;
		}
		if (_tmp134_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp141_ = ma;
		_tmp142_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp141_);
		_tmp143_ = _tmp142_;
		if (VALA_IS_DYNAMIC_PROPERTY (_tmp143_)) {
		} else {
			ValaExpression* _tmp144_;
			ValaExpression* _tmp145_;
			ValaMemberAccess* _tmp146_;
			ValaDataType* _tmp147_;
			ValaDataType* _tmp148_;
			ValaDataType* _tmp149_;
			ValaDataType* _tmp150_;
			ValaExpression* _tmp151_;
			ValaExpression* _tmp152_;
			ValaMemberAccess* _tmp153_;
			ValaDataType* _tmp154_;
			ValaDataType* _tmp155_;
			ValaDataType* _tmp156_;
			ValaDataType* _tmp157_;
			_tmp144_ = vala_assignment_get_right (self);
			_tmp145_ = _tmp144_;
			_tmp146_ = ma;
			_tmp147_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp146_);
			_tmp148_ = _tmp147_;
			_tmp149_ = vala_data_type_copy (_tmp148_);
			_tmp150_ = _tmp149_;
			vala_expression_set_formal_target_type (_tmp145_, _tmp150_);
			_vala_code_node_unref0 (_tmp150_);
			_tmp151_ = vala_assignment_get_right (self);
			_tmp152_ = _tmp151_;
			_tmp153_ = ma;
			_tmp154_ = vala_expression_get_value_type ((ValaExpression*) _tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = vala_data_type_copy (_tmp155_);
			_tmp157_ = _tmp156_;
			vala_expression_set_target_type (_tmp152_, _tmp157_);
			_vala_code_node_unref0 (_tmp157_);
		}
	} else {
		ValaExpression* _tmp158_;
		ValaExpression* _tmp159_;
		_tmp158_ = vala_assignment_get_left (self);
		_tmp159_ = _tmp158_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp159_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp160_;
			ValaExpression* _tmp161_;
			ValaElementAccess* _tmp162_;
			ValaExpression* _tmp163_;
			ValaExpression* _tmp164_;
			ValaElementAccess* _tmp165_;
			ValaExpression* _tmp166_;
			ValaExpression* _tmp167_;
			ValaDataType* _tmp168_;
			ValaDataType* _tmp169_;
			ValaTypeSymbol* _tmp170_;
			ValaTypeSymbol* _tmp171_;
			ValaSemanticAnalyzer* _tmp172_;
			ValaSemanticAnalyzer* _tmp173_;
			ValaDataType* _tmp174_;
			ValaTypeSymbol* _tmp175_;
			ValaTypeSymbol* _tmp176_;
			_tmp160_ = vala_assignment_get_left (self);
			_tmp161_ = _tmp160_;
			ea = G_TYPE_CHECK_INSTANCE_CAST (_tmp161_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
			_tmp162_ = ea;
			_tmp163_ = vala_element_access_get_container (_tmp162_);
			_tmp164_ = _tmp163_;
			vala_assignment_check_constant_assignment (self, VALA_IS_MEMBER_ACCESS (_tmp164_) ? ((ValaMemberAccess*) _tmp164_) : NULL);
			_tmp165_ = ea;
			_tmp166_ = vala_element_access_get_container (_tmp165_);
			_tmp167_ = _tmp166_;
			_tmp168_ = vala_expression_get_value_type (_tmp167_);
			_tmp169_ = _tmp168_;
			_tmp170_ = vala_data_type_get_type_symbol (_tmp169_);
			_tmp171_ = _tmp170_;
			_tmp172_ = vala_code_context_get_analyzer (context);
			_tmp173_ = _tmp172_;
			_tmp174_ = _tmp173_->string_type;
			_tmp175_ = vala_data_type_get_type_symbol (_tmp174_);
			_tmp176_ = _tmp175_;
			if (_tmp171_ == _tmp176_) {
				ValaElementAccess* _tmp177_;
				ValaSourceReference* _tmp178_;
				ValaSourceReference* _tmp179_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp177_ = ea;
				_tmp178_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp177_);
				_tmp179_ = _tmp178_;
				vala_report_error (_tmp179_, "strings are immutable");
				result = FALSE;
				return result;
			} else {
				ValaElementAccess* _tmp180_;
				ValaExpression* _tmp181_;
				ValaExpression* _tmp182_;
				ValaDataType* _tmp183_;
				ValaDataType* _tmp184_;
				ValaSymbol* _tmp185_;
				ValaSymbol* _tmp186_;
				gboolean _tmp187_;
				_tmp180_ = ea;
				_tmp181_ = vala_element_access_get_container (_tmp180_);
				_tmp182_ = _tmp181_;
				_tmp183_ = vala_expression_get_value_type (_tmp182_);
				_tmp184_ = _tmp183_;
				_tmp185_ = vala_data_type_get_member (_tmp184_, "set");
				_tmp186_ = _tmp185_;
				_tmp187_ = VALA_IS_METHOD (_tmp186_);
				_vala_code_node_unref0 (_tmp186_);
				if (_tmp187_) {
					ValaMethodCall* set_call = NULL;
					ValaElementAccess* _tmp188_;
					ValaExpression* _tmp189_;
					ValaExpression* _tmp190_;
					ValaSourceReference* _tmp191_;
					ValaSourceReference* _tmp192_;
					ValaMemberAccess* _tmp193_;
					ValaMemberAccess* _tmp194_;
					ValaSourceReference* _tmp195_;
					ValaSourceReference* _tmp196_;
					ValaMethodCall* _tmp197_;
					ValaMethodCall* _tmp198_;
					ValaMethodCall* _tmp211_;
					ValaExpression* _tmp212_;
					ValaExpression* _tmp213_;
					ValaCodeNode* _tmp214_;
					ValaCodeNode* _tmp215_;
					ValaMethodCall* _tmp216_;
					ValaMethodCall* _tmp217_;
					_tmp188_ = ea;
					_tmp189_ = vala_element_access_get_container (_tmp188_);
					_tmp190_ = _tmp189_;
					_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp192_ = _tmp191_;
					_tmp193_ = vala_member_access_new (_tmp190_, "set", _tmp192_);
					_tmp194_ = _tmp193_;
					_tmp195_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp196_ = _tmp195_;
					_tmp197_ = vala_method_call_new ((ValaExpression*) _tmp194_, _tmp196_);
					_tmp198_ = _tmp197_;
					_vala_code_node_unref0 (_tmp194_);
					set_call = _tmp198_;
					{
						ValaList* _e_list = NULL;
						ValaElementAccess* _tmp199_;
						ValaList* _tmp200_;
						ValaList* _tmp201_;
						gint _e_size = 0;
						ValaList* _tmp202_;
						gint _tmp203_;
						gint _tmp204_;
						gint _e_index = 0;
						_tmp199_ = ea;
						_tmp200_ = vala_element_access_get_indices (_tmp199_);
						_tmp201_ = _vala_iterable_ref0 (_tmp200_);
						_e_list = _tmp201_;
						_tmp202_ = _e_list;
						_tmp203_ = vala_collection_get_size ((ValaCollection*) _tmp202_);
						_tmp204_ = _tmp203_;
						_e_size = _tmp204_;
						_e_index = -1;
						while (TRUE) {
							gint _tmp205_;
							gint _tmp206_;
							ValaExpression* e = NULL;
							ValaList* _tmp207_;
							gpointer _tmp208_;
							ValaMethodCall* _tmp209_;
							ValaExpression* _tmp210_;
							_e_index = _e_index + 1;
							_tmp205_ = _e_index;
							_tmp206_ = _e_size;
							if (!(_tmp205_ < _tmp206_)) {
								break;
							}
							_tmp207_ = _e_list;
							_tmp208_ = vala_list_get (_tmp207_, _e_index);
							e = (ValaExpression*) _tmp208_;
							_tmp209_ = set_call;
							_tmp210_ = e;
							vala_method_call_add_argument (_tmp209_, _tmp210_);
							_vala_code_node_unref0 (e);
						}
						_vala_iterable_unref0 (_e_list);
					}
					_tmp211_ = set_call;
					_tmp212_ = vala_assignment_get_right (self);
					_tmp213_ = _tmp212_;
					vala_method_call_add_argument (_tmp211_, _tmp213_);
					_tmp214_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp215_ = _tmp214_;
					_tmp216_ = set_call;
					vala_code_node_replace_expression (_tmp215_, (ValaExpression*) self, (ValaExpression*) _tmp216_);
					_tmp217_ = set_call;
					result = vala_code_node_check ((ValaCodeNode*) _tmp217_, context);
					_vala_code_node_unref0 (set_call);
					return result;
				} else {
					ValaExpression* _tmp218_;
					ValaExpression* _tmp219_;
					ValaExpression* _tmp220_;
					ValaExpression* _tmp221_;
					ValaDataType* _tmp222_;
					ValaDataType* _tmp223_;
					ValaDataType* _tmp224_;
					ValaDataType* _tmp225_;
					_tmp218_ = vala_assignment_get_right (self);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_assignment_get_left (self);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_expression_get_value_type (_tmp221_);
					_tmp223_ = _tmp222_;
					_tmp224_ = vala_data_type_copy (_tmp223_);
					_tmp225_ = _tmp224_;
					vala_expression_set_target_type (_tmp219_, _tmp225_);
					_vala_code_node_unref0 (_tmp225_);
				}
			}
		} else {
			ValaExpression* _tmp226_;
			ValaExpression* _tmp227_;
			_tmp226_ = vala_assignment_get_left (self);
			_tmp227_ = _tmp226_;
			if (VALA_IS_POINTER_INDIRECTION (_tmp227_)) {
				ValaExpression* _tmp228_;
				ValaExpression* _tmp229_;
				ValaExpression* _tmp230_;
				ValaExpression* _tmp231_;
				ValaDataType* _tmp232_;
				ValaDataType* _tmp233_;
				ValaDataType* _tmp234_;
				ValaDataType* _tmp235_;
				_tmp228_ = vala_assignment_get_right (self);
				_tmp229_ = _tmp228_;
				_tmp230_ = vala_assignment_get_left (self);
				_tmp231_ = _tmp230_;
				_tmp232_ = vala_expression_get_value_type (_tmp231_);
				_tmp233_ = _tmp232_;
				_tmp234_ = vala_data_type_copy (_tmp233_);
				_tmp235_ = _tmp234_;
				vala_expression_set_target_type (_tmp229_, _tmp235_);
				_vala_code_node_unref0 (_tmp235_);
			} else {
				ValaExpression* _tmp236_;
				ValaExpression* _tmp237_;
				_tmp236_ = vala_assignment_get_left (self);
				_tmp237_ = _tmp236_;
				if (VALA_IS_LITERAL (_tmp237_)) {
					ValaSourceReference* _tmp238_;
					ValaSourceReference* _tmp239_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp238_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp239_ = _tmp238_;
					vala_report_error (_tmp239_, "Literals are immutable");
					result = FALSE;
					return result;
				} else {
					ValaSourceReference* _tmp240_;
					ValaSourceReference* _tmp241_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp240_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp241_ = _tmp240_;
					vala_report_error (_tmp241_, "unsupported lvalue in assignment");
					result = FALSE;
					return result;
				}
			}
		}
	}
	_tmp242_ = vala_assignment_get_right (self);
	_tmp243_ = _tmp242_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp243_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp244_ = vala_assignment_get_left (self);
	_tmp245_ = _tmp244_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp245_) ? ((ValaMemberAccess*) _tmp245_) : NULL;
	_tmp248_ = self->priv->_operator;
	if (_tmp248_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		ValaMemberAccess* _tmp249_;
		_tmp249_ = ma;
		_tmp247_ = _tmp249_ != NULL;
	} else {
		_tmp247_ = FALSE;
	}
	if (_tmp247_) {
		gboolean _tmp250_ = FALSE;
		ValaExpression* _tmp251_;
		ValaExpression* _tmp252_;
		ValaDataType* _tmp253_;
		ValaDataType* _tmp254_;
		_tmp251_ = vala_assignment_get_left (self);
		_tmp252_ = _tmp251_;
		_tmp253_ = vala_expression_get_value_type (_tmp252_);
		_tmp254_ = _tmp253_;
		if (vala_data_type_is_non_null_simple_type (_tmp254_)) {
			ValaMemberAccess* _tmp255_;
			ValaSymbol* _tmp256_;
			ValaSymbol* _tmp257_;
			_tmp255_ = ma;
			_tmp256_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp255_);
			_tmp257_ = _tmp256_;
			_tmp250_ = VALA_IS_LOCAL_VARIABLE (_tmp257_);
		} else {
			_tmp250_ = FALSE;
		}
		_tmp246_ = !_tmp250_;
	} else {
		_tmp246_ = FALSE;
	}
	if (_tmp246_) {
		ValaMemberAccess* old_value = NULL;
		ValaMemberAccess* _tmp258_;
		ValaExpression* _tmp259_;
		ValaExpression* _tmp260_;
		ValaMemberAccess* _tmp261_;
		const gchar* _tmp262_;
		const gchar* _tmp263_;
		ValaSourceReference* _tmp264_;
		ValaSourceReference* _tmp265_;
		ValaMemberAccess* _tmp266_;
		ValaBinaryOperator bop = 0;
		ValaAssignmentOperator _tmp267_;
		ValaBinaryExpression* bin = NULL;
		ValaBinaryOperator _tmp270_;
		ValaMemberAccess* _tmp271_;
		ValaExpression* _tmp272_;
		ValaExpression* _tmp273_;
		ValaSourceReference* _tmp274_;
		ValaSourceReference* _tmp275_;
		ValaBinaryExpression* _tmp276_;
		ValaBinaryExpression* _tmp277_;
		ValaExpression* _tmp278_;
		ValaExpression* _tmp279_;
		ValaDataType* _tmp280_;
		ValaDataType* _tmp281_;
		ValaExpression* _tmp282_;
		ValaExpression* _tmp283_;
		ValaExpression* _tmp284_;
		ValaExpression* _tmp285_;
		ValaDataType* _tmp286_;
		ValaDataType* _tmp287_;
		ValaDataType* _tmp288_;
		ValaDataType* _tmp289_;
		ValaExpression* _tmp290_;
		ValaExpression* _tmp291_;
		ValaDataType* _tmp292_;
		ValaDataType* _tmp293_;
		ValaBinaryExpression* _tmp294_;
		ValaExpression* _tmp295_;
		ValaExpression* _tmp296_;
		_tmp258_ = ma;
		_tmp259_ = vala_member_access_get_inner (_tmp258_);
		_tmp260_ = _tmp259_;
		_tmp261_ = ma;
		_tmp262_ = vala_member_access_get_member_name (_tmp261_);
		_tmp263_ = _tmp262_;
		_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp265_ = _tmp264_;
		_tmp266_ = vala_member_access_new (_tmp260_, _tmp263_, _tmp265_);
		old_value = _tmp266_;
		_tmp267_ = self->priv->_operator;
		switch (_tmp267_) {
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_OR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_AND;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_XOR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_ADD:
			{
				bop = VALA_BINARY_OPERATOR_PLUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SUB:
			{
				bop = VALA_BINARY_OPERATOR_MINUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_MUL:
			{
				bop = VALA_BINARY_OPERATOR_MUL;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_DIV:
			{
				bop = VALA_BINARY_OPERATOR_DIV;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_PERCENT:
			{
				bop = VALA_BINARY_OPERATOR_MOD;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_LEFT;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_RIGHT;
				break;
			}
			default:
			{
				ValaSourceReference* _tmp268_;
				ValaSourceReference* _tmp269_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp268_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp269_ = _tmp268_;
				vala_report_error (_tmp269_, "internal error: unsupported assignment operator");
				result = FALSE;
				_vala_code_node_unref0 (old_value);
				return result;
			}
		}
		_tmp270_ = bop;
		_tmp271_ = old_value;
		_tmp272_ = vala_assignment_get_right (self);
		_tmp273_ = _tmp272_;
		_tmp274_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp275_ = _tmp274_;
		_tmp276_ = vala_binary_expression_new (_tmp270_, (ValaExpression*) _tmp271_, _tmp273_, _tmp275_);
		bin = _tmp276_;
		_tmp277_ = bin;
		_tmp278_ = vala_assignment_get_right (self);
		_tmp279_ = _tmp278_;
		_tmp280_ = vala_expression_get_target_type (_tmp279_);
		_tmp281_ = _tmp280_;
		vala_expression_set_target_type ((ValaExpression*) _tmp277_, _tmp281_);
		_tmp282_ = vala_assignment_get_right (self);
		_tmp283_ = _tmp282_;
		_tmp284_ = vala_assignment_get_right (self);
		_tmp285_ = _tmp284_;
		_tmp286_ = vala_expression_get_target_type (_tmp285_);
		_tmp287_ = _tmp286_;
		_tmp288_ = vala_data_type_copy (_tmp287_);
		_tmp289_ = _tmp288_;
		vala_expression_set_target_type (_tmp283_, _tmp289_);
		_vala_code_node_unref0 (_tmp289_);
		_tmp290_ = vala_assignment_get_right (self);
		_tmp291_ = _tmp290_;
		_tmp292_ = vala_expression_get_target_type (_tmp291_);
		_tmp293_ = _tmp292_;
		vala_data_type_set_value_owned (_tmp293_, FALSE);
		_tmp294_ = bin;
		vala_assignment_set_right (self, (ValaExpression*) _tmp294_);
		_tmp295_ = vala_assignment_get_right (self);
		_tmp296_ = _tmp295_;
		vala_code_node_check ((ValaCodeNode*) _tmp296_, context);
		vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
		_vala_code_node_unref0 (bin);
		_vala_code_node_unref0 (old_value);
	}
	_tmp297_ = ma;
	if (_tmp297_ != NULL) {
		ValaMemberAccess* _tmp298_;
		ValaSymbol* _tmp299_;
		ValaSymbol* _tmp300_;
		gboolean _tmp419_ = FALSE;
		ValaExpression* _tmp420_;
		ValaExpression* _tmp421_;
		ValaDataType* _tmp422_;
		ValaDataType* _tmp423_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp478_;
		ValaExpression* _tmp479_;
		gboolean _tmp480_ = FALSE;
		ValaMemberAccess* _tmp481_;
		_tmp298_ = ma;
		_tmp299_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp298_);
		_tmp300_ = _tmp299_;
		if (VALA_IS_PROPERTY (_tmp300_)) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp301_;
			ValaSymbol* _tmp302_;
			ValaSymbol* _tmp303_;
			ValaDynamicProperty* dynamic_prop = NULL;
			ValaProperty* _tmp304_;
			ValaDynamicProperty* _tmp305_;
			_tmp301_ = ma;
			_tmp302_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp301_);
			_tmp303_ = _tmp302_;
			prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp303_, VALA_TYPE_PROPERTY, ValaProperty);
			_tmp304_ = prop;
			dynamic_prop = VALA_IS_DYNAMIC_PROPERTY (_tmp304_) ? ((ValaDynamicProperty*) _tmp304_) : NULL;
			_tmp305_ = dynamic_prop;
			if (_tmp305_ != NULL) {
				ValaDynamicProperty* _tmp306_;
				ValaExpression* _tmp307_;
				ValaExpression* _tmp308_;
				ValaDataType* _tmp309_;
				ValaDataType* _tmp310_;
				ValaDataType* _tmp311_;
				ValaDataType* _tmp312_;
				ValaExpression* _tmp313_;
				ValaExpression* _tmp314_;
				ValaDynamicProperty* _tmp315_;
				ValaDataType* _tmp316_;
				ValaDataType* _tmp317_;
				ValaDataType* _tmp318_;
				ValaDataType* _tmp319_;
				_tmp306_ = dynamic_prop;
				_tmp307_ = vala_assignment_get_right (self);
				_tmp308_ = _tmp307_;
				_tmp309_ = vala_expression_get_value_type (_tmp308_);
				_tmp310_ = _tmp309_;
				_tmp311_ = vala_data_type_copy (_tmp310_);
				_tmp312_ = _tmp311_;
				vala_property_set_property_type ((ValaProperty*) _tmp306_, _tmp312_);
				_vala_code_node_unref0 (_tmp312_);
				_tmp313_ = vala_assignment_get_left (self);
				_tmp314_ = _tmp313_;
				_tmp315_ = dynamic_prop;
				_tmp316_ = vala_property_get_property_type ((ValaProperty*) _tmp315_);
				_tmp317_ = _tmp316_;
				_tmp318_ = vala_data_type_copy (_tmp317_);
				_tmp319_ = _tmp318_;
				vala_expression_set_value_type (_tmp314_, _tmp319_);
				_vala_code_node_unref0 (_tmp319_);
			}
		} else {
			gboolean _tmp320_ = FALSE;
			ValaMemberAccess* _tmp321_;
			ValaSymbol* _tmp322_;
			ValaSymbol* _tmp323_;
			_tmp321_ = ma;
			_tmp322_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp321_);
			_tmp323_ = _tmp322_;
			if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp323_)) {
				ValaMemberAccess* _tmp324_;
				ValaExpression* _tmp325_;
				ValaExpression* _tmp326_;
				ValaDataType* _tmp327_;
				ValaDataType* _tmp328_;
				gboolean _tmp329_;
				gboolean _tmp330_;
				_tmp324_ = ma;
				_tmp325_ = vala_member_access_get_inner (_tmp324_);
				_tmp326_ = _tmp325_;
				_tmp327_ = vala_expression_get_value_type (_tmp326_);
				_tmp328_ = _tmp327_;
				_tmp329_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp328_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp330_ = _tmp329_;
				_tmp320_ = _tmp330_;
			} else {
				_tmp320_ = FALSE;
			}
			if (_tmp320_) {
				ValaSourceReference* _tmp331_;
				ValaSourceReference* _tmp332_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp331_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp332_ = _tmp331_;
				vala_report_error (_tmp332_, "`length' field of fixed length arrays is read-only");
				result = FALSE;
				return result;
			} else {
				gboolean _tmp333_ = FALSE;
				ValaMemberAccess* _tmp334_;
				ValaSymbol* _tmp335_;
				ValaSymbol* _tmp336_;
				_tmp334_ = ma;
				_tmp335_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp334_);
				_tmp336_ = _tmp335_;
				if (VALA_IS_VARIABLE (_tmp336_)) {
					ValaExpression* _tmp337_;
					ValaExpression* _tmp338_;
					ValaDataType* _tmp339_;
					ValaDataType* _tmp340_;
					_tmp337_ = vala_assignment_get_right (self);
					_tmp338_ = _tmp337_;
					_tmp339_ = vala_expression_get_value_type (_tmp338_);
					_tmp340_ = _tmp339_;
					_tmp333_ = VALA_IS_METHOD_TYPE (_tmp340_);
				} else {
					_tmp333_ = FALSE;
				}
				if (_tmp333_) {
					ValaVariable* variable = NULL;
					ValaMemberAccess* _tmp341_;
					ValaSymbol* _tmp342_;
					ValaSymbol* _tmp343_;
					ValaVariable* _tmp344_;
					ValaDataType* _tmp345_;
					ValaDataType* _tmp346_;
					_tmp341_ = ma;
					_tmp342_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp341_);
					_tmp343_ = _tmp342_;
					variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp343_, VALA_TYPE_VARIABLE, ValaVariable);
					_tmp344_ = variable;
					_tmp345_ = vala_variable_get_variable_type (_tmp344_);
					_tmp346_ = _tmp345_;
					if (VALA_IS_DELEGATE_TYPE (_tmp346_)) {
						ValaExpression* _tmp347_;
						ValaExpression* _tmp348_;
						ValaDataType* _tmp349_;
						ValaDataType* _tmp350_;
						ValaVariable* _tmp351_;
						ValaDataType* _tmp352_;
						ValaDataType* _tmp353_;
						_tmp347_ = vala_assignment_get_right (self);
						_tmp348_ = _tmp347_;
						_tmp349_ = vala_expression_get_value_type (_tmp348_);
						_tmp350_ = _tmp349_;
						_tmp351_ = variable;
						_tmp352_ = vala_variable_get_variable_type (_tmp351_);
						_tmp353_ = _tmp352_;
						if (!vala_data_type_compatible (_tmp350_, _tmp353_)) {
							ValaMethod* m = NULL;
							ValaExpression* _tmp354_;
							ValaExpression* _tmp355_;
							ValaSymbol* _tmp356_;
							ValaSymbol* _tmp357_;
							ValaDelegate* cb = NULL;
							ValaVariable* _tmp358_;
							ValaDataType* _tmp359_;
							ValaDataType* _tmp360_;
							ValaDelegate* _tmp361_;
							ValaDelegate* _tmp362_;
							ValaSourceReference* _tmp363_;
							ValaSourceReference* _tmp364_;
							ValaMethod* _tmp365_;
							gchar* _tmp366_;
							gchar* _tmp367_;
							ValaDelegate* _tmp368_;
							gchar* _tmp369_;
							gchar* _tmp370_;
							gchar* _tmp371_;
							gchar* _tmp372_;
							_tmp354_ = vala_assignment_get_right (self);
							_tmp355_ = _tmp354_;
							_tmp356_ = vala_expression_get_symbol_reference (_tmp355_);
							_tmp357_ = _tmp356_;
							m = G_TYPE_CHECK_INSTANCE_CAST (_tmp357_, VALA_TYPE_METHOD, ValaMethod);
							_tmp358_ = variable;
							_tmp359_ = vala_variable_get_variable_type (_tmp358_);
							_tmp360_ = _tmp359_;
							_tmp361_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp360_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							_tmp362_ = _tmp361_;
							cb = _tmp362_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp363_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp364_ = _tmp363_;
							_tmp365_ = m;
							_tmp366_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp365_);
							_tmp367_ = _tmp366_;
							_tmp368_ = cb;
							_tmp369_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp368_);
							_tmp370_ = _tmp369_;
							_tmp371_ = g_strdup_printf ("Declaration of method `%s' is not compatible with delegate `%s'", _tmp367_, _tmp370_);
							_tmp372_ = _tmp371_;
							vala_report_error (_tmp364_, _tmp372_);
							_g_free0 (_tmp372_);
							_g_free0 (_tmp370_);
							_g_free0 (_tmp367_);
							result = FALSE;
							return result;
						}
					} else {
						ValaSourceReference* _tmp373_;
						ValaSourceReference* _tmp374_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp373_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp374_ = _tmp373_;
						vala_report_error (_tmp374_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						return result;
					}
				} else {
					gboolean _tmp375_ = FALSE;
					ValaMemberAccess* _tmp376_;
					ValaSymbol* _tmp377_;
					ValaSymbol* _tmp378_;
					_tmp376_ = ma;
					_tmp377_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp376_);
					_tmp378_ = _tmp377_;
					if (VALA_IS_VARIABLE (_tmp378_)) {
						ValaExpression* _tmp379_;
						ValaExpression* _tmp380_;
						ValaDataType* _tmp381_;
						ValaDataType* _tmp382_;
						_tmp379_ = vala_assignment_get_right (self);
						_tmp380_ = _tmp379_;
						_tmp381_ = vala_expression_get_value_type (_tmp380_);
						_tmp382_ = _tmp381_;
						_tmp375_ = _tmp382_ == NULL;
					} else {
						_tmp375_ = FALSE;
					}
					if (_tmp375_) {
						ValaSourceReference* _tmp383_;
						ValaSourceReference* _tmp384_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp383_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp384_ = _tmp383_;
						vala_report_error (_tmp384_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						return result;
					} else {
						ValaMemberAccess* _tmp385_;
						ValaSymbol* _tmp386_;
						ValaSymbol* _tmp387_;
						_tmp385_ = ma;
						_tmp386_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp385_);
						_tmp387_ = _tmp386_;
						if (VALA_IS_VARIABLE (_tmp387_)) {
							ValaVariable* variable = NULL;
							ValaMemberAccess* _tmp388_;
							ValaSymbol* _tmp389_;
							ValaSymbol* _tmp390_;
							ValaArrayType* variable_array_type = NULL;
							ValaVariable* _tmp391_;
							ValaDataType* _tmp392_;
							ValaDataType* _tmp393_;
							gboolean _tmp394_ = FALSE;
							gboolean _tmp395_ = FALSE;
							gboolean _tmp396_ = FALSE;
							ValaArrayType* _tmp397_;
							_tmp388_ = ma;
							_tmp389_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp388_);
							_tmp390_ = _tmp389_;
							variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp390_, VALA_TYPE_VARIABLE, ValaVariable);
							_tmp391_ = variable;
							_tmp392_ = vala_variable_get_variable_type (_tmp391_);
							_tmp393_ = _tmp392_;
							variable_array_type = VALA_IS_ARRAY_TYPE (_tmp393_) ? ((ValaArrayType*) _tmp393_) : NULL;
							_tmp397_ = variable_array_type;
							if (_tmp397_ != NULL) {
								ValaArrayType* _tmp398_;
								gboolean _tmp399_;
								gboolean _tmp400_;
								_tmp398_ = variable_array_type;
								_tmp399_ = vala_array_type_get_inline_allocated (_tmp398_);
								_tmp400_ = _tmp399_;
								_tmp396_ = _tmp400_;
							} else {
								_tmp396_ = FALSE;
							}
							if (_tmp396_) {
								ValaExpression* _tmp401_;
								ValaExpression* _tmp402_;
								_tmp401_ = vala_assignment_get_right (self);
								_tmp402_ = _tmp401_;
								_tmp395_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp402_);
							} else {
								_tmp395_ = FALSE;
							}
							if (_tmp395_) {
								ValaExpression* _tmp403_;
								ValaExpression* _tmp404_;
								ValaInitializerList* _tmp405_;
								ValaInitializerList* _tmp406_;
								_tmp403_ = vala_assignment_get_right (self);
								_tmp404_ = _tmp403_;
								_tmp405_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp404_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
								_tmp406_ = _tmp405_;
								_tmp394_ = _tmp406_ == NULL;
							} else {
								_tmp394_ = FALSE;
							}
							if (_tmp394_) {
								ValaSourceReference* _tmp407_;
								ValaSourceReference* _tmp408_;
								ValaCodeNode* _tmp409_;
								ValaCodeNode* _tmp410_;
								ValaCodeNode* _tmp411_;
								ValaCodeNode* _tmp412_;
								ValaCodeNode* _tmp413_;
								ValaCodeNode* _tmp414_;
								ValaSourceReference* _tmp415_;
								ValaSourceReference* _tmp416_;
								ValaEmptyStatement* _tmp417_;
								ValaEmptyStatement* _tmp418_;
								_tmp407_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp408_ = _tmp407_;
								vala_report_warning (_tmp408_, "Inline allocated arrays don't require an explicit instantiation");
								_tmp409_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp410_ = _tmp409_;
								_tmp411_ = vala_code_node_get_parent_node (_tmp410_);
								_tmp412_ = _tmp411_;
								_tmp413_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp414_ = _tmp413_;
								_tmp415_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp416_ = _tmp415_;
								_tmp417_ = vala_empty_statement_new (_tmp416_);
								_tmp418_ = _tmp417_;
								vala_block_replace_statement (G_TYPE_CHECK_INSTANCE_CAST (_tmp412_, VALA_TYPE_BLOCK, ValaBlock), G_TYPE_CHECK_INSTANCE_CAST (_tmp414_, VALA_TYPE_STATEMENT, ValaStatement), (ValaStatement*) _tmp418_);
								_vala_code_node_unref0 (_tmp418_);
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
		_tmp420_ = vala_assignment_get_left (self);
		_tmp421_ = _tmp420_;
		_tmp422_ = vala_expression_get_value_type (_tmp421_);
		_tmp423_ = _tmp422_;
		if (_tmp423_ != NULL) {
			ValaExpression* _tmp424_;
			ValaExpression* _tmp425_;
			ValaDataType* _tmp426_;
			ValaDataType* _tmp427_;
			_tmp424_ = vala_assignment_get_right (self);
			_tmp425_ = _tmp424_;
			_tmp426_ = vala_expression_get_value_type (_tmp425_);
			_tmp427_ = _tmp426_;
			_tmp419_ = _tmp427_ != NULL;
		} else {
			_tmp419_ = FALSE;
		}
		if (_tmp419_) {
			ValaExpression* _tmp428_;
			ValaExpression* _tmp429_;
			ValaDataType* _tmp430_;
			ValaDataType* _tmp431_;
			ValaExpression* _tmp432_;
			ValaExpression* _tmp433_;
			ValaDataType* _tmp434_;
			ValaDataType* _tmp435_;
			ValaMemberAccess* _tmp452_;
			ValaSymbol* _tmp453_;
			ValaSymbol* _tmp454_;
			_tmp428_ = vala_assignment_get_right (self);
			_tmp429_ = _tmp428_;
			_tmp430_ = vala_expression_get_value_type (_tmp429_);
			_tmp431_ = _tmp430_;
			_tmp432_ = vala_assignment_get_left (self);
			_tmp433_ = _tmp432_;
			_tmp434_ = vala_expression_get_value_type (_tmp433_);
			_tmp435_ = _tmp434_;
			if (!vala_data_type_compatible (_tmp431_, _tmp435_)) {
				ValaSourceReference* _tmp436_;
				ValaSourceReference* _tmp437_;
				ValaExpression* _tmp438_;
				ValaExpression* _tmp439_;
				ValaDataType* _tmp440_;
				ValaDataType* _tmp441_;
				gchar* _tmp442_;
				gchar* _tmp443_;
				ValaExpression* _tmp444_;
				ValaExpression* _tmp445_;
				ValaDataType* _tmp446_;
				ValaDataType* _tmp447_;
				gchar* _tmp448_;
				gchar* _tmp449_;
				gchar* _tmp450_;
				gchar* _tmp451_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp436_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp437_ = _tmp436_;
				_tmp438_ = vala_assignment_get_right (self);
				_tmp439_ = _tmp438_;
				_tmp440_ = vala_expression_get_value_type (_tmp439_);
				_tmp441_ = _tmp440_;
				_tmp442_ = vala_code_node_to_string ((ValaCodeNode*) _tmp441_);
				_tmp443_ = _tmp442_;
				_tmp444_ = vala_assignment_get_left (self);
				_tmp445_ = _tmp444_;
				_tmp446_ = vala_expression_get_value_type (_tmp445_);
				_tmp447_ = _tmp446_;
				_tmp448_ = vala_code_node_to_string ((ValaCodeNode*) _tmp447_);
				_tmp449_ = _tmp448_;
				_tmp450_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp443_, _tmp449_);
				_tmp451_ = _tmp450_;
				vala_report_error (_tmp437_, _tmp451_);
				_g_free0 (_tmp451_);
				_g_free0 (_tmp449_);
				_g_free0 (_tmp443_);
				result = FALSE;
				return result;
			}
			_tmp452_ = ma;
			_tmp453_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp452_);
			_tmp454_ = _tmp453_;
			if (!VALA_IS_PROPERTY (_tmp454_)) {
				ValaExpression* _tmp455_;
				ValaExpression* _tmp456_;
				ValaDataType* _tmp457_;
				ValaDataType* _tmp458_;
				_tmp455_ = vala_assignment_get_right (self);
				_tmp456_ = _tmp455_;
				_tmp457_ = vala_expression_get_value_type (_tmp456_);
				_tmp458_ = _tmp457_;
				if (vala_data_type_is_disposable (_tmp458_)) {
					gboolean _tmp459_ = FALSE;
					ValaExpression* _tmp460_;
					ValaExpression* _tmp461_;
					ValaDataType* _tmp462_;
					ValaDataType* _tmp463_;
					_tmp460_ = vala_assignment_get_left (self);
					_tmp461_ = _tmp460_;
					_tmp462_ = vala_expression_get_value_type (_tmp461_);
					_tmp463_ = _tmp462_;
					if (!VALA_IS_POINTER_TYPE (_tmp463_)) {
						ValaExpression* _tmp464_;
						ValaExpression* _tmp465_;
						ValaDataType* _tmp466_;
						ValaDataType* _tmp467_;
						gboolean _tmp468_;
						gboolean _tmp469_;
						_tmp464_ = vala_assignment_get_left (self);
						_tmp465_ = _tmp464_;
						_tmp466_ = vala_expression_get_value_type (_tmp465_);
						_tmp467_ = _tmp466_;
						_tmp468_ = vala_data_type_get_value_owned (_tmp467_);
						_tmp469_ = _tmp468_;
						_tmp459_ = !_tmp469_;
					} else {
						_tmp459_ = FALSE;
					}
					if (_tmp459_) {
						ValaSourceReference* _tmp470_;
						ValaSourceReference* _tmp471_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp470_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp471_ = _tmp470_;
						vala_report_error (_tmp471_, "Invalid assignment from owned expression to unowned variable");
					}
				} else {
					ValaExpression* _tmp472_;
					ValaExpression* _tmp473_;
					ValaDataType* _tmp474_;
					ValaDataType* _tmp475_;
					gboolean _tmp476_;
					gboolean _tmp477_;
					_tmp472_ = vala_assignment_get_left (self);
					_tmp473_ = _tmp472_;
					_tmp474_ = vala_expression_get_value_type (_tmp473_);
					_tmp475_ = _tmp474_;
					_tmp476_ = vala_data_type_get_value_owned (_tmp475_);
					_tmp477_ = _tmp476_;
					if (_tmp477_) {
					}
				}
			}
		}
		_tmp478_ = vala_assignment_get_right (self);
		_tmp479_ = _tmp478_;
		right_ma = VALA_IS_MEMBER_ACCESS (_tmp479_) ? ((ValaMemberAccess*) _tmp479_) : NULL;
		_tmp481_ = right_ma;
		if (_tmp481_ != NULL) {
			ValaMemberAccess* _tmp482_;
			ValaSymbol* _tmp483_;
			ValaSymbol* _tmp484_;
			ValaMemberAccess* _tmp485_;
			ValaSymbol* _tmp486_;
			ValaSymbol* _tmp487_;
			_tmp482_ = ma;
			_tmp483_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp482_);
			_tmp484_ = _tmp483_;
			_tmp485_ = right_ma;
			_tmp486_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp485_);
			_tmp487_ = _tmp486_;
			_tmp480_ = _tmp484_ == _tmp487_;
		} else {
			_tmp480_ = FALSE;
		}
		if (_tmp480_) {
			gboolean _tmp488_ = FALSE;
			ValaMemberAccess* _tmp489_;
			ValaSymbol* _tmp490_;
			ValaSymbol* _tmp491_;
			_tmp489_ = ma;
			_tmp490_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp489_);
			_tmp491_ = _tmp490_;
			if (VALA_IS_LOCAL_VARIABLE (_tmp491_)) {
				_tmp488_ = TRUE;
			} else {
				ValaMemberAccess* _tmp492_;
				ValaSymbol* _tmp493_;
				ValaSymbol* _tmp494_;
				_tmp492_ = ma;
				_tmp493_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp492_);
				_tmp494_ = _tmp493_;
				_tmp488_ = VALA_IS_PARAMETER (_tmp494_);
			}
			if (_tmp488_) {
				ValaSourceReference* _tmp495_;
				ValaSourceReference* _tmp496_;
				_tmp495_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp496_ = _tmp495_;
				vala_report_warning (_tmp496_, "Assignment to same variable");
			} else {
				ValaMemberAccess* _tmp497_;
				ValaSymbol* _tmp498_;
				ValaSymbol* _tmp499_;
				_tmp497_ = ma;
				_tmp498_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp497_);
				_tmp499_ = _tmp498_;
				if (VALA_IS_FIELD (_tmp499_)) {
					ValaField* f = NULL;
					ValaMemberAccess* _tmp500_;
					ValaSymbol* _tmp501_;
					ValaSymbol* _tmp502_;
					ValaField* _tmp503_;
					ValaMemberBinding _tmp504_;
					ValaMemberBinding _tmp505_;
					_tmp500_ = ma;
					_tmp501_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp500_);
					_tmp502_ = _tmp501_;
					f = G_TYPE_CHECK_INSTANCE_CAST (_tmp502_, VALA_TYPE_FIELD, ValaField);
					_tmp503_ = f;
					_tmp504_ = vala_field_get_binding (_tmp503_);
					_tmp505_ = _tmp504_;
					if (_tmp505_ == VALA_MEMBER_BINDING_STATIC) {
						ValaSourceReference* _tmp506_;
						ValaSourceReference* _tmp507_;
						_tmp506_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp507_ = _tmp506_;
						vala_report_warning (_tmp507_, "Assignment to same variable");
					} else {
						ValaMemberAccess* ma_inner = NULL;
						ValaMemberAccess* _tmp508_;
						ValaExpression* _tmp509_;
						ValaExpression* _tmp510_;
						ValaMemberAccess* right_ma_inner = NULL;
						ValaMemberAccess* _tmp511_;
						ValaExpression* _tmp512_;
						ValaExpression* _tmp513_;
						gboolean _tmp514_ = FALSE;
						gboolean _tmp515_ = FALSE;
						gboolean _tmp516_ = FALSE;
						gboolean _tmp517_ = FALSE;
						gboolean _tmp518_ = FALSE;
						ValaMemberAccess* _tmp519_;
						_tmp508_ = ma;
						_tmp509_ = vala_member_access_get_inner (_tmp508_);
						_tmp510_ = _tmp509_;
						ma_inner = VALA_IS_MEMBER_ACCESS (_tmp510_) ? ((ValaMemberAccess*) _tmp510_) : NULL;
						_tmp511_ = right_ma;
						_tmp512_ = vala_member_access_get_inner (_tmp511_);
						_tmp513_ = _tmp512_;
						right_ma_inner = VALA_IS_MEMBER_ACCESS (_tmp513_) ? ((ValaMemberAccess*) _tmp513_) : NULL;
						_tmp519_ = ma_inner;
						if (_tmp519_ != NULL) {
							ValaMemberAccess* _tmp520_;
							const gchar* _tmp521_;
							const gchar* _tmp522_;
							_tmp520_ = ma_inner;
							_tmp521_ = vala_member_access_get_member_name (_tmp520_);
							_tmp522_ = _tmp521_;
							_tmp518_ = g_strcmp0 (_tmp522_, "this") == 0;
						} else {
							_tmp518_ = FALSE;
						}
						if (_tmp518_) {
							ValaMemberAccess* _tmp523_;
							ValaExpression* _tmp524_;
							ValaExpression* _tmp525_;
							_tmp523_ = ma_inner;
							_tmp524_ = vala_member_access_get_inner (_tmp523_);
							_tmp525_ = _tmp524_;
							_tmp517_ = _tmp525_ == NULL;
						} else {
							_tmp517_ = FALSE;
						}
						if (_tmp517_) {
							ValaMemberAccess* _tmp526_;
							_tmp526_ = right_ma_inner;
							_tmp516_ = _tmp526_ != NULL;
						} else {
							_tmp516_ = FALSE;
						}
						if (_tmp516_) {
							ValaMemberAccess* _tmp527_;
							const gchar* _tmp528_;
							const gchar* _tmp529_;
							_tmp527_ = right_ma_inner;
							_tmp528_ = vala_member_access_get_member_name (_tmp527_);
							_tmp529_ = _tmp528_;
							_tmp515_ = g_strcmp0 (_tmp529_, "this") == 0;
						} else {
							_tmp515_ = FALSE;
						}
						if (_tmp515_) {
							ValaMemberAccess* _tmp530_;
							ValaExpression* _tmp531_;
							ValaExpression* _tmp532_;
							_tmp530_ = right_ma_inner;
							_tmp531_ = vala_member_access_get_inner (_tmp530_);
							_tmp532_ = _tmp531_;
							_tmp514_ = _tmp532_ == NULL;
						} else {
							_tmp514_ = FALSE;
						}
						if (_tmp514_) {
							ValaSourceReference* _tmp533_;
							ValaSourceReference* _tmp534_;
							_tmp533_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp534_ = _tmp533_;
							vala_report_warning (_tmp534_, "Assignment to same variable");
						}
					}
				}
			}
		}
	} else {
		ValaExpression* _tmp535_;
		ValaExpression* _tmp536_;
		_tmp535_ = vala_assignment_get_left (self);
		_tmp536_ = _tmp535_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp536_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp537_;
			ValaExpression* _tmp538_;
			ValaExpression* _tmp539_;
			ValaExpression* _tmp540_;
			ValaDataType* _tmp541_;
			ValaDataType* _tmp542_;
			ValaExpression* _tmp543_;
			ValaExpression* _tmp544_;
			ValaDataType* _tmp545_;
			ValaDataType* _tmp546_;
			ValaExpression* _tmp563_;
			ValaExpression* _tmp564_;
			ValaDataType* _tmp565_;
			ValaDataType* _tmp566_;
			_tmp537_ = vala_assignment_get_left (self);
			_tmp538_ = _tmp537_;
			ea = G_TYPE_CHECK_INSTANCE_CAST (_tmp538_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
			_tmp539_ = vala_assignment_get_right (self);
			_tmp540_ = _tmp539_;
			_tmp541_ = vala_expression_get_value_type (_tmp540_);
			_tmp542_ = _tmp541_;
			_tmp543_ = vala_assignment_get_left (self);
			_tmp544_ = _tmp543_;
			_tmp545_ = vala_expression_get_value_type (_tmp544_);
			_tmp546_ = _tmp545_;
			if (!vala_data_type_compatible (_tmp542_, _tmp546_)) {
				ValaSourceReference* _tmp547_;
				ValaSourceReference* _tmp548_;
				ValaExpression* _tmp549_;
				ValaExpression* _tmp550_;
				ValaDataType* _tmp551_;
				ValaDataType* _tmp552_;
				gchar* _tmp553_;
				gchar* _tmp554_;
				ValaExpression* _tmp555_;
				ValaExpression* _tmp556_;
				ValaDataType* _tmp557_;
				ValaDataType* _tmp558_;
				gchar* _tmp559_;
				gchar* _tmp560_;
				gchar* _tmp561_;
				gchar* _tmp562_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp547_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp548_ = _tmp547_;
				_tmp549_ = vala_assignment_get_right (self);
				_tmp550_ = _tmp549_;
				_tmp551_ = vala_expression_get_value_type (_tmp550_);
				_tmp552_ = _tmp551_;
				_tmp553_ = vala_code_node_to_string ((ValaCodeNode*) _tmp552_);
				_tmp554_ = _tmp553_;
				_tmp555_ = vala_assignment_get_left (self);
				_tmp556_ = _tmp555_;
				_tmp557_ = vala_expression_get_value_type (_tmp556_);
				_tmp558_ = _tmp557_;
				_tmp559_ = vala_code_node_to_string ((ValaCodeNode*) _tmp558_);
				_tmp560_ = _tmp559_;
				_tmp561_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp554_, _tmp560_);
				_tmp562_ = _tmp561_;
				vala_report_error (_tmp548_, _tmp562_);
				_g_free0 (_tmp562_);
				_g_free0 (_tmp560_);
				_g_free0 (_tmp554_);
				result = FALSE;
				return result;
			}
			_tmp563_ = vala_assignment_get_right (self);
			_tmp564_ = _tmp563_;
			_tmp565_ = vala_expression_get_value_type (_tmp564_);
			_tmp566_ = _tmp565_;
			if (vala_data_type_is_disposable (_tmp566_)) {
				ValaDataType* element_type = NULL;
				ValaElementAccess* _tmp567_;
				ValaExpression* _tmp568_;
				ValaExpression* _tmp569_;
				ValaDataType* _tmp570_;
				ValaDataType* _tmp571_;
				gboolean _tmp593_ = FALSE;
				ValaDataType* _tmp594_;
				_tmp567_ = ea;
				_tmp568_ = vala_element_access_get_container (_tmp567_);
				_tmp569_ = _tmp568_;
				_tmp570_ = vala_expression_get_value_type (_tmp569_);
				_tmp571_ = _tmp570_;
				if (VALA_IS_ARRAY_TYPE (_tmp571_)) {
					ValaArrayType* array_type = NULL;
					ValaElementAccess* _tmp572_;
					ValaExpression* _tmp573_;
					ValaExpression* _tmp574_;
					ValaDataType* _tmp575_;
					ValaDataType* _tmp576_;
					ValaArrayType* _tmp577_;
					ValaDataType* _tmp578_;
					ValaDataType* _tmp579_;
					ValaDataType* _tmp580_;
					_tmp572_ = ea;
					_tmp573_ = vala_element_access_get_container (_tmp572_);
					_tmp574_ = _tmp573_;
					_tmp575_ = vala_expression_get_value_type (_tmp574_);
					_tmp576_ = _tmp575_;
					array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp576_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
					_tmp577_ = array_type;
					_tmp578_ = vala_array_type_get_element_type (_tmp577_);
					_tmp579_ = _tmp578_;
					_tmp580_ = _vala_code_node_ref0 (_tmp579_);
					_vala_code_node_unref0 (element_type);
					element_type = _tmp580_;
				} else {
					ValaList* args = NULL;
					ValaElementAccess* _tmp581_;
					ValaExpression* _tmp582_;
					ValaExpression* _tmp583_;
					ValaDataType* _tmp584_;
					ValaDataType* _tmp585_;
					ValaList* _tmp586_;
					ValaList* _tmp587_;
					ValaList* _tmp588_;
					gint _tmp589_;
					gint _tmp590_;
					ValaList* _tmp591_;
					gpointer _tmp592_;
					_tmp581_ = ea;
					_tmp582_ = vala_element_access_get_container (_tmp581_);
					_tmp583_ = _tmp582_;
					_tmp584_ = vala_expression_get_value_type (_tmp583_);
					_tmp585_ = _tmp584_;
					_tmp586_ = vala_data_type_get_type_arguments (_tmp585_);
					_tmp587_ = _vala_iterable_ref0 (_tmp586_);
					args = _tmp587_;
					_tmp588_ = args;
					_tmp589_ = vala_collection_get_size ((ValaCollection*) _tmp588_);
					_tmp590_ = _tmp589_;
					_vala_assert (_tmp590_ == 1, "args.size == 1");
					_tmp591_ = args;
					_tmp592_ = vala_list_get (_tmp591_, 0);
					_vala_code_node_unref0 (element_type);
					element_type = (ValaDataType*) _tmp592_;
					_vala_iterable_unref0 (args);
				}
				_tmp594_ = element_type;
				if (!VALA_IS_POINTER_TYPE (_tmp594_)) {
					ValaDataType* _tmp595_;
					gboolean _tmp596_;
					gboolean _tmp597_;
					_tmp595_ = element_type;
					_tmp596_ = vala_data_type_get_value_owned (_tmp595_);
					_tmp597_ = _tmp596_;
					_tmp593_ = !_tmp597_;
				} else {
					_tmp593_ = FALSE;
				}
				if (_tmp593_) {
					ValaSourceReference* _tmp598_;
					ValaSourceReference* _tmp599_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp598_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp599_ = _tmp598_;
					vala_report_error (_tmp599_, "Invalid assignment from owned expression to unowned variable");
					result = FALSE;
					_vala_code_node_unref0 (element_type);
					return result;
				}
				_vala_code_node_unref0 (element_type);
			} else {
				ValaExpression* _tmp600_;
				ValaExpression* _tmp601_;
				ValaDataType* _tmp602_;
				ValaDataType* _tmp603_;
				gboolean _tmp604_;
				gboolean _tmp605_;
				_tmp600_ = vala_assignment_get_left (self);
				_tmp601_ = _tmp600_;
				_tmp602_ = vala_expression_get_value_type (_tmp601_);
				_tmp603_ = _tmp602_;
				_tmp604_ = vala_data_type_get_value_owned (_tmp603_);
				_tmp605_ = _tmp604_;
				if (_tmp605_) {
				}
			}
		} else {
			result = TRUE;
			return result;
		}
	}
	_tmp606_ = vala_assignment_get_left (self);
	_tmp607_ = _tmp606_;
	_tmp608_ = vala_expression_get_value_type (_tmp607_);
	_tmp609_ = _tmp608_;
	if (_tmp609_ != NULL) {
		ValaExpression* _tmp610_;
		ValaExpression* _tmp611_;
		ValaDataType* _tmp612_;
		ValaDataType* _tmp613_;
		ValaDataType* _tmp614_;
		ValaDataType* _tmp615_;
		ValaDataType* _tmp616_;
		ValaDataType* _tmp617_;
		_tmp610_ = vala_assignment_get_left (self);
		_tmp611_ = _tmp610_;
		_tmp612_ = vala_expression_get_value_type (_tmp611_);
		_tmp613_ = _tmp612_;
		_tmp614_ = vala_data_type_copy (_tmp613_);
		_tmp615_ = _tmp614_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp615_);
		_vala_code_node_unref0 (_tmp615_);
		_tmp616_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp617_ = _tmp616_;
		vala_data_type_set_value_owned (_tmp617_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp618_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp619_ = _tmp618_;
	if (_tmp619_ != NULL) {
		ValaDataType* _tmp620_;
		ValaDataType* _tmp621_;
		_tmp620_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp621_ = _tmp620_;
		vala_code_node_check ((ValaCodeNode*) _tmp621_, context);
	}
	_tmp622_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp623_ = _tmp622_;
	result = !_tmp623_;
	return result;
}

static gboolean
vala_assignment_is_array_add (ValaAssignment* self)
{
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaBinaryExpression* _tmp3_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	binary = VALA_IS_BINARY_EXPRESSION (_tmp1_) ? ((ValaBinaryExpression*) _tmp1_) : NULL;
	_tmp3_ = binary;
	if (_tmp3_ != NULL) {
		ValaBinaryExpression* _tmp4_;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		_tmp4_ = binary;
		_tmp5_ = vala_binary_expression_get_left (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_expression_get_value_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = VALA_IS_ARRAY_TYPE (_tmp8_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaBinaryExpression* _tmp9_;
		ValaBinaryOperator _tmp10_;
		ValaBinaryOperator _tmp11_;
		_tmp9_ = binary;
		_tmp10_ = vala_binary_expression_get_operator (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaBinaryExpression* _tmp16_;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			_tmp12_ = vala_assignment_get_left (self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_expression_get_symbol_reference (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = binary;
			_tmp17_ = vala_binary_expression_get_left (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_expression_get_symbol_reference (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp15_ == _tmp20_) {
				ValaBinaryExpression* _tmp21_;
				ValaExpression* _tmp22_;
				ValaExpression* _tmp23_;
				_tmp21_ = binary;
				_tmp22_ = vala_binary_expression_get_left (_tmp21_);
				_tmp23_ = _tmp22_;
				vala_expression_set_lvalue (_tmp23_, TRUE);
				result = TRUE;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static void
vala_assignment_check_constant_assignment (ValaAssignment* self,
                                           ValaMemberAccess* inner)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		if (!(inner != NULL)) {
			break;
		}
		_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) inner);
		_tmp1_ = _tmp0_;
		if (VALA_IS_CONSTANT (_tmp1_)) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			vala_report_error (_tmp3_, "Assignment to constant after initialization");
			break;
		}
		_tmp4_ = vala_member_access_get_inner (inner);
		_tmp5_ = _tmp4_;
		if (VALA_IS_MEMBER_ACCESS (_tmp5_)) {
			ValaExpression* _tmp6_;
			ValaExpression* _tmp7_;
			_tmp6_ = vala_member_access_get_inner (inner);
			_tmp7_ = _tmp6_;
			inner = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		} else {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (inner);
			_tmp9_ = _tmp8_;
			if (VALA_IS_ELEMENT_ACCESS (_tmp9_)) {
				ValaExpression* _tmp10_;
				ValaExpression* _tmp11_;
				ValaExpression* _tmp12_;
				ValaExpression* _tmp13_;
				_tmp10_ = vala_member_access_get_inner (inner);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_element_access_get_container (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
				_tmp13_ = _tmp12_;
				inner = VALA_IS_MEMBER_ACCESS (_tmp13_) ? ((ValaMemberAccess*) _tmp13_) : NULL;
			} else {
				inner = NULL;
			}
		}
	}
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static void
vala_assignment_real_emit (ValaCodeNode* base,
                           ValaCodeGenerator* codegen)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaExpression* _tmp130_;
	ValaExpression* _tmp131_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL;
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	ea = VALA_IS_ELEMENT_ACCESS (_tmp3_) ? ((ValaElementAccess*) _tmp3_) : NULL;
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	pi = VALA_IS_POINTER_INDIRECTION (_tmp5_) ? ((ValaPointerIndirection*) _tmp5_) : NULL;
	_tmp6_ = ma;
	if (_tmp6_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp13_;
		ValaSymbol* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		ValaField* _tmp21_;
		gboolean instance = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		ValaAssignmentOperator _tmp36_;
		gboolean _tmp115_ = FALSE;
		gboolean _tmp116_ = FALSE;
		_tmp7_ = ma;
		_tmp8_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp7_);
		_tmp9_ = _tmp8_;
		local = VALA_IS_LOCAL_VARIABLE (_tmp9_) ? ((ValaLocalVariable*) _tmp9_) : NULL;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		param = VALA_IS_PARAMETER (_tmp12_) ? ((ValaParameter*) _tmp12_) : NULL;
		_tmp13_ = ma;
		_tmp14_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp13_);
		_tmp15_ = _tmp14_;
		field = VALA_IS_FIELD (_tmp15_) ? ((ValaField*) _tmp15_) : NULL;
		_tmp16_ = ma;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp16_);
		_tmp18_ = _tmp17_;
		property = VALA_IS_PROPERTY (_tmp18_) ? ((ValaProperty*) _tmp18_) : NULL;
		_tmp21_ = field;
		if (_tmp21_ != NULL) {
			ValaField* _tmp22_;
			ValaMemberBinding _tmp23_;
			ValaMemberBinding _tmp24_;
			_tmp22_ = field;
			_tmp23_ = vala_field_get_binding (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp20_ = _tmp24_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			gboolean _tmp25_ = FALSE;
			ValaProperty* _tmp26_;
			_tmp26_ = property;
			if (_tmp26_ != NULL) {
				ValaProperty* _tmp27_;
				ValaMemberBinding _tmp28_;
				ValaMemberBinding _tmp29_;
				_tmp27_ = property;
				_tmp28_ = vala_property_get_binding (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp25_ = _tmp29_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp25_ = FALSE;
			}
			_tmp19_ = _tmp25_;
		}
		instance = _tmp19_;
		_tmp36_ = self->priv->_operator;
		if (_tmp36_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp37_ = FALSE;
			gboolean _tmp38_ = FALSE;
			ValaLocalVariable* _tmp39_;
			_tmp39_ = local;
			if (_tmp39_ != NULL) {
				_tmp38_ = TRUE;
			} else {
				ValaParameter* _tmp40_;
				_tmp40_ = param;
				_tmp38_ = _tmp40_ != NULL;
			}
			if (_tmp38_) {
				_tmp37_ = TRUE;
			} else {
				ValaField* _tmp41_;
				_tmp41_ = field;
				_tmp37_ = _tmp41_ != NULL;
			}
			_tmp35_ = _tmp37_;
		} else {
			_tmp35_ = FALSE;
		}
		if (_tmp35_) {
			_tmp34_ = !vala_assignment_is_array_add (self);
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			ValaField* _tmp42_;
			_tmp42_ = field;
			_tmp33_ = !VALA_IS_ARRAY_LENGTH_FIELD (_tmp42_);
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			ValaField* _tmp43_;
			_tmp43_ = field;
			_tmp32_ = !VALA_IS_DELEGATE_TARGET_FIELD (_tmp43_);
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaField* _tmp44_;
			_tmp44_ = field;
			_tmp31_ = !VALA_IS_DELEGATE_DESTROY_FIELD (_tmp44_);
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			gboolean _tmp45_ = FALSE;
			ValaExpression* _tmp46_;
			ValaExpression* _tmp47_;
			ValaDataType* _tmp48_;
			ValaDataType* _tmp49_;
			_tmp46_ = vala_assignment_get_left (self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_expression_get_value_type (_tmp47_);
			_tmp49_ = _tmp48_;
			if (vala_data_type_is_real_non_null_struct_type (_tmp49_)) {
				ValaExpression* _tmp50_;
				ValaExpression* _tmp51_;
				_tmp50_ = vala_assignment_get_right (self);
				_tmp51_ = _tmp50_;
				_tmp45_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp51_);
			} else {
				_tmp45_ = FALSE;
			}
			_tmp30_ = !_tmp45_;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			gboolean _tmp52_ = FALSE;
			ValaExpression* _tmp59_;
			ValaExpression* _tmp60_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp61_;
			ValaExpression* _tmp62_;
			ValaTargetValue* _tmp63_;
			ValaTargetValue* _tmp64_;
			ValaTargetValue* _tmp65_;
			ValaLocalVariable* _tmp66_;
			ValaCodeNode* _tmp91_;
			ValaCodeNode* _tmp92_;
			if (instance) {
				ValaMemberAccess* _tmp53_;
				ValaExpression* _tmp54_;
				ValaExpression* _tmp55_;
				_tmp53_ = ma;
				_tmp54_ = vala_member_access_get_inner (_tmp53_);
				_tmp55_ = _tmp54_;
				_tmp52_ = _tmp55_ != NULL;
			} else {
				_tmp52_ = FALSE;
			}
			if (_tmp52_) {
				ValaMemberAccess* _tmp56_;
				ValaExpression* _tmp57_;
				ValaExpression* _tmp58_;
				_tmp56_ = ma;
				_tmp57_ = vala_member_access_get_inner (_tmp56_);
				_tmp58_ = _tmp57_;
				vala_code_node_emit ((ValaCodeNode*) _tmp58_, codegen);
			}
			_tmp59_ = vala_assignment_get_right (self);
			_tmp60_ = _tmp59_;
			vala_code_node_emit ((ValaCodeNode*) _tmp60_, codegen);
			_tmp61_ = vala_assignment_get_right (self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_expression_get_target_value (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = _vala_target_value_ref0 (_tmp64_);
			new_value = _tmp65_;
			_tmp66_ = local;
			if (_tmp66_ != NULL) {
				ValaLocalVariable* _tmp67_;
				ValaTargetValue* _tmp68_;
				ValaSourceReference* _tmp69_;
				ValaSourceReference* _tmp70_;
				_tmp67_ = local;
				_tmp68_ = new_value;
				_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp70_ = _tmp69_;
				vala_code_generator_store_local (codegen, _tmp67_, _tmp68_, FALSE, _tmp70_);
			} else {
				ValaParameter* _tmp71_;
				_tmp71_ = param;
				if (_tmp71_ != NULL) {
					ValaParameter* _tmp72_;
					ValaTargetValue* _tmp73_;
					ValaSourceReference* _tmp74_;
					ValaSourceReference* _tmp75_;
					_tmp72_ = param;
					_tmp73_ = new_value;
					_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp75_ = _tmp74_;
					vala_code_generator_store_parameter (codegen, _tmp72_, _tmp73_, FALSE, _tmp75_);
				} else {
					ValaField* _tmp76_;
					_tmp76_ = field;
					if (_tmp76_ != NULL) {
						ValaTargetValue* _tmp77_ = NULL;
						gboolean _tmp78_ = FALSE;
						ValaField* _tmp87_;
						ValaTargetValue* _tmp88_;
						ValaSourceReference* _tmp89_;
						ValaSourceReference* _tmp90_;
						if (instance) {
							ValaMemberAccess* _tmp79_;
							ValaExpression* _tmp80_;
							ValaExpression* _tmp81_;
							_tmp79_ = ma;
							_tmp80_ = vala_member_access_get_inner (_tmp79_);
							_tmp81_ = _tmp80_;
							_tmp78_ = _tmp81_ != NULL;
						} else {
							_tmp78_ = FALSE;
						}
						if (_tmp78_) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							ValaTargetValue* _tmp85_;
							ValaTargetValue* _tmp86_;
							_tmp82_ = ma;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp85_ = vala_expression_get_target_value (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp77_ = _tmp86_;
						} else {
							_tmp77_ = NULL;
						}
						_tmp87_ = field;
						_tmp88_ = new_value;
						_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp90_ = _tmp89_;
						vala_code_generator_store_field (codegen, _tmp87_, _tmp77_, _tmp88_, _tmp90_);
					}
				}
			}
			_tmp91_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp92_ = _tmp91_;
			if (!VALA_IS_EXPRESSION_STATEMENT (_tmp92_)) {
				ValaLocalVariable* _tmp93_;
				_tmp93_ = local;
				if (_tmp93_ != NULL) {
					ValaLocalVariable* _tmp94_;
					ValaTargetValue* _tmp95_;
					ValaTargetValue* _tmp96_;
					_tmp94_ = local;
					_tmp95_ = vala_code_generator_load_local (codegen, _tmp94_, NULL);
					_tmp96_ = _tmp95_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp96_);
					_vala_target_value_unref0 (_tmp96_);
				} else {
					ValaParameter* _tmp97_;
					_tmp97_ = param;
					if (_tmp97_ != NULL) {
						ValaParameter* _tmp98_;
						ValaTargetValue* _tmp99_;
						ValaTargetValue* _tmp100_;
						_tmp98_ = param;
						_tmp99_ = vala_code_generator_load_parameter (codegen, _tmp98_, NULL);
						_tmp100_ = _tmp99_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp100_);
						_vala_target_value_unref0 (_tmp100_);
					} else {
						ValaField* _tmp101_;
						_tmp101_ = field;
						if (_tmp101_ != NULL) {
							ValaTargetValue* _tmp102_ = NULL;
							gboolean _tmp103_ = FALSE;
							ValaField* _tmp112_;
							ValaTargetValue* _tmp113_;
							ValaTargetValue* _tmp114_;
							if (instance) {
								ValaMemberAccess* _tmp104_;
								ValaExpression* _tmp105_;
								ValaExpression* _tmp106_;
								_tmp104_ = ma;
								_tmp105_ = vala_member_access_get_inner (_tmp104_);
								_tmp106_ = _tmp105_;
								_tmp103_ = _tmp106_ != NULL;
							} else {
								_tmp103_ = FALSE;
							}
							if (_tmp103_) {
								ValaMemberAccess* _tmp107_;
								ValaExpression* _tmp108_;
								ValaExpression* _tmp109_;
								ValaTargetValue* _tmp110_;
								ValaTargetValue* _tmp111_;
								_tmp107_ = ma;
								_tmp108_ = vala_member_access_get_inner (_tmp107_);
								_tmp109_ = _tmp108_;
								_tmp110_ = vala_expression_get_target_value (_tmp109_);
								_tmp111_ = _tmp110_;
								_tmp102_ = _tmp111_;
							} else {
								_tmp102_ = NULL;
							}
							_tmp112_ = field;
							_tmp113_ = vala_code_generator_load_field (codegen, _tmp112_, _tmp102_, NULL);
							_tmp114_ = _tmp113_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp114_);
							_vala_target_value_unref0 (_tmp114_);
						}
					}
				}
			}
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			return;
		}
		if (instance) {
			ValaMemberAccess* _tmp117_;
			ValaExpression* _tmp118_;
			ValaExpression* _tmp119_;
			_tmp117_ = ma;
			_tmp118_ = vala_member_access_get_inner (_tmp117_);
			_tmp119_ = _tmp118_;
			_tmp116_ = _tmp119_ != NULL;
		} else {
			_tmp116_ = FALSE;
		}
		if (_tmp116_) {
			ValaProperty* _tmp120_;
			_tmp120_ = property;
			_tmp115_ = _tmp120_ != NULL;
		} else {
			_tmp115_ = FALSE;
		}
		if (_tmp115_) {
			ValaMemberAccess* _tmp121_;
			ValaExpression* _tmp122_;
			ValaExpression* _tmp123_;
			_tmp121_ = ma;
			_tmp122_ = vala_member_access_get_inner (_tmp121_);
			_tmp123_ = _tmp122_;
			vala_code_node_emit ((ValaCodeNode*) _tmp123_, codegen);
		} else {
			ValaProperty* _tmp124_;
			_tmp124_ = property;
			if (_tmp124_ == NULL) {
				ValaMemberAccess* _tmp125_;
				_tmp125_ = ma;
				vala_code_node_emit ((ValaCodeNode*) _tmp125_, codegen);
			}
		}
	} else {
		ValaElementAccess* _tmp126_;
		_tmp126_ = ea;
		if (_tmp126_ != NULL) {
			ValaElementAccess* _tmp127_;
			_tmp127_ = ea;
			vala_code_node_emit ((ValaCodeNode*) _tmp127_, codegen);
		} else {
			ValaPointerIndirection* _tmp128_;
			_tmp128_ = pi;
			if (_tmp128_ != NULL) {
				ValaPointerIndirection* _tmp129_;
				_tmp129_ = pi;
				vala_code_node_emit ((ValaCodeNode*) _tmp129_, codegen);
			}
		}
	}
	_tmp130_ = vala_assignment_get_right (self);
	_tmp131_ = _tmp130_;
	vala_code_node_emit ((ValaCodeNode*) _tmp131_, codegen);
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaLocalVariable* _tmp12_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_get_symbol_reference (_tmp5_);
	_tmp7_ = _tmp6_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp7_) ? ((ValaLocalVariable*) _tmp7_) : NULL;
	_tmp8_ = vala_assignment_get_left (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_expression_get_symbol_reference (_tmp9_);
	_tmp11_ = _tmp10_;
	param = VALA_IS_PARAMETER (_tmp11_) ? ((ValaParameter*) _tmp11_) : NULL;
	_tmp12_ = local;
	if (_tmp12_ != NULL) {
		ValaLocalVariable* _tmp13_;
		_tmp13_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp13_);
	} else {
		gboolean _tmp14_ = FALSE;
		ValaParameter* _tmp15_;
		_tmp15_ = param;
		if (_tmp15_ != NULL) {
			ValaParameter* _tmp16_;
			ValaParameterDirection _tmp17_;
			ValaParameterDirection _tmp18_;
			_tmp16_ = param;
			_tmp17_ = vala_parameter_get_direction (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaParameter* _tmp19_;
			_tmp19_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp19_);
		}
	}
}

static void
vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                         ValaCollection* collection)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMemberAccess* _tmp5_;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL;
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	ea = VALA_IS_ELEMENT_ACCESS (_tmp3_) ? ((ValaElementAccess*) _tmp3_) : NULL;
	_tmp5_ = ma;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		_tmp6_ = ma;
		_tmp7_ = vala_member_access_get_inner (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaMemberAccess* _tmp9_;
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		_tmp9_ = ma;
		_tmp10_ = vala_member_access_get_inner (_tmp9_);
		_tmp11_ = _tmp10_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
	} else {
		ValaElementAccess* _tmp12_;
		_tmp12_ = ea;
		if (_tmp12_ != NULL) {
			ValaElementAccess* _tmp13_;
			_tmp13_ = ea;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
		}
	}
	_tmp14_ = vala_assignment_get_right (self);
	_tmp15_ = _tmp14_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
}

static void
vala_assignment_class_init (ValaAssignmentClass * klass,
                            gpointer klass_data)
{
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_adjust_private_offset (klass, &ValaAssignment_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_assignment_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_assignment_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_used_variables;
}

static void
vala_assignment_instance_init (ValaAssignment * self,
                               gpointer klass)
{
	self->priv = vala_assignment_get_instance_private (self);
}

static void
vala_assignment_finalize (ValaCodeNode * obj)
{
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}

/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
static GType
vala_assignment_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
	GType vala_assignment_type_id;
	vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
	ValaAssignment_private_offset = g_type_add_instance_private (vala_assignment_type_id, sizeof (ValaAssignmentPrivate));
	return vala_assignment_type_id;
}

GType
vala_assignment_get_type (void)
{
	static volatile gsize vala_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_type_id__volatile)) {
		GType vala_assignment_type_id;
		vala_assignment_type_id = vala_assignment_get_type_once ();
		g_once_init_leave (&vala_assignment_type_id__volatile, vala_assignment_type_id);
	}
	return vala_assignment_type_id__volatile;
}

const gchar*
vala_assignment_operator_to_string (ValaAssignmentOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_ASSIGNMENT_OPERATOR_SIMPLE:
		{
			result = "=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
		{
			result = "|=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
		{
			result = "&=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
		{
			result = "^=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_ADD:
		{
			result = "+=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SUB:
		{
			result = "-=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_MUL:
		{
			result = "*=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_DIV:
		{
			result = "/=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_PERCENT:
		{
			result = "%=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
		{
			result = "<<=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>=";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
vala_assignment_operator_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
	GType vala_assignment_operator_type_id;
	vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
	return vala_assignment_operator_type_id;
}

GType
vala_assignment_operator_get_type (void)
{
	static volatile gsize vala_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__volatile)) {
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = vala_assignment_operator_get_type_once ();
		g_once_init_leave (&vala_assignment_operator_type_id__volatile, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__volatile;
}

