/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaDataType* _tmp13_;
			_type_arg_index = _type_arg_index + 1;
			_tmp9_ = _type_arg_index;
			_tmp10_ = _type_arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _type_arg_list;
			_tmp12_ = vala_list_get (_tmp11_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp12_;
			_tmp13_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp18_;
	gboolean _tmp627_ = FALSE;
	gboolean _tmp628_ = FALSE;
	gboolean _tmp629_ = FALSE;
	ValaExpression* _tmp630_;
	ValaExpression* _tmp631_;
	ValaSymbol* _tmp659_;
	ValaSymbol* _tmp660_;
	ValaSymbol* _tmp714_;
	ValaSymbol* _tmp715_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp753_;
	ValaSymbol* _tmp754_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp755_;
	ValaSymbol* _tmp756_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1219_;
	ValaSymbol* _tmp1220_;
	ValaSymbol* _tmp1222_;
	ValaVersionAttribute* _tmp1223_;
	ValaVersionAttribute* _tmp1224_;
	ValaSourceReference* _tmp1225_;
	ValaSourceReference* _tmp1226_;
	gboolean _tmp1227_ = FALSE;
	ValaSymbolAccessibility _tmp1228_;
	gboolean _tmp1284_ = FALSE;
	gboolean _tmp1311_ = FALSE;
	gboolean _tmp1312_ = FALSE;
	ValaDataType* _tmp1592_;
	ValaDataType* _tmp1593_;
	gboolean _tmp1596_;
	gboolean _tmp1597_;
	gboolean _tmp1598_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaDataType* _tmp17_;
			_type_arg_index = _type_arg_index + 1;
			_tmp13_ = _type_arg_index;
			_tmp14_ = _type_arg_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _type_arg_list;
			_tmp16_ = vala_list_get (_tmp15_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp16_;
			_tmp17_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp17_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp18_ = self->priv->_qualified;
	if (_tmp18_) {
		ValaNamespace* _tmp19_;
		ValaNamespace* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaScope* _tmp22_;
		ValaScope* _tmp23_;
		const gchar* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		_tmp19_ = vala_code_context_get_root (context);
		_tmp20_ = _tmp19_;
		base_symbol = (ValaSymbol*) _tmp20_;
		_tmp21_ = base_symbol;
		_tmp22_ = vala_symbol_get_scope (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = self->priv->_member_name;
		_tmp25_ = vala_scope_lookup (_tmp23_, _tmp24_);
		_tmp26_ = _tmp25_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp26_);
		_vala_code_node_unref0 (_tmp26_);
	} else {
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp27_ = vala_member_access_get_inner (self);
		_tmp28_ = _tmp27_;
		if (_tmp28_ == NULL) {
			const gchar* _tmp29_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSemanticAnalyzer* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			gboolean _tmp140_ = FALSE;
			ValaSymbol* _tmp141_;
			ValaSymbol* _tmp142_;
			_tmp29_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp29_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp30_;
				ValaSemanticAnalyzer* _tmp31_;
				_tmp30_ = vala_code_context_get_analyzer (context);
				_tmp31_ = _tmp30_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp31_)) {
					ValaSourceReference* _tmp32_;
					ValaSourceReference* _tmp33_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp33_ = _tmp32_;
					vala_report_error (_tmp33_, "This access invalid outside of instance methods");
					result = FALSE;
					return result;
				}
			}
			_tmp34_ = vala_code_context_get_analyzer (context);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_semantic_analyzer_get_current_symbol (_tmp35_);
			_tmp37_ = _tmp36_;
			base_symbol = _tmp37_;
			method_found = FALSE;
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			sym = _tmp41_;
			while (TRUE) {
				gboolean _tmp42_ = FALSE;
				ValaSymbol* _tmp43_;
				ValaSymbol* _tmp89_;
				const gchar* _tmp90_;
				ValaSymbol* _tmp91_;
				ValaSymbol* _tmp92_;
				gboolean _tmp93_ = FALSE;
				gboolean _tmp94_ = FALSE;
				ValaSymbol* _tmp95_;
				ValaSymbol* _tmp96_;
				ValaSymbol* _tmp134_;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp137_;
				ValaSymbol* _tmp138_;
				ValaSymbol* _tmp139_;
				_tmp43_ = sym;
				if (_tmp43_ != NULL) {
					ValaSymbol* _tmp44_;
					ValaSymbol* _tmp45_;
					_tmp44_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp45_ = _tmp44_;
					_tmp42_ = _tmp45_ == NULL;
				} else {
					_tmp42_ = FALSE;
				}
				if (!_tmp42_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp46_;
					_tmp46_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp46_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp47_;
						ValaCreationMethod* _tmp48_;
						ValaParameter* _tmp49_;
						ValaParameter* _tmp50_;
						_tmp47_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp48_ = cm;
						_tmp49_ = vala_method_get_this_parameter ((ValaMethod*) _tmp48_);
						_tmp50_ = _tmp49_;
						this_parameter = _tmp50_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp51_;
						_tmp51_ = sym;
						if (VALA_IS_PROPERTY (_tmp51_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp52_;
							ValaProperty* _tmp53_;
							ValaParameter* _tmp54_;
							ValaParameter* _tmp55_;
							ValaProperty* _tmp56_;
							ValaMemberBinding _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaProperty* _tmp59_;
							ValaMemberBinding _tmp60_;
							ValaMemberBinding _tmp61_;
							_tmp52_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp53_ = prop;
							_tmp54_ = vala_property_get_this_parameter (_tmp53_);
							_tmp55_ = _tmp54_;
							this_parameter = _tmp55_;
							_tmp56_ = prop;
							_tmp57_ = vala_property_get_binding (_tmp56_);
							_tmp58_ = _tmp57_;
							may_access_instance_members = _tmp58_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp59_ = prop;
							_tmp60_ = vala_property_get_binding (_tmp59_);
							_tmp61_ = _tmp60_;
							may_access_klass_members = _tmp61_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp62_;
							_tmp62_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp62_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp63_;
								ValaConstructor* _tmp64_;
								ValaParameter* _tmp65_;
								ValaParameter* _tmp66_;
								ValaConstructor* _tmp67_;
								ValaMemberBinding _tmp68_;
								ValaMemberBinding _tmp69_;
								_tmp63_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp64_ = c;
								_tmp65_ = vala_constructor_get_this_parameter (_tmp64_);
								_tmp66_ = _tmp65_;
								this_parameter = _tmp66_;
								_tmp67_ = c;
								_tmp68_ = vala_constructor_get_binding (_tmp67_);
								_tmp69_ = _tmp68_;
								may_access_instance_members = _tmp69_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp70_;
								_tmp70_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp70_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp71_;
									ValaDestructor* _tmp72_;
									ValaParameter* _tmp73_;
									ValaParameter* _tmp74_;
									ValaDestructor* _tmp75_;
									ValaMemberBinding _tmp76_;
									ValaMemberBinding _tmp77_;
									_tmp71_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp72_ = d;
									_tmp73_ = vala_destructor_get_this_parameter (_tmp72_);
									_tmp74_ = _tmp73_;
									this_parameter = _tmp74_;
									_tmp75_ = d;
									_tmp76_ = vala_destructor_get_binding (_tmp75_);
									_tmp77_ = _tmp76_;
									may_access_instance_members = _tmp77_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp78_;
									_tmp78_ = sym;
									if (VALA_IS_METHOD (_tmp78_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp79_;
										ValaMethod* _tmp80_;
										ValaParameter* _tmp81_;
										ValaParameter* _tmp82_;
										ValaMethod* _tmp83_;
										ValaMemberBinding _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMethod* _tmp86_;
										ValaMemberBinding _tmp87_;
										ValaMemberBinding _tmp88_;
										_tmp79_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALA_TYPE_METHOD, ValaMethod);
										_tmp80_ = m;
										_tmp81_ = vala_method_get_this_parameter (_tmp80_);
										_tmp82_ = _tmp81_;
										this_parameter = _tmp82_;
										_tmp83_ = m;
										_tmp84_ = vala_method_get_binding (_tmp83_);
										_tmp85_ = _tmp84_;
										may_access_instance_members = _tmp85_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp86_ = m;
										_tmp87_ = vala_method_get_binding (_tmp86_);
										_tmp88_ = _tmp87_;
										may_access_klass_members = _tmp88_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp89_ = sym;
				_tmp90_ = self->priv->_member_name;
				_tmp91_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp89_, _tmp90_);
				_tmp92_ = _tmp91_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp92_);
				_vala_code_node_unref0 (_tmp92_);
				_tmp95_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp96_ = _tmp95_;
				if (_tmp96_ == NULL) {
					ValaSymbol* _tmp97_;
					_tmp97_ = sym;
					_tmp94_ = VALA_IS_TYPESYMBOL (_tmp97_);
				} else {
					_tmp94_ = FALSE;
				}
				if (_tmp94_) {
					_tmp93_ = may_access_instance_members;
				} else {
					_tmp93_ = FALSE;
				}
				if (_tmp93_) {
					ValaParameter* _tmp98_;
					ValaDataType* _tmp99_;
					ValaDataType* _tmp100_;
					const gchar* _tmp101_;
					ValaSymbol* _tmp102_;
					ValaSymbol* _tmp103_;
					gboolean _tmp104_ = FALSE;
					ValaSymbol* _tmp105_;
					ValaSymbol* _tmp106_;
					_tmp98_ = this_parameter;
					_tmp99_ = vala_variable_get_variable_type ((ValaVariable*) _tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = self->priv->_member_name;
					_tmp102_ = vala_data_type_get_member (_tmp100_, _tmp101_);
					_tmp103_ = _tmp102_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp103_);
					_vala_code_node_unref0 (_tmp103_);
					_tmp105_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp106_ = _tmp105_;
					if (_tmp106_ != NULL) {
						ValaSymbol* _tmp107_;
						ValaSymbol* _tmp108_;
						_tmp107_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp108_ = _tmp107_;
						_tmp104_ = vala_member_access_is_instance_symbol (_tmp108_);
					} else {
						_tmp104_ = FALSE;
					}
					if (_tmp104_) {
						ValaSourceReference* _tmp109_;
						ValaSourceReference* _tmp110_;
						ValaMemberAccess* _tmp111_;
						ValaMemberAccess* _tmp112_;
						ValaExpression* _tmp113_;
						ValaExpression* _tmp114_;
						ValaParameter* _tmp115_;
						ValaDataType* _tmp116_;
						ValaDataType* _tmp117_;
						ValaDataType* _tmp118_;
						ValaDataType* _tmp119_;
						ValaExpression* _tmp120_;
						ValaExpression* _tmp121_;
						ValaDataType* _tmp122_;
						ValaDataType* _tmp123_;
						ValaExpression* _tmp124_;
						ValaExpression* _tmp125_;
						ValaParameter* _tmp126_;
						ValaExpression* _tmp127_;
						ValaExpression* _tmp128_;
						ValaDataType* _tmp129_;
						ValaDataType* _tmp130_;
						const gchar* _tmp131_;
						ValaSymbol* _tmp132_;
						ValaSymbol* _tmp133_;
						_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp110_ = _tmp109_;
						_tmp111_ = vala_member_access_new (NULL, "this", _tmp110_);
						_tmp112_ = _tmp111_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp112_);
						_vala_code_node_unref0 (_tmp112_);
						_tmp113_ = vala_member_access_get_inner (self);
						_tmp114_ = _tmp113_;
						_tmp115_ = this_parameter;
						_tmp116_ = vala_variable_get_variable_type ((ValaVariable*) _tmp115_);
						_tmp117_ = _tmp116_;
						_tmp118_ = vala_data_type_copy (_tmp117_);
						_tmp119_ = _tmp118_;
						vala_expression_set_value_type (_tmp114_, _tmp119_);
						_vala_code_node_unref0 (_tmp119_);
						_tmp120_ = vala_member_access_get_inner (self);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_expression_get_value_type (_tmp121_);
						_tmp123_ = _tmp122_;
						vala_data_type_set_value_owned (_tmp123_, FALSE);
						_tmp124_ = vala_member_access_get_inner (self);
						_tmp125_ = _tmp124_;
						_tmp126_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp125_, (ValaSymbol*) _tmp126_);
						_tmp127_ = vala_member_access_get_inner (self);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_expression_get_value_type (_tmp128_);
						_tmp130_ = _tmp129_;
						_tmp131_ = self->priv->_member_name;
						_tmp132_ = vala_data_type_get_member (_tmp130_, _tmp131_);
						_tmp133_ = _tmp132_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp133_);
						_vala_code_node_unref0 (_tmp133_);
					}
				}
				_tmp134_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp135_ = _tmp134_;
				if (_tmp135_ == NULL) {
					ValaSymbol* _tmp136_;
					_tmp136_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp136_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp137_ = sym;
				_tmp138_ = vala_symbol_get_parent_symbol (_tmp137_);
				_tmp139_ = _tmp138_;
				sym = _tmp139_;
			}
			_tmp141_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp142_ = _tmp141_;
			if (_tmp142_ == NULL) {
				ValaSourceReference* _tmp143_;
				ValaSourceReference* _tmp144_;
				_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp144_ = _tmp143_;
				_tmp140_ = _tmp144_ != NULL;
			} else {
				_tmp140_ = FALSE;
			}
			if (_tmp140_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp145_;
					ValaSourceReference* _tmp146_;
					ValaList* _tmp147_;
					ValaList* _tmp148_;
					ValaList* _tmp149_;
					gint _ns_size = 0;
					ValaList* _tmp150_;
					gint _tmp151_;
					gint _tmp152_;
					gint _ns_index = 0;
					_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp146_ = _tmp145_;
					_tmp147_ = vala_source_reference_get_using_directives (_tmp146_);
					_tmp148_ = _tmp147_;
					_tmp149_ = _vala_iterable_ref0 (_tmp148_);
					_ns_list = _tmp149_;
					_tmp150_ = _ns_list;
					_tmp151_ = vala_collection_get_size ((ValaCollection*) _tmp150_);
					_tmp152_ = _tmp151_;
					_ns_size = _tmp152_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp153_;
						gint _tmp154_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp155_;
						gpointer _tmp156_;
						ValaUsingDirective* _tmp157_;
						gboolean _tmp158_;
						gboolean _tmp159_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp160_;
						ValaSymbol* _tmp161_;
						ValaSymbol* _tmp162_;
						ValaScope* _tmp163_;
						ValaScope* _tmp164_;
						const gchar* _tmp165_;
						ValaSymbol* _tmp166_;
						ValaSymbol* _tmp167_;
						_ns_index = _ns_index + 1;
						_tmp153_ = _ns_index;
						_tmp154_ = _ns_size;
						if (!(_tmp153_ < _tmp154_)) {
							break;
						}
						_tmp155_ = _ns_list;
						_tmp156_ = vala_list_get (_tmp155_, _ns_index);
						ns = (ValaUsingDirective*) _tmp156_;
						_tmp157_ = ns;
						_tmp158_ = vala_code_node_get_error ((ValaCodeNode*) _tmp157_);
						_tmp159_ = _tmp158_;
						if (_tmp159_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp160_ = ns;
						_tmp161_ = vala_using_directive_get_namespace_symbol (_tmp160_);
						_tmp162_ = _tmp161_;
						_tmp163_ = vala_symbol_get_scope (_tmp162_);
						_tmp164_ = _tmp163_;
						_tmp165_ = self->priv->_member_name;
						_tmp166_ = vala_scope_lookup (_tmp164_, _tmp165_);
						local_sym = _tmp166_;
						_tmp167_ = local_sym;
						if (_tmp167_ != NULL) {
							gboolean _tmp168_ = FALSE;
							ValaSymbol* _tmp169_;
							ValaSymbol* _tmp170_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp186_;
							ValaSymbol* _tmp187_;
							ValaSymbol* _tmp188_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp208_;
							ValaExpression* _tmp209_;
							ValaExpression* _tmp210_;
							ValaSymbol* _tmp211_;
							_tmp169_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp170_ = _tmp169_;
							if (_tmp170_ != NULL) {
								ValaSymbol* _tmp171_;
								ValaSymbol* _tmp172_;
								ValaSymbol* _tmp173_;
								_tmp171_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp172_ = _tmp171_;
								_tmp173_ = local_sym;
								_tmp168_ = _tmp172_ != _tmp173_;
							} else {
								_tmp168_ = FALSE;
							}
							if (_tmp168_) {
								ValaSourceReference* _tmp174_;
								ValaSourceReference* _tmp175_;
								const gchar* _tmp176_;
								ValaSymbol* _tmp177_;
								ValaSymbol* _tmp178_;
								gchar* _tmp179_;
								gchar* _tmp180_;
								ValaSymbol* _tmp181_;
								gchar* _tmp182_;
								gchar* _tmp183_;
								gchar* _tmp184_;
								gchar* _tmp185_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp174_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp175_ = _tmp174_;
								_tmp176_ = self->priv->_member_name;
								_tmp177_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp178_ = _tmp177_;
								_tmp179_ = vala_symbol_get_full_name (_tmp178_);
								_tmp180_ = _tmp179_;
								_tmp181_ = local_sym;
								_tmp182_ = vala_symbol_get_full_name (_tmp181_);
								_tmp183_ = _tmp182_;
								_tmp184_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp176_, _tmp180_, _tmp183_);
								_tmp185_ = _tmp184_;
								vala_report_error (_tmp175_, _tmp185_);
								_g_free0 (_tmp185_);
								_g_free0 (_tmp183_);
								_g_free0 (_tmp180_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								return result;
							}
							_tmp186_ = local_sym;
							_tmp187_ = vala_symbol_get_parent_symbol (_tmp186_);
							_tmp188_ = _tmp187_;
							inner_sym = _tmp188_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp189_ = FALSE;
								ValaSymbol* _tmp190_;
								ValaMemberAccess* _tmp194_;
								ValaSymbol* _tmp195_;
								const gchar* _tmp196_;
								const gchar* _tmp197_;
								ValaSourceReference* _tmp198_;
								ValaSourceReference* _tmp199_;
								ValaMemberAccess* _tmp200_;
								ValaMemberAccess* _tmp201_;
								ValaMemberAccess* _tmp202_;
								ValaExpression* _tmp203_;
								ValaExpression* _tmp204_;
								ValaSymbol* _tmp205_;
								ValaSymbol* _tmp206_;
								ValaSymbol* _tmp207_;
								_tmp190_ = inner_sym;
								if (_tmp190_ != NULL) {
									ValaSymbol* _tmp191_;
									const gchar* _tmp192_;
									const gchar* _tmp193_;
									_tmp191_ = inner_sym;
									_tmp192_ = vala_symbol_get_name (_tmp191_);
									_tmp193_ = _tmp192_;
									_tmp189_ = _tmp193_ != NULL;
								} else {
									_tmp189_ = FALSE;
								}
								if (!_tmp189_) {
									break;
								}
								_tmp194_ = inner_ma;
								_tmp195_ = inner_sym;
								_tmp196_ = vala_symbol_get_name (_tmp195_);
								_tmp197_ = _tmp196_;
								_tmp198_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp199_ = _tmp198_;
								_tmp200_ = vala_member_access_new (NULL, _tmp197_, _tmp199_);
								_tmp201_ = _tmp200_;
								vala_member_access_set_inner (_tmp194_, (ValaExpression*) _tmp201_);
								_vala_code_node_unref0 (_tmp201_);
								_tmp202_ = inner_ma;
								_tmp203_ = vala_member_access_get_inner (_tmp202_);
								_tmp204_ = _tmp203_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp205_ = inner_sym;
								_tmp206_ = vala_symbol_get_parent_symbol (_tmp205_);
								_tmp207_ = _tmp206_;
								inner_sym = _tmp207_;
							}
							_tmp208_ = inner_ma;
							vala_member_access_set_qualified (_tmp208_, TRUE);
							_tmp209_ = vala_member_access_get_inner (self);
							_tmp210_ = _tmp209_;
							vala_code_node_check ((ValaCodeNode*) _tmp210_, context);
							_tmp211_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp211_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
		} else {
			ValaExpression* _tmp212_;
			ValaExpression* _tmp213_;
			gboolean _tmp214_;
			gboolean _tmp215_;
			ValaExpression* _tmp216_;
			ValaExpression* _tmp217_;
			ValaDataType* _tmp218_;
			ValaDataType* _tmp219_;
			ValaExpression* _tmp250_;
			ValaExpression* _tmp251_;
			gboolean _tmp266_ = FALSE;
			ValaExpression* _tmp267_;
			ValaExpression* _tmp268_;
			gboolean _tmp275_ = FALSE;
			ValaExpression* _tmp276_;
			ValaExpression* _tmp277_;
			gboolean _tmp298_ = FALSE;
			ValaExpression* _tmp299_;
			ValaExpression* _tmp300_;
			gboolean _tmp319_ = FALSE;
			ValaSymbol* _tmp320_;
			ValaSymbol* _tmp321_;
			gboolean _tmp355_ = FALSE;
			gboolean _tmp356_ = FALSE;
			ValaSymbol* _tmp357_;
			ValaSymbol* _tmp358_;
			ValaSymbol* _tmp593_;
			ValaSymbol* _tmp594_;
			_tmp212_ = vala_member_access_get_inner (self);
			_tmp213_ = _tmp212_;
			_tmp214_ = vala_code_node_get_error ((ValaCodeNode*) _tmp213_);
			_tmp215_ = _tmp214_;
			if (_tmp215_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				return result;
			}
			_tmp216_ = vala_member_access_get_inner (self);
			_tmp217_ = _tmp216_;
			_tmp218_ = vala_expression_get_value_type (_tmp217_);
			_tmp219_ = _tmp218_;
			if (VALA_IS_POINTER_TYPE (_tmp219_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp220_;
				ValaExpression* _tmp221_;
				ValaDataType* _tmp222_;
				ValaDataType* _tmp223_;
				gboolean _tmp224_ = FALSE;
				ValaPointerType* _tmp225_;
				_tmp220_ = vala_member_access_get_inner (self);
				_tmp221_ = _tmp220_;
				_tmp222_ = vala_expression_get_value_type (_tmp221_);
				_tmp223_ = _tmp222_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp223_) ? ((ValaPointerType*) _tmp223_) : NULL;
				_tmp225_ = pointer_type;
				if (_tmp225_ != NULL) {
					ValaPointerType* _tmp226_;
					ValaDataType* _tmp227_;
					ValaDataType* _tmp228_;
					_tmp226_ = pointer_type;
					_tmp227_ = vala_pointer_type_get_base_type (_tmp226_);
					_tmp228_ = _tmp227_;
					_tmp224_ = VALA_IS_VALUE_TYPE (_tmp228_);
				} else {
					_tmp224_ = FALSE;
				}
				if (_tmp224_) {
					ValaExpression* _tmp229_;
					ValaExpression* _tmp230_;
					ValaDataType* _tmp231_;
					ValaDataType* _tmp232_;
					ValaExpression* _tmp242_;
					ValaExpression* _tmp243_;
					ValaSourceReference* _tmp244_;
					ValaSourceReference* _tmp245_;
					ValaPointerIndirection* _tmp246_;
					ValaPointerIndirection* _tmp247_;
					ValaExpression* _tmp248_;
					ValaExpression* _tmp249_;
					_tmp229_ = vala_member_access_get_inner (self);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_expression_get_formal_value_type (_tmp230_);
					_tmp232_ = _tmp231_;
					if (VALA_IS_GENERIC_TYPE (_tmp232_)) {
						ValaExpression* _tmp233_;
						ValaExpression* _tmp234_;
						ValaPointerType* _tmp235_;
						ValaDataType* _tmp236_;
						ValaDataType* _tmp237_;
						ValaSourceReference* _tmp238_;
						ValaSourceReference* _tmp239_;
						ValaCastExpression* _tmp240_;
						ValaCastExpression* _tmp241_;
						_tmp233_ = vala_member_access_get_inner (self);
						_tmp234_ = _tmp233_;
						_tmp235_ = pointer_type;
						_tmp236_ = vala_data_type_copy ((ValaDataType*) _tmp235_);
						_tmp237_ = _tmp236_;
						_tmp238_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp239_ = _tmp238_;
						_tmp240_ = vala_cast_expression_new (_tmp234_, _tmp237_, _tmp239_);
						_tmp241_ = _tmp240_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp241_);
						_vala_code_node_unref0 (_tmp241_);
						_vala_code_node_unref0 (_tmp237_);
					}
					_tmp242_ = vala_member_access_get_inner (self);
					_tmp243_ = _tmp242_;
					_tmp244_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp245_ = _tmp244_;
					_tmp246_ = vala_pointer_indirection_new (_tmp243_, _tmp245_);
					_tmp247_ = _tmp246_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp247_);
					_vala_code_node_unref0 (_tmp247_);
					_tmp248_ = vala_member_access_get_inner (self);
					_tmp249_ = _tmp248_;
					vala_code_node_check ((ValaCodeNode*) _tmp249_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp250_ = vala_member_access_get_inner (self);
			_tmp251_ = _tmp250_;
			if (VALA_IS_MEMBER_ACCESS (_tmp251_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp252_;
				ValaExpression* _tmp253_;
				ValaMemberAccess* _tmp254_;
				gboolean _tmp255_;
				_tmp252_ = vala_member_access_get_inner (self);
				_tmp253_ = _tmp252_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp253_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp254_ = ma;
				_tmp255_ = _tmp254_->priv->_prototype_access;
				if (_tmp255_) {
					ValaSourceReference* _tmp256_;
					ValaSourceReference* _tmp257_;
					ValaExpression* _tmp258_;
					ValaExpression* _tmp259_;
					ValaSymbol* _tmp260_;
					ValaSymbol* _tmp261_;
					gchar* _tmp262_;
					gchar* _tmp263_;
					gchar* _tmp264_;
					gchar* _tmp265_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp256_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp257_ = _tmp256_;
					_tmp258_ = vala_member_access_get_inner (self);
					_tmp259_ = _tmp258_;
					_tmp260_ = vala_expression_get_symbol_reference (_tmp259_);
					_tmp261_ = _tmp260_;
					_tmp262_ = vala_symbol_get_full_name (_tmp261_);
					_tmp263_ = _tmp262_;
					_tmp264_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp263_);
					_tmp265_ = _tmp264_;
					vala_report_error (_tmp257_, _tmp265_);
					_g_free0 (_tmp265_);
					_g_free0 (_tmp263_);
					result = FALSE;
					return result;
				}
			}
			_tmp267_ = vala_member_access_get_inner (self);
			_tmp268_ = _tmp267_;
			if (VALA_IS_CAST_EXPRESSION (_tmp268_)) {
				ValaExpression* _tmp269_;
				ValaExpression* _tmp270_;
				gboolean _tmp271_;
				gboolean _tmp272_;
				_tmp269_ = vala_member_access_get_inner (self);
				_tmp270_ = _tmp269_;
				_tmp271_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp270_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp272_ = _tmp271_;
				_tmp266_ = _tmp272_;
			} else {
				_tmp266_ = FALSE;
			}
			if (_tmp266_) {
				ValaSourceReference* _tmp273_;
				ValaSourceReference* _tmp274_;
				_tmp273_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp274_ = _tmp273_;
				vala_report_warning (_tmp274_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp276_ = vala_member_access_get_inner (self);
			_tmp277_ = _tmp276_;
			if (VALA_IS_MEMBER_ACCESS (_tmp277_)) {
				_tmp275_ = TRUE;
			} else {
				ValaExpression* _tmp278_;
				ValaExpression* _tmp279_;
				_tmp278_ = vala_member_access_get_inner (self);
				_tmp279_ = _tmp278_;
				_tmp275_ = VALA_IS_BASE_ACCESS (_tmp279_);
			}
			if (_tmp275_) {
				ValaExpression* _tmp280_;
				ValaExpression* _tmp281_;
				ValaSymbol* _tmp282_;
				ValaSymbol* _tmp283_;
				gboolean _tmp284_ = FALSE;
				ValaSymbol* _tmp285_;
				ValaSymbol* _tmp286_;
				_tmp280_ = vala_member_access_get_inner (self);
				_tmp281_ = _tmp280_;
				_tmp282_ = vala_expression_get_symbol_reference (_tmp281_);
				_tmp283_ = _tmp282_;
				base_symbol = _tmp283_;
				_tmp285_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp286_ = _tmp285_;
				if (_tmp286_ == NULL) {
					gboolean _tmp287_ = FALSE;
					ValaSymbol* _tmp288_;
					_tmp288_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp288_)) {
						_tmp287_ = TRUE;
					} else {
						ValaSymbol* _tmp289_;
						_tmp289_ = base_symbol;
						_tmp287_ = VALA_IS_TYPESYMBOL (_tmp289_);
					}
					_tmp284_ = _tmp287_;
				} else {
					_tmp284_ = FALSE;
				}
				if (_tmp284_) {
					ValaSymbol* _tmp290_;
					ValaScope* _tmp291_;
					ValaScope* _tmp292_;
					const gchar* _tmp293_;
					ValaSymbol* _tmp294_;
					ValaSymbol* _tmp295_;
					ValaExpression* _tmp296_;
					ValaExpression* _tmp297_;
					_tmp290_ = base_symbol;
					_tmp291_ = vala_symbol_get_scope (_tmp290_);
					_tmp292_ = _tmp291_;
					_tmp293_ = self->priv->_member_name;
					_tmp294_ = vala_scope_lookup (_tmp292_, _tmp293_);
					_tmp295_ = _tmp294_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp295_);
					_vala_code_node_unref0 (_tmp295_);
					_tmp296_ = vala_member_access_get_inner (self);
					_tmp297_ = _tmp296_;
					if (VALA_IS_BASE_ACCESS (_tmp297_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp299_ = vala_member_access_get_inner (self);
			_tmp300_ = _tmp299_;
			if (VALA_IS_MEMBER_ACCESS (_tmp300_)) {
				ValaExpression* _tmp301_;
				ValaExpression* _tmp302_;
				ValaSymbol* _tmp303_;
				ValaSymbol* _tmp304_;
				_tmp301_ = vala_member_access_get_inner (self);
				_tmp302_ = _tmp301_;
				_tmp303_ = vala_expression_get_symbol_reference (_tmp302_);
				_tmp304_ = _tmp303_;
				_tmp298_ = VALA_IS_TYPEPARAMETER (_tmp304_);
			} else {
				_tmp298_ = FALSE;
			}
			if (_tmp298_) {
				ValaExpression* _tmp305_;
				ValaExpression* _tmp306_;
				ValaExpression* _tmp307_;
				ValaExpression* _tmp308_;
				ValaSymbol* _tmp309_;
				ValaSymbol* _tmp310_;
				ValaGenericType* _tmp311_;
				ValaGenericType* _tmp312_;
				ValaExpression* _tmp313_;
				ValaExpression* _tmp314_;
				ValaDataType* _tmp315_;
				ValaDataType* _tmp316_;
				ValaSourceReference* _tmp317_;
				ValaSourceReference* _tmp318_;
				_tmp305_ = vala_member_access_get_inner (self);
				_tmp306_ = _tmp305_;
				_tmp307_ = vala_member_access_get_inner (self);
				_tmp308_ = _tmp307_;
				_tmp309_ = vala_expression_get_symbol_reference (_tmp308_);
				_tmp310_ = _tmp309_;
				_tmp311_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp310_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp312_ = _tmp311_;
				vala_expression_set_value_type (_tmp306_, (ValaDataType*) _tmp312_);
				_vala_code_node_unref0 (_tmp312_);
				_tmp313_ = vala_member_access_get_inner (self);
				_tmp314_ = _tmp313_;
				_tmp315_ = vala_expression_get_value_type (_tmp314_);
				_tmp316_ = _tmp315_;
				_tmp317_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp318_ = _tmp317_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp316_, _tmp318_);
			}
			_tmp320_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp321_ = _tmp320_;
			if (_tmp321_ == NULL) {
				ValaExpression* _tmp322_;
				ValaExpression* _tmp323_;
				ValaDataType* _tmp324_;
				ValaDataType* _tmp325_;
				_tmp322_ = vala_member_access_get_inner (self);
				_tmp323_ = _tmp322_;
				_tmp324_ = vala_expression_get_value_type (_tmp323_);
				_tmp325_ = _tmp324_;
				_tmp319_ = _tmp325_ != NULL;
			} else {
				_tmp319_ = FALSE;
			}
			if (_tmp319_) {
				gboolean _tmp326_;
				ValaSymbol* _tmp353_;
				ValaSymbol* _tmp354_;
				_tmp326_ = self->priv->_pointer_member_access;
				if (_tmp326_) {
					ValaExpression* _tmp327_;
					ValaExpression* _tmp328_;
					ValaDataType* _tmp329_;
					ValaDataType* _tmp330_;
					const gchar* _tmp331_;
					ValaSymbol* _tmp332_;
					ValaSymbol* _tmp333_;
					_tmp327_ = vala_member_access_get_inner (self);
					_tmp328_ = _tmp327_;
					_tmp329_ = vala_expression_get_value_type (_tmp328_);
					_tmp330_ = _tmp329_;
					_tmp331_ = self->priv->_member_name;
					_tmp332_ = vala_data_type_get_pointer_member (_tmp330_, _tmp331_);
					_tmp333_ = _tmp332_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp333_);
					_vala_code_node_unref0 (_tmp333_);
				} else {
					ValaExpression* _tmp334_;
					ValaExpression* _tmp335_;
					ValaDataType* _tmp336_;
					ValaDataType* _tmp337_;
					ValaTypeSymbol* _tmp338_;
					ValaTypeSymbol* _tmp339_;
					ValaExpression* _tmp346_;
					ValaExpression* _tmp347_;
					ValaDataType* _tmp348_;
					ValaDataType* _tmp349_;
					const gchar* _tmp350_;
					ValaSymbol* _tmp351_;
					ValaSymbol* _tmp352_;
					_tmp334_ = vala_member_access_get_inner (self);
					_tmp335_ = _tmp334_;
					_tmp336_ = vala_expression_get_value_type (_tmp335_);
					_tmp337_ = _tmp336_;
					_tmp338_ = vala_data_type_get_type_symbol (_tmp337_);
					_tmp339_ = _tmp338_;
					if (_tmp339_ != NULL) {
						ValaExpression* _tmp340_;
						ValaExpression* _tmp341_;
						ValaDataType* _tmp342_;
						ValaDataType* _tmp343_;
						ValaTypeSymbol* _tmp344_;
						ValaTypeSymbol* _tmp345_;
						_tmp340_ = vala_member_access_get_inner (self);
						_tmp341_ = _tmp340_;
						_tmp342_ = vala_expression_get_value_type (_tmp341_);
						_tmp343_ = _tmp342_;
						_tmp344_ = vala_data_type_get_type_symbol (_tmp343_);
						_tmp345_ = _tmp344_;
						base_symbol = (ValaSymbol*) _tmp345_;
					}
					_tmp346_ = vala_member_access_get_inner (self);
					_tmp347_ = _tmp346_;
					_tmp348_ = vala_expression_get_value_type (_tmp347_);
					_tmp349_ = _tmp348_;
					_tmp350_ = self->priv->_member_name;
					_tmp351_ = vala_data_type_get_member (_tmp349_, _tmp350_);
					_tmp352_ = _tmp351_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp352_);
					_vala_code_node_unref0 (_tmp352_);
				}
				_tmp353_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp354_ = _tmp353_;
				if (_tmp354_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp357_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp358_ = _tmp357_;
			if (_tmp358_ == NULL) {
				ValaExpression* _tmp359_;
				ValaExpression* _tmp360_;
				ValaDataType* _tmp361_;
				ValaDataType* _tmp362_;
				_tmp359_ = vala_member_access_get_inner (self);
				_tmp360_ = _tmp359_;
				_tmp361_ = vala_expression_get_value_type (_tmp360_);
				_tmp362_ = _tmp361_;
				_tmp356_ = _tmp362_ != NULL;
			} else {
				_tmp356_ = FALSE;
			}
			if (_tmp356_) {
				ValaExpression* _tmp363_;
				ValaExpression* _tmp364_;
				ValaDataType* _tmp365_;
				ValaDataType* _tmp366_;
				gboolean _tmp367_;
				gboolean _tmp368_;
				_tmp363_ = vala_member_access_get_inner (self);
				_tmp364_ = _tmp363_;
				_tmp365_ = vala_expression_get_value_type (_tmp364_);
				_tmp366_ = _tmp365_;
				_tmp367_ = vala_data_type_get_is_dynamic (_tmp366_);
				_tmp368_ = _tmp367_;
				_tmp355_ = _tmp368_;
			} else {
				_tmp355_ = FALSE;
			}
			if (_tmp355_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp369_;
				ValaExpression* _tmp370_;
				ValaDataType* _tmp371_;
				ValaDataType* _tmp372_;
				ValaObjectType* _tmp373_;
				ValaCodeNode* _tmp374_;
				ValaCodeNode* _tmp375_;
				ValaSymbol* _tmp541_;
				ValaSymbol* _tmp542_;
				ValaSymbol* _tmp591_;
				ValaSymbol* _tmp592_;
				_tmp369_ = vala_member_access_get_inner (self);
				_tmp370_ = _tmp369_;
				_tmp371_ = vala_expression_get_value_type (_tmp370_);
				_tmp372_ = _tmp371_;
				_tmp373_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp372_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp373_;
				_tmp374_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp375_ = _tmp374_;
				if (VALA_IS_METHOD_CALL (_tmp375_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp376_;
					ValaCodeNode* _tmp377_;
					ValaMethodCall* _tmp378_;
					ValaExpression* _tmp379_;
					ValaExpression* _tmp380_;
					_tmp376_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp377_ = _tmp376_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp377_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp378_ = invoc;
					_tmp379_ = vala_method_call_get_call (_tmp378_);
					_tmp380_ = _tmp379_;
					if (_tmp380_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp381_;
						ValaDataType* _tmp382_;
						ValaDataType* _tmp383_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp398_;
						ValaExpression* _tmp399_;
						ValaDataType* _tmp400_;
						ValaDataType* _tmp401_;
						const gchar* _tmp402_;
						ValaDataType* _tmp403_;
						ValaSourceReference* _tmp404_;
						ValaSourceReference* _tmp405_;
						ValaDynamicMethod* _tmp406_;
						ValaDynamicMethod* _tmp407_;
						ValaMethodCall* _tmp408_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp409_;
						ValaErrorType* _tmp410_;
						ValaDynamicMethod* _tmp411_;
						ValaErrorType* _tmp412_;
						ValaDynamicMethod* _tmp413_;
						ValaDynamicMethod* _tmp414_;
						ValaParameter* _tmp415_;
						ValaParameter* _tmp416_;
						ValaDynamicMethod* _tmp417_;
						ValaObjectType* _tmp418_;
						ValaDataType* _tmp419_;
						ValaDataType* _tmp420_;
						ValaDynamicMethod* _tmp421_;
						ValaSourceReference* _tmp422_;
						ValaSourceReference* _tmp423_;
						ValaParameter* _tmp424_;
						ValaParameter* _tmp425_;
						ValaObjectType* _tmp426_;
						ValaTypeSymbol* _tmp427_;
						ValaTypeSymbol* _tmp428_;
						ValaScope* _tmp429_;
						ValaScope* _tmp430_;
						ValaDynamicMethod* _tmp431_;
						ValaDynamicMethod* _tmp432_;
						_tmp381_ = invoc;
						_tmp382_ = vala_expression_get_target_type ((ValaExpression*) _tmp381_);
						_tmp383_ = _tmp382_;
						if (_tmp383_ != NULL) {
							ValaMethodCall* _tmp384_;
							ValaDataType* _tmp385_;
							ValaDataType* _tmp386_;
							ValaDataType* _tmp387_;
							ValaDataType* _tmp388_;
							_tmp384_ = invoc;
							_tmp385_ = vala_expression_get_target_type ((ValaExpression*) _tmp384_);
							_tmp386_ = _tmp385_;
							_tmp387_ = vala_data_type_copy (_tmp386_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp387_;
							_tmp388_ = ret_type;
							vala_data_type_set_value_owned (_tmp388_, TRUE);
						} else {
							ValaMethodCall* _tmp389_;
							ValaCodeNode* _tmp390_;
							ValaCodeNode* _tmp391_;
							_tmp389_ = invoc;
							_tmp390_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp389_);
							_tmp391_ = _tmp390_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp391_)) {
								ValaVoidType* _tmp392_;
								_tmp392_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp392_;
							} else {
								ValaExpression* _tmp393_;
								ValaExpression* _tmp394_;
								ValaDataType* _tmp395_;
								ValaDataType* _tmp396_;
								ValaDataType* _tmp397_;
								_tmp393_ = vala_member_access_get_inner (self);
								_tmp394_ = _tmp393_;
								_tmp395_ = vala_expression_get_value_type (_tmp394_);
								_tmp396_ = _tmp395_;
								_tmp397_ = vala_data_type_copy (_tmp396_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp397_;
							}
						}
						_tmp398_ = vala_member_access_get_inner (self);
						_tmp399_ = _tmp398_;
						_tmp400_ = vala_expression_get_value_type (_tmp399_);
						_tmp401_ = _tmp400_;
						_tmp402_ = self->priv->_member_name;
						_tmp403_ = ret_type;
						_tmp404_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp405_ = _tmp404_;
						_tmp406_ = vala_dynamic_method_new (_tmp401_, _tmp402_, _tmp403_, _tmp405_, NULL);
						m = _tmp406_;
						_tmp407_ = m;
						_tmp408_ = invoc;
						vala_dynamic_method_set_invocation (_tmp407_, _tmp408_);
						_tmp409_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp409_;
						_tmp410_ = err;
						vala_error_type_set_dynamic_error (_tmp410_, TRUE);
						_tmp411_ = m;
						_tmp412_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp411_, (ValaDataType*) _tmp412_);
						_tmp413_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp413_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp414_ = m;
						_tmp415_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp416_ = _tmp415_;
						vala_callable_add_parameter ((ValaCallable*) _tmp414_, _tmp416_);
						_vala_code_node_unref0 (_tmp416_);
						_tmp417_ = m;
						_tmp418_ = dynamic_object_type;
						_tmp419_ = vala_data_type_copy ((ValaDataType*) _tmp418_);
						_tmp420_ = _tmp419_;
						_tmp421_ = m;
						_tmp422_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp421_);
						_tmp423_ = _tmp422_;
						_tmp424_ = vala_parameter_new ("this", _tmp420_, _tmp423_);
						_tmp425_ = _tmp424_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp417_, _tmp425_);
						_vala_code_node_unref0 (_tmp425_);
						_vala_code_node_unref0 (_tmp420_);
						_tmp426_ = dynamic_object_type;
						_tmp427_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp426_);
						_tmp428_ = _tmp427_;
						_tmp429_ = vala_symbol_get_scope ((ValaSymbol*) _tmp428_);
						_tmp430_ = _tmp429_;
						_tmp431_ = m;
						vala_scope_add (_tmp430_, NULL, (ValaSymbol*) _tmp431_);
						_tmp432_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp432_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp433_;
					ValaCodeNode* _tmp434_;
					_tmp433_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp434_ = _tmp433_;
					if (VALA_IS_ASSIGNMENT (_tmp434_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp435_;
						ValaCodeNode* _tmp436_;
						ValaAssignment* _tmp437_;
						ValaExpression* _tmp438_;
						ValaExpression* _tmp439_;
						_tmp435_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp436_ = _tmp435_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp436_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp437_ = a;
						_tmp438_ = vala_assignment_get_left (_tmp437_);
						_tmp439_ = _tmp438_;
						if (_tmp439_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp440_;
							ValaExpression* _tmp441_;
							ValaDataType* _tmp442_;
							ValaDataType* _tmp443_;
							const gchar* _tmp444_;
							ValaSourceReference* _tmp445_;
							ValaSourceReference* _tmp446_;
							ValaDynamicProperty* _tmp447_;
							ValaDynamicProperty* _tmp448_;
							ValaDynamicProperty* _tmp449_;
							ValaDynamicProperty* _tmp450_;
							ValaSourceReference* _tmp451_;
							ValaSourceReference* _tmp452_;
							ValaPropertyAccessor* _tmp453_;
							ValaPropertyAccessor* _tmp454_;
							ValaDynamicProperty* _tmp455_;
							ValaExpression* _tmp456_;
							ValaExpression* _tmp457_;
							ValaDataType* _tmp458_;
							ValaDataType* _tmp459_;
							ValaTypeSymbol* _tmp460_;
							ValaTypeSymbol* _tmp461_;
							ValaScope* _tmp462_;
							ValaScope* _tmp463_;
							ValaObjectType* _tmp464_;
							ValaTypeSymbol* _tmp465_;
							ValaTypeSymbol* _tmp466_;
							ValaScope* _tmp467_;
							ValaScope* _tmp468_;
							ValaDynamicProperty* _tmp469_;
							ValaDynamicProperty* _tmp470_;
							_tmp440_ = vala_member_access_get_inner (self);
							_tmp441_ = _tmp440_;
							_tmp442_ = vala_expression_get_value_type (_tmp441_);
							_tmp443_ = _tmp442_;
							_tmp444_ = self->priv->_member_name;
							_tmp445_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp446_ = _tmp445_;
							_tmp447_ = vala_dynamic_property_new (_tmp443_, _tmp444_, _tmp446_, NULL);
							prop = _tmp447_;
							_tmp448_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp448_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp449_ = prop;
							_tmp450_ = prop;
							_tmp451_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp450_);
							_tmp452_ = _tmp451_;
							_tmp453_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp452_, NULL);
							_tmp454_ = _tmp453_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp449_, _tmp454_);
							_vala_code_node_unref0 (_tmp454_);
							_tmp455_ = prop;
							_tmp456_ = vala_member_access_get_inner (self);
							_tmp457_ = _tmp456_;
							_tmp458_ = vala_expression_get_value_type (_tmp457_);
							_tmp459_ = _tmp458_;
							_tmp460_ = vala_data_type_get_type_symbol (_tmp459_);
							_tmp461_ = _tmp460_;
							_tmp462_ = vala_symbol_get_scope ((ValaSymbol*) _tmp461_);
							_tmp463_ = _tmp462_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp455_, _tmp463_);
							_tmp464_ = dynamic_object_type;
							_tmp465_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp464_);
							_tmp466_ = _tmp465_;
							_tmp467_ = vala_symbol_get_scope ((ValaSymbol*) _tmp466_);
							_tmp468_ = _tmp467_;
							_tmp469_ = prop;
							vala_scope_add (_tmp468_, NULL, (ValaSymbol*) _tmp469_);
							_tmp470_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp470_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp471_ = FALSE;
						gboolean _tmp472_ = FALSE;
						ValaCodeNode* _tmp473_;
						ValaCodeNode* _tmp474_;
						_tmp473_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp474_ = _tmp473_;
						if (VALA_IS_MEMBER_ACCESS (_tmp474_)) {
							ValaExpression* _tmp475_;
							ValaExpression* _tmp476_;
							_tmp475_ = vala_member_access_get_inner (self);
							_tmp476_ = _tmp475_;
							_tmp472_ = VALA_IS_MEMBER_ACCESS (_tmp476_);
						} else {
							_tmp472_ = FALSE;
						}
						if (_tmp472_) {
							ValaCodeNode* _tmp477_;
							ValaCodeNode* _tmp478_;
							ValaCodeNode* _tmp479_;
							ValaCodeNode* _tmp480_;
							_tmp477_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp478_ = _tmp477_;
							_tmp479_ = vala_code_node_get_parent_node (_tmp478_);
							_tmp480_ = _tmp479_;
							_tmp471_ = VALA_IS_METHOD_CALL (_tmp480_);
						} else {
							_tmp471_ = FALSE;
						}
						if (_tmp471_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp481_;
							ValaCodeNode* _tmp482_;
							gboolean _tmp483_ = FALSE;
							ValaMemberAccess* _tmp484_;
							const gchar* _tmp485_;
							_tmp481_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp482_ = _tmp481_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp482_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp484_ = ma;
							_tmp485_ = _tmp484_->priv->_member_name;
							if (g_strcmp0 (_tmp485_, "connect") == 0) {
								_tmp483_ = TRUE;
							} else {
								ValaMemberAccess* _tmp486_;
								const gchar* _tmp487_;
								_tmp486_ = ma;
								_tmp487_ = _tmp486_->priv->_member_name;
								_tmp483_ = g_strcmp0 (_tmp487_, "connect_after") == 0;
							}
							if (_tmp483_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp488_;
								ValaExpression* _tmp489_;
								ValaDataType* _tmp490_;
								ValaDataType* _tmp491_;
								const gchar* _tmp492_;
								ValaVoidType* _tmp493_;
								ValaVoidType* _tmp494_;
								ValaSourceReference* _tmp495_;
								ValaSourceReference* _tmp496_;
								ValaDynamicSignal* _tmp497_;
								ValaDynamicSignal* _tmp498_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp499_;
								ValaCodeNode* _tmp500_;
								ValaCodeNode* _tmp501_;
								ValaCodeNode* _tmp502_;
								ValaMethodCall* _tmp503_;
								ValaMethodCall* _tmp504_;
								ValaList* _tmp505_;
								gint _tmp506_;
								gint _tmp507_;
								ValaDynamicSignal* _tmp533_;
								ValaObjectType* _tmp534_;
								ValaTypeSymbol* _tmp535_;
								ValaTypeSymbol* _tmp536_;
								ValaScope* _tmp537_;
								ValaScope* _tmp538_;
								ValaDynamicSignal* _tmp539_;
								ValaDynamicSignal* _tmp540_;
								_tmp488_ = vala_member_access_get_inner (self);
								_tmp489_ = _tmp488_;
								_tmp490_ = vala_expression_get_value_type (_tmp489_);
								_tmp491_ = _tmp490_;
								_tmp492_ = self->priv->_member_name;
								_tmp493_ = vala_void_type_new (NULL);
								_tmp494_ = _tmp493_;
								_tmp495_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp496_ = _tmp495_;
								_tmp497_ = vala_dynamic_signal_new (_tmp491_, _tmp492_, (ValaDataType*) _tmp494_, _tmp496_, NULL);
								_tmp498_ = _tmp497_;
								_vala_code_node_unref0 (_tmp494_);
								s = _tmp498_;
								_tmp499_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp500_ = _tmp499_;
								_tmp501_ = vala_code_node_get_parent_node (_tmp500_);
								_tmp502_ = _tmp501_;
								_tmp503_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp502_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp503_;
								_tmp504_ = mcall;
								_tmp505_ = vala_method_call_get_argument_list (_tmp504_);
								_tmp506_ = vala_collection_get_size ((ValaCollection*) _tmp505_);
								_tmp507_ = _tmp506_;
								if (_tmp507_ > 0) {
									ValaDynamicSignal* _tmp508_;
									ValaMethodCall* _tmp509_;
									ValaList* _tmp510_;
									gpointer _tmp511_;
									ValaExpression* _tmp512_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp513_;
									ValaExpression* _tmp514_;
									ValaExpression* _tmp515_;
									gboolean _tmp516_ = FALSE;
									gboolean _tmp517_ = FALSE;
									ValaMemberAccess* _tmp518_;
									_tmp508_ = s;
									_tmp509_ = mcall;
									_tmp510_ = vala_method_call_get_argument_list (_tmp509_);
									_tmp511_ = vala_list_get (_tmp510_, 0);
									_tmp512_ = (ValaExpression*) _tmp511_;
									vala_dynamic_signal_set_handler (_tmp508_, _tmp512_);
									_vala_code_node_unref0 (_tmp512_);
									_tmp513_ = s;
									_tmp514_ = vala_dynamic_signal_get_handler (_tmp513_);
									_tmp515_ = _tmp514_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp515_) ? ((ValaMemberAccess*) _tmp515_) : NULL;
									_tmp518_ = arg;
									if (_tmp518_ == NULL) {
										_tmp517_ = TRUE;
									} else {
										ValaMemberAccess* _tmp519_;
										_tmp519_ = arg;
										_tmp517_ = !vala_code_node_check ((ValaCodeNode*) _tmp519_, context);
									}
									if (_tmp517_) {
										_tmp516_ = TRUE;
									} else {
										ValaMemberAccess* _tmp520_;
										ValaSymbol* _tmp521_;
										ValaSymbol* _tmp522_;
										_tmp520_ = arg;
										_tmp521_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp520_);
										_tmp522_ = _tmp521_;
										_tmp516_ = !VALA_IS_METHOD (_tmp522_);
									}
									if (_tmp516_) {
										ValaDynamicSignal* _tmp523_;
										ValaExpression* _tmp524_;
										ValaExpression* _tmp525_;
										ValaSourceReference* _tmp526_;
										ValaSourceReference* _tmp527_;
										ValaDynamicSignal* _tmp528_;
										gchar* _tmp529_;
										gchar* _tmp530_;
										gchar* _tmp531_;
										gchar* _tmp532_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp523_ = s;
										_tmp524_ = vala_dynamic_signal_get_handler (_tmp523_);
										_tmp525_ = _tmp524_;
										_tmp526_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp525_);
										_tmp527_ = _tmp526_;
										_tmp528_ = s;
										_tmp529_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp528_);
										_tmp530_ = _tmp529_;
										_tmp531_ = g_strdup_printf ("Invalid handler for `%s'", _tmp530_);
										_tmp532_ = _tmp531_;
										vala_report_error (_tmp527_, _tmp532_);
										_g_free0 (_tmp532_);
										_g_free0 (_tmp530_);
									}
								}
								_tmp533_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp533_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp534_ = dynamic_object_type;
								_tmp535_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp534_);
								_tmp536_ = _tmp535_;
								_tmp537_ = vala_symbol_get_scope ((ValaSymbol*) _tmp536_);
								_tmp538_ = _tmp537_;
								_tmp539_ = s;
								vala_scope_add (_tmp538_, NULL, (ValaSymbol*) _tmp539_);
								_tmp540_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp540_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp541_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp542_ = _tmp541_;
				if (_tmp542_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp543_;
					ValaExpression* _tmp544_;
					ValaDataType* _tmp545_;
					ValaDataType* _tmp546_;
					const gchar* _tmp547_;
					ValaSourceReference* _tmp548_;
					ValaSourceReference* _tmp549_;
					ValaDynamicProperty* _tmp550_;
					ValaDataType* _tmp551_;
					ValaDataType* _tmp552_;
					ValaDynamicProperty* _tmp563_;
					ValaDynamicProperty* _tmp564_;
					ValaDynamicProperty* _tmp565_;
					ValaDataType* _tmp566_;
					ValaDataType* _tmp567_;
					ValaDataType* _tmp568_;
					ValaDataType* _tmp569_;
					ValaDynamicProperty* _tmp570_;
					ValaSourceReference* _tmp571_;
					ValaSourceReference* _tmp572_;
					ValaPropertyAccessor* _tmp573_;
					ValaPropertyAccessor* _tmp574_;
					ValaDynamicProperty* _tmp575_;
					ValaExpression* _tmp576_;
					ValaExpression* _tmp577_;
					ValaDataType* _tmp578_;
					ValaDataType* _tmp579_;
					ValaTypeSymbol* _tmp580_;
					ValaTypeSymbol* _tmp581_;
					ValaScope* _tmp582_;
					ValaScope* _tmp583_;
					ValaObjectType* _tmp584_;
					ValaTypeSymbol* _tmp585_;
					ValaTypeSymbol* _tmp586_;
					ValaScope* _tmp587_;
					ValaScope* _tmp588_;
					ValaDynamicProperty* _tmp589_;
					ValaDynamicProperty* _tmp590_;
					_tmp543_ = vala_member_access_get_inner (self);
					_tmp544_ = _tmp543_;
					_tmp545_ = vala_expression_get_value_type (_tmp544_);
					_tmp546_ = _tmp545_;
					_tmp547_ = self->priv->_member_name;
					_tmp548_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp549_ = _tmp548_;
					_tmp550_ = vala_dynamic_property_new (_tmp546_, _tmp547_, _tmp549_, NULL);
					prop = _tmp550_;
					_tmp551_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp552_ = _tmp551_;
					if (_tmp552_ != NULL) {
						ValaDynamicProperty* _tmp553_;
						ValaDataType* _tmp554_;
						ValaDataType* _tmp555_;
						_tmp553_ = prop;
						_tmp554_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp555_ = _tmp554_;
						vala_property_set_property_type ((ValaProperty*) _tmp553_, _tmp555_);
					} else {
						ValaDynamicProperty* _tmp556_;
						ValaExpression* _tmp557_;
						ValaExpression* _tmp558_;
						ValaDataType* _tmp559_;
						ValaDataType* _tmp560_;
						ValaDataType* _tmp561_;
						ValaDataType* _tmp562_;
						_tmp556_ = prop;
						_tmp557_ = vala_member_access_get_inner (self);
						_tmp558_ = _tmp557_;
						_tmp559_ = vala_expression_get_value_type (_tmp558_);
						_tmp560_ = _tmp559_;
						_tmp561_ = vala_data_type_copy (_tmp560_);
						_tmp562_ = _tmp561_;
						vala_property_set_property_type ((ValaProperty*) _tmp556_, _tmp562_);
						_vala_code_node_unref0 (_tmp562_);
					}
					_tmp563_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp563_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp564_ = prop;
					_tmp565_ = prop;
					_tmp566_ = vala_property_get_property_type ((ValaProperty*) _tmp565_);
					_tmp567_ = _tmp566_;
					_tmp568_ = vala_data_type_copy (_tmp567_);
					_tmp569_ = _tmp568_;
					_tmp570_ = prop;
					_tmp571_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp570_);
					_tmp572_ = _tmp571_;
					_tmp573_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp569_, NULL, _tmp572_, NULL);
					_tmp574_ = _tmp573_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp564_, _tmp574_);
					_vala_code_node_unref0 (_tmp574_);
					_vala_code_node_unref0 (_tmp569_);
					_tmp575_ = prop;
					_tmp576_ = vala_member_access_get_inner (self);
					_tmp577_ = _tmp576_;
					_tmp578_ = vala_expression_get_value_type (_tmp577_);
					_tmp579_ = _tmp578_;
					_tmp580_ = vala_data_type_get_type_symbol (_tmp579_);
					_tmp581_ = _tmp580_;
					_tmp582_ = vala_symbol_get_scope ((ValaSymbol*) _tmp581_);
					_tmp583_ = _tmp582_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp575_, _tmp583_);
					_tmp584_ = dynamic_object_type;
					_tmp585_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp584_);
					_tmp586_ = _tmp585_;
					_tmp587_ = vala_symbol_get_scope ((ValaSymbol*) _tmp586_);
					_tmp588_ = _tmp587_;
					_tmp589_ = prop;
					vala_scope_add (_tmp588_, NULL, (ValaSymbol*) _tmp589_);
					_tmp590_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp590_);
					_vala_code_node_unref0 (prop);
				}
				_tmp591_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp592_ = _tmp591_;
				if (_tmp592_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp593_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp594_ = _tmp593_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp594_)) {
				ValaExpression* _tmp595_;
				ValaExpression* _tmp596_;
				ValaSymbol* _tmp597_;
				ValaSymbol* _tmp598_;
				_tmp595_ = vala_member_access_get_inner (self);
				_tmp596_ = _tmp595_;
				_tmp597_ = vala_expression_get_symbol_reference (_tmp596_);
				_tmp598_ = _tmp597_;
				if (VALA_IS_VARIABLE (_tmp598_)) {
					ValaArrayType* inner_type = NULL;
					ValaSemanticAnalyzer* _tmp599_;
					ValaSemanticAnalyzer* _tmp600_;
					ValaExpression* _tmp601_;
					ValaExpression* _tmp602_;
					ValaSymbol* _tmp603_;
					ValaSymbol* _tmp604_;
					ValaDataType* _tmp605_;
					ValaArrayType* _tmp606_;
					gboolean _tmp607_ = FALSE;
					ValaArrayType* _tmp608_;
					_tmp599_ = vala_code_context_get_analyzer (context);
					_tmp600_ = _tmp599_;
					_tmp601_ = vala_member_access_get_inner (self);
					_tmp602_ = _tmp601_;
					_tmp603_ = vala_expression_get_symbol_reference (_tmp602_);
					_tmp604_ = _tmp603_;
					_tmp605_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp600_, _tmp604_, TRUE);
					_tmp606_ = VALA_IS_ARRAY_TYPE (_tmp605_) ? ((ValaArrayType*) _tmp605_) : NULL;
					if (_tmp606_ == NULL) {
						_vala_code_node_unref0 (_tmp605_);
					}
					inner_type = _tmp606_;
					_tmp608_ = inner_type;
					if (_tmp608_ != NULL) {
						ValaArrayType* _tmp609_;
						gboolean _tmp610_;
						gboolean _tmp611_;
						_tmp609_ = inner_type;
						_tmp610_ = vala_array_type_get_inline_allocated (_tmp609_);
						_tmp611_ = _tmp610_;
						_tmp607_ = _tmp611_;
					} else {
						_tmp607_ = FALSE;
					}
					if (_tmp607_) {
						ValaSourceReference* _tmp612_;
						ValaSourceReference* _tmp613_;
						_tmp612_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp613_ = _tmp612_;
						vala_report_error (_tmp613_, "`resize' is not supported for arrays with fixed length");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					} else {
						gboolean _tmp614_ = FALSE;
						ValaArrayType* _tmp615_;
						_tmp615_ = inner_type;
						if (_tmp615_ != NULL) {
							ValaArrayType* _tmp616_;
							gboolean _tmp617_;
							gboolean _tmp618_;
							_tmp616_ = inner_type;
							_tmp617_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp616_);
							_tmp618_ = _tmp617_;
							_tmp614_ = !_tmp618_;
						} else {
							_tmp614_ = FALSE;
						}
						if (_tmp614_) {
							ValaSourceReference* _tmp619_;
							ValaSourceReference* _tmp620_;
							_tmp619_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp620_ = _tmp619_;
							vala_report_error (_tmp620_, "`resize' is not allowed for unowned array references");
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						}
					}
					_vala_code_node_unref0 (inner_type);
				} else {
					ValaExpression* _tmp621_;
					ValaExpression* _tmp622_;
					ValaSymbol* _tmp623_;
					ValaSymbol* _tmp624_;
					_tmp621_ = vala_member_access_get_inner (self);
					_tmp622_ = _tmp621_;
					_tmp623_ = vala_expression_get_symbol_reference (_tmp622_);
					_tmp624_ = _tmp623_;
					if (VALA_IS_CONSTANT (_tmp624_)) {
						ValaSourceReference* _tmp625_;
						ValaSourceReference* _tmp626_;
						_tmp625_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp626_ = _tmp625_;
						vala_report_error (_tmp626_, "`resize' is not allowed for constant arrays");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
			}
		}
	}
	_tmp630_ = vala_member_access_get_inner (self);
	_tmp631_ = _tmp630_;
	if (_tmp631_ == NULL) {
		ValaSymbol* _tmp632_;
		ValaSymbol* _tmp633_;
		_tmp632_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp633_ = _tmp632_;
		_tmp629_ = _tmp633_ == NULL;
	} else {
		_tmp629_ = FALSE;
	}
	if (_tmp629_) {
		ValaDataType* _tmp634_;
		ValaDataType* _tmp635_;
		_tmp634_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp635_ = _tmp634_;
		_tmp628_ = _tmp635_ != NULL;
	} else {
		_tmp628_ = FALSE;
	}
	if (_tmp628_) {
		ValaDataType* _tmp636_;
		ValaDataType* _tmp637_;
		ValaTypeSymbol* _tmp638_;
		ValaTypeSymbol* _tmp639_;
		_tmp636_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp637_ = _tmp636_;
		_tmp638_ = vala_data_type_get_type_symbol (_tmp637_);
		_tmp639_ = _tmp638_;
		_tmp627_ = VALA_IS_ENUM (_tmp639_);
	} else {
		_tmp627_ = FALSE;
	}
	if (_tmp627_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp640_;
		ValaDataType* _tmp641_;
		ValaTypeSymbol* _tmp642_;
		ValaTypeSymbol* _tmp643_;
		_tmp640_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp641_ = _tmp640_;
		_tmp642_ = vala_data_type_get_type_symbol (_tmp641_);
		_tmp643_ = _tmp642_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp643_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp644_;
			ValaList* _tmp645_;
			ValaList* _tmp646_;
			gint _val_size = 0;
			ValaList* _tmp647_;
			gint _tmp648_;
			gint _tmp649_;
			gint _val_index = 0;
			_tmp644_ = enum_type;
			_tmp645_ = vala_enum_get_values (_tmp644_);
			_tmp646_ = _vala_iterable_ref0 (_tmp645_);
			_val_list = _tmp646_;
			_tmp647_ = _val_list;
			_tmp648_ = vala_collection_get_size ((ValaCollection*) _tmp647_);
			_tmp649_ = _tmp648_;
			_val_size = _tmp649_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp650_;
				gint _tmp651_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp652_;
				gpointer _tmp653_;
				const gchar* _tmp654_;
				ValaEnumValue* _tmp655_;
				const gchar* _tmp656_;
				const gchar* _tmp657_;
				_val_index = _val_index + 1;
				_tmp650_ = _val_index;
				_tmp651_ = _val_size;
				if (!(_tmp650_ < _tmp651_)) {
					break;
				}
				_tmp652_ = _val_list;
				_tmp653_ = vala_list_get (_tmp652_, _val_index);
				val = (ValaEnumValue*) _tmp653_;
				_tmp654_ = self->priv->_member_name;
				_tmp655_ = val;
				_tmp656_ = vala_symbol_get_name ((ValaSymbol*) _tmp655_);
				_tmp657_ = _tmp656_;
				if (g_strcmp0 (_tmp654_, _tmp657_) == 0) {
					ValaEnumValue* _tmp658_;
					_tmp658_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp658_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
	}
	_tmp659_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp660_ = _tmp659_;
	if (_tmp660_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp661_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp662_ = FALSE;
		ValaExpression* _tmp663_;
		ValaExpression* _tmp664_;
		gchar* base_type_package = NULL;
		gchar* _tmp684_;
		gboolean _tmp685_ = FALSE;
		ValaSymbol* _tmp686_;
		ValaSourceReference* _tmp701_;
		ValaSourceReference* _tmp702_;
		const gchar* _tmp703_;
		const gchar* _tmp704_;
		const gchar* _tmp705_;
		gchar* _tmp706_;
		gchar* _tmp707_;
		ValaInvalidType* _tmp708_;
		ValaInvalidType* _tmp709_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp661_ = g_strdup ("(null)");
		base_type_name = _tmp661_;
		base_type = NULL;
		_tmp663_ = vala_member_access_get_inner (self);
		_tmp664_ = _tmp663_;
		if (_tmp664_ != NULL) {
			ValaExpression* _tmp665_;
			ValaExpression* _tmp666_;
			ValaDataType* _tmp667_;
			ValaDataType* _tmp668_;
			_tmp665_ = vala_member_access_get_inner (self);
			_tmp666_ = _tmp665_;
			_tmp667_ = vala_expression_get_value_type (_tmp666_);
			_tmp668_ = _tmp667_;
			_tmp662_ = _tmp668_ != NULL;
		} else {
			_tmp662_ = FALSE;
		}
		if (_tmp662_) {
			ValaExpression* _tmp669_;
			ValaExpression* _tmp670_;
			ValaDataType* _tmp671_;
			ValaDataType* _tmp672_;
			gchar* _tmp673_;
			ValaExpression* _tmp674_;
			ValaExpression* _tmp675_;
			ValaDataType* _tmp676_;
			ValaDataType* _tmp677_;
			ValaTypeSymbol* _tmp678_;
			ValaTypeSymbol* _tmp679_;
			_tmp669_ = vala_member_access_get_inner (self);
			_tmp670_ = _tmp669_;
			_tmp671_ = vala_expression_get_value_type (_tmp670_);
			_tmp672_ = _tmp671_;
			_tmp673_ = vala_code_node_to_string ((ValaCodeNode*) _tmp672_);
			_g_free0 (base_type_name);
			base_type_name = _tmp673_;
			_tmp674_ = vala_member_access_get_inner (self);
			_tmp675_ = _tmp674_;
			_tmp676_ = vala_expression_get_value_type (_tmp675_);
			_tmp677_ = _tmp676_;
			_tmp678_ = vala_data_type_get_type_symbol (_tmp677_);
			_tmp679_ = _tmp678_;
			base_type = (ValaSymbol*) _tmp679_;
		} else {
			ValaSymbol* _tmp680_;
			_tmp680_ = base_symbol;
			if (_tmp680_ != NULL) {
				ValaSymbol* _tmp681_;
				gchar* _tmp682_;
				ValaSymbol* _tmp683_;
				_tmp681_ = base_symbol;
				_tmp682_ = vala_symbol_get_full_name (_tmp681_);
				_g_free0 (base_type_name);
				base_type_name = _tmp682_;
				_tmp683_ = base_symbol;
				base_type = _tmp683_;
			}
		}
		_tmp684_ = g_strdup ("");
		base_type_package = _tmp684_;
		_tmp686_ = base_type;
		if (_tmp686_ != NULL) {
			ValaSymbol* _tmp687_;
			gboolean _tmp688_;
			gboolean _tmp689_;
			_tmp687_ = base_type;
			_tmp688_ = vala_symbol_get_external_package (_tmp687_);
			_tmp689_ = _tmp688_;
			_tmp685_ = _tmp689_;
		} else {
			_tmp685_ = FALSE;
		}
		if (_tmp685_) {
			ValaSymbol* _tmp690_;
			ValaSourceReference* _tmp691_;
			ValaSourceReference* _tmp692_;
			ValaSourceFile* _tmp693_;
			ValaSourceFile* _tmp694_;
			const gchar* _tmp695_;
			const gchar* _tmp696_;
			gchar* _tmp697_;
			const gchar* _tmp698_;
			_tmp690_ = base_symbol;
			_tmp691_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp690_);
			_tmp692_ = _tmp691_;
			_tmp693_ = vala_source_reference_get_file (_tmp692_);
			_tmp694_ = _tmp693_;
			_tmp695_ = vala_source_file_get_package_name (_tmp694_);
			_tmp696_ = _tmp695_;
			_tmp697_ = g_strdup (_tmp696_);
			_g_free0 (base_type_package);
			base_type_package = _tmp697_;
			_tmp698_ = base_type_package;
			if (_tmp698_ != NULL) {
				const gchar* _tmp699_;
				gchar* _tmp700_;
				_tmp699_ = base_type_package;
				_tmp700_ = g_strdup_printf (" (%s)", _tmp699_);
				_g_free0 (base_type_package);
				base_type_package = _tmp700_;
			}
		}
		_tmp701_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp702_ = _tmp701_;
		_tmp703_ = self->priv->_member_name;
		_tmp704_ = base_type_name;
		_tmp705_ = base_type_package;
		_tmp706_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'%s", _tmp703_, _tmp704_, _tmp705_);
		_tmp707_ = _tmp706_;
		vala_report_error (_tmp702_, _tmp707_);
		_g_free0 (_tmp707_);
		_tmp708_ = vala_invalid_type_new ();
		_tmp709_ = _tmp708_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp709_);
		_vala_code_node_unref0 (_tmp709_);
		result = FALSE;
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		return result;
	} else {
		ValaSymbol* _tmp710_;
		ValaSymbol* _tmp711_;
		gboolean _tmp712_;
		gboolean _tmp713_;
		_tmp710_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp711_ = _tmp710_;
		_tmp712_ = vala_code_node_get_error ((ValaCodeNode*) _tmp711_);
		_tmp713_ = _tmp712_;
		if (_tmp713_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp714_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp715_ = _tmp714_;
	if (VALA_IS_SIGNAL (_tmp715_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp716_;
		ValaSymbol* _tmp717_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp724_;
		ValaCodeNode* _tmp725_;
		ValaCodeNode* _tmp726_;
		gboolean _tmp727_ = FALSE;
		gboolean _tmp728_ = FALSE;
		gboolean _tmp729_ = FALSE;
		ValaCodeNode* _tmp730_;
		_tmp716_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp717_ = _tmp716_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp717_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp718_;
			ValaCodeNode* _tmp719_;
			ValaCodeNode* _tmp720_;
			ValaCodeNode* _tmp721_;
			ValaCodeNode* _tmp722_;
			ValaCodeNode* _tmp723_;
			_tmp718_ = ma;
			_tmp719_ = vala_code_node_get_parent_node (_tmp718_);
			_tmp720_ = _tmp719_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp720_)) {
				break;
			}
			_tmp721_ = ma;
			_tmp722_ = vala_code_node_get_parent_node (_tmp721_);
			_tmp723_ = _tmp722_;
			ma = _tmp723_;
		}
		_tmp724_ = ma;
		_tmp725_ = vala_code_node_get_parent_node (_tmp724_);
		_tmp726_ = _tmp725_;
		parent = _tmp726_;
		_tmp730_ = parent;
		if (_tmp730_ != NULL) {
			ValaCodeNode* _tmp731_;
			_tmp731_ = parent;
			_tmp729_ = !VALA_IS_ELEMENT_ACCESS (_tmp731_);
		} else {
			_tmp729_ = FALSE;
		}
		if (_tmp729_) {
			ValaCodeNode* _tmp732_;
			ValaExpression* _tmp733_;
			ValaExpression* _tmp734_;
			_tmp732_ = ma;
			_tmp733_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp732_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp734_ = _tmp733_;
			_tmp728_ = !VALA_IS_BASE_ACCESS (_tmp734_);
		} else {
			_tmp728_ = FALSE;
		}
		if (_tmp728_) {
			gboolean _tmp735_ = FALSE;
			ValaCodeNode* _tmp736_;
			_tmp736_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp736_)) {
				_tmp735_ = TRUE;
			} else {
				ValaCodeNode* _tmp737_;
				ValaList* _tmp738_;
				_tmp737_ = parent;
				_tmp738_ = vala_method_call_get_argument_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp737_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp735_ = vala_collection_contains ((ValaCollection*) _tmp738_, (ValaExpression*) self);
			}
			_tmp727_ = _tmp735_;
		} else {
			_tmp727_ = FALSE;
		}
		if (_tmp727_) {
			ValaSignal* _tmp739_;
			ValaAttribute* _tmp740_;
			_tmp739_ = sig;
			_tmp740_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp739_, "HasEmitter");
			if (_tmp740_ != NULL) {
				ValaSignal* _tmp741_;
				ValaSignal* _tmp742_;
				ValaMethod* _tmp743_;
				ValaMethod* _tmp744_;
				_tmp741_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp741_, context)) {
					result = FALSE;
					return result;
				}
				_tmp742_ = sig;
				_tmp743_ = vala_signal_get_emitter (_tmp742_);
				_tmp744_ = _tmp743_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp744_);
			} else {
				ValaSourceReference* _tmp745_;
				ValaSourceReference* _tmp746_;
				ValaSymbol* _tmp747_;
				ValaSymbol* _tmp748_;
				gchar* _tmp749_;
				gchar* _tmp750_;
				gchar* _tmp751_;
				gchar* _tmp752_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp745_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp746_ = _tmp745_;
				_tmp747_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp748_ = _tmp747_;
				_tmp749_ = vala_symbol_get_full_name (_tmp748_);
				_tmp750_ = _tmp749_;
				_tmp751_ = g_strdup_printf ("Signal `%s' requires emitter in this context", _tmp750_);
				_tmp752_ = _tmp751_;
				vala_report_error (_tmp746_, _tmp752_);
				_g_free0 (_tmp752_);
				_g_free0 (_tmp750_);
				result = FALSE;
				return result;
			}
		}
	}
	_tmp753_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp754_ = _tmp753_;
	member = _tmp754_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp755_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp755_, context)) {
		result = FALSE;
		return result;
	}
	_tmp756_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp756_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp757_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp758_;
		ValaSymbol* _tmp759_;
		ValaSymbol* _tmp760_;
		gboolean _tmp761_ = FALSE;
		ValaBlock* _tmp762_;
		_tmp757_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp757_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp758_ = local;
		_tmp759_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp758_);
		_tmp760_ = _tmp759_;
		block = VALA_IS_BLOCK (_tmp760_) ? ((ValaBlock*) _tmp760_) : NULL;
		_tmp762_ = block;
		if (_tmp762_ != NULL) {
			ValaBlock* _tmp763_;
			ValaSymbol* _tmp764_;
			ValaSemanticAnalyzer* _tmp765_;
			ValaSemanticAnalyzer* _tmp766_;
			ValaSymbol* _tmp767_;
			ValaSymbol* _tmp768_;
			_tmp763_ = block;
			_tmp764_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp763_);
			_tmp765_ = vala_code_context_get_analyzer (context);
			_tmp766_ = _tmp765_;
			_tmp767_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp766_);
			_tmp768_ = _tmp767_;
			_tmp761_ = _tmp764_ != _tmp768_;
		} else {
			_tmp761_ = FALSE;
		}
		if (_tmp761_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp769_;
			ValaSemanticAnalyzer* _tmp770_;
			ValaSymbol* _tmp771_;
			ValaSymbol* _tmp772_;
			ValaLocalVariable* _tmp783_;
			ValaBlock* _tmp784_;
			ValaLocalVariable* _tmp785_;
			ValaDataType* _tmp786_;
			ValaDataType* _tmp787_;
			ValaTypeSymbol* _tmp788_;
			ValaTypeSymbol* _tmp789_;
			ValaSemanticAnalyzer* _tmp790_;
			ValaSemanticAnalyzer* _tmp791_;
			ValaDataType* _tmp792_;
			ValaTypeSymbol* _tmp793_;
			ValaTypeSymbol* _tmp794_;
			_tmp769_ = vala_code_context_get_analyzer (context);
			_tmp770_ = _tmp769_;
			_tmp771_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp770_);
			_tmp772_ = _tmp771_;
			sym = _tmp772_;
			while (TRUE) {
				ValaSymbol* _tmp773_;
				ValaBlock* _tmp774_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp775_;
				ValaMethod* _tmp776_;
				ValaSymbol* _tmp780_;
				ValaSymbol* _tmp781_;
				ValaSymbol* _tmp782_;
				_tmp773_ = sym;
				_tmp774_ = block;
				if (!(_tmp773_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp774_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp775_ = sym;
				method = VALA_IS_METHOD (_tmp775_) ? ((ValaMethod*) _tmp775_) : NULL;
				_tmp776_ = method;
				if (_tmp776_ != NULL) {
					ValaMethod* _tmp777_;
					ValaMethod* _tmp778_;
					ValaLocalVariable* _tmp779_;
					_tmp777_ = method;
					vala_method_set_closure (_tmp777_, TRUE);
					_tmp778_ = method;
					_tmp779_ = local;
					vala_method_add_captured_variable (_tmp778_, _tmp779_);
				}
				_tmp780_ = sym;
				_tmp781_ = vala_symbol_get_parent_symbol (_tmp780_);
				_tmp782_ = _tmp781_;
				sym = _tmp782_;
			}
			_tmp783_ = local;
			vala_local_variable_set_captured (_tmp783_, TRUE);
			_tmp784_ = block;
			vala_block_set_captured (_tmp784_, TRUE);
			_tmp785_ = local;
			_tmp786_ = vala_variable_get_variable_type ((ValaVariable*) _tmp785_);
			_tmp787_ = _tmp786_;
			_tmp788_ = vala_data_type_get_type_symbol (_tmp787_);
			_tmp789_ = _tmp788_;
			_tmp790_ = vala_code_context_get_analyzer (context);
			_tmp791_ = _tmp790_;
			_tmp792_ = _tmp791_->va_list_type;
			_tmp793_ = vala_data_type_get_type_symbol (_tmp792_);
			_tmp794_ = _tmp793_;
			if (_tmp789_ == _tmp794_) {
				ValaSourceReference* _tmp795_;
				ValaSourceReference* _tmp796_;
				ValaLocalVariable* _tmp797_;
				gchar* _tmp798_;
				gchar* _tmp799_;
				gchar* _tmp800_;
				gchar* _tmp801_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp795_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp796_ = _tmp795_;
				_tmp797_ = local;
				_tmp798_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp797_);
				_tmp799_ = _tmp798_;
				_tmp800_ = g_strdup_printf ("Capturing `va_list' variable `%s' is not allowed", _tmp799_);
				_tmp801_ = _tmp800_;
				vala_report_error (_tmp796_, _tmp801_);
				_g_free0 (_tmp801_);
				_g_free0 (_tmp799_);
			}
		}
	} else {
		ValaSymbol* _tmp802_;
		_tmp802_ = member;
		if (VALA_IS_PARAMETER (_tmp802_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp803_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp804_;
			ValaSymbol* _tmp805_;
			ValaSymbol* _tmp806_;
			gboolean _tmp807_ = FALSE;
			gboolean _tmp808_ = FALSE;
			ValaMethod* _tmp809_;
			_tmp803_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp803_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp804_ = param;
			_tmp805_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp804_);
			_tmp806_ = _tmp805_;
			m = VALA_IS_METHOD (_tmp806_) ? ((ValaMethod*) _tmp806_) : NULL;
			_tmp809_ = m;
			if (_tmp809_ != NULL) {
				ValaMethod* _tmp810_;
				ValaSemanticAnalyzer* _tmp811_;
				ValaSemanticAnalyzer* _tmp812_;
				ValaSymbol* _tmp813_;
				ValaSymbol* _tmp814_;
				_tmp810_ = m;
				_tmp811_ = vala_code_context_get_analyzer (context);
				_tmp812_ = _tmp811_;
				_tmp813_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp812_);
				_tmp814_ = _tmp813_;
				_tmp808_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp810_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp814_;
			} else {
				_tmp808_ = FALSE;
			}
			if (_tmp808_) {
				ValaParameter* _tmp815_;
				ValaMethod* _tmp816_;
				ValaParameter* _tmp817_;
				ValaParameter* _tmp818_;
				_tmp815_ = param;
				_tmp816_ = m;
				_tmp817_ = vala_method_get_this_parameter (_tmp816_);
				_tmp818_ = _tmp817_;
				_tmp807_ = _tmp815_ != _tmp818_;
			} else {
				_tmp807_ = FALSE;
			}
			if (_tmp807_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp819_;
				ValaSemanticAnalyzer* _tmp820_;
				ValaSymbol* _tmp821_;
				ValaSymbol* _tmp822_;
				ValaParameter* _tmp831_;
				ValaMethod* _tmp832_;
				ValaBlock* _tmp833_;
				ValaBlock* _tmp834_;
				ValaParameter* _tmp835_;
				ValaParameterDirection _tmp836_;
				ValaParameterDirection _tmp837_;
				ValaParameter* _tmp845_;
				ValaDataType* _tmp846_;
				ValaDataType* _tmp847_;
				ValaTypeSymbol* _tmp848_;
				ValaTypeSymbol* _tmp849_;
				ValaSemanticAnalyzer* _tmp850_;
				ValaSemanticAnalyzer* _tmp851_;
				ValaDataType* _tmp852_;
				ValaTypeSymbol* _tmp853_;
				ValaTypeSymbol* _tmp854_;
				_tmp819_ = vala_code_context_get_analyzer (context);
				_tmp820_ = _tmp819_;
				_tmp821_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp820_);
				_tmp822_ = _tmp821_;
				sym = _tmp822_;
				while (TRUE) {
					ValaSymbol* _tmp823_;
					ValaMethod* _tmp824_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp825_;
					ValaMethod* _tmp826_;
					ValaSymbol* _tmp828_;
					ValaSymbol* _tmp829_;
					ValaSymbol* _tmp830_;
					_tmp823_ = sym;
					_tmp824_ = m;
					if (!(_tmp823_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp824_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp825_ = sym;
					method = VALA_IS_METHOD (_tmp825_) ? ((ValaMethod*) _tmp825_) : NULL;
					_tmp826_ = method;
					if (_tmp826_ != NULL) {
						ValaMethod* _tmp827_;
						_tmp827_ = method;
						vala_method_set_closure (_tmp827_, TRUE);
					}
					_tmp828_ = sym;
					_tmp829_ = vala_symbol_get_parent_symbol (_tmp828_);
					_tmp830_ = _tmp829_;
					sym = _tmp830_;
				}
				_tmp831_ = param;
				vala_parameter_set_captured (_tmp831_, TRUE);
				_tmp832_ = m;
				_tmp833_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp832_);
				_tmp834_ = _tmp833_;
				vala_block_set_captured (_tmp834_, TRUE);
				_tmp835_ = param;
				_tmp836_ = vala_parameter_get_direction (_tmp835_);
				_tmp837_ = _tmp836_;
				if (_tmp837_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp838_;
					ValaSourceReference* _tmp839_;
					ValaParameter* _tmp840_;
					gchar* _tmp841_;
					gchar* _tmp842_;
					gchar* _tmp843_;
					gchar* _tmp844_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp838_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp839_ = _tmp838_;
					_tmp840_ = param;
					_tmp841_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp840_);
					_tmp842_ = _tmp841_;
					_tmp843_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp842_);
					_tmp844_ = _tmp843_;
					vala_report_error (_tmp839_, _tmp844_);
					_g_free0 (_tmp844_);
					_g_free0 (_tmp842_);
				}
				_tmp845_ = param;
				_tmp846_ = vala_variable_get_variable_type ((ValaVariable*) _tmp845_);
				_tmp847_ = _tmp846_;
				_tmp848_ = vala_data_type_get_type_symbol (_tmp847_);
				_tmp849_ = _tmp848_;
				_tmp850_ = vala_code_context_get_analyzer (context);
				_tmp851_ = _tmp850_;
				_tmp852_ = _tmp851_->va_list_type;
				_tmp853_ = vala_data_type_get_type_symbol (_tmp852_);
				_tmp854_ = _tmp853_;
				if (_tmp849_ == _tmp854_) {
					ValaSourceReference* _tmp855_;
					ValaSourceReference* _tmp856_;
					ValaParameter* _tmp857_;
					gchar* _tmp858_;
					gchar* _tmp859_;
					gchar* _tmp860_;
					gchar* _tmp861_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp855_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp856_ = _tmp855_;
					_tmp857_ = param;
					_tmp858_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp857_);
					_tmp859_ = _tmp858_;
					_tmp860_ = g_strdup_printf ("Capturing `va_list' parameter `%s' is not allowed", _tmp859_);
					_tmp861_ = _tmp860_;
					vala_report_error (_tmp856_, _tmp861_);
					_g_free0 (_tmp861_);
					_g_free0 (_tmp859_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp862_;
				ValaSymbol* _tmp863_;
				ValaSymbol* _tmp864_;
				ValaSymbol* _tmp865_;
				ValaSymbol* _tmp866_;
				gboolean _tmp867_ = FALSE;
				gboolean _tmp868_ = FALSE;
				ValaPropertyAccessor* _tmp869_;
				_tmp862_ = param;
				_tmp863_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp862_);
				_tmp864_ = _tmp863_;
				_tmp865_ = vala_symbol_get_parent_symbol (_tmp864_);
				_tmp866_ = _tmp865_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp866_) ? ((ValaPropertyAccessor*) _tmp866_) : NULL;
				_tmp869_ = acc;
				if (_tmp869_ != NULL) {
					ValaPropertyAccessor* _tmp870_;
					ValaSemanticAnalyzer* _tmp871_;
					ValaSemanticAnalyzer* _tmp872_;
					ValaSymbol* _tmp873_;
					ValaSymbol* _tmp874_;
					_tmp870_ = acc;
					_tmp871_ = vala_code_context_get_analyzer (context);
					_tmp872_ = _tmp871_;
					_tmp873_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp872_);
					_tmp874_ = _tmp873_;
					_tmp868_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp870_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp874_;
				} else {
					_tmp868_ = FALSE;
				}
				if (_tmp868_) {
					ValaParameter* _tmp875_;
					ValaPropertyAccessor* _tmp876_;
					ValaProperty* _tmp877_;
					ValaProperty* _tmp878_;
					ValaParameter* _tmp879_;
					ValaParameter* _tmp880_;
					_tmp875_ = param;
					_tmp876_ = acc;
					_tmp877_ = vala_property_accessor_get_prop (_tmp876_);
					_tmp878_ = _tmp877_;
					_tmp879_ = vala_property_get_this_parameter (_tmp878_);
					_tmp880_ = _tmp879_;
					_tmp867_ = _tmp875_ != _tmp880_;
				} else {
					_tmp867_ = FALSE;
				}
				if (_tmp867_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp881_;
					ValaSemanticAnalyzer* _tmp882_;
					ValaSymbol* _tmp883_;
					ValaSymbol* _tmp884_;
					ValaParameter* _tmp893_;
					ValaPropertyAccessor* _tmp894_;
					ValaBlock* _tmp895_;
					ValaBlock* _tmp896_;
					_tmp881_ = vala_code_context_get_analyzer (context);
					_tmp882_ = _tmp881_;
					_tmp883_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp882_);
					_tmp884_ = _tmp883_;
					sym = _tmp884_;
					while (TRUE) {
						ValaSymbol* _tmp885_;
						ValaMethod* _tmp886_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp887_;
						ValaMethod* _tmp888_;
						ValaSymbol* _tmp890_;
						ValaSymbol* _tmp891_;
						ValaSymbol* _tmp892_;
						_tmp885_ = sym;
						_tmp886_ = m;
						if (!(_tmp885_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp886_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp887_ = sym;
						method = VALA_IS_METHOD (_tmp887_) ? ((ValaMethod*) _tmp887_) : NULL;
						_tmp888_ = method;
						if (_tmp888_ != NULL) {
							ValaMethod* _tmp889_;
							_tmp889_ = method;
							vala_method_set_closure (_tmp889_, TRUE);
						}
						_tmp890_ = sym;
						_tmp891_ = vala_symbol_get_parent_symbol (_tmp890_);
						_tmp892_ = _tmp891_;
						sym = _tmp892_;
					}
					_tmp893_ = param;
					vala_parameter_set_captured (_tmp893_, TRUE);
					_tmp894_ = acc;
					_tmp895_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp894_);
					_tmp896_ = _tmp895_;
					vala_block_set_captured (_tmp896_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp897_;
			_tmp897_ = member;
			if (VALA_IS_FIELD (_tmp897_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp898_;
				ValaField* _tmp899_;
				ValaSymbolAccessibility _tmp900_;
				ValaSymbolAccessibility _tmp901_;
				ValaField* _tmp902_;
				ValaMemberBinding _tmp903_;
				ValaMemberBinding _tmp904_;
				ValaField* _tmp905_;
				ValaMemberBinding _tmp906_;
				ValaMemberBinding _tmp907_;
				ValaField* _tmp908_;
				ValaDataType* _tmp909_;
				ValaDataType* _tmp910_;
				_tmp898_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp898_, VALA_TYPE_FIELD, ValaField);
				_tmp899_ = f;
				_tmp900_ = vala_symbol_get_access ((ValaSymbol*) _tmp899_);
				_tmp901_ = _tmp900_;
				access = _tmp901_;
				_tmp902_ = f;
				_tmp903_ = vala_field_get_binding (_tmp902_);
				_tmp904_ = _tmp903_;
				instance = _tmp904_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp905_ = f;
				_tmp906_ = vala_field_get_binding (_tmp905_);
				_tmp907_ = _tmp906_;
				klass = _tmp907_ == VALA_MEMBER_BINDING_CLASS;
				_tmp908_ = f;
				_tmp909_ = vala_variable_get_variable_type ((ValaVariable*) _tmp908_);
				_tmp910_ = _tmp909_;
				if (VALA_IS_GENERIC_TYPE (_tmp910_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp911_;
				_tmp911_ = member;
				if (VALA_IS_CONSTANT (_tmp911_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp912_;
					ValaConstant* _tmp913_;
					ValaSymbolAccessibility _tmp914_;
					ValaSymbolAccessibility _tmp915_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp916_;
					ValaSymbol* _tmp917_;
					ValaSymbol* _tmp918_;
					gboolean _tmp919_ = FALSE;
					ValaBlock* _tmp920_;
					_tmp912_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp912_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp913_ = c;
					_tmp914_ = vala_symbol_get_access ((ValaSymbol*) _tmp913_);
					_tmp915_ = _tmp914_;
					access = _tmp915_;
					_tmp916_ = c;
					_tmp917_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp916_);
					_tmp918_ = _tmp917_;
					block = VALA_IS_BLOCK (_tmp918_) ? ((ValaBlock*) _tmp918_) : NULL;
					_tmp920_ = block;
					if (_tmp920_ != NULL) {
						ValaBlock* _tmp921_;
						ValaSymbol* _tmp922_;
						ValaSemanticAnalyzer* _tmp923_;
						ValaSemanticAnalyzer* _tmp924_;
						ValaSymbol* _tmp925_;
						ValaSymbol* _tmp926_;
						_tmp921_ = block;
						_tmp922_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp921_);
						_tmp923_ = vala_code_context_get_analyzer (context);
						_tmp924_ = _tmp923_;
						_tmp925_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp924_);
						_tmp926_ = _tmp925_;
						_tmp919_ = _tmp922_ != _tmp926_;
					} else {
						_tmp919_ = FALSE;
					}
					if (_tmp919_) {
						ValaSourceReference* _tmp927_;
						ValaSourceReference* _tmp928_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp927_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp928_ = _tmp927_;
						vala_report_error (_tmp928_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						return result;
					}
				} else {
					ValaSymbol* _tmp929_;
					_tmp929_ = member;
					if (VALA_IS_METHOD (_tmp929_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp930_;
						ValaMethod* _tmp931_;
						gboolean _tmp932_;
						gboolean _tmp933_;
						ValaMethod* _tmp1022_;
						ValaSymbolAccessibility _tmp1023_;
						ValaSymbolAccessibility _tmp1024_;
						ValaMethod* _tmp1025_;
						ValaMethod* _tmp1029_;
						ValaMemberBinding _tmp1030_;
						ValaMemberBinding _tmp1031_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1052_;
						ValaDataType* _tmp1053_;
						ValaDataType* _tmp1054_;
						gboolean _tmp1055_ = FALSE;
						ValaGenericType* _tmp1056_;
						_tmp930_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp930_, VALA_TYPE_METHOD, ValaMethod);
						_tmp931_ = m;
						_tmp932_ = vala_method_get_is_async_callback (_tmp931_);
						_tmp933_ = _tmp932_;
						if (_tmp933_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp934_;
							ValaSemanticAnalyzer* _tmp935_;
							ValaMethod* _tmp936_;
							ValaMethod* _tmp937_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp938_;
							ValaMethod* _tmp967_;
							ValaSemanticAnalyzer* _tmp968_;
							ValaSemanticAnalyzer* _tmp969_;
							ValaMethod* _tmp970_;
							ValaMethod* _tmp971_;
							ValaMethod* _tmp987_;
							ValaMethod* _tmp988_;
							ValaMethod* _tmp989_;
							ValaSymbol* _tmp990_;
							ValaSymbol* _tmp991_;
							_tmp934_ = vala_code_context_get_analyzer (context);
							_tmp935_ = _tmp934_;
							_tmp936_ = vala_semantic_analyzer_get_current_async_method (_tmp935_);
							_tmp937_ = _tmp936_;
							async_method = _tmp937_;
							is_valid_access = FALSE;
							_tmp938_ = async_method;
							if (_tmp938_ != NULL) {
								ValaMethod* _tmp939_;
								ValaMethod* _tmp940_;
								ValaMethod* _tmp941_;
								_tmp939_ = m;
								_tmp940_ = async_method;
								_tmp941_ = vala_method_get_callback_method (_tmp940_);
								if (_tmp939_ == _tmp941_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp942_ = FALSE;
									ValaMethod* _tmp943_;
									ValaMethod* _tmp944_;
									ValaMethod* _tmp945_;
									_tmp943_ = async_method;
									_tmp944_ = vala_method_get_base_method (_tmp943_);
									_tmp945_ = _tmp944_;
									if (_tmp945_ != NULL) {
										ValaMethod* _tmp946_;
										ValaMethod* _tmp947_;
										ValaMethod* _tmp948_;
										ValaMethod* _tmp949_;
										ValaMethod* _tmp950_;
										_tmp946_ = m;
										_tmp947_ = async_method;
										_tmp948_ = vala_method_get_base_method (_tmp947_);
										_tmp949_ = _tmp948_;
										_tmp950_ = vala_method_get_callback_method (_tmp949_);
										_tmp942_ = _tmp946_ == _tmp950_;
									} else {
										_tmp942_ = FALSE;
									}
									if (_tmp942_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp951_ = FALSE;
										ValaMethod* _tmp952_;
										ValaMethod* _tmp953_;
										ValaMethod* _tmp954_;
										_tmp952_ = async_method;
										_tmp953_ = vala_method_get_base_interface_method (_tmp952_);
										_tmp954_ = _tmp953_;
										if (_tmp954_ != NULL) {
											ValaMethod* _tmp955_;
											ValaMethod* _tmp956_;
											ValaMethod* _tmp957_;
											ValaMethod* _tmp958_;
											ValaMethod* _tmp959_;
											_tmp955_ = m;
											_tmp956_ = async_method;
											_tmp957_ = vala_method_get_base_interface_method (_tmp956_);
											_tmp958_ = _tmp957_;
											_tmp959_ = vala_method_get_callback_method (_tmp958_);
											_tmp951_ = _tmp955_ == _tmp959_;
										} else {
											_tmp951_ = FALSE;
										}
										if (_tmp951_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp960_;
								ValaSourceReference* _tmp961_;
								ValaMethod* _tmp962_;
								gchar* _tmp963_;
								gchar* _tmp964_;
								gchar* _tmp965_;
								gchar* _tmp966_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp960_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp961_ = _tmp960_;
								_tmp962_ = m;
								_tmp963_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp962_);
								_tmp964_ = _tmp963_;
								_tmp965_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp964_);
								_tmp966_ = _tmp965_;
								vala_report_error (_tmp961_, _tmp966_);
								_g_free0 (_tmp966_);
								_g_free0 (_tmp964_);
								result = FALSE;
								return result;
							}
							_tmp967_ = async_method;
							_tmp968_ = vala_code_context_get_analyzer (context);
							_tmp969_ = _tmp968_;
							_tmp970_ = vala_semantic_analyzer_get_current_method (_tmp969_);
							_tmp971_ = _tmp970_;
							if (_tmp967_ != _tmp971_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp972_;
								ValaSemanticAnalyzer* _tmp973_;
								ValaMethod* _tmp974_;
								ValaMethod* _tmp975_;
								ValaMethod* _tmp984_;
								ValaBlock* _tmp985_;
								ValaBlock* _tmp986_;
								_tmp972_ = vala_code_context_get_analyzer (context);
								_tmp973_ = _tmp972_;
								_tmp974_ = vala_semantic_analyzer_get_current_method (_tmp973_);
								_tmp975_ = _tmp974_;
								sym = (ValaSymbol*) _tmp975_;
								while (TRUE) {
									ValaSymbol* _tmp976_;
									ValaMethod* _tmp977_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp978_;
									ValaMethod* _tmp979_;
									ValaSymbol* _tmp981_;
									ValaSymbol* _tmp982_;
									ValaSymbol* _tmp983_;
									_tmp976_ = sym;
									_tmp977_ = async_method;
									if (!(_tmp976_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp977_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp978_ = sym;
									method = VALA_IS_METHOD (_tmp978_) ? ((ValaMethod*) _tmp978_) : NULL;
									_tmp979_ = method;
									if (_tmp979_ != NULL) {
										ValaMethod* _tmp980_;
										_tmp980_ = method;
										vala_method_set_closure (_tmp980_, TRUE);
									}
									_tmp981_ = sym;
									_tmp982_ = vala_symbol_get_parent_symbol (_tmp981_);
									_tmp983_ = _tmp982_;
									sym = _tmp983_;
								}
								_tmp984_ = async_method;
								_tmp985_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp984_);
								_tmp986_ = _tmp985_;
								vala_block_set_captured (_tmp986_, TRUE);
							}
							_tmp987_ = async_method;
							_tmp988_ = vala_method_get_callback_method (_tmp987_);
							m = _tmp988_;
							_tmp989_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp989_);
							_tmp990_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp991_ = _tmp990_;
							member = _tmp991_;
						} else {
							ValaMethod* _tmp992_;
							ValaMethod* _tmp993_;
							ValaMethod* _tmp994_;
							_tmp992_ = m;
							_tmp993_ = vala_method_get_base_method (_tmp992_);
							_tmp994_ = _tmp993_;
							if (_tmp994_ != NULL) {
								ValaMethod* _tmp995_;
								ValaMethod* _tmp996_;
								ValaMethod* _tmp997_;
								ValaMethod* _tmp998_;
								ValaSignal* _tmp999_;
								ValaSignal* _tmp1000_;
								ValaSymbol* _tmp1005_;
								ValaSymbol* _tmp1006_;
								_tmp995_ = m;
								_tmp996_ = vala_method_get_base_method (_tmp995_);
								_tmp997_ = _tmp996_;
								m = _tmp997_;
								_tmp998_ = m;
								_tmp999_ = vala_method_get_signal_reference (_tmp998_);
								_tmp1000_ = _tmp999_;
								if (_tmp1000_ != NULL) {
									ValaMethod* _tmp1001_;
									ValaSignal* _tmp1002_;
									ValaSignal* _tmp1003_;
									_tmp1001_ = m;
									_tmp1002_ = vala_method_get_signal_reference (_tmp1001_);
									_tmp1003_ = _tmp1002_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1003_);
								} else {
									ValaMethod* _tmp1004_;
									_tmp1004_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1004_);
								}
								_tmp1005_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1006_ = _tmp1005_;
								member = _tmp1006_;
							} else {
								ValaMethod* _tmp1007_;
								ValaMethod* _tmp1008_;
								ValaMethod* _tmp1009_;
								_tmp1007_ = m;
								_tmp1008_ = vala_method_get_base_interface_method (_tmp1007_);
								_tmp1009_ = _tmp1008_;
								if (_tmp1009_ != NULL) {
									ValaMethod* _tmp1010_;
									ValaMethod* _tmp1011_;
									ValaMethod* _tmp1012_;
									ValaMethod* _tmp1013_;
									ValaSignal* _tmp1014_;
									ValaSignal* _tmp1015_;
									ValaSymbol* _tmp1020_;
									ValaSymbol* _tmp1021_;
									_tmp1010_ = m;
									_tmp1011_ = vala_method_get_base_interface_method (_tmp1010_);
									_tmp1012_ = _tmp1011_;
									m = _tmp1012_;
									_tmp1013_ = m;
									_tmp1014_ = vala_method_get_signal_reference (_tmp1013_);
									_tmp1015_ = _tmp1014_;
									if (_tmp1015_ != NULL) {
										ValaMethod* _tmp1016_;
										ValaSignal* _tmp1017_;
										ValaSignal* _tmp1018_;
										_tmp1016_ = m;
										_tmp1017_ = vala_method_get_signal_reference (_tmp1016_);
										_tmp1018_ = _tmp1017_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1018_);
									} else {
										ValaMethod* _tmp1019_;
										_tmp1019_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1019_);
									}
									_tmp1020_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1021_ = _tmp1020_;
									member = _tmp1021_;
								}
							}
						}
						_tmp1022_ = m;
						_tmp1023_ = vala_symbol_get_access ((ValaSymbol*) _tmp1022_);
						_tmp1024_ = _tmp1023_;
						access = _tmp1024_;
						_tmp1025_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1025_)) {
							ValaMethod* _tmp1026_;
							ValaMemberBinding _tmp1027_;
							ValaMemberBinding _tmp1028_;
							_tmp1026_ = m;
							_tmp1027_ = vala_method_get_binding (_tmp1026_);
							_tmp1028_ = _tmp1027_;
							instance = _tmp1028_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1029_ = m;
						_tmp1030_ = vala_method_get_binding (_tmp1029_);
						_tmp1031_ = _tmp1030_;
						klass = _tmp1031_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1032_;
							ValaList* _tmp1033_;
							ValaList* _tmp1034_;
							gint _param_size = 0;
							ValaList* _tmp1035_;
							gint _tmp1036_;
							gint _tmp1037_;
							gint _param_index = 0;
							_tmp1032_ = m;
							_tmp1033_ = vala_callable_get_parameters ((ValaCallable*) _tmp1032_);
							_tmp1034_ = _vala_iterable_ref0 (_tmp1033_);
							_param_list = _tmp1034_;
							_tmp1035_ = _param_list;
							_tmp1036_ = vala_collection_get_size ((ValaCollection*) _tmp1035_);
							_tmp1037_ = _tmp1036_;
							_param_size = _tmp1037_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1038_;
								gint _tmp1039_;
								ValaParameter* param = NULL;
								ValaList* _tmp1040_;
								gpointer _tmp1041_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1042_;
								ValaDataType* _tmp1043_;
								ValaDataType* _tmp1044_;
								gboolean _tmp1045_ = FALSE;
								ValaGenericType* _tmp1046_;
								_param_index = _param_index + 1;
								_tmp1038_ = _param_index;
								_tmp1039_ = _param_size;
								if (!(_tmp1038_ < _tmp1039_)) {
									break;
								}
								_tmp1040_ = _param_list;
								_tmp1041_ = vala_list_get (_tmp1040_, _param_index);
								param = (ValaParameter*) _tmp1041_;
								_tmp1042_ = param;
								_tmp1043_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1042_);
								_tmp1044_ = _tmp1043_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1044_) ? ((ValaGenericType*) _tmp1044_) : NULL;
								_tmp1046_ = generic_type;
								if (_tmp1046_ != NULL) {
									ValaGenericType* _tmp1047_;
									ValaTypeParameter* _tmp1048_;
									ValaTypeParameter* _tmp1049_;
									ValaSymbol* _tmp1050_;
									ValaSymbol* _tmp1051_;
									_tmp1047_ = generic_type;
									_tmp1048_ = vala_generic_type_get_type_parameter (_tmp1047_);
									_tmp1049_ = _tmp1048_;
									_tmp1050_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1049_);
									_tmp1051_ = _tmp1050_;
									_tmp1045_ = VALA_IS_TYPESYMBOL (_tmp1051_);
								} else {
									_tmp1045_ = FALSE;
								}
								if (_tmp1045_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp1052_ = m;
						_tmp1053_ = vala_callable_get_return_type ((ValaCallable*) _tmp1052_);
						_tmp1054_ = _tmp1053_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1054_) ? ((ValaGenericType*) _tmp1054_) : NULL;
						_tmp1056_ = generic_type;
						if (_tmp1056_ != NULL) {
							ValaGenericType* _tmp1057_;
							ValaTypeParameter* _tmp1058_;
							ValaTypeParameter* _tmp1059_;
							ValaSymbol* _tmp1060_;
							ValaSymbol* _tmp1061_;
							_tmp1057_ = generic_type;
							_tmp1058_ = vala_generic_type_get_type_parameter (_tmp1057_);
							_tmp1059_ = _tmp1058_;
							_tmp1060_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1059_);
							_tmp1061_ = _tmp1060_;
							_tmp1055_ = VALA_IS_TYPESYMBOL (_tmp1061_);
						} else {
							_tmp1055_ = FALSE;
						}
						if (_tmp1055_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1062_;
						_tmp1062_ = member;
						if (VALA_IS_PROPERTY (_tmp1062_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1063_;
							ValaProperty* _tmp1064_;
							ValaProperty* _tmp1065_;
							ValaProperty* _tmp1066_;
							ValaProperty* _tmp1067_;
							ValaProperty* _tmp1083_;
							ValaSymbolAccessibility _tmp1084_;
							ValaSymbolAccessibility _tmp1085_;
							gboolean _tmp1086_;
							gboolean _tmp1087_;
							ValaProperty* _tmp1192_;
							ValaMemberBinding _tmp1193_;
							ValaMemberBinding _tmp1194_;
							ValaProperty* _tmp1195_;
							ValaDataType* _tmp1196_;
							ValaDataType* _tmp1197_;
							_tmp1063_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1063_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1064_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1064_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								return result;
							}
							_tmp1065_ = prop;
							_tmp1066_ = vala_property_get_base_property (_tmp1065_);
							_tmp1067_ = _tmp1066_;
							if (_tmp1067_ != NULL) {
								ValaProperty* _tmp1068_;
								ValaProperty* _tmp1069_;
								ValaProperty* _tmp1070_;
								ValaProperty* _tmp1071_;
								ValaSymbol* _tmp1072_;
								ValaSymbol* _tmp1073_;
								_tmp1068_ = prop;
								_tmp1069_ = vala_property_get_base_property (_tmp1068_);
								_tmp1070_ = _tmp1069_;
								prop = _tmp1070_;
								_tmp1071_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1071_);
								_tmp1072_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1073_ = _tmp1072_;
								member = _tmp1073_;
							} else {
								ValaProperty* _tmp1074_;
								ValaProperty* _tmp1075_;
								ValaProperty* _tmp1076_;
								_tmp1074_ = prop;
								_tmp1075_ = vala_property_get_base_interface_property (_tmp1074_);
								_tmp1076_ = _tmp1075_;
								if (_tmp1076_ != NULL) {
									ValaProperty* _tmp1077_;
									ValaProperty* _tmp1078_;
									ValaProperty* _tmp1079_;
									ValaProperty* _tmp1080_;
									ValaSymbol* _tmp1081_;
									ValaSymbol* _tmp1082_;
									_tmp1077_ = prop;
									_tmp1078_ = vala_property_get_base_interface_property (_tmp1077_);
									_tmp1079_ = _tmp1078_;
									prop = _tmp1079_;
									_tmp1080_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1080_);
									_tmp1081_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1082_ = _tmp1081_;
									member = _tmp1082_;
								}
							}
							_tmp1083_ = prop;
							_tmp1084_ = vala_symbol_get_access ((ValaSymbol*) _tmp1083_);
							_tmp1085_ = _tmp1084_;
							access = _tmp1085_;
							_tmp1086_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1087_ = _tmp1086_;
							if (_tmp1087_) {
								ValaProperty* _tmp1088_;
								ValaPropertyAccessor* _tmp1089_;
								ValaPropertyAccessor* _tmp1090_;
								ValaProperty* _tmp1138_;
								ValaSymbolAccessibility _tmp1139_;
								ValaSymbolAccessibility _tmp1140_;
								_tmp1088_ = prop;
								_tmp1089_ = vala_property_get_set_accessor (_tmp1088_);
								_tmp1090_ = _tmp1089_;
								if (_tmp1090_ == NULL) {
									ValaSourceReference* _tmp1091_;
									ValaSourceReference* _tmp1092_;
									ValaProperty* _tmp1093_;
									gchar* _tmp1094_;
									gchar* _tmp1095_;
									gchar* _tmp1096_;
									gchar* _tmp1097_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1091_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1092_ = _tmp1091_;
									_tmp1093_ = prop;
									_tmp1094_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1093_);
									_tmp1095_ = _tmp1094_;
									_tmp1096_ = g_strdup_printf ("Property `%s' is read-only", _tmp1095_);
									_tmp1097_ = _tmp1096_;
									vala_report_error (_tmp1092_, _tmp1097_);
									_g_free0 (_tmp1097_);
									_g_free0 (_tmp1095_);
									result = FALSE;
									return result;
								} else {
									gboolean _tmp1098_ = FALSE;
									ValaProperty* _tmp1099_;
									ValaPropertyAccessor* _tmp1100_;
									ValaPropertyAccessor* _tmp1101_;
									gboolean _tmp1102_;
									gboolean _tmp1103_;
									_tmp1099_ = prop;
									_tmp1100_ = vala_property_get_set_accessor (_tmp1099_);
									_tmp1101_ = _tmp1100_;
									_tmp1102_ = vala_property_accessor_get_writable (_tmp1101_);
									_tmp1103_ = _tmp1102_;
									if (!_tmp1103_) {
										ValaProperty* _tmp1104_;
										ValaPropertyAccessor* _tmp1105_;
										ValaPropertyAccessor* _tmp1106_;
										gboolean _tmp1107_;
										gboolean _tmp1108_;
										_tmp1104_ = prop;
										_tmp1105_ = vala_property_get_set_accessor (_tmp1104_);
										_tmp1106_ = _tmp1105_;
										_tmp1107_ = vala_property_accessor_get_construction (_tmp1106_);
										_tmp1108_ = _tmp1107_;
										_tmp1098_ = _tmp1108_;
									} else {
										_tmp1098_ = FALSE;
									}
									if (_tmp1098_) {
										ValaSemanticAnalyzer* _tmp1109_;
										ValaSemanticAnalyzer* _tmp1110_;
										ValaMethod* _tmp1111_;
										_tmp1109_ = vala_code_context_get_analyzer (context);
										_tmp1110_ = _tmp1109_;
										_tmp1111_ = vala_semantic_analyzer_find_current_method (_tmp1110_);
										if (VALA_IS_CREATION_METHOD (_tmp1111_)) {
											ValaSourceReference* _tmp1112_;
											ValaSourceReference* _tmp1113_;
											vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
											_tmp1112_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
											_tmp1113_ = _tmp1112_;
											vala_report_error (_tmp1113_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
											result = FALSE;
											return result;
										} else {
											ValaSemanticAnalyzer* _tmp1114_;
											ValaSemanticAnalyzer* _tmp1115_;
											_tmp1114_ = vala_code_context_get_analyzer (context);
											_tmp1115_ = _tmp1114_;
											if (vala_semantic_analyzer_is_in_constructor (_tmp1115_)) {
												ValaSemanticAnalyzer* _tmp1116_;
												ValaSemanticAnalyzer* _tmp1117_;
												ValaTypeSymbol* _tmp1118_;
												ValaTypeSymbol* _tmp1119_;
												ValaProperty* _tmp1120_;
												ValaSymbol* _tmp1121_;
												ValaSymbol* _tmp1122_;
												_tmp1116_ = vala_code_context_get_analyzer (context);
												_tmp1117_ = _tmp1116_;
												_tmp1118_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1117_);
												_tmp1119_ = _tmp1118_;
												_tmp1120_ = prop;
												_tmp1121_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1120_);
												_tmp1122_ = _tmp1121_;
												if (!vala_typesymbol_is_subtype_of (_tmp1119_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1122_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))) {
													ValaSourceReference* _tmp1123_;
													ValaSourceReference* _tmp1124_;
													ValaProperty* _tmp1125_;
													gchar* _tmp1126_;
													gchar* _tmp1127_;
													ValaSemanticAnalyzer* _tmp1128_;
													ValaSemanticAnalyzer* _tmp1129_;
													ValaTypeSymbol* _tmp1130_;
													ValaTypeSymbol* _tmp1131_;
													gchar* _tmp1132_;
													gchar* _tmp1133_;
													gchar* _tmp1134_;
													gchar* _tmp1135_;
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													_tmp1123_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1124_ = _tmp1123_;
													_tmp1125_ = prop;
													_tmp1126_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1125_);
													_tmp1127_ = _tmp1126_;
													_tmp1128_ = vala_code_context_get_analyzer (context);
													_tmp1129_ = _tmp1128_;
													_tmp1130_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1129_);
													_tmp1131_ = _tmp1130_;
													_tmp1132_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1131_);
													_tmp1133_ = _tmp1132_;
													_tmp1134_ = g_strdup_printf ("Cannot assign to construct-only property `%s' in `construct' of `%s'", _tmp1127_, _tmp1133_);
													_tmp1135_ = _tmp1134_;
													vala_report_error (_tmp1124_, _tmp1135_);
													_g_free0 (_tmp1135_);
													_g_free0 (_tmp1133_);
													_g_free0 (_tmp1127_);
													result = FALSE;
													return result;
												}
											} else {
												ValaSourceReference* _tmp1136_;
												ValaSourceReference* _tmp1137_;
												vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
												_tmp1136_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1137_ = _tmp1136_;
												vala_report_error (_tmp1137_, "Cannot assign to construct-only property in this context");
												result = FALSE;
												return result;
											}
										}
									}
								}
								_tmp1138_ = prop;
								_tmp1139_ = vala_symbol_get_access ((ValaSymbol*) _tmp1138_);
								_tmp1140_ = _tmp1139_;
								if (_tmp1140_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1141_;
									ValaPropertyAccessor* _tmp1142_;
									ValaPropertyAccessor* _tmp1143_;
									ValaSymbolAccessibility _tmp1144_;
									ValaSymbolAccessibility _tmp1145_;
									_tmp1141_ = prop;
									_tmp1142_ = vala_property_get_set_accessor (_tmp1141_);
									_tmp1143_ = _tmp1142_;
									_tmp1144_ = vala_symbol_get_access ((ValaSymbol*) _tmp1143_);
									_tmp1145_ = _tmp1144_;
									access = _tmp1145_;
								} else {
									gboolean _tmp1146_ = FALSE;
									ValaProperty* _tmp1147_;
									ValaSymbolAccessibility _tmp1148_;
									ValaSymbolAccessibility _tmp1149_;
									_tmp1147_ = prop;
									_tmp1148_ = vala_symbol_get_access ((ValaSymbol*) _tmp1147_);
									_tmp1149_ = _tmp1148_;
									if (_tmp1149_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1150_;
										ValaPropertyAccessor* _tmp1151_;
										ValaPropertyAccessor* _tmp1152_;
										ValaSymbolAccessibility _tmp1153_;
										ValaSymbolAccessibility _tmp1154_;
										_tmp1150_ = prop;
										_tmp1151_ = vala_property_get_set_accessor (_tmp1150_);
										_tmp1152_ = _tmp1151_;
										_tmp1153_ = vala_symbol_get_access ((ValaSymbol*) _tmp1152_);
										_tmp1154_ = _tmp1153_;
										_tmp1146_ = _tmp1154_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1146_ = FALSE;
									}
									if (_tmp1146_) {
										ValaProperty* _tmp1155_;
										ValaPropertyAccessor* _tmp1156_;
										ValaPropertyAccessor* _tmp1157_;
										ValaSymbolAccessibility _tmp1158_;
										ValaSymbolAccessibility _tmp1159_;
										_tmp1155_ = prop;
										_tmp1156_ = vala_property_get_set_accessor (_tmp1155_);
										_tmp1157_ = _tmp1156_;
										_tmp1158_ = vala_symbol_get_access ((ValaSymbol*) _tmp1157_);
										_tmp1159_ = _tmp1158_;
										access = _tmp1159_;
									}
								}
							} else {
								ValaProperty* _tmp1160_;
								ValaPropertyAccessor* _tmp1161_;
								ValaPropertyAccessor* _tmp1162_;
								ValaProperty* _tmp1170_;
								ValaSymbolAccessibility _tmp1171_;
								ValaSymbolAccessibility _tmp1172_;
								_tmp1160_ = prop;
								_tmp1161_ = vala_property_get_get_accessor (_tmp1160_);
								_tmp1162_ = _tmp1161_;
								if (_tmp1162_ == NULL) {
									ValaSourceReference* _tmp1163_;
									ValaSourceReference* _tmp1164_;
									ValaProperty* _tmp1165_;
									gchar* _tmp1166_;
									gchar* _tmp1167_;
									gchar* _tmp1168_;
									gchar* _tmp1169_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1163_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1164_ = _tmp1163_;
									_tmp1165_ = prop;
									_tmp1166_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1165_);
									_tmp1167_ = _tmp1166_;
									_tmp1168_ = g_strdup_printf ("Property `%s' is write-only", _tmp1167_);
									_tmp1169_ = _tmp1168_;
									vala_report_error (_tmp1164_, _tmp1169_);
									_g_free0 (_tmp1169_);
									_g_free0 (_tmp1167_);
									result = FALSE;
									return result;
								}
								_tmp1170_ = prop;
								_tmp1171_ = vala_symbol_get_access ((ValaSymbol*) _tmp1170_);
								_tmp1172_ = _tmp1171_;
								if (_tmp1172_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1173_;
									ValaPropertyAccessor* _tmp1174_;
									ValaPropertyAccessor* _tmp1175_;
									ValaSymbolAccessibility _tmp1176_;
									ValaSymbolAccessibility _tmp1177_;
									_tmp1173_ = prop;
									_tmp1174_ = vala_property_get_get_accessor (_tmp1173_);
									_tmp1175_ = _tmp1174_;
									_tmp1176_ = vala_symbol_get_access ((ValaSymbol*) _tmp1175_);
									_tmp1177_ = _tmp1176_;
									access = _tmp1177_;
								} else {
									gboolean _tmp1178_ = FALSE;
									ValaProperty* _tmp1179_;
									ValaSymbolAccessibility _tmp1180_;
									ValaSymbolAccessibility _tmp1181_;
									_tmp1179_ = prop;
									_tmp1180_ = vala_symbol_get_access ((ValaSymbol*) _tmp1179_);
									_tmp1181_ = _tmp1180_;
									if (_tmp1181_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1182_;
										ValaPropertyAccessor* _tmp1183_;
										ValaPropertyAccessor* _tmp1184_;
										ValaSymbolAccessibility _tmp1185_;
										ValaSymbolAccessibility _tmp1186_;
										_tmp1182_ = prop;
										_tmp1183_ = vala_property_get_get_accessor (_tmp1182_);
										_tmp1184_ = _tmp1183_;
										_tmp1185_ = vala_symbol_get_access ((ValaSymbol*) _tmp1184_);
										_tmp1186_ = _tmp1185_;
										_tmp1178_ = _tmp1186_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1178_ = FALSE;
									}
									if (_tmp1178_) {
										ValaProperty* _tmp1187_;
										ValaPropertyAccessor* _tmp1188_;
										ValaPropertyAccessor* _tmp1189_;
										ValaSymbolAccessibility _tmp1190_;
										ValaSymbolAccessibility _tmp1191_;
										_tmp1187_ = prop;
										_tmp1188_ = vala_property_get_get_accessor (_tmp1187_);
										_tmp1189_ = _tmp1188_;
										_tmp1190_ = vala_symbol_get_access ((ValaSymbol*) _tmp1189_);
										_tmp1191_ = _tmp1190_;
										access = _tmp1191_;
									}
								}
							}
							_tmp1192_ = prop;
							_tmp1193_ = vala_property_get_binding (_tmp1192_);
							_tmp1194_ = _tmp1193_;
							instance = _tmp1194_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1195_ = prop;
							_tmp1196_ = vala_property_get_property_type (_tmp1195_);
							_tmp1197_ = _tmp1196_;
							if (VALA_IS_GENERIC_TYPE (_tmp1197_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1198_;
							_tmp1198_ = member;
							if (VALA_IS_SIGNAL (_tmp1198_)) {
								ValaSymbol* _tmp1199_;
								ValaSymbolAccessibility _tmp1200_;
								ValaSymbolAccessibility _tmp1201_;
								instance = TRUE;
								_tmp1199_ = member;
								_tmp1200_ = vala_symbol_get_access (_tmp1199_);
								_tmp1201_ = _tmp1200_;
								access = _tmp1201_;
							} else {
								gboolean _tmp1202_ = FALSE;
								gboolean _tmp1203_;
								_tmp1203_ = self->priv->_creation_member;
								if (!_tmp1203_) {
									ValaSymbol* _tmp1204_;
									_tmp1204_ = member;
									_tmp1202_ = VALA_IS_ERROR_CODE (_tmp1204_);
								} else {
									_tmp1202_ = FALSE;
								}
								if (_tmp1202_) {
									ValaSymbol* _tmp1205_;
									ValaConstant* _tmp1206_;
									ValaConstant* _tmp1207_;
									ValaSymbol* _tmp1208_;
									ValaSymbol* _tmp1209_;
									_tmp1205_ = member;
									_tmp1206_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1205_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1207_ = _tmp1206_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1207_);
									_tmp1208_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1209_ = _tmp1208_;
									member = _tmp1209_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1210_;
		ValaSymbol* _tmp1211_;
		ValaCodeNode* _tmp1212_;
		ValaCodeNode* _tmp1213_;
		ValaCodeNode* _tmp1214_;
		gboolean _tmp1215_ = FALSE;
		ValaCodeNode* _tmp1216_;
		_tmp1210_ = parent;
		_tmp1211_ = member;
		if (!(_tmp1210_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1211_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1212_ = parent;
		_tmp1213_ = vala_code_node_get_parent_node (_tmp1212_);
		_tmp1214_ = _tmp1213_;
		parent = _tmp1214_;
		_tmp1216_ = parent;
		if (_tmp1216_ == NULL) {
			_tmp1215_ = TRUE;
		} else {
			ValaCodeNode* _tmp1217_;
			ValaSymbol* _tmp1218_;
			_tmp1217_ = parent;
			_tmp1218_ = member;
			_tmp1215_ = _tmp1217_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1218_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1215_) {
			break;
		}
	}
	_tmp1219_ = parent;
	_tmp1220_ = member;
	if (_tmp1219_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1220_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1221_;
		_tmp1221_ = member;
		vala_symbol_set_used (_tmp1221_, TRUE);
	}
	_tmp1222_ = member;
	_tmp1223_ = vala_symbol_get_version (_tmp1222_);
	_tmp1224_ = _tmp1223_;
	_tmp1225_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1226_ = _tmp1225_;
	vala_version_attribute_check (_tmp1224_, _tmp1226_);
	_tmp1228_ = access;
	if (_tmp1228_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1229_;
		ValaSymbol* _tmp1230_;
		ValaSymbol* _tmp1231_;
		_tmp1229_ = member;
		_tmp1230_ = vala_symbol_get_parent_symbol (_tmp1229_);
		_tmp1231_ = _tmp1230_;
		_tmp1227_ = VALA_IS_TYPESYMBOL (_tmp1231_);
	} else {
		_tmp1227_ = FALSE;
	}
	if (_tmp1227_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1232_;
		ValaSymbol* _tmp1233_;
		ValaSymbol* _tmp1234_;
		gboolean in_subtype = FALSE;
		_tmp1232_ = member;
		_tmp1233_ = vala_symbol_get_parent_symbol (_tmp1232_);
		_tmp1234_ = _tmp1233_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1234_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1235_;
			ValaSemanticAnalyzer* _tmp1236_;
			ValaSymbol* _tmp1237_;
			ValaSymbol* _tmp1238_;
			ValaSymbol* _tmp1239_;
			_tmp1235_ = vala_code_context_get_analyzer (context);
			_tmp1236_ = _tmp1235_;
			_tmp1237_ = vala_semantic_analyzer_get_current_symbol (_tmp1236_);
			_tmp1238_ = _tmp1237_;
			_tmp1239_ = _vala_code_node_ref0 (_tmp1238_);
			this_symbol = _tmp1239_;
			{
				gboolean _tmp1240_ = FALSE;
				_tmp1240_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1245_;
					ValaSymbol* _tmp1246_;
					ValaTypeSymbol* _tmp1247_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1248_;
					gboolean _tmp1249_ = FALSE;
					ValaClass* _tmp1250_;
					if (!_tmp1240_) {
						ValaSymbol* _tmp1241_;
						ValaSymbol* _tmp1242_;
						ValaSymbol* _tmp1243_;
						ValaSymbol* _tmp1244_;
						_tmp1241_ = this_symbol;
						_tmp1242_ = vala_symbol_get_parent_symbol (_tmp1241_);
						_tmp1243_ = _tmp1242_;
						_tmp1244_ = _vala_code_node_ref0 (_tmp1243_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1244_;
					}
					_tmp1240_ = FALSE;
					_tmp1245_ = this_symbol;
					if (!(_tmp1245_ != NULL)) {
						break;
					}
					_tmp1246_ = this_symbol;
					_tmp1247_ = target_type;
					if (_tmp1246_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1247_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1248_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1248_) ? ((ValaClass*) _tmp1248_) : NULL;
					_tmp1250_ = cl;
					if (_tmp1250_ != NULL) {
						ValaClass* _tmp1251_;
						ValaTypeSymbol* _tmp1252_;
						_tmp1251_ = cl;
						_tmp1252_ = target_type;
						_tmp1249_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1251_, _tmp1252_);
					} else {
						_tmp1249_ = FALSE;
					}
					if (_tmp1249_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1253_;
			ValaSourceReference* _tmp1254_;
			ValaSymbol* _tmp1255_;
			gchar* _tmp1256_;
			gchar* _tmp1257_;
			gchar* _tmp1258_;
			gchar* _tmp1259_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1253_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1254_ = _tmp1253_;
			_tmp1255_ = member;
			_tmp1256_ = vala_symbol_get_full_name (_tmp1255_);
			_tmp1257_ = _tmp1256_;
			_tmp1258_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1257_);
			_tmp1259_ = _tmp1258_;
			vala_report_error (_tmp1254_, _tmp1259_);
			_g_free0 (_tmp1259_);
			_g_free0 (_tmp1257_);
			result = FALSE;
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1260_;
		_tmp1260_ = access;
		if (_tmp1260_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1261_;
			ValaSymbol* _tmp1262_;
			ValaSymbol* _tmp1263_;
			gboolean in_target_type = FALSE;
			_tmp1261_ = member;
			_tmp1262_ = vala_symbol_get_parent_symbol (_tmp1261_);
			_tmp1263_ = _tmp1262_;
			target_type = _tmp1263_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1264_;
				ValaSemanticAnalyzer* _tmp1265_;
				ValaSymbol* _tmp1266_;
				ValaSymbol* _tmp1267_;
				ValaSymbol* _tmp1268_;
				_tmp1264_ = vala_code_context_get_analyzer (context);
				_tmp1265_ = _tmp1264_;
				_tmp1266_ = vala_semantic_analyzer_get_current_symbol (_tmp1265_);
				_tmp1267_ = _tmp1266_;
				_tmp1268_ = _vala_code_node_ref0 (_tmp1267_);
				this_symbol = _tmp1268_;
				{
					gboolean _tmp1269_ = FALSE;
					_tmp1269_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1274_;
						ValaSymbol* _tmp1275_;
						ValaSymbol* _tmp1276_;
						if (!_tmp1269_) {
							ValaSymbol* _tmp1270_;
							ValaSymbol* _tmp1271_;
							ValaSymbol* _tmp1272_;
							ValaSymbol* _tmp1273_;
							_tmp1270_ = this_symbol;
							_tmp1271_ = vala_symbol_get_parent_symbol (_tmp1270_);
							_tmp1272_ = _tmp1271_;
							_tmp1273_ = _vala_code_node_ref0 (_tmp1272_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1273_;
						}
						_tmp1269_ = FALSE;
						_tmp1274_ = this_symbol;
						if (!(_tmp1274_ != NULL)) {
							break;
						}
						_tmp1275_ = target_type;
						_tmp1276_ = this_symbol;
						if (_tmp1275_ == _tmp1276_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1277_;
				ValaSourceReference* _tmp1278_;
				ValaSymbol* _tmp1279_;
				gchar* _tmp1280_;
				gchar* _tmp1281_;
				gchar* _tmp1282_;
				gchar* _tmp1283_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1277_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1278_ = _tmp1277_;
				_tmp1279_ = member;
				_tmp1280_ = vala_symbol_get_full_name (_tmp1279_);
				_tmp1281_ = _tmp1280_;
				_tmp1282_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1281_);
				_tmp1283_ = _tmp1282_;
				vala_report_error (_tmp1278_, _tmp1283_);
				_g_free0 (_tmp1283_);
				_g_free0 (_tmp1281_);
				result = FALSE;
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1285_;
		ValaExpression* _tmp1286_;
		_tmp1285_ = vala_member_access_get_inner (self);
		_tmp1286_ = _tmp1285_;
		_tmp1284_ = _tmp1286_ != NULL;
	} else {
		_tmp1284_ = FALSE;
	}
	if (_tmp1284_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1287_;
		ValaExpression* _tmp1288_;
		ValaDataType* _tmp1289_;
		ValaDataType* _tmp1290_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1291_;
		ValaExpression* _tmp1292_;
		ValaDataType* _tmp1293_;
		ValaDataType* _tmp1294_;
		ValaPointerType* _tmp1295_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1299_;
		gboolean _tmp1300_ = FALSE;
		gboolean _tmp1301_ = FALSE;
		ValaObjectType* _tmp1302_;
		_tmp1287_ = vala_member_access_get_inner (self);
		_tmp1288_ = _tmp1287_;
		_tmp1289_ = vala_expression_get_value_type (_tmp1288_);
		_tmp1290_ = _tmp1289_;
		instance_type = _tmp1290_;
		_tmp1291_ = vala_member_access_get_inner (self);
		_tmp1292_ = _tmp1291_;
		_tmp1293_ = vala_expression_get_value_type (_tmp1292_);
		_tmp1294_ = _tmp1293_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1294_) ? ((ValaPointerType*) _tmp1294_) : NULL;
		_tmp1295_ = pointer_type;
		if (_tmp1295_ != NULL) {
			ValaPointerType* _tmp1296_;
			ValaDataType* _tmp1297_;
			ValaDataType* _tmp1298_;
			_tmp1296_ = pointer_type;
			_tmp1297_ = vala_pointer_type_get_base_type (_tmp1296_);
			_tmp1298_ = _tmp1297_;
			instance_type = _tmp1298_;
		}
		_tmp1299_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1299_) ? ((ValaObjectType*) _tmp1299_) : NULL;
		_tmp1302_ = object_type;
		if (_tmp1302_ != NULL) {
			ValaObjectType* _tmp1303_;
			ValaObjectTypeSymbol* _tmp1304_;
			ValaObjectTypeSymbol* _tmp1305_;
			_tmp1303_ = object_type;
			_tmp1304_ = vala_object_type_get_object_type_symbol (_tmp1303_);
			_tmp1305_ = _tmp1304_;
			_tmp1301_ = vala_object_type_symbol_has_type_parameters (_tmp1305_);
		} else {
			_tmp1301_ = FALSE;
		}
		if (_tmp1301_) {
			ValaDataType* _tmp1306_;
			_tmp1306_ = instance_type;
			_tmp1300_ = !vala_data_type_has_type_arguments (_tmp1306_);
		} else {
			_tmp1300_ = FALSE;
		}
		if (_tmp1300_) {
			ValaExpression* _tmp1307_;
			ValaExpression* _tmp1308_;
			ValaSourceReference* _tmp1309_;
			ValaSourceReference* _tmp1310_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1307_ = vala_member_access_get_inner (self);
			_tmp1308_ = _tmp1307_;
			_tmp1309_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1308_);
			_tmp1310_ = _tmp1309_;
			vala_report_error (_tmp1310_, "missing generic type arguments");
			result = FALSE;
			return result;
		}
	}
	if (instance) {
		_tmp1312_ = !may_access_instance_members;
	} else {
		_tmp1312_ = FALSE;
	}
	if (_tmp1312_) {
		_tmp1311_ = TRUE;
	} else {
		gboolean _tmp1313_ = FALSE;
		if (klass) {
			_tmp1313_ = !may_access_klass_members;
		} else {
			_tmp1313_ = FALSE;
		}
		_tmp1311_ = _tmp1313_;
	}
	if (_tmp1311_) {
		ValaSymbol* _tmp1314_;
		ValaSymbol* _tmp1315_;
		ValaDataType* _tmp1338_;
		ValaDataType* _tmp1339_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1314_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1315_ = _tmp1314_;
		if (VALA_IS_METHOD (_tmp1315_)) {
			ValaSemanticAnalyzer* _tmp1316_;
			ValaSemanticAnalyzer* _tmp1317_;
			ValaSymbol* _tmp1318_;
			ValaSymbol* _tmp1319_;
			gboolean _tmp1320_;
			gboolean _tmp1321_;
			ValaDataType* _tmp1322_;
			ValaDataType* _tmp1323_;
			_tmp1316_ = vala_code_context_get_analyzer (context);
			_tmp1317_ = _tmp1316_;
			_tmp1318_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1319_ = _tmp1318_;
			_tmp1320_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1321_ = _tmp1320_;
			_tmp1322_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1317_, _tmp1319_, _tmp1321_);
			_tmp1323_ = _tmp1322_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1323_);
			_vala_code_node_unref0 (_tmp1323_);
		} else {
			ValaSymbol* _tmp1324_;
			ValaSymbol* _tmp1325_;
			_tmp1324_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1325_ = _tmp1324_;
			if (VALA_IS_FIELD (_tmp1325_)) {
				ValaSymbol* _tmp1326_;
				ValaSymbol* _tmp1327_;
				ValaFieldPrototype* _tmp1328_;
				ValaFieldPrototype* _tmp1329_;
				_tmp1326_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1327_ = _tmp1326_;
				_tmp1328_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1327_, VALA_TYPE_FIELD, ValaField));
				_tmp1329_ = _tmp1328_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1329_);
				_vala_code_node_unref0 (_tmp1329_);
			} else {
				ValaSymbol* _tmp1330_;
				ValaSymbol* _tmp1331_;
				_tmp1330_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1331_ = _tmp1330_;
				if (VALA_IS_PROPERTY (_tmp1331_)) {
					ValaSymbol* _tmp1332_;
					ValaSymbol* _tmp1333_;
					ValaPropertyPrototype* _tmp1334_;
					ValaPropertyPrototype* _tmp1335_;
					_tmp1332_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1333_ = _tmp1332_;
					_tmp1334_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1333_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1335_ = _tmp1334_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1335_);
					_vala_code_node_unref0 (_tmp1335_);
				} else {
					ValaInvalidType* _tmp1336_;
					ValaInvalidType* _tmp1337_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1336_ = vala_invalid_type_new ();
					_tmp1337_ = _tmp1336_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1337_);
					_vala_code_node_unref0 (_tmp1337_);
				}
			}
		}
		_tmp1338_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1339_ = _tmp1338_;
		if (_tmp1339_ != NULL) {
			ValaDataType* _tmp1340_;
			ValaDataType* _tmp1341_;
			ValaDataType* _tmp1342_;
			ValaDataType* _tmp1343_;
			gboolean _tmp1344_;
			gboolean _tmp1345_;
			_tmp1340_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1341_ = _tmp1340_;
			_tmp1342_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1343_ = _tmp1342_;
			_tmp1344_ = vala_data_type_get_value_owned (_tmp1343_);
			_tmp1345_ = _tmp1344_;
			vala_data_type_set_value_owned (_tmp1341_, _tmp1345_);
		}
	} else {
		gboolean _tmp1346_ = FALSE;
		gboolean _tmp1367_ = FALSE;
		gboolean _tmp1368_ = FALSE;
		gboolean _tmp1369_ = FALSE;
		gboolean _tmp1370_ = FALSE;
		gboolean _tmp1413_ = FALSE;
		gboolean _tmp1414_ = FALSE;
		gboolean _tmp1415_ = FALSE;
		gboolean _tmp1416_ = FALSE;
		gboolean _tmp1417_ = FALSE;
		gboolean _tmp1418_;
		gboolean _tmp1419_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1446_;
		ValaSymbol* _tmp1447_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1448_;
		ValaExpression* _tmp1449_;
		gboolean _tmp1450_ = FALSE;
		gboolean _tmp1451_ = FALSE;
		gboolean _tmp1452_ = FALSE;
		gboolean _tmp1453_ = FALSE;
		gboolean _tmp1454_ = FALSE;
		ValaMethod* _tmp1455_;
		ValaSemanticAnalyzer* _tmp1494_;
		ValaSemanticAnalyzer* _tmp1495_;
		ValaSymbol* _tmp1496_;
		ValaSymbol* _tmp1497_;
		gboolean _tmp1498_;
		gboolean _tmp1499_;
		ValaDataType* _tmp1500_;
		ValaDataType* _tmp1501_;
		gboolean _tmp1502_ = FALSE;
		ValaExpression* _tmp1503_;
		ValaExpression* _tmp1504_;
		ValaSymbol* _tmp1517_;
		ValaSymbol* _tmp1518_;
		if (instance) {
			ValaExpression* _tmp1347_;
			ValaExpression* _tmp1348_;
			_tmp1347_ = vala_member_access_get_inner (self);
			_tmp1348_ = _tmp1347_;
			_tmp1346_ = _tmp1348_ == NULL;
		} else {
			_tmp1346_ = FALSE;
		}
		if (_tmp1346_) {
			ValaSourceReference* _tmp1349_;
			ValaSourceReference* _tmp1350_;
			ValaMemberAccess* _tmp1351_;
			ValaMemberAccess* _tmp1352_;
			ValaExpression* _tmp1353_;
			ValaExpression* _tmp1354_;
			ValaParameter* _tmp1355_;
			ValaDataType* _tmp1356_;
			ValaDataType* _tmp1357_;
			ValaDataType* _tmp1358_;
			ValaDataType* _tmp1359_;
			ValaExpression* _tmp1360_;
			ValaExpression* _tmp1361_;
			ValaDataType* _tmp1362_;
			ValaDataType* _tmp1363_;
			ValaExpression* _tmp1364_;
			ValaExpression* _tmp1365_;
			ValaParameter* _tmp1366_;
			_tmp1349_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1350_ = _tmp1349_;
			_tmp1351_ = vala_member_access_new (NULL, "this", _tmp1350_);
			_tmp1352_ = _tmp1351_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1352_);
			_vala_code_node_unref0 (_tmp1352_);
			_tmp1353_ = vala_member_access_get_inner (self);
			_tmp1354_ = _tmp1353_;
			_tmp1355_ = this_parameter;
			_tmp1356_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1355_);
			_tmp1357_ = _tmp1356_;
			_tmp1358_ = vala_data_type_copy (_tmp1357_);
			_tmp1359_ = _tmp1358_;
			vala_expression_set_value_type (_tmp1354_, _tmp1359_);
			_vala_code_node_unref0 (_tmp1359_);
			_tmp1360_ = vala_member_access_get_inner (self);
			_tmp1361_ = _tmp1360_;
			_tmp1362_ = vala_expression_get_value_type (_tmp1361_);
			_tmp1363_ = _tmp1362_;
			vala_data_type_set_value_owned (_tmp1363_, FALSE);
			_tmp1364_ = vala_member_access_get_inner (self);
			_tmp1365_ = _tmp1364_;
			_tmp1366_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1365_, (ValaSymbol*) _tmp1366_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1370_ = !klass;
		} else {
			_tmp1370_ = FALSE;
		}
		if (_tmp1370_) {
			ValaSymbol* _tmp1371_;
			ValaSymbol* _tmp1372_;
			_tmp1371_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1372_ = _tmp1371_;
			_tmp1369_ = !VALA_IS_CREATION_METHOD (_tmp1372_);
		} else {
			_tmp1369_ = FALSE;
		}
		if (_tmp1369_) {
			_tmp1368_ = may_access_instance_members;
		} else {
			_tmp1368_ = FALSE;
		}
		if (_tmp1368_) {
			ValaExpression* _tmp1373_;
			ValaExpression* _tmp1374_;
			_tmp1373_ = vala_member_access_get_inner (self);
			_tmp1374_ = _tmp1373_;
			_tmp1367_ = _tmp1374_ != NULL;
		} else {
			_tmp1367_ = FALSE;
		}
		if (_tmp1367_) {
			ValaExpression* _tmp1375_;
			ValaExpression* _tmp1376_;
			ValaSymbol* _tmp1377_;
			ValaSymbol* _tmp1378_;
			_tmp1375_ = vala_member_access_get_inner (self);
			_tmp1376_ = _tmp1375_;
			_tmp1377_ = vala_expression_get_symbol_reference (_tmp1376_);
			_tmp1378_ = _tmp1377_;
			if (VALA_IS_METHOD (_tmp1378_)) {
			} else {
				ValaSourceReference* _tmp1379_;
				ValaSourceReference* _tmp1380_;
				ValaSymbol* _tmp1381_;
				ValaSymbol* _tmp1382_;
				gchar* _tmp1383_;
				gchar* _tmp1384_;
				gchar* _tmp1385_;
				gchar* _tmp1386_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1387_;
				ValaSymbol* _tmp1388_;
				ValaSymbol* _tmp1389_;
				ValaSymbol* _tmp1390_;
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp1410_;
				ValaExpression* _tmp1411_;
				ValaExpression* _tmp1412_;
				_tmp1379_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1380_ = _tmp1379_;
				_tmp1381_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1382_ = _tmp1381_;
				_tmp1383_ = vala_symbol_get_full_name (_tmp1382_);
				_tmp1384_ = _tmp1383_;
				_tmp1385_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1384_);
				_tmp1386_ = _tmp1385_;
				vala_report_warning (_tmp1380_, _tmp1386_);
				_g_free0 (_tmp1386_);
				_g_free0 (_tmp1384_);
				_tmp1387_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1388_ = _tmp1387_;
				_tmp1389_ = vala_symbol_get_parent_symbol (_tmp1388_);
				_tmp1390_ = _tmp1389_;
				inner_sym = _tmp1390_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1391_ = FALSE;
					ValaSymbol* _tmp1392_;
					ValaMemberAccess* _tmp1396_;
					ValaSymbol* _tmp1397_;
					const gchar* _tmp1398_;
					const gchar* _tmp1399_;
					ValaSourceReference* _tmp1400_;
					ValaSourceReference* _tmp1401_;
					ValaMemberAccess* _tmp1402_;
					ValaMemberAccess* _tmp1403_;
					ValaMemberAccess* _tmp1404_;
					ValaExpression* _tmp1405_;
					ValaExpression* _tmp1406_;
					ValaSymbol* _tmp1407_;
					ValaSymbol* _tmp1408_;
					ValaSymbol* _tmp1409_;
					_tmp1392_ = inner_sym;
					if (_tmp1392_ != NULL) {
						ValaSymbol* _tmp1393_;
						const gchar* _tmp1394_;
						const gchar* _tmp1395_;
						_tmp1393_ = inner_sym;
						_tmp1394_ = vala_symbol_get_name (_tmp1393_);
						_tmp1395_ = _tmp1394_;
						_tmp1391_ = _tmp1395_ != NULL;
					} else {
						_tmp1391_ = FALSE;
					}
					if (!_tmp1391_) {
						break;
					}
					_tmp1396_ = inner_ma;
					_tmp1397_ = inner_sym;
					_tmp1398_ = vala_symbol_get_name (_tmp1397_);
					_tmp1399_ = _tmp1398_;
					_tmp1400_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1401_ = _tmp1400_;
					_tmp1402_ = vala_member_access_new (NULL, _tmp1399_, _tmp1401_);
					_tmp1403_ = _tmp1402_;
					vala_member_access_set_inner (_tmp1396_, (ValaExpression*) _tmp1403_);
					_vala_code_node_unref0 (_tmp1403_);
					_tmp1404_ = inner_ma;
					_tmp1405_ = vala_member_access_get_inner (_tmp1404_);
					_tmp1406_ = _tmp1405_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1406_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1407_ = inner_sym;
					_tmp1408_ = vala_symbol_get_parent_symbol (_tmp1407_);
					_tmp1409_ = _tmp1408_;
					inner_sym = _tmp1409_;
				}
				_tmp1410_ = inner_ma;
				vala_member_access_set_qualified (_tmp1410_, TRUE);
				_tmp1411_ = vala_member_access_get_inner (self);
				_tmp1412_ = _tmp1411_;
				vala_code_node_check ((ValaCodeNode*) _tmp1412_, context);
			}
		}
		_tmp1418_ = vala_code_context_get_experimental_non_null (context);
		_tmp1419_ = _tmp1418_;
		if (_tmp1419_) {
			_tmp1417_ = instance;
		} else {
			_tmp1417_ = FALSE;
		}
		if (_tmp1417_) {
			ValaExpression* _tmp1420_;
			ValaExpression* _tmp1421_;
			ValaDataType* _tmp1422_;
			ValaDataType* _tmp1423_;
			gboolean _tmp1424_;
			gboolean _tmp1425_;
			_tmp1420_ = vala_member_access_get_inner (self);
			_tmp1421_ = _tmp1420_;
			_tmp1422_ = vala_expression_get_value_type (_tmp1421_);
			_tmp1423_ = _tmp1422_;
			_tmp1424_ = vala_data_type_get_nullable (_tmp1423_);
			_tmp1425_ = _tmp1424_;
			_tmp1416_ = _tmp1425_;
		} else {
			_tmp1416_ = FALSE;
		}
		if (_tmp1416_) {
			ValaExpression* _tmp1426_;
			ValaExpression* _tmp1427_;
			ValaDataType* _tmp1428_;
			ValaDataType* _tmp1429_;
			_tmp1426_ = vala_member_access_get_inner (self);
			_tmp1427_ = _tmp1426_;
			_tmp1428_ = vala_expression_get_value_type (_tmp1427_);
			_tmp1429_ = _tmp1428_;
			_tmp1415_ = !VALA_IS_POINTER_TYPE (_tmp1429_);
		} else {
			_tmp1415_ = FALSE;
		}
		if (_tmp1415_) {
			ValaExpression* _tmp1430_;
			ValaExpression* _tmp1431_;
			ValaDataType* _tmp1432_;
			ValaDataType* _tmp1433_;
			_tmp1430_ = vala_member_access_get_inner (self);
			_tmp1431_ = _tmp1430_;
			_tmp1432_ = vala_expression_get_value_type (_tmp1431_);
			_tmp1433_ = _tmp1432_;
			_tmp1414_ = !VALA_IS_GENERIC_TYPE (_tmp1433_);
		} else {
			_tmp1414_ = FALSE;
		}
		if (_tmp1414_) {
			ValaExpression* _tmp1434_;
			ValaExpression* _tmp1435_;
			ValaDataType* _tmp1436_;
			ValaDataType* _tmp1437_;
			_tmp1434_ = vala_member_access_get_inner (self);
			_tmp1435_ = _tmp1434_;
			_tmp1436_ = vala_expression_get_value_type (_tmp1435_);
			_tmp1437_ = _tmp1436_;
			_tmp1413_ = !VALA_IS_ARRAY_TYPE (_tmp1437_);
		} else {
			_tmp1413_ = FALSE;
		}
		if (_tmp1413_) {
			ValaSourceReference* _tmp1438_;
			ValaSourceReference* _tmp1439_;
			ValaSymbol* _tmp1440_;
			ValaSymbol* _tmp1441_;
			gchar* _tmp1442_;
			gchar* _tmp1443_;
			gchar* _tmp1444_;
			gchar* _tmp1445_;
			_tmp1438_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1439_ = _tmp1438_;
			_tmp1440_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1441_ = _tmp1440_;
			_tmp1442_ = vala_symbol_get_full_name (_tmp1441_);
			_tmp1443_ = _tmp1442_;
			_tmp1444_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1443_);
			_tmp1445_ = _tmp1444_;
			vala_report_error (_tmp1439_, _tmp1445_);
			_g_free0 (_tmp1445_);
			_g_free0 (_tmp1443_);
		}
		_tmp1446_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1447_ = _tmp1446_;
		m = VALA_IS_METHOD (_tmp1447_) ? ((ValaMethod*) _tmp1447_) : NULL;
		_tmp1448_ = vala_member_access_get_inner (self);
		_tmp1449_ = _tmp1448_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1449_) ? ((ValaMemberAccess*) _tmp1449_) : NULL;
		_tmp1455_ = m;
		if (_tmp1455_ != NULL) {
			ValaMethod* _tmp1456_;
			ValaMemberBinding _tmp1457_;
			ValaMemberBinding _tmp1458_;
			_tmp1456_ = m;
			_tmp1457_ = vala_method_get_binding (_tmp1456_);
			_tmp1458_ = _tmp1457_;
			_tmp1454_ = _tmp1458_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1454_ = FALSE;
		}
		if (_tmp1454_) {
			ValaMethod* _tmp1459_;
			ValaSymbol* _tmp1460_;
			ValaSymbol* _tmp1461_;
			_tmp1459_ = m;
			_tmp1460_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1459_);
			_tmp1461_ = _tmp1460_;
			_tmp1453_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1461_);
		} else {
			_tmp1453_ = FALSE;
		}
		if (_tmp1453_) {
			ValaExpression* _tmp1462_;
			ValaExpression* _tmp1463_;
			_tmp1462_ = vala_member_access_get_inner (self);
			_tmp1463_ = _tmp1462_;
			_tmp1452_ = _tmp1463_ != NULL;
		} else {
			_tmp1452_ = FALSE;
		}
		if (_tmp1452_) {
			ValaExpression* _tmp1464_;
			ValaExpression* _tmp1465_;
			ValaDataType* _tmp1466_;
			ValaDataType* _tmp1467_;
			_tmp1464_ = vala_member_access_get_inner (self);
			_tmp1465_ = _tmp1464_;
			_tmp1466_ = vala_expression_get_value_type (_tmp1465_);
			_tmp1467_ = _tmp1466_;
			_tmp1451_ = _tmp1467_ == NULL;
		} else {
			_tmp1451_ = FALSE;
		}
		if (_tmp1451_) {
			ValaMemberAccess* _tmp1468_;
			ValaList* _tmp1469_;
			gint _tmp1470_;
			gint _tmp1471_;
			_tmp1468_ = inner_ma;
			_tmp1469_ = _tmp1468_->priv->type_argument_list;
			_tmp1470_ = vala_collection_get_size ((ValaCollection*) _tmp1469_);
			_tmp1471_ = _tmp1470_;
			_tmp1450_ = _tmp1471_ > 0;
		} else {
			_tmp1450_ = FALSE;
		}
		if (_tmp1450_) {
			ValaExpression* _tmp1472_;
			ValaExpression* _tmp1473_;
			ValaMethod* _tmp1474_;
			ValaSymbol* _tmp1475_;
			ValaSymbol* _tmp1476_;
			ValaObjectType* _tmp1477_;
			ValaObjectType* _tmp1478_;
			_tmp1472_ = vala_member_access_get_inner (self);
			_tmp1473_ = _tmp1472_;
			_tmp1474_ = m;
			_tmp1475_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1474_);
			_tmp1476_ = _tmp1475_;
			_tmp1477_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1476_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1478_ = _tmp1477_;
			vala_expression_set_value_type (_tmp1473_, (ValaDataType*) _tmp1478_);
			_vala_code_node_unref0 (_tmp1478_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1479_;
				ValaList* _tmp1480_;
				ValaList* _tmp1481_;
				gint _type_argument_size = 0;
				ValaList* _tmp1482_;
				gint _tmp1483_;
				gint _tmp1484_;
				gint _type_argument_index = 0;
				_tmp1479_ = inner_ma;
				_tmp1480_ = _tmp1479_->priv->type_argument_list;
				_tmp1481_ = _vala_iterable_ref0 (_tmp1480_);
				_type_argument_list = _tmp1481_;
				_tmp1482_ = _type_argument_list;
				_tmp1483_ = vala_collection_get_size ((ValaCollection*) _tmp1482_);
				_tmp1484_ = _tmp1483_;
				_type_argument_size = _tmp1484_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1485_;
					gint _tmp1486_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1487_;
					gpointer _tmp1488_;
					ValaExpression* _tmp1489_;
					ValaExpression* _tmp1490_;
					ValaDataType* _tmp1491_;
					ValaDataType* _tmp1492_;
					ValaDataType* _tmp1493_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1485_ = _type_argument_index;
					_tmp1486_ = _type_argument_size;
					if (!(_tmp1485_ < _tmp1486_)) {
						break;
					}
					_tmp1487_ = _type_argument_list;
					_tmp1488_ = vala_list_get (_tmp1487_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1488_;
					_tmp1489_ = vala_member_access_get_inner (self);
					_tmp1490_ = _tmp1489_;
					_tmp1491_ = vala_expression_get_value_type (_tmp1490_);
					_tmp1492_ = _tmp1491_;
					_tmp1493_ = type_argument;
					vala_data_type_add_type_argument (_tmp1492_, _tmp1493_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1494_ = vala_code_context_get_analyzer (context);
		_tmp1495_ = _tmp1494_;
		_tmp1496_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1497_ = _tmp1496_;
		_tmp1498_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1499_ = _tmp1498_;
		_tmp1500_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1495_, _tmp1497_, _tmp1499_);
		_tmp1501_ = _tmp1500_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1501_);
		_vala_code_node_unref0 (_tmp1501_);
		_tmp1503_ = vala_member_access_get_inner (self);
		_tmp1504_ = _tmp1503_;
		if (_tmp1504_ != NULL) {
			ValaDataType* _tmp1505_;
			ValaDataType* _tmp1506_;
			_tmp1505_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1506_ = _tmp1505_;
			_tmp1502_ = _tmp1506_ != NULL;
		} else {
			_tmp1502_ = FALSE;
		}
		if (_tmp1502_) {
			ValaDataType* _tmp1507_;
			ValaDataType* _tmp1508_;
			ValaExpression* _tmp1509_;
			ValaExpression* _tmp1510_;
			ValaDataType* _tmp1511_;
			ValaDataType* _tmp1512_;
			ValaDataType* _tmp1513_;
			ValaDataType* _tmp1514_;
			_tmp1507_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1508_ = _tmp1507_;
			_tmp1509_ = vala_member_access_get_inner (self);
			_tmp1510_ = _tmp1509_;
			_tmp1511_ = vala_expression_get_value_type (_tmp1510_);
			_tmp1512_ = _tmp1511_;
			_tmp1513_ = vala_data_type_get_actual_type (_tmp1508_, _tmp1512_, NULL, (ValaCodeNode*) self);
			_tmp1514_ = _tmp1513_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1514_);
			_vala_code_node_unref0 (_tmp1514_);
		} else {
			ValaDataType* _tmp1515_;
			ValaDataType* _tmp1516_;
			_tmp1515_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1516_ = _tmp1515_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1516_);
		}
		_tmp1517_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1518_ = _tmp1517_;
		if (VALA_IS_METHOD (_tmp1518_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1519_;
			ValaSymbol* _tmp1520_;
			ValaDataType* _tmp1521_;
			ValaDataType* _tmp1522_;
			gboolean _tmp1529_ = FALSE;
			_tmp1519_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1520_ = _tmp1519_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1520_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1521_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1522_ = _tmp1521_;
			if (_tmp1522_ != NULL) {
				ValaDataType* _tmp1523_;
				ValaDataType* _tmp1524_;
				ValaDataType* _tmp1525_;
				ValaDataType* _tmp1526_;
				gboolean _tmp1527_;
				gboolean _tmp1528_;
				_tmp1523_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1524_ = _tmp1523_;
				_tmp1525_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1526_ = _tmp1525_;
				_tmp1527_ = vala_data_type_get_value_owned (_tmp1526_);
				_tmp1528_ = _tmp1527_;
				vala_data_type_set_value_owned (_tmp1524_, _tmp1528_);
			}
			if (instance) {
				ValaMethod* _tmp1530_;
				ValaSymbol* _tmp1531_;
				ValaSymbol* _tmp1532_;
				_tmp1530_ = method;
				_tmp1531_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1530_);
				_tmp1532_ = _tmp1531_;
				_tmp1529_ = VALA_IS_TYPESYMBOL (_tmp1532_);
			} else {
				_tmp1529_ = FALSE;
			}
			if (_tmp1529_) {
				ValaExpression* _tmp1533_;
				ValaExpression* _tmp1534_;
				ValaMethod* _tmp1535_;
				ValaSymbol* _tmp1536_;
				ValaSymbol* _tmp1537_;
				ValaDataType* _tmp1538_;
				ValaDataType* _tmp1539_;
				ValaExpression* _tmp1540_;
				ValaExpression* _tmp1541_;
				ValaDataType* _tmp1542_;
				ValaDataType* _tmp1543_;
				ValaMethod* _tmp1544_;
				ValaParameter* _tmp1545_;
				ValaParameter* _tmp1546_;
				ValaDataType* _tmp1547_;
				ValaDataType* _tmp1548_;
				gboolean _tmp1549_;
				gboolean _tmp1550_;
				_tmp1533_ = vala_member_access_get_inner (self);
				_tmp1534_ = _tmp1533_;
				_tmp1535_ = method;
				_tmp1536_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1535_);
				_tmp1537_ = _tmp1536_;
				_tmp1538_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1537_);
				_tmp1539_ = _tmp1538_;
				vala_expression_set_target_type (_tmp1534_, _tmp1539_);
				_vala_code_node_unref0 (_tmp1539_);
				_tmp1540_ = vala_member_access_get_inner (self);
				_tmp1541_ = _tmp1540_;
				_tmp1542_ = vala_expression_get_target_type (_tmp1541_);
				_tmp1543_ = _tmp1542_;
				_tmp1544_ = method;
				_tmp1545_ = vala_method_get_this_parameter (_tmp1544_);
				_tmp1546_ = _tmp1545_;
				_tmp1547_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1546_);
				_tmp1548_ = _tmp1547_;
				_tmp1549_ = vala_data_type_get_value_owned (_tmp1548_);
				_tmp1550_ = _tmp1549_;
				vala_data_type_set_value_owned (_tmp1543_, _tmp1550_);
			}
		} else {
			gboolean _tmp1551_ = FALSE;
			gboolean _tmp1552_ = FALSE;
			ValaSymbol* _tmp1553_;
			ValaSymbol* _tmp1554_;
			_tmp1553_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1554_ = _tmp1553_;
			if (VALA_IS_PROPERTY (_tmp1554_)) {
				_tmp1552_ = instance;
			} else {
				_tmp1552_ = FALSE;
			}
			if (_tmp1552_) {
				ValaSymbol* _tmp1555_;
				ValaSymbol* _tmp1556_;
				ValaSymbol* _tmp1557_;
				ValaSymbol* _tmp1558_;
				_tmp1555_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1556_ = _tmp1555_;
				_tmp1557_ = vala_symbol_get_parent_symbol (_tmp1556_);
				_tmp1558_ = _tmp1557_;
				_tmp1551_ = _tmp1558_ != NULL;
			} else {
				_tmp1551_ = FALSE;
			}
			if (_tmp1551_) {
				ValaExpression* _tmp1559_;
				ValaExpression* _tmp1560_;
				ValaSymbol* _tmp1561_;
				ValaSymbol* _tmp1562_;
				ValaSymbol* _tmp1563_;
				ValaSymbol* _tmp1564_;
				ValaDataType* _tmp1565_;
				ValaDataType* _tmp1566_;
				_tmp1559_ = vala_member_access_get_inner (self);
				_tmp1560_ = _tmp1559_;
				_tmp1561_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1562_ = _tmp1561_;
				_tmp1563_ = vala_symbol_get_parent_symbol (_tmp1562_);
				_tmp1564_ = _tmp1563_;
				_tmp1565_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1564_);
				_tmp1566_ = _tmp1565_;
				vala_expression_set_target_type (_tmp1560_, _tmp1566_);
				_vala_code_node_unref0 (_tmp1566_);
			} else {
				gboolean _tmp1567_ = FALSE;
				gboolean _tmp1568_ = FALSE;
				gboolean _tmp1569_ = FALSE;
				ValaSymbol* _tmp1570_;
				ValaSymbol* _tmp1571_;
				_tmp1570_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1571_ = _tmp1570_;
				if (VALA_IS_FIELD (_tmp1571_)) {
					_tmp1569_ = TRUE;
				} else {
					ValaSymbol* _tmp1572_;
					ValaSymbol* _tmp1573_;
					_tmp1572_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1573_ = _tmp1572_;
					_tmp1569_ = VALA_IS_SIGNAL (_tmp1573_);
				}
				if (_tmp1569_) {
					_tmp1568_ = instance;
				} else {
					_tmp1568_ = FALSE;
				}
				if (_tmp1568_) {
					ValaSymbol* _tmp1574_;
					ValaSymbol* _tmp1575_;
					ValaSymbol* _tmp1576_;
					ValaSymbol* _tmp1577_;
					_tmp1574_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1575_ = _tmp1574_;
					_tmp1576_ = vala_symbol_get_parent_symbol (_tmp1575_);
					_tmp1577_ = _tmp1576_;
					_tmp1567_ = _tmp1577_ != NULL;
				} else {
					_tmp1567_ = FALSE;
				}
				if (_tmp1567_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1578_;
					ValaSymbol* _tmp1579_;
					ValaSymbol* _tmp1580_;
					ValaSymbol* _tmp1581_;
					ValaDataType* _tmp1582_;
					ValaExpression* _tmp1583_;
					ValaExpression* _tmp1584_;
					ValaDataType* _tmp1585_;
					ValaExpression* _tmp1586_;
					ValaExpression* _tmp1587_;
					ValaDataType* _tmp1588_;
					ValaDataType* _tmp1589_;
					ValaDataType* _tmp1590_;
					ValaDataType* _tmp1591_;
					_tmp1578_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1579_ = _tmp1578_;
					_tmp1580_ = vala_symbol_get_parent_symbol (_tmp1579_);
					_tmp1581_ = _tmp1580_;
					_tmp1582_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1581_);
					parent_type = _tmp1582_;
					_tmp1583_ = vala_member_access_get_inner (self);
					_tmp1584_ = _tmp1583_;
					_tmp1585_ = parent_type;
					_tmp1586_ = vala_member_access_get_inner (self);
					_tmp1587_ = _tmp1586_;
					_tmp1588_ = vala_expression_get_value_type (_tmp1587_);
					_tmp1589_ = _tmp1588_;
					_tmp1590_ = vala_data_type_get_actual_type (_tmp1585_, _tmp1589_, NULL, (ValaCodeNode*) self);
					_tmp1591_ = _tmp1590_;
					vala_expression_set_target_type (_tmp1584_, _tmp1591_);
					_vala_code_node_unref0 (_tmp1591_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
	}
	_tmp1592_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1593_ = _tmp1592_;
	if (_tmp1593_ != NULL) {
		ValaDataType* _tmp1594_;
		ValaDataType* _tmp1595_;
		_tmp1594_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1595_ = _tmp1594_;
		vala_code_node_check ((ValaCodeNode*) _tmp1595_, context);
	}
	_tmp1596_ = self->priv->_tainted_access;
	if (!_tmp1596_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1597_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1598_ = _tmp1597_;
	result = !_tmp1598_;
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result = 0;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

