/* node.c generated by valac, the Vala compiler
 * generated from node.vala, do not modify */

/* node.vala
 *
 * Copyright (C) 2008-2009 Florian Brosch, Didier Villevalois
 * Copyright (C) 2011 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <vala.h>

enum  {
	VALADOC_API_NODE_0_PROPERTY,
	VALADOC_API_NODE_NAME_PROPERTY,
	VALADOC_API_NODE_NODE_TYPE_PROPERTY,
	VALADOC_API_NODE_NSPACE_PROPERTY,
	VALADOC_API_NODE_PACKAGE_PROPERTY,
	VALADOC_API_NODE_DOCUMENTATION_PROPERTY,
	VALADOC_API_NODE_NUM_PROPERTIES
};
static GParamSpec* valadoc_api_node_properties[VALADOC_API_NODE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValadocApiNodePrivate {
	ValadocApiSourceFile* file;
	gchar* _name;
	ValaMap* per_name_children;
	ValaMap* per_type_children;
	ValadocApiNamespace* _nspace;
	ValadocApiPackage* _package;
	gchar* _full_name;
	ValadocContentComment* _documentation;
};

static gint ValadocApiNode_private_offset;
static gpointer valadoc_api_node_parent_class = NULL;
static ValadocDocumentationIface * valadoc_api_node_valadoc_documentation_parent_iface = NULL;

G_GNUC_INTERNAL void valadoc_api_item_parse_comments (ValadocApiItem* self,
                                      ValadocSettings* settings,
                                      ValadocDocumentationParser* parser);
G_GNUC_INTERNAL void valadoc_api_item_check_comments (ValadocApiItem* self,
                                      ValadocSettings* settings,
                                      ValadocDocumentationParser* parser);
static void valadoc_api_node_set_name (ValadocApiNode* self,
                                const gchar* value);
static void valadoc_api_node_real_accept (ValadocApiNode* self,
                                   ValadocApiVisitor* visitor);
static gboolean valadoc_api_node_real_is_browsable (ValadocApiNode* self,
                                             ValadocSettings* settings);
static gchar* valadoc_api_node_real_get_filename (ValadocDocumentation* base);
static void valadoc_api_node_real_parse_comments (ValadocApiItem* base,
                                           ValadocSettings* settings,
                                           ValadocDocumentationParser* parser);
static void valadoc_api_node_real_check_comments (ValadocApiItem* base,
                                           ValadocSettings* settings,
                                           ValadocDocumentationParser* parser);
G_GNUC_INTERNAL void valadoc_api_node_set_documentation (ValadocApiNode* self,
                                         ValadocContentComment* value);
static void valadoc_api_node_finalize (GObject * obj);
static GType valadoc_api_node_get_type_once (void);
static void _vala_valadoc_api_node_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_valadoc_api_node_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
valadoc_api_node_get_instance_private (ValadocApiNode* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocApiNode_private_offset);
}

const gchar*
valadoc_api_node_get_name (ValadocApiNode* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
valadoc_api_node_set_name (ValadocApiNode* self,
                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = valadoc_api_node_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_node_properties[VALADOC_API_NODE_NAME_PROPERTY]);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ValadocApiSourceFile*
valadoc_api_node_get_source_file (ValadocApiNode* self)
{
	ValadocApiSourceFile* _tmp0_;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSourceFile* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

ValadocApiNodeType
valadoc_api_node_get_node_type (ValadocApiNode* self)
{
	g_return_val_if_fail (self != NULL, 0);
	return VALADOC_API_NODE_GET_CLASS (self)->get_node_type (self);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

ValadocApiNode*
valadoc_api_node_construct (GType object_type,
                            ValadocApiNode* parent,
                            ValadocApiSourceFile* file,
                            const gchar* name,
                            ValaCodeNode* data)
{
	ValadocApiNode * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GEqualFunc _tmp6_;
	ValaHashMap* _tmp7_;
	gboolean _tmp8_ = FALSE;
	ValadocApiSourceFile* _tmp14_;
	self = (ValadocApiNode*) valadoc_api_item_construct (object_type, data);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALADOC_API_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_, _tmp1_, _tmp2_);
	_vala_map_unref0 (self->priv->per_name_children);
	self->priv->per_name_children = (ValaMap*) _tmp3_;
	_tmp4_ = g_direct_hash;
	_tmp5_ = g_direct_equal;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_hash_map_new (VALADOC_API_TYPE_NODE_TYPE, NULL, NULL, VALA_TYPE_LIST, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp4_, _tmp5_, _tmp6_);
	_vala_map_unref0 (self->priv->per_type_children);
	self->priv->per_type_children = (ValaMap*) _tmp7_;
	if (name != NULL) {
		gboolean _tmp9_ = FALSE;
		gint _tmp10_;
		gint _tmp11_;
		_tmp10_ = strlen (name);
		_tmp11_ = _tmp10_;
		if (vala_scanner_get_identifier_or_keyword (name, _tmp11_) != VALA_TOKEN_TYPE_IDENTIFIER) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = g_ascii_isdigit (string_get (name, (glong) 0));
		}
		_tmp8_ = _tmp9_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = g_strconcat ("@", name, NULL);
		_tmp13_ = _tmp12_;
		valadoc_api_node_set_name (self, _tmp13_);
		_g_free0 (_tmp13_);
	} else {
		valadoc_api_node_set_name (self, name);
	}
	valadoc_api_item_set_parent ((ValadocApiItem*) self, (ValadocApiItem*) parent);
	_tmp14_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp14_;
	return self;
}

/**
 * Visits this node with the specified Visitor.
 *
 * @param visitor the visitor to be called while traversing
 */
static void
valadoc_api_node_real_accept (ValadocApiNode* self,
                              ValadocApiVisitor* visitor)
{
	g_critical ("Type `%s' does not implement abstract method `valadoc_api_node_accept'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
valadoc_api_node_accept (ValadocApiNode* self,
                         ValadocApiVisitor* visitor)
{
	g_return_if_fail (self != NULL);
	VALADOC_API_NODE_GET_CLASS (self)->accept (self, visitor);
}

/**
 * {@inheritDoc}
 */
static gboolean
valadoc_api_node_real_is_browsable (ValadocApiNode* self,
                                    ValadocSettings* settings)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `valadoc_api_node_is_browsable'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
valadoc_api_node_is_browsable (ValadocApiNode* self,
                               ValadocSettings* settings)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALADOC_API_NODE_GET_CLASS (self)->is_browsable (self, settings);
}

/**
 * {@inheritDoc}
 */
static gchar*
valadoc_api_node_real_get_filename (ValadocDocumentation* base)
{
	ValadocApiNode * self;
	ValadocApiSourceFile* _tmp0_;
	ValadocApiSourceFile* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result = NULL;
	self = (ValadocApiNode*) base;
	_tmp0_ = self->priv->file;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->file;
	_tmp2_ = valadoc_api_source_file_get_relative_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	return result;
}

void
valadoc_api_node_add_child (ValadocApiNode* self,
                            ValadocApiSymbol* child)
{
	const gchar* _tmp0_;
	ValaList* children = NULL;
	ValaMap* _tmp8_;
	ValadocApiNodeType _tmp9_;
	ValadocApiNodeType _tmp10_;
	gpointer _tmp11_;
	ValaList* _tmp12_;
	ValaList* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = ((ValadocApiNode*) child)->priv->_name;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = ((ValadocApiNode*) child)->priv->_name;
		if (string_get (_tmp1_, (glong) 0) == '@') {
			ValaMap* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = self->priv->per_name_children;
			_tmp3_ = ((ValadocApiNode*) child)->priv->_name;
			_tmp4_ = g_utf8_next_char (_tmp3_);
			vala_map_set (_tmp2_, _tmp4_, (ValadocApiNode*) child);
		} else {
			ValaMap* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = self->priv->per_name_children;
			_tmp6_ = ((ValadocApiNode*) child)->priv->_name;
			vala_map_set (_tmp5_, _tmp6_, (ValadocApiNode*) child);
		}
	} else {
		ValaMap* _tmp7_;
		_tmp7_ = self->priv->per_name_children;
		vala_map_set (_tmp7_, "", (ValadocApiNode*) child);
	}
	_tmp8_ = self->priv->per_type_children;
	_tmp9_ = valadoc_api_node_get_node_type ((ValadocApiNode*) child);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_map_get (_tmp8_, (gpointer) ((gintptr) _tmp10_));
	children = (ValaList*) _tmp11_;
	_tmp12_ = children;
	if (_tmp12_ == NULL) {
		GEqualFunc _tmp13_;
		ValaArrayList* _tmp14_;
		ValaMap* _tmp15_;
		ValadocApiNodeType _tmp16_;
		ValadocApiNodeType _tmp17_;
		ValaList* _tmp18_;
		_tmp13_ = g_direct_equal;
		_tmp14_ = vala_array_list_new (VALADOC_API_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp13_);
		_vala_iterable_unref0 (children);
		children = (ValaList*) _tmp14_;
		_tmp15_ = self->priv->per_type_children;
		_tmp16_ = valadoc_api_node_get_node_type ((ValadocApiNode*) child);
		_tmp17_ = _tmp16_;
		_tmp18_ = children;
		vala_map_set (_tmp15_, (gpointer) ((gintptr) _tmp17_), _tmp18_);
	}
	_tmp19_ = children;
	vala_collection_add ((ValaCollection*) _tmp19_, (ValadocApiNode*) child);
	_vala_iterable_unref0 (children);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_api_node_real_parse_comments (ValadocApiItem* base,
                                      ValadocSettings* settings,
                                      ValadocDocumentationParser* parser)
{
	ValadocApiNode * self;
	self = (ValadocApiNode*) base;
	g_return_if_fail (settings != NULL);
	g_return_if_fail (parser != NULL);
	self->do_document = TRUE;
	{
		ValaIterator* _node_it = NULL;
		ValaMap* _tmp0_;
		ValaCollection* _tmp1_;
		ValaCollection* _tmp2_;
		ValaIterator* _tmp3_;
		ValaIterator* _tmp4_;
		_tmp0_ = self->priv->per_name_children;
		_tmp1_ = vala_map_get_values (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_iterable_iterator ((ValaIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_vala_iterable_unref0 (_tmp2_);
		_node_it = _tmp4_;
		while (TRUE) {
			ValaIterator* _tmp5_;
			ValadocApiNode* node = NULL;
			ValaIterator* _tmp6_;
			gpointer _tmp7_;
			ValadocApiItem* _tmp8_;
			ValadocApiItem* _tmp9_;
			ValadocApiNode* _tmp10_;
			ValadocApiNode* _tmp11_;
			_tmp5_ = _node_it;
			if (!vala_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _node_it;
			_tmp7_ = vala_iterator_get (_tmp6_);
			node = (ValadocApiNode*) _tmp7_;
			_tmp8_ = valadoc_api_item_get_parent ((ValadocApiItem*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = node;
			if (_tmp9_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALADOC_API_TYPE_ITEM, ValadocApiItem)) {
				_g_object_unref0 (node);
				continue;
			}
			_tmp11_ = node;
			if (valadoc_api_node_is_browsable (_tmp11_, settings)) {
				ValadocApiNode* _tmp12_;
				_tmp12_ = node;
				valadoc_api_item_parse_comments ((ValadocApiItem*) _tmp12_, settings, parser);
			}
			_g_object_unref0 (node);
		}
		_vala_iterator_unref0 (_node_it);
	}
}

/**
 * {@inheritDoc}
 */
static void
valadoc_api_node_real_check_comments (ValadocApiItem* base,
                                      ValadocSettings* settings,
                                      ValadocDocumentationParser* parser)
{
	ValadocApiNode * self;
	self = (ValadocApiNode*) base;
	g_return_if_fail (settings != NULL);
	g_return_if_fail (parser != NULL);
	{
		ValaIterator* _node_it = NULL;
		ValaMap* _tmp0_;
		ValaCollection* _tmp1_;
		ValaCollection* _tmp2_;
		ValaIterator* _tmp3_;
		ValaIterator* _tmp4_;
		_tmp0_ = self->priv->per_name_children;
		_tmp1_ = vala_map_get_values (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_iterable_iterator ((ValaIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_vala_iterable_unref0 (_tmp2_);
		_node_it = _tmp4_;
		while (TRUE) {
			ValaIterator* _tmp5_;
			ValadocApiNode* node = NULL;
			ValaIterator* _tmp6_;
			gpointer _tmp7_;
			ValadocApiItem* _tmp8_;
			ValadocApiItem* _tmp9_;
			ValadocApiNode* _tmp10_;
			ValadocApiNode* _tmp11_;
			_tmp5_ = _node_it;
			if (!vala_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _node_it;
			_tmp7_ = vala_iterator_get (_tmp6_);
			node = (ValadocApiNode*) _tmp7_;
			_tmp8_ = valadoc_api_item_get_parent ((ValadocApiItem*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = node;
			if (_tmp9_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALADOC_API_TYPE_ITEM, ValadocApiItem)) {
				_g_object_unref0 (node);
				continue;
			}
			_tmp11_ = node;
			if (valadoc_api_node_is_browsable (_tmp11_, settings)) {
				ValadocApiNode* _tmp12_;
				_tmp12_ = node;
				valadoc_api_item_check_comments ((ValadocApiItem*) _tmp12_, settings, parser);
			}
			_g_object_unref0 (node);
		}
		_vala_iterator_unref0 (_node_it);
	}
}

/**
 * Specifies whether this node has at least one visible child with the given type
 *
 * @param type a node type
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

gboolean
valadoc_api_node_has_visible_children_by_type (ValadocApiNode* self,
                                               ValadocApiNodeType type,
                                               ValadocSettings* settings)
{
	ValaList* all_children = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValaList* _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (settings != NULL, FALSE);
	_tmp0_ = self->priv->per_type_children;
	_tmp1_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) type));
	all_children = (ValaList*) _tmp1_;
	_tmp2_ = all_children;
	if (_tmp2_ != NULL) {
		{
			ValaList* _node_list = NULL;
			ValaList* _tmp3_;
			ValaList* _tmp4_;
			gint _node_size = 0;
			ValaList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _node_index = 0;
			_tmp3_ = all_children;
			_tmp4_ = _vala_iterable_ref0 (_tmp3_);
			_node_list = _tmp4_;
			_tmp5_ = _node_list;
			_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_node_size = _tmp7_;
			_node_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				ValadocApiNode* node = NULL;
				ValaList* _tmp10_;
				gpointer _tmp11_;
				ValadocApiNode* _tmp12_;
				_node_index = _node_index + 1;
				_tmp8_ = _node_index;
				_tmp9_ = _node_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _node_list;
				_tmp11_ = vala_list_get (_tmp10_, _node_index);
				node = (ValadocApiNode*) _tmp11_;
				_tmp12_ = node;
				if (valadoc_api_node_is_browsable (_tmp12_, settings)) {
					result = TRUE;
					_g_object_unref0 (node);
					_vala_iterable_unref0 (_node_list);
					_vala_iterable_unref0 (all_children);
					return result;
				}
				_g_object_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
	}
	result = FALSE;
	_vala_iterable_unref0 (all_children);
	return result;
}

/**
 * Specifies whether this node has at least one visible child with the given types
 *
 * @param types a list of node types
 */
gboolean
valadoc_api_node_has_visible_children_by_types (ValadocApiNode* self,
                                                ValadocApiNodeType* types,
                                                gint types_length1,
                                                ValadocSettings* settings)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (settings != NULL, FALSE);
	{
		ValadocApiNodeType* type_collection = NULL;
		gint type_collection_length1 = 0;
		gint _type_collection_size_ = 0;
		gint type_it = 0;
		type_collection = types;
		type_collection_length1 = types_length1;
		for (type_it = 0; type_it < type_collection_length1; type_it = type_it + 1) {
			ValadocApiNodeType type = 0;
			type = type_collection[type_it];
			{
				ValadocApiNodeType _tmp0_;
				_tmp0_ = type;
				if (valadoc_api_node_has_visible_children_by_type (self, _tmp0_, settings)) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

/**
 * Specifies whether this node has at least one visible child
 */
gboolean
valadoc_api_node_has_visible_children (ValadocApiNode* self,
                                       ValadocSettings* settings)
{
	ValaMap* _tmp0_;
	ValaSet* _tmp1_;
	ValaSet* _tmp2_;
	gint _tmp3_ = 0;
	gpointer* _tmp4_;
	ValadocApiNodeType* _tmp5_;
	gint _tmp5__length1;
	gboolean _tmp6_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (settings != NULL, FALSE);
	_tmp0_ = self->priv->per_type_children;
	_tmp1_ = vala_map_get_keys (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = vala_collection_to_array ((ValaCollection*) _tmp2_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp6_ = valadoc_api_node_has_visible_children_by_types (self, _tmp5_, (gint) _tmp3_, settings);
	_tmp5_ = (g_free (_tmp5_), NULL);
	_vala_iterable_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}

/**
 * Specifies whether this node has at least one child with the given type
 *
 * @param type a node type
 */
gboolean
valadoc_api_node_has_children_by_type (ValadocApiNode* self,
                                       ValadocApiNodeType type)
{
	ValaList* all_children = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaList* _tmp3_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->per_type_children;
	_tmp1_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) type));
	all_children = (ValaList*) _tmp1_;
	_tmp3_ = all_children;
	if (_tmp3_ != NULL) {
		ValaList* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = all_children;
		_tmp5_ = vala_collection_get_is_empty ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = !_tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_vala_iterable_unref0 (all_children);
	return result;
}

/**
 * Specifies whether this node has at least one child with the given types
 *
 * @param types a list of node types
 */
gboolean
valadoc_api_node_has_children (ValadocApiNode* self,
                               ValadocApiNodeType* types,
                               gint types_length1)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValadocApiNodeType* type_collection = NULL;
		gint type_collection_length1 = 0;
		gint _type_collection_size_ = 0;
		gint type_it = 0;
		type_collection = types;
		type_collection_length1 = types_length1;
		for (type_it = 0; type_it < type_collection_length1; type_it = type_it + 1) {
			ValadocApiNodeType type = 0;
			type = type_collection[type_it];
			{
				ValadocApiNodeType _tmp0_;
				_tmp0_ = type;
				if (valadoc_api_node_has_children_by_type (self, _tmp0_)) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

/**
 * Returns a list of all children with the given type.
 *
 * @param type a node type
 * @param filtered specifies whether nodes which are not browsable should appear in the list
 */
ValaList*
valadoc_api_node_get_children_by_type (ValadocApiNode* self,
                                       ValadocApiNodeType type,
                                       gboolean filtered)
{
	ValaArrayList* children = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValaList* all_children = NULL;
	ValaMap* _tmp2_;
	gpointer _tmp3_;
	ValaList* _tmp4_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	children = _tmp1_;
	_tmp2_ = self->priv->per_type_children;
	_tmp3_ = vala_map_get (_tmp2_, (gpointer) ((gintptr) type));
	all_children = (ValaList*) _tmp3_;
	_tmp4_ = all_children;
	if (_tmp4_ != NULL) {
		{
			ValaList* _node_list = NULL;
			ValaList* _tmp5_;
			ValaList* _tmp6_;
			gint _node_size = 0;
			ValaList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _node_index = 0;
			_tmp5_ = all_children;
			_tmp6_ = _vala_iterable_ref0 (_tmp5_);
			_node_list = _tmp6_;
			_tmp7_ = _node_list;
			_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_node_size = _tmp9_;
			_node_index = -1;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				ValadocApiNode* node = NULL;
				ValaList* _tmp12_;
				gpointer _tmp13_;
				gboolean _tmp14_ = FALSE;
				ValadocApiNode* _tmp15_;
				_node_index = _node_index + 1;
				_tmp10_ = _node_index;
				_tmp11_ = _node_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _node_list;
				_tmp13_ = vala_list_get (_tmp12_, _node_index);
				node = (ValadocApiNode*) _tmp13_;
				_tmp15_ = node;
				if (_tmp15_->do_document) {
					_tmp14_ = TRUE;
				} else {
					_tmp14_ = !filtered;
				}
				if (_tmp14_) {
					ValaArrayList* _tmp16_;
					ValadocApiNode* _tmp17_;
					_tmp16_ = children;
					_tmp17_ = node;
					vala_collection_add ((ValaCollection*) _tmp16_, _tmp17_);
				}
				_g_object_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
	}
	result = (ValaList*) children;
	_vala_iterable_unref0 (all_children);
	return result;
}

/**
 * Returns a list of all children with the given types.
 *
 * @param types a list of node types
 * @param filtered specifies whether nodes which are not browsable should appear in the list
 */
ValaList*
valadoc_api_node_get_children_by_types (ValadocApiNode* self,
                                        ValadocApiNodeType* types,
                                        gint types_length1,
                                        gboolean filtered)
{
	ValaArrayList* children = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	children = _tmp1_;
	{
		ValadocApiNodeType* type_collection = NULL;
		gint type_collection_length1 = 0;
		gint _type_collection_size_ = 0;
		gint type_it = 0;
		type_collection = types;
		type_collection_length1 = types_length1;
		for (type_it = 0; type_it < type_collection_length1; type_it = type_it + 1) {
			ValadocApiNodeType type = 0;
			type = type_collection[type_it];
			{
				ValaArrayList* _tmp2_;
				ValadocApiNodeType _tmp3_;
				ValaList* _tmp4_;
				ValaList* _tmp5_;
				_tmp2_ = children;
				_tmp3_ = type;
				_tmp4_ = valadoc_api_node_get_children_by_type (self, _tmp3_, filtered);
				_tmp5_ = _tmp4_;
				vala_collection_add_all ((ValaCollection*) _tmp2_, (ValaCollection*) _tmp5_);
				_vala_iterable_unref0 (_tmp5_);
			}
		}
	}
	result = (ValaList*) children;
	return result;
}

/**
 * Visits all children of this node with the given type with the specified Visitor.
 *
 * @param type a node type
 * @param visitor the visitor to be called while traversing
 * @param filtered specifies whether nodes which are not browsable should appear in the list
 */
void
valadoc_api_node_accept_children_by_type (ValadocApiNode* self,
                                          ValadocApiNodeType type,
                                          ValadocApiVisitor* visitor,
                                          gboolean filtered)
{
	ValaList* all_children = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValaList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->per_type_children;
	_tmp1_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) type));
	all_children = (ValaList*) _tmp1_;
	_tmp2_ = all_children;
	if (_tmp2_ != NULL) {
		{
			ValaList* _node_list = NULL;
			ValaList* _tmp3_;
			ValaList* _tmp4_;
			gint _node_size = 0;
			ValaList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _node_index = 0;
			_tmp3_ = all_children;
			_tmp4_ = _vala_iterable_ref0 (_tmp3_);
			_node_list = _tmp4_;
			_tmp5_ = _node_list;
			_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_node_size = _tmp7_;
			_node_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				ValadocApiNode* node = NULL;
				ValaList* _tmp10_;
				gpointer _tmp11_;
				gboolean _tmp12_ = FALSE;
				ValadocApiNode* _tmp13_;
				_node_index = _node_index + 1;
				_tmp8_ = _node_index;
				_tmp9_ = _node_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _node_list;
				_tmp11_ = vala_list_get (_tmp10_, _node_index);
				node = (ValadocApiNode*) _tmp11_;
				_tmp13_ = node;
				if (_tmp13_->do_document) {
					_tmp12_ = TRUE;
				} else {
					_tmp12_ = !filtered;
				}
				if (_tmp12_) {
					ValadocApiNode* _tmp14_;
					_tmp14_ = node;
					valadoc_api_node_accept (_tmp14_, visitor);
				}
				_g_object_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
	}
	_vala_iterable_unref0 (all_children);
}

/**
 * Visits all children of this node with the given types with the specified Visitor.
 *
 * @param types a list of node types
 * @param visitor the visitor to be called while traversing
 * @param filtered specifies whether nodes which are not browsable should appear in the list
 */
void
valadoc_api_node_accept_children (ValadocApiNode* self,
                                  ValadocApiNodeType* types,
                                  gint types_length1,
                                  ValadocApiVisitor* visitor,
                                  gboolean filtered)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	{
		ValadocApiNodeType* type_collection = NULL;
		gint type_collection_length1 = 0;
		gint _type_collection_size_ = 0;
		gint type_it = 0;
		type_collection = types;
		type_collection_length1 = types_length1;
		for (type_it = 0; type_it < type_collection_length1; type_it = type_it + 1) {
			ValadocApiNodeType type = 0;
			type = type_collection[type_it];
			{
				ValadocApiNodeType _tmp0_;
				_tmp0_ = type;
				valadoc_api_node_accept_children_by_type (self, _tmp0_, visitor, filtered);
			}
		}
	}
}

/**
 * Visits all children of this node with the specified Visitor.
 *
 * @param visitor the visitor to be called while traversing
 * @param filtered specifies whether nodes which are not browsable should appear in the list
 */
void
valadoc_api_node_accept_all_children (ValadocApiNode* self,
                                      ValadocApiVisitor* visitor,
                                      gboolean filtered)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	{
		ValaIterator* _children_it = NULL;
		ValaMap* _tmp0_;
		ValaCollection* _tmp1_;
		ValaCollection* _tmp2_;
		ValaIterator* _tmp3_;
		ValaIterator* _tmp4_;
		_tmp0_ = self->priv->per_type_children;
		_tmp1_ = vala_map_get_values (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_iterable_iterator ((ValaIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_vala_iterable_unref0 (_tmp2_);
		_children_it = _tmp4_;
		while (TRUE) {
			ValaIterator* _tmp5_;
			ValaList* children = NULL;
			ValaIterator* _tmp6_;
			gpointer _tmp7_;
			ValadocApiItem* _tmp8_;
			ValadocApiItem* _tmp9_;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValadocApiNode* _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _children_it;
			if (!vala_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _children_it;
			_tmp7_ = vala_iterator_get (_tmp6_);
			children = (ValaList*) _tmp7_;
			_tmp8_ = valadoc_api_item_get_parent ((ValadocApiItem*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = children;
			_tmp11_ = vala_list_get (_tmp10_, 0);
			_tmp12_ = (ValadocApiNode*) _tmp11_;
			_tmp13_ = _tmp9_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALADOC_API_TYPE_ITEM, ValadocApiItem);
			_g_object_unref0 (_tmp12_);
			if (_tmp13_) {
				_vala_iterable_unref0 (children);
				continue;
			}
			{
				ValaList* _node_list = NULL;
				ValaList* _tmp14_;
				ValaList* _tmp15_;
				gint _node_size = 0;
				ValaList* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint _node_index = 0;
				_tmp14_ = children;
				_tmp15_ = _vala_iterable_ref0 (_tmp14_);
				_node_list = _tmp15_;
				_tmp16_ = _node_list;
				_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
				_tmp18_ = _tmp17_;
				_node_size = _tmp18_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp19_;
					gint _tmp20_;
					ValadocApiNode* node = NULL;
					ValaList* _tmp21_;
					gpointer _tmp22_;
					gboolean _tmp23_ = FALSE;
					ValadocApiNode* _tmp24_;
					_node_index = _node_index + 1;
					_tmp19_ = _node_index;
					_tmp20_ = _node_size;
					if (!(_tmp19_ < _tmp20_)) {
						break;
					}
					_tmp21_ = _node_list;
					_tmp22_ = vala_list_get (_tmp21_, _node_index);
					node = (ValadocApiNode*) _tmp22_;
					_tmp24_ = node;
					if (_tmp24_->do_document) {
						_tmp23_ = TRUE;
					} else {
						_tmp23_ = !filtered;
					}
					if (_tmp23_) {
						ValadocApiNode* _tmp25_;
						_tmp25_ = node;
						valadoc_api_node_accept (_tmp25_, visitor);
					}
					_g_object_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			_vala_iterable_unref0 (children);
		}
		_vala_iterator_unref0 (_children_it);
	}
}

ValadocApiNode*
valadoc_api_node_find_by_name (ValadocApiNode* self,
                               const gchar* name)
{
	ValadocApiNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (string_get (name, (glong) 0) == '@') {
		ValaMap* _tmp0_;
		const gchar* _tmp1_;
		gpointer _tmp2_;
		_tmp0_ = self->priv->per_name_children;
		_tmp1_ = g_utf8_next_char (name);
		_tmp2_ = vala_map_get (_tmp0_, _tmp1_);
		result = (ValadocApiNode*) _tmp2_;
		return result;
	} else {
		ValaMap* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = self->priv->per_name_children;
		_tmp4_ = vala_map_get (_tmp3_, name);
		result = (ValadocApiNode*) _tmp4_;
		return result;
	}
}

ValadocApiNamespace*
valadoc_api_node_get_nspace (ValadocApiNode* self)
{
	ValadocApiNamespace* result;
	ValadocApiNamespace* _tmp0_;
	ValadocApiNamespace* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nspace;
	if (_tmp0_ == NULL) {
		ValadocApiItem* ast = NULL;
		ValadocApiItem* _tmp1_;
		ValadocApiItem* _tmp8_;
		ValadocApiNamespace* _tmp9_;
		_tmp1_ = _g_object_ref0 ((ValadocApiItem*) self);
		ast = _tmp1_;
		while (TRUE) {
			ValadocApiItem* _tmp2_;
			ValadocApiItem* _tmp3_;
			ValadocApiItem* _tmp4_;
			ValadocApiItem* _tmp5_;
			ValadocApiItem* _tmp6_;
			ValadocApiItem* _tmp7_;
			_tmp2_ = ast;
			if (!(VALADOC_API_IS_NAMESPACE (_tmp2_) == FALSE)) {
				break;
			}
			_tmp3_ = ast;
			_tmp4_ = valadoc_api_item_get_parent (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			_g_object_unref0 (ast);
			ast = _tmp6_;
			_tmp7_ = ast;
			if (_tmp7_ == NULL) {
				result = NULL;
				_g_object_unref0 (ast);
				return result;
			}
		}
		_tmp8_ = ast;
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALADOC_API_TYPE_NAMESPACE, ValadocApiNamespace));
		_g_object_unref0 (self->priv->_nspace);
		self->priv->_nspace = _tmp9_;
		_g_object_unref0 (ast);
	}
	_tmp10_ = self->priv->_nspace;
	result = _tmp10_;
	return result;
}

static ValadocApiPackage*
valadoc_api_node_real_get_package (ValadocDocumentation* base)
{
	ValadocApiPackage* result;
	ValadocApiNode* self;
	ValadocApiPackage* _tmp0_;
	ValadocApiPackage* _tmp10_;
	self = (ValadocApiNode*) base;
	_tmp0_ = self->priv->_package;
	if (_tmp0_ == NULL) {
		ValadocApiItem* ast = NULL;
		ValadocApiItem* _tmp1_;
		ValadocApiItem* _tmp8_;
		ValadocApiPackage* _tmp9_;
		_tmp1_ = _g_object_ref0 ((ValadocApiItem*) self);
		ast = _tmp1_;
		while (TRUE) {
			ValadocApiItem* _tmp2_;
			ValadocApiItem* _tmp3_;
			ValadocApiItem* _tmp4_;
			ValadocApiItem* _tmp5_;
			ValadocApiItem* _tmp6_;
			ValadocApiItem* _tmp7_;
			_tmp2_ = ast;
			if (!(VALADOC_API_IS_PACKAGE (_tmp2_) == FALSE)) {
				break;
			}
			_tmp3_ = ast;
			_tmp4_ = valadoc_api_item_get_parent (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			_g_object_unref0 (ast);
			ast = _tmp6_;
			_tmp7_ = ast;
			if (_tmp7_ == NULL) {
				result = NULL;
				_g_object_unref0 (ast);
				return result;
			}
		}
		_tmp8_ = ast;
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALADOC_API_TYPE_PACKAGE, ValadocApiPackage));
		_g_object_unref0 (self->priv->_package);
		self->priv->_package = _tmp9_;
		_g_object_unref0 (ast);
	}
	_tmp10_ = self->priv->_package;
	result = _tmp10_;
	return result;
}

ValadocContentComment*
valadoc_api_node_get_documentation (ValadocApiNode* self)
{
	ValadocContentComment* result;
	ValadocContentComment* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_documentation;
	result = _tmp0_;
	return result;
}

G_GNUC_INTERNAL void
valadoc_api_node_set_documentation (ValadocApiNode* self,
                                    ValadocContentComment* value)
{
	ValadocContentComment* old_value;
	g_return_if_fail (self != NULL);
	old_value = valadoc_api_node_get_documentation (self);
	if (old_value != value) {
		ValadocContentComment* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_documentation);
		self->priv->_documentation = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_node_properties[VALADOC_API_NODE_DOCUMENTATION_PROPERTY]);
	}
}

/**
 * Returns canonicalized absolute name (GLib.FileStream for instance)
 */
gchar*
valadoc_api_node_get_full_name (ValadocApiNode* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_full_name;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		GString* full_name = NULL;
		const gchar* _tmp2_;
		GString* _tmp3_;
		ValadocApiItem* _tmp4_;
		ValadocApiItem* _tmp5_;
		GString* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp1_ = self->priv->_name;
		if (_tmp1_ == NULL) {
			result = NULL;
			return result;
		}
		_tmp2_ = self->priv->_name;
		_tmp3_ = g_string_new (_tmp2_);
		full_name = _tmp3_;
		_tmp4_ = valadoc_api_item_get_parent ((ValadocApiItem*) self);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			{
				ValadocApiItem* pos = NULL;
				ValadocApiItem* _tmp6_;
				ValadocApiItem* _tmp7_;
				ValadocApiItem* _tmp8_;
				_tmp6_ = valadoc_api_item_get_parent ((ValadocApiItem*) self);
				_tmp7_ = _tmp6_;
				_tmp8_ = _g_object_ref0 (_tmp7_);
				pos = _tmp8_;
				{
					gboolean _tmp9_ = FALSE;
					_tmp9_ = TRUE;
					while (TRUE) {
						ValadocApiItem* _tmp14_;
						gchar* name = NULL;
						ValadocApiItem* _tmp15_;
						const gchar* _tmp16_;
						gchar* _tmp17_;
						const gchar* _tmp18_;
						if (!_tmp9_) {
							ValadocApiItem* _tmp10_;
							ValadocApiItem* _tmp11_;
							ValadocApiItem* _tmp12_;
							ValadocApiItem* _tmp13_;
							_tmp10_ = pos;
							_tmp11_ = valadoc_api_item_get_parent (_tmp10_);
							_tmp12_ = _tmp11_;
							_tmp13_ = _g_object_ref0 (_tmp12_);
							_g_object_unref0 (pos);
							pos = _tmp13_;
						}
						_tmp9_ = FALSE;
						_tmp14_ = pos;
						if (!(VALADOC_API_IS_PACKAGE (_tmp14_) == FALSE)) {
							break;
						}
						_tmp15_ = pos;
						_tmp16_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALADOC_API_TYPE_NODE, ValadocApiNode)->priv->_name;
						_tmp17_ = g_strdup (_tmp16_);
						name = _tmp17_;
						_tmp18_ = name;
						if (_tmp18_ != NULL) {
							GString* _tmp19_;
							GString* _tmp20_;
							const gchar* _tmp21_;
							_tmp19_ = full_name;
							g_string_prepend_unichar (_tmp19_, (gunichar) '.');
							_tmp20_ = full_name;
							_tmp21_ = name;
							g_string_prepend (_tmp20_, _tmp21_);
						}
						_g_free0 (name);
					}
				}
				_g_object_unref0 (pos);
			}
		}
		_tmp22_ = full_name;
		_tmp23_ = _tmp22_->str;
		_tmp24_ = g_strdup (_tmp23_);
		_g_free0 (self->priv->_full_name);
		self->priv->_full_name = _tmp24_;
		_g_string_free0 (full_name);
	}
	_tmp25_ = self->priv->_full_name;
	_tmp26_ = g_strdup (_tmp25_);
	result = _tmp26_;
	return result;
}

/**
 * A comparison function used to sort nodes in alphabetical order
 */
gint
valadoc_api_node_compare_to (ValadocApiNode* self,
                             ValadocApiNode* node)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (node != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = self->priv->_name;
	_tmp2_ = node->priv->_name;
	result = _tmp0_ (_tmp1_, _tmp2_);
	return result;
}

static void
valadoc_api_node_class_init (ValadocApiNodeClass * klass,
                             gpointer klass_data)
{
	valadoc_api_node_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocApiNode_private_offset);
	((ValadocApiNodeClass *) klass)->accept = (void (*) (ValadocApiNode*, ValadocApiVisitor*)) valadoc_api_node_real_accept;
	((ValadocApiNodeClass *) klass)->is_browsable = (gboolean (*) (ValadocApiNode*, ValadocSettings*)) valadoc_api_node_real_is_browsable;
	((ValadocApiItemClass *) klass)->parse_comments = (void (*) (ValadocApiItem*, ValadocSettings*, ValadocDocumentationParser*)) valadoc_api_node_real_parse_comments;
	((ValadocApiItemClass *) klass)->check_comments = (void (*) (ValadocApiItem*, ValadocSettings*, ValadocDocumentationParser*)) valadoc_api_node_real_check_comments;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_api_node_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_api_node_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_api_node_finalize;
	/**
	 * The name of the node
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_NODE_NAME_PROPERTY, valadoc_api_node_properties[VALADOC_API_NODE_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Returns the type of this node
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_NODE_NODE_TYPE_PROPERTY, valadoc_api_node_properties[VALADOC_API_NODE_NODE_TYPE_PROPERTY] = g_param_spec_enum ("node-type", "node-type", "node-type", VALADOC_API_TYPE_NODE_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * The corresponding namespace
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_NODE_NSPACE_PROPERTY, valadoc_api_node_properties[VALADOC_API_NODE_NSPACE_PROPERTY] = g_param_spec_object ("nspace", "nspace", "nspace", VALADOC_API_TYPE_NAMESPACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * The corresponding package such as a vapi or gir file
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_NODE_PACKAGE_PROPERTY, valadoc_api_node_properties[VALADOC_API_NODE_PACKAGE_PROPERTY] = g_param_spec_object ("package", "package", "package", VALADOC_API_TYPE_PACKAGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_NODE_DOCUMENTATION_PROPERTY, valadoc_api_node_properties[VALADOC_API_NODE_DOCUMENTATION_PROPERTY] = g_param_spec_object ("documentation", "documentation", "documentation", VALADOC_CONTENT_TYPE_COMMENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
valadoc_api_node_valadoc_documentation_interface_init (ValadocDocumentationIface * iface,
                                                       gpointer iface_data)
{
	valadoc_api_node_valadoc_documentation_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_filename = (gchar* (*) (ValadocDocumentation*)) valadoc_api_node_real_get_filename;
	iface->get_package = valadoc_api_node_real_get_package;
}

static void
valadoc_api_node_instance_init (ValadocApiNode * self,
                                gpointer klass)
{
	self->priv = valadoc_api_node_get_instance_private (self);
	self->do_document = FALSE;
	self->priv->_nspace = NULL;
	self->priv->_package = NULL;
	self->priv->_full_name = NULL;
}

static void
valadoc_api_node_finalize (GObject * obj)
{
	ValadocApiNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_API_TYPE_NODE, ValadocApiNode);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->_name);
	_vala_map_unref0 (self->priv->per_name_children);
	_vala_map_unref0 (self->priv->per_type_children);
	_g_object_unref0 (self->priv->_nspace);
	_g_object_unref0 (self->priv->_package);
	_g_free0 (self->priv->_full_name);
	_g_object_unref0 (self->priv->_documentation);
	G_OBJECT_CLASS (valadoc_api_node_parent_class)->finalize (obj);
}

/**
 * Represents a node in the api tree.
 */
static GType
valadoc_api_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValadocApiNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_api_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocApiNode), 0, (GInstanceInitFunc) valadoc_api_node_instance_init, NULL };
	static const GInterfaceInfo valadoc_documentation_info = { (GInterfaceInitFunc) valadoc_api_node_valadoc_documentation_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType valadoc_api_node_type_id;
	valadoc_api_node_type_id = g_type_register_static (VALADOC_API_TYPE_ITEM, "ValadocApiNode", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (valadoc_api_node_type_id, VALADOC_TYPE_DOCUMENTATION, &valadoc_documentation_info);
	ValadocApiNode_private_offset = g_type_add_instance_private (valadoc_api_node_type_id, sizeof (ValadocApiNodePrivate));
	return valadoc_api_node_type_id;
}

GType
valadoc_api_node_get_type (void)
{
	static volatile gsize valadoc_api_node_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_api_node_type_id__volatile)) {
		GType valadoc_api_node_type_id;
		valadoc_api_node_type_id = valadoc_api_node_get_type_once ();
		g_once_init_leave (&valadoc_api_node_type_id__volatile, valadoc_api_node_type_id);
	}
	return valadoc_api_node_type_id__volatile;
}

static void
_vala_valadoc_api_node_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	ValadocApiNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_API_TYPE_NODE, ValadocApiNode);
	switch (property_id) {
		case VALADOC_API_NODE_NAME_PROPERTY:
		g_value_set_string (value, valadoc_api_node_get_name (self));
		break;
		case VALADOC_API_NODE_NSPACE_PROPERTY:
		g_value_set_object (value, valadoc_api_node_get_nspace (self));
		break;
		case VALADOC_API_NODE_PACKAGE_PROPERTY:
		g_value_set_object (value, valadoc_documentation_get_package ((ValadocDocumentation*) self));
		break;
		case VALADOC_API_NODE_DOCUMENTATION_PROPERTY:
		g_value_set_object (value, valadoc_api_node_get_documentation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_valadoc_api_node_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	ValadocApiNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_API_TYPE_NODE, ValadocApiNode);
	switch (property_id) {
		case VALADOC_API_NODE_NAME_PROPERTY:
		valadoc_api_node_set_name (self, g_value_get_string (value));
		break;
		case VALADOC_API_NODE_DOCUMENTATION_PROPERTY:
		valadoc_api_node_set_documentation (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

