/* valamethod.c generated by valac, the Vala compiler
 * generated from valamethod.vala, do not modify */

/* valamethod.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaMethodPrivate {
	ValaList* type_parameters;
	ValaMemberBinding _binding;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	gboolean _is_inline;
	gboolean _entry_point;
	ValaParameter* _this_parameter;
	ValaSignal* _signal_reference;
	gboolean _closure;
	gboolean _coroutine;
	gboolean _is_async_callback;
	ValaList* parameters;
	ValaList* preconditions;
	ValaList* postconditions;
	ValaDataType* _return_type;
	ValaMethod* _base_method;
	ValaMethod* _base_interface_method;
	ValaDataType* _base_interface_type;
	gboolean base_methods_valid;
	ValaMethod* callback_method;
	ValaMethod* end_method;
	ValaList* captured_variables;
};

static gint ValaMethod_private_offset;
static gpointer vala_method_parent_class = NULL;
static ValaList* vala_method__empty_expression_list;
static ValaList* vala_method__empty_expression_list = NULL;
static ValaList* vala_method__empty_type_parameter_list;
static ValaList* vala_method__empty_type_parameter_list = NULL;
static ValaCallableIface * vala_method_vala_callable_parent_iface = NULL;

static void vala_method_find_base_methods (ValaMethod* self);
static void vala_method_set_entry_point (ValaMethod* self,
                                  gboolean value);
static void vala_method_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_method_real_get_parameters (ValaCallable* base);
static void vala_method_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_method_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static gboolean vala_method_compatible_internal (ValaMethod* self,
                                          ValaMethod* base_method,
                                          gchar* * invalid_match,
                                          ValaCodeNode* node_reference);
static void vala_method_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference);
static void vala_method_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static void vala_method_find_base_interface_method (ValaMethod* self,
                                             ValaClass* cl);
static void vala_method_find_base_class_method (ValaMethod* self,
                                         ValaClass* cl);
static gboolean vala_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static gboolean vala_method_is_possible_entry_point (ValaMethod* self,
                                              ValaCodeContext* context);
static void vala_method_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection);
static void vala_method_finalize (ValaCodeNode * obj);

static inline gpointer
vala_method_get_instance_private (ValaMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethod_private_offset);
}

static ValaDataType*
vala_method_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_method_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_method_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	result = !VALA_IS_VOID_TYPE (_tmp1_);
	return result;
}

ValaMemberBinding
vala_method_get_binding (ValaMethod* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}

void
vala_method_set_binding (ValaMethod* self,
                         ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_method_get_is_abstract (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_method_set_is_abstract (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_method_get_is_virtual (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}

void
vala_method_set_is_virtual (ValaMethod* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}

gboolean
vala_method_get_overrides (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overrides;
	return result;
}

void
vala_method_set_overrides (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}

gboolean
vala_method_get_is_inline (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_inline;
	return result;
}

void
vala_method_set_is_inline (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_inline = value;
}

gboolean
vala_method_get_returns_floating_reference (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", FALSE);
	return result;
}

void
vala_method_set_returns_floating_reference (ValaMethod* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", value, NULL);
}

gboolean
vala_method_get_returns_modified_pointer (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_returns_modified_pointer (ValaMethod* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer", value, NULL);
}

ValaMethod*
vala_method_get_base_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_method;
	result = _tmp0_;
	return result;
}

ValaMethod*
vala_method_get_base_interface_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_interface_method;
	result = _tmp0_;
	return result;
}

ValaDataType*
vala_method_get_base_interface_type (ValaMethod* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_interface_type;
	result = _tmp0_;
	return result;
}

void
vala_method_set_base_interface_type (ValaMethod* self,
                                     ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	self->priv->_base_interface_type = _tmp0_;
	_tmp1_ = self->priv->_base_interface_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_get_entry_point (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_entry_point;
	return result;
}

static void
vala_method_set_entry_point (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = value;
}

ValaParameter*
vala_method_get_this_parameter (ValaMethod* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}

void
vala_method_set_this_parameter (ValaMethod* self,
                                ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}

gboolean
vala_method_get_printf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "PrintfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_printf_format (ValaMethod* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "PrintfFormat", value, NULL);
}

gboolean
vala_method_get_scanf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ScanfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_scanf_format (ValaMethod* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ScanfFormat", value, NULL);
}

gboolean
vala_method_get_has_construct_function (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", TRUE);
	return result;
}

void
vala_method_set_has_construct_function (ValaMethod* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", value, NULL);
}

ValaSignal*
vala_method_get_signal_reference (ValaMethod* self)
{
	ValaSignal* result;
	ValaSignal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_signal_reference;
	result = _tmp0_;
	return result;
}

void
vala_method_set_signal_reference (ValaMethod* self,
                                  ValaSignal* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_signal_reference = value;
}

gboolean
vala_method_get_closure (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_closure;
	return result;
}

void
vala_method_set_closure (ValaMethod* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_closure = value;
}

gboolean
vala_method_get_coroutine (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_coroutine;
	return result;
}

void
vala_method_set_coroutine (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_coroutine = value;
}

gboolean
vala_method_get_is_async_callback (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_async_callback;
	return result;
}

void
vala_method_set_is_async_callback (ValaMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_async_callback = value;
}

/**
 * Creates a new method.
 *
 * @param name              method name
 * @param return_type       method return type
 * @param source_reference  reference to source code
 * @return                  newly created method
 */
ValaMethod*
vala_method_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaMethod* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaMethod*) vala_subroutine_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}

ValaMethod*
vala_method_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_method_construct (VALA_TYPE_METHOD, name, return_type, source_reference, comment);
}

/**
 * Appends parameter to this method.
 *
 * @param param a formal parameter
 */
static void
vala_method_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}

static ValaList*
vala_method_real_get_parameters (ValaCallable* base)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaList* result = NULL;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->parameters;
	result = _tmp0_;
	return result;
}

/**
 * Remove all parameters from this method.
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

void
vala_method_clear_parameters (ValaMethod* self)
{
	ValaList* _tmp15_;
	g_return_if_fail (self != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaParameter* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp7_ = param;
			_tmp8_ = vala_parameter_get_ellipsis (_tmp7_);
			_tmp9_ = _tmp8_;
			if (!_tmp9_) {
				ValaScope* _tmp10_;
				ValaScope* _tmp11_;
				ValaParameter* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
				_tmp11_ = _tmp10_;
				_tmp12_ = param;
				_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
				_tmp14_ = _tmp13_;
				vala_scope_remove (_tmp11_, _tmp14_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp15_ = self->priv->parameters;
	vala_collection_clear ((ValaCollection*) _tmp15_);
}

gboolean
vala_method_is_variadic (ValaMethod* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaParameter* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp7_ = param;
			_tmp8_ = vala_parameter_get_ellipsis (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}

static void
vala_method_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method (visitor, self);
}

static void
vala_method_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaList* _tmp24_;
	ValaLocalVariable* _tmp33_;
	ValaLocalVariable* _tmp34_;
	ValaList* _tmp37_;
	ValaList* _tmp46_;
	ValaBlock* _tmp55_;
	ValaBlock* _tmp56_;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _p_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = vala_method_get_type_parameters (self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaTypeParameter* _tmp7_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp5_ = _p_list;
			_tmp6_ = vala_list_get (_tmp5_, _p_index);
			p = (ValaTypeParameter*) _tmp6_;
			_tmp7_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp8_ = vala_method_get_base_interface_type (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp10_ = vala_method_get_base_interface_type (self);
		_tmp11_ = _tmp10_;
		vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
	}
	_tmp12_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		_tmp14_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp15_ = _tmp14_;
		vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp16_;
		ValaList* _tmp17_;
		gint _param_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _param_index = 0;
		_tmp16_ = self->priv->parameters;
		_tmp17_ = _vala_iterable_ref0 (_tmp16_);
		_param_list = _tmp17_;
		_tmp18_ = _param_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_param_size = _tmp20_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp21_;
			gpointer _tmp22_;
			ValaParameter* _tmp23_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp21_ = _param_list;
			_tmp22_ = vala_list_get (_tmp21_, _param_index);
			param = (ValaParameter*) _tmp22_;
			_tmp23_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp23_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp24_ = self->error_types;
	if (_tmp24_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp25_;
			ValaList* _tmp26_;
			gint _error_type_size = 0;
			ValaList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _error_type_index = 0;
			_tmp25_ = self->error_types;
			_tmp26_ = _vala_iterable_ref0 (_tmp25_);
			_error_type_list = _tmp26_;
			_tmp27_ = _error_type_list;
			_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
			_tmp29_ = _tmp28_;
			_error_type_size = _tmp29_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp30_;
				gpointer _tmp31_;
				ValaDataType* _tmp32_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp30_ = _error_type_list;
				_tmp31_ = vala_list_get (_tmp30_, _error_type_index);
				error_type = (ValaDataType*) _tmp31_;
				_tmp32_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp32_, visitor);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp33_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp34_ = _tmp33_;
	if (_tmp34_ != NULL) {
		ValaLocalVariable* _tmp35_;
		ValaLocalVariable* _tmp36_;
		_tmp35_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp36_ = _tmp35_;
		vala_code_node_accept ((ValaCodeNode*) _tmp36_, visitor);
	}
	_tmp37_ = self->priv->preconditions;
	if (_tmp37_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp38_;
			ValaList* _tmp39_;
			gint _precondition_size = 0;
			ValaList* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gint _precondition_index = 0;
			_tmp38_ = self->priv->preconditions;
			_tmp39_ = _vala_iterable_ref0 (_tmp38_);
			_precondition_list = _tmp39_;
			_tmp40_ = _precondition_list;
			_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
			_tmp42_ = _tmp41_;
			_precondition_size = _tmp42_;
			_precondition_index = -1;
			while (TRUE) {
				ValaExpression* precondition = NULL;
				ValaList* _tmp43_;
				gpointer _tmp44_;
				ValaExpression* _tmp45_;
				_precondition_index = _precondition_index + 1;
				if (!(_precondition_index < _precondition_size)) {
					break;
				}
				_tmp43_ = _precondition_list;
				_tmp44_ = vala_list_get (_tmp43_, _precondition_index);
				precondition = (ValaExpression*) _tmp44_;
				_tmp45_ = precondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp45_, visitor);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp46_ = self->priv->postconditions;
	if (_tmp46_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp47_;
			ValaList* _tmp48_;
			gint _postcondition_size = 0;
			ValaList* _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			gint _postcondition_index = 0;
			_tmp47_ = self->priv->postconditions;
			_tmp48_ = _vala_iterable_ref0 (_tmp47_);
			_postcondition_list = _tmp48_;
			_tmp49_ = _postcondition_list;
			_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
			_tmp51_ = _tmp50_;
			_postcondition_size = _tmp51_;
			_postcondition_index = -1;
			while (TRUE) {
				ValaExpression* postcondition = NULL;
				ValaList* _tmp52_;
				gpointer _tmp53_;
				ValaExpression* _tmp54_;
				_postcondition_index = _postcondition_index + 1;
				if (!(_postcondition_index < _postcondition_size)) {
					break;
				}
				_tmp52_ = _postcondition_list;
				_tmp53_ = vala_list_get (_tmp52_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp53_;
				_tmp54_ = postcondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp54_, visitor);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp55_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp56_ = _tmp55_;
	if (_tmp56_ != NULL) {
		ValaBlock* _tmp57_;
		ValaBlock* _tmp58_;
		_tmp57_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp58_ = _tmp57_;
		vala_code_node_accept ((ValaCodeNode*) _tmp58_, visitor);
	}
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @param invalid_match error string about which check failed
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible (ValaMethod* self,
                        ValaMethod* base_method,
                        gchar* * invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	_tmp1_ = vala_method_compatible_internal (self, base_method, &_tmp0_, (ValaCodeNode*) self);
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = _tmp0_;
	result = _tmp1_;
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible_no_error (ValaMethod* self,
                                 ValaMethod* base_method)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	result = vala_method_compatible_internal (self, base_method, NULL, NULL);
	return result;
}

static gboolean
vala_method_compatible_internal (ValaMethod* self,
                                 ValaMethod* base_method,
                                 gchar* * invalid_match,
                                 ValaCodeNode* node_reference)
{
	gchar* _vala_invalid_match = NULL;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaObjectType* object_type = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	ValaList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	ValaList* method_type_args = NULL;
	ValaDataType* actual_base_type = NULL;
	ValaDataType* _tmp51_;
	ValaDataType* _tmp52_;
	ValaObjectType* _tmp53_;
	ValaList* _tmp54_;
	ValaDataType* _tmp55_;
	ValaDataType* _tmp56_;
	ValaDataType* _tmp57_;
	ValaDataType* _tmp58_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp67_;
	ValaIterator* _tmp68_;
	gint param_index = 0;
	ValaIterator* _tmp116_;
	ValaArrayList* base_method_errors = NULL;
	GEqualFunc _tmp118_;
	ValaArrayList* _tmp119_;
	ValaArrayList* _tmp120_;
	ValaList* _tmp121_;
	gboolean _tmp142_;
	gboolean _tmp143_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	if (self == base_method) {
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = NULL;
		result = TRUE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp0_ = self->priv->_binding;
	_tmp1_ = base_method->priv->_binding;
	if (_tmp0_ != _tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("incompatible binding");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp2_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	object_type = NULL;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaObjectType* _tmp7_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		_vala_code_node_unref0 (object_type);
		object_type = _tmp7_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaObjectType* _tmp8_;
			ValaObjectTypeSymbol* _tmp9_;
			ValaObjectTypeSymbol* _tmp10_;
			ValaList* _tmp11_;
			ValaList* _tmp12_;
			gint _type_parameter_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _type_parameter_index = 0;
			_tmp8_ = object_type;
			_tmp9_ = vala_object_type_get_object_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_object_type_symbol_get_type_parameters (_tmp10_);
			_tmp12_ = _vala_iterable_ref0 (_tmp11_);
			_type_parameter_list = _tmp12_;
			_tmp13_ = _type_parameter_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_type_parameter_size = _tmp15_;
			_type_parameter_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp16_;
				gpointer _tmp17_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp18_;
				ValaGenericType* _tmp19_;
				ValaGenericType* _tmp20_;
				ValaObjectType* _tmp21_;
				ValaGenericType* _tmp22_;
				_type_parameter_index = _type_parameter_index + 1;
				if (!(_type_parameter_index < _type_parameter_size)) {
					break;
				}
				_tmp16_ = _type_parameter_list;
				_tmp17_ = vala_list_get (_tmp16_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp17_;
				_tmp18_ = type_parameter;
				_tmp19_ = vala_generic_type_new (_tmp18_);
				type_arg = _tmp19_;
				_tmp20_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp20_, TRUE);
				_tmp21_ = object_type;
				_tmp22_ = type_arg;
				vala_data_type_add_type_argument ((ValaDataType*) _tmp21_, (ValaDataType*) _tmp22_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp23_ = vala_method_get_type_parameters (self);
	_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_method_get_type_parameters (base_method);
	_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp25_ < _tmp28_) {
		gchar* _tmp29_;
		_tmp29_ = g_strdup ("too few type parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp29_;
		result = FALSE;
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	} else {
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		ValaList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		_tmp30_ = vala_method_get_type_parameters (self);
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_method_get_type_parameters (base_method);
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp32_ > _tmp35_) {
			gchar* _tmp36_;
			_tmp36_ = g_strdup ("too many type parameters");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp36_;
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
	}
	method_type_args = NULL;
	if (vala_method_has_type_parameters (self)) {
		GEqualFunc _tmp37_;
		ValaArrayList* _tmp38_;
		_tmp37_ = g_direct_equal;
		_tmp38_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp37_);
		_vala_iterable_unref0 (method_type_args);
		method_type_args = (ValaList*) _tmp38_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaList* _tmp39_;
			ValaList* _tmp40_;
			gint _type_parameter_size = 0;
			ValaList* _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			gint _type_parameter_index = 0;
			_tmp39_ = vala_method_get_type_parameters (self);
			_tmp40_ = _vala_iterable_ref0 (_tmp39_);
			_type_parameter_list = _tmp40_;
			_tmp41_ = _type_parameter_list;
			_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
			_tmp43_ = _tmp42_;
			_type_parameter_size = _tmp43_;
			_type_parameter_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp44_;
				gpointer _tmp45_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp46_;
				ValaGenericType* _tmp47_;
				ValaGenericType* _tmp48_;
				ValaList* _tmp49_;
				ValaGenericType* _tmp50_;
				_type_parameter_index = _type_parameter_index + 1;
				if (!(_type_parameter_index < _type_parameter_size)) {
					break;
				}
				_tmp44_ = _type_parameter_list;
				_tmp45_ = vala_list_get (_tmp44_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp45_;
				_tmp46_ = type_parameter;
				_tmp47_ = vala_generic_type_new (_tmp46_);
				type_arg = _tmp47_;
				_tmp48_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp48_, TRUE);
				_tmp49_ = method_type_args;
				_tmp50_ = type_arg;
				vala_collection_add ((ValaCollection*) _tmp49_, (ValaDataType*) _tmp50_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp51_ = vala_callable_get_return_type ((ValaCallable*) base_method);
	_tmp52_ = _tmp51_;
	_tmp53_ = object_type;
	_tmp54_ = method_type_args;
	_tmp55_ = vala_data_type_get_actual_type (_tmp52_, (ValaDataType*) _tmp53_, _tmp54_, node_reference);
	actual_base_type = _tmp55_;
	_tmp56_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp57_ = _tmp56_;
	_tmp58_ = actual_base_type;
	if (!vala_data_type_equals (_tmp57_, _tmp58_)) {
		ValaDataType* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		ValaDataType* _tmp62_;
		ValaDataType* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		_tmp59_ = actual_base_type;
		_tmp60_ = vala_data_type_to_prototype_string (_tmp59_, NULL);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_data_type_to_prototype_string (_tmp63_, NULL);
		_tmp65_ = _tmp64_;
		_tmp66_ = g_strdup_printf ("Base method expected return type `%s', but `%s' was provided", _tmp61_, _tmp65_);
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp66_;
		_g_free0 (_tmp65_);
		_g_free0 (_tmp61_);
		result = FALSE;
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp67_ = self->priv->parameters;
	_tmp68_ = vala_iterable_iterator ((ValaIterable*) _tmp67_);
	method_params_it = _tmp68_;
	param_index = 1;
	{
		ValaList* _base_param_list = NULL;
		ValaList* _tmp69_;
		ValaList* _tmp70_;
		gint _base_param_size = 0;
		ValaList* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gint _base_param_index = 0;
		_tmp69_ = base_method->priv->parameters;
		_tmp70_ = _vala_iterable_ref0 (_tmp69_);
		_base_param_list = _tmp70_;
		_tmp71_ = _base_param_list;
		_tmp72_ = vala_collection_get_size ((ValaCollection*) _tmp71_);
		_tmp73_ = _tmp72_;
		_base_param_size = _tmp73_;
		_base_param_index = -1;
		while (TRUE) {
			ValaParameter* base_param = NULL;
			ValaList* _tmp74_;
			gpointer _tmp75_;
			ValaIterator* _tmp76_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp78_;
			gpointer _tmp79_;
			ValaParameter* _tmp80_;
			gboolean _tmp81_;
			gboolean _tmp82_;
			ValaParameter* _tmp83_;
			gboolean _tmp84_;
			gboolean _tmp85_;
			ValaParameter* _tmp87_;
			gboolean _tmp88_;
			gboolean _tmp89_;
			ValaParameter* _tmp90_;
			gboolean _tmp91_;
			gboolean _tmp92_;
			ValaParameter* _tmp94_;
			gboolean _tmp95_;
			gboolean _tmp96_;
			gint _tmp115_;
			_base_param_index = _base_param_index + 1;
			if (!(_base_param_index < _base_param_size)) {
				break;
			}
			_tmp74_ = _base_param_list;
			_tmp75_ = vala_list_get (_tmp74_, _base_param_index);
			base_param = (ValaParameter*) _tmp75_;
			_tmp76_ = method_params_it;
			if (!vala_iterator_next (_tmp76_)) {
				gchar* _tmp77_;
				_tmp77_ = g_strdup ("too few parameters");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp77_;
				result = FALSE;
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp78_ = method_params_it;
			_tmp79_ = vala_iterator_get (_tmp78_);
			param = (ValaParameter*) _tmp79_;
			_tmp80_ = base_param;
			_tmp81_ = vala_parameter_get_ellipsis (_tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = param;
			_tmp84_ = vala_parameter_get_ellipsis (_tmp83_);
			_tmp85_ = _tmp84_;
			if (_tmp82_ != _tmp85_) {
				gchar* _tmp86_;
				_tmp86_ = g_strdup ("ellipsis parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp86_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp87_ = base_param;
			_tmp88_ = vala_parameter_get_params_array (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp90_ = param;
			_tmp91_ = vala_parameter_get_params_array (_tmp90_);
			_tmp92_ = _tmp91_;
			if (_tmp89_ != _tmp92_) {
				gchar* _tmp93_;
				_tmp93_ = g_strdup ("params array parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp93_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp94_ = base_param;
			_tmp95_ = vala_parameter_get_ellipsis (_tmp94_);
			_tmp96_ = _tmp95_;
			if (!_tmp96_) {
				ValaParameter* _tmp97_;
				ValaParameterDirection _tmp98_;
				ValaParameterDirection _tmp99_;
				ValaParameter* _tmp100_;
				ValaParameterDirection _tmp101_;
				ValaParameterDirection _tmp102_;
				ValaParameter* _tmp104_;
				ValaDataType* _tmp105_;
				ValaDataType* _tmp106_;
				ValaObjectType* _tmp107_;
				ValaList* _tmp108_;
				ValaDataType* _tmp109_;
				ValaDataType* _tmp110_;
				ValaParameter* _tmp111_;
				ValaDataType* _tmp112_;
				ValaDataType* _tmp113_;
				_tmp97_ = base_param;
				_tmp98_ = vala_parameter_get_direction (_tmp97_);
				_tmp99_ = _tmp98_;
				_tmp100_ = param;
				_tmp101_ = vala_parameter_get_direction (_tmp100_);
				_tmp102_ = _tmp101_;
				if (_tmp99_ != _tmp102_) {
					gchar* _tmp103_;
					_tmp103_ = g_strdup_printf ("incompatible direction of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp103_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_tmp104_ = base_param;
				_tmp105_ = vala_variable_get_variable_type ((ValaVariable*) _tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = object_type;
				_tmp108_ = method_type_args;
				_tmp109_ = vala_data_type_get_actual_type (_tmp106_, (ValaDataType*) _tmp107_, _tmp108_, node_reference);
				_vala_code_node_unref0 (actual_base_type);
				actual_base_type = _tmp109_;
				_tmp110_ = actual_base_type;
				_tmp111_ = param;
				_tmp112_ = vala_variable_get_variable_type ((ValaVariable*) _tmp111_);
				_tmp113_ = _tmp112_;
				if (!vala_data_type_equals (_tmp110_, _tmp113_)) {
					gchar* _tmp114_;
					_tmp114_ = g_strdup_printf ("incompatible type of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp114_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
			}
			_tmp115_ = param_index;
			param_index = _tmp115_ + 1;
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (base_param);
		}
		_vala_iterable_unref0 (_base_param_list);
	}
	_tmp116_ = method_params_it;
	if (vala_iterator_next (_tmp116_)) {
		gchar* _tmp117_;
		_tmp117_ = g_strdup ("too many parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp117_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp118_ = g_direct_equal;
	_tmp119_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp118_);
	base_method_errors = _tmp119_;
	_tmp120_ = base_method_errors;
	vala_code_node_get_error_types ((ValaCodeNode*) base_method, (ValaCollection*) _tmp120_, NULL);
	_tmp121_ = self->error_types;
	if (_tmp121_ != NULL) {
		{
			ValaList* _method_error_type_list = NULL;
			ValaList* _tmp122_;
			ValaList* _tmp123_;
			gint _method_error_type_size = 0;
			ValaList* _tmp124_;
			gint _tmp125_;
			gint _tmp126_;
			gint _method_error_type_index = 0;
			_tmp122_ = self->error_types;
			_tmp123_ = _vala_iterable_ref0 (_tmp122_);
			_method_error_type_list = _tmp123_;
			_tmp124_ = _method_error_type_list;
			_tmp125_ = vala_collection_get_size ((ValaCollection*) _tmp124_);
			_tmp126_ = _tmp125_;
			_method_error_type_size = _tmp126_;
			_method_error_type_index = -1;
			while (TRUE) {
				ValaDataType* method_error_type = NULL;
				ValaList* _tmp127_;
				gpointer _tmp128_;
				gboolean match = FALSE;
				_method_error_type_index = _method_error_type_index + 1;
				if (!(_method_error_type_index < _method_error_type_size)) {
					break;
				}
				_tmp127_ = _method_error_type_list;
				_tmp128_ = vala_list_get (_tmp127_, _method_error_type_index);
				method_error_type = (ValaDataType*) _tmp128_;
				match = FALSE;
				{
					ValaArrayList* _base_method_error_type_list = NULL;
					ValaArrayList* _tmp129_;
					ValaArrayList* _tmp130_;
					gint _base_method_error_type_size = 0;
					ValaArrayList* _tmp131_;
					gint _tmp132_;
					gint _tmp133_;
					gint _base_method_error_type_index = 0;
					_tmp129_ = base_method_errors;
					_tmp130_ = _vala_iterable_ref0 (_tmp129_);
					_base_method_error_type_list = _tmp130_;
					_tmp131_ = _base_method_error_type_list;
					_tmp132_ = vala_collection_get_size ((ValaCollection*) _tmp131_);
					_tmp133_ = _tmp132_;
					_base_method_error_type_size = _tmp133_;
					_base_method_error_type_index = -1;
					while (TRUE) {
						ValaDataType* base_method_error_type = NULL;
						ValaArrayList* _tmp134_;
						gpointer _tmp135_;
						ValaDataType* _tmp136_;
						ValaDataType* _tmp137_;
						_base_method_error_type_index = _base_method_error_type_index + 1;
						if (!(_base_method_error_type_index < _base_method_error_type_size)) {
							break;
						}
						_tmp134_ = _base_method_error_type_list;
						_tmp135_ = vala_list_get ((ValaList*) _tmp134_, _base_method_error_type_index);
						base_method_error_type = (ValaDataType*) _tmp135_;
						_tmp136_ = method_error_type;
						_tmp137_ = base_method_error_type;
						if (vala_data_type_compatible (_tmp136_, _tmp137_)) {
							match = TRUE;
							_vala_code_node_unref0 (base_method_error_type);
							break;
						}
						_vala_code_node_unref0 (base_method_error_type);
					}
					_vala_iterable_unref0 (_base_method_error_type_list);
				}
				if (!match) {
					ValaDataType* _tmp138_;
					gchar* _tmp139_;
					gchar* _tmp140_;
					gchar* _tmp141_;
					_tmp138_ = method_error_type;
					_tmp139_ = vala_code_node_to_string ((ValaCodeNode*) _tmp138_);
					_tmp140_ = _tmp139_;
					_tmp141_ = g_strdup_printf ("incompatible error type `%s'", _tmp140_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp141_;
					_g_free0 (_tmp140_);
					result = FALSE;
					_vala_code_node_unref0 (method_error_type);
					_vala_iterable_unref0 (_method_error_type_list);
					_vala_iterable_unref0 (base_method_errors);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_vala_code_node_unref0 (method_error_type);
			}
			_vala_iterable_unref0 (_method_error_type_list);
		}
	}
	_tmp142_ = base_method->priv->_coroutine;
	_tmp143_ = self->priv->_coroutine;
	if (_tmp142_ != _tmp143_) {
		gchar* _tmp144_;
		_tmp144_ = g_strdup ("async mismatch");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp144_;
		result = FALSE;
		_vala_iterable_unref0 (base_method_errors);
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_iterable_unref0 (base_method_errors);
	_vala_iterator_unref0 (method_params_it);
	_vala_code_node_unref0 (actual_base_type);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_method_add_type_parameter (ValaMethod* self,
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_parameters);
		self->priv->type_parameters = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp3_, p);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp7_ = _tmp6_;
	vala_scope_add (_tmp5_, _tmp7_, (ValaSymbol*) p);
}

/**
 * Returns the type parameter list.
 *
 * @return list of type parameters
 */
ValaList*
vala_method_get_type_parameters (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->type_parameters;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_type_parameter_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_type_parameter_list);
		vala_method__empty_type_parameter_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_type_parameter_list;
	result = _tmp5_;
	return result;
}

gint
vala_method_get_type_parameter_index (ValaMethod* self,
                                      const gchar* name)
{
	ValaList* _tmp0_;
	gint i = 0;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	}
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _parameter_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _parameter_index = 0;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_parameter_list = _tmp2_;
		_tmp3_ = _parameter_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_parameter_size = _tmp5_;
		_parameter_index = -1;
		while (TRUE) {
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			_parameter_index = _parameter_index + 1;
			if (!(_parameter_index < _parameter_size)) {
				break;
			}
			_tmp6_ = _parameter_list;
			_tmp7_ = vala_list_get (_tmp6_, _parameter_index);
			parameter = (ValaTypeParameter*) _tmp7_;
			_tmp8_ = parameter;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 (_tmp10_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			_tmp11_ = i;
			i = _tmp11_ + 1;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_type_parameters (ValaMethod* self)
{
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->type_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_parameters;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
 * Adds a precondition to this method.
 *
 * @param precondition a boolean precondition expression
 */
void
vala_method_add_precondition (ValaMethod* self,
                              ValaExpression* precondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (precondition != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->preconditions);
		self->priv->preconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->preconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, precondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) precondition, (ValaCodeNode*) self);
}

/**
 * Returns the list of preconditions of this method.
 *
 * @return list of preconditions
 */
ValaList*
vala_method_get_preconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->preconditions;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_expression_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_expression_list;
	result = _tmp5_;
	return result;
}

/**
 * Adds a postcondition to this method.
 *
 * @param postcondition a boolean postcondition expression
 */
void
vala_method_add_postcondition (ValaMethod* self,
                               ValaExpression* postcondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (postcondition != NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->postconditions);
		self->priv->postconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->postconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, postcondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) postcondition, (ValaCodeNode*) self);
}

/**
 * Returns the list of postconditions of this method.
 *
 * @return list of postconditions
 */
ValaList*
vala_method_get_postconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->postconditions;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_expression_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_expression_list;
	result = _tmp5_;
	return result;
}

/**
 * Adds an error type to the exceptions that can be
 * thrown by this method.
 */
void
vala_method_add_error_type (ValaMethod* self,
                            ValaDataType* error_type)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_type != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->error_types);
		self->error_types = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->error_types;
	vala_collection_add ((ValaCollection*) _tmp3_, error_type);
	vala_code_node_set_parent_node ((ValaCodeNode*) error_type, (ValaCodeNode*) self);
}

static void
vala_method_real_get_error_types (ValaCodeNode* base,
                                  ValaCollection* collection,
                                  ValaSourceReference* source_reference)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _error_type_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _error_type_index = 0;
			_tmp1_ = self->error_types;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_error_type_list = _tmp2_;
			_tmp3_ = _error_type_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_error_type_size = _tmp5_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp6_ = _error_type_list;
				_tmp7_ = vala_list_get (_tmp6_, _error_type_index);
				error_type = (ValaDataType*) _tmp7_;
				if (source_reference != NULL) {
					ValaDataType* type = NULL;
					ValaDataType* _tmp8_;
					ValaDataType* _tmp9_;
					ValaDataType* _tmp10_;
					ValaDataType* _tmp11_;
					_tmp8_ = error_type;
					_tmp9_ = vala_data_type_copy (_tmp8_);
					type = _tmp9_;
					_tmp10_ = type;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp10_, source_reference);
					_tmp11_ = type;
					vala_collection_add (collection, _tmp11_);
					_vala_code_node_unref0 (type);
				} else {
					ValaDataType* _tmp12_;
					_tmp12_ = error_type;
					vala_collection_add (collection, _tmp12_);
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
}

static void
vala_method_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaMethod * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaList* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_method_get_base_interface_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_method_set_base_interface_type (self, new_type);
		return;
	}
	_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp4_ = self->error_types;
	if (_tmp4_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					ValaList* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					ValaList* _tmp10_;
					gpointer _tmp11_;
					ValaDataType* _tmp12_;
					gboolean _tmp13_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = self->error_types;
					_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
					_tmp9_ = _tmp8_;
					if (!(i < _tmp9_)) {
						break;
					}
					_tmp10_ = self->error_types;
					_tmp11_ = vala_list_get (_tmp10_, i);
					_tmp12_ = (ValaDataType*) _tmp11_;
					_tmp13_ = _tmp12_ == old_type;
					_vala_code_node_unref0 (_tmp12_);
					if (_tmp13_) {
						ValaList* _tmp14_;
						_tmp14_ = self->error_types;
						vala_list_set (_tmp14_, i, new_type);
						return;
					}
				}
			}
		}
	}
}

static void
vala_method_find_base_methods (ValaMethod* self)
{
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->base_methods_valid) {
		return;
	}
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_CLASS (_tmp1_)) {
		if (!VALA_IS_CREATION_METHOD (self)) {
			ValaSymbol* _tmp2_;
			ValaSymbol* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp3_ = _tmp2_;
			vala_method_find_base_interface_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
			_tmp6_ = self->priv->_is_virtual;
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				gboolean _tmp7_;
				_tmp7_ = self->priv->_is_abstract;
				_tmp5_ = _tmp7_;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				gboolean _tmp8_;
				_tmp8_ = self->priv->_overrides;
				_tmp4_ = _tmp8_;
			}
			if (_tmp4_) {
				ValaSymbol* _tmp9_;
				ValaSymbol* _tmp10_;
				_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp10_ = _tmp9_;
				vala_method_find_base_class_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CLASS, ValaClass));
			}
		}
	} else {
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		if (VALA_IS_INTERFACE (_tmp12_)) {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			_tmp14_ = self->priv->_is_virtual;
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp15_;
				_tmp15_ = self->priv->_is_abstract;
				_tmp13_ = _tmp15_;
			}
			if (_tmp13_) {
				self->priv->_base_interface_method = self;
			}
		}
	}
	self->priv->base_methods_valid = TRUE;
}

static void
vala_method_find_base_class_method (ValaMethod* self,
                                    ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp11_;
	ValaClass* _tmp35_;
	ValaClass* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (VALA_IS_SIGNAL (_tmp5_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp6_;
		ValaSignal* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = sym;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_SIGNAL, ValaSignal);
		_tmp7_ = sig;
		_tmp8_ = vala_signal_get_default_handler (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp9_);
		_vala_code_node_unref0 (sym);
		sym = _tmp10_;
	}
	_tmp11_ = sym;
	if (VALA_IS_METHOD (_tmp11_)) {
		ValaMethod* base_method = NULL;
		ValaSymbol* _tmp12_;
		gboolean _tmp13_ = FALSE;
		ValaMethod* _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = sym;
		base_method = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_METHOD, ValaMethod);
		_tmp14_ = base_method;
		_tmp15_ = _tmp14_->priv->_is_abstract;
		if (_tmp15_) {
			_tmp13_ = TRUE;
		} else {
			ValaMethod* _tmp16_;
			gboolean _tmp17_;
			_tmp16_ = base_method;
			_tmp17_ = _tmp16_->priv->_is_virtual;
			_tmp13_ = _tmp17_;
		}
		if (_tmp13_) {
			gchar* invalid_match = NULL;
			ValaMethod* _tmp18_;
			gchar* _tmp19_ = NULL;
			gboolean _tmp20_;
			ValaMethod* _tmp33_;
			ValaMethod* _tmp34_;
			_tmp18_ = base_method;
			_tmp20_ = vala_method_compatible (self, _tmp18_, &_tmp19_);
			_g_free0 (invalid_match);
			invalid_match = _tmp19_;
			if (!_tmp20_) {
				ValaMethodType* base_method_type = NULL;
				ValaMethod* _tmp21_;
				ValaMethodType* _tmp22_;
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				ValaMethodType* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp21_ = base_method;
				_tmp22_ = vala_method_type_new (_tmp21_);
				base_method_type = _tmp22_;
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = base_method_type;
				_tmp28_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp27_, NULL);
				_tmp29_ = _tmp28_;
				_tmp30_ = invalid_match;
				_tmp31_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp26_, _tmp29_, _tmp30_);
				_tmp32_ = _tmp31_;
				vala_report_error (_tmp24_, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp26_);
				_vala_code_node_unref0 (base_method_type);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp33_ = base_method;
			self->priv->_base_method = _tmp33_;
			_tmp34_ = base_method;
			vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp34_, "CCode", "instance_pos");
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (sym);
			return;
		}
	}
	_tmp35_ = vala_class_get_base_class (cl);
	_tmp36_ = _tmp35_;
	if (_tmp36_ != NULL) {
		ValaClass* _tmp37_;
		ValaClass* _tmp38_;
		_tmp37_ = vala_class_get_base_class (cl);
		_tmp38_ = _tmp37_;
		vala_method_find_base_class_method (self, _tmp38_);
	}
	_vala_code_node_unref0 (sym);
}

static void
vala_method_find_base_interface_method (ValaMethod* self,
                                        ValaClass* cl)
{
	ValaMethod* base_match = NULL;
	gchar* invalid_error = NULL;
	ValaMethod* invalid_base_match = NULL;
	ValaMethod* _tmp67_;
	ValaDataType* _tmp83_;
	ValaDataType* _tmp84_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	base_match = NULL;
	invalid_error = NULL;
	invalid_base_match = NULL;
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp5_ = _type_list;
			_tmp6_ = vala_list_get (_tmp5_, _type_index);
			type = (ValaDataType*) _tmp6_;
			_tmp7_ = type;
			_tmp8_ = vala_data_type_get_type_symbol (_tmp7_);
			_tmp9_ = _tmp8_;
			if (VALA_IS_INTERFACE (_tmp9_)) {
				gboolean _tmp10_ = FALSE;
				ValaDataType* _tmp11_;
				ValaDataType* _tmp12_;
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp20_;
				ValaTypeSymbol* _tmp21_;
				ValaTypeSymbol* _tmp22_;
				ValaScope* _tmp23_;
				ValaScope* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp28_;
				ValaSymbol* _tmp34_;
				_tmp11_ = vala_method_get_base_interface_type (self);
				_tmp12_ = _tmp11_;
				if (_tmp12_ != NULL) {
					ValaDataType* _tmp13_;
					ValaDataType* _tmp14_;
					ValaTypeSymbol* _tmp15_;
					ValaTypeSymbol* _tmp16_;
					ValaDataType* _tmp17_;
					ValaTypeSymbol* _tmp18_;
					ValaTypeSymbol* _tmp19_;
					_tmp13_ = vala_method_get_base_interface_type (self);
					_tmp14_ = _tmp13_;
					_tmp15_ = vala_data_type_get_type_symbol (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = type;
					_tmp18_ = vala_data_type_get_type_symbol (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp10_ = _tmp16_ != _tmp19_;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					_vala_code_node_unref0 (type);
					continue;
				}
				_tmp20_ = type;
				_tmp21_ = vala_data_type_get_type_symbol (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = vala_symbol_get_scope ((ValaSymbol*) _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_scope_lookup (_tmp24_, _tmp26_);
				sym = _tmp27_;
				_tmp28_ = sym;
				if (VALA_IS_SIGNAL (_tmp28_)) {
					ValaSignal* sig = NULL;
					ValaSymbol* _tmp29_;
					ValaSignal* _tmp30_;
					ValaMethod* _tmp31_;
					ValaMethod* _tmp32_;
					ValaSymbol* _tmp33_;
					_tmp29_ = sym;
					sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_SIGNAL, ValaSignal);
					_tmp30_ = sig;
					_tmp31_ = vala_signal_get_default_handler (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp32_);
					_vala_code_node_unref0 (sym);
					sym = _tmp33_;
				}
				_tmp34_ = sym;
				if (VALA_IS_METHOD (_tmp34_)) {
					ValaMethod* base_method = NULL;
					ValaSymbol* _tmp35_;
					gboolean _tmp36_ = FALSE;
					ValaMethod* _tmp37_;
					gboolean _tmp38_;
					_tmp35_ = sym;
					base_method = G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_METHOD, ValaMethod);
					_tmp37_ = base_method;
					_tmp38_ = _tmp37_->priv->_is_abstract;
					if (_tmp38_) {
						_tmp36_ = TRUE;
					} else {
						ValaMethod* _tmp39_;
						gboolean _tmp40_;
						_tmp39_ = base_method;
						_tmp40_ = _tmp39_->priv->_is_virtual;
						_tmp36_ = _tmp40_;
					}
					if (_tmp36_) {
						ValaDataType* _tmp41_;
						ValaDataType* _tmp42_;
						gchar* invalid_match = NULL;
						ValaMethod* _tmp58_;
						gchar* _tmp59_ = NULL;
						gboolean _tmp60_;
						_tmp41_ = vala_method_get_base_interface_type (self);
						_tmp42_ = _tmp41_;
						if (_tmp42_ == NULL) {
							gboolean has_explicit_implementation = FALSE;
							has_explicit_implementation = FALSE;
							{
								ValaList* _m_list = NULL;
								ValaList* _tmp43_;
								ValaList* _tmp44_;
								gint _m_size = 0;
								ValaList* _tmp45_;
								gint _tmp46_;
								gint _tmp47_;
								gint _m_index = 0;
								_tmp43_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
								_tmp44_ = _vala_iterable_ref0 (_tmp43_);
								_m_list = _tmp44_;
								_tmp45_ = _m_list;
								_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
								_tmp47_ = _tmp46_;
								_m_size = _tmp47_;
								_m_index = -1;
								while (TRUE) {
									ValaMethod* m = NULL;
									ValaList* _tmp48_;
									gpointer _tmp49_;
									gboolean _tmp50_ = FALSE;
									ValaMethod* _tmp51_;
									ValaDataType* _tmp52_;
									ValaDataType* _tmp53_;
									_m_index = _m_index + 1;
									if (!(_m_index < _m_size)) {
										break;
									}
									_tmp48_ = _m_list;
									_tmp49_ = vala_list_get (_tmp48_, _m_index);
									m = (ValaMethod*) _tmp49_;
									_tmp51_ = m;
									_tmp52_ = vala_method_get_base_interface_type (_tmp51_);
									_tmp53_ = _tmp52_;
									if (_tmp53_ != NULL) {
										ValaMethod* _tmp54_;
										ValaMethod* _tmp55_;
										ValaMethod* _tmp56_;
										ValaMethod* _tmp57_;
										_tmp54_ = base_method;
										_tmp55_ = m;
										_tmp56_ = vala_method_get_base_interface_method (_tmp55_);
										_tmp57_ = _tmp56_;
										_tmp50_ = _tmp54_ == _tmp57_;
									} else {
										_tmp50_ = FALSE;
									}
									if (_tmp50_) {
										has_explicit_implementation = TRUE;
										_vala_code_node_unref0 (m);
										break;
									}
									_vala_code_node_unref0 (m);
								}
								_vala_iterable_unref0 (_m_list);
							}
							if (has_explicit_implementation) {
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (type);
								continue;
							}
						}
						invalid_match = NULL;
						_tmp58_ = base_method;
						_tmp60_ = vala_method_compatible (self, _tmp58_, &_tmp59_);
						_g_free0 (invalid_match);
						invalid_match = _tmp59_;
						if (!_tmp60_) {
							const gchar* _tmp61_;
							gchar* _tmp62_;
							ValaMethod* _tmp63_;
							ValaMethod* _tmp64_;
							_tmp61_ = invalid_match;
							_tmp62_ = g_strdup (_tmp61_);
							_g_free0 (invalid_error);
							invalid_error = _tmp62_;
							_tmp63_ = base_method;
							_tmp64_ = _vala_code_node_ref0 (_tmp63_);
							_vala_code_node_unref0 (invalid_base_match);
							invalid_base_match = _tmp64_;
						} else {
							ValaMethod* _tmp65_;
							ValaMethod* _tmp66_;
							_tmp65_ = base_method;
							_tmp66_ = _vala_code_node_ref0 (_tmp65_);
							_vala_code_node_unref0 (base_match);
							base_match = _tmp66_;
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							break;
						}
						_g_free0 (invalid_match);
					}
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	_tmp67_ = base_match;
	if (_tmp67_ != NULL) {
		ValaMethod* _tmp68_;
		ValaMethod* _tmp69_;
		_tmp68_ = base_match;
		self->priv->_base_interface_method = _tmp68_;
		_tmp69_ = base_match;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp69_, "CCode", "instance_pos");
		_vala_code_node_unref0 (invalid_base_match);
		_g_free0 (invalid_error);
		_vala_code_node_unref0 (base_match);
		return;
	} else {
		ValaMethod* _tmp70_;
		_tmp70_ = invalid_base_match;
		if (_tmp70_ != NULL) {
			ValaMethodType* base_method_type = NULL;
			ValaMethod* _tmp71_;
			ValaMethodType* _tmp72_;
			ValaSourceReference* _tmp73_;
			ValaSourceReference* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			ValaMethodType* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			const gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp71_ = invalid_base_match;
			_tmp72_ = vala_method_type_new (_tmp71_);
			base_method_type = _tmp72_;
			_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp74_ = _tmp73_;
			_tmp75_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp76_ = _tmp75_;
			_tmp77_ = base_method_type;
			_tmp78_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp77_, NULL);
			_tmp79_ = _tmp78_;
			_tmp80_ = invalid_error;
			_tmp81_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp76_, _tmp79_, _tmp80_);
			_tmp82_ = _tmp81_;
			vala_report_error (_tmp74_, _tmp82_);
			_g_free0 (_tmp82_);
			_g_free0 (_tmp79_);
			_g_free0 (_tmp76_);
			_vala_code_node_unref0 (base_method_type);
			_vala_code_node_unref0 (invalid_base_match);
			_g_free0 (invalid_error);
			_vala_code_node_unref0 (base_match);
			return;
		}
	}
	_tmp83_ = vala_method_get_base_interface_type (self);
	_tmp84_ = _tmp83_;
	if (_tmp84_ != NULL) {
		ValaSourceReference* _tmp85_;
		ValaSourceReference* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp86_ = _tmp85_;
		_tmp87_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp88_ = _tmp87_;
		_tmp89_ = g_strdup_printf ("`%s': no suitable interface method found to implement", _tmp88_);
		_tmp90_ = _tmp89_;
		vala_report_error (_tmp86_, _tmp90_);
		_g_free0 (_tmp90_);
		_g_free0 (_tmp88_);
	}
	_vala_code_node_unref0 (invalid_base_match);
	_g_free0 (invalid_error);
	_vala_code_node_unref0 (base_match);
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_method_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaMethod * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaAttribute* _tmp4_;
	ValaAttribute* _tmp8_;
	gboolean _tmp9_ = FALSE;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp32_;
	gboolean _tmp68_ = FALSE;
	gboolean _tmp69_;
	gboolean _tmp101_ = FALSE;
	gboolean _tmp102_ = FALSE;
	gboolean _tmp103_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp108_;
	ValaSemanticAnalyzer* _tmp109_;
	ValaSourceFile* _tmp110_;
	ValaSourceFile* _tmp111_;
	ValaSourceFile* _tmp112_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp113_;
	ValaSemanticAnalyzer* _tmp114_;
	ValaSymbol* _tmp115_;
	ValaSymbol* _tmp116_;
	ValaSymbol* _tmp117_;
	ValaSourceReference* _tmp118_;
	ValaSourceReference* _tmp119_;
	ValaSemanticAnalyzer* _tmp126_;
	ValaSemanticAnalyzer* _tmp127_;
	ValaDataType* _tmp128_;
	ValaDataType* _tmp129_;
	gboolean _tmp130_;
	gboolean _tmp131_;
	ValaDataType* _tmp132_;
	ValaDataType* _tmp133_;
	gboolean _tmp134_;
	gboolean _tmp135_;
	ValaAttribute* init_attr = NULL;
	ValaAttribute* _tmp140_;
	ValaAttribute* _tmp141_;
	ValaAttribute* _tmp142_;
	ValaDataType* _tmp149_;
	ValaDataType* _tmp150_;
	gboolean _tmp153_ = FALSE;
	gboolean _tmp154_ = FALSE;
	gboolean _tmp155_ = FALSE;
	ValaList* _tmp156_;
	gint _tmp157_;
	gint _tmp158_;
	gboolean optional_param = FALSE;
	gboolean _tmp225_;
	ValaList* _tmp239_;
	ValaLocalVariable* _tmp260_;
	ValaLocalVariable* _tmp261_;
	ValaList* _tmp264_;
	ValaList* _tmp273_;
	ValaBlock* _tmp282_;
	ValaBlock* _tmp283_;
	ValaSemanticAnalyzer* _tmp286_;
	ValaSemanticAnalyzer* _tmp287_;
	ValaStruct* _tmp288_;
	ValaStruct* _tmp289_;
	gboolean _tmp328_ = FALSE;
	gboolean _tmp329_ = FALSE;
	ValaDataType* _tmp330_;
	ValaDataType* _tmp331_;
	ValaSemanticAnalyzer* _tmp375_;
	ValaSemanticAnalyzer* _tmp376_;
	ValaSourceFile* _tmp377_;
	ValaSemanticAnalyzer* _tmp378_;
	ValaSemanticAnalyzer* _tmp379_;
	ValaSymbol* _tmp380_;
	gboolean _tmp381_ = FALSE;
	gboolean _tmp382_ = FALSE;
	gboolean _tmp383_ = FALSE;
	gboolean _tmp384_;
	gboolean _tmp385_;
	ValaSemanticAnalyzer* _tmp401_;
	ValaSemanticAnalyzer* _tmp402_;
	ValaDataType* _tmp403_;
	ValaDataType* _tmp404_;
	ValaBlock* _tmp453_;
	ValaBlock* _tmp454_;
	gboolean _tmp491_ = FALSE;
	gboolean _tmp492_ = FALSE;
	gboolean _tmp493_ = FALSE;
	gboolean _tmp494_ = FALSE;
	gboolean _tmp495_ = FALSE;
	ValaAttribute* _tmp553_;
	gboolean _tmp554_;
	gboolean _tmp555_;
	gboolean result = FALSE;
	self = (ValaMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DestroysInstance");
	if (_tmp4_ != NULL) {
		ValaParameter* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp5_ = self->priv->_this_parameter;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) _tmp5_);
		_tmp7_ = _tmp6_;
		vala_data_type_set_value_owned (_tmp7_, TRUE);
	}
	_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "NoThrow");
	if (_tmp8_ != NULL) {
		_vala_iterable_unref0 (self->error_types);
		self->error_types = NULL;
	}
	_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp11_ = _tmp10_;
	if (VALA_IS_CLASS (_tmp11_)) {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		_tmp13_ = self->priv->_is_abstract;
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			gboolean _tmp14_;
			_tmp14_ = self->priv->_is_virtual;
			_tmp12_ = _tmp14_;
		}
		_tmp9_ = _tmp12_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		gboolean _tmp17_ = FALSE;
		ValaClass* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp16_ = _tmp15_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_CLASS, ValaClass);
		_tmp18_ = cl;
		_tmp19_ = vala_class_get_is_compact (_tmp18_);
		_tmp20_ = _tmp19_;
		if (_tmp20_) {
			ValaClass* _tmp21_;
			ValaClass* _tmp22_;
			ValaClass* _tmp23_;
			_tmp21_ = cl;
			_tmp22_ = vala_class_get_base_class (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp17_ = _tmp23_ != NULL;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			ValaSourceReference* _tmp24_;
			ValaSourceReference* _tmp25_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp25_ = _tmp24_;
			vala_report_error (_tmp25_, "Abstract and virtual methods may not be declared in derived compact cl" \
"asses");
			result = FALSE;
			return result;
		}
	}
	if (vala_method_is_variadic (self)) {
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_;
		_tmp28_ = self->priv->_is_abstract;
		if (_tmp28_) {
			_tmp27_ = TRUE;
		} else {
			gboolean _tmp29_;
			_tmp29_ = self->priv->_is_virtual;
			_tmp27_ = _tmp29_;
		}
		_tmp26_ = _tmp27_;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		ValaSourceReference* _tmp30_;
		ValaSourceReference* _tmp31_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp31_ = _tmp30_;
		vala_report_error (_tmp31_, "Abstract and virtual methods may not be variadic. Use a `va_list' para" \
"meter instead of `...'.");
		result = FALSE;
		return result;
	}
	_tmp32_ = self->priv->_is_abstract;
	if (_tmp32_) {
		ValaSymbol* _tmp33_;
		ValaSymbol* _tmp34_;
		_tmp33_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp34_ = _tmp33_;
		if (VALA_IS_CLASS (_tmp34_)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaClass* _tmp37_;
			gboolean _tmp38_;
			gboolean _tmp39_;
			_tmp35_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp36_ = _tmp35_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_CLASS, ValaClass);
			_tmp37_ = cl;
			_tmp38_ = vala_class_get_is_abstract (_tmp37_);
			_tmp39_ = _tmp38_;
			if (!_tmp39_) {
				ValaSourceReference* _tmp40_;
				ValaSourceReference* _tmp41_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp41_ = _tmp40_;
				vala_report_error (_tmp41_, "Abstract methods may not be declared in non-abstract classes");
				result = FALSE;
				return result;
			}
		} else {
			ValaSymbol* _tmp42_;
			ValaSymbol* _tmp43_;
			_tmp42_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp43_ = _tmp42_;
			if (!VALA_IS_INTERFACE (_tmp43_)) {
				ValaSourceReference* _tmp44_;
				ValaSourceReference* _tmp45_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp45_ = _tmp44_;
				vala_report_error (_tmp45_, "Abstract methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp46_;
		_tmp46_ = self->priv->_is_virtual;
		if (_tmp46_) {
			gboolean _tmp47_ = FALSE;
			ValaSymbol* _tmp48_;
			ValaSymbol* _tmp49_;
			_tmp48_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp49_ = _tmp48_;
			if (!VALA_IS_CLASS (_tmp49_)) {
				ValaSymbol* _tmp50_;
				ValaSymbol* _tmp51_;
				_tmp50_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp51_ = _tmp50_;
				_tmp47_ = !VALA_IS_INTERFACE (_tmp51_);
			} else {
				_tmp47_ = FALSE;
			}
			if (_tmp47_) {
				ValaSourceReference* _tmp52_;
				ValaSourceReference* _tmp53_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp53_ = _tmp52_;
				vala_report_error (_tmp53_, "Virtual methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		} else {
			gboolean _tmp54_;
			_tmp54_ = self->priv->_overrides;
			if (_tmp54_) {
				ValaSymbol* _tmp55_;
				ValaSymbol* _tmp56_;
				_tmp55_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp56_ = _tmp55_;
				if (!VALA_IS_CLASS (_tmp56_)) {
					ValaSourceReference* _tmp57_;
					ValaSourceReference* _tmp58_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp58_ = _tmp57_;
					vala_report_error (_tmp58_, "Methods may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp59_;
				ValaSymbolAccessibility _tmp60_;
				_tmp59_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp60_ = _tmp59_;
				if (_tmp60_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp61_ = FALSE;
					ValaSymbol* _tmp62_;
					ValaSymbol* _tmp63_;
					_tmp62_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp63_ = _tmp62_;
					if (!VALA_IS_CLASS (_tmp63_)) {
						ValaSymbol* _tmp64_;
						ValaSymbol* _tmp65_;
						_tmp64_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp65_ = _tmp64_;
						_tmp61_ = !VALA_IS_INTERFACE (_tmp65_);
					} else {
						_tmp61_ = FALSE;
					}
					if (_tmp61_) {
						ValaSourceReference* _tmp66_;
						ValaSourceReference* _tmp67_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp67_ = _tmp66_;
						vala_report_error (_tmp67_, "Protected methods may not be declared outside of classes and interface" \
"s");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp69_ = self->priv->_is_abstract;
	if (_tmp69_) {
		ValaBlock* _tmp70_;
		ValaBlock* _tmp71_;
		_tmp70_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp71_ = _tmp70_;
		_tmp68_ = _tmp71_ != NULL;
	} else {
		_tmp68_ = FALSE;
	}
	if (_tmp68_) {
		ValaSourceReference* _tmp72_;
		ValaSourceReference* _tmp73_;
		_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp73_ = _tmp72_;
		vala_report_error (_tmp73_, "Abstract methods cannot have bodies");
	} else {
		gboolean _tmp74_ = FALSE;
		gboolean _tmp75_ = FALSE;
		gboolean _tmp76_;
		_tmp76_ = self->priv->_is_abstract;
		if (_tmp76_) {
			_tmp75_ = TRUE;
		} else {
			gboolean _tmp77_;
			_tmp77_ = self->priv->_is_virtual;
			_tmp75_ = _tmp77_;
		}
		if (_tmp75_) {
			gboolean _tmp78_;
			gboolean _tmp79_;
			_tmp78_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp79_ = _tmp78_;
			_tmp74_ = _tmp79_;
		} else {
			_tmp74_ = FALSE;
		}
		if (_tmp74_) {
			ValaSourceReference* _tmp80_;
			ValaSourceReference* _tmp81_;
			_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp81_ = _tmp80_;
			vala_report_error (_tmp81_, "Extern methods cannot be abstract or virtual");
		} else {
			gboolean _tmp82_ = FALSE;
			gboolean _tmp83_;
			gboolean _tmp84_;
			_tmp83_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp84_ = _tmp83_;
			if (_tmp84_) {
				ValaBlock* _tmp85_;
				ValaBlock* _tmp86_;
				_tmp85_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp86_ = _tmp85_;
				_tmp82_ = _tmp86_ != NULL;
			} else {
				_tmp82_ = FALSE;
			}
			if (_tmp82_) {
				ValaSourceReference* _tmp87_;
				ValaSourceReference* _tmp88_;
				_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp88_ = _tmp87_;
				vala_report_error (_tmp88_, "Extern methods cannot have bodies");
			} else {
				gboolean _tmp89_ = FALSE;
				gboolean _tmp90_ = FALSE;
				gboolean _tmp91_ = FALSE;
				gboolean _tmp92_;
				_tmp92_ = self->priv->_is_abstract;
				if (!_tmp92_) {
					gboolean _tmp93_;
					gboolean _tmp94_;
					_tmp93_ = vala_symbol_get_external ((ValaSymbol*) self);
					_tmp94_ = _tmp93_;
					_tmp91_ = !_tmp94_;
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					ValaSourceFileType _tmp95_;
					ValaSourceFileType _tmp96_;
					_tmp95_ = vala_symbol_get_source_type ((ValaSymbol*) self);
					_tmp96_ = _tmp95_;
					_tmp90_ = _tmp96_ == VALA_SOURCE_FILE_TYPE_SOURCE;
				} else {
					_tmp90_ = FALSE;
				}
				if (_tmp90_) {
					ValaBlock* _tmp97_;
					ValaBlock* _tmp98_;
					_tmp97_ = vala_subroutine_get_body ((ValaSubroutine*) self);
					_tmp98_ = _tmp97_;
					_tmp89_ = _tmp98_ == NULL;
				} else {
					_tmp89_ = FALSE;
				}
				if (_tmp89_) {
					ValaSourceReference* _tmp99_;
					ValaSourceReference* _tmp100_;
					_tmp99_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp100_ = _tmp99_;
					vala_report_error (_tmp100_, "Non-abstract, non-extern methods must have bodies");
				}
			}
		}
	}
	_tmp103_ = self->priv->_coroutine;
	if (_tmp103_) {
		gboolean _tmp104_;
		gboolean _tmp105_;
		_tmp104_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp105_ = _tmp104_;
		_tmp102_ = !_tmp105_;
	} else {
		_tmp102_ = FALSE;
	}
	if (_tmp102_) {
		_tmp101_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp101_ = FALSE;
	}
	if (_tmp101_) {
		ValaSourceReference* _tmp106_;
		ValaSourceReference* _tmp107_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp107_ = _tmp106_;
		vala_report_error (_tmp107_, "gio-2.0 package required for async methods");
		result = FALSE;
		return result;
	}
	_tmp108_ = vala_code_context_get_analyzer (context);
	_tmp109_ = _tmp108_;
	_tmp110_ = vala_semantic_analyzer_get_current_source_file (_tmp109_);
	_tmp111_ = _tmp110_;
	_tmp112_ = _vala_source_file_ref0 (_tmp111_);
	old_source_file = _tmp112_;
	_tmp113_ = vala_code_context_get_analyzer (context);
	_tmp114_ = _tmp113_;
	_tmp115_ = vala_semantic_analyzer_get_current_symbol (_tmp114_);
	_tmp116_ = _tmp115_;
	_tmp117_ = _vala_code_node_ref0 (_tmp116_);
	old_symbol = _tmp117_;
	_tmp118_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp119_ = _tmp118_;
	if (_tmp119_ != NULL) {
		ValaSemanticAnalyzer* _tmp120_;
		ValaSemanticAnalyzer* _tmp121_;
		ValaSourceReference* _tmp122_;
		ValaSourceReference* _tmp123_;
		ValaSourceFile* _tmp124_;
		ValaSourceFile* _tmp125_;
		_tmp120_ = vala_code_context_get_analyzer (context);
		_tmp121_ = _tmp120_;
		_tmp122_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp123_ = _tmp122_;
		_tmp124_ = vala_source_reference_get_file (_tmp123_);
		_tmp125_ = _tmp124_;
		vala_semantic_analyzer_set_current_source_file (_tmp121_, _tmp125_);
	}
	_tmp126_ = vala_code_context_get_analyzer (context);
	_tmp127_ = _tmp126_;
	vala_semantic_analyzer_set_current_symbol (_tmp127_, (ValaSymbol*) self);
	_tmp128_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_method_get_returns_floating_reference (self);
	_tmp131_ = _tmp130_;
	vala_data_type_set_floating_reference (_tmp129_, _tmp131_);
	_tmp132_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp133_ = _tmp132_;
	vala_code_node_check ((ValaCodeNode*) _tmp133_, context);
	_tmp134_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp135_ = _tmp134_;
	if (!_tmp135_) {
		ValaSemanticAnalyzer* _tmp136_;
		ValaSemanticAnalyzer* _tmp137_;
		ValaDataType* _tmp138_;
		ValaDataType* _tmp139_;
		_tmp136_ = vala_code_context_get_analyzer (context);
		_tmp137_ = _tmp136_;
		_tmp138_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp139_ = _tmp138_;
		vala_semantic_analyzer_check_type (_tmp137_, _tmp139_);
	}
	_tmp140_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ModuleInit");
	_tmp141_ = _vala_code_node_ref0 (_tmp140_);
	init_attr = _tmp141_;
	_tmp142_ = init_attr;
	if (_tmp142_ != NULL) {
		ValaSourceReference* _tmp143_;
		ValaSourceReference* _tmp144_;
		ValaSourceFile* _tmp145_;
		ValaSourceFile* _tmp146_;
		ValaCodeContext* _tmp147_;
		ValaCodeContext* _tmp148_;
		_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp144_ = _tmp143_;
		_tmp145_ = vala_source_reference_get_file (_tmp144_);
		_tmp146_ = _tmp145_;
		_tmp147_ = vala_source_file_get_context (_tmp146_);
		_tmp148_ = _tmp147_;
		vala_code_context_set_module_init_method (_tmp148_, self);
	}
	_tmp149_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp150_ = _tmp149_;
	if (_tmp150_ != NULL) {
		ValaDataType* _tmp151_;
		ValaDataType* _tmp152_;
		_tmp151_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp152_ = _tmp151_;
		vala_code_node_check ((ValaCodeNode*) _tmp152_, context);
	}
	_tmp156_ = self->priv->parameters;
	_tmp157_ = vala_collection_get_size ((ValaCollection*) _tmp156_);
	_tmp158_ = _tmp157_;
	if (_tmp158_ == 1) {
		ValaList* _tmp159_;
		gpointer _tmp160_;
		ValaParameter* _tmp161_;
		gboolean _tmp162_;
		gboolean _tmp163_;
		_tmp159_ = self->priv->parameters;
		_tmp160_ = vala_list_get (_tmp159_, 0);
		_tmp161_ = (ValaParameter*) _tmp160_;
		_tmp162_ = vala_parameter_get_ellipsis (_tmp161_);
		_tmp163_ = _tmp162_;
		_tmp155_ = _tmp163_;
		_vala_code_node_unref0 (_tmp161_);
	} else {
		_tmp155_ = FALSE;
	}
	if (_tmp155_) {
		ValaBlock* _tmp164_;
		ValaBlock* _tmp165_;
		_tmp164_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp165_ = _tmp164_;
		_tmp154_ = _tmp165_ != NULL;
	} else {
		_tmp154_ = FALSE;
	}
	if (_tmp154_) {
		ValaMemberBinding _tmp166_;
		_tmp166_ = self->priv->_binding;
		_tmp153_ = _tmp166_ != VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp153_ = FALSE;
	}
	if (_tmp153_) {
		ValaList* _tmp167_;
		gpointer _tmp168_;
		ValaParameter* _tmp169_;
		ValaSourceReference* _tmp170_;
		ValaSourceReference* _tmp171_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp167_ = self->priv->parameters;
		_tmp168_ = vala_list_get (_tmp167_, 0);
		_tmp169_ = (ValaParameter*) _tmp168_;
		_tmp170_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp169_);
		_tmp171_ = _tmp170_;
		vala_report_error (_tmp171_, "Named parameter required before `...'");
		_vala_code_node_unref0 (_tmp169_);
	}
	optional_param = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp172_;
		ValaList* _tmp173_;
		gint _param_size = 0;
		ValaList* _tmp174_;
		gint _tmp175_;
		gint _tmp176_;
		gint _param_index = 0;
		_tmp172_ = self->priv->parameters;
		_tmp173_ = _vala_iterable_ref0 (_tmp172_);
		_param_list = _tmp173_;
		_tmp174_ = _param_list;
		_tmp175_ = vala_collection_get_size ((ValaCollection*) _tmp174_);
		_tmp176_ = _tmp175_;
		_param_size = _tmp176_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp177_;
			gpointer _tmp178_;
			ValaParameter* _tmp179_;
			gboolean _tmp180_ = FALSE;
			gboolean _tmp181_;
			gboolean _tmp188_ = FALSE;
			gboolean _tmp189_ = FALSE;
			gboolean _tmp190_;
			gboolean _tmp191_;
			gboolean _tmp210_;
			gboolean _tmp211_ = FALSE;
			gboolean _tmp212_ = FALSE;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp177_ = _param_list;
			_tmp178_ = vala_list_get (_tmp177_, _param_index);
			param = (ValaParameter*) _tmp178_;
			_tmp179_ = param;
			vala_code_node_check ((ValaCodeNode*) _tmp179_, context);
			_tmp181_ = self->priv->_coroutine;
			if (_tmp181_) {
				ValaParameter* _tmp182_;
				ValaParameterDirection _tmp183_;
				ValaParameterDirection _tmp184_;
				_tmp182_ = param;
				_tmp183_ = vala_parameter_get_direction (_tmp182_);
				_tmp184_ = _tmp183_;
				_tmp180_ = _tmp184_ == VALA_PARAMETER_DIRECTION_REF;
			} else {
				_tmp180_ = FALSE;
			}
			if (_tmp180_) {
				ValaParameter* _tmp185_;
				ValaSourceReference* _tmp186_;
				ValaSourceReference* _tmp187_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp185_ = param;
				_tmp186_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp185_);
				_tmp187_ = _tmp186_;
				vala_report_error (_tmp187_, "Reference parameters are not supported for async methods");
			}
			_tmp190_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp191_ = _tmp190_;
			if (!_tmp191_) {
				gboolean _tmp192_;
				_tmp192_ = self->priv->_coroutine;
				_tmp189_ = _tmp192_;
			} else {
				_tmp189_ = FALSE;
			}
			if (_tmp189_) {
				gboolean _tmp193_ = FALSE;
				ValaParameter* _tmp194_;
				gboolean _tmp195_;
				gboolean _tmp196_;
				_tmp194_ = param;
				_tmp195_ = vala_parameter_get_ellipsis (_tmp194_);
				_tmp196_ = _tmp195_;
				if (_tmp196_) {
					_tmp193_ = TRUE;
				} else {
					ValaParameter* _tmp197_;
					ValaDataType* _tmp198_;
					ValaDataType* _tmp199_;
					ValaTypeSymbol* _tmp200_;
					ValaTypeSymbol* _tmp201_;
					ValaSemanticAnalyzer* _tmp202_;
					ValaSemanticAnalyzer* _tmp203_;
					ValaDataType* _tmp204_;
					ValaTypeSymbol* _tmp205_;
					ValaTypeSymbol* _tmp206_;
					_tmp197_ = param;
					_tmp198_ = vala_variable_get_variable_type ((ValaVariable*) _tmp197_);
					_tmp199_ = _tmp198_;
					_tmp200_ = vala_data_type_get_type_symbol (_tmp199_);
					_tmp201_ = _tmp200_;
					_tmp202_ = vala_code_context_get_analyzer (context);
					_tmp203_ = _tmp202_;
					_tmp204_ = _tmp203_->va_list_type;
					_tmp205_ = vala_data_type_get_type_symbol (_tmp204_);
					_tmp206_ = _tmp205_;
					_tmp193_ = _tmp201_ == _tmp206_;
				}
				_tmp188_ = _tmp193_;
			} else {
				_tmp188_ = FALSE;
			}
			if (_tmp188_) {
				ValaParameter* _tmp207_;
				ValaSourceReference* _tmp208_;
				ValaSourceReference* _tmp209_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp207_ = param;
				_tmp208_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp207_);
				_tmp209_ = _tmp208_;
				vala_report_error (_tmp209_, "Variadic parameters are not supported for async methods");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp210_ = self->priv->_coroutine;
			if (_tmp210_) {
				_vala_code_node_unref0 (param);
				continue;
			}
			if (optional_param) {
				ValaParameter* _tmp213_;
				ValaExpression* _tmp214_;
				ValaExpression* _tmp215_;
				_tmp213_ = param;
				_tmp214_ = vala_variable_get_initializer ((ValaVariable*) _tmp213_);
				_tmp215_ = _tmp214_;
				_tmp212_ = _tmp215_ == NULL;
			} else {
				_tmp212_ = FALSE;
			}
			if (_tmp212_) {
				ValaParameter* _tmp216_;
				gboolean _tmp217_;
				gboolean _tmp218_;
				_tmp216_ = param;
				_tmp217_ = vala_parameter_get_ellipsis (_tmp216_);
				_tmp218_ = _tmp217_;
				_tmp211_ = !_tmp218_;
			} else {
				_tmp211_ = FALSE;
			}
			if (_tmp211_) {
				ValaParameter* _tmp219_;
				ValaSourceReference* _tmp220_;
				ValaSourceReference* _tmp221_;
				_tmp219_ = param;
				_tmp220_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp219_);
				_tmp221_ = _tmp220_;
				vala_report_warning (_tmp221_, "parameter without default follows parameter with default");
			} else {
				ValaParameter* _tmp222_;
				ValaExpression* _tmp223_;
				ValaExpression* _tmp224_;
				_tmp222_ = param;
				_tmp223_ = vala_variable_get_initializer ((ValaVariable*) _tmp222_);
				_tmp224_ = _tmp223_;
				if (_tmp224_ != NULL) {
					optional_param = TRUE;
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp225_ = self->priv->_coroutine;
	if (_tmp225_) {
		gboolean requires_pointer = FALSE;
		requires_pointer = FALSE;
		{
			gint i = 0;
			ValaList* _tmp226_;
			gint _tmp227_;
			gint _tmp228_;
			_tmp226_ = self->priv->parameters;
			_tmp227_ = vala_collection_get_size ((ValaCollection*) _tmp226_);
			_tmp228_ = _tmp227_;
			i = _tmp228_ - 1;
			{
				gboolean _tmp229_ = FALSE;
				_tmp229_ = TRUE;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp231_;
					gpointer _tmp232_;
					ValaParameter* _tmp233_;
					ValaParameterDirection _tmp234_;
					ValaParameterDirection _tmp235_;
					if (!_tmp229_) {
						gint _tmp230_;
						_tmp230_ = i;
						i = _tmp230_ - 1;
					}
					_tmp229_ = FALSE;
					if (!(i >= 0)) {
						break;
					}
					_tmp231_ = self->priv->parameters;
					_tmp232_ = vala_list_get (_tmp231_, i);
					param = (ValaParameter*) _tmp232_;
					_tmp233_ = param;
					_tmp234_ = vala_parameter_get_direction (_tmp233_);
					_tmp235_ = _tmp234_;
					if (_tmp235_ == VALA_PARAMETER_DIRECTION_IN) {
						requires_pointer = TRUE;
					} else {
						if (requires_pointer) {
							ValaParameter* _tmp236_;
							ValaSourceReference* _tmp237_;
							ValaSourceReference* _tmp238_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp236_ = param;
							_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp236_);
							_tmp238_ = _tmp237_;
							vala_report_error (_tmp238_, "Synchronous out-parameters are not supported in async methods");
						}
					}
					_vala_code_node_unref0 (param);
				}
			}
		}
	}
	_tmp239_ = self->error_types;
	if (_tmp239_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp240_;
			ValaList* _tmp241_;
			gint _error_type_size = 0;
			ValaList* _tmp242_;
			gint _tmp243_;
			gint _tmp244_;
			gint _error_type_index = 0;
			_tmp240_ = self->error_types;
			_tmp241_ = _vala_iterable_ref0 (_tmp240_);
			_error_type_list = _tmp241_;
			_tmp242_ = _error_type_list;
			_tmp243_ = vala_collection_get_size ((ValaCollection*) _tmp242_);
			_tmp244_ = _tmp243_;
			_error_type_size = _tmp244_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp245_;
				gpointer _tmp246_;
				ValaDataType* _tmp247_;
				ValaSemanticAnalyzer* _tmp248_;
				ValaSemanticAnalyzer* _tmp249_;
				ValaDataType* _tmp250_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp245_ = _error_type_list;
				_tmp246_ = vala_list_get (_tmp245_, _error_type_index);
				error_type = (ValaDataType*) _tmp246_;
				_tmp247_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp247_, context);
				_tmp248_ = vala_code_context_get_analyzer (context);
				_tmp249_ = _tmp248_;
				_tmp250_ = error_type;
				if (!vala_semantic_analyzer_is_type_accessible (_tmp249_, (ValaSymbol*) self, _tmp250_)) {
					ValaSourceReference* _tmp251_;
					ValaSourceReference* _tmp252_;
					ValaDataType* _tmp253_;
					gchar* _tmp254_;
					gchar* _tmp255_;
					gchar* _tmp256_;
					gchar* _tmp257_;
					gchar* _tmp258_;
					gchar* _tmp259_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp251_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp252_ = _tmp251_;
					_tmp253_ = error_type;
					_tmp254_ = vala_code_node_to_string ((ValaCodeNode*) _tmp253_);
					_tmp255_ = _tmp254_;
					_tmp256_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp257_ = _tmp256_;
					_tmp258_ = g_strdup_printf ("error type `%s' is less accessible than method `%s'", _tmp255_, _tmp257_);
					_tmp259_ = _tmp258_;
					vala_report_error (_tmp252_, _tmp259_);
					_g_free0 (_tmp259_);
					_g_free0 (_tmp257_);
					_g_free0 (_tmp255_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_iterable_unref0 (_error_type_list);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp260_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp261_ = _tmp260_;
	if (_tmp261_ != NULL) {
		ValaLocalVariable* _tmp262_;
		ValaLocalVariable* _tmp263_;
		_tmp262_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp263_ = _tmp262_;
		vala_code_node_check ((ValaCodeNode*) _tmp263_, context);
	}
	_tmp264_ = self->priv->preconditions;
	if (_tmp264_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp265_;
			ValaList* _tmp266_;
			gint _precondition_size = 0;
			ValaList* _tmp267_;
			gint _tmp268_;
			gint _tmp269_;
			gint _precondition_index = 0;
			_tmp265_ = self->priv->preconditions;
			_tmp266_ = _vala_iterable_ref0 (_tmp265_);
			_precondition_list = _tmp266_;
			_tmp267_ = _precondition_list;
			_tmp268_ = vala_collection_get_size ((ValaCollection*) _tmp267_);
			_tmp269_ = _tmp268_;
			_precondition_size = _tmp269_;
			_precondition_index = -1;
			while (TRUE) {
				ValaExpression* precondition = NULL;
				ValaList* _tmp270_;
				gpointer _tmp271_;
				ValaExpression* _tmp272_;
				_precondition_index = _precondition_index + 1;
				if (!(_precondition_index < _precondition_size)) {
					break;
				}
				_tmp270_ = _precondition_list;
				_tmp271_ = vala_list_get (_tmp270_, _precondition_index);
				precondition = (ValaExpression*) _tmp271_;
				_tmp272_ = precondition;
				vala_code_node_check ((ValaCodeNode*) _tmp272_, context);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp273_ = self->priv->postconditions;
	if (_tmp273_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp274_;
			ValaList* _tmp275_;
			gint _postcondition_size = 0;
			ValaList* _tmp276_;
			gint _tmp277_;
			gint _tmp278_;
			gint _postcondition_index = 0;
			_tmp274_ = self->priv->postconditions;
			_tmp275_ = _vala_iterable_ref0 (_tmp274_);
			_postcondition_list = _tmp275_;
			_tmp276_ = _postcondition_list;
			_tmp277_ = vala_collection_get_size ((ValaCollection*) _tmp276_);
			_tmp278_ = _tmp277_;
			_postcondition_size = _tmp278_;
			_postcondition_index = -1;
			while (TRUE) {
				ValaExpression* postcondition = NULL;
				ValaList* _tmp279_;
				gpointer _tmp280_;
				ValaExpression* _tmp281_;
				_postcondition_index = _postcondition_index + 1;
				if (!(_postcondition_index < _postcondition_size)) {
					break;
				}
				_tmp279_ = _postcondition_list;
				_tmp280_ = vala_list_get (_tmp279_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp280_;
				_tmp281_ = postcondition;
				vala_code_node_check ((ValaCodeNode*) _tmp281_, context);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp282_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp283_ = _tmp282_;
	if (_tmp283_ != NULL) {
		ValaBlock* _tmp284_;
		ValaBlock* _tmp285_;
		_tmp284_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp285_ = _tmp284_;
		vala_code_node_check ((ValaCodeNode*) _tmp285_, context);
	}
	_tmp286_ = vala_code_context_get_analyzer (context);
	_tmp287_ = _tmp286_;
	_tmp288_ = vala_semantic_analyzer_get_current_struct (_tmp287_);
	_tmp289_ = _tmp288_;
	if (_tmp289_ != NULL) {
		gboolean _tmp290_ = FALSE;
		gboolean _tmp291_ = FALSE;
		gboolean _tmp292_;
		_tmp292_ = self->priv->_is_abstract;
		if (_tmp292_) {
			_tmp291_ = TRUE;
		} else {
			gboolean _tmp293_;
			_tmp293_ = self->priv->_is_virtual;
			_tmp291_ = _tmp293_;
		}
		if (_tmp291_) {
			_tmp290_ = TRUE;
		} else {
			gboolean _tmp294_;
			_tmp294_ = self->priv->_overrides;
			_tmp290_ = _tmp294_;
		}
		if (_tmp290_) {
			ValaSourceReference* _tmp295_;
			ValaSourceReference* _tmp296_;
			gchar* _tmp297_;
			gchar* _tmp298_;
			gchar* _tmp299_;
			gchar* _tmp300_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp295_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp296_ = _tmp295_;
			_tmp297_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp298_ = _tmp297_;
			_tmp299_ = g_strdup_printf ("A struct member `%s' cannot be marked as override, virtual, or abstrac" \
"t", _tmp298_);
			_tmp300_ = _tmp299_;
			vala_report_error (_tmp296_, _tmp300_);
			_g_free0 (_tmp300_);
			_g_free0 (_tmp298_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	} else {
		gboolean _tmp301_ = FALSE;
		gboolean _tmp302_ = FALSE;
		gboolean _tmp303_;
		_tmp303_ = self->priv->_overrides;
		if (_tmp303_) {
			ValaMethod* _tmp304_;
			ValaMethod* _tmp305_;
			_tmp304_ = vala_method_get_base_method (self);
			_tmp305_ = _tmp304_;
			_tmp302_ = _tmp305_ == NULL;
		} else {
			_tmp302_ = FALSE;
		}
		if (_tmp302_) {
			ValaMethod* _tmp306_;
			ValaMethod* _tmp307_;
			_tmp306_ = vala_method_get_base_interface_method (self);
			_tmp307_ = _tmp306_;
			_tmp301_ = _tmp307_ == NULL;
		} else {
			_tmp301_ = FALSE;
		}
		if (_tmp301_) {
			ValaSourceReference* _tmp308_;
			ValaSourceReference* _tmp309_;
			gchar* _tmp310_;
			gchar* _tmp311_;
			gchar* _tmp312_;
			gchar* _tmp313_;
			_tmp308_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp309_ = _tmp308_;
			_tmp310_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp311_ = _tmp310_;
			_tmp312_ = g_strdup_printf ("`%s': no suitable method found to override", _tmp311_);
			_tmp313_ = _tmp312_;
			vala_report_error (_tmp309_, _tmp313_);
			_g_free0 (_tmp313_);
			_g_free0 (_tmp311_);
		} else {
			gboolean _tmp314_ = FALSE;
			gboolean _tmp315_ = FALSE;
			gboolean _tmp316_ = FALSE;
			gboolean _tmp317_;
			_tmp317_ = self->priv->_is_abstract;
			if (_tmp317_) {
				_tmp316_ = TRUE;
			} else {
				gboolean _tmp318_;
				_tmp318_ = self->priv->_is_virtual;
				_tmp316_ = _tmp318_;
			}
			if (_tmp316_) {
				_tmp315_ = TRUE;
			} else {
				gboolean _tmp319_;
				_tmp319_ = self->priv->_overrides;
				_tmp315_ = _tmp319_;
			}
			if (_tmp315_) {
				ValaSymbolAccessibility _tmp320_;
				ValaSymbolAccessibility _tmp321_;
				_tmp320_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp321_ = _tmp320_;
				_tmp314_ = _tmp321_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp314_ = FALSE;
			}
			if (_tmp314_) {
				ValaSourceReference* _tmp322_;
				ValaSourceReference* _tmp323_;
				gchar* _tmp324_;
				gchar* _tmp325_;
				gchar* _tmp326_;
				gchar* _tmp327_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp322_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp323_ = _tmp322_;
				_tmp324_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp325_ = _tmp324_;
				_tmp326_ = g_strdup_printf ("Private member `%s' cannot be marked as override, virtual, or abstract", _tmp325_);
				_tmp327_ = _tmp326_;
				vala_report_error (_tmp323_, _tmp327_);
				_g_free0 (_tmp327_);
				_g_free0 (_tmp325_);
				result = FALSE;
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
	}
	_tmp330_ = vala_method_get_base_interface_type (self);
	_tmp331_ = _tmp330_;
	if (_tmp331_ != NULL) {
		ValaMethod* _tmp332_;
		ValaMethod* _tmp333_;
		_tmp332_ = vala_method_get_base_interface_method (self);
		_tmp333_ = _tmp332_;
		_tmp329_ = _tmp333_ != NULL;
	} else {
		_tmp329_ = FALSE;
	}
	if (_tmp329_) {
		ValaSymbol* _tmp334_;
		ValaSymbol* _tmp335_;
		_tmp334_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp335_ = _tmp334_;
		_tmp328_ = VALA_IS_CLASS (_tmp335_);
	} else {
		_tmp328_ = FALSE;
	}
	if (_tmp328_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp336_;
		ValaSymbol* _tmp337_;
		_tmp336_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp337_ = _tmp336_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp337_, VALA_TYPE_CLASS, ValaClass);
		{
			ValaList* _m_list = NULL;
			ValaClass* _tmp338_;
			ValaList* _tmp339_;
			ValaList* _tmp340_;
			gint _m_size = 0;
			ValaList* _tmp341_;
			gint _tmp342_;
			gint _tmp343_;
			gint _m_index = 0;
			_tmp338_ = cl;
			_tmp339_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp338_);
			_tmp340_ = _vala_iterable_ref0 (_tmp339_);
			_m_list = _tmp340_;
			_tmp341_ = _m_list;
			_tmp342_ = vala_collection_get_size ((ValaCollection*) _tmp341_);
			_tmp343_ = _tmp342_;
			_m_size = _tmp343_;
			_m_index = -1;
			while (TRUE) {
				ValaMethod* m = NULL;
				ValaList* _tmp344_;
				gpointer _tmp345_;
				gboolean _tmp346_ = FALSE;
				ValaMethod* _tmp347_;
				_m_index = _m_index + 1;
				if (!(_m_index < _m_size)) {
					break;
				}
				_tmp344_ = _m_list;
				_tmp345_ = vala_list_get (_tmp344_, _m_index);
				m = (ValaMethod*) _tmp345_;
				_tmp347_ = m;
				if (_tmp347_ != self) {
					ValaMethod* _tmp348_;
					ValaMethod* _tmp349_;
					ValaMethod* _tmp350_;
					ValaMethod* _tmp351_;
					ValaMethod* _tmp352_;
					_tmp348_ = m;
					_tmp349_ = vala_method_get_base_interface_method (_tmp348_);
					_tmp350_ = _tmp349_;
					_tmp351_ = vala_method_get_base_interface_method (self);
					_tmp352_ = _tmp351_;
					_tmp346_ = _tmp350_ == _tmp352_;
				} else {
					_tmp346_ = FALSE;
				}
				if (_tmp346_) {
					ValaMethod* _tmp353_;
					ValaMethod* _tmp354_;
					ValaSourceReference* _tmp355_;
					ValaSourceReference* _tmp356_;
					ValaClass* _tmp357_;
					gchar* _tmp358_;
					gchar* _tmp359_;
					ValaMethod* _tmp360_;
					ValaMethod* _tmp361_;
					gchar* _tmp362_;
					gchar* _tmp363_;
					gchar* _tmp364_;
					gchar* _tmp365_;
					ValaMethod* _tmp366_;
					ValaSourceReference* _tmp367_;
					ValaSourceReference* _tmp368_;
					ValaMethod* _tmp369_;
					ValaMethod* _tmp370_;
					gchar* _tmp371_;
					gchar* _tmp372_;
					gchar* _tmp373_;
					gchar* _tmp374_;
					_tmp353_ = m;
					vala_code_node_set_checked ((ValaCodeNode*) _tmp353_, TRUE);
					_tmp354_ = m;
					vala_code_node_set_error ((ValaCodeNode*) _tmp354_, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp355_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp356_ = _tmp355_;
					_tmp357_ = cl;
					_tmp358_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp357_);
					_tmp359_ = _tmp358_;
					_tmp360_ = vala_method_get_base_interface_method (self);
					_tmp361_ = _tmp360_;
					_tmp362_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp361_);
					_tmp363_ = _tmp362_;
					_tmp364_ = g_strdup_printf ("`%s' already contains an implementation for `%s'", _tmp359_, _tmp363_);
					_tmp365_ = _tmp364_;
					vala_report_error (_tmp356_, _tmp365_);
					_g_free0 (_tmp365_);
					_g_free0 (_tmp363_);
					_g_free0 (_tmp359_);
					_tmp366_ = m;
					_tmp367_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp366_);
					_tmp368_ = _tmp367_;
					_tmp369_ = vala_method_get_base_interface_method (self);
					_tmp370_ = _tmp369_;
					_tmp371_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp370_);
					_tmp372_ = _tmp371_;
					_tmp373_ = g_strdup_printf ("previous implementation of `%s' was here", _tmp372_);
					_tmp374_ = _tmp373_;
					vala_report_notice (_tmp368_, _tmp374_);
					_g_free0 (_tmp374_);
					_g_free0 (_tmp372_);
					result = FALSE;
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (_m_list);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
	}
	_tmp375_ = vala_code_context_get_analyzer (context);
	_tmp376_ = _tmp375_;
	_tmp377_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp376_, _tmp377_);
	_tmp378_ = vala_code_context_get_analyzer (context);
	_tmp379_ = _tmp378_;
	_tmp380_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp379_, _tmp380_);
	_tmp384_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp385_ = _tmp384_;
	if (!_tmp385_) {
		gboolean _tmp386_;
		_tmp386_ = self->priv->_overrides;
		_tmp383_ = !_tmp386_;
	} else {
		_tmp383_ = FALSE;
	}
	if (_tmp383_) {
		gboolean _tmp387_;
		gboolean _tmp388_;
		_tmp387_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp388_ = _tmp387_;
		_tmp382_ = !_tmp388_;
	} else {
		_tmp382_ = FALSE;
	}
	if (_tmp382_) {
		ValaSymbol* _tmp389_;
		ValaSymbol* _tmp390_;
		_tmp389_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp390_ = _tmp389_;
		_tmp381_ = _tmp390_ != NULL;
		_vala_code_node_unref0 (_tmp390_);
	} else {
		_tmp381_ = FALSE;
	}
	if (_tmp381_) {
		ValaSourceReference* _tmp391_;
		ValaSourceReference* _tmp392_;
		gchar* _tmp393_;
		gchar* _tmp394_;
		ValaSymbol* _tmp395_;
		ValaSymbol* _tmp396_;
		gchar* _tmp397_;
		gchar* _tmp398_;
		gchar* _tmp399_;
		gchar* _tmp400_;
		_tmp391_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp392_ = _tmp391_;
		_tmp393_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp394_ = _tmp393_;
		_tmp395_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp396_ = _tmp395_;
		_tmp397_ = vala_symbol_get_full_name (_tmp396_);
		_tmp398_ = _tmp397_;
		_tmp399_ = g_strdup_printf ("%s hides inherited method `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp394_, _tmp398_);
		_tmp400_ = _tmp399_;
		vala_report_warning (_tmp392_, _tmp400_);
		_g_free0 (_tmp400_);
		_g_free0 (_tmp398_);
		_vala_code_node_unref0 (_tmp396_);
		_g_free0 (_tmp394_);
	}
	_tmp401_ = vala_code_context_get_analyzer (context);
	_tmp402_ = _tmp401_;
	_tmp403_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp404_ = _tmp403_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp402_, (ValaSymbol*) self, _tmp404_)) {
		ValaSourceReference* _tmp405_;
		ValaSourceReference* _tmp406_;
		ValaDataType* _tmp407_;
		ValaDataType* _tmp408_;
		gchar* _tmp409_;
		gchar* _tmp410_;
		gchar* _tmp411_;
		gchar* _tmp412_;
		gchar* _tmp413_;
		gchar* _tmp414_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp405_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp406_ = _tmp405_;
		_tmp407_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp408_ = _tmp407_;
		_tmp409_ = vala_code_node_to_string ((ValaCodeNode*) _tmp408_);
		_tmp410_ = _tmp409_;
		_tmp411_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp412_ = _tmp411_;
		_tmp413_ = g_strdup_printf ("return type `%s' is less accessible than method `%s'", _tmp410_, _tmp412_);
		_tmp414_ = _tmp413_;
		vala_report_error (_tmp406_, _tmp414_);
		_g_free0 (_tmp414_);
		_g_free0 (_tmp412_);
		_g_free0 (_tmp410_);
		result = FALSE;
		_vala_code_node_unref0 (init_attr);
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp415_;
		ValaList* _tmp416_;
		gint _precondition_size = 0;
		ValaList* _tmp417_;
		gint _tmp418_;
		gint _tmp419_;
		gint _precondition_index = 0;
		_tmp415_ = vala_method_get_preconditions (self);
		_tmp416_ = _vala_iterable_ref0 (_tmp415_);
		_precondition_list = _tmp416_;
		_tmp417_ = _precondition_list;
		_tmp418_ = vala_collection_get_size ((ValaCollection*) _tmp417_);
		_tmp419_ = _tmp418_;
		_precondition_size = _tmp419_;
		_precondition_index = -1;
		while (TRUE) {
			ValaExpression* precondition = NULL;
			ValaList* _tmp420_;
			gpointer _tmp421_;
			ValaExpression* _tmp422_;
			gboolean _tmp423_;
			gboolean _tmp424_;
			ValaExpression* _tmp425_;
			ValaDataType* _tmp426_;
			ValaDataType* _tmp427_;
			ValaSemanticAnalyzer* _tmp428_;
			ValaSemanticAnalyzer* _tmp429_;
			ValaDataType* _tmp430_;
			_precondition_index = _precondition_index + 1;
			if (!(_precondition_index < _precondition_size)) {
				break;
			}
			_tmp420_ = _precondition_list;
			_tmp421_ = vala_list_get (_tmp420_, _precondition_index);
			precondition = (ValaExpression*) _tmp421_;
			_tmp422_ = precondition;
			_tmp423_ = vala_code_node_get_error ((ValaCodeNode*) _tmp422_);
			_tmp424_ = _tmp423_;
			if (_tmp424_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp425_ = precondition;
			_tmp426_ = vala_expression_get_value_type (_tmp425_);
			_tmp427_ = _tmp426_;
			_tmp428_ = vala_code_context_get_analyzer (context);
			_tmp429_ = _tmp428_;
			_tmp430_ = _tmp429_->bool_type;
			if (!vala_data_type_compatible (_tmp427_, _tmp430_)) {
				ValaExpression* _tmp431_;
				ValaSourceReference* _tmp432_;
				ValaSourceReference* _tmp433_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp431_ = precondition;
				_tmp432_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp431_);
				_tmp433_ = _tmp432_;
				vala_report_error (_tmp433_, "Precondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp434_;
		ValaList* _tmp435_;
		gint _postcondition_size = 0;
		ValaList* _tmp436_;
		gint _tmp437_;
		gint _tmp438_;
		gint _postcondition_index = 0;
		_tmp434_ = vala_method_get_postconditions (self);
		_tmp435_ = _vala_iterable_ref0 (_tmp434_);
		_postcondition_list = _tmp435_;
		_tmp436_ = _postcondition_list;
		_tmp437_ = vala_collection_get_size ((ValaCollection*) _tmp436_);
		_tmp438_ = _tmp437_;
		_postcondition_size = _tmp438_;
		_postcondition_index = -1;
		while (TRUE) {
			ValaExpression* postcondition = NULL;
			ValaList* _tmp439_;
			gpointer _tmp440_;
			ValaExpression* _tmp441_;
			gboolean _tmp442_;
			gboolean _tmp443_;
			ValaExpression* _tmp444_;
			ValaDataType* _tmp445_;
			ValaDataType* _tmp446_;
			ValaSemanticAnalyzer* _tmp447_;
			ValaSemanticAnalyzer* _tmp448_;
			ValaDataType* _tmp449_;
			_postcondition_index = _postcondition_index + 1;
			if (!(_postcondition_index < _postcondition_size)) {
				break;
			}
			_tmp439_ = _postcondition_list;
			_tmp440_ = vala_list_get (_tmp439_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp440_;
			_tmp441_ = postcondition;
			_tmp442_ = vala_code_node_get_error ((ValaCodeNode*) _tmp441_);
			_tmp443_ = _tmp442_;
			if (_tmp443_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp444_ = postcondition;
			_tmp445_ = vala_expression_get_value_type (_tmp444_);
			_tmp446_ = _tmp445_;
			_tmp447_ = vala_code_context_get_analyzer (context);
			_tmp448_ = _tmp447_;
			_tmp449_ = _tmp448_->bool_type;
			if (!vala_data_type_compatible (_tmp446_, _tmp449_)) {
				ValaExpression* _tmp450_;
				ValaSourceReference* _tmp451_;
				ValaSourceReference* _tmp452_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp450_ = postcondition;
				_tmp451_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp450_);
				_tmp452_ = _tmp451_;
				vala_report_error (_tmp452_, "Postcondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp453_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp454_ = _tmp453_;
	if (_tmp454_ != NULL) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp455_;
		ValaArrayList* _tmp456_;
		ValaBlock* _tmp457_;
		ValaBlock* _tmp458_;
		ValaArrayList* _tmp459_;
		_tmp455_ = g_direct_equal;
		_tmp456_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp455_);
		body_errors = _tmp456_;
		_tmp457_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp458_ = _tmp457_;
		_tmp459_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp458_, (ValaCollection*) _tmp459_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp460_;
			ValaArrayList* _tmp461_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp462_;
			gint _tmp463_;
			gint _tmp464_;
			gint _body_error_type_index = 0;
			_tmp460_ = body_errors;
			_tmp461_ = _vala_iterable_ref0 (_tmp460_);
			_body_error_type_list = _tmp461_;
			_tmp462_ = _body_error_type_list;
			_tmp463_ = vala_collection_get_size ((ValaCollection*) _tmp462_);
			_tmp464_ = _tmp463_;
			_body_error_type_size = _tmp464_;
			_body_error_type_index = -1;
			while (TRUE) {
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp465_;
				gpointer _tmp466_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp467_;
				gboolean _tmp477_ = FALSE;
				ValaDataType* _tmp478_;
				gboolean is_dynamic_error = FALSE;
				gboolean _tmp482_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				if (!(_body_error_type_index < _body_error_type_size)) {
					break;
				}
				_tmp465_ = _body_error_type_list;
				_tmp466_ = vala_list_get ((ValaList*) _tmp465_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp466_;
				can_propagate_error = FALSE;
				_tmp467_ = self->error_types;
				if (_tmp467_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp468_;
						ValaList* _tmp469_;
						gint _method_error_type_size = 0;
						ValaList* _tmp470_;
						gint _tmp471_;
						gint _tmp472_;
						gint _method_error_type_index = 0;
						_tmp468_ = self->error_types;
						_tmp469_ = _vala_iterable_ref0 (_tmp468_);
						_method_error_type_list = _tmp469_;
						_tmp470_ = _method_error_type_list;
						_tmp471_ = vala_collection_get_size ((ValaCollection*) _tmp470_);
						_tmp472_ = _tmp471_;
						_method_error_type_size = _tmp472_;
						_method_error_type_index = -1;
						while (TRUE) {
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp473_;
							gpointer _tmp474_;
							ValaDataType* _tmp475_;
							ValaDataType* _tmp476_;
							_method_error_type_index = _method_error_type_index + 1;
							if (!(_method_error_type_index < _method_error_type_size)) {
								break;
							}
							_tmp473_ = _method_error_type_list;
							_tmp474_ = vala_list_get (_tmp473_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp474_;
							_tmp475_ = body_error_type;
							_tmp476_ = method_error_type;
							if (vala_data_type_compatible (_tmp475_, _tmp476_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
						_vala_iterable_unref0 (_method_error_type_list);
					}
				}
				_tmp478_ = body_error_type;
				if (VALA_IS_ERROR_TYPE (_tmp478_)) {
					ValaDataType* _tmp479_;
					gboolean _tmp480_;
					gboolean _tmp481_;
					_tmp479_ = body_error_type;
					_tmp480_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp479_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp481_ = _tmp480_;
					_tmp477_ = _tmp481_;
				} else {
					_tmp477_ = FALSE;
				}
				is_dynamic_error = _tmp477_;
				if (!can_propagate_error) {
					_tmp482_ = !is_dynamic_error;
				} else {
					_tmp482_ = FALSE;
				}
				if (_tmp482_) {
					ValaDataType* _tmp483_;
					ValaSourceReference* _tmp484_;
					ValaSourceReference* _tmp485_;
					ValaDataType* _tmp486_;
					gchar* _tmp487_;
					gchar* _tmp488_;
					gchar* _tmp489_;
					gchar* _tmp490_;
					_tmp483_ = body_error_type;
					_tmp484_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp483_);
					_tmp485_ = _tmp484_;
					_tmp486_ = body_error_type;
					_tmp487_ = vala_code_node_to_string ((ValaCodeNode*) _tmp486_);
					_tmp488_ = _tmp487_;
					_tmp489_ = g_strdup_printf ("unhandled error `%s'", _tmp488_);
					_tmp490_ = _tmp489_;
					vala_report_warning (_tmp485_, _tmp490_);
					_g_free0 (_tmp490_);
					_g_free0 (_tmp488_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (body_errors);
	}
	if (!VALA_IS_CREATION_METHOD (self)) {
		ValaMemberBinding _tmp496_;
		_tmp496_ = self->priv->_binding;
		_tmp495_ = _tmp496_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp495_ = FALSE;
	}
	if (_tmp495_) {
		gboolean _tmp497_;
		_tmp497_ = self->priv->_overrides;
		_tmp494_ = !_tmp497_;
	} else {
		_tmp494_ = FALSE;
	}
	if (_tmp494_) {
		ValaSymbolAccessibility _tmp498_;
		ValaSymbolAccessibility _tmp499_;
		_tmp498_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp499_ = _tmp498_;
		_tmp493_ = _tmp499_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	} else {
		_tmp493_ = FALSE;
	}
	if (_tmp493_) {
		ValaSymbol* _tmp500_;
		ValaSymbol* _tmp501_;
		_tmp500_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp501_ = _tmp500_;
		_tmp492_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp501_);
	} else {
		_tmp492_ = FALSE;
	}
	if (_tmp492_) {
		ValaSymbol* _tmp502_;
		ValaSymbol* _tmp503_;
		ValaAttribute* _tmp504_;
		_tmp502_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp503_ = _tmp502_;
		_tmp504_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp503_, "DBus");
		_tmp491_ = _tmp504_ != NULL;
	} else {
		_tmp491_ = FALSE;
	}
	if (_tmp491_) {
		ValaAttribute* dbus_attr = NULL;
		ValaAttribute* _tmp505_;
		ValaAttribute* _tmp506_;
		gboolean _tmp507_ = FALSE;
		ValaAttribute* _tmp508_;
		_tmp505_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DBus");
		_tmp506_ = _vala_code_node_ref0 (_tmp505_);
		dbus_attr = _tmp506_;
		_tmp508_ = dbus_attr;
		if (_tmp508_ == NULL) {
			_tmp507_ = TRUE;
		} else {
			ValaAttribute* _tmp509_;
			_tmp509_ = dbus_attr;
			_tmp507_ = vala_attribute_get_bool (_tmp509_, "visible", TRUE);
		}
		if (_tmp507_) {
			gboolean throws_gerror = FALSE;
			gboolean throws_gioerror = FALSE;
			gboolean throws_gdbuserror = FALSE;
			ValaArrayList* error_types = NULL;
			GEqualFunc _tmp510_;
			ValaArrayList* _tmp511_;
			ValaArrayList* _tmp512_;
			gboolean _tmp529_ = FALSE;
			throws_gerror = FALSE;
			throws_gioerror = FALSE;
			throws_gdbuserror = FALSE;
			_tmp510_ = g_direct_equal;
			_tmp511_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp510_);
			error_types = _tmp511_;
			_tmp512_ = error_types;
			vala_code_node_get_error_types ((ValaCodeNode*) self, (ValaCollection*) _tmp512_, NULL);
			{
				ValaArrayList* _error_type_list = NULL;
				ValaArrayList* _tmp513_;
				ValaArrayList* _tmp514_;
				gint _error_type_size = 0;
				ValaArrayList* _tmp515_;
				gint _tmp516_;
				gint _tmp517_;
				gint _error_type_index = 0;
				_tmp513_ = error_types;
				_tmp514_ = _vala_iterable_ref0 (_tmp513_);
				_error_type_list = _tmp514_;
				_tmp515_ = _error_type_list;
				_tmp516_ = vala_collection_get_size ((ValaCollection*) _tmp515_);
				_tmp517_ = _tmp516_;
				_error_type_size = _tmp517_;
				_error_type_index = -1;
				while (TRUE) {
					ValaDataType* error_type = NULL;
					ValaArrayList* _tmp518_;
					gpointer _tmp519_;
					ValaDataType* _tmp520_;
					ValaErrorDomain* error_domain = NULL;
					ValaDataType* _tmp521_;
					ValaErrorDomain* _tmp522_;
					ValaErrorDomain* _tmp523_;
					ValaErrorDomain* _tmp524_;
					gchar* full_error_domain = NULL;
					ValaErrorDomain* _tmp525_;
					gchar* _tmp526_;
					const gchar* _tmp527_;
					_error_type_index = _error_type_index + 1;
					if (!(_error_type_index < _error_type_size)) {
						break;
					}
					_tmp518_ = _error_type_list;
					_tmp519_ = vala_list_get ((ValaList*) _tmp518_, _error_type_index);
					error_type = (ValaDataType*) _tmp519_;
					_tmp520_ = error_type;
					if (!VALA_IS_ERROR_TYPE (_tmp520_)) {
						_vala_code_node_unref0 (error_type);
						continue;
					}
					_tmp521_ = error_type;
					_tmp522_ = vala_error_type_get_error_domain (G_TYPE_CHECK_INSTANCE_CAST (_tmp521_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp523_ = _tmp522_;
					error_domain = _tmp523_;
					_tmp524_ = error_domain;
					if (_tmp524_ == NULL) {
						throws_gerror = TRUE;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp525_ = error_domain;
					_tmp526_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp525_);
					full_error_domain = _tmp526_;
					_tmp527_ = full_error_domain;
					if (g_strcmp0 (_tmp527_, "GLib.IOError") == 0) {
						throws_gioerror = TRUE;
					} else {
						const gchar* _tmp528_;
						_tmp528_ = full_error_domain;
						if (g_strcmp0 (_tmp528_, "GLib.DBusError") == 0) {
							throws_gdbuserror = TRUE;
						}
					}
					_g_free0 (full_error_domain);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			if (!throws_gerror) {
				gboolean _tmp530_ = FALSE;
				if (throws_gioerror) {
					_tmp530_ = throws_gdbuserror;
				} else {
					_tmp530_ = FALSE;
				}
				_tmp529_ = !_tmp530_;
			} else {
				_tmp529_ = FALSE;
			}
			if (_tmp529_) {
				ValaSourceReference* _tmp531_;
				ValaSourceReference* _tmp532_;
				_tmp531_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp532_ = _tmp531_;
				vala_report_warning (_tmp532_, "DBus methods are recommended to throw at least `GLib.Error' or `GLib.D" \
"BusError, GLib.IOError'");
			}
			_vala_iterable_unref0 (error_types);
		}
		_vala_code_node_unref0 (dbus_attr);
	}
	if (vala_method_is_possible_entry_point (self, context)) {
		ValaMethod* _tmp533_;
		ValaMethod* _tmp534_;
		gboolean _tmp543_;
		gboolean _tmp544_;
		gboolean _tmp547_;
		gboolean _tmp550_;
		_tmp533_ = vala_code_context_get_entry_point (context);
		_tmp534_ = _tmp533_;
		if (_tmp534_ != NULL) {
			ValaSourceReference* _tmp535_;
			ValaSourceReference* _tmp536_;
			ValaMethod* _tmp537_;
			ValaMethod* _tmp538_;
			gchar* _tmp539_;
			gchar* _tmp540_;
			gchar* _tmp541_;
			gchar* _tmp542_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp535_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp536_ = _tmp535_;
			_tmp537_ = vala_code_context_get_entry_point (context);
			_tmp538_ = _tmp537_;
			_tmp539_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp538_);
			_tmp540_ = _tmp539_;
			_tmp541_ = g_strdup_printf ("program already has an entry point `%s'", _tmp540_);
			_tmp542_ = _tmp541_;
			vala_report_error (_tmp536_, _tmp542_);
			_g_free0 (_tmp542_);
			_g_free0 (_tmp540_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		vala_method_set_entry_point (self, TRUE);
		vala_code_context_set_entry_point (context, self);
		_tmp543_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp544_ = _tmp543_;
		if (_tmp544_) {
			ValaSourceReference* _tmp545_;
			ValaSourceReference* _tmp546_;
			_tmp545_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp546_ = _tmp545_;
			vala_report_error (_tmp546_, "\"main\" method cannot throw errors");
		}
		_tmp547_ = self->priv->_is_inline;
		if (_tmp547_) {
			ValaSourceReference* _tmp548_;
			ValaSourceReference* _tmp549_;
			_tmp548_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp549_ = _tmp548_;
			vala_report_error (_tmp549_, "\"main\" method cannot be inline");
		}
		_tmp550_ = self->priv->_coroutine;
		if (_tmp550_) {
			ValaSourceReference* _tmp551_;
			ValaSourceReference* _tmp552_;
			_tmp551_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp552_ = _tmp551_;
			vala_report_error (_tmp552_, "\"main\" method cannot be async");
		}
	}
	_tmp553_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkCallback");
	if (_tmp553_ != NULL) {
		vala_symbol_set_used ((ValaSymbol*) self, TRUE);
	}
	_tmp554_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp555_ = _tmp554_;
	result = !_tmp555_;
	_vala_code_node_unref0 (init_attr);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static gboolean
vala_method_is_possible_entry_point (ValaMethod* self,
                                     ValaCodeContext* context)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaMemberBinding _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaList* params = NULL;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	ValaList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	ValaList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	ValaIterator* params_it = NULL;
	ValaList* _tmp34_;
	ValaIterator* _tmp35_;
	ValaIterator* _tmp36_;
	ValaParameter* param = NULL;
	ValaIterator* _tmp37_;
	gpointer _tmp38_;
	ValaParameter* _tmp39_;
	ValaParameterDirection _tmp40_;
	ValaParameterDirection _tmp41_;
	ValaParameter* _tmp42_;
	ValaDataType* _tmp43_;
	ValaDataType* _tmp44_;
	ValaArrayType* array_type = NULL;
	ValaParameter* _tmp45_;
	ValaDataType* _tmp46_;
	ValaDataType* _tmp47_;
	ValaArrayType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaTypeSymbol* _tmp51_;
	ValaTypeSymbol* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	ValaSemanticAnalyzer* _tmp54_;
	ValaDataType* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	ValaTypeSymbol* _tmp57_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_code_context_get_entry_point_name (context);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp4_ = g_strcmp0 (_tmp8_, "main") != 0;
		}
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_context_get_entry_point_name (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp10_, _tmp12_) != 0;
		_g_free0 (_tmp10_);
		if (_tmp13_) {
			result = FALSE;
			return result;
		}
	}
	_tmp14_ = self->priv->_binding;
	if (_tmp14_ == VALA_MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (VALA_IS_VOID_TYPE (_tmp16_)) {
	} else {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaDataType* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_get_type_symbol (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_context_get_analyzer (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->int_type;
		_tmp24_ = vala_data_type_get_type_symbol (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp20_ == _tmp25_) {
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp26_ = vala_callable_get_parameters ((ValaCallable*) self);
	_tmp27_ = _vala_iterable_ref0 (_tmp26_);
	params = _tmp27_;
	_tmp28_ = params;
	_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ == 0) {
		result = TRUE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp31_ = params;
	_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ > 1) {
		result = FALSE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp34_ = params;
	_tmp35_ = vala_iterable_iterator ((ValaIterable*) _tmp34_);
	params_it = _tmp35_;
	_tmp36_ = params_it;
	vala_iterator_next (_tmp36_);
	_tmp37_ = params_it;
	_tmp38_ = vala_iterator_get (_tmp37_);
	param = (ValaParameter*) _tmp38_;
	_tmp39_ = param;
	_tmp40_ = vala_parameter_get_direction (_tmp39_);
	_tmp41_ = _tmp40_;
	if (_tmp41_ == VALA_PARAMETER_DIRECTION_OUT) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp42_ = param;
	_tmp43_ = vala_variable_get_variable_type ((ValaVariable*) _tmp42_);
	_tmp44_ = _tmp43_;
	if (!VALA_IS_ARRAY_TYPE (_tmp44_)) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp45_ = param;
	_tmp46_ = vala_variable_get_variable_type ((ValaVariable*) _tmp45_);
	_tmp47_ = _tmp46_;
	array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
	_tmp48_ = array_type;
	_tmp49_ = vala_array_type_get_element_type (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_data_type_get_type_symbol (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_code_context_get_analyzer (context);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->string_type;
	_tmp56_ = vala_data_type_get_type_symbol (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp52_ != _tmp57_) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (param);
	_vala_iterator_unref0 (params_it);
	_vala_iterable_unref0 (params);
	return result;
}

gint
vala_method_get_required_arguments (ValaMethod* self)
{
	gint n = 0;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaParameter* _tmp8_;
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			gint _tmp14_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp8_ = param;
			_tmp9_ = vala_variable_get_initializer ((ValaVariable*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				_tmp7_ = TRUE;
			} else {
				ValaParameter* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp11_ = param;
				_tmp12_ = vala_parameter_get_ellipsis (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = _tmp13_;
			}
			if (_tmp7_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp14_ = n;
			n = _tmp14_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = n;
	return result;
}

ValaMethod*
vala_method_get_end_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp32_;
	ValaMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->end_method;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaMethod* _tmp31_;
		_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_method_new ("end", _tmp3_, _tmp5_, NULL);
		_vala_code_node_unref0 (self->priv->end_method);
		self->priv->end_method = _tmp6_;
		_tmp7_ = self->priv->end_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->end_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp8_, TRUE);
		_tmp9_ = self->priv->end_method;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp9_, _tmp11_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			gint _param_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _param_index = 0;
			_tmp12_ = vala_method_get_async_end_parameters (self);
			_param_list = _tmp12_;
			_tmp13_ = _param_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_param_size = _tmp15_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp16_;
				gpointer _tmp17_;
				ValaMethod* _tmp18_;
				ValaParameter* _tmp19_;
				ValaParameter* _tmp20_;
				ValaParameter* _tmp21_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp16_ = _param_list;
				_tmp17_ = vala_list_get (_tmp16_, _param_index);
				param = (ValaParameter*) _tmp17_;
				_tmp18_ = self->priv->end_method;
				_tmp19_ = param;
				_tmp20_ = vala_parameter_copy (_tmp19_);
				_tmp21_ = _tmp20_;
				vala_callable_add_parameter ((ValaCallable*) _tmp18_, _tmp21_);
				_vala_code_node_unref0 (_tmp21_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp22_;
			ValaList* _tmp23_;
			gint _param_size = 0;
			ValaList* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _param_index = 0;
			_tmp22_ = vala_method_get_type_parameters (self);
			_tmp23_ = _vala_iterable_ref0 (_tmp22_);
			_param_list = _tmp23_;
			_tmp24_ = _param_list;
			_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
			_tmp26_ = _tmp25_;
			_param_size = _tmp26_;
			_param_index = -1;
			while (TRUE) {
				ValaTypeParameter* param = NULL;
				ValaList* _tmp27_;
				gpointer _tmp28_;
				ValaMethod* _tmp29_;
				ValaTypeParameter* _tmp30_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp27_ = _param_list;
				_tmp28_ = vala_list_get (_tmp27_, _param_index);
				param = (ValaTypeParameter*) _tmp28_;
				_tmp29_ = self->priv->end_method;
				_tmp30_ = param;
				vala_method_add_type_parameter (_tmp29_, _tmp30_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp31_ = self->priv->end_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp31_, (ValaCodeNode*) self, "CCode", "async_result_pos");
	}
	_tmp32_ = self->priv->end_method;
	result = _tmp32_;
	return result;
}

ValaMethod*
vala_method_get_callback_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp24_;
	ValaMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->callback_method;
	if (_tmp1_ == NULL) {
		ValaBooleanType* bool_type = NULL;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		ValaNamespace* _tmp4_;
		ValaNamespace* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaStruct* _tmp9_;
		ValaBooleanType* _tmp10_;
		ValaBooleanType* _tmp11_;
		ValaBooleanType* _tmp12_;
		ValaBooleanType* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		ValaMethod* _tmp23_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_scope_lookup (_tmp7_, "bool");
		_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp10_ = vala_boolean_type_new (_tmp9_);
		_tmp11_ = _tmp10_;
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_context_unref0 (_tmp3_);
		bool_type = _tmp11_;
		_tmp12_ = bool_type;
		vala_data_type_set_value_owned ((ValaDataType*) _tmp12_, TRUE);
		_tmp13_ = bool_type;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_method_new ("callback", (ValaDataType*) _tmp13_, _tmp15_, NULL);
		_vala_code_node_unref0 (self->priv->callback_method);
		self->priv->callback_method = _tmp16_;
		_tmp17_ = self->priv->callback_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp17_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp18_ = self->priv->callback_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp18_, TRUE);
		_tmp19_ = self->priv->callback_method;
		vala_method_set_binding (_tmp19_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp20_ = self->priv->callback_method;
		_tmp21_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp22_ = _tmp21_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp20_, _tmp22_);
		_tmp23_ = self->priv->callback_method;
		vala_method_set_is_async_callback (_tmp23_, TRUE);
		_vala_code_node_unref0 (bool_type);
	}
	_tmp24_ = self->priv->callback_method;
	result = _tmp24_;
	return result;
}

ValaList*
vala_method_get_async_begin_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaParameter* ellipsis = NULL;
	ValaDelegateType* callback_type = NULL;
	ValaSymbol* _tmp28_;
	ValaScope* _tmp29_;
	ValaScope* _tmp30_;
	ValaSymbol* _tmp31_;
	ValaDelegate* _tmp32_;
	ValaDelegateType* _tmp33_;
	ValaDelegateType* _tmp34_;
	ValaDelegateType* _tmp35_;
	ValaDelegateType* _tmp36_;
	ValaDelegateType* _tmp37_;
	ValaParameter* callback_param = NULL;
	ValaDelegateType* _tmp38_;
	ValaParameter* _tmp39_;
	ValaParameter* _tmp40_;
	ValaSourceReference* _tmp41_;
	ValaSourceReference* _tmp42_;
	ValaNullLiteral* _tmp43_;
	ValaNullLiteral* _tmp44_;
	ValaParameter* _tmp45_;
	ValaExpression* _tmp46_;
	ValaExpression* _tmp47_;
	ValaDelegateType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaParameter* _tmp51_;
	ValaParameter* _tmp52_;
	ValaArrayList* _tmp53_;
	ValaParameter* _tmp54_;
	ValaParameter* _tmp55_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = vala_code_context_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_root (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_scope_lookup (_tmp6_, "GLib");
	_tmp8_ = _tmp7_;
	_vala_code_context_unref0 (_tmp2_);
	glib_ns = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	params = _tmp10_;
	ellipsis = NULL;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _param_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _param_index = 0;
		_tmp11_ = self->priv->parameters;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_param_list = _tmp12_;
		_tmp13_ = _param_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_param_size = _tmp15_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			ValaParameter* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp16_ = _param_list;
			_tmp17_ = vala_list_get (_tmp16_, _param_index);
			param = (ValaParameter*) _tmp17_;
			_tmp18_ = param;
			_tmp19_ = vala_parameter_get_ellipsis (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_) {
				ValaParameter* _tmp21_;
				ValaParameter* _tmp22_;
				_tmp21_ = param;
				_tmp22_ = _vala_code_node_ref0 (_tmp21_);
				_vala_code_node_unref0 (ellipsis);
				ellipsis = _tmp22_;
			} else {
				ValaParameter* _tmp23_;
				ValaParameterDirection _tmp24_;
				ValaParameterDirection _tmp25_;
				_tmp23_ = param;
				_tmp24_ = vala_parameter_get_direction (_tmp23_);
				_tmp25_ = _tmp24_;
				if (_tmp25_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaArrayList* _tmp26_;
					ValaParameter* _tmp27_;
					_tmp26_ = params;
					_tmp27_ = param;
					vala_collection_add ((ValaCollection*) _tmp26_, _tmp27_);
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp28_ = glib_ns;
	_tmp29_ = vala_symbol_get_scope (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_scope_lookup (_tmp30_, "AsyncReadyCallback");
	_tmp32_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_DELEGATE, ValaDelegate);
	_tmp33_ = vala_delegate_type_new (_tmp32_);
	_tmp34_ = _tmp33_;
	_vala_code_node_unref0 (_tmp32_);
	callback_type = _tmp34_;
	_tmp35_ = callback_type;
	vala_data_type_set_nullable ((ValaDataType*) _tmp35_, TRUE);
	_tmp36_ = callback_type;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp36_, TRUE);
	_tmp37_ = callback_type;
	vala_delegate_type_set_is_called_once (_tmp37_, TRUE);
	_tmp38_ = callback_type;
	_tmp39_ = vala_parameter_new ("_callback_", (ValaDataType*) _tmp38_, NULL);
	callback_param = _tmp39_;
	_tmp40_ = callback_param;
	_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_null_literal_new (_tmp42_);
	_tmp44_ = _tmp43_;
	vala_variable_set_initializer ((ValaVariable*) _tmp40_, (ValaExpression*) _tmp44_);
	_vala_code_node_unref0 (_tmp44_);
	_tmp45_ = callback_param;
	_tmp46_ = vala_variable_get_initializer ((ValaVariable*) _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = callback_type;
	_tmp49_ = vala_data_type_copy ((ValaDataType*) _tmp48_);
	_tmp50_ = _tmp49_;
	vala_expression_set_target_type (_tmp47_, _tmp50_);
	_vala_code_node_unref0 (_tmp50_);
	_tmp51_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp51_, "CCode", "pos", (gdouble) -1, NULL);
	_tmp52_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp52_, "CCode", "delegate_target_pos", -0.9, NULL);
	_tmp53_ = params;
	_tmp54_ = callback_param;
	vala_collection_add ((ValaCollection*) _tmp53_, _tmp54_);
	_tmp55_ = ellipsis;
	if (_tmp55_ != NULL) {
		ValaArrayList* _tmp56_;
		ValaParameter* _tmp57_;
		_tmp56_ = params;
		_tmp57_ = ellipsis;
		vala_collection_add ((ValaCollection*) _tmp56_, _tmp57_);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (callback_param);
	_vala_code_node_unref0 (callback_type);
	_vala_code_node_unref0 (ellipsis);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

ValaList*
vala_method_get_async_end_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp3_;
	ValaCodeContext* _tmp4_;
	ValaNamespace* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaObjectType* result_type = NULL;
	ValaSymbol* _tmp11_;
	ValaScope* _tmp12_;
	ValaScope* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaObjectTypeSymbol* _tmp15_;
	ValaObjectType* _tmp16_;
	ValaObjectType* _tmp17_;
	ValaParameter* result_param = NULL;
	ValaObjectType* _tmp18_;
	ValaParameter* _tmp19_;
	ValaParameter* _tmp20_;
	ValaArrayList* _tmp21_;
	ValaParameter* _tmp22_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	params = _tmp2_;
	_tmp3_ = vala_code_context_get ();
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_code_context_get_root (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_scope_lookup (_tmp8_, "GLib");
	_tmp10_ = _tmp9_;
	_vala_code_context_unref0 (_tmp4_);
	glib_ns = _tmp10_;
	_tmp11_ = glib_ns;
	_tmp12_ = vala_symbol_get_scope (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_scope_lookup (_tmp13_, "AsyncResult");
	_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
	_tmp16_ = vala_object_type_new (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_code_node_unref0 (_tmp15_);
	result_type = _tmp17_;
	_tmp18_ = result_type;
	_tmp19_ = vala_parameter_new ("_res_", (ValaDataType*) _tmp18_, NULL);
	result_param = _tmp19_;
	_tmp20_ = result_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp20_, "CCode", "pos", vala_code_node_get_attribute_double ((ValaCodeNode*) self, "CCode", "async_result_pos", 0.1), NULL);
	_tmp21_ = params;
	_tmp22_ = result_param;
	vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _param_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _param_index = 0;
		_tmp23_ = self->priv->parameters;
		_tmp24_ = _vala_iterable_ref0 (_tmp23_);
		_param_list = _tmp24_;
		_tmp25_ = _param_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_param_size = _tmp27_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp28_;
			gpointer _tmp29_;
			ValaParameter* _tmp30_;
			ValaParameterDirection _tmp31_;
			ValaParameterDirection _tmp32_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp28_ = _param_list;
			_tmp29_ = vala_list_get (_tmp28_, _param_index);
			param = (ValaParameter*) _tmp29_;
			_tmp30_ = param;
			_tmp31_ = vala_parameter_get_direction (_tmp30_);
			_tmp32_ = _tmp31_;
			if (_tmp32_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaArrayList* _tmp33_;
				ValaParameter* _tmp34_;
				_tmp33_ = params;
				_tmp34_ = param;
				vala_collection_add ((ValaCollection*) _tmp33_, _tmp34_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (result_param);
	_vala_code_node_unref0 (result_type);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

void
vala_method_add_captured_variable (ValaMethod* self,
                                   ValaLocalVariable* local)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = self->priv->_closure;
	_vala_assert (_tmp0_, "this.closure");
	_tmp1_ = self->priv->captured_variables;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (self->priv->captured_variables);
		self->priv->captured_variables = (ValaList*) _tmp3_;
	}
	_tmp4_ = self->priv->captured_variables;
	vala_collection_add ((ValaCollection*) _tmp4_, local);
}

void
vala_method_get_captured_variables (ValaMethod* self,
                                    ValaCollection* variables)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variables != NULL);
	_tmp0_ = self->priv->captured_variables;
	if (_tmp0_ != NULL) {
		{
			ValaList* _local_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _local_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _local_index = 0;
			_tmp1_ = self->priv->captured_variables;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_local_list = _tmp2_;
			_tmp3_ = _local_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_local_size = _tmp5_;
			_local_index = -1;
			while (TRUE) {
				ValaLocalVariable* local = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				ValaLocalVariable* _tmp8_;
				_local_index = _local_index + 1;
				if (!(_local_index < _local_size)) {
					break;
				}
				_tmp6_ = _local_list;
				_tmp7_ = vala_list_get (_tmp6_, _local_index);
				local = (ValaLocalVariable*) _tmp7_;
				_tmp8_ = local;
				vala_collection_add (variables, _tmp8_);
				_vala_code_node_unref0 (local);
			}
			_vala_iterable_unref0 (_local_list);
		}
	}
}

static void
vala_method_real_get_defined_variables (ValaCodeNode* base,
                                        ValaCollection* collection)
{
	ValaMethod * self;
	ValaLocalVariable* _tmp0_;
	ValaLocalVariable* _tmp1_;
	gboolean _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaLocalVariable* _tmp2_;
		ValaLocalVariable* _tmp3_;
		_tmp2_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp3_ = _tmp2_;
		vala_collection_add (collection, (ValaVariable*) _tmp3_);
	}
	_tmp4_ = self->priv->_closure;
	if (_tmp4_) {
		vala_method_get_captured_variables (self, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}

gint
vala_method_get_format_arg_index (ValaMethod* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaParameter* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->parameters;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->parameters;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaParameter*) _tmp6_;
				_tmp8_ = vala_parameter_get_format_arg (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp10_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_error_type_parameter (ValaMethod* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaMethod* _tmp4_;
	ValaMethod* _tmp5_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	ValaMethod* _tmp12_;
	ValaMethod* _tmp13_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = vala_method_get_base_method (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		_tmp6_ = vala_method_get_base_method (self);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != self;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		_tmp8_ = vala_method_get_base_method (self);
		_tmp9_ = _tmp8_;
		_tmp2_ = vala_method_has_error_type_parameter (_tmp9_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp12_ = vala_method_get_base_interface_method (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaMethod* _tmp14_;
		ValaMethod* _tmp15_;
		_tmp14_ = vala_method_get_base_interface_method (self);
		_tmp15_ = _tmp14_;
		_tmp11_ = _tmp15_ != self;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		_tmp16_ = vala_method_get_base_interface_method (self);
		_tmp17_ = _tmp16_;
		_tmp10_ = vala_method_has_error_type_parameter (_tmp17_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
vala_method_class_init (ValaMethodClass * klass,
                        gpointer klass_data)
{
	vala_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_real_get_error_types;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_method_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_real_check;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_real_get_defined_variables;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_method_real_get_has_result;
}

static void
vala_method_vala_callable_interface_init (ValaCallableIface * iface,
                                          gpointer iface_data)
{
	vala_method_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_method_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_method_real_get_parameters;
	iface->get_return_type = vala_method_real_get_return_type;
	iface->set_return_type = vala_method_real_set_return_type;
}

static void
vala_method_instance_init (ValaMethod * self,
                           gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}

static void
vala_method_finalize (ValaCodeNode * obj)
{
	ValaMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD, ValaMethod);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_iterable_unref0 (self->priv->preconditions);
	_vala_iterable_unref0 (self->priv->postconditions);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_iterable_unref0 (self->error_types);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	_vala_code_node_unref0 (self->priv->callback_method);
	_vala_code_node_unref0 (self->priv->end_method);
	_vala_iterable_unref0 (self->priv->captured_variables);
	VALA_CODE_NODE_CLASS (vala_method_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace method.
 */
GType
vala_method_get_type (void)
{
	static volatile gsize vala_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethod), 0, (GInstanceInitFunc) vala_method_instance_init, NULL };
		static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_method_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_method_type_id;
		vala_method_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaMethod", &g_define_type_info, 0);
		g_type_add_interface_static (vala_method_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
		ValaMethod_private_offset = g_type_add_instance_private (vala_method_type_id, sizeof (ValaMethodPrivate));
		g_once_init_leave (&vala_method_type_id__volatile, vala_method_type_id);
	}
	return vala_method_type_id__volatile;
}

