/* valafield.c generated by valac, the Vala compiler
 * generated from valafield.vala, do not modify */

/* valafield.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaFieldPrivate {
	ValaMemberBinding _binding;
	gboolean _is_volatile;
	gboolean _lock_used;
};

static gint ValaField_private_offset;
static gpointer vala_field_parent_class = NULL;
static ValaLockableIface * vala_field_vala_lockable_parent_iface = NULL;

static void vala_field_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_field_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_field_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node);
static void vala_field_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static gboolean vala_field_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_field_finalize (ValaCodeNode * obj);

static inline gpointer
vala_field_get_instance_private (ValaField* self)
{
	return G_STRUCT_MEMBER_P (self, ValaField_private_offset);
}

/**
 * Creates a new field.
 *
 * @param name              field name
 * @param variable_type     field type
 * @param initializer       initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created field
 */
ValaField*
vala_field_construct (GType object_type,
                      const gchar* name,
                      ValaDataType* variable_type,
                      ValaExpression* initializer,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaField* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	self = (ValaField*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, comment);
	return self;
}

ValaField*
vala_field_new (const gchar* name,
                ValaDataType* variable_type,
                ValaExpression* initializer,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_field_construct (VALA_TYPE_FIELD, name, variable_type, initializer, source_reference, comment);
}

static void
vala_field_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaField * self;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_field (visitor, self);
}

static void
vala_field_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}

static void
vala_field_real_replace_expression (ValaCodeNode* base,
                                    ValaExpression* old_node,
                                    ValaExpression* new_node)
{
	ValaField * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_field_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_field_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaField * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaSemanticAnalyzer* _tmp30_;
	ValaSemanticAnalyzer* _tmp31_;
	ValaDataType* _tmp32_;
	ValaDataType* _tmp33_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp44_;
	ValaDataType* _tmp45_;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	ValaArrayType* _tmp49_;
	ValaExpression* _tmp61_;
	ValaExpression* _tmp62_;
	gboolean _tmp150_ = FALSE;
	ValaMemberBinding _tmp151_;
	gboolean field_in_header = FALSE;
	ValaSymbol* _tmp156_;
	ValaSymbol* _tmp157_;
	gboolean _tmp166_ = FALSE;
	gboolean _tmp167_ = FALSE;
	gboolean _tmp168_;
	gboolean _tmp169_;
	ValaSemanticAnalyzer* _tmp184_;
	ValaSemanticAnalyzer* _tmp185_;
	ValaSourceFile* _tmp186_;
	ValaSemanticAnalyzer* _tmp187_;
	ValaSemanticAnalyzer* _tmp188_;
	ValaSymbol* _tmp189_;
	gboolean _tmp190_;
	gboolean _tmp191_;
	self = (ValaField*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp25_ = _tmp24_;
	if (VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		vala_report_error (_tmp27_, "'void' not supported as field type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp29_ = _tmp28_;
	vala_code_node_check ((ValaCodeNode*) _tmp29_, context);
	_tmp30_ = vala_code_context_get_analyzer (context);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp33_ = _tmp32_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp31_, (ValaSymbol*) self, _tmp33_)) {
		ValaSourceReference* _tmp34_;
		ValaSourceReference* _tmp35_;
		ValaDataType* _tmp36_;
		ValaDataType* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_code_node_to_string ((ValaCodeNode*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_strdup_printf ("field type `%s' is less accessible than field `%s'", _tmp39_, _tmp41_);
		_tmp43_ = _tmp42_;
		vala_report_error (_tmp35_, _tmp43_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp39_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp44_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp45_ = _tmp44_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp45_) ? ((ValaArrayType*) _tmp45_) : NULL;
	_tmp49_ = variable_array_type;
	if (_tmp49_ != NULL) {
		ValaArrayType* _tmp50_;
		gboolean _tmp51_;
		gboolean _tmp52_;
		_tmp50_ = variable_array_type;
		_tmp51_ = vala_array_type_get_fixed_length (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp48_ = _tmp52_;
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		_tmp53_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp54_ = _tmp53_;
		_tmp47_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp54_);
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		ValaInitializerList* _tmp57_;
		ValaInitializerList* _tmp58_;
		_tmp55_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp58_ = _tmp57_;
		_tmp46_ = _tmp58_ == NULL;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		ValaSourceReference* _tmp59_;
		ValaSourceReference* _tmp60_;
		_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp60_ = _tmp59_;
		vala_report_warning (_tmp60_, "Arrays with fixed length don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp61_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp62_ = _tmp61_;
	if (_tmp62_ != NULL) {
		ValaExpression* _tmp63_;
		ValaExpression* _tmp64_;
		ValaDataType* _tmp65_;
		ValaDataType* _tmp66_;
		ValaExpression* _tmp67_;
		ValaExpression* _tmp68_;
		ValaExpression* _tmp69_;
		ValaExpression* _tmp70_;
		ValaDataType* _tmp71_;
		ValaDataType* _tmp72_;
		ValaExpression* _tmp75_;
		ValaExpression* _tmp76_;
		ValaDataType* _tmp77_;
		ValaDataType* _tmp78_;
		ValaDataType* _tmp79_;
		ValaDataType* _tmp80_;
		ValaExpression* _tmp95_;
		ValaExpression* _tmp96_;
		ValaDataType* _tmp97_;
		ValaDataType* _tmp98_;
		gboolean _tmp108_ = FALSE;
		ValaSymbol* _tmp109_;
		ValaSymbol* _tmp110_;
		gboolean _tmp115_ = FALSE;
		gboolean _tmp116_ = FALSE;
		ValaSymbol* _tmp117_;
		ValaSymbol* _tmp118_;
		gboolean _tmp132_ = FALSE;
		gboolean _tmp133_ = FALSE;
		gboolean _tmp134_ = FALSE;
		ValaMemberBinding _tmp135_;
		gboolean _tmp146_;
		gboolean _tmp147_;
		_tmp63_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp66_ = _tmp65_;
		vala_expression_set_target_type (_tmp64_, _tmp66_);
		_tmp67_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp68_ = _tmp67_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp68_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp69_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_expression_get_value_type (_tmp70_);
		_tmp72_ = _tmp71_;
		if (_tmp72_ == NULL) {
			ValaSourceReference* _tmp73_;
			ValaSourceReference* _tmp74_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp74_ = _tmp73_;
			vala_report_error (_tmp74_, "expression type not allowed as initializer");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp75_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp76_ = _tmp75_;
		_tmp77_ = vala_expression_get_value_type (_tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp80_ = _tmp79_;
		if (!vala_data_type_compatible (_tmp78_, _tmp80_)) {
			ValaSourceReference* _tmp81_;
			ValaSourceReference* _tmp82_;
			ValaExpression* _tmp83_;
			ValaExpression* _tmp84_;
			ValaDataType* _tmp85_;
			ValaDataType* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			ValaDataType* _tmp89_;
			ValaDataType* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp82_ = _tmp81_;
			_tmp83_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp84_ = _tmp83_;
			_tmp85_ = vala_expression_get_value_type (_tmp84_);
			_tmp86_ = _tmp85_;
			_tmp87_ = vala_code_node_to_string ((ValaCodeNode*) _tmp86_);
			_tmp88_ = _tmp87_;
			_tmp89_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp90_ = _tmp89_;
			_tmp91_ = vala_code_node_to_string ((ValaCodeNode*) _tmp90_);
			_tmp92_ = _tmp91_;
			_tmp93_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp88_, _tmp92_);
			_tmp94_ = _tmp93_;
			vala_report_error (_tmp82_, _tmp94_);
			_g_free0 (_tmp94_);
			_g_free0 (_tmp92_);
			_g_free0 (_tmp88_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp95_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp96_ = _tmp95_;
		_tmp97_ = vala_expression_get_value_type (_tmp96_);
		_tmp98_ = _tmp97_;
		if (vala_data_type_is_disposable (_tmp98_)) {
			gboolean _tmp99_ = FALSE;
			ValaDataType* _tmp100_;
			ValaDataType* _tmp101_;
			_tmp100_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp101_ = _tmp100_;
			if (!VALA_IS_POINTER_TYPE (_tmp101_)) {
				ValaDataType* _tmp102_;
				ValaDataType* _tmp103_;
				gboolean _tmp104_;
				gboolean _tmp105_;
				_tmp102_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp103_ = _tmp102_;
				_tmp104_ = vala_data_type_get_value_owned (_tmp103_);
				_tmp105_ = _tmp104_;
				_tmp99_ = !_tmp105_;
			} else {
				_tmp99_ = FALSE;
			}
			if (_tmp99_) {
				ValaSourceReference* _tmp106_;
				ValaSourceReference* _tmp107_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp107_ = _tmp106_;
				vala_report_error (_tmp107_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp109_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp110_ = _tmp109_;
		if (VALA_IS_NAMESPACE (_tmp110_)) {
			ValaExpression* _tmp111_;
			ValaExpression* _tmp112_;
			_tmp111_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp112_ = _tmp111_;
			_tmp108_ = !vala_expression_is_constant (_tmp112_);
		} else {
			_tmp108_ = FALSE;
		}
		if (_tmp108_) {
			ValaSourceReference* _tmp113_;
			ValaSourceReference* _tmp114_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp114_ = _tmp113_;
			vala_report_error (_tmp114_, "Non-constant field initializers not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp117_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp118_ = _tmp117_;
		if (VALA_IS_NAMESPACE (_tmp118_)) {
			ValaExpression* _tmp119_;
			ValaExpression* _tmp120_;
			_tmp119_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp120_ = _tmp119_;
			_tmp116_ = vala_expression_is_constant (_tmp120_);
		} else {
			_tmp116_ = FALSE;
		}
		if (_tmp116_) {
			ValaExpression* _tmp121_;
			ValaExpression* _tmp122_;
			_tmp121_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp122_ = _tmp121_;
			_tmp115_ = vala_expression_is_non_null (_tmp122_);
		} else {
			_tmp115_ = FALSE;
		}
		if (_tmp115_) {
			gboolean _tmp123_ = FALSE;
			ValaDataType* _tmp124_;
			ValaDataType* _tmp125_;
			_tmp124_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp125_ = _tmp124_;
			if (vala_data_type_is_disposable (_tmp125_)) {
				ValaDataType* _tmp126_;
				ValaDataType* _tmp127_;
				gboolean _tmp128_;
				gboolean _tmp129_;
				_tmp126_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp127_ = _tmp126_;
				_tmp128_ = vala_data_type_get_value_owned (_tmp127_);
				_tmp129_ = _tmp128_;
				_tmp123_ = _tmp129_;
			} else {
				_tmp123_ = FALSE;
			}
			if (_tmp123_) {
				ValaSourceReference* _tmp130_;
				ValaSourceReference* _tmp131_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp131_ = _tmp130_;
				vala_report_error (_tmp131_, "Owned namespace fields can only be initialized in a function or method");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp135_ = self->priv->_binding;
		if (_tmp135_ == VALA_MEMBER_BINDING_STATIC) {
			ValaSymbol* _tmp136_;
			ValaSymbol* _tmp137_;
			_tmp136_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp137_ = _tmp136_;
			_tmp134_ = VALA_IS_CLASS (_tmp137_);
		} else {
			_tmp134_ = FALSE;
		}
		if (_tmp134_) {
			ValaSymbol* _tmp138_;
			ValaSymbol* _tmp139_;
			gboolean _tmp140_;
			gboolean _tmp141_;
			_tmp138_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp139_ = _tmp138_;
			_tmp140_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp139_, VALA_TYPE_CLASS, ValaClass));
			_tmp141_ = _tmp140_;
			_tmp133_ = _tmp141_;
		} else {
			_tmp133_ = FALSE;
		}
		if (_tmp133_) {
			ValaExpression* _tmp142_;
			ValaExpression* _tmp143_;
			_tmp142_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp143_ = _tmp142_;
			_tmp132_ = !vala_expression_is_constant (_tmp143_);
		} else {
			_tmp132_ = FALSE;
		}
		if (_tmp132_) {
			ValaSourceReference* _tmp144_;
			ValaSourceReference* _tmp145_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp144_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp145_ = _tmp144_;
			vala_report_error (_tmp145_, "Static fields in compact classes cannot have non-constant initializers");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp146_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp147_ = _tmp146_;
		if (_tmp147_) {
			ValaSourceReference* _tmp148_;
			ValaSourceReference* _tmp149_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp149_ = _tmp148_;
			vala_report_error (_tmp149_, "External fields cannot use initializers");
		}
	}
	_tmp151_ = self->priv->_binding;
	if (_tmp151_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSymbol* _tmp152_;
		ValaSymbol* _tmp153_;
		_tmp152_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp153_ = _tmp152_;
		_tmp150_ = VALA_IS_INTERFACE (_tmp153_);
	} else {
		_tmp150_ = FALSE;
	}
	if (_tmp150_) {
		ValaSourceReference* _tmp154_;
		ValaSourceReference* _tmp155_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp154_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp155_ = _tmp154_;
		vala_report_error (_tmp155_, "Interfaces may not have instance fields");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	field_in_header = !vala_symbol_is_internal_symbol ((ValaSymbol*) self);
	_tmp156_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp157_ = _tmp156_;
	if (VALA_IS_CLASS (_tmp157_)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp158_;
		ValaSymbol* _tmp159_;
		ValaClass* _tmp160_;
		gboolean _tmp161_ = FALSE;
		ValaClass* _tmp162_;
		gboolean _tmp163_;
		gboolean _tmp164_;
		_tmp158_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp159_ = _tmp158_;
		_tmp160_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp159_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp160_;
		_tmp162_ = cl;
		_tmp163_ = vala_class_get_is_compact (_tmp162_);
		_tmp164_ = _tmp163_;
		if (_tmp164_) {
			ValaClass* _tmp165_;
			_tmp165_ = cl;
			_tmp161_ = !vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp165_);
		} else {
			_tmp161_ = FALSE;
		}
		if (_tmp161_) {
			field_in_header = TRUE;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp168_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp169_ = _tmp168_;
	if (!_tmp169_) {
		gboolean _tmp170_;
		gboolean _tmp171_;
		_tmp170_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp171_ = _tmp170_;
		_tmp167_ = !_tmp171_;
	} else {
		_tmp167_ = FALSE;
	}
	if (_tmp167_) {
		ValaSymbol* _tmp172_;
		ValaSymbol* _tmp173_;
		_tmp172_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp173_ = _tmp172_;
		_tmp166_ = _tmp173_ != NULL;
		_vala_code_node_unref0 (_tmp173_);
	} else {
		_tmp166_ = FALSE;
	}
	if (_tmp166_) {
		ValaSourceReference* _tmp174_;
		ValaSourceReference* _tmp175_;
		gchar* _tmp176_;
		gchar* _tmp177_;
		ValaSymbol* _tmp178_;
		ValaSymbol* _tmp179_;
		gchar* _tmp180_;
		gchar* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		_tmp174_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp175_ = _tmp174_;
		_tmp176_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp177_ = _tmp176_;
		_tmp178_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_symbol_get_full_name (_tmp179_);
		_tmp181_ = _tmp180_;
		_tmp182_ = g_strdup_printf ("%s hides inherited field `%s'. Use the `new' keyword if hiding was int" \
"entional", _tmp177_, _tmp181_);
		_tmp183_ = _tmp182_;
		vala_report_warning (_tmp175_, _tmp183_);
		_g_free0 (_tmp183_);
		_g_free0 (_tmp181_);
		_vala_code_node_unref0 (_tmp179_);
		_g_free0 (_tmp177_);
	}
	_tmp184_ = vala_code_context_get_analyzer (context);
	_tmp185_ = _tmp184_;
	_tmp186_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp185_, _tmp186_);
	_tmp187_ = vala_code_context_get_analyzer (context);
	_tmp188_ = _tmp187_;
	_tmp189_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp188_, _tmp189_);
	_tmp190_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp191_ = _tmp190_;
	result = !_tmp191_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

ValaMemberBinding
vala_field_get_binding (ValaField* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}

void
vala_field_set_binding (ValaField* self,
                        ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_field_get_is_volatile (ValaField* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_volatile;
	return result;
}

void
vala_field_set_is_volatile (ValaField* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_volatile = value;
}

static gboolean
vala_field_real_get_lock_used (ValaLockable* base)
{
	gboolean result;
	ValaField* self;
	self = (ValaField*) base;
	result = self->priv->_lock_used;
	return result;
}

static void
vala_field_real_set_lock_used (ValaLockable* base,
                               gboolean value)
{
	ValaField* self;
	self = (ValaField*) base;
	self->priv->_lock_used = value;
}

static void
vala_field_class_init (ValaFieldClass * klass,
                       gpointer klass_data)
{
	vala_field_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_field_finalize;
	g_type_class_adjust_private_offset (klass, &ValaField_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_field_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_field_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_field_real_check;
}

static void
vala_field_vala_lockable_interface_init (ValaLockableIface * iface,
                                         gpointer iface_data)
{
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = vala_field_real_get_lock_used;
	iface->set_lock_used = vala_field_real_set_lock_used;
}

static void
vala_field_instance_init (ValaField * self,
                          gpointer klass)
{
	self->priv = vala_field_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
}

static void
vala_field_finalize (ValaCodeNode * obj)
{
	ValaField * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FIELD, ValaField);
	VALA_CODE_NODE_CLASS (vala_field_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace field.
 */
GType
vala_field_get_type (void)
{
	static volatile gsize vala_field_type_id__volatile = 0;
	if (g_once_init_enter (&vala_field_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_field_type_id;
		vala_field_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaField", &g_define_type_info, 0);
		g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		ValaField_private_offset = g_type_add_instance_private (vala_field_type_id, sizeof (ValaFieldPrivate));
		g_once_init_leave (&vala_field_type_id__volatile, vala_field_type_id);
	}
	return vala_field_type_id__volatile;
}

