/* valagenieparser.c generated by valac, the Vala compiler
 * generated from valagenieparser.vala, do not modify */

/* valagenieparser.vala
 *
 * Copyright (C) 2008-2012  Jamie McCracken, Jürg Billeter
 * Based on code by Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jamie McCracken jamiemcc gnome org
 */

#include "vala.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define VALA_GENIE_PARSER_TYPE_TOKEN_INFO (vala_genie_parser_token_info_get_type ())
typedef struct _ValaGenieParserTokenInfo ValaGenieParserTokenInfo;
typedef enum  {
	VALA_GENIE_PARSER_MODIFIER_FLAGS_NONE,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT = 1 << 0,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS = 1 << 1,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN = 1 << 2,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE = 1 << 3,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW = 1 << 4,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE = 1 << 5,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC = 1 << 6,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL = 1 << 7,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE = 1 << 8,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_ASYNC = 1 << 9,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_SEALED = 1 << 10,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_PUBLIC = 1 << 11,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED = 1 << 12
} ValaGenieParserModifierFlags;

#define VALA_GENIE_PARSER_TYPE_MODIFIER_FLAGS (vala_genie_parser_modifier_flags_get_type ())
typedef enum  {
	VALA_GENIE_PARSER_RECOVERY_STATE_EOF,
	VALA_GENIE_PARSER_RECOVERY_STATE_DECLARATION_BEGIN,
	VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN
} ValaGenieParserRecoveryState;

#define VALA_GENIE_PARSER_TYPE_RECOVERY_STATE (vala_genie_parser_recovery_state_get_type ())
#define _vala_genie_scanner_unref0(var) ((var == NULL) ? NULL : (var = (vala_genie_scanner_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGenieParserTokenInfo {
	ValaGenieTokenType type;
	ValaSourceLocation begin;
	ValaSourceLocation end;
};

struct _ValaGenieParserPrivate {
	ValaGenieScanner* scanner;
	ValaCodeContext* context;
	ValaGenieParserTokenInfo* tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gint index;
	gint size;
	ValaComment* comment;
	gchar* class_name;
	gboolean current_expr_is_lambda;
};

static gint ValaGenieParser_private_offset;
static gpointer vala_genie_parser_parent_class = NULL;
static ValaList* vala_genie_parser__empty_type_parameter_list;
static ValaList* vala_genie_parser__empty_type_parameter_list = NULL;

static GType vala_genie_parser_token_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGenieParserTokenInfo* vala_genie_parser_token_info_dup (const ValaGenieParserTokenInfo* self);
static void vala_genie_parser_token_info_free (ValaGenieParserTokenInfo* self);
static GType vala_genie_parser_modifier_flags_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType vala_genie_parser_recovery_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_GENIE_PARSER_BUFFER_SIZE 32
static void vala_genie_parser_real_visit_source_file (ValaCodeVisitor* base,
                                               ValaSourceFile* source_file);
static inline gboolean vala_genie_parser_next (ValaGenieParser* self);
static inline void vala_genie_parser_prev (ValaGenieParser* self);
static inline ValaGenieTokenType vala_genie_parser_current (ValaGenieParser* self);
static inline gboolean vala_genie_parser_accept (ValaGenieParser* self,
                                   ValaGenieTokenType type);
static inline gboolean vala_genie_parser_accept_separator (ValaGenieParser* self);
static inline gboolean vala_genie_parser_accept_terminator (ValaGenieParser* self);
static inline gboolean vala_genie_parser_accept_block (ValaGenieParser* self);
static void vala_genie_parser_report_parse_error (ValaGenieParser* self,
                                           GError* e);
static inline void vala_genie_parser_get_location (ValaGenieParser* self,
                                     ValaSourceLocation* result);
static ValaSourceReference* vala_genie_parser_get_src (ValaGenieParser* self,
                                                ValaSourceLocation* begin);
static inline gboolean vala_genie_parser_expect (ValaGenieParser* self,
                                   ValaGenieTokenType type,
                                   GError** error);
static inline gboolean vala_genie_parser_expect_separator (ValaGenieParser* self,
                                             GError** error);
static inline gboolean vala_genie_parser_expect_terminator (ValaGenieParser* self,
                                              GError** error);
static gchar* vala_genie_parser_get_current_string (ValaGenieParser* self);
static gchar* vala_genie_parser_get_last_string (ValaGenieParser* self);
static ValaSourceReference* vala_genie_parser_get_current_src (ValaGenieParser* self);
static void vala_genie_parser_rollback (ValaGenieParser* self,
                                 ValaSourceLocation* location);
static inline ValaSymbolAccessibility vala_genie_parser_get_default_accessibility (ValaGenieParser* self,
                                                                     const gchar* s);
static void vala_genie_parser_skip_identifier (ValaGenieParser* self,
                                        GError** error);
static gchar* vala_genie_parser_parse_identifier (ValaGenieParser* self,
                                           GError** error);
static ValaExpression* vala_genie_parser_parse_literal (ValaGenieParser* self,
                                                 GError** error);
static void vala_genie_parser_parse_using_directives (ValaGenieParser* self,
                                               ValaNamespace* ns,
                                               GError** error);
static void vala_genie_parser_parse_declarations (ValaGenieParser* self,
                                           ValaSymbol* parent,
                                           gboolean root,
                                           GError** error);
static void vala_genie_parser_skip_symbol_name (ValaGenieParser* self,
                                         GError** error);
static ValaUnresolvedSymbol* vala_genie_parser_parse_symbol_name (ValaGenieParser* self,
                                                           GError** error);
static void vala_genie_parser_skip_type (ValaGenieParser* self,
                                  GError** error);
static void vala_genie_parser_skip_type_argument_list (ValaGenieParser* self,
                                                GError** error);
static ValaExpression* vala_genie_parser_parse_expression (ValaGenieParser* self,
                                                    GError** error);
static ValaExpression* vala_genie_parser_parse_regex_literal (ValaGenieParser* self,
                                                       GError** error);
static ValaDataType* vala_genie_parser_parse_type (ValaGenieParser* self,
                                            gboolean owned_by_default,
                                            gboolean can_weak_ref,
                                            GError** error);
static ValaList* vala_genie_parser_parse_type_argument_list (ValaGenieParser* self,
                                                      gboolean maybe_expression,
                                                      GError** error);
static ValaDataType* vala_genie_parser_parse_inline_array_type (ValaGenieParser* self,
                                                         ValaDataType* type,
                                                         GError** error);
static ValaList* vala_genie_parser_parse_argument_list (ValaGenieParser* self,
                                                 GError** error);
static ValaExpression* vala_genie_parser_parse_argument (ValaGenieParser* self,
                                                  GError** error);
static ValaExpression* vala_genie_parser_parse_primary_expression (ValaGenieParser* self,
                                                            GError** error);
static ValaExpression* vala_genie_parser_parse_assert_expression (ValaGenieParser* self,
                                                           GError** error);
static ValaInitializerList* vala_genie_parser_parse_initializer (ValaGenieParser* self,
                                                          GError** error);
static ValaExpression* vala_genie_parser_parse_tuple (ValaGenieParser* self,
                                               GError** error);
static ValaExpression* vala_genie_parser_parse_template (ValaGenieParser* self,
                                                  GError** error);
static ValaExpression* vala_genie_parser_parse_this_access (ValaGenieParser* self,
                                                     GError** error);
static ValaExpression* vala_genie_parser_parse_base_access (ValaGenieParser* self,
                                                     GError** error);
static ValaExpression* vala_genie_parser_parse_object_or_array_creation_expression (ValaGenieParser* self,
                                                                             GError** error);
static ValaExpression* vala_genie_parser_parse_print_expression (ValaGenieParser* self,
                                                          GError** error);
static ValaExpression* vala_genie_parser_parse_sizeof_expression (ValaGenieParser* self,
                                                           GError** error);
static ValaExpression* vala_genie_parser_parse_typeof_expression (ValaGenieParser* self,
                                                           GError** error);
static ValaExpression* vala_genie_parser_parse_yield_expression (ValaGenieParser* self,
                                                          GError** error);
static ValaExpression* vala_genie_parser_parse_simple_name (ValaGenieParser* self,
                                                     GError** error);
static ValaExpression* vala_genie_parser_parse_member_access (ValaGenieParser* self,
                                                       ValaSourceLocation* begin,
                                                       ValaExpression* inner,
                                                       GError** error);
static ValaExpression* vala_genie_parser_parse_pointer_member_access (ValaGenieParser* self,
                                                               ValaSourceLocation* begin,
                                                               ValaExpression* inner,
                                                               GError** error);
static ValaExpression* vala_genie_parser_parse_method_call (ValaGenieParser* self,
                                                     ValaSourceLocation* begin,
                                                     ValaExpression* inner,
                                                     GError** error);
static ValaExpression* vala_genie_parser_parse_element_access (ValaGenieParser* self,
                                                        ValaSourceLocation* begin,
                                                        ValaExpression* inner,
                                                        GError** error);
static ValaExpression* vala_genie_parser_parse_post_increment_expression (ValaGenieParser* self,
                                                                   ValaSourceLocation* begin,
                                                                   ValaExpression* inner,
                                                                   GError** error);
static ValaExpression* vala_genie_parser_parse_post_decrement_expression (ValaGenieParser* self,
                                                                   ValaSourceLocation* begin,
                                                                   ValaExpression* inner,
                                                                   GError** error);
static ValaList* vala_genie_parser_parse_print_argument_list (ValaGenieParser* self,
                                                       GError** error);
static ValaList* vala_genie_parser_parse_object_initializer (ValaGenieParser* self,
                                                      GError** error);
static ValaList* vala_genie_parser_parse_expression_list (ValaGenieParser* self,
                                                   GError** error);
static ValaExpression* vala_genie_parser_parse_array_creation_expression (ValaGenieParser* self,
                                                                   ValaSourceLocation* begin,
                                                                   ValaDataType* element_type,
                                                                   GError** error);
static ValaExpression* vala_genie_parser_parse_list_creation_expression (ValaGenieParser* self,
                                                                  ValaSourceLocation* begin,
                                                                  ValaDataType* element_type,
                                                                  GError** error);
static ValaExpression* vala_genie_parser_parse_dict_creation_expression (ValaGenieParser* self,
                                                                  ValaSourceLocation* begin,
                                                                  ValaDataType* key_type,
                                                                  ValaDataType* value_type,
                                                                  GError** error);
static ValaMemberAccess* vala_genie_parser_parse_member_name (ValaGenieParser* self,
                                                       ValaExpression* base_expr,
                                                       GError** error);
static ValaExpression* vala_genie_parser_parse_object_creation_expression (ValaGenieParser* self,
                                                                    ValaSourceLocation* begin,
                                                                    ValaMemberAccess* member,
                                                                    GError** error);
static ValaMemberInitializer* vala_genie_parser_parse_member_initializer (ValaGenieParser* self,
                                                                   GError** error);
static ValaUnaryOperator vala_genie_parser_get_unary_operator (ValaGenieParser* self,
                                                        ValaGenieTokenType token_type);
static ValaExpression* vala_genie_parser_parse_unary_expression (ValaGenieParser* self,
                                                          GError** error);
static ValaBinaryOperator vala_genie_parser_get_binary_operator (ValaGenieParser* self,
                                                          ValaGenieTokenType token_type);
static ValaExpression* vala_genie_parser_parse_multiplicative_expression (ValaGenieParser* self,
                                                                   GError** error);
static ValaExpression* vala_genie_parser_parse_additive_expression (ValaGenieParser* self,
                                                             GError** error);
static ValaExpression* vala_genie_parser_parse_shift_expression (ValaGenieParser* self,
                                                          GError** error);
static ValaExpression* vala_genie_parser_parse_relational_expression (ValaGenieParser* self,
                                                               GError** error);
static ValaExpression* vala_genie_parser_parse_equality_expression (ValaGenieParser* self,
                                                             GError** error);
static ValaExpression* vala_genie_parser_parse_and_expression (ValaGenieParser* self,
                                                        GError** error);
static ValaExpression* vala_genie_parser_parse_exclusive_or_expression (ValaGenieParser* self,
                                                                 GError** error);
static ValaExpression* vala_genie_parser_parse_inclusive_or_expression (ValaGenieParser* self,
                                                                 GError** error);
static ValaExpression* vala_genie_parser_parse_in_expression (ValaGenieParser* self,
                                                       GError** error);
static ValaExpression* vala_genie_parser_parse_conditional_and_expression (ValaGenieParser* self,
                                                                    GError** error);
static ValaExpression* vala_genie_parser_parse_conditional_or_expression (ValaGenieParser* self,
                                                                   GError** error);
static ValaExpression* vala_genie_parser_parse_conditional_expression (ValaGenieParser* self,
                                                                GError** error);
static ValaParameter* vala_genie_parser_parse_lambda_parameter (ValaGenieParser* self,
                                                         GError** error);
static ValaExpression* vala_genie_parser_parse_lambda_expression (ValaGenieParser* self,
                                                           GError** error);
static ValaBlock* vala_genie_parser_parse_block (ValaGenieParser* self,
                                          GError** error);
static ValaAssignmentOperator vala_genie_parser_get_assignment_operator (ValaGenieParser* self,
                                                                  ValaGenieTokenType token_type);
static ValaExpression* vala_genie_parser_parse_expression_with_terminator (ValaGenieParser* self,
                                                                    GError** error);
static ValaStatement* vala_genie_parser_get_for_statement_type (ValaGenieParser* self,
                                                         GError** error);
static ValaStatement* vala_genie_parser_parse_foreach_statement (ValaGenieParser* self,
                                                          GError** error);
static ValaStatement* vala_genie_parser_parse_for_statement (ValaGenieParser* self,
                                                      GError** error);
static void vala_genie_parser_parse_statements (ValaGenieParser* self,
                                         ValaBlock* block,
                                         GError** error);
static ValaStatement* vala_genie_parser_parse_empty_statement (ValaGenieParser* self,
                                                        GError** error);
static ValaStatement* vala_genie_parser_parse_expression_statement (ValaGenieParser* self,
                                                             GError** error);
static ValaStatement* vala_genie_parser_parse_if_statement (ValaGenieParser* self,
                                                     GError** error);
static ValaStatement* vala_genie_parser_parse_switch_statement (ValaGenieParser* self,
                                                         GError** error);
static ValaStatement* vala_genie_parser_parse_while_statement (ValaGenieParser* self,
                                                        GError** error);
static ValaStatement* vala_genie_parser_parse_do_statement (ValaGenieParser* self,
                                                     GError** error);
static ValaStatement* vala_genie_parser_parse_break_statement (ValaGenieParser* self,
                                                        GError** error);
static ValaStatement* vala_genie_parser_parse_continue_statement (ValaGenieParser* self,
                                                           GError** error);
static ValaStatement* vala_genie_parser_parse_return_statement (ValaGenieParser* self,
                                                         GError** error);
static ValaStatement* vala_genie_parser_parse_throw_statement (ValaGenieParser* self,
                                                        GError** error);
static ValaStatement* vala_genie_parser_parse_try_statement (ValaGenieParser* self,
                                                      GError** error);
static ValaStatement* vala_genie_parser_parse_lock_statement (ValaGenieParser* self,
                                                       GError** error);
static ValaStatement* vala_genie_parser_parse_delete_statement (ValaGenieParser* self,
                                                         GError** error);
static void vala_genie_parser_parse_type_inference_declaration (ValaGenieParser* self,
                                                         ValaBlock* block,
                                                         GError** error);
static ValaStatement* vala_genie_parser_parse_yield_statement (ValaGenieParser* self,
                                                        GError** error);
static gboolean vala_genie_parser_is_expression (ValaGenieParser* self,
                                          GError** error);
static void vala_genie_parser_parse_local_variable_declarations (ValaGenieParser* self,
                                                          ValaBlock* block,
                                                          GError** error);
static ValaGenieParserRecoveryState vala_genie_parser_recover (ValaGenieParser* self);
static ValaBlock* vala_genie_parser_parse_embedded_statement (ValaGenieParser* self,
                                                       GError** error);
static ValaStatement* vala_genie_parser_parse_embedded_statement_without_block (ValaGenieParser* self,
                                                                         GError** error);
static ValaLocalVariable* vala_genie_parser_parse_local_variable (ValaGenieParser* self,
                                                           ValaDataType* variable_type,
                                                           const gchar* id,
                                                           gboolean expect_terminator,
                                                           GError** error);
static ValaExpression* vala_genie_parser_parse_statement_expression (ValaGenieParser* self,
                                                              GError** error);
static void vala_genie_parser_parse_catch_clauses (ValaGenieParser* self,
                                            ValaList* catch_clauses,
                                            GError** error);
static ValaBlock* vala_genie_parser_parse_finally_clause (ValaGenieParser* self,
                                                   GError** error);
static gchar* vala_genie_parser_parse_attribute_value (ValaGenieParser* self,
                                                GError** error);
static ValaList* vala_genie_parser_parse_attributes (ValaGenieParser* self,
                                              gboolean parameter,
                                              GError** error);
static void vala_genie_parser_set_attributes (ValaGenieParser* self,
                                       ValaCodeNode* node,
                                       ValaList* attributes);
static ValaSymbol* vala_genie_parser_parse_declaration (ValaGenieParser* self,
                                                 gboolean is_root,
                                                 GError** error);
static ValaConstant* vala_genie_parser_parse_constant_declaration (ValaGenieParser* self,
                                                            ValaList* attrs,
                                                            GError** error);
static ValaCreationMethod* vala_genie_parser_parse_creation_method_declaration (ValaGenieParser* self,
                                                                         ValaList* attrs,
                                                                         GError** error);
static ValaSymbol* vala_genie_parser_parse_class_declaration (ValaGenieParser* self,
                                                       ValaList* attrs,
                                                       GError** error);
static ValaMethod* vala_genie_parser_parse_main_method_declaration (ValaGenieParser* self,
                                                             ValaList* attrs,
                                                             GError** error);
static ValaConstructor* vala_genie_parser_parse_constructor_declaration (ValaGenieParser* self,
                                                                  ValaList* attrs,
                                                                  GError** error);
static ValaSymbol* vala_genie_parser_parse_delegate_declaration (ValaGenieParser* self,
                                                          ValaList* attrs,
                                                          GError** error);
static ValaMethod* vala_genie_parser_parse_method_declaration (ValaGenieParser* self,
                                                        ValaList* attrs,
                                                        GError** error);
static ValaSymbol* vala_genie_parser_parse_enum_declaration (ValaGenieParser* self,
                                                      ValaList* attrs,
                                                      GError** error);
static ValaSymbol* vala_genie_parser_parse_errordomain_declaration (ValaGenieParser* self,
                                                             ValaList* attrs,
                                                             GError** error);
static ValaDestructor* vala_genie_parser_parse_destructor_declaration (ValaGenieParser* self,
                                                                ValaList* attrs,
                                                                GError** error);
static ValaSymbol* vala_genie_parser_parse_interface_declaration (ValaGenieParser* self,
                                                           ValaList* attrs,
                                                           GError** error);
static ValaNamespace* vala_genie_parser_parse_namespace_declaration (ValaGenieParser* self,
                                                              ValaList* attrs,
                                                              GError** error);
static ValaProperty* vala_genie_parser_parse_property_declaration (ValaGenieParser* self,
                                                            ValaList* attrs,
                                                            GError** error);
static ValaSignal* vala_genie_parser_parse_signal_declaration (ValaGenieParser* self,
                                                        ValaList* attrs,
                                                        GError** error);
static ValaSymbol* vala_genie_parser_parse_struct_declaration (ValaGenieParser* self,
                                                        ValaList* attrs,
                                                        GError** error);
static ValaField* vala_genie_parser_parse_field_declaration (ValaGenieParser* self,
                                                      ValaList* attrs,
                                                      GError** error);
static void vala_genie_parser_parse_namespace_member (ValaGenieParser* self,
                                               ValaNamespace* ns,
                                               GError** error);
static void vala_genie_parser_parse_class_member (ValaGenieParser* self,
                                           ValaClass* cl,
                                           GError** error);
static void vala_genie_parser_parse_struct_member (ValaGenieParser* self,
                                            ValaStruct* st,
                                            GError** error);
static void vala_genie_parser_parse_interface_member (ValaGenieParser* self,
                                               ValaInterface* iface,
                                               GError** error);
static void vala_genie_parser_add_uses_clause (ValaGenieParser* self,
                                        ValaNamespace* ns,
                                        GError** error);
static ValaGenieParserModifierFlags vala_genie_parser_parse_type_declaration_modifiers (ValaGenieParser* self);
static ValaList* vala_genie_parser_parse_type_parameter_list (ValaGenieParser* self,
                                                       GError** error);
static ValaGenieParserModifierFlags vala_genie_parser_parse_member_declaration_modifiers (ValaGenieParser* self);
static ValaParameter* vala_genie_parser_parse_parameter (ValaGenieParser* self,
                                                  GError** error);
static void vala_genie_parser_finalize (ValaCodeVisitor * obj);

static inline gpointer
vala_genie_parser_get_instance_private (ValaGenieParser* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGenieParser_private_offset);
}

static GType
vala_genie_parser_modifier_flags_get_type (void)
{
	static volatile gsize vala_genie_parser_modifier_flags_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_parser_modifier_flags_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_GENIE_PARSER_MODIFIER_FLAGS_NONE, "VALA_GENIE_PARSER_MODIFIER_FLAGS_NONE", "none"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT, "VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT", "abstract"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS, "VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS", "class"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN, "VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN", "extern"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE, "VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE", "inline"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW, "VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW", "new"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE, "VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE", "override"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC, "VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC", "static"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL, "VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL", "virtual"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE, "VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE", "private"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_ASYNC, "VALA_GENIE_PARSER_MODIFIER_FLAGS_ASYNC", "async"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_SEALED, "VALA_GENIE_PARSER_MODIFIER_FLAGS_SEALED", "sealed"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_PUBLIC, "VALA_GENIE_PARSER_MODIFIER_FLAGS_PUBLIC", "public"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED, "VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED", "protected"}, {0, NULL, NULL}};
		GType vala_genie_parser_modifier_flags_type_id;
		vala_genie_parser_modifier_flags_type_id = g_enum_register_static ("ValaGenieParserModifierFlags", values);
		g_once_init_leave (&vala_genie_parser_modifier_flags_type_id__volatile, vala_genie_parser_modifier_flags_type_id);
	}
	return vala_genie_parser_modifier_flags_type_id__volatile;
}

static GType
vala_genie_parser_recovery_state_get_type (void)
{
	static volatile gsize vala_genie_parser_recovery_state_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_parser_recovery_state_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_GENIE_PARSER_RECOVERY_STATE_EOF, "VALA_GENIE_PARSER_RECOVERY_STATE_EOF", "eof"}, {VALA_GENIE_PARSER_RECOVERY_STATE_DECLARATION_BEGIN, "VALA_GENIE_PARSER_RECOVERY_STATE_DECLARATION_BEGIN", "declaration-begin"}, {VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN, "VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN", "statement-begin"}, {0, NULL, NULL}};
		GType vala_genie_parser_recovery_state_type_id;
		vala_genie_parser_recovery_state_type_id = g_enum_register_static ("ValaGenieParserRecoveryState", values);
		g_once_init_leave (&vala_genie_parser_recovery_state_type_id__volatile, vala_genie_parser_recovery_state_type_id);
	}
	return vala_genie_parser_recovery_state_type_id__volatile;
}

ValaGenieParser*
vala_genie_parser_construct (GType object_type)
{
	ValaGenieParser* self = NULL;
	ValaGenieParserTokenInfo* _tmp0_;
	self = (ValaGenieParser*) vala_code_visitor_construct (object_type);
	_tmp0_ = g_new0 (ValaGenieParserTokenInfo, VALA_GENIE_PARSER_BUFFER_SIZE);
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
	self->priv->tokens = _tmp0_;
	self->priv->tokens_length1 = VALA_GENIE_PARSER_BUFFER_SIZE;
	self->priv->_tokens_size_ = self->priv->tokens_length1;
	_g_free0 (self->priv->class_name);
	self->priv->class_name = NULL;
	self->priv->current_expr_is_lambda = FALSE;
	return self;
}

ValaGenieParser*
vala_genie_parser_new (void)
{
	return vala_genie_parser_construct (VALA_GENIE_TYPE_PARSER);
}

/**
 * Parses all .gs source files in the specified code context and
 * builds a code tree.
 *
 * @param context a code context
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}

void
vala_genie_parser_parse (ValaGenieParser* self,
                         ValaCodeContext* context)
{
	ValaCodeContext* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = NULL;
}

static void
vala_genie_parser_real_visit_source_file (ValaCodeVisitor* base,
                                          ValaSourceFile* source_file)
{
	ValaGenieParser * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ValaGenieParser*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_filename (source_file);
	_tmp1_ = _tmp0_;
	if (g_str_has_suffix (_tmp1_, ".gs")) {
		vala_genie_parser_parse_file (self, source_file);
	}
}

static inline gboolean
vala_genie_parser_next (ValaGenieParser* self)
{
	gboolean result = FALSE;
	gint _tmp0_;
	ValaGenieParserTokenInfo* _tmp10_;
	gint _tmp10__length1;
	ValaGenieParserTokenInfo _tmp11_;
	ValaGenieTokenType _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->index = (self->priv->index + 1) % VALA_GENIE_PARSER_BUFFER_SIZE;
	_tmp0_ = self->priv->size;
	self->priv->size = _tmp0_ - 1;
	if (self->priv->size <= 0) {
		ValaSourceLocation begin = {0};
		ValaSourceLocation end = {0};
		ValaGenieTokenType type = 0;
		ValaGenieScanner* _tmp1_;
		ValaSourceLocation _tmp2_ = {0};
		ValaSourceLocation _tmp3_ = {0};
		ValaGenieTokenType _tmp4_;
		ValaGenieParserTokenInfo* _tmp5_;
		gint _tmp5__length1;
		ValaGenieTokenType _tmp6_;
		ValaSourceLocation _tmp7_;
		ValaSourceLocation _tmp8_;
		ValaGenieParserTokenInfo _tmp9_ = {0};
		_tmp1_ = self->priv->scanner;
		_tmp4_ = vala_genie_scanner_read_token (_tmp1_, &_tmp2_, &_tmp3_);
		begin = _tmp2_;
		end = _tmp3_;
		type = _tmp4_;
		_tmp5_ = self->priv->tokens;
		_tmp5__length1 = self->priv->tokens_length1;
		_tmp6_ = type;
		_tmp7_ = begin;
		_tmp8_ = end;
		_tmp9_.type = _tmp6_;
		_tmp9_.begin = _tmp7_;
		_tmp9_.end = _tmp8_;
		_tmp5_[self->priv->index] = _tmp9_;
		self->priv->size = 1;
	}
	_tmp10_ = self->priv->tokens;
	_tmp10__length1 = self->priv->tokens_length1;
	_tmp11_ = _tmp10_[self->priv->index];
	_tmp12_ = _tmp11_.type;
	result = _tmp12_ != VALA_GENIE_TOKEN_TYPE_EOF;
	return result;
}

static inline void
vala_genie_parser_prev (ValaGenieParser* self)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->index = ((self->priv->index - 1) + VALA_GENIE_PARSER_BUFFER_SIZE) % VALA_GENIE_PARSER_BUFFER_SIZE;
	_tmp0_ = self->priv->size;
	self->priv->size = _tmp0_ + 1;
	_vala_assert (self->priv->size <= VALA_GENIE_PARSER_BUFFER_SIZE, "size <= BUFFER_SIZE");
}

static inline ValaGenieTokenType
vala_genie_parser_current (ValaGenieParser* self)
{
	ValaGenieTokenType result = 0;
	ValaGenieParserTokenInfo* _tmp0_;
	gint _tmp0__length1;
	ValaGenieParserTokenInfo _tmp1_;
	ValaGenieTokenType _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->tokens;
	_tmp0__length1 = self->priv->tokens_length1;
	_tmp1_ = _tmp0_[self->priv->index];
	_tmp2_ = _tmp1_.type;
	result = _tmp2_;
	return result;
}

static inline gboolean
vala_genie_parser_accept (ValaGenieParser* self,
                          ValaGenieTokenType type)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_genie_parser_current (self) == type) {
		vala_genie_parser_next (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static inline gboolean
vala_genie_parser_accept_separator (ValaGenieParser* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_COMMA) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_EOL;
	}
	if (_tmp0_) {
		vala_genie_parser_next (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static inline gboolean
vala_genie_parser_accept_terminator (ValaGenieParser* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_SEMICOLON) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_EOL;
	}
	if (_tmp0_) {
		vala_genie_parser_next (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static inline gboolean
vala_genie_parser_accept_block (ValaGenieParser* self)
{
	gboolean result = FALSE;
	gboolean has_term = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	has_term = vala_genie_parser_accept_terminator (self);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT)) {
		vala_genie_parser_prev (self);
		result = TRUE;
		return result;
	}
	if (has_term) {
		vala_genie_parser_prev (self);
	}
	result = FALSE;
	return result;
}

static void
vala_genie_parser_report_parse_error (ValaGenieParser* self,
                                      GError* e)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_next (self);
	_tmp1_ = begin;
	_tmp2_ = vala_genie_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = e->message;
	_tmp5_ = g_strconcat ("syntax error, ", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	vala_report_error (_tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	_vala_source_reference_unref0 (_tmp3_);
}

static inline gboolean
vala_genie_parser_expect (ValaGenieParser* self,
                          ValaGenieTokenType type,
                          GError** error)
{
	gboolean result = FALSE;
	ValaGenieTokenType cur = 0;
	ValaGenieTokenType pre = 0;
	ValaGenieParserTokenInfo* _tmp0_;
	gint _tmp0__length1;
	ValaGenieParserTokenInfo _tmp1_;
	ValaGenieTokenType _tmp2_;
	const gchar* _tmp3_;
	ValaGenieTokenType _tmp4_;
	const gchar* _tmp5_;
	ValaGenieTokenType _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_genie_parser_accept (self, type)) {
		result = TRUE;
		return result;
	}
	cur = vala_genie_parser_current (self);
	_tmp0_ = self->priv->tokens;
	_tmp0__length1 = self->priv->tokens_length1;
	_tmp1_ = _tmp0_[self->priv->index - 1];
	_tmp2_ = _tmp1_.type;
	pre = _tmp2_;
	_tmp3_ = vala_genie_token_type_to_string (type);
	_tmp4_ = cur;
	_tmp5_ = vala_genie_token_type_to_string (_tmp4_);
	_tmp6_ = pre;
	_tmp7_ = vala_genie_token_type_to_string (_tmp6_);
	_tmp8_ = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected %s but got %s with previous %s", _tmp3_, _tmp5_, _tmp7_);
	_inner_error0_ = _tmp8_;
	if (_inner_error0_->domain == VALA_PARSE_ERROR) {
		gboolean _tmp9_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp9_;
	} else {
		gboolean _tmp10_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
}

static inline gboolean
vala_genie_parser_expect_separator (ValaGenieParser* self,
                                    GError** error)
{
	gboolean result = FALSE;
	ValaGenieTokenType cur = 0;
	ValaGenieTokenType _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_genie_parser_accept_separator (self)) {
		result = TRUE;
		return result;
	}
	cur = vala_genie_parser_current (self);
	_tmp0_ = cur;
	_tmp1_ = vala_genie_token_type_to_string (_tmp0_);
	_tmp2_ = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected line end or comma but got %s", _tmp1_);
	_inner_error0_ = _tmp2_;
	if (_inner_error0_->domain == VALA_PARSE_ERROR) {
		gboolean _tmp3_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp3_;
	} else {
		gboolean _tmp4_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static inline gboolean
vala_genie_parser_expect_terminator (ValaGenieParser* self,
                                     GError** error)
{
	gboolean result = FALSE;
	ValaGenieTokenType cur = 0;
	ValaGenieTokenType _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_genie_parser_accept_terminator (self)) {
		result = TRUE;
		return result;
	}
	cur = vala_genie_parser_current (self);
	_tmp0_ = cur;
	_tmp1_ = vala_genie_token_type_to_string (_tmp0_);
	_tmp2_ = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected line end or semicolon but got %s", _tmp1_);
	_inner_error0_ = _tmp2_;
	if (_inner_error0_->domain == VALA_PARSE_ERROR) {
		gboolean _tmp3_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp3_;
	} else {
		gboolean _tmp4_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static inline void
vala_genie_parser_get_location (ValaGenieParser* self,
                                ValaSourceLocation* result)
{
	ValaGenieParserTokenInfo* _tmp0_;
	gint _tmp0__length1;
	ValaGenieParserTokenInfo _tmp1_;
	ValaSourceLocation _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tokens;
	_tmp0__length1 = self->priv->tokens_length1;
	_tmp1_ = _tmp0_[self->priv->index];
	_tmp2_ = _tmp1_.begin;
	*result = _tmp2_;
	return;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
vala_genie_parser_get_current_string (ValaGenieParser* self)
{
	gchar* result = NULL;
	ValaGenieParserTokenInfo token = {0};
	ValaGenieParserTokenInfo* _tmp0_;
	gint _tmp0__length1;
	ValaGenieParserTokenInfo _tmp1_;
	ValaGenieParserTokenInfo _tmp2_;
	ValaSourceLocation _tmp3_;
	gchar* _tmp4_;
	ValaGenieParserTokenInfo _tmp5_;
	ValaSourceLocation _tmp6_;
	gchar* _tmp7_;
	ValaGenieParserTokenInfo _tmp8_;
	ValaSourceLocation _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tokens;
	_tmp0__length1 = self->priv->tokens_length1;
	_tmp1_ = _tmp0_[self->priv->index];
	token = _tmp1_;
	_tmp2_ = token;
	_tmp3_ = _tmp2_.begin;
	_tmp4_ = _tmp3_.pos;
	_tmp5_ = token;
	_tmp6_ = _tmp5_.end;
	_tmp7_ = _tmp6_.pos;
	_tmp8_ = token;
	_tmp9_ = _tmp8_.begin;
	_tmp10_ = _tmp9_.pos;
	_tmp11_ = string_substring ((const gchar*) _tmp4_, (glong) 0, (glong) ((gint) (_tmp7_ - _tmp10_)));
	result = _tmp11_;
	return result;
}

static gchar*
vala_genie_parser_get_last_string (ValaGenieParser* self)
{
	gchar* result = NULL;
	gint last_index = 0;
	ValaGenieParserTokenInfo token = {0};
	ValaGenieParserTokenInfo* _tmp0_;
	gint _tmp0__length1;
	ValaGenieParserTokenInfo _tmp1_;
	ValaGenieParserTokenInfo _tmp2_;
	ValaSourceLocation _tmp3_;
	gchar* _tmp4_;
	ValaGenieParserTokenInfo _tmp5_;
	ValaSourceLocation _tmp6_;
	gchar* _tmp7_;
	ValaGenieParserTokenInfo _tmp8_;
	ValaSourceLocation _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	last_index = ((self->priv->index + VALA_GENIE_PARSER_BUFFER_SIZE) - 1) % VALA_GENIE_PARSER_BUFFER_SIZE;
	_tmp0_ = self->priv->tokens;
	_tmp0__length1 = self->priv->tokens_length1;
	_tmp1_ = _tmp0_[last_index];
	token = _tmp1_;
	_tmp2_ = token;
	_tmp3_ = _tmp2_.begin;
	_tmp4_ = _tmp3_.pos;
	_tmp5_ = token;
	_tmp6_ = _tmp5_.end;
	_tmp7_ = _tmp6_.pos;
	_tmp8_ = token;
	_tmp9_ = _tmp8_.begin;
	_tmp10_ = _tmp9_.pos;
	_tmp11_ = string_substring ((const gchar*) _tmp4_, (glong) 0, (glong) ((gint) (_tmp7_ - _tmp10_)));
	result = _tmp11_;
	return result;
}

static ValaSourceReference*
vala_genie_parser_get_src (ValaGenieParser* self,
                           ValaSourceLocation* begin)
{
	ValaSourceReference* result = NULL;
	gint last_index = 0;
	ValaGenieScanner* _tmp0_;
	ValaSourceFile* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaGenieParserTokenInfo* _tmp4_;
	gint _tmp4__length1;
	ValaGenieParserTokenInfo _tmp5_;
	ValaSourceLocation _tmp6_;
	ValaSourceReference* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	last_index = ((self->priv->index + VALA_GENIE_PARSER_BUFFER_SIZE) - 1) % VALA_GENIE_PARSER_BUFFER_SIZE;
	_tmp0_ = self->priv->scanner;
	_tmp1_ = vala_genie_scanner_get_source_file (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = *begin;
	_tmp4_ = self->priv->tokens;
	_tmp4__length1 = self->priv->tokens_length1;
	_tmp5_ = _tmp4_[last_index];
	_tmp6_ = _tmp5_.end;
	_tmp7_ = vala_source_reference_new (_tmp2_, &_tmp3_, &_tmp6_);
	result = _tmp7_;
	return result;
}

static ValaSourceReference*
vala_genie_parser_get_current_src (ValaGenieParser* self)
{
	ValaSourceReference* result = NULL;
	ValaGenieParserTokenInfo token = {0};
	ValaGenieParserTokenInfo* _tmp0_;
	gint _tmp0__length1;
	ValaGenieParserTokenInfo _tmp1_;
	ValaGenieScanner* _tmp2_;
	ValaSourceFile* _tmp3_;
	ValaSourceFile* _tmp4_;
	ValaGenieParserTokenInfo _tmp5_;
	ValaSourceLocation _tmp6_;
	ValaGenieParserTokenInfo _tmp7_;
	ValaSourceLocation _tmp8_;
	ValaSourceReference* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tokens;
	_tmp0__length1 = self->priv->tokens_length1;
	_tmp1_ = _tmp0_[self->priv->index];
	token = _tmp1_;
	_tmp2_ = self->priv->scanner;
	_tmp3_ = vala_genie_scanner_get_source_file (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = token;
	_tmp6_ = _tmp5_.begin;
	_tmp7_ = token;
	_tmp8_ = _tmp7_.end;
	_tmp9_ = vala_source_reference_new (_tmp4_, &_tmp6_, &_tmp8_);
	result = _tmp9_;
	return result;
}

static void
vala_genie_parser_rollback (ValaGenieParser* self,
                            ValaSourceLocation* location)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	while (TRUE) {
		ValaGenieParserTokenInfo* _tmp0_;
		gint _tmp0__length1;
		ValaGenieParserTokenInfo _tmp1_;
		ValaSourceLocation _tmp2_;
		gchar* _tmp3_;
		ValaSourceLocation _tmp4_;
		gchar* _tmp5_;
		gint _tmp6_;
		_tmp0_ = self->priv->tokens;
		_tmp0__length1 = self->priv->tokens_length1;
		_tmp1_ = _tmp0_[self->priv->index];
		_tmp2_ = _tmp1_.begin;
		_tmp3_ = _tmp2_.pos;
		_tmp4_ = *location;
		_tmp5_ = _tmp4_.pos;
		if (!(_tmp3_ != _tmp5_)) {
			break;
		}
		self->priv->index = ((self->priv->index - 1) + VALA_GENIE_PARSER_BUFFER_SIZE) % VALA_GENIE_PARSER_BUFFER_SIZE;
		_tmp6_ = self->priv->size;
		self->priv->size = _tmp6_ + 1;
		if (self->priv->size > VALA_GENIE_PARSER_BUFFER_SIZE) {
			ValaGenieScanner* _tmp7_;
			ValaSourceLocation _tmp8_;
			_tmp7_ = self->priv->scanner;
			_tmp8_ = *location;
			vala_genie_scanner_seek (_tmp7_, &_tmp8_);
			self->priv->size = 0;
			self->priv->index = 0;
			vala_genie_parser_next (self);
		}
	}
}

static inline ValaSymbolAccessibility
vala_genie_parser_get_default_accessibility (ValaGenieParser* self,
                                             const gchar* s)
{
	ValaSymbolAccessibility result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (s != NULL, 0);
	if (g_str_has_prefix (s, "_")) {
		result = VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
		return result;
	}
	result = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
vala_genie_parser_skip_identifier (ValaGenieParser* self,
                                   GError** error)
{
	GError* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	switch (vala_genie_parser_current (self)) {
		case VALA_GENIE_TOKEN_TYPE_ABSTRACT:
		case VALA_GENIE_TOKEN_TYPE_AS:
		case VALA_GENIE_TOKEN_TYPE_ASSERT:
		case VALA_GENIE_TOKEN_TYPE_ASYNC:
		case VALA_GENIE_TOKEN_TYPE_BREAK:
		case VALA_GENIE_TOKEN_TYPE_CLASS:
		case VALA_GENIE_TOKEN_TYPE_CONST:
		case VALA_GENIE_TOKEN_TYPE_CONTINUE:
		case VALA_GENIE_TOKEN_TYPE_DEDENT:
		case VALA_GENIE_TOKEN_TYPE_DEF:
		case VALA_GENIE_TOKEN_TYPE_DEFAULT:
		case VALA_GENIE_TOKEN_TYPE_DELEGATE:
		case VALA_GENIE_TOKEN_TYPE_DELETE:
		case VALA_GENIE_TOKEN_TYPE_DO:
		case VALA_GENIE_TOKEN_TYPE_DOWNTO:
		case VALA_GENIE_TOKEN_TYPE_DYNAMIC:
		case VALA_GENIE_TOKEN_TYPE_ELSE:
		case VALA_GENIE_TOKEN_TYPE_EOL:
		case VALA_GENIE_TOKEN_TYPE_ENUM:
		case VALA_GENIE_TOKEN_TYPE_ENSURES:
		case VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN:
		case VALA_GENIE_TOKEN_TYPE_EVENT:
		case VALA_GENIE_TOKEN_TYPE_EXCEPT:
		case VALA_GENIE_TOKEN_TYPE_EXTERN:
		case VALA_GENIE_TOKEN_TYPE_FALSE:
		case VALA_GENIE_TOKEN_TYPE_FINAL:
		case VALA_GENIE_TOKEN_TYPE_FINALLY:
		case VALA_GENIE_TOKEN_TYPE_FOR:
		case VALA_GENIE_TOKEN_TYPE_GET:
		case VALA_GENIE_TOKEN_TYPE_IDENTIFIER:
		case VALA_GENIE_TOKEN_TYPE_IF:
		case VALA_GENIE_TOKEN_TYPE_IN:
		case VALA_GENIE_TOKEN_TYPE_INDENT:
		case VALA_GENIE_TOKEN_TYPE_INIT:
		case VALA_GENIE_TOKEN_TYPE_INLINE:
		case VALA_GENIE_TOKEN_TYPE_INTERFACE:
		case VALA_GENIE_TOKEN_TYPE_INTERNAL:
		case VALA_GENIE_TOKEN_TYPE_IS:
		case VALA_GENIE_TOKEN_TYPE_ISA:
		case VALA_GENIE_TOKEN_TYPE_LOCK:
		case VALA_GENIE_TOKEN_TYPE_NAMESPACE:
		case VALA_GENIE_TOKEN_TYPE_NEW:
		case VALA_GENIE_TOKEN_TYPE_NULL:
		case VALA_GENIE_TOKEN_TYPE_OF:
		case VALA_GENIE_TOKEN_TYPE_OUT:
		case VALA_GENIE_TOKEN_TYPE_OVERRIDE:
		case VALA_GENIE_TOKEN_TYPE_OWNED:
		case VALA_GENIE_TOKEN_TYPE_PASS:
		case VALA_GENIE_TOKEN_TYPE_PRINT:
		case VALA_GENIE_TOKEN_TYPE_PRIVATE:
		case VALA_GENIE_TOKEN_TYPE_PROTECTED:
		case VALA_GENIE_TOKEN_TYPE_PROP:
		case VALA_GENIE_TOKEN_TYPE_RAISE:
		case VALA_GENIE_TOKEN_TYPE_RAISES:
		case VALA_GENIE_TOKEN_TYPE_REF:
		case VALA_GENIE_TOKEN_TYPE_REQUIRES:
		case VALA_GENIE_TOKEN_TYPE_RETURN:
		case VALA_GENIE_TOKEN_TYPE_SEALED:
		case VALA_GENIE_TOKEN_TYPE_SET:
		case VALA_GENIE_TOKEN_TYPE_SIZEOF:
		case VALA_GENIE_TOKEN_TYPE_STATIC:
		case VALA_GENIE_TOKEN_TYPE_STRUCT:
		case VALA_GENIE_TOKEN_TYPE_SUPER:
		case VALA_GENIE_TOKEN_TYPE_THIS:
		case VALA_GENIE_TOKEN_TYPE_TO:
		case VALA_GENIE_TOKEN_TYPE_TRUE:
		case VALA_GENIE_TOKEN_TYPE_TRY:
		case VALA_GENIE_TOKEN_TYPE_TYPEOF:
		case VALA_GENIE_TOKEN_TYPE_UNOWNED:
		case VALA_GENIE_TOKEN_TYPE_USES:
		case VALA_GENIE_TOKEN_TYPE_VAR:
		case VALA_GENIE_TOKEN_TYPE_VIRTUAL:
		case VALA_GENIE_TOKEN_TYPE_VOID:
		case VALA_GENIE_TOKEN_TYPE_VOLATILE:
		case VALA_GENIE_TOKEN_TYPE_WEAK:
		case VALA_GENIE_TOKEN_TYPE_WHEN:
		case VALA_GENIE_TOKEN_TYPE_WHILE:
		case VALA_GENIE_TOKEN_TYPE_YIELD:
		{
			vala_genie_parser_next (self);
			return;
		}
		case VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL:
		case VALA_GENIE_TOKEN_TYPE_REAL_LITERAL:
		{
			gchar* id = NULL;
			gchar* _tmp0_;
			gboolean _tmp1_ = FALSE;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			_tmp0_ = vala_genie_parser_get_current_string (self);
			id = _tmp0_;
			_tmp2_ = id;
			_tmp3_ = id;
			_tmp4_ = strlen (_tmp3_);
			_tmp5_ = _tmp4_;
			if (g_ascii_isalpha (string_get (_tmp2_, (glong) (_tmp5_ - 1)))) {
				const gchar* _tmp6_;
				_tmp6_ = id;
				_tmp1_ = !string_contains (_tmp6_, ".");
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				vala_genie_parser_next (self);
				_g_free0 (id);
				return;
			}
			_g_free0 (id);
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp7_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected identifier");
	_inner_error0_ = _tmp7_;
	if (_inner_error0_->domain == VALA_PARSE_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
vala_genie_parser_parse_identifier (ValaGenieParser* self,
                                    GError** error)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_skip_identifier (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp0_ = vala_genie_parser_get_last_string (self);
	result = _tmp0_;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_literal (ValaGenieParser* self,
                                 GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	switch (vala_genie_parser_current (self)) {
		case VALA_GENIE_TOKEN_TYPE_TRUE:
		{
			ValaSourceLocation _tmp1_;
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			ValaBooleanLiteral* _tmp4_;
			ValaExpression* _tmp5_;
			vala_genie_parser_next (self);
			_tmp1_ = begin;
			_tmp2_ = vala_genie_parser_get_src (self, &_tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = vala_boolean_literal_new (TRUE, _tmp3_);
			_tmp5_ = (ValaExpression*) _tmp4_;
			_vala_source_reference_unref0 (_tmp3_);
			result = _tmp5_;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_FALSE:
		{
			ValaSourceLocation _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaBooleanLiteral* _tmp9_;
			ValaExpression* _tmp10_;
			vala_genie_parser_next (self);
			_tmp6_ = begin;
			_tmp7_ = vala_genie_parser_get_src (self, &_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_boolean_literal_new (FALSE, _tmp8_);
			_tmp10_ = (ValaExpression*) _tmp9_;
			_vala_source_reference_unref0 (_tmp8_);
			result = _tmp10_;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL:
		{
			gchar* _tmp11_;
			gchar* _tmp12_;
			ValaSourceLocation _tmp13_;
			ValaSourceReference* _tmp14_;
			ValaSourceReference* _tmp15_;
			ValaIntegerLiteral* _tmp16_;
			ValaExpression* _tmp17_;
			vala_genie_parser_next (self);
			_tmp11_ = vala_genie_parser_get_last_string (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = begin;
			_tmp14_ = vala_genie_parser_get_src (self, &_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_integer_literal_new (_tmp12_, _tmp15_);
			_tmp17_ = (ValaExpression*) _tmp16_;
			_vala_source_reference_unref0 (_tmp15_);
			_g_free0 (_tmp12_);
			result = _tmp17_;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_REAL_LITERAL:
		{
			gchar* _tmp18_;
			gchar* _tmp19_;
			ValaSourceLocation _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaSourceReference* _tmp22_;
			ValaRealLiteral* _tmp23_;
			ValaExpression* _tmp24_;
			vala_genie_parser_next (self);
			_tmp18_ = vala_genie_parser_get_last_string (self);
			_tmp19_ = _tmp18_;
			_tmp20_ = begin;
			_tmp21_ = vala_genie_parser_get_src (self, &_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_real_literal_new (_tmp19_, _tmp22_);
			_tmp24_ = (ValaExpression*) _tmp23_;
			_vala_source_reference_unref0 (_tmp22_);
			_g_free0 (_tmp19_);
			result = _tmp24_;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL:
		{
			ValaCharacterLiteral* lit = NULL;
			gchar* _tmp25_;
			gchar* _tmp26_;
			ValaSourceLocation _tmp27_;
			ValaSourceReference* _tmp28_;
			ValaSourceReference* _tmp29_;
			ValaCharacterLiteral* _tmp30_;
			ValaCharacterLiteral* _tmp31_;
			ValaCharacterLiteral* _tmp32_;
			gboolean _tmp33_;
			gboolean _tmp34_;
			vala_genie_parser_next (self);
			_tmp25_ = vala_genie_parser_get_last_string (self);
			_tmp26_ = _tmp25_;
			_tmp27_ = begin;
			_tmp28_ = vala_genie_parser_get_src (self, &_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = vala_character_literal_new (_tmp26_, _tmp29_);
			_tmp31_ = _tmp30_;
			_vala_source_reference_unref0 (_tmp29_);
			_g_free0 (_tmp26_);
			lit = _tmp31_;
			_tmp32_ = lit;
			_tmp33_ = vala_code_node_get_error ((ValaCodeNode*) _tmp32_);
			_tmp34_ = _tmp33_;
			if (_tmp34_) {
				ValaCharacterLiteral* _tmp35_;
				ValaSourceReference* _tmp36_;
				ValaSourceReference* _tmp37_;
				_tmp35_ = lit;
				_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp35_);
				_tmp37_ = _tmp36_;
				vala_report_error (_tmp37_, "invalid character literal");
			}
			result = (ValaExpression*) lit;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_REGEX_LITERAL:
		{
			gchar* match_part = NULL;
			gchar* _tmp38_;
			ValaSourceReference* src_begin = NULL;
			ValaSourceLocation _tmp39_;
			ValaSourceReference* _tmp40_;
			gchar* close_token = NULL;
			gchar* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaSourceReference* _tmp46_;
			ValaRegexLiteral* _tmp47_;
			ValaExpression* _tmp48_;
			vala_genie_parser_next (self);
			_tmp38_ = vala_genie_parser_get_last_string (self);
			match_part = _tmp38_;
			_tmp39_ = begin;
			_tmp40_ = vala_genie_parser_get_src (self, &_tmp39_);
			src_begin = _tmp40_;
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_REGEX_LITERAL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_source_reference_unref0 (src_begin);
					_g_free0 (match_part);
					return NULL;
				} else {
					_vala_source_reference_unref0 (src_begin);
					_g_free0 (match_part);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp41_ = vala_genie_parser_get_last_string (self);
			close_token = _tmp41_;
			_tmp42_ = close_token;
			_tmp43_ = match_part;
			_tmp44_ = g_strdup_printf ("%s/%s", _tmp42_, _tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = src_begin;
			_tmp47_ = vala_regex_literal_new (_tmp45_, _tmp46_);
			_tmp48_ = (ValaExpression*) _tmp47_;
			_g_free0 (_tmp45_);
			result = _tmp48_;
			_g_free0 (close_token);
			_vala_source_reference_unref0 (src_begin);
			_g_free0 (match_part);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_STRING_LITERAL:
		{
			gchar* _tmp49_;
			gchar* _tmp50_;
			ValaSourceLocation _tmp51_;
			ValaSourceReference* _tmp52_;
			ValaSourceReference* _tmp53_;
			ValaStringLiteral* _tmp54_;
			ValaExpression* _tmp55_;
			vala_genie_parser_next (self);
			_tmp49_ = vala_genie_parser_get_last_string (self);
			_tmp50_ = _tmp49_;
			_tmp51_ = begin;
			_tmp52_ = vala_genie_parser_get_src (self, &_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_string_literal_new (_tmp50_, _tmp53_);
			_tmp55_ = (ValaExpression*) _tmp54_;
			_vala_source_reference_unref0 (_tmp53_);
			_g_free0 (_tmp50_);
			result = _tmp55_;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_TEMPLATE_STRING_LITERAL:
		{
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			ValaSourceLocation _tmp60_;
			ValaSourceReference* _tmp61_;
			ValaSourceReference* _tmp62_;
			ValaStringLiteral* _tmp63_;
			ValaExpression* _tmp64_;
			vala_genie_parser_next (self);
			_tmp56_ = vala_genie_parser_get_last_string (self);
			_tmp57_ = _tmp56_;
			_tmp58_ = g_strdup_printf ("\"%s\"", _tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = begin;
			_tmp61_ = vala_genie_parser_get_src (self, &_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_string_literal_new (_tmp59_, _tmp62_);
			_tmp64_ = (ValaExpression*) _tmp63_;
			_vala_source_reference_unref0 (_tmp62_);
			_g_free0 (_tmp59_);
			_g_free0 (_tmp57_);
			result = _tmp64_;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_VERBATIM_STRING_LITERAL:
		{
			gchar* raw_string = NULL;
			gchar* _tmp65_;
			gchar* escaped_string = NULL;
			const gchar* _tmp66_;
			const gchar* _tmp67_;
			gint _tmp68_;
			gint _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			gchar* _tmp73_;
			const gchar* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			ValaSourceLocation _tmp77_;
			ValaSourceReference* _tmp78_;
			ValaSourceReference* _tmp79_;
			ValaStringLiteral* _tmp80_;
			ValaExpression* _tmp81_;
			vala_genie_parser_next (self);
			_tmp65_ = vala_genie_parser_get_last_string (self);
			raw_string = _tmp65_;
			_tmp66_ = raw_string;
			_tmp67_ = raw_string;
			_tmp68_ = strlen (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = string_substring (_tmp66_, (glong) 3, (glong) (_tmp69_ - 6));
			_tmp71_ = _tmp70_;
			_tmp72_ = g_strescape (_tmp71_, "");
			_tmp73_ = _tmp72_;
			_g_free0 (_tmp71_);
			escaped_string = _tmp73_;
			_tmp74_ = escaped_string;
			_tmp75_ = g_strdup_printf ("\"%s\"", _tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = begin;
			_tmp78_ = vala_genie_parser_get_src (self, &_tmp77_);
			_tmp79_ = _tmp78_;
			_tmp80_ = vala_string_literal_new (_tmp76_, _tmp79_);
			_tmp81_ = (ValaExpression*) _tmp80_;
			_vala_source_reference_unref0 (_tmp79_);
			_g_free0 (_tmp76_);
			result = _tmp81_;
			_g_free0 (escaped_string);
			_g_free0 (raw_string);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_NULL:
		{
			ValaSourceLocation _tmp82_;
			ValaSourceReference* _tmp83_;
			ValaSourceReference* _tmp84_;
			ValaNullLiteral* _tmp85_;
			ValaExpression* _tmp86_;
			vala_genie_parser_next (self);
			_tmp82_ = begin;
			_tmp83_ = vala_genie_parser_get_src (self, &_tmp82_);
			_tmp84_ = _tmp83_;
			_tmp85_ = vala_null_literal_new (_tmp84_);
			_tmp86_ = (ValaExpression*) _tmp85_;
			_vala_source_reference_unref0 (_tmp84_);
			result = _tmp86_;
			return result;
		}
		default:
		{
			GError* _tmp87_;
			_tmp87_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected literal");
			_inner_error0_ = _tmp87_;
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
}

void
vala_genie_parser_parse_file (ValaGenieParser* self,
                              ValaSourceFile* source_file)
{
	gboolean has_global_context = FALSE;
	ValaCodeContext* _tmp0_;
	ValaGenieScanner* _tmp4_;
	ValaGenieScanner* _tmp5_;
	ValaGenieScanner* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_tmp0_ = self->priv->context;
	has_global_context = _tmp0_ != NULL;
	if (!has_global_context) {
		ValaCodeContext* _tmp1_;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		_tmp1_ = vala_source_file_get_context (source_file);
		_tmp2_ = _tmp1_;
		_tmp3_ = _vala_code_context_ref0 (_tmp2_);
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = _tmp3_;
	}
	_tmp4_ = vala_genie_scanner_new (source_file);
	_vala_genie_scanner_unref0 (self->priv->scanner);
	self->priv->scanner = _tmp4_;
	_tmp5_ = self->priv->scanner;
	vala_genie_scanner_parse_file_comments (_tmp5_);
	_tmp6_ = self->priv->scanner;
	vala_genie_scanner_set_indent_spaces (_tmp6_, 0);
	self->priv->index = -1;
	self->priv->size = 0;
	vala_genie_parser_next (self);
	{
		ValaSourceLocation begin = {0};
		ValaSourceLocation _tmp7_ = {0};
		ValaCodeContext* _tmp14_;
		ValaNamespace* _tmp15_;
		ValaNamespace* _tmp16_;
		ValaCodeContext* _tmp17_;
		ValaNamespace* _tmp18_;
		ValaNamespace* _tmp19_;
		vala_genie_parser_get_location (self, &_tmp7_);
		begin = _tmp7_;
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)) {
			gchar* id = NULL;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp8_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
			id = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					goto __catch12_vala_parse_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp9_ = id;
			if (g_strcmp0 (_tmp9_, "indent") == 0) {
				ValaGenieScanner* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ASSIGN, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (id);
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						goto __catch12_vala_parse_error;
					}
					_g_free0 (id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (id);
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						goto __catch12_vala_parse_error;
					}
					_g_free0 (id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp10_ = self->priv->scanner;
				_tmp11_ = vala_genie_parser_get_last_string (self);
				_tmp12_ = _tmp11_;
				vala_genie_scanner_set_indent_spaces (_tmp10_, atoi (_tmp12_));
				_g_free0 (_tmp12_);
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (id);
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						goto __catch12_vala_parse_error;
					}
					_g_free0 (id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (id);
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						goto __catch12_vala_parse_error;
					}
					_g_free0 (id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			} else {
				ValaSourceLocation _tmp13_;
				_tmp13_ = begin;
				vala_genie_parser_rollback (self, &_tmp13_);
			}
			_g_free0 (id);
		}
		_tmp14_ = self->priv->context;
		_tmp15_ = vala_code_context_get_root (_tmp14_);
		_tmp16_ = _tmp15_;
		vala_genie_parser_parse_using_directives (self, _tmp16_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				goto __catch12_vala_parse_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp17_ = self->priv->context;
		_tmp18_ = vala_code_context_get_root (_tmp17_);
		_tmp19_ = _tmp18_;
		vala_genie_parser_parse_declarations (self, (ValaSymbol*) _tmp19_, TRUE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				goto __catch12_vala_parse_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally12;
	__catch12_vala_parse_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		vala_genie_parser_report_parse_error (self, _tmp20_);
		_g_error_free0 (e);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_vala_genie_scanner_unref0 (self->priv->scanner);
	self->priv->scanner = NULL;
	if (!has_global_context) {
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = NULL;
	}
}

static void
vala_genie_parser_skip_symbol_name (ValaGenieParser* self,
                                    GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			if (!_tmp0_) {
				if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DOT)) {
					break;
				}
			}
			_tmp0_ = FALSE;
			vala_genie_parser_skip_identifier (self, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
}

static ValaUnresolvedSymbol*
vala_genie_parser_parse_symbol_name (ValaGenieParser* self,
                                     GError** error)
{
	ValaUnresolvedSymbol* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaUnresolvedSymbol* sym = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	sym = NULL;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			gchar* name = NULL;
			gchar* _tmp2_;
			ValaUnresolvedSymbol* _tmp3_;
			const gchar* _tmp4_;
			ValaSourceLocation _tmp5_;
			ValaSourceReference* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaUnresolvedSymbol* _tmp8_;
			if (!_tmp1_) {
				if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DOT)) {
					break;
				}
			}
			_tmp1_ = FALSE;
			_tmp2_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
			name = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (sym);
					return NULL;
				} else {
					_vala_code_node_unref0 (sym);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp3_ = sym;
			_tmp4_ = name;
			_tmp5_ = begin;
			_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_unresolved_symbol_new (_tmp3_, _tmp4_, _tmp7_);
			_vala_code_node_unref0 (sym);
			sym = _tmp8_;
			_vala_source_reference_unref0 (_tmp7_);
			_g_free0 (name);
		}
	}
	result = sym;
	return result;
}

static void
vala_genie_parser_skip_type (ValaGenieParser* self,
                             GError** error)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DYNAMIC);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OWNED);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_UNOWNED);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_WEAK);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ARRAY)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_LIST);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DICT);
	}
	if (_tmp0_) {
		vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OF);
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_VOID)) {
	} else {
		vala_genie_parser_skip_symbol_name (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		vala_genie_parser_skip_type_argument_list (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	while (TRUE) {
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)) {
			break;
		}
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				if (!_tmp2_) {
					if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp2_ = FALSE;
				if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_COMMA) {
					_tmp3_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					ValaExpression* _tmp4_;
					ValaExpression* _tmp5_;
					_tmp4_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
					_tmp5_ = _tmp4_;
					_vala_code_node_unref0 (_tmp5_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				}
			}
		}
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OP_NEG);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INTERR);
}

static ValaExpression*
vala_genie_parser_parse_regex_literal (ValaGenieParser* self,
                                       GError** error)
{
	ValaExpression* result = NULL;
	ValaExpression* expr = NULL;
	ValaExpression* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_REGEX_LITERAL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp0_ = vala_genie_parser_parse_literal (self, &_inner_error0_);
	expr = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = expr;
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static ValaDataType*
vala_genie_parser_parse_type (ValaGenieParser* self,
                              gboolean owned_by_default,
                              gboolean can_weak_ref,
                              GError** error)
{
	ValaDataType* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaList* type_arg_list = NULL;
	ValaUnresolvedSymbol* sym = NULL;
	gboolean is_dynamic = FALSE;
	gboolean value_owned = FALSE;
	gboolean is_array = FALSE;
	gboolean is_list = FALSE;
	gboolean is_dict = FALSE;
	ValaDataType* type = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	ValaDataType* _tmp60_;
	ValaDataType* _tmp85_;
	ValaDataType* _tmp86_;
	ValaDataType* _tmp87_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	type_arg_list = NULL;
	sym = NULL;
	is_dynamic = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DYNAMIC);
	value_owned = owned_by_default;
	if (owned_by_default) {
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_UNOWNED)) {
			value_owned = FALSE;
		} else {
			if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_WEAK)) {
				gboolean _tmp1_ = FALSE;
				if (!can_weak_ref) {
					ValaCodeContext* _tmp2_;
					gboolean _tmp3_;
					gboolean _tmp4_;
					_tmp2_ = self->priv->context;
					_tmp3_ = vala_code_context_get_deprecated (_tmp2_);
					_tmp4_ = _tmp3_;
					_tmp1_ = !_tmp4_;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					ValaSourceLocation _tmp5_;
					ValaSourceReference* _tmp6_;
					ValaSourceReference* _tmp7_;
					_tmp5_ = begin;
					_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
					_tmp7_ = _tmp6_;
					vala_report_warning (_tmp7_, "deprecated syntax, use `unowned` modifier");
					_vala_source_reference_unref0 (_tmp7_);
				}
				value_owned = FALSE;
			}
		}
	} else {
		value_owned = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OWNED);
	}
	is_array = FALSE;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ARRAY)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OF, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (sym);
				_vala_iterable_unref0 (type_arg_list);
				return NULL;
			} else {
				_vala_code_node_unref0 (sym);
				_vala_iterable_unref0 (type_arg_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		is_array = TRUE;
	}
	is_list = FALSE;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_LIST)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OF, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (sym);
				_vala_iterable_unref0 (type_arg_list);
				return NULL;
			} else {
				_vala_code_node_unref0 (sym);
				_vala_iterable_unref0 (type_arg_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		vala_genie_parser_prev (self);
		is_list = TRUE;
	}
	is_dict = FALSE;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DICT)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OF, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (sym);
				_vala_iterable_unref0 (type_arg_list);
				return NULL;
			} else {
				_vala_code_node_unref0 (sym);
				_vala_iterable_unref0 (type_arg_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		vala_genie_parser_prev (self);
		is_dict = TRUE;
	}
	if (!is_dynamic) {
		_tmp9_ = value_owned == owned_by_default;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		_tmp8_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_VOID);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaSourceLocation _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaVoidType* _tmp13_;
		_tmp10_ = begin;
		_tmp11_ = vala_genie_parser_get_src (self, &_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_void_type_new (_tmp12_);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp13_;
		_vala_source_reference_unref0 (_tmp12_);
	} else {
		ValaList* _tmp37_ = NULL;
		ValaList* _tmp38_;
		ValaList* _tmp39_;
		ValaUnresolvedSymbol* _tmp40_;
		ValaSourceLocation _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaUnresolvedType* _tmp44_;
		ValaList* _tmp45_;
		if (is_list) {
			ValaUnresolvedSymbol* sym_parent = NULL;
			ValaSourceLocation _tmp14_;
			ValaSourceReference* _tmp15_;
			ValaSourceReference* _tmp16_;
			ValaUnresolvedSymbol* _tmp17_;
			ValaUnresolvedSymbol* _tmp18_;
			ValaUnresolvedSymbol* _tmp19_;
			ValaSourceLocation _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaSourceReference* _tmp22_;
			ValaUnresolvedSymbol* _tmp23_;
			_tmp14_ = begin;
			_tmp15_ = vala_genie_parser_get_src (self, &_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_unresolved_symbol_new (NULL, "Gee", _tmp16_);
			_tmp18_ = _tmp17_;
			_vala_source_reference_unref0 (_tmp16_);
			sym_parent = _tmp18_;
			_tmp19_ = sym_parent;
			_tmp20_ = begin;
			_tmp21_ = vala_genie_parser_get_src (self, &_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_unresolved_symbol_new (_tmp19_, "ArrayList", _tmp22_);
			_vala_code_node_unref0 (sym);
			sym = _tmp23_;
			_vala_source_reference_unref0 (_tmp22_);
			_vala_code_node_unref0 (sym_parent);
		} else {
			if (is_dict) {
				ValaUnresolvedSymbol* sym_parent = NULL;
				ValaSourceLocation _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				ValaUnresolvedSymbol* _tmp27_;
				ValaUnresolvedSymbol* _tmp28_;
				ValaUnresolvedSymbol* _tmp29_;
				ValaSourceLocation _tmp30_;
				ValaSourceReference* _tmp31_;
				ValaSourceReference* _tmp32_;
				ValaUnresolvedSymbol* _tmp33_;
				_tmp24_ = begin;
				_tmp25_ = vala_genie_parser_get_src (self, &_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_unresolved_symbol_new (NULL, "Gee", _tmp26_);
				_tmp28_ = _tmp27_;
				_vala_source_reference_unref0 (_tmp26_);
				sym_parent = _tmp28_;
				_tmp29_ = sym_parent;
				_tmp30_ = begin;
				_tmp31_ = vala_genie_parser_get_src (self, &_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_unresolved_symbol_new (_tmp29_, "HashMap", _tmp32_);
				_vala_code_node_unref0 (sym);
				sym = _tmp33_;
				_vala_source_reference_unref0 (_tmp32_);
				_vala_code_node_unref0 (sym_parent);
			} else {
				ValaUnresolvedSymbol* _tmp34_ = NULL;
				ValaUnresolvedSymbol* _tmp35_;
				ValaUnresolvedSymbol* _tmp36_;
				_tmp35_ = vala_genie_parser_parse_symbol_name (self, &_inner_error0_);
				_tmp34_ = _tmp35_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (type);
						_vala_code_node_unref0 (sym);
						_vala_iterable_unref0 (type_arg_list);
						return NULL;
					} else {
						_vala_code_node_unref0 (type);
						_vala_code_node_unref0 (sym);
						_vala_iterable_unref0 (type_arg_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp36_ = _tmp34_;
				_tmp34_ = NULL;
				_vala_code_node_unref0 (sym);
				sym = _tmp36_;
				_vala_code_node_unref0 (_tmp34_);
			}
		}
		_tmp38_ = vala_genie_parser_parse_type_argument_list (self, FALSE, &_inner_error0_);
		_tmp37_ = _tmp38_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (sym);
				_vala_iterable_unref0 (type_arg_list);
				return NULL;
			} else {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (sym);
				_vala_iterable_unref0 (type_arg_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp39_ = _tmp37_;
		_tmp37_ = NULL;
		_vala_iterable_unref0 (type_arg_list);
		type_arg_list = _tmp39_;
		_tmp40_ = sym;
		_tmp41_ = begin;
		_tmp42_ = vala_genie_parser_get_src (self, &_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_unresolved_type_new_from_symbol (_tmp40_, _tmp43_);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp44_;
		_vala_source_reference_unref0 (_tmp43_);
		_tmp45_ = type_arg_list;
		if (_tmp45_ != NULL) {
			{
				ValaList* _type_arg_list = NULL;
				ValaList* _tmp46_;
				ValaList* _tmp47_;
				gint _type_arg_size = 0;
				ValaList* _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				gint _type_arg_index = 0;
				_tmp46_ = type_arg_list;
				_tmp47_ = _vala_iterable_ref0 (_tmp46_);
				_type_arg_list = _tmp47_;
				_tmp48_ = _type_arg_list;
				_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
				_tmp50_ = _tmp49_;
				_type_arg_size = _tmp50_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp51_;
					gpointer _tmp52_;
					ValaDataType* _tmp53_;
					ValaDataType* _tmp54_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp51_ = _type_arg_list;
					_tmp52_ = vala_list_get (_tmp51_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp52_;
					_tmp53_ = type;
					_tmp54_ = type_arg;
					vala_data_type_add_type_argument (_tmp53_, _tmp54_);
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
		_vala_iterable_unref0 (_tmp37_);
	}
	while (TRUE) {
		ValaDataType* _tmp55_;
		ValaSourceLocation _tmp56_;
		ValaSourceReference* _tmp57_;
		ValaSourceReference* _tmp58_;
		ValaPointerType* _tmp59_;
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_STAR)) {
			break;
		}
		_tmp55_ = type;
		_tmp56_ = begin;
		_tmp57_ = vala_genie_parser_get_src (self, &_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_type_new (_tmp55_, _tmp58_);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp59_;
		_vala_source_reference_unref0 (_tmp58_);
	}
	_tmp60_ = type;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, VALA_TYPE_POINTER_TYPE)) {
		ValaDataType* _tmp61_;
		_tmp61_ = type;
		vala_data_type_set_nullable (_tmp61_, vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INTERR));
	}
	if (is_array) {
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)) {
			ValaDataType* _tmp62_;
			ValaDataType* _tmp63_;
			ValaSourceLocation _tmp64_;
			ValaSourceReference* _tmp65_;
			ValaSourceReference* _tmp66_;
			ValaArrayType* _tmp67_;
			ValaDataType* _tmp68_;
			_tmp62_ = type;
			vala_data_type_set_value_owned (_tmp62_, TRUE);
			_tmp63_ = type;
			_tmp64_ = begin;
			_tmp65_ = vala_genie_parser_get_src (self, &_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_array_type_new (_tmp63_, 1, _tmp66_);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp67_;
			_vala_source_reference_unref0 (_tmp66_);
			_tmp68_ = type;
			vala_data_type_set_nullable (_tmp68_, vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INTERR));
		} else {
			vala_genie_parser_prev (self);
			while (TRUE) {
				gboolean invalid_array = FALSE;
				gint array_rank = 0;
				ValaDataType* _tmp74_;
				ValaArrayType* array_type = NULL;
				ValaDataType* _tmp75_;
				ValaSourceLocation _tmp76_;
				ValaSourceReference* _tmp77_;
				ValaSourceReference* _tmp78_;
				ValaArrayType* _tmp79_;
				ValaArrayType* _tmp80_;
				ValaArrayType* _tmp81_;
				ValaArrayType* _tmp82_;
				ValaArrayType* _tmp83_;
				ValaDataType* _tmp84_;
				if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)) {
					break;
				}
				invalid_array = FALSE;
				array_rank = 0;
				{
					gboolean _tmp69_ = FALSE;
					_tmp69_ = TRUE;
					while (TRUE) {
						gint _tmp70_;
						gboolean _tmp71_ = FALSE;
						if (!_tmp69_) {
							if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
								break;
							}
						}
						_tmp69_ = FALSE;
						_tmp70_ = array_rank;
						array_rank = _tmp70_ + 1;
						if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_COMMA) {
							_tmp71_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET;
						} else {
							_tmp71_ = FALSE;
						}
						if (_tmp71_) {
							ValaExpression* _tmp72_;
							ValaExpression* _tmp73_;
							_tmp72_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
							_tmp73_ = _tmp72_;
							_vala_code_node_unref0 (_tmp73_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == VALA_PARSE_ERROR) {
									g_propagate_error (error, _inner_error0_);
									_vala_code_node_unref0 (type);
									_vala_code_node_unref0 (sym);
									_vala_iterable_unref0 (type_arg_list);
									return NULL;
								} else {
									_vala_code_node_unref0 (type);
									_vala_code_node_unref0 (sym);
									_vala_iterable_unref0 (type_arg_list);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return NULL;
								}
							}
							invalid_array = TRUE;
						}
					}
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (type);
						_vala_code_node_unref0 (sym);
						_vala_iterable_unref0 (type_arg_list);
						return NULL;
					} else {
						_vala_code_node_unref0 (type);
						_vala_code_node_unref0 (sym);
						_vala_iterable_unref0 (type_arg_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp74_ = type;
				vala_data_type_set_value_owned (_tmp74_, TRUE);
				_tmp75_ = type;
				_tmp76_ = begin;
				_tmp77_ = vala_genie_parser_get_src (self, &_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = vala_array_type_new (_tmp75_, array_rank, _tmp78_);
				_tmp80_ = _tmp79_;
				_vala_source_reference_unref0 (_tmp78_);
				array_type = _tmp80_;
				_tmp81_ = array_type;
				vala_data_type_set_nullable ((ValaDataType*) _tmp81_, vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INTERR));
				_tmp82_ = array_type;
				vala_array_type_set_invalid_syntax (_tmp82_, invalid_array);
				_tmp83_ = array_type;
				_tmp84_ = _vala_code_node_ref0 ((ValaDataType*) _tmp83_);
				_vala_code_node_unref0 (type);
				type = _tmp84_;
				_vala_code_node_unref0 (array_type);
			}
		}
	}
	_tmp85_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp85_, VALA_TYPE_POINTER_TYPE)) {
		value_owned = FALSE;
	}
	_tmp86_ = type;
	vala_data_type_set_is_dynamic (_tmp86_, is_dynamic);
	_tmp87_ = type;
	vala_data_type_set_value_owned (_tmp87_, value_owned);
	result = type;
	_vala_code_node_unref0 (sym);
	_vala_iterable_unref0 (type_arg_list);
	return result;
}

static ValaDataType*
vala_genie_parser_parse_inline_array_type (ValaGenieParser* self,
                                           ValaDataType* type,
                                           GError** error)
{
	ValaDataType* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	ValaDataType* _tmp18_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	if (type != NULL) {
		_tmp1_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaExpression* array_length = NULL;
		ValaArrayType* array_type = NULL;
		ValaSourceLocation _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaArrayType* _tmp8_;
		ValaArrayType* _tmp9_;
		ValaArrayType* _tmp10_;
		ValaExpression* _tmp11_;
		ValaArrayType* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		array_length = NULL;
		if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET) {
			ValaExpression* _tmp2_ = NULL;
			ValaExpression* _tmp3_;
			ValaExpression* _tmp4_;
			_tmp3_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
			_tmp2_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (array_length);
					return NULL;
				} else {
					_vala_code_node_unref0 (array_length);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp4_ = _tmp2_;
			_tmp2_ = NULL;
			_vala_code_node_unref0 (array_length);
			array_length = _tmp4_;
			_vala_code_node_unref0 (_tmp2_);
		}
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (array_length);
				return NULL;
			} else {
				_vala_code_node_unref0 (array_length);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp5_ = begin;
		_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_array_type_new (type, 1, _tmp7_);
		_tmp9_ = _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		array_type = _tmp9_;
		_tmp10_ = array_type;
		vala_array_type_set_inline_allocated (_tmp10_, TRUE);
		_tmp11_ = array_length;
		if (_tmp11_ != NULL) {
			ValaArrayType* _tmp12_;
			ValaArrayType* _tmp13_;
			ValaExpression* _tmp14_;
			_tmp12_ = array_type;
			vala_array_type_set_fixed_length (_tmp12_, TRUE);
			_tmp13_ = array_type;
			_tmp14_ = array_length;
			vala_array_type_set_length (_tmp13_, _tmp14_);
		}
		_tmp15_ = array_type;
		_tmp16_ = vala_data_type_get_value_owned (type);
		_tmp17_ = _tmp16_;
		vala_data_type_set_value_owned ((ValaDataType*) _tmp15_, _tmp17_);
		result = (ValaDataType*) array_type;
		_vala_code_node_unref0 (array_length);
		return result;
	}
	_tmp18_ = _vala_code_node_ref0 (type);
	result = _tmp18_;
	return result;
}

static ValaList*
vala_genie_parser_parse_argument_list (ValaGenieParser* self,
                                       GError** error)
{
	ValaList* result = NULL;
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	list = _tmp1_;
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ValaExpression* _tmp3_ = NULL;
				ValaExpression* _tmp4_;
				ValaArrayList* _tmp5_;
				if (!_tmp2_) {
					if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp2_ = FALSE;
				_tmp4_ = vala_genie_parser_parse_argument (self, &_inner_error0_);
				_tmp3_ = _tmp4_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_iterable_unref0 (list);
						return NULL;
					} else {
						_vala_iterable_unref0 (list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp5_ = list;
				vala_collection_add ((ValaCollection*) _tmp5_, _tmp3_);
				_vala_code_node_unref0 (_tmp3_);
			}
		}
	}
	result = (ValaList*) list;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_argument (ValaGenieParser* self,
                                  GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_REF)) {
		ValaExpression* inner = NULL;
		ValaExpression* _tmp1_;
		ValaExpression* _tmp2_;
		ValaSourceLocation _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaUnaryExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp1_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
		inner = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp2_ = inner;
		_tmp3_ = begin;
		_tmp4_ = vala_genie_parser_get_src (self, &_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_REF, _tmp2_, _tmp5_);
		_tmp7_ = (ValaExpression*) _tmp6_;
		_vala_source_reference_unref0 (_tmp5_);
		result = _tmp7_;
		_vala_code_node_unref0 (inner);
		return result;
	} else {
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OUT)) {
			ValaExpression* inner = NULL;
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			ValaSourceLocation _tmp10_;
			ValaSourceReference* _tmp11_;
			ValaSourceReference* _tmp12_;
			ValaUnaryExpression* _tmp13_;
			ValaExpression* _tmp14_;
			_tmp8_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
			inner = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp9_ = inner;
			_tmp10_ = begin;
			_tmp11_ = vala_genie_parser_get_src (self, &_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_OUT, _tmp9_, _tmp12_);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_vala_source_reference_unref0 (_tmp12_);
			result = _tmp14_;
			_vala_code_node_unref0 (inner);
			return result;
		} else {
			ValaExpression* expr = NULL;
			ValaExpression* _tmp15_;
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp16_;
			ValaMemberAccess* _tmp17_;
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			ValaMemberAccess* _tmp20_;
			_tmp15_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
			expr = _tmp15_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp16_ = expr;
			_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp16_) : NULL);
			ma = _tmp17_;
			_tmp20_ = ma;
			if (_tmp20_ != NULL) {
				ValaMemberAccess* _tmp21_;
				ValaExpression* _tmp22_;
				ValaExpression* _tmp23_;
				_tmp21_ = ma;
				_tmp22_ = vala_member_access_get_inner (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp19_ = _tmp23_ == NULL;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				_tmp18_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON);
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				ValaExpression* _tmp24_ = NULL;
				ValaExpression* _tmp25_;
				ValaExpression* _tmp26_;
				ValaMemberAccess* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				ValaExpression* _tmp30_;
				ValaSourceLocation _tmp31_;
				ValaSourceReference* _tmp32_;
				ValaSourceReference* _tmp33_;
				ValaNamedArgument* _tmp34_;
				ValaExpression* _tmp35_;
				_tmp25_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
				_tmp24_ = _tmp25_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (ma);
						_vala_code_node_unref0 (expr);
						return NULL;
					} else {
						_vala_code_node_unref0 (ma);
						_vala_code_node_unref0 (expr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp26_ = _tmp24_;
				_tmp24_ = NULL;
				_vala_code_node_unref0 (expr);
				expr = _tmp26_;
				_tmp27_ = ma;
				_tmp28_ = vala_member_access_get_member_name (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = expr;
				_tmp31_ = begin;
				_tmp32_ = vala_genie_parser_get_src (self, &_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = vala_named_argument_new (_tmp29_, _tmp30_, _tmp33_);
				_tmp35_ = (ValaExpression*) _tmp34_;
				_vala_source_reference_unref0 (_tmp33_);
				result = _tmp35_;
				_vala_code_node_unref0 (_tmp24_);
				_vala_code_node_unref0 (ma);
				_vala_code_node_unref0 (expr);
				return result;
			} else {
				result = expr;
				_vala_code_node_unref0 (ma);
				return result;
			}
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (expr);
		}
	}
}

static ValaExpression*
vala_genie_parser_parse_primary_expression (ValaGenieParser* self,
                                            GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* expr = NULL;
	gboolean found = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	switch (vala_genie_parser_current (self)) {
		case VALA_GENIE_TOKEN_TYPE_TRUE:
		case VALA_GENIE_TOKEN_TYPE_FALSE:
		case VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL:
		case VALA_GENIE_TOKEN_TYPE_REAL_LITERAL:
		case VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL:
		case VALA_GENIE_TOKEN_TYPE_REGEX_LITERAL:
		case VALA_GENIE_TOKEN_TYPE_STRING_LITERAL:
		case VALA_GENIE_TOKEN_TYPE_TEMPLATE_STRING_LITERAL:
		case VALA_GENIE_TOKEN_TYPE_VERBATIM_STRING_LITERAL:
		case VALA_GENIE_TOKEN_TYPE_NULL:
		{
			ValaExpression* _tmp1_ = NULL;
			ValaExpression* _tmp2_;
			ValaExpression* _tmp3_;
			_tmp2_ = vala_genie_parser_parse_literal (self, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp3_;
			_vala_code_node_unref0 (_tmp1_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSERT:
		{
			ValaExpression* _tmp4_ = NULL;
			ValaExpression* _tmp5_;
			ValaExpression* _tmp6_;
			_tmp5_ = vala_genie_parser_parse_assert_expression (self, &_inner_error0_);
			_tmp4_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp6_ = _tmp4_;
			_tmp4_ = NULL;
			result = _tmp6_;
			_vala_code_node_unref0 (_tmp4_);
			_vala_code_node_unref0 (expr);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_OPEN_BRACE:
		{
			ValaInitializerList* _tmp7_ = NULL;
			ValaInitializerList* _tmp8_;
			ValaInitializerList* _tmp9_;
			_tmp8_ = vala_genie_parser_parse_initializer (self, &_inner_error0_);
			_tmp7_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp9_ = _tmp7_;
			_tmp7_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp9_;
			_vala_code_node_unref0 (_tmp7_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
		{
			ValaExpression* _tmp10_ = NULL;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			_tmp11_ = vala_genie_parser_parse_tuple (self, &_inner_error0_);
			_tmp10_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp12_ = _tmp10_;
			_tmp10_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp12_;
			_vala_code_node_unref0 (_tmp10_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_OPEN_REGEX_LITERAL:
		{
			ValaExpression* _tmp13_ = NULL;
			ValaExpression* _tmp14_;
			ValaExpression* _tmp15_;
			_tmp14_ = vala_genie_parser_parse_regex_literal (self, &_inner_error0_);
			_tmp13_ = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp15_ = _tmp13_;
			_tmp13_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp15_;
			_vala_code_node_unref0 (_tmp13_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_OPEN_TEMPLATE:
		{
			ValaExpression* _tmp16_ = NULL;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			_tmp17_ = vala_genie_parser_parse_template (self, &_inner_error0_);
			_tmp16_ = _tmp17_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp18_ = _tmp16_;
			_tmp16_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp18_;
			_vala_code_node_unref0 (_tmp16_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_THIS:
		{
			ValaExpression* _tmp19_ = NULL;
			ValaExpression* _tmp20_;
			ValaExpression* _tmp21_;
			_tmp20_ = vala_genie_parser_parse_this_access (self, &_inner_error0_);
			_tmp19_ = _tmp20_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp21_ = _tmp19_;
			_tmp19_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp21_;
			_vala_code_node_unref0 (_tmp19_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_SUPER:
		{
			ValaExpression* _tmp22_ = NULL;
			ValaExpression* _tmp23_;
			ValaExpression* _tmp24_;
			_tmp23_ = vala_genie_parser_parse_base_access (self, &_inner_error0_);
			_tmp22_ = _tmp23_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp24_ = _tmp22_;
			_tmp22_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp24_;
			_vala_code_node_unref0 (_tmp22_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_NEW:
		{
			ValaExpression* _tmp25_ = NULL;
			ValaExpression* _tmp26_;
			ValaExpression* _tmp27_;
			_tmp26_ = vala_genie_parser_parse_object_or_array_creation_expression (self, &_inner_error0_);
			_tmp25_ = _tmp26_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp27_ = _tmp25_;
			_tmp25_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp27_;
			_vala_code_node_unref0 (_tmp25_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_PRINT:
		{
			ValaExpression* _tmp28_ = NULL;
			ValaExpression* _tmp29_;
			ValaExpression* _tmp30_;
			_tmp29_ = vala_genie_parser_parse_print_expression (self, &_inner_error0_);
			_tmp28_ = _tmp29_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp30_ = _tmp28_;
			_tmp28_ = NULL;
			result = _tmp30_;
			_vala_code_node_unref0 (_tmp28_);
			_vala_code_node_unref0 (expr);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_SIZEOF:
		{
			ValaExpression* _tmp31_ = NULL;
			ValaExpression* _tmp32_;
			ValaExpression* _tmp33_;
			_tmp32_ = vala_genie_parser_parse_sizeof_expression (self, &_inner_error0_);
			_tmp31_ = _tmp32_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp33_ = _tmp31_;
			_tmp31_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp33_;
			_vala_code_node_unref0 (_tmp31_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_TYPEOF:
		{
			ValaExpression* _tmp34_ = NULL;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			_tmp35_ = vala_genie_parser_parse_typeof_expression (self, &_inner_error0_);
			_tmp34_ = _tmp35_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp36_ = _tmp34_;
			_tmp34_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp36_;
			_vala_code_node_unref0 (_tmp34_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_YIELD:
		{
			ValaExpression* _tmp37_ = NULL;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			_tmp38_ = vala_genie_parser_parse_yield_expression (self, &_inner_error0_);
			_tmp37_ = _tmp38_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp39_ = _tmp37_;
			_tmp37_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp39_;
			_vala_code_node_unref0 (_tmp37_);
			break;
		}
		default:
		{
			ValaExpression* _tmp40_ = NULL;
			ValaExpression* _tmp41_;
			ValaExpression* _tmp42_;
			_tmp41_ = vala_genie_parser_parse_simple_name (self, &_inner_error0_);
			_tmp40_ = _tmp41_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp42_ = _tmp40_;
			_tmp40_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp42_;
			_vala_code_node_unref0 (_tmp40_);
			break;
		}
	}
	found = TRUE;
	while (TRUE) {
		if (!found) {
			break;
		}
		switch (vala_genie_parser_current (self)) {
			case VALA_GENIE_TOKEN_TYPE_DOT:
			{
				ValaExpression* _tmp43_ = NULL;
				ValaSourceLocation _tmp44_;
				ValaExpression* _tmp45_;
				ValaExpression* _tmp46_;
				ValaExpression* _tmp47_;
				_tmp44_ = begin;
				_tmp45_ = expr;
				_tmp46_ = vala_genie_parser_parse_member_access (self, &_tmp44_, _tmp45_, &_inner_error0_);
				_tmp43_ = _tmp46_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (expr);
						return NULL;
					} else {
						_vala_code_node_unref0 (expr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp47_ = _tmp43_;
				_tmp43_ = NULL;
				_vala_code_node_unref0 (expr);
				expr = _tmp47_;
				_vala_code_node_unref0 (_tmp43_);
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_OP_PTR:
			{
				ValaExpression* _tmp48_ = NULL;
				ValaSourceLocation _tmp49_;
				ValaExpression* _tmp50_;
				ValaExpression* _tmp51_;
				ValaExpression* _tmp52_;
				_tmp49_ = begin;
				_tmp50_ = expr;
				_tmp51_ = vala_genie_parser_parse_pointer_member_access (self, &_tmp49_, _tmp50_, &_inner_error0_);
				_tmp48_ = _tmp51_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (expr);
						return NULL;
					} else {
						_vala_code_node_unref0 (expr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp52_ = _tmp48_;
				_tmp48_ = NULL;
				_vala_code_node_unref0 (expr);
				expr = _tmp52_;
				_vala_code_node_unref0 (_tmp48_);
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
			{
				ValaExpression* _tmp53_ = NULL;
				ValaSourceLocation _tmp54_;
				ValaExpression* _tmp55_;
				ValaExpression* _tmp56_;
				ValaExpression* _tmp57_;
				_tmp54_ = begin;
				_tmp55_ = expr;
				_tmp56_ = vala_genie_parser_parse_method_call (self, &_tmp54_, _tmp55_, &_inner_error0_);
				_tmp53_ = _tmp56_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (expr);
						return NULL;
					} else {
						_vala_code_node_unref0 (expr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp57_ = _tmp53_;
				_tmp53_ = NULL;
				_vala_code_node_unref0 (expr);
				expr = _tmp57_;
				_vala_code_node_unref0 (_tmp53_);
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET:
			{
				ValaExpression* _tmp58_ = NULL;
				ValaSourceLocation _tmp59_;
				ValaExpression* _tmp60_;
				ValaExpression* _tmp61_;
				ValaExpression* _tmp62_;
				_tmp59_ = begin;
				_tmp60_ = expr;
				_tmp61_ = vala_genie_parser_parse_element_access (self, &_tmp59_, _tmp60_, &_inner_error0_);
				_tmp58_ = _tmp61_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (expr);
						return NULL;
					} else {
						_vala_code_node_unref0 (expr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp62_ = _tmp58_;
				_tmp58_ = NULL;
				_vala_code_node_unref0 (expr);
				expr = _tmp62_;
				_vala_code_node_unref0 (_tmp58_);
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_OP_INC:
			{
				ValaExpression* _tmp63_ = NULL;
				ValaSourceLocation _tmp64_;
				ValaExpression* _tmp65_;
				ValaExpression* _tmp66_;
				ValaExpression* _tmp67_;
				_tmp64_ = begin;
				_tmp65_ = expr;
				_tmp66_ = vala_genie_parser_parse_post_increment_expression (self, &_tmp64_, _tmp65_, &_inner_error0_);
				_tmp63_ = _tmp66_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (expr);
						return NULL;
					} else {
						_vala_code_node_unref0 (expr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp67_ = _tmp63_;
				_tmp63_ = NULL;
				_vala_code_node_unref0 (expr);
				expr = _tmp67_;
				_vala_code_node_unref0 (_tmp63_);
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_OP_DEC:
			{
				ValaExpression* _tmp68_ = NULL;
				ValaSourceLocation _tmp69_;
				ValaExpression* _tmp70_;
				ValaExpression* _tmp71_;
				ValaExpression* _tmp72_;
				_tmp69_ = begin;
				_tmp70_ = expr;
				_tmp71_ = vala_genie_parser_parse_post_decrement_expression (self, &_tmp69_, _tmp70_, &_inner_error0_);
				_tmp68_ = _tmp71_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (expr);
						return NULL;
					} else {
						_vala_code_node_unref0 (expr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp72_ = _tmp68_;
				_tmp68_ = NULL;
				_vala_code_node_unref0 (expr);
				expr = _tmp72_;
				_vala_code_node_unref0 (_tmp68_);
				break;
			}
			default:
			{
				found = FALSE;
				break;
			}
		}
	}
	result = expr;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_simple_name (ValaGenieParser* self,
                                     GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gchar* id = NULL;
	gchar* _tmp1_;
	ValaList* type_arg_list = NULL;
	ValaList* _tmp2_;
	ValaMemberAccess* expr = NULL;
	const gchar* _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaMemberAccess* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaList* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
	id = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = vala_genie_parser_parse_type_argument_list (self, TRUE, &_inner_error0_);
	type_arg_list = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = id;
	_tmp4_ = begin;
	_tmp5_ = vala_genie_parser_get_src (self, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_member_access_new (NULL, _tmp3_, _tmp6_);
	_tmp8_ = _tmp7_;
	_vala_source_reference_unref0 (_tmp6_);
	expr = _tmp8_;
	_tmp9_ = type_arg_list;
	if (_tmp9_ != NULL) {
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp10_;
			ValaList* _tmp11_;
			gint _type_arg_size = 0;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _type_arg_index = 0;
			_tmp10_ = type_arg_list;
			_tmp11_ = _vala_iterable_ref0 (_tmp10_);
			_type_arg_list = _tmp11_;
			_tmp12_ = _type_arg_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_type_arg_size = _tmp14_;
			_type_arg_index = -1;
			while (TRUE) {
				ValaDataType* type_arg = NULL;
				ValaList* _tmp15_;
				gpointer _tmp16_;
				ValaMemberAccess* _tmp17_;
				ValaDataType* _tmp18_;
				_type_arg_index = _type_arg_index + 1;
				if (!(_type_arg_index < _type_arg_size)) {
					break;
				}
				_tmp15_ = _type_arg_list;
				_tmp16_ = vala_list_get (_tmp15_, _type_arg_index);
				type_arg = (ValaDataType*) _tmp16_;
				_tmp17_ = expr;
				_tmp18_ = type_arg;
				vala_member_access_add_type_argument (_tmp17_, _tmp18_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
	}
	result = (ValaExpression*) expr;
	_vala_iterable_unref0 (type_arg_list);
	_g_free0 (id);
	return result;
}

static ValaExpression*
vala_genie_parser_parse_template (ValaGenieParser* self,
                                  GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaTemplate* template = NULL;
	ValaTemplate* _tmp1_;
	ValaTemplate* _tmp5_;
	ValaSourceLocation _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaSourceReference* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_template_new (NULL);
	template = _tmp1_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_TEMPLATE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (template);
			return NULL;
		} else {
			_vala_code_node_unref0 (template);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaExpression* _tmp2_ = NULL;
		ValaExpression* _tmp3_;
		ValaTemplate* _tmp4_;
		if (!(vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_TEMPLATE)) {
			break;
		}
		_tmp3_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (template);
				return NULL;
			} else {
				_vala_code_node_unref0 (template);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp4_ = template;
		vala_template_add_expression (_tmp4_, _tmp2_);
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COMMA, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (_tmp2_);
				_vala_code_node_unref0 (template);
				return NULL;
			} else {
				_vala_code_node_unref0 (_tmp2_);
				_vala_code_node_unref0 (template);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_vala_code_node_unref0 (_tmp2_);
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_TEMPLATE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (template);
			return NULL;
		} else {
			_vala_code_node_unref0 (template);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = template;
	_tmp6_ = begin;
	_tmp7_ = vala_genie_parser_get_src (self, &_tmp6_);
	_tmp8_ = _tmp7_;
	vala_code_node_set_source_reference ((ValaCodeNode*) _tmp5_, _tmp8_);
	_vala_source_reference_unref0 (_tmp8_);
	result = (ValaExpression*) template;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_tuple (ValaGenieParser* self,
                               GError** error)
{
	ValaExpression* result = NULL;
	ValaArrayList* expr_list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValaArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	ValaArrayList* _tmp19_;
	gpointer _tmp20_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	expr_list = _tmp1_;
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ValaExpression* _tmp3_ = NULL;
				ValaExpression* _tmp4_;
				ValaArrayList* _tmp5_;
				if (!_tmp2_) {
					if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp2_ = FALSE;
				_tmp4_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
				_tmp3_ = _tmp4_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_iterable_unref0 (expr_list);
						return NULL;
					} else {
						_vala_iterable_unref0 (expr_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp5_ = expr_list;
				vala_collection_add ((ValaCollection*) _tmp5_, _tmp3_);
				_vala_code_node_unref0 (_tmp3_);
			}
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_iterable_unref0 (expr_list);
			return NULL;
		} else {
			_vala_iterable_unref0 (expr_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = expr_list;
	_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != 1) {
		ValaTuple* tuple = NULL;
		ValaTuple* _tmp9_;
		_tmp9_ = vala_tuple_new (NULL);
		tuple = _tmp9_;
		{
			ValaArrayList* _expr_list = NULL;
			ValaArrayList* _tmp10_;
			ValaArrayList* _tmp11_;
			gint _expr_size = 0;
			ValaArrayList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _expr_index = 0;
			_tmp10_ = expr_list;
			_tmp11_ = _vala_iterable_ref0 (_tmp10_);
			_expr_list = _tmp11_;
			_tmp12_ = _expr_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_expr_size = _tmp14_;
			_expr_index = -1;
			while (TRUE) {
				ValaExpression* expr = NULL;
				ValaArrayList* _tmp15_;
				gpointer _tmp16_;
				ValaTuple* _tmp17_;
				ValaExpression* _tmp18_;
				_expr_index = _expr_index + 1;
				if (!(_expr_index < _expr_size)) {
					break;
				}
				_tmp15_ = _expr_list;
				_tmp16_ = vala_list_get ((ValaList*) _tmp15_, _expr_index);
				expr = (ValaExpression*) _tmp16_;
				_tmp17_ = tuple;
				_tmp18_ = expr;
				vala_tuple_add_expression (_tmp17_, _tmp18_);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		result = (ValaExpression*) tuple;
		_vala_iterable_unref0 (expr_list);
		return result;
	}
	_tmp19_ = expr_list;
	_tmp20_ = vala_list_get ((ValaList*) _tmp19_, 0);
	result = (ValaExpression*) _tmp20_;
	_vala_iterable_unref0 (expr_list);
	return result;
}

static ValaExpression*
vala_genie_parser_parse_member_access (ValaGenieParser* self,
                                       ValaSourceLocation* begin,
                                       ValaExpression* inner,
                                       GError** error)
{
	ValaExpression* result = NULL;
	gchar* id = NULL;
	gchar* _tmp0_;
	ValaList* type_arg_list = NULL;
	ValaList* _tmp1_;
	ValaMemberAccess* expr = NULL;
	const gchar* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaMemberAccess* _tmp7_;
	ValaList* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DOT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp0_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
	id = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = vala_genie_parser_parse_type_argument_list (self, TRUE, &_inner_error0_);
	type_arg_list = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = id;
	_tmp3_ = *begin;
	_tmp4_ = vala_genie_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_member_access_new (inner, _tmp2_, _tmp5_);
	_tmp7_ = _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	expr = _tmp7_;
	_tmp8_ = type_arg_list;
	if (_tmp8_ != NULL) {
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp9_;
			ValaList* _tmp10_;
			gint _type_arg_size = 0;
			ValaList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _type_arg_index = 0;
			_tmp9_ = type_arg_list;
			_tmp10_ = _vala_iterable_ref0 (_tmp9_);
			_type_arg_list = _tmp10_;
			_tmp11_ = _type_arg_list;
			_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			_type_arg_size = _tmp13_;
			_type_arg_index = -1;
			while (TRUE) {
				ValaDataType* type_arg = NULL;
				ValaList* _tmp14_;
				gpointer _tmp15_;
				ValaMemberAccess* _tmp16_;
				ValaDataType* _tmp17_;
				_type_arg_index = _type_arg_index + 1;
				if (!(_type_arg_index < _type_arg_size)) {
					break;
				}
				_tmp14_ = _type_arg_list;
				_tmp15_ = vala_list_get (_tmp14_, _type_arg_index);
				type_arg = (ValaDataType*) _tmp15_;
				_tmp16_ = expr;
				_tmp17_ = type_arg;
				vala_member_access_add_type_argument (_tmp16_, _tmp17_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
	}
	result = (ValaExpression*) expr;
	_vala_iterable_unref0 (type_arg_list);
	_g_free0 (id);
	return result;
}

static ValaExpression*
vala_genie_parser_parse_pointer_member_access (ValaGenieParser* self,
                                               ValaSourceLocation* begin,
                                               ValaExpression* inner,
                                               GError** error)
{
	ValaExpression* result = NULL;
	gchar* id = NULL;
	gchar* _tmp0_;
	ValaList* type_arg_list = NULL;
	ValaList* _tmp1_;
	ValaMemberAccess* expr = NULL;
	const gchar* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaMemberAccess* _tmp7_;
	ValaList* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OP_PTR, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp0_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
	id = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = vala_genie_parser_parse_type_argument_list (self, TRUE, &_inner_error0_);
	type_arg_list = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = id;
	_tmp3_ = *begin;
	_tmp4_ = vala_genie_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_member_access_new_pointer (inner, _tmp2_, _tmp5_);
	_tmp7_ = _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	expr = _tmp7_;
	_tmp8_ = type_arg_list;
	if (_tmp8_ != NULL) {
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp9_;
			ValaList* _tmp10_;
			gint _type_arg_size = 0;
			ValaList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _type_arg_index = 0;
			_tmp9_ = type_arg_list;
			_tmp10_ = _vala_iterable_ref0 (_tmp9_);
			_type_arg_list = _tmp10_;
			_tmp11_ = _type_arg_list;
			_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			_type_arg_size = _tmp13_;
			_type_arg_index = -1;
			while (TRUE) {
				ValaDataType* type_arg = NULL;
				ValaList* _tmp14_;
				gpointer _tmp15_;
				ValaMemberAccess* _tmp16_;
				ValaDataType* _tmp17_;
				_type_arg_index = _type_arg_index + 1;
				if (!(_type_arg_index < _type_arg_size)) {
					break;
				}
				_tmp14_ = _type_arg_list;
				_tmp15_ = vala_list_get (_tmp14_, _type_arg_index);
				type_arg = (ValaDataType*) _tmp15_;
				_tmp16_ = expr;
				_tmp17_ = type_arg;
				vala_member_access_add_type_argument (_tmp16_, _tmp17_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
	}
	result = (ValaExpression*) expr;
	_vala_iterable_unref0 (type_arg_list);
	_g_free0 (id);
	return result;
}

static ValaList*
vala_genie_parser_parse_print_argument_list (ValaGenieParser* self,
                                             GError** error)
{
	ValaList* result = NULL;
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	gint i = 0;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp2_ = {0};
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	list = _tmp1_;
	i = 0;
	vala_genie_parser_get_location (self, &_tmp2_);
	begin = _tmp2_;
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				ValaExpression* p_expr = NULL;
				ValaExpression* _tmp4_;
				ValaArrayList* _tmp40_;
				ValaExpression* _tmp41_;
				if (!_tmp3_) {
					if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp3_ = FALSE;
				_tmp4_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
				p_expr = _tmp4_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_iterable_unref0 (list);
						return NULL;
					} else {
						_vala_iterable_unref0 (list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				if (i == 0) {
					gint _tmp5_;
					ValaExpression* _tmp6_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
					_tmp6_ = p_expr;
					if (_tmp6_ != NULL) {
						ValaExpression* _tmp7_;
						_tmp7_ = p_expr;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_STRING_LITERAL)) {
							ValaStringLiteral* s_exp = NULL;
							ValaExpression* _tmp8_;
							ValaStringLiteral* _tmp9_;
							gint len = 0;
							ValaStringLiteral* _tmp10_;
							const gchar* _tmp11_;
							const gchar* _tmp12_;
							gint _tmp13_;
							gint _tmp14_;
							_tmp8_ = p_expr;
							_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRING_LITERAL, ValaStringLiteral));
							s_exp = _tmp9_;
							_tmp10_ = s_exp;
							_tmp11_ = vala_string_literal_get_value (_tmp10_);
							_tmp12_ = _tmp11_;
							_tmp13_ = strlen (_tmp12_);
							_tmp14_ = _tmp13_;
							len = _tmp14_;
							if (len > 2) {
								gchar* s = NULL;
								gchar* _tmp15_;
								gchar* st = NULL;
								ValaStringLiteral* _tmp16_;
								const gchar* _tmp17_;
								const gchar* _tmp18_;
								gchar* _tmp19_;
								const gchar* _tmp20_;
								const gchar* _tmp21_;
								gchar* _tmp22_;
								ValaStringLiteral* _tmp23_;
								const gchar* _tmp24_;
								_tmp15_ = g_strdup ("\\n\"");
								s = _tmp15_;
								_tmp16_ = s_exp;
								_tmp17_ = vala_string_literal_get_value (_tmp16_);
								_tmp18_ = _tmp17_;
								_tmp19_ = string_substring (_tmp18_, (glong) 0, (glong) (len - 1));
								st = _tmp19_;
								_tmp20_ = st;
								_tmp21_ = s;
								_tmp22_ = g_strconcat (_tmp20_, _tmp21_, NULL);
								_g_free0 (st);
								st = _tmp22_;
								_tmp23_ = s_exp;
								_tmp24_ = st;
								vala_string_literal_set_value (_tmp23_, _tmp24_);
								_g_free0 (st);
								_g_free0 (s);
							} else {
								gchar* s = NULL;
								gchar* _tmp25_;
								const gchar* _tmp26_;
								ValaSourceLocation _tmp27_;
								ValaSourceReference* _tmp28_;
								ValaSourceReference* _tmp29_;
								ValaStringLiteral* _tmp30_;
								_tmp25_ = g_strdup ("\"\\n\"");
								s = _tmp25_;
								_tmp26_ = s;
								_tmp27_ = begin;
								_tmp28_ = vala_genie_parser_get_src (self, &_tmp27_);
								_tmp29_ = _tmp28_;
								_tmp30_ = vala_string_literal_new (_tmp26_, _tmp29_);
								_vala_code_node_unref0 (p_expr);
								p_expr = (ValaExpression*) _tmp30_;
								_vala_source_reference_unref0 (_tmp29_);
								_g_free0 (s);
							}
							_vala_code_node_unref0 (s_exp);
						} else {
							gchar* s = NULL;
							gchar* _tmp31_;
							ValaStringLiteral* s_exp = NULL;
							const gchar* _tmp32_;
							ValaSourceLocation _tmp33_;
							ValaSourceReference* _tmp34_;
							ValaSourceReference* _tmp35_;
							ValaStringLiteral* _tmp36_;
							ValaStringLiteral* _tmp37_;
							ValaArrayList* _tmp38_;
							ValaStringLiteral* _tmp39_;
							_tmp31_ = g_strdup ("\"%s\\n\"");
							s = _tmp31_;
							_tmp32_ = s;
							_tmp33_ = begin;
							_tmp34_ = vala_genie_parser_get_src (self, &_tmp33_);
							_tmp35_ = _tmp34_;
							_tmp36_ = vala_string_literal_new (_tmp32_, _tmp35_);
							_tmp37_ = _tmp36_;
							_vala_source_reference_unref0 (_tmp35_);
							s_exp = _tmp37_;
							_tmp38_ = list;
							_tmp39_ = s_exp;
							vala_collection_add ((ValaCollection*) _tmp38_, (ValaExpression*) _tmp39_);
							_vala_code_node_unref0 (s_exp);
							_g_free0 (s);
						}
					}
				}
				_tmp40_ = list;
				_tmp41_ = p_expr;
				vala_collection_add ((ValaCollection*) _tmp40_, _tmp41_);
				_vala_code_node_unref0 (p_expr);
			}
		}
	}
	result = (ValaList*) list;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_print_expression (ValaGenieParser* self,
                                          GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gboolean parens = FALSE;
	ValaMemberAccess* expr = NULL;
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaList* arg_list = NULL;
	ValaList* _tmp6_;
	ValaMethodCall* print_expr = NULL;
	ValaMemberAccess* _tmp7_;
	ValaSourceLocation _tmp8_;
	ValaSourceReference* _tmp9_;
	ValaSourceReference* _tmp10_;
	ValaMethodCall* _tmp11_;
	ValaMethodCall* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_PRINT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	parens = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS);
	_tmp1_ = begin;
	_tmp2_ = vala_genie_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_member_access_new (NULL, "print", _tmp3_);
	_tmp5_ = _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	expr = _tmp5_;
	_tmp6_ = vala_genie_parser_parse_print_argument_list (self, &_inner_error0_);
	arg_list = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (expr);
			return NULL;
		} else {
			_vala_code_node_unref0 (expr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (parens) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_iterable_unref0 (arg_list);
				_vala_code_node_unref0 (expr);
				return NULL;
			} else {
				_vala_iterable_unref0 (arg_list);
				_vala_code_node_unref0 (expr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp7_ = expr;
	_tmp8_ = begin;
	_tmp9_ = vala_genie_parser_get_src (self, &_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_method_call_new ((ValaExpression*) _tmp7_, _tmp10_);
	_tmp12_ = _tmp11_;
	_vala_source_reference_unref0 (_tmp10_);
	print_expr = _tmp12_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _arg_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _arg_index = 0;
		_tmp13_ = arg_list;
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_arg_list = _tmp14_;
		_tmp15_ = _arg_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_arg_size = _tmp17_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp18_;
			gpointer _tmp19_;
			ValaMethodCall* _tmp20_;
			ValaExpression* _tmp21_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp18_ = _arg_list;
			_tmp19_ = vala_list_get (_tmp18_, _arg_index);
			arg = (ValaExpression*) _tmp19_;
			_tmp20_ = print_expr;
			_tmp21_ = arg;
			vala_method_call_add_argument (_tmp20_, _tmp21_);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = (ValaExpression*) print_expr;
	_vala_iterable_unref0 (arg_list);
	_vala_code_node_unref0 (expr);
	return result;
}

static ValaExpression*
vala_genie_parser_parse_assert_expression (ValaGenieParser* self,
                                           GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gboolean parens = FALSE;
	ValaMemberAccess* expr = NULL;
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaList* arg_list = NULL;
	ValaList* _tmp6_;
	ValaMethodCall* assert_expr = NULL;
	ValaMemberAccess* _tmp7_;
	ValaSourceLocation _tmp8_;
	ValaSourceReference* _tmp9_;
	ValaSourceReference* _tmp10_;
	ValaMethodCall* _tmp11_;
	ValaMethodCall* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ASSERT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	parens = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS);
	_tmp1_ = begin;
	_tmp2_ = vala_genie_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_member_access_new (NULL, "assert", _tmp3_);
	_tmp5_ = _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	expr = _tmp5_;
	_tmp6_ = vala_genie_parser_parse_argument_list (self, &_inner_error0_);
	arg_list = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (expr);
			return NULL;
		} else {
			_vala_code_node_unref0 (expr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (parens) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_iterable_unref0 (arg_list);
				_vala_code_node_unref0 (expr);
				return NULL;
			} else {
				_vala_iterable_unref0 (arg_list);
				_vala_code_node_unref0 (expr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp7_ = expr;
	_tmp8_ = begin;
	_tmp9_ = vala_genie_parser_get_src (self, &_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_method_call_new ((ValaExpression*) _tmp7_, _tmp10_);
	_tmp12_ = _tmp11_;
	_vala_source_reference_unref0 (_tmp10_);
	assert_expr = _tmp12_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _arg_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _arg_index = 0;
		_tmp13_ = arg_list;
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_arg_list = _tmp14_;
		_tmp15_ = _arg_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_arg_size = _tmp17_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp18_;
			gpointer _tmp19_;
			ValaMethodCall* _tmp20_;
			ValaExpression* _tmp21_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp18_ = _arg_list;
			_tmp19_ = vala_list_get (_tmp18_, _arg_index);
			arg = (ValaExpression*) _tmp19_;
			_tmp20_ = assert_expr;
			_tmp21_ = arg;
			vala_method_call_add_argument (_tmp20_, _tmp21_);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = (ValaExpression*) assert_expr;
	_vala_iterable_unref0 (arg_list);
	_vala_code_node_unref0 (expr);
	return result;
}

static ValaExpression*
vala_genie_parser_parse_method_call (ValaGenieParser* self,
                                     ValaSourceLocation* begin,
                                     ValaExpression* inner,
                                     GError** error)
{
	ValaExpression* result = NULL;
	ValaList* arg_list = NULL;
	ValaList* _tmp0_;
	ValaList* init_list = NULL;
	ValaList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp0_ = vala_genie_parser_parse_argument_list (self, &_inner_error0_);
	arg_list = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_iterable_unref0 (arg_list);
			return NULL;
		} else {
			_vala_iterable_unref0 (arg_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = vala_genie_parser_parse_object_initializer (self, &_inner_error0_);
	init_list = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_iterable_unref0 (arg_list);
			return NULL;
		} else {
			_vala_iterable_unref0 (arg_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = init_list;
	_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ > 0) {
		_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (inner, VALA_TYPE_MEMBER_ACCESS);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaMemberAccess* member = NULL;
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		ValaObjectCreationExpression* expr = NULL;
		ValaMemberAccess* _tmp8_;
		ValaSourceLocation _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaObjectCreationExpression* _tmp12_;
		ValaObjectCreationExpression* _tmp13_;
		ValaObjectCreationExpression* _tmp14_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (inner, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		member = _tmp6_;
		_tmp7_ = member;
		vala_member_access_set_creation_member (_tmp7_, TRUE);
		_tmp8_ = member;
		_tmp9_ = *begin;
		_tmp10_ = vala_genie_parser_get_src (self, &_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_object_creation_expression_new (_tmp8_, _tmp11_);
		_tmp13_ = _tmp12_;
		_vala_source_reference_unref0 (_tmp11_);
		expr = _tmp13_;
		_tmp14_ = expr;
		vala_object_creation_expression_set_struct_creation (_tmp14_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp15_;
			ValaList* _tmp16_;
			gint _arg_size = 0;
			ValaList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _arg_index = 0;
			_tmp15_ = arg_list;
			_tmp16_ = _vala_iterable_ref0 (_tmp15_);
			_arg_list = _tmp16_;
			_tmp17_ = _arg_list;
			_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
			_tmp19_ = _tmp18_;
			_arg_size = _tmp19_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp20_;
				gpointer _tmp21_;
				ValaObjectCreationExpression* _tmp22_;
				ValaExpression* _tmp23_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp20_ = _arg_list;
				_tmp21_ = vala_list_get (_tmp20_, _arg_index);
				arg = (ValaExpression*) _tmp21_;
				_tmp22_ = expr;
				_tmp23_ = arg;
				vala_object_creation_expression_add_argument (_tmp22_, _tmp23_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		{
			ValaList* _initializer_list = NULL;
			ValaList* _tmp24_;
			ValaList* _tmp25_;
			gint _initializer_size = 0;
			ValaList* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _initializer_index = 0;
			_tmp24_ = init_list;
			_tmp25_ = _vala_iterable_ref0 (_tmp24_);
			_initializer_list = _tmp25_;
			_tmp26_ = _initializer_list;
			_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
			_tmp28_ = _tmp27_;
			_initializer_size = _tmp28_;
			_initializer_index = -1;
			while (TRUE) {
				ValaMemberInitializer* initializer = NULL;
				ValaList* _tmp29_;
				gpointer _tmp30_;
				ValaObjectCreationExpression* _tmp31_;
				ValaMemberInitializer* _tmp32_;
				_initializer_index = _initializer_index + 1;
				if (!(_initializer_index < _initializer_size)) {
					break;
				}
				_tmp29_ = _initializer_list;
				_tmp30_ = vala_list_get (_tmp29_, _initializer_index);
				initializer = (ValaMemberInitializer*) _tmp30_;
				_tmp31_ = expr;
				_tmp32_ = initializer;
				vala_object_creation_expression_add_member_initializer (_tmp31_, _tmp32_);
				_vala_code_node_unref0 (initializer);
			}
			_vala_iterable_unref0 (_initializer_list);
		}
		result = (ValaExpression*) expr;
		_vala_code_node_unref0 (member);
		_vala_iterable_unref0 (init_list);
		_vala_iterable_unref0 (arg_list);
		return result;
	} else {
		ValaMethodCall* expr = NULL;
		ValaSourceLocation _tmp33_;
		ValaSourceReference* _tmp34_;
		ValaSourceReference* _tmp35_;
		ValaMethodCall* _tmp36_;
		ValaMethodCall* _tmp37_;
		_tmp33_ = *begin;
		_tmp34_ = vala_genie_parser_get_src (self, &_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_method_call_new (inner, _tmp35_);
		_tmp37_ = _tmp36_;
		_vala_source_reference_unref0 (_tmp35_);
		expr = _tmp37_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp38_;
			ValaList* _tmp39_;
			gint _arg_size = 0;
			ValaList* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gint _arg_index = 0;
			_tmp38_ = arg_list;
			_tmp39_ = _vala_iterable_ref0 (_tmp38_);
			_arg_list = _tmp39_;
			_tmp40_ = _arg_list;
			_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
			_tmp42_ = _tmp41_;
			_arg_size = _tmp42_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp43_;
				gpointer _tmp44_;
				ValaMethodCall* _tmp45_;
				ValaExpression* _tmp46_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp43_ = _arg_list;
				_tmp44_ = vala_list_get (_tmp43_, _arg_index);
				arg = (ValaExpression*) _tmp44_;
				_tmp45_ = expr;
				_tmp46_ = arg;
				vala_method_call_add_argument (_tmp45_, _tmp46_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		result = (ValaExpression*) expr;
		_vala_iterable_unref0 (init_list);
		_vala_iterable_unref0 (arg_list);
		return result;
	}
	_vala_iterable_unref0 (init_list);
	_vala_iterable_unref0 (arg_list);
}

static ValaExpression*
vala_genie_parser_parse_element_access (ValaGenieParser* self,
                                        ValaSourceLocation* begin,
                                        ValaExpression* inner,
                                        GError** error)
{
	ValaExpression* result = NULL;
	ValaList* index_list = NULL;
	ValaList* _tmp0_;
	ValaExpression* stop = NULL;
	gboolean _tmp1_ = FALSE;
	ValaList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	ValaExpression* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp0_ = vala_genie_parser_parse_expression_list (self, &_inner_error0_);
	index_list = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	stop = NULL;
	_tmp2_ = index_list;
	_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 1) {
		_tmp1_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaExpression* _tmp5_ = NULL;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
		_tmp5_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (stop);
				_vala_iterable_unref0 (index_list);
				return NULL;
			} else {
				_vala_code_node_unref0 (stop);
				_vala_iterable_unref0 (index_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp7_ = _tmp5_;
		_tmp5_ = NULL;
		_vala_code_node_unref0 (stop);
		stop = _tmp7_;
		_vala_code_node_unref0 (_tmp5_);
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (stop);
			_vala_iterable_unref0 (index_list);
			return NULL;
		} else {
			_vala_code_node_unref0 (stop);
			_vala_iterable_unref0 (index_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp8_ = stop;
	if (_tmp8_ == NULL) {
		ValaElementAccess* expr = NULL;
		ValaSourceLocation _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaElementAccess* _tmp12_;
		ValaElementAccess* _tmp13_;
		_tmp9_ = *begin;
		_tmp10_ = vala_genie_parser_get_src (self, &_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_element_access_new (inner, _tmp11_);
		_tmp13_ = _tmp12_;
		_vala_source_reference_unref0 (_tmp11_);
		expr = _tmp13_;
		{
			ValaList* _index_list = NULL;
			ValaList* _tmp14_;
			ValaList* _tmp15_;
			gint _index_size = 0;
			ValaList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _index_index = 0;
			_tmp14_ = index_list;
			_tmp15_ = _vala_iterable_ref0 (_tmp14_);
			_index_list = _tmp15_;
			_tmp16_ = _index_list;
			_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			_index_size = _tmp18_;
			_index_index = -1;
			while (TRUE) {
				ValaExpression* index = NULL;
				ValaList* _tmp19_;
				gpointer _tmp20_;
				ValaElementAccess* _tmp21_;
				ValaExpression* _tmp22_;
				_index_index = _index_index + 1;
				if (!(_index_index < _index_size)) {
					break;
				}
				_tmp19_ = _index_list;
				_tmp20_ = vala_list_get (_tmp19_, _index_index);
				index = (ValaExpression*) _tmp20_;
				_tmp21_ = expr;
				_tmp22_ = index;
				vala_element_access_append_index (_tmp21_, _tmp22_);
				_vala_code_node_unref0 (index);
			}
			_vala_iterable_unref0 (_index_list);
		}
		result = (ValaExpression*) expr;
		_vala_code_node_unref0 (stop);
		_vala_iterable_unref0 (index_list);
		return result;
	} else {
		ValaList* _tmp23_;
		gpointer _tmp24_;
		ValaExpression* _tmp25_;
		ValaExpression* _tmp26_;
		ValaSourceLocation _tmp27_;
		ValaSourceReference* _tmp28_;
		ValaSourceReference* _tmp29_;
		ValaSliceExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp23_ = index_list;
		_tmp24_ = vala_list_get (_tmp23_, 0);
		_tmp25_ = (ValaExpression*) _tmp24_;
		_tmp26_ = stop;
		_tmp27_ = *begin;
		_tmp28_ = vala_genie_parser_get_src (self, &_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_slice_expression_new (inner, _tmp25_, _tmp26_, _tmp29_);
		_tmp31_ = (ValaExpression*) _tmp30_;
		_vala_source_reference_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		result = _tmp31_;
		_vala_code_node_unref0 (stop);
		_vala_iterable_unref0 (index_list);
		return result;
	}
	_vala_code_node_unref0 (stop);
	_vala_iterable_unref0 (index_list);
}

static ValaList*
vala_genie_parser_parse_expression_list (ValaGenieParser* self,
                                         GError** error)
{
	ValaList* result = NULL;
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	list = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			ValaExpression* _tmp3_ = NULL;
			ValaExpression* _tmp4_;
			ValaArrayList* _tmp5_;
			if (!_tmp2_) {
				if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
					break;
				}
			}
			_tmp2_ = FALSE;
			_tmp4_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
			_tmp3_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_iterable_unref0 (list);
					return NULL;
				} else {
					_vala_iterable_unref0 (list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp5_ = list;
			vala_collection_add ((ValaCollection*) _tmp5_, _tmp3_);
			_vala_code_node_unref0 (_tmp3_);
		}
	}
	result = (ValaList*) list;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_this_access (ValaGenieParser* self,
                                     GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaMemberAccess* _tmp4_;
	ValaExpression* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_THIS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = begin;
	_tmp2_ = vala_genie_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_member_access_new (NULL, "this", _tmp3_);
	_tmp5_ = (ValaExpression*) _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_base_access (ValaGenieParser* self,
                                     GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaBaseAccess* _tmp4_;
	ValaExpression* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_SUPER, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = begin;
	_tmp2_ = vala_genie_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_base_access_new (_tmp3_);
	_tmp5_ = (ValaExpression*) _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_post_increment_expression (ValaGenieParser* self,
                                                   ValaSourceLocation* begin,
                                                   ValaExpression* inner,
                                                   GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaPostfixExpression* _tmp3_;
	ValaExpression* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OP_INC, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp0_ = *begin;
	_tmp1_ = vala_genie_parser_get_src (self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_postfix_expression_new (inner, TRUE, _tmp2_);
	_tmp4_ = (ValaExpression*) _tmp3_;
	_vala_source_reference_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_post_decrement_expression (ValaGenieParser* self,
                                                   ValaSourceLocation* begin,
                                                   ValaExpression* inner,
                                                   GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaPostfixExpression* _tmp3_;
	ValaExpression* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OP_DEC, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp0_ = *begin;
	_tmp1_ = vala_genie_parser_get_src (self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_postfix_expression_new (inner, FALSE, _tmp2_);
	_tmp4_ = (ValaExpression*) _tmp3_;
	_vala_source_reference_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_object_or_array_creation_expression (ValaGenieParser* self,
                                                             GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaMemberAccess* member = NULL;
	ValaMemberAccess* _tmp15_;
	ValaExpression* expr = NULL;
	ValaSourceLocation _tmp16_;
	ValaMemberAccess* _tmp17_;
	ValaExpression* _tmp18_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_NEW, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ARRAY)) {
		ValaDataType* mtype = NULL;
		ValaDataType* _tmp1_;
		ValaExpression* expr = NULL;
		ValaSourceLocation _tmp2_;
		ValaDataType* _tmp3_;
		ValaExpression* _tmp4_;
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OF, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp1_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
		mtype = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp2_ = begin;
		_tmp3_ = mtype;
		_tmp4_ = vala_genie_parser_parse_array_creation_expression (self, &_tmp2_, _tmp3_, &_inner_error0_);
		expr = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (mtype);
				return NULL;
			} else {
				_vala_code_node_unref0 (mtype);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		result = expr;
		_vala_code_node_unref0 (mtype);
		return result;
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_LIST)) {
		ValaDataType* mtype = NULL;
		ValaDataType* _tmp5_;
		ValaExpression* expr = NULL;
		ValaSourceLocation _tmp6_;
		ValaDataType* _tmp7_;
		ValaExpression* _tmp8_;
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OF, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp5_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
		mtype = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp6_ = begin;
		_tmp7_ = mtype;
		_tmp8_ = vala_genie_parser_parse_list_creation_expression (self, &_tmp6_, _tmp7_, &_inner_error0_);
		expr = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (mtype);
				return NULL;
			} else {
				_vala_code_node_unref0 (mtype);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		result = expr;
		_vala_code_node_unref0 (mtype);
		return result;
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DICT)) {
		ValaDataType* mtype1 = NULL;
		ValaDataType* _tmp9_;
		ValaDataType* mtype2 = NULL;
		ValaDataType* _tmp10_;
		ValaExpression* expr = NULL;
		ValaSourceLocation _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaExpression* _tmp14_;
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OF, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp9_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
		mtype1 = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COMMA, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (mtype1);
				return NULL;
			} else {
				_vala_code_node_unref0 (mtype1);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp10_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
		mtype2 = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (mtype1);
				return NULL;
			} else {
				_vala_code_node_unref0 (mtype1);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp11_ = begin;
		_tmp12_ = mtype1;
		_tmp13_ = mtype2;
		_tmp14_ = vala_genie_parser_parse_dict_creation_expression (self, &_tmp11_, _tmp12_, _tmp13_, &_inner_error0_);
		expr = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (mtype2);
				_vala_code_node_unref0 (mtype1);
				return NULL;
			} else {
				_vala_code_node_unref0 (mtype2);
				_vala_code_node_unref0 (mtype1);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		result = expr;
		_vala_code_node_unref0 (mtype2);
		_vala_code_node_unref0 (mtype1);
		return result;
	}
	_tmp15_ = vala_genie_parser_parse_member_name (self, NULL, &_inner_error0_);
	member = _tmp15_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp16_ = begin;
	_tmp17_ = member;
	_tmp18_ = vala_genie_parser_parse_object_creation_expression (self, &_tmp16_, _tmp17_, &_inner_error0_);
	expr = _tmp18_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (member);
			return NULL;
		} else {
			_vala_code_node_unref0 (member);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = expr;
	_vala_code_node_unref0 (member);
	return result;
}

static ValaExpression*
vala_genie_parser_parse_object_creation_expression (ValaGenieParser* self,
                                                    ValaSourceLocation* begin,
                                                    ValaMemberAccess* member,
                                                    GError** error)
{
	ValaExpression* result = NULL;
	ValaList* arg_list = NULL;
	ValaList* init_list = NULL;
	ValaList* _tmp5_;
	ValaObjectCreationExpression* expr = NULL;
	ValaSourceLocation _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaSourceReference* _tmp8_;
	ValaObjectCreationExpression* _tmp9_;
	ValaObjectCreationExpression* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	g_return_val_if_fail (member != NULL, NULL);
	vala_member_access_set_creation_member (member, TRUE);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)) {
		ValaList* _tmp0_ = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = vala_genie_parser_parse_argument_list (self, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_iterable_unref0 (arg_list);
				return NULL;
			} else {
				_vala_iterable_unref0 (arg_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_vala_iterable_unref0 (arg_list);
		arg_list = _tmp2_;
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_iterable_unref0 (_tmp0_);
				_vala_iterable_unref0 (arg_list);
				return NULL;
			} else {
				_vala_iterable_unref0 (_tmp0_);
				_vala_iterable_unref0 (arg_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_vala_iterable_unref0 (_tmp0_);
	} else {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (arg_list);
		arg_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_genie_parser_parse_object_initializer (self, &_inner_error0_);
	init_list = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_iterable_unref0 (arg_list);
			return NULL;
		} else {
			_vala_iterable_unref0 (arg_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = *begin;
	_tmp7_ = vala_genie_parser_get_src (self, &_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_object_creation_expression_new (member, _tmp8_);
	_tmp10_ = _tmp9_;
	_vala_source_reference_unref0 (_tmp8_);
	expr = _tmp10_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _arg_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _arg_index = 0;
		_tmp11_ = arg_list;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_arg_list = _tmp12_;
		_tmp13_ = _arg_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_arg_size = _tmp15_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			ValaObjectCreationExpression* _tmp18_;
			ValaExpression* _tmp19_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp16_ = _arg_list;
			_tmp17_ = vala_list_get (_tmp16_, _arg_index);
			arg = (ValaExpression*) _tmp17_;
			_tmp18_ = expr;
			_tmp19_ = arg;
			vala_object_creation_expression_add_argument (_tmp18_, _tmp19_);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _initializer_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _initializer_index = 0;
		_tmp20_ = init_list;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_initializer_list = _tmp21_;
		_tmp22_ = _initializer_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_initializer_size = _tmp24_;
		_initializer_index = -1;
		while (TRUE) {
			ValaMemberInitializer* initializer = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaObjectCreationExpression* _tmp27_;
			ValaMemberInitializer* _tmp28_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp25_ = _initializer_list;
			_tmp26_ = vala_list_get (_tmp25_, _initializer_index);
			initializer = (ValaMemberInitializer*) _tmp26_;
			_tmp27_ = expr;
			_tmp28_ = initializer;
			vala_object_creation_expression_add_member_initializer (_tmp27_, _tmp28_);
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = (ValaExpression*) expr;
	_vala_iterable_unref0 (init_list);
	_vala_iterable_unref0 (arg_list);
	return result;
}

static ValaExpression*
vala_genie_parser_parse_array_creation_expression (ValaGenieParser* self,
                                                   ValaSourceLocation* begin,
                                                   ValaDataType* element_type,
                                                   GError** error)
{
	ValaExpression* result = NULL;
	gboolean size_specified = FALSE;
	ValaList* size_specifier_list = NULL;
	gboolean first = FALSE;
	ValaDataType* etype = NULL;
	ValaDataType* _tmp0_;
	gboolean has_bracket = FALSE;
	ValaInitializerList* initializer = NULL;
	ValaArrayCreationExpression* expr = NULL;
	ValaDataType* _tmp24_;
	ValaList* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	ValaInitializerList* _tmp28_;
	ValaSourceLocation _tmp29_;
	ValaSourceReference* _tmp30_;
	ValaSourceReference* _tmp31_;
	ValaArrayCreationExpression* _tmp32_;
	ValaArrayCreationExpression* _tmp33_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	g_return_val_if_fail (element_type != NULL, NULL);
	size_specified = FALSE;
	size_specifier_list = NULL;
	first = TRUE;
	_tmp0_ = vala_data_type_copy (element_type);
	etype = _tmp0_;
	has_bracket = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET);
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			GEqualFunc _tmp11_;
			ValaArrayList* _tmp12_;
			if (!_tmp1_) {
				if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)) {
					break;
				}
			}
			_tmp1_ = FALSE;
			if (!first) {
				ValaDataType* _tmp3_;
				ValaList* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				ValaDataType* _tmp7_;
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				ValaArrayType* _tmp10_;
				if (size_specified) {
					GError* _tmp2_;
					_tmp2_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "size of inner arrays must not be specified in array creation expressio" \
"n");
					_inner_error0_ = _tmp2_;
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (etype);
						_vala_iterable_unref0 (size_specifier_list);
						return NULL;
					} else {
						_vala_code_node_unref0 (etype);
						_vala_iterable_unref0 (size_specifier_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp3_ = etype;
				_tmp4_ = size_specifier_list;
				_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = etype;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = vala_array_type_new (_tmp3_, _tmp6_, _tmp9_);
				_vala_code_node_unref0 (etype);
				etype = (ValaDataType*) _tmp10_;
			} else {
				first = FALSE;
			}
			_tmp11_ = g_direct_equal;
			_tmp12_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp11_);
			_vala_iterable_unref0 (size_specifier_list);
			size_specifier_list = (ValaList*) _tmp12_;
			{
				gboolean _tmp13_ = FALSE;
				_tmp13_ = TRUE;
				while (TRUE) {
					ValaExpression* size = NULL;
					gboolean _tmp14_ = FALSE;
					gboolean _tmp15_ = FALSE;
					ValaList* _tmp19_;
					ValaExpression* _tmp20_;
					if (!_tmp13_) {
						if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
							break;
						}
					}
					_tmp13_ = FALSE;
					size = NULL;
					if (has_bracket) {
						_tmp15_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET;
					} else {
						_tmp15_ = FALSE;
					}
					if (_tmp15_) {
						_tmp14_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_COMMA;
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						ValaExpression* _tmp16_ = NULL;
						ValaExpression* _tmp17_;
						ValaExpression* _tmp18_;
						_tmp17_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
						_tmp16_ = _tmp17_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error0_);
								_vala_code_node_unref0 (size);
								_vala_code_node_unref0 (etype);
								_vala_iterable_unref0 (size_specifier_list);
								return NULL;
							} else {
								_vala_code_node_unref0 (size);
								_vala_code_node_unref0 (etype);
								_vala_iterable_unref0 (size_specifier_list);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
						_tmp18_ = _tmp16_;
						_tmp16_ = NULL;
						_vala_code_node_unref0 (size);
						size = _tmp18_;
						size_specified = TRUE;
						_vala_code_node_unref0 (_tmp16_);
					}
					_tmp19_ = size_specifier_list;
					_tmp20_ = size;
					vala_collection_add ((ValaCollection*) _tmp19_, _tmp20_);
					_vala_code_node_unref0 (size);
				}
			}
			if (has_bracket) {
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (etype);
						_vala_iterable_unref0 (size_specifier_list);
						return NULL;
					} else {
						_vala_code_node_unref0 (etype);
						_vala_iterable_unref0 (size_specifier_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
			}
		}
	}
	initializer = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		ValaInitializerList* _tmp21_ = NULL;
		ValaInitializerList* _tmp22_;
		ValaInitializerList* _tmp23_;
		_tmp22_ = vala_genie_parser_parse_initializer (self, &_inner_error0_);
		_tmp21_ = _tmp22_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (etype);
				_vala_iterable_unref0 (size_specifier_list);
				return NULL;
			} else {
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (etype);
				_vala_iterable_unref0 (size_specifier_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp23_ = _tmp21_;
		_tmp21_ = NULL;
		_vala_code_node_unref0 (initializer);
		initializer = _tmp23_;
		_vala_code_node_unref0 (_tmp21_);
	}
	_tmp24_ = etype;
	_tmp25_ = size_specifier_list;
	_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = initializer;
	_tmp29_ = *begin;
	_tmp30_ = vala_genie_parser_get_src (self, &_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_array_creation_expression_new (_tmp24_, _tmp27_, _tmp28_, _tmp31_);
	_tmp33_ = _tmp32_;
	_vala_source_reference_unref0 (_tmp31_);
	expr = _tmp33_;
	if (size_specified) {
		{
			ValaList* _size_list = NULL;
			ValaList* _tmp34_;
			ValaList* _tmp35_;
			gint _size_size = 0;
			ValaList* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			gint _size_index = 0;
			_tmp34_ = size_specifier_list;
			_tmp35_ = _vala_iterable_ref0 (_tmp34_);
			_size_list = _tmp35_;
			_tmp36_ = _size_list;
			_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
			_tmp38_ = _tmp37_;
			_size_size = _tmp38_;
			_size_index = -1;
			while (TRUE) {
				ValaExpression* size = NULL;
				ValaList* _tmp39_;
				gpointer _tmp40_;
				ValaArrayCreationExpression* _tmp41_;
				ValaExpression* _tmp42_;
				_size_index = _size_index + 1;
				if (!(_size_index < _size_size)) {
					break;
				}
				_tmp39_ = _size_list;
				_tmp40_ = vala_list_get (_tmp39_, _size_index);
				size = (ValaExpression*) _tmp40_;
				_tmp41_ = expr;
				_tmp42_ = size;
				vala_array_creation_expression_append_size (_tmp41_, _tmp42_);
				_vala_code_node_unref0 (size);
			}
			_vala_iterable_unref0 (_size_list);
		}
	}
	result = (ValaExpression*) expr;
	_vala_code_node_unref0 (initializer);
	_vala_code_node_unref0 (etype);
	_vala_iterable_unref0 (size_specifier_list);
	return result;
}

static ValaExpression*
vala_genie_parser_parse_list_creation_expression (ValaGenieParser* self,
                                                  ValaSourceLocation* begin,
                                                  ValaDataType* element_type,
                                                  GError** error)
{
	ValaExpression* result = NULL;
	ValaMemberAccess* list_member = NULL;
	ValaMemberAccess* parent_member = NULL;
	ValaSourceLocation _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaMemberAccess* _tmp3_;
	ValaMemberAccess* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaMemberAccess* _tmp9_;
	ValaMemberAccess* _tmp10_;
	ValaObjectCreationExpression* expr = NULL;
	ValaMemberAccess* _tmp11_;
	ValaSourceLocation _tmp12_;
	ValaSourceReference* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaObjectCreationExpression* _tmp15_;
	ValaObjectCreationExpression* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	g_return_val_if_fail (element_type != NULL, NULL);
	list_member = NULL;
	parent_member = NULL;
	_tmp0_ = *begin;
	_tmp1_ = vala_genie_parser_get_src (self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_member_access_new (NULL, "Gee", _tmp2_);
	_vala_code_node_unref0 (parent_member);
	parent_member = _tmp3_;
	_vala_source_reference_unref0 (_tmp2_);
	_tmp4_ = parent_member;
	_tmp5_ = *begin;
	_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_member_access_new ((ValaExpression*) _tmp4_, "ArrayList", _tmp7_);
	_vala_code_node_unref0 (list_member);
	list_member = _tmp8_;
	_vala_source_reference_unref0 (_tmp7_);
	_tmp9_ = list_member;
	vala_member_access_add_type_argument (_tmp9_, element_type);
	_tmp10_ = list_member;
	vala_member_access_set_creation_member (_tmp10_, TRUE);
	_tmp11_ = list_member;
	_tmp12_ = *begin;
	_tmp13_ = vala_genie_parser_get_src (self, &_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_object_creation_expression_new (_tmp11_, _tmp14_);
	_tmp16_ = _tmp15_;
	_vala_source_reference_unref0 (_tmp14_);
	expr = _tmp16_;
	result = (ValaExpression*) expr;
	_vala_code_node_unref0 (parent_member);
	_vala_code_node_unref0 (list_member);
	return result;
}

static ValaExpression*
vala_genie_parser_parse_dict_creation_expression (ValaGenieParser* self,
                                                  ValaSourceLocation* begin,
                                                  ValaDataType* key_type,
                                                  ValaDataType* value_type,
                                                  GError** error)
{
	ValaExpression* result = NULL;
	ValaMemberAccess* dict_member = NULL;
	ValaMemberAccess* parent_member = NULL;
	ValaSourceLocation _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaMemberAccess* _tmp3_;
	ValaMemberAccess* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaMemberAccess* _tmp9_;
	ValaMemberAccess* _tmp10_;
	ValaMemberAccess* _tmp11_;
	ValaObjectCreationExpression* expr = NULL;
	ValaMemberAccess* _tmp12_;
	ValaSourceLocation _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaObjectCreationExpression* _tmp16_;
	ValaObjectCreationExpression* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	g_return_val_if_fail (key_type != NULL, NULL);
	g_return_val_if_fail (value_type != NULL, NULL);
	dict_member = NULL;
	parent_member = NULL;
	_tmp0_ = *begin;
	_tmp1_ = vala_genie_parser_get_src (self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_member_access_new (NULL, "Gee", _tmp2_);
	_vala_code_node_unref0 (parent_member);
	parent_member = _tmp3_;
	_vala_source_reference_unref0 (_tmp2_);
	_tmp4_ = parent_member;
	_tmp5_ = *begin;
	_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_member_access_new ((ValaExpression*) _tmp4_, "HashMap", _tmp7_);
	_vala_code_node_unref0 (dict_member);
	dict_member = _tmp8_;
	_vala_source_reference_unref0 (_tmp7_);
	_tmp9_ = dict_member;
	vala_member_access_add_type_argument (_tmp9_, key_type);
	_tmp10_ = dict_member;
	vala_member_access_add_type_argument (_tmp10_, value_type);
	_tmp11_ = dict_member;
	vala_member_access_set_creation_member (_tmp11_, TRUE);
	_tmp12_ = dict_member;
	_tmp13_ = *begin;
	_tmp14_ = vala_genie_parser_get_src (self, &_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_object_creation_expression_new (_tmp12_, _tmp15_);
	_tmp17_ = _tmp16_;
	_vala_source_reference_unref0 (_tmp15_);
	expr = _tmp17_;
	result = (ValaExpression*) expr;
	_vala_code_node_unref0 (parent_member);
	_vala_code_node_unref0 (dict_member);
	return result;
}

static ValaList*
vala_genie_parser_parse_object_initializer (ValaGenieParser* self,
                                            GError** error)
{
	ValaList* result = NULL;
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	list = _tmp1_;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACE)) {
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ValaMemberInitializer* _tmp3_ = NULL;
				ValaMemberInitializer* _tmp4_;
				ValaArrayList* _tmp5_;
				if (!_tmp2_) {
					if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp2_ = FALSE;
				_tmp4_ = vala_genie_parser_parse_member_initializer (self, &_inner_error0_);
				_tmp3_ = _tmp4_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_iterable_unref0 (list);
						return NULL;
					} else {
						_vala_iterable_unref0 (list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp5_ = list;
				vala_collection_add ((ValaCollection*) _tmp5_, _tmp3_);
				_vala_code_node_unref0 (_tmp3_);
			}
		}
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_iterable_unref0 (list);
				return NULL;
			} else {
				_vala_iterable_unref0 (list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	result = (ValaList*) list;
	return result;
}

static ValaMemberInitializer*
vala_genie_parser_parse_member_initializer (ValaGenieParser* self,
                                            GError** error)
{
	ValaMemberInitializer* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gchar* id = NULL;
	gchar* _tmp1_;
	ValaExpression* expr = NULL;
	ValaExpression* _tmp2_;
	const gchar* _tmp3_;
	ValaExpression* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaMemberInitializer* _tmp8_;
	ValaMemberInitializer* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
	id = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ASSIGN, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
	expr = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = id;
	_tmp4_ = expr;
	_tmp5_ = begin;
	_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_member_initializer_new (_tmp3_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_vala_source_reference_unref0 (_tmp7_);
	result = _tmp9_;
	_vala_code_node_unref0 (expr);
	_g_free0 (id);
	return result;
}

static ValaExpression*
vala_genie_parser_parse_yield_expression (ValaGenieParser* self,
                                          GError** error)
{
	ValaExpression* result = NULL;
	ValaExpression* expr = NULL;
	ValaExpression* _tmp0_;
	ValaMethodCall* call = NULL;
	ValaExpression* _tmp1_;
	ValaMethodCall* _tmp2_;
	ValaObjectCreationExpression* object_creation = NULL;
	ValaExpression* _tmp3_;
	ValaObjectCreationExpression* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodCall* _tmp6_;
	ValaMethodCall* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_YIELD, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp0_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
	expr = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = expr;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_METHOD_CALL) ? ((ValaMethodCall*) _tmp1_) : NULL);
	call = _tmp2_;
	_tmp3_ = expr;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_OBJECT_CREATION_EXPRESSION) ? ((ValaObjectCreationExpression*) _tmp3_) : NULL);
	object_creation = _tmp4_;
	_tmp6_ = call;
	if (_tmp6_ == NULL) {
		ValaObjectCreationExpression* _tmp7_;
		_tmp7_ = object_creation;
		_tmp5_ = _tmp7_ == NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaExpression* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		GError* _tmp11_;
		_tmp8_ = expr;
		_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp8_);
		_tmp10_ = _tmp9_;
		vala_report_error (_tmp10_, "syntax error, expected method call");
		_tmp11_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected method call");
		_inner_error0_ = _tmp11_;
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (object_creation);
			_vala_code_node_unref0 (call);
			_vala_code_node_unref0 (expr);
			return NULL;
		} else {
			_vala_code_node_unref0 (object_creation);
			_vala_code_node_unref0 (call);
			_vala_code_node_unref0 (expr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp12_ = call;
	if (_tmp12_ != NULL) {
		ValaMethodCall* _tmp13_;
		_tmp13_ = call;
		vala_method_call_set_is_yield_expression (_tmp13_, TRUE);
	} else {
		ValaObjectCreationExpression* _tmp14_;
		_tmp14_ = object_creation;
		if (_tmp14_ != NULL) {
			ValaObjectCreationExpression* _tmp15_;
			_tmp15_ = object_creation;
			vala_object_creation_expression_set_is_yield_expression (_tmp15_, TRUE);
		}
	}
	result = expr;
	_vala_code_node_unref0 (object_creation);
	_vala_code_node_unref0 (call);
	return result;
}

static ValaExpression*
vala_genie_parser_parse_sizeof_expression (ValaGenieParser* self,
                                           GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaDataType* type = NULL;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSizeofExpression* _tmp6_;
	ValaExpression* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_SIZEOF, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
	type = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = type;
	_tmp3_ = begin;
	_tmp4_ = vala_genie_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_sizeof_expression_new (_tmp2_, _tmp5_);
	_tmp7_ = (ValaExpression*) _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	result = _tmp7_;
	_vala_code_node_unref0 (type);
	return result;
}

static ValaExpression*
vala_genie_parser_parse_typeof_expression (ValaGenieParser* self,
                                           GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaDataType* type = NULL;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaTypeofExpression* _tmp6_;
	ValaExpression* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_TYPEOF, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
	type = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = type;
	_tmp3_ = begin;
	_tmp4_ = vala_genie_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_typeof_expression_new (_tmp2_, _tmp5_);
	_tmp7_ = (ValaExpression*) _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	result = _tmp7_;
	_vala_code_node_unref0 (type);
	return result;
}

static ValaUnaryOperator
vala_genie_parser_get_unary_operator (ValaGenieParser* self,
                                      ValaGenieTokenType token_type)
{
	ValaUnaryOperator result = 0;
	g_return_val_if_fail (self != NULL, 0);
	switch (token_type) {
		case VALA_GENIE_TOKEN_TYPE_PLUS:
		{
			result = VALA_UNARY_OPERATOR_PLUS;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_MINUS:
		{
			result = VALA_UNARY_OPERATOR_MINUS;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_NEG:
		{
			result = VALA_UNARY_OPERATOR_LOGICAL_NEGATION;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_TILDE:
		{
			result = VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_INC:
		{
			result = VALA_UNARY_OPERATOR_INCREMENT;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_DEC:
		{
			result = VALA_UNARY_OPERATOR_DECREMENT;
			return result;
		}
		default:
		{
			result = VALA_UNARY_OPERATOR_NONE;
			return result;
		}
	}
}

static ValaExpression*
vala_genie_parser_parse_unary_expression (ValaGenieParser* self,
                                          GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaUnaryOperator operator = 0;
	ValaUnaryOperator _tmp1_;
	ValaExpression* expr = NULL;
	ValaExpression* _tmp48_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	operator = vala_genie_parser_get_unary_operator (self, vala_genie_parser_current (self));
	_tmp1_ = operator;
	if (_tmp1_ != VALA_UNARY_OPERATOR_NONE) {
		ValaExpression* op = NULL;
		ValaExpression* _tmp2_;
		ValaUnaryOperator _tmp3_;
		ValaExpression* _tmp4_;
		ValaSourceLocation _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaUnaryExpression* _tmp8_;
		ValaExpression* _tmp9_;
		vala_genie_parser_next (self);
		_tmp2_ = vala_genie_parser_parse_unary_expression (self, &_inner_error0_);
		op = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp3_ = operator;
		_tmp4_ = op;
		_tmp5_ = begin;
		_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_unary_expression_new (_tmp3_, _tmp4_, _tmp7_);
		_tmp9_ = (ValaExpression*) _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		result = _tmp9_;
		_vala_code_node_unref0 (op);
		return result;
	}
	switch (vala_genie_parser_current (self)) {
		case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
		{
			ValaSourceLocation _tmp33_;
			vala_genie_parser_next (self);
			switch (vala_genie_parser_current (self)) {
				case VALA_GENIE_TOKEN_TYPE_OWNED:
				{
					vala_genie_parser_next (self);
					if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS)) {
						ValaExpression* op = NULL;
						ValaExpression* _tmp10_;
						ValaExpression* _tmp11_;
						ValaSourceLocation _tmp12_;
						ValaSourceReference* _tmp13_;
						ValaSourceReference* _tmp14_;
						ValaReferenceTransferExpression* _tmp15_;
						ValaExpression* _tmp16_;
						_tmp10_ = vala_genie_parser_parse_unary_expression (self, &_inner_error0_);
						op = _tmp10_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error0_);
								return NULL;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
						_tmp11_ = op;
						_tmp12_ = begin;
						_tmp13_ = vala_genie_parser_get_src (self, &_tmp12_);
						_tmp14_ = _tmp13_;
						_tmp15_ = vala_reference_transfer_expression_new (_tmp11_, _tmp14_);
						_tmp16_ = (ValaExpression*) _tmp15_;
						_vala_source_reference_unref0 (_tmp14_);
						result = _tmp16_;
						_vala_code_node_unref0 (op);
						return result;
					}
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_VOID:
				case VALA_GENIE_TOKEN_TYPE_DYNAMIC:
				case VALA_GENIE_TOKEN_TYPE_IDENTIFIER:
				case VALA_GENIE_TOKEN_TYPE_ARRAY:
				case VALA_GENIE_TOKEN_TYPE_LIST:
				case VALA_GENIE_TOKEN_TYPE_DICT:
				{
					ValaDataType* type = NULL;
					ValaDataType* _tmp17_;
					_tmp17_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
					type = _tmp17_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							return NULL;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS)) {
						switch (vala_genie_parser_current (self)) {
							case VALA_GENIE_TOKEN_TYPE_OP_NEG:
							case VALA_GENIE_TOKEN_TYPE_TILDE:
							case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
							case VALA_GENIE_TOKEN_TYPE_TRUE:
							case VALA_GENIE_TOKEN_TYPE_FALSE:
							case VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL:
							case VALA_GENIE_TOKEN_TYPE_REAL_LITERAL:
							case VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL:
							case VALA_GENIE_TOKEN_TYPE_REGEX_LITERAL:
							case VALA_GENIE_TOKEN_TYPE_STRING_LITERAL:
							case VALA_GENIE_TOKEN_TYPE_TEMPLATE_STRING_LITERAL:
							case VALA_GENIE_TOKEN_TYPE_VERBATIM_STRING_LITERAL:
							case VALA_GENIE_TOKEN_TYPE_NULL:
							case VALA_GENIE_TOKEN_TYPE_THIS:
							case VALA_GENIE_TOKEN_TYPE_SUPER:
							case VALA_GENIE_TOKEN_TYPE_NEW:
							case VALA_GENIE_TOKEN_TYPE_SIZEOF:
							case VALA_GENIE_TOKEN_TYPE_TYPEOF:
							case VALA_GENIE_TOKEN_TYPE_IDENTIFIER:
							case VALA_GENIE_TOKEN_TYPE_PARAMS:
							case VALA_GENIE_TOKEN_TYPE_YIELD:
							{
								ValaExpression* inner = NULL;
								ValaExpression* _tmp18_;
								ValaExpression* _tmp19_;
								ValaDataType* _tmp20_;
								ValaSourceLocation _tmp21_;
								ValaSourceReference* _tmp22_;
								ValaSourceReference* _tmp23_;
								ValaCastExpression* _tmp24_;
								ValaExpression* _tmp25_;
								_tmp18_ = vala_genie_parser_parse_unary_expression (self, &_inner_error0_);
								inner = _tmp18_;
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (_inner_error0_->domain == VALA_PARSE_ERROR) {
										g_propagate_error (error, _inner_error0_);
										_vala_code_node_unref0 (type);
										return NULL;
									} else {
										_vala_code_node_unref0 (type);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return NULL;
									}
								}
								_tmp19_ = inner;
								_tmp20_ = type;
								_tmp21_ = begin;
								_tmp22_ = vala_genie_parser_get_src (self, &_tmp21_);
								_tmp23_ = _tmp22_;
								_tmp24_ = vala_cast_expression_new (_tmp19_, _tmp20_, _tmp23_);
								_tmp25_ = (ValaExpression*) _tmp24_;
								_vala_source_reference_unref0 (_tmp23_);
								result = _tmp25_;
								_vala_code_node_unref0 (inner);
								_vala_code_node_unref0 (type);
								return result;
							}
							default:
							{
								break;
							}
						}
					}
					_vala_code_node_unref0 (type);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_OP_NEG:
				{
					vala_genie_parser_next (self);
					if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS)) {
						ValaExpression* inner = NULL;
						ValaExpression* _tmp26_;
						ValaExpression* _tmp27_;
						ValaSourceLocation _tmp28_;
						ValaSourceReference* _tmp29_;
						ValaSourceReference* _tmp30_;
						ValaCastExpression* _tmp31_;
						ValaExpression* _tmp32_;
						_tmp26_ = vala_genie_parser_parse_unary_expression (self, &_inner_error0_);
						inner = _tmp26_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error0_);
								return NULL;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
						_tmp27_ = inner;
						_tmp28_ = begin;
						_tmp29_ = vala_genie_parser_get_src (self, &_tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = vala_cast_expression_new_non_null (_tmp27_, _tmp30_);
						_tmp32_ = (ValaExpression*) _tmp31_;
						_vala_source_reference_unref0 (_tmp30_);
						result = _tmp32_;
						_vala_code_node_unref0 (inner);
						return result;
					}
					break;
				}
				default:
				{
					break;
				}
			}
			_tmp33_ = begin;
			vala_genie_parser_rollback (self, &_tmp33_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_STAR:
		{
			ValaExpression* op = NULL;
			ValaExpression* _tmp34_;
			ValaExpression* _tmp35_;
			ValaSourceLocation _tmp36_;
			ValaSourceReference* _tmp37_;
			ValaSourceReference* _tmp38_;
			ValaPointerIndirection* _tmp39_;
			ValaExpression* _tmp40_;
			vala_genie_parser_next (self);
			_tmp34_ = vala_genie_parser_parse_unary_expression (self, &_inner_error0_);
			op = _tmp34_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp35_ = op;
			_tmp36_ = begin;
			_tmp37_ = vala_genie_parser_get_src (self, &_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_pointer_indirection_new (_tmp35_, _tmp38_);
			_tmp40_ = (ValaExpression*) _tmp39_;
			_vala_source_reference_unref0 (_tmp38_);
			result = _tmp40_;
			_vala_code_node_unref0 (op);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_BITWISE_AND:
		{
			ValaExpression* op = NULL;
			ValaExpression* _tmp41_;
			ValaExpression* _tmp42_;
			ValaSourceLocation _tmp43_;
			ValaSourceReference* _tmp44_;
			ValaSourceReference* _tmp45_;
			ValaAddressofExpression* _tmp46_;
			ValaExpression* _tmp47_;
			vala_genie_parser_next (self);
			_tmp41_ = vala_genie_parser_parse_unary_expression (self, &_inner_error0_);
			op = _tmp41_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp42_ = op;
			_tmp43_ = begin;
			_tmp44_ = vala_genie_parser_get_src (self, &_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_addressof_expression_new (_tmp42_, _tmp45_);
			_tmp47_ = (ValaExpression*) _tmp46_;
			_vala_source_reference_unref0 (_tmp45_);
			result = _tmp47_;
			_vala_code_node_unref0 (op);
			return result;
		}
		default:
		{
			break;
		}
	}
	_tmp48_ = vala_genie_parser_parse_primary_expression (self, &_inner_error0_);
	expr = _tmp48_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = expr;
	return result;
}

static ValaBinaryOperator
vala_genie_parser_get_binary_operator (ValaGenieParser* self,
                                       ValaGenieTokenType token_type)
{
	ValaBinaryOperator result = 0;
	g_return_val_if_fail (self != NULL, 0);
	switch (token_type) {
		case VALA_GENIE_TOKEN_TYPE_STAR:
		{
			result = VALA_BINARY_OPERATOR_MUL;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_DIV:
		{
			result = VALA_BINARY_OPERATOR_DIV;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_PERCENT:
		{
			result = VALA_BINARY_OPERATOR_MOD;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_PLUS:
		{
			result = VALA_BINARY_OPERATOR_PLUS;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_MINUS:
		{
			result = VALA_BINARY_OPERATOR_MINUS;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_LT:
		{
			result = VALA_BINARY_OPERATOR_LESS_THAN;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_GT:
		{
			result = VALA_BINARY_OPERATOR_GREATER_THAN;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_LE:
		{
			result = VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_GE:
		{
			result = VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_EQ:
		{
			result = VALA_BINARY_OPERATOR_EQUALITY;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_IS:
		{
			vala_genie_parser_next (self);
			if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_OP_NEG) {
				vala_genie_parser_prev (self);
				result = VALA_BINARY_OPERATOR_INEQUALITY;
				return result;
			}
			vala_genie_parser_prev (self);
			result = VALA_BINARY_OPERATOR_EQUALITY;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_NE:
		{
			result = VALA_BINARY_OPERATOR_INEQUALITY;
			return result;
		}
		default:
		{
			result = VALA_BINARY_OPERATOR_NONE;
			return result;
		}
	}
}

static ValaExpression*
vala_genie_parser_parse_multiplicative_expression (ValaGenieParser* self,
                                                   GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	gboolean found = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_genie_parser_parse_unary_expression (self, &_inner_error0_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	found = TRUE;
	while (TRUE) {
		ValaBinaryOperator operator = 0;
		ValaBinaryOperator _tmp2_;
		if (!found) {
			break;
		}
		operator = vala_genie_parser_get_binary_operator (self, vala_genie_parser_current (self));
		_tmp2_ = operator;
		switch (_tmp2_) {
			case VALA_BINARY_OPERATOR_MUL:
			case VALA_BINARY_OPERATOR_DIV:
			case VALA_BINARY_OPERATOR_MOD:
			{
				ValaExpression* right = NULL;
				ValaExpression* _tmp3_;
				ValaBinaryOperator _tmp4_;
				ValaExpression* _tmp5_;
				ValaExpression* _tmp6_;
				ValaSourceLocation _tmp7_;
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				ValaBinaryExpression* _tmp10_;
				vala_genie_parser_next (self);
				_tmp3_ = vala_genie_parser_parse_unary_expression (self, &_inner_error0_);
				right = _tmp3_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (left);
						return NULL;
					} else {
						_vala_code_node_unref0 (left);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp4_ = operator;
				_tmp5_ = left;
				_tmp6_ = right;
				_tmp7_ = begin;
				_tmp8_ = vala_genie_parser_get_src (self, &_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = vala_binary_expression_new (_tmp4_, _tmp5_, _tmp6_, _tmp9_);
				_vala_code_node_unref0 (left);
				left = (ValaExpression*) _tmp10_;
				_vala_source_reference_unref0 (_tmp9_);
				_vala_code_node_unref0 (right);
				break;
			}
			default:
			{
				found = FALSE;
				break;
			}
		}
	}
	result = left;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_additive_expression (ValaGenieParser* self,
                                             GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	gboolean found = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_genie_parser_parse_multiplicative_expression (self, &_inner_error0_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	found = TRUE;
	while (TRUE) {
		ValaBinaryOperator operator = 0;
		ValaBinaryOperator _tmp2_;
		if (!found) {
			break;
		}
		operator = vala_genie_parser_get_binary_operator (self, vala_genie_parser_current (self));
		_tmp2_ = operator;
		switch (_tmp2_) {
			case VALA_BINARY_OPERATOR_PLUS:
			case VALA_BINARY_OPERATOR_MINUS:
			{
				ValaExpression* right = NULL;
				ValaExpression* _tmp3_;
				ValaBinaryOperator _tmp4_;
				ValaExpression* _tmp5_;
				ValaExpression* _tmp6_;
				ValaSourceLocation _tmp7_;
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				ValaBinaryExpression* _tmp10_;
				vala_genie_parser_next (self);
				_tmp3_ = vala_genie_parser_parse_multiplicative_expression (self, &_inner_error0_);
				right = _tmp3_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (left);
						return NULL;
					} else {
						_vala_code_node_unref0 (left);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp4_ = operator;
				_tmp5_ = left;
				_tmp6_ = right;
				_tmp7_ = begin;
				_tmp8_ = vala_genie_parser_get_src (self, &_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = vala_binary_expression_new (_tmp4_, _tmp5_, _tmp6_, _tmp9_);
				_vala_code_node_unref0 (left);
				left = (ValaExpression*) _tmp10_;
				_vala_source_reference_unref0 (_tmp9_);
				_vala_code_node_unref0 (right);
				break;
			}
			default:
			{
				found = FALSE;
				break;
			}
		}
	}
	result = left;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_shift_expression (ValaGenieParser* self,
                                          GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	gboolean found = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_genie_parser_parse_additive_expression (self, &_inner_error0_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	found = TRUE;
	while (TRUE) {
		if (!found) {
			break;
		}
		switch (vala_genie_parser_current (self)) {
			case VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT:
			{
				ValaExpression* right = NULL;
				ValaExpression* _tmp2_;
				ValaExpression* _tmp3_;
				ValaExpression* _tmp4_;
				ValaSourceLocation _tmp5_;
				ValaSourceReference* _tmp6_;
				ValaSourceReference* _tmp7_;
				ValaBinaryExpression* _tmp8_;
				vala_genie_parser_next (self);
				_tmp2_ = vala_genie_parser_parse_additive_expression (self, &_inner_error0_);
				right = _tmp2_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (left);
						return NULL;
					} else {
						_vala_code_node_unref0 (left);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp3_ = left;
				_tmp4_ = right;
				_tmp5_ = begin;
				_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_SHIFT_LEFT, _tmp3_, _tmp4_, _tmp7_);
				_vala_code_node_unref0 (left);
				left = (ValaExpression*) _tmp8_;
				_vala_source_reference_unref0 (_tmp7_);
				_vala_code_node_unref0 (right);
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_OP_GT:
			{
				gchar* first_gt_pos = NULL;
				ValaGenieParserTokenInfo* _tmp9_;
				gint _tmp9__length1;
				ValaGenieParserTokenInfo _tmp10_;
				ValaSourceLocation _tmp11_;
				gchar* _tmp12_;
				gboolean _tmp13_ = FALSE;
				_tmp9_ = self->priv->tokens;
				_tmp9__length1 = self->priv->tokens_length1;
				_tmp10_ = _tmp9_[self->priv->index];
				_tmp11_ = _tmp10_.begin;
				_tmp12_ = _tmp11_.pos;
				first_gt_pos = _tmp12_;
				vala_genie_parser_next (self);
				if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_OP_GT) {
					ValaGenieParserTokenInfo* _tmp14_;
					gint _tmp14__length1;
					ValaGenieParserTokenInfo _tmp15_;
					ValaSourceLocation _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp14_ = self->priv->tokens;
					_tmp14__length1 = self->priv->tokens_length1;
					_tmp15_ = _tmp14_[self->priv->index];
					_tmp16_ = _tmp15_.begin;
					_tmp17_ = _tmp16_.pos;
					_tmp18_ = first_gt_pos;
					_tmp13_ = _tmp17_ == (_tmp18_ + 1);
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					ValaExpression* right = NULL;
					ValaExpression* _tmp19_;
					ValaExpression* _tmp20_;
					ValaExpression* _tmp21_;
					ValaSourceLocation _tmp22_;
					ValaSourceReference* _tmp23_;
					ValaSourceReference* _tmp24_;
					ValaBinaryExpression* _tmp25_;
					vala_genie_parser_next (self);
					_tmp19_ = vala_genie_parser_parse_additive_expression (self, &_inner_error0_);
					right = _tmp19_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_vala_code_node_unref0 (left);
							return NULL;
						} else {
							_vala_code_node_unref0 (left);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp20_ = left;
					_tmp21_ = right;
					_tmp22_ = begin;
					_tmp23_ = vala_genie_parser_get_src (self, &_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_SHIFT_RIGHT, _tmp20_, _tmp21_, _tmp24_);
					_vala_code_node_unref0 (left);
					left = (ValaExpression*) _tmp25_;
					_vala_source_reference_unref0 (_tmp24_);
					_vala_code_node_unref0 (right);
				} else {
					vala_genie_parser_prev (self);
					found = FALSE;
				}
				break;
			}
			default:
			{
				found = FALSE;
				break;
			}
		}
	}
	result = left;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_relational_expression (ValaGenieParser* self,
                                               GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	gboolean found = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_genie_parser_parse_shift_expression (self, &_inner_error0_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	found = TRUE;
	while (TRUE) {
		ValaBinaryOperator operator = 0;
		ValaBinaryOperator _tmp2_;
		if (!found) {
			break;
		}
		operator = vala_genie_parser_get_binary_operator (self, vala_genie_parser_current (self));
		_tmp2_ = operator;
		switch (_tmp2_) {
			case VALA_BINARY_OPERATOR_LESS_THAN:
			case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
			case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
			{
				ValaExpression* right = NULL;
				ValaExpression* _tmp3_;
				ValaBinaryOperator _tmp4_;
				ValaExpression* _tmp5_;
				ValaExpression* _tmp6_;
				ValaSourceLocation _tmp7_;
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				ValaBinaryExpression* _tmp10_;
				vala_genie_parser_next (self);
				_tmp3_ = vala_genie_parser_parse_shift_expression (self, &_inner_error0_);
				right = _tmp3_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (left);
						return NULL;
					} else {
						_vala_code_node_unref0 (left);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp4_ = operator;
				_tmp5_ = left;
				_tmp6_ = right;
				_tmp7_ = begin;
				_tmp8_ = vala_genie_parser_get_src (self, &_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = vala_binary_expression_new (_tmp4_, _tmp5_, _tmp6_, _tmp9_);
				_vala_code_node_unref0 (left);
				left = (ValaExpression*) _tmp10_;
				_vala_source_reference_unref0 (_tmp9_);
				_vala_code_node_unref0 (right);
				break;
			}
			case VALA_BINARY_OPERATOR_GREATER_THAN:
			{
				gboolean _tmp11_ = FALSE;
				vala_genie_parser_next (self);
				if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_OP_GT) {
					_tmp11_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_OP_GE;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					ValaExpression* right = NULL;
					ValaExpression* _tmp12_;
					ValaBinaryOperator _tmp13_;
					ValaExpression* _tmp14_;
					ValaExpression* _tmp15_;
					ValaSourceLocation _tmp16_;
					ValaSourceReference* _tmp17_;
					ValaSourceReference* _tmp18_;
					ValaBinaryExpression* _tmp19_;
					_tmp12_ = vala_genie_parser_parse_shift_expression (self, &_inner_error0_);
					right = _tmp12_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_vala_code_node_unref0 (left);
							return NULL;
						} else {
							_vala_code_node_unref0 (left);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp13_ = operator;
					_tmp14_ = left;
					_tmp15_ = right;
					_tmp16_ = begin;
					_tmp17_ = vala_genie_parser_get_src (self, &_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = vala_binary_expression_new (_tmp13_, _tmp14_, _tmp15_, _tmp18_);
					_vala_code_node_unref0 (left);
					left = (ValaExpression*) _tmp19_;
					_vala_source_reference_unref0 (_tmp18_);
					_vala_code_node_unref0 (right);
				} else {
					vala_genie_parser_prev (self);
					found = FALSE;
				}
				break;
			}
			default:
			{
				switch (vala_genie_parser_current (self)) {
					case VALA_GENIE_TOKEN_TYPE_ISA:
					{
						ValaDataType* type = NULL;
						ValaDataType* _tmp20_;
						ValaExpression* _tmp21_;
						ValaDataType* _tmp22_;
						ValaSourceLocation _tmp23_;
						ValaSourceReference* _tmp24_;
						ValaSourceReference* _tmp25_;
						ValaTypeCheck* _tmp26_;
						vala_genie_parser_next (self);
						_tmp20_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
						type = _tmp20_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error0_);
								_vala_code_node_unref0 (left);
								return NULL;
							} else {
								_vala_code_node_unref0 (left);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
						_tmp21_ = left;
						_tmp22_ = type;
						_tmp23_ = begin;
						_tmp24_ = vala_genie_parser_get_src (self, &_tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = vala_typecheck_new (_tmp21_, _tmp22_, _tmp25_);
						_vala_code_node_unref0 (left);
						left = (ValaExpression*) _tmp26_;
						_vala_source_reference_unref0 (_tmp25_);
						_vala_code_node_unref0 (type);
						break;
					}
					case VALA_GENIE_TOKEN_TYPE_AS:
					{
						ValaDataType* type = NULL;
						ValaDataType* _tmp27_;
						ValaExpression* _tmp28_;
						ValaDataType* _tmp29_;
						ValaSourceLocation _tmp30_;
						ValaSourceReference* _tmp31_;
						ValaSourceReference* _tmp32_;
						ValaCastExpression* _tmp33_;
						vala_genie_parser_next (self);
						_tmp27_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
						type = _tmp27_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error0_);
								_vala_code_node_unref0 (left);
								return NULL;
							} else {
								_vala_code_node_unref0 (left);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
						_tmp28_ = left;
						_tmp29_ = type;
						_tmp30_ = begin;
						_tmp31_ = vala_genie_parser_get_src (self, &_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = vala_cast_expression_new_silent (_tmp28_, _tmp29_, _tmp32_);
						_vala_code_node_unref0 (left);
						left = (ValaExpression*) _tmp33_;
						_vala_source_reference_unref0 (_tmp32_);
						_vala_code_node_unref0 (type);
						break;
					}
					default:
					{
						found = FALSE;
						break;
					}
				}
				break;
			}
		}
	}
	result = left;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_equality_expression (ValaGenieParser* self,
                                             GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	gboolean found = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_genie_parser_parse_relational_expression (self, &_inner_error0_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	found = TRUE;
	while (TRUE) {
		ValaBinaryOperator operator = 0;
		ValaBinaryOperator _tmp2_;
		if (!found) {
			break;
		}
		operator = vala_genie_parser_get_binary_operator (self, vala_genie_parser_current (self));
		_tmp2_ = operator;
		switch (_tmp2_) {
			case VALA_BINARY_OPERATOR_INEQUALITY:
			case VALA_BINARY_OPERATOR_EQUALITY:
			{
				gboolean _tmp3_ = FALSE;
				ValaBinaryOperator _tmp4_;
				ValaExpression* right = NULL;
				ValaExpression* _tmp5_;
				ValaBinaryOperator _tmp6_;
				ValaExpression* _tmp7_;
				ValaExpression* _tmp8_;
				ValaSourceLocation _tmp9_;
				ValaSourceReference* _tmp10_;
				ValaSourceReference* _tmp11_;
				ValaBinaryExpression* _tmp12_;
				_tmp4_ = operator;
				if (_tmp4_ == VALA_BINARY_OPERATOR_INEQUALITY) {
					_tmp3_ = vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_IS;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					vala_genie_parser_next (self);
				}
				vala_genie_parser_next (self);
				_tmp5_ = vala_genie_parser_parse_relational_expression (self, &_inner_error0_);
				right = _tmp5_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (left);
						return NULL;
					} else {
						_vala_code_node_unref0 (left);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp6_ = operator;
				_tmp7_ = left;
				_tmp8_ = right;
				_tmp9_ = begin;
				_tmp10_ = vala_genie_parser_get_src (self, &_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_binary_expression_new (_tmp6_, _tmp7_, _tmp8_, _tmp11_);
				_vala_code_node_unref0 (left);
				left = (ValaExpression*) _tmp12_;
				_vala_source_reference_unref0 (_tmp11_);
				_vala_code_node_unref0 (right);
				break;
			}
			default:
			{
				found = FALSE;
				break;
			}
		}
	}
	result = left;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_and_expression (ValaGenieParser* self,
                                        GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_genie_parser_parse_equality_expression (self, &_inner_error0_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaExpression* right = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSourceLocation _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaBinaryExpression* _tmp8_;
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_BITWISE_AND)) {
			break;
		}
		_tmp2_ = vala_genie_parser_parse_equality_expression (self, &_inner_error0_);
		right = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (left);
				return NULL;
			} else {
				_vala_code_node_unref0 (left);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp3_ = left;
		_tmp4_ = right;
		_tmp5_ = begin;
		_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_BITWISE_AND, _tmp3_, _tmp4_, _tmp7_);
		_vala_code_node_unref0 (left);
		left = (ValaExpression*) _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_vala_code_node_unref0 (right);
	}
	result = left;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_exclusive_or_expression (ValaGenieParser* self,
                                                 GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_genie_parser_parse_and_expression (self, &_inner_error0_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaExpression* right = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSourceLocation _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaBinaryExpression* _tmp8_;
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CARRET)) {
			break;
		}
		_tmp2_ = vala_genie_parser_parse_and_expression (self, &_inner_error0_);
		right = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (left);
				return NULL;
			} else {
				_vala_code_node_unref0 (left);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp3_ = left;
		_tmp4_ = right;
		_tmp5_ = begin;
		_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_BITWISE_XOR, _tmp3_, _tmp4_, _tmp7_);
		_vala_code_node_unref0 (left);
		left = (ValaExpression*) _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_vala_code_node_unref0 (right);
	}
	result = left;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_inclusive_or_expression (ValaGenieParser* self,
                                                 GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_genie_parser_parse_exclusive_or_expression (self, &_inner_error0_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaExpression* right = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSourceLocation _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaBinaryExpression* _tmp8_;
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_BITWISE_OR)) {
			break;
		}
		_tmp2_ = vala_genie_parser_parse_exclusive_or_expression (self, &_inner_error0_);
		right = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (left);
				return NULL;
			} else {
				_vala_code_node_unref0 (left);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp3_ = left;
		_tmp4_ = right;
		_tmp5_ = begin;
		_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_BITWISE_OR, _tmp3_, _tmp4_, _tmp7_);
		_vala_code_node_unref0 (left);
		left = (ValaExpression*) _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_vala_code_node_unref0 (right);
	}
	result = left;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_in_expression (ValaGenieParser* self,
                                       GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_genie_parser_parse_inclusive_or_expression (self, &_inner_error0_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaExpression* right = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSourceLocation _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaBinaryExpression* _tmp8_;
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_IN)) {
			break;
		}
		_tmp2_ = vala_genie_parser_parse_inclusive_or_expression (self, &_inner_error0_);
		right = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (left);
				return NULL;
			} else {
				_vala_code_node_unref0 (left);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp3_ = left;
		_tmp4_ = right;
		_tmp5_ = begin;
		_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_IN, _tmp3_, _tmp4_, _tmp7_);
		_vala_code_node_unref0 (left);
		left = (ValaExpression*) _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_vala_code_node_unref0 (right);
	}
	result = left;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_conditional_and_expression (ValaGenieParser* self,
                                                    GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_genie_parser_parse_in_expression (self, &_inner_error0_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaExpression* right = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSourceLocation _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaBinaryExpression* _tmp8_;
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OP_AND)) {
			break;
		}
		_tmp2_ = vala_genie_parser_parse_in_expression (self, &_inner_error0_);
		right = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (left);
				return NULL;
			} else {
				_vala_code_node_unref0 (left);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp3_ = left;
		_tmp4_ = right;
		_tmp5_ = begin;
		_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_AND, _tmp3_, _tmp4_, _tmp7_);
		_vala_code_node_unref0 (left);
		left = (ValaExpression*) _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_vala_code_node_unref0 (right);
	}
	result = left;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_conditional_or_expression (ValaGenieParser* self,
                                                   GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_genie_parser_parse_conditional_and_expression (self, &_inner_error0_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaExpression* right = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSourceLocation _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaBinaryExpression* _tmp8_;
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OP_OR)) {
			break;
		}
		_tmp2_ = vala_genie_parser_parse_conditional_and_expression (self, &_inner_error0_);
		right = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (left);
				return NULL;
			} else {
				_vala_code_node_unref0 (left);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp3_ = left;
		_tmp4_ = right;
		_tmp5_ = begin;
		_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_OR, _tmp3_, _tmp4_, _tmp7_);
		_vala_code_node_unref0 (left);
		left = (ValaExpression*) _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_vala_code_node_unref0 (right);
	}
	result = left;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_conditional_expression (ValaGenieParser* self,
                                                GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* condition = NULL;
	ValaExpression* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_genie_parser_parse_conditional_or_expression (self, &_inner_error0_);
	condition = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INTERR)) {
		ValaExpression* true_expr = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* false_expr = NULL;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaSourceLocation _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaConditionalExpression* _tmp10_;
		ValaExpression* _tmp11_;
		_tmp2_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
		true_expr = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (condition);
				return NULL;
			} else {
				_vala_code_node_unref0 (condition);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (true_expr);
				_vala_code_node_unref0 (condition);
				return NULL;
			} else {
				_vala_code_node_unref0 (true_expr);
				_vala_code_node_unref0 (condition);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp3_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
		false_expr = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (true_expr);
				_vala_code_node_unref0 (condition);
				return NULL;
			} else {
				_vala_code_node_unref0 (true_expr);
				_vala_code_node_unref0 (condition);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp4_ = condition;
		_tmp5_ = true_expr;
		_tmp6_ = false_expr;
		_tmp7_ = begin;
		_tmp8_ = vala_genie_parser_get_src (self, &_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_conditional_expression_new (_tmp4_, _tmp5_, _tmp6_, _tmp9_);
		_tmp11_ = (ValaExpression*) _tmp10_;
		_vala_source_reference_unref0 (_tmp9_);
		result = _tmp11_;
		_vala_code_node_unref0 (false_expr);
		_vala_code_node_unref0 (true_expr);
		_vala_code_node_unref0 (condition);
		return result;
	} else {
		result = condition;
		return result;
	}
	_vala_code_node_unref0 (condition);
}

static ValaParameter*
vala_genie_parser_parse_lambda_parameter (ValaGenieParser* self,
                                          GError** error)
{
	ValaParameter* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaParameterDirection direction = 0;
	gchar* id = NULL;
	gchar* _tmp1_;
	ValaParameter* param = NULL;
	ValaSourceLocation _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaParameter* _tmp5_;
	ValaParameter* _tmp6_;
	ValaParameter* _tmp7_;
	ValaParameterDirection _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	direction = VALA_PARAMETER_DIRECTION_IN;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OUT)) {
		direction = VALA_PARAMETER_DIRECTION_OUT;
	} else {
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_REF)) {
			direction = VALA_PARAMETER_DIRECTION_REF;
		}
	}
	_tmp1_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
	id = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = begin;
	_tmp3_ = vala_genie_parser_get_src (self, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_parameter_new (id, NULL, _tmp4_);
	_tmp6_ = _tmp5_;
	_vala_source_reference_unref0 (_tmp4_);
	param = _tmp6_;
	_tmp7_ = param;
	_tmp8_ = direction;
	vala_parameter_set_direction (_tmp7_, _tmp8_);
	result = param;
	_g_free0 (id);
	return result;
}

static ValaExpression*
vala_genie_parser_parse_lambda_expression (ValaGenieParser* self,
                                           GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaList* params = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaLambdaExpression* lambda = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	params = (ValaList*) _tmp2_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEF, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_iterable_unref0 (params);
			return NULL;
		} else {
			_vala_iterable_unref0 (params);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)) {
		if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					ValaParameter* _tmp4_ = NULL;
					ValaParameter* _tmp5_;
					ValaList* _tmp6_;
					if (!_tmp3_) {
						if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
							break;
						}
					}
					_tmp3_ = FALSE;
					_tmp5_ = vala_genie_parser_parse_lambda_parameter (self, &_inner_error0_);
					_tmp4_ = _tmp5_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_vala_iterable_unref0 (params);
							return NULL;
						} else {
							_vala_iterable_unref0 (params);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp6_ = params;
					vala_collection_add ((ValaCollection*) _tmp6_, _tmp4_);
					_vala_code_node_unref0 (_tmp4_);
				}
			}
		}
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_iterable_unref0 (params);
				return NULL;
			} else {
				_vala_iterable_unref0 (params);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	} else {
		ValaParameter* _tmp7_ = NULL;
		ValaParameter* _tmp8_;
		ValaList* _tmp9_;
		_tmp8_ = vala_genie_parser_parse_lambda_parameter (self, &_inner_error0_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_iterable_unref0 (params);
				return NULL;
			} else {
				_vala_iterable_unref0 (params);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp9_ = params;
		vala_collection_add ((ValaCollection*) _tmp9_, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
	}
	if (vala_genie_parser_accept_block (self)) {
		ValaBlock* block = NULL;
		ValaBlock* _tmp10_;
		ValaBlock* _tmp11_;
		ValaSourceLocation _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaLambdaExpression* _tmp15_;
		_tmp10_ = vala_genie_parser_parse_block (self, &_inner_error0_);
		block = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (lambda);
				_vala_iterable_unref0 (params);
				return NULL;
			} else {
				_vala_code_node_unref0 (lambda);
				_vala_iterable_unref0 (params);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp11_ = block;
		_tmp12_ = begin;
		_tmp13_ = vala_genie_parser_get_src (self, &_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_lambda_expression_new_with_statement_body (_tmp11_, _tmp14_);
		_vala_code_node_unref0 (lambda);
		lambda = _tmp15_;
		_vala_source_reference_unref0 (_tmp14_);
		_vala_code_node_unref0 (block);
	} else {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaSourceLocation _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLambdaExpression* _tmp21_;
		_tmp16_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
		expr = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (lambda);
				_vala_iterable_unref0 (params);
				return NULL;
			} else {
				_vala_code_node_unref0 (lambda);
				_vala_iterable_unref0 (params);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp17_ = expr;
		_tmp18_ = begin;
		_tmp19_ = vala_genie_parser_get_src (self, &_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_lambda_expression_new (_tmp17_, _tmp20_);
		_vala_code_node_unref0 (lambda);
		lambda = _tmp21_;
		_vala_source_reference_unref0 (_tmp20_);
		vala_genie_parser_expect_terminator (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (expr);
				_vala_code_node_unref0 (lambda);
				_vala_iterable_unref0 (params);
				return NULL;
			} else {
				_vala_code_node_unref0 (expr);
				_vala_code_node_unref0 (lambda);
				_vala_iterable_unref0 (params);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_vala_code_node_unref0 (expr);
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp22_;
		ValaList* _tmp23_;
		gint _param_size = 0;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _param_index = 0;
		_tmp22_ = params;
		_tmp23_ = _vala_iterable_ref0 (_tmp22_);
		_param_list = _tmp23_;
		_tmp24_ = _param_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_param_size = _tmp26_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp27_;
			gpointer _tmp28_;
			ValaLambdaExpression* _tmp29_;
			ValaParameter* _tmp30_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp27_ = _param_list;
			_tmp28_ = vala_list_get (_tmp27_, _param_index);
			param = (ValaParameter*) _tmp28_;
			_tmp29_ = lambda;
			_tmp30_ = param;
			vala_lambda_expression_add_parameter (_tmp29_, _tmp30_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = (ValaExpression*) lambda;
	_vala_iterable_unref0 (params);
	return result;
}

static ValaAssignmentOperator
vala_genie_parser_get_assignment_operator (ValaGenieParser* self,
                                           ValaGenieTokenType token_type)
{
	ValaAssignmentOperator result = 0;
	g_return_val_if_fail (self != NULL, 0);
	switch (token_type) {
		case VALA_GENIE_TOKEN_TYPE_ASSIGN:
		{
			result = VALA_ASSIGNMENT_OPERATOR_SIMPLE;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD:
		{
			result = VALA_ASSIGNMENT_OPERATOR_ADD;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB:
		{
			result = VALA_ASSIGNMENT_OPERATOR_SUB;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR:
		{
			result = VALA_ASSIGNMENT_OPERATOR_BITWISE_OR;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND:
		{
			result = VALA_ASSIGNMENT_OPERATOR_BITWISE_AND;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR:
		{
			result = VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV:
		{
			result = VALA_ASSIGNMENT_OPERATOR_DIV;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL:
		{
			result = VALA_ASSIGNMENT_OPERATOR_MUL;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT:
		{
			result = VALA_ASSIGNMENT_OPERATOR_PERCENT;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT:
		{
			result = VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT;
			return result;
		}
		default:
		{
			result = VALA_ASSIGNMENT_OPERATOR_NONE;
			return result;
		}
	}
}

static ValaExpression*
vala_genie_parser_parse_expression_with_terminator (ValaGenieParser* self,
                                                    GError** error)
{
	ValaExpression* result = NULL;
	ValaExpression* expr = NULL;
	ValaExpression* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
	expr = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (self->priv->current_expr_is_lambda) {
		self->priv->current_expr_is_lambda = FALSE;
	} else {
		vala_genie_parser_expect_terminator (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (expr);
				return NULL;
			} else {
				_vala_code_node_unref0 (expr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	result = expr;
	return result;
}

static ValaExpression*
vala_genie_parser_parse_expression (ValaGenieParser* self,
                                    GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp1_ = {0};
	ValaExpression* expr = NULL;
	ValaExpression* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_DEF) {
		ValaExpression* lambda = NULL;
		ValaExpression* _tmp0_;
		_tmp0_ = vala_genie_parser_parse_lambda_expression (self, &_inner_error0_);
		lambda = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		self->priv->current_expr_is_lambda = TRUE;
		result = lambda;
		return result;
	} else {
		self->priv->current_expr_is_lambda = FALSE;
	}
	vala_genie_parser_get_location (self, &_tmp1_);
	begin = _tmp1_;
	_tmp2_ = vala_genie_parser_parse_conditional_expression (self, &_inner_error0_);
	expr = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaAssignmentOperator operator = 0;
		ValaAssignmentOperator _tmp3_;
		operator = vala_genie_parser_get_assignment_operator (self, vala_genie_parser_current (self));
		_tmp3_ = operator;
		if (_tmp3_ != VALA_ASSIGNMENT_OPERATOR_NONE) {
			ValaExpression* rhs = NULL;
			ValaExpression* _tmp4_;
			ValaExpression* _tmp5_;
			ValaExpression* _tmp6_;
			ValaAssignmentOperator _tmp7_;
			ValaSourceLocation _tmp8_;
			ValaSourceReference* _tmp9_;
			ValaSourceReference* _tmp10_;
			ValaAssignment* _tmp11_;
			vala_genie_parser_next (self);
			_tmp4_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
			rhs = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp5_ = expr;
			_tmp6_ = rhs;
			_tmp7_ = operator;
			_tmp8_ = begin;
			_tmp9_ = vala_genie_parser_get_src (self, &_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_assignment_new (_tmp5_, _tmp6_, _tmp7_, _tmp10_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp11_;
			_vala_source_reference_unref0 (_tmp10_);
			_vala_code_node_unref0 (rhs);
		} else {
			if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_OP_GT) {
				gchar* first_gt_pos = NULL;
				ValaGenieParserTokenInfo* _tmp12_;
				gint _tmp12__length1;
				ValaGenieParserTokenInfo _tmp13_;
				ValaSourceLocation _tmp14_;
				gchar* _tmp15_;
				gboolean _tmp16_ = FALSE;
				_tmp12_ = self->priv->tokens;
				_tmp12__length1 = self->priv->tokens_length1;
				_tmp13_ = _tmp12_[self->priv->index];
				_tmp14_ = _tmp13_.begin;
				_tmp15_ = _tmp14_.pos;
				first_gt_pos = _tmp15_;
				vala_genie_parser_next (self);
				if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_OP_GE) {
					ValaGenieParserTokenInfo* _tmp17_;
					gint _tmp17__length1;
					ValaGenieParserTokenInfo _tmp18_;
					ValaSourceLocation _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp17_ = self->priv->tokens;
					_tmp17__length1 = self->priv->tokens_length1;
					_tmp18_ = _tmp17_[self->priv->index];
					_tmp19_ = _tmp18_.begin;
					_tmp20_ = _tmp19_.pos;
					_tmp21_ = first_gt_pos;
					_tmp16_ = _tmp20_ == (_tmp21_ + 1);
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					ValaExpression* rhs = NULL;
					ValaExpression* _tmp22_;
					ValaExpression* _tmp23_;
					ValaExpression* _tmp24_;
					ValaSourceLocation _tmp25_;
					ValaSourceReference* _tmp26_;
					ValaSourceReference* _tmp27_;
					ValaAssignment* _tmp28_;
					vala_genie_parser_next (self);
					_tmp22_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
					rhs = _tmp22_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_vala_code_node_unref0 (expr);
							return NULL;
						} else {
							_vala_code_node_unref0 (expr);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp23_ = expr;
					_tmp24_ = rhs;
					_tmp25_ = begin;
					_tmp26_ = vala_genie_parser_get_src (self, &_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = vala_assignment_new (_tmp23_, _tmp24_, VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, _tmp27_);
					_vala_code_node_unref0 (expr);
					expr = (ValaExpression*) _tmp28_;
					_vala_source_reference_unref0 (_tmp27_);
					_vala_code_node_unref0 (rhs);
				} else {
					vala_genie_parser_prev (self);
					break;
				}
			} else {
				break;
			}
		}
	}
	result = expr;
	return result;
}

static ValaStatement*
vala_genie_parser_get_for_statement_type (ValaGenieParser* self,
                                          GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gboolean is_foreach = FALSE;
	ValaSourceLocation _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	is_foreach = FALSE;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOL) {
			_tmp1_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DO;
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		vala_genie_parser_next (self);
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_IN)) {
			is_foreach = TRUE;
			break;
		}
	}
	_tmp2_ = begin;
	vala_genie_parser_rollback (self, &_tmp2_);
	if (is_foreach) {
		ValaStatement* _tmp3_ = NULL;
		ValaStatement* _tmp4_;
		ValaStatement* _tmp5_;
		_tmp4_ = vala_genie_parser_parse_foreach_statement (self, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		result = _tmp5_;
		_vala_code_node_unref0 (_tmp3_);
		return result;
	} else {
		ValaStatement* _tmp6_ = NULL;
		ValaStatement* _tmp7_;
		ValaStatement* _tmp8_;
		_tmp7_ = vala_genie_parser_parse_for_statement (self, &_inner_error0_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp8_ = _tmp6_;
		_tmp6_ = NULL;
		result = _tmp8_;
		_vala_code_node_unref0 (_tmp6_);
		return result;
	}
}

static void
vala_genie_parser_parse_statements (ValaGenieParser* self,
                                    ValaBlock* block,
                                    GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
			_tmp1_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_WHEN;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEFAULT;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		{
			ValaStatement* stmt = NULL;
			gboolean is_decl = FALSE;
			ValaGenieScanner* _tmp2_;
			ValaComment* _tmp3_;
			stmt = NULL;
			is_decl = FALSE;
			_tmp2_ = self->priv->scanner;
			_tmp3_ = vala_genie_scanner_pop_comment (_tmp2_);
			_vala_comment_unref0 (self->priv->comment);
			self->priv->comment = _tmp3_;
			switch (vala_genie_parser_current (self)) {
				case VALA_GENIE_TOKEN_TYPE_REQUIRES:
				case VALA_GENIE_TOKEN_TYPE_ENSURES:
				{
					ValaSourceLocation begin = {0};
					ValaSourceLocation _tmp4_ = {0};
					gboolean _tmp5_ = FALSE;
					ValaSourceLocation _tmp6_;
					ValaSourceReference* _tmp7_;
					ValaSourceReference* _tmp8_;
					ValaEmptyStatement* _tmp9_;
					vala_genie_parser_get_location (self, &_tmp4_);
					begin = _tmp4_;
					vala_genie_parser_next (self);
					if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
						_tmp5_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT);
					} else {
						_tmp5_ = FALSE;
					}
					if (_tmp5_) {
						while (TRUE) {
							if (!(vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT)) {
								break;
							}
							vala_genie_parser_next (self);
						}
						vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_vala_code_node_unref0 (stmt);
							if (_inner_error0_->domain == VALA_PARSE_ERROR) {
								goto __catch13_vala_parse_error;
							}
							_vala_code_node_unref0 (stmt);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					} else {
						while (TRUE) {
							if (!(vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOL)) {
								break;
							}
							vala_genie_parser_next (self);
						}
						vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_vala_code_node_unref0 (stmt);
							if (_inner_error0_->domain == VALA_PARSE_ERROR) {
								goto __catch13_vala_parse_error;
							}
							_vala_code_node_unref0 (stmt);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					_tmp6_ = begin;
					_tmp7_ = vala_genie_parser_get_src (self, &_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = vala_empty_statement_new (_tmp8_);
					_vala_code_node_unref0 (stmt);
					stmt = (ValaStatement*) _tmp9_;
					_vala_source_reference_unref0 (_tmp8_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_INDENT:
				{
					ValaBlock* _tmp10_ = NULL;
					ValaBlock* _tmp11_;
					ValaBlock* _tmp12_;
					_tmp11_ = vala_genie_parser_parse_block (self, &_inner_error0_);
					_tmp10_ = _tmp11_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp12_ = _tmp10_;
					_tmp10_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = (ValaStatement*) _tmp12_;
					_vala_code_node_unref0 (_tmp10_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_SEMICOLON:
				case VALA_GENIE_TOKEN_TYPE_PASS:
				{
					ValaStatement* _tmp13_ = NULL;
					ValaStatement* _tmp14_;
					ValaStatement* _tmp15_;
					_tmp14_ = vala_genie_parser_parse_empty_statement (self, &_inner_error0_);
					_tmp13_ = _tmp14_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp15_ = _tmp13_;
					_tmp13_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp15_;
					_vala_code_node_unref0 (_tmp13_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_PRINT:
				case VALA_GENIE_TOKEN_TYPE_ASSERT:
				{
					ValaStatement* _tmp16_ = NULL;
					ValaStatement* _tmp17_;
					ValaStatement* _tmp18_;
					_tmp17_ = vala_genie_parser_parse_expression_statement (self, &_inner_error0_);
					_tmp16_ = _tmp17_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp18_ = _tmp16_;
					_tmp16_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp18_;
					_vala_code_node_unref0 (_tmp16_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_IF:
				{
					ValaStatement* _tmp19_ = NULL;
					ValaStatement* _tmp20_;
					ValaStatement* _tmp21_;
					_tmp20_ = vala_genie_parser_parse_if_statement (self, &_inner_error0_);
					_tmp19_ = _tmp20_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp21_ = _tmp19_;
					_tmp19_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp21_;
					_vala_code_node_unref0 (_tmp19_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_CASE:
				{
					ValaStatement* _tmp22_ = NULL;
					ValaStatement* _tmp23_;
					ValaStatement* _tmp24_;
					_tmp23_ = vala_genie_parser_parse_switch_statement (self, &_inner_error0_);
					_tmp22_ = _tmp23_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp24_ = _tmp22_;
					_tmp22_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp24_;
					_vala_code_node_unref0 (_tmp22_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_WHILE:
				{
					ValaStatement* _tmp25_ = NULL;
					ValaStatement* _tmp26_;
					ValaStatement* _tmp27_;
					_tmp26_ = vala_genie_parser_parse_while_statement (self, &_inner_error0_);
					_tmp25_ = _tmp26_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp27_ = _tmp25_;
					_tmp25_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp27_;
					_vala_code_node_unref0 (_tmp25_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_DO:
				{
					ValaStatement* _tmp28_ = NULL;
					ValaStatement* _tmp29_;
					ValaStatement* _tmp30_;
					_tmp29_ = vala_genie_parser_parse_do_statement (self, &_inner_error0_);
					_tmp28_ = _tmp29_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp30_ = _tmp28_;
					_tmp28_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp30_;
					_vala_code_node_unref0 (_tmp28_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_FOR:
				{
					ValaStatement* _tmp31_ = NULL;
					ValaStatement* _tmp32_;
					ValaStatement* _tmp33_;
					_tmp32_ = vala_genie_parser_get_for_statement_type (self, &_inner_error0_);
					_tmp31_ = _tmp32_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp33_ = _tmp31_;
					_tmp31_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp33_;
					_vala_code_node_unref0 (_tmp31_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_BREAK:
				{
					ValaStatement* _tmp34_ = NULL;
					ValaStatement* _tmp35_;
					ValaStatement* _tmp36_;
					_tmp35_ = vala_genie_parser_parse_break_statement (self, &_inner_error0_);
					_tmp34_ = _tmp35_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp36_ = _tmp34_;
					_tmp34_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp36_;
					_vala_code_node_unref0 (_tmp34_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_CONTINUE:
				{
					ValaStatement* _tmp37_ = NULL;
					ValaStatement* _tmp38_;
					ValaStatement* _tmp39_;
					_tmp38_ = vala_genie_parser_parse_continue_statement (self, &_inner_error0_);
					_tmp37_ = _tmp38_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp39_ = _tmp37_;
					_tmp37_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp39_;
					_vala_code_node_unref0 (_tmp37_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_RETURN:
				{
					ValaStatement* _tmp40_ = NULL;
					ValaStatement* _tmp41_;
					ValaStatement* _tmp42_;
					_tmp41_ = vala_genie_parser_parse_return_statement (self, &_inner_error0_);
					_tmp40_ = _tmp41_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp42_ = _tmp40_;
					_tmp40_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp42_;
					_vala_code_node_unref0 (_tmp40_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_RAISE:
				{
					ValaStatement* _tmp43_ = NULL;
					ValaStatement* _tmp44_;
					ValaStatement* _tmp45_;
					_tmp44_ = vala_genie_parser_parse_throw_statement (self, &_inner_error0_);
					_tmp43_ = _tmp44_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp45_ = _tmp43_;
					_tmp43_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp45_;
					_vala_code_node_unref0 (_tmp43_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_TRY:
				{
					ValaStatement* _tmp46_ = NULL;
					ValaStatement* _tmp47_;
					ValaStatement* _tmp48_;
					_tmp47_ = vala_genie_parser_parse_try_statement (self, &_inner_error0_);
					_tmp46_ = _tmp47_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp48_ = _tmp46_;
					_tmp46_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp48_;
					_vala_code_node_unref0 (_tmp46_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_LOCK:
				{
					ValaStatement* _tmp49_ = NULL;
					ValaStatement* _tmp50_;
					ValaStatement* _tmp51_;
					_tmp50_ = vala_genie_parser_parse_lock_statement (self, &_inner_error0_);
					_tmp49_ = _tmp50_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp51_ = _tmp49_;
					_tmp49_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp51_;
					_vala_code_node_unref0 (_tmp49_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_DELETE:
				{
					ValaStatement* _tmp52_ = NULL;
					ValaStatement* _tmp53_;
					ValaStatement* _tmp54_;
					_tmp53_ = vala_genie_parser_parse_delete_statement (self, &_inner_error0_);
					_tmp52_ = _tmp53_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp54_ = _tmp52_;
					_tmp52_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp54_;
					_vala_code_node_unref0 (_tmp52_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_VAR:
				{
					is_decl = TRUE;
					vala_genie_parser_parse_type_inference_declaration (self, block, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_YIELD:
				{
					ValaStatement* _tmp55_ = NULL;
					ValaStatement* _tmp56_;
					ValaStatement* _tmp57_;
					_tmp56_ = vala_genie_parser_parse_yield_statement (self, &_inner_error0_);
					_tmp55_ = _tmp56_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp57_ = _tmp55_;
					_tmp55_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp57_;
					_vala_code_node_unref0 (_tmp55_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_OP_INC:
				case VALA_GENIE_TOKEN_TYPE_OP_DEC:
				case VALA_GENIE_TOKEN_TYPE_SUPER:
				case VALA_GENIE_TOKEN_TYPE_THIS:
				case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
				case VALA_GENIE_TOKEN_TYPE_STAR:
				case VALA_GENIE_TOKEN_TYPE_NEW:
				{
					ValaStatement* _tmp58_ = NULL;
					ValaStatement* _tmp59_;
					ValaStatement* _tmp60_;
					_tmp59_ = vala_genie_parser_parse_expression_statement (self, &_inner_error0_);
					_tmp58_ = _tmp59_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp60_ = _tmp58_;
					_tmp58_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp60_;
					_vala_code_node_unref0 (_tmp58_);
					break;
				}
				default:
				{
					gboolean is_expr = FALSE;
					is_expr = vala_genie_parser_is_expression (self, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch13_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					if (is_expr) {
						ValaStatement* _tmp61_ = NULL;
						ValaStatement* _tmp62_;
						ValaStatement* _tmp63_;
						_tmp62_ = vala_genie_parser_parse_expression_statement (self, &_inner_error0_);
						_tmp61_ = _tmp62_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_vala_code_node_unref0 (stmt);
							if (_inner_error0_->domain == VALA_PARSE_ERROR) {
								goto __catch13_vala_parse_error;
							}
							_vala_code_node_unref0 (stmt);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						_tmp63_ = _tmp61_;
						_tmp61_ = NULL;
						_vala_code_node_unref0 (stmt);
						stmt = _tmp63_;
						_vala_code_node_unref0 (_tmp61_);
					} else {
						is_decl = TRUE;
						vala_genie_parser_parse_local_variable_declarations (self, block, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_vala_code_node_unref0 (stmt);
							if (_inner_error0_->domain == VALA_PARSE_ERROR) {
								goto __catch13_vala_parse_error;
							}
							_vala_code_node_unref0 (stmt);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					break;
				}
			}
			if (!is_decl) {
				ValaStatement* _tmp64_;
				_tmp64_ = stmt;
				vala_block_add_statement (block, _tmp64_);
			}
			_vala_code_node_unref0 (stmt);
		}
		goto __finally13;
		__catch13_vala_parse_error:
		{
			GError* e = NULL;
			GError* _tmp65_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp65_ = e;
			vala_genie_parser_report_parse_error (self, _tmp65_);
			if (vala_genie_parser_recover (self) != VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN) {
				_g_error_free0 (e);
				break;
			}
			_g_error_free0 (e);
		}
		__finally13:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
}

static gboolean
vala_genie_parser_is_expression (ValaGenieParser* self,
                                 GError** error)
{
	gboolean result = FALSE;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_skip_type (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			gboolean _tmp1_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gboolean _tmp2_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	switch (vala_genie_parser_current (self)) {
		case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
		case VALA_GENIE_TOKEN_TYPE_OP_INC:
		case VALA_GENIE_TOKEN_TYPE_OP_DEC:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB:
		case VALA_GENIE_TOKEN_TYPE_OP_GT:
		case VALA_GENIE_TOKEN_TYPE_DOT:
		case VALA_GENIE_TOKEN_TYPE_OP_PTR:
		{
			ValaSourceLocation _tmp3_;
			_tmp3_ = begin;
			vala_genie_parser_rollback (self, &_tmp3_);
			result = TRUE;
			return result;
		}
		default:
		{
			ValaSourceLocation _tmp4_;
			_tmp4_ = begin;
			vala_genie_parser_rollback (self, &_tmp4_);
			result = FALSE;
			return result;
		}
	}
}

static ValaBlock*
vala_genie_parser_parse_embedded_statement (ValaGenieParser* self,
                                            GError** error)
{
	ValaBlock* result = NULL;
	ValaGenieScanner* _tmp1_;
	ValaComment* _tmp2_;
	ValaBlock* block = NULL;
	ValaSourceLocation _tmp3_ = {0};
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaBlock* _tmp6_;
	ValaBlock* _tmp7_;
	ValaStatement* _tmp8_ = NULL;
	ValaStatement* _tmp9_;
	ValaBlock* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_INDENT) {
		ValaBlock* block = NULL;
		ValaBlock* _tmp0_;
		_tmp0_ = vala_genie_parser_parse_block (self, &_inner_error0_);
		block = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		result = block;
		return result;
	}
	_tmp1_ = self->priv->scanner;
	_tmp2_ = vala_genie_scanner_pop_comment (_tmp1_);
	_vala_comment_unref0 (self->priv->comment);
	self->priv->comment = _tmp2_;
	vala_genie_parser_get_location (self, &_tmp3_);
	_tmp4_ = vala_genie_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_block_new (_tmp5_);
	_tmp7_ = _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	block = _tmp7_;
	_tmp9_ = vala_genie_parser_parse_embedded_statement_without_block (self, &_inner_error0_);
	_tmp8_ = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (block);
			return NULL;
		} else {
			_vala_code_node_unref0 (block);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp10_ = block;
	vala_block_add_statement (_tmp10_, _tmp8_);
	result = block;
	_vala_code_node_unref0 (_tmp8_);
	return result;
}

static ValaStatement*
vala_genie_parser_parse_embedded_statement_without_block (ValaGenieParser* self,
                                                          GError** error)
{
	ValaStatement* result = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (vala_genie_parser_current (self)) {
		case VALA_GENIE_TOKEN_TYPE_PASS:
		case VALA_GENIE_TOKEN_TYPE_SEMICOLON:
		{
			ValaStatement* _tmp0_ = NULL;
			ValaStatement* _tmp1_;
			ValaStatement* _tmp2_;
			_tmp1_ = vala_genie_parser_parse_empty_statement (self, &_inner_error0_);
			_tmp0_ = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp2_ = _tmp0_;
			_tmp0_ = NULL;
			result = _tmp2_;
			_vala_code_node_unref0 (_tmp0_);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_IF:
		{
			ValaStatement* _tmp3_ = NULL;
			ValaStatement* _tmp4_;
			ValaStatement* _tmp5_;
			_tmp4_ = vala_genie_parser_parse_if_statement (self, &_inner_error0_);
			_tmp3_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp5_ = _tmp3_;
			_tmp3_ = NULL;
			result = _tmp5_;
			_vala_code_node_unref0 (_tmp3_);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_CASE:
		{
			ValaStatement* _tmp6_ = NULL;
			ValaStatement* _tmp7_;
			ValaStatement* _tmp8_;
			_tmp7_ = vala_genie_parser_parse_switch_statement (self, &_inner_error0_);
			_tmp6_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp8_ = _tmp6_;
			_tmp6_ = NULL;
			result = _tmp8_;
			_vala_code_node_unref0 (_tmp6_);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_WHILE:
		{
			ValaStatement* _tmp9_ = NULL;
			ValaStatement* _tmp10_;
			ValaStatement* _tmp11_;
			_tmp10_ = vala_genie_parser_parse_while_statement (self, &_inner_error0_);
			_tmp9_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp11_ = _tmp9_;
			_tmp9_ = NULL;
			result = _tmp11_;
			_vala_code_node_unref0 (_tmp9_);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_DO:
		{
			ValaStatement* _tmp12_ = NULL;
			ValaStatement* _tmp13_;
			ValaStatement* _tmp14_;
			_tmp13_ = vala_genie_parser_parse_do_statement (self, &_inner_error0_);
			_tmp12_ = _tmp13_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp14_ = _tmp12_;
			_tmp12_ = NULL;
			result = _tmp14_;
			_vala_code_node_unref0 (_tmp12_);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_FOR:
		{
			ValaStatement* _tmp15_ = NULL;
			ValaStatement* _tmp16_;
			ValaStatement* _tmp17_;
			_tmp16_ = vala_genie_parser_get_for_statement_type (self, &_inner_error0_);
			_tmp15_ = _tmp16_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp17_ = _tmp15_;
			_tmp15_ = NULL;
			result = _tmp17_;
			_vala_code_node_unref0 (_tmp15_);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_BREAK:
		{
			ValaStatement* _tmp18_ = NULL;
			ValaStatement* _tmp19_;
			ValaStatement* _tmp20_;
			_tmp19_ = vala_genie_parser_parse_break_statement (self, &_inner_error0_);
			_tmp18_ = _tmp19_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp20_ = _tmp18_;
			_tmp18_ = NULL;
			result = _tmp20_;
			_vala_code_node_unref0 (_tmp18_);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_CONTINUE:
		{
			ValaStatement* _tmp21_ = NULL;
			ValaStatement* _tmp22_;
			ValaStatement* _tmp23_;
			_tmp22_ = vala_genie_parser_parse_continue_statement (self, &_inner_error0_);
			_tmp21_ = _tmp22_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp23_ = _tmp21_;
			_tmp21_ = NULL;
			result = _tmp23_;
			_vala_code_node_unref0 (_tmp21_);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_RETURN:
		{
			ValaStatement* _tmp24_ = NULL;
			ValaStatement* _tmp25_;
			ValaStatement* _tmp26_;
			_tmp25_ = vala_genie_parser_parse_return_statement (self, &_inner_error0_);
			_tmp24_ = _tmp25_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp26_ = _tmp24_;
			_tmp24_ = NULL;
			result = _tmp26_;
			_vala_code_node_unref0 (_tmp24_);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_YIELD:
		{
			ValaStatement* _tmp27_ = NULL;
			ValaStatement* _tmp28_;
			ValaStatement* _tmp29_;
			_tmp28_ = vala_genie_parser_parse_yield_statement (self, &_inner_error0_);
			_tmp27_ = _tmp28_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp29_ = _tmp27_;
			_tmp27_ = NULL;
			result = _tmp29_;
			_vala_code_node_unref0 (_tmp27_);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_RAISE:
		{
			ValaStatement* _tmp30_ = NULL;
			ValaStatement* _tmp31_;
			ValaStatement* _tmp32_;
			_tmp31_ = vala_genie_parser_parse_throw_statement (self, &_inner_error0_);
			_tmp30_ = _tmp31_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp32_ = _tmp30_;
			_tmp30_ = NULL;
			result = _tmp32_;
			_vala_code_node_unref0 (_tmp30_);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_TRY:
		{
			ValaStatement* _tmp33_ = NULL;
			ValaStatement* _tmp34_;
			ValaStatement* _tmp35_;
			_tmp34_ = vala_genie_parser_parse_try_statement (self, &_inner_error0_);
			_tmp33_ = _tmp34_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp35_ = _tmp33_;
			_tmp33_ = NULL;
			result = _tmp35_;
			_vala_code_node_unref0 (_tmp33_);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_LOCK:
		{
			ValaStatement* _tmp36_ = NULL;
			ValaStatement* _tmp37_;
			ValaStatement* _tmp38_;
			_tmp37_ = vala_genie_parser_parse_lock_statement (self, &_inner_error0_);
			_tmp36_ = _tmp37_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp38_ = _tmp36_;
			_tmp36_ = NULL;
			result = _tmp38_;
			_vala_code_node_unref0 (_tmp36_);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_DELETE:
		{
			ValaStatement* _tmp39_ = NULL;
			ValaStatement* _tmp40_;
			ValaStatement* _tmp41_;
			_tmp40_ = vala_genie_parser_parse_delete_statement (self, &_inner_error0_);
			_tmp39_ = _tmp40_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp41_ = _tmp39_;
			_tmp39_ = NULL;
			result = _tmp41_;
			_vala_code_node_unref0 (_tmp39_);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_VAR:
		case VALA_GENIE_TOKEN_TYPE_CONST:
		{
			GError* _tmp42_;
			_tmp42_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "embedded statement cannot be declaration ");
			_inner_error0_ = _tmp42_;
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		case VALA_GENIE_TOKEN_TYPE_OP_INC:
		case VALA_GENIE_TOKEN_TYPE_OP_DEC:
		case VALA_GENIE_TOKEN_TYPE_SUPER:
		case VALA_GENIE_TOKEN_TYPE_THIS:
		case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
		case VALA_GENIE_TOKEN_TYPE_STAR:
		case VALA_GENIE_TOKEN_TYPE_NEW:
		{
			ValaStatement* _tmp43_ = NULL;
			ValaStatement* _tmp44_;
			ValaStatement* _tmp45_;
			_tmp44_ = vala_genie_parser_parse_expression_statement (self, &_inner_error0_);
			_tmp43_ = _tmp44_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp45_ = _tmp43_;
			_tmp43_ = NULL;
			result = _tmp45_;
			_vala_code_node_unref0 (_tmp43_);
			return result;
		}
		default:
		{
			gboolean _tmp46_ = FALSE;
			_tmp46_ = vala_genie_parser_is_expression (self, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			if (_tmp46_) {
				ValaStatement* _tmp47_ = NULL;
				ValaStatement* _tmp48_;
				ValaStatement* _tmp49_;
				_tmp48_ = vala_genie_parser_parse_expression_statement (self, &_inner_error0_);
				_tmp47_ = _tmp48_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return NULL;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp49_ = _tmp47_;
				_tmp47_ = NULL;
				result = _tmp49_;
				_vala_code_node_unref0 (_tmp47_);
				return result;
			} else {
				GError* _tmp50_;
				_tmp50_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "embedded statement cannot be declaration");
				_inner_error0_ = _tmp50_;
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	}
}

static ValaBlock*
vala_genie_parser_parse_block (ValaGenieParser* self,
                               GError** error)
{
	ValaBlock* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaBlock* block = NULL;
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaBlock* _tmp4_;
	ValaBlock* _tmp5_;
	ValaBlock* _tmp6_;
	ValaBlock* _tmp12_;
	ValaSourceReference* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSourceReference* _tmp16_;
	ValaSourceLocation _tmp17_ = {0};
	ValaSourceLocation _tmp18_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = begin;
	_tmp2_ = vala_genie_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_block_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	block = _tmp5_;
	_tmp6_ = block;
	vala_genie_parser_parse_statements (self, _tmp6_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (block);
			return NULL;
		} else {
			_vala_code_node_unref0 (block);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DEDENT)) {
		ValaCodeContext* _tmp7_;
		ValaReport* _tmp8_;
		ValaReport* _tmp9_;
		_tmp7_ = self->priv->context;
		_tmp8_ = vala_code_context_get_report (_tmp7_);
		_tmp9_ = _tmp8_;
		if (vala_report_get_errors (_tmp9_) == 0) {
			ValaSourceReference* _tmp10_;
			ValaSourceReference* _tmp11_;
			_tmp10_ = vala_genie_parser_get_current_src (self);
			_tmp11_ = _tmp10_;
			vala_report_error (_tmp11_, "tab indentation is incorrect");
			_vala_source_reference_unref0 (_tmp11_);
		}
	}
	_tmp12_ = block;
	_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_genie_parser_get_current_src (self);
	_tmp16_ = _tmp15_;
	vala_source_reference_get_end (_tmp16_, &_tmp17_);
	_tmp18_ = _tmp17_;
	vala_source_reference_set_end (_tmp14_, &_tmp18_);
	_vala_source_reference_unref0 (_tmp16_);
	result = block;
	return result;
}

static ValaStatement*
vala_genie_parser_parse_empty_statement (ValaGenieParser* self,
                                         GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaEmptyStatement* _tmp4_;
	ValaStatement* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_PASS);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_SEMICOLON);
	vala_genie_parser_expect_terminator (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = begin;
	_tmp2_ = vala_genie_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_empty_statement_new (_tmp3_);
	_tmp5_ = (ValaStatement*) _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static void
vala_genie_parser_parse_type_inference_declaration (ValaGenieParser* self,
                                                    ValaBlock* block,
                                                    GError** error)
{
	gboolean block_var = FALSE;
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_VAR, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	block_var = FALSE;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
		_tmp0_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		block_var = TRUE;
	}
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			gchar* s = NULL;
			gchar* _tmp3_;
			ValaLocalVariable* local = NULL;
			const gchar* _tmp4_;
			ValaLocalVariable* _tmp5_;
			ValaLocalVariable* _tmp6_;
			ValaLocalVariable* _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			ValaDeclarationStatement* _tmp10_;
			ValaDeclarationStatement* _tmp11_;
			if (!_tmp1_) {
				gboolean _tmp2_ = FALSE;
				if (block_var) {
					_tmp2_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT;
				} else {
					_tmp2_ = FALSE;
				}
				if (!_tmp2_) {
					break;
				}
			}
			_tmp1_ = FALSE;
			_tmp3_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
			s = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp4_ = s;
			_tmp5_ = vala_genie_parser_parse_local_variable (self, NULL, _tmp4_, TRUE, &_inner_error0_);
			local = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (s);
					return;
				} else {
					_g_free0 (s);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp6_ = local;
			_tmp7_ = local;
			_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_declaration_statement_new ((ValaSymbol*) _tmp6_, _tmp9_);
			_tmp11_ = _tmp10_;
			vala_block_add_statement (block, (ValaStatement*) _tmp11_);
			_vala_code_node_unref0 (_tmp11_);
			_vala_code_node_unref0 (local);
			_g_free0 (s);
		}
	}
	if (block_var) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
}

static void
vala_genie_parser_parse_local_variable_declarations (ValaGenieParser* self,
                                                     ValaBlock* block,
                                                     GError** error)
{
	ValaArrayList* id_list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	ValaArrayList* _tmp4_;
	ValaDataType* variable_type = NULL;
	ValaDataType* _tmp8_;
	ValaDataType* type = NULL;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaIterator* iterator = NULL;
	ValaArrayList* _tmp11_;
	ValaIterator* _tmp12_;
	ValaIterator* _tmp13_;
	gboolean expect_terminator = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_);
	id_list = _tmp1_;
	_tmp3_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
	_tmp2_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_iterable_unref0 (id_list);
			return;
		} else {
			_vala_iterable_unref0 (id_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp4_ = id_list;
	vala_collection_add ((ValaCollection*) _tmp4_, _tmp2_);
	while (TRUE) {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		ValaArrayList* _tmp7_;
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
			break;
		}
		_tmp6_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
		_tmp5_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (_tmp2_);
				_vala_iterable_unref0 (id_list);
				return;
			} else {
				_g_free0 (_tmp2_);
				_vala_iterable_unref0 (id_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp7_ = id_list;
		vala_collection_add ((ValaCollection*) _tmp7_, _tmp5_);
		_g_free0 (_tmp5_);
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp2_);
			_vala_iterable_unref0 (id_list);
			return;
		} else {
			_g_free0 (_tmp2_);
			_vala_iterable_unref0 (id_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp8_ = vala_genie_parser_parse_type (self, TRUE, TRUE, &_inner_error0_);
	variable_type = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp2_);
			_vala_iterable_unref0 (id_list);
			return;
		} else {
			_g_free0 (_tmp2_);
			_vala_iterable_unref0 (id_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp9_ = variable_type;
	_tmp10_ = vala_genie_parser_parse_inline_array_type (self, _tmp9_, &_inner_error0_);
	type = _tmp10_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (variable_type);
			_g_free0 (_tmp2_);
			_vala_iterable_unref0 (id_list);
			return;
		} else {
			_vala_code_node_unref0 (variable_type);
			_g_free0 (_tmp2_);
			_vala_iterable_unref0 (id_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp11_ = id_list;
	_tmp12_ = vala_iterable_iterator ((ValaIterable*) _tmp11_);
	iterator = _tmp12_;
	_tmp13_ = iterator;
	vala_iterator_next (_tmp13_);
	expect_terminator = FALSE;
	while (TRUE) {
		gchar* id = NULL;
		ValaIterator* _tmp14_;
		gpointer _tmp15_;
		ValaDataType* type_copy = NULL;
		ValaDataType* _tmp16_;
		ValaIterator* _tmp19_;
		ValaLocalVariable* local = NULL;
		ValaDataType* _tmp20_;
		const gchar* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaLocalVariable* _tmp23_;
		ValaLocalVariable* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaDeclarationStatement* _tmp27_;
		ValaDeclarationStatement* _tmp28_;
		if (!(!expect_terminator)) {
			break;
		}
		_tmp14_ = iterator;
		_tmp15_ = vala_iterator_get (_tmp14_);
		id = (gchar*) _tmp15_;
		type_copy = NULL;
		_tmp16_ = type;
		if (_tmp16_ != NULL) {
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			_tmp17_ = type;
			_tmp18_ = vala_data_type_copy (_tmp17_);
			_vala_code_node_unref0 (type_copy);
			type_copy = _tmp18_;
		}
		_tmp19_ = iterator;
		if (!vala_iterator_next (_tmp19_)) {
			expect_terminator = TRUE;
		}
		_tmp20_ = type_copy;
		_tmp21_ = id;
		_tmp22_ = vala_genie_parser_parse_local_variable (self, _tmp20_, _tmp21_, expect_terminator, &_inner_error0_);
		local = _tmp22_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (type_copy);
				_g_free0 (id);
				_vala_iterator_unref0 (iterator);
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (variable_type);
				_g_free0 (_tmp2_);
				_vala_iterable_unref0 (id_list);
				return;
			} else {
				_vala_code_node_unref0 (type_copy);
				_g_free0 (id);
				_vala_iterator_unref0 (iterator);
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (variable_type);
				_g_free0 (_tmp2_);
				_vala_iterable_unref0 (id_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp23_ = local;
		_tmp24_ = local;
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp26_);
		_tmp28_ = _tmp27_;
		vala_block_add_statement (block, (ValaStatement*) _tmp28_);
		_vala_code_node_unref0 (_tmp28_);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (type_copy);
		_g_free0 (id);
	}
	_vala_iterator_unref0 (iterator);
	_vala_code_node_unref0 (type);
	_vala_code_node_unref0 (variable_type);
	_g_free0 (_tmp2_);
	_vala_iterable_unref0 (id_list);
}

static ValaLocalVariable*
vala_genie_parser_parse_local_variable (ValaGenieParser* self,
                                        ValaDataType* variable_type,
                                        const gchar* id,
                                        gboolean expect_terminator,
                                        GError** error)
{
	ValaLocalVariable* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* initializer = NULL;
	ValaExpression* _tmp7_;
	ValaSourceLocation _tmp8_;
	ValaSourceReference* _tmp9_;
	ValaSourceReference* _tmp10_;
	ValaLocalVariable* _tmp11_;
	ValaLocalVariable* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	initializer = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		if (expect_terminator) {
			ValaExpression* _tmp1_ = NULL;
			ValaExpression* _tmp2_;
			ValaExpression* _tmp3_;
			_tmp2_ = vala_genie_parser_parse_expression_with_terminator (self, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (initializer);
					return NULL;
				} else {
					_vala_code_node_unref0 (initializer);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_vala_code_node_unref0 (initializer);
			initializer = _tmp3_;
			_vala_code_node_unref0 (_tmp1_);
		} else {
			ValaExpression* _tmp4_ = NULL;
			ValaExpression* _tmp5_;
			ValaExpression* _tmp6_;
			_tmp5_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
			_tmp4_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (initializer);
					return NULL;
				} else {
					_vala_code_node_unref0 (initializer);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp6_ = _tmp4_;
			_tmp4_ = NULL;
			_vala_code_node_unref0 (initializer);
			initializer = _tmp6_;
			_vala_code_node_unref0 (_tmp4_);
		}
	} else {
		if (expect_terminator) {
			vala_genie_parser_expect_terminator (self, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (initializer);
					return NULL;
				} else {
					_vala_code_node_unref0 (initializer);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	}
	_tmp7_ = initializer;
	_tmp8_ = begin;
	_tmp9_ = vala_genie_parser_get_src (self, &_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_local_variable_new (variable_type, id, _tmp7_, _tmp10_);
	_tmp12_ = _tmp11_;
	_vala_source_reference_unref0 (_tmp10_);
	result = _tmp12_;
	_vala_code_node_unref0 (initializer);
	return result;
}

static ValaStatement*
vala_genie_parser_parse_expression_statement (ValaGenieParser* self,
                                              GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* expr = NULL;
	ValaExpression* _tmp1_;
	ValaSourceLocation _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaExpressionStatement* _tmp5_;
	ValaStatement* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_genie_parser_parse_expression_with_terminator (self, &_inner_error0_);
	expr = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = begin;
	_tmp3_ = vala_genie_parser_get_src (self, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_expression_statement_new (expr, _tmp4_);
	_tmp6_ = (ValaStatement*) _tmp5_;
	_vala_source_reference_unref0 (_tmp4_);
	result = _tmp6_;
	_vala_code_node_unref0 (expr);
	return result;
}

static ValaExpression*
vala_genie_parser_parse_statement_expression (ValaGenieParser* self,
                                              GError** error)
{
	ValaExpression* result = NULL;
	ValaExpression* expr = NULL;
	ValaExpression* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
	expr = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = expr;
	return result;
}

static ValaStatement*
vala_genie_parser_parse_if_statement (ValaGenieParser* self,
                                      GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* condition = NULL;
	ValaExpression* _tmp1_;
	ValaSourceReference* src = NULL;
	ValaSourceLocation _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaBlock* true_stmt = NULL;
	ValaBlock* _tmp4_;
	ValaBlock* false_stmt = NULL;
	ValaExpression* _tmp9_;
	ValaBlock* _tmp10_;
	ValaBlock* _tmp11_;
	ValaSourceReference* _tmp12_;
	ValaIfStatement* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_IF, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
	condition = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DO)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (condition);
				return NULL;
			} else {
				_vala_code_node_unref0 (condition);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	} else {
		vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
	}
	_tmp2_ = begin;
	_tmp3_ = vala_genie_parser_get_src (self, &_tmp2_);
	src = _tmp3_;
	_tmp4_ = vala_genie_parser_parse_embedded_statement (self, &_inner_error0_);
	true_stmt = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_source_reference_unref0 (src);
			_vala_code_node_unref0 (condition);
			return NULL;
		} else {
			_vala_source_reference_unref0 (src);
			_vala_code_node_unref0 (condition);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	false_stmt = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ELSE)) {
		gboolean _tmp5_ = FALSE;
		ValaBlock* _tmp6_ = NULL;
		ValaBlock* _tmp7_;
		ValaBlock* _tmp8_;
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DO)) {
			_tmp5_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_IF;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (false_stmt);
					_vala_code_node_unref0 (true_stmt);
					_vala_source_reference_unref0 (src);
					_vala_code_node_unref0 (condition);
					return NULL;
				} else {
					_vala_code_node_unref0 (false_stmt);
					_vala_code_node_unref0 (true_stmt);
					_vala_source_reference_unref0 (src);
					_vala_code_node_unref0 (condition);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		} else {
			vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
		}
		_tmp7_ = vala_genie_parser_parse_embedded_statement (self, &_inner_error0_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (false_stmt);
				_vala_code_node_unref0 (true_stmt);
				_vala_source_reference_unref0 (src);
				_vala_code_node_unref0 (condition);
				return NULL;
			} else {
				_vala_code_node_unref0 (false_stmt);
				_vala_code_node_unref0 (true_stmt);
				_vala_source_reference_unref0 (src);
				_vala_code_node_unref0 (condition);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp8_ = _tmp6_;
		_tmp6_ = NULL;
		_vala_code_node_unref0 (false_stmt);
		false_stmt = _tmp8_;
		_vala_code_node_unref0 (_tmp6_);
	}
	_tmp9_ = condition;
	_tmp10_ = true_stmt;
	_tmp11_ = false_stmt;
	_tmp12_ = src;
	_tmp13_ = vala_if_statement_new (_tmp9_, _tmp10_, _tmp11_, _tmp12_);
	result = (ValaStatement*) _tmp13_;
	_vala_code_node_unref0 (false_stmt);
	_vala_code_node_unref0 (true_stmt);
	_vala_source_reference_unref0 (src);
	_vala_code_node_unref0 (condition);
	return result;
}

static ValaStatement*
vala_genie_parser_parse_switch_statement (ValaGenieParser* self,
                                          GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* condition = NULL;
	ValaExpression* _tmp1_;
	ValaSwitchStatement* stmt = NULL;
	ValaExpression* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSwitchStatement* _tmp6_;
	ValaSwitchStatement* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CASE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
	condition = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (condition);
			return NULL;
		} else {
			_vala_code_node_unref0 (condition);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = condition;
	_tmp3_ = begin;
	_tmp4_ = vala_genie_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_switch_statement_new (_tmp2_, _tmp5_);
	_tmp7_ = _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	stmt = _tmp7_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (condition);
			return NULL;
		} else {
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (condition);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaSwitchSection* section = NULL;
		ValaSourceLocation _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaSwitchSection* _tmp11_;
		ValaSwitchSection* _tmp12_;
		ValaSwitchSection* _tmp28_;
		ValaBreakStatement* break_stmt = NULL;
		ValaSourceLocation _tmp29_;
		ValaSourceReference* _tmp30_;
		ValaSourceReference* _tmp31_;
		ValaBreakStatement* _tmp32_;
		ValaBreakStatement* _tmp33_;
		ValaSwitchSection* _tmp34_;
		ValaBreakStatement* _tmp35_;
		ValaSwitchStatement* _tmp36_;
		ValaSwitchSection* _tmp37_;
		if (!(vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT)) {
			break;
		}
		_tmp8_ = begin;
		_tmp9_ = vala_genie_parser_get_src (self, &_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_switch_section_new (_tmp10_);
		_tmp12_ = _tmp11_;
		_vala_source_reference_unref0 (_tmp10_);
		section = _tmp12_;
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_WHEN)) {
			{
				gboolean _tmp13_ = FALSE;
				_tmp13_ = TRUE;
				while (TRUE) {
					ValaExpression* _tmp14_ = NULL;
					ValaExpression* _tmp15_;
					ValaSwitchSection* _tmp16_;
					ValaSourceLocation _tmp17_;
					ValaSourceReference* _tmp18_;
					ValaSourceReference* _tmp19_;
					ValaSwitchLabel* _tmp20_;
					ValaSwitchLabel* _tmp21_;
					if (!_tmp13_) {
						if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
							break;
						}
					}
					_tmp13_ = FALSE;
					_tmp15_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
					_tmp14_ = _tmp15_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_vala_code_node_unref0 (section);
							_vala_code_node_unref0 (stmt);
							_vala_code_node_unref0 (condition);
							return NULL;
						} else {
							_vala_code_node_unref0 (section);
							_vala_code_node_unref0 (stmt);
							_vala_code_node_unref0 (condition);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp16_ = section;
					_tmp17_ = begin;
					_tmp18_ = vala_genie_parser_get_src (self, &_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = vala_switch_label_new (_tmp14_, _tmp19_);
					_tmp21_ = _tmp20_;
					vala_switch_section_add_label (_tmp16_, _tmp21_);
					_vala_code_node_unref0 (_tmp21_);
					_vala_source_reference_unref0 (_tmp19_);
					_vala_code_node_unref0 (_tmp14_);
				}
			}
		} else {
			ValaSwitchSection* _tmp22_;
			ValaSourceLocation _tmp23_;
			ValaSourceReference* _tmp24_;
			ValaSourceReference* _tmp25_;
			ValaSwitchLabel* _tmp26_;
			ValaSwitchLabel* _tmp27_;
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEFAULT, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (section);
					_vala_code_node_unref0 (stmt);
					_vala_code_node_unref0 (condition);
					return NULL;
				} else {
					_vala_code_node_unref0 (section);
					_vala_code_node_unref0 (stmt);
					_vala_code_node_unref0 (condition);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp22_ = section;
			_tmp23_ = begin;
			_tmp24_ = vala_genie_parser_get_src (self, &_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_switch_label_new_with_default (_tmp25_);
			_tmp27_ = _tmp26_;
			vala_switch_section_add_label (_tmp22_, _tmp27_);
			_vala_code_node_unref0 (_tmp27_);
			_vala_source_reference_unref0 (_tmp25_);
		}
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DO, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (section);
					_vala_code_node_unref0 (stmt);
					_vala_code_node_unref0 (condition);
					return NULL;
				} else {
					_vala_code_node_unref0 (section);
					_vala_code_node_unref0 (stmt);
					_vala_code_node_unref0 (condition);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
		_tmp28_ = section;
		vala_genie_parser_parse_statements (self, (ValaBlock*) _tmp28_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (section);
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (condition);
				return NULL;
			} else {
				_vala_code_node_unref0 (section);
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (condition);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp29_ = begin;
		_tmp30_ = vala_genie_parser_get_src (self, &_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_break_statement_new (_tmp31_);
		_tmp33_ = _tmp32_;
		_vala_source_reference_unref0 (_tmp31_);
		break_stmt = _tmp33_;
		_tmp34_ = section;
		_tmp35_ = break_stmt;
		vala_block_add_statement ((ValaBlock*) _tmp34_, (ValaStatement*) _tmp35_);
		_tmp36_ = stmt;
		_tmp37_ = section;
		vala_switch_statement_add_section (_tmp36_, _tmp37_);
		_vala_code_node_unref0 (break_stmt);
		_vala_code_node_unref0 (section);
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (condition);
			return NULL;
		} else {
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (condition);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = (ValaStatement*) stmt;
	_vala_code_node_unref0 (condition);
	return result;
}

static ValaStatement*
vala_genie_parser_parse_while_statement (ValaGenieParser* self,
                                         GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* condition = NULL;
	ValaExpression* _tmp1_;
	ValaBlock* body = NULL;
	ValaBlock* _tmp2_;
	ValaExpression* _tmp3_;
	ValaBlock* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaWhileStatement* _tmp8_;
	ValaStatement* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_WHILE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
	condition = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DO)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (condition);
				return NULL;
			} else {
				_vala_code_node_unref0 (condition);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	} else {
		vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
	}
	_tmp2_ = vala_genie_parser_parse_embedded_statement (self, &_inner_error0_);
	body = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (condition);
			return NULL;
		} else {
			_vala_code_node_unref0 (condition);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = condition;
	_tmp4_ = body;
	_tmp5_ = begin;
	_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_while_statement_new (_tmp3_, _tmp4_, _tmp7_);
	_tmp9_ = (ValaStatement*) _tmp8_;
	_vala_source_reference_unref0 (_tmp7_);
	result = _tmp9_;
	_vala_code_node_unref0 (body);
	_vala_code_node_unref0 (condition);
	return result;
}

static ValaStatement*
vala_genie_parser_parse_do_statement (ValaGenieParser* self,
                                      GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaBlock* body = NULL;
	ValaBlock* _tmp1_;
	ValaExpression* condition = NULL;
	ValaExpression* _tmp2_;
	ValaBlock* _tmp3_;
	ValaExpression* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaDoStatement* _tmp8_;
	ValaStatement* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DO, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = vala_genie_parser_parse_embedded_statement (self, &_inner_error0_);
	body = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_WHILE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (body);
			return NULL;
		} else {
			_vala_code_node_unref0 (body);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
	condition = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (body);
			return NULL;
		} else {
			_vala_code_node_unref0 (body);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect_terminator (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (condition);
			_vala_code_node_unref0 (body);
			return NULL;
		} else {
			_vala_code_node_unref0 (condition);
			_vala_code_node_unref0 (body);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = body;
	_tmp4_ = condition;
	_tmp5_ = begin;
	_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_do_statement_new (_tmp3_, _tmp4_, _tmp7_);
	_tmp9_ = (ValaStatement*) _tmp8_;
	_vala_source_reference_unref0 (_tmp7_);
	result = _tmp9_;
	_vala_code_node_unref0 (condition);
	_vala_code_node_unref0 (body);
	return result;
}

static ValaStatement*
vala_genie_parser_parse_for_statement (ValaGenieParser* self,
                                       GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaBlock* block = NULL;
	ValaExpression* initializer = NULL;
	ValaExpression* condition = NULL;
	ValaExpression* iterator = NULL;
	gboolean is_expr = FALSE;
	gchar* id = NULL;
	ValaSourceReference* src = NULL;
	ValaSourceLocation _tmp63_;
	ValaSourceReference* _tmp64_;
	ValaBlock* body = NULL;
	ValaBlock* _tmp65_;
	ValaForStatement* stmt = NULL;
	ValaExpression* _tmp66_;
	ValaBlock* _tmp67_;
	ValaSourceReference* _tmp68_;
	ValaForStatement* _tmp69_;
	ValaExpression* _tmp70_;
	ValaForStatement* _tmp73_;
	ValaExpression* _tmp74_;
	ValaBlock* _tmp75_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	block = NULL;
	initializer = NULL;
	condition = NULL;
	iterator = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_FOR, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (id);
			_vala_code_node_unref0 (iterator);
			_vala_code_node_unref0 (condition);
			_vala_code_node_unref0 (initializer);
			_vala_code_node_unref0 (block);
			return NULL;
		} else {
			_g_free0 (id);
			_vala_code_node_unref0 (iterator);
			_vala_code_node_unref0 (condition);
			_vala_code_node_unref0 (initializer);
			_vala_code_node_unref0 (block);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	switch (vala_genie_parser_current (self)) {
		case VALA_GENIE_TOKEN_TYPE_VAR:
		{
			is_expr = FALSE;
			break;
		}
		default:
		{
			gboolean local_is_expr = FALSE;
			local_is_expr = vala_genie_parser_is_expression (self, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (id);
					_vala_code_node_unref0 (iterator);
					_vala_code_node_unref0 (condition);
					_vala_code_node_unref0 (initializer);
					_vala_code_node_unref0 (block);
					return NULL;
				} else {
					_g_free0 (id);
					_vala_code_node_unref0 (iterator);
					_vala_code_node_unref0 (condition);
					_vala_code_node_unref0 (initializer);
					_vala_code_node_unref0 (block);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			is_expr = local_is_expr;
			break;
		}
	}
	if (is_expr) {
		ValaSourceLocation expr_begin = {0};
		ValaSourceLocation _tmp1_ = {0};
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		ValaSourceLocation _tmp5_;
		ValaExpression* _tmp6_ = NULL;
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		vala_genie_parser_get_location (self, &_tmp1_);
		expr_begin = _tmp1_;
		_tmp3_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (id);
				_vala_code_node_unref0 (iterator);
				_vala_code_node_unref0 (condition);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (block);
				return NULL;
			} else {
				_g_free0 (id);
				_vala_code_node_unref0 (iterator);
				_vala_code_node_unref0 (condition);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (block);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_free0 (id);
		id = _tmp4_;
		_tmp5_ = expr_begin;
		vala_genie_parser_rollback (self, &_tmp5_);
		_tmp7_ = vala_genie_parser_parse_statement_expression (self, &_inner_error0_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (_tmp2_);
				_g_free0 (id);
				_vala_code_node_unref0 (iterator);
				_vala_code_node_unref0 (condition);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (block);
				return NULL;
			} else {
				_g_free0 (_tmp2_);
				_g_free0 (id);
				_vala_code_node_unref0 (iterator);
				_vala_code_node_unref0 (condition);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (block);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp8_ = _tmp6_;
		_tmp6_ = NULL;
		_vala_code_node_unref0 (initializer);
		initializer = _tmp8_;
		_vala_code_node_unref0 (_tmp6_);
		_g_free0 (_tmp2_);
	} else {
		ValaSourceLocation _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaBlock* _tmp12_;
		ValaDataType* variable_type = NULL;
		ValaDataType* type_copy = NULL;
		ValaDataType* _tmp22_;
		ValaLocalVariable* local = NULL;
		ValaDataType* _tmp25_;
		const gchar* _tmp26_;
		ValaLocalVariable* _tmp27_;
		ValaBlock* _tmp28_;
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaSourceReference* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaDeclarationStatement* _tmp33_;
		ValaDeclarationStatement* _tmp34_;
		_tmp9_ = begin;
		_tmp10_ = vala_genie_parser_get_src (self, &_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_block_new (_tmp11_);
		_vala_code_node_unref0 (block);
		block = _tmp12_;
		_vala_source_reference_unref0 (_tmp11_);
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_VAR)) {
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_vala_code_node_unref0 (variable_type);
			variable_type = NULL;
			_tmp14_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
			_tmp13_ = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (variable_type);
					_g_free0 (id);
					_vala_code_node_unref0 (iterator);
					_vala_code_node_unref0 (condition);
					_vala_code_node_unref0 (initializer);
					_vala_code_node_unref0 (block);
					return NULL;
				} else {
					_vala_code_node_unref0 (variable_type);
					_g_free0 (id);
					_vala_code_node_unref0 (iterator);
					_vala_code_node_unref0 (condition);
					_vala_code_node_unref0 (initializer);
					_vala_code_node_unref0 (block);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp15_ = _tmp13_;
			_tmp13_ = NULL;
			_g_free0 (id);
			id = _tmp15_;
			_g_free0 (_tmp13_);
		} else {
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			gchar* _tmp18_;
			ValaDataType* _tmp19_ = NULL;
			ValaDataType* _tmp20_;
			ValaDataType* _tmp21_;
			_tmp17_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
			_tmp16_ = _tmp17_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (variable_type);
					_g_free0 (id);
					_vala_code_node_unref0 (iterator);
					_vala_code_node_unref0 (condition);
					_vala_code_node_unref0 (initializer);
					_vala_code_node_unref0 (block);
					return NULL;
				} else {
					_vala_code_node_unref0 (variable_type);
					_g_free0 (id);
					_vala_code_node_unref0 (iterator);
					_vala_code_node_unref0 (condition);
					_vala_code_node_unref0 (initializer);
					_vala_code_node_unref0 (block);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp18_ = _tmp16_;
			_tmp16_ = NULL;
			_g_free0 (id);
			id = _tmp18_;
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (_tmp16_);
					_vala_code_node_unref0 (variable_type);
					_g_free0 (id);
					_vala_code_node_unref0 (iterator);
					_vala_code_node_unref0 (condition);
					_vala_code_node_unref0 (initializer);
					_vala_code_node_unref0 (block);
					return NULL;
				} else {
					_g_free0 (_tmp16_);
					_vala_code_node_unref0 (variable_type);
					_g_free0 (id);
					_vala_code_node_unref0 (iterator);
					_vala_code_node_unref0 (condition);
					_vala_code_node_unref0 (initializer);
					_vala_code_node_unref0 (block);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp20_ = vala_genie_parser_parse_type (self, TRUE, TRUE, &_inner_error0_);
			_tmp19_ = _tmp20_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (_tmp16_);
					_vala_code_node_unref0 (variable_type);
					_g_free0 (id);
					_vala_code_node_unref0 (iterator);
					_vala_code_node_unref0 (condition);
					_vala_code_node_unref0 (initializer);
					_vala_code_node_unref0 (block);
					return NULL;
				} else {
					_g_free0 (_tmp16_);
					_vala_code_node_unref0 (variable_type);
					_g_free0 (id);
					_vala_code_node_unref0 (iterator);
					_vala_code_node_unref0 (condition);
					_vala_code_node_unref0 (initializer);
					_vala_code_node_unref0 (block);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp21_ = _tmp19_;
			_tmp19_ = NULL;
			_vala_code_node_unref0 (variable_type);
			variable_type = _tmp21_;
			_vala_code_node_unref0 (_tmp19_);
			_g_free0 (_tmp16_);
		}
		type_copy = NULL;
		_tmp22_ = variable_type;
		if (_tmp22_ != NULL) {
			ValaDataType* _tmp23_;
			ValaDataType* _tmp24_;
			_tmp23_ = variable_type;
			_tmp24_ = vala_data_type_copy (_tmp23_);
			_vala_code_node_unref0 (type_copy);
			type_copy = _tmp24_;
		}
		_tmp25_ = type_copy;
		_tmp26_ = id;
		_tmp27_ = vala_genie_parser_parse_local_variable (self, _tmp25_, _tmp26_, FALSE, &_inner_error0_);
		local = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (type_copy);
				_vala_code_node_unref0 (variable_type);
				_g_free0 (id);
				_vala_code_node_unref0 (iterator);
				_vala_code_node_unref0 (condition);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (block);
				return NULL;
			} else {
				_vala_code_node_unref0 (type_copy);
				_vala_code_node_unref0 (variable_type);
				_g_free0 (id);
				_vala_code_node_unref0 (iterator);
				_vala_code_node_unref0 (condition);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (block);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp28_ = block;
		_tmp29_ = local;
		_tmp30_ = local;
		_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_declaration_statement_new ((ValaSymbol*) _tmp29_, _tmp32_);
		_tmp34_ = _tmp33_;
		vala_block_add_statement (_tmp28_, (ValaStatement*) _tmp34_);
		_vala_code_node_unref0 (_tmp34_);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (type_copy);
		_vala_code_node_unref0 (variable_type);
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_TO)) {
		ValaSourceLocation to_begin = {0};
		ValaSourceLocation _tmp35_ = {0};
		ValaSourceReference* to_src = NULL;
		ValaSourceLocation _tmp36_;
		ValaSourceReference* _tmp37_;
		ValaMemberAccess* left = NULL;
		const gchar* _tmp38_;
		ValaSourceReference* _tmp39_;
		ValaMemberAccess* _tmp40_;
		ValaExpression* right = NULL;
		ValaExpression* _tmp41_;
		ValaMemberAccess* _tmp42_;
		ValaExpression* _tmp43_;
		ValaSourceReference* _tmp44_;
		ValaBinaryExpression* _tmp45_;
		ValaMemberAccess* _tmp46_;
		ValaSourceReference* _tmp47_;
		ValaPostfixExpression* _tmp48_;
		vala_genie_parser_get_location (self, &_tmp35_);
		to_begin = _tmp35_;
		_tmp36_ = to_begin;
		_tmp37_ = vala_genie_parser_get_src (self, &_tmp36_);
		to_src = _tmp37_;
		_tmp38_ = id;
		_tmp39_ = to_src;
		_tmp40_ = vala_member_access_new (NULL, _tmp38_, _tmp39_);
		left = _tmp40_;
		_tmp41_ = vala_genie_parser_parse_primary_expression (self, &_inner_error0_);
		right = _tmp41_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (left);
				_vala_source_reference_unref0 (to_src);
				_g_free0 (id);
				_vala_code_node_unref0 (iterator);
				_vala_code_node_unref0 (condition);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (block);
				return NULL;
			} else {
				_vala_code_node_unref0 (left);
				_vala_source_reference_unref0 (to_src);
				_g_free0 (id);
				_vala_code_node_unref0 (iterator);
				_vala_code_node_unref0 (condition);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (block);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp42_ = left;
		_tmp43_ = right;
		_tmp44_ = to_src;
		_tmp45_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL, (ValaExpression*) _tmp42_, _tmp43_, _tmp44_);
		_vala_code_node_unref0 (condition);
		condition = (ValaExpression*) _tmp45_;
		_tmp46_ = left;
		_tmp47_ = to_src;
		_tmp48_ = vala_postfix_expression_new ((ValaExpression*) _tmp46_, TRUE, _tmp47_);
		_vala_code_node_unref0 (iterator);
		iterator = (ValaExpression*) _tmp48_;
		_vala_code_node_unref0 (right);
		_vala_code_node_unref0 (left);
		_vala_source_reference_unref0 (to_src);
	} else {
		ValaSourceLocation downto_begin = {0};
		ValaSourceLocation _tmp49_ = {0};
		ValaSourceReference* downto_src = NULL;
		ValaSourceLocation _tmp50_;
		ValaSourceReference* _tmp51_;
		ValaMemberAccess* left = NULL;
		const gchar* _tmp52_;
		ValaSourceReference* _tmp53_;
		ValaMemberAccess* _tmp54_;
		ValaExpression* right = NULL;
		ValaExpression* _tmp55_;
		ValaMemberAccess* _tmp56_;
		ValaExpression* _tmp57_;
		ValaSourceReference* _tmp58_;
		ValaBinaryExpression* _tmp59_;
		ValaMemberAccess* _tmp60_;
		ValaSourceReference* _tmp61_;
		ValaPostfixExpression* _tmp62_;
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DOWNTO, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (id);
				_vala_code_node_unref0 (iterator);
				_vala_code_node_unref0 (condition);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (block);
				return NULL;
			} else {
				_g_free0 (id);
				_vala_code_node_unref0 (iterator);
				_vala_code_node_unref0 (condition);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (block);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		vala_genie_parser_get_location (self, &_tmp49_);
		downto_begin = _tmp49_;
		_tmp50_ = downto_begin;
		_tmp51_ = vala_genie_parser_get_src (self, &_tmp50_);
		downto_src = _tmp51_;
		_tmp52_ = id;
		_tmp53_ = downto_src;
		_tmp54_ = vala_member_access_new (NULL, _tmp52_, _tmp53_);
		left = _tmp54_;
		_tmp55_ = vala_genie_parser_parse_primary_expression (self, &_inner_error0_);
		right = _tmp55_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (left);
				_vala_source_reference_unref0 (downto_src);
				_g_free0 (id);
				_vala_code_node_unref0 (iterator);
				_vala_code_node_unref0 (condition);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (block);
				return NULL;
			} else {
				_vala_code_node_unref0 (left);
				_vala_source_reference_unref0 (downto_src);
				_g_free0 (id);
				_vala_code_node_unref0 (iterator);
				_vala_code_node_unref0 (condition);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (block);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp56_ = left;
		_tmp57_ = right;
		_tmp58_ = downto_src;
		_tmp59_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, (ValaExpression*) _tmp56_, _tmp57_, _tmp58_);
		_vala_code_node_unref0 (condition);
		condition = (ValaExpression*) _tmp59_;
		_tmp60_ = left;
		_tmp61_ = downto_src;
		_tmp62_ = vala_postfix_expression_new ((ValaExpression*) _tmp60_, FALSE, _tmp61_);
		_vala_code_node_unref0 (iterator);
		iterator = (ValaExpression*) _tmp62_;
		_vala_code_node_unref0 (right);
		_vala_code_node_unref0 (left);
		_vala_source_reference_unref0 (downto_src);
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DO, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (id);
				_vala_code_node_unref0 (iterator);
				_vala_code_node_unref0 (condition);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (block);
				return NULL;
			} else {
				_g_free0 (id);
				_vala_code_node_unref0 (iterator);
				_vala_code_node_unref0 (condition);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (block);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp63_ = begin;
	_tmp64_ = vala_genie_parser_get_src (self, &_tmp63_);
	src = _tmp64_;
	_tmp65_ = vala_genie_parser_parse_embedded_statement (self, &_inner_error0_);
	body = _tmp65_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_source_reference_unref0 (src);
			_g_free0 (id);
			_vala_code_node_unref0 (iterator);
			_vala_code_node_unref0 (condition);
			_vala_code_node_unref0 (initializer);
			_vala_code_node_unref0 (block);
			return NULL;
		} else {
			_vala_source_reference_unref0 (src);
			_g_free0 (id);
			_vala_code_node_unref0 (iterator);
			_vala_code_node_unref0 (condition);
			_vala_code_node_unref0 (initializer);
			_vala_code_node_unref0 (block);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp66_ = condition;
	_tmp67_ = body;
	_tmp68_ = src;
	_tmp69_ = vala_for_statement_new (_tmp66_, _tmp67_, _tmp68_);
	stmt = _tmp69_;
	_tmp70_ = initializer;
	if (_tmp70_ != NULL) {
		ValaForStatement* _tmp71_;
		ValaExpression* _tmp72_;
		_tmp71_ = stmt;
		_tmp72_ = initializer;
		vala_for_statement_add_initializer (_tmp71_, _tmp72_);
	}
	_tmp73_ = stmt;
	_tmp74_ = iterator;
	vala_for_statement_add_iterator (_tmp73_, _tmp74_);
	_tmp75_ = block;
	if (_tmp75_ != NULL) {
		ValaBlock* _tmp76_;
		ValaForStatement* _tmp77_;
		_tmp76_ = block;
		_tmp77_ = stmt;
		vala_block_add_statement (_tmp76_, (ValaStatement*) _tmp77_);
		result = (ValaStatement*) block;
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (body);
		_vala_source_reference_unref0 (src);
		_g_free0 (id);
		_vala_code_node_unref0 (iterator);
		_vala_code_node_unref0 (condition);
		_vala_code_node_unref0 (initializer);
		return result;
	} else {
		result = (ValaStatement*) stmt;
		_vala_code_node_unref0 (body);
		_vala_source_reference_unref0 (src);
		_g_free0 (id);
		_vala_code_node_unref0 (iterator);
		_vala_code_node_unref0 (condition);
		_vala_code_node_unref0 (initializer);
		_vala_code_node_unref0 (block);
		return result;
	}
	_vala_code_node_unref0 (stmt);
	_vala_code_node_unref0 (body);
	_vala_source_reference_unref0 (src);
	_g_free0 (id);
	_vala_code_node_unref0 (iterator);
	_vala_code_node_unref0 (condition);
	_vala_code_node_unref0 (initializer);
	_vala_code_node_unref0 (block);
}

static ValaStatement*
vala_genie_parser_parse_foreach_statement (ValaGenieParser* self,
                                           GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaDataType* type = NULL;
	gchar* id = NULL;
	ValaExpression* collection = NULL;
	ValaExpression* _tmp10_;
	ValaSourceReference* src = NULL;
	ValaSourceLocation _tmp11_;
	ValaSourceReference* _tmp12_;
	ValaBlock* body = NULL;
	ValaBlock* _tmp13_;
	ValaDataType* _tmp14_;
	const gchar* _tmp15_;
	ValaExpression* _tmp16_;
	ValaBlock* _tmp17_;
	ValaSourceReference* _tmp18_;
	ValaForeachStatement* _tmp19_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	type = NULL;
	id = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_FOR, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_VAR)) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (id);
		id = _tmp3_;
		_g_free0 (_tmp1_);
	} else {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp6_ = _tmp4_;
		_tmp4_ = NULL;
		_g_free0 (id);
		id = _tmp6_;
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
			ValaDataType* _tmp7_ = NULL;
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			_tmp8_ = vala_genie_parser_parse_type (self, TRUE, TRUE, &_inner_error0_);
			_tmp7_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (_tmp4_);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					return NULL;
				} else {
					_g_free0 (_tmp4_);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp9_ = _tmp7_;
			_tmp7_ = NULL;
			_vala_code_node_unref0 (type);
			type = _tmp9_;
			_vala_code_node_unref0 (_tmp7_);
		}
		_g_free0 (_tmp4_);
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_IN, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp10_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
	collection = _tmp10_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DO, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (collection);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_code_node_unref0 (collection);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp11_ = begin;
	_tmp12_ = vala_genie_parser_get_src (self, &_tmp11_);
	src = _tmp12_;
	_tmp13_ = vala_genie_parser_parse_embedded_statement (self, &_inner_error0_);
	body = _tmp13_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_source_reference_unref0 (src);
			_vala_code_node_unref0 (collection);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_source_reference_unref0 (src);
			_vala_code_node_unref0 (collection);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp14_ = type;
	_tmp15_ = id;
	_tmp16_ = collection;
	_tmp17_ = body;
	_tmp18_ = src;
	_tmp19_ = vala_foreach_statement_new (_tmp14_, _tmp15_, _tmp16_, _tmp17_, _tmp18_);
	result = (ValaStatement*) _tmp19_;
	_vala_code_node_unref0 (body);
	_vala_source_reference_unref0 (src);
	_vala_code_node_unref0 (collection);
	_g_free0 (id);
	_vala_code_node_unref0 (type);
	return result;
}

static ValaStatement*
vala_genie_parser_parse_break_statement (ValaGenieParser* self,
                                         GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaBreakStatement* _tmp4_;
	ValaStatement* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_BREAK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect_terminator (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = begin;
	_tmp2_ = vala_genie_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_break_statement_new (_tmp3_);
	_tmp5_ = (ValaStatement*) _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static ValaStatement*
vala_genie_parser_parse_continue_statement (ValaGenieParser* self,
                                            GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaContinueStatement* _tmp4_;
	ValaStatement* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CONTINUE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect_terminator (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = begin;
	_tmp2_ = vala_genie_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_continue_statement_new (_tmp3_);
	_tmp5_ = (ValaStatement*) _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static ValaStatement*
vala_genie_parser_parse_return_statement (ValaGenieParser* self,
                                          GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* expr = NULL;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp5_;
	ValaSourceLocation _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaSourceReference* _tmp8_;
	ValaReturnStatement* _tmp9_;
	ValaStatement* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_RETURN, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	expr = NULL;
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_SEMICOLON) {
		_tmp1_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaExpression* _tmp2_ = NULL;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_genie_parser_parse_expression_with_terminator (self, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (expr);
				return NULL;
			} else {
				_vala_code_node_unref0 (expr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_vala_code_node_unref0 (expr);
		expr = _tmp4_;
		_vala_code_node_unref0 (_tmp2_);
	} else {
		vala_genie_parser_expect_terminator (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (expr);
				return NULL;
			} else {
				_vala_code_node_unref0 (expr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp5_ = expr;
	_tmp6_ = begin;
	_tmp7_ = vala_genie_parser_get_src (self, &_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_return_statement_new (_tmp5_, _tmp8_);
	_tmp10_ = (ValaStatement*) _tmp9_;
	_vala_source_reference_unref0 (_tmp8_);
	result = _tmp10_;
	_vala_code_node_unref0 (expr);
	return result;
}

static ValaStatement*
vala_genie_parser_parse_yield_statement (ValaGenieParser* self,
                                         GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaYieldStatement* _tmp8_;
	ValaStatement* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_YIELD, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_SEMICOLON) {
		_tmp1_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaStatement* _tmp2_ = NULL;
		ValaStatement* _tmp3_;
		ValaStatement* _tmp4_;
		vala_genie_parser_prev (self);
		_tmp3_ = vala_genie_parser_parse_expression_statement (self, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		result = _tmp4_;
		_vala_code_node_unref0 (_tmp2_);
		return result;
	}
	vala_genie_parser_expect_terminator (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = begin;
	_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_yield_statement_new (_tmp7_);
	_tmp9_ = (ValaStatement*) _tmp8_;
	_vala_source_reference_unref0 (_tmp7_);
	result = _tmp9_;
	return result;
}

static ValaStatement*
vala_genie_parser_parse_throw_statement (ValaGenieParser* self,
                                         GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* expr = NULL;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaThrowStatement* _tmp6_;
	ValaStatement* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_RAISE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
	expr = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect_terminator (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (expr);
			return NULL;
		} else {
			_vala_code_node_unref0 (expr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = expr;
	_tmp3_ = begin;
	_tmp4_ = vala_genie_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_throw_statement_new (_tmp2_, _tmp5_);
	_tmp7_ = (ValaStatement*) _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	result = _tmp7_;
	_vala_code_node_unref0 (expr);
	return result;
}

static ValaStatement*
vala_genie_parser_parse_try_statement (ValaGenieParser* self,
                                       GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaBlock* try_block = NULL;
	ValaBlock* _tmp1_;
	ValaBlock* finally_clause = NULL;
	ValaArrayList* catch_clauses = NULL;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	ValaTryStatement* stmt = NULL;
	ValaBlock* _tmp11_;
	ValaBlock* _tmp12_;
	ValaSourceLocation _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaTryStatement* _tmp16_;
	ValaTryStatement* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_TRY, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = vala_genie_parser_parse_block (self, &_inner_error0_);
	try_block = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	finally_clause = NULL;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_CATCH_CLAUSE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	catch_clauses = _tmp3_;
	if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_EXCEPT) {
		ValaArrayList* _tmp4_;
		_tmp4_ = catch_clauses;
		vala_genie_parser_parse_catch_clauses (self, (ValaList*) _tmp4_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_iterable_unref0 (catch_clauses);
				_vala_code_node_unref0 (finally_clause);
				_vala_code_node_unref0 (try_block);
				return NULL;
			} else {
				_vala_iterable_unref0 (catch_clauses);
				_vala_code_node_unref0 (finally_clause);
				_vala_code_node_unref0 (try_block);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_FINALLY) {
			ValaBlock* _tmp5_ = NULL;
			ValaBlock* _tmp6_;
			ValaBlock* _tmp7_;
			_tmp6_ = vala_genie_parser_parse_finally_clause (self, &_inner_error0_);
			_tmp5_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_iterable_unref0 (catch_clauses);
					_vala_code_node_unref0 (finally_clause);
					_vala_code_node_unref0 (try_block);
					return NULL;
				} else {
					_vala_iterable_unref0 (catch_clauses);
					_vala_code_node_unref0 (finally_clause);
					_vala_code_node_unref0 (try_block);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp7_ = _tmp5_;
			_tmp5_ = NULL;
			_vala_code_node_unref0 (finally_clause);
			finally_clause = _tmp7_;
			_vala_code_node_unref0 (_tmp5_);
		}
	} else {
		ValaBlock* _tmp8_ = NULL;
		ValaBlock* _tmp9_;
		ValaBlock* _tmp10_;
		_tmp9_ = vala_genie_parser_parse_finally_clause (self, &_inner_error0_);
		_tmp8_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_iterable_unref0 (catch_clauses);
				_vala_code_node_unref0 (finally_clause);
				_vala_code_node_unref0 (try_block);
				return NULL;
			} else {
				_vala_iterable_unref0 (catch_clauses);
				_vala_code_node_unref0 (finally_clause);
				_vala_code_node_unref0 (try_block);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp10_ = _tmp8_;
		_tmp8_ = NULL;
		_vala_code_node_unref0 (finally_clause);
		finally_clause = _tmp10_;
		_vala_code_node_unref0 (_tmp8_);
	}
	_tmp11_ = try_block;
	_tmp12_ = finally_clause;
	_tmp13_ = begin;
	_tmp14_ = vala_genie_parser_get_src (self, &_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_try_statement_new (_tmp11_, _tmp12_, _tmp15_);
	_tmp17_ = _tmp16_;
	_vala_source_reference_unref0 (_tmp15_);
	stmt = _tmp17_;
	{
		ValaArrayList* _clause_list = NULL;
		ValaArrayList* _tmp18_;
		ValaArrayList* _tmp19_;
		gint _clause_size = 0;
		ValaArrayList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _clause_index = 0;
		_tmp18_ = catch_clauses;
		_tmp19_ = _vala_iterable_ref0 (_tmp18_);
		_clause_list = _tmp19_;
		_tmp20_ = _clause_list;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_clause_size = _tmp22_;
		_clause_index = -1;
		while (TRUE) {
			ValaCatchClause* clause = NULL;
			ValaArrayList* _tmp23_;
			gpointer _tmp24_;
			ValaTryStatement* _tmp25_;
			ValaCatchClause* _tmp26_;
			_clause_index = _clause_index + 1;
			if (!(_clause_index < _clause_size)) {
				break;
			}
			_tmp23_ = _clause_list;
			_tmp24_ = vala_list_get ((ValaList*) _tmp23_, _clause_index);
			clause = (ValaCatchClause*) _tmp24_;
			_tmp25_ = stmt;
			_tmp26_ = clause;
			vala_try_statement_add_catch_clause (_tmp25_, _tmp26_);
			_vala_code_node_unref0 (clause);
		}
		_vala_iterable_unref0 (_clause_list);
	}
	result = (ValaStatement*) stmt;
	_vala_iterable_unref0 (catch_clauses);
	_vala_code_node_unref0 (finally_clause);
	_vala_code_node_unref0 (try_block);
	return result;
}

static void
vala_genie_parser_parse_catch_clauses (ValaGenieParser* self,
                                       ValaList* catch_clauses,
                                       GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (catch_clauses != NULL);
	while (TRUE) {
		ValaSourceLocation begin = {0};
		ValaSourceLocation _tmp0_ = {0};
		ValaDataType* type = NULL;
		gchar* id = NULL;
		ValaBlock* block = NULL;
		ValaBlock* _tmp7_;
		ValaDataType* _tmp8_;
		const gchar* _tmp9_;
		ValaBlock* _tmp10_;
		ValaSourceLocation _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaCatchClause* _tmp14_;
		ValaCatchClause* _tmp15_;
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EXCEPT)) {
			break;
		}
		vala_genie_parser_get_location (self, &_tmp0_);
		begin = _tmp0_;
		type = NULL;
		id = NULL;
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
			gchar* _tmp1_ = NULL;
			gchar* _tmp2_;
			gchar* _tmp3_;
			ValaDataType* _tmp4_ = NULL;
			ValaDataType* _tmp5_;
			ValaDataType* _tmp6_;
			_tmp2_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					return;
				} else {
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_free0 (id);
			id = _tmp3_;
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (_tmp1_);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					return;
				} else {
					_g_free0 (_tmp1_);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp5_ = vala_genie_parser_parse_type (self, TRUE, TRUE, &_inner_error0_);
			_tmp4_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (_tmp1_);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					return;
				} else {
					_g_free0 (_tmp1_);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp6_ = _tmp4_;
			_tmp4_ = NULL;
			_vala_code_node_unref0 (type);
			type = _tmp6_;
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (_tmp4_);
					_g_free0 (_tmp1_);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					return;
				} else {
					_vala_code_node_unref0 (_tmp4_);
					_g_free0 (_tmp1_);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_vala_code_node_unref0 (_tmp4_);
			_g_free0 (_tmp1_);
		}
		_tmp7_ = vala_genie_parser_parse_block (self, &_inner_error0_);
		block = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				return;
			} else {
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp8_ = type;
		_tmp9_ = id;
		_tmp10_ = block;
		_tmp11_ = begin;
		_tmp12_ = vala_genie_parser_get_src (self, &_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_catch_clause_new (_tmp8_, _tmp9_, _tmp10_, _tmp13_);
		_tmp15_ = _tmp14_;
		vala_collection_add ((ValaCollection*) catch_clauses, _tmp15_);
		_vala_code_node_unref0 (_tmp15_);
		_vala_source_reference_unref0 (_tmp13_);
		_vala_code_node_unref0 (block);
		_g_free0 (id);
		_vala_code_node_unref0 (type);
	}
}

static ValaBlock*
vala_genie_parser_parse_finally_clause (ValaGenieParser* self,
                                        GError** error)
{
	ValaBlock* result = NULL;
	ValaBlock* block = NULL;
	ValaBlock* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_FINALLY, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_accept_block (self);
	_tmp0_ = vala_genie_parser_parse_block (self, &_inner_error0_);
	block = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = block;
	return result;
}

static ValaStatement*
vala_genie_parser_parse_lock_statement (ValaGenieParser* self,
                                        GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* expr = NULL;
	ValaExpression* _tmp1_;
	ValaBlock* stmt = NULL;
	ValaBlock* _tmp2_;
	ValaExpression* _tmp3_;
	ValaBlock* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaLockStatement* _tmp8_;
	ValaStatement* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_LOCK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
	expr = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (expr);
			return NULL;
		} else {
			_vala_code_node_unref0 (expr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = vala_genie_parser_parse_embedded_statement (self, &_inner_error0_);
	stmt = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (expr);
			return NULL;
		} else {
			_vala_code_node_unref0 (expr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = expr;
	_tmp4_ = stmt;
	_tmp5_ = begin;
	_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_lock_statement_new (_tmp3_, _tmp4_, _tmp7_);
	_tmp9_ = (ValaStatement*) _tmp8_;
	_vala_source_reference_unref0 (_tmp7_);
	result = _tmp9_;
	_vala_code_node_unref0 (stmt);
	_vala_code_node_unref0 (expr);
	return result;
}

static ValaStatement*
vala_genie_parser_parse_delete_statement (ValaGenieParser* self,
                                          GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* expr = NULL;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaDeleteStatement* _tmp6_;
	ValaStatement* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DELETE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
	expr = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect_terminator (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (expr);
			return NULL;
		} else {
			_vala_code_node_unref0 (expr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = expr;
	_tmp3_ = begin;
	_tmp4_ = vala_genie_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_delete_statement_new (_tmp2_, _tmp5_);
	_tmp7_ = (ValaStatement*) _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	result = _tmp7_;
	_vala_code_node_unref0 (expr);
	return result;
}

static gchar*
vala_genie_parser_parse_attribute_value (ValaGenieParser* self,
                                         GError** error)
{
	gchar* result = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (vala_genie_parser_current (self)) {
		case VALA_GENIE_TOKEN_TYPE_NULL:
		case VALA_GENIE_TOKEN_TYPE_TRUE:
		case VALA_GENIE_TOKEN_TYPE_FALSE:
		case VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL:
		case VALA_GENIE_TOKEN_TYPE_REAL_LITERAL:
		case VALA_GENIE_TOKEN_TYPE_STRING_LITERAL:
		{
			gchar* _tmp0_;
			vala_genie_parser_next (self);
			_tmp0_ = vala_genie_parser_get_last_string (self);
			result = _tmp0_;
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_MINUS:
		{
			vala_genie_parser_next (self);
			switch (vala_genie_parser_current (self)) {
				case VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL:
				case VALA_GENIE_TOKEN_TYPE_REAL_LITERAL:
				{
					gchar* _tmp1_;
					gchar* _tmp2_;
					gchar* _tmp3_;
					gchar* _tmp4_;
					vala_genie_parser_next (self);
					_tmp1_ = vala_genie_parser_get_last_string (self);
					_tmp2_ = _tmp1_;
					_tmp3_ = g_strconcat ("-", _tmp2_, NULL);
					_tmp4_ = _tmp3_;
					_g_free0 (_tmp2_);
					result = _tmp4_;
					return result;
				}
				default:
				{
					GError* _tmp5_;
					_tmp5_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected number");
					_inner_error0_ = _tmp5_;
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return NULL;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
			}
		}
		default:
		{
			GError* _tmp6_;
			_tmp6_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected literal");
			_inner_error0_ = _tmp6_;
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
}

static ValaList*
vala_genie_parser_parse_attributes (ValaGenieParser* self,
                                    gboolean parameter,
                                    GError** error)
{
	ValaList* result = NULL;
	ValaArrayList* attrs = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET) {
		result = NULL;
		return result;
	}
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_ATTRIBUTE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	attrs = _tmp1_;
	while (TRUE) {
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)) {
			break;
		}
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ValaSourceLocation begin = {0};
				ValaSourceLocation _tmp3_ = {0};
				gchar* id = NULL;
				gchar* _tmp4_;
				ValaAttribute* attr = NULL;
				const gchar* _tmp5_;
				ValaSourceLocation _tmp6_;
				ValaSourceReference* _tmp7_;
				ValaSourceReference* _tmp8_;
				ValaAttribute* _tmp9_;
				ValaAttribute* _tmp10_;
				ValaArrayList* _tmp19_;
				ValaAttribute* _tmp20_;
				if (!_tmp2_) {
					if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp2_ = FALSE;
				vala_genie_parser_get_location (self, &_tmp3_);
				begin = _tmp3_;
				_tmp4_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
				id = _tmp4_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_iterable_unref0 (attrs);
						return NULL;
					} else {
						_vala_iterable_unref0 (attrs);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp5_ = id;
				_tmp6_ = begin;
				_tmp7_ = vala_genie_parser_get_src (self, &_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = vala_attribute_new (_tmp5_, _tmp8_);
				_tmp10_ = _tmp9_;
				_vala_source_reference_unref0 (_tmp8_);
				attr = _tmp10_;
				if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)) {
					if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
						{
							gboolean _tmp11_ = FALSE;
							_tmp11_ = TRUE;
							while (TRUE) {
								gchar* _tmp12_ = NULL;
								gchar* _tmp13_;
								gchar* _tmp14_;
								gchar* _tmp15_ = NULL;
								gchar* _tmp16_;
								ValaAttribute* _tmp17_;
								const gchar* _tmp18_;
								if (!_tmp11_) {
									if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
										break;
									}
								}
								_tmp11_ = FALSE;
								_tmp13_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
								_tmp12_ = _tmp13_;
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (_inner_error0_->domain == VALA_PARSE_ERROR) {
										g_propagate_error (error, _inner_error0_);
										_vala_code_node_unref0 (attr);
										_g_free0 (id);
										_vala_iterable_unref0 (attrs);
										return NULL;
									} else {
										_vala_code_node_unref0 (attr);
										_g_free0 (id);
										_vala_iterable_unref0 (attrs);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return NULL;
									}
								}
								_tmp14_ = _tmp12_;
								_tmp12_ = NULL;
								_g_free0 (id);
								id = _tmp14_;
								vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ASSIGN, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (_inner_error0_->domain == VALA_PARSE_ERROR) {
										g_propagate_error (error, _inner_error0_);
										_g_free0 (_tmp12_);
										_vala_code_node_unref0 (attr);
										_g_free0 (id);
										_vala_iterable_unref0 (attrs);
										return NULL;
									} else {
										_g_free0 (_tmp12_);
										_vala_code_node_unref0 (attr);
										_g_free0 (id);
										_vala_iterable_unref0 (attrs);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return NULL;
									}
								}
								_tmp16_ = vala_genie_parser_parse_attribute_value (self, &_inner_error0_);
								_tmp15_ = _tmp16_;
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (_inner_error0_->domain == VALA_PARSE_ERROR) {
										g_propagate_error (error, _inner_error0_);
										_g_free0 (_tmp12_);
										_vala_code_node_unref0 (attr);
										_g_free0 (id);
										_vala_iterable_unref0 (attrs);
										return NULL;
									} else {
										_g_free0 (_tmp12_);
										_vala_code_node_unref0 (attr);
										_g_free0 (id);
										_vala_iterable_unref0 (attrs);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return NULL;
									}
								}
								_tmp17_ = attr;
								_tmp18_ = id;
								vala_attribute_add_argument (_tmp17_, _tmp18_, _tmp15_);
								_g_free0 (_tmp15_);
								_g_free0 (_tmp12_);
							}
						}
					}
					vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_vala_code_node_unref0 (attr);
							_g_free0 (id);
							_vala_iterable_unref0 (attrs);
							return NULL;
						} else {
							_vala_code_node_unref0 (attr);
							_g_free0 (id);
							_vala_iterable_unref0 (attrs);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
				_tmp19_ = attrs;
				_tmp20_ = attr;
				vala_collection_add ((ValaCollection*) _tmp19_, _tmp20_);
				_vala_code_node_unref0 (attr);
				_g_free0 (id);
			}
		}
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_iterable_unref0 (attrs);
				return NULL;
			} else {
				_vala_iterable_unref0 (attrs);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	if (!parameter) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_iterable_unref0 (attrs);
				return NULL;
			} else {
				_vala_iterable_unref0 (attrs);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	result = (ValaList*) attrs;
	return result;
}

static void
vala_genie_parser_set_attributes (ValaGenieParser* self,
                                  ValaCodeNode* node,
                                  ValaList* attributes)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	if (attributes != NULL) {
		{
			ValaList* _attr_list = NULL;
			ValaList* _tmp0_;
			gint _attr_size = 0;
			ValaList* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gint _attr_index = 0;
			_tmp0_ = _vala_iterable_ref0 (G_TYPE_CHECK_INSTANCE_CAST (attributes, VALA_TYPE_LIST, ValaList));
			_attr_list = _tmp0_;
			_tmp1_ = _attr_list;
			_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
			_tmp3_ = _tmp2_;
			_attr_size = _tmp3_;
			_attr_index = -1;
			while (TRUE) {
				ValaAttribute* attr = NULL;
				ValaList* _tmp4_;
				gpointer _tmp5_;
				ValaAttribute* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				ValaAttribute* _tmp9_;
				ValaAttribute* _tmp18_;
				ValaAttribute* _tmp19_;
				_attr_index = _attr_index + 1;
				if (!(_attr_index < _attr_size)) {
					break;
				}
				_tmp4_ = _attr_list;
				_tmp5_ = vala_list_get (_tmp4_, _attr_index);
				attr = (ValaAttribute*) _tmp5_;
				_tmp6_ = attr;
				_tmp7_ = vala_attribute_get_name (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = vala_code_node_get_attribute (node, _tmp8_);
				if (_tmp9_ != NULL) {
					ValaAttribute* _tmp10_;
					ValaSourceReference* _tmp11_;
					ValaSourceReference* _tmp12_;
					ValaAttribute* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp10_ = attr;
					_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = attr;
					_tmp14_ = vala_attribute_get_name (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_strdup_printf ("duplicate attribute `%s'", _tmp15_);
					_tmp17_ = _tmp16_;
					vala_report_error (_tmp12_, _tmp17_);
					_g_free0 (_tmp17_);
				}
				_tmp18_ = attr;
				_tmp19_ = _vala_code_node_ref0 (_tmp18_);
				node->attributes = g_list_append (node->attributes, _tmp19_);
				_vala_code_node_unref0 (attr);
			}
			_vala_iterable_unref0 (_attr_list);
		}
	}
}

static ValaSymbol*
vala_genie_parser_parse_declaration (ValaGenieParser* self,
                                     gboolean is_root,
                                     GError** error)
{
	ValaSymbol* result = NULL;
	ValaGenieScanner* _tmp0_;
	ValaComment* _tmp1_;
	ValaList* attrs = NULL;
	ValaList* _tmp2_;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp3_ = {0};
	ValaGenieTokenType cur = 0;
	ValaGenieTokenType pre = 0;
	ValaGenieParserTokenInfo* _tmp76_;
	gint _tmp76__length1;
	ValaGenieParserTokenInfo _tmp77_;
	ValaGenieTokenType _tmp78_;
	ValaGenieTokenType _tmp79_;
	const gchar* _tmp80_;
	ValaGenieTokenType _tmp81_;
	const gchar* _tmp82_;
	GError* _tmp83_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = vala_genie_scanner_pop_comment (_tmp0_);
	_vala_comment_unref0 (self->priv->comment);
	self->priv->comment = _tmp1_;
	_tmp2_ = vala_genie_parser_parse_attributes (self, FALSE, &_inner_error0_);
	attrs = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_get_location (self, &_tmp3_);
	begin = _tmp3_;
	switch (vala_genie_parser_current (self)) {
		case VALA_GENIE_TOKEN_TYPE_CONST:
		{
			ValaConstant* _tmp4_ = NULL;
			ValaList* _tmp5_;
			ValaConstant* _tmp6_;
			ValaConstant* _tmp7_;
			_tmp5_ = attrs;
			_tmp6_ = vala_genie_parser_parse_constant_declaration (self, _tmp5_, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_iterable_unref0 (attrs);
					return NULL;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp7_ = _tmp4_;
			_tmp4_ = NULL;
			result = (ValaSymbol*) _tmp7_;
			_vala_code_node_unref0 (_tmp4_);
			_vala_iterable_unref0 (attrs);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_CONSTRUCT:
		{
			ValaCreationMethod* _tmp8_ = NULL;
			ValaList* _tmp9_;
			ValaCreationMethod* _tmp10_;
			ValaCreationMethod* _tmp11_;
			_tmp9_ = attrs;
			_tmp10_ = vala_genie_parser_parse_creation_method_declaration (self, _tmp9_, &_inner_error0_);
			_tmp8_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_iterable_unref0 (attrs);
					return NULL;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp11_ = _tmp8_;
			_tmp8_ = NULL;
			result = (ValaSymbol*) _tmp11_;
			_vala_code_node_unref0 (_tmp8_);
			_vala_iterable_unref0 (attrs);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_CLASS:
		{
			ValaSymbol* _tmp12_ = NULL;
			ValaList* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaSymbol* _tmp15_;
			_tmp13_ = attrs;
			_tmp14_ = vala_genie_parser_parse_class_declaration (self, _tmp13_, &_inner_error0_);
			_tmp12_ = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_iterable_unref0 (attrs);
					return NULL;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp15_ = _tmp12_;
			_tmp12_ = NULL;
			result = _tmp15_;
			_vala_code_node_unref0 (_tmp12_);
			_vala_iterable_unref0 (attrs);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_INIT:
		{
			ValaCodeContext* _tmp20_;
			ValaProfile _tmp21_;
			ValaProfile _tmp22_;
			if (is_root) {
				ValaMethod* _tmp16_ = NULL;
				ValaList* _tmp17_;
				ValaMethod* _tmp18_;
				ValaMethod* _tmp19_;
				_tmp17_ = attrs;
				_tmp18_ = vala_genie_parser_parse_main_method_declaration (self, _tmp17_, &_inner_error0_);
				_tmp16_ = _tmp18_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_iterable_unref0 (attrs);
						return NULL;
					} else {
						_vala_iterable_unref0 (attrs);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp19_ = _tmp16_;
				_tmp16_ = NULL;
				result = (ValaSymbol*) _tmp19_;
				_vala_code_node_unref0 (_tmp16_);
				_vala_iterable_unref0 (attrs);
				return result;
			}
			_tmp20_ = self->priv->context;
			_tmp21_ = vala_code_context_get_profile (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_ == VALA_PROFILE_GOBJECT) {
				ValaSourceLocation _tmp23_;
				ValaConstructor* _tmp24_ = NULL;
				ValaList* _tmp25_;
				ValaConstructor* _tmp26_;
				ValaConstructor* _tmp27_;
				_tmp23_ = begin;
				vala_genie_parser_rollback (self, &_tmp23_);
				_tmp25_ = attrs;
				_tmp26_ = vala_genie_parser_parse_constructor_declaration (self, _tmp25_, &_inner_error0_);
				_tmp24_ = _tmp26_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_iterable_unref0 (attrs);
						return NULL;
					} else {
						_vala_iterable_unref0 (attrs);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp27_ = _tmp24_;
				_tmp24_ = NULL;
				result = (ValaSymbol*) _tmp27_;
				_vala_code_node_unref0 (_tmp24_);
				_vala_iterable_unref0 (attrs);
				return result;
			}
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_DELEGATE:
		{
			ValaSymbol* _tmp28_ = NULL;
			ValaList* _tmp29_;
			ValaSymbol* _tmp30_;
			ValaSymbol* _tmp31_;
			_tmp29_ = attrs;
			_tmp30_ = vala_genie_parser_parse_delegate_declaration (self, _tmp29_, &_inner_error0_);
			_tmp28_ = _tmp30_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_iterable_unref0 (attrs);
					return NULL;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp31_ = _tmp28_;
			_tmp28_ = NULL;
			result = _tmp31_;
			_vala_code_node_unref0 (_tmp28_);
			_vala_iterable_unref0 (attrs);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_DEF:
		{
			ValaMethod* _tmp32_ = NULL;
			ValaList* _tmp33_;
			ValaMethod* _tmp34_;
			ValaMethod* _tmp35_;
			_tmp33_ = attrs;
			_tmp34_ = vala_genie_parser_parse_method_declaration (self, _tmp33_, &_inner_error0_);
			_tmp32_ = _tmp34_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_iterable_unref0 (attrs);
					return NULL;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp35_ = _tmp32_;
			_tmp32_ = NULL;
			result = (ValaSymbol*) _tmp35_;
			_vala_code_node_unref0 (_tmp32_);
			_vala_iterable_unref0 (attrs);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_ENUM:
		{
			ValaSymbol* _tmp36_ = NULL;
			ValaList* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaSymbol* _tmp39_;
			_tmp37_ = attrs;
			_tmp38_ = vala_genie_parser_parse_enum_declaration (self, _tmp37_, &_inner_error0_);
			_tmp36_ = _tmp38_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_iterable_unref0 (attrs);
					return NULL;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp39_ = _tmp36_;
			_tmp36_ = NULL;
			result = _tmp39_;
			_vala_code_node_unref0 (_tmp36_);
			_vala_iterable_unref0 (attrs);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN:
		{
			ValaSymbol* _tmp40_ = NULL;
			ValaList* _tmp41_;
			ValaSymbol* _tmp42_;
			ValaSymbol* _tmp43_;
			_tmp41_ = attrs;
			_tmp42_ = vala_genie_parser_parse_errordomain_declaration (self, _tmp41_, &_inner_error0_);
			_tmp40_ = _tmp42_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_iterable_unref0 (attrs);
					return NULL;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp43_ = _tmp40_;
			_tmp40_ = NULL;
			result = _tmp43_;
			_vala_code_node_unref0 (_tmp40_);
			_vala_iterable_unref0 (attrs);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_FINAL:
		{
			ValaDestructor* _tmp44_ = NULL;
			ValaList* _tmp45_;
			ValaDestructor* _tmp46_;
			ValaDestructor* _tmp47_;
			_tmp45_ = attrs;
			_tmp46_ = vala_genie_parser_parse_destructor_declaration (self, _tmp45_, &_inner_error0_);
			_tmp44_ = _tmp46_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_iterable_unref0 (attrs);
					return NULL;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp47_ = _tmp44_;
			_tmp44_ = NULL;
			result = (ValaSymbol*) _tmp47_;
			_vala_code_node_unref0 (_tmp44_);
			_vala_iterable_unref0 (attrs);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_INTERFACE:
		{
			ValaSymbol* _tmp48_ = NULL;
			ValaList* _tmp49_;
			ValaSymbol* _tmp50_;
			ValaSymbol* _tmp51_;
			_tmp49_ = attrs;
			_tmp50_ = vala_genie_parser_parse_interface_declaration (self, _tmp49_, &_inner_error0_);
			_tmp48_ = _tmp50_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_iterable_unref0 (attrs);
					return NULL;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp51_ = _tmp48_;
			_tmp48_ = NULL;
			result = _tmp51_;
			_vala_code_node_unref0 (_tmp48_);
			_vala_iterable_unref0 (attrs);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_NAMESPACE:
		{
			ValaNamespace* _tmp52_ = NULL;
			ValaList* _tmp53_;
			ValaNamespace* _tmp54_;
			ValaNamespace* _tmp55_;
			_tmp53_ = attrs;
			_tmp54_ = vala_genie_parser_parse_namespace_declaration (self, _tmp53_, &_inner_error0_);
			_tmp52_ = _tmp54_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_iterable_unref0 (attrs);
					return NULL;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp55_ = _tmp52_;
			_tmp52_ = NULL;
			result = (ValaSymbol*) _tmp55_;
			_vala_code_node_unref0 (_tmp52_);
			_vala_iterable_unref0 (attrs);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_PROP:
		{
			ValaProperty* _tmp56_ = NULL;
			ValaList* _tmp57_;
			ValaProperty* _tmp58_;
			ValaProperty* _tmp59_;
			_tmp57_ = attrs;
			_tmp58_ = vala_genie_parser_parse_property_declaration (self, _tmp57_, &_inner_error0_);
			_tmp56_ = _tmp58_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_iterable_unref0 (attrs);
					return NULL;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp59_ = _tmp56_;
			_tmp56_ = NULL;
			result = (ValaSymbol*) _tmp59_;
			_vala_code_node_unref0 (_tmp56_);
			_vala_iterable_unref0 (attrs);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_EVENT:
		{
			ValaSignal* _tmp60_ = NULL;
			ValaList* _tmp61_;
			ValaSignal* _tmp62_;
			ValaSignal* _tmp63_;
			_tmp61_ = attrs;
			_tmp62_ = vala_genie_parser_parse_signal_declaration (self, _tmp61_, &_inner_error0_);
			_tmp60_ = _tmp62_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_iterable_unref0 (attrs);
					return NULL;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp63_ = _tmp60_;
			_tmp60_ = NULL;
			result = (ValaSymbol*) _tmp63_;
			_vala_code_node_unref0 (_tmp60_);
			_vala_iterable_unref0 (attrs);
			return result;
		}
		case VALA_GENIE_TOKEN_TYPE_STRUCT:
		{
			ValaSymbol* _tmp64_ = NULL;
			ValaList* _tmp65_;
			ValaSymbol* _tmp66_;
			ValaSymbol* _tmp67_;
			_tmp65_ = attrs;
			_tmp66_ = vala_genie_parser_parse_struct_declaration (self, _tmp65_, &_inner_error0_);
			_tmp64_ = _tmp66_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_iterable_unref0 (attrs);
					return NULL;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp67_ = _tmp64_;
			_tmp64_ = NULL;
			result = _tmp67_;
			_vala_code_node_unref0 (_tmp64_);
			_vala_iterable_unref0 (attrs);
			return result;
		}
		default:
		{
			ValaSourceLocation _tmp75_;
			while (TRUE) {
				gboolean _tmp68_ = FALSE;
				gboolean _tmp69_ = FALSE;
				if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOL) {
					_tmp69_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_SEMICOLON;
				} else {
					_tmp69_ = FALSE;
				}
				if (_tmp69_) {
					_tmp68_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOF;
				} else {
					_tmp68_ = FALSE;
				}
				if (!_tmp68_) {
					break;
				}
				if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_COLON) {
					ValaSourceLocation _tmp70_;
					ValaField* _tmp71_ = NULL;
					ValaList* _tmp72_;
					ValaField* _tmp73_;
					ValaField* _tmp74_;
					_tmp70_ = begin;
					vala_genie_parser_rollback (self, &_tmp70_);
					_tmp72_ = attrs;
					_tmp73_ = vala_genie_parser_parse_field_declaration (self, _tmp72_, &_inner_error0_);
					_tmp71_ = _tmp73_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_vala_iterable_unref0 (attrs);
							return NULL;
						} else {
							_vala_iterable_unref0 (attrs);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp74_ = _tmp71_;
					_tmp71_ = NULL;
					result = (ValaSymbol*) _tmp74_;
					_vala_code_node_unref0 (_tmp71_);
					_vala_iterable_unref0 (attrs);
					return result;
				} else {
					vala_genie_parser_next (self);
				}
			}
			_tmp75_ = begin;
			vala_genie_parser_rollback (self, &_tmp75_);
			break;
		}
	}
	cur = vala_genie_parser_current (self);
	_tmp76_ = self->priv->tokens;
	_tmp76__length1 = self->priv->tokens_length1;
	_tmp77_ = _tmp76_[self->priv->index - 1];
	_tmp78_ = _tmp77_.type;
	pre = _tmp78_;
	_tmp79_ = cur;
	_tmp80_ = vala_genie_token_type_to_string (_tmp79_);
	_tmp81_ = pre;
	_tmp82_ = vala_genie_token_type_to_string (_tmp81_);
	_tmp83_ = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected declaration  but got %s with previous %s", _tmp80_, _tmp82_);
	_inner_error0_ = _tmp83_;
	if (_inner_error0_->domain == VALA_PARSE_ERROR) {
		g_propagate_error (error, _inner_error0_);
		_vala_iterable_unref0 (attrs);
		return NULL;
	} else {
		_vala_iterable_unref0 (attrs);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_vala_iterable_unref0 (attrs);
}

static void
vala_genie_parser_parse_declarations (ValaGenieParser* self,
                                      ValaSymbol* parent,
                                      gboolean root,
                                      GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	if (!root) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
			_tmp0_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOF;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		{
			if (G_TYPE_CHECK_INSTANCE_TYPE (parent, VALA_TYPE_NAMESPACE)) {
				vala_genie_parser_parse_namespace_member (self, G_TYPE_CHECK_INSTANCE_CAST (parent, VALA_TYPE_NAMESPACE, ValaNamespace), &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						goto __catch14_vala_parse_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (parent, VALA_TYPE_CLASS)) {
					vala_genie_parser_parse_class_member (self, G_TYPE_CHECK_INSTANCE_CAST (parent, VALA_TYPE_CLASS, ValaClass), &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							goto __catch14_vala_parse_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (parent, VALA_TYPE_STRUCT)) {
						vala_genie_parser_parse_struct_member (self, G_TYPE_CHECK_INSTANCE_CAST (parent, VALA_TYPE_STRUCT, ValaStruct), &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == VALA_PARSE_ERROR) {
								goto __catch14_vala_parse_error;
							}
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (parent, VALA_TYPE_INTERFACE)) {
							vala_genie_parser_parse_interface_member (self, G_TYPE_CHECK_INSTANCE_CAST (parent, VALA_TYPE_INTERFACE, ValaInterface), &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == VALA_PARSE_ERROR) {
									goto __catch14_vala_parse_error;
								}
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
						}
					}
				}
			}
		}
		goto __finally14;
		__catch14_vala_parse_error:
		{
			GError* e = NULL;
			GError* _tmp1_;
			gint r = 0;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp1_ = e;
			vala_genie_parser_report_parse_error (self, _tmp1_);
			while (TRUE) {
				r = (gint) vala_genie_parser_recover (self);
				if (r == ((gint) VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN)) {
					vala_genie_parser_next (self);
				} else {
					break;
				}
			}
			if (r == ((gint) VALA_GENIE_PARSER_RECOVERY_STATE_EOF)) {
				_g_error_free0 (e);
				return;
			}
			_g_error_free0 (e);
		}
		__finally14:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	if (!root) {
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DEDENT)) {
			ValaCodeContext* _tmp2_;
			ValaReport* _tmp3_;
			ValaReport* _tmp4_;
			_tmp2_ = self->priv->context;
			_tmp3_ = vala_code_context_get_report (_tmp2_);
			_tmp4_ = _tmp3_;
			if (vala_report_get_errors (_tmp4_) == 0) {
				ValaSourceReference* _tmp5_;
				ValaSourceReference* _tmp6_;
				_tmp5_ = vala_genie_parser_get_current_src (self);
				_tmp6_ = _tmp5_;
				vala_report_error (_tmp6_, "expected dedent");
				_vala_source_reference_unref0 (_tmp6_);
			}
		}
	}
}

static ValaGenieParserRecoveryState
vala_genie_parser_recover (ValaGenieParser* self)
{
	ValaGenieParserRecoveryState result = 0;
	g_return_val_if_fail (self != NULL, 0);
	while (TRUE) {
		if (!(vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOF)) {
			break;
		}
		switch (vala_genie_parser_current (self)) {
			case VALA_GENIE_TOKEN_TYPE_CLASS:
			case VALA_GENIE_TOKEN_TYPE_CONST:
			case VALA_GENIE_TOKEN_TYPE_CONSTRUCT:
			case VALA_GENIE_TOKEN_TYPE_INIT:
			case VALA_GENIE_TOKEN_TYPE_DEF:
			case VALA_GENIE_TOKEN_TYPE_DELEGATE:
			case VALA_GENIE_TOKEN_TYPE_ENUM:
			case VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN:
			case VALA_GENIE_TOKEN_TYPE_FINAL:
			case VALA_GENIE_TOKEN_TYPE_INTERFACE:
			case VALA_GENIE_TOKEN_TYPE_NAMESPACE:
			case VALA_GENIE_TOKEN_TYPE_PROP:
			case VALA_GENIE_TOKEN_TYPE_EVENT:
			case VALA_GENIE_TOKEN_TYPE_STRUCT:
			{
				result = VALA_GENIE_PARSER_RECOVERY_STATE_DECLARATION_BEGIN;
				return result;
			}
			case VALA_GENIE_TOKEN_TYPE_BREAK:
			case VALA_GENIE_TOKEN_TYPE_CASE:
			case VALA_GENIE_TOKEN_TYPE_CONTINUE:
			case VALA_GENIE_TOKEN_TYPE_DELETE:
			case VALA_GENIE_TOKEN_TYPE_DO:
			case VALA_GENIE_TOKEN_TYPE_FOR:
			case VALA_GENIE_TOKEN_TYPE_IF:
			case VALA_GENIE_TOKEN_TYPE_LOCK:
			case VALA_GENIE_TOKEN_TYPE_RETURN:
			case VALA_GENIE_TOKEN_TYPE_RAISE:
			case VALA_GENIE_TOKEN_TYPE_TRY:
			case VALA_GENIE_TOKEN_TYPE_VAR:
			case VALA_GENIE_TOKEN_TYPE_WHILE:
			case VALA_GENIE_TOKEN_TYPE_YIELD:
			{
				result = VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN;
				return result;
			}
			default:
			{
				vala_genie_parser_next (self);
				break;
			}
		}
	}
	result = VALA_GENIE_PARSER_RECOVERY_STATE_EOF;
	return result;
}

static ValaNamespace*
vala_genie_parser_parse_namespace_declaration (ValaGenieParser* self,
                                               ValaList* attrs,
                                               GError** error)
{
	ValaNamespace* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaUnresolvedSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp1_;
	ValaNamespace* ns = NULL;
	ValaUnresolvedSymbol* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaNamespace* _tmp8_;
	ValaNamespace* _tmp9_;
	ValaComment* _tmp10_;
	ValaNamespace* _tmp13_;
	ValaNamespace* _tmp14_;
	ValaNamespace* _result_ = NULL;
	ValaNamespace* _tmp15_;
	ValaNamespace* _tmp16_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_NAMESPACE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = vala_genie_parser_parse_symbol_name (self, &_inner_error0_);
	sym = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = sym;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = begin;
	_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_namespace_new (_tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_vala_source_reference_unref0 (_tmp7_);
	ns = _tmp9_;
	_tmp10_ = self->priv->comment;
	if (_tmp10_ != NULL) {
		ValaNamespace* _tmp11_;
		ValaComment* _tmp12_;
		_tmp11_ = ns;
		_tmp12_ = self->priv->comment;
		vala_namespace_add_comment (_tmp11_, _tmp12_);
		_vala_comment_unref0 (self->priv->comment);
		self->priv->comment = NULL;
	}
	_tmp13_ = ns;
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp13_, attrs);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (ns);
			_vala_code_node_unref0 (sym);
			return NULL;
		} else {
			_vala_code_node_unref0 (ns);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp14_ = ns;
	vala_genie_parser_parse_declarations (self, (ValaSymbol*) _tmp14_, FALSE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (ns);
			_vala_code_node_unref0 (sym);
			return NULL;
		} else {
			_vala_code_node_unref0 (ns);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp15_ = ns;
	_tmp16_ = _vala_code_node_ref0 (_tmp15_);
	_result_ = _tmp16_;
	while (TRUE) {
		ValaUnresolvedSymbol* _tmp17_;
		ValaUnresolvedSymbol* _tmp18_;
		ValaUnresolvedSymbol* _tmp19_;
		ValaUnresolvedSymbol* _tmp20_;
		ValaUnresolvedSymbol* _tmp21_;
		ValaUnresolvedSymbol* _tmp22_;
		ValaUnresolvedSymbol* _tmp23_;
		ValaUnresolvedSymbol* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		ValaNamespace* _tmp27_;
		ValaSourceReference* _tmp28_;
		ValaSourceReference* _tmp29_;
		ValaNamespace* _tmp30_;
		ValaNamespace* _tmp31_;
		ValaNamespace* _tmp32_;
		ValaNamespace* _tmp33_;
		ValaNamespace* _tmp34_;
		_tmp17_ = sym;
		_tmp18_ = vala_unresolved_symbol_get_inner (_tmp17_);
		_tmp19_ = _tmp18_;
		if (!(_tmp19_ != NULL)) {
			break;
		}
		_tmp20_ = sym;
		_tmp21_ = vala_unresolved_symbol_get_inner (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _vala_code_node_ref0 (_tmp22_);
		_vala_code_node_unref0 (sym);
		sym = _tmp23_;
		_tmp24_ = sym;
		_tmp25_ = vala_symbol_get_name ((ValaSymbol*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _result_;
		_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_namespace_new (_tmp26_, _tmp29_);
		_vala_code_node_unref0 (ns);
		ns = _tmp30_;
		_tmp31_ = ns;
		_tmp32_ = _result_;
		vala_symbol_add_namespace ((ValaSymbol*) _tmp31_, G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_NAMESPACE, ValaNamespace));
		_tmp33_ = ns;
		_tmp34_ = _vala_code_node_ref0 (_tmp33_);
		_vala_code_node_unref0 (_result_);
		_result_ = _tmp34_;
	}
	result = _result_;
	_vala_code_node_unref0 (ns);
	_vala_code_node_unref0 (sym);
	return result;
}

static void
vala_genie_parser_parse_namespace_member (ValaGenieParser* self,
                                          ValaNamespace* ns,
                                          GError** error)
{
	ValaSymbol* sym = NULL;
	ValaCodeContext* _tmp0_;
	ValaNamespace* _tmp1_;
	ValaNamespace* _tmp2_;
	ValaSymbol* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = vala_code_context_get_root (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_genie_parser_parse_declaration (self, ns == _tmp2_, &_inner_error0_);
	sym = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_NAMESPACE)) {
		vala_symbol_add_namespace ((ValaSymbol*) ns, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_NAMESPACE, ValaNamespace));
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
			vala_symbol_add_class ((ValaSymbol*) ns, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_INTERFACE)) {
				vala_symbol_add_interface ((ValaSymbol*) ns, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_INTERFACE, ValaInterface));
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT)) {
					vala_symbol_add_struct ((ValaSymbol*) ns, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM)) {
						vala_symbol_add_enum ((ValaSymbol*) ns, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ERROR_DOMAIN)) {
							vala_symbol_add_error_domain ((ValaSymbol*) ns, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_DELEGATE)) {
								vala_symbol_add_delegate ((ValaSymbol*) ns, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_DELEGATE, ValaDelegate));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
									ValaMethod* method = NULL;
									ValaMethod* _tmp4_;
									ValaMethod* _tmp5_;
									ValaMemberBinding _tmp6_;
									ValaMemberBinding _tmp7_;
									ValaMethod* _tmp9_;
									_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
									method = _tmp4_;
									_tmp5_ = method;
									_tmp6_ = vala_method_get_binding (_tmp5_);
									_tmp7_ = _tmp6_;
									if (_tmp7_ == VALA_MEMBER_BINDING_INSTANCE) {
										ValaMethod* _tmp8_;
										_tmp8_ = method;
										vala_method_set_binding (_tmp8_, VALA_MEMBER_BINDING_STATIC);
									}
									_tmp9_ = method;
									vala_symbol_add_method ((ValaSymbol*) ns, _tmp9_);
									_vala_code_node_unref0 (method);
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
										ValaField* field = NULL;
										ValaField* _tmp10_;
										ValaField* _tmp11_;
										ValaMemberBinding _tmp12_;
										ValaMemberBinding _tmp13_;
										ValaField* _tmp15_;
										_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
										field = _tmp10_;
										_tmp11_ = field;
										_tmp12_ = vala_field_get_binding (_tmp11_);
										_tmp13_ = _tmp12_;
										if (_tmp13_ == VALA_MEMBER_BINDING_INSTANCE) {
											ValaField* _tmp14_;
											_tmp14_ = field;
											vala_field_set_binding (_tmp14_, VALA_MEMBER_BINDING_STATIC);
										}
										_tmp15_ = field;
										vala_symbol_add_field ((ValaSymbol*) ns, _tmp15_);
										_vala_code_node_unref0 (field);
									} else {
										if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
											vala_symbol_add_constant ((ValaSymbol*) ns, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
										} else {
											ValaSourceReference* _tmp16_;
											ValaSourceReference* _tmp17_;
											_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
											_tmp17_ = _tmp16_;
											vala_report_error (_tmp17_, "unexpected declaration in namespace");
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_vala_code_node_unref0 (sym);
}

static void
vala_genie_parser_add_uses_clause (ValaGenieParser* self,
                                   ValaNamespace* ns,
                                   GError** error)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaUnresolvedSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp1_;
	ValaUsingDirective* ns_ref = NULL;
	ValaSourceLocation _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaUsingDirective* _tmp5_;
	ValaUsingDirective* _tmp6_;
	ValaGenieScanner* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaUsingDirective* _tmp10_;
	ValaUsingDirective* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_genie_parser_parse_symbol_name (self, &_inner_error0_);
	sym = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp2_ = begin;
	_tmp3_ = vala_genie_parser_get_src (self, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_using_directive_new ((ValaSymbol*) sym, _tmp4_);
	_tmp6_ = _tmp5_;
	_vala_source_reference_unref0 (_tmp4_);
	ns_ref = _tmp6_;
	_tmp7_ = self->priv->scanner;
	_tmp8_ = vala_genie_scanner_get_source_file (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = ns_ref;
	vala_source_file_add_using_directive (_tmp9_, _tmp10_);
	_tmp11_ = ns_ref;
	vala_namespace_add_using_directive (ns, _tmp11_);
	_vala_code_node_unref0 (ns_ref);
	_vala_code_node_unref0 (sym);
}

static void
vala_genie_parser_parse_using_directives (ValaGenieParser* self,
                                          ValaNamespace* ns,
                                          GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	while (TRUE) {
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_USES)) {
			break;
		}
		if (vala_genie_parser_accept_block (self)) {
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			while (TRUE) {
				gboolean _tmp0_ = FALSE;
				if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
					_tmp0_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOF;
				} else {
					_tmp0_ = FALSE;
				}
				if (!_tmp0_) {
					break;
				}
				vala_genie_parser_add_uses_clause (self, ns, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		} else {
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					if (!_tmp1_) {
						if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
							break;
						}
					}
					_tmp1_ = FALSE;
					vala_genie_parser_add_uses_clause (self, ns, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				}
			}
			vala_genie_parser_expect_terminator (self, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
}

static ValaSymbol*
vala_genie_parser_parse_class_declaration (ValaGenieParser* self,
                                           ValaList* attrs,
                                           GError** error)
{
	ValaSymbol* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaGenieParserModifierFlags flags = 0;
	ValaUnresolvedSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp1_;
	ValaList* type_param_list = NULL;
	ValaList* _tmp2_;
	ValaArrayList* base_types = NULL;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	ValaClass* cl = NULL;
	ValaUnresolvedSymbol* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	ValaSourceLocation _tmp15_;
	ValaSourceReference* _tmp16_;
	ValaSourceReference* _tmp17_;
	ValaComment* _tmp18_;
	ValaClass* _tmp19_;
	ValaClass* _tmp20_;
	ValaGenieParserModifierFlags _tmp21_;
	ValaGenieParserModifierFlags _tmp29_;
	ValaClass* _tmp31_;
	ValaClass* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	ValaClass* _tmp54_;
	gboolean _tmp55_ = FALSE;
	ValaGenieScanner* _tmp56_;
	ValaSourceFile* _tmp57_;
	ValaSourceFile* _tmp58_;
	ValaSourceFileType _tmp59_;
	ValaSourceFileType _tmp60_;
	ValaSymbol* _result_ = NULL;
	ValaClass* _tmp84_;
	ValaSymbol* _tmp85_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLASS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_type_declaration_modifiers (self);
	_tmp1_ = vala_genie_parser_parse_symbol_name (self, &_inner_error0_);
	sym = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = vala_genie_parser_parse_type_parameter_list (self, &_inner_error0_);
	type_param_list = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (sym);
			return NULL;
		} else {
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
	base_types = _tmp4_;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		ValaDataType* type1 = NULL;
		ValaDataType* _tmp5_;
		ValaArrayList* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp5_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
		type1 = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_iterable_unref0 (base_types);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				return NULL;
			} else {
				_vala_iterable_unref0 (base_types);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp6_ = base_types;
		_tmp7_ = type1;
		vala_collection_add ((ValaCollection*) _tmp6_, _tmp7_);
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_IMPLEMENTS)) {
			{
				gboolean _tmp8_ = FALSE;
				_tmp8_ = TRUE;
				while (TRUE) {
					ValaDataType* type2 = NULL;
					ValaDataType* _tmp9_;
					ValaArrayList* _tmp10_;
					ValaDataType* _tmp11_;
					if (!_tmp8_) {
						if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
							break;
						}
					}
					_tmp8_ = FALSE;
					_tmp9_ = vala_genie_parser_parse_type (self, TRUE, TRUE, &_inner_error0_);
					type2 = _tmp9_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_vala_code_node_unref0 (type1);
							_vala_iterable_unref0 (base_types);
							_vala_iterable_unref0 (type_param_list);
							_vala_code_node_unref0 (sym);
							return NULL;
						} else {
							_vala_code_node_unref0 (type1);
							_vala_iterable_unref0 (base_types);
							_vala_iterable_unref0 (type_param_list);
							_vala_code_node_unref0 (sym);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp10_ = base_types;
					_tmp11_ = type2;
					vala_collection_add ((ValaCollection*) _tmp10_, _tmp11_);
					_vala_code_node_unref0 (type2);
				}
			}
		}
		_vala_code_node_unref0 (type1);
	}
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
	_tmp12_ = sym;
	_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = begin;
	_tmp16_ = vala_genie_parser_get_src (self, &_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->comment;
	_tmp19_ = vala_class_new (_tmp14_, _tmp17_, _tmp18_);
	_tmp20_ = _tmp19_;
	_vala_source_reference_unref0 (_tmp17_);
	cl = _tmp20_;
	_tmp21_ = flags;
	if ((_tmp21_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		ValaClass* _tmp22_;
		_tmp22_ = cl;
		vala_symbol_set_access ((ValaSymbol*) _tmp22_, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		ValaGenieParserModifierFlags _tmp23_;
		_tmp23_ = flags;
		if ((_tmp23_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) {
			ValaClass* _tmp24_;
			_tmp24_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp24_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
		} else {
			ValaClass* _tmp25_;
			ValaUnresolvedSymbol* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			_tmp25_ = cl;
			_tmp26_ = sym;
			_tmp27_ = vala_symbol_get_name ((ValaSymbol*) _tmp26_);
			_tmp28_ = _tmp27_;
			vala_symbol_set_access ((ValaSymbol*) _tmp25_, vala_genie_parser_get_default_accessibility (self, _tmp28_));
		}
	}
	_tmp29_ = flags;
	if ((_tmp29_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) == VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) {
		ValaClass* _tmp30_;
		_tmp30_ = cl;
		vala_class_set_is_abstract (_tmp30_, TRUE);
	}
	_tmp31_ = cl;
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp31_, attrs);
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp32_;
		ValaList* _tmp33_;
		gint _type_param_size = 0;
		ValaList* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		gint _type_param_index = 0;
		_tmp32_ = type_param_list;
		_tmp33_ = _vala_iterable_ref0 (_tmp32_);
		_type_param_list = _tmp33_;
		_tmp34_ = _type_param_list;
		_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
		_tmp36_ = _tmp35_;
		_type_param_size = _tmp36_;
		_type_param_index = -1;
		while (TRUE) {
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp37_;
			gpointer _tmp38_;
			ValaClass* _tmp39_;
			ValaTypeParameter* _tmp40_;
			_type_param_index = _type_param_index + 1;
			if (!(_type_param_index < _type_param_size)) {
				break;
			}
			_tmp37_ = _type_param_list;
			_tmp38_ = vala_list_get (_tmp37_, _type_param_index);
			type_param = (ValaTypeParameter*) _tmp38_;
			_tmp39_ = cl;
			_tmp40_ = type_param;
			vala_object_type_symbol_add_type_parameter ((ValaObjectTypeSymbol*) _tmp39_, _tmp40_);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	{
		ValaArrayList* _base_type_list = NULL;
		ValaArrayList* _tmp41_;
		ValaArrayList* _tmp42_;
		gint _base_type_size = 0;
		ValaArrayList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gint _base_type_index = 0;
		_tmp41_ = base_types;
		_tmp42_ = _vala_iterable_ref0 (_tmp41_);
		_base_type_list = _tmp42_;
		_tmp43_ = _base_type_list;
		_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		_base_type_size = _tmp45_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaArrayList* _tmp46_;
			gpointer _tmp47_;
			ValaClass* _tmp48_;
			ValaDataType* _tmp49_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp46_ = _base_type_list;
			_tmp47_ = vala_list_get ((ValaList*) _tmp46_, _base_type_index);
			base_type = (ValaDataType*) _tmp47_;
			_tmp48_ = cl;
			_tmp49_ = base_type;
			vala_class_add_base_type (_tmp48_, _tmp49_);
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp50_ = cl;
	_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = g_strdup (_tmp52_);
	_g_free0 (self->priv->class_name);
	self->priv->class_name = _tmp53_;
	_tmp54_ = cl;
	vala_genie_parser_parse_declarations (self, (ValaSymbol*) _tmp54_, FALSE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (cl);
			_vala_iterable_unref0 (base_types);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			return NULL;
		} else {
			_vala_code_node_unref0 (cl);
			_vala_iterable_unref0 (base_types);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp56_ = self->priv->scanner;
	_tmp57_ = vala_genie_scanner_get_source_file (_tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = vala_source_file_get_file_type (_tmp58_);
	_tmp60_ = _tmp59_;
	if (_tmp60_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		ValaClass* _tmp61_;
		ValaCreationMethod* _tmp62_;
		ValaCreationMethod* _tmp63_;
		_tmp61_ = cl;
		_tmp62_ = vala_class_get_default_construction_method (_tmp61_);
		_tmp63_ = _tmp62_;
		_tmp55_ = _tmp63_ == NULL;
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		ValaCreationMethod* m = NULL;
		ValaClass* _tmp64_;
		const gchar* _tmp65_;
		const gchar* _tmp66_;
		ValaClass* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaSourceReference* _tmp69_;
		ValaCreationMethod* _tmp70_;
		ValaSymbolAccessibility _tmp71_ = 0;
		ValaClass* _tmp72_;
		gboolean _tmp73_;
		gboolean _tmp74_;
		ValaCreationMethod* _tmp75_;
		ValaCreationMethod* _tmp76_;
		ValaClass* _tmp77_;
		ValaSourceReference* _tmp78_;
		ValaSourceReference* _tmp79_;
		ValaBlock* _tmp80_;
		ValaBlock* _tmp81_;
		ValaClass* _tmp82_;
		ValaCreationMethod* _tmp83_;
		_tmp64_ = cl;
		_tmp65_ = vala_symbol_get_name ((ValaSymbol*) _tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = cl;
		_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_creation_method_new (_tmp66_, NULL, _tmp69_, NULL);
		m = _tmp70_;
		_tmp72_ = cl;
		_tmp73_ = vala_class_get_is_abstract (_tmp72_);
		_tmp74_ = _tmp73_;
		if (_tmp74_) {
			_tmp71_ = VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
		} else {
			_tmp71_ = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
		}
		_tmp75_ = m;
		vala_symbol_set_access ((ValaSymbol*) _tmp75_, _tmp71_);
		_tmp76_ = m;
		_tmp77_ = cl;
		_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp77_);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_block_new (_tmp79_);
		_tmp81_ = _tmp80_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp76_, _tmp81_);
		_vala_code_node_unref0 (_tmp81_);
		_tmp82_ = cl;
		_tmp83_ = m;
		vala_symbol_add_method ((ValaSymbol*) _tmp82_, (ValaMethod*) _tmp83_);
		_vala_code_node_unref0 (m);
	}
	_tmp84_ = cl;
	_tmp85_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp84_);
	_result_ = _tmp85_;
	while (TRUE) {
		ValaUnresolvedSymbol* _tmp86_;
		ValaUnresolvedSymbol* _tmp87_;
		ValaUnresolvedSymbol* _tmp88_;
		ValaUnresolvedSymbol* _tmp89_;
		ValaUnresolvedSymbol* _tmp90_;
		ValaUnresolvedSymbol* _tmp91_;
		ValaUnresolvedSymbol* _tmp92_;
		ValaNamespace* ns = NULL;
		ValaUnresolvedSymbol* _tmp93_;
		const gchar* _tmp94_;
		const gchar* _tmp95_;
		ValaClass* _tmp96_;
		ValaSourceReference* _tmp97_;
		ValaSourceReference* _tmp98_;
		ValaNamespace* _tmp99_;
		ValaSymbol* _tmp100_;
		ValaNamespace* _tmp105_;
		ValaSymbol* _tmp106_;
		_tmp86_ = sym;
		_tmp87_ = vala_unresolved_symbol_get_inner (_tmp86_);
		_tmp88_ = _tmp87_;
		if (!(_tmp88_ != NULL)) {
			break;
		}
		_tmp89_ = sym;
		_tmp90_ = vala_unresolved_symbol_get_inner (_tmp89_);
		_tmp91_ = _tmp90_;
		_tmp92_ = _vala_code_node_ref0 (_tmp91_);
		_vala_code_node_unref0 (sym);
		sym = _tmp92_;
		_tmp93_ = sym;
		_tmp94_ = vala_symbol_get_name ((ValaSymbol*) _tmp93_);
		_tmp95_ = _tmp94_;
		_tmp96_ = cl;
		_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp96_);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_namespace_new (_tmp95_, _tmp98_);
		ns = _tmp99_;
		_tmp100_ = _result_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp100_, VALA_TYPE_NAMESPACE)) {
			ValaNamespace* _tmp101_;
			ValaSymbol* _tmp102_;
			_tmp101_ = ns;
			_tmp102_ = _result_;
			vala_symbol_add_namespace ((ValaSymbol*) _tmp101_, G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_NAMESPACE, ValaNamespace));
		} else {
			ValaNamespace* _tmp103_;
			ValaSymbol* _tmp104_;
			_tmp103_ = ns;
			_tmp104_ = _result_;
			vala_symbol_add_class ((ValaSymbol*) _tmp103_, G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, VALA_TYPE_CLASS, ValaClass));
		}
		_tmp105_ = ns;
		_tmp106_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp105_);
		_vala_code_node_unref0 (_result_);
		_result_ = _tmp106_;
		_vala_code_node_unref0 (ns);
	}
	result = _result_;
	_vala_code_node_unref0 (cl);
	_vala_iterable_unref0 (base_types);
	_vala_iterable_unref0 (type_param_list);
	_vala_code_node_unref0 (sym);
	return result;
}

static void
vala_genie_parser_parse_class_member (ValaGenieParser* self,
                                      ValaClass* cl,
                                      GError** error)
{
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_genie_parser_parse_declaration (self, FALSE, &_inner_error0_);
	sym = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
		vala_symbol_add_class ((ValaSymbol*) cl, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT)) {
			vala_symbol_add_struct ((ValaSymbol*) cl, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM)) {
				vala_symbol_add_enum ((ValaSymbol*) cl, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_DELEGATE)) {
					vala_symbol_add_delegate ((ValaSymbol*) cl, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_DELEGATE, ValaDelegate));
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
						vala_symbol_add_method ((ValaSymbol*) cl, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_SIGNAL)) {
							vala_symbol_add_signal ((ValaSymbol*) cl, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
								vala_symbol_add_field ((ValaSymbol*) cl, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
									vala_symbol_add_constant ((ValaSymbol*) cl, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PROPERTY)) {
										vala_symbol_add_property ((ValaSymbol*) cl, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									} else {
										if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTRUCTOR)) {
											vala_symbol_add_constructor ((ValaSymbol*) cl, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
										} else {
											if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_DESTRUCTOR)) {
												vala_symbol_add_destructor ((ValaSymbol*) cl, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_DESTRUCTOR, ValaDestructor));
											} else {
												ValaSourceReference* _tmp1_;
												ValaSourceReference* _tmp2_;
												_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
												_tmp2_ = _tmp1_;
												vala_report_error (_tmp2_, "unexpected declaration in class");
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_vala_code_node_unref0 (sym);
}

static ValaConstant*
vala_genie_parser_parse_constant_declaration (ValaGenieParser* self,
                                              ValaList* attrs,
                                              GError** error)
{
	ValaConstant* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaGenieParserModifierFlags flags = 0;
	gchar* id = NULL;
	gchar* _tmp1_;
	ValaDataType* type = NULL;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_ = NULL;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaExpression* initializer = NULL;
	ValaArrayType* array_type = NULL;
	ValaDataType* _tmp10_;
	ValaArrayType* _tmp11_;
	ValaArrayType* _tmp12_;
	ValaConstant* c = NULL;
	const gchar* _tmp16_;
	ValaDataType* _tmp17_;
	ValaExpression* _tmp18_;
	ValaSourceLocation _tmp19_;
	ValaSourceReference* _tmp20_;
	ValaSourceReference* _tmp21_;
	ValaComment* _tmp22_;
	ValaConstant* _tmp23_;
	ValaConstant* _tmp24_;
	ValaConstant* _tmp25_;
	const gchar* _tmp26_;
	gboolean _tmp27_ = FALSE;
	ValaGenieParserModifierFlags _tmp28_;
	ValaGenieParserModifierFlags _tmp35_;
	ValaConstant* _tmp37_;
	ValaGenieParserModifierFlags _tmp38_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CONST, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	_tmp1_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
	id = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = vala_genie_parser_parse_type (self, FALSE, FALSE, &_inner_error0_);
	type = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = type;
	_tmp5_ = vala_genie_parser_parse_inline_array_type (self, _tmp4_, &_inner_error0_);
	_tmp3_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (type);
			_g_free0 (id);
			return NULL;
		} else {
			_vala_code_node_unref0 (type);
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = _tmp3_;
	_tmp3_ = NULL;
	_vala_code_node_unref0 (type);
	type = _tmp6_;
	initializer = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp7_ = NULL;
		ValaExpression* _tmp8_;
		ValaExpression* _tmp9_;
		_tmp8_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (_tmp3_);
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				return NULL;
			} else {
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (_tmp3_);
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp9_ = _tmp7_;
		_tmp7_ = NULL;
		_vala_code_node_unref0 (initializer);
		initializer = _tmp9_;
		_vala_code_node_unref0 (_tmp7_);
	}
	vala_genie_parser_expect_terminator (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (initializer);
			_vala_code_node_unref0 (_tmp3_);
			_vala_code_node_unref0 (type);
			_g_free0 (id);
			return NULL;
		} else {
			_vala_code_node_unref0 (initializer);
			_vala_code_node_unref0 (_tmp3_);
			_vala_code_node_unref0 (type);
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp10_ = type;
	_tmp11_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp10_) : NULL);
	array_type = _tmp11_;
	_tmp12_ = array_type;
	if (_tmp12_ != NULL) {
		ValaArrayType* _tmp13_;
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		_tmp13_ = array_type;
		_tmp14_ = vala_array_type_get_element_type (_tmp13_);
		_tmp15_ = _tmp14_;
		vala_data_type_set_value_owned (_tmp15_, FALSE);
	}
	_tmp16_ = id;
	_tmp17_ = type;
	_tmp18_ = initializer;
	_tmp19_ = begin;
	_tmp20_ = vala_genie_parser_get_src (self, &_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->comment;
	_tmp23_ = vala_constant_new (_tmp16_, _tmp17_, _tmp18_, _tmp21_, _tmp22_);
	_tmp24_ = _tmp23_;
	_vala_source_reference_unref0 (_tmp21_);
	c = _tmp24_;
	_tmp25_ = c;
	_tmp26_ = id;
	vala_symbol_set_access ((ValaSymbol*) _tmp25_, vala_genie_parser_get_default_accessibility (self, _tmp26_));
	_tmp28_ = flags;
	if ((_tmp28_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp27_ = TRUE;
	} else {
		ValaGenieScanner* _tmp29_;
		ValaSourceFile* _tmp30_;
		ValaSourceFile* _tmp31_;
		ValaSourceFileType _tmp32_;
		ValaSourceFileType _tmp33_;
		_tmp29_ = self->priv->scanner;
		_tmp30_ = vala_genie_scanner_get_source_file (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_source_file_get_file_type (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp27_ = _tmp33_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	}
	if (_tmp27_) {
		ValaConstant* _tmp34_;
		_tmp34_ = c;
		vala_symbol_set_external ((ValaSymbol*) _tmp34_, TRUE);
	}
	_tmp35_ = flags;
	if ((_tmp35_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) == VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) {
		ValaConstant* _tmp36_;
		_tmp36_ = c;
		vala_symbol_set_hides ((ValaSymbol*) _tmp36_, TRUE);
	}
	_tmp37_ = c;
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp37_, attrs);
	_tmp38_ = flags;
	if ((_tmp38_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) == VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) {
		ValaConstant* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		_tmp39_ = c;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp39_);
		_tmp41_ = _tmp40_;
		vala_report_warning (_tmp41_, "the modifier `static' is not applicable to constants");
	}
	result = c;
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (initializer);
	_vala_code_node_unref0 (_tmp3_);
	_vala_code_node_unref0 (type);
	_g_free0 (id);
	return result;
}

static ValaField*
vala_genie_parser_parse_field_declaration (ValaGenieParser* self,
                                           ValaList* attrs,
                                           GError** error)
{
	ValaField* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gchar* id = NULL;
	gchar* _tmp1_;
	ValaGenieParserModifierFlags flags = 0;
	ValaDataType* type = NULL;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_ = NULL;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaField* f = NULL;
	const gchar* _tmp7_;
	ValaDataType* _tmp8_;
	ValaSourceLocation _tmp9_;
	ValaSourceReference* _tmp10_;
	ValaSourceReference* _tmp11_;
	ValaComment* _tmp12_;
	ValaField* _tmp13_;
	ValaField* _tmp14_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	ValaGenieParserModifierFlags _tmp17_;
	ValaGenieParserModifierFlags _tmp23_;
	ValaField* _tmp29_;
	gboolean _tmp30_ = FALSE;
	ValaGenieParserModifierFlags _tmp31_;
	ValaGenieParserModifierFlags _tmp38_;
	ValaGenieParserModifierFlags _tmp43_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
	id = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	_tmp2_ = vala_genie_parser_parse_type (self, TRUE, TRUE, &_inner_error0_);
	type = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = type;
	_tmp5_ = vala_genie_parser_parse_inline_array_type (self, _tmp4_, &_inner_error0_);
	_tmp3_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (type);
			_g_free0 (id);
			return NULL;
		} else {
			_vala_code_node_unref0 (type);
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = _tmp3_;
	_tmp3_ = NULL;
	_vala_code_node_unref0 (type);
	type = _tmp6_;
	_tmp7_ = id;
	_tmp8_ = type;
	_tmp9_ = begin;
	_tmp10_ = vala_genie_parser_get_src (self, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->comment;
	_tmp13_ = vala_field_new (_tmp7_, _tmp8_, NULL, _tmp11_, _tmp12_);
	_tmp14_ = _tmp13_;
	_vala_source_reference_unref0 (_tmp11_);
	f = _tmp14_;
	_tmp17_ = flags;
	if ((_tmp17_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) == VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) {
		_tmp16_ = TRUE;
	} else {
		ValaGenieParserModifierFlags _tmp18_;
		_tmp18_ = flags;
		_tmp16_ = (_tmp18_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL) == VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		ValaGenieParserModifierFlags _tmp19_;
		_tmp19_ = flags;
		_tmp15_ = (_tmp19_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE;
	}
	if (_tmp15_) {
		ValaField* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaSourceReference* _tmp22_;
		_tmp20_ = f;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp20_);
		_tmp22_ = _tmp21_;
		vala_report_error (_tmp22_, "abstract, virtual, and override modifiers are not applicable to fields");
	}
	_tmp23_ = flags;
	if ((_tmp23_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		ValaField* _tmp24_;
		_tmp24_ = f;
		vala_symbol_set_access ((ValaSymbol*) _tmp24_, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		ValaGenieParserModifierFlags _tmp25_;
		_tmp25_ = flags;
		if ((_tmp25_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) {
			ValaField* _tmp26_;
			_tmp26_ = f;
			vala_symbol_set_access ((ValaSymbol*) _tmp26_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
		} else {
			ValaField* _tmp27_;
			const gchar* _tmp28_;
			_tmp27_ = f;
			_tmp28_ = id;
			vala_symbol_set_access ((ValaSymbol*) _tmp27_, vala_genie_parser_get_default_accessibility (self, _tmp28_));
		}
	}
	_tmp29_ = f;
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp29_, attrs);
	_tmp31_ = flags;
	if ((_tmp31_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp30_ = TRUE;
	} else {
		ValaGenieScanner* _tmp32_;
		ValaSourceFile* _tmp33_;
		ValaSourceFile* _tmp34_;
		ValaSourceFileType _tmp35_;
		ValaSourceFileType _tmp36_;
		_tmp32_ = self->priv->scanner;
		_tmp33_ = vala_genie_scanner_get_source_file (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_source_file_get_file_type (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp30_ = _tmp36_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	}
	if (_tmp30_) {
		ValaField* _tmp37_;
		_tmp37_ = f;
		vala_symbol_set_external ((ValaSymbol*) _tmp37_, TRUE);
	}
	_tmp38_ = flags;
	if ((_tmp38_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) == VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) {
		ValaField* _tmp39_;
		_tmp39_ = f;
		vala_symbol_set_hides ((ValaSymbol*) _tmp39_, TRUE);
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp40_ = NULL;
		ValaExpression* _tmp41_;
		ValaField* _tmp42_;
		_tmp41_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
		_tmp40_ = _tmp41_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (f);
				_vala_code_node_unref0 (_tmp3_);
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				return NULL;
			} else {
				_vala_code_node_unref0 (f);
				_vala_code_node_unref0 (_tmp3_);
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp42_ = f;
		vala_variable_set_initializer ((ValaVariable*) _tmp42_, _tmp40_);
		_vala_code_node_unref0 (_tmp40_);
	}
	_tmp43_ = flags;
	if ((_tmp43_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) == VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) {
		ValaField* _tmp44_;
		_tmp44_ = f;
		vala_field_set_binding (_tmp44_, VALA_MEMBER_BINDING_STATIC);
	} else {
		ValaGenieParserModifierFlags _tmp45_;
		_tmp45_ = flags;
		if ((_tmp45_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) == VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) {
			ValaField* _tmp46_;
			_tmp46_ = f;
			vala_field_set_binding (_tmp46_, VALA_MEMBER_BINDING_CLASS);
		}
	}
	vala_genie_parser_expect_terminator (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (f);
			_vala_code_node_unref0 (_tmp3_);
			_vala_code_node_unref0 (type);
			_g_free0 (id);
			return NULL;
		} else {
			_vala_code_node_unref0 (f);
			_vala_code_node_unref0 (_tmp3_);
			_vala_code_node_unref0 (type);
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = f;
	_vala_code_node_unref0 (_tmp3_);
	_vala_code_node_unref0 (type);
	_g_free0 (id);
	return result;
}

static ValaInitializerList*
vala_genie_parser_parse_initializer (ValaGenieParser* self,
                                     GError** error)
{
	ValaInitializerList* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaInitializerList* initializer = NULL;
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaInitializerList* _tmp4_;
	ValaInitializerList* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp1_ = begin;
	_tmp2_ = vala_genie_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_initializer_list_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	initializer = _tmp5_;
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				ValaExpression* init = NULL;
				ValaExpression* _tmp7_;
				ValaInitializerList* _tmp8_;
				ValaExpression* _tmp9_;
				if (!_tmp6_) {
					if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp6_ = FALSE;
				_tmp7_ = vala_genie_parser_parse_argument (self, &_inner_error0_);
				init = _tmp7_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (initializer);
						return NULL;
					} else {
						_vala_code_node_unref0 (initializer);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp8_ = initializer;
				_tmp9_ = init;
				vala_initializer_list_append (_tmp8_, _tmp9_);
				_vala_code_node_unref0 (init);
			}
		}
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (initializer);
				return NULL;
			} else {
				_vala_code_node_unref0 (initializer);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	result = initializer;
	return result;
}

static ValaMethod*
vala_genie_parser_parse_main_method_declaration (ValaGenieParser* self,
                                                 ValaList* attrs,
                                                 GError** error)
{
	ValaMethod* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaDataType* type = NULL;
	ValaMethod* method = NULL;
	ValaDataType* _tmp16_;
	ValaSourceLocation _tmp17_;
	ValaSourceReference* _tmp18_;
	ValaSourceReference* _tmp19_;
	ValaComment* _tmp20_;
	ValaMethod* _tmp21_;
	ValaMethod* _tmp22_;
	ValaMethod* _tmp23_;
	ValaMethod* _tmp24_;
	ValaMethod* _tmp25_;
	ValaUnresolvedSymbol* sym = NULL;
	ValaSourceLocation _tmp26_;
	ValaSourceReference* _tmp27_;
	ValaSourceReference* _tmp28_;
	ValaUnresolvedSymbol* _tmp29_;
	ValaUnresolvedSymbol* _tmp30_;
	ValaUnresolvedSymbol* _tmp31_;
	ValaSourceLocation _tmp32_;
	ValaSourceReference* _tmp33_;
	ValaSourceReference* _tmp34_;
	ValaUnresolvedType* _tmp35_;
	ValaDataType* _tmp36_;
	ValaDataType* _tmp37_;
	ValaSourceLocation _tmp38_;
	ValaSourceReference* _tmp39_;
	ValaSourceReference* _tmp40_;
	ValaArrayType* _tmp41_;
	ValaDataType* _tmp42_;
	ValaParameter* param = NULL;
	ValaDataType* _tmp43_;
	ValaSourceLocation _tmp44_;
	ValaSourceReference* _tmp45_;
	ValaSourceReference* _tmp46_;
	ValaParameter* _tmp47_;
	ValaParameter* _tmp48_;
	ValaMethod* _tmp49_;
	ValaParameter* _tmp50_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INIT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		ValaDataType* _tmp1_ = NULL;
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp2_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_vala_code_node_unref0 (type);
		type = _tmp3_;
		_tmp4_ = type;
		_tmp5_ = vala_code_node_to_string ((ValaCodeNode*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp6_, "int") != 0;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			ValaDataType* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GError* _tmp13_;
			GError* _tmp14_;
			_tmp8_ = type;
			_tmp9_ = vala_code_node_to_string ((ValaCodeNode*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strdup_printf ("main `init' must return void or `int', but got `%s'", _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, _tmp12_);
			_tmp14_ = _tmp13_;
			_g_free0 (_tmp12_);
			_g_free0 (_tmp10_);
			_inner_error0_ = _tmp14_;
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (_tmp1_);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_code_node_unref0 (_tmp1_);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_vala_code_node_unref0 (_tmp1_);
	} else {
		ValaVoidType* _tmp15_;
		_tmp15_ = vala_void_type_new (NULL);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp15_;
	}
	_tmp16_ = type;
	_tmp17_ = begin;
	_tmp18_ = vala_genie_parser_get_src (self, &_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = self->priv->comment;
	_tmp21_ = vala_method_new ("main", _tmp16_, _tmp19_, _tmp20_);
	_tmp22_ = _tmp21_;
	_vala_source_reference_unref0 (_tmp19_);
	method = _tmp22_;
	_tmp23_ = method;
	vala_symbol_set_access ((ValaSymbol*) _tmp23_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp24_ = method;
	vala_method_set_binding (_tmp24_, VALA_MEMBER_BINDING_STATIC);
	_tmp25_ = method;
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp25_, attrs);
	_tmp26_ = begin;
	_tmp27_ = vala_genie_parser_get_src (self, &_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_unresolved_symbol_new (NULL, "string", _tmp28_);
	_tmp30_ = _tmp29_;
	_vala_source_reference_unref0 (_tmp28_);
	sym = _tmp30_;
	_tmp31_ = sym;
	_tmp32_ = begin;
	_tmp33_ = vala_genie_parser_get_src (self, &_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_unresolved_type_new_from_symbol (_tmp31_, _tmp34_);
	_vala_code_node_unref0 (type);
	type = (ValaDataType*) _tmp35_;
	_vala_source_reference_unref0 (_tmp34_);
	_tmp36_ = type;
	vala_data_type_set_value_owned (_tmp36_, TRUE);
	_tmp37_ = type;
	_tmp38_ = begin;
	_tmp39_ = vala_genie_parser_get_src (self, &_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = vala_array_type_new (_tmp37_, 1, _tmp40_);
	_vala_code_node_unref0 (type);
	type = (ValaDataType*) _tmp41_;
	_vala_source_reference_unref0 (_tmp40_);
	_tmp42_ = type;
	vala_data_type_set_nullable (_tmp42_, FALSE);
	_tmp43_ = type;
	_tmp44_ = begin;
	_tmp45_ = vala_genie_parser_get_src (self, &_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_parameter_new ("args", _tmp43_, _tmp46_);
	_tmp48_ = _tmp47_;
	_vala_source_reference_unref0 (_tmp46_);
	param = _tmp48_;
	_tmp49_ = method;
	_tmp50_ = param;
	vala_callable_add_parameter ((ValaCallable*) _tmp49_, _tmp50_);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (method);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (method);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept_block (self)) {
		ValaBlock* _tmp51_ = NULL;
		ValaBlock* _tmp52_;
		ValaMethod* _tmp53_;
		_tmp52_ = vala_genie_parser_parse_block (self, &_inner_error0_);
		_tmp51_ = _tmp52_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (method);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (method);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp53_ = method;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp53_, _tmp51_);
		_vala_code_node_unref0 (_tmp51_);
	}
	result = method;
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (sym);
	_vala_code_node_unref0 (type);
	return result;
}

static ValaMethod*
vala_genie_parser_parse_method_declaration (ValaGenieParser* self,
                                            ValaList* attrs,
                                            GError** error)
{
	ValaMethod* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaDataType* type = NULL;
	ValaGenieParserModifierFlags flags = 0;
	gchar* id = NULL;
	gchar* _tmp1_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	ValaList* type_param_list = NULL;
	ValaList* _tmp12_;
	ValaMethod* method = NULL;
	const gchar* _tmp13_;
	ValaDataType* _tmp14_;
	ValaSourceLocation _tmp15_;
	ValaSourceReference* _tmp16_;
	ValaSourceReference* _tmp17_;
	ValaComment* _tmp18_;
	ValaMethod* _tmp19_;
	ValaMethod* _tmp20_;
	ValaGenieParserModifierFlags _tmp21_;
	ValaMethod* _tmp27_;
	gboolean _tmp50_ = FALSE;
	ValaGenieParserModifierFlags _tmp51_;
	ValaGenieParserModifierFlags _tmp56_;
	ValaGenieParserModifierFlags _tmp58_;
	ValaMethod* _tmp60_;
	ValaMemberBinding _tmp61_;
	ValaMemberBinding _tmp62_;
	ValaGenieParserModifierFlags _tmp99_;
	ValaGenieParserModifierFlags _tmp101_;
	ValaSourceLocation body_location = {0};
	ValaSourceLocation _tmp103_ = {0};
	ValaSourceLocation _tmp118_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEF, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	_tmp1_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
	id = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	params = _tmp3_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_iterable_unref0 (params);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_iterable_unref0 (params);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaParameter* _tmp5_;
				ValaArrayList* _tmp6_;
				ValaParameter* _tmp7_;
				if (!_tmp4_) {
					if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp4_ = FALSE;
				_tmp5_ = vala_genie_parser_parse_parameter (self, &_inner_error0_);
				param = _tmp5_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						return NULL;
					} else {
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp6_ = params;
				_tmp7_ = param;
				vala_collection_add ((ValaCollection*) _tmp6_, _tmp7_);
				_vala_code_node_unref0 (param);
			}
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_iterable_unref0 (params);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_iterable_unref0 (params);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		ValaDataType* _tmp8_ = NULL;
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		_tmp9_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
		_tmp8_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_iterable_unref0 (params);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_iterable_unref0 (params);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp10_ = _tmp8_;
		_tmp8_ = NULL;
		_vala_code_node_unref0 (type);
		type = _tmp10_;
		_vala_code_node_unref0 (_tmp8_);
	} else {
		ValaVoidType* _tmp11_;
		_tmp11_ = vala_void_type_new (NULL);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp11_;
	}
	_tmp12_ = vala_genie_parser_parse_type_parameter_list (self, &_inner_error0_);
	type_param_list = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_iterable_unref0 (params);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_iterable_unref0 (params);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp13_ = id;
	_tmp14_ = type;
	_tmp15_ = begin;
	_tmp16_ = vala_genie_parser_get_src (self, &_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->comment;
	_tmp19_ = vala_method_new (_tmp13_, _tmp14_, _tmp17_, _tmp18_);
	_tmp20_ = _tmp19_;
	_vala_source_reference_unref0 (_tmp17_);
	method = _tmp20_;
	_tmp21_ = flags;
	if ((_tmp21_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		ValaMethod* _tmp22_;
		_tmp22_ = method;
		vala_symbol_set_access ((ValaSymbol*) _tmp22_, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		ValaGenieParserModifierFlags _tmp23_;
		_tmp23_ = flags;
		if ((_tmp23_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) {
			ValaMethod* _tmp24_;
			_tmp24_ = method;
			vala_symbol_set_access ((ValaSymbol*) _tmp24_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
		} else {
			ValaMethod* _tmp25_;
			const gchar* _tmp26_;
			_tmp25_ = method;
			_tmp26_ = id;
			vala_symbol_set_access ((ValaSymbol*) _tmp25_, vala_genie_parser_get_default_accessibility (self, _tmp26_));
		}
	}
	_tmp27_ = method;
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp27_, attrs);
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp28_;
		ValaList* _tmp29_;
		gint _type_param_size = 0;
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _type_param_index = 0;
		_tmp28_ = type_param_list;
		_tmp29_ = _vala_iterable_ref0 (_tmp28_);
		_type_param_list = _tmp29_;
		_tmp30_ = _type_param_list;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_type_param_size = _tmp32_;
		_type_param_index = -1;
		while (TRUE) {
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp33_;
			gpointer _tmp34_;
			ValaMethod* _tmp35_;
			ValaTypeParameter* _tmp36_;
			_type_param_index = _type_param_index + 1;
			if (!(_type_param_index < _type_param_size)) {
				break;
			}
			_tmp33_ = _type_param_list;
			_tmp34_ = vala_list_get (_tmp33_, _type_param_index);
			type_param = (ValaTypeParameter*) _tmp34_;
			_tmp35_ = method;
			_tmp36_ = type_param;
			vala_method_add_type_parameter (_tmp35_, _tmp36_);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	{
		ValaArrayList* _param_list = NULL;
		ValaArrayList* _tmp37_;
		ValaArrayList* _tmp38_;
		gint _param_size = 0;
		ValaArrayList* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _param_index = 0;
		_tmp37_ = params;
		_tmp38_ = _vala_iterable_ref0 (_tmp37_);
		_param_list = _tmp38_;
		_tmp39_ = _param_list;
		_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
		_tmp41_ = _tmp40_;
		_param_size = _tmp41_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaArrayList* _tmp42_;
			gpointer _tmp43_;
			ValaMethod* _tmp44_;
			ValaParameter* _tmp45_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp42_ = _param_list;
			_tmp43_ = vala_list_get ((ValaList*) _tmp42_, _param_index);
			param = (ValaParameter*) _tmp43_;
			_tmp44_ = method;
			_tmp45_ = param;
			vala_callable_add_parameter ((ValaCallable*) _tmp44_, _tmp45_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_RAISES)) {
		{
			gboolean _tmp46_ = FALSE;
			_tmp46_ = TRUE;
			while (TRUE) {
				ValaDataType* _tmp47_ = NULL;
				ValaDataType* _tmp48_;
				ValaMethod* _tmp49_;
				if (!_tmp46_) {
					if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp46_ = FALSE;
				_tmp48_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
				_tmp47_ = _tmp48_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						return NULL;
					} else {
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp49_ = method;
				vala_method_add_error_type (_tmp49_, _tmp47_);
				_vala_code_node_unref0 (_tmp47_);
			}
		}
	}
	_tmp51_ = flags;
	if ((_tmp51_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) == VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) {
		_tmp50_ = TRUE;
	} else {
		const gchar* _tmp52_;
		_tmp52_ = id;
		_tmp50_ = g_strcmp0 (_tmp52_, "main") == 0;
	}
	if (_tmp50_) {
		ValaMethod* _tmp53_;
		_tmp53_ = method;
		vala_method_set_binding (_tmp53_, VALA_MEMBER_BINDING_STATIC);
	} else {
		ValaGenieParserModifierFlags _tmp54_;
		_tmp54_ = flags;
		if ((_tmp54_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) == VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) {
			ValaMethod* _tmp55_;
			_tmp55_ = method;
			vala_method_set_binding (_tmp55_, VALA_MEMBER_BINDING_CLASS);
		}
	}
	_tmp56_ = flags;
	if ((_tmp56_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_ASYNC) == VALA_GENIE_PARSER_MODIFIER_FLAGS_ASYNC) {
		ValaMethod* _tmp57_;
		_tmp57_ = method;
		vala_method_set_coroutine (_tmp57_, TRUE);
	}
	_tmp58_ = flags;
	if ((_tmp58_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) == VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) {
		ValaMethod* _tmp59_;
		_tmp59_ = method;
		vala_symbol_set_hides ((ValaSymbol*) _tmp59_, TRUE);
	}
	_tmp60_ = method;
	_tmp61_ = vala_method_get_binding (_tmp60_);
	_tmp62_ = _tmp61_;
	if (_tmp62_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaGenieParserModifierFlags _tmp63_;
		ValaGenieParserModifierFlags _tmp65_;
		ValaGenieParserModifierFlags _tmp67_;
		gboolean _tmp69_ = FALSE;
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMethod* _tmp72_;
		gboolean _tmp73_;
		gboolean _tmp74_;
		_tmp63_ = flags;
		if ((_tmp63_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) == VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) {
			ValaMethod* _tmp64_;
			_tmp64_ = method;
			vala_method_set_is_abstract (_tmp64_, TRUE);
		}
		_tmp65_ = flags;
		if ((_tmp65_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL) == VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL) {
			ValaMethod* _tmp66_;
			_tmp66_ = method;
			vala_method_set_is_virtual (_tmp66_, TRUE);
		}
		_tmp67_ = flags;
		if ((_tmp67_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE) {
			ValaMethod* _tmp68_;
			_tmp68_ = method;
			vala_method_set_overrides (_tmp68_, TRUE);
		}
		_tmp72_ = method;
		_tmp73_ = vala_method_get_is_abstract (_tmp72_);
		_tmp74_ = _tmp73_;
		if (_tmp74_) {
			ValaMethod* _tmp75_;
			gboolean _tmp76_;
			gboolean _tmp77_;
			_tmp75_ = method;
			_tmp76_ = vala_method_get_is_virtual (_tmp75_);
			_tmp77_ = _tmp76_;
			_tmp71_ = _tmp77_;
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			gboolean _tmp78_ = FALSE;
			ValaMethod* _tmp79_;
			gboolean _tmp80_;
			gboolean _tmp81_;
			_tmp79_ = method;
			_tmp80_ = vala_method_get_is_abstract (_tmp79_);
			_tmp81_ = _tmp80_;
			if (_tmp81_) {
				ValaMethod* _tmp82_;
				gboolean _tmp83_;
				gboolean _tmp84_;
				_tmp82_ = method;
				_tmp83_ = vala_method_get_overrides (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp78_ = _tmp84_;
			} else {
				_tmp78_ = FALSE;
			}
			_tmp70_ = _tmp78_;
		}
		if (_tmp70_) {
			_tmp69_ = TRUE;
		} else {
			gboolean _tmp85_ = FALSE;
			ValaMethod* _tmp86_;
			gboolean _tmp87_;
			gboolean _tmp88_;
			_tmp86_ = method;
			_tmp87_ = vala_method_get_is_virtual (_tmp86_);
			_tmp88_ = _tmp87_;
			if (_tmp88_) {
				ValaMethod* _tmp89_;
				gboolean _tmp90_;
				gboolean _tmp91_;
				_tmp89_ = method;
				_tmp90_ = vala_method_get_overrides (_tmp89_);
				_tmp91_ = _tmp90_;
				_tmp85_ = _tmp91_;
			} else {
				_tmp85_ = FALSE;
			}
			_tmp69_ = _tmp85_;
		}
		if (_tmp69_) {
			GError* _tmp92_;
			_tmp92_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "only one of `abstract', `virtual', or `override' may be specified");
			_inner_error0_ = _tmp92_;
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_iterable_unref0 (params);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_iterable_unref0 (params);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	} else {
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaGenieParserModifierFlags _tmp95_;
		_tmp95_ = flags;
		if ((_tmp95_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) == VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) {
			_tmp94_ = TRUE;
		} else {
			ValaGenieParserModifierFlags _tmp96_;
			_tmp96_ = flags;
			_tmp94_ = (_tmp96_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL) == VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL;
		}
		if (_tmp94_) {
			_tmp93_ = TRUE;
		} else {
			ValaGenieParserModifierFlags _tmp97_;
			_tmp97_ = flags;
			_tmp93_ = (_tmp97_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE;
		}
		if (_tmp93_) {
			GError* _tmp98_;
			_tmp98_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "the modifiers `abstract', `virtual', and `override' are not valid for " \
"static methods");
			_inner_error0_ = _tmp98_;
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_iterable_unref0 (params);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_iterable_unref0 (params);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp99_ = flags;
	if ((_tmp99_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE) {
		ValaMethod* _tmp100_;
		_tmp100_ = method;
		vala_method_set_is_inline (_tmp100_, TRUE);
	}
	_tmp101_ = flags;
	if ((_tmp101_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) {
		ValaMethod* _tmp102_;
		_tmp102_ = method;
		vala_symbol_set_external ((ValaSymbol*) _tmp102_, TRUE);
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (method);
			_vala_iterable_unref0 (type_param_list);
			_vala_iterable_unref0 (params);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (method);
			_vala_iterable_unref0 (type_param_list);
			_vala_iterable_unref0 (params);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_get_location (self, &_tmp103_);
	body_location = _tmp103_;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT)) {
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_REQUIRES)) {
			gboolean _tmp104_ = FALSE;
			if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
				_tmp104_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT);
			} else {
				_tmp104_ = FALSE;
			}
			if (_tmp104_) {
				while (TRUE) {
					ValaExpression* _tmp105_ = NULL;
					ValaExpression* _tmp106_;
					ValaMethod* _tmp107_;
					if (!(vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT)) {
						break;
					}
					_tmp106_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
					_tmp105_ = _tmp106_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_vala_code_node_unref0 (method);
							_vala_iterable_unref0 (type_param_list);
							_vala_iterable_unref0 (params);
							_g_free0 (id);
							_vala_code_node_unref0 (type);
							return NULL;
						} else {
							_vala_code_node_unref0 (method);
							_vala_iterable_unref0 (type_param_list);
							_vala_iterable_unref0 (params);
							_g_free0 (id);
							_vala_code_node_unref0 (type);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp107_ = method;
					vala_method_add_precondition (_tmp107_, _tmp105_);
					vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_vala_code_node_unref0 (_tmp105_);
							_vala_code_node_unref0 (method);
							_vala_iterable_unref0 (type_param_list);
							_vala_iterable_unref0 (params);
							_g_free0 (id);
							_vala_code_node_unref0 (type);
							return NULL;
						} else {
							_vala_code_node_unref0 (_tmp105_);
							_vala_code_node_unref0 (method);
							_vala_iterable_unref0 (type_param_list);
							_vala_iterable_unref0 (params);
							_g_free0 (id);
							_vala_code_node_unref0 (type);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_vala_code_node_unref0 (_tmp105_);
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						return NULL;
					} else {
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				vala_genie_parser_accept_terminator (self);
			} else {
				ValaExpression* _tmp108_ = NULL;
				ValaExpression* _tmp109_;
				ValaMethod* _tmp110_;
				_tmp109_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
				_tmp108_ = _tmp109_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						return NULL;
					} else {
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp110_ = method;
				vala_method_add_precondition (_tmp110_, _tmp108_);
				vala_genie_parser_expect_terminator (self, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (_tmp108_);
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						return NULL;
					} else {
						_vala_code_node_unref0 (_tmp108_);
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_vala_code_node_unref0 (_tmp108_);
			}
		}
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ENSURES)) {
			gboolean _tmp111_ = FALSE;
			if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
				_tmp111_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT);
			} else {
				_tmp111_ = FALSE;
			}
			if (_tmp111_) {
				while (TRUE) {
					ValaExpression* _tmp112_ = NULL;
					ValaExpression* _tmp113_;
					ValaMethod* _tmp114_;
					if (!(vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT)) {
						break;
					}
					_tmp113_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
					_tmp112_ = _tmp113_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_vala_code_node_unref0 (method);
							_vala_iterable_unref0 (type_param_list);
							_vala_iterable_unref0 (params);
							_g_free0 (id);
							_vala_code_node_unref0 (type);
							return NULL;
						} else {
							_vala_code_node_unref0 (method);
							_vala_iterable_unref0 (type_param_list);
							_vala_iterable_unref0 (params);
							_g_free0 (id);
							_vala_code_node_unref0 (type);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp114_ = method;
					vala_method_add_postcondition (_tmp114_, _tmp112_);
					vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_vala_code_node_unref0 (_tmp112_);
							_vala_code_node_unref0 (method);
							_vala_iterable_unref0 (type_param_list);
							_vala_iterable_unref0 (params);
							_g_free0 (id);
							_vala_code_node_unref0 (type);
							return NULL;
						} else {
							_vala_code_node_unref0 (_tmp112_);
							_vala_code_node_unref0 (method);
							_vala_iterable_unref0 (type_param_list);
							_vala_iterable_unref0 (params);
							_g_free0 (id);
							_vala_code_node_unref0 (type);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_vala_code_node_unref0 (_tmp112_);
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						return NULL;
					} else {
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				vala_genie_parser_accept_terminator (self);
			} else {
				ValaExpression* _tmp115_ = NULL;
				ValaExpression* _tmp116_;
				ValaMethod* _tmp117_;
				_tmp116_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
				_tmp115_ = _tmp116_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						return NULL;
					} else {
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp117_ = method;
				vala_method_add_postcondition (_tmp117_, _tmp115_);
				vala_genie_parser_expect_terminator (self, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (_tmp115_);
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						return NULL;
					} else {
						_vala_code_node_unref0 (_tmp115_);
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_vala_code_node_unref0 (_tmp115_);
			}
		}
	}
	_tmp118_ = body_location;
	vala_genie_parser_rollback (self, &_tmp118_);
	if (vala_genie_parser_accept_block (self)) {
		ValaBlock* _tmp119_ = NULL;
		ValaBlock* _tmp120_;
		ValaMethod* _tmp121_;
		_tmp120_ = vala_genie_parser_parse_block (self, &_inner_error0_);
		_tmp119_ = _tmp120_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_iterable_unref0 (params);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_iterable_unref0 (params);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp121_ = method;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp121_, _tmp119_);
		_vala_code_node_unref0 (_tmp119_);
	} else {
		ValaGenieScanner* _tmp122_;
		ValaSourceFile* _tmp123_;
		ValaSourceFile* _tmp124_;
		ValaSourceFileType _tmp125_;
		ValaSourceFileType _tmp126_;
		_tmp122_ = self->priv->scanner;
		_tmp123_ = vala_genie_scanner_get_source_file (_tmp122_);
		_tmp124_ = _tmp123_;
		_tmp125_ = vala_source_file_get_file_type (_tmp124_);
		_tmp126_ = _tmp125_;
		if (_tmp126_ == VALA_SOURCE_FILE_TYPE_PACKAGE) {
			ValaMethod* _tmp127_;
			_tmp127_ = method;
			vala_symbol_set_external ((ValaSymbol*) _tmp127_, TRUE);
		}
	}
	result = method;
	_vala_iterable_unref0 (type_param_list);
	_vala_iterable_unref0 (params);
	_g_free0 (id);
	_vala_code_node_unref0 (type);
	return result;
}

static ValaProperty*
vala_genie_parser_parse_property_declaration (ValaGenieParser* self,
                                              ValaList* attrs,
                                              GError** error)
{
	ValaProperty* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gboolean readonly = FALSE;
	ValaGenieParserModifierFlags flags = 0;
	gchar* id = NULL;
	gchar* _tmp1_;
	ValaDataType* type = NULL;
	ValaDataType* _tmp2_;
	ValaProperty* prop = NULL;
	const gchar* _tmp3_;
	ValaDataType* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaComment* _tmp8_;
	ValaProperty* _tmp9_;
	ValaProperty* _tmp10_;
	ValaGenieParserModifierFlags _tmp11_;
	ValaProperty* _tmp17_;
	ValaGenieParserModifierFlags _tmp18_;
	ValaGenieParserModifierFlags _tmp22_;
	ValaGenieParserModifierFlags _tmp24_;
	ValaGenieParserModifierFlags _tmp26_;
	ValaGenieParserModifierFlags _tmp28_;
	gboolean _tmp30_ = FALSE;
	ValaGenieParserModifierFlags _tmp31_;
	ValaGenieParserModifierFlags _tmp38_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	readonly = FALSE;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_PROP, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	readonly = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_READONLY);
	_tmp1_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
	id = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = vala_genie_parser_parse_type (self, TRUE, TRUE, &_inner_error0_);
	type = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = id;
	_tmp4_ = type;
	_tmp5_ = begin;
	_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->comment;
	_tmp9_ = vala_property_new (_tmp3_, _tmp4_, NULL, NULL, _tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	_vala_source_reference_unref0 (_tmp7_);
	prop = _tmp10_;
	_tmp11_ = flags;
	if ((_tmp11_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		ValaProperty* _tmp12_;
		_tmp12_ = prop;
		vala_symbol_set_access ((ValaSymbol*) _tmp12_, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		ValaGenieParserModifierFlags _tmp13_;
		_tmp13_ = flags;
		if ((_tmp13_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) {
			ValaProperty* _tmp14_;
			_tmp14_ = prop;
			vala_symbol_set_access ((ValaSymbol*) _tmp14_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
		} else {
			ValaProperty* _tmp15_;
			const gchar* _tmp16_;
			_tmp15_ = prop;
			_tmp16_ = id;
			vala_symbol_set_access ((ValaSymbol*) _tmp15_, vala_genie_parser_get_default_accessibility (self, _tmp16_));
		}
	}
	_tmp17_ = prop;
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp17_, attrs);
	_tmp18_ = flags;
	if ((_tmp18_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) == VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) {
		ValaProperty* _tmp19_;
		_tmp19_ = prop;
		vala_property_set_binding (_tmp19_, VALA_MEMBER_BINDING_STATIC);
	} else {
		ValaGenieParserModifierFlags _tmp20_;
		_tmp20_ = flags;
		if ((_tmp20_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) == VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) {
			ValaProperty* _tmp21_;
			_tmp21_ = prop;
			vala_property_set_binding (_tmp21_, VALA_MEMBER_BINDING_CLASS);
		}
	}
	_tmp22_ = flags;
	if ((_tmp22_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) == VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) {
		ValaProperty* _tmp23_;
		_tmp23_ = prop;
		vala_property_set_is_abstract (_tmp23_, TRUE);
	}
	_tmp24_ = flags;
	if ((_tmp24_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL) == VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL) {
		ValaProperty* _tmp25_;
		_tmp25_ = prop;
		vala_property_set_is_virtual (_tmp25_, TRUE);
	}
	_tmp26_ = flags;
	if ((_tmp26_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE) {
		ValaProperty* _tmp27_;
		_tmp27_ = prop;
		vala_property_set_overrides (_tmp27_, TRUE);
	}
	_tmp28_ = flags;
	if ((_tmp28_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) == VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) {
		ValaProperty* _tmp29_;
		_tmp29_ = prop;
		vala_symbol_set_hides ((ValaSymbol*) _tmp29_, TRUE);
	}
	_tmp31_ = flags;
	if ((_tmp31_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp30_ = TRUE;
	} else {
		ValaGenieScanner* _tmp32_;
		ValaSourceFile* _tmp33_;
		ValaSourceFile* _tmp34_;
		ValaSourceFileType _tmp35_;
		ValaSourceFileType _tmp36_;
		_tmp32_ = self->priv->scanner;
		_tmp33_ = vala_genie_scanner_get_source_file (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_source_file_get_file_type (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp30_ = _tmp36_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	}
	if (_tmp30_) {
		ValaProperty* _tmp37_;
		_tmp37_ = prop;
		vala_symbol_set_external ((ValaSymbol*) _tmp37_, TRUE);
	}
	_tmp38_ = flags;
	if ((_tmp38_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_ASYNC) == VALA_GENIE_PARSER_MODIFIER_FLAGS_ASYNC) {
		ValaProperty* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		_tmp39_ = prop;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp39_);
		_tmp41_ = _tmp40_;
		vala_report_error (_tmp41_, "async properties are not supported yet");
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp42_ = NULL;
		ValaExpression* _tmp43_;
		ValaProperty* _tmp44_;
		_tmp43_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
		_tmp42_ = _tmp43_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (prop);
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				return NULL;
			} else {
				_vala_code_node_unref0 (prop);
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp44_ = prop;
		vala_property_set_initializer (_tmp44_, _tmp42_);
		_vala_code_node_unref0 (_tmp42_);
	}
	if (vala_genie_parser_accept_block (self)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (prop);
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				return NULL;
			} else {
				_vala_code_node_unref0 (prop);
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		while (TRUE) {
			ValaSourceLocation accessor_begin = {0};
			ValaSourceLocation _tmp45_ = {0};
			ValaList* attribs = NULL;
			ValaList* _tmp46_;
			ValaDataType* value_type = NULL;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			ValaDataType* _tmp49_;
			if (!(vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT)) {
				break;
			}
			vala_genie_parser_get_location (self, &_tmp45_);
			accessor_begin = _tmp45_;
			_tmp46_ = vala_genie_parser_parse_attributes (self, FALSE, &_inner_error0_);
			attribs = _tmp46_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (prop);
					_vala_code_node_unref0 (type);
					_g_free0 (id);
					return NULL;
				} else {
					_vala_code_node_unref0 (prop);
					_vala_code_node_unref0 (type);
					_g_free0 (id);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp47_ = type;
			_tmp48_ = vala_data_type_copy (_tmp47_);
			value_type = _tmp48_;
			_tmp49_ = value_type;
			vala_data_type_set_value_owned (_tmp49_, vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OWNED));
			if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_GET)) {
				ValaProperty* _tmp50_;
				ValaPropertyAccessor* _tmp51_;
				ValaPropertyAccessor* _tmp52_;
				ValaBlock* block = NULL;
				ValaProperty* _tmp58_;
				ValaDataType* _tmp59_;
				ValaBlock* _tmp60_;
				ValaSourceLocation _tmp61_;
				ValaSourceReference* _tmp62_;
				ValaSourceReference* _tmp63_;
				ValaPropertyAccessor* _tmp64_;
				ValaPropertyAccessor* _tmp65_;
				ValaProperty* _tmp66_;
				ValaPropertyAccessor* _tmp67_;
				ValaPropertyAccessor* _tmp68_;
				ValaList* _tmp69_;
				ValaProperty* _tmp70_;
				ValaPropertyAccessor* _tmp71_;
				ValaPropertyAccessor* _tmp72_;
				_tmp50_ = prop;
				_tmp51_ = vala_property_get_get_accessor (_tmp50_);
				_tmp52_ = _tmp51_;
				if (_tmp52_ != NULL) {
					GError* _tmp53_;
					_tmp53_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "property get accessor already defined");
					_inner_error0_ = _tmp53_;
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (value_type);
						_vala_iterable_unref0 (attribs);
						_vala_code_node_unref0 (prop);
						_vala_code_node_unref0 (type);
						_g_free0 (id);
						return NULL;
					} else {
						_vala_code_node_unref0 (value_type);
						_vala_iterable_unref0 (attribs);
						_vala_code_node_unref0 (prop);
						_vala_code_node_unref0 (type);
						_g_free0 (id);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				block = NULL;
				if (vala_genie_parser_accept_block (self)) {
					ValaBlock* _tmp54_ = NULL;
					ValaBlock* _tmp55_;
					ValaBlock* _tmp56_;
					ValaProperty* _tmp57_;
					_tmp55_ = vala_genie_parser_parse_block (self, &_inner_error0_);
					_tmp54_ = _tmp55_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_vala_code_node_unref0 (block);
							_vala_code_node_unref0 (value_type);
							_vala_iterable_unref0 (attribs);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (type);
							_g_free0 (id);
							return NULL;
						} else {
							_vala_code_node_unref0 (block);
							_vala_code_node_unref0 (value_type);
							_vala_iterable_unref0 (attribs);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (type);
							_g_free0 (id);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp56_ = _tmp54_;
					_tmp54_ = NULL;
					_vala_code_node_unref0 (block);
					block = _tmp56_;
					_tmp57_ = prop;
					vala_symbol_set_external ((ValaSymbol*) _tmp57_, FALSE);
					_vala_code_node_unref0 (_tmp54_);
				}
				_tmp58_ = prop;
				_tmp59_ = value_type;
				_tmp60_ = block;
				_tmp61_ = accessor_begin;
				_tmp62_ = vala_genie_parser_get_src (self, &_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp59_, _tmp60_, _tmp63_, NULL);
				_tmp65_ = _tmp64_;
				vala_property_set_get_accessor (_tmp58_, _tmp65_);
				_vala_code_node_unref0 (_tmp65_);
				_vala_source_reference_unref0 (_tmp63_);
				_tmp66_ = prop;
				_tmp67_ = vala_property_get_get_accessor (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = attribs;
				vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp68_, _tmp69_);
				_tmp70_ = prop;
				_tmp71_ = vala_property_get_get_accessor (_tmp70_);
				_tmp72_ = _tmp71_;
				vala_symbol_set_access ((ValaSymbol*) _tmp72_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
				_vala_code_node_unref0 (block);
			} else {
				gboolean _construct = FALSE;
				ValaProperty* _tmp83_;
				ValaPropertyAccessor* _tmp84_;
				ValaPropertyAccessor* _tmp85_;
				ValaBlock* block = NULL;
				ValaProperty* _tmp91_;
				ValaDataType* _tmp92_;
				ValaBlock* _tmp93_;
				ValaSourceLocation _tmp94_;
				ValaSourceReference* _tmp95_;
				ValaSourceReference* _tmp96_;
				ValaPropertyAccessor* _tmp97_;
				ValaPropertyAccessor* _tmp98_;
				ValaProperty* _tmp99_;
				ValaPropertyAccessor* _tmp100_;
				ValaPropertyAccessor* _tmp101_;
				ValaList* _tmp102_;
				ValaProperty* _tmp103_;
				ValaPropertyAccessor* _tmp104_;
				ValaPropertyAccessor* _tmp105_;
				_construct = FALSE;
				if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_SET)) {
					gboolean _tmp74_ = FALSE;
					ValaCodeContext* _tmp75_;
					ValaProfile _tmp76_;
					ValaProfile _tmp77_;
					if (readonly) {
						GError* _tmp73_;
						_tmp73_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "set block not allowed for a read only property");
						_inner_error0_ = _tmp73_;
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_vala_code_node_unref0 (value_type);
							_vala_iterable_unref0 (attribs);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (type);
							_g_free0 (id);
							return NULL;
						} else {
							_vala_code_node_unref0 (value_type);
							_vala_iterable_unref0 (attribs);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (type);
							_g_free0 (id);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp75_ = self->priv->context;
					_tmp76_ = vala_code_context_get_profile (_tmp75_);
					_tmp77_ = _tmp76_;
					if (_tmp77_ == VALA_PROFILE_GOBJECT) {
						_tmp74_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CONSTRUCT);
					} else {
						_tmp74_ = FALSE;
					}
					_construct = _tmp74_;
				} else {
					gboolean _tmp78_ = FALSE;
					ValaCodeContext* _tmp79_;
					ValaProfile _tmp80_;
					ValaProfile _tmp81_;
					_tmp79_ = self->priv->context;
					_tmp80_ = vala_code_context_get_profile (_tmp79_);
					_tmp81_ = _tmp80_;
					if (_tmp81_ == VALA_PROFILE_GOBJECT) {
						_tmp78_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CONSTRUCT);
					} else {
						_tmp78_ = FALSE;
					}
					if (_tmp78_) {
						_construct = TRUE;
					} else {
						if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
							GError* _tmp82_;
							_tmp82_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected get, set, or construct");
							_inner_error0_ = _tmp82_;
							if (_inner_error0_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error0_);
								_vala_code_node_unref0 (value_type);
								_vala_iterable_unref0 (attribs);
								_vala_code_node_unref0 (prop);
								_vala_code_node_unref0 (type);
								_g_free0 (id);
								return NULL;
							} else {
								_vala_code_node_unref0 (value_type);
								_vala_iterable_unref0 (attribs);
								_vala_code_node_unref0 (prop);
								_vala_code_node_unref0 (type);
								_g_free0 (id);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
					}
				}
				_tmp83_ = prop;
				_tmp84_ = vala_property_get_set_accessor (_tmp83_);
				_tmp85_ = _tmp84_;
				if (_tmp85_ != NULL) {
					GError* _tmp86_;
					_tmp86_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "property set accessor already defined");
					_inner_error0_ = _tmp86_;
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (value_type);
						_vala_iterable_unref0 (attribs);
						_vala_code_node_unref0 (prop);
						_vala_code_node_unref0 (type);
						_g_free0 (id);
						return NULL;
					} else {
						_vala_code_node_unref0 (value_type);
						_vala_iterable_unref0 (attribs);
						_vala_code_node_unref0 (prop);
						_vala_code_node_unref0 (type);
						_g_free0 (id);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				block = NULL;
				if (vala_genie_parser_accept_block (self)) {
					ValaBlock* _tmp87_ = NULL;
					ValaBlock* _tmp88_;
					ValaBlock* _tmp89_;
					ValaProperty* _tmp90_;
					_tmp88_ = vala_genie_parser_parse_block (self, &_inner_error0_);
					_tmp87_ = _tmp88_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_vala_code_node_unref0 (block);
							_vala_code_node_unref0 (value_type);
							_vala_iterable_unref0 (attribs);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (type);
							_g_free0 (id);
							return NULL;
						} else {
							_vala_code_node_unref0 (block);
							_vala_code_node_unref0 (value_type);
							_vala_iterable_unref0 (attribs);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (type);
							_g_free0 (id);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp89_ = _tmp87_;
					_tmp87_ = NULL;
					_vala_code_node_unref0 (block);
					block = _tmp89_;
					_tmp90_ = prop;
					vala_symbol_set_external ((ValaSymbol*) _tmp90_, FALSE);
					_vala_code_node_unref0 (_tmp87_);
				}
				_tmp91_ = prop;
				_tmp92_ = value_type;
				_tmp93_ = block;
				_tmp94_ = accessor_begin;
				_tmp95_ = vala_genie_parser_get_src (self, &_tmp94_);
				_tmp96_ = _tmp95_;
				_tmp97_ = vala_property_accessor_new (FALSE, !readonly, _construct, _tmp92_, _tmp93_, _tmp96_, NULL);
				_tmp98_ = _tmp97_;
				vala_property_set_set_accessor (_tmp91_, _tmp98_);
				_vala_code_node_unref0 (_tmp98_);
				_vala_source_reference_unref0 (_tmp96_);
				_tmp99_ = prop;
				_tmp100_ = vala_property_get_set_accessor (_tmp99_);
				_tmp101_ = _tmp100_;
				_tmp102_ = attribs;
				vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp101_, _tmp102_);
				_tmp103_ = prop;
				_tmp104_ = vala_property_get_set_accessor (_tmp103_);
				_tmp105_ = _tmp104_;
				vala_symbol_set_access ((ValaSymbol*) _tmp105_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
				_vala_code_node_unref0 (block);
			}
			_vala_code_node_unref0 (value_type);
			_vala_iterable_unref0 (attribs);
		}
		vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (prop);
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				return NULL;
			} else {
				_vala_code_node_unref0 (prop);
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	} else {
		ValaDataType* value_type = NULL;
		ValaDataType* _tmp106_;
		ValaDataType* _tmp107_;
		ValaDataType* _tmp108_;
		ValaProperty* _tmp109_;
		ValaDataType* _tmp110_;
		ValaSourceLocation _tmp111_;
		ValaSourceReference* _tmp112_;
		ValaSourceReference* _tmp113_;
		ValaPropertyAccessor* _tmp114_;
		ValaPropertyAccessor* _tmp115_;
		ValaProperty* _tmp116_;
		ValaPropertyAccessor* _tmp117_;
		ValaPropertyAccessor* _tmp118_;
		_tmp106_ = type;
		_tmp107_ = vala_data_type_copy (_tmp106_);
		value_type = _tmp107_;
		_tmp108_ = value_type;
		vala_data_type_set_value_owned (_tmp108_, FALSE);
		_tmp109_ = prop;
		_tmp110_ = value_type;
		_tmp111_ = begin;
		_tmp112_ = vala_genie_parser_get_src (self, &_tmp111_);
		_tmp113_ = _tmp112_;
		_tmp114_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp110_, NULL, _tmp113_, NULL);
		_tmp115_ = _tmp114_;
		vala_property_set_get_accessor (_tmp109_, _tmp115_);
		_vala_code_node_unref0 (_tmp115_);
		_vala_source_reference_unref0 (_tmp113_);
		_tmp116_ = prop;
		_tmp117_ = vala_property_get_get_accessor (_tmp116_);
		_tmp118_ = _tmp117_;
		vala_symbol_set_access ((ValaSymbol*) _tmp118_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		if (!readonly) {
			ValaDataType* _tmp119_;
			ValaDataType* _tmp120_;
			ValaDataType* _tmp121_;
			ValaProperty* _tmp122_;
			ValaDataType* _tmp123_;
			ValaSourceLocation _tmp124_;
			ValaSourceReference* _tmp125_;
			ValaSourceReference* _tmp126_;
			ValaPropertyAccessor* _tmp127_;
			ValaPropertyAccessor* _tmp128_;
			ValaProperty* _tmp129_;
			ValaPropertyAccessor* _tmp130_;
			ValaPropertyAccessor* _tmp131_;
			_tmp119_ = type;
			_tmp120_ = vala_data_type_copy (_tmp119_);
			_vala_code_node_unref0 (value_type);
			value_type = _tmp120_;
			_tmp121_ = value_type;
			vala_data_type_set_value_owned (_tmp121_, FALSE);
			_tmp122_ = prop;
			_tmp123_ = value_type;
			_tmp124_ = begin;
			_tmp125_ = vala_genie_parser_get_src (self, &_tmp124_);
			_tmp126_ = _tmp125_;
			_tmp127_ = vala_property_accessor_new (FALSE, TRUE, FALSE, _tmp123_, NULL, _tmp126_, NULL);
			_tmp128_ = _tmp127_;
			vala_property_set_set_accessor (_tmp122_, _tmp128_);
			_vala_code_node_unref0 (_tmp128_);
			_vala_source_reference_unref0 (_tmp126_);
			_tmp129_ = prop;
			_tmp130_ = vala_property_get_set_accessor (_tmp129_);
			_tmp131_ = _tmp130_;
			vala_symbol_set_access ((ValaSymbol*) _tmp131_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		}
		vala_genie_parser_expect_terminator (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (value_type);
				_vala_code_node_unref0 (prop);
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				return NULL;
			} else {
				_vala_code_node_unref0 (value_type);
				_vala_code_node_unref0 (prop);
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_vala_code_node_unref0 (value_type);
	}
	result = prop;
	_vala_code_node_unref0 (type);
	_g_free0 (id);
	return result;
}

static ValaSignal*
vala_genie_parser_parse_signal_declaration (ValaGenieParser* self,
                                            ValaList* attrs,
                                            GError** error)
{
	ValaSignal* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaDataType* type = NULL;
	ValaGenieParserModifierFlags flags = 0;
	gchar* id = NULL;
	gchar* _tmp1_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	ValaSignal* sig = NULL;
	const gchar* _tmp12_;
	ValaDataType* _tmp13_;
	ValaSourceLocation _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSourceReference* _tmp16_;
	ValaComment* _tmp17_;
	ValaSignal* _tmp18_;
	ValaSignal* _tmp19_;
	ValaGenieParserModifierFlags _tmp20_;
	ValaGenieParserModifierFlags _tmp26_;
	ValaGenieParserModifierFlags _tmp28_;
	ValaGenieParserModifierFlags _tmp30_;
	ValaSignal* _tmp34_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EVENT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	_tmp1_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
	id = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	params = _tmp3_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_iterable_unref0 (params);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_iterable_unref0 (params);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaParameter* _tmp5_;
				ValaArrayList* _tmp6_;
				ValaParameter* _tmp7_;
				if (!_tmp4_) {
					if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp4_ = FALSE;
				_tmp5_ = vala_genie_parser_parse_parameter (self, &_inner_error0_);
				param = _tmp5_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						return NULL;
					} else {
						_vala_iterable_unref0 (params);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp6_ = params;
				_tmp7_ = param;
				vala_collection_add ((ValaCollection*) _tmp6_, _tmp7_);
				_vala_code_node_unref0 (param);
			}
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_iterable_unref0 (params);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_iterable_unref0 (params);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		ValaDataType* _tmp8_ = NULL;
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		_tmp9_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
		_tmp8_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_iterable_unref0 (params);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_iterable_unref0 (params);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp10_ = _tmp8_;
		_tmp8_ = NULL;
		_vala_code_node_unref0 (type);
		type = _tmp10_;
		_vala_code_node_unref0 (_tmp8_);
	} else {
		ValaVoidType* _tmp11_;
		_tmp11_ = vala_void_type_new (NULL);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp11_;
	}
	_tmp12_ = id;
	_tmp13_ = type;
	_tmp14_ = begin;
	_tmp15_ = vala_genie_parser_get_src (self, &_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->comment;
	_tmp18_ = vala_signal_new (_tmp12_, _tmp13_, _tmp16_, _tmp17_);
	_tmp19_ = _tmp18_;
	_vala_source_reference_unref0 (_tmp16_);
	sig = _tmp19_;
	_tmp20_ = flags;
	if ((_tmp20_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		ValaSignal* _tmp21_;
		_tmp21_ = sig;
		vala_symbol_set_access ((ValaSymbol*) _tmp21_, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		ValaGenieParserModifierFlags _tmp22_;
		_tmp22_ = flags;
		if ((_tmp22_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) {
			ValaSignal* _tmp23_;
			_tmp23_ = sig;
			vala_symbol_set_access ((ValaSymbol*) _tmp23_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
		} else {
			ValaSignal* _tmp24_;
			const gchar* _tmp25_;
			_tmp24_ = sig;
			_tmp25_ = id;
			vala_symbol_set_access ((ValaSymbol*) _tmp24_, vala_genie_parser_get_default_accessibility (self, _tmp25_));
		}
	}
	_tmp26_ = flags;
	if ((_tmp26_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL) == VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL) {
		ValaSignal* _tmp27_;
		_tmp27_ = sig;
		vala_signal_set_is_virtual (_tmp27_, TRUE);
	}
	_tmp28_ = flags;
	if ((_tmp28_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) == VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) {
		ValaSignal* _tmp29_;
		_tmp29_ = sig;
		vala_symbol_set_hides ((ValaSymbol*) _tmp29_, TRUE);
	}
	_tmp30_ = flags;
	if ((_tmp30_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) == VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) {
		GError* _tmp31_;
		_tmp31_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "`static' modifier not allowed on signals");
		_inner_error0_ = _tmp31_;
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (sig);
			_vala_iterable_unref0 (params);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (sig);
			_vala_iterable_unref0 (params);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	} else {
		ValaGenieParserModifierFlags _tmp32_;
		_tmp32_ = flags;
		if ((_tmp32_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) == VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) {
			GError* _tmp33_;
			_tmp33_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "`class' modifier not allowed on signals");
			_inner_error0_ = _tmp33_;
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (sig);
				_vala_iterable_unref0 (params);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_code_node_unref0 (sig);
				_vala_iterable_unref0 (params);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp34_ = sig;
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp34_, attrs);
	{
		ValaArrayList* _formal_param_list = NULL;
		ValaArrayList* _tmp35_;
		ValaArrayList* _tmp36_;
		gint _formal_param_size = 0;
		ValaArrayList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint _formal_param_index = 0;
		_tmp35_ = params;
		_tmp36_ = _vala_iterable_ref0 (_tmp35_);
		_formal_param_list = _tmp36_;
		_tmp37_ = _formal_param_list;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_formal_param_size = _tmp39_;
		_formal_param_index = -1;
		while (TRUE) {
			ValaParameter* formal_param = NULL;
			ValaArrayList* _tmp40_;
			gpointer _tmp41_;
			ValaSignal* _tmp42_;
			ValaParameter* _tmp43_;
			_formal_param_index = _formal_param_index + 1;
			if (!(_formal_param_index < _formal_param_size)) {
				break;
			}
			_tmp40_ = _formal_param_list;
			_tmp41_ = vala_list_get ((ValaList*) _tmp40_, _formal_param_index);
			formal_param = (ValaParameter*) _tmp41_;
			_tmp42_ = sig;
			_tmp43_ = formal_param;
			vala_callable_add_parameter ((ValaCallable*) _tmp42_, _tmp43_);
			_vala_code_node_unref0 (formal_param);
		}
		_vala_iterable_unref0 (_formal_param_list);
	}
	if (!vala_genie_parser_accept_terminator (self)) {
		ValaBlock* _tmp44_ = NULL;
		ValaBlock* _tmp45_;
		ValaSignal* _tmp46_;
		_tmp45_ = vala_genie_parser_parse_block (self, &_inner_error0_);
		_tmp44_ = _tmp45_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (sig);
				_vala_iterable_unref0 (params);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_code_node_unref0 (sig);
				_vala_iterable_unref0 (params);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp46_ = sig;
		vala_signal_set_body (_tmp46_, _tmp44_);
		_vala_code_node_unref0 (_tmp44_);
	}
	result = sig;
	_vala_iterable_unref0 (params);
	_g_free0 (id);
	_vala_code_node_unref0 (type);
	return result;
}

static ValaConstructor*
vala_genie_parser_parse_constructor_declaration (ValaGenieParser* self,
                                                 ValaList* attrs,
                                                 GError** error)
{
	ValaConstructor* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaGenieParserModifierFlags flags = 0;
	ValaConstructor* c = NULL;
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaConstructor* _tmp4_;
	ValaConstructor* _tmp5_;
	ValaGenieParserModifierFlags _tmp6_;
	ValaBlock* _tmp10_ = NULL;
	ValaBlock* _tmp11_;
	ValaConstructor* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INIT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	_tmp1_ = begin;
	_tmp2_ = vala_genie_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_constructor_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	c = _tmp5_;
	_tmp6_ = flags;
	if ((_tmp6_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) == VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) {
		ValaConstructor* _tmp7_;
		_tmp7_ = c;
		vala_constructor_set_binding (_tmp7_, VALA_MEMBER_BINDING_STATIC);
	} else {
		ValaGenieParserModifierFlags _tmp8_;
		_tmp8_ = flags;
		if ((_tmp8_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) == VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) {
			ValaConstructor* _tmp9_;
			_tmp9_ = c;
			vala_constructor_set_binding (_tmp9_, VALA_MEMBER_BINDING_CLASS);
		}
	}
	vala_genie_parser_accept_block (self);
	_tmp11_ = vala_genie_parser_parse_block (self, &_inner_error0_);
	_tmp10_ = _tmp11_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (c);
			return NULL;
		} else {
			_vala_code_node_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp12_ = c;
	vala_subroutine_set_body ((ValaSubroutine*) _tmp12_, _tmp10_);
	result = c;
	_vala_code_node_unref0 (_tmp10_);
	return result;
}

static ValaDestructor*
vala_genie_parser_parse_destructor_declaration (ValaGenieParser* self,
                                                ValaList* attrs,
                                                GError** error)
{
	ValaDestructor* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaDestructor* d = NULL;
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaDestructor* _tmp4_;
	ValaDestructor* _tmp5_;
	ValaBlock* _tmp6_ = NULL;
	ValaBlock* _tmp7_;
	ValaDestructor* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_FINAL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = begin;
	_tmp2_ = vala_genie_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_destructor_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	d = _tmp5_;
	vala_genie_parser_accept_block (self);
	_tmp7_ = vala_genie_parser_parse_block (self, &_inner_error0_);
	_tmp6_ = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (d);
			return NULL;
		} else {
			_vala_code_node_unref0 (d);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp8_ = d;
	vala_subroutine_set_body ((ValaSubroutine*) _tmp8_, _tmp6_);
	result = d;
	_vala_code_node_unref0 (_tmp6_);
	return result;
}

static ValaSymbol*
vala_genie_parser_parse_struct_declaration (ValaGenieParser* self,
                                            ValaList* attrs,
                                            GError** error)
{
	ValaSymbol* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaGenieParserModifierFlags flags = 0;
	ValaUnresolvedSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp1_;
	ValaList* type_param_list = NULL;
	ValaList* _tmp2_;
	ValaDataType* base_type = NULL;
	ValaStruct* st = NULL;
	ValaUnresolvedSymbol* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	ValaSourceLocation _tmp9_;
	ValaSourceReference* _tmp10_;
	ValaSourceReference* _tmp11_;
	ValaComment* _tmp12_;
	ValaStruct* _tmp13_;
	ValaStruct* _tmp14_;
	ValaGenieParserModifierFlags _tmp15_;
	ValaStruct* _tmp23_;
	ValaDataType* _tmp33_;
	ValaStruct* _tmp36_;
	ValaSymbol* _result_ = NULL;
	ValaStruct* _tmp37_;
	ValaSymbol* _tmp38_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_STRUCT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_type_declaration_modifiers (self);
	_tmp1_ = vala_genie_parser_parse_symbol_name (self, &_inner_error0_);
	sym = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = vala_genie_parser_parse_type_parameter_list (self, &_inner_error0_);
	type_param_list = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (sym);
			return NULL;
		} else {
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	base_type = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		ValaDataType* _tmp3_ = NULL;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		_tmp4_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				return NULL;
			} else {
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_vala_code_node_unref0 (base_type);
		base_type = _tmp5_;
		_vala_code_node_unref0 (_tmp3_);
	}
	_tmp6_ = sym;
	_tmp7_ = vala_symbol_get_name ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = begin;
	_tmp10_ = vala_genie_parser_get_src (self, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->comment;
	_tmp13_ = vala_struct_new (_tmp8_, _tmp11_, _tmp12_);
	_tmp14_ = _tmp13_;
	_vala_source_reference_unref0 (_tmp11_);
	st = _tmp14_;
	_tmp15_ = flags;
	if ((_tmp15_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		ValaStruct* _tmp16_;
		_tmp16_ = st;
		vala_symbol_set_access ((ValaSymbol*) _tmp16_, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		ValaGenieParserModifierFlags _tmp17_;
		_tmp17_ = flags;
		if ((_tmp17_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) {
			ValaStruct* _tmp18_;
			_tmp18_ = st;
			vala_symbol_set_access ((ValaSymbol*) _tmp18_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
		} else {
			ValaStruct* _tmp19_;
			ValaUnresolvedSymbol* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			_tmp19_ = st;
			_tmp20_ = sym;
			_tmp21_ = vala_symbol_get_name ((ValaSymbol*) _tmp20_);
			_tmp22_ = _tmp21_;
			vala_symbol_set_access ((ValaSymbol*) _tmp19_, vala_genie_parser_get_default_accessibility (self, _tmp22_));
		}
	}
	_tmp23_ = st;
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp23_, attrs);
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp24_;
		ValaList* _tmp25_;
		gint _type_param_size = 0;
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _type_param_index = 0;
		_tmp24_ = type_param_list;
		_tmp25_ = _vala_iterable_ref0 (_tmp24_);
		_type_param_list = _tmp25_;
		_tmp26_ = _type_param_list;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_type_param_size = _tmp28_;
		_type_param_index = -1;
		while (TRUE) {
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp29_;
			gpointer _tmp30_;
			ValaStruct* _tmp31_;
			ValaTypeParameter* _tmp32_;
			_type_param_index = _type_param_index + 1;
			if (!(_type_param_index < _type_param_size)) {
				break;
			}
			_tmp29_ = _type_param_list;
			_tmp30_ = vala_list_get (_tmp29_, _type_param_index);
			type_param = (ValaTypeParameter*) _tmp30_;
			_tmp31_ = st;
			_tmp32_ = type_param;
			vala_struct_add_type_parameter (_tmp31_, _tmp32_);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	_tmp33_ = base_type;
	if (_tmp33_ != NULL) {
		ValaStruct* _tmp34_;
		ValaDataType* _tmp35_;
		_tmp34_ = st;
		_tmp35_ = base_type;
		vala_struct_set_base_type (_tmp34_, _tmp35_);
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (base_type);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			return NULL;
		} else {
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (base_type);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp36_ = st;
	vala_genie_parser_parse_declarations (self, (ValaSymbol*) _tmp36_, FALSE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (base_type);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			return NULL;
		} else {
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (base_type);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp37_ = st;
	_tmp38_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp37_);
	_result_ = _tmp38_;
	while (TRUE) {
		ValaUnresolvedSymbol* _tmp39_;
		ValaUnresolvedSymbol* _tmp40_;
		ValaUnresolvedSymbol* _tmp41_;
		ValaUnresolvedSymbol* _tmp42_;
		ValaUnresolvedSymbol* _tmp43_;
		ValaUnresolvedSymbol* _tmp44_;
		ValaUnresolvedSymbol* _tmp45_;
		ValaNamespace* ns = NULL;
		ValaUnresolvedSymbol* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		ValaStruct* _tmp49_;
		ValaSourceReference* _tmp50_;
		ValaSourceReference* _tmp51_;
		ValaNamespace* _tmp52_;
		ValaSymbol* _tmp53_;
		ValaNamespace* _tmp58_;
		ValaSymbol* _tmp59_;
		_tmp39_ = sym;
		_tmp40_ = vala_unresolved_symbol_get_inner (_tmp39_);
		_tmp41_ = _tmp40_;
		if (!(_tmp41_ != NULL)) {
			break;
		}
		_tmp42_ = sym;
		_tmp43_ = vala_unresolved_symbol_get_inner (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = _vala_code_node_ref0 (_tmp44_);
		_vala_code_node_unref0 (sym);
		sym = _tmp45_;
		_tmp46_ = sym;
		_tmp47_ = vala_symbol_get_name ((ValaSymbol*) _tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = st;
		_tmp50_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = vala_namespace_new (_tmp48_, _tmp51_);
		ns = _tmp52_;
		_tmp53_ = _result_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, VALA_TYPE_NAMESPACE)) {
			ValaNamespace* _tmp54_;
			ValaSymbol* _tmp55_;
			_tmp54_ = ns;
			_tmp55_ = _result_;
			vala_symbol_add_namespace ((ValaSymbol*) _tmp54_, G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_NAMESPACE, ValaNamespace));
		} else {
			ValaNamespace* _tmp56_;
			ValaSymbol* _tmp57_;
			_tmp56_ = ns;
			_tmp57_ = _result_;
			vala_symbol_add_struct ((ValaSymbol*) _tmp56_, G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_STRUCT, ValaStruct));
		}
		_tmp58_ = ns;
		_tmp59_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp58_);
		_vala_code_node_unref0 (_result_);
		_result_ = _tmp59_;
		_vala_code_node_unref0 (ns);
	}
	result = _result_;
	_vala_code_node_unref0 (st);
	_vala_code_node_unref0 (base_type);
	_vala_iterable_unref0 (type_param_list);
	_vala_code_node_unref0 (sym);
	return result;
}

static void
vala_genie_parser_parse_struct_member (ValaGenieParser* self,
                                       ValaStruct* st,
                                       GError** error)
{
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	_tmp0_ = vala_genie_parser_parse_declaration (self, FALSE, &_inner_error0_);
	sym = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
		vala_symbol_add_method ((ValaSymbol*) st, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
			vala_symbol_add_field ((ValaSymbol*) st, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
				vala_symbol_add_constant ((ValaSymbol*) st, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PROPERTY)) {
					vala_symbol_add_property ((ValaSymbol*) st, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
				} else {
					ValaSourceReference* _tmp1_;
					ValaSourceReference* _tmp2_;
					_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
					_tmp2_ = _tmp1_;
					vala_report_error (_tmp2_, "unexpected declaration in struct");
				}
			}
		}
	}
	_vala_code_node_unref0 (sym);
}

static ValaSymbol*
vala_genie_parser_parse_interface_declaration (ValaGenieParser* self,
                                               ValaList* attrs,
                                               GError** error)
{
	ValaSymbol* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaGenieParserModifierFlags flags = 0;
	ValaUnresolvedSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp1_;
	ValaList* type_param_list = NULL;
	ValaList* _tmp2_;
	ValaArrayList* base_types = NULL;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	ValaInterface* iface = NULL;
	ValaUnresolvedSymbol* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ValaSourceLocation _tmp12_;
	ValaSourceReference* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaComment* _tmp15_;
	ValaInterface* _tmp16_;
	ValaInterface* _tmp17_;
	ValaGenieParserModifierFlags _tmp18_;
	gboolean _tmp26_ = FALSE;
	ValaGenieParserModifierFlags _tmp27_;
	ValaInterface* _tmp34_;
	ValaInterface* _tmp53_;
	ValaSymbol* _result_ = NULL;
	ValaInterface* _tmp54_;
	ValaSymbol* _tmp55_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INTERFACE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_type_declaration_modifiers (self);
	_tmp1_ = vala_genie_parser_parse_symbol_name (self, &_inner_error0_);
	sym = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = vala_genie_parser_parse_type_parameter_list (self, &_inner_error0_);
	type_param_list = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (sym);
			return NULL;
		} else {
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
	base_types = _tmp4_;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				ValaDataType* type = NULL;
				ValaDataType* _tmp6_;
				ValaArrayList* _tmp7_;
				ValaDataType* _tmp8_;
				if (!_tmp5_) {
					if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp5_ = FALSE;
				_tmp6_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
				type = _tmp6_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_iterable_unref0 (base_types);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						return NULL;
					} else {
						_vala_iterable_unref0 (base_types);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp7_ = base_types;
				_tmp8_ = type;
				vala_collection_add ((ValaCollection*) _tmp7_, _tmp8_);
				_vala_code_node_unref0 (type);
			}
		}
	}
	_tmp9_ = sym;
	_tmp10_ = vala_symbol_get_name ((ValaSymbol*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = begin;
	_tmp13_ = vala_genie_parser_get_src (self, &_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->comment;
	_tmp16_ = vala_interface_new (_tmp11_, _tmp14_, _tmp15_);
	_tmp17_ = _tmp16_;
	_vala_source_reference_unref0 (_tmp14_);
	iface = _tmp17_;
	_tmp18_ = flags;
	if ((_tmp18_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		ValaInterface* _tmp19_;
		_tmp19_ = iface;
		vala_symbol_set_access ((ValaSymbol*) _tmp19_, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		ValaGenieParserModifierFlags _tmp20_;
		_tmp20_ = flags;
		if ((_tmp20_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) {
			ValaInterface* _tmp21_;
			_tmp21_ = iface;
			vala_symbol_set_access ((ValaSymbol*) _tmp21_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
		} else {
			ValaInterface* _tmp22_;
			ValaUnresolvedSymbol* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			_tmp22_ = iface;
			_tmp23_ = sym;
			_tmp24_ = vala_symbol_get_name ((ValaSymbol*) _tmp23_);
			_tmp25_ = _tmp24_;
			vala_symbol_set_access ((ValaSymbol*) _tmp22_, vala_genie_parser_get_default_accessibility (self, _tmp25_));
		}
	}
	_tmp27_ = flags;
	if ((_tmp27_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp26_ = TRUE;
	} else {
		ValaGenieScanner* _tmp28_;
		ValaSourceFile* _tmp29_;
		ValaSourceFile* _tmp30_;
		ValaSourceFileType _tmp31_;
		ValaSourceFileType _tmp32_;
		_tmp28_ = self->priv->scanner;
		_tmp29_ = vala_genie_scanner_get_source_file (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_source_file_get_file_type (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp26_ = _tmp32_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	}
	if (_tmp26_) {
		ValaInterface* _tmp33_;
		_tmp33_ = iface;
		vala_symbol_set_external ((ValaSymbol*) _tmp33_, TRUE);
	}
	_tmp34_ = iface;
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp34_, attrs);
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp35_;
		ValaList* _tmp36_;
		gint _type_param_size = 0;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint _type_param_index = 0;
		_tmp35_ = type_param_list;
		_tmp36_ = _vala_iterable_ref0 (_tmp35_);
		_type_param_list = _tmp36_;
		_tmp37_ = _type_param_list;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_type_param_size = _tmp39_;
		_type_param_index = -1;
		while (TRUE) {
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp40_;
			gpointer _tmp41_;
			ValaInterface* _tmp42_;
			ValaTypeParameter* _tmp43_;
			_type_param_index = _type_param_index + 1;
			if (!(_type_param_index < _type_param_size)) {
				break;
			}
			_tmp40_ = _type_param_list;
			_tmp41_ = vala_list_get (_tmp40_, _type_param_index);
			type_param = (ValaTypeParameter*) _tmp41_;
			_tmp42_ = iface;
			_tmp43_ = type_param;
			vala_object_type_symbol_add_type_parameter ((ValaObjectTypeSymbol*) _tmp42_, _tmp43_);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	{
		ValaArrayList* _base_type_list = NULL;
		ValaArrayList* _tmp44_;
		ValaArrayList* _tmp45_;
		gint _base_type_size = 0;
		ValaArrayList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint _base_type_index = 0;
		_tmp44_ = base_types;
		_tmp45_ = _vala_iterable_ref0 (_tmp44_);
		_base_type_list = _tmp45_;
		_tmp46_ = _base_type_list;
		_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_base_type_size = _tmp48_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaArrayList* _tmp49_;
			gpointer _tmp50_;
			ValaInterface* _tmp51_;
			ValaDataType* _tmp52_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp49_ = _base_type_list;
			_tmp50_ = vala_list_get ((ValaList*) _tmp49_, _base_type_index);
			base_type = (ValaDataType*) _tmp50_;
			_tmp51_ = iface;
			_tmp52_ = base_type;
			vala_interface_add_prerequisite (_tmp51_, _tmp52_);
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (iface);
			_vala_iterable_unref0 (base_types);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			return NULL;
		} else {
			_vala_code_node_unref0 (iface);
			_vala_iterable_unref0 (base_types);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp53_ = iface;
	vala_genie_parser_parse_declarations (self, (ValaSymbol*) _tmp53_, FALSE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (iface);
			_vala_iterable_unref0 (base_types);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			return NULL;
		} else {
			_vala_code_node_unref0 (iface);
			_vala_iterable_unref0 (base_types);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp54_ = iface;
	_tmp55_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp54_);
	_result_ = _tmp55_;
	while (TRUE) {
		ValaUnresolvedSymbol* _tmp56_;
		ValaUnresolvedSymbol* _tmp57_;
		ValaUnresolvedSymbol* _tmp58_;
		ValaUnresolvedSymbol* _tmp59_;
		ValaUnresolvedSymbol* _tmp60_;
		ValaUnresolvedSymbol* _tmp61_;
		ValaUnresolvedSymbol* _tmp62_;
		ValaNamespace* ns = NULL;
		ValaUnresolvedSymbol* _tmp63_;
		const gchar* _tmp64_;
		const gchar* _tmp65_;
		ValaInterface* _tmp66_;
		ValaSourceReference* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaNamespace* _tmp69_;
		ValaSymbol* _tmp70_;
		ValaNamespace* _tmp75_;
		ValaSymbol* _tmp76_;
		_tmp56_ = sym;
		_tmp57_ = vala_unresolved_symbol_get_inner (_tmp56_);
		_tmp58_ = _tmp57_;
		if (!(_tmp58_ != NULL)) {
			break;
		}
		_tmp59_ = sym;
		_tmp60_ = vala_unresolved_symbol_get_inner (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = _vala_code_node_ref0 (_tmp61_);
		_vala_code_node_unref0 (sym);
		sym = _tmp62_;
		_tmp63_ = sym;
		_tmp64_ = vala_symbol_get_name ((ValaSymbol*) _tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = iface;
		_tmp67_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp66_);
		_tmp68_ = _tmp67_;
		_tmp69_ = vala_namespace_new (_tmp65_, _tmp68_);
		ns = _tmp69_;
		_tmp70_ = _result_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, VALA_TYPE_NAMESPACE)) {
			ValaNamespace* _tmp71_;
			ValaSymbol* _tmp72_;
			_tmp71_ = ns;
			_tmp72_ = _result_;
			vala_symbol_add_namespace ((ValaSymbol*) _tmp71_, G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_NAMESPACE, ValaNamespace));
		} else {
			ValaNamespace* _tmp73_;
			ValaSymbol* _tmp74_;
			_tmp73_ = ns;
			_tmp74_ = _result_;
			vala_symbol_add_interface ((ValaSymbol*) _tmp73_, G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, VALA_TYPE_INTERFACE, ValaInterface));
		}
		_tmp75_ = ns;
		_tmp76_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp75_);
		_vala_code_node_unref0 (_result_);
		_result_ = _tmp76_;
		_vala_code_node_unref0 (ns);
	}
	result = _result_;
	_vala_code_node_unref0 (iface);
	_vala_iterable_unref0 (base_types);
	_vala_iterable_unref0 (type_param_list);
	_vala_code_node_unref0 (sym);
	return result;
}

static void
vala_genie_parser_parse_interface_member (ValaGenieParser* self,
                                          ValaInterface* iface,
                                          GError** error)
{
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_tmp0_ = vala_genie_parser_parse_declaration (self, FALSE, &_inner_error0_);
	sym = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
		vala_symbol_add_class ((ValaSymbol*) iface, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT)) {
			vala_symbol_add_struct ((ValaSymbol*) iface, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM)) {
				vala_symbol_add_enum ((ValaSymbol*) iface, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_DELEGATE)) {
					vala_symbol_add_delegate ((ValaSymbol*) iface, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_DELEGATE, ValaDelegate));
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
						vala_symbol_add_method ((ValaSymbol*) iface, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_SIGNAL)) {
							vala_symbol_add_signal ((ValaSymbol*) iface, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
								vala_symbol_add_field ((ValaSymbol*) iface, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
									vala_symbol_add_constant ((ValaSymbol*) iface, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PROPERTY)) {
										vala_symbol_add_property ((ValaSymbol*) iface, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									} else {
										ValaSourceReference* _tmp1_;
										ValaSourceReference* _tmp2_;
										_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
										_tmp2_ = _tmp1_;
										vala_report_error (_tmp2_, "unexpected declaration in interface");
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_vala_code_node_unref0 (sym);
}

static ValaSymbol*
vala_genie_parser_parse_enum_declaration (ValaGenieParser* self,
                                          ValaList* attrs,
                                          GError** error)
{
	ValaSymbol* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaGenieParserModifierFlags flags = 0;
	ValaUnresolvedSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp1_;
	ValaEnum* en = NULL;
	ValaUnresolvedSymbol* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaComment* _tmp8_;
	ValaEnum* _tmp9_;
	ValaEnum* _tmp10_;
	ValaGenieParserModifierFlags _tmp11_;
	gboolean _tmp19_ = FALSE;
	ValaGenieParserModifierFlags _tmp20_;
	ValaEnum* _tmp27_;
	ValaSymbol* _result_ = NULL;
	ValaEnum* _tmp56_;
	ValaSymbol* _tmp57_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ENUM, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_type_declaration_modifiers (self);
	_tmp1_ = vala_genie_parser_parse_symbol_name (self, &_inner_error0_);
	sym = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = sym;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = begin;
	_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->comment;
	_tmp9_ = vala_enum_new (_tmp4_, _tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	_vala_source_reference_unref0 (_tmp7_);
	en = _tmp10_;
	_tmp11_ = flags;
	if ((_tmp11_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		ValaEnum* _tmp12_;
		_tmp12_ = en;
		vala_symbol_set_access ((ValaSymbol*) _tmp12_, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		ValaGenieParserModifierFlags _tmp13_;
		_tmp13_ = flags;
		if ((_tmp13_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) {
			ValaEnum* _tmp14_;
			_tmp14_ = en;
			vala_symbol_set_access ((ValaSymbol*) _tmp14_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
		} else {
			ValaEnum* _tmp15_;
			ValaUnresolvedSymbol* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			_tmp15_ = en;
			_tmp16_ = sym;
			_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
			_tmp18_ = _tmp17_;
			vala_symbol_set_access ((ValaSymbol*) _tmp15_, vala_genie_parser_get_default_accessibility (self, _tmp18_));
		}
	}
	_tmp20_ = flags;
	if ((_tmp20_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp19_ = TRUE;
	} else {
		ValaGenieScanner* _tmp21_;
		ValaSourceFile* _tmp22_;
		ValaSourceFile* _tmp23_;
		ValaSourceFileType _tmp24_;
		ValaSourceFileType _tmp25_;
		_tmp21_ = self->priv->scanner;
		_tmp22_ = vala_genie_scanner_get_source_file (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_source_file_get_file_type (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp19_ = _tmp25_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	}
	if (_tmp19_) {
		ValaEnum* _tmp26_;
		_tmp26_ = en;
		vala_symbol_set_external ((ValaSymbol*) _tmp26_, TRUE);
	}
	_tmp27_ = en;
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp27_, attrs);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (en);
			_vala_code_node_unref0 (sym);
			return NULL;
		} else {
			_vala_code_node_unref0 (en);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (en);
			_vala_code_node_unref0 (sym);
			return NULL;
		} else {
			_vala_code_node_unref0 (en);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	while (TRUE) {
		gboolean _tmp28_ = FALSE;
		ValaList* value_attrs = NULL;
		ValaList* _tmp34_;
		ValaSourceLocation value_begin = {0};
		ValaSourceLocation _tmp35_ = {0};
		gchar* id = NULL;
		gchar* _tmp36_;
		ValaGenieScanner* _tmp37_;
		ValaComment* _tmp38_;
		ValaExpression* value = NULL;
		ValaEnumValue* ev = NULL;
		const gchar* _tmp42_;
		ValaExpression* _tmp43_;
		ValaSourceLocation _tmp44_;
		ValaSourceReference* _tmp45_;
		ValaSourceReference* _tmp46_;
		ValaComment* _tmp47_;
		ValaEnumValue* _tmp48_;
		ValaEnumValue* _tmp49_;
		ValaEnumValue* _tmp50_;
		ValaEnumValue* _tmp51_;
		ValaList* _tmp52_;
		ValaEnum* _tmp53_;
		ValaEnumValue* _tmp54_;
		gboolean _tmp55_ = FALSE;
		if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_DEDENT) {
			ValaEnum* _tmp29_;
			ValaList* _tmp30_;
			ValaList* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			_tmp29_ = en;
			_tmp30_ = vala_enum_get_values (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp28_ = _tmp33_ > 0;
			_vala_iterable_unref0 (_tmp31_);
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			break;
		}
		_tmp34_ = vala_genie_parser_parse_attributes (self, FALSE, &_inner_error0_);
		value_attrs = _tmp34_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (en);
				_vala_code_node_unref0 (sym);
				return NULL;
			} else {
				_vala_code_node_unref0 (en);
				_vala_code_node_unref0 (sym);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		vala_genie_parser_get_location (self, &_tmp35_);
		value_begin = _tmp35_;
		_tmp36_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
		id = _tmp36_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_iterable_unref0 (value_attrs);
				_vala_code_node_unref0 (en);
				_vala_code_node_unref0 (sym);
				return NULL;
			} else {
				_vala_iterable_unref0 (value_attrs);
				_vala_code_node_unref0 (en);
				_vala_code_node_unref0 (sym);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp37_ = self->priv->scanner;
		_tmp38_ = vala_genie_scanner_pop_comment (_tmp37_);
		_vala_comment_unref0 (self->priv->comment);
		self->priv->comment = _tmp38_;
		value = NULL;
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
			ValaExpression* _tmp39_ = NULL;
			ValaExpression* _tmp40_;
			ValaExpression* _tmp41_;
			_tmp40_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
			_tmp39_ = _tmp40_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (value);
					_g_free0 (id);
					_vala_iterable_unref0 (value_attrs);
					_vala_code_node_unref0 (en);
					_vala_code_node_unref0 (sym);
					return NULL;
				} else {
					_vala_code_node_unref0 (value);
					_g_free0 (id);
					_vala_iterable_unref0 (value_attrs);
					_vala_code_node_unref0 (en);
					_vala_code_node_unref0 (sym);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp41_ = _tmp39_;
			_tmp39_ = NULL;
			_vala_code_node_unref0 (value);
			value = _tmp41_;
			_vala_code_node_unref0 (_tmp39_);
		}
		_tmp42_ = id;
		_tmp43_ = value;
		_tmp44_ = value_begin;
		_tmp45_ = vala_genie_parser_get_src (self, &_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = self->priv->comment;
		_tmp48_ = vala_enum_value_new (_tmp42_, _tmp43_, _tmp46_, _tmp47_);
		_tmp49_ = _tmp48_;
		_vala_source_reference_unref0 (_tmp46_);
		ev = _tmp49_;
		_tmp50_ = ev;
		vala_symbol_set_access ((ValaSymbol*) _tmp50_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp51_ = ev;
		_tmp52_ = value_attrs;
		vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp51_, _tmp52_);
		_tmp53_ = en;
		_tmp54_ = ev;
		vala_enum_add_value (_tmp53_, _tmp54_);
		_tmp55_ = vala_genie_parser_expect_separator (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (ev);
				_vala_code_node_unref0 (value);
				_g_free0 (id);
				_vala_iterable_unref0 (value_attrs);
				_vala_code_node_unref0 (en);
				_vala_code_node_unref0 (sym);
				return NULL;
			} else {
				_vala_code_node_unref0 (ev);
				_vala_code_node_unref0 (value);
				_g_free0 (id);
				_vala_iterable_unref0 (value_attrs);
				_vala_code_node_unref0 (en);
				_vala_code_node_unref0 (sym);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		if (_tmp55_) {
			vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
		}
		_vala_code_node_unref0 (ev);
		_vala_code_node_unref0 (value);
		_g_free0 (id);
		_vala_iterable_unref0 (value_attrs);
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (en);
			_vala_code_node_unref0 (sym);
			return NULL;
		} else {
			_vala_code_node_unref0 (en);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp56_ = en;
	_tmp57_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp56_);
	_result_ = _tmp57_;
	while (TRUE) {
		ValaUnresolvedSymbol* _tmp58_;
		ValaUnresolvedSymbol* _tmp59_;
		ValaUnresolvedSymbol* _tmp60_;
		ValaUnresolvedSymbol* _tmp61_;
		ValaUnresolvedSymbol* _tmp62_;
		ValaUnresolvedSymbol* _tmp63_;
		ValaUnresolvedSymbol* _tmp64_;
		ValaNamespace* ns = NULL;
		ValaUnresolvedSymbol* _tmp65_;
		const gchar* _tmp66_;
		const gchar* _tmp67_;
		ValaEnum* _tmp68_;
		ValaSourceReference* _tmp69_;
		ValaSourceReference* _tmp70_;
		ValaNamespace* _tmp71_;
		ValaSymbol* _tmp72_;
		ValaNamespace* _tmp77_;
		ValaSymbol* _tmp78_;
		_tmp58_ = sym;
		_tmp59_ = vala_unresolved_symbol_get_inner (_tmp58_);
		_tmp60_ = _tmp59_;
		if (!(_tmp60_ != NULL)) {
			break;
		}
		_tmp61_ = sym;
		_tmp62_ = vala_unresolved_symbol_get_inner (_tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = _vala_code_node_ref0 (_tmp63_);
		_vala_code_node_unref0 (sym);
		sym = _tmp64_;
		_tmp65_ = sym;
		_tmp66_ = vala_symbol_get_name ((ValaSymbol*) _tmp65_);
		_tmp67_ = _tmp66_;
		_tmp68_ = en;
		_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_namespace_new (_tmp67_, _tmp70_);
		ns = _tmp71_;
		_tmp72_ = _result_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, VALA_TYPE_NAMESPACE)) {
			ValaNamespace* _tmp73_;
			ValaSymbol* _tmp74_;
			_tmp73_ = ns;
			_tmp74_ = _result_;
			vala_symbol_add_namespace ((ValaSymbol*) _tmp73_, G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, VALA_TYPE_NAMESPACE, ValaNamespace));
		} else {
			ValaNamespace* _tmp75_;
			ValaSymbol* _tmp76_;
			_tmp75_ = ns;
			_tmp76_ = _result_;
			vala_symbol_add_enum ((ValaSymbol*) _tmp75_, G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALA_TYPE_ENUM, ValaEnum));
		}
		_tmp77_ = ns;
		_tmp78_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp77_);
		_vala_code_node_unref0 (_result_);
		_result_ = _tmp78_;
		_vala_code_node_unref0 (ns);
	}
	result = _result_;
	_vala_code_node_unref0 (en);
	_vala_code_node_unref0 (sym);
	return result;
}

static ValaSymbol*
vala_genie_parser_parse_errordomain_declaration (ValaGenieParser* self,
                                                 ValaList* attrs,
                                                 GError** error)
{
	ValaSymbol* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaGenieParserModifierFlags flags = 0;
	ValaUnresolvedSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp1_;
	ValaErrorDomain* ed = NULL;
	ValaUnresolvedSymbol* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaComment* _tmp8_;
	ValaErrorDomain* _tmp9_;
	ValaErrorDomain* _tmp10_;
	ValaGenieParserModifierFlags _tmp11_;
	ValaErrorDomain* _tmp19_;
	ValaSymbol* _result_ = NULL;
	ValaErrorDomain* _tmp45_;
	ValaSymbol* _tmp46_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_type_declaration_modifiers (self);
	_tmp1_ = vala_genie_parser_parse_symbol_name (self, &_inner_error0_);
	sym = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = sym;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = begin;
	_tmp6_ = vala_genie_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->comment;
	_tmp9_ = vala_error_domain_new (_tmp4_, _tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	_vala_source_reference_unref0 (_tmp7_);
	ed = _tmp10_;
	_tmp11_ = flags;
	if ((_tmp11_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		ValaErrorDomain* _tmp12_;
		_tmp12_ = ed;
		vala_symbol_set_access ((ValaSymbol*) _tmp12_, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		ValaGenieParserModifierFlags _tmp13_;
		_tmp13_ = flags;
		if ((_tmp13_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) {
			ValaErrorDomain* _tmp14_;
			_tmp14_ = ed;
			vala_symbol_set_access ((ValaSymbol*) _tmp14_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
		} else {
			ValaErrorDomain* _tmp15_;
			ValaUnresolvedSymbol* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			_tmp15_ = ed;
			_tmp16_ = sym;
			_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
			_tmp18_ = _tmp17_;
			vala_symbol_set_access ((ValaSymbol*) _tmp15_, vala_genie_parser_get_default_accessibility (self, _tmp18_));
		}
	}
	_tmp19_ = ed;
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp19_, attrs);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (ed);
			_vala_code_node_unref0 (sym);
			return NULL;
		} else {
			_vala_code_node_unref0 (ed);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (ed);
			_vala_code_node_unref0 (sym);
			return NULL;
		} else {
			_vala_code_node_unref0 (ed);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	while (TRUE) {
		gboolean _tmp20_ = FALSE;
		ValaList* code_attrs = NULL;
		ValaList* _tmp26_;
		ValaSourceLocation code_begin = {0};
		ValaSourceLocation _tmp27_ = {0};
		gchar* id = NULL;
		gchar* _tmp28_;
		ValaGenieScanner* _tmp29_;
		ValaComment* _tmp30_;
		ValaErrorCode* ec = NULL;
		const gchar* _tmp31_;
		ValaSourceLocation _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaSourceReference* _tmp34_;
		ValaComment* _tmp35_;
		ValaErrorCode* _tmp36_;
		ValaErrorCode* _tmp37_;
		ValaErrorCode* _tmp38_;
		ValaList* _tmp39_;
		ValaErrorDomain* _tmp43_;
		ValaErrorCode* _tmp44_;
		if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_DEDENT) {
			ValaErrorDomain* _tmp21_;
			ValaList* _tmp22_;
			ValaList* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			_tmp21_ = ed;
			_tmp22_ = vala_error_domain_get_codes (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp20_ = _tmp25_ > 0;
			_vala_iterable_unref0 (_tmp23_);
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			break;
		}
		_tmp26_ = vala_genie_parser_parse_attributes (self, FALSE, &_inner_error0_);
		code_attrs = _tmp26_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (ed);
				_vala_code_node_unref0 (sym);
				return NULL;
			} else {
				_vala_code_node_unref0 (ed);
				_vala_code_node_unref0 (sym);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		vala_genie_parser_get_location (self, &_tmp27_);
		code_begin = _tmp27_;
		_tmp28_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
		id = _tmp28_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_iterable_unref0 (code_attrs);
				_vala_code_node_unref0 (ed);
				_vala_code_node_unref0 (sym);
				return NULL;
			} else {
				_vala_iterable_unref0 (code_attrs);
				_vala_code_node_unref0 (ed);
				_vala_code_node_unref0 (sym);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp29_ = self->priv->scanner;
		_tmp30_ = vala_genie_scanner_pop_comment (_tmp29_);
		_vala_comment_unref0 (self->priv->comment);
		self->priv->comment = _tmp30_;
		_tmp31_ = id;
		_tmp32_ = code_begin;
		_tmp33_ = vala_genie_parser_get_src (self, &_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = self->priv->comment;
		_tmp36_ = vala_error_code_new (_tmp31_, _tmp34_, _tmp35_);
		_tmp37_ = _tmp36_;
		_vala_source_reference_unref0 (_tmp34_);
		ec = _tmp37_;
		_tmp38_ = ec;
		_tmp39_ = code_attrs;
		vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp38_, _tmp39_);
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
			ValaExpression* _tmp40_ = NULL;
			ValaExpression* _tmp41_;
			ValaErrorCode* _tmp42_;
			_tmp41_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
			_tmp40_ = _tmp41_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (ec);
					_g_free0 (id);
					_vala_iterable_unref0 (code_attrs);
					_vala_code_node_unref0 (ed);
					_vala_code_node_unref0 (sym);
					return NULL;
				} else {
					_vala_code_node_unref0 (ec);
					_g_free0 (id);
					_vala_iterable_unref0 (code_attrs);
					_vala_code_node_unref0 (ed);
					_vala_code_node_unref0 (sym);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp42_ = ec;
			vala_error_code_set_value (_tmp42_, _tmp40_);
			_vala_code_node_unref0 (_tmp40_);
		}
		_tmp43_ = ed;
		_tmp44_ = ec;
		vala_error_domain_add_code (_tmp43_, _tmp44_);
		vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
		_vala_code_node_unref0 (ec);
		_g_free0 (id);
		_vala_iterable_unref0 (code_attrs);
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (ed);
			_vala_code_node_unref0 (sym);
			return NULL;
		} else {
			_vala_code_node_unref0 (ed);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp45_ = ed;
	_tmp46_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp45_);
	_result_ = _tmp46_;
	while (TRUE) {
		ValaUnresolvedSymbol* _tmp47_;
		ValaUnresolvedSymbol* _tmp48_;
		ValaUnresolvedSymbol* _tmp49_;
		ValaUnresolvedSymbol* _tmp50_;
		ValaUnresolvedSymbol* _tmp51_;
		ValaUnresolvedSymbol* _tmp52_;
		ValaUnresolvedSymbol* _tmp53_;
		ValaNamespace* ns = NULL;
		ValaUnresolvedSymbol* _tmp54_;
		const gchar* _tmp55_;
		const gchar* _tmp56_;
		ValaErrorDomain* _tmp57_;
		ValaSourceReference* _tmp58_;
		ValaSourceReference* _tmp59_;
		ValaNamespace* _tmp60_;
		ValaSymbol* _tmp61_;
		ValaNamespace* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp47_ = sym;
		_tmp48_ = vala_unresolved_symbol_get_inner (_tmp47_);
		_tmp49_ = _tmp48_;
		if (!(_tmp49_ != NULL)) {
			break;
		}
		_tmp50_ = sym;
		_tmp51_ = vala_unresolved_symbol_get_inner (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = _vala_code_node_ref0 (_tmp52_);
		_vala_code_node_unref0 (sym);
		sym = _tmp53_;
		_tmp54_ = sym;
		_tmp55_ = vala_symbol_get_name ((ValaSymbol*) _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = ed;
		_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = vala_namespace_new (_tmp56_, _tmp59_);
		ns = _tmp60_;
		_tmp61_ = _result_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp61_, VALA_TYPE_NAMESPACE)) {
			ValaNamespace* _tmp62_;
			ValaSymbol* _tmp63_;
			_tmp62_ = ns;
			_tmp63_ = _result_;
			vala_symbol_add_namespace ((ValaSymbol*) _tmp62_, G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_NAMESPACE, ValaNamespace));
		} else {
			ValaNamespace* _tmp64_;
			ValaSymbol* _tmp65_;
			_tmp64_ = ns;
			_tmp65_ = _result_;
			vala_symbol_add_error_domain ((ValaSymbol*) _tmp64_, G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain));
		}
		_tmp66_ = ns;
		_tmp67_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp66_);
		_vala_code_node_unref0 (_result_);
		_result_ = _tmp67_;
		_vala_code_node_unref0 (ns);
	}
	result = _result_;
	_vala_code_node_unref0 (ed);
	_vala_code_node_unref0 (sym);
	return result;
}

static ValaGenieParserModifierFlags
vala_genie_parser_parse_type_declaration_modifiers (ValaGenieParser* self)
{
	ValaGenieParserModifierFlags result = 0;
	ValaGenieParserModifierFlags flags = 0;
	g_return_val_if_fail (self != NULL, 0);
	flags = 0;
	while (TRUE) {
		switch (vala_genie_parser_current (self)) {
			case VALA_GENIE_TOKEN_TYPE_ABSTRACT:
			{
				ValaGenieParserModifierFlags _tmp0_;
				vala_genie_parser_next (self);
				_tmp0_ = flags;
				flags = _tmp0_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_EXTERN:
			{
				ValaGenieParserModifierFlags _tmp1_;
				vala_genie_parser_next (self);
				_tmp1_ = flags;
				flags = _tmp1_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_STATIC:
			{
				ValaGenieParserModifierFlags _tmp2_;
				vala_genie_parser_next (self);
				_tmp2_ = flags;
				flags = _tmp2_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_PRIVATE:
			{
				ValaGenieParserModifierFlags _tmp3_;
				vala_genie_parser_next (self);
				_tmp3_ = flags;
				flags = _tmp3_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_PUBLIC:
			{
				ValaGenieParserModifierFlags _tmp4_;
				vala_genie_parser_next (self);
				_tmp4_ = flags;
				flags = _tmp4_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_PUBLIC;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_PROTECTED:
			{
				ValaGenieParserModifierFlags _tmp5_;
				vala_genie_parser_next (self);
				_tmp5_ = flags;
				flags = _tmp5_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED;
				break;
			}
			default:
			{
				result = flags;
				return result;
			}
		}
	}
}

static ValaGenieParserModifierFlags
vala_genie_parser_parse_member_declaration_modifiers (ValaGenieParser* self)
{
	ValaGenieParserModifierFlags result = 0;
	ValaGenieParserModifierFlags flags = 0;
	g_return_val_if_fail (self != NULL, 0);
	flags = 0;
	while (TRUE) {
		switch (vala_genie_parser_current (self)) {
			case VALA_GENIE_TOKEN_TYPE_ABSTRACT:
			{
				ValaGenieParserModifierFlags _tmp0_;
				vala_genie_parser_next (self);
				_tmp0_ = flags;
				flags = _tmp0_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_ASYNC:
			{
				ValaGenieParserModifierFlags _tmp1_;
				vala_genie_parser_next (self);
				_tmp1_ = flags;
				flags = _tmp1_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_ASYNC;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_CLASS:
			{
				ValaGenieParserModifierFlags _tmp2_;
				vala_genie_parser_next (self);
				_tmp2_ = flags;
				flags = _tmp2_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_EXTERN:
			{
				ValaGenieParserModifierFlags _tmp3_;
				vala_genie_parser_next (self);
				_tmp3_ = flags;
				flags = _tmp3_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_INLINE:
			{
				ValaGenieParserModifierFlags _tmp4_;
				vala_genie_parser_next (self);
				_tmp4_ = flags;
				flags = _tmp4_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_NEW:
			{
				ValaGenieParserModifierFlags _tmp5_;
				vala_genie_parser_next (self);
				_tmp5_ = flags;
				flags = _tmp5_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_OVERRIDE:
			{
				ValaGenieParserModifierFlags _tmp6_;
				vala_genie_parser_next (self);
				_tmp6_ = flags;
				flags = _tmp6_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_SEALED:
			{
				ValaGenieParserModifierFlags _tmp7_;
				vala_genie_parser_next (self);
				_tmp7_ = flags;
				flags = _tmp7_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_SEALED;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_STATIC:
			{
				ValaGenieParserModifierFlags _tmp8_;
				vala_genie_parser_next (self);
				_tmp8_ = flags;
				flags = _tmp8_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_VIRTUAL:
			{
				ValaGenieParserModifierFlags _tmp9_;
				vala_genie_parser_next (self);
				_tmp9_ = flags;
				flags = _tmp9_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_PRIVATE:
			{
				ValaGenieParserModifierFlags _tmp10_;
				vala_genie_parser_next (self);
				_tmp10_ = flags;
				flags = _tmp10_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_PUBLIC:
			{
				ValaGenieParserModifierFlags _tmp11_;
				vala_genie_parser_next (self);
				_tmp11_ = flags;
				flags = _tmp11_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_PUBLIC;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_PROTECTED:
			{
				ValaGenieParserModifierFlags _tmp12_;
				vala_genie_parser_next (self);
				_tmp12_ = flags;
				flags = _tmp12_ | VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED;
				break;
			}
			default:
			{
				result = flags;
				return result;
			}
		}
	}
}

static ValaParameter*
vala_genie_parser_parse_parameter (ValaGenieParser* self,
                                   GError** error)
{
	ValaParameter* result = NULL;
	ValaList* attrs = NULL;
	ValaList* _tmp0_;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp1_ = {0};
	gboolean params_array = FALSE;
	ValaParameterDirection direction = 0;
	gchar* id = NULL;
	gchar* _tmp7_;
	ValaDataType* type = NULL;
	ValaParameterDirection _tmp8_;
	ValaParameter* param = NULL;
	const gchar* _tmp19_;
	ValaDataType* _tmp20_;
	ValaSourceLocation _tmp21_;
	ValaSourceReference* _tmp22_;
	ValaSourceReference* _tmp23_;
	ValaParameter* _tmp24_;
	ValaParameter* _tmp25_;
	ValaParameter* _tmp26_;
	ValaList* _tmp27_;
	ValaParameter* _tmp28_;
	ValaParameterDirection _tmp29_;
	ValaParameter* _tmp30_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_genie_parser_parse_attributes (self, TRUE, &_inner_error0_);
	attrs = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_get_location (self, &_tmp1_);
	begin = _tmp1_;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ELLIPSIS)) {
		ValaSourceLocation _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaParameter* _tmp5_;
		ValaParameter* _tmp6_;
		_tmp2_ = begin;
		_tmp3_ = vala_genie_parser_get_src (self, &_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_parameter_new_with_ellipsis (_tmp4_);
		_tmp6_ = _tmp5_;
		_vala_source_reference_unref0 (_tmp4_);
		result = _tmp6_;
		_vala_iterable_unref0 (attrs);
		return result;
	}
	params_array = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_PARAMS);
	direction = VALA_PARAMETER_DIRECTION_IN;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OUT)) {
		direction = VALA_PARAMETER_DIRECTION_OUT;
	} else {
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_REF)) {
			direction = VALA_PARAMETER_DIRECTION_REF;
		}
	}
	_tmp7_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
	id = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_iterable_unref0 (attrs);
			return NULL;
		} else {
			_vala_iterable_unref0 (attrs);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (id);
			_vala_iterable_unref0 (attrs);
			return NULL;
		} else {
			_g_free0 (id);
			_vala_iterable_unref0 (attrs);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp8_ = direction;
	if (_tmp8_ == VALA_PARAMETER_DIRECTION_IN) {
		ValaDataType* _tmp9_ = NULL;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp10_ = vala_genie_parser_parse_type (self, FALSE, FALSE, &_inner_error0_);
		_tmp9_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				_vala_iterable_unref0 (attrs);
				return NULL;
			} else {
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				_vala_iterable_unref0 (attrs);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp11_ = _tmp9_;
		_tmp9_ = NULL;
		_vala_code_node_unref0 (type);
		type = _tmp11_;
		_vala_code_node_unref0 (_tmp9_);
	} else {
		ValaParameterDirection _tmp12_;
		_tmp12_ = direction;
		if (_tmp12_ == VALA_PARAMETER_DIRECTION_REF) {
			ValaDataType* _tmp13_ = NULL;
			ValaDataType* _tmp14_;
			ValaDataType* _tmp15_;
			_tmp14_ = vala_genie_parser_parse_type (self, TRUE, TRUE, &_inner_error0_);
			_tmp13_ = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (type);
					_g_free0 (id);
					_vala_iterable_unref0 (attrs);
					return NULL;
				} else {
					_vala_code_node_unref0 (type);
					_g_free0 (id);
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp15_ = _tmp13_;
			_tmp13_ = NULL;
			_vala_code_node_unref0 (type);
			type = _tmp15_;
			_vala_code_node_unref0 (_tmp13_);
		} else {
			ValaDataType* _tmp16_ = NULL;
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			_tmp17_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
			_tmp16_ = _tmp17_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (type);
					_g_free0 (id);
					_vala_iterable_unref0 (attrs);
					return NULL;
				} else {
					_vala_code_node_unref0 (type);
					_g_free0 (id);
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp18_ = _tmp16_;
			_tmp16_ = NULL;
			_vala_code_node_unref0 (type);
			type = _tmp18_;
			_vala_code_node_unref0 (_tmp16_);
		}
	}
	_tmp19_ = id;
	_tmp20_ = type;
	_tmp21_ = begin;
	_tmp22_ = vala_genie_parser_get_src (self, &_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_parameter_new (_tmp19_, _tmp20_, _tmp23_);
	_tmp25_ = _tmp24_;
	_vala_source_reference_unref0 (_tmp23_);
	param = _tmp25_;
	_tmp26_ = param;
	_tmp27_ = attrs;
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp26_, _tmp27_);
	_tmp28_ = param;
	_tmp29_ = direction;
	vala_parameter_set_direction (_tmp28_, _tmp29_);
	_tmp30_ = param;
	vala_parameter_set_params_array (_tmp30_, params_array);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp31_ = NULL;
		ValaExpression* _tmp32_;
		ValaParameter* _tmp33_;
		_tmp32_ = vala_genie_parser_parse_expression (self, &_inner_error0_);
		_tmp31_ = _tmp32_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				_vala_iterable_unref0 (attrs);
				return NULL;
			} else {
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				_vala_iterable_unref0 (attrs);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp33_ = param;
		vala_variable_set_initializer ((ValaVariable*) _tmp33_, _tmp31_);
		_vala_code_node_unref0 (_tmp31_);
	}
	result = param;
	_vala_code_node_unref0 (type);
	_g_free0 (id);
	_vala_iterable_unref0 (attrs);
	return result;
}

static ValaCreationMethod*
vala_genie_parser_parse_creation_method_declaration (ValaGenieParser* self,
                                                     ValaList* attrs,
                                                     GError** error)
{
	ValaCreationMethod* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaCreationMethod* method = NULL;
	ValaCreationMethod* _tmp53_;
	ValaCreationMethod* _tmp54_;
	ValaCreationMethod* _tmp55_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CONSTRUCT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (method);
			return NULL;
		} else {
			_vala_code_node_unref0 (method);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	vala_genie_parser_parse_member_declaration_modifiers (self);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)) {
		const gchar* _tmp1_;
		ValaSourceLocation _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaComment* _tmp5_;
		ValaCreationMethod* _tmp6_;
		_tmp1_ = self->priv->class_name;
		_tmp2_ = begin;
		_tmp3_ = vala_genie_parser_get_src (self, &_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->comment;
		_tmp6_ = vala_creation_method_new (_tmp1_, NULL, _tmp4_, _tmp5_);
		_vala_code_node_unref0 (method);
		method = _tmp6_;
		_vala_source_reference_unref0 (_tmp4_);
	} else {
		ValaUnresolvedSymbol* sym = NULL;
		ValaUnresolvedSymbol* _tmp7_;
		ValaUnresolvedSymbol* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		ValaUnresolvedSymbol* _tmp10_;
		_tmp7_ = vala_genie_parser_parse_symbol_name (self, &_inner_error0_);
		sym = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (method);
				return NULL;
			} else {
				_vala_code_node_unref0 (method);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp8_ = sym;
		_tmp9_ = vala_unresolved_symbol_get_inner (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == NULL) {
			ValaUnresolvedSymbol* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp11_ = sym;
			_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = self->priv->class_name;
			if (g_strcmp0 (_tmp13_, _tmp14_) != 0) {
				const gchar* _tmp15_;
				ValaUnresolvedSymbol* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				ValaSourceLocation _tmp19_;
				ValaSourceReference* _tmp20_;
				ValaSourceReference* _tmp21_;
				ValaComment* _tmp22_;
				ValaCreationMethod* _tmp23_;
				_tmp15_ = self->priv->class_name;
				_tmp16_ = sym;
				_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = begin;
				_tmp20_ = vala_genie_parser_get_src (self, &_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = self->priv->comment;
				_tmp23_ = vala_creation_method_new (_tmp15_, _tmp18_, _tmp21_, _tmp22_);
				_vala_code_node_unref0 (method);
				method = _tmp23_;
				_vala_source_reference_unref0 (_tmp21_);
			} else {
				ValaUnresolvedSymbol* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				ValaSourceLocation _tmp27_;
				ValaSourceReference* _tmp28_;
				ValaSourceReference* _tmp29_;
				ValaComment* _tmp30_;
				ValaCreationMethod* _tmp31_;
				_tmp24_ = sym;
				_tmp25_ = vala_symbol_get_name ((ValaSymbol*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = begin;
				_tmp28_ = vala_genie_parser_get_src (self, &_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = self->priv->comment;
				_tmp31_ = vala_creation_method_new (_tmp26_, NULL, _tmp29_, _tmp30_);
				_vala_code_node_unref0 (method);
				method = _tmp31_;
				_vala_source_reference_unref0 (_tmp29_);
			}
		} else {
			ValaUnresolvedSymbol* _tmp32_;
			ValaUnresolvedSymbol* _tmp33_;
			ValaUnresolvedSymbol* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			ValaUnresolvedSymbol* _tmp37_;
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			ValaSourceLocation _tmp40_;
			ValaSourceReference* _tmp41_;
			ValaSourceReference* _tmp42_;
			ValaComment* _tmp43_;
			ValaCreationMethod* _tmp44_;
			_tmp32_ = sym;
			_tmp33_ = vala_unresolved_symbol_get_inner (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_symbol_get_name ((ValaSymbol*) _tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = sym;
			_tmp38_ = vala_symbol_get_name ((ValaSymbol*) _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = begin;
			_tmp41_ = vala_genie_parser_get_src (self, &_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = self->priv->comment;
			_tmp44_ = vala_creation_method_new (_tmp36_, _tmp39_, _tmp42_, _tmp43_);
			_vala_code_node_unref0 (method);
			method = _tmp44_;
			_vala_source_reference_unref0 (_tmp42_);
		}
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (method);
				return NULL;
			} else {
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (method);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_vala_code_node_unref0 (sym);
	}
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		{
			gboolean _tmp45_ = FALSE;
			_tmp45_ = TRUE;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaParameter* _tmp46_;
				ValaCreationMethod* _tmp47_;
				ValaParameter* _tmp48_;
				if (!_tmp45_) {
					if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp45_ = FALSE;
				_tmp46_ = vala_genie_parser_parse_parameter (self, &_inner_error0_);
				param = _tmp46_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (method);
						return NULL;
					} else {
						_vala_code_node_unref0 (method);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp47_ = method;
				_tmp48_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp47_, _tmp48_);
				_vala_code_node_unref0 (param);
			}
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (method);
			return NULL;
		} else {
			_vala_code_node_unref0 (method);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_RAISES)) {
		{
			gboolean _tmp49_ = FALSE;
			_tmp49_ = TRUE;
			while (TRUE) {
				ValaDataType* _tmp50_ = NULL;
				ValaDataType* _tmp51_;
				ValaCreationMethod* _tmp52_;
				if (!_tmp49_) {
					if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp49_ = FALSE;
				_tmp51_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
				_tmp50_ = _tmp51_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (method);
						return NULL;
					} else {
						_vala_code_node_unref0 (method);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp52_ = method;
				vala_method_add_error_type ((ValaMethod*) _tmp52_, _tmp50_);
				_vala_code_node_unref0 (_tmp50_);
			}
		}
	}
	_tmp53_ = method;
	vala_symbol_set_access ((ValaSymbol*) _tmp53_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp54_ = method;
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp54_, attrs);
	_tmp55_ = method;
	vala_method_set_binding ((ValaMethod*) _tmp55_, VALA_MEMBER_BINDING_STATIC);
	if (vala_genie_parser_accept_block (self)) {
		ValaBlock* _tmp56_ = NULL;
		ValaBlock* _tmp57_;
		ValaCreationMethod* _tmp58_;
		_tmp57_ = vala_genie_parser_parse_block (self, &_inner_error0_);
		_tmp56_ = _tmp57_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_code_node_unref0 (method);
				return NULL;
			} else {
				_vala_code_node_unref0 (method);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp58_ = method;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp58_, _tmp56_);
		_vala_code_node_unref0 (_tmp56_);
	} else {
		ValaGenieScanner* _tmp59_;
		ValaSourceFile* _tmp60_;
		ValaSourceFile* _tmp61_;
		ValaSourceFileType _tmp62_;
		ValaSourceFileType _tmp63_;
		_tmp59_ = self->priv->scanner;
		_tmp60_ = vala_genie_scanner_get_source_file (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_source_file_get_file_type (_tmp61_);
		_tmp63_ = _tmp62_;
		if (_tmp63_ == VALA_SOURCE_FILE_TYPE_PACKAGE) {
			ValaCreationMethod* _tmp64_;
			_tmp64_ = method;
			vala_symbol_set_external ((ValaSymbol*) _tmp64_, TRUE);
		}
	}
	result = method;
	return result;
}

static ValaSymbol*
vala_genie_parser_parse_delegate_declaration (ValaGenieParser* self,
                                              ValaList* attrs,
                                              GError** error)
{
	ValaSymbol* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaDataType* type = NULL;
	ValaGenieParserModifierFlags flags = 0;
	ValaUnresolvedSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp1_;
	ValaList* type_param_list = NULL;
	ValaList* _tmp2_;
	ValaGenieParserModifierFlags _tmp3_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp5_;
	ValaArrayList* _tmp6_;
	ValaDelegate* d = NULL;
	ValaUnresolvedSymbol* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	ValaDataType* _tmp18_;
	ValaSourceLocation _tmp19_;
	ValaSourceReference* _tmp20_;
	ValaSourceReference* _tmp21_;
	ValaComment* _tmp22_;
	ValaDelegate* _tmp23_;
	ValaDelegate* _tmp24_;
	ValaGenieParserModifierFlags _tmp29_;
	ValaGenieParserModifierFlags _tmp37_;
	gboolean _tmp39_ = FALSE;
	ValaGenieParserModifierFlags _tmp40_;
	ValaDelegate* _tmp47_;
	ValaSymbol* _result_ = NULL;
	ValaDelegate* _tmp66_;
	ValaSymbol* _tmp67_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DELEGATE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	_tmp1_ = vala_genie_parser_parse_symbol_name (self, &_inner_error0_);
	sym = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = vala_genie_parser_parse_type_parameter_list (self, &_inner_error0_);
	type_param_list = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = flags;
	if ((_tmp3_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) == VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) {
		GError* _tmp4_;
		_tmp4_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "`new' modifier not allowed on delegates");
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp5_);
	params = _tmp6_;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_iterable_unref0 (params);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_iterable_unref0 (params);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaParameter* _tmp8_;
				ValaArrayList* _tmp9_;
				ValaParameter* _tmp10_;
				if (!_tmp7_) {
					if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp7_ = FALSE;
				_tmp8_ = vala_genie_parser_parse_parameter (self, &_inner_error0_);
				param = _tmp8_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_iterable_unref0 (params);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						return NULL;
					} else {
						_vala_iterable_unref0 (params);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp9_ = params;
				_tmp10_ = param;
				vala_collection_add ((ValaCollection*) _tmp9_, _tmp10_);
				_vala_code_node_unref0 (param);
			}
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_iterable_unref0 (params);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_iterable_unref0 (params);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		ValaDataType* _tmp11_ = NULL;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		_tmp12_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
		_tmp11_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_vala_iterable_unref0 (params);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_iterable_unref0 (params);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp13_ = _tmp11_;
		_tmp11_ = NULL;
		_vala_code_node_unref0 (type);
		type = _tmp13_;
		_vala_code_node_unref0 (_tmp11_);
	} else {
		ValaVoidType* _tmp14_;
		_tmp14_ = vala_void_type_new (NULL);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp14_;
	}
	_tmp15_ = sym;
	_tmp16_ = vala_symbol_get_name ((ValaSymbol*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = type;
	_tmp19_ = begin;
	_tmp20_ = vala_genie_parser_get_src (self, &_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->comment;
	_tmp23_ = vala_delegate_new (_tmp17_, _tmp18_, _tmp21_, _tmp22_);
	_tmp24_ = _tmp23_;
	_vala_source_reference_unref0 (_tmp21_);
	d = _tmp24_;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_RAISES)) {
		{
			gboolean _tmp25_ = FALSE;
			_tmp25_ = TRUE;
			while (TRUE) {
				ValaDataType* _tmp26_ = NULL;
				ValaDataType* _tmp27_;
				ValaDelegate* _tmp28_;
				if (!_tmp25_) {
					if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp25_ = FALSE;
				_tmp27_ = vala_genie_parser_parse_type (self, TRUE, FALSE, &_inner_error0_);
				_tmp26_ = _tmp27_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_code_node_unref0 (d);
						_vala_iterable_unref0 (params);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						return NULL;
					} else {
						_vala_code_node_unref0 (d);
						_vala_iterable_unref0 (params);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp28_ = d;
				vala_delegate_add_error_type (_tmp28_, _tmp26_);
				_vala_code_node_unref0 (_tmp26_);
			}
		}
	}
	vala_genie_parser_expect_terminator (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_vala_code_node_unref0 (d);
			_vala_iterable_unref0 (params);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (d);
			_vala_iterable_unref0 (params);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp29_ = flags;
	if ((_tmp29_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		ValaDelegate* _tmp30_;
		_tmp30_ = d;
		vala_symbol_set_access ((ValaSymbol*) _tmp30_, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		ValaGenieParserModifierFlags _tmp31_;
		_tmp31_ = flags;
		if ((_tmp31_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PROTECTED) {
			ValaDelegate* _tmp32_;
			_tmp32_ = d;
			vala_symbol_set_access ((ValaSymbol*) _tmp32_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
		} else {
			ValaDelegate* _tmp33_;
			ValaUnresolvedSymbol* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp33_ = d;
			_tmp34_ = sym;
			_tmp35_ = vala_symbol_get_name ((ValaSymbol*) _tmp34_);
			_tmp36_ = _tmp35_;
			vala_symbol_set_access ((ValaSymbol*) _tmp33_, vala_genie_parser_get_default_accessibility (self, _tmp36_));
		}
	}
	_tmp37_ = flags;
	if ((_tmp37_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) == VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) {
		ValaDelegate* _tmp38_;
		_tmp38_ = d;
		vala_delegate_set_has_target (_tmp38_, FALSE);
	}
	_tmp40_ = flags;
	if ((_tmp40_ & VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp39_ = TRUE;
	} else {
		ValaGenieScanner* _tmp41_;
		ValaSourceFile* _tmp42_;
		ValaSourceFile* _tmp43_;
		ValaSourceFileType _tmp44_;
		ValaSourceFileType _tmp45_;
		_tmp41_ = self->priv->scanner;
		_tmp42_ = vala_genie_scanner_get_source_file (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_source_file_get_file_type (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp39_ = _tmp45_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	}
	if (_tmp39_) {
		ValaDelegate* _tmp46_;
		_tmp46_ = d;
		vala_symbol_set_external ((ValaSymbol*) _tmp46_, TRUE);
	}
	_tmp47_ = d;
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) _tmp47_, attrs);
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp48_;
		ValaList* _tmp49_;
		gint _type_param_size = 0;
		ValaList* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		gint _type_param_index = 0;
		_tmp48_ = type_param_list;
		_tmp49_ = _vala_iterable_ref0 (_tmp48_);
		_type_param_list = _tmp49_;
		_tmp50_ = _type_param_list;
		_tmp51_ = vala_collection_get_size ((ValaCollection*) _tmp50_);
		_tmp52_ = _tmp51_;
		_type_param_size = _tmp52_;
		_type_param_index = -1;
		while (TRUE) {
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp53_;
			gpointer _tmp54_;
			ValaDelegate* _tmp55_;
			ValaTypeParameter* _tmp56_;
			_type_param_index = _type_param_index + 1;
			if (!(_type_param_index < _type_param_size)) {
				break;
			}
			_tmp53_ = _type_param_list;
			_tmp54_ = vala_list_get (_tmp53_, _type_param_index);
			type_param = (ValaTypeParameter*) _tmp54_;
			_tmp55_ = d;
			_tmp56_ = type_param;
			vala_delegate_add_type_parameter (_tmp55_, _tmp56_);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	{
		ValaArrayList* _formal_param_list = NULL;
		ValaArrayList* _tmp57_;
		ValaArrayList* _tmp58_;
		gint _formal_param_size = 0;
		ValaArrayList* _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		gint _formal_param_index = 0;
		_tmp57_ = params;
		_tmp58_ = _vala_iterable_ref0 (_tmp57_);
		_formal_param_list = _tmp58_;
		_tmp59_ = _formal_param_list;
		_tmp60_ = vala_collection_get_size ((ValaCollection*) _tmp59_);
		_tmp61_ = _tmp60_;
		_formal_param_size = _tmp61_;
		_formal_param_index = -1;
		while (TRUE) {
			ValaParameter* formal_param = NULL;
			ValaArrayList* _tmp62_;
			gpointer _tmp63_;
			ValaDelegate* _tmp64_;
			ValaParameter* _tmp65_;
			_formal_param_index = _formal_param_index + 1;
			if (!(_formal_param_index < _formal_param_size)) {
				break;
			}
			_tmp62_ = _formal_param_list;
			_tmp63_ = vala_list_get ((ValaList*) _tmp62_, _formal_param_index);
			formal_param = (ValaParameter*) _tmp63_;
			_tmp64_ = d;
			_tmp65_ = formal_param;
			vala_callable_add_parameter ((ValaCallable*) _tmp64_, _tmp65_);
			_vala_code_node_unref0 (formal_param);
		}
		_vala_iterable_unref0 (_formal_param_list);
	}
	_tmp66_ = d;
	_tmp67_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp66_);
	_result_ = _tmp67_;
	while (TRUE) {
		ValaUnresolvedSymbol* _tmp68_;
		ValaUnresolvedSymbol* _tmp69_;
		ValaUnresolvedSymbol* _tmp70_;
		ValaUnresolvedSymbol* _tmp71_;
		ValaUnresolvedSymbol* _tmp72_;
		ValaUnresolvedSymbol* _tmp73_;
		ValaUnresolvedSymbol* _tmp74_;
		ValaNamespace* ns = NULL;
		ValaUnresolvedSymbol* _tmp75_;
		const gchar* _tmp76_;
		const gchar* _tmp77_;
		ValaDelegate* _tmp78_;
		ValaSourceReference* _tmp79_;
		ValaSourceReference* _tmp80_;
		ValaNamespace* _tmp81_;
		ValaSymbol* _tmp82_;
		ValaNamespace* _tmp87_;
		ValaSymbol* _tmp88_;
		_tmp68_ = sym;
		_tmp69_ = vala_unresolved_symbol_get_inner (_tmp68_);
		_tmp70_ = _tmp69_;
		if (!(_tmp70_ != NULL)) {
			break;
		}
		_tmp71_ = sym;
		_tmp72_ = vala_unresolved_symbol_get_inner (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = _vala_code_node_ref0 (_tmp73_);
		_vala_code_node_unref0 (sym);
		sym = _tmp74_;
		_tmp75_ = sym;
		_tmp76_ = vala_symbol_get_name ((ValaSymbol*) _tmp75_);
		_tmp77_ = _tmp76_;
		_tmp78_ = d;
		_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp78_);
		_tmp80_ = _tmp79_;
		_tmp81_ = vala_namespace_new (_tmp77_, _tmp80_);
		ns = _tmp81_;
		_tmp82_ = _result_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp82_, VALA_TYPE_NAMESPACE)) {
			ValaNamespace* _tmp83_;
			ValaSymbol* _tmp84_;
			_tmp83_ = ns;
			_tmp84_ = _result_;
			vala_symbol_add_namespace ((ValaSymbol*) _tmp83_, G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, VALA_TYPE_NAMESPACE, ValaNamespace));
		} else {
			ValaNamespace* _tmp85_;
			ValaSymbol* _tmp86_;
			_tmp85_ = ns;
			_tmp86_ = _result_;
			vala_symbol_add_delegate ((ValaSymbol*) _tmp85_, G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_DELEGATE, ValaDelegate));
		}
		_tmp87_ = ns;
		_tmp88_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp87_);
		_vala_code_node_unref0 (_result_);
		_result_ = _tmp88_;
		_vala_code_node_unref0 (ns);
	}
	result = _result_;
	_vala_code_node_unref0 (d);
	_vala_iterable_unref0 (params);
	_vala_iterable_unref0 (type_param_list);
	_vala_code_node_unref0 (sym);
	_vala_code_node_unref0 (type);
	return result;
}

static ValaList*
vala_genie_parser_parse_type_parameter_list (ValaGenieParser* self,
                                             GError** error)
{
	ValaList* result = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OF)) {
		ValaArrayList* list = NULL;
		GEqualFunc _tmp0_;
		ValaArrayList* _tmp1_;
		_tmp0_ = g_direct_equal;
		_tmp1_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
		list = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ValaSourceLocation begin = {0};
				ValaSourceLocation _tmp3_ = {0};
				gchar* id = NULL;
				gchar* _tmp4_;
				ValaArrayList* _tmp5_;
				const gchar* _tmp6_;
				ValaSourceLocation _tmp7_;
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				ValaTypeParameter* _tmp10_;
				ValaTypeParameter* _tmp11_;
				if (!_tmp2_) {
					if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp2_ = FALSE;
				vala_genie_parser_get_location (self, &_tmp3_);
				begin = _tmp3_;
				_tmp4_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
				id = _tmp4_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_vala_iterable_unref0 (list);
						return NULL;
					} else {
						_vala_iterable_unref0 (list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp5_ = list;
				_tmp6_ = id;
				_tmp7_ = begin;
				_tmp8_ = vala_genie_parser_get_src (self, &_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = vala_typeparameter_new (_tmp6_, _tmp9_);
				_tmp11_ = _tmp10_;
				vala_collection_add ((ValaCollection*) _tmp5_, _tmp11_);
				_vala_code_node_unref0 (_tmp11_);
				_vala_source_reference_unref0 (_tmp9_);
				_g_free0 (id);
			}
		}
		result = (ValaList*) list;
		return result;
	} else {
		ValaList* _tmp12_;
		ValaList* _tmp15_;
		ValaList* _tmp16_;
		_tmp12_ = vala_genie_parser__empty_type_parameter_list;
		if (_tmp12_ == NULL) {
			GEqualFunc _tmp13_;
			ValaArrayList* _tmp14_;
			_tmp13_ = g_direct_equal;
			_tmp14_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp13_);
			_vala_iterable_unref0 (vala_genie_parser__empty_type_parameter_list);
			vala_genie_parser__empty_type_parameter_list = (ValaList*) _tmp14_;
		}
		_tmp15_ = vala_genie_parser__empty_type_parameter_list;
		_tmp16_ = _vala_iterable_ref0 (_tmp15_);
		result = _tmp16_;
		return result;
	}
}

static void
vala_genie_parser_skip_type_argument_list (ValaGenieParser* self,
                                           GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OF)) {
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)) {
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					if (!_tmp0_) {
						if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
							break;
						}
					}
					_tmp0_ = FALSE;
					vala_genie_parser_skip_type (self, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				}
			}
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		} else {
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					if (!_tmp1_) {
						if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
							break;
						}
					}
					_tmp1_ = FALSE;
					vala_genie_parser_skip_type (self, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				}
			}
		}
	}
}

static ValaList*
vala_genie_parser_parse_type_argument_list (ValaGenieParser* self,
                                            gboolean maybe_expression,
                                            GError** error)
{
	ValaList* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OF)) {
		ValaArrayList* list = NULL;
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		gboolean inParens = FALSE;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		list = _tmp2_;
		inParens = FALSE;
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)) {
			inParens = TRUE;
		}
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				if (!_tmp3_) {
					if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp3_ = FALSE;
				switch (vala_genie_parser_current (self)) {
					case VALA_GENIE_TOKEN_TYPE_VOID:
					case VALA_GENIE_TOKEN_TYPE_DYNAMIC:
					case VALA_GENIE_TOKEN_TYPE_UNOWNED:
					case VALA_GENIE_TOKEN_TYPE_WEAK:
					case VALA_GENIE_TOKEN_TYPE_IDENTIFIER:
					{
						ValaDataType* type = NULL;
						ValaDataType* _tmp4_;
						ValaArrayList* _tmp5_;
						ValaDataType* _tmp6_;
						_tmp4_ = vala_genie_parser_parse_type (self, TRUE, TRUE, &_inner_error0_);
						type = _tmp4_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error0_);
								_vala_iterable_unref0 (list);
								return NULL;
							} else {
								_vala_iterable_unref0 (list);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
						_tmp5_ = list;
						_tmp6_ = type;
						vala_collection_add ((ValaCollection*) _tmp5_, _tmp6_);
						_vala_code_node_unref0 (type);
						break;
					}
					default:
					{
						ValaSourceLocation _tmp7_;
						_tmp7_ = begin;
						vala_genie_parser_rollback (self, &_tmp7_);
						result = NULL;
						_vala_iterable_unref0 (list);
						return result;
					}
				}
			}
		}
		if (inParens) {
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_iterable_unref0 (list);
					return NULL;
				} else {
					_vala_iterable_unref0 (list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
		result = (ValaList*) list;
		return result;
	}
	result = NULL;
	return result;
}

static ValaMemberAccess*
vala_genie_parser_parse_member_name (ValaGenieParser* self,
                                     ValaExpression* base_expr,
                                     GError** error)
{
	ValaMemberAccess* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaMemberAccess* expr = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_genie_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	expr = NULL;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			gchar* id = NULL;
			gchar* _tmp2_;
			ValaList* type_arg_list = NULL;
			ValaList* _tmp3_;
			ValaExpression* _tmp4_ = NULL;
			ValaMemberAccess* _tmp5_;
			const gchar* _tmp7_;
			ValaSourceLocation _tmp8_;
			ValaSourceReference* _tmp9_;
			ValaSourceReference* _tmp10_;
			ValaMemberAccess* _tmp11_;
			ValaList* _tmp12_;
			if (!_tmp1_) {
				if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DOT)) {
					break;
				}
			}
			_tmp1_ = FALSE;
			_tmp2_ = vala_genie_parser_parse_identifier (self, &_inner_error0_);
			id = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp3_ = vala_genie_parser_parse_type_argument_list (self, FALSE, &_inner_error0_);
			type_arg_list = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (id);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_g_free0 (id);
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp5_ = expr;
			if (_tmp5_ != NULL) {
				ValaMemberAccess* _tmp6_;
				_tmp6_ = expr;
				_tmp4_ = (ValaExpression*) _tmp6_;
			} else {
				_tmp4_ = base_expr;
			}
			_tmp7_ = id;
			_tmp8_ = begin;
			_tmp9_ = vala_genie_parser_get_src (self, &_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_member_access_new (_tmp4_, _tmp7_, _tmp10_);
			_vala_code_node_unref0 (expr);
			expr = _tmp11_;
			_vala_source_reference_unref0 (_tmp10_);
			_tmp12_ = type_arg_list;
			if (_tmp12_ != NULL) {
				{
					ValaList* _type_arg_list = NULL;
					ValaList* _tmp13_;
					ValaList* _tmp14_;
					gint _type_arg_size = 0;
					ValaList* _tmp15_;
					gint _tmp16_;
					gint _tmp17_;
					gint _type_arg_index = 0;
					_tmp13_ = type_arg_list;
					_tmp14_ = _vala_iterable_ref0 (_tmp13_);
					_type_arg_list = _tmp14_;
					_tmp15_ = _type_arg_list;
					_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
					_tmp17_ = _tmp16_;
					_type_arg_size = _tmp17_;
					_type_arg_index = -1;
					while (TRUE) {
						ValaDataType* type_arg = NULL;
						ValaList* _tmp18_;
						gpointer _tmp19_;
						ValaMemberAccess* _tmp20_;
						ValaDataType* _tmp21_;
						_type_arg_index = _type_arg_index + 1;
						if (!(_type_arg_index < _type_arg_size)) {
							break;
						}
						_tmp18_ = _type_arg_list;
						_tmp19_ = vala_list_get (_tmp18_, _type_arg_index);
						type_arg = (ValaDataType*) _tmp19_;
						_tmp20_ = expr;
						_tmp21_ = type_arg;
						vala_member_access_add_type_argument (_tmp20_, _tmp21_);
						_vala_code_node_unref0 (type_arg);
					}
					_vala_iterable_unref0 (_type_arg_list);
				}
			}
			_vala_iterable_unref0 (type_arg_list);
			_g_free0 (id);
		}
	}
	result = expr;
	return result;
}

static ValaGenieParserTokenInfo*
vala_genie_parser_token_info_dup (const ValaGenieParserTokenInfo* self)
{
	ValaGenieParserTokenInfo* dup;
	dup = g_new0 (ValaGenieParserTokenInfo, 1);
	memcpy (dup, self, sizeof (ValaGenieParserTokenInfo));
	return dup;
}

static void
vala_genie_parser_token_info_free (ValaGenieParserTokenInfo* self)
{
	g_free (self);
}

static GType
vala_genie_parser_token_info_get_type (void)
{
	static volatile gsize vala_genie_parser_token_info_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_parser_token_info_type_id__volatile)) {
		GType vala_genie_parser_token_info_type_id;
		vala_genie_parser_token_info_type_id = g_boxed_type_register_static ("ValaGenieParserTokenInfo", (GBoxedCopyFunc) vala_genie_parser_token_info_dup, (GBoxedFreeFunc) vala_genie_parser_token_info_free);
		g_once_init_leave (&vala_genie_parser_token_info_type_id__volatile, vala_genie_parser_token_info_type_id);
	}
	return vala_genie_parser_token_info_type_id__volatile;
}

static void
vala_genie_parser_class_init (ValaGenieParserClass * klass,
                              gpointer klass_data)
{
	vala_genie_parser_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_genie_parser_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGenieParser_private_offset);
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor*, ValaSourceFile*)) vala_genie_parser_real_visit_source_file;
}

static void
vala_genie_parser_instance_init (ValaGenieParser * self,
                                 gpointer klass)
{
	self->priv = vala_genie_parser_get_instance_private (self);
}

static void
vala_genie_parser_finalize (ValaCodeVisitor * obj)
{
	ValaGenieParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GENIE_TYPE_PARSER, ValaGenieParser);
	_vala_genie_scanner_unref0 (self->priv->scanner);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
	_vala_comment_unref0 (self->priv->comment);
	_g_free0 (self->priv->class_name);
	VALA_CODE_VISITOR_CLASS (vala_genie_parser_parent_class)->finalize (obj);
}

/**
 * Code visitor parsing all Genie source files.
 */
GType
vala_genie_parser_get_type (void)
{
	static volatile gsize vala_genie_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGenieParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_genie_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGenieParser), 0, (GInstanceInitFunc) vala_genie_parser_instance_init, NULL };
		GType vala_genie_parser_type_id;
		vala_genie_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGenieParser", &g_define_type_info, 0);
		ValaGenieParser_private_offset = g_type_add_instance_private (vala_genie_parser_type_id, sizeof (ValaGenieParserPrivate));
		g_once_init_leave (&vala_genie_parser_type_id__volatile, vala_genie_parser_type_id);
	}
	return vala_genie_parser_type_id__volatile;
}

