/* valagirparser.c generated by valac, the Vala compiler
 * generated from valagirparser.vala, do not modify */

/* valagirparser.vala
 *
 * Copyright (C) 2008-2012  Jürg Billeter
 * Copyright (C) 2011-2014  Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Luca Bruno <lucabru@src.gnome.org>
 */

#include "vala.h"
#include <glib-object.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define VALA_GIR_PARSER_TYPE_NODE (vala_gir_parser_node_get_type ())
#define VALA_GIR_PARSER_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNode))
#define VALA_GIR_PARSER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNodeClass))
#define VALA_GIR_PARSER_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_NODE))
#define VALA_GIR_PARSER_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_NODE))
#define VALA_GIR_PARSER_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNodeClass))

typedef struct _ValaGirParserNode ValaGirParserNode;
typedef struct _ValaGirParserNodeClass ValaGirParserNodeClass;

#define VALA_GIR_PARSER_TYPE_METADATA (vala_gir_parser_metadata_get_type ())
#define VALA_GIR_PARSER_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadata))
#define VALA_GIR_PARSER_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadataClass))
#define VALA_GIR_PARSER_IS_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA))
#define VALA_GIR_PARSER_IS_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA))
#define VALA_GIR_PARSER_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadataClass))

typedef struct _ValaGirParserMetadata ValaGirParserMetadata;
typedef struct _ValaGirParserMetadataClass ValaGirParserMetadataClass;
typedef enum  {
	VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP,
	VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_OUT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_REF,
	VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS,
	VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID,
	VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID,
	VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET,
	VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX
} ValaGirParserArgumentType;

#define VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE (vala_gir_parser_argument_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _vala_markup_reader_unref0(var) ((var == NULL) ? NULL : (var = (vala_markup_reader_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_gir_parser_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_gir_parser_metadata_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_metadata_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
typedef struct _ValaGirParserNodePrivate ValaGirParserNodePrivate;

#define VALA_GIR_PARSER_TYPE_PARAMETER_INFO (vala_gir_parser_parameter_info_get_type ())
#define VALA_GIR_PARSER_PARAMETER_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfo))
#define VALA_GIR_PARSER_PARAMETER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfoClass))
#define VALA_GIR_PARSER_IS_PARAMETER_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO))
#define VALA_GIR_PARSER_IS_PARAMETER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_PARAMETER_INFO))
#define VALA_GIR_PARSER_PARAMETER_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfoClass))

typedef struct _ValaGirParserParameterInfo ValaGirParserParameterInfo;
typedef struct _ValaGirParserParameterInfoClass ValaGirParserParameterInfoClass;
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
typedef struct _ValaGirParserParameterInfoPrivate ValaGirParserParameterInfoPrivate;

#define VALA_GIR_PARSER_TYPE_METADATA_PARSER (vala_gir_parser_metadata_parser_get_type ())
#define VALA_GIR_PARSER_METADATA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParser))
#define VALA_GIR_PARSER_METADATA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParserClass))
#define VALA_GIR_PARSER_IS_METADATA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER))
#define VALA_GIR_PARSER_IS_METADATA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA_PARSER))
#define VALA_GIR_PARSER_METADATA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParserClass))

typedef struct _ValaGirParserMetadataParser ValaGirParserMetadataParser;
typedef struct _ValaGirParserMetadataParserClass ValaGirParserMetadataParserClass;
#define _vala_gir_parser_metadata_parser_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_metadata_parser_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _vala_gir_parser_parameter_info_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_parameter_info_unref (var), NULL)))
typedef struct _ValaGirParserMetadataPrivate ValaGirParserMetadataPrivate;

#define VALA_GIR_PARSER_TYPE_ARGUMENT (vala_gir_parser_argument_get_type ())
#define VALA_GIR_PARSER_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgument))
#define VALA_GIR_PARSER_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgumentClass))
#define VALA_GIR_PARSER_IS_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT))
#define VALA_GIR_PARSER_IS_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_ARGUMENT))
#define VALA_GIR_PARSER_ARGUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgumentClass))

typedef struct _ValaGirParserArgument ValaGirParserArgument;
typedef struct _ValaGirParserArgumentClass ValaGirParserArgumentClass;
typedef struct _ValaGirParserArgumentPrivate ValaGirParserArgumentPrivate;
#define _vala_gir_parser_argument_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_argument_unref (var), NULL)))
#define _vala_map_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_iterator_unref (var), NULL)))
typedef struct _ValaGirParserParamSpecArgument ValaGirParserParamSpecArgument;

#define VALA_GIR_PARSER_TYPE_METADATA_SET (vala_gir_parser_metadata_set_get_type ())
#define VALA_GIR_PARSER_METADATA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSet))
#define VALA_GIR_PARSER_METADATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSetClass))
#define VALA_GIR_PARSER_IS_METADATA_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET))
#define VALA_GIR_PARSER_IS_METADATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA_SET))
#define VALA_GIR_PARSER_METADATA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSetClass))

typedef struct _ValaGirParserMetadataSet ValaGirParserMetadataSet;
typedef struct _ValaGirParserMetadataSetClass ValaGirParserMetadataSetClass;
typedef struct _ValaGirParserMetadataSetPrivate ValaGirParserMetadataSetPrivate;
#define _g_pattern_spec_free0(var) ((var == NULL) ? NULL : (var = (g_pattern_spec_free (var), NULL)))
typedef struct _ValaGirParserParamSpecMetadata ValaGirParserParamSpecMetadata;
typedef struct _ValaGirParserMetadataParserPrivate ValaGirParserMetadataParserPrivate;
#define _vala_scanner_unref0(var) ((var == NULL) ? NULL : (var = (vala_scanner_unref (var), NULL)))
typedef struct _ValaGirParserParamSpecMetadataParser ValaGirParserParamSpecMetadataParser;
typedef struct _ValaGirParserParamSpecNode ValaGirParserParamSpecNode;
typedef struct _ValaGirParserParamSpecParameterInfo ValaGirParserParamSpecParameterInfo;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGirParserPrivate {
	ValaMarkupReader* reader;
	ValaCodeContext* context;
	ValaNamespace* glib_ns;
	ValaSourceFile* current_source_file;
	ValaGirParserNode* root;
	ValaArrayList* metadata_roots;
	ValaSourceLocation begin;
	ValaSourceLocation end;
	ValaMarkupTokenType current_token;
	gchar** cheader_filenames;
	gint cheader_filenames_length1;
	gint _cheader_filenames_size_;
	ValaArrayList* metadata_stack;
	ValaGirParserMetadata* metadata;
	ValaArrayList* tree_stack;
	ValaGirParserNode* current;
	ValaGirParserNode* old_current;
	ValaSet* provided_namespaces;
	ValaHashMap* unresolved_symbols_map;
	ValaArrayList* unresolved_gir_symbols;
	ValaHashMap* unresolved_type_arguments;
};

struct _ValaGirParserNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGirParserNode* parent;
	gchar* element_type;
	gchar* name;
	ValaMap* girdata;
	ValaGirParserMetadata* metadata;
	ValaSourceReference* source_reference;
	ValaArrayList* members;
	ValaHashMap* scope;
	ValaGirComment* comment;
	ValaSymbol* symbol;
	gboolean new_symbol;
	gboolean merged;
	gboolean processed;
	gint return_array_length_idx;
	ValaList* parameters;
	ValaArrayList* array_length_parameters;
	ValaArrayList* closure_parameters;
	ValaArrayList* destroy_parameters;
	ValaUnresolvedSymbol* gtype_struct_for;
	ValaDataType* base_type;
	gint array_length_idx;
	gboolean deprecated;
	guint64 deprecated_version;
	gchar* deprecated_since;
	gchar* deprecated_replacement;
	ValaGirParserNodePrivate * priv;
};

struct _ValaGirParserNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserNode *self);
};

struct _ValaGirParserParameterInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaParameter* param;
	gfloat vala_idx;
	gint array_length_idx;
	gint closure_idx;
	gint destroy_idx;
	gboolean keep;
	gboolean is_async;
	gboolean is_error;
	ValaGirParserParameterInfoPrivate * priv;
};

struct _ValaGirParserParameterInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserParameterInfo *self);
};

struct _ValaGirParserMetadata {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GPatternSpec* pattern_spec;
	gchar* selector;
	ValaSourceReference* source_reference;
	gboolean used;
	ValaMap* args;
	ValaArrayList* children;
	ValaGirParserMetadataPrivate * priv;
};

struct _ValaGirParserMetadataClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserMetadata *self);
};

struct _ValaGirParserArgument {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaExpression* expression;
	ValaSourceReference* source_reference;
	gboolean used;
	ValaGirParserArgumentPrivate * priv;
};

struct _ValaGirParserArgumentClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserArgument *self);
};

struct _ValaGirParserParamSpecArgument {
	GParamSpec parent_instance;
};

struct _ValaGirParserMetadataSet {
	ValaGirParserMetadata parent_instance;
	ValaGirParserMetadataSetPrivate * priv;
};

struct _ValaGirParserMetadataSetClass {
	ValaGirParserMetadataClass parent_class;
};

struct _ValaGirParserParamSpecMetadata {
	GParamSpec parent_instance;
};

struct _ValaGirParserMetadataParser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGirParserMetadataParserPrivate * priv;
};

struct _ValaGirParserMetadataParserClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserMetadataParser *self);
};

struct _ValaGirParserMetadataParserPrivate {
	ValaGirParserMetadata* tree;
	ValaScanner* scanner;
	ValaSourceLocation begin;
	ValaSourceLocation end;
	ValaSourceLocation old_end;
	ValaTokenType current;
	ValaGirParserMetadata* parent_metadata;
};

struct _ValaGirParserParamSpecMetadataParser {
	GParamSpec parent_instance;
};

struct _ValaGirParserParamSpecNode {
	GParamSpec parent_instance;
};

struct _ValaGirParserParamSpecParameterInfo {
	GParamSpec parent_instance;
};

static gint ValaGirParser_private_offset;
static gpointer vala_gir_parser_parent_class = NULL;
static GRegex* vala_gir_parser_type_from_string_regex;
static GRegex* vala_gir_parser_type_from_string_regex = NULL;
static ValaArrayList* vala_gir_parser_node_new_namespaces;
static gpointer vala_gir_parser_argument_parent_class = NULL;
static gpointer vala_gir_parser_metadata_set_parent_class = NULL;
static gpointer vala_gir_parser_metadata_parent_class = NULL;
static ValaGirParserMetadata* vala_gir_parser_metadata__empty;
static ValaGirParserMetadata* vala_gir_parser_metadata__empty = NULL;
static gint ValaGirParserMetadataParser_private_offset;
static gpointer vala_gir_parser_metadata_parser_parent_class = NULL;
static gpointer vala_gir_parser_node_parent_class = NULL;
static ValaArrayList* vala_gir_parser_node_new_namespaces = NULL;
static gpointer vala_gir_parser_parameter_info_parent_class = NULL;

static gpointer vala_gir_parser_node_ref (gpointer instance);
static void vala_gir_parser_node_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_node (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_node (GValue* value,
                                     gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_node (GValue* value,
                                      gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_node (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gpointer vala_gir_parser_metadata_ref (gpointer instance);
static void vala_gir_parser_metadata_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_metadata (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_metadata (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_metadata (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_metadata (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_metadata_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType vala_gir_parser_argument_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGirParserArgumentType* vala_gir_parser_argument_type_from_string (const gchar* name);
static ValaGirParserArgumentType* _vala_gir_parser_argument_type_dup (ValaGirParserArgumentType* self);
static guint vala_gir_parser_unresolved_symbol_hash (ValaUnresolvedSymbol* sym);
static guint _vala_gir_parser_unresolved_symbol_hash_ghash_func (gconstpointer key);
static gboolean vala_gir_parser_unresolved_symbol_equal (ValaUnresolvedSymbol* sym1,
                                                  ValaUnresolvedSymbol* sym2);
static gboolean _vala_gir_parser_unresolved_symbol_equal_gequal_func (gconstpointer a,
                                                               gconstpointer b);
#define VALA_GIR_PARSER_GIR_VERSION "1.2"
static ValaGirParserNode* vala_gir_parser_node_new (const gchar* name);
static ValaGirParserNode* vala_gir_parser_node_construct (GType object_type,
                                                   const gchar* name);
static gpointer vala_gir_parser_parameter_info_ref (gpointer instance);
static void vala_gir_parser_parameter_info_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_parameter_info (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_parameter_info (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_parameter_info (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_parameter_info (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_parameter_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_gir_parser_map_vala_to_gir (ValaGirParser* self);
static void vala_gir_parser_resolve_gir_symbols (ValaGirParser* self);
static void vala_gir_parser_create_new_namespaces (ValaGirParser* self);
static void vala_gir_parser_resolve_type_arguments (ValaGirParser* self);
static void vala_gir_parser_node_process (ValaGirParserNode* self,
                                   ValaGirParser* parser);
static void vala_gir_parser_report_unused_metadata (ValaGirParser* self,
                                             ValaGirParserMetadata* metadata);
static void vala_gir_parser_set_symbol_mapping (ValaGirParser* self,
                                         ValaUnresolvedSymbol* map_from,
                                         ValaSymbol* map_to);
static void vala_gir_parser_real_visit_source_file (ValaCodeVisitor* base,
                                             ValaSourceFile* source_file);
static ValaGirParserMetadata* vala_gir_parser_metadata_get_empty (void);
static void vala_gir_parser_next (ValaGirParser* self);
static void vala_gir_parser_parse_repository (ValaGirParser* self);
static void vala_gir_parser_start_element (ValaGirParser* self,
                                    const gchar* name);
static ValaSourceReference* vala_gir_parser_get_current_src (ValaGirParser* self);
static void vala_gir_parser_end_element (ValaGirParser* self,
                                  const gchar* name);
static void vala_gir_parser_skip_element (ValaGirParser* self);
static void vala_gir_parser_add_symbol_to_container (ValaSymbol* container,
                                              ValaSymbol* sym);
static gboolean vala_gir_parser_is_container (ValaSymbol* sym);
static ValaUnresolvedSymbol* vala_gir_parser_parse_symbol_from_string (ValaGirParser* self,
                                                                const gchar* symbol_string,
                                                                ValaSourceReference* source_reference);
static void vala_gir_parser_assume_parameter_names (ValaGirParser* self,
                                             ValaSignal* sig,
                                             ValaSymbol* sym,
                                             gboolean skip_first);
static ValaGirParserNode* vala_gir_parser_find_invoker (ValaGirParser* self,
                                                 ValaGirParserNode* node);
static ValaGirParserMetadata* vala_gir_parser_get_current_metadata (ValaGirParser* self);
static ValaGirParserMetadata* vala_gir_parser_metadata_match_child (ValaGirParserMetadata* self,
                                                             const gchar* name,
                                                             const gchar* selector);
static gboolean vala_gir_parser_push_metadata (ValaGirParser* self);
static gboolean vala_gir_parser_metadata_has_argument (ValaGirParserMetadata* self,
                                                ValaGirParserArgumentType key);
static gboolean vala_gir_parser_metadata_get_bool (ValaGirParserMetadata* self,
                                            ValaGirParserArgumentType arg,
                                            gboolean default_value);
static void vala_gir_parser_pop_metadata (ValaGirParser* self);
static gboolean vala_gir_parser_parse_type_arguments_from_string (ValaGirParser* self,
                                                           ValaDataType* parent_type,
                                                           const gchar* type_arguments,
                                                           ValaSourceReference* source_reference);
static ValaDataType* vala_gir_parser_parse_type_from_string (ValaGirParser* self,
                                                      const gchar* type_string,
                                                      gboolean owned_by_default,
                                                      ValaSourceReference* source_reference);
static gchar* vala_gir_parser_element_get_string (ValaGirParser* self,
                                           const gchar* attribute_name,
                                           ValaGirParserArgumentType arg_type);
static gchar* vala_gir_parser_metadata_get_string (ValaGirParserMetadata* self,
                                            ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_element_get_type (ValaGirParser* self,
                                                ValaDataType* orig_type,
                                                gboolean owned_by_default,
                                                gboolean* no_array_length,
                                                gboolean* array_null_terminated,
                                                gboolean* changed);
static ValaSourceReference* vala_gir_parser_metadata_get_source_reference (ValaGirParserMetadata* self,
                                                                    ValaGirParserArgumentType arg);
static gchar* vala_gir_parser_element_get_name (ValaGirParser* self,
                                         const gchar* gir_name);
static gchar* vala_gir_parser_element_get_type_id (ValaGirParser* self);
static void vala_gir_parser_set_array_ccode (ValaGirParser* self,
                                      ValaSymbol* sym,
                                      ValaGirParserParameterInfo* info);
static ValaGirParserNode* vala_gir_parser_node_lookup (ValaGirParserNode* self,
                                                const gchar* name,
                                                gboolean create_namespace,
                                                ValaSourceReference* source_reference);
static gchar* vala_gir_parser_node_get_cname (ValaGirParserNode* self);
static void vala_gir_parser_set_type_id_ccode (ValaGirParser* self,
                                        ValaSymbol* sym);
static void vala_gir_parser_parse_namespace (ValaGirParser* self);
static void vala_gir_parser_parse_include (ValaGirParser* self);
static gchar* vala_gir_parser_parse_package (ValaGirParser* self);
static void vala_gir_parser_parse_c_include (ValaGirParser* self);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static ValaGirParserNode* vala_gir_parser_resolve_node (ValaGirParser* self,
                                                 ValaGirParserNode* parent_scope,
                                                 ValaUnresolvedSymbol* unresolved_sym,
                                                 gboolean create_namespace);
static ValaSymbol* vala_gir_parser_resolve_symbol (ValaGirParser* self,
                                            ValaGirParserNode* parent_scope,
                                            ValaUnresolvedSymbol* unresolved_sym);
static void vala_gir_parser_push_node (ValaGirParser* self,
                                const gchar* name,
                                gboolean merge);
static void vala_gir_parser_node_add_member (ValaGirParserNode* self,
                                      ValaGirParserNode* node);
static gchar* vala_gir_parser_node_get_gir_name (ValaGirParserNode* self);
static ValaUnresolvedSymbol* vala_gir_parser_node_get_unresolved_symbol (ValaGirParserNode* self);
static void vala_gir_parser_pop_node (ValaGirParser* self);
static gpointer vala_gir_parser_metadata_parser_ref (gpointer instance);
static void vala_gir_parser_metadata_parser_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_metadata_parser (const gchar* name,
                                                        const gchar* nick,
                                                        const gchar* blurb,
                                                        GType object_type,
                                                        GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_metadata_parser (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_metadata_parser (GValue* value,
                                                 gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_metadata_parser (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_metadata_parser_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGirParserMetadataParser* vala_gir_parser_metadata_parser_new (void);
static ValaGirParserMetadataParser* vala_gir_parser_metadata_parser_construct (GType object_type);
static ValaGirParserMetadata* vala_gir_parser_metadata_parser_parse_metadata (ValaGirParserMetadataParser* self,
                                                                       ValaSourceFile* metadata_file);
static void _vala_code_node_unref0_ (gpointer var);
static inline void _g_list_free__vala_code_node_unref0_ (GList* self);
static void vala_gir_parser_parse_alias (ValaGirParser* self);
static void vala_gir_parser_parse_error_domain (ValaGirParser* self);
static void vala_gir_parser_parse_enumeration (ValaGirParser* self,
                                        const gchar* element_name,
                                        gboolean error_domain);
static void vala_gir_parser_parse_bitfield (ValaGirParser* self);
static void vala_gir_parser_parse_method (ValaGirParser* self,
                                   const gchar* element_name);
static void vala_gir_parser_parse_callback (ValaGirParser* self);
static void vala_gir_parser_parse_record (ValaGirParser* self);
static void vala_gir_parser_parse_boxed (ValaGirParser* self,
                                  const gchar* element_name);
static void vala_gir_parser_parse_class (ValaGirParser* self);
static void vala_gir_parser_parse_interface (ValaGirParser* self);
static void vala_gir_parser_parse_union (ValaGirParser* self);
static void vala_gir_parser_parse_constant (ValaGirParser* self);
static ValaGirComment* vala_gir_parser_parse_symbol_doc (ValaGirParser* self);
static ValaDataType* vala_gir_parser_parse_type (ValaGirParser* self,
                                          gchar* * ctype,
                                          gint* array_length_idx,
                                          gboolean transfer_elements,
                                          gboolean* no_array_length,
                                          gboolean* array_null_terminated);
static void vala_gir_parser_calculate_common_prefix (ValaGirParser* self,
                                              gchar* * common_prefix,
                                              const gchar* cname);
static ValaComment* vala_gir_parser_parse_doc (ValaGirParser* self);
static void vala_gir_parser_parse_error_member (ValaGirParser* self);
static void vala_gir_parser_parse_enumeration_member (ValaGirParser* self);
static ValaExpression* vala_gir_parser_metadata_get_expression (ValaGirParserMetadata* self,
                                                         ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_parse_return_value (ValaGirParser* self,
                                                  gchar* * ctype,
                                                  gint* array_length_idx,
                                                  gboolean* no_array_length,
                                                  gboolean* array_null_terminated,
                                                  ValaComment* * comment);
static ValaParameter* vala_gir_parser_parse_parameter (ValaGirParser* self,
                                                gint* array_length_idx,
                                                gint* closure_idx,
                                                gint* destroy_idx,
                                                gchar* * scope,
                                                ValaComment* * comment,
                                                const gchar* default_name);
static gint vala_gir_parser_metadata_get_integer (ValaGirParserMetadata* self,
                                           ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_parse_type_from_gir_name (ValaGirParser* self,
                                                        const gchar* type_name,
                                                        gboolean* no_array_length,
                                                        gboolean* array_null_terminated,
                                                        const gchar* ctype);
static void vala_gir_parser_parse_field (ValaGirParser* self);
static void vala_gir_parser_parse_constructor (ValaGirParser* self);
static ValaProperty* vala_gir_parser_parse_property (ValaGirParser* self);
static void vala_gir_parser_parse_signal (ValaGirParser* self);
static void vala_gir_parser_parse_function (ValaGirParser* self,
                                     const gchar* element_name);
G_GNUC_INTERNAL void vala_gir_comment_add_content_for_parameter (ValaGirComment* self,
                                                 const gchar* name,
                                                 ValaComment* comment);
static ValaGirParserParameterInfo* vala_gir_parser_parameter_info_new (ValaParameter* param,
                                                                gint array_length_idx,
                                                                gint closure_idx,
                                                                gint destroy_idx,
                                                                gboolean is_async);
static ValaGirParserParameterInfo* vala_gir_parser_parameter_info_construct (GType object_type,
                                                                      ValaParameter* param,
                                                                      gint array_length_idx,
                                                                      gint closure_idx,
                                                                      gint destroy_idx,
                                                                      gboolean is_async);
static gpointer vala_gir_parser_argument_ref (gpointer instance);
static void vala_gir_parser_argument_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_argument (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_argument (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_argument (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_argument (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_argument_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_gir_parser_process_interface (ValaGirParser* self,
                                        ValaGirParserNode* iface_node);
static void vala_gir_parser_process_alias (ValaGirParser* self,
                                    ValaGirParserNode* alias);
static gchar* vala_gir_parser_node_get_full_name (ValaGirParserNode* self);
static void vala_gir_parser_process_callable (ValaGirParser* self,
                                       ValaGirParserNode* node);
static void vala_gir_parser_find_parent (ValaGirParser* self,
                                  const gchar* cname,
                                  ValaGirParserNode* current,
                                  ValaGirParserNode* * best,
                                  gint* match);
static gchar* vala_gir_parser_node_get_lower_case_cprefix (ValaGirParserNode* self);
static gboolean vala_gir_parser_same_gir (ValaGirParser* self,
                                   ValaSymbol* gir_component,
                                   ValaSymbol* sym);
static void vala_gir_parser_process_namespace_method (ValaGirParser* self,
                                               ValaGirParserNode* ns,
                                               ValaGirParserNode* node);
static void vala_gir_parser_node_remove_member (ValaGirParserNode* self,
                                         ValaGirParserNode* node);
static void vala_gir_parser_process_virtual_method_field (ValaGirParser* self,
                                                   ValaGirParserNode* node,
                                                   ValaDelegate* d,
                                                   ValaUnresolvedSymbol* gtype_struct_for);
static gchar* vala_gir_parser_node_to_string (ValaGirParserNode* self);
static ValaArrayList* vala_gir_parser_node_lookup_all (ValaGirParserNode* self,
                                                const gchar* name);
static void vala_gir_parser_process_async_method (ValaGirParser* self,
                                           ValaGirParserNode* node);
static gchar* vala_gir_parser_node_get_finish_cname (ValaGirParserNode* self);
static ValaGirParserNode* vala_gir_parser_base_interface_property (ValaGirParser* self,
                                                            ValaGirParserNode* prop_node);
static ValaGirParserArgument* vala_gir_parser_argument_new (ValaExpression* expression,
                                                     ValaSourceReference* source_reference);
static ValaGirParserArgument* vala_gir_parser_argument_construct (GType object_type,
                                                           ValaExpression* expression,
                                                           ValaSourceReference* source_reference);
static void vala_gir_parser_argument_finalize (ValaGirParserArgument * obj);
static GType vala_gir_parser_metadata_set_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGirParserMetadataSet* vala_gir_parser_metadata_set_new (const gchar* selector);
static ValaGirParserMetadataSet* vala_gir_parser_metadata_set_construct (GType object_type,
                                                                  const gchar* selector);
static ValaGirParserMetadata* vala_gir_parser_metadata_new (const gchar* pattern,
                                                     const gchar* selector,
                                                     ValaSourceReference* source_reference);
static ValaGirParserMetadata* vala_gir_parser_metadata_construct (GType object_type,
                                                           const gchar* pattern,
                                                           const gchar* selector,
                                                           ValaSourceReference* source_reference);
static void vala_gir_parser_metadata_set_add_sibling (ValaGirParserMetadataSet* self,
                                               ValaGirParserMetadata* metadata);
static void vala_gir_parser_metadata_add_child (ValaGirParserMetadata* self,
                                         ValaGirParserMetadata* metadata);
static void vala_gir_parser_metadata_add_argument (ValaGirParserMetadata* self,
                                            ValaGirParserArgumentType key,
                                            ValaGirParserArgument* value);
static void vala_gir_parser_metadata_finalize (ValaGirParserMetadata * obj);
static ValaSourceReference* vala_gir_parser_metadata_parser_get_current_src (ValaGirParserMetadataParser* self);
static ValaSourceReference* vala_gir_parser_metadata_parser_get_src (ValaGirParserMetadataParser* self,
                                                              ValaSourceLocation* begin,
                                                              ValaSourceLocation* end);
static ValaTokenType vala_gir_parser_metadata_parser_next (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_parse_rule (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_has_space (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_has_newline (ValaGirParserMetadataParser* self);
static gchar* vala_gir_parser_metadata_parser_get_string (ValaGirParserMetadataParser* self,
                                                   ValaSourceLocation* begin,
                                                   ValaSourceLocation* end);
static gchar* vala_gir_parser_metadata_parser_parse_identifier (ValaGirParserMetadataParser* self,
                                                         gboolean is_glob);
static gchar* vala_gir_parser_metadata_parser_parse_selector (ValaGirParserMetadataParser* self);
static ValaGirParserMetadata* vala_gir_parser_metadata_parser_parse_pattern (ValaGirParserMetadataParser* self);
static ValaExpression* vala_gir_parser_metadata_parser_parse_expression (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_parse_args (ValaGirParserMetadataParser* self,
                                                     ValaGirParserMetadata* metadata);
static void vala_gir_parser_metadata_parser_finalize (ValaGirParserMetadataParser * obj);
static gchar* vala_gir_parser_node_get_default_gir_name (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_lower_case_cprefix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_lower_case_csuffix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_lower_case_csuffix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_cprefix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_cname (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_cheader_filename (ValaGirParserNode* self);
static guint64 vala_gir_parser_node_parse_version_string (const gchar* version);
static void vala_gir_parser_node_finalize (ValaGirParserNode * obj);
static void vala_gir_parser_parameter_info_finalize (ValaGirParserParameterInfo * obj);
static void vala_gir_parser_finalize (ValaCodeVisitor * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
vala_gir_parser_get_instance_private (ValaGirParser* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGirParser_private_offset);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally9;
	__catch9_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static ValaGirParserArgumentType*
_vala_gir_parser_argument_type_dup (ValaGirParserArgumentType* self)
{
	ValaGirParserArgumentType* dup;
	dup = g_new0 (ValaGirParserArgumentType, 1);
	memcpy (dup, self, sizeof (ValaGirParserArgumentType));
	return dup;
}

static gpointer
__vala_gir_parser_argument_type_dup0 (gpointer self)
{
	return self ? _vala_gir_parser_argument_type_dup (self) : NULL;
}

static ValaGirParserArgumentType*
vala_gir_parser_argument_type_from_string (const gchar* name)
{
	ValaGirParserArgumentType* result = NULL;
	GEnumClass* enum_class = NULL;
	GTypeClass* _tmp0_;
	gchar* nick = NULL;
	gchar* _tmp1_;
	GEnumValue* enum_value = NULL;
	GEnumClass* _tmp2_;
	const gchar* _tmp3_;
	GEnumValue* _tmp4_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_type_class_ref (VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE);
	enum_class = (GEnumClass*) _tmp0_;
	_tmp1_ = string_replace (name, "_", "-");
	nick = _tmp1_;
	_tmp2_ = enum_class;
	_tmp3_ = nick;
	enum_value = g_enum_get_value_by_nick (_tmp2_, _tmp3_);
	_tmp4_ = enum_value;
	if (_tmp4_ != NULL) {
		ValaGirParserArgumentType value = 0;
		GEnumValue* _tmp5_;
		ValaGirParserArgumentType* _tmp6_;
		_tmp5_ = enum_value;
		value = (ValaGirParserArgumentType) (*_tmp5_).value;
		_tmp6_ = __vala_gir_parser_argument_type_dup0 (&value);
		result = _tmp6_;
		_g_free0 (nick);
		_g_type_class_unref0 (enum_class);
		return result;
	}
	result = NULL;
	_g_free0 (nick);
	_g_type_class_unref0 (enum_class);
	return result;
}

static GType
vala_gir_parser_argument_type_get_type (void)
{
	static volatile gsize vala_gir_parser_argument_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_argument_type_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP, "VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP", "skip"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN, "VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN", "hidden"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE", "type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS", "type-arguments"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME", "cheader-filename"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_NAME", "name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED, "VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED", "owned"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED, "VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED", "unowned"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT, "VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT", "parent"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE, "VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE", "nullable"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED", "deprecated"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT, "VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT", "replacement"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE", "deprecated-since"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE", "since"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY", "array"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX", "array-length-idx"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED", "array-null-terminated"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT", "default"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_OUT, "VALA_GIR_PARSER_ARGUMENT_TYPE_OUT", "out"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_REF, "VALA_GIR_PARSER_ARGUMENT_TYPE_REF", "ref"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME", "vfunc-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL, "VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL", "virtual"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, "VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT", "abstract"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE", "scope"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, "VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT", "struct"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS, "VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS", "throws"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT, "VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT", "printf-format"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD", "array-length-field"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL, "VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL", "sentinel"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE, "VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE", "closure"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY, "VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY", "destroy"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX, "VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX", "cprefix"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX, "VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX", "lower-case-cprefix"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN, "VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN", "errordomain"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE", "destroys-instance"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE", "base-type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME", "finish-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE", "finish-instance"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE", "symbol-type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX, "VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX", "instance-idx"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL, "VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL", "experimental"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING, "VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING", "floating"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID", "type-id"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID, "VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID", "return-void"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER, "VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER", "returns-modified-pointer"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME", "delegate-target-cname"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME", "finish-vfunc-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD, "VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD", "no-accessor-method"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME", "cname"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET, "VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET", "delegate-target"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX, "VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX", "lower-case-csuffix"}, {0, NULL, NULL}};
		GType vala_gir_parser_argument_type_type_id;
		vala_gir_parser_argument_type_type_id = g_enum_register_static ("ValaGirParserArgumentType", values);
		g_once_init_leave (&vala_gir_parser_argument_type_type_id__volatile, vala_gir_parser_argument_type_type_id);
	}
	return vala_gir_parser_argument_type_type_id__volatile;
}

static guint
_vala_gir_parser_unresolved_symbol_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = vala_gir_parser_unresolved_symbol_hash ((ValaUnresolvedSymbol*) key);
	return result;
}

static gboolean
_vala_gir_parser_unresolved_symbol_equal_gequal_func (gconstpointer a,
                                                      gconstpointer b)
{
	gboolean result;
	result = vala_gir_parser_unresolved_symbol_equal ((ValaUnresolvedSymbol*) a, (ValaUnresolvedSymbol*) b);
	return result;
}

/**
 * Parses all .gir source files in the specified code
 * context and builds a code tree.
 *
 * @param context a code context
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_gir_parser_node_ref0 (gpointer self)
{
	return self ? vala_gir_parser_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

void
vala_gir_parser_parse (ValaGirParser* self,
                       ValaCodeContext* context)
{
	ValaCodeContext* _tmp0_;
	ValaNamespace* _tmp1_;
	ValaNamespace* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaGirParserNode* _tmp7_;
	ValaGirParserNode* _tmp8_;
	ValaNamespace* _tmp9_;
	ValaNamespace* _tmp10_;
	ValaSymbol* _tmp11_;
	GEqualFunc _tmp12_;
	ValaArrayList* _tmp13_;
	ValaGirParserNode* _tmp14_;
	ValaGirParserNode* _tmp15_;
	ValaGirParserNode* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = vala_code_context_get_root (context);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_scope_lookup (_tmp4_, "GLib");
	_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_NAMESPACE) ? ((ValaNamespace*) _tmp5_) : NULL;
	if (_tmp6_ == NULL) {
		_vala_code_node_unref0 (_tmp5_);
	}
	_vala_code_node_unref0 (self->priv->glib_ns);
	self->priv->glib_ns = _tmp6_;
	_tmp7_ = vala_gir_parser_node_new (NULL);
	_vala_gir_parser_node_unref0 (self->priv->root);
	self->priv->root = _tmp7_;
	_tmp8_ = self->priv->root;
	_tmp9_ = vala_code_context_get_root (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp10_);
	_vala_code_node_unref0 (_tmp8_->symbol);
	_tmp8_->symbol = _tmp11_;
	_tmp12_ = g_direct_equal;
	_tmp13_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp12_);
	_vala_iterable_unref0 (self->priv->tree_stack);
	self->priv->tree_stack = _tmp13_;
	_tmp14_ = self->priv->root;
	_tmp15_ = _vala_gir_parser_node_ref0 (_tmp14_);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = _tmp15_;
	vala_gir_parser_map_vala_to_gir (self);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	vala_gir_parser_resolve_gir_symbols (self);
	vala_gir_parser_create_new_namespaces (self);
	vala_gir_parser_resolve_type_arguments (self);
	_tmp16_ = self->priv->root;
	vala_gir_parser_node_process (_tmp16_, self);
	{
		ValaArrayList* _metadata_list = NULL;
		ValaArrayList* _tmp17_;
		ValaArrayList* _tmp18_;
		gint _metadata_size = 0;
		ValaArrayList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _metadata_index = 0;
		_tmp17_ = self->priv->metadata_roots;
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_metadata_list = _tmp18_;
		_tmp19_ = _metadata_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_metadata_size = _tmp21_;
		_metadata_index = -1;
		while (TRUE) {
			ValaGirParserMetadata* metadata = NULL;
			ValaArrayList* _tmp22_;
			gpointer _tmp23_;
			ValaGirParserMetadata* _tmp24_;
			_metadata_index = _metadata_index + 1;
			if (!(_metadata_index < _metadata_size)) {
				break;
			}
			_tmp22_ = _metadata_list;
			_tmp23_ = vala_list_get ((ValaList*) _tmp22_, _metadata_index);
			metadata = (ValaGirParserMetadata*) _tmp23_;
			_tmp24_ = metadata;
			vala_gir_parser_report_unused_metadata (self, _tmp24_);
			_vala_gir_parser_metadata_unref0 (metadata);
		}
		_vala_iterable_unref0 (_metadata_list);
	}
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = NULL;
}

static void
vala_gir_parser_map_vala_to_gir (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaList* _source_file_list = NULL;
		ValaCodeContext* _tmp0_;
		ValaList* _tmp1_;
		gint _source_file_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _source_file_index = 0;
		_tmp0_ = self->priv->context;
		_tmp1_ = vala_code_context_get_source_files (_tmp0_);
		_source_file_list = _tmp1_;
		_tmp2_ = _source_file_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_source_file_size = _tmp4_;
		_source_file_index = -1;
		while (TRUE) {
			ValaSourceFile* source_file = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gchar* gir_namespace = NULL;
			ValaSourceFile* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* gir_version = NULL;
			ValaSourceFile* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			ValaNamespace* ns = NULL;
			const gchar* _tmp15_;
			const gchar* _tmp31_;
			ValaSet* _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			ValaUnresolvedSymbol* gir_symbol = NULL;
			const gchar* _tmp37_;
			ValaUnresolvedSymbol* _tmp38_;
			const gchar* _tmp39_;
			ValaNamespace* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			_source_file_index = _source_file_index + 1;
			if (!(_source_file_index < _source_file_size)) {
				break;
			}
			_tmp5_ = _source_file_list;
			_tmp6_ = vala_list_get (_tmp5_, _source_file_index);
			source_file = (ValaSourceFile*) _tmp6_;
			_tmp7_ = source_file;
			_tmp8_ = vala_source_file_get_gir_namespace (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strdup (_tmp9_);
			gir_namespace = _tmp10_;
			_tmp11_ = source_file;
			_tmp12_ = vala_source_file_get_gir_version (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup (_tmp13_);
			gir_version = _tmp14_;
			ns = NULL;
			_tmp15_ = gir_namespace;
			if (_tmp15_ == NULL) {
				{
					ValaList* _node_list = NULL;
					ValaSourceFile* _tmp16_;
					ValaList* _tmp17_;
					gint _node_size = 0;
					ValaList* _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					gint _node_index = 0;
					_tmp16_ = source_file;
					_tmp17_ = vala_source_file_get_nodes (_tmp16_);
					_node_list = _tmp17_;
					_tmp18_ = _node_list;
					_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
					_tmp20_ = _tmp19_;
					_node_size = _tmp20_;
					_node_index = -1;
					while (TRUE) {
						ValaCodeNode* node = NULL;
						ValaList* _tmp21_;
						gpointer _tmp22_;
						ValaCodeNode* _tmp23_;
						_node_index = _node_index + 1;
						if (!(_node_index < _node_size)) {
							break;
						}
						_tmp21_ = _node_list;
						_tmp22_ = vala_list_get (_tmp21_, _node_index);
						node = (ValaCodeNode*) _tmp22_;
						_tmp23_ = node;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_NAMESPACE)) {
							ValaCodeNode* _tmp24_;
							ValaNamespace* _tmp25_;
							ValaNamespace* _tmp26_;
							gchar* _tmp27_;
							const gchar* _tmp28_;
							_tmp24_ = node;
							_tmp25_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALA_TYPE_NAMESPACE, ValaNamespace));
							_vala_code_node_unref0 (ns);
							ns = _tmp25_;
							_tmp26_ = ns;
							_tmp27_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp26_, "CCode", "gir_namespace", NULL);
							_g_free0 (gir_namespace);
							gir_namespace = _tmp27_;
							_tmp28_ = gir_namespace;
							if (_tmp28_ != NULL) {
								ValaNamespace* _tmp29_;
								gchar* _tmp30_;
								_tmp29_ = ns;
								_tmp30_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp29_, "CCode", "gir_version", NULL);
								_g_free0 (gir_version);
								gir_version = _tmp30_;
								_vala_code_node_unref0 (node);
								break;
							}
						}
						_vala_code_node_unref0 (node);
					}
					_vala_iterable_unref0 (_node_list);
				}
			}
			_tmp31_ = gir_namespace;
			if (_tmp31_ == NULL) {
				_vala_code_node_unref0 (ns);
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
				_vala_source_file_unref0 (source_file);
				continue;
			}
			_tmp32_ = self->priv->provided_namespaces;
			_tmp33_ = gir_namespace;
			_tmp34_ = gir_version;
			_tmp35_ = g_strdup_printf ("%s-%s", _tmp33_, _tmp34_);
			_tmp36_ = _tmp35_;
			vala_collection_add ((ValaCollection*) _tmp32_, _tmp36_);
			_g_free0 (_tmp36_);
			_tmp37_ = gir_namespace;
			_tmp38_ = vala_unresolved_symbol_new (NULL, _tmp37_, NULL);
			gir_symbol = _tmp38_;
			_tmp39_ = gir_namespace;
			_tmp40_ = ns;
			_tmp41_ = vala_symbol_get_name ((ValaSymbol*) _tmp40_);
			_tmp42_ = _tmp41_;
			if (g_strcmp0 (_tmp39_, _tmp42_) != 0) {
				ValaUnresolvedSymbol* _tmp43_;
				ValaNamespace* _tmp44_;
				_tmp43_ = gir_symbol;
				_tmp44_ = ns;
				vala_gir_parser_set_symbol_mapping (self, _tmp43_, (ValaSymbol*) _tmp44_);
			}
			{
				ValaList* _node_list = NULL;
				ValaSourceFile* _tmp45_;
				ValaList* _tmp46_;
				gint _node_size = 0;
				ValaList* _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				gint _node_index = 0;
				_tmp45_ = source_file;
				_tmp46_ = vala_source_file_get_nodes (_tmp45_);
				_node_list = _tmp46_;
				_tmp47_ = _node_list;
				_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
				_tmp49_ = _tmp48_;
				_node_size = _tmp49_;
				_node_index = -1;
				while (TRUE) {
					ValaCodeNode* node = NULL;
					ValaList* _tmp50_;
					gpointer _tmp51_;
					ValaCodeNode* _tmp52_;
					_node_index = _node_index + 1;
					if (!(_node_index < _node_size)) {
						break;
					}
					_tmp50_ = _node_list;
					_tmp51_ = vala_list_get (_tmp50_, _node_index);
					node = (ValaCodeNode*) _tmp51_;
					_tmp52_ = node;
					if (vala_code_node_has_attribute_argument (_tmp52_, "GIR", "name")) {
						ValaUnresolvedSymbol* map_from = NULL;
						ValaUnresolvedSymbol* _tmp53_;
						ValaCodeNode* _tmp54_;
						gchar* _tmp55_;
						gchar* _tmp56_;
						ValaUnresolvedSymbol* _tmp57_;
						ValaUnresolvedSymbol* _tmp58_;
						ValaUnresolvedSymbol* _tmp59_;
						ValaCodeNode* _tmp60_;
						_tmp53_ = gir_symbol;
						_tmp54_ = node;
						_tmp55_ = vala_code_node_get_attribute_string (_tmp54_, "GIR", "name", NULL);
						_tmp56_ = _tmp55_;
						_tmp57_ = vala_unresolved_symbol_new (_tmp53_, _tmp56_, NULL);
						_tmp58_ = _tmp57_;
						_g_free0 (_tmp56_);
						map_from = _tmp58_;
						_tmp59_ = map_from;
						_tmp60_ = node;
						vala_gir_parser_set_symbol_mapping (self, _tmp59_, G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, VALA_TYPE_SYMBOL, ValaSymbol));
						_vala_code_node_unref0 (map_from);
					}
					_vala_code_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			_vala_code_node_unref0 (gir_symbol);
			_vala_code_node_unref0 (ns);
			_g_free0 (gir_version);
			_g_free0 (gir_namespace);
			_vala_source_file_unref0 (source_file);
		}
		_vala_iterable_unref0 (_source_file_list);
	}
}

static void
vala_gir_parser_real_visit_source_file (ValaCodeVisitor* base,
                                        ValaSourceFile* source_file)
{
	ValaGirParser * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ValaGirParser*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_filename (source_file);
	_tmp1_ = _tmp0_;
	if (g_str_has_suffix (_tmp1_, ".gir")) {
		vala_gir_parser_parse_file (self, source_file);
	}
}

static gpointer
_vala_gir_parser_metadata_ref0 (gpointer self)
{
	return self ? vala_gir_parser_metadata_ref (self) : NULL;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

void
vala_gir_parser_parse_file (ValaGirParser* self,
                            ValaSourceFile* source_file)
{
	gboolean has_global_context = FALSE;
	ValaCodeContext* _tmp0_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	ValaGirParserMetadata* _tmp6_;
	ValaGirParserMetadata* _tmp7_;
	ValaGirParserMetadata* _tmp8_;
	ValaSourceFile* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ValaMarkupReader* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_tmp0_ = self->priv->context;
	has_global_context = _tmp0_ != NULL;
	if (!has_global_context) {
		ValaCodeContext* _tmp1_;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		_tmp1_ = vala_source_file_get_context (source_file);
		_tmp2_ = _tmp1_;
		_tmp3_ = _vala_code_context_ref0 (_tmp2_);
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = _tmp3_;
	}
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp4_);
	_vala_iterable_unref0 (self->priv->metadata_stack);
	self->priv->metadata_stack = _tmp5_;
	_tmp6_ = vala_gir_parser_metadata_get_empty ();
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_gir_parser_metadata_ref0 (_tmp7_);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = _tmp8_;
	self->priv->cheader_filenames = (_vala_array_free (self->priv->cheader_filenames, self->priv->cheader_filenames_length1, (GDestroyNotify) g_free), NULL);
	self->priv->cheader_filenames = NULL;
	self->priv->cheader_filenames_length1 = 0;
	self->priv->_cheader_filenames_size_ = self->priv->cheader_filenames_length1;
	_tmp9_ = _vala_source_file_ref0 (source_file);
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = _tmp9_;
	_tmp10_ = vala_source_file_get_filename (source_file);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_markup_reader_new (_tmp11_);
	_vala_markup_reader_unref0 (self->priv->reader);
	self->priv->reader = _tmp12_;
	vala_gir_parser_next (self);
	vala_gir_parser_next (self);
	vala_gir_parser_next (self);
	vala_gir_parser_parse_repository (self);
	_vala_markup_reader_unref0 (self->priv->reader);
	self->priv->reader = NULL;
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = NULL;
	if (!has_global_context) {
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = NULL;
	}
}

static void
vala_gir_parser_next (ValaGirParser* self)
{
	ValaMarkupReader* _tmp0_;
	ValaSourceLocation _tmp1_ = {0};
	ValaSourceLocation _tmp2_ = {0};
	ValaMarkupTokenType _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_read_token (_tmp0_, &_tmp1_, &_tmp2_);
	self->priv->begin = _tmp1_;
	self->priv->end = _tmp2_;
	self->priv->current_token = _tmp3_;
}

static void
vala_gir_parser_start_element (ValaGirParser* self,
                               const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	ValaMarkupTokenType _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->current_token;
	if (_tmp1_ != VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaMarkupReader* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->reader;
		_tmp3_ = vala_markup_reader_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, name) != 0;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = vala_gir_parser_get_current_src (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("expected start element of `%s'", name);
		_tmp8_ = _tmp7_;
		vala_report_error (_tmp6_, _tmp8_);
		_g_free0 (_tmp8_);
		_vala_source_reference_unref0 (_tmp6_);
	}
}

static void
vala_gir_parser_end_element (ValaGirParser* self,
                             const gchar* name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		ValaMarkupTokenType _tmp1_;
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp1_ = self->priv->current_token;
		if (_tmp1_ != VALA_MARKUP_TOKEN_TYPE_END_ELEMENT) {
			_tmp0_ = TRUE;
		} else {
			ValaMarkupReader* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = self->priv->reader;
			_tmp3_ = vala_markup_reader_get_name (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp0_ = g_strcmp0 (_tmp4_, name) != 0;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = vala_gir_parser_get_current_src (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("expected end element of `%s'", name);
		_tmp8_ = _tmp7_;
		vala_report_warning (_tmp6_, _tmp8_);
		_g_free0 (_tmp8_);
		_vala_source_reference_unref0 (_tmp6_);
		vala_gir_parser_skip_element (self);
	}
	vala_gir_parser_next (self);
}

static ValaSourceReference*
vala_gir_parser_get_current_src (ValaGirParser* self)
{
	ValaSourceReference* result = NULL;
	ValaSourceFile* _tmp0_;
	ValaSourceLocation _tmp1_;
	ValaSourceLocation _tmp2_;
	ValaSourceReference* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_source_file;
	_tmp1_ = self->priv->begin;
	_tmp2_ = self->priv->end;
	_tmp3_ = vala_source_reference_new (_tmp0_, &_tmp1_, &_tmp2_);
	result = _tmp3_;
	return result;
}

static void
vala_gir_parser_add_symbol_to_container (ValaSymbol* container,
                                         ValaSymbol* sym)
{
	g_return_if_fail (container != NULL);
	g_return_if_fail (sym != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		cl = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_CLASS, ValaClass);
		if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
			ValaClass* _tmp0_;
			_tmp0_ = cl;
			vala_symbol_add_class ((ValaSymbol*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
				ValaClass* _tmp1_;
				_tmp1_ = cl;
				vala_symbol_add_constant ((ValaSymbol*) _tmp1_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM)) {
					ValaClass* _tmp2_;
					_tmp2_ = cl;
					vala_symbol_add_enum ((ValaSymbol*) _tmp2_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
						ValaClass* _tmp3_;
						_tmp3_ = cl;
						vala_symbol_add_field ((ValaSymbol*) _tmp3_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
							ValaClass* _tmp4_;
							_tmp4_ = cl;
							vala_symbol_add_method ((ValaSymbol*) _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PROPERTY)) {
								ValaClass* _tmp5_;
								_tmp5_ = cl;
								vala_symbol_add_property ((ValaSymbol*) _tmp5_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_SIGNAL)) {
									ValaClass* _tmp6_;
									_tmp6_ = cl;
									vala_symbol_add_signal ((ValaSymbol*) _tmp6_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT)) {
										ValaClass* _tmp7_;
										_tmp7_ = cl;
										vala_symbol_add_struct ((ValaSymbol*) _tmp7_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
									}
								}
							}
						}
					}
				}
			}
		}
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_ENUM)) {
			ValaEnum* en = NULL;
			en = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_ENUM, ValaEnum);
			if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM_VALUE)) {
				ValaEnum* _tmp8_;
				_tmp8_ = en;
				vala_enum_add_value (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM_VALUE, ValaEnumValue));
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
					ValaEnum* _tmp9_;
					_tmp9_ = en;
					vala_symbol_add_constant ((ValaSymbol*) _tmp9_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
						ValaEnum* _tmp10_;
						_tmp10_ = en;
						vala_symbol_add_method ((ValaSymbol*) _tmp10_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
					}
				}
			}
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_INTERFACE)) {
				ValaInterface* iface = NULL;
				iface = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_INTERFACE, ValaInterface);
				if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
					ValaInterface* _tmp11_;
					_tmp11_ = iface;
					vala_symbol_add_class ((ValaSymbol*) _tmp11_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
						ValaInterface* _tmp12_;
						_tmp12_ = iface;
						vala_symbol_add_constant ((ValaSymbol*) _tmp12_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM)) {
							ValaInterface* _tmp13_;
							_tmp13_ = iface;
							vala_symbol_add_enum ((ValaSymbol*) _tmp13_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
								ValaInterface* _tmp14_;
								_tmp14_ = iface;
								vala_symbol_add_field ((ValaSymbol*) _tmp14_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
									ValaInterface* _tmp15_;
									_tmp15_ = iface;
									vala_symbol_add_method ((ValaSymbol*) _tmp15_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PROPERTY)) {
										ValaInterface* _tmp16_;
										_tmp16_ = iface;
										vala_symbol_add_property ((ValaSymbol*) _tmp16_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									} else {
										if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_SIGNAL)) {
											ValaInterface* _tmp17_;
											_tmp17_ = iface;
											vala_symbol_add_signal ((ValaSymbol*) _tmp17_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
										} else {
											if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT)) {
												ValaInterface* _tmp18_;
												_tmp18_ = iface;
												vala_symbol_add_struct ((ValaSymbol*) _tmp18_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
											}
										}
									}
								}
							}
						}
					}
				}
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_NAMESPACE)) {
					ValaNamespace* ns = NULL;
					ns = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_NAMESPACE, ValaNamespace);
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_NAMESPACE)) {
						ValaNamespace* _tmp19_;
						_tmp19_ = ns;
						vala_symbol_add_namespace ((ValaSymbol*) _tmp19_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_NAMESPACE, ValaNamespace));
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
							ValaNamespace* _tmp20_;
							_tmp20_ = ns;
							vala_symbol_add_class ((ValaSymbol*) _tmp20_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
								ValaNamespace* _tmp21_;
								_tmp21_ = ns;
								vala_symbol_add_constant ((ValaSymbol*) _tmp21_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_DELEGATE)) {
									ValaNamespace* _tmp22_;
									_tmp22_ = ns;
									vala_symbol_add_delegate ((ValaSymbol*) _tmp22_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_DELEGATE, ValaDelegate));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM)) {
										ValaNamespace* _tmp23_;
										_tmp23_ = ns;
										vala_symbol_add_enum ((ValaSymbol*) _tmp23_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
									} else {
										if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ERROR_DOMAIN)) {
											ValaNamespace* _tmp24_;
											_tmp24_ = ns;
											vala_symbol_add_error_domain ((ValaSymbol*) _tmp24_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain));
										} else {
											if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
												ValaNamespace* _tmp25_;
												_tmp25_ = ns;
												vala_symbol_add_field ((ValaSymbol*) _tmp25_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
											} else {
												if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_INTERFACE)) {
													ValaNamespace* _tmp26_;
													_tmp26_ = ns;
													vala_symbol_add_interface ((ValaSymbol*) _tmp26_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_INTERFACE, ValaInterface));
												} else {
													if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
														ValaNamespace* _tmp27_;
														_tmp27_ = ns;
														vala_symbol_add_method ((ValaSymbol*) _tmp27_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
													} else {
														if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT)) {
															ValaNamespace* _tmp28_;
															_tmp28_ = ns;
															vala_symbol_add_struct ((ValaSymbol*) _tmp28_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_STRUCT)) {
						ValaStruct* st = NULL;
						st = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_STRUCT, ValaStruct);
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
							ValaStruct* _tmp29_;
							_tmp29_ = st;
							vala_symbol_add_constant ((ValaSymbol*) _tmp29_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
								ValaStruct* _tmp30_;
								_tmp30_ = st;
								vala_symbol_add_field ((ValaSymbol*) _tmp30_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
									ValaStruct* _tmp31_;
									_tmp31_ = st;
									vala_symbol_add_method ((ValaSymbol*) _tmp31_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PROPERTY)) {
										ValaStruct* _tmp32_;
										_tmp32_ = st;
										vala_symbol_add_property ((ValaSymbol*) _tmp32_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									}
								}
							}
						}
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_ERROR_DOMAIN)) {
							ValaErrorDomain* ed = NULL;
							ed = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain);
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ERROR_CODE)) {
								ValaErrorDomain* _tmp33_;
								_tmp33_ = ed;
								vala_error_domain_add_code (_tmp33_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_CODE, ValaErrorCode));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
									ValaErrorDomain* _tmp34_;
									_tmp34_ = ed;
									vala_symbol_add_method ((ValaSymbol*) _tmp34_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								}
							}
						} else {
							ValaSourceReference* _tmp35_;
							ValaSourceReference* _tmp36_;
							const gchar* _tmp37_;
							const gchar* _tmp38_;
							const gchar* _tmp39_;
							const gchar* _tmp40_;
							gchar* _tmp41_;
							gchar* _tmp42_;
							_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
							_tmp36_ = _tmp35_;
							_tmp37_ = vala_symbol_get_name (sym);
							_tmp38_ = _tmp37_;
							_tmp39_ = vala_symbol_get_name (container);
							_tmp40_ = _tmp39_;
							_tmp41_ = g_strdup_printf ("impossible to add `%s' to container `%s'", _tmp38_, _tmp40_);
							_tmp42_ = _tmp41_;
							vala_report_error (_tmp36_, _tmp42_);
							_g_free0 (_tmp42_);
						}
					}
				}
			}
		}
	}
}

static gboolean
vala_gir_parser_is_container (ValaSymbol* sym)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (sym != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_NAMESPACE);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ERROR_DOMAIN);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM);
	}
	result = _tmp0_;
	return result;
}

static ValaUnresolvedSymbol*
vala_gir_parser_parse_symbol_from_string (ValaGirParser* self,
                                          const gchar* symbol_string,
                                          ValaSourceReference* source_reference)
{
	ValaUnresolvedSymbol* result = NULL;
	ValaUnresolvedSymbol* sym = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	ValaUnresolvedSymbol* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol_string != NULL, NULL);
	sym = NULL;
	_tmp1_ = _tmp0_ = g_strsplit (symbol_string, ".", 0);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp1_;
		s_collection_length1 = _vala_array_length (_tmp0_);
		for (s_it = 0; s_it < _vala_array_length (_tmp0_); s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				ValaUnresolvedSymbol* _tmp2_;
				const gchar* _tmp3_;
				ValaUnresolvedSymbol* _tmp4_;
				_tmp2_ = sym;
				_tmp3_ = s;
				_tmp4_ = vala_unresolved_symbol_new (_tmp2_, _tmp3_, source_reference);
				_vala_code_node_unref0 (sym);
				sym = _tmp4_;
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = sym;
	if (_tmp5_ == NULL) {
		vala_report_error (source_reference, "a symbol must be specified");
	}
	result = sym;
	return result;
}

static void
vala_gir_parser_set_symbol_mapping (ValaGirParser* self,
                                    ValaUnresolvedSymbol* map_from,
                                    ValaSymbol* map_to)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (map_from != NULL);
	g_return_if_fail (map_to != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (map_from, VALA_TYPE_UNRESOLVED_SYMBOL)) {
		ValaHashMap* _tmp0_;
		_tmp0_ = self->priv->unresolved_symbols_map;
		vala_map_set ((ValaMap*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (map_from, VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol), map_to);
	}
}

static void
vala_gir_parser_assume_parameter_names (ValaGirParser* self,
                                        ValaSignal* sig,
                                        ValaSymbol* sym,
                                        gboolean skip_first)
{
	ValaIterator* iter = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaIterator* _tmp2_;
	ValaIterator* _tmp3_;
	gboolean first = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = vala_callable_get_parameters (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CALLABLE, ValaCallable));
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_iterable_iterator ((ValaIterable*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_iterable_unref0 (_tmp1_);
	iter = _tmp3_;
	first = TRUE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp4_;
		gint _param_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _param_index = 0;
		_tmp4_ = vala_callable_get_parameters ((ValaCallable*) sig);
		_param_list = _tmp4_;
		_tmp5_ = _param_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_param_size = _tmp7_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaIterator* _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaParameter* _tmp13_;
			ValaIterator* _tmp14_;
			gpointer _tmp15_;
			ValaParameter* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp8_ = _param_list;
			_tmp9_ = vala_list_get (_tmp8_, _param_index);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = iter;
			if (!vala_iterator_next (_tmp10_)) {
				_vala_code_node_unref0 (param);
				break;
			}
			if (skip_first) {
				_tmp11_ = first;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				ValaIterator* _tmp12_;
				_tmp12_ = iter;
				if (!vala_iterator_next (_tmp12_)) {
					_vala_code_node_unref0 (param);
					break;
				}
				first = FALSE;
			}
			_tmp13_ = param;
			_tmp14_ = iter;
			_tmp15_ = vala_iterator_get (_tmp14_);
			_tmp16_ = (ValaParameter*) _tmp15_;
			_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
			_tmp18_ = _tmp17_;
			vala_symbol_set_name ((ValaSymbol*) _tmp13_, _tmp18_);
			_vala_code_node_unref0 (_tmp16_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_vala_iterator_unref0 (iter);
}

static ValaGirParserNode*
vala_gir_parser_find_invoker (ValaGirParser* self,
                              ValaGirParserNode* node)
{
	ValaGirParserNode* result = NULL;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp0_;
	ValaMethod* _tmp1_;
	gchar* prefix = NULL;
	ValaMethod* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_METHOD, ValaMethod));
	m = _tmp1_;
	_tmp2_ = m;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_", _tmp4_);
	prefix = _tmp5_;
	{
		ValaArrayList* _n_list = NULL;
		ValaGirParserNode* _tmp6_;
		ValaArrayList* _tmp7_;
		ValaArrayList* _tmp8_;
		gint _n_size = 0;
		ValaArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _n_index = 0;
		_tmp6_ = node->parent;
		_tmp7_ = _tmp6_->members;
		_tmp8_ = _vala_iterable_ref0 (_tmp7_);
		_n_list = _tmp8_;
		_tmp9_ = _n_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_n_size = _tmp11_;
		_n_index = -1;
		while (TRUE) {
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp12_;
			gpointer _tmp13_;
			ValaGirParserNode* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			ValaMethod* invoker = NULL;
			ValaGirParserNode* _tmp17_;
			ValaSymbol* _tmp18_;
			ValaMethod* _tmp19_;
			gboolean _tmp20_ = FALSE;
			ValaMethod* _tmp21_;
			ValaIterator* iter = NULL;
			ValaMethod* _tmp32_;
			ValaList* _tmp33_;
			ValaList* _tmp34_;
			ValaIterator* _tmp35_;
			ValaIterator* _tmp36_;
			ValaMethod* _tmp54_;
			_n_index = _n_index + 1;
			if (!(_n_index < _n_size)) {
				break;
			}
			_tmp12_ = _n_list;
			_tmp13_ = vala_list_get ((ValaList*) _tmp12_, _n_index);
			n = (ValaGirParserNode*) _tmp13_;
			_tmp14_ = n;
			_tmp15_ = _tmp14_->name;
			_tmp16_ = prefix;
			if (!g_str_has_prefix (_tmp15_, _tmp16_)) {
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp17_ = n;
			_tmp18_ = _tmp17_->symbol;
			_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp18_) : NULL);
			invoker = _tmp19_;
			_tmp21_ = invoker;
			if (_tmp21_ == NULL) {
				_tmp20_ = TRUE;
			} else {
				ValaMethod* _tmp22_;
				ValaList* _tmp23_;
				ValaList* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				ValaMethod* _tmp27_;
				ValaList* _tmp28_;
				ValaList* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				_tmp22_ = m;
				_tmp23_ = vala_callable_get_parameters ((ValaCallable*) _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = invoker;
				_tmp28_ = vala_callable_get_parameters ((ValaCallable*) _tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
				_tmp31_ = _tmp30_;
				_tmp20_ = _tmp26_ != _tmp31_;
				_vala_iterable_unref0 (_tmp29_);
				_vala_iterable_unref0 (_tmp24_);
			}
			if (_tmp20_) {
				_vala_code_node_unref0 (invoker);
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp32_ = invoker;
			_tmp33_ = vala_callable_get_parameters ((ValaCallable*) _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_iterable_iterator ((ValaIterable*) _tmp34_);
			_tmp36_ = _tmp35_;
			_vala_iterable_unref0 (_tmp34_);
			iter = _tmp36_;
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp37_;
				ValaList* _tmp38_;
				gint _param_size = 0;
				ValaList* _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				gint _param_index = 0;
				_tmp37_ = m;
				_tmp38_ = vala_callable_get_parameters ((ValaCallable*) _tmp37_);
				_param_list = _tmp38_;
				_tmp39_ = _param_list;
				_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
				_tmp41_ = _tmp40_;
				_param_size = _tmp41_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp42_;
					gpointer _tmp43_;
					ValaIterator* _tmp44_;
					ValaParameter* _tmp45_;
					const gchar* _tmp46_;
					const gchar* _tmp47_;
					ValaIterator* _tmp48_;
					gpointer _tmp49_;
					ValaParameter* _tmp50_;
					const gchar* _tmp51_;
					const gchar* _tmp52_;
					gboolean _tmp53_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp42_ = _param_list;
					_tmp43_ = vala_list_get (_tmp42_, _param_index);
					param = (ValaParameter*) _tmp43_;
					_tmp44_ = iter;
					_vala_assert (vala_iterator_next (_tmp44_), "iter.next ()");
					_tmp45_ = param;
					_tmp46_ = vala_symbol_get_name ((ValaSymbol*) _tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = iter;
					_tmp49_ = vala_iterator_get (_tmp48_);
					_tmp50_ = (ValaParameter*) _tmp49_;
					_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = g_strcmp0 (_tmp47_, _tmp52_) != 0;
					_vala_code_node_unref0 (_tmp50_);
					if (_tmp53_) {
						_vala_code_node_unref0 (invoker);
						invoker = NULL;
						_vala_code_node_unref0 (param);
						break;
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp54_ = invoker;
			if (_tmp54_ != NULL) {
				result = n;
				_vala_iterator_unref0 (iter);
				_vala_code_node_unref0 (invoker);
				_vala_iterable_unref0 (_n_list);
				_g_free0 (prefix);
				_vala_code_node_unref0 (m);
				return result;
			}
			_vala_iterator_unref0 (iter);
			_vala_code_node_unref0 (invoker);
			_vala_gir_parser_node_unref0 (n);
		}
		_vala_iterable_unref0 (_n_list);
	}
	result = NULL;
	_g_free0 (prefix);
	_vala_code_node_unref0 (m);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static ValaGirParserMetadata*
vala_gir_parser_get_current_metadata (ValaGirParser* self)
{
	ValaGirParserMetadata* result = NULL;
	gchar* selector = NULL;
	ValaMarkupReader* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* child_name = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	const gchar* _tmp13_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	ValaGirParserMetadata* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	ValaGirParserMetadata* _tmp29_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	selector = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "name");
	child_name = _tmp5_;
	_tmp6_ = child_name;
	if (_tmp6_ == NULL) {
		ValaMarkupReader* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = self->priv->reader;
		_tmp8_ = vala_markup_reader_get_attribute (_tmp7_, "glib:name");
		_g_free0 (child_name);
		child_name = _tmp8_;
	}
	_tmp10_ = selector;
	if (g_strcmp0 (_tmp10_, "union") == 0) {
		const gchar* _tmp11_;
		_tmp11_ = child_name;
		_tmp9_ = _tmp11_ == NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("union");
		_g_free0 (child_name);
		child_name = _tmp12_;
	}
	_tmp13_ = child_name;
	if (_tmp13_ == NULL) {
		ValaGirParserMetadata* _tmp14_;
		ValaGirParserMetadata* _tmp15_;
		ValaGirParserMetadata* _tmp16_;
		_tmp14_ = vala_gir_parser_metadata_get_empty ();
		_tmp15_ = _tmp14_;
		_tmp16_ = _vala_gir_parser_metadata_ref0 (_tmp15_);
		result = _tmp16_;
		_g_free0 (child_name);
		_g_free0 (selector);
		return result;
	}
	_tmp17_ = selector;
	_tmp18_ = string_replace (_tmp17_, "-", "_");
	_g_free0 (selector);
	selector = _tmp18_;
	_tmp19_ = child_name;
	_tmp20_ = string_replace (_tmp19_, "-", "_");
	_g_free0 (child_name);
	child_name = _tmp20_;
	_tmp21_ = selector;
	if (g_str_has_prefix (_tmp21_, "glib:")) {
		const gchar* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gchar* _tmp25_;
		_tmp22_ = selector;
		_tmp23_ = strlen ("glib:");
		_tmp24_ = _tmp23_;
		_tmp25_ = string_substring (_tmp22_, (glong) _tmp24_, (glong) -1);
		_g_free0 (selector);
		selector = _tmp25_;
	}
	_tmp26_ = self->priv->metadata;
	_tmp27_ = child_name;
	_tmp28_ = selector;
	_tmp29_ = vala_gir_parser_metadata_match_child (_tmp26_, _tmp27_, _tmp28_);
	result = _tmp29_;
	_g_free0 (child_name);
	_g_free0 (selector);
	return result;
}

static gboolean
vala_gir_parser_push_metadata (ValaGirParser* self)
{
	gboolean result = FALSE;
	ValaGirParserMetadata* new_metadata = NULL;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaArrayList* _tmp11_;
	ValaGirParserMetadata* _tmp12_;
	ValaGirParserMetadata* _tmp13_;
	ValaGirParserMetadata* _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_gir_parser_get_current_metadata (self);
	new_metadata = _tmp0_;
	_tmp1_ = new_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP)) {
		ValaGirParserMetadata* _tmp2_;
		_tmp2_ = new_metadata;
		if (vala_gir_parser_metadata_get_bool (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP, FALSE)) {
			result = FALSE;
			_vala_gir_parser_metadata_unref0 (new_metadata);
			return result;
		}
	} else {
		gboolean _tmp3_ = FALSE;
		ValaMarkupReader* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = self->priv->reader;
		_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "introspectable");
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp6_, "0") == 0;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			_tmp3_ = TRUE;
		} else {
			ValaMarkupReader* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = self->priv->reader;
			_tmp9_ = vala_markup_reader_get_attribute (_tmp8_, "private");
			_tmp10_ = _tmp9_;
			_tmp3_ = g_strcmp0 (_tmp10_, "1") == 0;
			_g_free0 (_tmp10_);
		}
		if (_tmp3_) {
			result = FALSE;
			_vala_gir_parser_metadata_unref0 (new_metadata);
			return result;
		}
	}
	_tmp11_ = self->priv->metadata_stack;
	_tmp12_ = self->priv->metadata;
	vala_collection_add ((ValaCollection*) _tmp11_, _tmp12_);
	_tmp13_ = new_metadata;
	_tmp14_ = _vala_gir_parser_metadata_ref0 (_tmp13_);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = _tmp14_;
	result = TRUE;
	_vala_gir_parser_metadata_unref0 (new_metadata);
	return result;
}

static void
vala_gir_parser_pop_metadata (ValaGirParser* self)
{
	ValaArrayList* _tmp0_;
	ValaArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->metadata_stack;
	_tmp1_ = self->priv->metadata_stack;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_list_remove_at ((ValaList*) _tmp0_, _tmp3_ - 1);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = (ValaGirParserMetadata*) _tmp4_;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
vala_gir_parser_parse_type_arguments_from_string (ValaGirParser* self,
                                                  ValaDataType* parent_type,
                                                  const gchar* type_arguments,
                                                  ValaSourceReference* source_reference)
{
	gboolean result = FALSE;
	gint type_arguments_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	GString* current = NULL;
	GString* _tmp2_;
	gint depth = 0;
	ValaDataType* dt = NULL;
	GString* _tmp19_;
	const gchar* _tmp20_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (parent_type != NULL, FALSE);
	g_return_val_if_fail (type_arguments != NULL, FALSE);
	_tmp0_ = strlen (type_arguments);
	_tmp1_ = _tmp0_;
	type_arguments_length = (gint) _tmp1_;
	_tmp2_ = g_string_sized_new ((gsize) type_arguments_length);
	current = _tmp2_;
	depth = 0;
	{
		gint c = 0;
		c = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = c;
					c = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(c < type_arguments_length)) {
					break;
				}
				if (string_get (type_arguments, (glong) c) == '<') {
					_tmp5_ = TRUE;
				} else {
					_tmp5_ = string_get (type_arguments, (glong) c) == '[';
				}
				if (_tmp5_) {
					gint _tmp6_;
					GString* _tmp7_;
					_tmp6_ = depth;
					depth = _tmp6_ + 1;
					_tmp7_ = current;
					g_string_append_unichar (_tmp7_, (gunichar) string_get (type_arguments, (glong) c));
				} else {
					gboolean _tmp8_ = FALSE;
					if (string_get (type_arguments, (glong) c) == '>') {
						_tmp8_ = TRUE;
					} else {
						_tmp8_ = string_get (type_arguments, (glong) c) == ']';
					}
					if (_tmp8_) {
						gint _tmp9_;
						GString* _tmp10_;
						_tmp9_ = depth;
						depth = _tmp9_ - 1;
						_tmp10_ = current;
						g_string_append_unichar (_tmp10_, (gunichar) string_get (type_arguments, (glong) c));
					} else {
						if (string_get (type_arguments, (glong) c) == ',') {
							if (depth == 0) {
								ValaDataType* dt = NULL;
								GString* _tmp11_;
								const gchar* _tmp12_;
								ValaDataType* _tmp13_;
								ValaDataType* _tmp14_;
								ValaDataType* _tmp15_;
								GString* _tmp16_;
								_tmp11_ = current;
								_tmp12_ = _tmp11_->str;
								_tmp13_ = vala_gir_parser_parse_type_from_string (self, _tmp12_, TRUE, source_reference);
								dt = _tmp13_;
								_tmp14_ = dt;
								if (_tmp14_ == NULL) {
									result = FALSE;
									_vala_code_node_unref0 (dt);
									_g_string_free0 (current);
									return result;
								}
								_tmp15_ = dt;
								vala_data_type_add_type_argument (parent_type, _tmp15_);
								_tmp16_ = current;
								g_string_truncate (_tmp16_, (gsize) 0);
								_vala_code_node_unref0 (dt);
							} else {
								GString* _tmp17_;
								_tmp17_ = current;
								g_string_append_unichar (_tmp17_, (gunichar) string_get (type_arguments, (glong) c));
							}
						} else {
							GString* _tmp18_;
							_tmp18_ = current;
							g_string_append_unichar (_tmp18_, (gunichar) string_get (type_arguments, (glong) c));
						}
					}
				}
			}
		}
	}
	_tmp19_ = current;
	_tmp20_ = _tmp19_->str;
	_tmp21_ = vala_gir_parser_parse_type_from_string (self, _tmp20_, TRUE, source_reference);
	dt = _tmp21_;
	_tmp22_ = dt;
	if (_tmp22_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (dt);
		_g_string_free0 (current);
		return result;
	}
	_tmp23_ = dt;
	vala_data_type_add_type_argument (parent_type, _tmp23_);
	result = TRUE;
	_vala_code_node_unref0 (dt);
	_g_string_free0 (current);
	return result;
}

static ValaDataType*
vala_gir_parser_parse_type_from_string (ValaGirParser* self,
                                        const gchar* type_string,
                                        gboolean owned_by_default,
                                        ValaSourceReference* source_reference)
{
	ValaDataType* result = NULL;
	GRegex* _tmp0_;
	GMatchInfo* match = NULL;
	GRegex* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_;
	ValaDataType* type = NULL;
	gchar* ownership_data = NULL;
	GMatchInfo* _tmp8_;
	gchar* _tmp9_;
	gchar* type_name = NULL;
	GMatchInfo* _tmp10_;
	gchar* _tmp11_;
	gchar* type_arguments_data = NULL;
	GMatchInfo* _tmp12_;
	gchar* _tmp13_;
	gchar* pointers_data = NULL;
	GMatchInfo* _tmp14_;
	gchar* _tmp15_;
	gchar* array_data = NULL;
	GMatchInfo* _tmp16_;
	gchar* _tmp17_;
	gchar* nullable_data = NULL;
	GMatchInfo* _tmp18_;
	gchar* _tmp19_;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_;
	gboolean nullable = FALSE;
	gboolean _tmp25_ = FALSE;
	const gchar* _tmp26_;
	gboolean value_owned = FALSE;
	const gchar* _tmp39_;
	ValaUnresolvedSymbol* sym = NULL;
	const gchar* _tmp41_;
	ValaUnresolvedSymbol* _tmp42_;
	ValaUnresolvedSymbol* _tmp43_;
	ValaUnresolvedSymbol* _tmp44_;
	ValaUnresolvedType* _tmp45_;
	gboolean _tmp46_ = FALSE;
	const gchar* _tmp47_;
	const gchar* _tmp53_;
	gboolean _tmp61_ = FALSE;
	const gchar* _tmp62_;
	ValaDataType* _tmp72_;
	ValaDataType* _tmp73_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_string != NULL, NULL);
	_tmp0_ = vala_gir_parser_type_from_string_regex;
	if (_tmp0_ == NULL) {
		{
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp3_;
			_tmp2_ = g_regex_new ("^(?:(owned|unowned|weak) +)?([0-9a-zA-Z_\\.]+)(?:<(.+)>)?(\\*+)?(\\[,*" \
"\\])?(\\?)?$", (G_REGEX_ANCHORED | G_REGEX_DOLLAR_ENDONLY) | G_REGEX_OPTIMIZE, 0, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch10_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (vala_gir_parser_type_from_string_regex);
			vala_gir_parser_type_from_string_regex = _tmp3_;
			_g_regex_unref0 (_tmp1_);
		}
		goto __finally10;
		__catch10_g_regex_error:
		{
			GError* e = NULL;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e->message;
			g_error ("valagirparser.vala:1710: Unable to compile regex: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally10:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = vala_gir_parser_type_from_string_regex;
	_tmp7_ = g_regex_match (_tmp5_, type_string, 0, &_tmp6_);
	_g_match_info_unref0 (match);
	match = _tmp6_;
	if (!_tmp7_) {
		vala_report_error (source_reference, "unable to parse type");
		result = NULL;
		_g_match_info_unref0 (match);
		return result;
	}
	type = NULL;
	_tmp8_ = match;
	_tmp9_ = g_match_info_fetch (_tmp8_, 1);
	ownership_data = _tmp9_;
	_tmp10_ = match;
	_tmp11_ = g_match_info_fetch (_tmp10_, 2);
	type_name = _tmp11_;
	_tmp12_ = match;
	_tmp13_ = g_match_info_fetch (_tmp12_, 3);
	type_arguments_data = _tmp13_;
	_tmp14_ = match;
	_tmp15_ = g_match_info_fetch (_tmp14_, 4);
	pointers_data = _tmp15_;
	_tmp16_ = match;
	_tmp17_ = g_match_info_fetch (_tmp16_, 5);
	array_data = _tmp17_;
	_tmp18_ = match;
	_tmp19_ = g_match_info_fetch (_tmp18_, 6);
	nullable_data = _tmp19_;
	_tmp21_ = nullable_data;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		_tmp22_ = nullable_data;
		_tmp23_ = strlen (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp20_ = _tmp24_ > 0;
	} else {
		_tmp20_ = FALSE;
	}
	nullable = _tmp20_;
	_tmp26_ = ownership_data;
	if (_tmp26_ == NULL) {
		const gchar* _tmp27_;
		_tmp27_ = type_name;
		_tmp25_ = g_strcmp0 (_tmp27_, "void") == 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp29_;
		_tmp29_ = array_data;
		if (_tmp29_ == NULL) {
			_tmp28_ = !nullable;
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaVoidType* _tmp30_;
			const gchar* _tmp31_;
			_tmp30_ = vala_void_type_new (source_reference);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp30_;
			_tmp31_ = pointers_data;
			if (_tmp31_ != NULL) {
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp32_ = FALSE;
						_tmp32_ = TRUE;
						while (TRUE) {
							const gchar* _tmp34_;
							gint _tmp35_;
							gint _tmp36_;
							ValaDataType* _tmp37_;
							ValaPointerType* _tmp38_;
							if (!_tmp32_) {
								gint _tmp33_;
								_tmp33_ = i;
								i = _tmp33_ + 1;
							}
							_tmp32_ = FALSE;
							_tmp34_ = pointers_data;
							_tmp35_ = strlen (_tmp34_);
							_tmp36_ = _tmp35_;
							if (!(i < _tmp36_)) {
								break;
							}
							_tmp37_ = type;
							_tmp38_ = vala_pointer_type_new (_tmp37_, NULL);
							_vala_code_node_unref0 (type);
							type = (ValaDataType*) _tmp38_;
						}
					}
				}
			}
			result = type;
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_g_match_info_unref0 (match);
			return result;
		} else {
			vala_report_error (source_reference, "invalid void type");
			result = NULL;
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	value_owned = owned_by_default;
	_tmp39_ = ownership_data;
	if (g_strcmp0 (_tmp39_, "owned") == 0) {
		if (owned_by_default) {
			vala_report_error (source_reference, "unexpected `owned' keyword");
		} else {
			value_owned = TRUE;
		}
	} else {
		const gchar* _tmp40_;
		_tmp40_ = ownership_data;
		if (g_strcmp0 (_tmp40_, "unowned") == 0) {
			if (owned_by_default) {
				value_owned = FALSE;
			} else {
				vala_report_error (source_reference, "unexpected `unowned' keyword");
				result = NULL;
				_g_free0 (nullable_data);
				_g_free0 (array_data);
				_g_free0 (pointers_data);
				_g_free0 (type_arguments_data);
				_g_free0 (type_name);
				_g_free0 (ownership_data);
				_vala_code_node_unref0 (type);
				_g_match_info_unref0 (match);
				return result;
			}
		}
	}
	_tmp41_ = type_name;
	_tmp42_ = vala_gir_parser_parse_symbol_from_string (self, _tmp41_, source_reference);
	sym = _tmp42_;
	_tmp43_ = sym;
	if (_tmp43_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (sym);
		_g_free0 (nullable_data);
		_g_free0 (array_data);
		_g_free0 (pointers_data);
		_g_free0 (type_arguments_data);
		_g_free0 (type_name);
		_g_free0 (ownership_data);
		_vala_code_node_unref0 (type);
		_g_match_info_unref0 (match);
		return result;
	}
	_tmp44_ = sym;
	_tmp45_ = vala_unresolved_type_new_from_symbol (_tmp44_, source_reference);
	_vala_code_node_unref0 (type);
	type = (ValaDataType*) _tmp45_;
	_tmp47_ = type_arguments_data;
	if (_tmp47_ != NULL) {
		const gchar* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		_tmp48_ = type_arguments_data;
		_tmp49_ = strlen (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp46_ = _tmp50_ > 0;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		ValaDataType* _tmp51_;
		const gchar* _tmp52_;
		_tmp51_ = type;
		_tmp52_ = type_arguments_data;
		if (!vala_gir_parser_parse_type_arguments_from_string (self, _tmp51_, _tmp52_, source_reference)) {
			result = NULL;
			_vala_code_node_unref0 (sym);
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	_tmp53_ = pointers_data;
	if (_tmp53_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp54_ = FALSE;
				_tmp54_ = TRUE;
				while (TRUE) {
					const gchar* _tmp56_;
					gint _tmp57_;
					gint _tmp58_;
					ValaDataType* _tmp59_;
					ValaPointerType* _tmp60_;
					if (!_tmp54_) {
						gint _tmp55_;
						_tmp55_ = i;
						i = _tmp55_ + 1;
					}
					_tmp54_ = FALSE;
					_tmp56_ = pointers_data;
					_tmp57_ = strlen (_tmp56_);
					_tmp58_ = _tmp57_;
					if (!(i < _tmp58_)) {
						break;
					}
					_tmp59_ = type;
					_tmp60_ = vala_pointer_type_new (_tmp59_, NULL);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp60_;
				}
			}
		}
	}
	_tmp62_ = array_data;
	if (_tmp62_ != NULL) {
		const gchar* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		_tmp63_ = array_data;
		_tmp64_ = strlen (_tmp63_);
		_tmp65_ = _tmp64_;
		_tmp61_ = _tmp65_ != 0;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaDataType* _tmp66_;
		ValaDataType* _tmp67_;
		const gchar* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		ValaArrayType* _tmp71_;
		_tmp66_ = type;
		vala_data_type_set_value_owned (_tmp66_, TRUE);
		_tmp67_ = type;
		_tmp68_ = array_data;
		_tmp69_ = strlen (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_array_type_new (_tmp67_, ((gint) _tmp70_) - 1, source_reference);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp71_;
	}
	_tmp72_ = type;
	vala_data_type_set_nullable (_tmp72_, nullable);
	_tmp73_ = type;
	vala_data_type_set_value_owned (_tmp73_, value_owned);
	result = type;
	_vala_code_node_unref0 (sym);
	_g_free0 (nullable_data);
	_g_free0 (array_data);
	_g_free0 (pointers_data);
	_g_free0 (type_arguments_data);
	_g_free0 (type_name);
	_g_free0 (ownership_data);
	_g_match_info_unref0 (match);
	return result;
}

static gchar*
vala_gir_parser_element_get_string (ValaGirParser* self,
                                    const gchar* attribute_name,
                                    ValaGirParserArgumentType arg_type)
{
	gchar* result = NULL;
	ValaGirParserMetadata* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attribute_name != NULL, NULL);
	_tmp0_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp0_, arg_type)) {
		ValaGirParserMetadata* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->metadata;
		_tmp2_ = vala_gir_parser_metadata_get_string (_tmp1_, arg_type);
		result = _tmp2_;
		return result;
	} else {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, attribute_name);
		result = _tmp4_;
		return result;
	}
}

static ValaDataType*
vala_gir_parser_element_get_type (ValaGirParser* self,
                                  ValaDataType* orig_type,
                                  gboolean owned_by_default,
                                  gboolean* no_array_length,
                                  gboolean* array_null_terminated,
                                  gboolean* changed)
{
	gboolean _vala_changed = FALSE;
	ValaDataType* result = NULL;
	ValaDataType* type = NULL;
	ValaDataType* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaDataType* _tmp43_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (orig_type != NULL, NULL);
	_vala_changed = FALSE;
	_tmp0_ = _vala_code_node_ref0 (orig_type);
	type = _tmp0_;
	_tmp1_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE)) {
		ValaGirParserMetadata* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		ValaGirParserMetadata* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaDataType* _tmp8_;
		_tmp2_ = self->priv->metadata;
		_tmp3_ = vala_gir_parser_metadata_get_string (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->metadata;
		_tmp6_ = vala_gir_parser_metadata_get_source_reference (_tmp5_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_gir_parser_parse_type_from_string (self, _tmp4_, owned_by_default, _tmp7_);
		_vala_code_node_unref0 (type);
		type = _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_g_free0 (_tmp4_);
		_vala_changed = TRUE;
	} else {
		ValaDataType* _tmp9_;
		_tmp9_ = type;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_VOID_TYPE)) {
			ValaGirParserMetadata* _tmp10_;
			gboolean _tmp19_ = FALSE;
			ValaDataType* _tmp20_;
			ValaDataType* _tmp38_;
			ValaGirParserMetadata* _tmp39_;
			ValaDataType* _tmp40_;
			gboolean _tmp41_;
			gboolean _tmp42_;
			_tmp10_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp10_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS)) {
				ValaDataType* _tmp11_;
				ValaDataType* _tmp12_;
				ValaGirParserMetadata* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				ValaGirParserMetadata* _tmp16_;
				ValaSourceReference* _tmp17_;
				ValaSourceReference* _tmp18_;
				_tmp11_ = type;
				vala_data_type_remove_all_type_arguments (_tmp11_);
				_tmp12_ = type;
				_tmp13_ = self->priv->metadata;
				_tmp14_ = vala_gir_parser_metadata_get_string (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS);
				_tmp15_ = _tmp14_;
				_tmp16_ = self->priv->metadata;
				_tmp17_ = vala_gir_parser_metadata_get_source_reference (_tmp16_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS);
				_tmp18_ = _tmp17_;
				vala_gir_parser_parse_type_arguments_from_string (self, _tmp12_, _tmp15_, _tmp18_);
				_vala_source_reference_unref0 (_tmp18_);
				_g_free0 (_tmp15_);
			}
			_tmp20_ = type;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_ARRAY_TYPE)) {
				ValaGirParserMetadata* _tmp21_;
				_tmp21_ = self->priv->metadata;
				_tmp19_ = vala_gir_parser_metadata_get_bool (_tmp21_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY, FALSE);
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				ValaDataType* _tmp22_;
				ValaDataType* _tmp23_;
				ValaDataType* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				ValaArrayType* _tmp27_;
				_tmp22_ = type;
				vala_data_type_set_value_owned (_tmp22_, TRUE);
				_tmp23_ = type;
				_tmp24_ = type;
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_array_type_new (_tmp23_, 1, _tmp26_);
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp27_;
				_vala_changed = TRUE;
			}
			if (owned_by_default) {
				ValaDataType* _tmp28_;
				ValaGirParserMetadata* _tmp29_;
				ValaDataType* _tmp30_;
				gboolean _tmp31_;
				gboolean _tmp32_;
				_tmp28_ = type;
				_tmp29_ = self->priv->metadata;
				_tmp30_ = type;
				_tmp31_ = vala_data_type_get_value_owned (_tmp30_);
				_tmp32_ = _tmp31_;
				vala_data_type_set_value_owned (_tmp28_, !vala_gir_parser_metadata_get_bool (_tmp29_, VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED, !_tmp32_));
			} else {
				ValaDataType* _tmp33_;
				ValaGirParserMetadata* _tmp34_;
				ValaDataType* _tmp35_;
				gboolean _tmp36_;
				gboolean _tmp37_;
				_tmp33_ = type;
				_tmp34_ = self->priv->metadata;
				_tmp35_ = type;
				_tmp36_ = vala_data_type_get_value_owned (_tmp35_);
				_tmp37_ = _tmp36_;
				vala_data_type_set_value_owned (_tmp33_, vala_gir_parser_metadata_get_bool (_tmp34_, VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED, _tmp37_));
			}
			_tmp38_ = type;
			_tmp39_ = self->priv->metadata;
			_tmp40_ = type;
			_tmp41_ = vala_data_type_get_nullable (_tmp40_);
			_tmp42_ = _tmp41_;
			vala_data_type_set_nullable (_tmp38_, vala_gir_parser_metadata_get_bool (_tmp39_, VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE, _tmp42_));
		}
	}
	_tmp43_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, VALA_TYPE_ARRAY_TYPE)) {
		ValaGirParserMetadata* _tmp44_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (orig_type, VALA_TYPE_ARRAY_TYPE)) {
			*no_array_length = TRUE;
		}
		_tmp44_ = self->priv->metadata;
		*array_null_terminated = vala_gir_parser_metadata_get_bool (_tmp44_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED, *array_null_terminated);
	}
	result = type;
	if (changed) {
		*changed = _vala_changed;
	}
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
vala_gir_parser_element_get_name (ValaGirParser* self,
                                  const gchar* gir_name)
{
	gchar* result = NULL;
	gchar* name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* pattern = NULL;
	ValaGirParserMetadata* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (gir_name);
	name = _tmp0_;
	_tmp1_ = name;
	if (_tmp1_ == NULL) {
		ValaMarkupReader* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->reader;
		_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "name");
		_g_free0 (name);
		name = _tmp3_;
	}
	_tmp4_ = self->priv->metadata;
	_tmp5_ = vala_gir_parser_metadata_get_string (_tmp4_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	pattern = _tmp5_;
	_tmp6_ = pattern;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = pattern;
		if (string_index_of_char (_tmp7_, (gunichar) '(', 0) < 0) {
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = pattern;
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (name);
			name = _tmp9_;
		} else {
			{
				gchar* replacement = NULL;
				gchar* _tmp10_;
				gchar** split = NULL;
				const gchar* _tmp11_;
				gchar** _tmp12_;
				gchar** _tmp13_;
				gint split_length1;
				gint _split_size_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				GRegex* regex = NULL;
				const gchar* _tmp21_;
				GRegex* _tmp22_;
				gchar* _tmp23_ = NULL;
				GRegex* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				_tmp10_ = g_strdup ("\\1");
				replacement = _tmp10_;
				_tmp11_ = pattern;
				_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, "/", 0);
				split = _tmp13_;
				split_length1 = _vala_array_length (_tmp12_);
				_split_size_ = split_length1;
				_tmp14_ = split;
				_tmp14__length1 = split_length1;
				if (_tmp14__length1 > 1) {
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					gchar** _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp15_ = split;
					_tmp15__length1 = split_length1;
					_tmp16_ = _tmp15_[0];
					_tmp17_ = g_strdup (_tmp16_);
					_g_free0 (pattern);
					pattern = _tmp17_;
					_tmp18_ = split;
					_tmp18__length1 = split_length1;
					_tmp19_ = _tmp18_[1];
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (replacement);
					replacement = _tmp20_;
				}
				_tmp21_ = pattern;
				_tmp22_ = g_regex_new (_tmp21_, G_REGEX_ANCHORED, G_REGEX_MATCH_ANCHORED, &_inner_error0_);
				regex = _tmp22_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (replacement);
					goto __catch11_g_error;
				}
				_tmp24_ = regex;
				_tmp25_ = name;
				_tmp26_ = replacement;
				_tmp27_ = g_regex_replace (_tmp24_, _tmp25_, (gssize) -1, 0, _tmp26_, 0, &_inner_error0_);
				_tmp23_ = _tmp27_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_regex_unref0 (regex);
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (replacement);
					goto __catch11_g_error;
				}
				_tmp28_ = _tmp23_;
				_tmp23_ = NULL;
				_g_free0 (name);
				name = _tmp28_;
				_g_free0 (_tmp23_);
				_g_regex_unref0 (regex);
				split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (replacement);
			}
			goto __finally11;
			__catch11_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp29_ = pattern;
				_tmp30_ = g_strdup (_tmp29_);
				_g_free0 (name);
				name = _tmp30_;
				_g_error_free0 (e);
			}
			__finally11:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (pattern);
				_g_free0 (name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	} else {
		gboolean _tmp31_ = FALSE;
		const gchar* _tmp32_;
		_tmp32_ = name;
		if (_tmp32_ != NULL) {
			const gchar* _tmp33_;
			_tmp33_ = name;
			_tmp31_ = g_str_has_suffix (_tmp33_, "Enum");
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			gchar* _tmp40_;
			_tmp34_ = name;
			_tmp35_ = name;
			_tmp36_ = strlen (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = strlen ("Enum");
			_tmp39_ = _tmp38_;
			_tmp40_ = string_substring (_tmp34_, (glong) 0, (glong) (_tmp37_ - _tmp39_));
			_g_free0 (name);
			name = _tmp40_;
		}
	}
	result = name;
	_g_free0 (pattern);
	return result;
}

static gchar*
vala_gir_parser_element_get_type_id (ValaGirParser* self)
{
	gchar* result = NULL;
	gchar* type_id = NULL;
	ValaGirParserMetadata* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ValaMarkupReader* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->metadata;
	_tmp1_ = vala_gir_parser_metadata_get_string (_tmp0_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID);
	type_id = _tmp1_;
	_tmp2_ = type_id;
	if (_tmp2_ != NULL) {
		result = type_id;
		return result;
	}
	_tmp3_ = self->priv->reader;
	_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:get-type");
	_g_free0 (type_id);
	type_id = _tmp4_;
	_tmp5_ = type_id;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = type_id;
		_tmp7_ = g_strconcat (_tmp6_, " ()", NULL);
		_g_free0 (type_id);
		type_id = _tmp7_;
	}
	result = type_id;
	return result;
}

static void
vala_gir_parser_set_array_ccode (ValaGirParser* self,
                                 ValaSymbol* sym,
                                 ValaGirParserParameterInfo* info)
{
	gchar* type_name = NULL;
	ValaParameter* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (info != NULL);
	vala_code_node_set_attribute_double ((ValaCodeNode*) sym, "CCode", "array_length_pos", (gdouble) info->vala_idx, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PARAMETER)) {
		ValaParameter* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = info->param;
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) _tmp0_);
		_tmp2_ = _tmp1_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "array_length_cname", _tmp2_, NULL);
	}
	_tmp3_ = info->param;
	_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_data_type_to_qualified_string (_tmp5_, NULL);
	type_name = _tmp6_;
	_tmp7_ = type_name;
	if (g_strcmp0 (_tmp7_, "int") != 0) {
		ValaGirParserNode* st = NULL;
		ValaGirParserNode* _tmp8_;
		const gchar* _tmp9_;
		ValaGirParserNode* _tmp10_;
		ValaGirParserNode* _tmp11_;
		_tmp8_ = self->priv->root;
		_tmp9_ = type_name;
		_tmp10_ = vala_gir_parser_node_lookup (_tmp8_, _tmp9_, FALSE, NULL);
		st = _tmp10_;
		_tmp11_ = st;
		if (_tmp11_ != NULL) {
			gboolean _tmp12_ = FALSE;
			if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CALLABLE)) {
				_tmp12_ = TRUE;
			} else {
				_tmp12_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PARAMETER);
			}
			if (_tmp12_) {
				ValaGirParserNode* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp13_ = st;
				_tmp14_ = vala_gir_parser_node_get_cname (_tmp13_);
				_tmp15_ = _tmp14_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "array_length_type", _tmp15_, NULL);
				_g_free0 (_tmp15_);
			}
		}
		_vala_gir_parser_node_unref0 (st);
	}
	_g_free0 (type_name);
}

static void
vala_gir_parser_set_type_id_ccode (ValaGirParser* self,
                                   ValaSymbol* sym)
{
	gboolean _tmp0_ = FALSE;
	gchar* type_id = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) sym, "CCode", "has_type_id")) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) sym, "CCode", "type_id");
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_gir_parser_element_get_type_id (self);
	type_id = _tmp1_;
	_tmp2_ = type_id;
	if (_tmp2_ == NULL) {
		vala_code_node_set_attribute_bool ((ValaCodeNode*) sym, "CCode", "has_type_id", FALSE, NULL);
	} else {
		const gchar* _tmp3_;
		_tmp3_ = type_id;
		vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "type_id", _tmp3_, NULL);
	}
	_g_free0 (type_id);
}

static void
vala_gir_parser_parse_repository (ValaGirParser* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "repository");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "version");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, VALA_GIR_PARSER_GIR_VERSION) != 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMarkupReader* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = vala_gir_parser_get_current_src (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->reader;
		_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "version");
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("unsupported GIR version %s (supported: %s)", _tmp8_, VALA_GIR_PARSER_GIR_VERSION);
		_tmp10_ = _tmp9_;
		vala_report_error (_tmp5_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_vala_source_reference_unref0 (_tmp5_);
		return;
	}
	vala_gir_parser_next (self);
	while (TRUE) {
		ValaMarkupTokenType _tmp11_;
		ValaMarkupReader* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp11_ = self->priv->current_token;
		if (!(_tmp11_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp12_ = self->priv->reader;
		_tmp13_ = vala_markup_reader_get_name (_tmp12_);
		_tmp14_ = _tmp13_;
		if (g_strcmp0 (_tmp14_, "namespace") == 0) {
			vala_gir_parser_parse_namespace (self);
		} else {
			ValaMarkupReader* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp15_ = self->priv->reader;
			_tmp16_ = vala_markup_reader_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			if (g_strcmp0 (_tmp17_, "include") == 0) {
				vala_gir_parser_parse_include (self);
			} else {
				ValaMarkupReader* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				_tmp18_ = self->priv->reader;
				_tmp19_ = vala_markup_reader_get_name (_tmp18_);
				_tmp20_ = _tmp19_;
				if (g_strcmp0 (_tmp20_, "package") == 0) {
					gchar* pkg = NULL;
					gchar* _tmp21_;
					ValaSourceFile* _tmp22_;
					const gchar* _tmp23_;
					ValaCodeContext* _tmp24_;
					const gchar* _tmp25_;
					_tmp21_ = vala_gir_parser_parse_package (self);
					pkg = _tmp21_;
					_tmp22_ = self->priv->current_source_file;
					_tmp23_ = pkg;
					vala_source_file_set_package_name (_tmp22_, _tmp23_);
					_tmp24_ = self->priv->context;
					_tmp25_ = pkg;
					if (vala_code_context_has_package (_tmp24_, _tmp25_)) {
						ValaSourceFile* _tmp26_;
						gboolean _tmp27_;
						gboolean _tmp28_;
						_tmp26_ = self->priv->current_source_file;
						_tmp27_ = vala_source_file_get_from_commandline (_tmp26_);
						_tmp28_ = _tmp27_;
						if (!_tmp28_) {
							_g_free0 (pkg);
							return;
						}
					} else {
						ValaCodeContext* _tmp29_;
						const gchar* _tmp30_;
						_tmp29_ = self->priv->context;
						_tmp30_ = pkg;
						vala_code_context_add_package (_tmp29_, _tmp30_);
					}
					_g_free0 (pkg);
				} else {
					ValaMarkupReader* _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					_tmp31_ = self->priv->reader;
					_tmp32_ = vala_markup_reader_get_name (_tmp31_);
					_tmp33_ = _tmp32_;
					if (g_strcmp0 (_tmp33_, "c:include") == 0) {
						vala_gir_parser_parse_c_include (self);
					} else {
						ValaSourceReference* _tmp34_;
						ValaSourceReference* _tmp35_;
						ValaMarkupReader* _tmp36_;
						const gchar* _tmp37_;
						const gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						_tmp34_ = vala_gir_parser_get_current_src (self);
						_tmp35_ = _tmp34_;
						_tmp36_ = self->priv->reader;
						_tmp37_ = vala_markup_reader_get_name (_tmp36_);
						_tmp38_ = _tmp37_;
						_tmp39_ = g_strdup_printf ("unknown child element `%s' in `repository'", _tmp38_);
						_tmp40_ = _tmp39_;
						vala_report_error (_tmp35_, _tmp40_);
						_g_free0 (_tmp40_);
						_vala_source_reference_unref0 (_tmp35_);
						vala_gir_parser_skip_element (self);
					}
				}
			}
		}
	}
	vala_gir_parser_end_element (self, "repository");
}

static void
vala_gir_parser_parse_include (ValaGirParser* self)
{
	gchar* pkg = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* version = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCodeContext* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "include");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	pkg = _tmp1_;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "version");
	version = _tmp3_;
	_tmp4_ = version;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = pkg;
		_tmp6_ = version;
		_tmp7_ = g_strdup_printf ("%s-%s", _tmp5_, _tmp6_);
		_g_free0 (pkg);
		pkg = _tmp7_;
	}
	_tmp8_ = self->priv->context;
	_tmp9_ = pkg;
	vala_code_context_add_external_package (_tmp8_, _tmp9_);
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "include");
	_g_free0 (version);
	_g_free0 (pkg);
}

static gchar*
vala_gir_parser_parse_package (ValaGirParser* self)
{
	gchar* result = NULL;
	gchar* pkg = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "package");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	pkg = _tmp1_;
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "package");
	result = pkg;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
vala_gir_parser_parse_c_include (ValaGirParser* self)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	ValaMarkupReader* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "c:include");
	_tmp0_ = self->priv->cheader_filenames;
	_tmp0__length1 = self->priv->cheader_filenames_length1;
	_tmp1_ = self->priv->reader;
	_tmp2_ = vala_markup_reader_get_attribute (_tmp1_, "name");
	_vala_array_add1 (&self->priv->cheader_filenames, &self->priv->cheader_filenames_length1, &self->priv->_cheader_filenames_size_, _tmp2_);
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "c:include");
}

static void
vala_gir_parser_skip_element (ValaGirParser* self)
{
	gint level = 0;
	g_return_if_fail (self != NULL);
	vala_gir_parser_next (self);
	level = 1;
	while (TRUE) {
		ValaMarkupTokenType _tmp0_;
		if (!(level > 0)) {
			break;
		}
		_tmp0_ = self->priv->current_token;
		if (_tmp0_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
			gint _tmp1_;
			_tmp1_ = level;
			level = _tmp1_ + 1;
		} else {
			ValaMarkupTokenType _tmp2_;
			_tmp2_ = self->priv->current_token;
			if (_tmp2_ == VALA_MARKUP_TOKEN_TYPE_END_ELEMENT) {
				gint _tmp3_;
				_tmp3_ = level;
				level = _tmp3_ - 1;
			} else {
				ValaMarkupTokenType _tmp4_;
				_tmp4_ = self->priv->current_token;
				if (_tmp4_ == VALA_MARKUP_TOKEN_TYPE_EOF) {
					ValaSourceReference* _tmp5_;
					ValaSourceReference* _tmp6_;
					_tmp5_ = vala_gir_parser_get_current_src (self);
					_tmp6_ = _tmp5_;
					vala_report_error (_tmp6_, "unexpected end of file");
					_vala_source_reference_unref0 (_tmp6_);
					break;
				}
			}
		}
		vala_gir_parser_next (self);
	}
}

static ValaGirParserNode*
vala_gir_parser_resolve_node (ValaGirParser* self,
                              ValaGirParserNode* parent_scope,
                              ValaUnresolvedSymbol* unresolved_sym,
                              gboolean create_namespace)
{
	ValaGirParserNode* result = NULL;
	ValaUnresolvedSymbol* _tmp0_;
	ValaUnresolvedSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent_scope != NULL, NULL);
	g_return_val_if_fail (unresolved_sym != NULL, NULL);
	_tmp0_ = vala_unresolved_symbol_get_inner (unresolved_sym);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		ValaGirParserNode* scope = NULL;
		ValaGirParserNode* _tmp2_;
		_tmp2_ = _vala_gir_parser_node_ref0 (parent_scope);
		scope = _tmp2_;
		while (TRUE) {
			ValaGirParserNode* _tmp3_;
			ValaGirParserNode* node = NULL;
			ValaGirParserNode* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaGirParserNode* _tmp9_;
			ValaGirParserNode* _tmp10_;
			ValaGirParserNode* _tmp11_;
			ValaGirParserNode* _tmp12_;
			ValaGirParserNode* _tmp13_;
			_tmp3_ = scope;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = scope;
			_tmp5_ = vala_symbol_get_name ((ValaSymbol*) unresolved_sym);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_sym);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_gir_parser_node_lookup (_tmp4_, _tmp6_, create_namespace, _tmp8_);
			node = _tmp9_;
			_tmp10_ = node;
			if (_tmp10_ != NULL) {
				result = node;
				_vala_gir_parser_node_unref0 (scope);
				return result;
			}
			_tmp11_ = scope;
			_tmp12_ = _tmp11_->parent;
			_tmp13_ = _vala_gir_parser_node_ref0 (_tmp12_);
			_vala_gir_parser_node_unref0 (scope);
			scope = _tmp13_;
			_vala_gir_parser_node_unref0 (node);
		}
		_vala_gir_parser_node_unref0 (scope);
	} else {
		ValaGirParserNode* inner = NULL;
		ValaUnresolvedSymbol* _tmp14_;
		ValaUnresolvedSymbol* _tmp15_;
		ValaGirParserNode* _tmp16_;
		ValaGirParserNode* _tmp17_;
		_tmp14_ = vala_unresolved_symbol_get_inner (unresolved_sym);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_gir_parser_resolve_node (self, parent_scope, _tmp15_, create_namespace);
		inner = _tmp16_;
		_tmp17_ = inner;
		if (_tmp17_ != NULL) {
			ValaGirParserNode* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaSourceReference* _tmp22_;
			ValaGirParserNode* _tmp23_;
			_tmp18_ = inner;
			_tmp19_ = vala_symbol_get_name ((ValaSymbol*) unresolved_sym);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_sym);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_gir_parser_node_lookup (_tmp18_, _tmp20_, create_namespace, _tmp22_);
			result = _tmp23_;
			_vala_gir_parser_node_unref0 (inner);
			return result;
		}
		_vala_gir_parser_node_unref0 (inner);
	}
	result = NULL;
	return result;
}

static ValaSymbol*
vala_gir_parser_resolve_symbol (ValaGirParser* self,
                                ValaGirParserNode* parent_scope,
                                ValaUnresolvedSymbol* unresolved_sym)
{
	ValaSymbol* result = NULL;
	ValaGirParserNode* node = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent_scope != NULL, NULL);
	g_return_val_if_fail (unresolved_sym != NULL, NULL);
	_tmp0_ = vala_gir_parser_resolve_node (self, parent_scope, unresolved_sym, FALSE);
	node = _tmp0_;
	_tmp1_ = node;
	if (_tmp1_ != NULL) {
		ValaGirParserNode* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp2_ = node;
		_tmp3_ = _tmp2_->symbol;
		_tmp4_ = _vala_code_node_ref0 (_tmp3_);
		result = _tmp4_;
		_vala_gir_parser_node_unref0 (node);
		return result;
	}
	result = NULL;
	_vala_gir_parser_node_unref0 (node);
	return result;
}

static void
vala_gir_parser_push_node (ValaGirParser* self,
                           const gchar* name,
                           gboolean merge)
{
	ValaGirParserNode* parent = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	ValaGirParserNode* node = NULL;
	ValaGirParserNode* _tmp14_;
	ValaGirParserNode* _tmp15_;
	gboolean _tmp16_ = FALSE;
	ValaGirParserNode* _tmp17_;
	ValaGirParserNode* _tmp27_;
	ValaMarkupReader* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	ValaGirParserNode* _tmp32_;
	ValaMarkupReader* _tmp33_;
	ValaMap* _tmp34_;
	ValaGirParserNode* _tmp35_;
	ValaGirParserMetadata* _tmp36_;
	ValaGirParserMetadata* _tmp37_;
	ValaGirParserNode* _tmp38_;
	ValaSourceReference* _tmp39_;
	gchar* gir_name = NULL;
	ValaGirParserNode* _tmp40_;
	gchar* _tmp41_;
	gboolean _tmp42_ = FALSE;
	ValaGirParserNode* _tmp43_;
	ValaGirParserNode* _tmp44_;
	ValaArrayList* _tmp52_;
	ValaGirParserNode* _tmp53_;
	ValaGirParserNode* _tmp54_;
	ValaGirParserNode* _tmp55_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = _vala_gir_parser_node_ref0 (_tmp0_);
	parent = _tmp1_;
	_tmp2_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT)) {
		ValaUnresolvedSymbol* target = NULL;
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		ValaGirParserMetadata* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		ValaUnresolvedSymbol* _tmp10_;
		ValaGirParserNode* _tmp11_;
		ValaUnresolvedSymbol* _tmp12_;
		ValaGirParserNode* _tmp13_;
		_tmp3_ = self->priv->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->metadata;
		_tmp7_ = vala_gir_parser_metadata_get_source_reference (_tmp6_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_gir_parser_parse_symbol_from_string (self, _tmp5_, _tmp8_);
		_tmp10_ = _tmp9_;
		_vala_source_reference_unref0 (_tmp8_);
		_g_free0 (_tmp5_);
		target = _tmp10_;
		_tmp11_ = self->priv->root;
		_tmp12_ = target;
		_tmp13_ = vala_gir_parser_resolve_node (self, _tmp11_, _tmp12_, TRUE);
		_vala_gir_parser_node_unref0 (parent);
		parent = _tmp13_;
		_vala_code_node_unref0 (target);
	}
	_tmp14_ = parent;
	_tmp15_ = vala_gir_parser_node_lookup (_tmp14_, name, FALSE, NULL);
	node = _tmp15_;
	_tmp17_ = node;
	if (_tmp17_ == NULL) {
		_tmp16_ = TRUE;
	} else {
		gboolean _tmp18_ = FALSE;
		ValaGirParserNode* _tmp19_;
		ValaSymbol* _tmp20_;
		_tmp19_ = node;
		_tmp20_ = _tmp19_->symbol;
		if (_tmp20_ != NULL) {
			_tmp18_ = !merge;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp16_ = _tmp18_;
	}
	if (_tmp16_) {
		ValaGirParserNode* _tmp21_;
		ValaGirParserNode* _tmp22_;
		ValaGirParserNode* _tmp23_;
		ValaGirParserNode* _tmp24_;
		_tmp21_ = vala_gir_parser_node_new (name);
		_vala_gir_parser_node_unref0 (node);
		node = _tmp21_;
		_tmp22_ = node;
		_tmp22_->new_symbol = TRUE;
		_tmp23_ = parent;
		_tmp24_ = node;
		vala_gir_parser_node_add_member (_tmp23_, _tmp24_);
	} else {
		ValaArrayList* _tmp25_;
		ValaGirParserNode* _tmp26_;
		_tmp25_ = vala_gir_parser_node_new_namespaces;
		_tmp26_ = node;
		vala_collection_remove ((ValaCollection*) _tmp25_, _tmp26_);
	}
	_tmp27_ = node;
	_tmp28_ = self->priv->reader;
	_tmp29_ = vala_markup_reader_get_name (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strdup (_tmp30_);
	_g_free0 (_tmp27_->element_type);
	_tmp27_->element_type = _tmp31_;
	_tmp32_ = node;
	_tmp33_ = self->priv->reader;
	_tmp34_ = vala_markup_reader_get_attributes (_tmp33_);
	_vala_map_unref0 (_tmp32_->girdata);
	_tmp32_->girdata = _tmp34_;
	_tmp35_ = node;
	_tmp36_ = self->priv->metadata;
	_tmp37_ = _vala_gir_parser_metadata_ref0 (_tmp36_);
	_vala_gir_parser_metadata_unref0 (_tmp35_->metadata);
	_tmp35_->metadata = _tmp37_;
	_tmp38_ = node;
	_tmp39_ = vala_gir_parser_get_current_src (self);
	_vala_source_reference_unref0 (_tmp38_->source_reference);
	_tmp38_->source_reference = _tmp39_;
	_tmp40_ = node;
	_tmp41_ = vala_gir_parser_node_get_gir_name (_tmp40_);
	gir_name = _tmp41_;
	_tmp43_ = parent;
	_tmp44_ = self->priv->current;
	if (_tmp43_ != _tmp44_) {
		_tmp42_ = TRUE;
	} else {
		const gchar* _tmp45_;
		_tmp45_ = gir_name;
		_tmp42_ = g_strcmp0 (_tmp45_, name) != 0;
	}
	if (_tmp42_) {
		const gchar* _tmp46_;
		ValaUnresolvedSymbol* _tmp47_;
		ValaUnresolvedSymbol* _tmp48_;
		ValaGirParserNode* _tmp49_;
		ValaUnresolvedSymbol* _tmp50_;
		ValaUnresolvedSymbol* _tmp51_;
		_tmp46_ = gir_name;
		_tmp47_ = vala_unresolved_symbol_new (NULL, _tmp46_, NULL);
		_tmp48_ = _tmp47_;
		_tmp49_ = node;
		_tmp50_ = vala_gir_parser_node_get_unresolved_symbol (_tmp49_);
		_tmp51_ = _tmp50_;
		vala_gir_parser_set_symbol_mapping (self, _tmp48_, (ValaSymbol*) _tmp51_);
		_vala_code_node_unref0 (_tmp51_);
		_vala_code_node_unref0 (_tmp48_);
	}
	_tmp52_ = self->priv->tree_stack;
	_tmp53_ = self->priv->current;
	vala_collection_add ((ValaCollection*) _tmp52_, _tmp53_);
	_tmp54_ = node;
	_tmp55_ = _vala_gir_parser_node_ref0 (_tmp54_);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = _tmp55_;
	_g_free0 (gir_name);
	_vala_gir_parser_node_unref0 (node);
	_vala_gir_parser_node_unref0 (parent);
}

static void
vala_gir_parser_pop_node (ValaGirParser* self)
{
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaArrayList* _tmp2_;
	ValaArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gpointer _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = _vala_gir_parser_node_ref0 (_tmp0_);
	_vala_gir_parser_node_unref0 (self->priv->old_current);
	self->priv->old_current = _tmp1_;
	_tmp2_ = self->priv->tree_stack;
	_tmp3_ = self->priv->tree_stack;
	_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_list_remove_at ((ValaList*) _tmp2_, _tmp5_ - 1);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = (ValaGirParserNode*) _tmp6_;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
_vala_code_node_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}

static inline void
_g_list_free__vala_code_node_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _vala_code_node_unref0_);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len = len + _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len = len + (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static void
vala_gir_parser_parse_namespace (ValaGirParser* self)
{
	gchar* cprefix = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* lower_case_cprefix = NULL;
	ValaMarkupReader* _tmp6_;
	gchar* _tmp7_;
	gchar* vala_namespace = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* gir_namespace = NULL;
	ValaMarkupReader* _tmp10_;
	gchar* _tmp11_;
	gchar* gir_version = NULL;
	ValaMarkupReader* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	ValaSet* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gboolean _tmp23_;
	gchar* metadata_filename = NULL;
	ValaCodeContext* _tmp24_;
	ValaSourceFile* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gboolean _tmp29_ = FALSE;
	const gchar* _tmp30_;
	ValaGirParserMetadata* ns_metadata = NULL;
	ValaGirParserMetadata* _tmp46_;
	const gchar* _tmp47_;
	ValaGirParserMetadata* _tmp48_;
	ValaGirParserMetadata* _tmp49_;
	const gchar* _tmp52_;
	ValaSourceFile* _tmp55_;
	const gchar* _tmp56_;
	ValaSourceFile* _tmp57_;
	const gchar* _tmp58_;
	ValaNamespace* ns = NULL;
	const gchar* _tmp59_;
	ValaGirParserNode* _tmp60_;
	ValaGirParserNode* _tmp75_;
	ValaGirParserMetadata* _tmp76_;
	ValaGirParserMetadata* _tmp77_;
	ValaGirParserMetadata* _tmp78_;
	ValaGirParserMetadata* _tmp81_;
	ValaNamespace* _tmp87_;
	const gchar* _tmp88_;
	ValaNamespace* _tmp89_;
	const gchar* _tmp90_;
	const gchar* _tmp91_;
	const gchar* _tmp101_;
	gchar** _tmp104_;
	gint _tmp104__length1;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "namespace");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:identifier-prefixes");
	cprefix = _tmp1_;
	_tmp2_ = cprefix;
	if (_tmp2_ != NULL) {
		gint idx = 0;
		const gchar* _tmp3_;
		_tmp3_ = cprefix;
		idx = string_index_of (_tmp3_, ",", 0);
		if (idx != -1) {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = cprefix;
			_tmp5_ = string_substring (_tmp4_, (glong) 0, (glong) idx);
			_g_free0 (cprefix);
			cprefix = _tmp5_;
		}
	}
	_tmp6_ = self->priv->reader;
	_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "c:symbol-prefixes");
	lower_case_cprefix = _tmp7_;
	_tmp8_ = cprefix;
	_tmp9_ = g_strdup (_tmp8_);
	vala_namespace = _tmp9_;
	_tmp10_ = self->priv->reader;
	_tmp11_ = vala_markup_reader_get_attribute (_tmp10_, "name");
	gir_namespace = _tmp11_;
	_tmp12_ = self->priv->reader;
	_tmp13_ = vala_markup_reader_get_attribute (_tmp12_, "version");
	gir_version = _tmp13_;
	_tmp14_ = lower_case_cprefix;
	if (_tmp14_ != NULL) {
		gint idx = 0;
		const gchar* _tmp15_;
		_tmp15_ = lower_case_cprefix;
		idx = string_index_of (_tmp15_, ",", 0);
		if (idx != -1) {
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp16_ = lower_case_cprefix;
			_tmp17_ = string_substring (_tmp16_, (glong) 0, (glong) idx);
			_g_free0 (lower_case_cprefix);
			lower_case_cprefix = _tmp17_;
		}
	}
	_tmp18_ = self->priv->provided_namespaces;
	_tmp19_ = gir_namespace;
	_tmp20_ = gir_version;
	_tmp21_ = g_strdup_printf ("%s-%s", _tmp19_, _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_collection_contains ((ValaCollection*) _tmp18_, _tmp22_);
	_g_free0 (_tmp22_);
	if (_tmp23_) {
		vala_gir_parser_skip_element (self);
		_g_free0 (gir_version);
		_g_free0 (gir_namespace);
		_g_free0 (vala_namespace);
		_g_free0 (lower_case_cprefix);
		_g_free0 (cprefix);
		return;
	}
	_tmp24_ = self->priv->context;
	_tmp25_ = self->priv->current_source_file;
	_tmp26_ = vala_source_file_get_filename (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_code_context_get_metadata_path (_tmp24_, _tmp27_);
	metadata_filename = _tmp28_;
	_tmp30_ = metadata_filename;
	if (_tmp30_ != NULL) {
		const gchar* _tmp31_;
		_tmp31_ = metadata_filename;
		_tmp29_ = g_file_test (_tmp31_, G_FILE_TEST_EXISTS);
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		ValaGirParserMetadataParser* metadata_parser = NULL;
		ValaGirParserMetadataParser* _tmp32_;
		ValaSourceFile* metadata_file = NULL;
		ValaCodeContext* _tmp33_;
		ValaSourceFile* _tmp34_;
		ValaSourceFileType _tmp35_;
		ValaSourceFileType _tmp36_;
		const gchar* _tmp37_;
		ValaSourceFile* _tmp38_;
		ValaCodeContext* _tmp39_;
		ValaSourceFile* _tmp40_;
		ValaGirParserMetadataParser* _tmp41_;
		ValaSourceFile* _tmp42_;
		ValaGirParserMetadata* _tmp43_;
		ValaArrayList* _tmp44_;
		ValaGirParserMetadata* _tmp45_;
		_tmp32_ = vala_gir_parser_metadata_parser_new ();
		metadata_parser = _tmp32_;
		_tmp33_ = self->priv->context;
		_tmp34_ = self->priv->current_source_file;
		_tmp35_ = vala_source_file_get_file_type (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = metadata_filename;
		_tmp38_ = vala_source_file_new (_tmp33_, _tmp36_, _tmp37_, NULL, FALSE);
		metadata_file = _tmp38_;
		_tmp39_ = self->priv->context;
		_tmp40_ = metadata_file;
		vala_code_context_add_source_file (_tmp39_, _tmp40_);
		_tmp41_ = metadata_parser;
		_tmp42_ = metadata_file;
		_tmp43_ = vala_gir_parser_metadata_parser_parse_metadata (_tmp41_, _tmp42_);
		_vala_gir_parser_metadata_unref0 (self->priv->metadata);
		self->priv->metadata = _tmp43_;
		_tmp44_ = self->priv->metadata_roots;
		_tmp45_ = self->priv->metadata;
		vala_collection_add ((ValaCollection*) _tmp44_, _tmp45_);
		_vala_source_file_unref0 (metadata_file);
		_vala_gir_parser_metadata_parser_unref0 (metadata_parser);
	}
	_tmp46_ = self->priv->metadata;
	_tmp47_ = gir_namespace;
	_tmp48_ = vala_gir_parser_metadata_match_child (_tmp46_, _tmp47_, NULL);
	ns_metadata = _tmp48_;
	_tmp49_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp49_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME)) {
		ValaGirParserMetadata* _tmp50_;
		gchar* _tmp51_;
		_tmp50_ = ns_metadata;
		_tmp51_ = vala_gir_parser_metadata_get_string (_tmp50_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
		_g_free0 (vala_namespace);
		vala_namespace = _tmp51_;
	}
	_tmp52_ = vala_namespace;
	if (_tmp52_ == NULL) {
		const gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp53_ = gir_namespace;
		_tmp54_ = g_strdup (_tmp53_);
		_g_free0 (vala_namespace);
		vala_namespace = _tmp54_;
	}
	_tmp55_ = self->priv->current_source_file;
	_tmp56_ = gir_namespace;
	vala_source_file_set_gir_namespace (_tmp55_, _tmp56_);
	_tmp57_ = self->priv->current_source_file;
	_tmp58_ = gir_version;
	vala_source_file_set_gir_version (_tmp57_, _tmp58_);
	_tmp59_ = vala_namespace;
	vala_gir_parser_push_node (self, _tmp59_, TRUE);
	_tmp60_ = self->priv->current;
	if (_tmp60_->new_symbol) {
		const gchar* _tmp61_;
		ValaGirParserNode* _tmp62_;
		ValaSourceReference* _tmp63_;
		ValaNamespace* _tmp64_;
		ValaGirParserNode* _tmp65_;
		ValaNamespace* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp61_ = vala_namespace;
		_tmp62_ = self->priv->current;
		_tmp63_ = _tmp62_->source_reference;
		_tmp64_ = vala_namespace_new (_tmp61_, _tmp63_);
		_vala_code_node_unref0 (ns);
		ns = _tmp64_;
		_tmp65_ = self->priv->current;
		_tmp66_ = ns;
		_tmp67_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp66_);
		_vala_code_node_unref0 (_tmp65_->symbol);
		_tmp65_->symbol = _tmp67_;
	} else {
		ValaGirParserNode* _tmp68_;
		ValaSymbol* _tmp69_;
		ValaNamespace* _tmp70_;
		ValaNamespace* _tmp71_;
		ValaNamespace* _tmp72_;
		ValaGirParserNode* _tmp73_;
		ValaSourceReference* _tmp74_;
		_tmp68_ = self->priv->current;
		_tmp69_ = _tmp68_->symbol;
		_tmp70_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_NAMESPACE, ValaNamespace));
		_vala_code_node_unref0 (ns);
		ns = _tmp70_;
		_tmp71_ = ns;
		(((ValaCodeNode*) _tmp71_)->attributes == NULL) ? NULL : (((ValaCodeNode*) _tmp71_)->attributes = (_g_list_free__vala_code_node_unref0_ (((ValaCodeNode*) _tmp71_)->attributes), NULL));
		((ValaCodeNode*) _tmp71_)->attributes = NULL;
		_tmp72_ = ns;
		_tmp73_ = self->priv->current;
		_tmp74_ = _tmp73_->source_reference;
		vala_code_node_set_source_reference ((ValaCodeNode*) _tmp72_, _tmp74_);
	}
	_tmp75_ = self->priv->current;
	_tmp76_ = ns_metadata;
	_tmp77_ = _vala_gir_parser_metadata_ref0 (_tmp76_);
	_vala_gir_parser_metadata_unref0 (_tmp75_->metadata);
	_tmp75_->metadata = _tmp77_;
	_tmp78_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp78_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
		ValaGirParserMetadata* _tmp79_;
		gchar* _tmp80_;
		_tmp79_ = ns_metadata;
		_tmp80_ = vala_gir_parser_metadata_get_string (_tmp79_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
		_g_free0 (cprefix);
		cprefix = _tmp80_;
	}
	_tmp81_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp81_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX)) {
		ValaGirParserMetadata* _tmp82_;
		gchar* _tmp83_;
		_tmp82_ = ns_metadata;
		_tmp83_ = vala_gir_parser_metadata_get_string (_tmp82_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX);
		_g_free0 (lower_case_cprefix);
		lower_case_cprefix = _tmp83_;
	} else {
		const gchar* _tmp84_;
		_tmp84_ = lower_case_cprefix;
		if (_tmp84_ != NULL) {
			const gchar* _tmp85_;
			gchar* _tmp86_;
			_tmp85_ = lower_case_cprefix;
			_tmp86_ = g_strconcat (_tmp85_, "_", NULL);
			_g_free0 (lower_case_cprefix);
			lower_case_cprefix = _tmp86_;
		}
	}
	_tmp87_ = ns;
	_tmp88_ = gir_namespace;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp87_, "CCode", "gir_namespace", _tmp88_, NULL);
	_tmp89_ = ns;
	_tmp90_ = gir_version;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp89_, "CCode", "gir_version", _tmp90_, NULL);
	_tmp91_ = cprefix;
	if (_tmp91_ != NULL) {
		ValaNamespace* _tmp92_;
		const gchar* _tmp93_;
		const gchar* _tmp94_;
		_tmp92_ = ns;
		_tmp93_ = cprefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp92_, "CCode", "cprefix", _tmp93_, NULL);
		_tmp94_ = lower_case_cprefix;
		if (_tmp94_ == NULL) {
			ValaNamespace* _tmp95_;
			const gchar* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			_tmp95_ = ns;
			_tmp96_ = cprefix;
			_tmp97_ = vala_symbol_camel_case_to_lower_case (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = g_strconcat (_tmp98_, "_", NULL);
			_tmp100_ = _tmp99_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp95_, "CCode", "lower_case_cprefix", _tmp100_, NULL);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp98_);
		}
	}
	_tmp101_ = lower_case_cprefix;
	if (_tmp101_ != NULL) {
		ValaNamespace* _tmp102_;
		const gchar* _tmp103_;
		_tmp102_ = ns;
		_tmp103_ = lower_case_cprefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp102_, "CCode", "lower_case_cprefix", _tmp103_, NULL);
	}
	_tmp104_ = self->priv->cheader_filenames;
	_tmp104__length1 = self->priv->cheader_filenames_length1;
	if (_tmp104_ != NULL) {
		ValaNamespace* _tmp105_;
		gchar** _tmp106_;
		gint _tmp106__length1;
		gchar* _tmp107_;
		gchar* _tmp108_;
		_tmp105_ = ns;
		_tmp106_ = self->priv->cheader_filenames;
		_tmp106__length1 = self->priv->cheader_filenames_length1;
		_tmp107_ = _vala_g_strjoinv (",", _tmp106_, (gint) _tmp106__length1);
		_tmp108_ = _tmp107_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp105_, "CCode", "cheader_filename", _tmp108_, NULL);
		_g_free0 (_tmp108_);
	}
	vala_gir_parser_next (self);
	while (TRUE) {
		ValaMarkupTokenType _tmp109_;
		ValaMarkupReader* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		_tmp109_ = self->priv->current_token;
		if (!(_tmp109_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp110_ = self->priv->reader;
		_tmp111_ = vala_markup_reader_get_name (_tmp110_);
		_tmp112_ = _tmp111_;
		if (g_strcmp0 (_tmp112_, "alias") == 0) {
			vala_gir_parser_parse_alias (self);
		} else {
			ValaMarkupReader* _tmp113_;
			const gchar* _tmp114_;
			const gchar* _tmp115_;
			_tmp113_ = self->priv->reader;
			_tmp114_ = vala_markup_reader_get_name (_tmp113_);
			_tmp115_ = _tmp114_;
			if (g_strcmp0 (_tmp115_, "enumeration") == 0) {
				ValaGirParserMetadata* _tmp116_;
				_tmp116_ = self->priv->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp116_, VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN)) {
					ValaGirParserMetadata* _tmp117_;
					_tmp117_ = self->priv->metadata;
					if (vala_gir_parser_metadata_get_bool (_tmp117_, VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN, FALSE)) {
						vala_gir_parser_parse_error_domain (self);
					} else {
						vala_gir_parser_parse_enumeration (self, "enumeration", FALSE);
					}
				} else {
					gboolean _tmp118_ = FALSE;
					ValaMarkupReader* _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					gboolean _tmp122_;
					_tmp119_ = self->priv->reader;
					_tmp120_ = vala_markup_reader_get_attribute (_tmp119_, "glib:error-quark");
					_tmp121_ = _tmp120_;
					_tmp122_ = _tmp121_ != NULL;
					_g_free0 (_tmp121_);
					if (_tmp122_) {
						_tmp118_ = TRUE;
					} else {
						ValaMarkupReader* _tmp123_;
						gchar* _tmp124_;
						gchar* _tmp125_;
						_tmp123_ = self->priv->reader;
						_tmp124_ = vala_markup_reader_get_attribute (_tmp123_, "glib:error-domain");
						_tmp125_ = _tmp124_;
						_tmp118_ = _tmp125_ != NULL;
						_g_free0 (_tmp125_);
					}
					if (_tmp118_) {
						vala_gir_parser_parse_error_domain (self);
					} else {
						vala_gir_parser_parse_enumeration (self, "enumeration", FALSE);
					}
				}
			} else {
				ValaMarkupReader* _tmp126_;
				const gchar* _tmp127_;
				const gchar* _tmp128_;
				_tmp126_ = self->priv->reader;
				_tmp127_ = vala_markup_reader_get_name (_tmp126_);
				_tmp128_ = _tmp127_;
				if (g_strcmp0 (_tmp128_, "bitfield") == 0) {
					vala_gir_parser_parse_bitfield (self);
				} else {
					ValaMarkupReader* _tmp129_;
					const gchar* _tmp130_;
					const gchar* _tmp131_;
					_tmp129_ = self->priv->reader;
					_tmp130_ = vala_markup_reader_get_name (_tmp129_);
					_tmp131_ = _tmp130_;
					if (g_strcmp0 (_tmp131_, "function") == 0) {
						vala_gir_parser_parse_method (self, "function");
					} else {
						ValaMarkupReader* _tmp132_;
						const gchar* _tmp133_;
						const gchar* _tmp134_;
						_tmp132_ = self->priv->reader;
						_tmp133_ = vala_markup_reader_get_name (_tmp132_);
						_tmp134_ = _tmp133_;
						if (g_strcmp0 (_tmp134_, "callback") == 0) {
							vala_gir_parser_parse_callback (self);
						} else {
							ValaMarkupReader* _tmp135_;
							const gchar* _tmp136_;
							const gchar* _tmp137_;
							_tmp135_ = self->priv->reader;
							_tmp136_ = vala_markup_reader_get_name (_tmp135_);
							_tmp137_ = _tmp136_;
							if (g_strcmp0 (_tmp137_, "record") == 0) {
								ValaGirParserMetadata* _tmp138_;
								_tmp138_ = self->priv->metadata;
								if (vala_gir_parser_metadata_has_argument (_tmp138_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT)) {
									ValaGirParserMetadata* _tmp139_;
									_tmp139_ = self->priv->metadata;
									if (vala_gir_parser_metadata_get_bool (_tmp139_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, FALSE)) {
										vala_gir_parser_parse_record (self);
									} else {
										vala_gir_parser_parse_boxed (self, "record");
									}
								} else {
									gchar* _tmp140_;
									gchar* _tmp141_;
									gboolean _tmp142_;
									_tmp140_ = vala_gir_parser_element_get_type_id (self);
									_tmp141_ = _tmp140_;
									_tmp142_ = _tmp141_ != NULL;
									_g_free0 (_tmp141_);
									if (_tmp142_) {
										vala_gir_parser_parse_boxed (self, "record");
									} else {
										ValaMarkupReader* _tmp143_;
										gchar* _tmp144_;
										gchar* _tmp145_;
										gboolean _tmp146_;
										_tmp143_ = self->priv->reader;
										_tmp144_ = vala_markup_reader_get_attribute (_tmp143_, "name");
										_tmp145_ = _tmp144_;
										_tmp146_ = !g_str_has_suffix (_tmp145_, "Private");
										_g_free0 (_tmp145_);
										if (_tmp146_) {
											gboolean _tmp147_ = FALSE;
											ValaMarkupReader* _tmp148_;
											gchar* _tmp149_;
											gchar* _tmp150_;
											gboolean _tmp151_;
											_tmp148_ = self->priv->reader;
											_tmp149_ = vala_markup_reader_get_attribute (_tmp148_, "glib:is-gtype-struct-for");
											_tmp150_ = _tmp149_;
											_tmp151_ = _tmp150_ == NULL;
											_g_free0 (_tmp150_);
											if (_tmp151_) {
												ValaMarkupReader* _tmp152_;
												gchar* _tmp153_;
												gchar* _tmp154_;
												_tmp152_ = self->priv->reader;
												_tmp153_ = vala_markup_reader_get_attribute (_tmp152_, "disguised");
												_tmp154_ = _tmp153_;
												_tmp147_ = g_strcmp0 (_tmp154_, "1") == 0;
												_g_free0 (_tmp154_);
											} else {
												_tmp147_ = FALSE;
											}
											if (_tmp147_) {
												vala_gir_parser_parse_boxed (self, "record");
											} else {
												vala_gir_parser_parse_record (self);
											}
										} else {
											vala_gir_parser_skip_element (self);
										}
									}
								}
							} else {
								ValaMarkupReader* _tmp155_;
								const gchar* _tmp156_;
								const gchar* _tmp157_;
								_tmp155_ = self->priv->reader;
								_tmp156_ = vala_markup_reader_get_name (_tmp155_);
								_tmp157_ = _tmp156_;
								if (g_strcmp0 (_tmp157_, "class") == 0) {
									vala_gir_parser_parse_class (self);
								} else {
									ValaMarkupReader* _tmp158_;
									const gchar* _tmp159_;
									const gchar* _tmp160_;
									_tmp158_ = self->priv->reader;
									_tmp159_ = vala_markup_reader_get_name (_tmp158_);
									_tmp160_ = _tmp159_;
									if (g_strcmp0 (_tmp160_, "interface") == 0) {
										vala_gir_parser_parse_interface (self);
									} else {
										ValaMarkupReader* _tmp161_;
										const gchar* _tmp162_;
										const gchar* _tmp163_;
										_tmp161_ = self->priv->reader;
										_tmp162_ = vala_markup_reader_get_name (_tmp161_);
										_tmp163_ = _tmp162_;
										if (g_strcmp0 (_tmp163_, "glib:boxed") == 0) {
											vala_gir_parser_parse_boxed (self, "glib:boxed");
										} else {
											ValaMarkupReader* _tmp164_;
											const gchar* _tmp165_;
											const gchar* _tmp166_;
											_tmp164_ = self->priv->reader;
											_tmp165_ = vala_markup_reader_get_name (_tmp164_);
											_tmp166_ = _tmp165_;
											if (g_strcmp0 (_tmp166_, "union") == 0) {
												gboolean _tmp167_ = FALSE;
												gchar* _tmp168_;
												gchar* _tmp169_;
												gboolean _tmp170_;
												_tmp168_ = vala_gir_parser_element_get_type_id (self);
												_tmp169_ = _tmp168_;
												_tmp170_ = _tmp169_ != NULL;
												_g_free0 (_tmp169_);
												if (_tmp170_) {
													ValaGirParserMetadata* _tmp171_;
													_tmp171_ = self->priv->metadata;
													_tmp167_ = !vala_gir_parser_metadata_get_bool (_tmp171_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, FALSE);
												} else {
													_tmp167_ = FALSE;
												}
												if (_tmp167_) {
													vala_gir_parser_parse_boxed (self, "union");
												} else {
													vala_gir_parser_parse_union (self);
												}
											} else {
												ValaMarkupReader* _tmp172_;
												const gchar* _tmp173_;
												const gchar* _tmp174_;
												_tmp172_ = self->priv->reader;
												_tmp173_ = vala_markup_reader_get_name (_tmp172_);
												_tmp174_ = _tmp173_;
												if (g_strcmp0 (_tmp174_, "constant") == 0) {
													vala_gir_parser_parse_constant (self);
												} else {
													ValaSourceReference* _tmp175_;
													ValaSourceReference* _tmp176_;
													ValaMarkupReader* _tmp177_;
													const gchar* _tmp178_;
													const gchar* _tmp179_;
													gchar* _tmp180_;
													gchar* _tmp181_;
													_tmp175_ = vala_gir_parser_get_current_src (self);
													_tmp176_ = _tmp175_;
													_tmp177_ = self->priv->reader;
													_tmp178_ = vala_markup_reader_get_name (_tmp177_);
													_tmp179_ = _tmp178_;
													_tmp180_ = g_strdup_printf ("unknown child element `%s' in `namespace'", _tmp179_);
													_tmp181_ = _tmp180_;
													vala_report_error (_tmp176_, _tmp181_);
													_g_free0 (_tmp181_);
													_vala_source_reference_unref0 (_tmp176_);
													vala_gir_parser_skip_element (self);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "namespace");
	_vala_code_node_unref0 (ns);
	_vala_gir_parser_metadata_unref0 (ns_metadata);
	_g_free0 (metadata_filename);
	_g_free0 (gir_version);
	_g_free0 (gir_namespace);
	_g_free0 (vala_namespace);
	_g_free0 (lower_case_cprefix);
	_g_free0 (cprefix);
}

static void
vala_gir_parser_parse_alias (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaGirParserNode* _tmp2_;
	ValaGirComment* _tmp3_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	ValaGirParserNode* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaGirParserMetadata* _tmp12_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "alias");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	vala_gir_parser_next (self);
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->comment;
	if (_tmp3_ == NULL) {
		ValaGirParserNode* _tmp4_;
		ValaGirComment* _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = vala_gir_parser_parse_symbol_doc (self);
		_vala_comment_unref0 (_tmp4_->comment);
		_tmp4_->comment = _tmp5_;
	} else {
		ValaGirComment* _tmp6_;
		ValaGirComment* _tmp7_;
		_tmp6_ = vala_gir_parser_parse_symbol_doc (self);
		_tmp7_ = _tmp6_;
		_vala_comment_unref0 (_tmp7_);
	}
	no_array_length = FALSE;
	array_null_terminated = FALSE;
	_tmp8_ = self->priv->current;
	_tmp9_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_gir_parser_element_get_type (self, _tmp10_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (_tmp8_->base_type);
	_tmp8_->base_type = _tmp11_;
	_vala_code_node_unref0 (_tmp10_);
	_tmp12_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE)) {
		ValaGirParserNode* _tmp13_;
		ValaGirParserMetadata* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		ValaGirParserMetadata* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaDataType* _tmp20_;
		_tmp13_ = self->priv->current;
		_tmp14_ = self->priv->metadata;
		_tmp15_ = vala_gir_parser_metadata_get_string (_tmp14_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->metadata;
		_tmp18_ = vala_gir_parser_metadata_get_source_reference (_tmp17_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_gir_parser_parse_type_from_string (self, _tmp16_, TRUE, _tmp19_);
		_vala_code_node_unref0 (_tmp13_->base_type);
		_tmp13_->base_type = _tmp20_;
		_vala_source_reference_unref0 (_tmp19_);
		_g_free0 (_tmp16_);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "alias");
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static void
vala_gir_parser_calculate_common_prefix (ValaGirParser* self,
                                         gchar* * common_prefix,
                                         const gchar* cname)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	if ((*common_prefix) == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (cname);
		_g_free0 (*common_prefix);
		*common_prefix = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			gint _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gchar* _tmp6_;
			_tmp2_ = strlen (*common_prefix);
			_tmp3_ = _tmp2_;
			if (_tmp3_ > 0) {
				_tmp1_ = !g_str_has_suffix (*common_prefix, "_");
			} else {
				_tmp1_ = FALSE;
			}
			if (!_tmp1_) {
				break;
			}
			_tmp4_ = strlen (*common_prefix);
			_tmp5_ = _tmp4_;
			_tmp6_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp5_ - 1));
			_g_free0 (*common_prefix);
			*common_prefix = _tmp6_;
		}
	} else {
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gchar* _tmp9_;
			if (!(!g_str_has_prefix (cname, *common_prefix))) {
				break;
			}
			_tmp7_ = strlen (*common_prefix);
			_tmp8_ = _tmp7_;
			_tmp9_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp8_ - 1));
			_g_free0 (*common_prefix);
			*common_prefix = _tmp9_;
		}
	}
	while (TRUE) {
		gboolean _tmp10_ = FALSE;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_;
		_tmp11_ = strlen (*common_prefix);
		_tmp12_ = _tmp11_;
		if (_tmp12_ > 0) {
			gboolean _tmp13_ = FALSE;
			if (!g_str_has_suffix (*common_prefix, "_")) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp14_ = FALSE;
				gint _tmp15_;
				gint _tmp16_;
				_tmp15_ = strlen (*common_prefix);
				_tmp16_ = _tmp15_;
				if (g_unichar_isdigit (string_get_char (cname, (glong) _tmp16_))) {
					gint _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					_tmp17_ = strlen (cname);
					_tmp18_ = _tmp17_;
					_tmp19_ = strlen (*common_prefix);
					_tmp20_ = _tmp19_;
					_tmp14_ = (_tmp18_ - _tmp20_) <= 1;
				} else {
					_tmp14_ = FALSE;
				}
				_tmp13_ = _tmp14_;
			}
			_tmp10_ = _tmp13_;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			break;
		}
		_tmp21_ = strlen (*common_prefix);
		_tmp22_ = _tmp21_;
		_tmp23_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp22_ - 1));
		_g_free0 (*common_prefix);
		*common_prefix = _tmp23_;
	}
}

static ValaGirComment*
vala_gir_parser_parse_symbol_doc (ValaGirParser* self)
{
	ValaGirComment* result = NULL;
	ValaGirComment* comment = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	comment = NULL;
	while (TRUE) {
		ValaMarkupTokenType _tmp0_;
		const gchar* reader_name = NULL;
		ValaMarkupReader* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp0_ = self->priv->current_token;
		if (!(_tmp0_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp1_ = self->priv->reader;
		_tmp2_ = vala_markup_reader_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		reader_name = _tmp3_;
		_tmp4_ = reader_name;
		if (g_strcmp0 (_tmp4_, "doc") == 0) {
			ValaMarkupTokenType _tmp5_;
			vala_gir_parser_start_element (self, "doc");
			vala_gir_parser_next (self);
			_tmp5_ = self->priv->current_token;
			if (_tmp5_ == VALA_MARKUP_TOKEN_TYPE_TEXT) {
				ValaMarkupReader* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				ValaGirParserNode* _tmp9_;
				ValaSourceReference* _tmp10_;
				ValaGirComment* _tmp11_;
				_tmp6_ = self->priv->reader;
				_tmp7_ = vala_markup_reader_get_content (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = self->priv->current;
				_tmp10_ = _tmp9_->source_reference;
				_tmp11_ = vala_gir_comment_new (_tmp8_, _tmp10_);
				_vala_comment_unref0 (comment);
				comment = _tmp11_;
				vala_gir_parser_next (self);
			}
			vala_gir_parser_end_element (self, "doc");
		} else {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_;
			_tmp14_ = reader_name;
			if (g_strcmp0 (_tmp14_, "doc-version") == 0) {
				_tmp13_ = TRUE;
			} else {
				const gchar* _tmp15_;
				_tmp15_ = reader_name;
				_tmp13_ = g_strcmp0 (_tmp15_, "doc-deprecated") == 0;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				const gchar* _tmp16_;
				_tmp16_ = reader_name;
				_tmp12_ = g_strcmp0 (_tmp16_, "doc-stability") == 0;
			}
			if (_tmp12_) {
				vala_gir_parser_skip_element (self);
			} else {
				const gchar* _tmp17_;
				_tmp17_ = reader_name;
				if (g_strcmp0 (_tmp17_, "source-position") == 0) {
					vala_gir_parser_skip_element (self);
				} else {
					break;
				}
			}
		}
	}
	result = comment;
	return result;
}

static ValaComment*
vala_gir_parser_parse_doc (ValaGirParser* self)
{
	ValaComment* result = NULL;
	ValaComment* comment = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	comment = NULL;
	while (TRUE) {
		ValaMarkupTokenType _tmp0_;
		const gchar* reader_name = NULL;
		ValaMarkupReader* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp0_ = self->priv->current_token;
		if (!(_tmp0_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp1_ = self->priv->reader;
		_tmp2_ = vala_markup_reader_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		reader_name = _tmp3_;
		_tmp4_ = reader_name;
		if (g_strcmp0 (_tmp4_, "doc") == 0) {
			ValaMarkupTokenType _tmp5_;
			vala_gir_parser_start_element (self, "doc");
			vala_gir_parser_next (self);
			_tmp5_ = self->priv->current_token;
			if (_tmp5_ == VALA_MARKUP_TOKEN_TYPE_TEXT) {
				ValaMarkupReader* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				ValaGirParserNode* _tmp9_;
				ValaSourceReference* _tmp10_;
				ValaComment* _tmp11_;
				_tmp6_ = self->priv->reader;
				_tmp7_ = vala_markup_reader_get_content (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = self->priv->current;
				_tmp10_ = _tmp9_->source_reference;
				_tmp11_ = vala_comment_new (_tmp8_, _tmp10_);
				_vala_comment_unref0 (comment);
				comment = _tmp11_;
				vala_gir_parser_next (self);
			}
			vala_gir_parser_end_element (self, "doc");
		} else {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_;
			_tmp14_ = reader_name;
			if (g_strcmp0 (_tmp14_, "doc-version") == 0) {
				_tmp13_ = TRUE;
			} else {
				const gchar* _tmp15_;
				_tmp15_ = reader_name;
				_tmp13_ = g_strcmp0 (_tmp15_, "doc-deprecated") == 0;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				const gchar* _tmp16_;
				_tmp16_ = reader_name;
				_tmp12_ = g_strcmp0 (_tmp16_, "doc-stability") == 0;
			}
			if (_tmp12_) {
				vala_gir_parser_skip_element (self);
			} else {
				const gchar* _tmp17_;
				_tmp17_ = reader_name;
				if (g_strcmp0 (_tmp17_, "source-position") == 0) {
					vala_gir_parser_skip_element (self);
				} else {
					break;
				}
			}
		}
	}
	result = comment;
	return result;
}

static void
vala_gir_parser_parse_enumeration (ValaGirParser* self,
                                   const gchar* element_name,
                                   gboolean error_domain)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaSymbol* sym = NULL;
	ValaGirParserNode* _tmp2_;
	ValaSymbol* _tmp23_;
	ValaSymbol* _tmp24_;
	gchar* common_prefix = NULL;
	gboolean has_member = FALSE;
	ValaSymbol* _tmp25_;
	ValaGirComment* _tmp26_;
	ValaGirComment* _tmp27_;
	const gchar* _tmp54_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->current;
	if (_tmp2_->new_symbol) {
		ValaGirParserNode* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		if (error_domain) {
			ValaGirParserNode* _tmp3_;
			const gchar* _tmp4_;
			ValaGirParserNode* _tmp5_;
			ValaSourceReference* _tmp6_;
			ValaErrorDomain* _tmp7_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_->name;
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_->source_reference;
			_tmp7_ = vala_error_domain_new (_tmp4_, _tmp6_, NULL);
			_vala_code_node_unref0 (sym);
			sym = (ValaSymbol*) _tmp7_;
		} else {
			ValaEnum* en = NULL;
			ValaGirParserNode* _tmp8_;
			const gchar* _tmp9_;
			ValaGirParserNode* _tmp10_;
			ValaSourceReference* _tmp11_;
			ValaEnum* _tmp12_;
			ValaEnum* _tmp14_;
			ValaSymbol* _tmp15_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_->name;
			_tmp10_ = self->priv->current;
			_tmp11_ = _tmp10_->source_reference;
			_tmp12_ = vala_enum_new (_tmp9_, _tmp11_, NULL);
			en = _tmp12_;
			if (g_strcmp0 (element_name, "bitfield") == 0) {
				ValaEnum* _tmp13_;
				_tmp13_ = en;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp13_, "Flags", TRUE, NULL);
			}
			_tmp14_ = en;
			_tmp15_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp14_);
			_vala_code_node_unref0 (sym);
			sym = _tmp15_;
			_vala_code_node_unref0 (en);
		}
		_tmp16_ = self->priv->current;
		_tmp17_ = sym;
		_tmp18_ = _vala_code_node_ref0 (_tmp17_);
		_vala_code_node_unref0 (_tmp16_->symbol);
		_tmp16_->symbol = _tmp18_;
	} else {
		ValaGirParserNode* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		_tmp19_ = self->priv->current;
		_tmp20_ = _tmp19_->symbol;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (sym);
		sym = _tmp21_;
	}
	if (!error_domain) {
		ValaSymbol* _tmp22_;
		_tmp22_ = sym;
		vala_gir_parser_set_type_id_ccode (self, _tmp22_);
	}
	_tmp23_ = sym;
	vala_symbol_set_external (_tmp23_, TRUE);
	_tmp24_ = sym;
	vala_symbol_set_access (_tmp24_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	common_prefix = NULL;
	has_member = FALSE;
	vala_gir_parser_next (self);
	_tmp25_ = sym;
	_tmp26_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp27_ = _tmp26_;
	vala_symbol_set_comment (_tmp25_, (ValaComment*) _tmp27_);
	_vala_comment_unref0 (_tmp27_);
	while (TRUE) {
		ValaMarkupTokenType _tmp28_;
		ValaMarkupReader* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		_tmp28_ = self->priv->current_token;
		if (!(_tmp28_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp29_ = self->priv->reader;
		_tmp30_ = vala_markup_reader_get_name (_tmp29_);
		_tmp31_ = _tmp30_;
		if (g_strcmp0 (_tmp31_, "member") == 0) {
			has_member = TRUE;
			if (error_domain) {
				ValaGirParserNode* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				vala_gir_parser_parse_error_member (self);
				_tmp32_ = self->priv->old_current;
				_tmp33_ = vala_gir_parser_node_get_cname (_tmp32_);
				_tmp34_ = _tmp33_;
				vala_gir_parser_calculate_common_prefix (self, &common_prefix, _tmp34_);
				_g_free0 (_tmp34_);
			} else {
				ValaGirParserNode* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				vala_gir_parser_parse_enumeration_member (self);
				_tmp35_ = self->priv->old_current;
				_tmp36_ = vala_gir_parser_node_get_cname (_tmp35_);
				_tmp37_ = _tmp36_;
				vala_gir_parser_calculate_common_prefix (self, &common_prefix, _tmp37_);
				_g_free0 (_tmp37_);
			}
		} else {
			ValaMarkupReader* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			_tmp38_ = self->priv->reader;
			_tmp39_ = vala_markup_reader_get_name (_tmp38_);
			_tmp40_ = _tmp39_;
			if (g_strcmp0 (_tmp40_, "function") == 0) {
				vala_gir_parser_skip_element (self);
			} else {
				ValaSourceReference* _tmp41_;
				ValaSourceReference* _tmp42_;
				ValaMarkupReader* _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				_tmp41_ = vala_gir_parser_get_current_src (self);
				_tmp42_ = _tmp41_;
				_tmp43_ = self->priv->reader;
				_tmp44_ = vala_markup_reader_get_name (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = g_strdup_printf ("unknown child element `%s' in `%s'", _tmp45_, element_name);
				_tmp47_ = _tmp46_;
				vala_report_error (_tmp42_, _tmp47_);
				_g_free0 (_tmp47_);
				_vala_source_reference_unref0 (_tmp42_);
				vala_gir_parser_skip_element (self);
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	if (!has_member) {
		ValaSourceReference* _tmp48_;
		ValaSourceReference* _tmp49_;
		ValaGirParserNode* _tmp50_;
		const gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		_tmp48_ = vala_gir_parser_get_current_src (self);
		_tmp49_ = _tmp48_;
		_tmp50_ = self->priv->current;
		_tmp51_ = _tmp50_->name;
		_tmp52_ = g_strdup_printf ("%s `%s' has no members", element_name, _tmp51_);
		_tmp53_ = _tmp52_;
		vala_report_error (_tmp49_, _tmp53_);
		_g_free0 (_tmp53_);
		_vala_source_reference_unref0 (_tmp49_);
	}
	_tmp54_ = common_prefix;
	if (_tmp54_ != NULL) {
		ValaSymbol* _tmp55_;
		const gchar* _tmp56_;
		_tmp55_ = sym;
		_tmp56_ = common_prefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp55_, "CCode", "cprefix", _tmp56_, NULL);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_g_free0 (common_prefix);
	_vala_code_node_unref0 (sym);
}

static void
vala_gir_parser_parse_error_domain (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_enumeration (self, "enumeration", TRUE);
}

static void
vala_gir_parser_parse_bitfield (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_enumeration (self, "bitfield", FALSE);
}

static void
vala_gir_parser_parse_enumeration_member (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaEnumValue* ev = NULL;
	ValaGirParserNode* _tmp6_;
	const gchar* _tmp7_;
	ValaGirParserMetadata* _tmp8_;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaGirParserNode* _tmp11_;
	ValaSourceReference* _tmp12_;
	ValaEnumValue* _tmp13_;
	ValaEnumValue* _tmp14_;
	ValaGirParserNode* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaGirComment* _tmp17_;
	ValaGirComment* _tmp18_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "member");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_ascii_strup (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "-", "_");
	_tmp5_ = _tmp4_;
	vala_gir_parser_push_node (self, _tmp5_, FALSE);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = self->priv->current;
	_tmp7_ = _tmp6_->name;
	_tmp8_ = self->priv->metadata;
	_tmp9_ = vala_gir_parser_metadata_get_expression (_tmp8_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->current;
	_tmp12_ = _tmp11_->source_reference;
	_tmp13_ = vala_enum_value_new (_tmp7_, _tmp10_, _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_vala_code_node_unref0 (_tmp10_);
	ev = _tmp14_;
	_tmp15_ = self->priv->current;
	_tmp16_ = _vala_code_node_ref0 ((ValaSymbol*) ev);
	_vala_code_node_unref0 (_tmp15_->symbol);
	_tmp15_->symbol = _tmp16_;
	vala_gir_parser_next (self);
	_tmp17_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp18_ = _tmp17_;
	vala_symbol_set_comment ((ValaSymbol*) ev, (ValaComment*) _tmp18_);
	_vala_comment_unref0 (_tmp18_);
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "member");
	_vala_code_node_unref0 (ev);
}

static void
vala_gir_parser_parse_error_member (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaErrorCode* ec = NULL;
	gchar* value = NULL;
	ValaMarkupReader* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	ValaGirParserNode* _tmp18_;
	ValaErrorCode* _tmp19_;
	ValaSymbol* _tmp20_;
	ValaErrorCode* _tmp21_;
	ValaGirComment* _tmp22_;
	ValaGirComment* _tmp23_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "member");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_ascii_strup (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "-", "_");
	_tmp5_ = _tmp4_;
	vala_gir_parser_push_node (self, _tmp5_, FALSE);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = self->priv->reader;
	_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "value");
	value = _tmp7_;
	_tmp8_ = value;
	if (_tmp8_ != NULL) {
		ValaGirParserNode* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		ValaIntegerLiteral* _tmp12_;
		ValaIntegerLiteral* _tmp13_;
		ValaErrorCode* _tmp14_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_->name;
		_tmp11_ = value;
		_tmp12_ = vala_integer_literal_new (_tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_error_code_new_with_value (_tmp10_, (ValaExpression*) _tmp13_, NULL);
		_vala_code_node_unref0 (ec);
		ec = _tmp14_;
		_vala_code_node_unref0 (_tmp13_);
	} else {
		ValaGirParserNode* _tmp15_;
		const gchar* _tmp16_;
		ValaErrorCode* _tmp17_;
		_tmp15_ = self->priv->current;
		_tmp16_ = _tmp15_->name;
		_tmp17_ = vala_error_code_new (_tmp16_, NULL, NULL);
		_vala_code_node_unref0 (ec);
		ec = _tmp17_;
	}
	_tmp18_ = self->priv->current;
	_tmp19_ = ec;
	_tmp20_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp19_);
	_vala_code_node_unref0 (_tmp18_->symbol);
	_tmp18_->symbol = _tmp20_;
	vala_gir_parser_next (self);
	_tmp21_ = ec;
	_tmp22_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp23_ = _tmp22_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp21_, (ValaComment*) _tmp23_);
	_vala_comment_unref0 (_tmp23_);
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "member");
	_g_free0 (value);
	_vala_code_node_unref0 (ec);
}

static ValaDataType*
vala_gir_parser_parse_return_value (ValaGirParser* self,
                                    gchar* * ctype,
                                    gint* array_length_idx,
                                    gboolean* no_array_length,
                                    gboolean* array_null_terminated,
                                    ValaComment* * comment)
{
	gchar* _vala_ctype = NULL;
	gint _vala_array_length_idx = 0;
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	ValaComment* _vala_comment = NULL;
	ValaDataType* result = NULL;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	ValaComment* _tmp6_;
	gboolean transfer_elements = FALSE;
	const gchar* _tmp7_;
	ValaDataType* type = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	ValaDataType* _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "return-value");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "transfer-ownership");
	transfer = _tmp1_;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "nullable");
	nullable = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "allow-none");
	allow_none = _tmp5_;
	vala_gir_parser_next (self);
	_tmp6_ = vala_gir_parser_parse_doc (self);
	_vala_comment_unref0 (_vala_comment);
	_vala_comment = _tmp6_;
	_tmp7_ = transfer;
	transfer_elements = g_strcmp0 (_tmp7_, "container") != 0;
	_tmp12_ = vala_gir_parser_parse_type (self, &_tmp8_, &_tmp9_, transfer_elements, &_tmp10_, &_tmp11_);
	_g_free0 (_vala_ctype);
	_vala_ctype = _tmp8_;
	_vala_array_length_idx = _tmp9_;
	_vala_no_array_length = _tmp10_;
	_vala_array_null_terminated = _tmp11_;
	type = _tmp12_;
	_tmp14_ = transfer;
	if (g_strcmp0 (_tmp14_, "full") == 0) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp15_;
		_tmp15_ = transfer;
		_tmp13_ = g_strcmp0 (_tmp15_, "container") == 0;
	}
	if (_tmp13_) {
		ValaDataType* _tmp16_;
		_tmp16_ = type;
		vala_data_type_set_value_owned (_tmp16_, TRUE);
	}
	_tmp18_ = nullable;
	if (g_strcmp0 (_tmp18_, "1") == 0) {
		_tmp17_ = TRUE;
	} else {
		const gchar* _tmp19_;
		_tmp19_ = allow_none;
		_tmp17_ = g_strcmp0 (_tmp19_, "1") == 0;
	}
	if (_tmp17_) {
		ValaDataType* _tmp20_;
		_tmp20_ = type;
		vala_data_type_set_nullable (_tmp20_, TRUE);
	}
	_tmp21_ = type;
	_tmp22_ = vala_gir_parser_element_get_type (self, _tmp21_, TRUE, &_vala_no_array_length, &_vala_array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp22_;
	vala_gir_parser_end_element (self, "return-value");
	result = type;
	_g_free0 (allow_none);
	_g_free0 (nullable);
	_g_free0 (transfer);
	if (ctype) {
		*ctype = _vala_ctype;
	} else {
		_g_free0 (_vala_ctype);
	}
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	if (comment) {
		*comment = _vala_comment;
	} else {
		_vala_comment_unref0 (_vala_comment);
	}
	return result;
}

static ValaParameter*
vala_gir_parser_parse_parameter (ValaGirParser* self,
                                 gint* array_length_idx,
                                 gint* closure_idx,
                                 gint* destroy_idx,
                                 gchar* * scope,
                                 ValaComment* * comment,
                                 const gchar* default_name)
{
	gint _vala_array_length_idx = 0;
	gint _vala_closure_idx = 0;
	gint _vala_destroy_idx = 0;
	gchar* _vala_scope = NULL;
	ValaComment* _vala_comment = NULL;
	ValaParameter* result = NULL;
	ValaParameter* param = NULL;
	gchar* element_type = NULL;
	ValaMarkupReader* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMarkupTokenType _tmp5_;
	const gchar* _tmp11_;
	gchar* name = NULL;
	ValaGirParserMetadata* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp17_;
	gchar* direction = NULL;
	ValaGirParserMetadata* _tmp19_;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp27_;
	gchar* _tmp28_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp29_;
	gchar* _tmp30_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* closure = NULL;
	ValaMarkupReader* _tmp34_;
	gchar* _tmp35_;
	gchar* destroy = NULL;
	ValaMarkupReader* _tmp36_;
	gchar* _tmp37_;
	gboolean _tmp38_ = FALSE;
	const gchar* _tmp39_;
	gboolean _tmp41_ = FALSE;
	const gchar* _tmp42_;
	ValaGirParserMetadata* _tmp44_;
	ValaGirParserMetadata* _tmp46_;
	ValaComment* _tmp48_;
	ValaMarkupReader* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp105_;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_array_length_idx = -1;
	_vala_closure_idx = -1;
	_vala_destroy_idx = -1;
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	element_type = _tmp3_;
	_tmp5_ = self->priv->current_token;
	if (_tmp5_ != VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		_tmp7_ = element_type;
		if (g_strcmp0 (_tmp7_, "parameter") != 0) {
			const gchar* _tmp8_;
			_tmp8_ = element_type;
			_tmp6_ = g_strcmp0 (_tmp8_, "instance-parameter") != 0;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp4_ = _tmp6_;
	}
	if (_tmp4_) {
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		_tmp9_ = vala_gir_parser_get_current_src (self);
		_tmp10_ = _tmp9_;
		vala_report_error (_tmp10_, "expected start element of `parameter' or `instance-parameter'");
		_vala_source_reference_unref0 (_tmp10_);
	}
	_tmp11_ = element_type;
	vala_gir_parser_start_element (self, _tmp11_);
	_tmp12_ = self->priv->metadata;
	_tmp13_ = vala_gir_parser_metadata_get_string (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	name = _tmp13_;
	_tmp14_ = name;
	if (_tmp14_ == NULL) {
		ValaMarkupReader* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = self->priv->reader;
		_tmp16_ = vala_markup_reader_get_attribute (_tmp15_, "name");
		_g_free0 (name);
		name = _tmp16_;
	}
	_tmp17_ = name;
	if (_tmp17_ == NULL) {
		gchar* _tmp18_;
		_tmp18_ = g_strdup (default_name);
		_g_free0 (name);
		name = _tmp18_;
	}
	direction = NULL;
	_tmp19_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp19_, VALA_GIR_PARSER_ARGUMENT_TYPE_OUT)) {
		ValaGirParserMetadata* _tmp20_;
		_tmp20_ = self->priv->metadata;
		if (vala_gir_parser_metadata_get_bool (_tmp20_, VALA_GIR_PARSER_ARGUMENT_TYPE_OUT, FALSE)) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("out");
			_g_free0 (direction);
			direction = _tmp21_;
		}
	} else {
		ValaGirParserMetadata* _tmp22_;
		_tmp22_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp22_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF)) {
			ValaGirParserMetadata* _tmp23_;
			_tmp23_ = self->priv->metadata;
			if (vala_gir_parser_metadata_get_bool (_tmp23_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF, FALSE)) {
				gchar* _tmp24_;
				_tmp24_ = g_strdup ("inout");
				_g_free0 (direction);
				direction = _tmp24_;
			}
		} else {
			ValaMarkupReader* _tmp25_;
			gchar* _tmp26_;
			_tmp25_ = self->priv->reader;
			_tmp26_ = vala_markup_reader_get_attribute (_tmp25_, "direction");
			_g_free0 (direction);
			direction = _tmp26_;
		}
	}
	_tmp27_ = self->priv->reader;
	_tmp28_ = vala_markup_reader_get_attribute (_tmp27_, "transfer-ownership");
	transfer = _tmp28_;
	_tmp29_ = self->priv->reader;
	_tmp30_ = vala_markup_reader_get_attribute (_tmp29_, "nullable");
	nullable = _tmp30_;
	_tmp31_ = self->priv->reader;
	_tmp32_ = vala_markup_reader_get_attribute (_tmp31_, "allow-none");
	allow_none = _tmp32_;
	_tmp33_ = vala_gir_parser_element_get_string (self, "scope", VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE);
	_g_free0 (_vala_scope);
	_vala_scope = _tmp33_;
	_tmp34_ = self->priv->reader;
	_tmp35_ = vala_markup_reader_get_attribute (_tmp34_, "closure");
	closure = _tmp35_;
	_tmp36_ = self->priv->reader;
	_tmp37_ = vala_markup_reader_get_attribute (_tmp36_, "destroy");
	destroy = _tmp37_;
	_tmp39_ = closure;
	if (_tmp39_ != NULL) {
		_tmp38_ = (&_vala_closure_idx) != NULL;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		const gchar* _tmp40_;
		_tmp40_ = closure;
		_vala_closure_idx = atoi (_tmp40_);
	}
	_tmp42_ = destroy;
	if (_tmp42_ != NULL) {
		_tmp41_ = (&_vala_destroy_idx) != NULL;
	} else {
		_tmp41_ = FALSE;
	}
	if (_tmp41_) {
		const gchar* _tmp43_;
		_tmp43_ = destroy;
		_vala_destroy_idx = atoi (_tmp43_);
	}
	_tmp44_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp44_, VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE)) {
		ValaGirParserMetadata* _tmp45_;
		_tmp45_ = self->priv->metadata;
		_vala_closure_idx = vala_gir_parser_metadata_get_integer (_tmp45_, VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE);
	}
	_tmp46_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp46_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY)) {
		ValaGirParserMetadata* _tmp47_;
		_tmp47_ = self->priv->metadata;
		_vala_destroy_idx = vala_gir_parser_metadata_get_integer (_tmp47_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY);
	}
	vala_gir_parser_next (self);
	_tmp48_ = vala_gir_parser_parse_doc (self);
	_vala_comment_unref0 (_vala_comment);
	_vala_comment = _tmp48_;
	_tmp49_ = self->priv->reader;
	_tmp50_ = vala_markup_reader_get_name (_tmp49_);
	_tmp51_ = _tmp50_;
	if (g_strcmp0 (_tmp51_, "varargs") == 0) {
		ValaSourceReference* _tmp52_;
		ValaSourceReference* _tmp53_;
		ValaParameter* _tmp54_;
		vala_gir_parser_start_element (self, "varargs");
		vala_gir_parser_next (self);
		_tmp52_ = vala_gir_parser_get_current_src (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_parameter_new_with_ellipsis (_tmp53_);
		_vala_code_node_unref0 (param);
		param = _tmp54_;
		_vala_source_reference_unref0 (_tmp53_);
		vala_gir_parser_end_element (self, "varargs");
	} else {
		gchar* ctype = NULL;
		gboolean no_array_length = FALSE;
		gboolean array_null_terminated = FALSE;
		ValaDataType* type = NULL;
		const gchar* _tmp55_;
		gchar* _tmp56_ = NULL;
		gint _tmp57_ = 0;
		gboolean _tmp58_ = FALSE;
		gboolean _tmp59_ = FALSE;
		ValaDataType* _tmp60_;
		gboolean _tmp61_ = FALSE;
		gboolean _tmp62_ = FALSE;
		const gchar* _tmp63_;
		gboolean _tmp67_ = FALSE;
		const gchar* _tmp68_;
		gboolean changed = FALSE;
		gboolean _tmp73_ = FALSE;
		const gchar* _tmp74_;
		ValaDataType* _tmp76_;
		gboolean _tmp77_ = FALSE;
		ValaDataType* _tmp78_;
		const gchar* _tmp79_;
		ValaDataType* _tmp80_;
		ValaSourceReference* _tmp81_;
		ValaSourceReference* _tmp82_;
		ValaParameter* _tmp83_;
		const gchar* _tmp84_;
		const gchar* _tmp87_;
		ValaDataType* _tmp91_;
		ValaParameter* _tmp97_;
		ValaGirParserMetadata* _tmp98_;
		ValaExpression* _tmp99_;
		ValaExpression* _tmp100_;
		ValaParameter* _tmp101_;
		ValaExpression* _tmp102_;
		ValaExpression* _tmp103_;
		_tmp55_ = transfer;
		_tmp60_ = vala_gir_parser_parse_type (self, &_tmp56_, &_tmp57_, g_strcmp0 (_tmp55_, "container") != 0, &_tmp58_, &_tmp59_);
		_g_free0 (ctype);
		ctype = _tmp56_;
		_vala_array_length_idx = _tmp57_;
		no_array_length = _tmp58_;
		array_null_terminated = _tmp59_;
		type = _tmp60_;
		_tmp63_ = transfer;
		if (g_strcmp0 (_tmp63_, "full") == 0) {
			_tmp62_ = TRUE;
		} else {
			const gchar* _tmp64_;
			_tmp64_ = transfer;
			_tmp62_ = g_strcmp0 (_tmp64_, "container") == 0;
		}
		if (_tmp62_) {
			_tmp61_ = TRUE;
		} else {
			const gchar* _tmp65_;
			_tmp65_ = destroy;
			_tmp61_ = _tmp65_ != NULL;
		}
		if (_tmp61_) {
			ValaDataType* _tmp66_;
			_tmp66_ = type;
			vala_data_type_set_value_owned (_tmp66_, TRUE);
		}
		_tmp68_ = nullable;
		if (g_strcmp0 (_tmp68_, "1") == 0) {
			_tmp67_ = TRUE;
		} else {
			gboolean _tmp69_ = FALSE;
			const gchar* _tmp70_;
			_tmp70_ = allow_none;
			if (g_strcmp0 (_tmp70_, "1") == 0) {
				const gchar* _tmp71_;
				_tmp71_ = direction;
				_tmp69_ = g_strcmp0 (_tmp71_, "out") != 0;
			} else {
				_tmp69_ = FALSE;
			}
			_tmp67_ = _tmp69_;
		}
		if (_tmp67_) {
			ValaDataType* _tmp72_;
			_tmp72_ = type;
			vala_data_type_set_nullable (_tmp72_, TRUE);
		}
		_tmp74_ = direction;
		if (g_strcmp0 (_tmp74_, "out") == 0) {
			_tmp73_ = TRUE;
		} else {
			const gchar* _tmp75_;
			_tmp75_ = direction;
			_tmp73_ = g_strcmp0 (_tmp75_, "inout") == 0;
		}
		_tmp76_ = type;
		_tmp78_ = vala_gir_parser_element_get_type (self, _tmp76_, _tmp73_, &no_array_length, &array_null_terminated, &_tmp77_);
		changed = _tmp77_;
		_vala_code_node_unref0 (type);
		type = _tmp78_;
		if (!changed) {
			_g_free0 (ctype);
			ctype = NULL;
		}
		_tmp79_ = name;
		_tmp80_ = type;
		_tmp81_ = vala_gir_parser_get_current_src (self);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_parameter_new (_tmp79_, _tmp80_, _tmp82_);
		_vala_code_node_unref0 (param);
		param = _tmp83_;
		_vala_source_reference_unref0 (_tmp82_);
		_tmp84_ = ctype;
		if (_tmp84_ != NULL) {
			ValaParameter* _tmp85_;
			const gchar* _tmp86_;
			_tmp85_ = param;
			_tmp86_ = ctype;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp85_, "CCode", "type", _tmp86_, NULL);
		}
		_tmp87_ = direction;
		if (g_strcmp0 (_tmp87_, "out") == 0) {
			ValaParameter* _tmp88_;
			_tmp88_ = param;
			vala_parameter_set_direction (_tmp88_, VALA_PARAMETER_DIRECTION_OUT);
		} else {
			const gchar* _tmp89_;
			_tmp89_ = direction;
			if (g_strcmp0 (_tmp89_, "inout") == 0) {
				ValaParameter* _tmp90_;
				_tmp90_ = param;
				vala_parameter_set_direction (_tmp90_, VALA_PARAMETER_DIRECTION_REF);
			}
		}
		_tmp91_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp91_, VALA_TYPE_ARRAY_TYPE)) {
			ValaGirParserMetadata* _tmp92_;
			_tmp92_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp92_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX)) {
				ValaGirParserMetadata* _tmp93_;
				_tmp93_ = self->priv->metadata;
				_vala_array_length_idx = vala_gir_parser_metadata_get_integer (_tmp93_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
			} else {
				gboolean _tmp94_ = FALSE;
				if (no_array_length) {
					_tmp94_ = TRUE;
				} else {
					_tmp94_ = array_null_terminated;
				}
				if (_tmp94_) {
					ValaParameter* _tmp95_;
					_tmp95_ = param;
					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp95_, "CCode", "array_length", !no_array_length, NULL);
				}
				if (array_null_terminated) {
					ValaParameter* _tmp96_;
					_tmp96_ = param;
					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp96_, "CCode", "array_null_terminated", array_null_terminated, NULL);
				}
			}
		}
		_tmp97_ = param;
		_tmp98_ = self->priv->metadata;
		_tmp99_ = vala_gir_parser_metadata_get_expression (_tmp98_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT);
		_tmp100_ = _tmp99_;
		vala_variable_set_initializer ((ValaVariable*) _tmp97_, _tmp100_);
		_vala_code_node_unref0 (_tmp100_);
		_tmp101_ = param;
		_tmp102_ = vala_variable_get_initializer ((ValaVariable*) _tmp101_);
		_tmp103_ = _tmp102_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp103_, VALA_TYPE_TUPLE)) {
			ValaParameter* _tmp104_;
			_tmp104_ = param;
			vala_variable_set_initializer ((ValaVariable*) _tmp104_, NULL);
		}
		_vala_code_node_unref0 (type);
		_g_free0 (ctype);
	}
	_tmp105_ = element_type;
	vala_gir_parser_end_element (self, _tmp105_);
	result = param;
	_g_free0 (destroy);
	_g_free0 (closure);
	_g_free0 (allow_none);
	_g_free0 (nullable);
	_g_free0 (transfer);
	_g_free0 (direction);
	_g_free0 (name);
	_g_free0 (element_type);
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (closure_idx) {
		*closure_idx = _vala_closure_idx;
	}
	if (destroy_idx) {
		*destroy_idx = _vala_destroy_idx;
	}
	if (scope) {
		*scope = _vala_scope;
	} else {
		_g_free0 (_vala_scope);
	}
	if (comment) {
		*comment = _vala_comment;
	} else {
		_vala_comment_unref0 (_vala_comment);
	}
	return result;
}

static ValaDataType*
vala_gir_parser_parse_type (ValaGirParser* self,
                            gchar* * ctype,
                            gint* array_length_idx,
                            gboolean transfer_elements,
                            gboolean* no_array_length,
                            gboolean* array_null_terminated)
{
	gchar* _vala_ctype = NULL;
	gint _vala_array_length_idx = 0;
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	ValaDataType* result = NULL;
	gboolean is_array = FALSE;
	gchar* type_name = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gint fixed_length = 0;
	ValaMarkupReader* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaMarkupReader* _tmp49_;
	gchar* _tmp50_;
	gboolean _tmp51_ = FALSE;
	const gchar* _tmp52_;
	const gchar* _tmp55_;
	ValaDataType* type = NULL;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	ValaDataType* _tmp62_;
	const gchar* _tmp89_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	is_array = FALSE;
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	type_name = _tmp1_;
	_g_free0 (_vala_ctype);
	_vala_ctype = NULL;
	fixed_length = -1;
	_vala_array_length_idx = -1;
	_vala_no_array_length = TRUE;
	_vala_array_null_terminated = TRUE;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "array") == 0) {
		ValaSourceReference* src = NULL;
		ValaSourceReference* _tmp5_;
		const gchar* _tmp6_;
		is_array = TRUE;
		vala_gir_parser_start_element (self, "array");
		_tmp5_ = vala_gir_parser_get_current_src (self);
		src = _tmp5_;
		_tmp6_ = type_name;
		if (_tmp6_ == NULL) {
			ValaMarkupReader* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_;
			ValaMarkupReader* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gboolean _tmp17_;
			ValaMarkupReader* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gboolean _tmp24_;
			ValaMarkupReader* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gboolean _tmp28_;
			ValaDataType* element_type = NULL;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp34_;
			ValaSourceReference* _tmp35_;
			ValaArrayType* _tmp36_;
			_tmp7_ = self->priv->reader;
			_tmp8_ = vala_markup_reader_get_attribute (_tmp7_, "length");
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_ != NULL;
			_g_free0 (_tmp9_);
			if (_tmp10_) {
				ValaMarkupReader* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = self->priv->reader;
				_tmp12_ = vala_markup_reader_get_attribute (_tmp11_, "length");
				_tmp13_ = _tmp12_;
				_vala_array_length_idx = atoi (_tmp13_);
				_g_free0 (_tmp13_);
				_vala_no_array_length = FALSE;
				_vala_array_null_terminated = FALSE;
			}
			_tmp14_ = self->priv->reader;
			_tmp15_ = vala_markup_reader_get_attribute (_tmp14_, "fixed-size");
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_ != NULL;
			_g_free0 (_tmp16_);
			if (_tmp17_) {
				ValaMarkupReader* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp18_ = self->priv->reader;
				_tmp19_ = vala_markup_reader_get_attribute (_tmp18_, "fixed-size");
				_tmp20_ = _tmp19_;
				fixed_length = atoi (_tmp20_);
				_g_free0 (_tmp20_);
				_vala_array_null_terminated = FALSE;
			}
			_tmp21_ = self->priv->reader;
			_tmp22_ = vala_markup_reader_get_attribute (_tmp21_, "c:type");
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strcmp0 (_tmp23_, "GStrv") == 0;
			_g_free0 (_tmp23_);
			if (_tmp24_) {
				_vala_no_array_length = TRUE;
				_vala_array_null_terminated = TRUE;
			}
			_tmp25_ = self->priv->reader;
			_tmp26_ = vala_markup_reader_get_attribute (_tmp25_, "zero-terminated");
			_tmp27_ = _tmp26_;
			_tmp28_ = _tmp27_ != NULL;
			_g_free0 (_tmp27_);
			if (_tmp28_) {
				ValaMarkupReader* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp29_ = self->priv->reader;
				_tmp30_ = vala_markup_reader_get_attribute (_tmp29_, "zero-terminated");
				_tmp31_ = _tmp30_;
				_vala_array_null_terminated = atoi (_tmp31_) != 0;
				_g_free0 (_tmp31_);
			}
			vala_gir_parser_next (self);
			_tmp32_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
			element_type = _tmp32_;
			_tmp33_ = element_type;
			vala_data_type_set_value_owned (_tmp33_, transfer_elements);
			vala_gir_parser_end_element (self, "array");
			_tmp34_ = element_type;
			_tmp35_ = src;
			_tmp36_ = vala_array_type_new (_tmp34_, 1, _tmp35_);
			array_type = _tmp36_;
			if (fixed_length > 0) {
				ValaArrayType* _tmp37_;
				ValaArrayType* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				ValaIntegerLiteral* _tmp41_;
				ValaIntegerLiteral* _tmp42_;
				_tmp37_ = array_type;
				vala_array_type_set_fixed_length (_tmp37_, TRUE);
				_tmp38_ = array_type;
				_tmp39_ = g_strdup_printf ("%i", fixed_length);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_integer_literal_new (_tmp40_, NULL);
				_tmp42_ = _tmp41_;
				vala_array_type_set_length (_tmp38_, (ValaExpression*) _tmp42_);
				_vala_code_node_unref0 (_tmp42_);
				_g_free0 (_tmp40_);
			}
			result = (ValaDataType*) array_type;
			_vala_code_node_unref0 (element_type);
			_vala_source_reference_unref0 (src);
			_g_free0 (type_name);
			if (ctype) {
				*ctype = _vala_ctype;
			} else {
				_g_free0 (_vala_ctype);
			}
			if (array_length_idx) {
				*array_length_idx = _vala_array_length_idx;
			}
			if (no_array_length) {
				*no_array_length = _vala_no_array_length;
			}
			if (array_null_terminated) {
				*array_null_terminated = _vala_array_null_terminated;
			}
			return result;
		}
		_vala_source_reference_unref0 (src);
	} else {
		ValaMarkupReader* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		_tmp43_ = self->priv->reader;
		_tmp44_ = vala_markup_reader_get_name (_tmp43_);
		_tmp45_ = _tmp44_;
		if (g_strcmp0 (_tmp45_, "callback") == 0) {
			ValaGirParserNode* _tmp46_;
			ValaSymbol* _tmp47_;
			ValaDelegateType* _tmp48_;
			vala_gir_parser_parse_callback (self);
			_tmp46_ = self->priv->old_current;
			_tmp47_ = _tmp46_->symbol;
			_tmp48_ = vala_delegate_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_DELEGATE, ValaDelegate));
			result = (ValaDataType*) _tmp48_;
			_g_free0 (type_name);
			if (ctype) {
				*ctype = _vala_ctype;
			} else {
				_g_free0 (_vala_ctype);
			}
			if (array_length_idx) {
				*array_length_idx = _vala_array_length_idx;
			}
			if (no_array_length) {
				*no_array_length = _vala_no_array_length;
			}
			if (array_null_terminated) {
				*array_null_terminated = _vala_array_null_terminated;
			}
			return result;
		} else {
			vala_gir_parser_start_element (self, "type");
		}
	}
	_tmp49_ = self->priv->reader;
	_tmp50_ = vala_markup_reader_get_attribute (_tmp49_, "c:type");
	_g_free0 (_vala_ctype);
	_vala_ctype = _tmp50_;
	vala_gir_parser_next (self);
	_tmp52_ = type_name;
	if (g_strcmp0 (_tmp52_, "GLib.PtrArray") == 0) {
		ValaMarkupTokenType _tmp53_;
		_tmp53_ = self->priv->current_token;
		_tmp51_ = _tmp53_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT;
	} else {
		_tmp51_ = FALSE;
	}
	if (_tmp51_) {
		gchar* _tmp54_;
		_tmp54_ = g_strdup ("GLib.GenericArray");
		_g_free0 (type_name);
		type_name = _tmp54_;
	}
	_tmp55_ = type_name;
	if (_tmp55_ == NULL) {
		const gchar* _tmp56_;
		gchar* _tmp57_;
		_tmp56_ = _vala_ctype;
		_tmp57_ = g_strdup (_tmp56_);
		_g_free0 (type_name);
		type_name = _tmp57_;
	}
	_tmp58_ = type_name;
	_tmp59_ = _vala_ctype;
	_tmp62_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp58_, &_tmp60_, &_tmp61_, _tmp59_);
	_vala_no_array_length = _tmp60_;
	_vala_array_null_terminated = _tmp61_;
	type = _tmp62_;
	while (TRUE) {
		ValaMarkupTokenType _tmp63_;
		const gchar* _tmp64_;
		ValaDataType* element_type = NULL;
		ValaDataType* _tmp65_;
		ValaDataType* _tmp66_;
		ValaDataType* _tmp67_;
		ValaDataType* _tmp68_;
		ValaDataType* _tmp69_;
		_tmp63_ = self->priv->current_token;
		if (!(_tmp63_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp64_ = type_name;
		if (g_strcmp0 (_tmp64_, "GLib.ByteArray") == 0) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp65_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
		element_type = _tmp65_;
		_tmp66_ = element_type;
		vala_data_type_set_value_owned (_tmp66_, transfer_elements);
		_tmp67_ = type;
		_tmp68_ = element_type;
		vala_data_type_add_type_argument (_tmp67_, _tmp68_);
		_tmp69_ = element_type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, VALA_TYPE_UNRESOLVED_TYPE)) {
			ValaGirParserNode* _tmp70_ = NULL;
			ValaGirParserNode* _tmp71_;
			ValaGirParserNode* parent = NULL;
			ValaGirParserNode* _tmp73_;
			ValaHashMap* _tmp86_;
			ValaDataType* _tmp87_;
			ValaGirParserNode* _tmp88_;
			_tmp71_ = self->priv->current;
			_tmp70_ = _tmp71_;
			if (_tmp70_ == NULL) {
				ValaGirParserNode* _tmp72_;
				_tmp72_ = self->priv->root;
				_tmp70_ = _tmp72_;
			}
			_tmp73_ = _vala_gir_parser_node_ref0 (_tmp70_);
			parent = _tmp73_;
			while (TRUE) {
				gboolean _tmp74_ = FALSE;
				gboolean _tmp75_ = FALSE;
				ValaGirParserNode* _tmp76_;
				ValaGirParserNode* _tmp77_;
				ValaGirParserNode* _tmp83_;
				ValaGirParserNode* _tmp84_;
				ValaGirParserNode* _tmp85_;
				_tmp76_ = parent;
				_tmp77_ = self->priv->root;
				if (_tmp76_ != _tmp77_) {
					ValaGirParserNode* _tmp78_;
					ValaGirParserNode* _tmp79_;
					_tmp78_ = parent;
					_tmp79_ = _tmp78_->parent;
					_tmp75_ = _tmp79_ != NULL;
				} else {
					_tmp75_ = FALSE;
				}
				if (_tmp75_) {
					ValaGirParserNode* _tmp80_;
					ValaGirParserNode* _tmp81_;
					ValaGirParserNode* _tmp82_;
					_tmp80_ = parent;
					_tmp81_ = _tmp80_->parent;
					_tmp82_ = self->priv->root;
					_tmp74_ = _tmp81_ != _tmp82_;
				} else {
					_tmp74_ = FALSE;
				}
				if (!_tmp74_) {
					break;
				}
				_tmp83_ = parent;
				_tmp84_ = _tmp83_->parent;
				_tmp85_ = _vala_gir_parser_node_ref0 (_tmp84_);
				_vala_gir_parser_node_unref0 (parent);
				parent = _tmp85_;
			}
			_tmp86_ = self->priv->unresolved_type_arguments;
			_tmp87_ = element_type;
			_tmp88_ = parent;
			vala_map_set ((ValaMap*) _tmp86_, G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType), _tmp88_);
			_vala_gir_parser_node_unref0 (parent);
		}
		_vala_code_node_unref0 (element_type);
	}
	if (is_array) {
		_tmp89_ = "array";
	} else {
		_tmp89_ = "type";
	}
	vala_gir_parser_end_element (self, _tmp89_);
	result = type;
	_g_free0 (type_name);
	if (ctype) {
		*ctype = _vala_ctype;
	} else {
		_g_free0 (_vala_ctype);
	}
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	return result;
}

static ValaDataType*
vala_gir_parser_parse_type_from_gir_name (ValaGirParser* self,
                                          const gchar* type_name,
                                          gboolean* no_array_length,
                                          gboolean* array_null_terminated,
                                          const gchar* ctype)
{
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	ValaDataType* result = NULL;
	ValaDataType* type = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	_vala_no_array_length = FALSE;
	_vala_array_null_terminated = FALSE;
	type = NULL;
	if (g_strcmp0 (type_name, "none") == 0) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		ValaVoidType* _tmp2_;
		_tmp0_ = vala_gir_parser_get_current_src (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_void_type_new (_tmp1_);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp2_;
		_vala_source_reference_unref0 (_tmp1_);
	} else {
		if (g_strcmp0 (type_name, "gpointer") == 0) {
			ValaSourceReference* _tmp3_;
			ValaSourceReference* _tmp4_;
			ValaVoidType* _tmp5_;
			ValaVoidType* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaPointerType* _tmp9_;
			_tmp3_ = vala_gir_parser_get_current_src (self);
			_tmp4_ = _tmp3_;
			_tmp5_ = vala_void_type_new (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_gir_parser_get_current_src (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_pointer_type_new ((ValaDataType*) _tmp6_, _tmp8_);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp9_;
			_vala_source_reference_unref0 (_tmp8_);
			_vala_code_node_unref0 (_tmp6_);
			_vala_source_reference_unref0 (_tmp4_);
		} else {
			if (g_strcmp0 (type_name, "GObject.Strv") == 0) {
				ValaUnresolvedType* element_type = NULL;
				ValaUnresolvedSymbol* _tmp10_;
				ValaUnresolvedSymbol* _tmp11_;
				ValaUnresolvedType* _tmp12_;
				ValaUnresolvedType* _tmp13_;
				ValaUnresolvedType* _tmp14_;
				ValaUnresolvedType* _tmp15_;
				ValaSourceReference* _tmp16_;
				ValaSourceReference* _tmp17_;
				ValaArrayType* _tmp18_;
				_tmp10_ = vala_unresolved_symbol_new (NULL, "string", NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_unresolved_type_new_from_symbol (_tmp11_, NULL);
				_tmp13_ = _tmp12_;
				_vala_code_node_unref0 (_tmp11_);
				element_type = _tmp13_;
				_tmp14_ = element_type;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp14_, TRUE);
				_tmp15_ = element_type;
				_tmp16_ = vala_gir_parser_get_current_src (self);
				_tmp17_ = _tmp16_;
				_tmp18_ = vala_array_type_new ((ValaDataType*) _tmp15_, 1, _tmp17_);
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp18_;
				_vala_source_reference_unref0 (_tmp17_);
				_vala_no_array_length = TRUE;
				_vala_array_null_terminated = TRUE;
				_vala_code_node_unref0 (element_type);
			} else {
				gboolean known_type = FALSE;
				ValaDataType* _tmp31_;
				known_type = TRUE;
				if (g_strcmp0 (type_name, "utf8") == 0) {
					type_name = "string";
				} else {
					if (g_strcmp0 (type_name, "gboolean") == 0) {
						ValaCodeContext* _tmp19_;
						ValaNamespace* _tmp20_;
						ValaNamespace* _tmp21_;
						ValaScope* _tmp22_;
						ValaScope* _tmp23_;
						ValaSymbol* _tmp24_;
						ValaStruct* _tmp25_;
						ValaBooleanType* _tmp26_;
						_tmp19_ = self->priv->context;
						_tmp20_ = vala_code_context_get_root (_tmp19_);
						_tmp21_ = _tmp20_;
						_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = vala_scope_lookup (_tmp23_, "bool");
						_tmp25_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALA_TYPE_STRUCT, ValaStruct);
						_tmp26_ = vala_boolean_type_new (_tmp25_);
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp26_;
						_vala_code_node_unref0 (_tmp25_);
					} else {
						if (g_strcmp0 (type_name, "gchar") == 0) {
							type_name = "char";
						} else {
							if (g_strcmp0 (type_name, "gshort") == 0) {
								type_name = "short";
							} else {
								if (g_strcmp0 (type_name, "gushort") == 0) {
									type_name = "ushort";
								} else {
									if (g_strcmp0 (type_name, "gint") == 0) {
										type_name = "int";
									} else {
										if (g_strcmp0 (type_name, "guint") == 0) {
											type_name = "uint";
										} else {
											if (g_strcmp0 (type_name, "glong") == 0) {
												gboolean _tmp27_ = FALSE;
												if (ctype != NULL) {
													_tmp27_ = g_str_has_prefix (ctype, "gssize");
												} else {
													_tmp27_ = FALSE;
												}
												if (_tmp27_) {
													type_name = "ssize_t";
												} else {
													gboolean _tmp28_ = FALSE;
													if (ctype != NULL) {
														_tmp28_ = g_str_has_prefix (ctype, "gintptr");
													} else {
														_tmp28_ = FALSE;
													}
													if (_tmp28_) {
														type_name = "intptr";
													} else {
														type_name = "long";
													}
												}
											} else {
												if (g_strcmp0 (type_name, "gulong") == 0) {
													gboolean _tmp29_ = FALSE;
													if (ctype != NULL) {
														_tmp29_ = g_str_has_prefix (ctype, "gsize");
													} else {
														_tmp29_ = FALSE;
													}
													if (_tmp29_) {
														type_name = "size_t";
													} else {
														gboolean _tmp30_ = FALSE;
														if (ctype != NULL) {
															_tmp30_ = g_str_has_prefix (ctype, "guintptr");
														} else {
															_tmp30_ = FALSE;
														}
														if (_tmp30_) {
															type_name = "uintptr";
														} else {
															type_name = "ulong";
														}
													}
												} else {
													if (g_strcmp0 (type_name, "gint8") == 0) {
														type_name = "int8";
													} else {
														if (g_strcmp0 (type_name, "guint8") == 0) {
															type_name = "uint8";
														} else {
															if (g_strcmp0 (type_name, "gint16") == 0) {
																type_name = "int16";
															} else {
																if (g_strcmp0 (type_name, "guint16") == 0) {
																	type_name = "uint16";
																} else {
																	if (g_strcmp0 (type_name, "gint32") == 0) {
																		type_name = "int32";
																	} else {
																		if (g_strcmp0 (type_name, "guint32") == 0) {
																			type_name = "uint32";
																		} else {
																			if (g_strcmp0 (type_name, "gint64") == 0) {
																				type_name = "int64";
																			} else {
																				if (g_strcmp0 (type_name, "guint64") == 0) {
																					type_name = "uint64";
																				} else {
																					if (g_strcmp0 (type_name, "gfloat") == 0) {
																						type_name = "float";
																					} else {
																						if (g_strcmp0 (type_name, "gdouble") == 0) {
																							type_name = "double";
																						} else {
																							if (g_strcmp0 (type_name, "filename") == 0) {
																								type_name = "string";
																							} else {
																								if (g_strcmp0 (type_name, "GLib.offset") == 0) {
																									type_name = "int64";
																								} else {
																									if (g_strcmp0 (type_name, "gsize") == 0) {
																										type_name = "size_t";
																									} else {
																										if (g_strcmp0 (type_name, "gssize") == 0) {
																											type_name = "ssize_t";
																										} else {
																											if (g_strcmp0 (type_name, "guintptr") == 0) {
																												type_name = "uintptr";
																											} else {
																												if (g_strcmp0 (type_name, "gintptr") == 0) {
																													type_name = "intptr";
																												} else {
																													if (g_strcmp0 (type_name, "GType") == 0) {
																														type_name = "GLib.Type";
																													} else {
																														if (g_strcmp0 (type_name, "GLib.String") == 0) {
																															type_name = "GLib.StringBuilder";
																														} else {
																															if (g_strcmp0 (type_name, "GObject.Class") == 0) {
																																type_name = "GLib.ObjectClass";
																															} else {
																																if (g_strcmp0 (type_name, "gunichar") == 0) {
																																	type_name = "unichar";
																																} else {
																																	if (g_strcmp0 (type_name, "GLib.Data") == 0) {
																																		type_name = "GLib.Datalist";
																																	} else {
																																		if (g_strcmp0 (type_name, "Atk.ImplementorIface") == 0) {
																																			type_name = "Atk.Implementor";
																																		} else {
																																			known_type = FALSE;
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				_tmp31_ = type;
				if (_tmp31_ == NULL) {
					ValaUnresolvedSymbol* sym = NULL;
					ValaSourceReference* _tmp32_;
					ValaSourceReference* _tmp33_;
					ValaUnresolvedSymbol* _tmp34_;
					ValaUnresolvedSymbol* _tmp35_;
					ValaUnresolvedSymbol* _tmp36_;
					ValaSourceReference* _tmp37_;
					ValaSourceReference* _tmp38_;
					ValaUnresolvedType* _tmp39_;
					_tmp32_ = vala_gir_parser_get_current_src (self);
					_tmp33_ = _tmp32_;
					_tmp34_ = vala_gir_parser_parse_symbol_from_string (self, type_name, _tmp33_);
					_tmp35_ = _tmp34_;
					_vala_source_reference_unref0 (_tmp33_);
					sym = _tmp35_;
					_tmp36_ = sym;
					_tmp37_ = vala_gir_parser_get_current_src (self);
					_tmp38_ = _tmp37_;
					_tmp39_ = vala_unresolved_type_new_from_symbol (_tmp36_, _tmp38_);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp39_;
					_vala_source_reference_unref0 (_tmp38_);
					if (!known_type) {
						ValaArrayList* _tmp40_;
						ValaUnresolvedSymbol* _tmp41_;
						_tmp40_ = self->priv->unresolved_gir_symbols;
						_tmp41_ = sym;
						vala_collection_add ((ValaCollection*) _tmp40_, _tmp41_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	result = type;
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	return result;
}

static void
vala_gir_parser_parse_record (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaStruct* st = NULL;
	ValaGirParserNode* _tmp2_;
	ValaStruct* _tmp14_;
	ValaStruct* _tmp15_;
	ValaStruct* _tmp16_;
	gchar* gtype_struct_for = NULL;
	ValaMarkupReader* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gboolean first_field = FALSE;
	ValaStruct* _tmp28_;
	ValaGirComment* _tmp29_;
	ValaGirComment* _tmp30_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "record");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->current;
	if (_tmp2_->new_symbol) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		ValaGirParserNode* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaStruct* _tmp7_;
		ValaGirParserNode* _tmp8_;
		ValaStruct* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp3_ = vala_gir_parser_element_get_name (self, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->source_reference;
		_tmp7_ = vala_struct_new (_tmp4_, _tmp6_, NULL);
		_vala_code_node_unref0 (st);
		st = _tmp7_;
		_g_free0 (_tmp4_);
		_tmp8_ = self->priv->current;
		_tmp9_ = st;
		_tmp10_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp9_);
		_vala_code_node_unref0 (_tmp8_->symbol);
		_tmp8_->symbol = _tmp10_;
	} else {
		ValaGirParserNode* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaStruct* _tmp13_;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_->symbol;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_STRUCT, ValaStruct));
		_vala_code_node_unref0 (st);
		st = _tmp13_;
	}
	_tmp14_ = st;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp14_);
	_tmp15_ = st;
	vala_symbol_set_external ((ValaSymbol*) _tmp15_, TRUE);
	_tmp16_ = st;
	vala_symbol_set_access ((ValaSymbol*) _tmp16_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp17_ = self->priv->reader;
	_tmp18_ = vala_markup_reader_get_attribute (_tmp17_, "glib:is-gtype-struct-for");
	gtype_struct_for = _tmp18_;
	_tmp19_ = gtype_struct_for;
	if (_tmp19_ != NULL) {
		ValaGirParserNode* _tmp20_;
		const gchar* _tmp21_;
		ValaGirParserNode* _tmp22_;
		ValaSourceReference* _tmp23_;
		ValaUnresolvedSymbol* _tmp24_;
		ValaArrayList* _tmp25_;
		ValaGirParserNode* _tmp26_;
		ValaUnresolvedSymbol* _tmp27_;
		_tmp20_ = self->priv->current;
		_tmp21_ = gtype_struct_for;
		_tmp22_ = self->priv->current;
		_tmp23_ = _tmp22_->source_reference;
		_tmp24_ = vala_gir_parser_parse_symbol_from_string (self, _tmp21_, _tmp23_);
		_vala_code_node_unref0 (_tmp20_->gtype_struct_for);
		_tmp20_->gtype_struct_for = _tmp24_;
		_tmp25_ = self->priv->unresolved_gir_symbols;
		_tmp26_ = self->priv->current;
		_tmp27_ = _tmp26_->gtype_struct_for;
		vala_collection_add ((ValaCollection*) _tmp25_, _tmp27_);
	}
	first_field = TRUE;
	vala_gir_parser_next (self);
	_tmp28_ = st;
	_tmp29_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp30_ = _tmp29_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp28_, (ValaComment*) _tmp30_);
	_vala_comment_unref0 (_tmp30_);
	while (TRUE) {
		ValaMarkupTokenType _tmp31_;
		ValaMarkupReader* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		_tmp31_ = self->priv->current_token;
		if (!(_tmp31_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			gboolean _tmp32_ = FALSE;
			if (first_field) {
				ValaMarkupReader* _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				_tmp33_ = self->priv->reader;
				_tmp34_ = vala_markup_reader_get_name (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp32_ = g_strcmp0 (_tmp35_, "field") == 0;
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				first_field = FALSE;
			}
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp36_ = self->priv->reader;
		_tmp37_ = vala_markup_reader_get_name (_tmp36_);
		_tmp38_ = _tmp37_;
		if (g_strcmp0 (_tmp38_, "field") == 0) {
			gboolean _tmp39_ = FALSE;
			ValaMarkupReader* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gboolean _tmp43_;
			_tmp40_ = self->priv->reader;
			_tmp41_ = vala_markup_reader_get_attribute (_tmp40_, "name");
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strcmp0 (_tmp42_, "priv") != 0;
			_g_free0 (_tmp42_);
			if (_tmp43_) {
				gboolean _tmp44_ = FALSE;
				if (first_field) {
					const gchar* _tmp45_;
					_tmp45_ = gtype_struct_for;
					_tmp44_ = _tmp45_ != NULL;
				} else {
					_tmp44_ = FALSE;
				}
				_tmp39_ = !_tmp44_;
			} else {
				_tmp39_ = FALSE;
			}
			if (_tmp39_) {
				vala_gir_parser_parse_field (self);
			} else {
				vala_gir_parser_skip_element (self);
			}
			first_field = FALSE;
		} else {
			ValaMarkupReader* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			_tmp46_ = self->priv->reader;
			_tmp47_ = vala_markup_reader_get_name (_tmp46_);
			_tmp48_ = _tmp47_;
			if (g_strcmp0 (_tmp48_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp49_;
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				_tmp49_ = self->priv->reader;
				_tmp50_ = vala_markup_reader_get_name (_tmp49_);
				_tmp51_ = _tmp50_;
				if (g_strcmp0 (_tmp51_, "method") == 0) {
					vala_gir_parser_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp52_;
					const gchar* _tmp53_;
					const gchar* _tmp54_;
					_tmp52_ = self->priv->reader;
					_tmp53_ = vala_markup_reader_get_name (_tmp52_);
					_tmp54_ = _tmp53_;
					if (g_strcmp0 (_tmp54_, "function") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp55_;
						const gchar* _tmp56_;
						const gchar* _tmp57_;
						_tmp55_ = self->priv->reader;
						_tmp56_ = vala_markup_reader_get_name (_tmp55_);
						_tmp57_ = _tmp56_;
						if (g_strcmp0 (_tmp57_, "union") == 0) {
							vala_gir_parser_parse_union (self);
						} else {
							ValaSourceReference* _tmp58_;
							ValaSourceReference* _tmp59_;
							ValaMarkupReader* _tmp60_;
							const gchar* _tmp61_;
							const gchar* _tmp62_;
							gchar* _tmp63_;
							gchar* _tmp64_;
							_tmp58_ = vala_gir_parser_get_current_src (self);
							_tmp59_ = _tmp58_;
							_tmp60_ = self->priv->reader;
							_tmp61_ = vala_markup_reader_get_name (_tmp60_);
							_tmp62_ = _tmp61_;
							_tmp63_ = g_strdup_printf ("unknown child element `%s' in `record'", _tmp62_);
							_tmp64_ = _tmp63_;
							vala_report_error (_tmp59_, _tmp64_);
							_g_free0 (_tmp64_);
							_vala_source_reference_unref0 (_tmp59_);
							vala_gir_parser_skip_element (self);
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "record");
	_g_free0 (gtype_struct_for);
	_vala_code_node_unref0 (st);
}

static void
vala_gir_parser_parse_class (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaClass* cl = NULL;
	gchar* parent = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	ValaGirParserNode* _tmp4_;
	ValaClass* _tmp26_;
	ValaClass* _tmp27_;
	ValaClass* _tmp28_;
	ValaClass* _tmp29_;
	ValaGirComment* _tmp30_;
	ValaGirComment* _tmp31_;
	gboolean first_field = FALSE;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "class");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "parent");
	parent = _tmp3_;
	_tmp4_ = self->priv->current;
	if (_tmp4_->new_symbol) {
		ValaGirParserNode* _tmp5_;
		const gchar* _tmp6_;
		ValaGirParserNode* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaClass* _tmp9_;
		ValaClass* _tmp10_;
		ValaGirParserMetadata* _tmp11_;
		ValaMarkupReader* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		ValaGirParserNode* _tmp20_;
		ValaClass* _tmp21_;
		ValaSymbol* _tmp22_;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->name;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_->source_reference;
		_tmp9_ = vala_class_new (_tmp6_, _tmp8_, NULL);
		_vala_code_node_unref0 (cl);
		cl = _tmp9_;
		_tmp10_ = cl;
		_tmp11_ = self->priv->metadata;
		_tmp12_ = self->priv->reader;
		_tmp13_ = vala_markup_reader_get_attribute (_tmp12_, "abstract");
		_tmp14_ = _tmp13_;
		vala_class_set_is_abstract (_tmp10_, vala_gir_parser_metadata_get_bool (_tmp11_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, g_strcmp0 (_tmp14_, "1") == 0));
		_g_free0 (_tmp14_);
		_tmp15_ = parent;
		if (_tmp15_ != NULL) {
			ValaClass* _tmp16_;
			const gchar* _tmp17_;
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			_tmp16_ = cl;
			_tmp17_ = parent;
			_tmp18_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp17_, NULL, NULL, NULL);
			_tmp19_ = _tmp18_;
			vala_class_add_base_type (_tmp16_, _tmp19_);
			_vala_code_node_unref0 (_tmp19_);
		}
		_tmp20_ = self->priv->current;
		_tmp21_ = cl;
		_tmp22_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp21_);
		_vala_code_node_unref0 (_tmp20_->symbol);
		_tmp20_->symbol = _tmp22_;
	} else {
		ValaGirParserNode* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaClass* _tmp25_;
		_tmp23_ = self->priv->current;
		_tmp24_ = _tmp23_->symbol;
		_tmp25_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALA_TYPE_CLASS, ValaClass));
		_vala_code_node_unref0 (cl);
		cl = _tmp25_;
	}
	_tmp26_ = cl;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp26_);
	_tmp27_ = cl;
	vala_symbol_set_access ((ValaSymbol*) _tmp27_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp28_ = cl;
	vala_symbol_set_external ((ValaSymbol*) _tmp28_, TRUE);
	vala_gir_parser_next (self);
	_tmp29_ = cl;
	_tmp30_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp31_ = _tmp30_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp29_, (ValaComment*) _tmp31_);
	_vala_comment_unref0 (_tmp31_);
	first_field = TRUE;
	while (TRUE) {
		ValaMarkupTokenType _tmp32_;
		ValaMarkupReader* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		_tmp32_ = self->priv->current_token;
		if (!(_tmp32_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			gboolean _tmp33_ = FALSE;
			if (first_field) {
				ValaMarkupReader* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				_tmp34_ = self->priv->reader;
				_tmp35_ = vala_markup_reader_get_name (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp33_ = g_strcmp0 (_tmp36_, "field") == 0;
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				first_field = FALSE;
			}
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp37_ = self->priv->reader;
		_tmp38_ = vala_markup_reader_get_name (_tmp37_);
		_tmp39_ = _tmp38_;
		if (g_strcmp0 (_tmp39_, "implements") == 0) {
			ValaClass* _tmp40_;
			ValaMarkupReader* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			ValaDataType* _tmp44_;
			ValaDataType* _tmp45_;
			vala_gir_parser_start_element (self, "implements");
			_tmp40_ = cl;
			_tmp41_ = self->priv->reader;
			_tmp42_ = vala_markup_reader_get_attribute (_tmp41_, "name");
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp43_, NULL, NULL, NULL);
			_tmp45_ = _tmp44_;
			vala_class_add_base_type (_tmp40_, _tmp45_);
			_vala_code_node_unref0 (_tmp45_);
			_g_free0 (_tmp43_);
			vala_gir_parser_next (self);
			vala_gir_parser_end_element (self, "implements");
		} else {
			ValaMarkupReader* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			_tmp46_ = self->priv->reader;
			_tmp47_ = vala_markup_reader_get_name (_tmp46_);
			_tmp48_ = _tmp47_;
			if (g_strcmp0 (_tmp48_, "constant") == 0) {
				vala_gir_parser_parse_constant (self);
			} else {
				ValaMarkupReader* _tmp49_;
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				_tmp49_ = self->priv->reader;
				_tmp50_ = vala_markup_reader_get_name (_tmp49_);
				_tmp51_ = _tmp50_;
				if (g_strcmp0 (_tmp51_, "field") == 0) {
					gboolean _tmp52_ = FALSE;
					if (first_field) {
						const gchar* _tmp53_;
						_tmp53_ = parent;
						_tmp52_ = _tmp53_ != NULL;
					} else {
						_tmp52_ = FALSE;
					}
					if (_tmp52_) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp54_;
						gchar* _tmp55_;
						gchar* _tmp56_;
						gboolean _tmp57_;
						_tmp54_ = self->priv->reader;
						_tmp55_ = vala_markup_reader_get_attribute (_tmp54_, "name");
						_tmp56_ = _tmp55_;
						_tmp57_ = g_strcmp0 (_tmp56_, "priv") != 0;
						_g_free0 (_tmp56_);
						if (_tmp57_) {
							vala_gir_parser_parse_field (self);
						} else {
							vala_gir_parser_skip_element (self);
						}
					}
					first_field = FALSE;
				} else {
					ValaMarkupReader* _tmp58_;
					const gchar* _tmp59_;
					const gchar* _tmp60_;
					_tmp58_ = self->priv->reader;
					_tmp59_ = vala_markup_reader_get_name (_tmp58_);
					_tmp60_ = _tmp59_;
					if (g_strcmp0 (_tmp60_, "property") == 0) {
						ValaProperty* _tmp61_;
						ValaProperty* _tmp62_;
						_tmp61_ = vala_gir_parser_parse_property (self);
						_tmp62_ = _tmp61_;
						_vala_code_node_unref0 (_tmp62_);
					} else {
						ValaMarkupReader* _tmp63_;
						const gchar* _tmp64_;
						const gchar* _tmp65_;
						_tmp63_ = self->priv->reader;
						_tmp64_ = vala_markup_reader_get_name (_tmp63_);
						_tmp65_ = _tmp64_;
						if (g_strcmp0 (_tmp65_, "constructor") == 0) {
							vala_gir_parser_parse_constructor (self);
						} else {
							ValaMarkupReader* _tmp66_;
							const gchar* _tmp67_;
							const gchar* _tmp68_;
							_tmp66_ = self->priv->reader;
							_tmp67_ = vala_markup_reader_get_name (_tmp66_);
							_tmp68_ = _tmp67_;
							if (g_strcmp0 (_tmp68_, "function") == 0) {
								vala_gir_parser_parse_method (self, "function");
							} else {
								ValaMarkupReader* _tmp69_;
								const gchar* _tmp70_;
								const gchar* _tmp71_;
								_tmp69_ = self->priv->reader;
								_tmp70_ = vala_markup_reader_get_name (_tmp69_);
								_tmp71_ = _tmp70_;
								if (g_strcmp0 (_tmp71_, "method") == 0) {
									vala_gir_parser_parse_method (self, "method");
								} else {
									ValaMarkupReader* _tmp72_;
									const gchar* _tmp73_;
									const gchar* _tmp74_;
									_tmp72_ = self->priv->reader;
									_tmp73_ = vala_markup_reader_get_name (_tmp72_);
									_tmp74_ = _tmp73_;
									if (g_strcmp0 (_tmp74_, "virtual-method") == 0) {
										vala_gir_parser_parse_method (self, "virtual-method");
									} else {
										ValaMarkupReader* _tmp75_;
										const gchar* _tmp76_;
										const gchar* _tmp77_;
										_tmp75_ = self->priv->reader;
										_tmp76_ = vala_markup_reader_get_name (_tmp75_);
										_tmp77_ = _tmp76_;
										if (g_strcmp0 (_tmp77_, "union") == 0) {
											vala_gir_parser_parse_union (self);
										} else {
											ValaMarkupReader* _tmp78_;
											const gchar* _tmp79_;
											const gchar* _tmp80_;
											_tmp78_ = self->priv->reader;
											_tmp79_ = vala_markup_reader_get_name (_tmp78_);
											_tmp80_ = _tmp79_;
											if (g_strcmp0 (_tmp80_, "glib:signal") == 0) {
												vala_gir_parser_parse_signal (self);
											} else {
												ValaSourceReference* _tmp81_;
												ValaSourceReference* _tmp82_;
												ValaMarkupReader* _tmp83_;
												const gchar* _tmp84_;
												const gchar* _tmp85_;
												gchar* _tmp86_;
												gchar* _tmp87_;
												_tmp81_ = vala_gir_parser_get_current_src (self);
												_tmp82_ = _tmp81_;
												_tmp83_ = self->priv->reader;
												_tmp84_ = vala_markup_reader_get_name (_tmp83_);
												_tmp85_ = _tmp84_;
												_tmp86_ = g_strdup_printf ("unknown child element `%s' in `class'", _tmp85_);
												_tmp87_ = _tmp86_;
												vala_report_error (_tmp82_, _tmp87_);
												_g_free0 (_tmp87_);
												_vala_source_reference_unref0 (_tmp82_);
												vala_gir_parser_skip_element (self);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "class");
	_g_free0 (parent);
	_vala_code_node_unref0 (cl);
}

static void
vala_gir_parser_parse_interface (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaInterface* iface = NULL;
	ValaGirParserNode* _tmp2_;
	ValaInterface* _tmp14_;
	ValaInterface* _tmp15_;
	ValaInterface* _tmp16_;
	ValaInterface* _tmp17_;
	ValaGirComment* _tmp18_;
	ValaGirComment* _tmp19_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "interface");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->current;
	if (_tmp2_->new_symbol) {
		ValaGirParserNode* _tmp3_;
		const gchar* _tmp4_;
		ValaGirParserNode* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaInterface* _tmp7_;
		ValaGirParserNode* _tmp8_;
		ValaInterface* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_->name;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->source_reference;
		_tmp7_ = vala_interface_new (_tmp4_, _tmp6_, NULL);
		_vala_code_node_unref0 (iface);
		iface = _tmp7_;
		_tmp8_ = self->priv->current;
		_tmp9_ = iface;
		_tmp10_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp9_);
		_vala_code_node_unref0 (_tmp8_->symbol);
		_tmp8_->symbol = _tmp10_;
	} else {
		ValaGirParserNode* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaInterface* _tmp13_;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_->symbol;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_INTERFACE, ValaInterface));
		_vala_code_node_unref0 (iface);
		iface = _tmp13_;
	}
	_tmp14_ = iface;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp14_);
	_tmp15_ = iface;
	vala_symbol_set_access ((ValaSymbol*) _tmp15_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp16_ = iface;
	vala_symbol_set_external ((ValaSymbol*) _tmp16_, TRUE);
	vala_gir_parser_next (self);
	_tmp17_ = iface;
	_tmp18_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp19_ = _tmp18_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp17_, (ValaComment*) _tmp19_);
	_vala_comment_unref0 (_tmp19_);
	while (TRUE) {
		ValaMarkupTokenType _tmp20_;
		ValaMarkupReader* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp20_ = self->priv->current_token;
		if (!(_tmp20_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp21_ = self->priv->reader;
		_tmp22_ = vala_markup_reader_get_name (_tmp21_);
		_tmp23_ = _tmp22_;
		if (g_strcmp0 (_tmp23_, "prerequisite") == 0) {
			ValaInterface* _tmp24_;
			ValaMarkupReader* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			ValaDataType* _tmp28_;
			ValaDataType* _tmp29_;
			vala_gir_parser_start_element (self, "prerequisite");
			_tmp24_ = iface;
			_tmp25_ = self->priv->reader;
			_tmp26_ = vala_markup_reader_get_attribute (_tmp25_, "name");
			_tmp27_ = _tmp26_;
			_tmp28_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp27_, NULL, NULL, NULL);
			_tmp29_ = _tmp28_;
			vala_interface_add_prerequisite (_tmp24_, _tmp29_);
			_vala_code_node_unref0 (_tmp29_);
			_g_free0 (_tmp27_);
			vala_gir_parser_next (self);
			vala_gir_parser_end_element (self, "prerequisite");
		} else {
			ValaMarkupReader* _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			_tmp30_ = self->priv->reader;
			_tmp31_ = vala_markup_reader_get_name (_tmp30_);
			_tmp32_ = _tmp31_;
			if (g_strcmp0 (_tmp32_, "field") == 0) {
				vala_gir_parser_parse_field (self);
			} else {
				ValaMarkupReader* _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				_tmp33_ = self->priv->reader;
				_tmp34_ = vala_markup_reader_get_name (_tmp33_);
				_tmp35_ = _tmp34_;
				if (g_strcmp0 (_tmp35_, "property") == 0) {
					ValaProperty* _tmp36_;
					ValaProperty* _tmp37_;
					_tmp36_ = vala_gir_parser_parse_property (self);
					_tmp37_ = _tmp36_;
					_vala_code_node_unref0 (_tmp37_);
				} else {
					ValaMarkupReader* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					_tmp38_ = self->priv->reader;
					_tmp39_ = vala_markup_reader_get_name (_tmp38_);
					_tmp40_ = _tmp39_;
					if (g_strcmp0 (_tmp40_, "virtual-method") == 0) {
						vala_gir_parser_parse_method (self, "virtual-method");
					} else {
						ValaMarkupReader* _tmp41_;
						const gchar* _tmp42_;
						const gchar* _tmp43_;
						_tmp41_ = self->priv->reader;
						_tmp42_ = vala_markup_reader_get_name (_tmp41_);
						_tmp43_ = _tmp42_;
						if (g_strcmp0 (_tmp43_, "function") == 0) {
							vala_gir_parser_parse_method (self, "function");
						} else {
							ValaMarkupReader* _tmp44_;
							const gchar* _tmp45_;
							const gchar* _tmp46_;
							_tmp44_ = self->priv->reader;
							_tmp45_ = vala_markup_reader_get_name (_tmp44_);
							_tmp46_ = _tmp45_;
							if (g_strcmp0 (_tmp46_, "method") == 0) {
								vala_gir_parser_parse_method (self, "method");
							} else {
								ValaMarkupReader* _tmp47_;
								const gchar* _tmp48_;
								const gchar* _tmp49_;
								_tmp47_ = self->priv->reader;
								_tmp48_ = vala_markup_reader_get_name (_tmp47_);
								_tmp49_ = _tmp48_;
								if (g_strcmp0 (_tmp49_, "glib:signal") == 0) {
									vala_gir_parser_parse_signal (self);
								} else {
									ValaSourceReference* _tmp50_;
									ValaSourceReference* _tmp51_;
									ValaMarkupReader* _tmp52_;
									const gchar* _tmp53_;
									const gchar* _tmp54_;
									gchar* _tmp55_;
									gchar* _tmp56_;
									_tmp50_ = vala_gir_parser_get_current_src (self);
									_tmp51_ = _tmp50_;
									_tmp52_ = self->priv->reader;
									_tmp53_ = vala_markup_reader_get_name (_tmp52_);
									_tmp54_ = _tmp53_;
									_tmp55_ = g_strdup_printf ("unknown child element `%s' in `interface'", _tmp54_);
									_tmp56_ = _tmp55_;
									vala_report_error (_tmp51_, _tmp56_);
									_g_free0 (_tmp56_);
									_vala_source_reference_unref0 (_tmp51_);
									vala_gir_parser_skip_element (self);
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "interface");
	_vala_code_node_unref0 (iface);
}

static void
vala_gir_parser_parse_field (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp6_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	gint array_length_idx = 0;
	ValaDataType* type = NULL;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	gchar* name = NULL;
	ValaGirParserNode* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* cname = NULL;
	ValaGirParserNode* _tmp16_;
	ValaMap* _tmp17_;
	gpointer _tmp18_;
	ValaField* field = NULL;
	const gchar* _tmp19_;
	ValaDataType* _tmp20_;
	ValaGirParserNode* _tmp21_;
	ValaSourceReference* _tmp22_;
	ValaField* _tmp23_;
	ValaField* _tmp24_;
	ValaField* _tmp25_;
	ValaGirComment* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	ValaDataType* _tmp31_;
	gboolean _tmp37_ = FALSE;
	const gchar* _tmp38_;
	ValaGirParserNode* _tmp41_;
	ValaField* _tmp42_;
	ValaSymbol* _tmp43_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "field");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, FALSE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "nullable");
	nullable = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "allow-none");
	allow_none = _tmp5_;
	vala_gir_parser_next (self);
	_tmp6_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp6_;
	_tmp10_ = vala_gir_parser_parse_type (self, NULL, &_tmp7_, TRUE, &_tmp8_, &_tmp9_);
	array_length_idx = _tmp7_;
	no_array_length = _tmp8_;
	array_null_terminated = _tmp9_;
	type = _tmp10_;
	_tmp11_ = type;
	_tmp12_ = vala_gir_parser_element_get_type (self, _tmp11_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp12_;
	_tmp13_ = self->priv->current;
	_tmp14_ = _tmp13_->name;
	_tmp15_ = g_strdup (_tmp14_);
	name = _tmp15_;
	_tmp16_ = self->priv->current;
	_tmp17_ = _tmp16_->girdata;
	_tmp18_ = vala_map_get (_tmp17_, "name");
	cname = (gchar*) _tmp18_;
	_tmp19_ = name;
	_tmp20_ = type;
	_tmp21_ = self->priv->current;
	_tmp22_ = _tmp21_->source_reference;
	_tmp23_ = vala_field_new (_tmp19_, _tmp20_, NULL, _tmp22_, NULL);
	field = _tmp23_;
	_tmp24_ = field;
	vala_symbol_set_access ((ValaSymbol*) _tmp24_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp25_ = field;
	_tmp26_ = comment;
	vala_symbol_set_comment ((ValaSymbol*) _tmp25_, (ValaComment*) _tmp26_);
	_tmp27_ = name;
	_tmp28_ = cname;
	if (g_strcmp0 (_tmp27_, _tmp28_) != 0) {
		ValaField* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = field;
		_tmp30_ = cname;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp29_, "CCode", "cname", _tmp30_, NULL);
	}
	_tmp31_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_ARRAY_TYPE)) {
		gboolean _tmp32_ = FALSE;
		gboolean _tmp34_ = FALSE;
		if (!no_array_length) {
			_tmp32_ = array_length_idx > -1;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaGirParserNode* _tmp33_;
			_tmp33_ = self->priv->current;
			_tmp33_->array_length_idx = array_length_idx;
		}
		if (no_array_length) {
			_tmp34_ = TRUE;
		} else {
			_tmp34_ = array_null_terminated;
		}
		if (_tmp34_) {
			ValaField* _tmp35_;
			_tmp35_ = field;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp35_, "CCode", "array_length", !no_array_length, NULL);
		}
		if (array_null_terminated) {
			ValaField* _tmp36_;
			_tmp36_ = field;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp36_, "CCode", "array_null_terminated", TRUE, NULL);
		}
	}
	_tmp38_ = nullable;
	if (g_strcmp0 (_tmp38_, "1") == 0) {
		_tmp37_ = TRUE;
	} else {
		const gchar* _tmp39_;
		_tmp39_ = allow_none;
		_tmp37_ = g_strcmp0 (_tmp39_, "1") == 0;
	}
	if (_tmp37_) {
		ValaDataType* _tmp40_;
		_tmp40_ = type;
		vala_data_type_set_nullable (_tmp40_, TRUE);
	}
	_tmp41_ = self->priv->current;
	_tmp42_ = field;
	_tmp43_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp42_);
	_vala_code_node_unref0 (_tmp41_->symbol);
	_tmp41_->symbol = _tmp43_;
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "field");
	_vala_code_node_unref0 (field);
	_g_free0 (cname);
	_g_free0 (name);
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
	_g_free0 (allow_none);
	_g_free0 (nullable);
}

static ValaProperty*
vala_gir_parser_parse_property (ValaGirParser* self)
{
	ValaProperty* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean is_abstract = FALSE;
	ValaGirParserMetadata* _tmp4_;
	ValaGirParserNode* _tmp5_;
	ValaGirParserNode* _tmp6_;
	ValaSymbol* _tmp7_;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp8_;
	gchar* _tmp9_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp10_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	ValaDataType* type = NULL;
	const gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaProperty* prop = NULL;
	ValaGirParserNode* _tmp17_;
	const gchar* _tmp18_;
	ValaDataType* _tmp19_;
	ValaGirParserNode* _tmp20_;
	ValaSourceReference* _tmp21_;
	ValaProperty* _tmp22_;
	ValaProperty* _tmp23_;
	ValaGirComment* _tmp24_;
	ValaProperty* _tmp25_;
	ValaProperty* _tmp26_;
	ValaProperty* _tmp27_;
	gboolean _tmp28_ = FALSE;
	ValaGirParserNode* _tmp31_;
	ValaProperty* _tmp32_;
	ValaSymbol* _tmp33_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "property");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "-", "_");
	_tmp3_ = _tmp2_;
	vala_gir_parser_push_node (self, _tmp3_, FALSE);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = self->priv->metadata;
	_tmp5_ = self->priv->current;
	_tmp6_ = _tmp5_->parent;
	_tmp7_ = _tmp6_->symbol;
	is_abstract = vala_gir_parser_metadata_get_bool (_tmp4_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_INTERFACE));
	_tmp8_ = self->priv->reader;
	_tmp9_ = vala_markup_reader_get_attribute (_tmp8_, "transfer-ownership");
	transfer = _tmp9_;
	vala_gir_parser_next (self);
	_tmp10_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp10_;
	_tmp11_ = transfer;
	_tmp14_ = vala_gir_parser_parse_type (self, NULL, NULL, g_strcmp0 (_tmp11_, "container") != 0, &_tmp12_, &_tmp13_);
	no_array_length = _tmp12_;
	array_null_terminated = _tmp13_;
	type = _tmp14_;
	_tmp15_ = type;
	_tmp16_ = vala_gir_parser_element_get_type (self, _tmp15_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp16_;
	_tmp17_ = self->priv->current;
	_tmp18_ = _tmp17_->name;
	_tmp19_ = type;
	_tmp20_ = self->priv->current;
	_tmp21_ = _tmp20_->source_reference;
	_tmp22_ = vala_property_new (_tmp18_, _tmp19_, NULL, NULL, _tmp21_, NULL);
	prop = _tmp22_;
	_tmp23_ = prop;
	_tmp24_ = comment;
	vala_symbol_set_comment ((ValaSymbol*) _tmp23_, (ValaComment*) _tmp24_);
	_tmp25_ = prop;
	vala_symbol_set_access ((ValaSymbol*) _tmp25_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp26_ = prop;
	vala_symbol_set_external ((ValaSymbol*) _tmp26_, TRUE);
	_tmp27_ = prop;
	vala_property_set_is_abstract (_tmp27_, is_abstract);
	if (no_array_length) {
		_tmp28_ = TRUE;
	} else {
		_tmp28_ = array_null_terminated;
	}
	if (_tmp28_) {
		ValaProperty* _tmp29_;
		_tmp29_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp29_, "CCode", "array_length", !no_array_length, NULL);
	}
	if (array_null_terminated) {
		ValaProperty* _tmp30_;
		_tmp30_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp30_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	_tmp31_ = self->priv->current;
	_tmp32_ = prop;
	_tmp33_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp32_);
	_vala_code_node_unref0 (_tmp31_->symbol);
	_tmp31_->symbol = _tmp33_;
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "property");
	result = prop;
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
	_g_free0 (transfer);
	return result;
}

static void
vala_gir_parser_parse_callback (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "callback");
}

static void
vala_gir_parser_parse_constructor (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "constructor");
}

static void
vala_gir_parser_parse_function (ValaGirParser* self,
                                const gchar* element_name)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* symbol_type = NULL;
	ValaGirParserMetadata* _tmp7_;
	gchar* name = NULL;
	ValaGirParserNode* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* throws_string = NULL;
	ValaMarkupReader* _tmp14_;
	gchar* _tmp15_;
	gchar* invoker = NULL;
	ValaMarkupReader* _tmp16_;
	gchar* _tmp17_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp18_;
	ValaDataType* return_type = NULL;
	gchar* return_ctype = NULL;
	gint return_array_length_idx = 0;
	gboolean return_no_array_length = FALSE;
	gboolean return_array_null_terminated = FALSE;
	gboolean _tmp19_ = FALSE;
	ValaMarkupTokenType _tmp20_;
	ValaSymbol* s = NULL;
	const gchar* _tmp38_;
	ValaSymbol* _tmp95_;
	ValaSymbol* _tmp96_;
	ValaGirComment* _tmp97_;
	ValaSymbol* _tmp98_;
	ValaArrayType* array_type = NULL;
	ValaDataType* _tmp99_;
	ValaArrayType* _tmp100_;
	gboolean _tmp101_ = FALSE;
	ValaArrayType* _tmp102_;
	ValaSymbol* _tmp114_;
	ValaSymbol* _tmp128_;
	gboolean _tmp165_ = FALSE;
	ValaSymbol* _tmp166_;
	ValaGirParserMetadata* _tmp190_;
	ValaExpression* _tmp191_;
	ValaExpression* _tmp192_;
	gboolean _tmp193_;
	ValaSymbol* _tmp223_;
	gboolean _tmp233_ = FALSE;
	ValaDataType* _tmp234_;
	ValaGirParserNode* _tmp240_;
	ValaGirParserNode* _tmp241_;
	ValaSymbol* _tmp242_;
	ValaSymbol* _tmp243_;
	ValaGirParserMetadata* _tmp244_;
	ValaGirParserMetadata* _tmp249_;
	gint instance_idx = 0;
	gboolean _tmp252_ = FALSE;
	ValaArrayList* parameters = NULL;
	GEqualFunc _tmp259_;
	ValaArrayList* _tmp260_;
	ValaGirParserNode* _tmp261_;
	GEqualFunc _tmp262_;
	ValaArrayList* _tmp263_;
	ValaGirParserNode* _tmp264_;
	GEqualFunc _tmp265_;
	ValaArrayList* _tmp266_;
	ValaGirParserNode* _tmp267_;
	GEqualFunc _tmp268_;
	ValaArrayList* _tmp269_;
	gboolean _tmp270_ = FALSE;
	ValaMarkupTokenType _tmp271_;
	ValaGirParserNode* _tmp368_;
	ValaArrayList* _tmp369_;
	ValaList* _tmp370_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "invoker");
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gir_parser_element_get_name (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_replace (_tmp4_, "-", "_");
	_tmp6_ = _tmp5_;
	vala_gir_parser_push_node (self, _tmp6_, FALSE);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp7_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp7_, VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE)) {
		ValaGirParserMetadata* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->priv->metadata;
		_tmp9_ = vala_gir_parser_metadata_get_string (_tmp8_, VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE);
		_g_free0 (symbol_type);
		symbol_type = _tmp9_;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (element_name);
		_g_free0 (symbol_type);
		symbol_type = _tmp10_;
	}
	_tmp11_ = self->priv->current;
	_tmp12_ = _tmp11_->name;
	_tmp13_ = g_strdup (_tmp12_);
	name = _tmp13_;
	_tmp14_ = self->priv->reader;
	_tmp15_ = vala_markup_reader_get_attribute (_tmp14_, "throws");
	throws_string = _tmp15_;
	_tmp16_ = self->priv->reader;
	_tmp17_ = vala_markup_reader_get_attribute (_tmp16_, "invoker");
	invoker = _tmp17_;
	vala_gir_parser_next (self);
	_tmp18_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp18_;
	return_ctype = NULL;
	return_array_length_idx = -1;
	return_no_array_length = FALSE;
	return_array_null_terminated = FALSE;
	_tmp20_ = self->priv->current_token;
	if (_tmp20_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp21_ = self->priv->reader;
		_tmp22_ = vala_markup_reader_get_name (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp19_ = g_strcmp0 (_tmp23_, "return-value") == 0;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		ValaComment* return_comment = NULL;
		gchar* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		ValaComment* _tmp28_ = NULL;
		ValaDataType* _tmp29_;
		ValaComment* _tmp30_;
		_tmp29_ = vala_gir_parser_parse_return_value (self, &_tmp24_, &_tmp25_, &_tmp26_, &_tmp27_, &_tmp28_);
		_g_free0 (return_ctype);
		return_ctype = _tmp24_;
		return_array_length_idx = _tmp25_;
		return_no_array_length = _tmp26_;
		return_array_null_terminated = _tmp27_;
		_vala_comment_unref0 (return_comment);
		return_comment = _tmp28_;
		_vala_code_node_unref0 (return_type);
		return_type = _tmp29_;
		_tmp30_ = return_comment;
		if (_tmp30_ != NULL) {
			ValaGirComment* _tmp31_;
			ValaGirComment* _tmp35_;
			ValaComment* _tmp36_;
			_tmp31_ = comment;
			if (_tmp31_ == NULL) {
				ValaGirParserNode* _tmp32_;
				ValaSourceReference* _tmp33_;
				ValaGirComment* _tmp34_;
				_tmp32_ = self->priv->current;
				_tmp33_ = _tmp32_->source_reference;
				_tmp34_ = vala_gir_comment_new (NULL, _tmp33_);
				_vala_comment_unref0 (comment);
				comment = _tmp34_;
			}
			_tmp35_ = comment;
			_tmp36_ = return_comment;
			vala_gir_comment_set_return_content (_tmp35_, _tmp36_);
		}
		_vala_comment_unref0 (return_comment);
	} else {
		ValaVoidType* _tmp37_;
		_tmp37_ = vala_void_type_new (NULL);
		_vala_code_node_unref0 (return_type);
		return_type = (ValaDataType*) _tmp37_;
	}
	_tmp38_ = symbol_type;
	if (g_strcmp0 (_tmp38_, "callback") == 0) {
		const gchar* _tmp39_;
		ValaDataType* _tmp40_;
		ValaGirParserNode* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaDelegate* _tmp43_;
		ValaSymbol* _tmp44_;
		_tmp39_ = name;
		_tmp40_ = return_type;
		_tmp41_ = self->priv->current;
		_tmp42_ = _tmp41_->source_reference;
		_tmp43_ = vala_delegate_new (_tmp39_, _tmp40_, _tmp42_, NULL);
		_vala_code_node_unref0 (s);
		s = (ValaSymbol*) _tmp43_;
		_tmp44_ = s;
		vala_delegate_set_has_target (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, VALA_TYPE_DELEGATE, ValaDelegate), FALSE);
	} else {
		const gchar* _tmp45_;
		_tmp45_ = symbol_type;
		if (g_strcmp0 (_tmp45_, "constructor") == 0) {
			const gchar* _tmp46_;
			ValaCreationMethod* m = NULL;
			const gchar* _tmp52_;
			ValaGirParserNode* _tmp53_;
			ValaSourceReference* _tmp54_;
			ValaCreationMethod* _tmp55_;
			ValaCreationMethod* _tmp56_;
			gboolean _tmp57_ = FALSE;
			const gchar* _tmp58_;
			gchar* parent_ctype = NULL;
			ValaGirParserNode* _tmp66_;
			ValaGirParserNode* _tmp67_;
			ValaSymbol* _tmp68_;
			gboolean _tmp72_ = FALSE;
			const gchar* _tmp73_;
			ValaCreationMethod* _tmp82_;
			ValaSymbol* _tmp83_;
			_tmp46_ = name;
			if (g_strcmp0 (_tmp46_, "new") == 0) {
				_g_free0 (name);
				name = NULL;
			} else {
				const gchar* _tmp47_;
				_tmp47_ = name;
				if (g_str_has_prefix (_tmp47_, "new_")) {
					const gchar* _tmp48_;
					gint _tmp49_;
					gint _tmp50_;
					gchar* _tmp51_;
					_tmp48_ = name;
					_tmp49_ = strlen ("new_");
					_tmp50_ = _tmp49_;
					_tmp51_ = string_substring (_tmp48_, (glong) _tmp50_, (glong) -1);
					_g_free0 (name);
					name = _tmp51_;
				}
			}
			_tmp52_ = name;
			_tmp53_ = self->priv->current;
			_tmp54_ = _tmp53_->source_reference;
			_tmp55_ = vala_creation_method_new (NULL, _tmp52_, _tmp54_, NULL);
			m = _tmp55_;
			_tmp56_ = m;
			vala_method_set_has_construct_function ((ValaMethod*) _tmp56_, FALSE);
			_tmp58_ = name;
			if (_tmp58_ != NULL) {
				ValaGirParserNode* _tmp59_;
				const gchar* _tmp60_;
				_tmp59_ = self->priv->current;
				_tmp60_ = _tmp59_->name;
				_tmp57_ = !g_str_has_prefix (_tmp60_, "new_");
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaCreationMethod* _tmp61_;
				ValaGirParserNode* _tmp62_;
				ValaMap* _tmp63_;
				gpointer _tmp64_;
				gchar* _tmp65_;
				_tmp61_ = m;
				_tmp62_ = self->priv->current;
				_tmp63_ = _tmp62_->girdata;
				_tmp64_ = vala_map_get (_tmp63_, "c:identifier");
				_tmp65_ = (gchar*) _tmp64_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp61_, "CCode", "cname", _tmp65_, NULL);
				_g_free0 (_tmp65_);
			}
			parent_ctype = NULL;
			_tmp66_ = self->priv->current;
			_tmp67_ = _tmp66_->parent;
			_tmp68_ = _tmp67_->symbol;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, VALA_TYPE_CLASS)) {
				ValaGirParserNode* _tmp69_;
				ValaGirParserNode* _tmp70_;
				gchar* _tmp71_;
				_tmp69_ = self->priv->current;
				_tmp70_ = _tmp69_->parent;
				_tmp71_ = vala_gir_parser_node_get_cname (_tmp70_);
				_g_free0 (parent_ctype);
				parent_ctype = _tmp71_;
			}
			_tmp73_ = return_ctype;
			if (_tmp73_ != NULL) {
				gboolean _tmp74_ = FALSE;
				const gchar* _tmp75_;
				_tmp75_ = parent_ctype;
				if (_tmp75_ == NULL) {
					_tmp74_ = TRUE;
				} else {
					const gchar* _tmp76_;
					const gchar* _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					_tmp76_ = return_ctype;
					_tmp77_ = parent_ctype;
					_tmp78_ = g_strconcat (_tmp77_, "*", NULL);
					_tmp79_ = _tmp78_;
					_tmp74_ = g_strcmp0 (_tmp76_, _tmp79_) != 0;
					_g_free0 (_tmp79_);
				}
				_tmp72_ = _tmp74_;
			} else {
				_tmp72_ = FALSE;
			}
			if (_tmp72_) {
				ValaCreationMethod* _tmp80_;
				const gchar* _tmp81_;
				_tmp80_ = m;
				_tmp81_ = return_ctype;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp80_, "CCode", "type", _tmp81_, NULL);
			}
			_tmp82_ = m;
			_tmp83_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp82_);
			_vala_code_node_unref0 (s);
			s = _tmp83_;
			_g_free0 (parent_ctype);
			_vala_code_node_unref0 (m);
		} else {
			const gchar* _tmp84_;
			_tmp84_ = symbol_type;
			if (g_strcmp0 (_tmp84_, "glib:signal") == 0) {
				const gchar* _tmp85_;
				ValaDataType* _tmp86_;
				ValaGirParserNode* _tmp87_;
				ValaSourceReference* _tmp88_;
				ValaSignal* _tmp89_;
				_tmp85_ = name;
				_tmp86_ = return_type;
				_tmp87_ = self->priv->current;
				_tmp88_ = _tmp87_->source_reference;
				_tmp89_ = vala_signal_new (_tmp85_, _tmp86_, _tmp88_, NULL);
				_vala_code_node_unref0 (s);
				s = (ValaSymbol*) _tmp89_;
			} else {
				const gchar* _tmp90_;
				ValaDataType* _tmp91_;
				ValaGirParserNode* _tmp92_;
				ValaSourceReference* _tmp93_;
				ValaMethod* _tmp94_;
				_tmp90_ = name;
				_tmp91_ = return_type;
				_tmp92_ = self->priv->current;
				_tmp93_ = _tmp92_->source_reference;
				_tmp94_ = vala_method_new (_tmp90_, _tmp91_, _tmp93_, NULL);
				_vala_code_node_unref0 (s);
				s = (ValaSymbol*) _tmp94_;
			}
		}
	}
	_tmp95_ = s;
	vala_symbol_set_access (_tmp95_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp96_ = s;
	_tmp97_ = comment;
	vala_symbol_set_comment (_tmp96_, (ValaComment*) _tmp97_);
	_tmp98_ = s;
	vala_symbol_set_external (_tmp98_, TRUE);
	_tmp99_ = return_type;
	_tmp100_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp99_) : NULL);
	array_type = _tmp100_;
	_tmp102_ = array_type;
	if (_tmp102_ != NULL) {
		ValaArrayType* _tmp103_;
		gboolean _tmp104_;
		gboolean _tmp105_;
		_tmp103_ = array_type;
		_tmp104_ = vala_array_type_get_fixed_length (_tmp103_);
		_tmp105_ = _tmp104_;
		_tmp101_ = _tmp105_;
	} else {
		_tmp101_ = FALSE;
	}
	if (_tmp101_) {
		ValaSymbol* _tmp106_;
		ValaArrayType* _tmp107_;
		ValaExpression* _tmp108_;
		ValaExpression* _tmp109_;
		const gchar* _tmp110_;
		const gchar* _tmp111_;
		ValaArrayType* _tmp112_;
		ValaArrayType* _tmp113_;
		_tmp106_ = s;
		_tmp107_ = array_type;
		_tmp108_ = vala_array_type_get_length (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
		_tmp111_ = _tmp110_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp106_, "CCode", "array_length_cexpr", _tmp111_, NULL);
		_tmp112_ = array_type;
		vala_array_type_set_fixed_length (_tmp112_, FALSE);
		_tmp113_ = array_type;
		vala_array_type_set_length (_tmp113_, NULL);
	}
	_tmp114_ = s;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp114_, VALA_TYPE_SIGNAL)) {
		ValaGirParserNode* _tmp115_;
		ValaMap* _tmp116_;
		gpointer _tmp117_;
		gchar* _tmp118_;
		const gchar* _tmp119_;
		gchar* _tmp120_;
		gchar* _tmp121_;
		gboolean _tmp122_;
		_tmp115_ = self->priv->current;
		_tmp116_ = _tmp115_->girdata;
		_tmp117_ = vala_map_get (_tmp116_, "name");
		_tmp118_ = (gchar*) _tmp117_;
		_tmp119_ = name;
		_tmp120_ = string_replace (_tmp119_, "_", "-");
		_tmp121_ = _tmp120_;
		_tmp122_ = g_strcmp0 (_tmp118_, _tmp121_) != 0;
		_g_free0 (_tmp121_);
		_g_free0 (_tmp118_);
		if (_tmp122_) {
			ValaSymbol* _tmp123_;
			ValaGirParserNode* _tmp124_;
			ValaMap* _tmp125_;
			gpointer _tmp126_;
			gchar* _tmp127_;
			_tmp123_ = s;
			_tmp124_ = self->priv->current;
			_tmp125_ = _tmp124_->girdata;
			_tmp126_ = vala_map_get (_tmp125_, "name");
			_tmp127_ = (gchar*) _tmp126_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp123_, "CCode", "cname", _tmp127_, NULL);
			_g_free0 (_tmp127_);
		}
	}
	_tmp128_ = s;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp128_, VALA_TYPE_METHOD)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp129_;
		ValaMethod* _tmp130_;
		gboolean _tmp131_ = FALSE;
		const gchar* _tmp132_;
		ValaGirParserMetadata* _tmp159_;
		_tmp129_ = s;
		_tmp130_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp130_;
		_tmp132_ = symbol_type;
		if (g_strcmp0 (_tmp132_, "virtual-method") == 0) {
			_tmp131_ = TRUE;
		} else {
			const gchar* _tmp133_;
			_tmp133_ = symbol_type;
			_tmp131_ = g_strcmp0 (_tmp133_, "callback") == 0;
		}
		if (_tmp131_) {
			ValaGirParserNode* _tmp134_;
			ValaGirParserNode* _tmp135_;
			ValaSymbol* _tmp136_;
			gboolean _tmp139_ = FALSE;
			const gchar* _tmp140_;
			ValaGirParserNode* _tmp146_;
			ValaMap* _tmp147_;
			gpointer _tmp148_;
			gchar* _tmp149_;
			const gchar* _tmp150_;
			gboolean _tmp151_;
			_tmp134_ = self->priv->current;
			_tmp135_ = _tmp134_->parent;
			_tmp136_ = _tmp135_->symbol;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp136_, VALA_TYPE_INTERFACE)) {
				ValaMethod* _tmp137_;
				_tmp137_ = m;
				vala_method_set_is_abstract (_tmp137_, TRUE);
			} else {
				ValaMethod* _tmp138_;
				_tmp138_ = m;
				vala_method_set_is_virtual (_tmp138_, TRUE);
			}
			_tmp140_ = invoker;
			if (_tmp140_ == NULL) {
				ValaGirParserMetadata* _tmp141_;
				_tmp141_ = self->priv->metadata;
				_tmp139_ = !vala_gir_parser_metadata_has_argument (_tmp141_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
			} else {
				_tmp139_ = FALSE;
			}
			if (_tmp139_) {
				ValaSymbol* _tmp142_;
				ValaSymbol* _tmp143_;
				ValaSourceReference* _tmp144_;
				ValaSourceReference* _tmp145_;
				_tmp142_ = s;
				_tmp143_ = s;
				_tmp144_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp143_);
				_tmp145_ = _tmp144_;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp142_, "NoWrapper", TRUE, _tmp145_);
			}
			_tmp146_ = self->priv->current;
			_tmp147_ = _tmp146_->girdata;
			_tmp148_ = vala_map_get (_tmp147_, "name");
			_tmp149_ = (gchar*) _tmp148_;
			_tmp150_ = name;
			_tmp151_ = g_strcmp0 (_tmp149_, _tmp150_) != 0;
			_g_free0 (_tmp149_);
			if (_tmp151_) {
				ValaMethod* _tmp152_;
				ValaGirParserNode* _tmp153_;
				ValaMap* _tmp154_;
				gpointer _tmp155_;
				gchar* _tmp156_;
				_tmp152_ = m;
				_tmp153_ = self->priv->current;
				_tmp154_ = _tmp153_->girdata;
				_tmp155_ = vala_map_get (_tmp154_, "name");
				_tmp156_ = (gchar*) _tmp155_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp152_, "CCode", "vfunc_name", _tmp156_, NULL);
				_g_free0 (_tmp156_);
			}
		} else {
			const gchar* _tmp157_;
			_tmp157_ = symbol_type;
			if (g_strcmp0 (_tmp157_, "function") == 0) {
				ValaMethod* _tmp158_;
				_tmp158_ = m;
				vala_method_set_binding (_tmp158_, VALA_MEMBER_BINDING_STATIC);
			}
		}
		_tmp159_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp159_, VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING)) {
			ValaMethod* _tmp160_;
			ValaGirParserMetadata* _tmp161_;
			ValaMethod* _tmp162_;
			ValaDataType* _tmp163_;
			ValaDataType* _tmp164_;
			_tmp160_ = m;
			_tmp161_ = self->priv->metadata;
			vala_method_set_returns_floating_reference (_tmp160_, vala_gir_parser_metadata_get_bool (_tmp161_, VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING, FALSE));
			_tmp162_ = m;
			_tmp163_ = vala_callable_get_return_type ((ValaCallable*) _tmp162_);
			_tmp164_ = _tmp163_;
			vala_data_type_set_value_owned (_tmp164_, TRUE);
		}
		_vala_code_node_unref0 (m);
	}
	_tmp166_ = s;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp166_, VALA_TYPE_METHOD)) {
		ValaSymbol* _tmp167_;
		_tmp167_ = s;
		_tmp165_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp167_, VALA_TYPE_CREATION_METHOD);
	} else {
		_tmp165_ = FALSE;
	}
	if (_tmp165_) {
		ValaMethod* method = NULL;
		ValaSymbol* _tmp168_;
		ValaMethod* _tmp169_;
		ValaGirParserMetadata* _tmp170_;
		ValaGirParserMetadata* _tmp178_;
		ValaGirParserMetadata* _tmp184_;
		_tmp168_ = s;
		_tmp169_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp168_, VALA_TYPE_METHOD, ValaMethod));
		method = _tmp169_;
		_tmp170_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp170_, VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL)) {
			ValaMethod* _tmp171_;
			ValaGirParserMetadata* _tmp172_;
			ValaMethod* _tmp173_;
			_tmp171_ = method;
			_tmp172_ = self->priv->metadata;
			vala_method_set_is_virtual (_tmp171_, vala_gir_parser_metadata_get_bool (_tmp172_, VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL, FALSE));
			_tmp173_ = method;
			vala_method_set_is_abstract (_tmp173_, FALSE);
		} else {
			ValaGirParserMetadata* _tmp174_;
			_tmp174_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp174_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT)) {
				ValaMethod* _tmp175_;
				ValaGirParserMetadata* _tmp176_;
				ValaMethod* _tmp177_;
				_tmp175_ = method;
				_tmp176_ = self->priv->metadata;
				vala_method_set_is_abstract (_tmp175_, vala_gir_parser_metadata_get_bool (_tmp176_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, FALSE));
				_tmp177_ = method;
				vala_method_set_is_virtual (_tmp177_, FALSE);
			}
		}
		_tmp178_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp178_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME)) {
			ValaMethod* _tmp179_;
			ValaGirParserMetadata* _tmp180_;
			gchar* _tmp181_;
			gchar* _tmp182_;
			ValaMethod* _tmp183_;
			_tmp179_ = method;
			_tmp180_ = self->priv->metadata;
			_tmp181_ = vala_gir_parser_metadata_get_string (_tmp180_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
			_tmp182_ = _tmp181_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp179_, "CCode", "vfunc_name", _tmp182_, NULL);
			_g_free0 (_tmp182_);
			_tmp183_ = method;
			vala_method_set_is_virtual (_tmp183_, TRUE);
		}
		_tmp184_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp184_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME)) {
			ValaMethod* _tmp185_;
			ValaGirParserMetadata* _tmp186_;
			gchar* _tmp187_;
			gchar* _tmp188_;
			ValaMethod* _tmp189_;
			_tmp185_ = method;
			_tmp186_ = self->priv->metadata;
			_tmp187_ = vala_gir_parser_metadata_get_string (_tmp186_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME);
			_tmp188_ = _tmp187_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp185_, "CCode", "finish_vfunc_name", _tmp188_, NULL);
			_g_free0 (_tmp188_);
			_tmp189_ = method;
			vala_method_set_is_virtual (_tmp189_, TRUE);
		}
		_vala_code_node_unref0 (method);
	}
	_tmp190_ = self->priv->metadata;
	_tmp191_ = vala_gir_parser_metadata_get_expression (_tmp190_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
	_tmp192_ = _tmp191_;
	_tmp193_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp192_, VALA_TYPE_NULL_LITERAL);
	_vala_code_node_unref0 (_tmp192_);
	if (_tmp193_) {
		ValaGirParserMetadata* _tmp194_;
		_tmp194_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp194_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS)) {
			gchar** error_types = NULL;
			ValaGirParserMetadata* _tmp195_;
			gchar* _tmp196_;
			gchar* _tmp197_;
			gchar** _tmp198_;
			gchar** _tmp199_;
			gchar** _tmp200_;
			gint _tmp200__length1;
			gint error_types_length1;
			gint _error_types_size_;
			gchar** _tmp201_;
			gint _tmp201__length1;
			gchar* _tmp214_;
			_tmp195_ = self->priv->metadata;
			_tmp196_ = vala_gir_parser_metadata_get_string (_tmp195_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
			_tmp197_ = _tmp196_;
			_tmp199_ = _tmp198_ = g_strsplit (_tmp197_, ",", 0);
			_tmp200_ = _tmp199_;
			_tmp200__length1 = _vala_array_length (_tmp198_);
			_g_free0 (_tmp197_);
			error_types = _tmp200_;
			error_types_length1 = _tmp200__length1;
			_error_types_size_ = error_types_length1;
			_tmp201_ = error_types;
			_tmp201__length1 = error_types_length1;
			{
				gchar** error_type_name_collection = NULL;
				gint error_type_name_collection_length1 = 0;
				gint _error_type_name_collection_size_ = 0;
				gint error_type_name_it = 0;
				error_type_name_collection = _tmp201_;
				error_type_name_collection_length1 = _tmp201__length1;
				for (error_type_name_it = 0; error_type_name_it < _tmp201__length1; error_type_name_it = error_type_name_it + 1) {
					gchar* _tmp202_;
					gchar* error_type_name = NULL;
					_tmp202_ = g_strdup (error_type_name_collection[error_type_name_it]);
					error_type_name = _tmp202_;
					{
						ValaDataType* error_type = NULL;
						const gchar* _tmp203_;
						ValaGirParserMetadata* _tmp204_;
						ValaSourceReference* _tmp205_;
						ValaSourceReference* _tmp206_;
						ValaDataType* _tmp207_;
						ValaDataType* _tmp208_;
						ValaSymbol* _tmp209_;
						_tmp203_ = error_type_name;
						_tmp204_ = self->priv->metadata;
						_tmp205_ = vala_gir_parser_metadata_get_source_reference (_tmp204_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
						_tmp206_ = _tmp205_;
						_tmp207_ = vala_gir_parser_parse_type_from_string (self, _tmp203_, TRUE, _tmp206_);
						_tmp208_ = _tmp207_;
						_vala_source_reference_unref0 (_tmp206_);
						error_type = _tmp208_;
						_tmp209_ = s;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp209_, VALA_TYPE_METHOD)) {
							ValaSymbol* _tmp210_;
							ValaDataType* _tmp211_;
							_tmp210_ = s;
							_tmp211_ = error_type;
							vala_method_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp210_, VALA_TYPE_METHOD, ValaMethod), _tmp211_);
						} else {
							ValaSymbol* _tmp212_;
							ValaDataType* _tmp213_;
							_tmp212_ = s;
							_tmp213_ = error_type;
							vala_delegate_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp212_, VALA_TYPE_DELEGATE, ValaDelegate), _tmp213_);
						}
						_vala_code_node_unref0 (error_type);
						_g_free0 (error_type_name);
					}
				}
			}
			_tmp214_ = g_strdup ("1");
			_g_free0 (throws_string);
			throws_string = _tmp214_;
			error_types = (_vala_array_free (error_types, error_types_length1, (GDestroyNotify) g_free), NULL);
		} else {
			const gchar* _tmp215_;
			_tmp215_ = throws_string;
			if (g_strcmp0 (_tmp215_, "1") == 0) {
				ValaSymbol* _tmp216_;
				_tmp216_ = s;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp216_, VALA_TYPE_METHOD)) {
					ValaSymbol* _tmp217_;
					ValaErrorType* _tmp218_;
					ValaErrorType* _tmp219_;
					_tmp217_ = s;
					_tmp218_ = vala_error_type_new (NULL, NULL, NULL);
					_tmp219_ = _tmp218_;
					vala_method_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp217_, VALA_TYPE_METHOD, ValaMethod), (ValaDataType*) _tmp219_);
					_vala_code_node_unref0 (_tmp219_);
				} else {
					ValaSymbol* _tmp220_;
					ValaErrorType* _tmp221_;
					ValaErrorType* _tmp222_;
					_tmp220_ = s;
					_tmp221_ = vala_error_type_new (NULL, NULL, NULL);
					_tmp222_ = _tmp221_;
					vala_delegate_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp220_, VALA_TYPE_DELEGATE, ValaDelegate), (ValaDataType*) _tmp222_);
					_vala_code_node_unref0 (_tmp222_);
				}
			}
		}
	}
	_tmp223_ = s;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp223_, VALA_TYPE_METHOD)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp224_;
		ValaMethod* _tmp225_;
		ValaMethod* _tmp226_;
		ValaGirParserMetadata* _tmp227_;
		ValaGirParserMetadata* _tmp228_;
		_tmp224_ = s;
		_tmp225_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp224_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp225_;
		_tmp226_ = m;
		_tmp227_ = self->priv->metadata;
		vala_code_node_set_attribute ((ValaCodeNode*) _tmp226_, "PrintfFormat", vala_gir_parser_metadata_get_bool (_tmp227_, VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT, FALSE), NULL);
		_tmp228_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp228_, VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL)) {
			ValaMethod* _tmp229_;
			ValaGirParserMetadata* _tmp230_;
			gchar* _tmp231_;
			gchar* _tmp232_;
			_tmp229_ = m;
			_tmp230_ = self->priv->metadata;
			_tmp231_ = vala_gir_parser_metadata_get_string (_tmp230_, VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL);
			_tmp232_ = _tmp231_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp229_, "CCode", "sentinel", _tmp232_, NULL);
			_g_free0 (_tmp232_);
		}
		_vala_code_node_unref0 (m);
	}
	_tmp234_ = return_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp234_, VALA_TYPE_ARRAY_TYPE)) {
		ValaGirParserMetadata* _tmp235_;
		_tmp235_ = self->priv->metadata;
		_tmp233_ = vala_gir_parser_metadata_has_argument (_tmp235_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
	} else {
		_tmp233_ = FALSE;
	}
	if (_tmp233_) {
		ValaGirParserMetadata* _tmp236_;
		_tmp236_ = self->priv->metadata;
		return_array_length_idx = vala_gir_parser_metadata_get_integer (_tmp236_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
	} else {
		gboolean _tmp237_ = FALSE;
		if (return_no_array_length) {
			_tmp237_ = TRUE;
		} else {
			_tmp237_ = return_array_null_terminated;
		}
		if (_tmp237_) {
			ValaSymbol* _tmp238_;
			_tmp238_ = s;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp238_, "CCode", "array_length", !return_no_array_length, NULL);
		}
		if (return_array_null_terminated) {
			ValaSymbol* _tmp239_;
			_tmp239_ = s;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp239_, "CCode", "array_null_terminated", TRUE, NULL);
		}
	}
	_tmp240_ = self->priv->current;
	_tmp240_->return_array_length_idx = return_array_length_idx;
	_tmp241_ = self->priv->current;
	_tmp242_ = s;
	_tmp243_ = _vala_code_node_ref0 (_tmp242_);
	_vala_code_node_unref0 (_tmp241_->symbol);
	_tmp241_->symbol = _tmp243_;
	_tmp244_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp244_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME)) {
		ValaSymbol* _tmp245_;
		ValaGirParserMetadata* _tmp246_;
		gchar* _tmp247_;
		gchar* _tmp248_;
		_tmp245_ = s;
		_tmp246_ = self->priv->metadata;
		_tmp247_ = vala_gir_parser_metadata_get_string (_tmp246_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME);
		_tmp248_ = _tmp247_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp245_, "CCode", "finish_name", _tmp248_, NULL);
		_g_free0 (_tmp248_);
	}
	_tmp249_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp249_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE)) {
		ValaSymbol* _tmp250_;
		ValaGirParserMetadata* _tmp251_;
		_tmp250_ = s;
		_tmp251_ = self->priv->metadata;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp250_, "CCode", "finish_instance", vala_gir_parser_metadata_get_bool (_tmp251_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE, FALSE), NULL);
	}
	instance_idx = -2;
	if (g_strcmp0 (element_name, "function") == 0) {
		const gchar* _tmp253_;
		_tmp253_ = symbol_type;
		_tmp252_ = g_strcmp0 (_tmp253_, "method") == 0;
	} else {
		_tmp252_ = FALSE;
	}
	if (_tmp252_) {
		ValaGirParserMetadata* _tmp254_;
		_tmp254_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp254_, VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX)) {
			ValaGirParserMetadata* _tmp255_;
			_tmp255_ = self->priv->metadata;
			instance_idx = vala_gir_parser_metadata_get_integer (_tmp255_, VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX);
			if (instance_idx != 0) {
				ValaSymbol* _tmp256_;
				_tmp256_ = s;
				vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp256_, "CCode", "instance_pos", instance_idx + 0.5, NULL);
			}
		} else {
			ValaSourceReference* _tmp257_;
			ValaSourceReference* _tmp258_;
			_tmp257_ = vala_gir_parser_get_current_src (self);
			_tmp258_ = _tmp257_;
			vala_report_error (_tmp258_, "instance_idx required when converting function to method");
			_vala_source_reference_unref0 (_tmp258_);
		}
	}
	_tmp259_ = g_direct_equal;
	_tmp260_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_PARAMETER_INFO, (GBoxedCopyFunc) vala_gir_parser_parameter_info_ref, (GDestroyNotify) vala_gir_parser_parameter_info_unref, _tmp259_);
	parameters = _tmp260_;
	_tmp261_ = self->priv->current;
	_tmp262_ = g_direct_equal;
	_tmp263_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp262_);
	_vala_iterable_unref0 (_tmp261_->array_length_parameters);
	_tmp261_->array_length_parameters = _tmp263_;
	_tmp264_ = self->priv->current;
	_tmp265_ = g_direct_equal;
	_tmp266_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp265_);
	_vala_iterable_unref0 (_tmp264_->closure_parameters);
	_tmp264_->closure_parameters = _tmp266_;
	_tmp267_ = self->priv->current;
	_tmp268_ = g_direct_equal;
	_tmp269_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp268_);
	_vala_iterable_unref0 (_tmp267_->destroy_parameters);
	_tmp267_->destroy_parameters = _tmp269_;
	_tmp271_ = self->priv->current_token;
	if (_tmp271_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp272_;
		const gchar* _tmp273_;
		const gchar* _tmp274_;
		_tmp272_ = self->priv->reader;
		_tmp273_ = vala_markup_reader_get_name (_tmp272_);
		_tmp274_ = _tmp273_;
		_tmp270_ = g_strcmp0 (_tmp274_, "parameters") == 0;
	} else {
		_tmp270_ = FALSE;
	}
	if (_tmp270_) {
		gint current_parameter_idx = 0;
		vala_gir_parser_start_element (self, "parameters");
		vala_gir_parser_next (self);
		current_parameter_idx = -1;
		while (TRUE) {
			ValaMarkupTokenType _tmp275_;
			gint _tmp276_;
			gboolean _tmp277_ = FALSE;
			ValaMarkupReader* _tmp278_;
			const gchar* _tmp279_;
			const gchar* _tmp280_;
			gboolean _tmp284_ = FALSE;
			gint array_length_idx = 0;
			gint closure_idx = 0;
			gint destroy_idx = 0;
			gchar* scope = NULL;
			gchar* default_param_name = NULL;
			ValaComment* param_comment = NULL;
			ValaArrayList* _tmp285_;
			gint _tmp286_;
			gint _tmp287_;
			gchar* _tmp288_;
			ValaParameter* param = NULL;
			const gchar* _tmp289_;
			gint _tmp290_ = 0;
			gint _tmp291_ = 0;
			gint _tmp292_ = 0;
			gchar* _tmp293_ = NULL;
			ValaComment* _tmp294_ = NULL;
			ValaParameter* _tmp295_;
			ValaComment* _tmp312_;
			ValaGirParserParameterInfo* info = NULL;
			ValaParameter* _tmp329_;
			const gchar* _tmp330_;
			ValaGirParserParameterInfo* _tmp331_;
			ValaUnresolvedType* unresolved_type = NULL;
			ValaParameter* _tmp332_;
			ValaDataType* _tmp333_;
			ValaDataType* _tmp334_;
			gboolean _tmp335_ = FALSE;
			ValaSymbol* _tmp336_;
			gboolean _tmp347_ = FALSE;
			gboolean _tmp348_ = FALSE;
			ValaSymbol* _tmp349_;
			ValaArrayList* _tmp366_;
			ValaGirParserParameterInfo* _tmp367_;
			_tmp275_ = self->priv->current_token;
			if (!(_tmp275_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
				break;
			}
			_tmp276_ = current_parameter_idx;
			current_parameter_idx = _tmp276_ + 1;
			_tmp278_ = self->priv->reader;
			_tmp279_ = vala_markup_reader_get_name (_tmp278_);
			_tmp280_ = _tmp279_;
			if (g_strcmp0 (_tmp280_, "instance-parameter") == 0) {
				gboolean _tmp281_ = FALSE;
				const gchar* _tmp282_;
				_tmp282_ = symbol_type;
				if (g_strcmp0 (_tmp282_, "function") == 0) {
					_tmp281_ = TRUE;
				} else {
					const gchar* _tmp283_;
					_tmp283_ = symbol_type;
					_tmp281_ = g_strcmp0 (_tmp283_, "constructor") == 0;
				}
				_tmp277_ = !_tmp281_;
			} else {
				_tmp277_ = FALSE;
			}
			if (_tmp277_) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			if (instance_idx > -2) {
				_tmp284_ = instance_idx == current_parameter_idx;
			} else {
				_tmp284_ = FALSE;
			}
			if (_tmp284_) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			if (!vala_gir_parser_push_metadata (self)) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			default_param_name = NULL;
			_tmp285_ = parameters;
			_tmp286_ = vala_collection_get_size ((ValaCollection*) _tmp285_);
			_tmp287_ = _tmp286_;
			_tmp288_ = g_strdup_printf ("arg%d", _tmp287_);
			_g_free0 (default_param_name);
			default_param_name = _tmp288_;
			_tmp289_ = default_param_name;
			_tmp295_ = vala_gir_parser_parse_parameter (self, &_tmp290_, &_tmp291_, &_tmp292_, &_tmp293_, &_tmp294_, _tmp289_);
			array_length_idx = _tmp290_;
			closure_idx = _tmp291_;
			destroy_idx = _tmp292_;
			_g_free0 (scope);
			scope = _tmp293_;
			_vala_comment_unref0 (param_comment);
			param_comment = _tmp294_;
			param = _tmp295_;
			if (array_length_idx != -1) {
				gboolean _tmp296_ = FALSE;
				ValaGirParserNode* _tmp298_;
				ValaArrayList* _tmp299_;
				if (instance_idx > -2) {
					_tmp296_ = instance_idx < array_length_idx;
				} else {
					_tmp296_ = FALSE;
				}
				if (_tmp296_) {
					gint _tmp297_;
					_tmp297_ = array_length_idx;
					array_length_idx = _tmp297_ - 1;
				}
				_tmp298_ = self->priv->current;
				_tmp299_ = _tmp298_->array_length_parameters;
				vala_collection_add ((ValaCollection*) _tmp299_, (gpointer) ((gintptr) array_length_idx));
			}
			if (closure_idx != -1) {
				gboolean _tmp300_ = FALSE;
				ValaGirParserNode* _tmp302_;
				ValaArrayList* _tmp303_;
				if (instance_idx > -2) {
					_tmp300_ = instance_idx < closure_idx;
				} else {
					_tmp300_ = FALSE;
				}
				if (_tmp300_) {
					gint _tmp301_;
					_tmp301_ = closure_idx;
					closure_idx = _tmp301_ - 1;
				}
				_tmp302_ = self->priv->current;
				_tmp303_ = _tmp302_->closure_parameters;
				if (vala_list_index_of ((ValaList*) _tmp303_, (gpointer) ((gintptr) current_parameter_idx)) < 0) {
					ValaGirParserNode* _tmp304_;
					ValaArrayList* _tmp305_;
					_tmp304_ = self->priv->current;
					_tmp305_ = _tmp304_->closure_parameters;
					vala_collection_add ((ValaCollection*) _tmp305_, (gpointer) ((gintptr) closure_idx));
				}
			}
			if (destroy_idx != -1) {
				gboolean _tmp306_ = FALSE;
				ValaGirParserNode* _tmp308_;
				ValaArrayList* _tmp309_;
				if (instance_idx > -2) {
					_tmp306_ = instance_idx < destroy_idx;
				} else {
					_tmp306_ = FALSE;
				}
				if (_tmp306_) {
					gint _tmp307_;
					_tmp307_ = destroy_idx;
					destroy_idx = _tmp307_ - 1;
				}
				_tmp308_ = self->priv->current;
				_tmp309_ = _tmp308_->destroy_parameters;
				if (vala_list_index_of ((ValaList*) _tmp309_, (gpointer) ((gintptr) current_parameter_idx)) < 0) {
					ValaGirParserNode* _tmp310_;
					ValaArrayList* _tmp311_;
					_tmp310_ = self->priv->current;
					_tmp311_ = _tmp310_->destroy_parameters;
					vala_collection_add ((ValaCollection*) _tmp311_, (gpointer) ((gintptr) destroy_idx));
				}
			}
			_tmp312_ = param_comment;
			if (_tmp312_ != NULL) {
				ValaGirComment* _tmp313_;
				const gchar* _tmp320_ = NULL;
				ValaParameter* _tmp321_;
				gboolean _tmp322_;
				gboolean _tmp323_;
				ValaGirComment* _tmp327_;
				ValaComment* _tmp328_;
				_tmp313_ = comment;
				if (_tmp313_ == NULL) {
					ValaSymbol* _tmp314_;
					ValaSourceReference* _tmp315_;
					ValaSourceReference* _tmp316_;
					ValaGirComment* _tmp317_;
					ValaSymbol* _tmp318_;
					ValaGirComment* _tmp319_;
					_tmp314_ = s;
					_tmp315_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp314_);
					_tmp316_ = _tmp315_;
					_tmp317_ = vala_gir_comment_new (NULL, _tmp316_);
					_vala_comment_unref0 (comment);
					comment = _tmp317_;
					_tmp318_ = s;
					_tmp319_ = comment;
					vala_symbol_set_comment (_tmp318_, (ValaComment*) _tmp319_);
				}
				_tmp321_ = param;
				_tmp322_ = vala_parameter_get_ellipsis (_tmp321_);
				_tmp323_ = _tmp322_;
				if (_tmp323_) {
					_tmp320_ = "...";
				} else {
					ValaParameter* _tmp324_;
					const gchar* _tmp325_;
					const gchar* _tmp326_;
					_tmp324_ = param;
					_tmp325_ = vala_symbol_get_name ((ValaSymbol*) _tmp324_);
					_tmp326_ = _tmp325_;
					_tmp320_ = _tmp326_;
				}
				_tmp327_ = comment;
				_tmp328_ = param_comment;
				vala_gir_comment_add_content_for_parameter (_tmp327_, _tmp320_, _tmp328_);
			}
			_tmp329_ = param;
			_tmp330_ = scope;
			_tmp331_ = vala_gir_parser_parameter_info_new (_tmp329_, array_length_idx, closure_idx, destroy_idx, g_strcmp0 (_tmp330_, "async") == 0);
			info = _tmp331_;
			_tmp332_ = param;
			_tmp333_ = vala_variable_get_variable_type ((ValaVariable*) _tmp332_);
			_tmp334_ = _tmp333_;
			unresolved_type = G_TYPE_CHECK_INSTANCE_TYPE (_tmp334_, VALA_TYPE_UNRESOLVED_TYPE) ? ((ValaUnresolvedType*) _tmp334_) : NULL;
			_tmp336_ = s;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp336_, VALA_TYPE_METHOD)) {
				const gchar* _tmp337_;
				_tmp337_ = scope;
				_tmp335_ = g_strcmp0 (_tmp337_, "async") == 0;
			} else {
				_tmp335_ = FALSE;
			}
			if (_tmp335_) {
				gboolean _tmp338_ = FALSE;
				ValaUnresolvedType* _tmp339_;
				_tmp339_ = unresolved_type;
				if (_tmp339_ != NULL) {
					ValaUnresolvedType* _tmp340_;
					ValaUnresolvedSymbol* _tmp341_;
					ValaUnresolvedSymbol* _tmp342_;
					const gchar* _tmp343_;
					const gchar* _tmp344_;
					_tmp340_ = unresolved_type;
					_tmp341_ = vala_unresolved_type_get_unresolved_symbol (_tmp340_);
					_tmp342_ = _tmp341_;
					_tmp343_ = vala_symbol_get_name ((ValaSymbol*) _tmp342_);
					_tmp344_ = _tmp343_;
					_tmp338_ = g_strcmp0 (_tmp344_, "AsyncReadyCallback") == 0;
				} else {
					_tmp338_ = FALSE;
				}
				if (_tmp338_) {
					ValaSymbol* _tmp345_;
					ValaGirParserParameterInfo* _tmp346_;
					_tmp345_ = s;
					vala_method_set_coroutine (G_TYPE_CHECK_INSTANCE_CAST (_tmp345_, VALA_TYPE_METHOD, ValaMethod), TRUE);
					_tmp346_ = info;
					_tmp346_->keep = FALSE;
				}
			}
			_tmp349_ = s;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp349_, VALA_TYPE_DELEGATE)) {
				const gchar* _tmp350_;
				_tmp350_ = throws_string;
				_tmp348_ = g_strcmp0 (_tmp350_, "1") != 0;
			} else {
				_tmp348_ = FALSE;
			}
			if (_tmp348_) {
				ValaParameter* _tmp351_;
				ValaParameterDirection _tmp352_;
				ValaParameterDirection _tmp353_;
				_tmp351_ = param;
				_tmp352_ = vala_parameter_get_direction (_tmp351_);
				_tmp353_ = _tmp352_;
				_tmp347_ = _tmp353_ == VALA_PARAMETER_DIRECTION_OUT;
			} else {
				_tmp347_ = FALSE;
			}
			if (_tmp347_) {
				gboolean _tmp354_ = FALSE;
				ValaUnresolvedType* _tmp355_;
				_tmp355_ = unresolved_type;
				if (_tmp355_ != NULL) {
					ValaUnresolvedType* _tmp356_;
					ValaUnresolvedSymbol* _tmp357_;
					ValaUnresolvedSymbol* _tmp358_;
					gchar* _tmp359_;
					gchar* _tmp360_;
					_tmp356_ = unresolved_type;
					_tmp357_ = vala_unresolved_type_get_unresolved_symbol (_tmp356_);
					_tmp358_ = _tmp357_;
					_tmp359_ = vala_code_node_to_string ((ValaCodeNode*) _tmp358_);
					_tmp360_ = _tmp359_;
					_tmp354_ = g_strcmp0 (_tmp360_, "GLib.Error") == 0;
					_g_free0 (_tmp360_);
				} else {
					_tmp354_ = FALSE;
				}
				if (_tmp354_) {
					ValaSymbol* _tmp361_;
					ValaErrorType* _tmp362_;
					ValaErrorType* _tmp363_;
					ValaGirParserParameterInfo* _tmp364_;
					ValaGirParserParameterInfo* _tmp365_;
					_tmp361_ = s;
					_tmp362_ = vala_error_type_new (NULL, NULL, NULL);
					_tmp363_ = _tmp362_;
					vala_delegate_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp361_, VALA_TYPE_DELEGATE, ValaDelegate), (ValaDataType*) _tmp363_);
					_vala_code_node_unref0 (_tmp363_);
					_tmp364_ = info;
					_tmp364_->is_error = TRUE;
					_tmp365_ = info;
					_tmp365_->keep = FALSE;
				}
			}
			_tmp366_ = parameters;
			_tmp367_ = info;
			vala_collection_add ((ValaCollection*) _tmp366_, _tmp367_);
			vala_gir_parser_pop_metadata (self);
			_vala_gir_parser_parameter_info_unref0 (info);
			_vala_code_node_unref0 (param);
			_vala_comment_unref0 (param_comment);
			_g_free0 (default_param_name);
			_g_free0 (scope);
		}
		vala_gir_parser_end_element (self, "parameters");
	}
	_tmp368_ = self->priv->current;
	_tmp369_ = parameters;
	_tmp370_ = _vala_iterable_ref0 ((ValaList*) _tmp369_);
	_vala_iterable_unref0 (_tmp368_->parameters);
	_tmp368_->parameters = _tmp370_;
	{
		gint param_n = 0;
		ValaArrayList* _tmp371_;
		gint _tmp372_;
		gint _tmp373_;
		_tmp371_ = parameters;
		_tmp372_ = vala_collection_get_size ((ValaCollection*) _tmp371_);
		_tmp373_ = _tmp372_;
		param_n = _tmp373_ - 1;
		{
			gboolean _tmp374_ = FALSE;
			_tmp374_ = TRUE;
			while (TRUE) {
				ValaGirParserParameterInfo* pi = NULL;
				ValaArrayList* _tmp376_;
				gpointer _tmp377_;
				gboolean _tmp378_ = FALSE;
				ValaGirParserParameterInfo* _tmp379_;
				ValaParameter* _tmp380_;
				gboolean _tmp381_;
				gboolean _tmp382_;
				if (!_tmp374_) {
					gint _tmp375_;
					_tmp375_ = param_n;
					param_n = _tmp375_ - 1;
				}
				_tmp374_ = FALSE;
				if (!(param_n >= 0)) {
					break;
				}
				_tmp376_ = parameters;
				_tmp377_ = vala_list_get ((ValaList*) _tmp376_, param_n);
				pi = (ValaGirParserParameterInfo*) _tmp377_;
				_tmp379_ = pi;
				_tmp380_ = _tmp379_->param;
				_tmp381_ = vala_parameter_get_ellipsis (_tmp380_);
				_tmp382_ = _tmp381_;
				if (!_tmp382_) {
					ValaGirParserParameterInfo* _tmp383_;
					ValaParameter* _tmp384_;
					ValaExpression* _tmp385_;
					ValaExpression* _tmp386_;
					_tmp383_ = pi;
					_tmp384_ = _tmp383_->param;
					_tmp385_ = vala_variable_get_initializer ((ValaVariable*) _tmp384_);
					_tmp386_ = _tmp385_;
					_tmp378_ = _tmp386_ == NULL;
				} else {
					_tmp378_ = FALSE;
				}
				if (_tmp378_) {
					gchar* type_string = NULL;
					ValaGirParserParameterInfo* _tmp387_;
					ValaParameter* _tmp388_;
					ValaDataType* _tmp389_;
					ValaDataType* _tmp390_;
					gchar* _tmp391_;
					const gchar* _tmp392_;
					_tmp387_ = pi;
					_tmp388_ = _tmp387_->param;
					_tmp389_ = vala_variable_get_variable_type ((ValaVariable*) _tmp388_);
					_tmp390_ = _tmp389_;
					_tmp391_ = vala_code_node_to_string ((ValaCodeNode*) _tmp390_);
					type_string = _tmp391_;
					_tmp392_ = type_string;
					if (g_strcmp0 (_tmp392_, "Gio.Cancellable?") == 0) {
						ValaGirParserParameterInfo* _tmp393_;
						ValaParameter* _tmp394_;
						ValaNullLiteral* _tmp395_;
						ValaNullLiteral* _tmp396_;
						_tmp393_ = pi;
						_tmp394_ = _tmp393_->param;
						_tmp395_ = vala_null_literal_new (NULL);
						_tmp396_ = _tmp395_;
						vala_variable_set_initializer ((ValaVariable*) _tmp394_, (ValaExpression*) _tmp396_);
						_vala_code_node_unref0 (_tmp396_);
					} else {
						_g_free0 (type_string);
						_vala_gir_parser_parameter_info_unref0 (pi);
						break;
					}
					_g_free0 (type_string);
				}
				_vala_gir_parser_parameter_info_unref0 (pi);
			}
		}
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_vala_iterable_unref0 (parameters);
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (s);
	_g_free0 (return_ctype);
	_vala_code_node_unref0 (return_type);
	_vala_comment_unref0 (comment);
	_g_free0 (invoker);
	_g_free0 (throws_string);
	_g_free0 (name);
	_g_free0 (symbol_type);
}

static void
vala_gir_parser_parse_method (ValaGirParser* self,
                              const gchar* element_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_parse_function (self, element_name);
}

static void
vala_gir_parser_parse_signal (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "glib:signal");
}

static void
vala_gir_parser_parse_boxed (ValaGirParser* self,
                             const gchar* element_name)
{
	gchar* name = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaClass* cl = NULL;
	gboolean require_copy_free = FALSE;
	ValaGirParserNode* _tmp8_;
	ValaClass* _tmp21_;
	ValaClass* _tmp22_;
	ValaClass* _tmp23_;
	ValaClass* _tmp24_;
	ValaGirParserMetadata* _tmp25_;
	ValaClass* _tmp35_;
	ValaGirComment* _tmp36_;
	ValaGirComment* _tmp37_;
	ValaGirParserNode* ref_method = NULL;
	ValaGirParserNode* unref_method = NULL;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
	gboolean _tmp81_ = FALSE;
	ValaClass* _tmp82_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	name = _tmp1_;
	_tmp2_ = name;
	if (_tmp2_ == NULL) {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:name");
		_g_free0 (name);
		name = _tmp4_;
	}
	_tmp5_ = name;
	_tmp6_ = vala_gir_parser_element_get_name (self, _tmp5_);
	_tmp7_ = _tmp6_;
	vala_gir_parser_push_node (self, _tmp7_, TRUE);
	_g_free0 (_tmp7_);
	require_copy_free = FALSE;
	_tmp8_ = self->priv->current;
	if (_tmp8_->new_symbol) {
		ValaGirParserNode* _tmp9_;
		const gchar* _tmp10_;
		ValaGirParserNode* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaClass* _tmp13_;
		ValaClass* _tmp14_;
		ValaGirParserNode* _tmp15_;
		ValaClass* _tmp16_;
		ValaSymbol* _tmp17_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_->name;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_->source_reference;
		_tmp13_ = vala_class_new (_tmp10_, _tmp12_, NULL);
		_vala_code_node_unref0 (cl);
		cl = _tmp13_;
		_tmp14_ = cl;
		vala_class_set_is_compact (_tmp14_, TRUE);
		_tmp15_ = self->priv->current;
		_tmp16_ = cl;
		_tmp17_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp16_);
		_vala_code_node_unref0 (_tmp15_->symbol);
		_tmp15_->symbol = _tmp17_;
	} else {
		ValaGirParserNode* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaClass* _tmp20_;
		_tmp18_ = self->priv->current;
		_tmp19_ = _tmp18_->symbol;
		_tmp20_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_CLASS, ValaClass));
		_vala_code_node_unref0 (cl);
		cl = _tmp20_;
	}
	_tmp21_ = cl;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp21_);
	_tmp22_ = cl;
	require_copy_free = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp22_, "CCode", "type_id");
	_tmp23_ = cl;
	vala_symbol_set_access ((ValaSymbol*) _tmp23_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp24_ = cl;
	vala_symbol_set_external ((ValaSymbol*) _tmp24_, TRUE);
	_tmp25_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp25_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE)) {
		ValaClass* _tmp26_;
		ValaGirParserMetadata* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		ValaGirParserMetadata* _tmp30_;
		ValaSourceReference* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaDataType* _tmp33_;
		ValaDataType* _tmp34_;
		_tmp26_ = cl;
		_tmp27_ = self->priv->metadata;
		_tmp28_ = vala_gir_parser_metadata_get_string (_tmp27_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp29_ = _tmp28_;
		_tmp30_ = self->priv->metadata;
		_tmp31_ = vala_gir_parser_metadata_get_source_reference (_tmp30_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_gir_parser_parse_type_from_string (self, _tmp29_, TRUE, _tmp32_);
		_tmp34_ = _tmp33_;
		vala_class_add_base_type (_tmp26_, _tmp34_);
		_vala_code_node_unref0 (_tmp34_);
		_vala_source_reference_unref0 (_tmp32_);
		_g_free0 (_tmp29_);
	}
	vala_gir_parser_next (self);
	_tmp35_ = cl;
	_tmp36_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp37_ = _tmp36_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp35_, (ValaComment*) _tmp37_);
	_vala_comment_unref0 (_tmp37_);
	ref_method = NULL;
	unref_method = NULL;
	while (TRUE) {
		ValaMarkupTokenType _tmp38_;
		ValaMarkupReader* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		_tmp38_ = self->priv->current_token;
		if (!(_tmp38_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp39_ = self->priv->reader;
		_tmp40_ = vala_markup_reader_get_name (_tmp39_);
		_tmp41_ = _tmp40_;
		if (g_strcmp0 (_tmp41_, "field") == 0) {
			vala_gir_parser_parse_field (self);
		} else {
			ValaMarkupReader* _tmp42_;
			const gchar* _tmp43_;
			const gchar* _tmp44_;
			_tmp42_ = self->priv->reader;
			_tmp43_ = vala_markup_reader_get_name (_tmp42_);
			_tmp44_ = _tmp43_;
			if (g_strcmp0 (_tmp44_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				_tmp45_ = self->priv->reader;
				_tmp46_ = vala_markup_reader_get_name (_tmp45_);
				_tmp47_ = _tmp46_;
				if (g_strcmp0 (_tmp47_, "method") == 0) {
					gchar* cname = NULL;
					ValaGirParserNode* _tmp48_;
					gchar* _tmp49_;
					gboolean _tmp50_ = FALSE;
					const gchar* _tmp51_;
					vala_gir_parser_parse_method (self, "method");
					_tmp48_ = self->priv->old_current;
					_tmp49_ = vala_gir_parser_node_get_cname (_tmp48_);
					cname = _tmp49_;
					_tmp51_ = cname;
					if (g_str_has_suffix (_tmp51_, "_ref")) {
						gboolean _tmp52_ = FALSE;
						ValaGirParserNode* _tmp53_;
						_tmp53_ = ref_method;
						if (_tmp53_ == NULL) {
							_tmp52_ = TRUE;
						} else {
							ValaGirParserNode* _tmp54_;
							const gchar* _tmp55_;
							_tmp54_ = self->priv->old_current;
							_tmp55_ = _tmp54_->name;
							_tmp52_ = g_strcmp0 (_tmp55_, "ref") == 0;
						}
						_tmp50_ = _tmp52_;
					} else {
						_tmp50_ = FALSE;
					}
					if (_tmp50_) {
						ValaGirParserNode* _tmp56_;
						ValaGirParserNode* _tmp57_;
						_tmp56_ = self->priv->old_current;
						_tmp57_ = _vala_gir_parser_node_ref0 (_tmp56_);
						_vala_gir_parser_node_unref0 (ref_method);
						ref_method = _tmp57_;
					} else {
						gboolean _tmp58_ = FALSE;
						const gchar* _tmp59_;
						_tmp59_ = cname;
						if (g_str_has_suffix (_tmp59_, "_unref")) {
							gboolean _tmp60_ = FALSE;
							ValaGirParserNode* _tmp61_;
							_tmp61_ = unref_method;
							if (_tmp61_ == NULL) {
								_tmp60_ = TRUE;
							} else {
								ValaGirParserNode* _tmp62_;
								const gchar* _tmp63_;
								_tmp62_ = self->priv->old_current;
								_tmp63_ = _tmp62_->name;
								_tmp60_ = g_strcmp0 (_tmp63_, "unref") == 0;
							}
							_tmp58_ = _tmp60_;
						} else {
							_tmp58_ = FALSE;
						}
						if (_tmp58_) {
							ValaGirParserNode* _tmp64_;
							ValaGirParserNode* _tmp65_;
							_tmp64_ = self->priv->old_current;
							_tmp65_ = _vala_gir_parser_node_ref0 (_tmp64_);
							_vala_gir_parser_node_unref0 (unref_method);
							unref_method = _tmp65_;
						}
					}
					_g_free0 (cname);
				} else {
					ValaMarkupReader* _tmp66_;
					const gchar* _tmp67_;
					const gchar* _tmp68_;
					_tmp66_ = self->priv->reader;
					_tmp67_ = vala_markup_reader_get_name (_tmp66_);
					_tmp68_ = _tmp67_;
					if (g_strcmp0 (_tmp68_, "function") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp69_;
						const gchar* _tmp70_;
						const gchar* _tmp71_;
						_tmp69_ = self->priv->reader;
						_tmp70_ = vala_markup_reader_get_name (_tmp69_);
						_tmp71_ = _tmp70_;
						if (g_strcmp0 (_tmp71_, "union") == 0) {
							vala_gir_parser_parse_union (self);
						} else {
							ValaSourceReference* _tmp72_;
							ValaSourceReference* _tmp73_;
							ValaMarkupReader* _tmp74_;
							const gchar* _tmp75_;
							const gchar* _tmp76_;
							gchar* _tmp77_;
							gchar* _tmp78_;
							_tmp72_ = vala_gir_parser_get_current_src (self);
							_tmp73_ = _tmp72_;
							_tmp74_ = self->priv->reader;
							_tmp75_ = vala_markup_reader_get_name (_tmp74_);
							_tmp76_ = _tmp75_;
							_tmp77_ = g_strdup_printf ("unknown child element `%s' in `class'", _tmp76_);
							_tmp78_ = _tmp77_;
							vala_report_error (_tmp73_, _tmp78_);
							_g_free0 (_tmp78_);
							_vala_source_reference_unref0 (_tmp73_);
							vala_gir_parser_skip_element (self);
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	_tmp82_ = cl;
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp82_, "CCode", "ref_function")) {
		_tmp81_ = TRUE;
	} else {
		ValaClass* _tmp83_;
		_tmp83_ = cl;
		_tmp81_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp83_, "CCode", "unref_function");
	}
	if (_tmp81_) {
		_tmp80_ = TRUE;
	} else {
		ValaClass* _tmp84_;
		_tmp84_ = cl;
		_tmp80_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp84_, "CCode", "copy_function");
	}
	if (_tmp80_) {
		_tmp79_ = TRUE;
	} else {
		ValaClass* _tmp85_;
		_tmp85_ = cl;
		_tmp79_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp85_, "CCode", "free_function");
	}
	if (_tmp79_) {
	} else {
		gboolean _tmp86_ = FALSE;
		ValaGirParserNode* _tmp87_;
		_tmp87_ = ref_method;
		if (_tmp87_ != NULL) {
			ValaGirParserNode* _tmp88_;
			_tmp88_ = unref_method;
			_tmp86_ = _tmp88_ != NULL;
		} else {
			_tmp86_ = FALSE;
		}
		if (_tmp86_) {
			ValaClass* _tmp89_;
			ValaGirParserNode* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			ValaClass* _tmp93_;
			ValaGirParserNode* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			_tmp89_ = cl;
			_tmp90_ = ref_method;
			_tmp91_ = vala_gir_parser_node_get_cname (_tmp90_);
			_tmp92_ = _tmp91_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp89_, "CCode", "ref_function", _tmp92_, NULL);
			_g_free0 (_tmp92_);
			_tmp93_ = cl;
			_tmp94_ = unref_method;
			_tmp95_ = vala_gir_parser_node_get_cname (_tmp94_);
			_tmp96_ = _tmp95_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp93_, "CCode", "unref_function", _tmp96_, NULL);
			_g_free0 (_tmp96_);
		} else {
			if (require_copy_free) {
				ValaClass* _tmp97_;
				ValaClass* _tmp98_;
				_tmp97_ = cl;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp97_, "CCode", "copy_function", "g_boxed_copy", NULL);
				_tmp98_ = cl;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp98_, "CCode", "free_function", "g_boxed_free", NULL);
			}
		}
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_vala_gir_parser_node_unref0 (unref_method);
	_vala_gir_parser_node_unref0 (ref_method);
	_vala_code_node_unref0 (cl);
	_g_free0 (name);
}

static void
vala_gir_parser_parse_union (ValaGirParser* self)
{
	gchar* element_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp15_;
	ValaStruct* st = NULL;
	ValaGirParserNode* _tmp16_;
	ValaStruct* _tmp29_;
	ValaStruct* _tmp30_;
	ValaStruct* _tmp31_;
	ValaGirComment* _tmp32_;
	ValaGirComment* _tmp33_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "union");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	element_name = _tmp0_;
	_tmp1_ = element_name;
	if (_tmp1_ == NULL) {
		ValaGirComment* _tmp2_;
		ValaGirComment* _tmp3_;
		vala_gir_parser_next (self);
		_tmp2_ = vala_gir_parser_parse_symbol_doc (self);
		_tmp3_ = _tmp2_;
		_vala_comment_unref0 (_tmp3_);
		while (TRUE) {
			ValaMarkupTokenType _tmp4_;
			ValaMarkupReader* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			_tmp4_ = self->priv->current_token;
			if (!(_tmp4_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
				break;
			}
			if (!vala_gir_parser_push_metadata (self)) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			_tmp5_ = self->priv->reader;
			_tmp6_ = vala_markup_reader_get_name (_tmp5_);
			_tmp7_ = _tmp6_;
			if (g_strcmp0 (_tmp7_, "field") == 0) {
				vala_gir_parser_parse_field (self);
			} else {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				ValaMarkupReader* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp8_ = vala_gir_parser_get_current_src (self);
				_tmp9_ = _tmp8_;
				_tmp10_ = self->priv->reader;
				_tmp11_ = vala_markup_reader_get_name (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strdup_printf ("unknown child element `%s' in `transparent union'", _tmp12_);
				_tmp14_ = _tmp13_;
				vala_report_error (_tmp9_, _tmp14_);
				_g_free0 (_tmp14_);
				_vala_source_reference_unref0 (_tmp9_);
				vala_gir_parser_skip_element (self);
			}
			vala_gir_parser_pop_metadata (self);
		}
		vala_gir_parser_end_element (self, "union");
		_g_free0 (element_name);
		return;
	}
	_tmp15_ = element_name;
	vala_gir_parser_push_node (self, _tmp15_, TRUE);
	_tmp16_ = self->priv->current;
	if (_tmp16_->new_symbol) {
		ValaMarkupReader* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		ValaGirParserNode* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaStruct* _tmp22_;
		ValaGirParserNode* _tmp23_;
		ValaStruct* _tmp24_;
		ValaSymbol* _tmp25_;
		_tmp17_ = self->priv->reader;
		_tmp18_ = vala_markup_reader_get_attribute (_tmp17_, "name");
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->current;
		_tmp21_ = _tmp20_->source_reference;
		_tmp22_ = vala_struct_new (_tmp19_, _tmp21_, NULL);
		_vala_code_node_unref0 (st);
		st = _tmp22_;
		_g_free0 (_tmp19_);
		_tmp23_ = self->priv->current;
		_tmp24_ = st;
		_tmp25_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp24_);
		_vala_code_node_unref0 (_tmp23_->symbol);
		_tmp23_->symbol = _tmp25_;
	} else {
		ValaGirParserNode* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaStruct* _tmp28_;
		_tmp26_ = self->priv->current;
		_tmp27_ = _tmp26_->symbol;
		_tmp28_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_STRUCT, ValaStruct));
		_vala_code_node_unref0 (st);
		st = _tmp28_;
	}
	_tmp29_ = st;
	vala_symbol_set_access ((ValaSymbol*) _tmp29_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp30_ = st;
	vala_symbol_set_external ((ValaSymbol*) _tmp30_, TRUE);
	vala_gir_parser_next (self);
	_tmp31_ = st;
	_tmp32_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp33_ = _tmp32_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp31_, (ValaComment*) _tmp33_);
	_vala_comment_unref0 (_tmp33_);
	while (TRUE) {
		ValaMarkupTokenType _tmp34_;
		ValaMarkupReader* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		_tmp34_ = self->priv->current_token;
		if (!(_tmp34_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp35_ = self->priv->reader;
		_tmp36_ = vala_markup_reader_get_name (_tmp35_);
		_tmp37_ = _tmp36_;
		if (g_strcmp0 (_tmp37_, "field") == 0) {
			vala_gir_parser_parse_field (self);
		} else {
			ValaMarkupReader* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			_tmp38_ = self->priv->reader;
			_tmp39_ = vala_markup_reader_get_name (_tmp38_);
			_tmp40_ = _tmp39_;
			if (g_strcmp0 (_tmp40_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp41_;
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				_tmp41_ = self->priv->reader;
				_tmp42_ = vala_markup_reader_get_name (_tmp41_);
				_tmp43_ = _tmp42_;
				if (g_strcmp0 (_tmp43_, "method") == 0) {
					vala_gir_parser_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp44_;
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					_tmp44_ = self->priv->reader;
					_tmp45_ = vala_markup_reader_get_name (_tmp44_);
					_tmp46_ = _tmp45_;
					if (g_strcmp0 (_tmp46_, "function") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp47_;
						const gchar* _tmp48_;
						const gchar* _tmp49_;
						_tmp47_ = self->priv->reader;
						_tmp48_ = vala_markup_reader_get_name (_tmp47_);
						_tmp49_ = _tmp48_;
						if (g_strcmp0 (_tmp49_, "record") == 0) {
							vala_gir_parser_parse_record (self);
						} else {
							ValaSourceReference* _tmp50_;
							ValaSourceReference* _tmp51_;
							ValaMarkupReader* _tmp52_;
							const gchar* _tmp53_;
							const gchar* _tmp54_;
							gchar* _tmp55_;
							gchar* _tmp56_;
							_tmp50_ = vala_gir_parser_get_current_src (self);
							_tmp51_ = _tmp50_;
							_tmp52_ = self->priv->reader;
							_tmp53_ = vala_markup_reader_get_name (_tmp52_);
							_tmp54_ = _tmp53_;
							_tmp55_ = g_strdup_printf ("unknown child element `%s' in `union'", _tmp54_);
							_tmp56_ = _tmp55_;
							vala_report_error (_tmp51_, _tmp56_);
							_g_free0 (_tmp56_);
							_vala_source_reference_unref0 (_tmp51_);
							vala_gir_parser_skip_element (self);
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "union");
	_vala_code_node_unref0 (st);
	_g_free0 (element_name);
}

static void
vala_gir_parser_parse_constant (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp2_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	gint array_length_idx = 0;
	ValaDataType* type = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaConstant* c = NULL;
	ValaGirParserNode* _tmp9_;
	const gchar* _tmp10_;
	ValaDataType* _tmp11_;
	ValaGirParserNode* _tmp12_;
	ValaSourceReference* _tmp13_;
	ValaConstant* _tmp14_;
	ValaGirParserNode* _tmp15_;
	ValaConstant* _tmp16_;
	ValaSymbol* _tmp17_;
	ValaConstant* _tmp18_;
	ValaConstant* _tmp19_;
	ValaGirComment* _tmp20_;
	ValaConstant* _tmp21_;
	gboolean _tmp22_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "constant");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, FALSE);
	_g_free0 (_tmp1_);
	vala_gir_parser_next (self);
	_tmp2_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp2_;
	_tmp6_ = vala_gir_parser_parse_type (self, NULL, &_tmp3_, TRUE, &_tmp4_, &_tmp5_);
	array_length_idx = _tmp3_;
	no_array_length = _tmp4_;
	array_null_terminated = _tmp5_;
	type = _tmp6_;
	_tmp7_ = type;
	_tmp8_ = vala_gir_parser_element_get_type (self, _tmp7_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp8_;
	_tmp9_ = self->priv->current;
	_tmp10_ = _tmp9_->name;
	_tmp11_ = type;
	_tmp12_ = self->priv->current;
	_tmp13_ = _tmp12_->source_reference;
	_tmp14_ = vala_constant_new (_tmp10_, _tmp11_, NULL, _tmp13_, NULL);
	c = _tmp14_;
	_tmp15_ = self->priv->current;
	_tmp16_ = c;
	_tmp17_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp16_);
	_vala_code_node_unref0 (_tmp15_->symbol);
	_tmp15_->symbol = _tmp17_;
	_tmp18_ = c;
	vala_symbol_set_access ((ValaSymbol*) _tmp18_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp19_ = c;
	_tmp20_ = comment;
	vala_symbol_set_comment ((ValaSymbol*) _tmp19_, (ValaComment*) _tmp20_);
	_tmp21_ = c;
	vala_symbol_set_external ((ValaSymbol*) _tmp21_, TRUE);
	if (no_array_length) {
		_tmp22_ = TRUE;
	} else {
		_tmp22_ = array_null_terminated;
	}
	if (_tmp22_) {
		ValaConstant* _tmp23_;
		_tmp23_ = c;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp23_, "CCode", "array_length", !no_array_length, NULL);
	}
	if (array_null_terminated) {
		ValaConstant* _tmp24_;
		_tmp24_ = c;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp24_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "constant");
	_vala_code_node_unref0 (c);
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
}

static void
vala_gir_parser_report_unused_metadata (ValaGirParser* self,
                                        ValaGirParserMetadata* metadata)
{
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaMap* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	if (metadata == _tmp1_) {
		return;
	}
	_tmp3_ = metadata->args;
	_tmp4_ = vala_map_get_size (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		ValaArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = metadata->children;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaSourceReference* _tmp9_;
		_tmp9_ = metadata->source_reference;
		vala_report_warning (_tmp9_, "empty metadata");
		return;
	}
	{
		ValaIterator* _arg_type_it = NULL;
		ValaMap* _tmp10_;
		ValaSet* _tmp11_;
		ValaSet* _tmp12_;
		ValaIterator* _tmp13_;
		ValaIterator* _tmp14_;
		_tmp10_ = metadata->args;
		_tmp11_ = vala_map_get_keys (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_iterable_iterator ((ValaIterable*) _tmp12_);
		_tmp14_ = _tmp13_;
		_vala_iterable_unref0 (_tmp12_);
		_arg_type_it = _tmp14_;
		while (TRUE) {
			ValaIterator* _tmp15_;
			ValaGirParserArgumentType arg_type = 0;
			ValaIterator* _tmp16_;
			gpointer _tmp17_;
			ValaGirParserArgument* arg = NULL;
			ValaMap* _tmp18_;
			ValaGirParserArgumentType _tmp19_;
			gpointer _tmp20_;
			ValaGirParserArgument* _tmp21_;
			_tmp15_ = _arg_type_it;
			if (!vala_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _arg_type_it;
			_tmp17_ = vala_iterator_get (_tmp16_);
			arg_type = (ValaGirParserArgumentType) ((gintptr) _tmp17_);
			_tmp18_ = metadata->args;
			_tmp19_ = arg_type;
			_tmp20_ = vala_map_get (_tmp18_, (gpointer) ((gintptr) _tmp19_));
			arg = (ValaGirParserArgument*) _tmp20_;
			_tmp21_ = arg;
			if (!_tmp21_->used) {
				ValaGirParserArgument* _tmp22_;
				ValaSourceReference* _tmp23_;
				_tmp22_ = arg;
				_tmp23_ = _tmp22_->source_reference;
				vala_report_warning (_tmp23_, "argument never used");
			}
			_vala_gir_parser_argument_unref0 (arg);
		}
		_vala_iterator_unref0 (_arg_type_it);
	}
	{
		ValaArrayList* _child_list = NULL;
		ValaArrayList* _tmp24_;
		ValaArrayList* _tmp25_;
		gint _child_size = 0;
		ValaArrayList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _child_index = 0;
		_tmp24_ = metadata->children;
		_tmp25_ = _vala_iterable_ref0 (_tmp24_);
		_child_list = _tmp25_;
		_tmp26_ = _child_list;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_child_size = _tmp28_;
		_child_index = -1;
		while (TRUE) {
			ValaGirParserMetadata* child = NULL;
			ValaArrayList* _tmp29_;
			gpointer _tmp30_;
			ValaGirParserMetadata* _tmp31_;
			_child_index = _child_index + 1;
			if (!(_child_index < _child_size)) {
				break;
			}
			_tmp29_ = _child_list;
			_tmp30_ = vala_list_get ((ValaList*) _tmp29_, _child_index);
			child = (ValaGirParserMetadata*) _tmp30_;
			_tmp31_ = child;
			if (!_tmp31_->used) {
				ValaGirParserMetadata* _tmp32_;
				ValaSourceReference* _tmp33_;
				_tmp32_ = child;
				_tmp33_ = _tmp32_->source_reference;
				vala_report_warning (_tmp33_, "metadata never used");
			} else {
				ValaGirParserMetadata* _tmp34_;
				_tmp34_ = child;
				vala_gir_parser_report_unused_metadata (self, _tmp34_);
			}
			_vala_gir_parser_metadata_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
}

static void
vala_gir_parser_resolve_gir_symbols (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _map_from_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _map_from_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _map_from_index = 0;
		_tmp0_ = self->priv->unresolved_gir_symbols;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_map_from_list = _tmp1_;
		_tmp2_ = _map_from_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_map_from_size = _tmp4_;
		_map_from_index = -1;
		while (TRUE) {
			ValaUnresolvedSymbol* map_from = NULL;
			ValaArrayList* _tmp5_;
			gpointer _tmp6_;
			_map_from_index = _map_from_index + 1;
			if (!(_map_from_index < _map_from_size)) {
				break;
			}
			_tmp5_ = _map_from_list;
			_tmp6_ = vala_list_get ((ValaList*) _tmp5_, _map_from_index);
			map_from = (ValaUnresolvedSymbol*) _tmp6_;
			while (TRUE) {
				ValaUnresolvedSymbol* _tmp7_;
				ValaSymbol* map_to = NULL;
				ValaHashMap* _tmp8_;
				ValaUnresolvedSymbol* _tmp9_;
				gpointer _tmp10_;
				ValaSymbol* _tmp11_;
				ValaUnresolvedSymbol* _tmp61_;
				ValaUnresolvedSymbol* _tmp62_;
				ValaUnresolvedSymbol* _tmp63_;
				ValaUnresolvedSymbol* _tmp64_;
				_tmp7_ = map_from;
				if (!(_tmp7_ != NULL)) {
					break;
				}
				_tmp8_ = self->priv->unresolved_symbols_map;
				_tmp9_ = map_from;
				_tmp10_ = vala_map_get ((ValaMap*) _tmp8_, _tmp9_);
				map_to = (ValaSymbol*) _tmp10_;
				_tmp11_ = map_to;
				if (_tmp11_ != NULL) {
					ValaUnresolvedSymbol* _tmp12_;
					ValaUnresolvedSymbol* _tmp13_;
					ValaSymbol* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					ValaSymbol* _tmp17_;
					_tmp12_ = map_from;
					vala_unresolved_symbol_set_inner (_tmp12_, NULL);
					_tmp13_ = map_from;
					_tmp14_ = map_to;
					_tmp15_ = vala_symbol_get_name (_tmp14_);
					_tmp16_ = _tmp15_;
					vala_symbol_set_name ((ValaSymbol*) _tmp13_, _tmp16_);
					_tmp17_ = map_to;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_UNRESOLVED_SYMBOL)) {
						ValaUnresolvedSymbol* umap_to = NULL;
						ValaSymbol* _tmp18_;
						ValaUnresolvedSymbol* _tmp19_;
						_tmp18_ = map_to;
						_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol));
						umap_to = _tmp19_;
						while (TRUE) {
							ValaUnresolvedSymbol* _tmp20_;
							ValaUnresolvedSymbol* _tmp21_;
							ValaUnresolvedSymbol* _tmp22_;
							ValaUnresolvedSymbol* _tmp23_;
							ValaUnresolvedSymbol* _tmp24_;
							ValaUnresolvedSymbol* _tmp25_;
							ValaUnresolvedSymbol* _tmp26_;
							ValaUnresolvedSymbol* _tmp27_;
							ValaUnresolvedSymbol* _tmp28_;
							const gchar* _tmp29_;
							const gchar* _tmp30_;
							ValaUnresolvedSymbol* _tmp31_;
							ValaUnresolvedSymbol* _tmp32_;
							ValaUnresolvedSymbol* _tmp33_;
							ValaUnresolvedSymbol* _tmp34_;
							ValaUnresolvedSymbol* _tmp35_;
							ValaUnresolvedSymbol* _tmp36_;
							_tmp20_ = umap_to;
							_tmp21_ = vala_unresolved_symbol_get_inner (_tmp20_);
							_tmp22_ = _tmp21_;
							if (!(_tmp22_ != NULL)) {
								break;
							}
							_tmp23_ = umap_to;
							_tmp24_ = vala_unresolved_symbol_get_inner (_tmp23_);
							_tmp25_ = _tmp24_;
							_tmp26_ = _vala_code_node_ref0 (_tmp25_);
							_vala_code_node_unref0 (umap_to);
							umap_to = _tmp26_;
							_tmp27_ = map_from;
							_tmp28_ = umap_to;
							_tmp29_ = vala_symbol_get_name ((ValaSymbol*) _tmp28_);
							_tmp30_ = _tmp29_;
							_tmp31_ = vala_unresolved_symbol_new (NULL, _tmp30_, NULL);
							_tmp32_ = _tmp31_;
							vala_unresolved_symbol_set_inner (_tmp27_, _tmp32_);
							_vala_code_node_unref0 (_tmp32_);
							_tmp33_ = map_from;
							_tmp34_ = vala_unresolved_symbol_get_inner (_tmp33_);
							_tmp35_ = _tmp34_;
							_tmp36_ = _vala_code_node_ref0 (_tmp35_);
							_vala_code_node_unref0 (map_from);
							map_from = _tmp36_;
						}
						_vala_code_node_unref0 (umap_to);
					} else {
						while (TRUE) {
							gboolean _tmp37_ = FALSE;
							ValaSymbol* _tmp38_;
							ValaSymbol* _tmp39_;
							ValaSymbol* _tmp40_;
							ValaSymbol* _tmp47_;
							ValaSymbol* _tmp48_;
							ValaSymbol* _tmp49_;
							ValaSymbol* _tmp50_;
							ValaUnresolvedSymbol* _tmp51_;
							ValaSymbol* _tmp52_;
							const gchar* _tmp53_;
							const gchar* _tmp54_;
							ValaUnresolvedSymbol* _tmp55_;
							ValaUnresolvedSymbol* _tmp56_;
							ValaUnresolvedSymbol* _tmp57_;
							ValaUnresolvedSymbol* _tmp58_;
							ValaUnresolvedSymbol* _tmp59_;
							ValaUnresolvedSymbol* _tmp60_;
							_tmp38_ = map_to;
							_tmp39_ = vala_symbol_get_parent_symbol (_tmp38_);
							_tmp40_ = _tmp39_;
							if (_tmp40_ != NULL) {
								ValaSymbol* _tmp41_;
								ValaSymbol* _tmp42_;
								ValaSymbol* _tmp43_;
								ValaCodeContext* _tmp44_;
								ValaNamespace* _tmp45_;
								ValaNamespace* _tmp46_;
								_tmp41_ = map_to;
								_tmp42_ = vala_symbol_get_parent_symbol (_tmp41_);
								_tmp43_ = _tmp42_;
								_tmp44_ = self->priv->context;
								_tmp45_ = vala_code_context_get_root (_tmp44_);
								_tmp46_ = _tmp45_;
								_tmp37_ = _tmp43_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, VALA_TYPE_SYMBOL, ValaSymbol);
							} else {
								_tmp37_ = FALSE;
							}
							if (!_tmp37_) {
								break;
							}
							_tmp47_ = map_to;
							_tmp48_ = vala_symbol_get_parent_symbol (_tmp47_);
							_tmp49_ = _tmp48_;
							_tmp50_ = _vala_code_node_ref0 (_tmp49_);
							_vala_code_node_unref0 (map_to);
							map_to = _tmp50_;
							_tmp51_ = map_from;
							_tmp52_ = map_to;
							_tmp53_ = vala_symbol_get_name (_tmp52_);
							_tmp54_ = _tmp53_;
							_tmp55_ = vala_unresolved_symbol_new (NULL, _tmp54_, NULL);
							_tmp56_ = _tmp55_;
							vala_unresolved_symbol_set_inner (_tmp51_, _tmp56_);
							_vala_code_node_unref0 (_tmp56_);
							_tmp57_ = map_from;
							_tmp58_ = vala_unresolved_symbol_get_inner (_tmp57_);
							_tmp59_ = _tmp58_;
							_tmp60_ = _vala_code_node_ref0 (_tmp59_);
							_vala_code_node_unref0 (map_from);
							map_from = _tmp60_;
						}
					}
					_vala_code_node_unref0 (map_to);
					break;
				}
				_tmp61_ = map_from;
				_tmp62_ = vala_unresolved_symbol_get_inner (_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = _vala_code_node_ref0 (_tmp63_);
				_vala_code_node_unref0 (map_from);
				map_from = _tmp64_;
				_vala_code_node_unref0 (map_to);
			}
			_vala_code_node_unref0 (map_from);
		}
		_vala_iterable_unref0 (_map_from_list);
	}
}

static void
vala_gir_parser_create_new_namespaces (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _node_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _node_index = 0;
		_tmp0_ = vala_gir_parser_node_new_namespaces;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_node_list = _tmp1_;
		_tmp2_ = _node_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_node_size = _tmp4_;
		_node_index = -1;
		while (TRUE) {
			ValaGirParserNode* node = NULL;
			ValaArrayList* _tmp5_;
			gpointer _tmp6_;
			ValaGirParserNode* _tmp7_;
			ValaSymbol* _tmp8_;
			_node_index = _node_index + 1;
			if (!(_node_index < _node_size)) {
				break;
			}
			_tmp5_ = _node_list;
			_tmp6_ = vala_list_get ((ValaList*) _tmp5_, _node_index);
			node = (ValaGirParserNode*) _tmp6_;
			_tmp7_ = node;
			_tmp8_ = _tmp7_->symbol;
			if (_tmp8_ == NULL) {
				ValaGirParserNode* _tmp9_;
				ValaGirParserNode* _tmp10_;
				const gchar* _tmp11_;
				ValaGirParserNode* _tmp12_;
				ValaSourceReference* _tmp13_;
				ValaNamespace* _tmp14_;
				_tmp9_ = node;
				_tmp10_ = node;
				_tmp11_ = _tmp10_->name;
				_tmp12_ = node;
				_tmp13_ = _tmp12_->source_reference;
				_tmp14_ = vala_namespace_new (_tmp11_, _tmp13_);
				_vala_code_node_unref0 (_tmp9_->symbol);
				_tmp9_->symbol = (ValaSymbol*) _tmp14_;
			}
			_vala_gir_parser_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
}

static void
vala_gir_parser_resolve_type_arguments (ValaGirParser* self)
{
	ValaMapIterator* it = NULL;
	ValaHashMap* _tmp0_;
	ValaMapIterator* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->unresolved_type_arguments;
	_tmp1_ = vala_map_map_iterator ((ValaMap*) _tmp0_);
	it = _tmp1_;
	while (TRUE) {
		ValaMapIterator* _tmp2_;
		ValaUnresolvedType* element_type = NULL;
		ValaMapIterator* _tmp3_;
		gpointer _tmp4_;
		ValaGirParserNode* parent = NULL;
		ValaMapIterator* _tmp5_;
		gpointer _tmp6_;
		ValaTypeSymbol* sym = NULL;
		ValaGirParserNode* _tmp7_;
		ValaUnresolvedType* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		ValaUnresolvedSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaStruct* st = NULL;
		ValaTypeSymbol* _tmp12_;
		ValaStruct* _tmp13_;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		ValaStruct* _tmp16_;
		_tmp2_ = it;
		if (!vala_map_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = it;
		_tmp4_ = vala_map_iterator_get_key (_tmp3_);
		element_type = (ValaUnresolvedType*) _tmp4_;
		_tmp5_ = it;
		_tmp6_ = vala_map_iterator_get_value (_tmp5_);
		parent = (ValaGirParserNode*) _tmp6_;
		_tmp7_ = parent;
		_tmp8_ = element_type;
		_tmp9_ = vala_unresolved_type_get_unresolved_symbol (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_gir_parser_resolve_symbol (self, _tmp7_, _tmp10_);
		sym = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		_tmp12_ = sym;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp12_) : NULL);
		st = _tmp13_;
		_tmp16_ = st;
		if (_tmp16_ != NULL) {
			ValaStruct* _tmp17_;
			_tmp17_ = st;
			_tmp15_ = !vala_struct_is_integer_type (_tmp17_);
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			ValaStruct* _tmp18_;
			_tmp18_ = st;
			_tmp14_ = !vala_struct_is_floating_type (_tmp18_);
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaUnresolvedType* _tmp19_;
			_tmp19_ = element_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp19_, TRUE);
		}
		_vala_code_node_unref0 (st);
		_vala_code_node_unref0 (sym);
		_vala_gir_parser_node_unref0 (parent);
		_vala_code_node_unref0 (element_type);
	}
	_vala_map_iterator_unref0 (it);
}

static void
vala_gir_parser_process_interface (ValaGirParser* self,
                                   ValaGirParserNode* iface_node)
{
	ValaInterface* iface = NULL;
	ValaSymbol* _tmp0_;
	ValaInterface* _tmp1_;
	gboolean has_instantiable_prereq = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface_node != NULL);
	_tmp0_ = iface_node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_INTERFACE, ValaInterface));
	iface = _tmp1_;
	has_instantiable_prereq = FALSE;
	{
		ValaList* _prereq_list = NULL;
		ValaInterface* _tmp2_;
		ValaList* _tmp3_;
		gint _prereq_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _prereq_index = 0;
		_tmp2_ = iface;
		_tmp3_ = vala_interface_get_prerequisites (_tmp2_);
		_prereq_list = _tmp3_;
		_tmp4_ = _prereq_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_prereq_size = _tmp6_;
		_prereq_index = -1;
		while (TRUE) {
			ValaDataType* prereq = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaSymbol* sym = NULL;
			ValaDataType* _tmp9_;
			ValaSymbol* _tmp21_;
			_prereq_index = _prereq_index + 1;
			if (!(_prereq_index < _prereq_size)) {
				break;
			}
			_tmp7_ = _prereq_list;
			_tmp8_ = vala_list_get (_tmp7_, _prereq_index);
			prereq = (ValaDataType*) _tmp8_;
			sym = NULL;
			_tmp9_ = prereq;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_UNRESOLVED_TYPE)) {
				ValaUnresolvedSymbol* unresolved_symbol = NULL;
				ValaDataType* _tmp10_;
				ValaUnresolvedSymbol* _tmp11_;
				ValaUnresolvedSymbol* _tmp12_;
				ValaUnresolvedSymbol* _tmp13_;
				ValaGirParserNode* _tmp14_;
				ValaUnresolvedSymbol* _tmp15_;
				ValaSymbol* _tmp16_;
				_tmp10_ = prereq;
				_tmp11_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
				_tmp12_ = _tmp11_;
				_tmp13_ = _vala_code_node_ref0 (_tmp12_);
				unresolved_symbol = _tmp13_;
				_tmp14_ = iface_node->parent;
				_tmp15_ = unresolved_symbol;
				_tmp16_ = vala_gir_parser_resolve_symbol (self, _tmp14_, _tmp15_);
				_vala_code_node_unref0 (sym);
				sym = _tmp16_;
				_vala_code_node_unref0 (unresolved_symbol);
			} else {
				ValaDataType* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				ValaTypeSymbol* _tmp19_;
				ValaSymbol* _tmp20_;
				_tmp17_ = prereq;
				_tmp18_ = vala_data_type_get_data_type (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp19_);
				_vala_code_node_unref0 (sym);
				sym = _tmp20_;
			}
			_tmp21_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_CLASS)) {
				has_instantiable_prereq = TRUE;
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (prereq);
				break;
			}
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	if (!has_instantiable_prereq) {
		ValaInterface* _tmp22_;
		ValaNamespace* _tmp23_;
		ValaScope* _tmp24_;
		ValaScope* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaObjectTypeSymbol* _tmp27_;
		ValaObjectType* _tmp28_;
		ValaObjectType* _tmp29_;
		_tmp22_ = iface;
		_tmp23_ = self->priv->glib_ns;
		_tmp24_ = vala_symbol_get_scope ((ValaSymbol*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_scope_lookup (_tmp25_, "Object");
		_tmp27_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
		_tmp28_ = vala_object_type_new (_tmp27_);
		_tmp29_ = _tmp28_;
		vala_interface_add_prerequisite (_tmp22_, (ValaDataType*) _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp27_);
	}
	_vala_code_node_unref0 (iface);
}

static void
vala_gir_parser_process_alias (ValaGirParser* self,
                               ValaGirParserNode* alias)
{
	ValaDataType* base_type = NULL;
	ValaSymbol* type_sym = NULL;
	ValaGirParserNode* base_node = NULL;
	gboolean simple_type = FALSE;
	ValaDataType* _tmp0_;
	gboolean _tmp32_ = FALSE;
	ValaSymbol* _tmp33_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	ValaDataType* _tmp37_;
	gboolean _tmp151_ = FALSE;
	ValaSymbol* _tmp152_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alias != NULL);
	base_type = NULL;
	type_sym = NULL;
	base_node = NULL;
	simple_type = FALSE;
	_tmp0_ = alias->base_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_UNRESOLVED_TYPE)) {
		ValaDataType* _tmp1_;
		ValaDataType* _tmp2_;
		ValaGirParserNode* _tmp3_;
		ValaDataType* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		ValaGirParserNode* _tmp7_;
		ValaGirParserNode* _tmp8_;
		_tmp1_ = alias->base_type;
		_tmp2_ = _vala_code_node_ref0 (_tmp1_);
		_vala_code_node_unref0 (base_type);
		base_type = _tmp2_;
		_tmp3_ = alias->parent;
		_tmp4_ = base_type;
		_tmp5_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_gir_parser_resolve_node (self, _tmp3_, _tmp6_, FALSE);
		_vala_gir_parser_node_unref0 (base_node);
		base_node = _tmp7_;
		_tmp8_ = base_node;
		if (_tmp8_ != NULL) {
			ValaGirParserNode* _tmp9_;
			ValaSymbol* _tmp10_;
			ValaSymbol* _tmp11_;
			_tmp9_ = base_node;
			_tmp10_ = _tmp9_->symbol;
			_tmp11_ = _vala_code_node_ref0 (_tmp10_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp11_;
		}
	} else {
		gboolean _tmp12_ = FALSE;
		ValaDataType* _tmp13_;
		_tmp13_ = alias->base_type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_POINTER_TYPE)) {
			ValaDataType* _tmp14_;
			ValaDataType* _tmp15_;
			ValaDataType* _tmp16_;
			_tmp14_ = alias->base_type;
			_tmp15_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
			_tmp16_ = _tmp15_;
			_tmp12_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_VOID_TYPE);
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			simple_type = TRUE;
		} else {
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			ValaTypeSymbol* _tmp20_;
			ValaTypeSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			ValaSymbol* _tmp23_;
			_tmp17_ = alias->base_type;
			_tmp18_ = _vala_code_node_ref0 (_tmp17_);
			_vala_code_node_unref0 (base_type);
			base_type = _tmp18_;
			_tmp19_ = base_type;
			_tmp20_ = vala_data_type_get_data_type (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp21_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp22_;
			_tmp23_ = type_sym;
			if (_tmp23_ != NULL) {
				ValaGirParserNode* _tmp24_;
				ValaSymbol* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				ValaSourceReference* _tmp28_;
				ValaUnresolvedSymbol* _tmp29_;
				ValaUnresolvedSymbol* _tmp30_;
				ValaGirParserNode* _tmp31_;
				_tmp24_ = alias->parent;
				_tmp25_ = type_sym;
				_tmp26_ = vala_symbol_get_full_name (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = alias->source_reference;
				_tmp29_ = vala_gir_parser_parse_symbol_from_string (self, _tmp27_, _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = vala_gir_parser_resolve_node (self, _tmp24_, _tmp30_, FALSE);
				_vala_gir_parser_node_unref0 (base_node);
				base_node = _tmp31_;
				_vala_code_node_unref0 (_tmp30_);
				_g_free0 (_tmp27_);
			}
		}
	}
	_tmp33_ = type_sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_STRUCT)) {
		ValaSymbol* _tmp34_;
		_tmp34_ = type_sym;
		_tmp32_ = vala_struct_is_simple_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, VALA_TYPE_STRUCT, ValaStruct));
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		simple_type = TRUE;
	}
	_tmp37_ = base_type;
	if (_tmp37_ == NULL) {
		_tmp36_ = TRUE;
	} else {
		ValaSymbol* _tmp38_;
		_tmp38_ = type_sym;
		_tmp36_ = _tmp38_ == NULL;
	}
	if (_tmp36_) {
		_tmp35_ = TRUE;
	} else {
		ValaSymbol* _tmp39_;
		_tmp39_ = type_sym;
		_tmp35_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALA_TYPE_STRUCT);
	}
	if (_tmp35_) {
		ValaStruct* st = NULL;
		const gchar* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaStruct* _tmp42_;
		ValaStruct* _tmp43_;
		ValaDataType* _tmp44_;
		ValaStruct* _tmp47_;
		ValaGirComment* _tmp48_;
		ValaStruct* _tmp49_;
		ValaStruct* _tmp50_;
		ValaStruct* _tmp51_;
		ValaSymbol* _tmp52_;
		_tmp40_ = alias->name;
		_tmp41_ = alias->source_reference;
		_tmp42_ = vala_struct_new (_tmp40_, _tmp41_, NULL);
		st = _tmp42_;
		_tmp43_ = st;
		vala_symbol_set_access ((ValaSymbol*) _tmp43_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp44_ = base_type;
		if (_tmp44_ != NULL) {
			ValaStruct* _tmp45_;
			ValaDataType* _tmp46_;
			_tmp45_ = st;
			_tmp46_ = base_type;
			vala_struct_set_base_type (_tmp45_, _tmp46_);
		}
		_tmp47_ = st;
		_tmp48_ = alias->comment;
		vala_symbol_set_comment ((ValaSymbol*) _tmp47_, (ValaComment*) _tmp48_);
		_tmp49_ = st;
		vala_symbol_set_external ((ValaSymbol*) _tmp49_, TRUE);
		_tmp50_ = st;
		vala_struct_set_simple_type (_tmp50_, simple_type);
		_tmp51_ = st;
		_tmp52_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp51_);
		_vala_code_node_unref0 (alias->symbol);
		alias->symbol = _tmp52_;
		_vala_code_node_unref0 (st);
	} else {
		ValaSymbol* _tmp53_;
		_tmp53_ = type_sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, VALA_TYPE_CLASS)) {
			ValaClass* cl = NULL;
			const gchar* _tmp54_;
			ValaSourceReference* _tmp55_;
			ValaClass* _tmp56_;
			ValaClass* _tmp57_;
			ValaDataType* _tmp58_;
			ValaClass* _tmp61_;
			ValaGirComment* _tmp62_;
			ValaClass* _tmp63_;
			ValaClass* _tmp64_;
			ValaSymbol* _tmp65_;
			gboolean _tmp66_;
			gboolean _tmp67_;
			ValaClass* _tmp68_;
			ValaSymbol* _tmp69_;
			_tmp54_ = alias->name;
			_tmp55_ = alias->source_reference;
			_tmp56_ = vala_class_new (_tmp54_, _tmp55_, NULL);
			cl = _tmp56_;
			_tmp57_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp57_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp58_ = base_type;
			if (_tmp58_ != NULL) {
				ValaClass* _tmp59_;
				ValaDataType* _tmp60_;
				_tmp59_ = cl;
				_tmp60_ = base_type;
				vala_class_add_base_type (_tmp59_, _tmp60_);
			}
			_tmp61_ = cl;
			_tmp62_ = alias->comment;
			vala_symbol_set_comment ((ValaSymbol*) _tmp61_, (ValaComment*) _tmp62_);
			_tmp63_ = cl;
			vala_symbol_set_external ((ValaSymbol*) _tmp63_, TRUE);
			_tmp64_ = cl;
			_tmp65_ = type_sym;
			_tmp66_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_CLASS, ValaClass));
			_tmp67_ = _tmp66_;
			vala_class_set_is_compact (_tmp64_, _tmp67_);
			_tmp68_ = cl;
			_tmp69_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp68_);
			_vala_code_node_unref0 (alias->symbol);
			alias->symbol = _tmp69_;
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp70_;
			_tmp70_ = type_sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, VALA_TYPE_INTERFACE)) {
				ValaInterface* iface = NULL;
				const gchar* _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaInterface* _tmp73_;
				ValaInterface* _tmp74_;
				ValaDataType* _tmp75_;
				ValaInterface* _tmp78_;
				ValaGirComment* _tmp79_;
				ValaInterface* _tmp80_;
				ValaInterface* _tmp81_;
				ValaSymbol* _tmp82_;
				_tmp71_ = alias->name;
				_tmp72_ = alias->source_reference;
				_tmp73_ = vala_interface_new (_tmp71_, _tmp72_, NULL);
				iface = _tmp73_;
				_tmp74_ = iface;
				vala_symbol_set_access ((ValaSymbol*) _tmp74_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
				_tmp75_ = base_type;
				if (_tmp75_ != NULL) {
					ValaInterface* _tmp76_;
					ValaDataType* _tmp77_;
					_tmp76_ = iface;
					_tmp77_ = base_type;
					vala_interface_add_prerequisite (_tmp76_, _tmp77_);
				}
				_tmp78_ = iface;
				_tmp79_ = alias->comment;
				vala_symbol_set_comment ((ValaSymbol*) _tmp78_, (ValaComment*) _tmp79_);
				_tmp80_ = iface;
				vala_symbol_set_external ((ValaSymbol*) _tmp80_, TRUE);
				_tmp81_ = iface;
				_tmp82_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp81_);
				_vala_code_node_unref0 (alias->symbol);
				alias->symbol = _tmp82_;
				_vala_code_node_unref0 (iface);
			} else {
				ValaSymbol* _tmp83_;
				_tmp83_ = type_sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp83_, VALA_TYPE_DELEGATE)) {
					ValaDelegate* orig = NULL;
					ValaSymbol* _tmp84_;
					ValaDelegate* _tmp85_;
					ValaGirParserNode* _tmp86_;
					ValaDelegate* deleg = NULL;
					const gchar* _tmp91_;
					ValaDelegate* _tmp92_;
					ValaDataType* _tmp93_;
					ValaDataType* _tmp94_;
					ValaDataType* _tmp95_;
					ValaDataType* _tmp96_;
					ValaSourceReference* _tmp97_;
					ValaDelegate* _tmp98_;
					ValaDelegate* _tmp99_;
					ValaDelegate* _tmp100_;
					ValaDelegate* _tmp101_;
					ValaSymbolAccessibility _tmp102_;
					ValaSymbolAccessibility _tmp103_;
					ValaArrayList* error_types = NULL;
					GEqualFunc _tmp115_;
					ValaArrayList* _tmp116_;
					ValaDelegate* _tmp117_;
					ValaArrayList* _tmp118_;
					ValaSourceReference* _tmp119_;
					ValaDelegate* _tmp131_;
					GList* _tmp132_;
					ValaDelegate* _tmp137_;
					ValaDelegate* _tmp138_;
					ValaSymbol* _tmp139_;
					_tmp84_ = type_sym;
					_tmp85_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, VALA_TYPE_DELEGATE, ValaDelegate));
					orig = _tmp85_;
					_tmp86_ = base_node;
					if (_tmp86_ != NULL) {
						ValaGirParserNode* _tmp87_;
						ValaGirParserNode* _tmp88_;
						ValaSymbol* _tmp89_;
						ValaDelegate* _tmp90_;
						_tmp87_ = base_node;
						vala_gir_parser_node_process (_tmp87_, self);
						_tmp88_ = base_node;
						_tmp89_ = _tmp88_->symbol;
						_tmp90_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, VALA_TYPE_DELEGATE, ValaDelegate));
						_vala_code_node_unref0 (orig);
						orig = _tmp90_;
					}
					_tmp91_ = alias->name;
					_tmp92_ = orig;
					_tmp93_ = vala_callable_get_return_type ((ValaCallable*) _tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = vala_data_type_copy (_tmp94_);
					_tmp96_ = _tmp95_;
					_tmp97_ = alias->source_reference;
					_tmp98_ = vala_delegate_new (_tmp91_, _tmp96_, _tmp97_, NULL);
					_tmp99_ = _tmp98_;
					_vala_code_node_unref0 (_tmp96_);
					deleg = _tmp99_;
					_tmp100_ = deleg;
					_tmp101_ = orig;
					_tmp102_ = vala_symbol_get_access ((ValaSymbol*) _tmp101_);
					_tmp103_ = _tmp102_;
					vala_symbol_set_access ((ValaSymbol*) _tmp100_, _tmp103_);
					{
						ValaList* _param_list = NULL;
						ValaDelegate* _tmp104_;
						ValaList* _tmp105_;
						gint _param_size = 0;
						ValaList* _tmp106_;
						gint _tmp107_;
						gint _tmp108_;
						gint _param_index = 0;
						_tmp104_ = orig;
						_tmp105_ = vala_callable_get_parameters ((ValaCallable*) _tmp104_);
						_param_list = _tmp105_;
						_tmp106_ = _param_list;
						_tmp107_ = vala_collection_get_size ((ValaCollection*) _tmp106_);
						_tmp108_ = _tmp107_;
						_param_size = _tmp108_;
						_param_index = -1;
						while (TRUE) {
							ValaParameter* param = NULL;
							ValaList* _tmp109_;
							gpointer _tmp110_;
							ValaDelegate* _tmp111_;
							ValaParameter* _tmp112_;
							ValaParameter* _tmp113_;
							ValaParameter* _tmp114_;
							_param_index = _param_index + 1;
							if (!(_param_index < _param_size)) {
								break;
							}
							_tmp109_ = _param_list;
							_tmp110_ = vala_list_get (_tmp109_, _param_index);
							param = (ValaParameter*) _tmp110_;
							_tmp111_ = deleg;
							_tmp112_ = param;
							_tmp113_ = vala_parameter_copy (_tmp112_);
							_tmp114_ = _tmp113_;
							vala_callable_add_parameter ((ValaCallable*) _tmp111_, _tmp114_);
							_vala_code_node_unref0 (_tmp114_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
					_tmp115_ = g_direct_equal;
					_tmp116_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp115_);
					error_types = _tmp116_;
					_tmp117_ = orig;
					_tmp118_ = error_types;
					_tmp119_ = alias->source_reference;
					vala_code_node_get_error_types ((ValaCodeNode*) _tmp117_, (ValaCollection*) _tmp118_, _tmp119_);
					{
						ValaArrayList* _error_type_list = NULL;
						ValaArrayList* _tmp120_;
						ValaArrayList* _tmp121_;
						gint _error_type_size = 0;
						ValaArrayList* _tmp122_;
						gint _tmp123_;
						gint _tmp124_;
						gint _error_type_index = 0;
						_tmp120_ = error_types;
						_tmp121_ = _vala_iterable_ref0 (_tmp120_);
						_error_type_list = _tmp121_;
						_tmp122_ = _error_type_list;
						_tmp123_ = vala_collection_get_size ((ValaCollection*) _tmp122_);
						_tmp124_ = _tmp123_;
						_error_type_size = _tmp124_;
						_error_type_index = -1;
						while (TRUE) {
							ValaDataType* error_type = NULL;
							ValaArrayList* _tmp125_;
							gpointer _tmp126_;
							ValaDelegate* _tmp127_;
							ValaDataType* _tmp128_;
							ValaDataType* _tmp129_;
							ValaDataType* _tmp130_;
							_error_type_index = _error_type_index + 1;
							if (!(_error_type_index < _error_type_size)) {
								break;
							}
							_tmp125_ = _error_type_list;
							_tmp126_ = vala_list_get ((ValaList*) _tmp125_, _error_type_index);
							error_type = (ValaDataType*) _tmp126_;
							_tmp127_ = deleg;
							_tmp128_ = error_type;
							_tmp129_ = vala_data_type_copy (_tmp128_);
							_tmp130_ = _tmp129_;
							vala_delegate_add_error_type (_tmp127_, _tmp130_);
							_vala_code_node_unref0 (_tmp130_);
							_vala_code_node_unref0 (error_type);
						}
						_vala_iterable_unref0 (_error_type_list);
					}
					_tmp131_ = orig;
					_tmp132_ = ((ValaCodeNode*) _tmp131_)->attributes;
					{
						GList* attribute_collection = NULL;
						GList* attribute_it = NULL;
						attribute_collection = _tmp132_;
						for (attribute_it = attribute_collection; attribute_it != NULL; attribute_it = attribute_it->next) {
							ValaAttribute* _tmp133_;
							ValaAttribute* attribute = NULL;
							_tmp133_ = _vala_code_node_ref0 ((ValaAttribute*) attribute_it->data);
							attribute = _tmp133_;
							{
								ValaDelegate* _tmp134_;
								ValaAttribute* _tmp135_;
								ValaAttribute* _tmp136_;
								_tmp134_ = deleg;
								_tmp135_ = attribute;
								_tmp136_ = _vala_code_node_ref0 (_tmp135_);
								((ValaCodeNode*) _tmp134_)->attributes = g_list_append (((ValaCodeNode*) _tmp134_)->attributes, _tmp136_);
								_vala_code_node_unref0 (attribute);
							}
						}
					}
					_tmp137_ = deleg;
					vala_symbol_set_external ((ValaSymbol*) _tmp137_, TRUE);
					_tmp138_ = deleg;
					_tmp139_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp138_);
					_vala_code_node_unref0 (alias->symbol);
					alias->symbol = _tmp139_;
					_vala_iterable_unref0 (error_types);
					_vala_code_node_unref0 (deleg);
					_vala_code_node_unref0 (orig);
				} else {
					ValaSymbol* _tmp140_;
					_tmp140_ = type_sym;
					if (_tmp140_ != NULL) {
						ValaSourceReference* _tmp141_;
						gchar* _tmp142_;
						gchar* _tmp143_;
						ValaSymbol* _tmp144_;
						gchar* _tmp145_;
						gchar* _tmp146_;
						gchar* _tmp147_;
						gchar* _tmp148_;
						ValaSymbol* _tmp149_;
						ValaSymbol* _tmp150_;
						_tmp141_ = alias->source_reference;
						_tmp142_ = vala_gir_parser_node_get_full_name (alias);
						_tmp143_ = _tmp142_;
						_tmp144_ = type_sym;
						_tmp145_ = vala_symbol_get_full_name (_tmp144_);
						_tmp146_ = _tmp145_;
						_tmp147_ = g_strdup_printf ("alias `%s' for `%s' is not supported", _tmp143_, _tmp146_);
						_tmp148_ = _tmp147_;
						vala_report_warning (_tmp141_, _tmp148_);
						_g_free0 (_tmp148_);
						_g_free0 (_tmp146_);
						_g_free0 (_tmp143_);
						_tmp149_ = type_sym;
						_tmp150_ = _vala_code_node_ref0 (_tmp149_);
						_vala_code_node_unref0 (alias->symbol);
						alias->symbol = _tmp150_;
						alias->merged = TRUE;
					}
				}
			}
		}
	}
	_tmp152_ = type_sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp152_, VALA_TYPE_CLASS)) {
		_tmp151_ = TRUE;
	} else {
		gboolean _tmp153_ = FALSE;
		ValaSymbol* _tmp154_;
		_tmp154_ = type_sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp154_, VALA_TYPE_STRUCT)) {
			_tmp153_ = !simple_type;
		} else {
			_tmp153_ = FALSE;
		}
		_tmp151_ = _tmp153_;
	}
	if (_tmp151_) {
		ValaSymbol* _tmp155_;
		_tmp155_ = type_sym;
		if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp155_, "CCode", "has_type_id")) {
			ValaSymbol* _tmp156_;
			ValaSymbol* _tmp157_;
			_tmp156_ = alias->symbol;
			_tmp157_ = type_sym;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp156_, "CCode", "has_type_id", vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp157_, "CCode", "has_type_id", FALSE), NULL);
		} else {
			ValaSymbol* _tmp158_;
			_tmp158_ = type_sym;
			if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp158_, "CCode", "type_id")) {
				ValaSymbol* _tmp159_;
				ValaSymbol* _tmp160_;
				gchar* _tmp161_;
				gchar* _tmp162_;
				_tmp159_ = alias->symbol;
				_tmp160_ = type_sym;
				_tmp161_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp160_, "CCode", "type_id", NULL);
				_tmp162_ = _tmp161_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp159_, "CCode", "type_id", _tmp162_, NULL);
				_g_free0 (_tmp162_);
			}
		}
	}
	_vala_gir_parser_node_unref0 (base_node);
	_vala_code_node_unref0 (type_sym);
	_vala_code_node_unref0 (base_type);
}

static void
vala_gir_parser_process_callable (ValaGirParser* self,
                                  ValaGirParserNode* node)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	ValaSymbol* s = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* parameters = NULL;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	ValaDataType* return_type = NULL;
	ValaSymbol* _tmp7_;
	gboolean _tmp12_ = FALSE;
	ValaDataType* _tmp13_;
	ValaList* _tmp148_;
	gint _tmp149_;
	gint _tmp150_;
	gint i = 0;
	gint j = 0;
	gint first_out = 0;
	gint last = 0;
	gboolean _tmp364_ = FALSE;
	ValaDataType* _tmp365_;
	ValaSymbol* _tmp370_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp1_ = node->element_type;
	if (g_strcmp0 (_tmp1_, "alias") == 0) {
		ValaSymbol* _tmp2_;
		_tmp2_ = node->symbol;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_DELEGATE);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = node->symbol;
	_tmp4_ = _vala_code_node_ref0 (_tmp3_);
	s = _tmp4_;
	_tmp5_ = node->parameters;
	_tmp6_ = _vala_iterable_ref0 (_tmp5_);
	parameters = _tmp6_;
	return_type = NULL;
	_tmp7_ = s;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_CALLABLE)) {
		ValaSymbol* _tmp8_;
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp8_ = s;
		_tmp9_ = vala_callable_get_return_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_CALLABLE, ValaCallable));
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 (_tmp10_);
		_vala_code_node_unref0 (return_type);
		return_type = _tmp11_;
	}
	_tmp13_ = return_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_ARRAY_TYPE)) {
		_tmp12_ = node->return_array_length_idx >= 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp14_ = parameters;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		if (node->return_array_length_idx >= _tmp16_) {
			ValaDataType* _tmp17_;
			ValaSourceReference* _tmp18_;
			ValaSourceReference* _tmp19_;
			_tmp17_ = return_type;
			_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp17_);
			_tmp19_ = _tmp18_;
			vala_report_error (_tmp19_, "invalid array length index");
		} else {
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaGirParserParameterInfo* _tmp22_;
			ValaArrayList* _tmp23_;
			_tmp20_ = parameters;
			_tmp21_ = vala_list_get (_tmp20_, node->return_array_length_idx);
			_tmp22_ = (ValaGirParserParameterInfo*) _tmp21_;
			_tmp22_->keep = FALSE;
			_vala_gir_parser_parameter_info_unref0 (_tmp22_);
			_tmp23_ = node->array_length_parameters;
			vala_collection_add ((ValaCollection*) _tmp23_, (gpointer) ((gintptr) node->return_array_length_idx));
		}
	} else {
		gboolean _tmp24_ = FALSE;
		ValaDataType* _tmp25_;
		_tmp25_ = return_type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_TYPE_VOID_TYPE)) {
			ValaList* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			_tmp26_ = parameters;
			_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp24_ = _tmp28_ > 0;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			gint n_out_parameters = 0;
			n_out_parameters = 0;
			{
				ValaList* _info_list = NULL;
				ValaList* _tmp29_;
				ValaList* _tmp30_;
				gint _info_size = 0;
				ValaList* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _info_index = 0;
				_tmp29_ = parameters;
				_tmp30_ = _vala_iterable_ref0 (_tmp29_);
				_info_list = _tmp30_;
				_tmp31_ = _info_list;
				_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
				_tmp33_ = _tmp32_;
				_info_size = _tmp33_;
				_info_index = -1;
				while (TRUE) {
					ValaGirParserParameterInfo* info = NULL;
					ValaList* _tmp34_;
					gpointer _tmp35_;
					ValaGirParserParameterInfo* _tmp36_;
					ValaParameter* _tmp37_;
					ValaParameterDirection _tmp38_;
					ValaParameterDirection _tmp39_;
					_info_index = _info_index + 1;
					if (!(_info_index < _info_size)) {
						break;
					}
					_tmp34_ = _info_list;
					_tmp35_ = vala_list_get (_tmp34_, _info_index);
					info = (ValaGirParserParameterInfo*) _tmp35_;
					_tmp36_ = info;
					_tmp37_ = _tmp36_->param;
					_tmp38_ = vala_parameter_get_direction (_tmp37_);
					_tmp39_ = _tmp38_;
					if (_tmp39_ == VALA_PARAMETER_DIRECTION_OUT) {
						gint _tmp40_;
						_tmp40_ = n_out_parameters;
						n_out_parameters = _tmp40_ + 1;
					}
					_vala_gir_parser_parameter_info_unref0 (info);
				}
				_vala_iterable_unref0 (_info_list);
			}
			if (n_out_parameters == 1) {
				ValaGirParserParameterInfo* last_param = NULL;
				ValaList* _tmp41_;
				ValaList* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				gpointer _tmp45_;
				ValaGirParserParameterInfo* _tmp46_;
				ValaParameter* _tmp47_;
				ValaParameterDirection _tmp48_;
				ValaParameterDirection _tmp49_;
				_tmp41_ = parameters;
				_tmp42_ = parameters;
				_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = vala_list_get (_tmp41_, _tmp44_ - 1);
				last_param = (ValaGirParserParameterInfo*) _tmp45_;
				_tmp46_ = last_param;
				_tmp47_ = _tmp46_->param;
				_tmp48_ = vala_parameter_get_direction (_tmp47_);
				_tmp49_ = _tmp48_;
				if (_tmp49_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaGirParserParameterInfo* _tmp50_;
					ValaParameter* _tmp51_;
					ValaDataType* _tmp52_;
					ValaDataType* _tmp53_;
					_tmp50_ = last_param;
					_tmp51_ = _tmp50_->param;
					_tmp52_ = vala_variable_get_variable_type ((ValaVariable*) _tmp51_);
					_tmp53_ = _tmp52_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, VALA_TYPE_UNRESOLVED_TYPE)) {
						ValaStruct* st = NULL;
						ValaGirParserNode* _tmp54_;
						ValaGirParserParameterInfo* _tmp55_;
						ValaParameter* _tmp56_;
						ValaDataType* _tmp57_;
						ValaDataType* _tmp58_;
						ValaUnresolvedSymbol* _tmp59_;
						ValaUnresolvedSymbol* _tmp60_;
						ValaSymbol* _tmp61_;
						ValaStruct* _tmp62_;
						gboolean _tmp63_ = FALSE;
						gboolean _tmp64_ = FALSE;
						ValaStruct* _tmp65_;
						_tmp54_ = node->parent;
						_tmp55_ = last_param;
						_tmp56_ = _tmp55_->param;
						_tmp57_ = vala_variable_get_variable_type ((ValaVariable*) _tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
						_tmp60_ = _tmp59_;
						_tmp61_ = vala_gir_parser_resolve_symbol (self, _tmp54_, _tmp60_);
						_tmp62_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp61_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp61_) : NULL;
						if (_tmp62_ == NULL) {
							_vala_code_node_unref0 (_tmp61_);
						}
						st = _tmp62_;
						_tmp65_ = st;
						if (_tmp65_ != NULL) {
							ValaStruct* _tmp66_;
							_tmp66_ = st;
							_tmp64_ = !vala_struct_is_simple_type (_tmp66_);
						} else {
							_tmp64_ = FALSE;
						}
						if (_tmp64_) {
							ValaGirParserParameterInfo* _tmp67_;
							ValaParameter* _tmp68_;
							ValaDataType* _tmp69_;
							ValaDataType* _tmp70_;
							gboolean _tmp71_;
							gboolean _tmp72_;
							_tmp67_ = last_param;
							_tmp68_ = _tmp67_->param;
							_tmp69_ = vala_variable_get_variable_type ((ValaVariable*) _tmp68_);
							_tmp70_ = _tmp69_;
							_tmp71_ = vala_data_type_get_nullable (_tmp70_);
							_tmp72_ = _tmp71_;
							_tmp63_ = !_tmp72_;
						} else {
							_tmp63_ = FALSE;
						}
						if (_tmp63_) {
							ValaGirParserMetadata* _tmp73_;
							_tmp73_ = node->metadata;
							if (!vala_gir_parser_metadata_get_bool (_tmp73_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID, FALSE)) {
								ValaGirParserParameterInfo* _tmp74_;
								ValaGirParserParameterInfo* _tmp75_;
								ValaParameter* _tmp76_;
								ValaDataType* _tmp77_;
								ValaDataType* _tmp78_;
								ValaDataType* _tmp79_;
								_tmp74_ = last_param;
								_tmp74_->keep = FALSE;
								_tmp75_ = last_param;
								_tmp76_ = _tmp75_->param;
								_tmp77_ = vala_variable_get_variable_type ((ValaVariable*) _tmp76_);
								_tmp78_ = _tmp77_;
								_tmp79_ = vala_data_type_copy (_tmp78_);
								_vala_code_node_unref0 (return_type);
								return_type = _tmp79_;
							}
						}
						_vala_code_node_unref0 (st);
					}
				}
				_vala_gir_parser_parameter_info_unref0 (last_param);
			}
		} else {
			gboolean _tmp80_ = FALSE;
			ValaDataType* _tmp81_;
			_tmp81_ = return_type;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp81_, VALA_TYPE_UNRESOLVED_TYPE)) {
				ValaDataType* _tmp82_;
				gboolean _tmp83_;
				gboolean _tmp84_;
				_tmp82_ = return_type;
				_tmp83_ = vala_data_type_get_nullable (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp80_ = !_tmp84_;
			} else {
				_tmp80_ = FALSE;
			}
			if (_tmp80_) {
				ValaStruct* st = NULL;
				ValaGirParserNode* _tmp85_;
				ValaDataType* _tmp86_;
				ValaUnresolvedSymbol* _tmp87_;
				ValaUnresolvedSymbol* _tmp88_;
				ValaSymbol* _tmp89_;
				ValaStruct* _tmp90_;
				ValaStruct* _tmp91_;
				_tmp85_ = node->parent;
				_tmp86_ = return_type;
				_tmp87_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_gir_parser_resolve_symbol (self, _tmp85_, _tmp88_);
				_tmp90_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp89_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp89_) : NULL;
				if (_tmp90_ == NULL) {
					_vala_code_node_unref0 (_tmp89_);
				}
				st = _tmp90_;
				_tmp91_ = st;
				if (_tmp91_ != NULL) {
					gboolean is_simple_type = FALSE;
					ValaStruct* base_st = NULL;
					ValaStruct* _tmp92_;
					ValaStruct* _tmp93_;
					is_simple_type = FALSE;
					_tmp92_ = st;
					_tmp93_ = _vala_code_node_ref0 (_tmp92_);
					base_st = _tmp93_;
					while (TRUE) {
						ValaStruct* _tmp94_;
						ValaStruct* _tmp95_;
						ValaStruct* _tmp96_;
						ValaDataType* _tmp97_;
						ValaDataType* _tmp98_;
						_tmp94_ = base_st;
						if (!(_tmp94_ != NULL)) {
							break;
						}
						_tmp95_ = base_st;
						if (vala_struct_is_simple_type (_tmp95_)) {
							is_simple_type = TRUE;
							break;
						}
						_tmp96_ = base_st;
						_tmp97_ = vala_struct_get_base_type (_tmp96_);
						_tmp98_ = _tmp97_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, VALA_TYPE_UNRESOLVED_TYPE)) {
							ValaGirParserNode* _tmp99_;
							ValaStruct* _tmp100_;
							ValaDataType* _tmp101_;
							ValaDataType* _tmp102_;
							ValaUnresolvedSymbol* _tmp103_;
							ValaUnresolvedSymbol* _tmp104_;
							ValaSymbol* _tmp105_;
							ValaStruct* _tmp106_;
							_tmp99_ = node->parent;
							_tmp100_ = base_st;
							_tmp101_ = vala_struct_get_base_type (_tmp100_);
							_tmp102_ = _tmp101_;
							_tmp103_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
							_tmp104_ = _tmp103_;
							_tmp105_ = vala_gir_parser_resolve_symbol (self, _tmp99_, _tmp104_);
							_tmp106_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp105_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp105_) : NULL;
							if (_tmp106_ == NULL) {
								_vala_code_node_unref0 (_tmp105_);
							}
							_vala_code_node_unref0 (base_st);
							base_st = _tmp106_;
						} else {
							ValaStruct* _tmp107_;
							ValaStruct* _tmp108_;
							ValaStruct* _tmp109_;
							ValaStruct* _tmp110_;
							_tmp107_ = base_st;
							_tmp108_ = vala_struct_get_base_struct (_tmp107_);
							_tmp109_ = _tmp108_;
							_tmp110_ = _vala_code_node_ref0 (_tmp109_);
							_vala_code_node_unref0 (base_st);
							base_st = _tmp110_;
						}
					}
					if (!is_simple_type) {
						ValaDataType* _tmp111_;
						_tmp111_ = return_type;
						vala_data_type_set_nullable (_tmp111_, TRUE);
					}
					_vala_code_node_unref0 (base_st);
				}
				_vala_code_node_unref0 (st);
			}
		}
	}
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp112_;
		ValaList* _tmp113_;
		gint _info_size = 0;
		ValaList* _tmp114_;
		gint _tmp115_;
		gint _tmp116_;
		gint _info_index = 0;
		_tmp112_ = parameters;
		_tmp113_ = _vala_iterable_ref0 (_tmp112_);
		_info_list = _tmp113_;
		_tmp114_ = _info_list;
		_tmp115_ = vala_collection_get_size ((ValaCollection*) _tmp114_);
		_tmp116_ = _tmp115_;
		_info_size = _tmp116_;
		_info_index = -1;
		while (TRUE) {
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp117_;
			gpointer _tmp118_;
			ValaDataType* type = NULL;
			ValaGirParserParameterInfo* _tmp119_;
			ValaParameter* _tmp120_;
			ValaDataType* _tmp121_;
			ValaDataType* _tmp122_;
			ValaDataType* _tmp123_;
			gboolean _tmp124_ = FALSE;
			ValaGirParserParameterInfo* _tmp125_;
			ValaParameter* _tmp126_;
			ValaParameterDirection _tmp127_;
			ValaParameterDirection _tmp128_;
			_info_index = _info_index + 1;
			if (!(_info_index < _info_size)) {
				break;
			}
			_tmp117_ = _info_list;
			_tmp118_ = vala_list_get (_tmp117_, _info_index);
			info = (ValaGirParserParameterInfo*) _tmp118_;
			_tmp119_ = info;
			_tmp120_ = _tmp119_->param;
			_tmp121_ = vala_variable_get_variable_type ((ValaVariable*) _tmp120_);
			_tmp122_ = _tmp121_;
			_tmp123_ = _vala_code_node_ref0 (_tmp122_);
			type = _tmp123_;
			_tmp125_ = info;
			_tmp126_ = _tmp125_->param;
			_tmp127_ = vala_parameter_get_direction (_tmp126_);
			_tmp128_ = _tmp127_;
			if (_tmp128_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaDataType* _tmp129_;
				gboolean _tmp130_;
				gboolean _tmp131_;
				_tmp129_ = type;
				_tmp130_ = vala_data_type_get_nullable (_tmp129_);
				_tmp131_ = _tmp130_;
				_tmp124_ = _tmp131_;
			} else {
				_tmp124_ = FALSE;
			}
			if (_tmp124_) {
				ValaStruct* st = NULL;
				ValaDataType* _tmp132_;
				gboolean _tmp144_ = FALSE;
				ValaStruct* _tmp145_;
				st = NULL;
				_tmp132_ = type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp132_, VALA_TYPE_UNRESOLVED_TYPE)) {
					ValaGirParserNode* _tmp133_;
					ValaDataType* _tmp134_;
					ValaUnresolvedSymbol* _tmp135_;
					ValaUnresolvedSymbol* _tmp136_;
					ValaSymbol* _tmp137_;
					ValaStruct* _tmp138_;
					_tmp133_ = node->parent;
					_tmp134_ = type;
					_tmp135_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp134_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
					_tmp136_ = _tmp135_;
					_tmp137_ = vala_gir_parser_resolve_symbol (self, _tmp133_, _tmp136_);
					_tmp138_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp137_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp137_) : NULL;
					if (_tmp138_ == NULL) {
						_vala_code_node_unref0 (_tmp137_);
					}
					_vala_code_node_unref0 (st);
					st = _tmp138_;
				} else {
					ValaDataType* _tmp139_;
					_tmp139_ = type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp139_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp140_;
						ValaTypeSymbol* _tmp141_;
						ValaTypeSymbol* _tmp142_;
						ValaStruct* _tmp143_;
						_tmp140_ = type;
						_tmp141_ = vala_data_type_get_data_type (_tmp140_);
						_tmp142_ = _tmp141_;
						_tmp143_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp142_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp142_) : NULL);
						_vala_code_node_unref0 (st);
						st = _tmp143_;
					}
				}
				_tmp145_ = st;
				if (_tmp145_ != NULL) {
					ValaStruct* _tmp146_;
					_tmp146_ = st;
					_tmp144_ = vala_struct_is_simple_type (_tmp146_);
				} else {
					_tmp144_ = FALSE;
				}
				if (_tmp144_) {
					ValaDataType* _tmp147_;
					_tmp147_ = type;
					vala_data_type_set_nullable (_tmp147_, FALSE);
				}
				_vala_code_node_unref0 (st);
			}
			_vala_code_node_unref0 (type);
			_vala_gir_parser_parameter_info_unref0 (info);
		}
		_vala_iterable_unref0 (_info_list);
	}
	_tmp148_ = parameters;
	_tmp149_ = vala_collection_get_size ((ValaCollection*) _tmp148_);
	_tmp150_ = _tmp149_;
	if (_tmp150_ > 1) {
		ValaGirParserParameterInfo* last_param = NULL;
		ValaList* _tmp151_;
		ValaList* _tmp152_;
		gint _tmp153_;
		gint _tmp154_;
		gpointer _tmp155_;
		ValaGirParserParameterInfo* _tmp156_;
		ValaParameter* _tmp157_;
		gboolean _tmp158_;
		gboolean _tmp159_;
		_tmp151_ = parameters;
		_tmp152_ = parameters;
		_tmp153_ = vala_collection_get_size ((ValaCollection*) _tmp152_);
		_tmp154_ = _tmp153_;
		_tmp155_ = vala_list_get (_tmp151_, _tmp154_ - 1);
		last_param = (ValaGirParserParameterInfo*) _tmp155_;
		_tmp156_ = last_param;
		_tmp157_ = _tmp156_->param;
		_tmp158_ = vala_parameter_get_ellipsis (_tmp157_);
		_tmp159_ = _tmp158_;
		if (_tmp159_) {
			ValaGirParserParameterInfo* first_vararg_param = NULL;
			ValaList* _tmp160_;
			ValaList* _tmp161_;
			gint _tmp162_;
			gint _tmp163_;
			gpointer _tmp164_;
			ValaGirParserParameterInfo* _tmp165_;
			ValaParameter* _tmp166_;
			const gchar* _tmp167_;
			const gchar* _tmp168_;
			_tmp160_ = parameters;
			_tmp161_ = parameters;
			_tmp162_ = vala_collection_get_size ((ValaCollection*) _tmp161_);
			_tmp163_ = _tmp162_;
			_tmp164_ = vala_list_get (_tmp160_, _tmp163_ - 2);
			first_vararg_param = (ValaGirParserParameterInfo*) _tmp164_;
			_tmp165_ = first_vararg_param;
			_tmp166_ = _tmp165_->param;
			_tmp167_ = vala_symbol_get_name ((ValaSymbol*) _tmp166_);
			_tmp168_ = _tmp167_;
			if (g_str_has_prefix (_tmp168_, "first_")) {
				ValaGirParserParameterInfo* _tmp169_;
				_tmp169_ = first_vararg_param;
				_tmp169_->keep = FALSE;
			}
			_vala_gir_parser_parameter_info_unref0 (first_vararg_param);
		}
		_vala_gir_parser_parameter_info_unref0 (last_param);
	}
	i = 0;
	j = 1;
	first_out = -1;
	last = -1;
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp170_;
		ValaList* _tmp171_;
		gint _info_size = 0;
		ValaList* _tmp172_;
		gint _tmp173_;
		gint _tmp174_;
		gint _info_index = 0;
		_tmp170_ = parameters;
		_tmp171_ = _vala_iterable_ref0 (_tmp170_);
		_info_list = _tmp171_;
		_tmp172_ = _info_list;
		_tmp173_ = vala_collection_get_size ((ValaCollection*) _tmp172_);
		_tmp174_ = _tmp173_;
		_info_size = _tmp174_;
		_info_index = -1;
		while (TRUE) {
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp175_;
			gpointer _tmp176_;
			gboolean _tmp177_ = FALSE;
			ValaSymbol* _tmp178_;
			gboolean _tmp205_ = FALSE;
			gboolean _tmp210_ = FALSE;
			gboolean _tmp211_ = FALSE;
			ValaSymbol* _tmp212_;
			gboolean _tmp230_ = FALSE;
			ValaSymbol* _tmp231_;
			gint _tmp235_;
			_info_index = _info_index + 1;
			if (!(_info_index < _info_size)) {
				break;
			}
			_tmp175_ = _info_list;
			_tmp176_ = vala_list_get (_tmp175_, _info_index);
			info = (ValaGirParserParameterInfo*) _tmp176_;
			_tmp178_ = s;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp178_, VALA_TYPE_DELEGATE)) {
				ValaGirParserParameterInfo* _tmp179_;
				_tmp179_ = info;
				_tmp177_ = _tmp179_->closure_idx == i;
			} else {
				_tmp177_ = FALSE;
			}
			if (_tmp177_) {
				ValaDelegate* d = NULL;
				ValaSymbol* _tmp180_;
				ValaDelegate* _tmp181_;
				ValaDelegate* _tmp182_;
				ValaDelegate* _tmp183_;
				ValaGirParserParameterInfo* _tmp184_;
				_tmp180_ = s;
				_tmp181_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp180_, VALA_TYPE_DELEGATE, ValaDelegate));
				d = _tmp181_;
				_tmp182_ = d;
				vala_delegate_set_has_target (_tmp182_, TRUE);
				_tmp183_ = d;
				vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp183_, "CCode", "instance_pos", j - 0.1, NULL);
				_tmp184_ = info;
				_tmp184_->keep = FALSE;
				_vala_code_node_unref0 (d);
			} else {
				gboolean _tmp185_ = FALSE;
				gboolean _tmp186_ = FALSE;
				gboolean _tmp187_ = FALSE;
				ValaGirParserParameterInfo* _tmp188_;
				_tmp188_ = info;
				if (_tmp188_->keep) {
					ValaArrayList* _tmp189_;
					_tmp189_ = node->array_length_parameters;
					_tmp187_ = !vala_collection_contains ((ValaCollection*) _tmp189_, (gpointer) ((gintptr) i));
				} else {
					_tmp187_ = FALSE;
				}
				if (_tmp187_) {
					ValaArrayList* _tmp190_;
					_tmp190_ = node->closure_parameters;
					_tmp186_ = !vala_collection_contains ((ValaCollection*) _tmp190_, (gpointer) ((gintptr) i));
				} else {
					_tmp186_ = FALSE;
				}
				if (_tmp186_) {
					ValaArrayList* _tmp191_;
					_tmp191_ = node->destroy_parameters;
					_tmp185_ = !vala_collection_contains ((ValaCollection*) _tmp191_, (gpointer) ((gintptr) i));
				} else {
					_tmp185_ = FALSE;
				}
				if (_tmp185_) {
					ValaGirParserParameterInfo* _tmp192_;
					ValaGirParserParameterInfo* _tmp193_;
					gfloat last_idx = 0.0F;
					gint _tmp202_;
					_tmp192_ = info;
					_tmp192_->vala_idx = (gfloat) j;
					_tmp193_ = info;
					_tmp193_->keep = TRUE;
					last_idx = 0.0F;
					if (last != -1) {
						ValaList* _tmp194_;
						gpointer _tmp195_;
						ValaGirParserParameterInfo* _tmp196_;
						_tmp194_ = parameters;
						_tmp195_ = vala_list_get (_tmp194_, last);
						_tmp196_ = (ValaGirParserParameterInfo*) _tmp195_;
						last_idx = _tmp196_->vala_idx;
						_vala_gir_parser_parameter_info_unref0 (_tmp196_);
					}
					{
						gint k = 0;
						k = last + 1;
						{
							gboolean _tmp197_ = FALSE;
							_tmp197_ = TRUE;
							while (TRUE) {
								ValaList* _tmp199_;
								gpointer _tmp200_;
								ValaGirParserParameterInfo* _tmp201_;
								if (!_tmp197_) {
									gint _tmp198_;
									_tmp198_ = k;
									k = _tmp198_ + 1;
								}
								_tmp197_ = FALSE;
								if (!(k < i)) {
									break;
								}
								_tmp199_ = parameters;
								_tmp200_ = vala_list_get (_tmp199_, k);
								_tmp201_ = (ValaGirParserParameterInfo*) _tmp200_;
								_tmp201_->vala_idx = last_idx + (((j - last_idx) / (i - last)) * (k - last));
								_vala_gir_parser_parameter_info_unref0 (_tmp201_);
							}
						}
					}
					last = i;
					_tmp202_ = j;
					j = _tmp202_ + 1;
				} else {
					ValaGirParserParameterInfo* _tmp203_;
					ValaGirParserParameterInfo* _tmp204_;
					_tmp203_ = info;
					_tmp203_->keep = FALSE;
					_tmp204_ = info;
					_tmp204_->vala_idx = (j - 1) + ((i - last) * 0.1F);
				}
			}
			if (first_out < 0) {
				ValaGirParserParameterInfo* _tmp206_;
				ValaParameter* _tmp207_;
				ValaParameterDirection _tmp208_;
				ValaParameterDirection _tmp209_;
				_tmp206_ = info;
				_tmp207_ = _tmp206_->param;
				_tmp208_ = vala_parameter_get_direction (_tmp207_);
				_tmp209_ = _tmp208_;
				_tmp205_ = _tmp209_ == VALA_PARAMETER_DIRECTION_OUT;
			} else {
				_tmp205_ = FALSE;
			}
			if (_tmp205_) {
				first_out = i;
			}
			_tmp212_ = s;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp212_, VALA_TYPE_METHOD)) {
				_tmp211_ = first_out >= 0;
			} else {
				_tmp211_ = FALSE;
			}
			if (_tmp211_) {
				ValaGirParserParameterInfo* _tmp213_;
				ValaParameter* _tmp214_;
				ValaDataType* _tmp215_;
				ValaDataType* _tmp216_;
				_tmp213_ = info;
				_tmp214_ = _tmp213_->param;
				_tmp215_ = vala_variable_get_variable_type ((ValaVariable*) _tmp214_);
				_tmp216_ = _tmp215_;
				_tmp210_ = _tmp216_ != NULL;
			} else {
				_tmp210_ = FALSE;
			}
			if (_tmp210_) {
				gchar* type_name = NULL;
				ValaGirParserParameterInfo* _tmp217_;
				ValaParameter* _tmp218_;
				ValaDataType* _tmp219_;
				ValaDataType* _tmp220_;
				gchar* _tmp221_;
				gboolean _tmp222_ = FALSE;
				const gchar* _tmp223_;
				_tmp217_ = info;
				_tmp218_ = _tmp217_->param;
				_tmp219_ = vala_variable_get_variable_type ((ValaVariable*) _tmp218_);
				_tmp220_ = _tmp219_;
				_tmp221_ = vala_code_node_to_string ((ValaCodeNode*) _tmp220_);
				type_name = _tmp221_;
				_tmp223_ = type_name;
				if (g_strcmp0 (_tmp223_, "GLib.AsyncResult") == 0) {
					_tmp222_ = TRUE;
				} else {
					const gchar* _tmp224_;
					_tmp224_ = type_name;
					_tmp222_ = g_strcmp0 (_tmp224_, "Gio.AsyncResult") == 0;
				}
				if (_tmp222_) {
					gdouble _tmp225_ = 0.0;
					ValaSymbol* _tmp226_;
					ValaMemberBinding _tmp227_;
					ValaMemberBinding _tmp228_;
					gdouble shift = 0.0;
					ValaSymbol* _tmp229_;
					_tmp226_ = s;
					_tmp227_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp226_, VALA_TYPE_METHOD, ValaMethod));
					_tmp228_ = _tmp227_;
					if (_tmp228_ == VALA_MEMBER_BINDING_INSTANCE) {
						_tmp225_ = 1.1;
					} else {
						_tmp225_ = 0.1;
					}
					shift = _tmp225_;
					_tmp229_ = s;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp229_, "CCode", "async_result_pos", i + shift, NULL);
				}
				_g_free0 (type_name);
			}
			_tmp231_ = s;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp231_, VALA_TYPE_DELEGATE)) {
				ValaGirParserParameterInfo* _tmp232_;
				_tmp232_ = info;
				_tmp230_ = _tmp232_->is_error;
			} else {
				_tmp230_ = FALSE;
			}
			if (_tmp230_) {
				ValaSymbol* _tmp233_;
				_tmp233_ = s;
				if (!vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp233_, "CCode", "instance_pos")) {
					ValaSymbol* _tmp234_;
					_tmp234_ = s;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp234_, "CCode", "error_pos", j - 0.2, NULL);
				}
			}
			_tmp235_ = i;
			i = _tmp235_ + 1;
			_vala_gir_parser_parameter_info_unref0 (info);
		}
		_vala_iterable_unref0 (_info_list);
	}
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp236_;
		ValaList* _tmp237_;
		gint _info_size = 0;
		ValaList* _tmp238_;
		gint _tmp239_;
		gint _tmp240_;
		gint _info_index = 0;
		_tmp236_ = parameters;
		_tmp237_ = _vala_iterable_ref0 (_tmp236_);
		_info_list = _tmp237_;
		_tmp238_ = _info_list;
		_tmp239_ = vala_collection_get_size ((ValaCollection*) _tmp238_);
		_tmp240_ = _tmp239_;
		_info_size = _tmp240_;
		_info_index = -1;
		while (TRUE) {
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp241_;
			gpointer _tmp242_;
			ValaGirParserParameterInfo* _tmp243_;
			ValaSymbol* _tmp244_;
			ValaGirParserParameterInfo* _tmp248_;
			ValaGirParserParameterInfo* _tmp263_;
			ValaGirParserParameterInfo* _tmp288_;
			ValaGirParserParameterInfo* _tmp313_;
			_info_index = _info_index + 1;
			if (!(_info_index < _info_size)) {
				break;
			}
			_tmp241_ = _info_list;
			_tmp242_ = vala_list_get (_tmp241_, _info_index);
			info = (ValaGirParserParameterInfo*) _tmp242_;
			_tmp243_ = info;
			if (!_tmp243_->keep) {
				_vala_gir_parser_parameter_info_unref0 (info);
				continue;
			}
			_tmp244_ = s;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp244_, VALA_TYPE_CALLABLE)) {
				ValaSymbol* _tmp245_;
				ValaGirParserParameterInfo* _tmp246_;
				ValaParameter* _tmp247_;
				_tmp245_ = s;
				_tmp246_ = info;
				_tmp247_ = _tmp246_->param;
				vala_callable_add_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp245_, VALA_TYPE_CALLABLE, ValaCallable), _tmp247_);
			}
			_tmp248_ = info;
			if (_tmp248_->array_length_idx != -1) {
				ValaGirParserParameterInfo* _tmp249_;
				ValaList* _tmp250_;
				gint _tmp251_;
				gint _tmp252_;
				ValaGirParserParameterInfo* _tmp257_;
				ValaParameter* _tmp258_;
				ValaList* _tmp259_;
				ValaGirParserParameterInfo* _tmp260_;
				gpointer _tmp261_;
				ValaGirParserParameterInfo* _tmp262_;
				_tmp249_ = info;
				_tmp250_ = parameters;
				_tmp251_ = vala_collection_get_size ((ValaCollection*) _tmp250_);
				_tmp252_ = _tmp251_;
				if (_tmp249_->array_length_idx >= _tmp252_) {
					ValaGirParserParameterInfo* _tmp253_;
					ValaParameter* _tmp254_;
					ValaSourceReference* _tmp255_;
					ValaSourceReference* _tmp256_;
					_tmp253_ = info;
					_tmp254_ = _tmp253_->param;
					_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp254_);
					_tmp256_ = _tmp255_;
					vala_report_error (_tmp256_, "invalid array_length index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp257_ = info;
				_tmp258_ = _tmp257_->param;
				_tmp259_ = parameters;
				_tmp260_ = info;
				_tmp261_ = vala_list_get (_tmp259_, _tmp260_->array_length_idx);
				_tmp262_ = (ValaGirParserParameterInfo*) _tmp261_;
				vala_gir_parser_set_array_ccode (self, (ValaSymbol*) _tmp258_, _tmp262_);
				_vala_gir_parser_parameter_info_unref0 (_tmp262_);
			}
			_tmp263_ = info;
			if (_tmp263_->closure_idx != -1) {
				ValaGirParserParameterInfo* _tmp264_;
				ValaList* _tmp265_;
				gint _tmp266_;
				gint _tmp267_;
				ValaList* _tmp272_;
				ValaGirParserParameterInfo* _tmp273_;
				gpointer _tmp274_;
				ValaGirParserParameterInfo* _tmp275_;
				gchar* _tmp276_;
				gchar* _tmp277_;
				ValaGirParserParameterInfo* _tmp278_;
				gchar* _tmp279_;
				gchar* _tmp280_;
				gboolean _tmp281_;
				_tmp264_ = info;
				_tmp265_ = parameters;
				_tmp266_ = vala_collection_get_size ((ValaCollection*) _tmp265_);
				_tmp267_ = _tmp266_;
				if (_tmp264_->closure_idx >= _tmp267_) {
					ValaGirParserParameterInfo* _tmp268_;
					ValaParameter* _tmp269_;
					ValaSourceReference* _tmp270_;
					ValaSourceReference* _tmp271_;
					_tmp268_ = info;
					_tmp269_ = _tmp268_->param;
					_tmp270_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp269_);
					_tmp271_ = _tmp270_;
					vala_report_error (_tmp271_, "invalid closure index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp272_ = parameters;
				_tmp273_ = info;
				_tmp274_ = vala_list_get (_tmp272_, _tmp273_->closure_idx);
				_tmp275_ = (ValaGirParserParameterInfo*) _tmp274_;
				_tmp276_ = g_strdup_printf ("%g", (gdouble) _tmp275_->vala_idx);
				_tmp277_ = _tmp276_;
				_tmp278_ = info;
				_tmp279_ = g_strdup_printf ("%g", _tmp278_->vala_idx + 0.1);
				_tmp280_ = _tmp279_;
				_tmp281_ = g_strcmp0 (_tmp277_, _tmp280_) != 0;
				_g_free0 (_tmp280_);
				_g_free0 (_tmp277_);
				_vala_gir_parser_parameter_info_unref0 (_tmp275_);
				if (_tmp281_) {
					ValaGirParserParameterInfo* _tmp282_;
					ValaParameter* _tmp283_;
					ValaList* _tmp284_;
					ValaGirParserParameterInfo* _tmp285_;
					gpointer _tmp286_;
					ValaGirParserParameterInfo* _tmp287_;
					_tmp282_ = info;
					_tmp283_ = _tmp282_->param;
					_tmp284_ = parameters;
					_tmp285_ = info;
					_tmp286_ = vala_list_get (_tmp284_, _tmp285_->closure_idx);
					_tmp287_ = (ValaGirParserParameterInfo*) _tmp286_;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp283_, "CCode", "delegate_target_pos", (gdouble) _tmp287_->vala_idx, NULL);
					_vala_gir_parser_parameter_info_unref0 (_tmp287_);
				}
			}
			_tmp288_ = info;
			if (_tmp288_->destroy_idx != -1) {
				ValaGirParserParameterInfo* _tmp289_;
				ValaList* _tmp290_;
				gint _tmp291_;
				gint _tmp292_;
				ValaList* _tmp297_;
				ValaGirParserParameterInfo* _tmp298_;
				gpointer _tmp299_;
				ValaGirParserParameterInfo* _tmp300_;
				gchar* _tmp301_;
				gchar* _tmp302_;
				ValaGirParserParameterInfo* _tmp303_;
				gchar* _tmp304_;
				gchar* _tmp305_;
				gboolean _tmp306_;
				_tmp289_ = info;
				_tmp290_ = parameters;
				_tmp291_ = vala_collection_get_size ((ValaCollection*) _tmp290_);
				_tmp292_ = _tmp291_;
				if (_tmp289_->destroy_idx >= _tmp292_) {
					ValaGirParserParameterInfo* _tmp293_;
					ValaParameter* _tmp294_;
					ValaSourceReference* _tmp295_;
					ValaSourceReference* _tmp296_;
					_tmp293_ = info;
					_tmp294_ = _tmp293_->param;
					_tmp295_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp294_);
					_tmp296_ = _tmp295_;
					vala_report_error (_tmp296_, "invalid destroy index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp297_ = parameters;
				_tmp298_ = info;
				_tmp299_ = vala_list_get (_tmp297_, _tmp298_->destroy_idx);
				_tmp300_ = (ValaGirParserParameterInfo*) _tmp299_;
				_tmp301_ = g_strdup_printf ("%g", (gdouble) _tmp300_->vala_idx);
				_tmp302_ = _tmp301_;
				_tmp303_ = info;
				_tmp304_ = g_strdup_printf ("%g", _tmp303_->vala_idx + 0.2);
				_tmp305_ = _tmp304_;
				_tmp306_ = g_strcmp0 (_tmp302_, _tmp305_) != 0;
				_g_free0 (_tmp305_);
				_g_free0 (_tmp302_);
				_vala_gir_parser_parameter_info_unref0 (_tmp300_);
				if (_tmp306_) {
					ValaGirParserParameterInfo* _tmp307_;
					ValaParameter* _tmp308_;
					ValaList* _tmp309_;
					ValaGirParserParameterInfo* _tmp310_;
					gpointer _tmp311_;
					ValaGirParserParameterInfo* _tmp312_;
					_tmp307_ = info;
					_tmp308_ = _tmp307_->param;
					_tmp309_ = parameters;
					_tmp310_ = info;
					_tmp311_ = vala_list_get (_tmp309_, _tmp310_->destroy_idx);
					_tmp312_ = (ValaGirParserParameterInfo*) _tmp311_;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp308_, "CCode", "destroy_notify_pos", (gdouble) _tmp312_->vala_idx, NULL);
					_vala_gir_parser_parameter_info_unref0 (_tmp312_);
				}
			}
			_tmp313_ = info;
			if (_tmp313_->is_async) {
				ValaDataType* resolved_type = NULL;
				ValaGirParserParameterInfo* _tmp314_;
				ValaParameter* _tmp315_;
				ValaDataType* _tmp316_;
				ValaDataType* _tmp317_;
				ValaDataType* _tmp318_;
				ValaDataType* _tmp319_;
				ValaDataType* _tmp328_;
				_tmp314_ = info;
				_tmp315_ = _tmp314_->param;
				_tmp316_ = vala_variable_get_variable_type ((ValaVariable*) _tmp315_);
				_tmp317_ = _tmp316_;
				_tmp318_ = _vala_code_node_ref0 (_tmp317_);
				resolved_type = _tmp318_;
				_tmp319_ = resolved_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp319_, VALA_TYPE_UNRESOLVED_TYPE)) {
					ValaSymbol* resolved_symbol = NULL;
					ValaGirParserNode* _tmp320_;
					ValaDataType* _tmp321_;
					ValaUnresolvedSymbol* _tmp322_;
					ValaUnresolvedSymbol* _tmp323_;
					ValaSymbol* _tmp324_;
					ValaSymbol* _tmp325_;
					_tmp320_ = node->parent;
					_tmp321_ = resolved_type;
					_tmp322_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp321_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
					_tmp323_ = _tmp322_;
					_tmp324_ = vala_gir_parser_resolve_symbol (self, _tmp320_, _tmp323_);
					resolved_symbol = _tmp324_;
					_tmp325_ = resolved_symbol;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp325_, VALA_TYPE_DELEGATE)) {
						ValaSymbol* _tmp326_;
						ValaDelegateType* _tmp327_;
						_tmp326_ = resolved_symbol;
						_tmp327_ = vala_delegate_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp326_, VALA_TYPE_DELEGATE, ValaDelegate));
						_vala_code_node_unref0 (resolved_type);
						resolved_type = (ValaDataType*) _tmp327_;
					}
					_vala_code_node_unref0 (resolved_symbol);
				}
				_tmp328_ = resolved_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp328_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegate* d = NULL;
					ValaDataType* _tmp329_;
					ValaDelegate* _tmp330_;
					ValaDelegate* _tmp331_;
					ValaDelegate* _tmp332_;
					gboolean _tmp333_ = FALSE;
					ValaDelegate* _tmp334_;
					const gchar* _tmp335_;
					const gchar* _tmp336_;
					_tmp329_ = resolved_type;
					_tmp330_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp329_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp331_ = _tmp330_;
					_tmp332_ = _vala_code_node_ref0 (_tmp331_);
					d = _tmp332_;
					_tmp334_ = d;
					_tmp335_ = vala_symbol_get_name ((ValaSymbol*) _tmp334_);
					_tmp336_ = _tmp335_;
					if (g_strcmp0 (_tmp336_, "DestroyNotify") == 0) {
						ValaDelegate* _tmp337_;
						ValaSymbol* _tmp338_;
						ValaSymbol* _tmp339_;
						const gchar* _tmp340_;
						const gchar* _tmp341_;
						_tmp337_ = d;
						_tmp338_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp337_);
						_tmp339_ = _tmp338_;
						_tmp340_ = vala_symbol_get_name (_tmp339_);
						_tmp341_ = _tmp340_;
						_tmp333_ = g_strcmp0 (_tmp341_, "GLib") == 0;
					} else {
						_tmp333_ = FALSE;
					}
					if (!_tmp333_) {
						ValaGirParserParameterInfo* _tmp342_;
						ValaParameter* _tmp343_;
						gboolean _tmp344_ = FALSE;
						ValaGirParserParameterInfo* _tmp345_;
						ValaGirParserParameterInfo* _tmp347_;
						ValaParameter* _tmp348_;
						ValaDataType* _tmp349_;
						ValaDataType* _tmp350_;
						_tmp342_ = info;
						_tmp343_ = _tmp342_->param;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp343_, "CCode", "scope", "async", NULL);
						_tmp345_ = info;
						if (_tmp345_->closure_idx != -1) {
							ValaGirParserParameterInfo* _tmp346_;
							_tmp346_ = info;
							_tmp344_ = _tmp346_->destroy_idx != -1;
						} else {
							_tmp344_ = FALSE;
						}
						_tmp347_ = info;
						_tmp348_ = _tmp347_->param;
						_tmp349_ = vala_variable_get_variable_type ((ValaVariable*) _tmp348_);
						_tmp350_ = _tmp349_;
						vala_data_type_set_value_owned (_tmp350_, _tmp344_);
					}
					_vala_code_node_unref0 (d);
				}
				_vala_code_node_unref0 (resolved_type);
			} else {
				ValaDataType* resolved_type = NULL;
				ValaGirParserParameterInfo* _tmp351_;
				ValaParameter* _tmp352_;
				ValaDataType* _tmp353_;
				ValaDataType* _tmp354_;
				ValaDataType* _tmp355_;
				ValaDataType* _tmp356_;
				_tmp351_ = info;
				_tmp352_ = _tmp351_->param;
				_tmp353_ = vala_variable_get_variable_type ((ValaVariable*) _tmp352_);
				_tmp354_ = _tmp353_;
				_tmp355_ = _vala_code_node_ref0 (_tmp354_);
				resolved_type = _tmp355_;
				_tmp356_ = resolved_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp356_, VALA_TYPE_DELEGATE_TYPE)) {
					gboolean _tmp357_ = FALSE;
					ValaGirParserParameterInfo* _tmp358_;
					ValaGirParserParameterInfo* _tmp360_;
					ValaParameter* _tmp361_;
					ValaDataType* _tmp362_;
					ValaDataType* _tmp363_;
					_tmp358_ = info;
					if (_tmp358_->closure_idx != -1) {
						ValaGirParserParameterInfo* _tmp359_;
						_tmp359_ = info;
						_tmp357_ = _tmp359_->destroy_idx != -1;
					} else {
						_tmp357_ = FALSE;
					}
					_tmp360_ = info;
					_tmp361_ = _tmp360_->param;
					_tmp362_ = vala_variable_get_variable_type ((ValaVariable*) _tmp361_);
					_tmp363_ = _tmp362_;
					vala_data_type_set_value_owned (_tmp363_, _tmp357_);
				}
				_vala_code_node_unref0 (resolved_type);
			}
			_vala_gir_parser_parameter_info_unref0 (info);
		}
		_vala_iterable_unref0 (_info_list);
	}
	_tmp365_ = return_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp365_, VALA_TYPE_ARRAY_TYPE)) {
		_tmp364_ = node->return_array_length_idx >= 0;
	} else {
		_tmp364_ = FALSE;
	}
	if (_tmp364_) {
		ValaSymbol* _tmp366_;
		ValaList* _tmp367_;
		gpointer _tmp368_;
		ValaGirParserParameterInfo* _tmp369_;
		_tmp366_ = s;
		_tmp367_ = parameters;
		_tmp368_ = vala_list_get (_tmp367_, node->return_array_length_idx);
		_tmp369_ = (ValaGirParserParameterInfo*) _tmp368_;
		vala_gir_parser_set_array_ccode (self, _tmp366_, _tmp369_);
		_vala_gir_parser_parameter_info_unref0 (_tmp369_);
	}
	_tmp370_ = s;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp370_, VALA_TYPE_CALLABLE)) {
		ValaSymbol* _tmp371_;
		ValaDataType* _tmp372_;
		_tmp371_ = s;
		_tmp372_ = return_type;
		vala_callable_set_return_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp371_, VALA_TYPE_CALLABLE, ValaCallable), _tmp372_);
	}
	_vala_code_node_unref0 (return_type);
	_vala_iterable_unref0 (parameters);
	_vala_code_node_unref0 (s);
}

static void
vala_gir_parser_find_parent (ValaGirParser* self,
                             const gchar* cname,
                             ValaGirParserNode* current,
                             ValaGirParserNode* * best,
                             gint* match)
{
	ValaGirParserNode* old_best = NULL;
	ValaGirParserNode* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaGirParserNode* _tmp19_;
	gint current_match = 0;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	g_return_if_fail (current != NULL);
	g_return_if_fail (*best != NULL);
	_tmp0_ = _vala_gir_parser_node_ref0 (*best);
	old_best = _tmp0_;
	_tmp1_ = current->symbol;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_NAMESPACE)) {
		{
			ValaArrayList* _child_list = NULL;
			ValaArrayList* _tmp2_;
			ValaArrayList* _tmp3_;
			gint _child_size = 0;
			ValaArrayList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _child_index = 0;
			_tmp2_ = current->members;
			_tmp3_ = _vala_iterable_ref0 (_tmp2_);
			_child_list = _tmp3_;
			_tmp4_ = _child_list;
			_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_child_size = _tmp6_;
			_child_index = -1;
			while (TRUE) {
				ValaGirParserNode* child = NULL;
				ValaArrayList* _tmp7_;
				gpointer _tmp8_;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				ValaGirParserNode* _tmp11_;
				ValaSymbol* _tmp12_;
				_child_index = _child_index + 1;
				if (!(_child_index < _child_size)) {
					break;
				}
				_tmp7_ = _child_list;
				_tmp8_ = vala_list_get ((ValaList*) _tmp7_, _child_index);
				child = (ValaGirParserNode*) _tmp8_;
				_tmp11_ = child;
				_tmp12_ = _tmp11_->symbol;
				if (_tmp12_ == NULL) {
					_tmp10_ = TRUE;
				} else {
					ValaGirParserNode* _tmp13_;
					ValaSymbol* _tmp14_;
					_tmp13_ = child;
					_tmp14_ = _tmp13_->symbol;
					_tmp10_ = vala_gir_parser_is_container (_tmp14_);
				}
				if (_tmp10_) {
					ValaGirParserNode* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp15_ = child;
					_tmp16_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp9_ = g_str_has_prefix (cname, _tmp17_);
					_g_free0 (_tmp17_);
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					ValaGirParserNode* _tmp18_;
					_tmp18_ = child;
					vala_gir_parser_find_parent (self, cname, _tmp18_, best, match);
				}
				_vala_gir_parser_node_unref0 (child);
			}
			_vala_iterable_unref0 (_child_list);
		}
	}
	_tmp19_ = old_best;
	if ((*best) != _tmp19_) {
		_vala_gir_parser_node_unref0 (old_best);
		return;
	}
	_tmp20_ = vala_gir_parser_node_get_lower_case_cprefix (current);
	_tmp21_ = _tmp20_;
	_tmp22_ = strlen (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp21_);
	current_match = _tmp24_;
	if (current_match > (*match)) {
		ValaGirParserNode* _tmp25_;
		*match = current_match;
		_tmp25_ = _vala_gir_parser_node_ref0 (current);
		_vala_gir_parser_node_unref0 (*best);
		*best = _tmp25_;
	}
	_vala_gir_parser_node_unref0 (old_best);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
vala_gir_parser_same_gir (ValaGirParser* self,
                          ValaSymbol* gir_component,
                          ValaSymbol* sym)
{
	gboolean result = FALSE;
	gchar* gir_name = NULL;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceFile* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* gir_version = NULL;
	ValaSourceReference* _tmp7_;
	ValaSourceReference* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSourceFile* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSourceFile* _tmp16_;
	ValaSourceFile* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (gir_component != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) gir_component);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_source_reference_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_source_file_get_gir_namespace (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	gir_name = _tmp6_;
	_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) gir_component);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_source_reference_get_file (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_source_file_get_gir_version (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup (_tmp12_);
	gir_version = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_source_reference_get_file (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_source_file_get_filename (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("%s-%s", gir_name, gir_version);
	_tmp21_ = _tmp20_;
	_tmp22_ = string_contains (_tmp19_, _tmp21_);
	_g_free0 (_tmp21_);
	result = _tmp22_;
	_g_free0 (gir_version);
	_g_free0 (gir_name);
	return result;
}

static void
vala_gir_parser_process_namespace_method (ValaGirParser* self,
                                          ValaGirParserNode* ns,
                                          ValaGirParserNode* node)
{
	gchar* ns_cprefix = NULL;
	gchar* _tmp0_;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	gchar* cname = NULL;
	gchar* _tmp3_;
	ValaParameter* first_param = NULL;
	ValaList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	ValaParameter* _tmp14_;
	gint match = 0;
	ValaGirParserNode* parent = NULL;
	ValaGirParserNode* _tmp72_;
	const gchar* _tmp73_;
	gchar* new_name = NULL;
	ValaMethod* _tmp74_;
	const gchar* _tmp75_;
	const gchar* _tmp76_;
	ValaGirParserNode* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gint _tmp80_;
	gint _tmp81_;
	const gchar* _tmp82_;
	gint _tmp83_;
	gint _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gboolean _tmp87_ = FALSE;
	ValaMethod* _tmp88_;
	ValaGirParserNode* _tmp89_;
	ValaSymbol* _tmp90_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = vala_gir_parser_node_get_lower_case_cprefix (ns);
	ns_cprefix = _tmp0_;
	_tmp1_ = node->symbol;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_METHOD, ValaMethod));
	method = _tmp2_;
	_tmp3_ = vala_gir_parser_node_get_cname (node);
	cname = _tmp3_;
	first_param = NULL;
	_tmp4_ = node->parameters;
	_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		ValaList* _tmp7_;
		gpointer _tmp8_;
		ValaGirParserParameterInfo* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		_tmp7_ = node->parameters;
		_tmp8_ = vala_list_get (_tmp7_, 0);
		_tmp9_ = (ValaGirParserParameterInfo*) _tmp8_;
		_tmp10_ = _tmp9_->param;
		_tmp11_ = _vala_code_node_ref0 (_tmp10_);
		_vala_code_node_unref0 (first_param);
		first_param = _tmp11_;
		_vala_gir_parser_parameter_info_unref0 (_tmp9_);
	}
	_tmp14_ = first_param;
	if (_tmp14_ != NULL) {
		ValaParameter* _tmp15_;
		ValaParameterDirection _tmp16_;
		ValaParameterDirection _tmp17_;
		_tmp15_ = first_param;
		_tmp16_ = vala_parameter_get_direction (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_ == VALA_PARAMETER_DIRECTION_IN;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		ValaParameter* _tmp18_;
		ValaDataType* _tmp19_;
		ValaDataType* _tmp20_;
		_tmp18_ = first_param;
		_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp12_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_UNRESOLVED_TYPE);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		ValaUnresolvedSymbol* sym = NULL;
		ValaParameter* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		ValaUnresolvedSymbol* _tmp24_;
		ValaUnresolvedSymbol* _tmp25_;
		ValaUnresolvedSymbol* _tmp26_;
		ValaGirParserNode* parent = NULL;
		ValaUnresolvedSymbol* _tmp27_;
		ValaGirParserNode* _tmp28_;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		ValaGirParserNode* _tmp33_;
		_tmp21_ = first_param;
		_tmp22_ = vala_variable_get_variable_type ((ValaVariable*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
		_tmp25_ = _tmp24_;
		_tmp26_ = _vala_code_node_ref0 (_tmp25_);
		sym = _tmp26_;
		_tmp27_ = sym;
		_tmp28_ = vala_gir_parser_resolve_node (self, ns, _tmp27_, FALSE);
		parent = _tmp28_;
		_tmp33_ = parent;
		if (_tmp33_ != NULL) {
			ValaMethod* _tmp34_;
			ValaGirParserNode* _tmp35_;
			ValaSymbol* _tmp36_;
			_tmp34_ = method;
			_tmp35_ = parent;
			_tmp36_ = _tmp35_->symbol;
			_tmp32_ = vala_gir_parser_same_gir (self, (ValaSymbol*) _tmp34_, _tmp36_);
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaGirParserNode* _tmp37_;
			ValaGirParserNode* _tmp38_;
			_tmp37_ = parent;
			_tmp38_ = _tmp37_->parent;
			_tmp31_ = _tmp38_ == ns;
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			ValaGirParserNode* _tmp39_;
			ValaSymbol* _tmp40_;
			_tmp39_ = parent;
			_tmp40_ = _tmp39_->symbol;
			_tmp30_ = vala_gir_parser_is_container (_tmp40_);
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			const gchar* _tmp41_;
			ValaGirParserNode* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			_tmp41_ = cname;
			_tmp42_ = parent;
			_tmp43_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp29_ = g_str_has_prefix (_tmp41_, _tmp44_);
			_g_free0 (_tmp44_);
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			gchar* new_name = NULL;
			ValaMethod* _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			ValaGirParserNode* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			const gchar* _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			ValaGirParserNode* _tmp58_;
			const gchar* _tmp59_;
			ValaGirParserNode* _tmp60_;
			ValaGirParserNode* _tmp61_;
			gboolean _tmp62_;
			_tmp45_ = method;
			_tmp46_ = vala_symbol_get_name ((ValaSymbol*) _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = parent;
			_tmp49_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = strlen (_tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = ns_cprefix;
			_tmp54_ = strlen (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = string_substring (_tmp47_, (glong) (_tmp52_ - _tmp55_), (glong) -1);
			_tmp57_ = _tmp56_;
			_g_free0 (_tmp50_);
			new_name = _tmp57_;
			_tmp58_ = parent;
			_tmp59_ = new_name;
			_tmp60_ = vala_gir_parser_node_lookup (_tmp58_, _tmp59_, FALSE, NULL);
			_tmp61_ = _tmp60_;
			_tmp62_ = _tmp61_ == NULL;
			_vala_gir_parser_node_unref0 (_tmp61_);
			if (_tmp62_) {
				const gchar* _tmp63_;
				gchar* _tmp64_;
				ValaList* _tmp65_;
				gpointer _tmp66_;
				ValaGirParserParameterInfo* _tmp67_;
				ValaMethod* _tmp68_;
				const gchar* _tmp69_;
				ValaMethod* _tmp70_;
				ValaGirParserNode* _tmp71_;
				vala_gir_parser_node_remove_member (ns, node);
				_tmp63_ = new_name;
				_tmp64_ = g_strdup (_tmp63_);
				_g_free0 (node->name);
				node->name = _tmp64_;
				_tmp65_ = node->parameters;
				_tmp66_ = vala_list_remove_at (_tmp65_, 0);
				_tmp67_ = (ValaGirParserParameterInfo*) _tmp66_;
				_vala_gir_parser_parameter_info_unref0 (_tmp67_);
				_tmp68_ = method;
				_tmp69_ = new_name;
				vala_symbol_set_name ((ValaSymbol*) _tmp68_, _tmp69_);
				_tmp70_ = method;
				vala_method_set_binding (_tmp70_, VALA_MEMBER_BINDING_INSTANCE);
				_tmp71_ = parent;
				vala_gir_parser_node_add_member (_tmp71_, node);
			}
			_g_free0 (new_name);
			_vala_gir_parser_node_unref0 (parent);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (first_param);
			_g_free0 (cname);
			_vala_code_node_unref0 (method);
			_g_free0 (ns_cprefix);
			return;
		}
		_vala_gir_parser_node_unref0 (parent);
		_vala_code_node_unref0 (sym);
	}
	match = 0;
	_tmp72_ = _vala_gir_parser_node_ref0 (ns);
	parent = _tmp72_;
	_tmp73_ = cname;
	vala_gir_parser_find_parent (self, _tmp73_, ns, &parent, &match);
	_tmp74_ = method;
	_tmp75_ = vala_symbol_get_name ((ValaSymbol*) _tmp74_);
	_tmp76_ = _tmp75_;
	_tmp77_ = parent;
	_tmp78_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp77_);
	_tmp79_ = _tmp78_;
	_tmp80_ = strlen (_tmp79_);
	_tmp81_ = _tmp80_;
	_tmp82_ = ns_cprefix;
	_tmp83_ = strlen (_tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = string_substring (_tmp76_, (glong) (_tmp81_ - _tmp84_), (glong) -1);
	_tmp86_ = _tmp85_;
	_g_free0 (_tmp79_);
	new_name = _tmp86_;
	_tmp88_ = method;
	_tmp89_ = parent;
	_tmp90_ = _tmp89_->symbol;
	if (vala_gir_parser_same_gir (self, (ValaSymbol*) _tmp88_, _tmp90_)) {
		ValaGirParserNode* _tmp91_;
		const gchar* _tmp92_;
		ValaGirParserNode* _tmp93_;
		ValaGirParserNode* _tmp94_;
		_tmp91_ = parent;
		_tmp92_ = new_name;
		_tmp93_ = vala_gir_parser_node_lookup (_tmp91_, _tmp92_, FALSE, NULL);
		_tmp94_ = _tmp93_;
		_tmp87_ = _tmp94_ == NULL;
		_vala_gir_parser_node_unref0 (_tmp94_);
	} else {
		_tmp87_ = FALSE;
	}
	if (_tmp87_) {
		const gchar* _tmp95_;
		gchar* _tmp96_;
		ValaMethod* _tmp97_;
		const gchar* _tmp98_;
		ValaGirParserNode* _tmp99_;
		vala_gir_parser_node_remove_member (ns, node);
		_tmp95_ = new_name;
		_tmp96_ = g_strdup (_tmp95_);
		_g_free0 (node->name);
		node->name = _tmp96_;
		_tmp97_ = method;
		_tmp98_ = new_name;
		vala_symbol_set_name ((ValaSymbol*) _tmp97_, _tmp98_);
		_tmp99_ = parent;
		vala_gir_parser_node_add_member (_tmp99_, node);
	}
	_g_free0 (new_name);
	_vala_gir_parser_node_unref0 (parent);
	_vala_code_node_unref0 (first_param);
	_g_free0 (cname);
	_vala_code_node_unref0 (method);
	_g_free0 (ns_cprefix);
}

static void
vala_gir_parser_process_virtual_method_field (ValaGirParser* self,
                                              ValaGirParserNode* node,
                                              ValaDelegate* d,
                                              ValaUnresolvedSymbol* gtype_struct_for)
{
	ValaGirParserNode* gtype_node = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaGirParserNode* _tmp3_;
	ValaArrayList* nodes = NULL;
	ValaGirParserNode* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	ValaArrayList* _tmp17_;
	ValaArrayList* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (d != NULL);
	g_return_if_fail (gtype_struct_for != NULL);
	_tmp0_ = node->parent;
	_tmp1_ = vala_gir_parser_resolve_node (self, _tmp0_, gtype_struct_for, FALSE);
	gtype_node = _tmp1_;
	_tmp3_ = gtype_node;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		ValaGirParserNode* _tmp4_;
		ValaSymbol* _tmp5_;
		_tmp4_ = gtype_node;
		_tmp5_ = _tmp4_->symbol;
		_tmp2_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_OBJECT_TYPE_SYMBOL);
	}
	if (_tmp2_) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) gtype_struct_for);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_code_node_to_string ((ValaCodeNode*) gtype_struct_for);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_gir_parser_node_to_string (node);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf ("Unknown symbol `%s' for virtual method field `%s'", _tmp9_, _tmp11_);
		_tmp13_ = _tmp12_;
		vala_report_error (_tmp7_, _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
	_tmp14_ = gtype_node;
	_tmp15_ = vala_symbol_get_name ((ValaSymbol*) d);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_gir_parser_node_lookup_all (_tmp14_, _tmp16_);
	nodes = _tmp17_;
	_tmp18_ = nodes;
	if (_tmp18_ == NULL) {
		_vala_iterable_unref0 (nodes);
		_vala_gir_parser_node_unref0 (gtype_node);
		return;
	}
	{
		ValaArrayList* _n_list = NULL;
		ValaArrayList* _tmp19_;
		ValaArrayList* _tmp20_;
		gint _n_size = 0;
		ValaArrayList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _n_index = 0;
		_tmp19_ = nodes;
		_tmp20_ = _vala_iterable_ref0 (_tmp19_);
		_n_list = _tmp20_;
		_tmp21_ = _n_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_n_size = _tmp23_;
		_n_index = -1;
		while (TRUE) {
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp24_;
			gpointer _tmp25_;
			ValaGirParserNode* _tmp26_;
			_n_index = _n_index + 1;
			if (!(_n_index < _n_size)) {
				break;
			}
			_tmp24_ = _n_list;
			_tmp25_ = vala_list_get ((ValaList*) _tmp24_, _n_index);
			n = (ValaGirParserNode*) _tmp25_;
			_tmp26_ = n;
			if (node != _tmp26_) {
				ValaGirParserNode* _tmp27_;
				_tmp27_ = n;
				vala_gir_parser_node_process (_tmp27_, self);
			}
			_vala_gir_parser_node_unref0 (n);
		}
		_vala_iterable_unref0 (_n_list);
	}
	{
		ValaArrayList* _n_list = NULL;
		ValaArrayList* _tmp28_;
		ValaArrayList* _tmp29_;
		gint _n_size = 0;
		ValaArrayList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _n_index = 0;
		_tmp28_ = nodes;
		_tmp29_ = _vala_iterable_ref0 (_tmp28_);
		_n_list = _tmp29_;
		_tmp30_ = _n_list;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_n_size = _tmp32_;
		_n_index = -1;
		while (TRUE) {
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp33_;
			gpointer _tmp34_;
			ValaGirParserNode* _tmp35_;
			ValaSymbol* sym = NULL;
			ValaGirParserNode* _tmp36_;
			ValaSymbol* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaSymbol* _tmp39_;
			_n_index = _n_index + 1;
			if (!(_n_index < _n_size)) {
				break;
			}
			_tmp33_ = _n_list;
			_tmp34_ = vala_list_get ((ValaList*) _tmp33_, _n_index);
			n = (ValaGirParserNode*) _tmp34_;
			_tmp35_ = n;
			if (_tmp35_->merged) {
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp36_ = n;
			_tmp37_ = _tmp36_->symbol;
			_tmp38_ = _vala_code_node_ref0 (_tmp37_);
			sym = _tmp38_;
			_tmp39_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALA_TYPE_SIGNAL)) {
				ValaSignal* sig = NULL;
				ValaSymbol* _tmp40_;
				ValaSignal* _tmp41_;
				ValaSignal* _tmp42_;
				ValaSignal* _tmp43_;
				_tmp40_ = sym;
				_tmp41_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, VALA_TYPE_SIGNAL, ValaSignal));
				sig = _tmp41_;
				_tmp42_ = sig;
				vala_signal_set_is_virtual (_tmp42_, TRUE);
				_tmp43_ = sig;
				vala_gir_parser_assume_parameter_names (self, _tmp43_, (ValaSymbol*) d, TRUE);
				_vala_code_node_unref0 (sig);
			} else {
				ValaSymbol* _tmp44_;
				_tmp44_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, VALA_TYPE_PROPERTY)) {
					ValaProperty* prop = NULL;
					ValaSymbol* _tmp45_;
					ValaProperty* _tmp46_;
					ValaProperty* _tmp47_;
					_tmp45_ = sym;
					_tmp46_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_PROPERTY, ValaProperty));
					prop = _tmp46_;
					_tmp47_ = prop;
					vala_property_set_is_virtual (_tmp47_, TRUE);
					_vala_code_node_unref0 (prop);
				}
			}
			_vala_code_node_unref0 (sym);
			_vala_gir_parser_node_unref0 (n);
		}
		_vala_iterable_unref0 (_n_list);
	}
	_vala_iterable_unref0 (nodes);
	_vala_gir_parser_node_unref0 (gtype_node);
}

static void
vala_gir_parser_process_async_method (ValaGirParser* self,
                                      ValaGirParserNode* node)
{
	ValaMethod* m = NULL;
	ValaSymbol* _tmp0_;
	ValaMethod* _tmp1_;
	gboolean requires_pointer = FALSE;
	gchar* finish_method_base = NULL;
	ValaMethod* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	ValaGirParserNode* finish_method_node = NULL;
	ValaGirParserNode* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	ValaGirParserNode* _tmp52_;
	ValaGirParserNode* _tmp53_;
	ValaGirParserNode* _tmp54_;
	ValaMethod* method = NULL;
	ValaMethod* _tmp73_;
	ValaMethod* _tmp74_;
	gboolean _tmp75_ = FALSE;
	ValaGirParserNode* _tmp76_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_METHOD, ValaMethod));
	m = _tmp1_;
	requires_pointer = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaMethod* _tmp2_;
		ValaList* _tmp3_;
		gint _param_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _param_index = 0;
		_tmp2_ = m;
		_tmp3_ = vala_callable_get_parameters ((ValaCallable*) _tmp2_);
		_param_list = _tmp3_;
		_tmp4_ = _param_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_param_size = _tmp6_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaParameter* _tmp9_;
			ValaParameterDirection _tmp10_;
			ValaParameterDirection _tmp11_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = vala_list_get (_tmp7_, _param_index);
			param = (ValaParameter*) _tmp8_;
			_tmp9_ = param;
			_tmp10_ = vala_parameter_get_direction (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ == VALA_PARAMETER_DIRECTION_IN) {
				requires_pointer = TRUE;
			} else {
				if (requires_pointer) {
					ValaParameter* _tmp12_;
					ValaParameter* _tmp13_;
					ValaDataType* _tmp14_;
					ValaDataType* _tmp15_;
					ValaParameter* _tmp16_;
					ValaParameter* _tmp17_;
					ValaDataType* _tmp18_;
					ValaDataType* _tmp19_;
					ValaPointerType* _tmp20_;
					ValaPointerType* _tmp21_;
					ValaParameter* _tmp22_;
					ValaSourceReference* _tmp23_;
					ValaSourceReference* _tmp24_;
					_tmp12_ = param;
					vala_parameter_set_direction (_tmp12_, VALA_PARAMETER_DIRECTION_IN);
					_tmp13_ = param;
					_tmp14_ = vala_variable_get_variable_type ((ValaVariable*) _tmp13_);
					_tmp15_ = _tmp14_;
					vala_data_type_set_nullable (_tmp15_, FALSE);
					_tmp16_ = param;
					_tmp17_ = param;
					_tmp18_ = vala_variable_get_variable_type ((ValaVariable*) _tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = vala_pointer_type_new (_tmp19_, NULL);
					_tmp21_ = _tmp20_;
					vala_variable_set_variable_type ((ValaVariable*) _tmp16_, (ValaDataType*) _tmp21_);
					_vala_code_node_unref0 (_tmp21_);
					_tmp22_ = param;
					_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp22_);
					_tmp24_ = _tmp23_;
					vala_report_warning (_tmp24_, "Synchronous out-parameters are not supported in async methods");
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp25_ = m;
	_tmp26_ = vala_symbol_get_name ((ValaSymbol*) _tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_ == NULL) {
		ValaMethod* _tmp28_;
		gchar* _tmp29_;
		_tmp28_ = m;
		_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, VALA_TYPE_CREATION_METHOD), "m is CreationMethod");
		_tmp29_ = g_strdup ("new");
		_g_free0 (finish_method_base);
		finish_method_base = _tmp29_;
	} else {
		ValaMethod* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		_tmp30_ = m;
		_tmp31_ = vala_symbol_get_name ((ValaSymbol*) _tmp30_);
		_tmp32_ = _tmp31_;
		if (g_str_has_suffix (_tmp32_, "_async")) {
			ValaMethod* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			ValaMethod* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gchar* _tmp43_;
			_tmp33_ = m;
			_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = m;
			_tmp37_ = vala_symbol_get_name ((ValaSymbol*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = strlen (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = strlen ("_async");
			_tmp42_ = _tmp41_;
			_tmp43_ = string_substring (_tmp35_, (glong) 0, (glong) (_tmp40_ - _tmp42_));
			_g_free0 (finish_method_base);
			finish_method_base = _tmp43_;
		} else {
			ValaMethod* _tmp44_;
			const gchar* _tmp45_;
			const gchar* _tmp46_;
			gchar* _tmp47_;
			_tmp44_ = m;
			_tmp45_ = vala_symbol_get_name ((ValaSymbol*) _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strdup (_tmp46_);
			_g_free0 (finish_method_base);
			finish_method_base = _tmp47_;
		}
	}
	_tmp48_ = node->parent;
	_tmp49_ = finish_method_base;
	_tmp50_ = g_strconcat (_tmp49_, "_finish", NULL);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_gir_parser_node_lookup (_tmp48_, _tmp51_, FALSE, NULL);
	_tmp53_ = _tmp52_;
	_g_free0 (_tmp51_);
	finish_method_node = _tmp53_;
	_tmp54_ = finish_method_node;
	if (_tmp54_ == NULL) {
		gchar* method_cname = NULL;
		gchar* _tmp55_;
		_tmp55_ = vala_gir_parser_node_get_finish_cname (node);
		method_cname = _tmp55_;
		{
			ValaArrayList* _n_list = NULL;
			ValaGirParserNode* _tmp56_;
			ValaArrayList* _tmp57_;
			ValaArrayList* _tmp58_;
			gint _n_size = 0;
			ValaArrayList* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			gint _n_index = 0;
			_tmp56_ = node->parent;
			_tmp57_ = _tmp56_->members;
			_tmp58_ = _vala_iterable_ref0 (_tmp57_);
			_n_list = _tmp58_;
			_tmp59_ = _n_list;
			_tmp60_ = vala_collection_get_size ((ValaCollection*) _tmp59_);
			_tmp61_ = _tmp60_;
			_n_size = _tmp61_;
			_n_index = -1;
			while (TRUE) {
				ValaGirParserNode* n = NULL;
				ValaArrayList* _tmp62_;
				gpointer _tmp63_;
				gboolean _tmp64_ = FALSE;
				ValaGirParserNode* _tmp65_;
				ValaSymbol* _tmp66_;
				_n_index = _n_index + 1;
				if (!(_n_index < _n_size)) {
					break;
				}
				_tmp62_ = _n_list;
				_tmp63_ = vala_list_get ((ValaList*) _tmp62_, _n_index);
				n = (ValaGirParserNode*) _tmp63_;
				_tmp65_ = n;
				_tmp66_ = _tmp65_->symbol;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp66_, VALA_TYPE_METHOD)) {
					ValaGirParserNode* _tmp67_;
					gchar* _tmp68_;
					gchar* _tmp69_;
					const gchar* _tmp70_;
					_tmp67_ = n;
					_tmp68_ = vala_gir_parser_node_get_cname (_tmp67_);
					_tmp69_ = _tmp68_;
					_tmp70_ = method_cname;
					_tmp64_ = g_strcmp0 (_tmp69_, _tmp70_) == 0;
					_g_free0 (_tmp69_);
				} else {
					_tmp64_ = FALSE;
				}
				if (_tmp64_) {
					ValaGirParserNode* _tmp71_;
					ValaGirParserNode* _tmp72_;
					_tmp71_ = n;
					_tmp72_ = _vala_gir_parser_node_ref0 (_tmp71_);
					_vala_gir_parser_node_unref0 (finish_method_node);
					finish_method_node = _tmp72_;
					_vala_gir_parser_node_unref0 (n);
					break;
				}
				_vala_gir_parser_node_unref0 (n);
			}
			_vala_iterable_unref0 (_n_list);
		}
		_g_free0 (method_cname);
	}
	_tmp73_ = m;
	_tmp74_ = _vala_code_node_ref0 (_tmp73_);
	method = _tmp74_;
	_tmp76_ = finish_method_node;
	if (_tmp76_ != NULL) {
		ValaGirParserNode* _tmp77_;
		ValaSymbol* _tmp78_;
		_tmp77_ = finish_method_node;
		_tmp78_ = _tmp77_->symbol;
		_tmp75_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp78_, VALA_TYPE_METHOD);
	} else {
		_tmp75_ = FALSE;
	}
	if (_tmp75_) {
		ValaGirParserNode* _tmp79_;
		ValaMethod* finish_method = NULL;
		ValaGirParserNode* _tmp80_;
		ValaSymbol* _tmp81_;
		ValaMethod* _tmp82_;
		ValaMethod* _tmp83_;
		ValaMethod* _tmp155_;
		ValaMethod* _tmp156_;
		ValaArrayList* error_types = NULL;
		GEqualFunc _tmp186_;
		ValaArrayList* _tmp187_;
		ValaMethod* _tmp188_;
		ValaArrayList* _tmp189_;
		ValaMethod* _tmp190_;
		ValaSourceReference* _tmp191_;
		ValaSourceReference* _tmp192_;
		ValaGirParserNode* _tmp202_;
		ValaGirParserNode* _tmp203_;
		_tmp79_ = finish_method_node;
		vala_gir_parser_node_process (_tmp79_, self);
		_tmp80_ = finish_method_node;
		_tmp81_ = _tmp80_->symbol;
		_tmp82_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, VALA_TYPE_METHOD, ValaMethod));
		finish_method = _tmp82_;
		_tmp83_ = finish_method;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp83_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp84_;
			const gchar* _tmp85_;
			const gchar* _tmp86_;
			ValaMethod* _tmp87_;
			ValaSourceReference* _tmp88_;
			ValaSourceReference* _tmp89_;
			ValaCreationMethod* _tmp90_;
			ValaMethod* _tmp91_;
			ValaMethod* _tmp92_;
			ValaSymbolAccessibility _tmp93_;
			ValaSymbolAccessibility _tmp94_;
			ValaMethod* _tmp95_;
			ValaMethod* _tmp96_;
			ValaMemberBinding _tmp97_;
			ValaMemberBinding _tmp98_;
			ValaMethod* _tmp99_;
			ValaMethod* _tmp100_;
			ValaMethod* _tmp101_;
			ValaMethod* _tmp102_;
			gboolean _tmp103_;
			gboolean _tmp104_;
			ValaMethod* _tmp105_;
			GList* _tmp106_;
			ValaMethod* _tmp111_;
			gchar* _tmp112_;
			gchar* _tmp113_;
			const gchar* _tmp114_;
			ValaMethod* _tmp134_;
			ValaSymbol* _tmp135_;
			_tmp84_ = finish_method;
			_tmp85_ = vala_creation_method_get_class_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			_tmp86_ = _tmp85_;
			_tmp87_ = m;
			_tmp88_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp87_);
			_tmp89_ = _tmp88_;
			_tmp90_ = vala_creation_method_new (_tmp86_, NULL, _tmp89_, NULL);
			_vala_code_node_unref0 (method);
			method = (ValaMethod*) _tmp90_;
			_tmp91_ = method;
			_tmp92_ = m;
			_tmp93_ = vala_symbol_get_access ((ValaSymbol*) _tmp92_);
			_tmp94_ = _tmp93_;
			vala_symbol_set_access ((ValaSymbol*) _tmp91_, _tmp94_);
			_tmp95_ = method;
			_tmp96_ = m;
			_tmp97_ = vala_method_get_binding (_tmp96_);
			_tmp98_ = _tmp97_;
			vala_method_set_binding (_tmp95_, _tmp98_);
			_tmp99_ = method;
			vala_symbol_set_external ((ValaSymbol*) _tmp99_, TRUE);
			_tmp100_ = method;
			vala_method_set_coroutine (_tmp100_, TRUE);
			_tmp101_ = method;
			_tmp102_ = finish_method;
			_tmp103_ = vala_method_get_has_construct_function (_tmp102_);
			_tmp104_ = _tmp103_;
			vala_method_set_has_construct_function (_tmp101_, _tmp104_);
			_tmp105_ = m;
			_tmp106_ = ((ValaCodeNode*) _tmp105_)->attributes;
			{
				GList* a_collection = NULL;
				GList* a_it = NULL;
				a_collection = _tmp106_;
				for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
					ValaAttribute* _tmp107_;
					ValaAttribute* a = NULL;
					_tmp107_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
					a = _tmp107_;
					{
						ValaMethod* _tmp108_;
						ValaAttribute* _tmp109_;
						ValaAttribute* _tmp110_;
						_tmp108_ = method;
						_tmp109_ = a;
						_tmp110_ = _vala_code_node_ref0 (_tmp109_);
						((ValaCodeNode*) _tmp108_)->attributes = g_list_append (((ValaCodeNode*) _tmp108_)->attributes, _tmp110_);
						_vala_code_node_unref0 (a);
					}
				}
			}
			_tmp111_ = method;
			_tmp112_ = vala_gir_parser_node_get_cname (node);
			_tmp113_ = _tmp112_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp111_, "CCode", "cname", _tmp113_, NULL);
			_g_free0 (_tmp113_);
			_tmp114_ = finish_method_base;
			if (g_strcmp0 (_tmp114_, "new") == 0) {
				ValaMethod* _tmp115_;
				_tmp115_ = method;
				vala_symbol_set_name ((ValaSymbol*) _tmp115_, NULL);
			} else {
				const gchar* _tmp116_;
				_tmp116_ = finish_method_base;
				if (g_str_has_prefix (_tmp116_, "new_")) {
					ValaMethod* _tmp117_;
					ValaMethod* _tmp118_;
					const gchar* _tmp119_;
					const gchar* _tmp120_;
					gint _tmp121_;
					gint _tmp122_;
					gchar* _tmp123_;
					gchar* _tmp124_;
					_tmp117_ = method;
					_tmp118_ = m;
					_tmp119_ = vala_symbol_get_name ((ValaSymbol*) _tmp118_);
					_tmp120_ = _tmp119_;
					_tmp121_ = strlen ("new_");
					_tmp122_ = _tmp121_;
					_tmp123_ = string_substring (_tmp120_, (glong) _tmp122_, (glong) -1);
					_tmp124_ = _tmp123_;
					vala_symbol_set_name ((ValaSymbol*) _tmp117_, _tmp124_);
					_g_free0 (_tmp124_);
				}
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp125_;
				ValaList* _tmp126_;
				gint _param_size = 0;
				ValaList* _tmp127_;
				gint _tmp128_;
				gint _tmp129_;
				gint _param_index = 0;
				_tmp125_ = m;
				_tmp126_ = vala_callable_get_parameters ((ValaCallable*) _tmp125_);
				_param_list = _tmp126_;
				_tmp127_ = _param_list;
				_tmp128_ = vala_collection_get_size ((ValaCollection*) _tmp127_);
				_tmp129_ = _tmp128_;
				_param_size = _tmp129_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp130_;
					gpointer _tmp131_;
					ValaMethod* _tmp132_;
					ValaParameter* _tmp133_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp130_ = _param_list;
					_tmp131_ = vala_list_get (_tmp130_, _param_index);
					param = (ValaParameter*) _tmp131_;
					_tmp132_ = method;
					_tmp133_ = param;
					vala_callable_add_parameter ((ValaCallable*) _tmp132_, _tmp133_);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp134_ = method;
			_tmp135_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp134_);
			_vala_code_node_unref0 (node->symbol);
			node->symbol = _tmp135_;
		} else {
			ValaMethod* _tmp136_;
			ValaMethod* _tmp137_;
			ValaDataType* _tmp138_;
			ValaDataType* _tmp139_;
			ValaDataType* _tmp140_;
			ValaDataType* _tmp141_;
			ValaAttribute* a = NULL;
			ValaMethod* _tmp142_;
			ValaAttribute* _tmp143_;
			ValaAttribute* _tmp144_;
			gboolean _tmp145_ = FALSE;
			ValaAttribute* _tmp146_;
			gboolean _tmp150_ = FALSE;
			ValaAttribute* _tmp151_;
			_tmp136_ = method;
			_tmp137_ = finish_method;
			_tmp138_ = vala_callable_get_return_type ((ValaCallable*) _tmp137_);
			_tmp139_ = _tmp138_;
			_tmp140_ = vala_data_type_copy (_tmp139_);
			_tmp141_ = _tmp140_;
			vala_callable_set_return_type ((ValaCallable*) _tmp136_, _tmp141_);
			_vala_code_node_unref0 (_tmp141_);
			_tmp142_ = finish_method;
			_tmp143_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp142_, "CCode");
			_tmp144_ = _vala_code_node_ref0 (_tmp143_);
			a = _tmp144_;
			_tmp146_ = a;
			if (_tmp146_ != NULL) {
				ValaAttribute* _tmp147_;
				_tmp147_ = a;
				_tmp145_ = vala_attribute_has_argument (_tmp147_, "array_length");
			} else {
				_tmp145_ = FALSE;
			}
			if (_tmp145_) {
				ValaMethod* _tmp148_;
				ValaAttribute* _tmp149_;
				_tmp148_ = method;
				_tmp149_ = a;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp148_, "CCode", "array_length", vala_attribute_get_bool (_tmp149_, "array_length", FALSE), NULL);
			}
			_tmp151_ = a;
			if (_tmp151_ != NULL) {
				ValaAttribute* _tmp152_;
				_tmp152_ = a;
				_tmp150_ = vala_attribute_has_argument (_tmp152_, "array_null_terminated");
			} else {
				_tmp150_ = FALSE;
			}
			if (_tmp150_) {
				ValaMethod* _tmp153_;
				ValaAttribute* _tmp154_;
				_tmp153_ = method;
				_tmp154_ = a;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp153_, "CCode", "array_null_terminated", vala_attribute_get_bool (_tmp154_, "array_null_terminated", FALSE), NULL);
			}
			_vala_code_node_unref0 (a);
		}
		_tmp155_ = method;
		_tmp156_ = finish_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp155_, (ValaCodeNode*) _tmp156_, "CCode", "async_result_pos");
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp157_;
			ValaList* _tmp158_;
			gint _param_size = 0;
			ValaList* _tmp159_;
			gint _tmp160_;
			gint _tmp161_;
			gint _param_index = 0;
			_tmp157_ = finish_method;
			_tmp158_ = vala_callable_get_parameters ((ValaCallable*) _tmp157_);
			_param_list = _tmp158_;
			_tmp159_ = _param_list;
			_tmp160_ = vala_collection_get_size ((ValaCollection*) _tmp159_);
			_tmp161_ = _tmp160_;
			_param_size = _tmp161_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp162_;
				gpointer _tmp163_;
				ValaParameter* _tmp164_;
				ValaParameterDirection _tmp165_;
				ValaParameterDirection _tmp166_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp162_ = _param_list;
				_tmp163_ = vala_list_get (_tmp162_, _param_index);
				param = (ValaParameter*) _tmp163_;
				_tmp164_ = param;
				_tmp165_ = vala_parameter_get_direction (_tmp164_);
				_tmp166_ = _tmp165_;
				if (_tmp166_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaParameter* async_param = NULL;
					ValaParameter* _tmp167_;
					ValaParameter* _tmp168_;
					ValaMethod* _tmp169_;
					ValaScope* _tmp170_;
					ValaScope* _tmp171_;
					ValaParameter* _tmp172_;
					const gchar* _tmp173_;
					const gchar* _tmp174_;
					ValaSymbol* _tmp175_;
					ValaSymbol* _tmp176_;
					gboolean _tmp177_;
					ValaMethod* _tmp184_;
					ValaParameter* _tmp185_;
					_tmp167_ = param;
					_tmp168_ = vala_parameter_copy (_tmp167_);
					async_param = _tmp168_;
					_tmp169_ = method;
					_tmp170_ = vala_symbol_get_scope ((ValaSymbol*) _tmp169_);
					_tmp171_ = _tmp170_;
					_tmp172_ = param;
					_tmp173_ = vala_symbol_get_name ((ValaSymbol*) _tmp172_);
					_tmp174_ = _tmp173_;
					_tmp175_ = vala_scope_lookup (_tmp171_, _tmp174_);
					_tmp176_ = _tmp175_;
					_tmp177_ = _tmp176_ != NULL;
					_vala_code_node_unref0 (_tmp176_);
					if (_tmp177_) {
						ValaParameter* _tmp178_;
						ValaParameter* _tmp179_;
						const gchar* _tmp180_;
						const gchar* _tmp181_;
						gchar* _tmp182_;
						gchar* _tmp183_;
						_tmp178_ = async_param;
						_tmp179_ = async_param;
						_tmp180_ = vala_symbol_get_name ((ValaSymbol*) _tmp179_);
						_tmp181_ = _tmp180_;
						_tmp182_ = g_strconcat (_tmp181_, "_out", NULL);
						_tmp183_ = _tmp182_;
						vala_symbol_set_name ((ValaSymbol*) _tmp179_, _tmp183_);
						_g_free0 (_tmp183_);
					}
					_tmp184_ = method;
					_tmp185_ = async_param;
					vala_callable_add_parameter ((ValaCallable*) _tmp184_, _tmp185_);
					_vala_code_node_unref0 (async_param);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp186_ = g_direct_equal;
		_tmp187_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp186_);
		error_types = _tmp187_;
		_tmp188_ = finish_method;
		_tmp189_ = error_types;
		_tmp190_ = method;
		_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp190_);
		_tmp192_ = _tmp191_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp188_, (ValaCollection*) _tmp189_, _tmp192_);
		{
			ValaArrayList* _error_type_list = NULL;
			ValaArrayList* _tmp193_;
			ValaArrayList* _tmp194_;
			gint _error_type_size = 0;
			ValaArrayList* _tmp195_;
			gint _tmp196_;
			gint _tmp197_;
			gint _error_type_index = 0;
			_tmp193_ = error_types;
			_tmp194_ = _vala_iterable_ref0 (_tmp193_);
			_error_type_list = _tmp194_;
			_tmp195_ = _error_type_list;
			_tmp196_ = vala_collection_get_size ((ValaCollection*) _tmp195_);
			_tmp197_ = _tmp196_;
			_error_type_size = _tmp197_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaArrayList* _tmp198_;
				gpointer _tmp199_;
				ValaMethod* _tmp200_;
				ValaDataType* _tmp201_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp198_ = _error_type_list;
				_tmp199_ = vala_list_get ((ValaList*) _tmp198_, _error_type_index);
				error_type = (ValaDataType*) _tmp199_;
				_tmp200_ = method;
				_tmp201_ = error_type;
				vala_method_add_error_type (_tmp200_, _tmp201_);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
		_tmp202_ = finish_method_node;
		_tmp202_->processed = TRUE;
		_tmp203_ = finish_method_node;
		_tmp203_->merged = TRUE;
		_vala_iterable_unref0 (error_types);
		_vala_code_node_unref0 (finish_method);
	}
	_vala_code_node_unref0 (method);
	_vala_gir_parser_node_unref0 (finish_method_node);
	_g_free0 (finish_method_base);
	_vala_code_node_unref0 (m);
}

static guint
vala_gir_parser_unresolved_symbol_hash (ValaUnresolvedSymbol* sym)
{
	guint result = 0U;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp6_;
	const gchar* _tmp7_;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	while (TRUE) {
		GString* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		ValaUnresolvedSymbol* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		if (!(sym != NULL)) {
			break;
		}
		_tmp1_ = builder;
		_tmp2_ = vala_symbol_get_name ((ValaSymbol*) sym);
		_tmp3_ = _tmp2_;
		g_string_append (_tmp1_, _tmp3_);
		_tmp4_ = vala_unresolved_symbol_get_inner (sym);
		_tmp5_ = _tmp4_;
		sym = _tmp5_;
	}
	_tmp6_ = builder;
	_tmp7_ = _tmp6_->str;
	result = g_str_hash (_tmp7_);
	_g_string_free0 (builder);
	return result;
}

static gboolean
vala_gir_parser_unresolved_symbol_equal (ValaUnresolvedSymbol* sym1,
                                         ValaUnresolvedSymbol* sym2)
{
	gboolean result = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		ValaUnresolvedSymbol* _tmp7_;
		ValaUnresolvedSymbol* _tmp8_;
		if (!(sym1 != sym2)) {
			break;
		}
		if (sym1 == NULL) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = sym2 == NULL;
		}
		if (_tmp0_) {
			result = FALSE;
			return result;
		}
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) sym1);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) sym2);
		_tmp4_ = _tmp3_;
		if (g_strcmp0 (_tmp2_, _tmp4_) != 0) {
			result = FALSE;
			return result;
		}
		_tmp5_ = vala_unresolved_symbol_get_inner (sym1);
		_tmp6_ = _tmp5_;
		sym1 = _tmp6_;
		_tmp7_ = vala_unresolved_symbol_get_inner (sym2);
		_tmp8_ = _tmp7_;
		sym2 = _tmp8_;
	}
	result = TRUE;
	return result;
}

static ValaGirParserNode*
vala_gir_parser_base_interface_property (ValaGirParser* self,
                                         ValaGirParserNode* prop_node)
{
	ValaGirParserNode* result = NULL;
	ValaClass* cl = NULL;
	ValaGirParserNode* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaClass* _tmp2_;
	ValaClass* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop_node != NULL, NULL);
	_tmp0_ = prop_node->parent;
	_tmp1_ = _tmp0_->symbol;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp1_) : NULL);
	cl = _tmp2_;
	_tmp3_ = cl;
	if (_tmp3_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (cl);
		return result;
	}
	{
		ValaList* _type_list = NULL;
		ValaClass* _tmp4_;
		ValaList* _tmp5_;
		gint _type_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_index = 0;
		_tmp4_ = cl;
		_tmp5_ = vala_class_get_base_types (_tmp4_);
		_type_list = _tmp5_;
		_tmp6_ = _type_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_size = _tmp8_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			ValaGirParserNode* base_node = NULL;
			ValaGirParserNode* _tmp12_;
			ValaDataType* _tmp13_;
			ValaUnresolvedSymbol* _tmp14_;
			ValaUnresolvedSymbol* _tmp15_;
			ValaGirParserNode* _tmp16_;
			gboolean _tmp17_ = FALSE;
			ValaGirParserNode* _tmp18_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp9_ = _type_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_index);
			type = (ValaDataType*) _tmp10_;
			_tmp11_ = type;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_UNRESOLVED_TYPE)) {
				_vala_code_node_unref0 (type);
				continue;
			}
			_tmp12_ = prop_node->parent;
			_tmp13_ = type;
			_tmp14_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_gir_parser_resolve_node (self, _tmp12_, _tmp15_, FALSE);
			base_node = _tmp16_;
			_tmp18_ = base_node;
			if (_tmp18_ != NULL) {
				ValaGirParserNode* _tmp19_;
				ValaSymbol* _tmp20_;
				_tmp19_ = base_node;
				_tmp20_ = _tmp19_->symbol;
				_tmp17_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_INTERFACE);
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				ValaGirParserNode* base_prop_node = NULL;
				ValaGirParserNode* _tmp21_;
				const gchar* _tmp22_;
				ValaGirParserNode* _tmp23_;
				gboolean _tmp24_ = FALSE;
				ValaGirParserNode* _tmp25_;
				_tmp21_ = base_node;
				_tmp22_ = prop_node->name;
				_tmp23_ = vala_gir_parser_node_lookup (_tmp21_, _tmp22_, FALSE, NULL);
				base_prop_node = _tmp23_;
				_tmp25_ = base_prop_node;
				if (_tmp25_ != NULL) {
					ValaGirParserNode* _tmp26_;
					ValaSymbol* _tmp27_;
					_tmp26_ = base_prop_node;
					_tmp27_ = _tmp26_->symbol;
					_tmp24_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_PROPERTY);
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					ValaProperty* base_property = NULL;
					ValaGirParserNode* _tmp28_;
					ValaSymbol* _tmp29_;
					ValaProperty* _tmp30_;
					gboolean _tmp31_ = FALSE;
					ValaProperty* _tmp32_;
					gboolean _tmp33_;
					gboolean _tmp34_;
					_tmp28_ = base_prop_node;
					_tmp29_ = _tmp28_->symbol;
					_tmp30_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_PROPERTY, ValaProperty));
					base_property = _tmp30_;
					_tmp32_ = base_property;
					_tmp33_ = vala_property_get_is_abstract (_tmp32_);
					_tmp34_ = _tmp33_;
					if (_tmp34_) {
						_tmp31_ = TRUE;
					} else {
						ValaProperty* _tmp35_;
						gboolean _tmp36_;
						gboolean _tmp37_;
						_tmp35_ = base_property;
						_tmp36_ = vala_property_get_is_virtual (_tmp35_);
						_tmp37_ = _tmp36_;
						_tmp31_ = _tmp37_;
					}
					if (_tmp31_) {
						result = base_prop_node;
						_vala_code_node_unref0 (base_property);
						_vala_gir_parser_node_unref0 (base_node);
						_vala_code_node_unref0 (type);
						_vala_iterable_unref0 (_type_list);
						_vala_code_node_unref0 (cl);
						return result;
					}
					_vala_code_node_unref0 (base_property);
				}
				_vala_gir_parser_node_unref0 (base_prop_node);
			}
			_vala_gir_parser_node_unref0 (base_node);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	result = NULL;
	_vala_code_node_unref0 (cl);
	return result;
}

ValaGirParser*
vala_gir_parser_construct (GType object_type)
{
	ValaGirParser* self = NULL;
	self = (ValaGirParser*) vala_code_visitor_construct (object_type);
	return self;
}

ValaGirParser*
vala_gir_parser_new (void)
{
	return vala_gir_parser_construct (VALA_TYPE_GIR_PARSER);
}

static gpointer
_vala_source_reference_ref0 (gpointer self)
{
	return self ? vala_source_reference_ref (self) : NULL;
}

static ValaGirParserArgument*
vala_gir_parser_argument_construct (GType object_type,
                                    ValaExpression* expression,
                                    ValaSourceReference* source_reference)
{
	ValaGirParserArgument* self = NULL;
	ValaExpression* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (expression != NULL, NULL);
	self = (ValaGirParserArgument*) g_type_create_instance (object_type);
	_tmp0_ = _vala_code_node_ref0 (expression);
	_vala_code_node_unref0 (self->expression);
	self->expression = _tmp0_;
	_tmp1_ = _vala_source_reference_ref0 (source_reference);
	_vala_source_reference_unref0 (self->source_reference);
	self->source_reference = _tmp1_;
	return self;
}

static ValaGirParserArgument*
vala_gir_parser_argument_new (ValaExpression* expression,
                              ValaSourceReference* source_reference)
{
	return vala_gir_parser_argument_construct (VALA_GIR_PARSER_TYPE_ARGUMENT, expression, source_reference);
}

static void
vala_gir_parser_value_argument_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_argument_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_argument_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_argument_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_argument_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_argument_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_argument_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserArgument * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_argument_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_argument_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	ValaGirParserArgument ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_argument_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_argument (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	ValaGirParserParamSpecArgument* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_ARGUMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_argument (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_argument (GValue* value,
                                    gpointer v_object)
{
	ValaGirParserArgument * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_ARGUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_argument_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_argument_unref (old);
	}
}

static void
vala_gir_parser_value_take_argument (GValue* value,
                                     gpointer v_object)
{
	ValaGirParserArgument * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_ARGUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_argument_unref (old);
	}
}

static void
vala_gir_parser_argument_class_init (ValaGirParserArgumentClass * klass,
                                     gpointer klass_data)
{
	vala_gir_parser_argument_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserArgumentClass *) klass)->finalize = vala_gir_parser_argument_finalize;
}

static void
vala_gir_parser_argument_instance_init (ValaGirParserArgument * self,
                                        gpointer klass)
{
	self->used = FALSE;
	self->ref_count = 1;
}

static void
vala_gir_parser_argument_finalize (ValaGirParserArgument * obj)
{
	ValaGirParserArgument * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgument);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->expression);
	_vala_source_reference_unref0 (self->source_reference);
}

static GType
vala_gir_parser_argument_get_type (void)
{
	static volatile gsize vala_gir_parser_argument_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_argument_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_argument_init, vala_gir_parser_value_argument_free_value, vala_gir_parser_value_argument_copy_value, vala_gir_parser_value_argument_peek_pointer, "p", vala_gir_parser_value_argument_collect_value, "p", vala_gir_parser_value_argument_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserArgumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_argument_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserArgument), 0, (GInstanceInitFunc) vala_gir_parser_argument_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_gir_parser_argument_type_id;
		vala_gir_parser_argument_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserArgument", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_gir_parser_argument_type_id__volatile, vala_gir_parser_argument_type_id);
	}
	return vala_gir_parser_argument_type_id__volatile;
}

static gpointer
vala_gir_parser_argument_ref (gpointer instance)
{
	ValaGirParserArgument * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_argument_unref (gpointer instance)
{
	ValaGirParserArgument * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_ARGUMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static ValaGirParserMetadataSet*
vala_gir_parser_metadata_set_construct (GType object_type,
                                        const gchar* selector)
{
	ValaGirParserMetadataSet* self = NULL;
	self = (ValaGirParserMetadataSet*) vala_gir_parser_metadata_construct (object_type, "", selector, NULL);
	return self;
}

static ValaGirParserMetadataSet*
vala_gir_parser_metadata_set_new (const gchar* selector)
{
	return vala_gir_parser_metadata_set_construct (VALA_GIR_PARSER_TYPE_METADATA_SET, selector);
}

static void
vala_gir_parser_metadata_set_add_sibling (ValaGirParserMetadataSet* self,
                                          ValaGirParserMetadata* metadata)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	{
		ValaArrayList* _child_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _child_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _child_index = 0;
		_tmp0_ = metadata->children;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_child_list = _tmp1_;
		_tmp2_ = _child_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_child_size = _tmp4_;
		_child_index = -1;
		while (TRUE) {
			ValaGirParserMetadata* child = NULL;
			ValaArrayList* _tmp5_;
			gpointer _tmp6_;
			ValaGirParserMetadata* _tmp7_;
			_child_index = _child_index + 1;
			if (!(_child_index < _child_size)) {
				break;
			}
			_tmp5_ = _child_list;
			_tmp6_ = vala_list_get ((ValaList*) _tmp5_, _child_index);
			child = (ValaGirParserMetadata*) _tmp6_;
			_tmp7_ = child;
			vala_gir_parser_metadata_add_child ((ValaGirParserMetadata*) self, _tmp7_);
			_vala_gir_parser_metadata_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
	{
		ValaIterator* _key_it = NULL;
		ValaMap* _tmp8_;
		ValaSet* _tmp9_;
		ValaSet* _tmp10_;
		ValaIterator* _tmp11_;
		ValaIterator* _tmp12_;
		_tmp8_ = metadata->args;
		_tmp9_ = vala_map_get_keys (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_iterable_iterator ((ValaIterable*) _tmp10_);
		_tmp12_ = _tmp11_;
		_vala_iterable_unref0 (_tmp10_);
		_key_it = _tmp12_;
		while (TRUE) {
			ValaIterator* _tmp13_;
			ValaGirParserArgumentType key = 0;
			ValaIterator* _tmp14_;
			gpointer _tmp15_;
			ValaMap* _tmp16_;
			ValaGirParserArgumentType _tmp17_;
			ValaMap* _tmp18_;
			ValaGirParserArgumentType _tmp19_;
			gpointer _tmp20_;
			ValaGirParserArgument* _tmp21_;
			_tmp13_ = _key_it;
			if (!vala_iterator_next (_tmp13_)) {
				break;
			}
			_tmp14_ = _key_it;
			_tmp15_ = vala_iterator_get (_tmp14_);
			key = (ValaGirParserArgumentType) ((gintptr) _tmp15_);
			_tmp16_ = ((ValaGirParserMetadata*) self)->args;
			_tmp17_ = key;
			_tmp18_ = metadata->args;
			_tmp19_ = key;
			_tmp20_ = vala_map_get (_tmp18_, (gpointer) ((gintptr) _tmp19_));
			_tmp21_ = (ValaGirParserArgument*) _tmp20_;
			vala_map_set (_tmp16_, (gpointer) ((gintptr) _tmp17_), _tmp21_);
			_vala_gir_parser_argument_unref0 (_tmp21_);
		}
		_vala_iterator_unref0 (_key_it);
	}
}

static void
vala_gir_parser_metadata_set_class_init (ValaGirParserMetadataSetClass * klass,
                                         gpointer klass_data)
{
	vala_gir_parser_metadata_set_parent_class = g_type_class_peek_parent (klass);
}

static void
vala_gir_parser_metadata_set_instance_init (ValaGirParserMetadataSet * self,
                                            gpointer klass)
{
}

static GType
vala_gir_parser_metadata_set_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_set_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadataSet), 0, (GInstanceInitFunc) vala_gir_parser_metadata_set_instance_init, NULL };
		GType vala_gir_parser_metadata_set_type_id;
		vala_gir_parser_metadata_set_type_id = g_type_register_static (VALA_GIR_PARSER_TYPE_METADATA, "ValaGirParserMetadataSet", &g_define_type_info, 0);
		g_once_init_leave (&vala_gir_parser_metadata_set_type_id__volatile, vala_gir_parser_metadata_set_type_id);
	}
	return vala_gir_parser_metadata_set_type_id__volatile;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_construct (GType object_type,
                                    const gchar* pattern,
                                    const gchar* selector,
                                    ValaSourceReference* source_reference)
{
	ValaGirParserMetadata* self = NULL;
	GPatternSpec* _tmp0_;
	gchar* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_val_if_fail (pattern != NULL, NULL);
	self = (ValaGirParserMetadata*) g_type_create_instance (object_type);
	_tmp0_ = g_pattern_spec_new (pattern);
	_g_pattern_spec_free0 (self->pattern_spec);
	self->pattern_spec = _tmp0_;
	_tmp1_ = g_strdup (selector);
	_g_free0 (self->selector);
	self->selector = _tmp1_;
	_tmp2_ = _vala_source_reference_ref0 (source_reference);
	_vala_source_reference_unref0 (self->source_reference);
	self->source_reference = _tmp2_;
	return self;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_new (const gchar* pattern,
                              const gchar* selector,
                              ValaSourceReference* source_reference)
{
	return vala_gir_parser_metadata_construct (VALA_GIR_PARSER_TYPE_METADATA, pattern, selector, source_reference);
}

static void
vala_gir_parser_metadata_add_child (ValaGirParserMetadata* self,
                                    ValaGirParserMetadata* metadata)
{
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = self->children;
	vala_collection_add ((ValaCollection*) _tmp0_, metadata);
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_match_child (ValaGirParserMetadata* self,
                                      const gchar* name,
                                      const gchar* selector)
{
	ValaGirParserMetadata* result = NULL;
	ValaGirParserMetadata* _result_ = NULL;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_gir_parser_metadata_ref0 (_tmp1_);
	_result_ = _tmp2_;
	{
		ValaArrayList* _metadata_list = NULL;
		ValaArrayList* _tmp3_;
		ValaArrayList* _tmp4_;
		gint _metadata_size = 0;
		ValaArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _metadata_index = 0;
		_tmp3_ = self->children;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_metadata_list = _tmp4_;
		_tmp5_ = _metadata_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_metadata_size = _tmp7_;
		_metadata_index = -1;
		while (TRUE) {
			ValaGirParserMetadata* metadata = NULL;
			ValaArrayList* _tmp8_;
			gpointer _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			_metadata_index = _metadata_index + 1;
			if (!(_metadata_index < _metadata_size)) {
				break;
			}
			_tmp8_ = _metadata_list;
			_tmp9_ = vala_list_get ((ValaList*) _tmp8_, _metadata_index);
			metadata = (ValaGirParserMetadata*) _tmp9_;
			if (selector == NULL) {
				_tmp12_ = TRUE;
			} else {
				ValaGirParserMetadata* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = metadata;
				_tmp14_ = _tmp13_->selector;
				_tmp12_ = _tmp14_ == NULL;
			}
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				ValaGirParserMetadata* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = metadata;
				_tmp16_ = _tmp15_->selector;
				_tmp11_ = g_strcmp0 (_tmp16_, selector) == 0;
			}
			if (_tmp11_) {
				ValaGirParserMetadata* _tmp17_;
				GPatternSpec* _tmp18_;
				_tmp17_ = metadata;
				_tmp18_ = _tmp17_->pattern_spec;
				_tmp10_ = g_pattern_match_string (_tmp18_, name);
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				ValaGirParserMetadata* _tmp19_;
				ValaGirParserMetadata* _tmp20_;
				ValaGirParserMetadata* _tmp21_;
				ValaGirParserMetadata* _tmp22_;
				_tmp19_ = metadata;
				_tmp19_->used = TRUE;
				_tmp20_ = _result_;
				_tmp21_ = vala_gir_parser_metadata_get_empty ();
				_tmp22_ = _tmp21_;
				if (_tmp20_ == _tmp22_) {
					ValaGirParserMetadata* _tmp23_;
					ValaGirParserMetadata* _tmp24_;
					_tmp23_ = metadata;
					_tmp24_ = _vala_gir_parser_metadata_ref0 (_tmp23_);
					_vala_gir_parser_metadata_unref0 (_result_);
					_result_ = _tmp24_;
				} else {
					ValaGirParserMetadataSet* ms = NULL;
					ValaGirParserMetadata* _tmp25_;
					ValaGirParserMetadataSet* _tmp26_;
					ValaGirParserMetadataSet* _tmp27_;
					ValaGirParserMetadataSet* _tmp31_;
					ValaGirParserMetadata* _tmp32_;
					ValaGirParserMetadataSet* _tmp33_;
					ValaGirParserMetadata* _tmp34_;
					_tmp25_ = _result_;
					_tmp26_ = _vala_gir_parser_metadata_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_GIR_PARSER_TYPE_METADATA_SET) ? ((ValaGirParserMetadataSet*) _tmp25_) : NULL);
					ms = _tmp26_;
					_tmp27_ = ms;
					if (_tmp27_ == NULL) {
						ValaGirParserMetadataSet* _tmp28_;
						ValaGirParserMetadataSet* _tmp29_;
						ValaGirParserMetadata* _tmp30_;
						_tmp28_ = vala_gir_parser_metadata_set_new (selector);
						_vala_gir_parser_metadata_unref0 (ms);
						ms = _tmp28_;
						_tmp29_ = ms;
						_tmp30_ = _result_;
						vala_gir_parser_metadata_set_add_sibling (_tmp29_, _tmp30_);
					}
					_tmp31_ = ms;
					_tmp32_ = metadata;
					vala_gir_parser_metadata_set_add_sibling (_tmp31_, _tmp32_);
					_tmp33_ = ms;
					_tmp34_ = _vala_gir_parser_metadata_ref0 ((ValaGirParserMetadata*) _tmp33_);
					_vala_gir_parser_metadata_unref0 (_result_);
					_result_ = _tmp34_;
					_vala_gir_parser_metadata_unref0 (ms);
				}
			}
			_vala_gir_parser_metadata_unref0 (metadata);
		}
		_vala_iterable_unref0 (_metadata_list);
	}
	result = _result_;
	return result;
}

static void
vala_gir_parser_metadata_add_argument (ValaGirParserMetadata* self,
                                       ValaGirParserArgumentType key,
                                       ValaGirParserArgument* value)
{
	ValaMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->args;
	vala_map_set (_tmp0_, (gpointer) ((gintptr) key), value);
}

static gboolean
vala_gir_parser_metadata_has_argument (ValaGirParserMetadata* self,
                                       ValaGirParserArgumentType key)
{
	gboolean result = FALSE;
	ValaMap* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->args;
	result = vala_map_contains (_tmp0_, (gpointer) ((gintptr) key));
	return result;
}

static ValaExpression*
vala_gir_parser_metadata_get_expression (ValaGirParserMetadata* self,
                                         ValaGirParserArgumentType arg)
{
	ValaExpression* result = NULL;
	ValaGirParserArgument* val = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserArgument* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->args;
	_tmp1_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) arg));
	val = (ValaGirParserArgument*) _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		ValaGirParserArgument* _tmp3_;
		ValaGirParserArgument* _tmp4_;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp3_ = val;
		_tmp3_->used = TRUE;
		_tmp4_ = val;
		_tmp5_ = _tmp4_->expression;
		_tmp6_ = _vala_code_node_ref0 (_tmp5_);
		result = _tmp6_;
		_vala_gir_parser_argument_unref0 (val);
		return result;
	}
	result = NULL;
	_vala_gir_parser_argument_unref0 (val);
	return result;
}

static gchar*
vala_gir_parser_metadata_get_string (ValaGirParserMetadata* self,
                                     ValaGirParserArgumentType arg)
{
	gchar* result = NULL;
	ValaStringLiteral* lit = NULL;
	ValaExpression* _tmp0_;
	ValaStringLiteral* _tmp1_;
	ValaStringLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_STRING_LITERAL) ? ((ValaStringLiteral*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	lit = _tmp1_;
	_tmp2_ = lit;
	if (_tmp2_ != NULL) {
		ValaStringLiteral* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = lit;
		_tmp4_ = vala_string_literal_eval (_tmp3_);
		result = _tmp4_;
		_vala_code_node_unref0 (lit);
		return result;
	}
	result = NULL;
	_vala_code_node_unref0 (lit);
	return result;
}

static gint
vala_gir_parser_metadata_get_integer (ValaGirParserMetadata* self,
                                      ValaGirParserArgumentType arg)
{
	gint result = 0;
	ValaUnaryExpression* unary = NULL;
	ValaExpression* _tmp0_;
	ValaUnaryExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaUnaryExpression* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	unary = _tmp1_;
	_tmp3_ = unary;
	if (_tmp3_ != NULL) {
		ValaUnaryExpression* _tmp4_;
		ValaUnaryOperator _tmp5_;
		ValaUnaryOperator _tmp6_;
		_tmp4_ = unary;
		_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == VALA_UNARY_OPERATOR_MINUS;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaIntegerLiteral* lit = NULL;
		ValaUnaryExpression* _tmp7_;
		ValaExpression* _tmp8_;
		ValaExpression* _tmp9_;
		ValaIntegerLiteral* _tmp10_;
		ValaIntegerLiteral* _tmp11_;
		_tmp7_ = unary;
		_tmp8_ = vala_unary_expression_get_inner (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_INTEGER_LITERAL) ? ((ValaIntegerLiteral*) _tmp9_) : NULL);
		lit = _tmp10_;
		_tmp11_ = lit;
		if (_tmp11_ != NULL) {
			ValaIntegerLiteral* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp12_ = lit;
			_tmp13_ = vala_integer_literal_get_value (_tmp12_);
			_tmp14_ = _tmp13_;
			result = -atoi (_tmp14_);
			_vala_code_node_unref0 (lit);
			_vala_code_node_unref0 (unary);
			return result;
		}
		_vala_code_node_unref0 (lit);
	} else {
		ValaIntegerLiteral* lit = NULL;
		ValaExpression* _tmp15_;
		ValaIntegerLiteral* _tmp16_;
		ValaIntegerLiteral* _tmp17_;
		_tmp15_ = vala_gir_parser_metadata_get_expression (self, arg);
		_tmp16_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_INTEGER_LITERAL) ? ((ValaIntegerLiteral*) _tmp15_) : NULL;
		if (_tmp16_ == NULL) {
			_vala_code_node_unref0 (_tmp15_);
		}
		lit = _tmp16_;
		_tmp17_ = lit;
		if (_tmp17_ != NULL) {
			ValaIntegerLiteral* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = lit;
			_tmp19_ = vala_integer_literal_get_value (_tmp18_);
			_tmp20_ = _tmp19_;
			result = atoi (_tmp20_);
			_vala_code_node_unref0 (lit);
			_vala_code_node_unref0 (unary);
			return result;
		}
		_vala_code_node_unref0 (lit);
	}
	result = 0;
	_vala_code_node_unref0 (unary);
	return result;
}

static gboolean
vala_gir_parser_metadata_get_bool (ValaGirParserMetadata* self,
                                   ValaGirParserArgumentType arg,
                                   gboolean default_value)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* lit = NULL;
	ValaExpression* _tmp0_;
	ValaBooleanLiteral* _tmp1_;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_BOOLEAN_LITERAL) ? ((ValaBooleanLiteral*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	lit = _tmp1_;
	_tmp2_ = lit;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = lit;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		result = _tmp5_;
		_vala_code_node_unref0 (lit);
		return result;
	}
	result = default_value;
	_vala_code_node_unref0 (lit);
	return result;
}

static ValaSourceReference*
vala_gir_parser_metadata_get_source_reference (ValaGirParserMetadata* self,
                                               ValaGirParserArgumentType arg)
{
	ValaSourceReference* result = NULL;
	ValaGirParserArgument* val = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserArgument* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->args;
	_tmp1_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) arg));
	val = (ValaGirParserArgument*) _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		ValaGirParserArgument* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		_tmp3_ = val;
		_tmp4_ = _tmp3_->source_reference;
		_tmp5_ = _vala_source_reference_ref0 (_tmp4_);
		result = _tmp5_;
		_vala_gir_parser_argument_unref0 (val);
		return result;
	}
	result = NULL;
	_vala_gir_parser_argument_unref0 (val);
	return result;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_get_empty (void)
{
	ValaGirParserMetadata* result;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp2_;
	_tmp0_ = vala_gir_parser_metadata__empty;
	if (_tmp0_ == NULL) {
		ValaGirParserMetadata* _tmp1_;
		_tmp1_ = vala_gir_parser_metadata_new ("", NULL, NULL);
		_vala_gir_parser_metadata_unref0 (vala_gir_parser_metadata__empty);
		vala_gir_parser_metadata__empty = _tmp1_;
	}
	_tmp2_ = vala_gir_parser_metadata__empty;
	result = _tmp2_;
	return result;
}

static void
vala_gir_parser_value_metadata_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_metadata_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_metadata_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_metadata_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_metadata_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_metadata_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_metadata_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserMetadata * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_metadata_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_metadata_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	ValaGirParserMetadata ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_metadata_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_metadata (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	ValaGirParserParamSpecMetadata* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_METADATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_metadata (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_metadata (GValue* value,
                                    gpointer v_object)
{
	ValaGirParserMetadata * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_metadata_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_unref (old);
	}
}

static void
vala_gir_parser_value_take_metadata (GValue* value,
                                     gpointer v_object)
{
	ValaGirParserMetadata * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_unref (old);
	}
}

static void
vala_gir_parser_metadata_class_init (ValaGirParserMetadataClass * klass,
                                     gpointer klass_data)
{
	vala_gir_parser_metadata_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserMetadataClass *) klass)->finalize = vala_gir_parser_metadata_finalize;
}

static void
vala_gir_parser_metadata_instance_init (ValaGirParserMetadata * self,
                                        gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	self->used = FALSE;
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE, NULL, NULL, VALA_GIR_PARSER_TYPE_ARGUMENT, (GBoxedCopyFunc) vala_gir_parser_argument_ref, (GDestroyNotify) vala_gir_parser_argument_unref, _tmp0_, _tmp1_, _tmp2_);
	self->args = (ValaMap*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp4_);
	self->children = _tmp5_;
	self->ref_count = 1;
}

static void
vala_gir_parser_metadata_finalize (ValaGirParserMetadata * obj)
{
	ValaGirParserMetadata * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadata);
	g_signal_handlers_destroy (self);
	_g_pattern_spec_free0 (self->pattern_spec);
	_g_free0 (self->selector);
	_vala_source_reference_unref0 (self->source_reference);
	_vala_map_unref0 (self->args);
	_vala_iterable_unref0 (self->children);
}

static GType
vala_gir_parser_metadata_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_metadata_init, vala_gir_parser_value_metadata_free_value, vala_gir_parser_value_metadata_copy_value, vala_gir_parser_value_metadata_peek_pointer, "p", vala_gir_parser_value_metadata_collect_value, "p", vala_gir_parser_value_metadata_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadata), 0, (GInstanceInitFunc) vala_gir_parser_metadata_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_gir_parser_metadata_type_id;
		vala_gir_parser_metadata_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserMetadata", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_gir_parser_metadata_type_id__volatile, vala_gir_parser_metadata_type_id);
	}
	return vala_gir_parser_metadata_type_id__volatile;
}

static gpointer
vala_gir_parser_metadata_ref (gpointer instance)
{
	ValaGirParserMetadata * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_metadata_unref (gpointer instance)
{
	ValaGirParserMetadata * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_METADATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
vala_gir_parser_metadata_parser_get_instance_private (ValaGirParserMetadataParser* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGirParserMetadataParser_private_offset);
}

static ValaGirParserMetadataParser*
vala_gir_parser_metadata_parser_construct (GType object_type)
{
	ValaGirParserMetadataParser* self = NULL;
	ValaGirParserMetadata* _tmp0_;
	self = (ValaGirParserMetadataParser*) g_type_create_instance (object_type);
	_tmp0_ = self->priv->tree;
	_tmp0_->used = TRUE;
	return self;
}

static ValaGirParserMetadataParser*
vala_gir_parser_metadata_parser_new (void)
{
	return vala_gir_parser_metadata_parser_construct (VALA_GIR_PARSER_TYPE_METADATA_PARSER);
}

static ValaSourceReference*
vala_gir_parser_metadata_parser_get_current_src (ValaGirParserMetadataParser* self)
{
	ValaSourceReference* result = NULL;
	ValaScanner* _tmp0_;
	ValaSourceFile* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaSourceReference* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = vala_scanner_get_source_file (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->begin;
	_tmp4_ = self->priv->end;
	_tmp5_ = vala_source_reference_new (_tmp2_, &_tmp3_, &_tmp4_);
	result = _tmp5_;
	return result;
}

static ValaSourceReference*
vala_gir_parser_metadata_parser_get_src (ValaGirParserMetadataParser* self,
                                         ValaSourceLocation* begin,
                                         ValaSourceLocation* end)
{
	ValaSourceReference* result = NULL;
	ValaSourceLocation e = {0};
	ValaSourceLocation _tmp0_;
	ValaScanner* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceFile* _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	_tmp0_ = self->priv->end;
	e = _tmp0_;
	if (end != NULL) {
		e = *end;
	}
	_tmp1_ = self->priv->scanner;
	_tmp2_ = vala_scanner_get_source_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = *begin;
	_tmp5_ = e;
	_tmp6_ = vala_source_reference_new (_tmp3_, &_tmp4_, &_tmp5_);
	result = _tmp6_;
	return result;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_parser_parse_metadata (ValaGirParserMetadataParser* self,
                                                ValaSourceFile* metadata_file)
{
	ValaGirParserMetadata* result = NULL;
	ValaScanner* _tmp0_;
	ValaGirParserMetadata* _tmp5_;
	ValaGirParserMetadata* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (metadata_file != NULL, NULL);
	_tmp0_ = vala_scanner_new (metadata_file);
	_vala_scanner_unref0 (self->priv->scanner);
	self->priv->scanner = _tmp0_;
	vala_gir_parser_metadata_parser_next (self);
	while (TRUE) {
		ValaTokenType _tmp1_;
		_tmp1_ = self->priv->current;
		if (!(_tmp1_ != VALA_TOKEN_TYPE_EOF)) {
			break;
		}
		if (!vala_gir_parser_metadata_parser_parse_rule (self)) {
			ValaGirParserMetadata* _tmp2_;
			ValaGirParserMetadata* _tmp3_;
			ValaGirParserMetadata* _tmp4_;
			_tmp2_ = vala_gir_parser_metadata_get_empty ();
			_tmp3_ = _tmp2_;
			_tmp4_ = _vala_gir_parser_metadata_ref0 (_tmp3_);
			result = _tmp4_;
			return result;
		}
	}
	_tmp5_ = self->priv->tree;
	_tmp6_ = _vala_gir_parser_metadata_ref0 (_tmp5_);
	result = _tmp6_;
	return result;
}

static ValaTokenType
vala_gir_parser_metadata_parser_next (ValaGirParserMetadataParser* self)
{
	ValaTokenType result = 0;
	ValaSourceLocation _tmp0_;
	ValaScanner* _tmp1_;
	ValaSourceLocation _tmp2_ = {0};
	ValaSourceLocation _tmp3_ = {0};
	ValaTokenType _tmp4_;
	ValaTokenType _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->end;
	self->priv->old_end = _tmp0_;
	_tmp1_ = self->priv->scanner;
	_tmp4_ = vala_scanner_read_token (_tmp1_, &_tmp2_, &_tmp3_);
	self->priv->begin = _tmp2_;
	self->priv->end = _tmp3_;
	self->priv->current = _tmp4_;
	_tmp5_ = self->priv->current;
	result = _tmp5_;
	return result;
}

static gboolean
vala_gir_parser_metadata_parser_has_space (ValaGirParserMetadataParser* self)
{
	gboolean result = FALSE;
	ValaSourceLocation _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->old_end;
	_tmp1_ = _tmp0_.pos;
	_tmp2_ = self->priv->begin;
	_tmp3_ = _tmp2_.pos;
	result = _tmp1_ != _tmp3_;
	return result;
}

static gboolean
vala_gir_parser_metadata_parser_has_newline (ValaGirParserMetadataParser* self)
{
	gboolean result = FALSE;
	ValaSourceLocation _tmp0_;
	ValaSourceLocation _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->old_end;
	_tmp1_ = self->priv->begin;
	result = _tmp0_.line != _tmp1_.line;
	return result;
}

static gchar*
vala_gir_parser_metadata_parser_get_string (ValaGirParserMetadataParser* self,
                                            ValaSourceLocation* begin,
                                            ValaSourceLocation* end)
{
	gchar* result = NULL;
	ValaSourceLocation b = {0};
	ValaSourceLocation _tmp0_;
	ValaSourceLocation e = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceLocation _tmp2_;
	gchar* _tmp3_;
	ValaSourceLocation _tmp4_;
	gchar* _tmp5_;
	ValaSourceLocation _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	b = _tmp0_;
	_tmp1_ = self->priv->end;
	e = _tmp1_;
	if (begin != NULL) {
		b = *begin;
	}
	if (end != NULL) {
		e = *end;
	}
	_tmp2_ = b;
	_tmp3_ = _tmp2_.pos;
	_tmp4_ = e;
	_tmp5_ = _tmp4_.pos;
	_tmp6_ = b;
	_tmp7_ = _tmp6_.pos;
	_tmp8_ = string_substring ((const gchar*) _tmp3_, (glong) 0, (glong) ((gint) (_tmp5_ - _tmp7_)));
	result = _tmp8_;
	return result;
}

static gchar*
vala_gir_parser_metadata_parser_parse_identifier (ValaGirParserMetadataParser* self,
                                                  gboolean is_glob)
{
	gchar* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaTokenType _tmp2_;
	ValaSourceLocation _tmp15_;
	ValaSourceLocation _tmp16_;
	gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	begin = _tmp0_;
	_tmp2_ = self->priv->current;
	if (_tmp2_ == VALA_TOKEN_TYPE_DOT) {
		_tmp1_ = TRUE;
	} else {
		ValaTokenType _tmp3_;
		_tmp3_ = self->priv->current;
		_tmp1_ = _tmp3_ == VALA_TOKEN_TYPE_HASH;
	}
	if (_tmp1_) {
		if (is_glob) {
			ValaSourceLocation _tmp4_;
			ValaSourceReference* _tmp5_;
			ValaSourceReference* _tmp6_;
			_tmp4_ = begin;
			_tmp5_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp4_, NULL);
			_tmp6_ = _tmp5_;
			vala_report_error (_tmp6_, "expected glob-style pattern");
			_vala_source_reference_unref0 (_tmp6_);
		} else {
			ValaSourceLocation _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			_tmp7_ = begin;
			_tmp8_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp7_, NULL);
			_tmp9_ = _tmp8_;
			vala_report_error (_tmp9_, "expected identifier");
			_vala_source_reference_unref0 (_tmp9_);
		}
		result = NULL;
		return result;
	}
	if (is_glob) {
		while (TRUE) {
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			ValaTokenType _tmp12_;
			_tmp12_ = self->priv->current;
			if (_tmp12_ != VALA_TOKEN_TYPE_EOF) {
				ValaTokenType _tmp13_;
				_tmp13_ = self->priv->current;
				_tmp11_ = _tmp13_ != VALA_TOKEN_TYPE_DOT;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				ValaTokenType _tmp14_;
				_tmp14_ = self->priv->current;
				_tmp10_ = _tmp14_ != VALA_TOKEN_TYPE_HASH;
			} else {
				_tmp10_ = FALSE;
			}
			if (!_tmp10_) {
				break;
			}
			vala_gir_parser_metadata_parser_next (self);
			if (vala_gir_parser_metadata_parser_has_space (self)) {
				break;
			}
		}
	} else {
		vala_gir_parser_metadata_parser_next (self);
	}
	_tmp15_ = begin;
	_tmp16_ = self->priv->old_end;
	_tmp17_ = vala_gir_parser_metadata_parser_get_string (self, &_tmp15_, &_tmp16_);
	result = _tmp17_;
	return result;
}

static gchar*
vala_gir_parser_metadata_parser_parse_selector (ValaGirParserMetadataParser* self)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaTokenType _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->current;
	if (_tmp1_ != VALA_TOKEN_TYPE_HASH) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_gir_parser_metadata_parser_has_space (self);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	vala_gir_parser_metadata_parser_next (self);
	_tmp2_ = vala_gir_parser_metadata_parser_parse_identifier (self, FALSE);
	result = _tmp2_;
	return result;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_parser_parse_pattern (ValaGirParserMetadataParser* self)
{
	ValaGirParserMetadata* result = NULL;
	ValaGirParserMetadata* metadata = NULL;
	gboolean is_relative = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaTokenType _tmp1_;
	ValaGirParserMetadata* _tmp12_;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp15_;
	gchar* pattern = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ValaSourceLocation _tmp21_;
	ValaSourceReference* _tmp22_;
	ValaSourceReference* _tmp23_;
	ValaGirParserMetadata* _tmp24_;
	ValaGirParserMetadata* _tmp25_;
	ValaGirParserMetadata* _tmp26_;
	g_return_val_if_fail (self != NULL, NULL);
	is_relative = FALSE;
	_tmp1_ = self->priv->current;
	if (_tmp1_ == VALA_TOKEN_TYPE_IDENTIFIER) {
		_tmp0_ = TRUE;
	} else {
		ValaTokenType _tmp2_;
		_tmp2_ = self->priv->current;
		_tmp0_ = _tmp2_ == VALA_TOKEN_TYPE_STAR;
	}
	if (_tmp0_) {
		ValaGirParserMetadata* _tmp3_;
		ValaGirParserMetadata* _tmp4_;
		_tmp3_ = self->priv->tree;
		_tmp4_ = _vala_gir_parser_metadata_ref0 (_tmp3_);
		_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
		self->priv->parent_metadata = _tmp4_;
	} else {
		ValaTokenType _tmp5_;
		_tmp5_ = self->priv->current;
		if (_tmp5_ != VALA_TOKEN_TYPE_DOT) {
			ValaSourceReference* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaTokenType _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp6_ = vala_gir_parser_metadata_parser_get_current_src (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = self->priv->current;
			_tmp9_ = vala_token_type_to_string (_tmp8_);
			_tmp10_ = g_strdup_printf ("expected pattern or `.', got %s", _tmp9_);
			_tmp11_ = _tmp10_;
			vala_report_error (_tmp7_, _tmp11_);
			_g_free0 (_tmp11_);
			_vala_source_reference_unref0 (_tmp7_);
			result = NULL;
			_vala_gir_parser_metadata_unref0 (metadata);
			return result;
		}
		vala_gir_parser_metadata_parser_next (self);
		is_relative = TRUE;
	}
	_tmp12_ = self->priv->parent_metadata;
	if (_tmp12_ == NULL) {
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		_tmp13_ = vala_gir_parser_metadata_parser_get_current_src (self);
		_tmp14_ = _tmp13_;
		vala_report_error (_tmp14_, "cannot determinate parent metadata");
		_vala_source_reference_unref0 (_tmp14_);
		result = NULL;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp15_ = self->priv->begin;
	begin = _tmp15_;
	_tmp16_ = vala_gir_parser_metadata_parser_parse_identifier (self, TRUE);
	pattern = _tmp16_;
	_tmp17_ = pattern;
	if (_tmp17_ == NULL) {
		result = NULL;
		_g_free0 (pattern);
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp18_ = pattern;
	_tmp19_ = vala_gir_parser_metadata_parser_parse_selector (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = begin;
	_tmp22_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_gir_parser_metadata_new (_tmp18_, _tmp20_, _tmp23_);
	_vala_gir_parser_metadata_unref0 (metadata);
	metadata = _tmp24_;
	_vala_source_reference_unref0 (_tmp23_);
	_g_free0 (_tmp20_);
	_tmp25_ = self->priv->parent_metadata;
	_tmp26_ = metadata;
	vala_gir_parser_metadata_add_child (_tmp25_, _tmp26_);
	while (TRUE) {
		gboolean _tmp27_ = FALSE;
		ValaTokenType _tmp28_;
		ValaTokenType _tmp29_;
		ValaSourceLocation _tmp36_;
		gchar* _tmp37_;
		const gchar* _tmp38_;
		ValaGirParserMetadata* child = NULL;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		ValaSourceLocation _tmp42_;
		ValaSourceLocation _tmp43_;
		ValaSourceReference* _tmp44_;
		ValaSourceReference* _tmp45_;
		ValaGirParserMetadata* _tmp46_;
		ValaGirParserMetadata* _tmp47_;
		ValaGirParserMetadata* _tmp48_;
		ValaGirParserMetadata* _tmp49_;
		ValaGirParserMetadata* _tmp50_;
		ValaGirParserMetadata* _tmp51_;
		_tmp28_ = self->priv->current;
		if (_tmp28_ != VALA_TOKEN_TYPE_EOF) {
			_tmp27_ = !vala_gir_parser_metadata_parser_has_space (self);
		} else {
			_tmp27_ = FALSE;
		}
		if (!_tmp27_) {
			break;
		}
		_tmp29_ = self->priv->current;
		if (_tmp29_ != VALA_TOKEN_TYPE_DOT) {
			ValaSourceReference* _tmp30_;
			ValaSourceReference* _tmp31_;
			ValaTokenType _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp30_ = vala_gir_parser_metadata_parser_get_current_src (self);
			_tmp31_ = _tmp30_;
			_tmp32_ = self->priv->current;
			_tmp33_ = vala_token_type_to_string (_tmp32_);
			_tmp34_ = g_strdup_printf ("expected `.' got %s", _tmp33_);
			_tmp35_ = _tmp34_;
			vala_report_error (_tmp31_, _tmp35_);
			_g_free0 (_tmp35_);
			_vala_source_reference_unref0 (_tmp31_);
			break;
		}
		vala_gir_parser_metadata_parser_next (self);
		_tmp36_ = self->priv->begin;
		begin = _tmp36_;
		_tmp37_ = vala_gir_parser_metadata_parser_parse_identifier (self, TRUE);
		_g_free0 (pattern);
		pattern = _tmp37_;
		_tmp38_ = pattern;
		if (_tmp38_ == NULL) {
			result = NULL;
			_g_free0 (pattern);
			_vala_gir_parser_metadata_unref0 (metadata);
			return result;
		}
		_tmp39_ = pattern;
		_tmp40_ = vala_gir_parser_metadata_parser_parse_selector (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = begin;
		_tmp43_ = self->priv->old_end;
		_tmp44_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp42_, &_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_gir_parser_metadata_new (_tmp39_, _tmp41_, _tmp45_);
		_tmp47_ = _tmp46_;
		_vala_source_reference_unref0 (_tmp45_);
		_g_free0 (_tmp41_);
		child = _tmp47_;
		_tmp48_ = metadata;
		_tmp49_ = child;
		vala_gir_parser_metadata_add_child (_tmp48_, _tmp49_);
		_tmp50_ = child;
		_tmp51_ = _vala_gir_parser_metadata_ref0 (_tmp50_);
		_vala_gir_parser_metadata_unref0 (metadata);
		metadata = _tmp51_;
		_vala_gir_parser_metadata_unref0 (child);
	}
	if (!is_relative) {
		ValaGirParserMetadata* _tmp52_;
		ValaGirParserMetadata* _tmp53_;
		_tmp52_ = metadata;
		_tmp53_ = _vala_gir_parser_metadata_ref0 (_tmp52_);
		_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
		self->priv->parent_metadata = _tmp53_;
	}
	result = metadata;
	_g_free0 (pattern);
	return result;
}

static ValaExpression*
vala_gir_parser_metadata_parser_parse_expression (ValaGirParserMetadataParser* self)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_;
	ValaSourceReference* src = NULL;
	ValaSourceReference* _tmp1_;
	ValaExpression* expr = NULL;
	ValaTokenType _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	begin = _tmp0_;
	_tmp1_ = vala_gir_parser_metadata_parser_get_current_src (self);
	src = _tmp1_;
	expr = NULL;
	_tmp2_ = self->priv->current;
	switch (_tmp2_) {
		case VALA_TOKEN_TYPE_NULL:
		{
			ValaSourceReference* _tmp3_;
			ValaNullLiteral* _tmp4_;
			_tmp3_ = src;
			_tmp4_ = vala_null_literal_new (_tmp3_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp4_;
			break;
		}
		case VALA_TOKEN_TYPE_TRUE:
		{
			ValaSourceReference* _tmp5_;
			ValaBooleanLiteral* _tmp6_;
			_tmp5_ = src;
			_tmp6_ = vala_boolean_literal_new (TRUE, _tmp5_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp6_;
			break;
		}
		case VALA_TOKEN_TYPE_FALSE:
		{
			ValaSourceReference* _tmp7_;
			ValaBooleanLiteral* _tmp8_;
			_tmp7_ = src;
			_tmp8_ = vala_boolean_literal_new (FALSE, _tmp7_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp8_;
			break;
		}
		case VALA_TOKEN_TYPE_MINUS:
		{
			ValaExpression* inner = NULL;
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			vala_gir_parser_metadata_parser_next (self);
			_tmp9_ = vala_gir_parser_metadata_parser_parse_expression (self);
			inner = _tmp9_;
			_tmp10_ = inner;
			if (_tmp10_ == NULL) {
				ValaSourceReference* _tmp11_;
				ValaTokenType _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp11_ = src;
				_tmp12_ = self->priv->current;
				_tmp13_ = vala_token_type_to_string (_tmp12_);
				_tmp14_ = g_strdup_printf ("expected expression after `-', got %s", _tmp13_);
				_tmp15_ = _tmp14_;
				vala_report_error (_tmp11_, _tmp15_);
				_g_free0 (_tmp15_);
			} else {
				ValaExpression* _tmp16_;
				ValaSourceLocation _tmp17_;
				ValaSourceReference* _tmp18_;
				ValaSourceReference* _tmp19_;
				ValaUnaryExpression* _tmp20_;
				_tmp16_ = inner;
				_tmp17_ = begin;
				_tmp18_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp17_, NULL);
				_tmp19_ = _tmp18_;
				_tmp20_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_MINUS, _tmp16_, _tmp19_);
				_vala_code_node_unref0 (expr);
				expr = (ValaExpression*) _tmp20_;
				_vala_source_reference_unref0 (_tmp19_);
			}
			result = expr;
			_vala_code_node_unref0 (inner);
			_vala_source_reference_unref0 (src);
			return result;
		}
		case VALA_TOKEN_TYPE_INTEGER_LITERAL:
		{
			gchar* _tmp21_;
			gchar* _tmp22_;
			ValaSourceReference* _tmp23_;
			ValaIntegerLiteral* _tmp24_;
			_tmp21_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = src;
			_tmp24_ = vala_integer_literal_new (_tmp22_, _tmp23_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp24_;
			_g_free0 (_tmp22_);
			break;
		}
		case VALA_TOKEN_TYPE_REAL_LITERAL:
		{
			gchar* _tmp25_;
			gchar* _tmp26_;
			ValaSourceReference* _tmp27_;
			ValaRealLiteral* _tmp28_;
			_tmp25_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = src;
			_tmp28_ = vala_real_literal_new (_tmp26_, _tmp27_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp28_;
			_g_free0 (_tmp26_);
			break;
		}
		case VALA_TOKEN_TYPE_STRING_LITERAL:
		{
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaSourceReference* _tmp31_;
			ValaStringLiteral* _tmp32_;
			_tmp29_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp30_ = _tmp29_;
			_tmp31_ = src;
			_tmp32_ = vala_string_literal_new (_tmp30_, _tmp31_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp32_;
			_g_free0 (_tmp30_);
			break;
		}
		case VALA_TOKEN_TYPE_IDENTIFIER:
		{
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaSourceReference* _tmp35_;
			ValaMemberAccess* _tmp36_;
			_tmp33_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp34_ = _tmp33_;
			_tmp35_ = src;
			_tmp36_ = vala_member_access_new (NULL, _tmp34_, _tmp35_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp36_;
			_g_free0 (_tmp34_);
			while (TRUE) {
				ValaExpression* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				ValaSourceReference* _tmp46_;
				ValaSourceReference* _tmp47_;
				ValaMemberAccess* _tmp48_;
				if (!(vala_gir_parser_metadata_parser_next (self) == VALA_TOKEN_TYPE_DOT)) {
					break;
				}
				if (vala_gir_parser_metadata_parser_next (self) != VALA_TOKEN_TYPE_IDENTIFIER) {
					ValaSourceReference* _tmp37_;
					ValaSourceReference* _tmp38_;
					ValaTokenType _tmp39_;
					const gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp37_ = vala_gir_parser_metadata_parser_get_current_src (self);
					_tmp38_ = _tmp37_;
					_tmp39_ = self->priv->current;
					_tmp40_ = vala_token_type_to_string (_tmp39_);
					_tmp41_ = g_strdup_printf ("expected identifier got %s", _tmp40_);
					_tmp42_ = _tmp41_;
					vala_report_error (_tmp38_, _tmp42_);
					_g_free0 (_tmp42_);
					_vala_source_reference_unref0 (_tmp38_);
					break;
				}
				_tmp43_ = expr;
				_tmp44_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
				_tmp45_ = _tmp44_;
				_tmp46_ = vala_gir_parser_metadata_parser_get_current_src (self);
				_tmp47_ = _tmp46_;
				_tmp48_ = vala_member_access_new (_tmp43_, _tmp45_, _tmp47_);
				_vala_code_node_unref0 (expr);
				expr = (ValaExpression*) _tmp48_;
				_vala_source_reference_unref0 (_tmp47_);
				_g_free0 (_tmp45_);
			}
			result = expr;
			_vala_source_reference_unref0 (src);
			return result;
		}
		case VALA_TOKEN_TYPE_OPEN_PARENS:
		{
			ValaSourceReference* _tmp55_;
			ValaTuple* _tmp56_;
			if (vala_gir_parser_metadata_parser_next (self) != VALA_TOKEN_TYPE_CLOSE_PARENS) {
				ValaSourceReference* _tmp49_;
				ValaSourceReference* _tmp50_;
				ValaTokenType _tmp51_;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp49_ = vala_gir_parser_metadata_parser_get_current_src (self);
				_tmp50_ = _tmp49_;
				_tmp51_ = self->priv->current;
				_tmp52_ = vala_token_type_to_string (_tmp51_);
				_tmp53_ = g_strdup_printf ("expected `)', got %s", _tmp52_);
				_tmp54_ = _tmp53_;
				vala_report_error (_tmp50_, _tmp54_);
				_g_free0 (_tmp54_);
				_vala_source_reference_unref0 (_tmp50_);
				break;
			}
			_tmp55_ = src;
			_tmp56_ = vala_tuple_new (_tmp55_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp56_;
			break;
		}
		default:
		{
			ValaSourceReference* _tmp57_;
			ValaTokenType _tmp58_;
			const gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			_tmp57_ = src;
			_tmp58_ = self->priv->current;
			_tmp59_ = vala_token_type_to_string (_tmp58_);
			_tmp60_ = g_strdup_printf ("expected literal or symbol got %s", _tmp59_);
			_tmp61_ = _tmp60_;
			vala_report_error (_tmp57_, _tmp61_);
			_g_free0 (_tmp61_);
			break;
		}
	}
	vala_gir_parser_metadata_parser_next (self);
	result = expr;
	_vala_source_reference_unref0 (src);
	return result;
}

static gboolean
vala_gir_parser_metadata_parser_parse_args (ValaGirParserMetadataParser* self,
                                            ValaGirParserMetadata* metadata)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (metadata != NULL, FALSE);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		ValaTokenType _tmp2_;
		ValaSourceLocation begin = {0};
		ValaSourceLocation _tmp3_;
		gchar* id = NULL;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		ValaGirParserArgumentType* arg_type = NULL;
		const gchar* _tmp6_;
		ValaGirParserArgumentType* _tmp7_;
		ValaGirParserArgumentType* _tmp8_;
		ValaTokenType _tmp16_;
		ValaExpression* expr = NULL;
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaGirParserArgumentType* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSourceLocation _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaSourceReference* _tmp34_;
		ValaGirParserArgument* _tmp35_;
		ValaGirParserArgument* _tmp36_;
		_tmp2_ = self->priv->current;
		if (_tmp2_ != VALA_TOKEN_TYPE_EOF) {
			_tmp1_ = vala_gir_parser_metadata_parser_has_space (self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = !vala_gir_parser_metadata_parser_has_newline (self);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp3_ = self->priv->begin;
		begin = _tmp3_;
		_tmp4_ = vala_gir_parser_metadata_parser_parse_identifier (self, FALSE);
		id = _tmp4_;
		_tmp5_ = id;
		if (_tmp5_ == NULL) {
			result = FALSE;
			_g_free0 (id);
			return result;
		}
		_tmp6_ = id;
		_tmp7_ = vala_gir_parser_argument_type_from_string (_tmp6_);
		arg_type = _tmp7_;
		_tmp8_ = arg_type;
		if (_tmp8_ == NULL) {
			ValaSourceLocation _tmp9_;
			ValaSourceLocation _tmp10_;
			ValaSourceReference* _tmp11_;
			ValaSourceReference* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp9_ = begin;
			_tmp10_ = self->priv->old_end;
			_tmp11_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp9_, &_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = id;
			_tmp14_ = g_strdup_printf ("unknown argument `%s'", _tmp13_);
			_tmp15_ = _tmp14_;
			vala_report_warning (_tmp12_, _tmp15_);
			_g_free0 (_tmp15_);
			_vala_source_reference_unref0 (_tmp12_);
			_g_free0 (arg_type);
			_g_free0 (id);
			continue;
		}
		_tmp16_ = self->priv->current;
		if (_tmp16_ != VALA_TOKEN_TYPE_ASSIGN) {
			ValaGirParserArgumentType* _tmp17_;
			ValaSourceLocation _tmp18_;
			ValaSourceReference* _tmp19_;
			ValaSourceReference* _tmp20_;
			ValaBooleanLiteral* _tmp21_;
			ValaBooleanLiteral* _tmp22_;
			ValaSourceLocation _tmp23_;
			ValaSourceReference* _tmp24_;
			ValaSourceReference* _tmp25_;
			ValaGirParserArgument* _tmp26_;
			ValaGirParserArgument* _tmp27_;
			_tmp17_ = arg_type;
			_tmp18_ = begin;
			_tmp19_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp18_, NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_boolean_literal_new (TRUE, _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = begin;
			_tmp24_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp23_, NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_gir_parser_argument_new ((ValaExpression*) _tmp22_, _tmp25_);
			_tmp27_ = _tmp26_;
			vala_gir_parser_metadata_add_argument (metadata, *_tmp17_, _tmp27_);
			_vala_gir_parser_argument_unref0 (_tmp27_);
			_vala_source_reference_unref0 (_tmp25_);
			_vala_code_node_unref0 (_tmp22_);
			_vala_source_reference_unref0 (_tmp20_);
			_g_free0 (arg_type);
			_g_free0 (id);
			continue;
		}
		vala_gir_parser_metadata_parser_next (self);
		_tmp28_ = vala_gir_parser_metadata_parser_parse_expression (self);
		expr = _tmp28_;
		_tmp29_ = expr;
		if (_tmp29_ == NULL) {
			result = FALSE;
			_vala_code_node_unref0 (expr);
			_g_free0 (arg_type);
			_g_free0 (id);
			return result;
		}
		_tmp30_ = arg_type;
		_tmp31_ = expr;
		_tmp32_ = begin;
		_tmp33_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp32_, NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_gir_parser_argument_new (_tmp31_, _tmp34_);
		_tmp36_ = _tmp35_;
		vala_gir_parser_metadata_add_argument (metadata, *_tmp30_, _tmp36_);
		_vala_gir_parser_argument_unref0 (_tmp36_);
		_vala_source_reference_unref0 (_tmp34_);
		_vala_code_node_unref0 (expr);
		_g_free0 (arg_type);
		_g_free0 (id);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_gir_parser_metadata_parser_parse_rule (ValaGirParserMetadataParser* self)
{
	gboolean result = FALSE;
	ValaSourceLocation old_end = {0};
	ValaSourceLocation _tmp0_;
	ValaGirParserMetadata* metadata = NULL;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaTokenType _tmp4_;
	ValaGirParserMetadata* _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->end;
	old_end = _tmp0_;
	_tmp1_ = vala_gir_parser_metadata_parser_parse_pattern (self);
	metadata = _tmp1_;
	_tmp2_ = metadata;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp4_ = self->priv->current;
	if (_tmp4_ == VALA_TOKEN_TYPE_EOF) {
		_tmp3_ = TRUE;
	} else {
		ValaSourceLocation _tmp5_;
		ValaSourceLocation _tmp6_;
		_tmp5_ = old_end;
		_tmp6_ = self->priv->end;
		_tmp3_ = _tmp5_.line != _tmp6_.line;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp7_ = metadata;
	result = vala_gir_parser_metadata_parser_parse_args (self, _tmp7_);
	_vala_gir_parser_metadata_unref0 (metadata);
	return result;
}

static void
vala_gir_parser_value_metadata_parser_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_metadata_parser_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_metadata_parser_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_metadata_parser_copy_value (const GValue* src_value,
                                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_metadata_parser_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_metadata_parser_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_metadata_parser_collect_value (GValue* value,
                                                     guint n_collect_values,
                                                     GTypeCValue* collect_values,
                                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserMetadataParser * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_metadata_parser_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_metadata_parser_lcopy_value (const GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	ValaGirParserMetadataParser ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_metadata_parser_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_metadata_parser (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags)
{
	ValaGirParserParamSpecMetadataParser* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_METADATA_PARSER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_metadata_parser (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_metadata_parser (GValue* value,
                                           gpointer v_object)
{
	ValaGirParserMetadataParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_metadata_parser_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_parser_unref (old);
	}
}

static void
vala_gir_parser_value_take_metadata_parser (GValue* value,
                                            gpointer v_object)
{
	ValaGirParserMetadataParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_parser_unref (old);
	}
}

static void
vala_gir_parser_metadata_parser_class_init (ValaGirParserMetadataParserClass * klass,
                                            gpointer klass_data)
{
	vala_gir_parser_metadata_parser_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserMetadataParserClass *) klass)->finalize = vala_gir_parser_metadata_parser_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGirParserMetadataParser_private_offset);
}

static void
vala_gir_parser_metadata_parser_instance_init (ValaGirParserMetadataParser * self,
                                               gpointer klass)
{
	ValaGirParserMetadata* _tmp0_;
	self->priv = vala_gir_parser_metadata_parser_get_instance_private (self);
	_tmp0_ = vala_gir_parser_metadata_new ("", NULL, NULL);
	self->priv->tree = _tmp0_;
	self->ref_count = 1;
}

static void
vala_gir_parser_metadata_parser_finalize (ValaGirParserMetadataParser * obj)
{
	ValaGirParserMetadataParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParser);
	g_signal_handlers_destroy (self);
	_vala_gir_parser_metadata_unref0 (self->priv->tree);
	_vala_scanner_unref0 (self->priv->scanner);
	_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
}

static GType
vala_gir_parser_metadata_parser_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_parser_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_metadata_parser_init, vala_gir_parser_value_metadata_parser_free_value, vala_gir_parser_value_metadata_parser_copy_value, vala_gir_parser_value_metadata_parser_peek_pointer, "p", vala_gir_parser_value_metadata_parser_collect_value, "p", vala_gir_parser_value_metadata_parser_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadataParser), 0, (GInstanceInitFunc) vala_gir_parser_metadata_parser_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_gir_parser_metadata_parser_type_id;
		vala_gir_parser_metadata_parser_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserMetadataParser", &g_define_type_info, &g_define_type_fundamental_info, 0);
		ValaGirParserMetadataParser_private_offset = g_type_add_instance_private (vala_gir_parser_metadata_parser_type_id, sizeof (ValaGirParserMetadataParserPrivate));
		g_once_init_leave (&vala_gir_parser_metadata_parser_type_id__volatile, vala_gir_parser_metadata_parser_type_id);
	}
	return vala_gir_parser_metadata_parser_type_id__volatile;
}

static gpointer
vala_gir_parser_metadata_parser_ref (gpointer instance)
{
	ValaGirParserMetadataParser * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_metadata_parser_unref (gpointer instance)
{
	ValaGirParserMetadataParser * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_METADATA_PARSER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static ValaGirParserNode*
vala_gir_parser_node_construct (GType object_type,
                                const gchar* name)
{
	ValaGirParserNode* self = NULL;
	gchar* _tmp0_;
	self = (ValaGirParserNode*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	return self;
}

static ValaGirParserNode*
vala_gir_parser_node_new (const gchar* name)
{
	return vala_gir_parser_node_construct (VALA_GIR_PARSER_TYPE_NODE, name);
}

static void
vala_gir_parser_node_add_member (ValaGirParserNode* self,
                                 ValaGirParserNode* node)
{
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	ValaArrayList* _tmp3_;
	ValaArrayList* _tmp9_;
	ValaArrayList* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->scope;
	_tmp1_ = node->name;
	_tmp2_ = vala_map_get ((ValaMap*) _tmp0_, _tmp1_);
	nodes = (ValaArrayList*) _tmp2_;
	_tmp3_ = nodes;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		ValaHashMap* _tmp6_;
		const gchar* _tmp7_;
		ValaArrayList* _tmp8_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp4_);
		_vala_iterable_unref0 (nodes);
		nodes = _tmp5_;
		_tmp6_ = self->scope;
		_tmp7_ = node->name;
		_tmp8_ = nodes;
		vala_map_set ((ValaMap*) _tmp6_, _tmp7_, _tmp8_);
	}
	_tmp9_ = nodes;
	vala_collection_add ((ValaCollection*) _tmp9_, node);
	_tmp10_ = self->members;
	vala_collection_add ((ValaCollection*) _tmp10_, node);
	node->parent = self;
	_vala_iterable_unref0 (nodes);
}

static void
vala_gir_parser_node_remove_member (ValaGirParserNode* self,
                                    ValaGirParserNode* node)
{
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	ValaArrayList* _tmp3_;
	ValaArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ValaArrayList* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->scope;
	_tmp1_ = node->name;
	_tmp2_ = vala_map_get ((ValaMap*) _tmp0_, _tmp1_);
	nodes = (ValaArrayList*) _tmp2_;
	_tmp3_ = nodes;
	vala_collection_remove ((ValaCollection*) _tmp3_, node);
	_tmp4_ = nodes;
	_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == 0) {
		ValaHashMap* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->scope;
		_tmp8_ = node->name;
		vala_map_remove ((ValaMap*) _tmp7_, _tmp8_);
	}
	_tmp9_ = self->members;
	vala_collection_remove ((ValaCollection*) _tmp9_, node);
	node->parent = NULL;
	_vala_iterable_unref0 (nodes);
}

static ValaGirParserNode*
vala_gir_parser_node_lookup (ValaGirParserNode* self,
                             const gchar* name,
                             gboolean create_namespace,
                             ValaSourceReference* source_reference)
{
	ValaGirParserNode* result = NULL;
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserNode* node = NULL;
	ValaArrayList* _tmp2_;
	ValaGirParserNode* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->scope;
	_tmp1_ = vala_map_get ((ValaMap*) _tmp0_, name);
	nodes = (ValaArrayList*) _tmp1_;
	node = NULL;
	_tmp2_ = nodes;
	if (_tmp2_ != NULL) {
		ValaArrayList* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = nodes;
		_tmp4_ = vala_list_get ((ValaList*) _tmp3_, 0);
		_vala_gir_parser_node_unref0 (node);
		node = (ValaGirParserNode*) _tmp4_;
	}
	_tmp5_ = node;
	if (_tmp5_ == NULL) {
		ValaSymbol* sym = NULL;
		ValaSymbol* _tmp6_;
		gboolean _tmp11_ = FALSE;
		ValaSymbol* _tmp12_;
		sym = NULL;
		_tmp6_ = self->symbol;
		if (_tmp6_ != NULL) {
			ValaSymbol* _tmp7_;
			ValaScope* _tmp8_;
			ValaScope* _tmp9_;
			ValaSymbol* _tmp10_;
			_tmp7_ = self->symbol;
			_tmp8_ = vala_symbol_get_scope (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_scope_lookup (_tmp9_, name);
			_vala_code_node_unref0 (sym);
			sym = _tmp10_;
		}
		_tmp12_ = sym;
		if (_tmp12_ != NULL) {
			_tmp11_ = TRUE;
		} else {
			_tmp11_ = create_namespace;
		}
		if (_tmp11_) {
			ValaGirParserNode* _tmp13_;
			ValaGirParserNode* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaGirParserNode* _tmp17_;
			ValaGirParserNode* _tmp18_;
			ValaSymbol* _tmp19_;
			ValaGirParserNode* _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaGirParserNode* _tmp22_;
			ValaSymbol* _tmp23_;
			_tmp13_ = vala_gir_parser_node_new (name);
			_vala_gir_parser_node_unref0 (node);
			node = _tmp13_;
			_tmp14_ = node;
			_tmp15_ = sym;
			_tmp16_ = _vala_code_node_ref0 (_tmp15_);
			_vala_code_node_unref0 (_tmp14_->symbol);
			_tmp14_->symbol = _tmp16_;
			_tmp17_ = node;
			_tmp18_ = node;
			_tmp19_ = _tmp18_->symbol;
			_tmp17_->new_symbol = _tmp19_ == NULL;
			_tmp20_ = node;
			_tmp21_ = _vala_source_reference_ref0 (source_reference);
			_vala_source_reference_unref0 (_tmp20_->source_reference);
			_tmp20_->source_reference = _tmp21_;
			_tmp22_ = node;
			vala_gir_parser_node_add_member (self, _tmp22_);
			_tmp23_ = sym;
			if (_tmp23_ == NULL) {
				ValaArrayList* _tmp24_;
				ValaGirParserNode* _tmp25_;
				_tmp24_ = vala_gir_parser_node_new_namespaces;
				_tmp25_ = node;
				vala_collection_add ((ValaCollection*) _tmp24_, _tmp25_);
			}
		}
		_vala_code_node_unref0 (sym);
	}
	result = node;
	_vala_iterable_unref0 (nodes);
	return result;
}

static ValaArrayList*
vala_gir_parser_node_lookup_all (ValaGirParserNode* self,
                                 const gchar* name)
{
	ValaArrayList* result = NULL;
	ValaHashMap* _tmp0_;
	gpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->scope;
	_tmp1_ = vala_map_get ((ValaMap*) _tmp0_, name);
	result = (ValaArrayList*) _tmp1_;
	return result;
}

static ValaUnresolvedSymbol*
vala_gir_parser_node_get_unresolved_symbol (ValaGirParserNode* self)
{
	ValaUnresolvedSymbol* result = NULL;
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = _tmp0_->name;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		ValaUnresolvedSymbol* _tmp3_;
		_tmp2_ = self->name;
		_tmp3_ = vala_unresolved_symbol_new (NULL, _tmp2_, NULL);
		result = _tmp3_;
		return result;
	} else {
		ValaGirParserNode* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		const gchar* _tmp7_;
		ValaUnresolvedSymbol* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_get_unresolved_symbol (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->name;
		_tmp8_ = vala_unresolved_symbol_new (_tmp6_, _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_vala_code_node_unref0 (_tmp6_);
		result = _tmp9_;
		return result;
	}
}

static gchar*
vala_gir_parser_node_get_full_name (ValaGirParserNode* self)
{
	gchar* result = NULL;
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp3_;
	ValaGirParserNode* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	ValaGirParserNode* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->name;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->name;
	if (_tmp3_ == NULL) {
		ValaGirParserNode* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_get_full_name (_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = self->parent;
	_tmp7_ = vala_gir_parser_node_get_full_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ == NULL;
	_g_free0 (_tmp8_);
	if (_tmp9_) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = self->name;
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		return result;
	}
	_tmp12_ = self->parent;
	_tmp13_ = vala_gir_parser_node_get_full_name (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->name;
	_tmp16_ = g_strdup_printf ("%s.%s", _tmp14_, _tmp15_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp14_);
	result = _tmp17_;
	return result;
}

static gchar*
vala_gir_parser_node_get_default_gir_name (ValaGirParserNode* self)
{
	gchar* result = NULL;
	GString* default_name = NULL;
	GString* _tmp0_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	default_name = _tmp0_;
	{
		ValaGirParserNode* node = NULL;
		node = self;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				ValaGirParserNode* _tmp4_;
				ValaGirParserNode* _tmp5_;
				ValaSymbol* _tmp6_;
				GString* _tmp12_;
				ValaGirParserNode* _tmp13_;
				const gchar* _tmp14_;
				if (!_tmp1_) {
					ValaGirParserNode* _tmp2_;
					ValaGirParserNode* _tmp3_;
					_tmp2_ = node;
					_tmp3_ = _tmp2_->parent;
					node = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = node;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = node;
				_tmp6_ = _tmp5_->symbol;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_NAMESPACE)) {
					ValaGirParserNode* _tmp7_;
					ValaSymbol* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					gboolean _tmp11_;
					_tmp7_ = node;
					_tmp8_ = _tmp7_->symbol;
					_tmp9_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp8_, "CCode", "gir_namespace", NULL);
					_tmp10_ = _tmp9_;
					_tmp11_ = _tmp10_ != NULL;
					_g_free0 (_tmp10_);
					if (_tmp11_) {
						break;
					}
				}
				_tmp12_ = default_name;
				_tmp13_ = node;
				_tmp14_ = _tmp13_->name;
				g_string_prepend (_tmp12_, _tmp14_);
			}
		}
	}
	_tmp15_ = default_name;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (default_name);
	return result;
}

static gchar*
vala_gir_parser_node_get_gir_name (ValaGirParserNode* self)
{
	gchar* result = NULL;
	gchar* gir_name = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->girdata;
	_tmp1_ = vala_map_get (_tmp0_, "name");
	gir_name = (gchar*) _tmp1_;
	_tmp2_ = gir_name;
	if (_tmp2_ == NULL) {
		ValaMap* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = self->girdata;
		_tmp4_ = vala_map_get (_tmp3_, "glib:name");
		_g_free0 (gir_name);
		gir_name = (gchar*) _tmp4_;
	}
	result = gir_name;
	return result;
}

static gchar*
vala_gir_parser_node_get_lower_case_cprefix (ValaGirParserNode* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* prefix = NULL;
	ValaSymbol* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	const gchar* _tmp46_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->symbol;
	_tmp3_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp2_, "CCode", "lower_case_cprefix", NULL);
	prefix = _tmp3_;
	_tmp5_ = prefix;
	if (_tmp5_ == NULL) {
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		_tmp7_ = self->symbol;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
			_tmp6_ = TRUE;
		} else {
			ValaSymbol* _tmp8_;
			_tmp8_ = self->symbol;
			_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_STRUCT);
		}
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaGirParserMetadata* _tmp9_;
		_tmp9_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp9_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX)) {
			ValaGirParserMetadata* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = self->metadata;
			_tmp11_ = vala_gir_parser_metadata_get_string (_tmp10_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX);
			_g_free0 (prefix);
			prefix = _tmp11_;
		} else {
			ValaGirParserMetadata* _tmp12_;
			_tmp12_ = self->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
				ValaGirParserMetadata* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = self->metadata;
				_tmp14_ = vala_gir_parser_metadata_get_string (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
				_g_free0 (prefix);
				prefix = _tmp14_;
			} else {
				ValaSymbol* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = self->symbol;
				_tmp16_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp15_, "CCode", "cprefix", NULL);
				_g_free0 (prefix);
				prefix = _tmp16_;
			}
		}
	}
	_tmp19_ = prefix;
	if (_tmp19_ == NULL) {
		ValaMap* _tmp20_;
		_tmp20_ = self->girdata;
		_tmp18_ = _tmp20_ != NULL;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gboolean _tmp21_ = FALSE;
		ValaMap* _tmp22_;
		_tmp22_ = self->girdata;
		if (vala_map_contains (_tmp22_, "c:symbol-prefix")) {
			_tmp21_ = TRUE;
		} else {
			ValaMap* _tmp23_;
			_tmp23_ = self->girdata;
			_tmp21_ = vala_map_contains (_tmp23_, "c:symbol-prefixes");
		}
		_tmp17_ = _tmp21_;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		ValaGirParserNode* cur = NULL;
		cur = self;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				ValaGirParserNode* _tmp26_;
				ValaMap* _tmp27_;
				ValaGirParserNode* _tmp44_;
				ValaGirParserNode* _tmp45_;
				if (!_tmp24_) {
					ValaGirParserNode* _tmp25_;
					_tmp25_ = cur;
					if (!(_tmp25_ != NULL)) {
						break;
					}
				}
				_tmp24_ = FALSE;
				_tmp26_ = cur;
				_tmp27_ = _tmp26_->girdata;
				if (_tmp27_ != NULL) {
					gchar* p = NULL;
					ValaGirParserNode* _tmp28_;
					ValaMap* _tmp29_;
					gpointer _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp39_;
					_tmp28_ = cur;
					_tmp29_ = _tmp28_->girdata;
					_tmp30_ = vala_map_get (_tmp29_, "c:symbol-prefix");
					p = (gchar*) _tmp30_;
					_tmp31_ = p;
					if (_tmp31_ == NULL) {
						ValaGirParserNode* _tmp32_;
						ValaMap* _tmp33_;
						gpointer _tmp34_;
						const gchar* _tmp35_;
						_tmp32_ = cur;
						_tmp33_ = _tmp32_->girdata;
						_tmp34_ = vala_map_get (_tmp33_, "c:symbol-prefixes");
						_g_free0 (p);
						p = (gchar*) _tmp34_;
						_tmp35_ = p;
						if (_tmp35_ != NULL) {
							gint idx = 0;
							const gchar* _tmp36_;
							_tmp36_ = p;
							idx = string_index_of (_tmp36_, ",", 0);
							if (idx >= 0) {
								const gchar* _tmp37_;
								gchar* _tmp38_;
								_tmp37_ = p;
								_tmp38_ = string_substring (_tmp37_, (glong) 0, (glong) idx);
								_g_free0 (p);
								p = _tmp38_;
							}
						}
					}
					_tmp39_ = p;
					if (_tmp39_ != NULL) {
						const gchar* _tmp40_ = NULL;
						const gchar* _tmp41_;
						const gchar* _tmp42_;
						gchar* _tmp43_;
						_tmp41_ = prefix;
						_tmp40_ = _tmp41_;
						if (_tmp40_ == NULL) {
							_tmp40_ = "";
						}
						_tmp42_ = p;
						_tmp43_ = g_strdup_printf ("%s_%s", _tmp42_, _tmp40_);
						_g_free0 (prefix);
						prefix = _tmp43_;
					}
					_g_free0 (p);
				}
				_tmp44_ = cur;
				_tmp45_ = _tmp44_->parent;
				cur = _tmp45_;
			}
		}
	}
	_tmp46_ = prefix;
	if (_tmp46_ == NULL) {
		gchar* _tmp47_;
		_tmp47_ = vala_gir_parser_node_get_default_lower_case_cprefix (self);
		_g_free0 (prefix);
		prefix = _tmp47_;
	}
	result = prefix;
	return result;
}

static gchar*
vala_gir_parser_node_get_default_lower_case_cprefix (ValaGirParserNode* self)
{
	gchar* result = NULL;
	ValaGirParserNode* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gir_parser_node_get_lower_case_csuffix (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s%s_", _tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}

static gchar*
vala_gir_parser_node_get_lower_case_csuffix (ValaGirParserNode* self)
{
	gchar* result = NULL;
	gchar* suffix = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	const gchar* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->symbol;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "CCode", "lower_case_csuffix", NULL);
	suffix = _tmp1_;
	_tmp2_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX)) {
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX);
		_g_free0 (suffix);
		suffix = _tmp4_;
	}
	_tmp8_ = suffix;
	if (_tmp8_ == NULL) {
		ValaMap* _tmp9_;
		_tmp9_ = self->girdata;
		_tmp7_ = _tmp9_ != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaMap* _tmp10_;
		gpointer _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = self->girdata;
		_tmp11_ = vala_map_get (_tmp10_, "c:symbol-prefix");
		_tmp12_ = (gchar*) _tmp11_;
		_tmp6_ = _tmp12_ != NULL;
		_g_free0 (_tmp12_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaGirParserMetadata* _tmp13_;
		_tmp13_ = self->metadata;
		_tmp5_ = !vala_gir_parser_metadata_has_argument (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaMap* _tmp14_;
		gpointer _tmp15_;
		_tmp14_ = self->girdata;
		_tmp15_ = vala_map_get (_tmp14_, "c:symbol-prefix");
		_g_free0 (suffix);
		suffix = (gchar*) _tmp15_;
	}
	_tmp16_ = suffix;
	if (_tmp16_ == NULL) {
		gchar* _tmp17_;
		_tmp17_ = vala_gir_parser_node_get_default_lower_case_csuffix (self);
		_g_free0 (suffix);
		suffix = _tmp17_;
	}
	result = suffix;
	return result;
}

static gchar*
vala_gir_parser_node_get_default_lower_case_csuffix (ValaGirParserNode* self)
{
	gchar* result = NULL;
	gchar* csuffix = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	_tmp1_ = vala_symbol_camel_case_to_lower_case (_tmp0_);
	csuffix = _tmp1_;
	_tmp2_ = csuffix;
	if (g_str_has_prefix (_tmp2_, "type_")) {
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = csuffix;
		_tmp4_ = strlen ("type_");
		_tmp5_ = _tmp4_;
		_tmp6_ = string_substring (_tmp3_, (glong) _tmp5_, (glong) -1);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat ("type", _tmp7_, NULL);
		_g_free0 (csuffix);
		csuffix = _tmp8_;
		_g_free0 (_tmp7_);
	} else {
		const gchar* _tmp9_;
		_tmp9_ = csuffix;
		if (g_str_has_prefix (_tmp9_, "is_")) {
			const gchar* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp10_ = csuffix;
			_tmp11_ = strlen ("is_");
			_tmp12_ = _tmp11_;
			_tmp13_ = string_substring (_tmp10_, (glong) _tmp12_, (glong) -1);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat ("is", _tmp14_, NULL);
			_g_free0 (csuffix);
			csuffix = _tmp15_;
			_g_free0 (_tmp14_);
		}
	}
	_tmp16_ = csuffix;
	if (g_str_has_suffix (_tmp16_, "_class")) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp17_ = csuffix;
		_tmp18_ = csuffix;
		_tmp19_ = strlen (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = strlen ("_class");
		_tmp22_ = _tmp21_;
		_tmp23_ = string_substring (_tmp17_, (glong) 0, (glong) (_tmp20_ - _tmp22_));
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp24_, "class", NULL);
		_g_free0 (csuffix);
		csuffix = _tmp25_;
		_g_free0 (_tmp24_);
	}
	result = csuffix;
	return result;
}

static gchar*
vala_gir_parser_node_get_cprefix (ValaGirParserNode* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* prefix = NULL;
	ValaGirParserMetadata* _tmp2_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	const gchar* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
		_g_free0 (prefix);
		prefix = _tmp4_;
	} else {
		ValaSymbol* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->symbol;
		_tmp6_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp5_, "CCode", "cprefix", NULL);
		_g_free0 (prefix);
		prefix = _tmp6_;
	}
	_tmp9_ = prefix;
	if (_tmp9_ == NULL) {
		ValaMap* _tmp10_;
		_tmp10_ = self->girdata;
		_tmp8_ = _tmp10_ != NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaMap* _tmp11_;
		gpointer _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = self->girdata;
		_tmp12_ = vala_map_get (_tmp11_, "c:identifier-prefixes");
		_tmp13_ = (gchar*) _tmp12_;
		_tmp7_ = _tmp13_ != NULL;
		_g_free0 (_tmp13_);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaMap* _tmp14_;
		gpointer _tmp15_;
		gint idx = 0;
		const gchar* _tmp16_;
		_tmp14_ = self->girdata;
		_tmp15_ = vala_map_get (_tmp14_, "c:identifier-prefixes");
		_g_free0 (prefix);
		prefix = (gchar*) _tmp15_;
		_tmp16_ = prefix;
		idx = string_index_of (_tmp16_, ",", 0);
		if (idx != -1) {
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp17_ = prefix;
			_tmp18_ = string_substring (_tmp17_, (glong) 0, (glong) idx);
			_g_free0 (prefix);
			prefix = _tmp18_;
		}
	}
	_tmp19_ = prefix;
	if (_tmp19_ == NULL) {
		gboolean _tmp20_ = FALSE;
		ValaSymbol* _tmp21_;
		_tmp21_ = self->symbol;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_ENUM)) {
			_tmp20_ = TRUE;
		} else {
			ValaSymbol* _tmp22_;
			_tmp22_ = self->symbol;
			_tmp20_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, VALA_TYPE_ERROR_DOMAIN);
		}
		if (_tmp20_) {
			ValaGirParserNode* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp23_ = self->parent;
			_tmp24_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_ascii_strup (_tmp25_, (gssize) -1);
			_tmp27_ = _tmp26_;
			_tmp28_ = self->name;
			_tmp29_ = g_strdup_printf ("%s%s", _tmp27_, _tmp28_);
			_g_free0 (prefix);
			prefix = _tmp29_;
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
		} else {
			gchar* _tmp30_;
			_tmp30_ = vala_gir_parser_node_get_cname (self);
			_g_free0 (prefix);
			prefix = _tmp30_;
		}
	}
	result = prefix;
	return result;
}

static gchar*
vala_gir_parser_node_get_cname (ValaGirParserNode* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* cname = NULL;
	ValaGirParserMetadata* _tmp2_;
	ValaMap* _tmp7_;
	const gchar* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME)) {
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME);
		_g_free0 (cname);
		cname = _tmp4_;
	} else {
		ValaSymbol* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->symbol;
		_tmp6_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp5_, "CCode", "cname", NULL);
		_g_free0 (cname);
		cname = _tmp6_;
	}
	_tmp7_ = self->girdata;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		const gchar* _tmp11_;
		_tmp8_ = cname;
		if (_tmp8_ == NULL) {
			ValaMap* _tmp9_;
			gpointer _tmp10_;
			_tmp9_ = self->girdata;
			_tmp10_ = vala_map_get (_tmp9_, "c:identifier");
			_g_free0 (cname);
			cname = (gchar*) _tmp10_;
		}
		_tmp11_ = cname;
		if (_tmp11_ == NULL) {
			ValaMap* _tmp12_;
			gpointer _tmp13_;
			_tmp12_ = self->girdata;
			_tmp13_ = vala_map_get (_tmp12_, "c:type");
			_g_free0 (cname);
			cname = (gchar*) _tmp13_;
		}
	}
	_tmp14_ = cname;
	if (_tmp14_ == NULL) {
		gchar* _tmp15_;
		_tmp15_ = vala_gir_parser_node_get_default_cname (self);
		_g_free0 (cname);
		cname = _tmp15_;
	}
	result = cname;
	return result;
}

static gchar*
vala_gir_parser_node_get_default_cname (ValaGirParserNode* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	ValaSymbol* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->symbol;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_FIELD)) {
		ValaSymbol* _tmp3_;
		ValaMemberBinding _tmp4_;
		ValaMemberBinding _tmp5_;
		_tmp3_ = self->symbol;
		_tmp4_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_FIELD, ValaField));
		_tmp5_ = _tmp4_;
		if (_tmp5_ == VALA_MEMBER_BINDING_STATIC) {
			ValaGirParserNode* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp6_ = self->parent;
			_tmp7_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->name;
			_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp8_);
			result = _tmp11_;
			return result;
		} else {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = self->name;
			_tmp13_ = g_strdup (_tmp12_);
			result = _tmp13_;
			return result;
		}
	} else {
		ValaSymbol* _tmp14_;
		_tmp14_ = self->symbol;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_METHOD)) {
			ValaGirParserNode* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp15_ = self->parent;
			_tmp16_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = self->name;
			_tmp19_ = g_strdup_printf ("%s%s", _tmp17_, _tmp18_);
			_tmp20_ = _tmp19_;
			_g_free0 (_tmp17_);
			result = _tmp20_;
			return result;
		} else {
			ValaGirParserNode* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp21_ = self->parent;
			_tmp22_ = vala_gir_parser_node_get_cprefix (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = self->name;
			_tmp25_ = g_strdup_printf ("%s%s", _tmp23_, _tmp24_);
			_tmp26_ = _tmp25_;
			_g_free0 (_tmp23_);
			result = _tmp26_;
			return result;
		}
	}
}

static gchar*
vala_gir_parser_node_get_finish_cname (ValaGirParserNode* self)
{
	gchar* result = NULL;
	gchar* finish_cname = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->symbol;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "CCode", "finish_name", NULL);
	finish_cname = _tmp1_;
	_tmp2_ = finish_cname;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp3_ = vala_gir_parser_node_get_cname (self);
		_g_free0 (finish_cname);
		finish_cname = _tmp3_;
		_tmp4_ = finish_cname;
		if (g_str_has_suffix (_tmp4_, "_async")) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gchar* _tmp11_;
			_tmp5_ = finish_cname;
			_tmp6_ = finish_cname;
			_tmp7_ = strlen (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = strlen ("_async");
			_tmp10_ = _tmp9_;
			_tmp11_ = string_substring (_tmp5_, (glong) 0, (glong) (_tmp8_ - _tmp10_));
			_g_free0 (finish_cname);
			finish_cname = _tmp11_;
		}
		_tmp12_ = finish_cname;
		_tmp13_ = g_strdup_printf ("%s_finish", _tmp12_);
		_g_free0 (finish_cname);
		finish_cname = _tmp13_;
	}
	result = finish_cname;
	return result;
}

static gchar*
vala_gir_parser_node_get_cheader_filename (ValaGirParserNode* self)
{
	gchar* result = NULL;
	ValaGirParserMetadata* _tmp0_;
	gchar* cheader_filename = NULL;
	ValaSymbol* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	ValaGirParserNode* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp0_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME)) {
		ValaGirParserMetadata* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->metadata;
		_tmp2_ = vala_gir_parser_metadata_get_string (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->symbol;
	_tmp4_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp3_, "CCode", "cheader_filename", NULL);
	cheader_filename = _tmp4_;
	_tmp5_ = cheader_filename;
	if (_tmp5_ != NULL) {
		result = cheader_filename;
		return result;
	}
	_tmp6_ = self->parent;
	_tmp7_ = _tmp6_->name;
	if (_tmp7_ != NULL) {
		ValaGirParserNode* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->parent;
		_tmp9_ = vala_gir_parser_node_get_cheader_filename (_tmp8_);
		result = _tmp9_;
		_g_free0 (cheader_filename);
		return result;
	} else {
		ValaSymbol* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		_tmp10_ = self->symbol;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != NULL) {
			ValaSymbol* _tmp13_;
			ValaSourceReference* _tmp14_;
			ValaSourceReference* _tmp15_;
			ValaSourceFile* _tmp16_;
			ValaSourceFile* _tmp17_;
			gchar* _tmp18_;
			_tmp13_ = self->symbol;
			_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_source_reference_get_file (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_source_file_get_cinclude_filename (_tmp17_);
			result = _tmp18_;
			_g_free0 (cheader_filename);
			return result;
		}
	}
	_tmp19_ = g_strdup ("");
	result = _tmp19_;
	_g_free0 (cheader_filename);
	return result;
}

static gboolean
int64_try_parse (const gchar* str,
                 gint64* _result_,
                 const gchar* * unparsed)
{
	gint64 _vala__result_ = 0LL;
	const gchar* _vala_unparsed = NULL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, (guint) 0);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = TRUE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala__result_;
	}
	if (unparsed) {
		*unparsed = _vala_unparsed;
	}
}

static guint64
vala_gir_parser_node_parse_version_string (const gchar* version)
{
	guint64 result = 0ULL;
	gint64 res = 0LL;
	gint shift = 0;
	gchar** tokens = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (version != NULL, 0ULL);
	res = (gint64) 0;
	shift = 16;
	_tmp1_ = _tmp0_ = g_strsplit (version, ".", 3);
	tokens = _tmp1_;
	tokens_length1 = _vala_array_length (_tmp0_);
	_tokens_size_ = tokens_length1;
	_tmp2_ = tokens;
	_tmp2__length1 = tokens_length1;
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = _tmp2_;
		token_collection_length1 = _tmp2__length1;
		for (token_it = 0; token_it < _tmp2__length1; token_it = token_it + 1) {
			const gchar* token = NULL;
			token = token_collection[token_it];
			{
				gint64 t = 0LL;
				const gchar* _tmp3_;
				gint64 _tmp4_ = 0LL;
				gboolean _tmp5_;
				_tmp3_ = token;
				_tmp5_ = int64_try_parse (_tmp3_, &_tmp4_, NULL);
				t = _tmp4_;
				if (!_tmp5_) {
					result = (guint64) 0;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				if (t > ((gint64) 0xffff)) {
					result = (guint64) 0;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				res = res | (t << shift);
				shift = shift - 8;
			}
		}
	}
	result = (guint64) res;
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
vala_gir_parser_node_process (ValaGirParserNode* self,
                              ValaGirParser* parser)
{
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	gboolean _tmp35_ = FALSE;
	ValaSymbol* _tmp36_;
	ValaMap* _tmp74_;
	gboolean _tmp768_ = FALSE;
	gboolean _tmp769_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parser != NULL);
	if (self->processed) {
		return;
	}
	_tmp1_ = self->symbol;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_NAMESPACE)) {
		ValaGirParserNode* _tmp2_;
		ValaGirParserNode* _tmp3_;
		_tmp2_ = self->parent;
		_tmp3_ = parser->priv->root;
		_tmp0_ = _tmp2_ == _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			ValaArrayList* _node_list = NULL;
			ValaArrayList* _tmp4_;
			ValaArrayList* _tmp5_;
			gint _node_size = 0;
			ValaArrayList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _node_index = 0;
			_tmp4_ = self->members;
			_tmp5_ = _vala_iterable_ref0 (_tmp4_);
			_node_list = _tmp5_;
			_tmp6_ = _node_list;
			_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_node_size = _tmp8_;
			_node_index = -1;
			while (TRUE) {
				ValaGirParserNode* node = NULL;
				ValaArrayList* _tmp9_;
				gpointer _tmp10_;
				ValaGirParserNode* _tmp11_;
				const gchar* _tmp12_;
				_node_index = _node_index + 1;
				if (!(_node_index < _node_size)) {
					break;
				}
				_tmp9_ = _node_list;
				_tmp10_ = vala_list_get ((ValaList*) _tmp9_, _node_index);
				node = (ValaGirParserNode*) _tmp10_;
				_tmp11_ = node;
				_tmp12_ = _tmp11_->element_type;
				if (g_strcmp0 (_tmp12_, "alias") == 0) {
					ValaGirParserNode* _tmp13_;
					_tmp13_ = node;
					vala_gir_parser_process_alias (parser, _tmp13_);
				}
				_vala_gir_parser_node_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp14_ = FALSE;
				_tmp14_ = TRUE;
				while (TRUE) {
					ValaArrayList* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					ValaGirParserNode* node = NULL;
					ValaArrayList* _tmp19_;
					gpointer _tmp20_;
					gboolean _tmp21_ = FALSE;
					ValaGirParserNode* _tmp22_;
					ValaSymbol* _tmp23_;
					if (!_tmp14_) {
						gint _tmp15_;
						_tmp15_ = i;
						i = _tmp15_ + 1;
					}
					_tmp14_ = FALSE;
					_tmp16_ = self->members;
					_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
					_tmp18_ = _tmp17_;
					if (!(i < _tmp18_)) {
						break;
					}
					_tmp19_ = self->members;
					_tmp20_ = vala_list_get ((ValaList*) _tmp19_, i);
					node = (ValaGirParserNode*) _tmp20_;
					_tmp22_ = node;
					_tmp23_ = _tmp22_->symbol;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_METHOD)) {
						ValaGirParserNode* _tmp24_;
						_tmp24_ = node;
						_tmp21_ = _tmp24_->new_symbol;
					} else {
						_tmp21_ = FALSE;
					}
					if (_tmp21_) {
						ValaGirParserNode* _tmp25_;
						gboolean _tmp26_ = FALSE;
						ValaArrayList* _tmp27_;
						gint _tmp28_;
						gint _tmp29_;
						_tmp25_ = node;
						vala_gir_parser_process_namespace_method (parser, self, _tmp25_);
						_tmp27_ = self->members;
						_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
						_tmp29_ = _tmp28_;
						if (i < _tmp29_) {
							ValaArrayList* _tmp30_;
							gpointer _tmp31_;
							ValaGirParserNode* _tmp32_;
							ValaGirParserNode* _tmp33_;
							_tmp30_ = self->members;
							_tmp31_ = vala_list_get ((ValaList*) _tmp30_, i);
							_tmp32_ = (ValaGirParserNode*) _tmp31_;
							_tmp33_ = node;
							_tmp26_ = _tmp32_ != _tmp33_;
							_vala_gir_parser_node_unref0 (_tmp32_);
						} else {
							_tmp26_ = FALSE;
						}
						if (_tmp26_) {
							gint _tmp34_;
							_tmp34_ = i;
							i = _tmp34_ - 1;
						}
					}
					_vala_gir_parser_node_unref0 (node);
				}
			}
		}
	}
	_tmp36_ = self->symbol;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, VALA_TYPE_CLASS)) {
		ValaMap* _tmp37_;
		_tmp37_ = self->girdata;
		_tmp35_ = _tmp37_ != NULL;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		gchar* class_struct = NULL;
		ValaMap* _tmp38_;
		gpointer _tmp39_;
		const gchar* _tmp40_;
		_tmp38_ = self->girdata;
		_tmp39_ = vala_map_get (_tmp38_, "glib:type-struct");
		class_struct = (gchar*) _tmp39_;
		_tmp40_ = class_struct;
		if (_tmp40_ != NULL) {
			ValaGirParserNode* klass = NULL;
			ValaGirParserNode* _tmp41_;
			const gchar* _tmp42_;
			ValaSourceReference* _tmp43_;
			ValaUnresolvedSymbol* _tmp44_;
			ValaUnresolvedSymbol* _tmp45_;
			ValaGirParserNode* _tmp46_;
			ValaGirParserNode* _tmp47_;
			ValaGirParserNode* _tmp48_;
			_tmp41_ = self->parent;
			_tmp42_ = class_struct;
			_tmp43_ = self->source_reference;
			_tmp44_ = vala_gir_parser_parse_symbol_from_string (parser, _tmp42_, _tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_gir_parser_resolve_node (parser, _tmp41_, _tmp45_, FALSE);
			_tmp47_ = _tmp46_;
			_vala_code_node_unref0 (_tmp45_);
			klass = _tmp47_;
			_tmp48_ = klass;
			if (_tmp48_ != NULL) {
				gint i = 0;
				i = 0;
				while (TRUE) {
					ValaGirParserNode* _tmp49_;
					ValaArrayList* _tmp50_;
					gint _tmp51_;
					gint _tmp52_;
					ValaGirParserNode* node = NULL;
					ValaGirParserNode* _tmp53_;
					ValaArrayList* _tmp54_;
					gpointer _tmp55_;
					ValaGirParserNode* _tmp56_;
					ValaSymbol* _tmp57_;
					_tmp49_ = klass;
					_tmp50_ = _tmp49_->members;
					_tmp51_ = vala_collection_get_size ((ValaCollection*) _tmp50_);
					_tmp52_ = _tmp51_;
					if (!(i < _tmp52_)) {
						break;
					}
					_tmp53_ = klass;
					_tmp54_ = _tmp53_->members;
					_tmp55_ = vala_list_get ((ValaList*) _tmp54_, i);
					node = (ValaGirParserNode*) _tmp55_;
					_tmp56_ = node;
					_tmp57_ = _tmp56_->symbol;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, VALA_TYPE_METHOD)) {
						ValaGirParserNode* _tmp58_;
						ValaGirParserNode* _tmp59_;
						ValaGirParserNode* _tmp60_;
						ValaMethod* m = NULL;
						ValaGirParserNode* _tmp61_;
						ValaSymbol* _tmp62_;
						ValaMethod* _tmp63_;
						ValaMethod* _tmp64_;
						_tmp58_ = klass;
						_tmp59_ = node;
						vala_gir_parser_node_remove_member (_tmp58_, _tmp59_);
						_tmp60_ = node;
						vala_gir_parser_node_add_member (self, _tmp60_);
						_tmp61_ = node;
						_tmp62_ = _tmp61_->symbol;
						_tmp63_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp63_;
						_tmp64_ = m;
						vala_method_set_binding (_tmp64_, VALA_MEMBER_BINDING_CLASS);
						_vala_code_node_unref0 (m);
					} else {
						gint _tmp65_;
						_tmp65_ = i;
						i = _tmp65_ + 1;
					}
					_vala_gir_parser_node_unref0 (node);
				}
			}
			_vala_gir_parser_node_unref0 (klass);
		}
		_g_free0 (class_struct);
	}
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp66_;
		ValaArrayList* _tmp67_;
		gint _node_size = 0;
		ValaArrayList* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gint _node_index = 0;
		_tmp66_ = self->members;
		_tmp67_ = _vala_iterable_ref0 (_tmp66_);
		_node_list = _tmp67_;
		_tmp68_ = _node_list;
		_tmp69_ = vala_collection_get_size ((ValaCollection*) _tmp68_);
		_tmp70_ = _tmp69_;
		_node_size = _tmp70_;
		_node_index = -1;
		while (TRUE) {
			ValaGirParserNode* node = NULL;
			ValaArrayList* _tmp71_;
			gpointer _tmp72_;
			ValaGirParserNode* _tmp73_;
			_node_index = _node_index + 1;
			if (!(_node_index < _node_size)) {
				break;
			}
			_tmp71_ = _node_list;
			_tmp72_ = vala_list_get ((ValaList*) _tmp71_, _node_index);
			node = (ValaGirParserNode*) _tmp72_;
			_tmp73_ = node;
			vala_gir_parser_node_process (_tmp73_, parser);
			_vala_gir_parser_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_tmp74_ = self->girdata;
	if (_tmp74_ != NULL) {
		ValaSymbol* _tmp75_;
		ValaGirParserMetadata* _tmp680_;
		ValaGirParserMetadata* _tmp683_;
		ValaGirParserMetadata* _tmp692_;
		const gchar* _tmp698_;
		ValaGirParserMetadata* _tmp700_;
		ValaGirParserMetadata* _tmp703_;
		ValaGirParserNode* _tmp721_;
		ValaSymbol* _tmp722_;
		gchar* _tmp731_;
		gchar* _tmp732_;
		gchar* _tmp733_;
		gchar* _tmp734_;
		gboolean _tmp735_;
		gchar* _tmp739_;
		gchar* _tmp740_;
		gchar* _tmp741_;
		gchar* _tmp742_;
		gboolean _tmp743_;
		gchar* _tmp747_;
		gchar* _tmp748_;
		gchar* _tmp749_;
		gchar* _tmp750_;
		gboolean _tmp751_;
		gchar* gir_name = NULL;
		gchar* _tmp755_;
		gchar* default_gir_name = NULL;
		gchar* _tmp756_;
		gboolean _tmp757_ = FALSE;
		gboolean _tmp758_ = FALSE;
		ValaSymbol* _tmp759_;
		_tmp75_ = self->symbol;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, VALA_TYPE_METHOD)) {
			ValaMethod* m = NULL;
			ValaSymbol* _tmp76_;
			ValaMethod* _tmp77_;
			ValaArrayList* colliding = NULL;
			ValaGirParserNode* _tmp78_;
			const gchar* _tmp79_;
			ValaArrayList* _tmp80_;
			ValaMethod* _tmp173_;
			ValaMethod* _tmp192_;
			gboolean _tmp193_;
			gboolean _tmp194_;
			_tmp76_ = self->symbol;
			_tmp77_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALA_TYPE_METHOD, ValaMethod));
			m = _tmp77_;
			vala_gir_parser_process_callable (parser, self);
			_tmp78_ = self->parent;
			_tmp79_ = self->name;
			_tmp80_ = vala_gir_parser_node_lookup_all (_tmp78_, _tmp79_);
			colliding = _tmp80_;
			{
				ValaArrayList* _node_list = NULL;
				ValaArrayList* _tmp81_;
				ValaArrayList* _tmp82_;
				gint _node_size = 0;
				ValaArrayList* _tmp83_;
				gint _tmp84_;
				gint _tmp85_;
				gint _node_index = 0;
				_tmp81_ = colliding;
				_tmp82_ = _vala_iterable_ref0 (_tmp81_);
				_node_list = _tmp82_;
				_tmp83_ = _node_list;
				_tmp84_ = vala_collection_get_size ((ValaCollection*) _tmp83_);
				_tmp85_ = _tmp84_;
				_node_size = _tmp85_;
				_node_index = -1;
				while (TRUE) {
					ValaGirParserNode* node = NULL;
					ValaArrayList* _tmp86_;
					gpointer _tmp87_;
					ValaSymbol* sym = NULL;
					ValaGirParserNode* _tmp88_;
					ValaSymbol* _tmp89_;
					ValaSymbol* _tmp90_;
					gboolean _tmp91_ = FALSE;
					gboolean _tmp92_ = FALSE;
					ValaSymbol* _tmp93_;
					_node_index = _node_index + 1;
					if (!(_node_index < _node_size)) {
						break;
					}
					_tmp86_ = _node_list;
					_tmp87_ = vala_list_get ((ValaList*) _tmp86_, _node_index);
					node = (ValaGirParserNode*) _tmp87_;
					_tmp88_ = node;
					_tmp89_ = _tmp88_->symbol;
					_tmp90_ = _vala_code_node_ref0 (_tmp89_);
					sym = _tmp90_;
					_tmp93_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp93_, VALA_TYPE_FIELD)) {
						ValaMethod* _tmp94_;
						ValaDataType* _tmp95_;
						ValaDataType* _tmp96_;
						_tmp94_ = m;
						_tmp95_ = vala_callable_get_return_type ((ValaCallable*) _tmp94_);
						_tmp96_ = _tmp95_;
						_tmp92_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp96_, VALA_TYPE_VOID_TYPE);
					} else {
						_tmp92_ = FALSE;
					}
					if (_tmp92_) {
						ValaMethod* _tmp97_;
						ValaList* _tmp98_;
						ValaList* _tmp99_;
						gint _tmp100_;
						gint _tmp101_;
						_tmp97_ = m;
						_tmp98_ = vala_callable_get_parameters ((ValaCallable*) _tmp97_);
						_tmp99_ = _tmp98_;
						_tmp100_ = vala_collection_get_size ((ValaCollection*) _tmp99_);
						_tmp101_ = _tmp100_;
						_tmp91_ = _tmp101_ == 0;
						_vala_iterable_unref0 (_tmp99_);
					} else {
						_tmp91_ = FALSE;
					}
					if (_tmp91_) {
						self->merged = TRUE;
					} else {
						ValaSymbol* _tmp102_;
						_tmp102_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp102_, VALA_TYPE_SIGNAL)) {
							ValaGirParserNode* _tmp103_;
							ValaSignal* sig = NULL;
							ValaSymbol* _tmp104_;
							ValaSignal* _tmp105_;
							gboolean _tmp106_ = FALSE;
							ValaMethod* _tmp107_;
							gboolean _tmp108_;
							gboolean _tmp109_;
							ValaSignal* _tmp115_;
							ValaMethod* _tmp116_;
							ValaMethod* _tmp117_;
							ValaList* _tmp118_;
							ValaList* _tmp119_;
							gint _tmp120_;
							gint _tmp121_;
							ValaSignal* _tmp122_;
							ValaList* _tmp123_;
							ValaList* _tmp124_;
							gint _tmp125_;
							gint _tmp126_;
							gboolean _tmp127_;
							_tmp103_ = node;
							vala_gir_parser_node_process (_tmp103_, parser);
							_tmp104_ = sym;
							_tmp105_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, VALA_TYPE_SIGNAL, ValaSignal));
							sig = _tmp105_;
							_tmp107_ = m;
							_tmp108_ = vala_method_get_is_virtual (_tmp107_);
							_tmp109_ = _tmp108_;
							if (_tmp109_) {
								_tmp106_ = TRUE;
							} else {
								ValaMethod* _tmp110_;
								gboolean _tmp111_;
								gboolean _tmp112_;
								_tmp110_ = m;
								_tmp111_ = vala_method_get_is_abstract (_tmp110_);
								_tmp112_ = _tmp111_;
								_tmp106_ = _tmp112_;
							}
							if (_tmp106_) {
								ValaSignal* _tmp113_;
								_tmp113_ = sig;
								vala_signal_set_is_virtual (_tmp113_, TRUE);
							} else {
								ValaSignal* _tmp114_;
								_tmp114_ = sig;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp114_, "HasEmitter", TRUE, NULL);
							}
							_tmp115_ = sig;
							_tmp116_ = m;
							vala_gir_parser_assume_parameter_names (parser, _tmp115_, (ValaSymbol*) _tmp116_, FALSE);
							_tmp117_ = m;
							_tmp118_ = vala_callable_get_parameters ((ValaCallable*) _tmp117_);
							_tmp119_ = _tmp118_;
							_tmp120_ = vala_collection_get_size ((ValaCollection*) _tmp119_);
							_tmp121_ = _tmp120_;
							_tmp122_ = sig;
							_tmp123_ = vala_callable_get_parameters ((ValaCallable*) _tmp122_);
							_tmp124_ = _tmp123_;
							_tmp125_ = vala_collection_get_size ((ValaCollection*) _tmp124_);
							_tmp126_ = _tmp125_;
							_tmp127_ = _tmp121_ != _tmp126_;
							_vala_iterable_unref0 (_tmp124_);
							_vala_iterable_unref0 (_tmp119_);
							if (_tmp127_) {
								ValaSymbol* _tmp128_;
								ValaSourceReference* _tmp129_;
								ValaSourceReference* _tmp130_;
								gchar* _tmp131_;
								gchar* _tmp132_;
								gchar* _tmp133_;
								gchar* _tmp134_;
								_tmp128_ = self->symbol;
								_tmp129_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp128_);
								_tmp130_ = _tmp129_;
								_tmp131_ = vala_gir_parser_node_get_full_name (self);
								_tmp132_ = _tmp131_;
								_tmp133_ = g_strdup_printf ("Signal `%s' conflicts with method of the same name", _tmp132_);
								_tmp134_ = _tmp133_;
								vala_report_warning (_tmp130_, _tmp134_);
								_g_free0 (_tmp134_);
								_g_free0 (_tmp132_);
							}
							self->merged = TRUE;
							_vala_code_node_unref0 (sig);
						} else {
							gboolean _tmp135_ = FALSE;
							gboolean _tmp136_ = FALSE;
							ValaSymbol* _tmp137_;
							_tmp137_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp137_, VALA_TYPE_METHOD)) {
								ValaSymbol* _tmp138_;
								_tmp138_ = sym;
								_tmp136_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp138_, VALA_TYPE_CREATION_METHOD);
							} else {
								_tmp136_ = FALSE;
							}
							if (_tmp136_) {
								ValaGirParserNode* _tmp139_;
								_tmp139_ = node;
								_tmp135_ = _tmp139_ != self;
							} else {
								_tmp135_ = FALSE;
							}
							if (_tmp135_) {
								gboolean _tmp140_ = FALSE;
								ValaMethod* _tmp141_;
								gboolean _tmp142_;
								gboolean _tmp143_;
								_tmp141_ = m;
								_tmp142_ = vala_method_get_is_virtual (_tmp141_);
								_tmp143_ = _tmp142_;
								if (_tmp143_) {
									_tmp140_ = TRUE;
								} else {
									ValaMethod* _tmp144_;
									gboolean _tmp145_;
									gboolean _tmp146_;
									_tmp144_ = m;
									_tmp145_ = vala_method_get_is_abstract (_tmp144_);
									_tmp146_ = _tmp145_;
									_tmp140_ = _tmp146_;
								}
								if (_tmp140_) {
									gboolean different_invoker = FALSE;
									ValaAttribute* attr = NULL;
									ValaMethod* _tmp147_;
									ValaAttribute* _tmp148_;
									ValaAttribute* _tmp149_;
									ValaAttribute* _tmp150_;
									different_invoker = FALSE;
									_tmp147_ = m;
									_tmp148_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp147_, "NoWrapper");
									_tmp149_ = _vala_code_node_ref0 (_tmp148_);
									attr = _tmp149_;
									_tmp150_ = attr;
									if (_tmp150_ != NULL) {
										ValaGirParserNode* invoker = NULL;
										ValaGirParserNode* _tmp151_;
										ValaGirParserNode* _tmp152_;
										_tmp151_ = vala_gir_parser_find_invoker (parser, self);
										invoker = _tmp151_;
										_tmp152_ = invoker;
										if (_tmp152_ != NULL) {
											ValaMethod* _tmp153_;
											ValaMethod* _tmp154_;
											const gchar* _tmp155_;
											const gchar* _tmp156_;
											ValaMethod* _tmp157_;
											ValaGirParserNode* _tmp158_;
											ValaSymbol* _tmp159_;
											const gchar* _tmp160_;
											const gchar* _tmp161_;
											ValaMethod* _tmp162_;
											ValaGirParserNode* _tmp163_;
											_tmp153_ = m;
											_tmp154_ = m;
											_tmp155_ = vala_symbol_get_name ((ValaSymbol*) _tmp154_);
											_tmp156_ = _tmp155_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp153_, "CCode", "vfunc_name", _tmp156_, NULL);
											_tmp157_ = m;
											_tmp158_ = invoker;
											_tmp159_ = _tmp158_->symbol;
											_tmp160_ = vala_symbol_get_name (_tmp159_);
											_tmp161_ = _tmp160_;
											vala_symbol_set_name ((ValaSymbol*) _tmp157_, _tmp161_);
											_tmp162_ = m;
											vala_code_node_set_attribute ((ValaCodeNode*) _tmp162_, "NoWrapper", FALSE, NULL);
											_tmp163_ = invoker;
											_tmp163_->merged = TRUE;
											different_invoker = TRUE;
										}
										_vala_gir_parser_node_unref0 (invoker);
									}
									if (!different_invoker) {
										ValaAttribute* _tmp164_;
										ValaGirParserNode* _tmp172_;
										_tmp164_ = attr;
										if (_tmp164_ != NULL) {
											ValaSymbol* _tmp165_;
											ValaSourceReference* _tmp166_;
											ValaSourceReference* _tmp167_;
											gchar* _tmp168_;
											gchar* _tmp169_;
											gchar* _tmp170_;
											gchar* _tmp171_;
											_tmp165_ = self->symbol;
											_tmp166_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp165_);
											_tmp167_ = _tmp166_;
											_tmp168_ = vala_gir_parser_node_get_full_name (self);
											_tmp169_ = _tmp168_;
											_tmp170_ = g_strdup_printf ("Virtual method `%s' conflicts with method of the same name", _tmp169_);
											_tmp171_ = _tmp170_;
											vala_report_warning (_tmp167_, _tmp171_);
											_g_free0 (_tmp171_);
											_g_free0 (_tmp169_);
										}
										_tmp172_ = node;
										_tmp172_->merged = TRUE;
									}
									_vala_code_node_unref0 (attr);
								}
							}
						}
					}
					_vala_code_node_unref0 (sym);
					_vala_gir_parser_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			_tmp173_ = m;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp173_, VALA_TYPE_CREATION_METHOD)) {
				ValaGirParserMetadata* _tmp174_;
				ValaGirParserMetadata* _tmp177_;
				ValaGirParserMetadata* _tmp180_;
				_tmp174_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp174_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE)) {
					ValaMethod* _tmp175_;
					ValaGirParserMetadata* _tmp176_;
					_tmp175_ = m;
					_tmp176_ = self->metadata;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp175_, "DestroysInstance", vala_gir_parser_metadata_get_bool (_tmp176_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE, FALSE), NULL);
				}
				_tmp177_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp177_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER)) {
					ValaMethod* _tmp178_;
					ValaGirParserMetadata* _tmp179_;
					_tmp178_ = m;
					_tmp179_ = self->metadata;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp178_, "ReturnsModifiedPointer", vala_gir_parser_metadata_get_bool (_tmp179_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER, FALSE), NULL);
				}
				_tmp180_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp180_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME)) {
					ValaGirParserNode* vfunc = NULL;
					ValaGirParserNode* _tmp181_;
					ValaGirParserMetadata* _tmp182_;
					gchar* _tmp183_;
					gchar* _tmp184_;
					ValaGirParserNode* _tmp185_;
					ValaGirParserNode* _tmp186_;
					gboolean _tmp187_ = FALSE;
					ValaGirParserNode* _tmp188_;
					_tmp181_ = self->parent;
					_tmp182_ = self->metadata;
					_tmp183_ = vala_gir_parser_metadata_get_string (_tmp182_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
					_tmp184_ = _tmp183_;
					_tmp185_ = vala_gir_parser_node_lookup (_tmp181_, _tmp184_, FALSE, NULL);
					_tmp186_ = _tmp185_;
					_g_free0 (_tmp184_);
					vfunc = _tmp186_;
					_tmp188_ = vfunc;
					if (_tmp188_ != NULL) {
						ValaGirParserNode* _tmp189_;
						_tmp189_ = vfunc;
						_tmp187_ = _tmp189_ != self;
					} else {
						_tmp187_ = FALSE;
					}
					if (_tmp187_) {
						ValaGirParserNode* _tmp190_;
						ValaGirParserNode* _tmp191_;
						_tmp190_ = vfunc;
						_tmp190_->processed = TRUE;
						_tmp191_ = vfunc;
						_tmp191_->merged = TRUE;
					}
					_vala_gir_parser_node_unref0 (vfunc);
				}
			}
			_tmp192_ = m;
			_tmp193_ = vala_method_get_coroutine (_tmp192_);
			_tmp194_ = _tmp193_;
			if (_tmp194_) {
				vala_gir_parser_process_async_method (parser, self);
			}
			_vala_iterable_unref0 (colliding);
			_vala_code_node_unref0 (m);
		} else {
			ValaSymbol* _tmp195_;
			_tmp195_ = self->symbol;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp195_, VALA_TYPE_PROPERTY)) {
				ValaArrayList* colliding = NULL;
				ValaGirParserNode* _tmp196_;
				const gchar* _tmp197_;
				ValaArrayList* _tmp198_;
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp213_;
				ValaProperty* _tmp214_;
				gchar* readable = NULL;
				ValaMap* _tmp215_;
				gpointer _tmp216_;
				gchar* writable = NULL;
				ValaMap* _tmp217_;
				gpointer _tmp218_;
				gchar* construct_ = NULL;
				ValaMap* _tmp219_;
				gpointer _tmp220_;
				gchar* construct_only = NULL;
				ValaMap* _tmp221_;
				gpointer _tmp222_;
				const gchar* _tmp223_;
				gboolean _tmp232_ = FALSE;
				const gchar* _tmp233_;
				ValaGirParserNode* getter = NULL;
				ValaArrayList* getters = NULL;
				ValaGirParserNode* _tmp249_;
				const gchar* _tmp250_;
				gchar* _tmp251_;
				gchar* _tmp252_;
				ValaArrayList* _tmp253_;
				ValaArrayList* _tmp254_;
				ValaArrayList* _tmp255_;
				ValaGirParserNode* setter = NULL;
				ValaArrayList* setters = NULL;
				ValaGirParserNode* _tmp278_;
				const gchar* _tmp279_;
				gchar* _tmp280_;
				gchar* _tmp281_;
				ValaArrayList* _tmp282_;
				ValaArrayList* _tmp283_;
				ValaArrayList* _tmp284_;
				gboolean _tmp307_ = FALSE;
				const gchar* _tmp308_;
				ValaProperty* _tmp310_;
				ValaProperty* _tmp311_;
				ValaPropertyAccessor* _tmp312_;
				ValaPropertyAccessor* _tmp313_;
				gboolean _tmp371_ = FALSE;
				gboolean _tmp372_ = FALSE;
				ValaProperty* _tmp373_;
				ValaAttribute* _tmp374_;
				ValaProperty* _tmp441_;
				ValaAttribute* _tmp442_;
				ValaGirParserMetadata* _tmp488_;
				ValaProperty* _tmp491_;
				ValaAttribute* _tmp492_;
				_tmp196_ = self->parent;
				_tmp197_ = self->name;
				_tmp198_ = vala_gir_parser_node_lookup_all (_tmp196_, _tmp197_);
				colliding = _tmp198_;
				{
					ValaArrayList* _node_list = NULL;
					ValaArrayList* _tmp199_;
					ValaArrayList* _tmp200_;
					gint _node_size = 0;
					ValaArrayList* _tmp201_;
					gint _tmp202_;
					gint _tmp203_;
					gint _node_index = 0;
					_tmp199_ = colliding;
					_tmp200_ = _vala_iterable_ref0 (_tmp199_);
					_node_list = _tmp200_;
					_tmp201_ = _node_list;
					_tmp202_ = vala_collection_get_size ((ValaCollection*) _tmp201_);
					_tmp203_ = _tmp202_;
					_node_size = _tmp203_;
					_node_index = -1;
					while (TRUE) {
						ValaGirParserNode* node = NULL;
						ValaArrayList* _tmp204_;
						gpointer _tmp205_;
						ValaGirParserNode* _tmp206_;
						ValaSymbol* _tmp207_;
						_node_index = _node_index + 1;
						if (!(_node_index < _node_size)) {
							break;
						}
						_tmp204_ = _node_list;
						_tmp205_ = vala_list_get ((ValaList*) _tmp204_, _node_index);
						node = (ValaGirParserNode*) _tmp205_;
						_tmp206_ = node;
						_tmp207_ = _tmp206_->symbol;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp207_, VALA_TYPE_SIGNAL)) {
							ValaGirParserNode* _tmp208_;
							ValaGirParserNode* _tmp209_;
							_tmp208_ = node;
							_tmp208_->processed = TRUE;
							_tmp209_ = node;
							_tmp209_->merged = TRUE;
						} else {
							ValaGirParserNode* _tmp210_;
							ValaSymbol* _tmp211_;
							_tmp210_ = node;
							_tmp211_ = _tmp210_->symbol;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp211_, VALA_TYPE_METHOD)) {
								ValaGirParserNode* _tmp212_;
								_tmp212_ = node;
								_tmp212_->merged = TRUE;
							}
						}
						_vala_gir_parser_node_unref0 (node);
					}
					_vala_iterable_unref0 (_node_list);
				}
				_tmp213_ = self->symbol;
				_tmp214_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp213_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp214_;
				_tmp215_ = self->girdata;
				_tmp216_ = vala_map_get (_tmp215_, "readable");
				readable = (gchar*) _tmp216_;
				_tmp217_ = self->girdata;
				_tmp218_ = vala_map_get (_tmp217_, "writable");
				writable = (gchar*) _tmp218_;
				_tmp219_ = self->girdata;
				_tmp220_ = vala_map_get (_tmp219_, "construct");
				construct_ = (gchar*) _tmp220_;
				_tmp221_ = self->girdata;
				_tmp222_ = vala_map_get (_tmp221_, "construct-only");
				construct_only = (gchar*) _tmp222_;
				_tmp223_ = readable;
				if (g_strcmp0 (_tmp223_, "0") != 0) {
					ValaProperty* _tmp224_;
					ValaProperty* _tmp225_;
					ValaDataType* _tmp226_;
					ValaDataType* _tmp227_;
					ValaDataType* _tmp228_;
					ValaDataType* _tmp229_;
					ValaPropertyAccessor* _tmp230_;
					ValaPropertyAccessor* _tmp231_;
					_tmp224_ = prop;
					_tmp225_ = prop;
					_tmp226_ = vala_property_get_property_type (_tmp225_);
					_tmp227_ = _tmp226_;
					_tmp228_ = vala_data_type_copy (_tmp227_);
					_tmp229_ = _tmp228_;
					_tmp230_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp229_, NULL, NULL, NULL);
					_tmp231_ = _tmp230_;
					vala_property_set_get_accessor (_tmp224_, _tmp231_);
					_vala_code_node_unref0 (_tmp231_);
					_vala_code_node_unref0 (_tmp229_);
				}
				_tmp233_ = writable;
				if (g_strcmp0 (_tmp233_, "1") == 0) {
					_tmp232_ = TRUE;
				} else {
					const gchar* _tmp234_;
					_tmp234_ = construct_only;
					_tmp232_ = g_strcmp0 (_tmp234_, "1") == 0;
				}
				if (_tmp232_) {
					gboolean _tmp235_ = FALSE;
					const gchar* _tmp236_;
					gboolean _tmp238_ = FALSE;
					const gchar* _tmp239_;
					ValaProperty* _tmp241_;
					ValaProperty* _tmp242_;
					ValaDataType* _tmp243_;
					ValaDataType* _tmp244_;
					ValaDataType* _tmp245_;
					ValaDataType* _tmp246_;
					ValaPropertyAccessor* _tmp247_;
					ValaPropertyAccessor* _tmp248_;
					_tmp236_ = construct_only;
					if (g_strcmp0 (_tmp236_, "1") != 0) {
						const gchar* _tmp237_;
						_tmp237_ = writable;
						_tmp235_ = g_strcmp0 (_tmp237_, "1") == 0;
					} else {
						_tmp235_ = FALSE;
					}
					_tmp239_ = construct_only;
					if (g_strcmp0 (_tmp239_, "1") == 0) {
						_tmp238_ = TRUE;
					} else {
						const gchar* _tmp240_;
						_tmp240_ = construct_;
						_tmp238_ = g_strcmp0 (_tmp240_, "1") == 0;
					}
					_tmp241_ = prop;
					_tmp242_ = prop;
					_tmp243_ = vala_property_get_property_type (_tmp242_);
					_tmp244_ = _tmp243_;
					_tmp245_ = vala_data_type_copy (_tmp244_);
					_tmp246_ = _tmp245_;
					_tmp247_ = vala_property_accessor_new (FALSE, _tmp235_, _tmp238_, _tmp246_, NULL, NULL, NULL);
					_tmp248_ = _tmp247_;
					vala_property_set_set_accessor (_tmp241_, _tmp248_);
					_vala_code_node_unref0 (_tmp248_);
					_vala_code_node_unref0 (_tmp246_);
				}
				getter = NULL;
				_tmp249_ = self->parent;
				_tmp250_ = self->name;
				_tmp251_ = g_strdup_printf ("get_%s", _tmp250_);
				_tmp252_ = _tmp251_;
				_tmp253_ = vala_gir_parser_node_lookup_all (_tmp249_, _tmp252_);
				_tmp254_ = _tmp253_;
				_g_free0 (_tmp252_);
				getters = _tmp254_;
				_tmp255_ = getters;
				if (_tmp255_ != NULL) {
					{
						ValaArrayList* _g_list = NULL;
						ValaArrayList* _tmp256_;
						ValaArrayList* _tmp257_;
						gint _g_size = 0;
						ValaArrayList* _tmp258_;
						gint _tmp259_;
						gint _tmp260_;
						gint _g_index = 0;
						_tmp256_ = getters;
						_tmp257_ = _vala_iterable_ref0 (_tmp256_);
						_g_list = _tmp257_;
						_tmp258_ = _g_list;
						_tmp259_ = vala_collection_get_size ((ValaCollection*) _tmp258_);
						_tmp260_ = _tmp259_;
						_g_size = _tmp260_;
						_g_index = -1;
						while (TRUE) {
							ValaGirParserNode* g = NULL;
							ValaArrayList* _tmp261_;
							gpointer _tmp262_;
							gboolean _tmp263_ = FALSE;
							gboolean _tmp264_ = FALSE;
							ValaGirParserNode* _tmp265_;
							_g_index = _g_index + 1;
							if (!(_g_index < _g_size)) {
								break;
							}
							_tmp261_ = _g_list;
							_tmp262_ = vala_list_get ((ValaList*) _tmp261_, _g_index);
							g = (ValaGirParserNode*) _tmp262_;
							_tmp265_ = getter;
							if (_tmp265_ == NULL) {
								_tmp264_ = TRUE;
							} else {
								ValaGirParserNode* _tmp266_;
								_tmp266_ = g;
								_tmp264_ = !_tmp266_->merged;
							}
							if (_tmp264_) {
								ValaGirParserNode* _tmp267_;
								gchar* _tmp268_;
								gchar* _tmp269_;
								ValaGirParserNode* _tmp270_;
								gchar* _tmp271_;
								gchar* _tmp272_;
								const gchar* _tmp273_;
								gchar* _tmp274_;
								gchar* _tmp275_;
								_tmp267_ = g;
								_tmp268_ = vala_gir_parser_node_get_cname (_tmp267_);
								_tmp269_ = _tmp268_;
								_tmp270_ = self->parent;
								_tmp271_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp270_);
								_tmp272_ = _tmp271_;
								_tmp273_ = self->name;
								_tmp274_ = g_strdup_printf ("%sget_%s", _tmp272_, _tmp273_);
								_tmp275_ = _tmp274_;
								_tmp263_ = g_strcmp0 (_tmp269_, _tmp275_) == 0;
								_g_free0 (_tmp275_);
								_g_free0 (_tmp272_);
								_g_free0 (_tmp269_);
							} else {
								_tmp263_ = FALSE;
							}
							if (_tmp263_) {
								ValaGirParserNode* _tmp276_;
								ValaGirParserNode* _tmp277_;
								_tmp276_ = g;
								_tmp277_ = _vala_gir_parser_node_ref0 (_tmp276_);
								_vala_gir_parser_node_unref0 (getter);
								getter = _tmp277_;
							}
							_vala_gir_parser_node_unref0 (g);
						}
						_vala_iterable_unref0 (_g_list);
					}
				}
				setter = NULL;
				_tmp278_ = self->parent;
				_tmp279_ = self->name;
				_tmp280_ = g_strdup_printf ("set_%s", _tmp279_);
				_tmp281_ = _tmp280_;
				_tmp282_ = vala_gir_parser_node_lookup_all (_tmp278_, _tmp281_);
				_tmp283_ = _tmp282_;
				_g_free0 (_tmp281_);
				setters = _tmp283_;
				_tmp284_ = setters;
				if (_tmp284_ != NULL) {
					{
						ValaArrayList* _s_list = NULL;
						ValaArrayList* _tmp285_;
						ValaArrayList* _tmp286_;
						gint _s_size = 0;
						ValaArrayList* _tmp287_;
						gint _tmp288_;
						gint _tmp289_;
						gint _s_index = 0;
						_tmp285_ = setters;
						_tmp286_ = _vala_iterable_ref0 (_tmp285_);
						_s_list = _tmp286_;
						_tmp287_ = _s_list;
						_tmp288_ = vala_collection_get_size ((ValaCollection*) _tmp287_);
						_tmp289_ = _tmp288_;
						_s_size = _tmp289_;
						_s_index = -1;
						while (TRUE) {
							ValaGirParserNode* s = NULL;
							ValaArrayList* _tmp290_;
							gpointer _tmp291_;
							gboolean _tmp292_ = FALSE;
							gboolean _tmp293_ = FALSE;
							ValaGirParserNode* _tmp294_;
							_s_index = _s_index + 1;
							if (!(_s_index < _s_size)) {
								break;
							}
							_tmp290_ = _s_list;
							_tmp291_ = vala_list_get ((ValaList*) _tmp290_, _s_index);
							s = (ValaGirParserNode*) _tmp291_;
							_tmp294_ = setter;
							if (_tmp294_ == NULL) {
								_tmp293_ = TRUE;
							} else {
								ValaGirParserNode* _tmp295_;
								_tmp295_ = s;
								_tmp293_ = !_tmp295_->merged;
							}
							if (_tmp293_) {
								ValaGirParserNode* _tmp296_;
								gchar* _tmp297_;
								gchar* _tmp298_;
								ValaGirParserNode* _tmp299_;
								gchar* _tmp300_;
								gchar* _tmp301_;
								const gchar* _tmp302_;
								gchar* _tmp303_;
								gchar* _tmp304_;
								_tmp296_ = s;
								_tmp297_ = vala_gir_parser_node_get_cname (_tmp296_);
								_tmp298_ = _tmp297_;
								_tmp299_ = self->parent;
								_tmp300_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp299_);
								_tmp301_ = _tmp300_;
								_tmp302_ = self->name;
								_tmp303_ = g_strdup_printf ("%sset_%s", _tmp301_, _tmp302_);
								_tmp304_ = _tmp303_;
								_tmp292_ = g_strcmp0 (_tmp298_, _tmp304_) == 0;
								_g_free0 (_tmp304_);
								_g_free0 (_tmp301_);
								_g_free0 (_tmp298_);
							} else {
								_tmp292_ = FALSE;
							}
							if (_tmp292_) {
								ValaGirParserNode* _tmp305_;
								ValaGirParserNode* _tmp306_;
								_tmp305_ = s;
								_tmp306_ = _vala_gir_parser_node_ref0 (_tmp305_);
								_vala_gir_parser_node_unref0 (setter);
								setter = _tmp306_;
							}
							_vala_gir_parser_node_unref0 (s);
						}
						_vala_iterable_unref0 (_s_list);
					}
				}
				_tmp308_ = readable;
				if (g_strcmp0 (_tmp308_, "0") == 0) {
					const gchar* _tmp309_;
					_tmp309_ = construct_only;
					_tmp307_ = g_strcmp0 (_tmp309_, "1") == 0;
				} else {
					_tmp307_ = FALSE;
				}
				_tmp310_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp310_, "NoAccessorMethod", _tmp307_, NULL);
				_tmp311_ = prop;
				_tmp312_ = vala_property_get_get_accessor (_tmp311_);
				_tmp313_ = _tmp312_;
				if (_tmp313_ != NULL) {
					ValaMethod* _tmp314_ = NULL;
					ValaGirParserNode* _tmp315_;
					ValaMethod* m = NULL;
					ValaMethod* _tmp318_;
					ValaMethod* _tmp319_;
					_tmp315_ = getter;
					if (_tmp315_ != NULL) {
						ValaGirParserNode* _tmp316_;
						ValaSymbol* _tmp317_;
						_tmp316_ = getter;
						_tmp317_ = _tmp316_->symbol;
						_tmp314_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp317_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp317_) : NULL;
					} else {
						_tmp314_ = NULL;
					}
					_tmp318_ = _vala_code_node_ref0 (_tmp314_);
					m = _tmp318_;
					_tmp319_ = m;
					if (_tmp319_ != NULL) {
						ValaGirParserNode* _tmp320_;
						gboolean _tmp321_ = FALSE;
						gboolean _tmp322_ = FALSE;
						ValaMethod* _tmp323_;
						ValaDataType* _tmp324_;
						ValaDataType* _tmp325_;
						_tmp320_ = getter;
						vala_gir_parser_node_process (_tmp320_, parser);
						_tmp323_ = m;
						_tmp324_ = vala_callable_get_return_type ((ValaCallable*) _tmp323_);
						_tmp325_ = _tmp324_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp325_, VALA_TYPE_VOID_TYPE)) {
							_tmp322_ = TRUE;
						} else {
							ValaMethod* _tmp326_;
							ValaList* _tmp327_;
							ValaList* _tmp328_;
							gint _tmp329_;
							gint _tmp330_;
							_tmp326_ = m;
							_tmp327_ = vala_callable_get_parameters ((ValaCallable*) _tmp326_);
							_tmp328_ = _tmp327_;
							_tmp329_ = vala_collection_get_size ((ValaCollection*) _tmp328_);
							_tmp330_ = _tmp329_;
							_tmp322_ = _tmp330_ != 0;
							_vala_iterable_unref0 (_tmp328_);
						}
						if (_tmp322_) {
							_tmp321_ = TRUE;
						} else {
							ValaMethod* _tmp331_;
							gboolean _tmp332_;
							gboolean _tmp333_;
							_tmp331_ = m;
							_tmp332_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp331_);
							_tmp333_ = _tmp332_;
							_tmp321_ = _tmp333_;
						}
						if (_tmp321_) {
							ValaProperty* _tmp334_;
							_tmp334_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp334_, "NoAccessorMethod", TRUE, NULL);
						} else {
							ValaGirParserNode* _tmp335_;
							const gchar* _tmp336_;
							const gchar* _tmp337_;
							ValaProperty* _tmp348_;
							ValaPropertyAccessor* _tmp349_;
							ValaPropertyAccessor* _tmp350_;
							ValaDataType* _tmp351_;
							ValaDataType* _tmp352_;
							ValaMethod* _tmp353_;
							ValaDataType* _tmp354_;
							ValaDataType* _tmp355_;
							gboolean _tmp356_;
							gboolean _tmp357_;
							gboolean _tmp358_ = FALSE;
							gboolean _tmp359_ = FALSE;
							ValaMethod* _tmp360_;
							gboolean _tmp361_;
							gboolean _tmp362_;
							_tmp335_ = getter;
							_tmp336_ = _tmp335_->name;
							_tmp337_ = self->name;
							if (g_strcmp0 (_tmp336_, _tmp337_) == 0) {
								{
									ValaArrayList* _node_list = NULL;
									ValaArrayList* _tmp338_;
									ValaArrayList* _tmp339_;
									gint _node_size = 0;
									ValaArrayList* _tmp340_;
									gint _tmp341_;
									gint _tmp342_;
									gint _node_index = 0;
									_tmp338_ = colliding;
									_tmp339_ = _vala_iterable_ref0 (_tmp338_);
									_node_list = _tmp339_;
									_tmp340_ = _node_list;
									_tmp341_ = vala_collection_get_size ((ValaCollection*) _tmp340_);
									_tmp342_ = _tmp341_;
									_node_size = _tmp342_;
									_node_index = -1;
									while (TRUE) {
										ValaGirParserNode* node = NULL;
										ValaArrayList* _tmp343_;
										gpointer _tmp344_;
										ValaGirParserNode* _tmp345_;
										ValaSymbol* _tmp346_;
										_node_index = _node_index + 1;
										if (!(_node_index < _node_size)) {
											break;
										}
										_tmp343_ = _node_list;
										_tmp344_ = vala_list_get ((ValaList*) _tmp343_, _node_index);
										node = (ValaGirParserNode*) _tmp344_;
										_tmp345_ = node;
										_tmp346_ = _tmp345_->symbol;
										if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp346_, VALA_TYPE_METHOD)) {
											ValaGirParserNode* _tmp347_;
											_tmp347_ = node;
											_tmp347_->merged = TRUE;
										}
										_vala_gir_parser_node_unref0 (node);
									}
									_vala_iterable_unref0 (_node_list);
								}
							}
							_tmp348_ = prop;
							_tmp349_ = vala_property_get_get_accessor (_tmp348_);
							_tmp350_ = _tmp349_;
							_tmp351_ = vala_property_accessor_get_value_type (_tmp350_);
							_tmp352_ = _tmp351_;
							_tmp353_ = m;
							_tmp354_ = vala_callable_get_return_type ((ValaCallable*) _tmp353_);
							_tmp355_ = _tmp354_;
							_tmp356_ = vala_data_type_get_value_owned (_tmp355_);
							_tmp357_ = _tmp356_;
							vala_data_type_set_value_owned (_tmp352_, _tmp357_);
							_tmp360_ = m;
							_tmp361_ = vala_method_get_is_abstract (_tmp360_);
							_tmp362_ = _tmp361_;
							if (!_tmp362_) {
								ValaMethod* _tmp363_;
								gboolean _tmp364_;
								gboolean _tmp365_;
								_tmp363_ = m;
								_tmp364_ = vala_method_get_is_virtual (_tmp363_);
								_tmp365_ = _tmp364_;
								_tmp359_ = !_tmp365_;
							} else {
								_tmp359_ = FALSE;
							}
							if (_tmp359_) {
								ValaProperty* _tmp366_;
								gboolean _tmp367_;
								gboolean _tmp368_;
								_tmp366_ = prop;
								_tmp367_ = vala_property_get_is_abstract (_tmp366_);
								_tmp368_ = _tmp367_;
								_tmp358_ = _tmp368_;
							} else {
								_tmp358_ = FALSE;
							}
							if (_tmp358_) {
								ValaProperty* _tmp369_;
								_tmp369_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp369_, "ConcreteAccessor", TRUE, NULL);
							}
						}
					} else {
						ValaProperty* _tmp370_;
						_tmp370_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp370_, "NoAccessorMethod", TRUE, NULL);
					}
					_vala_code_node_unref0 (m);
				}
				_tmp373_ = prop;
				_tmp374_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp373_, "NoAccessorMethod");
				if (_tmp374_ == NULL) {
					ValaProperty* _tmp375_;
					ValaPropertyAccessor* _tmp376_;
					ValaPropertyAccessor* _tmp377_;
					_tmp375_ = prop;
					_tmp376_ = vala_property_get_set_accessor (_tmp375_);
					_tmp377_ = _tmp376_;
					_tmp372_ = _tmp377_ != NULL;
				} else {
					_tmp372_ = FALSE;
				}
				if (_tmp372_) {
					ValaProperty* _tmp378_;
					ValaPropertyAccessor* _tmp379_;
					ValaPropertyAccessor* _tmp380_;
					gboolean _tmp381_;
					gboolean _tmp382_;
					_tmp378_ = prop;
					_tmp379_ = vala_property_get_set_accessor (_tmp378_);
					_tmp380_ = _tmp379_;
					_tmp381_ = vala_property_accessor_get_writable (_tmp380_);
					_tmp382_ = _tmp381_;
					_tmp371_ = _tmp382_;
				} else {
					_tmp371_ = FALSE;
				}
				if (_tmp371_) {
					ValaMethod* _tmp383_ = NULL;
					ValaGirParserNode* _tmp384_;
					ValaMethod* m = NULL;
					ValaMethod* _tmp387_;
					ValaMethod* _tmp388_;
					_tmp384_ = setter;
					if (_tmp384_ != NULL) {
						ValaGirParserNode* _tmp385_;
						ValaSymbol* _tmp386_;
						_tmp385_ = setter;
						_tmp386_ = _tmp385_->symbol;
						_tmp383_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp386_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp386_) : NULL;
					} else {
						_tmp383_ = NULL;
					}
					_tmp387_ = _vala_code_node_ref0 (_tmp383_);
					m = _tmp387_;
					_tmp388_ = m;
					if (_tmp388_ != NULL) {
						ValaGirParserNode* _tmp389_;
						gboolean _tmp390_ = FALSE;
						gboolean _tmp391_ = FALSE;
						gboolean _tmp392_ = FALSE;
						ValaMethod* _tmp393_;
						ValaDataType* _tmp394_;
						ValaDataType* _tmp395_;
						_tmp389_ = setter;
						vala_gir_parser_node_process (_tmp389_, parser);
						_tmp393_ = m;
						_tmp394_ = vala_callable_get_return_type ((ValaCallable*) _tmp393_);
						_tmp395_ = _tmp394_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp395_, VALA_TYPE_VOID_TYPE)) {
							_tmp392_ = TRUE;
						} else {
							ValaMethod* _tmp396_;
							ValaDataType* _tmp397_;
							ValaDataType* _tmp398_;
							_tmp396_ = m;
							_tmp397_ = vala_callable_get_return_type ((ValaCallable*) _tmp396_);
							_tmp398_ = _tmp397_;
							_tmp392_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp398_, VALA_TYPE_BOOLEAN_TYPE);
						}
						if (!_tmp392_) {
							_tmp391_ = TRUE;
						} else {
							ValaMethod* _tmp399_;
							ValaList* _tmp400_;
							ValaList* _tmp401_;
							gint _tmp402_;
							gint _tmp403_;
							_tmp399_ = m;
							_tmp400_ = vala_callable_get_parameters ((ValaCallable*) _tmp399_);
							_tmp401_ = _tmp400_;
							_tmp402_ = vala_collection_get_size ((ValaCollection*) _tmp401_);
							_tmp403_ = _tmp402_;
							_tmp391_ = _tmp403_ != 1;
							_vala_iterable_unref0 (_tmp401_);
						}
						if (_tmp391_) {
							_tmp390_ = TRUE;
						} else {
							ValaMethod* _tmp404_;
							gboolean _tmp405_;
							gboolean _tmp406_;
							_tmp404_ = m;
							_tmp405_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp404_);
							_tmp406_ = _tmp405_;
							_tmp390_ = _tmp406_;
						}
						if (_tmp390_) {
							ValaProperty* _tmp407_;
							ValaProperty* _tmp408_;
							_tmp407_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp407_, "NoAccessorMethod", TRUE, NULL);
							_tmp408_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp408_, "ConcreteAccessor", FALSE, NULL);
						} else {
							ValaProperty* _tmp409_;
							ValaPropertyAccessor* _tmp410_;
							ValaPropertyAccessor* _tmp411_;
							ValaDataType* _tmp412_;
							ValaDataType* _tmp413_;
							ValaMethod* _tmp414_;
							ValaList* _tmp415_;
							ValaList* _tmp416_;
							gpointer _tmp417_;
							ValaParameter* _tmp418_;
							ValaDataType* _tmp419_;
							ValaDataType* _tmp420_;
							gboolean _tmp421_;
							gboolean _tmp422_;
							gboolean _tmp423_ = FALSE;
							gboolean _tmp424_ = FALSE;
							gboolean _tmp425_ = FALSE;
							ValaProperty* _tmp426_;
							ValaAttribute* _tmp427_;
							_tmp409_ = prop;
							_tmp410_ = vala_property_get_set_accessor (_tmp409_);
							_tmp411_ = _tmp410_;
							_tmp412_ = vala_property_accessor_get_value_type (_tmp411_);
							_tmp413_ = _tmp412_;
							_tmp414_ = m;
							_tmp415_ = vala_callable_get_parameters ((ValaCallable*) _tmp414_);
							_tmp416_ = _tmp415_;
							_tmp417_ = vala_list_get (_tmp416_, 0);
							_tmp418_ = (ValaParameter*) _tmp417_;
							_tmp419_ = vala_variable_get_variable_type ((ValaVariable*) _tmp418_);
							_tmp420_ = _tmp419_;
							_tmp421_ = vala_data_type_get_value_owned (_tmp420_);
							_tmp422_ = _tmp421_;
							vala_data_type_set_value_owned (_tmp413_, _tmp422_);
							_vala_code_node_unref0 (_tmp418_);
							_vala_iterable_unref0 (_tmp416_);
							_tmp426_ = prop;
							_tmp427_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp426_, "ConcreteAccessor");
							if (_tmp427_ != NULL) {
								ValaMethod* _tmp428_;
								gboolean _tmp429_;
								gboolean _tmp430_;
								_tmp428_ = m;
								_tmp429_ = vala_method_get_is_abstract (_tmp428_);
								_tmp430_ = _tmp429_;
								_tmp425_ = !_tmp430_;
							} else {
								_tmp425_ = FALSE;
							}
							if (_tmp425_) {
								ValaMethod* _tmp431_;
								gboolean _tmp432_;
								gboolean _tmp433_;
								_tmp431_ = m;
								_tmp432_ = vala_method_get_is_virtual (_tmp431_);
								_tmp433_ = _tmp432_;
								_tmp424_ = !_tmp433_;
							} else {
								_tmp424_ = FALSE;
							}
							if (_tmp424_) {
								ValaProperty* _tmp434_;
								gboolean _tmp435_;
								gboolean _tmp436_;
								_tmp434_ = prop;
								_tmp435_ = vala_property_get_is_abstract (_tmp434_);
								_tmp436_ = _tmp435_;
								_tmp423_ = _tmp436_;
							} else {
								_tmp423_ = FALSE;
							}
							if (_tmp423_) {
								ValaProperty* _tmp437_;
								ValaProperty* _tmp438_;
								_tmp437_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp437_, "ConcreteAccessor", TRUE, NULL);
								_tmp438_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp438_, "NoAccessorMethod", FALSE, NULL);
							}
						}
					} else {
						ValaProperty* _tmp439_;
						ValaProperty* _tmp440_;
						_tmp439_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp439_, "NoAccessorMethod", TRUE, NULL);
						_tmp440_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp440_, "ConcreteAccessor", FALSE, NULL);
					}
					_vala_code_node_unref0 (m);
				}
				_tmp441_ = prop;
				_tmp442_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp441_, "NoAccessorMethod");
				if (_tmp442_ != NULL) {
					gboolean _tmp443_ = FALSE;
					ValaProperty* _tmp444_;
					gboolean _tmp445_;
					gboolean _tmp446_;
					_tmp444_ = prop;
					_tmp445_ = vala_property_get_overrides (_tmp444_);
					_tmp446_ = _tmp445_;
					if (!_tmp446_) {
						ValaGirParserNode* _tmp447_;
						ValaSymbol* _tmp448_;
						_tmp447_ = self->parent;
						_tmp448_ = _tmp447_->symbol;
						_tmp443_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp448_, VALA_TYPE_CLASS);
					} else {
						_tmp443_ = FALSE;
					}
					if (_tmp443_) {
						ValaGirParserNode* base_prop_node = NULL;
						ValaGirParserNode* _tmp449_;
						ValaGirParserNode* _tmp450_;
						_tmp449_ = vala_gir_parser_base_interface_property (parser, self);
						base_prop_node = _tmp449_;
						_tmp450_ = base_prop_node;
						if (_tmp450_ != NULL) {
							ValaGirParserNode* _tmp451_;
							ValaProperty* base_property = NULL;
							ValaGirParserNode* _tmp452_;
							ValaSymbol* _tmp453_;
							ValaProperty* _tmp454_;
							ValaProperty* _tmp455_;
							ValaAttribute* _tmp456_;
							_tmp451_ = base_prop_node;
							vala_gir_parser_node_process (_tmp451_, parser);
							_tmp452_ = base_prop_node;
							_tmp453_ = _tmp452_->symbol;
							_tmp454_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp453_, VALA_TYPE_PROPERTY, ValaProperty));
							base_property = _tmp454_;
							_tmp455_ = base_property;
							_tmp456_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp455_, "ConcreteAccessor");
							if (_tmp456_ != NULL) {
								ValaProperty* _tmp457_;
								ValaProperty* _tmp458_;
								ValaPropertyAccessor* _tmp459_;
								ValaPropertyAccessor* _tmp460_;
								ValaProperty* _tmp473_;
								ValaPropertyAccessor* _tmp474_;
								ValaPropertyAccessor* _tmp475_;
								_tmp457_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp457_, "NoAccessorMethod", FALSE, NULL);
								_tmp458_ = prop;
								_tmp459_ = vala_property_get_get_accessor (_tmp458_);
								_tmp460_ = _tmp459_;
								if (_tmp460_ != NULL) {
									ValaProperty* _tmp461_;
									ValaPropertyAccessor* _tmp462_;
									ValaPropertyAccessor* _tmp463_;
									ValaDataType* _tmp464_;
									ValaDataType* _tmp465_;
									ValaProperty* _tmp466_;
									ValaPropertyAccessor* _tmp467_;
									ValaPropertyAccessor* _tmp468_;
									ValaDataType* _tmp469_;
									ValaDataType* _tmp470_;
									gboolean _tmp471_;
									gboolean _tmp472_;
									_tmp461_ = prop;
									_tmp462_ = vala_property_get_get_accessor (_tmp461_);
									_tmp463_ = _tmp462_;
									_tmp464_ = vala_property_accessor_get_value_type (_tmp463_);
									_tmp465_ = _tmp464_;
									_tmp466_ = base_property;
									_tmp467_ = vala_property_get_get_accessor (_tmp466_);
									_tmp468_ = _tmp467_;
									_tmp469_ = vala_property_accessor_get_value_type (_tmp468_);
									_tmp470_ = _tmp469_;
									_tmp471_ = vala_data_type_get_value_owned (_tmp470_);
									_tmp472_ = _tmp471_;
									vala_data_type_set_value_owned (_tmp465_, _tmp472_);
								}
								_tmp473_ = prop;
								_tmp474_ = vala_property_get_set_accessor (_tmp473_);
								_tmp475_ = _tmp474_;
								if (_tmp475_ != NULL) {
									ValaProperty* _tmp476_;
									ValaPropertyAccessor* _tmp477_;
									ValaPropertyAccessor* _tmp478_;
									ValaDataType* _tmp479_;
									ValaDataType* _tmp480_;
									ValaProperty* _tmp481_;
									ValaPropertyAccessor* _tmp482_;
									ValaPropertyAccessor* _tmp483_;
									ValaDataType* _tmp484_;
									ValaDataType* _tmp485_;
									gboolean _tmp486_;
									gboolean _tmp487_;
									_tmp476_ = prop;
									_tmp477_ = vala_property_get_set_accessor (_tmp476_);
									_tmp478_ = _tmp477_;
									_tmp479_ = vala_property_accessor_get_value_type (_tmp478_);
									_tmp480_ = _tmp479_;
									_tmp481_ = base_property;
									_tmp482_ = vala_property_get_set_accessor (_tmp481_);
									_tmp483_ = _tmp482_;
									_tmp484_ = vala_property_accessor_get_value_type (_tmp483_);
									_tmp485_ = _tmp484_;
									_tmp486_ = vala_data_type_get_value_owned (_tmp485_);
									_tmp487_ = _tmp486_;
									vala_data_type_set_value_owned (_tmp480_, _tmp487_);
								}
							}
							_vala_code_node_unref0 (base_property);
						}
						_vala_gir_parser_node_unref0 (base_prop_node);
					}
				}
				_tmp488_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp488_, VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD)) {
					ValaProperty* _tmp489_;
					ValaGirParserMetadata* _tmp490_;
					_tmp489_ = prop;
					_tmp490_ = self->metadata;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp489_, "NoAccessorMethod", vala_gir_parser_metadata_get_bool (_tmp490_, VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD, FALSE), NULL);
				}
				_tmp491_ = prop;
				_tmp492_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp491_, "NoAccessorMethod");
				if (_tmp492_ != NULL) {
					ValaProperty* _tmp493_;
					ValaPropertyAccessor* _tmp494_;
					ValaPropertyAccessor* _tmp495_;
					ValaProperty* _tmp501_;
					ValaPropertyAccessor* _tmp502_;
					ValaPropertyAccessor* _tmp503_;
					_tmp493_ = prop;
					_tmp494_ = vala_property_get_get_accessor (_tmp493_);
					_tmp495_ = _tmp494_;
					if (_tmp495_ != NULL) {
						ValaProperty* _tmp496_;
						ValaPropertyAccessor* _tmp497_;
						ValaPropertyAccessor* _tmp498_;
						ValaDataType* _tmp499_;
						ValaDataType* _tmp500_;
						_tmp496_ = prop;
						_tmp497_ = vala_property_get_get_accessor (_tmp496_);
						_tmp498_ = _tmp497_;
						_tmp499_ = vala_property_accessor_get_value_type (_tmp498_);
						_tmp500_ = _tmp499_;
						vala_data_type_set_value_owned (_tmp500_, TRUE);
					}
					_tmp501_ = prop;
					_tmp502_ = vala_property_get_set_accessor (_tmp501_);
					_tmp503_ = _tmp502_;
					if (_tmp503_ != NULL) {
						ValaProperty* _tmp504_;
						ValaPropertyAccessor* _tmp505_;
						ValaPropertyAccessor* _tmp506_;
						ValaDataType* _tmp507_;
						ValaDataType* _tmp508_;
						_tmp504_ = prop;
						_tmp505_ = vala_property_get_set_accessor (_tmp504_);
						_tmp506_ = _tmp505_;
						_tmp507_ = vala_property_accessor_get_value_type (_tmp506_);
						_tmp508_ = _tmp507_;
						vala_data_type_set_value_owned (_tmp508_, FALSE);
					}
				}
				_vala_iterable_unref0 (setters);
				_vala_gir_parser_node_unref0 (setter);
				_vala_iterable_unref0 (getters);
				_vala_gir_parser_node_unref0 (getter);
				_g_free0 (construct_only);
				_g_free0 (construct_);
				_g_free0 (writable);
				_g_free0 (readable);
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (colliding);
			} else {
				ValaSymbol* _tmp509_;
				_tmp509_ = self->symbol;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp509_, VALA_TYPE_FIELD)) {
					ValaField* field = NULL;
					ValaSymbol* _tmp510_;
					ValaField* _tmp511_;
					ValaArrayList* colliding = NULL;
					ValaGirParserNode* _tmp512_;
					const gchar* _tmp513_;
					ValaArrayList* _tmp514_;
					ValaArrayList* _tmp515_;
					gint _tmp516_;
					gint _tmp517_;
					ValaGirParserMetadata* _tmp518_;
					ValaGirParserMetadata* _tmp521_;
					gboolean _tmp526_ = FALSE;
					ValaField* _tmp527_;
					ValaDataType* _tmp528_;
					ValaDataType* _tmp529_;
					_tmp510_ = self->symbol;
					_tmp511_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp510_, VALA_TYPE_FIELD, ValaField));
					field = _tmp511_;
					_tmp512_ = self->parent;
					_tmp513_ = self->name;
					_tmp514_ = vala_gir_parser_node_lookup_all (_tmp512_, _tmp513_);
					colliding = _tmp514_;
					_tmp515_ = colliding;
					_tmp516_ = vala_collection_get_size ((ValaCollection*) _tmp515_);
					_tmp517_ = _tmp516_;
					if (_tmp517_ > 1) {
						self->merged = TRUE;
					}
					_tmp518_ = self->metadata;
					if (vala_gir_parser_metadata_has_argument (_tmp518_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET)) {
						ValaField* _tmp519_;
						ValaGirParserMetadata* _tmp520_;
						_tmp519_ = field;
						_tmp520_ = self->metadata;
						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp519_, "CCode", "delegate_target", vala_gir_parser_metadata_get_bool (_tmp520_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET, FALSE), NULL);
					}
					_tmp521_ = self->metadata;
					if (vala_gir_parser_metadata_has_argument (_tmp521_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME)) {
						ValaField* _tmp522_;
						ValaGirParserMetadata* _tmp523_;
						gchar* _tmp524_;
						gchar* _tmp525_;
						_tmp522_ = field;
						_tmp523_ = self->metadata;
						_tmp524_ = vala_gir_parser_metadata_get_string (_tmp523_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME);
						_tmp525_ = _tmp524_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp522_, "CCode", "delegate_target_cname", _tmp525_, NULL);
						_g_free0 (_tmp525_);
					}
					_tmp527_ = field;
					_tmp528_ = vala_variable_get_variable_type ((ValaVariable*) _tmp527_);
					_tmp529_ = _tmp528_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp529_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaGirParserNode* _tmp530_;
						ValaUnresolvedSymbol* _tmp531_;
						_tmp530_ = self->parent;
						_tmp531_ = _tmp530_->gtype_struct_for;
						_tmp526_ = _tmp531_ != NULL;
					} else {
						_tmp526_ = FALSE;
					}
					if (_tmp526_) {
						ValaDelegate* d = NULL;
						ValaField* _tmp532_;
						ValaDataType* _tmp533_;
						ValaDataType* _tmp534_;
						ValaDelegate* _tmp535_;
						ValaDelegate* _tmp536_;
						ValaDelegate* _tmp537_;
						ValaDelegate* _tmp538_;
						ValaGirParserNode* _tmp539_;
						ValaUnresolvedSymbol* _tmp540_;
						_tmp532_ = field;
						_tmp533_ = vala_variable_get_variable_type ((ValaVariable*) _tmp532_);
						_tmp534_ = _tmp533_;
						_tmp535_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp534_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp536_ = _tmp535_;
						_tmp537_ = _vala_code_node_ref0 (_tmp536_);
						d = _tmp537_;
						_tmp538_ = d;
						_tmp539_ = self->parent;
						_tmp540_ = _tmp539_->gtype_struct_for;
						vala_gir_parser_process_virtual_method_field (parser, self, _tmp538_, _tmp540_);
						self->merged = TRUE;
						_vala_code_node_unref0 (d);
					} else {
						ValaField* _tmp541_;
						ValaDataType* _tmp542_;
						ValaDataType* _tmp543_;
						_tmp541_ = field;
						_tmp542_ = vala_variable_get_variable_type ((ValaVariable*) _tmp541_);
						_tmp543_ = _tmp542_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp543_, VALA_TYPE_ARRAY_TYPE)) {
							ValaGirParserNode* array_length = NULL;
							ValaGirParserMetadata* _tmp544_;
							gboolean _tmp581_ = FALSE;
							ValaGirParserNode* _tmp582_;
							_tmp544_ = self->metadata;
							if (vala_gir_parser_metadata_has_argument (_tmp544_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD)) {
								ValaGirParserNode* _tmp545_;
								ValaGirParserMetadata* _tmp546_;
								gchar* _tmp547_;
								gchar* _tmp548_;
								ValaGirParserNode* _tmp549_;
								_tmp545_ = self->parent;
								_tmp546_ = self->metadata;
								_tmp547_ = vala_gir_parser_metadata_get_string (_tmp546_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD);
								_tmp548_ = _tmp547_;
								_tmp549_ = vala_gir_parser_node_lookup (_tmp545_, _tmp548_, FALSE, NULL);
								_vala_gir_parser_node_unref0 (array_length);
								array_length = _tmp549_;
								_g_free0 (_tmp548_);
							} else {
								gboolean _tmp550_ = FALSE;
								if (self->array_length_idx > -1) {
									ValaGirParserNode* _tmp551_;
									ValaArrayList* _tmp552_;
									gint _tmp553_;
									gint _tmp554_;
									_tmp551_ = self->parent;
									_tmp552_ = _tmp551_->members;
									_tmp553_ = vala_collection_get_size ((ValaCollection*) _tmp552_);
									_tmp554_ = _tmp553_;
									_tmp550_ = _tmp554_ > self->array_length_idx;
								} else {
									_tmp550_ = FALSE;
								}
								if (_tmp550_) {
									ValaGirParserNode* _tmp555_;
									ValaArrayList* _tmp556_;
									gpointer _tmp557_;
									_tmp555_ = self->parent;
									_tmp556_ = _tmp555_->members;
									_tmp557_ = vala_list_get ((ValaList*) _tmp556_, self->array_length_idx);
									_vala_gir_parser_node_unref0 (array_length);
									array_length = (ValaGirParserNode*) _tmp557_;
								} else {
									ValaGirParserNode* _tmp558_;
									ValaField* _tmp559_;
									const gchar* _tmp560_;
									const gchar* _tmp561_;
									gchar* _tmp562_;
									gchar* _tmp563_;
									ValaGirParserNode* _tmp564_;
									ValaGirParserNode* _tmp565_;
									_tmp558_ = self->parent;
									_tmp559_ = field;
									_tmp560_ = vala_symbol_get_name ((ValaSymbol*) _tmp559_);
									_tmp561_ = _tmp560_;
									_tmp562_ = g_strdup_printf ("n_%s", _tmp561_);
									_tmp563_ = _tmp562_;
									_tmp564_ = vala_gir_parser_node_lookup (_tmp558_, _tmp563_, FALSE, NULL);
									_vala_gir_parser_node_unref0 (array_length);
									array_length = _tmp564_;
									_g_free0 (_tmp563_);
									_tmp565_ = array_length;
									if (_tmp565_ == NULL) {
										ValaGirParserNode* _tmp566_;
										ValaField* _tmp567_;
										const gchar* _tmp568_;
										const gchar* _tmp569_;
										gchar* _tmp570_;
										gchar* _tmp571_;
										ValaGirParserNode* _tmp572_;
										ValaGirParserNode* _tmp573_;
										_tmp566_ = self->parent;
										_tmp567_ = field;
										_tmp568_ = vala_symbol_get_name ((ValaSymbol*) _tmp567_);
										_tmp569_ = _tmp568_;
										_tmp570_ = g_strdup_printf ("num_%s", _tmp569_);
										_tmp571_ = _tmp570_;
										_tmp572_ = vala_gir_parser_node_lookup (_tmp566_, _tmp571_, FALSE, NULL);
										_vala_gir_parser_node_unref0 (array_length);
										array_length = _tmp572_;
										_g_free0 (_tmp571_);
										_tmp573_ = array_length;
										if (_tmp573_ == NULL) {
											ValaGirParserNode* _tmp574_;
											ValaField* _tmp575_;
											const gchar* _tmp576_;
											const gchar* _tmp577_;
											gchar* _tmp578_;
											gchar* _tmp579_;
											ValaGirParserNode* _tmp580_;
											_tmp574_ = self->parent;
											_tmp575_ = field;
											_tmp576_ = vala_symbol_get_name ((ValaSymbol*) _tmp575_);
											_tmp577_ = _tmp576_;
											_tmp578_ = g_strdup_printf ("%s_length", _tmp577_);
											_tmp579_ = _tmp578_;
											_tmp580_ = vala_gir_parser_node_lookup (_tmp574_, _tmp579_, FALSE, NULL);
											_vala_gir_parser_node_unref0 (array_length);
											array_length = _tmp580_;
											_g_free0 (_tmp579_);
										}
									}
								}
							}
							_tmp582_ = array_length;
							if (_tmp582_ != NULL) {
								ValaGirParserNode* _tmp583_;
								ValaSymbol* _tmp584_;
								_tmp583_ = array_length;
								_tmp584_ = _tmp583_->symbol;
								_tmp581_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp584_, VALA_TYPE_FIELD);
							} else {
								_tmp581_ = FALSE;
							}
							if (_tmp581_) {
								ValaField* length_field = NULL;
								ValaGirParserNode* _tmp585_;
								ValaSymbol* _tmp586_;
								ValaField* _tmp587_;
								ValaField* _tmp588_;
								ValaField* _tmp589_;
								const gchar* _tmp590_;
								const gchar* _tmp591_;
								gchar* length_type = NULL;
								ValaField* _tmp592_;
								ValaDataType* _tmp593_;
								ValaDataType* _tmp594_;
								gchar* _tmp595_;
								const gchar* _tmp596_;
								ValaField* _tmp605_;
								ValaField* _tmp606_;
								_tmp585_ = array_length;
								_tmp586_ = _tmp585_->symbol;
								_tmp587_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp586_, VALA_TYPE_FIELD, ValaField));
								length_field = _tmp587_;
								_tmp588_ = field;
								_tmp589_ = length_field;
								_tmp590_ = vala_symbol_get_name ((ValaSymbol*) _tmp589_);
								_tmp591_ = _tmp590_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp588_, "CCode", "array_length_cname", _tmp591_, NULL);
								_tmp592_ = length_field;
								_tmp593_ = vala_variable_get_variable_type ((ValaVariable*) _tmp592_);
								_tmp594_ = _tmp593_;
								_tmp595_ = vala_data_type_to_qualified_string (_tmp594_, NULL);
								length_type = _tmp595_;
								_tmp596_ = length_type;
								if (g_strcmp0 (_tmp596_, "int") != 0) {
									ValaGirParserNode* st = NULL;
									ValaGirParserNode* _tmp597_;
									const gchar* _tmp598_;
									ValaGirParserNode* _tmp599_;
									ValaGirParserNode* _tmp600_;
									_tmp597_ = parser->priv->root;
									_tmp598_ = length_type;
									_tmp599_ = vala_gir_parser_node_lookup (_tmp597_, _tmp598_, FALSE, NULL);
									st = _tmp599_;
									_tmp600_ = st;
									if (_tmp600_ != NULL) {
										ValaField* _tmp601_;
										ValaGirParserNode* _tmp602_;
										gchar* _tmp603_;
										gchar* _tmp604_;
										_tmp601_ = field;
										_tmp602_ = st;
										_tmp603_ = vala_gir_parser_node_get_cname (_tmp602_);
										_tmp604_ = _tmp603_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp601_, "CCode", "array_length_type", _tmp604_, NULL);
										_g_free0 (_tmp604_);
									}
									_vala_gir_parser_node_unref0 (st);
								}
								_tmp605_ = field;
								vala_code_node_remove_attribute_argument ((ValaCodeNode*) _tmp605_, "CCode", "array_length");
								_tmp606_ = field;
								vala_code_node_remove_attribute_argument ((ValaCodeNode*) _tmp606_, "CCode", "array_null_terminated");
								_g_free0 (length_type);
								_vala_code_node_unref0 (length_field);
							}
							_vala_gir_parser_node_unref0 (array_length);
						}
					}
					_vala_iterable_unref0 (colliding);
					_vala_code_node_unref0 (field);
				} else {
					gboolean _tmp607_ = FALSE;
					ValaSymbol* _tmp608_;
					_tmp608_ = self->symbol;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp608_, VALA_TYPE_SIGNAL)) {
						_tmp607_ = TRUE;
					} else {
						ValaSymbol* _tmp609_;
						_tmp609_ = self->symbol;
						_tmp607_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp609_, VALA_TYPE_DELEGATE);
					}
					if (_tmp607_) {
						vala_gir_parser_process_callable (parser, self);
					} else {
						ValaSymbol* _tmp610_;
						_tmp610_ = self->symbol;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp610_, VALA_TYPE_INTERFACE)) {
							vala_gir_parser_process_interface (parser, self);
						} else {
							ValaSymbol* _tmp611_;
							_tmp611_ = self->symbol;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp611_, VALA_TYPE_STRUCT)) {
								gboolean _tmp612_ = FALSE;
								ValaGirParserNode* _tmp613_;
								ValaSymbol* _tmp614_;
								_tmp613_ = self->parent;
								_tmp614_ = _tmp613_->symbol;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp614_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
									_tmp612_ = TRUE;
								} else {
									ValaGirParserNode* _tmp615_;
									ValaSymbol* _tmp616_;
									_tmp615_ = self->parent;
									_tmp616_ = _tmp615_->symbol;
									_tmp612_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp616_, VALA_TYPE_STRUCT);
								}
								if (_tmp612_) {
									{
										ValaArrayList* _fn_list = NULL;
										ValaArrayList* _tmp617_;
										ValaArrayList* _tmp618_;
										gint _fn_size = 0;
										ValaArrayList* _tmp619_;
										gint _tmp620_;
										gint _tmp621_;
										gint _fn_index = 0;
										_tmp617_ = self->members;
										_tmp618_ = _vala_iterable_ref0 (_tmp617_);
										_fn_list = _tmp618_;
										_tmp619_ = _fn_list;
										_tmp620_ = vala_collection_get_size ((ValaCollection*) _tmp619_);
										_tmp621_ = _tmp620_;
										_fn_size = _tmp621_;
										_fn_index = -1;
										while (TRUE) {
											ValaGirParserNode* fn = NULL;
											ValaArrayList* _tmp622_;
											gpointer _tmp623_;
											ValaField* f = NULL;
											ValaGirParserNode* _tmp624_;
											ValaSymbol* _tmp625_;
											ValaField* _tmp626_;
											ValaField* _tmp627_;
											_fn_index = _fn_index + 1;
											if (!(_fn_index < _fn_size)) {
												break;
											}
											_tmp622_ = _fn_list;
											_tmp623_ = vala_list_get ((ValaList*) _tmp622_, _fn_index);
											fn = (ValaGirParserNode*) _tmp623_;
											_tmp624_ = fn;
											_tmp625_ = _tmp624_->symbol;
											_tmp626_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp625_, VALA_TYPE_FIELD) ? ((ValaField*) _tmp625_) : NULL);
											f = _tmp626_;
											_tmp627_ = f;
											if (_tmp627_ != NULL) {
												ValaField* _tmp628_;
												ValaMemberBinding _tmp629_;
												ValaMemberBinding _tmp630_;
												ValaField* _tmp638_;
												ValaSymbol* _tmp639_;
												const gchar* _tmp640_;
												const gchar* _tmp641_;
												ValaField* _tmp642_;
												const gchar* _tmp643_;
												const gchar* _tmp644_;
												gchar* _tmp645_;
												gchar* _tmp646_;
												ValaGirParserNode* _tmp647_;
												ValaField* _tmp648_;
												const gchar* _tmp649_;
												const gchar* _tmp650_;
												gchar* _tmp651_;
												ValaGirParserNode* _tmp652_;
												ValaGirParserNode* _tmp653_;
												_tmp628_ = f;
												_tmp629_ = vala_field_get_binding (_tmp628_);
												_tmp630_ = _tmp629_;
												if (_tmp630_ == VALA_MEMBER_BINDING_INSTANCE) {
													ValaField* _tmp631_;
													const gchar* _tmp632_;
													ValaGirParserNode* _tmp633_;
													gchar* _tmp634_;
													gchar* _tmp635_;
													gchar* _tmp636_;
													gchar* _tmp637_;
													_tmp631_ = f;
													_tmp632_ = self->name;
													_tmp633_ = fn;
													_tmp634_ = vala_gir_parser_node_get_cname (_tmp633_);
													_tmp635_ = _tmp634_;
													_tmp636_ = g_strdup_printf ("%s.%s", _tmp632_, _tmp635_);
													_tmp637_ = _tmp636_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp631_, "CCode", "cname", _tmp637_, NULL);
													_g_free0 (_tmp637_);
													_g_free0 (_tmp635_);
												}
												_tmp638_ = f;
												_tmp639_ = self->symbol;
												_tmp640_ = vala_symbol_get_name (_tmp639_);
												_tmp641_ = _tmp640_;
												_tmp642_ = f;
												_tmp643_ = vala_symbol_get_name ((ValaSymbol*) _tmp642_);
												_tmp644_ = _tmp643_;
												_tmp645_ = g_strdup_printf ("%s_%s", _tmp641_, _tmp644_);
												_tmp646_ = _tmp645_;
												vala_symbol_set_name ((ValaSymbol*) _tmp638_, _tmp646_);
												_g_free0 (_tmp646_);
												_tmp647_ = fn;
												_tmp648_ = f;
												_tmp649_ = vala_symbol_get_name ((ValaSymbol*) _tmp648_);
												_tmp650_ = _tmp649_;
												_tmp651_ = g_strdup (_tmp650_);
												_g_free0 (_tmp647_->name);
												_tmp647_->name = _tmp651_;
												_tmp652_ = self->parent;
												_tmp653_ = fn;
												vala_gir_parser_node_add_member (_tmp652_, _tmp653_);
											}
											_vala_code_node_unref0 (f);
											_vala_gir_parser_node_unref0 (fn);
										}
										_vala_iterable_unref0 (_fn_list);
									}
									self->merged = TRUE;
								} else {
									gchar* gtype_struct_for = NULL;
									ValaMap* _tmp654_;
									gpointer _tmp655_;
									const gchar* _tmp656_;
									_tmp654_ = self->girdata;
									_tmp655_ = vala_map_get (_tmp654_, "glib:is-gtype-struct-for");
									gtype_struct_for = (gchar*) _tmp655_;
									_tmp656_ = gtype_struct_for;
									if (_tmp656_ != NULL) {
										ValaGirParserNode* iface = NULL;
										ValaGirParserNode* _tmp657_;
										const gchar* _tmp658_;
										ValaSourceReference* _tmp659_;
										ValaUnresolvedSymbol* _tmp660_;
										ValaUnresolvedSymbol* _tmp661_;
										ValaGirParserNode* _tmp662_;
										ValaGirParserNode* _tmp663_;
										gboolean _tmp664_ = FALSE;
										gboolean _tmp665_ = FALSE;
										ValaGirParserNode* _tmp666_;
										_tmp657_ = self->parent;
										_tmp658_ = gtype_struct_for;
										_tmp659_ = self->source_reference;
										_tmp660_ = vala_gir_parser_parse_symbol_from_string (parser, _tmp658_, _tmp659_);
										_tmp661_ = _tmp660_;
										_tmp662_ = vala_gir_parser_resolve_node (parser, _tmp657_, _tmp661_, FALSE);
										_tmp663_ = _tmp662_;
										_vala_code_node_unref0 (_tmp661_);
										iface = _tmp663_;
										_tmp666_ = iface;
										if (_tmp666_ != NULL) {
											ValaGirParserNode* _tmp667_;
											ValaSymbol* _tmp668_;
											_tmp667_ = iface;
											_tmp668_ = _tmp667_->symbol;
											_tmp665_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp668_, VALA_TYPE_INTERFACE);
										} else {
											_tmp665_ = FALSE;
										}
										if (_tmp665_) {
											ValaGirParserNode* _tmp669_;
											gchar* _tmp670_;
											gchar* _tmp671_;
											gchar* _tmp672_;
											gchar* _tmp673_;
											gchar* _tmp674_;
											gchar* _tmp675_;
											_tmp669_ = iface;
											_tmp670_ = vala_gir_parser_node_get_cname (_tmp669_);
											_tmp671_ = _tmp670_;
											_tmp672_ = g_strdup_printf ("%sIface", _tmp671_);
											_tmp673_ = _tmp672_;
											_tmp674_ = vala_gir_parser_node_get_cname (self);
											_tmp675_ = _tmp674_;
											_tmp664_ = g_strcmp0 (_tmp673_, _tmp675_) != 0;
											_g_free0 (_tmp675_);
											_g_free0 (_tmp673_);
											_g_free0 (_tmp671_);
										} else {
											_tmp664_ = FALSE;
										}
										if (_tmp664_) {
											ValaGirParserNode* _tmp676_;
											ValaSymbol* _tmp677_;
											gchar* _tmp678_;
											gchar* _tmp679_;
											_tmp676_ = iface;
											_tmp677_ = _tmp676_->symbol;
											_tmp678_ = vala_gir_parser_node_get_cname (self);
											_tmp679_ = _tmp678_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp677_, "CCode", "type_cname", _tmp679_, NULL);
											_g_free0 (_tmp679_);
										}
										self->merged = TRUE;
										_vala_gir_parser_node_unref0 (iface);
									}
									_g_free0 (gtype_struct_for);
								}
							}
						}
					}
				}
			}
		}
		_tmp680_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp680_, VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT)) {
			ValaGirParserMetadata* _tmp681_;
			gchar* _tmp682_;
			self->deprecated = TRUE;
			_tmp681_ = self->metadata;
			_tmp682_ = vala_gir_parser_metadata_get_string (_tmp681_, VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT);
			_g_free0 (self->deprecated_replacement);
			self->deprecated_replacement = _tmp682_;
		}
		_tmp683_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp683_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE)) {
			ValaGirParserMetadata* _tmp684_;
			gchar* _tmp685_;
			self->deprecated = TRUE;
			_tmp684_ = self->metadata;
			_tmp685_ = vala_gir_parser_metadata_get_string (_tmp684_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE);
			_g_free0 (self->deprecated_since);
			self->deprecated_since = _tmp685_;
		} else {
			ValaMap* _tmp686_;
			gpointer _tmp687_;
			gchar* _tmp688_;
			gboolean _tmp689_;
			_tmp686_ = self->girdata;
			_tmp687_ = vala_map_get (_tmp686_, "deprecated-version");
			_tmp688_ = (gchar*) _tmp687_;
			_tmp689_ = _tmp688_ != NULL;
			_g_free0 (_tmp688_);
			if (_tmp689_) {
				ValaMap* _tmp690_;
				gpointer _tmp691_;
				self->deprecated = TRUE;
				_tmp690_ = self->girdata;
				_tmp691_ = vala_map_get (_tmp690_, "deprecated-version");
				_g_free0 (self->deprecated_since);
				self->deprecated_since = (gchar*) _tmp691_;
			}
		}
		_tmp692_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp692_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED)) {
			ValaGirParserMetadata* _tmp693_;
			_tmp693_ = self->metadata;
			self->deprecated = vala_gir_parser_metadata_get_bool (_tmp693_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED, TRUE);
			if (!self->deprecated) {
				_g_free0 (self->deprecated_since);
				self->deprecated_since = NULL;
				_g_free0 (self->deprecated_replacement);
				self->deprecated_replacement = NULL;
			}
		} else {
			ValaMap* _tmp694_;
			gpointer _tmp695_;
			gchar* _tmp696_;
			gboolean _tmp697_;
			_tmp694_ = self->girdata;
			_tmp695_ = vala_map_get (_tmp694_, "deprecated");
			_tmp696_ = (gchar*) _tmp695_;
			_tmp697_ = _tmp696_ != NULL;
			_g_free0 (_tmp696_);
			if (_tmp697_) {
				self->deprecated = TRUE;
			}
		}
		_tmp698_ = self->deprecated_since;
		if (_tmp698_ != NULL) {
			const gchar* _tmp699_;
			_tmp699_ = self->deprecated_since;
			self->deprecated_version = vala_gir_parser_node_parse_version_string (_tmp699_);
		}
		_tmp700_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp700_, VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL)) {
			ValaSymbol* _tmp701_;
			ValaGirParserMetadata* _tmp702_;
			_tmp701_ = self->symbol;
			_tmp702_ = self->metadata;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp701_, "Version", "experimental", vala_gir_parser_metadata_get_bool (_tmp702_, VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL, FALSE), NULL);
		}
		_tmp703_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp703_, VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE)) {
			ValaSymbol* _tmp704_;
			ValaVersionAttribute* _tmp705_;
			ValaVersionAttribute* _tmp706_;
			ValaGirParserMetadata* _tmp707_;
			gchar* _tmp708_;
			gchar* _tmp709_;
			_tmp704_ = self->symbol;
			_tmp705_ = vala_symbol_get_version (_tmp704_);
			_tmp706_ = _tmp705_;
			_tmp707_ = self->metadata;
			_tmp708_ = vala_gir_parser_metadata_get_string (_tmp707_, VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE);
			_tmp709_ = _tmp708_;
			vala_version_attribute_set_since (_tmp706_, _tmp709_);
			_g_free0 (_tmp709_);
		} else {
			gboolean _tmp710_ = FALSE;
			ValaSymbol* _tmp711_;
			_tmp711_ = self->symbol;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp711_, VALA_TYPE_NAMESPACE) == FALSE) {
				ValaMap* _tmp712_;
				gpointer _tmp713_;
				gchar* _tmp714_;
				_tmp712_ = self->girdata;
				_tmp713_ = vala_map_get (_tmp712_, "version");
				_tmp714_ = (gchar*) _tmp713_;
				_tmp710_ = _tmp714_ != NULL;
				_g_free0 (_tmp714_);
			} else {
				_tmp710_ = FALSE;
			}
			if (_tmp710_) {
				ValaSymbol* _tmp715_;
				ValaVersionAttribute* _tmp716_;
				ValaVersionAttribute* _tmp717_;
				ValaMap* _tmp718_;
				gpointer _tmp719_;
				gchar* _tmp720_;
				_tmp715_ = self->symbol;
				_tmp716_ = vala_symbol_get_version (_tmp715_);
				_tmp717_ = _tmp716_;
				_tmp718_ = self->girdata;
				_tmp719_ = vala_map_get (_tmp718_, "version");
				_tmp720_ = (gchar*) _tmp719_;
				vala_version_attribute_set_since (_tmp717_, _tmp720_);
				_g_free0 (_tmp720_);
			}
		}
		_tmp721_ = self->parent;
		_tmp722_ = _tmp721_->symbol;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp722_, VALA_TYPE_NAMESPACE)) {
			ValaSymbol* _tmp723_;
			gchar* _tmp724_;
			gchar* _tmp725_;
			_tmp723_ = self->symbol;
			_tmp724_ = vala_gir_parser_node_get_cheader_filename (self);
			_tmp725_ = _tmp724_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp723_, "CCode", "cheader_filename", _tmp725_, NULL);
			_g_free0 (_tmp725_);
		} else {
			ValaGirParserMetadata* _tmp726_;
			_tmp726_ = self->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp726_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME)) {
				ValaSymbol* _tmp727_;
				ValaGirParserMetadata* _tmp728_;
				gchar* _tmp729_;
				gchar* _tmp730_;
				_tmp727_ = self->symbol;
				_tmp728_ = self->metadata;
				_tmp729_ = vala_gir_parser_metadata_get_string (_tmp728_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME);
				_tmp730_ = _tmp729_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp727_, "CCode", "cheader_filename", _tmp730_, NULL);
				_g_free0 (_tmp730_);
			}
		}
		_tmp731_ = vala_gir_parser_node_get_cname (self);
		_tmp732_ = _tmp731_;
		_tmp733_ = vala_gir_parser_node_get_default_cname (self);
		_tmp734_ = _tmp733_;
		_tmp735_ = g_strcmp0 (_tmp732_, _tmp734_) != 0;
		_g_free0 (_tmp734_);
		_g_free0 (_tmp732_);
		if (_tmp735_) {
			ValaSymbol* _tmp736_;
			gchar* _tmp737_;
			gchar* _tmp738_;
			_tmp736_ = self->symbol;
			_tmp737_ = vala_gir_parser_node_get_cname (self);
			_tmp738_ = _tmp737_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp736_, "CCode", "cname", _tmp738_, NULL);
			_g_free0 (_tmp738_);
		}
		_tmp739_ = vala_gir_parser_node_get_lower_case_cprefix (self);
		_tmp740_ = _tmp739_;
		_tmp741_ = vala_gir_parser_node_get_default_lower_case_cprefix (self);
		_tmp742_ = _tmp741_;
		_tmp743_ = g_strcmp0 (_tmp740_, _tmp742_) != 0;
		_g_free0 (_tmp742_);
		_g_free0 (_tmp740_);
		if (_tmp743_) {
			ValaSymbol* _tmp744_;
			gchar* _tmp745_;
			gchar* _tmp746_;
			_tmp744_ = self->symbol;
			_tmp745_ = vala_gir_parser_node_get_lower_case_cprefix (self);
			_tmp746_ = _tmp745_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp744_, "CCode", "lower_case_cprefix", _tmp746_, NULL);
			_g_free0 (_tmp746_);
		}
		_tmp747_ = vala_gir_parser_node_get_lower_case_csuffix (self);
		_tmp748_ = _tmp747_;
		_tmp749_ = vala_gir_parser_node_get_default_lower_case_csuffix (self);
		_tmp750_ = _tmp749_;
		_tmp751_ = g_strcmp0 (_tmp748_, _tmp750_) != 0;
		_g_free0 (_tmp750_);
		_g_free0 (_tmp748_);
		if (_tmp751_) {
			ValaSymbol* _tmp752_;
			gchar* _tmp753_;
			gchar* _tmp754_;
			_tmp752_ = self->symbol;
			_tmp753_ = vala_gir_parser_node_get_lower_case_csuffix (self);
			_tmp754_ = _tmp753_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp752_, "CCode", "lower_case_csuffix", _tmp754_, NULL);
			_g_free0 (_tmp754_);
		}
		_tmp755_ = vala_gir_parser_node_get_gir_name (self);
		gir_name = _tmp755_;
		_tmp756_ = vala_gir_parser_node_get_default_gir_name (self);
		default_gir_name = _tmp756_;
		_tmp759_ = self->symbol;
		if (vala_gir_parser_is_container (_tmp759_)) {
			ValaSymbol* _tmp760_;
			_tmp760_ = self->symbol;
			_tmp758_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp760_, VALA_TYPE_NAMESPACE);
		} else {
			_tmp758_ = FALSE;
		}
		if (_tmp758_) {
			gboolean _tmp761_ = FALSE;
			const gchar* _tmp762_;
			const gchar* _tmp763_;
			_tmp762_ = self->name;
			_tmp763_ = gir_name;
			if (g_strcmp0 (_tmp762_, _tmp763_) != 0) {
				_tmp761_ = TRUE;
			} else {
				const gchar* _tmp764_;
				const gchar* _tmp765_;
				_tmp764_ = gir_name;
				_tmp765_ = default_gir_name;
				_tmp761_ = g_strcmp0 (_tmp764_, _tmp765_) != 0;
			}
			_tmp757_ = _tmp761_;
		} else {
			_tmp757_ = FALSE;
		}
		if (_tmp757_) {
			ValaSymbol* _tmp766_;
			const gchar* _tmp767_;
			_tmp766_ = self->symbol;
			_tmp767_ = gir_name;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp766_, "GIR", "name", _tmp767_, NULL);
		}
		_g_free0 (default_gir_name);
		_g_free0 (gir_name);
	}
	if (self->new_symbol) {
		_tmp769_ = self->merged;
	} else {
		_tmp769_ = FALSE;
	}
	if (!_tmp769_) {
		ValaSymbol* _tmp770_;
		_tmp770_ = self->symbol;
		_tmp768_ = vala_gir_parser_is_container (_tmp770_);
	} else {
		_tmp768_ = FALSE;
	}
	if (_tmp768_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp813_;
		ValaClass* _tmp814_;
		gboolean _tmp815_ = FALSE;
		gboolean _tmp816_ = FALSE;
		ValaClass* _tmp817_;
		{
			ValaArrayList* _node_list = NULL;
			ValaArrayList* _tmp771_;
			ValaArrayList* _tmp772_;
			gint _node_size = 0;
			ValaArrayList* _tmp773_;
			gint _tmp774_;
			gint _tmp775_;
			gint _node_index = 0;
			_tmp771_ = self->members;
			_tmp772_ = _vala_iterable_ref0 (_tmp771_);
			_node_list = _tmp772_;
			_tmp773_ = _node_list;
			_tmp774_ = vala_collection_get_size ((ValaCollection*) _tmp773_);
			_tmp775_ = _tmp774_;
			_node_size = _tmp775_;
			_node_index = -1;
			while (TRUE) {
				ValaGirParserNode* node = NULL;
				ValaArrayList* _tmp776_;
				gpointer _tmp777_;
				gboolean _tmp778_ = FALSE;
				ValaGirParserNode* _tmp784_;
				ValaGirParserNode* _tmp789_;
				const gchar* _tmp790_;
				ValaGirParserNode* _tmp797_;
				const gchar* _tmp798_;
				gboolean _tmp805_ = FALSE;
				gboolean _tmp806_ = FALSE;
				ValaGirParserNode* _tmp807_;
				_node_index = _node_index + 1;
				if (!(_node_index < _node_size)) {
					break;
				}
				_tmp776_ = _node_list;
				_tmp777_ = vala_list_get ((ValaList*) _tmp776_, _node_index);
				node = (ValaGirParserNode*) _tmp777_;
				if (self->deprecated_version > ((guint64) 0)) {
					ValaGirParserNode* _tmp779_;
					_tmp779_ = node;
					_tmp778_ = _tmp779_->deprecated_version > ((guint64) 0);
				} else {
					_tmp778_ = FALSE;
				}
				if (_tmp778_) {
					ValaGirParserNode* _tmp780_;
					_tmp780_ = node;
					if (self->deprecated_version <= _tmp780_->deprecated_version) {
						ValaGirParserNode* _tmp781_;
						ValaGirParserNode* _tmp782_;
						ValaGirParserNode* _tmp783_;
						_tmp781_ = node;
						_tmp781_->deprecated = FALSE;
						_tmp782_ = node;
						_g_free0 (_tmp782_->deprecated_since);
						_tmp782_->deprecated_since = NULL;
						_tmp783_ = node;
						_g_free0 (_tmp783_->deprecated_replacement);
						_tmp783_->deprecated_replacement = NULL;
					}
				}
				_tmp784_ = node;
				if (_tmp784_->deprecated) {
					ValaGirParserNode* _tmp785_;
					ValaSymbol* _tmp786_;
					ValaVersionAttribute* _tmp787_;
					ValaVersionAttribute* _tmp788_;
					_tmp785_ = node;
					_tmp786_ = _tmp785_->symbol;
					_tmp787_ = vala_symbol_get_version (_tmp786_);
					_tmp788_ = _tmp787_;
					vala_version_attribute_set_deprecated (_tmp788_, TRUE);
				}
				_tmp789_ = node;
				_tmp790_ = _tmp789_->deprecated_since;
				if (_tmp790_ != NULL) {
					ValaGirParserNode* _tmp791_;
					ValaSymbol* _tmp792_;
					ValaVersionAttribute* _tmp793_;
					ValaVersionAttribute* _tmp794_;
					ValaGirParserNode* _tmp795_;
					const gchar* _tmp796_;
					_tmp791_ = node;
					_tmp792_ = _tmp791_->symbol;
					_tmp793_ = vala_symbol_get_version (_tmp792_);
					_tmp794_ = _tmp793_;
					_tmp795_ = node;
					_tmp796_ = _tmp795_->deprecated_since;
					vala_version_attribute_set_deprecated_since (_tmp794_, _tmp796_);
				}
				_tmp797_ = node;
				_tmp798_ = _tmp797_->deprecated_replacement;
				if (_tmp798_ != NULL) {
					ValaGirParserNode* _tmp799_;
					ValaSymbol* _tmp800_;
					ValaVersionAttribute* _tmp801_;
					ValaVersionAttribute* _tmp802_;
					ValaGirParserNode* _tmp803_;
					const gchar* _tmp804_;
					_tmp799_ = node;
					_tmp800_ = _tmp799_->symbol;
					_tmp801_ = vala_symbol_get_version (_tmp800_);
					_tmp802_ = _tmp801_;
					_tmp803_ = node;
					_tmp804_ = _tmp803_->deprecated_replacement;
					vala_version_attribute_set_replacement (_tmp802_, _tmp804_);
				}
				_tmp807_ = node;
				if (_tmp807_->new_symbol) {
					ValaGirParserNode* _tmp808_;
					_tmp808_ = node;
					_tmp806_ = !_tmp808_->merged;
				} else {
					_tmp806_ = FALSE;
				}
				if (_tmp806_) {
					ValaGirParserMetadata* _tmp809_;
					_tmp809_ = self->metadata;
					_tmp805_ = !vala_gir_parser_metadata_get_bool (_tmp809_, VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN, FALSE);
				} else {
					_tmp805_ = FALSE;
				}
				if (_tmp805_) {
					ValaSymbol* _tmp810_;
					ValaGirParserNode* _tmp811_;
					ValaSymbol* _tmp812_;
					_tmp810_ = self->symbol;
					_tmp811_ = node;
					_tmp812_ = _tmp811_->symbol;
					vala_gir_parser_add_symbol_to_container (_tmp810_, _tmp812_);
				}
				_vala_gir_parser_node_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
		_tmp813_ = self->symbol;
		_tmp814_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp813_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp813_) : NULL);
		cl = _tmp814_;
		_tmp817_ = cl;
		if (_tmp817_ != NULL) {
			ValaClass* _tmp818_;
			gboolean _tmp819_;
			gboolean _tmp820_;
			_tmp818_ = cl;
			_tmp819_ = vala_class_get_is_compact (_tmp818_);
			_tmp820_ = _tmp819_;
			_tmp816_ = !_tmp820_;
		} else {
			_tmp816_ = FALSE;
		}
		if (_tmp816_) {
			ValaClass* _tmp821_;
			ValaCreationMethod* _tmp822_;
			ValaCreationMethod* _tmp823_;
			_tmp821_ = cl;
			_tmp822_ = vala_class_get_default_construction_method (_tmp821_);
			_tmp823_ = _tmp822_;
			_tmp815_ = _tmp823_ == NULL;
		} else {
			_tmp815_ = FALSE;
		}
		if (_tmp815_) {
			ValaCreationMethod* cm = NULL;
			ValaClass* _tmp824_;
			ValaSourceReference* _tmp825_;
			ValaSourceReference* _tmp826_;
			ValaCreationMethod* _tmp827_;
			ValaCreationMethod* _tmp828_;
			ValaCreationMethod* _tmp829_;
			ValaClass* _tmp830_;
			ValaCreationMethod* _tmp831_;
			_tmp824_ = cl;
			_tmp825_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp824_);
			_tmp826_ = _tmp825_;
			_tmp827_ = vala_creation_method_new (NULL, NULL, _tmp826_, NULL);
			cm = _tmp827_;
			_tmp828_ = cm;
			vala_method_set_has_construct_function ((ValaMethod*) _tmp828_, FALSE);
			_tmp829_ = cm;
			vala_symbol_set_access ((ValaSymbol*) _tmp829_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
			_tmp830_ = cl;
			_tmp831_ = cm;
			vala_symbol_add_method ((ValaSymbol*) _tmp830_, (ValaMethod*) _tmp831_);
			_vala_code_node_unref0 (cm);
		}
		_vala_code_node_unref0 (cl);
	}
	self->processed = TRUE;
}

static gchar*
vala_gir_parser_node_to_string (ValaGirParserNode* self)
{
	gchar* result = NULL;
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = _tmp0_->name;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->name;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	} else {
		ValaGirParserNode* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_to_string (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->name;
		_tmp8_ = g_strdup_printf ("%s.%s", _tmp6_, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp6_);
		result = _tmp9_;
		return result;
	}
}

static void
vala_gir_parser_value_node_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_node_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_node_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_node_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_node_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_node_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserNode * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_node_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	ValaGirParserNode ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_node (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	ValaGirParserParamSpecNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_node (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_node (GValue* value,
                                gpointer v_object)
{
	ValaGirParserNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_node_unref (old);
	}
}

static void
vala_gir_parser_value_take_node (GValue* value,
                                 gpointer v_object)
{
	ValaGirParserNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_node_unref (old);
	}
}

static void
vala_gir_parser_node_class_init (ValaGirParserNodeClass * klass,
                                 gpointer klass_data)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	vala_gir_parser_node_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserNodeClass *) klass)->finalize = vala_gir_parser_node_finalize;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp0_);
	vala_gir_parser_node_new_namespaces = _tmp1_;
}

static void
vala_gir_parser_node_instance_init (ValaGirParserNode * self,
                                    gpointer klass)
{
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GEqualFunc _tmp7_;
	ValaHashMap* _tmp8_;
	self->girdata = NULL;
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_gir_parser_metadata_ref0 (_tmp1_);
	self->metadata = _tmp2_;
	self->source_reference = NULL;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp3_);
	self->members = _tmp4_;
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_ARRAY_LIST, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp5_, _tmp6_, _tmp7_);
	self->scope = _tmp8_;
	self->return_array_length_idx = -1;
	self->array_length_idx = -1;
	self->deprecated = FALSE;
	self->deprecated_version = (guint64) 0;
	self->deprecated_since = NULL;
	self->deprecated_replacement = NULL;
	self->ref_count = 1;
}

static void
vala_gir_parser_node_finalize (ValaGirParserNode * obj)
{
	ValaGirParserNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNode);
	g_signal_handlers_destroy (self);
	_g_free0 (self->element_type);
	_g_free0 (self->name);
	_vala_map_unref0 (self->girdata);
	_vala_gir_parser_metadata_unref0 (self->metadata);
	_vala_source_reference_unref0 (self->source_reference);
	_vala_iterable_unref0 (self->members);
	_vala_map_unref0 (self->scope);
	_vala_comment_unref0 (self->comment);
	_vala_code_node_unref0 (self->symbol);
	_vala_iterable_unref0 (self->parameters);
	_vala_iterable_unref0 (self->array_length_parameters);
	_vala_iterable_unref0 (self->closure_parameters);
	_vala_iterable_unref0 (self->destroy_parameters);
	_vala_code_node_unref0 (self->gtype_struct_for);
	_vala_code_node_unref0 (self->base_type);
	_g_free0 (self->deprecated_since);
	_g_free0 (self->deprecated_replacement);
}

static GType
vala_gir_parser_node_get_type (void)
{
	static volatile gsize vala_gir_parser_node_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_node_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_node_init, vala_gir_parser_value_node_free_value, vala_gir_parser_value_node_copy_value, vala_gir_parser_value_node_peek_pointer, "p", vala_gir_parser_value_node_collect_value, "p", vala_gir_parser_value_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserNode), 0, (GInstanceInitFunc) vala_gir_parser_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_gir_parser_node_type_id;
		vala_gir_parser_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserNode", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_gir_parser_node_type_id__volatile, vala_gir_parser_node_type_id);
	}
	return vala_gir_parser_node_type_id__volatile;
}

static gpointer
vala_gir_parser_node_ref (gpointer instance)
{
	ValaGirParserNode * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_node_unref (gpointer instance)
{
	ValaGirParserNode * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static ValaGirParserParameterInfo*
vala_gir_parser_parameter_info_construct (GType object_type,
                                          ValaParameter* param,
                                          gint array_length_idx,
                                          gint closure_idx,
                                          gint destroy_idx,
                                          gboolean is_async)
{
	ValaGirParserParameterInfo* self = NULL;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (param != NULL, NULL);
	self = (ValaGirParserParameterInfo*) g_type_create_instance (object_type);
	_tmp0_ = _vala_code_node_ref0 (param);
	_vala_code_node_unref0 (self->param);
	self->param = _tmp0_;
	self->array_length_idx = array_length_idx;
	self->closure_idx = closure_idx;
	self->destroy_idx = destroy_idx;
	self->vala_idx = 0.0F;
	self->keep = TRUE;
	self->is_async = is_async;
	return self;
}

static ValaGirParserParameterInfo*
vala_gir_parser_parameter_info_new (ValaParameter* param,
                                    gint array_length_idx,
                                    gint closure_idx,
                                    gint destroy_idx,
                                    gboolean is_async)
{
	return vala_gir_parser_parameter_info_construct (VALA_GIR_PARSER_TYPE_PARAMETER_INFO, param, array_length_idx, closure_idx, destroy_idx, is_async);
}

static void
vala_gir_parser_value_parameter_info_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_parameter_info_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_parameter_info_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_parameter_info_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_parameter_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_parameter_info_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_parameter_info_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserParameterInfo * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_parameter_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_parameter_info_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	ValaGirParserParameterInfo ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_parameter_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_parameter_info (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	ValaGirParserParamSpecParameterInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_PARAMETER_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_parameter_info (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_parameter_info (GValue* value,
                                          gpointer v_object)
{
	ValaGirParserParameterInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_parameter_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_parameter_info_unref (old);
	}
}

static void
vala_gir_parser_value_take_parameter_info (GValue* value,
                                           gpointer v_object)
{
	ValaGirParserParameterInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_parameter_info_unref (old);
	}
}

static void
vala_gir_parser_parameter_info_class_init (ValaGirParserParameterInfoClass * klass,
                                           gpointer klass_data)
{
	vala_gir_parser_parameter_info_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserParameterInfoClass *) klass)->finalize = vala_gir_parser_parameter_info_finalize;
}

static void
vala_gir_parser_parameter_info_instance_init (ValaGirParserParameterInfo * self,
                                              gpointer klass)
{
	self->ref_count = 1;
}

static void
vala_gir_parser_parameter_info_finalize (ValaGirParserParameterInfo * obj)
{
	ValaGirParserParameterInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfo);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->param);
}

static GType
vala_gir_parser_parameter_info_get_type (void)
{
	static volatile gsize vala_gir_parser_parameter_info_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_parameter_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_parameter_info_init, vala_gir_parser_value_parameter_info_free_value, vala_gir_parser_value_parameter_info_copy_value, vala_gir_parser_value_parameter_info_peek_pointer, "p", vala_gir_parser_value_parameter_info_collect_value, "p", vala_gir_parser_value_parameter_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserParameterInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_parameter_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserParameterInfo), 0, (GInstanceInitFunc) vala_gir_parser_parameter_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_gir_parser_parameter_info_type_id;
		vala_gir_parser_parameter_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserParameterInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_gir_parser_parameter_info_type_id__volatile, vala_gir_parser_parameter_info_type_id);
	}
	return vala_gir_parser_parameter_info_type_id__volatile;
}

static gpointer
vala_gir_parser_parameter_info_ref (gpointer instance)
{
	ValaGirParserParameterInfo * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_parameter_info_unref (gpointer instance)
{
	ValaGirParserParameterInfo * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_PARAMETER_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
vala_gir_parser_class_init (ValaGirParserClass * klass,
                            gpointer klass_data)
{
	vala_gir_parser_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gir_parser_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGirParser_private_offset);
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor*, ValaSourceFile*)) vala_gir_parser_real_visit_source_file;
}

static void
vala_gir_parser_instance_init (ValaGirParser * self,
                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashSet* _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashMap* _tmp6_;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GEqualFunc _tmp11_;
	ValaHashMap* _tmp12_;
	self->priv = vala_gir_parser_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp0_);
	self->priv->metadata_roots = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp2_, _tmp3_);
	self->priv->provided_namespaces = (ValaSet*) _tmp4_;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_map_new (VALA_TYPE_UNRESOLVED_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _vala_gir_parser_unresolved_symbol_hash_ghash_func, _vala_gir_parser_unresolved_symbol_equal_gequal_func, _tmp5_);
	self->priv->unresolved_symbols_map = _tmp6_;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_UNRESOLVED_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp7_);
	self->priv->unresolved_gir_symbols = _tmp8_;
	_tmp9_ = g_direct_hash;
	_tmp10_ = g_direct_equal;
	_tmp11_ = g_direct_equal;
	_tmp12_ = vala_hash_map_new (VALA_TYPE_UNRESOLVED_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp9_, _tmp10_, _tmp11_);
	self->priv->unresolved_type_arguments = _tmp12_;
}

static void
vala_gir_parser_finalize (ValaCodeVisitor * obj)
{
	ValaGirParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GIR_PARSER, ValaGirParser);
	_vala_markup_reader_unref0 (self->priv->reader);
	_vala_code_context_unref0 (self->priv->context);
	_vala_code_node_unref0 (self->priv->glib_ns);
	_vala_source_file_unref0 (self->priv->current_source_file);
	_vala_gir_parser_node_unref0 (self->priv->root);
	_vala_iterable_unref0 (self->priv->metadata_roots);
	self->priv->cheader_filenames = (_vala_array_free (self->priv->cheader_filenames, self->priv->cheader_filenames_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->priv->metadata_stack);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	_vala_iterable_unref0 (self->priv->tree_stack);
	_vala_gir_parser_node_unref0 (self->priv->current);
	_vala_gir_parser_node_unref0 (self->priv->old_current);
	_vala_iterable_unref0 (self->priv->provided_namespaces);
	_vala_map_unref0 (self->priv->unresolved_symbols_map);
	_vala_iterable_unref0 (self->priv->unresolved_gir_symbols);
	_vala_map_unref0 (self->priv->unresolved_type_arguments);
	VALA_CODE_VISITOR_CLASS (vala_gir_parser_parent_class)->finalize (obj);
}

/**
 * Code visitor parsing all GIR source files.
 *
 * Pipeline:
 * 1) Parse metadata
 * 2) Parse GIR with metadata, track unresolved GIR symbols, create Vala symbols
 * 3) Reconciliate the tree by mapping tracked symbols
 * 4) Process the tree
 */
GType
vala_gir_parser_get_type (void)
{
	static volatile gsize vala_gir_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParser), 0, (GInstanceInitFunc) vala_gir_parser_instance_init, NULL };
		GType vala_gir_parser_type_id;
		vala_gir_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGirParser", &g_define_type_info, 0);
		ValaGirParser_private_offset = g_type_add_instance_private (vala_gir_parser_type_id, sizeof (ValaGirParserPrivate));
		g_once_init_leave (&vala_gir_parser_type_id__volatile, vala_gir_parser_type_id);
	}
	return vala_gir_parser_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

