/* valapostfixexpression.c generated by valac, the Vala compiler
 * generated from valapostfixexpression.vala, do not modify */

/* valapostfixexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaPostfixExpressionPrivate {
	gboolean _increment;
	ValaExpression* _inner;
};

static gint ValaPostfixExpression_private_offset;
static gpointer vala_postfix_expression_parent_class = NULL;

static void vala_postfix_expression_real_accept (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static void vala_postfix_expression_real_accept_children (ValaCodeNode* base,
                                                   ValaCodeVisitor* visitor);
static gboolean vala_postfix_expression_real_is_pure (ValaExpression* base);
static gboolean vala_postfix_expression_real_is_accessible (ValaExpression* base,
                                                     ValaSymbol* sym);
static void vala_postfix_expression_real_get_defined_variables (ValaCodeNode* base,
                                                         ValaCollection* collection);
static void vala_postfix_expression_real_get_used_variables (ValaCodeNode* base,
                                                      ValaCollection* collection);
static void vala_postfix_expression_real_replace_expression (ValaCodeNode* base,
                                                      ValaExpression* old_node,
                                                      ValaExpression* new_node);
static gboolean vala_postfix_expression_real_check (ValaCodeNode* base,
                                             ValaCodeContext* context);
static void vala_postfix_expression_real_emit (ValaCodeNode* base,
                                        ValaCodeGenerator* codegen);
static gchar* vala_postfix_expression_real_to_string (ValaCodeNode* base);
static void vala_postfix_expression_finalize (ValaCodeNode * obj);

static inline gpointer
vala_postfix_expression_get_instance_private (ValaPostfixExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaPostfixExpression_private_offset);
}

/**
 * Creates a new postfix expression.
 *
 * @param _inner  operand expression
 * @param inc     true for increment, false for decrement
 * @param source  reference to source code
 * @return newly  created postfix expression
 */
ValaPostfixExpression*
vala_postfix_expression_construct (GType object_type,
                                   ValaExpression* _inner,
                                   gboolean inc,
                                   ValaSourceReference* source)
{
	ValaPostfixExpression* self = NULL;
	g_return_val_if_fail (_inner != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = (ValaPostfixExpression*) vala_expression_construct (object_type);
	vala_postfix_expression_set_inner (self, _inner);
	vala_postfix_expression_set_increment (self, inc);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaPostfixExpression*
vala_postfix_expression_new (ValaExpression* _inner,
                             gboolean inc,
                             ValaSourceReference* source)
{
	return vala_postfix_expression_construct (VALA_TYPE_POSTFIX_EXPRESSION, _inner, inc, source);
}

static void
vala_postfix_expression_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaPostfixExpression * self;
	self = (ValaPostfixExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_postfix_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_postfix_expression_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor)
{
	ValaPostfixExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaPostfixExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_postfix_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
}

static gboolean
vala_postfix_expression_real_is_pure (ValaExpression* base)
{
	ValaPostfixExpression * self;
	gboolean result = FALSE;
	self = (ValaPostfixExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_postfix_expression_real_is_accessible (ValaExpression* base,
                                            ValaSymbol* sym)
{
	ValaPostfixExpression * self;
	gboolean result = FALSE;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaPostfixExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_postfix_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	result = vala_expression_is_accessible (_tmp1_, sym);
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_postfix_expression_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection)
{
	ValaPostfixExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaParameter* _tmp11_;
	ValaLocalVariable* _tmp12_;
	self = (ValaPostfixExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_postfix_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_postfix_expression_get_inner (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_symbol_reference (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_postfix_expression_get_inner (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_expression_get_symbol_reference (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp10_) : NULL);
	param = _tmp11_;
	_tmp12_ = local;
	if (_tmp12_ != NULL) {
		ValaLocalVariable* _tmp13_;
		_tmp13_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp13_);
	} else {
		gboolean _tmp14_ = FALSE;
		ValaParameter* _tmp15_;
		_tmp15_ = param;
		if (_tmp15_ != NULL) {
			ValaParameter* _tmp16_;
			ValaParameterDirection _tmp17_;
			ValaParameterDirection _tmp18_;
			_tmp16_ = param;
			_tmp17_ = vala_parameter_get_direction (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaParameter* _tmp19_;
			_tmp19_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp19_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}

static void
vala_postfix_expression_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection)
{
	ValaPostfixExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaPostfixExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_postfix_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
}

static void
vala_postfix_expression_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node)
{
	ValaPostfixExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaPostfixExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_postfix_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_postfix_expression_set_inner (self, new_node);
	}
}

static gboolean
vala_postfix_expression_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context)
{
	ValaPostfixExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	ValaExpression* _tmp10_;
	ValaExpression* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaExpression* _tmp62_;
	ValaExpression* _tmp63_;
	ValaExpression* _tmp92_;
	ValaExpression* _tmp93_;
	ValaDataType* _tmp94_;
	ValaDataType* _tmp95_;
	gboolean _tmp96_;
	gboolean _tmp97_;
	self = (ValaPostfixExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_postfix_expression_get_inner (self);
	_tmp5_ = _tmp4_;
	vala_expression_set_lvalue (_tmp5_, TRUE);
	_tmp6_ = vala_postfix_expression_get_inner (self);
	_tmp7_ = _tmp6_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp7_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp10_ = vala_postfix_expression_get_inner (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_expression_get_value_type (_tmp11_);
	_tmp13_ = _tmp12_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_INTEGER_TYPE)) {
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		_tmp14_ = vala_postfix_expression_get_inner (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_expression_get_value_type (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp9_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_FLOATING_TYPE);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		_tmp18_ = vala_postfix_expression_get_inner (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_expression_get_value_type (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp8_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaSourceReference* _tmp22_;
		ValaSourceReference* _tmp23_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp23_ = _tmp22_;
		vala_report_error (_tmp23_, "unsupported lvalue in postfix expression");
		result = FALSE;
		return result;
	}
	_tmp24_ = vala_postfix_expression_get_inner (self);
	_tmp25_ = _tmp24_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp26_;
		ValaExpression* _tmp27_;
		ValaMemberAccess* _tmp28_;
		ValaMemberAccess* _tmp29_;
		gboolean _tmp30_;
		gboolean _tmp31_;
		gboolean _tmp41_ = FALSE;
		ValaMemberAccess* _tmp42_;
		gboolean _tmp43_;
		gboolean _tmp44_;
		_tmp26_ = vala_postfix_expression_get_inner (self);
		_tmp27_ = _tmp26_;
		_tmp28_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp28_;
		_tmp29_ = ma;
		_tmp30_ = vala_member_access_get_prototype_access (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_) {
			ValaSourceReference* _tmp32_;
			ValaSourceReference* _tmp33_;
			ValaMemberAccess* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp33_ = _tmp32_;
			_tmp34_ = ma;
			_tmp35_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_symbol_get_full_name (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp38_);
			_tmp40_ = _tmp39_;
			vala_report_error (_tmp33_, _tmp40_);
			_g_free0 (_tmp40_);
			_g_free0 (_tmp38_);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp42_ = ma;
		_tmp43_ = vala_code_node_get_error ((ValaCodeNode*) _tmp42_);
		_tmp44_ = _tmp43_;
		if (_tmp44_) {
			_tmp41_ = TRUE;
		} else {
			ValaMemberAccess* _tmp45_;
			ValaSymbol* _tmp46_;
			ValaSymbol* _tmp47_;
			_tmp45_ = ma;
			_tmp46_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp41_ = _tmp47_ == NULL;
		}
		if (_tmp41_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_vala_code_node_unref0 (ma);
	} else {
		ValaExpression* _tmp48_;
		ValaExpression* _tmp49_;
		_tmp48_ = vala_postfix_expression_get_inner (self);
		_tmp49_ = _tmp48_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, VALA_TYPE_ELEMENT_ACCESS)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp50_;
			ValaExpression* _tmp51_;
			ValaElementAccess* _tmp52_;
			ValaElementAccess* _tmp53_;
			ValaExpression* _tmp54_;
			ValaExpression* _tmp55_;
			ValaDataType* _tmp56_;
			ValaDataType* _tmp57_;
			_tmp50_ = vala_postfix_expression_get_inner (self);
			_tmp51_ = _tmp50_;
			_tmp52_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
			ea = _tmp52_;
			_tmp53_ = ea;
			_tmp54_ = vala_element_access_get_container (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_expression_get_value_type (_tmp55_);
			_tmp57_ = _tmp56_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, VALA_TYPE_ARRAY_TYPE)) {
				ValaSourceReference* _tmp58_;
				ValaSourceReference* _tmp59_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp59_ = _tmp58_;
				vala_report_error (_tmp59_, "unsupported lvalue in postfix expression");
				result = FALSE;
				_vala_code_node_unref0 (ea);
				return result;
			}
			_vala_code_node_unref0 (ea);
		} else {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp61_ = _tmp60_;
			vala_report_error (_tmp61_, "unsupported lvalue in postfix expression");
			result = FALSE;
			return result;
		}
	}
	_tmp62_ = vala_postfix_expression_get_inner (self);
	_tmp63_ = _tmp62_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp63_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp64_;
		ValaExpression* _tmp65_;
		ValaMemberAccess* _tmp66_;
		ValaMemberAccess* _tmp67_;
		ValaSymbol* _tmp68_;
		ValaSymbol* _tmp69_;
		_tmp64_ = vala_postfix_expression_get_inner (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp66_;
		_tmp67_ = ma;
		_tmp68_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp67_);
		_tmp69_ = _tmp68_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, VALA_TYPE_PROPERTY)) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp70_;
			ValaSymbol* _tmp71_;
			ValaSymbol* _tmp72_;
			ValaProperty* _tmp73_;
			gboolean _tmp74_ = FALSE;
			ValaProperty* _tmp75_;
			ValaPropertyAccessor* _tmp76_;
			ValaPropertyAccessor* _tmp77_;
			_tmp70_ = ma;
			_tmp71_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp73_;
			_tmp75_ = prop;
			_tmp76_ = vala_property_get_set_accessor (_tmp75_);
			_tmp77_ = _tmp76_;
			if (_tmp77_ == NULL) {
				_tmp74_ = TRUE;
			} else {
				ValaProperty* _tmp78_;
				ValaPropertyAccessor* _tmp79_;
				ValaPropertyAccessor* _tmp80_;
				gboolean _tmp81_;
				gboolean _tmp82_;
				_tmp78_ = prop;
				_tmp79_ = vala_property_get_set_accessor (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = vala_property_accessor_get_writable (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp74_ = !_tmp82_;
			}
			if (_tmp74_) {
				ValaMemberAccess* _tmp83_;
				ValaMemberAccess* _tmp84_;
				ValaSourceReference* _tmp85_;
				ValaSourceReference* _tmp86_;
				ValaProperty* _tmp87_;
				gchar* _tmp88_;
				gchar* _tmp89_;
				gchar* _tmp90_;
				gchar* _tmp91_;
				_tmp83_ = ma;
				vala_code_node_set_error ((ValaCodeNode*) _tmp83_, TRUE);
				_tmp84_ = ma;
				_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp84_);
				_tmp86_ = _tmp85_;
				_tmp87_ = prop;
				_tmp88_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp87_);
				_tmp89_ = _tmp88_;
				_tmp90_ = g_strdup_printf ("Property `%s' is read-only", _tmp89_);
				_tmp91_ = _tmp90_;
				vala_report_error (_tmp86_, _tmp91_);
				_g_free0 (_tmp91_);
				_g_free0 (_tmp89_);
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_code_node_unref0 (ma);
				return result;
			}
			_vala_code_node_unref0 (prop);
		}
		_vala_code_node_unref0 (ma);
	}
	_tmp92_ = vala_postfix_expression_get_inner (self);
	_tmp93_ = _tmp92_;
	_tmp94_ = vala_expression_get_value_type (_tmp93_);
	_tmp95_ = _tmp94_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp95_);
	_tmp96_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp97_ = _tmp96_;
	result = !_tmp97_;
	return result;
}

static void
vala_postfix_expression_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen)
{
	ValaPostfixExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaPostfixExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_postfix_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	vala_code_visitor_visit_postfix_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static gchar*
vala_postfix_expression_real_to_string (ValaCodeNode* base)
{
	ValaPostfixExpression * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	self = (ValaPostfixExpression*) base;
	_tmp1_ = self->priv->_increment;
	if (_tmp1_) {
		_tmp0_ = "++";
	} else {
		_tmp0_ = "--";
	}
	_tmp2_ = vala_postfix_expression_get_inner (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_code_node_to_string ((ValaCodeNode*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("(%s%s)", _tmp5_, _tmp0_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	result = _tmp7_;
	return result;
}

ValaExpression*
vala_postfix_expression_get_inner (ValaPostfixExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

void
vala_postfix_expression_set_inner (ValaPostfixExpression* self,
                                   ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_postfix_expression_get_increment (ValaPostfixExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_increment;
	return result;
}

void
vala_postfix_expression_set_increment (ValaPostfixExpression* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_increment = value;
}

static void
vala_postfix_expression_class_init (ValaPostfixExpressionClass * klass)
{
	vala_postfix_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_postfix_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaPostfixExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_postfix_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_postfix_expression_real_accept_children;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_postfix_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_postfix_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_postfix_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_postfix_expression_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_postfix_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_postfix_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_postfix_expression_real_emit;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_postfix_expression_real_to_string;
}

static void
vala_postfix_expression_instance_init (ValaPostfixExpression * self)
{
	self->priv = vala_postfix_expression_get_instance_private (self);
}

static void
vala_postfix_expression_finalize (ValaCodeNode * obj)
{
	ValaPostfixExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpression);
	_vala_code_node_unref0 (self->priv->_inner);
	VALA_CODE_NODE_CLASS (vala_postfix_expression_parent_class)->finalize (obj);
}

/**
 * Represents a postfix increment or decrement expression.
 */
GType
vala_postfix_expression_get_type (void)
{
	static volatile gsize vala_postfix_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_postfix_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPostfixExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_postfix_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPostfixExpression), 0, (GInstanceInitFunc) vala_postfix_expression_instance_init, NULL };
		GType vala_postfix_expression_type_id;
		vala_postfix_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaPostfixExpression", &g_define_type_info, 0);
		ValaPostfixExpression_private_offset = g_type_add_instance_private (vala_postfix_expression_type_id, sizeof (ValaPostfixExpressionPrivate));
		g_once_init_leave (&vala_postfix_expression_type_id__volatile, vala_postfix_expression_type_id);
	}
	return vala_postfix_expression_type_id__volatile;
}

