/* valaccodefunctioncall.c generated by valac, the Vala compiler
 * generated from valaccodefunctioncall.vala, do not modify */

/* valaccodefunctioncall.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaccode.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaCCodeFunctionCallPrivate {
	ValaCCodeExpression* _call;
	ValaList* arguments;
};

static gint ValaCCodeFunctionCall_private_offset;
static gpointer vala_ccode_function_call_parent_class = NULL;

static void vala_ccode_function_call_real_write (ValaCCodeNode* base,
                                          ValaCCodeWriter* writer);
static void vala_ccode_function_call_finalize (ValaCCodeNode * obj);

static inline gpointer
vala_ccode_function_call_get_instance_private (ValaCCodeFunctionCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCCodeFunctionCall_private_offset);
}

ValaCCodeFunctionCall*
vala_ccode_function_call_construct (GType object_type,
                                    ValaCCodeExpression* call)
{
	ValaCCodeFunctionCall* self = NULL;
	self = (ValaCCodeFunctionCall*) vala_ccode_expression_construct (object_type);
	vala_ccode_function_call_set_call (self, call);
	return self;
}

ValaCCodeFunctionCall*
vala_ccode_function_call_new (ValaCCodeExpression* call)
{
	return vala_ccode_function_call_construct (VALA_TYPE_CCODE_FUNCTION_CALL, call);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param expr a C code expression
 */
void
vala_ccode_function_call_add_argument (ValaCCodeFunctionCall* self,
                                       ValaCCodeExpression* expr)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->arguments;
	vala_collection_add ((ValaCollection*) _tmp0_, expr);
}

void
vala_ccode_function_call_insert_argument (ValaCCodeFunctionCall* self,
                                          gint index,
                                          ValaCCodeExpression* expr)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->arguments;
	vala_list_insert (_tmp0_, index, expr);
}

/**
 * Returns a copy of the list of arguments.
 *
 * @return list of arguments
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_ccode_function_call_get_arguments (ValaCCodeFunctionCall* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->arguments;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
vala_ccode_function_call_real_write (ValaCCodeNode* base,
                                     ValaCCodeWriter* writer)
{
	ValaCCodeFunctionCall * self;
	ValaCCodeExpression* _tmp0_;
	gboolean first = FALSE;
	self = (ValaCCodeFunctionCall*) base;
	g_return_if_fail (writer != NULL);
	_tmp0_ = self->priv->_call;
	vala_ccode_expression_write_inner (_tmp0_, writer);
	vala_ccode_writer_write_string (writer, " (");
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _expr_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _expr_index = 0;
		_tmp1_ = self->priv->arguments;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_expr_list = _tmp2_;
		_tmp3_ = _expr_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_expr_size = _tmp5_;
		_expr_index = -1;
		while (TRUE) {
			ValaCCodeExpression* expr = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaCCodeExpression* _tmp8_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp6_ = _expr_list;
			_tmp7_ = vala_list_get (_tmp6_, _expr_index);
			expr = (ValaCCodeExpression*) _tmp7_;
			if (!first) {
				vala_ccode_writer_write_string (writer, ", ");
			} else {
				first = FALSE;
			}
			_tmp8_ = expr;
			if (_tmp8_ != NULL) {
				ValaCCodeExpression* _tmp9_;
				_tmp9_ = expr;
				vala_ccode_node_write ((ValaCCodeNode*) _tmp9_, writer);
			}
			_vala_ccode_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_ccode_writer_write_string (writer, ")");
}

ValaCCodeExpression*
vala_ccode_function_call_get_call (ValaCCodeFunctionCall* self)
{
	ValaCCodeExpression* result;
	ValaCCodeExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

void
vala_ccode_function_call_set_call (ValaCCodeFunctionCall* self,
                                   ValaCCodeExpression* value)
{
	ValaCCodeExpression* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_ccode_node_ref0 (value);
	_vala_ccode_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
}

static void
vala_ccode_function_call_class_init (ValaCCodeFunctionCallClass * klass)
{
	vala_ccode_function_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeNodeClass *) klass)->finalize = vala_ccode_function_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCCodeFunctionCall_private_offset);
	((ValaCCodeNodeClass *) klass)->write = (void (*) (ValaCCodeNode*, ValaCCodeWriter*)) vala_ccode_function_call_real_write;
}

static void
vala_ccode_function_call_instance_init (ValaCCodeFunctionCall * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_ccode_function_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp0_);
	self->priv->arguments = (ValaList*) _tmp1_;
}

static void
vala_ccode_function_call_finalize (ValaCCodeNode * obj)
{
	ValaCCodeFunctionCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
	_vala_ccode_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->arguments);
	VALA_CCODE_NODE_CLASS (vala_ccode_function_call_parent_class)->finalize (obj);
}

/**
 * Represents a function call in the C code.
 */
GType
vala_ccode_function_call_get_type (void)
{
	static volatile gsize vala_ccode_function_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_function_call_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeFunctionCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_function_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeFunctionCall), 0, (GInstanceInitFunc) vala_ccode_function_call_instance_init, NULL };
		GType vala_ccode_function_call_type_id;
		vala_ccode_function_call_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeFunctionCall", &g_define_type_info, 0);
		ValaCCodeFunctionCall_private_offset = g_type_add_instance_private (vala_ccode_function_call_type_id, sizeof (ValaCCodeFunctionCallPrivate));
		g_once_init_leave (&vala_ccode_function_call_type_id__volatile, vala_ccode_function_call_type_id);
	}
	return vala_ccode_function_call_type_id__volatile;
}

