/* valawhilestatement.c generated by valac, the Vala compiler
 * generated from valawhilestatement.vala, do not modify */

/* valawhilestatement.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaWhileStatementPrivate {
	ValaExpression* _condition;
	ValaBlock* _body;
};


static gint ValaWhileStatement_private_offset;
static gpointer vala_while_statement_parent_class = NULL;
static ValaStatementIface * vala_while_statement_vala_statement_parent_iface = NULL;

static void vala_while_statement_real_accept (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_while_statement_real_accept_children (ValaCodeNode* base,
                                                ValaCodeVisitor* visitor);
static gboolean vala_while_statement_always_true (ValaWhileStatement* self,
                                           ValaExpression* condition);
static gboolean vala_while_statement_always_false (ValaWhileStatement* self,
                                            ValaExpression* condition);
static void vala_while_statement_real_replace_expression (ValaCodeNode* base,
                                                   ValaExpression* old_node,
                                                   ValaExpression* new_node);
static gboolean vala_while_statement_real_check (ValaCodeNode* base,
                                          ValaCodeContext* context);
static void vala_while_statement_finalize (ValaCodeNode * obj);


static inline gpointer
vala_while_statement_get_instance_private (ValaWhileStatement* self)
{
	return G_STRUCT_MEMBER_P (self, ValaWhileStatement_private_offset);
}


/**
 * Creates a new while statement.
 *
 * @param condition         loop condition
 * @param body              loop body
 * @param source_reference  reference to source code
 * @return                  newly created while statement
 */
ValaWhileStatement*
vala_while_statement_construct (GType object_type,
                                ValaExpression* condition,
                                ValaBlock* body,
                                ValaSourceReference* source_reference)
{
	ValaWhileStatement* self = NULL;
	g_return_val_if_fail (condition != NULL, NULL);
	g_return_val_if_fail (body != NULL, NULL);
	self = (ValaWhileStatement*) vala_code_node_construct (object_type);
	vala_while_statement_set_body (self, body);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_while_statement_set_condition (self, condition);
	return self;
}


ValaWhileStatement*
vala_while_statement_new (ValaExpression* condition,
                          ValaBlock* body,
                          ValaSourceReference* source_reference)
{
	return vala_while_statement_construct (VALA_TYPE_WHILE_STATEMENT, condition, body, source_reference);
}


static void
vala_while_statement_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaWhileStatement * self;
	self = (ValaWhileStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_while_statement (visitor, self);
}


static void
vala_while_statement_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor)
{
	ValaWhileStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaBlock* _tmp4_;
	ValaBlock* _tmp5_;
	self = (ValaWhileStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_while_statement_get_condition (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_while_statement_get_condition (self);
	_tmp3_ = _tmp2_;
	vala_code_visitor_visit_end_full_expression (visitor, _tmp3_);
	_tmp4_ = vala_while_statement_get_body (self);
	_tmp5_ = _tmp4_;
	vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_while_statement_always_true (ValaWhileStatement* self,
                                  ValaExpression* condition)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaBooleanLiteral* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (condition, VALA_TYPE_BOOLEAN_LITERAL) ? ((ValaBooleanLiteral*) condition) : NULL);
	literal = _tmp0_;
	_tmp2_ = literal;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = literal;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_vala_code_node_unref0 (literal);
	return result;
}


static gboolean
vala_while_statement_always_false (ValaWhileStatement* self,
                                   ValaExpression* condition)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaBooleanLiteral* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (condition, VALA_TYPE_BOOLEAN_LITERAL) ? ((ValaBooleanLiteral*) condition) : NULL);
	literal = _tmp0_;
	_tmp2_ = literal;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = literal;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = !_tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_vala_code_node_unref0 (literal);
	return result;
}


static void
vala_while_statement_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node)
{
	ValaWhileStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaWhileStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_while_statement_get_condition (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_while_statement_set_condition (self, new_node);
	}
}


static gboolean
vala_while_statement_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context)
{
	ValaWhileStatement * self;
	gboolean result = FALSE;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLoop* loop = NULL;
	ValaBlock* _tmp41_;
	ValaBlock* _tmp42_;
	ValaSourceReference* _tmp43_;
	ValaSourceReference* _tmp44_;
	ValaLoop* _tmp45_;
	ValaBlock* parent_block = NULL;
	ValaCodeNode* _tmp46_;
	ValaCodeNode* _tmp47_;
	ValaBlock* _tmp48_;
	self = (ValaWhileStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_while_statement_get_condition (self);
	_tmp1_ = _tmp0_;
	if (vala_while_statement_always_true (self, _tmp1_)) {
	} else {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_while_statement_get_condition (self);
		_tmp3_ = _tmp2_;
		if (vala_while_statement_always_false (self, _tmp3_)) {
			ValaBlock* _tmp4_;
			ValaBlock* _tmp5_;
			ValaExpression* _tmp6_;
			ValaExpression* _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			ValaBreakStatement* _tmp10_;
			ValaBreakStatement* _tmp11_;
			_tmp4_ = vala_while_statement_get_body (self);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_while_statement_get_condition (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_break_statement_new (_tmp9_);
			_tmp11_ = _tmp10_;
			vala_block_insert_statement (_tmp5_, 0, (ValaStatement*) _tmp11_);
			_vala_code_node_unref0 (_tmp11_);
		} else {
			ValaUnaryExpression* if_condition = NULL;
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaExpression* _tmp15_;
			ValaSourceReference* _tmp16_;
			ValaSourceReference* _tmp17_;
			ValaUnaryExpression* _tmp18_;
			ValaBlock* true_block = NULL;
			ValaExpression* _tmp19_;
			ValaExpression* _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaSourceReference* _tmp22_;
			ValaBlock* _tmp23_;
			ValaBlock* _tmp24_;
			ValaExpression* _tmp25_;
			ValaExpression* _tmp26_;
			ValaSourceReference* _tmp27_;
			ValaSourceReference* _tmp28_;
			ValaBreakStatement* _tmp29_;
			ValaBreakStatement* _tmp30_;
			ValaIfStatement* if_stmt = NULL;
			ValaUnaryExpression* _tmp31_;
			ValaBlock* _tmp32_;
			ValaExpression* _tmp33_;
			ValaExpression* _tmp34_;
			ValaSourceReference* _tmp35_;
			ValaSourceReference* _tmp36_;
			ValaIfStatement* _tmp37_;
			ValaBlock* _tmp38_;
			ValaBlock* _tmp39_;
			ValaIfStatement* _tmp40_;
			_tmp12_ = vala_while_statement_get_condition (self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_while_statement_get_condition (self);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_LOGICAL_NEGATION, _tmp13_, _tmp17_);
			if_condition = _tmp18_;
			_tmp19_ = vala_while_statement_get_condition (self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_block_new (_tmp22_);
			true_block = _tmp23_;
			_tmp24_ = true_block;
			_tmp25_ = vala_while_statement_get_condition (self);
			_tmp26_ = _tmp25_;
			_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = vala_break_statement_new (_tmp28_);
			_tmp30_ = _tmp29_;
			vala_block_add_statement (_tmp24_, (ValaStatement*) _tmp30_);
			_vala_code_node_unref0 (_tmp30_);
			_tmp31_ = if_condition;
			_tmp32_ = true_block;
			_tmp33_ = vala_while_statement_get_condition (self);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_if_statement_new ((ValaExpression*) _tmp31_, _tmp32_, NULL, _tmp36_);
			if_stmt = _tmp37_;
			_tmp38_ = vala_while_statement_get_body (self);
			_tmp39_ = _tmp38_;
			_tmp40_ = if_stmt;
			vala_block_insert_statement (_tmp39_, 0, (ValaStatement*) _tmp40_);
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (if_condition);
		}
	}
	_tmp41_ = vala_while_statement_get_body (self);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp44_ = _tmp43_;
	_tmp45_ = vala_loop_new (_tmp42_, _tmp44_);
	loop = _tmp45_;
	_tmp46_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp47_ = _tmp46_;
	_tmp48_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_BLOCK, ValaBlock));
	parent_block = _tmp48_;
	vala_block_replace_statement (parent_block, (ValaStatement*) self, (ValaStatement*) loop);
	result = vala_code_node_check ((ValaCodeNode*) loop, context);
	_vala_code_node_unref0 (parent_block);
	_vala_code_node_unref0 (loop);
	return result;
}


ValaExpression*
vala_while_statement_get_condition (ValaWhileStatement* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_condition;
	result = _tmp0_;
	return result;
}


void
vala_while_statement_set_condition (ValaWhileStatement* self,
                                    ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_condition);
	self->priv->_condition = _tmp0_;
	_tmp1_ = self->priv->_condition;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaBlock*
vala_while_statement_get_body (ValaWhileStatement* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}


void
vala_while_statement_set_body (ValaWhileStatement* self,
                               ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp0_;
	_tmp1_ = self->priv->_body;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static void
vala_while_statement_class_init (ValaWhileStatementClass * klass)
{
	vala_while_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_while_statement_finalize;
	g_type_class_adjust_private_offset (klass, &ValaWhileStatement_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_while_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_while_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_while_statement_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_while_statement_real_check;
}


static void
vala_while_statement_vala_statement_interface_init (ValaStatementIface * iface)
{
	vala_while_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void
vala_while_statement_instance_init (ValaWhileStatement * self)
{
	self->priv = vala_while_statement_get_instance_private (self);
}


static void
vala_while_statement_finalize (ValaCodeNode * obj)
{
	ValaWhileStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_WHILE_STATEMENT, ValaWhileStatement);
	_vala_code_node_unref0 (self->priv->_condition);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_while_statement_parent_class)->finalize (obj);
}


/**
 * Represents a while iteration statement in the source code.
 */
GType
vala_while_statement_get_type (void)
{
	static volatile gsize vala_while_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_while_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaWhileStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_while_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaWhileStatement), 0, (GInstanceInitFunc) vala_while_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_while_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_while_statement_type_id;
		vala_while_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaWhileStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_while_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		ValaWhileStatement_private_offset = g_type_add_instance_private (vala_while_statement_type_id, sizeof (ValaWhileStatementPrivate));
		g_once_init_leave (&vala_while_statement_type_id__volatile, vala_while_statement_type_id);
	}
	return vala_while_statement_type_id__volatile;
}



