/* valaparser.c generated by valac, the Vala compiler
 * generated from valaparser.vala, do not modify */

/* valaparser.vala
 *
 * Copyright (C) 2006-2013  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>


#define VALA_PARSER_TYPE_TOKEN_INFO (vala_parser_token_info_get_type ())
typedef struct _ValaParserTokenInfo ValaParserTokenInfo;

#define VALA_PARSER_TYPE_MODIFIER_FLAGS (vala_parser_modifier_flags_get_type ())

#define VALA_PARSER_TYPE_RECOVERY_STATE (vala_parser_recovery_state_get_type ())
#define _vala_scanner_unref0(var) ((var == NULL) ? NULL : (var = (vala_scanner_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaParserTokenInfo {
	ValaTokenType type;
	ValaSourceLocation begin;
	ValaSourceLocation end;
};

struct _ValaParserPrivate {
	ValaScanner* scanner;
	ValaCodeContext* context;
	ValaParserTokenInfo* tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gint index;
	gint size;
	ValaComment* comment;
};

typedef enum  {
	VALA_PARSER_MODIFIER_FLAGS_NONE,
	VALA_PARSER_MODIFIER_FLAGS_ABSTRACT = 1 << 0,
	VALA_PARSER_MODIFIER_FLAGS_CLASS = 1 << 1,
	VALA_PARSER_MODIFIER_FLAGS_EXTERN = 1 << 2,
	VALA_PARSER_MODIFIER_FLAGS_INLINE = 1 << 3,
	VALA_PARSER_MODIFIER_FLAGS_NEW = 1 << 4,
	VALA_PARSER_MODIFIER_FLAGS_OVERRIDE = 1 << 5,
	VALA_PARSER_MODIFIER_FLAGS_STATIC = 1 << 6,
	VALA_PARSER_MODIFIER_FLAGS_VIRTUAL = 1 << 7,
	VALA_PARSER_MODIFIER_FLAGS_ASYNC = 1 << 8,
	VALA_PARSER_MODIFIER_FLAGS_SEALED = 1 << 9
} ValaParserModifierFlags;

typedef enum  {
	VALA_PARSER_RECOVERY_STATE_EOF,
	VALA_PARSER_RECOVERY_STATE_DECLARATION_BEGIN,
	VALA_PARSER_RECOVERY_STATE_STATEMENT_BEGIN
} ValaParserRecoveryState;


static gpointer vala_parser_parent_class = NULL;
static ValaList* vala_parser__empty_type_parameter_list;
static ValaList* vala_parser__empty_type_parameter_list = NULL;

static GType vala_parser_token_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaParserTokenInfo* vala_parser_token_info_dup (const ValaParserTokenInfo* self);
static void vala_parser_token_info_free (ValaParserTokenInfo* self);
#define VALA_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_PARSER, ValaParserPrivate))
static GType vala_parser_modifier_flags_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType vala_parser_recovery_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_PARSER_BUFFER_SIZE 32
static void vala_parser_real_visit_source_file (ValaCodeVisitor* base,
                                         ValaSourceFile* source_file);
static inline gboolean vala_parser_next (ValaParser* self);
static inline void vala_parser_prev (ValaParser* self);
static inline ValaTokenType vala_parser_current (ValaParser* self);
static inline gboolean vala_parser_accept (ValaParser* self,
                             ValaTokenType type);
static void vala_parser_report_parse_error (ValaParser* self,
                                     GError* e);
static inline void vala_parser_get_location (ValaParser* self,
                               ValaSourceLocation* result);
static ValaSourceReference* vala_parser_get_src (ValaParser* self,
                                          ValaSourceLocation* begin);
static inline gboolean vala_parser_expect (ValaParser* self,
                             ValaTokenType type,
                             GError** error);
static gchar* vala_parser_get_current_string (ValaParser* self);
static gchar* vala_parser_get_last_string (ValaParser* self);
static ValaSourceReference* vala_parser_get_current_src (ValaParser* self);
static ValaSourceReference* vala_parser_get_last_src (ValaParser* self);
static void vala_parser_rollback (ValaParser* self,
                           ValaSourceLocation* location);
static void vala_parser_skip_identifier (ValaParser* self,
                                  GError** error);
static gchar* vala_parser_parse_identifier (ValaParser* self,
                                     GError** error);
static ValaExpression* vala_parser_parse_literal (ValaParser* self,
                                           GError** error);
static void vala_parser_parse_file_comments (ValaParser* self);
static void vala_parser_parse_using_directives (ValaParser* self,
                                         ValaNamespace* ns,
                                         GError** error);
static void vala_parser_parse_declarations (ValaParser* self,
                                     ValaSymbol* parent,
                                     gboolean root,
                                     GError** error);
static void vala_parser_skip_symbol_name (ValaParser* self,
                                   GError** error);
static ValaUnresolvedSymbol* vala_parser_parse_symbol_name (ValaParser* self,
                                                     GError** error);
static void vala_parser_skip_type (ValaParser* self,
                            GError** error);
static gboolean vala_parser_is_inner_array_type (ValaParser* self);
static void vala_parser_skip_type_argument_list (ValaParser* self,
                                          GError** error);
static ValaExpression* vala_parser_parse_expression (ValaParser* self,
                                              GError** error);
static ValaDataType* vala_parser_parse_type (ValaParser* self,
                                      gboolean owned_by_default,
                                      gboolean can_weak_ref,
                                      gboolean require_unowned,
                                      GError** error);
static ValaList* vala_parser_parse_type_argument_list (ValaParser* self,
                                                gboolean maybe_expression,
                                                GError** error);
static ValaDataType* vala_parser_parse_inline_array_type (ValaParser* self,
                                                   ValaDataType* type,
                                                   GError** error);
static ValaList* vala_parser_parse_argument_list (ValaParser* self,
                                           GError** error);
static ValaExpression* vala_parser_parse_argument (ValaParser* self,
                                            GError** error);
static ValaExpression* vala_parser_parse_primary_expression (ValaParser* self,
                                                      GError** error);
static ValaInitializerList* vala_parser_parse_initializer (ValaParser* self,
                                                    GError** error);
static ValaExpression* vala_parser_parse_simple_name (ValaParser* self,
                                               GError** error);
static ValaExpression* vala_parser_parse_tuple (ValaParser* self,
                                         GError** error);
static ValaExpression* vala_parser_parse_template (ValaParser* self,
                                            GError** error);
static ValaExpression* vala_parser_parse_regex_literal (ValaParser* self,
                                                 GError** error);
static ValaExpression* vala_parser_parse_this_access (ValaParser* self,
                                               GError** error);
static ValaExpression* vala_parser_parse_base_access (ValaParser* self,
                                               GError** error);
static ValaExpression* vala_parser_parse_object_or_array_creation_expression (ValaParser* self,
                                                                       GError** error);
static ValaExpression* vala_parser_parse_yield_expression (ValaParser* self,
                                                    GError** error);
static ValaExpression* vala_parser_parse_sizeof_expression (ValaParser* self,
                                                     GError** error);
static ValaExpression* vala_parser_parse_typeof_expression (ValaParser* self,
                                                     GError** error);
static ValaExpression* vala_parser_parse_member_access (ValaParser* self,
                                                 ValaSourceLocation* begin,
                                                 ValaExpression* inner,
                                                 GError** error);
static ValaExpression* vala_parser_parse_pointer_member_access (ValaParser* self,
                                                         ValaSourceLocation* begin,
                                                         ValaExpression* inner,
                                                         GError** error);
static ValaExpression* vala_parser_parse_method_call (ValaParser* self,
                                               ValaSourceLocation* begin,
                                               ValaExpression* inner,
                                               GError** error);
static ValaExpression* vala_parser_parse_element_access (ValaParser* self,
                                                  ValaSourceLocation* begin,
                                                  ValaExpression* inner,
                                                  GError** error);
static ValaExpression* vala_parser_parse_post_increment_expression (ValaParser* self,
                                                             ValaSourceLocation* begin,
                                                             ValaExpression* inner,
                                                             GError** error);
static ValaExpression* vala_parser_parse_post_decrement_expression (ValaParser* self,
                                                             ValaSourceLocation* begin,
                                                             ValaExpression* inner,
                                                             GError** error);
static ValaList* vala_parser_parse_object_initializer (ValaParser* self,
                                                GError** error);
static ValaList* vala_parser_parse_expression_list (ValaParser* self,
                                             GError** error);
static ValaExpression* vala_parser_parse_array_creation_expression (ValaParser* self,
                                                             GError** error);
static ValaMemberAccess* vala_parser_parse_member_name (ValaParser* self,
                                                 ValaExpression* base_expr,
                                                 GError** error);
static ValaExpression* vala_parser_parse_object_creation_expression (ValaParser* self,
                                                              ValaSourceLocation* begin,
                                                              ValaMemberAccess* member,
                                                              GError** error);
static ValaMemberInitializer* vala_parser_parse_member_initializer (ValaParser* self,
                                                             GError** error);
static ValaUnaryOperator vala_parser_get_unary_operator (ValaParser* self,
                                                  ValaTokenType token_type);
static ValaExpression* vala_parser_parse_unary_expression (ValaParser* self,
                                                    GError** error);
static ValaBinaryOperator vala_parser_get_binary_operator (ValaParser* self,
                                                    ValaTokenType token_type);
static ValaExpression* vala_parser_parse_multiplicative_expression (ValaParser* self,
                                                             GError** error);
static ValaExpression* vala_parser_parse_additive_expression (ValaParser* self,
                                                       GError** error);
static ValaExpression* vala_parser_parse_shift_expression (ValaParser* self,
                                                    GError** error);
static ValaExpression* vala_parser_parse_relational_expression (ValaParser* self,
                                                         GError** error);
static ValaExpression* vala_parser_parse_equality_expression (ValaParser* self,
                                                       GError** error);
static ValaExpression* vala_parser_parse_and_expression (ValaParser* self,
                                                  GError** error);
static ValaExpression* vala_parser_parse_exclusive_or_expression (ValaParser* self,
                                                           GError** error);
static ValaExpression* vala_parser_parse_inclusive_or_expression (ValaParser* self,
                                                           GError** error);
static ValaExpression* vala_parser_parse_in_expression (ValaParser* self,
                                                 GError** error);
static ValaExpression* vala_parser_parse_conditional_and_expression (ValaParser* self,
                                                              GError** error);
static ValaExpression* vala_parser_parse_conditional_or_expression (ValaParser* self,
                                                             GError** error);
static ValaExpression* vala_parser_parse_coalescing_expression (ValaParser* self,
                                                         GError** error);
static ValaExpression* vala_parser_parse_conditional_expression (ValaParser* self,
                                                          GError** error);
static ValaParameter* vala_parser_parse_lambda_parameter (ValaParser* self,
                                                   GError** error);
static ValaExpression* vala_parser_parse_lambda_expression (ValaParser* self,
                                                     GError** error);
static ValaBlock* vala_parser_parse_block (ValaParser* self,
                                    GError** error);
static ValaAssignmentOperator vala_parser_get_assignment_operator (ValaParser* self,
                                                            ValaTokenType token_type);
static gboolean vala_parser_is_lambda_expression (ValaParser* self);
static void vala_parser_parse_statements (ValaParser* self,
                                   ValaBlock* block,
                                   GError** error);
static ValaStatement* vala_parser_parse_empty_statement (ValaParser* self,
                                                  GError** error);
static ValaStatement* vala_parser_parse_if_statement (ValaParser* self,
                                               GError** error);
static ValaStatement* vala_parser_parse_switch_statement (ValaParser* self,
                                                   GError** error);
static ValaStatement* vala_parser_parse_while_statement (ValaParser* self,
                                                  GError** error);
static ValaStatement* vala_parser_parse_do_statement (ValaParser* self,
                                               GError** error);
static ValaStatement* vala_parser_parse_for_statement (ValaParser* self,
                                                GError** error);
static ValaStatement* vala_parser_parse_foreach_statement (ValaParser* self,
                                                    GError** error);
static ValaStatement* vala_parser_parse_break_statement (ValaParser* self,
                                                  GError** error);
static ValaStatement* vala_parser_parse_continue_statement (ValaParser* self,
                                                     GError** error);
static ValaStatement* vala_parser_parse_return_statement (ValaParser* self,
                                                   GError** error);
static ValaStatement* vala_parser_parse_yield_statement (ValaParser* self,
                                                  GError** error);
static ValaStatement* vala_parser_parse_throw_statement (ValaParser* self,
                                                  GError** error);
static ValaStatement* vala_parser_parse_try_statement (ValaParser* self,
                                                GError** error);
static ValaStatement* vala_parser_parse_lock_statement (ValaParser* self,
                                                 GError** error);
static ValaStatement* vala_parser_parse_delete_statement (ValaParser* self,
                                                   GError** error);
static void vala_parser_parse_local_variable_declarations (ValaParser* self,
                                                    ValaBlock* block,
                                                    GError** error);
static void vala_parser_parse_local_constant_declarations (ValaParser* self,
                                                    ValaBlock* block,
                                                    GError** error);
static ValaStatement* vala_parser_parse_expression_statement (ValaParser* self,
                                                       GError** error);
static gboolean vala_parser_is_expression (ValaParser* self,
                                    GError** error);
static ValaParserRecoveryState vala_parser_recover (ValaParser* self);
static ValaBlock* vala_parser_parse_embedded_statement (ValaParser* self,
                                                 const gchar* statement_name,
                                                 gboolean accept_empty_body,
                                                 GError** error);
static ValaStatement* vala_parser_parse_embedded_statement_without_block (ValaParser* self,
                                                                   const gchar* statement_name,
                                                                   gboolean accept_empty_body,
                                                                   GError** error);
static void _vala_array_add12 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static ValaLocalVariable* vala_parser_parse_local_variable (ValaParser* self,
                                                     ValaDataType* variable_type,
                                                     GError** error);
static ValaConstant* vala_parser_parse_local_constant (ValaParser* self,
                                                ValaDataType* constant_type,
                                                GError** error);
static ValaExpression* vala_parser_parse_statement_expression (ValaParser* self,
                                                        GError** error);
static void vala_parser_parse_catch_clauses (ValaParser* self,
                                      ValaList* catch_clauses,
                                      GError** error);
static ValaBlock* vala_parser_parse_finally_clause (ValaParser* self,
                                             GError** error);
static gchar* vala_parser_parse_attribute_value (ValaParser* self,
                                          GError** error);
static ValaList* vala_parser_parse_attributes (ValaParser* self,
                                        GError** error);
static void vala_parser_set_attributes (ValaParser* self,
                                 ValaCodeNode* node,
                                 ValaList* attributes);
static void vala_parser_parse_main_block (ValaParser* self,
                                   ValaSymbol* parent,
                                   GError** error);
static void vala_parser_parse_declaration (ValaParser* self,
                                    ValaSymbol* parent,
                                    gboolean root,
                                    GError** error);
static gboolean vala_parser_is_declaration_keyword (ValaParser* self,
                                             ValaTokenType type);
static void vala_parser_parse_constructor_declaration (ValaParser* self,
                                                ValaSymbol* parent,
                                                ValaList* attrs,
                                                GError** error);
static void vala_parser_parse_destructor_declaration (ValaParser* self,
                                               ValaSymbol* parent,
                                               ValaList* attrs,
                                               GError** error);
static void vala_parser_parse_class_declaration (ValaParser* self,
                                          ValaSymbol* parent,
                                          ValaList* attrs,
                                          GError** error);
static void vala_parser_parse_enum_declaration (ValaParser* self,
                                         ValaSymbol* parent,
                                         ValaList* attrs,
                                         GError** error);
static void vala_parser_parse_errordomain_declaration (ValaParser* self,
                                                ValaSymbol* parent,
                                                ValaList* attrs,
                                                GError** error);
static void vala_parser_parse_interface_declaration (ValaParser* self,
                                              ValaSymbol* parent,
                                              ValaList* attrs,
                                              GError** error);
static void vala_parser_parse_namespace_declaration (ValaParser* self,
                                              ValaSymbol* parent,
                                              ValaList* attrs,
                                              GError** error);
static void vala_parser_parse_struct_declaration (ValaParser* self,
                                           ValaSymbol* parent,
                                           ValaList* attrs,
                                           GError** error);
static void vala_parser_parse_creation_method_declaration (ValaParser* self,
                                                    ValaSymbol* parent,
                                                    ValaList* attrs,
                                                    GError** error);
static void vala_parser_parse_delegate_declaration (ValaParser* self,
                                             ValaSymbol* parent,
                                             ValaList* attrs,
                                             GError** error);
static void vala_parser_parse_signal_declaration (ValaParser* self,
                                           ValaSymbol* parent,
                                           ValaList* attrs,
                                           GError** error);
static void vala_parser_parse_method_declaration (ValaParser* self,
                                           ValaSymbol* parent,
                                           ValaList* attrs,
                                           GError** error);
static void vala_parser_parse_constant_declaration (ValaParser* self,
                                             ValaSymbol* parent,
                                             ValaList* attrs,
                                             GError** error);
static void vala_parser_parse_field_declaration (ValaParser* self,
                                          ValaSymbol* parent,
                                          ValaList* attrs,
                                          GError** error);
static void vala_parser_parse_property_declaration (ValaParser* self,
                                             ValaSymbol* parent,
                                             ValaList* attrs,
                                             GError** error);
static ValaSymbolAccessibility vala_parser_parse_access_modifier (ValaParser* self,
                                                           ValaSymbolAccessibility default_access);
static ValaParserModifierFlags vala_parser_parse_type_declaration_modifiers (ValaParser* self);
static ValaList* vala_parser_parse_type_parameter_list (ValaParser* self,
                                                 GError** error);
static ValaParserModifierFlags vala_parser_parse_member_declaration_modifiers (ValaParser* self);
static ValaParameter* vala_parser_parse_parameter (ValaParser* self,
                                            GError** error);
static void vala_parser_finalize (ValaCodeVisitor * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static GType
vala_parser_modifier_flags_get_type (void)
{
	static volatile gsize vala_parser_modifier_flags_type_id__volatile = 0;
	if (g_once_init_enter (&vala_parser_modifier_flags_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_PARSER_MODIFIER_FLAGS_NONE, "VALA_PARSER_MODIFIER_FLAGS_NONE", "none"}, {VALA_PARSER_MODIFIER_FLAGS_ABSTRACT, "VALA_PARSER_MODIFIER_FLAGS_ABSTRACT", "abstract"}, {VALA_PARSER_MODIFIER_FLAGS_CLASS, "VALA_PARSER_MODIFIER_FLAGS_CLASS", "class"}, {VALA_PARSER_MODIFIER_FLAGS_EXTERN, "VALA_PARSER_MODIFIER_FLAGS_EXTERN", "extern"}, {VALA_PARSER_MODIFIER_FLAGS_INLINE, "VALA_PARSER_MODIFIER_FLAGS_INLINE", "inline"}, {VALA_PARSER_MODIFIER_FLAGS_NEW, "VALA_PARSER_MODIFIER_FLAGS_NEW", "new"}, {VALA_PARSER_MODIFIER_FLAGS_OVERRIDE, "VALA_PARSER_MODIFIER_FLAGS_OVERRIDE", "override"}, {VALA_PARSER_MODIFIER_FLAGS_STATIC, "VALA_PARSER_MODIFIER_FLAGS_STATIC", "static"}, {VALA_PARSER_MODIFIER_FLAGS_VIRTUAL, "VALA_PARSER_MODIFIER_FLAGS_VIRTUAL", "virtual"}, {VALA_PARSER_MODIFIER_FLAGS_ASYNC, "VALA_PARSER_MODIFIER_FLAGS_ASYNC", "async"}, {VALA_PARSER_MODIFIER_FLAGS_SEALED, "VALA_PARSER_MODIFIER_FLAGS_SEALED", "sealed"}, {0, NULL, NULL}};
		GType vala_parser_modifier_flags_type_id;
		vala_parser_modifier_flags_type_id = g_enum_register_static ("ValaParserModifierFlags", values);
		g_once_init_leave (&vala_parser_modifier_flags_type_id__volatile, vala_parser_modifier_flags_type_id);
	}
	return vala_parser_modifier_flags_type_id__volatile;
}


static GType
vala_parser_recovery_state_get_type (void)
{
	static volatile gsize vala_parser_recovery_state_type_id__volatile = 0;
	if (g_once_init_enter (&vala_parser_recovery_state_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_PARSER_RECOVERY_STATE_EOF, "VALA_PARSER_RECOVERY_STATE_EOF", "eof"}, {VALA_PARSER_RECOVERY_STATE_DECLARATION_BEGIN, "VALA_PARSER_RECOVERY_STATE_DECLARATION_BEGIN", "declaration-begin"}, {VALA_PARSER_RECOVERY_STATE_STATEMENT_BEGIN, "VALA_PARSER_RECOVERY_STATE_STATEMENT_BEGIN", "statement-begin"}, {0, NULL, NULL}};
		GType vala_parser_recovery_state_type_id;
		vala_parser_recovery_state_type_id = g_enum_register_static ("ValaParserRecoveryState", values);
		g_once_init_leave (&vala_parser_recovery_state_type_id__volatile, vala_parser_recovery_state_type_id);
	}
	return vala_parser_recovery_state_type_id__volatile;
}


ValaParser*
vala_parser_construct (GType object_type)
{
	ValaParser* self = NULL;
	ValaParserTokenInfo* _tmp0_;
	self = (ValaParser*) vala_code_visitor_construct (object_type);
	_tmp0_ = g_new0 (ValaParserTokenInfo, VALA_PARSER_BUFFER_SIZE);
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
	self->priv->tokens = _tmp0_;
	self->priv->tokens_length1 = VALA_PARSER_BUFFER_SIZE;
	self->priv->_tokens_size_ = self->priv->tokens_length1;
	return self;
}


ValaParser*
vala_parser_new (void)
{
	return vala_parser_construct (VALA_TYPE_PARSER);
}


/**
 * Parses all .vala and .vapi source files in the specified code
 * context and builds a code tree.
 *
 * @param context a code context
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}


void
vala_parser_parse (ValaParser* self,
                   ValaCodeContext* context)
{
	ValaCodeContext* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = NULL;
}


static void
vala_parser_real_visit_source_file (ValaCodeVisitor* base,
                                    ValaSourceFile* source_file)
{
	ValaParser * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ValaCodeContext* _tmp3_;
	self = (ValaParser*) base;
	g_return_if_fail (source_file != NULL);
	_tmp3_ = self->priv->context;
	if (_tmp3_ != NULL) {
		ValaCodeContext* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->context;
		_tmp5_ = vala_code_context_get_run_output (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = vala_source_file_get_filename (source_file);
		_tmp8_ = _tmp7_;
		_tmp1_ = g_str_has_suffix (_tmp8_, ".vala");
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = vala_source_file_get_filename (source_file);
		_tmp10_ = _tmp9_;
		_tmp0_ = g_str_has_suffix (_tmp10_, ".vapi");
	}
	if (_tmp0_) {
		vala_parser_parse_file (self, source_file);
	}
}


static inline gboolean
vala_parser_next (ValaParser* self)
{
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ValaParserTokenInfo* _tmp14_;
	gint _tmp14__length1;
	gint _tmp15_;
	ValaParserTokenInfo _tmp16_;
	ValaTokenType _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->index;
	self->priv->index = (_tmp0_ + 1) % VALA_PARSER_BUFFER_SIZE;
	_tmp1_ = self->priv->size;
	self->priv->size = _tmp1_ - 1;
	_tmp2_ = self->priv->size;
	if (_tmp2_ <= 0) {
		ValaSourceLocation begin = {0};
		ValaSourceLocation end = {0};
		ValaTokenType type = 0;
		ValaScanner* _tmp3_;
		ValaSourceLocation _tmp4_ = {0};
		ValaSourceLocation _tmp5_ = {0};
		ValaTokenType _tmp6_;
		ValaParserTokenInfo* _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_;
		ValaTokenType _tmp9_;
		ValaSourceLocation _tmp10_;
		ValaSourceLocation _tmp11_;
		ValaParserTokenInfo _tmp12_ = {0};
		ValaParserTokenInfo _tmp13_;
		_tmp3_ = self->priv->scanner;
		_tmp6_ = vala_scanner_read_token (_tmp3_, &_tmp4_, &_tmp5_);
		begin = _tmp4_;
		end = _tmp5_;
		type = _tmp6_;
		_tmp7_ = self->priv->tokens;
		_tmp7__length1 = self->priv->tokens_length1;
		_tmp8_ = self->priv->index;
		_tmp9_ = type;
		_tmp10_ = begin;
		_tmp11_ = end;
		_tmp12_.type = _tmp9_;
		_tmp12_.begin = _tmp10_;
		_tmp12_.end = _tmp11_;
		_tmp7_[_tmp8_] = _tmp12_;
		_tmp13_ = _tmp7_[_tmp8_];
		self->priv->size = 1;
	}
	_tmp14_ = self->priv->tokens;
	_tmp14__length1 = self->priv->tokens_length1;
	_tmp15_ = self->priv->index;
	_tmp16_ = _tmp14_[_tmp15_];
	_tmp17_ = _tmp16_.type;
	result = _tmp17_ != VALA_TOKEN_TYPE_EOF;
	return result;
}


static inline void
vala_parser_prev (ValaParser* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->index;
	self->priv->index = ((_tmp0_ - 1) + VALA_PARSER_BUFFER_SIZE) % VALA_PARSER_BUFFER_SIZE;
	_tmp1_ = self->priv->size;
	self->priv->size = _tmp1_ + 1;
	_tmp2_ = self->priv->size;
	_vala_assert (_tmp2_ <= VALA_PARSER_BUFFER_SIZE, "size <= BUFFER_SIZE");
}


static inline ValaTokenType
vala_parser_current (ValaParser* self)
{
	ValaTokenType result = 0;
	ValaParserTokenInfo* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	ValaParserTokenInfo _tmp2_;
	ValaTokenType _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->tokens;
	_tmp0__length1 = self->priv->tokens_length1;
	_tmp1_ = self->priv->index;
	_tmp2_ = _tmp0_[_tmp1_];
	_tmp3_ = _tmp2_.type;
	result = _tmp3_;
	return result;
}


static inline gboolean
vala_parser_accept (ValaParser* self,
                    ValaTokenType type)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_parser_current (self) == type) {
		vala_parser_next (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void
vala_parser_report_parse_error (ValaParser* self,
                                GError* e)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_next (self);
	_tmp1_ = begin;
	_tmp2_ = vala_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = e->message;
	_tmp5_ = g_strconcat ("syntax error, ", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	vala_report_error (_tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	_vala_source_reference_unref0 (_tmp3_);
}


static inline gboolean
vala_parser_expect (ValaParser* self,
                    ValaTokenType type,
                    GError** error)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GError* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_parser_accept (self, type)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = vala_token_type_to_string (type);
	_tmp1_ = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected %s", _tmp0_);
	_inner_error_ = _tmp1_;
	if (_inner_error_->domain == VALA_PARSE_ERROR) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error_);
		return _tmp2_;
	} else {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp3_;
	}
}


static inline void
vala_parser_get_location (ValaParser* self,
                          ValaSourceLocation* result)
{
	ValaParserTokenInfo* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	ValaParserTokenInfo _tmp2_;
	ValaSourceLocation _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tokens;
	_tmp0__length1 = self->priv->tokens_length1;
	_tmp1_ = self->priv->index;
	_tmp2_ = _tmp0_[_tmp1_];
	_tmp3_ = _tmp2_.begin;
	*result = _tmp3_;
	return;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
vala_parser_get_current_string (ValaParser* self)
{
	gchar* result = NULL;
	ValaParserTokenInfo token = {0};
	ValaParserTokenInfo* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	ValaParserTokenInfo _tmp2_;
	ValaParserTokenInfo _tmp3_;
	ValaSourceLocation _tmp4_;
	gchar* _tmp5_;
	ValaParserTokenInfo _tmp6_;
	ValaSourceLocation _tmp7_;
	gchar* _tmp8_;
	ValaParserTokenInfo _tmp9_;
	ValaSourceLocation _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tokens;
	_tmp0__length1 = self->priv->tokens_length1;
	_tmp1_ = self->priv->index;
	_tmp2_ = _tmp0_[_tmp1_];
	token = _tmp2_;
	_tmp3_ = token;
	_tmp4_ = _tmp3_.begin;
	_tmp5_ = _tmp4_.pos;
	_tmp6_ = token;
	_tmp7_ = _tmp6_.end;
	_tmp8_ = _tmp7_.pos;
	_tmp9_ = token;
	_tmp10_ = _tmp9_.begin;
	_tmp11_ = _tmp10_.pos;
	_tmp12_ = string_substring ((const gchar*) _tmp5_, (glong) 0, (glong) ((gint) (_tmp8_ - _tmp11_)));
	result = _tmp12_;
	return result;
}


static gchar*
vala_parser_get_last_string (ValaParser* self)
{
	gchar* result = NULL;
	gint last_index = 0;
	gint _tmp0_;
	ValaParserTokenInfo token = {0};
	ValaParserTokenInfo* _tmp1_;
	gint _tmp1__length1;
	ValaParserTokenInfo _tmp2_;
	ValaParserTokenInfo _tmp3_;
	ValaSourceLocation _tmp4_;
	gchar* _tmp5_;
	ValaParserTokenInfo _tmp6_;
	ValaSourceLocation _tmp7_;
	gchar* _tmp8_;
	ValaParserTokenInfo _tmp9_;
	ValaSourceLocation _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->index;
	last_index = ((_tmp0_ + VALA_PARSER_BUFFER_SIZE) - 1) % VALA_PARSER_BUFFER_SIZE;
	_tmp1_ = self->priv->tokens;
	_tmp1__length1 = self->priv->tokens_length1;
	_tmp2_ = _tmp1_[last_index];
	token = _tmp2_;
	_tmp3_ = token;
	_tmp4_ = _tmp3_.begin;
	_tmp5_ = _tmp4_.pos;
	_tmp6_ = token;
	_tmp7_ = _tmp6_.end;
	_tmp8_ = _tmp7_.pos;
	_tmp9_ = token;
	_tmp10_ = _tmp9_.begin;
	_tmp11_ = _tmp10_.pos;
	_tmp12_ = string_substring ((const gchar*) _tmp5_, (glong) 0, (glong) ((gint) (_tmp8_ - _tmp11_)));
	result = _tmp12_;
	return result;
}


static ValaSourceReference*
vala_parser_get_src (ValaParser* self,
                     ValaSourceLocation* begin)
{
	ValaSourceReference* result = NULL;
	gint last_index = 0;
	gint _tmp0_;
	ValaScanner* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceFile* _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaParserTokenInfo* _tmp5_;
	gint _tmp5__length1;
	ValaParserTokenInfo _tmp6_;
	ValaSourceLocation _tmp7_;
	ValaSourceReference* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	_tmp0_ = self->priv->index;
	last_index = ((_tmp0_ + VALA_PARSER_BUFFER_SIZE) - 1) % VALA_PARSER_BUFFER_SIZE;
	_tmp1_ = self->priv->scanner;
	_tmp2_ = vala_scanner_get_source_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = *begin;
	_tmp5_ = self->priv->tokens;
	_tmp5__length1 = self->priv->tokens_length1;
	_tmp6_ = _tmp5_[last_index];
	_tmp7_ = _tmp6_.end;
	_tmp8_ = vala_source_reference_new (_tmp3_, &_tmp4_, &_tmp7_);
	result = _tmp8_;
	return result;
}


static ValaSourceReference*
vala_parser_get_current_src (ValaParser* self)
{
	ValaSourceReference* result = NULL;
	ValaParserTokenInfo token = {0};
	ValaParserTokenInfo* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	ValaParserTokenInfo _tmp2_;
	ValaScanner* _tmp3_;
	ValaSourceFile* _tmp4_;
	ValaSourceFile* _tmp5_;
	ValaParserTokenInfo _tmp6_;
	ValaSourceLocation _tmp7_;
	ValaParserTokenInfo _tmp8_;
	ValaSourceLocation _tmp9_;
	ValaSourceReference* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tokens;
	_tmp0__length1 = self->priv->tokens_length1;
	_tmp1_ = self->priv->index;
	_tmp2_ = _tmp0_[_tmp1_];
	token = _tmp2_;
	_tmp3_ = self->priv->scanner;
	_tmp4_ = vala_scanner_get_source_file (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = token;
	_tmp7_ = _tmp6_.begin;
	_tmp8_ = token;
	_tmp9_ = _tmp8_.end;
	_tmp10_ = vala_source_reference_new (_tmp5_, &_tmp7_, &_tmp9_);
	result = _tmp10_;
	return result;
}


static ValaSourceReference*
vala_parser_get_last_src (ValaParser* self)
{
	ValaSourceReference* result = NULL;
	gint last_index = 0;
	gint _tmp0_;
	ValaParserTokenInfo token = {0};
	ValaParserTokenInfo* _tmp1_;
	gint _tmp1__length1;
	ValaParserTokenInfo _tmp2_;
	ValaScanner* _tmp3_;
	ValaSourceFile* _tmp4_;
	ValaSourceFile* _tmp5_;
	ValaParserTokenInfo _tmp6_;
	ValaSourceLocation _tmp7_;
	ValaParserTokenInfo _tmp8_;
	ValaSourceLocation _tmp9_;
	ValaSourceReference* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->index;
	last_index = ((_tmp0_ + VALA_PARSER_BUFFER_SIZE) - 1) % VALA_PARSER_BUFFER_SIZE;
	_tmp1_ = self->priv->tokens;
	_tmp1__length1 = self->priv->tokens_length1;
	_tmp2_ = _tmp1_[last_index];
	token = _tmp2_;
	_tmp3_ = self->priv->scanner;
	_tmp4_ = vala_scanner_get_source_file (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = token;
	_tmp7_ = _tmp6_.begin;
	_tmp8_ = token;
	_tmp9_ = _tmp8_.end;
	_tmp10_ = vala_source_reference_new (_tmp5_, &_tmp7_, &_tmp9_);
	result = _tmp10_;
	return result;
}


static void
vala_parser_rollback (ValaParser* self,
                      ValaSourceLocation* location)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	while (TRUE) {
		ValaParserTokenInfo* _tmp0_;
		gint _tmp0__length1;
		gint _tmp1_;
		ValaParserTokenInfo _tmp2_;
		ValaSourceLocation _tmp3_;
		gchar* _tmp4_;
		ValaSourceLocation _tmp5_;
		gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp0_ = self->priv->tokens;
		_tmp0__length1 = self->priv->tokens_length1;
		_tmp1_ = self->priv->index;
		_tmp2_ = _tmp0_[_tmp1_];
		_tmp3_ = _tmp2_.begin;
		_tmp4_ = _tmp3_.pos;
		_tmp5_ = *location;
		_tmp6_ = _tmp5_.pos;
		if (!(_tmp4_ != _tmp6_)) {
			break;
		}
		_tmp7_ = self->priv->index;
		self->priv->index = ((_tmp7_ - 1) + VALA_PARSER_BUFFER_SIZE) % VALA_PARSER_BUFFER_SIZE;
		_tmp8_ = self->priv->size;
		self->priv->size = _tmp8_ + 1;
		_tmp9_ = self->priv->size;
		if (_tmp9_ > VALA_PARSER_BUFFER_SIZE) {
			ValaScanner* _tmp10_;
			ValaSourceLocation _tmp11_;
			_tmp10_ = self->priv->scanner;
			_tmp11_ = *location;
			vala_scanner_seek (_tmp10_, &_tmp11_);
			self->priv->size = 0;
			self->priv->index = 0;
			vala_parser_next (self);
		}
	}
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static void
vala_parser_skip_identifier (ValaParser* self,
                             GError** error)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	switch (vala_parser_current (self)) {
		case VALA_TOKEN_TYPE_ABSTRACT:
		case VALA_TOKEN_TYPE_AS:
		case VALA_TOKEN_TYPE_ASYNC:
		case VALA_TOKEN_TYPE_BASE:
		case VALA_TOKEN_TYPE_BREAK:
		case VALA_TOKEN_TYPE_CASE:
		case VALA_TOKEN_TYPE_CATCH:
		case VALA_TOKEN_TYPE_CLASS:
		case VALA_TOKEN_TYPE_CONST:
		case VALA_TOKEN_TYPE_CONSTRUCT:
		case VALA_TOKEN_TYPE_CONTINUE:
		case VALA_TOKEN_TYPE_DEFAULT:
		case VALA_TOKEN_TYPE_DELEGATE:
		case VALA_TOKEN_TYPE_DELETE:
		case VALA_TOKEN_TYPE_DO:
		case VALA_TOKEN_TYPE_DYNAMIC:
		case VALA_TOKEN_TYPE_ELSE:
		case VALA_TOKEN_TYPE_ENUM:
		case VALA_TOKEN_TYPE_ENSURES:
		case VALA_TOKEN_TYPE_ERRORDOMAIN:
		case VALA_TOKEN_TYPE_EXTERN:
		case VALA_TOKEN_TYPE_FALSE:
		case VALA_TOKEN_TYPE_FINALLY:
		case VALA_TOKEN_TYPE_FOR:
		case VALA_TOKEN_TYPE_FOREACH:
		case VALA_TOKEN_TYPE_GET:
		case VALA_TOKEN_TYPE_IDENTIFIER:
		case VALA_TOKEN_TYPE_IF:
		case VALA_TOKEN_TYPE_IN:
		case VALA_TOKEN_TYPE_INLINE:
		case VALA_TOKEN_TYPE_INTERFACE:
		case VALA_TOKEN_TYPE_INTERNAL:
		case VALA_TOKEN_TYPE_IS:
		case VALA_TOKEN_TYPE_LOCK:
		case VALA_TOKEN_TYPE_NAMESPACE:
		case VALA_TOKEN_TYPE_NEW:
		case VALA_TOKEN_TYPE_NULL:
		case VALA_TOKEN_TYPE_OUT:
		case VALA_TOKEN_TYPE_OVERRIDE:
		case VALA_TOKEN_TYPE_OWNED:
		case VALA_TOKEN_TYPE_PARAMS:
		case VALA_TOKEN_TYPE_PRIVATE:
		case VALA_TOKEN_TYPE_PROTECTED:
		case VALA_TOKEN_TYPE_PUBLIC:
		case VALA_TOKEN_TYPE_REF:
		case VALA_TOKEN_TYPE_REQUIRES:
		case VALA_TOKEN_TYPE_RETURN:
		case VALA_TOKEN_TYPE_SEALED:
		case VALA_TOKEN_TYPE_SET:
		case VALA_TOKEN_TYPE_SIGNAL:
		case VALA_TOKEN_TYPE_SIZEOF:
		case VALA_TOKEN_TYPE_STATIC:
		case VALA_TOKEN_TYPE_STRUCT:
		case VALA_TOKEN_TYPE_SWITCH:
		case VALA_TOKEN_TYPE_THIS:
		case VALA_TOKEN_TYPE_THROW:
		case VALA_TOKEN_TYPE_THROWS:
		case VALA_TOKEN_TYPE_TRUE:
		case VALA_TOKEN_TYPE_TRY:
		case VALA_TOKEN_TYPE_TYPEOF:
		case VALA_TOKEN_TYPE_UNOWNED:
		case VALA_TOKEN_TYPE_USING:
		case VALA_TOKEN_TYPE_VAR:
		case VALA_TOKEN_TYPE_VIRTUAL:
		case VALA_TOKEN_TYPE_VOID:
		case VALA_TOKEN_TYPE_VOLATILE:
		case VALA_TOKEN_TYPE_WEAK:
		case VALA_TOKEN_TYPE_WHILE:
		case VALA_TOKEN_TYPE_YIELD:
		{
			vala_parser_next (self);
			return;
		}
		case VALA_TOKEN_TYPE_INTEGER_LITERAL:
		case VALA_TOKEN_TYPE_REAL_LITERAL:
		{
			gchar* id = NULL;
			gchar* _tmp0_;
			gboolean _tmp1_ = FALSE;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			_tmp0_ = vala_parser_get_current_string (self);
			id = _tmp0_;
			_tmp2_ = id;
			_tmp3_ = id;
			_tmp4_ = strlen (_tmp3_);
			_tmp5_ = _tmp4_;
			if (g_ascii_isalpha (string_get (_tmp2_, (glong) (_tmp5_ - 1)))) {
				const gchar* _tmp6_;
				_tmp6_ = id;
				_tmp1_ = !string_contains (_tmp6_, ".");
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				vala_parser_next (self);
				_g_free0 (id);
				return;
			}
			_g_free0 (id);
			break;
		}
		default:
		{
			GError* _tmp7_;
			_tmp7_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected identifier");
			_inner_error_ = _tmp7_;
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static gchar*
vala_parser_parse_identifier (ValaParser* self,
                              GError** error)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_skip_identifier (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = vala_parser_get_last_string (self);
	result = _tmp0_;
	return result;
}


static ValaExpression*
vala_parser_parse_literal (ValaParser* self,
                           GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	switch (vala_parser_current (self)) {
		case VALA_TOKEN_TYPE_TRUE:
		{
			ValaSourceLocation _tmp1_;
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			ValaBooleanLiteral* _tmp4_;
			ValaExpression* _tmp5_;
			vala_parser_next (self);
			_tmp1_ = begin;
			_tmp2_ = vala_parser_get_src (self, &_tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = vala_boolean_literal_new (TRUE, _tmp3_);
			_tmp5_ = (ValaExpression*) _tmp4_;
			_vala_source_reference_unref0 (_tmp3_);
			result = _tmp5_;
			return result;
		}
		case VALA_TOKEN_TYPE_FALSE:
		{
			ValaSourceLocation _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaBooleanLiteral* _tmp9_;
			ValaExpression* _tmp10_;
			vala_parser_next (self);
			_tmp6_ = begin;
			_tmp7_ = vala_parser_get_src (self, &_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_boolean_literal_new (FALSE, _tmp8_);
			_tmp10_ = (ValaExpression*) _tmp9_;
			_vala_source_reference_unref0 (_tmp8_);
			result = _tmp10_;
			return result;
		}
		case VALA_TOKEN_TYPE_INTEGER_LITERAL:
		{
			gchar* _tmp11_;
			gchar* _tmp12_;
			ValaSourceLocation _tmp13_;
			ValaSourceReference* _tmp14_;
			ValaSourceReference* _tmp15_;
			ValaIntegerLiteral* _tmp16_;
			ValaExpression* _tmp17_;
			vala_parser_next (self);
			_tmp11_ = vala_parser_get_last_string (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = begin;
			_tmp14_ = vala_parser_get_src (self, &_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_integer_literal_new (_tmp12_, _tmp15_);
			_tmp17_ = (ValaExpression*) _tmp16_;
			_vala_source_reference_unref0 (_tmp15_);
			_g_free0 (_tmp12_);
			result = _tmp17_;
			return result;
		}
		case VALA_TOKEN_TYPE_REAL_LITERAL:
		{
			gchar* _tmp18_;
			gchar* _tmp19_;
			ValaSourceLocation _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaSourceReference* _tmp22_;
			ValaRealLiteral* _tmp23_;
			ValaExpression* _tmp24_;
			vala_parser_next (self);
			_tmp18_ = vala_parser_get_last_string (self);
			_tmp19_ = _tmp18_;
			_tmp20_ = begin;
			_tmp21_ = vala_parser_get_src (self, &_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_real_literal_new (_tmp19_, _tmp22_);
			_tmp24_ = (ValaExpression*) _tmp23_;
			_vala_source_reference_unref0 (_tmp22_);
			_g_free0 (_tmp19_);
			result = _tmp24_;
			return result;
		}
		case VALA_TOKEN_TYPE_CHARACTER_LITERAL:
		{
			ValaCharacterLiteral* lit = NULL;
			gchar* _tmp25_;
			gchar* _tmp26_;
			ValaSourceLocation _tmp27_;
			ValaSourceReference* _tmp28_;
			ValaSourceReference* _tmp29_;
			ValaCharacterLiteral* _tmp30_;
			ValaCharacterLiteral* _tmp31_;
			ValaCharacterLiteral* _tmp32_;
			gboolean _tmp33_;
			gboolean _tmp34_;
			vala_parser_next (self);
			_tmp25_ = vala_parser_get_last_string (self);
			_tmp26_ = _tmp25_;
			_tmp27_ = begin;
			_tmp28_ = vala_parser_get_src (self, &_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = vala_character_literal_new (_tmp26_, _tmp29_);
			_tmp31_ = _tmp30_;
			_vala_source_reference_unref0 (_tmp29_);
			_g_free0 (_tmp26_);
			lit = _tmp31_;
			_tmp32_ = lit;
			_tmp33_ = vala_code_node_get_error ((ValaCodeNode*) _tmp32_);
			_tmp34_ = _tmp33_;
			if (_tmp34_) {
				ValaCharacterLiteral* _tmp35_;
				ValaSourceReference* _tmp36_;
				ValaSourceReference* _tmp37_;
				_tmp35_ = lit;
				_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp35_);
				_tmp37_ = _tmp36_;
				vala_report_error (_tmp37_, "invalid character literal");
			}
			result = (ValaExpression*) lit;
			return result;
		}
		case VALA_TOKEN_TYPE_REGEX_LITERAL:
		{
			gchar* match_part = NULL;
			gchar* _tmp38_;
			ValaSourceReference* src_begin = NULL;
			ValaSourceLocation _tmp39_;
			ValaSourceReference* _tmp40_;
			gchar* close_token = NULL;
			gchar* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaSourceReference* _tmp46_;
			ValaRegexLiteral* _tmp47_;
			ValaExpression* _tmp48_;
			vala_parser_next (self);
			_tmp38_ = vala_parser_get_last_string (self);
			match_part = _tmp38_;
			_tmp39_ = begin;
			_tmp40_ = vala_parser_get_src (self, &_tmp39_);
			src_begin = _tmp40_;
			vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_REGEX_LITERAL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_source_reference_unref0 (src_begin);
					_g_free0 (match_part);
					return NULL;
				} else {
					_vala_source_reference_unref0 (src_begin);
					_g_free0 (match_part);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp41_ = vala_parser_get_last_string (self);
			close_token = _tmp41_;
			_tmp42_ = close_token;
			_tmp43_ = match_part;
			_tmp44_ = g_strdup_printf ("%s/%s", _tmp42_, _tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = src_begin;
			_tmp47_ = vala_regex_literal_new (_tmp45_, _tmp46_);
			_tmp48_ = (ValaExpression*) _tmp47_;
			_g_free0 (_tmp45_);
			result = _tmp48_;
			_g_free0 (close_token);
			_vala_source_reference_unref0 (src_begin);
			_g_free0 (match_part);
			return result;
		}
		case VALA_TOKEN_TYPE_STRING_LITERAL:
		{
			gchar* _tmp49_;
			gchar* _tmp50_;
			ValaSourceLocation _tmp51_;
			ValaSourceReference* _tmp52_;
			ValaSourceReference* _tmp53_;
			ValaStringLiteral* _tmp54_;
			ValaExpression* _tmp55_;
			vala_parser_next (self);
			_tmp49_ = vala_parser_get_last_string (self);
			_tmp50_ = _tmp49_;
			_tmp51_ = begin;
			_tmp52_ = vala_parser_get_src (self, &_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_string_literal_new (_tmp50_, _tmp53_);
			_tmp55_ = (ValaExpression*) _tmp54_;
			_vala_source_reference_unref0 (_tmp53_);
			_g_free0 (_tmp50_);
			result = _tmp55_;
			return result;
		}
		case VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL:
		{
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			ValaSourceLocation _tmp60_;
			ValaSourceReference* _tmp61_;
			ValaSourceReference* _tmp62_;
			ValaStringLiteral* _tmp63_;
			ValaExpression* _tmp64_;
			vala_parser_next (self);
			_tmp56_ = vala_parser_get_last_string (self);
			_tmp57_ = _tmp56_;
			_tmp58_ = g_strdup_printf ("\"%s\"", _tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = begin;
			_tmp61_ = vala_parser_get_src (self, &_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_string_literal_new (_tmp59_, _tmp62_);
			_tmp64_ = (ValaExpression*) _tmp63_;
			_vala_source_reference_unref0 (_tmp62_);
			_g_free0 (_tmp59_);
			_g_free0 (_tmp57_);
			result = _tmp64_;
			return result;
		}
		case VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL:
		{
			gchar* raw_string = NULL;
			gchar* _tmp65_;
			gchar* escaped_string = NULL;
			const gchar* _tmp66_;
			const gchar* _tmp67_;
			gint _tmp68_;
			gint _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			gchar* _tmp73_;
			const gchar* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			ValaSourceLocation _tmp77_;
			ValaSourceReference* _tmp78_;
			ValaSourceReference* _tmp79_;
			ValaStringLiteral* _tmp80_;
			ValaExpression* _tmp81_;
			vala_parser_next (self);
			_tmp65_ = vala_parser_get_last_string (self);
			raw_string = _tmp65_;
			_tmp66_ = raw_string;
			_tmp67_ = raw_string;
			_tmp68_ = strlen (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = string_substring (_tmp66_, (glong) 3, (glong) (_tmp69_ - 6));
			_tmp71_ = _tmp70_;
			_tmp72_ = g_strescape (_tmp71_, "");
			_tmp73_ = _tmp72_;
			_g_free0 (_tmp71_);
			escaped_string = _tmp73_;
			_tmp74_ = escaped_string;
			_tmp75_ = g_strdup_printf ("\"%s\"", _tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = begin;
			_tmp78_ = vala_parser_get_src (self, &_tmp77_);
			_tmp79_ = _tmp78_;
			_tmp80_ = vala_string_literal_new (_tmp76_, _tmp79_);
			_tmp81_ = (ValaExpression*) _tmp80_;
			_vala_source_reference_unref0 (_tmp79_);
			_g_free0 (_tmp76_);
			result = _tmp81_;
			_g_free0 (escaped_string);
			_g_free0 (raw_string);
			return result;
		}
		case VALA_TOKEN_TYPE_NULL:
		{
			ValaSourceLocation _tmp82_;
			ValaSourceReference* _tmp83_;
			ValaSourceReference* _tmp84_;
			ValaNullLiteral* _tmp85_;
			ValaExpression* _tmp86_;
			vala_parser_next (self);
			_tmp82_ = begin;
			_tmp83_ = vala_parser_get_src (self, &_tmp82_);
			_tmp84_ = _tmp83_;
			_tmp85_ = vala_null_literal_new (_tmp84_);
			_tmp86_ = (ValaExpression*) _tmp85_;
			_vala_source_reference_unref0 (_tmp84_);
			result = _tmp86_;
			return result;
		}
		default:
		{
			GError* _tmp87_;
			_tmp87_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected literal");
			_inner_error_ = _tmp87_;
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
}


void
vala_parser_parse_file (ValaParser* self,
                        ValaSourceFile* source_file)
{
	gboolean has_global_context = FALSE;
	ValaCodeContext* _tmp0_;
	gboolean _tmp1_;
	ValaScanner* _tmp5_;
	gboolean _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_tmp0_ = self->priv->context;
	has_global_context = _tmp0_ != NULL;
	_tmp1_ = has_global_context;
	if (!_tmp1_) {
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		ValaCodeContext* _tmp4_;
		_tmp2_ = vala_source_file_get_context (source_file);
		_tmp3_ = _tmp2_;
		_tmp4_ = _vala_code_context_ref0 (_tmp3_);
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = _tmp4_;
	}
	_tmp5_ = vala_scanner_new (source_file);
	_vala_scanner_unref0 (self->priv->scanner);
	self->priv->scanner = _tmp5_;
	vala_parser_parse_file_comments (self);
	self->priv->index = -1;
	self->priv->size = 0;
	vala_parser_next (self);
	{
		ValaCodeContext* _tmp6_;
		ValaNamespace* _tmp7_;
		ValaNamespace* _tmp8_;
		ValaCodeContext* _tmp9_;
		ValaNamespace* _tmp10_;
		ValaNamespace* _tmp11_;
		_tmp6_ = self->priv->context;
		_tmp7_ = vala_code_context_get_root (_tmp6_);
		_tmp8_ = _tmp7_;
		vala_parser_parse_using_directives (self, _tmp8_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				goto __catch14_vala_parse_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp9_ = self->priv->context;
		_tmp10_ = vala_code_context_get_root (_tmp9_);
		_tmp11_ = _tmp10_;
		vala_parser_parse_declarations (self, (ValaSymbol*) _tmp11_, TRUE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				goto __catch14_vala_parse_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (vala_parser_accept (self, VALA_TOKEN_TYPE_CLOSE_BRACE)) {
			ValaCodeContext* _tmp12_;
			ValaReport* _tmp13_;
			ValaReport* _tmp14_;
			_tmp12_ = self->priv->context;
			_tmp13_ = vala_code_context_get_report (_tmp12_);
			_tmp14_ = _tmp13_;
			if (vala_report_get_errors (_tmp14_) == 0) {
				ValaSourceReference* _tmp15_;
				ValaSourceReference* _tmp16_;
				_tmp15_ = vala_parser_get_last_src (self);
				_tmp16_ = _tmp15_;
				vala_report_error (_tmp16_, "unexpected `}'");
				_vala_source_reference_unref0 (_tmp16_);
			}
		}
	}
	goto __finally14;
	__catch14_vala_parse_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = e;
		vala_parser_report_parse_error (self, _tmp17_);
		_g_error_free0 (e);
	}
	__finally14:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_vala_scanner_unref0 (self->priv->scanner);
	self->priv->scanner = NULL;
	_tmp18_ = has_global_context;
	if (!_tmp18_) {
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = NULL;
	}
}


static void
vala_parser_parse_file_comments (ValaParser* self)
{
	ValaScanner* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scanner;
	vala_scanner_parse_file_comments (_tmp0_);
}


static void
vala_parser_skip_symbol_name (ValaParser* self,
                              GError** error)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			if (!_tmp0_) {
				gboolean _tmp1_ = FALSE;
				if (vala_parser_accept (self, VALA_TOKEN_TYPE_DOT)) {
					_tmp1_ = TRUE;
				} else {
					_tmp1_ = vala_parser_accept (self, VALA_TOKEN_TYPE_DOUBLE_COLON);
				}
				if (!_tmp1_) {
					break;
				}
			}
			_tmp0_ = FALSE;
			vala_parser_skip_identifier (self, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static ValaUnresolvedSymbol*
vala_parser_parse_symbol_name (ValaParser* self,
                               GError** error)
{
	ValaUnresolvedSymbol* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaUnresolvedSymbol* sym = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	sym = NULL;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			gchar* name = NULL;
			gchar* _tmp2_;
			gboolean _tmp3_ = FALSE;
			const gchar* _tmp4_;
			ValaUnresolvedSymbol* _tmp15_;
			const gchar* _tmp16_;
			ValaSourceLocation _tmp17_;
			ValaSourceReference* _tmp18_;
			ValaSourceReference* _tmp19_;
			ValaUnresolvedSymbol* _tmp20_;
			if (!_tmp1_) {
				if (!vala_parser_accept (self, VALA_TOKEN_TYPE_DOT)) {
					break;
				}
			}
			_tmp1_ = FALSE;
			_tmp2_ = vala_parser_parse_identifier (self, &_inner_error_);
			name = _tmp2_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (sym);
					return NULL;
				} else {
					_vala_code_node_unref0 (sym);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp4_ = name;
			if (g_strcmp0 (_tmp4_, "global") == 0) {
				_tmp3_ = vala_parser_accept (self, VALA_TOKEN_TYPE_DOUBLE_COLON);
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				gchar* _tmp7_;
				ValaUnresolvedSymbol* _tmp8_;
				const gchar* _tmp9_;
				ValaSourceLocation _tmp10_;
				ValaSourceReference* _tmp11_;
				ValaSourceReference* _tmp12_;
				ValaUnresolvedSymbol* _tmp13_;
				ValaUnresolvedSymbol* _tmp14_;
				_tmp6_ = vala_parser_parse_identifier (self, &_inner_error_);
				_tmp5_ = _tmp6_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (name);
						_vala_code_node_unref0 (sym);
						return NULL;
					} else {
						_g_free0 (name);
						_vala_code_node_unref0 (sym);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp7_ = _tmp5_;
				_tmp5_ = NULL;
				_g_free0 (name);
				name = _tmp7_;
				_tmp8_ = sym;
				_tmp9_ = name;
				_tmp10_ = begin;
				_tmp11_ = vala_parser_get_src (self, &_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = vala_unresolved_symbol_new (_tmp8_, _tmp9_, _tmp12_);
				_vala_code_node_unref0 (sym);
				sym = _tmp13_;
				_vala_source_reference_unref0 (_tmp12_);
				_tmp14_ = sym;
				vala_unresolved_symbol_set_qualified (_tmp14_, TRUE);
				_g_free0 (_tmp5_);
				_g_free0 (name);
				continue;
			}
			_tmp15_ = sym;
			_tmp16_ = name;
			_tmp17_ = begin;
			_tmp18_ = vala_parser_get_src (self, &_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_unresolved_symbol_new (_tmp15_, _tmp16_, _tmp19_);
			_vala_code_node_unref0 (sym);
			sym = _tmp20_;
			_vala_source_reference_unref0 (_tmp19_);
			_g_free0 (name);
		}
	}
	result = sym;
	return result;
}


static void
vala_parser_skip_type (ValaParser* self,
                       GError** error)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	vala_parser_accept (self, VALA_TOKEN_TYPE_DYNAMIC);
	vala_parser_accept (self, VALA_TOKEN_TYPE_OWNED);
	vala_parser_accept (self, VALA_TOKEN_TYPE_UNOWNED);
	vala_parser_accept (self, VALA_TOKEN_TYPE_WEAK);
	if (vala_parser_is_inner_array_type (self)) {
		vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_UNOWNED, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		vala_parser_skip_type (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_BRACKET, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		vala_parser_prev (self);
	} else {
		if (vala_parser_accept (self, VALA_TOKEN_TYPE_VOID)) {
		} else {
			vala_parser_skip_symbol_name (self, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			vala_parser_skip_type_argument_list (self, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		while (TRUE) {
			if (!vala_parser_accept (self, VALA_TOKEN_TYPE_STAR)) {
				break;
			}
		}
		vala_parser_accept (self, VALA_TOKEN_TYPE_INTERR);
	}
	while (TRUE) {
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_OPEN_BRACKET)) {
			break;
		}
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				if (!_tmp0_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp0_ = FALSE;
				if (vala_parser_current (self) != VALA_TOKEN_TYPE_COMMA) {
					_tmp1_ = vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_BRACKET;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					ValaExpression* _tmp2_;
					ValaExpression* _tmp3_;
					_tmp2_ = vala_parser_parse_expression (self, &_inner_error_);
					_tmp3_ = _tmp2_;
					_vala_code_node_unref0 (_tmp3_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
			}
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		vala_parser_accept (self, VALA_TOKEN_TYPE_INTERR);
	}
	vala_parser_accept (self, VALA_TOKEN_TYPE_OP_NEG);
	vala_parser_accept (self, VALA_TOKEN_TYPE_HASH);
}


static gboolean
vala_parser_is_inner_array_type (ValaParser* self)
{
	gboolean result = FALSE;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _result_ = FALSE;
	ValaSourceLocation _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_OPEN_PARENS)) {
		_tmp2_ = vala_parser_accept (self, VALA_TOKEN_TYPE_UNOWNED);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_PARENS;
	} else {
		_tmp1_ = FALSE;
	}
	_result_ = _tmp1_;
	_tmp3_ = begin;
	vala_parser_rollback (self, &_tmp3_);
	result = _result_;
	return result;
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static ValaDataType*
vala_parser_parse_type (ValaParser* self,
                        gboolean owned_by_default,
                        gboolean can_weak_ref,
                        gboolean require_unowned,
                        GError** error)
{
	ValaDataType* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gboolean is_dynamic = FALSE;
	gboolean value_owned = FALSE;
	ValaDataType* type = NULL;
	gboolean inner_type_owned = FALSE;
	ValaDataType* _tmp76_;
	ValaDataType* _tmp77_;
	gboolean _tmp78_;
	ValaDataType* _tmp79_;
	gboolean _tmp80_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	is_dynamic = vala_parser_accept (self, VALA_TOKEN_TYPE_DYNAMIC);
	value_owned = owned_by_default;
	if (require_unowned) {
		vala_parser_expect (self, VALA_TOKEN_TYPE_UNOWNED, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	} else {
		if (owned_by_default) {
			if (vala_parser_accept (self, VALA_TOKEN_TYPE_UNOWNED)) {
				value_owned = FALSE;
			} else {
				if (vala_parser_accept (self, VALA_TOKEN_TYPE_WEAK)) {
					gboolean _tmp1_ = FALSE;
					if (!can_weak_ref) {
						ValaCodeContext* _tmp2_;
						gboolean _tmp3_;
						gboolean _tmp4_;
						_tmp2_ = self->priv->context;
						_tmp3_ = vala_code_context_get_deprecated (_tmp2_);
						_tmp4_ = _tmp3_;
						_tmp1_ = !_tmp4_;
					} else {
						_tmp1_ = FALSE;
					}
					if (_tmp1_) {
						ValaSourceReference* _tmp5_;
						ValaSourceReference* _tmp6_;
						_tmp5_ = vala_parser_get_last_src (self);
						_tmp6_ = _tmp5_;
						vala_report_warning (_tmp6_, "deprecated syntax, use `unowned` modifier");
						_vala_source_reference_unref0 (_tmp6_);
					}
					value_owned = FALSE;
				} else {
					if (vala_parser_accept (self, VALA_TOKEN_TYPE_OWNED)) {
						ValaSourceReference* _tmp7_;
						ValaSourceReference* _tmp8_;
						_tmp7_ = vala_parser_get_last_src (self);
						_tmp8_ = _tmp7_;
						vala_report_warning (_tmp8_, "`owned' is default in this context");
						_vala_source_reference_unref0 (_tmp8_);
					}
				}
			}
		} else {
			if (vala_parser_accept (self, VALA_TOKEN_TYPE_OWNED)) {
				value_owned = TRUE;
			} else {
				value_owned = FALSE;
				if (vala_parser_accept (self, VALA_TOKEN_TYPE_UNOWNED)) {
					ValaSourceReference* _tmp9_;
					ValaSourceReference* _tmp10_;
					_tmp9_ = vala_parser_get_last_src (self);
					_tmp10_ = _tmp9_;
					vala_report_warning (_tmp10_, "`unowned' is default in this context");
					_vala_source_reference_unref0 (_tmp10_);
				}
			}
		}
	}
	inner_type_owned = TRUE;
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_OPEN_PARENS)) {
		ValaDataType* _tmp11_ = NULL;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		_tmp12_ = vala_parser_parse_type (self, FALSE, FALSE, TRUE, &_inner_error_);
		_tmp11_ = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp13_ = _tmp11_;
		_tmp11_ = NULL;
		_vala_code_node_unref0 (type);
		type = _tmp13_;
		vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (_tmp11_);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_code_node_unref0 (_tmp11_);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		inner_type_owned = FALSE;
		vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_BRACKET, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (_tmp11_);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_code_node_unref0 (_tmp11_);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		vala_parser_prev (self);
		_vala_code_node_unref0 (_tmp11_);
	} else {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_;
		ValaDataType* _tmp48_;
		_tmp16_ = is_dynamic;
		if (!_tmp16_) {
			gboolean _tmp17_;
			_tmp17_ = value_owned;
			_tmp15_ = _tmp17_ == owned_by_default;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			_tmp14_ = vala_parser_accept (self, VALA_TOKEN_TYPE_VOID);
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaSourceLocation _tmp18_;
			ValaSourceReference* _tmp19_;
			ValaSourceReference* _tmp20_;
			ValaVoidType* _tmp21_;
			_tmp18_ = begin;
			_tmp19_ = vala_parser_get_src (self, &_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_void_type_new (_tmp20_);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp21_;
			_vala_source_reference_unref0 (_tmp20_);
		} else {
			ValaUnresolvedSymbol* sym = NULL;
			ValaUnresolvedSymbol* _tmp22_;
			ValaList* type_arg_list = NULL;
			ValaList* _tmp23_;
			ValaUnresolvedSymbol* _tmp24_;
			ValaSourceLocation _tmp25_;
			ValaSourceReference* _tmp26_;
			ValaSourceReference* _tmp27_;
			ValaUnresolvedType* _tmp28_;
			ValaList* _tmp29_;
			_tmp22_ = vala_parser_parse_symbol_name (self, &_inner_error_);
			sym = _tmp22_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (type);
					return NULL;
				} else {
					_vala_code_node_unref0 (type);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp23_ = vala_parser_parse_type_argument_list (self, FALSE, &_inner_error_);
			type_arg_list = _tmp23_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (sym);
					_vala_code_node_unref0 (type);
					return NULL;
				} else {
					_vala_code_node_unref0 (sym);
					_vala_code_node_unref0 (type);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp24_ = sym;
			_tmp25_ = begin;
			_tmp26_ = vala_parser_get_src (self, &_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = vala_unresolved_type_new_from_symbol (_tmp24_, _tmp27_);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp28_;
			_vala_source_reference_unref0 (_tmp27_);
			_tmp29_ = type_arg_list;
			if (_tmp29_ != NULL) {
				{
					ValaList* _type_arg_list = NULL;
					ValaList* _tmp30_;
					ValaList* _tmp31_;
					gint _type_arg_size = 0;
					ValaList* _tmp32_;
					gint _tmp33_;
					gint _tmp34_;
					gint _type_arg_index = 0;
					_tmp30_ = type_arg_list;
					_tmp31_ = _vala_iterable_ref0 (_tmp30_);
					_type_arg_list = _tmp31_;
					_tmp32_ = _type_arg_list;
					_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
					_tmp34_ = _tmp33_;
					_type_arg_size = _tmp34_;
					_type_arg_index = -1;
					while (TRUE) {
						gint _tmp35_;
						gint _tmp36_;
						gint _tmp37_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp38_;
						gint _tmp39_;
						gpointer _tmp40_;
						ValaDataType* _tmp41_;
						ValaDataType* _tmp42_;
						_tmp35_ = _type_arg_index;
						_type_arg_index = _tmp35_ + 1;
						_tmp36_ = _type_arg_index;
						_tmp37_ = _type_arg_size;
						if (!(_tmp36_ < _tmp37_)) {
							break;
						}
						_tmp38_ = _type_arg_list;
						_tmp39_ = _type_arg_index;
						_tmp40_ = vala_list_get (_tmp38_, _tmp39_);
						type_arg = (ValaDataType*) _tmp40_;
						_tmp41_ = type;
						_tmp42_ = type_arg;
						vala_data_type_add_type_argument (_tmp41_, _tmp42_);
						_vala_code_node_unref0 (type_arg);
					}
					_vala_iterable_unref0 (_type_arg_list);
				}
			}
			_vala_iterable_unref0 (type_arg_list);
			_vala_code_node_unref0 (sym);
		}
		while (TRUE) {
			ValaDataType* _tmp43_;
			ValaSourceLocation _tmp44_;
			ValaSourceReference* _tmp45_;
			ValaSourceReference* _tmp46_;
			ValaPointerType* _tmp47_;
			if (!vala_parser_accept (self, VALA_TOKEN_TYPE_STAR)) {
				break;
			}
			_tmp43_ = type;
			_tmp44_ = begin;
			_tmp45_ = vala_parser_get_src (self, &_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_pointer_type_new (_tmp43_, _tmp46_);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp47_;
			_vala_source_reference_unref0 (_tmp46_);
		}
		_tmp48_ = type;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_POINTER_TYPE)) {
			ValaDataType* _tmp49_;
			_tmp49_ = type;
			vala_data_type_set_nullable (_tmp49_, vala_parser_accept (self, VALA_TOKEN_TYPE_INTERR));
		}
	}
	while (TRUE) {
		gboolean invalid_array = FALSE;
		gint array_rank = 0;
		ValaDataType* _tmp55_;
		gboolean _tmp56_;
		ValaArrayType* array_type = NULL;
		ValaDataType* _tmp57_;
		gint _tmp58_;
		ValaSourceLocation _tmp59_;
		ValaSourceReference* _tmp60_;
		ValaSourceReference* _tmp61_;
		ValaArrayType* _tmp62_;
		ValaArrayType* _tmp63_;
		ValaArrayType* _tmp64_;
		ValaArrayType* _tmp65_;
		gboolean _tmp66_;
		ValaArrayType* _tmp67_;
		ValaDataType* _tmp68_;
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_OPEN_BRACKET)) {
			break;
		}
		invalid_array = FALSE;
		array_rank = 0;
		{
			gboolean _tmp50_ = FALSE;
			_tmp50_ = TRUE;
			while (TRUE) {
				gint _tmp51_;
				gboolean _tmp52_ = FALSE;
				if (!_tmp50_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp50_ = FALSE;
				_tmp51_ = array_rank;
				array_rank = _tmp51_ + 1;
				if (vala_parser_current (self) != VALA_TOKEN_TYPE_COMMA) {
					_tmp52_ = vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_BRACKET;
				} else {
					_tmp52_ = FALSE;
				}
				if (_tmp52_) {
					ValaExpression* _tmp53_;
					ValaExpression* _tmp54_;
					_tmp53_ = vala_parser_parse_expression (self, &_inner_error_);
					_tmp54_ = _tmp53_;
					_vala_code_node_unref0 (_tmp54_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_vala_code_node_unref0 (type);
							return NULL;
						} else {
							_vala_code_node_unref0 (type);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					invalid_array = TRUE;
				}
			}
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp55_ = type;
		_tmp56_ = inner_type_owned;
		vala_data_type_set_value_owned (_tmp55_, _tmp56_);
		_tmp57_ = type;
		_tmp58_ = array_rank;
		_tmp59_ = begin;
		_tmp60_ = vala_parser_get_src (self, &_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_array_type_new (_tmp57_, _tmp58_, _tmp61_);
		_tmp63_ = _tmp62_;
		_vala_source_reference_unref0 (_tmp61_);
		array_type = _tmp63_;
		_tmp64_ = array_type;
		vala_data_type_set_nullable ((ValaDataType*) _tmp64_, vala_parser_accept (self, VALA_TOKEN_TYPE_INTERR));
		_tmp65_ = array_type;
		_tmp66_ = invalid_array;
		vala_array_type_set_invalid_syntax (_tmp65_, _tmp66_);
		_tmp67_ = array_type;
		_tmp68_ = _vala_code_node_ref0 ((ValaDataType*) _tmp67_);
		_vala_code_node_unref0 (type);
		type = _tmp68_;
		_vala_code_node_unref0 (array_type);
	}
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_OP_NEG)) {
		ValaSourceReference* _tmp69_;
		ValaSourceReference* _tmp70_;
		_tmp69_ = vala_parser_get_last_src (self);
		_tmp70_ = _tmp69_;
		vala_report_warning (_tmp70_, "obsolete syntax, types are non-null by default");
		_vala_source_reference_unref0 (_tmp70_);
	}
	if (!owned_by_default) {
		if (vala_parser_accept (self, VALA_TOKEN_TYPE_HASH)) {
			ValaCodeContext* _tmp71_;
			gboolean _tmp72_;
			gboolean _tmp73_;
			_tmp71_ = self->priv->context;
			_tmp72_ = vala_code_context_get_deprecated (_tmp71_);
			_tmp73_ = _tmp72_;
			if (!_tmp73_) {
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				_tmp74_ = vala_parser_get_last_src (self);
				_tmp75_ = _tmp74_;
				vala_report_warning (_tmp75_, "deprecated syntax, use `owned` modifier");
				_vala_source_reference_unref0 (_tmp75_);
			}
			value_owned = TRUE;
		}
	}
	_tmp76_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp76_, VALA_TYPE_POINTER_TYPE)) {
		value_owned = FALSE;
	}
	_tmp77_ = type;
	_tmp78_ = is_dynamic;
	vala_data_type_set_is_dynamic (_tmp77_, _tmp78_);
	_tmp79_ = type;
	_tmp80_ = value_owned;
	vala_data_type_set_value_owned (_tmp79_, _tmp80_);
	result = type;
	return result;
}


static ValaDataType*
vala_parser_parse_inline_array_type (ValaParser* self,
                                     ValaDataType* type,
                                     GError** error)
{
	ValaDataType* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	ValaDataType* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	if (type != NULL) {
		_tmp1_ = vala_parser_accept (self, VALA_TOKEN_TYPE_OPEN_BRACKET);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaExpression* array_length = NULL;
		ValaArrayType* array_type = NULL;
		ValaSourceLocation _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaArrayType* _tmp8_;
		ValaArrayType* _tmp9_;
		ValaArrayType* _tmp10_;
		ValaExpression* _tmp11_;
		ValaArrayType* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		array_length = NULL;
		if (vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_BRACKET) {
			ValaExpression* _tmp2_ = NULL;
			ValaExpression* _tmp3_;
			ValaExpression* _tmp4_;
			_tmp3_ = vala_parser_parse_expression (self, &_inner_error_);
			_tmp2_ = _tmp3_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (array_length);
					return NULL;
				} else {
					_vala_code_node_unref0 (array_length);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp4_ = _tmp2_;
			_tmp2_ = NULL;
			_vala_code_node_unref0 (array_length);
			array_length = _tmp4_;
			_vala_code_node_unref0 (_tmp2_);
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (array_length);
				return NULL;
			} else {
				_vala_code_node_unref0 (array_length);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp5_ = begin;
		_tmp6_ = vala_parser_get_src (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_array_type_new (type, 1, _tmp7_);
		_tmp9_ = _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		array_type = _tmp9_;
		_tmp10_ = array_type;
		vala_array_type_set_inline_allocated (_tmp10_, TRUE);
		_tmp11_ = array_length;
		if (_tmp11_ != NULL) {
			ValaArrayType* _tmp12_;
			ValaArrayType* _tmp13_;
			ValaExpression* _tmp14_;
			_tmp12_ = array_type;
			vala_array_type_set_fixed_length (_tmp12_, TRUE);
			_tmp13_ = array_type;
			_tmp14_ = array_length;
			vala_array_type_set_length (_tmp13_, _tmp14_);
		}
		_tmp15_ = array_type;
		_tmp16_ = vala_data_type_get_value_owned (type);
		_tmp17_ = _tmp16_;
		vala_data_type_set_value_owned ((ValaDataType*) _tmp15_, _tmp17_);
		result = (ValaDataType*) array_type;
		_vala_code_node_unref0 (array_length);
		return result;
	}
	_tmp18_ = _vala_code_node_ref0 (type);
	result = _tmp18_;
	return result;
}


static ValaList*
vala_parser_parse_argument_list (ValaParser* self,
                                 GError** error)
{
	ValaList* result = NULL;
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	list = _tmp1_;
	if (vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_PARENS) {
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ValaExpression* _tmp3_ = NULL;
				ValaExpression* _tmp4_;
				ValaArrayList* _tmp5_;
				if (!_tmp2_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp2_ = FALSE;
				_tmp4_ = vala_parser_parse_argument (self, &_inner_error_);
				_tmp3_ = _tmp4_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_iterable_unref0 (list);
						return NULL;
					} else {
						_vala_iterable_unref0 (list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp5_ = list;
				vala_collection_add ((ValaCollection*) _tmp5_, _tmp3_);
				_vala_code_node_unref0 (_tmp3_);
			}
		}
	}
	result = (ValaList*) list;
	return result;
}


static ValaExpression*
vala_parser_parse_argument (ValaParser* self,
                            GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_REF)) {
		ValaExpression* inner = NULL;
		ValaExpression* _tmp1_;
		ValaExpression* _tmp2_;
		ValaSourceLocation _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaUnaryExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp1_ = vala_parser_parse_expression (self, &_inner_error_);
		inner = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp2_ = inner;
		_tmp3_ = begin;
		_tmp4_ = vala_parser_get_src (self, &_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_REF, _tmp2_, _tmp5_);
		_tmp7_ = (ValaExpression*) _tmp6_;
		_vala_source_reference_unref0 (_tmp5_);
		result = _tmp7_;
		_vala_code_node_unref0 (inner);
		return result;
	} else {
		if (vala_parser_accept (self, VALA_TOKEN_TYPE_OUT)) {
			ValaExpression* inner = NULL;
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			ValaSourceLocation _tmp10_;
			ValaSourceReference* _tmp11_;
			ValaSourceReference* _tmp12_;
			ValaUnaryExpression* _tmp13_;
			ValaExpression* _tmp14_;
			_tmp8_ = vala_parser_parse_expression (self, &_inner_error_);
			inner = _tmp8_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp9_ = inner;
			_tmp10_ = begin;
			_tmp11_ = vala_parser_get_src (self, &_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_OUT, _tmp9_, _tmp12_);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_vala_source_reference_unref0 (_tmp12_);
			result = _tmp14_;
			_vala_code_node_unref0 (inner);
			return result;
		} else {
			ValaExpression* expr = NULL;
			ValaExpression* _tmp15_;
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp16_;
			ValaMemberAccess* _tmp17_;
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			ValaMemberAccess* _tmp20_;
			_tmp15_ = vala_parser_parse_expression (self, &_inner_error_);
			expr = _tmp15_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp16_ = expr;
			_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp16_) : NULL);
			ma = _tmp17_;
			_tmp20_ = ma;
			if (_tmp20_ != NULL) {
				ValaMemberAccess* _tmp21_;
				ValaExpression* _tmp22_;
				ValaExpression* _tmp23_;
				_tmp21_ = ma;
				_tmp22_ = vala_member_access_get_inner (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp19_ = _tmp23_ == NULL;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				_tmp18_ = vala_parser_accept (self, VALA_TOKEN_TYPE_COLON);
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				ValaExpression* _tmp24_ = NULL;
				ValaExpression* _tmp25_;
				ValaExpression* _tmp26_;
				ValaMemberAccess* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				ValaExpression* _tmp30_;
				ValaSourceLocation _tmp31_;
				ValaSourceReference* _tmp32_;
				ValaSourceReference* _tmp33_;
				ValaNamedArgument* _tmp34_;
				ValaExpression* _tmp35_;
				_tmp25_ = vala_parser_parse_expression (self, &_inner_error_);
				_tmp24_ = _tmp25_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (ma);
						_vala_code_node_unref0 (expr);
						return NULL;
					} else {
						_vala_code_node_unref0 (ma);
						_vala_code_node_unref0 (expr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp26_ = _tmp24_;
				_tmp24_ = NULL;
				_vala_code_node_unref0 (expr);
				expr = _tmp26_;
				_tmp27_ = ma;
				_tmp28_ = vala_member_access_get_member_name (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = expr;
				_tmp31_ = begin;
				_tmp32_ = vala_parser_get_src (self, &_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = vala_named_argument_new (_tmp29_, _tmp30_, _tmp33_);
				_tmp35_ = (ValaExpression*) _tmp34_;
				_vala_source_reference_unref0 (_tmp33_);
				result = _tmp35_;
				_vala_code_node_unref0 (_tmp24_);
				_vala_code_node_unref0 (ma);
				_vala_code_node_unref0 (expr);
				return result;
			} else {
				result = expr;
				_vala_code_node_unref0 (ma);
				return result;
			}
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (expr);
		}
	}
}


static ValaExpression*
vala_parser_parse_primary_expression (ValaParser* self,
                                      GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* expr = NULL;
	gboolean found = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	switch (vala_parser_current (self)) {
		case VALA_TOKEN_TYPE_TRUE:
		case VALA_TOKEN_TYPE_FALSE:
		case VALA_TOKEN_TYPE_INTEGER_LITERAL:
		case VALA_TOKEN_TYPE_REAL_LITERAL:
		case VALA_TOKEN_TYPE_CHARACTER_LITERAL:
		case VALA_TOKEN_TYPE_STRING_LITERAL:
		case VALA_TOKEN_TYPE_REGEX_LITERAL:
		case VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL:
		case VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL:
		case VALA_TOKEN_TYPE_NULL:
		{
			ValaExpression* _tmp1_ = NULL;
			ValaExpression* _tmp2_;
			ValaExpression* _tmp3_;
			_tmp2_ = vala_parser_parse_literal (self, &_inner_error_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp3_;
			_vala_code_node_unref0 (_tmp1_);
			break;
		}
		case VALA_TOKEN_TYPE_OPEN_BRACE:
		{
			ValaInitializerList* _tmp4_ = NULL;
			ValaInitializerList* _tmp5_;
			ValaInitializerList* _tmp6_;
			_tmp5_ = vala_parser_parse_initializer (self, &_inner_error_);
			_tmp4_ = _tmp5_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp6_ = _tmp4_;
			_tmp4_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp6_;
			_vala_code_node_unref0 (_tmp4_);
			break;
		}
		case VALA_TOKEN_TYPE_OPEN_BRACKET:
		{
			ValaExpression* _tmp7_ = NULL;
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_parser_parse_simple_name (self, &_inner_error_);
			_tmp7_ = _tmp8_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp9_ = _tmp7_;
			_tmp7_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp9_;
			_vala_code_node_unref0 (_tmp7_);
			break;
		}
		case VALA_TOKEN_TYPE_OPEN_PARENS:
		{
			ValaExpression* _tmp10_ = NULL;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			_tmp11_ = vala_parser_parse_tuple (self, &_inner_error_);
			_tmp10_ = _tmp11_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp12_ = _tmp10_;
			_tmp10_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp12_;
			_vala_code_node_unref0 (_tmp10_);
			break;
		}
		case VALA_TOKEN_TYPE_OPEN_TEMPLATE:
		{
			ValaExpression* _tmp13_ = NULL;
			ValaExpression* _tmp14_;
			ValaExpression* _tmp15_;
			_tmp14_ = vala_parser_parse_template (self, &_inner_error_);
			_tmp13_ = _tmp14_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp15_ = _tmp13_;
			_tmp13_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp15_;
			_vala_code_node_unref0 (_tmp13_);
			break;
		}
		case VALA_TOKEN_TYPE_OPEN_REGEX_LITERAL:
		{
			ValaExpression* _tmp16_ = NULL;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			_tmp17_ = vala_parser_parse_regex_literal (self, &_inner_error_);
			_tmp16_ = _tmp17_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp18_ = _tmp16_;
			_tmp16_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp18_;
			_vala_code_node_unref0 (_tmp16_);
			break;
		}
		case VALA_TOKEN_TYPE_THIS:
		{
			ValaExpression* _tmp19_ = NULL;
			ValaExpression* _tmp20_;
			ValaExpression* _tmp21_;
			_tmp20_ = vala_parser_parse_this_access (self, &_inner_error_);
			_tmp19_ = _tmp20_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp21_ = _tmp19_;
			_tmp19_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp21_;
			_vala_code_node_unref0 (_tmp19_);
			break;
		}
		case VALA_TOKEN_TYPE_BASE:
		{
			ValaExpression* _tmp22_ = NULL;
			ValaExpression* _tmp23_;
			ValaExpression* _tmp24_;
			_tmp23_ = vala_parser_parse_base_access (self, &_inner_error_);
			_tmp22_ = _tmp23_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp24_ = _tmp22_;
			_tmp22_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp24_;
			_vala_code_node_unref0 (_tmp22_);
			break;
		}
		case VALA_TOKEN_TYPE_NEW:
		{
			ValaExpression* _tmp25_ = NULL;
			ValaExpression* _tmp26_;
			ValaExpression* _tmp27_;
			_tmp26_ = vala_parser_parse_object_or_array_creation_expression (self, &_inner_error_);
			_tmp25_ = _tmp26_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp27_ = _tmp25_;
			_tmp25_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp27_;
			_vala_code_node_unref0 (_tmp25_);
			break;
		}
		case VALA_TOKEN_TYPE_YIELD:
		{
			ValaExpression* _tmp28_ = NULL;
			ValaExpression* _tmp29_;
			ValaExpression* _tmp30_;
			_tmp29_ = vala_parser_parse_yield_expression (self, &_inner_error_);
			_tmp28_ = _tmp29_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp30_ = _tmp28_;
			_tmp28_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp30_;
			_vala_code_node_unref0 (_tmp28_);
			break;
		}
		case VALA_TOKEN_TYPE_SIZEOF:
		{
			ValaExpression* _tmp31_ = NULL;
			ValaExpression* _tmp32_;
			ValaExpression* _tmp33_;
			_tmp32_ = vala_parser_parse_sizeof_expression (self, &_inner_error_);
			_tmp31_ = _tmp32_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp33_ = _tmp31_;
			_tmp31_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp33_;
			_vala_code_node_unref0 (_tmp31_);
			break;
		}
		case VALA_TOKEN_TYPE_TYPEOF:
		{
			ValaExpression* _tmp34_ = NULL;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			_tmp35_ = vala_parser_parse_typeof_expression (self, &_inner_error_);
			_tmp34_ = _tmp35_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp36_ = _tmp34_;
			_tmp34_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp36_;
			_vala_code_node_unref0 (_tmp34_);
			break;
		}
		default:
		{
			ValaExpression* _tmp37_ = NULL;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			_tmp38_ = vala_parser_parse_simple_name (self, &_inner_error_);
			_tmp37_ = _tmp38_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp39_ = _tmp37_;
			_tmp37_ = NULL;
			_vala_code_node_unref0 (expr);
			expr = _tmp39_;
			_vala_code_node_unref0 (_tmp37_);
			break;
		}
	}
	found = TRUE;
	while (TRUE) {
		gboolean _tmp40_;
		_tmp40_ = found;
		if (!_tmp40_) {
			break;
		}
		switch (vala_parser_current (self)) {
			case VALA_TOKEN_TYPE_DOT:
			{
				ValaExpression* _tmp41_ = NULL;
				ValaSourceLocation _tmp42_;
				ValaExpression* _tmp43_;
				ValaExpression* _tmp44_;
				ValaExpression* _tmp45_;
				_tmp42_ = begin;
				_tmp43_ = expr;
				_tmp44_ = vala_parser_parse_member_access (self, &_tmp42_, _tmp43_, &_inner_error_);
				_tmp41_ = _tmp44_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (expr);
						return NULL;
					} else {
						_vala_code_node_unref0 (expr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp45_ = _tmp41_;
				_tmp41_ = NULL;
				_vala_code_node_unref0 (expr);
				expr = _tmp45_;
				_vala_code_node_unref0 (_tmp41_);
				break;
			}
			case VALA_TOKEN_TYPE_OP_PTR:
			{
				ValaExpression* _tmp46_ = NULL;
				ValaSourceLocation _tmp47_;
				ValaExpression* _tmp48_;
				ValaExpression* _tmp49_;
				ValaExpression* _tmp50_;
				_tmp47_ = begin;
				_tmp48_ = expr;
				_tmp49_ = vala_parser_parse_pointer_member_access (self, &_tmp47_, _tmp48_, &_inner_error_);
				_tmp46_ = _tmp49_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (expr);
						return NULL;
					} else {
						_vala_code_node_unref0 (expr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp50_ = _tmp46_;
				_tmp46_ = NULL;
				_vala_code_node_unref0 (expr);
				expr = _tmp50_;
				_vala_code_node_unref0 (_tmp46_);
				break;
			}
			case VALA_TOKEN_TYPE_OPEN_PARENS:
			{
				ValaExpression* _tmp51_ = NULL;
				ValaSourceLocation _tmp52_;
				ValaExpression* _tmp53_;
				ValaExpression* _tmp54_;
				ValaExpression* _tmp55_;
				_tmp52_ = begin;
				_tmp53_ = expr;
				_tmp54_ = vala_parser_parse_method_call (self, &_tmp52_, _tmp53_, &_inner_error_);
				_tmp51_ = _tmp54_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (expr);
						return NULL;
					} else {
						_vala_code_node_unref0 (expr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp55_ = _tmp51_;
				_tmp51_ = NULL;
				_vala_code_node_unref0 (expr);
				expr = _tmp55_;
				_vala_code_node_unref0 (_tmp51_);
				break;
			}
			case VALA_TOKEN_TYPE_OPEN_BRACKET:
			{
				ValaExpression* _tmp56_ = NULL;
				ValaSourceLocation _tmp57_;
				ValaExpression* _tmp58_;
				ValaExpression* _tmp59_;
				ValaExpression* _tmp60_;
				_tmp57_ = begin;
				_tmp58_ = expr;
				_tmp59_ = vala_parser_parse_element_access (self, &_tmp57_, _tmp58_, &_inner_error_);
				_tmp56_ = _tmp59_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (expr);
						return NULL;
					} else {
						_vala_code_node_unref0 (expr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp60_ = _tmp56_;
				_tmp56_ = NULL;
				_vala_code_node_unref0 (expr);
				expr = _tmp60_;
				_vala_code_node_unref0 (_tmp56_);
				break;
			}
			case VALA_TOKEN_TYPE_OP_INC:
			{
				ValaExpression* _tmp61_ = NULL;
				ValaSourceLocation _tmp62_;
				ValaExpression* _tmp63_;
				ValaExpression* _tmp64_;
				ValaExpression* _tmp65_;
				_tmp62_ = begin;
				_tmp63_ = expr;
				_tmp64_ = vala_parser_parse_post_increment_expression (self, &_tmp62_, _tmp63_, &_inner_error_);
				_tmp61_ = _tmp64_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (expr);
						return NULL;
					} else {
						_vala_code_node_unref0 (expr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp65_ = _tmp61_;
				_tmp61_ = NULL;
				_vala_code_node_unref0 (expr);
				expr = _tmp65_;
				_vala_code_node_unref0 (_tmp61_);
				break;
			}
			case VALA_TOKEN_TYPE_OP_DEC:
			{
				ValaExpression* _tmp66_ = NULL;
				ValaSourceLocation _tmp67_;
				ValaExpression* _tmp68_;
				ValaExpression* _tmp69_;
				ValaExpression* _tmp70_;
				_tmp67_ = begin;
				_tmp68_ = expr;
				_tmp69_ = vala_parser_parse_post_decrement_expression (self, &_tmp67_, _tmp68_, &_inner_error_);
				_tmp66_ = _tmp69_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (expr);
						return NULL;
					} else {
						_vala_code_node_unref0 (expr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp70_ = _tmp66_;
				_tmp66_ = NULL;
				_vala_code_node_unref0 (expr);
				expr = _tmp70_;
				_vala_code_node_unref0 (_tmp66_);
				break;
			}
			default:
			{
				found = FALSE;
				break;
			}
		}
	}
	result = expr;
	return result;
}


static ValaExpression*
vala_parser_parse_simple_name (ValaParser* self,
                               GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gchar* id = NULL;
	gchar* _tmp1_;
	gboolean qualified = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	ValaList* type_arg_list = NULL;
	ValaList* _tmp7_;
	ValaMemberAccess* expr = NULL;
	const gchar* _tmp8_;
	ValaSourceLocation _tmp9_;
	ValaSourceReference* _tmp10_;
	ValaSourceReference* _tmp11_;
	ValaMemberAccess* _tmp12_;
	ValaMemberAccess* _tmp13_;
	ValaMemberAccess* _tmp14_;
	gboolean _tmp15_;
	ValaList* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_identifier (self, &_inner_error_);
	id = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	qualified = FALSE;
	_tmp3_ = id;
	if (g_strcmp0 (_tmp3_, "global") == 0) {
		_tmp2_ = vala_parser_accept (self, VALA_TOKEN_TYPE_DOUBLE_COLON);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = vala_parser_parse_identifier (self, &_inner_error_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (id);
				return NULL;
			} else {
				_g_free0 (id);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp6_ = _tmp4_;
		_tmp4_ = NULL;
		_g_free0 (id);
		id = _tmp6_;
		qualified = TRUE;
		_g_free0 (_tmp4_);
	}
	_tmp7_ = vala_parser_parse_type_argument_list (self, TRUE, &_inner_error_);
	type_arg_list = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = id;
	_tmp9_ = begin;
	_tmp10_ = vala_parser_get_src (self, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_member_access_new (NULL, _tmp8_, _tmp11_);
	_tmp13_ = _tmp12_;
	_vala_source_reference_unref0 (_tmp11_);
	expr = _tmp13_;
	_tmp14_ = expr;
	_tmp15_ = qualified;
	vala_member_access_set_qualified (_tmp14_, _tmp15_);
	_tmp16_ = type_arg_list;
	if (_tmp16_ != NULL) {
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp17_;
			ValaList* _tmp18_;
			gint _type_arg_size = 0;
			ValaList* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _type_arg_index = 0;
			_tmp17_ = type_arg_list;
			_tmp18_ = _vala_iterable_ref0 (_tmp17_);
			_type_arg_list = _tmp18_;
			_tmp19_ = _type_arg_list;
			_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
			_tmp21_ = _tmp20_;
			_type_arg_size = _tmp21_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp25_;
				gint _tmp26_;
				gpointer _tmp27_;
				ValaMemberAccess* _tmp28_;
				ValaDataType* _tmp29_;
				_tmp22_ = _type_arg_index;
				_type_arg_index = _tmp22_ + 1;
				_tmp23_ = _type_arg_index;
				_tmp24_ = _type_arg_size;
				if (!(_tmp23_ < _tmp24_)) {
					break;
				}
				_tmp25_ = _type_arg_list;
				_tmp26_ = _type_arg_index;
				_tmp27_ = vala_list_get (_tmp25_, _tmp26_);
				type_arg = (ValaDataType*) _tmp27_;
				_tmp28_ = expr;
				_tmp29_ = type_arg;
				vala_member_access_add_type_argument (_tmp28_, _tmp29_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
	}
	result = (ValaExpression*) expr;
	_vala_iterable_unref0 (type_arg_list);
	_g_free0 (id);
	return result;
}


static ValaExpression*
vala_parser_parse_tuple (ValaParser* self,
                         GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaArrayList* expr_list = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	ValaArrayList* _tmp28_;
	gpointer _tmp29_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	expr_list = _tmp2_;
	if (vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_PARENS) {
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				ValaExpression* _tmp4_ = NULL;
				ValaExpression* _tmp5_;
				ValaArrayList* _tmp6_;
				if (!_tmp3_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp3_ = FALSE;
				_tmp5_ = vala_parser_parse_expression (self, &_inner_error_);
				_tmp4_ = _tmp5_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_iterable_unref0 (expr_list);
						return NULL;
					} else {
						_vala_iterable_unref0 (expr_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp6_ = expr_list;
				vala_collection_add ((ValaCollection*) _tmp6_, _tmp4_);
				_vala_code_node_unref0 (_tmp4_);
			}
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_iterable_unref0 (expr_list);
			return NULL;
		} else {
			_vala_iterable_unref0 (expr_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp7_ = expr_list;
	_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != 1) {
		ValaTuple* tuple = NULL;
		ValaSourceLocation _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaTuple* _tmp13_;
		ValaTuple* _tmp14_;
		_tmp10_ = begin;
		_tmp11_ = vala_parser_get_src (self, &_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_tuple_new (_tmp12_);
		_tmp14_ = _tmp13_;
		_vala_source_reference_unref0 (_tmp12_);
		tuple = _tmp14_;
		{
			ValaArrayList* _expr_list = NULL;
			ValaArrayList* _tmp15_;
			ValaArrayList* _tmp16_;
			gint _expr_size = 0;
			ValaArrayList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _expr_index = 0;
			_tmp15_ = expr_list;
			_tmp16_ = _vala_iterable_ref0 (_tmp15_);
			_expr_list = _tmp16_;
			_tmp17_ = _expr_list;
			_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
			_tmp19_ = _tmp18_;
			_expr_size = _tmp19_;
			_expr_index = -1;
			while (TRUE) {
				gint _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				ValaExpression* expr = NULL;
				ValaArrayList* _tmp23_;
				gint _tmp24_;
				gpointer _tmp25_;
				ValaTuple* _tmp26_;
				ValaExpression* _tmp27_;
				_tmp20_ = _expr_index;
				_expr_index = _tmp20_ + 1;
				_tmp21_ = _expr_index;
				_tmp22_ = _expr_size;
				if (!(_tmp21_ < _tmp22_)) {
					break;
				}
				_tmp23_ = _expr_list;
				_tmp24_ = _expr_index;
				_tmp25_ = vala_list_get ((ValaList*) _tmp23_, _tmp24_);
				expr = (ValaExpression*) _tmp25_;
				_tmp26_ = tuple;
				_tmp27_ = expr;
				vala_tuple_add_expression (_tmp26_, _tmp27_);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		result = (ValaExpression*) tuple;
		_vala_iterable_unref0 (expr_list);
		return result;
	}
	_tmp28_ = expr_list;
	_tmp29_ = vala_list_get ((ValaList*) _tmp28_, 0);
	result = (ValaExpression*) _tmp29_;
	_vala_iterable_unref0 (expr_list);
	return result;
}


static ValaExpression*
vala_parser_parse_template (ValaParser* self,
                            GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaTemplate* template = NULL;
	ValaTemplate* _tmp1_;
	ValaTemplate* _tmp5_;
	ValaSourceLocation _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaSourceReference* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_template_new (NULL);
	template = _tmp1_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_TEMPLATE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (template);
			return NULL;
		} else {
			_vala_code_node_unref0 (template);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaExpression* _tmp2_ = NULL;
		ValaExpression* _tmp3_;
		ValaTemplate* _tmp4_;
		if (!(vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_TEMPLATE)) {
			break;
		}
		_tmp3_ = vala_parser_parse_expression (self, &_inner_error_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (template);
				return NULL;
			} else {
				_vala_code_node_unref0 (template);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp4_ = template;
		vala_template_add_expression (_tmp4_, _tmp2_);
		vala_parser_expect (self, VALA_TOKEN_TYPE_COMMA, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (_tmp2_);
				_vala_code_node_unref0 (template);
				return NULL;
			} else {
				_vala_code_node_unref0 (_tmp2_);
				_vala_code_node_unref0 (template);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_vala_code_node_unref0 (_tmp2_);
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_TEMPLATE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (template);
			return NULL;
		} else {
			_vala_code_node_unref0 (template);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = template;
	_tmp6_ = begin;
	_tmp7_ = vala_parser_get_src (self, &_tmp6_);
	_tmp8_ = _tmp7_;
	vala_code_node_set_source_reference ((ValaCodeNode*) _tmp5_, _tmp8_);
	_vala_source_reference_unref0 (_tmp8_);
	result = (ValaExpression*) template;
	return result;
}


static ValaExpression*
vala_parser_parse_regex_literal (ValaParser* self,
                                 GError** error)
{
	ValaExpression* result = NULL;
	ValaExpression* expr = NULL;
	ValaExpression* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_REGEX_LITERAL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = vala_parser_parse_literal (self, &_inner_error_);
	expr = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = expr;
	return result;
}


static ValaExpression*
vala_parser_parse_member_access (ValaParser* self,
                                 ValaSourceLocation* begin,
                                 ValaExpression* inner,
                                 GError** error)
{
	ValaExpression* result = NULL;
	gchar* id = NULL;
	gchar* _tmp0_;
	ValaList* type_arg_list = NULL;
	ValaList* _tmp1_;
	ValaMemberAccess* expr = NULL;
	const gchar* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaMemberAccess* _tmp7_;
	ValaList* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	vala_parser_expect (self, VALA_TOKEN_TYPE_DOT, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = vala_parser_parse_identifier (self, &_inner_error_);
	id = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = vala_parser_parse_type_argument_list (self, TRUE, &_inner_error_);
	type_arg_list = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = id;
	_tmp3_ = *begin;
	_tmp4_ = vala_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_member_access_new (inner, _tmp2_, _tmp5_);
	_tmp7_ = _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	expr = _tmp7_;
	_tmp8_ = type_arg_list;
	if (_tmp8_ != NULL) {
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp9_;
			ValaList* _tmp10_;
			gint _type_arg_size = 0;
			ValaList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _type_arg_index = 0;
			_tmp9_ = type_arg_list;
			_tmp10_ = _vala_iterable_ref0 (_tmp9_);
			_type_arg_list = _tmp10_;
			_tmp11_ = _type_arg_list;
			_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			_type_arg_size = _tmp13_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp17_;
				gint _tmp18_;
				gpointer _tmp19_;
				ValaMemberAccess* _tmp20_;
				ValaDataType* _tmp21_;
				_tmp14_ = _type_arg_index;
				_type_arg_index = _tmp14_ + 1;
				_tmp15_ = _type_arg_index;
				_tmp16_ = _type_arg_size;
				if (!(_tmp15_ < _tmp16_)) {
					break;
				}
				_tmp17_ = _type_arg_list;
				_tmp18_ = _type_arg_index;
				_tmp19_ = vala_list_get (_tmp17_, _tmp18_);
				type_arg = (ValaDataType*) _tmp19_;
				_tmp20_ = expr;
				_tmp21_ = type_arg;
				vala_member_access_add_type_argument (_tmp20_, _tmp21_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
	}
	result = (ValaExpression*) expr;
	_vala_iterable_unref0 (type_arg_list);
	_g_free0 (id);
	return result;
}


static ValaExpression*
vala_parser_parse_pointer_member_access (ValaParser* self,
                                         ValaSourceLocation* begin,
                                         ValaExpression* inner,
                                         GError** error)
{
	ValaExpression* result = NULL;
	gchar* id = NULL;
	gchar* _tmp0_;
	ValaList* type_arg_list = NULL;
	ValaList* _tmp1_;
	ValaMemberAccess* expr = NULL;
	const gchar* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaMemberAccess* _tmp7_;
	ValaList* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	vala_parser_expect (self, VALA_TOKEN_TYPE_OP_PTR, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = vala_parser_parse_identifier (self, &_inner_error_);
	id = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = vala_parser_parse_type_argument_list (self, TRUE, &_inner_error_);
	type_arg_list = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = id;
	_tmp3_ = *begin;
	_tmp4_ = vala_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_member_access_new_pointer (inner, _tmp2_, _tmp5_);
	_tmp7_ = _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	expr = _tmp7_;
	_tmp8_ = type_arg_list;
	if (_tmp8_ != NULL) {
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp9_;
			ValaList* _tmp10_;
			gint _type_arg_size = 0;
			ValaList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _type_arg_index = 0;
			_tmp9_ = type_arg_list;
			_tmp10_ = _vala_iterable_ref0 (_tmp9_);
			_type_arg_list = _tmp10_;
			_tmp11_ = _type_arg_list;
			_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			_type_arg_size = _tmp13_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp17_;
				gint _tmp18_;
				gpointer _tmp19_;
				ValaMemberAccess* _tmp20_;
				ValaDataType* _tmp21_;
				_tmp14_ = _type_arg_index;
				_type_arg_index = _tmp14_ + 1;
				_tmp15_ = _type_arg_index;
				_tmp16_ = _type_arg_size;
				if (!(_tmp15_ < _tmp16_)) {
					break;
				}
				_tmp17_ = _type_arg_list;
				_tmp18_ = _type_arg_index;
				_tmp19_ = vala_list_get (_tmp17_, _tmp18_);
				type_arg = (ValaDataType*) _tmp19_;
				_tmp20_ = expr;
				_tmp21_ = type_arg;
				vala_member_access_add_type_argument (_tmp20_, _tmp21_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
	}
	result = (ValaExpression*) expr;
	_vala_iterable_unref0 (type_arg_list);
	_g_free0 (id);
	return result;
}


static ValaExpression*
vala_parser_parse_method_call (ValaParser* self,
                               ValaSourceLocation* begin,
                               ValaExpression* inner,
                               GError** error)
{
	ValaExpression* result = NULL;
	ValaList* arg_list = NULL;
	ValaList* _tmp0_;
	ValaList* init_list = NULL;
	ValaList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = vala_parser_parse_argument_list (self, &_inner_error_);
	arg_list = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_iterable_unref0 (arg_list);
			return NULL;
		} else {
			_vala_iterable_unref0 (arg_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = vala_parser_parse_object_initializer (self, &_inner_error_);
	init_list = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_iterable_unref0 (arg_list);
			return NULL;
		} else {
			_vala_iterable_unref0 (arg_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = init_list;
	_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ > 0) {
		_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (inner, VALA_TYPE_MEMBER_ACCESS);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaMemberAccess* member = NULL;
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		ValaObjectCreationExpression* expr = NULL;
		ValaMemberAccess* _tmp8_;
		ValaSourceLocation _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaObjectCreationExpression* _tmp12_;
		ValaObjectCreationExpression* _tmp13_;
		ValaObjectCreationExpression* _tmp14_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (inner, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		member = _tmp6_;
		_tmp7_ = member;
		vala_member_access_set_creation_member (_tmp7_, TRUE);
		_tmp8_ = member;
		_tmp9_ = *begin;
		_tmp10_ = vala_parser_get_src (self, &_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_object_creation_expression_new (_tmp8_, _tmp11_);
		_tmp13_ = _tmp12_;
		_vala_source_reference_unref0 (_tmp11_);
		expr = _tmp13_;
		_tmp14_ = expr;
		vala_object_creation_expression_set_struct_creation (_tmp14_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp15_;
			ValaList* _tmp16_;
			gint _arg_size = 0;
			ValaList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _arg_index = 0;
			_tmp15_ = arg_list;
			_tmp16_ = _vala_iterable_ref0 (_tmp15_);
			_arg_list = _tmp16_;
			_tmp17_ = _arg_list;
			_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
			_tmp19_ = _tmp18_;
			_arg_size = _tmp19_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				ValaExpression* arg = NULL;
				ValaList* _tmp23_;
				gint _tmp24_;
				gpointer _tmp25_;
				ValaObjectCreationExpression* _tmp26_;
				ValaExpression* _tmp27_;
				_tmp20_ = _arg_index;
				_arg_index = _tmp20_ + 1;
				_tmp21_ = _arg_index;
				_tmp22_ = _arg_size;
				if (!(_tmp21_ < _tmp22_)) {
					break;
				}
				_tmp23_ = _arg_list;
				_tmp24_ = _arg_index;
				_tmp25_ = vala_list_get (_tmp23_, _tmp24_);
				arg = (ValaExpression*) _tmp25_;
				_tmp26_ = expr;
				_tmp27_ = arg;
				vala_object_creation_expression_add_argument (_tmp26_, _tmp27_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		{
			ValaList* _initializer_list = NULL;
			ValaList* _tmp28_;
			ValaList* _tmp29_;
			gint _initializer_size = 0;
			ValaList* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gint _initializer_index = 0;
			_tmp28_ = init_list;
			_tmp29_ = _vala_iterable_ref0 (_tmp28_);
			_initializer_list = _tmp29_;
			_tmp30_ = _initializer_list;
			_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
			_tmp32_ = _tmp31_;
			_initializer_size = _tmp32_;
			_initializer_index = -1;
			while (TRUE) {
				gint _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				ValaMemberInitializer* initializer = NULL;
				ValaList* _tmp36_;
				gint _tmp37_;
				gpointer _tmp38_;
				ValaObjectCreationExpression* _tmp39_;
				ValaMemberInitializer* _tmp40_;
				_tmp33_ = _initializer_index;
				_initializer_index = _tmp33_ + 1;
				_tmp34_ = _initializer_index;
				_tmp35_ = _initializer_size;
				if (!(_tmp34_ < _tmp35_)) {
					break;
				}
				_tmp36_ = _initializer_list;
				_tmp37_ = _initializer_index;
				_tmp38_ = vala_list_get (_tmp36_, _tmp37_);
				initializer = (ValaMemberInitializer*) _tmp38_;
				_tmp39_ = expr;
				_tmp40_ = initializer;
				vala_object_creation_expression_add_member_initializer (_tmp39_, _tmp40_);
				_vala_code_node_unref0 (initializer);
			}
			_vala_iterable_unref0 (_initializer_list);
		}
		result = (ValaExpression*) expr;
		_vala_code_node_unref0 (member);
		_vala_iterable_unref0 (init_list);
		_vala_iterable_unref0 (arg_list);
		return result;
	} else {
		ValaMethodCall* expr = NULL;
		ValaSourceLocation _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaMethodCall* _tmp44_;
		ValaMethodCall* _tmp45_;
		_tmp41_ = *begin;
		_tmp42_ = vala_parser_get_src (self, &_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_method_call_new (inner, _tmp43_);
		_tmp45_ = _tmp44_;
		_vala_source_reference_unref0 (_tmp43_);
		expr = _tmp45_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp46_;
			ValaList* _tmp47_;
			gint _arg_size = 0;
			ValaList* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			gint _arg_index = 0;
			_tmp46_ = arg_list;
			_tmp47_ = _vala_iterable_ref0 (_tmp46_);
			_arg_list = _tmp47_;
			_tmp48_ = _arg_list;
			_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
			_tmp50_ = _tmp49_;
			_arg_size = _tmp50_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp51_;
				gint _tmp52_;
				gint _tmp53_;
				ValaExpression* arg = NULL;
				ValaList* _tmp54_;
				gint _tmp55_;
				gpointer _tmp56_;
				ValaMethodCall* _tmp57_;
				ValaExpression* _tmp58_;
				_tmp51_ = _arg_index;
				_arg_index = _tmp51_ + 1;
				_tmp52_ = _arg_index;
				_tmp53_ = _arg_size;
				if (!(_tmp52_ < _tmp53_)) {
					break;
				}
				_tmp54_ = _arg_list;
				_tmp55_ = _arg_index;
				_tmp56_ = vala_list_get (_tmp54_, _tmp55_);
				arg = (ValaExpression*) _tmp56_;
				_tmp57_ = expr;
				_tmp58_ = arg;
				vala_method_call_add_argument (_tmp57_, _tmp58_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		result = (ValaExpression*) expr;
		_vala_iterable_unref0 (init_list);
		_vala_iterable_unref0 (arg_list);
		return result;
	}
	_vala_iterable_unref0 (init_list);
	_vala_iterable_unref0 (arg_list);
}


static ValaExpression*
vala_parser_parse_element_access (ValaParser* self,
                                  ValaSourceLocation* begin,
                                  ValaExpression* inner,
                                  GError** error)
{
	ValaExpression* result = NULL;
	ValaList* index_list = NULL;
	ValaList* _tmp0_;
	ValaExpression* stop = NULL;
	gboolean _tmp1_ = FALSE;
	ValaList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	ValaExpression* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_BRACKET, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = vala_parser_parse_expression_list (self, &_inner_error_);
	index_list = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	stop = NULL;
	_tmp2_ = index_list;
	_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 1) {
		_tmp1_ = vala_parser_accept (self, VALA_TOKEN_TYPE_COLON);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaExpression* _tmp5_ = NULL;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_parser_parse_expression (self, &_inner_error_);
		_tmp5_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (stop);
				_vala_iterable_unref0 (index_list);
				return NULL;
			} else {
				_vala_code_node_unref0 (stop);
				_vala_iterable_unref0 (index_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp7_ = _tmp5_;
		_tmp5_ = NULL;
		_vala_code_node_unref0 (stop);
		stop = _tmp7_;
		_vala_code_node_unref0 (_tmp5_);
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (stop);
			_vala_iterable_unref0 (index_list);
			return NULL;
		} else {
			_vala_code_node_unref0 (stop);
			_vala_iterable_unref0 (index_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = stop;
	if (_tmp8_ == NULL) {
		ValaElementAccess* expr = NULL;
		ValaSourceLocation _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaElementAccess* _tmp12_;
		ValaElementAccess* _tmp13_;
		_tmp9_ = *begin;
		_tmp10_ = vala_parser_get_src (self, &_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_element_access_new (inner, _tmp11_);
		_tmp13_ = _tmp12_;
		_vala_source_reference_unref0 (_tmp11_);
		expr = _tmp13_;
		{
			ValaList* _index_list = NULL;
			ValaList* _tmp14_;
			ValaList* _tmp15_;
			gint _index_size = 0;
			ValaList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _index_index = 0;
			_tmp14_ = index_list;
			_tmp15_ = _vala_iterable_ref0 (_tmp14_);
			_index_list = _tmp15_;
			_tmp16_ = _index_list;
			_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			_index_size = _tmp18_;
			_index_index = -1;
			while (TRUE) {
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				ValaExpression* index = NULL;
				ValaList* _tmp22_;
				gint _tmp23_;
				gpointer _tmp24_;
				ValaElementAccess* _tmp25_;
				ValaExpression* _tmp26_;
				_tmp19_ = _index_index;
				_index_index = _tmp19_ + 1;
				_tmp20_ = _index_index;
				_tmp21_ = _index_size;
				if (!(_tmp20_ < _tmp21_)) {
					break;
				}
				_tmp22_ = _index_list;
				_tmp23_ = _index_index;
				_tmp24_ = vala_list_get (_tmp22_, _tmp23_);
				index = (ValaExpression*) _tmp24_;
				_tmp25_ = expr;
				_tmp26_ = index;
				vala_element_access_append_index (_tmp25_, _tmp26_);
				_vala_code_node_unref0 (index);
			}
			_vala_iterable_unref0 (_index_list);
		}
		result = (ValaExpression*) expr;
		_vala_code_node_unref0 (stop);
		_vala_iterable_unref0 (index_list);
		return result;
	} else {
		ValaList* _tmp27_;
		gpointer _tmp28_;
		ValaExpression* _tmp29_;
		ValaExpression* _tmp30_;
		ValaSourceLocation _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaSliceExpression* _tmp34_;
		ValaExpression* _tmp35_;
		_tmp27_ = index_list;
		_tmp28_ = vala_list_get (_tmp27_, 0);
		_tmp29_ = (ValaExpression*) _tmp28_;
		_tmp30_ = stop;
		_tmp31_ = *begin;
		_tmp32_ = vala_parser_get_src (self, &_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_slice_expression_new (inner, _tmp29_, _tmp30_, _tmp33_);
		_tmp35_ = (ValaExpression*) _tmp34_;
		_vala_source_reference_unref0 (_tmp33_);
		_vala_code_node_unref0 (_tmp29_);
		result = _tmp35_;
		_vala_code_node_unref0 (stop);
		_vala_iterable_unref0 (index_list);
		return result;
	}
	_vala_code_node_unref0 (stop);
	_vala_iterable_unref0 (index_list);
}


static ValaList*
vala_parser_parse_expression_list (ValaParser* self,
                                   GError** error)
{
	ValaList* result = NULL;
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	list = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			ValaExpression* _tmp3_ = NULL;
			ValaExpression* _tmp4_;
			ValaArrayList* _tmp5_;
			if (!_tmp2_) {
				if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
					break;
				}
			}
			_tmp2_ = FALSE;
			_tmp4_ = vala_parser_parse_expression (self, &_inner_error_);
			_tmp3_ = _tmp4_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_iterable_unref0 (list);
					return NULL;
				} else {
					_vala_iterable_unref0 (list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp5_ = list;
			vala_collection_add ((ValaCollection*) _tmp5_, _tmp3_);
			_vala_code_node_unref0 (_tmp3_);
		}
	}
	result = (ValaList*) list;
	return result;
}


static ValaExpression*
vala_parser_parse_this_access (ValaParser* self,
                               GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaMemberAccess* _tmp4_;
	ValaExpression* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_THIS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = begin;
	_tmp2_ = vala_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_member_access_new (NULL, "this", _tmp3_);
	_tmp5_ = (ValaExpression*) _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static ValaExpression*
vala_parser_parse_base_access (ValaParser* self,
                               GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaBaseAccess* _tmp4_;
	ValaExpression* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_BASE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = begin;
	_tmp2_ = vala_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_base_access_new (_tmp3_);
	_tmp5_ = (ValaExpression*) _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static ValaExpression*
vala_parser_parse_post_increment_expression (ValaParser* self,
                                             ValaSourceLocation* begin,
                                             ValaExpression* inner,
                                             GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaPostfixExpression* _tmp3_;
	ValaExpression* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	vala_parser_expect (self, VALA_TOKEN_TYPE_OP_INC, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = *begin;
	_tmp1_ = vala_parser_get_src (self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_postfix_expression_new (inner, TRUE, _tmp2_);
	_tmp4_ = (ValaExpression*) _tmp3_;
	_vala_source_reference_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static ValaExpression*
vala_parser_parse_post_decrement_expression (ValaParser* self,
                                             ValaSourceLocation* begin,
                                             ValaExpression* inner,
                                             GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaPostfixExpression* _tmp3_;
	ValaExpression* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	vala_parser_expect (self, VALA_TOKEN_TYPE_OP_DEC, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = *begin;
	_tmp1_ = vala_parser_get_src (self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_postfix_expression_new (inner, FALSE, _tmp2_);
	_tmp4_ = (ValaExpression*) _tmp3_;
	_vala_source_reference_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static ValaExpression*
vala_parser_parse_object_or_array_creation_expression (ValaParser* self,
                                                       GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaMemberAccess* member = NULL;
	ValaMemberAccess* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_NEW, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vala_parser_is_inner_array_type (self)) {
		ValaSourceLocation _tmp1_;
		ValaExpression* _tmp2_ = NULL;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp1_ = begin;
		vala_parser_rollback (self, &_tmp1_);
		_tmp3_ = vala_parser_parse_array_creation_expression (self, &_inner_error_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		result = _tmp4_;
		_vala_code_node_unref0 (_tmp2_);
		return result;
	}
	_tmp5_ = vala_parser_parse_member_name (self, NULL, &_inner_error_);
	member = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_OPEN_PARENS)) {
		ValaExpression* expr = NULL;
		ValaSourceLocation _tmp6_;
		ValaMemberAccess* _tmp7_;
		ValaExpression* _tmp8_;
		_tmp6_ = begin;
		_tmp7_ = member;
		_tmp8_ = vala_parser_parse_object_creation_expression (self, &_tmp6_, _tmp7_, &_inner_error_);
		expr = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (member);
				return NULL;
			} else {
				_vala_code_node_unref0 (member);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = expr;
		_vala_code_node_unref0 (member);
		return result;
	} else {
		gboolean is_pointer_type = FALSE;
		gboolean _tmp9_;
		is_pointer_type = FALSE;
		while (TRUE) {
			if (!vala_parser_accept (self, VALA_TOKEN_TYPE_STAR)) {
				break;
			}
			is_pointer_type = TRUE;
		}
		_tmp9_ = is_pointer_type;
		if (!_tmp9_) {
			vala_parser_accept (self, VALA_TOKEN_TYPE_INTERR);
		}
		if (vala_parser_accept (self, VALA_TOKEN_TYPE_OPEN_BRACKET)) {
			ValaSourceLocation _tmp10_;
			ValaExpression* expr = NULL;
			ValaExpression* _tmp11_;
			_tmp10_ = begin;
			vala_parser_rollback (self, &_tmp10_);
			_tmp11_ = vala_parser_parse_array_creation_expression (self, &_inner_error_);
			expr = _tmp11_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (member);
					return NULL;
				} else {
					_vala_code_node_unref0 (member);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			result = expr;
			_vala_code_node_unref0 (member);
			return result;
		} else {
			GError* _tmp12_;
			_tmp12_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected ( or [");
			_inner_error_ = _tmp12_;
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (member);
				return NULL;
			} else {
				_vala_code_node_unref0 (member);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_vala_code_node_unref0 (member);
}


static ValaExpression*
vala_parser_parse_object_creation_expression (ValaParser* self,
                                              ValaSourceLocation* begin,
                                              ValaMemberAccess* member,
                                              GError** error)
{
	ValaExpression* result = NULL;
	ValaList* arg_list = NULL;
	ValaList* _tmp0_;
	ValaList* init_list = NULL;
	ValaList* _tmp1_;
	ValaObjectCreationExpression* expr = NULL;
	ValaSourceLocation _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaObjectCreationExpression* _tmp5_;
	ValaObjectCreationExpression* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	g_return_val_if_fail (member != NULL, NULL);
	vala_member_access_set_creation_member (member, TRUE);
	_tmp0_ = vala_parser_parse_argument_list (self, &_inner_error_);
	arg_list = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_iterable_unref0 (arg_list);
			return NULL;
		} else {
			_vala_iterable_unref0 (arg_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = vala_parser_parse_object_initializer (self, &_inner_error_);
	init_list = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_iterable_unref0 (arg_list);
			return NULL;
		} else {
			_vala_iterable_unref0 (arg_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = *begin;
	_tmp3_ = vala_parser_get_src (self, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_object_creation_expression_new (member, _tmp4_);
	_tmp6_ = _tmp5_;
	_vala_source_reference_unref0 (_tmp4_);
	expr = _tmp6_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp7_;
		ValaList* _tmp8_;
		gint _arg_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _arg_index = 0;
		_tmp7_ = arg_list;
		_tmp8_ = _vala_iterable_ref0 (_tmp7_);
		_arg_list = _tmp8_;
		_tmp9_ = _arg_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_arg_size = _tmp11_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			ValaExpression* arg = NULL;
			ValaList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_;
			ValaObjectCreationExpression* _tmp18_;
			ValaExpression* _tmp19_;
			_tmp12_ = _arg_index;
			_arg_index = _tmp12_ + 1;
			_tmp13_ = _arg_index;
			_tmp14_ = _arg_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _arg_list;
			_tmp16_ = _arg_index;
			_tmp17_ = vala_list_get (_tmp15_, _tmp16_);
			arg = (ValaExpression*) _tmp17_;
			_tmp18_ = expr;
			_tmp19_ = arg;
			vala_object_creation_expression_add_argument (_tmp18_, _tmp19_);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _initializer_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _initializer_index = 0;
		_tmp20_ = init_list;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_initializer_list = _tmp21_;
		_tmp22_ = _initializer_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_initializer_size = _tmp24_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			ValaMemberInitializer* initializer = NULL;
			ValaList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			ValaObjectCreationExpression* _tmp31_;
			ValaMemberInitializer* _tmp32_;
			_tmp25_ = _initializer_index;
			_initializer_index = _tmp25_ + 1;
			_tmp26_ = _initializer_index;
			_tmp27_ = _initializer_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _initializer_list;
			_tmp29_ = _initializer_index;
			_tmp30_ = vala_list_get (_tmp28_, _tmp29_);
			initializer = (ValaMemberInitializer*) _tmp30_;
			_tmp31_ = expr;
			_tmp32_ = initializer;
			vala_object_creation_expression_add_member_initializer (_tmp31_, _tmp32_);
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = (ValaExpression*) expr;
	_vala_iterable_unref0 (init_list);
	_vala_iterable_unref0 (arg_list);
	return result;
}


static ValaExpression*
vala_parser_parse_array_creation_expression (ValaParser* self,
                                             GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gboolean inner_array_type = FALSE;
	gboolean _tmp1_;
	ValaMemberAccess* member = NULL;
	ValaMemberAccess* _tmp2_;
	ValaDataType* element_type = NULL;
	ValaMemberAccess* _tmp3_;
	ValaUnresolvedType* _tmp4_;
	gboolean is_pointer_type = FALSE;
	gboolean _tmp10_;
	gboolean _tmp12_;
	gboolean size_specified = FALSE;
	ValaList* size_specifier_list = NULL;
	gboolean first = FALSE;
	ValaInitializerList* initializer = NULL;
	ValaArrayCreationExpression* expr = NULL;
	ValaDataType* _tmp39_;
	ValaList* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	ValaInitializerList* _tmp43_;
	ValaSourceLocation _tmp44_;
	ValaSourceReference* _tmp45_;
	ValaSourceReference* _tmp46_;
	ValaArrayCreationExpression* _tmp47_;
	ValaArrayCreationExpression* _tmp48_;
	gboolean _tmp49_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_NEW, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	inner_array_type = vala_parser_is_inner_array_type (self);
	_tmp1_ = inner_array_type;
	if (_tmp1_) {
		vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_UNOWNED, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp2_ = vala_parser_parse_member_name (self, NULL, &_inner_error_);
	member = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = member;
	_tmp4_ = vala_unresolved_type_new_from_expression ((ValaExpression*) _tmp3_);
	element_type = (ValaDataType*) _tmp4_;
	is_pointer_type = FALSE;
	while (TRUE) {
		ValaDataType* _tmp5_;
		ValaSourceLocation _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaPointerType* _tmp9_;
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_STAR)) {
			break;
		}
		_tmp5_ = element_type;
		_tmp6_ = begin;
		_tmp7_ = vala_parser_get_src (self, &_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_pointer_type_new (_tmp5_, _tmp8_);
		_vala_code_node_unref0 (element_type);
		element_type = (ValaDataType*) _tmp9_;
		_vala_source_reference_unref0 (_tmp8_);
		is_pointer_type = TRUE;
	}
	_tmp10_ = is_pointer_type;
	if (!_tmp10_) {
		if (vala_parser_accept (self, VALA_TOKEN_TYPE_INTERR)) {
			ValaDataType* _tmp11_;
			_tmp11_ = element_type;
			vala_data_type_set_nullable (_tmp11_, TRUE);
		}
	}
	_tmp12_ = inner_array_type;
	if (_tmp12_) {
		ValaDataType* _tmp13_;
		vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (element_type);
				_vala_code_node_unref0 (member);
				return NULL;
			} else {
				_vala_code_node_unref0 (element_type);
				_vala_code_node_unref0 (member);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp13_ = element_type;
		vala_data_type_set_value_owned (_tmp13_, FALSE);
	} else {
		ValaDataType* _tmp14_;
		_tmp14_ = element_type;
		vala_data_type_set_value_owned (_tmp14_, TRUE);
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_BRACKET, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (element_type);
			_vala_code_node_unref0 (member);
			return NULL;
		} else {
			_vala_code_node_unref0 (element_type);
			_vala_code_node_unref0 (member);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	size_specified = FALSE;
	size_specifier_list = NULL;
	first = TRUE;
	{
		gboolean _tmp15_ = FALSE;
		_tmp15_ = TRUE;
		while (TRUE) {
			gboolean _tmp16_;
			GEqualFunc _tmp27_;
			ValaArrayList* _tmp28_;
			if (!_tmp15_) {
				if (!vala_parser_accept (self, VALA_TOKEN_TYPE_OPEN_BRACKET)) {
					break;
				}
			}
			_tmp15_ = FALSE;
			_tmp16_ = first;
			if (!_tmp16_) {
				gboolean _tmp17_;
				ValaDataType* _tmp19_;
				ValaList* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				ValaDataType* _tmp23_;
				ValaSourceReference* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaArrayType* _tmp26_;
				_tmp17_ = size_specified;
				if (_tmp17_) {
					GError* _tmp18_;
					_tmp18_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "size of inner arrays must not be specified in array creation expressio" \
"n");
					_inner_error_ = _tmp18_;
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_iterable_unref0 (size_specifier_list);
						_vala_code_node_unref0 (element_type);
						_vala_code_node_unref0 (member);
						return NULL;
					} else {
						_vala_iterable_unref0 (size_specifier_list);
						_vala_code_node_unref0 (element_type);
						_vala_code_node_unref0 (member);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp19_ = element_type;
				_tmp20_ = size_specifier_list;
				_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = element_type;
				_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_array_type_new (_tmp19_, _tmp22_, _tmp25_);
				_vala_code_node_unref0 (element_type);
				element_type = (ValaDataType*) _tmp26_;
			} else {
				first = FALSE;
			}
			_tmp27_ = g_direct_equal;
			_tmp28_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp27_);
			_vala_iterable_unref0 (size_specifier_list);
			size_specifier_list = (ValaList*) _tmp28_;
			{
				gboolean _tmp29_ = FALSE;
				_tmp29_ = TRUE;
				while (TRUE) {
					ValaExpression* size = NULL;
					gboolean _tmp30_ = FALSE;
					ValaList* _tmp34_;
					ValaExpression* _tmp35_;
					if (!_tmp29_) {
						if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
							break;
						}
					}
					_tmp29_ = FALSE;
					size = NULL;
					if (vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_BRACKET) {
						_tmp30_ = vala_parser_current (self) != VALA_TOKEN_TYPE_COMMA;
					} else {
						_tmp30_ = FALSE;
					}
					if (_tmp30_) {
						ValaExpression* _tmp31_ = NULL;
						ValaExpression* _tmp32_;
						ValaExpression* _tmp33_;
						_tmp32_ = vala_parser_parse_expression (self, &_inner_error_);
						_tmp31_ = _tmp32_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								_vala_code_node_unref0 (size);
								_vala_iterable_unref0 (size_specifier_list);
								_vala_code_node_unref0 (element_type);
								_vala_code_node_unref0 (member);
								return NULL;
							} else {
								_vala_code_node_unref0 (size);
								_vala_iterable_unref0 (size_specifier_list);
								_vala_code_node_unref0 (element_type);
								_vala_code_node_unref0 (member);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_tmp33_ = _tmp31_;
						_tmp31_ = NULL;
						_vala_code_node_unref0 (size);
						size = _tmp33_;
						size_specified = TRUE;
						_vala_code_node_unref0 (_tmp31_);
					}
					_tmp34_ = size_specifier_list;
					_tmp35_ = size;
					vala_collection_add ((ValaCollection*) _tmp34_, _tmp35_);
					_vala_code_node_unref0 (size);
				}
			}
			vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_iterable_unref0 (size_specifier_list);
					_vala_code_node_unref0 (element_type);
					_vala_code_node_unref0 (member);
					return NULL;
				} else {
					_vala_iterable_unref0 (size_specifier_list);
					_vala_code_node_unref0 (element_type);
					_vala_code_node_unref0 (member);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	initializer = NULL;
	if (vala_parser_current (self) == VALA_TOKEN_TYPE_OPEN_BRACE) {
		ValaInitializerList* _tmp36_ = NULL;
		ValaInitializerList* _tmp37_;
		ValaInitializerList* _tmp38_;
		_tmp37_ = vala_parser_parse_initializer (self, &_inner_error_);
		_tmp36_ = _tmp37_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (size_specifier_list);
				_vala_code_node_unref0 (element_type);
				_vala_code_node_unref0 (member);
				return NULL;
			} else {
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (size_specifier_list);
				_vala_code_node_unref0 (element_type);
				_vala_code_node_unref0 (member);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp38_ = _tmp36_;
		_tmp36_ = NULL;
		_vala_code_node_unref0 (initializer);
		initializer = _tmp38_;
		_vala_code_node_unref0 (_tmp36_);
	}
	_tmp39_ = element_type;
	_tmp40_ = size_specifier_list;
	_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = initializer;
	_tmp44_ = begin;
	_tmp45_ = vala_parser_get_src (self, &_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_array_creation_expression_new (_tmp39_, _tmp42_, _tmp43_, _tmp46_);
	_tmp48_ = _tmp47_;
	_vala_source_reference_unref0 (_tmp46_);
	expr = _tmp48_;
	_tmp49_ = size_specified;
	if (_tmp49_) {
		{
			ValaList* _size_list = NULL;
			ValaList* _tmp50_;
			ValaList* _tmp51_;
			gint _size_size = 0;
			ValaList* _tmp52_;
			gint _tmp53_;
			gint _tmp54_;
			gint _size_index = 0;
			_tmp50_ = size_specifier_list;
			_tmp51_ = _vala_iterable_ref0 (_tmp50_);
			_size_list = _tmp51_;
			_tmp52_ = _size_list;
			_tmp53_ = vala_collection_get_size ((ValaCollection*) _tmp52_);
			_tmp54_ = _tmp53_;
			_size_size = _tmp54_;
			_size_index = -1;
			while (TRUE) {
				gint _tmp55_;
				gint _tmp56_;
				gint _tmp57_;
				ValaExpression* size = NULL;
				ValaList* _tmp58_;
				gint _tmp59_;
				gpointer _tmp60_;
				ValaArrayCreationExpression* _tmp61_;
				ValaExpression* _tmp62_;
				_tmp55_ = _size_index;
				_size_index = _tmp55_ + 1;
				_tmp56_ = _size_index;
				_tmp57_ = _size_size;
				if (!(_tmp56_ < _tmp57_)) {
					break;
				}
				_tmp58_ = _size_list;
				_tmp59_ = _size_index;
				_tmp60_ = vala_list_get (_tmp58_, _tmp59_);
				size = (ValaExpression*) _tmp60_;
				_tmp61_ = expr;
				_tmp62_ = size;
				vala_array_creation_expression_append_size (_tmp61_, _tmp62_);
				_vala_code_node_unref0 (size);
			}
			_vala_iterable_unref0 (_size_list);
		}
	}
	result = (ValaExpression*) expr;
	_vala_code_node_unref0 (initializer);
	_vala_iterable_unref0 (size_specifier_list);
	_vala_code_node_unref0 (element_type);
	_vala_code_node_unref0 (member);
	return result;
}


static ValaList*
vala_parser_parse_object_initializer (ValaParser* self,
                                      GError** error)
{
	ValaList* result = NULL;
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	list = _tmp1_;
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_OPEN_BRACE)) {
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ValaMemberInitializer* _tmp3_ = NULL;
				ValaMemberInitializer* _tmp4_;
				ValaArrayList* _tmp5_;
				if (!_tmp2_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp2_ = FALSE;
				_tmp4_ = vala_parser_parse_member_initializer (self, &_inner_error_);
				_tmp3_ = _tmp4_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_iterable_unref0 (list);
						return NULL;
					} else {
						_vala_iterable_unref0 (list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp5_ = list;
				vala_collection_add ((ValaCollection*) _tmp5_, _tmp3_);
				_vala_code_node_unref0 (_tmp3_);
			}
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_iterable_unref0 (list);
				return NULL;
			} else {
				_vala_iterable_unref0 (list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = (ValaList*) list;
	return result;
}


static ValaMemberInitializer*
vala_parser_parse_member_initializer (ValaParser* self,
                                      GError** error)
{
	ValaMemberInitializer* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gchar* id = NULL;
	gchar* _tmp1_;
	ValaExpression* expr = NULL;
	ValaExpression* _tmp2_;
	const gchar* _tmp3_;
	ValaExpression* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaMemberInitializer* _tmp8_;
	ValaMemberInitializer* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_identifier (self, &_inner_error_);
	id = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_ASSIGN, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = vala_parser_parse_expression (self, &_inner_error_);
	expr = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = id;
	_tmp4_ = expr;
	_tmp5_ = begin;
	_tmp6_ = vala_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_member_initializer_new (_tmp3_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_vala_source_reference_unref0 (_tmp7_);
	result = _tmp9_;
	_vala_code_node_unref0 (expr);
	_g_free0 (id);
	return result;
}


static ValaExpression*
vala_parser_parse_yield_expression (ValaParser* self,
                                    GError** error)
{
	ValaExpression* result = NULL;
	ValaExpression* expr = NULL;
	ValaExpression* _tmp0_;
	ValaMethodCall* call = NULL;
	ValaExpression* _tmp1_;
	ValaMethodCall* _tmp2_;
	ValaObjectCreationExpression* object_creation = NULL;
	ValaExpression* _tmp3_;
	ValaObjectCreationExpression* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodCall* _tmp6_;
	ValaMethodCall* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_expect (self, VALA_TOKEN_TYPE_YIELD, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = vala_parser_parse_expression (self, &_inner_error_);
	expr = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = expr;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_METHOD_CALL) ? ((ValaMethodCall*) _tmp1_) : NULL);
	call = _tmp2_;
	_tmp3_ = expr;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_OBJECT_CREATION_EXPRESSION) ? ((ValaObjectCreationExpression*) _tmp3_) : NULL);
	object_creation = _tmp4_;
	_tmp6_ = call;
	if (_tmp6_ == NULL) {
		ValaObjectCreationExpression* _tmp7_;
		_tmp7_ = object_creation;
		_tmp5_ = _tmp7_ == NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaExpression* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		GError* _tmp11_;
		_tmp8_ = expr;
		_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp8_);
		_tmp10_ = _tmp9_;
		vala_report_error (_tmp10_, "syntax error, expected method call");
		_tmp11_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected method call");
		_inner_error_ = _tmp11_;
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (object_creation);
			_vala_code_node_unref0 (call);
			_vala_code_node_unref0 (expr);
			return NULL;
		} else {
			_vala_code_node_unref0 (object_creation);
			_vala_code_node_unref0 (call);
			_vala_code_node_unref0 (expr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp12_ = call;
	if (_tmp12_ != NULL) {
		ValaMethodCall* _tmp13_;
		_tmp13_ = call;
		vala_method_call_set_is_yield_expression (_tmp13_, TRUE);
	} else {
		ValaObjectCreationExpression* _tmp14_;
		_tmp14_ = object_creation;
		if (_tmp14_ != NULL) {
			ValaObjectCreationExpression* _tmp15_;
			_tmp15_ = object_creation;
			vala_object_creation_expression_set_is_yield_expression (_tmp15_, TRUE);
		}
	}
	result = expr;
	_vala_code_node_unref0 (object_creation);
	_vala_code_node_unref0 (call);
	return result;
}


static ValaExpression*
vala_parser_parse_sizeof_expression (ValaParser* self,
                                     GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaDataType* type = NULL;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSizeofExpression* _tmp6_;
	ValaExpression* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_SIZEOF, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = vala_parser_parse_type (self, TRUE, FALSE, FALSE, &_inner_error_);
	type = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = type;
	_tmp3_ = begin;
	_tmp4_ = vala_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_sizeof_expression_new (_tmp2_, _tmp5_);
	_tmp7_ = (ValaExpression*) _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	result = _tmp7_;
	_vala_code_node_unref0 (type);
	return result;
}


static ValaExpression*
vala_parser_parse_typeof_expression (ValaParser* self,
                                     GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaDataType* type = NULL;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaTypeofExpression* _tmp6_;
	ValaExpression* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_TYPEOF, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = vala_parser_parse_type (self, TRUE, FALSE, FALSE, &_inner_error_);
	type = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = type;
	_tmp3_ = begin;
	_tmp4_ = vala_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_typeof_expression_new (_tmp2_, _tmp5_);
	_tmp7_ = (ValaExpression*) _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	result = _tmp7_;
	_vala_code_node_unref0 (type);
	return result;
}


static ValaUnaryOperator
vala_parser_get_unary_operator (ValaParser* self,
                                ValaTokenType token_type)
{
	ValaUnaryOperator result = 0;
	g_return_val_if_fail (self != NULL, 0);
	switch (token_type) {
		case VALA_TOKEN_TYPE_PLUS:
		{
			result = VALA_UNARY_OPERATOR_PLUS;
			return result;
		}
		case VALA_TOKEN_TYPE_MINUS:
		{
			result = VALA_UNARY_OPERATOR_MINUS;
			return result;
		}
		case VALA_TOKEN_TYPE_OP_NEG:
		{
			result = VALA_UNARY_OPERATOR_LOGICAL_NEGATION;
			return result;
		}
		case VALA_TOKEN_TYPE_TILDE:
		{
			result = VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT;
			return result;
		}
		case VALA_TOKEN_TYPE_OP_INC:
		{
			result = VALA_UNARY_OPERATOR_INCREMENT;
			return result;
		}
		case VALA_TOKEN_TYPE_OP_DEC:
		{
			result = VALA_UNARY_OPERATOR_DECREMENT;
			return result;
		}
		default:
		{
			result = VALA_UNARY_OPERATOR_NONE;
			return result;
		}
	}
}


static ValaExpression*
vala_parser_parse_unary_expression (ValaParser* self,
                                    GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaUnaryOperator operator = 0;
	ValaUnaryOperator _tmp1_;
	ValaExpression* expr = NULL;
	ValaExpression* _tmp104_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	operator = vala_parser_get_unary_operator (self, vala_parser_current (self));
	_tmp1_ = operator;
	if (_tmp1_ != VALA_UNARY_OPERATOR_NONE) {
		ValaExpression* op = NULL;
		ValaExpression* _tmp2_;
		ValaIntegerLiteral* lit = NULL;
		ValaExpression* _tmp3_;
		ValaIntegerLiteral* _tmp4_;
		ValaIntegerLiteral* _tmp5_;
		ValaUnaryOperator _tmp18_;
		ValaExpression* _tmp19_;
		ValaSourceLocation _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaUnaryExpression* _tmp23_;
		ValaExpression* _tmp24_;
		vala_parser_next (self);
		_tmp2_ = vala_parser_parse_unary_expression (self, &_inner_error_);
		op = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp3_ = op;
		_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_INTEGER_LITERAL) ? ((ValaIntegerLiteral*) _tmp3_) : NULL);
		lit = _tmp4_;
		_tmp5_ = lit;
		if (_tmp5_ != NULL) {
			ValaUnaryOperator _tmp6_;
			_tmp6_ = operator;
			if (_tmp6_ == VALA_UNARY_OPERATOR_PLUS) {
				result = (ValaExpression*) lit;
				_vala_code_node_unref0 (op);
				return result;
			} else {
				ValaUnaryOperator _tmp7_;
				_tmp7_ = operator;
				if (_tmp7_ == VALA_UNARY_OPERATOR_MINUS) {
					ValaIntegerLiteral* _tmp8_;
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					ValaSourceLocation _tmp13_;
					ValaSourceReference* _tmp14_;
					ValaSourceReference* _tmp15_;
					ValaIntegerLiteral* _tmp16_;
					ValaExpression* _tmp17_;
					_tmp8_ = lit;
					_tmp9_ = vala_integer_literal_get_value (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = g_strconcat ("-", _tmp10_, NULL);
					_tmp12_ = _tmp11_;
					_tmp13_ = begin;
					_tmp14_ = vala_parser_get_src (self, &_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = vala_integer_literal_new (_tmp12_, _tmp15_);
					_tmp17_ = (ValaExpression*) _tmp16_;
					_vala_source_reference_unref0 (_tmp15_);
					_g_free0 (_tmp12_);
					result = _tmp17_;
					_vala_code_node_unref0 (lit);
					_vala_code_node_unref0 (op);
					return result;
				}
			}
		}
		_tmp18_ = operator;
		_tmp19_ = op;
		_tmp20_ = begin;
		_tmp21_ = vala_parser_get_src (self, &_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_unary_expression_new (_tmp18_, _tmp19_, _tmp22_);
		_tmp24_ = (ValaExpression*) _tmp23_;
		_vala_source_reference_unref0 (_tmp22_);
		result = _tmp24_;
		_vala_code_node_unref0 (lit);
		_vala_code_node_unref0 (op);
		return result;
	}
	switch (vala_parser_current (self)) {
		case VALA_TOKEN_TYPE_HASH:
		{
			ValaCodeContext* _tmp25_;
			gboolean _tmp26_;
			gboolean _tmp27_;
			ValaExpression* op = NULL;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaSourceLocation _tmp32_;
			ValaSourceReference* _tmp33_;
			ValaSourceReference* _tmp34_;
			ValaReferenceTransferExpression* _tmp35_;
			ValaExpression* _tmp36_;
			_tmp25_ = self->priv->context;
			_tmp26_ = vala_code_context_get_deprecated (_tmp25_);
			_tmp27_ = _tmp26_;
			if (!_tmp27_) {
				ValaSourceReference* _tmp28_;
				ValaSourceReference* _tmp29_;
				_tmp28_ = vala_parser_get_last_src (self);
				_tmp29_ = _tmp28_;
				vala_report_warning (_tmp29_, "deprecated syntax, use `(owned)` cast");
				_vala_source_reference_unref0 (_tmp29_);
			}
			vala_parser_next (self);
			_tmp30_ = vala_parser_parse_unary_expression (self, &_inner_error_);
			op = _tmp30_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp31_ = op;
			_tmp32_ = begin;
			_tmp33_ = vala_parser_get_src (self, &_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_reference_transfer_expression_new (_tmp31_, _tmp34_);
			_tmp36_ = (ValaExpression*) _tmp35_;
			_vala_source_reference_unref0 (_tmp34_);
			result = _tmp36_;
			_vala_code_node_unref0 (op);
			return result;
		}
		case VALA_TOKEN_TYPE_OPEN_PARENS:
		{
			ValaSourceLocation _tmp89_;
			vala_parser_next (self);
			switch (vala_parser_current (self)) {
				case VALA_TOKEN_TYPE_UNOWNED:
				{
					break;
				}
				case VALA_TOKEN_TYPE_OWNED:
				{
					vala_parser_next (self);
					if (vala_parser_accept (self, VALA_TOKEN_TYPE_CLOSE_PARENS)) {
						ValaExpression* op = NULL;
						ValaExpression* _tmp37_;
						ValaExpression* _tmp38_;
						ValaSourceLocation _tmp39_;
						ValaSourceReference* _tmp40_;
						ValaSourceReference* _tmp41_;
						ValaReferenceTransferExpression* _tmp42_;
						ValaExpression* _tmp43_;
						_tmp37_ = vala_parser_parse_unary_expression (self, &_inner_error_);
						op = _tmp37_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								return NULL;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_tmp38_ = op;
						_tmp39_ = begin;
						_tmp40_ = vala_parser_get_src (self, &_tmp39_);
						_tmp41_ = _tmp40_;
						_tmp42_ = vala_reference_transfer_expression_new (_tmp38_, _tmp41_);
						_tmp43_ = (ValaExpression*) _tmp42_;
						_vala_source_reference_unref0 (_tmp41_);
						result = _tmp43_;
						_vala_code_node_unref0 (op);
						return result;
					}
					break;
				}
				case VALA_TOKEN_TYPE_VOID:
				case VALA_TOKEN_TYPE_DYNAMIC:
				case VALA_TOKEN_TYPE_OPEN_PARENS:
				case VALA_TOKEN_TYPE_IDENTIFIER:
				{
					gboolean _tmp44_ = FALSE;
					if (vala_parser_current (self) != VALA_TOKEN_TYPE_OPEN_PARENS) {
						_tmp44_ = TRUE;
					} else {
						_tmp44_ = vala_parser_is_inner_array_type (self);
					}
					if (_tmp44_) {
						ValaDataType* type = NULL;
						ValaDataType* _tmp45_;
						_tmp45_ = vala_parser_parse_type (self, TRUE, FALSE, FALSE, &_inner_error_);
						type = _tmp45_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								return NULL;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						if (vala_parser_accept (self, VALA_TOKEN_TYPE_CLOSE_PARENS)) {
							switch (vala_parser_current (self)) {
								case VALA_TOKEN_TYPE_OP_NEG:
								case VALA_TOKEN_TYPE_TILDE:
								case VALA_TOKEN_TYPE_OPEN_PARENS:
								case VALA_TOKEN_TYPE_TRUE:
								case VALA_TOKEN_TYPE_FALSE:
								case VALA_TOKEN_TYPE_INTEGER_LITERAL:
								case VALA_TOKEN_TYPE_REAL_LITERAL:
								case VALA_TOKEN_TYPE_CHARACTER_LITERAL:
								case VALA_TOKEN_TYPE_STRING_LITERAL:
								case VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL:
								case VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL:
								case VALA_TOKEN_TYPE_REGEX_LITERAL:
								case VALA_TOKEN_TYPE_NULL:
								case VALA_TOKEN_TYPE_THIS:
								case VALA_TOKEN_TYPE_BASE:
								case VALA_TOKEN_TYPE_NEW:
								case VALA_TOKEN_TYPE_YIELD:
								case VALA_TOKEN_TYPE_SIZEOF:
								case VALA_TOKEN_TYPE_TYPEOF:
								case VALA_TOKEN_TYPE_IDENTIFIER:
								case VALA_TOKEN_TYPE_PARAMS:
								{
									ValaExpression* inner = NULL;
									ValaExpression* _tmp46_;
									ValaExpression* _tmp47_;
									ValaDataType* _tmp48_;
									ValaSourceLocation _tmp49_;
									ValaSourceReference* _tmp50_;
									ValaSourceReference* _tmp51_;
									ValaCastExpression* _tmp52_;
									ValaExpression* _tmp53_;
									_tmp46_ = vala_parser_parse_unary_expression (self, &_inner_error_);
									inner = _tmp46_;
									if (G_UNLIKELY (_inner_error_ != NULL)) {
										if (_inner_error_->domain == VALA_PARSE_ERROR) {
											g_propagate_error (error, _inner_error_);
											_vala_code_node_unref0 (type);
											return NULL;
										} else {
											_vala_code_node_unref0 (type);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return NULL;
										}
									}
									_tmp47_ = inner;
									_tmp48_ = type;
									_tmp49_ = begin;
									_tmp50_ = vala_parser_get_src (self, &_tmp49_);
									_tmp51_ = _tmp50_;
									_tmp52_ = vala_cast_expression_new (_tmp47_, _tmp48_, _tmp51_);
									_tmp53_ = (ValaExpression*) _tmp52_;
									_vala_source_reference_unref0 (_tmp51_);
									result = _tmp53_;
									_vala_code_node_unref0 (inner);
									_vala_code_node_unref0 (type);
									return result;
								}
								case VALA_TOKEN_TYPE_STAR:
								{
									ValaExpression* op = NULL;
									ValaExpression* _tmp54_;
									ValaPointerIndirection* inner = NULL;
									ValaExpression* _tmp55_;
									ValaSourceLocation _tmp56_;
									ValaSourceReference* _tmp57_;
									ValaSourceReference* _tmp58_;
									ValaPointerIndirection* _tmp59_;
									ValaPointerIndirection* _tmp60_;
									ValaPointerIndirection* _tmp61_;
									ValaDataType* _tmp62_;
									ValaSourceLocation _tmp63_;
									ValaSourceReference* _tmp64_;
									ValaSourceReference* _tmp65_;
									ValaCastExpression* _tmp66_;
									ValaExpression* _tmp67_;
									vala_parser_next (self);
									_tmp54_ = vala_parser_parse_unary_expression (self, &_inner_error_);
									op = _tmp54_;
									if (G_UNLIKELY (_inner_error_ != NULL)) {
										if (_inner_error_->domain == VALA_PARSE_ERROR) {
											g_propagate_error (error, _inner_error_);
											_vala_code_node_unref0 (type);
											return NULL;
										} else {
											_vala_code_node_unref0 (type);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return NULL;
										}
									}
									_tmp55_ = op;
									_tmp56_ = begin;
									_tmp57_ = vala_parser_get_src (self, &_tmp56_);
									_tmp58_ = _tmp57_;
									_tmp59_ = vala_pointer_indirection_new (_tmp55_, _tmp58_);
									_tmp60_ = _tmp59_;
									_vala_source_reference_unref0 (_tmp58_);
									inner = _tmp60_;
									_tmp61_ = inner;
									_tmp62_ = type;
									_tmp63_ = begin;
									_tmp64_ = vala_parser_get_src (self, &_tmp63_);
									_tmp65_ = _tmp64_;
									_tmp66_ = vala_cast_expression_new ((ValaExpression*) _tmp61_, _tmp62_, _tmp65_);
									_tmp67_ = (ValaExpression*) _tmp66_;
									_vala_source_reference_unref0 (_tmp65_);
									result = _tmp67_;
									_vala_code_node_unref0 (inner);
									_vala_code_node_unref0 (op);
									_vala_code_node_unref0 (type);
									return result;
								}
								case VALA_TOKEN_TYPE_BITWISE_AND:
								{
									ValaExpression* op = NULL;
									ValaExpression* _tmp68_;
									ValaAddressofExpression* inner = NULL;
									ValaExpression* _tmp69_;
									ValaSourceLocation _tmp70_;
									ValaSourceReference* _tmp71_;
									ValaSourceReference* _tmp72_;
									ValaAddressofExpression* _tmp73_;
									ValaAddressofExpression* _tmp74_;
									ValaAddressofExpression* _tmp75_;
									ValaDataType* _tmp76_;
									ValaSourceLocation _tmp77_;
									ValaSourceReference* _tmp78_;
									ValaSourceReference* _tmp79_;
									ValaCastExpression* _tmp80_;
									ValaExpression* _tmp81_;
									vala_parser_next (self);
									_tmp68_ = vala_parser_parse_unary_expression (self, &_inner_error_);
									op = _tmp68_;
									if (G_UNLIKELY (_inner_error_ != NULL)) {
										if (_inner_error_->domain == VALA_PARSE_ERROR) {
											g_propagate_error (error, _inner_error_);
											_vala_code_node_unref0 (type);
											return NULL;
										} else {
											_vala_code_node_unref0 (type);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return NULL;
										}
									}
									_tmp69_ = op;
									_tmp70_ = begin;
									_tmp71_ = vala_parser_get_src (self, &_tmp70_);
									_tmp72_ = _tmp71_;
									_tmp73_ = vala_addressof_expression_new (_tmp69_, _tmp72_);
									_tmp74_ = _tmp73_;
									_vala_source_reference_unref0 (_tmp72_);
									inner = _tmp74_;
									_tmp75_ = inner;
									_tmp76_ = type;
									_tmp77_ = begin;
									_tmp78_ = vala_parser_get_src (self, &_tmp77_);
									_tmp79_ = _tmp78_;
									_tmp80_ = vala_cast_expression_new ((ValaExpression*) _tmp75_, _tmp76_, _tmp79_);
									_tmp81_ = (ValaExpression*) _tmp80_;
									_vala_source_reference_unref0 (_tmp79_);
									result = _tmp81_;
									_vala_code_node_unref0 (inner);
									_vala_code_node_unref0 (op);
									_vala_code_node_unref0 (type);
									return result;
								}
								default:
								{
									break;
								}
							}
						}
						_vala_code_node_unref0 (type);
					}
					break;
				}
				case VALA_TOKEN_TYPE_OP_NEG:
				{
					vala_parser_next (self);
					if (vala_parser_accept (self, VALA_TOKEN_TYPE_CLOSE_PARENS)) {
						ValaExpression* inner = NULL;
						ValaExpression* _tmp82_;
						ValaExpression* _tmp83_;
						ValaSourceLocation _tmp84_;
						ValaSourceReference* _tmp85_;
						ValaSourceReference* _tmp86_;
						ValaCastExpression* _tmp87_;
						ValaExpression* _tmp88_;
						_tmp82_ = vala_parser_parse_unary_expression (self, &_inner_error_);
						inner = _tmp82_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								return NULL;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_tmp83_ = inner;
						_tmp84_ = begin;
						_tmp85_ = vala_parser_get_src (self, &_tmp84_);
						_tmp86_ = _tmp85_;
						_tmp87_ = vala_cast_expression_new_non_null (_tmp83_, _tmp86_);
						_tmp88_ = (ValaExpression*) _tmp87_;
						_vala_source_reference_unref0 (_tmp86_);
						result = _tmp88_;
						_vala_code_node_unref0 (inner);
						return result;
					}
					break;
				}
				default:
				{
					break;
				}
			}
			_tmp89_ = begin;
			vala_parser_rollback (self, &_tmp89_);
			break;
		}
		case VALA_TOKEN_TYPE_STAR:
		{
			ValaExpression* op = NULL;
			ValaExpression* _tmp90_;
			ValaExpression* _tmp91_;
			ValaSourceLocation _tmp92_;
			ValaSourceReference* _tmp93_;
			ValaSourceReference* _tmp94_;
			ValaPointerIndirection* _tmp95_;
			ValaExpression* _tmp96_;
			vala_parser_next (self);
			_tmp90_ = vala_parser_parse_unary_expression (self, &_inner_error_);
			op = _tmp90_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp91_ = op;
			_tmp92_ = begin;
			_tmp93_ = vala_parser_get_src (self, &_tmp92_);
			_tmp94_ = _tmp93_;
			_tmp95_ = vala_pointer_indirection_new (_tmp91_, _tmp94_);
			_tmp96_ = (ValaExpression*) _tmp95_;
			_vala_source_reference_unref0 (_tmp94_);
			result = _tmp96_;
			_vala_code_node_unref0 (op);
			return result;
		}
		case VALA_TOKEN_TYPE_BITWISE_AND:
		{
			ValaExpression* op = NULL;
			ValaExpression* _tmp97_;
			ValaExpression* _tmp98_;
			ValaSourceLocation _tmp99_;
			ValaSourceReference* _tmp100_;
			ValaSourceReference* _tmp101_;
			ValaAddressofExpression* _tmp102_;
			ValaExpression* _tmp103_;
			vala_parser_next (self);
			_tmp97_ = vala_parser_parse_unary_expression (self, &_inner_error_);
			op = _tmp97_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp98_ = op;
			_tmp99_ = begin;
			_tmp100_ = vala_parser_get_src (self, &_tmp99_);
			_tmp101_ = _tmp100_;
			_tmp102_ = vala_addressof_expression_new (_tmp98_, _tmp101_);
			_tmp103_ = (ValaExpression*) _tmp102_;
			_vala_source_reference_unref0 (_tmp101_);
			result = _tmp103_;
			_vala_code_node_unref0 (op);
			return result;
		}
		default:
		{
			break;
		}
	}
	_tmp104_ = vala_parser_parse_primary_expression (self, &_inner_error_);
	expr = _tmp104_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = expr;
	return result;
}


static ValaBinaryOperator
vala_parser_get_binary_operator (ValaParser* self,
                                 ValaTokenType token_type)
{
	ValaBinaryOperator result = 0;
	g_return_val_if_fail (self != NULL, 0);
	switch (token_type) {
		case VALA_TOKEN_TYPE_STAR:
		{
			result = VALA_BINARY_OPERATOR_MUL;
			return result;
		}
		case VALA_TOKEN_TYPE_DIV:
		{
			result = VALA_BINARY_OPERATOR_DIV;
			return result;
		}
		case VALA_TOKEN_TYPE_PERCENT:
		{
			result = VALA_BINARY_OPERATOR_MOD;
			return result;
		}
		case VALA_TOKEN_TYPE_PLUS:
		{
			result = VALA_BINARY_OPERATOR_PLUS;
			return result;
		}
		case VALA_TOKEN_TYPE_MINUS:
		{
			result = VALA_BINARY_OPERATOR_MINUS;
			return result;
		}
		case VALA_TOKEN_TYPE_OP_LT:
		{
			result = VALA_BINARY_OPERATOR_LESS_THAN;
			return result;
		}
		case VALA_TOKEN_TYPE_OP_GT:
		{
			result = VALA_BINARY_OPERATOR_GREATER_THAN;
			return result;
		}
		case VALA_TOKEN_TYPE_OP_LE:
		{
			result = VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
			return result;
		}
		case VALA_TOKEN_TYPE_OP_GE:
		{
			result = VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
			return result;
		}
		case VALA_TOKEN_TYPE_OP_EQ:
		{
			result = VALA_BINARY_OPERATOR_EQUALITY;
			return result;
		}
		case VALA_TOKEN_TYPE_OP_NE:
		{
			result = VALA_BINARY_OPERATOR_INEQUALITY;
			return result;
		}
		default:
		{
			result = VALA_BINARY_OPERATOR_NONE;
			return result;
		}
	}
}


static ValaExpression*
vala_parser_parse_multiplicative_expression (ValaParser* self,
                                             GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	gboolean found = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_unary_expression (self, &_inner_error_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	found = TRUE;
	while (TRUE) {
		gboolean _tmp2_;
		ValaBinaryOperator operator = 0;
		ValaBinaryOperator _tmp3_;
		_tmp2_ = found;
		if (!_tmp2_) {
			break;
		}
		operator = vala_parser_get_binary_operator (self, vala_parser_current (self));
		_tmp3_ = operator;
		switch (_tmp3_) {
			case VALA_BINARY_OPERATOR_MUL:
			case VALA_BINARY_OPERATOR_DIV:
			case VALA_BINARY_OPERATOR_MOD:
			{
				ValaExpression* right = NULL;
				ValaExpression* _tmp4_;
				ValaBinaryOperator _tmp5_;
				ValaExpression* _tmp6_;
				ValaExpression* _tmp7_;
				ValaSourceLocation _tmp8_;
				ValaSourceReference* _tmp9_;
				ValaSourceReference* _tmp10_;
				ValaBinaryExpression* _tmp11_;
				vala_parser_next (self);
				_tmp4_ = vala_parser_parse_unary_expression (self, &_inner_error_);
				right = _tmp4_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (left);
						return NULL;
					} else {
						_vala_code_node_unref0 (left);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp5_ = operator;
				_tmp6_ = left;
				_tmp7_ = right;
				_tmp8_ = begin;
				_tmp9_ = vala_parser_get_src (self, &_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = vala_binary_expression_new (_tmp5_, _tmp6_, _tmp7_, _tmp10_);
				_vala_code_node_unref0 (left);
				left = (ValaExpression*) _tmp11_;
				_vala_source_reference_unref0 (_tmp10_);
				_vala_code_node_unref0 (right);
				break;
			}
			default:
			{
				found = FALSE;
				break;
			}
		}
	}
	result = left;
	return result;
}


static ValaExpression*
vala_parser_parse_additive_expression (ValaParser* self,
                                       GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	gboolean found = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_multiplicative_expression (self, &_inner_error_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	found = TRUE;
	while (TRUE) {
		gboolean _tmp2_;
		ValaBinaryOperator operator = 0;
		ValaBinaryOperator _tmp3_;
		_tmp2_ = found;
		if (!_tmp2_) {
			break;
		}
		operator = vala_parser_get_binary_operator (self, vala_parser_current (self));
		_tmp3_ = operator;
		switch (_tmp3_) {
			case VALA_BINARY_OPERATOR_PLUS:
			case VALA_BINARY_OPERATOR_MINUS:
			{
				ValaExpression* right = NULL;
				ValaExpression* _tmp4_;
				ValaBinaryOperator _tmp5_;
				ValaExpression* _tmp6_;
				ValaExpression* _tmp7_;
				ValaSourceLocation _tmp8_;
				ValaSourceReference* _tmp9_;
				ValaSourceReference* _tmp10_;
				ValaBinaryExpression* _tmp11_;
				vala_parser_next (self);
				_tmp4_ = vala_parser_parse_multiplicative_expression (self, &_inner_error_);
				right = _tmp4_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (left);
						return NULL;
					} else {
						_vala_code_node_unref0 (left);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp5_ = operator;
				_tmp6_ = left;
				_tmp7_ = right;
				_tmp8_ = begin;
				_tmp9_ = vala_parser_get_src (self, &_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = vala_binary_expression_new (_tmp5_, _tmp6_, _tmp7_, _tmp10_);
				_vala_code_node_unref0 (left);
				left = (ValaExpression*) _tmp11_;
				_vala_source_reference_unref0 (_tmp10_);
				_vala_code_node_unref0 (right);
				break;
			}
			default:
			{
				found = FALSE;
				break;
			}
		}
	}
	result = left;
	return result;
}


static ValaExpression*
vala_parser_parse_shift_expression (ValaParser* self,
                                    GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	gboolean found = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_additive_expression (self, &_inner_error_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	found = TRUE;
	while (TRUE) {
		gboolean _tmp2_;
		_tmp2_ = found;
		if (!_tmp2_) {
			break;
		}
		switch (vala_parser_current (self)) {
			case VALA_TOKEN_TYPE_OP_SHIFT_LEFT:
			{
				ValaExpression* right = NULL;
				ValaExpression* _tmp3_;
				ValaExpression* _tmp4_;
				ValaExpression* _tmp5_;
				ValaSourceLocation _tmp6_;
				ValaSourceReference* _tmp7_;
				ValaSourceReference* _tmp8_;
				ValaBinaryExpression* _tmp9_;
				vala_parser_next (self);
				_tmp3_ = vala_parser_parse_additive_expression (self, &_inner_error_);
				right = _tmp3_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (left);
						return NULL;
					} else {
						_vala_code_node_unref0 (left);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp4_ = left;
				_tmp5_ = right;
				_tmp6_ = begin;
				_tmp7_ = vala_parser_get_src (self, &_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_SHIFT_LEFT, _tmp4_, _tmp5_, _tmp8_);
				_vala_code_node_unref0 (left);
				left = (ValaExpression*) _tmp9_;
				_vala_source_reference_unref0 (_tmp8_);
				_vala_code_node_unref0 (right);
				break;
			}
			case VALA_TOKEN_TYPE_OP_GT:
			{
				gchar* first_gt_pos = NULL;
				ValaParserTokenInfo* _tmp10_;
				gint _tmp10__length1;
				gint _tmp11_;
				ValaParserTokenInfo _tmp12_;
				ValaSourceLocation _tmp13_;
				gchar* _tmp14_;
				gboolean _tmp15_ = FALSE;
				_tmp10_ = self->priv->tokens;
				_tmp10__length1 = self->priv->tokens_length1;
				_tmp11_ = self->priv->index;
				_tmp12_ = _tmp10_[_tmp11_];
				_tmp13_ = _tmp12_.begin;
				_tmp14_ = _tmp13_.pos;
				first_gt_pos = _tmp14_;
				vala_parser_next (self);
				if (vala_parser_current (self) == VALA_TOKEN_TYPE_OP_GT) {
					ValaParserTokenInfo* _tmp16_;
					gint _tmp16__length1;
					gint _tmp17_;
					ValaParserTokenInfo _tmp18_;
					ValaSourceLocation _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp16_ = self->priv->tokens;
					_tmp16__length1 = self->priv->tokens_length1;
					_tmp17_ = self->priv->index;
					_tmp18_ = _tmp16_[_tmp17_];
					_tmp19_ = _tmp18_.begin;
					_tmp20_ = _tmp19_.pos;
					_tmp21_ = first_gt_pos;
					_tmp15_ = _tmp20_ == (_tmp21_ + 1);
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					ValaExpression* right = NULL;
					ValaExpression* _tmp22_;
					ValaExpression* _tmp23_;
					ValaExpression* _tmp24_;
					ValaSourceLocation _tmp25_;
					ValaSourceReference* _tmp26_;
					ValaSourceReference* _tmp27_;
					ValaBinaryExpression* _tmp28_;
					vala_parser_next (self);
					_tmp22_ = vala_parser_parse_additive_expression (self, &_inner_error_);
					right = _tmp22_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_vala_code_node_unref0 (left);
							return NULL;
						} else {
							_vala_code_node_unref0 (left);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp23_ = left;
					_tmp24_ = right;
					_tmp25_ = begin;
					_tmp26_ = vala_parser_get_src (self, &_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_SHIFT_RIGHT, _tmp23_, _tmp24_, _tmp27_);
					_vala_code_node_unref0 (left);
					left = (ValaExpression*) _tmp28_;
					_vala_source_reference_unref0 (_tmp27_);
					_vala_code_node_unref0 (right);
				} else {
					vala_parser_prev (self);
					found = FALSE;
				}
				break;
			}
			default:
			{
				found = FALSE;
				break;
			}
		}
	}
	result = left;
	return result;
}


static ValaExpression*
vala_parser_parse_relational_expression (ValaParser* self,
                                         GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	gboolean first = FALSE;
	gboolean found = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_shift_expression (self, &_inner_error_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	first = TRUE;
	found = TRUE;
	while (TRUE) {
		gboolean _tmp2_;
		ValaBinaryOperator operator = 0;
		ValaBinaryOperator _tmp3_;
		_tmp2_ = found;
		if (!_tmp2_) {
			break;
		}
		operator = vala_parser_get_binary_operator (self, vala_parser_current (self));
		_tmp3_ = operator;
		switch (_tmp3_) {
			case VALA_BINARY_OPERATOR_LESS_THAN:
			case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
			case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
			{
				ValaExpression* right = NULL;
				ValaExpression* _tmp4_;
				gboolean _tmp5_;
				vala_parser_next (self);
				_tmp4_ = vala_parser_parse_shift_expression (self, &_inner_error_);
				right = _tmp4_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (left);
						return NULL;
					} else {
						_vala_code_node_unref0 (left);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp5_ = first;
				if (_tmp5_) {
					ValaBinaryOperator _tmp6_;
					ValaExpression* _tmp7_;
					ValaExpression* _tmp8_;
					ValaSourceLocation _tmp9_;
					ValaSourceReference* _tmp10_;
					ValaSourceReference* _tmp11_;
					ValaBinaryExpression* _tmp12_;
					_tmp6_ = operator;
					_tmp7_ = left;
					_tmp8_ = right;
					_tmp9_ = begin;
					_tmp10_ = vala_parser_get_src (self, &_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = vala_binary_expression_new (_tmp6_, _tmp7_, _tmp8_, _tmp11_);
					_vala_code_node_unref0 (left);
					left = (ValaExpression*) _tmp12_;
					_vala_source_reference_unref0 (_tmp11_);
				} else {
					ValaBinaryOperator _tmp13_;
					ValaExpression* _tmp14_;
					ValaExpression* _tmp15_;
					ValaSourceLocation _tmp16_;
					ValaSourceReference* _tmp17_;
					ValaSourceReference* _tmp18_;
					ValaBinaryExpression* _tmp19_;
					_tmp13_ = operator;
					_tmp14_ = left;
					_tmp15_ = right;
					_tmp16_ = begin;
					_tmp17_ = vala_parser_get_src (self, &_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = vala_binary_expression_new_chained (_tmp13_, _tmp14_, _tmp15_, _tmp18_);
					_vala_code_node_unref0 (left);
					left = (ValaExpression*) _tmp19_;
					_vala_source_reference_unref0 (_tmp18_);
				}
				first = FALSE;
				_vala_code_node_unref0 (right);
				break;
			}
			case VALA_BINARY_OPERATOR_GREATER_THAN:
			{
				gboolean _tmp20_ = FALSE;
				vala_parser_next (self);
				if (vala_parser_current (self) != VALA_TOKEN_TYPE_OP_GT) {
					_tmp20_ = vala_parser_current (self) != VALA_TOKEN_TYPE_OP_GE;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					ValaExpression* right = NULL;
					ValaExpression* _tmp21_;
					gboolean _tmp22_;
					_tmp21_ = vala_parser_parse_shift_expression (self, &_inner_error_);
					right = _tmp21_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_vala_code_node_unref0 (left);
							return NULL;
						} else {
							_vala_code_node_unref0 (left);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp22_ = first;
					if (_tmp22_) {
						ValaBinaryOperator _tmp23_;
						ValaExpression* _tmp24_;
						ValaExpression* _tmp25_;
						ValaSourceLocation _tmp26_;
						ValaSourceReference* _tmp27_;
						ValaSourceReference* _tmp28_;
						ValaBinaryExpression* _tmp29_;
						_tmp23_ = operator;
						_tmp24_ = left;
						_tmp25_ = right;
						_tmp26_ = begin;
						_tmp27_ = vala_parser_get_src (self, &_tmp26_);
						_tmp28_ = _tmp27_;
						_tmp29_ = vala_binary_expression_new (_tmp23_, _tmp24_, _tmp25_, _tmp28_);
						_vala_code_node_unref0 (left);
						left = (ValaExpression*) _tmp29_;
						_vala_source_reference_unref0 (_tmp28_);
					} else {
						ValaBinaryOperator _tmp30_;
						ValaExpression* _tmp31_;
						ValaExpression* _tmp32_;
						ValaSourceLocation _tmp33_;
						ValaSourceReference* _tmp34_;
						ValaSourceReference* _tmp35_;
						ValaBinaryExpression* _tmp36_;
						_tmp30_ = operator;
						_tmp31_ = left;
						_tmp32_ = right;
						_tmp33_ = begin;
						_tmp34_ = vala_parser_get_src (self, &_tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = vala_binary_expression_new_chained (_tmp30_, _tmp31_, _tmp32_, _tmp35_);
						_vala_code_node_unref0 (left);
						left = (ValaExpression*) _tmp36_;
						_vala_source_reference_unref0 (_tmp35_);
					}
					first = FALSE;
					_vala_code_node_unref0 (right);
				} else {
					vala_parser_prev (self);
					found = FALSE;
				}
				break;
			}
			default:
			{
				switch (vala_parser_current (self)) {
					case VALA_TOKEN_TYPE_IS:
					{
						ValaDataType* type = NULL;
						ValaDataType* _tmp37_;
						ValaExpression* _tmp38_;
						ValaDataType* _tmp39_;
						ValaSourceLocation _tmp40_;
						ValaSourceReference* _tmp41_;
						ValaSourceReference* _tmp42_;
						ValaTypeCheck* _tmp43_;
						vala_parser_next (self);
						_tmp37_ = vala_parser_parse_type (self, TRUE, FALSE, FALSE, &_inner_error_);
						type = _tmp37_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								_vala_code_node_unref0 (left);
								return NULL;
							} else {
								_vala_code_node_unref0 (left);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_tmp38_ = left;
						_tmp39_ = type;
						_tmp40_ = begin;
						_tmp41_ = vala_parser_get_src (self, &_tmp40_);
						_tmp42_ = _tmp41_;
						_tmp43_ = vala_typecheck_new (_tmp38_, _tmp39_, _tmp42_);
						_vala_code_node_unref0 (left);
						left = (ValaExpression*) _tmp43_;
						_vala_source_reference_unref0 (_tmp42_);
						_vala_code_node_unref0 (type);
						break;
					}
					case VALA_TOKEN_TYPE_AS:
					{
						ValaDataType* type = NULL;
						ValaDataType* _tmp44_;
						ValaExpression* _tmp45_;
						ValaDataType* _tmp46_;
						ValaSourceLocation _tmp47_;
						ValaSourceReference* _tmp48_;
						ValaSourceReference* _tmp49_;
						ValaCastExpression* _tmp50_;
						vala_parser_next (self);
						_tmp44_ = vala_parser_parse_type (self, TRUE, FALSE, FALSE, &_inner_error_);
						type = _tmp44_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								_vala_code_node_unref0 (left);
								return NULL;
							} else {
								_vala_code_node_unref0 (left);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_tmp45_ = left;
						_tmp46_ = type;
						_tmp47_ = begin;
						_tmp48_ = vala_parser_get_src (self, &_tmp47_);
						_tmp49_ = _tmp48_;
						_tmp50_ = vala_cast_expression_new_silent (_tmp45_, _tmp46_, _tmp49_);
						_vala_code_node_unref0 (left);
						left = (ValaExpression*) _tmp50_;
						_vala_source_reference_unref0 (_tmp49_);
						_vala_code_node_unref0 (type);
						break;
					}
					default:
					{
						found = FALSE;
						break;
					}
				}
				break;
			}
		}
	}
	result = left;
	return result;
}


static ValaExpression*
vala_parser_parse_equality_expression (ValaParser* self,
                                       GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	gboolean found = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_relational_expression (self, &_inner_error_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	found = TRUE;
	while (TRUE) {
		gboolean _tmp2_;
		ValaBinaryOperator operator = 0;
		ValaBinaryOperator _tmp3_;
		_tmp2_ = found;
		if (!_tmp2_) {
			break;
		}
		operator = vala_parser_get_binary_operator (self, vala_parser_current (self));
		_tmp3_ = operator;
		switch (_tmp3_) {
			case VALA_BINARY_OPERATOR_EQUALITY:
			case VALA_BINARY_OPERATOR_INEQUALITY:
			{
				ValaExpression* right = NULL;
				ValaExpression* _tmp4_;
				ValaBinaryOperator _tmp5_;
				ValaExpression* _tmp6_;
				ValaExpression* _tmp7_;
				ValaSourceLocation _tmp8_;
				ValaSourceReference* _tmp9_;
				ValaSourceReference* _tmp10_;
				ValaBinaryExpression* _tmp11_;
				vala_parser_next (self);
				_tmp4_ = vala_parser_parse_relational_expression (self, &_inner_error_);
				right = _tmp4_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (left);
						return NULL;
					} else {
						_vala_code_node_unref0 (left);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp5_ = operator;
				_tmp6_ = left;
				_tmp7_ = right;
				_tmp8_ = begin;
				_tmp9_ = vala_parser_get_src (self, &_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = vala_binary_expression_new (_tmp5_, _tmp6_, _tmp7_, _tmp10_);
				_vala_code_node_unref0 (left);
				left = (ValaExpression*) _tmp11_;
				_vala_source_reference_unref0 (_tmp10_);
				_vala_code_node_unref0 (right);
				break;
			}
			default:
			{
				found = FALSE;
				break;
			}
		}
	}
	result = left;
	return result;
}


static ValaExpression*
vala_parser_parse_and_expression (ValaParser* self,
                                  GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_equality_expression (self, &_inner_error_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaExpression* right = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSourceLocation _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaBinaryExpression* _tmp8_;
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_BITWISE_AND)) {
			break;
		}
		_tmp2_ = vala_parser_parse_equality_expression (self, &_inner_error_);
		right = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (left);
				return NULL;
			} else {
				_vala_code_node_unref0 (left);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp3_ = left;
		_tmp4_ = right;
		_tmp5_ = begin;
		_tmp6_ = vala_parser_get_src (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_BITWISE_AND, _tmp3_, _tmp4_, _tmp7_);
		_vala_code_node_unref0 (left);
		left = (ValaExpression*) _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_vala_code_node_unref0 (right);
	}
	result = left;
	return result;
}


static ValaExpression*
vala_parser_parse_exclusive_or_expression (ValaParser* self,
                                           GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_and_expression (self, &_inner_error_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaExpression* right = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSourceLocation _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaBinaryExpression* _tmp8_;
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_CARRET)) {
			break;
		}
		_tmp2_ = vala_parser_parse_and_expression (self, &_inner_error_);
		right = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (left);
				return NULL;
			} else {
				_vala_code_node_unref0 (left);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp3_ = left;
		_tmp4_ = right;
		_tmp5_ = begin;
		_tmp6_ = vala_parser_get_src (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_BITWISE_XOR, _tmp3_, _tmp4_, _tmp7_);
		_vala_code_node_unref0 (left);
		left = (ValaExpression*) _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_vala_code_node_unref0 (right);
	}
	result = left;
	return result;
}


static ValaExpression*
vala_parser_parse_inclusive_or_expression (ValaParser* self,
                                           GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_exclusive_or_expression (self, &_inner_error_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaExpression* right = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSourceLocation _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaBinaryExpression* _tmp8_;
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_BITWISE_OR)) {
			break;
		}
		_tmp2_ = vala_parser_parse_exclusive_or_expression (self, &_inner_error_);
		right = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (left);
				return NULL;
			} else {
				_vala_code_node_unref0 (left);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp3_ = left;
		_tmp4_ = right;
		_tmp5_ = begin;
		_tmp6_ = vala_parser_get_src (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_BITWISE_OR, _tmp3_, _tmp4_, _tmp7_);
		_vala_code_node_unref0 (left);
		left = (ValaExpression*) _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_vala_code_node_unref0 (right);
	}
	result = left;
	return result;
}


static ValaExpression*
vala_parser_parse_in_expression (ValaParser* self,
                                 GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_inclusive_or_expression (self, &_inner_error_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaExpression* right = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSourceLocation _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaBinaryExpression* _tmp8_;
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_IN)) {
			break;
		}
		_tmp2_ = vala_parser_parse_inclusive_or_expression (self, &_inner_error_);
		right = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (left);
				return NULL;
			} else {
				_vala_code_node_unref0 (left);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp3_ = left;
		_tmp4_ = right;
		_tmp5_ = begin;
		_tmp6_ = vala_parser_get_src (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_IN, _tmp3_, _tmp4_, _tmp7_);
		_vala_code_node_unref0 (left);
		left = (ValaExpression*) _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_vala_code_node_unref0 (right);
	}
	result = left;
	return result;
}


static ValaExpression*
vala_parser_parse_conditional_and_expression (ValaParser* self,
                                              GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_in_expression (self, &_inner_error_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaExpression* right = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSourceLocation _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaBinaryExpression* _tmp8_;
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_OP_AND)) {
			break;
		}
		_tmp2_ = vala_parser_parse_in_expression (self, &_inner_error_);
		right = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (left);
				return NULL;
			} else {
				_vala_code_node_unref0 (left);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp3_ = left;
		_tmp4_ = right;
		_tmp5_ = begin;
		_tmp6_ = vala_parser_get_src (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_AND, _tmp3_, _tmp4_, _tmp7_);
		_vala_code_node_unref0 (left);
		left = (ValaExpression*) _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_vala_code_node_unref0 (right);
	}
	result = left;
	return result;
}


static ValaExpression*
vala_parser_parse_conditional_or_expression (ValaParser* self,
                                             GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_conditional_and_expression (self, &_inner_error_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaExpression* right = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSourceLocation _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaBinaryExpression* _tmp8_;
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_OP_OR)) {
			break;
		}
		_tmp2_ = vala_parser_parse_conditional_and_expression (self, &_inner_error_);
		right = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (left);
				return NULL;
			} else {
				_vala_code_node_unref0 (left);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp3_ = left;
		_tmp4_ = right;
		_tmp5_ = begin;
		_tmp6_ = vala_parser_get_src (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_OR, _tmp3_, _tmp4_, _tmp7_);
		_vala_code_node_unref0 (left);
		left = (ValaExpression*) _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_vala_code_node_unref0 (right);
	}
	result = left;
	return result;
}


static ValaExpression*
vala_parser_parse_coalescing_expression (ValaParser* self,
                                         GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* left = NULL;
	ValaExpression* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_conditional_or_expression (self, &_inner_error_);
	left = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_OP_COALESCING)) {
		ValaExpression* right = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSourceLocation _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaBinaryExpression* _tmp8_;
		ValaExpression* _tmp9_;
		_tmp2_ = vala_parser_parse_coalescing_expression (self, &_inner_error_);
		right = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (left);
				return NULL;
			} else {
				_vala_code_node_unref0 (left);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp3_ = left;
		_tmp4_ = right;
		_tmp5_ = begin;
		_tmp6_ = vala_parser_get_src (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_COALESCE, _tmp3_, _tmp4_, _tmp7_);
		_tmp9_ = (ValaExpression*) _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		result = _tmp9_;
		_vala_code_node_unref0 (right);
		_vala_code_node_unref0 (left);
		return result;
	} else {
		result = left;
		return result;
	}
	_vala_code_node_unref0 (left);
}


static ValaExpression*
vala_parser_parse_conditional_expression (ValaParser* self,
                                          GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* condition = NULL;
	ValaExpression* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_coalescing_expression (self, &_inner_error_);
	condition = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_INTERR)) {
		ValaExpression* true_expr = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* false_expr = NULL;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaSourceLocation _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaConditionalExpression* _tmp10_;
		ValaExpression* _tmp11_;
		_tmp2_ = vala_parser_parse_expression (self, &_inner_error_);
		true_expr = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (condition);
				return NULL;
			} else {
				_vala_code_node_unref0 (condition);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_COLON, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (true_expr);
				_vala_code_node_unref0 (condition);
				return NULL;
			} else {
				_vala_code_node_unref0 (true_expr);
				_vala_code_node_unref0 (condition);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp3_ = vala_parser_parse_expression (self, &_inner_error_);
		false_expr = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (true_expr);
				_vala_code_node_unref0 (condition);
				return NULL;
			} else {
				_vala_code_node_unref0 (true_expr);
				_vala_code_node_unref0 (condition);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp4_ = condition;
		_tmp5_ = true_expr;
		_tmp6_ = false_expr;
		_tmp7_ = begin;
		_tmp8_ = vala_parser_get_src (self, &_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_conditional_expression_new (_tmp4_, _tmp5_, _tmp6_, _tmp9_);
		_tmp11_ = (ValaExpression*) _tmp10_;
		_vala_source_reference_unref0 (_tmp9_);
		result = _tmp11_;
		_vala_code_node_unref0 (false_expr);
		_vala_code_node_unref0 (true_expr);
		_vala_code_node_unref0 (condition);
		return result;
	} else {
		result = condition;
		return result;
	}
	_vala_code_node_unref0 (condition);
}


static ValaParameter*
vala_parser_parse_lambda_parameter (ValaParser* self,
                                    GError** error)
{
	ValaParameter* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaParameterDirection direction = 0;
	gchar* id = NULL;
	gchar* _tmp1_;
	ValaParameter* param = NULL;
	ValaSourceLocation _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaParameter* _tmp5_;
	ValaParameter* _tmp6_;
	ValaParameter* _tmp7_;
	ValaParameterDirection _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	direction = VALA_PARAMETER_DIRECTION_IN;
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_OUT)) {
		direction = VALA_PARAMETER_DIRECTION_OUT;
	} else {
		if (vala_parser_accept (self, VALA_TOKEN_TYPE_REF)) {
			direction = VALA_PARAMETER_DIRECTION_REF;
		}
	}
	_tmp1_ = vala_parser_parse_identifier (self, &_inner_error_);
	id = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = begin;
	_tmp3_ = vala_parser_get_src (self, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_parameter_new (id, NULL, _tmp4_);
	_tmp6_ = _tmp5_;
	_vala_source_reference_unref0 (_tmp4_);
	param = _tmp6_;
	_tmp7_ = param;
	_tmp8_ = direction;
	vala_parameter_set_direction (_tmp7_, _tmp8_);
	result = param;
	_g_free0 (id);
	return result;
}


static ValaExpression*
vala_parser_parse_lambda_expression (ValaParser* self,
                                     GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaList* params = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaLambdaExpression* lambda = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	params = (ValaList*) _tmp2_;
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_OPEN_PARENS)) {
		if (vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_PARENS) {
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					ValaParameter* _tmp4_ = NULL;
					ValaParameter* _tmp5_;
					ValaList* _tmp6_;
					if (!_tmp3_) {
						if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
							break;
						}
					}
					_tmp3_ = FALSE;
					_tmp5_ = vala_parser_parse_lambda_parameter (self, &_inner_error_);
					_tmp4_ = _tmp5_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_vala_iterable_unref0 (params);
							return NULL;
						} else {
							_vala_iterable_unref0 (params);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp6_ = params;
					vala_collection_add ((ValaCollection*) _tmp6_, _tmp4_);
					_vala_code_node_unref0 (_tmp4_);
				}
			}
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_iterable_unref0 (params);
				return NULL;
			} else {
				_vala_iterable_unref0 (params);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	} else {
		ValaParameter* _tmp7_ = NULL;
		ValaParameter* _tmp8_;
		ValaList* _tmp9_;
		_tmp8_ = vala_parser_parse_lambda_parameter (self, &_inner_error_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_iterable_unref0 (params);
				return NULL;
			} else {
				_vala_iterable_unref0 (params);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp9_ = params;
		vala_collection_add ((ValaCollection*) _tmp9_, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_LAMBDA, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_iterable_unref0 (params);
			return NULL;
		} else {
			_vala_iterable_unref0 (params);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vala_parser_current (self) == VALA_TOKEN_TYPE_OPEN_BRACE) {
		ValaBlock* block = NULL;
		ValaBlock* _tmp10_;
		ValaBlock* _tmp11_;
		ValaSourceLocation _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaLambdaExpression* _tmp15_;
		_tmp10_ = vala_parser_parse_block (self, &_inner_error_);
		block = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (lambda);
				_vala_iterable_unref0 (params);
				return NULL;
			} else {
				_vala_code_node_unref0 (lambda);
				_vala_iterable_unref0 (params);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp11_ = block;
		_tmp12_ = begin;
		_tmp13_ = vala_parser_get_src (self, &_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_lambda_expression_new_with_statement_body (_tmp11_, _tmp14_);
		_vala_code_node_unref0 (lambda);
		lambda = _tmp15_;
		_vala_source_reference_unref0 (_tmp14_);
		_vala_code_node_unref0 (block);
	} else {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaSourceLocation _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLambdaExpression* _tmp21_;
		_tmp16_ = vala_parser_parse_expression (self, &_inner_error_);
		expr = _tmp16_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (lambda);
				_vala_iterable_unref0 (params);
				return NULL;
			} else {
				_vala_code_node_unref0 (lambda);
				_vala_iterable_unref0 (params);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp17_ = expr;
		_tmp18_ = begin;
		_tmp19_ = vala_parser_get_src (self, &_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_lambda_expression_new (_tmp17_, _tmp20_);
		_vala_code_node_unref0 (lambda);
		lambda = _tmp21_;
		_vala_source_reference_unref0 (_tmp20_);
		_vala_code_node_unref0 (expr);
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp22_;
		ValaList* _tmp23_;
		gint _param_size = 0;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _param_index = 0;
		_tmp22_ = params;
		_tmp23_ = _vala_iterable_ref0 (_tmp22_);
		_param_list = _tmp23_;
		_tmp24_ = _param_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_param_size = _tmp26_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			ValaParameter* param = NULL;
			ValaList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			ValaLambdaExpression* _tmp33_;
			ValaParameter* _tmp34_;
			_tmp27_ = _param_index;
			_param_index = _tmp27_ + 1;
			_tmp28_ = _param_index;
			_tmp29_ = _param_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _param_list;
			_tmp31_ = _param_index;
			_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
			param = (ValaParameter*) _tmp32_;
			_tmp33_ = lambda;
			_tmp34_ = param;
			vala_lambda_expression_add_parameter (_tmp33_, _tmp34_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = (ValaExpression*) lambda;
	_vala_iterable_unref0 (params);
	return result;
}


static ValaAssignmentOperator
vala_parser_get_assignment_operator (ValaParser* self,
                                     ValaTokenType token_type)
{
	ValaAssignmentOperator result = 0;
	g_return_val_if_fail (self != NULL, 0);
	switch (token_type) {
		case VALA_TOKEN_TYPE_ASSIGN:
		{
			result = VALA_ASSIGNMENT_OPERATOR_SIMPLE;
			return result;
		}
		case VALA_TOKEN_TYPE_ASSIGN_ADD:
		{
			result = VALA_ASSIGNMENT_OPERATOR_ADD;
			return result;
		}
		case VALA_TOKEN_TYPE_ASSIGN_SUB:
		{
			result = VALA_ASSIGNMENT_OPERATOR_SUB;
			return result;
		}
		case VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR:
		{
			result = VALA_ASSIGNMENT_OPERATOR_BITWISE_OR;
			return result;
		}
		case VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND:
		{
			result = VALA_ASSIGNMENT_OPERATOR_BITWISE_AND;
			return result;
		}
		case VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR:
		{
			result = VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR;
			return result;
		}
		case VALA_TOKEN_TYPE_ASSIGN_DIV:
		{
			result = VALA_ASSIGNMENT_OPERATOR_DIV;
			return result;
		}
		case VALA_TOKEN_TYPE_ASSIGN_MUL:
		{
			result = VALA_ASSIGNMENT_OPERATOR_MUL;
			return result;
		}
		case VALA_TOKEN_TYPE_ASSIGN_PERCENT:
		{
			result = VALA_ASSIGNMENT_OPERATOR_PERCENT;
			return result;
		}
		case VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT:
		{
			result = VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT;
			return result;
		}
		default:
		{
			result = VALA_ASSIGNMENT_OPERATOR_NONE;
			return result;
		}
	}
}


static ValaExpression*
vala_parser_parse_expression (ValaParser* self,
                              GError** error)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp3_ = {0};
	ValaExpression* expr = NULL;
	ValaExpression* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_parser_is_lambda_expression (self)) {
		ValaExpression* _tmp0_ = NULL;
		ValaExpression* _tmp1_;
		ValaExpression* _tmp2_;
		_tmp1_ = vala_parser_parse_lambda_expression (self, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp2_;
		_vala_code_node_unref0 (_tmp0_);
		return result;
	}
	vala_parser_get_location (self, &_tmp3_);
	begin = _tmp3_;
	_tmp4_ = vala_parser_parse_conditional_expression (self, &_inner_error_);
	expr = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaAssignmentOperator operator = 0;
		ValaAssignmentOperator _tmp5_;
		operator = vala_parser_get_assignment_operator (self, vala_parser_current (self));
		_tmp5_ = operator;
		if (_tmp5_ != VALA_ASSIGNMENT_OPERATOR_NONE) {
			ValaExpression* rhs = NULL;
			ValaExpression* _tmp6_;
			ValaExpression* _tmp7_;
			ValaExpression* _tmp8_;
			ValaAssignmentOperator _tmp9_;
			ValaSourceLocation _tmp10_;
			ValaSourceReference* _tmp11_;
			ValaSourceReference* _tmp12_;
			ValaAssignment* _tmp13_;
			vala_parser_next (self);
			_tmp6_ = vala_parser_parse_expression (self, &_inner_error_);
			rhs = _tmp6_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp7_ = expr;
			_tmp8_ = rhs;
			_tmp9_ = operator;
			_tmp10_ = begin;
			_tmp11_ = vala_parser_get_src (self, &_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_assignment_new (_tmp7_, _tmp8_, _tmp9_, _tmp12_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp13_;
			_vala_source_reference_unref0 (_tmp12_);
			_vala_code_node_unref0 (rhs);
		} else {
			if (vala_parser_current (self) == VALA_TOKEN_TYPE_OP_GT) {
				gchar* first_gt_pos = NULL;
				ValaParserTokenInfo* _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				ValaParserTokenInfo _tmp16_;
				ValaSourceLocation _tmp17_;
				gchar* _tmp18_;
				gboolean _tmp19_ = FALSE;
				_tmp14_ = self->priv->tokens;
				_tmp14__length1 = self->priv->tokens_length1;
				_tmp15_ = self->priv->index;
				_tmp16_ = _tmp14_[_tmp15_];
				_tmp17_ = _tmp16_.begin;
				_tmp18_ = _tmp17_.pos;
				first_gt_pos = _tmp18_;
				vala_parser_next (self);
				if (vala_parser_current (self) == VALA_TOKEN_TYPE_OP_GE) {
					ValaParserTokenInfo* _tmp20_;
					gint _tmp20__length1;
					gint _tmp21_;
					ValaParserTokenInfo _tmp22_;
					ValaSourceLocation _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp20_ = self->priv->tokens;
					_tmp20__length1 = self->priv->tokens_length1;
					_tmp21_ = self->priv->index;
					_tmp22_ = _tmp20_[_tmp21_];
					_tmp23_ = _tmp22_.begin;
					_tmp24_ = _tmp23_.pos;
					_tmp25_ = first_gt_pos;
					_tmp19_ = _tmp24_ == (_tmp25_ + 1);
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					ValaExpression* rhs = NULL;
					ValaExpression* _tmp26_;
					ValaExpression* _tmp27_;
					ValaExpression* _tmp28_;
					ValaSourceLocation _tmp29_;
					ValaSourceReference* _tmp30_;
					ValaSourceReference* _tmp31_;
					ValaAssignment* _tmp32_;
					vala_parser_next (self);
					_tmp26_ = vala_parser_parse_expression (self, &_inner_error_);
					rhs = _tmp26_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_vala_code_node_unref0 (expr);
							return NULL;
						} else {
							_vala_code_node_unref0 (expr);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp27_ = expr;
					_tmp28_ = rhs;
					_tmp29_ = begin;
					_tmp30_ = vala_parser_get_src (self, &_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = vala_assignment_new (_tmp27_, _tmp28_, VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, _tmp31_);
					_vala_code_node_unref0 (expr);
					expr = (ValaExpression*) _tmp32_;
					_vala_source_reference_unref0 (_tmp31_);
					_vala_code_node_unref0 (rhs);
				} else {
					vala_parser_prev (self);
					break;
				}
			} else {
				break;
			}
		}
	}
	result = expr;
	return result;
}


static void
vala_parser_parse_statements (ValaParser* self,
                              ValaBlock* block,
                              GError** error)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		if (vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_BRACE) {
			_tmp2_ = vala_parser_current (self) != VALA_TOKEN_TYPE_CASE;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = vala_parser_current (self) != VALA_TOKEN_TYPE_DEFAULT;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = vala_parser_current (self) != VALA_TOKEN_TYPE_EOF;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		{
			ValaStatement* stmt = NULL;
			gboolean is_decl = FALSE;
			ValaScanner* _tmp3_;
			ValaComment* _tmp4_;
			gboolean _tmp60_;
			stmt = NULL;
			is_decl = FALSE;
			_tmp3_ = self->priv->scanner;
			_tmp4_ = vala_scanner_pop_comment (_tmp3_);
			_vala_comment_unref0 (self->priv->comment);
			self->priv->comment = _tmp4_;
			switch (vala_parser_current (self)) {
				case VALA_TOKEN_TYPE_OPEN_BRACE:
				{
					ValaBlock* _tmp5_ = NULL;
					ValaBlock* _tmp6_;
					ValaBlock* _tmp7_;
					_tmp6_ = vala_parser_parse_block (self, &_inner_error_);
					_tmp5_ = _tmp6_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp7_ = _tmp5_;
					_tmp5_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = (ValaStatement*) _tmp7_;
					_vala_code_node_unref0 (_tmp5_);
					break;
				}
				case VALA_TOKEN_TYPE_SEMICOLON:
				{
					ValaStatement* _tmp8_ = NULL;
					ValaStatement* _tmp9_;
					ValaStatement* _tmp10_;
					_tmp9_ = vala_parser_parse_empty_statement (self, &_inner_error_);
					_tmp8_ = _tmp9_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp10_ = _tmp8_;
					_tmp8_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp10_;
					_vala_code_node_unref0 (_tmp8_);
					break;
				}
				case VALA_TOKEN_TYPE_IF:
				{
					ValaStatement* _tmp11_ = NULL;
					ValaStatement* _tmp12_;
					ValaStatement* _tmp13_;
					_tmp12_ = vala_parser_parse_if_statement (self, &_inner_error_);
					_tmp11_ = _tmp12_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp13_ = _tmp11_;
					_tmp11_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp13_;
					_vala_code_node_unref0 (_tmp11_);
					break;
				}
				case VALA_TOKEN_TYPE_SWITCH:
				{
					ValaStatement* _tmp14_ = NULL;
					ValaStatement* _tmp15_;
					ValaStatement* _tmp16_;
					_tmp15_ = vala_parser_parse_switch_statement (self, &_inner_error_);
					_tmp14_ = _tmp15_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp16_ = _tmp14_;
					_tmp14_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp16_;
					_vala_code_node_unref0 (_tmp14_);
					break;
				}
				case VALA_TOKEN_TYPE_WHILE:
				{
					ValaStatement* _tmp17_ = NULL;
					ValaStatement* _tmp18_;
					ValaStatement* _tmp19_;
					_tmp18_ = vala_parser_parse_while_statement (self, &_inner_error_);
					_tmp17_ = _tmp18_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp19_ = _tmp17_;
					_tmp17_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp19_;
					_vala_code_node_unref0 (_tmp17_);
					break;
				}
				case VALA_TOKEN_TYPE_DO:
				{
					ValaStatement* _tmp20_ = NULL;
					ValaStatement* _tmp21_;
					ValaStatement* _tmp22_;
					_tmp21_ = vala_parser_parse_do_statement (self, &_inner_error_);
					_tmp20_ = _tmp21_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp22_ = _tmp20_;
					_tmp20_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp22_;
					_vala_code_node_unref0 (_tmp20_);
					break;
				}
				case VALA_TOKEN_TYPE_FOR:
				{
					ValaStatement* _tmp23_ = NULL;
					ValaStatement* _tmp24_;
					ValaStatement* _tmp25_;
					_tmp24_ = vala_parser_parse_for_statement (self, &_inner_error_);
					_tmp23_ = _tmp24_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp25_ = _tmp23_;
					_tmp23_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp25_;
					_vala_code_node_unref0 (_tmp23_);
					break;
				}
				case VALA_TOKEN_TYPE_FOREACH:
				{
					ValaStatement* _tmp26_ = NULL;
					ValaStatement* _tmp27_;
					ValaStatement* _tmp28_;
					_tmp27_ = vala_parser_parse_foreach_statement (self, &_inner_error_);
					_tmp26_ = _tmp27_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp28_ = _tmp26_;
					_tmp26_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp28_;
					_vala_code_node_unref0 (_tmp26_);
					break;
				}
				case VALA_TOKEN_TYPE_BREAK:
				{
					ValaStatement* _tmp29_ = NULL;
					ValaStatement* _tmp30_;
					ValaStatement* _tmp31_;
					_tmp30_ = vala_parser_parse_break_statement (self, &_inner_error_);
					_tmp29_ = _tmp30_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp31_ = _tmp29_;
					_tmp29_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp31_;
					_vala_code_node_unref0 (_tmp29_);
					break;
				}
				case VALA_TOKEN_TYPE_CONTINUE:
				{
					ValaStatement* _tmp32_ = NULL;
					ValaStatement* _tmp33_;
					ValaStatement* _tmp34_;
					_tmp33_ = vala_parser_parse_continue_statement (self, &_inner_error_);
					_tmp32_ = _tmp33_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp34_ = _tmp32_;
					_tmp32_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp34_;
					_vala_code_node_unref0 (_tmp32_);
					break;
				}
				case VALA_TOKEN_TYPE_RETURN:
				{
					ValaStatement* _tmp35_ = NULL;
					ValaStatement* _tmp36_;
					ValaStatement* _tmp37_;
					_tmp36_ = vala_parser_parse_return_statement (self, &_inner_error_);
					_tmp35_ = _tmp36_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp37_ = _tmp35_;
					_tmp35_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp37_;
					_vala_code_node_unref0 (_tmp35_);
					break;
				}
				case VALA_TOKEN_TYPE_YIELD:
				{
					ValaStatement* _tmp38_ = NULL;
					ValaStatement* _tmp39_;
					ValaStatement* _tmp40_;
					_tmp39_ = vala_parser_parse_yield_statement (self, &_inner_error_);
					_tmp38_ = _tmp39_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp40_ = _tmp38_;
					_tmp38_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp40_;
					_vala_code_node_unref0 (_tmp38_);
					break;
				}
				case VALA_TOKEN_TYPE_THROW:
				{
					ValaStatement* _tmp41_ = NULL;
					ValaStatement* _tmp42_;
					ValaStatement* _tmp43_;
					_tmp42_ = vala_parser_parse_throw_statement (self, &_inner_error_);
					_tmp41_ = _tmp42_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp43_ = _tmp41_;
					_tmp41_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp43_;
					_vala_code_node_unref0 (_tmp41_);
					break;
				}
				case VALA_TOKEN_TYPE_TRY:
				{
					ValaStatement* _tmp44_ = NULL;
					ValaStatement* _tmp45_;
					ValaStatement* _tmp46_;
					_tmp45_ = vala_parser_parse_try_statement (self, &_inner_error_);
					_tmp44_ = _tmp45_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp46_ = _tmp44_;
					_tmp44_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp46_;
					_vala_code_node_unref0 (_tmp44_);
					break;
				}
				case VALA_TOKEN_TYPE_LOCK:
				{
					ValaStatement* _tmp47_ = NULL;
					ValaStatement* _tmp48_;
					ValaStatement* _tmp49_;
					_tmp48_ = vala_parser_parse_lock_statement (self, &_inner_error_);
					_tmp47_ = _tmp48_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp49_ = _tmp47_;
					_tmp47_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp49_;
					_vala_code_node_unref0 (_tmp47_);
					break;
				}
				case VALA_TOKEN_TYPE_DELETE:
				{
					ValaStatement* _tmp50_ = NULL;
					ValaStatement* _tmp51_;
					ValaStatement* _tmp52_;
					_tmp51_ = vala_parser_parse_delete_statement (self, &_inner_error_);
					_tmp50_ = _tmp51_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp52_ = _tmp50_;
					_tmp50_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp52_;
					_vala_code_node_unref0 (_tmp50_);
					break;
				}
				case VALA_TOKEN_TYPE_VAR:
				{
					is_decl = TRUE;
					vala_parser_parse_local_variable_declarations (self, block, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					break;
				}
				case VALA_TOKEN_TYPE_CONST:
				{
					is_decl = TRUE;
					vala_parser_parse_local_constant_declarations (self, block, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					break;
				}
				case VALA_TOKEN_TYPE_OP_INC:
				case VALA_TOKEN_TYPE_OP_DEC:
				case VALA_TOKEN_TYPE_BASE:
				case VALA_TOKEN_TYPE_THIS:
				case VALA_TOKEN_TYPE_STAR:
				case VALA_TOKEN_TYPE_NEW:
				{
					ValaStatement* _tmp53_ = NULL;
					ValaStatement* _tmp54_;
					ValaStatement* _tmp55_;
					_tmp54_ = vala_parser_parse_expression_statement (self, &_inner_error_);
					_tmp53_ = _tmp54_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp55_ = _tmp53_;
					_tmp53_ = NULL;
					_vala_code_node_unref0 (stmt);
					stmt = _tmp55_;
					_vala_code_node_unref0 (_tmp53_);
					break;
				}
				default:
				{
					gboolean is_expr = FALSE;
					gboolean _tmp56_;
					is_expr = vala_parser_is_expression (self, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_vala_code_node_unref0 (stmt);
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch15_vala_parse_error;
						}
						_vala_code_node_unref0 (stmt);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp56_ = is_expr;
					if (_tmp56_) {
						ValaStatement* _tmp57_ = NULL;
						ValaStatement* _tmp58_;
						ValaStatement* _tmp59_;
						_tmp58_ = vala_parser_parse_expression_statement (self, &_inner_error_);
						_tmp57_ = _tmp58_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_vala_code_node_unref0 (stmt);
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								goto __catch15_vala_parse_error;
							}
							_vala_code_node_unref0 (stmt);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_tmp59_ = _tmp57_;
						_tmp57_ = NULL;
						_vala_code_node_unref0 (stmt);
						stmt = _tmp59_;
						_vala_code_node_unref0 (_tmp57_);
					} else {
						is_decl = TRUE;
						vala_parser_parse_local_variable_declarations (self, block, &_inner_error_);
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_vala_code_node_unref0 (stmt);
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								goto __catch15_vala_parse_error;
							}
							_vala_code_node_unref0 (stmt);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					break;
				}
			}
			_tmp60_ = is_decl;
			if (!_tmp60_) {
				ValaStatement* _tmp61_;
				_tmp61_ = stmt;
				vala_block_add_statement (block, _tmp61_);
			}
			_vala_code_node_unref0 (stmt);
		}
		goto __finally15;
		__catch15_vala_parse_error:
		{
			GError* e = NULL;
			GError* _tmp62_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp62_ = e;
			vala_parser_report_parse_error (self, _tmp62_);
			if (vala_parser_recover (self) != VALA_PARSER_RECOVERY_STATE_STATEMENT_BEGIN) {
				_g_error_free0 (e);
				break;
			}
			_g_error_free0 (e);
		}
		__finally15:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static gboolean
vala_parser_is_expression (ValaParser* self,
                           GError** error)
{
	gboolean result = FALSE;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_parser_current (self) == VALA_TOKEN_TYPE_OPEN_PARENS) {
		result = !vala_parser_is_inner_array_type (self);
		return result;
	}
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_skip_type (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			gboolean _tmp1_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp1_;
		} else {
			gboolean _tmp2_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp2_;
		}
	}
	switch (vala_parser_current (self)) {
		case VALA_TOKEN_TYPE_OPEN_PARENS:
		case VALA_TOKEN_TYPE_OP_INC:
		case VALA_TOKEN_TYPE_OP_DEC:
		case VALA_TOKEN_TYPE_ASSIGN:
		case VALA_TOKEN_TYPE_ASSIGN_ADD:
		case VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND:
		case VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR:
		case VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR:
		case VALA_TOKEN_TYPE_ASSIGN_DIV:
		case VALA_TOKEN_TYPE_ASSIGN_MUL:
		case VALA_TOKEN_TYPE_ASSIGN_PERCENT:
		case VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT:
		case VALA_TOKEN_TYPE_ASSIGN_SUB:
		case VALA_TOKEN_TYPE_OP_GT:
		case VALA_TOKEN_TYPE_DOT:
		case VALA_TOKEN_TYPE_OP_PTR:
		{
			ValaSourceLocation _tmp3_;
			_tmp3_ = begin;
			vala_parser_rollback (self, &_tmp3_);
			result = TRUE;
			return result;
		}
		default:
		{
			ValaSourceLocation _tmp4_;
			_tmp4_ = begin;
			vala_parser_rollback (self, &_tmp4_);
			result = FALSE;
			return result;
		}
	}
}


static gboolean
vala_parser_is_lambda_expression (ValaParser* self)
{
	gboolean result = FALSE;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSourceLocation _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	switch (vala_parser_current (self)) {
		case VALA_TOKEN_TYPE_OUT:
		case VALA_TOKEN_TYPE_REF:
		{
			gboolean _tmp1_ = FALSE;
			vala_parser_next (self);
			if (vala_parser_accept (self, VALA_TOKEN_TYPE_IDENTIFIER)) {
				_tmp1_ = vala_parser_accept (self, VALA_TOKEN_TYPE_LAMBDA);
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				ValaSourceLocation _tmp2_;
				_tmp2_ = begin;
				vala_parser_rollback (self, &_tmp2_);
				result = TRUE;
				return result;
			}
			break;
		}
		case VALA_TOKEN_TYPE_IDENTIFIER:
		{
			vala_parser_next (self);
			if (vala_parser_accept (self, VALA_TOKEN_TYPE_LAMBDA)) {
				ValaSourceLocation _tmp3_;
				_tmp3_ = begin;
				vala_parser_rollback (self, &_tmp3_);
				result = TRUE;
				return result;
			}
			break;
		}
		case VALA_TOKEN_TYPE_OPEN_PARENS:
		{
			gboolean _tmp7_ = FALSE;
			vala_parser_next (self);
			if (vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_PARENS) {
				{
					gboolean _tmp4_ = FALSE;
					_tmp4_ = TRUE;
					while (TRUE) {
						gboolean _tmp5_ = FALSE;
						if (!_tmp4_) {
							if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
								break;
							}
						}
						_tmp4_ = FALSE;
						if (vala_parser_current (self) == VALA_TOKEN_TYPE_OUT) {
							_tmp5_ = TRUE;
						} else {
							_tmp5_ = vala_parser_current (self) == VALA_TOKEN_TYPE_REF;
						}
						if (_tmp5_) {
							vala_parser_next (self);
						}
						if (!vala_parser_accept (self, VALA_TOKEN_TYPE_IDENTIFIER)) {
							ValaSourceLocation _tmp6_;
							_tmp6_ = begin;
							vala_parser_rollback (self, &_tmp6_);
							result = FALSE;
							return result;
						}
					}
				}
			}
			if (vala_parser_accept (self, VALA_TOKEN_TYPE_CLOSE_PARENS)) {
				_tmp7_ = vala_parser_accept (self, VALA_TOKEN_TYPE_LAMBDA);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				ValaSourceLocation _tmp8_;
				_tmp8_ = begin;
				vala_parser_rollback (self, &_tmp8_);
				result = TRUE;
				return result;
			}
			break;
		}
		default:
		break;
	}
	_tmp9_ = begin;
	vala_parser_rollback (self, &_tmp9_);
	result = FALSE;
	return result;
}


static ValaBlock*
vala_parser_parse_embedded_statement (ValaParser* self,
                                      const gchar* statement_name,
                                      gboolean accept_empty_body,
                                      GError** error)
{
	ValaBlock* result = NULL;
	ValaScanner* _tmp1_;
	ValaComment* _tmp2_;
	ValaBlock* block = NULL;
	ValaSourceLocation _tmp3_ = {0};
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaBlock* _tmp6_;
	ValaBlock* _tmp7_;
	ValaStatement* stmt = NULL;
	ValaStatement* _tmp8_;
	ValaBlock* _tmp9_;
	ValaStatement* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (statement_name != NULL, NULL);
	if (vala_parser_current (self) == VALA_TOKEN_TYPE_OPEN_BRACE) {
		ValaBlock* block = NULL;
		ValaBlock* _tmp0_;
		_tmp0_ = vala_parser_parse_block (self, &_inner_error_);
		block = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = block;
		return result;
	}
	_tmp1_ = self->priv->scanner;
	_tmp2_ = vala_scanner_pop_comment (_tmp1_);
	_vala_comment_unref0 (self->priv->comment);
	self->priv->comment = _tmp2_;
	vala_parser_get_location (self, &_tmp3_);
	_tmp4_ = vala_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_block_new (_tmp5_);
	_tmp7_ = _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	block = _tmp7_;
	_tmp8_ = vala_parser_parse_embedded_statement_without_block (self, statement_name, accept_empty_body, &_inner_error_);
	stmt = _tmp8_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (block);
			return NULL;
		} else {
			_vala_code_node_unref0 (block);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp9_ = block;
	_tmp10_ = stmt;
	vala_block_add_statement (_tmp9_, _tmp10_);
	result = block;
	_vala_code_node_unref0 (stmt);
	return result;
}


static ValaStatement*
vala_parser_parse_embedded_statement_without_block (ValaParser* self,
                                                    const gchar* statement_name,
                                                    gboolean accept_empty_body,
                                                    GError** error)
{
	ValaStatement* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (statement_name != NULL, NULL);
	switch (vala_parser_current (self)) {
		case VALA_TOKEN_TYPE_SEMICOLON:
		{
			ValaStatement* _tmp4_ = NULL;
			ValaStatement* _tmp5_;
			ValaStatement* _tmp6_;
			if (!accept_empty_body) {
				ValaSourceReference* _tmp0_;
				ValaSourceReference* _tmp1_;
				gchar* _tmp2_;
				gchar* _tmp3_;
				_tmp0_ = vala_parser_get_current_src (self);
				_tmp1_ = _tmp0_;
				_tmp2_ = g_strdup_printf ("%s-statement without body", statement_name);
				_tmp3_ = _tmp2_;
				vala_report_warning (_tmp1_, _tmp3_);
				_g_free0 (_tmp3_);
				_vala_source_reference_unref0 (_tmp1_);
			}
			_tmp5_ = vala_parser_parse_empty_statement (self, &_inner_error_);
			_tmp4_ = _tmp5_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp6_ = _tmp4_;
			_tmp4_ = NULL;
			result = _tmp6_;
			_vala_code_node_unref0 (_tmp4_);
			return result;
		}
		case VALA_TOKEN_TYPE_IF:
		{
			ValaStatement* _tmp7_ = NULL;
			ValaStatement* _tmp8_;
			ValaStatement* _tmp9_;
			_tmp8_ = vala_parser_parse_if_statement (self, &_inner_error_);
			_tmp7_ = _tmp8_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp9_ = _tmp7_;
			_tmp7_ = NULL;
			result = _tmp9_;
			_vala_code_node_unref0 (_tmp7_);
			return result;
		}
		case VALA_TOKEN_TYPE_SWITCH:
		{
			ValaStatement* _tmp10_ = NULL;
			ValaStatement* _tmp11_;
			ValaStatement* _tmp12_;
			_tmp11_ = vala_parser_parse_switch_statement (self, &_inner_error_);
			_tmp10_ = _tmp11_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp12_ = _tmp10_;
			_tmp10_ = NULL;
			result = _tmp12_;
			_vala_code_node_unref0 (_tmp10_);
			return result;
		}
		case VALA_TOKEN_TYPE_WHILE:
		{
			ValaStatement* _tmp13_ = NULL;
			ValaStatement* _tmp14_;
			ValaStatement* _tmp15_;
			_tmp14_ = vala_parser_parse_while_statement (self, &_inner_error_);
			_tmp13_ = _tmp14_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp15_ = _tmp13_;
			_tmp13_ = NULL;
			result = _tmp15_;
			_vala_code_node_unref0 (_tmp13_);
			return result;
		}
		case VALA_TOKEN_TYPE_DO:
		{
			ValaStatement* _tmp16_ = NULL;
			ValaStatement* _tmp17_;
			ValaStatement* _tmp18_;
			_tmp17_ = vala_parser_parse_do_statement (self, &_inner_error_);
			_tmp16_ = _tmp17_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp18_ = _tmp16_;
			_tmp16_ = NULL;
			result = _tmp18_;
			_vala_code_node_unref0 (_tmp16_);
			return result;
		}
		case VALA_TOKEN_TYPE_FOR:
		{
			ValaStatement* _tmp19_ = NULL;
			ValaStatement* _tmp20_;
			ValaStatement* _tmp21_;
			_tmp20_ = vala_parser_parse_for_statement (self, &_inner_error_);
			_tmp19_ = _tmp20_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp21_ = _tmp19_;
			_tmp19_ = NULL;
			result = _tmp21_;
			_vala_code_node_unref0 (_tmp19_);
			return result;
		}
		case VALA_TOKEN_TYPE_FOREACH:
		{
			ValaStatement* _tmp22_ = NULL;
			ValaStatement* _tmp23_;
			ValaStatement* _tmp24_;
			_tmp23_ = vala_parser_parse_foreach_statement (self, &_inner_error_);
			_tmp22_ = _tmp23_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp24_ = _tmp22_;
			_tmp22_ = NULL;
			result = _tmp24_;
			_vala_code_node_unref0 (_tmp22_);
			return result;
		}
		case VALA_TOKEN_TYPE_BREAK:
		{
			ValaStatement* _tmp25_ = NULL;
			ValaStatement* _tmp26_;
			ValaStatement* _tmp27_;
			_tmp26_ = vala_parser_parse_break_statement (self, &_inner_error_);
			_tmp25_ = _tmp26_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp27_ = _tmp25_;
			_tmp25_ = NULL;
			result = _tmp27_;
			_vala_code_node_unref0 (_tmp25_);
			return result;
		}
		case VALA_TOKEN_TYPE_CONTINUE:
		{
			ValaStatement* _tmp28_ = NULL;
			ValaStatement* _tmp29_;
			ValaStatement* _tmp30_;
			_tmp29_ = vala_parser_parse_continue_statement (self, &_inner_error_);
			_tmp28_ = _tmp29_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp30_ = _tmp28_;
			_tmp28_ = NULL;
			result = _tmp30_;
			_vala_code_node_unref0 (_tmp28_);
			return result;
		}
		case VALA_TOKEN_TYPE_RETURN:
		{
			ValaStatement* _tmp31_ = NULL;
			ValaStatement* _tmp32_;
			ValaStatement* _tmp33_;
			_tmp32_ = vala_parser_parse_return_statement (self, &_inner_error_);
			_tmp31_ = _tmp32_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp33_ = _tmp31_;
			_tmp31_ = NULL;
			result = _tmp33_;
			_vala_code_node_unref0 (_tmp31_);
			return result;
		}
		case VALA_TOKEN_TYPE_YIELD:
		{
			ValaStatement* _tmp34_ = NULL;
			ValaStatement* _tmp35_;
			ValaStatement* _tmp36_;
			_tmp35_ = vala_parser_parse_yield_statement (self, &_inner_error_);
			_tmp34_ = _tmp35_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp36_ = _tmp34_;
			_tmp34_ = NULL;
			result = _tmp36_;
			_vala_code_node_unref0 (_tmp34_);
			return result;
		}
		case VALA_TOKEN_TYPE_THROW:
		{
			ValaStatement* _tmp37_ = NULL;
			ValaStatement* _tmp38_;
			ValaStatement* _tmp39_;
			_tmp38_ = vala_parser_parse_throw_statement (self, &_inner_error_);
			_tmp37_ = _tmp38_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp39_ = _tmp37_;
			_tmp37_ = NULL;
			result = _tmp39_;
			_vala_code_node_unref0 (_tmp37_);
			return result;
		}
		case VALA_TOKEN_TYPE_TRY:
		{
			ValaStatement* _tmp40_ = NULL;
			ValaStatement* _tmp41_;
			ValaStatement* _tmp42_;
			_tmp41_ = vala_parser_parse_try_statement (self, &_inner_error_);
			_tmp40_ = _tmp41_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp42_ = _tmp40_;
			_tmp40_ = NULL;
			result = _tmp42_;
			_vala_code_node_unref0 (_tmp40_);
			return result;
		}
		case VALA_TOKEN_TYPE_LOCK:
		{
			ValaStatement* _tmp43_ = NULL;
			ValaStatement* _tmp44_;
			ValaStatement* _tmp45_;
			_tmp44_ = vala_parser_parse_lock_statement (self, &_inner_error_);
			_tmp43_ = _tmp44_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp45_ = _tmp43_;
			_tmp43_ = NULL;
			result = _tmp45_;
			_vala_code_node_unref0 (_tmp43_);
			return result;
		}
		case VALA_TOKEN_TYPE_DELETE:
		{
			ValaStatement* _tmp46_ = NULL;
			ValaStatement* _tmp47_;
			ValaStatement* _tmp48_;
			_tmp47_ = vala_parser_parse_delete_statement (self, &_inner_error_);
			_tmp46_ = _tmp47_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp48_ = _tmp46_;
			_tmp46_ = NULL;
			result = _tmp48_;
			_vala_code_node_unref0 (_tmp46_);
			return result;
		}
		case VALA_TOKEN_TYPE_VAR:
		case VALA_TOKEN_TYPE_CONST:
		{
			GError* _tmp49_;
			_tmp49_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "embedded statement cannot be declaration ");
			_inner_error_ = _tmp49_;
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		case VALA_TOKEN_TYPE_OP_INC:
		case VALA_TOKEN_TYPE_OP_DEC:
		case VALA_TOKEN_TYPE_BASE:
		case VALA_TOKEN_TYPE_THIS:
		case VALA_TOKEN_TYPE_OPEN_PARENS:
		case VALA_TOKEN_TYPE_STAR:
		case VALA_TOKEN_TYPE_NEW:
		{
			ValaStatement* _tmp50_ = NULL;
			ValaStatement* _tmp51_;
			ValaStatement* _tmp52_;
			_tmp51_ = vala_parser_parse_expression_statement (self, &_inner_error_);
			_tmp50_ = _tmp51_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp52_ = _tmp50_;
			_tmp50_ = NULL;
			result = _tmp52_;
			_vala_code_node_unref0 (_tmp50_);
			return result;
		}
		default:
		{
			gboolean _tmp53_ = FALSE;
			_tmp53_ = vala_parser_is_expression (self, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (_tmp53_) {
				ValaStatement* _tmp54_ = NULL;
				ValaStatement* _tmp55_;
				ValaStatement* _tmp56_;
				_tmp55_ = vala_parser_parse_expression_statement (self, &_inner_error_);
				_tmp54_ = _tmp55_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return NULL;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp56_ = _tmp54_;
				_tmp54_ = NULL;
				result = _tmp56_;
				_vala_code_node_unref0 (_tmp54_);
				return result;
			} else {
				GError* _tmp57_;
				_tmp57_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "embedded statement cannot be declaration");
				_inner_error_ = _tmp57_;
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
}


static ValaBlock*
vala_parser_parse_block (ValaParser* self,
                         GError** error)
{
	ValaBlock* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaBlock* block = NULL;
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaBlock* _tmp4_;
	ValaBlock* _tmp5_;
	ValaBlock* _tmp6_;
	ValaBlock* _tmp12_;
	ValaSourceReference* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSourceReference* _tmp16_;
	ValaSourceLocation _tmp17_ = {0};
	ValaSourceLocation _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = begin;
	_tmp2_ = vala_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_block_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	block = _tmp5_;
	_tmp6_ = block;
	vala_parser_parse_statements (self, _tmp6_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (block);
			return NULL;
		} else {
			_vala_code_node_unref0 (block);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (!vala_parser_accept (self, VALA_TOKEN_TYPE_CLOSE_BRACE)) {
		ValaCodeContext* _tmp7_;
		ValaReport* _tmp8_;
		ValaReport* _tmp9_;
		_tmp7_ = self->priv->context;
		_tmp8_ = vala_code_context_get_report (_tmp7_);
		_tmp9_ = _tmp8_;
		if (vala_report_get_errors (_tmp9_) == 0) {
			ValaSourceReference* _tmp10_;
			ValaSourceReference* _tmp11_;
			_tmp10_ = vala_parser_get_current_src (self);
			_tmp11_ = _tmp10_;
			vala_report_error (_tmp11_, "expected `}'");
			_vala_source_reference_unref0 (_tmp11_);
		}
	}
	_tmp12_ = block;
	_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_parser_get_current_src (self);
	_tmp16_ = _tmp15_;
	vala_source_reference_get_end (_tmp16_, &_tmp17_);
	_tmp18_ = _tmp17_;
	vala_source_reference_set_end (_tmp14_, &_tmp18_);
	_vala_source_reference_unref0 (_tmp16_);
	result = block;
	return result;
}


static ValaStatement*
vala_parser_parse_empty_statement (ValaParser* self,
                                   GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaEmptyStatement* _tmp4_;
	ValaStatement* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = begin;
	_tmp2_ = vala_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_empty_statement_new (_tmp3_);
	_tmp5_ = (ValaStatement*) _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static void
_vala_array_add12 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
vala_parser_parse_local_variable_declarations (ValaParser* self,
                                               ValaBlock* block,
                                               GError** error)
{
	ValaDataType* variable_type = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_VAR)) {
		_vala_code_node_unref0 (variable_type);
		variable_type = NULL;
	} else {
		ValaDataType* _tmp0_ = NULL;
		ValaDataType* _tmp1_;
		ValaDataType* _tmp2_;
		_tmp1_ = vala_parser_parse_type (self, TRUE, TRUE, FALSE, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (variable_type);
				return;
			} else {
				_vala_code_node_unref0 (variable_type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_vala_code_node_unref0 (variable_type);
		variable_type = _tmp2_;
		_vala_code_node_unref0 (_tmp0_);
	}
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = TRUE;
		while (TRUE) {
			gboolean _tmp4_ = FALSE;
			ValaDataType* _tmp5_;
			ValaDataType* type_copy = NULL;
			ValaDataType* _tmp64_;
			ValaLocalVariable* local = NULL;
			ValaDataType* _tmp67_;
			ValaLocalVariable* _tmp68_;
			ValaLocalVariable* _tmp69_;
			ValaLocalVariable* _tmp70_;
			ValaSourceReference* _tmp71_;
			ValaSourceReference* _tmp72_;
			ValaDeclarationStatement* _tmp73_;
			ValaDeclarationStatement* _tmp74_;
			if (!_tmp3_) {
				if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
					break;
				}
			}
			_tmp3_ = FALSE;
			_tmp5_ = variable_type;
			if (_tmp5_ == NULL) {
				_tmp4_ = vala_parser_accept (self, VALA_TOKEN_TYPE_OPEN_PARENS);
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				ValaSourceLocation begin = {0};
				ValaSourceLocation _tmp6_ = {0};
				gchar** identifiers = NULL;
				gchar** _tmp7_;
				gint identifiers_length1;
				gint _identifiers_size_;
				ValaExpression* tuple = NULL;
				ValaExpression* _tmp13_;
				ValaLocalVariable* tuple_local = NULL;
				gchar* _tmp14_;
				gchar* _tmp15_;
				ValaExpression* _tmp16_;
				ValaSourceLocation _tmp17_;
				ValaSourceReference* _tmp18_;
				ValaSourceReference* _tmp19_;
				ValaLocalVariable* _tmp20_;
				ValaLocalVariable* _tmp21_;
				ValaLocalVariable* _tmp22_;
				ValaLocalVariable* _tmp23_;
				ValaSourceReference* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaDeclarationStatement* _tmp26_;
				ValaDeclarationStatement* _tmp27_;
				vala_parser_get_location (self, &_tmp6_);
				begin = _tmp6_;
				_tmp7_ = g_new0 (gchar*, 0 + 1);
				identifiers = _tmp7_;
				identifiers_length1 = 0;
				_identifiers_size_ = identifiers_length1;
				{
					gboolean _tmp8_ = FALSE;
					_tmp8_ = TRUE;
					while (TRUE) {
						gchar* _tmp9_ = NULL;
						gchar* _tmp10_;
						gchar** _tmp11_;
						gint _tmp11__length1;
						gchar* _tmp12_;
						if (!_tmp8_) {
							if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
								break;
							}
						}
						_tmp8_ = FALSE;
						_tmp10_ = vala_parser_parse_identifier (self, &_inner_error_);
						_tmp9_ = _tmp10_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								identifiers = (_vala_array_free (identifiers, identifiers_length1, (GDestroyNotify) g_free), NULL);
								_vala_code_node_unref0 (variable_type);
								return;
							} else {
								identifiers = (_vala_array_free (identifiers, identifiers_length1, (GDestroyNotify) g_free), NULL);
								_vala_code_node_unref0 (variable_type);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp11_ = identifiers;
						_tmp11__length1 = identifiers_length1;
						_tmp12_ = _tmp9_;
						_tmp9_ = NULL;
						_vala_array_add12 (&identifiers, &identifiers_length1, &_identifiers_size_, _tmp12_);
						_g_free0 (_tmp9_);
					}
				}
				vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						identifiers = (_vala_array_free (identifiers, identifiers_length1, (GDestroyNotify) g_free), NULL);
						_vala_code_node_unref0 (variable_type);
						return;
					} else {
						identifiers = (_vala_array_free (identifiers, identifiers_length1, (GDestroyNotify) g_free), NULL);
						_vala_code_node_unref0 (variable_type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				vala_parser_expect (self, VALA_TOKEN_TYPE_ASSIGN, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						identifiers = (_vala_array_free (identifiers, identifiers_length1, (GDestroyNotify) g_free), NULL);
						_vala_code_node_unref0 (variable_type);
						return;
					} else {
						identifiers = (_vala_array_free (identifiers, identifiers_length1, (GDestroyNotify) g_free), NULL);
						_vala_code_node_unref0 (variable_type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp13_ = vala_parser_parse_expression (self, &_inner_error_);
				tuple = _tmp13_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						identifiers = (_vala_array_free (identifiers, identifiers_length1, (GDestroyNotify) g_free), NULL);
						_vala_code_node_unref0 (variable_type);
						return;
					} else {
						identifiers = (_vala_array_free (identifiers, identifiers_length1, (GDestroyNotify) g_free), NULL);
						_vala_code_node_unref0 (variable_type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp14_ = vala_code_node_get_temp_name ();
				_tmp15_ = _tmp14_;
				_tmp16_ = tuple;
				_tmp17_ = begin;
				_tmp18_ = vala_parser_get_src (self, &_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = vala_local_variable_new (NULL, _tmp15_, _tmp16_, _tmp19_);
				_tmp21_ = _tmp20_;
				_vala_source_reference_unref0 (_tmp19_);
				_g_free0 (_tmp15_);
				tuple_local = _tmp21_;
				_tmp22_ = tuple_local;
				_tmp23_ = tuple_local;
				_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp22_, _tmp25_);
				_tmp27_ = _tmp26_;
				vala_block_add_statement (block, (ValaStatement*) _tmp27_);
				_vala_code_node_unref0 (_tmp27_);
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp28_ = FALSE;
						_tmp28_ = TRUE;
						while (TRUE) {
							gint _tmp30_;
							gchar** _tmp31_;
							gint _tmp31__length1;
							ValaMemberAccess* temp_access = NULL;
							ValaLocalVariable* _tmp32_;
							const gchar* _tmp33_;
							const gchar* _tmp34_;
							ValaLocalVariable* _tmp35_;
							ValaSourceReference* _tmp36_;
							ValaSourceReference* _tmp37_;
							ValaMemberAccess* _tmp38_;
							ValaElementAccess* ea = NULL;
							ValaMemberAccess* _tmp39_;
							ValaLocalVariable* _tmp40_;
							ValaSourceReference* _tmp41_;
							ValaSourceReference* _tmp42_;
							ValaElementAccess* _tmp43_;
							ValaElementAccess* _tmp44_;
							gint _tmp45_;
							gchar* _tmp46_;
							gchar* _tmp47_;
							ValaIntegerLiteral* _tmp48_;
							ValaIntegerLiteral* _tmp49_;
							ValaLocalVariable* local = NULL;
							gchar** _tmp50_;
							gint _tmp50__length1;
							gint _tmp51_;
							const gchar* _tmp52_;
							ValaElementAccess* _tmp53_;
							ValaLocalVariable* _tmp54_;
							ValaSourceReference* _tmp55_;
							ValaSourceReference* _tmp56_;
							ValaLocalVariable* _tmp57_;
							ValaLocalVariable* _tmp58_;
							ValaLocalVariable* _tmp59_;
							ValaSourceReference* _tmp60_;
							ValaSourceReference* _tmp61_;
							ValaDeclarationStatement* _tmp62_;
							ValaDeclarationStatement* _tmp63_;
							if (!_tmp28_) {
								gint _tmp29_;
								_tmp29_ = i;
								i = _tmp29_ + 1;
							}
							_tmp28_ = FALSE;
							_tmp30_ = i;
							_tmp31_ = identifiers;
							_tmp31__length1 = identifiers_length1;
							if (!(_tmp30_ < _tmp31__length1)) {
								break;
							}
							_tmp32_ = tuple_local;
							_tmp33_ = vala_symbol_get_name ((ValaSymbol*) _tmp32_);
							_tmp34_ = _tmp33_;
							_tmp35_ = tuple_local;
							_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp35_);
							_tmp37_ = _tmp36_;
							_tmp38_ = vala_member_access_new_simple (_tmp34_, _tmp37_);
							temp_access = _tmp38_;
							_tmp39_ = temp_access;
							_tmp40_ = tuple_local;
							_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp40_);
							_tmp42_ = _tmp41_;
							_tmp43_ = vala_element_access_new ((ValaExpression*) _tmp39_, _tmp42_);
							ea = _tmp43_;
							_tmp44_ = ea;
							_tmp45_ = i;
							_tmp46_ = g_strdup_printf ("%i", _tmp45_);
							_tmp47_ = _tmp46_;
							_tmp48_ = vala_integer_literal_new (_tmp47_, NULL);
							_tmp49_ = _tmp48_;
							vala_element_access_append_index (_tmp44_, (ValaExpression*) _tmp49_);
							_vala_code_node_unref0 (_tmp49_);
							_g_free0 (_tmp47_);
							_tmp50_ = identifiers;
							_tmp50__length1 = identifiers_length1;
							_tmp51_ = i;
							_tmp52_ = _tmp50_[_tmp51_];
							_tmp53_ = ea;
							_tmp54_ = tuple_local;
							_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
							_tmp56_ = _tmp55_;
							_tmp57_ = vala_local_variable_new (NULL, _tmp52_, (ValaExpression*) _tmp53_, _tmp56_);
							local = _tmp57_;
							_tmp58_ = local;
							_tmp59_ = local;
							_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp59_);
							_tmp61_ = _tmp60_;
							_tmp62_ = vala_declaration_statement_new ((ValaSymbol*) _tmp58_, _tmp61_);
							_tmp63_ = _tmp62_;
							vala_block_add_statement (block, (ValaStatement*) _tmp63_);
							_vala_code_node_unref0 (_tmp63_);
							_vala_code_node_unref0 (local);
							_vala_code_node_unref0 (ea);
							_vala_code_node_unref0 (temp_access);
						}
					}
				}
				_vala_code_node_unref0 (tuple_local);
				_vala_code_node_unref0 (tuple);
				identifiers = (_vala_array_free (identifiers, identifiers_length1, (GDestroyNotify) g_free), NULL);
				continue;
			}
			type_copy = NULL;
			_tmp64_ = variable_type;
			if (_tmp64_ != NULL) {
				ValaDataType* _tmp65_;
				ValaDataType* _tmp66_;
				_tmp65_ = variable_type;
				_tmp66_ = vala_data_type_copy (_tmp65_);
				_vala_code_node_unref0 (type_copy);
				type_copy = _tmp66_;
			}
			_tmp67_ = type_copy;
			_tmp68_ = vala_parser_parse_local_variable (self, _tmp67_, &_inner_error_);
			local = _tmp68_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (type_copy);
					_vala_code_node_unref0 (variable_type);
					return;
				} else {
					_vala_code_node_unref0 (type_copy);
					_vala_code_node_unref0 (variable_type);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp69_ = local;
			_tmp70_ = local;
			_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = vala_declaration_statement_new ((ValaSymbol*) _tmp69_, _tmp72_);
			_tmp74_ = _tmp73_;
			vala_block_add_statement (block, (ValaStatement*) _tmp74_);
			_vala_code_node_unref0 (_tmp74_);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (type_copy);
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (variable_type);
			return;
		} else {
			_vala_code_node_unref0 (variable_type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_vala_code_node_unref0 (variable_type);
}


static ValaLocalVariable*
vala_parser_parse_local_variable (ValaParser* self,
                                  ValaDataType* variable_type,
                                  GError** error)
{
	ValaLocalVariable* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gchar* id = NULL;
	gchar* _tmp1_;
	ValaDataType* type = NULL;
	ValaDataType* _tmp2_;
	ValaExpression* initializer = NULL;
	ValaDataType* _tmp6_;
	const gchar* _tmp7_;
	ValaExpression* _tmp8_;
	ValaSourceLocation _tmp9_;
	ValaSourceReference* _tmp10_;
	ValaSourceReference* _tmp11_;
	ValaLocalVariable* _tmp12_;
	ValaLocalVariable* _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_identifier (self, &_inner_error_);
	id = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = vala_parser_parse_inline_array_type (self, variable_type, &_inner_error_);
	type = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	initializer = NULL;
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp3_ = NULL;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_parser_parse_expression (self, &_inner_error_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				return NULL;
			} else {
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (type);
				_g_free0 (id);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_vala_code_node_unref0 (initializer);
		initializer = _tmp5_;
		_vala_code_node_unref0 (_tmp3_);
	}
	_tmp6_ = type;
	_tmp7_ = id;
	_tmp8_ = initializer;
	_tmp9_ = begin;
	_tmp10_ = vala_parser_get_src (self, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_local_variable_new (_tmp6_, _tmp7_, _tmp8_, _tmp11_);
	_tmp13_ = _tmp12_;
	_vala_source_reference_unref0 (_tmp11_);
	result = _tmp13_;
	_vala_code_node_unref0 (initializer);
	_vala_code_node_unref0 (type);
	_g_free0 (id);
	return result;
}


static void
vala_parser_parse_local_constant_declarations (ValaParser* self,
                                               ValaBlock* block,
                                               GError** error)
{
	ValaDataType* constant_type = NULL;
	ValaDataType* _tmp0_;
	ValaArrayType* array_type = NULL;
	ValaDataType* _tmp1_;
	ValaArrayType* _tmp2_;
	ValaArrayType* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	vala_parser_expect (self, VALA_TOKEN_TYPE_CONST, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp0_ = vala_parser_parse_type (self, FALSE, FALSE, FALSE, &_inner_error_);
	constant_type = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = constant_type;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp1_) : NULL);
	array_type = _tmp2_;
	_tmp3_ = array_type;
	if (_tmp3_ != NULL) {
		ValaArrayType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		_tmp4_ = array_type;
		_tmp5_ = vala_array_type_get_element_type (_tmp4_);
		_tmp6_ = _tmp5_;
		vala_data_type_set_value_owned (_tmp6_, FALSE);
	}
	{
		gboolean _tmp7_ = FALSE;
		_tmp7_ = TRUE;
		while (TRUE) {
			ValaDataType* type_copy = NULL;
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			ValaConstant* local = NULL;
			ValaDataType* _tmp10_;
			ValaConstant* _tmp11_;
			ValaConstant* _tmp12_;
			ValaConstant* _tmp13_;
			ValaSourceReference* _tmp14_;
			ValaSourceReference* _tmp15_;
			ValaDeclarationStatement* _tmp16_;
			ValaDeclarationStatement* _tmp17_;
			ValaConstant* _tmp18_;
			ValaConstant* _tmp19_;
			if (!_tmp7_) {
				if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
					break;
				}
			}
			_tmp7_ = FALSE;
			_tmp8_ = constant_type;
			_tmp9_ = vala_data_type_copy (_tmp8_);
			type_copy = _tmp9_;
			_tmp10_ = type_copy;
			_tmp11_ = vala_parser_parse_local_constant (self, _tmp10_, &_inner_error_);
			local = _tmp11_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (type_copy);
					_vala_code_node_unref0 (array_type);
					_vala_code_node_unref0 (constant_type);
					return;
				} else {
					_vala_code_node_unref0 (type_copy);
					_vala_code_node_unref0 (array_type);
					_vala_code_node_unref0 (constant_type);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp12_ = local;
			_tmp13_ = local;
			_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_declaration_statement_new ((ValaSymbol*) _tmp12_, _tmp15_);
			_tmp17_ = _tmp16_;
			vala_block_add_statement (block, (ValaStatement*) _tmp17_);
			_vala_code_node_unref0 (_tmp17_);
			_tmp18_ = local;
			vala_block_add_local_constant (block, _tmp18_);
			_tmp19_ = local;
			vala_symbol_set_active ((ValaSymbol*) _tmp19_, FALSE);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (type_copy);
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (array_type);
			_vala_code_node_unref0 (constant_type);
			return;
		} else {
			_vala_code_node_unref0 (array_type);
			_vala_code_node_unref0 (constant_type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (constant_type);
}


static ValaConstant*
vala_parser_parse_local_constant (ValaParser* self,
                                  ValaDataType* constant_type,
                                  GError** error)
{
	ValaConstant* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gchar* id = NULL;
	gchar* _tmp1_;
	ValaDataType* type = NULL;
	ValaDataType* _tmp2_;
	ValaExpression* initializer = NULL;
	ValaExpression* _tmp3_;
	const gchar* _tmp4_;
	ValaDataType* _tmp5_;
	ValaExpression* _tmp6_;
	ValaSourceLocation _tmp7_;
	ValaSourceReference* _tmp8_;
	ValaSourceReference* _tmp9_;
	ValaConstant* _tmp10_;
	ValaConstant* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (constant_type != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_identifier (self, &_inner_error_);
	id = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = vala_parser_parse_inline_array_type (self, constant_type, &_inner_error_);
	type = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (id);
			return NULL;
		} else {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_ASSIGN, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (type);
			_g_free0 (id);
			return NULL;
		} else {
			_vala_code_node_unref0 (type);
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = vala_parser_parse_expression (self, &_inner_error_);
	initializer = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (type);
			_g_free0 (id);
			return NULL;
		} else {
			_vala_code_node_unref0 (type);
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = id;
	_tmp5_ = type;
	_tmp6_ = initializer;
	_tmp7_ = begin;
	_tmp8_ = vala_parser_get_src (self, &_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_constant_new (_tmp4_, _tmp5_, _tmp6_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_vala_source_reference_unref0 (_tmp9_);
	result = _tmp11_;
	_vala_code_node_unref0 (initializer);
	_vala_code_node_unref0 (type);
	_g_free0 (id);
	return result;
}


static ValaStatement*
vala_parser_parse_expression_statement (ValaParser* self,
                                        GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* expr = NULL;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaExpressionStatement* _tmp6_;
	ValaStatement* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_parser_parse_statement_expression (self, &_inner_error_);
	expr = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (expr);
			return NULL;
		} else {
			_vala_code_node_unref0 (expr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = expr;
	_tmp3_ = begin;
	_tmp4_ = vala_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_statement_new (_tmp2_, _tmp5_);
	_tmp7_ = (ValaStatement*) _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	result = _tmp7_;
	_vala_code_node_unref0 (expr);
	return result;
}


static ValaExpression*
vala_parser_parse_statement_expression (ValaParser* self,
                                        GError** error)
{
	ValaExpression* result = NULL;
	ValaExpression* expr = NULL;
	ValaExpression* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_parser_parse_expression (self, &_inner_error_);
	expr = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = expr;
	return result;
}


static ValaStatement*
vala_parser_parse_if_statement (ValaParser* self,
                                GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* condition = NULL;
	ValaExpression* _tmp1_;
	ValaSourceReference* src = NULL;
	ValaSourceLocation _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaBlock* true_stmt = NULL;
	ValaBlock* _tmp4_;
	ValaBlock* false_stmt = NULL;
	ValaExpression* _tmp8_;
	ValaBlock* _tmp9_;
	ValaBlock* _tmp10_;
	ValaSourceReference* _tmp11_;
	ValaIfStatement* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_IF, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = vala_parser_parse_expression (self, &_inner_error_);
	condition = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (condition);
			return NULL;
		} else {
			_vala_code_node_unref0 (condition);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = begin;
	_tmp3_ = vala_parser_get_src (self, &_tmp2_);
	src = _tmp3_;
	_tmp4_ = vala_parser_parse_embedded_statement (self, "if", FALSE, &_inner_error_);
	true_stmt = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_source_reference_unref0 (src);
			_vala_code_node_unref0 (condition);
			return NULL;
		} else {
			_vala_source_reference_unref0 (src);
			_vala_code_node_unref0 (condition);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	false_stmt = NULL;
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_ELSE)) {
		ValaBlock* _tmp5_ = NULL;
		ValaBlock* _tmp6_;
		ValaBlock* _tmp7_;
		_tmp6_ = vala_parser_parse_embedded_statement (self, "else", FALSE, &_inner_error_);
		_tmp5_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (false_stmt);
				_vala_code_node_unref0 (true_stmt);
				_vala_source_reference_unref0 (src);
				_vala_code_node_unref0 (condition);
				return NULL;
			} else {
				_vala_code_node_unref0 (false_stmt);
				_vala_code_node_unref0 (true_stmt);
				_vala_source_reference_unref0 (src);
				_vala_code_node_unref0 (condition);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp7_ = _tmp5_;
		_tmp5_ = NULL;
		_vala_code_node_unref0 (false_stmt);
		false_stmt = _tmp7_;
		_vala_code_node_unref0 (_tmp5_);
	}
	_tmp8_ = condition;
	_tmp9_ = true_stmt;
	_tmp10_ = false_stmt;
	_tmp11_ = src;
	_tmp12_ = vala_if_statement_new (_tmp8_, _tmp9_, _tmp10_, _tmp11_);
	result = (ValaStatement*) _tmp12_;
	_vala_code_node_unref0 (false_stmt);
	_vala_code_node_unref0 (true_stmt);
	_vala_source_reference_unref0 (src);
	_vala_code_node_unref0 (condition);
	return result;
}


static ValaStatement*
vala_parser_parse_switch_statement (ValaParser* self,
                                    GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* condition = NULL;
	ValaExpression* _tmp1_;
	ValaSwitchStatement* stmt = NULL;
	ValaExpression* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSwitchStatement* _tmp6_;
	ValaSwitchStatement* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_SWITCH, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = vala_parser_parse_expression (self, &_inner_error_);
	condition = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (condition);
			return NULL;
		} else {
			_vala_code_node_unref0 (condition);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = condition;
	_tmp3_ = begin;
	_tmp4_ = vala_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_switch_statement_new (_tmp2_, _tmp5_);
	_tmp7_ = _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	stmt = _tmp7_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (condition);
			return NULL;
		} else {
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (condition);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaSourceLocation _tmp8_ = {0};
		ValaSwitchSection* section = NULL;
		ValaSourceLocation _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSwitchSection* _tmp12_;
		ValaSwitchSection* _tmp13_;
		ValaSwitchSection* _tmp38_;
		ValaSwitchStatement* _tmp39_;
		ValaSwitchSection* _tmp40_;
		if (!(vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_BRACE)) {
			break;
		}
		vala_parser_get_location (self, &_tmp8_);
		begin = _tmp8_;
		_tmp9_ = begin;
		_tmp10_ = vala_parser_get_src (self, &_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_switch_section_new (_tmp11_);
		_tmp13_ = _tmp12_;
		_vala_source_reference_unref0 (_tmp11_);
		section = _tmp13_;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				if (!_tmp14_) {
					gboolean _tmp15_ = FALSE;
					if (vala_parser_current (self) == VALA_TOKEN_TYPE_CASE) {
						_tmp15_ = TRUE;
					} else {
						_tmp15_ = vala_parser_current (self) == VALA_TOKEN_TYPE_DEFAULT;
					}
					if (!_tmp15_) {
						break;
					}
				}
				_tmp14_ = FALSE;
				if (vala_parser_accept (self, VALA_TOKEN_TYPE_CASE)) {
					ValaExpression* _tmp16_ = NULL;
					ValaExpression* _tmp17_;
					ValaSwitchSection* _tmp18_;
					ValaSourceLocation _tmp19_;
					ValaSourceReference* _tmp20_;
					ValaSourceReference* _tmp21_;
					ValaSwitchLabel* _tmp22_;
					ValaSwitchLabel* _tmp23_;
					_tmp17_ = vala_parser_parse_expression (self, &_inner_error_);
					_tmp16_ = _tmp17_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_vala_code_node_unref0 (section);
							_vala_code_node_unref0 (stmt);
							_vala_code_node_unref0 (condition);
							return NULL;
						} else {
							_vala_code_node_unref0 (section);
							_vala_code_node_unref0 (stmt);
							_vala_code_node_unref0 (condition);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp18_ = section;
					_tmp19_ = begin;
					_tmp20_ = vala_parser_get_src (self, &_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = vala_switch_label_new (_tmp16_, _tmp21_);
					_tmp23_ = _tmp22_;
					vala_switch_section_add_label (_tmp18_, _tmp23_);
					_vala_code_node_unref0 (_tmp23_);
					_vala_source_reference_unref0 (_tmp21_);
					while (TRUE) {
						ValaExpression* _tmp24_ = NULL;
						ValaExpression* _tmp25_;
						ValaSwitchSection* _tmp26_;
						ValaSourceLocation _tmp27_;
						ValaSourceReference* _tmp28_;
						ValaSourceReference* _tmp29_;
						ValaSwitchLabel* _tmp30_;
						ValaSwitchLabel* _tmp31_;
						if (!(vala_parser_current (self) == VALA_TOKEN_TYPE_COMMA)) {
							break;
						}
						vala_parser_expect (self, VALA_TOKEN_TYPE_COMMA, &_inner_error_);
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								_vala_code_node_unref0 (_tmp16_);
								_vala_code_node_unref0 (section);
								_vala_code_node_unref0 (stmt);
								_vala_code_node_unref0 (condition);
								return NULL;
							} else {
								_vala_code_node_unref0 (_tmp16_);
								_vala_code_node_unref0 (section);
								_vala_code_node_unref0 (stmt);
								_vala_code_node_unref0 (condition);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_tmp25_ = vala_parser_parse_expression (self, &_inner_error_);
						_tmp24_ = _tmp25_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								_vala_code_node_unref0 (_tmp16_);
								_vala_code_node_unref0 (section);
								_vala_code_node_unref0 (stmt);
								_vala_code_node_unref0 (condition);
								return NULL;
							} else {
								_vala_code_node_unref0 (_tmp16_);
								_vala_code_node_unref0 (section);
								_vala_code_node_unref0 (stmt);
								_vala_code_node_unref0 (condition);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_tmp26_ = section;
						_tmp27_ = begin;
						_tmp28_ = vala_parser_get_src (self, &_tmp27_);
						_tmp29_ = _tmp28_;
						_tmp30_ = vala_switch_label_new (_tmp24_, _tmp29_);
						_tmp31_ = _tmp30_;
						vala_switch_section_add_label (_tmp26_, _tmp31_);
						_vala_code_node_unref0 (_tmp31_);
						_vala_source_reference_unref0 (_tmp29_);
						_vala_code_node_unref0 (_tmp24_);
					}
					_vala_code_node_unref0 (_tmp16_);
				} else {
					ValaSwitchSection* _tmp32_;
					ValaSourceLocation _tmp33_;
					ValaSourceReference* _tmp34_;
					ValaSourceReference* _tmp35_;
					ValaSwitchLabel* _tmp36_;
					ValaSwitchLabel* _tmp37_;
					vala_parser_expect (self, VALA_TOKEN_TYPE_DEFAULT, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_vala_code_node_unref0 (section);
							_vala_code_node_unref0 (stmt);
							_vala_code_node_unref0 (condition);
							return NULL;
						} else {
							_vala_code_node_unref0 (section);
							_vala_code_node_unref0 (stmt);
							_vala_code_node_unref0 (condition);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp32_ = section;
					_tmp33_ = begin;
					_tmp34_ = vala_parser_get_src (self, &_tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = vala_switch_label_new_with_default (_tmp35_);
					_tmp37_ = _tmp36_;
					vala_switch_section_add_label (_tmp32_, _tmp37_);
					_vala_code_node_unref0 (_tmp37_);
					_vala_source_reference_unref0 (_tmp35_);
				}
				vala_parser_expect (self, VALA_TOKEN_TYPE_COLON, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (section);
						_vala_code_node_unref0 (stmt);
						_vala_code_node_unref0 (condition);
						return NULL;
					} else {
						_vala_code_node_unref0 (section);
						_vala_code_node_unref0 (stmt);
						_vala_code_node_unref0 (condition);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
		}
		_tmp38_ = section;
		vala_parser_parse_statements (self, (ValaBlock*) _tmp38_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (section);
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (condition);
				return NULL;
			} else {
				_vala_code_node_unref0 (section);
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (condition);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp39_ = stmt;
		_tmp40_ = section;
		vala_switch_statement_add_section (_tmp39_, _tmp40_);
		_vala_code_node_unref0 (section);
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (condition);
			return NULL;
		} else {
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (condition);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = (ValaStatement*) stmt;
	_vala_code_node_unref0 (condition);
	return result;
}


static ValaStatement*
vala_parser_parse_while_statement (ValaParser* self,
                                   GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* condition = NULL;
	ValaExpression* _tmp1_;
	ValaBlock* body = NULL;
	ValaBlock* _tmp2_;
	ValaExpression* _tmp3_;
	ValaBlock* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaWhileStatement* _tmp8_;
	ValaStatement* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_WHILE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = vala_parser_parse_expression (self, &_inner_error_);
	condition = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (condition);
			return NULL;
		} else {
			_vala_code_node_unref0 (condition);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = vala_parser_parse_embedded_statement (self, "while", TRUE, &_inner_error_);
	body = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (condition);
			return NULL;
		} else {
			_vala_code_node_unref0 (condition);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = condition;
	_tmp4_ = body;
	_tmp5_ = begin;
	_tmp6_ = vala_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_while_statement_new (_tmp3_, _tmp4_, _tmp7_);
	_tmp9_ = (ValaStatement*) _tmp8_;
	_vala_source_reference_unref0 (_tmp7_);
	result = _tmp9_;
	_vala_code_node_unref0 (body);
	_vala_code_node_unref0 (condition);
	return result;
}


static ValaStatement*
vala_parser_parse_do_statement (ValaParser* self,
                                GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaBlock* body = NULL;
	ValaBlock* _tmp1_;
	ValaExpression* condition = NULL;
	ValaExpression* _tmp2_;
	ValaBlock* _tmp3_;
	ValaExpression* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaDoStatement* _tmp8_;
	ValaStatement* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_DO, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = vala_parser_parse_embedded_statement (self, "do", TRUE, &_inner_error_);
	body = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_WHILE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (body);
			return NULL;
		} else {
			_vala_code_node_unref0 (body);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (body);
			return NULL;
		} else {
			_vala_code_node_unref0 (body);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = vala_parser_parse_expression (self, &_inner_error_);
	condition = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (body);
			return NULL;
		} else {
			_vala_code_node_unref0 (body);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (condition);
			_vala_code_node_unref0 (body);
			return NULL;
		} else {
			_vala_code_node_unref0 (condition);
			_vala_code_node_unref0 (body);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (condition);
			_vala_code_node_unref0 (body);
			return NULL;
		} else {
			_vala_code_node_unref0 (condition);
			_vala_code_node_unref0 (body);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = body;
	_tmp4_ = condition;
	_tmp5_ = begin;
	_tmp6_ = vala_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_do_statement_new (_tmp3_, _tmp4_, _tmp7_);
	_tmp9_ = (ValaStatement*) _tmp8_;
	_vala_source_reference_unref0 (_tmp7_);
	result = _tmp9_;
	_vala_code_node_unref0 (condition);
	_vala_code_node_unref0 (body);
	return result;
}


static ValaStatement*
vala_parser_parse_for_statement (ValaParser* self,
                                 GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaBlock* block = NULL;
	ValaArrayList* initializer_list = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaExpression* condition = NULL;
	ValaArrayList* iterator_list = NULL;
	GEqualFunc _tmp17_;
	ValaArrayList* _tmp18_;
	ValaSourceReference* src = NULL;
	ValaSourceLocation _tmp23_;
	ValaSourceReference* _tmp24_;
	ValaBlock* body = NULL;
	ValaBlock* _tmp25_;
	ValaForStatement* stmt = NULL;
	ValaExpression* _tmp26_;
	ValaBlock* _tmp27_;
	ValaSourceReference* _tmp28_;
	ValaForStatement* _tmp29_;
	ValaBlock* _tmp56_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	block = NULL;
	vala_parser_expect (self, VALA_TOKEN_TYPE_FOR, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (block);
			return NULL;
		} else {
			_vala_code_node_unref0 (block);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (block);
			return NULL;
		} else {
			_vala_code_node_unref0 (block);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	initializer_list = _tmp2_;
	if (!vala_parser_accept (self, VALA_TOKEN_TYPE_SEMICOLON)) {
		gboolean is_expr = FALSE;
		gboolean _tmp4_;
		switch (vala_parser_current (self)) {
			case VALA_TOKEN_TYPE_VAR:
			{
				is_expr = FALSE;
				break;
			}
			case VALA_TOKEN_TYPE_OP_INC:
			case VALA_TOKEN_TYPE_OP_DEC:
			{
				is_expr = TRUE;
				break;
			}
			default:
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = vala_parser_is_expression (self, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_iterable_unref0 (initializer_list);
						_vala_code_node_unref0 (block);
						return NULL;
					} else {
						_vala_iterable_unref0 (initializer_list);
						_vala_code_node_unref0 (block);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				is_expr = _tmp3_;
				break;
			}
		}
		_tmp4_ = is_expr;
		if (_tmp4_) {
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					ValaExpression* _tmp6_ = NULL;
					ValaExpression* _tmp7_;
					ValaArrayList* _tmp8_;
					if (!_tmp5_) {
						if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
							break;
						}
					}
					_tmp5_ = FALSE;
					_tmp7_ = vala_parser_parse_statement_expression (self, &_inner_error_);
					_tmp6_ = _tmp7_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_vala_iterable_unref0 (initializer_list);
							_vala_code_node_unref0 (block);
							return NULL;
						} else {
							_vala_iterable_unref0 (initializer_list);
							_vala_code_node_unref0 (block);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp8_ = initializer_list;
					vala_collection_add ((ValaCollection*) _tmp8_, _tmp6_);
					_vala_code_node_unref0 (_tmp6_);
				}
			}
			vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_iterable_unref0 (initializer_list);
					_vala_code_node_unref0 (block);
					return NULL;
				} else {
					_vala_iterable_unref0 (initializer_list);
					_vala_code_node_unref0 (block);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		} else {
			ValaSourceLocation _tmp9_;
			ValaSourceReference* _tmp10_;
			ValaSourceReference* _tmp11_;
			ValaBlock* _tmp12_;
			ValaBlock* _tmp13_;
			_tmp9_ = begin;
			_tmp10_ = vala_parser_get_src (self, &_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_block_new (_tmp11_);
			_vala_code_node_unref0 (block);
			block = _tmp12_;
			_vala_source_reference_unref0 (_tmp11_);
			_tmp13_ = block;
			vala_parser_parse_local_variable_declarations (self, _tmp13_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_iterable_unref0 (initializer_list);
					_vala_code_node_unref0 (block);
					return NULL;
				} else {
					_vala_iterable_unref0 (initializer_list);
					_vala_code_node_unref0 (block);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	condition = NULL;
	if (vala_parser_current (self) != VALA_TOKEN_TYPE_SEMICOLON) {
		ValaExpression* _tmp14_ = NULL;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_parser_parse_expression (self, &_inner_error_);
		_tmp14_ = _tmp15_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (condition);
				_vala_iterable_unref0 (initializer_list);
				_vala_code_node_unref0 (block);
				return NULL;
			} else {
				_vala_code_node_unref0 (condition);
				_vala_iterable_unref0 (initializer_list);
				_vala_code_node_unref0 (block);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp16_ = _tmp14_;
		_tmp14_ = NULL;
		_vala_code_node_unref0 (condition);
		condition = _tmp16_;
		_vala_code_node_unref0 (_tmp14_);
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (condition);
			_vala_iterable_unref0 (initializer_list);
			_vala_code_node_unref0 (block);
			return NULL;
		} else {
			_vala_code_node_unref0 (condition);
			_vala_iterable_unref0 (initializer_list);
			_vala_code_node_unref0 (block);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp17_ = g_direct_equal;
	_tmp18_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp17_);
	iterator_list = _tmp18_;
	if (vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_PARENS) {
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				ValaExpression* _tmp20_ = NULL;
				ValaExpression* _tmp21_;
				ValaArrayList* _tmp22_;
				if (!_tmp19_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp19_ = FALSE;
				_tmp21_ = vala_parser_parse_statement_expression (self, &_inner_error_);
				_tmp20_ = _tmp21_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_iterable_unref0 (iterator_list);
						_vala_code_node_unref0 (condition);
						_vala_iterable_unref0 (initializer_list);
						_vala_code_node_unref0 (block);
						return NULL;
					} else {
						_vala_iterable_unref0 (iterator_list);
						_vala_code_node_unref0 (condition);
						_vala_iterable_unref0 (initializer_list);
						_vala_code_node_unref0 (block);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp22_ = iterator_list;
				vala_collection_add ((ValaCollection*) _tmp22_, _tmp20_);
				_vala_code_node_unref0 (_tmp20_);
			}
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_iterable_unref0 (iterator_list);
			_vala_code_node_unref0 (condition);
			_vala_iterable_unref0 (initializer_list);
			_vala_code_node_unref0 (block);
			return NULL;
		} else {
			_vala_iterable_unref0 (iterator_list);
			_vala_code_node_unref0 (condition);
			_vala_iterable_unref0 (initializer_list);
			_vala_code_node_unref0 (block);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp23_ = begin;
	_tmp24_ = vala_parser_get_src (self, &_tmp23_);
	src = _tmp24_;
	_tmp25_ = vala_parser_parse_embedded_statement (self, "for", TRUE, &_inner_error_);
	body = _tmp25_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_source_reference_unref0 (src);
			_vala_iterable_unref0 (iterator_list);
			_vala_code_node_unref0 (condition);
			_vala_iterable_unref0 (initializer_list);
			_vala_code_node_unref0 (block);
			return NULL;
		} else {
			_vala_source_reference_unref0 (src);
			_vala_iterable_unref0 (iterator_list);
			_vala_code_node_unref0 (condition);
			_vala_iterable_unref0 (initializer_list);
			_vala_code_node_unref0 (block);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp26_ = condition;
	_tmp27_ = body;
	_tmp28_ = src;
	_tmp29_ = vala_for_statement_new (_tmp26_, _tmp27_, _tmp28_);
	stmt = _tmp29_;
	{
		ValaArrayList* _init_list = NULL;
		ValaArrayList* _tmp30_;
		ValaArrayList* _tmp31_;
		gint _init_size = 0;
		ValaArrayList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _init_index = 0;
		_tmp30_ = initializer_list;
		_tmp31_ = _vala_iterable_ref0 (_tmp30_);
		_init_list = _tmp31_;
		_tmp32_ = _init_list;
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_init_size = _tmp34_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			ValaExpression* init = NULL;
			ValaArrayList* _tmp38_;
			gint _tmp39_;
			gpointer _tmp40_;
			ValaForStatement* _tmp41_;
			ValaExpression* _tmp42_;
			_tmp35_ = _init_index;
			_init_index = _tmp35_ + 1;
			_tmp36_ = _init_index;
			_tmp37_ = _init_size;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = _init_list;
			_tmp39_ = _init_index;
			_tmp40_ = vala_list_get ((ValaList*) _tmp38_, _tmp39_);
			init = (ValaExpression*) _tmp40_;
			_tmp41_ = stmt;
			_tmp42_ = init;
			vala_for_statement_add_initializer (_tmp41_, _tmp42_);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	{
		ValaArrayList* _iter_list = NULL;
		ValaArrayList* _tmp43_;
		ValaArrayList* _tmp44_;
		gint _iter_size = 0;
		ValaArrayList* _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		gint _iter_index = 0;
		_tmp43_ = iterator_list;
		_tmp44_ = _vala_iterable_ref0 (_tmp43_);
		_iter_list = _tmp44_;
		_tmp45_ = _iter_list;
		_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
		_tmp47_ = _tmp46_;
		_iter_size = _tmp47_;
		_iter_index = -1;
		while (TRUE) {
			gint _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			ValaExpression* iter = NULL;
			ValaArrayList* _tmp51_;
			gint _tmp52_;
			gpointer _tmp53_;
			ValaForStatement* _tmp54_;
			ValaExpression* _tmp55_;
			_tmp48_ = _iter_index;
			_iter_index = _tmp48_ + 1;
			_tmp49_ = _iter_index;
			_tmp50_ = _iter_size;
			if (!(_tmp49_ < _tmp50_)) {
				break;
			}
			_tmp51_ = _iter_list;
			_tmp52_ = _iter_index;
			_tmp53_ = vala_list_get ((ValaList*) _tmp51_, _tmp52_);
			iter = (ValaExpression*) _tmp53_;
			_tmp54_ = stmt;
			_tmp55_ = iter;
			vala_for_statement_add_iterator (_tmp54_, _tmp55_);
			_vala_code_node_unref0 (iter);
		}
		_vala_iterable_unref0 (_iter_list);
	}
	_tmp56_ = block;
	if (_tmp56_ != NULL) {
		ValaBlock* _tmp57_;
		ValaForStatement* _tmp58_;
		_tmp57_ = block;
		_tmp58_ = stmt;
		vala_block_add_statement (_tmp57_, (ValaStatement*) _tmp58_);
		result = (ValaStatement*) block;
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (body);
		_vala_source_reference_unref0 (src);
		_vala_iterable_unref0 (iterator_list);
		_vala_code_node_unref0 (condition);
		_vala_iterable_unref0 (initializer_list);
		return result;
	} else {
		result = (ValaStatement*) stmt;
		_vala_code_node_unref0 (body);
		_vala_source_reference_unref0 (src);
		_vala_iterable_unref0 (iterator_list);
		_vala_code_node_unref0 (condition);
		_vala_iterable_unref0 (initializer_list);
		_vala_code_node_unref0 (block);
		return result;
	}
	_vala_code_node_unref0 (stmt);
	_vala_code_node_unref0 (body);
	_vala_source_reference_unref0 (src);
	_vala_iterable_unref0 (iterator_list);
	_vala_code_node_unref0 (condition);
	_vala_iterable_unref0 (initializer_list);
	_vala_code_node_unref0 (block);
}


static ValaStatement*
vala_parser_parse_foreach_statement (ValaParser* self,
                                     GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaDataType* type = NULL;
	gchar* id = NULL;
	gchar* _tmp8_;
	ValaExpression* collection = NULL;
	ValaExpression* _tmp9_;
	ValaSourceReference* src = NULL;
	ValaSourceLocation _tmp10_;
	ValaSourceReference* _tmp11_;
	ValaBlock* body = NULL;
	ValaBlock* _tmp12_;
	ValaDataType* _tmp13_;
	const gchar* _tmp14_;
	ValaExpression* _tmp15_;
	ValaBlock* _tmp16_;
	ValaSourceReference* _tmp17_;
	ValaForeachStatement* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_FOREACH, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	type = NULL;
	if (!vala_parser_accept (self, VALA_TOKEN_TYPE_VAR)) {
		ValaDataType* _tmp1_ = NULL;
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_parser_parse_type (self, TRUE, TRUE, FALSE, &_inner_error_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_vala_code_node_unref0 (type);
		type = _tmp3_;
		if (vala_parser_accept (self, VALA_TOKEN_TYPE_IN)) {
			ValaDataType* _tmp4_;
			ValaSourceReference* _tmp5_;
			ValaSourceReference* _tmp6_;
			GError* _tmp7_;
			_tmp4_ = type;
			_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp4_);
			_tmp6_ = _tmp5_;
			vala_report_error (_tmp6_, "syntax error, expected var or type");
			_tmp7_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected var or type");
			_inner_error_ = _tmp7_;
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (_tmp1_);
				_vala_code_node_unref0 (type);
				return NULL;
			} else {
				_vala_code_node_unref0 (_tmp1_);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_vala_code_node_unref0 (_tmp1_);
	}
	_tmp8_ = vala_parser_parse_identifier (self, &_inner_error_);
	id = _tmp8_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_IN, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp9_ = vala_parser_parse_expression (self, &_inner_error_);
	collection = _tmp9_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (collection);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_code_node_unref0 (collection);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp10_ = begin;
	_tmp11_ = vala_parser_get_src (self, &_tmp10_);
	src = _tmp11_;
	_tmp12_ = vala_parser_parse_embedded_statement (self, "foreach", TRUE, &_inner_error_);
	body = _tmp12_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_source_reference_unref0 (src);
			_vala_code_node_unref0 (collection);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return NULL;
		} else {
			_vala_source_reference_unref0 (src);
			_vala_code_node_unref0 (collection);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp13_ = type;
	_tmp14_ = id;
	_tmp15_ = collection;
	_tmp16_ = body;
	_tmp17_ = src;
	_tmp18_ = vala_foreach_statement_new (_tmp13_, _tmp14_, _tmp15_, _tmp16_, _tmp17_);
	result = (ValaStatement*) _tmp18_;
	_vala_code_node_unref0 (body);
	_vala_source_reference_unref0 (src);
	_vala_code_node_unref0 (collection);
	_g_free0 (id);
	_vala_code_node_unref0 (type);
	return result;
}


static ValaStatement*
vala_parser_parse_break_statement (ValaParser* self,
                                   GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaBreakStatement* _tmp4_;
	ValaStatement* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_BREAK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = begin;
	_tmp2_ = vala_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_break_statement_new (_tmp3_);
	_tmp5_ = (ValaStatement*) _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static ValaStatement*
vala_parser_parse_continue_statement (ValaParser* self,
                                      GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaContinueStatement* _tmp4_;
	ValaStatement* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_CONTINUE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = begin;
	_tmp2_ = vala_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_continue_statement_new (_tmp3_);
	_tmp5_ = (ValaStatement*) _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static ValaStatement*
vala_parser_parse_return_statement (ValaParser* self,
                                    GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* expr = NULL;
	ValaExpression* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaReturnStatement* _tmp8_;
	ValaStatement* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_RETURN, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	expr = NULL;
	if (vala_parser_current (self) != VALA_TOKEN_TYPE_SEMICOLON) {
		ValaExpression* _tmp1_ = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_parser_parse_expression (self, &_inner_error_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (expr);
				return NULL;
			} else {
				_vala_code_node_unref0 (expr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_vala_code_node_unref0 (expr);
		expr = _tmp3_;
		_vala_code_node_unref0 (_tmp1_);
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (expr);
			return NULL;
		} else {
			_vala_code_node_unref0 (expr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = expr;
	_tmp5_ = begin;
	_tmp6_ = vala_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_return_statement_new (_tmp4_, _tmp7_);
	_tmp9_ = (ValaStatement*) _tmp8_;
	_vala_source_reference_unref0 (_tmp7_);
	result = _tmp9_;
	_vala_code_node_unref0 (expr);
	return result;
}


static ValaStatement*
vala_parser_parse_yield_statement (ValaParser* self,
                                   GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	ValaExpression* expr = NULL;
	ValaExpression* _tmp8_;
	ValaSourceLocation _tmp9_;
	ValaSourceReference* _tmp10_;
	ValaSourceReference* _tmp11_;
	ValaYieldStatement* _tmp12_;
	ValaStatement* _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_YIELD, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vala_parser_current (self) != VALA_TOKEN_TYPE_SEMICOLON) {
		_tmp1_ = vala_parser_current (self) != VALA_TOKEN_TYPE_RETURN;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaStatement* _tmp2_ = NULL;
		ValaStatement* _tmp3_;
		ValaStatement* _tmp4_;
		vala_parser_prev (self);
		_tmp3_ = vala_parser_parse_expression_statement (self, &_inner_error_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		result = _tmp4_;
		_vala_code_node_unref0 (_tmp2_);
		return result;
	}
	expr = NULL;
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_RETURN)) {
		ValaExpression* _tmp5_ = NULL;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_parser_parse_expression (self, &_inner_error_);
		_tmp5_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (expr);
				return NULL;
			} else {
				_vala_code_node_unref0 (expr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp7_ = _tmp5_;
		_tmp5_ = NULL;
		_vala_code_node_unref0 (expr);
		expr = _tmp7_;
		_vala_code_node_unref0 (_tmp5_);
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (expr);
			return NULL;
		} else {
			_vala_code_node_unref0 (expr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = expr;
	_tmp9_ = begin;
	_tmp10_ = vala_parser_get_src (self, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_yield_statement_new (_tmp8_, _tmp11_);
	_tmp13_ = (ValaStatement*) _tmp12_;
	_vala_source_reference_unref0 (_tmp11_);
	result = _tmp13_;
	_vala_code_node_unref0 (expr);
	return result;
}


static ValaStatement*
vala_parser_parse_throw_statement (ValaParser* self,
                                   GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* expr = NULL;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaThrowStatement* _tmp6_;
	ValaStatement* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_THROW, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = vala_parser_parse_expression (self, &_inner_error_);
	expr = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (expr);
			return NULL;
		} else {
			_vala_code_node_unref0 (expr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = expr;
	_tmp3_ = begin;
	_tmp4_ = vala_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_throw_statement_new (_tmp2_, _tmp5_);
	_tmp7_ = (ValaStatement*) _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	result = _tmp7_;
	_vala_code_node_unref0 (expr);
	return result;
}


static ValaStatement*
vala_parser_parse_try_statement (ValaParser* self,
                                 GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaBlock* try_block = NULL;
	ValaBlock* _tmp1_;
	ValaBlock* finally_clause = NULL;
	ValaArrayList* catch_clauses = NULL;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	ValaTryStatement* stmt = NULL;
	ValaBlock* _tmp11_;
	ValaBlock* _tmp12_;
	ValaSourceLocation _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaTryStatement* _tmp16_;
	ValaTryStatement* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_TRY, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = vala_parser_parse_block (self, &_inner_error_);
	try_block = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	finally_clause = NULL;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_CATCH_CLAUSE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	catch_clauses = _tmp3_;
	if (vala_parser_current (self) == VALA_TOKEN_TYPE_CATCH) {
		ValaArrayList* _tmp4_;
		_tmp4_ = catch_clauses;
		vala_parser_parse_catch_clauses (self, (ValaList*) _tmp4_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_iterable_unref0 (catch_clauses);
				_vala_code_node_unref0 (finally_clause);
				_vala_code_node_unref0 (try_block);
				return NULL;
			} else {
				_vala_iterable_unref0 (catch_clauses);
				_vala_code_node_unref0 (finally_clause);
				_vala_code_node_unref0 (try_block);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		if (vala_parser_current (self) == VALA_TOKEN_TYPE_FINALLY) {
			ValaBlock* _tmp5_ = NULL;
			ValaBlock* _tmp6_;
			ValaBlock* _tmp7_;
			_tmp6_ = vala_parser_parse_finally_clause (self, &_inner_error_);
			_tmp5_ = _tmp6_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_iterable_unref0 (catch_clauses);
					_vala_code_node_unref0 (finally_clause);
					_vala_code_node_unref0 (try_block);
					return NULL;
				} else {
					_vala_iterable_unref0 (catch_clauses);
					_vala_code_node_unref0 (finally_clause);
					_vala_code_node_unref0 (try_block);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp7_ = _tmp5_;
			_tmp5_ = NULL;
			_vala_code_node_unref0 (finally_clause);
			finally_clause = _tmp7_;
			_vala_code_node_unref0 (_tmp5_);
		}
	} else {
		ValaBlock* _tmp8_ = NULL;
		ValaBlock* _tmp9_;
		ValaBlock* _tmp10_;
		_tmp9_ = vala_parser_parse_finally_clause (self, &_inner_error_);
		_tmp8_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_iterable_unref0 (catch_clauses);
				_vala_code_node_unref0 (finally_clause);
				_vala_code_node_unref0 (try_block);
				return NULL;
			} else {
				_vala_iterable_unref0 (catch_clauses);
				_vala_code_node_unref0 (finally_clause);
				_vala_code_node_unref0 (try_block);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp10_ = _tmp8_;
		_tmp8_ = NULL;
		_vala_code_node_unref0 (finally_clause);
		finally_clause = _tmp10_;
		_vala_code_node_unref0 (_tmp8_);
	}
	_tmp11_ = try_block;
	_tmp12_ = finally_clause;
	_tmp13_ = begin;
	_tmp14_ = vala_parser_get_src (self, &_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_try_statement_new (_tmp11_, _tmp12_, _tmp15_);
	_tmp17_ = _tmp16_;
	_vala_source_reference_unref0 (_tmp15_);
	stmt = _tmp17_;
	{
		ValaArrayList* _clause_list = NULL;
		ValaArrayList* _tmp18_;
		ValaArrayList* _tmp19_;
		gint _clause_size = 0;
		ValaArrayList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _clause_index = 0;
		_tmp18_ = catch_clauses;
		_tmp19_ = _vala_iterable_ref0 (_tmp18_);
		_clause_list = _tmp19_;
		_tmp20_ = _clause_list;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_clause_size = _tmp22_;
		_clause_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			ValaCatchClause* clause = NULL;
			ValaArrayList* _tmp26_;
			gint _tmp27_;
			gpointer _tmp28_;
			ValaTryStatement* _tmp29_;
			ValaCatchClause* _tmp30_;
			_tmp23_ = _clause_index;
			_clause_index = _tmp23_ + 1;
			_tmp24_ = _clause_index;
			_tmp25_ = _clause_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _clause_list;
			_tmp27_ = _clause_index;
			_tmp28_ = vala_list_get ((ValaList*) _tmp26_, _tmp27_);
			clause = (ValaCatchClause*) _tmp28_;
			_tmp29_ = stmt;
			_tmp30_ = clause;
			vala_try_statement_add_catch_clause (_tmp29_, _tmp30_);
			_vala_code_node_unref0 (clause);
		}
		_vala_iterable_unref0 (_clause_list);
	}
	result = (ValaStatement*) stmt;
	_vala_iterable_unref0 (catch_clauses);
	_vala_code_node_unref0 (finally_clause);
	_vala_code_node_unref0 (try_block);
	return result;
}


static void
vala_parser_parse_catch_clauses (ValaParser* self,
                                 ValaList* catch_clauses,
                                 GError** error)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (catch_clauses != NULL);
	while (TRUE) {
		ValaSourceLocation begin = {0};
		ValaSourceLocation _tmp0_ = {0};
		ValaDataType* type = NULL;
		gchar* id = NULL;
		ValaBlock* block = NULL;
		ValaBlock* _tmp7_;
		ValaDataType* _tmp8_;
		const gchar* _tmp9_;
		ValaBlock* _tmp10_;
		ValaSourceLocation _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaCatchClause* _tmp14_;
		ValaCatchClause* _tmp15_;
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_CATCH)) {
			break;
		}
		vala_parser_get_location (self, &_tmp0_);
		begin = _tmp0_;
		type = NULL;
		id = NULL;
		if (vala_parser_accept (self, VALA_TOKEN_TYPE_OPEN_PARENS)) {
			ValaDataType* _tmp1_ = NULL;
			ValaDataType* _tmp2_;
			ValaDataType* _tmp3_;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp2_ = vala_parser_parse_type (self, TRUE, TRUE, FALSE, &_inner_error_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					return;
				} else {
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_vala_code_node_unref0 (type);
			type = _tmp3_;
			_tmp5_ = vala_parser_parse_identifier (self, &_inner_error_);
			_tmp4_ = _tmp5_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (_tmp1_);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					return;
				} else {
					_vala_code_node_unref0 (_tmp1_);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp6_ = _tmp4_;
			_tmp4_ = NULL;
			_g_free0 (id);
			id = _tmp6_;
			vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (_tmp4_);
					_vala_code_node_unref0 (_tmp1_);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					return;
				} else {
					_g_free0 (_tmp4_);
					_vala_code_node_unref0 (_tmp1_);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_g_free0 (_tmp4_);
			_vala_code_node_unref0 (_tmp1_);
		}
		_tmp7_ = vala_parser_parse_block (self, &_inner_error_);
		block = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				return;
			} else {
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp8_ = type;
		_tmp9_ = id;
		_tmp10_ = block;
		_tmp11_ = begin;
		_tmp12_ = vala_parser_get_src (self, &_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_catch_clause_new (_tmp8_, _tmp9_, _tmp10_, _tmp13_);
		_tmp15_ = _tmp14_;
		vala_collection_add ((ValaCollection*) catch_clauses, _tmp15_);
		_vala_code_node_unref0 (_tmp15_);
		_vala_source_reference_unref0 (_tmp13_);
		_vala_code_node_unref0 (block);
		_g_free0 (id);
		_vala_code_node_unref0 (type);
	}
}


static ValaBlock*
vala_parser_parse_finally_clause (ValaParser* self,
                                  GError** error)
{
	ValaBlock* result = NULL;
	ValaBlock* block = NULL;
	ValaBlock* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_expect (self, VALA_TOKEN_TYPE_FINALLY, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = vala_parser_parse_block (self, &_inner_error_);
	block = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = block;
	return result;
}


static ValaStatement*
vala_parser_parse_lock_statement (ValaParser* self,
                                  GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* expr = NULL;
	ValaExpression* _tmp1_;
	ValaBlock* stmt = NULL;
	ValaBlock* _tmp2_;
	ValaExpression* _tmp3_;
	ValaBlock* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaLockStatement* _tmp8_;
	ValaStatement* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_LOCK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = vala_parser_parse_expression (self, &_inner_error_);
	expr = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (expr);
			return NULL;
		} else {
			_vala_code_node_unref0 (expr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = vala_parser_parse_embedded_statement (self, "lock", FALSE, &_inner_error_);
	stmt = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (expr);
			return NULL;
		} else {
			_vala_code_node_unref0 (expr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = expr;
	_tmp4_ = stmt;
	_tmp5_ = begin;
	_tmp6_ = vala_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_lock_statement_new (_tmp3_, _tmp4_, _tmp7_);
	_tmp9_ = (ValaStatement*) _tmp8_;
	_vala_source_reference_unref0 (_tmp7_);
	result = _tmp9_;
	_vala_code_node_unref0 (stmt);
	_vala_code_node_unref0 (expr);
	return result;
}


static ValaStatement*
vala_parser_parse_delete_statement (ValaParser* self,
                                    GError** error)
{
	ValaStatement* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaExpression* expr = NULL;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaDeleteStatement* _tmp6_;
	ValaStatement* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_DELETE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = vala_parser_parse_expression (self, &_inner_error_);
	expr = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (expr);
			return NULL;
		} else {
			_vala_code_node_unref0 (expr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = expr;
	_tmp3_ = begin;
	_tmp4_ = vala_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_delete_statement_new (_tmp2_, _tmp5_);
	_tmp7_ = (ValaStatement*) _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	result = _tmp7_;
	_vala_code_node_unref0 (expr);
	return result;
}


static gchar*
vala_parser_parse_attribute_value (ValaParser* self,
                                   GError** error)
{
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (vala_parser_current (self)) {
		case VALA_TOKEN_TYPE_NULL:
		case VALA_TOKEN_TYPE_TRUE:
		case VALA_TOKEN_TYPE_FALSE:
		case VALA_TOKEN_TYPE_INTEGER_LITERAL:
		case VALA_TOKEN_TYPE_REAL_LITERAL:
		case VALA_TOKEN_TYPE_STRING_LITERAL:
		{
			gchar* _tmp0_;
			vala_parser_next (self);
			_tmp0_ = vala_parser_get_last_string (self);
			result = _tmp0_;
			return result;
		}
		case VALA_TOKEN_TYPE_MINUS:
		{
			vala_parser_next (self);
			switch (vala_parser_current (self)) {
				case VALA_TOKEN_TYPE_INTEGER_LITERAL:
				case VALA_TOKEN_TYPE_REAL_LITERAL:
				{
					gchar* _tmp1_;
					gchar* _tmp2_;
					gchar* _tmp3_;
					gchar* _tmp4_;
					vala_parser_next (self);
					_tmp1_ = vala_parser_get_last_string (self);
					_tmp2_ = _tmp1_;
					_tmp3_ = g_strconcat ("-", _tmp2_, NULL);
					_tmp4_ = _tmp3_;
					_g_free0 (_tmp2_);
					result = _tmp4_;
					return result;
				}
				default:
				{
					GError* _tmp5_;
					_tmp5_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected number");
					_inner_error_ = _tmp5_;
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return NULL;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
		}
		default:
		{
			GError* _tmp6_;
			_tmp6_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected literal");
			_inner_error_ = _tmp6_;
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
}


static ValaList*
vala_parser_parse_attributes (ValaParser* self,
                              GError** error)
{
	ValaList* result = NULL;
	ValaArrayList* attrs = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_parser_current (self) != VALA_TOKEN_TYPE_OPEN_BRACKET) {
		result = NULL;
		return result;
	}
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_ATTRIBUTE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	attrs = _tmp1_;
	while (TRUE) {
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_OPEN_BRACKET)) {
			break;
		}
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ValaSourceLocation begin = {0};
				ValaSourceLocation _tmp3_ = {0};
				gchar* id = NULL;
				gchar* _tmp4_;
				ValaAttribute* attr = NULL;
				const gchar* _tmp5_;
				ValaSourceLocation _tmp6_;
				ValaSourceReference* _tmp7_;
				ValaSourceReference* _tmp8_;
				ValaAttribute* _tmp9_;
				ValaAttribute* _tmp10_;
				ValaArrayList* _tmp19_;
				ValaAttribute* _tmp20_;
				if (!_tmp2_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp2_ = FALSE;
				vala_parser_get_location (self, &_tmp3_);
				begin = _tmp3_;
				_tmp4_ = vala_parser_parse_identifier (self, &_inner_error_);
				id = _tmp4_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_iterable_unref0 (attrs);
						return NULL;
					} else {
						_vala_iterable_unref0 (attrs);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp5_ = id;
				_tmp6_ = begin;
				_tmp7_ = vala_parser_get_src (self, &_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = vala_attribute_new (_tmp5_, _tmp8_);
				_tmp10_ = _tmp9_;
				_vala_source_reference_unref0 (_tmp8_);
				attr = _tmp10_;
				if (vala_parser_accept (self, VALA_TOKEN_TYPE_OPEN_PARENS)) {
					if (vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_PARENS) {
						{
							gboolean _tmp11_ = FALSE;
							_tmp11_ = TRUE;
							while (TRUE) {
								gchar* _tmp12_ = NULL;
								gchar* _tmp13_;
								gchar* _tmp14_;
								gchar* _tmp15_ = NULL;
								gchar* _tmp16_;
								ValaAttribute* _tmp17_;
								const gchar* _tmp18_;
								if (!_tmp11_) {
									if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
										break;
									}
								}
								_tmp11_ = FALSE;
								_tmp13_ = vala_parser_parse_identifier (self, &_inner_error_);
								_tmp12_ = _tmp13_;
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									if (_inner_error_->domain == VALA_PARSE_ERROR) {
										g_propagate_error (error, _inner_error_);
										_vala_code_node_unref0 (attr);
										_g_free0 (id);
										_vala_iterable_unref0 (attrs);
										return NULL;
									} else {
										_vala_code_node_unref0 (attr);
										_g_free0 (id);
										_vala_iterable_unref0 (attrs);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
								_tmp14_ = _tmp12_;
								_tmp12_ = NULL;
								_g_free0 (id);
								id = _tmp14_;
								vala_parser_expect (self, VALA_TOKEN_TYPE_ASSIGN, &_inner_error_);
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									if (_inner_error_->domain == VALA_PARSE_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_free0 (_tmp12_);
										_vala_code_node_unref0 (attr);
										_g_free0 (id);
										_vala_iterable_unref0 (attrs);
										return NULL;
									} else {
										_g_free0 (_tmp12_);
										_vala_code_node_unref0 (attr);
										_g_free0 (id);
										_vala_iterable_unref0 (attrs);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
								_tmp16_ = vala_parser_parse_attribute_value (self, &_inner_error_);
								_tmp15_ = _tmp16_;
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									if (_inner_error_->domain == VALA_PARSE_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_free0 (_tmp12_);
										_vala_code_node_unref0 (attr);
										_g_free0 (id);
										_vala_iterable_unref0 (attrs);
										return NULL;
									} else {
										_g_free0 (_tmp12_);
										_vala_code_node_unref0 (attr);
										_g_free0 (id);
										_vala_iterable_unref0 (attrs);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
								_tmp17_ = attr;
								_tmp18_ = id;
								vala_attribute_add_argument (_tmp17_, _tmp18_, _tmp15_);
								_g_free0 (_tmp15_);
								_g_free0 (_tmp12_);
							}
						}
					}
					vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_vala_code_node_unref0 (attr);
							_g_free0 (id);
							_vala_iterable_unref0 (attrs);
							return NULL;
						} else {
							_vala_code_node_unref0 (attr);
							_g_free0 (id);
							_vala_iterable_unref0 (attrs);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
				_tmp19_ = attrs;
				_tmp20_ = attr;
				vala_collection_add ((ValaCollection*) _tmp19_, _tmp20_);
				_vala_code_node_unref0 (attr);
				_g_free0 (id);
			}
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_iterable_unref0 (attrs);
				return NULL;
			} else {
				_vala_iterable_unref0 (attrs);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = (ValaList*) attrs;
	return result;
}


static void
vala_parser_set_attributes (ValaParser* self,
                            ValaCodeNode* node,
                            ValaList* attributes)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	if (attributes != NULL) {
		{
			ValaList* _attr_list = NULL;
			ValaList* _tmp0_;
			gint _attr_size = 0;
			ValaList* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gint _attr_index = 0;
			_tmp0_ = _vala_iterable_ref0 (G_TYPE_CHECK_INSTANCE_CAST (attributes, VALA_TYPE_LIST, ValaList));
			_attr_list = _tmp0_;
			_tmp1_ = _attr_list;
			_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
			_tmp3_ = _tmp2_;
			_attr_size = _tmp3_;
			_attr_index = -1;
			while (TRUE) {
				gint _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				ValaAttribute* attr = NULL;
				ValaList* _tmp7_;
				gint _tmp8_;
				gpointer _tmp9_;
				ValaAttribute* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				ValaAttribute* _tmp13_;
				ValaAttribute* _tmp14_;
				gboolean _tmp15_;
				ValaAttribute* _tmp24_;
				ValaAttribute* _tmp25_;
				_tmp4_ = _attr_index;
				_attr_index = _tmp4_ + 1;
				_tmp5_ = _attr_index;
				_tmp6_ = _attr_size;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = _attr_list;
				_tmp8_ = _attr_index;
				_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
				attr = (ValaAttribute*) _tmp9_;
				_tmp10_ = attr;
				_tmp11_ = vala_attribute_get_name (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = vala_code_node_get_attribute (node, _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = _tmp14_ != NULL;
				_vala_code_node_unref0 (_tmp14_);
				if (_tmp15_) {
					ValaAttribute* _tmp16_;
					ValaSourceReference* _tmp17_;
					ValaSourceReference* _tmp18_;
					ValaAttribute* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp16_ = attr;
					_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = attr;
					_tmp20_ = vala_attribute_get_name (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_strdup_printf ("duplicate attribute `%s`", _tmp21_);
					_tmp23_ = _tmp22_;
					vala_report_error (_tmp18_, _tmp23_);
					_g_free0 (_tmp23_);
				}
				_tmp24_ = attr;
				_tmp25_ = _vala_code_node_ref0 (_tmp24_);
				node->attributes = g_list_append (node->attributes, _tmp25_);
				_vala_code_node_unref0 (attr);
			}
			_vala_iterable_unref0 (_attr_list);
		}
	}
}


static void
vala_parser_parse_main_block (ValaParser* self,
                              ValaSymbol* parent,
                              GError** error)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaMethod* method = NULL;
	ValaVoidType* _tmp1_;
	ValaVoidType* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaMethod* _tmp6_;
	ValaMethod* _tmp7_;
	ValaSourceLocation _tmp8_;
	ValaSourceReference* _tmp9_;
	ValaSourceReference* _tmp10_;
	ValaBlock* _tmp11_;
	ValaBlock* _tmp12_;
	ValaBlock* _tmp13_;
	ValaBlock* _tmp14_;
	ValaBlock* _tmp17_;
	ValaBlock* _tmp18_;
	ValaSourceReference* _tmp19_;
	ValaSourceReference* _tmp20_;
	ValaSourceReference* _tmp21_;
	ValaSourceReference* _tmp22_;
	ValaSourceLocation _tmp23_ = {0};
	ValaSourceLocation _tmp24_;
	ValaCodeContext* _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	_tmp1_ = vala_void_type_new (NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = begin;
	_tmp4_ = vala_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_method_new ("main", (ValaDataType*) _tmp2_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	_vala_code_node_unref0 (_tmp2_);
	method = _tmp7_;
	_tmp8_ = begin;
	_tmp9_ = vala_parser_get_src (self, &_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_block_new (_tmp10_);
	_tmp12_ = _tmp11_;
	vala_subroutine_set_body ((ValaSubroutine*) method, _tmp12_);
	_vala_code_node_unref0 (_tmp12_);
	_vala_source_reference_unref0 (_tmp10_);
	_tmp13_ = vala_subroutine_get_body ((ValaSubroutine*) method);
	_tmp14_ = _tmp13_;
	vala_parser_parse_statements (self, _tmp14_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (method);
			return;
		} else {
			_vala_code_node_unref0 (method);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (vala_parser_current (self) != VALA_TOKEN_TYPE_EOF) {
		ValaSourceReference* _tmp15_;
		ValaSourceReference* _tmp16_;
		_tmp15_ = vala_parser_get_current_src (self);
		_tmp16_ = _tmp15_;
		vala_report_error (_tmp16_, "expected end of file");
		_vala_source_reference_unref0 (_tmp16_);
	}
	_tmp17_ = vala_subroutine_get_body ((ValaSubroutine*) method);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_parser_get_current_src (self);
	_tmp22_ = _tmp21_;
	vala_source_reference_get_end (_tmp22_, &_tmp23_);
	_tmp24_ = _tmp23_;
	vala_source_reference_set_end (_tmp20_, &_tmp24_);
	_vala_source_reference_unref0 (_tmp22_);
	_tmp25_ = self->priv->context;
	_tmp26_ = vala_code_context_get_experimental (_tmp25_);
	_tmp27_ = _tmp26_;
	if (!_tmp27_) {
		ValaSourceReference* _tmp28_;
		ValaSourceReference* _tmp29_;
		_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) method);
		_tmp29_ = _tmp28_;
		vala_report_warning (_tmp29_, "main blocks are experimental");
	}
	vala_symbol_add_method (parent, method);
	_vala_code_node_unref0 (method);
}


static void
vala_parser_parse_declaration (ValaParser* self,
                               ValaSymbol* parent,
                               gboolean root,
                               GError** error)
{
	ValaScanner* _tmp0_;
	ValaComment* _tmp1_;
	ValaList* attrs = NULL;
	ValaList* _tmp2_;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp3_ = {0};
	ValaTokenType last_keyword = 0;
	ValaSourceLocation _tmp35_;
	GError* _tmp36_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = vala_scanner_pop_comment (_tmp0_);
	_vala_comment_unref0 (self->priv->comment);
	self->priv->comment = _tmp1_;
	_tmp2_ = vala_parser_parse_attributes (self, &_inner_error_);
	attrs = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	vala_parser_get_location (self, &_tmp3_);
	begin = _tmp3_;
	last_keyword = vala_parser_current (self);
	while (TRUE) {
		if (!vala_parser_is_declaration_keyword (self, vala_parser_current (self))) {
			break;
		}
		last_keyword = vala_parser_current (self);
		vala_parser_next (self);
	}
	switch (vala_parser_current (self)) {
		case VALA_TOKEN_TYPE_CONSTRUCT:
		{
			ValaSourceLocation _tmp4_;
			ValaList* _tmp5_;
			_tmp4_ = begin;
			vala_parser_rollback (self, &_tmp4_);
			_tmp5_ = attrs;
			vala_parser_parse_constructor_declaration (self, parent, _tmp5_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_iterable_unref0 (attrs);
					return;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_vala_iterable_unref0 (attrs);
			return;
		}
		case VALA_TOKEN_TYPE_TILDE:
		{
			ValaSourceLocation _tmp6_;
			ValaList* _tmp7_;
			_tmp6_ = begin;
			vala_parser_rollback (self, &_tmp6_);
			_tmp7_ = attrs;
			vala_parser_parse_destructor_declaration (self, parent, _tmp7_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_iterable_unref0 (attrs);
					return;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_vala_iterable_unref0 (attrs);
			return;
		}
		case VALA_TOKEN_TYPE_OPEN_BRACE:
		case VALA_TOKEN_TYPE_SEMICOLON:
		case VALA_TOKEN_TYPE_IF:
		case VALA_TOKEN_TYPE_SWITCH:
		case VALA_TOKEN_TYPE_WHILE:
		case VALA_TOKEN_TYPE_DO:
		case VALA_TOKEN_TYPE_FOR:
		case VALA_TOKEN_TYPE_FOREACH:
		case VALA_TOKEN_TYPE_BREAK:
		case VALA_TOKEN_TYPE_CONTINUE:
		case VALA_TOKEN_TYPE_RETURN:
		case VALA_TOKEN_TYPE_YIELD:
		case VALA_TOKEN_TYPE_THROW:
		case VALA_TOKEN_TYPE_TRY:
		case VALA_TOKEN_TYPE_LOCK:
		case VALA_TOKEN_TYPE_DELETE:
		case VALA_TOKEN_TYPE_VAR:
		case VALA_TOKEN_TYPE_OP_INC:
		case VALA_TOKEN_TYPE_OP_DEC:
		case VALA_TOKEN_TYPE_BASE:
		case VALA_TOKEN_TYPE_THIS:
		case VALA_TOKEN_TYPE_STAR:
		case VALA_TOKEN_TYPE_NEW:
		{
			ValaList* _tmp8_;
			ValaSourceLocation _tmp11_;
			_tmp8_ = attrs;
			if (_tmp8_ != NULL) {
				GError* _tmp9_;
				_tmp9_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected statement");
				_inner_error_ = _tmp9_;
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_iterable_unref0 (attrs);
					return;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			if (!root) {
				GError* _tmp10_;
				_tmp10_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "statements outside blocks allowed only in root namespace");
				_inner_error_ = _tmp10_;
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_iterable_unref0 (attrs);
					return;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp11_ = begin;
			vala_parser_rollback (self, &_tmp11_);
			vala_parser_parse_main_block (self, parent, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_iterable_unref0 (attrs);
					return;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_vala_iterable_unref0 (attrs);
			return;
		}
		default:
		{
			if (root) {
				gboolean is_expr = FALSE;
				gboolean _tmp12_;
				is_expr = vala_parser_is_expression (self, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_iterable_unref0 (attrs);
						return;
					} else {
						_vala_iterable_unref0 (attrs);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp12_ = is_expr;
				if (_tmp12_) {
					ValaSourceLocation _tmp13_;
					_tmp13_ = begin;
					vala_parser_rollback (self, &_tmp13_);
					vala_parser_parse_main_block (self, parent, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_vala_iterable_unref0 (attrs);
							return;
						} else {
							_vala_iterable_unref0 (attrs);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_vala_iterable_unref0 (attrs);
					return;
				}
			}
			vala_parser_skip_type (self, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_iterable_unref0 (attrs);
					return;
				} else {
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			switch (vala_parser_current (self)) {
				case VALA_TOKEN_TYPE_OPEN_BRACE:
				case VALA_TOKEN_TYPE_SEMICOLON:
				case VALA_TOKEN_TYPE_COLON:
				{
					ValaSourceLocation _tmp14_;
					ValaTokenType _tmp15_;
					_tmp14_ = begin;
					vala_parser_rollback (self, &_tmp14_);
					_tmp15_ = last_keyword;
					switch (_tmp15_) {
						case VALA_TOKEN_TYPE_CLASS:
						{
							ValaList* _tmp16_;
							_tmp16_ = attrs;
							vala_parser_parse_class_declaration (self, parent, _tmp16_, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == VALA_PARSE_ERROR) {
									g_propagate_error (error, _inner_error_);
									_vala_iterable_unref0 (attrs);
									return;
								} else {
									_vala_iterable_unref0 (attrs);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_vala_iterable_unref0 (attrs);
							return;
						}
						case VALA_TOKEN_TYPE_ENUM:
						{
							ValaList* _tmp17_;
							_tmp17_ = attrs;
							vala_parser_parse_enum_declaration (self, parent, _tmp17_, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == VALA_PARSE_ERROR) {
									g_propagate_error (error, _inner_error_);
									_vala_iterable_unref0 (attrs);
									return;
								} else {
									_vala_iterable_unref0 (attrs);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_vala_iterable_unref0 (attrs);
							return;
						}
						case VALA_TOKEN_TYPE_ERRORDOMAIN:
						{
							ValaList* _tmp18_;
							_tmp18_ = attrs;
							vala_parser_parse_errordomain_declaration (self, parent, _tmp18_, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == VALA_PARSE_ERROR) {
									g_propagate_error (error, _inner_error_);
									_vala_iterable_unref0 (attrs);
									return;
								} else {
									_vala_iterable_unref0 (attrs);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_vala_iterable_unref0 (attrs);
							return;
						}
						case VALA_TOKEN_TYPE_INTERFACE:
						{
							ValaList* _tmp19_;
							_tmp19_ = attrs;
							vala_parser_parse_interface_declaration (self, parent, _tmp19_, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == VALA_PARSE_ERROR) {
									g_propagate_error (error, _inner_error_);
									_vala_iterable_unref0 (attrs);
									return;
								} else {
									_vala_iterable_unref0 (attrs);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_vala_iterable_unref0 (attrs);
							return;
						}
						case VALA_TOKEN_TYPE_NAMESPACE:
						{
							ValaList* _tmp20_;
							_tmp20_ = attrs;
							vala_parser_parse_namespace_declaration (self, parent, _tmp20_, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == VALA_PARSE_ERROR) {
									g_propagate_error (error, _inner_error_);
									_vala_iterable_unref0 (attrs);
									return;
								} else {
									_vala_iterable_unref0 (attrs);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_vala_iterable_unref0 (attrs);
							return;
						}
						case VALA_TOKEN_TYPE_STRUCT:
						{
							ValaList* _tmp21_;
							_tmp21_ = attrs;
							vala_parser_parse_struct_declaration (self, parent, _tmp21_, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == VALA_PARSE_ERROR) {
									g_propagate_error (error, _inner_error_);
									_vala_iterable_unref0 (attrs);
									return;
								} else {
									_vala_iterable_unref0 (attrs);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_vala_iterable_unref0 (attrs);
							return;
						}
						default:
						{
							break;
						}
					}
					break;
				}
				case VALA_TOKEN_TYPE_OPEN_PARENS:
				{
					ValaSourceLocation _tmp22_;
					ValaList* _tmp23_;
					_tmp22_ = begin;
					vala_parser_rollback (self, &_tmp22_);
					_tmp23_ = attrs;
					vala_parser_parse_creation_method_declaration (self, parent, _tmp23_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_vala_iterable_unref0 (attrs);
							return;
						} else {
							_vala_iterable_unref0 (attrs);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_vala_iterable_unref0 (attrs);
					return;
				}
				default:
				{
					vala_parser_skip_type (self, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_vala_iterable_unref0 (attrs);
							return;
						} else {
							_vala_iterable_unref0 (attrs);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					switch (vala_parser_current (self)) {
						case VALA_TOKEN_TYPE_OPEN_PARENS:
						{
							ValaSourceLocation _tmp24_;
							ValaTokenType _tmp25_;
							_tmp24_ = begin;
							vala_parser_rollback (self, &_tmp24_);
							_tmp25_ = last_keyword;
							switch (_tmp25_) {
								case VALA_TOKEN_TYPE_DELEGATE:
								{
									ValaList* _tmp26_;
									_tmp26_ = attrs;
									vala_parser_parse_delegate_declaration (self, parent, _tmp26_, &_inner_error_);
									if (G_UNLIKELY (_inner_error_ != NULL)) {
										if (_inner_error_->domain == VALA_PARSE_ERROR) {
											g_propagate_error (error, _inner_error_);
											_vala_iterable_unref0 (attrs);
											return;
										} else {
											_vala_iterable_unref0 (attrs);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
									_vala_iterable_unref0 (attrs);
									return;
								}
								case VALA_TOKEN_TYPE_SIGNAL:
								{
									ValaList* _tmp27_;
									_tmp27_ = attrs;
									vala_parser_parse_signal_declaration (self, parent, _tmp27_, &_inner_error_);
									if (G_UNLIKELY (_inner_error_ != NULL)) {
										if (_inner_error_->domain == VALA_PARSE_ERROR) {
											g_propagate_error (error, _inner_error_);
											_vala_iterable_unref0 (attrs);
											return;
										} else {
											_vala_iterable_unref0 (attrs);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
									_vala_iterable_unref0 (attrs);
									return;
								}
								default:
								{
									ValaList* _tmp28_;
									_tmp28_ = attrs;
									vala_parser_parse_method_declaration (self, parent, _tmp28_, &_inner_error_);
									if (G_UNLIKELY (_inner_error_ != NULL)) {
										if (_inner_error_->domain == VALA_PARSE_ERROR) {
											g_propagate_error (error, _inner_error_);
											_vala_iterable_unref0 (attrs);
											return;
										} else {
											_vala_iterable_unref0 (attrs);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
									_vala_iterable_unref0 (attrs);
									return;
								}
							}
						}
						case VALA_TOKEN_TYPE_ASSIGN:
						case VALA_TOKEN_TYPE_SEMICOLON:
						{
							ValaSourceLocation _tmp29_;
							ValaTokenType _tmp30_;
							_tmp29_ = begin;
							vala_parser_rollback (self, &_tmp29_);
							_tmp30_ = last_keyword;
							switch (_tmp30_) {
								case VALA_TOKEN_TYPE_CONST:
								{
									ValaList* _tmp31_;
									_tmp31_ = attrs;
									vala_parser_parse_constant_declaration (self, parent, _tmp31_, &_inner_error_);
									if (G_UNLIKELY (_inner_error_ != NULL)) {
										if (_inner_error_->domain == VALA_PARSE_ERROR) {
											g_propagate_error (error, _inner_error_);
											_vala_iterable_unref0 (attrs);
											return;
										} else {
											_vala_iterable_unref0 (attrs);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
									_vala_iterable_unref0 (attrs);
									return;
								}
								default:
								{
									ValaList* _tmp32_;
									_tmp32_ = attrs;
									vala_parser_parse_field_declaration (self, parent, _tmp32_, &_inner_error_);
									if (G_UNLIKELY (_inner_error_ != NULL)) {
										if (_inner_error_->domain == VALA_PARSE_ERROR) {
											g_propagate_error (error, _inner_error_);
											_vala_iterable_unref0 (attrs);
											return;
										} else {
											_vala_iterable_unref0 (attrs);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
									_vala_iterable_unref0 (attrs);
									return;
								}
							}
						}
						case VALA_TOKEN_TYPE_OPEN_BRACE:
						case VALA_TOKEN_TYPE_THROWS:
						{
							ValaSourceLocation _tmp33_;
							ValaList* _tmp34_;
							_tmp33_ = begin;
							vala_parser_rollback (self, &_tmp33_);
							_tmp34_ = attrs;
							vala_parser_parse_property_declaration (self, parent, _tmp34_, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == VALA_PARSE_ERROR) {
									g_propagate_error (error, _inner_error_);
									_vala_iterable_unref0 (attrs);
									return;
								} else {
									_vala_iterable_unref0 (attrs);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_vala_iterable_unref0 (attrs);
							return;
						}
						default:
						{
							break;
						}
					}
					break;
				}
			}
			break;
		}
	}
	_tmp35_ = begin;
	vala_parser_rollback (self, &_tmp35_);
	_tmp36_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected declaration");
	_inner_error_ = _tmp36_;
	if (_inner_error_->domain == VALA_PARSE_ERROR) {
		g_propagate_error (error, _inner_error_);
		_vala_iterable_unref0 (attrs);
		return;
	} else {
		_vala_iterable_unref0 (attrs);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_vala_iterable_unref0 (attrs);
}


static void
vala_parser_parse_declarations (ValaParser* self,
                                ValaSymbol* parent,
                                gboolean root,
                                GError** error)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	if (!root) {
		vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_BRACE) {
			_tmp0_ = vala_parser_current (self) != VALA_TOKEN_TYPE_EOF;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		{
			ValaCodeContext* _tmp1_;
			ValaNamespace* _tmp2_;
			ValaNamespace* _tmp3_;
			_tmp1_ = self->priv->context;
			_tmp2_ = vala_code_context_get_root (_tmp1_);
			_tmp3_ = _tmp2_;
			vala_parser_parse_declaration (self, parent, parent == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_SYMBOL, ValaSymbol), &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					goto __catch16_vala_parse_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally16;
		__catch16_vala_parse_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			gint r = 0;
			gint _tmp6_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp4_ = e;
			vala_parser_report_parse_error (self, _tmp4_);
			while (TRUE) {
				gint _tmp5_;
				r = (gint) vala_parser_recover (self);
				_tmp5_ = r;
				if (_tmp5_ == ((gint) VALA_PARSER_RECOVERY_STATE_STATEMENT_BEGIN)) {
					vala_parser_next (self);
				} else {
					break;
				}
			}
			_tmp6_ = r;
			if (_tmp6_ == ((gint) VALA_PARSER_RECOVERY_STATE_EOF)) {
				_g_error_free0 (e);
				return;
			}
			_g_error_free0 (e);
		}
		__finally16:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	if (!root) {
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_CLOSE_BRACE)) {
			ValaCodeContext* _tmp7_;
			ValaReport* _tmp8_;
			ValaReport* _tmp9_;
			_tmp7_ = self->priv->context;
			_tmp8_ = vala_code_context_get_report (_tmp7_);
			_tmp9_ = _tmp8_;
			if (vala_report_get_errors (_tmp9_) == 0) {
				ValaSourceReference* _tmp10_;
				ValaSourceReference* _tmp11_;
				_tmp10_ = vala_parser_get_current_src (self);
				_tmp11_ = _tmp10_;
				vala_report_error (_tmp11_, "expected `}'");
				_vala_source_reference_unref0 (_tmp11_);
			}
		}
	}
}


static ValaParserRecoveryState
vala_parser_recover (ValaParser* self)
{
	ValaParserRecoveryState result = 0;
	g_return_val_if_fail (self != NULL, 0);
	while (TRUE) {
		if (!(vala_parser_current (self) != VALA_TOKEN_TYPE_EOF)) {
			break;
		}
		switch (vala_parser_current (self)) {
			case VALA_TOKEN_TYPE_ABSTRACT:
			case VALA_TOKEN_TYPE_CLASS:
			case VALA_TOKEN_TYPE_CONST:
			case VALA_TOKEN_TYPE_CONSTRUCT:
			case VALA_TOKEN_TYPE_DELEGATE:
			case VALA_TOKEN_TYPE_ENUM:
			case VALA_TOKEN_TYPE_ERRORDOMAIN:
			case VALA_TOKEN_TYPE_EXTERN:
			case VALA_TOKEN_TYPE_INLINE:
			case VALA_TOKEN_TYPE_INTERFACE:
			case VALA_TOKEN_TYPE_INTERNAL:
			case VALA_TOKEN_TYPE_NAMESPACE:
			case VALA_TOKEN_TYPE_NEW:
			case VALA_TOKEN_TYPE_OVERRIDE:
			case VALA_TOKEN_TYPE_PRIVATE:
			case VALA_TOKEN_TYPE_PROTECTED:
			case VALA_TOKEN_TYPE_PUBLIC:
			case VALA_TOKEN_TYPE_SEALED:
			case VALA_TOKEN_TYPE_SIGNAL:
			case VALA_TOKEN_TYPE_STATIC:
			case VALA_TOKEN_TYPE_STRUCT:
			case VALA_TOKEN_TYPE_VIRTUAL:
			case VALA_TOKEN_TYPE_VOLATILE:
			{
				result = VALA_PARSER_RECOVERY_STATE_DECLARATION_BEGIN;
				return result;
			}
			case VALA_TOKEN_TYPE_BREAK:
			case VALA_TOKEN_TYPE_CONTINUE:
			case VALA_TOKEN_TYPE_DELETE:
			case VALA_TOKEN_TYPE_DO:
			case VALA_TOKEN_TYPE_FOR:
			case VALA_TOKEN_TYPE_FOREACH:
			case VALA_TOKEN_TYPE_IF:
			case VALA_TOKEN_TYPE_LOCK:
			case VALA_TOKEN_TYPE_RETURN:
			case VALA_TOKEN_TYPE_SWITCH:
			case VALA_TOKEN_TYPE_THROW:
			case VALA_TOKEN_TYPE_TRY:
			case VALA_TOKEN_TYPE_VAR:
			case VALA_TOKEN_TYPE_WHILE:
			case VALA_TOKEN_TYPE_YIELD:
			{
				result = VALA_PARSER_RECOVERY_STATE_STATEMENT_BEGIN;
				return result;
			}
			default:
			{
				vala_parser_next (self);
				break;
			}
		}
	}
	result = VALA_PARSER_RECOVERY_STATE_EOF;
	return result;
}


static void
vala_parser_parse_namespace_declaration (ValaParser* self,
                                         ValaSymbol* parent,
                                         ValaList* attrs,
                                         GError** error)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaUnresolvedSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp1_;
	ValaNamespace* ns = NULL;
	ValaUnresolvedSymbol* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaNamespace* _tmp8_;
	ValaNamespace* _tmp9_;
	ValaComment* _tmp10_;
	ValaNamespace* _tmp13_;
	ValaList* old_using_directives = NULL;
	ValaScanner* _tmp14_;
	ValaSourceFile* _tmp15_;
	ValaSourceFile* _tmp16_;
	ValaList* _tmp17_;
	ValaList* _tmp18_;
	ValaList* _tmp19_;
	ValaNamespace* _tmp20_;
	ValaNamespace* _tmp21_;
	ValaScanner* _tmp22_;
	ValaSourceFile* _tmp23_;
	ValaSourceFile* _tmp24_;
	ValaList* _tmp25_;
	ValaSymbol* _result_ = NULL;
	ValaNamespace* _tmp31_;
	ValaSymbol* _tmp32_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_NAMESPACE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = vala_parser_parse_symbol_name (self, &_inner_error_);
	sym = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = sym;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = begin;
	_tmp6_ = vala_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_namespace_new (_tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_vala_source_reference_unref0 (_tmp7_);
	ns = _tmp9_;
	_tmp10_ = self->priv->comment;
	if (_tmp10_ != NULL) {
		ValaNamespace* _tmp11_;
		ValaComment* _tmp12_;
		_tmp11_ = ns;
		_tmp12_ = self->priv->comment;
		vala_namespace_add_comment (_tmp11_, _tmp12_);
		_vala_comment_unref0 (self->priv->comment);
		self->priv->comment = NULL;
	}
	_tmp13_ = ns;
	vala_parser_set_attributes (self, (ValaCodeNode*) _tmp13_, attrs);
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (ns);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_code_node_unref0 (ns);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp14_ = self->priv->scanner;
	_tmp15_ = vala_scanner_get_source_file (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_source_file_get_current_using_directives (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _vala_iterable_ref0 (_tmp18_);
	old_using_directives = _tmp19_;
	_tmp20_ = ns;
	vala_parser_parse_using_directives (self, _tmp20_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_iterable_unref0 (old_using_directives);
			_vala_code_node_unref0 (ns);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_iterable_unref0 (old_using_directives);
			_vala_code_node_unref0 (ns);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp21_ = ns;
	vala_parser_parse_declarations (self, (ValaSymbol*) _tmp21_, TRUE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_iterable_unref0 (old_using_directives);
			_vala_code_node_unref0 (ns);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_iterable_unref0 (old_using_directives);
			_vala_code_node_unref0 (ns);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp22_ = self->priv->scanner;
	_tmp23_ = vala_scanner_get_source_file (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = old_using_directives;
	vala_source_file_set_current_using_directives (_tmp24_, _tmp25_);
	if (!vala_parser_accept (self, VALA_TOKEN_TYPE_CLOSE_BRACE)) {
		ValaCodeContext* _tmp26_;
		ValaReport* _tmp27_;
		ValaReport* _tmp28_;
		_tmp26_ = self->priv->context;
		_tmp27_ = vala_code_context_get_report (_tmp26_);
		_tmp28_ = _tmp27_;
		if (vala_report_get_errors (_tmp28_) == 0) {
			ValaSourceReference* _tmp29_;
			ValaSourceReference* _tmp30_;
			_tmp29_ = vala_parser_get_current_src (self);
			_tmp30_ = _tmp29_;
			vala_report_error (_tmp30_, "expected `}'");
			_vala_source_reference_unref0 (_tmp30_);
		}
	}
	_tmp31_ = ns;
	_tmp32_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp31_);
	_result_ = _tmp32_;
	while (TRUE) {
		ValaUnresolvedSymbol* _tmp33_;
		ValaUnresolvedSymbol* _tmp34_;
		ValaUnresolvedSymbol* _tmp35_;
		ValaUnresolvedSymbol* _tmp36_;
		ValaUnresolvedSymbol* _tmp37_;
		ValaSymbol* _tmp38_ = NULL;
		ValaUnresolvedSymbol* _tmp39_;
		ValaSymbol* next = NULL;
		ValaSymbol* _tmp48_;
		ValaSymbol* _tmp49_;
		ValaSymbol* _tmp50_;
		ValaSymbol* _tmp51_;
		ValaSymbol* _tmp52_;
		_tmp33_ = sym;
		if (!(_tmp33_ != NULL)) {
			break;
		}
		_tmp34_ = sym;
		_tmp35_ = vala_unresolved_symbol_get_inner (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = _vala_code_node_ref0 (_tmp36_);
		_vala_code_node_unref0 (sym);
		sym = _tmp37_;
		_tmp39_ = sym;
		if (_tmp39_ != NULL) {
			ValaUnresolvedSymbol* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			ValaNamespace* _tmp43_;
			ValaSourceReference* _tmp44_;
			ValaSourceReference* _tmp45_;
			ValaNamespace* _tmp46_;
			_tmp40_ = sym;
			_tmp41_ = vala_symbol_get_name ((ValaSymbol*) _tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = ns;
			_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_namespace_new (_tmp42_, _tmp45_);
			_vala_code_node_unref0 (_tmp38_);
			_tmp38_ = (ValaSymbol*) _tmp46_;
		} else {
			ValaSymbol* _tmp47_;
			_tmp47_ = _vala_code_node_ref0 (parent);
			_vala_code_node_unref0 (_tmp38_);
			_tmp38_ = _tmp47_;
		}
		_tmp48_ = _vala_code_node_ref0 (_tmp38_);
		next = _tmp48_;
		_tmp49_ = next;
		_tmp50_ = _result_;
		vala_symbol_add_namespace (_tmp49_, G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_NAMESPACE, ValaNamespace));
		_tmp51_ = next;
		_tmp52_ = _vala_code_node_ref0 (_tmp51_);
		_vala_code_node_unref0 (_result_);
		_result_ = _tmp52_;
		_vala_code_node_unref0 (next);
		_vala_code_node_unref0 (_tmp38_);
	}
	_vala_code_node_unref0 (_result_);
	_vala_iterable_unref0 (old_using_directives);
	_vala_code_node_unref0 (ns);
	_vala_code_node_unref0 (sym);
}


static void
vala_parser_parse_using_directives (ValaParser* self,
                                    ValaNamespace* ns,
                                    GError** error)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	while (TRUE) {
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_USING)) {
			break;
		}
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaSourceLocation begin = {0};
				ValaSourceLocation _tmp1_ = {0};
				ValaUnresolvedSymbol* sym = NULL;
				ValaUnresolvedSymbol* _tmp2_;
				ValaUsingDirective* ns_ref = NULL;
				ValaUnresolvedSymbol* _tmp3_;
				ValaSourceLocation _tmp4_;
				ValaSourceReference* _tmp5_;
				ValaSourceReference* _tmp6_;
				ValaUsingDirective* _tmp7_;
				ValaUsingDirective* _tmp8_;
				ValaScanner* _tmp9_;
				ValaSourceFile* _tmp10_;
				ValaSourceFile* _tmp11_;
				ValaUsingDirective* _tmp12_;
				ValaUsingDirective* _tmp13_;
				if (!_tmp0_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp0_ = FALSE;
				vala_parser_get_location (self, &_tmp1_);
				begin = _tmp1_;
				_tmp2_ = vala_parser_parse_symbol_name (self, &_inner_error_);
				sym = _tmp2_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp3_ = sym;
				_tmp4_ = begin;
				_tmp5_ = vala_parser_get_src (self, &_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = vala_using_directive_new ((ValaSymbol*) _tmp3_, _tmp6_);
				_tmp8_ = _tmp7_;
				_vala_source_reference_unref0 (_tmp6_);
				ns_ref = _tmp8_;
				_tmp9_ = self->priv->scanner;
				_tmp10_ = vala_scanner_get_source_file (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = ns_ref;
				vala_source_file_add_using_directive (_tmp11_, _tmp12_);
				_tmp13_ = ns_ref;
				vala_namespace_add_using_directive (ns, _tmp13_);
				_vala_code_node_unref0 (ns_ref);
				_vala_code_node_unref0 (sym);
			}
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static void
vala_parser_parse_class_declaration (ValaParser* self,
                                     ValaSymbol* parent,
                                     ValaList* attrs,
                                     GError** error)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSymbolAccessibility access = 0;
	ValaParserModifierFlags flags = 0;
	ValaUnresolvedSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp1_;
	ValaList* type_param_list = NULL;
	ValaList* _tmp2_;
	ValaArrayList* base_types = NULL;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	ValaClass* cl = NULL;
	ValaUnresolvedSymbol* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ValaSourceLocation _tmp12_;
	ValaSourceReference* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaComment* _tmp15_;
	ValaClass* _tmp16_;
	ValaClass* _tmp17_;
	ValaClass* _tmp18_;
	ValaSymbolAccessibility _tmp19_;
	ValaParserModifierFlags _tmp20_;
	gboolean _tmp22_ = FALSE;
	ValaParserModifierFlags _tmp23_;
	ValaClass* _tmp30_;
	ValaClass* _tmp57_;
	gboolean _tmp58_ = FALSE;
	ValaScanner* _tmp59_;
	ValaSourceFile* _tmp60_;
	ValaSourceFile* _tmp61_;
	ValaSourceFileType _tmp62_;
	ValaSourceFileType _tmp63_;
	ValaSymbol* _result_ = NULL;
	ValaClass* _tmp83_;
	ValaSymbol* _tmp84_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	access = vala_parser_parse_access_modifier (self, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	flags = vala_parser_parse_type_declaration_modifiers (self);
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLASS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = vala_parser_parse_symbol_name (self, &_inner_error_);
	sym = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = vala_parser_parse_type_parameter_list (self, &_inner_error_);
	type_param_list = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
	base_types = _tmp4_;
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_COLON)) {
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				ValaDataType* _tmp6_ = NULL;
				ValaDataType* _tmp7_;
				ValaArrayList* _tmp8_;
				if (!_tmp5_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp5_ = FALSE;
				_tmp7_ = vala_parser_parse_type (self, TRUE, FALSE, FALSE, &_inner_error_);
				_tmp6_ = _tmp7_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_iterable_unref0 (base_types);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						return;
					} else {
						_vala_iterable_unref0 (base_types);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp8_ = base_types;
				vala_collection_add ((ValaCollection*) _tmp8_, _tmp6_);
				_vala_code_node_unref0 (_tmp6_);
			}
		}
	}
	_tmp9_ = sym;
	_tmp10_ = vala_symbol_get_name ((ValaSymbol*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = begin;
	_tmp13_ = vala_parser_get_src (self, &_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->comment;
	_tmp16_ = vala_class_new (_tmp11_, _tmp14_, _tmp15_);
	_tmp17_ = _tmp16_;
	_vala_source_reference_unref0 (_tmp14_);
	cl = _tmp17_;
	_tmp18_ = cl;
	_tmp19_ = access;
	vala_symbol_set_access ((ValaSymbol*) _tmp18_, _tmp19_);
	_tmp20_ = flags;
	if ((_tmp20_ & VALA_PARSER_MODIFIER_FLAGS_ABSTRACT) == VALA_PARSER_MODIFIER_FLAGS_ABSTRACT) {
		ValaClass* _tmp21_;
		_tmp21_ = cl;
		vala_class_set_is_abstract (_tmp21_, TRUE);
	}
	_tmp23_ = flags;
	if ((_tmp23_ & VALA_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp22_ = TRUE;
	} else {
		ValaScanner* _tmp24_;
		ValaSourceFile* _tmp25_;
		ValaSourceFile* _tmp26_;
		ValaSourceFileType _tmp27_;
		ValaSourceFileType _tmp28_;
		_tmp24_ = self->priv->scanner;
		_tmp25_ = vala_scanner_get_source_file (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_source_file_get_file_type (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp22_ = _tmp28_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	}
	if (_tmp22_) {
		ValaClass* _tmp29_;
		_tmp29_ = cl;
		vala_symbol_set_external ((ValaSymbol*) _tmp29_, TRUE);
	}
	_tmp30_ = cl;
	vala_parser_set_attributes (self, (ValaCodeNode*) _tmp30_, attrs);
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp31_;
		ValaList* _tmp32_;
		gint _type_param_size = 0;
		ValaList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _type_param_index = 0;
		_tmp31_ = type_param_list;
		_tmp32_ = _vala_iterable_ref0 (_tmp31_);
		_type_param_list = _tmp32_;
		_tmp33_ = _type_param_list;
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_type_param_size = _tmp35_;
		_type_param_index = -1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp39_;
			gint _tmp40_;
			gpointer _tmp41_;
			ValaClass* _tmp42_;
			ValaTypeParameter* _tmp43_;
			_tmp36_ = _type_param_index;
			_type_param_index = _tmp36_ + 1;
			_tmp37_ = _type_param_index;
			_tmp38_ = _type_param_size;
			if (!(_tmp37_ < _tmp38_)) {
				break;
			}
			_tmp39_ = _type_param_list;
			_tmp40_ = _type_param_index;
			_tmp41_ = vala_list_get (_tmp39_, _tmp40_);
			type_param = (ValaTypeParameter*) _tmp41_;
			_tmp42_ = cl;
			_tmp43_ = type_param;
			vala_object_type_symbol_add_type_parameter ((ValaObjectTypeSymbol*) _tmp42_, _tmp43_);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	{
		ValaArrayList* _base_type_list = NULL;
		ValaArrayList* _tmp44_;
		ValaArrayList* _tmp45_;
		gint _base_type_size = 0;
		ValaArrayList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint _base_type_index = 0;
		_tmp44_ = base_types;
		_tmp45_ = _vala_iterable_ref0 (_tmp44_);
		_base_type_list = _tmp45_;
		_tmp46_ = _base_type_list;
		_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_base_type_size = _tmp48_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			ValaDataType* base_type = NULL;
			ValaArrayList* _tmp52_;
			gint _tmp53_;
			gpointer _tmp54_;
			ValaClass* _tmp55_;
			ValaDataType* _tmp56_;
			_tmp49_ = _base_type_index;
			_base_type_index = _tmp49_ + 1;
			_tmp50_ = _base_type_index;
			_tmp51_ = _base_type_size;
			if (!(_tmp50_ < _tmp51_)) {
				break;
			}
			_tmp52_ = _base_type_list;
			_tmp53_ = _base_type_index;
			_tmp54_ = vala_list_get ((ValaList*) _tmp52_, _tmp53_);
			base_type = (ValaDataType*) _tmp54_;
			_tmp55_ = cl;
			_tmp56_ = base_type;
			vala_class_add_base_type (_tmp55_, _tmp56_);
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp57_ = cl;
	vala_parser_parse_declarations (self, (ValaSymbol*) _tmp57_, FALSE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (cl);
			_vala_iterable_unref0 (base_types);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_code_node_unref0 (cl);
			_vala_iterable_unref0 (base_types);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp59_ = self->priv->scanner;
	_tmp60_ = vala_scanner_get_source_file (_tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = vala_source_file_get_file_type (_tmp61_);
	_tmp63_ = _tmp62_;
	if (_tmp63_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		ValaClass* _tmp64_;
		ValaCreationMethod* _tmp65_;
		ValaCreationMethod* _tmp66_;
		_tmp64_ = cl;
		_tmp65_ = vala_class_get_default_construction_method (_tmp64_);
		_tmp66_ = _tmp65_;
		_tmp58_ = _tmp66_ == NULL;
	} else {
		_tmp58_ = FALSE;
	}
	if (_tmp58_) {
		ValaCreationMethod* m = NULL;
		ValaClass* _tmp67_;
		const gchar* _tmp68_;
		const gchar* _tmp69_;
		ValaClass* _tmp70_;
		ValaSourceReference* _tmp71_;
		ValaSourceReference* _tmp72_;
		ValaCreationMethod* _tmp73_;
		ValaCreationMethod* _tmp74_;
		ValaCreationMethod* _tmp75_;
		ValaClass* _tmp76_;
		ValaSourceReference* _tmp77_;
		ValaSourceReference* _tmp78_;
		ValaBlock* _tmp79_;
		ValaBlock* _tmp80_;
		ValaClass* _tmp81_;
		ValaCreationMethod* _tmp82_;
		_tmp67_ = cl;
		_tmp68_ = vala_symbol_get_name ((ValaSymbol*) _tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = cl;
		_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = vala_creation_method_new (_tmp69_, NULL, _tmp72_, NULL);
		m = _tmp73_;
		_tmp74_ = m;
		vala_symbol_set_access ((ValaSymbol*) _tmp74_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp75_ = m;
		_tmp76_ = cl;
		_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = vala_block_new (_tmp78_);
		_tmp80_ = _tmp79_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp75_, _tmp80_);
		_vala_code_node_unref0 (_tmp80_);
		_tmp81_ = cl;
		_tmp82_ = m;
		vala_symbol_add_method ((ValaSymbol*) _tmp81_, (ValaMethod*) _tmp82_);
		_vala_code_node_unref0 (m);
	}
	_tmp83_ = cl;
	_tmp84_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp83_);
	_result_ = _tmp84_;
	while (TRUE) {
		ValaUnresolvedSymbol* _tmp85_;
		ValaUnresolvedSymbol* _tmp86_;
		ValaUnresolvedSymbol* _tmp87_;
		ValaUnresolvedSymbol* _tmp88_;
		ValaUnresolvedSymbol* _tmp89_;
		ValaSymbol* _tmp90_ = NULL;
		ValaUnresolvedSymbol* _tmp91_;
		ValaSymbol* next = NULL;
		ValaSymbol* _tmp100_;
		ValaSymbol* _tmp101_;
		ValaSymbol* _tmp106_;
		ValaSymbol* _tmp107_;
		_tmp85_ = sym;
		if (!(_tmp85_ != NULL)) {
			break;
		}
		_tmp86_ = sym;
		_tmp87_ = vala_unresolved_symbol_get_inner (_tmp86_);
		_tmp88_ = _tmp87_;
		_tmp89_ = _vala_code_node_ref0 (_tmp88_);
		_vala_code_node_unref0 (sym);
		sym = _tmp89_;
		_tmp91_ = sym;
		if (_tmp91_ != NULL) {
			ValaUnresolvedSymbol* _tmp92_;
			const gchar* _tmp93_;
			const gchar* _tmp94_;
			ValaClass* _tmp95_;
			ValaSourceReference* _tmp96_;
			ValaSourceReference* _tmp97_;
			ValaNamespace* _tmp98_;
			_tmp92_ = sym;
			_tmp93_ = vala_symbol_get_name ((ValaSymbol*) _tmp92_);
			_tmp94_ = _tmp93_;
			_tmp95_ = cl;
			_tmp96_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp95_);
			_tmp97_ = _tmp96_;
			_tmp98_ = vala_namespace_new (_tmp94_, _tmp97_);
			_vala_code_node_unref0 (_tmp90_);
			_tmp90_ = (ValaSymbol*) _tmp98_;
		} else {
			ValaSymbol* _tmp99_;
			_tmp99_ = _vala_code_node_ref0 (parent);
			_vala_code_node_unref0 (_tmp90_);
			_tmp90_ = _tmp99_;
		}
		_tmp100_ = _vala_code_node_ref0 (_tmp90_);
		next = _tmp100_;
		_tmp101_ = _result_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp101_, VALA_TYPE_NAMESPACE)) {
			ValaSymbol* _tmp102_;
			ValaSymbol* _tmp103_;
			_tmp102_ = next;
			_tmp103_ = _result_;
			vala_symbol_add_namespace (_tmp102_, G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, VALA_TYPE_NAMESPACE, ValaNamespace));
		} else {
			ValaSymbol* _tmp104_;
			ValaSymbol* _tmp105_;
			_tmp104_ = next;
			_tmp105_ = _result_;
			vala_symbol_add_class (_tmp104_, G_TYPE_CHECK_INSTANCE_CAST (_tmp105_, VALA_TYPE_CLASS, ValaClass));
		}
		_tmp106_ = next;
		_tmp107_ = _vala_code_node_ref0 (_tmp106_);
		_vala_code_node_unref0 (_result_);
		_result_ = _tmp107_;
		_vala_code_node_unref0 (next);
		_vala_code_node_unref0 (_tmp90_);
	}
	_vala_code_node_unref0 (_result_);
	_vala_code_node_unref0 (cl);
	_vala_iterable_unref0 (base_types);
	_vala_iterable_unref0 (type_param_list);
	_vala_code_node_unref0 (sym);
}


static void
vala_parser_parse_constant_declaration (ValaParser* self,
                                        ValaSymbol* parent,
                                        ValaList* attrs,
                                        GError** error)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSymbolAccessibility access = 0;
	ValaParserModifierFlags flags = 0;
	ValaDataType* type = NULL;
	ValaDataType* _tmp1_;
	gchar* id = NULL;
	gchar* _tmp2_;
	ValaDataType* _tmp3_ = NULL;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaExpression* initializer = NULL;
	ValaArrayType* array_type = NULL;
	ValaDataType* _tmp10_;
	ValaArrayType* _tmp11_;
	ValaArrayType* _tmp12_;
	ValaConstant* c = NULL;
	const gchar* _tmp16_;
	ValaDataType* _tmp17_;
	ValaExpression* _tmp18_;
	ValaSourceLocation _tmp19_;
	ValaSourceReference* _tmp20_;
	ValaSourceReference* _tmp21_;
	ValaComment* _tmp22_;
	ValaConstant* _tmp23_;
	ValaConstant* _tmp24_;
	ValaConstant* _tmp25_;
	ValaSymbolAccessibility _tmp26_;
	gboolean _tmp27_ = FALSE;
	ValaParserModifierFlags _tmp28_;
	ValaParserModifierFlags _tmp35_;
	ValaConstant* _tmp37_;
	ValaParserModifierFlags _tmp38_;
	ValaConstant* _tmp42_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	access = vala_parser_parse_access_modifier (self, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	flags = vala_parser_parse_member_declaration_modifiers (self);
	vala_parser_expect (self, VALA_TOKEN_TYPE_CONST, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = vala_parser_parse_type (self, FALSE, FALSE, FALSE, &_inner_error_);
	type = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = vala_parser_parse_identifier (self, &_inner_error_);
	id = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = type;
	_tmp5_ = vala_parser_parse_inline_array_type (self, _tmp4_, &_inner_error_);
	_tmp3_ = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp6_ = _tmp3_;
	_tmp3_ = NULL;
	_vala_code_node_unref0 (type);
	type = _tmp6_;
	initializer = NULL;
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp7_ = NULL;
		ValaExpression* _tmp8_;
		ValaExpression* _tmp9_;
		_tmp8_ = vala_parser_parse_expression (self, &_inner_error_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (_tmp3_);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				return;
			} else {
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (_tmp3_);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp9_ = _tmp7_;
		_tmp7_ = NULL;
		_vala_code_node_unref0 (initializer);
		initializer = _tmp9_;
		_vala_code_node_unref0 (_tmp7_);
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (initializer);
			_vala_code_node_unref0 (_tmp3_);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (initializer);
			_vala_code_node_unref0 (_tmp3_);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp10_ = type;
	_tmp11_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp10_) : NULL);
	array_type = _tmp11_;
	_tmp12_ = array_type;
	if (_tmp12_ != NULL) {
		ValaArrayType* _tmp13_;
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		_tmp13_ = array_type;
		_tmp14_ = vala_array_type_get_element_type (_tmp13_);
		_tmp15_ = _tmp14_;
		vala_data_type_set_value_owned (_tmp15_, FALSE);
	}
	_tmp16_ = id;
	_tmp17_ = type;
	_tmp18_ = initializer;
	_tmp19_ = begin;
	_tmp20_ = vala_parser_get_src (self, &_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->comment;
	_tmp23_ = vala_constant_new (_tmp16_, _tmp17_, _tmp18_, _tmp21_, _tmp22_);
	_tmp24_ = _tmp23_;
	_vala_source_reference_unref0 (_tmp21_);
	c = _tmp24_;
	_tmp25_ = c;
	_tmp26_ = access;
	vala_symbol_set_access ((ValaSymbol*) _tmp25_, _tmp26_);
	_tmp28_ = flags;
	if ((_tmp28_ & VALA_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp27_ = TRUE;
	} else {
		ValaScanner* _tmp29_;
		ValaSourceFile* _tmp30_;
		ValaSourceFile* _tmp31_;
		ValaSourceFileType _tmp32_;
		ValaSourceFileType _tmp33_;
		_tmp29_ = self->priv->scanner;
		_tmp30_ = vala_scanner_get_source_file (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_source_file_get_file_type (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp27_ = _tmp33_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	}
	if (_tmp27_) {
		ValaConstant* _tmp34_;
		_tmp34_ = c;
		vala_symbol_set_external ((ValaSymbol*) _tmp34_, TRUE);
	}
	_tmp35_ = flags;
	if ((_tmp35_ & VALA_PARSER_MODIFIER_FLAGS_NEW) == VALA_PARSER_MODIFIER_FLAGS_NEW) {
		ValaConstant* _tmp36_;
		_tmp36_ = c;
		vala_symbol_set_hides ((ValaSymbol*) _tmp36_, TRUE);
	}
	_tmp37_ = c;
	vala_parser_set_attributes (self, (ValaCodeNode*) _tmp37_, attrs);
	_tmp38_ = flags;
	if ((_tmp38_ & VALA_PARSER_MODIFIER_FLAGS_STATIC) == VALA_PARSER_MODIFIER_FLAGS_STATIC) {
		ValaConstant* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		_tmp39_ = c;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp39_);
		_tmp41_ = _tmp40_;
		vala_report_warning (_tmp41_, "the modifier `static' is not applicable to constants");
	}
	_tmp42_ = c;
	vala_symbol_add_constant (parent, _tmp42_);
	_vala_code_node_unref0 (c);
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (initializer);
	_vala_code_node_unref0 (_tmp3_);
	_g_free0 (id);
	_vala_code_node_unref0 (type);
}


static void
vala_parser_parse_field_declaration (ValaParser* self,
                                     ValaSymbol* parent,
                                     ValaList* attrs,
                                     GError** error)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSymbolAccessibility _tmp1_ = 0;
	ValaSymbolAccessibility access = 0;
	ValaParserModifierFlags flags = 0;
	ValaDataType* type = NULL;
	ValaDataType* _tmp2_;
	gchar* id = NULL;
	gchar* _tmp3_;
	ValaDataType* _tmp4_ = NULL;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaField* f = NULL;
	const gchar* _tmp8_;
	ValaDataType* _tmp9_;
	ValaSourceLocation _tmp10_;
	ValaSourceReference* _tmp11_;
	ValaSourceReference* _tmp12_;
	ValaComment* _tmp13_;
	ValaField* _tmp14_;
	ValaField* _tmp15_;
	ValaField* _tmp16_;
	ValaSymbolAccessibility _tmp17_;
	ValaField* _tmp18_;
	gboolean _tmp19_ = FALSE;
	ValaParserModifierFlags _tmp20_;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	ValaParserModifierFlags _tmp42_;
	gboolean _tmp48_ = FALSE;
	ValaParserModifierFlags _tmp49_;
	ValaParserModifierFlags _tmp56_;
	ValaField* _tmp61_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (parent, VALA_TYPE_STRUCT)) {
		_tmp1_ = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	} else {
		_tmp1_ = VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
	}
	access = vala_parser_parse_access_modifier (self, _tmp1_);
	flags = vala_parser_parse_member_declaration_modifiers (self);
	_tmp2_ = vala_parser_parse_type (self, TRUE, TRUE, FALSE, &_inner_error_);
	type = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = vala_parser_parse_identifier (self, &_inner_error_);
	id = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp5_ = type;
	_tmp6_ = vala_parser_parse_inline_array_type (self, _tmp5_, &_inner_error_);
	_tmp4_ = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp7_ = _tmp4_;
	_tmp4_ = NULL;
	_vala_code_node_unref0 (type);
	type = _tmp7_;
	_tmp8_ = id;
	_tmp9_ = type;
	_tmp10_ = begin;
	_tmp11_ = vala_parser_get_src (self, &_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->comment;
	_tmp14_ = vala_field_new (_tmp8_, _tmp9_, NULL, _tmp12_, _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_source_reference_unref0 (_tmp12_);
	f = _tmp15_;
	_tmp16_ = f;
	_tmp17_ = access;
	vala_symbol_set_access ((ValaSymbol*) _tmp16_, _tmp17_);
	_tmp18_ = f;
	vala_parser_set_attributes (self, (ValaCodeNode*) _tmp18_, attrs);
	_tmp20_ = flags;
	if ((_tmp20_ & VALA_PARSER_MODIFIER_FLAGS_STATIC) == VALA_PARSER_MODIFIER_FLAGS_STATIC) {
		ValaParserModifierFlags _tmp21_;
		_tmp21_ = flags;
		_tmp19_ = (_tmp21_ & VALA_PARSER_MODIFIER_FLAGS_CLASS) == VALA_PARSER_MODIFIER_FLAGS_CLASS;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		ValaField* _tmp22_;
		ValaSourceReference* _tmp23_;
		ValaSourceReference* _tmp24_;
		_tmp22_ = f;
		_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp22_);
		_tmp24_ = _tmp23_;
		vala_report_error (_tmp24_, "only one of `static' or `class' may be specified");
	} else {
		ValaParserModifierFlags _tmp25_;
		_tmp25_ = flags;
		if ((_tmp25_ & VALA_PARSER_MODIFIER_FLAGS_STATIC) == VALA_PARSER_MODIFIER_FLAGS_STATIC) {
			ValaField* _tmp26_;
			_tmp26_ = f;
			vala_field_set_binding (_tmp26_, VALA_MEMBER_BINDING_STATIC);
		} else {
			ValaParserModifierFlags _tmp27_;
			_tmp27_ = flags;
			if ((_tmp27_ & VALA_PARSER_MODIFIER_FLAGS_CLASS) == VALA_PARSER_MODIFIER_FLAGS_CLASS) {
				ValaField* _tmp28_;
				_tmp28_ = f;
				vala_field_set_binding (_tmp28_, VALA_MEMBER_BINDING_CLASS);
			}
		}
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (parent, VALA_TYPE_STRUCT)) {
		ValaField* _tmp31_;
		ValaSymbolAccessibility _tmp32_;
		ValaSymbolAccessibility _tmp33_;
		_tmp31_ = f;
		_tmp32_ = vala_symbol_get_access ((ValaSymbol*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp30_ = _tmp33_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		ValaField* _tmp34_;
		ValaMemberBinding _tmp35_;
		ValaMemberBinding _tmp36_;
		_tmp34_ = f;
		_tmp35_ = vala_field_get_binding (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp29_ = _tmp36_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		ValaField* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaSourceReference* _tmp39_;
		_tmp37_ = f;
		_tmp38_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp37_);
		_tmp39_ = _tmp38_;
		vala_report_warning (_tmp39_, "accessibility of struct fields can only be `public`");
	}
	_tmp42_ = flags;
	if ((_tmp42_ & VALA_PARSER_MODIFIER_FLAGS_ABSTRACT) == VALA_PARSER_MODIFIER_FLAGS_ABSTRACT) {
		_tmp41_ = TRUE;
	} else {
		ValaParserModifierFlags _tmp43_;
		_tmp43_ = flags;
		_tmp41_ = (_tmp43_ & VALA_PARSER_MODIFIER_FLAGS_VIRTUAL) == VALA_PARSER_MODIFIER_FLAGS_VIRTUAL;
	}
	if (_tmp41_) {
		_tmp40_ = TRUE;
	} else {
		ValaParserModifierFlags _tmp44_;
		_tmp44_ = flags;
		_tmp40_ = (_tmp44_ & VALA_PARSER_MODIFIER_FLAGS_OVERRIDE) == VALA_PARSER_MODIFIER_FLAGS_OVERRIDE;
	}
	if (_tmp40_) {
		ValaField* _tmp45_;
		ValaSourceReference* _tmp46_;
		ValaSourceReference* _tmp47_;
		_tmp45_ = f;
		_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp45_);
		_tmp47_ = _tmp46_;
		vala_report_error (_tmp47_, "abstract, virtual, and override modifiers are not applicable to fields");
	}
	_tmp49_ = flags;
	if ((_tmp49_ & VALA_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp48_ = TRUE;
	} else {
		ValaScanner* _tmp50_;
		ValaSourceFile* _tmp51_;
		ValaSourceFile* _tmp52_;
		ValaSourceFileType _tmp53_;
		ValaSourceFileType _tmp54_;
		_tmp50_ = self->priv->scanner;
		_tmp51_ = vala_scanner_get_source_file (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_source_file_get_file_type (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp48_ = _tmp54_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	}
	if (_tmp48_) {
		ValaField* _tmp55_;
		_tmp55_ = f;
		vala_symbol_set_external ((ValaSymbol*) _tmp55_, TRUE);
	}
	_tmp56_ = flags;
	if ((_tmp56_ & VALA_PARSER_MODIFIER_FLAGS_NEW) == VALA_PARSER_MODIFIER_FLAGS_NEW) {
		ValaField* _tmp57_;
		_tmp57_ = f;
		vala_symbol_set_hides ((ValaSymbol*) _tmp57_, TRUE);
	}
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp58_ = NULL;
		ValaExpression* _tmp59_;
		ValaField* _tmp60_;
		_tmp59_ = vala_parser_parse_expression (self, &_inner_error_);
		_tmp58_ = _tmp59_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (f);
				_vala_code_node_unref0 (_tmp4_);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				return;
			} else {
				_vala_code_node_unref0 (f);
				_vala_code_node_unref0 (_tmp4_);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp60_ = f;
		vala_variable_set_initializer ((ValaVariable*) _tmp60_, _tmp58_);
		_vala_code_node_unref0 (_tmp58_);
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (f);
			_vala_code_node_unref0 (_tmp4_);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (f);
			_vala_code_node_unref0 (_tmp4_);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp61_ = f;
	vala_symbol_add_field (parent, _tmp61_);
	_vala_code_node_unref0 (f);
	_vala_code_node_unref0 (_tmp4_);
	_g_free0 (id);
	_vala_code_node_unref0 (type);
}


static ValaInitializerList*
vala_parser_parse_initializer (ValaParser* self,
                               GError** error)
{
	ValaInitializerList* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaInitializerList* initializer = NULL;
	ValaSourceLocation _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaInitializerList* _tmp4_;
	ValaInitializerList* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = begin;
	_tmp2_ = vala_parser_get_src (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_initializer_list_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_source_reference_unref0 (_tmp3_);
	initializer = _tmp5_;
	while (TRUE) {
		ValaExpression* init = NULL;
		ValaExpression* _tmp6_;
		ValaInitializerList* _tmp7_;
		ValaExpression* _tmp8_;
		if (!(vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_BRACE)) {
			break;
		}
		_tmp6_ = vala_parser_parse_argument (self, &_inner_error_);
		init = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (initializer);
				return NULL;
			} else {
				_vala_code_node_unref0 (initializer);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp7_ = initializer;
		_tmp8_ = init;
		vala_initializer_list_append (_tmp7_, _tmp8_);
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
			_vala_code_node_unref0 (init);
			break;
		}
		_vala_code_node_unref0 (init);
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (initializer);
			return NULL;
		} else {
			_vala_code_node_unref0 (initializer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = initializer;
	return result;
}


static void
vala_parser_parse_method_declaration (ValaParser* self,
                                      ValaSymbol* parent,
                                      ValaList* attrs,
                                      GError** error)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSymbolAccessibility access = 0;
	ValaParserModifierFlags flags = 0;
	ValaDataType* type = NULL;
	ValaDataType* _tmp1_;
	ValaUnresolvedSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp2_;
	ValaList* type_param_list = NULL;
	ValaList* _tmp3_;
	ValaMethod* method = NULL;
	ValaUnresolvedSymbol* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaDataType* _tmp7_;
	ValaSourceLocation _tmp8_;
	ValaSourceReference* _tmp9_;
	ValaSourceReference* _tmp10_;
	ValaComment* _tmp11_;
	ValaMethod* _tmp12_;
	ValaMethod* _tmp13_;
	ValaUnresolvedSymbol* _tmp14_;
	ValaUnresolvedSymbol* _tmp15_;
	ValaUnresolvedSymbol* _tmp16_;
	ValaMethod* _tmp28_;
	ValaSymbolAccessibility _tmp29_;
	ValaMethod* _tmp30_;
	gboolean _tmp44_ = FALSE;
	ValaParserModifierFlags _tmp45_;
	ValaParserModifierFlags _tmp54_;
	ValaParserModifierFlags _tmp56_;
	ValaMethod* _tmp58_;
	ValaMemberBinding _tmp59_;
	ValaMemberBinding _tmp60_;
	ValaParserModifierFlags _tmp99_;
	ValaParserModifierFlags _tmp101_;
	ValaMethod* _tmp126_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	access = vala_parser_parse_access_modifier (self, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	flags = vala_parser_parse_member_declaration_modifiers (self);
	_tmp1_ = vala_parser_parse_type (self, TRUE, FALSE, FALSE, &_inner_error_);
	type = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = vala_parser_parse_symbol_name (self, &_inner_error_);
	sym = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = vala_parser_parse_type_parameter_list (self, &_inner_error_);
	type_param_list = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = sym;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = type;
	_tmp8_ = begin;
	_tmp9_ = vala_parser_get_src (self, &_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->comment;
	_tmp12_ = vala_method_new (_tmp6_, _tmp7_, _tmp10_, _tmp11_);
	_tmp13_ = _tmp12_;
	_vala_source_reference_unref0 (_tmp10_);
	method = _tmp13_;
	_tmp14_ = sym;
	_tmp15_ = vala_unresolved_symbol_get_inner (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		ValaMethod* _tmp17_;
		ValaUnresolvedSymbol* _tmp18_;
		ValaUnresolvedSymbol* _tmp19_;
		ValaUnresolvedSymbol* _tmp20_;
		ValaUnresolvedSymbol* _tmp21_;
		ValaUnresolvedSymbol* _tmp22_;
		ValaUnresolvedSymbol* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaUnresolvedType* _tmp26_;
		ValaUnresolvedType* _tmp27_;
		_tmp17_ = method;
		_tmp18_ = sym;
		_tmp19_ = vala_unresolved_symbol_get_inner (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = sym;
		_tmp22_ = vala_unresolved_symbol_get_inner (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_unresolved_type_new_from_symbol (_tmp20_, _tmp25_);
		_tmp27_ = _tmp26_;
		vala_method_set_base_interface_type (_tmp17_, (ValaDataType*) _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
	}
	_tmp28_ = method;
	_tmp29_ = access;
	vala_symbol_set_access ((ValaSymbol*) _tmp28_, _tmp29_);
	_tmp30_ = method;
	vala_parser_set_attributes (self, (ValaCodeNode*) _tmp30_, attrs);
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp31_;
		ValaList* _tmp32_;
		gint _type_param_size = 0;
		ValaList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _type_param_index = 0;
		_tmp31_ = type_param_list;
		_tmp32_ = _vala_iterable_ref0 (_tmp31_);
		_type_param_list = _tmp32_;
		_tmp33_ = _type_param_list;
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_type_param_size = _tmp35_;
		_type_param_index = -1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp39_;
			gint _tmp40_;
			gpointer _tmp41_;
			ValaMethod* _tmp42_;
			ValaTypeParameter* _tmp43_;
			_tmp36_ = _type_param_index;
			_type_param_index = _tmp36_ + 1;
			_tmp37_ = _type_param_index;
			_tmp38_ = _type_param_size;
			if (!(_tmp37_ < _tmp38_)) {
				break;
			}
			_tmp39_ = _type_param_list;
			_tmp40_ = _type_param_index;
			_tmp41_ = vala_list_get (_tmp39_, _tmp40_);
			type_param = (ValaTypeParameter*) _tmp41_;
			_tmp42_ = method;
			_tmp43_ = type_param;
			vala_method_add_type_parameter (_tmp42_, _tmp43_);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	_tmp45_ = flags;
	if ((_tmp45_ & VALA_PARSER_MODIFIER_FLAGS_STATIC) == VALA_PARSER_MODIFIER_FLAGS_STATIC) {
		ValaParserModifierFlags _tmp46_;
		_tmp46_ = flags;
		_tmp44_ = (_tmp46_ & VALA_PARSER_MODIFIER_FLAGS_CLASS) == VALA_PARSER_MODIFIER_FLAGS_CLASS;
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		ValaMethod* _tmp47_;
		ValaSourceReference* _tmp48_;
		ValaSourceReference* _tmp49_;
		_tmp47_ = method;
		_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp47_);
		_tmp49_ = _tmp48_;
		vala_report_error (_tmp49_, "only one of `static' or `class' may be specified");
	} else {
		ValaParserModifierFlags _tmp50_;
		_tmp50_ = flags;
		if ((_tmp50_ & VALA_PARSER_MODIFIER_FLAGS_STATIC) == VALA_PARSER_MODIFIER_FLAGS_STATIC) {
			ValaMethod* _tmp51_;
			_tmp51_ = method;
			vala_method_set_binding (_tmp51_, VALA_MEMBER_BINDING_STATIC);
		} else {
			ValaParserModifierFlags _tmp52_;
			_tmp52_ = flags;
			if ((_tmp52_ & VALA_PARSER_MODIFIER_FLAGS_CLASS) == VALA_PARSER_MODIFIER_FLAGS_CLASS) {
				ValaMethod* _tmp53_;
				_tmp53_ = method;
				vala_method_set_binding (_tmp53_, VALA_MEMBER_BINDING_CLASS);
			}
		}
	}
	_tmp54_ = flags;
	if ((_tmp54_ & VALA_PARSER_MODIFIER_FLAGS_ASYNC) == VALA_PARSER_MODIFIER_FLAGS_ASYNC) {
		ValaMethod* _tmp55_;
		_tmp55_ = method;
		vala_method_set_coroutine (_tmp55_, TRUE);
	}
	_tmp56_ = flags;
	if ((_tmp56_ & VALA_PARSER_MODIFIER_FLAGS_NEW) == VALA_PARSER_MODIFIER_FLAGS_NEW) {
		ValaMethod* _tmp57_;
		_tmp57_ = method;
		vala_symbol_set_hides ((ValaSymbol*) _tmp57_, TRUE);
	}
	_tmp58_ = method;
	_tmp59_ = vala_method_get_binding (_tmp58_);
	_tmp60_ = _tmp59_;
	if (_tmp60_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaParserModifierFlags _tmp61_;
		ValaParserModifierFlags _tmp63_;
		ValaParserModifierFlags _tmp65_;
		gboolean _tmp67_ = FALSE;
		gboolean _tmp68_ = FALSE;
		gboolean _tmp69_ = FALSE;
		ValaMethod* _tmp70_;
		gboolean _tmp71_;
		gboolean _tmp72_;
		_tmp61_ = flags;
		if ((_tmp61_ & VALA_PARSER_MODIFIER_FLAGS_ABSTRACT) == VALA_PARSER_MODIFIER_FLAGS_ABSTRACT) {
			ValaMethod* _tmp62_;
			_tmp62_ = method;
			vala_method_set_is_abstract (_tmp62_, TRUE);
		}
		_tmp63_ = flags;
		if ((_tmp63_ & VALA_PARSER_MODIFIER_FLAGS_VIRTUAL) == VALA_PARSER_MODIFIER_FLAGS_VIRTUAL) {
			ValaMethod* _tmp64_;
			_tmp64_ = method;
			vala_method_set_is_virtual (_tmp64_, TRUE);
		}
		_tmp65_ = flags;
		if ((_tmp65_ & VALA_PARSER_MODIFIER_FLAGS_OVERRIDE) == VALA_PARSER_MODIFIER_FLAGS_OVERRIDE) {
			ValaMethod* _tmp66_;
			_tmp66_ = method;
			vala_method_set_overrides (_tmp66_, TRUE);
		}
		_tmp70_ = method;
		_tmp71_ = vala_method_get_is_abstract (_tmp70_);
		_tmp72_ = _tmp71_;
		if (_tmp72_) {
			ValaMethod* _tmp73_;
			gboolean _tmp74_;
			gboolean _tmp75_;
			_tmp73_ = method;
			_tmp74_ = vala_method_get_is_virtual (_tmp73_);
			_tmp75_ = _tmp74_;
			_tmp69_ = _tmp75_;
		} else {
			_tmp69_ = FALSE;
		}
		if (_tmp69_) {
			_tmp68_ = TRUE;
		} else {
			gboolean _tmp76_ = FALSE;
			ValaMethod* _tmp77_;
			gboolean _tmp78_;
			gboolean _tmp79_;
			_tmp77_ = method;
			_tmp78_ = vala_method_get_is_abstract (_tmp77_);
			_tmp79_ = _tmp78_;
			if (_tmp79_) {
				ValaMethod* _tmp80_;
				gboolean _tmp81_;
				gboolean _tmp82_;
				_tmp80_ = method;
				_tmp81_ = vala_method_get_overrides (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp76_ = _tmp82_;
			} else {
				_tmp76_ = FALSE;
			}
			_tmp68_ = _tmp76_;
		}
		if (_tmp68_) {
			_tmp67_ = TRUE;
		} else {
			gboolean _tmp83_ = FALSE;
			ValaMethod* _tmp84_;
			gboolean _tmp85_;
			gboolean _tmp86_;
			_tmp84_ = method;
			_tmp85_ = vala_method_get_is_virtual (_tmp84_);
			_tmp86_ = _tmp85_;
			if (_tmp86_) {
				ValaMethod* _tmp87_;
				gboolean _tmp88_;
				gboolean _tmp89_;
				_tmp87_ = method;
				_tmp88_ = vala_method_get_overrides (_tmp87_);
				_tmp89_ = _tmp88_;
				_tmp83_ = _tmp89_;
			} else {
				_tmp83_ = FALSE;
			}
			_tmp67_ = _tmp83_;
		}
		if (_tmp67_) {
			GError* _tmp90_;
			_tmp90_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "only one of `abstract', `virtual', or `override' may be specified");
			_inner_error_ = _tmp90_;
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				return;
			} else {
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		gboolean _tmp91_ = FALSE;
		gboolean _tmp92_ = FALSE;
		ValaParserModifierFlags _tmp93_;
		_tmp93_ = flags;
		if ((_tmp93_ & VALA_PARSER_MODIFIER_FLAGS_ABSTRACT) == VALA_PARSER_MODIFIER_FLAGS_ABSTRACT) {
			_tmp92_ = TRUE;
		} else {
			ValaParserModifierFlags _tmp94_;
			_tmp94_ = flags;
			_tmp92_ = (_tmp94_ & VALA_PARSER_MODIFIER_FLAGS_VIRTUAL) == VALA_PARSER_MODIFIER_FLAGS_VIRTUAL;
		}
		if (_tmp92_) {
			_tmp91_ = TRUE;
		} else {
			ValaParserModifierFlags _tmp95_;
			_tmp95_ = flags;
			_tmp91_ = (_tmp95_ & VALA_PARSER_MODIFIER_FLAGS_OVERRIDE) == VALA_PARSER_MODIFIER_FLAGS_OVERRIDE;
		}
		if (_tmp91_) {
			const gchar* _tmp96_ = NULL;
			ValaParserModifierFlags _tmp97_;
			GError* _tmp98_;
			_tmp97_ = flags;
			if ((_tmp97_ & VALA_PARSER_MODIFIER_FLAGS_CLASS) == VALA_PARSER_MODIFIER_FLAGS_CLASS) {
				_tmp96_ = "class";
			} else {
				_tmp96_ = "static";
			}
			_tmp98_ = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "the modifiers `abstract', `virtual', and `override' are not valid for " \
"%s methods", _tmp96_);
			_inner_error_ = _tmp98_;
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				return;
			} else {
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tmp99_ = flags;
	if ((_tmp99_ & VALA_PARSER_MODIFIER_FLAGS_INLINE) == VALA_PARSER_MODIFIER_FLAGS_INLINE) {
		ValaMethod* _tmp100_;
		_tmp100_ = method;
		vala_method_set_is_inline (_tmp100_, TRUE);
	}
	_tmp101_ = flags;
	if ((_tmp101_ & VALA_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_PARSER_MODIFIER_FLAGS_EXTERN) {
		ValaMethod* _tmp102_;
		_tmp102_ = method;
		vala_symbol_set_external ((ValaSymbol*) _tmp102_, TRUE);
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (method);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (method);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_PARENS) {
		{
			gboolean _tmp103_ = FALSE;
			_tmp103_ = TRUE;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaParameter* _tmp104_;
				ValaMethod* _tmp105_;
				ValaParameter* _tmp106_;
				if (!_tmp103_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp103_ = FALSE;
				_tmp104_ = vala_parser_parse_parameter (self, &_inner_error_);
				param = _tmp104_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						return;
					} else {
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp105_ = method;
				_tmp106_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp105_, _tmp106_);
				_vala_code_node_unref0 (param);
			}
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (method);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (method);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_THROWS)) {
		{
			gboolean _tmp107_ = FALSE;
			_tmp107_ = TRUE;
			while (TRUE) {
				ValaDataType* _tmp108_ = NULL;
				ValaDataType* _tmp109_;
				ValaMethod* _tmp110_;
				if (!_tmp107_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp107_ = FALSE;
				_tmp109_ = vala_parser_parse_type (self, TRUE, FALSE, FALSE, &_inner_error_);
				_tmp108_ = _tmp109_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						return;
					} else {
						_vala_code_node_unref0 (method);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp110_ = method;
				vala_code_node_add_error_type ((ValaCodeNode*) _tmp110_, _tmp108_);
				_vala_code_node_unref0 (_tmp108_);
			}
		}
	}
	while (TRUE) {
		ValaExpression* _tmp111_ = NULL;
		ValaExpression* _tmp112_;
		ValaMethod* _tmp113_;
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_REQUIRES)) {
			break;
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				return;
			} else {
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp112_ = vala_parser_parse_expression (self, &_inner_error_);
		_tmp111_ = _tmp112_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				return;
			} else {
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp113_ = method;
		vala_method_add_precondition (_tmp113_, _tmp111_);
		vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (_tmp111_);
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				return;
			} else {
				_vala_code_node_unref0 (_tmp111_);
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_vala_code_node_unref0 (_tmp111_);
	}
	while (TRUE) {
		ValaExpression* _tmp114_ = NULL;
		ValaExpression* _tmp115_;
		ValaMethod* _tmp116_;
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_ENSURES)) {
			break;
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				return;
			} else {
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp115_ = vala_parser_parse_expression (self, &_inner_error_);
		_tmp114_ = _tmp115_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				return;
			} else {
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp116_ = method;
		vala_method_add_postcondition (_tmp116_, _tmp114_);
		vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (_tmp114_);
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				return;
			} else {
				_vala_code_node_unref0 (_tmp114_);
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_vala_code_node_unref0 (_tmp114_);
	}
	if (!vala_parser_accept (self, VALA_TOKEN_TYPE_SEMICOLON)) {
		ValaBlock* _tmp117_ = NULL;
		ValaBlock* _tmp118_;
		ValaMethod* _tmp119_;
		_tmp118_ = vala_parser_parse_block (self, &_inner_error_);
		_tmp117_ = _tmp118_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				return;
			} else {
				_vala_code_node_unref0 (method);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp119_ = method;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp119_, _tmp117_);
		_vala_code_node_unref0 (_tmp117_);
	} else {
		ValaScanner* _tmp120_;
		ValaSourceFile* _tmp121_;
		ValaSourceFile* _tmp122_;
		ValaSourceFileType _tmp123_;
		ValaSourceFileType _tmp124_;
		_tmp120_ = self->priv->scanner;
		_tmp121_ = vala_scanner_get_source_file (_tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_source_file_get_file_type (_tmp122_);
		_tmp124_ = _tmp123_;
		if (_tmp124_ == VALA_SOURCE_FILE_TYPE_PACKAGE) {
			ValaMethod* _tmp125_;
			_tmp125_ = method;
			vala_symbol_set_external ((ValaSymbol*) _tmp125_, TRUE);
		}
	}
	_tmp126_ = method;
	vala_symbol_add_method (parent, _tmp126_);
	_vala_code_node_unref0 (method);
	_vala_iterable_unref0 (type_param_list);
	_vala_code_node_unref0 (sym);
	_vala_code_node_unref0 (type);
}


static void
vala_parser_parse_property_declaration (ValaParser* self,
                                        ValaSymbol* parent,
                                        ValaList* attrs,
                                        GError** error)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSymbolAccessibility access = 0;
	ValaParserModifierFlags flags = 0;
	ValaDataType* type = NULL;
	ValaDataType* _tmp1_;
	gboolean getter_owned = FALSE;
	gchar* id = NULL;
	gchar* _tmp7_;
	ValaProperty* prop = NULL;
	const gchar* _tmp8_;
	ValaDataType* _tmp9_;
	ValaSourceLocation _tmp10_;
	ValaSourceReference* _tmp11_;
	ValaSourceReference* _tmp12_;
	ValaComment* _tmp13_;
	ValaProperty* _tmp14_;
	ValaProperty* _tmp15_;
	ValaProperty* _tmp16_;
	ValaSymbolAccessibility _tmp17_;
	ValaProperty* _tmp18_;
	gboolean _tmp19_ = FALSE;
	ValaParserModifierFlags _tmp20_;
	ValaParserModifierFlags _tmp29_;
	ValaParserModifierFlags _tmp31_;
	ValaParserModifierFlags _tmp33_;
	ValaParserModifierFlags _tmp35_;
	ValaParserModifierFlags _tmp37_;
	gboolean _tmp41_ = FALSE;
	ValaParserModifierFlags _tmp42_;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	ValaProperty* _tmp52_;
	gboolean _tmp53_;
	gboolean _tmp54_;
	gboolean _tmp152_ = FALSE;
	ValaProperty* _tmp153_;
	gboolean _tmp154_;
	gboolean _tmp155_;
	ValaProperty* _tmp228_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	access = vala_parser_parse_access_modifier (self, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	flags = vala_parser_parse_member_declaration_modifiers (self);
	_tmp1_ = vala_parser_parse_type (self, TRUE, TRUE, FALSE, &_inner_error_);
	type = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	getter_owned = FALSE;
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_HASH)) {
		ValaCodeContext* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->context;
		_tmp3_ = vala_code_context_get_deprecated (_tmp2_);
		_tmp4_ = _tmp3_;
		if (!_tmp4_) {
			ValaSourceReference* _tmp5_;
			ValaSourceReference* _tmp6_;
			_tmp5_ = vala_parser_get_last_src (self);
			_tmp6_ = _tmp5_;
			vala_report_warning (_tmp6_, "deprecated syntax, use `owned` modifier before `get'");
			_vala_source_reference_unref0 (_tmp6_);
		}
		getter_owned = TRUE;
	}
	_tmp7_ = vala_parser_parse_identifier (self, &_inner_error_);
	id = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp8_ = id;
	_tmp9_ = type;
	_tmp10_ = begin;
	_tmp11_ = vala_parser_get_src (self, &_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->comment;
	_tmp14_ = vala_property_new (_tmp8_, _tmp9_, NULL, NULL, _tmp12_, _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_source_reference_unref0 (_tmp12_);
	prop = _tmp15_;
	_tmp16_ = prop;
	_tmp17_ = access;
	vala_symbol_set_access ((ValaSymbol*) _tmp16_, _tmp17_);
	_tmp18_ = prop;
	vala_parser_set_attributes (self, (ValaCodeNode*) _tmp18_, attrs);
	_tmp20_ = flags;
	if ((_tmp20_ & VALA_PARSER_MODIFIER_FLAGS_STATIC) == VALA_PARSER_MODIFIER_FLAGS_STATIC) {
		ValaParserModifierFlags _tmp21_;
		_tmp21_ = flags;
		_tmp19_ = (_tmp21_ & VALA_PARSER_MODIFIER_FLAGS_CLASS) == VALA_PARSER_MODIFIER_FLAGS_CLASS;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		ValaProperty* _tmp22_;
		ValaSourceReference* _tmp23_;
		ValaSourceReference* _tmp24_;
		_tmp22_ = prop;
		_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp22_);
		_tmp24_ = _tmp23_;
		vala_report_error (_tmp24_, "only one of `static' or `class' may be specified");
	} else {
		ValaParserModifierFlags _tmp25_;
		_tmp25_ = flags;
		if ((_tmp25_ & VALA_PARSER_MODIFIER_FLAGS_STATIC) == VALA_PARSER_MODIFIER_FLAGS_STATIC) {
			ValaProperty* _tmp26_;
			_tmp26_ = prop;
			vala_property_set_binding (_tmp26_, VALA_MEMBER_BINDING_STATIC);
		} else {
			ValaParserModifierFlags _tmp27_;
			_tmp27_ = flags;
			if ((_tmp27_ & VALA_PARSER_MODIFIER_FLAGS_CLASS) == VALA_PARSER_MODIFIER_FLAGS_CLASS) {
				ValaProperty* _tmp28_;
				_tmp28_ = prop;
				vala_property_set_binding (_tmp28_, VALA_MEMBER_BINDING_CLASS);
			}
		}
	}
	_tmp29_ = flags;
	if ((_tmp29_ & VALA_PARSER_MODIFIER_FLAGS_ABSTRACT) == VALA_PARSER_MODIFIER_FLAGS_ABSTRACT) {
		ValaProperty* _tmp30_;
		_tmp30_ = prop;
		vala_property_set_is_abstract (_tmp30_, TRUE);
	}
	_tmp31_ = flags;
	if ((_tmp31_ & VALA_PARSER_MODIFIER_FLAGS_VIRTUAL) == VALA_PARSER_MODIFIER_FLAGS_VIRTUAL) {
		ValaProperty* _tmp32_;
		_tmp32_ = prop;
		vala_property_set_is_virtual (_tmp32_, TRUE);
	}
	_tmp33_ = flags;
	if ((_tmp33_ & VALA_PARSER_MODIFIER_FLAGS_OVERRIDE) == VALA_PARSER_MODIFIER_FLAGS_OVERRIDE) {
		ValaProperty* _tmp34_;
		_tmp34_ = prop;
		vala_property_set_overrides (_tmp34_, TRUE);
	}
	_tmp35_ = flags;
	if ((_tmp35_ & VALA_PARSER_MODIFIER_FLAGS_NEW) == VALA_PARSER_MODIFIER_FLAGS_NEW) {
		ValaProperty* _tmp36_;
		_tmp36_ = prop;
		vala_symbol_set_hides ((ValaSymbol*) _tmp36_, TRUE);
	}
	_tmp37_ = flags;
	if ((_tmp37_ & VALA_PARSER_MODIFIER_FLAGS_ASYNC) == VALA_PARSER_MODIFIER_FLAGS_ASYNC) {
		ValaProperty* _tmp38_;
		ValaSourceReference* _tmp39_;
		ValaSourceReference* _tmp40_;
		_tmp38_ = prop;
		_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp38_);
		_tmp40_ = _tmp39_;
		vala_report_error (_tmp40_, "async properties are not supported yet");
	}
	_tmp42_ = flags;
	if ((_tmp42_ & VALA_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp41_ = TRUE;
	} else {
		ValaScanner* _tmp43_;
		ValaSourceFile* _tmp44_;
		ValaSourceFile* _tmp45_;
		ValaSourceFileType _tmp46_;
		ValaSourceFileType _tmp47_;
		_tmp43_ = self->priv->scanner;
		_tmp44_ = vala_scanner_get_source_file (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_source_file_get_file_type (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp41_ = _tmp47_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	}
	if (_tmp41_) {
		ValaProperty* _tmp48_;
		_tmp48_ = prop;
		vala_symbol_set_external ((ValaSymbol*) _tmp48_, TRUE);
	}
	_tmp52_ = prop;
	_tmp53_ = vala_property_get_is_abstract (_tmp52_);
	_tmp54_ = _tmp53_;
	if (_tmp54_) {
		ValaProperty* _tmp55_;
		gboolean _tmp56_;
		gboolean _tmp57_;
		_tmp55_ = prop;
		_tmp56_ = vala_property_get_is_virtual (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp51_ = _tmp57_;
	} else {
		_tmp51_ = FALSE;
	}
	if (_tmp51_) {
		_tmp50_ = TRUE;
	} else {
		gboolean _tmp58_ = FALSE;
		ValaProperty* _tmp59_;
		gboolean _tmp60_;
		gboolean _tmp61_;
		_tmp59_ = prop;
		_tmp60_ = vala_property_get_is_abstract (_tmp59_);
		_tmp61_ = _tmp60_;
		if (_tmp61_) {
			ValaProperty* _tmp62_;
			gboolean _tmp63_;
			gboolean _tmp64_;
			_tmp62_ = prop;
			_tmp63_ = vala_property_get_overrides (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp58_ = _tmp64_;
		} else {
			_tmp58_ = FALSE;
		}
		_tmp50_ = _tmp58_;
	}
	if (_tmp50_) {
		_tmp49_ = TRUE;
	} else {
		gboolean _tmp65_ = FALSE;
		ValaProperty* _tmp66_;
		gboolean _tmp67_;
		gboolean _tmp68_;
		_tmp66_ = prop;
		_tmp67_ = vala_property_get_is_virtual (_tmp66_);
		_tmp68_ = _tmp67_;
		if (_tmp68_) {
			ValaProperty* _tmp69_;
			gboolean _tmp70_;
			gboolean _tmp71_;
			_tmp69_ = prop;
			_tmp70_ = vala_property_get_overrides (_tmp69_);
			_tmp71_ = _tmp70_;
			_tmp65_ = _tmp71_;
		} else {
			_tmp65_ = FALSE;
		}
		_tmp49_ = _tmp65_;
	}
	if (_tmp49_) {
		GError* _tmp72_;
		_tmp72_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "only one of `abstract', `virtual', or `override' may be specified");
		_inner_error_ = _tmp72_;
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (prop);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (prop);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_THROWS)) {
		ValaProperty* _tmp77_;
		ValaSourceReference* _tmp78_;
		ValaSourceReference* _tmp79_;
		{
			gboolean _tmp73_ = FALSE;
			_tmp73_ = TRUE;
			while (TRUE) {
				ValaDataType* _tmp74_ = NULL;
				ValaDataType* _tmp75_;
				ValaProperty* _tmp76_;
				if (!_tmp73_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp73_ = FALSE;
				_tmp75_ = vala_parser_parse_type (self, TRUE, FALSE, FALSE, &_inner_error_);
				_tmp74_ = _tmp75_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (prop);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						return;
					} else {
						_vala_code_node_unref0 (prop);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp76_ = prop;
				vala_code_node_add_error_type ((ValaCodeNode*) _tmp76_, _tmp74_);
				_vala_code_node_unref0 (_tmp74_);
			}
		}
		_tmp77_ = prop;
		_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp77_);
		_tmp79_ = _tmp78_;
		vala_report_error (_tmp79_, "properties throwing errors are not supported yet");
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (prop);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (prop);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		if (!(vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_BRACE)) {
			break;
		}
		if (vala_parser_accept (self, VALA_TOKEN_TYPE_DEFAULT)) {
			ValaProperty* _tmp80_;
			ValaExpression* _tmp81_;
			ValaExpression* _tmp82_;
			ValaExpression* _tmp84_ = NULL;
			ValaExpression* _tmp85_;
			ValaProperty* _tmp86_;
			_tmp80_ = prop;
			_tmp81_ = vala_property_get_initializer (_tmp80_);
			_tmp82_ = _tmp81_;
			if (_tmp82_ != NULL) {
				GError* _tmp83_;
				_tmp83_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "property default value already defined");
				_inner_error_ = _tmp83_;
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (prop);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					return;
				} else {
					_vala_code_node_unref0 (prop);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			vala_parser_expect (self, VALA_TOKEN_TYPE_ASSIGN, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (prop);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					return;
				} else {
					_vala_code_node_unref0 (prop);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp85_ = vala_parser_parse_expression (self, &_inner_error_);
			_tmp84_ = _tmp85_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (prop);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					return;
				} else {
					_vala_code_node_unref0 (prop);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp86_ = prop;
			vala_property_set_initializer (_tmp86_, _tmp84_);
			vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (_tmp84_);
					_vala_code_node_unref0 (prop);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					return;
				} else {
					_vala_code_node_unref0 (_tmp84_);
					_vala_code_node_unref0 (prop);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_vala_code_node_unref0 (_tmp84_);
		} else {
			ValaScanner* _tmp87_;
			ValaComment* _tmp88_;
			ValaSourceLocation accessor_begin = {0};
			ValaSourceLocation _tmp89_ = {0};
			ValaList* accessor_attrs = NULL;
			ValaList* _tmp90_;
			ValaSymbolAccessibility accessor_access = 0;
			ValaDataType* value_type = NULL;
			ValaDataType* _tmp91_;
			ValaDataType* _tmp92_;
			_tmp87_ = self->priv->scanner;
			_tmp88_ = vala_scanner_pop_comment (_tmp87_);
			_vala_comment_unref0 (self->priv->comment);
			self->priv->comment = _tmp88_;
			vala_parser_get_location (self, &_tmp89_);
			accessor_begin = _tmp89_;
			_tmp90_ = vala_parser_parse_attributes (self, &_inner_error_);
			accessor_attrs = _tmp90_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (prop);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					return;
				} else {
					_vala_code_node_unref0 (prop);
					_g_free0 (id);
					_vala_code_node_unref0 (type);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			accessor_access = vala_parser_parse_access_modifier (self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp91_ = type;
			_tmp92_ = vala_data_type_copy (_tmp91_);
			value_type = _tmp92_;
			if (vala_parser_accept (self, VALA_TOKEN_TYPE_OWNED)) {
				ValaDataType* _tmp93_;
				_tmp93_ = value_type;
				vala_data_type_set_value_owned (_tmp93_, TRUE);
			} else {
				ValaDataType* _tmp94_;
				_tmp94_ = value_type;
				vala_data_type_set_value_owned (_tmp94_, FALSE);
				if (vala_parser_accept (self, VALA_TOKEN_TYPE_UNOWNED)) {
					ValaSourceReference* _tmp95_;
					ValaSourceReference* _tmp96_;
					_tmp95_ = vala_parser_get_last_src (self);
					_tmp96_ = _tmp95_;
					vala_report_warning (_tmp96_, "property getters are `unowned' by default");
					_vala_source_reference_unref0 (_tmp96_);
				}
			}
			if (vala_parser_accept (self, VALA_TOKEN_TYPE_GET)) {
				ValaProperty* _tmp97_;
				ValaPropertyAccessor* _tmp98_;
				ValaPropertyAccessor* _tmp99_;
				gboolean _tmp101_;
				ValaBlock* block = NULL;
				ValaProperty* _tmp107_;
				ValaDataType* _tmp108_;
				ValaBlock* _tmp109_;
				ValaSourceLocation _tmp110_;
				ValaSourceReference* _tmp111_;
				ValaSourceReference* _tmp112_;
				ValaComment* _tmp113_;
				ValaPropertyAccessor* _tmp114_;
				ValaPropertyAccessor* _tmp115_;
				ValaProperty* _tmp116_;
				ValaPropertyAccessor* _tmp117_;
				ValaPropertyAccessor* _tmp118_;
				ValaList* _tmp119_;
				ValaProperty* _tmp120_;
				ValaPropertyAccessor* _tmp121_;
				ValaPropertyAccessor* _tmp122_;
				ValaSymbolAccessibility _tmp123_;
				_tmp97_ = prop;
				_tmp98_ = vala_property_get_get_accessor (_tmp97_);
				_tmp99_ = _tmp98_;
				if (_tmp99_ != NULL) {
					GError* _tmp100_;
					_tmp100_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "property get accessor already defined");
					_inner_error_ = _tmp100_;
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (value_type);
						_vala_iterable_unref0 (accessor_attrs);
						_vala_code_node_unref0 (prop);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						return;
					} else {
						_vala_code_node_unref0 (value_type);
						_vala_iterable_unref0 (accessor_attrs);
						_vala_code_node_unref0 (prop);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp101_ = getter_owned;
				if (_tmp101_) {
					ValaDataType* _tmp102_;
					_tmp102_ = value_type;
					vala_data_type_set_value_owned (_tmp102_, TRUE);
				}
				block = NULL;
				if (!vala_parser_accept (self, VALA_TOKEN_TYPE_SEMICOLON)) {
					ValaBlock* _tmp103_ = NULL;
					ValaBlock* _tmp104_;
					ValaBlock* _tmp105_;
					ValaProperty* _tmp106_;
					_tmp104_ = vala_parser_parse_block (self, &_inner_error_);
					_tmp103_ = _tmp104_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_vala_code_node_unref0 (block);
							_vala_code_node_unref0 (value_type);
							_vala_iterable_unref0 (accessor_attrs);
							_vala_code_node_unref0 (prop);
							_g_free0 (id);
							_vala_code_node_unref0 (type);
							return;
						} else {
							_vala_code_node_unref0 (block);
							_vala_code_node_unref0 (value_type);
							_vala_iterable_unref0 (accessor_attrs);
							_vala_code_node_unref0 (prop);
							_g_free0 (id);
							_vala_code_node_unref0 (type);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp105_ = _tmp103_;
					_tmp103_ = NULL;
					_vala_code_node_unref0 (block);
					block = _tmp105_;
					_tmp106_ = prop;
					vala_symbol_set_external ((ValaSymbol*) _tmp106_, FALSE);
					_vala_code_node_unref0 (_tmp103_);
				}
				_tmp107_ = prop;
				_tmp108_ = value_type;
				_tmp109_ = block;
				_tmp110_ = accessor_begin;
				_tmp111_ = vala_parser_get_src (self, &_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp113_ = self->priv->comment;
				_tmp114_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp108_, _tmp109_, _tmp112_, _tmp113_);
				_tmp115_ = _tmp114_;
				vala_property_set_get_accessor (_tmp107_, _tmp115_);
				_vala_code_node_unref0 (_tmp115_);
				_vala_source_reference_unref0 (_tmp112_);
				_tmp116_ = prop;
				_tmp117_ = vala_property_get_get_accessor (_tmp116_);
				_tmp118_ = _tmp117_;
				_tmp119_ = accessor_attrs;
				vala_parser_set_attributes (self, (ValaCodeNode*) _tmp118_, _tmp119_);
				_tmp120_ = prop;
				_tmp121_ = vala_property_get_get_accessor (_tmp120_);
				_tmp122_ = _tmp121_;
				_tmp123_ = accessor_access;
				vala_symbol_set_access ((ValaSymbol*) _tmp122_, _tmp123_);
				_vala_code_node_unref0 (block);
			} else {
				gboolean writable = FALSE;
				gboolean _construct = FALSE;
				ValaProperty* _tmp125_;
				ValaPropertyAccessor* _tmp126_;
				ValaPropertyAccessor* _tmp127_;
				ValaBlock* block = NULL;
				ValaProperty* _tmp133_;
				gboolean _tmp134_;
				gboolean _tmp135_;
				ValaDataType* _tmp136_;
				ValaBlock* _tmp137_;
				ValaSourceLocation _tmp138_;
				ValaSourceReference* _tmp139_;
				ValaSourceReference* _tmp140_;
				ValaComment* _tmp141_;
				ValaPropertyAccessor* _tmp142_;
				ValaPropertyAccessor* _tmp143_;
				ValaProperty* _tmp144_;
				ValaPropertyAccessor* _tmp145_;
				ValaPropertyAccessor* _tmp146_;
				ValaList* _tmp147_;
				ValaProperty* _tmp148_;
				ValaPropertyAccessor* _tmp149_;
				ValaPropertyAccessor* _tmp150_;
				ValaSymbolAccessibility _tmp151_;
				if (vala_parser_accept (self, VALA_TOKEN_TYPE_SET)) {
					writable = TRUE;
					_construct = vala_parser_accept (self, VALA_TOKEN_TYPE_CONSTRUCT);
				} else {
					if (vala_parser_accept (self, VALA_TOKEN_TYPE_CONSTRUCT)) {
						_construct = TRUE;
						writable = vala_parser_accept (self, VALA_TOKEN_TYPE_SET);
					} else {
						GError* _tmp124_;
						_tmp124_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "expected get, set, or construct");
						_inner_error_ = _tmp124_;
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_vala_code_node_unref0 (value_type);
							_vala_iterable_unref0 (accessor_attrs);
							_vala_code_node_unref0 (prop);
							_g_free0 (id);
							_vala_code_node_unref0 (type);
							return;
						} else {
							_vala_code_node_unref0 (value_type);
							_vala_iterable_unref0 (accessor_attrs);
							_vala_code_node_unref0 (prop);
							_g_free0 (id);
							_vala_code_node_unref0 (type);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
				_tmp125_ = prop;
				_tmp126_ = vala_property_get_set_accessor (_tmp125_);
				_tmp127_ = _tmp126_;
				if (_tmp127_ != NULL) {
					GError* _tmp128_;
					_tmp128_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "property set accessor already defined");
					_inner_error_ = _tmp128_;
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (value_type);
						_vala_iterable_unref0 (accessor_attrs);
						_vala_code_node_unref0 (prop);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						return;
					} else {
						_vala_code_node_unref0 (value_type);
						_vala_iterable_unref0 (accessor_attrs);
						_vala_code_node_unref0 (prop);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				block = NULL;
				if (!vala_parser_accept (self, VALA_TOKEN_TYPE_SEMICOLON)) {
					ValaBlock* _tmp129_ = NULL;
					ValaBlock* _tmp130_;
					ValaBlock* _tmp131_;
					ValaProperty* _tmp132_;
					_tmp130_ = vala_parser_parse_block (self, &_inner_error_);
					_tmp129_ = _tmp130_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_vala_code_node_unref0 (block);
							_vala_code_node_unref0 (value_type);
							_vala_iterable_unref0 (accessor_attrs);
							_vala_code_node_unref0 (prop);
							_g_free0 (id);
							_vala_code_node_unref0 (type);
							return;
						} else {
							_vala_code_node_unref0 (block);
							_vala_code_node_unref0 (value_type);
							_vala_iterable_unref0 (accessor_attrs);
							_vala_code_node_unref0 (prop);
							_g_free0 (id);
							_vala_code_node_unref0 (type);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp131_ = _tmp129_;
					_tmp129_ = NULL;
					_vala_code_node_unref0 (block);
					block = _tmp131_;
					_tmp132_ = prop;
					vala_symbol_set_external ((ValaSymbol*) _tmp132_, FALSE);
					_vala_code_node_unref0 (_tmp129_);
				}
				_tmp133_ = prop;
				_tmp134_ = writable;
				_tmp135_ = _construct;
				_tmp136_ = value_type;
				_tmp137_ = block;
				_tmp138_ = accessor_begin;
				_tmp139_ = vala_parser_get_src (self, &_tmp138_);
				_tmp140_ = _tmp139_;
				_tmp141_ = self->priv->comment;
				_tmp142_ = vala_property_accessor_new (FALSE, _tmp134_, _tmp135_, _tmp136_, _tmp137_, _tmp140_, _tmp141_);
				_tmp143_ = _tmp142_;
				vala_property_set_set_accessor (_tmp133_, _tmp143_);
				_vala_code_node_unref0 (_tmp143_);
				_vala_source_reference_unref0 (_tmp140_);
				_tmp144_ = prop;
				_tmp145_ = vala_property_get_set_accessor (_tmp144_);
				_tmp146_ = _tmp145_;
				_tmp147_ = accessor_attrs;
				vala_parser_set_attributes (self, (ValaCodeNode*) _tmp146_, _tmp147_);
				_tmp148_ = prop;
				_tmp149_ = vala_property_get_set_accessor (_tmp148_);
				_tmp150_ = _tmp149_;
				_tmp151_ = accessor_access;
				vala_symbol_set_access ((ValaSymbol*) _tmp150_, _tmp151_);
				_vala_code_node_unref0 (block);
			}
			_vala_code_node_unref0 (value_type);
			_vala_iterable_unref0 (accessor_attrs);
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (prop);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (prop);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp153_ = prop;
	_tmp154_ = vala_property_get_is_abstract (_tmp153_);
	_tmp155_ = _tmp154_;
	if (!_tmp155_) {
		ValaProperty* _tmp156_;
		ValaSourceFileType _tmp157_;
		ValaSourceFileType _tmp158_;
		_tmp156_ = prop;
		_tmp157_ = vala_symbol_get_source_type ((ValaSymbol*) _tmp156_);
		_tmp158_ = _tmp157_;
		_tmp152_ = _tmp158_ == VALA_SOURCE_FILE_TYPE_SOURCE;
	} else {
		_tmp152_ = FALSE;
	}
	if (_tmp152_) {
		gboolean has_get = FALSE;
		ValaProperty* _tmp159_;
		ValaPropertyAccessor* _tmp160_;
		ValaPropertyAccessor* _tmp161_;
		gboolean _tmp162_ = FALSE;
		gboolean _tmp163_;
		gboolean get_has_body = FALSE;
		gboolean has_set = FALSE;
		ValaProperty* _tmp169_;
		ValaPropertyAccessor* _tmp170_;
		ValaPropertyAccessor* _tmp171_;
		gboolean _tmp172_ = FALSE;
		gboolean _tmp173_;
		gboolean set_has_body = FALSE;
		gboolean _tmp179_ = FALSE;
		gboolean _tmp180_;
		gboolean _tmp188_ = FALSE;
		gboolean _tmp189_;
		gboolean _tmp197_ = FALSE;
		gboolean _tmp198_;
		_tmp159_ = prop;
		_tmp160_ = vala_property_get_get_accessor (_tmp159_);
		_tmp161_ = _tmp160_;
		has_get = _tmp161_ != NULL;
		_tmp163_ = has_get;
		if (_tmp163_) {
			ValaProperty* _tmp164_;
			ValaPropertyAccessor* _tmp165_;
			ValaPropertyAccessor* _tmp166_;
			ValaBlock* _tmp167_;
			ValaBlock* _tmp168_;
			_tmp164_ = prop;
			_tmp165_ = vala_property_get_get_accessor (_tmp164_);
			_tmp166_ = _tmp165_;
			_tmp167_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp166_);
			_tmp168_ = _tmp167_;
			_tmp162_ = _tmp168_ != NULL;
		} else {
			_tmp162_ = FALSE;
		}
		get_has_body = _tmp162_;
		_tmp169_ = prop;
		_tmp170_ = vala_property_get_set_accessor (_tmp169_);
		_tmp171_ = _tmp170_;
		has_set = _tmp171_ != NULL;
		_tmp173_ = has_set;
		if (_tmp173_) {
			ValaProperty* _tmp174_;
			ValaPropertyAccessor* _tmp175_;
			ValaPropertyAccessor* _tmp176_;
			ValaBlock* _tmp177_;
			ValaBlock* _tmp178_;
			_tmp174_ = prop;
			_tmp175_ = vala_property_get_set_accessor (_tmp174_);
			_tmp176_ = _tmp175_;
			_tmp177_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp176_);
			_tmp178_ = _tmp177_;
			_tmp172_ = _tmp178_ != NULL;
		} else {
			_tmp172_ = FALSE;
		}
		set_has_body = _tmp172_;
		_tmp180_ = set_has_body;
		if (_tmp180_) {
			gboolean _tmp181_ = FALSE;
			gboolean _tmp182_;
			_tmp182_ = has_get;
			if (_tmp182_) {
				gboolean _tmp183_;
				_tmp183_ = get_has_body;
				_tmp181_ = !_tmp183_;
			} else {
				_tmp181_ = FALSE;
			}
			_tmp179_ = _tmp181_;
		} else {
			_tmp179_ = FALSE;
		}
		if (_tmp179_) {
			ValaProperty* _tmp184_;
			ValaProperty* _tmp185_;
			ValaSourceReference* _tmp186_;
			ValaSourceReference* _tmp187_;
			_tmp184_ = prop;
			vala_code_node_set_error ((ValaCodeNode*) _tmp184_, TRUE);
			_tmp185_ = prop;
			_tmp186_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp185_);
			_tmp187_ = _tmp186_;
			vala_report_error (_tmp187_, "Property getter must have a body");
		}
		_tmp189_ = get_has_body;
		if (_tmp189_) {
			gboolean _tmp190_ = FALSE;
			gboolean _tmp191_;
			_tmp191_ = has_set;
			if (_tmp191_) {
				gboolean _tmp192_;
				_tmp192_ = set_has_body;
				_tmp190_ = !_tmp192_;
			} else {
				_tmp190_ = FALSE;
			}
			_tmp188_ = _tmp190_;
		} else {
			_tmp188_ = FALSE;
		}
		if (_tmp188_) {
			ValaProperty* _tmp193_;
			ValaProperty* _tmp194_;
			ValaSourceReference* _tmp195_;
			ValaSourceReference* _tmp196_;
			_tmp193_ = prop;
			vala_code_node_set_error ((ValaCodeNode*) _tmp193_, TRUE);
			_tmp194_ = prop;
			_tmp195_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp194_);
			_tmp196_ = _tmp195_;
			vala_report_error (_tmp196_, "Property setter must have a body");
		}
		_tmp198_ = get_has_body;
		if (!_tmp198_) {
			gboolean _tmp199_;
			_tmp199_ = set_has_body;
			_tmp197_ = !_tmp199_;
		} else {
			_tmp197_ = FALSE;
		}
		if (_tmp197_) {
			ValaDataType* variable_type = NULL;
			ValaProperty* _tmp200_;
			ValaDataType* _tmp201_;
			ValaDataType* _tmp202_;
			ValaDataType* _tmp203_;
			ValaProperty* _tmp204_;
			ValaProperty* _tmp205_;
			const gchar* _tmp206_;
			const gchar* _tmp207_;
			gchar* _tmp208_;
			gchar* _tmp209_;
			ValaDataType* _tmp210_;
			ValaProperty* _tmp211_;
			ValaExpression* _tmp212_;
			ValaExpression* _tmp213_;
			ValaProperty* _tmp214_;
			ValaSourceReference* _tmp215_;
			ValaSourceReference* _tmp216_;
			ValaField* _tmp217_;
			ValaField* _tmp218_;
			ValaProperty* _tmp219_;
			ValaField* _tmp220_;
			ValaField* _tmp221_;
			ValaProperty* _tmp222_;
			ValaField* _tmp223_;
			ValaField* _tmp224_;
			ValaProperty* _tmp225_;
			ValaMemberBinding _tmp226_;
			ValaMemberBinding _tmp227_;
			_tmp200_ = prop;
			_tmp201_ = vala_property_get_property_type (_tmp200_);
			_tmp202_ = _tmp201_;
			_tmp203_ = vala_data_type_copy (_tmp202_);
			variable_type = _tmp203_;
			_tmp204_ = prop;
			_tmp205_ = prop;
			_tmp206_ = vala_symbol_get_name ((ValaSymbol*) _tmp205_);
			_tmp207_ = _tmp206_;
			_tmp208_ = g_strdup_printf ("_%s", _tmp207_);
			_tmp209_ = _tmp208_;
			_tmp210_ = variable_type;
			_tmp211_ = prop;
			_tmp212_ = vala_property_get_initializer (_tmp211_);
			_tmp213_ = _tmp212_;
			_tmp214_ = prop;
			_tmp215_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp214_);
			_tmp216_ = _tmp215_;
			_tmp217_ = vala_field_new (_tmp209_, _tmp210_, _tmp213_, _tmp216_, NULL);
			_tmp218_ = _tmp217_;
			vala_property_set_field (_tmp204_, _tmp218_);
			_vala_code_node_unref0 (_tmp218_);
			_g_free0 (_tmp209_);
			_tmp219_ = prop;
			_tmp220_ = vala_property_get_field (_tmp219_);
			_tmp221_ = _tmp220_;
			vala_symbol_set_access ((ValaSymbol*) _tmp221_, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
			_tmp222_ = prop;
			_tmp223_ = vala_property_get_field (_tmp222_);
			_tmp224_ = _tmp223_;
			_tmp225_ = prop;
			_tmp226_ = vala_property_get_binding (_tmp225_);
			_tmp227_ = _tmp226_;
			vala_field_set_binding (_tmp224_, _tmp227_);
			_vala_code_node_unref0 (variable_type);
		}
	}
	_tmp228_ = prop;
	vala_symbol_add_property (parent, _tmp228_);
	_vala_code_node_unref0 (prop);
	_g_free0 (id);
	_vala_code_node_unref0 (type);
}


static void
vala_parser_parse_signal_declaration (ValaParser* self,
                                      ValaSymbol* parent,
                                      ValaList* attrs,
                                      GError** error)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSymbolAccessibility access = 0;
	ValaParserModifierFlags flags = 0;
	ValaDataType* type = NULL;
	ValaDataType* _tmp1_;
	gchar* id = NULL;
	gchar* _tmp2_;
	ValaSignal* sig = NULL;
	const gchar* _tmp3_;
	ValaDataType* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaComment* _tmp8_;
	ValaSignal* _tmp9_;
	ValaSignal* _tmp10_;
	ValaSignal* _tmp11_;
	ValaSymbolAccessibility _tmp12_;
	ValaSignal* _tmp13_;
	ValaParserModifierFlags _tmp14_;
	ValaParserModifierFlags _tmp18_;
	ValaParserModifierFlags _tmp20_;
	ValaSignal* _tmp29_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	access = vala_parser_parse_access_modifier (self, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	flags = vala_parser_parse_member_declaration_modifiers (self);
	vala_parser_expect (self, VALA_TOKEN_TYPE_SIGNAL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = vala_parser_parse_type (self, TRUE, FALSE, FALSE, &_inner_error_);
	type = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = vala_parser_parse_identifier (self, &_inner_error_);
	id = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = id;
	_tmp4_ = type;
	_tmp5_ = begin;
	_tmp6_ = vala_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->comment;
	_tmp9_ = vala_signal_new (_tmp3_, _tmp4_, _tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	_vala_source_reference_unref0 (_tmp7_);
	sig = _tmp10_;
	_tmp11_ = sig;
	_tmp12_ = access;
	vala_symbol_set_access ((ValaSymbol*) _tmp11_, _tmp12_);
	_tmp13_ = sig;
	vala_parser_set_attributes (self, (ValaCodeNode*) _tmp13_, attrs);
	_tmp14_ = flags;
	if ((_tmp14_ & VALA_PARSER_MODIFIER_FLAGS_STATIC) == VALA_PARSER_MODIFIER_FLAGS_STATIC) {
		GError* _tmp15_;
		_tmp15_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "`static' modifier not allowed on signals");
		_inner_error_ = _tmp15_;
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (sig);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (sig);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		ValaParserModifierFlags _tmp16_;
		_tmp16_ = flags;
		if ((_tmp16_ & VALA_PARSER_MODIFIER_FLAGS_CLASS) == VALA_PARSER_MODIFIER_FLAGS_CLASS) {
			GError* _tmp17_;
			_tmp17_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "`class' modifier not allowed on signals");
			_inner_error_ = _tmp17_;
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (sig);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				return;
			} else {
				_vala_code_node_unref0 (sig);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tmp18_ = flags;
	if ((_tmp18_ & VALA_PARSER_MODIFIER_FLAGS_VIRTUAL) == VALA_PARSER_MODIFIER_FLAGS_VIRTUAL) {
		ValaSignal* _tmp19_;
		_tmp19_ = sig;
		vala_signal_set_is_virtual (_tmp19_, TRUE);
	}
	_tmp20_ = flags;
	if ((_tmp20_ & VALA_PARSER_MODIFIER_FLAGS_NEW) == VALA_PARSER_MODIFIER_FLAGS_NEW) {
		ValaSignal* _tmp21_;
		_tmp21_ = sig;
		vala_symbol_set_hides ((ValaSymbol*) _tmp21_, TRUE);
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (sig);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (sig);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_PARENS) {
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaParameter* _tmp23_;
				ValaSignal* _tmp24_;
				ValaParameter* _tmp25_;
				if (!_tmp22_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp22_ = FALSE;
				_tmp23_ = vala_parser_parse_parameter (self, &_inner_error_);
				param = _tmp23_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (sig);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						return;
					} else {
						_vala_code_node_unref0 (sig);
						_g_free0 (id);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp24_ = sig;
				_tmp25_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp24_, _tmp25_);
				_vala_code_node_unref0 (param);
			}
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (sig);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (sig);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (!vala_parser_accept (self, VALA_TOKEN_TYPE_SEMICOLON)) {
		ValaBlock* _tmp26_ = NULL;
		ValaBlock* _tmp27_;
		ValaSignal* _tmp28_;
		_tmp27_ = vala_parser_parse_block (self, &_inner_error_);
		_tmp26_ = _tmp27_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (sig);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				return;
			} else {
				_vala_code_node_unref0 (sig);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp28_ = sig;
		vala_signal_set_body (_tmp28_, _tmp26_);
		_vala_code_node_unref0 (_tmp26_);
	}
	_tmp29_ = sig;
	vala_symbol_add_signal (parent, _tmp29_);
	_vala_code_node_unref0 (sig);
	_g_free0 (id);
	_vala_code_node_unref0 (type);
}


static void
vala_parser_parse_constructor_declaration (ValaParser* self,
                                           ValaSymbol* parent,
                                           ValaList* attrs,
                                           GError** error)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaParserModifierFlags flags = 0;
	ValaParserModifierFlags _tmp1_;
	ValaConstructor* c = NULL;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaConstructor* _tmp6_;
	ValaConstructor* _tmp7_;
	gboolean _tmp8_ = FALSE;
	ValaParserModifierFlags _tmp9_;
	ValaBlock* _tmp18_ = NULL;
	ValaBlock* _tmp19_;
	ValaConstructor* _tmp20_;
	ValaConstructor* _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	flags = vala_parser_parse_member_declaration_modifiers (self);
	vala_parser_expect (self, VALA_TOKEN_TYPE_CONSTRUCT, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = flags;
	if ((_tmp1_ & VALA_PARSER_MODIFIER_FLAGS_NEW) == VALA_PARSER_MODIFIER_FLAGS_NEW) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "`new' modifier not allowed on constructor");
		_inner_error_ = _tmp2_;
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = begin;
	_tmp4_ = vala_parser_get_src (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_constructor_new (_tmp5_);
	_tmp7_ = _tmp6_;
	_vala_source_reference_unref0 (_tmp5_);
	c = _tmp7_;
	_tmp9_ = flags;
	if ((_tmp9_ & VALA_PARSER_MODIFIER_FLAGS_STATIC) == VALA_PARSER_MODIFIER_FLAGS_STATIC) {
		ValaParserModifierFlags _tmp10_;
		_tmp10_ = flags;
		_tmp8_ = (_tmp10_ & VALA_PARSER_MODIFIER_FLAGS_CLASS) == VALA_PARSER_MODIFIER_FLAGS_CLASS;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaConstructor* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSourceReference* _tmp13_;
		_tmp11_ = c;
		_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp11_);
		_tmp13_ = _tmp12_;
		vala_report_error (_tmp13_, "only one of `static' or `class' may be specified");
	} else {
		ValaParserModifierFlags _tmp14_;
		_tmp14_ = flags;
		if ((_tmp14_ & VALA_PARSER_MODIFIER_FLAGS_STATIC) == VALA_PARSER_MODIFIER_FLAGS_STATIC) {
			ValaConstructor* _tmp15_;
			_tmp15_ = c;
			vala_constructor_set_binding (_tmp15_, VALA_MEMBER_BINDING_STATIC);
		} else {
			ValaParserModifierFlags _tmp16_;
			_tmp16_ = flags;
			if ((_tmp16_ & VALA_PARSER_MODIFIER_FLAGS_CLASS) == VALA_PARSER_MODIFIER_FLAGS_CLASS) {
				ValaConstructor* _tmp17_;
				_tmp17_ = c;
				vala_constructor_set_binding (_tmp17_, VALA_MEMBER_BINDING_CLASS);
			}
		}
	}
	_tmp19_ = vala_parser_parse_block (self, &_inner_error_);
	_tmp18_ = _tmp19_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (c);
			return;
		} else {
			_vala_code_node_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp20_ = c;
	vala_subroutine_set_body ((ValaSubroutine*) _tmp20_, _tmp18_);
	_tmp21_ = c;
	vala_symbol_add_constructor (parent, _tmp21_);
	_vala_code_node_unref0 (_tmp18_);
	_vala_code_node_unref0 (c);
}


static void
vala_parser_parse_destructor_declaration (ValaParser* self,
                                          ValaSymbol* parent,
                                          ValaList* attrs,
                                          GError** error)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaParserModifierFlags flags = 0;
	gchar* identifier = NULL;
	gchar* _tmp1_;
	ValaParserModifierFlags _tmp2_;
	ValaDestructor* d = NULL;
	ValaSourceLocation _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaDestructor* _tmp7_;
	ValaDestructor* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp15_ = FALSE;
	ValaParserModifierFlags _tmp16_;
	ValaBlock* _tmp25_ = NULL;
	ValaBlock* _tmp26_;
	ValaDestructor* _tmp27_;
	ValaDestructor* _tmp28_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	flags = vala_parser_parse_member_declaration_modifiers (self);
	vala_parser_expect (self, VALA_TOKEN_TYPE_TILDE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = vala_parser_parse_identifier (self, &_inner_error_);
	identifier = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (identifier);
			return;
		} else {
			_g_free0 (identifier);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (identifier);
			return;
		} else {
			_g_free0 (identifier);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = flags;
	if ((_tmp2_ & VALA_PARSER_MODIFIER_FLAGS_NEW) == VALA_PARSER_MODIFIER_FLAGS_NEW) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "`new' modifier not allowed on destructor");
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (identifier);
			return;
		} else {
			_g_free0 (identifier);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = begin;
	_tmp5_ = vala_parser_get_src (self, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_destructor_new (_tmp6_);
	_tmp8_ = _tmp7_;
	_vala_source_reference_unref0 (_tmp6_);
	d = _tmp8_;
	_tmp9_ = identifier;
	_tmp10_ = vala_symbol_get_name (parent);
	_tmp11_ = _tmp10_;
	if (g_strcmp0 (_tmp9_, _tmp11_) != 0) {
		ValaDestructor* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		_tmp12_ = d;
		_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp12_);
		_tmp14_ = _tmp13_;
		vala_report_error (_tmp14_, "destructor and parent symbol name do not match");
	}
	_tmp16_ = flags;
	if ((_tmp16_ & VALA_PARSER_MODIFIER_FLAGS_STATIC) == VALA_PARSER_MODIFIER_FLAGS_STATIC) {
		ValaParserModifierFlags _tmp17_;
		_tmp17_ = flags;
		_tmp15_ = (_tmp17_ & VALA_PARSER_MODIFIER_FLAGS_CLASS) == VALA_PARSER_MODIFIER_FLAGS_CLASS;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		ValaDestructor* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		_tmp18_ = d;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp18_);
		_tmp20_ = _tmp19_;
		vala_report_error (_tmp20_, "only one of `static' or `class' may be specified");
	} else {
		ValaParserModifierFlags _tmp21_;
		_tmp21_ = flags;
		if ((_tmp21_ & VALA_PARSER_MODIFIER_FLAGS_STATIC) == VALA_PARSER_MODIFIER_FLAGS_STATIC) {
			ValaDestructor* _tmp22_;
			_tmp22_ = d;
			vala_destructor_set_binding (_tmp22_, VALA_MEMBER_BINDING_STATIC);
		} else {
			ValaParserModifierFlags _tmp23_;
			_tmp23_ = flags;
			if ((_tmp23_ & VALA_PARSER_MODIFIER_FLAGS_CLASS) == VALA_PARSER_MODIFIER_FLAGS_CLASS) {
				ValaDestructor* _tmp24_;
				_tmp24_ = d;
				vala_destructor_set_binding (_tmp24_, VALA_MEMBER_BINDING_CLASS);
			}
		}
	}
	_tmp26_ = vala_parser_parse_block (self, &_inner_error_);
	_tmp25_ = _tmp26_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (d);
			_g_free0 (identifier);
			return;
		} else {
			_vala_code_node_unref0 (d);
			_g_free0 (identifier);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp27_ = d;
	vala_subroutine_set_body ((ValaSubroutine*) _tmp27_, _tmp25_);
	_tmp28_ = d;
	vala_symbol_add_destructor (parent, _tmp28_);
	_vala_code_node_unref0 (_tmp25_);
	_vala_code_node_unref0 (d);
	_g_free0 (identifier);
}


static void
vala_parser_parse_struct_declaration (ValaParser* self,
                                      ValaSymbol* parent,
                                      ValaList* attrs,
                                      GError** error)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSymbolAccessibility access = 0;
	ValaParserModifierFlags flags = 0;
	ValaUnresolvedSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp1_;
	ValaList* type_param_list = NULL;
	ValaList* _tmp2_;
	ValaDataType* base_type = NULL;
	ValaStruct* st = NULL;
	ValaUnresolvedSymbol* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	ValaSourceLocation _tmp9_;
	ValaSourceReference* _tmp10_;
	ValaSourceReference* _tmp11_;
	ValaComment* _tmp12_;
	ValaStruct* _tmp13_;
	ValaStruct* _tmp14_;
	ValaStruct* _tmp15_;
	ValaSymbolAccessibility _tmp16_;
	gboolean _tmp17_ = FALSE;
	ValaParserModifierFlags _tmp18_;
	ValaStruct* _tmp25_;
	ValaDataType* _tmp39_;
	ValaStruct* _tmp42_;
	ValaSymbol* _result_ = NULL;
	ValaStruct* _tmp43_;
	ValaSymbol* _tmp44_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	access = vala_parser_parse_access_modifier (self, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	flags = vala_parser_parse_type_declaration_modifiers (self);
	vala_parser_expect (self, VALA_TOKEN_TYPE_STRUCT, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = vala_parser_parse_symbol_name (self, &_inner_error_);
	sym = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = vala_parser_parse_type_parameter_list (self, &_inner_error_);
	type_param_list = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	base_type = NULL;
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_COLON)) {
		ValaDataType* _tmp3_ = NULL;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		_tmp4_ = vala_parser_parse_type (self, TRUE, FALSE, FALSE, &_inner_error_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				return;
			} else {
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (type_param_list);
				_vala_code_node_unref0 (sym);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_vala_code_node_unref0 (base_type);
		base_type = _tmp5_;
		_vala_code_node_unref0 (_tmp3_);
	}
	_tmp6_ = sym;
	_tmp7_ = vala_symbol_get_name ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = begin;
	_tmp10_ = vala_parser_get_src (self, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->comment;
	_tmp13_ = vala_struct_new (_tmp8_, _tmp11_, _tmp12_);
	_tmp14_ = _tmp13_;
	_vala_source_reference_unref0 (_tmp11_);
	st = _tmp14_;
	_tmp15_ = st;
	_tmp16_ = access;
	vala_symbol_set_access ((ValaSymbol*) _tmp15_, _tmp16_);
	_tmp18_ = flags;
	if ((_tmp18_ & VALA_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp17_ = TRUE;
	} else {
		ValaScanner* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		ValaSourceFileType _tmp22_;
		ValaSourceFileType _tmp23_;
		_tmp19_ = self->priv->scanner;
		_tmp20_ = vala_scanner_get_source_file (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_source_file_get_file_type (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp17_ = _tmp23_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	}
	if (_tmp17_) {
		ValaStruct* _tmp24_;
		_tmp24_ = st;
		vala_symbol_set_external ((ValaSymbol*) _tmp24_, TRUE);
	}
	_tmp25_ = st;
	vala_parser_set_attributes (self, (ValaCodeNode*) _tmp25_, attrs);
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp26_;
		ValaList* _tmp27_;
		gint _type_param_size = 0;
		ValaList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gint _type_param_index = 0;
		_tmp26_ = type_param_list;
		_tmp27_ = _vala_iterable_ref0 (_tmp26_);
		_type_param_list = _tmp27_;
		_tmp28_ = _type_param_list;
		_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_type_param_size = _tmp30_;
		_type_param_index = -1;
		while (TRUE) {
			gint _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp34_;
			gint _tmp35_;
			gpointer _tmp36_;
			ValaStruct* _tmp37_;
			ValaTypeParameter* _tmp38_;
			_tmp31_ = _type_param_index;
			_type_param_index = _tmp31_ + 1;
			_tmp32_ = _type_param_index;
			_tmp33_ = _type_param_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = _type_param_list;
			_tmp35_ = _type_param_index;
			_tmp36_ = vala_list_get (_tmp34_, _tmp35_);
			type_param = (ValaTypeParameter*) _tmp36_;
			_tmp37_ = st;
			_tmp38_ = type_param;
			vala_struct_add_type_parameter (_tmp37_, _tmp38_);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	_tmp39_ = base_type;
	if (_tmp39_ != NULL) {
		ValaStruct* _tmp40_;
		ValaDataType* _tmp41_;
		_tmp40_ = st;
		_tmp41_ = base_type;
		vala_struct_set_base_type (_tmp40_, _tmp41_);
	}
	_tmp42_ = st;
	vala_parser_parse_declarations (self, (ValaSymbol*) _tmp42_, FALSE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (base_type);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (base_type);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp43_ = st;
	_tmp44_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp43_);
	_result_ = _tmp44_;
	while (TRUE) {
		ValaUnresolvedSymbol* _tmp45_;
		ValaUnresolvedSymbol* _tmp46_;
		ValaUnresolvedSymbol* _tmp47_;
		ValaUnresolvedSymbol* _tmp48_;
		ValaUnresolvedSymbol* _tmp49_;
		ValaSymbol* _tmp50_ = NULL;
		ValaUnresolvedSymbol* _tmp51_;
		ValaSymbol* next = NULL;
		ValaSymbol* _tmp60_;
		ValaSymbol* _tmp61_;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp45_ = sym;
		if (!(_tmp45_ != NULL)) {
			break;
		}
		_tmp46_ = sym;
		_tmp47_ = vala_unresolved_symbol_get_inner (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = _vala_code_node_ref0 (_tmp48_);
		_vala_code_node_unref0 (sym);
		sym = _tmp49_;
		_tmp51_ = sym;
		if (_tmp51_ != NULL) {
			ValaUnresolvedSymbol* _tmp52_;
			const gchar* _tmp53_;
			const gchar* _tmp54_;
			ValaStruct* _tmp55_;
			ValaSourceReference* _tmp56_;
			ValaSourceReference* _tmp57_;
			ValaNamespace* _tmp58_;
			_tmp52_ = sym;
			_tmp53_ = vala_symbol_get_name ((ValaSymbol*) _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = st;
			_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_namespace_new (_tmp54_, _tmp57_);
			_vala_code_node_unref0 (_tmp50_);
			_tmp50_ = (ValaSymbol*) _tmp58_;
		} else {
			ValaSymbol* _tmp59_;
			_tmp59_ = _vala_code_node_ref0 (parent);
			_vala_code_node_unref0 (_tmp50_);
			_tmp50_ = _tmp59_;
		}
		_tmp60_ = _vala_code_node_ref0 (_tmp50_);
		next = _tmp60_;
		_tmp61_ = _result_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp61_, VALA_TYPE_NAMESPACE)) {
			ValaSymbol* _tmp62_;
			ValaSymbol* _tmp63_;
			_tmp62_ = next;
			_tmp63_ = _result_;
			vala_symbol_add_namespace (_tmp62_, G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_NAMESPACE, ValaNamespace));
		} else {
			ValaSymbol* _tmp64_;
			ValaSymbol* _tmp65_;
			_tmp64_ = next;
			_tmp65_ = _result_;
			vala_symbol_add_struct (_tmp64_, G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_STRUCT, ValaStruct));
		}
		_tmp66_ = next;
		_tmp67_ = _vala_code_node_ref0 (_tmp66_);
		_vala_code_node_unref0 (_result_);
		_result_ = _tmp67_;
		_vala_code_node_unref0 (next);
		_vala_code_node_unref0 (_tmp50_);
	}
	_vala_code_node_unref0 (_result_);
	_vala_code_node_unref0 (st);
	_vala_code_node_unref0 (base_type);
	_vala_iterable_unref0 (type_param_list);
	_vala_code_node_unref0 (sym);
}


static void
vala_parser_parse_interface_declaration (ValaParser* self,
                                         ValaSymbol* parent,
                                         ValaList* attrs,
                                         GError** error)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSymbolAccessibility access = 0;
	ValaParserModifierFlags flags = 0;
	ValaUnresolvedSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp1_;
	ValaList* type_param_list = NULL;
	ValaList* _tmp2_;
	ValaArrayList* base_types = NULL;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	ValaInterface* iface = NULL;
	ValaUnresolvedSymbol* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ValaSourceLocation _tmp12_;
	ValaSourceReference* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaComment* _tmp15_;
	ValaInterface* _tmp16_;
	ValaInterface* _tmp17_;
	ValaInterface* _tmp18_;
	ValaSymbolAccessibility _tmp19_;
	gboolean _tmp20_ = FALSE;
	ValaParserModifierFlags _tmp21_;
	ValaInterface* _tmp28_;
	ValaInterface* _tmp55_;
	ValaSymbol* _result_ = NULL;
	ValaInterface* _tmp56_;
	ValaSymbol* _tmp57_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	access = vala_parser_parse_access_modifier (self, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	flags = vala_parser_parse_type_declaration_modifiers (self);
	vala_parser_expect (self, VALA_TOKEN_TYPE_INTERFACE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = vala_parser_parse_symbol_name (self, &_inner_error_);
	sym = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = vala_parser_parse_type_parameter_list (self, &_inner_error_);
	type_param_list = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
	base_types = _tmp4_;
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_COLON)) {
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				ValaDataType* type = NULL;
				ValaDataType* _tmp6_;
				ValaArrayList* _tmp7_;
				ValaDataType* _tmp8_;
				if (!_tmp5_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp5_ = FALSE;
				_tmp6_ = vala_parser_parse_type (self, TRUE, FALSE, FALSE, &_inner_error_);
				type = _tmp6_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_iterable_unref0 (base_types);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						return;
					} else {
						_vala_iterable_unref0 (base_types);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp7_ = base_types;
				_tmp8_ = type;
				vala_collection_add ((ValaCollection*) _tmp7_, _tmp8_);
				_vala_code_node_unref0 (type);
			}
		}
	}
	_tmp9_ = sym;
	_tmp10_ = vala_symbol_get_name ((ValaSymbol*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = begin;
	_tmp13_ = vala_parser_get_src (self, &_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->comment;
	_tmp16_ = vala_interface_new (_tmp11_, _tmp14_, _tmp15_);
	_tmp17_ = _tmp16_;
	_vala_source_reference_unref0 (_tmp14_);
	iface = _tmp17_;
	_tmp18_ = iface;
	_tmp19_ = access;
	vala_symbol_set_access ((ValaSymbol*) _tmp18_, _tmp19_);
	_tmp21_ = flags;
	if ((_tmp21_ & VALA_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp20_ = TRUE;
	} else {
		ValaScanner* _tmp22_;
		ValaSourceFile* _tmp23_;
		ValaSourceFile* _tmp24_;
		ValaSourceFileType _tmp25_;
		ValaSourceFileType _tmp26_;
		_tmp22_ = self->priv->scanner;
		_tmp23_ = vala_scanner_get_source_file (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_source_file_get_file_type (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp20_ = _tmp26_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	}
	if (_tmp20_) {
		ValaInterface* _tmp27_;
		_tmp27_ = iface;
		vala_symbol_set_external ((ValaSymbol*) _tmp27_, TRUE);
	}
	_tmp28_ = iface;
	vala_parser_set_attributes (self, (ValaCodeNode*) _tmp28_, attrs);
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp29_;
		ValaList* _tmp30_;
		gint _type_param_size = 0;
		ValaList* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint _type_param_index = 0;
		_tmp29_ = type_param_list;
		_tmp30_ = _vala_iterable_ref0 (_tmp29_);
		_type_param_list = _tmp30_;
		_tmp31_ = _type_param_list;
		_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
		_tmp33_ = _tmp32_;
		_type_param_size = _tmp33_;
		_type_param_index = -1;
		while (TRUE) {
			gint _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp37_;
			gint _tmp38_;
			gpointer _tmp39_;
			ValaInterface* _tmp40_;
			ValaTypeParameter* _tmp41_;
			_tmp34_ = _type_param_index;
			_type_param_index = _tmp34_ + 1;
			_tmp35_ = _type_param_index;
			_tmp36_ = _type_param_size;
			if (!(_tmp35_ < _tmp36_)) {
				break;
			}
			_tmp37_ = _type_param_list;
			_tmp38_ = _type_param_index;
			_tmp39_ = vala_list_get (_tmp37_, _tmp38_);
			type_param = (ValaTypeParameter*) _tmp39_;
			_tmp40_ = iface;
			_tmp41_ = type_param;
			vala_object_type_symbol_add_type_parameter ((ValaObjectTypeSymbol*) _tmp40_, _tmp41_);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	{
		ValaArrayList* _base_type_list = NULL;
		ValaArrayList* _tmp42_;
		ValaArrayList* _tmp43_;
		gint _base_type_size = 0;
		ValaArrayList* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		gint _base_type_index = 0;
		_tmp42_ = base_types;
		_tmp43_ = _vala_iterable_ref0 (_tmp42_);
		_base_type_list = _tmp43_;
		_tmp44_ = _base_type_list;
		_tmp45_ = vala_collection_get_size ((ValaCollection*) _tmp44_);
		_tmp46_ = _tmp45_;
		_base_type_size = _tmp46_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp47_;
			gint _tmp48_;
			gint _tmp49_;
			ValaDataType* base_type = NULL;
			ValaArrayList* _tmp50_;
			gint _tmp51_;
			gpointer _tmp52_;
			ValaInterface* _tmp53_;
			ValaDataType* _tmp54_;
			_tmp47_ = _base_type_index;
			_base_type_index = _tmp47_ + 1;
			_tmp48_ = _base_type_index;
			_tmp49_ = _base_type_size;
			if (!(_tmp48_ < _tmp49_)) {
				break;
			}
			_tmp50_ = _base_type_list;
			_tmp51_ = _base_type_index;
			_tmp52_ = vala_list_get ((ValaList*) _tmp50_, _tmp51_);
			base_type = (ValaDataType*) _tmp52_;
			_tmp53_ = iface;
			_tmp54_ = base_type;
			vala_interface_add_prerequisite (_tmp53_, _tmp54_);
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp55_ = iface;
	vala_parser_parse_declarations (self, (ValaSymbol*) _tmp55_, FALSE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (iface);
			_vala_iterable_unref0 (base_types);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_code_node_unref0 (iface);
			_vala_iterable_unref0 (base_types);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp56_ = iface;
	_tmp57_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp56_);
	_result_ = _tmp57_;
	while (TRUE) {
		ValaUnresolvedSymbol* _tmp58_;
		ValaUnresolvedSymbol* _tmp59_;
		ValaUnresolvedSymbol* _tmp60_;
		ValaUnresolvedSymbol* _tmp61_;
		ValaUnresolvedSymbol* _tmp62_;
		ValaSymbol* _tmp63_ = NULL;
		ValaUnresolvedSymbol* _tmp64_;
		ValaSymbol* next = NULL;
		ValaSymbol* _tmp73_;
		ValaSymbol* _tmp74_;
		ValaSymbol* _tmp79_;
		ValaSymbol* _tmp80_;
		_tmp58_ = sym;
		if (!(_tmp58_ != NULL)) {
			break;
		}
		_tmp59_ = sym;
		_tmp60_ = vala_unresolved_symbol_get_inner (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = _vala_code_node_ref0 (_tmp61_);
		_vala_code_node_unref0 (sym);
		sym = _tmp62_;
		_tmp64_ = sym;
		if (_tmp64_ != NULL) {
			ValaUnresolvedSymbol* _tmp65_;
			const gchar* _tmp66_;
			const gchar* _tmp67_;
			ValaInterface* _tmp68_;
			ValaSourceReference* _tmp69_;
			ValaSourceReference* _tmp70_;
			ValaNamespace* _tmp71_;
			_tmp65_ = sym;
			_tmp66_ = vala_symbol_get_name ((ValaSymbol*) _tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = iface;
			_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = vala_namespace_new (_tmp67_, _tmp70_);
			_vala_code_node_unref0 (_tmp63_);
			_tmp63_ = (ValaSymbol*) _tmp71_;
		} else {
			ValaSymbol* _tmp72_;
			_tmp72_ = _vala_code_node_ref0 (parent);
			_vala_code_node_unref0 (_tmp63_);
			_tmp63_ = _tmp72_;
		}
		_tmp73_ = _vala_code_node_ref0 (_tmp63_);
		next = _tmp73_;
		_tmp74_ = _result_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp74_, VALA_TYPE_NAMESPACE)) {
			ValaSymbol* _tmp75_;
			ValaSymbol* _tmp76_;
			_tmp75_ = next;
			_tmp76_ = _result_;
			vala_symbol_add_namespace (_tmp75_, G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALA_TYPE_NAMESPACE, ValaNamespace));
		} else {
			ValaSymbol* _tmp77_;
			ValaSymbol* _tmp78_;
			_tmp77_ = next;
			_tmp78_ = _result_;
			vala_symbol_add_interface (_tmp77_, G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_INTERFACE, ValaInterface));
		}
		_tmp79_ = next;
		_tmp80_ = _vala_code_node_ref0 (_tmp79_);
		_vala_code_node_unref0 (_result_);
		_result_ = _tmp80_;
		_vala_code_node_unref0 (next);
		_vala_code_node_unref0 (_tmp63_);
	}
	_vala_code_node_unref0 (_result_);
	_vala_code_node_unref0 (iface);
	_vala_iterable_unref0 (base_types);
	_vala_iterable_unref0 (type_param_list);
	_vala_code_node_unref0 (sym);
}


static void
vala_parser_parse_enum_declaration (ValaParser* self,
                                    ValaSymbol* parent,
                                    ValaList* attrs,
                                    GError** error)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSymbolAccessibility access = 0;
	ValaParserModifierFlags flags = 0;
	ValaUnresolvedSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp1_;
	ValaEnum* en = NULL;
	ValaUnresolvedSymbol* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaComment* _tmp8_;
	ValaEnum* _tmp9_;
	ValaEnum* _tmp10_;
	ValaEnum* _tmp11_;
	ValaSymbolAccessibility _tmp12_;
	gboolean _tmp13_ = FALSE;
	ValaParserModifierFlags _tmp14_;
	ValaEnum* _tmp21_;
	ValaSourceLocation inner_begin = {0};
	ValaSourceLocation _tmp22_ = {0};
	ValaSymbol* _result_ = NULL;
	ValaEnum* _tmp48_;
	ValaSymbol* _tmp49_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	access = vala_parser_parse_access_modifier (self, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	flags = vala_parser_parse_type_declaration_modifiers (self);
	vala_parser_expect (self, VALA_TOKEN_TYPE_ENUM, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = vala_parser_parse_symbol_name (self, &_inner_error_);
	sym = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = sym;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = begin;
	_tmp6_ = vala_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->comment;
	_tmp9_ = vala_enum_new (_tmp4_, _tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	_vala_source_reference_unref0 (_tmp7_);
	en = _tmp10_;
	_tmp11_ = en;
	_tmp12_ = access;
	vala_symbol_set_access ((ValaSymbol*) _tmp11_, _tmp12_);
	_tmp14_ = flags;
	if ((_tmp14_ & VALA_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp13_ = TRUE;
	} else {
		ValaScanner* _tmp15_;
		ValaSourceFile* _tmp16_;
		ValaSourceFile* _tmp17_;
		ValaSourceFileType _tmp18_;
		ValaSourceFileType _tmp19_;
		_tmp15_ = self->priv->scanner;
		_tmp16_ = vala_scanner_get_source_file (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_source_file_get_file_type (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp13_ = _tmp19_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	}
	if (_tmp13_) {
		ValaEnum* _tmp20_;
		_tmp20_ = en;
		vala_symbol_set_external ((ValaSymbol*) _tmp20_, TRUE);
	}
	_tmp21_ = en;
	vala_parser_set_attributes (self, (ValaCodeNode*) _tmp21_, attrs);
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (en);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_code_node_unref0 (en);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	vala_parser_get_location (self, &_tmp22_);
	inner_begin = _tmp22_;
	{
		while (TRUE) {
			ValaEnum* _tmp23_;
			if (!(vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_BRACE)) {
				break;
			}
			_tmp23_ = en;
			vala_parser_parse_declaration (self, (ValaSymbol*) _tmp23_, FALSE, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					goto __catch17_vala_parse_error;
				}
				_vala_code_node_unref0 (en);
				_vala_code_node_unref0 (sym);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	goto __finally17;
	__catch17_vala_parse_error:
	{
		GError* e = NULL;
		ValaSourceLocation _tmp24_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = inner_begin;
		vala_parser_rollback (self, &_tmp24_);
		_g_error_free0 (e);
	}
	__finally17:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (en);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_code_node_unref0 (en);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		gboolean _tmp25_ = FALSE;
		_tmp25_ = TRUE;
		while (TRUE) {
			ValaList* value_attrs = NULL;
			ValaList* _tmp26_;
			ValaSourceLocation value_begin = {0};
			ValaSourceLocation _tmp27_ = {0};
			gchar* id = NULL;
			gchar* _tmp28_;
			ValaScanner* _tmp29_;
			ValaComment* _tmp30_;
			ValaExpression* value = NULL;
			ValaEnumValue* ev = NULL;
			const gchar* _tmp34_;
			ValaExpression* _tmp35_;
			ValaSourceLocation _tmp36_;
			ValaSourceReference* _tmp37_;
			ValaSourceReference* _tmp38_;
			ValaComment* _tmp39_;
			ValaEnumValue* _tmp40_;
			ValaEnumValue* _tmp41_;
			ValaEnumValue* _tmp42_;
			ValaEnumValue* _tmp43_;
			ValaList* _tmp44_;
			ValaEnum* _tmp45_;
			ValaEnumValue* _tmp46_;
			if (!_tmp25_) {
				if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
					break;
				}
			}
			_tmp25_ = FALSE;
			if (vala_parser_current (self) == VALA_TOKEN_TYPE_CLOSE_BRACE) {
				break;
			}
			_tmp26_ = vala_parser_parse_attributes (self, &_inner_error_);
			value_attrs = _tmp26_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (en);
					_vala_code_node_unref0 (sym);
					return;
				} else {
					_vala_code_node_unref0 (en);
					_vala_code_node_unref0 (sym);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			vala_parser_get_location (self, &_tmp27_);
			value_begin = _tmp27_;
			_tmp28_ = vala_parser_parse_identifier (self, &_inner_error_);
			id = _tmp28_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_iterable_unref0 (value_attrs);
					_vala_code_node_unref0 (en);
					_vala_code_node_unref0 (sym);
					return;
				} else {
					_vala_iterable_unref0 (value_attrs);
					_vala_code_node_unref0 (en);
					_vala_code_node_unref0 (sym);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp29_ = self->priv->scanner;
			_tmp30_ = vala_scanner_pop_comment (_tmp29_);
			_vala_comment_unref0 (self->priv->comment);
			self->priv->comment = _tmp30_;
			value = NULL;
			if (vala_parser_accept (self, VALA_TOKEN_TYPE_ASSIGN)) {
				ValaExpression* _tmp31_ = NULL;
				ValaExpression* _tmp32_;
				ValaExpression* _tmp33_;
				_tmp32_ = vala_parser_parse_expression (self, &_inner_error_);
				_tmp31_ = _tmp32_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (value);
						_g_free0 (id);
						_vala_iterable_unref0 (value_attrs);
						_vala_code_node_unref0 (en);
						_vala_code_node_unref0 (sym);
						return;
					} else {
						_vala_code_node_unref0 (value);
						_g_free0 (id);
						_vala_iterable_unref0 (value_attrs);
						_vala_code_node_unref0 (en);
						_vala_code_node_unref0 (sym);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp33_ = _tmp31_;
				_tmp31_ = NULL;
				_vala_code_node_unref0 (value);
				value = _tmp33_;
				_vala_code_node_unref0 (_tmp31_);
			}
			_tmp34_ = id;
			_tmp35_ = value;
			_tmp36_ = value_begin;
			_tmp37_ = vala_parser_get_src (self, &_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = self->priv->comment;
			_tmp40_ = vala_enum_value_new (_tmp34_, _tmp35_, _tmp38_, _tmp39_);
			_tmp41_ = _tmp40_;
			_vala_source_reference_unref0 (_tmp38_);
			ev = _tmp41_;
			_tmp42_ = ev;
			vala_symbol_set_access ((ValaSymbol*) _tmp42_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp43_ = ev;
			_tmp44_ = value_attrs;
			vala_parser_set_attributes (self, (ValaCodeNode*) _tmp43_, _tmp44_);
			_tmp45_ = en;
			_tmp46_ = ev;
			vala_enum_add_value (_tmp45_, _tmp46_);
			_vala_code_node_unref0 (ev);
			_vala_code_node_unref0 (value);
			_g_free0 (id);
			_vala_iterable_unref0 (value_attrs);
		}
	}
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_SEMICOLON)) {
		while (TRUE) {
			ValaEnum* _tmp47_;
			if (!(vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_BRACE)) {
				break;
			}
			_tmp47_ = en;
			vala_parser_parse_declaration (self, (ValaSymbol*) _tmp47_, FALSE, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (en);
					_vala_code_node_unref0 (sym);
					return;
				} else {
					_vala_code_node_unref0 (en);
					_vala_code_node_unref0 (sym);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (en);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_code_node_unref0 (en);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp48_ = en;
	_tmp49_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp48_);
	_result_ = _tmp49_;
	while (TRUE) {
		ValaUnresolvedSymbol* _tmp50_;
		ValaUnresolvedSymbol* _tmp51_;
		ValaUnresolvedSymbol* _tmp52_;
		ValaUnresolvedSymbol* _tmp53_;
		ValaUnresolvedSymbol* _tmp54_;
		ValaSymbol* _tmp55_ = NULL;
		ValaUnresolvedSymbol* _tmp56_;
		ValaSymbol* next = NULL;
		ValaSymbol* _tmp65_;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp71_;
		ValaSymbol* _tmp72_;
		_tmp50_ = sym;
		if (!(_tmp50_ != NULL)) {
			break;
		}
		_tmp51_ = sym;
		_tmp52_ = vala_unresolved_symbol_get_inner (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = _vala_code_node_ref0 (_tmp53_);
		_vala_code_node_unref0 (sym);
		sym = _tmp54_;
		_tmp56_ = sym;
		if (_tmp56_ != NULL) {
			ValaUnresolvedSymbol* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			ValaEnum* _tmp60_;
			ValaSourceReference* _tmp61_;
			ValaSourceReference* _tmp62_;
			ValaNamespace* _tmp63_;
			_tmp57_ = sym;
			_tmp58_ = vala_symbol_get_name ((ValaSymbol*) _tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = en;
			_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_namespace_new (_tmp59_, _tmp62_);
			_vala_code_node_unref0 (_tmp55_);
			_tmp55_ = (ValaSymbol*) _tmp63_;
		} else {
			ValaSymbol* _tmp64_;
			_tmp64_ = _vala_code_node_ref0 (parent);
			_vala_code_node_unref0 (_tmp55_);
			_tmp55_ = _tmp64_;
		}
		_tmp65_ = _vala_code_node_ref0 (_tmp55_);
		next = _tmp65_;
		_tmp66_ = _result_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp66_, VALA_TYPE_NAMESPACE)) {
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			_tmp67_ = next;
			_tmp68_ = _result_;
			vala_symbol_add_namespace (_tmp67_, G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALA_TYPE_NAMESPACE, ValaNamespace));
		} else {
			ValaSymbol* _tmp69_;
			ValaSymbol* _tmp70_;
			_tmp69_ = next;
			_tmp70_ = _result_;
			vala_symbol_add_enum (_tmp69_, G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_ENUM, ValaEnum));
		}
		_tmp71_ = next;
		_tmp72_ = _vala_code_node_ref0 (_tmp71_);
		_vala_code_node_unref0 (_result_);
		_result_ = _tmp72_;
		_vala_code_node_unref0 (next);
		_vala_code_node_unref0 (_tmp55_);
	}
	_vala_code_node_unref0 (_result_);
	_vala_code_node_unref0 (en);
	_vala_code_node_unref0 (sym);
}


static void
vala_parser_parse_errordomain_declaration (ValaParser* self,
                                           ValaSymbol* parent,
                                           ValaList* attrs,
                                           GError** error)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSymbolAccessibility access = 0;
	ValaParserModifierFlags flags = 0;
	ValaUnresolvedSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp1_;
	ValaErrorDomain* ed = NULL;
	ValaUnresolvedSymbol* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaComment* _tmp8_;
	ValaErrorDomain* _tmp9_;
	ValaErrorDomain* _tmp10_;
	ValaErrorDomain* _tmp11_;
	ValaSymbolAccessibility _tmp12_;
	gboolean _tmp13_ = FALSE;
	ValaParserModifierFlags _tmp14_;
	ValaErrorDomain* _tmp21_;
	ValaSourceLocation inner_begin = {0};
	ValaSourceLocation _tmp22_ = {0};
	ValaSymbol* _result_ = NULL;
	ValaErrorDomain* _tmp46_;
	ValaSymbol* _tmp47_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	access = vala_parser_parse_access_modifier (self, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	flags = vala_parser_parse_type_declaration_modifiers (self);
	vala_parser_expect (self, VALA_TOKEN_TYPE_ERRORDOMAIN, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = vala_parser_parse_symbol_name (self, &_inner_error_);
	sym = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = sym;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = begin;
	_tmp6_ = vala_parser_get_src (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->comment;
	_tmp9_ = vala_error_domain_new (_tmp4_, _tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	_vala_source_reference_unref0 (_tmp7_);
	ed = _tmp10_;
	_tmp11_ = ed;
	_tmp12_ = access;
	vala_symbol_set_access ((ValaSymbol*) _tmp11_, _tmp12_);
	_tmp14_ = flags;
	if ((_tmp14_ & VALA_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp13_ = TRUE;
	} else {
		ValaScanner* _tmp15_;
		ValaSourceFile* _tmp16_;
		ValaSourceFile* _tmp17_;
		ValaSourceFileType _tmp18_;
		ValaSourceFileType _tmp19_;
		_tmp15_ = self->priv->scanner;
		_tmp16_ = vala_scanner_get_source_file (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_source_file_get_file_type (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp13_ = _tmp19_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	}
	if (_tmp13_) {
		ValaErrorDomain* _tmp20_;
		_tmp20_ = ed;
		vala_symbol_set_external ((ValaSymbol*) _tmp20_, TRUE);
	}
	_tmp21_ = ed;
	vala_parser_set_attributes (self, (ValaCodeNode*) _tmp21_, attrs);
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (ed);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_code_node_unref0 (ed);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	vala_parser_get_location (self, &_tmp22_);
	inner_begin = _tmp22_;
	{
		while (TRUE) {
			ValaErrorDomain* _tmp23_;
			if (!(vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_BRACE)) {
				break;
			}
			_tmp23_ = ed;
			vala_parser_parse_declaration (self, (ValaSymbol*) _tmp23_, FALSE, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					goto __catch18_vala_parse_error;
				}
				_vala_code_node_unref0 (ed);
				_vala_code_node_unref0 (sym);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	goto __finally18;
	__catch18_vala_parse_error:
	{
		GError* e = NULL;
		ValaSourceLocation _tmp24_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = inner_begin;
		vala_parser_rollback (self, &_tmp24_);
		_g_error_free0 (e);
	}
	__finally18:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (ed);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_code_node_unref0 (ed);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		gboolean _tmp25_ = FALSE;
		_tmp25_ = TRUE;
		while (TRUE) {
			ValaList* code_attrs = NULL;
			ValaList* _tmp26_;
			ValaSourceLocation code_begin = {0};
			ValaSourceLocation _tmp27_ = {0};
			gchar* id = NULL;
			gchar* _tmp28_;
			ValaScanner* _tmp29_;
			ValaComment* _tmp30_;
			ValaErrorCode* ec = NULL;
			const gchar* _tmp31_;
			ValaSourceLocation _tmp32_;
			ValaSourceReference* _tmp33_;
			ValaSourceReference* _tmp34_;
			ValaComment* _tmp35_;
			ValaErrorCode* _tmp36_;
			ValaErrorCode* _tmp37_;
			ValaErrorCode* _tmp38_;
			ValaList* _tmp39_;
			ValaErrorDomain* _tmp43_;
			ValaErrorCode* _tmp44_;
			if (!_tmp25_) {
				if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
					break;
				}
			}
			_tmp25_ = FALSE;
			if (vala_parser_current (self) == VALA_TOKEN_TYPE_CLOSE_BRACE) {
				break;
			}
			_tmp26_ = vala_parser_parse_attributes (self, &_inner_error_);
			code_attrs = _tmp26_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (ed);
					_vala_code_node_unref0 (sym);
					return;
				} else {
					_vala_code_node_unref0 (ed);
					_vala_code_node_unref0 (sym);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			vala_parser_get_location (self, &_tmp27_);
			code_begin = _tmp27_;
			_tmp28_ = vala_parser_parse_identifier (self, &_inner_error_);
			id = _tmp28_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_iterable_unref0 (code_attrs);
					_vala_code_node_unref0 (ed);
					_vala_code_node_unref0 (sym);
					return;
				} else {
					_vala_iterable_unref0 (code_attrs);
					_vala_code_node_unref0 (ed);
					_vala_code_node_unref0 (sym);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp29_ = self->priv->scanner;
			_tmp30_ = vala_scanner_pop_comment (_tmp29_);
			_vala_comment_unref0 (self->priv->comment);
			self->priv->comment = _tmp30_;
			_tmp31_ = id;
			_tmp32_ = code_begin;
			_tmp33_ = vala_parser_get_src (self, &_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = self->priv->comment;
			_tmp36_ = vala_error_code_new (_tmp31_, _tmp34_, _tmp35_);
			_tmp37_ = _tmp36_;
			_vala_source_reference_unref0 (_tmp34_);
			ec = _tmp37_;
			_tmp38_ = ec;
			_tmp39_ = code_attrs;
			vala_parser_set_attributes (self, (ValaCodeNode*) _tmp38_, _tmp39_);
			if (vala_parser_accept (self, VALA_TOKEN_TYPE_ASSIGN)) {
				ValaExpression* _tmp40_ = NULL;
				ValaExpression* _tmp41_;
				ValaErrorCode* _tmp42_;
				_tmp41_ = vala_parser_parse_expression (self, &_inner_error_);
				_tmp40_ = _tmp41_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (ec);
						_g_free0 (id);
						_vala_iterable_unref0 (code_attrs);
						_vala_code_node_unref0 (ed);
						_vala_code_node_unref0 (sym);
						return;
					} else {
						_vala_code_node_unref0 (ec);
						_g_free0 (id);
						_vala_iterable_unref0 (code_attrs);
						_vala_code_node_unref0 (ed);
						_vala_code_node_unref0 (sym);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp42_ = ec;
				vala_error_code_set_value (_tmp42_, _tmp40_);
				_vala_code_node_unref0 (_tmp40_);
			}
			_tmp43_ = ed;
			_tmp44_ = ec;
			vala_error_domain_add_code (_tmp43_, _tmp44_);
			_vala_code_node_unref0 (ec);
			_g_free0 (id);
			_vala_iterable_unref0 (code_attrs);
		}
	}
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_SEMICOLON)) {
		while (TRUE) {
			ValaErrorDomain* _tmp45_;
			if (!(vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_BRACE)) {
				break;
			}
			_tmp45_ = ed;
			vala_parser_parse_declaration (self, (ValaSymbol*) _tmp45_, FALSE, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (ed);
					_vala_code_node_unref0 (sym);
					return;
				} else {
					_vala_code_node_unref0 (ed);
					_vala_code_node_unref0 (sym);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (ed);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_code_node_unref0 (ed);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp46_ = ed;
	_tmp47_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp46_);
	_result_ = _tmp47_;
	while (TRUE) {
		ValaUnresolvedSymbol* _tmp48_;
		ValaUnresolvedSymbol* _tmp49_;
		ValaUnresolvedSymbol* _tmp50_;
		ValaUnresolvedSymbol* _tmp51_;
		ValaUnresolvedSymbol* _tmp52_;
		ValaSymbol* _tmp53_ = NULL;
		ValaUnresolvedSymbol* _tmp54_;
		ValaSymbol* next = NULL;
		ValaSymbol* _tmp63_;
		ValaSymbol* _tmp64_;
		ValaSymbol* _tmp69_;
		ValaSymbol* _tmp70_;
		_tmp48_ = sym;
		if (!(_tmp48_ != NULL)) {
			break;
		}
		_tmp49_ = sym;
		_tmp50_ = vala_unresolved_symbol_get_inner (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = _vala_code_node_ref0 (_tmp51_);
		_vala_code_node_unref0 (sym);
		sym = _tmp52_;
		_tmp54_ = sym;
		if (_tmp54_ != NULL) {
			ValaUnresolvedSymbol* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			ValaErrorDomain* _tmp58_;
			ValaSourceReference* _tmp59_;
			ValaSourceReference* _tmp60_;
			ValaNamespace* _tmp61_;
			_tmp55_ = sym;
			_tmp56_ = vala_symbol_get_name ((ValaSymbol*) _tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = ed;
			_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_namespace_new (_tmp57_, _tmp60_);
			_vala_code_node_unref0 (_tmp53_);
			_tmp53_ = (ValaSymbol*) _tmp61_;
		} else {
			ValaSymbol* _tmp62_;
			_tmp62_ = _vala_code_node_ref0 (parent);
			_vala_code_node_unref0 (_tmp53_);
			_tmp53_ = _tmp62_;
		}
		_tmp63_ = _vala_code_node_ref0 (_tmp53_);
		next = _tmp63_;
		_tmp64_ = _result_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_NAMESPACE)) {
			ValaSymbol* _tmp65_;
			ValaSymbol* _tmp66_;
			_tmp65_ = next;
			_tmp66_ = _result_;
			vala_symbol_add_namespace (_tmp65_, G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, VALA_TYPE_NAMESPACE, ValaNamespace));
		} else {
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			_tmp67_ = next;
			_tmp68_ = _result_;
			vala_symbol_add_error_domain (_tmp67_, G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain));
		}
		_tmp69_ = next;
		_tmp70_ = _vala_code_node_ref0 (_tmp69_);
		_vala_code_node_unref0 (_result_);
		_result_ = _tmp70_;
		_vala_code_node_unref0 (next);
		_vala_code_node_unref0 (_tmp53_);
	}
	_vala_code_node_unref0 (_result_);
	_vala_code_node_unref0 (ed);
	_vala_code_node_unref0 (sym);
}


static ValaSymbolAccessibility
vala_parser_parse_access_modifier (ValaParser* self,
                                   ValaSymbolAccessibility default_access)
{
	ValaSymbolAccessibility result = 0;
	g_return_val_if_fail (self != NULL, 0);
	switch (vala_parser_current (self)) {
		case VALA_TOKEN_TYPE_PRIVATE:
		{
			vala_parser_next (self);
			result = VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			return result;
		}
		case VALA_TOKEN_TYPE_PROTECTED:
		{
			vala_parser_next (self);
			result = VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			return result;
		}
		case VALA_TOKEN_TYPE_INTERNAL:
		{
			vala_parser_next (self);
			result = VALA_SYMBOL_ACCESSIBILITY_INTERNAL;
			return result;
		}
		case VALA_TOKEN_TYPE_PUBLIC:
		{
			vala_parser_next (self);
			result = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			return result;
		}
		default:
		{
			result = default_access;
			return result;
		}
	}
}


static ValaParserModifierFlags
vala_parser_parse_type_declaration_modifiers (ValaParser* self)
{
	ValaParserModifierFlags result = 0;
	ValaParserModifierFlags flags = 0;
	g_return_val_if_fail (self != NULL, 0);
	flags = 0;
	while (TRUE) {
		switch (vala_parser_current (self)) {
			case VALA_TOKEN_TYPE_ABSTRACT:
			{
				ValaParserModifierFlags _tmp0_;
				vala_parser_next (self);
				_tmp0_ = flags;
				flags = _tmp0_ | VALA_PARSER_MODIFIER_FLAGS_ABSTRACT;
				break;
			}
			case VALA_TOKEN_TYPE_EXTERN:
			{
				ValaParserModifierFlags _tmp1_;
				vala_parser_next (self);
				_tmp1_ = flags;
				flags = _tmp1_ | VALA_PARSER_MODIFIER_FLAGS_EXTERN;
				break;
			}
			case VALA_TOKEN_TYPE_SEALED:
			{
				ValaParserModifierFlags _tmp2_;
				vala_parser_next (self);
				_tmp2_ = flags;
				flags = _tmp2_ | VALA_PARSER_MODIFIER_FLAGS_SEALED;
				break;
			}
			default:
			{
				result = flags;
				return result;
			}
		}
	}
}


static ValaParserModifierFlags
vala_parser_parse_member_declaration_modifiers (ValaParser* self)
{
	ValaParserModifierFlags result = 0;
	ValaParserModifierFlags flags = 0;
	g_return_val_if_fail (self != NULL, 0);
	flags = 0;
	while (TRUE) {
		switch (vala_parser_current (self)) {
			case VALA_TOKEN_TYPE_ABSTRACT:
			{
				ValaParserModifierFlags _tmp0_;
				vala_parser_next (self);
				_tmp0_ = flags;
				flags = _tmp0_ | VALA_PARSER_MODIFIER_FLAGS_ABSTRACT;
				break;
			}
			case VALA_TOKEN_TYPE_ASYNC:
			{
				ValaParserModifierFlags _tmp1_;
				vala_parser_next (self);
				_tmp1_ = flags;
				flags = _tmp1_ | VALA_PARSER_MODIFIER_FLAGS_ASYNC;
				break;
			}
			case VALA_TOKEN_TYPE_CLASS:
			{
				ValaParserModifierFlags _tmp2_;
				vala_parser_next (self);
				_tmp2_ = flags;
				flags = _tmp2_ | VALA_PARSER_MODIFIER_FLAGS_CLASS;
				break;
			}
			case VALA_TOKEN_TYPE_EXTERN:
			{
				ValaParserModifierFlags _tmp3_;
				vala_parser_next (self);
				_tmp3_ = flags;
				flags = _tmp3_ | VALA_PARSER_MODIFIER_FLAGS_EXTERN;
				break;
			}
			case VALA_TOKEN_TYPE_INLINE:
			{
				ValaParserModifierFlags _tmp4_;
				vala_parser_next (self);
				_tmp4_ = flags;
				flags = _tmp4_ | VALA_PARSER_MODIFIER_FLAGS_INLINE;
				break;
			}
			case VALA_TOKEN_TYPE_NEW:
			{
				ValaParserModifierFlags _tmp5_;
				vala_parser_next (self);
				_tmp5_ = flags;
				flags = _tmp5_ | VALA_PARSER_MODIFIER_FLAGS_NEW;
				break;
			}
			case VALA_TOKEN_TYPE_OVERRIDE:
			{
				ValaParserModifierFlags _tmp6_;
				vala_parser_next (self);
				_tmp6_ = flags;
				flags = _tmp6_ | VALA_PARSER_MODIFIER_FLAGS_OVERRIDE;
				break;
			}
			case VALA_TOKEN_TYPE_SEALED:
			{
				ValaParserModifierFlags _tmp7_;
				vala_parser_next (self);
				_tmp7_ = flags;
				flags = _tmp7_ | VALA_PARSER_MODIFIER_FLAGS_SEALED;
				break;
			}
			case VALA_TOKEN_TYPE_STATIC:
			{
				ValaParserModifierFlags _tmp8_;
				vala_parser_next (self);
				_tmp8_ = flags;
				flags = _tmp8_ | VALA_PARSER_MODIFIER_FLAGS_STATIC;
				break;
			}
			case VALA_TOKEN_TYPE_VIRTUAL:
			{
				ValaParserModifierFlags _tmp9_;
				vala_parser_next (self);
				_tmp9_ = flags;
				flags = _tmp9_ | VALA_PARSER_MODIFIER_FLAGS_VIRTUAL;
				break;
			}
			default:
			{
				result = flags;
				return result;
			}
		}
	}
}


static ValaParameter*
vala_parser_parse_parameter (ValaParser* self,
                             GError** error)
{
	ValaParameter* result = NULL;
	ValaList* attrs = NULL;
	ValaList* _tmp0_;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp1_ = {0};
	gboolean params_array = FALSE;
	ValaParameterDirection direction = 0;
	ValaDataType* type = NULL;
	ValaParameterDirection _tmp7_;
	gchar* id = NULL;
	gchar* _tmp18_;
	ValaDataType* _tmp19_ = NULL;
	ValaDataType* _tmp20_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	ValaParameter* param = NULL;
	const gchar* _tmp23_;
	ValaDataType* _tmp24_;
	ValaSourceLocation _tmp25_;
	ValaSourceReference* _tmp26_;
	ValaSourceReference* _tmp27_;
	ValaParameter* _tmp28_;
	ValaParameter* _tmp29_;
	ValaParameter* _tmp30_;
	ValaList* _tmp31_;
	ValaParameter* _tmp32_;
	ValaParameterDirection _tmp33_;
	ValaParameter* _tmp34_;
	gboolean _tmp35_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_parser_parse_attributes (self, &_inner_error_);
	attrs = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_parser_get_location (self, &_tmp1_);
	begin = _tmp1_;
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_ELLIPSIS)) {
		ValaSourceLocation _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaParameter* _tmp5_;
		ValaParameter* _tmp6_;
		_tmp2_ = begin;
		_tmp3_ = vala_parser_get_src (self, &_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_parameter_new_with_ellipsis (_tmp4_);
		_tmp6_ = _tmp5_;
		_vala_source_reference_unref0 (_tmp4_);
		result = _tmp6_;
		_vala_iterable_unref0 (attrs);
		return result;
	}
	params_array = vala_parser_accept (self, VALA_TOKEN_TYPE_PARAMS);
	direction = VALA_PARAMETER_DIRECTION_IN;
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_OUT)) {
		direction = VALA_PARAMETER_DIRECTION_OUT;
	} else {
		if (vala_parser_accept (self, VALA_TOKEN_TYPE_REF)) {
			direction = VALA_PARAMETER_DIRECTION_REF;
		}
	}
	_tmp7_ = direction;
	if (_tmp7_ == VALA_PARAMETER_DIRECTION_IN) {
		ValaDataType* _tmp8_ = NULL;
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		_tmp9_ = vala_parser_parse_type (self, FALSE, FALSE, FALSE, &_inner_error_);
		_tmp8_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (type);
				_vala_iterable_unref0 (attrs);
				return NULL;
			} else {
				_vala_code_node_unref0 (type);
				_vala_iterable_unref0 (attrs);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp10_ = _tmp8_;
		_tmp8_ = NULL;
		_vala_code_node_unref0 (type);
		type = _tmp10_;
		_vala_code_node_unref0 (_tmp8_);
	} else {
		ValaParameterDirection _tmp11_;
		_tmp11_ = direction;
		if (_tmp11_ == VALA_PARAMETER_DIRECTION_REF) {
			ValaDataType* _tmp12_ = NULL;
			ValaDataType* _tmp13_;
			ValaDataType* _tmp14_;
			_tmp13_ = vala_parser_parse_type (self, TRUE, TRUE, FALSE, &_inner_error_);
			_tmp12_ = _tmp13_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (type);
					_vala_iterable_unref0 (attrs);
					return NULL;
				} else {
					_vala_code_node_unref0 (type);
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp14_ = _tmp12_;
			_tmp12_ = NULL;
			_vala_code_node_unref0 (type);
			type = _tmp14_;
			_vala_code_node_unref0 (_tmp12_);
		} else {
			ValaDataType* _tmp15_ = NULL;
			ValaDataType* _tmp16_;
			ValaDataType* _tmp17_;
			_tmp16_ = vala_parser_parse_type (self, TRUE, FALSE, FALSE, &_inner_error_);
			_tmp15_ = _tmp16_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (type);
					_vala_iterable_unref0 (attrs);
					return NULL;
				} else {
					_vala_code_node_unref0 (type);
					_vala_iterable_unref0 (attrs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp17_ = _tmp15_;
			_tmp15_ = NULL;
			_vala_code_node_unref0 (type);
			type = _tmp17_;
			_vala_code_node_unref0 (_tmp15_);
		}
	}
	_tmp18_ = vala_parser_parse_identifier (self, &_inner_error_);
	id = _tmp18_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (type);
			_vala_iterable_unref0 (attrs);
			return NULL;
		} else {
			_vala_code_node_unref0 (type);
			_vala_iterable_unref0 (attrs);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp20_ = type;
	_tmp21_ = vala_parser_parse_inline_array_type (self, _tmp20_, &_inner_error_);
	_tmp19_ = _tmp21_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			_vala_iterable_unref0 (attrs);
			return NULL;
		} else {
			_g_free0 (id);
			_vala_code_node_unref0 (type);
			_vala_iterable_unref0 (attrs);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp22_ = _tmp19_;
	_tmp19_ = NULL;
	_vala_code_node_unref0 (type);
	type = _tmp22_;
	_tmp23_ = id;
	_tmp24_ = type;
	_tmp25_ = begin;
	_tmp26_ = vala_parser_get_src (self, &_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_parameter_new (_tmp23_, _tmp24_, _tmp27_);
	_tmp29_ = _tmp28_;
	_vala_source_reference_unref0 (_tmp27_);
	param = _tmp29_;
	_tmp30_ = param;
	_tmp31_ = attrs;
	vala_parser_set_attributes (self, (ValaCodeNode*) _tmp30_, _tmp31_);
	_tmp32_ = param;
	_tmp33_ = direction;
	vala_parameter_set_direction (_tmp32_, _tmp33_);
	_tmp34_ = param;
	_tmp35_ = params_array;
	vala_parameter_set_params_array (_tmp34_, _tmp35_);
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp36_ = NULL;
		ValaExpression* _tmp37_;
		ValaParameter* _tmp38_;
		_tmp37_ = vala_parser_parse_expression (self, &_inner_error_);
		_tmp36_ = _tmp37_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (_tmp19_);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				_vala_iterable_unref0 (attrs);
				return NULL;
			} else {
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (_tmp19_);
				_g_free0 (id);
				_vala_code_node_unref0 (type);
				_vala_iterable_unref0 (attrs);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp38_ = param;
		vala_variable_set_initializer ((ValaVariable*) _tmp38_, _tmp36_);
		_vala_code_node_unref0 (_tmp36_);
	}
	result = param;
	_vala_code_node_unref0 (_tmp19_);
	_g_free0 (id);
	_vala_code_node_unref0 (type);
	_vala_iterable_unref0 (attrs);
	return result;
}


static void
vala_parser_parse_creation_method_declaration (ValaParser* self,
                                               ValaSymbol* parent,
                                               ValaList* attrs,
                                               GError** error)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSymbolAccessibility access = 0;
	ValaParserModifierFlags flags = 0;
	ValaUnresolvedSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp1_;
	ValaParserModifierFlags _tmp2_;
	ValaCreationMethod* method = NULL;
	ValaUnresolvedSymbol* _tmp4_;
	ValaUnresolvedSymbol* _tmp5_;
	ValaUnresolvedSymbol* _tmp6_;
	ValaParserModifierFlags _tmp28_;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	ValaParserModifierFlags _tmp32_;
	ValaParserModifierFlags _tmp38_;
	ValaCreationMethod* _tmp54_;
	ValaSymbolAccessibility _tmp55_;
	ValaCreationMethod* _tmp56_;
	ValaCreationMethod* _tmp66_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	access = vala_parser_parse_access_modifier (self, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	flags = vala_parser_parse_member_declaration_modifiers (self);
	_tmp1_ = vala_parser_parse_symbol_name (self, &_inner_error_);
	sym = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = flags;
	if ((_tmp2_ & VALA_PARSER_MODIFIER_FLAGS_NEW) == VALA_PARSER_MODIFIER_FLAGS_NEW) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "`new' modifier not allowed on creation method");
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = sym;
	_tmp5_ = vala_unresolved_symbol_get_inner (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == NULL) {
		ValaUnresolvedSymbol* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		ValaSourceLocation _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaComment* _tmp13_;
		ValaCreationMethod* _tmp14_;
		_tmp7_ = sym;
		_tmp8_ = vala_symbol_get_name ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = begin;
		_tmp11_ = vala_parser_get_src (self, &_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = self->priv->comment;
		_tmp14_ = vala_creation_method_new (_tmp9_, NULL, _tmp12_, _tmp13_);
		_vala_code_node_unref0 (method);
		method = _tmp14_;
		_vala_source_reference_unref0 (_tmp12_);
	} else {
		ValaUnresolvedSymbol* _tmp15_;
		ValaUnresolvedSymbol* _tmp16_;
		ValaUnresolvedSymbol* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		ValaUnresolvedSymbol* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		ValaSourceLocation _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaComment* _tmp26_;
		ValaCreationMethod* _tmp27_;
		_tmp15_ = sym;
		_tmp16_ = vala_unresolved_symbol_get_inner (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_symbol_get_name ((ValaSymbol*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = sym;
		_tmp21_ = vala_symbol_get_name ((ValaSymbol*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = begin;
		_tmp24_ = vala_parser_get_src (self, &_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = self->priv->comment;
		_tmp27_ = vala_creation_method_new (_tmp19_, _tmp22_, _tmp25_, _tmp26_);
		_vala_code_node_unref0 (method);
		method = _tmp27_;
		_vala_source_reference_unref0 (_tmp25_);
	}
	_tmp28_ = flags;
	if ((_tmp28_ & VALA_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_PARSER_MODIFIER_FLAGS_EXTERN) {
		ValaCreationMethod* _tmp29_;
		_tmp29_ = method;
		vala_symbol_set_external ((ValaSymbol*) _tmp29_, TRUE);
	}
	_tmp32_ = flags;
	if ((_tmp32_ & VALA_PARSER_MODIFIER_FLAGS_ABSTRACT) == VALA_PARSER_MODIFIER_FLAGS_ABSTRACT) {
		_tmp31_ = TRUE;
	} else {
		ValaParserModifierFlags _tmp33_;
		_tmp33_ = flags;
		_tmp31_ = (_tmp33_ & VALA_PARSER_MODIFIER_FLAGS_VIRTUAL) == VALA_PARSER_MODIFIER_FLAGS_VIRTUAL;
	}
	if (_tmp31_) {
		_tmp30_ = TRUE;
	} else {
		ValaParserModifierFlags _tmp34_;
		_tmp34_ = flags;
		_tmp30_ = (_tmp34_ & VALA_PARSER_MODIFIER_FLAGS_OVERRIDE) == VALA_PARSER_MODIFIER_FLAGS_OVERRIDE;
	}
	if (_tmp30_) {
		ValaCreationMethod* _tmp35_;
		ValaSourceReference* _tmp36_;
		ValaSourceReference* _tmp37_;
		_tmp35_ = method;
		_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp35_);
		_tmp37_ = _tmp36_;
		vala_report_error (_tmp37_, "abstract, virtual, and override modifiers are not applicable to creati" \
"on methods");
	}
	_tmp38_ = flags;
	if ((_tmp38_ & VALA_PARSER_MODIFIER_FLAGS_ASYNC) == VALA_PARSER_MODIFIER_FLAGS_ASYNC) {
		ValaCreationMethod* _tmp39_;
		_tmp39_ = method;
		vala_method_set_coroutine ((ValaMethod*) _tmp39_, TRUE);
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (method);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_code_node_unref0 (method);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_PARENS) {
		{
			gboolean _tmp40_ = FALSE;
			_tmp40_ = TRUE;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaParameter* _tmp41_;
				ValaCreationMethod* _tmp42_;
				ValaParameter* _tmp43_;
				if (!_tmp40_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp40_ = FALSE;
				_tmp41_ = vala_parser_parse_parameter (self, &_inner_error_);
				param = _tmp41_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (method);
						_vala_code_node_unref0 (sym);
						return;
					} else {
						_vala_code_node_unref0 (method);
						_vala_code_node_unref0 (sym);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp42_ = method;
				_tmp43_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp42_, _tmp43_);
				_vala_code_node_unref0 (param);
			}
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (method);
			_vala_code_node_unref0 (sym);
			return;
		} else {
			_vala_code_node_unref0 (method);
			_vala_code_node_unref0 (sym);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_THROWS)) {
		{
			gboolean _tmp44_ = FALSE;
			_tmp44_ = TRUE;
			while (TRUE) {
				ValaDataType* _tmp45_ = NULL;
				ValaDataType* _tmp46_;
				ValaCreationMethod* _tmp47_;
				if (!_tmp44_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp44_ = FALSE;
				_tmp46_ = vala_parser_parse_type (self, TRUE, FALSE, FALSE, &_inner_error_);
				_tmp45_ = _tmp46_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (method);
						_vala_code_node_unref0 (sym);
						return;
					} else {
						_vala_code_node_unref0 (method);
						_vala_code_node_unref0 (sym);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp47_ = method;
				vala_code_node_add_error_type ((ValaCodeNode*) _tmp47_, _tmp45_);
				_vala_code_node_unref0 (_tmp45_);
			}
		}
	}
	while (TRUE) {
		ValaExpression* _tmp48_ = NULL;
		ValaExpression* _tmp49_;
		ValaCreationMethod* _tmp50_;
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_REQUIRES)) {
			break;
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (method);
				_vala_code_node_unref0 (sym);
				return;
			} else {
				_vala_code_node_unref0 (method);
				_vala_code_node_unref0 (sym);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp49_ = vala_parser_parse_expression (self, &_inner_error_);
		_tmp48_ = _tmp49_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (method);
				_vala_code_node_unref0 (sym);
				return;
			} else {
				_vala_code_node_unref0 (method);
				_vala_code_node_unref0 (sym);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp50_ = method;
		vala_method_add_precondition ((ValaMethod*) _tmp50_, _tmp48_);
		vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (_tmp48_);
				_vala_code_node_unref0 (method);
				_vala_code_node_unref0 (sym);
				return;
			} else {
				_vala_code_node_unref0 (_tmp48_);
				_vala_code_node_unref0 (method);
				_vala_code_node_unref0 (sym);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_vala_code_node_unref0 (_tmp48_);
	}
	while (TRUE) {
		ValaExpression* _tmp51_ = NULL;
		ValaExpression* _tmp52_;
		ValaCreationMethod* _tmp53_;
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_ENSURES)) {
			break;
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (method);
				_vala_code_node_unref0 (sym);
				return;
			} else {
				_vala_code_node_unref0 (method);
				_vala_code_node_unref0 (sym);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp52_ = vala_parser_parse_expression (self, &_inner_error_);
		_tmp51_ = _tmp52_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (method);
				_vala_code_node_unref0 (sym);
				return;
			} else {
				_vala_code_node_unref0 (method);
				_vala_code_node_unref0 (sym);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp53_ = method;
		vala_method_add_postcondition ((ValaMethod*) _tmp53_, _tmp51_);
		vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (_tmp51_);
				_vala_code_node_unref0 (method);
				_vala_code_node_unref0 (sym);
				return;
			} else {
				_vala_code_node_unref0 (_tmp51_);
				_vala_code_node_unref0 (method);
				_vala_code_node_unref0 (sym);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_vala_code_node_unref0 (_tmp51_);
	}
	_tmp54_ = method;
	_tmp55_ = access;
	vala_symbol_set_access ((ValaSymbol*) _tmp54_, _tmp55_);
	_tmp56_ = method;
	vala_parser_set_attributes (self, (ValaCodeNode*) _tmp56_, attrs);
	if (!vala_parser_accept (self, VALA_TOKEN_TYPE_SEMICOLON)) {
		ValaBlock* _tmp57_ = NULL;
		ValaBlock* _tmp58_;
		ValaCreationMethod* _tmp59_;
		_tmp58_ = vala_parser_parse_block (self, &_inner_error_);
		_tmp57_ = _tmp58_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_code_node_unref0 (method);
				_vala_code_node_unref0 (sym);
				return;
			} else {
				_vala_code_node_unref0 (method);
				_vala_code_node_unref0 (sym);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp59_ = method;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp59_, _tmp57_);
		_vala_code_node_unref0 (_tmp57_);
	} else {
		ValaScanner* _tmp60_;
		ValaSourceFile* _tmp61_;
		ValaSourceFile* _tmp62_;
		ValaSourceFileType _tmp63_;
		ValaSourceFileType _tmp64_;
		_tmp60_ = self->priv->scanner;
		_tmp61_ = vala_scanner_get_source_file (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_source_file_get_file_type (_tmp62_);
		_tmp64_ = _tmp63_;
		if (_tmp64_ == VALA_SOURCE_FILE_TYPE_PACKAGE) {
			ValaCreationMethod* _tmp65_;
			_tmp65_ = method;
			vala_symbol_set_external ((ValaSymbol*) _tmp65_, TRUE);
		}
	}
	_tmp66_ = method;
	vala_symbol_add_method (parent, (ValaMethod*) _tmp66_);
	_vala_code_node_unref0 (method);
	_vala_code_node_unref0 (sym);
}


static void
vala_parser_parse_delegate_declaration (ValaParser* self,
                                        ValaSymbol* parent,
                                        ValaList* attrs,
                                        GError** error)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaSymbolAccessibility access = 0;
	ValaParserModifierFlags flags = 0;
	ValaParserModifierFlags _tmp1_;
	ValaDataType* type = NULL;
	ValaDataType* _tmp3_;
	ValaUnresolvedSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp4_;
	ValaList* type_param_list = NULL;
	ValaList* _tmp5_;
	ValaDelegate* d = NULL;
	ValaUnresolvedSymbol* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	ValaDataType* _tmp9_;
	ValaSourceLocation _tmp10_;
	ValaSourceReference* _tmp11_;
	ValaSourceReference* _tmp12_;
	ValaComment* _tmp13_;
	ValaDelegate* _tmp14_;
	ValaDelegate* _tmp15_;
	ValaDelegate* _tmp16_;
	ValaSymbolAccessibility _tmp17_;
	ValaDelegate* _tmp18_;
	ValaParserModifierFlags _tmp19_;
	gboolean _tmp26_ = FALSE;
	ValaParserModifierFlags _tmp27_;
	ValaSymbol* _result_ = NULL;
	ValaDelegate* _tmp55_;
	ValaSymbol* _tmp56_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	access = vala_parser_parse_access_modifier (self, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	flags = vala_parser_parse_member_declaration_modifiers (self);
	vala_parser_expect (self, VALA_TOKEN_TYPE_DELEGATE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = flags;
	if ((_tmp1_ & VALA_PARSER_MODIFIER_FLAGS_NEW) == VALA_PARSER_MODIFIER_FLAGS_NEW) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "`new' modifier not allowed on delegates");
		_inner_error_ = _tmp2_;
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = vala_parser_parse_type (self, TRUE, FALSE, FALSE, &_inner_error_);
	type = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = vala_parser_parse_symbol_name (self, &_inner_error_);
	sym = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp5_ = vala_parser_parse_type_parameter_list (self, &_inner_error_);
	type_param_list = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp6_ = sym;
	_tmp7_ = vala_symbol_get_name ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = type;
	_tmp10_ = begin;
	_tmp11_ = vala_parser_get_src (self, &_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->comment;
	_tmp14_ = vala_delegate_new (_tmp8_, _tmp9_, _tmp12_, _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_source_reference_unref0 (_tmp12_);
	d = _tmp15_;
	_tmp16_ = d;
	_tmp17_ = access;
	vala_symbol_set_access ((ValaSymbol*) _tmp16_, _tmp17_);
	_tmp18_ = d;
	vala_parser_set_attributes (self, (ValaCodeNode*) _tmp18_, attrs);
	_tmp19_ = flags;
	if ((_tmp19_ & VALA_PARSER_MODIFIER_FLAGS_STATIC) == VALA_PARSER_MODIFIER_FLAGS_STATIC) {
		ValaCodeContext* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		ValaDelegate* _tmp25_;
		_tmp20_ = self->priv->context;
		_tmp21_ = vala_code_context_get_deprecated (_tmp20_);
		_tmp22_ = _tmp21_;
		if (!_tmp22_) {
			ValaSourceReference* _tmp23_;
			ValaSourceReference* _tmp24_;
			_tmp23_ = vala_parser_get_last_src (self);
			_tmp24_ = _tmp23_;
			vala_report_warning (_tmp24_, "deprecated syntax, use [CCode (has_target = false)]");
			_vala_source_reference_unref0 (_tmp24_);
		}
		_tmp25_ = d;
		vala_delegate_set_has_target (_tmp25_, FALSE);
	}
	_tmp27_ = flags;
	if ((_tmp27_ & VALA_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp26_ = TRUE;
	} else {
		ValaScanner* _tmp28_;
		ValaSourceFile* _tmp29_;
		ValaSourceFile* _tmp30_;
		ValaSourceFileType _tmp31_;
		ValaSourceFileType _tmp32_;
		_tmp28_ = self->priv->scanner;
		_tmp29_ = vala_scanner_get_source_file (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_source_file_get_file_type (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp26_ = _tmp32_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	}
	if (_tmp26_) {
		ValaDelegate* _tmp33_;
		_tmp33_ = d;
		vala_symbol_set_external ((ValaSymbol*) _tmp33_, TRUE);
	}
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp34_;
		ValaList* _tmp35_;
		gint _type_param_size = 0;
		ValaList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _type_param_index = 0;
		_tmp34_ = type_param_list;
		_tmp35_ = _vala_iterable_ref0 (_tmp34_);
		_type_param_list = _tmp35_;
		_tmp36_ = _type_param_list;
		_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_type_param_size = _tmp38_;
		_type_param_index = -1;
		while (TRUE) {
			gint _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp42_;
			gint _tmp43_;
			gpointer _tmp44_;
			ValaDelegate* _tmp45_;
			ValaTypeParameter* _tmp46_;
			_tmp39_ = _type_param_index;
			_type_param_index = _tmp39_ + 1;
			_tmp40_ = _type_param_index;
			_tmp41_ = _type_param_size;
			if (!(_tmp40_ < _tmp41_)) {
				break;
			}
			_tmp42_ = _type_param_list;
			_tmp43_ = _type_param_index;
			_tmp44_ = vala_list_get (_tmp42_, _tmp43_);
			type_param = (ValaTypeParameter*) _tmp44_;
			_tmp45_ = d;
			_tmp46_ = type_param;
			vala_delegate_add_type_parameter (_tmp45_, _tmp46_);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (d);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (d);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (vala_parser_current (self) != VALA_TOKEN_TYPE_CLOSE_PARENS) {
		{
			gboolean _tmp47_ = FALSE;
			_tmp47_ = TRUE;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaParameter* _tmp48_;
				ValaDelegate* _tmp49_;
				ValaParameter* _tmp50_;
				if (!_tmp47_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp47_ = FALSE;
				_tmp48_ = vala_parser_parse_parameter (self, &_inner_error_);
				param = _tmp48_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (d);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						return;
					} else {
						_vala_code_node_unref0 (d);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp49_ = d;
				_tmp50_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp49_, _tmp50_);
				_vala_code_node_unref0 (param);
			}
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (d);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (d);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_THROWS)) {
		{
			gboolean _tmp51_ = FALSE;
			_tmp51_ = TRUE;
			while (TRUE) {
				ValaDataType* _tmp52_ = NULL;
				ValaDataType* _tmp53_;
				ValaDelegate* _tmp54_;
				if (!_tmp51_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp51_ = FALSE;
				_tmp53_ = vala_parser_parse_type (self, TRUE, FALSE, FALSE, &_inner_error_);
				_tmp52_ = _tmp53_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (d);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						return;
					} else {
						_vala_code_node_unref0 (d);
						_vala_iterable_unref0 (type_param_list);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp54_ = d;
				vala_code_node_add_error_type ((ValaCodeNode*) _tmp54_, _tmp52_);
				_vala_code_node_unref0 (_tmp52_);
			}
		}
	}
	vala_parser_expect (self, VALA_TOKEN_TYPE_SEMICOLON, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_vala_code_node_unref0 (d);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			return;
		} else {
			_vala_code_node_unref0 (d);
			_vala_iterable_unref0 (type_param_list);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp55_ = d;
	_tmp56_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp55_);
	_result_ = _tmp56_;
	while (TRUE) {
		ValaUnresolvedSymbol* _tmp57_;
		ValaUnresolvedSymbol* _tmp58_;
		ValaUnresolvedSymbol* _tmp59_;
		ValaUnresolvedSymbol* _tmp60_;
		ValaUnresolvedSymbol* _tmp61_;
		ValaSymbol* _tmp62_ = NULL;
		ValaUnresolvedSymbol* _tmp63_;
		ValaSymbol* next = NULL;
		ValaSymbol* _tmp72_;
		ValaSymbol* _tmp73_;
		ValaSymbol* _tmp78_;
		ValaSymbol* _tmp79_;
		_tmp57_ = sym;
		if (!(_tmp57_ != NULL)) {
			break;
		}
		_tmp58_ = sym;
		_tmp59_ = vala_unresolved_symbol_get_inner (_tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = _vala_code_node_ref0 (_tmp60_);
		_vala_code_node_unref0 (sym);
		sym = _tmp61_;
		_tmp63_ = sym;
		if (_tmp63_ != NULL) {
			ValaUnresolvedSymbol* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			ValaDelegate* _tmp67_;
			ValaSourceReference* _tmp68_;
			ValaSourceReference* _tmp69_;
			ValaNamespace* _tmp70_;
			_tmp64_ = sym;
			_tmp65_ = vala_symbol_get_name ((ValaSymbol*) _tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = d;
			_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = vala_namespace_new (_tmp66_, _tmp69_);
			_vala_code_node_unref0 (_tmp62_);
			_tmp62_ = (ValaSymbol*) _tmp70_;
		} else {
			ValaSymbol* _tmp71_;
			_tmp71_ = _vala_code_node_ref0 (parent);
			_vala_code_node_unref0 (_tmp62_);
			_tmp62_ = _tmp71_;
		}
		_tmp72_ = _vala_code_node_ref0 (_tmp62_);
		next = _tmp72_;
		_tmp73_ = _result_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp73_, VALA_TYPE_NAMESPACE)) {
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp74_ = next;
			_tmp75_ = _result_;
			vala_symbol_add_namespace (_tmp74_, G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, VALA_TYPE_NAMESPACE, ValaNamespace));
		} else {
			ValaSymbol* _tmp76_;
			ValaSymbol* _tmp77_;
			_tmp76_ = next;
			_tmp77_ = _result_;
			vala_symbol_add_delegate (_tmp76_, G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, VALA_TYPE_DELEGATE, ValaDelegate));
		}
		_tmp78_ = next;
		_tmp79_ = _vala_code_node_ref0 (_tmp78_);
		_vala_code_node_unref0 (_result_);
		_result_ = _tmp79_;
		_vala_code_node_unref0 (next);
		_vala_code_node_unref0 (_tmp62_);
	}
	_vala_code_node_unref0 (_result_);
	_vala_code_node_unref0 (d);
	_vala_iterable_unref0 (type_param_list);
	_vala_code_node_unref0 (sym);
	_vala_code_node_unref0 (type);
}


static ValaList*
vala_parser_parse_type_parameter_list (ValaParser* self,
                                       GError** error)
{
	ValaList* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_OP_LT)) {
		ValaArrayList* list = NULL;
		GEqualFunc _tmp0_;
		ValaArrayList* _tmp1_;
		_tmp0_ = g_direct_equal;
		_tmp1_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
		list = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ValaSourceLocation begin = {0};
				ValaSourceLocation _tmp3_ = {0};
				gchar* id = NULL;
				gchar* _tmp4_;
				ValaArrayList* _tmp5_;
				const gchar* _tmp6_;
				ValaSourceLocation _tmp7_;
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				ValaTypeParameter* _tmp10_;
				ValaTypeParameter* _tmp11_;
				if (!_tmp2_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp2_ = FALSE;
				vala_parser_get_location (self, &_tmp3_);
				begin = _tmp3_;
				_tmp4_ = vala_parser_parse_identifier (self, &_inner_error_);
				id = _tmp4_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_vala_iterable_unref0 (list);
						return NULL;
					} else {
						_vala_iterable_unref0 (list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp5_ = list;
				_tmp6_ = id;
				_tmp7_ = begin;
				_tmp8_ = vala_parser_get_src (self, &_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = vala_typeparameter_new (_tmp6_, _tmp9_);
				_tmp11_ = _tmp10_;
				vala_collection_add ((ValaCollection*) _tmp5_, _tmp11_);
				_vala_code_node_unref0 (_tmp11_);
				_vala_source_reference_unref0 (_tmp9_);
				_g_free0 (id);
			}
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_OP_GT, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_vala_iterable_unref0 (list);
				return NULL;
			} else {
				_vala_iterable_unref0 (list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = (ValaList*) list;
		return result;
	} else {
		ValaList* _tmp12_;
		ValaList* _tmp15_;
		ValaList* _tmp16_;
		_tmp12_ = vala_parser__empty_type_parameter_list;
		if (_tmp12_ == NULL) {
			GEqualFunc _tmp13_;
			ValaArrayList* _tmp14_;
			_tmp13_ = g_direct_equal;
			_tmp14_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp13_);
			_vala_iterable_unref0 (vala_parser__empty_type_parameter_list);
			vala_parser__empty_type_parameter_list = (ValaList*) _tmp14_;
		}
		_tmp15_ = vala_parser__empty_type_parameter_list;
		_tmp16_ = _vala_iterable_ref0 (_tmp15_);
		result = _tmp16_;
		return result;
	}
}


static void
vala_parser_skip_type_argument_list (ValaParser* self,
                                     GError** error)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_OP_LT)) {
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp0_ = FALSE;
				vala_parser_skip_type (self, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
		}
		vala_parser_expect (self, VALA_TOKEN_TYPE_OP_GT, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static ValaList*
vala_parser_parse_type_argument_list (ValaParser* self,
                                      gboolean maybe_expression,
                                      GError** error)
{
	ValaList* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	if (vala_parser_accept (self, VALA_TOKEN_TYPE_OP_LT)) {
		ValaArrayList* list = NULL;
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		list = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				if (!_tmp3_) {
					if (!vala_parser_accept (self, VALA_TOKEN_TYPE_COMMA)) {
						break;
					}
				}
				_tmp3_ = FALSE;
				switch (vala_parser_current (self)) {
					case VALA_TOKEN_TYPE_VOID:
					case VALA_TOKEN_TYPE_DYNAMIC:
					case VALA_TOKEN_TYPE_UNOWNED:
					case VALA_TOKEN_TYPE_WEAK:
					case VALA_TOKEN_TYPE_IDENTIFIER:
					{
						ValaDataType* type = NULL;
						ValaDataType* _tmp4_;
						ValaArrayList* _tmp5_;
						ValaDataType* _tmp6_;
						_tmp4_ = vala_parser_parse_type (self, TRUE, TRUE, FALSE, &_inner_error_);
						type = _tmp4_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								_vala_iterable_unref0 (list);
								return NULL;
							} else {
								_vala_iterable_unref0 (list);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_tmp5_ = list;
						_tmp6_ = type;
						vala_collection_add ((ValaCollection*) _tmp5_, _tmp6_);
						_vala_code_node_unref0 (type);
						break;
					}
					default:
					{
						ValaSourceLocation _tmp7_;
						_tmp7_ = begin;
						vala_parser_rollback (self, &_tmp7_);
						result = NULL;
						_vala_iterable_unref0 (list);
						return result;
					}
				}
			}
		}
		if (!vala_parser_accept (self, VALA_TOKEN_TYPE_OP_GT)) {
			ValaSourceLocation _tmp8_;
			_tmp8_ = begin;
			vala_parser_rollback (self, &_tmp8_);
			result = NULL;
			_vala_iterable_unref0 (list);
			return result;
		}
		if (maybe_expression) {
			switch (vala_parser_current (self)) {
				case VALA_TOKEN_TYPE_OPEN_PARENS:
				case VALA_TOKEN_TYPE_CLOSE_PARENS:
				case VALA_TOKEN_TYPE_CLOSE_BRACKET:
				case VALA_TOKEN_TYPE_OPEN_BRACE:
				case VALA_TOKEN_TYPE_COLON:
				case VALA_TOKEN_TYPE_SEMICOLON:
				case VALA_TOKEN_TYPE_COMMA:
				case VALA_TOKEN_TYPE_DOT:
				case VALA_TOKEN_TYPE_INTERR:
				case VALA_TOKEN_TYPE_OP_EQ:
				case VALA_TOKEN_TYPE_OP_NE:
				{
					break;
				}
				default:
				{
					ValaSourceLocation _tmp9_;
					_tmp9_ = begin;
					vala_parser_rollback (self, &_tmp9_);
					result = NULL;
					_vala_iterable_unref0 (list);
					return result;
				}
			}
		}
		result = (ValaList*) list;
		return result;
	}
	result = NULL;
	return result;
}


static ValaMemberAccess*
vala_parser_parse_member_name (ValaParser* self,
                               ValaExpression* base_expr,
                               GError** error)
{
	ValaMemberAccess* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_ = {0};
	ValaMemberAccess* expr = NULL;
	gboolean first = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_parser_get_location (self, &_tmp0_);
	begin = _tmp0_;
	expr = NULL;
	first = TRUE;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			gchar* id = NULL;
			gchar* _tmp2_;
			gboolean qualified = FALSE;
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_;
			ValaList* type_arg_list = NULL;
			ValaList* _tmp10_;
			ValaExpression* _tmp11_ = NULL;
			ValaMemberAccess* _tmp12_;
			const gchar* _tmp14_;
			ValaSourceLocation _tmp15_;
			ValaSourceReference* _tmp16_;
			ValaSourceReference* _tmp17_;
			ValaMemberAccess* _tmp18_;
			ValaMemberAccess* _tmp19_;
			gboolean _tmp20_;
			ValaList* _tmp21_;
			if (!_tmp1_) {
				if (!vala_parser_accept (self, VALA_TOKEN_TYPE_DOT)) {
					break;
				}
			}
			_tmp1_ = FALSE;
			_tmp2_ = vala_parser_parse_identifier (self, &_inner_error_);
			id = _tmp2_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			qualified = FALSE;
			_tmp5_ = first;
			if (_tmp5_) {
				const gchar* _tmp6_;
				_tmp6_ = id;
				_tmp4_ = g_strcmp0 (_tmp6_, "global") == 0;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				_tmp3_ = vala_parser_accept (self, VALA_TOKEN_TYPE_DOUBLE_COLON);
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp8_ = vala_parser_parse_identifier (self, &_inner_error_);
				_tmp7_ = _tmp8_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (id);
						_vala_code_node_unref0 (expr);
						return NULL;
					} else {
						_g_free0 (id);
						_vala_code_node_unref0 (expr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp9_ = _tmp7_;
				_tmp7_ = NULL;
				_g_free0 (id);
				id = _tmp9_;
				qualified = TRUE;
				_g_free0 (_tmp7_);
			}
			_tmp10_ = vala_parser_parse_type_argument_list (self, FALSE, &_inner_error_);
			type_arg_list = _tmp10_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (id);
					_vala_code_node_unref0 (expr);
					return NULL;
				} else {
					_g_free0 (id);
					_vala_code_node_unref0 (expr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp12_ = expr;
			if (_tmp12_ != NULL) {
				ValaMemberAccess* _tmp13_;
				_tmp13_ = expr;
				_tmp11_ = (ValaExpression*) _tmp13_;
			} else {
				_tmp11_ = base_expr;
			}
			_tmp14_ = id;
			_tmp15_ = begin;
			_tmp16_ = vala_parser_get_src (self, &_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_member_access_new (_tmp11_, _tmp14_, _tmp17_);
			_vala_code_node_unref0 (expr);
			expr = _tmp18_;
			_vala_source_reference_unref0 (_tmp17_);
			_tmp19_ = expr;
			_tmp20_ = qualified;
			vala_member_access_set_qualified (_tmp19_, _tmp20_);
			_tmp21_ = type_arg_list;
			if (_tmp21_ != NULL) {
				{
					ValaList* _type_arg_list = NULL;
					ValaList* _tmp22_;
					ValaList* _tmp23_;
					gint _type_arg_size = 0;
					ValaList* _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
					gint _type_arg_index = 0;
					_tmp22_ = type_arg_list;
					_tmp23_ = _vala_iterable_ref0 (_tmp22_);
					_type_arg_list = _tmp23_;
					_tmp24_ = _type_arg_list;
					_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
					_tmp26_ = _tmp25_;
					_type_arg_size = _tmp26_;
					_type_arg_index = -1;
					while (TRUE) {
						gint _tmp27_;
						gint _tmp28_;
						gint _tmp29_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp30_;
						gint _tmp31_;
						gpointer _tmp32_;
						ValaMemberAccess* _tmp33_;
						ValaDataType* _tmp34_;
						_tmp27_ = _type_arg_index;
						_type_arg_index = _tmp27_ + 1;
						_tmp28_ = _type_arg_index;
						_tmp29_ = _type_arg_size;
						if (!(_tmp28_ < _tmp29_)) {
							break;
						}
						_tmp30_ = _type_arg_list;
						_tmp31_ = _type_arg_index;
						_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
						type_arg = (ValaDataType*) _tmp32_;
						_tmp33_ = expr;
						_tmp34_ = type_arg;
						vala_member_access_add_type_argument (_tmp33_, _tmp34_);
						_vala_code_node_unref0 (type_arg);
					}
					_vala_iterable_unref0 (_type_arg_list);
				}
			}
			first = FALSE;
			_vala_iterable_unref0 (type_arg_list);
			_g_free0 (id);
		}
	}
	result = expr;
	return result;
}


static gboolean
vala_parser_is_declaration_keyword (ValaParser* self,
                                    ValaTokenType type)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	switch (type) {
		case VALA_TOKEN_TYPE_ABSTRACT:
		case VALA_TOKEN_TYPE_ASYNC:
		case VALA_TOKEN_TYPE_CLASS:
		case VALA_TOKEN_TYPE_CONST:
		case VALA_TOKEN_TYPE_DELEGATE:
		case VALA_TOKEN_TYPE_ENUM:
		case VALA_TOKEN_TYPE_ERRORDOMAIN:
		case VALA_TOKEN_TYPE_EXTERN:
		case VALA_TOKEN_TYPE_INLINE:
		case VALA_TOKEN_TYPE_INTERFACE:
		case VALA_TOKEN_TYPE_INTERNAL:
		case VALA_TOKEN_TYPE_NAMESPACE:
		case VALA_TOKEN_TYPE_NEW:
		case VALA_TOKEN_TYPE_OVERRIDE:
		case VALA_TOKEN_TYPE_PRIVATE:
		case VALA_TOKEN_TYPE_PROTECTED:
		case VALA_TOKEN_TYPE_PUBLIC:
		case VALA_TOKEN_TYPE_SEALED:
		case VALA_TOKEN_TYPE_SIGNAL:
		case VALA_TOKEN_TYPE_STATIC:
		case VALA_TOKEN_TYPE_STRUCT:
		case VALA_TOKEN_TYPE_VIRTUAL:
		case VALA_TOKEN_TYPE_VOLATILE:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static ValaParserTokenInfo*
vala_parser_token_info_dup (const ValaParserTokenInfo* self)
{
	ValaParserTokenInfo* dup;
	dup = g_new0 (ValaParserTokenInfo, 1);
	memcpy (dup, self, sizeof (ValaParserTokenInfo));
	return dup;
}


static void
vala_parser_token_info_free (ValaParserTokenInfo* self)
{
	g_free (self);
}


static GType
vala_parser_token_info_get_type (void)
{
	static volatile gsize vala_parser_token_info_type_id__volatile = 0;
	if (g_once_init_enter (&vala_parser_token_info_type_id__volatile)) {
		GType vala_parser_token_info_type_id;
		vala_parser_token_info_type_id = g_boxed_type_register_static ("ValaParserTokenInfo", (GBoxedCopyFunc) vala_parser_token_info_dup, (GBoxedFreeFunc) vala_parser_token_info_free);
		g_once_init_leave (&vala_parser_token_info_type_id__volatile, vala_parser_token_info_type_id);
	}
	return vala_parser_token_info_type_id__volatile;
}


static void
vala_parser_class_init (ValaParserClass * klass)
{
	vala_parser_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_parser_finalize;
	g_type_class_add_private (klass, sizeof (ValaParserPrivate));
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor *, ValaSourceFile*)) vala_parser_real_visit_source_file;
}


static void
vala_parser_instance_init (ValaParser * self)
{
	self->priv = VALA_PARSER_GET_PRIVATE (self);
}


static void
vala_parser_finalize (ValaCodeVisitor * obj)
{
	ValaParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_PARSER, ValaParser);
	_vala_scanner_unref0 (self->priv->scanner);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
	_vala_comment_unref0 (self->priv->comment);
	VALA_CODE_VISITOR_CLASS (vala_parser_parent_class)->finalize (obj);
}


/**
 * Code visitor parsing all Vala source files.
 */
GType
vala_parser_get_type (void)
{
	static volatile gsize vala_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaParser), 0, (GInstanceInitFunc) vala_parser_instance_init, NULL };
		GType vala_parser_type_id;
		vala_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaParser", &g_define_type_info, 0);
		g_once_init_leave (&vala_parser_type_id__volatile, vala_parser_type_id);
	}
	return vala_parser_type_id__volatile;
}


GQuark
vala_parse_error_quark (void)
{
	return g_quark_from_static_string ("vala_parse_error-quark");
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



