/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};


static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                                      ValaEnum* en);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                          ValaCallable* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gint _tmp23_;
		gsize _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* res = NULL;
		gsize _tmp28_;
		void* _tmp29_;
		void* ptr = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		void* _tmp32_;
		const gchar* _tmp45_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = str_array_length1;
		_tmp24_ = len;
		_tmp25_ = strlen ((const gchar*) separator);
		_tmp26_ = _tmp25_;
		_tmp27_ = i;
		len = _tmp24_ + (_tmp26_ * (_tmp27_ - 1));
		_tmp28_ = len;
		_tmp29_ = g_malloc (_tmp28_);
		res = _tmp29_;
		_tmp30_ = res;
		_tmp31_ = str_array[0];
		_tmp32_ = g_stpcpy ((void*) _tmp30_, (const gchar*) _tmp31_);
		ptr = _tmp32_;
		{
			gboolean _tmp33_ = FALSE;
			i = 1;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				void* _tmp36_;
				void* _tmp37_;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_;
				const gchar* _tmp40_;
				void* _tmp43_;
				void* _tmp44_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				if (!(_tmp35_ < str_array_length1)) {
					break;
				}
				_tmp36_ = ptr;
				_tmp37_ = g_stpcpy (_tmp36_, (const gchar*) separator);
				ptr = _tmp37_;
				_tmp39_ = i;
				_tmp40_ = str_array[_tmp39_];
				if (_tmp40_ != NULL) {
					gint _tmp41_;
					const gchar* _tmp42_;
					_tmp41_ = i;
					_tmp42_ = str_array[_tmp41_];
					_tmp38_ = (const gchar*) _tmp42_;
				} else {
					_tmp38_ = "";
				}
				_tmp43_ = ptr;
				_tmp44_ = g_stpcpy (_tmp43_, _tmp38_);
				ptr = _tmp44_;
			}
		}
		_tmp45_ = res;
		res = NULL;
		result = (gchar*) _tmp45_;
		return result;
	} else {
		gchar* _tmp46_;
		_tmp46_ = g_strdup ("");
		result = _tmp46_;
		return result;
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp130_;
	GEqualFunc _tmp131_;
	GEqualFunc _tmp132_;
	ValaHashMap* _tmp133_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp134_;
	ValaHashMap* _tmp135_;
	gboolean _tmp136_ = FALSE;
	ValaMethod* _tmp137_;
	gboolean _tmp282_ = FALSE;
	ValaMethod* _tmp283_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp452_;
	ValaCCodeExpression* _tmp453_;
	ValaMethod* _tmp454_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp478_ = FALSE;
	ValaMethod* _tmp479_;
	gboolean _tmp635_ = FALSE;
	ValaMethod* _tmp636_;
	ValaMethod* _tmp688_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp884_;
	ValaIterator* _tmp885_;
	ValaIterator* _tmp1233_;
	gboolean _tmp1243_ = FALSE;
	gboolean _tmp1244_ = FALSE;
	ValaMethod* _tmp1245_;
	gboolean _tmp1372_ = FALSE;
	ValaDelegate* _tmp1373_;
	gboolean _tmp1472_ = FALSE;
	ValaMethod* _tmp1473_;
	gboolean _tmp1489_;
	gboolean _tmp1490_;
	gboolean _tmp1505_;
	ValaDataType* _tmp1530_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1554_;
	ValaDataType* _tmp1555_;
	ValaDataType* _tmp1556_;
	gboolean _tmp1557_;
	gboolean _tmp1558_ = FALSE;
	ValaDataType* _tmp1559_;
	ValaCCodeFunctionCall* _tmp1588_;
	ValaCCodeFunctionCall* _tmp1589_;
	ValaCCodeExpression* out_param_ref = NULL;
	gboolean _tmp1590_;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1605_;
	ValaCCodeFunctionCall* _tmp1606_;
	ValaCCodeFunctionCall* _tmp1630_;
	gboolean _tmp1654_;
	gboolean _tmp1655_;
	gboolean _tmp1681_;
	gboolean _tmp1682_;
	gboolean _tmp1712_;
	gboolean _tmp1718_ = FALSE;
	gboolean _tmp1719_ = FALSE;
	ValaMethod* _tmp1720_;
	gboolean _tmp1758_ = FALSE;
	gboolean _tmp1759_ = FALSE;
	ValaMethod* _tmp1760_;
	ValaMethod* _tmp1779_;
	gboolean _tmp1896_ = FALSE;
	ValaCodeNode* _tmp1897_;
	ValaCodeNode* _tmp1898_;
	ValaList* _tmp1981_;
	ValaIterator* _tmp1982_;
	gboolean _tmp2067_ = FALSE;
	gboolean _tmp2068_ = FALSE;
	ValaMethod* _tmp2069_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_tostring_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_;
			gboolean _tmp57_;
			_tmp56_ = vala_method_call_get_is_constructv_chainup (expr);
			_tmp57_ = _tmp56_;
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp58_;
				ValaMethod* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				ValaCCodeIdentifier* _tmp62_;
				ValaCCodeIdentifier* _tmp63_;
				_tmp58_ = ccall;
				_tmp59_ = m;
				_tmp60_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_ccode_identifier_new (_tmp61_);
				_tmp63_ = _tmp62_;
				vala_ccode_function_call_set_call (_tmp58_, (ValaCCodeExpression*) _tmp63_);
				_vala_ccode_node_unref0 (_tmp63_);
				_g_free0 (_tmp61_);
			}
		}
	} else {
		ValaDataType* _tmp64_;
		_tmp64_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp65_;
			ValaSignalType* _tmp66_;
			gboolean _tmp67_ = FALSE;
			gboolean _tmp68_ = FALSE;
			ValaMemberAccess* _tmp69_;
			_tmp65_ = itype;
			_tmp66_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp66_;
			_tmp69_ = ma;
			if (_tmp69_ != NULL) {
				ValaMemberAccess* _tmp70_;
				ValaExpression* _tmp71_;
				ValaExpression* _tmp72_;
				_tmp70_ = ma;
				_tmp71_ = vala_member_access_get_inner (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp68_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp68_ = FALSE;
			}
			if (_tmp68_) {
				ValaSignalType* _tmp73_;
				ValaSignal* _tmp74_;
				ValaSignal* _tmp75_;
				gboolean _tmp76_;
				gboolean _tmp77_;
				_tmp73_ = sig_type;
				_tmp74_ = vala_signal_type_get_signal_symbol (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_signal_get_is_virtual (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp67_ = _tmp77_;
			} else {
				_tmp67_ = FALSE;
			}
			if (_tmp67_) {
				ValaSignalType* _tmp78_;
				ValaSignal* _tmp79_;
				ValaSignal* _tmp80_;
				ValaMethod* _tmp81_;
				ValaMethod* _tmp82_;
				ValaMethod* _tmp83_;
				_tmp78_ = sig_type;
				_tmp79_ = vala_signal_type_get_signal_symbol (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = vala_signal_get_default_handler (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = _vala_code_node_ref0 (_tmp82_);
				_vala_code_node_unref0 (m);
				m = _tmp83_;
			} else {
				ValaExpression* _tmp84_;
				ValaExpression* _tmp85_;
				ValaCCodeExpression* _tmp86_;
				_tmp84_ = vala_method_call_get_call (expr);
				_tmp85_ = _tmp84_;
				_tmp86_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp85_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp87_;
			_tmp87_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp88_;
				ValaObjectTypeSymbol* _tmp89_;
				ValaObjectTypeSymbol* _tmp90_;
				ValaClass* _tmp91_;
				ValaClass* _tmp92_;
				ValaCreationMethod* _tmp93_;
				ValaCreationMethod* _tmp94_;
				ValaMethod* _tmp95_;
				ValaMethod* _tmp96_;
				ValaCCodeFile* _tmp97_;
				gchar* real_name = NULL;
				ValaMethod* _tmp98_;
				gchar* _tmp99_;
				gboolean _tmp100_;
				gboolean _tmp101_;
				const gchar* _tmp104_;
				ValaCCodeIdentifier* _tmp105_;
				ValaCCodeIdentifier* _tmp106_;
				ValaCCodeFunctionCall* _tmp107_;
				_tmp88_ = itype;
				_tmp89_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp90_ = _tmp89_;
				_tmp91_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp91_;
				_tmp92_ = cl;
				_tmp93_ = vala_class_get_default_construction_method (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = _vala_code_node_ref0 ((ValaMethod*) _tmp94_);
				_vala_code_node_unref0 (m);
				m = _tmp95_;
				_tmp96_ = m;
				_tmp97_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp96_, _tmp97_);
				_tmp98_ = m;
				_tmp99_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp98_);
				real_name = _tmp99_;
				_tmp100_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp101_ = _tmp100_;
				if (_tmp101_) {
					ValaMethod* _tmp102_;
					gchar* _tmp103_;
					_tmp102_ = m;
					_tmp103_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp103_;
				}
				_tmp104_ = real_name;
				_tmp105_ = vala_ccode_identifier_new (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp106_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp107_;
				_vala_ccode_node_unref0 (_tmp106_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp108_;
				_tmp108_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp109_;
					ValaTypeSymbol* _tmp110_;
					ValaTypeSymbol* _tmp111_;
					ValaStruct* _tmp112_;
					ValaStruct* _tmp113_;
					ValaMethod* _tmp114_;
					ValaMethod* _tmp115_;
					ValaMethod* _tmp116_;
					ValaMethod* _tmp117_;
					ValaCCodeFile* _tmp118_;
					ValaMethod* _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					ValaCCodeIdentifier* _tmp122_;
					ValaCCodeIdentifier* _tmp123_;
					ValaCCodeFunctionCall* _tmp124_;
					_tmp109_ = itype;
					_tmp110_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp111_ = _tmp110_;
					_tmp112_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp112_;
					_tmp113_ = st;
					_tmp114_ = vala_struct_get_default_construction_method (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = _vala_code_node_ref0 (_tmp115_);
					_vala_code_node_unref0 (m);
					m = _tmp116_;
					_tmp117_ = m;
					_tmp118_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp117_, _tmp118_);
					_tmp119_ = m;
					_tmp120_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = vala_ccode_identifier_new (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp123_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp124_;
					_vala_ccode_node_unref0 (_tmp123_);
					_g_free0 (_tmp121_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp125_;
					_tmp125_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp125_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp126_;
						ValaDelegate* _tmp127_;
						ValaDelegate* _tmp128_;
						ValaDelegate* _tmp129_;
						_tmp126_ = itype;
						_tmp127_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp128_ = _tmp127_;
						_tmp129_ = _vala_code_node_ref0 (_tmp128_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp129_;
					}
				}
			}
		}
	}
	_tmp130_ = g_direct_hash;
	_tmp131_ = g_direct_equal;
	_tmp132_ = g_direct_equal;
	_tmp133_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp130_, _tmp131_, _tmp132_);
	in_arg_map = _tmp133_;
	_tmp134_ = in_arg_map;
	_tmp135_ = _vala_map_ref0 (_tmp134_);
	out_arg_map = _tmp135_;
	_tmp137_ = m;
	if (_tmp137_ != NULL) {
		ValaMethod* _tmp138_;
		gboolean _tmp139_;
		gboolean _tmp140_;
		_tmp138_ = m;
		_tmp139_ = vala_method_get_coroutine (_tmp138_);
		_tmp140_ = _tmp139_;
		_tmp136_ = _tmp140_;
	} else {
		_tmp136_ = FALSE;
	}
	if (_tmp136_) {
		ValaMethod* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
		ValaCCodeIdentifier* _tmp144_;
		ValaCCodeIdentifier* _tmp145_;
		ValaCCodeFunctionCall* _tmp146_;
		ValaMethod* _tmp147_;
		gchar* _tmp148_;
		gchar* _tmp149_;
		ValaCCodeIdentifier* _tmp150_;
		ValaCCodeIdentifier* _tmp151_;
		ValaCCodeFunctionCall* _tmp152_;
		ValaMemberAccess* _tmp153_;
		ValaExpression* _tmp154_;
		ValaExpression* _tmp155_;
		gboolean _tmp233_ = FALSE;
		ValaMemberAccess* _tmp234_;
		const gchar* _tmp235_;
		const gchar* _tmp236_;
		_tmp141_ = m;
		_tmp142_ = vala_get_ccode_name ((ValaCodeNode*) _tmp141_);
		_tmp143_ = _tmp142_;
		_tmp144_ = vala_ccode_identifier_new (_tmp143_);
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp145_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp146_;
		_vala_ccode_node_unref0 (_tmp145_);
		_g_free0 (_tmp143_);
		_tmp147_ = m;
		_tmp148_ = vala_get_ccode_finish_name (_tmp147_);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_ccode_identifier_new (_tmp149_);
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp151_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp152_;
		_vala_ccode_node_unref0 (_tmp151_);
		_g_free0 (_tmp149_);
		_tmp153_ = ma;
		_tmp154_ = vala_member_access_get_inner (_tmp153_);
		_tmp155_ = _tmp154_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp155_, VALA_TYPE_BASE_ACCESS)) {
			ValaMethod* _tmp156_;
			ValaMethod* _tmp157_;
			ValaMethod* _tmp158_;
			_tmp156_ = m;
			_tmp157_ = vala_method_get_base_method (_tmp156_);
			_tmp158_ = _tmp157_;
			if (_tmp158_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp159_;
				ValaMethod* _tmp160_;
				ValaMethod* _tmp161_;
				ValaSymbol* _tmp162_;
				ValaSymbol* _tmp163_;
				ValaClass* _tmp164_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaClass* _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				ValaCCodeIdentifier* _tmp170_;
				ValaCCodeIdentifier* _tmp171_;
				ValaCCodeFunctionCall* _tmp172_;
				ValaCCodeFunctionCall* _tmp173_;
				ValaCCodeFunctionCall* _tmp174_;
				ValaClass* _tmp175_;
				ValaClass* _tmp176_;
				gchar* _tmp177_;
				gchar* _tmp178_;
				gchar* _tmp179_;
				gchar* _tmp180_;
				ValaCCodeIdentifier* _tmp181_;
				ValaCCodeIdentifier* _tmp182_;
				ValaCCodeFunctionCall* _tmp183_;
				ValaCCodeFunctionCall* _tmp184_;
				ValaMethod* _tmp185_;
				gchar* _tmp186_;
				gchar* _tmp187_;
				ValaCCodeMemberAccess* _tmp188_;
				ValaCCodeMemberAccess* _tmp189_;
				ValaCCodeFunctionCall* _tmp190_;
				ValaCCodeFunctionCall* _tmp191_;
				ValaMethod* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				ValaCCodeMemberAccess* _tmp195_;
				ValaCCodeMemberAccess* _tmp196_;
				_tmp159_ = m;
				_tmp160_ = vala_method_get_base_method (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, VALA_TYPE_CLASS, ValaClass));
				base_class = _tmp164_;
				_tmp165_ = base_class;
				_tmp166_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp165_, NULL);
				_tmp167_ = _tmp166_;
				_tmp168_ = g_strdup_printf ("%s_CLASS", _tmp167_);
				_tmp169_ = _tmp168_;
				_tmp170_ = vala_ccode_identifier_new (_tmp169_);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp171_);
				_tmp173_ = _tmp172_;
				_vala_ccode_node_unref0 (_tmp171_);
				_g_free0 (_tmp169_);
				_g_free0 (_tmp167_);
				vcast = _tmp173_;
				_tmp174_ = vcast;
				_tmp175_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp176_ = _tmp175_;
				_tmp177_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp176_, NULL);
				_tmp178_ = _tmp177_;
				_tmp179_ = g_strdup_printf ("%s_parent_class", _tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = vala_ccode_identifier_new (_tmp180_);
				_tmp182_ = _tmp181_;
				vala_ccode_function_call_add_argument (_tmp174_, (ValaCCodeExpression*) _tmp182_);
				_vala_ccode_node_unref0 (_tmp182_);
				_g_free0 (_tmp180_);
				_g_free0 (_tmp178_);
				_tmp183_ = async_call;
				_tmp184_ = vcast;
				_tmp185_ = m;
				_tmp186_ = vala_get_ccode_vfunc_name (_tmp185_);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp184_, _tmp187_);
				_tmp189_ = _tmp188_;
				vala_ccode_function_call_set_call (_tmp183_, (ValaCCodeExpression*) _tmp189_);
				_vala_ccode_node_unref0 (_tmp189_);
				_g_free0 (_tmp187_);
				_tmp190_ = finish_call;
				_tmp191_ = vcast;
				_tmp192_ = m;
				_tmp193_ = vala_get_ccode_finish_vfunc_name (_tmp192_);
				_tmp194_ = _tmp193_;
				_tmp195_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp191_, _tmp194_);
				_tmp196_ = _tmp195_;
				vala_ccode_function_call_set_call (_tmp190_, (ValaCCodeExpression*) _tmp196_);
				_vala_ccode_node_unref0 (_tmp196_);
				_g_free0 (_tmp194_);
				_vala_ccode_node_unref0 (vcast);
				_vala_code_node_unref0 (base_class);
			} else {
				ValaMethod* _tmp197_;
				ValaMethod* _tmp198_;
				ValaMethod* _tmp199_;
				_tmp197_ = m;
				_tmp198_ = vala_method_get_base_interface_method (_tmp197_);
				_tmp199_ = _tmp198_;
				if (_tmp199_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp200_;
					ValaMethod* _tmp201_;
					ValaMethod* _tmp202_;
					ValaSymbol* _tmp203_;
					ValaSymbol* _tmp204_;
					ValaInterface* _tmp205_;
					gchar* parent_iface_var = NULL;
					ValaClass* _tmp206_;
					ValaClass* _tmp207_;
					gchar* _tmp208_;
					gchar* _tmp209_;
					ValaInterface* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					gchar* _tmp214_;
					ValaCCodeFunctionCall* _tmp215_;
					const gchar* _tmp216_;
					ValaCCodeIdentifier* _tmp217_;
					ValaCCodeIdentifier* _tmp218_;
					ValaMethod* _tmp219_;
					gchar* _tmp220_;
					gchar* _tmp221_;
					ValaCCodeMemberAccess* _tmp222_;
					ValaCCodeMemberAccess* _tmp223_;
					ValaCCodeFunctionCall* _tmp224_;
					const gchar* _tmp225_;
					ValaCCodeIdentifier* _tmp226_;
					ValaCCodeIdentifier* _tmp227_;
					ValaMethod* _tmp228_;
					gchar* _tmp229_;
					gchar* _tmp230_;
					ValaCCodeMemberAccess* _tmp231_;
					ValaCCodeMemberAccess* _tmp232_;
					_tmp200_ = m;
					_tmp201_ = vala_method_get_base_interface_method (_tmp200_);
					_tmp202_ = _tmp201_;
					_tmp203_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp202_);
					_tmp204_ = _tmp203_;
					_tmp205_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_INTERFACE, ValaInterface));
					base_iface = _tmp205_;
					_tmp206_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp207_ = _tmp206_;
					_tmp208_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp207_, NULL);
					_tmp209_ = _tmp208_;
					_tmp210_ = base_iface;
					_tmp211_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp210_, NULL);
					_tmp212_ = _tmp211_;
					_tmp213_ = g_strdup_printf ("%s_%s_parent_iface", _tmp209_, _tmp212_);
					_tmp214_ = _tmp213_;
					_g_free0 (_tmp212_);
					_g_free0 (_tmp209_);
					parent_iface_var = _tmp214_;
					_tmp215_ = async_call;
					_tmp216_ = parent_iface_var;
					_tmp217_ = vala_ccode_identifier_new (_tmp216_);
					_tmp218_ = _tmp217_;
					_tmp219_ = m;
					_tmp220_ = vala_get_ccode_vfunc_name (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp218_, _tmp221_);
					_tmp223_ = _tmp222_;
					vala_ccode_function_call_set_call (_tmp215_, (ValaCCodeExpression*) _tmp223_);
					_vala_ccode_node_unref0 (_tmp223_);
					_g_free0 (_tmp221_);
					_vala_ccode_node_unref0 (_tmp218_);
					_tmp224_ = finish_call;
					_tmp225_ = parent_iface_var;
					_tmp226_ = vala_ccode_identifier_new (_tmp225_);
					_tmp227_ = _tmp226_;
					_tmp228_ = m;
					_tmp229_ = vala_get_ccode_finish_vfunc_name (_tmp228_);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp227_, _tmp230_);
					_tmp232_ = _tmp231_;
					vala_ccode_function_call_set_call (_tmp224_, (ValaCCodeExpression*) _tmp232_);
					_vala_ccode_node_unref0 (_tmp232_);
					_g_free0 (_tmp230_);
					_vala_ccode_node_unref0 (_tmp227_);
					_g_free0 (parent_iface_var);
					_vala_code_node_unref0 (base_iface);
				}
			}
		}
		_tmp234_ = ma;
		_tmp235_ = vala_member_access_get_member_name (_tmp234_);
		_tmp236_ = _tmp235_;
		if (g_strcmp0 (_tmp236_, "begin") == 0) {
			ValaMemberAccess* _tmp237_;
			ValaExpression* _tmp238_;
			ValaExpression* _tmp239_;
			ValaSymbol* _tmp240_;
			ValaSymbol* _tmp241_;
			ValaMemberAccess* _tmp242_;
			ValaSymbol* _tmp243_;
			ValaSymbol* _tmp244_;
			_tmp237_ = ma;
			_tmp238_ = vala_member_access_get_inner (_tmp237_);
			_tmp239_ = _tmp238_;
			_tmp240_ = vala_expression_get_symbol_reference (_tmp239_);
			_tmp241_ = _tmp240_;
			_tmp242_ = ma;
			_tmp243_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp242_);
			_tmp244_ = _tmp243_;
			_tmp233_ = _tmp241_ == _tmp244_;
		} else {
			_tmp233_ = FALSE;
		}
		if (_tmp233_) {
			ValaCCodeFunctionCall* _tmp245_;
			ValaCCodeFunctionCall* _tmp246_;
			ValaMethod* _tmp247_;
			ValaList* _tmp248_;
			_tmp245_ = async_call;
			_tmp246_ = _vala_ccode_node_ref0 (_tmp245_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp246_;
			_tmp247_ = m;
			_tmp248_ = vala_method_get_async_begin_parameters (_tmp247_);
			_vala_iterable_unref0 (params);
			params = _tmp248_;
		} else {
			gboolean _tmp249_ = FALSE;
			ValaMemberAccess* _tmp250_;
			const gchar* _tmp251_;
			const gchar* _tmp252_;
			_tmp250_ = ma;
			_tmp251_ = vala_member_access_get_member_name (_tmp250_);
			_tmp252_ = _tmp251_;
			if (g_strcmp0 (_tmp252_, "end") == 0) {
				ValaMemberAccess* _tmp253_;
				ValaExpression* _tmp254_;
				ValaExpression* _tmp255_;
				ValaSymbol* _tmp256_;
				ValaSymbol* _tmp257_;
				ValaMemberAccess* _tmp258_;
				ValaSymbol* _tmp259_;
				ValaSymbol* _tmp260_;
				_tmp253_ = ma;
				_tmp254_ = vala_member_access_get_inner (_tmp253_);
				_tmp255_ = _tmp254_;
				_tmp256_ = vala_expression_get_symbol_reference (_tmp255_);
				_tmp257_ = _tmp256_;
				_tmp258_ = ma;
				_tmp259_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp258_);
				_tmp260_ = _tmp259_;
				_tmp249_ = _tmp257_ == _tmp260_;
			} else {
				_tmp249_ = FALSE;
			}
			if (_tmp249_) {
				ValaCCodeFunctionCall* _tmp261_;
				ValaCCodeFunctionCall* _tmp262_;
				ValaMethod* _tmp263_;
				ValaList* _tmp264_;
				_tmp261_ = finish_call;
				_tmp262_ = _vala_ccode_node_ref0 (_tmp261_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp262_;
				_tmp263_ = m;
				_tmp264_ = vala_method_get_async_end_parameters (_tmp263_);
				_vala_iterable_unref0 (params);
				params = _tmp264_;
			} else {
				gboolean _tmp265_;
				gboolean _tmp266_;
				_tmp265_ = vala_method_call_get_is_yield_expression (expr);
				_tmp266_ = _tmp265_;
				if (!_tmp266_) {
					ValaCCodeFunctionCall* _tmp267_;
					ValaCCodeFunctionCall* _tmp268_;
					ValaMethod* _tmp269_;
					ValaList* _tmp270_;
					_tmp267_ = async_call;
					_tmp268_ = _vala_ccode_node_ref0 (_tmp267_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp268_;
					_tmp269_ = m;
					_tmp270_ = vala_method_get_async_begin_parameters (_tmp269_);
					_vala_iterable_unref0 (params);
					params = _tmp270_;
				} else {
					ValaCCodeFunctionCall* _tmp271_;
					ValaCCodeFunctionCall* _tmp272_;
					GHashFunc _tmp273_;
					GEqualFunc _tmp274_;
					GEqualFunc _tmp275_;
					ValaHashMap* _tmp276_;
					ValaHashMap* _tmp277_;
					ValaCCodeIdentifier* _tmp278_;
					ValaCCodeIdentifier* _tmp279_;
					ValaCCodeMemberAccess* _tmp280_;
					ValaCCodeMemberAccess* _tmp281_;
					_tmp271_ = finish_call;
					_tmp272_ = _vala_ccode_node_ref0 (_tmp271_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp272_;
					_tmp273_ = g_direct_hash;
					_tmp274_ = g_direct_equal;
					_tmp275_ = g_direct_equal;
					_tmp276_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp273_, _tmp274_, _tmp275_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp276_;
					_tmp277_ = out_arg_map;
					_tmp278_ = vala_ccode_identifier_new ("_data_");
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp279_, "_res_");
					_tmp281_ = _tmp280_;
					vala_map_set ((ValaMap*) _tmp277_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp281_);
					_vala_ccode_node_unref0 (_tmp281_);
					_vala_ccode_node_unref0 (_tmp279_);
				}
			}
		}
	}
	_tmp283_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp283_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp284_;
		ValaSymbol* _tmp285_;
		ValaSymbol* _tmp286_;
		_tmp284_ = m;
		_tmp285_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp284_);
		_tmp286_ = _tmp285_;
		_tmp282_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp286_, VALA_TYPE_CLASS);
	} else {
		_tmp282_ = FALSE;
	}
	if (_tmp282_) {
		ValaMethod* _tmp287_;
		ValaSymbol* _tmp288_;
		ValaSymbol* _tmp289_;
		gboolean _tmp290_;
		gboolean _tmp291_;
		ValaClass* _tmp295_;
		ValaClass* _tmp296_;
		gboolean _tmp297_;
		gboolean _tmp298_;
		_tmp287_ = m;
		_tmp288_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp287_);
		_tmp289_ = _tmp288_;
		_tmp290_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp289_, VALA_TYPE_CLASS, ValaClass));
		_tmp291_ = _tmp290_;
		if (!_tmp291_) {
			ValaCCodeFunctionCall* _tmp292_;
			ValaCCodeExpression* _tmp293_;
			ValaCCodeExpression* _tmp294_;
			_tmp292_ = ccall;
			_tmp293_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
			_tmp294_ = _tmp293_;
			vala_ccode_function_call_add_argument (_tmp292_, _tmp294_);
			_vala_ccode_node_unref0 (_tmp294_);
		}
		_tmp295_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp296_ = _tmp295_;
		_tmp297_ = vala_class_get_is_compact (_tmp296_);
		_tmp298_ = _tmp297_;
		if (!_tmp298_) {
			ValaClass* _tmp299_;
			ValaClass* _tmp300_;
			ValaMethod* _tmp301_;
			ValaSymbol* _tmp302_;
			ValaSymbol* _tmp303_;
			_tmp299_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp300_ = _tmp299_;
			_tmp301_ = m;
			_tmp302_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp301_);
			_tmp303_ = _tmp302_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp300_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp303_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp304_;
					ValaClass* _tmp305_;
					ValaList* _tmp306_;
					gint _base_type_size = 0;
					ValaList* _tmp307_;
					gint _tmp308_;
					gint _tmp309_;
					gint _base_type_index = 0;
					_tmp304_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp305_ = _tmp304_;
					_tmp306_ = vala_class_get_base_types (_tmp305_);
					_base_type_list = _tmp306_;
					_tmp307_ = _base_type_list;
					_tmp308_ = vala_collection_get_size ((ValaCollection*) _tmp307_);
					_tmp309_ = _tmp308_;
					_base_type_size = _tmp309_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp310_;
						gint _tmp311_;
						gint _tmp312_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp313_;
						gint _tmp314_;
						gpointer _tmp315_;
						ValaDataType* _tmp316_;
						ValaTypeSymbol* _tmp317_;
						ValaTypeSymbol* _tmp318_;
						_tmp310_ = _base_type_index;
						_base_type_index = _tmp310_ + 1;
						_tmp311_ = _base_type_index;
						_tmp312_ = _base_type_size;
						if (!(_tmp311_ < _tmp312_)) {
							break;
						}
						_tmp313_ = _base_type_list;
						_tmp314_ = _base_type_index;
						_tmp315_ = vala_list_get (_tmp313_, _tmp314_);
						base_type = (ValaDataType*) _tmp315_;
						_tmp316_ = base_type;
						_tmp317_ = vala_data_type_get_data_type (_tmp316_);
						_tmp318_ = _tmp317_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp318_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp319_;
							gchar* _tmp320_;
							gchar* _tmp321_;
							gboolean _tmp322_;
							ValaHashMap* _tmp327_;
							ValaDataType* _tmp328_;
							ValaList* _tmp329_;
							ValaList* _tmp330_;
							ValaList* _tmp331_;
							type_parameters = NULL;
							_tmp319_ = m;
							_tmp320_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp319_);
							_tmp321_ = _tmp320_;
							_tmp322_ = g_strcmp0 (_tmp321_, "g_object_new") == 0;
							_g_free0 (_tmp321_);
							if (_tmp322_) {
								ValaDataType* _tmp323_;
								ValaTypeSymbol* _tmp324_;
								ValaTypeSymbol* _tmp325_;
								ValaList* _tmp326_;
								_tmp323_ = base_type;
								_tmp324_ = vala_data_type_get_data_type (_tmp323_);
								_tmp325_ = _tmp324_;
								_tmp326_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp325_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp326_;
							}
							_tmp327_ = in_arg_map;
							_tmp328_ = base_type;
							_tmp329_ = vala_data_type_get_type_arguments (_tmp328_);
							_tmp330_ = _tmp329_;
							_tmp331_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp327_, _tmp330_, (ValaCodeNode*) expr, TRUE, _tmp331_);
							_vala_iterable_unref0 (_tmp330_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp332_;
				ValaSymbol* _tmp333_;
				ValaSymbol* _tmp334_;
				ValaClass* _tmp335_;
				type_param_index = 0;
				_tmp332_ = m;
				_tmp333_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp332_);
				_tmp334_ = _tmp333_;
				_tmp335_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp334_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp335_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp336_;
					ValaList* _tmp337_;
					gint _type_param_size = 0;
					ValaList* _tmp338_;
					gint _tmp339_;
					gint _tmp340_;
					gint _type_param_index = 0;
					_tmp336_ = cl;
					_tmp337_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp336_);
					_type_param_list = _tmp337_;
					_tmp338_ = _type_param_list;
					_tmp339_ = vala_collection_get_size ((ValaCollection*) _tmp338_);
					_tmp340_ = _tmp339_;
					_type_param_size = _tmp340_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp341_;
						gint _tmp342_;
						gint _tmp343_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp344_;
						gint _tmp345_;
						gpointer _tmp346_;
						ValaHashMap* _tmp347_;
						gint _tmp348_;
						ValaTypeParameter* _tmp349_;
						const gchar* _tmp350_;
						const gchar* _tmp351_;
						gchar* _tmp352_;
						gchar* _tmp353_;
						gchar* _tmp354_;
						gchar* _tmp355_;
						ValaCCodeIdentifier* _tmp356_;
						ValaCCodeIdentifier* _tmp357_;
						ValaHashMap* _tmp358_;
						gint _tmp359_;
						ValaTypeParameter* _tmp360_;
						const gchar* _tmp361_;
						const gchar* _tmp362_;
						gchar* _tmp363_;
						gchar* _tmp364_;
						gchar* _tmp365_;
						gchar* _tmp366_;
						ValaCCodeIdentifier* _tmp367_;
						ValaCCodeIdentifier* _tmp368_;
						ValaHashMap* _tmp369_;
						gint _tmp370_;
						ValaTypeParameter* _tmp371_;
						const gchar* _tmp372_;
						const gchar* _tmp373_;
						gchar* _tmp374_;
						gchar* _tmp375_;
						gchar* _tmp376_;
						gchar* _tmp377_;
						ValaCCodeIdentifier* _tmp378_;
						ValaCCodeIdentifier* _tmp379_;
						gint _tmp380_;
						_tmp341_ = _type_param_index;
						_type_param_index = _tmp341_ + 1;
						_tmp342_ = _type_param_index;
						_tmp343_ = _type_param_size;
						if (!(_tmp342_ < _tmp343_)) {
							break;
						}
						_tmp344_ = _type_param_list;
						_tmp345_ = _type_param_index;
						_tmp346_ = vala_list_get (_tmp344_, _tmp345_);
						type_param = (ValaTypeParameter*) _tmp346_;
						_tmp347_ = in_arg_map;
						_tmp348_ = type_param_index;
						_tmp349_ = type_param;
						_tmp350_ = vala_symbol_get_name ((ValaSymbol*) _tmp349_);
						_tmp351_ = _tmp350_;
						_tmp352_ = g_utf8_strdown (_tmp351_, (gssize) -1);
						_tmp353_ = _tmp352_;
						_tmp354_ = g_strdup_printf ("%s_type", _tmp353_);
						_tmp355_ = _tmp354_;
						_tmp356_ = vala_ccode_identifier_new (_tmp355_);
						_tmp357_ = _tmp356_;
						vala_map_set ((ValaMap*) _tmp347_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp348_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp357_);
						_vala_ccode_node_unref0 (_tmp357_);
						_g_free0 (_tmp355_);
						_g_free0 (_tmp353_);
						_tmp358_ = in_arg_map;
						_tmp359_ = type_param_index;
						_tmp360_ = type_param;
						_tmp361_ = vala_symbol_get_name ((ValaSymbol*) _tmp360_);
						_tmp362_ = _tmp361_;
						_tmp363_ = g_utf8_strdown (_tmp362_, (gssize) -1);
						_tmp364_ = _tmp363_;
						_tmp365_ = g_strdup_printf ("%s_dup_func", _tmp364_);
						_tmp366_ = _tmp365_;
						_tmp367_ = vala_ccode_identifier_new (_tmp366_);
						_tmp368_ = _tmp367_;
						vala_map_set ((ValaMap*) _tmp358_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp359_) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp368_);
						_vala_ccode_node_unref0 (_tmp368_);
						_g_free0 (_tmp366_);
						_g_free0 (_tmp364_);
						_tmp369_ = in_arg_map;
						_tmp370_ = type_param_index;
						_tmp371_ = type_param;
						_tmp372_ = vala_symbol_get_name ((ValaSymbol*) _tmp371_);
						_tmp373_ = _tmp372_;
						_tmp374_ = g_utf8_strdown (_tmp373_, (gssize) -1);
						_tmp375_ = _tmp374_;
						_tmp376_ = g_strdup_printf ("%s_destroy_func", _tmp375_);
						_tmp377_ = _tmp376_;
						_tmp378_ = vala_ccode_identifier_new (_tmp377_);
						_tmp379_ = _tmp378_;
						vala_map_set ((ValaMap*) _tmp369_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp370_) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp379_);
						_vala_ccode_node_unref0 (_tmp379_);
						_g_free0 (_tmp377_);
						_g_free0 (_tmp375_);
						_tmp380_ = type_param_index;
						type_param_index = _tmp380_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp381_;
			ValaClass* _tmp382_;
			ValaClass* _tmp383_;
			ValaClass* _tmp384_;
			ValaClass* _tmp385_;
			_tmp381_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp382_ = _tmp381_;
			_tmp383_ = vala_class_get_base_class (_tmp382_);
			_tmp384_ = _tmp383_;
			_tmp385_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp384_ == _tmp385_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp386_;
				ValaClass* _tmp387_;
				gchar* _tmp388_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp389_;
				ValaCCodeDeclaration* _tmp390_;
				ValaCCodeDeclaration* _tmp391_;
				const gchar* _tmp392_;
				const gchar* _tmp393_;
				const gchar* _tmp394_;
				const gchar* _tmp395_;
				gchar* _tmp396_;
				gchar* _tmp397_;
				ValaCCodeConstant* _tmp398_;
				ValaCCodeConstant* _tmp399_;
				ValaCCodeVariableDeclarator* _tmp400_;
				ValaCCodeVariableDeclarator* _tmp401_;
				ValaCCodeFunction* _tmp402_;
				ValaCCodeFunction* _tmp403_;
				ValaCCodeDeclaration* _tmp404_;
				ValaCCodeFunctionCall* _tmp405_;
				ValaCCodeIdentifier* _tmp406_;
				ValaCCodeIdentifier* _tmp407_;
				ValaCCodeUnaryExpression* _tmp408_;
				ValaCCodeUnaryExpression* _tmp409_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp410_;
				ValaCCodeIdentifier* _tmp411_;
				ValaCCodeFunctionCall* _tmp412_;
				ValaCCodeFunctionCall* _tmp413_;
				ValaCCodeFunctionCall* _tmp414_;
				ValaClass* _tmp415_;
				ValaClass* _tmp416_;
				gchar* _tmp417_;
				gchar* _tmp418_;
				ValaCCodeIdentifier* _tmp419_;
				ValaCCodeIdentifier* _tmp420_;
				ValaCCodeFunctionCall* _tmp421_;
				ValaCCodeFunctionCall* _tmp422_;
				_tmp386_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp387_ = _tmp386_;
				_tmp388_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp387_, NULL);
				class_prefix = _tmp388_;
				_tmp389_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp389_;
				_tmp390_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp390_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp391_ = funcs;
				_tmp392_ = class_prefix;
				_tmp393_ = class_prefix;
				_tmp394_ = class_prefix;
				_tmp395_ = class_prefix;
				_tmp396_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp392_, _tmp393_, _tmp394_, _tmp395_);
				_tmp397_ = _tmp396_;
				_tmp398_ = vala_ccode_constant_new (_tmp397_);
				_tmp399_ = _tmp398_;
				_tmp400_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp399_, NULL);
				_tmp401_ = _tmp400_;
				vala_ccode_declaration_add_declarator (_tmp391_, (ValaCCodeDeclarator*) _tmp401_);
				_vala_ccode_node_unref0 (_tmp401_);
				_vala_ccode_node_unref0 (_tmp399_);
				_g_free0 (_tmp397_);
				_tmp402_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp403_ = _tmp402_;
				_tmp404_ = funcs;
				vala_ccode_function_add_statement (_tmp403_, (ValaCCodeNode*) _tmp404_);
				_tmp405_ = ccall;
				_tmp406_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp407_ = _tmp406_;
				_tmp408_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp407_);
				_tmp409_ = _tmp408_;
				vala_ccode_function_call_add_argument (_tmp405_, (ValaCCodeExpression*) _tmp409_);
				_vala_ccode_node_unref0 (_tmp409_);
				_vala_ccode_node_unref0 (_tmp407_);
				_tmp410_ = vala_ccode_identifier_new ("sizeof");
				_tmp411_ = _tmp410_;
				_tmp412_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp411_);
				_tmp413_ = _tmp412_;
				_vala_ccode_node_unref0 (_tmp411_);
				csizeof = _tmp413_;
				_tmp414_ = csizeof;
				_tmp415_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp416_ = _tmp415_;
				_tmp417_ = vala_get_ccode_name ((ValaCodeNode*) _tmp416_);
				_tmp418_ = _tmp417_;
				_tmp419_ = vala_ccode_identifier_new (_tmp418_);
				_tmp420_ = _tmp419_;
				vala_ccode_function_call_add_argument (_tmp414_, (ValaCCodeExpression*) _tmp420_);
				_vala_ccode_node_unref0 (_tmp420_);
				_g_free0 (_tmp418_);
				_tmp421_ = ccall;
				_tmp422_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp421_, (ValaCCodeExpression*) _tmp422_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp423_ = FALSE;
		ValaMethod* _tmp424_;
		_tmp424_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp424_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp425_;
			ValaSymbol* _tmp426_;
			ValaSymbol* _tmp427_;
			_tmp425_ = m;
			_tmp426_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp425_);
			_tmp427_ = _tmp426_;
			_tmp423_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp427_, VALA_TYPE_STRUCT);
		} else {
			_tmp423_ = FALSE;
		}
		if (_tmp423_) {
			ValaCCodeFunctionCall* _tmp428_;
			ValaCCodeExpression* _tmp429_;
			ValaCCodeExpression* _tmp430_;
			_tmp428_ = ccall;
			_tmp429_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp430_ = _tmp429_;
			vala_ccode_function_call_add_argument (_tmp428_, _tmp430_);
			_vala_ccode_node_unref0 (_tmp430_);
		} else {
			gboolean _tmp431_ = FALSE;
			gboolean _tmp432_ = FALSE;
			gboolean _tmp433_ = FALSE;
			gboolean _tmp434_ = FALSE;
			ValaMethod* _tmp435_;
			_tmp435_ = m;
			if (_tmp435_ != NULL) {
				ValaMethod* _tmp436_;
				ValaList* _tmp437_;
				ValaList* _tmp438_;
				gint _tmp439_;
				gint _tmp440_;
				_tmp436_ = m;
				_tmp437_ = vala_method_get_type_parameters (_tmp436_);
				_tmp438_ = _tmp437_;
				_tmp439_ = vala_collection_get_size ((ValaCollection*) _tmp438_);
				_tmp440_ = _tmp439_;
				_tmp434_ = _tmp440_ > 0;
				_vala_iterable_unref0 (_tmp438_);
			} else {
				_tmp434_ = FALSE;
			}
			if (_tmp434_) {
				ValaMethod* _tmp441_;
				_tmp441_ = m;
				_tmp433_ = !vala_get_ccode_has_generic_type_parameter (_tmp441_);
			} else {
				_tmp433_ = FALSE;
			}
			if (_tmp433_) {
				ValaMethod* _tmp442_;
				_tmp442_ = m;
				_tmp432_ = !vala_get_ccode_simple_generics (_tmp442_);
			} else {
				_tmp432_ = FALSE;
			}
			if (_tmp432_) {
				gboolean _tmp443_ = FALSE;
				ValaCCodeFunctionCall* _tmp444_;
				ValaCCodeFunctionCall* _tmp445_;
				_tmp444_ = ccall;
				_tmp445_ = finish_call;
				if (_tmp444_ != _tmp445_) {
					_tmp443_ = TRUE;
				} else {
					gboolean _tmp446_;
					gboolean _tmp447_;
					_tmp446_ = vala_method_call_get_is_yield_expression (expr);
					_tmp447_ = _tmp446_;
					_tmp443_ = _tmp447_;
				}
				_tmp431_ = _tmp443_;
			} else {
				_tmp431_ = FALSE;
			}
			if (_tmp431_) {
				ValaHashMap* _tmp448_;
				ValaMemberAccess* _tmp449_;
				ValaList* _tmp450_;
				ValaList* _tmp451_;
				_tmp448_ = in_arg_map;
				_tmp449_ = ma;
				_tmp450_ = vala_member_access_get_type_arguments (_tmp449_);
				_tmp451_ = _tmp450_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp448_, _tmp451_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp451_);
			}
		}
	}
	_tmp452_ = ccall;
	_tmp453_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp452_);
	ccall_expr = _tmp453_;
	_tmp454_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp454_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp455_;
		ValaExpression* _tmp456_;
		ValaExpression* _tmp457_;
		ValaDataType* _tmp458_;
		ValaDataType* _tmp459_;
		ValaArrayType* _tmp460_;
		ValaHashMap* _tmp461_;
		ValaArrayType* _tmp462_;
		ValaDataType* _tmp463_;
		ValaDataType* _tmp464_;
		gchar* _tmp465_;
		gchar* _tmp466_;
		ValaCCodeIdentifier* _tmp467_;
		ValaCCodeIdentifier* _tmp468_;
		_tmp455_ = ma;
		_tmp456_ = vala_member_access_get_inner (_tmp455_);
		_tmp457_ = _tmp456_;
		_tmp458_ = vala_expression_get_value_type (_tmp457_);
		_tmp459_ = _tmp458_;
		_tmp460_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp459_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp460_;
		_tmp461_ = in_arg_map;
		_tmp462_ = array_type;
		_tmp463_ = vala_array_type_get_element_type (_tmp462_);
		_tmp464_ = _tmp463_;
		_tmp465_ = vala_get_ccode_name ((ValaCodeNode*) _tmp464_);
		_tmp466_ = _tmp465_;
		_tmp467_ = vala_ccode_identifier_new (_tmp466_);
		_tmp468_ = _tmp467_;
		vala_map_set ((ValaMap*) _tmp461_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp468_);
		_vala_ccode_node_unref0 (_tmp468_);
		_g_free0 (_tmp466_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp469_;
		_tmp469_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp469_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp470_;
			_tmp470_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp470_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp471_;
				ValaExpression* _tmp472_;
				ValaExpression* _tmp473_;
				ValaTargetValue* _tmp474_;
				ValaTargetValue* _tmp475_;
				ValaTargetValue* _tmp476_;
				ValaTargetValue* _tmp477_;
				_tmp471_ = ma;
				_tmp472_ = vala_member_access_get_inner (_tmp471_);
				_tmp473_ = _tmp472_;
				_tmp474_ = vala_expression_get_target_value (_tmp473_);
				_tmp475_ = _tmp474_;
				_tmp476_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp475_, (ValaCodeNode*) expr);
				_tmp477_ = _tmp476_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp477_);
				_vala_target_value_unref0 (_tmp477_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp479_ = m;
	if (_tmp479_ != NULL) {
		ValaMethod* _tmp480_;
		gboolean _tmp481_;
		gboolean _tmp482_;
		_tmp480_ = m;
		_tmp481_ = vala_method_get_is_async_callback (_tmp480_);
		_tmp482_ = _tmp481_;
		_tmp478_ = _tmp482_;
	} else {
		_tmp478_ = FALSE;
	}
	if (_tmp478_) {
		ValaMethod* _tmp483_;
		ValaMethod* _tmp484_;
		gboolean _tmp485_;
		gboolean _tmp486_;
		ValaHashMap* _tmp500_;
		ValaMethod* _tmp501_;
		ValaCCodeExpression* _tmp502_;
		ValaHashMap* _tmp503_;
		ValaMethod* _tmp504_;
		ValaCCodeExpression* _tmp505_;
		_tmp483_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp484_ = _tmp483_;
		_tmp485_ = vala_method_get_closure (_tmp484_);
		_tmp486_ = _tmp485_;
		if (_tmp486_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp487_;
			ValaSymbol* _tmp488_;
			ValaSymbol* _tmp489_;
			ValaBlock* _tmp490_;
			ValaBlock* _tmp491_;
			ValaBlock* _tmp492_;
			ValaBlock* _tmp493_;
			gchar* _tmp494_;
			gchar* _tmp495_;
			ValaCCodeExpression* _tmp496_;
			ValaCCodeExpression* _tmp497_;
			ValaCCodeMemberAccess* _tmp498_;
			_tmp487_ = m;
			_tmp488_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp487_);
			_tmp489_ = _tmp488_;
			_tmp490_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp489_, VALA_TYPE_METHOD, ValaMethod));
			_tmp491_ = _tmp490_;
			_tmp492_ = _vala_code_node_ref0 (_tmp491_);
			block = _tmp492_;
			_tmp493_ = block;
			_tmp494_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp493_));
			_tmp495_ = _tmp494_;
			_tmp496_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp495_);
			_tmp497_ = _tmp496_;
			_tmp498_ = vala_ccode_member_access_new_pointer (_tmp497_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp498_;
			_vala_ccode_node_unref0 (_tmp497_);
			_g_free0 (_tmp495_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp499_;
			_tmp499_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp499_;
		}
		_tmp500_ = in_arg_map;
		_tmp501_ = m;
		_tmp502_ = instance;
		vala_map_set ((ValaMap*) _tmp500_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp501_), FALSE)), _tmp502_);
		_tmp503_ = out_arg_map;
		_tmp504_ = m;
		_tmp505_ = instance;
		vala_map_set ((ValaMap*) _tmp503_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp504_), FALSE)), _tmp505_);
	} else {
		gboolean _tmp506_ = FALSE;
		gboolean _tmp507_ = FALSE;
		ValaMethod* _tmp508_;
		_tmp508_ = m;
		if (_tmp508_ != NULL) {
			ValaMethod* _tmp509_;
			ValaMemberBinding _tmp510_;
			ValaMemberBinding _tmp511_;
			_tmp509_ = m;
			_tmp510_ = vala_method_get_binding (_tmp509_);
			_tmp511_ = _tmp510_;
			_tmp507_ = _tmp511_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp507_ = FALSE;
		}
		if (_tmp507_) {
			ValaMethod* _tmp512_;
			_tmp512_ = m;
			_tmp506_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp512_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp506_ = FALSE;
		}
		if (_tmp506_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp513_;
			ValaExpression* _tmp514_;
			ValaExpression* _tmp515_;
			ValaTargetValue* _tmp516_;
			ValaTargetValue* _tmp517_;
			ValaTargetValue* _tmp518_;
			gboolean _tmp519_ = FALSE;
			gboolean _tmp520_ = FALSE;
			ValaMemberAccess* _tmp521_;
			const gchar* _tmp522_;
			const gchar* _tmp523_;
			ValaTargetValue* _tmp545_;
			ValaCCodeExpression* _tmp546_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp547_;
			ValaSymbol* _tmp548_;
			ValaSymbol* _tmp549_;
			ValaStruct* _tmp550_;
			gboolean _tmp551_ = FALSE;
			ValaStruct* _tmp552_;
			gboolean _tmp561_;
			gboolean _tmp562_;
			_tmp513_ = ma;
			_tmp514_ = vala_member_access_get_inner (_tmp513_);
			_tmp515_ = _tmp514_;
			_tmp516_ = vala_expression_get_target_value (_tmp515_);
			_tmp517_ = _tmp516_;
			_tmp518_ = _vala_target_value_ref0 (_tmp517_);
			instance_value = _tmp518_;
			_tmp521_ = ma;
			_tmp522_ = vala_member_access_get_member_name (_tmp521_);
			_tmp523_ = _tmp522_;
			if (g_strcmp0 (_tmp523_, "begin") == 0) {
				_tmp520_ = TRUE;
			} else {
				ValaMemberAccess* _tmp524_;
				const gchar* _tmp525_;
				const gchar* _tmp526_;
				_tmp524_ = ma;
				_tmp525_ = vala_member_access_get_member_name (_tmp524_);
				_tmp526_ = _tmp525_;
				_tmp520_ = g_strcmp0 (_tmp526_, "end") == 0;
			}
			if (_tmp520_) {
				ValaMemberAccess* _tmp527_;
				ValaExpression* _tmp528_;
				ValaExpression* _tmp529_;
				ValaSymbol* _tmp530_;
				ValaSymbol* _tmp531_;
				ValaMemberAccess* _tmp532_;
				ValaSymbol* _tmp533_;
				ValaSymbol* _tmp534_;
				_tmp527_ = ma;
				_tmp528_ = vala_member_access_get_inner (_tmp527_);
				_tmp529_ = _tmp528_;
				_tmp530_ = vala_expression_get_symbol_reference (_tmp529_);
				_tmp531_ = _tmp530_;
				_tmp532_ = ma;
				_tmp533_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp532_);
				_tmp534_ = _tmp533_;
				_tmp519_ = _tmp531_ == _tmp534_;
			} else {
				_tmp519_ = FALSE;
			}
			if (_tmp519_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp535_;
				ValaExpression* _tmp536_;
				ValaExpression* _tmp537_;
				ValaMemberAccess* _tmp538_;
				ValaMemberAccess* _tmp539_;
				ValaExpression* _tmp540_;
				ValaExpression* _tmp541_;
				ValaTargetValue* _tmp542_;
				ValaTargetValue* _tmp543_;
				ValaTargetValue* _tmp544_;
				_tmp535_ = ma;
				_tmp536_ = vala_member_access_get_inner (_tmp535_);
				_tmp537_ = _tmp536_;
				_tmp538_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp537_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp538_;
				_tmp539_ = inner_ma;
				_tmp540_ = vala_member_access_get_inner (_tmp539_);
				_tmp541_ = _tmp540_;
				_tmp542_ = vala_expression_get_target_value (_tmp541_);
				_tmp543_ = _tmp542_;
				_tmp544_ = _vala_target_value_ref0 (_tmp543_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp544_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp545_ = instance_value;
			_tmp546_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp545_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp546_;
			_tmp547_ = m;
			_tmp548_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp547_);
			_tmp549_ = _tmp548_;
			_tmp550_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp549_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp549_) : NULL);
			st = _tmp550_;
			_tmp552_ = st;
			if (_tmp552_ != NULL) {
				ValaStruct* _tmp553_;
				_tmp553_ = st;
				_tmp551_ = !vala_struct_is_simple_type (_tmp553_);
			} else {
				_tmp551_ = FALSE;
			}
			if (_tmp551_) {
				ValaTargetValue* _tmp554_;
				ValaTargetValue* _tmp557_;
				ValaCCodeExpression* _tmp558_;
				ValaCCodeExpression* _tmp559_;
				ValaCCodeUnaryExpression* _tmp560_;
				_tmp554_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp554_)) {
					ValaTargetValue* _tmp555_;
					ValaTargetValue* _tmp556_;
					_tmp555_ = instance_value;
					_tmp556_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp555_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp556_;
				}
				_tmp557_ = instance_value;
				_tmp558_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp557_);
				_tmp559_ = _tmp558_;
				_tmp560_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp559_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp560_;
				_vala_ccode_node_unref0 (_tmp559_);
			}
			_tmp561_ = vala_method_call_get_is_yield_expression (expr);
			_tmp562_ = _tmp561_;
			if (_tmp562_) {
				ValaHashMap* _tmp563_;
				ValaMethod* _tmp564_;
				ValaCCodeExpression* _tmp565_;
				ValaMethod* _tmp566_;
				_tmp563_ = in_arg_map;
				_tmp564_ = m;
				_tmp565_ = instance;
				vala_map_set ((ValaMap*) _tmp563_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp564_), FALSE)), _tmp565_);
				_tmp566_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp566_)) {
					ValaHashMap* _tmp567_;
					ValaMethod* _tmp568_;
					ValaCCodeExpression* _tmp569_;
					_tmp567_ = out_arg_map;
					_tmp568_ = m;
					_tmp569_ = instance;
					vala_map_set ((ValaMap*) _tmp567_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp568_), FALSE)), _tmp569_);
				}
			} else {
				gboolean _tmp570_ = FALSE;
				ValaMemberAccess* _tmp571_;
				const gchar* _tmp572_;
				const gchar* _tmp573_;
				_tmp571_ = ma;
				_tmp572_ = vala_member_access_get_member_name (_tmp571_);
				_tmp573_ = _tmp572_;
				if (g_strcmp0 (_tmp573_, "end") != 0) {
					_tmp570_ = TRUE;
				} else {
					ValaMethod* _tmp574_;
					_tmp574_ = m;
					_tmp570_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp574_);
				}
				if (_tmp570_) {
					ValaHashMap* _tmp575_;
					ValaMethod* _tmp576_;
					ValaCCodeExpression* _tmp577_;
					ValaHashMap* _tmp578_;
					ValaMethod* _tmp579_;
					ValaCCodeExpression* _tmp580_;
					_tmp575_ = out_arg_map;
					_tmp576_ = m;
					_tmp577_ = instance;
					vala_map_set ((ValaMap*) _tmp575_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp576_), FALSE)), _tmp577_);
					_tmp578_ = in_arg_map;
					_tmp579_ = m;
					_tmp580_ = instance;
					vala_map_set ((ValaMap*) _tmp578_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp579_), FALSE)), _tmp580_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp581_ = FALSE;
			ValaMethod* _tmp582_;
			_tmp582_ = m;
			if (_tmp582_ != NULL) {
				ValaMethod* _tmp583_;
				ValaMemberBinding _tmp584_;
				ValaMemberBinding _tmp585_;
				_tmp583_ = m;
				_tmp584_ = vala_method_get_binding (_tmp583_);
				_tmp585_ = _tmp584_;
				_tmp581_ = _tmp585_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp581_ = FALSE;
			}
			if (_tmp581_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp586_;
				ValaSymbol* _tmp587_;
				ValaSymbol* _tmp588_;
				ValaClass* _tmp589_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp590_;
				gchar* _tmp591_;
				gchar* _tmp592_;
				gchar* _tmp593_;
				gchar* _tmp594_;
				ValaCCodeIdentifier* _tmp595_;
				ValaCCodeIdentifier* _tmp596_;
				ValaCCodeFunctionCall* _tmp597_;
				ValaCCodeFunctionCall* _tmp598_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp599_;
				ValaExpression* _tmp600_;
				ValaExpression* _tmp601_;
				ValaCCodeFunctionCall* _tmp627_;
				ValaCCodeExpression* _tmp628_;
				ValaHashMap* _tmp629_;
				ValaMethod* _tmp630_;
				ValaCCodeFunctionCall* _tmp631_;
				ValaHashMap* _tmp632_;
				ValaMethod* _tmp633_;
				ValaCCodeFunctionCall* _tmp634_;
				_tmp586_ = m;
				_tmp587_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp586_);
				_tmp588_ = _tmp587_;
				_tmp589_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp588_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp589_;
				_tmp590_ = cl;
				_tmp591_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp590_, NULL);
				_tmp592_ = _tmp591_;
				_tmp593_ = g_strconcat (_tmp592_, "_CLASS", NULL);
				_tmp594_ = _tmp593_;
				_tmp595_ = vala_ccode_identifier_new (_tmp594_);
				_tmp596_ = _tmp595_;
				_tmp597_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp596_);
				_tmp598_ = _tmp597_;
				_vala_ccode_node_unref0 (_tmp596_);
				_g_free0 (_tmp594_);
				_g_free0 (_tmp592_);
				cast = _tmp598_;
				_tmp599_ = ma;
				_tmp600_ = vala_member_access_get_inner (_tmp599_);
				_tmp601_ = _tmp600_;
				if (_tmp601_ == NULL) {
					ValaDataType* _tmp602_;
					ValaDataType* _tmp603_;
					gboolean _tmp604_;
					_tmp602_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp603_ = _tmp602_;
					_tmp604_ = _tmp603_ == NULL;
					_vala_code_node_unref0 (_tmp603_);
					if (_tmp604_) {
						ValaCCodeIdentifier* _tmp605_;
						_tmp605_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp605_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp606_;
						ValaCCodeIdentifier* _tmp607_;
						ValaCCodeFunctionCall* _tmp608_;
						ValaCCodeFunctionCall* _tmp609_;
						ValaCCodeFunctionCall* _tmp610_;
						ValaCCodeExpression* _tmp611_;
						ValaCCodeExpression* _tmp612_;
						ValaCCodeFunctionCall* _tmp613_;
						ValaCCodeExpression* _tmp614_;
						_tmp606_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp607_ = _tmp606_;
						_tmp608_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp607_);
						_tmp609_ = _tmp608_;
						_vala_ccode_node_unref0 (_tmp607_);
						k = _tmp609_;
						_tmp610_ = k;
						_tmp611_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp612_ = _tmp611_;
						vala_ccode_function_call_add_argument (_tmp610_, _tmp612_);
						_vala_ccode_node_unref0 (_tmp612_);
						_tmp613_ = k;
						_tmp614_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp613_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp614_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp615_;
					ValaCCodeIdentifier* _tmp616_;
					ValaCCodeFunctionCall* _tmp617_;
					ValaCCodeFunctionCall* _tmp618_;
					ValaCCodeFunctionCall* _tmp619_;
					ValaMemberAccess* _tmp620_;
					ValaExpression* _tmp621_;
					ValaExpression* _tmp622_;
					ValaCCodeExpression* _tmp623_;
					ValaCCodeExpression* _tmp624_;
					ValaCCodeFunctionCall* _tmp625_;
					ValaCCodeExpression* _tmp626_;
					_tmp615_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp616_ = _tmp615_;
					_tmp617_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp616_);
					_tmp618_ = _tmp617_;
					_vala_ccode_node_unref0 (_tmp616_);
					k = _tmp618_;
					_tmp619_ = k;
					_tmp620_ = ma;
					_tmp621_ = vala_member_access_get_inner (_tmp620_);
					_tmp622_ = _tmp621_;
					_tmp623_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp622_);
					_tmp624_ = _tmp623_;
					vala_ccode_function_call_add_argument (_tmp619_, _tmp624_);
					_vala_ccode_node_unref0 (_tmp624_);
					_tmp625_ = k;
					_tmp626_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp625_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp626_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp627_ = cast;
				_tmp628_ = klass;
				vala_ccode_function_call_add_argument (_tmp627_, _tmp628_);
				_tmp629_ = in_arg_map;
				_tmp630_ = m;
				_tmp631_ = cast;
				vala_map_set ((ValaMap*) _tmp629_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp630_), FALSE)), (ValaCCodeExpression*) _tmp631_);
				_tmp632_ = out_arg_map;
				_tmp633_ = m;
				_tmp634_ = cast;
				vala_map_set ((ValaMap*) _tmp632_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp633_), FALSE)), (ValaCCodeExpression*) _tmp634_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp636_ = m;
	if (_tmp636_ != NULL) {
		ValaMethod* _tmp637_;
		_tmp637_ = m;
		_tmp635_ = vala_get_ccode_has_generic_type_parameter (_tmp637_);
	} else {
		_tmp635_ = FALSE;
	}
	if (_tmp635_) {
		ValaMethod* _tmp638_;
		ValaList* _tmp639_;
		ValaList* _tmp640_;
		gint _tmp641_;
		gint _tmp642_;
		gboolean _tmp643_;
		_tmp638_ = m;
		_tmp639_ = vala_method_get_type_parameters (_tmp638_);
		_tmp640_ = _tmp639_;
		_tmp641_ = vala_collection_get_size ((ValaCollection*) _tmp640_);
		_tmp642_ = _tmp641_;
		_tmp643_ = _tmp642_ > 0;
		_vala_iterable_unref0 (_tmp640_);
		if (_tmp643_) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp644_;
				ValaList* _tmp645_;
				gint _type_arg_size = 0;
				ValaList* _tmp646_;
				gint _tmp647_;
				gint _tmp648_;
				gint _type_arg_index = 0;
				_tmp644_ = ma;
				_tmp645_ = vala_member_access_get_type_arguments (_tmp644_);
				_type_arg_list = _tmp645_;
				_tmp646_ = _type_arg_list;
				_tmp647_ = vala_collection_get_size ((ValaCollection*) _tmp646_);
				_tmp648_ = _tmp647_;
				_type_arg_size = _tmp648_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp649_;
					gint _tmp650_;
					gint _tmp651_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp652_;
					gint _tmp653_;
					gpointer _tmp654_;
					ValaHashMap* _tmp655_;
					ValaMethod* _tmp656_;
					gint _tmp657_;
					ValaDataType* _tmp658_;
					gchar* _tmp659_;
					gchar* _tmp660_;
					ValaCCodeIdentifier* _tmp661_;
					ValaCCodeIdentifier* _tmp662_;
					gint _tmp663_;
					_tmp649_ = _type_arg_index;
					_type_arg_index = _tmp649_ + 1;
					_tmp650_ = _type_arg_index;
					_tmp651_ = _type_arg_size;
					if (!(_tmp650_ < _tmp651_)) {
						break;
					}
					_tmp652_ = _type_arg_list;
					_tmp653_ = _type_arg_index;
					_tmp654_ = vala_list_get (_tmp652_, _tmp653_);
					type_arg = (ValaDataType*) _tmp654_;
					_tmp655_ = in_arg_map;
					_tmp656_ = m;
					_tmp657_ = type_param_index;
					_tmp658_ = type_arg;
					_tmp659_ = vala_get_ccode_name ((ValaCodeNode*) _tmp658_);
					_tmp660_ = _tmp659_;
					_tmp661_ = vala_ccode_identifier_new (_tmp660_);
					_tmp662_ = _tmp661_;
					vala_map_set ((ValaMap*) _tmp655_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp656_) + (0.01 * _tmp657_), FALSE)), (ValaCCodeExpression*) _tmp662_);
					_vala_ccode_node_unref0 (_tmp662_);
					_g_free0 (_tmp660_);
					_tmp663_ = type_param_index;
					type_param_index = _tmp663_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp664_;
				ValaExpression* _tmp665_;
				ValaExpression* _tmp666_;
				ValaDataType* _tmp667_;
				ValaDataType* _tmp668_;
				ValaList* _tmp669_;
				gint _type_arg_size = 0;
				ValaList* _tmp670_;
				gint _tmp671_;
				gint _tmp672_;
				gint _type_arg_index = 0;
				_tmp664_ = ma;
				_tmp665_ = vala_member_access_get_inner (_tmp664_);
				_tmp666_ = _tmp665_;
				_tmp667_ = vala_expression_get_value_type (_tmp666_);
				_tmp668_ = _tmp667_;
				_tmp669_ = vala_data_type_get_type_arguments (_tmp668_);
				_type_arg_list = _tmp669_;
				_tmp670_ = _type_arg_list;
				_tmp671_ = vala_collection_get_size ((ValaCollection*) _tmp670_);
				_tmp672_ = _tmp671_;
				_type_arg_size = _tmp672_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp673_;
					gint _tmp674_;
					gint _tmp675_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp676_;
					gint _tmp677_;
					gpointer _tmp678_;
					ValaHashMap* _tmp679_;
					ValaMethod* _tmp680_;
					gint _tmp681_;
					ValaDataType* _tmp682_;
					gchar* _tmp683_;
					gchar* _tmp684_;
					ValaCCodeIdentifier* _tmp685_;
					ValaCCodeIdentifier* _tmp686_;
					gint _tmp687_;
					_tmp673_ = _type_arg_index;
					_type_arg_index = _tmp673_ + 1;
					_tmp674_ = _type_arg_index;
					_tmp675_ = _type_arg_size;
					if (!(_tmp674_ < _tmp675_)) {
						break;
					}
					_tmp676_ = _type_arg_list;
					_tmp677_ = _type_arg_index;
					_tmp678_ = vala_list_get (_tmp676_, _tmp677_);
					type_arg = (ValaDataType*) _tmp678_;
					_tmp679_ = in_arg_map;
					_tmp680_ = m;
					_tmp681_ = type_param_index;
					_tmp682_ = type_arg;
					_tmp683_ = vala_get_ccode_name ((ValaCodeNode*) _tmp682_);
					_tmp684_ = _tmp683_;
					_tmp685_ = vala_ccode_identifier_new (_tmp684_);
					_tmp686_ = _tmp685_;
					vala_map_set ((ValaMap*) _tmp679_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp680_) + (0.01 * _tmp681_), FALSE)), (ValaCCodeExpression*) _tmp686_);
					_vala_ccode_node_unref0 (_tmp686_);
					_g_free0 (_tmp684_);
					_tmp687_ = type_param_index;
					type_param_index = _tmp687_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp688_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp688_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp689_;
		ValaExpression* _tmp690_;
		ValaExpression* _tmp691_;
		ValaDataType* _tmp692_;
		ValaDataType* _tmp693_;
		ValaArrayType* _tmp694_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp695_;
		ValaCCodeIdentifier* _tmp696_;
		ValaCCodeFunctionCall* _tmp697_;
		ValaCCodeFunctionCall* _tmp698_;
		ValaCCodeFunctionCall* _tmp699_;
		ValaArrayType* _tmp700_;
		ValaDataType* _tmp701_;
		ValaDataType* _tmp702_;
		gchar* _tmp703_;
		gchar* _tmp704_;
		ValaCCodeIdentifier* _tmp705_;
		ValaCCodeIdentifier* _tmp706_;
		ValaHashMap* _tmp707_;
		ValaCCodeFunctionCall* _tmp708_;
		_tmp689_ = ma;
		_tmp690_ = vala_member_access_get_inner (_tmp689_);
		_tmp691_ = _tmp690_;
		_tmp692_ = vala_expression_get_value_type (_tmp691_);
		_tmp693_ = _tmp692_;
		_tmp694_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp693_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp694_;
		_tmp695_ = vala_ccode_identifier_new ("sizeof");
		_tmp696_ = _tmp695_;
		_tmp697_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp696_);
		_tmp698_ = _tmp697_;
		_vala_ccode_node_unref0 (_tmp696_);
		csizeof = _tmp698_;
		_tmp699_ = csizeof;
		_tmp700_ = array_type;
		_tmp701_ = vala_array_type_get_element_type (_tmp700_);
		_tmp702_ = _tmp701_;
		_tmp703_ = vala_get_ccode_name ((ValaCodeNode*) _tmp702_);
		_tmp704_ = _tmp703_;
		_tmp705_ = vala_ccode_identifier_new (_tmp704_);
		_tmp706_ = _tmp705_;
		vala_ccode_function_call_add_argument (_tmp699_, (ValaCCodeExpression*) _tmp706_);
		_vala_ccode_node_unref0 (_tmp706_);
		_g_free0 (_tmp704_);
		_tmp707_ = in_arg_map;
		_tmp708_ = csizeof;
		vala_map_set ((ValaMap*) _tmp707_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp708_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp709_;
		_tmp709_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp709_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaMethod* _tmp710_;
			gint param_nr = 0;
			ValaMethod* _tmp781_;
			_tmp710_ = m;
			vala_method_clear_parameters (_tmp710_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp711_;
				gint _arg_size = 0;
				ValaList* _tmp712_;
				gint _tmp713_;
				gint _tmp714_;
				gint _arg_index = 0;
				_tmp711_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp711_;
				_tmp712_ = _arg_list;
				_tmp713_ = vala_collection_get_size ((ValaCollection*) _tmp712_);
				_tmp714_ = _tmp713_;
				_arg_size = _tmp714_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp715_;
					gint _tmp716_;
					gint _tmp717_;
					ValaExpression* arg = NULL;
					ValaList* _tmp718_;
					gint _tmp719_;
					gpointer _tmp720_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp721_;
					ValaUnaryExpression* _tmp722_;
					gboolean _tmp723_ = FALSE;
					ValaUnaryExpression* _tmp724_;
					gint _tmp768_;
					_tmp715_ = _arg_index;
					_arg_index = _tmp715_ + 1;
					_tmp716_ = _arg_index;
					_tmp717_ = _arg_size;
					if (!(_tmp716_ < _tmp717_)) {
						break;
					}
					_tmp718_ = _arg_list;
					_tmp719_ = _arg_index;
					_tmp720_ = vala_list_get (_tmp718_, _tmp719_);
					arg = (ValaExpression*) _tmp720_;
					_tmp721_ = arg;
					_tmp722_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp721_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp721_) : NULL);
					unary = _tmp722_;
					_tmp724_ = unary;
					if (_tmp724_ != NULL) {
						ValaUnaryExpression* _tmp725_;
						ValaUnaryOperator _tmp726_;
						ValaUnaryOperator _tmp727_;
						_tmp725_ = unary;
						_tmp726_ = vala_unary_expression_get_operator (_tmp725_);
						_tmp727_ = _tmp726_;
						_tmp723_ = _tmp727_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp723_ = FALSE;
					}
					if (_tmp723_) {
						ValaParameter* param = NULL;
						gint _tmp728_;
						gchar* _tmp729_;
						gchar* _tmp730_;
						ValaUnaryExpression* _tmp731_;
						ValaExpression* _tmp732_;
						ValaExpression* _tmp733_;
						ValaDataType* _tmp734_;
						ValaDataType* _tmp735_;
						ValaParameter* _tmp736_;
						ValaParameter* _tmp737_;
						ValaParameter* _tmp738_;
						ValaMethod* _tmp739_;
						ValaParameter* _tmp740_;
						_tmp728_ = param_nr;
						_tmp729_ = g_strdup_printf ("param%d", _tmp728_);
						_tmp730_ = _tmp729_;
						_tmp731_ = unary;
						_tmp732_ = vala_unary_expression_get_inner (_tmp731_);
						_tmp733_ = _tmp732_;
						_tmp734_ = vala_expression_get_value_type (_tmp733_);
						_tmp735_ = _tmp734_;
						_tmp736_ = vala_parameter_new (_tmp730_, _tmp735_, NULL);
						_tmp737_ = _tmp736_;
						_g_free0 (_tmp730_);
						param = _tmp737_;
						_tmp738_ = param;
						vala_parameter_set_direction (_tmp738_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp739_ = m;
						_tmp740_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp739_, _tmp740_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp741_ = FALSE;
						ValaUnaryExpression* _tmp742_;
						_tmp742_ = unary;
						if (_tmp742_ != NULL) {
							ValaUnaryExpression* _tmp743_;
							ValaUnaryOperator _tmp744_;
							ValaUnaryOperator _tmp745_;
							_tmp743_ = unary;
							_tmp744_ = vala_unary_expression_get_operator (_tmp743_);
							_tmp745_ = _tmp744_;
							_tmp741_ = _tmp745_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp741_ = FALSE;
						}
						if (_tmp741_) {
							ValaParameter* param = NULL;
							gint _tmp746_;
							gchar* _tmp747_;
							gchar* _tmp748_;
							ValaUnaryExpression* _tmp749_;
							ValaExpression* _tmp750_;
							ValaExpression* _tmp751_;
							ValaDataType* _tmp752_;
							ValaDataType* _tmp753_;
							ValaParameter* _tmp754_;
							ValaParameter* _tmp755_;
							ValaParameter* _tmp756_;
							ValaMethod* _tmp757_;
							ValaParameter* _tmp758_;
							_tmp746_ = param_nr;
							_tmp747_ = g_strdup_printf ("param%d", _tmp746_);
							_tmp748_ = _tmp747_;
							_tmp749_ = unary;
							_tmp750_ = vala_unary_expression_get_inner (_tmp749_);
							_tmp751_ = _tmp750_;
							_tmp752_ = vala_expression_get_value_type (_tmp751_);
							_tmp753_ = _tmp752_;
							_tmp754_ = vala_parameter_new (_tmp748_, _tmp753_, NULL);
							_tmp755_ = _tmp754_;
							_g_free0 (_tmp748_);
							param = _tmp755_;
							_tmp756_ = param;
							vala_parameter_set_direction (_tmp756_, VALA_PARAMETER_DIRECTION_REF);
							_tmp757_ = m;
							_tmp758_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp757_, _tmp758_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp759_;
							gint _tmp760_;
							gchar* _tmp761_;
							gchar* _tmp762_;
							ValaExpression* _tmp763_;
							ValaDataType* _tmp764_;
							ValaDataType* _tmp765_;
							ValaParameter* _tmp766_;
							ValaParameter* _tmp767_;
							_tmp759_ = m;
							_tmp760_ = param_nr;
							_tmp761_ = g_strdup_printf ("param%d", _tmp760_);
							_tmp762_ = _tmp761_;
							_tmp763_ = arg;
							_tmp764_ = vala_expression_get_value_type (_tmp763_);
							_tmp765_ = _tmp764_;
							_tmp766_ = vala_parameter_new (_tmp762_, _tmp765_, NULL);
							_tmp767_ = _tmp766_;
							vala_callable_add_parameter ((ValaCallable*) _tmp759_, _tmp767_);
							_vala_code_node_unref0 (_tmp767_);
							_g_free0 (_tmp762_);
						}
					}
					_tmp768_ = param_nr;
					param_nr = _tmp768_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp769_;
				ValaList* _tmp770_;
				gint _param_size = 0;
				ValaList* _tmp771_;
				gint _tmp772_;
				gint _tmp773_;
				gint _param_index = 0;
				_tmp769_ = m;
				_tmp770_ = vala_callable_get_parameters ((ValaCallable*) _tmp769_);
				_param_list = _tmp770_;
				_tmp771_ = _param_list;
				_tmp772_ = vala_collection_get_size ((ValaCollection*) _tmp771_);
				_tmp773_ = _tmp772_;
				_param_size = _tmp773_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp774_;
					gint _tmp775_;
					gint _tmp776_;
					ValaParameter* param = NULL;
					ValaList* _tmp777_;
					gint _tmp778_;
					gpointer _tmp779_;
					ValaParameter* _tmp780_;
					_tmp774_ = _param_index;
					_param_index = _tmp774_ + 1;
					_tmp775_ = _param_index;
					_tmp776_ = _param_size;
					if (!(_tmp775_ < _tmp776_)) {
						break;
					}
					_tmp777_ = _param_list;
					_tmp778_ = _param_index;
					_tmp779_ = vala_list_get (_tmp777_, _tmp778_);
					param = (ValaParameter*) _tmp779_;
					_tmp780_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp780_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp781_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp781_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
		} else {
			gboolean _tmp782_ = FALSE;
			ValaMethod* _tmp783_;
			_tmp783_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp783_, VALA_TYPE_CREATION_METHOD)) {
				ValaMethod* _tmp784_;
				ValaSymbol* _tmp785_;
				ValaSymbol* _tmp786_;
				_tmp784_ = m;
				_tmp785_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp784_);
				_tmp786_ = _tmp785_;
				_tmp782_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp786_, VALA_TYPE_CLASS);
			} else {
				_tmp782_ = FALSE;
			}
			if (_tmp782_) {
				ValaCCodeFunction* _tmp787_;
				ValaCCodeFunction* _tmp788_;
				ValaCCodeExpression* _tmp789_;
				ValaCCodeExpression* _tmp790_;
				ValaCCodeFunctionCall* _tmp791_;
				ValaClass* _tmp792_;
				ValaClass* _tmp793_;
				gchar* _tmp794_;
				gchar* _tmp795_;
				gchar* _tmp796_;
				gchar* _tmp797_;
				ValaCCodeCastExpression* _tmp798_;
				ValaCCodeCastExpression* _tmp799_;
				ValaMethod* _tmp800_;
				ValaMethod* _tmp801_;
				ValaBlock* _tmp802_;
				ValaBlock* _tmp803_;
				gboolean _tmp804_;
				gboolean _tmp805_;
				gboolean _tmp832_ = FALSE;
				ValaClass* _tmp833_;
				ValaClass* _tmp834_;
				gboolean _tmp835_;
				gboolean _tmp836_;
				_tmp787_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp788_ = _tmp787_;
				_tmp789_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp790_ = _tmp789_;
				_tmp791_ = ccall;
				_tmp792_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp793_ = _tmp792_;
				_tmp794_ = vala_get_ccode_name ((ValaCodeNode*) _tmp793_);
				_tmp795_ = _tmp794_;
				_tmp796_ = g_strconcat (_tmp795_, "*", NULL);
				_tmp797_ = _tmp796_;
				_tmp798_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp791_, _tmp797_);
				_tmp799_ = _tmp798_;
				vala_ccode_function_add_assignment (_tmp788_, _tmp790_, (ValaCCodeExpression*) _tmp799_);
				_vala_ccode_node_unref0 (_tmp799_);
				_g_free0 (_tmp797_);
				_g_free0 (_tmp795_);
				_vala_ccode_node_unref0 (_tmp790_);
				_tmp800_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp801_ = _tmp800_;
				_tmp802_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp801_);
				_tmp803_ = _tmp802_;
				_tmp804_ = vala_block_get_captured (_tmp803_);
				_tmp805_ = _tmp804_;
				if (_tmp805_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp806_;
					ValaClass* _tmp807_;
					ValaObjectType* _tmp808_;
					ValaObjectType* _tmp809_;
					ValaSourceReference* _tmp810_;
					ValaSourceReference* _tmp811_;
					ValaCCodeExpression* _tmp812_;
					ValaCCodeExpression* _tmp813_;
					ValaCCodeFunctionCall* _tmp814_;
					ValaCCodeFunctionCall* _tmp815_;
					ValaCCodeFunctionCall* _tmp816_;
					ValaCCodeExpression* _tmp817_;
					ValaCCodeExpression* _tmp818_;
					ValaCCodeFunction* _tmp819_;
					ValaCCodeFunction* _tmp820_;
					ValaMethod* _tmp821_;
					ValaMethod* _tmp822_;
					ValaBlock* _tmp823_;
					ValaBlock* _tmp824_;
					gchar* _tmp825_;
					gchar* _tmp826_;
					ValaCCodeExpression* _tmp827_;
					ValaCCodeExpression* _tmp828_;
					ValaCCodeMemberAccess* _tmp829_;
					ValaCCodeMemberAccess* _tmp830_;
					ValaCCodeFunctionCall* _tmp831_;
					_tmp806_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp807_ = _tmp806_;
					_tmp808_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp807_);
					_tmp809_ = _tmp808_;
					_tmp810_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp811_ = _tmp810_;
					_tmp812_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp809_, _tmp811_, FALSE);
					_tmp813_ = _tmp812_;
					_tmp814_ = vala_ccode_function_call_new (_tmp813_);
					_tmp815_ = _tmp814_;
					_vala_ccode_node_unref0 (_tmp813_);
					_vala_code_node_unref0 (_tmp809_);
					ref_call = _tmp815_;
					_tmp816_ = ref_call;
					_tmp817_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp818_ = _tmp817_;
					vala_ccode_function_call_add_argument (_tmp816_, _tmp818_);
					_vala_ccode_node_unref0 (_tmp818_);
					_tmp819_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp820_ = _tmp819_;
					_tmp821_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp822_ = _tmp821_;
					_tmp823_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp822_);
					_tmp824_ = _tmp823_;
					_tmp825_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp824_));
					_tmp826_ = _tmp825_;
					_tmp827_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp826_);
					_tmp828_ = _tmp827_;
					_tmp829_ = vala_ccode_member_access_new_pointer (_tmp828_, "self");
					_tmp830_ = _tmp829_;
					_tmp831_ = ref_call;
					vala_ccode_function_add_assignment (_tmp820_, (ValaCCodeExpression*) _tmp830_, (ValaCCodeExpression*) _tmp831_);
					_vala_ccode_node_unref0 (_tmp830_);
					_vala_ccode_node_unref0 (_tmp828_);
					_g_free0 (_tmp826_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp833_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp834_ = _tmp833_;
				_tmp835_ = vala_class_get_is_compact (_tmp834_);
				_tmp836_ = _tmp835_;
				if (!_tmp836_) {
					ValaClass* _tmp837_;
					ValaClass* _tmp838_;
					ValaList* _tmp839_;
					ValaList* _tmp840_;
					gint _tmp841_;
					gint _tmp842_;
					_tmp837_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp838_ = _tmp837_;
					_tmp839_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp838_);
					_tmp840_ = _tmp839_;
					_tmp841_ = vala_collection_get_size ((ValaCollection*) _tmp840_);
					_tmp842_ = _tmp841_;
					_tmp832_ = _tmp842_ > 0;
					_vala_iterable_unref0 (_tmp840_);
				} else {
					_tmp832_ = FALSE;
				}
				if (_tmp832_) {
					gchar** suffices = NULL;
					gchar* _tmp843_;
					gchar* _tmp844_;
					gchar* _tmp845_;
					gchar** _tmp846_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp843_ = g_strdup ("type");
					_tmp844_ = g_strdup ("dup_func");
					_tmp845_ = g_strdup ("destroy_func");
					_tmp846_ = g_new0 (gchar*, 3 + 1);
					_tmp846_[0] = _tmp843_;
					_tmp846_[1] = _tmp844_;
					_tmp846_[2] = _tmp845_;
					suffices = _tmp846_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp847_;
						ValaClass* _tmp848_;
						ValaList* _tmp849_;
						gint _type_param_size = 0;
						ValaList* _tmp850_;
						gint _tmp851_;
						gint _tmp852_;
						gint _type_param_index = 0;
						_tmp847_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp848_ = _tmp847_;
						_tmp849_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp848_);
						_type_param_list = _tmp849_;
						_tmp850_ = _type_param_list;
						_tmp851_ = vala_collection_get_size ((ValaCollection*) _tmp850_);
						_tmp852_ = _tmp851_;
						_type_param_size = _tmp852_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp853_;
							gint _tmp854_;
							gint _tmp855_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp856_;
							gint _tmp857_;
							gpointer _tmp858_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp859_;
							ValaCCodeIdentifier* _tmp860_;
							ValaCCodeMemberAccess* _tmp861_;
							ValaCCodeMemberAccess* _tmp862_;
							gchar** _tmp863_;
							gint _tmp863__length1;
							_tmp853_ = _type_param_index;
							_type_param_index = _tmp853_ + 1;
							_tmp854_ = _type_param_index;
							_tmp855_ = _type_param_size;
							if (!(_tmp854_ < _tmp855_)) {
								break;
							}
							_tmp856_ = _type_param_list;
							_tmp857_ = _type_param_index;
							_tmp858_ = vala_list_get (_tmp856_, _tmp857_);
							type_param = (ValaTypeParameter*) _tmp858_;
							_tmp859_ = vala_ccode_identifier_new ("self");
							_tmp860_ = _tmp859_;
							_tmp861_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp860_, "priv");
							_tmp862_ = _tmp861_;
							_vala_ccode_node_unref0 (_tmp860_);
							priv_access = _tmp862_;
							_tmp863_ = suffices;
							_tmp863__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp863_;
								suffix_collection_length1 = _tmp863__length1;
								for (suffix_it = 0; suffix_it < _tmp863__length1; suffix_it = suffix_it + 1) {
									gchar* _tmp864_;
									gchar* suffix = NULL;
									_tmp864_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp864_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp865_;
										const gchar* _tmp866_;
										const gchar* _tmp867_;
										gchar* _tmp868_;
										gchar* _tmp869_;
										const gchar* _tmp870_;
										gchar* _tmp871_;
										gchar* _tmp872_;
										ValaCCodeIdentifier* _tmp873_;
										ValaCCodeIdentifier* _tmp874_;
										ValaCCodeFunction* _tmp875_;
										ValaCCodeFunction* _tmp876_;
										ValaCCodeMemberAccess* _tmp877_;
										ValaCCodeIdentifier* _tmp878_;
										const gchar* _tmp879_;
										const gchar* _tmp880_;
										ValaCCodeMemberAccess* _tmp881_;
										ValaCCodeMemberAccess* _tmp882_;
										ValaCCodeIdentifier* _tmp883_;
										_tmp865_ = type_param;
										_tmp866_ = vala_symbol_get_name ((ValaSymbol*) _tmp865_);
										_tmp867_ = _tmp866_;
										_tmp868_ = g_utf8_strdown (_tmp867_, (gssize) -1);
										_tmp869_ = _tmp868_;
										_tmp870_ = suffix;
										_tmp871_ = g_strdup_printf ("%s_%s", _tmp869_, _tmp870_);
										_tmp872_ = _tmp871_;
										_tmp873_ = vala_ccode_identifier_new (_tmp872_);
										_tmp874_ = _tmp873_;
										_g_free0 (_tmp872_);
										_g_free0 (_tmp869_);
										param_name = _tmp874_;
										_tmp875_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp876_ = _tmp875_;
										_tmp877_ = priv_access;
										_tmp878_ = param_name;
										_tmp879_ = vala_ccode_identifier_get_name (_tmp878_);
										_tmp880_ = _tmp879_;
										_tmp881_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp877_, _tmp880_);
										_tmp882_ = _tmp881_;
										_tmp883_ = param_name;
										vala_ccode_function_add_assignment (_tmp876_, (ValaCCodeExpression*) _tmp882_, (ValaCCodeExpression*) _tmp883_);
										_vala_ccode_node_unref0 (_tmp882_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp884_ = params;
	_tmp885_ = vala_iterable_iterator ((ValaIterable*) _tmp884_);
	params_it = _tmp885_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp886_;
		gint _arg_size = 0;
		ValaList* _tmp887_;
		gint _tmp888_;
		gint _tmp889_;
		gint _arg_index = 0;
		_tmp886_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp886_;
		_tmp887_ = _arg_list;
		_tmp888_ = vala_collection_get_size ((ValaCollection*) _tmp887_);
		_tmp889_ = _tmp888_;
		_arg_size = _tmp889_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp890_;
			gint _tmp891_;
			gint _tmp892_;
			ValaExpression* arg = NULL;
			ValaList* _tmp893_;
			gint _tmp894_;
			gpointer _tmp895_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp896_;
			ValaCCodeExpression* _tmp897_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp898_;
			ValaHashMap* _tmp899_;
			ValaIterator* _tmp900_;
			ValaHashMap* _tmp1208_;
			gint _tmp1209_;
			ValaCCodeExpression* _tmp1210_;
			gboolean _tmp1211_ = FALSE;
			ValaExpression* _tmp1212_;
			gint _tmp1232_;
			_tmp890_ = _arg_index;
			_arg_index = _tmp890_ + 1;
			_tmp891_ = _arg_index;
			_tmp892_ = _arg_size;
			if (!(_tmp891_ < _tmp892_)) {
				break;
			}
			_tmp893_ = _arg_list;
			_tmp894_ = _arg_index;
			_tmp895_ = vala_list_get (_tmp893_, _tmp894_);
			arg = (ValaExpression*) _tmp895_;
			_tmp896_ = arg;
			_tmp897_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp896_);
			cexpr = _tmp897_;
			_tmp898_ = in_arg_map;
			_tmp899_ = _vala_map_ref0 (_tmp898_);
			carg_map = _tmp899_;
			_tmp900_ = params_it;
			if (vala_iterator_next (_tmp900_)) {
				ValaParameter* param = NULL;
				ValaIterator* _tmp901_;
				gpointer _tmp902_;
				gboolean _tmp903_ = FALSE;
				ValaParameter* _tmp904_;
				gboolean _tmp905_;
				gboolean _tmp906_;
				gboolean _tmp910_;
				ValaParameter* _tmp1201_;
				gboolean _tmp1202_;
				_tmp901_ = params_it;
				_tmp902_ = vala_iterator_get (_tmp901_);
				param = (ValaParameter*) _tmp902_;
				_tmp904_ = param;
				_tmp905_ = vala_parameter_get_params_array (_tmp904_);
				_tmp906_ = _tmp905_;
				if (_tmp906_) {
					_tmp903_ = TRUE;
				} else {
					ValaParameter* _tmp907_;
					gboolean _tmp908_;
					gboolean _tmp909_;
					_tmp907_ = param;
					_tmp908_ = vala_parameter_get_ellipsis (_tmp907_);
					_tmp909_ = _tmp908_;
					_tmp903_ = _tmp909_;
				}
				ellipsis = _tmp903_;
				_tmp910_ = ellipsis;
				if (!_tmp910_) {
					ValaParameter* _tmp911_;
					ValaParameterDirection _tmp912_;
					ValaParameterDirection _tmp913_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp916_;
					ValaUnaryExpression* _tmp917_;
					gboolean _tmp918_ = FALSE;
					ValaUnaryExpression* _tmp919_;
					ValaParameter* _tmp1189_;
					gchar* _tmp1190_;
					gchar* _tmp1191_;
					gboolean _tmp1192_;
					_tmp911_ = param;
					_tmp912_ = vala_parameter_get_direction (_tmp911_);
					_tmp913_ = _tmp912_;
					if (_tmp913_ == VALA_PARAMETER_DIRECTION_OUT) {
						ValaHashMap* _tmp914_;
						ValaHashMap* _tmp915_;
						_tmp914_ = out_arg_map;
						_tmp915_ = _vala_map_ref0 (_tmp914_);
						_vala_map_unref0 (carg_map);
						carg_map = _tmp915_;
					}
					_tmp916_ = arg;
					_tmp917_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp916_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp916_) : NULL);
					unary = _tmp917_;
					_tmp919_ = unary;
					if (_tmp919_ == NULL) {
						_tmp918_ = TRUE;
					} else {
						ValaUnaryExpression* _tmp920_;
						ValaUnaryOperator _tmp921_;
						ValaUnaryOperator _tmp922_;
						_tmp920_ = unary;
						_tmp921_ = vala_unary_expression_get_operator (_tmp920_);
						_tmp922_ = _tmp921_;
						_tmp918_ = _tmp922_ != VALA_UNARY_OPERATOR_OUT;
					}
					if (_tmp918_) {
						gboolean _tmp923_ = FALSE;
						ValaParameter* _tmp924_;
						ValaParameter* _tmp1063_;
						ValaExpression* _tmp1064_;
						ValaCCodeExpression* _tmp1065_;
						ValaCCodeExpression* _tmp1066_;
						_tmp924_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp924_)) {
							ValaParameter* _tmp925_;
							ValaDataType* _tmp926_;
							ValaDataType* _tmp927_;
							_tmp925_ = param;
							_tmp926_ = vala_variable_get_variable_type ((ValaVariable*) _tmp925_);
							_tmp927_ = _tmp926_;
							_tmp923_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp927_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp923_ = FALSE;
						}
						if (_tmp923_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp928_;
							ValaDataType* _tmp929_;
							ValaDataType* _tmp930_;
							ValaArrayType* _tmp931_;
							_tmp928_ = param;
							_tmp929_ = vala_variable_get_variable_type ((ValaVariable*) _tmp928_);
							_tmp930_ = _tmp929_;
							_tmp931_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp930_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp931_;
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp932_ = FALSE;
									_tmp932_ = TRUE;
									while (TRUE) {
										gint _tmp934_;
										ValaArrayType* _tmp935_;
										gint _tmp936_;
										gint _tmp937_;
										ValaCCodeExpression* array_length_expr = NULL;
										ValaParameter* _tmp938_;
										gchar* _tmp939_;
										gchar* _tmp940_;
										gboolean _tmp941_;
										ValaHashMap* _tmp960_;
										ValaParameter* _tmp961_;
										gint _tmp962_;
										ValaCCodeExpression* _tmp963_;
										if (!_tmp932_) {
											gint _tmp933_;
											_tmp933_ = dim;
											dim = _tmp933_ + 1;
										}
										_tmp932_ = FALSE;
										_tmp934_ = dim;
										_tmp935_ = array_type;
										_tmp936_ = vala_array_type_get_rank (_tmp935_);
										_tmp937_ = _tmp936_;
										if (!(_tmp934_ <= _tmp937_)) {
											break;
										}
										array_length_expr = NULL;
										_tmp938_ = param;
										_tmp939_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp938_);
										_tmp940_ = _tmp939_;
										_tmp941_ = _tmp940_ != NULL;
										_g_free0 (_tmp940_);
										if (_tmp941_) {
											gchar* length_ctype = NULL;
											ValaParameter* _tmp942_;
											gchar* _tmp943_;
											gboolean _tmp944_ = FALSE;
											ValaUnaryExpression* _tmp945_;
											ValaExpression* _tmp951_;
											gint _tmp952_;
											ValaCCodeExpression* _tmp953_;
											ValaCCodeExpression* _tmp954_;
											const gchar* _tmp955_;
											ValaCCodeCastExpression* _tmp956_;
											_tmp942_ = param;
											_tmp943_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp942_);
											length_ctype = _tmp943_;
											_tmp945_ = unary;
											if (_tmp945_ != NULL) {
												ValaUnaryExpression* _tmp946_;
												ValaUnaryOperator _tmp947_;
												ValaUnaryOperator _tmp948_;
												_tmp946_ = unary;
												_tmp947_ = vala_unary_expression_get_operator (_tmp946_);
												_tmp948_ = _tmp947_;
												_tmp944_ = _tmp948_ == VALA_UNARY_OPERATOR_REF;
											} else {
												_tmp944_ = FALSE;
											}
											if (_tmp944_) {
												const gchar* _tmp949_;
												gchar* _tmp950_;
												_tmp949_ = length_ctype;
												_tmp950_ = g_strdup_printf ("%s*", _tmp949_);
												_g_free0 (length_ctype);
												length_ctype = _tmp950_;
											}
											_tmp951_ = arg;
											_tmp952_ = dim;
											_tmp953_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp951_, _tmp952_);
											_tmp954_ = _tmp953_;
											_tmp955_ = length_ctype;
											_tmp956_ = vala_ccode_cast_expression_new (_tmp954_, _tmp955_);
											_vala_ccode_node_unref0 (array_length_expr);
											array_length_expr = (ValaCCodeExpression*) _tmp956_;
											_vala_ccode_node_unref0 (_tmp954_);
											_g_free0 (length_ctype);
										} else {
											ValaExpression* _tmp957_;
											gint _tmp958_;
											ValaCCodeExpression* _tmp959_;
											_tmp957_ = arg;
											_tmp958_ = dim;
											_tmp959_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp957_, _tmp958_);
											_vala_ccode_node_unref0 (array_length_expr);
											array_length_expr = _tmp959_;
										}
										_tmp960_ = carg_map;
										_tmp961_ = param;
										_tmp962_ = dim;
										_tmp963_ = array_length_expr;
										vala_map_set ((ValaMap*) _tmp960_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp961_) + (0.01 * _tmp962_), FALSE)), _tmp963_);
										_vala_ccode_node_unref0 (array_length_expr);
									}
								}
							}
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp964_;
							ValaDataType* _tmp965_;
							ValaDataType* _tmp966_;
							_tmp964_ = param;
							_tmp965_ = vala_variable_get_variable_type ((ValaVariable*) _tmp964_);
							_tmp966_ = _tmp965_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp966_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp967_;
								ValaDataType* _tmp968_;
								ValaDataType* _tmp969_;
								ValaDelegateType* _tmp970_;
								ValaDelegate* d = NULL;
								ValaDelegateType* _tmp971_;
								ValaDelegate* _tmp972_;
								ValaDelegate* _tmp973_;
								ValaDelegate* _tmp974_;
								ValaDelegate* _tmp975_;
								gboolean _tmp976_;
								gboolean _tmp977_;
								_tmp967_ = param;
								_tmp968_ = vala_variable_get_variable_type ((ValaVariable*) _tmp967_);
								_tmp969_ = _tmp968_;
								_tmp970_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp969_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp970_;
								_tmp971_ = deleg_type;
								_tmp972_ = vala_delegate_type_get_delegate_symbol (_tmp971_);
								_tmp973_ = _tmp972_;
								_tmp974_ = _vala_code_node_ref0 (_tmp973_);
								d = _tmp974_;
								_tmp975_ = d;
								_tmp976_ = vala_delegate_get_has_target (_tmp975_);
								_tmp977_ = _tmp976_;
								if (_tmp977_) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaCCodeExpression* delegate_target = NULL;
									ValaExpression* _tmp978_;
									ValaCCodeExpression* _tmp979_ = NULL;
									ValaCCodeExpression* _tmp980_;
									ValaCCodeExpression* _tmp981_;
									ValaParameter* _tmp982_;
									gchar* _tmp983_;
									gchar* _tmp984_;
									gboolean _tmp985_;
									_tmp978_ = arg;
									_tmp980_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp978_, &_tmp979_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp979_;
									delegate_target = _tmp980_;
									_tmp981_ = delegate_target;
									_vala_assert (_tmp981_ != NULL, "delegate_target != null");
									_tmp982_ = param;
									_tmp983_ = vala_get_ccode_type ((ValaCodeNode*) _tmp982_);
									_tmp984_ = _tmp983_;
									_tmp985_ = g_strcmp0 (_tmp984_, "GClosure*") == 0;
									_g_free0 (_tmp984_);
									if (_tmp985_) {
										ValaCCodeFunctionCall* closure_new = NULL;
										ValaCCodeIdentifier* _tmp986_;
										ValaCCodeIdentifier* _tmp987_;
										ValaCCodeFunctionCall* _tmp988_;
										ValaCCodeFunctionCall* _tmp989_;
										ValaCCodeFunctionCall* _tmp990_;
										ValaCCodeExpression* _tmp991_;
										ValaCCodeCastExpression* _tmp992_;
										ValaCCodeCastExpression* _tmp993_;
										ValaCCodeFunctionCall* _tmp994_;
										ValaCCodeExpression* _tmp995_;
										ValaCCodeFunctionCall* _tmp996_;
										ValaCCodeExpression* _tmp997_;
										ValaCCodeCastExpression* _tmp998_;
										ValaCCodeCastExpression* _tmp999_;
										ValaCCodeExpression* _tmp1000_;
										ValaCCodeIdentifier* _tmp1001_;
										ValaCCodeIdentifier* _tmp1002_;
										ValaCCodeBinaryExpression* _tmp1003_;
										ValaCCodeBinaryExpression* _tmp1004_;
										ValaCCodeIdentifier* _tmp1005_;
										ValaCCodeIdentifier* _tmp1006_;
										ValaCCodeFunctionCall* _tmp1007_;
										ValaCCodeConditionalExpression* _tmp1008_;
										_tmp986_ = vala_ccode_identifier_new ("g_cclosure_new");
										_tmp987_ = _tmp986_;
										_tmp988_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp987_);
										_tmp989_ = _tmp988_;
										_vala_ccode_node_unref0 (_tmp987_);
										closure_new = _tmp989_;
										_tmp990_ = closure_new;
										_tmp991_ = cexpr;
										_tmp992_ = vala_ccode_cast_expression_new (_tmp991_, "GCallback");
										_tmp993_ = _tmp992_;
										vala_ccode_function_call_add_argument (_tmp990_, (ValaCCodeExpression*) _tmp993_);
										_vala_ccode_node_unref0 (_tmp993_);
										_tmp994_ = closure_new;
										_tmp995_ = delegate_target;
										vala_ccode_function_call_add_argument (_tmp994_, _tmp995_);
										_tmp996_ = closure_new;
										_tmp997_ = delegate_target_destroy_notify;
										_tmp998_ = vala_ccode_cast_expression_new (_tmp997_, "GClosureNotify");
										_tmp999_ = _tmp998_;
										vala_ccode_function_call_add_argument (_tmp996_, (ValaCCodeExpression*) _tmp999_);
										_vala_ccode_node_unref0 (_tmp999_);
										_tmp1000_ = cexpr;
										_tmp1001_ = vala_ccode_identifier_new ("NULL");
										_tmp1002_ = _tmp1001_;
										_tmp1003_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1000_, (ValaCCodeExpression*) _tmp1002_);
										_tmp1004_ = _tmp1003_;
										_tmp1005_ = vala_ccode_identifier_new ("NULL");
										_tmp1006_ = _tmp1005_;
										_tmp1007_ = closure_new;
										_tmp1008_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1004_, (ValaCCodeExpression*) _tmp1006_, (ValaCCodeExpression*) _tmp1007_);
										_vala_ccode_node_unref0 (cexpr);
										cexpr = (ValaCCodeExpression*) _tmp1008_;
										_vala_ccode_node_unref0 (_tmp1006_);
										_vala_ccode_node_unref0 (_tmp1004_);
										_vala_ccode_node_unref0 (_tmp1002_);
										_vala_ccode_node_unref0 (closure_new);
									} else {
										ValaHashMap* _tmp1009_;
										ValaParameter* _tmp1010_;
										ValaCCodeExpression* _tmp1011_;
										ValaDelegateType* _tmp1012_;
										_tmp1009_ = carg_map;
										_tmp1010_ = param;
										_tmp1011_ = delegate_target;
										vala_map_set ((ValaMap*) _tmp1009_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1010_), FALSE)), _tmp1011_);
										_tmp1012_ = deleg_type;
										if (vala_data_type_is_disposable ((ValaDataType*) _tmp1012_)) {
											ValaCCodeExpression* _tmp1013_;
											ValaHashMap* _tmp1014_;
											ValaParameter* _tmp1015_;
											ValaCCodeExpression* _tmp1016_;
											_tmp1013_ = delegate_target_destroy_notify;
											_vala_assert (_tmp1013_ != NULL, "delegate_target_destroy_notify != null");
											_tmp1014_ = carg_map;
											_tmp1015_ = param;
											_tmp1016_ = delegate_target_destroy_notify;
											vala_map_set ((ValaMap*) _tmp1014_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1015_) + 0.01, FALSE)), _tmp1016_);
										}
									}
									_vala_ccode_node_unref0 (delegate_target);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								}
								_vala_code_node_unref0 (d);
								_vala_code_node_unref0 (deleg_type);
							} else {
								ValaParameter* _tmp1017_;
								ValaDataType* _tmp1018_;
								ValaDataType* _tmp1019_;
								_tmp1017_ = param;
								_tmp1018_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1017_);
								_tmp1019_ = _tmp1018_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1019_, VALA_TYPE_METHOD_TYPE)) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaHashMap* _tmp1020_;
									ValaParameter* _tmp1021_;
									ValaExpression* _tmp1022_;
									ValaCCodeExpression* _tmp1023_ = NULL;
									ValaCCodeExpression* _tmp1024_;
									ValaCCodeExpression* _tmp1025_;
									_tmp1020_ = carg_map;
									_tmp1021_ = param;
									_tmp1022_ = arg;
									_tmp1024_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1022_, &_tmp1023_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp1023_;
									_tmp1025_ = _tmp1024_;
									vala_map_set ((ValaMap*) _tmp1020_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1021_), FALSE)), _tmp1025_);
									_vala_ccode_node_unref0 (_tmp1025_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								} else {
									ValaParameter* _tmp1026_;
									ValaDataType* _tmp1027_;
									ValaDataType* _tmp1028_;
									_tmp1026_ = param;
									_tmp1027_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1026_);
									_tmp1028_ = _tmp1027_;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1028_, VALA_TYPE_GENERIC_TYPE)) {
										gboolean _tmp1029_ = FALSE;
										ValaMethod* _tmp1030_;
										_tmp1030_ = m;
										if (_tmp1030_ != NULL) {
											ValaMethod* _tmp1031_;
											_tmp1031_ = m;
											_tmp1029_ = vala_get_ccode_simple_generics (_tmp1031_);
										} else {
											_tmp1029_ = FALSE;
										}
										if (_tmp1029_) {
											ValaGenericType* generic_type = NULL;
											ValaParameter* _tmp1032_;
											ValaDataType* _tmp1033_;
											ValaDataType* _tmp1034_;
											ValaGenericType* _tmp1035_;
											gint type_param_index = 0;
											ValaMethod* _tmp1036_;
											ValaGenericType* _tmp1037_;
											ValaTypeParameter* _tmp1038_;
											ValaTypeParameter* _tmp1039_;
											const gchar* _tmp1040_;
											const gchar* _tmp1041_;
											ValaDataType* type_arg = NULL;
											ValaMemberAccess* _tmp1042_;
											ValaList* _tmp1043_;
											ValaList* _tmp1044_;
											gint _tmp1045_;
											gpointer _tmp1046_;
											ValaDataType* _tmp1047_;
											ValaParameter* _tmp1048_;
											ValaDataType* _tmp1049_;
											ValaDataType* _tmp1050_;
											gboolean _tmp1051_;
											gboolean _tmp1052_;
											_tmp1032_ = param;
											_tmp1033_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1032_);
											_tmp1034_ = _tmp1033_;
											_tmp1035_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1034_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
											generic_type = _tmp1035_;
											_tmp1036_ = m;
											_tmp1037_ = generic_type;
											_tmp1038_ = vala_generic_type_get_type_parameter (_tmp1037_);
											_tmp1039_ = _tmp1038_;
											_tmp1040_ = vala_symbol_get_name ((ValaSymbol*) _tmp1039_);
											_tmp1041_ = _tmp1040_;
											type_param_index = vala_method_get_type_parameter_index (_tmp1036_, _tmp1041_);
											_tmp1042_ = ma;
											_tmp1043_ = vala_member_access_get_type_arguments (_tmp1042_);
											_tmp1044_ = _tmp1043_;
											_tmp1045_ = type_param_index;
											_tmp1046_ = vala_list_get (_tmp1044_, _tmp1045_);
											_tmp1047_ = (ValaDataType*) _tmp1046_;
											_vala_iterable_unref0 (_tmp1044_);
											type_arg = _tmp1047_;
											_tmp1048_ = param;
											_tmp1049_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1048_);
											_tmp1050_ = _tmp1049_;
											_tmp1051_ = vala_data_type_get_value_owned (_tmp1050_);
											_tmp1052_ = _tmp1051_;
											if (_tmp1052_) {
												ValaDataType* _tmp1053_;
												_tmp1053_ = type_arg;
												if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1053_)) {
													ValaHashMap* _tmp1054_;
													ValaParameter* _tmp1055_;
													ValaDataType* _tmp1056_;
													ValaCCodeExpression* _tmp1057_;
													ValaCCodeExpression* _tmp1058_;
													_tmp1054_ = carg_map;
													_tmp1055_ = param;
													_tmp1056_ = type_arg;
													_tmp1057_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1056_, FALSE);
													_tmp1058_ = _tmp1057_;
													vala_map_set ((ValaMap*) _tmp1054_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1055_), FALSE)), _tmp1058_);
													_vala_ccode_node_unref0 (_tmp1058_);
												} else {
													ValaHashMap* _tmp1059_;
													ValaParameter* _tmp1060_;
													ValaCCodeConstant* _tmp1061_;
													ValaCCodeConstant* _tmp1062_;
													_tmp1059_ = carg_map;
													_tmp1060_ = param;
													_tmp1061_ = vala_ccode_constant_new ("NULL");
													_tmp1062_ = _tmp1061_;
													vala_map_set ((ValaMap*) _tmp1059_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1060_), FALSE)), (ValaCCodeExpression*) _tmp1062_);
													_vala_ccode_node_unref0 (_tmp1062_);
												}
											}
											_vala_code_node_unref0 (type_arg);
											_vala_code_node_unref0 (generic_type);
										}
									}
								}
							}
						}
						_tmp1063_ = param;
						_tmp1064_ = arg;
						_tmp1065_ = cexpr;
						_tmp1066_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1063_, _tmp1064_, _tmp1065_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = _tmp1066_;
					} else {
						ValaExpression* _tmp1067_;
						ValaLocalVariable* temp_var = NULL;
						ValaParameter* _tmp1068_;
						ValaDataType* _tmp1069_;
						ValaDataType* _tmp1070_;
						ValaParameter* _tmp1071_;
						ValaDataType* _tmp1072_;
						ValaDataType* _tmp1073_;
						gboolean _tmp1074_;
						gboolean _tmp1075_;
						ValaLocalVariable* _tmp1076_;
						ValaLocalVariable* _tmp1077_;
						ValaExpression* _tmp1078_;
						ValaLocalVariable* _tmp1079_;
						const gchar* _tmp1080_;
						const gchar* _tmp1081_;
						ValaCCodeExpression* _tmp1082_;
						ValaCCodeExpression* _tmp1083_;
						ValaExpression* _tmp1084_;
						ValaTargetValue* _tmp1085_;
						ValaTargetValue* _tmp1086_;
						ValaExpression* _tmp1087_;
						ValaDataType* _tmp1088_;
						ValaDataType* _tmp1089_;
						ValaExpression* _tmp1090_;
						ValaCCodeExpression* _tmp1091_;
						ValaCCodeExpression* _tmp1092_;
						ValaCCodeUnaryExpression* _tmp1093_;
						gboolean _tmp1094_ = FALSE;
						ValaParameter* _tmp1095_;
						_tmp1067_ = arg;
						vala_expression_set_target_value (_tmp1067_, NULL);
						_tmp1068_ = param;
						_tmp1069_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1068_);
						_tmp1070_ = _tmp1069_;
						_tmp1071_ = param;
						_tmp1072_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1071_);
						_tmp1073_ = _tmp1072_;
						_tmp1074_ = vala_data_type_get_value_owned (_tmp1073_);
						_tmp1075_ = _tmp1074_;
						_tmp1076_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1070_, _tmp1075_, NULL, TRUE);
						temp_var = _tmp1076_;
						_tmp1077_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1077_);
						_tmp1078_ = arg;
						_tmp1079_ = temp_var;
						_tmp1080_ = vala_symbol_get_name ((ValaSymbol*) _tmp1079_);
						_tmp1081_ = _tmp1080_;
						_tmp1082_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1081_);
						_tmp1083_ = _tmp1082_;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1078_, _tmp1083_);
						_vala_ccode_node_unref0 (_tmp1083_);
						_tmp1084_ = arg;
						_tmp1085_ = vala_expression_get_target_value (_tmp1084_);
						_tmp1086_ = _tmp1085_;
						_tmp1087_ = arg;
						_tmp1088_ = vala_expression_get_target_type (_tmp1087_);
						_tmp1089_ = _tmp1088_;
						vala_target_value_set_value_type (_tmp1086_, _tmp1089_);
						_tmp1090_ = arg;
						_tmp1091_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1090_);
						_tmp1092_ = _tmp1091_;
						_tmp1093_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1092_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1093_;
						_vala_ccode_node_unref0 (_tmp1092_);
						_tmp1095_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1095_)) {
							ValaParameter* _tmp1096_;
							ValaDataType* _tmp1097_;
							ValaDataType* _tmp1098_;
							_tmp1096_ = param;
							_tmp1097_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1096_);
							_tmp1098_ = _tmp1097_;
							_tmp1094_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1098_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp1094_ = FALSE;
						}
						if (_tmp1094_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp1099_;
							ValaDataType* _tmp1100_;
							ValaDataType* _tmp1101_;
							ValaArrayType* _tmp1102_;
							ValaDataType* array_length_type = NULL;
							ValaDataType* _tmp1103_;
							ValaDataType* _tmp1104_;
							ValaParameter* _tmp1105_;
							gchar* _tmp1106_;
							gchar* _tmp1107_;
							gboolean _tmp1108_;
							_tmp1099_ = param;
							_tmp1100_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1099_);
							_tmp1101_ = _tmp1100_;
							_tmp1102_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1101_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp1102_;
							_tmp1103_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1104_ = _vala_code_node_ref0 (_tmp1103_);
							array_length_type = _tmp1104_;
							_tmp1105_ = param;
							_tmp1106_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1105_);
							_tmp1107_ = _tmp1106_;
							_tmp1108_ = _tmp1107_ != NULL;
							_g_free0 (_tmp1107_);
							if (_tmp1108_) {
								ValaParameter* _tmp1109_;
								gchar* _tmp1110_;
								gchar* _tmp1111_;
								ValaCType* _tmp1112_;
								_tmp1109_ = param;
								_tmp1110_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1109_);
								_tmp1111_ = _tmp1110_;
								_tmp1112_ = vala_ctype_new (_tmp1111_);
								_vala_code_node_unref0 (array_length_type);
								array_length_type = (ValaDataType*) _tmp1112_;
								_g_free0 (_tmp1111_);
							}
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp1113_ = FALSE;
									_tmp1113_ = TRUE;
									while (TRUE) {
										gint _tmp1115_;
										ValaArrayType* _tmp1116_;
										gint _tmp1117_;
										gint _tmp1118_;
										ValaLocalVariable* temp_array_length = NULL;
										ValaDataType* _tmp1119_;
										ValaLocalVariable* _tmp1120_;
										ValaLocalVariable* _tmp1121_;
										ValaExpression* _tmp1122_;
										ValaLocalVariable* _tmp1123_;
										const gchar* _tmp1124_;
										const gchar* _tmp1125_;
										ValaCCodeExpression* _tmp1126_;
										ValaCCodeExpression* _tmp1127_;
										ValaHashMap* _tmp1128_;
										ValaParameter* _tmp1129_;
										gint _tmp1130_;
										ValaExpression* _tmp1131_;
										ValaList* _tmp1132_;
										ValaList* _tmp1133_;
										gint _tmp1134_;
										gpointer _tmp1135_;
										ValaCCodeExpression* _tmp1136_;
										ValaCCodeUnaryExpression* _tmp1137_;
										ValaCCodeUnaryExpression* _tmp1138_;
										if (!_tmp1113_) {
											gint _tmp1114_;
											_tmp1114_ = dim;
											dim = _tmp1114_ + 1;
										}
										_tmp1113_ = FALSE;
										_tmp1115_ = dim;
										_tmp1116_ = array_type;
										_tmp1117_ = vala_array_type_get_rank (_tmp1116_);
										_tmp1118_ = _tmp1117_;
										if (!(_tmp1115_ <= _tmp1118_)) {
											break;
										}
										_tmp1119_ = array_length_type;
										_tmp1120_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1119_, TRUE, NULL, FALSE);
										temp_array_length = _tmp1120_;
										_tmp1121_ = temp_array_length;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1121_);
										_tmp1122_ = arg;
										_tmp1123_ = temp_array_length;
										_tmp1124_ = vala_symbol_get_name ((ValaSymbol*) _tmp1123_);
										_tmp1125_ = _tmp1124_;
										_tmp1126_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1125_);
										_tmp1127_ = _tmp1126_;
										vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1122_, _tmp1127_);
										_vala_ccode_node_unref0 (_tmp1127_);
										_tmp1128_ = carg_map;
										_tmp1129_ = param;
										_tmp1130_ = dim;
										_tmp1131_ = arg;
										_tmp1132_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1131_);
										_tmp1133_ = _tmp1132_;
										_tmp1134_ = dim;
										_tmp1135_ = vala_list_get (_tmp1133_, _tmp1134_ - 1);
										_tmp1136_ = (ValaCCodeExpression*) _tmp1135_;
										_tmp1137_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1136_);
										_tmp1138_ = _tmp1137_;
										vala_map_set ((ValaMap*) _tmp1128_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1129_) + (0.01 * _tmp1130_), FALSE)), (ValaCCodeExpression*) _tmp1138_);
										_vala_ccode_node_unref0 (_tmp1138_);
										_vala_ccode_node_unref0 (_tmp1136_);
										_vala_iterable_unref0 (_tmp1133_);
										_vala_code_node_unref0 (temp_array_length);
									}
								}
							}
							_vala_code_node_unref0 (array_length_type);
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp1139_;
							ValaDataType* _tmp1140_;
							ValaDataType* _tmp1141_;
							_tmp1139_ = param;
							_tmp1140_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1139_);
							_tmp1141_ = _tmp1140_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1141_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp1142_;
								ValaDataType* _tmp1143_;
								ValaDataType* _tmp1144_;
								ValaDelegateType* _tmp1145_;
								ValaDelegate* d = NULL;
								ValaDelegateType* _tmp1146_;
								ValaDelegate* _tmp1147_;
								ValaDelegate* _tmp1148_;
								ValaDelegate* _tmp1149_;
								ValaDelegate* _tmp1150_;
								gboolean _tmp1151_;
								gboolean _tmp1152_;
								_tmp1142_ = param;
								_tmp1143_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1142_);
								_tmp1144_ = _tmp1143_;
								_tmp1145_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1144_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp1145_;
								_tmp1146_ = deleg_type;
								_tmp1147_ = vala_delegate_type_get_delegate_symbol (_tmp1146_);
								_tmp1148_ = _tmp1147_;
								_tmp1149_ = _vala_code_node_ref0 (_tmp1148_);
								d = _tmp1149_;
								_tmp1150_ = d;
								_tmp1151_ = vala_delegate_get_has_target (_tmp1150_);
								_tmp1152_ = _tmp1151_;
								if (_tmp1152_) {
									ValaVoidType* _tmp1153_;
									ValaVoidType* _tmp1154_;
									ValaPointerType* _tmp1155_;
									ValaPointerType* _tmp1156_;
									ValaLocalVariable* _tmp1157_;
									ValaLocalVariable* _tmp1158_;
									ValaExpression* _tmp1159_;
									ValaLocalVariable* _tmp1160_;
									const gchar* _tmp1161_;
									const gchar* _tmp1162_;
									ValaCCodeExpression* _tmp1163_;
									ValaCCodeExpression* _tmp1164_;
									ValaHashMap* _tmp1165_;
									ValaParameter* _tmp1166_;
									ValaExpression* _tmp1167_;
									ValaCCodeExpression* _tmp1168_;
									ValaCCodeExpression* _tmp1169_;
									ValaCCodeUnaryExpression* _tmp1170_;
									ValaCCodeUnaryExpression* _tmp1171_;
									ValaDelegateType* _tmp1172_;
									_tmp1153_ = vala_void_type_new (NULL);
									_tmp1154_ = _tmp1153_;
									_tmp1155_ = vala_pointer_type_new ((ValaDataType*) _tmp1154_, NULL);
									_tmp1156_ = _tmp1155_;
									_tmp1157_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1156_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1157_;
									_vala_code_node_unref0 (_tmp1156_);
									_vala_code_node_unref0 (_tmp1154_);
									_tmp1158_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1158_);
									_tmp1159_ = arg;
									_tmp1160_ = temp_var;
									_tmp1161_ = vala_symbol_get_name ((ValaSymbol*) _tmp1160_);
									_tmp1162_ = _tmp1161_;
									_tmp1163_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1162_);
									_tmp1164_ = _tmp1163_;
									vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1159_, _tmp1164_);
									_vala_ccode_node_unref0 (_tmp1164_);
									_tmp1165_ = carg_map;
									_tmp1166_ = param;
									_tmp1167_ = arg;
									_tmp1168_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1167_);
									_tmp1169_ = _tmp1168_;
									_tmp1170_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1169_);
									_tmp1171_ = _tmp1170_;
									vala_map_set ((ValaMap*) _tmp1165_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1166_), FALSE)), (ValaCCodeExpression*) _tmp1171_);
									_vala_ccode_node_unref0 (_tmp1171_);
									_vala_ccode_node_unref0 (_tmp1169_);
									_tmp1172_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1172_)) {
										ValaDataType* _tmp1173_;
										ValaLocalVariable* _tmp1174_;
										ValaLocalVariable* _tmp1175_;
										ValaExpression* _tmp1176_;
										ValaLocalVariable* _tmp1177_;
										const gchar* _tmp1178_;
										const gchar* _tmp1179_;
										ValaCCodeExpression* _tmp1180_;
										ValaCCodeExpression* _tmp1181_;
										ValaHashMap* _tmp1182_;
										ValaParameter* _tmp1183_;
										ValaExpression* _tmp1184_;
										ValaCCodeExpression* _tmp1185_;
										ValaCCodeExpression* _tmp1186_;
										ValaCCodeUnaryExpression* _tmp1187_;
										ValaCCodeUnaryExpression* _tmp1188_;
										_tmp1173_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
										_tmp1174_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1173_, TRUE, NULL, TRUE);
										_vala_code_node_unref0 (temp_var);
										temp_var = _tmp1174_;
										_tmp1175_ = temp_var;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1175_);
										_tmp1176_ = arg;
										_tmp1177_ = temp_var;
										_tmp1178_ = vala_symbol_get_name ((ValaSymbol*) _tmp1177_);
										_tmp1179_ = _tmp1178_;
										_tmp1180_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1179_);
										_tmp1181_ = _tmp1180_;
										vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1176_, _tmp1181_);
										_vala_ccode_node_unref0 (_tmp1181_);
										_tmp1182_ = carg_map;
										_tmp1183_ = param;
										_tmp1184_ = arg;
										_tmp1185_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1184_);
										_tmp1186_ = _tmp1185_;
										_tmp1187_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1186_);
										_tmp1188_ = _tmp1187_;
										vala_map_set ((ValaMap*) _tmp1182_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1183_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1188_);
										_vala_ccode_node_unref0 (_tmp1188_);
										_vala_ccode_node_unref0 (_tmp1186_);
									}
								}
								_vala_code_node_unref0 (d);
								_vala_code_node_unref0 (deleg_type);
							}
						}
						_vala_code_node_unref0 (temp_var);
					}
					_tmp1189_ = param;
					_tmp1190_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1189_);
					_tmp1191_ = _tmp1190_;
					_tmp1192_ = _tmp1191_ != NULL;
					_g_free0 (_tmp1191_);
					if (_tmp1192_) {
						ValaCCodeExpression* _tmp1193_;
						ValaParameter* _tmp1194_;
						gchar* _tmp1195_;
						gchar* _tmp1196_;
						ValaCCodeCastExpression* _tmp1197_;
						_tmp1193_ = cexpr;
						_tmp1194_ = param;
						_tmp1195_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1194_);
						_tmp1196_ = _tmp1195_;
						_tmp1197_ = vala_ccode_cast_expression_new (_tmp1193_, _tmp1196_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1197_;
						_g_free0 (_tmp1196_);
					}
					_vala_code_node_unref0 (unary);
				} else {
					ValaExpression* _tmp1198_;
					ValaCCodeExpression* _tmp1199_;
					ValaCCodeExpression* _tmp1200_;
					_tmp1198_ = arg;
					_tmp1199_ = cexpr;
					_tmp1200_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1198_, _tmp1199_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1200_;
				}
				_tmp1201_ = param;
				_tmp1202_ = ellipsis;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_pos (_tmp1201_), _tmp1202_);
				_vala_code_node_unref0 (param);
			} else {
				ValaExpression* _tmp1203_;
				ValaCCodeExpression* _tmp1204_;
				ValaCCodeExpression* _tmp1205_;
				gint _tmp1206_;
				gboolean _tmp1207_;
				_tmp1203_ = arg;
				_tmp1204_ = cexpr;
				_tmp1205_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1203_, _tmp1204_);
				_vala_ccode_node_unref0 (cexpr);
				cexpr = _tmp1205_;
				_tmp1206_ = i;
				_tmp1207_ = ellipsis;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) _tmp1206_, _tmp1207_);
			}
			_tmp1208_ = carg_map;
			_tmp1209_ = arg_pos;
			_tmp1210_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1208_, (gpointer) ((gintptr) _tmp1209_), _tmp1210_);
			_tmp1212_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1212_, VALA_TYPE_NAMED_ARGUMENT)) {
				gboolean _tmp1213_;
				_tmp1213_ = ellipsis;
				_tmp1211_ = _tmp1213_;
			} else {
				_tmp1211_ = FALSE;
			}
			if (_tmp1211_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1214_;
				ValaNamedArgument* _tmp1215_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1216_;
				const gchar* _tmp1217_;
				const gchar* _tmp1218_;
				gchar** _tmp1219_;
				gchar** _tmp1220_;
				gchar** _tmp1221_;
				gint _tmp1221__length1;
				gchar* _tmp1222_;
				gchar* _tmp1223_;
				ValaHashMap* _tmp1224_;
				gint _tmp1225_;
				gboolean _tmp1226_;
				const gchar* _tmp1227_;
				gchar* _tmp1228_;
				gchar* _tmp1229_;
				ValaCCodeConstant* _tmp1230_;
				ValaCCodeConstant* _tmp1231_;
				_tmp1214_ = arg;
				_tmp1215_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1214_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1215_;
				_tmp1216_ = named_arg;
				_tmp1217_ = vala_named_argument_get_name (_tmp1216_);
				_tmp1218_ = _tmp1217_;
				_tmp1220_ = _tmp1219_ = g_strsplit (_tmp1218_, "_", 0);
				_tmp1221_ = _tmp1220_;
				_tmp1221__length1 = _vala_array_length (_tmp1219_);
				_tmp1222_ = _vala_g_strjoinv ("-", _tmp1221_, _vala_array_length (_tmp1219_));
				_tmp1223_ = _tmp1222_;
				_tmp1221_ = (_vala_array_free (_tmp1221_, _tmp1221__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1223_;
				_tmp1224_ = carg_map;
				_tmp1225_ = i;
				_tmp1226_ = ellipsis;
				_tmp1227_ = name;
				_tmp1228_ = g_strdup_printf ("\"%s\"", _tmp1227_);
				_tmp1229_ = _tmp1228_;
				_tmp1230_ = vala_ccode_constant_new (_tmp1229_);
				_tmp1231_ = _tmp1230_;
				vala_map_set ((ValaMap*) _tmp1224_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1225_ - 0.1, _tmp1226_)), (ValaCCodeExpression*) _tmp1231_);
				_vala_ccode_node_unref0 (_tmp1231_);
				_g_free0 (_tmp1229_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1232_ = i;
			i = _tmp1232_ + 1;
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1233_ = params_it;
	if (vala_iterator_next (_tmp1233_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1234_;
		gpointer _tmp1235_;
		gboolean _tmp1236_ = FALSE;
		ValaParameter* _tmp1237_;
		gboolean _tmp1238_;
		gboolean _tmp1239_;
		_tmp1234_ = params_it;
		_tmp1235_ = vala_iterator_get (_tmp1234_);
		param = (ValaParameter*) _tmp1235_;
		_tmp1237_ = param;
		_tmp1238_ = vala_parameter_get_params_array (_tmp1237_);
		_tmp1239_ = _tmp1238_;
		if (_tmp1239_) {
			_tmp1236_ = TRUE;
		} else {
			ValaParameter* _tmp1240_;
			gboolean _tmp1241_;
			gboolean _tmp1242_;
			_tmp1240_ = param;
			_tmp1241_ = vala_parameter_get_ellipsis (_tmp1240_);
			_tmp1242_ = _tmp1241_;
			_tmp1236_ = _tmp1242_;
		}
		_vala_assert (_tmp1236_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1245_ = m;
	if (_tmp1245_ != NULL) {
		ValaMethod* _tmp1246_;
		ValaDataType* _tmp1247_;
		ValaDataType* _tmp1248_;
		_tmp1246_ = m;
		_tmp1247_ = vala_callable_get_return_type ((ValaCallable*) _tmp1246_);
		_tmp1248_ = _tmp1247_;
		_tmp1244_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1248_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1244_ = FALSE;
	}
	if (_tmp1244_) {
		ValaCCodeFunctionCall* _tmp1249_;
		ValaCCodeFunctionCall* _tmp1250_;
		_tmp1249_ = async_call;
		_tmp1250_ = ccall;
		_tmp1243_ = _tmp1249_ != _tmp1250_;
	} else {
		_tmp1243_ = FALSE;
	}
	if (_tmp1243_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1251_;
		ValaDataType* _tmp1252_;
		ValaDataType* _tmp1253_;
		ValaArrayType* _tmp1254_;
		_tmp1251_ = m;
		_tmp1252_ = vala_callable_get_return_type ((ValaCallable*) _tmp1251_);
		_tmp1253_ = _tmp1252_;
		_tmp1254_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1253_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1254_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1255_ = FALSE;
				_tmp1255_ = TRUE;
				while (TRUE) {
					gint _tmp1257_;
					ValaArrayType* _tmp1258_;
					gint _tmp1259_;
					gint _tmp1260_;
					ValaMethod* _tmp1261_;
					if (!_tmp1255_) {
						gint _tmp1256_;
						_tmp1256_ = dim;
						dim = _tmp1256_ + 1;
					}
					_tmp1255_ = FALSE;
					_tmp1257_ = dim;
					_tmp1258_ = array_type;
					_tmp1259_ = vala_array_type_get_rank (_tmp1258_);
					_tmp1260_ = _tmp1259_;
					if (!(_tmp1257_ <= _tmp1260_)) {
						break;
					}
					_tmp1261_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1261_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1262_;
						ValaDataType* _tmp1263_;
						ValaDataType* _tmp1264_;
						ValaLocalVariable* _tmp1265_;
						ValaLocalVariable* _tmp1266_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1267_;
						const gchar* _tmp1268_;
						const gchar* _tmp1269_;
						ValaCCodeExpression* _tmp1270_;
						ValaLocalVariable* _tmp1271_;
						ValaCCodeExpression* _tmp1272_;
						ValaCCodeExpression* _tmp1273_;
						ValaCCodeAssignment* _tmp1274_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1275_;
						ValaCCodeIdentifier* _tmp1276_;
						ValaCCodeFunctionCall* _tmp1277_;
						ValaCCodeFunctionCall* _tmp1278_;
						ValaCCodeFunctionCall* _tmp1279_;
						ValaCCodeExpression* _tmp1280_;
						ValaCCodeFunctionCall* _tmp1281_;
						_tmp1262_ = itype;
						_tmp1263_ = vala_data_type_get_return_type (_tmp1262_);
						_tmp1264_ = _tmp1263_;
						_tmp1265_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1264_, TRUE, NULL, FALSE);
						_tmp1266_ = _tmp1265_;
						_vala_code_node_unref0 (_tmp1264_);
						temp_var = _tmp1266_;
						_tmp1267_ = temp_var;
						_tmp1268_ = vala_symbol_get_name ((ValaSymbol*) _tmp1267_);
						_tmp1269_ = _tmp1268_;
						_tmp1270_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1269_);
						temp_ref = _tmp1270_;
						_tmp1271_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1271_);
						_tmp1272_ = temp_ref;
						_tmp1273_ = ccall_expr;
						_tmp1274_ = vala_ccode_assignment_new (_tmp1272_, _tmp1273_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1274_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1275_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1276_ = _tmp1275_;
						_tmp1277_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1276_);
						_tmp1278_ = _tmp1277_;
						_vala_ccode_node_unref0 (_tmp1276_);
						len_call = _tmp1278_;
						_tmp1279_ = len_call;
						_tmp1280_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1279_, _tmp1280_);
						_tmp1281_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1281_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1282_;
						_tmp1282_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1282_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaMethod* _tmp1283_;
							gchar* _tmp1284_;
							gchar* _tmp1285_;
							gboolean _tmp1286_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1295_;
							const gchar* _tmp1296_;
							const gchar* _tmp1297_;
							ValaCCodeExpression* _tmp1298_;
							ValaLocalVariable* _tmp1299_;
							ValaHashMap* _tmp1300_;
							ValaMethod* _tmp1301_;
							gint _tmp1302_;
							ValaCCodeExpression* _tmp1303_;
							ValaCCodeUnaryExpression* _tmp1304_;
							ValaCCodeUnaryExpression* _tmp1305_;
							ValaCCodeExpression* _tmp1306_;
							_tmp1283_ = m;
							_tmp1284_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1283_);
							_tmp1285_ = _tmp1284_;
							_tmp1286_ = _tmp1285_ == NULL;
							_g_free0 (_tmp1285_);
							if (_tmp1286_) {
								ValaDataType* _tmp1287_;
								ValaLocalVariable* _tmp1288_;
								_tmp1287_ = ((ValaCCodeBaseModule*) self)->int_type;
								_tmp1288_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1287_, TRUE, NULL, FALSE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1288_;
							} else {
								ValaMethod* _tmp1289_;
								gchar* _tmp1290_;
								gchar* _tmp1291_;
								ValaCType* _tmp1292_;
								ValaCType* _tmp1293_;
								ValaLocalVariable* _tmp1294_;
								_tmp1289_ = m;
								_tmp1290_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1289_);
								_tmp1291_ = _tmp1290_;
								_tmp1292_ = vala_ctype_new (_tmp1291_);
								_tmp1293_ = _tmp1292_;
								_tmp1294_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1293_, TRUE, NULL, FALSE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1294_;
								_vala_code_node_unref0 (_tmp1293_);
								_g_free0 (_tmp1291_);
							}
							_tmp1295_ = temp_var;
							_tmp1296_ = vala_symbol_get_name ((ValaSymbol*) _tmp1295_);
							_tmp1297_ = _tmp1296_;
							_tmp1298_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1297_);
							temp_ref = _tmp1298_;
							_tmp1299_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1299_);
							_tmp1300_ = out_arg_map;
							_tmp1301_ = m;
							_tmp1302_ = dim;
							_tmp1303_ = temp_ref;
							_tmp1304_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1303_);
							_tmp1305_ = _tmp1304_;
							vala_map_set ((ValaMap*) _tmp1300_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1301_) + (0.01 * _tmp1302_), FALSE)), (ValaCCodeExpression*) _tmp1305_);
							_vala_ccode_node_unref0 (_tmp1305_);
							_tmp1306_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1306_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaMethod* _tmp1307_;
							gchar* _tmp1308_;
							gchar* _tmp1309_;
							gboolean _tmp1310_;
							_tmp1307_ = m;
							_tmp1308_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1307_);
							_tmp1309_ = _tmp1308_;
							_tmp1310_ = _tmp1309_ != NULL;
							_g_free0 (_tmp1309_);
							if (_tmp1310_) {
								ValaMethod* _tmp1311_;
								gchar* _tmp1312_;
								gchar* _tmp1313_;
								ValaCCodeConstant* _tmp1314_;
								ValaCCodeConstant* _tmp1315_;
								_tmp1311_ = m;
								_tmp1312_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1311_);
								_tmp1313_ = _tmp1312_;
								_tmp1314_ = vala_ccode_constant_new (_tmp1313_);
								_tmp1315_ = _tmp1314_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1315_);
								_vala_ccode_node_unref0 (_tmp1315_);
								_g_free0 (_tmp1313_);
							} else {
								ValaCCodeConstant* _tmp1316_;
								ValaCCodeConstant* _tmp1317_;
								_tmp1316_ = vala_ccode_constant_new ("-1");
								_tmp1317_ = _tmp1316_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1317_);
								_vala_ccode_node_unref0 (_tmp1317_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1318_ = FALSE;
		gboolean _tmp1319_ = FALSE;
		ValaMethod* _tmp1320_;
		_tmp1320_ = m;
		if (_tmp1320_ != NULL) {
			ValaMethod* _tmp1321_;
			ValaDataType* _tmp1322_;
			ValaDataType* _tmp1323_;
			_tmp1321_ = m;
			_tmp1322_ = vala_callable_get_return_type ((ValaCallable*) _tmp1321_);
			_tmp1323_ = _tmp1322_;
			_tmp1319_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1323_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1319_ = FALSE;
		}
		if (_tmp1319_) {
			ValaCCodeFunctionCall* _tmp1324_;
			ValaCCodeFunctionCall* _tmp1325_;
			_tmp1324_ = async_call;
			_tmp1325_ = ccall;
			_tmp1318_ = _tmp1324_ != _tmp1325_;
		} else {
			_tmp1318_ = FALSE;
		}
		if (_tmp1318_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1326_;
			ValaDataType* _tmp1327_;
			ValaDataType* _tmp1328_;
			ValaDelegateType* _tmp1329_;
			ValaDelegate* d = NULL;
			ValaDelegateType* _tmp1330_;
			ValaDelegate* _tmp1331_;
			ValaDelegate* _tmp1332_;
			ValaDelegate* _tmp1333_;
			ValaDelegate* _tmp1334_;
			gboolean _tmp1335_;
			gboolean _tmp1336_;
			_tmp1326_ = m;
			_tmp1327_ = vala_callable_get_return_type ((ValaCallable*) _tmp1326_);
			_tmp1328_ = _tmp1327_;
			_tmp1329_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1328_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1329_;
			_tmp1330_ = deleg_type;
			_tmp1331_ = vala_delegate_type_get_delegate_symbol (_tmp1330_);
			_tmp1332_ = _tmp1331_;
			_tmp1333_ = _vala_code_node_ref0 (_tmp1332_);
			d = _tmp1333_;
			_tmp1334_ = d;
			_tmp1335_ = vala_delegate_get_has_target (_tmp1334_);
			_tmp1336_ = _tmp1335_;
			if (_tmp1336_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1337_;
				ValaVoidType* _tmp1338_;
				ValaPointerType* _tmp1339_;
				ValaPointerType* _tmp1340_;
				ValaLocalVariable* _tmp1341_;
				ValaLocalVariable* _tmp1342_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1343_;
				const gchar* _tmp1344_;
				const gchar* _tmp1345_;
				ValaCCodeExpression* _tmp1346_;
				ValaLocalVariable* _tmp1347_;
				ValaHashMap* _tmp1348_;
				ValaMethod* _tmp1349_;
				ValaCCodeExpression* _tmp1350_;
				ValaCCodeUnaryExpression* _tmp1351_;
				ValaCCodeUnaryExpression* _tmp1352_;
				ValaCCodeExpression* _tmp1353_;
				ValaDelegateType* _tmp1354_;
				_tmp1337_ = vala_void_type_new (NULL);
				_tmp1338_ = _tmp1337_;
				_tmp1339_ = vala_pointer_type_new ((ValaDataType*) _tmp1338_, NULL);
				_tmp1340_ = _tmp1339_;
				_tmp1341_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1340_, TRUE, NULL, FALSE);
				_tmp1342_ = _tmp1341_;
				_vala_code_node_unref0 (_tmp1340_);
				_vala_code_node_unref0 (_tmp1338_);
				temp_var = _tmp1342_;
				_tmp1343_ = temp_var;
				_tmp1344_ = vala_symbol_get_name ((ValaSymbol*) _tmp1343_);
				_tmp1345_ = _tmp1344_;
				_tmp1346_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1345_);
				temp_ref = _tmp1346_;
				_tmp1347_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1347_);
				_tmp1348_ = out_arg_map;
				_tmp1349_ = m;
				_tmp1350_ = temp_ref;
				_tmp1351_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1350_);
				_tmp1352_ = _tmp1351_;
				vala_map_set ((ValaMap*) _tmp1348_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1349_), FALSE)), (ValaCCodeExpression*) _tmp1352_);
				_vala_ccode_node_unref0 (_tmp1352_);
				_tmp1353_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1353_);
				_tmp1354_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1354_)) {
					ValaDataType* _tmp1355_;
					ValaLocalVariable* _tmp1356_;
					ValaLocalVariable* _tmp1357_;
					const gchar* _tmp1358_;
					const gchar* _tmp1359_;
					ValaCCodeExpression* _tmp1360_;
					ValaLocalVariable* _tmp1361_;
					ValaHashMap* _tmp1362_;
					ValaMethod* _tmp1363_;
					ValaCCodeExpression* _tmp1364_;
					ValaCCodeUnaryExpression* _tmp1365_;
					ValaCCodeUnaryExpression* _tmp1366_;
					ValaCCodeExpression* _tmp1367_;
					_tmp1355_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1356_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1355_, TRUE, NULL, FALSE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1356_;
					_tmp1357_ = temp_var;
					_tmp1358_ = vala_symbol_get_name ((ValaSymbol*) _tmp1357_);
					_tmp1359_ = _tmp1358_;
					_tmp1360_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1359_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1360_;
					_tmp1361_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1361_);
					_tmp1362_ = out_arg_map;
					_tmp1363_ = m;
					_tmp1364_ = temp_ref;
					_tmp1365_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1364_);
					_tmp1366_ = _tmp1365_;
					vala_map_set ((ValaMap*) _tmp1362_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1363_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1366_);
					_vala_ccode_node_unref0 (_tmp1366_);
					_tmp1367_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1367_);
				} else {
					ValaCCodeConstant* _tmp1368_;
					ValaCCodeConstant* _tmp1369_;
					_tmp1368_ = vala_ccode_constant_new ("NULL");
					_tmp1369_ = _tmp1368_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1369_);
					_vala_ccode_node_unref0 (_tmp1369_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1370_;
				ValaCCodeConstant* _tmp1371_;
				_tmp1370_ = vala_ccode_constant_new ("NULL");
				_tmp1371_ = _tmp1370_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1371_);
				_vala_ccode_node_unref0 (_tmp1371_);
			}
			_vala_code_node_unref0 (d);
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1373_ = deleg;
	if (_tmp1373_ != NULL) {
		ValaDelegate* _tmp1374_;
		ValaDataType* _tmp1375_;
		ValaDataType* _tmp1376_;
		_tmp1374_ = deleg;
		_tmp1375_ = vala_callable_get_return_type ((ValaCallable*) _tmp1374_);
		_tmp1376_ = _tmp1375_;
		_tmp1372_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1376_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1372_ = FALSE;
	}
	if (_tmp1372_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1377_;
		ValaDataType* _tmp1378_;
		ValaDataType* _tmp1379_;
		ValaArrayType* _tmp1380_;
		_tmp1377_ = deleg;
		_tmp1378_ = vala_callable_get_return_type ((ValaCallable*) _tmp1377_);
		_tmp1379_ = _tmp1378_;
		_tmp1380_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1379_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1380_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1381_ = FALSE;
				_tmp1381_ = TRUE;
				while (TRUE) {
					gint _tmp1383_;
					ValaArrayType* _tmp1384_;
					gint _tmp1385_;
					gint _tmp1386_;
					ValaDelegate* _tmp1387_;
					if (!_tmp1381_) {
						gint _tmp1382_;
						_tmp1382_ = dim;
						dim = _tmp1382_ + 1;
					}
					_tmp1381_ = FALSE;
					_tmp1383_ = dim;
					_tmp1384_ = array_type;
					_tmp1385_ = vala_array_type_get_rank (_tmp1384_);
					_tmp1386_ = _tmp1385_;
					if (!(_tmp1383_ <= _tmp1386_)) {
						break;
					}
					_tmp1387_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1387_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1388_;
						ValaDataType* _tmp1389_;
						ValaDataType* _tmp1390_;
						ValaLocalVariable* _tmp1391_;
						ValaLocalVariable* _tmp1392_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1393_;
						const gchar* _tmp1394_;
						const gchar* _tmp1395_;
						ValaCCodeExpression* _tmp1396_;
						ValaLocalVariable* _tmp1397_;
						ValaCCodeExpression* _tmp1398_;
						ValaCCodeExpression* _tmp1399_;
						ValaCCodeAssignment* _tmp1400_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1401_;
						ValaCCodeIdentifier* _tmp1402_;
						ValaCCodeFunctionCall* _tmp1403_;
						ValaCCodeFunctionCall* _tmp1404_;
						ValaCCodeFunctionCall* _tmp1405_;
						ValaCCodeExpression* _tmp1406_;
						ValaCCodeFunctionCall* _tmp1407_;
						_tmp1388_ = itype;
						_tmp1389_ = vala_data_type_get_return_type (_tmp1388_);
						_tmp1390_ = _tmp1389_;
						_tmp1391_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1390_, TRUE, NULL, FALSE);
						_tmp1392_ = _tmp1391_;
						_vala_code_node_unref0 (_tmp1390_);
						temp_var = _tmp1392_;
						_tmp1393_ = temp_var;
						_tmp1394_ = vala_symbol_get_name ((ValaSymbol*) _tmp1393_);
						_tmp1395_ = _tmp1394_;
						_tmp1396_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1395_);
						temp_ref = _tmp1396_;
						_tmp1397_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1397_);
						_tmp1398_ = temp_ref;
						_tmp1399_ = ccall_expr;
						_tmp1400_ = vala_ccode_assignment_new (_tmp1398_, _tmp1399_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1400_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1401_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1402_ = _tmp1401_;
						_tmp1403_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1402_);
						_tmp1404_ = _tmp1403_;
						_vala_ccode_node_unref0 (_tmp1402_);
						len_call = _tmp1404_;
						_tmp1405_ = len_call;
						_tmp1406_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1405_, _tmp1406_);
						_tmp1407_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1407_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1408_;
						_tmp1408_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1408_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaDataType* _tmp1409_;
							ValaLocalVariable* _tmp1410_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1411_;
							const gchar* _tmp1412_;
							const gchar* _tmp1413_;
							ValaCCodeExpression* _tmp1414_;
							ValaLocalVariable* _tmp1415_;
							ValaHashMap* _tmp1416_;
							ValaDelegate* _tmp1417_;
							gint _tmp1418_;
							ValaCCodeExpression* _tmp1419_;
							ValaCCodeUnaryExpression* _tmp1420_;
							ValaCCodeUnaryExpression* _tmp1421_;
							ValaCCodeExpression* _tmp1422_;
							_tmp1409_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1410_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1409_, TRUE, NULL, FALSE);
							temp_var = _tmp1410_;
							_tmp1411_ = temp_var;
							_tmp1412_ = vala_symbol_get_name ((ValaSymbol*) _tmp1411_);
							_tmp1413_ = _tmp1412_;
							_tmp1414_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1413_);
							temp_ref = _tmp1414_;
							_tmp1415_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1415_);
							_tmp1416_ = out_arg_map;
							_tmp1417_ = deleg;
							_tmp1418_ = dim;
							_tmp1419_ = temp_ref;
							_tmp1420_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1419_);
							_tmp1421_ = _tmp1420_;
							vala_map_set ((ValaMap*) _tmp1416_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1417_) + (0.01 * _tmp1418_), FALSE)), (ValaCCodeExpression*) _tmp1421_);
							_vala_ccode_node_unref0 (_tmp1421_);
							_tmp1422_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1422_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1423_;
							ValaCCodeConstant* _tmp1424_;
							_tmp1423_ = vala_ccode_constant_new ("-1");
							_tmp1424_ = _tmp1423_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1424_);
							_vala_ccode_node_unref0 (_tmp1424_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1425_ = FALSE;
		ValaDelegate* _tmp1426_;
		_tmp1426_ = deleg;
		if (_tmp1426_ != NULL) {
			ValaDelegate* _tmp1427_;
			ValaDataType* _tmp1428_;
			ValaDataType* _tmp1429_;
			_tmp1427_ = deleg;
			_tmp1428_ = vala_callable_get_return_type ((ValaCallable*) _tmp1427_);
			_tmp1429_ = _tmp1428_;
			_tmp1425_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1429_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1425_ = FALSE;
		}
		if (_tmp1425_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1430_;
			ValaDataType* _tmp1431_;
			ValaDataType* _tmp1432_;
			ValaDelegateType* _tmp1433_;
			ValaDelegate* d = NULL;
			ValaDelegateType* _tmp1434_;
			ValaDelegate* _tmp1435_;
			ValaDelegate* _tmp1436_;
			ValaDelegate* _tmp1437_;
			ValaDelegate* _tmp1438_;
			gboolean _tmp1439_;
			gboolean _tmp1440_;
			_tmp1430_ = deleg;
			_tmp1431_ = vala_callable_get_return_type ((ValaCallable*) _tmp1430_);
			_tmp1432_ = _tmp1431_;
			_tmp1433_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1432_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1433_;
			_tmp1434_ = deleg_type;
			_tmp1435_ = vala_delegate_type_get_delegate_symbol (_tmp1434_);
			_tmp1436_ = _tmp1435_;
			_tmp1437_ = _vala_code_node_ref0 (_tmp1436_);
			d = _tmp1437_;
			_tmp1438_ = d;
			_tmp1439_ = vala_delegate_get_has_target (_tmp1438_);
			_tmp1440_ = _tmp1439_;
			if (_tmp1440_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1441_;
				ValaVoidType* _tmp1442_;
				ValaPointerType* _tmp1443_;
				ValaPointerType* _tmp1444_;
				ValaLocalVariable* _tmp1445_;
				ValaLocalVariable* _tmp1446_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1447_;
				const gchar* _tmp1448_;
				const gchar* _tmp1449_;
				ValaCCodeExpression* _tmp1450_;
				ValaLocalVariable* _tmp1451_;
				ValaHashMap* _tmp1452_;
				ValaDelegate* _tmp1453_;
				ValaCCodeExpression* _tmp1454_;
				ValaCCodeUnaryExpression* _tmp1455_;
				ValaCCodeUnaryExpression* _tmp1456_;
				ValaCCodeExpression* _tmp1457_;
				ValaDelegateType* _tmp1458_;
				_tmp1441_ = vala_void_type_new (NULL);
				_tmp1442_ = _tmp1441_;
				_tmp1443_ = vala_pointer_type_new ((ValaDataType*) _tmp1442_, NULL);
				_tmp1444_ = _tmp1443_;
				_tmp1445_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1444_, TRUE, NULL, FALSE);
				_tmp1446_ = _tmp1445_;
				_vala_code_node_unref0 (_tmp1444_);
				_vala_code_node_unref0 (_tmp1442_);
				temp_var = _tmp1446_;
				_tmp1447_ = temp_var;
				_tmp1448_ = vala_symbol_get_name ((ValaSymbol*) _tmp1447_);
				_tmp1449_ = _tmp1448_;
				_tmp1450_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1449_);
				temp_ref = _tmp1450_;
				_tmp1451_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1451_);
				_tmp1452_ = out_arg_map;
				_tmp1453_ = deleg;
				_tmp1454_ = temp_ref;
				_tmp1455_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1454_);
				_tmp1456_ = _tmp1455_;
				vala_map_set ((ValaMap*) _tmp1452_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1453_), FALSE)), (ValaCCodeExpression*) _tmp1456_);
				_vala_ccode_node_unref0 (_tmp1456_);
				_tmp1457_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1457_);
				_tmp1458_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1458_)) {
					ValaDataType* _tmp1459_;
					ValaLocalVariable* _tmp1460_;
					ValaLocalVariable* _tmp1461_;
					const gchar* _tmp1462_;
					const gchar* _tmp1463_;
					ValaCCodeExpression* _tmp1464_;
					ValaLocalVariable* _tmp1465_;
					ValaHashMap* _tmp1466_;
					ValaDelegate* _tmp1467_;
					ValaCCodeExpression* _tmp1468_;
					ValaCCodeUnaryExpression* _tmp1469_;
					ValaCCodeUnaryExpression* _tmp1470_;
					ValaCCodeExpression* _tmp1471_;
					_tmp1459_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1460_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1459_, TRUE, NULL, FALSE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1460_;
					_tmp1461_ = temp_var;
					_tmp1462_ = vala_symbol_get_name ((ValaSymbol*) _tmp1461_);
					_tmp1463_ = _tmp1462_;
					_tmp1464_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1463_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1464_;
					_tmp1465_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1465_);
					_tmp1466_ = out_arg_map;
					_tmp1467_ = deleg;
					_tmp1468_ = temp_ref;
					_tmp1469_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1468_);
					_tmp1470_ = _tmp1469_;
					vala_map_set ((ValaMap*) _tmp1466_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1467_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1470_);
					_vala_ccode_node_unref0 (_tmp1470_);
					_tmp1471_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1471_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (d);
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1473_ = m;
	if (_tmp1473_ != NULL) {
		ValaMethod* _tmp1474_;
		gboolean _tmp1475_;
		gboolean _tmp1476_;
		_tmp1474_ = m;
		_tmp1475_ = vala_method_get_coroutine (_tmp1474_);
		_tmp1476_ = _tmp1475_;
		_tmp1472_ = _tmp1476_;
	} else {
		_tmp1472_ = FALSE;
	}
	if (_tmp1472_) {
		gboolean _tmp1477_;
		gboolean _tmp1478_;
		_tmp1477_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1478_ = _tmp1477_;
		if (_tmp1478_) {
			ValaHashMap* _tmp1479_;
			ValaMethod* _tmp1480_;
			ValaMethod* _tmp1481_;
			gchar* _tmp1482_;
			gchar* _tmp1483_;
			ValaCCodeIdentifier* _tmp1484_;
			ValaCCodeIdentifier* _tmp1485_;
			ValaHashMap* _tmp1486_;
			ValaCCodeIdentifier* _tmp1487_;
			ValaCCodeIdentifier* _tmp1488_;
			_tmp1479_ = in_arg_map;
			_tmp1480_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1481_ = _tmp1480_;
			_tmp1482_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1481_);
			_tmp1483_ = _tmp1482_;
			_tmp1484_ = vala_ccode_identifier_new (_tmp1483_);
			_tmp1485_ = _tmp1484_;
			vala_map_set ((ValaMap*) _tmp1479_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1485_);
			_vala_ccode_node_unref0 (_tmp1485_);
			_g_free0 (_tmp1483_);
			_tmp1486_ = in_arg_map;
			_tmp1487_ = vala_ccode_identifier_new ("_data_");
			_tmp1488_ = _tmp1487_;
			vala_map_set ((ValaMap*) _tmp1486_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1488_);
			_vala_ccode_node_unref0 (_tmp1488_);
		}
	}
	_tmp1489_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1490_ = _tmp1489_;
	if (_tmp1490_) {
		ValaHashMap* _tmp1491_;
		ValaCCodeExpression* _tmp1492_;
		ValaCCodeExpression* _tmp1493_;
		ValaCCodeUnaryExpression* _tmp1494_;
		ValaCCodeUnaryExpression* _tmp1495_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1491_ = out_arg_map;
		_tmp1492_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_");
		_tmp1493_ = _tmp1492_;
		_tmp1494_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1493_);
		_tmp1495_ = _tmp1494_;
		vala_map_set ((ValaMap*) _tmp1491_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1495_);
		_vala_ccode_node_unref0 (_tmp1495_);
		_vala_ccode_node_unref0 (_tmp1493_);
	} else {
		gboolean _tmp1496_ = FALSE;
		gboolean _tmp1497_ = FALSE;
		ValaMethod* _tmp1498_;
		_tmp1498_ = m;
		if (_tmp1498_ != NULL) {
			ValaMethod* _tmp1499_;
			_tmp1499_ = m;
			_tmp1497_ = vala_method_has_error_type_parameter (_tmp1499_);
		} else {
			_tmp1497_ = FALSE;
		}
		if (_tmp1497_) {
			ValaCCodeFunctionCall* _tmp1500_;
			ValaCCodeFunctionCall* _tmp1501_;
			_tmp1500_ = async_call;
			_tmp1501_ = ccall;
			_tmp1496_ = _tmp1500_ != _tmp1501_;
		} else {
			_tmp1496_ = FALSE;
		}
		if (_tmp1496_) {
			ValaHashMap* _tmp1502_;
			ValaCCodeConstant* _tmp1503_;
			ValaCCodeConstant* _tmp1504_;
			_tmp1502_ = out_arg_map;
			_tmp1503_ = vala_ccode_constant_new ("NULL");
			_tmp1504_ = _tmp1503_;
			vala_map_set ((ValaMap*) _tmp1502_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1504_);
			_vala_ccode_node_unref0 (_tmp1504_);
		}
	}
	_tmp1505_ = ellipsis;
	if (_tmp1505_) {
		ValaMethod* _tmp1506_;
		_tmp1506_ = m;
		if (_tmp1506_ == NULL) {
			ValaHashMap* _tmp1507_;
			ValaCCodeConstant* _tmp1508_;
			ValaCCodeConstant* _tmp1509_;
			_tmp1507_ = in_arg_map;
			_tmp1508_ = vala_ccode_constant_new ("NULL");
			_tmp1509_ = _tmp1508_;
			vala_map_set ((ValaMap*) _tmp1507_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1509_);
			_vala_ccode_node_unref0 (_tmp1509_);
		} else {
			gboolean _tmp1510_ = FALSE;
			gboolean _tmp1511_ = FALSE;
			gboolean _tmp1512_ = FALSE;
			ValaMethod* _tmp1513_;
			gboolean _tmp1514_;
			gboolean _tmp1515_;
			_tmp1513_ = m;
			_tmp1514_ = vala_method_get_printf_format (_tmp1513_);
			_tmp1515_ = _tmp1514_;
			if (!_tmp1515_) {
				ValaMethod* _tmp1516_;
				gboolean _tmp1517_;
				gboolean _tmp1518_;
				_tmp1516_ = m;
				_tmp1517_ = vala_method_get_scanf_format (_tmp1516_);
				_tmp1518_ = _tmp1517_;
				_tmp1512_ = !_tmp1518_;
			} else {
				_tmp1512_ = FALSE;
			}
			if (_tmp1512_) {
				ValaMethod* _tmp1519_;
				gchar* _tmp1520_;
				gchar* _tmp1521_;
				_tmp1519_ = m;
				_tmp1520_ = vala_get_ccode_sentinel (_tmp1519_);
				_tmp1521_ = _tmp1520_;
				_tmp1511_ = g_strcmp0 (_tmp1521_, "") != 0;
				_g_free0 (_tmp1521_);
			} else {
				_tmp1511_ = FALSE;
			}
			if (_tmp1511_) {
				gboolean _tmp1522_;
				gboolean _tmp1523_;
				_tmp1522_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1523_ = _tmp1522_;
				_tmp1510_ = !_tmp1523_;
			} else {
				_tmp1510_ = FALSE;
			}
			if (_tmp1510_) {
				ValaHashMap* _tmp1524_;
				ValaMethod* _tmp1525_;
				gchar* _tmp1526_;
				gchar* _tmp1527_;
				ValaCCodeConstant* _tmp1528_;
				ValaCCodeConstant* _tmp1529_;
				_tmp1524_ = in_arg_map;
				_tmp1525_ = m;
				_tmp1526_ = vala_get_ccode_sentinel (_tmp1525_);
				_tmp1527_ = _tmp1526_;
				_tmp1528_ = vala_ccode_constant_new (_tmp1527_);
				_tmp1529_ = _tmp1528_;
				vala_map_set ((ValaMap*) _tmp1524_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1529_);
				_vala_ccode_node_unref0 (_tmp1529_);
				_g_free0 (_tmp1527_);
			}
		}
	}
	_tmp1530_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1530_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1531_;
		ValaDelegateType* _tmp1532_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1533_;
		ValaDelegate* _tmp1534_;
		ValaDelegate* _tmp1535_;
		ValaDelegate* _tmp1536_;
		ValaDelegate* _tmp1537_;
		gboolean _tmp1538_;
		gboolean _tmp1539_;
		_tmp1531_ = itype;
		_tmp1532_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1531_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1532_;
		_tmp1533_ = deleg_type;
		_tmp1534_ = vala_delegate_type_get_delegate_symbol (_tmp1533_);
		_tmp1535_ = _tmp1534_;
		_tmp1536_ = _vala_code_node_ref0 (_tmp1535_);
		d = _tmp1536_;
		_tmp1537_ = d;
		_tmp1538_ = vala_delegate_get_has_target (_tmp1537_);
		_tmp1539_ = _tmp1538_;
		if (_tmp1539_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1540_;
			ValaDelegate* _tmp1541_;
			ValaExpression* _tmp1542_;
			ValaExpression* _tmp1543_;
			ValaCCodeExpression* _tmp1544_ = NULL;
			ValaCCodeExpression* _tmp1545_;
			ValaCCodeExpression* _tmp1546_;
			ValaHashMap* _tmp1547_;
			ValaDelegate* _tmp1548_;
			ValaExpression* _tmp1549_;
			ValaExpression* _tmp1550_;
			ValaCCodeExpression* _tmp1551_ = NULL;
			ValaCCodeExpression* _tmp1552_;
			ValaCCodeExpression* _tmp1553_;
			_tmp1540_ = in_arg_map;
			_tmp1541_ = d;
			_tmp1542_ = vala_method_call_get_call (expr);
			_tmp1543_ = _tmp1542_;
			_tmp1545_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1543_, &_tmp1544_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1544_;
			_tmp1546_ = _tmp1545_;
			vala_map_set ((ValaMap*) _tmp1540_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1541_), FALSE)), _tmp1546_);
			_vala_ccode_node_unref0 (_tmp1546_);
			_tmp1547_ = out_arg_map;
			_tmp1548_ = d;
			_tmp1549_ = vala_method_call_get_call (expr);
			_tmp1550_ = _tmp1549_;
			_tmp1552_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1550_, &_tmp1551_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1551_;
			_tmp1553_ = _tmp1552_;
			vala_map_set ((ValaMap*) _tmp1547_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1548_), FALSE)), _tmp1553_);
			_vala_ccode_node_unref0 (_tmp1553_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1554_ = itype;
	_tmp1555_ = vala_data_type_get_return_type (_tmp1554_);
	_tmp1556_ = _tmp1555_;
	_tmp1557_ = vala_data_type_is_real_non_null_struct_type (_tmp1556_);
	_vala_code_node_unref0 (_tmp1556_);
	return_result_via_out_param = _tmp1557_;
	_tmp1559_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1559_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1560_;
		ValaDataType* _tmp1561_;
		ValaDataType* _tmp1562_;
		_tmp1560_ = itype;
		_tmp1561_ = vala_data_type_get_return_type (_tmp1560_);
		_tmp1562_ = _tmp1561_;
		_tmp1558_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1562_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1562_);
	} else {
		_tmp1558_ = FALSE;
	}
	if (_tmp1558_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1563_;
		ValaSignal* _tmp1564_;
		ValaSignal* _tmp1565_;
		ValaSignal* _tmp1566_;
		gboolean _tmp1567_ = FALSE;
		gboolean _tmp1568_ = FALSE;
		ValaMemberAccess* _tmp1569_;
		_tmp1563_ = itype;
		_tmp1564_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1563_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1565_ = _tmp1564_;
		_tmp1566_ = _vala_code_node_ref0 (_tmp1565_);
		sig = _tmp1566_;
		_tmp1569_ = ma;
		if (_tmp1569_ != NULL) {
			ValaMemberAccess* _tmp1570_;
			ValaExpression* _tmp1571_;
			ValaExpression* _tmp1572_;
			_tmp1570_ = ma;
			_tmp1571_ = vala_member_access_get_inner (_tmp1570_);
			_tmp1572_ = _tmp1571_;
			_tmp1568_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1572_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1568_ = FALSE;
		}
		if (_tmp1568_) {
			ValaSignal* _tmp1573_;
			gboolean _tmp1574_;
			gboolean _tmp1575_;
			_tmp1573_ = sig;
			_tmp1574_ = vala_signal_get_is_virtual (_tmp1573_);
			_tmp1575_ = _tmp1574_;
			_tmp1567_ = _tmp1575_;
		} else {
			_tmp1567_ = FALSE;
		}
		if (_tmp1567_) {
		} else {
			gboolean _tmp1576_ = FALSE;
			ValaSignal* _tmp1577_;
			_tmp1577_ = sig;
			if (!vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp1577_)) {
				_tmp1576_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1578_;
				ValaSourceReference* _tmp1579_;
				ValaSourceReference* _tmp1580_;
				ValaSourceFile* _tmp1581_;
				ValaSourceFile* _tmp1582_;
				ValaSignal* _tmp1583_;
				ValaSourceReference* _tmp1584_;
				ValaSourceReference* _tmp1585_;
				ValaSourceFile* _tmp1586_;
				ValaSourceFile* _tmp1587_;
				_tmp1578_ = ma;
				_tmp1579_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1578_);
				_tmp1580_ = _tmp1579_;
				_tmp1581_ = vala_source_reference_get_file (_tmp1580_);
				_tmp1582_ = _tmp1581_;
				_tmp1583_ = sig;
				_tmp1584_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1583_);
				_tmp1585_ = _tmp1584_;
				_tmp1586_ = vala_source_reference_get_file (_tmp1585_);
				_tmp1587_ = _tmp1586_;
				_tmp1576_ = _tmp1582_ == _tmp1587_;
			}
			if (_tmp1576_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1588_ = async_call;
	_tmp1589_ = ccall;
	if (_tmp1588_ == _tmp1589_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	_tmp1590_ = return_result_via_out_param;
	if (_tmp1590_) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1591_;
		ValaDataType* _tmp1592_;
		ValaDataType* _tmp1593_;
		ValaLocalVariable* _tmp1594_;
		ValaLocalVariable* _tmp1595_;
		ValaLocalVariable* _tmp1596_;
		const gchar* _tmp1597_;
		const gchar* _tmp1598_;
		ValaCCodeExpression* _tmp1599_;
		ValaLocalVariable* _tmp1600_;
		ValaHashMap* _tmp1601_;
		ValaCCodeExpression* _tmp1602_;
		ValaCCodeUnaryExpression* _tmp1603_;
		ValaCCodeUnaryExpression* _tmp1604_;
		_tmp1591_ = itype;
		_tmp1592_ = vala_data_type_get_return_type (_tmp1591_);
		_tmp1593_ = _tmp1592_;
		_tmp1594_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1593_, TRUE, NULL, TRUE);
		_tmp1595_ = _tmp1594_;
		_vala_code_node_unref0 (_tmp1593_);
		out_param_var = _tmp1595_;
		_tmp1596_ = out_param_var;
		_tmp1597_ = vala_symbol_get_name ((ValaSymbol*) _tmp1596_);
		_tmp1598_ = _tmp1597_;
		_tmp1599_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1598_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1599_;
		_tmp1600_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1600_);
		_tmp1601_ = out_arg_map;
		_tmp1602_ = out_param_ref;
		_tmp1603_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1602_);
		_tmp1604_ = _tmp1603_;
		vala_map_set ((ValaMap*) _tmp1601_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1604_);
		_vala_ccode_node_unref0 (_tmp1604_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1605_ = async_call;
	_tmp1606_ = ccall;
	if (_tmp1605_ != _tmp1606_) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1623_;
			ValaCCodeFunctionCall* _tmp1624_;
			ValaHashMap* _tmp1625_;
			gint _tmp1626_;
			gpointer _tmp1627_;
			ValaCCodeExpression* _tmp1628_;
			gint _tmp1629_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1607_;
				ValaSet* _tmp1608_;
				ValaSet* _tmp1609_;
				ValaIterator* _tmp1610_;
				ValaIterator* _tmp1611_;
				_tmp1607_ = out_arg_map;
				_tmp1608_ = vala_map_get_keys ((ValaMap*) _tmp1607_);
				_tmp1609_ = _tmp1608_;
				_tmp1610_ = vala_iterable_iterator ((ValaIterable*) _tmp1609_);
				_tmp1611_ = _tmp1610_;
				_vala_iterable_unref0 (_tmp1609_);
				_pos_it = _tmp1611_;
				while (TRUE) {
					ValaIterator* _tmp1612_;
					gint pos = 0;
					ValaIterator* _tmp1613_;
					gpointer _tmp1614_;
					gboolean _tmp1615_ = FALSE;
					gint _tmp1616_;
					gint _tmp1617_;
					_tmp1612_ = _pos_it;
					if (!vala_iterator_next (_tmp1612_)) {
						break;
					}
					_tmp1613_ = _pos_it;
					_tmp1614_ = vala_iterator_get (_tmp1613_);
					pos = (gint) ((gintptr) _tmp1614_);
					_tmp1616_ = pos;
					_tmp1617_ = last_pos;
					if (_tmp1616_ > _tmp1617_) {
						gboolean _tmp1618_ = FALSE;
						gint _tmp1619_;
						_tmp1619_ = min_pos;
						if (_tmp1619_ == -1) {
							_tmp1618_ = TRUE;
						} else {
							gint _tmp1620_;
							gint _tmp1621_;
							_tmp1620_ = pos;
							_tmp1621_ = min_pos;
							_tmp1618_ = _tmp1620_ < _tmp1621_;
						}
						_tmp1615_ = _tmp1618_;
					} else {
						_tmp1615_ = FALSE;
					}
					if (_tmp1615_) {
						gint _tmp1622_;
						_tmp1622_ = pos;
						min_pos = _tmp1622_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1623_ = min_pos;
			if (_tmp1623_ == -1) {
				break;
			}
			_tmp1624_ = ccall;
			_tmp1625_ = out_arg_map;
			_tmp1626_ = min_pos;
			_tmp1627_ = vala_map_get ((ValaMap*) _tmp1625_, (gpointer) ((gintptr) _tmp1626_));
			_tmp1628_ = (ValaCCodeExpression*) _tmp1627_;
			vala_ccode_function_call_add_argument (_tmp1624_, _tmp1628_);
			_vala_ccode_node_unref0 (_tmp1628_);
			_tmp1629_ = min_pos;
			last_pos = _tmp1629_;
		}
	}
	_tmp1630_ = async_call;
	if (_tmp1630_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1647_;
			ValaCCodeFunctionCall* _tmp1648_;
			ValaHashMap* _tmp1649_;
			gint _tmp1650_;
			gpointer _tmp1651_;
			ValaCCodeExpression* _tmp1652_;
			gint _tmp1653_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1631_;
				ValaSet* _tmp1632_;
				ValaSet* _tmp1633_;
				ValaIterator* _tmp1634_;
				ValaIterator* _tmp1635_;
				_tmp1631_ = in_arg_map;
				_tmp1632_ = vala_map_get_keys ((ValaMap*) _tmp1631_);
				_tmp1633_ = _tmp1632_;
				_tmp1634_ = vala_iterable_iterator ((ValaIterable*) _tmp1633_);
				_tmp1635_ = _tmp1634_;
				_vala_iterable_unref0 (_tmp1633_);
				_pos_it = _tmp1635_;
				while (TRUE) {
					ValaIterator* _tmp1636_;
					gint pos = 0;
					ValaIterator* _tmp1637_;
					gpointer _tmp1638_;
					gboolean _tmp1639_ = FALSE;
					gint _tmp1640_;
					gint _tmp1641_;
					_tmp1636_ = _pos_it;
					if (!vala_iterator_next (_tmp1636_)) {
						break;
					}
					_tmp1637_ = _pos_it;
					_tmp1638_ = vala_iterator_get (_tmp1637_);
					pos = (gint) ((gintptr) _tmp1638_);
					_tmp1640_ = pos;
					_tmp1641_ = last_pos;
					if (_tmp1640_ > _tmp1641_) {
						gboolean _tmp1642_ = FALSE;
						gint _tmp1643_;
						_tmp1643_ = min_pos;
						if (_tmp1643_ == -1) {
							_tmp1642_ = TRUE;
						} else {
							gint _tmp1644_;
							gint _tmp1645_;
							_tmp1644_ = pos;
							_tmp1645_ = min_pos;
							_tmp1642_ = _tmp1644_ < _tmp1645_;
						}
						_tmp1639_ = _tmp1642_;
					} else {
						_tmp1639_ = FALSE;
					}
					if (_tmp1639_) {
						gint _tmp1646_;
						_tmp1646_ = pos;
						min_pos = _tmp1646_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1647_ = min_pos;
			if (_tmp1647_ == -1) {
				break;
			}
			_tmp1648_ = async_call;
			_tmp1649_ = in_arg_map;
			_tmp1650_ = min_pos;
			_tmp1651_ = vala_map_get ((ValaMap*) _tmp1649_, (gpointer) ((gintptr) _tmp1650_));
			_tmp1652_ = (ValaCCodeExpression*) _tmp1651_;
			vala_ccode_function_call_add_argument (_tmp1648_, _tmp1652_);
			_vala_ccode_node_unref0 (_tmp1652_);
			_tmp1653_ = min_pos;
			last_pos = _tmp1653_;
		}
	}
	_tmp1654_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1655_ = _tmp1654_;
	if (_tmp1655_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1656_;
		gint _tmp1657_;
		ValaCCodeFunction* _tmp1658_;
		ValaCCodeFunction* _tmp1659_;
		ValaCCodeIdentifier* _tmp1660_;
		ValaCCodeIdentifier* _tmp1661_;
		ValaCCodeMemberAccess* _tmp1662_;
		ValaCCodeMemberAccess* _tmp1663_;
		gint _tmp1664_;
		gchar* _tmp1665_;
		gchar* _tmp1666_;
		ValaCCodeConstant* _tmp1667_;
		ValaCCodeConstant* _tmp1668_;
		ValaCCodeFunction* _tmp1669_;
		ValaCCodeFunction* _tmp1670_;
		ValaCCodeFunctionCall* _tmp1671_;
		ValaCCodeFunction* _tmp1672_;
		ValaCCodeFunction* _tmp1673_;
		ValaCCodeConstant* _tmp1674_;
		ValaCCodeConstant* _tmp1675_;
		ValaCCodeFunction* _tmp1676_;
		ValaCCodeFunction* _tmp1677_;
		gint _tmp1678_;
		gchar* _tmp1679_;
		gchar* _tmp1680_;
		_tmp1656_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1657_ = _tmp1656_->next_coroutine_state;
		_tmp1656_->next_coroutine_state = _tmp1657_ + 1;
		state = _tmp1657_;
		_tmp1658_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1659_ = _tmp1658_;
		_tmp1660_ = vala_ccode_identifier_new ("_data_");
		_tmp1661_ = _tmp1660_;
		_tmp1662_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1661_, "_state_");
		_tmp1663_ = _tmp1662_;
		_tmp1664_ = state;
		_tmp1665_ = g_strdup_printf ("%i", _tmp1664_);
		_tmp1666_ = _tmp1665_;
		_tmp1667_ = vala_ccode_constant_new (_tmp1666_);
		_tmp1668_ = _tmp1667_;
		vala_ccode_function_add_assignment (_tmp1659_, (ValaCCodeExpression*) _tmp1663_, (ValaCCodeExpression*) _tmp1668_);
		_vala_ccode_node_unref0 (_tmp1668_);
		_g_free0 (_tmp1666_);
		_vala_ccode_node_unref0 (_tmp1663_);
		_vala_ccode_node_unref0 (_tmp1661_);
		_tmp1669_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1670_ = _tmp1669_;
		_tmp1671_ = async_call;
		vala_ccode_function_add_expression (_tmp1670_, (ValaCCodeExpression*) _tmp1671_);
		_tmp1672_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1673_ = _tmp1672_;
		_tmp1674_ = vala_ccode_constant_new ("FALSE");
		_tmp1675_ = _tmp1674_;
		vala_ccode_function_add_return (_tmp1673_, (ValaCCodeExpression*) _tmp1675_);
		_vala_ccode_node_unref0 (_tmp1675_);
		_tmp1676_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1677_ = _tmp1676_;
		_tmp1678_ = state;
		_tmp1679_ = g_strdup_printf ("_state_%d", _tmp1678_);
		_tmp1680_ = _tmp1679_;
		vala_ccode_function_add_label (_tmp1677_, _tmp1680_);
		_g_free0 (_tmp1680_);
	}
	_tmp1681_ = vala_method_call_get_is_assert (expr);
	_tmp1682_ = _tmp1681_;
	if (_tmp1682_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1683_;
		ValaSourceReference* _tmp1684_;
		ValaSourceLocation _tmp1685_ = {0};
		ValaSourceLocation _tmp1686_;
		gchar* _tmp1687_;
		ValaSourceReference* _tmp1688_;
		ValaSourceReference* _tmp1689_;
		ValaSourceLocation _tmp1690_ = {0};
		ValaSourceLocation _tmp1691_;
		gchar* _tmp1692_;
		ValaSourceReference* _tmp1693_;
		ValaSourceReference* _tmp1694_;
		ValaSourceLocation _tmp1695_ = {0};
		ValaSourceLocation _tmp1696_;
		gchar* _tmp1697_;
		gchar* _tmp1698_;
		ValaCCodeFunctionCall* _tmp1699_;
		ValaCCodeIdentifier* _tmp1700_;
		ValaCCodeIdentifier* _tmp1701_;
		ValaCCodeFunctionCall* _tmp1702_;
		const gchar* _tmp1703_;
		gchar* _tmp1704_;
		gchar* _tmp1705_;
		gchar* _tmp1706_;
		gchar* _tmp1707_;
		gchar* _tmp1708_;
		gchar* _tmp1709_;
		ValaCCodeConstant* _tmp1710_;
		ValaCCodeConstant* _tmp1711_;
		_tmp1683_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1684_ = _tmp1683_;
		vala_source_reference_get_begin (_tmp1684_, &_tmp1685_);
		_tmp1686_ = _tmp1685_;
		_tmp1687_ = _tmp1686_.pos;
		_tmp1688_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1689_ = _tmp1688_;
		vala_source_reference_get_end (_tmp1689_, &_tmp1690_);
		_tmp1691_ = _tmp1690_;
		_tmp1692_ = _tmp1691_.pos;
		_tmp1693_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1694_ = _tmp1693_;
		vala_source_reference_get_begin (_tmp1694_, &_tmp1695_);
		_tmp1696_ = _tmp1695_;
		_tmp1697_ = _tmp1696_.pos;
		_tmp1698_ = string_substring ((const gchar*) _tmp1687_, (glong) 0, (glong) ((gint) (_tmp1692_ - _tmp1697_)));
		message = _tmp1698_;
		_tmp1699_ = ccall;
		_tmp1700_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1701_ = _tmp1700_;
		vala_ccode_function_call_set_call (_tmp1699_, (ValaCCodeExpression*) _tmp1701_);
		_vala_ccode_node_unref0 (_tmp1701_);
		_tmp1702_ = ccall;
		_tmp1703_ = message;
		_tmp1704_ = string_replace (_tmp1703_, "\n", " ");
		_tmp1705_ = _tmp1704_;
		_tmp1706_ = g_strescape (_tmp1705_, "");
		_tmp1707_ = _tmp1706_;
		_tmp1708_ = g_strdup_printf ("\"%s\"", _tmp1707_);
		_tmp1709_ = _tmp1708_;
		_tmp1710_ = vala_ccode_constant_new (_tmp1709_);
		_tmp1711_ = _tmp1710_;
		vala_ccode_function_call_add_argument (_tmp1702_, (ValaCCodeExpression*) _tmp1711_);
		_vala_ccode_node_unref0 (_tmp1711_);
		_g_free0 (_tmp1709_);
		_g_free0 (_tmp1707_);
		_g_free0 (_tmp1705_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	_tmp1712_ = return_result_via_out_param;
	if (_tmp1712_) {
		ValaCCodeFunction* _tmp1713_;
		ValaCCodeFunction* _tmp1714_;
		ValaCCodeExpression* _tmp1715_;
		ValaCCodeExpression* _tmp1716_;
		ValaCCodeExpression* _tmp1717_;
		_tmp1713_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1714_ = _tmp1713_;
		_tmp1715_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1714_, _tmp1715_);
		_tmp1716_ = out_param_ref;
		_tmp1717_ = _vala_ccode_node_ref0 (_tmp1716_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1717_;
	}
	_tmp1720_ = m;
	if (_tmp1720_ != NULL) {
		ValaMethod* _tmp1721_;
		ValaMemberBinding _tmp1722_;
		ValaMemberBinding _tmp1723_;
		_tmp1721_ = m;
		_tmp1722_ = vala_method_get_binding (_tmp1721_);
		_tmp1723_ = _tmp1722_;
		_tmp1719_ = _tmp1723_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1719_ = FALSE;
	}
	if (_tmp1719_) {
		ValaMethod* _tmp1724_;
		gboolean _tmp1725_;
		gboolean _tmp1726_;
		_tmp1724_ = m;
		_tmp1725_ = vala_method_get_returns_modified_pointer (_tmp1724_);
		_tmp1726_ = _tmp1725_;
		_tmp1718_ = _tmp1726_;
	} else {
		_tmp1718_ = FALSE;
	}
	if (_tmp1718_) {
		gboolean _tmp1727_ = FALSE;
		gboolean _tmp1728_ = FALSE;
		ValaMemberAccess* _tmp1729_;
		_tmp1729_ = ma;
		if (_tmp1729_ != NULL) {
			ValaMemberAccess* _tmp1730_;
			ValaExpression* _tmp1731_;
			ValaExpression* _tmp1732_;
			ValaSymbol* _tmp1733_;
			ValaSymbol* _tmp1734_;
			_tmp1730_ = ma;
			_tmp1731_ = vala_member_access_get_inner (_tmp1730_);
			_tmp1732_ = _tmp1731_;
			_tmp1733_ = vala_expression_get_symbol_reference (_tmp1732_);
			_tmp1734_ = _tmp1733_;
			_tmp1728_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1734_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1728_ = FALSE;
		}
		if (_tmp1728_) {
			ValaMemberAccess* _tmp1735_;
			ValaExpression* _tmp1736_;
			ValaExpression* _tmp1737_;
			_tmp1735_ = ma;
			_tmp1736_ = vala_member_access_get_inner (_tmp1735_);
			_tmp1737_ = _tmp1736_;
			_tmp1727_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1737_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1727_ = FALSE;
		}
		if (_tmp1727_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1738_;
			ValaExpression* _tmp1739_;
			ValaExpression* _tmp1740_;
			ValaSymbol* _tmp1741_;
			ValaSymbol* _tmp1742_;
			ValaProperty* _tmp1743_;
			ValaProperty* _tmp1744_;
			ValaMemberAccess* _tmp1745_;
			ValaExpression* _tmp1746_;
			ValaExpression* _tmp1747_;
			ValaExpression* _tmp1748_;
			ValaExpression* _tmp1749_;
			ValaDataType* _tmp1750_;
			ValaDataType* _tmp1751_;
			ValaCCodeExpression* _tmp1752_;
			ValaGLibValue* _tmp1753_;
			ValaGLibValue* _tmp1754_;
			_tmp1738_ = ma;
			_tmp1739_ = vala_member_access_get_inner (_tmp1738_);
			_tmp1740_ = _tmp1739_;
			_tmp1741_ = vala_expression_get_symbol_reference (_tmp1740_);
			_tmp1742_ = _tmp1741_;
			_tmp1743_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1742_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1743_;
			_tmp1744_ = prop;
			_tmp1745_ = ma;
			_tmp1746_ = vala_member_access_get_inner (_tmp1745_);
			_tmp1747_ = _tmp1746_;
			_tmp1748_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1747_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1749_ = _tmp1748_;
			_tmp1750_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1751_ = _tmp1750_;
			_tmp1752_ = ccall_expr;
			_tmp1753_ = vala_glib_value_new (_tmp1751_, _tmp1752_, FALSE);
			_tmp1754_ = _tmp1753_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1744_, _tmp1749_, (ValaTargetValue*) _tmp1754_);
			_vala_target_value_unref0 (_tmp1754_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1755_;
			ValaCCodeExpression* _tmp1756_;
			ValaCCodeAssignment* _tmp1757_;
			_tmp1755_ = instance;
			_tmp1756_ = ccall_expr;
			_tmp1757_ = vala_ccode_assignment_new (_tmp1755_, _tmp1756_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1757_;
		}
	}
	_tmp1760_ = m;
	if (_tmp1760_ != NULL) {
		ValaMethod* _tmp1761_;
		gchar* _tmp1762_;
		gchar* _tmp1763_;
		_tmp1761_ = m;
		_tmp1762_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1761_);
		_tmp1763_ = _tmp1762_;
		_tmp1759_ = _tmp1763_ != NULL;
		_g_free0 (_tmp1763_);
	} else {
		_tmp1759_ = FALSE;
	}
	if (_tmp1759_) {
		ValaMethod* _tmp1764_;
		gchar* _tmp1765_;
		gchar* _tmp1766_;
		ValaMethod* _tmp1767_;
		ValaDataType* _tmp1768_;
		ValaDataType* _tmp1769_;
		gchar* _tmp1770_;
		gchar* _tmp1771_;
		_tmp1764_ = m;
		_tmp1765_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1764_);
		_tmp1766_ = _tmp1765_;
		_tmp1767_ = m;
		_tmp1768_ = vala_callable_get_return_type ((ValaCallable*) _tmp1767_);
		_tmp1769_ = _tmp1768_;
		_tmp1770_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1769_);
		_tmp1771_ = _tmp1770_;
		_tmp1758_ = g_strcmp0 (_tmp1766_, _tmp1771_) != 0;
		_g_free0 (_tmp1771_);
		_g_free0 (_tmp1766_);
	} else {
		_tmp1758_ = FALSE;
	}
	if (_tmp1758_) {
		ValaCCodeExpression* _tmp1772_;
		ValaMethod* _tmp1773_;
		ValaDataType* _tmp1774_;
		ValaDataType* _tmp1775_;
		gchar* _tmp1776_;
		gchar* _tmp1777_;
		ValaCCodeCastExpression* _tmp1778_;
		_tmp1772_ = ccall_expr;
		_tmp1773_ = m;
		_tmp1774_ = vala_callable_get_return_type ((ValaCallable*) _tmp1773_);
		_tmp1775_ = _tmp1774_;
		_tmp1776_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1775_);
		_tmp1777_ = _tmp1776_;
		_tmp1778_ = vala_ccode_cast_expression_new (_tmp1772_, _tmp1777_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1778_;
		_g_free0 (_tmp1777_);
	}
	_tmp1779_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1779_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1780_;
		ValaList* _tmp1781_;
		ValaIterator* _tmp1782_;
		ValaIterator* _tmp1783_;
		ValaIterator* _tmp1784_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1785_;
		gpointer _tmp1786_;
		ValaExpression* _tmp1787_;
		ValaCCodeExpression* _tmp1788_;
		ValaCCodeExpression* _tmp1789_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1790_;
		ValaLocalVariable* _tmp1791_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1792_;
		const gchar* _tmp1793_;
		const gchar* _tmp1794_;
		ValaCCodeExpression* _tmp1795_;
		ValaLocalVariable* _tmp1796_;
		ValaCCodeFile* _tmp1797_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1798_;
		ValaExpression* _tmp1799_;
		ValaExpression* _tmp1800_;
		ValaCCodeExpression* _tmp1801_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1802_;
		ValaExpression* _tmp1803_;
		ValaExpression* _tmp1804_;
		ValaCCodeExpression* _tmp1805_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1806_;
		ValaExpression* _tmp1807_;
		ValaExpression* _tmp1808_;
		ValaDataType* _tmp1809_;
		ValaDataType* _tmp1810_;
		ValaArrayType* _tmp1811_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1812_;
		ValaDataType* _tmp1813_;
		ValaDataType* _tmp1814_;
		gchar* _tmp1815_;
		gchar* _tmp1816_;
		gchar* _tmp1817_;
		gchar* _tmp1818_;
		ValaCCodeIdentifier* _tmp1819_;
		ValaCCodeIdentifier* _tmp1820_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1821_;
		ValaCCodeExpression* _tmp1822_;
		ValaCCodeBinaryExpression* _tmp1823_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1824_;
		ValaCCodeExpression* _tmp1825_;
		ValaCCodeBinaryExpression* _tmp1826_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1827_;
		ValaCCodeIdentifier* _tmp1828_;
		ValaCCodeFunctionCall* _tmp1829_;
		ValaCCodeFunctionCall* _tmp1830_;
		ValaCCodeFunctionCall* _tmp1831_;
		ValaCCodeExpression* _tmp1832_;
		ValaCCodeExpression* _tmp1833_;
		ValaCCodeBinaryExpression* _tmp1834_;
		ValaCCodeBinaryExpression* _tmp1835_;
		ValaCCodeFunctionCall* _tmp1836_;
		ValaCCodeConstant* _tmp1837_;
		ValaCCodeConstant* _tmp1838_;
		ValaCCodeFunctionCall* _tmp1839_;
		ValaCCodeIdentifier* _tmp1840_;
		ValaCCodeBinaryExpression* _tmp1841_;
		ValaCCodeBinaryExpression* _tmp1842_;
		ValaCCodeBinaryExpression* _tmp1843_;
		ValaCCodeFunction* _tmp1844_;
		ValaCCodeFunction* _tmp1845_;
		ValaCCodeExpression* _tmp1846_;
		ValaCCodeExpression* _tmp1847_;
		ValaCCodeFunction* _tmp1848_;
		ValaCCodeFunction* _tmp1849_;
		ValaCCodeExpression* _tmp1850_;
		ValaCCodeFunction* _tmp1851_;
		ValaCCodeFunction* _tmp1852_;
		ValaCCodeBinaryExpression* _tmp1853_;
		ValaCCodeFunctionCall* _tmp1854_;
		ValaCCodeConstant* _tmp1855_;
		ValaCCodeConstant* _tmp1856_;
		ValaCCodeConditionalExpression* _tmp1857_;
		ValaCCodeConditionalExpression* _tmp1858_;
		ValaCCodeFunction* _tmp1859_;
		ValaCCodeFunction* _tmp1860_;
		ValaMemberAccess* _tmp1861_;
		ValaExpression* _tmp1862_;
		ValaExpression* _tmp1863_;
		ValaCCodeExpression* _tmp1864_;
		ValaCCodeExpression* _tmp1865_;
		ValaCCodeExpression* _tmp1866_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1867_;
		ValaExpression* _tmp1868_;
		ValaExpression* _tmp1869_;
		ValaSymbol* _tmp1870_;
		ValaSymbol* _tmp1871_;
		ValaSymbol* _tmp1872_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1873_;
		ValaLocalVariable* _tmp1874_;
		gboolean _tmp1875_ = FALSE;
		gboolean _tmp1876_ = FALSE;
		ValaSymbol* _tmp1877_;
		_tmp1780_ = vala_method_call_get_argument_list (expr);
		_tmp1781_ = _tmp1780_;
		_tmp1782_ = vala_iterable_iterator ((ValaIterable*) _tmp1781_);
		_tmp1783_ = _tmp1782_;
		_vala_iterable_unref0 (_tmp1781_);
		arg_it = _tmp1783_;
		_tmp1784_ = arg_it;
		vala_iterator_next (_tmp1784_);
		_tmp1785_ = arg_it;
		_tmp1786_ = vala_iterator_get (_tmp1785_);
		_tmp1787_ = (ValaExpression*) _tmp1786_;
		_tmp1788_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1787_);
		_tmp1789_ = _tmp1788_;
		_vala_code_node_unref0 (_tmp1787_);
		new_size = _tmp1789_;
		_tmp1790_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1791_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1790_, TRUE, NULL, FALSE);
		temp_decl = _tmp1791_;
		_tmp1792_ = temp_decl;
		_tmp1793_ = vala_symbol_get_name ((ValaSymbol*) _tmp1792_);
		_tmp1794_ = _tmp1793_;
		_tmp1795_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1794_);
		temp_ref = _tmp1795_;
		_tmp1796_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1796_);
		_tmp1797_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1797_, "string.h", FALSE);
		_tmp1798_ = ma;
		_tmp1799_ = vala_member_access_get_inner (_tmp1798_);
		_tmp1800_ = _tmp1799_;
		_tmp1801_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1800_, 1);
		clen = _tmp1801_;
		_tmp1802_ = ma;
		_tmp1803_ = vala_member_access_get_inner (_tmp1802_);
		_tmp1804_ = _tmp1803_;
		_tmp1805_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1804_);
		celems = _tmp1805_;
		_tmp1806_ = ma;
		_tmp1807_ = vala_member_access_get_inner (_tmp1806_);
		_tmp1808_ = _tmp1807_;
		_tmp1809_ = vala_expression_get_value_type (_tmp1808_);
		_tmp1810_ = _tmp1809_;
		_tmp1811_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1810_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1811_;
		_tmp1812_ = array_type;
		_tmp1813_ = vala_array_type_get_element_type (_tmp1812_);
		_tmp1814_ = _tmp1813_;
		_tmp1815_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1814_);
		_tmp1816_ = _tmp1815_;
		_tmp1817_ = g_strdup_printf ("sizeof (%s)", _tmp1816_);
		_tmp1818_ = _tmp1817_;
		_tmp1819_ = vala_ccode_identifier_new (_tmp1818_);
		_tmp1820_ = _tmp1819_;
		_g_free0 (_tmp1818_);
		_g_free0 (_tmp1816_);
		csizeof = _tmp1820_;
		_tmp1821_ = temp_ref;
		_tmp1822_ = clen;
		_tmp1823_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1821_, _tmp1822_);
		cdelta = _tmp1823_;
		_tmp1824_ = temp_ref;
		_tmp1825_ = clen;
		_tmp1826_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1824_, _tmp1825_);
		ccheck = _tmp1826_;
		_tmp1827_ = vala_ccode_identifier_new ("memset");
		_tmp1828_ = _tmp1827_;
		_tmp1829_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1828_);
		_tmp1830_ = _tmp1829_;
		_vala_ccode_node_unref0 (_tmp1828_);
		czero = _tmp1830_;
		_tmp1831_ = czero;
		_tmp1832_ = celems;
		_tmp1833_ = clen;
		_tmp1834_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1832_, _tmp1833_);
		_tmp1835_ = _tmp1834_;
		vala_ccode_function_call_add_argument (_tmp1831_, (ValaCCodeExpression*) _tmp1835_);
		_vala_ccode_node_unref0 (_tmp1835_);
		_tmp1836_ = czero;
		_tmp1837_ = vala_ccode_constant_new ("0");
		_tmp1838_ = _tmp1837_;
		vala_ccode_function_call_add_argument (_tmp1836_, (ValaCCodeExpression*) _tmp1838_);
		_vala_ccode_node_unref0 (_tmp1838_);
		_tmp1839_ = czero;
		_tmp1840_ = csizeof;
		_tmp1841_ = cdelta;
		_tmp1842_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1840_, (ValaCCodeExpression*) _tmp1841_);
		_tmp1843_ = _tmp1842_;
		vala_ccode_function_call_add_argument (_tmp1839_, (ValaCCodeExpression*) _tmp1843_);
		_vala_ccode_node_unref0 (_tmp1843_);
		_tmp1844_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1845_ = _tmp1844_;
		_tmp1846_ = temp_ref;
		_tmp1847_ = new_size;
		vala_ccode_function_add_assignment (_tmp1845_, _tmp1846_, _tmp1847_);
		_tmp1848_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1849_ = _tmp1848_;
		_tmp1850_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1849_, _tmp1850_);
		_tmp1851_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1852_ = _tmp1851_;
		_tmp1853_ = ccheck;
		_tmp1854_ = czero;
		_tmp1855_ = vala_ccode_constant_new ("NULL");
		_tmp1856_ = _tmp1855_;
		_tmp1857_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1853_, (ValaCCodeExpression*) _tmp1854_, (ValaCCodeExpression*) _tmp1856_);
		_tmp1858_ = _tmp1857_;
		vala_ccode_function_add_expression (_tmp1852_, (ValaCCodeExpression*) _tmp1858_);
		_vala_ccode_node_unref0 (_tmp1858_);
		_vala_ccode_node_unref0 (_tmp1856_);
		_tmp1859_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1860_ = _tmp1859_;
		_tmp1861_ = ma;
		_tmp1862_ = vala_member_access_get_inner (_tmp1861_);
		_tmp1863_ = _tmp1862_;
		_tmp1864_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1863_, 1);
		_tmp1865_ = _tmp1864_;
		_tmp1866_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1860_, _tmp1865_, _tmp1866_);
		_vala_ccode_node_unref0 (_tmp1865_);
		_tmp1867_ = ma;
		_tmp1868_ = vala_member_access_get_inner (_tmp1867_);
		_tmp1869_ = _tmp1868_;
		_tmp1870_ = vala_expression_get_symbol_reference (_tmp1869_);
		_tmp1871_ = _tmp1870_;
		_tmp1872_ = _vala_code_node_ref0 (_tmp1871_);
		array_var = _tmp1872_;
		_tmp1873_ = array_var;
		_tmp1874_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1873_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1873_) : NULL);
		array_local = _tmp1874_;
		_tmp1877_ = array_var;
		if (_tmp1877_ != NULL) {
			ValaSymbol* _tmp1878_;
			_tmp1878_ = array_var;
			_tmp1876_ = vala_symbol_is_internal_symbol (_tmp1878_);
		} else {
			_tmp1876_ = FALSE;
		}
		if (_tmp1876_) {
			gboolean _tmp1879_ = FALSE;
			gboolean _tmp1880_ = FALSE;
			ValaSymbol* _tmp1881_;
			_tmp1881_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1881_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1882_;
				gboolean _tmp1883_;
				gboolean _tmp1884_;
				_tmp1882_ = array_local;
				_tmp1883_ = vala_local_variable_get_captured (_tmp1882_);
				_tmp1884_ = _tmp1883_;
				_tmp1880_ = !_tmp1884_;
			} else {
				_tmp1880_ = FALSE;
			}
			if (_tmp1880_) {
				_tmp1879_ = TRUE;
			} else {
				ValaSymbol* _tmp1885_;
				_tmp1885_ = array_var;
				_tmp1879_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1885_, VALA_TYPE_FIELD);
			}
			_tmp1875_ = _tmp1879_;
		} else {
			_tmp1875_ = FALSE;
		}
		if (_tmp1875_) {
			ValaCCodeFunction* _tmp1886_;
			ValaCCodeFunction* _tmp1887_;
			ValaMemberAccess* _tmp1888_;
			ValaExpression* _tmp1889_;
			ValaExpression* _tmp1890_;
			ValaTargetValue* _tmp1891_;
			ValaTargetValue* _tmp1892_;
			ValaCCodeExpression* _tmp1893_;
			ValaCCodeExpression* _tmp1894_;
			ValaCCodeExpression* _tmp1895_;
			_tmp1886_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1887_ = _tmp1886_;
			_tmp1888_ = ma;
			_tmp1889_ = vala_member_access_get_inner (_tmp1888_);
			_tmp1890_ = _tmp1889_;
			_tmp1891_ = vala_expression_get_target_value (_tmp1890_);
			_tmp1892_ = _tmp1891_;
			_tmp1893_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1892_);
			_tmp1894_ = _tmp1893_;
			_tmp1895_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1887_, _tmp1894_, _tmp1895_);
			_vala_ccode_node_unref0 (_tmp1894_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1897_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1898_ = _tmp1897_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1898_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1899_;
		ValaDataType* _tmp1900_;
		_tmp1899_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1900_ = _tmp1899_;
		_tmp1896_ = !vala_data_type_is_disposable (_tmp1900_);
	} else {
		_tmp1896_ = FALSE;
	}
	if (_tmp1896_) {
		gboolean _tmp1901_ = FALSE;
		ValaCCodeExpression* _tmp1902_;
		_tmp1902_ = ccall_expr;
		if (_tmp1902_ != NULL) {
			gboolean _tmp1903_;
			_tmp1903_ = return_result_via_out_param;
			_tmp1901_ = !_tmp1903_;
		} else {
			_tmp1901_ = FALSE;
		}
		if (_tmp1901_) {
			ValaCCodeFunction* _tmp1904_;
			ValaCCodeFunction* _tmp1905_;
			ValaCCodeExpression* _tmp1906_;
			_tmp1904_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1905_ = _tmp1904_;
			_tmp1906_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1905_, _tmp1906_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1907_;
		ValaDataType* _tmp1908_;
		gboolean _tmp1909_ = FALSE;
		ValaDataType* _tmp1910_;
		ValaDataType* _tmp1911_;
		gboolean _tmp1938_ = FALSE;
		ValaMethod* _tmp1939_;
		_tmp1907_ = itype;
		_tmp1908_ = vala_data_type_get_return_type (_tmp1907_);
		result_type = _tmp1908_;
		_tmp1910_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1911_ = _tmp1910_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1911_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1912_;
			ValaDataType* _tmp1913_;
			_tmp1912_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1913_ = _tmp1912_;
			_tmp1909_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1913_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1909_ = FALSE;
		}
		if (_tmp1909_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1914_;
			ValaDataType* _tmp1915_;
			ValaTypeParameter* _tmp1916_;
			ValaTypeParameter* _tmp1917_;
			ValaTypeParameter* _tmp1918_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1919_;
			ValaSymbol* _tmp1920_;
			ValaSymbol* _tmp1921_;
			ValaSymbol* _tmp1922_;
			ValaSymbol* _tmp1923_;
			ValaStruct* _tmp1924_;
			gboolean _tmp1925_ = FALSE;
			ValaTypeParameter* _tmp1926_;
			ValaSymbol* _tmp1927_;
			ValaSymbol* _tmp1928_;
			ValaTypeSymbol* _tmp1929_;
			_tmp1914_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1915_ = _tmp1914_;
			_tmp1916_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1915_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1917_ = _tmp1916_;
			_tmp1918_ = _vala_code_node_ref0 (_tmp1917_);
			type_parameter = _tmp1918_;
			_tmp1919_ = type_parameter;
			_tmp1920_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1919_);
			_tmp1921_ = _tmp1920_;
			_tmp1922_ = vala_symbol_get_parent_symbol (_tmp1921_);
			_tmp1923_ = _tmp1922_;
			_tmp1924_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1923_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1923_) : NULL);
			st = _tmp1924_;
			_tmp1926_ = type_parameter;
			_tmp1927_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1926_);
			_tmp1928_ = _tmp1927_;
			_tmp1929_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1928_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1929_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1925_ = TRUE;
			} else {
				gboolean _tmp1930_ = FALSE;
				ValaStruct* _tmp1931_;
				_tmp1931_ = st;
				if (_tmp1931_ != NULL) {
					ValaStruct* _tmp1932_;
					gchar* _tmp1933_;
					gchar* _tmp1934_;
					_tmp1932_ = st;
					_tmp1933_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1932_);
					_tmp1934_ = _tmp1933_;
					_tmp1930_ = g_strcmp0 (_tmp1934_, "va_list") == 0;
					_g_free0 (_tmp1934_);
				} else {
					_tmp1930_ = FALSE;
				}
				_tmp1925_ = _tmp1930_;
			}
			if (_tmp1925_) {
				ValaDataType* _tmp1935_;
				ValaDataType* _tmp1936_;
				ValaDataType* _tmp1937_;
				_tmp1935_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1936_ = _tmp1935_;
				_tmp1937_ = _vala_code_node_ref0 (_tmp1936_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1937_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp1939_ = m;
		if (_tmp1939_ != NULL) {
			ValaMethod* _tmp1940_;
			_tmp1940_ = m;
			_tmp1938_ = vala_method_get_format_arg_index (_tmp1940_) >= 0;
		} else {
			_tmp1938_ = FALSE;
		}
		if (_tmp1938_) {
			ValaCCodeExpression* _tmp1941_;
			_tmp1941_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1941_);
		} else {
			gboolean _tmp1942_ = FALSE;
			ValaMethod* _tmp1943_;
			_tmp1943_ = m;
			if (_tmp1943_ != NULL) {
				ValaMethod* _tmp1944_;
				_tmp1944_ = m;
				_tmp1942_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp1944_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp1942_ = FALSE;
			}
			if (_tmp1942_) {
				ValaCCodeExpression* _tmp1945_;
				_tmp1945_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1945_);
			} else {
				gboolean _tmp1946_ = FALSE;
				gboolean _tmp1947_ = FALSE;
				gboolean _tmp1948_;
				_tmp1948_ = return_result_via_out_param;
				if (!_tmp1948_) {
					gboolean _tmp1949_ = FALSE;
					gboolean _tmp1950_ = FALSE;
					ValaMethod* _tmp1951_;
					_tmp1951_ = m;
					if (_tmp1951_ != NULL) {
						ValaMethod* _tmp1952_;
						_tmp1952_ = m;
						_tmp1950_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp1952_);
					} else {
						_tmp1950_ = FALSE;
					}
					if (_tmp1950_) {
						_tmp1949_ = TRUE;
					} else {
						gboolean _tmp1953_ = FALSE;
						ValaDelegate* _tmp1954_;
						_tmp1954_ = deleg;
						if (_tmp1954_ != NULL) {
							ValaDelegate* _tmp1955_;
							_tmp1955_ = deleg;
							_tmp1953_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp1955_);
						} else {
							_tmp1953_ = FALSE;
						}
						_tmp1949_ = _tmp1953_;
					}
					_tmp1947_ = _tmp1949_;
				} else {
					_tmp1947_ = FALSE;
				}
				if (_tmp1947_) {
					gboolean _tmp1956_ = FALSE;
					ValaDataType* _tmp1957_;
					_tmp1957_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1957_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp1958_;
						_tmp1958_ = result_type;
						_tmp1956_ = !vala_data_type_is_disposable (_tmp1958_);
					} else {
						_tmp1956_ = FALSE;
					}
					_tmp1946_ = _tmp1956_;
				} else {
					_tmp1946_ = FALSE;
				}
				if (_tmp1946_) {
					ValaCCodeExpression* _tmp1959_;
					_tmp1959_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1959_);
				} else {
					gboolean _tmp1960_;
					_tmp1960_ = return_result_via_out_param;
					if (!_tmp1960_) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1961_;
						ValaDataType* _tmp1962_;
						gboolean _tmp1963_;
						gboolean _tmp1964_;
						ValaLocalVariable* _tmp1965_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1966_;
						const gchar* _tmp1967_;
						const gchar* _tmp1968_;
						ValaCCodeExpression* _tmp1969_;
						ValaLocalVariable* _tmp1970_;
						ValaCCodeFunction* _tmp1971_;
						ValaCCodeFunction* _tmp1972_;
						ValaCCodeExpression* _tmp1973_;
						ValaCCodeExpression* _tmp1974_;
						ValaCCodeExpression* _tmp1975_;
						ValaTargetValue* _tmp1976_;
						ValaTargetValue* _tmp1977_;
						_tmp1961_ = result_type;
						_tmp1962_ = result_type;
						_tmp1963_ = vala_data_type_get_value_owned (_tmp1962_);
						_tmp1964_ = _tmp1963_;
						_tmp1965_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1961_, _tmp1964_, NULL, FALSE);
						temp_var = _tmp1965_;
						_tmp1966_ = temp_var;
						_tmp1967_ = vala_symbol_get_name ((ValaSymbol*) _tmp1966_);
						_tmp1968_ = _tmp1967_;
						_tmp1969_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1968_);
						temp_ref = _tmp1969_;
						_tmp1970_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1970_);
						_tmp1971_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp1972_ = _tmp1971_;
						_tmp1973_ = temp_ref;
						_tmp1974_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp1972_, _tmp1973_, _tmp1974_);
						_tmp1975_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1975_);
						_tmp1976_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1977_ = _tmp1976_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1977_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp1978_;
						ValaTargetValue* _tmp1979_;
						ValaTargetValue* _tmp1980_;
						_tmp1978_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1978_);
						_tmp1979_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1980_ = _tmp1979_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1980_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp1981_ = params;
	_tmp1982_ = vala_iterable_iterator ((ValaIterable*) _tmp1981_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp1982_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1983_;
		gint _arg_size = 0;
		ValaList* _tmp1984_;
		gint _tmp1985_;
		gint _tmp1986_;
		gint _arg_index = 0;
		_tmp1983_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp1983_;
		_tmp1984_ = _arg_list;
		_tmp1985_ = vala_collection_get_size ((ValaCollection*) _tmp1984_);
		_tmp1986_ = _tmp1985_;
		_arg_size = _tmp1986_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp1987_;
			gint _tmp1988_;
			gint _tmp1989_;
			ValaExpression* arg = NULL;
			ValaList* _tmp1990_;
			gint _tmp1991_;
			gpointer _tmp1992_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1993_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2003_;
			ValaUnaryExpression* _tmp2004_;
			gboolean _tmp2005_ = FALSE;
			ValaUnaryExpression* _tmp2006_;
			ValaUnaryExpression* _tmp2010_;
			ValaExpression* _tmp2011_;
			ValaExpression* _tmp2012_;
			ValaDataType* _tmp2013_;
			ValaDataType* _tmp2014_;
			ValaUnaryExpression* _tmp2024_;
			ValaExpression* _tmp2025_;
			ValaExpression* _tmp2026_;
			ValaTargetValue* _tmp2027_;
			ValaTargetValue* _tmp2028_;
			ValaUnaryExpression* _tmp2029_;
			ValaTargetValue* _tmp2030_;
			ValaTargetValue* _tmp2031_;
			ValaUnaryExpression* _tmp2032_;
			ValaExpression* _tmp2033_;
			ValaExpression* _tmp2034_;
			ValaDataType* _tmp2035_;
			ValaDataType* _tmp2036_;
			ValaExpression* _tmp2037_;
			ValaTargetValue* _tmp2038_;
			ValaTargetValue* _tmp2039_;
			ValaSourceReference* _tmp2040_;
			ValaSourceReference* _tmp2041_;
			gboolean _tmp2042_ = FALSE;
			ValaParameter* _tmp2043_;
			_tmp1987_ = _arg_index;
			_arg_index = _tmp1987_ + 1;
			_tmp1988_ = _arg_index;
			_tmp1989_ = _arg_size;
			if (!(_tmp1988_ < _tmp1989_)) {
				break;
			}
			_tmp1990_ = _arg_list;
			_tmp1991_ = _arg_index;
			_tmp1992_ = vala_list_get (_tmp1990_, _tmp1991_);
			arg = (ValaExpression*) _tmp1992_;
			param = NULL;
			_tmp1993_ = params_it;
			if (vala_iterator_next (_tmp1993_)) {
				ValaIterator* _tmp1994_;
				gpointer _tmp1995_;
				gboolean _tmp1996_ = FALSE;
				ValaParameter* _tmp1997_;
				gboolean _tmp1998_;
				gboolean _tmp1999_;
				_tmp1994_ = params_it;
				_tmp1995_ = vala_iterator_get (_tmp1994_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1995_;
				_tmp1997_ = param;
				_tmp1998_ = vala_parameter_get_params_array (_tmp1997_);
				_tmp1999_ = _tmp1998_;
				if (_tmp1999_) {
					_tmp1996_ = TRUE;
				} else {
					ValaParameter* _tmp2000_;
					gboolean _tmp2001_;
					gboolean _tmp2002_;
					_tmp2000_ = param;
					_tmp2001_ = vala_parameter_get_ellipsis (_tmp2000_);
					_tmp2002_ = _tmp2001_;
					_tmp1996_ = _tmp2002_;
				}
				if (_tmp1996_) {
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (arg);
					break;
				}
			}
			_tmp2003_ = arg;
			_tmp2004_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2003_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2003_) : NULL);
			unary = _tmp2004_;
			_tmp2006_ = unary;
			if (_tmp2006_ == NULL) {
				_tmp2005_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2007_;
				ValaUnaryOperator _tmp2008_;
				ValaUnaryOperator _tmp2009_;
				_tmp2007_ = unary;
				_tmp2008_ = vala_unary_expression_get_operator (_tmp2007_);
				_tmp2009_ = _tmp2008_;
				_tmp2005_ = _tmp2009_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2005_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2010_ = unary;
			_tmp2011_ = vala_unary_expression_get_inner (_tmp2010_);
			_tmp2012_ = _tmp2011_;
			_tmp2013_ = vala_expression_get_value_type (_tmp2012_);
			_tmp2014_ = _tmp2013_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp2014_)) {
				ValaCCodeFunction* _tmp2015_;
				ValaCCodeFunction* _tmp2016_;
				ValaUnaryExpression* _tmp2017_;
				ValaExpression* _tmp2018_;
				ValaExpression* _tmp2019_;
				ValaTargetValue* _tmp2020_;
				ValaTargetValue* _tmp2021_;
				ValaCCodeExpression* _tmp2022_;
				ValaCCodeExpression* _tmp2023_;
				_tmp2015_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2016_ = _tmp2015_;
				_tmp2017_ = unary;
				_tmp2018_ = vala_unary_expression_get_inner (_tmp2017_);
				_tmp2019_ = _tmp2018_;
				_tmp2020_ = vala_expression_get_target_value (_tmp2019_);
				_tmp2021_ = _tmp2020_;
				_tmp2022_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2021_, FALSE);
				_tmp2023_ = _tmp2022_;
				vala_ccode_function_add_expression (_tmp2016_, _tmp2023_);
				_vala_ccode_node_unref0 (_tmp2023_);
			}
			_tmp2024_ = unary;
			_tmp2025_ = vala_unary_expression_get_inner (_tmp2024_);
			_tmp2026_ = _tmp2025_;
			_tmp2027_ = vala_expression_get_target_value (_tmp2026_);
			_tmp2028_ = _tmp2027_;
			_tmp2029_ = unary;
			_tmp2030_ = vala_expression_get_target_value ((ValaExpression*) _tmp2029_);
			_tmp2031_ = _tmp2030_;
			_tmp2032_ = unary;
			_tmp2033_ = vala_unary_expression_get_inner (_tmp2032_);
			_tmp2034_ = _tmp2033_;
			_tmp2035_ = vala_expression_get_value_type (_tmp2034_);
			_tmp2036_ = _tmp2035_;
			_tmp2037_ = arg;
			_tmp2038_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2031_, _tmp2036_, (ValaCodeNode*) _tmp2037_);
			_tmp2039_ = _tmp2038_;
			_tmp2040_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2041_ = _tmp2040_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2028_, _tmp2039_, _tmp2041_);
			_vala_target_value_unref0 (_tmp2039_);
			_tmp2043_ = param;
			if (_tmp2043_ != NULL) {
				ValaParameter* _tmp2044_;
				_tmp2044_ = param;
				_tmp2042_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2044_);
			} else {
				_tmp2042_ = FALSE;
			}
			if (_tmp2042_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2045_;
				ValaCCodeIdentifier* _tmp2046_;
				ValaCCodeFunctionCall* _tmp2047_;
				ValaCCodeFunctionCall* _tmp2048_;
				ValaCCodeFunctionCall* _tmp2049_;
				ValaUnaryExpression* _tmp2050_;
				ValaExpression* _tmp2051_;
				ValaExpression* _tmp2052_;
				ValaTargetValue* _tmp2053_;
				ValaTargetValue* _tmp2054_;
				ValaCCodeExpression* _tmp2055_;
				ValaCCodeExpression* _tmp2056_;
				ValaCCodeFunction* _tmp2057_;
				ValaCCodeFunction* _tmp2058_;
				ValaUnaryExpression* _tmp2059_;
				ValaExpression* _tmp2060_;
				ValaExpression* _tmp2061_;
				ValaTargetValue* _tmp2062_;
				ValaTargetValue* _tmp2063_;
				ValaCCodeExpression* _tmp2064_;
				ValaCCodeExpression* _tmp2065_;
				ValaCCodeFunctionCall* _tmp2066_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2045_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2046_ = _tmp2045_;
				_tmp2047_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2046_);
				_tmp2048_ = _tmp2047_;
				_vala_ccode_node_unref0 (_tmp2046_);
				len_call = _tmp2048_;
				_tmp2049_ = len_call;
				_tmp2050_ = unary;
				_tmp2051_ = vala_unary_expression_get_inner (_tmp2050_);
				_tmp2052_ = _tmp2051_;
				_tmp2053_ = vala_expression_get_target_value (_tmp2052_);
				_tmp2054_ = _tmp2053_;
				_tmp2055_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2054_);
				_tmp2056_ = _tmp2055_;
				vala_ccode_function_call_add_argument (_tmp2049_, _tmp2056_);
				_vala_ccode_node_unref0 (_tmp2056_);
				_tmp2057_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2058_ = _tmp2057_;
				_tmp2059_ = unary;
				_tmp2060_ = vala_unary_expression_get_inner (_tmp2059_);
				_tmp2061_ = _tmp2060_;
				_tmp2062_ = vala_expression_get_target_value (_tmp2061_);
				_tmp2063_ = _tmp2062_;
				_tmp2064_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2063_, 1);
				_tmp2065_ = _tmp2064_;
				_tmp2066_ = len_call;
				vala_ccode_function_add_assignment (_tmp2058_, _tmp2065_, (ValaCCodeExpression*) _tmp2066_);
				_vala_ccode_node_unref0 (_tmp2065_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2069_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2069_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2070_;
		ValaSymbol* _tmp2071_;
		ValaSymbol* _tmp2072_;
		_tmp2070_ = m;
		_tmp2071_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2070_);
		_tmp2072_ = _tmp2071_;
		_tmp2068_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2072_, VALA_TYPE_CLASS);
	} else {
		_tmp2068_ = FALSE;
	}
	if (_tmp2068_) {
		gboolean _tmp2073_ = FALSE;
		gboolean _tmp2074_ = FALSE;
		ValaClass* _tmp2075_;
		ValaClass* _tmp2076_;
		gboolean _tmp2077_;
		gboolean _tmp2078_;
		_tmp2075_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2076_ = _tmp2075_;
		_tmp2077_ = vala_class_get_is_compact (_tmp2076_);
		_tmp2078_ = _tmp2077_;
		if (_tmp2078_) {
			ValaClass* _tmp2079_;
			ValaClass* _tmp2080_;
			ValaClass* _tmp2081_;
			ValaClass* _tmp2082_;
			_tmp2079_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2080_ = _tmp2079_;
			_tmp2081_ = vala_class_get_base_class (_tmp2080_);
			_tmp2082_ = _tmp2081_;
			_tmp2074_ = _tmp2082_ != NULL;
		} else {
			_tmp2074_ = FALSE;
		}
		if (_tmp2074_) {
			_tmp2073_ = TRUE;
		} else {
			ValaClass* _tmp2083_;
			ValaClass* _tmp2084_;
			ValaClass* _tmp2085_;
			ValaClass* _tmp2086_;
			ValaClass* _tmp2087_;
			_tmp2083_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2084_ = _tmp2083_;
			_tmp2085_ = vala_class_get_base_class (_tmp2084_);
			_tmp2086_ = _tmp2085_;
			_tmp2087_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2073_ = _tmp2086_ == _tmp2087_;
		}
		_tmp2067_ = _tmp2073_;
	} else {
		_tmp2067_ = FALSE;
	}
	if (_tmp2067_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2088_;
		ValaClass* _tmp2089_;
		gchar* _tmp2090_;
		gchar* _tmp2091_;
		gchar* _tmp2092_;
		gchar* _tmp2093_;
		ValaCCodeIdentifier* _tmp2094_;
		ValaCCodeIdentifier* _tmp2095_;
		ValaCCodeFunctionCall* _tmp2096_;
		ValaCCodeFunctionCall* _tmp2097_;
		ValaCCodeFunctionCall* _tmp2098_;
		ValaCCodeExpression* _tmp2099_;
		ValaCCodeExpression* _tmp2100_;
		ValaCCodeFunction* _tmp2101_;
		ValaCCodeFunction* _tmp2102_;
		ValaCCodeFunctionCall* _tmp2103_;
		_tmp2088_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2089_ = _tmp2088_;
		_tmp2090_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2089_, NULL);
		_tmp2091_ = _tmp2090_;
		_tmp2092_ = g_strdup_printf ("%s_instance_init", _tmp2091_);
		_tmp2093_ = _tmp2092_;
		_tmp2094_ = vala_ccode_identifier_new (_tmp2093_);
		_tmp2095_ = _tmp2094_;
		_tmp2096_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2095_);
		_tmp2097_ = _tmp2096_;
		_vala_ccode_node_unref0 (_tmp2095_);
		_g_free0 (_tmp2093_);
		_g_free0 (_tmp2091_);
		cinitcall = _tmp2097_;
		_tmp2098_ = cinitcall;
		_tmp2099_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2100_ = _tmp2099_;
		vala_ccode_function_call_add_argument (_tmp2098_, _tmp2100_);
		_vala_ccode_node_unref0 (_tmp2100_);
		_tmp2101_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2102_ = _tmp2101_;
		_tmp2103_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2102_, (ValaCCodeExpression*) _tmp2103_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}


static gchar*
vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                               ValaEnum* en)
{
	gchar* result = NULL;
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeConstant* _tmp53_;
	ValaCCodeFile* _tmp54_;
	ValaCCodeFunction* _tmp55_;
	ValaCCodeFile* _tmp56_;
	ValaCCodeFunction* _tmp57_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaCCodeFunction* _tmp31_;
			ValaEnumValue* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeIdentifier* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaCCodeFunction* _tmp38_;
			ValaEnumValue* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaCCodeConstant* _tmp46_;
			ValaCCodeConstant* _tmp47_;
			_tmp24_ = _enum_value_index;
			_enum_value_index = _tmp24_ + 1;
			_tmp25_ = _enum_value_index;
			_tmp26_ = _enum_value_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _enum_value_list;
			_tmp28_ = _enum_value_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			enum_value = (ValaEnumValue*) _tmp29_;
			_tmp30_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp31_ = _tmp30_;
			_tmp32_ = enum_value;
			_tmp33_ = vala_get_ccode_name ((ValaCodeNode*) _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_identifier_new (_tmp34_);
			_tmp36_ = _tmp35_;
			vala_ccode_function_add_case (_tmp31_, (ValaCCodeExpression*) _tmp36_);
			_vala_ccode_node_unref0 (_tmp36_);
			_g_free0 (_tmp34_);
			_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = enum_value;
			_tmp40_ = vala_get_ccode_name ((ValaCodeNode*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat ("\"", _tmp41_, NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat (_tmp43_, "\"", NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_ccode_constant_new (_tmp45_);
			_tmp47_ = _tmp46_;
			vala_ccode_function_add_return (_tmp38_, (ValaCCodeExpression*) _tmp47_);
			_vala_ccode_node_unref0 (_tmp47_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp48_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp49_ = _tmp48_;
	vala_ccode_function_close (_tmp49_);
	_tmp50_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_ccode_constant_new ("NULL");
	_tmp53_ = _tmp52_;
	vala_ccode_function_add_return (_tmp51_, (ValaCCodeExpression*) _tmp53_);
	_vala_ccode_node_unref0 (_tmp53_);
	_tmp54_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp55_ = function;
	vala_ccode_file_add_function_declaration (_tmp54_, _tmp55_);
	_tmp56_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp57_ = function;
	vala_ccode_file_add_function (_tmp56_, _tmp57_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}


static gboolean
vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                 ValaCallable* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters (c);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaParameter* _tmp10_;
			ValaParameterDirection _tmp11_;
			ValaParameterDirection _tmp12_;
			_tmp4_ = _param_index;
			_param_index = _tmp4_ + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = _param_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = param;
			_tmp11_ = vala_parameter_get_direction (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != VALA_PARAMETER_DIRECTION_IN) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}


static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor *, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}


static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self)
{
}


GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



