/* gcomment.c generated by valac, the Vala compiler
 * generated from gcomment.vala, do not modify */

/* gcomment.vala
 *
 * Copyright (C) 2010 Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lethalman88@gmail.com>
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <valagee.h>
#include <valadoc.h>
#include <gobject/gvaluecollector.h>


#define GTKDOC_TYPE_HEADER (gtkdoc_header_get_type ())
#define GTKDOC_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_HEADER, GtkdocHeader))
#define GTKDOC_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_HEADER, GtkdocHeaderClass))
#define GTKDOC_IS_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_HEADER))
#define GTKDOC_IS_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_HEADER))
#define GTKDOC_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_HEADER, GtkdocHeaderClass))

typedef struct _GtkdocHeader GtkdocHeader;
typedef struct _GtkdocHeaderClass GtkdocHeaderClass;
typedef struct _GtkdocHeaderPrivate GtkdocHeaderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GtkdocParamSpecHeader GtkdocParamSpecHeader;

#define GTKDOC_TYPE_GCOMMENT (gtkdoc_gcomment_get_type ())
#define GTKDOC_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGComment))
#define GTKDOC_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))
#define GTKDOC_IS_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_IS_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_GCOMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))

typedef struct _GtkdocGComment GtkdocGComment;
typedef struct _GtkdocGCommentClass GtkdocGCommentClass;
typedef struct _GtkdocGCommentPrivate GtkdocGCommentPrivate;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _gtkdoc_header_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_header_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _GtkdocParamSpecGComment GtkdocParamSpecGComment;

struct _GtkdocHeader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* name;
	gchar** annotations;
	gint annotations_length1;
	gchar* value;
	gdouble pos;
	gboolean block;
	GtkdocHeaderPrivate * priv;
};

struct _GtkdocHeaderClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocHeader *self);
};

struct _GtkdocParamSpecHeader {
	GParamSpec parent_instance;
};

struct _GtkdocGComment {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* symbol;
	gchar** symbol_annotations;
	gint symbol_annotations_length1;
	ValaList* headers;
	gboolean short_description;
	gchar* brief_comment;
	gchar* long_comment;
	gchar* returns;
	gchar** returns_annotations;
	gint returns_annotations_length1;
	ValaList* versioning;
	gchar** see_also;
	gint see_also_length1;
	gboolean is_section;
	GtkdocGCommentPrivate * priv;
};

struct _GtkdocGCommentClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocGComment *self);
};

struct _GtkdocParamSpecGComment {
	GParamSpec parent_instance;
};


static gpointer gtkdoc_header_parent_class = NULL;
static gpointer gtkdoc_gcomment_parent_class = NULL;

gpointer gtkdoc_header_ref (gpointer instance);
void gtkdoc_header_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_header (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void gtkdoc_value_set_header (GValue* value,
                              gpointer v_object);
void gtkdoc_value_take_header (GValue* value,
                               gpointer v_object);
gpointer gtkdoc_value_get_header (const GValue* value);
GType gtkdoc_header_get_type (void) G_GNUC_CONST;
GtkdocHeader* gtkdoc_header_new (const gchar* name,
                                 const gchar* value,
                                 gdouble pos,
                                 gboolean block);
GtkdocHeader* gtkdoc_header_construct (GType object_type,
                                       const gchar* name,
                                       const gchar* value,
                                       gdouble pos,
                                       gboolean block);
gint gtkdoc_header_cmp (GtkdocHeader* self,
                        GtkdocHeader* header);
static void gtkdoc_header_finalize (GtkdocHeader * obj);
gpointer gtkdoc_gcomment_ref (gpointer instance);
void gtkdoc_gcomment_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_gcomment (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void gtkdoc_value_set_gcomment (GValue* value,
                                gpointer v_object);
void gtkdoc_value_take_gcomment (GValue* value,
                                 gpointer v_object);
gpointer gtkdoc_value_get_gcomment (const GValue* value);
GType gtkdoc_gcomment_get_type (void) G_GNUC_CONST;
gchar* gtkdoc_gcomment_to_string (GtkdocGComment* self);
gchar* gtkdoc_commentize (const gchar* comment);
gchar* gtkdoc_gcomment_to_docbook (GtkdocGComment* self,
                                   ValadocErrorReporter* reporter);
GtkdocGComment* gtkdoc_gcomment_new (void);
GtkdocGComment* gtkdoc_gcomment_construct (GType object_type);
static void gtkdoc_gcomment_finalize (GtkdocGComment * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


GtkdocHeader*
gtkdoc_header_construct (GType object_type,
                         const gchar* name,
                         const gchar* value,
                         gdouble pos,
                         gboolean block)
{
	GtkdocHeader* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GtkdocHeader*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	_tmp1_ = g_strdup (value);
	_g_free0 (self->value);
	self->value = _tmp1_;
	self->pos = pos;
	self->block = block;
	return self;
}


GtkdocHeader*
gtkdoc_header_new (const gchar* name,
                   const gchar* value,
                   gdouble pos,
                   gboolean block)
{
	return gtkdoc_header_construct (GTKDOC_TYPE_HEADER, name, value, pos, block);
}


gint
gtkdoc_header_cmp (GtkdocHeader* self,
                   GtkdocHeader* header)
{
	gint result = 0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (header != NULL, 0);
	_tmp0_ = self->pos;
	_tmp1_ = header->pos;
	if (_tmp0_ > _tmp1_) {
		result = 1;
		return result;
	} else {
		gdouble _tmp2_;
		gdouble _tmp3_;
		_tmp2_ = self->pos;
		_tmp3_ = header->pos;
		if (_tmp2_ < _tmp3_) {
			result = -1;
			return result;
		}
	}
	result = 0;
	return result;
}


static void
gtkdoc_value_header_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
gtkdoc_value_header_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_header_unref (value->data[0].v_pointer);
	}
}


static void
gtkdoc_value_header_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_header_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
gtkdoc_value_header_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
gtkdoc_value_header_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocHeader * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_header_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
gtkdoc_value_header_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	GtkdocHeader ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_header_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
gtkdoc_param_spec_header (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	GtkdocParamSpecHeader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_TYPE_HEADER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
gtkdoc_value_get_header (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_HEADER), NULL);
	return value->data[0].v_pointer;
}


void
gtkdoc_value_set_header (GValue* value,
                         gpointer v_object)
{
	GtkdocHeader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_HEADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_HEADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_header_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_header_unref (old);
	}
}


void
gtkdoc_value_take_header (GValue* value,
                          gpointer v_object)
{
	GtkdocHeader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_HEADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_HEADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_header_unref (old);
	}
}


static void
gtkdoc_header_class_init (GtkdocHeaderClass * klass)
{
	gtkdoc_header_parent_class = g_type_class_peek_parent (klass);
	((GtkdocHeaderClass *) klass)->finalize = gtkdoc_header_finalize;
}


static void
gtkdoc_header_instance_init (GtkdocHeader * self)
{
	self->ref_count = 1;
}


static void
gtkdoc_header_finalize (GtkdocHeader * obj)
{
	GtkdocHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_TYPE_HEADER, GtkdocHeader);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	self->annotations = (_vala_array_free (self->annotations, self->annotations_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->value);
}


GType
gtkdoc_header_get_type (void)
{
	static volatile gsize gtkdoc_header_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_header_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gtkdoc_value_header_init, gtkdoc_value_header_free_value, gtkdoc_value_header_copy_value, gtkdoc_value_header_peek_pointer, "p", gtkdoc_value_header_collect_value, "p", gtkdoc_value_header_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GtkdocHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocHeader), 0, (GInstanceInitFunc) gtkdoc_header_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gtkdoc_header_type_id;
		gtkdoc_header_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocHeader", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gtkdoc_header_type_id__volatile, gtkdoc_header_type_id);
	}
	return gtkdoc_header_type_id__volatile;
}


gpointer
gtkdoc_header_ref (gpointer instance)
{
	GtkdocHeader * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
gtkdoc_header_unref (gpointer instance)
{
	GtkdocHeader * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_HEADER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gsize _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		const gchar* res = NULL;
		gsize _tmp27_;
		void* _tmp28_;
		void* ptr = NULL;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		void* _tmp31_;
		const gchar* _tmp44_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = len;
		_tmp24_ = strlen ((const gchar*) separator);
		_tmp25_ = _tmp24_;
		_tmp26_ = i;
		len = _tmp23_ + (_tmp25_ * (_tmp26_ - 1));
		_tmp27_ = len;
		_tmp28_ = g_malloc (_tmp27_);
		res = _tmp28_;
		_tmp29_ = res;
		_tmp30_ = str_array[0];
		_tmp31_ = g_stpcpy ((void*) _tmp29_, (const gchar*) _tmp30_);
		ptr = _tmp31_;
		{
			gboolean _tmp32_ = FALSE;
			i = 1;
			_tmp32_ = TRUE;
			while (TRUE) {
				gint _tmp34_;
				void* _tmp35_;
				void* _tmp36_;
				const gchar* _tmp37_ = NULL;
				gint _tmp38_;
				const gchar* _tmp39_;
				void* _tmp42_;
				void* _tmp43_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = i;
				if (!(_tmp34_ < str_array_length1)) {
					break;
				}
				_tmp35_ = ptr;
				_tmp36_ = g_stpcpy (_tmp35_, (const gchar*) separator);
				ptr = _tmp36_;
				_tmp38_ = i;
				_tmp39_ = str_array[_tmp38_];
				if (_tmp39_ != NULL) {
					gint _tmp40_;
					const gchar* _tmp41_;
					_tmp40_ = i;
					_tmp41_ = str_array[_tmp40_];
					_tmp37_ = (const gchar*) _tmp41_;
				} else {
					_tmp37_ = "";
				}
				_tmp42_ = ptr;
				_tmp43_ = g_stpcpy (_tmp42_, _tmp37_);
				ptr = _tmp43_;
			}
		}
		_tmp44_ = res;
		res = NULL;
		result = (gchar*) _tmp44_;
		return result;
	} else {
		gchar* _tmp45_;
		_tmp45_ = g_strdup ("");
		result = _tmp45_;
		return result;
	}
}


gchar*
gtkdoc_gcomment_to_string (GtkdocGComment* self)
{
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	GString* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	ValaList* _tmp21_;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_;
	const gchar* _tmp61_;
	gchar** _tmp66_;
	gint _tmp66__length1;
	gboolean _tmp71_ = FALSE;
	const gchar* _tmp72_;
	ValaList* _tmp88_;
	gint _tmp89_;
	gint _tmp90_;
	GString* _tmp112_;
	GString* _tmp113_;
	const gchar* _tmp114_;
	gchar* _tmp115_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp2_ = self->is_section;
	if (_tmp2_) {
		_tmp1_ = "SECTION:%s";
	} else {
		_tmp1_ = "%s:";
	}
	_tmp3_ = builder;
	_tmp4_ = self->symbol;
	_tmp5_ = g_strdup_printf (_tmp1_, _tmp4_);
	_tmp6_ = _tmp5_;
	g_string_append_printf (_tmp3_, "/**\n * %s", _tmp6_);
	_g_free0 (_tmp6_);
	_tmp8_ = self->symbol_annotations;
	_tmp8__length1 = self->symbol_annotations_length1;
	if (_tmp8_ != NULL) {
		gchar** _tmp9_;
		gint _tmp9__length1;
		_tmp9_ = self->symbol_annotations;
		_tmp9__length1 = self->symbol_annotations_length1;
		_tmp7_ = _tmp9__length1 > 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gchar** _tmp10_;
		gint _tmp10__length1;
		_tmp10_ = self->symbol_annotations;
		_tmp10__length1 = self->symbol_annotations_length1;
		{
			gchar** annotation_collection = NULL;
			gint annotation_collection_length1 = 0;
			gint _annotation_collection_size_ = 0;
			gint annotation_it = 0;
			annotation_collection = _tmp10_;
			annotation_collection_length1 = _tmp10__length1;
			for (annotation_it = 0; annotation_it < annotation_collection_length1; annotation_it = annotation_it + 1) {
				gchar* _tmp11_;
				gchar* annotation = NULL;
				_tmp11_ = g_strdup (annotation_collection[annotation_it]);
				annotation = _tmp11_;
				{
					GString* _tmp12_;
					const gchar* _tmp13_;
					_tmp12_ = builder;
					_tmp13_ = annotation;
					g_string_append_printf (_tmp12_, " (%s)", _tmp13_);
					_g_free0 (annotation);
				}
			}
		}
	}
	_tmp15_ = self->short_description;
	if (_tmp15_) {
		const gchar* _tmp16_;
		_tmp16_ = self->brief_comment;
		_tmp14_ = _tmp16_ != NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		GString* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp17_ = builder;
		_tmp18_ = self->brief_comment;
		_tmp19_ = gtkdoc_commentize (_tmp18_);
		_tmp20_ = _tmp19_;
		g_string_append_printf (_tmp17_, "\n * @short_description: %s", _tmp20_);
		_g_free0 (_tmp20_);
	}
	_tmp21_ = self->headers;
	vala_list_sort (_tmp21_, (GCompareDataFunc) gtkdoc_header_cmp, NULL, NULL);
	{
		ValaList* _header_list = NULL;
		ValaList* _tmp22_;
		ValaList* _tmp23_;
		gint _header_size = 0;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _header_index = 0;
		_tmp22_ = self->headers;
		_tmp23_ = _vala_iterable_ref0 (_tmp22_);
		_header_list = _tmp23_;
		_tmp24_ = _header_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_header_size = _tmp26_;
		_header_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			GtkdocHeader* header = NULL;
			ValaList* _tmp29_;
			gint _tmp30_;
			gpointer _tmp31_;
			GString* _tmp32_;
			GtkdocHeader* _tmp33_;
			const gchar* _tmp34_;
			gboolean _tmp35_ = FALSE;
			GtkdocHeader* _tmp36_;
			gchar** _tmp37_;
			gint _tmp37__length1;
			GtkdocHeader* _tmp46_;
			const gchar* _tmp47_;
			_header_index = _header_index + 1;
			_tmp27_ = _header_index;
			_tmp28_ = _header_size;
			if (!(_tmp27_ < _tmp28_)) {
				break;
			}
			_tmp29_ = _header_list;
			_tmp30_ = _header_index;
			_tmp31_ = vala_list_get (_tmp29_, _tmp30_);
			header = (GtkdocHeader*) _tmp31_;
			_tmp32_ = builder;
			_tmp33_ = header;
			_tmp34_ = _tmp33_->name;
			g_string_append_printf (_tmp32_, "\n * @%s:", _tmp34_);
			_tmp36_ = header;
			_tmp37_ = _tmp36_->annotations;
			_tmp37__length1 = _tmp36_->annotations_length1;
			if (_tmp37_ != NULL) {
				GtkdocHeader* _tmp38_;
				gchar** _tmp39_;
				gint _tmp39__length1;
				_tmp38_ = header;
				_tmp39_ = _tmp38_->annotations;
				_tmp39__length1 = _tmp38_->annotations_length1;
				_tmp35_ = _tmp39__length1 > 0;
			} else {
				_tmp35_ = FALSE;
			}
			if (_tmp35_) {
				GtkdocHeader* _tmp40_;
				gchar** _tmp41_;
				gint _tmp41__length1;
				GString* _tmp45_;
				_tmp40_ = header;
				_tmp41_ = _tmp40_->annotations;
				_tmp41__length1 = _tmp40_->annotations_length1;
				{
					gchar** annotation_collection = NULL;
					gint annotation_collection_length1 = 0;
					gint _annotation_collection_size_ = 0;
					gint annotation_it = 0;
					annotation_collection = _tmp41_;
					annotation_collection_length1 = _tmp41__length1;
					for (annotation_it = 0; annotation_it < annotation_collection_length1; annotation_it = annotation_it + 1) {
						gchar* _tmp42_;
						gchar* annotation = NULL;
						_tmp42_ = g_strdup (annotation_collection[annotation_it]);
						annotation = _tmp42_;
						{
							GString* _tmp43_;
							const gchar* _tmp44_;
							_tmp43_ = builder;
							_tmp44_ = annotation;
							g_string_append_printf (_tmp43_, " (%s)", _tmp44_);
							_g_free0 (annotation);
						}
					}
				}
				_tmp45_ = builder;
				g_string_append_c (_tmp45_, ':');
			}
			_tmp46_ = header;
			_tmp47_ = _tmp46_->value;
			if (_tmp47_ != NULL) {
				GString* _tmp48_;
				GString* _tmp49_;
				GtkdocHeader* _tmp50_;
				const gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				_tmp48_ = builder;
				g_string_append_c (_tmp48_, ' ');
				_tmp49_ = builder;
				_tmp50_ = header;
				_tmp51_ = _tmp50_->value;
				_tmp52_ = gtkdoc_commentize (_tmp51_);
				_tmp53_ = _tmp52_;
				g_string_append (_tmp49_, _tmp53_);
				_g_free0 (_tmp53_);
			}
			_gtkdoc_header_unref0 (header);
		}
		_vala_iterable_unref0 (_header_list);
	}
	_tmp55_ = self->short_description;
	if (!_tmp55_) {
		const gchar* _tmp56_;
		_tmp56_ = self->brief_comment;
		_tmp54_ = _tmp56_ != NULL;
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		GString* _tmp57_;
		const gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		_tmp57_ = builder;
		_tmp58_ = self->brief_comment;
		_tmp59_ = gtkdoc_commentize (_tmp58_);
		_tmp60_ = _tmp59_;
		g_string_append_printf (_tmp57_, "\n * \n * %s", _tmp60_);
		_g_free0 (_tmp60_);
	}
	_tmp61_ = self->long_comment;
	if (_tmp61_ != NULL) {
		GString* _tmp62_;
		const gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		_tmp62_ = builder;
		_tmp63_ = self->long_comment;
		_tmp64_ = gtkdoc_commentize (_tmp63_);
		_tmp65_ = _tmp64_;
		g_string_append_printf (_tmp62_, "\n * \n * %s", _tmp65_);
		_g_free0 (_tmp65_);
	}
	_tmp66_ = self->see_also;
	_tmp66__length1 = self->see_also_length1;
	if (_tmp66__length1 > 0) {
		GString* _tmp67_;
		gchar** _tmp68_;
		gint _tmp68__length1;
		gchar* _tmp69_;
		gchar* _tmp70_;
		_tmp67_ = builder;
		_tmp68_ = self->see_also;
		_tmp68__length1 = self->see_also_length1;
		_tmp69_ = _vala_g_strjoinv (", ", _tmp68_, _tmp68__length1);
		_tmp70_ = _tmp69_;
		g_string_append_printf (_tmp67_, "\n * \n * <emphasis>See also</emphasis>: %s", _tmp70_);
		_g_free0 (_tmp70_);
	}
	_tmp72_ = self->returns;
	if (_tmp72_ != NULL) {
		_tmp71_ = TRUE;
	} else {
		gchar** _tmp73_;
		gint _tmp73__length1;
		_tmp73_ = self->returns_annotations;
		_tmp73__length1 = self->returns_annotations_length1;
		_tmp71_ = _tmp73__length1 > 0;
	}
	if (_tmp71_) {
		GString* _tmp74_;
		gchar** _tmp75_;
		gint _tmp75__length1;
		GString* _tmp82_;
		const gchar* _tmp83_;
		_tmp74_ = builder;
		g_string_append (_tmp74_, "\n * \n * Returns:");
		_tmp75_ = self->returns_annotations;
		_tmp75__length1 = self->returns_annotations_length1;
		if (_tmp75_ != NULL) {
			gchar** _tmp76_;
			gint _tmp76__length1;
			gchar** _tmp80_;
			gint _tmp80__length1;
			_tmp76_ = self->returns_annotations;
			_tmp76__length1 = self->returns_annotations_length1;
			{
				gchar** annotation_collection = NULL;
				gint annotation_collection_length1 = 0;
				gint _annotation_collection_size_ = 0;
				gint annotation_it = 0;
				annotation_collection = _tmp76_;
				annotation_collection_length1 = _tmp76__length1;
				for (annotation_it = 0; annotation_it < annotation_collection_length1; annotation_it = annotation_it + 1) {
					gchar* _tmp77_;
					gchar* annotation = NULL;
					_tmp77_ = g_strdup (annotation_collection[annotation_it]);
					annotation = _tmp77_;
					{
						GString* _tmp78_;
						const gchar* _tmp79_;
						_tmp78_ = builder;
						_tmp79_ = annotation;
						g_string_append_printf (_tmp78_, " (%s)", _tmp79_);
						_g_free0 (annotation);
					}
				}
			}
			_tmp80_ = self->returns_annotations;
			_tmp80__length1 = self->returns_annotations_length1;
			if (_tmp80__length1 > 0) {
				GString* _tmp81_;
				_tmp81_ = builder;
				g_string_append_c (_tmp81_, ':');
			}
		}
		_tmp82_ = builder;
		g_string_append_c (_tmp82_, ' ');
		_tmp83_ = self->returns;
		if (_tmp83_ != NULL) {
			GString* _tmp84_;
			const gchar* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			_tmp84_ = builder;
			_tmp85_ = self->returns;
			_tmp86_ = gtkdoc_commentize (_tmp85_);
			_tmp87_ = _tmp86_;
			g_string_append (_tmp84_, _tmp87_);
			_g_free0 (_tmp87_);
		}
	}
	_tmp88_ = self->versioning;
	_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
	_tmp90_ = _tmp89_;
	if (_tmp90_ > 0) {
		GString* _tmp91_;
		_tmp91_ = builder;
		g_string_append (_tmp91_, "\n *");
		{
			ValaList* _version_list = NULL;
			ValaList* _tmp92_;
			ValaList* _tmp93_;
			gint _version_size = 0;
			ValaList* _tmp94_;
			gint _tmp95_;
			gint _tmp96_;
			gint _version_index = 0;
			_tmp92_ = self->versioning;
			_tmp93_ = _vala_iterable_ref0 (_tmp92_);
			_version_list = _tmp93_;
			_tmp94_ = _version_list;
			_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
			_tmp96_ = _tmp95_;
			_version_size = _tmp96_;
			_version_index = -1;
			while (TRUE) {
				gint _tmp97_;
				gint _tmp98_;
				GtkdocHeader* version = NULL;
				ValaList* _tmp99_;
				gint _tmp100_;
				gpointer _tmp101_;
				GString* _tmp102_;
				GtkdocHeader* _tmp103_;
				const gchar* _tmp104_;
				GtkdocHeader* _tmp105_;
				const gchar* _tmp106_;
				_version_index = _version_index + 1;
				_tmp97_ = _version_index;
				_tmp98_ = _version_size;
				if (!(_tmp97_ < _tmp98_)) {
					break;
				}
				_tmp99_ = _version_list;
				_tmp100_ = _version_index;
				_tmp101_ = vala_list_get (_tmp99_, _tmp100_);
				version = (GtkdocHeader*) _tmp101_;
				_tmp102_ = builder;
				_tmp103_ = version;
				_tmp104_ = _tmp103_->name;
				g_string_append_printf (_tmp102_, "\n * %s:", _tmp104_);
				_tmp105_ = version;
				_tmp106_ = _tmp105_->value;
				if (_tmp106_ != NULL) {
					GString* _tmp107_;
					GtkdocHeader* _tmp108_;
					const gchar* _tmp109_;
					gchar* _tmp110_;
					gchar* _tmp111_;
					_tmp107_ = builder;
					_tmp108_ = version;
					_tmp109_ = _tmp108_->value;
					_tmp110_ = gtkdoc_commentize (_tmp109_);
					_tmp111_ = _tmp110_;
					g_string_append_printf (_tmp107_, " %s", _tmp111_);
					_g_free0 (_tmp111_);
				}
				_gtkdoc_header_unref0 (version);
			}
			_vala_iterable_unref0 (_version_list);
		}
	}
	_tmp112_ = builder;
	g_string_append (_tmp112_, "\n */");
	_tmp113_ = builder;
	_tmp114_ = _tmp113_->str;
	_tmp115_ = g_strdup (_tmp114_);
	result = _tmp115_;
	_g_string_free0 (builder);
	return result;
}


gchar*
gtkdoc_gcomment_to_docbook (GtkdocGComment* self,
                            ValadocErrorReporter* reporter)
{
	gchar* result = NULL;
	gchar* deprecated = NULL;
	gchar* since = NULL;
	GString* builder = NULL;
	GString* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp27_;
	const gchar* _tmp30_;
	ValaList* _tmp33_;
	gboolean _tmp34_ = FALSE;
	ValaList* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	const gchar* _tmp59_;
	GString* _tmp62_;
	const gchar* _tmp63_;
	gchar* _tmp64_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	deprecated = NULL;
	since = NULL;
	{
		ValaList* _header_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _header_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _header_index = 0;
		_tmp0_ = self->versioning;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_header_list = _tmp1_;
		_tmp2_ = _header_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_header_size = _tmp4_;
		_header_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			GtkdocHeader* header = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			GtkdocHeader* _tmp10_;
			const gchar* _tmp11_;
			_header_index = _header_index + 1;
			_tmp5_ = _header_index;
			_tmp6_ = _header_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _header_list;
			_tmp8_ = _header_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			header = (GtkdocHeader*) _tmp9_;
			_tmp10_ = header;
			_tmp11_ = _tmp10_->name;
			if (g_strcmp0 (_tmp11_, "Deprecated") == 0) {
				GtkdocHeader* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp12_ = header;
				_tmp13_ = _tmp12_->value;
				_tmp14_ = g_strdup (_tmp13_);
				_g_free0 (deprecated);
				deprecated = _tmp14_;
			} else {
				GtkdocHeader* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = header;
				_tmp16_ = _tmp15_->name;
				if (g_strcmp0 (_tmp16_, "Since") == 0) {
					GtkdocHeader* _tmp17_;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp17_ = header;
					_tmp18_ = _tmp17_->value;
					_tmp19_ = g_strdup (_tmp18_);
					_g_free0 (since);
					since = _tmp19_;
				} else {
					GtkdocHeader* _tmp20_;
					const gchar* _tmp21_;
					_tmp20_ = header;
					_tmp21_ = _tmp20_->name;
					valadoc_error_reporter_simple_warning (reporter, "GtkDoc", "Unknown versioning tag '%s'", _tmp21_);
				}
			}
			_gtkdoc_header_unref0 (header);
		}
		_vala_iterable_unref0 (_header_list);
	}
	_tmp22_ = g_string_new ("");
	builder = _tmp22_;
	_tmp23_ = deprecated;
	if (_tmp23_ != NULL) {
		GString* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		_tmp24_ = builder;
		_tmp25_ = self->symbol;
		_tmp26_ = deprecated;
		g_string_append_printf (_tmp24_, "<warning><para><literal>%s</literal> is deprecated and should not be u" \
"sed in newly-written code. %s</para></warning>", _tmp25_, _tmp26_);
	}
	_tmp27_ = self->brief_comment;
	if (_tmp27_ != NULL) {
		GString* _tmp28_;
		const gchar* _tmp29_;
		_tmp28_ = builder;
		_tmp29_ = self->brief_comment;
		g_string_append_printf (_tmp28_, "<para>%s</para>", _tmp29_);
	}
	_tmp30_ = self->long_comment;
	if (_tmp30_ != NULL) {
		GString* _tmp31_;
		const gchar* _tmp32_;
		_tmp31_ = builder;
		_tmp32_ = self->long_comment;
		g_string_append (_tmp31_, _tmp32_);
	}
	_tmp33_ = self->headers;
	vala_list_sort (_tmp33_, (GCompareDataFunc) gtkdoc_header_cmp, NULL, NULL);
	_tmp35_ = self->headers;
	_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_ > 0) {
		_tmp34_ = TRUE;
	} else {
		const gchar* _tmp38_;
		_tmp38_ = self->returns;
		_tmp34_ = _tmp38_ != NULL;
	}
	if (_tmp34_) {
		GString* _tmp39_;
		const gchar* _tmp55_;
		GString* _tmp58_;
		_tmp39_ = builder;
		g_string_append (_tmp39_, "<variablelist role=\"params\">");
		{
			ValaList* _header_list = NULL;
			ValaList* _tmp40_;
			ValaList* _tmp41_;
			gint _header_size = 0;
			ValaList* _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			gint _header_index = 0;
			_tmp40_ = self->headers;
			_tmp41_ = _vala_iterable_ref0 (_tmp40_);
			_header_list = _tmp41_;
			_tmp42_ = _header_list;
			_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
			_tmp44_ = _tmp43_;
			_header_size = _tmp44_;
			_header_index = -1;
			while (TRUE) {
				gint _tmp45_;
				gint _tmp46_;
				GtkdocHeader* header = NULL;
				ValaList* _tmp47_;
				gint _tmp48_;
				gpointer _tmp49_;
				GString* _tmp50_;
				GtkdocHeader* _tmp51_;
				const gchar* _tmp52_;
				GtkdocHeader* _tmp53_;
				const gchar* _tmp54_;
				_header_index = _header_index + 1;
				_tmp45_ = _header_index;
				_tmp46_ = _header_size;
				if (!(_tmp45_ < _tmp46_)) {
					break;
				}
				_tmp47_ = _header_list;
				_tmp48_ = _header_index;
				_tmp49_ = vala_list_get (_tmp47_, _tmp48_);
				header = (GtkdocHeader*) _tmp49_;
				_tmp50_ = builder;
				_tmp51_ = header;
				_tmp52_ = _tmp51_->name;
				_tmp53_ = header;
				_tmp54_ = _tmp53_->value;
				g_string_append_printf (_tmp50_, "<varlistentry><term><parameter>%s</parameter>&#160;:</term>\n" \
"<listitem><simpara> %s </simpara></listitem></varlistentry>", _tmp52_, _tmp54_);
				_gtkdoc_header_unref0 (header);
			}
			_vala_iterable_unref0 (_header_list);
		}
		_tmp55_ = self->returns;
		if (_tmp55_ != NULL) {
			GString* _tmp56_;
			const gchar* _tmp57_;
			_tmp56_ = builder;
			_tmp57_ = self->returns;
			g_string_append_printf (_tmp56_, "<varlistentry><term><emphasis>Returns</emphasis>&#160;:</term>\n" \
"<listitem><simpara> %s </simpara></listitem></varlistentry>", _tmp57_);
		}
		_tmp58_ = builder;
		g_string_append (_tmp58_, "</variablelist>");
	}
	_tmp59_ = since;
	if (_tmp59_ != NULL) {
		GString* _tmp60_;
		const gchar* _tmp61_;
		_tmp60_ = builder;
		_tmp61_ = since;
		g_string_append_printf (_tmp60_, "<para role=\"since\">Since %s</para>", _tmp61_);
	}
	_tmp62_ = builder;
	_tmp63_ = _tmp62_->str;
	_tmp64_ = g_strdup (_tmp63_);
	result = _tmp64_;
	_g_string_free0 (builder);
	_g_free0 (since);
	_g_free0 (deprecated);
	return result;
}


GtkdocGComment*
gtkdoc_gcomment_construct (GType object_type)
{
	GtkdocGComment* self = NULL;
	self = (GtkdocGComment*) g_type_create_instance (object_type);
	return self;
}


GtkdocGComment*
gtkdoc_gcomment_new (void)
{
	return gtkdoc_gcomment_construct (GTKDOC_TYPE_GCOMMENT);
}


static void
gtkdoc_value_gcomment_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
gtkdoc_value_gcomment_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_gcomment_unref (value->data[0].v_pointer);
	}
}


static void
gtkdoc_value_gcomment_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_gcomment_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
gtkdoc_value_gcomment_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
gtkdoc_value_gcomment_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocGComment * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_gcomment_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
gtkdoc_value_gcomment_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	GtkdocGComment ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_gcomment_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
gtkdoc_param_spec_gcomment (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	GtkdocParamSpecGComment* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_TYPE_GCOMMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
gtkdoc_value_get_gcomment (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_GCOMMENT), NULL);
	return value->data[0].v_pointer;
}


void
gtkdoc_value_set_gcomment (GValue* value,
                           gpointer v_object)
{
	GtkdocGComment * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_GCOMMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_GCOMMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_gcomment_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_gcomment_unref (old);
	}
}


void
gtkdoc_value_take_gcomment (GValue* value,
                            gpointer v_object)
{
	GtkdocGComment * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_GCOMMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_GCOMMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_gcomment_unref (old);
	}
}


static void
gtkdoc_gcomment_class_init (GtkdocGCommentClass * klass)
{
	gtkdoc_gcomment_parent_class = g_type_class_peek_parent (klass);
	((GtkdocGCommentClass *) klass)->finalize = gtkdoc_gcomment_finalize;
}


static void
gtkdoc_gcomment_instance_init (GtkdocGComment * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp0_);
	self->headers = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp2_);
	self->versioning = (ValaList*) _tmp3_;
	self->ref_count = 1;
}


static void
gtkdoc_gcomment_finalize (GtkdocGComment * obj)
{
	GtkdocGComment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_TYPE_GCOMMENT, GtkdocGComment);
	g_signal_handlers_destroy (self);
	_g_free0 (self->symbol);
	self->symbol_annotations = (_vala_array_free (self->symbol_annotations, self->symbol_annotations_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->headers);
	_g_free0 (self->brief_comment);
	_g_free0 (self->long_comment);
	_g_free0 (self->returns);
	self->returns_annotations = (_vala_array_free (self->returns_annotations, self->returns_annotations_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->versioning);
	self->see_also = (_vala_array_free (self->see_also, self->see_also_length1, (GDestroyNotify) g_free), NULL);
}


GType
gtkdoc_gcomment_get_type (void)
{
	static volatile gsize gtkdoc_gcomment_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_gcomment_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gtkdoc_value_gcomment_init, gtkdoc_value_gcomment_free_value, gtkdoc_value_gcomment_copy_value, gtkdoc_value_gcomment_peek_pointer, "p", gtkdoc_value_gcomment_collect_value, "p", gtkdoc_value_gcomment_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GtkdocGCommentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_gcomment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocGComment), 0, (GInstanceInitFunc) gtkdoc_gcomment_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gtkdoc_gcomment_type_id;
		gtkdoc_gcomment_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocGComment", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gtkdoc_gcomment_type_id__volatile, gtkdoc_gcomment_type_id);
	}
	return gtkdoc_gcomment_type_id__volatile;
}


gpointer
gtkdoc_gcomment_ref (gpointer instance)
{
	GtkdocGComment * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
gtkdoc_gcomment_unref (gpointer instance)
{
	GtkdocGComment * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_GCOMMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



