/* valalocalvariable.c generated by valac, the Vala compiler
 * generated from valalocalvariable.vala, do not modify */

/* valalocalvariable.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaLocalVariablePrivate {
	gboolean _is_result;
	gboolean _captured;
	gboolean _init;
};


static gpointer vala_local_variable_parent_class = NULL;

#define VALA_LOCAL_VARIABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariablePrivate))
static void vala_local_variable_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_local_variable_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static void vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static void vala_local_variable_real_replace_type (ValaCodeNode* base,
                                            ValaDataType* old_type,
                                            ValaDataType* new_type);
static gboolean vala_local_variable_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_local_variable_finalize (ValaCodeNode * obj);


/**
 * Creates a new local variable.
 *
 * @param name              name of the variable
 * @param initializer       optional initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created variable declarator
 */
ValaLocalVariable*
vala_local_variable_construct (GType object_type,
                               ValaDataType* variable_type,
                               const gchar* name,
                               ValaExpression* initializer,
                               ValaSourceReference* source_reference)
{
	ValaLocalVariable* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaLocalVariable*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, NULL);
	return self;
}


ValaLocalVariable*
vala_local_variable_new (ValaDataType* variable_type,
                         const gchar* name,
                         ValaExpression* initializer,
                         ValaSourceReference* source_reference)
{
	return vala_local_variable_construct (VALA_TYPE_LOCAL_VARIABLE, variable_type, name, initializer, source_reference);
}


static void
vala_local_variable_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_local_variable (visitor, self);
}


static void
vala_local_variable_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
	}
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}


static void
vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}


static void
vala_local_variable_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type)
{
	ValaLocalVariable * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_local_variable_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaLocalVariable * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean is_initializer_list = FALSE;
	gint initializer_size = 0;
	gboolean _tmp12_ = FALSE;
	ValaExpression* _tmp13_;
	ValaExpression* _tmp14_;
	ValaSemanticAnalyzer* _tmp37_;
	ValaSemanticAnalyzer* _tmp38_;
	ValaSymbol* _tmp39_;
	ValaSymbol* _tmp40_;
	ValaScope* _tmp41_;
	ValaScope* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	ValaDataType* _tmp47_;
	ValaDataType* _tmp48_;
	gboolean _tmp96_;
	gboolean _tmp97_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp110_;
	ValaDataType* _tmp111_;
	gboolean _tmp112_ = FALSE;
	gboolean _tmp113_ = FALSE;
	gboolean _tmp114_ = FALSE;
	ValaArrayType* _tmp115_;
	gboolean _tmp127_ = FALSE;
	gboolean _tmp128_ = FALSE;
	gboolean _tmp129_ = FALSE;
	ValaArrayType* _tmp130_;
	gboolean _tmp141_ = FALSE;
	ValaExpression* _tmp142_;
	ValaExpression* _tmp143_;
	ValaBlock* block = NULL;
	ValaSemanticAnalyzer* _tmp261_;
	ValaSemanticAnalyzer* _tmp262_;
	ValaSymbol* _tmp263_;
	ValaSymbol* _tmp264_;
	ValaBlock* _tmp265_;
	ValaBlock* _tmp266_;
	gboolean _tmp268_;
	gboolean _tmp269_;
	self = (ValaLocalVariable*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_VOID_TYPE (_tmp7_)) {
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp9_ = _tmp8_;
			vala_report_error (_tmp9_, "'void' not supported as variable type");
		} else {
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			_tmp10_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp11_ = _tmp10_;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp11_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
		}
	}
	is_initializer_list = FALSE;
	initializer_size = -1;
	_tmp13_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		gboolean _tmp15_;
		gboolean _tmp16_;
		_tmp15_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp16_ = _tmp15_;
		_tmp12_ = !_tmp16_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaDataType* _tmp19_;
		ValaDataType* _tmp20_;
		ValaExpression* _tmp21_;
		ValaExpression* _tmp22_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp20_ = _tmp19_;
		vala_expression_set_target_type (_tmp18_, _tmp20_);
		_tmp21_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp22_ = _tmp21_;
		if (VALA_IS_INITIALIZER_LIST (_tmp22_)) {
			ValaExpression* _tmp23_;
			ValaExpression* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			_tmp23_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp26_ = _tmp25_;
			initializer_size = _tmp26_;
			is_initializer_list = TRUE;
		}
		_tmp27_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp28_ = _tmp27_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp28_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		} else {
			ValaExpression* _tmp29_;
			ValaExpression* _tmp30_;
			ValaDataType* _tmp31_;
			ValaDataType* _tmp32_;
			_tmp29_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_expression_get_value_type (_tmp30_);
			_tmp32_ = _tmp31_;
			if (VALA_IS_VOID_TYPE (_tmp32_)) {
				ValaExpression* _tmp33_;
				ValaExpression* _tmp34_;
				ValaSourceReference* _tmp35_;
				ValaSourceReference* _tmp36_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp33_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp34_);
				_tmp36_ = _tmp35_;
				vala_report_error (_tmp36_, "'void' not supported as initializer type");
			}
		}
	}
	_tmp37_ = vala_code_context_get_analyzer (context);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_semantic_analyzer_get_current_symbol (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = vala_symbol_get_scope (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp44_ = _tmp43_;
	vala_scope_add (_tmp42_, _tmp44_, (ValaSymbol*) self);
	_tmp45_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp46_ = _tmp45_;
	if (_tmp46_) {
		result = FALSE;
		return result;
	}
	_tmp47_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp48_ = _tmp47_;
	if (_tmp48_ == NULL) {
		ValaExpression* _tmp49_;
		ValaExpression* _tmp50_;
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		ValaDataType* _tmp55_;
		ValaDataType* _tmp56_;
		gboolean _tmp59_ = FALSE;
		ValaExpression* _tmp60_;
		ValaExpression* _tmp61_;
		ValaDataType* _tmp62_;
		ValaDataType* _tmp63_;
		ValaExpression* _tmp80_;
		ValaExpression* _tmp81_;
		ValaDataType* _tmp82_;
		ValaDataType* _tmp83_;
		ValaDataType* _tmp84_;
		ValaDataType* _tmp85_;
		ValaDataType* _tmp86_;
		ValaDataType* _tmp87_;
		ValaDataType* _tmp88_;
		ValaDataType* _tmp89_;
		ValaExpression* _tmp90_;
		ValaExpression* _tmp91_;
		ValaDataType* _tmp92_;
		ValaDataType* _tmp93_;
		ValaDataType* _tmp94_;
		ValaDataType* _tmp95_;
		_tmp49_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp50_ = _tmp49_;
		if (_tmp50_ == NULL) {
			ValaSourceReference* _tmp51_;
			ValaSourceReference* _tmp52_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp52_ = _tmp51_;
			vala_report_error (_tmp52_, "var declaration not allowed without initializer");
			result = FALSE;
			return result;
		}
		_tmp53_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_expression_get_value_type (_tmp54_);
		_tmp56_ = _tmp55_;
		if (_tmp56_ == NULL) {
			ValaSourceReference* _tmp57_;
			ValaSourceReference* _tmp58_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp58_ = _tmp57_;
			vala_report_error (_tmp58_, "var declaration not allowed with non-typed initializer");
			result = FALSE;
			return result;
		}
		_tmp60_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_expression_get_value_type (_tmp61_);
		_tmp63_ = _tmp62_;
		if (VALA_IS_FIELD_PROTOTYPE (_tmp63_)) {
			_tmp59_ = TRUE;
		} else {
			ValaExpression* _tmp64_;
			ValaExpression* _tmp65_;
			ValaDataType* _tmp66_;
			ValaDataType* _tmp67_;
			_tmp64_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp65_ = _tmp64_;
			_tmp66_ = vala_expression_get_value_type (_tmp65_);
			_tmp67_ = _tmp66_;
			_tmp59_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp67_);
		}
		if (_tmp59_) {
			ValaExpression* _tmp68_;
			ValaExpression* _tmp69_;
			ValaSourceReference* _tmp70_;
			ValaSourceReference* _tmp71_;
			ValaExpression* _tmp72_;
			ValaExpression* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp68_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp69_ = _tmp68_;
			_tmp70_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp73_ = _tmp72_;
			_tmp74_ = vala_expression_get_symbol_reference (_tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = vala_symbol_get_full_name (_tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp77_);
			_tmp79_ = _tmp78_;
			vala_report_error (_tmp71_, _tmp79_);
			_g_free0 (_tmp79_);
			_g_free0 (_tmp77_);
			result = FALSE;
			return result;
		}
		_tmp80_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp81_ = _tmp80_;
		_tmp82_ = vala_expression_get_value_type (_tmp81_);
		_tmp83_ = _tmp82_;
		_tmp84_ = vala_data_type_copy (_tmp83_);
		_tmp85_ = _tmp84_;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp85_);
		_vala_code_node_unref0 (_tmp85_);
		_tmp86_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp87_ = _tmp86_;
		vala_data_type_set_value_owned (_tmp87_, TRUE);
		_tmp88_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp89_ = _tmp88_;
		vala_data_type_set_floating_reference (_tmp89_, FALSE);
		_tmp90_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp91_ = _tmp90_;
		_tmp92_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp93_ = _tmp92_;
		vala_expression_set_target_type (_tmp91_, _tmp93_);
		_tmp94_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp95_ = _tmp94_;
		vala_code_node_check ((ValaCodeNode*) _tmp95_, context);
	}
	_tmp96_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp97_ = _tmp96_;
	if (!_tmp97_) {
		ValaDataType* _tmp98_;
		ValaDataType* _tmp99_;
		ValaTypeSymbol* _tmp100_;
		ValaTypeSymbol* _tmp101_;
		_tmp98_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp99_ = _tmp98_;
		_tmp100_ = vala_data_type_get_data_type (_tmp99_);
		_tmp101_ = _tmp100_;
		if (_tmp101_ != NULL) {
			ValaDataType* _tmp102_;
			ValaDataType* _tmp103_;
			ValaTypeSymbol* _tmp104_;
			ValaTypeSymbol* _tmp105_;
			ValaVersionAttribute* _tmp106_;
			ValaVersionAttribute* _tmp107_;
			ValaSourceReference* _tmp108_;
			ValaSourceReference* _tmp109_;
			_tmp102_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp103_ = _tmp102_;
			_tmp104_ = vala_data_type_get_data_type (_tmp103_);
			_tmp105_ = _tmp104_;
			_tmp106_ = vala_symbol_get_version ((ValaSymbol*) _tmp105_);
			_tmp107_ = _tmp106_;
			_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp109_ = _tmp108_;
			vala_version_attribute_check (_tmp107_, _tmp109_);
		}
	}
	_tmp110_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp111_ = _tmp110_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp111_) ? ((ValaArrayType*) _tmp111_) : NULL;
	_tmp115_ = variable_array_type;
	if (_tmp115_ != NULL) {
		ValaArrayType* _tmp116_;
		gboolean _tmp117_;
		gboolean _tmp118_;
		_tmp116_ = variable_array_type;
		_tmp117_ = vala_array_type_get_inline_allocated (_tmp116_);
		_tmp118_ = _tmp117_;
		_tmp114_ = _tmp118_;
	} else {
		_tmp114_ = FALSE;
	}
	if (_tmp114_) {
		ValaExpression* _tmp119_;
		ValaExpression* _tmp120_;
		_tmp119_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp120_ = _tmp119_;
		_tmp113_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp120_);
	} else {
		_tmp113_ = FALSE;
	}
	if (_tmp113_) {
		ValaExpression* _tmp121_;
		ValaExpression* _tmp122_;
		ValaInitializerList* _tmp123_;
		ValaInitializerList* _tmp124_;
		_tmp121_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp124_ = _tmp123_;
		_tmp112_ = _tmp124_ == NULL;
	} else {
		_tmp112_ = FALSE;
	}
	if (_tmp112_) {
		ValaSourceReference* _tmp125_;
		ValaSourceReference* _tmp126_;
		_tmp125_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp126_ = _tmp125_;
		vala_report_warning (_tmp126_, "Inline allocated arrays don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp130_ = variable_array_type;
	if (_tmp130_ != NULL) {
		ValaArrayType* _tmp131_;
		gboolean _tmp132_;
		gboolean _tmp133_;
		_tmp131_ = variable_array_type;
		_tmp132_ = vala_array_type_get_inline_allocated (_tmp131_);
		_tmp133_ = _tmp132_;
		_tmp129_ = _tmp133_;
	} else {
		_tmp129_ = FALSE;
	}
	if (_tmp129_) {
		ValaArrayType* _tmp134_;
		ValaExpression* _tmp135_;
		ValaExpression* _tmp136_;
		_tmp134_ = variable_array_type;
		_tmp135_ = vala_array_type_get_length (_tmp134_);
		_tmp136_ = _tmp135_;
		_tmp128_ = _tmp136_ == NULL;
	} else {
		_tmp128_ = FALSE;
	}
	if (_tmp128_) {
		ValaExpression* _tmp137_;
		ValaExpression* _tmp138_;
		_tmp137_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp138_ = _tmp137_;
		_tmp127_ = !VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp138_);
	} else {
		_tmp127_ = FALSE;
	}
	if (_tmp127_) {
		ValaSourceReference* _tmp139_;
		ValaSourceReference* _tmp140_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp140_ = _tmp139_;
		vala_report_error (_tmp140_, "Inline allocated array requires either a given length or an initialize" \
"r");
	}
	_tmp142_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp143_ = _tmp142_;
	if (_tmp143_ != NULL) {
		ValaExpression* _tmp144_;
		ValaExpression* _tmp145_;
		gboolean _tmp146_;
		gboolean _tmp147_;
		_tmp144_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_code_node_get_error ((ValaCodeNode*) _tmp145_);
		_tmp147_ = _tmp146_;
		_tmp141_ = !_tmp147_;
	} else {
		_tmp141_ = FALSE;
	}
	if (_tmp141_) {
		ValaExpression* _tmp148_;
		ValaExpression* _tmp149_;
		ValaDataType* _tmp150_;
		ValaDataType* _tmp151_;
		ValaExpression* _tmp197_;
		ValaExpression* _tmp198_;
		ValaDataType* _tmp199_;
		ValaDataType* _tmp200_;
		ValaDataType* _tmp201_;
		ValaDataType* _tmp202_;
		gboolean _tmp217_ = FALSE;
		gboolean _tmp218_ = FALSE;
		gboolean _tmp219_ = FALSE;
		ValaArrayType* _tmp220_;
		gboolean _tmp236_ = FALSE;
		gboolean _tmp237_ = FALSE;
		ValaArrayType* _tmp238_;
		ValaExpression* _tmp248_;
		ValaExpression* _tmp249_;
		ValaDataType* _tmp250_;
		ValaDataType* _tmp251_;
		_tmp148_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_expression_get_value_type (_tmp149_);
		_tmp151_ = _tmp150_;
		if (_tmp151_ == NULL) {
			gboolean _tmp152_ = FALSE;
			ValaExpression* _tmp153_;
			ValaExpression* _tmp154_;
			gboolean _tmp159_ = FALSE;
			ValaExpression* _tmp160_;
			ValaExpression* _tmp161_;
			ValaSymbol* _tmp162_;
			ValaSymbol* _tmp163_;
			_tmp153_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp154_ = _tmp153_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp154_)) {
				ValaExpression* _tmp155_;
				ValaExpression* _tmp156_;
				_tmp155_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp156_ = _tmp155_;
				_tmp152_ = !VALA_IS_LAMBDA_EXPRESSION (_tmp156_);
			} else {
				_tmp152_ = FALSE;
			}
			if (_tmp152_) {
				ValaSourceReference* _tmp157_;
				ValaSourceReference* _tmp158_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp158_ = _tmp157_;
				vala_report_error (_tmp158_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
			_tmp160_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp161_ = _tmp160_;
			_tmp162_ = vala_expression_get_symbol_reference (_tmp161_);
			_tmp163_ = _tmp162_;
			if (VALA_IS_METHOD (_tmp163_)) {
				ValaDataType* _tmp164_;
				ValaDataType* _tmp165_;
				_tmp164_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp165_ = _tmp164_;
				_tmp159_ = VALA_IS_DELEGATE_TYPE (_tmp165_);
			} else {
				_tmp159_ = FALSE;
			}
			if (_tmp159_) {
				ValaMethod* m = NULL;
				ValaExpression* _tmp166_;
				ValaExpression* _tmp167_;
				ValaSymbol* _tmp168_;
				ValaSymbol* _tmp169_;
				ValaMethod* _tmp170_;
				ValaDelegateType* dt = NULL;
				ValaDataType* _tmp171_;
				ValaDataType* _tmp172_;
				ValaDelegateType* _tmp173_;
				ValaDelegate* cb = NULL;
				ValaDelegateType* _tmp174_;
				ValaDelegate* _tmp175_;
				ValaDelegate* _tmp176_;
				ValaDelegate* _tmp177_;
				ValaDelegate* _tmp178_;
				ValaMethod* _tmp179_;
				ValaDelegateType* _tmp180_;
				ValaExpression* _tmp191_;
				ValaExpression* _tmp192_;
				ValaDataType* _tmp193_;
				ValaDataType* _tmp194_;
				_tmp166_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp167_ = _tmp166_;
				_tmp168_ = vala_expression_get_symbol_reference (_tmp167_);
				_tmp169_ = _tmp168_;
				_tmp170_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp169_, VALA_TYPE_METHOD, ValaMethod));
				m = _tmp170_;
				_tmp171_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp172_ = _tmp171_;
				_tmp173_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp172_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				dt = _tmp173_;
				_tmp174_ = dt;
				_tmp175_ = vala_delegate_type_get_delegate_symbol (_tmp174_);
				_tmp176_ = _tmp175_;
				_tmp177_ = _vala_code_node_ref0 (_tmp176_);
				cb = _tmp177_;
				_tmp178_ = cb;
				_tmp179_ = m;
				_tmp180_ = dt;
				if (!vala_delegate_matches_method (_tmp178_, _tmp179_, (ValaDataType*) _tmp180_)) {
					ValaSourceReference* _tmp181_;
					ValaSourceReference* _tmp182_;
					ValaMethod* _tmp183_;
					gchar* _tmp184_;
					gchar* _tmp185_;
					ValaDelegate* _tmp186_;
					gchar* _tmp187_;
					gchar* _tmp188_;
					gchar* _tmp189_;
					gchar* _tmp190_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp182_ = _tmp181_;
					_tmp183_ = m;
					_tmp184_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp183_);
					_tmp185_ = _tmp184_;
					_tmp186_ = cb;
					_tmp187_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp186_);
					_tmp188_ = _tmp187_;
					_tmp189_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp185_, _tmp188_);
					_tmp190_ = _tmp189_;
					vala_report_error (_tmp182_, _tmp190_);
					_g_free0 (_tmp190_);
					_g_free0 (_tmp188_);
					_g_free0 (_tmp185_);
					result = FALSE;
					_vala_code_node_unref0 (cb);
					_vala_code_node_unref0 (dt);
					_vala_code_node_unref0 (m);
					return result;
				}
				_tmp191_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp192_ = _tmp191_;
				_tmp193_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp194_ = _tmp193_;
				vala_expression_set_value_type (_tmp192_, _tmp194_);
				_vala_code_node_unref0 (cb);
				_vala_code_node_unref0 (dt);
				_vala_code_node_unref0 (m);
			} else {
				ValaSourceReference* _tmp195_;
				ValaSourceReference* _tmp196_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp195_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp196_ = _tmp195_;
				vala_report_error (_tmp196_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		}
		_tmp197_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp198_ = _tmp197_;
		_tmp199_ = vala_expression_get_value_type (_tmp198_);
		_tmp200_ = _tmp199_;
		_tmp201_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp202_ = _tmp201_;
		if (!vala_data_type_compatible (_tmp200_, _tmp202_)) {
			ValaSourceReference* _tmp203_;
			ValaSourceReference* _tmp204_;
			ValaExpression* _tmp205_;
			ValaExpression* _tmp206_;
			ValaDataType* _tmp207_;
			ValaDataType* _tmp208_;
			gchar* _tmp209_;
			gchar* _tmp210_;
			ValaDataType* _tmp211_;
			ValaDataType* _tmp212_;
			gchar* _tmp213_;
			gchar* _tmp214_;
			gchar* _tmp215_;
			gchar* _tmp216_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp203_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp204_ = _tmp203_;
			_tmp205_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp206_ = _tmp205_;
			_tmp207_ = vala_expression_get_value_type (_tmp206_);
			_tmp208_ = _tmp207_;
			_tmp209_ = vala_code_node_to_string ((ValaCodeNode*) _tmp208_);
			_tmp210_ = _tmp209_;
			_tmp211_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp212_ = _tmp211_;
			_tmp213_ = vala_code_node_to_string ((ValaCodeNode*) _tmp212_);
			_tmp214_ = _tmp213_;
			_tmp215_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp210_, _tmp214_);
			_tmp216_ = _tmp215_;
			vala_report_error (_tmp204_, _tmp216_);
			_g_free0 (_tmp216_);
			_g_free0 (_tmp214_);
			_g_free0 (_tmp210_);
			result = FALSE;
			return result;
		}
		_tmp220_ = variable_array_type;
		if (_tmp220_ != NULL) {
			ValaArrayType* _tmp221_;
			gboolean _tmp222_;
			gboolean _tmp223_;
			_tmp221_ = variable_array_type;
			_tmp222_ = vala_array_type_get_inline_allocated (_tmp221_);
			_tmp223_ = _tmp222_;
			_tmp219_ = _tmp223_;
		} else {
			_tmp219_ = FALSE;
		}
		if (_tmp219_) {
			ValaArrayType* _tmp224_;
			gboolean _tmp225_;
			gboolean _tmp226_;
			_tmp224_ = variable_array_type;
			_tmp225_ = vala_array_type_get_fixed_length (_tmp224_);
			_tmp226_ = _tmp225_;
			_tmp218_ = !_tmp226_;
		} else {
			_tmp218_ = FALSE;
		}
		if (_tmp218_) {
			gboolean _tmp227_;
			_tmp227_ = is_initializer_list;
			_tmp217_ = _tmp227_;
		} else {
			_tmp217_ = FALSE;
		}
		if (_tmp217_) {
			ValaArrayType* _tmp228_;
			gint _tmp229_;
			gchar* _tmp230_;
			gchar* _tmp231_;
			ValaIntegerLiteral* _tmp232_;
			ValaIntegerLiteral* _tmp233_;
			ValaArrayType* _tmp234_;
			ValaArrayType* _tmp235_;
			_tmp228_ = variable_array_type;
			_tmp229_ = initializer_size;
			_tmp230_ = g_strdup_printf ("%i", _tmp229_);
			_tmp231_ = _tmp230_;
			_tmp232_ = vala_integer_literal_new (_tmp231_, NULL);
			_tmp233_ = _tmp232_;
			vala_array_type_set_length (_tmp228_, (ValaExpression*) _tmp233_);
			_vala_code_node_unref0 (_tmp233_);
			_g_free0 (_tmp231_);
			_tmp234_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp234_, TRUE);
			_tmp235_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp235_, FALSE);
		}
		_tmp238_ = variable_array_type;
		if (_tmp238_ != NULL) {
			ValaArrayType* _tmp239_;
			gboolean _tmp240_;
			gboolean _tmp241_;
			_tmp239_ = variable_array_type;
			_tmp240_ = vala_array_type_get_inline_allocated (_tmp239_);
			_tmp241_ = _tmp240_;
			_tmp237_ = _tmp241_;
		} else {
			_tmp237_ = FALSE;
		}
		if (_tmp237_) {
			ValaExpression* _tmp242_;
			ValaExpression* _tmp243_;
			ValaDataType* _tmp244_;
			ValaDataType* _tmp245_;
			_tmp242_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp243_ = _tmp242_;
			_tmp244_ = vala_expression_get_value_type (_tmp243_);
			_tmp245_ = _tmp244_;
			_tmp236_ = VALA_IS_ARRAY_TYPE (_tmp245_) == FALSE;
		} else {
			_tmp236_ = FALSE;
		}
		if (_tmp236_) {
			ValaSourceReference* _tmp246_;
			ValaSourceReference* _tmp247_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp246_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp247_ = _tmp246_;
			vala_report_error (_tmp247_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			return result;
		}
		_tmp248_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp249_ = _tmp248_;
		_tmp250_ = vala_expression_get_value_type (_tmp249_);
		_tmp251_ = _tmp250_;
		if (vala_data_type_is_disposable (_tmp251_)) {
			gboolean _tmp252_ = FALSE;
			ValaDataType* _tmp253_;
			ValaDataType* _tmp254_;
			_tmp253_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp254_ = _tmp253_;
			if (!VALA_IS_POINTER_TYPE (_tmp254_)) {
				ValaDataType* _tmp255_;
				ValaDataType* _tmp256_;
				gboolean _tmp257_;
				gboolean _tmp258_;
				_tmp255_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp256_ = _tmp255_;
				_tmp257_ = vala_data_type_get_value_owned (_tmp256_);
				_tmp258_ = _tmp257_;
				_tmp252_ = !_tmp258_;
			} else {
				_tmp252_ = FALSE;
			}
			if (_tmp252_) {
				ValaSourceReference* _tmp259_;
				ValaSourceReference* _tmp260_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp259_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp260_ = _tmp259_;
				vala_report_error (_tmp260_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp261_ = vala_code_context_get_analyzer (context);
	_tmp262_ = _tmp261_;
	_tmp263_ = vala_semantic_analyzer_get_current_symbol (_tmp262_);
	_tmp264_ = _tmp263_;
	_tmp265_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp264_) ? ((ValaBlock*) _tmp264_) : NULL);
	block = _tmp265_;
	_tmp266_ = block;
	if (_tmp266_ != NULL) {
		ValaBlock* _tmp267_;
		_tmp267_ = block;
		vala_block_add_local_variable (_tmp267_, self);
	}
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp268_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp269_ = _tmp268_;
	result = !_tmp269_;
	_vala_code_node_unref0 (block);
	return result;
}


gboolean
vala_local_variable_get_is_result (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_result;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_is_result (ValaLocalVariable* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_result = value;
}


gboolean
vala_local_variable_get_captured (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_captured;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_captured (ValaLocalVariable* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}


gboolean
vala_local_variable_get_init (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_init;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_init (ValaLocalVariable* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_init = value;
}


static void
vala_local_variable_class_init (ValaLocalVariableClass * klass)
{
	vala_local_variable_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_local_variable_finalize;
	g_type_class_add_private (klass, sizeof (ValaLocalVariablePrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_local_variable_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_local_variable_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_local_variable_real_check;
}


static void
vala_local_variable_instance_init (ValaLocalVariable * self)
{
	self->priv = VALA_LOCAL_VARIABLE_GET_PRIVATE (self);
}


static void
vala_local_variable_finalize (ValaCodeNode * obj)
{
	ValaLocalVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
	VALA_CODE_NODE_CLASS (vala_local_variable_parent_class)->finalize (obj);
}


/**
 * Represents a local variable declaration in the source code.
 */
GType
vala_local_variable_get_type (void)
{
	static volatile gsize vala_local_variable_type_id__volatile = 0;
	if (g_once_init_enter (&vala_local_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariable), 0, (GInstanceInitFunc) vala_local_variable_instance_init, NULL };
		GType vala_local_variable_type_id;
		vala_local_variable_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaLocalVariable", &g_define_type_info, 0);
		g_once_init_leave (&vala_local_variable_type_id__volatile, vala_local_variable_type_id);
	}
	return vala_local_variable_type_id__volatile;
}



