/* valainterface.c generated by valac, the Vala compiler
 * generated from valainterface.vala, do not modify */

/* valainterface.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaInterfacePrivate {
	ValaList* prerequisites;
	ValaList* virtuals;
};


static gpointer vala_interface_parent_class = NULL;

#define VALA_INTERFACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INTERFACE, ValaInterfacePrivate))
static void vala_interface_real_add_method (ValaSymbol* base,
                                     ValaMethod* m);
static void vala_interface_real_add_property (ValaSymbol* base,
                                       ValaProperty* prop);
static ValaList* vala_interface_real_get_virtuals (ValaInterface* self);
static void vala_interface_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_interface_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_interface_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                            ValaTypeSymbol* t);
static void vala_interface_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static gboolean vala_interface_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static void vala_interface_finalize (ValaCodeNode * obj);


/**
 * Creates a new interface.
 *
 * @param name              type name
 * @param source_reference  reference to source code
 * @return                  newly created interface
 */
ValaInterface*
vala_interface_construct (GType object_type,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	ValaInterface* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaInterface*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaInterface*
vala_interface_new (const gchar* name,
                    ValaSourceReference* source_reference,
                    ValaComment* comment)
{
	return vala_interface_construct (VALA_TYPE_INTERFACE, name, source_reference, comment);
}


/**
 * Adds the specified interface or class to the list of prerequisites of
 * this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_add_prerequisite (ValaInterface* self,
                                 ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}


/**
 * Prepends the specified interface or class to the list of
 * prerequisites of this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_prepend_prerequisite (ValaInterface* self,
                                     ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_list_insert (_tmp0_, 0, type);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_interface_get_prerequisites (ValaInterface* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prerequisites;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified method as a member to this interface.
 *
 * @param m a method
 */
static void
vala_interface_real_add_method (ValaSymbol* base,
                                ValaMethod* m)
{
	ValaInterface * self;
	ValaMemberBinding _tmp2_;
	ValaMemberBinding _tmp3_;
	gboolean _tmp16_ = FALSE;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	self = (ValaInterface*) base;
	g_return_if_fail (m != NULL);
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp2_ = vala_method_get_binding (m);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaObjectType* _tmp4_;
		ValaObjectType* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp4_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", (ValaDataType*) _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		vala_method_set_this_parameter (m, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp5_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_method_get_this_parameter (m);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_method_get_this_parameter (m);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp17_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp18_ = _tmp17_;
	if (!VALA_IS_VOID_TYPE (_tmp18_)) {
		ValaList* _tmp19_;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp19_ = vala_method_get_postconditions (m);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp16_ = _tmp22_ > 0;
		_vala_iterable_unref0 (_tmp20_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaDataType* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaSourceReference* _tmp28_;
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		_tmp23_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_data_type_copy (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_local_variable_new (_tmp26_, "result", NULL, _tmp28_);
		_tmp30_ = _tmp29_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp30_);
		_vala_code_node_unref0 (_tmp30_);
		_vala_code_node_unref0 (_tmp26_);
		_tmp31_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp32_ = _tmp31_;
		vala_local_variable_set_is_result (_tmp32_, TRUE);
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}


/**
 * Adds the specified property as a member to this interface.
 *
 * @param prop a property
 */
static void
vala_interface_real_add_property (ValaSymbol* base,
                                  ValaProperty* prop)
{
	ValaInterface * self;
	ValaField* _tmp0_;
	ValaField* _tmp1_;
	ValaObjectType* _tmp4_;
	ValaObjectType* _tmp5_;
	ValaParameter* _tmp6_;
	ValaParameter* _tmp7_;
	ValaScope* _tmp8_;
	ValaScope* _tmp9_;
	ValaParameter* _tmp10_;
	ValaParameter* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	ValaParameter* _tmp14_;
	ValaParameter* _tmp15_;
	self = (ValaInterface*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = vala_property_get_field (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "interface properties should be `abstract' or have `get' accessor and/o" \
"r `set' mutator");
		vala_code_node_set_error ((ValaCodeNode*) prop, TRUE);
		return;
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp4_ = vala_object_type_new ((ValaObjectTypeSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_parameter_new ("this", (ValaDataType*) _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	vala_property_set_this_parameter (prop, _tmp7_);
	_vala_code_node_unref0 (_tmp7_);
	_vala_code_node_unref0 (_tmp5_);
	_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_property_get_this_parameter (prop);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_property_get_this_parameter (prop);
	_tmp15_ = _tmp14_;
	vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
}


static ValaList*
vala_interface_real_get_virtuals (ValaInterface* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	_tmp0_ = self->priv->virtuals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


ValaList*
vala_interface_get_virtuals (ValaInterface* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_INTERFACE_GET_CLASS (self)->get_virtuals (self);
}


static void
vala_interface_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_interface (visitor, self);
}


static void
vala_interface_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* type = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaDataType* _tmp10_;
			_type_index = _type_index + 1;
			_tmp5_ = _type_index;
			_tmp6_ = _type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _type_list;
			_tmp8_ = _type_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			type = (ValaDataType*) _tmp9_;
			_tmp10_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp11_;
		gint _p_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _p_index = 0;
		_tmp11_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp11_;
		_tmp12_ = _p_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_p_size = _tmp14_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp17_;
			gint _tmp18_;
			gpointer _tmp19_;
			ValaTypeParameter* _tmp20_;
			_p_index = _p_index + 1;
			_tmp15_ = _p_index;
			_tmp16_ = _p_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _p_list;
			_tmp18_ = _p_index;
			_tmp19_ = vala_list_get (_tmp17_, _tmp18_);
			p = (ValaTypeParameter*) _tmp19_;
			_tmp20_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp20_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp21_;
		gint _en_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _en_index = 0;
		_tmp21_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp21_;
		_tmp22_ = _en_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_en_size = _tmp24_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			ValaEnum* en = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaEnum* _tmp30_;
			_en_index = _en_index + 1;
			_tmp25_ = _en_index;
			_tmp26_ = _en_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _en_list;
			_tmp28_ = _en_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			en = (ValaEnum*) _tmp29_;
			_tmp30_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp30_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp31_;
		gint _m_size = 0;
		ValaList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _m_index = 0;
		_tmp31_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp31_;
		_tmp32_ = _m_list;
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_m_size = _tmp34_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			ValaMethod* m = NULL;
			ValaList* _tmp37_;
			gint _tmp38_;
			gpointer _tmp39_;
			ValaMethod* _tmp40_;
			_m_index = _m_index + 1;
			_tmp35_ = _m_index;
			_tmp36_ = _m_size;
			if (!(_tmp35_ < _tmp36_)) {
				break;
			}
			_tmp37_ = _m_list;
			_tmp38_ = _m_index;
			_tmp39_ = vala_list_get (_tmp37_, _tmp38_);
			m = (ValaMethod*) _tmp39_;
			_tmp40_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp40_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp41_;
		gint _f_size = 0;
		ValaList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _f_index = 0;
		_tmp41_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp41_;
		_tmp42_ = _f_list;
		_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
		_tmp44_ = _tmp43_;
		_f_size = _tmp44_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp45_;
			gint _tmp46_;
			ValaField* f = NULL;
			ValaList* _tmp47_;
			gint _tmp48_;
			gpointer _tmp49_;
			ValaField* _tmp50_;
			_f_index = _f_index + 1;
			_tmp45_ = _f_index;
			_tmp46_ = _f_size;
			if (!(_tmp45_ < _tmp46_)) {
				break;
			}
			_tmp47_ = _f_list;
			_tmp48_ = _f_index;
			_tmp49_ = vala_list_get (_tmp47_, _tmp48_);
			f = (ValaField*) _tmp49_;
			_tmp50_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp50_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp51_;
		gint _c_size = 0;
		ValaList* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _c_index = 0;
		_tmp51_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp51_;
		_tmp52_ = _c_list;
		_tmp53_ = vala_collection_get_size ((ValaCollection*) _tmp52_);
		_tmp54_ = _tmp53_;
		_c_size = _tmp54_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp55_;
			gint _tmp56_;
			ValaConstant* c = NULL;
			ValaList* _tmp57_;
			gint _tmp58_;
			gpointer _tmp59_;
			ValaConstant* _tmp60_;
			_c_index = _c_index + 1;
			_tmp55_ = _c_index;
			_tmp56_ = _c_size;
			if (!(_tmp55_ < _tmp56_)) {
				break;
			}
			_tmp57_ = _c_list;
			_tmp58_ = _c_index;
			_tmp59_ = vala_list_get (_tmp57_, _tmp58_);
			c = (ValaConstant*) _tmp59_;
			_tmp60_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp60_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp61_;
		gint _prop_size = 0;
		ValaList* _tmp62_;
		gint _tmp63_;
		gint _tmp64_;
		gint _prop_index = 0;
		_tmp61_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp61_;
		_tmp62_ = _prop_list;
		_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
		_tmp64_ = _tmp63_;
		_prop_size = _tmp64_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp65_;
			gint _tmp66_;
			ValaProperty* prop = NULL;
			ValaList* _tmp67_;
			gint _tmp68_;
			gpointer _tmp69_;
			ValaProperty* _tmp70_;
			_prop_index = _prop_index + 1;
			_tmp65_ = _prop_index;
			_tmp66_ = _prop_size;
			if (!(_tmp65_ < _tmp66_)) {
				break;
			}
			_tmp67_ = _prop_list;
			_tmp68_ = _prop_index;
			_tmp69_ = vala_list_get (_tmp67_, _tmp68_);
			prop = (ValaProperty*) _tmp69_;
			_tmp70_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp70_, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp71_;
		gint _sig_size = 0;
		ValaList* _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		gint _sig_index = 0;
		_tmp71_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp71_;
		_tmp72_ = _sig_list;
		_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
		_tmp74_ = _tmp73_;
		_sig_size = _tmp74_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp75_;
			gint _tmp76_;
			ValaSignal* sig = NULL;
			ValaList* _tmp77_;
			gint _tmp78_;
			gpointer _tmp79_;
			ValaSignal* _tmp80_;
			_sig_index = _sig_index + 1;
			_tmp75_ = _sig_index;
			_tmp76_ = _sig_size;
			if (!(_tmp75_ < _tmp76_)) {
				break;
			}
			_tmp77_ = _sig_list;
			_tmp78_ = _sig_index;
			_tmp79_ = vala_list_get (_tmp77_, _tmp78_);
			sig = (ValaSignal*) _tmp79_;
			_tmp80_ = sig;
			vala_code_node_accept ((ValaCodeNode*) _tmp80_, visitor);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp81_;
		gint _cl_size = 0;
		ValaList* _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		gint _cl_index = 0;
		_tmp81_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp81_;
		_tmp82_ = _cl_list;
		_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
		_tmp84_ = _tmp83_;
		_cl_size = _tmp84_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp85_;
			gint _tmp86_;
			ValaClass* cl = NULL;
			ValaList* _tmp87_;
			gint _tmp88_;
			gpointer _tmp89_;
			ValaClass* _tmp90_;
			_cl_index = _cl_index + 1;
			_tmp85_ = _cl_index;
			_tmp86_ = _cl_size;
			if (!(_tmp85_ < _tmp86_)) {
				break;
			}
			_tmp87_ = _cl_list;
			_tmp88_ = _cl_index;
			_tmp89_ = vala_list_get (_tmp87_, _tmp88_);
			cl = (ValaClass*) _tmp89_;
			_tmp90_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp90_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp91_;
		gint _st_size = 0;
		ValaList* _tmp92_;
		gint _tmp93_;
		gint _tmp94_;
		gint _st_index = 0;
		_tmp91_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp91_;
		_tmp92_ = _st_list;
		_tmp93_ = vala_collection_get_size ((ValaCollection*) _tmp92_);
		_tmp94_ = _tmp93_;
		_st_size = _tmp94_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp95_;
			gint _tmp96_;
			ValaStruct* st = NULL;
			ValaList* _tmp97_;
			gint _tmp98_;
			gpointer _tmp99_;
			ValaStruct* _tmp100_;
			_st_index = _st_index + 1;
			_tmp95_ = _st_index;
			_tmp96_ = _st_size;
			if (!(_tmp95_ < _tmp96_)) {
				break;
			}
			_tmp97_ = _st_list;
			_tmp98_ = _st_index;
			_tmp99_ = vala_list_get (_tmp97_, _tmp98_);
			st = (ValaStruct*) _tmp99_;
			_tmp100_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp100_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp101_;
		gint _d_size = 0;
		ValaList* _tmp102_;
		gint _tmp103_;
		gint _tmp104_;
		gint _d_index = 0;
		_tmp101_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp101_;
		_tmp102_ = _d_list;
		_tmp103_ = vala_collection_get_size ((ValaCollection*) _tmp102_);
		_tmp104_ = _tmp103_;
		_d_size = _tmp104_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp105_;
			gint _tmp106_;
			ValaDelegate* d = NULL;
			ValaList* _tmp107_;
			gint _tmp108_;
			gpointer _tmp109_;
			ValaDelegate* _tmp110_;
			_d_index = _d_index + 1;
			_tmp105_ = _d_index;
			_tmp106_ = _d_size;
			if (!(_tmp105_ < _tmp106_)) {
				break;
			}
			_tmp107_ = _d_list;
			_tmp108_ = _d_index;
			_tmp109_ = vala_list_get (_tmp107_, _tmp108_);
			d = (ValaDelegate*) _tmp109_;
			_tmp110_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp110_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}


static gboolean
vala_interface_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	result = TRUE;
	return result;
}


static gboolean
vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                   ValaTypeSymbol* t)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _prerequisite_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prerequisite_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prerequisite_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prerequisite_list = _tmp1_;
		_tmp2_ = _prerequisite_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prerequisite_size = _tmp4_;
		_prerequisite_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* prerequisite = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			gboolean _tmp10_ = FALSE;
			ValaDataType* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			_prerequisite_index = _prerequisite_index + 1;
			_tmp5_ = _prerequisite_index;
			_tmp6_ = _prerequisite_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _prerequisite_list;
			_tmp8_ = _prerequisite_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			prerequisite = (ValaDataType*) _tmp9_;
			_tmp11_ = prerequisite;
			_tmp12_ = vala_data_type_get_data_type (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != NULL) {
				ValaDataType* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				_tmp14_ = prerequisite;
				_tmp15_ = vala_data_type_get_data_type (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp10_ = vala_typesymbol_is_subtype_of (_tmp16_, t);
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				result = TRUE;
				_vala_code_node_unref0 (prerequisite);
				_vala_iterable_unref0 (_prerequisite_list);
				return result;
			}
			_vala_code_node_unref0 (prerequisite);
		}
		_vala_iterable_unref0 (_prerequisite_list);
	}
	result = FALSE;
	return result;
}


static void
vala_interface_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->prerequisites;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->prerequisites;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = _tmp9_ == old_type;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->prerequisites;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_interface_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaInterface * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaClass* prereq_class = NULL;
	gboolean _tmp137_;
	gboolean _tmp138_;
	ValaMap* positions = NULL;
	GHashFunc _tmp266_;
	GEqualFunc _tmp267_;
	GEqualFunc _tmp268_;
	ValaHashMap* _tmp269_;
	gboolean ordered_seen = FALSE;
	gboolean unordered_seen = FALSE;
	gboolean _tmp345_;
	ValaSemanticAnalyzer* _tmp368_;
	ValaSemanticAnalyzer* _tmp369_;
	ValaSourceFile* _tmp370_;
	ValaSemanticAnalyzer* _tmp371_;
	ValaSemanticAnalyzer* _tmp372_;
	ValaSymbol* _tmp373_;
	gboolean _tmp374_;
	gboolean _tmp375_;
	self = (ValaInterface*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	if (!VALA_CODE_NODE_CLASS (vala_interface_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), context)) {
		result = FALSE;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _prerequisite_reference_list = NULL;
		ValaList* _tmp24_;
		gint _prerequisite_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _prerequisite_reference_index = 0;
		_tmp24_ = vala_interface_get_prerequisites (self);
		_prerequisite_reference_list = _tmp24_;
		_tmp25_ = _prerequisite_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_prerequisite_reference_size = _tmp27_;
		_prerequisite_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			ValaDataType* prerequisite_reference = NULL;
			ValaList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaDataType* _tmp35_;
			_prerequisite_reference_index = _prerequisite_reference_index + 1;
			_tmp28_ = _prerequisite_reference_index;
			_tmp29_ = _prerequisite_reference_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _prerequisite_reference_list;
			_tmp31_ = _prerequisite_reference_index;
			_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
			prerequisite_reference = (ValaDataType*) _tmp32_;
			_tmp33_ = vala_code_context_get_analyzer (context);
			_tmp34_ = _tmp33_;
			_tmp35_ = prerequisite_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp34_, (ValaSymbol*) self, _tmp35_)) {
				ValaSourceReference* _tmp36_;
				ValaSourceReference* _tmp37_;
				ValaDataType* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp37_ = _tmp36_;
				_tmp38_ = prerequisite_reference;
				_tmp39_ = vala_code_node_to_string ((ValaCodeNode*) _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strdup_printf ("prerequisite `%s` is less accessible than interface `%s`", _tmp40_, _tmp42_);
				_tmp44_ = _tmp43_;
				vala_report_error (_tmp37_, _tmp44_);
				_g_free0 (_tmp44_);
				_g_free0 (_tmp42_);
				_g_free0 (_tmp40_);
				result = FALSE;
				_vala_code_node_unref0 (prerequisite_reference);
				_vala_iterable_unref0 (_prerequisite_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (prerequisite_reference);
		}
		_vala_iterable_unref0 (_prerequisite_reference_list);
	}
	prereq_class = NULL;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp45_;
		gint _prereq_size = 0;
		ValaList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint _prereq_index = 0;
		_tmp45_ = vala_interface_get_prerequisites (self);
		_prereq_list = _tmp45_;
		_tmp46_ = _prereq_list;
		_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_prereq_size = _tmp48_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp49_;
			gint _tmp50_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp51_;
			gint _tmp52_;
			gpointer _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp64_;
			ValaTypeSymbol* _tmp65_;
			ValaTypeSymbol* _tmp66_;
			_prereq_index = _prereq_index + 1;
			_tmp49_ = _prereq_index;
			_tmp50_ = _prereq_size;
			if (!(_tmp49_ < _tmp50_)) {
				break;
			}
			_tmp51_ = _prereq_list;
			_tmp52_ = _prereq_index;
			_tmp53_ = vala_list_get (_tmp51_, _tmp52_);
			prereq = (ValaDataType*) _tmp53_;
			_tmp54_ = prereq;
			if (!VALA_IS_OBJECT_TYPE (_tmp54_)) {
				ValaSourceReference* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaDataType* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp56_ = _tmp55_;
				_tmp57_ = prereq;
				_tmp58_ = vala_code_node_to_string ((ValaCodeNode*) _tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp61_ = _tmp60_;
				_tmp62_ = g_strdup_printf ("Prerequisite `%s' of interface `%s' is not a class or interface", _tmp59_, _tmp61_);
				_tmp63_ = _tmp62_;
				vala_report_error (_tmp56_, _tmp63_);
				_g_free0 (_tmp63_);
				_g_free0 (_tmp61_);
				_g_free0 (_tmp59_);
				result = FALSE;
				_vala_code_node_unref0 (prereq);
				_vala_iterable_unref0 (_prereq_list);
				_vala_code_node_unref0 (prereq_class);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp64_ = prereq;
			_tmp65_ = vala_data_type_get_data_type (_tmp64_);
			_tmp66_ = _tmp65_;
			if (VALA_IS_CLASS (_tmp66_)) {
				ValaClass* _tmp67_;
				ValaDataType* _tmp82_;
				ValaTypeSymbol* _tmp83_;
				ValaTypeSymbol* _tmp84_;
				ValaClass* _tmp85_;
				_tmp67_ = prereq_class;
				if (_tmp67_ != NULL) {
					ValaSourceReference* _tmp68_;
					ValaSourceReference* _tmp69_;
					gchar* _tmp70_;
					gchar* _tmp71_;
					ValaDataType* _tmp72_;
					ValaTypeSymbol* _tmp73_;
					ValaTypeSymbol* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					ValaClass* _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					gchar* _tmp80_;
					gchar* _tmp81_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp69_ = _tmp68_;
					_tmp70_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp71_ = _tmp70_;
					_tmp72_ = prereq;
					_tmp73_ = vala_data_type_get_data_type (_tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp74_);
					_tmp76_ = _tmp75_;
					_tmp77_ = prereq_class;
					_tmp78_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp77_);
					_tmp79_ = _tmp78_;
					_tmp80_ = g_strdup_printf ("%s: Interfaces cannot have multiple instantiable prerequisites (`%s' a" \
"nd `%s')", _tmp71_, _tmp76_, _tmp79_);
					_tmp81_ = _tmp80_;
					vala_report_error (_tmp69_, _tmp81_);
					_g_free0 (_tmp81_);
					_g_free0 (_tmp79_);
					_g_free0 (_tmp76_);
					_g_free0 (_tmp71_);
					result = FALSE;
					_vala_code_node_unref0 (prereq);
					_vala_iterable_unref0 (_prereq_list);
					_vala_code_node_unref0 (prereq_class);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_tmp82_ = prereq;
				_tmp83_ = vala_data_type_get_data_type (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp85_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, VALA_TYPE_CLASS, ValaClass));
				_vala_code_node_unref0 (prereq_class);
				prereq_class = _tmp85_;
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp86_;
		ValaList* _tmp87_;
		gint _type_size = 0;
		ValaList* _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		gint _type_index = 0;
		_tmp86_ = self->priv->prerequisites;
		_tmp87_ = _vala_iterable_ref0 (_tmp86_);
		_type_list = _tmp87_;
		_tmp88_ = _type_list;
		_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
		_tmp90_ = _tmp89_;
		_type_size = _tmp90_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp91_;
			gint _tmp92_;
			ValaDataType* type = NULL;
			ValaList* _tmp93_;
			gint _tmp94_;
			gpointer _tmp95_;
			ValaDataType* _tmp96_;
			_type_index = _type_index + 1;
			_tmp91_ = _type_index;
			_tmp92_ = _type_size;
			if (!(_tmp91_ < _tmp92_)) {
				break;
			}
			_tmp93_ = _type_list;
			_tmp94_ = _type_index;
			_tmp95_ = vala_list_get (_tmp93_, _tmp94_);
			type = (ValaDataType*) _tmp95_;
			_tmp96_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp96_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp97_;
		gint _p_size = 0;
		ValaList* _tmp98_;
		gint _tmp99_;
		gint _tmp100_;
		gint _p_index = 0;
		_tmp97_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp97_;
		_tmp98_ = _p_list;
		_tmp99_ = vala_collection_get_size ((ValaCollection*) _tmp98_);
		_tmp100_ = _tmp99_;
		_p_size = _tmp100_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp101_;
			gint _tmp102_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp103_;
			gint _tmp104_;
			gpointer _tmp105_;
			ValaTypeParameter* _tmp106_;
			_p_index = _p_index + 1;
			_tmp101_ = _p_index;
			_tmp102_ = _p_size;
			if (!(_tmp101_ < _tmp102_)) {
				break;
			}
			_tmp103_ = _p_list;
			_tmp104_ = _p_index;
			_tmp105_ = vala_list_get (_tmp103_, _tmp104_);
			p = (ValaTypeParameter*) _tmp105_;
			_tmp106_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp106_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp107_;
		gint _en_size = 0;
		ValaList* _tmp108_;
		gint _tmp109_;
		gint _tmp110_;
		gint _en_index = 0;
		_tmp107_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp107_;
		_tmp108_ = _en_list;
		_tmp109_ = vala_collection_get_size ((ValaCollection*) _tmp108_);
		_tmp110_ = _tmp109_;
		_en_size = _tmp110_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp111_;
			gint _tmp112_;
			ValaEnum* en = NULL;
			ValaList* _tmp113_;
			gint _tmp114_;
			gpointer _tmp115_;
			ValaEnum* _tmp116_;
			_en_index = _en_index + 1;
			_tmp111_ = _en_index;
			_tmp112_ = _en_size;
			if (!(_tmp111_ < _tmp112_)) {
				break;
			}
			_tmp113_ = _en_list;
			_tmp114_ = _en_index;
			_tmp115_ = vala_list_get (_tmp113_, _tmp114_);
			en = (ValaEnum*) _tmp115_;
			_tmp116_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp116_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp117_;
		gint _f_size = 0;
		ValaList* _tmp118_;
		gint _tmp119_;
		gint _tmp120_;
		gint _f_index = 0;
		_tmp117_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp117_;
		_tmp118_ = _f_list;
		_tmp119_ = vala_collection_get_size ((ValaCollection*) _tmp118_);
		_tmp120_ = _tmp119_;
		_f_size = _tmp120_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp121_;
			gint _tmp122_;
			ValaField* f = NULL;
			ValaList* _tmp123_;
			gint _tmp124_;
			gpointer _tmp125_;
			ValaField* _tmp126_;
			_f_index = _f_index + 1;
			_tmp121_ = _f_index;
			_tmp122_ = _f_size;
			if (!(_tmp121_ < _tmp122_)) {
				break;
			}
			_tmp123_ = _f_list;
			_tmp124_ = _f_index;
			_tmp125_ = vala_list_get (_tmp123_, _tmp124_);
			f = (ValaField*) _tmp125_;
			_tmp126_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp126_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp127_;
		gint _c_size = 0;
		ValaList* _tmp128_;
		gint _tmp129_;
		gint _tmp130_;
		gint _c_index = 0;
		_tmp127_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp127_;
		_tmp128_ = _c_list;
		_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
		_tmp130_ = _tmp129_;
		_c_size = _tmp130_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp131_;
			gint _tmp132_;
			ValaConstant* c = NULL;
			ValaList* _tmp133_;
			gint _tmp134_;
			gpointer _tmp135_;
			ValaConstant* _tmp136_;
			_c_index = _c_index + 1;
			_tmp131_ = _c_index;
			_tmp132_ = _c_size;
			if (!(_tmp131_ < _tmp132_)) {
				break;
			}
			_tmp133_ = _c_list;
			_tmp134_ = _c_index;
			_tmp135_ = vala_list_get (_tmp133_, _tmp134_);
			c = (ValaConstant*) _tmp135_;
			_tmp136_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp136_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	_tmp137_ = vala_code_context_get_abi_stability (context);
	_tmp138_ = _tmp137_;
	if (_tmp138_) {
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp139_;
			gint _s_size = 0;
			ValaList* _tmp140_;
			gint _tmp141_;
			gint _tmp142_;
			gint _s_index = 0;
			_tmp139_ = vala_object_type_symbol_get_members ((ValaObjectTypeSymbol*) self);
			_s_list = _tmp139_;
			_tmp140_ = _s_list;
			_tmp141_ = vala_collection_get_size ((ValaCollection*) _tmp140_);
			_tmp142_ = _tmp141_;
			_s_size = _tmp142_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp143_;
				gint _tmp144_;
				ValaSymbol* s = NULL;
				ValaList* _tmp145_;
				gint _tmp146_;
				gpointer _tmp147_;
				ValaSymbol* _tmp148_;
				_s_index = _s_index + 1;
				_tmp143_ = _s_index;
				_tmp144_ = _s_size;
				if (!(_tmp143_ < _tmp144_)) {
					break;
				}
				_tmp145_ = _s_list;
				_tmp146_ = _s_index;
				_tmp147_ = vala_list_get (_tmp145_, _tmp146_);
				s = (ValaSymbol*) _tmp147_;
				_tmp148_ = s;
				if (VALA_IS_METHOD (_tmp148_)) {
					ValaMethod* m = NULL;
					ValaSymbol* _tmp149_;
					ValaMethod* _tmp150_;
					ValaMethod* _tmp151_;
					gboolean _tmp152_ = FALSE;
					ValaMethod* _tmp153_;
					gboolean _tmp154_;
					gboolean _tmp155_;
					_tmp149_ = s;
					_tmp150_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp149_, VALA_TYPE_METHOD, ValaMethod));
					m = _tmp150_;
					_tmp151_ = m;
					vala_code_node_check ((ValaCodeNode*) _tmp151_, context);
					_tmp153_ = m;
					_tmp154_ = vala_method_get_is_virtual (_tmp153_);
					_tmp155_ = _tmp154_;
					if (_tmp155_) {
						_tmp152_ = TRUE;
					} else {
						ValaMethod* _tmp156_;
						gboolean _tmp157_;
						gboolean _tmp158_;
						_tmp156_ = m;
						_tmp157_ = vala_method_get_is_abstract (_tmp156_);
						_tmp158_ = _tmp157_;
						_tmp152_ = _tmp158_;
					}
					if (_tmp152_) {
						ValaList* _tmp159_;
						ValaMethod* _tmp160_;
						_tmp159_ = self->priv->virtuals;
						_tmp160_ = m;
						vala_collection_add ((ValaCollection*) _tmp159_, (ValaSymbol*) _tmp160_);
					}
					_vala_code_node_unref0 (m);
				} else {
					ValaSymbol* _tmp161_;
					_tmp161_ = s;
					if (VALA_IS_SIGNAL (_tmp161_)) {
						ValaSignal* sig = NULL;
						ValaSymbol* _tmp162_;
						ValaSignal* _tmp163_;
						ValaSignal* _tmp164_;
						ValaSignal* _tmp165_;
						gboolean _tmp166_;
						gboolean _tmp167_;
						_tmp162_ = s;
						_tmp163_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, VALA_TYPE_SIGNAL, ValaSignal));
						sig = _tmp163_;
						_tmp164_ = sig;
						vala_code_node_check ((ValaCodeNode*) _tmp164_, context);
						_tmp165_ = sig;
						_tmp166_ = vala_signal_get_is_virtual (_tmp165_);
						_tmp167_ = _tmp166_;
						if (_tmp167_) {
							ValaList* _tmp168_;
							ValaSignal* _tmp169_;
							_tmp168_ = self->priv->virtuals;
							_tmp169_ = sig;
							vala_collection_add ((ValaCollection*) _tmp168_, (ValaSymbol*) _tmp169_);
						}
						_vala_code_node_unref0 (sig);
					} else {
						ValaSymbol* _tmp170_;
						_tmp170_ = s;
						if (VALA_IS_PROPERTY (_tmp170_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp171_;
							ValaProperty* _tmp172_;
							ValaProperty* _tmp173_;
							gboolean _tmp174_ = FALSE;
							ValaProperty* _tmp175_;
							gboolean _tmp176_;
							gboolean _tmp177_;
							_tmp171_ = s;
							_tmp172_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp171_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp172_;
							_tmp173_ = prop;
							vala_code_node_check ((ValaCodeNode*) _tmp173_, context);
							_tmp175_ = prop;
							_tmp176_ = vala_property_get_is_virtual (_tmp175_);
							_tmp177_ = _tmp176_;
							if (_tmp177_) {
								_tmp174_ = TRUE;
							} else {
								ValaProperty* _tmp178_;
								gboolean _tmp179_;
								gboolean _tmp180_;
								_tmp178_ = prop;
								_tmp179_ = vala_property_get_is_abstract (_tmp178_);
								_tmp180_ = _tmp179_;
								_tmp174_ = _tmp180_;
							}
							if (_tmp174_) {
								ValaList* _tmp181_;
								ValaProperty* _tmp182_;
								_tmp181_ = self->priv->virtuals;
								_tmp182_ = prop;
								vala_collection_add ((ValaCollection*) _tmp181_, (ValaSymbol*) _tmp182_);
							}
							_vala_code_node_unref0 (prop);
						}
					}
				}
				_vala_code_node_unref0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
	} else {
		{
			ValaList* _m_list = NULL;
			ValaList* _tmp183_;
			gint _m_size = 0;
			ValaList* _tmp184_;
			gint _tmp185_;
			gint _tmp186_;
			gint _m_index = 0;
			_tmp183_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
			_m_list = _tmp183_;
			_tmp184_ = _m_list;
			_tmp185_ = vala_collection_get_size ((ValaCollection*) _tmp184_);
			_tmp186_ = _tmp185_;
			_m_size = _tmp186_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp187_;
				gint _tmp188_;
				ValaMethod* m = NULL;
				ValaList* _tmp189_;
				gint _tmp190_;
				gpointer _tmp191_;
				ValaMethod* _tmp192_;
				gboolean _tmp193_ = FALSE;
				ValaMethod* _tmp194_;
				gboolean _tmp195_;
				gboolean _tmp196_;
				_m_index = _m_index + 1;
				_tmp187_ = _m_index;
				_tmp188_ = _m_size;
				if (!(_tmp187_ < _tmp188_)) {
					break;
				}
				_tmp189_ = _m_list;
				_tmp190_ = _m_index;
				_tmp191_ = vala_list_get (_tmp189_, _tmp190_);
				m = (ValaMethod*) _tmp191_;
				_tmp192_ = m;
				vala_code_node_check ((ValaCodeNode*) _tmp192_, context);
				_tmp194_ = m;
				_tmp195_ = vala_method_get_is_virtual (_tmp194_);
				_tmp196_ = _tmp195_;
				if (_tmp196_) {
					_tmp193_ = TRUE;
				} else {
					ValaMethod* _tmp197_;
					gboolean _tmp198_;
					gboolean _tmp199_;
					_tmp197_ = m;
					_tmp198_ = vala_method_get_is_abstract (_tmp197_);
					_tmp199_ = _tmp198_;
					_tmp193_ = _tmp199_;
				}
				if (_tmp193_) {
					ValaList* _tmp200_;
					ValaMethod* _tmp201_;
					_tmp200_ = self->priv->virtuals;
					_tmp201_ = m;
					vala_collection_add ((ValaCollection*) _tmp200_, (ValaSymbol*) _tmp201_);
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp202_;
			gint _sig_size = 0;
			ValaList* _tmp203_;
			gint _tmp204_;
			gint _tmp205_;
			gint _sig_index = 0;
			_tmp202_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
			_sig_list = _tmp202_;
			_tmp203_ = _sig_list;
			_tmp204_ = vala_collection_get_size ((ValaCollection*) _tmp203_);
			_tmp205_ = _tmp204_;
			_sig_size = _tmp205_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp206_;
				gint _tmp207_;
				ValaSignal* sig = NULL;
				ValaList* _tmp208_;
				gint _tmp209_;
				gpointer _tmp210_;
				ValaSignal* _tmp211_;
				ValaSignal* _tmp212_;
				gboolean _tmp213_;
				gboolean _tmp214_;
				_sig_index = _sig_index + 1;
				_tmp206_ = _sig_index;
				_tmp207_ = _sig_size;
				if (!(_tmp206_ < _tmp207_)) {
					break;
				}
				_tmp208_ = _sig_list;
				_tmp209_ = _sig_index;
				_tmp210_ = vala_list_get (_tmp208_, _tmp209_);
				sig = (ValaSignal*) _tmp210_;
				_tmp211_ = sig;
				vala_code_node_check ((ValaCodeNode*) _tmp211_, context);
				_tmp212_ = sig;
				_tmp213_ = vala_signal_get_is_virtual (_tmp212_);
				_tmp214_ = _tmp213_;
				if (_tmp214_) {
					ValaList* _tmp215_;
					ValaSignal* _tmp216_;
					_tmp215_ = self->priv->virtuals;
					_tmp216_ = sig;
					vala_collection_add ((ValaCollection*) _tmp215_, (ValaSymbol*) _tmp216_);
				}
				_vala_code_node_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		{
			ValaList* _prop_list = NULL;
			ValaList* _tmp217_;
			gint _prop_size = 0;
			ValaList* _tmp218_;
			gint _tmp219_;
			gint _tmp220_;
			gint _prop_index = 0;
			_tmp217_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
			_prop_list = _tmp217_;
			_tmp218_ = _prop_list;
			_tmp219_ = vala_collection_get_size ((ValaCollection*) _tmp218_);
			_tmp220_ = _tmp219_;
			_prop_size = _tmp220_;
			_prop_index = -1;
			while (TRUE) {
				gint _tmp221_;
				gint _tmp222_;
				ValaProperty* prop = NULL;
				ValaList* _tmp223_;
				gint _tmp224_;
				gpointer _tmp225_;
				ValaProperty* _tmp226_;
				gboolean _tmp227_ = FALSE;
				ValaProperty* _tmp228_;
				gboolean _tmp229_;
				gboolean _tmp230_;
				_prop_index = _prop_index + 1;
				_tmp221_ = _prop_index;
				_tmp222_ = _prop_size;
				if (!(_tmp221_ < _tmp222_)) {
					break;
				}
				_tmp223_ = _prop_list;
				_tmp224_ = _prop_index;
				_tmp225_ = vala_list_get (_tmp223_, _tmp224_);
				prop = (ValaProperty*) _tmp225_;
				_tmp226_ = prop;
				vala_code_node_check ((ValaCodeNode*) _tmp226_, context);
				_tmp228_ = prop;
				_tmp229_ = vala_property_get_is_virtual (_tmp228_);
				_tmp230_ = _tmp229_;
				if (_tmp230_) {
					_tmp227_ = TRUE;
				} else {
					ValaProperty* _tmp231_;
					gboolean _tmp232_;
					gboolean _tmp233_;
					_tmp231_ = prop;
					_tmp232_ = vala_property_get_is_abstract (_tmp231_);
					_tmp233_ = _tmp232_;
					_tmp227_ = _tmp233_;
				}
				if (_tmp227_) {
					ValaList* _tmp234_;
					ValaProperty* _tmp235_;
					_tmp234_ = self->priv->virtuals;
					_tmp235_ = prop;
					vala_collection_add ((ValaCollection*) _tmp234_, (ValaSymbol*) _tmp235_);
				}
				_vala_code_node_unref0 (prop);
			}
			_vala_iterable_unref0 (_prop_list);
		}
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp236_;
		gint _cl_size = 0;
		ValaList* _tmp237_;
		gint _tmp238_;
		gint _tmp239_;
		gint _cl_index = 0;
		_tmp236_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp236_;
		_tmp237_ = _cl_list;
		_tmp238_ = vala_collection_get_size ((ValaCollection*) _tmp237_);
		_tmp239_ = _tmp238_;
		_cl_size = _tmp239_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp240_;
			gint _tmp241_;
			ValaClass* cl = NULL;
			ValaList* _tmp242_;
			gint _tmp243_;
			gpointer _tmp244_;
			ValaClass* _tmp245_;
			_cl_index = _cl_index + 1;
			_tmp240_ = _cl_index;
			_tmp241_ = _cl_size;
			if (!(_tmp240_ < _tmp241_)) {
				break;
			}
			_tmp242_ = _cl_list;
			_tmp243_ = _cl_index;
			_tmp244_ = vala_list_get (_tmp242_, _tmp243_);
			cl = (ValaClass*) _tmp244_;
			_tmp245_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp245_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp246_;
		gint _st_size = 0;
		ValaList* _tmp247_;
		gint _tmp248_;
		gint _tmp249_;
		gint _st_index = 0;
		_tmp246_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp246_;
		_tmp247_ = _st_list;
		_tmp248_ = vala_collection_get_size ((ValaCollection*) _tmp247_);
		_tmp249_ = _tmp248_;
		_st_size = _tmp249_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp250_;
			gint _tmp251_;
			ValaStruct* st = NULL;
			ValaList* _tmp252_;
			gint _tmp253_;
			gpointer _tmp254_;
			ValaStruct* _tmp255_;
			_st_index = _st_index + 1;
			_tmp250_ = _st_index;
			_tmp251_ = _st_size;
			if (!(_tmp250_ < _tmp251_)) {
				break;
			}
			_tmp252_ = _st_list;
			_tmp253_ = _st_index;
			_tmp254_ = vala_list_get (_tmp252_, _tmp253_);
			st = (ValaStruct*) _tmp254_;
			_tmp255_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp255_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp256_;
		gint _d_size = 0;
		ValaList* _tmp257_;
		gint _tmp258_;
		gint _tmp259_;
		gint _d_index = 0;
		_tmp256_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp256_;
		_tmp257_ = _d_list;
		_tmp258_ = vala_collection_get_size ((ValaCollection*) _tmp257_);
		_tmp259_ = _tmp258_;
		_d_size = _tmp259_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp260_;
			gint _tmp261_;
			ValaDelegate* d = NULL;
			ValaList* _tmp262_;
			gint _tmp263_;
			gpointer _tmp264_;
			ValaDelegate* _tmp265_;
			_d_index = _d_index + 1;
			_tmp260_ = _d_index;
			_tmp261_ = _d_size;
			if (!(_tmp260_ < _tmp261_)) {
				break;
			}
			_tmp262_ = _d_list;
			_tmp263_ = _d_index;
			_tmp264_ = vala_list_get (_tmp262_, _tmp263_);
			d = (ValaDelegate*) _tmp264_;
			_tmp265_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp265_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp266_ = g_direct_hash;
	_tmp267_ = g_direct_equal;
	_tmp268_ = g_direct_equal;
	_tmp269_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp266_, _tmp267_, _tmp268_);
	positions = (ValaMap*) _tmp269_;
	ordered_seen = FALSE;
	unordered_seen = FALSE;
	{
		ValaList* _sym_list = NULL;
		ValaList* _tmp270_;
		ValaList* _tmp271_;
		gint _sym_size = 0;
		ValaList* _tmp272_;
		gint _tmp273_;
		gint _tmp274_;
		gint _sym_index = 0;
		_tmp270_ = self->priv->virtuals;
		_tmp271_ = _vala_iterable_ref0 (_tmp270_);
		_sym_list = _tmp271_;
		_tmp272_ = _sym_list;
		_tmp273_ = vala_collection_get_size ((ValaCollection*) _tmp272_);
		_tmp274_ = _tmp273_;
		_sym_size = _tmp274_;
		_sym_index = -1;
		while (TRUE) {
			gint _tmp275_;
			gint _tmp276_;
			ValaSymbol* sym = NULL;
			ValaList* _tmp277_;
			gint _tmp278_;
			gpointer _tmp279_;
			gint ordering = 0;
			ValaSymbol* _tmp280_;
			gint _tmp281_;
			gboolean ordered = FALSE;
			gint _tmp290_;
			gboolean _tmp291_ = FALSE;
			gboolean _tmp292_ = FALSE;
			gboolean _tmp293_;
			gboolean _tmp304_ = FALSE;
			gboolean _tmp305_;
			gboolean _tmp307_ = FALSE;
			gboolean _tmp308_ = FALSE;
			gboolean _tmp309_;
			gboolean _tmp320_ = FALSE;
			gboolean _tmp321_;
			gboolean _tmp323_ = FALSE;
			gboolean _tmp324_;
			_sym_index = _sym_index + 1;
			_tmp275_ = _sym_index;
			_tmp276_ = _sym_size;
			if (!(_tmp275_ < _tmp276_)) {
				break;
			}
			_tmp277_ = _sym_list;
			_tmp278_ = _sym_index;
			_tmp279_ = vala_list_get (_tmp277_, _tmp278_);
			sym = (ValaSymbol*) _tmp279_;
			_tmp280_ = sym;
			ordering = vala_code_node_get_attribute_integer ((ValaCodeNode*) _tmp280_, "CCode", "ordering", -1);
			_tmp281_ = ordering;
			if (_tmp281_ < -1) {
				ValaSymbol* _tmp282_;
				ValaSourceReference* _tmp283_;
				ValaSourceReference* _tmp284_;
				ValaSymbol* _tmp285_;
				gchar* _tmp286_;
				gchar* _tmp287_;
				gchar* _tmp288_;
				gchar* _tmp289_;
				_tmp282_ = sym;
				_tmp283_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp282_);
				_tmp284_ = _tmp283_;
				_tmp285_ = sym;
				_tmp286_ = vala_symbol_get_full_name (_tmp285_);
				_tmp287_ = _tmp286_;
				_tmp288_ = g_strdup_printf ("%s: Invalid ordering", _tmp287_);
				_tmp289_ = _tmp288_;
				vala_report_error (_tmp284_, _tmp289_);
				_g_free0 (_tmp289_);
				_g_free0 (_tmp287_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				ordered_seen = TRUE;
				unordered_seen = TRUE;
				_vala_code_node_unref0 (sym);
				continue;
			}
			_tmp290_ = ordering;
			ordered = _tmp290_ != -1;
			_tmp293_ = ordered;
			if (_tmp293_) {
				gboolean _tmp294_;
				_tmp294_ = unordered_seen;
				_tmp292_ = _tmp294_;
			} else {
				_tmp292_ = FALSE;
			}
			if (_tmp292_) {
				gboolean _tmp295_;
				_tmp295_ = ordered_seen;
				_tmp291_ = !_tmp295_;
			} else {
				_tmp291_ = FALSE;
			}
			if (_tmp291_) {
				ValaSymbol* _tmp296_;
				ValaSourceReference* _tmp297_;
				ValaSourceReference* _tmp298_;
				ValaSymbol* _tmp299_;
				gchar* _tmp300_;
				gchar* _tmp301_;
				gchar* _tmp302_;
				gchar* _tmp303_;
				_tmp296_ = sym;
				_tmp297_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp296_);
				_tmp298_ = _tmp297_;
				_tmp299_ = sym;
				_tmp300_ = vala_symbol_get_full_name (_tmp299_);
				_tmp301_ = _tmp300_;
				_tmp302_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp301_);
				_tmp303_ = _tmp302_;
				vala_report_error (_tmp298_, _tmp303_);
				_g_free0 (_tmp303_);
				_g_free0 (_tmp301_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp305_ = ordered_seen;
			if (_tmp305_) {
				_tmp304_ = TRUE;
			} else {
				gboolean _tmp306_;
				_tmp306_ = ordered;
				_tmp304_ = _tmp306_;
			}
			ordered_seen = _tmp304_;
			_tmp309_ = ordered;
			if (!_tmp309_) {
				gboolean _tmp310_;
				_tmp310_ = unordered_seen;
				_tmp308_ = !_tmp310_;
			} else {
				_tmp308_ = FALSE;
			}
			if (_tmp308_) {
				gboolean _tmp311_;
				_tmp311_ = ordered_seen;
				_tmp307_ = _tmp311_;
			} else {
				_tmp307_ = FALSE;
			}
			if (_tmp307_) {
				ValaSymbol* _tmp312_;
				ValaSourceReference* _tmp313_;
				ValaSourceReference* _tmp314_;
				ValaSymbol* _tmp315_;
				gchar* _tmp316_;
				gchar* _tmp317_;
				gchar* _tmp318_;
				gchar* _tmp319_;
				_tmp312_ = sym;
				_tmp313_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp312_);
				_tmp314_ = _tmp313_;
				_tmp315_ = sym;
				_tmp316_ = vala_symbol_get_full_name (_tmp315_);
				_tmp317_ = _tmp316_;
				_tmp318_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp317_);
				_tmp319_ = _tmp318_;
				vala_report_error (_tmp314_, _tmp319_);
				_g_free0 (_tmp319_);
				_g_free0 (_tmp317_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp321_ = unordered_seen;
			if (_tmp321_) {
				_tmp320_ = TRUE;
			} else {
				gboolean _tmp322_;
				_tmp322_ = ordered;
				_tmp320_ = !_tmp322_;
			}
			unordered_seen = _tmp320_;
			_tmp324_ = ordered_seen;
			if (!_tmp324_) {
				_tmp323_ = TRUE;
			} else {
				gboolean _tmp325_;
				_tmp325_ = unordered_seen;
				_tmp323_ = !_tmp325_;
			}
			if (_tmp323_) {
				gboolean _tmp326_;
				_tmp326_ = ordered;
				if (_tmp326_) {
					ValaSymbol* prev = NULL;
					ValaMap* _tmp327_;
					gint _tmp328_;
					gpointer _tmp329_;
					ValaSymbol* _tmp330_;
					ValaMap* _tmp342_;
					gint _tmp343_;
					ValaSymbol* _tmp344_;
					_tmp327_ = positions;
					_tmp328_ = ordering;
					_tmp329_ = vala_map_get (_tmp327_, (gpointer) ((gintptr) _tmp328_));
					prev = (ValaSymbol*) _tmp329_;
					_tmp330_ = prev;
					if (_tmp330_ != NULL) {
						ValaSymbol* _tmp331_;
						ValaSourceReference* _tmp332_;
						ValaSourceReference* _tmp333_;
						ValaSymbol* _tmp334_;
						gchar* _tmp335_;
						gchar* _tmp336_;
						ValaSymbol* _tmp337_;
						const gchar* _tmp338_;
						const gchar* _tmp339_;
						gchar* _tmp340_;
						gchar* _tmp341_;
						_tmp331_ = sym;
						_tmp332_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp331_);
						_tmp333_ = _tmp332_;
						_tmp334_ = sym;
						_tmp335_ = vala_symbol_get_full_name (_tmp334_);
						_tmp336_ = _tmp335_;
						_tmp337_ = prev;
						_tmp338_ = vala_symbol_get_name (_tmp337_);
						_tmp339_ = _tmp338_;
						_tmp340_ = g_strdup_printf ("%s: Duplicate ordering (previous virtual with the same position is %s)", _tmp336_, _tmp339_);
						_tmp341_ = _tmp340_;
						vala_report_error (_tmp333_, _tmp341_);
						_g_free0 (_tmp341_);
						_g_free0 (_tmp336_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp342_ = positions;
					_tmp343_ = ordering;
					_tmp344_ = sym;
					vala_map_set (_tmp342_, (gpointer) ((gintptr) _tmp343_), _tmp344_);
					_vala_code_node_unref0 (prev);
				}
			}
			_vala_code_node_unref0 (sym);
		}
		_vala_iterable_unref0 (_sym_list);
	}
	_tmp345_ = ordered_seen;
	if (_tmp345_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp346_ = FALSE;
				_tmp346_ = TRUE;
				while (TRUE) {
					gint _tmp348_;
					ValaList* _tmp349_;
					gint _tmp350_;
					gint _tmp351_;
					ValaSymbol* sym = NULL;
					ValaMap* _tmp352_;
					gint _tmp353_;
					gpointer _tmp354_;
					ValaSymbol* _tmp355_;
					gboolean _tmp363_;
					gboolean _tmp364_;
					if (!_tmp346_) {
						gint _tmp347_;
						_tmp347_ = i;
						i = _tmp347_ + 1;
					}
					_tmp346_ = FALSE;
					_tmp348_ = i;
					_tmp349_ = self->priv->virtuals;
					_tmp350_ = vala_collection_get_size ((ValaCollection*) _tmp349_);
					_tmp351_ = _tmp350_;
					if (!(_tmp348_ < _tmp351_)) {
						break;
					}
					_tmp352_ = positions;
					_tmp353_ = i;
					_tmp354_ = vala_map_get (_tmp352_, (gpointer) ((gintptr) _tmp353_));
					sym = (ValaSymbol*) _tmp354_;
					_tmp355_ = sym;
					if (_tmp355_ == NULL) {
						ValaSourceReference* _tmp356_;
						ValaSourceReference* _tmp357_;
						gchar* _tmp358_;
						gchar* _tmp359_;
						gint _tmp360_;
						gchar* _tmp361_;
						gchar* _tmp362_;
						_tmp356_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp357_ = _tmp356_;
						_tmp358_ = vala_symbol_get_full_name ((ValaSymbol*) self);
						_tmp359_ = _tmp358_;
						_tmp360_ = i;
						_tmp361_ = g_strdup_printf ("%s: Gap in ordering in position %d", _tmp359_, _tmp360_);
						_tmp362_ = _tmp361_;
						vala_report_error (_tmp357_, _tmp362_);
						_g_free0 (_tmp362_);
						_g_free0 (_tmp359_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp363_ = vala_code_node_get_error ((ValaCodeNode*) self);
					_tmp364_ = _tmp363_;
					if (!_tmp364_) {
						ValaList* _tmp365_;
						gint _tmp366_;
						ValaSymbol* _tmp367_;
						_tmp365_ = self->priv->virtuals;
						_tmp366_ = i;
						_tmp367_ = sym;
						vala_list_set (_tmp365_, _tmp366_, _tmp367_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	_tmp368_ = vala_code_context_get_analyzer (context);
	_tmp369_ = _tmp368_;
	_tmp370_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp369_, _tmp370_);
	_tmp371_ = vala_code_context_get_analyzer (context);
	_tmp372_ = _tmp371_;
	_tmp373_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp372_, _tmp373_);
	_tmp374_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp375_ = _tmp374_;
	result = !_tmp375_;
	_vala_map_unref0 (positions);
	_vala_code_node_unref0 (prereq_class);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


static void
vala_interface_class_init (ValaInterfaceClass * klass)
{
	vala_interface_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_interface_finalize;
	g_type_class_add_private (klass, sizeof (ValaInterfacePrivate));
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_interface_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_interface_real_add_property;
	((ValaInterfaceClass *) klass)->get_virtuals = (ValaList* (*) (ValaInterface*)) vala_interface_real_get_virtuals;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_interface_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_interface_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_interface_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_interface_real_check;
}


static void
vala_interface_instance_init (ValaInterface * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = VALA_INTERFACE_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->prerequisites = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->virtuals = (ValaList*) _tmp3_;
}


static void
vala_interface_finalize (ValaCodeNode * obj)
{
	ValaInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INTERFACE, ValaInterface);
	_vala_iterable_unref0 (self->priv->prerequisites);
	_vala_iterable_unref0 (self->priv->virtuals);
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->finalize (obj);
}


/**
 * Represents an interface declaration in the source code.
 */
GType
vala_interface_get_type (void)
{
	static volatile gsize vala_interface_type_id__volatile = 0;
	if (g_once_init_enter (&vala_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterface), 0, (GInstanceInitFunc) vala_interface_instance_init, NULL };
		GType vala_interface_type_id;
		vala_interface_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaInterface", &g_define_type_info, 0);
		g_once_init_leave (&vala_interface_type_id__volatile, vala_interface_type_id);
	}
	return vala_interface_type_id__volatile;
}



