/* valaarraycreationexpression.c generated by valac, the Vala compiler
 * generated from valaarraycreationexpression.vala, do not modify */

/* valaarraycreationexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaArrayCreationExpressionPrivate {
	gint _rank;
	ValaList* sizes;
	ValaDataType* _element_type;
	ValaInitializerList* _initializer_list;
};


static gpointer vala_array_creation_expression_parent_class = NULL;

#define VALA_ARRAY_CREATION_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionPrivate))
static void vala_array_creation_expression_real_accept_children (ValaCodeNode* base,
                                                          ValaCodeVisitor* visitor);
static void vala_array_creation_expression_real_accept (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static gboolean vala_array_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_array_creation_expression_real_is_accessible (ValaExpression* base,
                                                            ValaSymbol* sym);
static gchar* vala_array_creation_expression_real_to_string (ValaCodeNode* base);
static void vala_array_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                             ValaExpression* old_node,
                                                             ValaExpression* new_node);
static void vala_array_creation_expression_real_replace_type (ValaCodeNode* base,
                                                       ValaDataType* old_type,
                                                       ValaDataType* new_type);
static gint vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self,
                                                                        ValaCodeContext* context,
                                                                        ValaInitializerList* il,
                                                                        gint rank,
                                                                        ValaList* sl);
static gboolean vala_array_creation_expression_real_check (ValaCodeNode* base,
                                                    ValaCodeContext* context);
static void vala_array_creation_expression_real_emit (ValaCodeNode* base,
                                               ValaCodeGenerator* codegen);
static void vala_array_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                             ValaCollection* collection);
static void vala_array_creation_expression_finalize (ValaCodeNode * obj);


/**
 * Add a size expression.
 */
void
vala_array_creation_expression_append_size (ValaArrayCreationExpression* self,
                                            ValaExpression* size)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (size != NULL);
	_tmp0_ = self->priv->sizes;
	vala_collection_add ((ValaCollection*) _tmp0_, size);
	if (size != NULL) {
		vala_code_node_set_parent_node ((ValaCodeNode*) size, (ValaCodeNode*) self);
	}
}


/**
 * Get the sizes for all dimensions ascending from left to right.
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_array_creation_expression_get_sizes (ValaArrayCreationExpression* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sizes;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


ValaArrayCreationExpression*
vala_array_creation_expression_construct (GType object_type,
                                          ValaDataType* element_type,
                                          gint rank,
                                          ValaInitializerList* initializer_list,
                                          ValaSourceReference* source_reference)
{
	ValaArrayCreationExpression* self = NULL;
	g_return_val_if_fail (element_type != NULL, NULL);
	self = (ValaArrayCreationExpression*) vala_expression_construct (object_type);
	vala_array_creation_expression_set_element_type (self, element_type);
	vala_array_creation_expression_set_rank (self, rank);
	vala_array_creation_expression_set_initializer_list (self, initializer_list);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaArrayCreationExpression*
vala_array_creation_expression_new (ValaDataType* element_type,
                                    gint rank,
                                    ValaInitializerList* initializer_list,
                                    ValaSourceReference* source_reference)
{
	return vala_array_creation_expression_construct (VALA_TYPE_ARRAY_CREATION_EXPRESSION, element_type, rank, initializer_list, source_reference);
}


static void
vala_array_creation_expression_real_accept_children (ValaCodeNode* base,
                                                     ValaCodeVisitor* visitor)
{
	ValaArrayCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaInitializerList* _tmp15_;
	ValaInitializerList* _tmp16_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_array_creation_expression_get_element_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_array_creation_expression_get_element_type (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _e_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _e_index = 0;
		_tmp4_ = self->priv->sizes;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_e_list = _tmp5_;
		_tmp6_ = _e_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_e_size = _tmp8_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* e = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			_e_index = _e_index + 1;
			_tmp9_ = _e_index;
			_tmp10_ = _e_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _e_list;
			_tmp12_ = _e_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			e = (ValaExpression*) _tmp13_;
			_tmp14_ = e;
			vala_code_node_accept ((ValaCodeNode*) _tmp14_, visitor);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp15_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		ValaInitializerList* _tmp17_;
		ValaInitializerList* _tmp18_;
		_tmp17_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp18_ = _tmp17_;
		vala_code_node_accept ((ValaCodeNode*) _tmp18_, visitor);
	}
}


static void
vala_array_creation_expression_real_accept (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_array_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static gboolean
vala_array_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaArrayCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaArrayCreationExpression*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_array_creation_expression_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym)
{
	ValaArrayCreationExpression * self;
	gboolean result = FALSE;
	ValaInitializerList* _tmp11_;
	ValaInitializerList* _tmp12_;
	self = (ValaArrayCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _e_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = self->priv->sizes;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* e = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_e_index = _e_index + 1;
			_tmp5_ = _e_index;
			_tmp6_ = _e_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _e_list;
			_tmp8_ = _e_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			e = (ValaExpression*) _tmp9_;
			_tmp10_ = e;
			if (!vala_expression_is_accessible (_tmp10_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (e);
				_vala_iterable_unref0 (_e_list);
				return result;
			}
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp11_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		ValaInitializerList* _tmp13_;
		ValaInitializerList* _tmp14_;
		_tmp13_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp14_ = _tmp13_;
		result = vala_expression_is_accessible ((ValaExpression*) _tmp14_, sym);
		return result;
	}
	result = TRUE;
	return result;
}


static gchar*
vala_array_creation_expression_real_to_string (ValaCodeNode* base)
{
	ValaArrayCreationExpression * self;
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean first = FALSE;
	GString* _tmp25_;
	ValaInitializerList* _tmp26_;
	ValaInitializerList* _tmp27_;
	GString* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	self = (ValaArrayCreationExpression*) base;
	_tmp0_ = g_string_new ("new ");
	builder = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = vala_array_creation_expression_get_element_type (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_code_node_to_string ((ValaCodeNode*) _tmp3_);
	_tmp5_ = _tmp4_;
	g_string_append_printf (_tmp1_, "%s[", _tmp5_);
	_g_free0 (_tmp5_);
	first = TRUE;
	{
		ValaList* _size_list = NULL;
		ValaList* _tmp6_;
		ValaList* _tmp7_;
		gint _size_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _size_index = 0;
		_tmp6_ = self->priv->sizes;
		_tmp7_ = _vala_iterable_ref0 (_tmp6_);
		_size_list = _tmp7_;
		_tmp8_ = _size_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_size_size = _tmp10_;
		_size_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			ValaExpression* size = NULL;
			ValaList* _tmp13_;
			gint _tmp14_;
			gpointer _tmp15_;
			gboolean _tmp16_;
			_size_index = _size_index + 1;
			_tmp11_ = _size_index;
			_tmp12_ = _size_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _size_list;
			_tmp14_ = _size_index;
			_tmp15_ = vala_list_get (_tmp13_, _tmp14_);
			size = (ValaExpression*) _tmp15_;
			_tmp16_ = first;
			if (_tmp16_) {
				GString* _tmp17_;
				ValaExpression* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp17_ = builder;
				_tmp18_ = size;
				_tmp19_ = vala_code_node_to_string ((ValaCodeNode*) _tmp18_);
				_tmp20_ = _tmp19_;
				g_string_append (_tmp17_, _tmp20_);
				_g_free0 (_tmp20_);
				first = FALSE;
			} else {
				GString* _tmp21_;
				ValaExpression* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp21_ = builder;
				_tmp22_ = size;
				_tmp23_ = vala_code_node_to_string ((ValaCodeNode*) _tmp22_);
				_tmp24_ = _tmp23_;
				g_string_append_printf (_tmp21_, ", %s", _tmp24_);
				_g_free0 (_tmp24_);
			}
			_vala_code_node_unref0 (size);
		}
		_vala_iterable_unref0 (_size_list);
	}
	_tmp25_ = builder;
	g_string_append_c (_tmp25_, ']');
	_tmp26_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ != NULL) {
		GString* _tmp28_;
		ValaInitializerList* _tmp29_;
		ValaInitializerList* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp28_ = builder;
		_tmp29_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_code_node_to_string ((ValaCodeNode*) _tmp30_);
		_tmp32_ = _tmp31_;
		g_string_append (_tmp28_, _tmp32_);
		_g_free0 (_tmp32_);
	}
	_tmp33_ = builder;
	_tmp34_ = _tmp33_->str;
	_tmp35_ = g_strdup (_tmp34_);
	result = _tmp35_;
	_g_string_free0 (builder);
	return result;
}


static void
vala_array_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                        ValaExpression* old_node,
                                                        ValaExpression* new_node)
{
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaExpression* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->sizes;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->sizes;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaExpression*) _tmp8_;
				_tmp10_ = _tmp9_ == old_node;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->sizes;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}


static void
vala_array_creation_expression_real_replace_type (ValaCodeNode* base,
                                                  ValaDataType* old_type,
                                                  ValaDataType* new_type)
{
	ValaArrayCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_array_creation_expression_get_element_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_array_creation_expression_set_element_type (self, new_type);
	}
}


static gint
vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self,
                                                                   ValaCodeContext* context,
                                                                   ValaInitializerList* il,
                                                                   gint rank,
                                                                   ValaList* sl)
{
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint subsize = 0;
	gint _tmp48_;
	gint _tmp49_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (context != NULL, 0);
	g_return_val_if_fail (il != NULL, 0);
	g_return_val_if_fail (sl != NULL, 0);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) sl);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_rank;
	if (_tmp1_ == (_tmp2_ - rank)) {
		ValaIntegerLiteral* init = NULL;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaIntegerLiteral* _tmp9_;
		ValaIntegerLiteral* _tmp10_;
		ValaIntegerLiteral* _tmp11_;
		ValaIntegerLiteral* _tmp12_;
		_tmp3_ = vala_initializer_list_get_size (il);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("%i", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) il);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_integer_literal_new (_tmp6_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp6_);
		init = _tmp10_;
		_tmp11_ = init;
		vala_code_node_check ((ValaCodeNode*) _tmp11_, context);
		_tmp12_ = init;
		vala_collection_add ((ValaCollection*) sl, (ValaLiteral*) _tmp12_);
		_vala_code_node_unref0 (init);
	}
	subsize = -1;
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp13_;
		gint _e_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _e_index = 0;
		_tmp13_ = vala_initializer_list_get_initializers (il);
		_e_list = _tmp13_;
		_tmp14_ = _e_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_e_size = _tmp16_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			ValaExpression* e = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			gboolean _tmp22_ = FALSE;
			ValaExpression* _tmp23_;
			_e_index = _e_index + 1;
			_tmp17_ = _e_index;
			_tmp18_ = _e_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _e_list;
			_tmp20_ = _e_index;
			_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
			e = (ValaExpression*) _tmp21_;
			_tmp23_ = e;
			if (VALA_IS_INITIALIZER_LIST (_tmp23_)) {
				ValaExpression* _tmp24_;
				ValaDataType* _tmp25_;
				ValaDataType* _tmp26_;
				_tmp24_ = e;
				_tmp25_ = vala_expression_get_target_type (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp22_ = VALA_IS_ARRAY_TYPE (_tmp26_);
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				gint size = 0;
				ValaExpression* _tmp31_;
				gint _tmp32_;
				gboolean _tmp33_ = FALSE;
				gint _tmp34_;
				if (rank == 1) {
					ValaExpression* _tmp27_;
					ValaExpression* _tmp28_;
					ValaSourceReference* _tmp29_;
					ValaSourceReference* _tmp30_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp27_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp27_, TRUE);
					_tmp28_ = e;
					_tmp29_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp28_);
					_tmp30_ = _tmp29_;
					vala_report_error (_tmp30_, "Expected array element, got array initializer list");
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
				_tmp31_ = e;
				size = vala_array_creation_expression_create_sizes_from_initializer_list (self, context, G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList), rank - 1, sl);
				_tmp32_ = size;
				if (_tmp32_ == -1) {
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
				_tmp34_ = subsize;
				if (_tmp34_ >= 0) {
					gint _tmp35_;
					gint _tmp36_;
					_tmp35_ = subsize;
					_tmp36_ = size;
					_tmp33_ = _tmp35_ != _tmp36_;
				} else {
					_tmp33_ = FALSE;
				}
				if (_tmp33_) {
					ValaSourceReference* _tmp37_;
					ValaSourceReference* _tmp38_;
					gint _tmp39_;
					gint _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) il);
					_tmp38_ = _tmp37_;
					_tmp39_ = subsize;
					_tmp40_ = size;
					_tmp41_ = g_strdup_printf ("Expected initializer list of size %d, got size %d", _tmp39_, _tmp40_);
					_tmp42_ = _tmp41_;
					vala_report_error (_tmp38_, _tmp42_);
					_g_free0 (_tmp42_);
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				} else {
					gint _tmp43_;
					_tmp43_ = size;
					subsize = _tmp43_;
				}
			} else {
				if (rank != 1) {
					ValaExpression* _tmp44_;
					ValaExpression* _tmp45_;
					ValaSourceReference* _tmp46_;
					ValaSourceReference* _tmp47_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp44_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp44_, TRUE);
					_tmp45_ = e;
					_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp45_);
					_tmp47_ = _tmp46_;
					vala_report_error (_tmp47_, "Expected array initializer list, got array element");
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
			}
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp48_ = vala_initializer_list_get_size (il);
	_tmp49_ = _tmp48_;
	result = _tmp49_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_array_creation_expression_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context)
{
	ValaArrayCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaList* sizes = NULL;
	ValaList* _tmp4_;
	ValaInitializerList* initlist = NULL;
	ValaInitializerList* _tmp5_;
	ValaInitializerList* _tmp6_;
	ValaInitializerList* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaArrayList* calc_sizes = NULL;
	GEqualFunc _tmp23_;
	ValaArrayList* _tmp24_;
	ValaInitializerList* _tmp25_;
	ValaList* _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	gboolean _tmp103_;
	gboolean _tmp104_;
	gboolean _tmp105_ = FALSE;
	ValaInitializerList* _tmp106_;
	ValaInitializerList* _tmp107_;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp116_;
	ValaDataType* _tmp117_;
	gint _tmp118_;
	ValaSourceReference* _tmp119_;
	ValaSourceReference* _tmp120_;
	ValaArrayType* _tmp121_;
	ValaArrayType* _tmp122_;
	ValaDataType* _tmp123_;
	ValaDataType* _tmp124_;
	ValaDataType* _tmp137_;
	ValaDataType* _tmp138_;
	ValaDataType* _tmp139_;
	ValaDataType* _tmp140_;
	gboolean _tmp141_;
	gboolean _tmp142_;
	self = (ValaArrayCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_array_creation_expression_get_sizes (self);
	sizes = _tmp4_;
	_tmp5_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _vala_code_node_ref0 (_tmp6_);
	initlist = _tmp7_;
	_tmp8_ = vala_array_creation_expression_get_element_type (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp10_ = vala_array_creation_expression_get_element_type (self);
		_tmp11_ = _tmp10_;
		vala_code_node_check ((ValaCodeNode*) _tmp11_, context);
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		gint _e_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _e_index = 0;
		_tmp12_ = sizes;
		_tmp13_ = _vala_iterable_ref0 (_tmp12_);
		_e_list = _tmp13_;
		_tmp14_ = _e_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_e_size = _tmp16_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			ValaExpression* e = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			ValaExpression* _tmp22_;
			_e_index = _e_index + 1;
			_tmp17_ = _e_index;
			_tmp18_ = _e_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _e_list;
			_tmp20_ = _e_index;
			_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
			e = (ValaExpression*) _tmp21_;
			_tmp22_ = e;
			vala_code_node_check ((ValaCodeNode*) _tmp22_, context);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp23_ = g_direct_equal;
	_tmp24_ = vala_array_list_new (VALA_TYPE_LITERAL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp23_);
	calc_sizes = _tmp24_;
	_tmp25_ = initlist;
	if (_tmp25_ != NULL) {
		ValaInitializerList* _tmp26_;
		ValaDataType* _tmp27_;
		ValaDataType* _tmp28_;
		gint _tmp29_;
		ValaSourceReference* _tmp30_;
		ValaSourceReference* _tmp31_;
		ValaArrayType* _tmp32_;
		ValaArrayType* _tmp33_;
		ValaInitializerList* _tmp34_;
		gint ret = 0;
		ValaInitializerList* _tmp35_;
		gint _tmp36_;
		ValaArrayList* _tmp37_;
		gint _tmp38_;
		ValaArrayList* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		_tmp26_ = initlist;
		_tmp27_ = vala_array_creation_expression_get_element_type (self);
		_tmp28_ = _tmp27_;
		_tmp29_ = self->priv->_rank;
		_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_array_type_new (_tmp28_, _tmp29_, _tmp31_);
		_tmp33_ = _tmp32_;
		vala_expression_set_target_type ((ValaExpression*) _tmp26_, (ValaDataType*) _tmp33_);
		_vala_code_node_unref0 (_tmp33_);
		_tmp34_ = initlist;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp34_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
		_tmp35_ = initlist;
		_tmp36_ = self->priv->_rank;
		_tmp37_ = calc_sizes;
		ret = vala_array_creation_expression_create_sizes_from_initializer_list (self, context, _tmp35_, _tmp36_, (ValaList*) _tmp37_);
		_tmp38_ = ret;
		if (_tmp38_ == -1) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
		_tmp39_ = calc_sizes;
		_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = self->priv->_rank;
		if (_tmp41_ != _tmp42_) {
			ValaArrayType* actual_type = NULL;
			ValaDataType* _tmp43_;
			ValaDataType* _tmp44_;
			ValaArrayList* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			ValaSourceReference* _tmp48_;
			ValaSourceReference* _tmp49_;
			ValaArrayType* _tmp50_;
			ValaInitializerList* _tmp51_;
			ValaSourceReference* _tmp52_;
			ValaSourceReference* _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			ValaArrayType* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp43_ = vala_array_creation_expression_get_element_type (self);
			_tmp44_ = _tmp43_;
			_tmp45_ = calc_sizes;
			_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_array_type_new (_tmp44_, _tmp47_, _tmp49_);
			actual_type = _tmp50_;
			_tmp51_ = initlist;
			_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_code_node_to_string ((ValaCodeNode*) _tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = actual_type;
			_tmp59_ = vala_code_node_to_string ((ValaCodeNode*) _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = g_strdup_printf ("Expected initializer for `%s' but got `%s'", _tmp57_, _tmp60_);
			_tmp62_ = _tmp61_;
			vala_report_error (_tmp53_, _tmp62_);
			_g_free0 (_tmp62_);
			_g_free0 (_tmp60_);
			_g_free0 (_tmp57_);
			_vala_code_node_unref0 (actual_type);
		}
	}
	_tmp63_ = sizes;
	_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
	_tmp65_ = _tmp64_;
	if (_tmp65_ > 0) {
		{
			ValaList* _e_list = NULL;
			ValaList* _tmp66_;
			ValaList* _tmp67_;
			gint _e_size = 0;
			ValaList* _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			gint _e_index = 0;
			_tmp66_ = sizes;
			_tmp67_ = _vala_iterable_ref0 (_tmp66_);
			_e_list = _tmp67_;
			_tmp68_ = _e_list;
			_tmp69_ = vala_collection_get_size ((ValaCollection*) _tmp68_);
			_tmp70_ = _tmp69_;
			_e_size = _tmp70_;
			_e_index = -1;
			while (TRUE) {
				gint _tmp71_;
				gint _tmp72_;
				ValaExpression* e = NULL;
				ValaList* _tmp73_;
				gint _tmp74_;
				gpointer _tmp75_;
				ValaExpression* _tmp76_;
				ValaDataType* _tmp77_;
				ValaDataType* _tmp78_;
				_e_index = _e_index + 1;
				_tmp71_ = _e_index;
				_tmp72_ = _e_size;
				if (!(_tmp71_ < _tmp72_)) {
					break;
				}
				_tmp73_ = _e_list;
				_tmp74_ = _e_index;
				_tmp75_ = vala_list_get (_tmp73_, _tmp74_);
				e = (ValaExpression*) _tmp75_;
				_tmp76_ = e;
				_tmp77_ = vala_expression_get_value_type (_tmp76_);
				_tmp78_ = _tmp77_;
				if (_tmp78_ == NULL) {
					result = FALSE;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					_vala_iterable_unref0 (calc_sizes);
					_vala_code_node_unref0 (initlist);
					_vala_iterable_unref0 (sizes);
					return result;
				} else {
					gboolean _tmp79_ = FALSE;
					ValaExpression* _tmp80_;
					ValaDataType* _tmp81_;
					ValaDataType* _tmp82_;
					_tmp80_ = e;
					_tmp81_ = vala_expression_get_value_type (_tmp80_);
					_tmp82_ = _tmp81_;
					if (VALA_IS_INTEGER_TYPE (_tmp82_)) {
						_tmp79_ = TRUE;
					} else {
						ValaExpression* _tmp83_;
						ValaDataType* _tmp84_;
						ValaDataType* _tmp85_;
						_tmp83_ = e;
						_tmp84_ = vala_expression_get_value_type (_tmp83_);
						_tmp85_ = _tmp84_;
						_tmp79_ = VALA_IS_ENUM_VALUE_TYPE (_tmp85_);
					}
					if (!_tmp79_) {
						ValaExpression* _tmp86_;
						ValaSourceReference* _tmp87_;
						ValaSourceReference* _tmp88_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp86_ = e;
						_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp86_);
						_tmp88_ = _tmp87_;
						vala_report_error (_tmp88_, "Expression of integer type expected");
					}
				}
				_vala_code_node_unref0 (e);
			}
			_vala_iterable_unref0 (_e_list);
		}
	} else {
		ValaInitializerList* _tmp89_;
		_tmp89_ = initlist;
		if (_tmp89_ == NULL) {
			ValaSourceReference* _tmp90_;
			ValaSourceReference* _tmp91_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp90_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp91_ = _tmp90_;
			vala_report_error (_tmp91_, "internal error: initializer list expected");
		} else {
			{
				ValaArrayList* _size_list = NULL;
				ValaArrayList* _tmp92_;
				ValaArrayList* _tmp93_;
				gint _size_size = 0;
				ValaArrayList* _tmp94_;
				gint _tmp95_;
				gint _tmp96_;
				gint _size_index = 0;
				_tmp92_ = calc_sizes;
				_tmp93_ = _vala_iterable_ref0 (_tmp92_);
				_size_list = _tmp93_;
				_tmp94_ = _size_list;
				_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
				_tmp96_ = _tmp95_;
				_size_size = _tmp96_;
				_size_index = -1;
				while (TRUE) {
					gint _tmp97_;
					gint _tmp98_;
					ValaExpression* size = NULL;
					ValaArrayList* _tmp99_;
					gint _tmp100_;
					gpointer _tmp101_;
					ValaExpression* _tmp102_;
					_size_index = _size_index + 1;
					_tmp97_ = _size_index;
					_tmp98_ = _size_size;
					if (!(_tmp97_ < _tmp98_)) {
						break;
					}
					_tmp99_ = _size_list;
					_tmp100_ = _size_index;
					_tmp101_ = vala_list_get ((ValaList*) _tmp99_, _tmp100_);
					size = (ValaExpression*) ((ValaLiteral*) _tmp101_);
					_tmp102_ = size;
					vala_array_creation_expression_append_size (self, _tmp102_);
					_vala_code_node_unref0 (size);
				}
				_vala_iterable_unref0 (_size_list);
			}
		}
	}
	_tmp103_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp104_ = _tmp103_;
	if (_tmp104_) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp106_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp107_ = _tmp106_;
	if (_tmp107_ != NULL) {
		ValaInitializerList* _tmp108_;
		ValaInitializerList* _tmp109_;
		ValaDataType* _tmp110_;
		ValaDataType* _tmp111_;
		_tmp108_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp109_ = _tmp108_;
		_tmp110_ = vala_expression_get_value_type ((ValaExpression*) _tmp109_);
		_tmp111_ = _tmp110_;
		_tmp105_ = _tmp111_ == NULL;
	} else {
		_tmp105_ = FALSE;
	}
	if (_tmp105_) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp112_ = vala_array_creation_expression_get_element_type (self);
	_tmp113_ = _tmp112_;
	if (_tmp113_ == NULL) {
		ValaSourceReference* _tmp114_;
		ValaSourceReference* _tmp115_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp114_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp115_ = _tmp114_;
		vala_report_error (_tmp115_, "Cannot determine the element type of the created array");
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp116_ = vala_array_creation_expression_get_element_type (self);
	_tmp117_ = _tmp116_;
	_tmp118_ = self->priv->_rank;
	_tmp119_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_array_type_new (_tmp117_, _tmp118_, _tmp120_);
	_tmp122_ = _tmp121_;
	vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp122_);
	_vala_code_node_unref0 (_tmp122_);
	_tmp123_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
	_tmp124_ = _tmp123_;
	if (VALA_IS_ARRAY_TYPE (_tmp124_)) {
		ValaDataType* _tmp125_;
		ValaDataType* _tmp126_;
		ValaDataType* _tmp127_;
		ValaDataType* _tmp128_;
		gboolean _tmp129_;
		gboolean _tmp130_;
		ValaDataType* _tmp131_;
		ValaDataType* _tmp132_;
		ValaDataType* _tmp133_;
		ValaDataType* _tmp134_;
		gboolean _tmp135_;
		gboolean _tmp136_;
		_tmp125_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp126_ = _tmp125_;
		_tmp127_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp128_ = _tmp127_;
		_tmp129_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp128_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		_tmp130_ = _tmp129_;
		vala_array_type_set_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp130_);
		_tmp131_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp132_ = _tmp131_;
		_tmp133_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp134_ = _tmp133_;
		_tmp135_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp134_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		_tmp136_ = _tmp135_;
		vala_array_type_set_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp136_);
	}
	_tmp137_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp138_ = _tmp137_;
	vala_data_type_set_value_owned (_tmp138_, TRUE);
	_tmp139_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp140_ = _tmp139_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp140_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp141_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp142_ = _tmp141_;
	result = !_tmp142_;
	_vala_iterable_unref0 (calc_sizes);
	_vala_code_node_unref0 (initlist);
	_vala_iterable_unref0 (sizes);
	return result;
}


static void
vala_array_creation_expression_real_emit (ValaCodeNode* base,
                                          ValaCodeGenerator* codegen)
{
	ValaArrayCreationExpression * self;
	ValaInitializerList* _tmp11_;
	ValaInitializerList* _tmp12_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _e_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = self->priv->sizes;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* e = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_e_index = _e_index + 1;
			_tmp5_ = _e_index;
			_tmp6_ = _e_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _e_list;
			_tmp8_ = _e_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			e = (ValaExpression*) _tmp9_;
			_tmp10_ = e;
			vala_code_node_emit ((ValaCodeNode*) _tmp10_, codegen);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp11_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		ValaInitializerList* _tmp13_;
		ValaInitializerList* _tmp14_;
		_tmp13_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp14_ = _tmp13_;
		vala_code_node_emit ((ValaCodeNode*) _tmp14_, codegen);
	}
	vala_code_visitor_visit_array_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_array_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                        ValaCollection* collection)
{
	ValaArrayCreationExpression * self;
	ValaInitializerList* _tmp11_;
	ValaInitializerList* _tmp12_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _e_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = self->priv->sizes;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* e = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_e_index = _e_index + 1;
			_tmp5_ = _e_index;
			_tmp6_ = _e_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _e_list;
			_tmp8_ = _e_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			e = (ValaExpression*) _tmp9_;
			_tmp10_ = e;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp11_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		ValaInitializerList* _tmp13_;
		ValaInitializerList* _tmp14_;
		_tmp13_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp14_ = _tmp13_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp14_, collection);
	}
}


ValaDataType*
vala_array_creation_expression_get_element_type (ValaArrayCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_element_type;
	result = _tmp0_;
	return result;
}


void
vala_array_creation_expression_set_element_type (ValaArrayCreationExpression* self,
                                                 ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_element_type);
	self->priv->_element_type = _tmp0_;
	_tmp1_ = self->priv->_element_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


gint
vala_array_creation_expression_get_rank (ValaArrayCreationExpression* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rank;
	result = _tmp0_;
	return result;
}


void
vala_array_creation_expression_set_rank (ValaArrayCreationExpression* self,
                                         gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_rank = value;
}


ValaInitializerList*
vala_array_creation_expression_get_initializer_list (ValaArrayCreationExpression* self)
{
	ValaInitializerList* result;
	ValaInitializerList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_initializer_list;
	result = _tmp0_;
	return result;
}


void
vala_array_creation_expression_set_initializer_list (ValaArrayCreationExpression* self,
                                                     ValaInitializerList* value)
{
	ValaInitializerList* _tmp0_;
	ValaInitializerList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_initializer_list);
	self->priv->_initializer_list = _tmp0_;
	_tmp1_ = self->priv->_initializer_list;
	if (_tmp1_ != NULL) {
		ValaInitializerList* _tmp2_;
		_tmp2_ = self->priv->_initializer_list;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


static void
vala_array_creation_expression_class_init (ValaArrayCreationExpressionClass * klass)
{
	vala_array_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_array_creation_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaArrayCreationExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_array_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_array_creation_expression_real_accept;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_array_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_array_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_array_creation_expression_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_array_creation_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_array_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_array_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_array_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_array_creation_expression_real_get_used_variables;
}


static void
vala_array_creation_expression_instance_init (ValaArrayCreationExpression * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_ARRAY_CREATION_EXPRESSION_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->sizes = (ValaList*) _tmp1_;
}


static void
vala_array_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaArrayCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression);
	_vala_iterable_unref0 (self->priv->sizes);
	_vala_code_node_unref0 (self->priv->_element_type);
	_vala_code_node_unref0 (self->priv->_initializer_list);
	VALA_CODE_NODE_CLASS (vala_array_creation_expression_parent_class)->finalize (obj);
}


/**
 * Represents an array creation expression.
 *
 * {{{ new int[] { 1, 2, 3 } }}}
 */
GType
vala_array_creation_expression_get_type (void)
{
	static volatile gsize vala_array_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_array_creation_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayCreationExpression), 0, (GInstanceInitFunc) vala_array_creation_expression_instance_init, NULL };
		GType vala_array_creation_expression_type_id;
		vala_array_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaArrayCreationExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_array_creation_expression_type_id__volatile, vala_array_creation_expression_type_id);
	}
	return vala_array_creation_expression_type_id__volatile;
}



