/* tagletlink.c generated by valac, the Vala compiler
 * generated from tagletlink.vala, do not modify */

/* taglet.vala
 *
 * Copyright (C) 2008-2009 Didier Villevalois
 * Copyright (C) 2008-2014 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */


#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

typedef enum  {
	VALADOC_TAGLETS_LINK_SYMBOL_CONTEXT_NORMAL,
	VALADOC_TAGLETS_LINK_SYMBOL_CONTEXT_FINISH,
	VALADOC_TAGLETS_LINK_SYMBOL_CONTEXT_TYPE
} ValadocTagletsLinkSymbolContext;


#define VALADOC_TAGLETS_LINK_TYPE_SYMBOL_CONTEXT (valadoc_taglets_link_symbol_context_get_type ())
enum  {
	VALADOC_TAGLETS_LINK_0_PROPERTY,
	VALADOC_TAGLETS_LINK_SYMBOL_NAME_PROPERTY,
	VALADOC_TAGLETS_LINK_C_ACCEPT_PLURAL_PROPERTY,
	VALADOC_TAGLETS_LINK_C_IS_PLURAL_PROPERTY,
	VALADOC_TAGLETS_LINK_NUM_PROPERTIES
};
static GParamSpec* valadoc_taglets_link_properties[VALADOC_TAGLETS_LINK_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ValadocTagletsLinkPrivate {
	gchar* _symbol_name;
	gboolean _c_accept_plural;
	gboolean _c_is_plural;
	ValadocTagletsLinkSymbolContext _context;
	ValadocApiNode* _symbol;
};


static gpointer valadoc_taglets_link_parent_class = NULL;

static GType valadoc_taglets_link_symbol_context_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALADOC_TAGLETS_LINK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_TAGLETS_TYPE_LINK, ValadocTagletsLinkPrivate))
static ValadocRule* valadoc_taglets_link_real_get_parser_rule (ValadocContentInlineTaglet* base,
                                                        ValadocRule* run_rule);
static void __lambda8_ (ValadocTagletsLink* self,
                 ValadocToken* token,
                 GError** error);
G_GNUC_INTERNAL void valadoc_taglets_link_set_symbol_name (ValadocTagletsLink* self,
                                           const gchar* value);
static void ___lambda8__valadoc_token_type_action (ValadocToken* token,
                                            gpointer self,
                                            GError** error);
static void __lambda9_ (ValadocTagletsLink* self,
                 ValadocToken* token,
                 GError** error);
static void ___lambda9__valadoc_token_type_action (ValadocToken* token,
                                            gpointer self,
                                            GError** error);
static void __lambda10_ (ValadocTagletsLink* self,
                  ValadocToken* token,
                  GError** error);
static void ___lambda10__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void valadoc_taglets_link_real_check (ValadocContentContentElement* base,
                                      ValadocApiTree* api_root,
                                      ValadocApiNode* container,
                                      const gchar* file_path,
                                      ValadocErrorReporter* reporter,
                                      ValadocSettings* settings);
static void valadoc_taglets_link_set_c_is_plural (ValadocTagletsLink* self,
                                           gboolean value);
static ValadocContentContentElement* valadoc_taglets_link_real_produce_content (ValadocContentInlineTaglet* base);
G_GNUC_INTERNAL ValadocContentSymbolLink* valadoc_content_symbol_link_new (ValadocApiNode* symbol,
                                                           const gchar* given_symbol_name);
G_GNUC_INTERNAL ValadocContentSymbolLink* valadoc_content_symbol_link_construct (GType object_type,
                                                                 ValadocApiNode* symbol,
                                                                 const gchar* given_symbol_name);
G_GNUC_INTERNAL ValadocContentRun* valadoc_content_run_new (ValadocContentRunStyle style);
G_GNUC_INTERNAL ValadocContentRun* valadoc_content_run_construct (GType object_type,
                                                  ValadocContentRunStyle style);
G_GNUC_INTERNAL ValadocContentText* valadoc_content_text_new (const gchar* text);
G_GNUC_INTERNAL ValadocContentText* valadoc_content_text_construct (GType object_type,
                                                    const gchar* text);
static gboolean valadoc_taglets_link_real_is_empty (ValadocContentContentElement* base);
static ValadocContentContentElement* valadoc_taglets_link_real_copy (ValadocContentContentElement* base,
                                                              ValadocContentContentElement* new_parent);
G_GNUC_INTERNAL void valadoc_content_content_element_set_parent (ValadocContentContentElement* self,
                                                 ValadocContentContentElement* value);
G_GNUC_INTERNAL void valadoc_taglets_link_set_c_accept_plural (ValadocTagletsLink* self,
                                               gboolean value);
static void valadoc_taglets_link_finalize (GObject * obj);
static void _vala_valadoc_taglets_link_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_valadoc_taglets_link_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static GType
valadoc_taglets_link_symbol_context_get_type (void)
{
	static volatile gsize valadoc_taglets_link_symbol_context_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_taglets_link_symbol_context_type_id__volatile)) {
		static const GEnumValue values[] = {{VALADOC_TAGLETS_LINK_SYMBOL_CONTEXT_NORMAL, "VALADOC_TAGLETS_LINK_SYMBOL_CONTEXT_NORMAL", "normal"}, {VALADOC_TAGLETS_LINK_SYMBOL_CONTEXT_FINISH, "VALADOC_TAGLETS_LINK_SYMBOL_CONTEXT_FINISH", "finish"}, {VALADOC_TAGLETS_LINK_SYMBOL_CONTEXT_TYPE, "VALADOC_TAGLETS_LINK_SYMBOL_CONTEXT_TYPE", "type"}, {0, NULL, NULL}};
		GType valadoc_taglets_link_symbol_context_type_id;
		valadoc_taglets_link_symbol_context_type_id = g_enum_register_static ("ValadocTagletsLinkSymbolContext", values);
		g_once_init_leave (&valadoc_taglets_link_symbol_context_type_id__volatile, valadoc_taglets_link_symbol_context_type_id);
	}
	return valadoc_taglets_link_symbol_context_type_id__volatile;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
__lambda8_ (ValadocTagletsLink* self,
            ValadocToken* token,
            GError** error)
{
	const gchar* _tmp0_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_token_to_string (token);
	valadoc_taglets_link_set_symbol_name (self, _tmp0_);
}


static void
___lambda8__valadoc_token_type_action (ValadocToken* token,
                                       gpointer self,
                                       GError** error)
{
	__lambda8_ ((ValadocTagletsLink*) self, token, error);
}


static void
__lambda9_ (ValadocTagletsLink* self,
            ValadocToken* token,
            GError** error)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (token != NULL);
	_tmp0_ = self->priv->_symbol_name;
	_tmp1_ = valadoc_token_to_string (token);
	_tmp2_ = g_strconcat (_tmp0_, _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	valadoc_taglets_link_set_symbol_name (self, _tmp3_);
	_g_free0 (_tmp3_);
}


static void
___lambda9__valadoc_token_type_action (ValadocToken* token,
                                       gpointer self,
                                       GError** error)
{
	__lambda9_ ((ValadocTagletsLink*) self, token, error);
}


static void
__lambda10_ (ValadocTagletsLink* self,
             ValadocToken* token,
             GError** error)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (token != NULL);
	_tmp0_ = self->priv->_symbol_name;
	_tmp1_ = valadoc_token_to_string (token);
	_tmp2_ = g_strconcat (_tmp0_, _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	valadoc_taglets_link_set_symbol_name (self, _tmp3_);
	_g_free0 (_tmp3_);
}


static void
___lambda10__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda10_ ((ValadocTagletsLink*) self, token, error);
}


static ValadocRule*
valadoc_taglets_link_real_get_parser_rule (ValadocContentInlineTaglet* base,
                                           ValadocRule* run_rule)
{
	ValadocTagletsLink * self;
	ValadocRule* result = NULL;
	ValadocTokenType* _tmp0_;
	GObject* _tmp1_;
	ValadocTokenType* _tmp2_;
	GObject* _tmp3_;
	GObject** _tmp4_;
	GObject** _tmp5_;
	gint _tmp5__length1;
	ValadocRule* _tmp6_;
	GObject** _tmp7_;
	GObject** _tmp8_;
	gint _tmp8__length1;
	ValadocRule* _tmp9_;
	GObject** _tmp10_;
	GObject** _tmp11_;
	gint _tmp11__length1;
	ValadocRule* _tmp12_;
	ValadocTokenType* _tmp13_;
	ValadocTokenType* _tmp14_;
	ValadocTokenType* _tmp15_;
	ValadocTokenType* _tmp16_;
	ValadocTokenType* _tmp17_;
	ValadocTokenType* _tmp18_;
	ValadocTokenType* _tmp19_;
	ValadocTokenType* _tmp20_;
	GObject** _tmp21_;
	GObject** _tmp22_;
	gint _tmp22__length1;
	ValadocRule* _tmp23_;
	GObject** _tmp24_;
	GObject** _tmp25_;
	gint _tmp25__length1;
	ValadocRule* _tmp26_;
	GObject** _tmp27_;
	GObject** _tmp28_;
	gint _tmp28__length1;
	ValadocRule* _tmp29_;
	GObject** _tmp30_;
	GObject** _tmp31_;
	gint _tmp31__length1;
	ValadocRule* _tmp32_;
	ValadocRule* _tmp33_;
	self = (ValadocTagletsLink*) base;
	g_return_val_if_fail (run_rule != NULL, NULL);
	_tmp0_ = valadoc_token_type_SPACE;
	_tmp1_ = _g_object_ref0 ((GObject*) _tmp0_);
	_tmp2_ = valadoc_token_type_EOL;
	_tmp3_ = _g_object_ref0 ((GObject*) _tmp2_);
	_tmp4_ = g_new0 (GObject*, 2 + 1);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 2;
	_tmp6_ = valadoc_rule_one_of (_tmp5_, 2);
	_tmp7_ = g_new0 (GObject*, 1 + 1);
	_tmp7_[0] = (GObject*) _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	_tmp9_ = valadoc_rule_many (_tmp8_, 1);
	_tmp10_ = g_new0 (GObject*, 1 + 1);
	_tmp10_[0] = (GObject*) _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	_tmp12_ = valadoc_rule_option (_tmp11_, 1);
	_tmp13_ = valadoc_token_type_any_word ();
	_tmp14_ = _tmp13_;
	_tmp15_ = valadoc_token_type_action (_tmp14_, ___lambda8__valadoc_token_type_action, self);
	_tmp16_ = valadoc_token_type_any_word ();
	_tmp17_ = _tmp16_;
	_tmp18_ = valadoc_token_type_action (_tmp17_, ___lambda9__valadoc_token_type_action, self);
	_tmp19_ = valadoc_token_type_MINUS;
	_tmp20_ = valadoc_token_type_action (_tmp19_, ___lambda10__valadoc_token_type_action, self);
	_tmp21_ = g_new0 (GObject*, 2 + 1);
	_tmp21_[0] = (GObject*) _tmp18_;
	_tmp21_[1] = (GObject*) _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 2;
	_tmp23_ = valadoc_rule_one_of (_tmp22_, 2);
	_tmp24_ = g_new0 (GObject*, 1 + 1);
	_tmp24_[0] = (GObject*) _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = 1;
	_tmp26_ = valadoc_rule_many (_tmp25_, 1);
	_tmp27_ = g_new0 (GObject*, 1 + 1);
	_tmp27_[0] = (GObject*) _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 1;
	_tmp29_ = valadoc_rule_option (_tmp28_, 1);
	_tmp30_ = g_new0 (GObject*, 3 + 1);
	_tmp30_[0] = (GObject*) _tmp12_;
	_tmp30_[1] = (GObject*) _tmp15_;
	_tmp30_[2] = (GObject*) _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp31__length1 = 3;
	_tmp32_ = valadoc_rule_seq (_tmp31_, 3);
	_tmp33_ = _tmp32_;
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp17_);
	_g_object_unref0 (_tmp14_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_object_unref), NULL);
	result = _tmp33_;
	return result;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static void
valadoc_taglets_link_real_check (ValadocContentContentElement* base,
                                 ValadocApiTree* api_root,
                                 ValadocApiNode* container,
                                 const gchar* file_path,
                                 ValadocErrorReporter* reporter,
                                 ValadocSettings* settings)
{
	ValadocTagletsLink * self;
	const gchar* _tmp0_;
	gboolean _tmp61_ = FALSE;
	ValadocApiNode* _tmp62_;
	self = (ValadocTagletsLink*) base;
	g_return_if_fail (api_root != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (file_path != NULL);
	g_return_if_fail (reporter != NULL);
	g_return_if_fail (settings != NULL);
	_tmp0_ = self->priv->_symbol_name;
	if (g_str_has_prefix (_tmp0_, "c::")) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		gchar* singular_symbol_name = NULL;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		ValadocApiNode* _tmp14_;
		gboolean _tmp15_ = FALSE;
		ValadocApiNode* _tmp16_;
		gboolean _tmp20_ = FALSE;
		ValadocApiNode* _tmp21_;
		ValadocApiNode* _tmp46_;
		ValadocApiNode* _tmp55_;
		_tmp1_ = self->priv->_symbol_name;
		_tmp2_ = string_substring (_tmp1_, (glong) 3, (glong) -1);
		_g_free0 (self->priv->_symbol_name);
		self->priv->_symbol_name = _tmp2_;
		_tmp5_ = self->priv->_c_accept_plural;
		if (_tmp5_) {
			const gchar* _tmp6_;
			_tmp6_ = self->priv->_symbol_name;
			_tmp4_ = g_str_has_suffix (_tmp6_, "s");
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gchar* _tmp11_;
			_tmp7_ = self->priv->_symbol_name;
			_tmp8_ = self->priv->_symbol_name;
			_tmp9_ = strlen (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = string_substring (_tmp7_, (glong) 0, (glong) (_tmp10_ - 1));
			_g_free0 (_tmp3_);
			_tmp3_ = _tmp11_;
		} else {
			_g_free0 (_tmp3_);
			_tmp3_ = NULL;
		}
		_tmp12_ = g_strdup (_tmp3_);
		singular_symbol_name = _tmp12_;
		_tmp13_ = self->priv->_symbol_name;
		_tmp14_ = valadoc_api_tree_search_symbol_cstr (api_root, container, _tmp13_);
		_g_object_unref0 (self->priv->_symbol);
		self->priv->_symbol = _tmp14_;
		_tmp16_ = self->priv->_symbol;
		if (_tmp16_ == NULL) {
			const gchar* _tmp17_;
			_tmp17_ = singular_symbol_name;
			_tmp15_ = _tmp17_ != NULL;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			const gchar* _tmp18_;
			ValadocApiNode* _tmp19_;
			_tmp18_ = singular_symbol_name;
			_tmp19_ = valadoc_api_tree_search_symbol_cstr (api_root, container, _tmp18_);
			_g_object_unref0 (self->priv->_symbol);
			self->priv->_symbol = _tmp19_;
			valadoc_taglets_link_set_c_is_plural (self, TRUE);
		}
		self->priv->_context = VALADOC_TAGLETS_LINK_SYMBOL_CONTEXT_NORMAL;
		_tmp21_ = self->priv->_symbol;
		if (_tmp21_ == NULL) {
			const gchar* _tmp22_;
			_tmp22_ = self->priv->_symbol_name;
			_tmp20_ = g_str_has_suffix (_tmp22_, "_finish");
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			gchar* tmp = NULL;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gchar* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValadocApiNode* _tmp31_;
			ValadocApiMethod* _tmp32_;
			gboolean _tmp33_ = FALSE;
			ValadocApiNode* _tmp34_;
			_tmp23_ = self->priv->_symbol_name;
			_tmp24_ = self->priv->_symbol_name;
			_tmp25_ = strlen (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = string_substring (_tmp23_, (glong) 0, (glong) (_tmp26_ - 7));
			tmp = _tmp27_;
			_tmp28_ = tmp;
			_tmp29_ = g_strconcat (_tmp28_, "_async", NULL);
			_tmp30_ = _tmp29_;
			_tmp31_ = valadoc_api_tree_search_symbol_cstr (api_root, container, _tmp30_);
			_tmp32_ = VALADOC_API_IS_METHOD (_tmp31_) ? ((ValadocApiMethod*) _tmp31_) : NULL;
			if (_tmp32_ == NULL) {
				_g_object_unref0 (_tmp31_);
			}
			_g_object_unref0 (self->priv->_symbol);
			self->priv->_symbol = (ValadocApiNode*) _tmp32_;
			_g_free0 (_tmp30_);
			_tmp34_ = self->priv->_symbol;
			if (_tmp34_ != NULL) {
				ValadocApiNode* _tmp35_;
				gboolean _tmp36_;
				gboolean _tmp37_;
				_tmp35_ = self->priv->_symbol;
				_tmp36_ = valadoc_api_method_get_is_yields (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
				_tmp37_ = _tmp36_;
				_tmp33_ = _tmp37_;
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				self->priv->_context = VALADOC_TAGLETS_LINK_SYMBOL_CONTEXT_FINISH;
			} else {
				const gchar* _tmp38_;
				ValadocApiNode* _tmp39_;
				ValadocApiMethod* _tmp40_;
				gboolean _tmp41_ = FALSE;
				ValadocApiNode* _tmp42_;
				_tmp38_ = tmp;
				_tmp39_ = valadoc_api_tree_search_symbol_cstr (api_root, container, _tmp38_);
				_tmp40_ = VALADOC_API_IS_METHOD (_tmp39_) ? ((ValadocApiMethod*) _tmp39_) : NULL;
				if (_tmp40_ == NULL) {
					_g_object_unref0 (_tmp39_);
				}
				_g_object_unref0 (self->priv->_symbol);
				self->priv->_symbol = (ValadocApiNode*) _tmp40_;
				_tmp42_ = self->priv->_symbol;
				if (_tmp42_ != NULL) {
					ValadocApiNode* _tmp43_;
					gboolean _tmp44_;
					gboolean _tmp45_;
					_tmp43_ = self->priv->_symbol;
					_tmp44_ = valadoc_api_method_get_is_yields (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
					_tmp45_ = _tmp44_;
					_tmp41_ = _tmp45_;
				} else {
					_tmp41_ = FALSE;
				}
				if (_tmp41_) {
					self->priv->_context = VALADOC_TAGLETS_LINK_SYMBOL_CONTEXT_FINISH;
				} else {
					_g_object_unref0 (self->priv->_symbol);
					self->priv->_symbol = NULL;
				}
			}
			_g_free0 (tmp);
		}
		_tmp46_ = self->priv->_symbol;
		if (_tmp46_ == NULL) {
			const gchar* _tmp47_;
			ValadocApiTypeSymbol* _tmp48_;
			gboolean _tmp49_ = FALSE;
			ValadocApiNode* _tmp50_;
			ValadocApiNode* _tmp54_;
			_tmp47_ = self->priv->_symbol_name;
			_tmp48_ = valadoc_api_tree_search_symbol_type_cstr (api_root, _tmp47_);
			_g_object_unref0 (self->priv->_symbol);
			self->priv->_symbol = (ValadocApiNode*) _tmp48_;
			_tmp50_ = self->priv->_symbol;
			if (_tmp50_ == NULL) {
				const gchar* _tmp51_;
				_tmp51_ = singular_symbol_name;
				_tmp49_ = _tmp51_ != NULL;
			} else {
				_tmp49_ = FALSE;
			}
			if (_tmp49_) {
				const gchar* _tmp52_;
				ValadocApiTypeSymbol* _tmp53_;
				_tmp52_ = singular_symbol_name;
				_tmp53_ = valadoc_api_tree_search_symbol_type_cstr (api_root, _tmp52_);
				_g_object_unref0 (self->priv->_symbol);
				self->priv->_symbol = (ValadocApiNode*) _tmp53_;
				valadoc_taglets_link_set_c_is_plural (self, TRUE);
			}
			_tmp54_ = self->priv->_symbol;
			if (_tmp54_ != NULL) {
				self->priv->_context = VALADOC_TAGLETS_LINK_SYMBOL_CONTEXT_TYPE;
			}
		}
		_tmp55_ = self->priv->_symbol;
		if (_tmp55_ != NULL) {
			ValadocApiNode* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			_tmp56_ = self->priv->_symbol;
			_tmp57_ = valadoc_api_node_get_name (_tmp56_);
			_tmp58_ = _tmp57_;
			valadoc_taglets_link_set_symbol_name (self, _tmp58_);
		}
		_g_free0 (singular_symbol_name);
		_g_free0 (_tmp3_);
	} else {
		const gchar* _tmp59_;
		ValadocApiNode* _tmp60_;
		_tmp59_ = self->priv->_symbol_name;
		_tmp60_ = valadoc_api_tree_search_symbol_str (api_root, container, _tmp59_);
		_g_object_unref0 (self->priv->_symbol);
		self->priv->_symbol = _tmp60_;
	}
	_tmp62_ = self->priv->_symbol;
	if (_tmp62_ == NULL) {
		const gchar* _tmp63_;
		_tmp63_ = self->priv->_symbol_name;
		_tmp61_ = g_strcmp0 (_tmp63_, "main") != 0;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		gchar* _tmp64_ = NULL;
		gchar* node_segment = NULL;
		gchar* _tmp69_;
		const gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		const gchar* _tmp73_;
		if (VALADOC_API_IS_PACKAGE (container)) {
			gchar* _tmp65_;
			_tmp65_ = g_strdup ("");
			_g_free0 (_tmp64_);
			_tmp64_ = _tmp65_;
		} else {
			gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			_tmp66_ = valadoc_api_node_get_full_name (container);
			_tmp67_ = _tmp66_;
			_tmp68_ = g_strconcat (_tmp67_, ": ", NULL);
			_g_free0 (_tmp64_);
			_tmp64_ = _tmp68_;
			_g_free0 (_tmp67_);
		}
		_tmp69_ = g_strdup (_tmp64_);
		node_segment = _tmp69_;
		_tmp70_ = node_segment;
		_tmp71_ = g_strdup_printf ("%s: %s@link", file_path, _tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = self->priv->_symbol_name;
		valadoc_error_reporter_simple_warning (reporter, _tmp72_, "`%s' does not exist", _tmp73_);
		_g_free0 (_tmp72_);
		_g_free0 (node_segment);
		_g_free0 (_tmp64_);
	}
	VALADOC_CONTENT_CONTENT_ELEMENT_CLASS (valadoc_taglets_link_parent_class)->check ((ValadocContentContentElement*) G_TYPE_CHECK_INSTANCE_CAST (self, VALADOC_CONTENT_TYPE_INLINE_TAGLET, ValadocContentInlineTaglet), api_root, container, file_path, reporter, settings);
}


static ValadocContentContentElement*
valadoc_taglets_link_real_produce_content (ValadocContentInlineTaglet* base)
{
	ValadocTagletsLink * self;
	ValadocContentContentElement* result = NULL;
	ValadocContentSymbolLink* link = NULL;
	ValadocContentSymbolLink* _tmp0_;
	ValadocContentSymbolLink* _tmp1_;
	ValadocApiNode* _tmp2_;
	ValadocContentSymbolLink* _tmp3_;
	const gchar* _tmp4_;
	ValadocContentInline* content = NULL;
	ValadocTagletsLinkSymbolContext _tmp5_;
	gboolean _tmp43_;
	self = (ValadocTagletsLink*) base;
	_tmp0_ = valadoc_content_symbol_link_new (NULL, NULL);
	link = _tmp0_;
	_tmp1_ = link;
	_tmp2_ = self->priv->_symbol;
	valadoc_content_symbol_link_set_symbol (_tmp1_, _tmp2_);
	_tmp3_ = link;
	_tmp4_ = self->priv->_symbol_name;
	valadoc_content_symbol_link_set_given_symbol_name (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->_context;
	switch (_tmp5_) {
		case VALADOC_TAGLETS_LINK_SYMBOL_CONTEXT_FINISH:
		{
			ValadocContentSymbolLink* _tmp6_;
			ValadocContentSymbolLink* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			ValadocContentSymbolLink* _tmp12_;
			ValadocContentInline* _tmp13_;
			_tmp6_ = link;
			_tmp7_ = link;
			_tmp8_ = valadoc_content_symbol_link_get_given_symbol_name (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strconcat (_tmp9_, ".end", NULL);
			_tmp11_ = _tmp10_;
			valadoc_content_symbol_link_set_given_symbol_name (_tmp7_, _tmp11_);
			_g_free0 (_tmp11_);
			_tmp12_ = link;
			_tmp13_ = _g_object_ref0 ((ValadocContentInline*) _tmp12_);
			_g_object_unref0 (content);
			content = _tmp13_;
			break;
		}
		case VALADOC_TAGLETS_LINK_SYMBOL_CONTEXT_TYPE:
		{
			ValadocContentRun* run = NULL;
			ValadocContentRun* _tmp14_;
			ValadocContentRun* _tmp15_;
			ValadocContentInline* _tmp16_;
			ValadocContentRun* keyword = NULL;
			ValadocContentRun* _tmp17_;
			ValadocContentRun* _tmp18_;
			ValaList* _tmp19_;
			ValaList* _tmp20_;
			ValadocContentText* _tmp21_;
			ValadocContentText* _tmp22_;
			ValadocContentRun* _tmp23_;
			ValaList* _tmp24_;
			ValaList* _tmp25_;
			ValadocContentRun* _tmp26_;
			ValadocContentRun* _tmp27_;
			ValaList* _tmp28_;
			ValaList* _tmp29_;
			ValadocContentText* _tmp30_;
			ValadocContentText* _tmp31_;
			ValadocContentRun* _tmp32_;
			ValaList* _tmp33_;
			ValaList* _tmp34_;
			ValadocContentSymbolLink* _tmp35_;
			ValadocContentRun* _tmp36_;
			ValaList* _tmp37_;
			ValaList* _tmp38_;
			ValadocContentText* _tmp39_;
			ValadocContentText* _tmp40_;
			_tmp14_ = valadoc_content_run_new (VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
			run = _tmp14_;
			_tmp15_ = run;
			_tmp16_ = _g_object_ref0 ((ValadocContentInline*) _tmp15_);
			_g_object_unref0 (content);
			content = _tmp16_;
			_tmp17_ = valadoc_content_run_new (VALADOC_CONTENT_RUN_STYLE_LANG_KEYWORD);
			keyword = _tmp17_;
			_tmp18_ = keyword;
			_tmp19_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = valadoc_content_text_new ("typeof");
			_tmp22_ = _tmp21_;
			vala_collection_add ((ValaCollection*) _tmp20_, (ValadocContentInline*) _tmp22_);
			_g_object_unref0 (_tmp22_);
			_tmp23_ = run;
			_tmp24_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = keyword;
			vala_collection_add ((ValaCollection*) _tmp25_, (ValadocContentInline*) _tmp26_);
			_tmp27_ = run;
			_tmp28_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = valadoc_content_text_new (" (");
			_tmp31_ = _tmp30_;
			vala_collection_add ((ValaCollection*) _tmp29_, (ValadocContentInline*) _tmp31_);
			_g_object_unref0 (_tmp31_);
			_tmp32_ = run;
			_tmp33_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = link;
			vala_collection_add ((ValaCollection*) _tmp34_, (ValadocContentInline*) _tmp35_);
			_tmp36_ = run;
			_tmp37_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = valadoc_content_text_new (")");
			_tmp40_ = _tmp39_;
			vala_collection_add ((ValaCollection*) _tmp38_, (ValadocContentInline*) _tmp40_);
			_g_object_unref0 (_tmp40_);
			_g_object_unref0 (keyword);
			_g_object_unref0 (run);
			break;
		}
		default:
		{
			ValadocContentSymbolLink* _tmp41_;
			ValadocContentInline* _tmp42_;
			_tmp41_ = link;
			_tmp42_ = _g_object_ref0 ((ValadocContentInline*) _tmp41_);
			_g_object_unref0 (content);
			content = _tmp42_;
			break;
		}
	}
	_tmp43_ = self->priv->_c_is_plural;
	if (_tmp43_ == TRUE) {
		ValadocContentRun* run = NULL;
		ValadocContentRun* _tmp44_;
		ValadocContentRun* _tmp45_;
		ValaList* _tmp46_;
		ValaList* _tmp47_;
		ValadocContentInline* _tmp48_;
		ValadocContentRun* _tmp49_;
		ValaList* _tmp50_;
		ValaList* _tmp51_;
		ValadocContentText* _tmp52_;
		ValadocContentText* _tmp53_;
		_tmp44_ = valadoc_content_run_new (VALADOC_CONTENT_RUN_STYLE_NONE);
		run = _tmp44_;
		_tmp45_ = run;
		_tmp46_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = content;
		vala_collection_add ((ValaCollection*) _tmp47_, _tmp48_);
		_tmp49_ = run;
		_tmp50_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = valadoc_content_text_new ("s");
		_tmp53_ = _tmp52_;
		vala_collection_add ((ValaCollection*) _tmp51_, (ValadocContentInline*) _tmp53_);
		_g_object_unref0 (_tmp53_);
		result = (ValadocContentContentElement*) run;
		_g_object_unref0 (content);
		_g_object_unref0 (link);
		return result;
	}
	result = (ValadocContentContentElement*) content;
	_g_object_unref0 (link);
	return result;
}


static gboolean
valadoc_taglets_link_real_is_empty (ValadocContentContentElement* base)
{
	ValadocTagletsLink * self;
	gboolean result = FALSE;
	self = (ValadocTagletsLink*) base;
	result = FALSE;
	return result;
}


static ValadocContentContentElement*
valadoc_taglets_link_real_copy (ValadocContentContentElement* base,
                                ValadocContentContentElement* new_parent)
{
	ValadocTagletsLink * self;
	ValadocContentContentElement* result = NULL;
	ValadocTagletsLink* link = NULL;
	ValadocTagletsLink* _tmp0_;
	ValadocSettings* _tmp1_;
	ValadocSettings* _tmp2_;
	ValadocResourceLocator* _tmp3_;
	ValadocResourceLocator* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	ValadocTagletsLinkSymbolContext _tmp8_;
	ValadocApiNode* _tmp9_;
	ValadocApiNode* _tmp10_;
	self = (ValadocTagletsLink*) base;
	_tmp0_ = valadoc_taglets_link_new ();
	link = _tmp0_;
	valadoc_content_content_element_set_parent ((ValadocContentContentElement*) link, new_parent);
	_tmp1_ = ((ValadocContentInlineTaglet*) self)->settings;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (((ValadocContentInlineTaglet*) link)->settings);
	((ValadocContentInlineTaglet*) link)->settings = _tmp2_;
	_tmp3_ = ((ValadocContentInlineTaglet*) self)->locator;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (((ValadocContentInlineTaglet*) link)->locator);
	((ValadocContentInlineTaglet*) link)->locator = _tmp4_;
	_tmp5_ = self->priv->_symbol_name;
	valadoc_taglets_link_set_symbol_name (link, _tmp5_);
	_tmp6_ = self->priv->_c_accept_plural;
	valadoc_taglets_link_set_c_accept_plural (link, _tmp6_);
	_tmp7_ = self->priv->_c_is_plural;
	valadoc_taglets_link_set_c_is_plural (link, _tmp7_);
	_tmp8_ = self->priv->_context;
	link->priv->_context = _tmp8_;
	_tmp9_ = self->priv->_symbol;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (link->priv->_symbol);
	link->priv->_symbol = _tmp10_;
	result = (ValadocContentContentElement*) link;
	return result;
}


ValadocTagletsLink*
valadoc_taglets_link_construct (GType object_type)
{
	ValadocTagletsLink * self = NULL;
	self = (ValadocTagletsLink*) valadoc_content_inline_taglet_construct (object_type);
	return self;
}


ValadocTagletsLink*
valadoc_taglets_link_new (void)
{
	return valadoc_taglets_link_construct (VALADOC_TAGLETS_TYPE_LINK);
}


const gchar*
valadoc_taglets_link_get_symbol_name (ValadocTagletsLink* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_symbol_name;
	result = _tmp0_;
	return result;
}


G_GNUC_INTERNAL void
valadoc_taglets_link_set_symbol_name (ValadocTagletsLink* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = valadoc_taglets_link_get_symbol_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_symbol_name);
		self->priv->_symbol_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_taglets_link_properties[VALADOC_TAGLETS_LINK_SYMBOL_NAME_PROPERTY]);
	}
}


gboolean
valadoc_taglets_link_get_c_accept_plural (ValadocTagletsLink* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_c_accept_plural;
	result = _tmp0_;
	return result;
}


G_GNUC_INTERNAL void
valadoc_taglets_link_set_c_accept_plural (ValadocTagletsLink* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = valadoc_taglets_link_get_c_accept_plural (self);
	if (old_value != value) {
		self->priv->_c_accept_plural = value;
		g_object_notify_by_pspec ((GObject *) self, valadoc_taglets_link_properties[VALADOC_TAGLETS_LINK_C_ACCEPT_PLURAL_PROPERTY]);
	}
}


gboolean
valadoc_taglets_link_get_c_is_plural (ValadocTagletsLink* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_c_is_plural;
	result = _tmp0_;
	return result;
}


static void
valadoc_taglets_link_set_c_is_plural (ValadocTagletsLink* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = valadoc_taglets_link_get_c_is_plural (self);
	if (old_value != value) {
		self->priv->_c_is_plural = value;
		g_object_notify_by_pspec ((GObject *) self, valadoc_taglets_link_properties[VALADOC_TAGLETS_LINK_C_IS_PLURAL_PROPERTY]);
	}
}


static void
valadoc_taglets_link_class_init (ValadocTagletsLinkClass * klass)
{
	valadoc_taglets_link_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocTagletsLinkPrivate));
	((ValadocContentInlineTagletClass *) klass)->get_parser_rule = (ValadocRule* (*) (ValadocContentInlineTaglet*, ValadocRule*)) valadoc_taglets_link_real_get_parser_rule;
	((ValadocContentContentElementClass *) klass)->check = (void (*) (ValadocContentContentElement*, ValadocApiTree*, ValadocApiNode*, const gchar*, ValadocErrorReporter*, ValadocSettings*)) valadoc_taglets_link_real_check;
	((ValadocContentInlineTagletClass *) klass)->produce_content = (ValadocContentContentElement* (*) (ValadocContentInlineTaglet*)) valadoc_taglets_link_real_produce_content;
	((ValadocContentContentElementClass *) klass)->is_empty = (gboolean (*) (ValadocContentContentElement*)) valadoc_taglets_link_real_is_empty;
	((ValadocContentContentElementClass *) klass)->copy = (ValadocContentContentElement* (*) (ValadocContentContentElement*, ValadocContentContentElement*)) valadoc_taglets_link_real_copy;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_taglets_link_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_taglets_link_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_taglets_link_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_TAGLETS_LINK_SYMBOL_NAME_PROPERTY, valadoc_taglets_link_properties[VALADOC_TAGLETS_LINK_SYMBOL_NAME_PROPERTY] = g_param_spec_string ("symbol-name", "symbol-name", "symbol-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Accept leading 's', e.g. #Widgets
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_TAGLETS_LINK_C_ACCEPT_PLURAL_PROPERTY, valadoc_taglets_link_properties[VALADOC_TAGLETS_LINK_C_ACCEPT_PLURAL_PROPERTY] = g_param_spec_boolean ("c-accept-plural", "c-accept-plural", "c-accept-plural", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * True if symbol_name could only be resolved after removing 's'
	 *
	 * E.g. true or #Widgets, false for #Widget
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_TAGLETS_LINK_C_IS_PLURAL_PROPERTY, valadoc_taglets_link_properties[VALADOC_TAGLETS_LINK_C_IS_PLURAL_PROPERTY] = g_param_spec_boolean ("c-is-plural", "c-is-plural", "c-is-plural", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}


static void
valadoc_taglets_link_instance_init (ValadocTagletsLink * self)
{
	self->priv = VALADOC_TAGLETS_LINK_GET_PRIVATE (self);
	self->priv->_context = VALADOC_TAGLETS_LINK_SYMBOL_CONTEXT_NORMAL;
}


static void
valadoc_taglets_link_finalize (GObject * obj)
{
	ValadocTagletsLink * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TAGLETS_TYPE_LINK, ValadocTagletsLink);
	_g_free0 (self->priv->_symbol_name);
	_g_object_unref0 (self->priv->_symbol);
	G_OBJECT_CLASS (valadoc_taglets_link_parent_class)->finalize (obj);
}


GType
valadoc_taglets_link_get_type (void)
{
	static volatile gsize valadoc_taglets_link_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_taglets_link_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocTagletsLinkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_taglets_link_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocTagletsLink), 0, (GInstanceInitFunc) valadoc_taglets_link_instance_init, NULL };
		GType valadoc_taglets_link_type_id;
		valadoc_taglets_link_type_id = g_type_register_static (VALADOC_CONTENT_TYPE_INLINE_TAGLET, "ValadocTagletsLink", &g_define_type_info, 0);
		g_once_init_leave (&valadoc_taglets_link_type_id__volatile, valadoc_taglets_link_type_id);
	}
	return valadoc_taglets_link_type_id__volatile;
}


static void
_vala_valadoc_taglets_link_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	ValadocTagletsLink * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_TAGLETS_TYPE_LINK, ValadocTagletsLink);
	switch (property_id) {
		case VALADOC_TAGLETS_LINK_SYMBOL_NAME_PROPERTY:
		g_value_set_string (value, valadoc_taglets_link_get_symbol_name (self));
		break;
		case VALADOC_TAGLETS_LINK_C_ACCEPT_PLURAL_PROPERTY:
		g_value_set_boolean (value, valadoc_taglets_link_get_c_accept_plural (self));
		break;
		case VALADOC_TAGLETS_LINK_C_IS_PLURAL_PROPERTY:
		g_value_set_boolean (value, valadoc_taglets_link_get_c_is_plural (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_valadoc_taglets_link_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	ValadocTagletsLink * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_TAGLETS_TYPE_LINK, ValadocTagletsLink);
	switch (property_id) {
		case VALADOC_TAGLETS_LINK_SYMBOL_NAME_PROPERTY:
		valadoc_taglets_link_set_symbol_name (self, g_value_get_string (value));
		break;
		case VALADOC_TAGLETS_LINK_C_ACCEPT_PLURAL_PROPERTY:
		valadoc_taglets_link_set_c_accept_plural (self, g_value_get_boolean (value));
		break;
		case VALADOC_TAGLETS_LINK_C_IS_PLURAL_PROPERTY:
		valadoc_taglets_link_set_c_is_plural (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



