/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};


static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                                      ValaEnum* en);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gsize _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		const gchar* res = NULL;
		gsize _tmp27_;
		void* _tmp28_;
		void* ptr = NULL;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		void* _tmp31_;
		const gchar* _tmp44_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = len;
		_tmp24_ = strlen ((const gchar*) separator);
		_tmp25_ = _tmp24_;
		_tmp26_ = i;
		len = _tmp23_ + (_tmp25_ * (_tmp26_ - 1));
		_tmp27_ = len;
		_tmp28_ = g_malloc (_tmp27_);
		res = _tmp28_;
		_tmp29_ = res;
		_tmp30_ = str_array[0];
		_tmp31_ = g_stpcpy ((void*) _tmp29_, (const gchar*) _tmp30_);
		ptr = _tmp31_;
		{
			gboolean _tmp32_ = FALSE;
			i = 1;
			_tmp32_ = TRUE;
			while (TRUE) {
				gint _tmp34_;
				void* _tmp35_;
				void* _tmp36_;
				const gchar* _tmp37_ = NULL;
				gint _tmp38_;
				const gchar* _tmp39_;
				void* _tmp42_;
				void* _tmp43_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = i;
				if (!(_tmp34_ < str_array_length1)) {
					break;
				}
				_tmp35_ = ptr;
				_tmp36_ = g_stpcpy (_tmp35_, (const gchar*) separator);
				ptr = _tmp36_;
				_tmp38_ = i;
				_tmp39_ = str_array[_tmp38_];
				if (_tmp39_ != NULL) {
					gint _tmp40_;
					const gchar* _tmp41_;
					_tmp40_ = i;
					_tmp41_ = str_array[_tmp40_];
					_tmp37_ = (const gchar*) _tmp41_;
				} else {
					_tmp37_ = "";
				}
				_tmp42_ = ptr;
				_tmp43_ = g_stpcpy (_tmp42_, _tmp37_);
				ptr = _tmp43_;
			}
		}
		_tmp44_ = res;
		res = NULL;
		result = (gchar*) _tmp44_;
		return result;
	} else {
		gchar* _tmp45_;
		_tmp45_ = g_strdup ("");
		result = _tmp45_;
		return result;
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}


static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp130_;
	GEqualFunc _tmp131_;
	GEqualFunc _tmp132_;
	ValaHashMap* _tmp133_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp134_;
	ValaHashMap* _tmp135_;
	gboolean _tmp136_ = FALSE;
	ValaMethod* _tmp137_;
	gboolean _tmp256_ = FALSE;
	ValaMethod* _tmp257_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp426_;
	ValaCCodeExpression* _tmp427_;
	ValaMethod* _tmp428_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp452_ = FALSE;
	ValaMethod* _tmp453_;
	gboolean _tmp615_ = FALSE;
	ValaMethod* _tmp616_;
	ValaMethod* _tmp677_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp873_;
	ValaIterator* _tmp874_;
	ValaIterator* _tmp1269_;
	gboolean _tmp1279_ = FALSE;
	gboolean _tmp1280_ = FALSE;
	ValaMethod* _tmp1281_;
	gboolean _tmp1406_ = FALSE;
	ValaDelegate* _tmp1407_;
	gboolean _tmp1504_ = FALSE;
	ValaMethod* _tmp1505_;
	gboolean _tmp1521_;
	gboolean _tmp1522_;
	gboolean _tmp1537_;
	ValaDataType* _tmp1562_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1586_;
	ValaDataType* _tmp1587_;
	ValaDataType* _tmp1588_;
	gboolean _tmp1589_;
	gboolean _tmp1590_ = FALSE;
	ValaDataType* _tmp1591_;
	ValaCCodeFunctionCall* _tmp1620_;
	ValaCCodeFunctionCall* _tmp1621_;
	ValaCCodeExpression* out_param_ref = NULL;
	gboolean _tmp1622_;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1637_;
	ValaCCodeFunctionCall* _tmp1638_;
	ValaCCodeFunctionCall* _tmp1662_;
	gboolean _tmp1686_;
	gboolean _tmp1687_;
	gboolean _tmp1713_;
	gboolean _tmp1714_;
	gboolean _tmp1744_;
	gboolean _tmp1750_ = FALSE;
	gboolean _tmp1751_ = FALSE;
	ValaMethod* _tmp1752_;
	gboolean _tmp1790_ = FALSE;
	gboolean _tmp1791_ = FALSE;
	gboolean _tmp1792_ = FALSE;
	gboolean _tmp1793_ = FALSE;
	gboolean _tmp1794_ = FALSE;
	ValaMethod* _tmp1795_;
	gboolean _tmp1812_ = FALSE;
	gboolean _tmp1813_ = FALSE;
	ValaMethod* _tmp1814_;
	ValaMethod* _tmp1833_;
	gboolean _tmp1944_ = FALSE;
	ValaCodeNode* _tmp1945_;
	ValaCodeNode* _tmp1946_;
	ValaList* _tmp2022_;
	ValaIterator* _tmp2023_;
	gboolean _tmp2171_ = FALSE;
	gboolean _tmp2172_ = FALSE;
	ValaMethod* _tmp2173_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_tostring_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_;
			gboolean _tmp57_;
			_tmp56_ = vala_method_call_get_is_constructv_chainup (expr);
			_tmp57_ = _tmp56_;
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp58_;
				ValaMethod* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				ValaCCodeIdentifier* _tmp62_;
				ValaCCodeIdentifier* _tmp63_;
				_tmp58_ = ccall;
				_tmp59_ = m;
				_tmp60_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_ccode_identifier_new (_tmp61_);
				_tmp63_ = _tmp62_;
				vala_ccode_function_call_set_call (_tmp58_, (ValaCCodeExpression*) _tmp63_);
				_vala_ccode_node_unref0 (_tmp63_);
				_g_free0 (_tmp61_);
			}
		}
	} else {
		ValaDataType* _tmp64_;
		_tmp64_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp65_;
			ValaSignalType* _tmp66_;
			gboolean _tmp67_ = FALSE;
			gboolean _tmp68_ = FALSE;
			ValaMemberAccess* _tmp69_;
			_tmp65_ = itype;
			_tmp66_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp66_;
			_tmp69_ = ma;
			if (_tmp69_ != NULL) {
				ValaMemberAccess* _tmp70_;
				ValaExpression* _tmp71_;
				ValaExpression* _tmp72_;
				_tmp70_ = ma;
				_tmp71_ = vala_member_access_get_inner (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp68_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp68_ = FALSE;
			}
			if (_tmp68_) {
				ValaSignalType* _tmp73_;
				ValaSignal* _tmp74_;
				ValaSignal* _tmp75_;
				gboolean _tmp76_;
				gboolean _tmp77_;
				_tmp73_ = sig_type;
				_tmp74_ = vala_signal_type_get_signal_symbol (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_signal_get_is_virtual (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp67_ = _tmp77_;
			} else {
				_tmp67_ = FALSE;
			}
			if (_tmp67_) {
				ValaSignalType* _tmp78_;
				ValaSignal* _tmp79_;
				ValaSignal* _tmp80_;
				ValaMethod* _tmp81_;
				ValaMethod* _tmp82_;
				ValaMethod* _tmp83_;
				_tmp78_ = sig_type;
				_tmp79_ = vala_signal_type_get_signal_symbol (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = vala_signal_get_default_handler (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = _vala_code_node_ref0 (_tmp82_);
				_vala_code_node_unref0 (m);
				m = _tmp83_;
			} else {
				ValaExpression* _tmp84_;
				ValaExpression* _tmp85_;
				ValaCCodeExpression* _tmp86_;
				_tmp84_ = vala_method_call_get_call (expr);
				_tmp85_ = _tmp84_;
				_tmp86_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp85_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp87_;
			_tmp87_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp88_;
				ValaObjectTypeSymbol* _tmp89_;
				ValaObjectTypeSymbol* _tmp90_;
				ValaClass* _tmp91_;
				ValaClass* _tmp92_;
				ValaCreationMethod* _tmp93_;
				ValaCreationMethod* _tmp94_;
				ValaMethod* _tmp95_;
				ValaMethod* _tmp96_;
				ValaCCodeFile* _tmp97_;
				gchar* real_name = NULL;
				ValaMethod* _tmp98_;
				gchar* _tmp99_;
				gboolean _tmp100_;
				gboolean _tmp101_;
				const gchar* _tmp104_;
				ValaCCodeIdentifier* _tmp105_;
				ValaCCodeIdentifier* _tmp106_;
				ValaCCodeFunctionCall* _tmp107_;
				_tmp88_ = itype;
				_tmp89_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp90_ = _tmp89_;
				_tmp91_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp91_;
				_tmp92_ = cl;
				_tmp93_ = vala_class_get_default_construction_method (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = _vala_code_node_ref0 ((ValaMethod*) _tmp94_);
				_vala_code_node_unref0 (m);
				m = _tmp95_;
				_tmp96_ = m;
				_tmp97_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp96_, _tmp97_);
				_tmp98_ = m;
				_tmp99_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp98_);
				real_name = _tmp99_;
				_tmp100_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp101_ = _tmp100_;
				if (_tmp101_) {
					ValaMethod* _tmp102_;
					gchar* _tmp103_;
					_tmp102_ = m;
					_tmp103_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp103_;
				}
				_tmp104_ = real_name;
				_tmp105_ = vala_ccode_identifier_new (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp106_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp107_;
				_vala_ccode_node_unref0 (_tmp106_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp108_;
				_tmp108_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp109_;
					ValaTypeSymbol* _tmp110_;
					ValaTypeSymbol* _tmp111_;
					ValaStruct* _tmp112_;
					ValaStruct* _tmp113_;
					ValaMethod* _tmp114_;
					ValaMethod* _tmp115_;
					ValaMethod* _tmp116_;
					ValaMethod* _tmp117_;
					ValaCCodeFile* _tmp118_;
					ValaMethod* _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					ValaCCodeIdentifier* _tmp122_;
					ValaCCodeIdentifier* _tmp123_;
					ValaCCodeFunctionCall* _tmp124_;
					_tmp109_ = itype;
					_tmp110_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp111_ = _tmp110_;
					_tmp112_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp112_;
					_tmp113_ = st;
					_tmp114_ = vala_struct_get_default_construction_method (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = _vala_code_node_ref0 (_tmp115_);
					_vala_code_node_unref0 (m);
					m = _tmp116_;
					_tmp117_ = m;
					_tmp118_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp117_, _tmp118_);
					_tmp119_ = m;
					_tmp120_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = vala_ccode_identifier_new (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp123_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp124_;
					_vala_ccode_node_unref0 (_tmp123_);
					_g_free0 (_tmp121_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp125_;
					_tmp125_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp125_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp126_;
						ValaDelegate* _tmp127_;
						ValaDelegate* _tmp128_;
						ValaDelegate* _tmp129_;
						_tmp126_ = itype;
						_tmp127_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp128_ = _tmp127_;
						_tmp129_ = _vala_code_node_ref0 (_tmp128_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp129_;
					}
				}
			}
		}
	}
	_tmp130_ = g_direct_hash;
	_tmp131_ = g_direct_equal;
	_tmp132_ = g_direct_equal;
	_tmp133_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp130_, _tmp131_, _tmp132_);
	in_arg_map = _tmp133_;
	_tmp134_ = in_arg_map;
	_tmp135_ = _vala_map_ref0 (_tmp134_);
	out_arg_map = _tmp135_;
	_tmp137_ = m;
	if (_tmp137_ != NULL) {
		ValaMethod* _tmp138_;
		gboolean _tmp139_;
		gboolean _tmp140_;
		_tmp138_ = m;
		_tmp139_ = vala_method_get_coroutine (_tmp138_);
		_tmp140_ = _tmp139_;
		_tmp136_ = _tmp140_;
	} else {
		_tmp136_ = FALSE;
	}
	if (_tmp136_) {
		ValaMethod* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
		ValaCCodeIdentifier* _tmp144_;
		ValaCCodeIdentifier* _tmp145_;
		ValaCCodeFunctionCall* _tmp146_;
		ValaMethod* _tmp147_;
		gchar* _tmp148_;
		gchar* _tmp149_;
		ValaCCodeIdentifier* _tmp150_;
		ValaCCodeIdentifier* _tmp151_;
		ValaCCodeFunctionCall* _tmp152_;
		ValaMemberAccess* _tmp153_;
		ValaExpression* _tmp154_;
		ValaExpression* _tmp155_;
		gboolean _tmp206_ = FALSE;
		ValaMemberAccess* _tmp207_;
		const gchar* _tmp208_;
		const gchar* _tmp209_;
		_tmp141_ = m;
		_tmp142_ = vala_get_ccode_name ((ValaCodeNode*) _tmp141_);
		_tmp143_ = _tmp142_;
		_tmp144_ = vala_ccode_identifier_new (_tmp143_);
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp145_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp146_;
		_vala_ccode_node_unref0 (_tmp145_);
		_g_free0 (_tmp143_);
		_tmp147_ = m;
		_tmp148_ = vala_get_ccode_finish_name (_tmp147_);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_ccode_identifier_new (_tmp149_);
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp151_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp152_;
		_vala_ccode_node_unref0 (_tmp151_);
		_g_free0 (_tmp149_);
		_tmp153_ = ma;
		_tmp154_ = vala_member_access_get_inner (_tmp153_);
		_tmp155_ = _tmp154_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp155_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp156_;
			ValaMethod* _tmp157_;
			ValaMethod* _tmp158_;
			ValaCCodeExpression* _tmp191_;
			vcast = NULL;
			_tmp156_ = m;
			_tmp157_ = vala_method_get_base_method (_tmp156_);
			_tmp158_ = _tmp157_;
			if (_tmp158_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp159_;
				ValaMethod* _tmp160_;
				ValaMethod* _tmp161_;
				ValaSymbol* _tmp162_;
				ValaSymbol* _tmp163_;
				ValaClass* _tmp164_;
				gchar* _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				gchar* _tmp168_;
				ValaCCodeIdentifier* _tmp169_;
				ValaCCodeIdentifier* _tmp170_;
				ValaCCodeFunctionCall* _tmp171_;
				ValaCCodeExpression* _tmp172_;
				ValaClass* _tmp173_;
				ValaClass* _tmp174_;
				gchar* _tmp175_;
				gchar* _tmp176_;
				gchar* _tmp177_;
				gchar* _tmp178_;
				ValaCCodeIdentifier* _tmp179_;
				ValaCCodeIdentifier* _tmp180_;
				_tmp159_ = m;
				_tmp160_ = vala_method_get_base_method (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp161_);
				_tmp163_ = _tmp162_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, VALA_TYPE_CLASS, ValaClass);
				_tmp164_ = base_class;
				_tmp165_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp164_, NULL);
				_tmp166_ = _tmp165_;
				_tmp167_ = g_strdup_printf ("%s_CLASS", _tmp166_);
				_tmp168_ = _tmp167_;
				_tmp169_ = vala_ccode_identifier_new (_tmp168_);
				_tmp170_ = _tmp169_;
				_tmp171_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp170_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp171_;
				_vala_ccode_node_unref0 (_tmp170_);
				_g_free0 (_tmp168_);
				_g_free0 (_tmp166_);
				_tmp172_ = vcast;
				_tmp173_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp174_ = _tmp173_;
				_tmp175_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp174_, NULL);
				_tmp176_ = _tmp175_;
				_tmp177_ = g_strdup_printf ("%s_parent_class", _tmp176_);
				_tmp178_ = _tmp177_;
				_tmp179_ = vala_ccode_identifier_new (_tmp178_);
				_tmp180_ = _tmp179_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp172_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp180_);
				_vala_ccode_node_unref0 (_tmp180_);
				_g_free0 (_tmp178_);
				_g_free0 (_tmp176_);
			} else {
				ValaMethod* _tmp181_;
				ValaMethod* _tmp182_;
				ValaMethod* _tmp183_;
				_tmp181_ = m;
				_tmp182_ = vala_method_get_base_interface_method (_tmp181_);
				_tmp183_ = _tmp182_;
				if (_tmp183_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp184_;
					ValaMethod* _tmp185_;
					ValaMethod* _tmp186_;
					ValaSymbol* _tmp187_;
					ValaSymbol* _tmp188_;
					ValaInterface* _tmp189_;
					ValaCCodeExpression* _tmp190_;
					_tmp184_ = m;
					_tmp185_ = vala_method_get_base_interface_method (_tmp184_);
					_tmp186_ = _tmp185_;
					_tmp187_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp186_);
					_tmp188_ = _tmp187_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp188_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp189_ = base_iface;
					_tmp190_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp189_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp190_;
				}
			}
			_tmp191_ = vcast;
			if (_tmp191_ != NULL) {
				ValaCCodeFunctionCall* _tmp192_;
				ValaCCodeExpression* _tmp193_;
				ValaMethod* _tmp194_;
				gchar* _tmp195_;
				gchar* _tmp196_;
				ValaCCodeMemberAccess* _tmp197_;
				ValaCCodeMemberAccess* _tmp198_;
				ValaCCodeFunctionCall* _tmp199_;
				ValaCCodeExpression* _tmp200_;
				ValaMethod* _tmp201_;
				gchar* _tmp202_;
				gchar* _tmp203_;
				ValaCCodeMemberAccess* _tmp204_;
				ValaCCodeMemberAccess* _tmp205_;
				_tmp192_ = async_call;
				_tmp193_ = vcast;
				_tmp194_ = m;
				_tmp195_ = vala_get_ccode_vfunc_name (_tmp194_);
				_tmp196_ = _tmp195_;
				_tmp197_ = vala_ccode_member_access_new_pointer (_tmp193_, _tmp196_);
				_tmp198_ = _tmp197_;
				vala_ccode_function_call_set_call (_tmp192_, (ValaCCodeExpression*) _tmp198_);
				_vala_ccode_node_unref0 (_tmp198_);
				_g_free0 (_tmp196_);
				_tmp199_ = finish_call;
				_tmp200_ = vcast;
				_tmp201_ = m;
				_tmp202_ = vala_get_ccode_finish_vfunc_name (_tmp201_);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_ccode_member_access_new_pointer (_tmp200_, _tmp203_);
				_tmp205_ = _tmp204_;
				vala_ccode_function_call_set_call (_tmp199_, (ValaCCodeExpression*) _tmp205_);
				_vala_ccode_node_unref0 (_tmp205_);
				_g_free0 (_tmp203_);
			}
			_vala_ccode_node_unref0 (vcast);
		}
		_tmp207_ = ma;
		_tmp208_ = vala_member_access_get_member_name (_tmp207_);
		_tmp209_ = _tmp208_;
		if (g_strcmp0 (_tmp209_, "begin") == 0) {
			ValaMemberAccess* _tmp210_;
			ValaExpression* _tmp211_;
			ValaExpression* _tmp212_;
			ValaSymbol* _tmp213_;
			ValaSymbol* _tmp214_;
			ValaMemberAccess* _tmp215_;
			ValaSymbol* _tmp216_;
			ValaSymbol* _tmp217_;
			_tmp210_ = ma;
			_tmp211_ = vala_member_access_get_inner (_tmp210_);
			_tmp212_ = _tmp211_;
			_tmp213_ = vala_expression_get_symbol_reference (_tmp212_);
			_tmp214_ = _tmp213_;
			_tmp215_ = ma;
			_tmp216_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp215_);
			_tmp217_ = _tmp216_;
			_tmp206_ = _tmp214_ == _tmp217_;
		} else {
			_tmp206_ = FALSE;
		}
		if (_tmp206_) {
			ValaCCodeFunctionCall* _tmp218_;
			ValaCCodeFunctionCall* _tmp219_;
			ValaMethod* _tmp220_;
			ValaList* _tmp221_;
			_tmp218_ = async_call;
			_tmp219_ = _vala_ccode_node_ref0 (_tmp218_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp219_;
			_tmp220_ = m;
			_tmp221_ = vala_method_get_async_begin_parameters (_tmp220_);
			_vala_iterable_unref0 (params);
			params = _tmp221_;
		} else {
			gboolean _tmp222_ = FALSE;
			ValaMemberAccess* _tmp223_;
			const gchar* _tmp224_;
			const gchar* _tmp225_;
			_tmp223_ = ma;
			_tmp224_ = vala_member_access_get_member_name (_tmp223_);
			_tmp225_ = _tmp224_;
			if (g_strcmp0 (_tmp225_, "end") == 0) {
				ValaMemberAccess* _tmp226_;
				ValaExpression* _tmp227_;
				ValaExpression* _tmp228_;
				ValaSymbol* _tmp229_;
				ValaSymbol* _tmp230_;
				ValaMemberAccess* _tmp231_;
				ValaSymbol* _tmp232_;
				ValaSymbol* _tmp233_;
				_tmp226_ = ma;
				_tmp227_ = vala_member_access_get_inner (_tmp226_);
				_tmp228_ = _tmp227_;
				_tmp229_ = vala_expression_get_symbol_reference (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp231_ = ma;
				_tmp232_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp231_);
				_tmp233_ = _tmp232_;
				_tmp222_ = _tmp230_ == _tmp233_;
			} else {
				_tmp222_ = FALSE;
			}
			if (_tmp222_) {
				ValaCCodeFunctionCall* _tmp234_;
				ValaCCodeFunctionCall* _tmp235_;
				ValaMethod* _tmp236_;
				ValaList* _tmp237_;
				_tmp234_ = finish_call;
				_tmp235_ = _vala_ccode_node_ref0 (_tmp234_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp235_;
				_tmp236_ = m;
				_tmp237_ = vala_method_get_async_end_parameters (_tmp236_);
				_vala_iterable_unref0 (params);
				params = _tmp237_;
			} else {
				gboolean _tmp238_;
				gboolean _tmp239_;
				_tmp238_ = vala_method_call_get_is_yield_expression (expr);
				_tmp239_ = _tmp238_;
				if (!_tmp239_) {
					ValaCCodeFunctionCall* _tmp240_;
					ValaCCodeFunctionCall* _tmp241_;
					ValaMethod* _tmp242_;
					ValaList* _tmp243_;
					_tmp240_ = async_call;
					_tmp241_ = _vala_ccode_node_ref0 (_tmp240_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp241_;
					_tmp242_ = m;
					_tmp243_ = vala_method_get_async_begin_parameters (_tmp242_);
					_vala_iterable_unref0 (params);
					params = _tmp243_;
				} else {
					ValaCCodeFunctionCall* _tmp244_;
					ValaCCodeFunctionCall* _tmp245_;
					GHashFunc _tmp246_;
					GEqualFunc _tmp247_;
					GEqualFunc _tmp248_;
					ValaHashMap* _tmp249_;
					ValaHashMap* _tmp250_;
					ValaMethod* _tmp251_;
					ValaCCodeIdentifier* _tmp252_;
					ValaCCodeIdentifier* _tmp253_;
					ValaCCodeMemberAccess* _tmp254_;
					ValaCCodeMemberAccess* _tmp255_;
					_tmp244_ = finish_call;
					_tmp245_ = _vala_ccode_node_ref0 (_tmp244_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp245_;
					_tmp246_ = g_direct_hash;
					_tmp247_ = g_direct_equal;
					_tmp248_ = g_direct_equal;
					_tmp249_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp246_, _tmp247_, _tmp248_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp249_;
					_tmp250_ = out_arg_map;
					_tmp251_ = m;
					_tmp252_ = vala_ccode_identifier_new ("_data_");
					_tmp253_ = _tmp252_;
					_tmp254_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp253_, "_res_");
					_tmp255_ = _tmp254_;
					vala_map_set ((ValaMap*) _tmp250_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp251_), FALSE)), (ValaCCodeExpression*) _tmp255_);
					_vala_ccode_node_unref0 (_tmp255_);
					_vala_ccode_node_unref0 (_tmp253_);
				}
			}
		}
	}
	_tmp257_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp257_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp258_;
		ValaSymbol* _tmp259_;
		ValaSymbol* _tmp260_;
		_tmp258_ = m;
		_tmp259_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp258_);
		_tmp260_ = _tmp259_;
		_tmp256_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp260_, VALA_TYPE_CLASS);
	} else {
		_tmp256_ = FALSE;
	}
	if (_tmp256_) {
		ValaMethod* _tmp261_;
		ValaSymbol* _tmp262_;
		ValaSymbol* _tmp263_;
		gboolean _tmp264_;
		gboolean _tmp265_;
		ValaClass* _tmp269_;
		ValaClass* _tmp270_;
		gboolean _tmp271_;
		gboolean _tmp272_;
		_tmp261_ = m;
		_tmp262_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp261_);
		_tmp263_ = _tmp262_;
		_tmp264_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp263_, VALA_TYPE_CLASS, ValaClass));
		_tmp265_ = _tmp264_;
		if (!_tmp265_) {
			ValaCCodeFunctionCall* _tmp266_;
			ValaCCodeExpression* _tmp267_;
			ValaCCodeExpression* _tmp268_;
			_tmp266_ = ccall;
			_tmp267_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
			_tmp268_ = _tmp267_;
			vala_ccode_function_call_add_argument (_tmp266_, _tmp268_);
			_vala_ccode_node_unref0 (_tmp268_);
		}
		_tmp269_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp270_ = _tmp269_;
		_tmp271_ = vala_class_get_is_compact (_tmp270_);
		_tmp272_ = _tmp271_;
		if (!_tmp272_) {
			ValaClass* _tmp273_;
			ValaClass* _tmp274_;
			ValaMethod* _tmp275_;
			ValaSymbol* _tmp276_;
			ValaSymbol* _tmp277_;
			_tmp273_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp274_ = _tmp273_;
			_tmp275_ = m;
			_tmp276_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp275_);
			_tmp277_ = _tmp276_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp274_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp277_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp278_;
					ValaClass* _tmp279_;
					ValaList* _tmp280_;
					gint _base_type_size = 0;
					ValaList* _tmp281_;
					gint _tmp282_;
					gint _tmp283_;
					gint _base_type_index = 0;
					_tmp278_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_class_get_base_types (_tmp279_);
					_base_type_list = _tmp280_;
					_tmp281_ = _base_type_list;
					_tmp282_ = vala_collection_get_size ((ValaCollection*) _tmp281_);
					_tmp283_ = _tmp282_;
					_base_type_size = _tmp283_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp284_;
						gint _tmp285_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp286_;
						gint _tmp287_;
						gpointer _tmp288_;
						ValaDataType* _tmp289_;
						ValaTypeSymbol* _tmp290_;
						ValaTypeSymbol* _tmp291_;
						_base_type_index = _base_type_index + 1;
						_tmp284_ = _base_type_index;
						_tmp285_ = _base_type_size;
						if (!(_tmp284_ < _tmp285_)) {
							break;
						}
						_tmp286_ = _base_type_list;
						_tmp287_ = _base_type_index;
						_tmp288_ = vala_list_get (_tmp286_, _tmp287_);
						base_type = (ValaDataType*) _tmp288_;
						_tmp289_ = base_type;
						_tmp290_ = vala_data_type_get_data_type (_tmp289_);
						_tmp291_ = _tmp290_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp291_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp292_;
							gchar* _tmp293_;
							gchar* _tmp294_;
							gboolean _tmp295_;
							ValaHashMap* _tmp300_;
							ValaDataType* _tmp301_;
							ValaList* _tmp302_;
							ValaList* _tmp303_;
							ValaList* _tmp304_;
							type_parameters = NULL;
							_tmp292_ = m;
							_tmp293_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp292_);
							_tmp294_ = _tmp293_;
							_tmp295_ = g_strcmp0 (_tmp294_, "g_object_new") == 0;
							_g_free0 (_tmp294_);
							if (_tmp295_) {
								ValaDataType* _tmp296_;
								ValaTypeSymbol* _tmp297_;
								ValaTypeSymbol* _tmp298_;
								ValaList* _tmp299_;
								_tmp296_ = base_type;
								_tmp297_ = vala_data_type_get_data_type (_tmp296_);
								_tmp298_ = _tmp297_;
								_tmp299_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp298_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp299_;
							}
							_tmp300_ = in_arg_map;
							_tmp301_ = base_type;
							_tmp302_ = vala_data_type_get_type_arguments (_tmp301_);
							_tmp303_ = _tmp302_;
							_tmp304_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp300_, _tmp303_, (ValaCodeNode*) expr, TRUE, _tmp304_);
							_vala_iterable_unref0 (_tmp303_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp305_;
				ValaSymbol* _tmp306_;
				ValaSymbol* _tmp307_;
				ValaClass* _tmp308_;
				type_param_index = 0;
				_tmp305_ = m;
				_tmp306_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp305_);
				_tmp307_ = _tmp306_;
				_tmp308_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp307_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp308_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp309_;
					ValaList* _tmp310_;
					gint _type_param_size = 0;
					ValaList* _tmp311_;
					gint _tmp312_;
					gint _tmp313_;
					gint _type_param_index = 0;
					_tmp309_ = cl;
					_tmp310_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp309_);
					_type_param_list = _tmp310_;
					_tmp311_ = _type_param_list;
					_tmp312_ = vala_collection_get_size ((ValaCollection*) _tmp311_);
					_tmp313_ = _tmp312_;
					_type_param_size = _tmp313_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp314_;
						gint _tmp315_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp316_;
						gint _tmp317_;
						gpointer _tmp318_;
						ValaHashMap* _tmp319_;
						gint _tmp320_;
						ValaTypeParameter* _tmp321_;
						const gchar* _tmp322_;
						const gchar* _tmp323_;
						gchar* _tmp324_;
						gchar* _tmp325_;
						gchar* _tmp326_;
						gchar* _tmp327_;
						ValaCCodeIdentifier* _tmp328_;
						ValaCCodeIdentifier* _tmp329_;
						ValaHashMap* _tmp330_;
						gint _tmp331_;
						ValaTypeParameter* _tmp332_;
						const gchar* _tmp333_;
						const gchar* _tmp334_;
						gchar* _tmp335_;
						gchar* _tmp336_;
						gchar* _tmp337_;
						gchar* _tmp338_;
						ValaCCodeIdentifier* _tmp339_;
						ValaCCodeIdentifier* _tmp340_;
						ValaHashMap* _tmp341_;
						gint _tmp342_;
						ValaTypeParameter* _tmp343_;
						const gchar* _tmp344_;
						const gchar* _tmp345_;
						gchar* _tmp346_;
						gchar* _tmp347_;
						gchar* _tmp348_;
						gchar* _tmp349_;
						ValaCCodeIdentifier* _tmp350_;
						ValaCCodeIdentifier* _tmp351_;
						gint _tmp352_;
						_type_param_index = _type_param_index + 1;
						_tmp314_ = _type_param_index;
						_tmp315_ = _type_param_size;
						if (!(_tmp314_ < _tmp315_)) {
							break;
						}
						_tmp316_ = _type_param_list;
						_tmp317_ = _type_param_index;
						_tmp318_ = vala_list_get (_tmp316_, _tmp317_);
						type_param = (ValaTypeParameter*) _tmp318_;
						_tmp319_ = in_arg_map;
						_tmp320_ = type_param_index;
						_tmp321_ = type_param;
						_tmp322_ = vala_symbol_get_name ((ValaSymbol*) _tmp321_);
						_tmp323_ = _tmp322_;
						_tmp324_ = g_ascii_strdown (_tmp323_, (gssize) -1);
						_tmp325_ = _tmp324_;
						_tmp326_ = g_strdup_printf ("%s_type", _tmp325_);
						_tmp327_ = _tmp326_;
						_tmp328_ = vala_ccode_identifier_new (_tmp327_);
						_tmp329_ = _tmp328_;
						vala_map_set ((ValaMap*) _tmp319_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp320_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp329_);
						_vala_ccode_node_unref0 (_tmp329_);
						_g_free0 (_tmp327_);
						_g_free0 (_tmp325_);
						_tmp330_ = in_arg_map;
						_tmp331_ = type_param_index;
						_tmp332_ = type_param;
						_tmp333_ = vala_symbol_get_name ((ValaSymbol*) _tmp332_);
						_tmp334_ = _tmp333_;
						_tmp335_ = g_ascii_strdown (_tmp334_, (gssize) -1);
						_tmp336_ = _tmp335_;
						_tmp337_ = g_strdup_printf ("%s_dup_func", _tmp336_);
						_tmp338_ = _tmp337_;
						_tmp339_ = vala_ccode_identifier_new (_tmp338_);
						_tmp340_ = _tmp339_;
						vala_map_set ((ValaMap*) _tmp330_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp331_) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp340_);
						_vala_ccode_node_unref0 (_tmp340_);
						_g_free0 (_tmp338_);
						_g_free0 (_tmp336_);
						_tmp341_ = in_arg_map;
						_tmp342_ = type_param_index;
						_tmp343_ = type_param;
						_tmp344_ = vala_symbol_get_name ((ValaSymbol*) _tmp343_);
						_tmp345_ = _tmp344_;
						_tmp346_ = g_ascii_strdown (_tmp345_, (gssize) -1);
						_tmp347_ = _tmp346_;
						_tmp348_ = g_strdup_printf ("%s_destroy_func", _tmp347_);
						_tmp349_ = _tmp348_;
						_tmp350_ = vala_ccode_identifier_new (_tmp349_);
						_tmp351_ = _tmp350_;
						vala_map_set ((ValaMap*) _tmp341_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp342_) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp351_);
						_vala_ccode_node_unref0 (_tmp351_);
						_g_free0 (_tmp349_);
						_g_free0 (_tmp347_);
						_tmp352_ = type_param_index;
						type_param_index = _tmp352_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp353_;
			ValaClass* _tmp354_;
			ValaClass* _tmp355_;
			ValaClass* _tmp356_;
			ValaClass* _tmp357_;
			_tmp353_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp354_ = _tmp353_;
			_tmp355_ = vala_class_get_base_class (_tmp354_);
			_tmp356_ = _tmp355_;
			_tmp357_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp356_ == _tmp357_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp358_;
				ValaClass* _tmp359_;
				gchar* _tmp360_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp361_;
				ValaCCodeDeclaration* _tmp362_;
				ValaCCodeDeclaration* _tmp363_;
				const gchar* _tmp364_;
				const gchar* _tmp365_;
				const gchar* _tmp366_;
				const gchar* _tmp367_;
				gchar* _tmp368_;
				gchar* _tmp369_;
				ValaCCodeConstant* _tmp370_;
				ValaCCodeConstant* _tmp371_;
				ValaCCodeVariableDeclarator* _tmp372_;
				ValaCCodeVariableDeclarator* _tmp373_;
				ValaCCodeFunction* _tmp374_;
				ValaCCodeFunction* _tmp375_;
				ValaCCodeDeclaration* _tmp376_;
				ValaCCodeFunctionCall* _tmp377_;
				ValaCCodeIdentifier* _tmp378_;
				ValaCCodeIdentifier* _tmp379_;
				ValaCCodeUnaryExpression* _tmp380_;
				ValaCCodeUnaryExpression* _tmp381_;
				ValaCCodeCastExpression* _tmp382_;
				ValaCCodeCastExpression* _tmp383_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp384_;
				ValaCCodeIdentifier* _tmp385_;
				ValaCCodeFunctionCall* _tmp386_;
				ValaCCodeFunctionCall* _tmp387_;
				ValaCCodeFunctionCall* _tmp388_;
				ValaClass* _tmp389_;
				ValaClass* _tmp390_;
				gchar* _tmp391_;
				gchar* _tmp392_;
				ValaCCodeIdentifier* _tmp393_;
				ValaCCodeIdentifier* _tmp394_;
				ValaCCodeFunctionCall* _tmp395_;
				ValaCCodeFunctionCall* _tmp396_;
				_tmp358_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp359_ = _tmp358_;
				_tmp360_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp359_, NULL);
				class_prefix = _tmp360_;
				_tmp361_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp361_;
				_tmp362_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp362_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp363_ = funcs;
				_tmp364_ = class_prefix;
				_tmp365_ = class_prefix;
				_tmp366_ = class_prefix;
				_tmp367_ = class_prefix;
				_tmp368_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp364_, _tmp365_, _tmp366_, _tmp367_);
				_tmp369_ = _tmp368_;
				_tmp370_ = vala_ccode_constant_new (_tmp369_);
				_tmp371_ = _tmp370_;
				_tmp372_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp371_, NULL);
				_tmp373_ = _tmp372_;
				vala_ccode_declaration_add_declarator (_tmp363_, (ValaCCodeDeclarator*) _tmp373_);
				_vala_ccode_node_unref0 (_tmp373_);
				_vala_ccode_node_unref0 (_tmp371_);
				_g_free0 (_tmp369_);
				_tmp374_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp375_ = _tmp374_;
				_tmp376_ = funcs;
				vala_ccode_function_add_statement (_tmp375_, (ValaCCodeNode*) _tmp376_);
				_tmp377_ = ccall;
				_tmp378_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp379_ = _tmp378_;
				_tmp380_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp379_);
				_tmp381_ = _tmp380_;
				_tmp382_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp381_, "GSourceFuncs *");
				_tmp383_ = _tmp382_;
				vala_ccode_function_call_add_argument (_tmp377_, (ValaCCodeExpression*) _tmp383_);
				_vala_ccode_node_unref0 (_tmp383_);
				_vala_ccode_node_unref0 (_tmp381_);
				_vala_ccode_node_unref0 (_tmp379_);
				_tmp384_ = vala_ccode_identifier_new ("sizeof");
				_tmp385_ = _tmp384_;
				_tmp386_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp385_);
				_tmp387_ = _tmp386_;
				_vala_ccode_node_unref0 (_tmp385_);
				csizeof = _tmp387_;
				_tmp388_ = csizeof;
				_tmp389_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp390_ = _tmp389_;
				_tmp391_ = vala_get_ccode_name ((ValaCodeNode*) _tmp390_);
				_tmp392_ = _tmp391_;
				_tmp393_ = vala_ccode_identifier_new (_tmp392_);
				_tmp394_ = _tmp393_;
				vala_ccode_function_call_add_argument (_tmp388_, (ValaCCodeExpression*) _tmp394_);
				_vala_ccode_node_unref0 (_tmp394_);
				_g_free0 (_tmp392_);
				_tmp395_ = ccall;
				_tmp396_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp395_, (ValaCCodeExpression*) _tmp396_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp397_ = FALSE;
		ValaMethod* _tmp398_;
		_tmp398_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp398_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp399_;
			ValaSymbol* _tmp400_;
			ValaSymbol* _tmp401_;
			_tmp399_ = m;
			_tmp400_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp399_);
			_tmp401_ = _tmp400_;
			_tmp397_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp401_, VALA_TYPE_STRUCT);
		} else {
			_tmp397_ = FALSE;
		}
		if (_tmp397_) {
			ValaCCodeFunctionCall* _tmp402_;
			ValaCCodeExpression* _tmp403_;
			ValaCCodeExpression* _tmp404_;
			_tmp402_ = ccall;
			_tmp403_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp404_ = _tmp403_;
			vala_ccode_function_call_add_argument (_tmp402_, _tmp404_);
			_vala_ccode_node_unref0 (_tmp404_);
		} else {
			gboolean _tmp405_ = FALSE;
			gboolean _tmp406_ = FALSE;
			gboolean _tmp407_ = FALSE;
			gboolean _tmp408_ = FALSE;
			ValaMethod* _tmp409_;
			_tmp409_ = m;
			if (_tmp409_ != NULL) {
				ValaMethod* _tmp410_;
				ValaList* _tmp411_;
				ValaList* _tmp412_;
				gint _tmp413_;
				gint _tmp414_;
				_tmp410_ = m;
				_tmp411_ = vala_method_get_type_parameters (_tmp410_);
				_tmp412_ = _tmp411_;
				_tmp413_ = vala_collection_get_size ((ValaCollection*) _tmp412_);
				_tmp414_ = _tmp413_;
				_tmp408_ = _tmp414_ > 0;
				_vala_iterable_unref0 (_tmp412_);
			} else {
				_tmp408_ = FALSE;
			}
			if (_tmp408_) {
				ValaMethod* _tmp415_;
				_tmp415_ = m;
				_tmp407_ = !vala_get_ccode_has_generic_type_parameter (_tmp415_);
			} else {
				_tmp407_ = FALSE;
			}
			if (_tmp407_) {
				ValaMethod* _tmp416_;
				_tmp416_ = m;
				_tmp406_ = !vala_get_ccode_simple_generics (_tmp416_);
			} else {
				_tmp406_ = FALSE;
			}
			if (_tmp406_) {
				gboolean _tmp417_ = FALSE;
				ValaCCodeFunctionCall* _tmp418_;
				ValaCCodeFunctionCall* _tmp419_;
				_tmp418_ = ccall;
				_tmp419_ = finish_call;
				if (_tmp418_ != _tmp419_) {
					_tmp417_ = TRUE;
				} else {
					gboolean _tmp420_;
					gboolean _tmp421_;
					_tmp420_ = vala_method_call_get_is_yield_expression (expr);
					_tmp421_ = _tmp420_;
					_tmp417_ = _tmp421_;
				}
				_tmp405_ = _tmp417_;
			} else {
				_tmp405_ = FALSE;
			}
			if (_tmp405_) {
				ValaHashMap* _tmp422_;
				ValaMemberAccess* _tmp423_;
				ValaList* _tmp424_;
				ValaList* _tmp425_;
				_tmp422_ = in_arg_map;
				_tmp423_ = ma;
				_tmp424_ = vala_member_access_get_type_arguments (_tmp423_);
				_tmp425_ = _tmp424_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp422_, _tmp425_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp425_);
			}
		}
	}
	_tmp426_ = ccall;
	_tmp427_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp426_);
	ccall_expr = _tmp427_;
	_tmp428_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp428_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp429_;
		ValaExpression* _tmp430_;
		ValaExpression* _tmp431_;
		ValaDataType* _tmp432_;
		ValaDataType* _tmp433_;
		ValaArrayType* _tmp434_;
		ValaHashMap* _tmp435_;
		ValaArrayType* _tmp436_;
		ValaDataType* _tmp437_;
		ValaDataType* _tmp438_;
		gchar* _tmp439_;
		gchar* _tmp440_;
		ValaCCodeIdentifier* _tmp441_;
		ValaCCodeIdentifier* _tmp442_;
		_tmp429_ = ma;
		_tmp430_ = vala_member_access_get_inner (_tmp429_);
		_tmp431_ = _tmp430_;
		_tmp432_ = vala_expression_get_value_type (_tmp431_);
		_tmp433_ = _tmp432_;
		_tmp434_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp433_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp434_;
		_tmp435_ = in_arg_map;
		_tmp436_ = array_type;
		_tmp437_ = vala_array_type_get_element_type (_tmp436_);
		_tmp438_ = _tmp437_;
		_tmp439_ = vala_get_ccode_name ((ValaCodeNode*) _tmp438_);
		_tmp440_ = _tmp439_;
		_tmp441_ = vala_ccode_identifier_new (_tmp440_);
		_tmp442_ = _tmp441_;
		vala_map_set ((ValaMap*) _tmp435_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp442_);
		_vala_ccode_node_unref0 (_tmp442_);
		_g_free0 (_tmp440_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp443_;
		_tmp443_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp443_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp444_;
			_tmp444_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp444_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp445_;
				ValaExpression* _tmp446_;
				ValaExpression* _tmp447_;
				ValaTargetValue* _tmp448_;
				ValaTargetValue* _tmp449_;
				ValaTargetValue* _tmp450_;
				ValaTargetValue* _tmp451_;
				_tmp445_ = ma;
				_tmp446_ = vala_member_access_get_inner (_tmp445_);
				_tmp447_ = _tmp446_;
				_tmp448_ = vala_expression_get_target_value (_tmp447_);
				_tmp449_ = _tmp448_;
				_tmp450_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp449_, (ValaCodeNode*) expr);
				_tmp451_ = _tmp450_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp451_);
				_vala_target_value_unref0 (_tmp451_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp453_ = m;
	if (_tmp453_ != NULL) {
		ValaMethod* _tmp454_;
		gboolean _tmp455_;
		gboolean _tmp456_;
		_tmp454_ = m;
		_tmp455_ = vala_method_get_is_async_callback (_tmp454_);
		_tmp456_ = _tmp455_;
		_tmp452_ = _tmp456_;
	} else {
		_tmp452_ = FALSE;
	}
	if (_tmp452_) {
		ValaMethod* _tmp457_;
		ValaMethod* _tmp458_;
		gboolean _tmp459_;
		gboolean _tmp460_;
		ValaHashMap* _tmp474_;
		ValaMethod* _tmp475_;
		ValaCCodeExpression* _tmp476_;
		ValaHashMap* _tmp477_;
		ValaMethod* _tmp478_;
		ValaCCodeExpression* _tmp479_;
		_tmp457_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp458_ = _tmp457_;
		_tmp459_ = vala_method_get_closure (_tmp458_);
		_tmp460_ = _tmp459_;
		if (_tmp460_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp461_;
			ValaSymbol* _tmp462_;
			ValaSymbol* _tmp463_;
			ValaBlock* _tmp464_;
			ValaBlock* _tmp465_;
			ValaBlock* _tmp466_;
			ValaBlock* _tmp467_;
			gchar* _tmp468_;
			gchar* _tmp469_;
			ValaCCodeExpression* _tmp470_;
			ValaCCodeExpression* _tmp471_;
			ValaCCodeMemberAccess* _tmp472_;
			_tmp461_ = m;
			_tmp462_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp461_);
			_tmp463_ = _tmp462_;
			_tmp464_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp463_, VALA_TYPE_METHOD, ValaMethod));
			_tmp465_ = _tmp464_;
			_tmp466_ = _vala_code_node_ref0 (_tmp465_);
			block = _tmp466_;
			_tmp467_ = block;
			_tmp468_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp467_));
			_tmp469_ = _tmp468_;
			_tmp470_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp469_);
			_tmp471_ = _tmp470_;
			_tmp472_ = vala_ccode_member_access_new_pointer (_tmp471_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp472_;
			_vala_ccode_node_unref0 (_tmp471_);
			_g_free0 (_tmp469_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp473_;
			_tmp473_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp473_;
		}
		_tmp474_ = in_arg_map;
		_tmp475_ = m;
		_tmp476_ = instance;
		vala_map_set ((ValaMap*) _tmp474_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp475_), FALSE)), _tmp476_);
		_tmp477_ = out_arg_map;
		_tmp478_ = m;
		_tmp479_ = instance;
		vala_map_set ((ValaMap*) _tmp477_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp478_), FALSE)), _tmp479_);
	} else {
		gboolean _tmp480_ = FALSE;
		gboolean _tmp481_ = FALSE;
		ValaMethod* _tmp482_;
		_tmp482_ = m;
		if (_tmp482_ != NULL) {
			ValaMethod* _tmp483_;
			ValaMemberBinding _tmp484_;
			ValaMemberBinding _tmp485_;
			_tmp483_ = m;
			_tmp484_ = vala_method_get_binding (_tmp483_);
			_tmp485_ = _tmp484_;
			_tmp481_ = _tmp485_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp481_ = FALSE;
		}
		if (_tmp481_) {
			ValaMethod* _tmp486_;
			_tmp486_ = m;
			_tmp480_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp486_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp480_ = FALSE;
		}
		if (_tmp480_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp487_;
			ValaExpression* _tmp488_;
			ValaExpression* _tmp489_;
			ValaTargetValue* _tmp490_;
			ValaTargetValue* _tmp491_;
			ValaTargetValue* _tmp492_;
			gboolean _tmp493_ = FALSE;
			gboolean _tmp494_ = FALSE;
			ValaMemberAccess* _tmp495_;
			const gchar* _tmp496_;
			const gchar* _tmp497_;
			ValaTargetValue* _tmp519_;
			ValaCCodeExpression* _tmp520_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp521_;
			ValaSymbol* _tmp522_;
			ValaSymbol* _tmp523_;
			ValaStruct* _tmp524_;
			gboolean _tmp525_ = FALSE;
			ValaStruct* _tmp526_;
			ValaMethod* _tmp535_;
			gboolean _tmp536_;
			gboolean _tmp537_;
			_tmp487_ = ma;
			_tmp488_ = vala_member_access_get_inner (_tmp487_);
			_tmp489_ = _tmp488_;
			_tmp490_ = vala_expression_get_target_value (_tmp489_);
			_tmp491_ = _tmp490_;
			_tmp492_ = _vala_target_value_ref0 (_tmp491_);
			instance_value = _tmp492_;
			_tmp495_ = ma;
			_tmp496_ = vala_member_access_get_member_name (_tmp495_);
			_tmp497_ = _tmp496_;
			if (g_strcmp0 (_tmp497_, "begin") == 0) {
				_tmp494_ = TRUE;
			} else {
				ValaMemberAccess* _tmp498_;
				const gchar* _tmp499_;
				const gchar* _tmp500_;
				_tmp498_ = ma;
				_tmp499_ = vala_member_access_get_member_name (_tmp498_);
				_tmp500_ = _tmp499_;
				_tmp494_ = g_strcmp0 (_tmp500_, "end") == 0;
			}
			if (_tmp494_) {
				ValaMemberAccess* _tmp501_;
				ValaExpression* _tmp502_;
				ValaExpression* _tmp503_;
				ValaSymbol* _tmp504_;
				ValaSymbol* _tmp505_;
				ValaMemberAccess* _tmp506_;
				ValaSymbol* _tmp507_;
				ValaSymbol* _tmp508_;
				_tmp501_ = ma;
				_tmp502_ = vala_member_access_get_inner (_tmp501_);
				_tmp503_ = _tmp502_;
				_tmp504_ = vala_expression_get_symbol_reference (_tmp503_);
				_tmp505_ = _tmp504_;
				_tmp506_ = ma;
				_tmp507_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp506_);
				_tmp508_ = _tmp507_;
				_tmp493_ = _tmp505_ == _tmp508_;
			} else {
				_tmp493_ = FALSE;
			}
			if (_tmp493_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp509_;
				ValaExpression* _tmp510_;
				ValaExpression* _tmp511_;
				ValaMemberAccess* _tmp512_;
				ValaMemberAccess* _tmp513_;
				ValaExpression* _tmp514_;
				ValaExpression* _tmp515_;
				ValaTargetValue* _tmp516_;
				ValaTargetValue* _tmp517_;
				ValaTargetValue* _tmp518_;
				_tmp509_ = ma;
				_tmp510_ = vala_member_access_get_inner (_tmp509_);
				_tmp511_ = _tmp510_;
				_tmp512_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp511_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp512_;
				_tmp513_ = inner_ma;
				_tmp514_ = vala_member_access_get_inner (_tmp513_);
				_tmp515_ = _tmp514_;
				_tmp516_ = vala_expression_get_target_value (_tmp515_);
				_tmp517_ = _tmp516_;
				_tmp518_ = _vala_target_value_ref0 (_tmp517_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp518_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp519_ = instance_value;
			_tmp520_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp519_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp520_;
			_tmp521_ = m;
			_tmp522_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp521_);
			_tmp523_ = _tmp522_;
			_tmp524_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp523_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp523_) : NULL);
			st = _tmp524_;
			_tmp526_ = st;
			if (_tmp526_ != NULL) {
				ValaStruct* _tmp527_;
				_tmp527_ = st;
				_tmp525_ = !vala_struct_is_simple_type (_tmp527_);
			} else {
				_tmp525_ = FALSE;
			}
			if (_tmp525_) {
				ValaTargetValue* _tmp528_;
				ValaTargetValue* _tmp531_;
				ValaCCodeExpression* _tmp532_;
				ValaCCodeExpression* _tmp533_;
				ValaCCodeUnaryExpression* _tmp534_;
				_tmp528_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp528_)) {
					ValaTargetValue* _tmp529_;
					ValaTargetValue* _tmp530_;
					_tmp529_ = instance_value;
					_tmp530_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp529_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp530_;
				}
				_tmp531_ = instance_value;
				_tmp532_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp531_);
				_tmp533_ = _tmp532_;
				_tmp534_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp533_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp534_;
				_vala_ccode_node_unref0 (_tmp533_);
			}
			_tmp535_ = m;
			_tmp536_ = vala_method_get_coroutine (_tmp535_);
			_tmp537_ = _tmp536_;
			if (!_tmp537_) {
				ValaHashMap* _tmp538_;
				ValaMethod* _tmp539_;
				ValaCCodeExpression* _tmp540_;
				_tmp538_ = in_arg_map;
				_tmp539_ = m;
				_tmp540_ = instance;
				vala_map_set ((ValaMap*) _tmp538_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp539_), FALSE)), _tmp540_);
			} else {
				gboolean _tmp541_;
				gboolean _tmp542_;
				_tmp541_ = vala_method_call_get_is_yield_expression (expr);
				_tmp542_ = _tmp541_;
				if (_tmp542_) {
					ValaHashMap* _tmp543_;
					ValaMethod* _tmp544_;
					ValaCCodeExpression* _tmp545_;
					ValaMethod* _tmp546_;
					_tmp543_ = in_arg_map;
					_tmp544_ = m;
					_tmp545_ = instance;
					vala_map_set ((ValaMap*) _tmp543_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp544_), FALSE)), _tmp545_);
					_tmp546_ = m;
					if (vala_get_ccode_finish_instance (_tmp546_)) {
						ValaHashMap* _tmp547_;
						ValaMethod* _tmp548_;
						ValaCCodeExpression* _tmp549_;
						_tmp547_ = out_arg_map;
						_tmp548_ = m;
						_tmp549_ = instance;
						vala_map_set ((ValaMap*) _tmp547_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp548_), FALSE)), _tmp549_);
					}
				} else {
					gboolean _tmp550_ = FALSE;
					ValaMemberAccess* _tmp551_;
					const gchar* _tmp552_;
					const gchar* _tmp553_;
					_tmp551_ = ma;
					_tmp552_ = vala_member_access_get_member_name (_tmp551_);
					_tmp553_ = _tmp552_;
					if (g_strcmp0 (_tmp553_, "end") != 0) {
						_tmp550_ = TRUE;
					} else {
						ValaMethod* _tmp554_;
						_tmp554_ = m;
						_tmp550_ = vala_get_ccode_finish_instance (_tmp554_);
					}
					if (_tmp550_) {
						ValaHashMap* _tmp555_;
						ValaMethod* _tmp556_;
						ValaCCodeExpression* _tmp557_;
						ValaHashMap* _tmp558_;
						ValaMethod* _tmp559_;
						ValaCCodeExpression* _tmp560_;
						_tmp555_ = out_arg_map;
						_tmp556_ = m;
						_tmp557_ = instance;
						vala_map_set ((ValaMap*) _tmp555_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp556_), FALSE)), _tmp557_);
						_tmp558_ = in_arg_map;
						_tmp559_ = m;
						_tmp560_ = instance;
						vala_map_set ((ValaMap*) _tmp558_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp559_), FALSE)), _tmp560_);
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp561_ = FALSE;
			ValaMethod* _tmp562_;
			_tmp562_ = m;
			if (_tmp562_ != NULL) {
				ValaMethod* _tmp563_;
				ValaMemberBinding _tmp564_;
				ValaMemberBinding _tmp565_;
				_tmp563_ = m;
				_tmp564_ = vala_method_get_binding (_tmp563_);
				_tmp565_ = _tmp564_;
				_tmp561_ = _tmp565_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp561_ = FALSE;
			}
			if (_tmp561_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp566_;
				ValaSymbol* _tmp567_;
				ValaSymbol* _tmp568_;
				ValaClass* _tmp569_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp570_;
				gchar* _tmp571_;
				gchar* _tmp572_;
				gchar* _tmp573_;
				gchar* _tmp574_;
				ValaCCodeIdentifier* _tmp575_;
				ValaCCodeIdentifier* _tmp576_;
				ValaCCodeFunctionCall* _tmp577_;
				ValaCCodeFunctionCall* _tmp578_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp579_;
				ValaExpression* _tmp580_;
				ValaExpression* _tmp581_;
				ValaCCodeFunctionCall* _tmp607_;
				ValaCCodeExpression* _tmp608_;
				ValaHashMap* _tmp609_;
				ValaMethod* _tmp610_;
				ValaCCodeFunctionCall* _tmp611_;
				ValaHashMap* _tmp612_;
				ValaMethod* _tmp613_;
				ValaCCodeFunctionCall* _tmp614_;
				_tmp566_ = m;
				_tmp567_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp566_);
				_tmp568_ = _tmp567_;
				_tmp569_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp568_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp569_;
				_tmp570_ = cl;
				_tmp571_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp570_, NULL);
				_tmp572_ = _tmp571_;
				_tmp573_ = g_strconcat (_tmp572_, "_CLASS", NULL);
				_tmp574_ = _tmp573_;
				_tmp575_ = vala_ccode_identifier_new (_tmp574_);
				_tmp576_ = _tmp575_;
				_tmp577_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp576_);
				_tmp578_ = _tmp577_;
				_vala_ccode_node_unref0 (_tmp576_);
				_g_free0 (_tmp574_);
				_g_free0 (_tmp572_);
				cast = _tmp578_;
				_tmp579_ = ma;
				_tmp580_ = vala_member_access_get_inner (_tmp579_);
				_tmp581_ = _tmp580_;
				if (_tmp581_ == NULL) {
					ValaDataType* _tmp582_;
					ValaDataType* _tmp583_;
					gboolean _tmp584_;
					_tmp582_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp583_ = _tmp582_;
					_tmp584_ = _tmp583_ == NULL;
					_vala_code_node_unref0 (_tmp583_);
					if (_tmp584_) {
						ValaCCodeIdentifier* _tmp585_;
						_tmp585_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp585_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp586_;
						ValaCCodeIdentifier* _tmp587_;
						ValaCCodeFunctionCall* _tmp588_;
						ValaCCodeFunctionCall* _tmp589_;
						ValaCCodeFunctionCall* _tmp590_;
						ValaCCodeExpression* _tmp591_;
						ValaCCodeExpression* _tmp592_;
						ValaCCodeFunctionCall* _tmp593_;
						ValaCCodeExpression* _tmp594_;
						_tmp586_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp587_ = _tmp586_;
						_tmp588_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp587_);
						_tmp589_ = _tmp588_;
						_vala_ccode_node_unref0 (_tmp587_);
						k = _tmp589_;
						_tmp590_ = k;
						_tmp591_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp592_ = _tmp591_;
						vala_ccode_function_call_add_argument (_tmp590_, _tmp592_);
						_vala_ccode_node_unref0 (_tmp592_);
						_tmp593_ = k;
						_tmp594_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp593_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp594_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp595_;
					ValaCCodeIdentifier* _tmp596_;
					ValaCCodeFunctionCall* _tmp597_;
					ValaCCodeFunctionCall* _tmp598_;
					ValaCCodeFunctionCall* _tmp599_;
					ValaMemberAccess* _tmp600_;
					ValaExpression* _tmp601_;
					ValaExpression* _tmp602_;
					ValaCCodeExpression* _tmp603_;
					ValaCCodeExpression* _tmp604_;
					ValaCCodeFunctionCall* _tmp605_;
					ValaCCodeExpression* _tmp606_;
					_tmp595_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp596_ = _tmp595_;
					_tmp597_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp596_);
					_tmp598_ = _tmp597_;
					_vala_ccode_node_unref0 (_tmp596_);
					k = _tmp598_;
					_tmp599_ = k;
					_tmp600_ = ma;
					_tmp601_ = vala_member_access_get_inner (_tmp600_);
					_tmp602_ = _tmp601_;
					_tmp603_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp602_);
					_tmp604_ = _tmp603_;
					vala_ccode_function_call_add_argument (_tmp599_, _tmp604_);
					_vala_ccode_node_unref0 (_tmp604_);
					_tmp605_ = k;
					_tmp606_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp605_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp606_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp607_ = cast;
				_tmp608_ = klass;
				vala_ccode_function_call_add_argument (_tmp607_, _tmp608_);
				_tmp609_ = in_arg_map;
				_tmp610_ = m;
				_tmp611_ = cast;
				vala_map_set ((ValaMap*) _tmp609_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp610_), FALSE)), (ValaCCodeExpression*) _tmp611_);
				_tmp612_ = out_arg_map;
				_tmp613_ = m;
				_tmp614_ = cast;
				vala_map_set ((ValaMap*) _tmp612_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp613_), FALSE)), (ValaCCodeExpression*) _tmp614_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp616_ = m;
	if (_tmp616_ != NULL) {
		ValaMethod* _tmp617_;
		_tmp617_ = m;
		_tmp615_ = vala_get_ccode_has_generic_type_parameter (_tmp617_);
	} else {
		_tmp615_ = FALSE;
	}
	if (_tmp615_) {
		ValaMethod* _tmp618_;
		ValaList* _tmp619_;
		ValaList* _tmp620_;
		gint _tmp621_;
		gint _tmp622_;
		gboolean _tmp623_;
		_tmp618_ = m;
		_tmp619_ = vala_method_get_type_parameters (_tmp618_);
		_tmp620_ = _tmp619_;
		_tmp621_ = vala_collection_get_size ((ValaCollection*) _tmp620_);
		_tmp622_ = _tmp621_;
		_tmp623_ = _tmp622_ > 0;
		_vala_iterable_unref0 (_tmp620_);
		if (_tmp623_) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp624_;
				ValaList* _tmp625_;
				gint _type_arg_size = 0;
				ValaList* _tmp626_;
				gint _tmp627_;
				gint _tmp628_;
				gint _type_arg_index = 0;
				_tmp624_ = ma;
				_tmp625_ = vala_member_access_get_type_arguments (_tmp624_);
				_type_arg_list = _tmp625_;
				_tmp626_ = _type_arg_list;
				_tmp627_ = vala_collection_get_size ((ValaCollection*) _tmp626_);
				_tmp628_ = _tmp627_;
				_type_arg_size = _tmp628_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp629_;
					gint _tmp630_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp631_;
					gint _tmp632_;
					gpointer _tmp633_;
					gboolean _tmp634_ = FALSE;
					gboolean _tmp635_ = FALSE;
					gboolean _tmp636_ = FALSE;
					ValaMethod* _tmp637_;
					ValaHashMap* _tmp645_;
					ValaMethod* _tmp646_;
					gint _tmp647_;
					ValaDataType* _tmp648_;
					gchar* _tmp649_;
					gchar* _tmp650_;
					ValaCCodeIdentifier* _tmp651_;
					ValaCCodeIdentifier* _tmp652_;
					gint _tmp653_;
					_type_arg_index = _type_arg_index + 1;
					_tmp629_ = _type_arg_index;
					_tmp630_ = _type_arg_size;
					if (!(_tmp629_ < _tmp630_)) {
						break;
					}
					_tmp631_ = _type_arg_list;
					_tmp632_ = _type_arg_index;
					_tmp633_ = vala_list_get (_tmp631_, _tmp632_);
					type_arg = (ValaDataType*) _tmp633_;
					_tmp637_ = m;
					if (vala_get_ccode_simple_generics (_tmp637_)) {
						ValaDataType* _tmp638_;
						_tmp638_ = type_arg;
						_tmp636_ = vala_data_type_is_real_struct_type (_tmp638_);
					} else {
						_tmp636_ = FALSE;
					}
					if (_tmp636_) {
						ValaDataType* _tmp639_;
						gboolean _tmp640_;
						gboolean _tmp641_;
						_tmp639_ = type_arg;
						_tmp640_ = vala_data_type_get_nullable (_tmp639_);
						_tmp641_ = _tmp640_;
						_tmp635_ = !_tmp641_;
					} else {
						_tmp635_ = FALSE;
					}
					if (_tmp635_) {
						ValaDataType* _tmp642_;
						_tmp642_ = type_arg;
						_tmp634_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp642_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp634_ = FALSE;
					}
					if (_tmp634_) {
						ValaDataType* _tmp643_;
						ValaPointerType* _tmp644_;
						_tmp643_ = type_arg;
						_tmp644_ = vala_pointer_type_new (_tmp643_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp644_;
					}
					_tmp645_ = in_arg_map;
					_tmp646_ = m;
					_tmp647_ = type_param_index;
					_tmp648_ = type_arg;
					_tmp649_ = vala_get_ccode_name ((ValaCodeNode*) _tmp648_);
					_tmp650_ = _tmp649_;
					_tmp651_ = vala_ccode_identifier_new (_tmp650_);
					_tmp652_ = _tmp651_;
					vala_map_set ((ValaMap*) _tmp645_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp646_) + (0.01 * _tmp647_), FALSE)), (ValaCCodeExpression*) _tmp652_);
					_vala_ccode_node_unref0 (_tmp652_);
					_g_free0 (_tmp650_);
					_tmp653_ = type_param_index;
					type_param_index = _tmp653_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp654_;
				ValaExpression* _tmp655_;
				ValaExpression* _tmp656_;
				ValaDataType* _tmp657_;
				ValaDataType* _tmp658_;
				ValaList* _tmp659_;
				gint _type_arg_size = 0;
				ValaList* _tmp660_;
				gint _tmp661_;
				gint _tmp662_;
				gint _type_arg_index = 0;
				_tmp654_ = ma;
				_tmp655_ = vala_member_access_get_inner (_tmp654_);
				_tmp656_ = _tmp655_;
				_tmp657_ = vala_expression_get_value_type (_tmp656_);
				_tmp658_ = _tmp657_;
				_tmp659_ = vala_data_type_get_type_arguments (_tmp658_);
				_type_arg_list = _tmp659_;
				_tmp660_ = _type_arg_list;
				_tmp661_ = vala_collection_get_size ((ValaCollection*) _tmp660_);
				_tmp662_ = _tmp661_;
				_type_arg_size = _tmp662_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp663_;
					gint _tmp664_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp665_;
					gint _tmp666_;
					gpointer _tmp667_;
					ValaHashMap* _tmp668_;
					ValaMethod* _tmp669_;
					gint _tmp670_;
					ValaDataType* _tmp671_;
					gchar* _tmp672_;
					gchar* _tmp673_;
					ValaCCodeIdentifier* _tmp674_;
					ValaCCodeIdentifier* _tmp675_;
					gint _tmp676_;
					_type_arg_index = _type_arg_index + 1;
					_tmp663_ = _type_arg_index;
					_tmp664_ = _type_arg_size;
					if (!(_tmp663_ < _tmp664_)) {
						break;
					}
					_tmp665_ = _type_arg_list;
					_tmp666_ = _type_arg_index;
					_tmp667_ = vala_list_get (_tmp665_, _tmp666_);
					type_arg = (ValaDataType*) _tmp667_;
					_tmp668_ = in_arg_map;
					_tmp669_ = m;
					_tmp670_ = type_param_index;
					_tmp671_ = type_arg;
					_tmp672_ = vala_get_ccode_name ((ValaCodeNode*) _tmp671_);
					_tmp673_ = _tmp672_;
					_tmp674_ = vala_ccode_identifier_new (_tmp673_);
					_tmp675_ = _tmp674_;
					vala_map_set ((ValaMap*) _tmp668_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp669_) + (0.01 * _tmp670_), FALSE)), (ValaCCodeExpression*) _tmp675_);
					_vala_ccode_node_unref0 (_tmp675_);
					_g_free0 (_tmp673_);
					_tmp676_ = type_param_index;
					type_param_index = _tmp676_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp677_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp677_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp678_;
		ValaExpression* _tmp679_;
		ValaExpression* _tmp680_;
		ValaDataType* _tmp681_;
		ValaDataType* _tmp682_;
		ValaArrayType* _tmp683_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp684_;
		ValaCCodeIdentifier* _tmp685_;
		ValaCCodeFunctionCall* _tmp686_;
		ValaCCodeFunctionCall* _tmp687_;
		ValaCCodeFunctionCall* _tmp688_;
		ValaArrayType* _tmp689_;
		ValaDataType* _tmp690_;
		ValaDataType* _tmp691_;
		gchar* _tmp692_;
		gchar* _tmp693_;
		ValaCCodeIdentifier* _tmp694_;
		ValaCCodeIdentifier* _tmp695_;
		ValaHashMap* _tmp696_;
		ValaCCodeFunctionCall* _tmp697_;
		_tmp678_ = ma;
		_tmp679_ = vala_member_access_get_inner (_tmp678_);
		_tmp680_ = _tmp679_;
		_tmp681_ = vala_expression_get_value_type (_tmp680_);
		_tmp682_ = _tmp681_;
		_tmp683_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp682_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp683_;
		_tmp684_ = vala_ccode_identifier_new ("sizeof");
		_tmp685_ = _tmp684_;
		_tmp686_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp685_);
		_tmp687_ = _tmp686_;
		_vala_ccode_node_unref0 (_tmp685_);
		csizeof = _tmp687_;
		_tmp688_ = csizeof;
		_tmp689_ = array_type;
		_tmp690_ = vala_array_type_get_element_type (_tmp689_);
		_tmp691_ = _tmp690_;
		_tmp692_ = vala_get_ccode_name ((ValaCodeNode*) _tmp691_);
		_tmp693_ = _tmp692_;
		_tmp694_ = vala_ccode_identifier_new (_tmp693_);
		_tmp695_ = _tmp694_;
		vala_ccode_function_call_add_argument (_tmp688_, (ValaCCodeExpression*) _tmp695_);
		_vala_ccode_node_unref0 (_tmp695_);
		_g_free0 (_tmp693_);
		_tmp696_ = in_arg_map;
		_tmp697_ = csizeof;
		vala_map_set ((ValaMap*) _tmp696_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp697_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp698_;
		_tmp698_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp698_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp699_;
			ValaMethod* _tmp700_;
			ValaMethod* _tmp701_;
			gint param_nr = 0;
			ValaMethod* _tmp770_;
			ValaCCodeBaseModuleEmitContext* _tmp771_;
			_tmp699_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp700_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp699_, (ValaSymbol*) _tmp700_);
			_tmp701_ = m;
			vala_method_clear_parameters (_tmp701_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp702_;
				gint _arg_size = 0;
				ValaList* _tmp703_;
				gint _tmp704_;
				gint _tmp705_;
				gint _arg_index = 0;
				_tmp702_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp702_;
				_tmp703_ = _arg_list;
				_tmp704_ = vala_collection_get_size ((ValaCollection*) _tmp703_);
				_tmp705_ = _tmp704_;
				_arg_size = _tmp705_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp706_;
					gint _tmp707_;
					ValaExpression* arg = NULL;
					ValaList* _tmp708_;
					gint _tmp709_;
					gpointer _tmp710_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp711_;
					ValaUnaryExpression* _tmp712_;
					gboolean _tmp713_ = FALSE;
					ValaUnaryExpression* _tmp714_;
					gint _tmp758_;
					_arg_index = _arg_index + 1;
					_tmp706_ = _arg_index;
					_tmp707_ = _arg_size;
					if (!(_tmp706_ < _tmp707_)) {
						break;
					}
					_tmp708_ = _arg_list;
					_tmp709_ = _arg_index;
					_tmp710_ = vala_list_get (_tmp708_, _tmp709_);
					arg = (ValaExpression*) _tmp710_;
					_tmp711_ = arg;
					_tmp712_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp711_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp711_) : NULL);
					unary = _tmp712_;
					_tmp714_ = unary;
					if (_tmp714_ != NULL) {
						ValaUnaryExpression* _tmp715_;
						ValaUnaryOperator _tmp716_;
						ValaUnaryOperator _tmp717_;
						_tmp715_ = unary;
						_tmp716_ = vala_unary_expression_get_operator (_tmp715_);
						_tmp717_ = _tmp716_;
						_tmp713_ = _tmp717_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp713_ = FALSE;
					}
					if (_tmp713_) {
						ValaParameter* param = NULL;
						gint _tmp718_;
						gchar* _tmp719_;
						gchar* _tmp720_;
						ValaUnaryExpression* _tmp721_;
						ValaExpression* _tmp722_;
						ValaExpression* _tmp723_;
						ValaDataType* _tmp724_;
						ValaDataType* _tmp725_;
						ValaParameter* _tmp726_;
						ValaParameter* _tmp727_;
						ValaParameter* _tmp728_;
						ValaMethod* _tmp729_;
						ValaParameter* _tmp730_;
						_tmp718_ = param_nr;
						_tmp719_ = g_strdup_printf ("param%d", _tmp718_);
						_tmp720_ = _tmp719_;
						_tmp721_ = unary;
						_tmp722_ = vala_unary_expression_get_inner (_tmp721_);
						_tmp723_ = _tmp722_;
						_tmp724_ = vala_expression_get_value_type (_tmp723_);
						_tmp725_ = _tmp724_;
						_tmp726_ = vala_parameter_new (_tmp720_, _tmp725_, NULL);
						_tmp727_ = _tmp726_;
						_g_free0 (_tmp720_);
						param = _tmp727_;
						_tmp728_ = param;
						vala_parameter_set_direction (_tmp728_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp729_ = m;
						_tmp730_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp729_, _tmp730_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp731_ = FALSE;
						ValaUnaryExpression* _tmp732_;
						_tmp732_ = unary;
						if (_tmp732_ != NULL) {
							ValaUnaryExpression* _tmp733_;
							ValaUnaryOperator _tmp734_;
							ValaUnaryOperator _tmp735_;
							_tmp733_ = unary;
							_tmp734_ = vala_unary_expression_get_operator (_tmp733_);
							_tmp735_ = _tmp734_;
							_tmp731_ = _tmp735_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp731_ = FALSE;
						}
						if (_tmp731_) {
							ValaParameter* param = NULL;
							gint _tmp736_;
							gchar* _tmp737_;
							gchar* _tmp738_;
							ValaUnaryExpression* _tmp739_;
							ValaExpression* _tmp740_;
							ValaExpression* _tmp741_;
							ValaDataType* _tmp742_;
							ValaDataType* _tmp743_;
							ValaParameter* _tmp744_;
							ValaParameter* _tmp745_;
							ValaParameter* _tmp746_;
							ValaMethod* _tmp747_;
							ValaParameter* _tmp748_;
							_tmp736_ = param_nr;
							_tmp737_ = g_strdup_printf ("param%d", _tmp736_);
							_tmp738_ = _tmp737_;
							_tmp739_ = unary;
							_tmp740_ = vala_unary_expression_get_inner (_tmp739_);
							_tmp741_ = _tmp740_;
							_tmp742_ = vala_expression_get_value_type (_tmp741_);
							_tmp743_ = _tmp742_;
							_tmp744_ = vala_parameter_new (_tmp738_, _tmp743_, NULL);
							_tmp745_ = _tmp744_;
							_g_free0 (_tmp738_);
							param = _tmp745_;
							_tmp746_ = param;
							vala_parameter_set_direction (_tmp746_, VALA_PARAMETER_DIRECTION_REF);
							_tmp747_ = m;
							_tmp748_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp747_, _tmp748_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp749_;
							gint _tmp750_;
							gchar* _tmp751_;
							gchar* _tmp752_;
							ValaExpression* _tmp753_;
							ValaDataType* _tmp754_;
							ValaDataType* _tmp755_;
							ValaParameter* _tmp756_;
							ValaParameter* _tmp757_;
							_tmp749_ = m;
							_tmp750_ = param_nr;
							_tmp751_ = g_strdup_printf ("param%d", _tmp750_);
							_tmp752_ = _tmp751_;
							_tmp753_ = arg;
							_tmp754_ = vala_expression_get_value_type (_tmp753_);
							_tmp755_ = _tmp754_;
							_tmp756_ = vala_parameter_new (_tmp752_, _tmp755_, NULL);
							_tmp757_ = _tmp756_;
							vala_callable_add_parameter ((ValaCallable*) _tmp749_, _tmp757_);
							_vala_code_node_unref0 (_tmp757_);
							_g_free0 (_tmp752_);
						}
					}
					_tmp758_ = param_nr;
					param_nr = _tmp758_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp759_;
				ValaList* _tmp760_;
				gint _param_size = 0;
				ValaList* _tmp761_;
				gint _tmp762_;
				gint _tmp763_;
				gint _param_index = 0;
				_tmp759_ = m;
				_tmp760_ = vala_callable_get_parameters ((ValaCallable*) _tmp759_);
				_param_list = _tmp760_;
				_tmp761_ = _param_list;
				_tmp762_ = vala_collection_get_size ((ValaCollection*) _tmp761_);
				_tmp763_ = _tmp762_;
				_param_size = _tmp763_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp764_;
					gint _tmp765_;
					ValaParameter* param = NULL;
					ValaList* _tmp766_;
					gint _tmp767_;
					gpointer _tmp768_;
					ValaParameter* _tmp769_;
					_param_index = _param_index + 1;
					_tmp764_ = _param_index;
					_tmp765_ = _param_size;
					if (!(_tmp764_ < _tmp765_)) {
						break;
					}
					_tmp766_ = _param_list;
					_tmp767_ = _param_index;
					_tmp768_ = vala_list_get (_tmp766_, _tmp767_);
					param = (ValaParameter*) _tmp768_;
					_tmp769_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp769_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp770_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp770_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp771_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp771_);
		} else {
			gboolean _tmp772_ = FALSE;
			ValaMethod* _tmp773_;
			_tmp773_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp773_, VALA_TYPE_CREATION_METHOD)) {
				ValaMethod* _tmp774_;
				ValaSymbol* _tmp775_;
				ValaSymbol* _tmp776_;
				_tmp774_ = m;
				_tmp775_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp774_);
				_tmp776_ = _tmp775_;
				_tmp772_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp776_, VALA_TYPE_CLASS);
			} else {
				_tmp772_ = FALSE;
			}
			if (_tmp772_) {
				ValaCCodeFunction* _tmp777_;
				ValaCCodeFunction* _tmp778_;
				ValaCCodeExpression* _tmp779_;
				ValaCCodeExpression* _tmp780_;
				ValaCCodeFunctionCall* _tmp781_;
				ValaClass* _tmp782_;
				ValaClass* _tmp783_;
				gchar* _tmp784_;
				gchar* _tmp785_;
				gchar* _tmp786_;
				gchar* _tmp787_;
				ValaCCodeCastExpression* _tmp788_;
				ValaCCodeCastExpression* _tmp789_;
				ValaMethod* _tmp790_;
				ValaMethod* _tmp791_;
				ValaBlock* _tmp792_;
				ValaBlock* _tmp793_;
				gboolean _tmp794_;
				gboolean _tmp795_;
				gboolean _tmp822_ = FALSE;
				ValaClass* _tmp823_;
				ValaClass* _tmp824_;
				gboolean _tmp825_;
				gboolean _tmp826_;
				_tmp777_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp778_ = _tmp777_;
				_tmp779_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp780_ = _tmp779_;
				_tmp781_ = ccall;
				_tmp782_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp783_ = _tmp782_;
				_tmp784_ = vala_get_ccode_name ((ValaCodeNode*) _tmp783_);
				_tmp785_ = _tmp784_;
				_tmp786_ = g_strconcat (_tmp785_, "*", NULL);
				_tmp787_ = _tmp786_;
				_tmp788_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp781_, _tmp787_);
				_tmp789_ = _tmp788_;
				vala_ccode_function_add_assignment (_tmp778_, _tmp780_, (ValaCCodeExpression*) _tmp789_);
				_vala_ccode_node_unref0 (_tmp789_);
				_g_free0 (_tmp787_);
				_g_free0 (_tmp785_);
				_vala_ccode_node_unref0 (_tmp780_);
				_tmp790_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp791_ = _tmp790_;
				_tmp792_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp791_);
				_tmp793_ = _tmp792_;
				_tmp794_ = vala_block_get_captured (_tmp793_);
				_tmp795_ = _tmp794_;
				if (_tmp795_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp796_;
					ValaClass* _tmp797_;
					ValaObjectType* _tmp798_;
					ValaObjectType* _tmp799_;
					ValaSourceReference* _tmp800_;
					ValaSourceReference* _tmp801_;
					ValaCCodeExpression* _tmp802_;
					ValaCCodeExpression* _tmp803_;
					ValaCCodeFunctionCall* _tmp804_;
					ValaCCodeFunctionCall* _tmp805_;
					ValaCCodeFunctionCall* _tmp806_;
					ValaCCodeExpression* _tmp807_;
					ValaCCodeExpression* _tmp808_;
					ValaCCodeFunction* _tmp809_;
					ValaCCodeFunction* _tmp810_;
					ValaMethod* _tmp811_;
					ValaMethod* _tmp812_;
					ValaBlock* _tmp813_;
					ValaBlock* _tmp814_;
					gchar* _tmp815_;
					gchar* _tmp816_;
					ValaCCodeExpression* _tmp817_;
					ValaCCodeExpression* _tmp818_;
					ValaCCodeMemberAccess* _tmp819_;
					ValaCCodeMemberAccess* _tmp820_;
					ValaCCodeFunctionCall* _tmp821_;
					_tmp796_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp797_ = _tmp796_;
					_tmp798_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp797_);
					_tmp799_ = _tmp798_;
					_tmp800_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp801_ = _tmp800_;
					_tmp802_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp799_, _tmp801_, FALSE);
					_tmp803_ = _tmp802_;
					_tmp804_ = vala_ccode_function_call_new (_tmp803_);
					_tmp805_ = _tmp804_;
					_vala_ccode_node_unref0 (_tmp803_);
					_vala_code_node_unref0 (_tmp799_);
					ref_call = _tmp805_;
					_tmp806_ = ref_call;
					_tmp807_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp808_ = _tmp807_;
					vala_ccode_function_call_add_argument (_tmp806_, _tmp808_);
					_vala_ccode_node_unref0 (_tmp808_);
					_tmp809_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp810_ = _tmp809_;
					_tmp811_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp812_ = _tmp811_;
					_tmp813_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp812_);
					_tmp814_ = _tmp813_;
					_tmp815_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp814_));
					_tmp816_ = _tmp815_;
					_tmp817_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp816_);
					_tmp818_ = _tmp817_;
					_tmp819_ = vala_ccode_member_access_new_pointer (_tmp818_, "self");
					_tmp820_ = _tmp819_;
					_tmp821_ = ref_call;
					vala_ccode_function_add_assignment (_tmp810_, (ValaCCodeExpression*) _tmp820_, (ValaCCodeExpression*) _tmp821_);
					_vala_ccode_node_unref0 (_tmp820_);
					_vala_ccode_node_unref0 (_tmp818_);
					_g_free0 (_tmp816_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp823_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp824_ = _tmp823_;
				_tmp825_ = vala_class_get_is_compact (_tmp824_);
				_tmp826_ = _tmp825_;
				if (!_tmp826_) {
					ValaClass* _tmp827_;
					ValaClass* _tmp828_;
					ValaList* _tmp829_;
					ValaList* _tmp830_;
					gint _tmp831_;
					gint _tmp832_;
					_tmp827_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp828_ = _tmp827_;
					_tmp829_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp828_);
					_tmp830_ = _tmp829_;
					_tmp831_ = vala_collection_get_size ((ValaCollection*) _tmp830_);
					_tmp832_ = _tmp831_;
					_tmp822_ = _tmp832_ > 0;
					_vala_iterable_unref0 (_tmp830_);
				} else {
					_tmp822_ = FALSE;
				}
				if (_tmp822_) {
					gchar** suffices = NULL;
					gchar* _tmp833_;
					gchar* _tmp834_;
					gchar* _tmp835_;
					gchar** _tmp836_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp833_ = g_strdup ("type");
					_tmp834_ = g_strdup ("dup_func");
					_tmp835_ = g_strdup ("destroy_func");
					_tmp836_ = g_new0 (gchar*, 3 + 1);
					_tmp836_[0] = _tmp833_;
					_tmp836_[1] = _tmp834_;
					_tmp836_[2] = _tmp835_;
					suffices = _tmp836_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp837_;
						ValaClass* _tmp838_;
						ValaList* _tmp839_;
						gint _type_param_size = 0;
						ValaList* _tmp840_;
						gint _tmp841_;
						gint _tmp842_;
						gint _type_param_index = 0;
						_tmp837_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp838_ = _tmp837_;
						_tmp839_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp838_);
						_type_param_list = _tmp839_;
						_tmp840_ = _type_param_list;
						_tmp841_ = vala_collection_get_size ((ValaCollection*) _tmp840_);
						_tmp842_ = _tmp841_;
						_type_param_size = _tmp842_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp843_;
							gint _tmp844_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp845_;
							gint _tmp846_;
							gpointer _tmp847_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp848_;
							ValaCCodeIdentifier* _tmp849_;
							ValaCCodeMemberAccess* _tmp850_;
							ValaCCodeMemberAccess* _tmp851_;
							gchar** _tmp852_;
							gint _tmp852__length1;
							_type_param_index = _type_param_index + 1;
							_tmp843_ = _type_param_index;
							_tmp844_ = _type_param_size;
							if (!(_tmp843_ < _tmp844_)) {
								break;
							}
							_tmp845_ = _type_param_list;
							_tmp846_ = _type_param_index;
							_tmp847_ = vala_list_get (_tmp845_, _tmp846_);
							type_param = (ValaTypeParameter*) _tmp847_;
							_tmp848_ = vala_ccode_identifier_new ("self");
							_tmp849_ = _tmp848_;
							_tmp850_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp849_, "priv");
							_tmp851_ = _tmp850_;
							_vala_ccode_node_unref0 (_tmp849_);
							priv_access = _tmp851_;
							_tmp852_ = suffices;
							_tmp852__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp852_;
								suffix_collection_length1 = _tmp852__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp853_;
									gchar* suffix = NULL;
									_tmp853_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp853_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp854_;
										const gchar* _tmp855_;
										const gchar* _tmp856_;
										gchar* _tmp857_;
										gchar* _tmp858_;
										const gchar* _tmp859_;
										gchar* _tmp860_;
										gchar* _tmp861_;
										ValaCCodeIdentifier* _tmp862_;
										ValaCCodeIdentifier* _tmp863_;
										ValaCCodeFunction* _tmp864_;
										ValaCCodeFunction* _tmp865_;
										ValaCCodeMemberAccess* _tmp866_;
										ValaCCodeIdentifier* _tmp867_;
										const gchar* _tmp868_;
										const gchar* _tmp869_;
										ValaCCodeMemberAccess* _tmp870_;
										ValaCCodeMemberAccess* _tmp871_;
										ValaCCodeIdentifier* _tmp872_;
										_tmp854_ = type_param;
										_tmp855_ = vala_symbol_get_name ((ValaSymbol*) _tmp854_);
										_tmp856_ = _tmp855_;
										_tmp857_ = g_ascii_strdown (_tmp856_, (gssize) -1);
										_tmp858_ = _tmp857_;
										_tmp859_ = suffix;
										_tmp860_ = g_strdup_printf ("%s_%s", _tmp858_, _tmp859_);
										_tmp861_ = _tmp860_;
										_tmp862_ = vala_ccode_identifier_new (_tmp861_);
										_tmp863_ = _tmp862_;
										_g_free0 (_tmp861_);
										_g_free0 (_tmp858_);
										param_name = _tmp863_;
										_tmp864_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp865_ = _tmp864_;
										_tmp866_ = priv_access;
										_tmp867_ = param_name;
										_tmp868_ = vala_ccode_identifier_get_name (_tmp867_);
										_tmp869_ = _tmp868_;
										_tmp870_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp866_, _tmp869_);
										_tmp871_ = _tmp870_;
										_tmp872_ = param_name;
										vala_ccode_function_add_assignment (_tmp865_, (ValaCCodeExpression*) _tmp871_, (ValaCCodeExpression*) _tmp872_);
										_vala_ccode_node_unref0 (_tmp871_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp873_ = params;
	_tmp874_ = vala_iterable_iterator ((ValaIterable*) _tmp873_);
	params_it = _tmp874_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp875_;
		gint _arg_size = 0;
		ValaList* _tmp876_;
		gint _tmp877_;
		gint _tmp878_;
		gint _arg_index = 0;
		_tmp875_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp875_;
		_tmp876_ = _arg_list;
		_tmp877_ = vala_collection_get_size ((ValaCollection*) _tmp876_);
		_tmp878_ = _tmp877_;
		_arg_size = _tmp878_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp879_;
			gint _tmp880_;
			ValaExpression* arg = NULL;
			ValaList* _tmp881_;
			gint _tmp882_;
			gpointer _tmp883_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp884_;
			ValaCCodeExpression* _tmp885_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp886_;
			ValaHashMap* _tmp887_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp888_;
			gboolean _tmp898_ = FALSE;
			ValaParameter* _tmp899_;
			gdouble _tmp1237_ = 0.0;
			gboolean _tmp1238_ = FALSE;
			ValaParameter* _tmp1239_;
			gboolean _tmp1243_;
			ValaHashMap* _tmp1244_;
			gint _tmp1245_;
			ValaCCodeExpression* _tmp1246_;
			gboolean _tmp1247_ = FALSE;
			ValaExpression* _tmp1248_;
			gint _tmp1268_;
			_arg_index = _arg_index + 1;
			_tmp879_ = _arg_index;
			_tmp880_ = _arg_size;
			if (!(_tmp879_ < _tmp880_)) {
				break;
			}
			_tmp881_ = _arg_list;
			_tmp882_ = _arg_index;
			_tmp883_ = vala_list_get (_tmp881_, _tmp882_);
			arg = (ValaExpression*) _tmp883_;
			_tmp884_ = arg;
			_tmp885_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp884_);
			cexpr = _tmp885_;
			_tmp886_ = in_arg_map;
			_tmp887_ = _vala_map_ref0 (_tmp886_);
			carg_map = _tmp887_;
			param = NULL;
			_tmp888_ = params_it;
			if (vala_iterator_next (_tmp888_)) {
				ValaIterator* _tmp889_;
				gpointer _tmp890_;
				gboolean _tmp891_ = FALSE;
				ValaParameter* _tmp892_;
				gboolean _tmp893_;
				gboolean _tmp894_;
				_tmp889_ = params_it;
				_tmp890_ = vala_iterator_get (_tmp889_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp890_;
				_tmp892_ = param;
				_tmp893_ = vala_parameter_get_params_array (_tmp892_);
				_tmp894_ = _tmp893_;
				if (_tmp894_) {
					_tmp891_ = TRUE;
				} else {
					ValaParameter* _tmp895_;
					gboolean _tmp896_;
					gboolean _tmp897_;
					_tmp895_ = param;
					_tmp896_ = vala_parameter_get_ellipsis (_tmp895_);
					_tmp897_ = _tmp896_;
					_tmp891_ = _tmp897_;
				}
				ellipsis = _tmp891_;
			}
			_tmp899_ = param;
			if (_tmp899_ != NULL) {
				gboolean _tmp900_;
				_tmp900_ = ellipsis;
				_tmp898_ = !_tmp900_;
			} else {
				_tmp898_ = FALSE;
			}
			if (_tmp898_) {
				ValaParameter* _tmp901_;
				ValaParameterDirection _tmp902_;
				ValaParameterDirection _tmp903_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp906_;
				ValaUnaryExpression* _tmp907_;
				gboolean _tmp908_ = FALSE;
				ValaUnaryExpression* _tmp909_;
				ValaParameter* _tmp1187_;
				gchar* _tmp1188_;
				gchar* _tmp1189_;
				gboolean _tmp1190_;
				_tmp901_ = param;
				_tmp902_ = vala_parameter_get_direction (_tmp901_);
				_tmp903_ = _tmp902_;
				if (_tmp903_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp904_;
					ValaHashMap* _tmp905_;
					_tmp904_ = out_arg_map;
					_tmp905_ = _vala_map_ref0 (_tmp904_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp905_;
				}
				_tmp906_ = arg;
				_tmp907_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp906_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp906_) : NULL);
				unary = _tmp907_;
				_tmp909_ = unary;
				if (_tmp909_ == NULL) {
					_tmp908_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp910_;
					ValaUnaryOperator _tmp911_;
					ValaUnaryOperator _tmp912_;
					_tmp910_ = unary;
					_tmp911_ = vala_unary_expression_get_operator (_tmp910_);
					_tmp912_ = _tmp911_;
					_tmp908_ = _tmp912_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp908_) {
					gboolean _tmp913_ = FALSE;
					gboolean _tmp914_ = FALSE;
					ValaParameter* _tmp915_;
					ValaParameter* _tmp1057_;
					ValaExpression* _tmp1058_;
					ValaCCodeExpression* _tmp1059_;
					ValaCCodeExpression* _tmp1060_;
					_tmp915_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp915_)) {
						ValaParameter* _tmp916_;
						ValaDataType* _tmp917_;
						ValaDataType* _tmp918_;
						_tmp916_ = param;
						_tmp917_ = vala_variable_get_variable_type ((ValaVariable*) _tmp916_);
						_tmp918_ = _tmp917_;
						_tmp914_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp918_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp914_ = FALSE;
					}
					if (_tmp914_) {
						ValaParameter* _tmp919_;
						ValaDataType* _tmp920_;
						ValaDataType* _tmp921_;
						gboolean _tmp922_;
						gboolean _tmp923_;
						_tmp919_ = param;
						_tmp920_ = vala_variable_get_variable_type ((ValaVariable*) _tmp919_);
						_tmp921_ = _tmp920_;
						_tmp922_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp921_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp923_ = _tmp922_;
						_tmp913_ = !_tmp923_;
					} else {
						_tmp913_ = FALSE;
					}
					if (_tmp913_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp924_;
						ValaDataType* _tmp925_;
						ValaDataType* _tmp926_;
						ValaArrayType* _tmp927_;
						_tmp924_ = param;
						_tmp925_ = vala_variable_get_variable_type ((ValaVariable*) _tmp924_);
						_tmp926_ = _tmp925_;
						_tmp927_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp926_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp927_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp928_ = FALSE;
								_tmp928_ = TRUE;
								while (TRUE) {
									gint _tmp930_;
									ValaArrayType* _tmp931_;
									gint _tmp932_;
									gint _tmp933_;
									ValaCCodeExpression* array_length_expr = NULL;
									ValaParameter* _tmp934_;
									gchar* _tmp935_;
									gchar* _tmp936_;
									gboolean _tmp937_;
									ValaHashMap* _tmp956_;
									ValaParameter* _tmp957_;
									gint _tmp958_;
									ValaCCodeExpression* _tmp959_;
									if (!_tmp928_) {
										gint _tmp929_;
										_tmp929_ = dim;
										dim = _tmp929_ + 1;
									}
									_tmp928_ = FALSE;
									_tmp930_ = dim;
									_tmp931_ = array_type;
									_tmp932_ = vala_array_type_get_rank (_tmp931_);
									_tmp933_ = _tmp932_;
									if (!(_tmp930_ <= _tmp933_)) {
										break;
									}
									array_length_expr = NULL;
									_tmp934_ = param;
									_tmp935_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp934_);
									_tmp936_ = _tmp935_;
									_tmp937_ = _tmp936_ != NULL;
									_g_free0 (_tmp936_);
									if (_tmp937_) {
										gchar* length_ctype = NULL;
										ValaParameter* _tmp938_;
										gchar* _tmp939_;
										gboolean _tmp940_ = FALSE;
										ValaUnaryExpression* _tmp941_;
										ValaExpression* _tmp947_;
										gint _tmp948_;
										ValaCCodeExpression* _tmp949_;
										ValaCCodeExpression* _tmp950_;
										const gchar* _tmp951_;
										ValaCCodeCastExpression* _tmp952_;
										_tmp938_ = param;
										_tmp939_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp938_);
										length_ctype = _tmp939_;
										_tmp941_ = unary;
										if (_tmp941_ != NULL) {
											ValaUnaryExpression* _tmp942_;
											ValaUnaryOperator _tmp943_;
											ValaUnaryOperator _tmp944_;
											_tmp942_ = unary;
											_tmp943_ = vala_unary_expression_get_operator (_tmp942_);
											_tmp944_ = _tmp943_;
											_tmp940_ = _tmp944_ == VALA_UNARY_OPERATOR_REF;
										} else {
											_tmp940_ = FALSE;
										}
										if (_tmp940_) {
											const gchar* _tmp945_;
											gchar* _tmp946_;
											_tmp945_ = length_ctype;
											_tmp946_ = g_strdup_printf ("%s*", _tmp945_);
											_g_free0 (length_ctype);
											length_ctype = _tmp946_;
										}
										_tmp947_ = arg;
										_tmp948_ = dim;
										_tmp949_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp947_, _tmp948_);
										_tmp950_ = _tmp949_;
										_tmp951_ = length_ctype;
										_tmp952_ = vala_ccode_cast_expression_new (_tmp950_, _tmp951_);
										_vala_ccode_node_unref0 (array_length_expr);
										array_length_expr = (ValaCCodeExpression*) _tmp952_;
										_vala_ccode_node_unref0 (_tmp950_);
										_g_free0 (length_ctype);
									} else {
										ValaExpression* _tmp953_;
										gint _tmp954_;
										ValaCCodeExpression* _tmp955_;
										_tmp953_ = arg;
										_tmp954_ = dim;
										_tmp955_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp953_, _tmp954_);
										_vala_ccode_node_unref0 (array_length_expr);
										array_length_expr = _tmp955_;
									}
									_tmp956_ = carg_map;
									_tmp957_ = param;
									_tmp958_ = dim;
									_tmp959_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp956_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp957_) + (0.01 * _tmp958_), FALSE)), _tmp959_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp960_;
						ValaDataType* _tmp961_;
						ValaDataType* _tmp962_;
						_tmp960_ = param;
						_tmp961_ = vala_variable_get_variable_type ((ValaVariable*) _tmp960_);
						_tmp962_ = _tmp961_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp962_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp963_;
							ValaDataType* _tmp964_;
							ValaDataType* _tmp965_;
							ValaDelegateType* _tmp966_;
							ValaDelegateType* _tmp967_;
							ValaDelegate* _tmp968_;
							ValaDelegate* _tmp969_;
							gboolean _tmp970_;
							gboolean _tmp971_;
							_tmp963_ = param;
							_tmp964_ = vala_variable_get_variable_type ((ValaVariable*) _tmp963_);
							_tmp965_ = _tmp964_;
							_tmp966_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp965_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp966_;
							_tmp967_ = deleg_type;
							_tmp968_ = vala_delegate_type_get_delegate_symbol (_tmp967_);
							_tmp969_ = _tmp968_;
							_tmp970_ = vala_delegate_get_has_target (_tmp969_);
							_tmp971_ = _tmp970_;
							if (_tmp971_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp972_;
								ValaCCodeExpression* _tmp973_ = NULL;
								ValaCCodeExpression* _tmp974_;
								ValaCCodeExpression* _tmp975_;
								ValaParameter* _tmp976_;
								gchar* _tmp977_;
								gchar* _tmp978_;
								gboolean _tmp979_;
								_tmp972_ = arg;
								_tmp974_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp972_, &_tmp973_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp973_;
								delegate_target = _tmp974_;
								_tmp975_ = delegate_target;
								_vala_assert (_tmp975_ != NULL, "delegate_target != null");
								_tmp976_ = param;
								_tmp977_ = vala_get_ccode_type ((ValaCodeNode*) _tmp976_);
								_tmp978_ = _tmp977_;
								_tmp979_ = g_strcmp0 (_tmp978_, "GClosure*") == 0;
								_g_free0 (_tmp978_);
								if (_tmp979_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp980_;
									ValaCCodeIdentifier* _tmp981_;
									ValaCCodeFunctionCall* _tmp982_;
									ValaCCodeFunctionCall* _tmp983_;
									ValaCCodeFunctionCall* _tmp984_;
									ValaCCodeExpression* _tmp985_;
									ValaCCodeCastExpression* _tmp986_;
									ValaCCodeCastExpression* _tmp987_;
									ValaCCodeFunctionCall* _tmp988_;
									ValaCCodeExpression* _tmp989_;
									ValaCCodeFunctionCall* _tmp990_;
									ValaCCodeExpression* _tmp991_;
									ValaCCodeCastExpression* _tmp992_;
									ValaCCodeCastExpression* _tmp993_;
									ValaCCodeExpression* _tmp994_;
									ValaCCodeIdentifier* _tmp995_;
									ValaCCodeIdentifier* _tmp996_;
									ValaCCodeBinaryExpression* _tmp997_;
									ValaCCodeBinaryExpression* _tmp998_;
									ValaCCodeIdentifier* _tmp999_;
									ValaCCodeIdentifier* _tmp1000_;
									ValaCCodeFunctionCall* _tmp1001_;
									ValaCCodeConditionalExpression* _tmp1002_;
									_tmp980_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp981_ = _tmp980_;
									_tmp982_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp981_);
									_tmp983_ = _tmp982_;
									_vala_ccode_node_unref0 (_tmp981_);
									closure_new = _tmp983_;
									_tmp984_ = closure_new;
									_tmp985_ = cexpr;
									_tmp986_ = vala_ccode_cast_expression_new (_tmp985_, "GCallback");
									_tmp987_ = _tmp986_;
									vala_ccode_function_call_add_argument (_tmp984_, (ValaCCodeExpression*) _tmp987_);
									_vala_ccode_node_unref0 (_tmp987_);
									_tmp988_ = closure_new;
									_tmp989_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp988_, _tmp989_);
									_tmp990_ = closure_new;
									_tmp991_ = delegate_target_destroy_notify;
									_tmp992_ = vala_ccode_cast_expression_new (_tmp991_, "GClosureNotify");
									_tmp993_ = _tmp992_;
									vala_ccode_function_call_add_argument (_tmp990_, (ValaCCodeExpression*) _tmp993_);
									_vala_ccode_node_unref0 (_tmp993_);
									_tmp994_ = cexpr;
									_tmp995_ = vala_ccode_identifier_new ("NULL");
									_tmp996_ = _tmp995_;
									_tmp997_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp994_, (ValaCCodeExpression*) _tmp996_);
									_tmp998_ = _tmp997_;
									_tmp999_ = vala_ccode_identifier_new ("NULL");
									_tmp1000_ = _tmp999_;
									_tmp1001_ = closure_new;
									_tmp1002_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp998_, (ValaCCodeExpression*) _tmp1000_, (ValaCCodeExpression*) _tmp1001_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1002_;
									_vala_ccode_node_unref0 (_tmp1000_);
									_vala_ccode_node_unref0 (_tmp998_);
									_vala_ccode_node_unref0 (_tmp996_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaHashMap* _tmp1003_;
									ValaParameter* _tmp1004_;
									ValaCCodeExpression* _tmp1005_;
									ValaDelegateType* _tmp1006_;
									_tmp1003_ = carg_map;
									_tmp1004_ = param;
									_tmp1005_ = delegate_target;
									vala_map_set ((ValaMap*) _tmp1003_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1004_), FALSE)), _tmp1005_);
									_tmp1006_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1006_)) {
										ValaCCodeExpression* _tmp1007_;
										ValaHashMap* _tmp1008_;
										ValaParameter* _tmp1009_;
										ValaCCodeExpression* _tmp1010_;
										_tmp1007_ = delegate_target_destroy_notify;
										_vala_assert (_tmp1007_ != NULL, "delegate_target_destroy_notify != null");
										_tmp1008_ = carg_map;
										_tmp1009_ = param;
										_tmp1010_ = delegate_target_destroy_notify;
										vala_map_set ((ValaMap*) _tmp1008_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1009_) + 0.01, FALSE)), _tmp1010_);
									}
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1011_;
							ValaDataType* _tmp1012_;
							ValaDataType* _tmp1013_;
							_tmp1011_ = param;
							_tmp1012_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1011_);
							_tmp1013_ = _tmp1012_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1013_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1014_;
								ValaParameter* _tmp1015_;
								ValaExpression* _tmp1016_;
								ValaCCodeExpression* _tmp1017_ = NULL;
								ValaCCodeExpression* _tmp1018_;
								ValaCCodeExpression* _tmp1019_;
								_tmp1014_ = carg_map;
								_tmp1015_ = param;
								_tmp1016_ = arg;
								_tmp1018_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1016_, &_tmp1017_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1017_;
								_tmp1019_ = _tmp1018_;
								vala_map_set ((ValaMap*) _tmp1014_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1015_), FALSE)), _tmp1019_);
								_vala_ccode_node_unref0 (_tmp1019_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1020_;
								ValaDataType* _tmp1021_;
								ValaDataType* _tmp1022_;
								_tmp1020_ = param;
								_tmp1021_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1020_);
								_tmp1022_ = _tmp1021_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1022_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1023_ = FALSE;
									ValaMethod* _tmp1024_;
									_tmp1024_ = m;
									if (_tmp1024_ != NULL) {
										ValaMethod* _tmp1025_;
										_tmp1025_ = m;
										_tmp1023_ = vala_get_ccode_simple_generics (_tmp1025_);
									} else {
										_tmp1023_ = FALSE;
									}
									if (_tmp1023_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1026_;
										ValaDataType* _tmp1027_;
										ValaDataType* _tmp1028_;
										ValaGenericType* _tmp1029_;
										gint type_param_index = 0;
										ValaMethod* _tmp1030_;
										ValaGenericType* _tmp1031_;
										ValaTypeParameter* _tmp1032_;
										ValaTypeParameter* _tmp1033_;
										const gchar* _tmp1034_;
										const gchar* _tmp1035_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1036_;
										ValaList* _tmp1037_;
										ValaList* _tmp1038_;
										gint _tmp1039_;
										gpointer _tmp1040_;
										ValaDataType* _tmp1041_;
										ValaParameter* _tmp1042_;
										ValaDataType* _tmp1043_;
										ValaDataType* _tmp1044_;
										gboolean _tmp1045_;
										gboolean _tmp1046_;
										_tmp1026_ = param;
										_tmp1027_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1026_);
										_tmp1028_ = _tmp1027_;
										_tmp1029_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1028_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1029_;
										_tmp1030_ = m;
										_tmp1031_ = generic_type;
										_tmp1032_ = vala_generic_type_get_type_parameter (_tmp1031_);
										_tmp1033_ = _tmp1032_;
										_tmp1034_ = vala_symbol_get_name ((ValaSymbol*) _tmp1033_);
										_tmp1035_ = _tmp1034_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1030_, _tmp1035_);
										_tmp1036_ = ma;
										_tmp1037_ = vala_member_access_get_type_arguments (_tmp1036_);
										_tmp1038_ = _tmp1037_;
										_tmp1039_ = type_param_index;
										_tmp1040_ = vala_list_get (_tmp1038_, _tmp1039_);
										_tmp1041_ = (ValaDataType*) _tmp1040_;
										_vala_iterable_unref0 (_tmp1038_);
										type_arg = _tmp1041_;
										_tmp1042_ = param;
										_tmp1043_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1042_);
										_tmp1044_ = _tmp1043_;
										_tmp1045_ = vala_data_type_get_value_owned (_tmp1044_);
										_tmp1046_ = _tmp1045_;
										if (_tmp1046_) {
											ValaDataType* _tmp1047_;
											_tmp1047_ = type_arg;
											if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1047_)) {
												ValaHashMap* _tmp1048_;
												ValaParameter* _tmp1049_;
												ValaDataType* _tmp1050_;
												ValaCCodeExpression* _tmp1051_;
												ValaCCodeExpression* _tmp1052_;
												_tmp1048_ = carg_map;
												_tmp1049_ = param;
												_tmp1050_ = type_arg;
												_tmp1051_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1050_, FALSE);
												_tmp1052_ = _tmp1051_;
												vala_map_set ((ValaMap*) _tmp1048_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1049_), FALSE)), _tmp1052_);
												_vala_ccode_node_unref0 (_tmp1052_);
											} else {
												ValaHashMap* _tmp1053_;
												ValaParameter* _tmp1054_;
												ValaCCodeConstant* _tmp1055_;
												ValaCCodeConstant* _tmp1056_;
												_tmp1053_ = carg_map;
												_tmp1054_ = param;
												_tmp1055_ = vala_ccode_constant_new ("NULL");
												_tmp1056_ = _tmp1055_;
												vala_map_set ((ValaMap*) _tmp1053_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1054_), FALSE)), (ValaCCodeExpression*) _tmp1056_);
												_vala_ccode_node_unref0 (_tmp1056_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1057_ = param;
					_tmp1058_ = arg;
					_tmp1059_ = cexpr;
					_tmp1060_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1057_, _tmp1058_, _tmp1059_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1060_;
				} else {
					ValaExpression* _tmp1061_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1062_;
					ValaDataType* _tmp1063_;
					ValaDataType* _tmp1064_;
					ValaParameter* _tmp1065_;
					ValaDataType* _tmp1066_;
					ValaDataType* _tmp1067_;
					gboolean _tmp1068_;
					gboolean _tmp1069_;
					ValaLocalVariable* _tmp1070_;
					ValaLocalVariable* _tmp1071_;
					ValaExpression* _tmp1072_;
					ValaLocalVariable* _tmp1073_;
					const gchar* _tmp1074_;
					const gchar* _tmp1075_;
					ValaCCodeExpression* _tmp1076_;
					ValaCCodeExpression* _tmp1077_;
					ValaExpression* _tmp1078_;
					ValaTargetValue* _tmp1079_;
					ValaTargetValue* _tmp1080_;
					ValaExpression* _tmp1081_;
					ValaDataType* _tmp1082_;
					ValaDataType* _tmp1083_;
					ValaExpression* _tmp1084_;
					ValaCCodeExpression* _tmp1085_;
					ValaCCodeExpression* _tmp1086_;
					ValaCCodeUnaryExpression* _tmp1087_;
					gboolean _tmp1088_ = FALSE;
					gboolean _tmp1089_ = FALSE;
					ValaParameter* _tmp1090_;
					_tmp1061_ = arg;
					vala_expression_set_target_value (_tmp1061_, NULL);
					_tmp1062_ = param;
					_tmp1063_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1062_);
					_tmp1064_ = _tmp1063_;
					_tmp1065_ = param;
					_tmp1066_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1065_);
					_tmp1067_ = _tmp1066_;
					_tmp1068_ = vala_data_type_get_value_owned (_tmp1067_);
					_tmp1069_ = _tmp1068_;
					_tmp1070_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1064_, _tmp1069_, NULL, TRUE);
					temp_var = _tmp1070_;
					_tmp1071_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1071_, FALSE);
					_tmp1072_ = arg;
					_tmp1073_ = temp_var;
					_tmp1074_ = vala_symbol_get_name ((ValaSymbol*) _tmp1073_);
					_tmp1075_ = _tmp1074_;
					_tmp1076_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1075_);
					_tmp1077_ = _tmp1076_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1072_, _tmp1077_);
					_vala_ccode_node_unref0 (_tmp1077_);
					_tmp1078_ = arg;
					_tmp1079_ = vala_expression_get_target_value (_tmp1078_);
					_tmp1080_ = _tmp1079_;
					_tmp1081_ = arg;
					_tmp1082_ = vala_expression_get_target_type (_tmp1081_);
					_tmp1083_ = _tmp1082_;
					vala_target_value_set_value_type (_tmp1080_, _tmp1083_);
					_tmp1084_ = arg;
					_tmp1085_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1084_);
					_tmp1086_ = _tmp1085_;
					_tmp1087_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1086_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1087_;
					_vala_ccode_node_unref0 (_tmp1086_);
					_tmp1090_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1090_)) {
						ValaParameter* _tmp1091_;
						ValaDataType* _tmp1092_;
						ValaDataType* _tmp1093_;
						_tmp1091_ = param;
						_tmp1092_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1091_);
						_tmp1093_ = _tmp1092_;
						_tmp1089_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1093_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1089_ = FALSE;
					}
					if (_tmp1089_) {
						ValaParameter* _tmp1094_;
						ValaDataType* _tmp1095_;
						ValaDataType* _tmp1096_;
						gboolean _tmp1097_;
						gboolean _tmp1098_;
						_tmp1094_ = param;
						_tmp1095_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1094_);
						_tmp1096_ = _tmp1095_;
						_tmp1097_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1096_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1098_ = _tmp1097_;
						_tmp1088_ = !_tmp1098_;
					} else {
						_tmp1088_ = FALSE;
					}
					if (_tmp1088_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1099_;
						ValaDataType* _tmp1100_;
						ValaDataType* _tmp1101_;
						ValaArrayType* _tmp1102_;
						ValaDataType* array_length_type = NULL;
						ValaDataType* _tmp1103_;
						ValaDataType* _tmp1104_;
						ValaParameter* _tmp1105_;
						gchar* _tmp1106_;
						gchar* _tmp1107_;
						gboolean _tmp1108_;
						_tmp1099_ = param;
						_tmp1100_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1099_);
						_tmp1101_ = _tmp1100_;
						_tmp1102_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1101_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1102_;
						_tmp1103_ = ((ValaCCodeBaseModule*) self)->int_type;
						_tmp1104_ = _vala_code_node_ref0 (_tmp1103_);
						array_length_type = _tmp1104_;
						_tmp1105_ = param;
						_tmp1106_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1105_);
						_tmp1107_ = _tmp1106_;
						_tmp1108_ = _tmp1107_ != NULL;
						_g_free0 (_tmp1107_);
						if (_tmp1108_) {
							ValaParameter* _tmp1109_;
							gchar* _tmp1110_;
							gchar* _tmp1111_;
							ValaCType* _tmp1112_;
							_tmp1109_ = param;
							_tmp1110_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1109_);
							_tmp1111_ = _tmp1110_;
							_tmp1112_ = vala_ctype_new (_tmp1111_, "0");
							_vala_code_node_unref0 (array_length_type);
							array_length_type = (ValaDataType*) _tmp1112_;
							_g_free0 (_tmp1111_);
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1113_ = FALSE;
								_tmp1113_ = TRUE;
								while (TRUE) {
									gint _tmp1115_;
									ValaArrayType* _tmp1116_;
									gint _tmp1117_;
									gint _tmp1118_;
									ValaLocalVariable* temp_array_length = NULL;
									ValaDataType* _tmp1119_;
									ValaLocalVariable* _tmp1120_;
									ValaLocalVariable* _tmp1121_;
									ValaExpression* _tmp1122_;
									ValaLocalVariable* _tmp1123_;
									const gchar* _tmp1124_;
									const gchar* _tmp1125_;
									ValaCCodeExpression* _tmp1126_;
									ValaCCodeExpression* _tmp1127_;
									ValaHashMap* _tmp1128_;
									ValaParameter* _tmp1129_;
									gint _tmp1130_;
									ValaExpression* _tmp1131_;
									ValaList* _tmp1132_;
									ValaList* _tmp1133_;
									gint _tmp1134_;
									gpointer _tmp1135_;
									ValaCCodeExpression* _tmp1136_;
									ValaCCodeUnaryExpression* _tmp1137_;
									ValaCCodeUnaryExpression* _tmp1138_;
									if (!_tmp1113_) {
										gint _tmp1114_;
										_tmp1114_ = dim;
										dim = _tmp1114_ + 1;
									}
									_tmp1113_ = FALSE;
									_tmp1115_ = dim;
									_tmp1116_ = array_type;
									_tmp1117_ = vala_array_type_get_rank (_tmp1116_);
									_tmp1118_ = _tmp1117_;
									if (!(_tmp1115_ <= _tmp1118_)) {
										break;
									}
									_tmp1119_ = array_length_type;
									_tmp1120_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1119_, TRUE, NULL, FALSE);
									temp_array_length = _tmp1120_;
									_tmp1121_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1121_, FALSE);
									_tmp1122_ = arg;
									_tmp1123_ = temp_array_length;
									_tmp1124_ = vala_symbol_get_name ((ValaSymbol*) _tmp1123_);
									_tmp1125_ = _tmp1124_;
									_tmp1126_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1125_);
									_tmp1127_ = _tmp1126_;
									vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1122_, _tmp1127_);
									_vala_ccode_node_unref0 (_tmp1127_);
									_tmp1128_ = carg_map;
									_tmp1129_ = param;
									_tmp1130_ = dim;
									_tmp1131_ = arg;
									_tmp1132_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1131_);
									_tmp1133_ = _tmp1132_;
									_tmp1134_ = dim;
									_tmp1135_ = vala_list_get (_tmp1133_, _tmp1134_ - 1);
									_tmp1136_ = (ValaCCodeExpression*) _tmp1135_;
									_tmp1137_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1136_);
									_tmp1138_ = _tmp1137_;
									vala_map_set ((ValaMap*) _tmp1128_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1129_) + (0.01 * _tmp1130_), FALSE)), (ValaCCodeExpression*) _tmp1138_);
									_vala_ccode_node_unref0 (_tmp1138_);
									_vala_ccode_node_unref0 (_tmp1136_);
									_vala_iterable_unref0 (_tmp1133_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_vala_code_node_unref0 (array_length_type);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp1139_;
						ValaDataType* _tmp1140_;
						ValaDataType* _tmp1141_;
						_tmp1139_ = param;
						_tmp1140_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1139_);
						_tmp1141_ = _tmp1140_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1141_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1142_;
							ValaDataType* _tmp1143_;
							ValaDataType* _tmp1144_;
							ValaDelegateType* _tmp1145_;
							ValaDelegateType* _tmp1146_;
							ValaDelegate* _tmp1147_;
							ValaDelegate* _tmp1148_;
							gboolean _tmp1149_;
							gboolean _tmp1150_;
							_tmp1142_ = param;
							_tmp1143_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1142_);
							_tmp1144_ = _tmp1143_;
							_tmp1145_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1144_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1145_;
							_tmp1146_ = deleg_type;
							_tmp1147_ = vala_delegate_type_get_delegate_symbol (_tmp1146_);
							_tmp1148_ = _tmp1147_;
							_tmp1149_ = vala_delegate_get_has_target (_tmp1148_);
							_tmp1150_ = _tmp1149_;
							if (_tmp1150_) {
								ValaVoidType* _tmp1151_;
								ValaVoidType* _tmp1152_;
								ValaPointerType* _tmp1153_;
								ValaPointerType* _tmp1154_;
								ValaLocalVariable* _tmp1155_;
								ValaLocalVariable* _tmp1156_;
								ValaExpression* _tmp1157_;
								ValaLocalVariable* _tmp1158_;
								const gchar* _tmp1159_;
								const gchar* _tmp1160_;
								ValaCCodeExpression* _tmp1161_;
								ValaCCodeExpression* _tmp1162_;
								ValaHashMap* _tmp1163_;
								ValaParameter* _tmp1164_;
								ValaExpression* _tmp1165_;
								ValaCCodeExpression* _tmp1166_;
								ValaCCodeExpression* _tmp1167_;
								ValaCCodeUnaryExpression* _tmp1168_;
								ValaCCodeUnaryExpression* _tmp1169_;
								ValaDelegateType* _tmp1170_;
								_tmp1151_ = vala_void_type_new (NULL);
								_tmp1152_ = _tmp1151_;
								_tmp1153_ = vala_pointer_type_new ((ValaDataType*) _tmp1152_, NULL);
								_tmp1154_ = _tmp1153_;
								_tmp1155_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1154_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1155_;
								_vala_code_node_unref0 (_tmp1154_);
								_vala_code_node_unref0 (_tmp1152_);
								_tmp1156_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1156_, FALSE);
								_tmp1157_ = arg;
								_tmp1158_ = temp_var;
								_tmp1159_ = vala_symbol_get_name ((ValaSymbol*) _tmp1158_);
								_tmp1160_ = _tmp1159_;
								_tmp1161_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1160_);
								_tmp1162_ = _tmp1161_;
								vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1157_, _tmp1162_);
								_vala_ccode_node_unref0 (_tmp1162_);
								_tmp1163_ = carg_map;
								_tmp1164_ = param;
								_tmp1165_ = arg;
								_tmp1166_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1165_);
								_tmp1167_ = _tmp1166_;
								_tmp1168_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1167_);
								_tmp1169_ = _tmp1168_;
								vala_map_set ((ValaMap*) _tmp1163_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1164_), FALSE)), (ValaCCodeExpression*) _tmp1169_);
								_vala_ccode_node_unref0 (_tmp1169_);
								_vala_ccode_node_unref0 (_tmp1167_);
								_tmp1170_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1170_)) {
									ValaDataType* _tmp1171_;
									ValaLocalVariable* _tmp1172_;
									ValaLocalVariable* _tmp1173_;
									ValaExpression* _tmp1174_;
									ValaLocalVariable* _tmp1175_;
									const gchar* _tmp1176_;
									const gchar* _tmp1177_;
									ValaCCodeExpression* _tmp1178_;
									ValaCCodeExpression* _tmp1179_;
									ValaHashMap* _tmp1180_;
									ValaParameter* _tmp1181_;
									ValaExpression* _tmp1182_;
									ValaCCodeExpression* _tmp1183_;
									ValaCCodeExpression* _tmp1184_;
									ValaCCodeUnaryExpression* _tmp1185_;
									ValaCCodeUnaryExpression* _tmp1186_;
									_tmp1171_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
									_tmp1172_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1171_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1172_;
									_tmp1173_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1173_, FALSE);
									_tmp1174_ = arg;
									_tmp1175_ = temp_var;
									_tmp1176_ = vala_symbol_get_name ((ValaSymbol*) _tmp1175_);
									_tmp1177_ = _tmp1176_;
									_tmp1178_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1177_);
									_tmp1179_ = _tmp1178_;
									vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1174_, _tmp1179_);
									_vala_ccode_node_unref0 (_tmp1179_);
									_tmp1180_ = carg_map;
									_tmp1181_ = param;
									_tmp1182_ = arg;
									_tmp1183_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1182_);
									_tmp1184_ = _tmp1183_;
									_tmp1185_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1184_);
									_tmp1186_ = _tmp1185_;
									vala_map_set ((ValaMap*) _tmp1180_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1181_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1186_);
									_vala_ccode_node_unref0 (_tmp1186_);
									_vala_ccode_node_unref0 (_tmp1184_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1187_ = param;
				_tmp1188_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1187_);
				_tmp1189_ = _tmp1188_;
				_tmp1190_ = _tmp1189_ != NULL;
				_g_free0 (_tmp1189_);
				if (_tmp1190_) {
					ValaCCodeExpression* _tmp1191_;
					ValaParameter* _tmp1192_;
					gchar* _tmp1193_;
					gchar* _tmp1194_;
					ValaCCodeCastExpression* _tmp1195_;
					_tmp1191_ = cexpr;
					_tmp1192_ = param;
					_tmp1193_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1192_);
					_tmp1194_ = _tmp1193_;
					_tmp1195_ = vala_ccode_cast_expression_new (_tmp1191_, _tmp1194_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1195_;
					_g_free0 (_tmp1194_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1196_;
				ValaUnaryExpression* _tmp1197_;
				gboolean _tmp1198_ = FALSE;
				gboolean _tmp1199_ = FALSE;
				gboolean _tmp1200_;
				_tmp1196_ = arg;
				_tmp1197_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1196_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1196_) : NULL);
				unary = _tmp1197_;
				_tmp1200_ = ellipsis;
				if (_tmp1200_) {
					ValaUnaryExpression* _tmp1201_;
					_tmp1201_ = unary;
					_tmp1199_ = _tmp1201_ != NULL;
				} else {
					_tmp1199_ = FALSE;
				}
				if (_tmp1199_) {
					ValaUnaryExpression* _tmp1202_;
					ValaUnaryOperator _tmp1203_;
					ValaUnaryOperator _tmp1204_;
					_tmp1202_ = unary;
					_tmp1203_ = vala_unary_expression_get_operator (_tmp1202_);
					_tmp1204_ = _tmp1203_;
					_tmp1198_ = _tmp1204_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1198_ = FALSE;
				}
				if (_tmp1198_) {
					ValaHashMap* _tmp1205_;
					ValaHashMap* _tmp1206_;
					ValaExpression* _tmp1207_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1208_;
					ValaDataType* _tmp1209_;
					ValaDataType* _tmp1210_;
					ValaExpression* _tmp1211_;
					ValaDataType* _tmp1212_;
					ValaDataType* _tmp1213_;
					gboolean _tmp1214_;
					gboolean _tmp1215_;
					ValaLocalVariable* _tmp1216_;
					ValaLocalVariable* _tmp1217_;
					ValaExpression* _tmp1218_;
					ValaLocalVariable* _tmp1219_;
					const gchar* _tmp1220_;
					const gchar* _tmp1221_;
					ValaCCodeExpression* _tmp1222_;
					ValaCCodeExpression* _tmp1223_;
					ValaExpression* _tmp1224_;
					ValaTargetValue* _tmp1225_;
					ValaTargetValue* _tmp1226_;
					ValaExpression* _tmp1227_;
					ValaDataType* _tmp1228_;
					ValaDataType* _tmp1229_;
					ValaExpression* _tmp1230_;
					ValaCCodeExpression* _tmp1231_;
					ValaCCodeExpression* _tmp1232_;
					ValaCCodeUnaryExpression* _tmp1233_;
					_tmp1205_ = out_arg_map;
					_tmp1206_ = _vala_map_ref0 (_tmp1205_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1206_;
					_tmp1207_ = arg;
					vala_expression_set_target_value (_tmp1207_, NULL);
					_tmp1208_ = arg;
					_tmp1209_ = vala_expression_get_value_type (_tmp1208_);
					_tmp1210_ = _tmp1209_;
					_tmp1211_ = arg;
					_tmp1212_ = vala_expression_get_value_type (_tmp1211_);
					_tmp1213_ = _tmp1212_;
					_tmp1214_ = vala_data_type_get_value_owned (_tmp1213_);
					_tmp1215_ = _tmp1214_;
					_tmp1216_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1210_, _tmp1215_, NULL, TRUE);
					temp_var = _tmp1216_;
					_tmp1217_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1217_, FALSE);
					_tmp1218_ = arg;
					_tmp1219_ = temp_var;
					_tmp1220_ = vala_symbol_get_name ((ValaSymbol*) _tmp1219_);
					_tmp1221_ = _tmp1220_;
					_tmp1222_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1221_);
					_tmp1223_ = _tmp1222_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1218_, _tmp1223_);
					_vala_ccode_node_unref0 (_tmp1223_);
					_tmp1224_ = arg;
					_tmp1225_ = vala_expression_get_target_value (_tmp1224_);
					_tmp1226_ = _tmp1225_;
					_tmp1227_ = arg;
					_tmp1228_ = vala_expression_get_value_type (_tmp1227_);
					_tmp1229_ = _tmp1228_;
					vala_target_value_set_value_type (_tmp1226_, _tmp1229_);
					_tmp1230_ = arg;
					_tmp1231_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1230_);
					_tmp1232_ = _tmp1231_;
					_tmp1233_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1232_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1233_;
					_vala_ccode_node_unref0 (_tmp1232_);
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1234_;
					ValaCCodeExpression* _tmp1235_;
					ValaCCodeExpression* _tmp1236_;
					_tmp1234_ = arg;
					_tmp1235_ = cexpr;
					_tmp1236_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1234_, _tmp1235_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1236_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1239_ = param;
			if (_tmp1239_ != NULL) {
				gboolean _tmp1240_;
				_tmp1240_ = ellipsis;
				_tmp1238_ = !_tmp1240_;
			} else {
				_tmp1238_ = FALSE;
			}
			if (_tmp1238_) {
				ValaParameter* _tmp1241_;
				_tmp1241_ = param;
				_tmp1237_ = vala_get_ccode_pos (_tmp1241_);
			} else {
				gint _tmp1242_;
				_tmp1242_ = i;
				_tmp1237_ = (gdouble) _tmp1242_;
			}
			_tmp1243_ = ellipsis;
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1237_, _tmp1243_);
			_tmp1244_ = carg_map;
			_tmp1245_ = arg_pos;
			_tmp1246_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1244_, (gpointer) ((gintptr) _tmp1245_), _tmp1246_);
			_tmp1248_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1248_, VALA_TYPE_NAMED_ARGUMENT)) {
				gboolean _tmp1249_;
				_tmp1249_ = ellipsis;
				_tmp1247_ = _tmp1249_;
			} else {
				_tmp1247_ = FALSE;
			}
			if (_tmp1247_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1250_;
				ValaNamedArgument* _tmp1251_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1252_;
				const gchar* _tmp1253_;
				const gchar* _tmp1254_;
				gchar** _tmp1255_;
				gchar** _tmp1256_;
				gchar** _tmp1257_;
				gint _tmp1257__length1;
				gchar* _tmp1258_;
				gchar* _tmp1259_;
				ValaHashMap* _tmp1260_;
				gint _tmp1261_;
				gboolean _tmp1262_;
				const gchar* _tmp1263_;
				gchar* _tmp1264_;
				gchar* _tmp1265_;
				ValaCCodeConstant* _tmp1266_;
				ValaCCodeConstant* _tmp1267_;
				_tmp1250_ = arg;
				_tmp1251_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1250_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1251_;
				_tmp1252_ = named_arg;
				_tmp1253_ = vala_named_argument_get_name (_tmp1252_);
				_tmp1254_ = _tmp1253_;
				_tmp1256_ = _tmp1255_ = g_strsplit (_tmp1254_, "_", 0);
				_tmp1257_ = _tmp1256_;
				_tmp1257__length1 = _vala_array_length (_tmp1255_);
				_tmp1258_ = _vala_g_strjoinv ("-", _tmp1257_, _vala_array_length (_tmp1255_));
				_tmp1259_ = _tmp1258_;
				_tmp1257_ = (_vala_array_free (_tmp1257_, _tmp1257__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1259_;
				_tmp1260_ = carg_map;
				_tmp1261_ = i;
				_tmp1262_ = ellipsis;
				_tmp1263_ = name;
				_tmp1264_ = g_strdup_printf ("\"%s\"", _tmp1263_);
				_tmp1265_ = _tmp1264_;
				_tmp1266_ = vala_ccode_constant_new (_tmp1265_);
				_tmp1267_ = _tmp1266_;
				vala_map_set ((ValaMap*) _tmp1260_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1261_ - 0.1, _tmp1262_)), (ValaCCodeExpression*) _tmp1267_);
				_vala_ccode_node_unref0 (_tmp1267_);
				_g_free0 (_tmp1265_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1268_ = i;
			i = _tmp1268_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1269_ = params_it;
	if (vala_iterator_next (_tmp1269_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1270_;
		gpointer _tmp1271_;
		gboolean _tmp1272_ = FALSE;
		ValaParameter* _tmp1273_;
		gboolean _tmp1274_;
		gboolean _tmp1275_;
		_tmp1270_ = params_it;
		_tmp1271_ = vala_iterator_get (_tmp1270_);
		param = (ValaParameter*) _tmp1271_;
		_tmp1273_ = param;
		_tmp1274_ = vala_parameter_get_params_array (_tmp1273_);
		_tmp1275_ = _tmp1274_;
		if (_tmp1275_) {
			_tmp1272_ = TRUE;
		} else {
			ValaParameter* _tmp1276_;
			gboolean _tmp1277_;
			gboolean _tmp1278_;
			_tmp1276_ = param;
			_tmp1277_ = vala_parameter_get_ellipsis (_tmp1276_);
			_tmp1278_ = _tmp1277_;
			_tmp1272_ = _tmp1278_;
		}
		_vala_assert (_tmp1272_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1281_ = m;
	if (_tmp1281_ != NULL) {
		ValaMethod* _tmp1282_;
		ValaDataType* _tmp1283_;
		ValaDataType* _tmp1284_;
		_tmp1282_ = m;
		_tmp1283_ = vala_callable_get_return_type ((ValaCallable*) _tmp1282_);
		_tmp1284_ = _tmp1283_;
		_tmp1280_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1284_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1280_ = FALSE;
	}
	if (_tmp1280_) {
		ValaCCodeFunctionCall* _tmp1285_;
		ValaCCodeFunctionCall* _tmp1286_;
		_tmp1285_ = async_call;
		_tmp1286_ = ccall;
		_tmp1279_ = _tmp1285_ != _tmp1286_;
	} else {
		_tmp1279_ = FALSE;
	}
	if (_tmp1279_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1287_;
		ValaDataType* _tmp1288_;
		ValaDataType* _tmp1289_;
		ValaArrayType* _tmp1290_;
		_tmp1287_ = m;
		_tmp1288_ = vala_callable_get_return_type ((ValaCallable*) _tmp1287_);
		_tmp1289_ = _tmp1288_;
		_tmp1290_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1289_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1290_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1291_ = FALSE;
				_tmp1291_ = TRUE;
				while (TRUE) {
					gint _tmp1293_;
					ValaArrayType* _tmp1294_;
					gint _tmp1295_;
					gint _tmp1296_;
					ValaMethod* _tmp1297_;
					if (!_tmp1291_) {
						gint _tmp1292_;
						_tmp1292_ = dim;
						dim = _tmp1292_ + 1;
					}
					_tmp1291_ = FALSE;
					_tmp1293_ = dim;
					_tmp1294_ = array_type;
					_tmp1295_ = vala_array_type_get_rank (_tmp1294_);
					_tmp1296_ = _tmp1295_;
					if (!(_tmp1293_ <= _tmp1296_)) {
						break;
					}
					_tmp1297_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1297_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1298_;
						ValaDataType* _tmp1299_;
						ValaDataType* _tmp1300_;
						ValaLocalVariable* _tmp1301_;
						ValaLocalVariable* _tmp1302_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1303_;
						const gchar* _tmp1304_;
						const gchar* _tmp1305_;
						ValaCCodeExpression* _tmp1306_;
						ValaLocalVariable* _tmp1307_;
						ValaCCodeExpression* _tmp1308_;
						ValaCCodeExpression* _tmp1309_;
						ValaCCodeAssignment* _tmp1310_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1311_;
						ValaCCodeIdentifier* _tmp1312_;
						ValaCCodeFunctionCall* _tmp1313_;
						ValaCCodeFunctionCall* _tmp1314_;
						ValaCCodeFunctionCall* _tmp1315_;
						ValaCCodeExpression* _tmp1316_;
						ValaCCodeFunctionCall* _tmp1317_;
						_tmp1298_ = itype;
						_tmp1299_ = vala_data_type_get_return_type (_tmp1298_);
						_tmp1300_ = _tmp1299_;
						_tmp1301_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1300_, TRUE, NULL, FALSE);
						_tmp1302_ = _tmp1301_;
						_vala_code_node_unref0 (_tmp1300_);
						temp_var = _tmp1302_;
						_tmp1303_ = temp_var;
						_tmp1304_ = vala_symbol_get_name ((ValaSymbol*) _tmp1303_);
						_tmp1305_ = _tmp1304_;
						_tmp1306_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1305_);
						temp_ref = _tmp1306_;
						_tmp1307_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1307_, FALSE);
						_tmp1308_ = temp_ref;
						_tmp1309_ = ccall_expr;
						_tmp1310_ = vala_ccode_assignment_new (_tmp1308_, _tmp1309_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1310_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1311_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1312_ = _tmp1311_;
						_tmp1313_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1312_);
						_tmp1314_ = _tmp1313_;
						_vala_ccode_node_unref0 (_tmp1312_);
						len_call = _tmp1314_;
						_tmp1315_ = len_call;
						_tmp1316_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1315_, _tmp1316_);
						_tmp1317_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1317_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1318_;
						_tmp1318_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1318_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaMethod* _tmp1319_;
							gchar* _tmp1320_;
							gchar* _tmp1321_;
							gboolean _tmp1322_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1331_;
							const gchar* _tmp1332_;
							const gchar* _tmp1333_;
							ValaCCodeExpression* _tmp1334_;
							ValaLocalVariable* _tmp1335_;
							ValaHashMap* _tmp1336_;
							ValaMethod* _tmp1337_;
							gint _tmp1338_;
							ValaCCodeExpression* _tmp1339_;
							ValaCCodeUnaryExpression* _tmp1340_;
							ValaCCodeUnaryExpression* _tmp1341_;
							ValaCCodeExpression* _tmp1342_;
							_tmp1319_ = m;
							_tmp1320_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1319_);
							_tmp1321_ = _tmp1320_;
							_tmp1322_ = _tmp1321_ == NULL;
							_g_free0 (_tmp1321_);
							if (_tmp1322_) {
								ValaDataType* _tmp1323_;
								ValaLocalVariable* _tmp1324_;
								_tmp1323_ = ((ValaCCodeBaseModule*) self)->int_type;
								_tmp1324_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1323_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1324_;
							} else {
								ValaMethod* _tmp1325_;
								gchar* _tmp1326_;
								gchar* _tmp1327_;
								ValaCType* _tmp1328_;
								ValaCType* _tmp1329_;
								ValaLocalVariable* _tmp1330_;
								_tmp1325_ = m;
								_tmp1326_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1325_);
								_tmp1327_ = _tmp1326_;
								_tmp1328_ = vala_ctype_new (_tmp1327_, "0");
								_tmp1329_ = _tmp1328_;
								_tmp1330_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1329_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1330_;
								_vala_code_node_unref0 (_tmp1329_);
								_g_free0 (_tmp1327_);
							}
							_tmp1331_ = temp_var;
							_tmp1332_ = vala_symbol_get_name ((ValaSymbol*) _tmp1331_);
							_tmp1333_ = _tmp1332_;
							_tmp1334_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1333_);
							temp_ref = _tmp1334_;
							_tmp1335_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1335_, FALSE);
							_tmp1336_ = out_arg_map;
							_tmp1337_ = m;
							_tmp1338_ = dim;
							_tmp1339_ = temp_ref;
							_tmp1340_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1339_);
							_tmp1341_ = _tmp1340_;
							vala_map_set ((ValaMap*) _tmp1336_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1337_) + (0.01 * _tmp1338_), FALSE)), (ValaCCodeExpression*) _tmp1341_);
							_vala_ccode_node_unref0 (_tmp1341_);
							_tmp1342_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1342_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaMethod* _tmp1343_;
							gchar* _tmp1344_;
							gchar* _tmp1345_;
							gboolean _tmp1346_;
							_tmp1343_ = m;
							_tmp1344_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1343_);
							_tmp1345_ = _tmp1344_;
							_tmp1346_ = _tmp1345_ != NULL;
							_g_free0 (_tmp1345_);
							if (_tmp1346_) {
								ValaMethod* _tmp1347_;
								gchar* _tmp1348_;
								gchar* _tmp1349_;
								ValaCCodeConstant* _tmp1350_;
								ValaCCodeConstant* _tmp1351_;
								_tmp1347_ = m;
								_tmp1348_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1347_);
								_tmp1349_ = _tmp1348_;
								_tmp1350_ = vala_ccode_constant_new (_tmp1349_);
								_tmp1351_ = _tmp1350_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1351_);
								_vala_ccode_node_unref0 (_tmp1351_);
								_g_free0 (_tmp1349_);
							} else {
								ValaCCodeConstant* _tmp1352_;
								ValaCCodeConstant* _tmp1353_;
								_tmp1352_ = vala_ccode_constant_new ("-1");
								_tmp1353_ = _tmp1352_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1353_);
								_vala_ccode_node_unref0 (_tmp1353_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1354_ = FALSE;
		gboolean _tmp1355_ = FALSE;
		ValaMethod* _tmp1356_;
		_tmp1356_ = m;
		if (_tmp1356_ != NULL) {
			ValaMethod* _tmp1357_;
			ValaDataType* _tmp1358_;
			ValaDataType* _tmp1359_;
			_tmp1357_ = m;
			_tmp1358_ = vala_callable_get_return_type ((ValaCallable*) _tmp1357_);
			_tmp1359_ = _tmp1358_;
			_tmp1355_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1359_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1355_ = FALSE;
		}
		if (_tmp1355_) {
			ValaCCodeFunctionCall* _tmp1360_;
			ValaCCodeFunctionCall* _tmp1361_;
			_tmp1360_ = async_call;
			_tmp1361_ = ccall;
			_tmp1354_ = _tmp1360_ != _tmp1361_;
		} else {
			_tmp1354_ = FALSE;
		}
		if (_tmp1354_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1362_;
			ValaDataType* _tmp1363_;
			ValaDataType* _tmp1364_;
			ValaDelegateType* _tmp1365_;
			ValaDelegateType* _tmp1366_;
			ValaDelegate* _tmp1367_;
			ValaDelegate* _tmp1368_;
			gboolean _tmp1369_;
			gboolean _tmp1370_;
			_tmp1362_ = m;
			_tmp1363_ = vala_callable_get_return_type ((ValaCallable*) _tmp1362_);
			_tmp1364_ = _tmp1363_;
			_tmp1365_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1364_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1365_;
			_tmp1366_ = deleg_type;
			_tmp1367_ = vala_delegate_type_get_delegate_symbol (_tmp1366_);
			_tmp1368_ = _tmp1367_;
			_tmp1369_ = vala_delegate_get_has_target (_tmp1368_);
			_tmp1370_ = _tmp1369_;
			if (_tmp1370_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1371_;
				ValaVoidType* _tmp1372_;
				ValaPointerType* _tmp1373_;
				ValaPointerType* _tmp1374_;
				ValaLocalVariable* _tmp1375_;
				ValaLocalVariable* _tmp1376_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1377_;
				const gchar* _tmp1378_;
				const gchar* _tmp1379_;
				ValaCCodeExpression* _tmp1380_;
				ValaLocalVariable* _tmp1381_;
				ValaHashMap* _tmp1382_;
				ValaMethod* _tmp1383_;
				ValaCCodeExpression* _tmp1384_;
				ValaCCodeUnaryExpression* _tmp1385_;
				ValaCCodeUnaryExpression* _tmp1386_;
				ValaCCodeExpression* _tmp1387_;
				ValaDelegateType* _tmp1388_;
				_tmp1371_ = vala_void_type_new (NULL);
				_tmp1372_ = _tmp1371_;
				_tmp1373_ = vala_pointer_type_new ((ValaDataType*) _tmp1372_, NULL);
				_tmp1374_ = _tmp1373_;
				_tmp1375_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1374_, TRUE, NULL, TRUE);
				_tmp1376_ = _tmp1375_;
				_vala_code_node_unref0 (_tmp1374_);
				_vala_code_node_unref0 (_tmp1372_);
				temp_var = _tmp1376_;
				_tmp1377_ = temp_var;
				_tmp1378_ = vala_symbol_get_name ((ValaSymbol*) _tmp1377_);
				_tmp1379_ = _tmp1378_;
				_tmp1380_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1379_);
				temp_ref = _tmp1380_;
				_tmp1381_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1381_, FALSE);
				_tmp1382_ = out_arg_map;
				_tmp1383_ = m;
				_tmp1384_ = temp_ref;
				_tmp1385_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1384_);
				_tmp1386_ = _tmp1385_;
				vala_map_set ((ValaMap*) _tmp1382_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1383_), FALSE)), (ValaCCodeExpression*) _tmp1386_);
				_vala_ccode_node_unref0 (_tmp1386_);
				_tmp1387_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1387_);
				_tmp1388_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1388_)) {
					ValaDataType* _tmp1389_;
					ValaLocalVariable* _tmp1390_;
					ValaLocalVariable* _tmp1391_;
					const gchar* _tmp1392_;
					const gchar* _tmp1393_;
					ValaCCodeExpression* _tmp1394_;
					ValaLocalVariable* _tmp1395_;
					ValaHashMap* _tmp1396_;
					ValaMethod* _tmp1397_;
					ValaCCodeExpression* _tmp1398_;
					ValaCCodeUnaryExpression* _tmp1399_;
					ValaCCodeUnaryExpression* _tmp1400_;
					ValaCCodeExpression* _tmp1401_;
					_tmp1389_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1390_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1389_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1390_;
					_tmp1391_ = temp_var;
					_tmp1392_ = vala_symbol_get_name ((ValaSymbol*) _tmp1391_);
					_tmp1393_ = _tmp1392_;
					_tmp1394_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1393_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1394_;
					_tmp1395_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1395_, FALSE);
					_tmp1396_ = out_arg_map;
					_tmp1397_ = m;
					_tmp1398_ = temp_ref;
					_tmp1399_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1398_);
					_tmp1400_ = _tmp1399_;
					vala_map_set ((ValaMap*) _tmp1396_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1397_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1400_);
					_vala_ccode_node_unref0 (_tmp1400_);
					_tmp1401_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1401_);
				} else {
					ValaCCodeConstant* _tmp1402_;
					ValaCCodeConstant* _tmp1403_;
					_tmp1402_ = vala_ccode_constant_new ("NULL");
					_tmp1403_ = _tmp1402_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1403_);
					_vala_ccode_node_unref0 (_tmp1403_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1404_;
				ValaCCodeConstant* _tmp1405_;
				_tmp1404_ = vala_ccode_constant_new ("NULL");
				_tmp1405_ = _tmp1404_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1405_);
				_vala_ccode_node_unref0 (_tmp1405_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1407_ = deleg;
	if (_tmp1407_ != NULL) {
		ValaDelegate* _tmp1408_;
		ValaDataType* _tmp1409_;
		ValaDataType* _tmp1410_;
		_tmp1408_ = deleg;
		_tmp1409_ = vala_callable_get_return_type ((ValaCallable*) _tmp1408_);
		_tmp1410_ = _tmp1409_;
		_tmp1406_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1410_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1406_ = FALSE;
	}
	if (_tmp1406_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1411_;
		ValaDataType* _tmp1412_;
		ValaDataType* _tmp1413_;
		ValaArrayType* _tmp1414_;
		_tmp1411_ = deleg;
		_tmp1412_ = vala_callable_get_return_type ((ValaCallable*) _tmp1411_);
		_tmp1413_ = _tmp1412_;
		_tmp1414_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1413_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1414_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1415_ = FALSE;
				_tmp1415_ = TRUE;
				while (TRUE) {
					gint _tmp1417_;
					ValaArrayType* _tmp1418_;
					gint _tmp1419_;
					gint _tmp1420_;
					ValaDelegate* _tmp1421_;
					if (!_tmp1415_) {
						gint _tmp1416_;
						_tmp1416_ = dim;
						dim = _tmp1416_ + 1;
					}
					_tmp1415_ = FALSE;
					_tmp1417_ = dim;
					_tmp1418_ = array_type;
					_tmp1419_ = vala_array_type_get_rank (_tmp1418_);
					_tmp1420_ = _tmp1419_;
					if (!(_tmp1417_ <= _tmp1420_)) {
						break;
					}
					_tmp1421_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1421_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1422_;
						ValaDataType* _tmp1423_;
						ValaDataType* _tmp1424_;
						ValaLocalVariable* _tmp1425_;
						ValaLocalVariable* _tmp1426_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1427_;
						const gchar* _tmp1428_;
						const gchar* _tmp1429_;
						ValaCCodeExpression* _tmp1430_;
						ValaLocalVariable* _tmp1431_;
						ValaCCodeExpression* _tmp1432_;
						ValaCCodeExpression* _tmp1433_;
						ValaCCodeAssignment* _tmp1434_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1435_;
						ValaCCodeIdentifier* _tmp1436_;
						ValaCCodeFunctionCall* _tmp1437_;
						ValaCCodeFunctionCall* _tmp1438_;
						ValaCCodeFunctionCall* _tmp1439_;
						ValaCCodeExpression* _tmp1440_;
						ValaCCodeFunctionCall* _tmp1441_;
						_tmp1422_ = itype;
						_tmp1423_ = vala_data_type_get_return_type (_tmp1422_);
						_tmp1424_ = _tmp1423_;
						_tmp1425_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1424_, TRUE, NULL, FALSE);
						_tmp1426_ = _tmp1425_;
						_vala_code_node_unref0 (_tmp1424_);
						temp_var = _tmp1426_;
						_tmp1427_ = temp_var;
						_tmp1428_ = vala_symbol_get_name ((ValaSymbol*) _tmp1427_);
						_tmp1429_ = _tmp1428_;
						_tmp1430_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1429_);
						temp_ref = _tmp1430_;
						_tmp1431_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1431_, FALSE);
						_tmp1432_ = temp_ref;
						_tmp1433_ = ccall_expr;
						_tmp1434_ = vala_ccode_assignment_new (_tmp1432_, _tmp1433_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1434_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1435_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1436_ = _tmp1435_;
						_tmp1437_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1436_);
						_tmp1438_ = _tmp1437_;
						_vala_ccode_node_unref0 (_tmp1436_);
						len_call = _tmp1438_;
						_tmp1439_ = len_call;
						_tmp1440_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1439_, _tmp1440_);
						_tmp1441_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1441_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1442_;
						_tmp1442_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1442_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaDataType* _tmp1443_;
							ValaLocalVariable* _tmp1444_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1445_;
							const gchar* _tmp1446_;
							const gchar* _tmp1447_;
							ValaCCodeExpression* _tmp1448_;
							ValaLocalVariable* _tmp1449_;
							ValaHashMap* _tmp1450_;
							ValaDelegate* _tmp1451_;
							gint _tmp1452_;
							ValaCCodeExpression* _tmp1453_;
							ValaCCodeUnaryExpression* _tmp1454_;
							ValaCCodeUnaryExpression* _tmp1455_;
							ValaCCodeExpression* _tmp1456_;
							_tmp1443_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1444_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1443_, TRUE, NULL, TRUE);
							temp_var = _tmp1444_;
							_tmp1445_ = temp_var;
							_tmp1446_ = vala_symbol_get_name ((ValaSymbol*) _tmp1445_);
							_tmp1447_ = _tmp1446_;
							_tmp1448_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1447_);
							temp_ref = _tmp1448_;
							_tmp1449_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1449_, FALSE);
							_tmp1450_ = out_arg_map;
							_tmp1451_ = deleg;
							_tmp1452_ = dim;
							_tmp1453_ = temp_ref;
							_tmp1454_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1453_);
							_tmp1455_ = _tmp1454_;
							vala_map_set ((ValaMap*) _tmp1450_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1451_) + (0.01 * _tmp1452_), FALSE)), (ValaCCodeExpression*) _tmp1455_);
							_vala_ccode_node_unref0 (_tmp1455_);
							_tmp1456_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1456_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1457_;
							ValaCCodeConstant* _tmp1458_;
							_tmp1457_ = vala_ccode_constant_new ("-1");
							_tmp1458_ = _tmp1457_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1458_);
							_vala_ccode_node_unref0 (_tmp1458_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1459_ = FALSE;
		ValaDelegate* _tmp1460_;
		_tmp1460_ = deleg;
		if (_tmp1460_ != NULL) {
			ValaDelegate* _tmp1461_;
			ValaDataType* _tmp1462_;
			ValaDataType* _tmp1463_;
			_tmp1461_ = deleg;
			_tmp1462_ = vala_callable_get_return_type ((ValaCallable*) _tmp1461_);
			_tmp1463_ = _tmp1462_;
			_tmp1459_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1463_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1459_ = FALSE;
		}
		if (_tmp1459_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1464_;
			ValaDataType* _tmp1465_;
			ValaDataType* _tmp1466_;
			ValaDelegateType* _tmp1467_;
			ValaDelegateType* _tmp1468_;
			ValaDelegate* _tmp1469_;
			ValaDelegate* _tmp1470_;
			gboolean _tmp1471_;
			gboolean _tmp1472_;
			_tmp1464_ = deleg;
			_tmp1465_ = vala_callable_get_return_type ((ValaCallable*) _tmp1464_);
			_tmp1466_ = _tmp1465_;
			_tmp1467_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1466_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1467_;
			_tmp1468_ = deleg_type;
			_tmp1469_ = vala_delegate_type_get_delegate_symbol (_tmp1468_);
			_tmp1470_ = _tmp1469_;
			_tmp1471_ = vala_delegate_get_has_target (_tmp1470_);
			_tmp1472_ = _tmp1471_;
			if (_tmp1472_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1473_;
				ValaVoidType* _tmp1474_;
				ValaPointerType* _tmp1475_;
				ValaPointerType* _tmp1476_;
				ValaLocalVariable* _tmp1477_;
				ValaLocalVariable* _tmp1478_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1479_;
				const gchar* _tmp1480_;
				const gchar* _tmp1481_;
				ValaCCodeExpression* _tmp1482_;
				ValaLocalVariable* _tmp1483_;
				ValaHashMap* _tmp1484_;
				ValaDelegate* _tmp1485_;
				ValaCCodeExpression* _tmp1486_;
				ValaCCodeUnaryExpression* _tmp1487_;
				ValaCCodeUnaryExpression* _tmp1488_;
				ValaCCodeExpression* _tmp1489_;
				ValaDelegateType* _tmp1490_;
				_tmp1473_ = vala_void_type_new (NULL);
				_tmp1474_ = _tmp1473_;
				_tmp1475_ = vala_pointer_type_new ((ValaDataType*) _tmp1474_, NULL);
				_tmp1476_ = _tmp1475_;
				_tmp1477_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1476_, TRUE, NULL, TRUE);
				_tmp1478_ = _tmp1477_;
				_vala_code_node_unref0 (_tmp1476_);
				_vala_code_node_unref0 (_tmp1474_);
				temp_var = _tmp1478_;
				_tmp1479_ = temp_var;
				_tmp1480_ = vala_symbol_get_name ((ValaSymbol*) _tmp1479_);
				_tmp1481_ = _tmp1480_;
				_tmp1482_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1481_);
				temp_ref = _tmp1482_;
				_tmp1483_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1483_, FALSE);
				_tmp1484_ = out_arg_map;
				_tmp1485_ = deleg;
				_tmp1486_ = temp_ref;
				_tmp1487_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1486_);
				_tmp1488_ = _tmp1487_;
				vala_map_set ((ValaMap*) _tmp1484_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1485_), FALSE)), (ValaCCodeExpression*) _tmp1488_);
				_vala_ccode_node_unref0 (_tmp1488_);
				_tmp1489_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1489_);
				_tmp1490_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1490_)) {
					ValaDataType* _tmp1491_;
					ValaLocalVariable* _tmp1492_;
					ValaLocalVariable* _tmp1493_;
					const gchar* _tmp1494_;
					const gchar* _tmp1495_;
					ValaCCodeExpression* _tmp1496_;
					ValaLocalVariable* _tmp1497_;
					ValaHashMap* _tmp1498_;
					ValaDelegate* _tmp1499_;
					ValaCCodeExpression* _tmp1500_;
					ValaCCodeUnaryExpression* _tmp1501_;
					ValaCCodeUnaryExpression* _tmp1502_;
					ValaCCodeExpression* _tmp1503_;
					_tmp1491_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1492_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1491_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1492_;
					_tmp1493_ = temp_var;
					_tmp1494_ = vala_symbol_get_name ((ValaSymbol*) _tmp1493_);
					_tmp1495_ = _tmp1494_;
					_tmp1496_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1495_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1496_;
					_tmp1497_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1497_, FALSE);
					_tmp1498_ = out_arg_map;
					_tmp1499_ = deleg;
					_tmp1500_ = temp_ref;
					_tmp1501_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1500_);
					_tmp1502_ = _tmp1501_;
					vala_map_set ((ValaMap*) _tmp1498_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1499_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1502_);
					_vala_ccode_node_unref0 (_tmp1502_);
					_tmp1503_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1503_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1505_ = m;
	if (_tmp1505_ != NULL) {
		ValaMethod* _tmp1506_;
		gboolean _tmp1507_;
		gboolean _tmp1508_;
		_tmp1506_ = m;
		_tmp1507_ = vala_method_get_coroutine (_tmp1506_);
		_tmp1508_ = _tmp1507_;
		_tmp1504_ = _tmp1508_;
	} else {
		_tmp1504_ = FALSE;
	}
	if (_tmp1504_) {
		gboolean _tmp1509_;
		gboolean _tmp1510_;
		_tmp1509_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1510_ = _tmp1509_;
		if (_tmp1510_) {
			ValaHashMap* _tmp1511_;
			ValaMethod* _tmp1512_;
			ValaMethod* _tmp1513_;
			gchar* _tmp1514_;
			gchar* _tmp1515_;
			ValaCCodeIdentifier* _tmp1516_;
			ValaCCodeIdentifier* _tmp1517_;
			ValaHashMap* _tmp1518_;
			ValaCCodeIdentifier* _tmp1519_;
			ValaCCodeIdentifier* _tmp1520_;
			_tmp1511_ = in_arg_map;
			_tmp1512_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1513_ = _tmp1512_;
			_tmp1514_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1513_);
			_tmp1515_ = _tmp1514_;
			_tmp1516_ = vala_ccode_identifier_new (_tmp1515_);
			_tmp1517_ = _tmp1516_;
			vala_map_set ((ValaMap*) _tmp1511_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1517_);
			_vala_ccode_node_unref0 (_tmp1517_);
			_g_free0 (_tmp1515_);
			_tmp1518_ = in_arg_map;
			_tmp1519_ = vala_ccode_identifier_new ("_data_");
			_tmp1520_ = _tmp1519_;
			vala_map_set ((ValaMap*) _tmp1518_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1520_);
			_vala_ccode_node_unref0 (_tmp1520_);
		}
	}
	_tmp1521_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1522_ = _tmp1521_;
	if (_tmp1522_) {
		ValaHashMap* _tmp1523_;
		ValaCCodeExpression* _tmp1524_;
		ValaCCodeExpression* _tmp1525_;
		ValaCCodeUnaryExpression* _tmp1526_;
		ValaCCodeUnaryExpression* _tmp1527_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1523_ = out_arg_map;
		_tmp1524_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1525_ = _tmp1524_;
		_tmp1526_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1525_);
		_tmp1527_ = _tmp1526_;
		vala_map_set ((ValaMap*) _tmp1523_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1527_);
		_vala_ccode_node_unref0 (_tmp1527_);
		_vala_ccode_node_unref0 (_tmp1525_);
	} else {
		gboolean _tmp1528_ = FALSE;
		gboolean _tmp1529_ = FALSE;
		ValaMethod* _tmp1530_;
		_tmp1530_ = m;
		if (_tmp1530_ != NULL) {
			ValaMethod* _tmp1531_;
			_tmp1531_ = m;
			_tmp1529_ = vala_method_has_error_type_parameter (_tmp1531_);
		} else {
			_tmp1529_ = FALSE;
		}
		if (_tmp1529_) {
			ValaCCodeFunctionCall* _tmp1532_;
			ValaCCodeFunctionCall* _tmp1533_;
			_tmp1532_ = async_call;
			_tmp1533_ = ccall;
			_tmp1528_ = _tmp1532_ != _tmp1533_;
		} else {
			_tmp1528_ = FALSE;
		}
		if (_tmp1528_) {
			ValaHashMap* _tmp1534_;
			ValaCCodeConstant* _tmp1535_;
			ValaCCodeConstant* _tmp1536_;
			_tmp1534_ = out_arg_map;
			_tmp1535_ = vala_ccode_constant_new ("NULL");
			_tmp1536_ = _tmp1535_;
			vala_map_set ((ValaMap*) _tmp1534_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1536_);
			_vala_ccode_node_unref0 (_tmp1536_);
		}
	}
	_tmp1537_ = ellipsis;
	if (_tmp1537_) {
		ValaMethod* _tmp1538_;
		_tmp1538_ = m;
		if (_tmp1538_ == NULL) {
			ValaHashMap* _tmp1539_;
			ValaCCodeConstant* _tmp1540_;
			ValaCCodeConstant* _tmp1541_;
			_tmp1539_ = in_arg_map;
			_tmp1540_ = vala_ccode_constant_new ("NULL");
			_tmp1541_ = _tmp1540_;
			vala_map_set ((ValaMap*) _tmp1539_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1541_);
			_vala_ccode_node_unref0 (_tmp1541_);
		} else {
			gboolean _tmp1542_ = FALSE;
			gboolean _tmp1543_ = FALSE;
			gboolean _tmp1544_ = FALSE;
			ValaMethod* _tmp1545_;
			gboolean _tmp1546_;
			gboolean _tmp1547_;
			_tmp1545_ = m;
			_tmp1546_ = vala_method_get_printf_format (_tmp1545_);
			_tmp1547_ = _tmp1546_;
			if (!_tmp1547_) {
				ValaMethod* _tmp1548_;
				gboolean _tmp1549_;
				gboolean _tmp1550_;
				_tmp1548_ = m;
				_tmp1549_ = vala_method_get_scanf_format (_tmp1548_);
				_tmp1550_ = _tmp1549_;
				_tmp1544_ = !_tmp1550_;
			} else {
				_tmp1544_ = FALSE;
			}
			if (_tmp1544_) {
				ValaMethod* _tmp1551_;
				gchar* _tmp1552_;
				gchar* _tmp1553_;
				_tmp1551_ = m;
				_tmp1552_ = vala_get_ccode_sentinel (_tmp1551_);
				_tmp1553_ = _tmp1552_;
				_tmp1543_ = g_strcmp0 (_tmp1553_, "") != 0;
				_g_free0 (_tmp1553_);
			} else {
				_tmp1543_ = FALSE;
			}
			if (_tmp1543_) {
				gboolean _tmp1554_;
				gboolean _tmp1555_;
				_tmp1554_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1555_ = _tmp1554_;
				_tmp1542_ = !_tmp1555_;
			} else {
				_tmp1542_ = FALSE;
			}
			if (_tmp1542_) {
				ValaHashMap* _tmp1556_;
				ValaMethod* _tmp1557_;
				gchar* _tmp1558_;
				gchar* _tmp1559_;
				ValaCCodeConstant* _tmp1560_;
				ValaCCodeConstant* _tmp1561_;
				_tmp1556_ = in_arg_map;
				_tmp1557_ = m;
				_tmp1558_ = vala_get_ccode_sentinel (_tmp1557_);
				_tmp1559_ = _tmp1558_;
				_tmp1560_ = vala_ccode_constant_new (_tmp1559_);
				_tmp1561_ = _tmp1560_;
				vala_map_set ((ValaMap*) _tmp1556_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1561_);
				_vala_ccode_node_unref0 (_tmp1561_);
				_g_free0 (_tmp1559_);
			}
		}
	}
	_tmp1562_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1562_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1563_;
		ValaDelegateType* _tmp1564_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1565_;
		ValaDelegate* _tmp1566_;
		ValaDelegate* _tmp1567_;
		ValaDelegate* _tmp1568_;
		ValaDelegate* _tmp1569_;
		gboolean _tmp1570_;
		gboolean _tmp1571_;
		_tmp1563_ = itype;
		_tmp1564_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1563_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1564_;
		_tmp1565_ = deleg_type;
		_tmp1566_ = vala_delegate_type_get_delegate_symbol (_tmp1565_);
		_tmp1567_ = _tmp1566_;
		_tmp1568_ = _vala_code_node_ref0 (_tmp1567_);
		d = _tmp1568_;
		_tmp1569_ = d;
		_tmp1570_ = vala_delegate_get_has_target (_tmp1569_);
		_tmp1571_ = _tmp1570_;
		if (_tmp1571_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1572_;
			ValaDelegate* _tmp1573_;
			ValaExpression* _tmp1574_;
			ValaExpression* _tmp1575_;
			ValaCCodeExpression* _tmp1576_ = NULL;
			ValaCCodeExpression* _tmp1577_;
			ValaCCodeExpression* _tmp1578_;
			ValaHashMap* _tmp1579_;
			ValaDelegate* _tmp1580_;
			ValaExpression* _tmp1581_;
			ValaExpression* _tmp1582_;
			ValaCCodeExpression* _tmp1583_ = NULL;
			ValaCCodeExpression* _tmp1584_;
			ValaCCodeExpression* _tmp1585_;
			_tmp1572_ = in_arg_map;
			_tmp1573_ = d;
			_tmp1574_ = vala_method_call_get_call (expr);
			_tmp1575_ = _tmp1574_;
			_tmp1577_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1575_, &_tmp1576_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1576_;
			_tmp1578_ = _tmp1577_;
			vala_map_set ((ValaMap*) _tmp1572_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1573_), FALSE)), _tmp1578_);
			_vala_ccode_node_unref0 (_tmp1578_);
			_tmp1579_ = out_arg_map;
			_tmp1580_ = d;
			_tmp1581_ = vala_method_call_get_call (expr);
			_tmp1582_ = _tmp1581_;
			_tmp1584_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1582_, &_tmp1583_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1583_;
			_tmp1585_ = _tmp1584_;
			vala_map_set ((ValaMap*) _tmp1579_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1580_), FALSE)), _tmp1585_);
			_vala_ccode_node_unref0 (_tmp1585_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1586_ = itype;
	_tmp1587_ = vala_data_type_get_return_type (_tmp1586_);
	_tmp1588_ = _tmp1587_;
	_tmp1589_ = vala_data_type_is_real_non_null_struct_type (_tmp1588_);
	_vala_code_node_unref0 (_tmp1588_);
	return_result_via_out_param = _tmp1589_;
	_tmp1591_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1591_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1592_;
		ValaDataType* _tmp1593_;
		ValaDataType* _tmp1594_;
		_tmp1592_ = itype;
		_tmp1593_ = vala_data_type_get_return_type (_tmp1592_);
		_tmp1594_ = _tmp1593_;
		_tmp1590_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1594_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1594_);
	} else {
		_tmp1590_ = FALSE;
	}
	if (_tmp1590_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1595_;
		ValaSignal* _tmp1596_;
		ValaSignal* _tmp1597_;
		ValaSignal* _tmp1598_;
		gboolean _tmp1599_ = FALSE;
		gboolean _tmp1600_ = FALSE;
		ValaMemberAccess* _tmp1601_;
		_tmp1595_ = itype;
		_tmp1596_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1595_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1597_ = _tmp1596_;
		_tmp1598_ = _vala_code_node_ref0 (_tmp1597_);
		sig = _tmp1598_;
		_tmp1601_ = ma;
		if (_tmp1601_ != NULL) {
			ValaMemberAccess* _tmp1602_;
			ValaExpression* _tmp1603_;
			ValaExpression* _tmp1604_;
			_tmp1602_ = ma;
			_tmp1603_ = vala_member_access_get_inner (_tmp1602_);
			_tmp1604_ = _tmp1603_;
			_tmp1600_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1604_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1600_ = FALSE;
		}
		if (_tmp1600_) {
			ValaSignal* _tmp1605_;
			gboolean _tmp1606_;
			gboolean _tmp1607_;
			_tmp1605_ = sig;
			_tmp1606_ = vala_signal_get_is_virtual (_tmp1605_);
			_tmp1607_ = _tmp1606_;
			_tmp1599_ = _tmp1607_;
		} else {
			_tmp1599_ = FALSE;
		}
		if (_tmp1599_) {
		} else {
			gboolean _tmp1608_ = FALSE;
			ValaSignal* _tmp1609_;
			_tmp1609_ = sig;
			if (!vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp1609_)) {
				_tmp1608_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1610_;
				ValaSourceReference* _tmp1611_;
				ValaSourceReference* _tmp1612_;
				ValaSourceFile* _tmp1613_;
				ValaSourceFile* _tmp1614_;
				ValaSignal* _tmp1615_;
				ValaSourceReference* _tmp1616_;
				ValaSourceReference* _tmp1617_;
				ValaSourceFile* _tmp1618_;
				ValaSourceFile* _tmp1619_;
				_tmp1610_ = ma;
				_tmp1611_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1610_);
				_tmp1612_ = _tmp1611_;
				_tmp1613_ = vala_source_reference_get_file (_tmp1612_);
				_tmp1614_ = _tmp1613_;
				_tmp1615_ = sig;
				_tmp1616_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1615_);
				_tmp1617_ = _tmp1616_;
				_tmp1618_ = vala_source_reference_get_file (_tmp1617_);
				_tmp1619_ = _tmp1618_;
				_tmp1608_ = _tmp1614_ == _tmp1619_;
			}
			if (_tmp1608_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1620_ = async_call;
	_tmp1621_ = ccall;
	if (_tmp1620_ == _tmp1621_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	_tmp1622_ = return_result_via_out_param;
	if (_tmp1622_) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1623_;
		ValaDataType* _tmp1624_;
		ValaDataType* _tmp1625_;
		ValaLocalVariable* _tmp1626_;
		ValaLocalVariable* _tmp1627_;
		ValaLocalVariable* _tmp1628_;
		const gchar* _tmp1629_;
		const gchar* _tmp1630_;
		ValaCCodeExpression* _tmp1631_;
		ValaLocalVariable* _tmp1632_;
		ValaHashMap* _tmp1633_;
		ValaCCodeExpression* _tmp1634_;
		ValaCCodeUnaryExpression* _tmp1635_;
		ValaCCodeUnaryExpression* _tmp1636_;
		_tmp1623_ = itype;
		_tmp1624_ = vala_data_type_get_return_type (_tmp1623_);
		_tmp1625_ = _tmp1624_;
		_tmp1626_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1625_, TRUE, NULL, TRUE);
		_tmp1627_ = _tmp1626_;
		_vala_code_node_unref0 (_tmp1625_);
		out_param_var = _tmp1627_;
		_tmp1628_ = out_param_var;
		_tmp1629_ = vala_symbol_get_name ((ValaSymbol*) _tmp1628_);
		_tmp1630_ = _tmp1629_;
		_tmp1631_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1630_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1631_;
		_tmp1632_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1632_, FALSE);
		_tmp1633_ = out_arg_map;
		_tmp1634_ = out_param_ref;
		_tmp1635_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1634_);
		_tmp1636_ = _tmp1635_;
		vala_map_set ((ValaMap*) _tmp1633_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1636_);
		_vala_ccode_node_unref0 (_tmp1636_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1637_ = async_call;
	_tmp1638_ = ccall;
	if (_tmp1637_ != _tmp1638_) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1655_;
			ValaCCodeFunctionCall* _tmp1656_;
			ValaHashMap* _tmp1657_;
			gint _tmp1658_;
			gpointer _tmp1659_;
			ValaCCodeExpression* _tmp1660_;
			gint _tmp1661_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1639_;
				ValaSet* _tmp1640_;
				ValaSet* _tmp1641_;
				ValaIterator* _tmp1642_;
				ValaIterator* _tmp1643_;
				_tmp1639_ = out_arg_map;
				_tmp1640_ = vala_map_get_keys ((ValaMap*) _tmp1639_);
				_tmp1641_ = _tmp1640_;
				_tmp1642_ = vala_iterable_iterator ((ValaIterable*) _tmp1641_);
				_tmp1643_ = _tmp1642_;
				_vala_iterable_unref0 (_tmp1641_);
				_pos_it = _tmp1643_;
				while (TRUE) {
					ValaIterator* _tmp1644_;
					gint pos = 0;
					ValaIterator* _tmp1645_;
					gpointer _tmp1646_;
					gboolean _tmp1647_ = FALSE;
					gint _tmp1648_;
					gint _tmp1649_;
					_tmp1644_ = _pos_it;
					if (!vala_iterator_next (_tmp1644_)) {
						break;
					}
					_tmp1645_ = _pos_it;
					_tmp1646_ = vala_iterator_get (_tmp1645_);
					pos = (gint) ((gintptr) _tmp1646_);
					_tmp1648_ = pos;
					_tmp1649_ = last_pos;
					if (_tmp1648_ > _tmp1649_) {
						gboolean _tmp1650_ = FALSE;
						gint _tmp1651_;
						_tmp1651_ = min_pos;
						if (_tmp1651_ == -1) {
							_tmp1650_ = TRUE;
						} else {
							gint _tmp1652_;
							gint _tmp1653_;
							_tmp1652_ = pos;
							_tmp1653_ = min_pos;
							_tmp1650_ = _tmp1652_ < _tmp1653_;
						}
						_tmp1647_ = _tmp1650_;
					} else {
						_tmp1647_ = FALSE;
					}
					if (_tmp1647_) {
						gint _tmp1654_;
						_tmp1654_ = pos;
						min_pos = _tmp1654_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1655_ = min_pos;
			if (_tmp1655_ == -1) {
				break;
			}
			_tmp1656_ = ccall;
			_tmp1657_ = out_arg_map;
			_tmp1658_ = min_pos;
			_tmp1659_ = vala_map_get ((ValaMap*) _tmp1657_, (gpointer) ((gintptr) _tmp1658_));
			_tmp1660_ = (ValaCCodeExpression*) _tmp1659_;
			vala_ccode_function_call_add_argument (_tmp1656_, _tmp1660_);
			_vala_ccode_node_unref0 (_tmp1660_);
			_tmp1661_ = min_pos;
			last_pos = _tmp1661_;
		}
	}
	_tmp1662_ = async_call;
	if (_tmp1662_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1679_;
			ValaCCodeFunctionCall* _tmp1680_;
			ValaHashMap* _tmp1681_;
			gint _tmp1682_;
			gpointer _tmp1683_;
			ValaCCodeExpression* _tmp1684_;
			gint _tmp1685_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1663_;
				ValaSet* _tmp1664_;
				ValaSet* _tmp1665_;
				ValaIterator* _tmp1666_;
				ValaIterator* _tmp1667_;
				_tmp1663_ = in_arg_map;
				_tmp1664_ = vala_map_get_keys ((ValaMap*) _tmp1663_);
				_tmp1665_ = _tmp1664_;
				_tmp1666_ = vala_iterable_iterator ((ValaIterable*) _tmp1665_);
				_tmp1667_ = _tmp1666_;
				_vala_iterable_unref0 (_tmp1665_);
				_pos_it = _tmp1667_;
				while (TRUE) {
					ValaIterator* _tmp1668_;
					gint pos = 0;
					ValaIterator* _tmp1669_;
					gpointer _tmp1670_;
					gboolean _tmp1671_ = FALSE;
					gint _tmp1672_;
					gint _tmp1673_;
					_tmp1668_ = _pos_it;
					if (!vala_iterator_next (_tmp1668_)) {
						break;
					}
					_tmp1669_ = _pos_it;
					_tmp1670_ = vala_iterator_get (_tmp1669_);
					pos = (gint) ((gintptr) _tmp1670_);
					_tmp1672_ = pos;
					_tmp1673_ = last_pos;
					if (_tmp1672_ > _tmp1673_) {
						gboolean _tmp1674_ = FALSE;
						gint _tmp1675_;
						_tmp1675_ = min_pos;
						if (_tmp1675_ == -1) {
							_tmp1674_ = TRUE;
						} else {
							gint _tmp1676_;
							gint _tmp1677_;
							_tmp1676_ = pos;
							_tmp1677_ = min_pos;
							_tmp1674_ = _tmp1676_ < _tmp1677_;
						}
						_tmp1671_ = _tmp1674_;
					} else {
						_tmp1671_ = FALSE;
					}
					if (_tmp1671_) {
						gint _tmp1678_;
						_tmp1678_ = pos;
						min_pos = _tmp1678_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1679_ = min_pos;
			if (_tmp1679_ == -1) {
				break;
			}
			_tmp1680_ = async_call;
			_tmp1681_ = in_arg_map;
			_tmp1682_ = min_pos;
			_tmp1683_ = vala_map_get ((ValaMap*) _tmp1681_, (gpointer) ((gintptr) _tmp1682_));
			_tmp1684_ = (ValaCCodeExpression*) _tmp1683_;
			vala_ccode_function_call_add_argument (_tmp1680_, _tmp1684_);
			_vala_ccode_node_unref0 (_tmp1684_);
			_tmp1685_ = min_pos;
			last_pos = _tmp1685_;
		}
	}
	_tmp1686_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1687_ = _tmp1686_;
	if (_tmp1687_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1688_;
		gint _tmp1689_;
		ValaCCodeFunction* _tmp1690_;
		ValaCCodeFunction* _tmp1691_;
		ValaCCodeIdentifier* _tmp1692_;
		ValaCCodeIdentifier* _tmp1693_;
		ValaCCodeMemberAccess* _tmp1694_;
		ValaCCodeMemberAccess* _tmp1695_;
		gint _tmp1696_;
		gchar* _tmp1697_;
		gchar* _tmp1698_;
		ValaCCodeConstant* _tmp1699_;
		ValaCCodeConstant* _tmp1700_;
		ValaCCodeFunction* _tmp1701_;
		ValaCCodeFunction* _tmp1702_;
		ValaCCodeFunctionCall* _tmp1703_;
		ValaCCodeFunction* _tmp1704_;
		ValaCCodeFunction* _tmp1705_;
		ValaCCodeConstant* _tmp1706_;
		ValaCCodeConstant* _tmp1707_;
		ValaCCodeFunction* _tmp1708_;
		ValaCCodeFunction* _tmp1709_;
		gint _tmp1710_;
		gchar* _tmp1711_;
		gchar* _tmp1712_;
		_tmp1688_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1689_ = _tmp1688_->next_coroutine_state;
		_tmp1688_->next_coroutine_state = _tmp1689_ + 1;
		state = _tmp1689_;
		_tmp1690_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1691_ = _tmp1690_;
		_tmp1692_ = vala_ccode_identifier_new ("_data_");
		_tmp1693_ = _tmp1692_;
		_tmp1694_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1693_, "_state_");
		_tmp1695_ = _tmp1694_;
		_tmp1696_ = state;
		_tmp1697_ = g_strdup_printf ("%i", _tmp1696_);
		_tmp1698_ = _tmp1697_;
		_tmp1699_ = vala_ccode_constant_new (_tmp1698_);
		_tmp1700_ = _tmp1699_;
		vala_ccode_function_add_assignment (_tmp1691_, (ValaCCodeExpression*) _tmp1695_, (ValaCCodeExpression*) _tmp1700_);
		_vala_ccode_node_unref0 (_tmp1700_);
		_g_free0 (_tmp1698_);
		_vala_ccode_node_unref0 (_tmp1695_);
		_vala_ccode_node_unref0 (_tmp1693_);
		_tmp1701_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1702_ = _tmp1701_;
		_tmp1703_ = async_call;
		vala_ccode_function_add_expression (_tmp1702_, (ValaCCodeExpression*) _tmp1703_);
		_tmp1704_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1705_ = _tmp1704_;
		_tmp1706_ = vala_ccode_constant_new ("FALSE");
		_tmp1707_ = _tmp1706_;
		vala_ccode_function_add_return (_tmp1705_, (ValaCCodeExpression*) _tmp1707_);
		_vala_ccode_node_unref0 (_tmp1707_);
		_tmp1708_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1709_ = _tmp1708_;
		_tmp1710_ = state;
		_tmp1711_ = g_strdup_printf ("_state_%d", _tmp1710_);
		_tmp1712_ = _tmp1711_;
		vala_ccode_function_add_label (_tmp1709_, _tmp1712_);
		_g_free0 (_tmp1712_);
	}
	_tmp1713_ = vala_method_call_get_is_assert (expr);
	_tmp1714_ = _tmp1713_;
	if (_tmp1714_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1715_;
		ValaSourceReference* _tmp1716_;
		ValaSourceLocation _tmp1717_ = {0};
		ValaSourceLocation _tmp1718_;
		gchar* _tmp1719_;
		ValaSourceReference* _tmp1720_;
		ValaSourceReference* _tmp1721_;
		ValaSourceLocation _tmp1722_ = {0};
		ValaSourceLocation _tmp1723_;
		gchar* _tmp1724_;
		ValaSourceReference* _tmp1725_;
		ValaSourceReference* _tmp1726_;
		ValaSourceLocation _tmp1727_ = {0};
		ValaSourceLocation _tmp1728_;
		gchar* _tmp1729_;
		gchar* _tmp1730_;
		ValaCCodeFunctionCall* _tmp1731_;
		ValaCCodeIdentifier* _tmp1732_;
		ValaCCodeIdentifier* _tmp1733_;
		ValaCCodeFunctionCall* _tmp1734_;
		const gchar* _tmp1735_;
		gchar* _tmp1736_;
		gchar* _tmp1737_;
		gchar* _tmp1738_;
		gchar* _tmp1739_;
		gchar* _tmp1740_;
		gchar* _tmp1741_;
		ValaCCodeConstant* _tmp1742_;
		ValaCCodeConstant* _tmp1743_;
		_tmp1715_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1716_ = _tmp1715_;
		vala_source_reference_get_begin (_tmp1716_, &_tmp1717_);
		_tmp1718_ = _tmp1717_;
		_tmp1719_ = _tmp1718_.pos;
		_tmp1720_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1721_ = _tmp1720_;
		vala_source_reference_get_end (_tmp1721_, &_tmp1722_);
		_tmp1723_ = _tmp1722_;
		_tmp1724_ = _tmp1723_.pos;
		_tmp1725_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1726_ = _tmp1725_;
		vala_source_reference_get_begin (_tmp1726_, &_tmp1727_);
		_tmp1728_ = _tmp1727_;
		_tmp1729_ = _tmp1728_.pos;
		_tmp1730_ = string_substring ((const gchar*) _tmp1719_, (glong) 0, (glong) ((gint) (_tmp1724_ - _tmp1729_)));
		message = _tmp1730_;
		_tmp1731_ = ccall;
		_tmp1732_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1733_ = _tmp1732_;
		vala_ccode_function_call_set_call (_tmp1731_, (ValaCCodeExpression*) _tmp1733_);
		_vala_ccode_node_unref0 (_tmp1733_);
		_tmp1734_ = ccall;
		_tmp1735_ = message;
		_tmp1736_ = string_replace (_tmp1735_, "\n", " ");
		_tmp1737_ = _tmp1736_;
		_tmp1738_ = g_strescape (_tmp1737_, "");
		_tmp1739_ = _tmp1738_;
		_tmp1740_ = g_strdup_printf ("\"%s\"", _tmp1739_);
		_tmp1741_ = _tmp1740_;
		_tmp1742_ = vala_ccode_constant_new (_tmp1741_);
		_tmp1743_ = _tmp1742_;
		vala_ccode_function_call_add_argument (_tmp1734_, (ValaCCodeExpression*) _tmp1743_);
		_vala_ccode_node_unref0 (_tmp1743_);
		_g_free0 (_tmp1741_);
		_g_free0 (_tmp1739_);
		_g_free0 (_tmp1737_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	_tmp1744_ = return_result_via_out_param;
	if (_tmp1744_) {
		ValaCCodeFunction* _tmp1745_;
		ValaCCodeFunction* _tmp1746_;
		ValaCCodeExpression* _tmp1747_;
		ValaCCodeExpression* _tmp1748_;
		ValaCCodeExpression* _tmp1749_;
		_tmp1745_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1746_ = _tmp1745_;
		_tmp1747_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1746_, _tmp1747_);
		_tmp1748_ = out_param_ref;
		_tmp1749_ = _vala_ccode_node_ref0 (_tmp1748_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1749_;
	}
	_tmp1752_ = m;
	if (_tmp1752_ != NULL) {
		ValaMethod* _tmp1753_;
		ValaMemberBinding _tmp1754_;
		ValaMemberBinding _tmp1755_;
		_tmp1753_ = m;
		_tmp1754_ = vala_method_get_binding (_tmp1753_);
		_tmp1755_ = _tmp1754_;
		_tmp1751_ = _tmp1755_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1751_ = FALSE;
	}
	if (_tmp1751_) {
		ValaMethod* _tmp1756_;
		gboolean _tmp1757_;
		gboolean _tmp1758_;
		_tmp1756_ = m;
		_tmp1757_ = vala_method_get_returns_modified_pointer (_tmp1756_);
		_tmp1758_ = _tmp1757_;
		_tmp1750_ = _tmp1758_;
	} else {
		_tmp1750_ = FALSE;
	}
	if (_tmp1750_) {
		gboolean _tmp1759_ = FALSE;
		gboolean _tmp1760_ = FALSE;
		ValaMemberAccess* _tmp1761_;
		_tmp1761_ = ma;
		if (_tmp1761_ != NULL) {
			ValaMemberAccess* _tmp1762_;
			ValaExpression* _tmp1763_;
			ValaExpression* _tmp1764_;
			ValaSymbol* _tmp1765_;
			ValaSymbol* _tmp1766_;
			_tmp1762_ = ma;
			_tmp1763_ = vala_member_access_get_inner (_tmp1762_);
			_tmp1764_ = _tmp1763_;
			_tmp1765_ = vala_expression_get_symbol_reference (_tmp1764_);
			_tmp1766_ = _tmp1765_;
			_tmp1760_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1766_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1760_ = FALSE;
		}
		if (_tmp1760_) {
			ValaMemberAccess* _tmp1767_;
			ValaExpression* _tmp1768_;
			ValaExpression* _tmp1769_;
			_tmp1767_ = ma;
			_tmp1768_ = vala_member_access_get_inner (_tmp1767_);
			_tmp1769_ = _tmp1768_;
			_tmp1759_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1769_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1759_ = FALSE;
		}
		if (_tmp1759_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1770_;
			ValaExpression* _tmp1771_;
			ValaExpression* _tmp1772_;
			ValaSymbol* _tmp1773_;
			ValaSymbol* _tmp1774_;
			ValaProperty* _tmp1775_;
			ValaProperty* _tmp1776_;
			ValaMemberAccess* _tmp1777_;
			ValaExpression* _tmp1778_;
			ValaExpression* _tmp1779_;
			ValaExpression* _tmp1780_;
			ValaExpression* _tmp1781_;
			ValaDataType* _tmp1782_;
			ValaDataType* _tmp1783_;
			ValaCCodeExpression* _tmp1784_;
			ValaGLibValue* _tmp1785_;
			ValaGLibValue* _tmp1786_;
			_tmp1770_ = ma;
			_tmp1771_ = vala_member_access_get_inner (_tmp1770_);
			_tmp1772_ = _tmp1771_;
			_tmp1773_ = vala_expression_get_symbol_reference (_tmp1772_);
			_tmp1774_ = _tmp1773_;
			_tmp1775_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1774_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1775_;
			_tmp1776_ = prop;
			_tmp1777_ = ma;
			_tmp1778_ = vala_member_access_get_inner (_tmp1777_);
			_tmp1779_ = _tmp1778_;
			_tmp1780_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1779_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1781_ = _tmp1780_;
			_tmp1782_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1783_ = _tmp1782_;
			_tmp1784_ = ccall_expr;
			_tmp1785_ = vala_glib_value_new (_tmp1783_, _tmp1784_, FALSE);
			_tmp1786_ = _tmp1785_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1776_, _tmp1781_, (ValaTargetValue*) _tmp1786_);
			_vala_target_value_unref0 (_tmp1786_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1787_;
			ValaCCodeExpression* _tmp1788_;
			ValaCCodeAssignment* _tmp1789_;
			_tmp1787_ = instance;
			_tmp1788_ = ccall_expr;
			_tmp1789_ = vala_ccode_assignment_new (_tmp1787_, _tmp1788_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1789_;
		}
	}
	_tmp1795_ = m;
	if (_tmp1795_ != NULL) {
		ValaMethod* _tmp1796_;
		_tmp1796_ = m;
		_tmp1794_ = vala_get_ccode_simple_generics (_tmp1796_);
	} else {
		_tmp1794_ = FALSE;
	}
	if (_tmp1794_) {
		ValaMethod* _tmp1797_;
		ValaDataType* _tmp1798_;
		ValaDataType* _tmp1799_;
		_tmp1797_ = m;
		_tmp1798_ = vala_callable_get_return_type ((ValaCallable*) _tmp1797_);
		_tmp1799_ = _tmp1798_;
		_tmp1793_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1799_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1793_ = FALSE;
	}
	if (_tmp1793_) {
		ValaDataType* _tmp1800_;
		ValaDataType* _tmp1801_;
		_tmp1800_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1801_ = _tmp1800_;
		_tmp1792_ = vala_data_type_is_real_struct_type (_tmp1801_);
	} else {
		_tmp1792_ = FALSE;
	}
	if (_tmp1792_) {
		ValaDataType* _tmp1802_;
		ValaDataType* _tmp1803_;
		gboolean _tmp1804_;
		gboolean _tmp1805_;
		_tmp1802_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1803_ = _tmp1802_;
		_tmp1804_ = vala_data_type_get_nullable (_tmp1803_);
		_tmp1805_ = _tmp1804_;
		_tmp1791_ = !_tmp1805_;
	} else {
		_tmp1791_ = FALSE;
	}
	if (_tmp1791_) {
		ValaDataType* _tmp1806_;
		ValaDataType* _tmp1807_;
		_tmp1806_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1807_ = _tmp1806_;
		_tmp1790_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1807_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1790_ = FALSE;
	}
	if (_tmp1790_) {
		ValaCCodeExpression* _tmp1808_;
		ValaCCodeParenthesizedExpression* _tmp1809_;
		ValaCCodeParenthesizedExpression* _tmp1810_;
		ValaCCodeUnaryExpression* _tmp1811_;
		_tmp1808_ = ccall_expr;
		_tmp1809_ = vala_ccode_parenthesized_expression_new (_tmp1808_);
		_tmp1810_ = _tmp1809_;
		_tmp1811_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1810_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1811_;
		_vala_ccode_node_unref0 (_tmp1810_);
	}
	_tmp1814_ = m;
	if (_tmp1814_ != NULL) {
		ValaMethod* _tmp1815_;
		gchar* _tmp1816_;
		gchar* _tmp1817_;
		_tmp1815_ = m;
		_tmp1816_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1815_);
		_tmp1817_ = _tmp1816_;
		_tmp1813_ = _tmp1817_ != NULL;
		_g_free0 (_tmp1817_);
	} else {
		_tmp1813_ = FALSE;
	}
	if (_tmp1813_) {
		ValaMethod* _tmp1818_;
		gchar* _tmp1819_;
		gchar* _tmp1820_;
		ValaMethod* _tmp1821_;
		ValaDataType* _tmp1822_;
		ValaDataType* _tmp1823_;
		gchar* _tmp1824_;
		gchar* _tmp1825_;
		_tmp1818_ = m;
		_tmp1819_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1818_);
		_tmp1820_ = _tmp1819_;
		_tmp1821_ = m;
		_tmp1822_ = vala_callable_get_return_type ((ValaCallable*) _tmp1821_);
		_tmp1823_ = _tmp1822_;
		_tmp1824_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1823_);
		_tmp1825_ = _tmp1824_;
		_tmp1812_ = g_strcmp0 (_tmp1820_, _tmp1825_) != 0;
		_g_free0 (_tmp1825_);
		_g_free0 (_tmp1820_);
	} else {
		_tmp1812_ = FALSE;
	}
	if (_tmp1812_) {
		ValaCCodeExpression* _tmp1826_;
		ValaMethod* _tmp1827_;
		ValaDataType* _tmp1828_;
		ValaDataType* _tmp1829_;
		gchar* _tmp1830_;
		gchar* _tmp1831_;
		ValaCCodeCastExpression* _tmp1832_;
		_tmp1826_ = ccall_expr;
		_tmp1827_ = m;
		_tmp1828_ = vala_callable_get_return_type ((ValaCallable*) _tmp1827_);
		_tmp1829_ = _tmp1828_;
		_tmp1830_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1829_);
		_tmp1831_ = _tmp1830_;
		_tmp1832_ = vala_ccode_cast_expression_new (_tmp1826_, _tmp1831_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1832_;
		_g_free0 (_tmp1831_);
	}
	_tmp1833_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1833_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1834_;
		ValaList* _tmp1835_;
		ValaIterator* _tmp1836_;
		ValaIterator* _tmp1837_;
		ValaIterator* _tmp1838_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1839_;
		gpointer _tmp1840_;
		ValaExpression* _tmp1841_;
		ValaCCodeExpression* _tmp1842_;
		ValaCCodeExpression* _tmp1843_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1844_;
		ValaLocalVariable* _tmp1845_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1846_;
		const gchar* _tmp1847_;
		const gchar* _tmp1848_;
		ValaCCodeExpression* _tmp1849_;
		ValaLocalVariable* _tmp1850_;
		ValaCCodeFile* _tmp1851_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1852_;
		ValaExpression* _tmp1853_;
		ValaExpression* _tmp1854_;
		ValaCCodeExpression* _tmp1855_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1856_;
		ValaExpression* _tmp1857_;
		ValaExpression* _tmp1858_;
		ValaCCodeExpression* _tmp1859_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1860_;
		ValaExpression* _tmp1861_;
		ValaExpression* _tmp1862_;
		ValaDataType* _tmp1863_;
		ValaDataType* _tmp1864_;
		ValaArrayType* _tmp1865_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1866_;
		ValaDataType* _tmp1867_;
		ValaDataType* _tmp1868_;
		gchar* _tmp1869_;
		gchar* _tmp1870_;
		gchar* _tmp1871_;
		gchar* _tmp1872_;
		ValaCCodeIdentifier* _tmp1873_;
		ValaCCodeIdentifier* _tmp1874_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1875_;
		ValaCCodeExpression* _tmp1876_;
		ValaCCodeBinaryExpression* _tmp1877_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1878_;
		ValaCCodeExpression* _tmp1879_;
		ValaCCodeBinaryExpression* _tmp1880_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1881_;
		ValaCCodeIdentifier* _tmp1882_;
		ValaCCodeFunctionCall* _tmp1883_;
		ValaCCodeFunctionCall* _tmp1884_;
		ValaCCodeFunctionCall* _tmp1885_;
		ValaCCodeExpression* _tmp1886_;
		ValaCCodeExpression* _tmp1887_;
		ValaCCodeBinaryExpression* _tmp1888_;
		ValaCCodeBinaryExpression* _tmp1889_;
		ValaCCodeFunctionCall* _tmp1890_;
		ValaCCodeConstant* _tmp1891_;
		ValaCCodeConstant* _tmp1892_;
		ValaCCodeFunctionCall* _tmp1893_;
		ValaCCodeIdentifier* _tmp1894_;
		ValaCCodeBinaryExpression* _tmp1895_;
		ValaCCodeBinaryExpression* _tmp1896_;
		ValaCCodeBinaryExpression* _tmp1897_;
		ValaCCodeFunction* _tmp1898_;
		ValaCCodeFunction* _tmp1899_;
		ValaCCodeExpression* _tmp1900_;
		ValaCCodeExpression* _tmp1901_;
		ValaCCodeFunction* _tmp1902_;
		ValaCCodeFunction* _tmp1903_;
		ValaCCodeExpression* _tmp1904_;
		ValaCCodeFunction* _tmp1905_;
		ValaCCodeFunction* _tmp1906_;
		ValaCCodeBinaryExpression* _tmp1907_;
		ValaCCodeFunctionCall* _tmp1908_;
		ValaCCodeConstant* _tmp1909_;
		ValaCCodeConstant* _tmp1910_;
		ValaCCodeConditionalExpression* _tmp1911_;
		ValaCCodeConditionalExpression* _tmp1912_;
		ValaCCodeFunction* _tmp1913_;
		ValaCCodeFunction* _tmp1914_;
		ValaMemberAccess* _tmp1915_;
		ValaExpression* _tmp1916_;
		ValaExpression* _tmp1917_;
		ValaCCodeExpression* _tmp1918_;
		ValaCCodeExpression* _tmp1919_;
		ValaCCodeExpression* _tmp1920_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1921_;
		ValaExpression* _tmp1922_;
		ValaExpression* _tmp1923_;
		ValaSymbol* _tmp1924_;
		ValaSymbol* _tmp1925_;
		ValaSymbol* _tmp1926_;
		gboolean _tmp1927_ = FALSE;
		gboolean _tmp1928_ = FALSE;
		ValaSymbol* _tmp1929_;
		_tmp1834_ = vala_method_call_get_argument_list (expr);
		_tmp1835_ = _tmp1834_;
		_tmp1836_ = vala_iterable_iterator ((ValaIterable*) _tmp1835_);
		_tmp1837_ = _tmp1836_;
		_vala_iterable_unref0 (_tmp1835_);
		arg_it = _tmp1837_;
		_tmp1838_ = arg_it;
		vala_iterator_next (_tmp1838_);
		_tmp1839_ = arg_it;
		_tmp1840_ = vala_iterator_get (_tmp1839_);
		_tmp1841_ = (ValaExpression*) _tmp1840_;
		_tmp1842_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1841_);
		_tmp1843_ = _tmp1842_;
		_vala_code_node_unref0 (_tmp1841_);
		new_size = _tmp1843_;
		_tmp1844_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1845_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1844_, TRUE, NULL, FALSE);
		temp_decl = _tmp1845_;
		_tmp1846_ = temp_decl;
		_tmp1847_ = vala_symbol_get_name ((ValaSymbol*) _tmp1846_);
		_tmp1848_ = _tmp1847_;
		_tmp1849_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1848_);
		temp_ref = _tmp1849_;
		_tmp1850_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1850_, FALSE);
		_tmp1851_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1851_, "string.h", FALSE);
		_tmp1852_ = ma;
		_tmp1853_ = vala_member_access_get_inner (_tmp1852_);
		_tmp1854_ = _tmp1853_;
		_tmp1855_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1854_, 1);
		clen = _tmp1855_;
		_tmp1856_ = ma;
		_tmp1857_ = vala_member_access_get_inner (_tmp1856_);
		_tmp1858_ = _tmp1857_;
		_tmp1859_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1858_);
		celems = _tmp1859_;
		_tmp1860_ = ma;
		_tmp1861_ = vala_member_access_get_inner (_tmp1860_);
		_tmp1862_ = _tmp1861_;
		_tmp1863_ = vala_expression_get_value_type (_tmp1862_);
		_tmp1864_ = _tmp1863_;
		_tmp1865_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1864_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1865_;
		_tmp1866_ = array_type;
		_tmp1867_ = vala_array_type_get_element_type (_tmp1866_);
		_tmp1868_ = _tmp1867_;
		_tmp1869_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1868_);
		_tmp1870_ = _tmp1869_;
		_tmp1871_ = g_strdup_printf ("sizeof (%s)", _tmp1870_);
		_tmp1872_ = _tmp1871_;
		_tmp1873_ = vala_ccode_identifier_new (_tmp1872_);
		_tmp1874_ = _tmp1873_;
		_g_free0 (_tmp1872_);
		_g_free0 (_tmp1870_);
		csizeof = _tmp1874_;
		_tmp1875_ = temp_ref;
		_tmp1876_ = clen;
		_tmp1877_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1875_, _tmp1876_);
		cdelta = _tmp1877_;
		_tmp1878_ = temp_ref;
		_tmp1879_ = clen;
		_tmp1880_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1878_, _tmp1879_);
		ccheck = _tmp1880_;
		_tmp1881_ = vala_ccode_identifier_new ("memset");
		_tmp1882_ = _tmp1881_;
		_tmp1883_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1882_);
		_tmp1884_ = _tmp1883_;
		_vala_ccode_node_unref0 (_tmp1882_);
		czero = _tmp1884_;
		_tmp1885_ = czero;
		_tmp1886_ = celems;
		_tmp1887_ = clen;
		_tmp1888_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1886_, _tmp1887_);
		_tmp1889_ = _tmp1888_;
		vala_ccode_function_call_add_argument (_tmp1885_, (ValaCCodeExpression*) _tmp1889_);
		_vala_ccode_node_unref0 (_tmp1889_);
		_tmp1890_ = czero;
		_tmp1891_ = vala_ccode_constant_new ("0");
		_tmp1892_ = _tmp1891_;
		vala_ccode_function_call_add_argument (_tmp1890_, (ValaCCodeExpression*) _tmp1892_);
		_vala_ccode_node_unref0 (_tmp1892_);
		_tmp1893_ = czero;
		_tmp1894_ = csizeof;
		_tmp1895_ = cdelta;
		_tmp1896_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1894_, (ValaCCodeExpression*) _tmp1895_);
		_tmp1897_ = _tmp1896_;
		vala_ccode_function_call_add_argument (_tmp1893_, (ValaCCodeExpression*) _tmp1897_);
		_vala_ccode_node_unref0 (_tmp1897_);
		_tmp1898_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1899_ = _tmp1898_;
		_tmp1900_ = temp_ref;
		_tmp1901_ = new_size;
		vala_ccode_function_add_assignment (_tmp1899_, _tmp1900_, _tmp1901_);
		_tmp1902_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1903_ = _tmp1902_;
		_tmp1904_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1903_, _tmp1904_);
		_tmp1905_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1906_ = _tmp1905_;
		_tmp1907_ = ccheck;
		_tmp1908_ = czero;
		_tmp1909_ = vala_ccode_constant_new ("NULL");
		_tmp1910_ = _tmp1909_;
		_tmp1911_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1907_, (ValaCCodeExpression*) _tmp1908_, (ValaCCodeExpression*) _tmp1910_);
		_tmp1912_ = _tmp1911_;
		vala_ccode_function_add_expression (_tmp1906_, (ValaCCodeExpression*) _tmp1912_);
		_vala_ccode_node_unref0 (_tmp1912_);
		_vala_ccode_node_unref0 (_tmp1910_);
		_tmp1913_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1914_ = _tmp1913_;
		_tmp1915_ = ma;
		_tmp1916_ = vala_member_access_get_inner (_tmp1915_);
		_tmp1917_ = _tmp1916_;
		_tmp1918_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1917_, 1);
		_tmp1919_ = _tmp1918_;
		_tmp1920_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1914_, _tmp1919_, _tmp1920_);
		_vala_ccode_node_unref0 (_tmp1919_);
		_tmp1921_ = ma;
		_tmp1922_ = vala_member_access_get_inner (_tmp1921_);
		_tmp1923_ = _tmp1922_;
		_tmp1924_ = vala_expression_get_symbol_reference (_tmp1923_);
		_tmp1925_ = _tmp1924_;
		_tmp1926_ = _vala_code_node_ref0 (_tmp1925_);
		array_var = _tmp1926_;
		_tmp1929_ = array_var;
		if (_tmp1929_ != NULL) {
			ValaSymbol* _tmp1930_;
			_tmp1930_ = array_var;
			_tmp1928_ = vala_symbol_is_internal_symbol (_tmp1930_);
		} else {
			_tmp1928_ = FALSE;
		}
		if (_tmp1928_) {
			gboolean _tmp1931_ = FALSE;
			ValaSymbol* _tmp1932_;
			_tmp1932_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1932_, VALA_TYPE_LOCAL_VARIABLE)) {
				_tmp1931_ = TRUE;
			} else {
				ValaSymbol* _tmp1933_;
				_tmp1933_ = array_var;
				_tmp1931_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1933_, VALA_TYPE_FIELD);
			}
			_tmp1927_ = _tmp1931_;
		} else {
			_tmp1927_ = FALSE;
		}
		if (_tmp1927_) {
			ValaCCodeFunction* _tmp1934_;
			ValaCCodeFunction* _tmp1935_;
			ValaMemberAccess* _tmp1936_;
			ValaExpression* _tmp1937_;
			ValaExpression* _tmp1938_;
			ValaTargetValue* _tmp1939_;
			ValaTargetValue* _tmp1940_;
			ValaCCodeExpression* _tmp1941_;
			ValaCCodeExpression* _tmp1942_;
			ValaCCodeExpression* _tmp1943_;
			_tmp1934_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1935_ = _tmp1934_;
			_tmp1936_ = ma;
			_tmp1937_ = vala_member_access_get_inner (_tmp1936_);
			_tmp1938_ = _tmp1937_;
			_tmp1939_ = vala_expression_get_target_value (_tmp1938_);
			_tmp1940_ = _tmp1939_;
			_tmp1941_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1940_);
			_tmp1942_ = _tmp1941_;
			_tmp1943_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1935_, _tmp1942_, _tmp1943_);
			_vala_ccode_node_unref0 (_tmp1942_);
		}
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1945_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1946_ = _tmp1945_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1946_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1947_;
		ValaDataType* _tmp1948_;
		_tmp1947_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1948_ = _tmp1947_;
		_tmp1944_ = !vala_data_type_is_disposable (_tmp1948_);
	} else {
		_tmp1944_ = FALSE;
	}
	if (_tmp1944_) {
		gboolean _tmp1949_ = FALSE;
		ValaCCodeExpression* _tmp1950_;
		_tmp1950_ = ccall_expr;
		if (_tmp1950_ != NULL) {
			gboolean _tmp1951_;
			_tmp1951_ = return_result_via_out_param;
			_tmp1949_ = !_tmp1951_;
		} else {
			_tmp1949_ = FALSE;
		}
		if (_tmp1949_) {
			ValaCCodeFunction* _tmp1952_;
			ValaCCodeFunction* _tmp1953_;
			ValaCCodeExpression* _tmp1954_;
			_tmp1952_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1953_ = _tmp1952_;
			_tmp1954_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1953_, _tmp1954_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1955_;
		ValaDataType* _tmp1956_;
		gboolean _tmp1957_ = FALSE;
		ValaDataType* _tmp1958_;
		ValaDataType* _tmp1959_;
		gboolean _tmp1986_ = FALSE;
		ValaMethod* _tmp1987_;
		_tmp1955_ = itype;
		_tmp1956_ = vala_data_type_get_return_type (_tmp1955_);
		result_type = _tmp1956_;
		_tmp1958_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1959_ = _tmp1958_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1959_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1960_;
			ValaDataType* _tmp1961_;
			_tmp1960_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1961_ = _tmp1960_;
			_tmp1957_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1961_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1957_ = FALSE;
		}
		if (_tmp1957_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1962_;
			ValaDataType* _tmp1963_;
			ValaTypeParameter* _tmp1964_;
			ValaTypeParameter* _tmp1965_;
			ValaTypeParameter* _tmp1966_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1967_;
			ValaSymbol* _tmp1968_;
			ValaSymbol* _tmp1969_;
			ValaSymbol* _tmp1970_;
			ValaSymbol* _tmp1971_;
			ValaStruct* _tmp1972_;
			gboolean _tmp1973_ = FALSE;
			ValaTypeParameter* _tmp1974_;
			ValaSymbol* _tmp1975_;
			ValaSymbol* _tmp1976_;
			ValaTypeSymbol* _tmp1977_;
			_tmp1962_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1963_ = _tmp1962_;
			_tmp1964_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1963_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1965_ = _tmp1964_;
			_tmp1966_ = _vala_code_node_ref0 (_tmp1965_);
			type_parameter = _tmp1966_;
			_tmp1967_ = type_parameter;
			_tmp1968_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1967_);
			_tmp1969_ = _tmp1968_;
			_tmp1970_ = vala_symbol_get_parent_symbol (_tmp1969_);
			_tmp1971_ = _tmp1970_;
			_tmp1972_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1971_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1971_) : NULL);
			st = _tmp1972_;
			_tmp1974_ = type_parameter;
			_tmp1975_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1974_);
			_tmp1976_ = _tmp1975_;
			_tmp1977_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1976_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1977_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1973_ = TRUE;
			} else {
				gboolean _tmp1978_ = FALSE;
				ValaStruct* _tmp1979_;
				_tmp1979_ = st;
				if (_tmp1979_ != NULL) {
					ValaStruct* _tmp1980_;
					gchar* _tmp1981_;
					gchar* _tmp1982_;
					_tmp1980_ = st;
					_tmp1981_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1980_);
					_tmp1982_ = _tmp1981_;
					_tmp1978_ = g_strcmp0 (_tmp1982_, "va_list") == 0;
					_g_free0 (_tmp1982_);
				} else {
					_tmp1978_ = FALSE;
				}
				_tmp1973_ = _tmp1978_;
			}
			if (_tmp1973_) {
				ValaDataType* _tmp1983_;
				ValaDataType* _tmp1984_;
				ValaDataType* _tmp1985_;
				_tmp1983_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1984_ = _tmp1983_;
				_tmp1985_ = _vala_code_node_ref0 (_tmp1984_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1985_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp1987_ = m;
		if (_tmp1987_ != NULL) {
			ValaMethod* _tmp1988_;
			_tmp1988_ = m;
			_tmp1986_ = vala_method_get_format_arg_index (_tmp1988_) >= 0;
		} else {
			_tmp1986_ = FALSE;
		}
		if (_tmp1986_) {
			ValaCCodeExpression* _tmp1989_;
			_tmp1989_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1989_);
		} else {
			gboolean _tmp1990_ = FALSE;
			ValaMethod* _tmp1991_;
			_tmp1991_ = m;
			if (_tmp1991_ != NULL) {
				ValaMethod* _tmp1992_;
				_tmp1992_ = m;
				_tmp1990_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp1992_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp1990_ = FALSE;
			}
			if (_tmp1990_) {
				ValaCCodeExpression* _tmp1993_;
				_tmp1993_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1993_);
			} else {
				gboolean _tmp1994_ = FALSE;
				gboolean _tmp1995_ = FALSE;
				gboolean _tmp1996_;
				_tmp1996_ = return_result_via_out_param;
				if (!_tmp1996_) {
					_tmp1995_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp1995_ = FALSE;
				}
				if (_tmp1995_) {
					gboolean _tmp1997_ = FALSE;
					ValaDataType* _tmp1998_;
					_tmp1998_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1998_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp1999_;
						_tmp1999_ = result_type;
						_tmp1997_ = !vala_data_type_is_disposable (_tmp1999_);
					} else {
						_tmp1997_ = FALSE;
					}
					_tmp1994_ = _tmp1997_;
				} else {
					_tmp1994_ = FALSE;
				}
				if (_tmp1994_) {
					ValaCCodeExpression* _tmp2000_;
					_tmp2000_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2000_);
				} else {
					gboolean _tmp2001_;
					_tmp2001_ = return_result_via_out_param;
					if (!_tmp2001_) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2002_;
						ValaDataType* _tmp2003_;
						gboolean _tmp2004_;
						gboolean _tmp2005_;
						ValaLocalVariable* _tmp2006_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2007_;
						const gchar* _tmp2008_;
						const gchar* _tmp2009_;
						ValaCCodeExpression* _tmp2010_;
						ValaLocalVariable* _tmp2011_;
						ValaCCodeFunction* _tmp2012_;
						ValaCCodeFunction* _tmp2013_;
						ValaCCodeExpression* _tmp2014_;
						ValaCCodeExpression* _tmp2015_;
						ValaCCodeExpression* _tmp2016_;
						ValaTargetValue* _tmp2017_;
						ValaTargetValue* _tmp2018_;
						_tmp2002_ = result_type;
						_tmp2003_ = result_type;
						_tmp2004_ = vala_data_type_get_value_owned (_tmp2003_);
						_tmp2005_ = _tmp2004_;
						_tmp2006_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2002_, _tmp2005_, NULL, FALSE);
						temp_var = _tmp2006_;
						_tmp2007_ = temp_var;
						_tmp2008_ = vala_symbol_get_name ((ValaSymbol*) _tmp2007_);
						_tmp2009_ = _tmp2008_;
						_tmp2010_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2009_);
						temp_ref = _tmp2010_;
						_tmp2011_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2011_, FALSE);
						_tmp2012_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2013_ = _tmp2012_;
						_tmp2014_ = temp_ref;
						_tmp2015_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2013_, _tmp2014_, _tmp2015_);
						_tmp2016_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2016_);
						_tmp2017_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2018_ = _tmp2017_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2018_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2019_;
						ValaTargetValue* _tmp2020_;
						ValaTargetValue* _tmp2021_;
						_tmp2019_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2019_);
						_tmp2020_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2021_ = _tmp2020_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2021_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2022_ = params;
	_tmp2023_ = vala_iterable_iterator ((ValaIterable*) _tmp2022_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2023_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2024_;
		gint _arg_size = 0;
		ValaList* _tmp2025_;
		gint _tmp2026_;
		gint _tmp2027_;
		gint _arg_index = 0;
		_tmp2024_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp2024_;
		_tmp2025_ = _arg_list;
		_tmp2026_ = vala_collection_get_size ((ValaCollection*) _tmp2025_);
		_tmp2027_ = _tmp2026_;
		_arg_size = _tmp2027_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp2028_;
			gint _tmp2029_;
			ValaExpression* arg = NULL;
			ValaList* _tmp2030_;
			gint _tmp2031_;
			gpointer _tmp2032_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2033_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2036_;
			ValaUnaryExpression* _tmp2037_;
			gboolean _tmp2038_ = FALSE;
			ValaUnaryExpression* _tmp2039_;
			gboolean _tmp2090_ = FALSE;
			ValaUnaryExpression* _tmp2091_;
			ValaUnaryExpression* _tmp2095_;
			ValaExpression* _tmp2096_;
			ValaExpression* _tmp2097_;
			ValaDataType* _tmp2098_;
			ValaDataType* _tmp2099_;
			gboolean _tmp2109_ = FALSE;
			ValaMemberAccess* _tmp2110_;
			ValaSymbol* _tmp2111_;
			ValaSymbol* _tmp2112_;
			ValaUnaryExpression* _tmp2128_;
			ValaExpression* _tmp2129_;
			ValaExpression* _tmp2130_;
			ValaTargetValue* _tmp2131_;
			ValaTargetValue* _tmp2132_;
			ValaUnaryExpression* _tmp2133_;
			ValaTargetValue* _tmp2134_;
			ValaTargetValue* _tmp2135_;
			ValaUnaryExpression* _tmp2136_;
			ValaExpression* _tmp2137_;
			ValaExpression* _tmp2138_;
			ValaDataType* _tmp2139_;
			ValaDataType* _tmp2140_;
			ValaExpression* _tmp2141_;
			ValaTargetValue* _tmp2142_;
			ValaTargetValue* _tmp2143_;
			ValaSourceReference* _tmp2144_;
			ValaSourceReference* _tmp2145_;
			gboolean _tmp2146_ = FALSE;
			ValaParameter* _tmp2147_;
			_arg_index = _arg_index + 1;
			_tmp2028_ = _arg_index;
			_tmp2029_ = _arg_size;
			if (!(_tmp2028_ < _tmp2029_)) {
				break;
			}
			_tmp2030_ = _arg_list;
			_tmp2031_ = _arg_index;
			_tmp2032_ = vala_list_get (_tmp2030_, _tmp2031_);
			arg = (ValaExpression*) _tmp2032_;
			param = NULL;
			_tmp2033_ = params_it;
			if (vala_iterator_next (_tmp2033_)) {
				ValaIterator* _tmp2034_;
				gpointer _tmp2035_;
				_tmp2034_ = params_it;
				_tmp2035_ = vala_iterator_get (_tmp2034_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2035_;
			}
			_tmp2036_ = arg;
			_tmp2037_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2036_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2036_) : NULL);
			unary = _tmp2037_;
			_tmp2039_ = unary;
			if (_tmp2039_ != NULL) {
				ValaUnaryExpression* _tmp2040_;
				ValaUnaryOperator _tmp2041_;
				ValaUnaryOperator _tmp2042_;
				_tmp2040_ = unary;
				_tmp2041_ = vala_unary_expression_get_operator (_tmp2040_);
				_tmp2042_ = _tmp2041_;
				_tmp2038_ = _tmp2042_ == VALA_UNARY_OPERATOR_REF;
			} else {
				_tmp2038_ = FALSE;
			}
			if (_tmp2038_) {
				gboolean _tmp2043_ = FALSE;
				gboolean _tmp2044_ = FALSE;
				gboolean _tmp2045_ = FALSE;
				gboolean _tmp2046_ = FALSE;
				ValaParameter* _tmp2047_;
				_tmp2047_ = param;
				if (_tmp2047_ != NULL) {
					ValaParameter* _tmp2048_;
					_tmp2048_ = param;
					_tmp2046_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp2048_);
				} else {
					_tmp2046_ = FALSE;
				}
				if (_tmp2046_) {
					ValaParameter* _tmp2049_;
					ValaDataType* _tmp2050_;
					ValaDataType* _tmp2051_;
					_tmp2049_ = param;
					_tmp2050_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2049_);
					_tmp2051_ = _tmp2050_;
					_tmp2045_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2051_, VALA_TYPE_ARRAY_TYPE);
				} else {
					_tmp2045_ = FALSE;
				}
				if (_tmp2045_) {
					ValaParameter* _tmp2052_;
					ValaDataType* _tmp2053_;
					ValaDataType* _tmp2054_;
					gboolean _tmp2055_;
					gboolean _tmp2056_;
					_tmp2052_ = param;
					_tmp2053_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2052_);
					_tmp2054_ = _tmp2053_;
					_tmp2055_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2054_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2056_ = _tmp2055_;
					_tmp2044_ = !_tmp2056_;
				} else {
					_tmp2044_ = FALSE;
				}
				if (_tmp2044_) {
					ValaParameter* _tmp2057_;
					ValaDataType* _tmp2058_;
					ValaDataType* _tmp2059_;
					gint _tmp2060_;
					gint _tmp2061_;
					_tmp2057_ = param;
					_tmp2058_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2057_);
					_tmp2059_ = _tmp2058_;
					_tmp2060_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp2059_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2061_ = _tmp2060_;
					_tmp2043_ = _tmp2061_ == 1;
				} else {
					_tmp2043_ = FALSE;
				}
				if (_tmp2043_) {
					ValaSymbol* array_var = NULL;
					ValaUnaryExpression* _tmp2062_;
					ValaExpression* _tmp2063_;
					ValaExpression* _tmp2064_;
					ValaSymbol* _tmp2065_;
					ValaSymbol* _tmp2066_;
					gboolean _tmp2067_ = FALSE;
					gboolean _tmp2068_ = FALSE;
					ValaSymbol* _tmp2069_;
					_tmp2062_ = unary;
					_tmp2063_ = vala_unary_expression_get_inner (_tmp2062_);
					_tmp2064_ = _tmp2063_;
					_tmp2065_ = vala_expression_get_symbol_reference (_tmp2064_);
					_tmp2066_ = _tmp2065_;
					array_var = _tmp2066_;
					_tmp2069_ = array_var;
					if (_tmp2069_ != NULL) {
						ValaSymbol* _tmp2070_;
						_tmp2070_ = array_var;
						_tmp2068_ = vala_symbol_is_internal_symbol (_tmp2070_);
					} else {
						_tmp2068_ = FALSE;
					}
					if (_tmp2068_) {
						gboolean _tmp2071_ = FALSE;
						ValaSymbol* _tmp2072_;
						_tmp2072_ = array_var;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2072_, VALA_TYPE_LOCAL_VARIABLE)) {
							_tmp2071_ = TRUE;
						} else {
							ValaSymbol* _tmp2073_;
							_tmp2073_ = array_var;
							_tmp2071_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2073_, VALA_TYPE_FIELD);
						}
						_tmp2067_ = _tmp2071_;
					} else {
						_tmp2067_ = FALSE;
					}
					if (_tmp2067_) {
						ValaCCodeFunction* _tmp2074_;
						ValaCCodeFunction* _tmp2075_;
						ValaUnaryExpression* _tmp2076_;
						ValaExpression* _tmp2077_;
						ValaExpression* _tmp2078_;
						ValaTargetValue* _tmp2079_;
						ValaTargetValue* _tmp2080_;
						ValaCCodeExpression* _tmp2081_;
						ValaCCodeExpression* _tmp2082_;
						ValaUnaryExpression* _tmp2083_;
						ValaExpression* _tmp2084_;
						ValaExpression* _tmp2085_;
						ValaTargetValue* _tmp2086_;
						ValaTargetValue* _tmp2087_;
						ValaCCodeExpression* _tmp2088_;
						ValaCCodeExpression* _tmp2089_;
						_tmp2074_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2075_ = _tmp2074_;
						_tmp2076_ = unary;
						_tmp2077_ = vala_unary_expression_get_inner (_tmp2076_);
						_tmp2078_ = _tmp2077_;
						_tmp2079_ = vala_expression_get_target_value (_tmp2078_);
						_tmp2080_ = _tmp2079_;
						_tmp2081_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp2080_);
						_tmp2082_ = _tmp2081_;
						_tmp2083_ = unary;
						_tmp2084_ = vala_unary_expression_get_inner (_tmp2083_);
						_tmp2085_ = _tmp2084_;
						_tmp2086_ = vala_expression_get_target_value (_tmp2085_);
						_tmp2087_ = _tmp2086_;
						_tmp2088_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2087_, 1);
						_tmp2089_ = _tmp2088_;
						vala_ccode_function_add_assignment (_tmp2075_, _tmp2082_, _tmp2089_);
						_vala_ccode_node_unref0 (_tmp2089_);
						_vala_ccode_node_unref0 (_tmp2082_);
					}
				}
			}
			_tmp2091_ = unary;
			if (_tmp2091_ == NULL) {
				_tmp2090_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2092_;
				ValaUnaryOperator _tmp2093_;
				ValaUnaryOperator _tmp2094_;
				_tmp2092_ = unary;
				_tmp2093_ = vala_unary_expression_get_operator (_tmp2092_);
				_tmp2094_ = _tmp2093_;
				_tmp2090_ = _tmp2094_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2090_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2095_ = unary;
			_tmp2096_ = vala_unary_expression_get_inner (_tmp2095_);
			_tmp2097_ = _tmp2096_;
			_tmp2098_ = vala_expression_get_value_type (_tmp2097_);
			_tmp2099_ = _tmp2098_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp2099_)) {
				ValaCCodeFunction* _tmp2100_;
				ValaCCodeFunction* _tmp2101_;
				ValaUnaryExpression* _tmp2102_;
				ValaExpression* _tmp2103_;
				ValaExpression* _tmp2104_;
				ValaTargetValue* _tmp2105_;
				ValaTargetValue* _tmp2106_;
				ValaCCodeExpression* _tmp2107_;
				ValaCCodeExpression* _tmp2108_;
				_tmp2100_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2101_ = _tmp2100_;
				_tmp2102_ = unary;
				_tmp2103_ = vala_unary_expression_get_inner (_tmp2102_);
				_tmp2104_ = _tmp2103_;
				_tmp2105_ = vala_expression_get_target_value (_tmp2104_);
				_tmp2106_ = _tmp2105_;
				_tmp2107_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2106_, FALSE);
				_tmp2108_ = _tmp2107_;
				vala_ccode_function_add_expression (_tmp2101_, _tmp2108_);
				_vala_ccode_node_unref0 (_tmp2108_);
			}
			_tmp2110_ = ma;
			_tmp2111_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2110_);
			_tmp2112_ = _tmp2111_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2112_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2113_;
				ValaTargetValue* _tmp2114_;
				ValaTargetValue* _tmp2115_;
				ValaDataType* _tmp2116_;
				ValaDataType* _tmp2117_;
				_tmp2113_ = unary;
				_tmp2114_ = vala_expression_get_target_value ((ValaExpression*) _tmp2113_);
				_tmp2115_ = _tmp2114_;
				_tmp2116_ = vala_target_value_get_value_type (_tmp2115_);
				_tmp2117_ = _tmp2116_;
				_tmp2109_ = _tmp2117_ == NULL;
			} else {
				_tmp2109_ = FALSE;
			}
			if (_tmp2109_) {
				ValaUnaryExpression* _tmp2118_;
				ValaTargetValue* _tmp2119_;
				ValaTargetValue* _tmp2120_;
				ValaUnaryExpression* _tmp2121_;
				ValaExpression* _tmp2122_;
				ValaExpression* _tmp2123_;
				ValaDataType* _tmp2124_;
				ValaDataType* _tmp2125_;
				ValaDataType* _tmp2126_;
				ValaDataType* _tmp2127_;
				_tmp2118_ = unary;
				_tmp2119_ = vala_expression_get_target_value ((ValaExpression*) _tmp2118_);
				_tmp2120_ = _tmp2119_;
				_tmp2121_ = unary;
				_tmp2122_ = vala_unary_expression_get_inner (_tmp2121_);
				_tmp2123_ = _tmp2122_;
				_tmp2124_ = vala_expression_get_value_type (_tmp2123_);
				_tmp2125_ = _tmp2124_;
				_tmp2126_ = vala_data_type_copy (_tmp2125_);
				_tmp2127_ = _tmp2126_;
				vala_target_value_set_value_type (_tmp2120_, _tmp2127_);
				_vala_code_node_unref0 (_tmp2127_);
			}
			_tmp2128_ = unary;
			_tmp2129_ = vala_unary_expression_get_inner (_tmp2128_);
			_tmp2130_ = _tmp2129_;
			_tmp2131_ = vala_expression_get_target_value (_tmp2130_);
			_tmp2132_ = _tmp2131_;
			_tmp2133_ = unary;
			_tmp2134_ = vala_expression_get_target_value ((ValaExpression*) _tmp2133_);
			_tmp2135_ = _tmp2134_;
			_tmp2136_ = unary;
			_tmp2137_ = vala_unary_expression_get_inner (_tmp2136_);
			_tmp2138_ = _tmp2137_;
			_tmp2139_ = vala_expression_get_value_type (_tmp2138_);
			_tmp2140_ = _tmp2139_;
			_tmp2141_ = arg;
			_tmp2142_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2135_, _tmp2140_, (ValaCodeNode*) _tmp2141_);
			_tmp2143_ = _tmp2142_;
			_tmp2144_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2145_ = _tmp2144_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2132_, _tmp2143_, _tmp2145_);
			_vala_target_value_unref0 (_tmp2143_);
			_tmp2147_ = param;
			if (_tmp2147_ != NULL) {
				ValaParameter* _tmp2148_;
				_tmp2148_ = param;
				_tmp2146_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2148_);
			} else {
				_tmp2146_ = FALSE;
			}
			if (_tmp2146_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2149_;
				ValaCCodeIdentifier* _tmp2150_;
				ValaCCodeFunctionCall* _tmp2151_;
				ValaCCodeFunctionCall* _tmp2152_;
				ValaCCodeFunctionCall* _tmp2153_;
				ValaUnaryExpression* _tmp2154_;
				ValaExpression* _tmp2155_;
				ValaExpression* _tmp2156_;
				ValaTargetValue* _tmp2157_;
				ValaTargetValue* _tmp2158_;
				ValaCCodeExpression* _tmp2159_;
				ValaCCodeExpression* _tmp2160_;
				ValaCCodeFunction* _tmp2161_;
				ValaCCodeFunction* _tmp2162_;
				ValaUnaryExpression* _tmp2163_;
				ValaExpression* _tmp2164_;
				ValaExpression* _tmp2165_;
				ValaTargetValue* _tmp2166_;
				ValaTargetValue* _tmp2167_;
				ValaCCodeExpression* _tmp2168_;
				ValaCCodeExpression* _tmp2169_;
				ValaCCodeFunctionCall* _tmp2170_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2149_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2150_ = _tmp2149_;
				_tmp2151_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2150_);
				_tmp2152_ = _tmp2151_;
				_vala_ccode_node_unref0 (_tmp2150_);
				len_call = _tmp2152_;
				_tmp2153_ = len_call;
				_tmp2154_ = unary;
				_tmp2155_ = vala_unary_expression_get_inner (_tmp2154_);
				_tmp2156_ = _tmp2155_;
				_tmp2157_ = vala_expression_get_target_value (_tmp2156_);
				_tmp2158_ = _tmp2157_;
				_tmp2159_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2158_);
				_tmp2160_ = _tmp2159_;
				vala_ccode_function_call_add_argument (_tmp2153_, _tmp2160_);
				_vala_ccode_node_unref0 (_tmp2160_);
				_tmp2161_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2162_ = _tmp2161_;
				_tmp2163_ = unary;
				_tmp2164_ = vala_unary_expression_get_inner (_tmp2163_);
				_tmp2165_ = _tmp2164_;
				_tmp2166_ = vala_expression_get_target_value (_tmp2165_);
				_tmp2167_ = _tmp2166_;
				_tmp2168_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2167_, 1);
				_tmp2169_ = _tmp2168_;
				_tmp2170_ = len_call;
				vala_ccode_function_add_assignment (_tmp2162_, _tmp2169_, (ValaCCodeExpression*) _tmp2170_);
				_vala_ccode_node_unref0 (_tmp2169_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2173_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2173_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2174_;
		ValaSymbol* _tmp2175_;
		ValaSymbol* _tmp2176_;
		_tmp2174_ = m;
		_tmp2175_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2174_);
		_tmp2176_ = _tmp2175_;
		_tmp2172_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2176_, VALA_TYPE_CLASS);
	} else {
		_tmp2172_ = FALSE;
	}
	if (_tmp2172_) {
		gboolean _tmp2177_ = FALSE;
		gboolean _tmp2178_ = FALSE;
		ValaClass* _tmp2179_;
		ValaClass* _tmp2180_;
		gboolean _tmp2181_;
		gboolean _tmp2182_;
		_tmp2179_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2180_ = _tmp2179_;
		_tmp2181_ = vala_class_get_is_compact (_tmp2180_);
		_tmp2182_ = _tmp2181_;
		if (_tmp2182_) {
			ValaClass* _tmp2183_;
			ValaClass* _tmp2184_;
			ValaClass* _tmp2185_;
			ValaClass* _tmp2186_;
			_tmp2183_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2184_ = _tmp2183_;
			_tmp2185_ = vala_class_get_base_class (_tmp2184_);
			_tmp2186_ = _tmp2185_;
			_tmp2178_ = _tmp2186_ != NULL;
		} else {
			_tmp2178_ = FALSE;
		}
		if (_tmp2178_) {
			_tmp2177_ = TRUE;
		} else {
			ValaClass* _tmp2187_;
			ValaClass* _tmp2188_;
			ValaClass* _tmp2189_;
			ValaClass* _tmp2190_;
			ValaClass* _tmp2191_;
			_tmp2187_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2188_ = _tmp2187_;
			_tmp2189_ = vala_class_get_base_class (_tmp2188_);
			_tmp2190_ = _tmp2189_;
			_tmp2191_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2177_ = _tmp2190_ == _tmp2191_;
		}
		_tmp2171_ = _tmp2177_;
	} else {
		_tmp2171_ = FALSE;
	}
	if (_tmp2171_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2192_;
		ValaClass* _tmp2193_;
		gchar* _tmp2194_;
		gchar* _tmp2195_;
		gchar* _tmp2196_;
		gchar* _tmp2197_;
		ValaCCodeIdentifier* _tmp2198_;
		ValaCCodeIdentifier* _tmp2199_;
		ValaCCodeFunctionCall* _tmp2200_;
		ValaCCodeFunctionCall* _tmp2201_;
		ValaCCodeFunctionCall* _tmp2202_;
		ValaCCodeExpression* _tmp2203_;
		ValaCCodeExpression* _tmp2204_;
		ValaCCodeFunction* _tmp2205_;
		ValaCCodeFunction* _tmp2206_;
		ValaCCodeFunctionCall* _tmp2207_;
		_tmp2192_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2193_ = _tmp2192_;
		_tmp2194_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2193_, NULL);
		_tmp2195_ = _tmp2194_;
		_tmp2196_ = g_strdup_printf ("%s_instance_init", _tmp2195_);
		_tmp2197_ = _tmp2196_;
		_tmp2198_ = vala_ccode_identifier_new (_tmp2197_);
		_tmp2199_ = _tmp2198_;
		_tmp2200_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2199_);
		_tmp2201_ = _tmp2200_;
		_vala_ccode_node_unref0 (_tmp2199_);
		_g_free0 (_tmp2197_);
		_g_free0 (_tmp2195_);
		cinitcall = _tmp2201_;
		_tmp2202_ = cinitcall;
		_tmp2203_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2204_ = _tmp2203_;
		vala_ccode_function_call_add_argument (_tmp2202_, _tmp2204_);
		_vala_ccode_node_unref0 (_tmp2204_);
		_tmp2205_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2206_ = _tmp2205_;
		_tmp2207_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2206_, (ValaCCodeExpression*) _tmp2207_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}


static gchar*
vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                               ValaEnum* en)
{
	gchar* result = NULL;
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeFile* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	ValaCCodeFile* _tmp55_;
	ValaCCodeFunction* _tmp56_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp26_;
			gint _tmp27_;
			gpointer _tmp28_;
			ValaCCodeFunction* _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaEnumValue* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeFunction* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaEnumValue* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			ValaCCodeConstant* _tmp45_;
			ValaCCodeConstant* _tmp46_;
			_enum_value_index = _enum_value_index + 1;
			_tmp24_ = _enum_value_index;
			_tmp25_ = _enum_value_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _enum_value_list;
			_tmp27_ = _enum_value_index;
			_tmp28_ = vala_list_get (_tmp26_, _tmp27_);
			enum_value = (ValaEnumValue*) _tmp28_;
			_tmp29_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp30_ = _tmp29_;
			_tmp31_ = enum_value;
			_tmp32_ = vala_get_ccode_name ((ValaCodeNode*) _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_ccode_identifier_new (_tmp33_);
			_tmp35_ = _tmp34_;
			vala_ccode_function_add_case (_tmp30_, (ValaCCodeExpression*) _tmp35_);
			_vala_ccode_node_unref0 (_tmp35_);
			_g_free0 (_tmp33_);
			_tmp36_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = enum_value;
			_tmp39_ = vala_get_ccode_name ((ValaCodeNode*) _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat ("\"", _tmp40_, NULL);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat (_tmp42_, "\"", NULL);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_ccode_constant_new (_tmp44_);
			_tmp46_ = _tmp45_;
			vala_ccode_function_add_return (_tmp37_, (ValaCCodeExpression*) _tmp46_);
			_vala_ccode_node_unref0 (_tmp46_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp47_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp48_ = _tmp47_;
	vala_ccode_function_close (_tmp48_);
	_tmp49_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_ccode_constant_new ("NULL");
	_tmp52_ = _tmp51_;
	vala_ccode_function_add_return (_tmp50_, (ValaCCodeExpression*) _tmp52_);
	_vala_ccode_node_unref0 (_tmp52_);
	_tmp53_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp54_ = function;
	vala_ccode_file_add_function_declaration (_tmp53_, _tmp54_);
	_tmp55_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp56_ = function;
	vala_ccode_file_add_function (_tmp55_, _tmp56_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}


static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gint _tmp7_;
			gpointer _tmp8_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp9_;
			gboolean _tmp10_ = FALSE;
			ValaUnaryExpression* _tmp11_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = _arg_index;
			_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp9_) : NULL;
			_tmp11_ = unary;
			if (_tmp11_ != NULL) {
				gboolean _tmp12_ = FALSE;
				ValaUnaryExpression* _tmp13_;
				ValaUnaryOperator _tmp14_;
				ValaUnaryOperator _tmp15_;
				_tmp13_ = unary;
				_tmp14_ = vala_unary_expression_get_operator (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp12_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp16_;
					ValaUnaryOperator _tmp17_;
					ValaUnaryOperator _tmp18_;
					_tmp16_ = unary;
					_tmp17_ = vala_unary_expression_get_operator (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp10_ = _tmp12_;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}


static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}


static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self)
{
}


GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



