/* valaccodeblock.c generated by valac, the Vala compiler
 * generated from valaccodeblock.vala, do not modify */

/* valaccodeblock.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valaccode.h"
#include <valagee.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))

struct _ValaCCodeBlockPrivate {
	gboolean _suppress_newline;
	ValaList* statements;
};


static gpointer vala_ccode_block_parent_class = NULL;

#define VALA_CCODE_BLOCK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_BLOCK, ValaCCodeBlockPrivate))
static void vala_ccode_block_real_write (ValaCCodeNode* base,
                                  ValaCCodeWriter* writer);
static void vala_ccode_block_finalize (ValaCCodeNode * obj);


/**
 * Prepend the specified statement to the list of statements.
 */
void
vala_ccode_block_prepend_statement (ValaCCodeBlock* self,
                                    ValaCCodeNode* statement)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (statement != NULL);
	_tmp0_ = self->priv->statements;
	vala_list_insert (_tmp0_, 0, statement);
}


/**
 * Append the specified statement to the list of statements.
 */
void
vala_ccode_block_add_statement (ValaCCodeBlock* self,
                                ValaCCodeNode* statement)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (statement != NULL);
	_tmp0_ = self->priv->statements;
	vala_collection_add ((ValaCollection*) _tmp0_, statement);
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static void
vala_ccode_block_real_write (ValaCCodeNode* base,
                             ValaCCodeWriter* writer)
{
	ValaCCodeBlock * self;
	ValaCCodeNode* last_statement = NULL;
	gboolean _tmp36_;
	self = (ValaCCodeBlock*) base;
	g_return_if_fail (writer != NULL);
	last_statement = NULL;
	vala_ccode_writer_write_begin_block (writer);
	{
		ValaList* _statement_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _statement_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _statement_index = 0;
		_tmp0_ = self->priv->statements;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_statement_list = _tmp1_;
		_tmp2_ = _statement_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_statement_size = _tmp4_;
		_statement_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaCCodeNode* statement = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaCCodeNode* _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaCCodeNode* _tmp12_;
			_statement_index = _statement_index + 1;
			_tmp5_ = _statement_index;
			_tmp6_ = _statement_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _statement_list;
			_tmp8_ = _statement_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			statement = (ValaCCodeNode*) _tmp9_;
			_tmp10_ = statement;
			vala_ccode_node_write_declaration (_tmp10_, writer);
			_tmp12_ = statement;
			if (VALA_IS_CCODE_LABEL (_tmp12_)) {
				_tmp11_ = TRUE;
			} else {
				ValaCCodeNode* _tmp13_;
				_tmp13_ = statement;
				_tmp11_ = VALA_IS_CCODE_CASE_STATEMENT (_tmp13_);
			}
			if (_tmp11_) {
				_vala_ccode_node_unref0 (last_statement);
				last_statement = NULL;
			} else {
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_ = FALSE;
				ValaCCodeNode* _tmp17_;
				_tmp17_ = statement;
				if (VALA_IS_CCODE_RETURN_STATEMENT (_tmp17_)) {
					_tmp16_ = TRUE;
				} else {
					ValaCCodeNode* _tmp18_;
					_tmp18_ = statement;
					_tmp16_ = VALA_IS_CCODE_GOTO_STATEMENT (_tmp18_);
				}
				if (_tmp16_) {
					_tmp15_ = TRUE;
				} else {
					ValaCCodeNode* _tmp19_;
					_tmp19_ = statement;
					_tmp15_ = VALA_IS_CCODE_CONTINUE_STATEMENT (_tmp19_);
				}
				if (_tmp15_) {
					_tmp14_ = TRUE;
				} else {
					ValaCCodeNode* _tmp20_;
					_tmp20_ = statement;
					_tmp14_ = VALA_IS_CCODE_BREAK_STATEMENT (_tmp20_);
				}
				if (_tmp14_) {
					ValaCCodeNode* _tmp21_;
					ValaCCodeNode* _tmp22_;
					_tmp21_ = statement;
					_tmp22_ = _vala_ccode_node_ref0 (_tmp21_);
					_vala_ccode_node_unref0 (last_statement);
					last_statement = _tmp22_;
				}
			}
			_vala_ccode_node_unref0 (statement);
		}
		_vala_iterable_unref0 (_statement_list);
	}
	{
		ValaList* _statement_list = NULL;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _statement_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _statement_index = 0;
		_tmp23_ = self->priv->statements;
		_tmp24_ = _vala_iterable_ref0 (_tmp23_);
		_statement_list = _tmp24_;
		_tmp25_ = _statement_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_statement_size = _tmp27_;
		_statement_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			ValaCCodeNode* statement = NULL;
			ValaList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			ValaCCodeNode* _tmp33_;
			ValaCCodeNode* _tmp34_;
			ValaCCodeNode* _tmp35_;
			_statement_index = _statement_index + 1;
			_tmp28_ = _statement_index;
			_tmp29_ = _statement_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _statement_list;
			_tmp31_ = _statement_index;
			_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
			statement = (ValaCCodeNode*) _tmp32_;
			_tmp33_ = statement;
			vala_ccode_node_write (_tmp33_, writer);
			_tmp34_ = statement;
			_tmp35_ = last_statement;
			if (_tmp34_ == _tmp35_) {
				_vala_ccode_node_unref0 (statement);
				break;
			}
			_vala_ccode_node_unref0 (statement);
		}
		_vala_iterable_unref0 (_statement_list);
	}
	vala_ccode_writer_write_end_block (writer);
	_tmp36_ = self->priv->_suppress_newline;
	if (!_tmp36_) {
		vala_ccode_writer_write_newline (writer);
	}
	_vala_ccode_node_unref0 (last_statement);
}


ValaCCodeBlock*
vala_ccode_block_construct (GType object_type)
{
	ValaCCodeBlock* self = NULL;
	self = (ValaCCodeBlock*) vala_ccode_statement_construct (object_type);
	return self;
}


ValaCCodeBlock*
vala_ccode_block_new (void)
{
	return vala_ccode_block_construct (VALA_TYPE_CCODE_BLOCK);
}


gboolean
vala_ccode_block_get_suppress_newline (ValaCCodeBlock* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_suppress_newline;
	result = _tmp0_;
	return result;
}


void
vala_ccode_block_set_suppress_newline (ValaCCodeBlock* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_suppress_newline = value;
}


static void
vala_ccode_block_class_init (ValaCCodeBlockClass * klass)
{
	vala_ccode_block_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeNodeClass *) klass)->finalize = vala_ccode_block_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeBlockPrivate));
	((ValaCCodeNodeClass *) klass)->write = (void (*) (ValaCCodeNode*, ValaCCodeWriter*)) vala_ccode_block_real_write;
}


static void
vala_ccode_block_instance_init (ValaCCodeBlock * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_CCODE_BLOCK_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_CCODE_NODE, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp0_);
	self->priv->statements = (ValaList*) _tmp1_;
}


static void
vala_ccode_block_finalize (ValaCCodeNode * obj)
{
	ValaCCodeBlock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_BLOCK, ValaCCodeBlock);
	_vala_iterable_unref0 (self->priv->statements);
	VALA_CCODE_NODE_CLASS (vala_ccode_block_parent_class)->finalize (obj);
}


/**
 * Represents a C code block.
 */
GType
vala_ccode_block_get_type (void)
{
	static volatile gsize vala_ccode_block_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_block_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeBlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_block_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeBlock), 0, (GInstanceInitFunc) vala_ccode_block_instance_init, NULL };
		GType vala_ccode_block_type_id;
		vala_ccode_block_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeBlock", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_block_type_id__volatile, vala_ccode_block_type_id);
	}
	return vala_ccode_block_type_id__volatile;
}



