/* valatrystatement.c generated by valac, the Vala compiler
 * generated from valatrystatement.vala, do not modify */

/* valatrystatement.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaTryStatementPrivate {
	gboolean _after_try_block_reachable;
	ValaBlock* _body;
	ValaBlock* _finally_body;
	ValaList* catch_clauses;
};


static gpointer vala_try_statement_parent_class = NULL;
static ValaStatementIface * vala_try_statement_vala_statement_parent_iface = NULL;

#define VALA_TRY_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TRY_STATEMENT, ValaTryStatementPrivate))
static void vala_try_statement_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_try_statement_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gboolean vala_try_statement_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static void vala_try_statement_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_try_statement_finalize (ValaCodeNode * obj);


/**
 * Creates a new try statement.
 *
 * @param body             body of the try statement
 * @param finally_body     body of the optional finally clause
 * @param source_reference reference to source code
 * @return                 newly created try statement
 */
ValaTryStatement*
vala_try_statement_construct (GType object_type,
                              ValaBlock* body,
                              ValaBlock* finally_body,
                              ValaSourceReference* source_reference)
{
	ValaTryStatement* self = NULL;
	g_return_val_if_fail (body != NULL, NULL);
	self = (ValaTryStatement*) vala_code_node_construct (object_type);
	vala_try_statement_set_body (self, body);
	vala_try_statement_set_finally_body (self, finally_body);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaTryStatement*
vala_try_statement_new (ValaBlock* body,
                        ValaBlock* finally_body,
                        ValaSourceReference* source_reference)
{
	return vala_try_statement_construct (VALA_TYPE_TRY_STATEMENT, body, finally_body, source_reference);
}


/**
 * Appends the specified clause to the list of catch clauses.
 *
 * @param clause a catch clause
 */
void
vala_try_statement_add_catch_clause (ValaTryStatement* self,
                                     ValaCatchClause* clause)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clause != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) clause, (ValaCodeNode*) self);
	_tmp0_ = self->priv->catch_clauses;
	vala_collection_add ((ValaCollection*) _tmp0_, clause);
}


/**
 * Returns a copy of the list of catch clauses.
 *
 * @return list of catch clauses
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_try_statement_get_catch_clauses (ValaTryStatement* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->catch_clauses;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_try_statement_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaTryStatement * self;
	self = (ValaTryStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_try_statement (visitor, self);
}


static void
vala_try_statement_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaTryStatement * self;
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp13_;
	ValaBlock* _tmp14_;
	self = (ValaTryStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_try_statement_get_body (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _clause_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _clause_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _clause_index = 0;
		_tmp2_ = self->priv->catch_clauses;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_clause_list = _tmp3_;
		_tmp4_ = _clause_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_clause_size = _tmp6_;
		_clause_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaCatchClause* clause = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			ValaCatchClause* _tmp12_;
			_clause_index = _clause_index + 1;
			_tmp7_ = _clause_index;
			_tmp8_ = _clause_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _clause_list;
			_tmp10_ = _clause_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			clause = (ValaCatchClause*) _tmp11_;
			_tmp12_ = clause;
			vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
			_vala_code_node_unref0 (clause);
		}
		_vala_iterable_unref0 (_clause_list);
	}
	_tmp13_ = vala_try_statement_get_finally_body (self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		ValaBlock* _tmp15_;
		ValaBlock* _tmp16_;
		_tmp15_ = vala_try_statement_get_finally_body (self);
		_tmp16_ = _tmp15_;
		vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
	}
}


static gboolean
vala_try_statement_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaTryStatement * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaBlock* _tmp4_;
	ValaBlock* _tmp5_;
	ValaArrayList* error_types = NULL;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	ValaArrayList* handled_error_types = NULL;
	GEqualFunc _tmp21_;
	ValaArrayList* _tmp22_;
	ValaBlock* _tmp81_;
	ValaBlock* _tmp82_;
	ValaArrayList* _tmp98_;
	gboolean _tmp99_;
	gboolean _tmp100_;
	self = (ValaTryStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_try_statement_get_body (self);
	_tmp5_ = _tmp4_;
	vala_code_node_check ((ValaCodeNode*) _tmp5_, context);
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp6_);
	error_types = _tmp7_;
	{
		ValaList* _body_error_type_list = NULL;
		ValaBlock* _tmp8_;
		ValaBlock* _tmp9_;
		ValaList* _tmp10_;
		gint _body_error_type_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _body_error_type_index = 0;
		_tmp8_ = vala_try_statement_get_body (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp9_);
		_body_error_type_list = _tmp10_;
		_tmp11_ = _body_error_type_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_body_error_type_size = _tmp13_;
		_body_error_type_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			ValaDataType* body_error_type = NULL;
			ValaList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_;
			ValaArrayList* _tmp19_;
			ValaDataType* _tmp20_;
			_body_error_type_index = _body_error_type_index + 1;
			_tmp14_ = _body_error_type_index;
			_tmp15_ = _body_error_type_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _body_error_type_list;
			_tmp17_ = _body_error_type_index;
			_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
			body_error_type = (ValaDataType*) _tmp18_;
			_tmp19_ = error_types;
			_tmp20_ = body_error_type;
			vala_collection_add ((ValaCollection*) _tmp19_, _tmp20_);
			_vala_code_node_unref0 (body_error_type);
		}
		_vala_iterable_unref0 (_body_error_type_list);
	}
	_tmp21_ = g_direct_equal;
	_tmp22_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp21_);
	handled_error_types = _tmp22_;
	{
		ValaList* _clause_list = NULL;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _clause_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _clause_index = 0;
		_tmp23_ = self->priv->catch_clauses;
		_tmp24_ = _vala_iterable_ref0 (_tmp23_);
		_clause_list = _tmp24_;
		_tmp25_ = _clause_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_clause_size = _tmp27_;
		_clause_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			ValaCatchClause* clause = NULL;
			ValaList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			ValaArrayList* _tmp65_;
			ValaCatchClause* _tmp66_;
			_clause_index = _clause_index + 1;
			_tmp28_ = _clause_index;
			_tmp29_ = _clause_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _clause_list;
			_tmp31_ = _clause_index;
			_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
			clause = (ValaCatchClause*) _tmp32_;
			{
				ValaArrayList* _body_error_type_list = NULL;
				ValaArrayList* _tmp33_;
				ValaArrayList* _tmp34_;
				gint _body_error_type_size = 0;
				ValaArrayList* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				gint _body_error_type_index = 0;
				_tmp33_ = error_types;
				_tmp34_ = _vala_iterable_ref0 (_tmp33_);
				_body_error_type_list = _tmp34_;
				_tmp35_ = _body_error_type_list;
				_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
				_tmp37_ = _tmp36_;
				_body_error_type_size = _tmp37_;
				_body_error_type_index = -1;
				while (TRUE) {
					gint _tmp38_;
					gint _tmp39_;
					ValaDataType* body_error_type = NULL;
					ValaArrayList* _tmp40_;
					gint _tmp41_;
					gpointer _tmp42_;
					gboolean _tmp43_ = FALSE;
					ValaCatchClause* _tmp44_;
					ValaDataType* _tmp45_;
					ValaDataType* _tmp46_;
					_body_error_type_index = _body_error_type_index + 1;
					_tmp38_ = _body_error_type_index;
					_tmp39_ = _body_error_type_size;
					if (!(_tmp38_ < _tmp39_)) {
						break;
					}
					_tmp40_ = _body_error_type_list;
					_tmp41_ = _body_error_type_index;
					_tmp42_ = vala_list_get ((ValaList*) _tmp40_, _tmp41_);
					body_error_type = (ValaDataType*) _tmp42_;
					_tmp44_ = clause;
					_tmp45_ = vala_catch_clause_get_error_type (_tmp44_);
					_tmp46_ = _tmp45_;
					if (_tmp46_ == NULL) {
						_tmp43_ = TRUE;
					} else {
						ValaDataType* _tmp47_;
						ValaCatchClause* _tmp48_;
						ValaDataType* _tmp49_;
						ValaDataType* _tmp50_;
						_tmp47_ = body_error_type;
						_tmp48_ = clause;
						_tmp49_ = vala_catch_clause_get_error_type (_tmp48_);
						_tmp50_ = _tmp49_;
						_tmp43_ = vala_data_type_compatible (_tmp47_, _tmp50_);
					}
					if (_tmp43_) {
						ValaArrayList* _tmp51_;
						ValaDataType* _tmp52_;
						_tmp51_ = handled_error_types;
						_tmp52_ = body_error_type;
						vala_collection_add ((ValaCollection*) _tmp51_, _tmp52_);
					}
					_vala_code_node_unref0 (body_error_type);
				}
				_vala_iterable_unref0 (_body_error_type_list);
			}
			{
				ValaArrayList* _handled_error_type_list = NULL;
				ValaArrayList* _tmp53_;
				ValaArrayList* _tmp54_;
				gint _handled_error_type_size = 0;
				ValaArrayList* _tmp55_;
				gint _tmp56_;
				gint _tmp57_;
				gint _handled_error_type_index = 0;
				_tmp53_ = handled_error_types;
				_tmp54_ = _vala_iterable_ref0 (_tmp53_);
				_handled_error_type_list = _tmp54_;
				_tmp55_ = _handled_error_type_list;
				_tmp56_ = vala_collection_get_size ((ValaCollection*) _tmp55_);
				_tmp57_ = _tmp56_;
				_handled_error_type_size = _tmp57_;
				_handled_error_type_index = -1;
				while (TRUE) {
					gint _tmp58_;
					gint _tmp59_;
					ValaDataType* handled_error_type = NULL;
					ValaArrayList* _tmp60_;
					gint _tmp61_;
					gpointer _tmp62_;
					ValaArrayList* _tmp63_;
					ValaDataType* _tmp64_;
					_handled_error_type_index = _handled_error_type_index + 1;
					_tmp58_ = _handled_error_type_index;
					_tmp59_ = _handled_error_type_size;
					if (!(_tmp58_ < _tmp59_)) {
						break;
					}
					_tmp60_ = _handled_error_type_list;
					_tmp61_ = _handled_error_type_index;
					_tmp62_ = vala_list_get ((ValaList*) _tmp60_, _tmp61_);
					handled_error_type = (ValaDataType*) _tmp62_;
					_tmp63_ = error_types;
					_tmp64_ = handled_error_type;
					vala_collection_remove ((ValaCollection*) _tmp63_, _tmp64_);
					_vala_code_node_unref0 (handled_error_type);
				}
				_vala_iterable_unref0 (_handled_error_type_list);
			}
			_tmp65_ = handled_error_types;
			vala_collection_clear ((ValaCollection*) _tmp65_);
			_tmp66_ = clause;
			vala_code_node_check ((ValaCodeNode*) _tmp66_, context);
			{
				ValaList* _body_error_type_list = NULL;
				ValaCatchClause* _tmp67_;
				ValaBlock* _tmp68_;
				ValaBlock* _tmp69_;
				ValaList* _tmp70_;
				gint _body_error_type_size = 0;
				ValaList* _tmp71_;
				gint _tmp72_;
				gint _tmp73_;
				gint _body_error_type_index = 0;
				_tmp67_ = clause;
				_tmp68_ = vala_catch_clause_get_body (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp69_);
				_body_error_type_list = _tmp70_;
				_tmp71_ = _body_error_type_list;
				_tmp72_ = vala_collection_get_size ((ValaCollection*) _tmp71_);
				_tmp73_ = _tmp72_;
				_body_error_type_size = _tmp73_;
				_body_error_type_index = -1;
				while (TRUE) {
					gint _tmp74_;
					gint _tmp75_;
					ValaDataType* body_error_type = NULL;
					ValaList* _tmp76_;
					gint _tmp77_;
					gpointer _tmp78_;
					ValaArrayList* _tmp79_;
					ValaDataType* _tmp80_;
					_body_error_type_index = _body_error_type_index + 1;
					_tmp74_ = _body_error_type_index;
					_tmp75_ = _body_error_type_size;
					if (!(_tmp74_ < _tmp75_)) {
						break;
					}
					_tmp76_ = _body_error_type_list;
					_tmp77_ = _body_error_type_index;
					_tmp78_ = vala_list_get (_tmp76_, _tmp77_);
					body_error_type = (ValaDataType*) _tmp78_;
					_tmp79_ = error_types;
					_tmp80_ = body_error_type;
					vala_collection_add ((ValaCollection*) _tmp79_, _tmp80_);
					_vala_code_node_unref0 (body_error_type);
				}
				_vala_iterable_unref0 (_body_error_type_list);
			}
			_vala_code_node_unref0 (clause);
		}
		_vala_iterable_unref0 (_clause_list);
	}
	_tmp81_ = vala_try_statement_get_finally_body (self);
	_tmp82_ = _tmp81_;
	if (_tmp82_ != NULL) {
		ValaBlock* _tmp83_;
		ValaBlock* _tmp84_;
		_tmp83_ = vala_try_statement_get_finally_body (self);
		_tmp84_ = _tmp83_;
		vala_code_node_check ((ValaCodeNode*) _tmp84_, context);
		{
			ValaList* _body_error_type_list = NULL;
			ValaBlock* _tmp85_;
			ValaBlock* _tmp86_;
			ValaList* _tmp87_;
			gint _body_error_type_size = 0;
			ValaList* _tmp88_;
			gint _tmp89_;
			gint _tmp90_;
			gint _body_error_type_index = 0;
			_tmp85_ = vala_try_statement_get_finally_body (self);
			_tmp86_ = _tmp85_;
			_tmp87_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp86_);
			_body_error_type_list = _tmp87_;
			_tmp88_ = _body_error_type_list;
			_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
			_tmp90_ = _tmp89_;
			_body_error_type_size = _tmp90_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp91_;
				gint _tmp92_;
				ValaDataType* body_error_type = NULL;
				ValaList* _tmp93_;
				gint _tmp94_;
				gpointer _tmp95_;
				ValaArrayList* _tmp96_;
				ValaDataType* _tmp97_;
				_body_error_type_index = _body_error_type_index + 1;
				_tmp91_ = _body_error_type_index;
				_tmp92_ = _body_error_type_size;
				if (!(_tmp91_ < _tmp92_)) {
					break;
				}
				_tmp93_ = _body_error_type_list;
				_tmp94_ = _body_error_type_index;
				_tmp95_ = vala_list_get (_tmp93_, _tmp94_);
				body_error_type = (ValaDataType*) _tmp95_;
				_tmp96_ = error_types;
				_tmp97_ = body_error_type;
				vala_collection_add ((ValaCollection*) _tmp96_, _tmp97_);
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
	}
	_tmp98_ = error_types;
	vala_code_node_add_error_types ((ValaCodeNode*) self, (ValaList*) _tmp98_);
	_tmp99_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp100_ = _tmp99_;
	result = !_tmp100_;
	_vala_iterable_unref0 (handled_error_types);
	_vala_iterable_unref0 (error_types);
	return result;
}


static void
vala_try_statement_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaTryStatement * self;
	self = (ValaTryStatement*) base;
	g_return_if_fail (codegen != NULL);
	vala_code_visitor_visit_try_statement ((ValaCodeVisitor*) codegen, self);
}


ValaBlock*
vala_try_statement_get_body (ValaTryStatement* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


void
vala_try_statement_set_body (ValaTryStatement* self,
                             ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp0_;
	_tmp1_ = self->priv->_body;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaBlock*
vala_try_statement_get_finally_body (ValaTryStatement* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_finally_body;
	result = _tmp0_;
	return result;
}


void
vala_try_statement_set_finally_body (ValaTryStatement* self,
                                     ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_finally_body);
	self->priv->_finally_body = _tmp0_;
	_tmp1_ = self->priv->_finally_body;
	if (_tmp1_ != NULL) {
		ValaBlock* _tmp2_;
		_tmp2_ = self->priv->_finally_body;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


gboolean
vala_try_statement_get_after_try_block_reachable (ValaTryStatement* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_after_try_block_reachable;
	result = _tmp0_;
	return result;
}


void
vala_try_statement_set_after_try_block_reachable (ValaTryStatement* self,
                                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_after_try_block_reachable = value;
}


static void
vala_try_statement_class_init (ValaTryStatementClass * klass)
{
	vala_try_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_try_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaTryStatementPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_try_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_try_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_try_statement_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_try_statement_real_emit;
}


static void
vala_try_statement_vala_statement_interface_init (ValaStatementIface * iface)
{
	vala_try_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void
vala_try_statement_instance_init (ValaTryStatement * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_TRY_STATEMENT_GET_PRIVATE (self);
	self->priv->_after_try_block_reachable = TRUE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_CATCH_CLAUSE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->catch_clauses = (ValaList*) _tmp1_;
}


static void
vala_try_statement_finalize (ValaCodeNode * obj)
{
	ValaTryStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_TRY_STATEMENT, ValaTryStatement);
	_vala_code_node_unref0 (self->priv->_body);
	_vala_code_node_unref0 (self->priv->_finally_body);
	_vala_iterable_unref0 (self->priv->catch_clauses);
	VALA_CODE_NODE_CLASS (vala_try_statement_parent_class)->finalize (obj);
}


/**
 * Represents a try statement in the source code.
 */
GType
vala_try_statement_get_type (void)
{
	static volatile gsize vala_try_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_try_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTryStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_try_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTryStatement), 0, (GInstanceInitFunc) vala_try_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_try_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_try_statement_type_id;
		vala_try_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaTryStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_try_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		g_once_init_leave (&vala_try_statement_type_id__volatile, vala_try_statement_type_id);
	}
	return vala_try_statement_type_id__volatile;
}



