/* valasignal.c generated by valac, the Vala compiler
 * generated from valasignal.vala, do not modify */

/* valasignal.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaSignalPrivate {
	gboolean _is_virtual;
	ValaList* parameters;
	ValaMethod* _default_handler;
	ValaMethod* _emitter;
	gboolean lock_used;
	ValaDataType* _return_type;
	ValaBlock* _body;
};


static gpointer vala_signal_parent_class = NULL;
static ValaLockableIface * vala_signal_vala_lockable_parent_iface = NULL;
static ValaCallableIface * vala_signal_vala_callable_parent_iface = NULL;

#define VALA_SIGNAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SIGNAL, ValaSignalPrivate))
static void vala_signal_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_signal_real_get_parameters (ValaCallable* base);
static void vala_signal_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_signal_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static gboolean vala_signal_real_get_lock_used (ValaLockable* base);
static void vala_signal_real_set_lock_used (ValaLockable* base,
                                     gboolean used);
static void vala_signal_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static gboolean vala_signal_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static void vala_signal_set_default_handler (ValaSignal* self,
                                      ValaMethod* value);
static void vala_signal_set_emitter (ValaSignal* self,
                              ValaMethod* value);
static void vala_signal_finalize (ValaCodeNode * obj);


/**
 * Creates a new signal.
 *
 * @param name              signal name
 * @param return_type       signal return type
 * @param source_reference  reference to source code
 * @return                  newly created signal
 */
ValaSignal*
vala_signal_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaSignal* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaSignal*) vala_symbol_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}


ValaSignal*
vala_signal_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_signal_construct (VALA_TYPE_SIGNAL, name, return_type, source_reference, comment);
}


/**
 * Appends parameter to signal handler.
 *
 * @param param a formal parameter
 */
static void
vala_signal_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaSignal * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaSignal*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static ValaList*
vala_signal_real_get_parameters (ValaCallable* base)
{
	ValaSignal * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns generated delegate to be used for signal handlers.
 *
 * @return delegate
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


ValaDelegate*
vala_signal_get_delegate (ValaSignal* self,
                          ValaDataType* sender_type,
                          ValaCodeNode* node_reference)
{
	ValaDelegate* result = NULL;
	ValaDataType* actual_return_type = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDelegate* generated_delegate = NULL;
	ValaDataType* _tmp3_;
	ValaDelegate* _tmp4_;
	ValaDelegate* _tmp5_;
	ValaDelegate* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaDataType* sender_param_type = NULL;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDelegate* _tmp12_;
	ValaDataType* _tmp13_;
	gboolean is_generic = FALSE;
	gboolean _tmp37_;
	ValaScope* _tmp87_;
	ValaScope* _tmp88_;
	ValaDelegate* _tmp89_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sender_type != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_data_type_get_actual_type (_tmp1_, sender_type, NULL, node_reference);
	actual_return_type = _tmp2_;
	_tmp3_ = actual_return_type;
	_tmp4_ = vala_delegate_new (NULL, _tmp3_, NULL, NULL);
	generated_delegate = _tmp4_;
	_tmp5_ = generated_delegate;
	vala_symbol_set_access ((ValaSymbol*) _tmp5_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp6_ = generated_delegate;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp8_ = _tmp7_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp6_, _tmp8_);
	_tmp9_ = vala_data_type_copy (sender_type);
	sender_param_type = _tmp9_;
	_tmp10_ = sender_param_type;
	vala_data_type_set_value_owned (_tmp10_, FALSE);
	_tmp11_ = sender_param_type;
	vala_data_type_set_nullable (_tmp11_, FALSE);
	_tmp12_ = generated_delegate;
	_tmp13_ = sender_param_type;
	vala_delegate_set_sender_type (_tmp12_, _tmp13_);
	is_generic = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp14_;
		ValaList* _tmp15_;
		gint _param_size = 0;
		ValaList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _param_index = 0;
		_tmp14_ = self->priv->parameters;
		_tmp15_ = _vala_iterable_ref0 (_tmp14_);
		_param_list = _tmp15_;
		_tmp16_ = _param_list;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_param_size = _tmp18_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			ValaParameter* param = NULL;
			ValaList* _tmp21_;
			gint _tmp22_;
			gpointer _tmp23_;
			ValaParameter* actual_param = NULL;
			ValaParameter* _tmp24_;
			ValaParameter* _tmp25_;
			ValaParameter* _tmp26_;
			ValaParameter* _tmp27_;
			ValaDataType* _tmp28_;
			ValaDataType* _tmp29_;
			ValaDataType* _tmp30_;
			ValaDataType* _tmp31_;
			ValaDelegate* _tmp32_;
			ValaParameter* _tmp33_;
			ValaParameter* _tmp34_;
			ValaDataType* _tmp35_;
			ValaDataType* _tmp36_;
			_param_index = _param_index + 1;
			_tmp19_ = _param_index;
			_tmp20_ = _param_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _param_list;
			_tmp22_ = _param_index;
			_tmp23_ = vala_list_get (_tmp21_, _tmp22_);
			param = (ValaParameter*) _tmp23_;
			_tmp24_ = param;
			_tmp25_ = vala_parameter_copy (_tmp24_);
			actual_param = _tmp25_;
			_tmp26_ = actual_param;
			_tmp27_ = actual_param;
			_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = vala_data_type_get_actual_type (_tmp29_, sender_type, NULL, node_reference);
			_tmp31_ = _tmp30_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp26_, _tmp31_);
			_vala_code_node_unref0 (_tmp31_);
			_tmp32_ = generated_delegate;
			_tmp33_ = actual_param;
			vala_callable_add_parameter ((ValaCallable*) _tmp32_, _tmp33_);
			_tmp34_ = actual_param;
			_tmp35_ = vala_variable_get_variable_type ((ValaVariable*) _tmp34_);
			_tmp36_ = _tmp35_;
			if (VALA_IS_GENERIC_TYPE (_tmp36_)) {
				is_generic = TRUE;
			}
			_vala_code_node_unref0 (actual_param);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp37_ = is_generic;
	if (_tmp37_) {
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp38_;
		ValaSymbol* _tmp39_;
		ValaObjectTypeSymbol* _tmp40_;
		_tmp38_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp39_ = _tmp38_;
		_tmp40_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		cl = _tmp40_;
		{
			ValaList* _type_param_list = NULL;
			ValaObjectTypeSymbol* _tmp41_;
			ValaList* _tmp42_;
			gint _type_param_size = 0;
			ValaList* _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			gint _type_param_index = 0;
			_tmp41_ = cl;
			_tmp42_ = vala_object_type_symbol_get_type_parameters (_tmp41_);
			_type_param_list = _tmp42_;
			_tmp43_ = _type_param_list;
			_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
			_tmp45_ = _tmp44_;
			_type_param_size = _tmp45_;
			_type_param_index = -1;
			while (TRUE) {
				gint _tmp46_;
				gint _tmp47_;
				ValaTypeParameter* type_param = NULL;
				ValaList* _tmp48_;
				gint _tmp49_;
				gpointer _tmp50_;
				ValaDelegate* _tmp51_;
				ValaTypeParameter* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				ValaTypeParameter* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaSourceReference* _tmp57_;
				ValaTypeParameter* _tmp58_;
				ValaTypeParameter* _tmp59_;
				_type_param_index = _type_param_index + 1;
				_tmp46_ = _type_param_index;
				_tmp47_ = _type_param_size;
				if (!(_tmp46_ < _tmp47_)) {
					break;
				}
				_tmp48_ = _type_param_list;
				_tmp49_ = _type_param_index;
				_tmp50_ = vala_list_get (_tmp48_, _tmp49_);
				type_param = (ValaTypeParameter*) _tmp50_;
				_tmp51_ = generated_delegate;
				_tmp52_ = type_param;
				_tmp53_ = vala_symbol_get_name ((ValaSymbol*) _tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = type_param;
				_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = vala_typeparameter_new (_tmp54_, _tmp57_);
				_tmp59_ = _tmp58_;
				vala_delegate_add_type_parameter (_tmp51_, _tmp59_);
				_vala_code_node_unref0 (_tmp59_);
				_vala_code_node_unref0 (type_param);
			}
			_vala_iterable_unref0 (_type_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaDelegate* _tmp60_;
			ValaList* _tmp61_;
			gint _param_size = 0;
			ValaList* _tmp62_;
			gint _tmp63_;
			gint _tmp64_;
			gint _param_index = 0;
			_tmp60_ = generated_delegate;
			_tmp61_ = vala_callable_get_parameters ((ValaCallable*) _tmp60_);
			_param_list = _tmp61_;
			_tmp62_ = _param_list;
			_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
			_tmp64_ = _tmp63_;
			_param_size = _tmp64_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp65_;
				gint _tmp66_;
				ValaParameter* param = NULL;
				ValaList* _tmp67_;
				gint _tmp68_;
				gpointer _tmp69_;
				ValaGenericType* generic_type = NULL;
				ValaParameter* _tmp70_;
				ValaDataType* _tmp71_;
				ValaDataType* _tmp72_;
				ValaGenericType* _tmp73_;
				ValaGenericType* _tmp74_;
				_param_index = _param_index + 1;
				_tmp65_ = _param_index;
				_tmp66_ = _param_size;
				if (!(_tmp65_ < _tmp66_)) {
					break;
				}
				_tmp67_ = _param_list;
				_tmp68_ = _param_index;
				_tmp69_ = vala_list_get (_tmp67_, _tmp68_);
				param = (ValaParameter*) _tmp69_;
				_tmp70_ = param;
				_tmp71_ = vala_variable_get_variable_type ((ValaVariable*) _tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp72_) ? ((ValaGenericType*) _tmp72_) : NULL);
				generic_type = _tmp73_;
				_tmp74_ = generic_type;
				if (_tmp74_ != NULL) {
					ValaGenericType* _tmp75_;
					ValaDelegate* _tmp76_;
					ValaList* _tmp77_;
					ValaList* _tmp78_;
					ValaDelegate* _tmp79_;
					ValaGenericType* _tmp80_;
					ValaTypeParameter* _tmp81_;
					ValaTypeParameter* _tmp82_;
					const gchar* _tmp83_;
					const gchar* _tmp84_;
					gpointer _tmp85_;
					ValaTypeParameter* _tmp86_;
					_tmp75_ = generic_type;
					_tmp76_ = generated_delegate;
					_tmp77_ = vala_delegate_get_type_parameters (_tmp76_);
					_tmp78_ = _tmp77_;
					_tmp79_ = generated_delegate;
					_tmp80_ = generic_type;
					_tmp81_ = vala_generic_type_get_type_parameter (_tmp80_);
					_tmp82_ = _tmp81_;
					_tmp83_ = vala_symbol_get_name ((ValaSymbol*) _tmp82_);
					_tmp84_ = _tmp83_;
					_tmp85_ = vala_list_get (_tmp78_, vala_typesymbol_get_type_parameter_index ((ValaTypeSymbol*) _tmp79_, _tmp84_));
					_tmp86_ = (ValaTypeParameter*) _tmp85_;
					vala_generic_type_set_type_parameter (_tmp75_, _tmp86_);
					_vala_code_node_unref0 (_tmp86_);
					_vala_iterable_unref0 (_tmp78_);
				}
				_vala_code_node_unref0 (generic_type);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp87_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp88_ = _tmp87_;
	_tmp89_ = generated_delegate;
	vala_scope_add (_tmp88_, NULL, (ValaSymbol*) _tmp89_);
	result = generated_delegate;
	_vala_code_node_unref0 (sender_param_type);
	_vala_code_node_unref0 (actual_return_type);
	return result;
}


static void
vala_signal_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaSignal * self;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_signal (visitor, self);
}


static void
vala_signal_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaSignal * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	gboolean _tmp13_ = FALSE;
	ValaMethod* _tmp14_;
	ValaMethod* _tmp21_;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _param_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _param_index = 0;
		_tmp2_ = self->priv->parameters;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_param_list = _tmp3_;
		_tmp4_ = _param_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_param_size = _tmp6_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaParameter* param = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			ValaParameter* _tmp12_;
			_param_index = _param_index + 1;
			_tmp7_ = _param_index;
			_tmp8_ = _param_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _param_list;
			_tmp10_ = _param_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			param = (ValaParameter*) _tmp11_;
			_tmp12_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp14_ = self->priv->_default_handler;
	if (_tmp14_ == NULL) {
		ValaBlock* _tmp15_;
		ValaBlock* _tmp16_;
		_tmp15_ = vala_signal_get_body (self);
		_tmp16_ = _tmp15_;
		_tmp13_ = _tmp16_ != NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		ValaBlock* _tmp17_;
		ValaBlock* _tmp18_;
		_tmp17_ = vala_signal_get_body (self);
		_tmp18_ = _tmp17_;
		vala_code_node_accept ((ValaCodeNode*) _tmp18_, visitor);
	} else {
		ValaMethod* _tmp19_;
		_tmp19_ = self->priv->_default_handler;
		if (_tmp19_ != NULL) {
			ValaMethod* _tmp20_;
			_tmp20_ = self->priv->_default_handler;
			vala_code_node_accept ((ValaCodeNode*) _tmp20_, visitor);
		}
	}
	_tmp21_ = self->priv->_emitter;
	if (_tmp21_ != NULL) {
		ValaMethod* _tmp22_;
		_tmp22_ = self->priv->_emitter;
		vala_code_node_accept ((ValaCodeNode*) _tmp22_, visitor);
	}
}


static gboolean
vala_signal_real_get_lock_used (ValaLockable* base)
{
	ValaSignal * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->lock_used;
	result = _tmp0_;
	return result;
}


static void
vala_signal_real_set_lock_used (ValaLockable* base,
                                gboolean used)
{
	ValaSignal * self;
	self = (ValaSignal*) base;
	self->priv->lock_used = used;
}


static void
vala_signal_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaSignal * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaSignal*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
	}
}


static gboolean
vala_signal_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaSignal * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaTypeSymbol* _tmp8_;
	ValaTypeSymbol* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaDataType* _tmp12_;
	ValaTypeSymbol* _tmp13_;
	ValaTypeSymbol* _tmp14_;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_;
	gboolean _tmp48_;
	ValaAttribute* _tmp92_;
	ValaAttribute* _tmp93_;
	gboolean _tmp94_;
	gboolean _tmp166_ = FALSE;
	gboolean _tmp167_ = FALSE;
	gboolean _tmp168_;
	gboolean _tmp169_;
	gboolean _tmp184_;
	gboolean _tmp185_;
	self = (ValaSignal*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp5_ = _tmp4_;
	vala_code_node_check ((ValaCodeNode*) _tmp5_, context);
	_tmp6_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_data_type_get_data_type (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_code_context_get_analyzer (context);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_->va_list_type;
	_tmp13_ = vala_data_type_get_data_type (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp9_ == _tmp14_) {
		ValaSourceReference* _tmp15_;
		ValaSourceReference* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp15_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_get_data_type (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strdup_printf ("`%s' not supported as return type", _tmp22_);
		_tmp24_ = _tmp23_;
		vala_report_error (_tmp16_, _tmp24_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		result = FALSE;
		return result;
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp25_;
		ValaList* _tmp26_;
		gint _param_size = 0;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _param_index = 0;
		_tmp25_ = self->priv->parameters;
		_tmp26_ = _vala_iterable_ref0 (_tmp25_);
		_param_list = _tmp26_;
		_tmp27_ = _param_list;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_param_size = _tmp29_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp30_;
			gint _tmp31_;
			ValaParameter* param = NULL;
			ValaList* _tmp32_;
			gint _tmp33_;
			gpointer _tmp34_;
			ValaParameter* _tmp35_;
			gboolean _tmp36_;
			gboolean _tmp37_;
			ValaParameter* _tmp41_;
			_param_index = _param_index + 1;
			_tmp30_ = _param_index;
			_tmp31_ = _param_size;
			if (!(_tmp30_ < _tmp31_)) {
				break;
			}
			_tmp32_ = _param_list;
			_tmp33_ = _param_index;
			_tmp34_ = vala_list_get (_tmp32_, _tmp33_);
			param = (ValaParameter*) _tmp34_;
			_tmp35_ = param;
			_tmp36_ = vala_parameter_get_ellipsis (_tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_) {
				ValaParameter* _tmp38_;
				ValaSourceReference* _tmp39_;
				ValaSourceReference* _tmp40_;
				_tmp38_ = param;
				_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp38_);
				_tmp40_ = _tmp39_;
				vala_report_error (_tmp40_, "Signals with variable argument lists are not supported");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_tmp41_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp41_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp43_ = self->priv->_is_virtual;
	if (!_tmp43_) {
		ValaBlock* _tmp44_;
		ValaBlock* _tmp45_;
		_tmp44_ = vala_signal_get_body (self);
		_tmp45_ = _tmp44_;
		_tmp42_ = _tmp45_ != NULL;
	} else {
		_tmp42_ = FALSE;
	}
	if (_tmp42_) {
		ValaSourceReference* _tmp46_;
		ValaSourceReference* _tmp47_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp47_ = _tmp46_;
		vala_report_error (_tmp47_, "Only virtual signals can have a default signal handler body");
	}
	_tmp48_ = self->priv->_is_virtual;
	if (_tmp48_) {
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		ValaDataType* _tmp51_;
		ValaDataType* _tmp52_;
		ValaSourceReference* _tmp53_;
		ValaSourceReference* _tmp54_;
		ValaMethod* _tmp55_;
		ValaMethod* _tmp56_;
		ValaMethod* _tmp57_;
		ValaScope* _tmp58_;
		ValaScope* _tmp59_;
		ValaMethod* _tmp60_;
		ValaSymbolAccessibility _tmp61_;
		ValaSymbolAccessibility _tmp62_;
		ValaMethod* _tmp63_;
		gboolean _tmp64_;
		gboolean _tmp65_;
		ValaMethod* _tmp66_;
		gboolean _tmp67_;
		gboolean _tmp68_;
		ValaMethod* _tmp69_;
		ValaMethod* _tmp70_;
		ValaMethod* _tmp71_;
		ValaBlock* _tmp72_;
		ValaBlock* _tmp73_;
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaObjectTypeSymbol* _tmp88_;
		ValaObjectTypeSymbol* _tmp89_;
		ValaMethod* _tmp90_;
		ValaMethod* _tmp91_;
		_tmp49_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp50_ = _tmp49_;
		_tmp51_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_method_new (_tmp50_, _tmp52_, _tmp54_, NULL);
		_tmp56_ = _tmp55_;
		vala_signal_set_default_handler (self, _tmp56_);
		_vala_code_node_unref0 (_tmp56_);
		_tmp57_ = self->priv->_default_handler;
		_tmp58_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp59_ = _tmp58_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp57_, _tmp59_);
		_tmp60_ = self->priv->_default_handler;
		_tmp61_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp62_ = _tmp61_;
		vala_symbol_set_access ((ValaSymbol*) _tmp60_, _tmp62_);
		_tmp63_ = self->priv->_default_handler;
		_tmp64_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp65_ = _tmp64_;
		vala_symbol_set_external ((ValaSymbol*) _tmp63_, _tmp65_);
		_tmp66_ = self->priv->_default_handler;
		_tmp67_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp68_ = _tmp67_;
		vala_symbol_set_hides ((ValaSymbol*) _tmp66_, _tmp68_);
		_tmp69_ = self->priv->_default_handler;
		vala_method_set_is_virtual (_tmp69_, TRUE);
		_tmp70_ = self->priv->_default_handler;
		vala_method_set_signal_reference (_tmp70_, self);
		_tmp71_ = self->priv->_default_handler;
		_tmp72_ = vala_signal_get_body (self);
		_tmp73_ = _tmp72_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp71_, _tmp73_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp74_;
			ValaList* _tmp75_;
			gint _param_size = 0;
			ValaList* _tmp76_;
			gint _tmp77_;
			gint _tmp78_;
			gint _param_index = 0;
			_tmp74_ = self->priv->parameters;
			_tmp75_ = _vala_iterable_ref0 (_tmp74_);
			_param_list = _tmp75_;
			_tmp76_ = _param_list;
			_tmp77_ = vala_collection_get_size ((ValaCollection*) _tmp76_);
			_tmp78_ = _tmp77_;
			_param_size = _tmp78_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp79_;
				gint _tmp80_;
				ValaParameter* param = NULL;
				ValaList* _tmp81_;
				gint _tmp82_;
				gpointer _tmp83_;
				ValaMethod* _tmp84_;
				ValaParameter* _tmp85_;
				_param_index = _param_index + 1;
				_tmp79_ = _param_index;
				_tmp80_ = _param_size;
				if (!(_tmp79_ < _tmp80_)) {
					break;
				}
				_tmp81_ = _param_list;
				_tmp82_ = _param_index;
				_tmp83_ = vala_list_get (_tmp81_, _tmp82_);
				param = (ValaParameter*) _tmp83_;
				_tmp84_ = self->priv->_default_handler;
				_tmp85_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp84_, _tmp85_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp86_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = _vala_code_node_ref0 (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp87_) ? ((ValaObjectTypeSymbol*) _tmp87_) : NULL);
		cl = _tmp88_;
		_tmp89_ = cl;
		_tmp90_ = self->priv->_default_handler;
		vala_object_type_symbol_add_hidden_method (_tmp89_, _tmp90_);
		_tmp91_ = self->priv->_default_handler;
		vala_code_node_check ((ValaCodeNode*) _tmp91_, context);
		_vala_code_node_unref0 (cl);
	}
	_tmp92_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "HasEmitter");
	_tmp93_ = _tmp92_;
	_tmp94_ = _tmp93_ != NULL;
	_vala_code_node_unref0 (_tmp93_);
	if (_tmp94_) {
		const gchar* _tmp95_;
		const gchar* _tmp96_;
		ValaDataType* _tmp97_;
		ValaDataType* _tmp98_;
		ValaSourceReference* _tmp99_;
		ValaSourceReference* _tmp100_;
		ValaMethod* _tmp101_;
		ValaMethod* _tmp102_;
		ValaMethod* _tmp103_;
		ValaScope* _tmp104_;
		ValaScope* _tmp105_;
		ValaMethod* _tmp106_;
		ValaSymbolAccessibility _tmp107_;
		ValaSymbolAccessibility _tmp108_;
		ValaBlock* body = NULL;
		ValaSourceReference* _tmp109_;
		ValaSourceReference* _tmp110_;
		ValaBlock* _tmp111_;
		ValaMethodCall* call = NULL;
		const gchar* _tmp112_;
		const gchar* _tmp113_;
		ValaSourceReference* _tmp114_;
		ValaSourceReference* _tmp115_;
		ValaMemberAccess* _tmp116_;
		ValaMemberAccess* _tmp117_;
		ValaSourceReference* _tmp118_;
		ValaSourceReference* _tmp119_;
		ValaMethodCall* _tmp120_;
		ValaMethodCall* _tmp121_;
		ValaDataType* _tmp142_;
		ValaDataType* _tmp143_;
		ValaMethod* _tmp156_;
		ValaBlock* _tmp157_;
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp158_;
		ValaSymbol* _tmp159_;
		ValaObjectTypeSymbol* _tmp160_;
		ValaObjectTypeSymbol* _tmp161_;
		ValaMethod* _tmp162_;
		gboolean _tmp163_;
		gboolean _tmp164_;
		_tmp95_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp96_ = _tmp95_;
		_tmp97_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp100_ = _tmp99_;
		_tmp101_ = vala_method_new (_tmp96_, _tmp98_, _tmp100_, NULL);
		_tmp102_ = _tmp101_;
		vala_signal_set_emitter (self, _tmp102_);
		_vala_code_node_unref0 (_tmp102_);
		_tmp103_ = self->priv->_emitter;
		_tmp104_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp105_ = _tmp104_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp103_, _tmp105_);
		_tmp106_ = self->priv->_emitter;
		_tmp107_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp108_ = _tmp107_;
		vala_symbol_set_access ((ValaSymbol*) _tmp106_, _tmp108_);
		_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp110_ = _tmp109_;
		_tmp111_ = vala_block_new (_tmp110_);
		body = _tmp111_;
		_tmp112_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp113_ = _tmp112_;
		_tmp114_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp115_ = _tmp114_;
		_tmp116_ = vala_member_access_new_simple (_tmp113_, _tmp115_);
		_tmp117_ = _tmp116_;
		_tmp118_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp119_ = _tmp118_;
		_tmp120_ = vala_method_call_new ((ValaExpression*) _tmp117_, _tmp119_);
		_tmp121_ = _tmp120_;
		_vala_code_node_unref0 (_tmp117_);
		call = _tmp121_;
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp122_;
			ValaList* _tmp123_;
			gint _param_size = 0;
			ValaList* _tmp124_;
			gint _tmp125_;
			gint _tmp126_;
			gint _param_index = 0;
			_tmp122_ = self->priv->parameters;
			_tmp123_ = _vala_iterable_ref0 (_tmp122_);
			_param_list = _tmp123_;
			_tmp124_ = _param_list;
			_tmp125_ = vala_collection_get_size ((ValaCollection*) _tmp124_);
			_tmp126_ = _tmp125_;
			_param_size = _tmp126_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp127_;
				gint _tmp128_;
				ValaParameter* param = NULL;
				ValaList* _tmp129_;
				gint _tmp130_;
				gpointer _tmp131_;
				ValaMethod* _tmp132_;
				ValaParameter* _tmp133_;
				ValaMethodCall* _tmp134_;
				ValaParameter* _tmp135_;
				const gchar* _tmp136_;
				const gchar* _tmp137_;
				ValaSourceReference* _tmp138_;
				ValaSourceReference* _tmp139_;
				ValaMemberAccess* _tmp140_;
				ValaMemberAccess* _tmp141_;
				_param_index = _param_index + 1;
				_tmp127_ = _param_index;
				_tmp128_ = _param_size;
				if (!(_tmp127_ < _tmp128_)) {
					break;
				}
				_tmp129_ = _param_list;
				_tmp130_ = _param_index;
				_tmp131_ = vala_list_get (_tmp129_, _tmp130_);
				param = (ValaParameter*) _tmp131_;
				_tmp132_ = self->priv->_emitter;
				_tmp133_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp132_, _tmp133_);
				_tmp134_ = call;
				_tmp135_ = param;
				_tmp136_ = vala_symbol_get_name ((ValaSymbol*) _tmp135_);
				_tmp137_ = _tmp136_;
				_tmp138_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp139_ = _tmp138_;
				_tmp140_ = vala_member_access_new_simple (_tmp137_, _tmp139_);
				_tmp141_ = _tmp140_;
				vala_method_call_add_argument (_tmp134_, (ValaExpression*) _tmp141_);
				_vala_code_node_unref0 (_tmp141_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp142_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp143_ = _tmp142_;
		if (VALA_IS_VOID_TYPE (_tmp143_)) {
			ValaBlock* _tmp144_;
			ValaMethodCall* _tmp145_;
			ValaSourceReference* _tmp146_;
			ValaSourceReference* _tmp147_;
			ValaExpressionStatement* _tmp148_;
			ValaExpressionStatement* _tmp149_;
			_tmp144_ = body;
			_tmp145_ = call;
			_tmp146_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp147_ = _tmp146_;
			_tmp148_ = vala_expression_statement_new ((ValaExpression*) _tmp145_, _tmp147_);
			_tmp149_ = _tmp148_;
			vala_block_add_statement (_tmp144_, (ValaStatement*) _tmp149_);
			_vala_code_node_unref0 (_tmp149_);
		} else {
			ValaBlock* _tmp150_;
			ValaMethodCall* _tmp151_;
			ValaSourceReference* _tmp152_;
			ValaSourceReference* _tmp153_;
			ValaReturnStatement* _tmp154_;
			ValaReturnStatement* _tmp155_;
			_tmp150_ = body;
			_tmp151_ = call;
			_tmp152_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp153_ = _tmp152_;
			_tmp154_ = vala_return_statement_new ((ValaExpression*) _tmp151_, _tmp153_);
			_tmp155_ = _tmp154_;
			vala_block_add_statement (_tmp150_, (ValaStatement*) _tmp155_);
			_vala_code_node_unref0 (_tmp155_);
		}
		_tmp156_ = self->priv->_emitter;
		_tmp157_ = body;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp156_, _tmp157_);
		_tmp158_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp159_ = _tmp158_;
		_tmp160_ = _vala_code_node_ref0 (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp159_) ? ((ValaObjectTypeSymbol*) _tmp159_) : NULL);
		cl = _tmp160_;
		_tmp161_ = cl;
		_tmp162_ = self->priv->_emitter;
		vala_object_type_symbol_add_hidden_method (_tmp161_, _tmp162_);
		_tmp163_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp164_ = _tmp163_;
		if (!_tmp164_) {
			ValaMethod* _tmp165_;
			_tmp165_ = self->priv->_emitter;
			vala_code_node_check ((ValaCodeNode*) _tmp165_, context);
		}
		_vala_code_node_unref0 (cl);
		_vala_code_node_unref0 (call);
		_vala_code_node_unref0 (body);
	}
	_tmp168_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp169_ = _tmp168_;
	if (!_tmp169_) {
		gboolean _tmp170_;
		gboolean _tmp171_;
		_tmp170_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp171_ = _tmp170_;
		_tmp167_ = !_tmp171_;
	} else {
		_tmp167_ = FALSE;
	}
	if (_tmp167_) {
		ValaSymbol* _tmp172_;
		ValaSymbol* _tmp173_;
		_tmp172_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp173_ = _tmp172_;
		_tmp166_ = _tmp173_ != NULL;
		_vala_code_node_unref0 (_tmp173_);
	} else {
		_tmp166_ = FALSE;
	}
	if (_tmp166_) {
		ValaSourceReference* _tmp174_;
		ValaSourceReference* _tmp175_;
		gchar* _tmp176_;
		gchar* _tmp177_;
		ValaSymbol* _tmp178_;
		ValaSymbol* _tmp179_;
		gchar* _tmp180_;
		gchar* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		_tmp174_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp175_ = _tmp174_;
		_tmp176_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp177_ = _tmp176_;
		_tmp178_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_symbol_get_full_name (_tmp179_);
		_tmp181_ = _tmp180_;
		_tmp182_ = g_strdup_printf ("%s hides inherited signal `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp177_, _tmp181_);
		_tmp183_ = _tmp182_;
		vala_report_warning (_tmp175_, _tmp183_);
		_g_free0 (_tmp183_);
		_g_free0 (_tmp181_);
		_vala_code_node_unref0 (_tmp179_);
		_g_free0 (_tmp177_);
	}
	_tmp184_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp185_ = _tmp184_;
	result = !_tmp185_;
	return result;
}


static ValaDataType*
vala_signal_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaSignal* self;
	ValaDataType* _tmp0_;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}


static void
vala_signal_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaSignal* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaSignal*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaBlock*
vala_signal_get_body (ValaSignal* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}


void
vala_signal_set_body (ValaSignal* self,
                      ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp0_;
	_tmp1_ = self->priv->_body;
	if (_tmp1_ != NULL) {
		ValaBlock* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_body;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


gboolean
vala_signal_get_is_virtual (ValaSignal* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_virtual;
	result = _tmp0_;
	return result;
}


void
vala_signal_set_is_virtual (ValaSignal* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}


ValaMethod*
vala_signal_get_default_handler (ValaSignal* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_handler;
	result = _tmp0_;
	return result;
}


static void
vala_signal_set_default_handler (ValaSignal* self,
                                 ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_handler);
	self->priv->_default_handler = _tmp0_;
}


ValaMethod*
vala_signal_get_emitter (ValaSignal* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_emitter;
	result = _tmp0_;
	return result;
}


static void
vala_signal_set_emitter (ValaSignal* self,
                         ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_emitter);
	self->priv->_emitter = _tmp0_;
}


static void
vala_signal_class_init (ValaSignalClass * klass)
{
	vala_signal_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_signal_finalize;
	g_type_class_add_private (klass, sizeof (ValaSignalPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_signal_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_signal_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_signal_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_signal_real_check;
}


static void
vala_signal_vala_lockable_interface_init (ValaLockableIface * iface)
{
	vala_signal_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = (gboolean (*) (ValaLockable*)) vala_signal_real_get_lock_used;
	iface->set_lock_used = (void (*) (ValaLockable*, gboolean)) vala_signal_real_set_lock_used;
}


static void
vala_signal_vala_callable_interface_init (ValaCallableIface * iface)
{
	vala_signal_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_signal_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_signal_real_get_parameters;
	iface->get_return_type = vala_signal_real_get_return_type;
	iface->set_return_type = vala_signal_real_set_return_type;
}


static void
vala_signal_instance_init (ValaSignal * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_SIGNAL_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
	self->priv->lock_used = FALSE;
}


static void
vala_signal_finalize (ValaCodeNode * obj)
{
	ValaSignal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SIGNAL, ValaSignal);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_code_node_unref0 (self->priv->_default_handler);
	_vala_code_node_unref0 (self->priv->_emitter);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_signal_parent_class)->finalize (obj);
}


/**
 * Represents an object signal. Signals enable objects to provide notifications.
 */
GType
vala_signal_get_type (void)
{
	static volatile gsize vala_signal_type_id__volatile = 0;
	if (g_once_init_enter (&vala_signal_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSignalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_signal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSignal), 0, (GInstanceInitFunc) vala_signal_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_signal_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_signal_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_signal_type_id;
		vala_signal_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaSignal", &g_define_type_info, 0);
		g_type_add_interface_static (vala_signal_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_type_add_interface_static (vala_signal_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
		g_once_init_leave (&vala_signal_type_id__volatile, vala_signal_type_id);
	}
	return vala_signal_type_id__volatile;
}



