/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};


static gpointer vala_assignment_parent_class = NULL;

#define VALA_ASSIGNMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ASSIGNMENT, ValaAssignmentPrivate))
static void vala_assignment_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor);
static const gchar* vala_assignment_get_operator_string (ValaAssignment* self);
static gchar* vala_assignment_real_to_string (ValaCodeNode* base);
static void vala_assignment_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base,
                                             ValaSymbol* sym);
static gboolean vala_assignment_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static void vala_assignment_check_constant_assignment (ValaAssignment* self,
                                                ValaMemberAccess* inner);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                              ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);


/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment*
vala_assignment_construct (GType object_type,
                           ValaExpression* left,
                           ValaExpression* right,
                           ValaAssignmentOperator operator,
                           ValaSourceReference* source_reference)
{
	ValaAssignment* self = NULL;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	vala_assignment_set_right (self, right);
	vala_assignment_set_operator (self, operator);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_assignment_set_left (self, left);
	return self;
}


ValaAssignment*
vala_assignment_new (ValaExpression* left,
                     ValaExpression* right,
                     ValaAssignmentOperator operator,
                     ValaSourceReference* source_reference)
{
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}


static void
vala_assignment_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_assignment (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_assignment_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}


static const gchar*
vala_assignment_get_operator_string (ValaAssignment* self)
{
	const gchar* result = NULL;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_operator;
	switch (_tmp0_) {
		case VALA_ASSIGNMENT_OPERATOR_SIMPLE:
		{
			result = "=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
		{
			result = "|=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
		{
			result = "&=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
		{
			result = "^=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_ADD:
		{
			result = "+=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SUB:
		{
			result = "-=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_MUL:
		{
			result = "*=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_DIV:
		{
			result = "/=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_PERCENT:
		{
			result = "%=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
		{
			result = "<<=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>=";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static gchar*
vala_assignment_real_to_string (ValaCodeNode* base)
{
	ValaAssignment * self;
	gchar* result = NULL;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaExpression* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	self = (ValaAssignment*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_assignment_get_operator_string (self);
	_tmp4_ = self->priv->_right;
	_tmp5_ = vala_code_node_to_string ((ValaCodeNode*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp3_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp2_);
	result = _tmp8_;
	return result;
}


static void
vala_assignment_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_assignment_set_left (self, new_node);
	}
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_assignment_set_right (self, new_node);
	}
}


static gboolean
vala_assignment_real_is_pure (ValaExpression* base)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_assignment_real_is_accessible (ValaExpression* base,
                                    ValaSymbol* sym)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_assignment_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_assignment_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp95_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp97_;
	ValaExpression* _tmp98_;
	ValaExpression* _tmp99_;
	ValaExpression* _tmp100_;
	ValaExpression* _tmp307_;
	ValaExpression* _tmp308_;
	gboolean _tmp309_ = FALSE;
	ValaAssignmentOperator _tmp310_;
	ValaExpression* _tmp365_;
	ValaExpression* _tmp366_;
	ValaSymbol* _tmp367_;
	ValaSymbol* _tmp368_;
	ValaExpression* _tmp858_;
	ValaExpression* _tmp859_;
	ValaDataType* _tmp860_;
	ValaDataType* _tmp861_;
	ValaExpression* _tmp870_;
	ValaExpression* _tmp871_;
	ValaList* _tmp872_;
	ValaList* _tmp873_;
	ValaExpression* _tmp874_;
	ValaExpression* _tmp875_;
	ValaList* _tmp876_;
	ValaList* _tmp877_;
	gboolean _tmp878_;
	gboolean _tmp879_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (VALA_IS_TUPLE (_tmp7_)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_EXPRESSION_STATEMENT (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaTuple* _tmp13_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaLocalVariable* _tmp23_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaDeclarationStatement* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaSemanticAnalyzer* _tmp29_;
		ValaBlock* _tmp30_;
		ValaDeclarationStatement* _tmp31_;
		ValaDeclarationStatement* _tmp32_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaSemanticAnalyzer* _tmp84_;
		ValaSemanticAnalyzer* _tmp85_;
		ValaList* _tmp86_;
		ValaCodeNode* _tmp87_;
		ValaCodeNode* _tmp88_;
		ValaExpressionStatement* _tmp89_;
		ValaExpression* _tmp90_;
		ValaExpression* _tmp91_;
		ValaExpressionStatement* _tmp92_;
		ValaExpression* _tmp93_;
		ValaExpression* _tmp94_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple));
		tuple = _tmp13_;
		_tmp14_ = vala_code_node_get_temp_name ();
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_assignment_get_right (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_assignment_get_right (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_local_variable_new (NULL, _tmp15_, _tmp17_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp15_);
		local = _tmp23_;
		_tmp24_ = local;
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_declaration_statement_new ((ValaSymbol*) _tmp24_, _tmp26_);
		decl = _tmp27_;
		_tmp28_ = vala_code_context_get_analyzer (context);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp29_->insert_block;
		_tmp31_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp30_, (ValaStatement*) _tmp31_);
		_tmp32_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp32_, context);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp33_;
			ValaList* _tmp34_;
			gint _expr_size = 0;
			ValaList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _expr_index = 0;
			_tmp33_ = tuple;
			_tmp34_ = vala_tuple_get_expressions (_tmp33_);
			_expr_list = _tmp34_;
			_tmp35_ = _expr_list;
			_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_expr_size = _tmp37_;
			_expr_index = -1;
			while (TRUE) {
				gint _tmp38_;
				gint _tmp39_;
				ValaExpression* expr = NULL;
				ValaList* _tmp40_;
				gint _tmp41_;
				gpointer _tmp42_;
				ValaExpressionStatement* _tmp43_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp49_;
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				ValaExpression* _tmp52_;
				ValaExpression* _tmp53_;
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				ValaMemberAccess* _tmp56_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp57_;
				ValaExpression* _tmp58_;
				ValaSourceReference* _tmp59_;
				ValaSourceReference* _tmp60_;
				ValaElementAccess* _tmp61_;
				ValaElementAccess* _tmp62_;
				gint _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				ValaExpression* _tmp66_;
				ValaSourceReference* _tmp67_;
				ValaSourceReference* _tmp68_;
				ValaIntegerLiteral* _tmp69_;
				ValaIntegerLiteral* _tmp70_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp71_;
				ValaElementAccess* _tmp72_;
				ValaAssignmentOperator _tmp73_;
				ValaExpression* _tmp74_;
				ValaSourceReference* _tmp75_;
				ValaSourceReference* _tmp76_;
				ValaAssignment* _tmp77_;
				ValaAssignment* _tmp78_;
				ValaExpression* _tmp79_;
				ValaSourceReference* _tmp80_;
				ValaSourceReference* _tmp81_;
				ValaExpressionStatement* _tmp82_;
				gint _tmp83_;
				_expr_index = _expr_index + 1;
				_tmp38_ = _expr_index;
				_tmp39_ = _expr_size;
				if (!(_tmp38_ < _tmp39_)) {
					break;
				}
				_tmp40_ = _expr_list;
				_tmp41_ = _expr_index;
				_tmp42_ = vala_list_get (_tmp40_, _tmp41_);
				expr = (ValaExpression*) _tmp42_;
				_tmp43_ = stmt;
				if (_tmp43_ != NULL) {
					ValaSemanticAnalyzer* _tmp44_;
					ValaSemanticAnalyzer* _tmp45_;
					ValaBlock* _tmp46_;
					ValaExpressionStatement* _tmp47_;
					ValaExpressionStatement* _tmp48_;
					_tmp44_ = vala_code_context_get_analyzer (context);
					_tmp45_ = _tmp44_;
					_tmp46_ = _tmp45_->insert_block;
					_tmp47_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp46_, (ValaStatement*) _tmp47_);
					_tmp48_ = stmt;
					vala_code_node_check ((ValaCodeNode*) _tmp48_, context);
				}
				_tmp49_ = local;
				_tmp50_ = vala_symbol_get_name ((ValaSymbol*) _tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = vala_assignment_get_right (self);
				_tmp53_ = _tmp52_;
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp53_);
				_tmp55_ = _tmp54_;
				_tmp56_ = vala_member_access_new_simple (_tmp51_, _tmp55_);
				temp_access = _tmp56_;
				_tmp57_ = temp_access;
				_tmp58_ = expr;
				_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = vala_element_access_new ((ValaExpression*) _tmp57_, _tmp60_);
				ea = _tmp61_;
				_tmp62_ = ea;
				_tmp63_ = i;
				_tmp64_ = g_strdup_printf ("%i", _tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = expr;
				_tmp67_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = vala_integer_literal_new (_tmp65_, _tmp68_);
				_tmp70_ = _tmp69_;
				vala_element_access_append_index (_tmp62_, (ValaExpression*) _tmp70_);
				_vala_code_node_unref0 (_tmp70_);
				_g_free0 (_tmp65_);
				_tmp71_ = expr;
				_tmp72_ = ea;
				_tmp73_ = self->priv->_operator;
				_tmp74_ = expr;
				_tmp75_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = vala_assignment_new (_tmp71_, (ValaExpression*) _tmp72_, _tmp73_, _tmp76_);
				assign = _tmp77_;
				_tmp78_ = assign;
				_tmp79_ = expr;
				_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = vala_expression_statement_new ((ValaExpression*) _tmp78_, _tmp81_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp82_;
				_tmp83_ = i;
				i = _tmp83_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		_tmp84_ = vala_code_context_get_analyzer (context);
		_tmp85_ = _tmp84_;
		_tmp86_ = _tmp85_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp86_, (ValaCodeNode*) self);
		_tmp87_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp88_ = _tmp87_;
		_tmp89_ = stmt;
		_tmp90_ = vala_expression_statement_get_expression (_tmp89_);
		_tmp91_ = _tmp90_;
		vala_code_node_replace_expression (_tmp88_, (ValaExpression*) self, _tmp91_);
		_tmp92_ = stmt;
		_tmp93_ = vala_expression_statement_get_expression (_tmp92_);
		_tmp94_ = _tmp93_;
		result = vala_code_node_check ((ValaCodeNode*) _tmp94_, context);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (tuple);
		return result;
	}
	_tmp95_ = vala_assignment_get_left (self);
	_tmp96_ = _tmp95_;
	vala_expression_set_lvalue (_tmp96_, TRUE);
	_tmp97_ = vala_assignment_get_left (self);
	_tmp98_ = _tmp97_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp98_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp99_ = vala_assignment_get_left (self);
	_tmp100_ = _tmp99_;
	if (VALA_IS_MEMBER_ACCESS (_tmp100_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp101_;
		ValaExpression* _tmp102_;
		ValaMemberAccess* _tmp103_;
		ValaMemberAccess* _tmp104_;
		gboolean _tmp105_ = FALSE;
		gboolean _tmp106_ = FALSE;
		gboolean _tmp107_ = FALSE;
		ValaMemberAccess* _tmp108_;
		ValaSymbol* _tmp109_;
		ValaSymbol* _tmp110_;
		ValaMemberAccess* _tmp129_;
		gboolean _tmp130_;
		gboolean _tmp131_;
		gboolean _tmp141_ = FALSE;
		ValaMemberAccess* _tmp142_;
		gboolean _tmp143_;
		gboolean _tmp144_;
		ValaMemberAccess* _tmp148_;
		ValaSymbol* _tmp149_;
		ValaSymbol* _tmp150_;
		_tmp101_ = vala_assignment_get_left (self);
		_tmp102_ = _tmp101_;
		_tmp103_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp103_;
		_tmp104_ = ma;
		vala_assignment_check_constant_assignment (self, _tmp104_);
		_tmp108_ = ma;
		_tmp109_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp108_);
		_tmp110_ = _tmp109_;
		if (VALA_IS_SIGNAL (_tmp110_)) {
			_tmp107_ = TRUE;
		} else {
			ValaMemberAccess* _tmp111_;
			ValaSymbol* _tmp112_;
			ValaSymbol* _tmp113_;
			_tmp111_ = ma;
			_tmp112_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp111_);
			_tmp113_ = _tmp112_;
			_tmp107_ = VALA_IS_DYNAMIC_PROPERTY (_tmp113_);
		}
		if (!_tmp107_) {
			ValaMemberAccess* _tmp114_;
			ValaDataType* _tmp115_;
			ValaDataType* _tmp116_;
			_tmp114_ = ma;
			_tmp115_ = vala_expression_get_value_type ((ValaExpression*) _tmp114_);
			_tmp116_ = _tmp115_;
			_tmp106_ = _tmp116_ == NULL;
		} else {
			_tmp106_ = FALSE;
		}
		if (_tmp106_) {
			_tmp105_ = TRUE;
		} else {
			gboolean _tmp117_ = FALSE;
			gboolean _tmp118_ = FALSE;
			ValaMemberAccess* _tmp119_;
			ValaExpression* _tmp120_;
			ValaExpression* _tmp121_;
			_tmp119_ = ma;
			_tmp120_ = vala_member_access_get_inner (_tmp119_);
			_tmp121_ = _tmp120_;
			if (_tmp121_ == NULL) {
				ValaMemberAccess* _tmp122_;
				const gchar* _tmp123_;
				const gchar* _tmp124_;
				_tmp122_ = ma;
				_tmp123_ = vala_member_access_get_member_name (_tmp122_);
				_tmp124_ = _tmp123_;
				_tmp118_ = g_strcmp0 (_tmp124_, "this") == 0;
			} else {
				_tmp118_ = FALSE;
			}
			if (_tmp118_) {
				ValaSemanticAnalyzer* _tmp125_;
				ValaSemanticAnalyzer* _tmp126_;
				_tmp125_ = vala_code_context_get_analyzer (context);
				_tmp126_ = _tmp125_;
				_tmp117_ = vala_semantic_analyzer_is_in_instance_method (_tmp126_);
			} else {
				_tmp117_ = FALSE;
			}
			_tmp105_ = _tmp117_;
		}
		if (_tmp105_) {
			ValaSourceReference* _tmp127_;
			ValaSourceReference* _tmp128_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp128_ = _tmp127_;
			vala_report_error (_tmp128_, "unsupported lvalue in assignment");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp129_ = ma;
		_tmp130_ = vala_member_access_get_prototype_access (_tmp129_);
		_tmp131_ = _tmp130_;
		if (_tmp131_) {
			ValaSourceReference* _tmp132_;
			ValaSourceReference* _tmp133_;
			ValaMemberAccess* _tmp134_;
			ValaSymbol* _tmp135_;
			ValaSymbol* _tmp136_;
			gchar* _tmp137_;
			gchar* _tmp138_;
			gchar* _tmp139_;
			gchar* _tmp140_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp133_ = _tmp132_;
			_tmp134_ = ma;
			_tmp135_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp134_);
			_tmp136_ = _tmp135_;
			_tmp137_ = vala_symbol_get_full_name (_tmp136_);
			_tmp138_ = _tmp137_;
			_tmp139_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp138_);
			_tmp140_ = _tmp139_;
			vala_report_error (_tmp133_, _tmp140_);
			_g_free0 (_tmp140_);
			_g_free0 (_tmp138_);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp142_ = ma;
		_tmp143_ = vala_code_node_get_error ((ValaCodeNode*) _tmp142_);
		_tmp144_ = _tmp143_;
		if (_tmp144_) {
			_tmp141_ = TRUE;
		} else {
			ValaMemberAccess* _tmp145_;
			ValaSymbol* _tmp146_;
			ValaSymbol* _tmp147_;
			_tmp145_ = ma;
			_tmp146_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp145_);
			_tmp147_ = _tmp146_;
			_tmp141_ = _tmp147_ == NULL;
		}
		if (_tmp141_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp148_ = ma;
		_tmp149_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp148_);
		_tmp150_ = _tmp149_;
		if (VALA_IS_DYNAMIC_SIGNAL (_tmp150_)) {
			gboolean _tmp151_;
			gboolean _tmp152_;
			_tmp151_ = vala_code_context_get_deprecated (context);
			_tmp152_ = _tmp151_;
			if (!_tmp152_) {
				ValaSourceReference* _tmp153_;
				ValaSourceReference* _tmp154_;
				_tmp153_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp154_ = _tmp153_;
				vala_report_warning (_tmp154_, "deprecated syntax, use `connect' method instead");
			}
		} else {
			ValaMemberAccess* _tmp155_;
			ValaSymbol* _tmp156_;
			ValaSymbol* _tmp157_;
			_tmp155_ = ma;
			_tmp156_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp155_);
			_tmp157_ = _tmp156_;
			if (VALA_IS_SIGNAL (_tmp157_)) {
				gboolean _tmp158_;
				gboolean _tmp159_;
				ValaSignal* sig = NULL;
				ValaMemberAccess* _tmp162_;
				ValaSymbol* _tmp163_;
				ValaSymbol* _tmp164_;
				ValaSignal* _tmp165_;
				ValaExpression* _tmp166_;
				ValaExpression* _tmp167_;
				ValaSignal* _tmp168_;
				ValaMemberAccess* _tmp169_;
				ValaExpression* _tmp170_;
				ValaExpression* _tmp171_;
				ValaDataType* _tmp172_;
				ValaDataType* _tmp173_;
				ValaDelegate* _tmp174_;
				ValaDelegate* _tmp175_;
				ValaDelegateType* _tmp176_;
				ValaDelegateType* _tmp177_;
				_tmp158_ = vala_code_context_get_deprecated (context);
				_tmp159_ = _tmp158_;
				if (!_tmp159_) {
					ValaSourceReference* _tmp160_;
					ValaSourceReference* _tmp161_;
					_tmp160_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp161_ = _tmp160_;
					vala_report_warning (_tmp161_, "deprecated syntax, use `connect' method instead");
				}
				_tmp162_ = ma;
				_tmp163_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp162_);
				_tmp164_ = _tmp163_;
				_tmp165_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, VALA_TYPE_SIGNAL, ValaSignal));
				sig = _tmp165_;
				_tmp166_ = vala_assignment_get_right (self);
				_tmp167_ = _tmp166_;
				_tmp168_ = sig;
				_tmp169_ = ma;
				_tmp170_ = vala_member_access_get_inner (_tmp169_);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_expression_get_value_type (_tmp171_);
				_tmp173_ = _tmp172_;
				_tmp174_ = vala_signal_get_delegate (_tmp168_, _tmp173_, (ValaCodeNode*) self);
				_tmp175_ = _tmp174_;
				_tmp176_ = vala_delegate_type_new (_tmp175_);
				_tmp177_ = _tmp176_;
				vala_expression_set_target_type (_tmp167_, (ValaDataType*) _tmp177_);
				_vala_code_node_unref0 (_tmp177_);
				_vala_code_node_unref0 (_tmp175_);
				_vala_code_node_unref0 (sig);
			} else {
				ValaMemberAccess* _tmp178_;
				ValaSymbol* _tmp179_;
				ValaSymbol* _tmp180_;
				_tmp178_ = ma;
				_tmp179_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp178_);
				_tmp180_ = _tmp179_;
				if (VALA_IS_DYNAMIC_PROPERTY (_tmp180_)) {
				} else {
					ValaExpression* _tmp181_;
					ValaExpression* _tmp182_;
					ValaMemberAccess* _tmp183_;
					ValaDataType* _tmp184_;
					ValaDataType* _tmp185_;
					ValaDataType* _tmp186_;
					ValaDataType* _tmp187_;
					ValaExpression* _tmp188_;
					ValaExpression* _tmp189_;
					ValaMemberAccess* _tmp190_;
					ValaDataType* _tmp191_;
					ValaDataType* _tmp192_;
					ValaDataType* _tmp193_;
					ValaDataType* _tmp194_;
					_tmp181_ = vala_assignment_get_right (self);
					_tmp182_ = _tmp181_;
					_tmp183_ = ma;
					_tmp184_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp183_);
					_tmp185_ = _tmp184_;
					_tmp186_ = vala_data_type_copy (_tmp185_);
					_tmp187_ = _tmp186_;
					vala_expression_set_formal_target_type (_tmp182_, _tmp187_);
					_vala_code_node_unref0 (_tmp187_);
					_tmp188_ = vala_assignment_get_right (self);
					_tmp189_ = _tmp188_;
					_tmp190_ = ma;
					_tmp191_ = vala_expression_get_value_type ((ValaExpression*) _tmp190_);
					_tmp192_ = _tmp191_;
					_tmp193_ = vala_data_type_copy (_tmp192_);
					_tmp194_ = _tmp193_;
					vala_expression_set_target_type (_tmp189_, _tmp194_);
					_vala_code_node_unref0 (_tmp194_);
				}
			}
		}
		_vala_code_node_unref0 (ma);
	} else {
		ValaExpression* _tmp195_;
		ValaExpression* _tmp196_;
		_tmp195_ = vala_assignment_get_left (self);
		_tmp196_ = _tmp195_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp196_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp197_;
			ValaExpression* _tmp198_;
			ValaElementAccess* _tmp199_;
			ValaElementAccess* _tmp200_;
			ValaExpression* _tmp201_;
			ValaExpression* _tmp202_;
			ValaElementAccess* _tmp203_;
			ValaExpression* _tmp204_;
			ValaExpression* _tmp205_;
			ValaDataType* _tmp206_;
			ValaDataType* _tmp207_;
			ValaTypeSymbol* _tmp208_;
			ValaTypeSymbol* _tmp209_;
			ValaSemanticAnalyzer* _tmp210_;
			ValaSemanticAnalyzer* _tmp211_;
			ValaDataType* _tmp212_;
			ValaTypeSymbol* _tmp213_;
			ValaTypeSymbol* _tmp214_;
			_tmp197_ = vala_assignment_get_left (self);
			_tmp198_ = _tmp197_;
			_tmp199_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp198_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
			ea = _tmp199_;
			_tmp200_ = ea;
			_tmp201_ = vala_element_access_get_container (_tmp200_);
			_tmp202_ = _tmp201_;
			vala_assignment_check_constant_assignment (self, VALA_IS_MEMBER_ACCESS (_tmp202_) ? ((ValaMemberAccess*) _tmp202_) : NULL);
			_tmp203_ = ea;
			_tmp204_ = vala_element_access_get_container (_tmp203_);
			_tmp205_ = _tmp204_;
			_tmp206_ = vala_expression_get_value_type (_tmp205_);
			_tmp207_ = _tmp206_;
			_tmp208_ = vala_data_type_get_data_type (_tmp207_);
			_tmp209_ = _tmp208_;
			_tmp210_ = vala_code_context_get_analyzer (context);
			_tmp211_ = _tmp210_;
			_tmp212_ = _tmp211_->string_type;
			_tmp213_ = vala_data_type_get_data_type (_tmp212_);
			_tmp214_ = _tmp213_;
			if (_tmp209_ == _tmp214_) {
				ValaElementAccess* _tmp215_;
				ValaSourceReference* _tmp216_;
				ValaSourceReference* _tmp217_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp215_ = ea;
				_tmp216_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp215_);
				_tmp217_ = _tmp216_;
				vala_report_error (_tmp217_, "strings are immutable");
				result = FALSE;
				_vala_code_node_unref0 (ea);
				return result;
			} else {
				gboolean _tmp218_ = FALSE;
				ValaElementAccess* _tmp219_;
				ValaExpression* _tmp220_;
				ValaExpression* _tmp221_;
				_tmp219_ = ea;
				_tmp220_ = vala_element_access_get_container (_tmp219_);
				_tmp221_ = _tmp220_;
				if (VALA_IS_MEMBER_ACCESS (_tmp221_)) {
					ValaElementAccess* _tmp222_;
					ValaExpression* _tmp223_;
					ValaExpression* _tmp224_;
					ValaSymbol* _tmp225_;
					ValaSymbol* _tmp226_;
					_tmp222_ = ea;
					_tmp223_ = vala_element_access_get_container (_tmp222_);
					_tmp224_ = _tmp223_;
					_tmp225_ = vala_expression_get_symbol_reference (_tmp224_);
					_tmp226_ = _tmp225_;
					_tmp218_ = VALA_IS_SIGNAL (_tmp226_);
				} else {
					_tmp218_ = FALSE;
				}
				if (_tmp218_) {
					ValaMemberAccess* ma = NULL;
					ValaElementAccess* _tmp227_;
					ValaExpression* _tmp228_;
					ValaExpression* _tmp229_;
					ValaMemberAccess* _tmp230_;
					ValaSignal* sig = NULL;
					ValaElementAccess* _tmp231_;
					ValaExpression* _tmp232_;
					ValaExpression* _tmp233_;
					ValaSymbol* _tmp234_;
					ValaSymbol* _tmp235_;
					ValaSignal* _tmp236_;
					ValaExpression* _tmp237_;
					ValaExpression* _tmp238_;
					ValaSignal* _tmp239_;
					ValaMemberAccess* _tmp240_;
					ValaExpression* _tmp241_;
					ValaExpression* _tmp242_;
					ValaDataType* _tmp243_;
					ValaDataType* _tmp244_;
					ValaDelegate* _tmp245_;
					ValaDelegate* _tmp246_;
					ValaDelegateType* _tmp247_;
					ValaDelegateType* _tmp248_;
					_tmp227_ = ea;
					_tmp228_ = vala_element_access_get_container (_tmp227_);
					_tmp229_ = _tmp228_;
					_tmp230_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp229_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
					ma = _tmp230_;
					_tmp231_ = ea;
					_tmp232_ = vala_element_access_get_container (_tmp231_);
					_tmp233_ = _tmp232_;
					_tmp234_ = vala_expression_get_symbol_reference (_tmp233_);
					_tmp235_ = _tmp234_;
					_tmp236_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp235_, VALA_TYPE_SIGNAL, ValaSignal));
					sig = _tmp236_;
					_tmp237_ = vala_assignment_get_right (self);
					_tmp238_ = _tmp237_;
					_tmp239_ = sig;
					_tmp240_ = ma;
					_tmp241_ = vala_member_access_get_inner (_tmp240_);
					_tmp242_ = _tmp241_;
					_tmp243_ = vala_expression_get_value_type (_tmp242_);
					_tmp244_ = _tmp243_;
					_tmp245_ = vala_signal_get_delegate (_tmp239_, _tmp244_, (ValaCodeNode*) self);
					_tmp246_ = _tmp245_;
					_tmp247_ = vala_delegate_type_new (_tmp246_);
					_tmp248_ = _tmp247_;
					vala_expression_set_target_type (_tmp238_, (ValaDataType*) _tmp248_);
					_vala_code_node_unref0 (_tmp248_);
					_vala_code_node_unref0 (_tmp246_);
					_vala_code_node_unref0 (sig);
					_vala_code_node_unref0 (ma);
				} else {
					ValaElementAccess* _tmp249_;
					ValaExpression* _tmp250_;
					ValaExpression* _tmp251_;
					ValaDataType* _tmp252_;
					ValaDataType* _tmp253_;
					ValaSymbol* _tmp254_;
					ValaSymbol* _tmp255_;
					gboolean _tmp256_;
					_tmp249_ = ea;
					_tmp250_ = vala_element_access_get_container (_tmp249_);
					_tmp251_ = _tmp250_;
					_tmp252_ = vala_expression_get_value_type (_tmp251_);
					_tmp253_ = _tmp252_;
					_tmp254_ = vala_data_type_get_member (_tmp253_, "set");
					_tmp255_ = _tmp254_;
					_tmp256_ = VALA_IS_METHOD (_tmp255_);
					_vala_code_node_unref0 (_tmp255_);
					if (_tmp256_) {
						ValaMethodCall* set_call = NULL;
						ValaElementAccess* _tmp257_;
						ValaExpression* _tmp258_;
						ValaExpression* _tmp259_;
						ValaSourceReference* _tmp260_;
						ValaSourceReference* _tmp261_;
						ValaMemberAccess* _tmp262_;
						ValaMemberAccess* _tmp263_;
						ValaSourceReference* _tmp264_;
						ValaSourceReference* _tmp265_;
						ValaMethodCall* _tmp266_;
						ValaMethodCall* _tmp267_;
						ValaMethodCall* _tmp280_;
						ValaExpression* _tmp281_;
						ValaExpression* _tmp282_;
						ValaCodeNode* _tmp283_;
						ValaCodeNode* _tmp284_;
						ValaMethodCall* _tmp285_;
						ValaMethodCall* _tmp286_;
						_tmp257_ = ea;
						_tmp258_ = vala_element_access_get_container (_tmp257_);
						_tmp259_ = _tmp258_;
						_tmp260_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp261_ = _tmp260_;
						_tmp262_ = vala_member_access_new (_tmp259_, "set", _tmp261_);
						_tmp263_ = _tmp262_;
						_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp265_ = _tmp264_;
						_tmp266_ = vala_method_call_new ((ValaExpression*) _tmp263_, _tmp265_);
						_tmp267_ = _tmp266_;
						_vala_code_node_unref0 (_tmp263_);
						set_call = _tmp267_;
						{
							ValaList* _e_list = NULL;
							ValaElementAccess* _tmp268_;
							ValaList* _tmp269_;
							gint _e_size = 0;
							ValaList* _tmp270_;
							gint _tmp271_;
							gint _tmp272_;
							gint _e_index = 0;
							_tmp268_ = ea;
							_tmp269_ = vala_element_access_get_indices (_tmp268_);
							_e_list = _tmp269_;
							_tmp270_ = _e_list;
							_tmp271_ = vala_collection_get_size ((ValaCollection*) _tmp270_);
							_tmp272_ = _tmp271_;
							_e_size = _tmp272_;
							_e_index = -1;
							while (TRUE) {
								gint _tmp273_;
								gint _tmp274_;
								ValaExpression* e = NULL;
								ValaList* _tmp275_;
								gint _tmp276_;
								gpointer _tmp277_;
								ValaMethodCall* _tmp278_;
								ValaExpression* _tmp279_;
								_e_index = _e_index + 1;
								_tmp273_ = _e_index;
								_tmp274_ = _e_size;
								if (!(_tmp273_ < _tmp274_)) {
									break;
								}
								_tmp275_ = _e_list;
								_tmp276_ = _e_index;
								_tmp277_ = vala_list_get (_tmp275_, _tmp276_);
								e = (ValaExpression*) _tmp277_;
								_tmp278_ = set_call;
								_tmp279_ = e;
								vala_method_call_add_argument (_tmp278_, _tmp279_);
								_vala_code_node_unref0 (e);
							}
							_vala_iterable_unref0 (_e_list);
						}
						_tmp280_ = set_call;
						_tmp281_ = vala_assignment_get_right (self);
						_tmp282_ = _tmp281_;
						vala_method_call_add_argument (_tmp280_, _tmp282_);
						_tmp283_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp284_ = _tmp283_;
						_tmp285_ = set_call;
						vala_code_node_replace_expression (_tmp284_, (ValaExpression*) self, (ValaExpression*) _tmp285_);
						_tmp286_ = set_call;
						result = vala_code_node_check ((ValaCodeNode*) _tmp286_, context);
						_vala_code_node_unref0 (set_call);
						_vala_code_node_unref0 (ea);
						return result;
					} else {
						ValaExpression* _tmp287_;
						ValaExpression* _tmp288_;
						ValaExpression* _tmp289_;
						ValaExpression* _tmp290_;
						ValaDataType* _tmp291_;
						ValaDataType* _tmp292_;
						ValaDataType* _tmp293_;
						ValaDataType* _tmp294_;
						_tmp287_ = vala_assignment_get_right (self);
						_tmp288_ = _tmp287_;
						_tmp289_ = vala_assignment_get_left (self);
						_tmp290_ = _tmp289_;
						_tmp291_ = vala_expression_get_value_type (_tmp290_);
						_tmp292_ = _tmp291_;
						_tmp293_ = vala_data_type_copy (_tmp292_);
						_tmp294_ = _tmp293_;
						vala_expression_set_target_type (_tmp288_, _tmp294_);
						_vala_code_node_unref0 (_tmp294_);
					}
				}
			}
			_vala_code_node_unref0 (ea);
		} else {
			ValaExpression* _tmp295_;
			ValaExpression* _tmp296_;
			_tmp295_ = vala_assignment_get_left (self);
			_tmp296_ = _tmp295_;
			if (VALA_IS_POINTER_INDIRECTION (_tmp296_)) {
				ValaExpression* _tmp297_;
				ValaExpression* _tmp298_;
				ValaExpression* _tmp299_;
				ValaExpression* _tmp300_;
				ValaDataType* _tmp301_;
				ValaDataType* _tmp302_;
				ValaDataType* _tmp303_;
				ValaDataType* _tmp304_;
				_tmp297_ = vala_assignment_get_right (self);
				_tmp298_ = _tmp297_;
				_tmp299_ = vala_assignment_get_left (self);
				_tmp300_ = _tmp299_;
				_tmp301_ = vala_expression_get_value_type (_tmp300_);
				_tmp302_ = _tmp301_;
				_tmp303_ = vala_data_type_copy (_tmp302_);
				_tmp304_ = _tmp303_;
				vala_expression_set_target_type (_tmp298_, _tmp304_);
				_vala_code_node_unref0 (_tmp304_);
			} else {
				ValaSourceReference* _tmp305_;
				ValaSourceReference* _tmp306_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp305_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp306_ = _tmp305_;
				vala_report_error (_tmp306_, "unsupported lvalue in assignment");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp307_ = vala_assignment_get_right (self);
	_tmp308_ = _tmp307_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp308_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp310_ = self->priv->_operator;
	if (_tmp310_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		ValaExpression* _tmp311_;
		ValaExpression* _tmp312_;
		_tmp311_ = vala_assignment_get_left (self);
		_tmp312_ = _tmp311_;
		_tmp309_ = VALA_IS_MEMBER_ACCESS (_tmp312_);
	} else {
		_tmp309_ = FALSE;
	}
	if (_tmp309_) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp313_;
		ValaExpression* _tmp314_;
		ValaMemberAccess* _tmp315_;
		ValaMemberAccess* _tmp316_;
		ValaSymbol* _tmp317_;
		ValaSymbol* _tmp318_;
		_tmp313_ = vala_assignment_get_left (self);
		_tmp314_ = _tmp313_;
		_tmp315_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp314_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp315_;
		_tmp316_ = ma;
		_tmp317_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp316_);
		_tmp318_ = _tmp317_;
		if (!VALA_IS_SIGNAL (_tmp318_)) {
			ValaMemberAccess* old_value = NULL;
			ValaMemberAccess* _tmp319_;
			ValaExpression* _tmp320_;
			ValaExpression* _tmp321_;
			ValaMemberAccess* _tmp322_;
			const gchar* _tmp323_;
			const gchar* _tmp324_;
			ValaMemberAccess* _tmp325_;
			ValaBinaryExpression* bin = NULL;
			ValaMemberAccess* _tmp326_;
			ValaExpression* _tmp327_;
			ValaExpression* _tmp328_;
			ValaSourceReference* _tmp329_;
			ValaSourceReference* _tmp330_;
			ValaBinaryExpression* _tmp331_;
			ValaBinaryExpression* _tmp332_;
			ValaExpression* _tmp333_;
			ValaExpression* _tmp334_;
			ValaDataType* _tmp335_;
			ValaDataType* _tmp336_;
			ValaDataType* _tmp337_;
			ValaDataType* _tmp338_;
			ValaExpression* _tmp339_;
			ValaExpression* _tmp340_;
			ValaExpression* _tmp341_;
			ValaExpression* _tmp342_;
			ValaDataType* _tmp343_;
			ValaDataType* _tmp344_;
			ValaDataType* _tmp345_;
			ValaDataType* _tmp346_;
			ValaExpression* _tmp347_;
			ValaExpression* _tmp348_;
			ValaDataType* _tmp349_;
			ValaDataType* _tmp350_;
			ValaAssignmentOperator _tmp351_;
			ValaBinaryExpression* _tmp362_;
			ValaExpression* _tmp363_;
			ValaExpression* _tmp364_;
			_tmp319_ = ma;
			_tmp320_ = vala_member_access_get_inner (_tmp319_);
			_tmp321_ = _tmp320_;
			_tmp322_ = ma;
			_tmp323_ = vala_member_access_get_member_name (_tmp322_);
			_tmp324_ = _tmp323_;
			_tmp325_ = vala_member_access_new (_tmp321_, _tmp324_, NULL);
			old_value = _tmp325_;
			_tmp326_ = old_value;
			_tmp327_ = vala_assignment_get_right (self);
			_tmp328_ = _tmp327_;
			_tmp329_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp330_ = _tmp329_;
			_tmp331_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_PLUS, (ValaExpression*) _tmp326_, _tmp328_, _tmp330_);
			bin = _tmp331_;
			_tmp332_ = bin;
			_tmp333_ = vala_assignment_get_right (self);
			_tmp334_ = _tmp333_;
			_tmp335_ = vala_expression_get_target_type (_tmp334_);
			_tmp336_ = _tmp335_;
			_tmp337_ = vala_data_type_copy (_tmp336_);
			_tmp338_ = _tmp337_;
			vala_expression_set_target_type ((ValaExpression*) _tmp332_, _tmp338_);
			_vala_code_node_unref0 (_tmp338_);
			_tmp339_ = vala_assignment_get_right (self);
			_tmp340_ = _tmp339_;
			_tmp341_ = vala_assignment_get_right (self);
			_tmp342_ = _tmp341_;
			_tmp343_ = vala_expression_get_target_type (_tmp342_);
			_tmp344_ = _tmp343_;
			_tmp345_ = vala_data_type_copy (_tmp344_);
			_tmp346_ = _tmp345_;
			vala_expression_set_target_type (_tmp340_, _tmp346_);
			_vala_code_node_unref0 (_tmp346_);
			_tmp347_ = vala_assignment_get_right (self);
			_tmp348_ = _tmp347_;
			_tmp349_ = vala_expression_get_target_type (_tmp348_);
			_tmp350_ = _tmp349_;
			vala_data_type_set_value_owned (_tmp350_, FALSE);
			_tmp351_ = self->priv->_operator;
			switch (_tmp351_) {
				case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
				{
					ValaBinaryExpression* _tmp352_;
					_tmp352_ = bin;
					vala_binary_expression_set_operator (_tmp352_, VALA_BINARY_OPERATOR_BITWISE_OR);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
				{
					ValaBinaryExpression* _tmp353_;
					_tmp353_ = bin;
					vala_binary_expression_set_operator (_tmp353_, VALA_BINARY_OPERATOR_BITWISE_AND);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
				{
					ValaBinaryExpression* _tmp354_;
					_tmp354_ = bin;
					vala_binary_expression_set_operator (_tmp354_, VALA_BINARY_OPERATOR_BITWISE_XOR);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_ADD:
				{
					ValaBinaryExpression* _tmp355_;
					_tmp355_ = bin;
					vala_binary_expression_set_operator (_tmp355_, VALA_BINARY_OPERATOR_PLUS);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_SUB:
				{
					ValaBinaryExpression* _tmp356_;
					_tmp356_ = bin;
					vala_binary_expression_set_operator (_tmp356_, VALA_BINARY_OPERATOR_MINUS);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_MUL:
				{
					ValaBinaryExpression* _tmp357_;
					_tmp357_ = bin;
					vala_binary_expression_set_operator (_tmp357_, VALA_BINARY_OPERATOR_MUL);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_DIV:
				{
					ValaBinaryExpression* _tmp358_;
					_tmp358_ = bin;
					vala_binary_expression_set_operator (_tmp358_, VALA_BINARY_OPERATOR_DIV);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_PERCENT:
				{
					ValaBinaryExpression* _tmp359_;
					_tmp359_ = bin;
					vala_binary_expression_set_operator (_tmp359_, VALA_BINARY_OPERATOR_MOD);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
				{
					ValaBinaryExpression* _tmp360_;
					_tmp360_ = bin;
					vala_binary_expression_set_operator (_tmp360_, VALA_BINARY_OPERATOR_SHIFT_LEFT);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
				{
					ValaBinaryExpression* _tmp361_;
					_tmp361_ = bin;
					vala_binary_expression_set_operator (_tmp361_, VALA_BINARY_OPERATOR_SHIFT_RIGHT);
					break;
				}
				default:
				break;
			}
			_tmp362_ = bin;
			vala_assignment_set_right (self, (ValaExpression*) _tmp362_);
			_tmp363_ = vala_assignment_get_right (self);
			_tmp364_ = _tmp363_;
			vala_code_node_check ((ValaCodeNode*) _tmp364_, context);
			vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_code_node_unref0 (bin);
			_vala_code_node_unref0 (old_value);
		}
		_vala_code_node_unref0 (ma);
	}
	_tmp365_ = vala_assignment_get_left (self);
	_tmp366_ = _tmp365_;
	_tmp367_ = vala_expression_get_symbol_reference (_tmp366_);
	_tmp368_ = _tmp367_;
	if (VALA_IS_SIGNAL (_tmp368_)) {
		ValaSignal* sig = NULL;
		ValaExpression* _tmp369_;
		ValaExpression* _tmp370_;
		ValaSymbol* _tmp371_;
		ValaSymbol* _tmp372_;
		ValaSignal* _tmp373_;
		ValaMethod* m = NULL;
		ValaExpression* _tmp374_;
		ValaExpression* _tmp375_;
		ValaSymbol* _tmp376_;
		ValaSymbol* _tmp377_;
		ValaMethod* _tmp378_;
		ValaMethod* _tmp379_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaSignal* _tmp384_;
		ValaDynamicSignal* _tmp385_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp386_;
		ValaExpression* _tmp387_;
		ValaMemberAccess* _tmp388_;
		ValaDynamicSignal* _tmp389_;
		_tmp369_ = vala_assignment_get_left (self);
		_tmp370_ = _tmp369_;
		_tmp371_ = vala_expression_get_symbol_reference (_tmp370_);
		_tmp372_ = _tmp371_;
		_tmp373_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp372_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp373_;
		_tmp374_ = vala_assignment_get_right (self);
		_tmp375_ = _tmp374_;
		_tmp376_ = vala_expression_get_symbol_reference (_tmp375_);
		_tmp377_ = _tmp376_;
		_tmp378_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp377_) ? ((ValaMethod*) _tmp377_) : NULL);
		m = _tmp378_;
		_tmp379_ = m;
		if (_tmp379_ == NULL) {
			ValaExpression* _tmp380_;
			ValaExpression* _tmp381_;
			ValaSourceReference* _tmp382_;
			ValaSourceReference* _tmp383_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp380_ = vala_assignment_get_right (self);
			_tmp381_ = _tmp380_;
			_tmp382_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp381_);
			_tmp383_ = _tmp382_;
			vala_report_error (_tmp383_, "unsupported expression for signal handler");
			result = FALSE;
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (sig);
			return result;
		}
		_tmp384_ = sig;
		_tmp385_ = _vala_code_node_ref0 (VALA_IS_DYNAMIC_SIGNAL (_tmp384_) ? ((ValaDynamicSignal*) _tmp384_) : NULL);
		dynamic_sig = _tmp385_;
		_tmp386_ = vala_assignment_get_right (self);
		_tmp387_ = _tmp386_;
		_tmp388_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp387_) ? ((ValaMemberAccess*) _tmp387_) : NULL);
		right_ma = _tmp388_;
		_tmp389_ = dynamic_sig;
		if (_tmp389_ != NULL) {
			gboolean first = FALSE;
			ValaExpression* _tmp409_;
			ValaExpression* _tmp410_;
			ValaSignal* _tmp411_;
			ValaSignal* _tmp412_;
			ValaSymbol* _tmp413_;
			ValaSymbol* _tmp414_;
			ValaObjectType* _tmp415_;
			ValaObjectType* _tmp416_;
			ValaDelegate* _tmp417_;
			ValaDelegate* _tmp418_;
			ValaDelegateType* _tmp419_;
			ValaDelegateType* _tmp420_;
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp390_;
				ValaExpression* _tmp391_;
				ValaExpression* _tmp392_;
				ValaDataType* _tmp393_;
				ValaDataType* _tmp394_;
				ValaList* _tmp395_;
				gint _param_size = 0;
				ValaList* _tmp396_;
				gint _tmp397_;
				gint _tmp398_;
				gint _param_index = 0;
				_tmp390_ = dynamic_sig;
				_tmp391_ = vala_dynamic_signal_get_handler (_tmp390_);
				_tmp392_ = _tmp391_;
				_tmp393_ = vala_expression_get_value_type (_tmp392_);
				_tmp394_ = _tmp393_;
				_tmp395_ = vala_data_type_get_parameters (_tmp394_);
				_param_list = _tmp395_;
				_tmp396_ = _param_list;
				_tmp397_ = vala_collection_get_size ((ValaCollection*) _tmp396_);
				_tmp398_ = _tmp397_;
				_param_size = _tmp398_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp399_;
					gint _tmp400_;
					ValaParameter* param = NULL;
					ValaList* _tmp401_;
					gint _tmp402_;
					gpointer _tmp403_;
					gboolean _tmp404_;
					_param_index = _param_index + 1;
					_tmp399_ = _param_index;
					_tmp400_ = _param_size;
					if (!(_tmp399_ < _tmp400_)) {
						break;
					}
					_tmp401_ = _param_list;
					_tmp402_ = _param_index;
					_tmp403_ = vala_list_get (_tmp401_, _tmp402_);
					param = (ValaParameter*) _tmp403_;
					_tmp404_ = first;
					if (_tmp404_) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp405_;
						ValaParameter* _tmp406_;
						ValaParameter* _tmp407_;
						ValaParameter* _tmp408_;
						_tmp405_ = dynamic_sig;
						_tmp406_ = param;
						_tmp407_ = vala_parameter_copy (_tmp406_);
						_tmp408_ = _tmp407_;
						vala_callable_add_parameter ((ValaCallable*) _tmp405_, _tmp408_);
						_vala_code_node_unref0 (_tmp408_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp409_ = vala_assignment_get_right (self);
			_tmp410_ = _tmp409_;
			_tmp411_ = sig;
			_tmp412_ = sig;
			_tmp413_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp412_);
			_tmp414_ = _tmp413_;
			_tmp415_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp414_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp416_ = _tmp415_;
			_tmp417_ = vala_signal_get_delegate (_tmp411_, (ValaDataType*) _tmp416_, (ValaCodeNode*) self);
			_tmp418_ = _tmp417_;
			_tmp419_ = vala_delegate_type_new (_tmp418_);
			_tmp420_ = _tmp419_;
			vala_expression_set_target_type (_tmp410_, (ValaDataType*) _tmp420_);
			_vala_code_node_unref0 (_tmp420_);
			_vala_code_node_unref0 (_tmp418_);
			_vala_code_node_unref0 (_tmp416_);
		} else {
			ValaExpression* _tmp421_;
			ValaExpression* _tmp422_;
			ValaDataType* _tmp423_;
			ValaDataType* _tmp424_;
			ValaExpression* _tmp425_;
			ValaExpression* _tmp426_;
			ValaDataType* _tmp427_;
			ValaDataType* _tmp428_;
			_tmp421_ = vala_assignment_get_right (self);
			_tmp422_ = _tmp421_;
			_tmp423_ = vala_expression_get_value_type (_tmp422_);
			_tmp424_ = _tmp423_;
			_tmp425_ = vala_assignment_get_right (self);
			_tmp426_ = _tmp425_;
			_tmp427_ = vala_expression_get_target_type (_tmp426_);
			_tmp428_ = _tmp427_;
			if (!vala_data_type_compatible (_tmp424_, _tmp428_)) {
				ValaDelegateType* delegate_type = NULL;
				ValaExpression* _tmp429_;
				ValaExpression* _tmp430_;
				ValaDataType* _tmp431_;
				ValaDataType* _tmp432_;
				ValaDelegateType* _tmp433_;
				ValaExpression* _tmp434_;
				ValaExpression* _tmp435_;
				ValaSourceReference* _tmp436_;
				ValaSourceReference* _tmp437_;
				ValaExpression* _tmp438_;
				ValaExpression* _tmp439_;
				ValaDataType* _tmp440_;
				ValaDataType* _tmp441_;
				gchar* _tmp442_;
				gchar* _tmp443_;
				ValaExpression* _tmp444_;
				ValaExpression* _tmp445_;
				ValaDataType* _tmp446_;
				ValaDataType* _tmp447_;
				gchar* _tmp448_;
				gchar* _tmp449_;
				ValaDelegateType* _tmp450_;
				ValaMethod* _tmp451_;
				const gchar* _tmp452_;
				const gchar* _tmp453_;
				gchar* _tmp454_;
				gchar* _tmp455_;
				gchar* _tmp456_;
				gchar* _tmp457_;
				_tmp429_ = vala_assignment_get_right (self);
				_tmp430_ = _tmp429_;
				_tmp431_ = vala_expression_get_target_type (_tmp430_);
				_tmp432_ = _tmp431_;
				_tmp433_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp432_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				delegate_type = _tmp433_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp434_ = vala_assignment_get_right (self);
				_tmp435_ = _tmp434_;
				_tmp436_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp435_);
				_tmp437_ = _tmp436_;
				_tmp438_ = vala_assignment_get_right (self);
				_tmp439_ = _tmp438_;
				_tmp440_ = vala_expression_get_value_type (_tmp439_);
				_tmp441_ = _tmp440_;
				_tmp442_ = vala_code_node_to_string ((ValaCodeNode*) _tmp441_);
				_tmp443_ = _tmp442_;
				_tmp444_ = vala_assignment_get_right (self);
				_tmp445_ = _tmp444_;
				_tmp446_ = vala_expression_get_target_type (_tmp445_);
				_tmp447_ = _tmp446_;
				_tmp448_ = vala_code_node_to_string ((ValaCodeNode*) _tmp447_);
				_tmp449_ = _tmp448_;
				_tmp450_ = delegate_type;
				_tmp451_ = m;
				_tmp452_ = vala_symbol_get_name ((ValaSymbol*) _tmp451_);
				_tmp453_ = _tmp452_;
				_tmp454_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp450_, _tmp453_);
				_tmp455_ = _tmp454_;
				_tmp456_ = g_strdup_printf ("method `%s' is incompatible with signal `%s', expected `%s'", _tmp443_, _tmp449_, _tmp455_);
				_tmp457_ = _tmp456_;
				vala_report_error (_tmp437_, _tmp457_);
				_g_free0 (_tmp457_);
				_g_free0 (_tmp455_);
				_g_free0 (_tmp449_);
				_g_free0 (_tmp443_);
				result = FALSE;
				_vala_code_node_unref0 (delegate_type);
				_vala_code_node_unref0 (right_ma);
				_vala_code_node_unref0 (dynamic_sig);
				_vala_code_node_unref0 (m);
				_vala_code_node_unref0 (sig);
				return result;
			} else {
				gboolean _tmp458_ = FALSE;
				ValaMemberAccess* _tmp459_;
				_tmp459_ = right_ma;
				if (_tmp459_ != NULL) {
					ValaMemberAccess* _tmp460_;
					gboolean _tmp461_;
					gboolean _tmp462_;
					_tmp460_ = right_ma;
					_tmp461_ = vala_member_access_get_prototype_access (_tmp460_);
					_tmp462_ = _tmp461_;
					_tmp458_ = _tmp462_;
				} else {
					_tmp458_ = FALSE;
				}
				if (_tmp458_) {
					ValaExpression* _tmp463_;
					ValaExpression* _tmp464_;
					ValaSourceReference* _tmp465_;
					ValaSourceReference* _tmp466_;
					ValaMethod* _tmp467_;
					gchar* _tmp468_;
					gchar* _tmp469_;
					gchar* _tmp470_;
					gchar* _tmp471_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp463_ = vala_assignment_get_right (self);
					_tmp464_ = _tmp463_;
					_tmp465_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp464_);
					_tmp466_ = _tmp465_;
					_tmp467_ = m;
					_tmp468_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp467_);
					_tmp469_ = _tmp468_;
					_tmp470_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp469_);
					_tmp471_ = _tmp470_;
					vala_report_error (_tmp466_, _tmp471_);
					_g_free0 (_tmp471_);
					_g_free0 (_tmp469_);
					result = FALSE;
					_vala_code_node_unref0 (right_ma);
					_vala_code_node_unref0 (dynamic_sig);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (sig);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (right_ma);
		_vala_code_node_unref0 (dynamic_sig);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (sig);
	} else {
		ValaExpression* _tmp472_;
		ValaExpression* _tmp473_;
		_tmp472_ = vala_assignment_get_left (self);
		_tmp473_ = _tmp472_;
		if (VALA_IS_MEMBER_ACCESS (_tmp473_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp474_;
			ValaExpression* _tmp475_;
			ValaMemberAccess* _tmp476_;
			ValaMemberAccess* _tmp477_;
			ValaSymbol* _tmp478_;
			ValaSymbol* _tmp479_;
			gboolean _tmp666_ = FALSE;
			ValaExpression* _tmp667_;
			ValaExpression* _tmp668_;
			ValaDataType* _tmp669_;
			ValaDataType* _tmp670_;
			ValaMemberAccess* right_ma = NULL;
			ValaExpression* _tmp725_;
			ValaExpression* _tmp726_;
			ValaMemberAccess* _tmp727_;
			gboolean _tmp728_ = FALSE;
			ValaMemberAccess* _tmp729_;
			_tmp474_ = vala_assignment_get_left (self);
			_tmp475_ = _tmp474_;
			_tmp476_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp475_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp476_;
			_tmp477_ = ma;
			_tmp478_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp477_);
			_tmp479_ = _tmp478_;
			if (VALA_IS_PROPERTY (_tmp479_)) {
				ValaProperty* prop = NULL;
				ValaMemberAccess* _tmp480_;
				ValaSymbol* _tmp481_;
				ValaSymbol* _tmp482_;
				ValaProperty* _tmp483_;
				ValaDynamicProperty* dynamic_prop = NULL;
				ValaProperty* _tmp484_;
				ValaDynamicProperty* _tmp485_;
				ValaDynamicProperty* _tmp486_;
				gboolean _tmp501_ = FALSE;
				ValaProperty* _tmp502_;
				ValaPropertyAccessor* _tmp503_;
				ValaPropertyAccessor* _tmp504_;
				_tmp480_ = ma;
				_tmp481_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp480_);
				_tmp482_ = _tmp481_;
				_tmp483_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp482_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp483_;
				_tmp484_ = prop;
				_tmp485_ = _vala_code_node_ref0 (VALA_IS_DYNAMIC_PROPERTY (_tmp484_) ? ((ValaDynamicProperty*) _tmp484_) : NULL);
				dynamic_prop = _tmp485_;
				_tmp486_ = dynamic_prop;
				if (_tmp486_ != NULL) {
					ValaDynamicProperty* _tmp487_;
					ValaExpression* _tmp488_;
					ValaExpression* _tmp489_;
					ValaDataType* _tmp490_;
					ValaDataType* _tmp491_;
					ValaDataType* _tmp492_;
					ValaDataType* _tmp493_;
					ValaExpression* _tmp494_;
					ValaExpression* _tmp495_;
					ValaDynamicProperty* _tmp496_;
					ValaDataType* _tmp497_;
					ValaDataType* _tmp498_;
					ValaDataType* _tmp499_;
					ValaDataType* _tmp500_;
					_tmp487_ = dynamic_prop;
					_tmp488_ = vala_assignment_get_right (self);
					_tmp489_ = _tmp488_;
					_tmp490_ = vala_expression_get_value_type (_tmp489_);
					_tmp491_ = _tmp490_;
					_tmp492_ = vala_data_type_copy (_tmp491_);
					_tmp493_ = _tmp492_;
					vala_property_set_property_type ((ValaProperty*) _tmp487_, _tmp493_);
					_vala_code_node_unref0 (_tmp493_);
					_tmp494_ = vala_assignment_get_left (self);
					_tmp495_ = _tmp494_;
					_tmp496_ = dynamic_prop;
					_tmp497_ = vala_property_get_property_type ((ValaProperty*) _tmp496_);
					_tmp498_ = _tmp497_;
					_tmp499_ = vala_data_type_copy (_tmp498_);
					_tmp500_ = _tmp499_;
					vala_expression_set_value_type (_tmp495_, _tmp500_);
					_vala_code_node_unref0 (_tmp500_);
				}
				_tmp502_ = prop;
				_tmp503_ = vala_property_get_set_accessor (_tmp502_);
				_tmp504_ = _tmp503_;
				if (_tmp504_ == NULL) {
					_tmp501_ = TRUE;
				} else {
					gboolean _tmp505_ = FALSE;
					ValaProperty* _tmp506_;
					ValaPropertyAccessor* _tmp507_;
					ValaPropertyAccessor* _tmp508_;
					gboolean _tmp509_;
					gboolean _tmp510_;
					_tmp506_ = prop;
					_tmp507_ = vala_property_get_set_accessor (_tmp506_);
					_tmp508_ = _tmp507_;
					_tmp509_ = vala_property_accessor_get_writable (_tmp508_);
					_tmp510_ = _tmp509_;
					if (!_tmp510_) {
						gboolean _tmp511_ = FALSE;
						ValaSemanticAnalyzer* _tmp512_;
						ValaSemanticAnalyzer* _tmp513_;
						ValaMethod* _tmp514_;
						ValaMethod* _tmp515_;
						gboolean _tmp516_;
						_tmp512_ = vala_code_context_get_analyzer (context);
						_tmp513_ = _tmp512_;
						_tmp514_ = vala_semantic_analyzer_find_current_method (_tmp513_);
						_tmp515_ = _tmp514_;
						_tmp516_ = VALA_IS_CREATION_METHOD (_tmp515_);
						_vala_code_node_unref0 (_tmp515_);
						if (_tmp516_) {
							_tmp511_ = TRUE;
						} else {
							ValaSemanticAnalyzer* _tmp517_;
							ValaSemanticAnalyzer* _tmp518_;
							_tmp517_ = vala_code_context_get_analyzer (context);
							_tmp518_ = _tmp517_;
							_tmp511_ = vala_semantic_analyzer_is_in_constructor (_tmp518_);
						}
						_tmp505_ = !_tmp511_;
					} else {
						_tmp505_ = FALSE;
					}
					_tmp501_ = _tmp505_;
				}
				if (_tmp501_) {
					ValaMemberAccess* _tmp519_;
					ValaMemberAccess* _tmp520_;
					ValaSourceReference* _tmp521_;
					ValaSourceReference* _tmp522_;
					ValaProperty* _tmp523_;
					gchar* _tmp524_;
					gchar* _tmp525_;
					gchar* _tmp526_;
					gchar* _tmp527_;
					_tmp519_ = ma;
					vala_code_node_set_error ((ValaCodeNode*) _tmp519_, TRUE);
					_tmp520_ = ma;
					_tmp521_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp520_);
					_tmp522_ = _tmp521_;
					_tmp523_ = prop;
					_tmp524_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp523_);
					_tmp525_ = _tmp524_;
					_tmp526_ = g_strdup_printf ("Property `%s' is read-only", _tmp525_);
					_tmp527_ = _tmp526_;
					vala_report_error (_tmp522_, _tmp527_);
					_g_free0 (_tmp527_);
					_g_free0 (_tmp525_);
					result = FALSE;
					_vala_code_node_unref0 (dynamic_prop);
					_vala_code_node_unref0 (prop);
					_vala_code_node_unref0 (ma);
					return result;
				} else {
					gboolean _tmp528_ = FALSE;
					gboolean _tmp529_ = FALSE;
					gboolean _tmp530_;
					gboolean _tmp531_;
					_tmp530_ = vala_code_context_get_deprecated (context);
					_tmp531_ = _tmp530_;
					if (!_tmp531_) {
						ValaProperty* _tmp532_;
						ValaPropertyAccessor* _tmp533_;
						ValaPropertyAccessor* _tmp534_;
						gboolean _tmp535_;
						gboolean _tmp536_;
						_tmp532_ = prop;
						_tmp533_ = vala_property_get_set_accessor (_tmp532_);
						_tmp534_ = _tmp533_;
						_tmp535_ = vala_property_accessor_get_writable (_tmp534_);
						_tmp536_ = _tmp535_;
						_tmp529_ = !_tmp536_;
					} else {
						_tmp529_ = FALSE;
					}
					if (_tmp529_) {
						ValaSemanticAnalyzer* _tmp537_;
						ValaSemanticAnalyzer* _tmp538_;
						ValaMethod* _tmp539_;
						ValaMethod* _tmp540_;
						_tmp537_ = vala_code_context_get_analyzer (context);
						_tmp538_ = _tmp537_;
						_tmp539_ = vala_semantic_analyzer_find_current_method (_tmp538_);
						_tmp540_ = _tmp539_;
						_tmp528_ = VALA_IS_CREATION_METHOD (_tmp540_);
						_vala_code_node_unref0 (_tmp540_);
					} else {
						_tmp528_ = FALSE;
					}
					if (_tmp528_) {
						ValaMemberAccess* _tmp541_;
						ValaExpression* _tmp542_;
						ValaExpression* _tmp543_;
						ValaSymbol* _tmp544_;
						ValaSymbol* _tmp545_;
						ValaSemanticAnalyzer* _tmp546_;
						ValaSemanticAnalyzer* _tmp547_;
						ValaMethod* _tmp548_;
						ValaMethod* _tmp549_;
						ValaParameter* _tmp550_;
						ValaParameter* _tmp551_;
						gboolean _tmp552_;
						_tmp541_ = ma;
						_tmp542_ = vala_member_access_get_inner (_tmp541_);
						_tmp543_ = _tmp542_;
						_tmp544_ = vala_expression_get_symbol_reference (_tmp543_);
						_tmp545_ = _tmp544_;
						_tmp546_ = vala_code_context_get_analyzer (context);
						_tmp547_ = _tmp546_;
						_tmp548_ = vala_semantic_analyzer_find_current_method (_tmp547_);
						_tmp549_ = _tmp548_;
						_tmp550_ = vala_method_get_this_parameter (_tmp549_);
						_tmp551_ = _tmp550_;
						_tmp552_ = _tmp545_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp551_, VALA_TYPE_SYMBOL, ValaSymbol);
						_vala_code_node_unref0 (_tmp549_);
						if (_tmp552_) {
							ValaMemberAccess* _tmp553_;
							ValaSourceReference* _tmp554_;
							ValaSourceReference* _tmp555_;
							ValaProperty* _tmp556_;
							gchar* _tmp557_;
							gchar* _tmp558_;
							gchar* _tmp559_;
							gchar* _tmp560_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp553_ = ma;
							_tmp554_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp553_);
							_tmp555_ = _tmp554_;
							_tmp556_ = prop;
							_tmp557_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp556_);
							_tmp558_ = _tmp557_;
							_tmp559_ = g_strdup_printf ("Property `%s' is read-only", _tmp558_);
							_tmp560_ = _tmp559_;
							vala_report_error (_tmp555_, _tmp560_);
							_g_free0 (_tmp560_);
							_g_free0 (_tmp558_);
							result = FALSE;
							_vala_code_node_unref0 (dynamic_prop);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (ma);
							return result;
						} else {
							ValaMemberAccess* _tmp561_;
							ValaSourceReference* _tmp562_;
							ValaSourceReference* _tmp563_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp561_ = ma;
							_tmp562_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp561_);
							_tmp563_ = _tmp562_;
							vala_report_error (_tmp563_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
							result = FALSE;
							_vala_code_node_unref0 (dynamic_prop);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (ma);
							return result;
						}
					}
				}
				_vala_code_node_unref0 (dynamic_prop);
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp564_ = FALSE;
				ValaMemberAccess* _tmp565_;
				ValaSymbol* _tmp566_;
				ValaSymbol* _tmp567_;
				_tmp565_ = ma;
				_tmp566_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp565_);
				_tmp567_ = _tmp566_;
				if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp567_)) {
					ValaMemberAccess* _tmp568_;
					ValaExpression* _tmp569_;
					ValaExpression* _tmp570_;
					ValaDataType* _tmp571_;
					ValaDataType* _tmp572_;
					gboolean _tmp573_;
					gboolean _tmp574_;
					_tmp568_ = ma;
					_tmp569_ = vala_member_access_get_inner (_tmp568_);
					_tmp570_ = _tmp569_;
					_tmp571_ = vala_expression_get_value_type (_tmp570_);
					_tmp572_ = _tmp571_;
					_tmp573_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp572_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp574_ = _tmp573_;
					_tmp564_ = _tmp574_;
				} else {
					_tmp564_ = FALSE;
				}
				if (_tmp564_) {
					ValaSourceReference* _tmp575_;
					ValaSourceReference* _tmp576_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp575_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp576_ = _tmp575_;
					vala_report_error (_tmp576_, "`length' field of fixed length arrays is read-only");
					result = FALSE;
					_vala_code_node_unref0 (ma);
					return result;
				} else {
					gboolean _tmp577_ = FALSE;
					ValaMemberAccess* _tmp578_;
					ValaSymbol* _tmp579_;
					ValaSymbol* _tmp580_;
					_tmp578_ = ma;
					_tmp579_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp578_);
					_tmp580_ = _tmp579_;
					if (VALA_IS_VARIABLE (_tmp580_)) {
						ValaExpression* _tmp581_;
						ValaExpression* _tmp582_;
						ValaDataType* _tmp583_;
						ValaDataType* _tmp584_;
						_tmp581_ = vala_assignment_get_right (self);
						_tmp582_ = _tmp581_;
						_tmp583_ = vala_expression_get_value_type (_tmp582_);
						_tmp584_ = _tmp583_;
						_tmp577_ = _tmp584_ == NULL;
					} else {
						_tmp577_ = FALSE;
					}
					if (_tmp577_) {
						ValaVariable* variable = NULL;
						ValaMemberAccess* _tmp585_;
						ValaSymbol* _tmp586_;
						ValaSymbol* _tmp587_;
						ValaVariable* _tmp588_;
						gboolean _tmp589_ = FALSE;
						ValaExpression* _tmp590_;
						ValaExpression* _tmp591_;
						ValaSymbol* _tmp592_;
						ValaSymbol* _tmp593_;
						_tmp585_ = ma;
						_tmp586_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp585_);
						_tmp587_ = _tmp586_;
						_tmp588_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp587_, VALA_TYPE_VARIABLE, ValaVariable));
						variable = _tmp588_;
						_tmp590_ = vala_assignment_get_right (self);
						_tmp591_ = _tmp590_;
						_tmp592_ = vala_expression_get_symbol_reference (_tmp591_);
						_tmp593_ = _tmp592_;
						if (VALA_IS_METHOD (_tmp593_)) {
							ValaVariable* _tmp594_;
							ValaDataType* _tmp595_;
							ValaDataType* _tmp596_;
							_tmp594_ = variable;
							_tmp595_ = vala_variable_get_variable_type (_tmp594_);
							_tmp596_ = _tmp595_;
							_tmp589_ = VALA_IS_DELEGATE_TYPE (_tmp596_);
						} else {
							_tmp589_ = FALSE;
						}
						if (_tmp589_) {
							ValaMethod* m = NULL;
							ValaExpression* _tmp597_;
							ValaExpression* _tmp598_;
							ValaSymbol* _tmp599_;
							ValaSymbol* _tmp600_;
							ValaMethod* _tmp601_;
							ValaDelegateType* dt = NULL;
							ValaVariable* _tmp602_;
							ValaDataType* _tmp603_;
							ValaDataType* _tmp604_;
							ValaDelegateType* _tmp605_;
							ValaDelegate* cb = NULL;
							ValaDelegateType* _tmp606_;
							ValaDelegate* _tmp607_;
							ValaDelegate* _tmp608_;
							ValaDelegate* _tmp609_;
							ValaDelegate* _tmp610_;
							ValaMethod* _tmp611_;
							ValaDelegateType* _tmp612_;
							ValaExpression* _tmp623_;
							ValaExpression* _tmp624_;
							ValaVariable* _tmp625_;
							ValaDataType* _tmp626_;
							ValaDataType* _tmp627_;
							ValaDataType* _tmp628_;
							ValaDataType* _tmp629_;
							_tmp597_ = vala_assignment_get_right (self);
							_tmp598_ = _tmp597_;
							_tmp599_ = vala_expression_get_symbol_reference (_tmp598_);
							_tmp600_ = _tmp599_;
							_tmp601_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp600_, VALA_TYPE_METHOD, ValaMethod));
							m = _tmp601_;
							_tmp602_ = variable;
							_tmp603_ = vala_variable_get_variable_type (_tmp602_);
							_tmp604_ = _tmp603_;
							_tmp605_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp604_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							dt = _tmp605_;
							_tmp606_ = dt;
							_tmp607_ = vala_delegate_type_get_delegate_symbol (_tmp606_);
							_tmp608_ = _tmp607_;
							_tmp609_ = _vala_code_node_ref0 (_tmp608_);
							cb = _tmp609_;
							_tmp610_ = cb;
							_tmp611_ = m;
							_tmp612_ = dt;
							if (!vala_delegate_matches_method (_tmp610_, _tmp611_, (ValaDataType*) _tmp612_)) {
								ValaSourceReference* _tmp613_;
								ValaSourceReference* _tmp614_;
								ValaMethod* _tmp615_;
								gchar* _tmp616_;
								gchar* _tmp617_;
								ValaDelegate* _tmp618_;
								gchar* _tmp619_;
								gchar* _tmp620_;
								gchar* _tmp621_;
								gchar* _tmp622_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp613_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp614_ = _tmp613_;
								_tmp615_ = m;
								_tmp616_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp615_);
								_tmp617_ = _tmp616_;
								_tmp618_ = cb;
								_tmp619_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp618_);
								_tmp620_ = _tmp619_;
								_tmp621_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp617_, _tmp620_);
								_tmp622_ = _tmp621_;
								vala_report_error (_tmp614_, _tmp622_);
								_g_free0 (_tmp622_);
								_g_free0 (_tmp620_);
								_g_free0 (_tmp617_);
								result = FALSE;
								_vala_code_node_unref0 (cb);
								_vala_code_node_unref0 (dt);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (variable);
								_vala_code_node_unref0 (ma);
								return result;
							}
							_tmp623_ = vala_assignment_get_right (self);
							_tmp624_ = _tmp623_;
							_tmp625_ = variable;
							_tmp626_ = vala_variable_get_variable_type (_tmp625_);
							_tmp627_ = _tmp626_;
							_tmp628_ = vala_data_type_copy (_tmp627_);
							_tmp629_ = _tmp628_;
							vala_expression_set_value_type (_tmp624_, _tmp629_);
							_vala_code_node_unref0 (_tmp629_);
							_vala_code_node_unref0 (cb);
							_vala_code_node_unref0 (dt);
							_vala_code_node_unref0 (m);
						} else {
							ValaSourceReference* _tmp630_;
							ValaSourceReference* _tmp631_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp630_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp631_ = _tmp630_;
							vala_report_error (_tmp631_, "Assignment: Invalid assignment attempt");
							result = FALSE;
							_vala_code_node_unref0 (variable);
							_vala_code_node_unref0 (ma);
							return result;
						}
						_vala_code_node_unref0 (variable);
					} else {
						ValaMemberAccess* _tmp632_;
						ValaSymbol* _tmp633_;
						ValaSymbol* _tmp634_;
						_tmp632_ = ma;
						_tmp633_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp632_);
						_tmp634_ = _tmp633_;
						if (VALA_IS_VARIABLE (_tmp634_)) {
							ValaVariable* variable = NULL;
							ValaMemberAccess* _tmp635_;
							ValaSymbol* _tmp636_;
							ValaSymbol* _tmp637_;
							ValaArrayType* variable_array_type = NULL;
							ValaVariable* _tmp638_;
							ValaDataType* _tmp639_;
							ValaDataType* _tmp640_;
							gboolean _tmp641_ = FALSE;
							gboolean _tmp642_ = FALSE;
							gboolean _tmp643_ = FALSE;
							ValaArrayType* _tmp644_;
							_tmp635_ = ma;
							_tmp636_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp635_);
							_tmp637_ = _tmp636_;
							variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp637_, VALA_TYPE_VARIABLE, ValaVariable);
							_tmp638_ = variable;
							_tmp639_ = vala_variable_get_variable_type (_tmp638_);
							_tmp640_ = _tmp639_;
							variable_array_type = VALA_IS_ARRAY_TYPE (_tmp640_) ? ((ValaArrayType*) _tmp640_) : NULL;
							_tmp644_ = variable_array_type;
							if (_tmp644_ != NULL) {
								ValaArrayType* _tmp645_;
								gboolean _tmp646_;
								gboolean _tmp647_;
								_tmp645_ = variable_array_type;
								_tmp646_ = vala_array_type_get_inline_allocated (_tmp645_);
								_tmp647_ = _tmp646_;
								_tmp643_ = _tmp647_;
							} else {
								_tmp643_ = FALSE;
							}
							if (_tmp643_) {
								ValaExpression* _tmp648_;
								ValaExpression* _tmp649_;
								_tmp648_ = vala_assignment_get_right (self);
								_tmp649_ = _tmp648_;
								_tmp642_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp649_);
							} else {
								_tmp642_ = FALSE;
							}
							if (_tmp642_) {
								ValaExpression* _tmp650_;
								ValaExpression* _tmp651_;
								ValaInitializerList* _tmp652_;
								ValaInitializerList* _tmp653_;
								_tmp650_ = vala_assignment_get_right (self);
								_tmp651_ = _tmp650_;
								_tmp652_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp651_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
								_tmp653_ = _tmp652_;
								_tmp641_ = _tmp653_ == NULL;
							} else {
								_tmp641_ = FALSE;
							}
							if (_tmp641_) {
								ValaSourceReference* _tmp654_;
								ValaSourceReference* _tmp655_;
								ValaCodeNode* _tmp656_;
								ValaCodeNode* _tmp657_;
								ValaCodeNode* _tmp658_;
								ValaCodeNode* _tmp659_;
								ValaCodeNode* _tmp660_;
								ValaCodeNode* _tmp661_;
								ValaSourceReference* _tmp662_;
								ValaSourceReference* _tmp663_;
								ValaEmptyStatement* _tmp664_;
								ValaEmptyStatement* _tmp665_;
								_tmp654_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp655_ = _tmp654_;
								vala_report_warning (_tmp655_, "Inline allocated arrays don't require an explicit instantiation");
								_tmp656_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp657_ = _tmp656_;
								_tmp658_ = vala_code_node_get_parent_node (_tmp657_);
								_tmp659_ = _tmp658_;
								_tmp660_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp661_ = _tmp660_;
								_tmp662_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp663_ = _tmp662_;
								_tmp664_ = vala_empty_statement_new (_tmp663_);
								_tmp665_ = _tmp664_;
								vala_block_replace_statement (G_TYPE_CHECK_INSTANCE_CAST (_tmp659_, VALA_TYPE_BLOCK, ValaBlock), G_TYPE_CHECK_INSTANCE_CAST (_tmp661_, VALA_TYPE_STATEMENT, ValaStatement), (ValaStatement*) _tmp665_);
								_vala_code_node_unref0 (_tmp665_);
								result = TRUE;
								_vala_code_node_unref0 (ma);
								return result;
							}
						}
					}
				}
			}
			_tmp667_ = vala_assignment_get_left (self);
			_tmp668_ = _tmp667_;
			_tmp669_ = vala_expression_get_value_type (_tmp668_);
			_tmp670_ = _tmp669_;
			if (_tmp670_ != NULL) {
				ValaExpression* _tmp671_;
				ValaExpression* _tmp672_;
				ValaDataType* _tmp673_;
				ValaDataType* _tmp674_;
				_tmp671_ = vala_assignment_get_right (self);
				_tmp672_ = _tmp671_;
				_tmp673_ = vala_expression_get_value_type (_tmp672_);
				_tmp674_ = _tmp673_;
				_tmp666_ = _tmp674_ != NULL;
			} else {
				_tmp666_ = FALSE;
			}
			if (_tmp666_) {
				ValaExpression* _tmp675_;
				ValaExpression* _tmp676_;
				ValaDataType* _tmp677_;
				ValaDataType* _tmp678_;
				ValaExpression* _tmp679_;
				ValaExpression* _tmp680_;
				ValaDataType* _tmp681_;
				ValaDataType* _tmp682_;
				ValaMemberAccess* _tmp699_;
				ValaSymbol* _tmp700_;
				ValaSymbol* _tmp701_;
				_tmp675_ = vala_assignment_get_right (self);
				_tmp676_ = _tmp675_;
				_tmp677_ = vala_expression_get_value_type (_tmp676_);
				_tmp678_ = _tmp677_;
				_tmp679_ = vala_assignment_get_left (self);
				_tmp680_ = _tmp679_;
				_tmp681_ = vala_expression_get_value_type (_tmp680_);
				_tmp682_ = _tmp681_;
				if (!vala_data_type_compatible (_tmp678_, _tmp682_)) {
					ValaSourceReference* _tmp683_;
					ValaSourceReference* _tmp684_;
					ValaExpression* _tmp685_;
					ValaExpression* _tmp686_;
					ValaDataType* _tmp687_;
					ValaDataType* _tmp688_;
					gchar* _tmp689_;
					gchar* _tmp690_;
					ValaExpression* _tmp691_;
					ValaExpression* _tmp692_;
					ValaDataType* _tmp693_;
					ValaDataType* _tmp694_;
					gchar* _tmp695_;
					gchar* _tmp696_;
					gchar* _tmp697_;
					gchar* _tmp698_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp683_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp684_ = _tmp683_;
					_tmp685_ = vala_assignment_get_right (self);
					_tmp686_ = _tmp685_;
					_tmp687_ = vala_expression_get_value_type (_tmp686_);
					_tmp688_ = _tmp687_;
					_tmp689_ = vala_code_node_to_string ((ValaCodeNode*) _tmp688_);
					_tmp690_ = _tmp689_;
					_tmp691_ = vala_assignment_get_left (self);
					_tmp692_ = _tmp691_;
					_tmp693_ = vala_expression_get_value_type (_tmp692_);
					_tmp694_ = _tmp693_;
					_tmp695_ = vala_code_node_to_string ((ValaCodeNode*) _tmp694_);
					_tmp696_ = _tmp695_;
					_tmp697_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp690_, _tmp696_);
					_tmp698_ = _tmp697_;
					vala_report_error (_tmp684_, _tmp698_);
					_g_free0 (_tmp698_);
					_g_free0 (_tmp696_);
					_g_free0 (_tmp690_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					return result;
				}
				_tmp699_ = ma;
				_tmp700_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp699_);
				_tmp701_ = _tmp700_;
				if (!VALA_IS_PROPERTY (_tmp701_)) {
					ValaExpression* _tmp702_;
					ValaExpression* _tmp703_;
					ValaDataType* _tmp704_;
					ValaDataType* _tmp705_;
					_tmp702_ = vala_assignment_get_right (self);
					_tmp703_ = _tmp702_;
					_tmp704_ = vala_expression_get_value_type (_tmp703_);
					_tmp705_ = _tmp704_;
					if (vala_data_type_is_disposable (_tmp705_)) {
						gboolean _tmp706_ = FALSE;
						ValaExpression* _tmp707_;
						ValaExpression* _tmp708_;
						ValaDataType* _tmp709_;
						ValaDataType* _tmp710_;
						_tmp707_ = vala_assignment_get_left (self);
						_tmp708_ = _tmp707_;
						_tmp709_ = vala_expression_get_value_type (_tmp708_);
						_tmp710_ = _tmp709_;
						if (!VALA_IS_POINTER_TYPE (_tmp710_)) {
							ValaExpression* _tmp711_;
							ValaExpression* _tmp712_;
							ValaDataType* _tmp713_;
							ValaDataType* _tmp714_;
							gboolean _tmp715_;
							gboolean _tmp716_;
							_tmp711_ = vala_assignment_get_left (self);
							_tmp712_ = _tmp711_;
							_tmp713_ = vala_expression_get_value_type (_tmp712_);
							_tmp714_ = _tmp713_;
							_tmp715_ = vala_data_type_get_value_owned (_tmp714_);
							_tmp716_ = _tmp715_;
							_tmp706_ = !_tmp716_;
						} else {
							_tmp706_ = FALSE;
						}
						if (_tmp706_) {
							ValaSourceReference* _tmp717_;
							ValaSourceReference* _tmp718_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp717_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp718_ = _tmp717_;
							vala_report_error (_tmp718_, "Invalid assignment from owned expression to unowned variable");
						}
					} else {
						ValaExpression* _tmp719_;
						ValaExpression* _tmp720_;
						ValaDataType* _tmp721_;
						ValaDataType* _tmp722_;
						gboolean _tmp723_;
						gboolean _tmp724_;
						_tmp719_ = vala_assignment_get_left (self);
						_tmp720_ = _tmp719_;
						_tmp721_ = vala_expression_get_value_type (_tmp720_);
						_tmp722_ = _tmp721_;
						_tmp723_ = vala_data_type_get_value_owned (_tmp722_);
						_tmp724_ = _tmp723_;
						if (_tmp724_) {
						}
					}
				}
			}
			_tmp725_ = vala_assignment_get_right (self);
			_tmp726_ = _tmp725_;
			_tmp727_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp726_) ? ((ValaMemberAccess*) _tmp726_) : NULL);
			right_ma = _tmp727_;
			_tmp729_ = right_ma;
			if (_tmp729_ != NULL) {
				ValaMemberAccess* _tmp730_;
				ValaSymbol* _tmp731_;
				ValaSymbol* _tmp732_;
				ValaMemberAccess* _tmp733_;
				ValaSymbol* _tmp734_;
				ValaSymbol* _tmp735_;
				_tmp730_ = ma;
				_tmp731_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp730_);
				_tmp732_ = _tmp731_;
				_tmp733_ = right_ma;
				_tmp734_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp733_);
				_tmp735_ = _tmp734_;
				_tmp728_ = _tmp732_ == _tmp735_;
			} else {
				_tmp728_ = FALSE;
			}
			if (_tmp728_) {
				gboolean _tmp736_ = FALSE;
				ValaMemberAccess* _tmp737_;
				ValaSymbol* _tmp738_;
				ValaSymbol* _tmp739_;
				_tmp737_ = ma;
				_tmp738_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp737_);
				_tmp739_ = _tmp738_;
				if (VALA_IS_LOCAL_VARIABLE (_tmp739_)) {
					_tmp736_ = TRUE;
				} else {
					ValaMemberAccess* _tmp740_;
					ValaSymbol* _tmp741_;
					ValaSymbol* _tmp742_;
					_tmp740_ = ma;
					_tmp741_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp740_);
					_tmp742_ = _tmp741_;
					_tmp736_ = VALA_IS_PARAMETER (_tmp742_);
				}
				if (_tmp736_) {
					ValaSourceReference* _tmp743_;
					ValaSourceReference* _tmp744_;
					_tmp743_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp744_ = _tmp743_;
					vala_report_warning (_tmp744_, "Assignment to same variable");
				} else {
					ValaMemberAccess* _tmp745_;
					ValaSymbol* _tmp746_;
					ValaSymbol* _tmp747_;
					_tmp745_ = ma;
					_tmp746_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp745_);
					_tmp747_ = _tmp746_;
					if (VALA_IS_FIELD (_tmp747_)) {
						ValaField* f = NULL;
						ValaMemberAccess* _tmp748_;
						ValaSymbol* _tmp749_;
						ValaSymbol* _tmp750_;
						ValaField* _tmp751_;
						ValaField* _tmp752_;
						ValaMemberBinding _tmp753_;
						ValaMemberBinding _tmp754_;
						_tmp748_ = ma;
						_tmp749_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp748_);
						_tmp750_ = _tmp749_;
						_tmp751_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp750_, VALA_TYPE_FIELD, ValaField));
						f = _tmp751_;
						_tmp752_ = f;
						_tmp753_ = vala_field_get_binding (_tmp752_);
						_tmp754_ = _tmp753_;
						if (_tmp754_ == VALA_MEMBER_BINDING_STATIC) {
							ValaSourceReference* _tmp755_;
							ValaSourceReference* _tmp756_;
							_tmp755_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp756_ = _tmp755_;
							vala_report_warning (_tmp756_, "Assignment to same variable");
						} else {
							ValaMemberAccess* ma_inner = NULL;
							ValaMemberAccess* _tmp757_;
							ValaExpression* _tmp758_;
							ValaExpression* _tmp759_;
							ValaMemberAccess* _tmp760_;
							ValaMemberAccess* right_ma_inner = NULL;
							ValaMemberAccess* _tmp761_;
							ValaExpression* _tmp762_;
							ValaExpression* _tmp763_;
							ValaMemberAccess* _tmp764_;
							gboolean _tmp765_ = FALSE;
							gboolean _tmp766_ = FALSE;
							gboolean _tmp767_ = FALSE;
							gboolean _tmp768_ = FALSE;
							gboolean _tmp769_ = FALSE;
							ValaMemberAccess* _tmp770_;
							_tmp757_ = ma;
							_tmp758_ = vala_member_access_get_inner (_tmp757_);
							_tmp759_ = _tmp758_;
							_tmp760_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp759_) ? ((ValaMemberAccess*) _tmp759_) : NULL);
							ma_inner = _tmp760_;
							_tmp761_ = right_ma;
							_tmp762_ = vala_member_access_get_inner (_tmp761_);
							_tmp763_ = _tmp762_;
							_tmp764_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp763_) ? ((ValaMemberAccess*) _tmp763_) : NULL);
							right_ma_inner = _tmp764_;
							_tmp770_ = ma_inner;
							if (_tmp770_ != NULL) {
								ValaMemberAccess* _tmp771_;
								const gchar* _tmp772_;
								const gchar* _tmp773_;
								_tmp771_ = ma_inner;
								_tmp772_ = vala_member_access_get_member_name (_tmp771_);
								_tmp773_ = _tmp772_;
								_tmp769_ = g_strcmp0 (_tmp773_, "this") == 0;
							} else {
								_tmp769_ = FALSE;
							}
							if (_tmp769_) {
								ValaMemberAccess* _tmp774_;
								ValaExpression* _tmp775_;
								ValaExpression* _tmp776_;
								_tmp774_ = ma_inner;
								_tmp775_ = vala_member_access_get_inner (_tmp774_);
								_tmp776_ = _tmp775_;
								_tmp768_ = _tmp776_ == NULL;
							} else {
								_tmp768_ = FALSE;
							}
							if (_tmp768_) {
								ValaMemberAccess* _tmp777_;
								_tmp777_ = right_ma_inner;
								_tmp767_ = _tmp777_ != NULL;
							} else {
								_tmp767_ = FALSE;
							}
							if (_tmp767_) {
								ValaMemberAccess* _tmp778_;
								const gchar* _tmp779_;
								const gchar* _tmp780_;
								_tmp778_ = right_ma_inner;
								_tmp779_ = vala_member_access_get_member_name (_tmp778_);
								_tmp780_ = _tmp779_;
								_tmp766_ = g_strcmp0 (_tmp780_, "this") == 0;
							} else {
								_tmp766_ = FALSE;
							}
							if (_tmp766_) {
								ValaMemberAccess* _tmp781_;
								ValaExpression* _tmp782_;
								ValaExpression* _tmp783_;
								_tmp781_ = right_ma_inner;
								_tmp782_ = vala_member_access_get_inner (_tmp781_);
								_tmp783_ = _tmp782_;
								_tmp765_ = _tmp783_ == NULL;
							} else {
								_tmp765_ = FALSE;
							}
							if (_tmp765_) {
								ValaSourceReference* _tmp784_;
								ValaSourceReference* _tmp785_;
								_tmp784_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp785_ = _tmp784_;
								vala_report_warning (_tmp785_, "Assignment to same variable");
							}
							_vala_code_node_unref0 (right_ma_inner);
							_vala_code_node_unref0 (ma_inner);
						}
						_vala_code_node_unref0 (f);
					}
				}
			}
			_vala_code_node_unref0 (right_ma);
			_vala_code_node_unref0 (ma);
		} else {
			ValaExpression* _tmp786_;
			ValaExpression* _tmp787_;
			_tmp786_ = vala_assignment_get_left (self);
			_tmp787_ = _tmp786_;
			if (VALA_IS_ELEMENT_ACCESS (_tmp787_)) {
				ValaElementAccess* ea = NULL;
				ValaExpression* _tmp788_;
				ValaExpression* _tmp789_;
				ValaElementAccess* _tmp790_;
				ValaExpression* _tmp791_;
				ValaExpression* _tmp792_;
				ValaDataType* _tmp793_;
				ValaDataType* _tmp794_;
				ValaExpression* _tmp795_;
				ValaExpression* _tmp796_;
				ValaDataType* _tmp797_;
				ValaDataType* _tmp798_;
				ValaExpression* _tmp815_;
				ValaExpression* _tmp816_;
				ValaDataType* _tmp817_;
				ValaDataType* _tmp818_;
				_tmp788_ = vala_assignment_get_left (self);
				_tmp789_ = _tmp788_;
				_tmp790_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp789_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
				ea = _tmp790_;
				_tmp791_ = vala_assignment_get_right (self);
				_tmp792_ = _tmp791_;
				_tmp793_ = vala_expression_get_value_type (_tmp792_);
				_tmp794_ = _tmp793_;
				_tmp795_ = vala_assignment_get_left (self);
				_tmp796_ = _tmp795_;
				_tmp797_ = vala_expression_get_value_type (_tmp796_);
				_tmp798_ = _tmp797_;
				if (!vala_data_type_compatible (_tmp794_, _tmp798_)) {
					ValaSourceReference* _tmp799_;
					ValaSourceReference* _tmp800_;
					ValaExpression* _tmp801_;
					ValaExpression* _tmp802_;
					ValaDataType* _tmp803_;
					ValaDataType* _tmp804_;
					gchar* _tmp805_;
					gchar* _tmp806_;
					ValaExpression* _tmp807_;
					ValaExpression* _tmp808_;
					ValaDataType* _tmp809_;
					ValaDataType* _tmp810_;
					gchar* _tmp811_;
					gchar* _tmp812_;
					gchar* _tmp813_;
					gchar* _tmp814_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp799_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp800_ = _tmp799_;
					_tmp801_ = vala_assignment_get_right (self);
					_tmp802_ = _tmp801_;
					_tmp803_ = vala_expression_get_value_type (_tmp802_);
					_tmp804_ = _tmp803_;
					_tmp805_ = vala_code_node_to_string ((ValaCodeNode*) _tmp804_);
					_tmp806_ = _tmp805_;
					_tmp807_ = vala_assignment_get_left (self);
					_tmp808_ = _tmp807_;
					_tmp809_ = vala_expression_get_value_type (_tmp808_);
					_tmp810_ = _tmp809_;
					_tmp811_ = vala_code_node_to_string ((ValaCodeNode*) _tmp810_);
					_tmp812_ = _tmp811_;
					_tmp813_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp806_, _tmp812_);
					_tmp814_ = _tmp813_;
					vala_report_error (_tmp800_, _tmp814_);
					_g_free0 (_tmp814_);
					_g_free0 (_tmp812_);
					_g_free0 (_tmp806_);
					result = FALSE;
					_vala_code_node_unref0 (ea);
					return result;
				}
				_tmp815_ = vala_assignment_get_right (self);
				_tmp816_ = _tmp815_;
				_tmp817_ = vala_expression_get_value_type (_tmp816_);
				_tmp818_ = _tmp817_;
				if (vala_data_type_is_disposable (_tmp818_)) {
					ValaDataType* element_type = NULL;
					ValaElementAccess* _tmp819_;
					ValaExpression* _tmp820_;
					ValaExpression* _tmp821_;
					ValaDataType* _tmp822_;
					ValaDataType* _tmp823_;
					gboolean _tmp845_ = FALSE;
					ValaDataType* _tmp846_;
					_tmp819_ = ea;
					_tmp820_ = vala_element_access_get_container (_tmp819_);
					_tmp821_ = _tmp820_;
					_tmp822_ = vala_expression_get_value_type (_tmp821_);
					_tmp823_ = _tmp822_;
					if (VALA_IS_ARRAY_TYPE (_tmp823_)) {
						ValaArrayType* array_type = NULL;
						ValaElementAccess* _tmp824_;
						ValaExpression* _tmp825_;
						ValaExpression* _tmp826_;
						ValaDataType* _tmp827_;
						ValaDataType* _tmp828_;
						ValaArrayType* _tmp829_;
						ValaArrayType* _tmp830_;
						ValaDataType* _tmp831_;
						ValaDataType* _tmp832_;
						ValaDataType* _tmp833_;
						_tmp824_ = ea;
						_tmp825_ = vala_element_access_get_container (_tmp824_);
						_tmp826_ = _tmp825_;
						_tmp827_ = vala_expression_get_value_type (_tmp826_);
						_tmp828_ = _tmp827_;
						_tmp829_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp828_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp829_;
						_tmp830_ = array_type;
						_tmp831_ = vala_array_type_get_element_type (_tmp830_);
						_tmp832_ = _tmp831_;
						_tmp833_ = _vala_code_node_ref0 (_tmp832_);
						_vala_code_node_unref0 (element_type);
						element_type = _tmp833_;
						_vala_code_node_unref0 (array_type);
					} else {
						ValaList* args = NULL;
						ValaElementAccess* _tmp834_;
						ValaExpression* _tmp835_;
						ValaExpression* _tmp836_;
						ValaDataType* _tmp837_;
						ValaDataType* _tmp838_;
						ValaList* _tmp839_;
						ValaList* _tmp840_;
						gint _tmp841_;
						gint _tmp842_;
						ValaList* _tmp843_;
						gpointer _tmp844_;
						_tmp834_ = ea;
						_tmp835_ = vala_element_access_get_container (_tmp834_);
						_tmp836_ = _tmp835_;
						_tmp837_ = vala_expression_get_value_type (_tmp836_);
						_tmp838_ = _tmp837_;
						_tmp839_ = vala_data_type_get_type_arguments (_tmp838_);
						args = _tmp839_;
						_tmp840_ = args;
						_tmp841_ = vala_collection_get_size ((ValaCollection*) _tmp840_);
						_tmp842_ = _tmp841_;
						_vala_assert (_tmp842_ == 1, "args.size == 1");
						_tmp843_ = args;
						_tmp844_ = vala_list_get (_tmp843_, 0);
						_vala_code_node_unref0 (element_type);
						element_type = (ValaDataType*) _tmp844_;
						_vala_iterable_unref0 (args);
					}
					_tmp846_ = element_type;
					if (!VALA_IS_POINTER_TYPE (_tmp846_)) {
						ValaDataType* _tmp847_;
						gboolean _tmp848_;
						gboolean _tmp849_;
						_tmp847_ = element_type;
						_tmp848_ = vala_data_type_get_value_owned (_tmp847_);
						_tmp849_ = _tmp848_;
						_tmp845_ = !_tmp849_;
					} else {
						_tmp845_ = FALSE;
					}
					if (_tmp845_) {
						ValaSourceReference* _tmp850_;
						ValaSourceReference* _tmp851_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp850_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp851_ = _tmp850_;
						vala_report_error (_tmp851_, "Invalid assignment from owned expression to unowned variable");
						result = FALSE;
						_vala_code_node_unref0 (element_type);
						_vala_code_node_unref0 (ea);
						return result;
					}
					_vala_code_node_unref0 (element_type);
				} else {
					ValaExpression* _tmp852_;
					ValaExpression* _tmp853_;
					ValaDataType* _tmp854_;
					ValaDataType* _tmp855_;
					gboolean _tmp856_;
					gboolean _tmp857_;
					_tmp852_ = vala_assignment_get_left (self);
					_tmp853_ = _tmp852_;
					_tmp854_ = vala_expression_get_value_type (_tmp853_);
					_tmp855_ = _tmp854_;
					_tmp856_ = vala_data_type_get_value_owned (_tmp855_);
					_tmp857_ = _tmp856_;
					if (_tmp857_) {
					}
				}
				_vala_code_node_unref0 (ea);
			} else {
				result = TRUE;
				return result;
			}
		}
	}
	_tmp858_ = vala_assignment_get_left (self);
	_tmp859_ = _tmp858_;
	_tmp860_ = vala_expression_get_value_type (_tmp859_);
	_tmp861_ = _tmp860_;
	if (_tmp861_ != NULL) {
		ValaExpression* _tmp862_;
		ValaExpression* _tmp863_;
		ValaDataType* _tmp864_;
		ValaDataType* _tmp865_;
		ValaDataType* _tmp866_;
		ValaDataType* _tmp867_;
		ValaDataType* _tmp868_;
		ValaDataType* _tmp869_;
		_tmp862_ = vala_assignment_get_left (self);
		_tmp863_ = _tmp862_;
		_tmp864_ = vala_expression_get_value_type (_tmp863_);
		_tmp865_ = _tmp864_;
		_tmp866_ = vala_data_type_copy (_tmp865_);
		_tmp867_ = _tmp866_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp867_);
		_vala_code_node_unref0 (_tmp867_);
		_tmp868_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp869_ = _tmp868_;
		vala_data_type_set_value_owned (_tmp869_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp870_ = vala_assignment_get_left (self);
	_tmp871_ = _tmp870_;
	_tmp872_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp871_);
	_tmp873_ = _tmp872_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp873_);
	_vala_iterable_unref0 (_tmp873_);
	_tmp874_ = vala_assignment_get_right (self);
	_tmp875_ = _tmp874_;
	_tmp876_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp875_);
	_tmp877_ = _tmp876_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp877_);
	_vala_iterable_unref0 (_tmp877_);
	_tmp878_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp879_ = _tmp878_;
	result = !_tmp879_;
	return result;
}


static gboolean
vala_assignment_is_array_add (ValaAssignment* self)
{
	gboolean result = FALSE;
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBinaryExpression* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaBinaryExpression* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_BINARY_EXPRESSION (_tmp1_) ? ((ValaBinaryExpression*) _tmp1_) : NULL);
	binary = _tmp2_;
	_tmp4_ = binary;
	if (_tmp4_ != NULL) {
		ValaBinaryExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp5_ = binary;
		_tmp6_ = vala_binary_expression_get_left (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_value_type (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = VALA_IS_ARRAY_TYPE (_tmp9_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaBinaryExpression* _tmp10_;
		ValaBinaryOperator _tmp11_;
		ValaBinaryOperator _tmp12_;
		_tmp10_ = binary;
		_tmp11_ = vala_binary_expression_get_operator (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaBinaryExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaExpression* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaSymbol* _tmp21_;
			_tmp13_ = vala_assignment_get_left (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = binary;
			_tmp18_ = vala_binary_expression_get_left (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_expression_get_symbol_reference (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp16_ == _tmp21_) {
				result = TRUE;
				_vala_code_node_unref0 (binary);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (binary);
	return result;
}


static void
vala_assignment_check_constant_assignment (ValaAssignment* self,
                                           ValaMemberAccess* inner)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		if (!(inner != NULL)) {
			break;
		}
		_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) inner);
		_tmp1_ = _tmp0_;
		if (VALA_IS_CONSTANT (_tmp1_)) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			vala_report_error (_tmp3_, "Assignment to constant after initialization");
			break;
		}
		_tmp4_ = vala_member_access_get_inner (inner);
		_tmp5_ = _tmp4_;
		if (VALA_IS_MEMBER_ACCESS (_tmp5_)) {
			ValaExpression* _tmp6_;
			ValaExpression* _tmp7_;
			_tmp6_ = vala_member_access_get_inner (inner);
			_tmp7_ = _tmp6_;
			inner = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		} else {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (inner);
			_tmp9_ = _tmp8_;
			if (VALA_IS_ELEMENT_ACCESS (_tmp9_)) {
				ValaExpression* _tmp10_;
				ValaExpression* _tmp11_;
				ValaExpression* _tmp12_;
				ValaExpression* _tmp13_;
				_tmp10_ = vala_member_access_get_inner (inner);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_element_access_get_container (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
				_tmp13_ = _tmp12_;
				inner = VALA_IS_MEMBER_ACCESS (_tmp13_) ? ((ValaMemberAccess*) _tmp13_) : NULL;
			} else {
				inner = NULL;
			}
		}
	}
}


static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}


static void
vala_assignment_real_emit (ValaCodeNode* base,
                           ValaCodeGenerator* codegen)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaPointerIndirection* _tmp8_;
	ValaMemberAccess* _tmp9_;
	ValaExpression* _tmp137_;
	ValaExpression* _tmp138_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (VALA_IS_ELEMENT_ACCESS (_tmp4_) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (VALA_IS_POINTER_INDIRECTION (_tmp7_) ? ((ValaPointerIndirection*) _tmp7_) : NULL);
	pi = _tmp8_;
	_tmp9_ = ma;
	if (_tmp9_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaLocalVariable* _tmp13_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaParameter* _tmp17_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaField* _tmp21_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaProperty* _tmp25_;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		ValaField* _tmp28_;
		gboolean instance = FALSE;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
		ValaAssignmentOperator _tmp41_;
		gboolean _tmp121_ = FALSE;
		gboolean _tmp122_ = FALSE;
		gboolean _tmp123_;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp12_) ? ((ValaLocalVariable*) _tmp12_) : NULL);
		local = _tmp13_;
		_tmp14_ = ma;
		_tmp15_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp16_) ? ((ValaParameter*) _tmp16_) : NULL);
		param = _tmp17_;
		_tmp18_ = ma;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (VALA_IS_FIELD (_tmp20_) ? ((ValaField*) _tmp20_) : NULL);
		field = _tmp21_;
		_tmp22_ = ma;
		_tmp23_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _vala_code_node_ref0 (VALA_IS_PROPERTY (_tmp24_) ? ((ValaProperty*) _tmp24_) : NULL);
		property = _tmp25_;
		_tmp28_ = field;
		if (_tmp28_ != NULL) {
			ValaField* _tmp29_;
			ValaMemberBinding _tmp30_;
			ValaMemberBinding _tmp31_;
			_tmp29_ = field;
			_tmp30_ = vala_field_get_binding (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp27_ = _tmp31_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp32_ = FALSE;
			ValaProperty* _tmp33_;
			_tmp33_ = property;
			if (_tmp33_ != NULL) {
				ValaProperty* _tmp34_;
				ValaMemberBinding _tmp35_;
				ValaMemberBinding _tmp36_;
				_tmp34_ = property;
				_tmp35_ = vala_property_get_binding (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp32_ = _tmp36_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp32_ = FALSE;
			}
			_tmp26_ = _tmp32_;
		}
		instance = _tmp26_;
		_tmp41_ = self->priv->_operator;
		if (_tmp41_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp42_ = FALSE;
			gboolean _tmp43_ = FALSE;
			ValaLocalVariable* _tmp44_;
			_tmp44_ = local;
			if (_tmp44_ != NULL) {
				_tmp43_ = TRUE;
			} else {
				ValaParameter* _tmp45_;
				_tmp45_ = param;
				_tmp43_ = _tmp45_ != NULL;
			}
			if (_tmp43_) {
				_tmp42_ = TRUE;
			} else {
				ValaField* _tmp46_;
				_tmp46_ = field;
				_tmp42_ = _tmp46_ != NULL;
			}
			_tmp40_ = _tmp42_;
		} else {
			_tmp40_ = FALSE;
		}
		if (_tmp40_) {
			_tmp39_ = !vala_assignment_is_array_add (self);
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			ValaField* _tmp47_;
			_tmp47_ = field;
			_tmp38_ = !VALA_IS_ARRAY_LENGTH_FIELD (_tmp47_);
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			gboolean _tmp48_ = FALSE;
			ValaExpression* _tmp49_;
			ValaExpression* _tmp50_;
			ValaDataType* _tmp51_;
			ValaDataType* _tmp52_;
			_tmp49_ = vala_assignment_get_left (self);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_expression_get_value_type (_tmp50_);
			_tmp52_ = _tmp51_;
			if (vala_data_type_is_real_non_null_struct_type (_tmp52_)) {
				ValaExpression* _tmp53_;
				ValaExpression* _tmp54_;
				_tmp53_ = vala_assignment_get_right (self);
				_tmp54_ = _tmp53_;
				_tmp48_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp54_);
			} else {
				_tmp48_ = FALSE;
			}
			_tmp37_ = !_tmp48_;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			gboolean _tmp55_ = FALSE;
			gboolean _tmp56_;
			ValaExpression* _tmp63_;
			ValaExpression* _tmp64_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaTargetValue* _tmp67_;
			ValaTargetValue* _tmp68_;
			ValaTargetValue* _tmp69_;
			ValaLocalVariable* _tmp70_;
			ValaCodeNode* _tmp96_;
			ValaCodeNode* _tmp97_;
			_tmp56_ = instance;
			if (_tmp56_) {
				ValaMemberAccess* _tmp57_;
				ValaExpression* _tmp58_;
				ValaExpression* _tmp59_;
				_tmp57_ = ma;
				_tmp58_ = vala_member_access_get_inner (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp55_ = _tmp59_ != NULL;
			} else {
				_tmp55_ = FALSE;
			}
			if (_tmp55_) {
				ValaMemberAccess* _tmp60_;
				ValaExpression* _tmp61_;
				ValaExpression* _tmp62_;
				_tmp60_ = ma;
				_tmp61_ = vala_member_access_get_inner (_tmp60_);
				_tmp62_ = _tmp61_;
				vala_code_node_emit ((ValaCodeNode*) _tmp62_, codegen);
			}
			_tmp63_ = vala_assignment_get_right (self);
			_tmp64_ = _tmp63_;
			vala_code_node_emit ((ValaCodeNode*) _tmp64_, codegen);
			_tmp65_ = vala_assignment_get_right (self);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_target_value (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = _vala_target_value_ref0 (_tmp68_);
			new_value = _tmp69_;
			_tmp70_ = local;
			if (_tmp70_ != NULL) {
				ValaLocalVariable* _tmp71_;
				ValaTargetValue* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaSourceReference* _tmp74_;
				_tmp71_ = local;
				_tmp72_ = new_value;
				_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp74_ = _tmp73_;
				vala_code_generator_store_local (codegen, _tmp71_, _tmp72_, FALSE, _tmp74_);
			} else {
				ValaParameter* _tmp75_;
				_tmp75_ = param;
				if (_tmp75_ != NULL) {
					ValaParameter* _tmp76_;
					ValaTargetValue* _tmp77_;
					ValaSourceReference* _tmp78_;
					ValaSourceReference* _tmp79_;
					_tmp76_ = param;
					_tmp77_ = new_value;
					_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp79_ = _tmp78_;
					vala_code_generator_store_parameter (codegen, _tmp76_, _tmp77_, FALSE, _tmp79_);
				} else {
					ValaField* _tmp80_;
					_tmp80_ = field;
					if (_tmp80_ != NULL) {
						ValaTargetValue* _tmp81_ = NULL;
						gboolean _tmp82_ = FALSE;
						gboolean _tmp83_;
						ValaField* _tmp92_;
						ValaTargetValue* _tmp93_;
						ValaSourceReference* _tmp94_;
						ValaSourceReference* _tmp95_;
						_tmp83_ = instance;
						if (_tmp83_) {
							ValaMemberAccess* _tmp84_;
							ValaExpression* _tmp85_;
							ValaExpression* _tmp86_;
							_tmp84_ = ma;
							_tmp85_ = vala_member_access_get_inner (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp82_ = _tmp86_ != NULL;
						} else {
							_tmp82_ = FALSE;
						}
						if (_tmp82_) {
							ValaMemberAccess* _tmp87_;
							ValaExpression* _tmp88_;
							ValaExpression* _tmp89_;
							ValaTargetValue* _tmp90_;
							ValaTargetValue* _tmp91_;
							_tmp87_ = ma;
							_tmp88_ = vala_member_access_get_inner (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = vala_expression_get_target_value (_tmp89_);
							_tmp91_ = _tmp90_;
							_tmp81_ = _tmp91_;
						} else {
							_tmp81_ = NULL;
						}
						_tmp92_ = field;
						_tmp93_ = new_value;
						_tmp94_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp95_ = _tmp94_;
						vala_code_generator_store_field (codegen, _tmp92_, _tmp81_, _tmp93_, _tmp95_);
					}
				}
			}
			_tmp96_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp97_ = _tmp96_;
			if (!VALA_IS_EXPRESSION_STATEMENT (_tmp97_)) {
				ValaLocalVariable* _tmp98_;
				_tmp98_ = local;
				if (_tmp98_ != NULL) {
					ValaLocalVariable* _tmp99_;
					ValaTargetValue* _tmp100_;
					ValaTargetValue* _tmp101_;
					_tmp99_ = local;
					_tmp100_ = vala_code_generator_load_local (codegen, _tmp99_, NULL);
					_tmp101_ = _tmp100_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp101_);
					_vala_target_value_unref0 (_tmp101_);
				} else {
					ValaParameter* _tmp102_;
					_tmp102_ = param;
					if (_tmp102_ != NULL) {
						ValaParameter* _tmp103_;
						ValaTargetValue* _tmp104_;
						ValaTargetValue* _tmp105_;
						_tmp103_ = param;
						_tmp104_ = vala_code_generator_load_parameter (codegen, _tmp103_, NULL);
						_tmp105_ = _tmp104_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp105_);
						_vala_target_value_unref0 (_tmp105_);
					} else {
						ValaField* _tmp106_;
						_tmp106_ = field;
						if (_tmp106_ != NULL) {
							ValaTargetValue* _tmp107_ = NULL;
							gboolean _tmp108_ = FALSE;
							gboolean _tmp109_;
							ValaField* _tmp118_;
							ValaTargetValue* _tmp119_;
							ValaTargetValue* _tmp120_;
							_tmp109_ = instance;
							if (_tmp109_) {
								ValaMemberAccess* _tmp110_;
								ValaExpression* _tmp111_;
								ValaExpression* _tmp112_;
								_tmp110_ = ma;
								_tmp111_ = vala_member_access_get_inner (_tmp110_);
								_tmp112_ = _tmp111_;
								_tmp108_ = _tmp112_ != NULL;
							} else {
								_tmp108_ = FALSE;
							}
							if (_tmp108_) {
								ValaMemberAccess* _tmp113_;
								ValaExpression* _tmp114_;
								ValaExpression* _tmp115_;
								ValaTargetValue* _tmp116_;
								ValaTargetValue* _tmp117_;
								_tmp113_ = ma;
								_tmp114_ = vala_member_access_get_inner (_tmp113_);
								_tmp115_ = _tmp114_;
								_tmp116_ = vala_expression_get_target_value (_tmp115_);
								_tmp117_ = _tmp116_;
								_tmp107_ = _tmp117_;
							} else {
								_tmp107_ = NULL;
							}
							_tmp118_ = field;
							_tmp119_ = vala_code_generator_load_field (codegen, _tmp118_, _tmp107_, NULL);
							_tmp120_ = _tmp119_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp120_);
							_vala_target_value_unref0 (_tmp120_);
						}
					}
				}
			}
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			_vala_code_node_unref0 (property);
			_vala_code_node_unref0 (field);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (pi);
			_vala_code_node_unref0 (ea);
			_vala_code_node_unref0 (ma);
			return;
		}
		_tmp123_ = instance;
		if (_tmp123_) {
			ValaMemberAccess* _tmp124_;
			ValaExpression* _tmp125_;
			ValaExpression* _tmp126_;
			_tmp124_ = ma;
			_tmp125_ = vala_member_access_get_inner (_tmp124_);
			_tmp126_ = _tmp125_;
			_tmp122_ = _tmp126_ != NULL;
		} else {
			_tmp122_ = FALSE;
		}
		if (_tmp122_) {
			ValaProperty* _tmp127_;
			_tmp127_ = property;
			_tmp121_ = _tmp127_ != NULL;
		} else {
			_tmp121_ = FALSE;
		}
		if (_tmp121_) {
			ValaMemberAccess* _tmp128_;
			ValaExpression* _tmp129_;
			ValaExpression* _tmp130_;
			_tmp128_ = ma;
			_tmp129_ = vala_member_access_get_inner (_tmp128_);
			_tmp130_ = _tmp129_;
			vala_code_node_emit ((ValaCodeNode*) _tmp130_, codegen);
		} else {
			ValaProperty* _tmp131_;
			_tmp131_ = property;
			if (_tmp131_ == NULL) {
				ValaMemberAccess* _tmp132_;
				_tmp132_ = ma;
				vala_code_node_emit ((ValaCodeNode*) _tmp132_, codegen);
			}
		}
		_vala_code_node_unref0 (property);
		_vala_code_node_unref0 (field);
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (local);
	} else {
		ValaElementAccess* _tmp133_;
		_tmp133_ = ea;
		if (_tmp133_ != NULL) {
			ValaElementAccess* _tmp134_;
			_tmp134_ = ea;
			vala_code_node_emit ((ValaCodeNode*) _tmp134_, codegen);
		} else {
			ValaPointerIndirection* _tmp135_;
			_tmp135_ = pi;
			if (_tmp135_ != NULL) {
				ValaPointerIndirection* _tmp136_;
				_tmp136_ = pi;
				vala_code_node_emit ((ValaCodeNode*) _tmp136_, codegen);
			}
		}
	}
	_tmp137_ = vala_assignment_get_right (self);
	_tmp138_ = _tmp137_;
	vala_code_node_emit ((ValaCodeNode*) _tmp138_, codegen);
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
	_vala_code_node_unref0 (pi);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}


static void
vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaParameter* _tmp13_;
	ValaLocalVariable* _tmp14_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_get_symbol_reference (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp7_) ? ((ValaLocalVariable*) _tmp7_) : NULL);
	local = _tmp8_;
	_tmp9_ = vala_assignment_get_left (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_symbol_reference (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp12_) ? ((ValaParameter*) _tmp12_) : NULL);
	param = _tmp13_;
	_tmp14_ = local;
	if (_tmp14_ != NULL) {
		ValaLocalVariable* _tmp15_;
		_tmp15_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp15_);
	} else {
		gboolean _tmp16_ = FALSE;
		ValaParameter* _tmp17_;
		_tmp17_ = param;
		if (_tmp17_ != NULL) {
			ValaParameter* _tmp18_;
			ValaParameterDirection _tmp19_;
			ValaParameterDirection _tmp20_;
			_tmp18_ = param;
			_tmp19_ = vala_parameter_get_direction (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp16_ = _tmp20_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			ValaParameter* _tmp21_;
			_tmp21_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp21_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}


static void
vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                         ValaCollection* collection)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaMemberAccess* _tmp7_;
	ValaExpression* _tmp16_;
	ValaExpression* _tmp17_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (VALA_IS_ELEMENT_ACCESS (_tmp4_) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp7_ = ma;
	if (_tmp7_ != NULL) {
		ValaMemberAccess* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp8_ = ma;
		_tmp9_ = vala_member_access_get_inner (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaMemberAccess* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		_tmp11_ = ma;
		_tmp12_ = vala_member_access_get_inner (_tmp11_);
		_tmp13_ = _tmp12_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
	} else {
		ValaElementAccess* _tmp14_;
		_tmp14_ = ea;
		if (_tmp14_ != NULL) {
			ValaElementAccess* _tmp15_;
			_tmp15_ = ea;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
		}
	}
	_tmp16_ = vala_assignment_get_right (self);
	_tmp17_ = _tmp16_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp17_, collection);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}


ValaExpression*
vala_assignment_get_left (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}


void
vala_assignment_set_left (ValaAssignment* self,
                          ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaAssignmentOperator
vala_assignment_get_operator (ValaAssignment* self)
{
	ValaAssignmentOperator result;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}


void
vala_assignment_set_operator (ValaAssignment* self,
                              ValaAssignmentOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}


ValaExpression*
vala_assignment_get_right (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}


void
vala_assignment_set_right (ValaAssignment* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static void
vala_assignment_class_init (ValaAssignmentClass * klass)
{
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_add_private (klass, sizeof (ValaAssignmentPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_assignment_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_used_variables;
}


static void
vala_assignment_instance_init (ValaAssignment * self)
{
	self->priv = VALA_ASSIGNMENT_GET_PRIVATE (self);
}


static void
vala_assignment_finalize (ValaCodeNode * obj)
{
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}


/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
GType
vala_assignment_get_type (void)
{
	static volatile gsize vala_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
		GType vala_assignment_type_id;
		vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
		g_once_init_leave (&vala_assignment_type_id__volatile, vala_assignment_type_id);
	}
	return vala_assignment_type_id__volatile;
}


GType
vala_assignment_operator_get_type (void)
{
	static volatile gsize vala_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
		g_once_init_leave (&vala_assignment_operator_type_id__volatile, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__volatile;
}



