/* valaccodecompiler.c generated by valac, the Vala compiler
 * generated from valaccodecompiler.vala, do not modify */

/* valaccodecompiler.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ValaParamSpecCCodeCompiler ValaParamSpecCCodeCompiler;

struct _ValaParamSpecCCodeCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_ccode_compiler_parent_class = NULL;

static void vala_ccode_compiler_finalize (ValaCCodeCompiler * obj);


ValaCCodeCompiler*
vala_ccode_compiler_construct (GType object_type)
{
	ValaCCodeCompiler* self = NULL;
	self = (ValaCCodeCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCCodeCompiler*
vala_ccode_compiler_new (void)
{
	return vala_ccode_compiler_construct (VALA_TYPE_CCODE_COMPILER);
}


/**
 * Compile generated C code to object code and optionally link object
 * files.
 *
 * @param context a code context
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


void
vala_ccode_compiler_compile (ValaCCodeCompiler* self,
                             ValaCodeContext* context,
                             const gchar* cc_command,
                             gchar** cc_options,
                             int cc_options_length1)
{
	gchar* pc = NULL;
	gchar* _tmp0_;
	gchar* pkgflags = NULL;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* cmdline = NULL;
	gchar* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	ValaList* source_files = NULL;
	ValaList* _tmp53_;
	ValaList* c_source_files = NULL;
	ValaList* _tmp76_;
	const gchar* _tmp94_;
	const gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gboolean _tmp109_;
	gboolean _tmp110_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = g_strdup (" gobject-2.0");
	pc = _tmp0_;
	{
		ValaList* _pkg_list = NULL;
		ValaList* _tmp1_;
		gint _pkg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _pkg_index = 0;
		_tmp1_ = vala_code_context_get_packages (context);
		_pkg_list = _tmp1_;
		_tmp2_ = _pkg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_pkg_size = _tmp4_;
		_pkg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gchar* pkg = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			const gchar* _tmp10_;
			_pkg_index = _pkg_index + 1;
			_tmp5_ = _pkg_index;
			_tmp6_ = _pkg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _pkg_list;
			_tmp8_ = _pkg_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			pkg = (gchar*) _tmp9_;
			_tmp10_ = pkg;
			if (vala_code_context_pkg_config_exists (context, _tmp10_)) {
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp11_ = pc;
				_tmp12_ = pkg;
				_tmp13_ = g_strconcat (" ", _tmp12_, NULL);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strconcat (_tmp11_, _tmp14_, NULL);
				_g_free0 (pc);
				pc = _tmp15_;
				_g_free0 (_tmp14_);
			}
			_g_free0 (pkg);
		}
		_vala_iterable_unref0 (_pkg_list);
	}
	_tmp16_ = pc;
	_tmp17_ = vala_code_context_pkg_config_compile_flags (context, _tmp16_);
	pkgflags = _tmp17_;
	_tmp18_ = pkgflags;
	if (_tmp18_ == NULL) {
		_g_free0 (pkgflags);
		_g_free0 (pc);
		return;
	}
	if (cc_command == NULL) {
		cc_command = "cc";
	}
	_tmp19_ = g_strdup (cc_command);
	cmdline = _tmp19_;
	_tmp20_ = vala_code_context_get_debug (context);
	_tmp21_ = _tmp20_;
	if (_tmp21_) {
		const gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp22_ = cmdline;
		_tmp23_ = g_strconcat (_tmp22_, " -g", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp23_;
	}
	_tmp24_ = vala_code_context_get_compile_only (context);
	_tmp25_ = _tmp24_;
	if (_tmp25_) {
		const gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp26_ = cmdline;
		_tmp27_ = g_strconcat (_tmp26_, " -c", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp27_;
	} else {
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp28_ = vala_code_context_get_output (context);
		_tmp29_ = _tmp28_;
		if (_tmp29_ != NULL) {
			gchar* output = NULL;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			gboolean _tmp33_ = FALSE;
			gboolean _tmp34_ = FALSE;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			_tmp30_ = vala_code_context_get_output (context);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strdup (_tmp31_);
			output = _tmp32_;
			_tmp35_ = vala_code_context_get_directory (context);
			_tmp36_ = _tmp35_;
			if (_tmp36_ != NULL) {
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				_tmp37_ = vala_code_context_get_directory (context);
				_tmp38_ = _tmp37_;
				_tmp34_ = g_strcmp0 (_tmp38_, "") != 0;
			} else {
				_tmp34_ = FALSE;
			}
			if (_tmp34_) {
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				_tmp39_ = vala_code_context_get_output (context);
				_tmp40_ = _tmp39_;
				_tmp33_ = !g_path_is_absolute (_tmp40_);
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				const gchar* _tmp44_;
				gchar* _tmp45_;
				_tmp41_ = vala_code_context_get_directory (context);
				_tmp42_ = _tmp41_;
				_tmp43_ = vala_code_context_get_output (context);
				_tmp44_ = _tmp43_;
				_tmp45_ = g_strdup_printf ("%s%c%s", _tmp42_, (gint) G_DIR_SEPARATOR, _tmp44_);
				_g_free0 (output);
				output = _tmp45_;
			}
			_tmp46_ = cmdline;
			_tmp47_ = output;
			_tmp48_ = g_shell_quote (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = g_strconcat (" -o ", _tmp49_, NULL);
			_tmp51_ = _tmp50_;
			_tmp52_ = g_strconcat (_tmp46_, _tmp51_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp52_;
			_g_free0 (_tmp51_);
			_g_free0 (_tmp49_);
			_g_free0 (output);
		}
	}
	_tmp53_ = vala_code_context_get_source_files (context);
	source_files = _tmp53_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp54_;
		ValaList* _tmp55_;
		gint _file_size = 0;
		ValaList* _tmp56_;
		gint _tmp57_;
		gint _tmp58_;
		gint _file_index = 0;
		_tmp54_ = source_files;
		_tmp55_ = _vala_iterable_ref0 (_tmp54_);
		_file_list = _tmp55_;
		_tmp56_ = _file_list;
		_tmp57_ = vala_collection_get_size ((ValaCollection*) _tmp56_);
		_tmp58_ = _tmp57_;
		_file_size = _tmp58_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp59_;
			gint _tmp60_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp61_;
			gint _tmp62_;
			gpointer _tmp63_;
			ValaSourceFile* _tmp64_;
			ValaSourceFileType _tmp65_;
			ValaSourceFileType _tmp66_;
			_file_index = _file_index + 1;
			_tmp59_ = _file_index;
			_tmp60_ = _file_size;
			if (!(_tmp59_ < _tmp60_)) {
				break;
			}
			_tmp61_ = _file_list;
			_tmp62_ = _file_index;
			_tmp63_ = vala_list_get (_tmp61_, _tmp62_);
			file = (ValaSourceFile*) _tmp63_;
			_tmp64_ = file;
			_tmp65_ = vala_source_file_get_file_type (_tmp64_);
			_tmp66_ = _tmp65_;
			if (_tmp66_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				const gchar* _tmp67_;
				ValaSourceFile* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				gchar* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				_tmp67_ = cmdline;
				_tmp68_ = file;
				_tmp69_ = vala_source_file_get_csource_filename (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = g_shell_quote (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = g_strconcat (" ", _tmp72_, NULL);
				_tmp74_ = _tmp73_;
				_tmp75_ = g_strconcat (_tmp67_, _tmp74_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp75_;
				_g_free0 (_tmp74_);
				_g_free0 (_tmp72_);
				_g_free0 (_tmp70_);
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp76_ = vala_code_context_get_c_source_files (context);
	c_source_files = _tmp76_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp77_;
		ValaList* _tmp78_;
		gint _file_size = 0;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _file_index = 0;
		_tmp77_ = c_source_files;
		_tmp78_ = _vala_iterable_ref0 (_tmp77_);
		_file_list = _tmp78_;
		_tmp79_ = _file_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_file_size = _tmp81_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			gchar* file = NULL;
			ValaList* _tmp84_;
			gint _tmp85_;
			gpointer _tmp86_;
			const gchar* _tmp87_;
			const gchar* _tmp88_;
			gchar* _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			gchar* _tmp93_;
			_file_index = _file_index + 1;
			_tmp82_ = _file_index;
			_tmp83_ = _file_size;
			if (!(_tmp82_ < _tmp83_)) {
				break;
			}
			_tmp84_ = _file_list;
			_tmp85_ = _file_index;
			_tmp86_ = vala_list_get (_tmp84_, _tmp85_);
			file = (gchar*) _tmp86_;
			_tmp87_ = cmdline;
			_tmp88_ = file;
			_tmp89_ = g_shell_quote (_tmp88_);
			_tmp90_ = _tmp89_;
			_tmp91_ = g_strconcat (" ", _tmp90_, NULL);
			_tmp92_ = _tmp91_;
			_tmp93_ = g_strconcat (_tmp87_, _tmp92_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp93_;
			_g_free0 (_tmp92_);
			_g_free0 (_tmp90_);
			_g_free0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp94_ = cmdline;
	_tmp95_ = pkgflags;
	_tmp96_ = string_strip (_tmp95_);
	_tmp97_ = _tmp96_;
	_tmp98_ = g_strconcat (" ", _tmp97_, NULL);
	_tmp99_ = _tmp98_;
	_tmp100_ = g_strconcat (_tmp94_, _tmp99_, NULL);
	_g_free0 (cmdline);
	cmdline = _tmp100_;
	_g_free0 (_tmp99_);
	_g_free0 (_tmp97_);
	{
		gchar** cc_option_collection = NULL;
		gint cc_option_collection_length1 = 0;
		gint _cc_option_collection_size_ = 0;
		gint cc_option_it = 0;
		cc_option_collection = cc_options;
		cc_option_collection_length1 = cc_options_length1;
		for (cc_option_it = 0; cc_option_it < cc_option_collection_length1; cc_option_it = cc_option_it + 1) {
			gchar* _tmp101_;
			gchar* cc_option = NULL;
			_tmp101_ = g_strdup (cc_option_collection[cc_option_it]);
			cc_option = _tmp101_;
			{
				const gchar* _tmp102_;
				const gchar* _tmp103_;
				gchar* _tmp104_;
				gchar* _tmp105_;
				gchar* _tmp106_;
				gchar* _tmp107_;
				gchar* _tmp108_;
				_tmp102_ = cmdline;
				_tmp103_ = cc_option;
				_tmp104_ = g_shell_quote (_tmp103_);
				_tmp105_ = _tmp104_;
				_tmp106_ = g_strconcat (" ", _tmp105_, NULL);
				_tmp107_ = _tmp106_;
				_tmp108_ = g_strconcat (_tmp102_, _tmp107_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp108_;
				_g_free0 (_tmp107_);
				_g_free0 (_tmp105_);
				_g_free0 (cc_option);
			}
		}
	}
	_tmp109_ = vala_code_context_get_verbose_mode (context);
	_tmp110_ = _tmp109_;
	if (_tmp110_) {
		FILE* _tmp111_;
		const gchar* _tmp112_;
		_tmp111_ = stdout;
		_tmp112_ = cmdline;
		fprintf (_tmp111_, "%s\n", _tmp112_);
	}
	{
		gint exit_status = 0;
		const gchar* _tmp113_;
		gint _tmp114_ = 0;
		gint _tmp115_;
		_tmp113_ = cmdline;
		g_spawn_command_line_sync (_tmp113_, NULL, NULL, &_tmp114_, &_inner_error0_);
		exit_status = _tmp114_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch3_g_spawn_error;
			}
			_vala_iterable_unref0 (c_source_files);
			_vala_iterable_unref0 (source_files);
			_g_free0 (cmdline);
			_g_free0 (pkgflags);
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp115_ = exit_status;
		if (_tmp115_ != 0) {
			gint _tmp116_;
			gchar* _tmp117_;
			gchar* _tmp118_;
			_tmp116_ = exit_status;
			_tmp117_ = g_strdup_printf ("cc exited with status %d", _tmp116_);
			_tmp118_ = _tmp117_;
			vala_report_error (NULL, _tmp118_);
			_g_free0 (_tmp118_);
		}
	}
	goto __finally3;
	__catch3_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp119_;
		const gchar* _tmp120_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp119_ = e;
		_tmp120_ = _tmp119_->message;
		vala_report_error (NULL, _tmp120_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_vala_iterable_unref0 (c_source_files);
		_vala_iterable_unref0 (source_files);
		_g_free0 (cmdline);
		_g_free0 (pkgflags);
		_g_free0 (pc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp121_;
		ValaList* _tmp122_;
		gint _file_size = 0;
		ValaList* _tmp123_;
		gint _tmp124_;
		gint _tmp125_;
		gint _file_index = 0;
		_tmp121_ = source_files;
		_tmp122_ = _vala_iterable_ref0 (_tmp121_);
		_file_list = _tmp122_;
		_tmp123_ = _file_list;
		_tmp124_ = vala_collection_get_size ((ValaCollection*) _tmp123_);
		_tmp125_ = _tmp124_;
		_file_size = _tmp125_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp126_;
			gint _tmp127_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp128_;
			gint _tmp129_;
			gpointer _tmp130_;
			ValaSourceFile* _tmp131_;
			ValaSourceFileType _tmp132_;
			ValaSourceFileType _tmp133_;
			_file_index = _file_index + 1;
			_tmp126_ = _file_index;
			_tmp127_ = _file_size;
			if (!(_tmp126_ < _tmp127_)) {
				break;
			}
			_tmp128_ = _file_list;
			_tmp129_ = _file_index;
			_tmp130_ = vala_list_get (_tmp128_, _tmp129_);
			file = (ValaSourceFile*) _tmp130_;
			_tmp131_ = file;
			_tmp132_ = vala_source_file_get_file_type (_tmp131_);
			_tmp133_ = _tmp132_;
			if (_tmp133_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				gboolean _tmp134_;
				gboolean _tmp135_;
				_tmp134_ = vala_code_context_get_save_csources (context);
				_tmp135_ = _tmp134_;
				if (!_tmp135_) {
					ValaSourceFile* _tmp136_;
					gchar* _tmp137_;
					gchar* _tmp138_;
					_tmp136_ = file;
					_tmp137_ = vala_source_file_get_csource_filename (_tmp136_);
					_tmp138_ = _tmp137_;
					g_unlink (_tmp138_);
					_g_free0 (_tmp138_);
				}
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_vala_iterable_unref0 (c_source_files);
	_vala_iterable_unref0 (source_files);
	_g_free0 (cmdline);
	_g_free0 (pkgflags);
	_g_free0 (pc);
}


static void
vala_value_ccode_compiler_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_ccode_compiler_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_ccode_compiler_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_ccode_compiler_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_ccode_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_ccode_compiler_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_ccode_compiler_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCCodeCompiler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_ccode_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_ccode_compiler_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	ValaCCodeCompiler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_ccode_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
vala_param_spec_ccode_compiler (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ValaParamSpecCCodeCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CCODE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
vala_value_get_ccode_compiler (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void
vala_value_set_ccode_compiler (GValue* value,
                               gpointer v_object)
{
	ValaCCodeCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_ccode_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}


void
vala_value_take_ccode_compiler (GValue* value,
                                gpointer v_object)
{
	ValaCCodeCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}


static void
vala_ccode_compiler_class_init (ValaCCodeCompilerClass * klass)
{
	vala_ccode_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeCompilerClass *) klass)->finalize = vala_ccode_compiler_finalize;
}


static void
vala_ccode_compiler_instance_init (ValaCCodeCompiler * self)
{
	self->ref_count = 1;
}


static void
vala_ccode_compiler_finalize (ValaCCodeCompiler * obj)
{
	ValaCCodeCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_COMPILER, ValaCCodeCompiler);
	g_signal_handlers_destroy (self);
}


/**
 * Interface to the C compiler.
 */
GType
vala_ccode_compiler_get_type (void)
{
	static volatile gsize vala_ccode_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_ccode_compiler_init, vala_value_ccode_compiler_free_value, vala_value_ccode_compiler_copy_value, vala_value_ccode_compiler_peek_pointer, "p", vala_value_ccode_compiler_collect_value, "p", vala_value_ccode_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCompiler), 0, (GInstanceInitFunc) vala_ccode_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_ccode_compiler_type_id;
		vala_ccode_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCCodeCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_ccode_compiler_type_id__volatile, vala_ccode_compiler_type_id);
	}
	return vala_ccode_compiler_type_id__volatile;
}


gpointer
vala_ccode_compiler_ref (gpointer instance)
{
	ValaCCodeCompiler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
vala_ccode_compiler_unref (gpointer instance)
{
	ValaCCodeCompiler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CCODE_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



