/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};


static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                                      ValaEnum* en);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gsize _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		const gchar* res = NULL;
		gsize _tmp27_;
		void* _tmp28_;
		void* ptr = NULL;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		void* _tmp31_;
		const gchar* _tmp44_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = len;
		_tmp24_ = strlen ((const gchar*) separator);
		_tmp25_ = _tmp24_;
		_tmp26_ = i;
		len = _tmp23_ + (_tmp25_ * (_tmp26_ - 1));
		_tmp27_ = len;
		_tmp28_ = g_malloc (_tmp27_);
		res = _tmp28_;
		_tmp29_ = res;
		_tmp30_ = str_array[0];
		_tmp31_ = g_stpcpy ((void*) _tmp29_, (const gchar*) _tmp30_);
		ptr = _tmp31_;
		{
			gboolean _tmp32_ = FALSE;
			i = 1;
			_tmp32_ = TRUE;
			while (TRUE) {
				gint _tmp34_;
				void* _tmp35_;
				void* _tmp36_;
				const gchar* _tmp37_ = NULL;
				gint _tmp38_;
				const gchar* _tmp39_;
				void* _tmp42_;
				void* _tmp43_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = i;
				if (!(_tmp34_ < str_array_length1)) {
					break;
				}
				_tmp35_ = ptr;
				_tmp36_ = g_stpcpy (_tmp35_, (const gchar*) separator);
				ptr = _tmp36_;
				_tmp38_ = i;
				_tmp39_ = str_array[_tmp38_];
				if (_tmp39_ != NULL) {
					gint _tmp40_;
					const gchar* _tmp41_;
					_tmp40_ = i;
					_tmp41_ = str_array[_tmp40_];
					_tmp37_ = (const gchar*) _tmp41_;
				} else {
					_tmp37_ = "";
				}
				_tmp42_ = ptr;
				_tmp43_ = g_stpcpy (_tmp42_, _tmp37_);
				ptr = _tmp43_;
			}
		}
		_tmp44_ = res;
		res = NULL;
		result = (gchar*) _tmp44_;
		return result;
	} else {
		gchar* _tmp45_;
		_tmp45_ = g_strdup ("");
		result = _tmp45_;
		return result;
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}


static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp130_;
	GEqualFunc _tmp131_;
	GEqualFunc _tmp132_;
	ValaHashMap* _tmp133_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp134_;
	ValaHashMap* _tmp135_;
	gboolean _tmp136_ = FALSE;
	ValaMethod* _tmp137_;
	gboolean _tmp256_ = FALSE;
	ValaMethod* _tmp257_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp428_;
	ValaCCodeExpression* _tmp429_;
	ValaMethod* _tmp430_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp454_ = FALSE;
	ValaMethod* _tmp455_;
	gboolean _tmp611_ = FALSE;
	ValaMethod* _tmp612_;
	ValaMethod* _tmp675_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp874_;
	ValaIterator* _tmp875_;
	ValaIterator* _tmp1269_;
	gboolean _tmp1279_ = FALSE;
	gboolean _tmp1280_ = FALSE;
	ValaMethod* _tmp1281_;
	gboolean _tmp1406_ = FALSE;
	ValaDelegate* _tmp1407_;
	gboolean _tmp1504_ = FALSE;
	ValaMethod* _tmp1505_;
	gboolean _tmp1521_;
	gboolean _tmp1522_;
	gboolean _tmp1537_;
	ValaDataType* _tmp1562_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1586_;
	ValaDataType* _tmp1587_;
	ValaDataType* _tmp1588_;
	gboolean _tmp1589_;
	gboolean _tmp1590_ = FALSE;
	ValaDataType* _tmp1591_;
	ValaCCodeFunctionCall* _tmp1620_;
	ValaCCodeFunctionCall* _tmp1621_;
	ValaCCodeExpression* out_param_ref = NULL;
	gboolean _tmp1622_;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1637_;
	ValaCCodeFunctionCall* _tmp1638_;
	ValaCCodeFunctionCall* _tmp1662_;
	gboolean _tmp1686_;
	gboolean _tmp1687_;
	gboolean _tmp1713_;
	gboolean _tmp1714_;
	gboolean _tmp1744_;
	gboolean _tmp1750_ = FALSE;
	gboolean _tmp1751_ = FALSE;
	ValaMethod* _tmp1752_;
	gboolean _tmp1790_ = FALSE;
	gboolean _tmp1791_ = FALSE;
	gboolean _tmp1792_ = FALSE;
	gboolean _tmp1793_ = FALSE;
	gboolean _tmp1794_ = FALSE;
	ValaMethod* _tmp1795_;
	gboolean _tmp1812_ = FALSE;
	gboolean _tmp1813_ = FALSE;
	ValaMethod* _tmp1814_;
	ValaMethod* _tmp1833_;
	gboolean _tmp1950_ = FALSE;
	ValaCodeNode* _tmp1951_;
	ValaCodeNode* _tmp1952_;
	ValaList* _tmp2028_;
	ValaIterator* _tmp2029_;
	gboolean _tmp2181_ = FALSE;
	gboolean _tmp2182_ = FALSE;
	ValaMethod* _tmp2183_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_tostring_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_;
			gboolean _tmp57_;
			_tmp56_ = vala_method_call_get_is_constructv_chainup (expr);
			_tmp57_ = _tmp56_;
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp58_;
				ValaMethod* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				ValaCCodeIdentifier* _tmp62_;
				ValaCCodeIdentifier* _tmp63_;
				_tmp58_ = ccall;
				_tmp59_ = m;
				_tmp60_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_ccode_identifier_new (_tmp61_);
				_tmp63_ = _tmp62_;
				vala_ccode_function_call_set_call (_tmp58_, (ValaCCodeExpression*) _tmp63_);
				_vala_ccode_node_unref0 (_tmp63_);
				_g_free0 (_tmp61_);
			}
		}
	} else {
		ValaDataType* _tmp64_;
		_tmp64_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp65_;
			ValaSignalType* _tmp66_;
			gboolean _tmp67_ = FALSE;
			gboolean _tmp68_ = FALSE;
			ValaMemberAccess* _tmp69_;
			_tmp65_ = itype;
			_tmp66_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp66_;
			_tmp69_ = ma;
			if (_tmp69_ != NULL) {
				ValaMemberAccess* _tmp70_;
				ValaExpression* _tmp71_;
				ValaExpression* _tmp72_;
				_tmp70_ = ma;
				_tmp71_ = vala_member_access_get_inner (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp68_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp68_ = FALSE;
			}
			if (_tmp68_) {
				ValaSignalType* _tmp73_;
				ValaSignal* _tmp74_;
				ValaSignal* _tmp75_;
				gboolean _tmp76_;
				gboolean _tmp77_;
				_tmp73_ = sig_type;
				_tmp74_ = vala_signal_type_get_signal_symbol (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_signal_get_is_virtual (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp67_ = _tmp77_;
			} else {
				_tmp67_ = FALSE;
			}
			if (_tmp67_) {
				ValaSignalType* _tmp78_;
				ValaSignal* _tmp79_;
				ValaSignal* _tmp80_;
				ValaMethod* _tmp81_;
				ValaMethod* _tmp82_;
				ValaMethod* _tmp83_;
				_tmp78_ = sig_type;
				_tmp79_ = vala_signal_type_get_signal_symbol (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = vala_signal_get_default_handler (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = _vala_code_node_ref0 (_tmp82_);
				_vala_code_node_unref0 (m);
				m = _tmp83_;
			} else {
				ValaExpression* _tmp84_;
				ValaExpression* _tmp85_;
				ValaCCodeExpression* _tmp86_;
				_tmp84_ = vala_method_call_get_call (expr);
				_tmp85_ = _tmp84_;
				_tmp86_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp85_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp87_;
			_tmp87_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp88_;
				ValaObjectTypeSymbol* _tmp89_;
				ValaObjectTypeSymbol* _tmp90_;
				ValaClass* _tmp91_;
				ValaClass* _tmp92_;
				ValaCreationMethod* _tmp93_;
				ValaCreationMethod* _tmp94_;
				ValaMethod* _tmp95_;
				ValaMethod* _tmp96_;
				ValaCCodeFile* _tmp97_;
				gchar* real_name = NULL;
				ValaMethod* _tmp98_;
				gchar* _tmp99_;
				gboolean _tmp100_;
				gboolean _tmp101_;
				const gchar* _tmp104_;
				ValaCCodeIdentifier* _tmp105_;
				ValaCCodeIdentifier* _tmp106_;
				ValaCCodeFunctionCall* _tmp107_;
				_tmp88_ = itype;
				_tmp89_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp90_ = _tmp89_;
				_tmp91_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp91_;
				_tmp92_ = cl;
				_tmp93_ = vala_class_get_default_construction_method (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = _vala_code_node_ref0 ((ValaMethod*) _tmp94_);
				_vala_code_node_unref0 (m);
				m = _tmp95_;
				_tmp96_ = m;
				_tmp97_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp96_, _tmp97_);
				_tmp98_ = m;
				_tmp99_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp98_);
				real_name = _tmp99_;
				_tmp100_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp101_ = _tmp100_;
				if (_tmp101_) {
					ValaMethod* _tmp102_;
					gchar* _tmp103_;
					_tmp102_ = m;
					_tmp103_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp103_;
				}
				_tmp104_ = real_name;
				_tmp105_ = vala_ccode_identifier_new (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp106_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp107_;
				_vala_ccode_node_unref0 (_tmp106_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp108_;
				_tmp108_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp109_;
					ValaTypeSymbol* _tmp110_;
					ValaTypeSymbol* _tmp111_;
					ValaStruct* _tmp112_;
					ValaStruct* _tmp113_;
					ValaMethod* _tmp114_;
					ValaMethod* _tmp115_;
					ValaMethod* _tmp116_;
					ValaMethod* _tmp117_;
					ValaCCodeFile* _tmp118_;
					ValaMethod* _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					ValaCCodeIdentifier* _tmp122_;
					ValaCCodeIdentifier* _tmp123_;
					ValaCCodeFunctionCall* _tmp124_;
					_tmp109_ = itype;
					_tmp110_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp111_ = _tmp110_;
					_tmp112_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp112_;
					_tmp113_ = st;
					_tmp114_ = vala_struct_get_default_construction_method (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = _vala_code_node_ref0 (_tmp115_);
					_vala_code_node_unref0 (m);
					m = _tmp116_;
					_tmp117_ = m;
					_tmp118_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp117_, _tmp118_);
					_tmp119_ = m;
					_tmp120_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = vala_ccode_identifier_new (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp123_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp124_;
					_vala_ccode_node_unref0 (_tmp123_);
					_g_free0 (_tmp121_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp125_;
					_tmp125_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp125_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp126_;
						ValaDelegate* _tmp127_;
						ValaDelegate* _tmp128_;
						ValaDelegate* _tmp129_;
						_tmp126_ = itype;
						_tmp127_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp128_ = _tmp127_;
						_tmp129_ = _vala_code_node_ref0 (_tmp128_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp129_;
					}
				}
			}
		}
	}
	_tmp130_ = g_direct_hash;
	_tmp131_ = g_direct_equal;
	_tmp132_ = g_direct_equal;
	_tmp133_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp130_, _tmp131_, _tmp132_);
	in_arg_map = _tmp133_;
	_tmp134_ = in_arg_map;
	_tmp135_ = _vala_map_ref0 (_tmp134_);
	out_arg_map = _tmp135_;
	_tmp137_ = m;
	if (_tmp137_ != NULL) {
		ValaMethod* _tmp138_;
		gboolean _tmp139_;
		gboolean _tmp140_;
		_tmp138_ = m;
		_tmp139_ = vala_method_get_coroutine (_tmp138_);
		_tmp140_ = _tmp139_;
		_tmp136_ = _tmp140_;
	} else {
		_tmp136_ = FALSE;
	}
	if (_tmp136_) {
		ValaMethod* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
		ValaCCodeIdentifier* _tmp144_;
		ValaCCodeIdentifier* _tmp145_;
		ValaCCodeFunctionCall* _tmp146_;
		ValaMethod* _tmp147_;
		gchar* _tmp148_;
		gchar* _tmp149_;
		ValaCCodeIdentifier* _tmp150_;
		ValaCCodeIdentifier* _tmp151_;
		ValaCCodeFunctionCall* _tmp152_;
		ValaMemberAccess* _tmp153_;
		ValaExpression* _tmp154_;
		ValaExpression* _tmp155_;
		gboolean _tmp206_ = FALSE;
		ValaMemberAccess* _tmp207_;
		const gchar* _tmp208_;
		const gchar* _tmp209_;
		_tmp141_ = m;
		_tmp142_ = vala_get_ccode_name ((ValaCodeNode*) _tmp141_);
		_tmp143_ = _tmp142_;
		_tmp144_ = vala_ccode_identifier_new (_tmp143_);
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp145_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp146_;
		_vala_ccode_node_unref0 (_tmp145_);
		_g_free0 (_tmp143_);
		_tmp147_ = m;
		_tmp148_ = vala_get_ccode_finish_name (_tmp147_);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_ccode_identifier_new (_tmp149_);
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp151_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp152_;
		_vala_ccode_node_unref0 (_tmp151_);
		_g_free0 (_tmp149_);
		_tmp153_ = ma;
		_tmp154_ = vala_member_access_get_inner (_tmp153_);
		_tmp155_ = _tmp154_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp155_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp156_;
			ValaMethod* _tmp157_;
			ValaMethod* _tmp158_;
			ValaCCodeExpression* _tmp191_;
			vcast = NULL;
			_tmp156_ = m;
			_tmp157_ = vala_method_get_base_method (_tmp156_);
			_tmp158_ = _tmp157_;
			if (_tmp158_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp159_;
				ValaMethod* _tmp160_;
				ValaMethod* _tmp161_;
				ValaSymbol* _tmp162_;
				ValaSymbol* _tmp163_;
				ValaClass* _tmp164_;
				gchar* _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				gchar* _tmp168_;
				ValaCCodeIdentifier* _tmp169_;
				ValaCCodeIdentifier* _tmp170_;
				ValaCCodeFunctionCall* _tmp171_;
				ValaCCodeExpression* _tmp172_;
				ValaClass* _tmp173_;
				ValaClass* _tmp174_;
				gchar* _tmp175_;
				gchar* _tmp176_;
				gchar* _tmp177_;
				gchar* _tmp178_;
				ValaCCodeIdentifier* _tmp179_;
				ValaCCodeIdentifier* _tmp180_;
				_tmp159_ = m;
				_tmp160_ = vala_method_get_base_method (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp161_);
				_tmp163_ = _tmp162_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, VALA_TYPE_CLASS, ValaClass);
				_tmp164_ = base_class;
				_tmp165_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp164_, NULL);
				_tmp166_ = _tmp165_;
				_tmp167_ = g_strdup_printf ("%s_CLASS", _tmp166_);
				_tmp168_ = _tmp167_;
				_tmp169_ = vala_ccode_identifier_new (_tmp168_);
				_tmp170_ = _tmp169_;
				_tmp171_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp170_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp171_;
				_vala_ccode_node_unref0 (_tmp170_);
				_g_free0 (_tmp168_);
				_g_free0 (_tmp166_);
				_tmp172_ = vcast;
				_tmp173_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp174_ = _tmp173_;
				_tmp175_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp174_, NULL);
				_tmp176_ = _tmp175_;
				_tmp177_ = g_strdup_printf ("%s_parent_class", _tmp176_);
				_tmp178_ = _tmp177_;
				_tmp179_ = vala_ccode_identifier_new (_tmp178_);
				_tmp180_ = _tmp179_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp172_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp180_);
				_vala_ccode_node_unref0 (_tmp180_);
				_g_free0 (_tmp178_);
				_g_free0 (_tmp176_);
			} else {
				ValaMethod* _tmp181_;
				ValaMethod* _tmp182_;
				ValaMethod* _tmp183_;
				_tmp181_ = m;
				_tmp182_ = vala_method_get_base_interface_method (_tmp181_);
				_tmp183_ = _tmp182_;
				if (_tmp183_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp184_;
					ValaMethod* _tmp185_;
					ValaMethod* _tmp186_;
					ValaSymbol* _tmp187_;
					ValaSymbol* _tmp188_;
					ValaInterface* _tmp189_;
					ValaCCodeExpression* _tmp190_;
					_tmp184_ = m;
					_tmp185_ = vala_method_get_base_interface_method (_tmp184_);
					_tmp186_ = _tmp185_;
					_tmp187_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp186_);
					_tmp188_ = _tmp187_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp188_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp189_ = base_iface;
					_tmp190_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp189_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp190_;
				}
			}
			_tmp191_ = vcast;
			if (_tmp191_ != NULL) {
				ValaCCodeFunctionCall* _tmp192_;
				ValaCCodeExpression* _tmp193_;
				ValaMethod* _tmp194_;
				gchar* _tmp195_;
				gchar* _tmp196_;
				ValaCCodeMemberAccess* _tmp197_;
				ValaCCodeMemberAccess* _tmp198_;
				ValaCCodeFunctionCall* _tmp199_;
				ValaCCodeExpression* _tmp200_;
				ValaMethod* _tmp201_;
				gchar* _tmp202_;
				gchar* _tmp203_;
				ValaCCodeMemberAccess* _tmp204_;
				ValaCCodeMemberAccess* _tmp205_;
				_tmp192_ = async_call;
				_tmp193_ = vcast;
				_tmp194_ = m;
				_tmp195_ = vala_get_ccode_vfunc_name (_tmp194_);
				_tmp196_ = _tmp195_;
				_tmp197_ = vala_ccode_member_access_new_pointer (_tmp193_, _tmp196_);
				_tmp198_ = _tmp197_;
				vala_ccode_function_call_set_call (_tmp192_, (ValaCCodeExpression*) _tmp198_);
				_vala_ccode_node_unref0 (_tmp198_);
				_g_free0 (_tmp196_);
				_tmp199_ = finish_call;
				_tmp200_ = vcast;
				_tmp201_ = m;
				_tmp202_ = vala_get_ccode_finish_vfunc_name (_tmp201_);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_ccode_member_access_new_pointer (_tmp200_, _tmp203_);
				_tmp205_ = _tmp204_;
				vala_ccode_function_call_set_call (_tmp199_, (ValaCCodeExpression*) _tmp205_);
				_vala_ccode_node_unref0 (_tmp205_);
				_g_free0 (_tmp203_);
			}
			_vala_ccode_node_unref0 (vcast);
		}
		_tmp207_ = ma;
		_tmp208_ = vala_member_access_get_member_name (_tmp207_);
		_tmp209_ = _tmp208_;
		if (g_strcmp0 (_tmp209_, "begin") == 0) {
			ValaMemberAccess* _tmp210_;
			ValaExpression* _tmp211_;
			ValaExpression* _tmp212_;
			ValaSymbol* _tmp213_;
			ValaSymbol* _tmp214_;
			ValaMemberAccess* _tmp215_;
			ValaSymbol* _tmp216_;
			ValaSymbol* _tmp217_;
			_tmp210_ = ma;
			_tmp211_ = vala_member_access_get_inner (_tmp210_);
			_tmp212_ = _tmp211_;
			_tmp213_ = vala_expression_get_symbol_reference (_tmp212_);
			_tmp214_ = _tmp213_;
			_tmp215_ = ma;
			_tmp216_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp215_);
			_tmp217_ = _tmp216_;
			_tmp206_ = _tmp214_ == _tmp217_;
		} else {
			_tmp206_ = FALSE;
		}
		if (_tmp206_) {
			ValaCCodeFunctionCall* _tmp218_;
			ValaCCodeFunctionCall* _tmp219_;
			ValaMethod* _tmp220_;
			ValaList* _tmp221_;
			_tmp218_ = async_call;
			_tmp219_ = _vala_ccode_node_ref0 (_tmp218_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp219_;
			_tmp220_ = m;
			_tmp221_ = vala_method_get_async_begin_parameters (_tmp220_);
			_vala_iterable_unref0 (params);
			params = _tmp221_;
		} else {
			gboolean _tmp222_ = FALSE;
			ValaMemberAccess* _tmp223_;
			const gchar* _tmp224_;
			const gchar* _tmp225_;
			_tmp223_ = ma;
			_tmp224_ = vala_member_access_get_member_name (_tmp223_);
			_tmp225_ = _tmp224_;
			if (g_strcmp0 (_tmp225_, "end") == 0) {
				ValaMemberAccess* _tmp226_;
				ValaExpression* _tmp227_;
				ValaExpression* _tmp228_;
				ValaSymbol* _tmp229_;
				ValaSymbol* _tmp230_;
				ValaMemberAccess* _tmp231_;
				ValaSymbol* _tmp232_;
				ValaSymbol* _tmp233_;
				_tmp226_ = ma;
				_tmp227_ = vala_member_access_get_inner (_tmp226_);
				_tmp228_ = _tmp227_;
				_tmp229_ = vala_expression_get_symbol_reference (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp231_ = ma;
				_tmp232_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp231_);
				_tmp233_ = _tmp232_;
				_tmp222_ = _tmp230_ == _tmp233_;
			} else {
				_tmp222_ = FALSE;
			}
			if (_tmp222_) {
				ValaCCodeFunctionCall* _tmp234_;
				ValaCCodeFunctionCall* _tmp235_;
				ValaMethod* _tmp236_;
				ValaList* _tmp237_;
				_tmp234_ = finish_call;
				_tmp235_ = _vala_ccode_node_ref0 (_tmp234_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp235_;
				_tmp236_ = m;
				_tmp237_ = vala_method_get_async_end_parameters (_tmp236_);
				_vala_iterable_unref0 (params);
				params = _tmp237_;
			} else {
				gboolean _tmp238_;
				gboolean _tmp239_;
				_tmp238_ = vala_method_call_get_is_yield_expression (expr);
				_tmp239_ = _tmp238_;
				if (!_tmp239_) {
					ValaCCodeFunctionCall* _tmp240_;
					ValaCCodeFunctionCall* _tmp241_;
					ValaMethod* _tmp242_;
					ValaList* _tmp243_;
					_tmp240_ = async_call;
					_tmp241_ = _vala_ccode_node_ref0 (_tmp240_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp241_;
					_tmp242_ = m;
					_tmp243_ = vala_method_get_async_begin_parameters (_tmp242_);
					_vala_iterable_unref0 (params);
					params = _tmp243_;
				} else {
					ValaCCodeFunctionCall* _tmp244_;
					ValaCCodeFunctionCall* _tmp245_;
					GHashFunc _tmp246_;
					GEqualFunc _tmp247_;
					GEqualFunc _tmp248_;
					ValaHashMap* _tmp249_;
					ValaHashMap* _tmp250_;
					ValaMethod* _tmp251_;
					ValaCCodeIdentifier* _tmp252_;
					ValaCCodeIdentifier* _tmp253_;
					ValaCCodeMemberAccess* _tmp254_;
					ValaCCodeMemberAccess* _tmp255_;
					_tmp244_ = finish_call;
					_tmp245_ = _vala_ccode_node_ref0 (_tmp244_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp245_;
					_tmp246_ = g_direct_hash;
					_tmp247_ = g_direct_equal;
					_tmp248_ = g_direct_equal;
					_tmp249_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp246_, _tmp247_, _tmp248_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp249_;
					_tmp250_ = out_arg_map;
					_tmp251_ = m;
					_tmp252_ = vala_ccode_identifier_new ("_data_");
					_tmp253_ = _tmp252_;
					_tmp254_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp253_, "_res_");
					_tmp255_ = _tmp254_;
					vala_map_set ((ValaMap*) _tmp250_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp251_), FALSE)), (ValaCCodeExpression*) _tmp255_);
					_vala_ccode_node_unref0 (_tmp255_);
					_vala_ccode_node_unref0 (_tmp253_);
				}
			}
		}
	}
	_tmp257_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp257_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp258_;
		ValaSymbol* _tmp259_;
		ValaSymbol* _tmp260_;
		_tmp258_ = m;
		_tmp259_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp258_);
		_tmp260_ = _tmp259_;
		_tmp256_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp260_, VALA_TYPE_CLASS);
	} else {
		_tmp256_ = FALSE;
	}
	if (_tmp256_) {
		ValaMethod* _tmp261_;
		ValaSymbol* _tmp262_;
		ValaSymbol* _tmp263_;
		gboolean _tmp264_;
		gboolean _tmp265_;
		ValaClass* _tmp269_;
		ValaClass* _tmp270_;
		gboolean _tmp271_;
		gboolean _tmp272_;
		_tmp261_ = m;
		_tmp262_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp261_);
		_tmp263_ = _tmp262_;
		_tmp264_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp263_, VALA_TYPE_CLASS, ValaClass));
		_tmp265_ = _tmp264_;
		if (!_tmp265_) {
			ValaCCodeFunctionCall* _tmp266_;
			ValaCCodeExpression* _tmp267_;
			ValaCCodeExpression* _tmp268_;
			_tmp266_ = ccall;
			_tmp267_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
			_tmp268_ = _tmp267_;
			vala_ccode_function_call_add_argument (_tmp266_, _tmp268_);
			_vala_ccode_node_unref0 (_tmp268_);
		}
		_tmp269_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp270_ = _tmp269_;
		_tmp271_ = vala_class_get_is_compact (_tmp270_);
		_tmp272_ = _tmp271_;
		if (!_tmp272_) {
			ValaClass* _tmp273_;
			ValaClass* _tmp274_;
			ValaMethod* _tmp275_;
			ValaSymbol* _tmp276_;
			ValaSymbol* _tmp277_;
			_tmp273_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp274_ = _tmp273_;
			_tmp275_ = m;
			_tmp276_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp275_);
			_tmp277_ = _tmp276_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp274_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp277_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp278_;
					ValaClass* _tmp279_;
					ValaList* _tmp280_;
					gint _base_type_size = 0;
					ValaList* _tmp281_;
					gint _tmp282_;
					gint _tmp283_;
					gint _base_type_index = 0;
					_tmp278_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_class_get_base_types (_tmp279_);
					_base_type_list = _tmp280_;
					_tmp281_ = _base_type_list;
					_tmp282_ = vala_collection_get_size ((ValaCollection*) _tmp281_);
					_tmp283_ = _tmp282_;
					_base_type_size = _tmp283_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp284_;
						gint _tmp285_;
						gint _tmp286_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp287_;
						gint _tmp288_;
						gpointer _tmp289_;
						ValaDataType* _tmp290_;
						ValaTypeSymbol* _tmp291_;
						ValaTypeSymbol* _tmp292_;
						_tmp284_ = _base_type_index;
						_base_type_index = _tmp284_ + 1;
						_tmp285_ = _base_type_index;
						_tmp286_ = _base_type_size;
						if (!(_tmp285_ < _tmp286_)) {
							break;
						}
						_tmp287_ = _base_type_list;
						_tmp288_ = _base_type_index;
						_tmp289_ = vala_list_get (_tmp287_, _tmp288_);
						base_type = (ValaDataType*) _tmp289_;
						_tmp290_ = base_type;
						_tmp291_ = vala_data_type_get_data_type (_tmp290_);
						_tmp292_ = _tmp291_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp292_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp293_;
							gchar* _tmp294_;
							gchar* _tmp295_;
							gboolean _tmp296_;
							ValaHashMap* _tmp301_;
							ValaDataType* _tmp302_;
							ValaList* _tmp303_;
							ValaList* _tmp304_;
							ValaList* _tmp305_;
							type_parameters = NULL;
							_tmp293_ = m;
							_tmp294_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp293_);
							_tmp295_ = _tmp294_;
							_tmp296_ = g_strcmp0 (_tmp295_, "g_object_new") == 0;
							_g_free0 (_tmp295_);
							if (_tmp296_) {
								ValaDataType* _tmp297_;
								ValaTypeSymbol* _tmp298_;
								ValaTypeSymbol* _tmp299_;
								ValaList* _tmp300_;
								_tmp297_ = base_type;
								_tmp298_ = vala_data_type_get_data_type (_tmp297_);
								_tmp299_ = _tmp298_;
								_tmp300_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp299_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp300_;
							}
							_tmp301_ = in_arg_map;
							_tmp302_ = base_type;
							_tmp303_ = vala_data_type_get_type_arguments (_tmp302_);
							_tmp304_ = _tmp303_;
							_tmp305_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp301_, _tmp304_, (ValaCodeNode*) expr, TRUE, _tmp305_);
							_vala_iterable_unref0 (_tmp304_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp306_;
				ValaSymbol* _tmp307_;
				ValaSymbol* _tmp308_;
				ValaClass* _tmp309_;
				type_param_index = 0;
				_tmp306_ = m;
				_tmp307_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp306_);
				_tmp308_ = _tmp307_;
				_tmp309_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp308_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp309_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp310_;
					ValaList* _tmp311_;
					gint _type_param_size = 0;
					ValaList* _tmp312_;
					gint _tmp313_;
					gint _tmp314_;
					gint _type_param_index = 0;
					_tmp310_ = cl;
					_tmp311_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp310_);
					_type_param_list = _tmp311_;
					_tmp312_ = _type_param_list;
					_tmp313_ = vala_collection_get_size ((ValaCollection*) _tmp312_);
					_tmp314_ = _tmp313_;
					_type_param_size = _tmp314_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp315_;
						gint _tmp316_;
						gint _tmp317_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp318_;
						gint _tmp319_;
						gpointer _tmp320_;
						ValaHashMap* _tmp321_;
						gint _tmp322_;
						ValaTypeParameter* _tmp323_;
						const gchar* _tmp324_;
						const gchar* _tmp325_;
						gchar* _tmp326_;
						gchar* _tmp327_;
						gchar* _tmp328_;
						gchar* _tmp329_;
						ValaCCodeIdentifier* _tmp330_;
						ValaCCodeIdentifier* _tmp331_;
						ValaHashMap* _tmp332_;
						gint _tmp333_;
						ValaTypeParameter* _tmp334_;
						const gchar* _tmp335_;
						const gchar* _tmp336_;
						gchar* _tmp337_;
						gchar* _tmp338_;
						gchar* _tmp339_;
						gchar* _tmp340_;
						ValaCCodeIdentifier* _tmp341_;
						ValaCCodeIdentifier* _tmp342_;
						ValaHashMap* _tmp343_;
						gint _tmp344_;
						ValaTypeParameter* _tmp345_;
						const gchar* _tmp346_;
						const gchar* _tmp347_;
						gchar* _tmp348_;
						gchar* _tmp349_;
						gchar* _tmp350_;
						gchar* _tmp351_;
						ValaCCodeIdentifier* _tmp352_;
						ValaCCodeIdentifier* _tmp353_;
						gint _tmp354_;
						_tmp315_ = _type_param_index;
						_type_param_index = _tmp315_ + 1;
						_tmp316_ = _type_param_index;
						_tmp317_ = _type_param_size;
						if (!(_tmp316_ < _tmp317_)) {
							break;
						}
						_tmp318_ = _type_param_list;
						_tmp319_ = _type_param_index;
						_tmp320_ = vala_list_get (_tmp318_, _tmp319_);
						type_param = (ValaTypeParameter*) _tmp320_;
						_tmp321_ = in_arg_map;
						_tmp322_ = type_param_index;
						_tmp323_ = type_param;
						_tmp324_ = vala_symbol_get_name ((ValaSymbol*) _tmp323_);
						_tmp325_ = _tmp324_;
						_tmp326_ = g_utf8_strdown (_tmp325_, (gssize) -1);
						_tmp327_ = _tmp326_;
						_tmp328_ = g_strdup_printf ("%s_type", _tmp327_);
						_tmp329_ = _tmp328_;
						_tmp330_ = vala_ccode_identifier_new (_tmp329_);
						_tmp331_ = _tmp330_;
						vala_map_set ((ValaMap*) _tmp321_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp322_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp331_);
						_vala_ccode_node_unref0 (_tmp331_);
						_g_free0 (_tmp329_);
						_g_free0 (_tmp327_);
						_tmp332_ = in_arg_map;
						_tmp333_ = type_param_index;
						_tmp334_ = type_param;
						_tmp335_ = vala_symbol_get_name ((ValaSymbol*) _tmp334_);
						_tmp336_ = _tmp335_;
						_tmp337_ = g_utf8_strdown (_tmp336_, (gssize) -1);
						_tmp338_ = _tmp337_;
						_tmp339_ = g_strdup_printf ("%s_dup_func", _tmp338_);
						_tmp340_ = _tmp339_;
						_tmp341_ = vala_ccode_identifier_new (_tmp340_);
						_tmp342_ = _tmp341_;
						vala_map_set ((ValaMap*) _tmp332_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp333_) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp342_);
						_vala_ccode_node_unref0 (_tmp342_);
						_g_free0 (_tmp340_);
						_g_free0 (_tmp338_);
						_tmp343_ = in_arg_map;
						_tmp344_ = type_param_index;
						_tmp345_ = type_param;
						_tmp346_ = vala_symbol_get_name ((ValaSymbol*) _tmp345_);
						_tmp347_ = _tmp346_;
						_tmp348_ = g_utf8_strdown (_tmp347_, (gssize) -1);
						_tmp349_ = _tmp348_;
						_tmp350_ = g_strdup_printf ("%s_destroy_func", _tmp349_);
						_tmp351_ = _tmp350_;
						_tmp352_ = vala_ccode_identifier_new (_tmp351_);
						_tmp353_ = _tmp352_;
						vala_map_set ((ValaMap*) _tmp343_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp344_) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp353_);
						_vala_ccode_node_unref0 (_tmp353_);
						_g_free0 (_tmp351_);
						_g_free0 (_tmp349_);
						_tmp354_ = type_param_index;
						type_param_index = _tmp354_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp355_;
			ValaClass* _tmp356_;
			ValaClass* _tmp357_;
			ValaClass* _tmp358_;
			ValaClass* _tmp359_;
			_tmp355_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp356_ = _tmp355_;
			_tmp357_ = vala_class_get_base_class (_tmp356_);
			_tmp358_ = _tmp357_;
			_tmp359_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp358_ == _tmp359_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp360_;
				ValaClass* _tmp361_;
				gchar* _tmp362_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp363_;
				ValaCCodeDeclaration* _tmp364_;
				ValaCCodeDeclaration* _tmp365_;
				const gchar* _tmp366_;
				const gchar* _tmp367_;
				const gchar* _tmp368_;
				const gchar* _tmp369_;
				gchar* _tmp370_;
				gchar* _tmp371_;
				ValaCCodeConstant* _tmp372_;
				ValaCCodeConstant* _tmp373_;
				ValaCCodeVariableDeclarator* _tmp374_;
				ValaCCodeVariableDeclarator* _tmp375_;
				ValaCCodeFunction* _tmp376_;
				ValaCCodeFunction* _tmp377_;
				ValaCCodeDeclaration* _tmp378_;
				ValaCCodeFunctionCall* _tmp379_;
				ValaCCodeIdentifier* _tmp380_;
				ValaCCodeIdentifier* _tmp381_;
				ValaCCodeUnaryExpression* _tmp382_;
				ValaCCodeUnaryExpression* _tmp383_;
				ValaCCodeCastExpression* _tmp384_;
				ValaCCodeCastExpression* _tmp385_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp386_;
				ValaCCodeIdentifier* _tmp387_;
				ValaCCodeFunctionCall* _tmp388_;
				ValaCCodeFunctionCall* _tmp389_;
				ValaCCodeFunctionCall* _tmp390_;
				ValaClass* _tmp391_;
				ValaClass* _tmp392_;
				gchar* _tmp393_;
				gchar* _tmp394_;
				ValaCCodeIdentifier* _tmp395_;
				ValaCCodeIdentifier* _tmp396_;
				ValaCCodeFunctionCall* _tmp397_;
				ValaCCodeFunctionCall* _tmp398_;
				_tmp360_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp361_ = _tmp360_;
				_tmp362_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp361_, NULL);
				class_prefix = _tmp362_;
				_tmp363_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp363_;
				_tmp364_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp364_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp365_ = funcs;
				_tmp366_ = class_prefix;
				_tmp367_ = class_prefix;
				_tmp368_ = class_prefix;
				_tmp369_ = class_prefix;
				_tmp370_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp366_, _tmp367_, _tmp368_, _tmp369_);
				_tmp371_ = _tmp370_;
				_tmp372_ = vala_ccode_constant_new (_tmp371_);
				_tmp373_ = _tmp372_;
				_tmp374_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp373_, NULL);
				_tmp375_ = _tmp374_;
				vala_ccode_declaration_add_declarator (_tmp365_, (ValaCCodeDeclarator*) _tmp375_);
				_vala_ccode_node_unref0 (_tmp375_);
				_vala_ccode_node_unref0 (_tmp373_);
				_g_free0 (_tmp371_);
				_tmp376_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp377_ = _tmp376_;
				_tmp378_ = funcs;
				vala_ccode_function_add_statement (_tmp377_, (ValaCCodeNode*) _tmp378_);
				_tmp379_ = ccall;
				_tmp380_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp381_ = _tmp380_;
				_tmp382_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp381_);
				_tmp383_ = _tmp382_;
				_tmp384_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp383_, "GSourceFuncs *");
				_tmp385_ = _tmp384_;
				vala_ccode_function_call_add_argument (_tmp379_, (ValaCCodeExpression*) _tmp385_);
				_vala_ccode_node_unref0 (_tmp385_);
				_vala_ccode_node_unref0 (_tmp383_);
				_vala_ccode_node_unref0 (_tmp381_);
				_tmp386_ = vala_ccode_identifier_new ("sizeof");
				_tmp387_ = _tmp386_;
				_tmp388_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp387_);
				_tmp389_ = _tmp388_;
				_vala_ccode_node_unref0 (_tmp387_);
				csizeof = _tmp389_;
				_tmp390_ = csizeof;
				_tmp391_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp392_ = _tmp391_;
				_tmp393_ = vala_get_ccode_name ((ValaCodeNode*) _tmp392_);
				_tmp394_ = _tmp393_;
				_tmp395_ = vala_ccode_identifier_new (_tmp394_);
				_tmp396_ = _tmp395_;
				vala_ccode_function_call_add_argument (_tmp390_, (ValaCCodeExpression*) _tmp396_);
				_vala_ccode_node_unref0 (_tmp396_);
				_g_free0 (_tmp394_);
				_tmp397_ = ccall;
				_tmp398_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp397_, (ValaCCodeExpression*) _tmp398_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp399_ = FALSE;
		ValaMethod* _tmp400_;
		_tmp400_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp400_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp401_;
			ValaSymbol* _tmp402_;
			ValaSymbol* _tmp403_;
			_tmp401_ = m;
			_tmp402_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp401_);
			_tmp403_ = _tmp402_;
			_tmp399_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp403_, VALA_TYPE_STRUCT);
		} else {
			_tmp399_ = FALSE;
		}
		if (_tmp399_) {
			ValaCCodeFunctionCall* _tmp404_;
			ValaCCodeExpression* _tmp405_;
			ValaCCodeExpression* _tmp406_;
			_tmp404_ = ccall;
			_tmp405_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp406_ = _tmp405_;
			vala_ccode_function_call_add_argument (_tmp404_, _tmp406_);
			_vala_ccode_node_unref0 (_tmp406_);
		} else {
			gboolean _tmp407_ = FALSE;
			gboolean _tmp408_ = FALSE;
			gboolean _tmp409_ = FALSE;
			gboolean _tmp410_ = FALSE;
			ValaMethod* _tmp411_;
			_tmp411_ = m;
			if (_tmp411_ != NULL) {
				ValaMethod* _tmp412_;
				ValaList* _tmp413_;
				ValaList* _tmp414_;
				gint _tmp415_;
				gint _tmp416_;
				_tmp412_ = m;
				_tmp413_ = vala_method_get_type_parameters (_tmp412_);
				_tmp414_ = _tmp413_;
				_tmp415_ = vala_collection_get_size ((ValaCollection*) _tmp414_);
				_tmp416_ = _tmp415_;
				_tmp410_ = _tmp416_ > 0;
				_vala_iterable_unref0 (_tmp414_);
			} else {
				_tmp410_ = FALSE;
			}
			if (_tmp410_) {
				ValaMethod* _tmp417_;
				_tmp417_ = m;
				_tmp409_ = !vala_get_ccode_has_generic_type_parameter (_tmp417_);
			} else {
				_tmp409_ = FALSE;
			}
			if (_tmp409_) {
				ValaMethod* _tmp418_;
				_tmp418_ = m;
				_tmp408_ = !vala_get_ccode_simple_generics (_tmp418_);
			} else {
				_tmp408_ = FALSE;
			}
			if (_tmp408_) {
				gboolean _tmp419_ = FALSE;
				ValaCCodeFunctionCall* _tmp420_;
				ValaCCodeFunctionCall* _tmp421_;
				_tmp420_ = ccall;
				_tmp421_ = finish_call;
				if (_tmp420_ != _tmp421_) {
					_tmp419_ = TRUE;
				} else {
					gboolean _tmp422_;
					gboolean _tmp423_;
					_tmp422_ = vala_method_call_get_is_yield_expression (expr);
					_tmp423_ = _tmp422_;
					_tmp419_ = _tmp423_;
				}
				_tmp407_ = _tmp419_;
			} else {
				_tmp407_ = FALSE;
			}
			if (_tmp407_) {
				ValaHashMap* _tmp424_;
				ValaMemberAccess* _tmp425_;
				ValaList* _tmp426_;
				ValaList* _tmp427_;
				_tmp424_ = in_arg_map;
				_tmp425_ = ma;
				_tmp426_ = vala_member_access_get_type_arguments (_tmp425_);
				_tmp427_ = _tmp426_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp424_, _tmp427_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp427_);
			}
		}
	}
	_tmp428_ = ccall;
	_tmp429_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp428_);
	ccall_expr = _tmp429_;
	_tmp430_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp430_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp431_;
		ValaExpression* _tmp432_;
		ValaExpression* _tmp433_;
		ValaDataType* _tmp434_;
		ValaDataType* _tmp435_;
		ValaArrayType* _tmp436_;
		ValaHashMap* _tmp437_;
		ValaArrayType* _tmp438_;
		ValaDataType* _tmp439_;
		ValaDataType* _tmp440_;
		gchar* _tmp441_;
		gchar* _tmp442_;
		ValaCCodeIdentifier* _tmp443_;
		ValaCCodeIdentifier* _tmp444_;
		_tmp431_ = ma;
		_tmp432_ = vala_member_access_get_inner (_tmp431_);
		_tmp433_ = _tmp432_;
		_tmp434_ = vala_expression_get_value_type (_tmp433_);
		_tmp435_ = _tmp434_;
		_tmp436_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp435_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp436_;
		_tmp437_ = in_arg_map;
		_tmp438_ = array_type;
		_tmp439_ = vala_array_type_get_element_type (_tmp438_);
		_tmp440_ = _tmp439_;
		_tmp441_ = vala_get_ccode_name ((ValaCodeNode*) _tmp440_);
		_tmp442_ = _tmp441_;
		_tmp443_ = vala_ccode_identifier_new (_tmp442_);
		_tmp444_ = _tmp443_;
		vala_map_set ((ValaMap*) _tmp437_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp444_);
		_vala_ccode_node_unref0 (_tmp444_);
		_g_free0 (_tmp442_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp445_;
		_tmp445_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp445_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp446_;
			_tmp446_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp446_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp447_;
				ValaExpression* _tmp448_;
				ValaExpression* _tmp449_;
				ValaTargetValue* _tmp450_;
				ValaTargetValue* _tmp451_;
				ValaTargetValue* _tmp452_;
				ValaTargetValue* _tmp453_;
				_tmp447_ = ma;
				_tmp448_ = vala_member_access_get_inner (_tmp447_);
				_tmp449_ = _tmp448_;
				_tmp450_ = vala_expression_get_target_value (_tmp449_);
				_tmp451_ = _tmp450_;
				_tmp452_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp451_, (ValaCodeNode*) expr);
				_tmp453_ = _tmp452_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp453_);
				_vala_target_value_unref0 (_tmp453_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp455_ = m;
	if (_tmp455_ != NULL) {
		ValaMethod* _tmp456_;
		gboolean _tmp457_;
		gboolean _tmp458_;
		_tmp456_ = m;
		_tmp457_ = vala_method_get_is_async_callback (_tmp456_);
		_tmp458_ = _tmp457_;
		_tmp454_ = _tmp458_;
	} else {
		_tmp454_ = FALSE;
	}
	if (_tmp454_) {
		ValaMethod* _tmp459_;
		ValaMethod* _tmp460_;
		gboolean _tmp461_;
		gboolean _tmp462_;
		ValaHashMap* _tmp476_;
		ValaMethod* _tmp477_;
		ValaCCodeExpression* _tmp478_;
		ValaHashMap* _tmp479_;
		ValaMethod* _tmp480_;
		ValaCCodeExpression* _tmp481_;
		_tmp459_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp460_ = _tmp459_;
		_tmp461_ = vala_method_get_closure (_tmp460_);
		_tmp462_ = _tmp461_;
		if (_tmp462_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp463_;
			ValaSymbol* _tmp464_;
			ValaSymbol* _tmp465_;
			ValaBlock* _tmp466_;
			ValaBlock* _tmp467_;
			ValaBlock* _tmp468_;
			ValaBlock* _tmp469_;
			gchar* _tmp470_;
			gchar* _tmp471_;
			ValaCCodeExpression* _tmp472_;
			ValaCCodeExpression* _tmp473_;
			ValaCCodeMemberAccess* _tmp474_;
			_tmp463_ = m;
			_tmp464_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp463_);
			_tmp465_ = _tmp464_;
			_tmp466_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp465_, VALA_TYPE_METHOD, ValaMethod));
			_tmp467_ = _tmp466_;
			_tmp468_ = _vala_code_node_ref0 (_tmp467_);
			block = _tmp468_;
			_tmp469_ = block;
			_tmp470_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp469_));
			_tmp471_ = _tmp470_;
			_tmp472_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp471_);
			_tmp473_ = _tmp472_;
			_tmp474_ = vala_ccode_member_access_new_pointer (_tmp473_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp474_;
			_vala_ccode_node_unref0 (_tmp473_);
			_g_free0 (_tmp471_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp475_;
			_tmp475_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp475_;
		}
		_tmp476_ = in_arg_map;
		_tmp477_ = m;
		_tmp478_ = instance;
		vala_map_set ((ValaMap*) _tmp476_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp477_), FALSE)), _tmp478_);
		_tmp479_ = out_arg_map;
		_tmp480_ = m;
		_tmp481_ = instance;
		vala_map_set ((ValaMap*) _tmp479_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp480_), FALSE)), _tmp481_);
	} else {
		gboolean _tmp482_ = FALSE;
		gboolean _tmp483_ = FALSE;
		ValaMethod* _tmp484_;
		_tmp484_ = m;
		if (_tmp484_ != NULL) {
			ValaMethod* _tmp485_;
			ValaMemberBinding _tmp486_;
			ValaMemberBinding _tmp487_;
			_tmp485_ = m;
			_tmp486_ = vala_method_get_binding (_tmp485_);
			_tmp487_ = _tmp486_;
			_tmp483_ = _tmp487_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp483_ = FALSE;
		}
		if (_tmp483_) {
			ValaMethod* _tmp488_;
			_tmp488_ = m;
			_tmp482_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp488_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp482_ = FALSE;
		}
		if (_tmp482_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp489_;
			ValaExpression* _tmp490_;
			ValaExpression* _tmp491_;
			ValaTargetValue* _tmp492_;
			ValaTargetValue* _tmp493_;
			ValaTargetValue* _tmp494_;
			gboolean _tmp495_ = FALSE;
			gboolean _tmp496_ = FALSE;
			ValaMemberAccess* _tmp497_;
			const gchar* _tmp498_;
			const gchar* _tmp499_;
			ValaTargetValue* _tmp521_;
			ValaCCodeExpression* _tmp522_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp523_;
			ValaSymbol* _tmp524_;
			ValaSymbol* _tmp525_;
			ValaStruct* _tmp526_;
			gboolean _tmp527_ = FALSE;
			ValaStruct* _tmp528_;
			gboolean _tmp537_;
			gboolean _tmp538_;
			_tmp489_ = ma;
			_tmp490_ = vala_member_access_get_inner (_tmp489_);
			_tmp491_ = _tmp490_;
			_tmp492_ = vala_expression_get_target_value (_tmp491_);
			_tmp493_ = _tmp492_;
			_tmp494_ = _vala_target_value_ref0 (_tmp493_);
			instance_value = _tmp494_;
			_tmp497_ = ma;
			_tmp498_ = vala_member_access_get_member_name (_tmp497_);
			_tmp499_ = _tmp498_;
			if (g_strcmp0 (_tmp499_, "begin") == 0) {
				_tmp496_ = TRUE;
			} else {
				ValaMemberAccess* _tmp500_;
				const gchar* _tmp501_;
				const gchar* _tmp502_;
				_tmp500_ = ma;
				_tmp501_ = vala_member_access_get_member_name (_tmp500_);
				_tmp502_ = _tmp501_;
				_tmp496_ = g_strcmp0 (_tmp502_, "end") == 0;
			}
			if (_tmp496_) {
				ValaMemberAccess* _tmp503_;
				ValaExpression* _tmp504_;
				ValaExpression* _tmp505_;
				ValaSymbol* _tmp506_;
				ValaSymbol* _tmp507_;
				ValaMemberAccess* _tmp508_;
				ValaSymbol* _tmp509_;
				ValaSymbol* _tmp510_;
				_tmp503_ = ma;
				_tmp504_ = vala_member_access_get_inner (_tmp503_);
				_tmp505_ = _tmp504_;
				_tmp506_ = vala_expression_get_symbol_reference (_tmp505_);
				_tmp507_ = _tmp506_;
				_tmp508_ = ma;
				_tmp509_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp508_);
				_tmp510_ = _tmp509_;
				_tmp495_ = _tmp507_ == _tmp510_;
			} else {
				_tmp495_ = FALSE;
			}
			if (_tmp495_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp511_;
				ValaExpression* _tmp512_;
				ValaExpression* _tmp513_;
				ValaMemberAccess* _tmp514_;
				ValaMemberAccess* _tmp515_;
				ValaExpression* _tmp516_;
				ValaExpression* _tmp517_;
				ValaTargetValue* _tmp518_;
				ValaTargetValue* _tmp519_;
				ValaTargetValue* _tmp520_;
				_tmp511_ = ma;
				_tmp512_ = vala_member_access_get_inner (_tmp511_);
				_tmp513_ = _tmp512_;
				_tmp514_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp513_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp514_;
				_tmp515_ = inner_ma;
				_tmp516_ = vala_member_access_get_inner (_tmp515_);
				_tmp517_ = _tmp516_;
				_tmp518_ = vala_expression_get_target_value (_tmp517_);
				_tmp519_ = _tmp518_;
				_tmp520_ = _vala_target_value_ref0 (_tmp519_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp520_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp521_ = instance_value;
			_tmp522_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp521_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp522_;
			_tmp523_ = m;
			_tmp524_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp523_);
			_tmp525_ = _tmp524_;
			_tmp526_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp525_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp525_) : NULL);
			st = _tmp526_;
			_tmp528_ = st;
			if (_tmp528_ != NULL) {
				ValaStruct* _tmp529_;
				_tmp529_ = st;
				_tmp527_ = !vala_struct_is_simple_type (_tmp529_);
			} else {
				_tmp527_ = FALSE;
			}
			if (_tmp527_) {
				ValaTargetValue* _tmp530_;
				ValaTargetValue* _tmp533_;
				ValaCCodeExpression* _tmp534_;
				ValaCCodeExpression* _tmp535_;
				ValaCCodeUnaryExpression* _tmp536_;
				_tmp530_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp530_)) {
					ValaTargetValue* _tmp531_;
					ValaTargetValue* _tmp532_;
					_tmp531_ = instance_value;
					_tmp532_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp531_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp532_;
				}
				_tmp533_ = instance_value;
				_tmp534_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp533_);
				_tmp535_ = _tmp534_;
				_tmp536_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp535_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp536_;
				_vala_ccode_node_unref0 (_tmp535_);
			}
			_tmp537_ = vala_method_call_get_is_yield_expression (expr);
			_tmp538_ = _tmp537_;
			if (_tmp538_) {
				ValaHashMap* _tmp539_;
				ValaMethod* _tmp540_;
				ValaCCodeExpression* _tmp541_;
				ValaMethod* _tmp542_;
				_tmp539_ = in_arg_map;
				_tmp540_ = m;
				_tmp541_ = instance;
				vala_map_set ((ValaMap*) _tmp539_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp540_), FALSE)), _tmp541_);
				_tmp542_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp542_)) {
					ValaHashMap* _tmp543_;
					ValaMethod* _tmp544_;
					ValaCCodeExpression* _tmp545_;
					_tmp543_ = out_arg_map;
					_tmp544_ = m;
					_tmp545_ = instance;
					vala_map_set ((ValaMap*) _tmp543_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp544_), FALSE)), _tmp545_);
				}
			} else {
				gboolean _tmp546_ = FALSE;
				ValaMemberAccess* _tmp547_;
				const gchar* _tmp548_;
				const gchar* _tmp549_;
				_tmp547_ = ma;
				_tmp548_ = vala_member_access_get_member_name (_tmp547_);
				_tmp549_ = _tmp548_;
				if (g_strcmp0 (_tmp549_, "end") != 0) {
					_tmp546_ = TRUE;
				} else {
					ValaMethod* _tmp550_;
					_tmp550_ = m;
					_tmp546_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp550_);
				}
				if (_tmp546_) {
					ValaHashMap* _tmp551_;
					ValaMethod* _tmp552_;
					ValaCCodeExpression* _tmp553_;
					ValaHashMap* _tmp554_;
					ValaMethod* _tmp555_;
					ValaCCodeExpression* _tmp556_;
					_tmp551_ = out_arg_map;
					_tmp552_ = m;
					_tmp553_ = instance;
					vala_map_set ((ValaMap*) _tmp551_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp552_), FALSE)), _tmp553_);
					_tmp554_ = in_arg_map;
					_tmp555_ = m;
					_tmp556_ = instance;
					vala_map_set ((ValaMap*) _tmp554_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp555_), FALSE)), _tmp556_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp557_ = FALSE;
			ValaMethod* _tmp558_;
			_tmp558_ = m;
			if (_tmp558_ != NULL) {
				ValaMethod* _tmp559_;
				ValaMemberBinding _tmp560_;
				ValaMemberBinding _tmp561_;
				_tmp559_ = m;
				_tmp560_ = vala_method_get_binding (_tmp559_);
				_tmp561_ = _tmp560_;
				_tmp557_ = _tmp561_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp557_ = FALSE;
			}
			if (_tmp557_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp562_;
				ValaSymbol* _tmp563_;
				ValaSymbol* _tmp564_;
				ValaClass* _tmp565_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp566_;
				gchar* _tmp567_;
				gchar* _tmp568_;
				gchar* _tmp569_;
				gchar* _tmp570_;
				ValaCCodeIdentifier* _tmp571_;
				ValaCCodeIdentifier* _tmp572_;
				ValaCCodeFunctionCall* _tmp573_;
				ValaCCodeFunctionCall* _tmp574_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp575_;
				ValaExpression* _tmp576_;
				ValaExpression* _tmp577_;
				ValaCCodeFunctionCall* _tmp603_;
				ValaCCodeExpression* _tmp604_;
				ValaHashMap* _tmp605_;
				ValaMethod* _tmp606_;
				ValaCCodeFunctionCall* _tmp607_;
				ValaHashMap* _tmp608_;
				ValaMethod* _tmp609_;
				ValaCCodeFunctionCall* _tmp610_;
				_tmp562_ = m;
				_tmp563_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp562_);
				_tmp564_ = _tmp563_;
				_tmp565_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp564_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp565_;
				_tmp566_ = cl;
				_tmp567_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp566_, NULL);
				_tmp568_ = _tmp567_;
				_tmp569_ = g_strconcat (_tmp568_, "_CLASS", NULL);
				_tmp570_ = _tmp569_;
				_tmp571_ = vala_ccode_identifier_new (_tmp570_);
				_tmp572_ = _tmp571_;
				_tmp573_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp572_);
				_tmp574_ = _tmp573_;
				_vala_ccode_node_unref0 (_tmp572_);
				_g_free0 (_tmp570_);
				_g_free0 (_tmp568_);
				cast = _tmp574_;
				_tmp575_ = ma;
				_tmp576_ = vala_member_access_get_inner (_tmp575_);
				_tmp577_ = _tmp576_;
				if (_tmp577_ == NULL) {
					ValaDataType* _tmp578_;
					ValaDataType* _tmp579_;
					gboolean _tmp580_;
					_tmp578_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp579_ = _tmp578_;
					_tmp580_ = _tmp579_ == NULL;
					_vala_code_node_unref0 (_tmp579_);
					if (_tmp580_) {
						ValaCCodeIdentifier* _tmp581_;
						_tmp581_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp581_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp582_;
						ValaCCodeIdentifier* _tmp583_;
						ValaCCodeFunctionCall* _tmp584_;
						ValaCCodeFunctionCall* _tmp585_;
						ValaCCodeFunctionCall* _tmp586_;
						ValaCCodeExpression* _tmp587_;
						ValaCCodeExpression* _tmp588_;
						ValaCCodeFunctionCall* _tmp589_;
						ValaCCodeExpression* _tmp590_;
						_tmp582_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp583_ = _tmp582_;
						_tmp584_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp583_);
						_tmp585_ = _tmp584_;
						_vala_ccode_node_unref0 (_tmp583_);
						k = _tmp585_;
						_tmp586_ = k;
						_tmp587_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp588_ = _tmp587_;
						vala_ccode_function_call_add_argument (_tmp586_, _tmp588_);
						_vala_ccode_node_unref0 (_tmp588_);
						_tmp589_ = k;
						_tmp590_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp589_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp590_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp591_;
					ValaCCodeIdentifier* _tmp592_;
					ValaCCodeFunctionCall* _tmp593_;
					ValaCCodeFunctionCall* _tmp594_;
					ValaCCodeFunctionCall* _tmp595_;
					ValaMemberAccess* _tmp596_;
					ValaExpression* _tmp597_;
					ValaExpression* _tmp598_;
					ValaCCodeExpression* _tmp599_;
					ValaCCodeExpression* _tmp600_;
					ValaCCodeFunctionCall* _tmp601_;
					ValaCCodeExpression* _tmp602_;
					_tmp591_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp592_ = _tmp591_;
					_tmp593_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp592_);
					_tmp594_ = _tmp593_;
					_vala_ccode_node_unref0 (_tmp592_);
					k = _tmp594_;
					_tmp595_ = k;
					_tmp596_ = ma;
					_tmp597_ = vala_member_access_get_inner (_tmp596_);
					_tmp598_ = _tmp597_;
					_tmp599_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp598_);
					_tmp600_ = _tmp599_;
					vala_ccode_function_call_add_argument (_tmp595_, _tmp600_);
					_vala_ccode_node_unref0 (_tmp600_);
					_tmp601_ = k;
					_tmp602_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp601_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp602_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp603_ = cast;
				_tmp604_ = klass;
				vala_ccode_function_call_add_argument (_tmp603_, _tmp604_);
				_tmp605_ = in_arg_map;
				_tmp606_ = m;
				_tmp607_ = cast;
				vala_map_set ((ValaMap*) _tmp605_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp606_), FALSE)), (ValaCCodeExpression*) _tmp607_);
				_tmp608_ = out_arg_map;
				_tmp609_ = m;
				_tmp610_ = cast;
				vala_map_set ((ValaMap*) _tmp608_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp609_), FALSE)), (ValaCCodeExpression*) _tmp610_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp612_ = m;
	if (_tmp612_ != NULL) {
		ValaMethod* _tmp613_;
		_tmp613_ = m;
		_tmp611_ = vala_get_ccode_has_generic_type_parameter (_tmp613_);
	} else {
		_tmp611_ = FALSE;
	}
	if (_tmp611_) {
		ValaMethod* _tmp614_;
		ValaList* _tmp615_;
		ValaList* _tmp616_;
		gint _tmp617_;
		gint _tmp618_;
		gboolean _tmp619_;
		_tmp614_ = m;
		_tmp615_ = vala_method_get_type_parameters (_tmp614_);
		_tmp616_ = _tmp615_;
		_tmp617_ = vala_collection_get_size ((ValaCollection*) _tmp616_);
		_tmp618_ = _tmp617_;
		_tmp619_ = _tmp618_ > 0;
		_vala_iterable_unref0 (_tmp616_);
		if (_tmp619_) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp620_;
				ValaList* _tmp621_;
				gint _type_arg_size = 0;
				ValaList* _tmp622_;
				gint _tmp623_;
				gint _tmp624_;
				gint _type_arg_index = 0;
				_tmp620_ = ma;
				_tmp621_ = vala_member_access_get_type_arguments (_tmp620_);
				_type_arg_list = _tmp621_;
				_tmp622_ = _type_arg_list;
				_tmp623_ = vala_collection_get_size ((ValaCollection*) _tmp622_);
				_tmp624_ = _tmp623_;
				_type_arg_size = _tmp624_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp625_;
					gint _tmp626_;
					gint _tmp627_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp628_;
					gint _tmp629_;
					gpointer _tmp630_;
					gboolean _tmp631_ = FALSE;
					gboolean _tmp632_ = FALSE;
					gboolean _tmp633_ = FALSE;
					ValaMethod* _tmp634_;
					ValaHashMap* _tmp642_;
					ValaMethod* _tmp643_;
					gint _tmp644_;
					ValaDataType* _tmp645_;
					gchar* _tmp646_;
					gchar* _tmp647_;
					ValaCCodeIdentifier* _tmp648_;
					ValaCCodeIdentifier* _tmp649_;
					gint _tmp650_;
					_tmp625_ = _type_arg_index;
					_type_arg_index = _tmp625_ + 1;
					_tmp626_ = _type_arg_index;
					_tmp627_ = _type_arg_size;
					if (!(_tmp626_ < _tmp627_)) {
						break;
					}
					_tmp628_ = _type_arg_list;
					_tmp629_ = _type_arg_index;
					_tmp630_ = vala_list_get (_tmp628_, _tmp629_);
					type_arg = (ValaDataType*) _tmp630_;
					_tmp634_ = m;
					if (vala_get_ccode_simple_generics (_tmp634_)) {
						ValaDataType* _tmp635_;
						_tmp635_ = type_arg;
						_tmp633_ = vala_data_type_is_real_struct_type (_tmp635_);
					} else {
						_tmp633_ = FALSE;
					}
					if (_tmp633_) {
						ValaDataType* _tmp636_;
						gboolean _tmp637_;
						gboolean _tmp638_;
						_tmp636_ = type_arg;
						_tmp637_ = vala_data_type_get_nullable (_tmp636_);
						_tmp638_ = _tmp637_;
						_tmp632_ = !_tmp638_;
					} else {
						_tmp632_ = FALSE;
					}
					if (_tmp632_) {
						ValaDataType* _tmp639_;
						_tmp639_ = type_arg;
						_tmp631_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp639_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp631_ = FALSE;
					}
					if (_tmp631_) {
						ValaDataType* _tmp640_;
						ValaPointerType* _tmp641_;
						_tmp640_ = type_arg;
						_tmp641_ = vala_pointer_type_new (_tmp640_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp641_;
					}
					_tmp642_ = in_arg_map;
					_tmp643_ = m;
					_tmp644_ = type_param_index;
					_tmp645_ = type_arg;
					_tmp646_ = vala_get_ccode_name ((ValaCodeNode*) _tmp645_);
					_tmp647_ = _tmp646_;
					_tmp648_ = vala_ccode_identifier_new (_tmp647_);
					_tmp649_ = _tmp648_;
					vala_map_set ((ValaMap*) _tmp642_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp643_) + (0.01 * _tmp644_), FALSE)), (ValaCCodeExpression*) _tmp649_);
					_vala_ccode_node_unref0 (_tmp649_);
					_g_free0 (_tmp647_);
					_tmp650_ = type_param_index;
					type_param_index = _tmp650_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp651_;
				ValaExpression* _tmp652_;
				ValaExpression* _tmp653_;
				ValaDataType* _tmp654_;
				ValaDataType* _tmp655_;
				ValaList* _tmp656_;
				gint _type_arg_size = 0;
				ValaList* _tmp657_;
				gint _tmp658_;
				gint _tmp659_;
				gint _type_arg_index = 0;
				_tmp651_ = ma;
				_tmp652_ = vala_member_access_get_inner (_tmp651_);
				_tmp653_ = _tmp652_;
				_tmp654_ = vala_expression_get_value_type (_tmp653_);
				_tmp655_ = _tmp654_;
				_tmp656_ = vala_data_type_get_type_arguments (_tmp655_);
				_type_arg_list = _tmp656_;
				_tmp657_ = _type_arg_list;
				_tmp658_ = vala_collection_get_size ((ValaCollection*) _tmp657_);
				_tmp659_ = _tmp658_;
				_type_arg_size = _tmp659_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp660_;
					gint _tmp661_;
					gint _tmp662_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp663_;
					gint _tmp664_;
					gpointer _tmp665_;
					ValaHashMap* _tmp666_;
					ValaMethod* _tmp667_;
					gint _tmp668_;
					ValaDataType* _tmp669_;
					gchar* _tmp670_;
					gchar* _tmp671_;
					ValaCCodeIdentifier* _tmp672_;
					ValaCCodeIdentifier* _tmp673_;
					gint _tmp674_;
					_tmp660_ = _type_arg_index;
					_type_arg_index = _tmp660_ + 1;
					_tmp661_ = _type_arg_index;
					_tmp662_ = _type_arg_size;
					if (!(_tmp661_ < _tmp662_)) {
						break;
					}
					_tmp663_ = _type_arg_list;
					_tmp664_ = _type_arg_index;
					_tmp665_ = vala_list_get (_tmp663_, _tmp664_);
					type_arg = (ValaDataType*) _tmp665_;
					_tmp666_ = in_arg_map;
					_tmp667_ = m;
					_tmp668_ = type_param_index;
					_tmp669_ = type_arg;
					_tmp670_ = vala_get_ccode_name ((ValaCodeNode*) _tmp669_);
					_tmp671_ = _tmp670_;
					_tmp672_ = vala_ccode_identifier_new (_tmp671_);
					_tmp673_ = _tmp672_;
					vala_map_set ((ValaMap*) _tmp666_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp667_) + (0.01 * _tmp668_), FALSE)), (ValaCCodeExpression*) _tmp673_);
					_vala_ccode_node_unref0 (_tmp673_);
					_g_free0 (_tmp671_);
					_tmp674_ = type_param_index;
					type_param_index = _tmp674_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp675_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp675_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp676_;
		ValaExpression* _tmp677_;
		ValaExpression* _tmp678_;
		ValaDataType* _tmp679_;
		ValaDataType* _tmp680_;
		ValaArrayType* _tmp681_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp682_;
		ValaCCodeIdentifier* _tmp683_;
		ValaCCodeFunctionCall* _tmp684_;
		ValaCCodeFunctionCall* _tmp685_;
		ValaCCodeFunctionCall* _tmp686_;
		ValaArrayType* _tmp687_;
		ValaDataType* _tmp688_;
		ValaDataType* _tmp689_;
		gchar* _tmp690_;
		gchar* _tmp691_;
		ValaCCodeIdentifier* _tmp692_;
		ValaCCodeIdentifier* _tmp693_;
		ValaHashMap* _tmp694_;
		ValaCCodeFunctionCall* _tmp695_;
		_tmp676_ = ma;
		_tmp677_ = vala_member_access_get_inner (_tmp676_);
		_tmp678_ = _tmp677_;
		_tmp679_ = vala_expression_get_value_type (_tmp678_);
		_tmp680_ = _tmp679_;
		_tmp681_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp680_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp681_;
		_tmp682_ = vala_ccode_identifier_new ("sizeof");
		_tmp683_ = _tmp682_;
		_tmp684_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp683_);
		_tmp685_ = _tmp684_;
		_vala_ccode_node_unref0 (_tmp683_);
		csizeof = _tmp685_;
		_tmp686_ = csizeof;
		_tmp687_ = array_type;
		_tmp688_ = vala_array_type_get_element_type (_tmp687_);
		_tmp689_ = _tmp688_;
		_tmp690_ = vala_get_ccode_name ((ValaCodeNode*) _tmp689_);
		_tmp691_ = _tmp690_;
		_tmp692_ = vala_ccode_identifier_new (_tmp691_);
		_tmp693_ = _tmp692_;
		vala_ccode_function_call_add_argument (_tmp686_, (ValaCCodeExpression*) _tmp693_);
		_vala_ccode_node_unref0 (_tmp693_);
		_g_free0 (_tmp691_);
		_tmp694_ = in_arg_map;
		_tmp695_ = csizeof;
		vala_map_set ((ValaMap*) _tmp694_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp695_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp696_;
		_tmp696_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp696_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp697_;
			ValaMethod* _tmp698_;
			ValaMethod* _tmp699_;
			gint param_nr = 0;
			ValaMethod* _tmp770_;
			ValaCCodeBaseModuleEmitContext* _tmp771_;
			_tmp697_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp698_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp697_, (ValaSymbol*) _tmp698_);
			_tmp699_ = m;
			vala_method_clear_parameters (_tmp699_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp700_;
				gint _arg_size = 0;
				ValaList* _tmp701_;
				gint _tmp702_;
				gint _tmp703_;
				gint _arg_index = 0;
				_tmp700_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp700_;
				_tmp701_ = _arg_list;
				_tmp702_ = vala_collection_get_size ((ValaCollection*) _tmp701_);
				_tmp703_ = _tmp702_;
				_arg_size = _tmp703_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp704_;
					gint _tmp705_;
					gint _tmp706_;
					ValaExpression* arg = NULL;
					ValaList* _tmp707_;
					gint _tmp708_;
					gpointer _tmp709_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp710_;
					ValaUnaryExpression* _tmp711_;
					gboolean _tmp712_ = FALSE;
					ValaUnaryExpression* _tmp713_;
					gint _tmp757_;
					_tmp704_ = _arg_index;
					_arg_index = _tmp704_ + 1;
					_tmp705_ = _arg_index;
					_tmp706_ = _arg_size;
					if (!(_tmp705_ < _tmp706_)) {
						break;
					}
					_tmp707_ = _arg_list;
					_tmp708_ = _arg_index;
					_tmp709_ = vala_list_get (_tmp707_, _tmp708_);
					arg = (ValaExpression*) _tmp709_;
					_tmp710_ = arg;
					_tmp711_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp710_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp710_) : NULL);
					unary = _tmp711_;
					_tmp713_ = unary;
					if (_tmp713_ != NULL) {
						ValaUnaryExpression* _tmp714_;
						ValaUnaryOperator _tmp715_;
						ValaUnaryOperator _tmp716_;
						_tmp714_ = unary;
						_tmp715_ = vala_unary_expression_get_operator (_tmp714_);
						_tmp716_ = _tmp715_;
						_tmp712_ = _tmp716_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp712_ = FALSE;
					}
					if (_tmp712_) {
						ValaParameter* param = NULL;
						gint _tmp717_;
						gchar* _tmp718_;
						gchar* _tmp719_;
						ValaUnaryExpression* _tmp720_;
						ValaExpression* _tmp721_;
						ValaExpression* _tmp722_;
						ValaDataType* _tmp723_;
						ValaDataType* _tmp724_;
						ValaParameter* _tmp725_;
						ValaParameter* _tmp726_;
						ValaParameter* _tmp727_;
						ValaMethod* _tmp728_;
						ValaParameter* _tmp729_;
						_tmp717_ = param_nr;
						_tmp718_ = g_strdup_printf ("param%d", _tmp717_);
						_tmp719_ = _tmp718_;
						_tmp720_ = unary;
						_tmp721_ = vala_unary_expression_get_inner (_tmp720_);
						_tmp722_ = _tmp721_;
						_tmp723_ = vala_expression_get_value_type (_tmp722_);
						_tmp724_ = _tmp723_;
						_tmp725_ = vala_parameter_new (_tmp719_, _tmp724_, NULL);
						_tmp726_ = _tmp725_;
						_g_free0 (_tmp719_);
						param = _tmp726_;
						_tmp727_ = param;
						vala_parameter_set_direction (_tmp727_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp728_ = m;
						_tmp729_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp728_, _tmp729_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp730_ = FALSE;
						ValaUnaryExpression* _tmp731_;
						_tmp731_ = unary;
						if (_tmp731_ != NULL) {
							ValaUnaryExpression* _tmp732_;
							ValaUnaryOperator _tmp733_;
							ValaUnaryOperator _tmp734_;
							_tmp732_ = unary;
							_tmp733_ = vala_unary_expression_get_operator (_tmp732_);
							_tmp734_ = _tmp733_;
							_tmp730_ = _tmp734_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp730_ = FALSE;
						}
						if (_tmp730_) {
							ValaParameter* param = NULL;
							gint _tmp735_;
							gchar* _tmp736_;
							gchar* _tmp737_;
							ValaUnaryExpression* _tmp738_;
							ValaExpression* _tmp739_;
							ValaExpression* _tmp740_;
							ValaDataType* _tmp741_;
							ValaDataType* _tmp742_;
							ValaParameter* _tmp743_;
							ValaParameter* _tmp744_;
							ValaParameter* _tmp745_;
							ValaMethod* _tmp746_;
							ValaParameter* _tmp747_;
							_tmp735_ = param_nr;
							_tmp736_ = g_strdup_printf ("param%d", _tmp735_);
							_tmp737_ = _tmp736_;
							_tmp738_ = unary;
							_tmp739_ = vala_unary_expression_get_inner (_tmp738_);
							_tmp740_ = _tmp739_;
							_tmp741_ = vala_expression_get_value_type (_tmp740_);
							_tmp742_ = _tmp741_;
							_tmp743_ = vala_parameter_new (_tmp737_, _tmp742_, NULL);
							_tmp744_ = _tmp743_;
							_g_free0 (_tmp737_);
							param = _tmp744_;
							_tmp745_ = param;
							vala_parameter_set_direction (_tmp745_, VALA_PARAMETER_DIRECTION_REF);
							_tmp746_ = m;
							_tmp747_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp746_, _tmp747_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp748_;
							gint _tmp749_;
							gchar* _tmp750_;
							gchar* _tmp751_;
							ValaExpression* _tmp752_;
							ValaDataType* _tmp753_;
							ValaDataType* _tmp754_;
							ValaParameter* _tmp755_;
							ValaParameter* _tmp756_;
							_tmp748_ = m;
							_tmp749_ = param_nr;
							_tmp750_ = g_strdup_printf ("param%d", _tmp749_);
							_tmp751_ = _tmp750_;
							_tmp752_ = arg;
							_tmp753_ = vala_expression_get_value_type (_tmp752_);
							_tmp754_ = _tmp753_;
							_tmp755_ = vala_parameter_new (_tmp751_, _tmp754_, NULL);
							_tmp756_ = _tmp755_;
							vala_callable_add_parameter ((ValaCallable*) _tmp748_, _tmp756_);
							_vala_code_node_unref0 (_tmp756_);
							_g_free0 (_tmp751_);
						}
					}
					_tmp757_ = param_nr;
					param_nr = _tmp757_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp758_;
				ValaList* _tmp759_;
				gint _param_size = 0;
				ValaList* _tmp760_;
				gint _tmp761_;
				gint _tmp762_;
				gint _param_index = 0;
				_tmp758_ = m;
				_tmp759_ = vala_callable_get_parameters ((ValaCallable*) _tmp758_);
				_param_list = _tmp759_;
				_tmp760_ = _param_list;
				_tmp761_ = vala_collection_get_size ((ValaCollection*) _tmp760_);
				_tmp762_ = _tmp761_;
				_param_size = _tmp762_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp763_;
					gint _tmp764_;
					gint _tmp765_;
					ValaParameter* param = NULL;
					ValaList* _tmp766_;
					gint _tmp767_;
					gpointer _tmp768_;
					ValaParameter* _tmp769_;
					_tmp763_ = _param_index;
					_param_index = _tmp763_ + 1;
					_tmp764_ = _param_index;
					_tmp765_ = _param_size;
					if (!(_tmp764_ < _tmp765_)) {
						break;
					}
					_tmp766_ = _param_list;
					_tmp767_ = _param_index;
					_tmp768_ = vala_list_get (_tmp766_, _tmp767_);
					param = (ValaParameter*) _tmp768_;
					_tmp769_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp769_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp770_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp770_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp771_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp771_);
		} else {
			gboolean _tmp772_ = FALSE;
			ValaMethod* _tmp773_;
			_tmp773_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp773_, VALA_TYPE_CREATION_METHOD)) {
				ValaMethod* _tmp774_;
				ValaSymbol* _tmp775_;
				ValaSymbol* _tmp776_;
				_tmp774_ = m;
				_tmp775_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp774_);
				_tmp776_ = _tmp775_;
				_tmp772_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp776_, VALA_TYPE_CLASS);
			} else {
				_tmp772_ = FALSE;
			}
			if (_tmp772_) {
				ValaCCodeFunction* _tmp777_;
				ValaCCodeFunction* _tmp778_;
				ValaCCodeExpression* _tmp779_;
				ValaCCodeExpression* _tmp780_;
				ValaCCodeFunctionCall* _tmp781_;
				ValaClass* _tmp782_;
				ValaClass* _tmp783_;
				gchar* _tmp784_;
				gchar* _tmp785_;
				gchar* _tmp786_;
				gchar* _tmp787_;
				ValaCCodeCastExpression* _tmp788_;
				ValaCCodeCastExpression* _tmp789_;
				ValaMethod* _tmp790_;
				ValaMethod* _tmp791_;
				ValaBlock* _tmp792_;
				ValaBlock* _tmp793_;
				gboolean _tmp794_;
				gboolean _tmp795_;
				gboolean _tmp822_ = FALSE;
				ValaClass* _tmp823_;
				ValaClass* _tmp824_;
				gboolean _tmp825_;
				gboolean _tmp826_;
				_tmp777_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp778_ = _tmp777_;
				_tmp779_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp780_ = _tmp779_;
				_tmp781_ = ccall;
				_tmp782_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp783_ = _tmp782_;
				_tmp784_ = vala_get_ccode_name ((ValaCodeNode*) _tmp783_);
				_tmp785_ = _tmp784_;
				_tmp786_ = g_strconcat (_tmp785_, "*", NULL);
				_tmp787_ = _tmp786_;
				_tmp788_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp781_, _tmp787_);
				_tmp789_ = _tmp788_;
				vala_ccode_function_add_assignment (_tmp778_, _tmp780_, (ValaCCodeExpression*) _tmp789_);
				_vala_ccode_node_unref0 (_tmp789_);
				_g_free0 (_tmp787_);
				_g_free0 (_tmp785_);
				_vala_ccode_node_unref0 (_tmp780_);
				_tmp790_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp791_ = _tmp790_;
				_tmp792_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp791_);
				_tmp793_ = _tmp792_;
				_tmp794_ = vala_block_get_captured (_tmp793_);
				_tmp795_ = _tmp794_;
				if (_tmp795_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp796_;
					ValaClass* _tmp797_;
					ValaObjectType* _tmp798_;
					ValaObjectType* _tmp799_;
					ValaSourceReference* _tmp800_;
					ValaSourceReference* _tmp801_;
					ValaCCodeExpression* _tmp802_;
					ValaCCodeExpression* _tmp803_;
					ValaCCodeFunctionCall* _tmp804_;
					ValaCCodeFunctionCall* _tmp805_;
					ValaCCodeFunctionCall* _tmp806_;
					ValaCCodeExpression* _tmp807_;
					ValaCCodeExpression* _tmp808_;
					ValaCCodeFunction* _tmp809_;
					ValaCCodeFunction* _tmp810_;
					ValaMethod* _tmp811_;
					ValaMethod* _tmp812_;
					ValaBlock* _tmp813_;
					ValaBlock* _tmp814_;
					gchar* _tmp815_;
					gchar* _tmp816_;
					ValaCCodeExpression* _tmp817_;
					ValaCCodeExpression* _tmp818_;
					ValaCCodeMemberAccess* _tmp819_;
					ValaCCodeMemberAccess* _tmp820_;
					ValaCCodeFunctionCall* _tmp821_;
					_tmp796_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp797_ = _tmp796_;
					_tmp798_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp797_);
					_tmp799_ = _tmp798_;
					_tmp800_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp801_ = _tmp800_;
					_tmp802_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp799_, _tmp801_, FALSE);
					_tmp803_ = _tmp802_;
					_tmp804_ = vala_ccode_function_call_new (_tmp803_);
					_tmp805_ = _tmp804_;
					_vala_ccode_node_unref0 (_tmp803_);
					_vala_code_node_unref0 (_tmp799_);
					ref_call = _tmp805_;
					_tmp806_ = ref_call;
					_tmp807_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp808_ = _tmp807_;
					vala_ccode_function_call_add_argument (_tmp806_, _tmp808_);
					_vala_ccode_node_unref0 (_tmp808_);
					_tmp809_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp810_ = _tmp809_;
					_tmp811_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp812_ = _tmp811_;
					_tmp813_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp812_);
					_tmp814_ = _tmp813_;
					_tmp815_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp814_));
					_tmp816_ = _tmp815_;
					_tmp817_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp816_);
					_tmp818_ = _tmp817_;
					_tmp819_ = vala_ccode_member_access_new_pointer (_tmp818_, "self");
					_tmp820_ = _tmp819_;
					_tmp821_ = ref_call;
					vala_ccode_function_add_assignment (_tmp810_, (ValaCCodeExpression*) _tmp820_, (ValaCCodeExpression*) _tmp821_);
					_vala_ccode_node_unref0 (_tmp820_);
					_vala_ccode_node_unref0 (_tmp818_);
					_g_free0 (_tmp816_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp823_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp824_ = _tmp823_;
				_tmp825_ = vala_class_get_is_compact (_tmp824_);
				_tmp826_ = _tmp825_;
				if (!_tmp826_) {
					ValaClass* _tmp827_;
					ValaClass* _tmp828_;
					ValaList* _tmp829_;
					ValaList* _tmp830_;
					gint _tmp831_;
					gint _tmp832_;
					_tmp827_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp828_ = _tmp827_;
					_tmp829_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp828_);
					_tmp830_ = _tmp829_;
					_tmp831_ = vala_collection_get_size ((ValaCollection*) _tmp830_);
					_tmp832_ = _tmp831_;
					_tmp822_ = _tmp832_ > 0;
					_vala_iterable_unref0 (_tmp830_);
				} else {
					_tmp822_ = FALSE;
				}
				if (_tmp822_) {
					gchar** suffices = NULL;
					gchar* _tmp833_;
					gchar* _tmp834_;
					gchar* _tmp835_;
					gchar** _tmp836_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp833_ = g_strdup ("type");
					_tmp834_ = g_strdup ("dup_func");
					_tmp835_ = g_strdup ("destroy_func");
					_tmp836_ = g_new0 (gchar*, 3 + 1);
					_tmp836_[0] = _tmp833_;
					_tmp836_[1] = _tmp834_;
					_tmp836_[2] = _tmp835_;
					suffices = _tmp836_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp837_;
						ValaClass* _tmp838_;
						ValaList* _tmp839_;
						gint _type_param_size = 0;
						ValaList* _tmp840_;
						gint _tmp841_;
						gint _tmp842_;
						gint _type_param_index = 0;
						_tmp837_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp838_ = _tmp837_;
						_tmp839_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp838_);
						_type_param_list = _tmp839_;
						_tmp840_ = _type_param_list;
						_tmp841_ = vala_collection_get_size ((ValaCollection*) _tmp840_);
						_tmp842_ = _tmp841_;
						_type_param_size = _tmp842_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp843_;
							gint _tmp844_;
							gint _tmp845_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp846_;
							gint _tmp847_;
							gpointer _tmp848_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp849_;
							ValaCCodeIdentifier* _tmp850_;
							ValaCCodeMemberAccess* _tmp851_;
							ValaCCodeMemberAccess* _tmp852_;
							gchar** _tmp853_;
							gint _tmp853__length1;
							_tmp843_ = _type_param_index;
							_type_param_index = _tmp843_ + 1;
							_tmp844_ = _type_param_index;
							_tmp845_ = _type_param_size;
							if (!(_tmp844_ < _tmp845_)) {
								break;
							}
							_tmp846_ = _type_param_list;
							_tmp847_ = _type_param_index;
							_tmp848_ = vala_list_get (_tmp846_, _tmp847_);
							type_param = (ValaTypeParameter*) _tmp848_;
							_tmp849_ = vala_ccode_identifier_new ("self");
							_tmp850_ = _tmp849_;
							_tmp851_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp850_, "priv");
							_tmp852_ = _tmp851_;
							_vala_ccode_node_unref0 (_tmp850_);
							priv_access = _tmp852_;
							_tmp853_ = suffices;
							_tmp853__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp853_;
								suffix_collection_length1 = _tmp853__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp854_;
									gchar* suffix = NULL;
									_tmp854_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp854_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp855_;
										const gchar* _tmp856_;
										const gchar* _tmp857_;
										gchar* _tmp858_;
										gchar* _tmp859_;
										const gchar* _tmp860_;
										gchar* _tmp861_;
										gchar* _tmp862_;
										ValaCCodeIdentifier* _tmp863_;
										ValaCCodeIdentifier* _tmp864_;
										ValaCCodeFunction* _tmp865_;
										ValaCCodeFunction* _tmp866_;
										ValaCCodeMemberAccess* _tmp867_;
										ValaCCodeIdentifier* _tmp868_;
										const gchar* _tmp869_;
										const gchar* _tmp870_;
										ValaCCodeMemberAccess* _tmp871_;
										ValaCCodeMemberAccess* _tmp872_;
										ValaCCodeIdentifier* _tmp873_;
										_tmp855_ = type_param;
										_tmp856_ = vala_symbol_get_name ((ValaSymbol*) _tmp855_);
										_tmp857_ = _tmp856_;
										_tmp858_ = g_utf8_strdown (_tmp857_, (gssize) -1);
										_tmp859_ = _tmp858_;
										_tmp860_ = suffix;
										_tmp861_ = g_strdup_printf ("%s_%s", _tmp859_, _tmp860_);
										_tmp862_ = _tmp861_;
										_tmp863_ = vala_ccode_identifier_new (_tmp862_);
										_tmp864_ = _tmp863_;
										_g_free0 (_tmp862_);
										_g_free0 (_tmp859_);
										param_name = _tmp864_;
										_tmp865_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp866_ = _tmp865_;
										_tmp867_ = priv_access;
										_tmp868_ = param_name;
										_tmp869_ = vala_ccode_identifier_get_name (_tmp868_);
										_tmp870_ = _tmp869_;
										_tmp871_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp867_, _tmp870_);
										_tmp872_ = _tmp871_;
										_tmp873_ = param_name;
										vala_ccode_function_add_assignment (_tmp866_, (ValaCCodeExpression*) _tmp872_, (ValaCCodeExpression*) _tmp873_);
										_vala_ccode_node_unref0 (_tmp872_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp874_ = params;
	_tmp875_ = vala_iterable_iterator ((ValaIterable*) _tmp874_);
	params_it = _tmp875_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp876_;
		gint _arg_size = 0;
		ValaList* _tmp877_;
		gint _tmp878_;
		gint _tmp879_;
		gint _arg_index = 0;
		_tmp876_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp876_;
		_tmp877_ = _arg_list;
		_tmp878_ = vala_collection_get_size ((ValaCollection*) _tmp877_);
		_tmp879_ = _tmp878_;
		_arg_size = _tmp879_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp880_;
			gint _tmp881_;
			gint _tmp882_;
			ValaExpression* arg = NULL;
			ValaList* _tmp883_;
			gint _tmp884_;
			gpointer _tmp885_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp886_;
			ValaCCodeExpression* _tmp887_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp888_;
			ValaHashMap* _tmp889_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp890_;
			gboolean _tmp900_ = FALSE;
			ValaParameter* _tmp901_;
			gdouble _tmp1239_ = 0.0;
			ValaParameter* _tmp1240_;
			gboolean _tmp1243_;
			ValaHashMap* _tmp1244_;
			gint _tmp1245_;
			ValaCCodeExpression* _tmp1246_;
			gboolean _tmp1247_ = FALSE;
			ValaExpression* _tmp1248_;
			gint _tmp1268_;
			_tmp880_ = _arg_index;
			_arg_index = _tmp880_ + 1;
			_tmp881_ = _arg_index;
			_tmp882_ = _arg_size;
			if (!(_tmp881_ < _tmp882_)) {
				break;
			}
			_tmp883_ = _arg_list;
			_tmp884_ = _arg_index;
			_tmp885_ = vala_list_get (_tmp883_, _tmp884_);
			arg = (ValaExpression*) _tmp885_;
			_tmp886_ = arg;
			_tmp887_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp886_);
			cexpr = _tmp887_;
			_tmp888_ = in_arg_map;
			_tmp889_ = _vala_map_ref0 (_tmp888_);
			carg_map = _tmp889_;
			param = NULL;
			_tmp890_ = params_it;
			if (vala_iterator_next (_tmp890_)) {
				ValaIterator* _tmp891_;
				gpointer _tmp892_;
				gboolean _tmp893_ = FALSE;
				ValaParameter* _tmp894_;
				gboolean _tmp895_;
				gboolean _tmp896_;
				_tmp891_ = params_it;
				_tmp892_ = vala_iterator_get (_tmp891_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp892_;
				_tmp894_ = param;
				_tmp895_ = vala_parameter_get_params_array (_tmp894_);
				_tmp896_ = _tmp895_;
				if (_tmp896_) {
					_tmp893_ = TRUE;
				} else {
					ValaParameter* _tmp897_;
					gboolean _tmp898_;
					gboolean _tmp899_;
					_tmp897_ = param;
					_tmp898_ = vala_parameter_get_ellipsis (_tmp897_);
					_tmp899_ = _tmp898_;
					_tmp893_ = _tmp899_;
				}
				ellipsis = _tmp893_;
			}
			_tmp901_ = param;
			if (_tmp901_ != NULL) {
				gboolean _tmp902_;
				_tmp902_ = ellipsis;
				_tmp900_ = !_tmp902_;
			} else {
				_tmp900_ = FALSE;
			}
			if (_tmp900_) {
				ValaParameter* _tmp903_;
				ValaParameterDirection _tmp904_;
				ValaParameterDirection _tmp905_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp908_;
				ValaUnaryExpression* _tmp909_;
				gboolean _tmp910_ = FALSE;
				ValaUnaryExpression* _tmp911_;
				ValaParameter* _tmp1189_;
				gchar* _tmp1190_;
				gchar* _tmp1191_;
				gboolean _tmp1192_;
				_tmp903_ = param;
				_tmp904_ = vala_parameter_get_direction (_tmp903_);
				_tmp905_ = _tmp904_;
				if (_tmp905_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp906_;
					ValaHashMap* _tmp907_;
					_tmp906_ = out_arg_map;
					_tmp907_ = _vala_map_ref0 (_tmp906_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp907_;
				}
				_tmp908_ = arg;
				_tmp909_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp908_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp908_) : NULL);
				unary = _tmp909_;
				_tmp911_ = unary;
				if (_tmp911_ == NULL) {
					_tmp910_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp912_;
					ValaUnaryOperator _tmp913_;
					ValaUnaryOperator _tmp914_;
					_tmp912_ = unary;
					_tmp913_ = vala_unary_expression_get_operator (_tmp912_);
					_tmp914_ = _tmp913_;
					_tmp910_ = _tmp914_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp910_) {
					gboolean _tmp915_ = FALSE;
					gboolean _tmp916_ = FALSE;
					ValaParameter* _tmp917_;
					ValaParameter* _tmp1059_;
					ValaExpression* _tmp1060_;
					ValaCCodeExpression* _tmp1061_;
					ValaCCodeExpression* _tmp1062_;
					_tmp917_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp917_)) {
						ValaParameter* _tmp918_;
						ValaDataType* _tmp919_;
						ValaDataType* _tmp920_;
						_tmp918_ = param;
						_tmp919_ = vala_variable_get_variable_type ((ValaVariable*) _tmp918_);
						_tmp920_ = _tmp919_;
						_tmp916_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp920_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp916_ = FALSE;
					}
					if (_tmp916_) {
						ValaParameter* _tmp921_;
						ValaDataType* _tmp922_;
						ValaDataType* _tmp923_;
						gboolean _tmp924_;
						gboolean _tmp925_;
						_tmp921_ = param;
						_tmp922_ = vala_variable_get_variable_type ((ValaVariable*) _tmp921_);
						_tmp923_ = _tmp922_;
						_tmp924_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp923_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp925_ = _tmp924_;
						_tmp915_ = !_tmp925_;
					} else {
						_tmp915_ = FALSE;
					}
					if (_tmp915_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp926_;
						ValaDataType* _tmp927_;
						ValaDataType* _tmp928_;
						ValaArrayType* _tmp929_;
						_tmp926_ = param;
						_tmp927_ = vala_variable_get_variable_type ((ValaVariable*) _tmp926_);
						_tmp928_ = _tmp927_;
						_tmp929_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp928_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp929_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp930_ = FALSE;
								_tmp930_ = TRUE;
								while (TRUE) {
									gint _tmp932_;
									ValaArrayType* _tmp933_;
									gint _tmp934_;
									gint _tmp935_;
									ValaCCodeExpression* array_length_expr = NULL;
									ValaParameter* _tmp936_;
									gchar* _tmp937_;
									gchar* _tmp938_;
									gboolean _tmp939_;
									ValaHashMap* _tmp958_;
									ValaParameter* _tmp959_;
									gint _tmp960_;
									ValaCCodeExpression* _tmp961_;
									if (!_tmp930_) {
										gint _tmp931_;
										_tmp931_ = dim;
										dim = _tmp931_ + 1;
									}
									_tmp930_ = FALSE;
									_tmp932_ = dim;
									_tmp933_ = array_type;
									_tmp934_ = vala_array_type_get_rank (_tmp933_);
									_tmp935_ = _tmp934_;
									if (!(_tmp932_ <= _tmp935_)) {
										break;
									}
									array_length_expr = NULL;
									_tmp936_ = param;
									_tmp937_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp936_);
									_tmp938_ = _tmp937_;
									_tmp939_ = _tmp938_ != NULL;
									_g_free0 (_tmp938_);
									if (_tmp939_) {
										gchar* length_ctype = NULL;
										ValaParameter* _tmp940_;
										gchar* _tmp941_;
										gboolean _tmp942_ = FALSE;
										ValaUnaryExpression* _tmp943_;
										ValaExpression* _tmp949_;
										gint _tmp950_;
										ValaCCodeExpression* _tmp951_;
										ValaCCodeExpression* _tmp952_;
										const gchar* _tmp953_;
										ValaCCodeCastExpression* _tmp954_;
										_tmp940_ = param;
										_tmp941_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp940_);
										length_ctype = _tmp941_;
										_tmp943_ = unary;
										if (_tmp943_ != NULL) {
											ValaUnaryExpression* _tmp944_;
											ValaUnaryOperator _tmp945_;
											ValaUnaryOperator _tmp946_;
											_tmp944_ = unary;
											_tmp945_ = vala_unary_expression_get_operator (_tmp944_);
											_tmp946_ = _tmp945_;
											_tmp942_ = _tmp946_ == VALA_UNARY_OPERATOR_REF;
										} else {
											_tmp942_ = FALSE;
										}
										if (_tmp942_) {
											const gchar* _tmp947_;
											gchar* _tmp948_;
											_tmp947_ = length_ctype;
											_tmp948_ = g_strdup_printf ("%s*", _tmp947_);
											_g_free0 (length_ctype);
											length_ctype = _tmp948_;
										}
										_tmp949_ = arg;
										_tmp950_ = dim;
										_tmp951_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp949_, _tmp950_);
										_tmp952_ = _tmp951_;
										_tmp953_ = length_ctype;
										_tmp954_ = vala_ccode_cast_expression_new (_tmp952_, _tmp953_);
										_vala_ccode_node_unref0 (array_length_expr);
										array_length_expr = (ValaCCodeExpression*) _tmp954_;
										_vala_ccode_node_unref0 (_tmp952_);
										_g_free0 (length_ctype);
									} else {
										ValaExpression* _tmp955_;
										gint _tmp956_;
										ValaCCodeExpression* _tmp957_;
										_tmp955_ = arg;
										_tmp956_ = dim;
										_tmp957_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp955_, _tmp956_);
										_vala_ccode_node_unref0 (array_length_expr);
										array_length_expr = _tmp957_;
									}
									_tmp958_ = carg_map;
									_tmp959_ = param;
									_tmp960_ = dim;
									_tmp961_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp958_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp959_) + (0.01 * _tmp960_), FALSE)), _tmp961_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp962_;
						ValaDataType* _tmp963_;
						ValaDataType* _tmp964_;
						_tmp962_ = param;
						_tmp963_ = vala_variable_get_variable_type ((ValaVariable*) _tmp962_);
						_tmp964_ = _tmp963_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp964_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp965_;
							ValaDataType* _tmp966_;
							ValaDataType* _tmp967_;
							ValaDelegateType* _tmp968_;
							ValaDelegateType* _tmp969_;
							ValaDelegate* _tmp970_;
							ValaDelegate* _tmp971_;
							gboolean _tmp972_;
							gboolean _tmp973_;
							_tmp965_ = param;
							_tmp966_ = vala_variable_get_variable_type ((ValaVariable*) _tmp965_);
							_tmp967_ = _tmp966_;
							_tmp968_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp967_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp968_;
							_tmp969_ = deleg_type;
							_tmp970_ = vala_delegate_type_get_delegate_symbol (_tmp969_);
							_tmp971_ = _tmp970_;
							_tmp972_ = vala_delegate_get_has_target (_tmp971_);
							_tmp973_ = _tmp972_;
							if (_tmp973_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp974_;
								ValaCCodeExpression* _tmp975_ = NULL;
								ValaCCodeExpression* _tmp976_;
								ValaCCodeExpression* _tmp977_;
								ValaParameter* _tmp978_;
								gchar* _tmp979_;
								gchar* _tmp980_;
								gboolean _tmp981_;
								_tmp974_ = arg;
								_tmp976_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp974_, &_tmp975_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp975_;
								delegate_target = _tmp976_;
								_tmp977_ = delegate_target;
								_vala_assert (_tmp977_ != NULL, "delegate_target != null");
								_tmp978_ = param;
								_tmp979_ = vala_get_ccode_type ((ValaCodeNode*) _tmp978_);
								_tmp980_ = _tmp979_;
								_tmp981_ = g_strcmp0 (_tmp980_, "GClosure*") == 0;
								_g_free0 (_tmp980_);
								if (_tmp981_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp982_;
									ValaCCodeIdentifier* _tmp983_;
									ValaCCodeFunctionCall* _tmp984_;
									ValaCCodeFunctionCall* _tmp985_;
									ValaCCodeFunctionCall* _tmp986_;
									ValaCCodeExpression* _tmp987_;
									ValaCCodeCastExpression* _tmp988_;
									ValaCCodeCastExpression* _tmp989_;
									ValaCCodeFunctionCall* _tmp990_;
									ValaCCodeExpression* _tmp991_;
									ValaCCodeFunctionCall* _tmp992_;
									ValaCCodeExpression* _tmp993_;
									ValaCCodeCastExpression* _tmp994_;
									ValaCCodeCastExpression* _tmp995_;
									ValaCCodeExpression* _tmp996_;
									ValaCCodeIdentifier* _tmp997_;
									ValaCCodeIdentifier* _tmp998_;
									ValaCCodeBinaryExpression* _tmp999_;
									ValaCCodeBinaryExpression* _tmp1000_;
									ValaCCodeIdentifier* _tmp1001_;
									ValaCCodeIdentifier* _tmp1002_;
									ValaCCodeFunctionCall* _tmp1003_;
									ValaCCodeConditionalExpression* _tmp1004_;
									_tmp982_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp983_ = _tmp982_;
									_tmp984_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp983_);
									_tmp985_ = _tmp984_;
									_vala_ccode_node_unref0 (_tmp983_);
									closure_new = _tmp985_;
									_tmp986_ = closure_new;
									_tmp987_ = cexpr;
									_tmp988_ = vala_ccode_cast_expression_new (_tmp987_, "GCallback");
									_tmp989_ = _tmp988_;
									vala_ccode_function_call_add_argument (_tmp986_, (ValaCCodeExpression*) _tmp989_);
									_vala_ccode_node_unref0 (_tmp989_);
									_tmp990_ = closure_new;
									_tmp991_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp990_, _tmp991_);
									_tmp992_ = closure_new;
									_tmp993_ = delegate_target_destroy_notify;
									_tmp994_ = vala_ccode_cast_expression_new (_tmp993_, "GClosureNotify");
									_tmp995_ = _tmp994_;
									vala_ccode_function_call_add_argument (_tmp992_, (ValaCCodeExpression*) _tmp995_);
									_vala_ccode_node_unref0 (_tmp995_);
									_tmp996_ = cexpr;
									_tmp997_ = vala_ccode_identifier_new ("NULL");
									_tmp998_ = _tmp997_;
									_tmp999_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp996_, (ValaCCodeExpression*) _tmp998_);
									_tmp1000_ = _tmp999_;
									_tmp1001_ = vala_ccode_identifier_new ("NULL");
									_tmp1002_ = _tmp1001_;
									_tmp1003_ = closure_new;
									_tmp1004_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1000_, (ValaCCodeExpression*) _tmp1002_, (ValaCCodeExpression*) _tmp1003_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1004_;
									_vala_ccode_node_unref0 (_tmp1002_);
									_vala_ccode_node_unref0 (_tmp1000_);
									_vala_ccode_node_unref0 (_tmp998_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaHashMap* _tmp1005_;
									ValaParameter* _tmp1006_;
									ValaCCodeExpression* _tmp1007_;
									ValaDelegateType* _tmp1008_;
									_tmp1005_ = carg_map;
									_tmp1006_ = param;
									_tmp1007_ = delegate_target;
									vala_map_set ((ValaMap*) _tmp1005_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1006_), FALSE)), _tmp1007_);
									_tmp1008_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1008_)) {
										ValaCCodeExpression* _tmp1009_;
										ValaHashMap* _tmp1010_;
										ValaParameter* _tmp1011_;
										ValaCCodeExpression* _tmp1012_;
										_tmp1009_ = delegate_target_destroy_notify;
										_vala_assert (_tmp1009_ != NULL, "delegate_target_destroy_notify != null");
										_tmp1010_ = carg_map;
										_tmp1011_ = param;
										_tmp1012_ = delegate_target_destroy_notify;
										vala_map_set ((ValaMap*) _tmp1010_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1011_) + 0.01, FALSE)), _tmp1012_);
									}
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1013_;
							ValaDataType* _tmp1014_;
							ValaDataType* _tmp1015_;
							_tmp1013_ = param;
							_tmp1014_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1013_);
							_tmp1015_ = _tmp1014_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1015_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1016_;
								ValaParameter* _tmp1017_;
								ValaExpression* _tmp1018_;
								ValaCCodeExpression* _tmp1019_ = NULL;
								ValaCCodeExpression* _tmp1020_;
								ValaCCodeExpression* _tmp1021_;
								_tmp1016_ = carg_map;
								_tmp1017_ = param;
								_tmp1018_ = arg;
								_tmp1020_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1018_, &_tmp1019_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1019_;
								_tmp1021_ = _tmp1020_;
								vala_map_set ((ValaMap*) _tmp1016_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1017_), FALSE)), _tmp1021_);
								_vala_ccode_node_unref0 (_tmp1021_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1022_;
								ValaDataType* _tmp1023_;
								ValaDataType* _tmp1024_;
								_tmp1022_ = param;
								_tmp1023_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1022_);
								_tmp1024_ = _tmp1023_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1024_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1025_ = FALSE;
									ValaMethod* _tmp1026_;
									_tmp1026_ = m;
									if (_tmp1026_ != NULL) {
										ValaMethod* _tmp1027_;
										_tmp1027_ = m;
										_tmp1025_ = vala_get_ccode_simple_generics (_tmp1027_);
									} else {
										_tmp1025_ = FALSE;
									}
									if (_tmp1025_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1028_;
										ValaDataType* _tmp1029_;
										ValaDataType* _tmp1030_;
										ValaGenericType* _tmp1031_;
										gint type_param_index = 0;
										ValaMethod* _tmp1032_;
										ValaGenericType* _tmp1033_;
										ValaTypeParameter* _tmp1034_;
										ValaTypeParameter* _tmp1035_;
										const gchar* _tmp1036_;
										const gchar* _tmp1037_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1038_;
										ValaList* _tmp1039_;
										ValaList* _tmp1040_;
										gint _tmp1041_;
										gpointer _tmp1042_;
										ValaDataType* _tmp1043_;
										ValaParameter* _tmp1044_;
										ValaDataType* _tmp1045_;
										ValaDataType* _tmp1046_;
										gboolean _tmp1047_;
										gboolean _tmp1048_;
										_tmp1028_ = param;
										_tmp1029_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1028_);
										_tmp1030_ = _tmp1029_;
										_tmp1031_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1030_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1031_;
										_tmp1032_ = m;
										_tmp1033_ = generic_type;
										_tmp1034_ = vala_generic_type_get_type_parameter (_tmp1033_);
										_tmp1035_ = _tmp1034_;
										_tmp1036_ = vala_symbol_get_name ((ValaSymbol*) _tmp1035_);
										_tmp1037_ = _tmp1036_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1032_, _tmp1037_);
										_tmp1038_ = ma;
										_tmp1039_ = vala_member_access_get_type_arguments (_tmp1038_);
										_tmp1040_ = _tmp1039_;
										_tmp1041_ = type_param_index;
										_tmp1042_ = vala_list_get (_tmp1040_, _tmp1041_);
										_tmp1043_ = (ValaDataType*) _tmp1042_;
										_vala_iterable_unref0 (_tmp1040_);
										type_arg = _tmp1043_;
										_tmp1044_ = param;
										_tmp1045_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1044_);
										_tmp1046_ = _tmp1045_;
										_tmp1047_ = vala_data_type_get_value_owned (_tmp1046_);
										_tmp1048_ = _tmp1047_;
										if (_tmp1048_) {
											ValaDataType* _tmp1049_;
											_tmp1049_ = type_arg;
											if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1049_)) {
												ValaHashMap* _tmp1050_;
												ValaParameter* _tmp1051_;
												ValaDataType* _tmp1052_;
												ValaCCodeExpression* _tmp1053_;
												ValaCCodeExpression* _tmp1054_;
												_tmp1050_ = carg_map;
												_tmp1051_ = param;
												_tmp1052_ = type_arg;
												_tmp1053_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1052_, FALSE);
												_tmp1054_ = _tmp1053_;
												vala_map_set ((ValaMap*) _tmp1050_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1051_), FALSE)), _tmp1054_);
												_vala_ccode_node_unref0 (_tmp1054_);
											} else {
												ValaHashMap* _tmp1055_;
												ValaParameter* _tmp1056_;
												ValaCCodeConstant* _tmp1057_;
												ValaCCodeConstant* _tmp1058_;
												_tmp1055_ = carg_map;
												_tmp1056_ = param;
												_tmp1057_ = vala_ccode_constant_new ("NULL");
												_tmp1058_ = _tmp1057_;
												vala_map_set ((ValaMap*) _tmp1055_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1056_), FALSE)), (ValaCCodeExpression*) _tmp1058_);
												_vala_ccode_node_unref0 (_tmp1058_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1059_ = param;
					_tmp1060_ = arg;
					_tmp1061_ = cexpr;
					_tmp1062_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1059_, _tmp1060_, _tmp1061_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1062_;
				} else {
					ValaExpression* _tmp1063_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1064_;
					ValaDataType* _tmp1065_;
					ValaDataType* _tmp1066_;
					ValaParameter* _tmp1067_;
					ValaDataType* _tmp1068_;
					ValaDataType* _tmp1069_;
					gboolean _tmp1070_;
					gboolean _tmp1071_;
					ValaLocalVariable* _tmp1072_;
					ValaLocalVariable* _tmp1073_;
					ValaExpression* _tmp1074_;
					ValaLocalVariable* _tmp1075_;
					const gchar* _tmp1076_;
					const gchar* _tmp1077_;
					ValaCCodeExpression* _tmp1078_;
					ValaCCodeExpression* _tmp1079_;
					ValaExpression* _tmp1080_;
					ValaTargetValue* _tmp1081_;
					ValaTargetValue* _tmp1082_;
					ValaExpression* _tmp1083_;
					ValaDataType* _tmp1084_;
					ValaDataType* _tmp1085_;
					ValaExpression* _tmp1086_;
					ValaCCodeExpression* _tmp1087_;
					ValaCCodeExpression* _tmp1088_;
					ValaCCodeUnaryExpression* _tmp1089_;
					gboolean _tmp1090_ = FALSE;
					gboolean _tmp1091_ = FALSE;
					ValaParameter* _tmp1092_;
					_tmp1063_ = arg;
					vala_expression_set_target_value (_tmp1063_, NULL);
					_tmp1064_ = param;
					_tmp1065_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1064_);
					_tmp1066_ = _tmp1065_;
					_tmp1067_ = param;
					_tmp1068_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1067_);
					_tmp1069_ = _tmp1068_;
					_tmp1070_ = vala_data_type_get_value_owned (_tmp1069_);
					_tmp1071_ = _tmp1070_;
					_tmp1072_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1066_, _tmp1071_, NULL, TRUE);
					temp_var = _tmp1072_;
					_tmp1073_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1073_, FALSE);
					_tmp1074_ = arg;
					_tmp1075_ = temp_var;
					_tmp1076_ = vala_symbol_get_name ((ValaSymbol*) _tmp1075_);
					_tmp1077_ = _tmp1076_;
					_tmp1078_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1077_);
					_tmp1079_ = _tmp1078_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1074_, _tmp1079_);
					_vala_ccode_node_unref0 (_tmp1079_);
					_tmp1080_ = arg;
					_tmp1081_ = vala_expression_get_target_value (_tmp1080_);
					_tmp1082_ = _tmp1081_;
					_tmp1083_ = arg;
					_tmp1084_ = vala_expression_get_target_type (_tmp1083_);
					_tmp1085_ = _tmp1084_;
					vala_target_value_set_value_type (_tmp1082_, _tmp1085_);
					_tmp1086_ = arg;
					_tmp1087_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1086_);
					_tmp1088_ = _tmp1087_;
					_tmp1089_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1088_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1089_;
					_vala_ccode_node_unref0 (_tmp1088_);
					_tmp1092_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1092_)) {
						ValaParameter* _tmp1093_;
						ValaDataType* _tmp1094_;
						ValaDataType* _tmp1095_;
						_tmp1093_ = param;
						_tmp1094_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1093_);
						_tmp1095_ = _tmp1094_;
						_tmp1091_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1095_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1091_ = FALSE;
					}
					if (_tmp1091_) {
						ValaParameter* _tmp1096_;
						ValaDataType* _tmp1097_;
						ValaDataType* _tmp1098_;
						gboolean _tmp1099_;
						gboolean _tmp1100_;
						_tmp1096_ = param;
						_tmp1097_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1096_);
						_tmp1098_ = _tmp1097_;
						_tmp1099_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1098_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1100_ = _tmp1099_;
						_tmp1090_ = !_tmp1100_;
					} else {
						_tmp1090_ = FALSE;
					}
					if (_tmp1090_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1101_;
						ValaDataType* _tmp1102_;
						ValaDataType* _tmp1103_;
						ValaArrayType* _tmp1104_;
						ValaDataType* array_length_type = NULL;
						ValaDataType* _tmp1105_;
						ValaDataType* _tmp1106_;
						ValaParameter* _tmp1107_;
						gchar* _tmp1108_;
						gchar* _tmp1109_;
						gboolean _tmp1110_;
						_tmp1101_ = param;
						_tmp1102_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1101_);
						_tmp1103_ = _tmp1102_;
						_tmp1104_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1103_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1104_;
						_tmp1105_ = ((ValaCCodeBaseModule*) self)->int_type;
						_tmp1106_ = _vala_code_node_ref0 (_tmp1105_);
						array_length_type = _tmp1106_;
						_tmp1107_ = param;
						_tmp1108_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1107_);
						_tmp1109_ = _tmp1108_;
						_tmp1110_ = _tmp1109_ != NULL;
						_g_free0 (_tmp1109_);
						if (_tmp1110_) {
							ValaParameter* _tmp1111_;
							gchar* _tmp1112_;
							gchar* _tmp1113_;
							ValaCType* _tmp1114_;
							_tmp1111_ = param;
							_tmp1112_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1111_);
							_tmp1113_ = _tmp1112_;
							_tmp1114_ = vala_ctype_new (_tmp1113_, "0");
							_vala_code_node_unref0 (array_length_type);
							array_length_type = (ValaDataType*) _tmp1114_;
							_g_free0 (_tmp1113_);
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1115_ = FALSE;
								_tmp1115_ = TRUE;
								while (TRUE) {
									gint _tmp1117_;
									ValaArrayType* _tmp1118_;
									gint _tmp1119_;
									gint _tmp1120_;
									ValaLocalVariable* temp_array_length = NULL;
									ValaDataType* _tmp1121_;
									ValaLocalVariable* _tmp1122_;
									ValaLocalVariable* _tmp1123_;
									ValaExpression* _tmp1124_;
									ValaLocalVariable* _tmp1125_;
									const gchar* _tmp1126_;
									const gchar* _tmp1127_;
									ValaCCodeExpression* _tmp1128_;
									ValaCCodeExpression* _tmp1129_;
									ValaHashMap* _tmp1130_;
									ValaParameter* _tmp1131_;
									gint _tmp1132_;
									ValaExpression* _tmp1133_;
									ValaList* _tmp1134_;
									ValaList* _tmp1135_;
									gint _tmp1136_;
									gpointer _tmp1137_;
									ValaCCodeExpression* _tmp1138_;
									ValaCCodeUnaryExpression* _tmp1139_;
									ValaCCodeUnaryExpression* _tmp1140_;
									if (!_tmp1115_) {
										gint _tmp1116_;
										_tmp1116_ = dim;
										dim = _tmp1116_ + 1;
									}
									_tmp1115_ = FALSE;
									_tmp1117_ = dim;
									_tmp1118_ = array_type;
									_tmp1119_ = vala_array_type_get_rank (_tmp1118_);
									_tmp1120_ = _tmp1119_;
									if (!(_tmp1117_ <= _tmp1120_)) {
										break;
									}
									_tmp1121_ = array_length_type;
									_tmp1122_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1121_, TRUE, NULL, FALSE);
									temp_array_length = _tmp1122_;
									_tmp1123_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1123_, FALSE);
									_tmp1124_ = arg;
									_tmp1125_ = temp_array_length;
									_tmp1126_ = vala_symbol_get_name ((ValaSymbol*) _tmp1125_);
									_tmp1127_ = _tmp1126_;
									_tmp1128_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1127_);
									_tmp1129_ = _tmp1128_;
									vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1124_, _tmp1129_);
									_vala_ccode_node_unref0 (_tmp1129_);
									_tmp1130_ = carg_map;
									_tmp1131_ = param;
									_tmp1132_ = dim;
									_tmp1133_ = arg;
									_tmp1134_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1133_);
									_tmp1135_ = _tmp1134_;
									_tmp1136_ = dim;
									_tmp1137_ = vala_list_get (_tmp1135_, _tmp1136_ - 1);
									_tmp1138_ = (ValaCCodeExpression*) _tmp1137_;
									_tmp1139_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1138_);
									_tmp1140_ = _tmp1139_;
									vala_map_set ((ValaMap*) _tmp1130_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1131_) + (0.01 * _tmp1132_), FALSE)), (ValaCCodeExpression*) _tmp1140_);
									_vala_ccode_node_unref0 (_tmp1140_);
									_vala_ccode_node_unref0 (_tmp1138_);
									_vala_iterable_unref0 (_tmp1135_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_vala_code_node_unref0 (array_length_type);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp1141_;
						ValaDataType* _tmp1142_;
						ValaDataType* _tmp1143_;
						_tmp1141_ = param;
						_tmp1142_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1141_);
						_tmp1143_ = _tmp1142_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1143_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1144_;
							ValaDataType* _tmp1145_;
							ValaDataType* _tmp1146_;
							ValaDelegateType* _tmp1147_;
							ValaDelegateType* _tmp1148_;
							ValaDelegate* _tmp1149_;
							ValaDelegate* _tmp1150_;
							gboolean _tmp1151_;
							gboolean _tmp1152_;
							_tmp1144_ = param;
							_tmp1145_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1144_);
							_tmp1146_ = _tmp1145_;
							_tmp1147_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1146_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1147_;
							_tmp1148_ = deleg_type;
							_tmp1149_ = vala_delegate_type_get_delegate_symbol (_tmp1148_);
							_tmp1150_ = _tmp1149_;
							_tmp1151_ = vala_delegate_get_has_target (_tmp1150_);
							_tmp1152_ = _tmp1151_;
							if (_tmp1152_) {
								ValaVoidType* _tmp1153_;
								ValaVoidType* _tmp1154_;
								ValaPointerType* _tmp1155_;
								ValaPointerType* _tmp1156_;
								ValaLocalVariable* _tmp1157_;
								ValaLocalVariable* _tmp1158_;
								ValaExpression* _tmp1159_;
								ValaLocalVariable* _tmp1160_;
								const gchar* _tmp1161_;
								const gchar* _tmp1162_;
								ValaCCodeExpression* _tmp1163_;
								ValaCCodeExpression* _tmp1164_;
								ValaHashMap* _tmp1165_;
								ValaParameter* _tmp1166_;
								ValaExpression* _tmp1167_;
								ValaCCodeExpression* _tmp1168_;
								ValaCCodeExpression* _tmp1169_;
								ValaCCodeUnaryExpression* _tmp1170_;
								ValaCCodeUnaryExpression* _tmp1171_;
								ValaDelegateType* _tmp1172_;
								_tmp1153_ = vala_void_type_new (NULL);
								_tmp1154_ = _tmp1153_;
								_tmp1155_ = vala_pointer_type_new ((ValaDataType*) _tmp1154_, NULL);
								_tmp1156_ = _tmp1155_;
								_tmp1157_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1156_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1157_;
								_vala_code_node_unref0 (_tmp1156_);
								_vala_code_node_unref0 (_tmp1154_);
								_tmp1158_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1158_, FALSE);
								_tmp1159_ = arg;
								_tmp1160_ = temp_var;
								_tmp1161_ = vala_symbol_get_name ((ValaSymbol*) _tmp1160_);
								_tmp1162_ = _tmp1161_;
								_tmp1163_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1162_);
								_tmp1164_ = _tmp1163_;
								vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1159_, _tmp1164_);
								_vala_ccode_node_unref0 (_tmp1164_);
								_tmp1165_ = carg_map;
								_tmp1166_ = param;
								_tmp1167_ = arg;
								_tmp1168_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1167_);
								_tmp1169_ = _tmp1168_;
								_tmp1170_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1169_);
								_tmp1171_ = _tmp1170_;
								vala_map_set ((ValaMap*) _tmp1165_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1166_), FALSE)), (ValaCCodeExpression*) _tmp1171_);
								_vala_ccode_node_unref0 (_tmp1171_);
								_vala_ccode_node_unref0 (_tmp1169_);
								_tmp1172_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1172_)) {
									ValaDataType* _tmp1173_;
									ValaLocalVariable* _tmp1174_;
									ValaLocalVariable* _tmp1175_;
									ValaExpression* _tmp1176_;
									ValaLocalVariable* _tmp1177_;
									const gchar* _tmp1178_;
									const gchar* _tmp1179_;
									ValaCCodeExpression* _tmp1180_;
									ValaCCodeExpression* _tmp1181_;
									ValaHashMap* _tmp1182_;
									ValaParameter* _tmp1183_;
									ValaExpression* _tmp1184_;
									ValaCCodeExpression* _tmp1185_;
									ValaCCodeExpression* _tmp1186_;
									ValaCCodeUnaryExpression* _tmp1187_;
									ValaCCodeUnaryExpression* _tmp1188_;
									_tmp1173_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
									_tmp1174_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1173_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1174_;
									_tmp1175_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1175_, FALSE);
									_tmp1176_ = arg;
									_tmp1177_ = temp_var;
									_tmp1178_ = vala_symbol_get_name ((ValaSymbol*) _tmp1177_);
									_tmp1179_ = _tmp1178_;
									_tmp1180_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1179_);
									_tmp1181_ = _tmp1180_;
									vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1176_, _tmp1181_);
									_vala_ccode_node_unref0 (_tmp1181_);
									_tmp1182_ = carg_map;
									_tmp1183_ = param;
									_tmp1184_ = arg;
									_tmp1185_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1184_);
									_tmp1186_ = _tmp1185_;
									_tmp1187_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1186_);
									_tmp1188_ = _tmp1187_;
									vala_map_set ((ValaMap*) _tmp1182_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1183_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1188_);
									_vala_ccode_node_unref0 (_tmp1188_);
									_vala_ccode_node_unref0 (_tmp1186_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1189_ = param;
				_tmp1190_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1189_);
				_tmp1191_ = _tmp1190_;
				_tmp1192_ = _tmp1191_ != NULL;
				_g_free0 (_tmp1191_);
				if (_tmp1192_) {
					ValaCCodeExpression* _tmp1193_;
					ValaParameter* _tmp1194_;
					gchar* _tmp1195_;
					gchar* _tmp1196_;
					ValaCCodeCastExpression* _tmp1197_;
					_tmp1193_ = cexpr;
					_tmp1194_ = param;
					_tmp1195_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1194_);
					_tmp1196_ = _tmp1195_;
					_tmp1197_ = vala_ccode_cast_expression_new (_tmp1193_, _tmp1196_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1197_;
					_g_free0 (_tmp1196_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1198_;
				ValaUnaryExpression* _tmp1199_;
				gboolean _tmp1200_ = FALSE;
				gboolean _tmp1201_ = FALSE;
				gboolean _tmp1202_;
				_tmp1198_ = arg;
				_tmp1199_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1198_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1198_) : NULL);
				unary = _tmp1199_;
				_tmp1202_ = ellipsis;
				if (_tmp1202_) {
					ValaUnaryExpression* _tmp1203_;
					_tmp1203_ = unary;
					_tmp1201_ = _tmp1203_ != NULL;
				} else {
					_tmp1201_ = FALSE;
				}
				if (_tmp1201_) {
					ValaUnaryExpression* _tmp1204_;
					ValaUnaryOperator _tmp1205_;
					ValaUnaryOperator _tmp1206_;
					_tmp1204_ = unary;
					_tmp1205_ = vala_unary_expression_get_operator (_tmp1204_);
					_tmp1206_ = _tmp1205_;
					_tmp1200_ = _tmp1206_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1200_ = FALSE;
				}
				if (_tmp1200_) {
					ValaHashMap* _tmp1207_;
					ValaHashMap* _tmp1208_;
					ValaExpression* _tmp1209_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1210_;
					ValaDataType* _tmp1211_;
					ValaDataType* _tmp1212_;
					ValaExpression* _tmp1213_;
					ValaDataType* _tmp1214_;
					ValaDataType* _tmp1215_;
					gboolean _tmp1216_;
					gboolean _tmp1217_;
					ValaLocalVariable* _tmp1218_;
					ValaLocalVariable* _tmp1219_;
					ValaExpression* _tmp1220_;
					ValaLocalVariable* _tmp1221_;
					const gchar* _tmp1222_;
					const gchar* _tmp1223_;
					ValaCCodeExpression* _tmp1224_;
					ValaCCodeExpression* _tmp1225_;
					ValaExpression* _tmp1226_;
					ValaTargetValue* _tmp1227_;
					ValaTargetValue* _tmp1228_;
					ValaExpression* _tmp1229_;
					ValaDataType* _tmp1230_;
					ValaDataType* _tmp1231_;
					ValaExpression* _tmp1232_;
					ValaCCodeExpression* _tmp1233_;
					ValaCCodeExpression* _tmp1234_;
					ValaCCodeUnaryExpression* _tmp1235_;
					_tmp1207_ = out_arg_map;
					_tmp1208_ = _vala_map_ref0 (_tmp1207_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1208_;
					_tmp1209_ = arg;
					vala_expression_set_target_value (_tmp1209_, NULL);
					_tmp1210_ = arg;
					_tmp1211_ = vala_expression_get_value_type (_tmp1210_);
					_tmp1212_ = _tmp1211_;
					_tmp1213_ = arg;
					_tmp1214_ = vala_expression_get_value_type (_tmp1213_);
					_tmp1215_ = _tmp1214_;
					_tmp1216_ = vala_data_type_get_value_owned (_tmp1215_);
					_tmp1217_ = _tmp1216_;
					_tmp1218_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1212_, _tmp1217_, NULL, TRUE);
					temp_var = _tmp1218_;
					_tmp1219_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1219_, FALSE);
					_tmp1220_ = arg;
					_tmp1221_ = temp_var;
					_tmp1222_ = vala_symbol_get_name ((ValaSymbol*) _tmp1221_);
					_tmp1223_ = _tmp1222_;
					_tmp1224_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1223_);
					_tmp1225_ = _tmp1224_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1220_, _tmp1225_);
					_vala_ccode_node_unref0 (_tmp1225_);
					_tmp1226_ = arg;
					_tmp1227_ = vala_expression_get_target_value (_tmp1226_);
					_tmp1228_ = _tmp1227_;
					_tmp1229_ = arg;
					_tmp1230_ = vala_expression_get_value_type (_tmp1229_);
					_tmp1231_ = _tmp1230_;
					vala_target_value_set_value_type (_tmp1228_, _tmp1231_);
					_tmp1232_ = arg;
					_tmp1233_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1232_);
					_tmp1234_ = _tmp1233_;
					_tmp1235_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1234_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1235_;
					_vala_ccode_node_unref0 (_tmp1234_);
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1236_;
					ValaCCodeExpression* _tmp1237_;
					ValaCCodeExpression* _tmp1238_;
					_tmp1236_ = arg;
					_tmp1237_ = cexpr;
					_tmp1238_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1236_, _tmp1237_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1238_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1240_ = param;
			if (_tmp1240_ != NULL) {
				ValaParameter* _tmp1241_;
				_tmp1241_ = param;
				_tmp1239_ = vala_get_ccode_pos (_tmp1241_);
			} else {
				gint _tmp1242_;
				_tmp1242_ = i;
				_tmp1239_ = (gdouble) _tmp1242_;
			}
			_tmp1243_ = ellipsis;
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1239_, _tmp1243_);
			_tmp1244_ = carg_map;
			_tmp1245_ = arg_pos;
			_tmp1246_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1244_, (gpointer) ((gintptr) _tmp1245_), _tmp1246_);
			_tmp1248_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1248_, VALA_TYPE_NAMED_ARGUMENT)) {
				gboolean _tmp1249_;
				_tmp1249_ = ellipsis;
				_tmp1247_ = _tmp1249_;
			} else {
				_tmp1247_ = FALSE;
			}
			if (_tmp1247_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1250_;
				ValaNamedArgument* _tmp1251_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1252_;
				const gchar* _tmp1253_;
				const gchar* _tmp1254_;
				gchar** _tmp1255_;
				gchar** _tmp1256_;
				gchar** _tmp1257_;
				gint _tmp1257__length1;
				gchar* _tmp1258_;
				gchar* _tmp1259_;
				ValaHashMap* _tmp1260_;
				gint _tmp1261_;
				gboolean _tmp1262_;
				const gchar* _tmp1263_;
				gchar* _tmp1264_;
				gchar* _tmp1265_;
				ValaCCodeConstant* _tmp1266_;
				ValaCCodeConstant* _tmp1267_;
				_tmp1250_ = arg;
				_tmp1251_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1250_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1251_;
				_tmp1252_ = named_arg;
				_tmp1253_ = vala_named_argument_get_name (_tmp1252_);
				_tmp1254_ = _tmp1253_;
				_tmp1256_ = _tmp1255_ = g_strsplit (_tmp1254_, "_", 0);
				_tmp1257_ = _tmp1256_;
				_tmp1257__length1 = _vala_array_length (_tmp1255_);
				_tmp1258_ = _vala_g_strjoinv ("-", _tmp1257_, _vala_array_length (_tmp1255_));
				_tmp1259_ = _tmp1258_;
				_tmp1257_ = (_vala_array_free (_tmp1257_, _tmp1257__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1259_;
				_tmp1260_ = carg_map;
				_tmp1261_ = i;
				_tmp1262_ = ellipsis;
				_tmp1263_ = name;
				_tmp1264_ = g_strdup_printf ("\"%s\"", _tmp1263_);
				_tmp1265_ = _tmp1264_;
				_tmp1266_ = vala_ccode_constant_new (_tmp1265_);
				_tmp1267_ = _tmp1266_;
				vala_map_set ((ValaMap*) _tmp1260_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1261_ - 0.1, _tmp1262_)), (ValaCCodeExpression*) _tmp1267_);
				_vala_ccode_node_unref0 (_tmp1267_);
				_g_free0 (_tmp1265_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1268_ = i;
			i = _tmp1268_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1269_ = params_it;
	if (vala_iterator_next (_tmp1269_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1270_;
		gpointer _tmp1271_;
		gboolean _tmp1272_ = FALSE;
		ValaParameter* _tmp1273_;
		gboolean _tmp1274_;
		gboolean _tmp1275_;
		_tmp1270_ = params_it;
		_tmp1271_ = vala_iterator_get (_tmp1270_);
		param = (ValaParameter*) _tmp1271_;
		_tmp1273_ = param;
		_tmp1274_ = vala_parameter_get_params_array (_tmp1273_);
		_tmp1275_ = _tmp1274_;
		if (_tmp1275_) {
			_tmp1272_ = TRUE;
		} else {
			ValaParameter* _tmp1276_;
			gboolean _tmp1277_;
			gboolean _tmp1278_;
			_tmp1276_ = param;
			_tmp1277_ = vala_parameter_get_ellipsis (_tmp1276_);
			_tmp1278_ = _tmp1277_;
			_tmp1272_ = _tmp1278_;
		}
		_vala_assert (_tmp1272_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1281_ = m;
	if (_tmp1281_ != NULL) {
		ValaMethod* _tmp1282_;
		ValaDataType* _tmp1283_;
		ValaDataType* _tmp1284_;
		_tmp1282_ = m;
		_tmp1283_ = vala_callable_get_return_type ((ValaCallable*) _tmp1282_);
		_tmp1284_ = _tmp1283_;
		_tmp1280_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1284_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1280_ = FALSE;
	}
	if (_tmp1280_) {
		ValaCCodeFunctionCall* _tmp1285_;
		ValaCCodeFunctionCall* _tmp1286_;
		_tmp1285_ = async_call;
		_tmp1286_ = ccall;
		_tmp1279_ = _tmp1285_ != _tmp1286_;
	} else {
		_tmp1279_ = FALSE;
	}
	if (_tmp1279_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1287_;
		ValaDataType* _tmp1288_;
		ValaDataType* _tmp1289_;
		ValaArrayType* _tmp1290_;
		_tmp1287_ = m;
		_tmp1288_ = vala_callable_get_return_type ((ValaCallable*) _tmp1287_);
		_tmp1289_ = _tmp1288_;
		_tmp1290_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1289_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1290_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1291_ = FALSE;
				_tmp1291_ = TRUE;
				while (TRUE) {
					gint _tmp1293_;
					ValaArrayType* _tmp1294_;
					gint _tmp1295_;
					gint _tmp1296_;
					ValaMethod* _tmp1297_;
					if (!_tmp1291_) {
						gint _tmp1292_;
						_tmp1292_ = dim;
						dim = _tmp1292_ + 1;
					}
					_tmp1291_ = FALSE;
					_tmp1293_ = dim;
					_tmp1294_ = array_type;
					_tmp1295_ = vala_array_type_get_rank (_tmp1294_);
					_tmp1296_ = _tmp1295_;
					if (!(_tmp1293_ <= _tmp1296_)) {
						break;
					}
					_tmp1297_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1297_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1298_;
						ValaDataType* _tmp1299_;
						ValaDataType* _tmp1300_;
						ValaLocalVariable* _tmp1301_;
						ValaLocalVariable* _tmp1302_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1303_;
						const gchar* _tmp1304_;
						const gchar* _tmp1305_;
						ValaCCodeExpression* _tmp1306_;
						ValaLocalVariable* _tmp1307_;
						ValaCCodeExpression* _tmp1308_;
						ValaCCodeExpression* _tmp1309_;
						ValaCCodeAssignment* _tmp1310_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1311_;
						ValaCCodeIdentifier* _tmp1312_;
						ValaCCodeFunctionCall* _tmp1313_;
						ValaCCodeFunctionCall* _tmp1314_;
						ValaCCodeFunctionCall* _tmp1315_;
						ValaCCodeExpression* _tmp1316_;
						ValaCCodeFunctionCall* _tmp1317_;
						_tmp1298_ = itype;
						_tmp1299_ = vala_data_type_get_return_type (_tmp1298_);
						_tmp1300_ = _tmp1299_;
						_tmp1301_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1300_, TRUE, NULL, FALSE);
						_tmp1302_ = _tmp1301_;
						_vala_code_node_unref0 (_tmp1300_);
						temp_var = _tmp1302_;
						_tmp1303_ = temp_var;
						_tmp1304_ = vala_symbol_get_name ((ValaSymbol*) _tmp1303_);
						_tmp1305_ = _tmp1304_;
						_tmp1306_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1305_);
						temp_ref = _tmp1306_;
						_tmp1307_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1307_, FALSE);
						_tmp1308_ = temp_ref;
						_tmp1309_ = ccall_expr;
						_tmp1310_ = vala_ccode_assignment_new (_tmp1308_, _tmp1309_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1310_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1311_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1312_ = _tmp1311_;
						_tmp1313_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1312_);
						_tmp1314_ = _tmp1313_;
						_vala_ccode_node_unref0 (_tmp1312_);
						len_call = _tmp1314_;
						_tmp1315_ = len_call;
						_tmp1316_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1315_, _tmp1316_);
						_tmp1317_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1317_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1318_;
						_tmp1318_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1318_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaMethod* _tmp1319_;
							gchar* _tmp1320_;
							gchar* _tmp1321_;
							gboolean _tmp1322_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1331_;
							const gchar* _tmp1332_;
							const gchar* _tmp1333_;
							ValaCCodeExpression* _tmp1334_;
							ValaLocalVariable* _tmp1335_;
							ValaHashMap* _tmp1336_;
							ValaMethod* _tmp1337_;
							gint _tmp1338_;
							ValaCCodeExpression* _tmp1339_;
							ValaCCodeUnaryExpression* _tmp1340_;
							ValaCCodeUnaryExpression* _tmp1341_;
							ValaCCodeExpression* _tmp1342_;
							_tmp1319_ = m;
							_tmp1320_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1319_);
							_tmp1321_ = _tmp1320_;
							_tmp1322_ = _tmp1321_ == NULL;
							_g_free0 (_tmp1321_);
							if (_tmp1322_) {
								ValaDataType* _tmp1323_;
								ValaLocalVariable* _tmp1324_;
								_tmp1323_ = ((ValaCCodeBaseModule*) self)->int_type;
								_tmp1324_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1323_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1324_;
							} else {
								ValaMethod* _tmp1325_;
								gchar* _tmp1326_;
								gchar* _tmp1327_;
								ValaCType* _tmp1328_;
								ValaCType* _tmp1329_;
								ValaLocalVariable* _tmp1330_;
								_tmp1325_ = m;
								_tmp1326_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1325_);
								_tmp1327_ = _tmp1326_;
								_tmp1328_ = vala_ctype_new (_tmp1327_, "0");
								_tmp1329_ = _tmp1328_;
								_tmp1330_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1329_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1330_;
								_vala_code_node_unref0 (_tmp1329_);
								_g_free0 (_tmp1327_);
							}
							_tmp1331_ = temp_var;
							_tmp1332_ = vala_symbol_get_name ((ValaSymbol*) _tmp1331_);
							_tmp1333_ = _tmp1332_;
							_tmp1334_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1333_);
							temp_ref = _tmp1334_;
							_tmp1335_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1335_, FALSE);
							_tmp1336_ = out_arg_map;
							_tmp1337_ = m;
							_tmp1338_ = dim;
							_tmp1339_ = temp_ref;
							_tmp1340_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1339_);
							_tmp1341_ = _tmp1340_;
							vala_map_set ((ValaMap*) _tmp1336_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1337_) + (0.01 * _tmp1338_), FALSE)), (ValaCCodeExpression*) _tmp1341_);
							_vala_ccode_node_unref0 (_tmp1341_);
							_tmp1342_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1342_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaMethod* _tmp1343_;
							gchar* _tmp1344_;
							gchar* _tmp1345_;
							gboolean _tmp1346_;
							_tmp1343_ = m;
							_tmp1344_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1343_);
							_tmp1345_ = _tmp1344_;
							_tmp1346_ = _tmp1345_ != NULL;
							_g_free0 (_tmp1345_);
							if (_tmp1346_) {
								ValaMethod* _tmp1347_;
								gchar* _tmp1348_;
								gchar* _tmp1349_;
								ValaCCodeConstant* _tmp1350_;
								ValaCCodeConstant* _tmp1351_;
								_tmp1347_ = m;
								_tmp1348_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1347_);
								_tmp1349_ = _tmp1348_;
								_tmp1350_ = vala_ccode_constant_new (_tmp1349_);
								_tmp1351_ = _tmp1350_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1351_);
								_vala_ccode_node_unref0 (_tmp1351_);
								_g_free0 (_tmp1349_);
							} else {
								ValaCCodeConstant* _tmp1352_;
								ValaCCodeConstant* _tmp1353_;
								_tmp1352_ = vala_ccode_constant_new ("-1");
								_tmp1353_ = _tmp1352_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1353_);
								_vala_ccode_node_unref0 (_tmp1353_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1354_ = FALSE;
		gboolean _tmp1355_ = FALSE;
		ValaMethod* _tmp1356_;
		_tmp1356_ = m;
		if (_tmp1356_ != NULL) {
			ValaMethod* _tmp1357_;
			ValaDataType* _tmp1358_;
			ValaDataType* _tmp1359_;
			_tmp1357_ = m;
			_tmp1358_ = vala_callable_get_return_type ((ValaCallable*) _tmp1357_);
			_tmp1359_ = _tmp1358_;
			_tmp1355_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1359_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1355_ = FALSE;
		}
		if (_tmp1355_) {
			ValaCCodeFunctionCall* _tmp1360_;
			ValaCCodeFunctionCall* _tmp1361_;
			_tmp1360_ = async_call;
			_tmp1361_ = ccall;
			_tmp1354_ = _tmp1360_ != _tmp1361_;
		} else {
			_tmp1354_ = FALSE;
		}
		if (_tmp1354_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1362_;
			ValaDataType* _tmp1363_;
			ValaDataType* _tmp1364_;
			ValaDelegateType* _tmp1365_;
			ValaDelegateType* _tmp1366_;
			ValaDelegate* _tmp1367_;
			ValaDelegate* _tmp1368_;
			gboolean _tmp1369_;
			gboolean _tmp1370_;
			_tmp1362_ = m;
			_tmp1363_ = vala_callable_get_return_type ((ValaCallable*) _tmp1362_);
			_tmp1364_ = _tmp1363_;
			_tmp1365_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1364_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1365_;
			_tmp1366_ = deleg_type;
			_tmp1367_ = vala_delegate_type_get_delegate_symbol (_tmp1366_);
			_tmp1368_ = _tmp1367_;
			_tmp1369_ = vala_delegate_get_has_target (_tmp1368_);
			_tmp1370_ = _tmp1369_;
			if (_tmp1370_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1371_;
				ValaVoidType* _tmp1372_;
				ValaPointerType* _tmp1373_;
				ValaPointerType* _tmp1374_;
				ValaLocalVariable* _tmp1375_;
				ValaLocalVariable* _tmp1376_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1377_;
				const gchar* _tmp1378_;
				const gchar* _tmp1379_;
				ValaCCodeExpression* _tmp1380_;
				ValaLocalVariable* _tmp1381_;
				ValaHashMap* _tmp1382_;
				ValaMethod* _tmp1383_;
				ValaCCodeExpression* _tmp1384_;
				ValaCCodeUnaryExpression* _tmp1385_;
				ValaCCodeUnaryExpression* _tmp1386_;
				ValaCCodeExpression* _tmp1387_;
				ValaDelegateType* _tmp1388_;
				_tmp1371_ = vala_void_type_new (NULL);
				_tmp1372_ = _tmp1371_;
				_tmp1373_ = vala_pointer_type_new ((ValaDataType*) _tmp1372_, NULL);
				_tmp1374_ = _tmp1373_;
				_tmp1375_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1374_, TRUE, NULL, TRUE);
				_tmp1376_ = _tmp1375_;
				_vala_code_node_unref0 (_tmp1374_);
				_vala_code_node_unref0 (_tmp1372_);
				temp_var = _tmp1376_;
				_tmp1377_ = temp_var;
				_tmp1378_ = vala_symbol_get_name ((ValaSymbol*) _tmp1377_);
				_tmp1379_ = _tmp1378_;
				_tmp1380_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1379_);
				temp_ref = _tmp1380_;
				_tmp1381_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1381_, FALSE);
				_tmp1382_ = out_arg_map;
				_tmp1383_ = m;
				_tmp1384_ = temp_ref;
				_tmp1385_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1384_);
				_tmp1386_ = _tmp1385_;
				vala_map_set ((ValaMap*) _tmp1382_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1383_), FALSE)), (ValaCCodeExpression*) _tmp1386_);
				_vala_ccode_node_unref0 (_tmp1386_);
				_tmp1387_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1387_);
				_tmp1388_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1388_)) {
					ValaDataType* _tmp1389_;
					ValaLocalVariable* _tmp1390_;
					ValaLocalVariable* _tmp1391_;
					const gchar* _tmp1392_;
					const gchar* _tmp1393_;
					ValaCCodeExpression* _tmp1394_;
					ValaLocalVariable* _tmp1395_;
					ValaHashMap* _tmp1396_;
					ValaMethod* _tmp1397_;
					ValaCCodeExpression* _tmp1398_;
					ValaCCodeUnaryExpression* _tmp1399_;
					ValaCCodeUnaryExpression* _tmp1400_;
					ValaCCodeExpression* _tmp1401_;
					_tmp1389_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1390_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1389_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1390_;
					_tmp1391_ = temp_var;
					_tmp1392_ = vala_symbol_get_name ((ValaSymbol*) _tmp1391_);
					_tmp1393_ = _tmp1392_;
					_tmp1394_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1393_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1394_;
					_tmp1395_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1395_, FALSE);
					_tmp1396_ = out_arg_map;
					_tmp1397_ = m;
					_tmp1398_ = temp_ref;
					_tmp1399_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1398_);
					_tmp1400_ = _tmp1399_;
					vala_map_set ((ValaMap*) _tmp1396_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1397_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1400_);
					_vala_ccode_node_unref0 (_tmp1400_);
					_tmp1401_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1401_);
				} else {
					ValaCCodeConstant* _tmp1402_;
					ValaCCodeConstant* _tmp1403_;
					_tmp1402_ = vala_ccode_constant_new ("NULL");
					_tmp1403_ = _tmp1402_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1403_);
					_vala_ccode_node_unref0 (_tmp1403_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1404_;
				ValaCCodeConstant* _tmp1405_;
				_tmp1404_ = vala_ccode_constant_new ("NULL");
				_tmp1405_ = _tmp1404_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1405_);
				_vala_ccode_node_unref0 (_tmp1405_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1407_ = deleg;
	if (_tmp1407_ != NULL) {
		ValaDelegate* _tmp1408_;
		ValaDataType* _tmp1409_;
		ValaDataType* _tmp1410_;
		_tmp1408_ = deleg;
		_tmp1409_ = vala_callable_get_return_type ((ValaCallable*) _tmp1408_);
		_tmp1410_ = _tmp1409_;
		_tmp1406_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1410_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1406_ = FALSE;
	}
	if (_tmp1406_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1411_;
		ValaDataType* _tmp1412_;
		ValaDataType* _tmp1413_;
		ValaArrayType* _tmp1414_;
		_tmp1411_ = deleg;
		_tmp1412_ = vala_callable_get_return_type ((ValaCallable*) _tmp1411_);
		_tmp1413_ = _tmp1412_;
		_tmp1414_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1413_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1414_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1415_ = FALSE;
				_tmp1415_ = TRUE;
				while (TRUE) {
					gint _tmp1417_;
					ValaArrayType* _tmp1418_;
					gint _tmp1419_;
					gint _tmp1420_;
					ValaDelegate* _tmp1421_;
					if (!_tmp1415_) {
						gint _tmp1416_;
						_tmp1416_ = dim;
						dim = _tmp1416_ + 1;
					}
					_tmp1415_ = FALSE;
					_tmp1417_ = dim;
					_tmp1418_ = array_type;
					_tmp1419_ = vala_array_type_get_rank (_tmp1418_);
					_tmp1420_ = _tmp1419_;
					if (!(_tmp1417_ <= _tmp1420_)) {
						break;
					}
					_tmp1421_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1421_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1422_;
						ValaDataType* _tmp1423_;
						ValaDataType* _tmp1424_;
						ValaLocalVariable* _tmp1425_;
						ValaLocalVariable* _tmp1426_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1427_;
						const gchar* _tmp1428_;
						const gchar* _tmp1429_;
						ValaCCodeExpression* _tmp1430_;
						ValaLocalVariable* _tmp1431_;
						ValaCCodeExpression* _tmp1432_;
						ValaCCodeExpression* _tmp1433_;
						ValaCCodeAssignment* _tmp1434_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1435_;
						ValaCCodeIdentifier* _tmp1436_;
						ValaCCodeFunctionCall* _tmp1437_;
						ValaCCodeFunctionCall* _tmp1438_;
						ValaCCodeFunctionCall* _tmp1439_;
						ValaCCodeExpression* _tmp1440_;
						ValaCCodeFunctionCall* _tmp1441_;
						_tmp1422_ = itype;
						_tmp1423_ = vala_data_type_get_return_type (_tmp1422_);
						_tmp1424_ = _tmp1423_;
						_tmp1425_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1424_, TRUE, NULL, FALSE);
						_tmp1426_ = _tmp1425_;
						_vala_code_node_unref0 (_tmp1424_);
						temp_var = _tmp1426_;
						_tmp1427_ = temp_var;
						_tmp1428_ = vala_symbol_get_name ((ValaSymbol*) _tmp1427_);
						_tmp1429_ = _tmp1428_;
						_tmp1430_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1429_);
						temp_ref = _tmp1430_;
						_tmp1431_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1431_, FALSE);
						_tmp1432_ = temp_ref;
						_tmp1433_ = ccall_expr;
						_tmp1434_ = vala_ccode_assignment_new (_tmp1432_, _tmp1433_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1434_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1435_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1436_ = _tmp1435_;
						_tmp1437_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1436_);
						_tmp1438_ = _tmp1437_;
						_vala_ccode_node_unref0 (_tmp1436_);
						len_call = _tmp1438_;
						_tmp1439_ = len_call;
						_tmp1440_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1439_, _tmp1440_);
						_tmp1441_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1441_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1442_;
						_tmp1442_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1442_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaDataType* _tmp1443_;
							ValaLocalVariable* _tmp1444_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1445_;
							const gchar* _tmp1446_;
							const gchar* _tmp1447_;
							ValaCCodeExpression* _tmp1448_;
							ValaLocalVariable* _tmp1449_;
							ValaHashMap* _tmp1450_;
							ValaDelegate* _tmp1451_;
							gint _tmp1452_;
							ValaCCodeExpression* _tmp1453_;
							ValaCCodeUnaryExpression* _tmp1454_;
							ValaCCodeUnaryExpression* _tmp1455_;
							ValaCCodeExpression* _tmp1456_;
							_tmp1443_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1444_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1443_, TRUE, NULL, TRUE);
							temp_var = _tmp1444_;
							_tmp1445_ = temp_var;
							_tmp1446_ = vala_symbol_get_name ((ValaSymbol*) _tmp1445_);
							_tmp1447_ = _tmp1446_;
							_tmp1448_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1447_);
							temp_ref = _tmp1448_;
							_tmp1449_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1449_, FALSE);
							_tmp1450_ = out_arg_map;
							_tmp1451_ = deleg;
							_tmp1452_ = dim;
							_tmp1453_ = temp_ref;
							_tmp1454_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1453_);
							_tmp1455_ = _tmp1454_;
							vala_map_set ((ValaMap*) _tmp1450_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1451_) + (0.01 * _tmp1452_), FALSE)), (ValaCCodeExpression*) _tmp1455_);
							_vala_ccode_node_unref0 (_tmp1455_);
							_tmp1456_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1456_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1457_;
							ValaCCodeConstant* _tmp1458_;
							_tmp1457_ = vala_ccode_constant_new ("-1");
							_tmp1458_ = _tmp1457_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1458_);
							_vala_ccode_node_unref0 (_tmp1458_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1459_ = FALSE;
		ValaDelegate* _tmp1460_;
		_tmp1460_ = deleg;
		if (_tmp1460_ != NULL) {
			ValaDelegate* _tmp1461_;
			ValaDataType* _tmp1462_;
			ValaDataType* _tmp1463_;
			_tmp1461_ = deleg;
			_tmp1462_ = vala_callable_get_return_type ((ValaCallable*) _tmp1461_);
			_tmp1463_ = _tmp1462_;
			_tmp1459_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1463_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1459_ = FALSE;
		}
		if (_tmp1459_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1464_;
			ValaDataType* _tmp1465_;
			ValaDataType* _tmp1466_;
			ValaDelegateType* _tmp1467_;
			ValaDelegateType* _tmp1468_;
			ValaDelegate* _tmp1469_;
			ValaDelegate* _tmp1470_;
			gboolean _tmp1471_;
			gboolean _tmp1472_;
			_tmp1464_ = deleg;
			_tmp1465_ = vala_callable_get_return_type ((ValaCallable*) _tmp1464_);
			_tmp1466_ = _tmp1465_;
			_tmp1467_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1466_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1467_;
			_tmp1468_ = deleg_type;
			_tmp1469_ = vala_delegate_type_get_delegate_symbol (_tmp1468_);
			_tmp1470_ = _tmp1469_;
			_tmp1471_ = vala_delegate_get_has_target (_tmp1470_);
			_tmp1472_ = _tmp1471_;
			if (_tmp1472_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1473_;
				ValaVoidType* _tmp1474_;
				ValaPointerType* _tmp1475_;
				ValaPointerType* _tmp1476_;
				ValaLocalVariable* _tmp1477_;
				ValaLocalVariable* _tmp1478_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1479_;
				const gchar* _tmp1480_;
				const gchar* _tmp1481_;
				ValaCCodeExpression* _tmp1482_;
				ValaLocalVariable* _tmp1483_;
				ValaHashMap* _tmp1484_;
				ValaDelegate* _tmp1485_;
				ValaCCodeExpression* _tmp1486_;
				ValaCCodeUnaryExpression* _tmp1487_;
				ValaCCodeUnaryExpression* _tmp1488_;
				ValaCCodeExpression* _tmp1489_;
				ValaDelegateType* _tmp1490_;
				_tmp1473_ = vala_void_type_new (NULL);
				_tmp1474_ = _tmp1473_;
				_tmp1475_ = vala_pointer_type_new ((ValaDataType*) _tmp1474_, NULL);
				_tmp1476_ = _tmp1475_;
				_tmp1477_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1476_, TRUE, NULL, TRUE);
				_tmp1478_ = _tmp1477_;
				_vala_code_node_unref0 (_tmp1476_);
				_vala_code_node_unref0 (_tmp1474_);
				temp_var = _tmp1478_;
				_tmp1479_ = temp_var;
				_tmp1480_ = vala_symbol_get_name ((ValaSymbol*) _tmp1479_);
				_tmp1481_ = _tmp1480_;
				_tmp1482_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1481_);
				temp_ref = _tmp1482_;
				_tmp1483_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1483_, FALSE);
				_tmp1484_ = out_arg_map;
				_tmp1485_ = deleg;
				_tmp1486_ = temp_ref;
				_tmp1487_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1486_);
				_tmp1488_ = _tmp1487_;
				vala_map_set ((ValaMap*) _tmp1484_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1485_), FALSE)), (ValaCCodeExpression*) _tmp1488_);
				_vala_ccode_node_unref0 (_tmp1488_);
				_tmp1489_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1489_);
				_tmp1490_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1490_)) {
					ValaDataType* _tmp1491_;
					ValaLocalVariable* _tmp1492_;
					ValaLocalVariable* _tmp1493_;
					const gchar* _tmp1494_;
					const gchar* _tmp1495_;
					ValaCCodeExpression* _tmp1496_;
					ValaLocalVariable* _tmp1497_;
					ValaHashMap* _tmp1498_;
					ValaDelegate* _tmp1499_;
					ValaCCodeExpression* _tmp1500_;
					ValaCCodeUnaryExpression* _tmp1501_;
					ValaCCodeUnaryExpression* _tmp1502_;
					ValaCCodeExpression* _tmp1503_;
					_tmp1491_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1492_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1491_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1492_;
					_tmp1493_ = temp_var;
					_tmp1494_ = vala_symbol_get_name ((ValaSymbol*) _tmp1493_);
					_tmp1495_ = _tmp1494_;
					_tmp1496_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1495_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1496_;
					_tmp1497_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1497_, FALSE);
					_tmp1498_ = out_arg_map;
					_tmp1499_ = deleg;
					_tmp1500_ = temp_ref;
					_tmp1501_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1500_);
					_tmp1502_ = _tmp1501_;
					vala_map_set ((ValaMap*) _tmp1498_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1499_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1502_);
					_vala_ccode_node_unref0 (_tmp1502_);
					_tmp1503_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1503_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1505_ = m;
	if (_tmp1505_ != NULL) {
		ValaMethod* _tmp1506_;
		gboolean _tmp1507_;
		gboolean _tmp1508_;
		_tmp1506_ = m;
		_tmp1507_ = vala_method_get_coroutine (_tmp1506_);
		_tmp1508_ = _tmp1507_;
		_tmp1504_ = _tmp1508_;
	} else {
		_tmp1504_ = FALSE;
	}
	if (_tmp1504_) {
		gboolean _tmp1509_;
		gboolean _tmp1510_;
		_tmp1509_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1510_ = _tmp1509_;
		if (_tmp1510_) {
			ValaHashMap* _tmp1511_;
			ValaMethod* _tmp1512_;
			ValaMethod* _tmp1513_;
			gchar* _tmp1514_;
			gchar* _tmp1515_;
			ValaCCodeIdentifier* _tmp1516_;
			ValaCCodeIdentifier* _tmp1517_;
			ValaHashMap* _tmp1518_;
			ValaCCodeIdentifier* _tmp1519_;
			ValaCCodeIdentifier* _tmp1520_;
			_tmp1511_ = in_arg_map;
			_tmp1512_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1513_ = _tmp1512_;
			_tmp1514_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1513_);
			_tmp1515_ = _tmp1514_;
			_tmp1516_ = vala_ccode_identifier_new (_tmp1515_);
			_tmp1517_ = _tmp1516_;
			vala_map_set ((ValaMap*) _tmp1511_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1517_);
			_vala_ccode_node_unref0 (_tmp1517_);
			_g_free0 (_tmp1515_);
			_tmp1518_ = in_arg_map;
			_tmp1519_ = vala_ccode_identifier_new ("_data_");
			_tmp1520_ = _tmp1519_;
			vala_map_set ((ValaMap*) _tmp1518_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1520_);
			_vala_ccode_node_unref0 (_tmp1520_);
		}
	}
	_tmp1521_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1522_ = _tmp1521_;
	if (_tmp1522_) {
		ValaHashMap* _tmp1523_;
		ValaCCodeExpression* _tmp1524_;
		ValaCCodeExpression* _tmp1525_;
		ValaCCodeUnaryExpression* _tmp1526_;
		ValaCCodeUnaryExpression* _tmp1527_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1523_ = out_arg_map;
		_tmp1524_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1525_ = _tmp1524_;
		_tmp1526_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1525_);
		_tmp1527_ = _tmp1526_;
		vala_map_set ((ValaMap*) _tmp1523_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1527_);
		_vala_ccode_node_unref0 (_tmp1527_);
		_vala_ccode_node_unref0 (_tmp1525_);
	} else {
		gboolean _tmp1528_ = FALSE;
		gboolean _tmp1529_ = FALSE;
		ValaMethod* _tmp1530_;
		_tmp1530_ = m;
		if (_tmp1530_ != NULL) {
			ValaMethod* _tmp1531_;
			_tmp1531_ = m;
			_tmp1529_ = vala_method_has_error_type_parameter (_tmp1531_);
		} else {
			_tmp1529_ = FALSE;
		}
		if (_tmp1529_) {
			ValaCCodeFunctionCall* _tmp1532_;
			ValaCCodeFunctionCall* _tmp1533_;
			_tmp1532_ = async_call;
			_tmp1533_ = ccall;
			_tmp1528_ = _tmp1532_ != _tmp1533_;
		} else {
			_tmp1528_ = FALSE;
		}
		if (_tmp1528_) {
			ValaHashMap* _tmp1534_;
			ValaCCodeConstant* _tmp1535_;
			ValaCCodeConstant* _tmp1536_;
			_tmp1534_ = out_arg_map;
			_tmp1535_ = vala_ccode_constant_new ("NULL");
			_tmp1536_ = _tmp1535_;
			vala_map_set ((ValaMap*) _tmp1534_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1536_);
			_vala_ccode_node_unref0 (_tmp1536_);
		}
	}
	_tmp1537_ = ellipsis;
	if (_tmp1537_) {
		ValaMethod* _tmp1538_;
		_tmp1538_ = m;
		if (_tmp1538_ == NULL) {
			ValaHashMap* _tmp1539_;
			ValaCCodeConstant* _tmp1540_;
			ValaCCodeConstant* _tmp1541_;
			_tmp1539_ = in_arg_map;
			_tmp1540_ = vala_ccode_constant_new ("NULL");
			_tmp1541_ = _tmp1540_;
			vala_map_set ((ValaMap*) _tmp1539_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1541_);
			_vala_ccode_node_unref0 (_tmp1541_);
		} else {
			gboolean _tmp1542_ = FALSE;
			gboolean _tmp1543_ = FALSE;
			gboolean _tmp1544_ = FALSE;
			ValaMethod* _tmp1545_;
			gboolean _tmp1546_;
			gboolean _tmp1547_;
			_tmp1545_ = m;
			_tmp1546_ = vala_method_get_printf_format (_tmp1545_);
			_tmp1547_ = _tmp1546_;
			if (!_tmp1547_) {
				ValaMethod* _tmp1548_;
				gboolean _tmp1549_;
				gboolean _tmp1550_;
				_tmp1548_ = m;
				_tmp1549_ = vala_method_get_scanf_format (_tmp1548_);
				_tmp1550_ = _tmp1549_;
				_tmp1544_ = !_tmp1550_;
			} else {
				_tmp1544_ = FALSE;
			}
			if (_tmp1544_) {
				ValaMethod* _tmp1551_;
				gchar* _tmp1552_;
				gchar* _tmp1553_;
				_tmp1551_ = m;
				_tmp1552_ = vala_get_ccode_sentinel (_tmp1551_);
				_tmp1553_ = _tmp1552_;
				_tmp1543_ = g_strcmp0 (_tmp1553_, "") != 0;
				_g_free0 (_tmp1553_);
			} else {
				_tmp1543_ = FALSE;
			}
			if (_tmp1543_) {
				gboolean _tmp1554_;
				gboolean _tmp1555_;
				_tmp1554_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1555_ = _tmp1554_;
				_tmp1542_ = !_tmp1555_;
			} else {
				_tmp1542_ = FALSE;
			}
			if (_tmp1542_) {
				ValaHashMap* _tmp1556_;
				ValaMethod* _tmp1557_;
				gchar* _tmp1558_;
				gchar* _tmp1559_;
				ValaCCodeConstant* _tmp1560_;
				ValaCCodeConstant* _tmp1561_;
				_tmp1556_ = in_arg_map;
				_tmp1557_ = m;
				_tmp1558_ = vala_get_ccode_sentinel (_tmp1557_);
				_tmp1559_ = _tmp1558_;
				_tmp1560_ = vala_ccode_constant_new (_tmp1559_);
				_tmp1561_ = _tmp1560_;
				vala_map_set ((ValaMap*) _tmp1556_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1561_);
				_vala_ccode_node_unref0 (_tmp1561_);
				_g_free0 (_tmp1559_);
			}
		}
	}
	_tmp1562_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1562_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1563_;
		ValaDelegateType* _tmp1564_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1565_;
		ValaDelegate* _tmp1566_;
		ValaDelegate* _tmp1567_;
		ValaDelegate* _tmp1568_;
		ValaDelegate* _tmp1569_;
		gboolean _tmp1570_;
		gboolean _tmp1571_;
		_tmp1563_ = itype;
		_tmp1564_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1563_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1564_;
		_tmp1565_ = deleg_type;
		_tmp1566_ = vala_delegate_type_get_delegate_symbol (_tmp1565_);
		_tmp1567_ = _tmp1566_;
		_tmp1568_ = _vala_code_node_ref0 (_tmp1567_);
		d = _tmp1568_;
		_tmp1569_ = d;
		_tmp1570_ = vala_delegate_get_has_target (_tmp1569_);
		_tmp1571_ = _tmp1570_;
		if (_tmp1571_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1572_;
			ValaDelegate* _tmp1573_;
			ValaExpression* _tmp1574_;
			ValaExpression* _tmp1575_;
			ValaCCodeExpression* _tmp1576_ = NULL;
			ValaCCodeExpression* _tmp1577_;
			ValaCCodeExpression* _tmp1578_;
			ValaHashMap* _tmp1579_;
			ValaDelegate* _tmp1580_;
			ValaExpression* _tmp1581_;
			ValaExpression* _tmp1582_;
			ValaCCodeExpression* _tmp1583_ = NULL;
			ValaCCodeExpression* _tmp1584_;
			ValaCCodeExpression* _tmp1585_;
			_tmp1572_ = in_arg_map;
			_tmp1573_ = d;
			_tmp1574_ = vala_method_call_get_call (expr);
			_tmp1575_ = _tmp1574_;
			_tmp1577_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1575_, &_tmp1576_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1576_;
			_tmp1578_ = _tmp1577_;
			vala_map_set ((ValaMap*) _tmp1572_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1573_), FALSE)), _tmp1578_);
			_vala_ccode_node_unref0 (_tmp1578_);
			_tmp1579_ = out_arg_map;
			_tmp1580_ = d;
			_tmp1581_ = vala_method_call_get_call (expr);
			_tmp1582_ = _tmp1581_;
			_tmp1584_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1582_, &_tmp1583_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1583_;
			_tmp1585_ = _tmp1584_;
			vala_map_set ((ValaMap*) _tmp1579_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1580_), FALSE)), _tmp1585_);
			_vala_ccode_node_unref0 (_tmp1585_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1586_ = itype;
	_tmp1587_ = vala_data_type_get_return_type (_tmp1586_);
	_tmp1588_ = _tmp1587_;
	_tmp1589_ = vala_data_type_is_real_non_null_struct_type (_tmp1588_);
	_vala_code_node_unref0 (_tmp1588_);
	return_result_via_out_param = _tmp1589_;
	_tmp1591_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1591_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1592_;
		ValaDataType* _tmp1593_;
		ValaDataType* _tmp1594_;
		_tmp1592_ = itype;
		_tmp1593_ = vala_data_type_get_return_type (_tmp1592_);
		_tmp1594_ = _tmp1593_;
		_tmp1590_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1594_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1594_);
	} else {
		_tmp1590_ = FALSE;
	}
	if (_tmp1590_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1595_;
		ValaSignal* _tmp1596_;
		ValaSignal* _tmp1597_;
		ValaSignal* _tmp1598_;
		gboolean _tmp1599_ = FALSE;
		gboolean _tmp1600_ = FALSE;
		ValaMemberAccess* _tmp1601_;
		_tmp1595_ = itype;
		_tmp1596_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1595_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1597_ = _tmp1596_;
		_tmp1598_ = _vala_code_node_ref0 (_tmp1597_);
		sig = _tmp1598_;
		_tmp1601_ = ma;
		if (_tmp1601_ != NULL) {
			ValaMemberAccess* _tmp1602_;
			ValaExpression* _tmp1603_;
			ValaExpression* _tmp1604_;
			_tmp1602_ = ma;
			_tmp1603_ = vala_member_access_get_inner (_tmp1602_);
			_tmp1604_ = _tmp1603_;
			_tmp1600_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1604_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1600_ = FALSE;
		}
		if (_tmp1600_) {
			ValaSignal* _tmp1605_;
			gboolean _tmp1606_;
			gboolean _tmp1607_;
			_tmp1605_ = sig;
			_tmp1606_ = vala_signal_get_is_virtual (_tmp1605_);
			_tmp1607_ = _tmp1606_;
			_tmp1599_ = _tmp1607_;
		} else {
			_tmp1599_ = FALSE;
		}
		if (_tmp1599_) {
		} else {
			gboolean _tmp1608_ = FALSE;
			ValaSignal* _tmp1609_;
			_tmp1609_ = sig;
			if (!vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp1609_)) {
				_tmp1608_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1610_;
				ValaSourceReference* _tmp1611_;
				ValaSourceReference* _tmp1612_;
				ValaSourceFile* _tmp1613_;
				ValaSourceFile* _tmp1614_;
				ValaSignal* _tmp1615_;
				ValaSourceReference* _tmp1616_;
				ValaSourceReference* _tmp1617_;
				ValaSourceFile* _tmp1618_;
				ValaSourceFile* _tmp1619_;
				_tmp1610_ = ma;
				_tmp1611_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1610_);
				_tmp1612_ = _tmp1611_;
				_tmp1613_ = vala_source_reference_get_file (_tmp1612_);
				_tmp1614_ = _tmp1613_;
				_tmp1615_ = sig;
				_tmp1616_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1615_);
				_tmp1617_ = _tmp1616_;
				_tmp1618_ = vala_source_reference_get_file (_tmp1617_);
				_tmp1619_ = _tmp1618_;
				_tmp1608_ = _tmp1614_ == _tmp1619_;
			}
			if (_tmp1608_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1620_ = async_call;
	_tmp1621_ = ccall;
	if (_tmp1620_ == _tmp1621_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	_tmp1622_ = return_result_via_out_param;
	if (_tmp1622_) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1623_;
		ValaDataType* _tmp1624_;
		ValaDataType* _tmp1625_;
		ValaLocalVariable* _tmp1626_;
		ValaLocalVariable* _tmp1627_;
		ValaLocalVariable* _tmp1628_;
		const gchar* _tmp1629_;
		const gchar* _tmp1630_;
		ValaCCodeExpression* _tmp1631_;
		ValaLocalVariable* _tmp1632_;
		ValaHashMap* _tmp1633_;
		ValaCCodeExpression* _tmp1634_;
		ValaCCodeUnaryExpression* _tmp1635_;
		ValaCCodeUnaryExpression* _tmp1636_;
		_tmp1623_ = itype;
		_tmp1624_ = vala_data_type_get_return_type (_tmp1623_);
		_tmp1625_ = _tmp1624_;
		_tmp1626_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1625_, TRUE, NULL, TRUE);
		_tmp1627_ = _tmp1626_;
		_vala_code_node_unref0 (_tmp1625_);
		out_param_var = _tmp1627_;
		_tmp1628_ = out_param_var;
		_tmp1629_ = vala_symbol_get_name ((ValaSymbol*) _tmp1628_);
		_tmp1630_ = _tmp1629_;
		_tmp1631_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1630_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1631_;
		_tmp1632_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1632_, FALSE);
		_tmp1633_ = out_arg_map;
		_tmp1634_ = out_param_ref;
		_tmp1635_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1634_);
		_tmp1636_ = _tmp1635_;
		vala_map_set ((ValaMap*) _tmp1633_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1636_);
		_vala_ccode_node_unref0 (_tmp1636_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1637_ = async_call;
	_tmp1638_ = ccall;
	if (_tmp1637_ != _tmp1638_) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1655_;
			ValaCCodeFunctionCall* _tmp1656_;
			ValaHashMap* _tmp1657_;
			gint _tmp1658_;
			gpointer _tmp1659_;
			ValaCCodeExpression* _tmp1660_;
			gint _tmp1661_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1639_;
				ValaSet* _tmp1640_;
				ValaSet* _tmp1641_;
				ValaIterator* _tmp1642_;
				ValaIterator* _tmp1643_;
				_tmp1639_ = out_arg_map;
				_tmp1640_ = vala_map_get_keys ((ValaMap*) _tmp1639_);
				_tmp1641_ = _tmp1640_;
				_tmp1642_ = vala_iterable_iterator ((ValaIterable*) _tmp1641_);
				_tmp1643_ = _tmp1642_;
				_vala_iterable_unref0 (_tmp1641_);
				_pos_it = _tmp1643_;
				while (TRUE) {
					ValaIterator* _tmp1644_;
					gint pos = 0;
					ValaIterator* _tmp1645_;
					gpointer _tmp1646_;
					gboolean _tmp1647_ = FALSE;
					gint _tmp1648_;
					gint _tmp1649_;
					_tmp1644_ = _pos_it;
					if (!vala_iterator_next (_tmp1644_)) {
						break;
					}
					_tmp1645_ = _pos_it;
					_tmp1646_ = vala_iterator_get (_tmp1645_);
					pos = (gint) ((gintptr) _tmp1646_);
					_tmp1648_ = pos;
					_tmp1649_ = last_pos;
					if (_tmp1648_ > _tmp1649_) {
						gboolean _tmp1650_ = FALSE;
						gint _tmp1651_;
						_tmp1651_ = min_pos;
						if (_tmp1651_ == -1) {
							_tmp1650_ = TRUE;
						} else {
							gint _tmp1652_;
							gint _tmp1653_;
							_tmp1652_ = pos;
							_tmp1653_ = min_pos;
							_tmp1650_ = _tmp1652_ < _tmp1653_;
						}
						_tmp1647_ = _tmp1650_;
					} else {
						_tmp1647_ = FALSE;
					}
					if (_tmp1647_) {
						gint _tmp1654_;
						_tmp1654_ = pos;
						min_pos = _tmp1654_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1655_ = min_pos;
			if (_tmp1655_ == -1) {
				break;
			}
			_tmp1656_ = ccall;
			_tmp1657_ = out_arg_map;
			_tmp1658_ = min_pos;
			_tmp1659_ = vala_map_get ((ValaMap*) _tmp1657_, (gpointer) ((gintptr) _tmp1658_));
			_tmp1660_ = (ValaCCodeExpression*) _tmp1659_;
			vala_ccode_function_call_add_argument (_tmp1656_, _tmp1660_);
			_vala_ccode_node_unref0 (_tmp1660_);
			_tmp1661_ = min_pos;
			last_pos = _tmp1661_;
		}
	}
	_tmp1662_ = async_call;
	if (_tmp1662_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1679_;
			ValaCCodeFunctionCall* _tmp1680_;
			ValaHashMap* _tmp1681_;
			gint _tmp1682_;
			gpointer _tmp1683_;
			ValaCCodeExpression* _tmp1684_;
			gint _tmp1685_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1663_;
				ValaSet* _tmp1664_;
				ValaSet* _tmp1665_;
				ValaIterator* _tmp1666_;
				ValaIterator* _tmp1667_;
				_tmp1663_ = in_arg_map;
				_tmp1664_ = vala_map_get_keys ((ValaMap*) _tmp1663_);
				_tmp1665_ = _tmp1664_;
				_tmp1666_ = vala_iterable_iterator ((ValaIterable*) _tmp1665_);
				_tmp1667_ = _tmp1666_;
				_vala_iterable_unref0 (_tmp1665_);
				_pos_it = _tmp1667_;
				while (TRUE) {
					ValaIterator* _tmp1668_;
					gint pos = 0;
					ValaIterator* _tmp1669_;
					gpointer _tmp1670_;
					gboolean _tmp1671_ = FALSE;
					gint _tmp1672_;
					gint _tmp1673_;
					_tmp1668_ = _pos_it;
					if (!vala_iterator_next (_tmp1668_)) {
						break;
					}
					_tmp1669_ = _pos_it;
					_tmp1670_ = vala_iterator_get (_tmp1669_);
					pos = (gint) ((gintptr) _tmp1670_);
					_tmp1672_ = pos;
					_tmp1673_ = last_pos;
					if (_tmp1672_ > _tmp1673_) {
						gboolean _tmp1674_ = FALSE;
						gint _tmp1675_;
						_tmp1675_ = min_pos;
						if (_tmp1675_ == -1) {
							_tmp1674_ = TRUE;
						} else {
							gint _tmp1676_;
							gint _tmp1677_;
							_tmp1676_ = pos;
							_tmp1677_ = min_pos;
							_tmp1674_ = _tmp1676_ < _tmp1677_;
						}
						_tmp1671_ = _tmp1674_;
					} else {
						_tmp1671_ = FALSE;
					}
					if (_tmp1671_) {
						gint _tmp1678_;
						_tmp1678_ = pos;
						min_pos = _tmp1678_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1679_ = min_pos;
			if (_tmp1679_ == -1) {
				break;
			}
			_tmp1680_ = async_call;
			_tmp1681_ = in_arg_map;
			_tmp1682_ = min_pos;
			_tmp1683_ = vala_map_get ((ValaMap*) _tmp1681_, (gpointer) ((gintptr) _tmp1682_));
			_tmp1684_ = (ValaCCodeExpression*) _tmp1683_;
			vala_ccode_function_call_add_argument (_tmp1680_, _tmp1684_);
			_vala_ccode_node_unref0 (_tmp1684_);
			_tmp1685_ = min_pos;
			last_pos = _tmp1685_;
		}
	}
	_tmp1686_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1687_ = _tmp1686_;
	if (_tmp1687_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1688_;
		gint _tmp1689_;
		ValaCCodeFunction* _tmp1690_;
		ValaCCodeFunction* _tmp1691_;
		ValaCCodeIdentifier* _tmp1692_;
		ValaCCodeIdentifier* _tmp1693_;
		ValaCCodeMemberAccess* _tmp1694_;
		ValaCCodeMemberAccess* _tmp1695_;
		gint _tmp1696_;
		gchar* _tmp1697_;
		gchar* _tmp1698_;
		ValaCCodeConstant* _tmp1699_;
		ValaCCodeConstant* _tmp1700_;
		ValaCCodeFunction* _tmp1701_;
		ValaCCodeFunction* _tmp1702_;
		ValaCCodeFunctionCall* _tmp1703_;
		ValaCCodeFunction* _tmp1704_;
		ValaCCodeFunction* _tmp1705_;
		ValaCCodeConstant* _tmp1706_;
		ValaCCodeConstant* _tmp1707_;
		ValaCCodeFunction* _tmp1708_;
		ValaCCodeFunction* _tmp1709_;
		gint _tmp1710_;
		gchar* _tmp1711_;
		gchar* _tmp1712_;
		_tmp1688_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1689_ = _tmp1688_->next_coroutine_state;
		_tmp1688_->next_coroutine_state = _tmp1689_ + 1;
		state = _tmp1689_;
		_tmp1690_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1691_ = _tmp1690_;
		_tmp1692_ = vala_ccode_identifier_new ("_data_");
		_tmp1693_ = _tmp1692_;
		_tmp1694_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1693_, "_state_");
		_tmp1695_ = _tmp1694_;
		_tmp1696_ = state;
		_tmp1697_ = g_strdup_printf ("%i", _tmp1696_);
		_tmp1698_ = _tmp1697_;
		_tmp1699_ = vala_ccode_constant_new (_tmp1698_);
		_tmp1700_ = _tmp1699_;
		vala_ccode_function_add_assignment (_tmp1691_, (ValaCCodeExpression*) _tmp1695_, (ValaCCodeExpression*) _tmp1700_);
		_vala_ccode_node_unref0 (_tmp1700_);
		_g_free0 (_tmp1698_);
		_vala_ccode_node_unref0 (_tmp1695_);
		_vala_ccode_node_unref0 (_tmp1693_);
		_tmp1701_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1702_ = _tmp1701_;
		_tmp1703_ = async_call;
		vala_ccode_function_add_expression (_tmp1702_, (ValaCCodeExpression*) _tmp1703_);
		_tmp1704_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1705_ = _tmp1704_;
		_tmp1706_ = vala_ccode_constant_new ("FALSE");
		_tmp1707_ = _tmp1706_;
		vala_ccode_function_add_return (_tmp1705_, (ValaCCodeExpression*) _tmp1707_);
		_vala_ccode_node_unref0 (_tmp1707_);
		_tmp1708_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1709_ = _tmp1708_;
		_tmp1710_ = state;
		_tmp1711_ = g_strdup_printf ("_state_%d", _tmp1710_);
		_tmp1712_ = _tmp1711_;
		vala_ccode_function_add_label (_tmp1709_, _tmp1712_);
		_g_free0 (_tmp1712_);
	}
	_tmp1713_ = vala_method_call_get_is_assert (expr);
	_tmp1714_ = _tmp1713_;
	if (_tmp1714_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1715_;
		ValaSourceReference* _tmp1716_;
		ValaSourceLocation _tmp1717_ = {0};
		ValaSourceLocation _tmp1718_;
		gchar* _tmp1719_;
		ValaSourceReference* _tmp1720_;
		ValaSourceReference* _tmp1721_;
		ValaSourceLocation _tmp1722_ = {0};
		ValaSourceLocation _tmp1723_;
		gchar* _tmp1724_;
		ValaSourceReference* _tmp1725_;
		ValaSourceReference* _tmp1726_;
		ValaSourceLocation _tmp1727_ = {0};
		ValaSourceLocation _tmp1728_;
		gchar* _tmp1729_;
		gchar* _tmp1730_;
		ValaCCodeFunctionCall* _tmp1731_;
		ValaCCodeIdentifier* _tmp1732_;
		ValaCCodeIdentifier* _tmp1733_;
		ValaCCodeFunctionCall* _tmp1734_;
		const gchar* _tmp1735_;
		gchar* _tmp1736_;
		gchar* _tmp1737_;
		gchar* _tmp1738_;
		gchar* _tmp1739_;
		gchar* _tmp1740_;
		gchar* _tmp1741_;
		ValaCCodeConstant* _tmp1742_;
		ValaCCodeConstant* _tmp1743_;
		_tmp1715_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1716_ = _tmp1715_;
		vala_source_reference_get_begin (_tmp1716_, &_tmp1717_);
		_tmp1718_ = _tmp1717_;
		_tmp1719_ = _tmp1718_.pos;
		_tmp1720_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1721_ = _tmp1720_;
		vala_source_reference_get_end (_tmp1721_, &_tmp1722_);
		_tmp1723_ = _tmp1722_;
		_tmp1724_ = _tmp1723_.pos;
		_tmp1725_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1726_ = _tmp1725_;
		vala_source_reference_get_begin (_tmp1726_, &_tmp1727_);
		_tmp1728_ = _tmp1727_;
		_tmp1729_ = _tmp1728_.pos;
		_tmp1730_ = string_substring ((const gchar*) _tmp1719_, (glong) 0, (glong) ((gint) (_tmp1724_ - _tmp1729_)));
		message = _tmp1730_;
		_tmp1731_ = ccall;
		_tmp1732_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1733_ = _tmp1732_;
		vala_ccode_function_call_set_call (_tmp1731_, (ValaCCodeExpression*) _tmp1733_);
		_vala_ccode_node_unref0 (_tmp1733_);
		_tmp1734_ = ccall;
		_tmp1735_ = message;
		_tmp1736_ = string_replace (_tmp1735_, "\n", " ");
		_tmp1737_ = _tmp1736_;
		_tmp1738_ = g_strescape (_tmp1737_, "");
		_tmp1739_ = _tmp1738_;
		_tmp1740_ = g_strdup_printf ("\"%s\"", _tmp1739_);
		_tmp1741_ = _tmp1740_;
		_tmp1742_ = vala_ccode_constant_new (_tmp1741_);
		_tmp1743_ = _tmp1742_;
		vala_ccode_function_call_add_argument (_tmp1734_, (ValaCCodeExpression*) _tmp1743_);
		_vala_ccode_node_unref0 (_tmp1743_);
		_g_free0 (_tmp1741_);
		_g_free0 (_tmp1739_);
		_g_free0 (_tmp1737_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	_tmp1744_ = return_result_via_out_param;
	if (_tmp1744_) {
		ValaCCodeFunction* _tmp1745_;
		ValaCCodeFunction* _tmp1746_;
		ValaCCodeExpression* _tmp1747_;
		ValaCCodeExpression* _tmp1748_;
		ValaCCodeExpression* _tmp1749_;
		_tmp1745_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1746_ = _tmp1745_;
		_tmp1747_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1746_, _tmp1747_);
		_tmp1748_ = out_param_ref;
		_tmp1749_ = _vala_ccode_node_ref0 (_tmp1748_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1749_;
	}
	_tmp1752_ = m;
	if (_tmp1752_ != NULL) {
		ValaMethod* _tmp1753_;
		ValaMemberBinding _tmp1754_;
		ValaMemberBinding _tmp1755_;
		_tmp1753_ = m;
		_tmp1754_ = vala_method_get_binding (_tmp1753_);
		_tmp1755_ = _tmp1754_;
		_tmp1751_ = _tmp1755_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1751_ = FALSE;
	}
	if (_tmp1751_) {
		ValaMethod* _tmp1756_;
		gboolean _tmp1757_;
		gboolean _tmp1758_;
		_tmp1756_ = m;
		_tmp1757_ = vala_method_get_returns_modified_pointer (_tmp1756_);
		_tmp1758_ = _tmp1757_;
		_tmp1750_ = _tmp1758_;
	} else {
		_tmp1750_ = FALSE;
	}
	if (_tmp1750_) {
		gboolean _tmp1759_ = FALSE;
		gboolean _tmp1760_ = FALSE;
		ValaMemberAccess* _tmp1761_;
		_tmp1761_ = ma;
		if (_tmp1761_ != NULL) {
			ValaMemberAccess* _tmp1762_;
			ValaExpression* _tmp1763_;
			ValaExpression* _tmp1764_;
			ValaSymbol* _tmp1765_;
			ValaSymbol* _tmp1766_;
			_tmp1762_ = ma;
			_tmp1763_ = vala_member_access_get_inner (_tmp1762_);
			_tmp1764_ = _tmp1763_;
			_tmp1765_ = vala_expression_get_symbol_reference (_tmp1764_);
			_tmp1766_ = _tmp1765_;
			_tmp1760_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1766_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1760_ = FALSE;
		}
		if (_tmp1760_) {
			ValaMemberAccess* _tmp1767_;
			ValaExpression* _tmp1768_;
			ValaExpression* _tmp1769_;
			_tmp1767_ = ma;
			_tmp1768_ = vala_member_access_get_inner (_tmp1767_);
			_tmp1769_ = _tmp1768_;
			_tmp1759_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1769_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1759_ = FALSE;
		}
		if (_tmp1759_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1770_;
			ValaExpression* _tmp1771_;
			ValaExpression* _tmp1772_;
			ValaSymbol* _tmp1773_;
			ValaSymbol* _tmp1774_;
			ValaProperty* _tmp1775_;
			ValaProperty* _tmp1776_;
			ValaMemberAccess* _tmp1777_;
			ValaExpression* _tmp1778_;
			ValaExpression* _tmp1779_;
			ValaExpression* _tmp1780_;
			ValaExpression* _tmp1781_;
			ValaDataType* _tmp1782_;
			ValaDataType* _tmp1783_;
			ValaCCodeExpression* _tmp1784_;
			ValaGLibValue* _tmp1785_;
			ValaGLibValue* _tmp1786_;
			_tmp1770_ = ma;
			_tmp1771_ = vala_member_access_get_inner (_tmp1770_);
			_tmp1772_ = _tmp1771_;
			_tmp1773_ = vala_expression_get_symbol_reference (_tmp1772_);
			_tmp1774_ = _tmp1773_;
			_tmp1775_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1774_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1775_;
			_tmp1776_ = prop;
			_tmp1777_ = ma;
			_tmp1778_ = vala_member_access_get_inner (_tmp1777_);
			_tmp1779_ = _tmp1778_;
			_tmp1780_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1779_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1781_ = _tmp1780_;
			_tmp1782_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1783_ = _tmp1782_;
			_tmp1784_ = ccall_expr;
			_tmp1785_ = vala_glib_value_new (_tmp1783_, _tmp1784_, FALSE);
			_tmp1786_ = _tmp1785_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1776_, _tmp1781_, (ValaTargetValue*) _tmp1786_);
			_vala_target_value_unref0 (_tmp1786_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1787_;
			ValaCCodeExpression* _tmp1788_;
			ValaCCodeAssignment* _tmp1789_;
			_tmp1787_ = instance;
			_tmp1788_ = ccall_expr;
			_tmp1789_ = vala_ccode_assignment_new (_tmp1787_, _tmp1788_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1789_;
		}
	}
	_tmp1795_ = m;
	if (_tmp1795_ != NULL) {
		ValaMethod* _tmp1796_;
		_tmp1796_ = m;
		_tmp1794_ = vala_get_ccode_simple_generics (_tmp1796_);
	} else {
		_tmp1794_ = FALSE;
	}
	if (_tmp1794_) {
		ValaMethod* _tmp1797_;
		ValaDataType* _tmp1798_;
		ValaDataType* _tmp1799_;
		_tmp1797_ = m;
		_tmp1798_ = vala_callable_get_return_type ((ValaCallable*) _tmp1797_);
		_tmp1799_ = _tmp1798_;
		_tmp1793_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1799_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1793_ = FALSE;
	}
	if (_tmp1793_) {
		ValaDataType* _tmp1800_;
		ValaDataType* _tmp1801_;
		_tmp1800_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1801_ = _tmp1800_;
		_tmp1792_ = vala_data_type_is_real_struct_type (_tmp1801_);
	} else {
		_tmp1792_ = FALSE;
	}
	if (_tmp1792_) {
		ValaDataType* _tmp1802_;
		ValaDataType* _tmp1803_;
		gboolean _tmp1804_;
		gboolean _tmp1805_;
		_tmp1802_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1803_ = _tmp1802_;
		_tmp1804_ = vala_data_type_get_nullable (_tmp1803_);
		_tmp1805_ = _tmp1804_;
		_tmp1791_ = !_tmp1805_;
	} else {
		_tmp1791_ = FALSE;
	}
	if (_tmp1791_) {
		ValaDataType* _tmp1806_;
		ValaDataType* _tmp1807_;
		_tmp1806_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1807_ = _tmp1806_;
		_tmp1790_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1807_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1790_ = FALSE;
	}
	if (_tmp1790_) {
		ValaCCodeExpression* _tmp1808_;
		ValaCCodeParenthesizedExpression* _tmp1809_;
		ValaCCodeParenthesizedExpression* _tmp1810_;
		ValaCCodeUnaryExpression* _tmp1811_;
		_tmp1808_ = ccall_expr;
		_tmp1809_ = vala_ccode_parenthesized_expression_new (_tmp1808_);
		_tmp1810_ = _tmp1809_;
		_tmp1811_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1810_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1811_;
		_vala_ccode_node_unref0 (_tmp1810_);
	}
	_tmp1814_ = m;
	if (_tmp1814_ != NULL) {
		ValaMethod* _tmp1815_;
		gchar* _tmp1816_;
		gchar* _tmp1817_;
		_tmp1815_ = m;
		_tmp1816_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1815_);
		_tmp1817_ = _tmp1816_;
		_tmp1813_ = _tmp1817_ != NULL;
		_g_free0 (_tmp1817_);
	} else {
		_tmp1813_ = FALSE;
	}
	if (_tmp1813_) {
		ValaMethod* _tmp1818_;
		gchar* _tmp1819_;
		gchar* _tmp1820_;
		ValaMethod* _tmp1821_;
		ValaDataType* _tmp1822_;
		ValaDataType* _tmp1823_;
		gchar* _tmp1824_;
		gchar* _tmp1825_;
		_tmp1818_ = m;
		_tmp1819_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1818_);
		_tmp1820_ = _tmp1819_;
		_tmp1821_ = m;
		_tmp1822_ = vala_callable_get_return_type ((ValaCallable*) _tmp1821_);
		_tmp1823_ = _tmp1822_;
		_tmp1824_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1823_);
		_tmp1825_ = _tmp1824_;
		_tmp1812_ = g_strcmp0 (_tmp1820_, _tmp1825_) != 0;
		_g_free0 (_tmp1825_);
		_g_free0 (_tmp1820_);
	} else {
		_tmp1812_ = FALSE;
	}
	if (_tmp1812_) {
		ValaCCodeExpression* _tmp1826_;
		ValaMethod* _tmp1827_;
		ValaDataType* _tmp1828_;
		ValaDataType* _tmp1829_;
		gchar* _tmp1830_;
		gchar* _tmp1831_;
		ValaCCodeCastExpression* _tmp1832_;
		_tmp1826_ = ccall_expr;
		_tmp1827_ = m;
		_tmp1828_ = vala_callable_get_return_type ((ValaCallable*) _tmp1827_);
		_tmp1829_ = _tmp1828_;
		_tmp1830_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1829_);
		_tmp1831_ = _tmp1830_;
		_tmp1832_ = vala_ccode_cast_expression_new (_tmp1826_, _tmp1831_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1832_;
		_g_free0 (_tmp1831_);
	}
	_tmp1833_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1833_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1834_;
		ValaList* _tmp1835_;
		ValaIterator* _tmp1836_;
		ValaIterator* _tmp1837_;
		ValaIterator* _tmp1838_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1839_;
		gpointer _tmp1840_;
		ValaExpression* _tmp1841_;
		ValaCCodeExpression* _tmp1842_;
		ValaCCodeExpression* _tmp1843_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1844_;
		ValaLocalVariable* _tmp1845_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1846_;
		const gchar* _tmp1847_;
		const gchar* _tmp1848_;
		ValaCCodeExpression* _tmp1849_;
		ValaLocalVariable* _tmp1850_;
		ValaCCodeFile* _tmp1851_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1852_;
		ValaExpression* _tmp1853_;
		ValaExpression* _tmp1854_;
		ValaCCodeExpression* _tmp1855_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1856_;
		ValaExpression* _tmp1857_;
		ValaExpression* _tmp1858_;
		ValaCCodeExpression* _tmp1859_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1860_;
		ValaExpression* _tmp1861_;
		ValaExpression* _tmp1862_;
		ValaDataType* _tmp1863_;
		ValaDataType* _tmp1864_;
		ValaArrayType* _tmp1865_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1866_;
		ValaDataType* _tmp1867_;
		ValaDataType* _tmp1868_;
		gchar* _tmp1869_;
		gchar* _tmp1870_;
		gchar* _tmp1871_;
		gchar* _tmp1872_;
		ValaCCodeIdentifier* _tmp1873_;
		ValaCCodeIdentifier* _tmp1874_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1875_;
		ValaCCodeExpression* _tmp1876_;
		ValaCCodeBinaryExpression* _tmp1877_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1878_;
		ValaCCodeExpression* _tmp1879_;
		ValaCCodeBinaryExpression* _tmp1880_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1881_;
		ValaCCodeIdentifier* _tmp1882_;
		ValaCCodeFunctionCall* _tmp1883_;
		ValaCCodeFunctionCall* _tmp1884_;
		ValaCCodeFunctionCall* _tmp1885_;
		ValaCCodeExpression* _tmp1886_;
		ValaCCodeExpression* _tmp1887_;
		ValaCCodeBinaryExpression* _tmp1888_;
		ValaCCodeBinaryExpression* _tmp1889_;
		ValaCCodeFunctionCall* _tmp1890_;
		ValaCCodeConstant* _tmp1891_;
		ValaCCodeConstant* _tmp1892_;
		ValaCCodeFunctionCall* _tmp1893_;
		ValaCCodeIdentifier* _tmp1894_;
		ValaCCodeBinaryExpression* _tmp1895_;
		ValaCCodeBinaryExpression* _tmp1896_;
		ValaCCodeBinaryExpression* _tmp1897_;
		ValaCCodeFunction* _tmp1898_;
		ValaCCodeFunction* _tmp1899_;
		ValaCCodeExpression* _tmp1900_;
		ValaCCodeExpression* _tmp1901_;
		ValaCCodeFunction* _tmp1902_;
		ValaCCodeFunction* _tmp1903_;
		ValaCCodeExpression* _tmp1904_;
		ValaCCodeFunction* _tmp1905_;
		ValaCCodeFunction* _tmp1906_;
		ValaCCodeBinaryExpression* _tmp1907_;
		ValaCCodeFunctionCall* _tmp1908_;
		ValaCCodeConstant* _tmp1909_;
		ValaCCodeConstant* _tmp1910_;
		ValaCCodeConditionalExpression* _tmp1911_;
		ValaCCodeConditionalExpression* _tmp1912_;
		ValaCCodeFunction* _tmp1913_;
		ValaCCodeFunction* _tmp1914_;
		ValaMemberAccess* _tmp1915_;
		ValaExpression* _tmp1916_;
		ValaExpression* _tmp1917_;
		ValaCCodeExpression* _tmp1918_;
		ValaCCodeExpression* _tmp1919_;
		ValaCCodeExpression* _tmp1920_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1921_;
		ValaExpression* _tmp1922_;
		ValaExpression* _tmp1923_;
		ValaSymbol* _tmp1924_;
		ValaSymbol* _tmp1925_;
		ValaSymbol* _tmp1926_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1927_;
		ValaLocalVariable* _tmp1928_;
		gboolean _tmp1929_ = FALSE;
		gboolean _tmp1930_ = FALSE;
		ValaSymbol* _tmp1931_;
		_tmp1834_ = vala_method_call_get_argument_list (expr);
		_tmp1835_ = _tmp1834_;
		_tmp1836_ = vala_iterable_iterator ((ValaIterable*) _tmp1835_);
		_tmp1837_ = _tmp1836_;
		_vala_iterable_unref0 (_tmp1835_);
		arg_it = _tmp1837_;
		_tmp1838_ = arg_it;
		vala_iterator_next (_tmp1838_);
		_tmp1839_ = arg_it;
		_tmp1840_ = vala_iterator_get (_tmp1839_);
		_tmp1841_ = (ValaExpression*) _tmp1840_;
		_tmp1842_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1841_);
		_tmp1843_ = _tmp1842_;
		_vala_code_node_unref0 (_tmp1841_);
		new_size = _tmp1843_;
		_tmp1844_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1845_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1844_, TRUE, NULL, FALSE);
		temp_decl = _tmp1845_;
		_tmp1846_ = temp_decl;
		_tmp1847_ = vala_symbol_get_name ((ValaSymbol*) _tmp1846_);
		_tmp1848_ = _tmp1847_;
		_tmp1849_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1848_);
		temp_ref = _tmp1849_;
		_tmp1850_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1850_, FALSE);
		_tmp1851_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1851_, "string.h", FALSE);
		_tmp1852_ = ma;
		_tmp1853_ = vala_member_access_get_inner (_tmp1852_);
		_tmp1854_ = _tmp1853_;
		_tmp1855_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1854_, 1);
		clen = _tmp1855_;
		_tmp1856_ = ma;
		_tmp1857_ = vala_member_access_get_inner (_tmp1856_);
		_tmp1858_ = _tmp1857_;
		_tmp1859_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1858_);
		celems = _tmp1859_;
		_tmp1860_ = ma;
		_tmp1861_ = vala_member_access_get_inner (_tmp1860_);
		_tmp1862_ = _tmp1861_;
		_tmp1863_ = vala_expression_get_value_type (_tmp1862_);
		_tmp1864_ = _tmp1863_;
		_tmp1865_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1864_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1865_;
		_tmp1866_ = array_type;
		_tmp1867_ = vala_array_type_get_element_type (_tmp1866_);
		_tmp1868_ = _tmp1867_;
		_tmp1869_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1868_);
		_tmp1870_ = _tmp1869_;
		_tmp1871_ = g_strdup_printf ("sizeof (%s)", _tmp1870_);
		_tmp1872_ = _tmp1871_;
		_tmp1873_ = vala_ccode_identifier_new (_tmp1872_);
		_tmp1874_ = _tmp1873_;
		_g_free0 (_tmp1872_);
		_g_free0 (_tmp1870_);
		csizeof = _tmp1874_;
		_tmp1875_ = temp_ref;
		_tmp1876_ = clen;
		_tmp1877_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1875_, _tmp1876_);
		cdelta = _tmp1877_;
		_tmp1878_ = temp_ref;
		_tmp1879_ = clen;
		_tmp1880_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1878_, _tmp1879_);
		ccheck = _tmp1880_;
		_tmp1881_ = vala_ccode_identifier_new ("memset");
		_tmp1882_ = _tmp1881_;
		_tmp1883_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1882_);
		_tmp1884_ = _tmp1883_;
		_vala_ccode_node_unref0 (_tmp1882_);
		czero = _tmp1884_;
		_tmp1885_ = czero;
		_tmp1886_ = celems;
		_tmp1887_ = clen;
		_tmp1888_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1886_, _tmp1887_);
		_tmp1889_ = _tmp1888_;
		vala_ccode_function_call_add_argument (_tmp1885_, (ValaCCodeExpression*) _tmp1889_);
		_vala_ccode_node_unref0 (_tmp1889_);
		_tmp1890_ = czero;
		_tmp1891_ = vala_ccode_constant_new ("0");
		_tmp1892_ = _tmp1891_;
		vala_ccode_function_call_add_argument (_tmp1890_, (ValaCCodeExpression*) _tmp1892_);
		_vala_ccode_node_unref0 (_tmp1892_);
		_tmp1893_ = czero;
		_tmp1894_ = csizeof;
		_tmp1895_ = cdelta;
		_tmp1896_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1894_, (ValaCCodeExpression*) _tmp1895_);
		_tmp1897_ = _tmp1896_;
		vala_ccode_function_call_add_argument (_tmp1893_, (ValaCCodeExpression*) _tmp1897_);
		_vala_ccode_node_unref0 (_tmp1897_);
		_tmp1898_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1899_ = _tmp1898_;
		_tmp1900_ = temp_ref;
		_tmp1901_ = new_size;
		vala_ccode_function_add_assignment (_tmp1899_, _tmp1900_, _tmp1901_);
		_tmp1902_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1903_ = _tmp1902_;
		_tmp1904_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1903_, _tmp1904_);
		_tmp1905_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1906_ = _tmp1905_;
		_tmp1907_ = ccheck;
		_tmp1908_ = czero;
		_tmp1909_ = vala_ccode_constant_new ("NULL");
		_tmp1910_ = _tmp1909_;
		_tmp1911_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1907_, (ValaCCodeExpression*) _tmp1908_, (ValaCCodeExpression*) _tmp1910_);
		_tmp1912_ = _tmp1911_;
		vala_ccode_function_add_expression (_tmp1906_, (ValaCCodeExpression*) _tmp1912_);
		_vala_ccode_node_unref0 (_tmp1912_);
		_vala_ccode_node_unref0 (_tmp1910_);
		_tmp1913_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1914_ = _tmp1913_;
		_tmp1915_ = ma;
		_tmp1916_ = vala_member_access_get_inner (_tmp1915_);
		_tmp1917_ = _tmp1916_;
		_tmp1918_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1917_, 1);
		_tmp1919_ = _tmp1918_;
		_tmp1920_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1914_, _tmp1919_, _tmp1920_);
		_vala_ccode_node_unref0 (_tmp1919_);
		_tmp1921_ = ma;
		_tmp1922_ = vala_member_access_get_inner (_tmp1921_);
		_tmp1923_ = _tmp1922_;
		_tmp1924_ = vala_expression_get_symbol_reference (_tmp1923_);
		_tmp1925_ = _tmp1924_;
		_tmp1926_ = _vala_code_node_ref0 (_tmp1925_);
		array_var = _tmp1926_;
		_tmp1927_ = array_var;
		_tmp1928_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1927_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1927_) : NULL);
		array_local = _tmp1928_;
		_tmp1931_ = array_var;
		if (_tmp1931_ != NULL) {
			ValaSymbol* _tmp1932_;
			_tmp1932_ = array_var;
			_tmp1930_ = vala_symbol_is_internal_symbol (_tmp1932_);
		} else {
			_tmp1930_ = FALSE;
		}
		if (_tmp1930_) {
			gboolean _tmp1933_ = FALSE;
			gboolean _tmp1934_ = FALSE;
			ValaSymbol* _tmp1935_;
			_tmp1935_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1935_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1936_;
				gboolean _tmp1937_;
				gboolean _tmp1938_;
				_tmp1936_ = array_local;
				_tmp1937_ = vala_local_variable_get_captured (_tmp1936_);
				_tmp1938_ = _tmp1937_;
				_tmp1934_ = !_tmp1938_;
			} else {
				_tmp1934_ = FALSE;
			}
			if (_tmp1934_) {
				_tmp1933_ = TRUE;
			} else {
				ValaSymbol* _tmp1939_;
				_tmp1939_ = array_var;
				_tmp1933_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1939_, VALA_TYPE_FIELD);
			}
			_tmp1929_ = _tmp1933_;
		} else {
			_tmp1929_ = FALSE;
		}
		if (_tmp1929_) {
			ValaCCodeFunction* _tmp1940_;
			ValaCCodeFunction* _tmp1941_;
			ValaMemberAccess* _tmp1942_;
			ValaExpression* _tmp1943_;
			ValaExpression* _tmp1944_;
			ValaTargetValue* _tmp1945_;
			ValaTargetValue* _tmp1946_;
			ValaCCodeExpression* _tmp1947_;
			ValaCCodeExpression* _tmp1948_;
			ValaCCodeExpression* _tmp1949_;
			_tmp1940_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1941_ = _tmp1940_;
			_tmp1942_ = ma;
			_tmp1943_ = vala_member_access_get_inner (_tmp1942_);
			_tmp1944_ = _tmp1943_;
			_tmp1945_ = vala_expression_get_target_value (_tmp1944_);
			_tmp1946_ = _tmp1945_;
			_tmp1947_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1946_);
			_tmp1948_ = _tmp1947_;
			_tmp1949_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1941_, _tmp1948_, _tmp1949_);
			_vala_ccode_node_unref0 (_tmp1948_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1951_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1952_ = _tmp1951_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1952_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1953_;
		ValaDataType* _tmp1954_;
		_tmp1953_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1954_ = _tmp1953_;
		_tmp1950_ = !vala_data_type_is_disposable (_tmp1954_);
	} else {
		_tmp1950_ = FALSE;
	}
	if (_tmp1950_) {
		gboolean _tmp1955_ = FALSE;
		ValaCCodeExpression* _tmp1956_;
		_tmp1956_ = ccall_expr;
		if (_tmp1956_ != NULL) {
			gboolean _tmp1957_;
			_tmp1957_ = return_result_via_out_param;
			_tmp1955_ = !_tmp1957_;
		} else {
			_tmp1955_ = FALSE;
		}
		if (_tmp1955_) {
			ValaCCodeFunction* _tmp1958_;
			ValaCCodeFunction* _tmp1959_;
			ValaCCodeExpression* _tmp1960_;
			_tmp1958_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1959_ = _tmp1958_;
			_tmp1960_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1959_, _tmp1960_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1961_;
		ValaDataType* _tmp1962_;
		gboolean _tmp1963_ = FALSE;
		ValaDataType* _tmp1964_;
		ValaDataType* _tmp1965_;
		gboolean _tmp1992_ = FALSE;
		ValaMethod* _tmp1993_;
		_tmp1961_ = itype;
		_tmp1962_ = vala_data_type_get_return_type (_tmp1961_);
		result_type = _tmp1962_;
		_tmp1964_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1965_ = _tmp1964_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1965_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1966_;
			ValaDataType* _tmp1967_;
			_tmp1966_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1967_ = _tmp1966_;
			_tmp1963_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1967_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1963_ = FALSE;
		}
		if (_tmp1963_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1968_;
			ValaDataType* _tmp1969_;
			ValaTypeParameter* _tmp1970_;
			ValaTypeParameter* _tmp1971_;
			ValaTypeParameter* _tmp1972_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1973_;
			ValaSymbol* _tmp1974_;
			ValaSymbol* _tmp1975_;
			ValaSymbol* _tmp1976_;
			ValaSymbol* _tmp1977_;
			ValaStruct* _tmp1978_;
			gboolean _tmp1979_ = FALSE;
			ValaTypeParameter* _tmp1980_;
			ValaSymbol* _tmp1981_;
			ValaSymbol* _tmp1982_;
			ValaTypeSymbol* _tmp1983_;
			_tmp1968_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1969_ = _tmp1968_;
			_tmp1970_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1969_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1971_ = _tmp1970_;
			_tmp1972_ = _vala_code_node_ref0 (_tmp1971_);
			type_parameter = _tmp1972_;
			_tmp1973_ = type_parameter;
			_tmp1974_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1973_);
			_tmp1975_ = _tmp1974_;
			_tmp1976_ = vala_symbol_get_parent_symbol (_tmp1975_);
			_tmp1977_ = _tmp1976_;
			_tmp1978_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1977_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1977_) : NULL);
			st = _tmp1978_;
			_tmp1980_ = type_parameter;
			_tmp1981_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1980_);
			_tmp1982_ = _tmp1981_;
			_tmp1983_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1982_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1983_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1979_ = TRUE;
			} else {
				gboolean _tmp1984_ = FALSE;
				ValaStruct* _tmp1985_;
				_tmp1985_ = st;
				if (_tmp1985_ != NULL) {
					ValaStruct* _tmp1986_;
					gchar* _tmp1987_;
					gchar* _tmp1988_;
					_tmp1986_ = st;
					_tmp1987_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1986_);
					_tmp1988_ = _tmp1987_;
					_tmp1984_ = g_strcmp0 (_tmp1988_, "va_list") == 0;
					_g_free0 (_tmp1988_);
				} else {
					_tmp1984_ = FALSE;
				}
				_tmp1979_ = _tmp1984_;
			}
			if (_tmp1979_) {
				ValaDataType* _tmp1989_;
				ValaDataType* _tmp1990_;
				ValaDataType* _tmp1991_;
				_tmp1989_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1990_ = _tmp1989_;
				_tmp1991_ = _vala_code_node_ref0 (_tmp1990_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1991_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp1993_ = m;
		if (_tmp1993_ != NULL) {
			ValaMethod* _tmp1994_;
			_tmp1994_ = m;
			_tmp1992_ = vala_method_get_format_arg_index (_tmp1994_) >= 0;
		} else {
			_tmp1992_ = FALSE;
		}
		if (_tmp1992_) {
			ValaCCodeExpression* _tmp1995_;
			_tmp1995_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1995_);
		} else {
			gboolean _tmp1996_ = FALSE;
			ValaMethod* _tmp1997_;
			_tmp1997_ = m;
			if (_tmp1997_ != NULL) {
				ValaMethod* _tmp1998_;
				_tmp1998_ = m;
				_tmp1996_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp1998_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp1996_ = FALSE;
			}
			if (_tmp1996_) {
				ValaCCodeExpression* _tmp1999_;
				_tmp1999_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1999_);
			} else {
				gboolean _tmp2000_ = FALSE;
				gboolean _tmp2001_ = FALSE;
				gboolean _tmp2002_;
				_tmp2002_ = return_result_via_out_param;
				if (!_tmp2002_) {
					_tmp2001_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp2001_ = FALSE;
				}
				if (_tmp2001_) {
					gboolean _tmp2003_ = FALSE;
					ValaDataType* _tmp2004_;
					_tmp2004_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2004_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2005_;
						_tmp2005_ = result_type;
						_tmp2003_ = !vala_data_type_is_disposable (_tmp2005_);
					} else {
						_tmp2003_ = FALSE;
					}
					_tmp2000_ = _tmp2003_;
				} else {
					_tmp2000_ = FALSE;
				}
				if (_tmp2000_) {
					ValaCCodeExpression* _tmp2006_;
					_tmp2006_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2006_);
				} else {
					gboolean _tmp2007_;
					_tmp2007_ = return_result_via_out_param;
					if (!_tmp2007_) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2008_;
						ValaDataType* _tmp2009_;
						gboolean _tmp2010_;
						gboolean _tmp2011_;
						ValaLocalVariable* _tmp2012_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2013_;
						const gchar* _tmp2014_;
						const gchar* _tmp2015_;
						ValaCCodeExpression* _tmp2016_;
						ValaLocalVariable* _tmp2017_;
						ValaCCodeFunction* _tmp2018_;
						ValaCCodeFunction* _tmp2019_;
						ValaCCodeExpression* _tmp2020_;
						ValaCCodeExpression* _tmp2021_;
						ValaCCodeExpression* _tmp2022_;
						ValaTargetValue* _tmp2023_;
						ValaTargetValue* _tmp2024_;
						_tmp2008_ = result_type;
						_tmp2009_ = result_type;
						_tmp2010_ = vala_data_type_get_value_owned (_tmp2009_);
						_tmp2011_ = _tmp2010_;
						_tmp2012_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2008_, _tmp2011_, NULL, FALSE);
						temp_var = _tmp2012_;
						_tmp2013_ = temp_var;
						_tmp2014_ = vala_symbol_get_name ((ValaSymbol*) _tmp2013_);
						_tmp2015_ = _tmp2014_;
						_tmp2016_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2015_);
						temp_ref = _tmp2016_;
						_tmp2017_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2017_, FALSE);
						_tmp2018_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2019_ = _tmp2018_;
						_tmp2020_ = temp_ref;
						_tmp2021_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2019_, _tmp2020_, _tmp2021_);
						_tmp2022_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2022_);
						_tmp2023_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2024_ = _tmp2023_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2024_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2025_;
						ValaTargetValue* _tmp2026_;
						ValaTargetValue* _tmp2027_;
						_tmp2025_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2025_);
						_tmp2026_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2027_ = _tmp2026_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2027_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2028_ = params;
	_tmp2029_ = vala_iterable_iterator ((ValaIterable*) _tmp2028_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2029_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2030_;
		gint _arg_size = 0;
		ValaList* _tmp2031_;
		gint _tmp2032_;
		gint _tmp2033_;
		gint _arg_index = 0;
		_tmp2030_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp2030_;
		_tmp2031_ = _arg_list;
		_tmp2032_ = vala_collection_get_size ((ValaCollection*) _tmp2031_);
		_tmp2033_ = _tmp2032_;
		_arg_size = _tmp2033_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp2034_;
			gint _tmp2035_;
			gint _tmp2036_;
			ValaExpression* arg = NULL;
			ValaList* _tmp2037_;
			gint _tmp2038_;
			gpointer _tmp2039_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2040_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2043_;
			ValaUnaryExpression* _tmp2044_;
			gboolean _tmp2045_ = FALSE;
			ValaUnaryExpression* _tmp2046_;
			gboolean _tmp2100_ = FALSE;
			ValaUnaryExpression* _tmp2101_;
			ValaUnaryExpression* _tmp2105_;
			ValaExpression* _tmp2106_;
			ValaExpression* _tmp2107_;
			ValaDataType* _tmp2108_;
			ValaDataType* _tmp2109_;
			gboolean _tmp2119_ = FALSE;
			ValaMemberAccess* _tmp2120_;
			ValaSymbol* _tmp2121_;
			ValaSymbol* _tmp2122_;
			ValaUnaryExpression* _tmp2138_;
			ValaExpression* _tmp2139_;
			ValaExpression* _tmp2140_;
			ValaTargetValue* _tmp2141_;
			ValaTargetValue* _tmp2142_;
			ValaUnaryExpression* _tmp2143_;
			ValaTargetValue* _tmp2144_;
			ValaTargetValue* _tmp2145_;
			ValaUnaryExpression* _tmp2146_;
			ValaExpression* _tmp2147_;
			ValaExpression* _tmp2148_;
			ValaDataType* _tmp2149_;
			ValaDataType* _tmp2150_;
			ValaExpression* _tmp2151_;
			ValaTargetValue* _tmp2152_;
			ValaTargetValue* _tmp2153_;
			ValaSourceReference* _tmp2154_;
			ValaSourceReference* _tmp2155_;
			gboolean _tmp2156_ = FALSE;
			ValaParameter* _tmp2157_;
			_tmp2034_ = _arg_index;
			_arg_index = _tmp2034_ + 1;
			_tmp2035_ = _arg_index;
			_tmp2036_ = _arg_size;
			if (!(_tmp2035_ < _tmp2036_)) {
				break;
			}
			_tmp2037_ = _arg_list;
			_tmp2038_ = _arg_index;
			_tmp2039_ = vala_list_get (_tmp2037_, _tmp2038_);
			arg = (ValaExpression*) _tmp2039_;
			param = NULL;
			_tmp2040_ = params_it;
			if (vala_iterator_next (_tmp2040_)) {
				ValaIterator* _tmp2041_;
				gpointer _tmp2042_;
				_tmp2041_ = params_it;
				_tmp2042_ = vala_iterator_get (_tmp2041_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2042_;
			}
			_tmp2043_ = arg;
			_tmp2044_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2043_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2043_) : NULL);
			unary = _tmp2044_;
			_tmp2046_ = unary;
			if (_tmp2046_ != NULL) {
				ValaUnaryExpression* _tmp2047_;
				ValaUnaryOperator _tmp2048_;
				ValaUnaryOperator _tmp2049_;
				_tmp2047_ = unary;
				_tmp2048_ = vala_unary_expression_get_operator (_tmp2047_);
				_tmp2049_ = _tmp2048_;
				_tmp2045_ = _tmp2049_ == VALA_UNARY_OPERATOR_REF;
			} else {
				_tmp2045_ = FALSE;
			}
			if (_tmp2045_) {
				gboolean _tmp2050_ = FALSE;
				gboolean _tmp2051_ = FALSE;
				gboolean _tmp2052_ = FALSE;
				ValaParameter* _tmp2053_;
				_tmp2053_ = param;
				if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp2053_)) {
					ValaParameter* _tmp2054_;
					ValaDataType* _tmp2055_;
					ValaDataType* _tmp2056_;
					_tmp2054_ = param;
					_tmp2055_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2054_);
					_tmp2056_ = _tmp2055_;
					_tmp2052_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2056_, VALA_TYPE_ARRAY_TYPE);
				} else {
					_tmp2052_ = FALSE;
				}
				if (_tmp2052_) {
					ValaParameter* _tmp2057_;
					ValaDataType* _tmp2058_;
					ValaDataType* _tmp2059_;
					gboolean _tmp2060_;
					gboolean _tmp2061_;
					_tmp2057_ = param;
					_tmp2058_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2057_);
					_tmp2059_ = _tmp2058_;
					_tmp2060_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2059_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2061_ = _tmp2060_;
					_tmp2051_ = !_tmp2061_;
				} else {
					_tmp2051_ = FALSE;
				}
				if (_tmp2051_) {
					ValaParameter* _tmp2062_;
					ValaDataType* _tmp2063_;
					ValaDataType* _tmp2064_;
					gint _tmp2065_;
					gint _tmp2066_;
					_tmp2062_ = param;
					_tmp2063_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2062_);
					_tmp2064_ = _tmp2063_;
					_tmp2065_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp2064_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2066_ = _tmp2065_;
					_tmp2050_ = _tmp2066_ == 1;
				} else {
					_tmp2050_ = FALSE;
				}
				if (_tmp2050_) {
					ValaSymbol* array_var = NULL;
					ValaUnaryExpression* _tmp2067_;
					ValaExpression* _tmp2068_;
					ValaExpression* _tmp2069_;
					ValaSymbol* _tmp2070_;
					ValaSymbol* _tmp2071_;
					ValaLocalVariable* array_local = NULL;
					ValaSymbol* _tmp2072_;
					gboolean _tmp2073_ = FALSE;
					gboolean _tmp2074_ = FALSE;
					ValaSymbol* _tmp2075_;
					_tmp2067_ = unary;
					_tmp2068_ = vala_unary_expression_get_inner (_tmp2067_);
					_tmp2069_ = _tmp2068_;
					_tmp2070_ = vala_expression_get_symbol_reference (_tmp2069_);
					_tmp2071_ = _tmp2070_;
					array_var = _tmp2071_;
					_tmp2072_ = array_var;
					array_local = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2072_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp2072_) : NULL;
					_tmp2075_ = array_var;
					if (_tmp2075_ != NULL) {
						ValaSymbol* _tmp2076_;
						_tmp2076_ = array_var;
						_tmp2074_ = vala_symbol_is_internal_symbol (_tmp2076_);
					} else {
						_tmp2074_ = FALSE;
					}
					if (_tmp2074_) {
						gboolean _tmp2077_ = FALSE;
						gboolean _tmp2078_ = FALSE;
						ValaLocalVariable* _tmp2079_;
						_tmp2079_ = array_local;
						if (_tmp2079_ != NULL) {
							ValaLocalVariable* _tmp2080_;
							gboolean _tmp2081_;
							gboolean _tmp2082_;
							_tmp2080_ = array_local;
							_tmp2081_ = vala_local_variable_get_captured (_tmp2080_);
							_tmp2082_ = _tmp2081_;
							_tmp2078_ = !_tmp2082_;
						} else {
							_tmp2078_ = FALSE;
						}
						if (_tmp2078_) {
							_tmp2077_ = TRUE;
						} else {
							ValaSymbol* _tmp2083_;
							_tmp2083_ = array_var;
							_tmp2077_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2083_, VALA_TYPE_FIELD);
						}
						_tmp2073_ = _tmp2077_;
					} else {
						_tmp2073_ = FALSE;
					}
					if (_tmp2073_) {
						ValaCCodeFunction* _tmp2084_;
						ValaCCodeFunction* _tmp2085_;
						ValaUnaryExpression* _tmp2086_;
						ValaExpression* _tmp2087_;
						ValaExpression* _tmp2088_;
						ValaTargetValue* _tmp2089_;
						ValaTargetValue* _tmp2090_;
						ValaCCodeExpression* _tmp2091_;
						ValaCCodeExpression* _tmp2092_;
						ValaUnaryExpression* _tmp2093_;
						ValaExpression* _tmp2094_;
						ValaExpression* _tmp2095_;
						ValaTargetValue* _tmp2096_;
						ValaTargetValue* _tmp2097_;
						ValaCCodeExpression* _tmp2098_;
						ValaCCodeExpression* _tmp2099_;
						_tmp2084_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2085_ = _tmp2084_;
						_tmp2086_ = unary;
						_tmp2087_ = vala_unary_expression_get_inner (_tmp2086_);
						_tmp2088_ = _tmp2087_;
						_tmp2089_ = vala_expression_get_target_value (_tmp2088_);
						_tmp2090_ = _tmp2089_;
						_tmp2091_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp2090_);
						_tmp2092_ = _tmp2091_;
						_tmp2093_ = unary;
						_tmp2094_ = vala_unary_expression_get_inner (_tmp2093_);
						_tmp2095_ = _tmp2094_;
						_tmp2096_ = vala_expression_get_target_value (_tmp2095_);
						_tmp2097_ = _tmp2096_;
						_tmp2098_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2097_, 1);
						_tmp2099_ = _tmp2098_;
						vala_ccode_function_add_assignment (_tmp2085_, _tmp2092_, _tmp2099_);
						_vala_ccode_node_unref0 (_tmp2099_);
						_vala_ccode_node_unref0 (_tmp2092_);
					}
				}
			}
			_tmp2101_ = unary;
			if (_tmp2101_ == NULL) {
				_tmp2100_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2102_;
				ValaUnaryOperator _tmp2103_;
				ValaUnaryOperator _tmp2104_;
				_tmp2102_ = unary;
				_tmp2103_ = vala_unary_expression_get_operator (_tmp2102_);
				_tmp2104_ = _tmp2103_;
				_tmp2100_ = _tmp2104_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2100_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2105_ = unary;
			_tmp2106_ = vala_unary_expression_get_inner (_tmp2105_);
			_tmp2107_ = _tmp2106_;
			_tmp2108_ = vala_expression_get_value_type (_tmp2107_);
			_tmp2109_ = _tmp2108_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp2109_)) {
				ValaCCodeFunction* _tmp2110_;
				ValaCCodeFunction* _tmp2111_;
				ValaUnaryExpression* _tmp2112_;
				ValaExpression* _tmp2113_;
				ValaExpression* _tmp2114_;
				ValaTargetValue* _tmp2115_;
				ValaTargetValue* _tmp2116_;
				ValaCCodeExpression* _tmp2117_;
				ValaCCodeExpression* _tmp2118_;
				_tmp2110_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2111_ = _tmp2110_;
				_tmp2112_ = unary;
				_tmp2113_ = vala_unary_expression_get_inner (_tmp2112_);
				_tmp2114_ = _tmp2113_;
				_tmp2115_ = vala_expression_get_target_value (_tmp2114_);
				_tmp2116_ = _tmp2115_;
				_tmp2117_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2116_, FALSE);
				_tmp2118_ = _tmp2117_;
				vala_ccode_function_add_expression (_tmp2111_, _tmp2118_);
				_vala_ccode_node_unref0 (_tmp2118_);
			}
			_tmp2120_ = ma;
			_tmp2121_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2120_);
			_tmp2122_ = _tmp2121_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2122_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2123_;
				ValaTargetValue* _tmp2124_;
				ValaTargetValue* _tmp2125_;
				ValaDataType* _tmp2126_;
				ValaDataType* _tmp2127_;
				_tmp2123_ = unary;
				_tmp2124_ = vala_expression_get_target_value ((ValaExpression*) _tmp2123_);
				_tmp2125_ = _tmp2124_;
				_tmp2126_ = vala_target_value_get_value_type (_tmp2125_);
				_tmp2127_ = _tmp2126_;
				_tmp2119_ = _tmp2127_ == NULL;
			} else {
				_tmp2119_ = FALSE;
			}
			if (_tmp2119_) {
				ValaUnaryExpression* _tmp2128_;
				ValaTargetValue* _tmp2129_;
				ValaTargetValue* _tmp2130_;
				ValaUnaryExpression* _tmp2131_;
				ValaExpression* _tmp2132_;
				ValaExpression* _tmp2133_;
				ValaDataType* _tmp2134_;
				ValaDataType* _tmp2135_;
				ValaDataType* _tmp2136_;
				ValaDataType* _tmp2137_;
				_tmp2128_ = unary;
				_tmp2129_ = vala_expression_get_target_value ((ValaExpression*) _tmp2128_);
				_tmp2130_ = _tmp2129_;
				_tmp2131_ = unary;
				_tmp2132_ = vala_unary_expression_get_inner (_tmp2131_);
				_tmp2133_ = _tmp2132_;
				_tmp2134_ = vala_expression_get_value_type (_tmp2133_);
				_tmp2135_ = _tmp2134_;
				_tmp2136_ = vala_data_type_copy (_tmp2135_);
				_tmp2137_ = _tmp2136_;
				vala_target_value_set_value_type (_tmp2130_, _tmp2137_);
				_vala_code_node_unref0 (_tmp2137_);
			}
			_tmp2138_ = unary;
			_tmp2139_ = vala_unary_expression_get_inner (_tmp2138_);
			_tmp2140_ = _tmp2139_;
			_tmp2141_ = vala_expression_get_target_value (_tmp2140_);
			_tmp2142_ = _tmp2141_;
			_tmp2143_ = unary;
			_tmp2144_ = vala_expression_get_target_value ((ValaExpression*) _tmp2143_);
			_tmp2145_ = _tmp2144_;
			_tmp2146_ = unary;
			_tmp2147_ = vala_unary_expression_get_inner (_tmp2146_);
			_tmp2148_ = _tmp2147_;
			_tmp2149_ = vala_expression_get_value_type (_tmp2148_);
			_tmp2150_ = _tmp2149_;
			_tmp2151_ = arg;
			_tmp2152_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2145_, _tmp2150_, (ValaCodeNode*) _tmp2151_);
			_tmp2153_ = _tmp2152_;
			_tmp2154_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2155_ = _tmp2154_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2142_, _tmp2153_, _tmp2155_);
			_vala_target_value_unref0 (_tmp2153_);
			_tmp2157_ = param;
			if (_tmp2157_ != NULL) {
				ValaParameter* _tmp2158_;
				_tmp2158_ = param;
				_tmp2156_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2158_);
			} else {
				_tmp2156_ = FALSE;
			}
			if (_tmp2156_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2159_;
				ValaCCodeIdentifier* _tmp2160_;
				ValaCCodeFunctionCall* _tmp2161_;
				ValaCCodeFunctionCall* _tmp2162_;
				ValaCCodeFunctionCall* _tmp2163_;
				ValaUnaryExpression* _tmp2164_;
				ValaExpression* _tmp2165_;
				ValaExpression* _tmp2166_;
				ValaTargetValue* _tmp2167_;
				ValaTargetValue* _tmp2168_;
				ValaCCodeExpression* _tmp2169_;
				ValaCCodeExpression* _tmp2170_;
				ValaCCodeFunction* _tmp2171_;
				ValaCCodeFunction* _tmp2172_;
				ValaUnaryExpression* _tmp2173_;
				ValaExpression* _tmp2174_;
				ValaExpression* _tmp2175_;
				ValaTargetValue* _tmp2176_;
				ValaTargetValue* _tmp2177_;
				ValaCCodeExpression* _tmp2178_;
				ValaCCodeExpression* _tmp2179_;
				ValaCCodeFunctionCall* _tmp2180_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2159_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2160_ = _tmp2159_;
				_tmp2161_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2160_);
				_tmp2162_ = _tmp2161_;
				_vala_ccode_node_unref0 (_tmp2160_);
				len_call = _tmp2162_;
				_tmp2163_ = len_call;
				_tmp2164_ = unary;
				_tmp2165_ = vala_unary_expression_get_inner (_tmp2164_);
				_tmp2166_ = _tmp2165_;
				_tmp2167_ = vala_expression_get_target_value (_tmp2166_);
				_tmp2168_ = _tmp2167_;
				_tmp2169_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2168_);
				_tmp2170_ = _tmp2169_;
				vala_ccode_function_call_add_argument (_tmp2163_, _tmp2170_);
				_vala_ccode_node_unref0 (_tmp2170_);
				_tmp2171_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2172_ = _tmp2171_;
				_tmp2173_ = unary;
				_tmp2174_ = vala_unary_expression_get_inner (_tmp2173_);
				_tmp2175_ = _tmp2174_;
				_tmp2176_ = vala_expression_get_target_value (_tmp2175_);
				_tmp2177_ = _tmp2176_;
				_tmp2178_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2177_, 1);
				_tmp2179_ = _tmp2178_;
				_tmp2180_ = len_call;
				vala_ccode_function_add_assignment (_tmp2172_, _tmp2179_, (ValaCCodeExpression*) _tmp2180_);
				_vala_ccode_node_unref0 (_tmp2179_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2183_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2183_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2184_;
		ValaSymbol* _tmp2185_;
		ValaSymbol* _tmp2186_;
		_tmp2184_ = m;
		_tmp2185_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2184_);
		_tmp2186_ = _tmp2185_;
		_tmp2182_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2186_, VALA_TYPE_CLASS);
	} else {
		_tmp2182_ = FALSE;
	}
	if (_tmp2182_) {
		gboolean _tmp2187_ = FALSE;
		gboolean _tmp2188_ = FALSE;
		ValaClass* _tmp2189_;
		ValaClass* _tmp2190_;
		gboolean _tmp2191_;
		gboolean _tmp2192_;
		_tmp2189_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2190_ = _tmp2189_;
		_tmp2191_ = vala_class_get_is_compact (_tmp2190_);
		_tmp2192_ = _tmp2191_;
		if (_tmp2192_) {
			ValaClass* _tmp2193_;
			ValaClass* _tmp2194_;
			ValaClass* _tmp2195_;
			ValaClass* _tmp2196_;
			_tmp2193_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2194_ = _tmp2193_;
			_tmp2195_ = vala_class_get_base_class (_tmp2194_);
			_tmp2196_ = _tmp2195_;
			_tmp2188_ = _tmp2196_ != NULL;
		} else {
			_tmp2188_ = FALSE;
		}
		if (_tmp2188_) {
			_tmp2187_ = TRUE;
		} else {
			ValaClass* _tmp2197_;
			ValaClass* _tmp2198_;
			ValaClass* _tmp2199_;
			ValaClass* _tmp2200_;
			ValaClass* _tmp2201_;
			_tmp2197_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2198_ = _tmp2197_;
			_tmp2199_ = vala_class_get_base_class (_tmp2198_);
			_tmp2200_ = _tmp2199_;
			_tmp2201_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2187_ = _tmp2200_ == _tmp2201_;
		}
		_tmp2181_ = _tmp2187_;
	} else {
		_tmp2181_ = FALSE;
	}
	if (_tmp2181_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2202_;
		ValaClass* _tmp2203_;
		gchar* _tmp2204_;
		gchar* _tmp2205_;
		gchar* _tmp2206_;
		gchar* _tmp2207_;
		ValaCCodeIdentifier* _tmp2208_;
		ValaCCodeIdentifier* _tmp2209_;
		ValaCCodeFunctionCall* _tmp2210_;
		ValaCCodeFunctionCall* _tmp2211_;
		ValaCCodeFunctionCall* _tmp2212_;
		ValaCCodeExpression* _tmp2213_;
		ValaCCodeExpression* _tmp2214_;
		ValaCCodeFunction* _tmp2215_;
		ValaCCodeFunction* _tmp2216_;
		ValaCCodeFunctionCall* _tmp2217_;
		_tmp2202_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2203_ = _tmp2202_;
		_tmp2204_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2203_, NULL);
		_tmp2205_ = _tmp2204_;
		_tmp2206_ = g_strdup_printf ("%s_instance_init", _tmp2205_);
		_tmp2207_ = _tmp2206_;
		_tmp2208_ = vala_ccode_identifier_new (_tmp2207_);
		_tmp2209_ = _tmp2208_;
		_tmp2210_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2209_);
		_tmp2211_ = _tmp2210_;
		_vala_ccode_node_unref0 (_tmp2209_);
		_g_free0 (_tmp2207_);
		_g_free0 (_tmp2205_);
		cinitcall = _tmp2211_;
		_tmp2212_ = cinitcall;
		_tmp2213_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2214_ = _tmp2213_;
		vala_ccode_function_call_add_argument (_tmp2212_, _tmp2214_);
		_vala_ccode_node_unref0 (_tmp2214_);
		_tmp2215_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2216_ = _tmp2215_;
		_tmp2217_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2216_, (ValaCCodeExpression*) _tmp2217_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}


static gchar*
vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                               ValaEnum* en)
{
	gchar* result = NULL;
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeConstant* _tmp53_;
	ValaCCodeFile* _tmp54_;
	ValaCCodeFunction* _tmp55_;
	ValaCCodeFile* _tmp56_;
	ValaCCodeFunction* _tmp57_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaCCodeFunction* _tmp31_;
			ValaEnumValue* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeIdentifier* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaCCodeFunction* _tmp38_;
			ValaEnumValue* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaCCodeConstant* _tmp46_;
			ValaCCodeConstant* _tmp47_;
			_tmp24_ = _enum_value_index;
			_enum_value_index = _tmp24_ + 1;
			_tmp25_ = _enum_value_index;
			_tmp26_ = _enum_value_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _enum_value_list;
			_tmp28_ = _enum_value_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			enum_value = (ValaEnumValue*) _tmp29_;
			_tmp30_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp31_ = _tmp30_;
			_tmp32_ = enum_value;
			_tmp33_ = vala_get_ccode_name ((ValaCodeNode*) _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_identifier_new (_tmp34_);
			_tmp36_ = _tmp35_;
			vala_ccode_function_add_case (_tmp31_, (ValaCCodeExpression*) _tmp36_);
			_vala_ccode_node_unref0 (_tmp36_);
			_g_free0 (_tmp34_);
			_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = enum_value;
			_tmp40_ = vala_get_ccode_name ((ValaCodeNode*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat ("\"", _tmp41_, NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat (_tmp43_, "\"", NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_ccode_constant_new (_tmp45_);
			_tmp47_ = _tmp46_;
			vala_ccode_function_add_return (_tmp38_, (ValaCCodeExpression*) _tmp47_);
			_vala_ccode_node_unref0 (_tmp47_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp48_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp49_ = _tmp48_;
	vala_ccode_function_close (_tmp49_);
	_tmp50_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_ccode_constant_new ("NULL");
	_tmp53_ = _tmp52_;
	vala_ccode_function_add_return (_tmp51_, (ValaCCodeExpression*) _tmp53_);
	_vala_ccode_node_unref0 (_tmp53_);
	_tmp54_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp55_ = function;
	vala_ccode_file_add_function_declaration (_tmp54_, _tmp55_);
	_tmp56_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp57_ = function;
	vala_ccode_file_add_function (_tmp56_, _tmp57_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}


static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaUnaryExpression* _tmp12_;
			_tmp4_ = _arg_index;
			_arg_index = _tmp4_ + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = _arg_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp10_) : NULL;
			_tmp12_ = unary;
			if (_tmp12_ != NULL) {
				gboolean _tmp13_ = FALSE;
				ValaUnaryExpression* _tmp14_;
				ValaUnaryOperator _tmp15_;
				ValaUnaryOperator _tmp16_;
				_tmp14_ = unary;
				_tmp15_ = vala_unary_expression_get_operator (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp13_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp17_;
					ValaUnaryOperator _tmp18_;
					ValaUnaryOperator _tmp19_;
					_tmp17_ = unary;
					_tmp18_ = vala_unary_expression_get_operator (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp13_ = _tmp19_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp11_ = _tmp13_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}


static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}


static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self)
{
}


GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



