/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_immutable;
	ValaList* base_types;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _static_destructor;
};


static gpointer vala_class_parent_class = NULL;

#define VALA_CLASS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CLASS, ValaClassPrivate))
static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static gboolean* _bool_dup (gboolean* self);
static void vala_class_finalize (ValaCodeNode * obj);


/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}


/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}


/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp23_ = FALSE;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp69_;
	ValaDataType* _tmp70_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaObjectType* _tmp11_;
		ValaObjectType* _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameter* _tmp14_;
		ValaScope* _tmp15_;
		ValaScope* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		ValaParameter* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_parameter_new ("this", (ValaDataType*) _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_method_set_this_parameter (m, _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp15_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_method_get_this_parameter (m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_method_get_this_parameter (m);
		_tmp22_ = _tmp21_;
		vala_scope_add (_tmp16_, _tmp20_, (ValaSymbol*) _tmp22_);
	}
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp25_ = _tmp24_;
	if (!VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaList* _tmp26_;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		_tmp26_ = vala_method_get_postconditions (m);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp23_ = _tmp29_ > 0;
		_vala_iterable_unref0 (_tmp27_);
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		ValaLocalVariable* _tmp47_;
		_tmp30_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaScope* _tmp32_;
			ValaScope* _tmp33_;
			ValaLocalVariable* _tmp34_;
			ValaLocalVariable* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			_tmp32_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_symbol_get_name ((ValaSymbol*) _tmp35_);
			_tmp37_ = _tmp36_;
			vala_scope_remove (_tmp33_, _tmp37_);
		}
		_tmp38_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_data_type_copy (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_local_variable_new (_tmp41_, "result", NULL, _tmp43_);
		_tmp45_ = _tmp44_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp45_);
		_vala_code_node_unref0 (_tmp45_);
		_vala_code_node_unref0 (_tmp41_);
		_tmp46_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp47_ = _tmp46_;
		vala_local_variable_set_is_result (_tmp47_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		ValaCreationMethod* cm = NULL;
		ValaCreationMethod* _tmp50_;
		gboolean _tmp51_ = FALSE;
		ValaCreationMethod* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		_tmp48_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp49_ = _tmp48_;
		if (_tmp49_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		_tmp50_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
		cm = _tmp50_;
		_tmp52_ = cm;
		_tmp53_ = vala_creation_method_get_class_name (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_ != NULL) {
			ValaCreationMethod* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			_tmp55_ = cm;
			_tmp56_ = vala_creation_method_get_class_name (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp59_ = _tmp58_;
			_tmp51_ = g_strcmp0 (_tmp57_, _tmp59_) != 0;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			ValaCreationMethod* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp63_ = _tmp62_;
			_tmp64_ = cm;
			_tmp65_ = vala_creation_method_get_class_name (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp63_, _tmp66_);
			_tmp68_ = _tmp67_;
			vala_report_error (_tmp61_, _tmp68_);
			_g_free0 (_tmp68_);
			_g_free0 (_tmp63_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_vala_code_node_unref0 (cm);
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
	_tmp69_ = vala_method_get_base_interface_type (m);
	_tmp70_ = _tmp69_;
	if (_tmp70_ != NULL) {
		ValaScope* _tmp71_;
		ValaScope* _tmp72_;
		const gchar* _tmp73_;
		const gchar* _tmp74_;
		ValaScope* _tmp75_;
		ValaScope* _tmp76_;
		_tmp71_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp72_ = _tmp71_;
		_tmp73_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp74_ = _tmp73_;
		vala_scope_remove (_tmp72_, _tmp74_);
		_tmp75_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp76_ = _tmp75_;
		vala_scope_add (_tmp76_, NULL, (ValaSymbol*) m);
	}
}


/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaObjectType* _tmp0_;
	ValaObjectType* _tmp1_;
	ValaParameter* _tmp2_;
	ValaParameter* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	ValaParameter* _tmp6_;
	ValaParameter* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	ValaParameter* _tmp10_;
	ValaParameter* _tmp11_;
	ValaField* _tmp12_;
	ValaField* _tmp13_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_parameter_new ("this", (ValaDataType*) _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	vala_property_set_this_parameter (prop, _tmp3_);
	_vala_code_node_unref0 (_tmp3_);
	_vala_code_node_unref0 (_tmp1_);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_property_get_this_parameter (prop);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_symbol_get_name ((ValaSymbol*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_property_get_this_parameter (prop);
	_tmp11_ = _tmp10_;
	vala_scope_add (_tmp5_, _tmp9_, (ValaSymbol*) _tmp11_);
	_tmp12_ = vala_property_get_field (prop);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaField* _tmp14_;
		ValaField* _tmp15_;
		_tmp14_ = vala_property_get_field (prop);
		_tmp15_ = _tmp14_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp15_);
	}
}


static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaConstructor* _tmp2_;
		ValaConstructor* _tmp3_;
		_tmp2_ = vala_class_get_constructor (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaSourceReference* _tmp4_;
			ValaSourceReference* _tmp5_;
			_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
			_tmp5_ = _tmp4_;
			vala_report_error (_tmp5_, "class already contains a constructor");
		}
		vala_class_set_constructor (self, c);
	} else {
		ValaMemberBinding _tmp6_;
		ValaMemberBinding _tmp7_;
		_tmp6_ = vala_constructor_get_binding (c);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_MEMBER_BINDING_CLASS) {
			ValaConstructor* _tmp8_;
			ValaConstructor* _tmp9_;
			_tmp8_ = vala_class_get_class_constructor (self);
			_tmp9_ = _tmp8_;
			if (_tmp9_ != NULL) {
				ValaSourceReference* _tmp10_;
				ValaSourceReference* _tmp11_;
				_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp11_ = _tmp10_;
				vala_report_error (_tmp11_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
		} else {
			ValaConstructor* _tmp12_;
			ValaConstructor* _tmp13_;
			_tmp12_ = vala_class_get_static_constructor (self);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != NULL) {
				ValaSourceReference* _tmp14_;
				ValaSourceReference* _tmp15_;
				_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp15_ = _tmp14_;
				vala_report_error (_tmp15_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
		}
	}
}


static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaDestructor* _tmp2_;
		ValaDestructor* _tmp3_;
		_tmp2_ = vala_class_get_destructor (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaSourceReference* _tmp4_;
			ValaSourceReference* _tmp5_;
			_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
			_tmp5_ = _tmp4_;
			vala_report_error (_tmp5_, "class already contains a destructor");
		}
		vala_class_set_destructor (self, d);
	} else {
		ValaMemberBinding _tmp6_;
		ValaMemberBinding _tmp7_;
		_tmp6_ = vala_destructor_get_binding (d);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_MEMBER_BINDING_CLASS) {
			ValaDestructor* _tmp8_;
			ValaDestructor* _tmp9_;
			_tmp8_ = vala_class_get_class_destructor (self);
			_tmp9_ = _tmp8_;
			if (_tmp9_ != NULL) {
				ValaSourceReference* _tmp10_;
				ValaSourceReference* _tmp11_;
				_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp11_ = _tmp10_;
				vala_report_error (_tmp11_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
		} else {
			ValaDestructor* _tmp12_;
			ValaDestructor* _tmp13_;
			_tmp12_ = vala_class_get_static_destructor (self);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != NULL) {
				ValaSourceReference* _tmp14_;
				ValaSourceReference* _tmp15_;
				_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp15_ = _tmp14_;
				vala_report_error (_tmp15_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
		}
	}
}


static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}


static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp89_;
	ValaConstructor* _tmp90_;
	ValaConstructor* _tmp93_;
	ValaConstructor* _tmp94_;
	ValaConstructor* _tmp97_;
	ValaConstructor* _tmp98_;
	ValaDestructor* _tmp101_;
	ValaDestructor* _tmp102_;
	ValaDestructor* _tmp105_;
	ValaDestructor* _tmp106_;
	ValaDestructor* _tmp109_;
	ValaDestructor* _tmp110_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* type = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_tmp5_ = _type_index;
			_type_index = _tmp5_ + 1;
			_tmp6_ = _type_index;
			_tmp7_ = _type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _type_list;
			_tmp9_ = _type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			type = (ValaDataType*) _tmp10_;
			_tmp11_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp12_;
		gint _p_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _p_index = 0;
		_tmp12_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp12_;
		_tmp13_ = _p_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_p_size = _tmp15_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			ValaTypeParameter* _tmp22_;
			_tmp16_ = _p_index;
			_p_index = _tmp16_ + 1;
			_tmp17_ = _p_index;
			_tmp18_ = _p_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _p_list;
			_tmp20_ = _p_index;
			_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
			p = (ValaTypeParameter*) _tmp21_;
			_tmp22_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp23_;
		gint _en_size = 0;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _en_index = 0;
		_tmp23_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp23_;
		_tmp24_ = _en_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_en_size = _tmp26_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			ValaEnum* en = NULL;
			ValaList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			ValaEnum* _tmp33_;
			_tmp27_ = _en_index;
			_en_index = _tmp27_ + 1;
			_tmp28_ = _en_index;
			_tmp29_ = _en_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _en_list;
			_tmp31_ = _en_index;
			_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
			en = (ValaEnum*) _tmp32_;
			_tmp33_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp33_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp34_;
		gint _f_size = 0;
		ValaList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _f_index = 0;
		_tmp34_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp34_;
		_tmp35_ = _f_list;
		_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_f_size = _tmp37_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			ValaField* f = NULL;
			ValaList* _tmp41_;
			gint _tmp42_;
			gpointer _tmp43_;
			ValaField* _tmp44_;
			_tmp38_ = _f_index;
			_f_index = _tmp38_ + 1;
			_tmp39_ = _f_index;
			_tmp40_ = _f_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _f_list;
			_tmp42_ = _f_index;
			_tmp43_ = vala_list_get (_tmp41_, _tmp42_);
			f = (ValaField*) _tmp43_;
			_tmp44_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp44_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp45_;
		gint _c_size = 0;
		ValaList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint _c_index = 0;
		_tmp45_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp45_;
		_tmp46_ = _c_list;
		_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_c_size = _tmp48_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			ValaConstant* c = NULL;
			ValaList* _tmp52_;
			gint _tmp53_;
			gpointer _tmp54_;
			ValaConstant* _tmp55_;
			_tmp49_ = _c_index;
			_c_index = _tmp49_ + 1;
			_tmp50_ = _c_index;
			_tmp51_ = _c_size;
			if (!(_tmp50_ < _tmp51_)) {
				break;
			}
			_tmp52_ = _c_list;
			_tmp53_ = _c_index;
			_tmp54_ = vala_list_get (_tmp52_, _tmp53_);
			c = (ValaConstant*) _tmp54_;
			_tmp55_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp55_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp56_;
		gint _m_size = 0;
		ValaList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _m_index = 0;
		_tmp56_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp56_;
		_tmp57_ = _m_list;
		_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_m_size = _tmp59_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			ValaMethod* m = NULL;
			ValaList* _tmp63_;
			gint _tmp64_;
			gpointer _tmp65_;
			ValaMethod* _tmp66_;
			_tmp60_ = _m_index;
			_m_index = _tmp60_ + 1;
			_tmp61_ = _m_index;
			_tmp62_ = _m_size;
			if (!(_tmp61_ < _tmp62_)) {
				break;
			}
			_tmp63_ = _m_list;
			_tmp64_ = _m_index;
			_tmp65_ = vala_list_get (_tmp63_, _tmp64_);
			m = (ValaMethod*) _tmp65_;
			_tmp66_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp66_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp67_;
		gint _prop_size = 0;
		ValaList* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gint _prop_index = 0;
		_tmp67_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp67_;
		_tmp68_ = _prop_list;
		_tmp69_ = vala_collection_get_size ((ValaCollection*) _tmp68_);
		_tmp70_ = _tmp69_;
		_prop_size = _tmp70_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			ValaProperty* prop = NULL;
			ValaList* _tmp74_;
			gint _tmp75_;
			gpointer _tmp76_;
			ValaProperty* _tmp77_;
			_tmp71_ = _prop_index;
			_prop_index = _tmp71_ + 1;
			_tmp72_ = _prop_index;
			_tmp73_ = _prop_size;
			if (!(_tmp72_ < _tmp73_)) {
				break;
			}
			_tmp74_ = _prop_list;
			_tmp75_ = _prop_index;
			_tmp76_ = vala_list_get (_tmp74_, _tmp75_);
			prop = (ValaProperty*) _tmp76_;
			_tmp77_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp77_, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp78_;
		gint _sig_size = 0;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _sig_index = 0;
		_tmp78_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp78_;
		_tmp79_ = _sig_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_sig_size = _tmp81_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			ValaSignal* sig = NULL;
			ValaList* _tmp85_;
			gint _tmp86_;
			gpointer _tmp87_;
			ValaSignal* _tmp88_;
			_tmp82_ = _sig_index;
			_sig_index = _tmp82_ + 1;
			_tmp83_ = _sig_index;
			_tmp84_ = _sig_size;
			if (!(_tmp83_ < _tmp84_)) {
				break;
			}
			_tmp85_ = _sig_list;
			_tmp86_ = _sig_index;
			_tmp87_ = vala_list_get (_tmp85_, _tmp86_);
			sig = (ValaSignal*) _tmp87_;
			_tmp88_ = sig;
			vala_code_node_accept ((ValaCodeNode*) _tmp88_, visitor);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp89_ = vala_class_get_constructor (self);
	_tmp90_ = _tmp89_;
	if (_tmp90_ != NULL) {
		ValaConstructor* _tmp91_;
		ValaConstructor* _tmp92_;
		_tmp91_ = vala_class_get_constructor (self);
		_tmp92_ = _tmp91_;
		vala_code_node_accept ((ValaCodeNode*) _tmp92_, visitor);
	}
	_tmp93_ = vala_class_get_class_constructor (self);
	_tmp94_ = _tmp93_;
	if (_tmp94_ != NULL) {
		ValaConstructor* _tmp95_;
		ValaConstructor* _tmp96_;
		_tmp95_ = vala_class_get_class_constructor (self);
		_tmp96_ = _tmp95_;
		vala_code_node_accept ((ValaCodeNode*) _tmp96_, visitor);
	}
	_tmp97_ = vala_class_get_static_constructor (self);
	_tmp98_ = _tmp97_;
	if (_tmp98_ != NULL) {
		ValaConstructor* _tmp99_;
		ValaConstructor* _tmp100_;
		_tmp99_ = vala_class_get_static_constructor (self);
		_tmp100_ = _tmp99_;
		vala_code_node_accept ((ValaCodeNode*) _tmp100_, visitor);
	}
	_tmp101_ = vala_class_get_destructor (self);
	_tmp102_ = _tmp101_;
	if (_tmp102_ != NULL) {
		ValaDestructor* _tmp103_;
		ValaDestructor* _tmp104_;
		_tmp103_ = vala_class_get_destructor (self);
		_tmp104_ = _tmp103_;
		vala_code_node_accept ((ValaCodeNode*) _tmp104_, visitor);
	}
	_tmp105_ = vala_class_get_static_destructor (self);
	_tmp106_ = _tmp105_;
	if (_tmp106_ != NULL) {
		ValaDestructor* _tmp107_;
		ValaDestructor* _tmp108_;
		_tmp107_ = vala_class_get_static_destructor (self);
		_tmp108_ = _tmp107_;
		vala_code_node_accept ((ValaCodeNode*) _tmp108_, visitor);
	}
	_tmp109_ = vala_class_get_class_destructor (self);
	_tmp110_ = _tmp109_;
	if (_tmp110_ != NULL) {
		ValaDestructor* _tmp111_;
		ValaDestructor* _tmp112_;
		_tmp111_ = vala_class_get_class_destructor (self);
		_tmp112_ = _tmp111_;
		vala_code_node_accept ((ValaCodeNode*) _tmp112_, visitor);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp113_;
		gint _cl_size = 0;
		ValaList* _tmp114_;
		gint _tmp115_;
		gint _tmp116_;
		gint _cl_index = 0;
		_tmp113_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp113_;
		_tmp114_ = _cl_list;
		_tmp115_ = vala_collection_get_size ((ValaCollection*) _tmp114_);
		_tmp116_ = _tmp115_;
		_cl_size = _tmp116_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp117_;
			gint _tmp118_;
			gint _tmp119_;
			ValaClass* cl = NULL;
			ValaList* _tmp120_;
			gint _tmp121_;
			gpointer _tmp122_;
			ValaClass* _tmp123_;
			_tmp117_ = _cl_index;
			_cl_index = _tmp117_ + 1;
			_tmp118_ = _cl_index;
			_tmp119_ = _cl_size;
			if (!(_tmp118_ < _tmp119_)) {
				break;
			}
			_tmp120_ = _cl_list;
			_tmp121_ = _cl_index;
			_tmp122_ = vala_list_get (_tmp120_, _tmp121_);
			cl = (ValaClass*) _tmp122_;
			_tmp123_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp123_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp124_;
		gint _st_size = 0;
		ValaList* _tmp125_;
		gint _tmp126_;
		gint _tmp127_;
		gint _st_index = 0;
		_tmp124_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp124_;
		_tmp125_ = _st_list;
		_tmp126_ = vala_collection_get_size ((ValaCollection*) _tmp125_);
		_tmp127_ = _tmp126_;
		_st_size = _tmp127_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp128_;
			gint _tmp129_;
			gint _tmp130_;
			ValaStruct* st = NULL;
			ValaList* _tmp131_;
			gint _tmp132_;
			gpointer _tmp133_;
			ValaStruct* _tmp134_;
			_tmp128_ = _st_index;
			_st_index = _tmp128_ + 1;
			_tmp129_ = _st_index;
			_tmp130_ = _st_size;
			if (!(_tmp129_ < _tmp130_)) {
				break;
			}
			_tmp131_ = _st_list;
			_tmp132_ = _st_index;
			_tmp133_ = vala_list_get (_tmp131_, _tmp132_);
			st = (ValaStruct*) _tmp133_;
			_tmp134_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp134_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp135_;
		gint _d_size = 0;
		ValaList* _tmp136_;
		gint _tmp137_;
		gint _tmp138_;
		gint _d_index = 0;
		_tmp135_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp135_;
		_tmp136_ = _d_list;
		_tmp137_ = vala_collection_get_size ((ValaCollection*) _tmp136_);
		_tmp138_ = _tmp137_;
		_d_size = _tmp138_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp139_;
			gint _tmp140_;
			gint _tmp141_;
			ValaDelegate* d = NULL;
			ValaList* _tmp142_;
			gint _tmp143_;
			gpointer _tmp144_;
			ValaDelegate* _tmp145_;
			_tmp139_ = _d_index;
			_d_index = _tmp139_ + 1;
			_tmp140_ = _d_index;
			_tmp141_ = _d_size;
			if (!(_tmp140_ < _tmp141_)) {
				break;
			}
			_tmp142_ = _d_list;
			_tmp143_ = _d_index;
			_tmp144_ = vala_list_get (_tmp142_, _tmp143_);
			d = (ValaDelegate*) _tmp144_;
			_tmp145_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp145_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}


static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}


gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			ValaDataType* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			ValaTypeSymbol* _tmp15_;
			_tmp5_ = _base_type_index;
			_base_type_index = _tmp5_ + 1;
			_tmp6_ = _base_type_index;
			_tmp7_ = _base_type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _base_type_list;
			_tmp9_ = _base_type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			base_type = (ValaDataType*) _tmp10_;
			_tmp13_ = base_type;
			_tmp14_ = vala_data_type_get_data_type (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ != NULL) {
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				_tmp16_ = base_type;
				_tmp17_ = vala_data_type_get_data_type (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp12_ = _tmp18_ != G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				ValaDataType* _tmp19_;
				ValaTypeSymbol* _tmp20_;
				ValaTypeSymbol* _tmp21_;
				_tmp19_ = base_type;
				_tmp20_ = vala_data_type_get_data_type (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp11_ = vala_typesymbol_is_subtype_of (_tmp21_, t);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->base_types;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->base_types;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = _tmp9_ == old_type;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->base_types;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}


static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		gint _prereq_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_prereq_list = _tmp0_;
		_tmp1_ = _prereq_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prereq_size = _tmp3_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			ValaTypeSymbol* _tmp15_;
			ValaTypeSymbol* _tmp16_;
			_tmp4_ = _prereq_index;
			_prereq_index = _tmp4_ + 1;
			_tmp5_ = _prereq_index;
			_tmp6_ = _prereq_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _prereq_list;
			_tmp8_ = _prereq_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			prereq = (ValaDataType*) _tmp9_;
			_tmp10_ = prereq;
			_tmp11_ = vala_data_type_get_data_type (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _vala_code_node_ref0 (_tmp12_);
			type = _tmp13_;
			_tmp14_ = type;
			if (_tmp14_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp15_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp15_);
			_tmp16_ = type;
			if (VALA_IS_INTERFACE (_tmp16_)) {
				ValaTypeSymbol* _tmp17_;
				_tmp17_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
}


gboolean
vala_class_is_a (ValaClass* self,
                 ValaObjectTypeSymbol* t)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_tmp4_ = _base_type_index;
			_base_type_index = _tmp4_ + 1;
			_tmp5_ = _base_type_index;
			_tmp6_ = _base_type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _base_type_list;
			_tmp8_ = _base_type_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			base_type = (ValaDataType*) _tmp9_;
			_tmp10_ = base_type;
			_tmp11_ = vala_data_type_get_data_type (_tmp10_);
			_tmp12_ = _tmp11_;
			if (VALA_IS_CLASS (_tmp12_)) {
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				_tmp13_ = base_type;
				_tmp14_ = vala_data_type_get_data_type (_tmp13_);
				_tmp15_ = _tmp14_;
				if (vala_class_is_a (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			} else {
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				_tmp16_ = base_type;
				_tmp17_ = vala_data_type_get_data_type (_tmp16_);
				_tmp18_ = _tmp17_;
				if (_tmp18_ == G_TYPE_CHECK_INSTANCE_CAST (t, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


gboolean
vala_class_implements (ValaClass* self,
                       ValaInterface* i)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_tmp4_ = _base_type_index;
			_base_type_index = _tmp4_ + 1;
			_tmp5_ = _base_type_index;
			_tmp6_ = _base_type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _base_type_list;
			_tmp8_ = _base_type_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			base_type = (ValaDataType*) _tmp9_;
			_tmp10_ = base_type;
			_tmp11_ = vala_data_type_get_data_type (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ == G_TYPE_CHECK_INSTANCE_CAST (i, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaCreationMethod* _tmp5_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp26_;
	ValaSemanticAnalyzer* _tmp27_;
	ValaSourceFile* _tmp28_;
	ValaSourceFile* _tmp29_;
	ValaSourceFile* _tmp30_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp31_;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSymbol* _tmp33_;
	ValaSymbol* _tmp34_;
	ValaSymbol* _tmp35_;
	ValaSourceReference* _tmp36_;
	ValaSourceReference* _tmp37_;
	ValaSemanticAnalyzer* _tmp44_;
	ValaSemanticAnalyzer* _tmp45_;
	ValaConstructor* _tmp223_;
	ValaConstructor* _tmp224_;
	ValaConstructor* _tmp227_;
	ValaConstructor* _tmp228_;
	ValaConstructor* _tmp231_;
	ValaConstructor* _tmp232_;
	ValaDestructor* _tmp235_;
	ValaDestructor* _tmp236_;
	ValaDestructor* _tmp239_;
	ValaDestructor* _tmp240_;
	ValaDestructor* _tmp243_;
	ValaDestructor* _tmp244_;
	gboolean _tmp280_;
	gboolean _tmp281_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp328_;
	ValaArrayList* _tmp329_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp347_;
	ValaArrayList* _tmp348_;
	ValaList* _tmp365_;
	gint _tmp366_;
	gint _tmp367_;
	ValaSourceFileType _tmp395_;
	ValaSourceFileType _tmp396_;
	ValaSemanticAnalyzer* _tmp622_;
	ValaSemanticAnalyzer* _tmp623_;
	ValaSourceFile* _tmp624_;
	ValaSemanticAnalyzer* _tmp625_;
	ValaSemanticAnalyzer* _tmp626_;
	ValaSymbol* _tmp627_;
	gboolean _tmp628_;
	gboolean _tmp629_;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_default_construction_method;
	if (_tmp5_ == NULL) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceFile* _tmp8_;
		ValaSourceFile* _tmp9_;
		ValaSourceFileType _tmp10_;
		ValaSourceFileType _tmp11_;
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_source_reference_get_file (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_source_file_get_file_type (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp4_ = _tmp11_ == VALA_SOURCE_FILE_TYPE_SOURCE;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaCreationMethod* m = NULL;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaCreationMethod* _tmp16_;
		ValaSymbolAccessibility _tmp17_ = 0;
		gboolean _tmp18_;
		ValaCreationMethod* _tmp19_;
		ValaCreationMethod* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaBlock* _tmp23_;
		ValaBlock* _tmp24_;
		ValaCreationMethod* _tmp25_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_creation_method_new (_tmp13_, NULL, _tmp15_, NULL);
		m = _tmp16_;
		_tmp18_ = self->priv->_is_abstract;
		if (_tmp18_) {
			_tmp17_ = VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
		} else {
			_tmp17_ = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
		}
		_tmp19_ = m;
		vala_symbol_set_access ((ValaSymbol*) _tmp19_, _tmp17_);
		_tmp20_ = m;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_block_new (_tmp22_);
		_tmp24_ = _tmp23_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp20_, _tmp24_);
		_vala_code_node_unref0 (_tmp24_);
		_tmp25_ = m;
		vala_symbol_add_method ((ValaSymbol*) self, (ValaMethod*) _tmp25_);
		_vala_code_node_unref0 (m);
	}
	_tmp26_ = vala_code_context_get_analyzer (context);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_semantic_analyzer_get_current_source_file (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _vala_source_file_ref0 (_tmp29_);
	old_source_file = _tmp30_;
	_tmp31_ = vala_code_context_get_analyzer (context);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_semantic_analyzer_get_current_symbol (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = _vala_code_node_ref0 (_tmp34_);
	old_symbol = _tmp35_;
	_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		ValaSemanticAnalyzer* _tmp38_;
		ValaSemanticAnalyzer* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaSourceFile* _tmp42_;
		ValaSourceFile* _tmp43_;
		_tmp38_ = vala_code_context_get_analyzer (context);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_source_reference_get_file (_tmp41_);
		_tmp43_ = _tmp42_;
		vala_semantic_analyzer_set_current_source_file (_tmp39_, _tmp43_);
	}
	_tmp44_ = vala_code_context_get_analyzer (context);
	_tmp45_ = _tmp44_;
	vala_semantic_analyzer_set_current_symbol (_tmp45_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp46_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _base_type_reference_index = 0;
		_tmp46_ = vala_class_get_base_types (self);
		_base_type_reference_list = _tmp46_;
		_tmp47_ = _base_type_reference_list;
		_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_base_type_reference_size = _tmp49_;
		_base_type_reference_index = -1;
		while (TRUE) {
			gint _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp53_;
			gint _tmp54_;
			gpointer _tmp55_;
			ValaDataType* _tmp56_;
			ValaDataType* _tmp57_;
			ValaSemanticAnalyzer* _tmp67_;
			ValaSemanticAnalyzer* _tmp68_;
			ValaDataType* _tmp69_;
			gint n_type_args = 0;
			ValaDataType* _tmp79_;
			ValaList* _tmp80_;
			ValaList* _tmp81_;
			gint _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			gint n_type_params = 0;
			ValaDataType* _tmp85_;
			ValaTypeSymbol* _tmp86_;
			ValaTypeSymbol* _tmp87_;
			ValaList* _tmp88_;
			ValaList* _tmp89_;
			gint _tmp90_;
			gint _tmp91_;
			gint _tmp92_;
			gint _tmp93_;
			gint _tmp94_;
			_tmp50_ = _base_type_reference_index;
			_base_type_reference_index = _tmp50_ + 1;
			_tmp51_ = _base_type_reference_index;
			_tmp52_ = _base_type_reference_size;
			if (!(_tmp51_ < _tmp52_)) {
				break;
			}
			_tmp53_ = _base_type_reference_list;
			_tmp54_ = _base_type_reference_index;
			_tmp55_ = vala_list_get (_tmp53_, _tmp54_);
			base_type_reference = (ValaDataType*) _tmp55_;
			_tmp56_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp56_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp57_ = base_type_reference;
			if (!VALA_IS_OBJECT_TYPE (_tmp57_)) {
				ValaSourceReference* _tmp58_;
				ValaSourceReference* _tmp59_;
				ValaDataType* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp59_ = _tmp58_;
				_tmp60_ = base_type_reference;
				_tmp61_ = vala_code_node_to_string ((ValaCodeNode*) _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp64_ = _tmp63_;
				_tmp65_ = g_strdup_printf ("base type `%s` of class `%s` is not an object type", _tmp62_, _tmp64_);
				_tmp66_ = _tmp65_;
				vala_report_error (_tmp59_, _tmp66_);
				_g_free0 (_tmp66_);
				_g_free0 (_tmp64_);
				_g_free0 (_tmp62_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp67_ = vala_code_context_get_analyzer (context);
			_tmp68_ = _tmp67_;
			_tmp69_ = base_type_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp68_, (ValaSymbol*) self, _tmp69_)) {
				ValaSourceReference* _tmp70_;
				ValaSourceReference* _tmp71_;
				ValaDataType* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp70_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = base_type_reference;
				_tmp73_ = vala_code_node_to_string ((ValaCodeNode*) _tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp76_ = _tmp75_;
				_tmp77_ = g_strdup_printf ("base type `%s` is less accessible than class `%s`", _tmp74_, _tmp76_);
				_tmp78_ = _tmp77_;
				vala_report_error (_tmp71_, _tmp78_);
				_g_free0 (_tmp78_);
				_g_free0 (_tmp76_);
				_g_free0 (_tmp74_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp79_ = base_type_reference;
			_tmp80_ = vala_data_type_get_type_arguments (_tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = vala_collection_get_size ((ValaCollection*) _tmp81_);
			_tmp83_ = _tmp82_;
			_tmp84_ = _tmp83_;
			_vala_iterable_unref0 (_tmp81_);
			n_type_args = _tmp84_;
			_tmp85_ = base_type_reference;
			_tmp86_ = vala_data_type_get_data_type (_tmp85_);
			_tmp87_ = _tmp86_;
			_tmp88_ = vala_object_type_symbol_get_type_parameters (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp89_ = _tmp88_;
			_tmp90_ = vala_collection_get_size ((ValaCollection*) _tmp89_);
			_tmp91_ = _tmp90_;
			_tmp92_ = _tmp91_;
			_vala_iterable_unref0 (_tmp89_);
			n_type_params = _tmp92_;
			_tmp93_ = n_type_args;
			_tmp94_ = n_type_params;
			if (_tmp93_ < _tmp94_) {
				ValaDataType* _tmp95_;
				ValaSourceReference* _tmp96_;
				ValaSourceReference* _tmp97_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp95_ = base_type_reference;
				_tmp96_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp95_);
				_tmp97_ = _tmp96_;
				vala_report_error (_tmp97_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				gint _tmp98_;
				gint _tmp99_;
				_tmp98_ = n_type_args;
				_tmp99_ = n_type_params;
				if (_tmp98_ > _tmp99_) {
					ValaDataType* _tmp100_;
					ValaSourceReference* _tmp101_;
					ValaSourceReference* _tmp102_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp100_ = base_type_reference;
					_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp100_);
					_tmp102_ = _tmp101_;
					vala_report_error (_tmp102_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (base_type_reference);
					_vala_iterable_unref0 (_base_type_reference_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_vala_iterable_unref0 (_base_type_reference_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp103_;
		ValaList* _tmp104_;
		gint _type_size = 0;
		ValaList* _tmp105_;
		gint _tmp106_;
		gint _tmp107_;
		gint _type_index = 0;
		_tmp103_ = self->priv->base_types;
		_tmp104_ = _vala_iterable_ref0 (_tmp103_);
		_type_list = _tmp104_;
		_tmp105_ = _type_list;
		_tmp106_ = vala_collection_get_size ((ValaCollection*) _tmp105_);
		_tmp107_ = _tmp106_;
		_type_size = _tmp107_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp108_;
			gint _tmp109_;
			gint _tmp110_;
			ValaDataType* type = NULL;
			ValaList* _tmp111_;
			gint _tmp112_;
			gpointer _tmp113_;
			ValaDataType* _tmp114_;
			_tmp108_ = _type_index;
			_type_index = _tmp108_ + 1;
			_tmp109_ = _type_index;
			_tmp110_ = _type_size;
			if (!(_tmp109_ < _tmp110_)) {
				break;
			}
			_tmp111_ = _type_list;
			_tmp112_ = _type_index;
			_tmp113_ = vala_list_get (_tmp111_, _tmp112_);
			type = (ValaDataType*) _tmp113_;
			_tmp114_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp114_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp115_;
		gint _p_size = 0;
		ValaList* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		gint _p_index = 0;
		_tmp115_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp115_;
		_tmp116_ = _p_list;
		_tmp117_ = vala_collection_get_size ((ValaCollection*) _tmp116_);
		_tmp118_ = _tmp117_;
		_p_size = _tmp118_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp119_;
			gint _tmp120_;
			gint _tmp121_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp122_;
			gint _tmp123_;
			gpointer _tmp124_;
			ValaTypeParameter* _tmp125_;
			_tmp119_ = _p_index;
			_p_index = _tmp119_ + 1;
			_tmp120_ = _p_index;
			_tmp121_ = _p_size;
			if (!(_tmp120_ < _tmp121_)) {
				break;
			}
			_tmp122_ = _p_list;
			_tmp123_ = _p_index;
			_tmp124_ = vala_list_get (_tmp122_, _tmp123_);
			p = (ValaTypeParameter*) _tmp124_;
			_tmp125_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp125_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp126_;
		gint _en_size = 0;
		ValaList* _tmp127_;
		gint _tmp128_;
		gint _tmp129_;
		gint _en_index = 0;
		_tmp126_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp126_;
		_tmp127_ = _en_list;
		_tmp128_ = vala_collection_get_size ((ValaCollection*) _tmp127_);
		_tmp129_ = _tmp128_;
		_en_size = _tmp129_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp130_;
			gint _tmp131_;
			gint _tmp132_;
			ValaEnum* en = NULL;
			ValaList* _tmp133_;
			gint _tmp134_;
			gpointer _tmp135_;
			ValaEnum* _tmp136_;
			_tmp130_ = _en_index;
			_en_index = _tmp130_ + 1;
			_tmp131_ = _en_index;
			_tmp132_ = _en_size;
			if (!(_tmp131_ < _tmp132_)) {
				break;
			}
			_tmp133_ = _en_list;
			_tmp134_ = _en_index;
			_tmp135_ = vala_list_get (_tmp133_, _tmp134_);
			en = (ValaEnum*) _tmp135_;
			_tmp136_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp136_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp137_;
		gint _f_size = 0;
		ValaList* _tmp138_;
		gint _tmp139_;
		gint _tmp140_;
		gint _f_index = 0;
		_tmp137_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp137_;
		_tmp138_ = _f_list;
		_tmp139_ = vala_collection_get_size ((ValaCollection*) _tmp138_);
		_tmp140_ = _tmp139_;
		_f_size = _tmp140_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp141_;
			gint _tmp142_;
			gint _tmp143_;
			ValaField* f = NULL;
			ValaList* _tmp144_;
			gint _tmp145_;
			gpointer _tmp146_;
			gboolean _tmp147_ = FALSE;
			gboolean _tmp148_;
			gboolean _tmp149_;
			ValaField* _tmp167_;
			_tmp141_ = _f_index;
			_f_index = _tmp141_ + 1;
			_tmp142_ = _f_index;
			_tmp143_ = _f_size;
			if (!(_tmp142_ < _tmp143_)) {
				break;
			}
			_tmp144_ = _f_list;
			_tmp145_ = _f_index;
			_tmp146_ = vala_list_get (_tmp144_, _tmp145_);
			f = (ValaField*) _tmp146_;
			_tmp148_ = vala_class_get_is_compact (self);
			_tmp149_ = _tmp148_;
			if (_tmp149_) {
				ValaField* _tmp150_;
				ValaMemberBinding _tmp151_;
				ValaMemberBinding _tmp152_;
				_tmp150_ = f;
				_tmp151_ = vala_field_get_binding (_tmp150_);
				_tmp152_ = _tmp151_;
				_tmp147_ = _tmp152_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp147_ = FALSE;
			}
			if (_tmp147_) {
				gboolean _tmp153_ = FALSE;
				gboolean _tmp154_;
				gboolean _tmp155_;
				ValaField* _tmp161_;
				ValaMemberBinding _tmp162_;
				ValaMemberBinding _tmp163_;
				_tmp154_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp155_ = _tmp154_;
				if (!_tmp155_) {
					ValaField* _tmp156_;
					ValaSymbolAccessibility _tmp157_;
					ValaSymbolAccessibility _tmp158_;
					_tmp156_ = f;
					_tmp157_ = vala_symbol_get_access ((ValaSymbol*) _tmp156_);
					_tmp158_ = _tmp157_;
					_tmp153_ = _tmp158_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp153_ = FALSE;
				}
				if (_tmp153_) {
					ValaSourceReference* _tmp159_;
					ValaSourceReference* _tmp160_;
					_tmp159_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp160_ = _tmp159_;
					vala_report_error (_tmp160_, "private fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp161_ = f;
				_tmp162_ = vala_field_get_binding (_tmp161_);
				_tmp163_ = _tmp162_;
				if (_tmp163_ == VALA_MEMBER_BINDING_CLASS) {
					ValaField* _tmp164_;
					ValaSourceReference* _tmp165_;
					ValaSourceReference* _tmp166_;
					_tmp164_ = f;
					_tmp165_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp164_);
					_tmp166_ = _tmp165_;
					vala_report_error (_tmp166_, "class fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_tmp167_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp167_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp168_;
		gint _c_size = 0;
		ValaList* _tmp169_;
		gint _tmp170_;
		gint _tmp171_;
		gint _c_index = 0;
		_tmp168_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp168_;
		_tmp169_ = _c_list;
		_tmp170_ = vala_collection_get_size ((ValaCollection*) _tmp169_);
		_tmp171_ = _tmp170_;
		_c_size = _tmp171_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp172_;
			gint _tmp173_;
			gint _tmp174_;
			ValaConstant* c = NULL;
			ValaList* _tmp175_;
			gint _tmp176_;
			gpointer _tmp177_;
			ValaConstant* _tmp178_;
			_tmp172_ = _c_index;
			_c_index = _tmp172_ + 1;
			_tmp173_ = _c_index;
			_tmp174_ = _c_size;
			if (!(_tmp173_ < _tmp174_)) {
				break;
			}
			_tmp175_ = _c_list;
			_tmp176_ = _c_index;
			_tmp177_ = vala_list_get (_tmp175_, _tmp176_);
			c = (ValaConstant*) _tmp177_;
			_tmp178_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp178_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp179_;
		gint _m_size = 0;
		ValaList* _tmp180_;
		gint _tmp181_;
		gint _tmp182_;
		gint _m_index = 0;
		_tmp179_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp179_;
		_tmp180_ = _m_list;
		_tmp181_ = vala_collection_get_size ((ValaCollection*) _tmp180_);
		_tmp182_ = _tmp181_;
		_m_size = _tmp182_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp183_;
			gint _tmp184_;
			gint _tmp185_;
			ValaMethod* m = NULL;
			ValaList* _tmp186_;
			gint _tmp187_;
			gpointer _tmp188_;
			ValaMethod* _tmp189_;
			_tmp183_ = _m_index;
			_m_index = _tmp183_ + 1;
			_tmp184_ = _m_index;
			_tmp185_ = _m_size;
			if (!(_tmp184_ < _tmp185_)) {
				break;
			}
			_tmp186_ = _m_list;
			_tmp187_ = _m_index;
			_tmp188_ = vala_list_get (_tmp186_, _tmp187_);
			m = (ValaMethod*) _tmp188_;
			_tmp189_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp189_, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp190_;
		gint _prop_size = 0;
		ValaList* _tmp191_;
		gint _tmp192_;
		gint _tmp193_;
		gint _prop_index = 0;
		_tmp190_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp190_;
		_tmp191_ = _prop_list;
		_tmp192_ = vala_collection_get_size ((ValaCollection*) _tmp191_);
		_tmp193_ = _tmp192_;
		_prop_size = _tmp193_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp194_;
			gint _tmp195_;
			gint _tmp196_;
			ValaProperty* prop = NULL;
			ValaList* _tmp197_;
			gint _tmp198_;
			gpointer _tmp199_;
			gboolean _tmp200_ = FALSE;
			ValaProperty* _tmp201_;
			ValaAttribute* _tmp202_;
			ValaAttribute* _tmp203_;
			gboolean _tmp204_;
			ValaProperty* _tmp211_;
			_tmp194_ = _prop_index;
			_prop_index = _tmp194_ + 1;
			_tmp195_ = _prop_index;
			_tmp196_ = _prop_size;
			if (!(_tmp195_ < _tmp196_)) {
				break;
			}
			_tmp197_ = _prop_list;
			_tmp198_ = _prop_index;
			_tmp199_ = vala_list_get (_tmp197_, _tmp198_);
			prop = (ValaProperty*) _tmp199_;
			_tmp201_ = prop;
			_tmp202_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp201_, "NoAccessorMethod");
			_tmp203_ = _tmp202_;
			_tmp204_ = _tmp203_ != NULL;
			_vala_code_node_unref0 (_tmp203_);
			if (_tmp204_) {
				ValaSemanticAnalyzer* _tmp205_;
				ValaSemanticAnalyzer* _tmp206_;
				ValaClass* _tmp207_;
				_tmp205_ = vala_code_context_get_analyzer (context);
				_tmp206_ = _tmp205_;
				_tmp207_ = _tmp206_->object_type;
				_tmp200_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp207_);
			} else {
				_tmp200_ = FALSE;
			}
			if (_tmp200_) {
				ValaProperty* _tmp208_;
				ValaSourceReference* _tmp209_;
				ValaSourceReference* _tmp210_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp208_ = prop;
				_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp208_);
				_tmp210_ = _tmp209_;
				vala_report_error (_tmp210_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp211_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp211_, context);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp212_;
		gint _sig_size = 0;
		ValaList* _tmp213_;
		gint _tmp214_;
		gint _tmp215_;
		gint _sig_index = 0;
		_tmp212_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp212_;
		_tmp213_ = _sig_list;
		_tmp214_ = vala_collection_get_size ((ValaCollection*) _tmp213_);
		_tmp215_ = _tmp214_;
		_sig_size = _tmp215_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp216_;
			gint _tmp217_;
			gint _tmp218_;
			ValaSignal* sig = NULL;
			ValaList* _tmp219_;
			gint _tmp220_;
			gpointer _tmp221_;
			ValaSignal* _tmp222_;
			_tmp216_ = _sig_index;
			_sig_index = _tmp216_ + 1;
			_tmp217_ = _sig_index;
			_tmp218_ = _sig_size;
			if (!(_tmp217_ < _tmp218_)) {
				break;
			}
			_tmp219_ = _sig_list;
			_tmp220_ = _sig_index;
			_tmp221_ = vala_list_get (_tmp219_, _tmp220_);
			sig = (ValaSignal*) _tmp221_;
			_tmp222_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp222_, context);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp223_ = vala_class_get_constructor (self);
	_tmp224_ = _tmp223_;
	if (_tmp224_ != NULL) {
		ValaConstructor* _tmp225_;
		ValaConstructor* _tmp226_;
		_tmp225_ = vala_class_get_constructor (self);
		_tmp226_ = _tmp225_;
		vala_code_node_check ((ValaCodeNode*) _tmp226_, context);
	}
	_tmp227_ = vala_class_get_class_constructor (self);
	_tmp228_ = _tmp227_;
	if (_tmp228_ != NULL) {
		ValaConstructor* _tmp229_;
		ValaConstructor* _tmp230_;
		_tmp229_ = vala_class_get_class_constructor (self);
		_tmp230_ = _tmp229_;
		vala_code_node_check ((ValaCodeNode*) _tmp230_, context);
	}
	_tmp231_ = vala_class_get_static_constructor (self);
	_tmp232_ = _tmp231_;
	if (_tmp232_ != NULL) {
		ValaConstructor* _tmp233_;
		ValaConstructor* _tmp234_;
		_tmp233_ = vala_class_get_static_constructor (self);
		_tmp234_ = _tmp233_;
		vala_code_node_check ((ValaCodeNode*) _tmp234_, context);
	}
	_tmp235_ = vala_class_get_destructor (self);
	_tmp236_ = _tmp235_;
	if (_tmp236_ != NULL) {
		ValaDestructor* _tmp237_;
		ValaDestructor* _tmp238_;
		_tmp237_ = vala_class_get_destructor (self);
		_tmp238_ = _tmp237_;
		vala_code_node_check ((ValaCodeNode*) _tmp238_, context);
	}
	_tmp239_ = vala_class_get_static_destructor (self);
	_tmp240_ = _tmp239_;
	if (_tmp240_ != NULL) {
		ValaDestructor* _tmp241_;
		ValaDestructor* _tmp242_;
		_tmp241_ = vala_class_get_static_destructor (self);
		_tmp242_ = _tmp241_;
		vala_code_node_check ((ValaCodeNode*) _tmp242_, context);
	}
	_tmp243_ = vala_class_get_class_destructor (self);
	_tmp244_ = _tmp243_;
	if (_tmp244_ != NULL) {
		ValaDestructor* _tmp245_;
		ValaDestructor* _tmp246_;
		_tmp245_ = vala_class_get_class_destructor (self);
		_tmp246_ = _tmp245_;
		vala_code_node_check ((ValaCodeNode*) _tmp246_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp247_;
		gint _cl_size = 0;
		ValaList* _tmp248_;
		gint _tmp249_;
		gint _tmp250_;
		gint _cl_index = 0;
		_tmp247_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp247_;
		_tmp248_ = _cl_list;
		_tmp249_ = vala_collection_get_size ((ValaCollection*) _tmp248_);
		_tmp250_ = _tmp249_;
		_cl_size = _tmp250_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp251_;
			gint _tmp252_;
			gint _tmp253_;
			ValaClass* cl = NULL;
			ValaList* _tmp254_;
			gint _tmp255_;
			gpointer _tmp256_;
			ValaClass* _tmp257_;
			_tmp251_ = _cl_index;
			_cl_index = _tmp251_ + 1;
			_tmp252_ = _cl_index;
			_tmp253_ = _cl_size;
			if (!(_tmp252_ < _tmp253_)) {
				break;
			}
			_tmp254_ = _cl_list;
			_tmp255_ = _cl_index;
			_tmp256_ = vala_list_get (_tmp254_, _tmp255_);
			cl = (ValaClass*) _tmp256_;
			_tmp257_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp257_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp258_;
		gint _st_size = 0;
		ValaList* _tmp259_;
		gint _tmp260_;
		gint _tmp261_;
		gint _st_index = 0;
		_tmp258_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp258_;
		_tmp259_ = _st_list;
		_tmp260_ = vala_collection_get_size ((ValaCollection*) _tmp259_);
		_tmp261_ = _tmp260_;
		_st_size = _tmp261_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp262_;
			gint _tmp263_;
			gint _tmp264_;
			ValaStruct* st = NULL;
			ValaList* _tmp265_;
			gint _tmp266_;
			gpointer _tmp267_;
			ValaStruct* _tmp268_;
			_tmp262_ = _st_index;
			_st_index = _tmp262_ + 1;
			_tmp263_ = _st_index;
			_tmp264_ = _st_size;
			if (!(_tmp263_ < _tmp264_)) {
				break;
			}
			_tmp265_ = _st_list;
			_tmp266_ = _st_index;
			_tmp267_ = vala_list_get (_tmp265_, _tmp266_);
			st = (ValaStruct*) _tmp267_;
			_tmp268_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp268_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp269_;
		gint _d_size = 0;
		ValaList* _tmp270_;
		gint _tmp271_;
		gint _tmp272_;
		gint _d_index = 0;
		_tmp269_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp269_;
		_tmp270_ = _d_list;
		_tmp271_ = vala_collection_get_size ((ValaCollection*) _tmp270_);
		_tmp272_ = _tmp271_;
		_d_size = _tmp272_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp273_;
			gint _tmp274_;
			gint _tmp275_;
			ValaDelegate* d = NULL;
			ValaList* _tmp276_;
			gint _tmp277_;
			gpointer _tmp278_;
			ValaDelegate* _tmp279_;
			_tmp273_ = _d_index;
			_d_index = _tmp273_ + 1;
			_tmp274_ = _d_index;
			_tmp275_ = _d_size;
			if (!(_tmp274_ < _tmp275_)) {
				break;
			}
			_tmp276_ = _d_list;
			_tmp277_ = _d_index;
			_tmp278_ = vala_list_get (_tmp276_, _tmp277_);
			d = (ValaDelegate*) _tmp278_;
			_tmp279_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp279_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp280_ = vala_class_get_is_compact (self);
	_tmp281_ = _tmp280_;
	if (_tmp281_) {
		gboolean _tmp301_ = FALSE;
		gboolean _tmp302_ = FALSE;
		gboolean _tmp303_ = FALSE;
		gboolean _tmp304_;
		gboolean _tmp305_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp282_;
			gint _base_type_size = 0;
			ValaList* _tmp283_;
			gint _tmp284_;
			gint _tmp285_;
			gint _base_type_index = 0;
			_tmp282_ = vala_class_get_base_types (self);
			_base_type_list = _tmp282_;
			_tmp283_ = _base_type_list;
			_tmp284_ = vala_collection_get_size ((ValaCollection*) _tmp283_);
			_tmp285_ = _tmp284_;
			_base_type_size = _tmp285_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp286_;
				gint _tmp287_;
				gint _tmp288_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp289_;
				gint _tmp290_;
				gpointer _tmp291_;
				ValaDataType* _tmp292_;
				ValaTypeSymbol* _tmp293_;
				ValaTypeSymbol* _tmp294_;
				_tmp286_ = _base_type_index;
				_base_type_index = _tmp286_ + 1;
				_tmp287_ = _base_type_index;
				_tmp288_ = _base_type_size;
				if (!(_tmp287_ < _tmp288_)) {
					break;
				}
				_tmp289_ = _base_type_list;
				_tmp290_ = _base_type_index;
				_tmp291_ = vala_list_get (_tmp289_, _tmp290_);
				base_type = (ValaDataType*) _tmp291_;
				_tmp292_ = base_type;
				_tmp293_ = vala_data_type_get_data_type (_tmp292_);
				_tmp294_ = _tmp293_;
				if (VALA_IS_INTERFACE (_tmp294_)) {
					ValaSourceReference* _tmp295_;
					ValaSourceReference* _tmp296_;
					gchar* _tmp297_;
					gchar* _tmp298_;
					gchar* _tmp299_;
					gchar* _tmp300_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp295_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp296_ = _tmp295_;
					_tmp297_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp298_ = _tmp297_;
					_tmp299_ = g_strdup_printf ("compact classes `%s` may not implement interfaces", _tmp298_);
					_tmp300_ = _tmp299_;
					vala_report_error (_tmp296_, _tmp300_);
					_g_free0 (_tmp300_);
					_g_free0 (_tmp298_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp304_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp305_ = _tmp304_;
		if (!_tmp305_) {
			gboolean _tmp306_;
			gboolean _tmp307_;
			_tmp306_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp307_ = _tmp306_;
			_tmp303_ = !_tmp307_;
		} else {
			_tmp303_ = FALSE;
		}
		if (_tmp303_) {
			ValaClass* _tmp308_;
			_tmp308_ = self->priv->_base_class;
			_tmp302_ = _tmp308_ != NULL;
		} else {
			_tmp302_ = FALSE;
		}
		if (_tmp302_) {
			ValaClass* _tmp309_;
			ValaSemanticAnalyzer* _tmp310_;
			ValaSemanticAnalyzer* _tmp311_;
			ValaClass* _tmp312_;
			_tmp309_ = self->priv->_base_class;
			_tmp310_ = vala_code_context_get_analyzer (context);
			_tmp311_ = _tmp310_;
			_tmp312_ = _tmp311_->gsource_type;
			_tmp301_ = _tmp309_ != _tmp312_;
		} else {
			_tmp301_ = FALSE;
		}
		if (_tmp301_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp313_;
				gint _f_size = 0;
				ValaList* _tmp314_;
				gint _tmp315_;
				gint _tmp316_;
				gint _f_index = 0;
				_tmp313_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_f_list = _tmp313_;
				_tmp314_ = _f_list;
				_tmp315_ = vala_collection_get_size ((ValaCollection*) _tmp314_);
				_tmp316_ = _tmp315_;
				_f_size = _tmp316_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp317_;
					gint _tmp318_;
					gint _tmp319_;
					ValaField* f = NULL;
					ValaList* _tmp320_;
					gint _tmp321_;
					gpointer _tmp322_;
					ValaField* _tmp323_;
					ValaMemberBinding _tmp324_;
					ValaMemberBinding _tmp325_;
					_tmp317_ = _f_index;
					_f_index = _tmp317_ + 1;
					_tmp318_ = _f_index;
					_tmp319_ = _f_size;
					if (!(_tmp318_ < _tmp319_)) {
						break;
					}
					_tmp320_ = _f_list;
					_tmp321_ = _f_index;
					_tmp322_ = vala_list_get (_tmp320_, _tmp321_);
					f = (ValaField*) _tmp322_;
					_tmp323_ = f;
					_tmp324_ = vala_field_get_binding (_tmp323_);
					_tmp325_ = _tmp324_;
					if (_tmp325_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp326_;
						ValaSourceReference* _tmp327_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp326_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp327_ = _tmp326_;
						vala_report_error (_tmp327_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
		}
	}
	_tmp328_ = g_direct_equal;
	_tmp329_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp328_);
	prerequisites = (ValaList*) _tmp329_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp330_;
		gint _base_type_size = 0;
		ValaList* _tmp331_;
		gint _tmp332_;
		gint _tmp333_;
		gint _base_type_index = 0;
		_tmp330_ = vala_class_get_base_types (self);
		_base_type_list = _tmp330_;
		_tmp331_ = _base_type_list;
		_tmp332_ = vala_collection_get_size ((ValaCollection*) _tmp331_);
		_tmp333_ = _tmp332_;
		_base_type_size = _tmp333_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp334_;
			gint _tmp335_;
			gint _tmp336_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp337_;
			gint _tmp338_;
			gpointer _tmp339_;
			ValaDataType* _tmp340_;
			ValaTypeSymbol* _tmp341_;
			ValaTypeSymbol* _tmp342_;
			_tmp334_ = _base_type_index;
			_base_type_index = _tmp334_ + 1;
			_tmp335_ = _base_type_index;
			_tmp336_ = _base_type_size;
			if (!(_tmp335_ < _tmp336_)) {
				break;
			}
			_tmp337_ = _base_type_list;
			_tmp338_ = _base_type_index;
			_tmp339_ = vala_list_get (_tmp337_, _tmp338_);
			base_type = (ValaDataType*) _tmp339_;
			_tmp340_ = base_type;
			_tmp341_ = vala_data_type_get_data_type (_tmp340_);
			_tmp342_ = _tmp341_;
			if (VALA_IS_INTERFACE (_tmp342_)) {
				ValaDataType* _tmp343_;
				ValaTypeSymbol* _tmp344_;
				ValaTypeSymbol* _tmp345_;
				ValaList* _tmp346_;
				_tmp343_ = base_type;
				_tmp344_ = vala_data_type_get_data_type (_tmp343_);
				_tmp345_ = _tmp344_;
				_tmp346_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp345_, VALA_TYPE_INTERFACE, ValaInterface), _tmp346_);
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp347_ = g_direct_equal;
	_tmp348_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp347_);
	missing_prereqs = (ValaList*) _tmp348_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp349_;
		ValaList* _tmp350_;
		gint _prereq_size = 0;
		ValaList* _tmp351_;
		gint _tmp352_;
		gint _tmp353_;
		gint _prereq_index = 0;
		_tmp349_ = prerequisites;
		_tmp350_ = _vala_iterable_ref0 (_tmp349_);
		_prereq_list = _tmp350_;
		_tmp351_ = _prereq_list;
		_tmp352_ = vala_collection_get_size ((ValaCollection*) _tmp351_);
		_tmp353_ = _tmp352_;
		_prereq_size = _tmp353_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp354_;
			gint _tmp355_;
			gint _tmp356_;
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp357_;
			gint _tmp358_;
			gpointer _tmp359_;
			ValaTypeSymbol* _tmp360_;
			_tmp354_ = _prereq_index;
			_prereq_index = _tmp354_ + 1;
			_tmp355_ = _prereq_index;
			_tmp356_ = _prereq_size;
			if (!(_tmp355_ < _tmp356_)) {
				break;
			}
			_tmp357_ = _prereq_list;
			_tmp358_ = _prereq_index;
			_tmp359_ = vala_list_get (_tmp357_, _tmp358_);
			prereq = (ValaTypeSymbol*) _tmp359_;
			_tmp360_ = prereq;
			if (!vala_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp360_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))) {
				ValaList* _tmp361_;
				ValaTypeSymbol* _tmp362_;
				gchar* _tmp363_;
				gchar* _tmp364_;
				_tmp361_ = missing_prereqs;
				_tmp362_ = prereq;
				_tmp363_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp362_);
				_tmp364_ = _tmp363_;
				vala_list_insert (_tmp361_, 0, _tmp364_);
				_g_free0 (_tmp364_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp365_ = missing_prereqs;
	_tmp366_ = vala_collection_get_size ((ValaCollection*) _tmp365_);
	_tmp367_ = _tmp366_;
	if (_tmp367_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp368_;
		gchar* _tmp369_;
		gchar* _tmp370_;
		gchar* _tmp371_;
		gboolean first = FALSE;
		const gchar* _tmp390_;
		gchar* _tmp391_;
		ValaSourceReference* _tmp392_;
		ValaSourceReference* _tmp393_;
		const gchar* _tmp394_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp368_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp369_ = _tmp368_;
		_tmp370_ = g_strdup_printf ("%s: some prerequisites (", _tmp369_);
		_tmp371_ = _tmp370_;
		_g_free0 (_tmp369_);
		error_string = _tmp371_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp372_;
			ValaList* _tmp373_;
			gint _s_size = 0;
			ValaList* _tmp374_;
			gint _tmp375_;
			gint _tmp376_;
			gint _s_index = 0;
			_tmp372_ = missing_prereqs;
			_tmp373_ = _vala_iterable_ref0 (_tmp372_);
			_s_list = _tmp373_;
			_tmp374_ = _s_list;
			_tmp375_ = vala_collection_get_size ((ValaCollection*) _tmp374_);
			_tmp376_ = _tmp375_;
			_s_size = _tmp376_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp377_;
				gint _tmp378_;
				gint _tmp379_;
				gchar* s = NULL;
				ValaList* _tmp380_;
				gint _tmp381_;
				gpointer _tmp382_;
				gboolean _tmp383_;
				_tmp377_ = _s_index;
				_s_index = _tmp377_ + 1;
				_tmp378_ = _s_index;
				_tmp379_ = _s_size;
				if (!(_tmp378_ < _tmp379_)) {
					break;
				}
				_tmp380_ = _s_list;
				_tmp381_ = _s_index;
				_tmp382_ = vala_list_get (_tmp380_, _tmp381_);
				s = (gchar*) _tmp382_;
				_tmp383_ = first;
				if (_tmp383_) {
					const gchar* _tmp384_;
					const gchar* _tmp385_;
					gchar* _tmp386_;
					_tmp384_ = error_string;
					_tmp385_ = s;
					_tmp386_ = g_strdup_printf ("%s`%s'", _tmp384_, _tmp385_);
					_g_free0 (error_string);
					error_string = _tmp386_;
					first = FALSE;
				} else {
					const gchar* _tmp387_;
					const gchar* _tmp388_;
					gchar* _tmp389_;
					_tmp387_ = error_string;
					_tmp388_ = s;
					_tmp389_ = g_strdup_printf ("%s, `%s'", _tmp387_, _tmp388_);
					_g_free0 (error_string);
					error_string = _tmp389_;
				}
				_g_free0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
		_tmp390_ = error_string;
		_tmp391_ = g_strconcat (_tmp390_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp391_;
		_tmp392_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp393_ = _tmp392_;
		_tmp394_ = error_string;
		vala_report_error (_tmp393_, _tmp394_);
		_g_free0 (error_string);
	}
	_tmp395_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp396_ = _tmp395_;
	if (_tmp396_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp546_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp397_;
			gint _base_type_size = 0;
			ValaList* _tmp398_;
			gint _tmp399_;
			gint _tmp400_;
			gint _base_type_index = 0;
			_tmp397_ = vala_class_get_base_types (self);
			_base_type_list = _tmp397_;
			_tmp398_ = _base_type_list;
			_tmp399_ = vala_collection_get_size ((ValaCollection*) _tmp398_);
			_tmp400_ = _tmp399_;
			_base_type_size = _tmp400_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp401_;
				gint _tmp402_;
				gint _tmp403_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp404_;
				gint _tmp405_;
				gpointer _tmp406_;
				ValaDataType* _tmp407_;
				ValaTypeSymbol* _tmp408_;
				ValaTypeSymbol* _tmp409_;
				_tmp401_ = _base_type_index;
				_base_type_index = _tmp401_ + 1;
				_tmp402_ = _base_type_index;
				_tmp403_ = _base_type_size;
				if (!(_tmp402_ < _tmp403_)) {
					break;
				}
				_tmp404_ = _base_type_list;
				_tmp405_ = _base_type_index;
				_tmp406_ = vala_list_get (_tmp404_, _tmp405_);
				base_type = (ValaDataType*) _tmp406_;
				_tmp407_ = base_type;
				_tmp408_ = vala_data_type_get_data_type (_tmp407_);
				_tmp409_ = _tmp408_;
				if (VALA_IS_INTERFACE (_tmp409_)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp410_;
					ValaTypeSymbol* _tmp411_;
					ValaTypeSymbol* _tmp412_;
					ValaInterface* _tmp413_;
					gboolean _tmp414_ = FALSE;
					ValaClass* _tmp415_;
					_tmp410_ = base_type;
					_tmp411_ = vala_data_type_get_data_type (_tmp410_);
					_tmp412_ = _tmp411_;
					_tmp413_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp412_, VALA_TYPE_INTERFACE, ValaInterface));
					iface = _tmp413_;
					_tmp415_ = self->priv->_base_class;
					if (_tmp415_ != NULL) {
						ValaClass* _tmp416_;
						ValaInterface* _tmp417_;
						_tmp416_ = self->priv->_base_class;
						_tmp417_ = iface;
						_tmp414_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp416_, (ValaTypeSymbol*) _tmp417_);
					} else {
						_tmp414_ = FALSE;
					}
					if (_tmp414_) {
						_vala_code_node_unref0 (iface);
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp418_;
						ValaList* _tmp419_;
						gint _m_size = 0;
						ValaList* _tmp420_;
						gint _tmp421_;
						gint _tmp422_;
						gint _m_index = 0;
						_tmp418_ = iface;
						_tmp419_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp418_);
						_m_list = _tmp419_;
						_tmp420_ = _m_list;
						_tmp421_ = vala_collection_get_size ((ValaCollection*) _tmp420_);
						_tmp422_ = _tmp421_;
						_m_size = _tmp422_;
						_m_index = -1;
						while (TRUE) {
							gint _tmp423_;
							gint _tmp424_;
							gint _tmp425_;
							ValaMethod* m = NULL;
							ValaList* _tmp426_;
							gint _tmp427_;
							gpointer _tmp428_;
							ValaMethod* _tmp429_;
							gboolean _tmp430_;
							gboolean _tmp431_;
							_tmp423_ = _m_index;
							_m_index = _tmp423_ + 1;
							_tmp424_ = _m_index;
							_tmp425_ = _m_size;
							if (!(_tmp424_ < _tmp425_)) {
								break;
							}
							_tmp426_ = _m_list;
							_tmp427_ = _m_index;
							_tmp428_ = vala_list_get (_tmp426_, _tmp427_);
							m = (ValaMethod*) _tmp428_;
							_tmp429_ = m;
							_tmp430_ = vala_method_get_is_abstract (_tmp429_);
							_tmp431_ = _tmp430_;
							if (_tmp431_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								ValaClass* _tmp432_;
								gboolean _tmp471_;
								implemented = FALSE;
								_tmp432_ = _vala_code_node_ref0 (self);
								base_class = _tmp432_;
								while (TRUE) {
									ValaClass* _tmp433_;
									ValaClass* _tmp468_;
									ValaClass* _tmp469_;
									ValaClass* _tmp470_;
									_tmp433_ = base_class;
									if (!(_tmp433_ != NULL)) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp434_;
										ValaList* _tmp435_;
										gint _impl_size = 0;
										ValaList* _tmp436_;
										gint _tmp437_;
										gint _tmp438_;
										gint _impl_index = 0;
										_tmp434_ = base_class;
										_tmp435_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp434_);
										_impl_list = _tmp435_;
										_tmp436_ = _impl_list;
										_tmp437_ = vala_collection_get_size ((ValaCollection*) _tmp436_);
										_tmp438_ = _tmp437_;
										_impl_size = _tmp438_;
										_impl_index = -1;
										while (TRUE) {
											gint _tmp439_;
											gint _tmp440_;
											gint _tmp441_;
											ValaMethod* impl = NULL;
											ValaList* _tmp442_;
											gint _tmp443_;
											gpointer _tmp444_;
											gboolean _tmp445_ = FALSE;
											ValaMethod* _tmp446_;
											const gchar* _tmp447_;
											const gchar* _tmp448_;
											ValaMethod* _tmp449_;
											const gchar* _tmp450_;
											const gchar* _tmp451_;
											_tmp439_ = _impl_index;
											_impl_index = _tmp439_ + 1;
											_tmp440_ = _impl_index;
											_tmp441_ = _impl_size;
											if (!(_tmp440_ < _tmp441_)) {
												break;
											}
											_tmp442_ = _impl_list;
											_tmp443_ = _impl_index;
											_tmp444_ = vala_list_get (_tmp442_, _tmp443_);
											impl = (ValaMethod*) _tmp444_;
											_tmp446_ = impl;
											_tmp447_ = vala_symbol_get_name ((ValaSymbol*) _tmp446_);
											_tmp448_ = _tmp447_;
											_tmp449_ = m;
											_tmp450_ = vala_symbol_get_name ((ValaSymbol*) _tmp449_);
											_tmp451_ = _tmp450_;
											if (g_strcmp0 (_tmp448_, _tmp451_) == 0) {
												gboolean _tmp452_ = FALSE;
												ValaMethod* _tmp453_;
												ValaDataType* _tmp454_;
												ValaDataType* _tmp455_;
												_tmp453_ = impl;
												_tmp454_ = vala_method_get_base_interface_type (_tmp453_);
												_tmp455_ = _tmp454_;
												if (_tmp455_ == NULL) {
													_tmp452_ = TRUE;
												} else {
													ValaMethod* _tmp456_;
													ValaDataType* _tmp457_;
													ValaDataType* _tmp458_;
													ValaTypeSymbol* _tmp459_;
													ValaTypeSymbol* _tmp460_;
													ValaInterface* _tmp461_;
													_tmp456_ = impl;
													_tmp457_ = vala_method_get_base_interface_type (_tmp456_);
													_tmp458_ = _tmp457_;
													_tmp459_ = vala_data_type_get_data_type (_tmp458_);
													_tmp460_ = _tmp459_;
													_tmp461_ = iface;
													_tmp452_ = _tmp460_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp461_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
												}
												_tmp445_ = _tmp452_;
											} else {
												_tmp445_ = FALSE;
											}
											if (_tmp445_) {
												ValaMethod* _tmp462_;
												ValaVersionAttribute* _tmp463_;
												ValaVersionAttribute* _tmp464_;
												ValaSourceReference* _tmp465_;
												ValaSourceReference* _tmp466_;
												ValaMethod* _tmp467_;
												_tmp462_ = impl;
												_tmp463_ = vala_symbol_get_version ((ValaSymbol*) _tmp462_);
												_tmp464_ = _tmp463_;
												_tmp465_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp466_ = _tmp465_;
												vala_version_attribute_check (_tmp464_, _tmp466_);
												_tmp467_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp467_, TRUE);
												implemented = TRUE;
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
										_vala_iterable_unref0 (_impl_list);
									}
									_tmp468_ = base_class;
									_tmp469_ = _tmp468_->priv->_base_class;
									_tmp470_ = _vala_code_node_ref0 (_tmp469_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp470_;
								}
								_tmp471_ = implemented;
								if (!_tmp471_) {
									ValaSourceReference* _tmp472_;
									ValaSourceReference* _tmp473_;
									gchar* _tmp474_;
									gchar* _tmp475_;
									ValaMethod* _tmp476_;
									gchar* _tmp477_;
									gchar* _tmp478_;
									gchar* _tmp479_;
									gchar* _tmp480_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp472_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp473_ = _tmp472_;
									_tmp474_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp475_ = _tmp474_;
									_tmp476_ = m;
									_tmp477_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp476_);
									_tmp478_ = _tmp477_;
									_tmp479_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp475_, _tmp478_);
									_tmp480_ = _tmp479_;
									vala_report_error (_tmp473_, _tmp480_);
									_g_free0 (_tmp480_);
									_g_free0 (_tmp478_);
									_g_free0 (_tmp475_);
								}
								_vala_code_node_unref0 (base_class);
							}
							_vala_code_node_unref0 (m);
						}
						_vala_iterable_unref0 (_m_list);
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp481_;
						ValaList* _tmp482_;
						gint _prop_size = 0;
						ValaList* _tmp483_;
						gint _tmp484_;
						gint _tmp485_;
						gint _prop_index = 0;
						_tmp481_ = iface;
						_tmp482_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp481_);
						_prop_list = _tmp482_;
						_tmp483_ = _prop_list;
						_tmp484_ = vala_collection_get_size ((ValaCollection*) _tmp483_);
						_tmp485_ = _tmp484_;
						_prop_size = _tmp485_;
						_prop_index = -1;
						while (TRUE) {
							gint _tmp486_;
							gint _tmp487_;
							gint _tmp488_;
							ValaProperty* prop = NULL;
							ValaList* _tmp489_;
							gint _tmp490_;
							gpointer _tmp491_;
							ValaProperty* _tmp492_;
							gboolean _tmp493_;
							gboolean _tmp494_;
							_tmp486_ = _prop_index;
							_prop_index = _tmp486_ + 1;
							_tmp487_ = _prop_index;
							_tmp488_ = _prop_size;
							if (!(_tmp487_ < _tmp488_)) {
								break;
							}
							_tmp489_ = _prop_list;
							_tmp490_ = _prop_index;
							_tmp491_ = vala_list_get (_tmp489_, _tmp490_);
							prop = (ValaProperty*) _tmp491_;
							_tmp492_ = prop;
							_tmp493_ = vala_property_get_is_abstract (_tmp492_);
							_tmp494_ = _tmp493_;
							if (_tmp494_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaClass* _tmp495_;
								ValaSymbol* _tmp509_;
								sym = NULL;
								_tmp495_ = _vala_code_node_ref0 (self);
								base_class = _tmp495_;
								while (TRUE) {
									gboolean _tmp496_ = FALSE;
									ValaClass* _tmp497_;
									ValaClass* _tmp499_;
									ValaScope* _tmp500_;
									ValaScope* _tmp501_;
									ValaProperty* _tmp502_;
									const gchar* _tmp503_;
									const gchar* _tmp504_;
									ValaSymbol* _tmp505_;
									ValaClass* _tmp506_;
									ValaClass* _tmp507_;
									ValaClass* _tmp508_;
									_tmp497_ = base_class;
									if (_tmp497_ != NULL) {
										ValaSymbol* _tmp498_;
										_tmp498_ = sym;
										_tmp496_ = !VALA_IS_PROPERTY (_tmp498_);
									} else {
										_tmp496_ = FALSE;
									}
									if (!_tmp496_) {
										break;
									}
									_tmp499_ = base_class;
									_tmp500_ = vala_symbol_get_scope ((ValaSymbol*) _tmp499_);
									_tmp501_ = _tmp500_;
									_tmp502_ = prop;
									_tmp503_ = vala_symbol_get_name ((ValaSymbol*) _tmp502_);
									_tmp504_ = _tmp503_;
									_tmp505_ = vala_scope_lookup (_tmp501_, _tmp504_);
									_vala_code_node_unref0 (sym);
									sym = _tmp505_;
									_tmp506_ = base_class;
									_tmp507_ = _tmp506_->priv->_base_class;
									_tmp508_ = _vala_code_node_ref0 (_tmp507_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp508_;
								}
								_tmp509_ = sym;
								if (VALA_IS_PROPERTY (_tmp509_)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp510_;
									ValaProperty* _tmp511_;
									gchar* invalid_match = NULL;
									gboolean _tmp512_ = FALSE;
									ValaProperty* _tmp513_;
									gboolean _tmp514_;
									gboolean _tmp515_;
									ValaSymbol* _tmp531_;
									ValaVersionAttribute* _tmp532_;
									ValaVersionAttribute* _tmp533_;
									ValaSourceReference* _tmp534_;
									ValaSourceReference* _tmp535_;
									ValaSymbol* _tmp536_;
									_tmp510_ = sym;
									_tmp511_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp510_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp511_;
									invalid_match = NULL;
									_tmp513_ = base_prop;
									_tmp514_ = vala_symbol_get_hides ((ValaSymbol*) _tmp513_);
									_tmp515_ = _tmp514_;
									if (!_tmp515_) {
										ValaProperty* _tmp516_;
										ValaProperty* _tmp517_;
										gchar* _tmp518_ = NULL;
										gboolean _tmp519_;
										_tmp516_ = base_prop;
										_tmp517_ = prop;
										_tmp519_ = vala_property_compatible (_tmp516_, _tmp517_, &_tmp518_);
										_g_free0 (invalid_match);
										invalid_match = _tmp518_;
										_tmp512_ = !_tmp519_;
									} else {
										_tmp512_ = FALSE;
									}
									if (_tmp512_) {
										ValaSourceReference* _tmp520_;
										ValaSourceReference* _tmp521_;
										ValaProperty* _tmp522_;
										gchar* _tmp523_;
										gchar* _tmp524_;
										ValaProperty* _tmp525_;
										gchar* _tmp526_;
										gchar* _tmp527_;
										const gchar* _tmp528_;
										gchar* _tmp529_;
										gchar* _tmp530_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp520_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp521_ = _tmp520_;
										_tmp522_ = prop;
										_tmp523_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp522_);
										_tmp524_ = _tmp523_;
										_tmp525_ = base_prop;
										_tmp526_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp525_);
										_tmp527_ = _tmp526_;
										_tmp528_ = invalid_match;
										_tmp529_ = g_strdup_printf ("Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp524_, _tmp527_, _tmp528_);
										_tmp530_ = _tmp529_;
										vala_report_error (_tmp521_, _tmp530_);
										_g_free0 (_tmp530_);
										_g_free0 (_tmp527_);
										_g_free0 (_tmp524_);
									}
									_tmp531_ = sym;
									_tmp532_ = vala_symbol_get_version (_tmp531_);
									_tmp533_ = _tmp532_;
									_tmp534_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp535_ = _tmp534_;
									vala_version_attribute_check (_tmp533_, _tmp535_);
									_tmp536_ = sym;
									vala_symbol_set_used (_tmp536_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp537_;
									ValaSourceReference* _tmp538_;
									gchar* _tmp539_;
									gchar* _tmp540_;
									ValaProperty* _tmp541_;
									gchar* _tmp542_;
									gchar* _tmp543_;
									gchar* _tmp544_;
									gchar* _tmp545_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp537_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp538_ = _tmp537_;
									_tmp539_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp540_ = _tmp539_;
									_tmp541_ = prop;
									_tmp542_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp541_);
									_tmp543_ = _tmp542_;
									_tmp544_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp540_, _tmp543_);
									_tmp545_ = _tmp544_;
									vala_report_error (_tmp538_, _tmp545_);
									_g_free0 (_tmp545_);
									_g_free0 (_tmp543_);
									_g_free0 (_tmp540_);
								}
								_vala_code_node_unref0 (base_class);
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_iterable_unref0 (_prop_list);
					}
					_vala_code_node_unref0 (iface);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp546_ = self->priv->_is_abstract;
		if (!_tmp546_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp547_;
			ValaClass* _tmp548_;
			_tmp547_ = self->priv->_base_class;
			_tmp548_ = _vala_code_node_ref0 (_tmp547_);
			base_class = _tmp548_;
			while (TRUE) {
				gboolean _tmp549_ = FALSE;
				ValaClass* _tmp550_;
				ValaClass* _tmp619_;
				ValaClass* _tmp620_;
				ValaClass* _tmp621_;
				_tmp550_ = base_class;
				if (_tmp550_ != NULL) {
					ValaClass* _tmp551_;
					gboolean _tmp552_;
					_tmp551_ = base_class;
					_tmp552_ = _tmp551_->priv->_is_abstract;
					_tmp549_ = _tmp552_;
				} else {
					_tmp549_ = FALSE;
				}
				if (!_tmp549_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp553_;
					ValaList* _tmp554_;
					gint _base_method_size = 0;
					ValaList* _tmp555_;
					gint _tmp556_;
					gint _tmp557_;
					gint _base_method_index = 0;
					_tmp553_ = base_class;
					_tmp554_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp553_);
					_base_method_list = _tmp554_;
					_tmp555_ = _base_method_list;
					_tmp556_ = vala_collection_get_size ((ValaCollection*) _tmp555_);
					_tmp557_ = _tmp556_;
					_base_method_size = _tmp557_;
					_base_method_index = -1;
					while (TRUE) {
						gint _tmp558_;
						gint _tmp559_;
						gint _tmp560_;
						ValaMethod* base_method = NULL;
						ValaList* _tmp561_;
						gint _tmp562_;
						gpointer _tmp563_;
						ValaMethod* _tmp564_;
						gboolean _tmp565_;
						gboolean _tmp566_;
						_tmp558_ = _base_method_index;
						_base_method_index = _tmp558_ + 1;
						_tmp559_ = _base_method_index;
						_tmp560_ = _base_method_size;
						if (!(_tmp559_ < _tmp560_)) {
							break;
						}
						_tmp561_ = _base_method_list;
						_tmp562_ = _base_method_index;
						_tmp563_ = vala_list_get (_tmp561_, _tmp562_);
						base_method = (ValaMethod*) _tmp563_;
						_tmp564_ = base_method;
						_tmp565_ = vala_method_get_is_abstract (_tmp564_);
						_tmp566_ = _tmp565_;
						if (_tmp566_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp567_;
							const gchar* _tmp568_;
							const gchar* _tmp569_;
							ValaSymbol* _tmp570_;
							ValaMethod* _tmp571_;
							gboolean _tmp572_ = FALSE;
							ValaMethod* _tmp573_;
							_tmp567_ = base_method;
							_tmp568_ = vala_symbol_get_name ((ValaSymbol*) _tmp567_);
							_tmp569_ = _tmp568_;
							_tmp570_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp569_);
							_tmp571_ = VALA_IS_METHOD (_tmp570_) ? ((ValaMethod*) _tmp570_) : NULL;
							if (_tmp571_ == NULL) {
								_vala_code_node_unref0 (_tmp570_);
							}
							override_method = _tmp571_;
							_tmp573_ = override_method;
							if (_tmp573_ == NULL) {
								_tmp572_ = TRUE;
							} else {
								ValaMethod* _tmp574_;
								gboolean _tmp575_;
								gboolean _tmp576_;
								_tmp574_ = override_method;
								_tmp575_ = vala_method_get_overrides (_tmp574_);
								_tmp576_ = _tmp575_;
								_tmp572_ = !_tmp576_;
							}
							if (_tmp572_) {
								ValaSourceReference* _tmp577_;
								ValaSourceReference* _tmp578_;
								gchar* _tmp579_;
								gchar* _tmp580_;
								ValaMethod* _tmp581_;
								gchar* _tmp582_;
								gchar* _tmp583_;
								gchar* _tmp584_;
								gchar* _tmp585_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp577_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp578_ = _tmp577_;
								_tmp579_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp580_ = _tmp579_;
								_tmp581_ = base_method;
								_tmp582_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp581_);
								_tmp583_ = _tmp582_;
								_tmp584_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp580_, _tmp583_);
								_tmp585_ = _tmp584_;
								vala_report_error (_tmp578_, _tmp585_);
								_g_free0 (_tmp585_);
								_g_free0 (_tmp583_);
								_g_free0 (_tmp580_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_vala_iterable_unref0 (_base_method_list);
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp586_;
					ValaList* _tmp587_;
					gint _base_property_size = 0;
					ValaList* _tmp588_;
					gint _tmp589_;
					gint _tmp590_;
					gint _base_property_index = 0;
					_tmp586_ = base_class;
					_tmp587_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp586_);
					_base_property_list = _tmp587_;
					_tmp588_ = _base_property_list;
					_tmp589_ = vala_collection_get_size ((ValaCollection*) _tmp588_);
					_tmp590_ = _tmp589_;
					_base_property_size = _tmp590_;
					_base_property_index = -1;
					while (TRUE) {
						gint _tmp591_;
						gint _tmp592_;
						gint _tmp593_;
						ValaProperty* base_property = NULL;
						ValaList* _tmp594_;
						gint _tmp595_;
						gpointer _tmp596_;
						ValaProperty* _tmp597_;
						gboolean _tmp598_;
						gboolean _tmp599_;
						_tmp591_ = _base_property_index;
						_base_property_index = _tmp591_ + 1;
						_tmp592_ = _base_property_index;
						_tmp593_ = _base_property_size;
						if (!(_tmp592_ < _tmp593_)) {
							break;
						}
						_tmp594_ = _base_property_list;
						_tmp595_ = _base_property_index;
						_tmp596_ = vala_list_get (_tmp594_, _tmp595_);
						base_property = (ValaProperty*) _tmp596_;
						_tmp597_ = base_property;
						_tmp598_ = vala_property_get_is_abstract (_tmp597_);
						_tmp599_ = _tmp598_;
						if (_tmp599_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp600_;
							const gchar* _tmp601_;
							const gchar* _tmp602_;
							ValaSymbol* _tmp603_;
							ValaProperty* _tmp604_;
							gboolean _tmp605_ = FALSE;
							ValaProperty* _tmp606_;
							_tmp600_ = base_property;
							_tmp601_ = vala_symbol_get_name ((ValaSymbol*) _tmp600_);
							_tmp602_ = _tmp601_;
							_tmp603_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp602_);
							_tmp604_ = VALA_IS_PROPERTY (_tmp603_) ? ((ValaProperty*) _tmp603_) : NULL;
							if (_tmp604_ == NULL) {
								_vala_code_node_unref0 (_tmp603_);
							}
							override_property = _tmp604_;
							_tmp606_ = override_property;
							if (_tmp606_ == NULL) {
								_tmp605_ = TRUE;
							} else {
								ValaProperty* _tmp607_;
								gboolean _tmp608_;
								gboolean _tmp609_;
								_tmp607_ = override_property;
								_tmp608_ = vala_property_get_overrides (_tmp607_);
								_tmp609_ = _tmp608_;
								_tmp605_ = !_tmp609_;
							}
							if (_tmp605_) {
								ValaSourceReference* _tmp610_;
								ValaSourceReference* _tmp611_;
								gchar* _tmp612_;
								gchar* _tmp613_;
								ValaProperty* _tmp614_;
								gchar* _tmp615_;
								gchar* _tmp616_;
								gchar* _tmp617_;
								gchar* _tmp618_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp610_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp611_ = _tmp610_;
								_tmp612_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp613_ = _tmp612_;
								_tmp614_ = base_property;
								_tmp615_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp614_);
								_tmp616_ = _tmp615_;
								_tmp617_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp613_, _tmp616_);
								_tmp618_ = _tmp617_;
								vala_report_error (_tmp611_, _tmp618_);
								_g_free0 (_tmp618_);
								_g_free0 (_tmp616_);
								_g_free0 (_tmp613_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_vala_iterable_unref0 (_base_property_list);
				}
				_tmp619_ = base_class;
				_tmp620_ = _tmp619_->priv->_base_class;
				_tmp621_ = _vala_code_node_ref0 (_tmp620_);
				_vala_code_node_unref0 (base_class);
				base_class = _tmp621_;
			}
			_vala_code_node_unref0 (base_class);
		}
	}
	_tmp622_ = vala_code_context_get_analyzer (context);
	_tmp623_ = _tmp622_;
	_tmp624_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp623_, _tmp624_);
	_tmp625_ = vala_code_context_get_analyzer (context);
	_tmp626_ = _tmp625_;
	_tmp627_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp626_, _tmp627_);
	_tmp628_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp629_ = _tmp628_;
	result = !_tmp629_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}


void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}


gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_abstract;
	result = _tmp0_;
	return result;
}


void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}


gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_compact (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			ValaAttribute* _tmp9_;
			gboolean _tmp10_;
			gboolean* _tmp11_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_ != NULL;
			_tmp11_ = __bool_dup0 (&_tmp10_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp11_;
			_vala_code_node_unref0 (_tmp9_);
		}
	}
	_tmp12_ = self->priv->_is_compact;
	result = *_tmp12_;
	return result;
}


void
vala_class_set_is_compact (ValaClass* self,
                           gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_compact);
	self->priv->_is_compact = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Compact", value, NULL);
}


gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_immutable (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			ValaAttribute* _tmp9_;
			gboolean _tmp10_;
			gboolean* _tmp11_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_ != NULL;
			_tmp11_ = __bool_dup0 (&_tmp10_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp11_;
			_vala_code_node_unref0 (_tmp9_);
		}
	}
	_tmp12_ = self->priv->_is_immutable;
	result = *_tmp12_;
	return result;
}


void
vala_class_set_is_immutable (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", value, NULL);
}


gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_private_fields;
	result = _tmp0_;
	return result;
}


void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}


gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_class_private_fields;
	result = _tmp0_;
	return result;
}


static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}


ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}


void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}


ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
	_tmp1_ = self->priv->_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
	_tmp1_ = self->priv->_class_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
	_tmp1_ = self->priv->_static_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		ValaDestructor* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaDestructor* _tmp16_;
		ValaObjectType* _tmp17_;
		ValaObjectType* _tmp18_;
		ValaParameter* _tmp19_;
		ValaParameter* _tmp20_;
		ValaDestructor* _tmp21_;
		ValaScope* _tmp22_;
		ValaScope* _tmp23_;
		ValaDestructor* _tmp24_;
		ValaParameter* _tmp25_;
		ValaParameter* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		ValaDestructor* _tmp29_;
		ValaParameter* _tmp30_;
		ValaParameter* _tmp31_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
		_tmp5_ = self->priv->_destructor;
		_tmp6_ = vala_destructor_get_this_parameter (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ != NULL) {
			ValaDestructor* _tmp8_;
			ValaScope* _tmp9_;
			ValaScope* _tmp10_;
			ValaDestructor* _tmp11_;
			ValaParameter* _tmp12_;
			ValaParameter* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp8_ = self->priv->_destructor;
			_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->_destructor;
			_tmp12_ = vala_destructor_get_this_parameter (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_symbol_get_name ((ValaSymbol*) _tmp13_);
			_tmp15_ = _tmp14_;
			vala_scope_remove (_tmp10_, _tmp15_);
		}
		_tmp16_ = self->priv->_destructor;
		_tmp17_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_parameter_new ("this", (ValaDataType*) _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		vala_destructor_set_this_parameter (_tmp16_, _tmp20_);
		_vala_code_node_unref0 (_tmp20_);
		_vala_code_node_unref0 (_tmp18_);
		_tmp21_ = self->priv->_destructor;
		_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = self->priv->_destructor;
		_tmp25_ = vala_destructor_get_this_parameter (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_symbol_get_name ((ValaSymbol*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = self->priv->_destructor;
		_tmp30_ = vala_destructor_get_this_parameter (_tmp29_);
		_tmp31_ = _tmp30_;
		vala_scope_add (_tmp23_, _tmp28_, (ValaSymbol*) _tmp31_);
	}
}


ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
	_tmp1_ = self->priv->_static_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
	_tmp1_ = self->priv->_class_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


static void
vala_class_class_init (ValaClassClass * klass)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_add_private (klass, sizeof (ValaClassPrivate));
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_class_real_check;
}


static void
vala_class_instance_init (ValaClass * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_CLASS_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
}


static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_immutable);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}


/**
 * Represents a class declaration in the source code.
 */
GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
		GType vala_class_type_id;
		vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}



