/* valalocalvariable.c generated by valac, the Vala compiler
 * generated from valalocalvariable.vala, do not modify */

/* valalocalvariable.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaLocalVariablePrivate {
	gboolean _is_result;
	gboolean _captured;
	gboolean _init;
};


static gpointer vala_local_variable_parent_class = NULL;

#define VALA_LOCAL_VARIABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariablePrivate))
static void vala_local_variable_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_local_variable_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static void vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static void vala_local_variable_real_replace_type (ValaCodeNode* base,
                                            ValaDataType* old_type,
                                            ValaDataType* new_type);
static gboolean vala_local_variable_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_local_variable_finalize (ValaCodeNode * obj);


/**
 * Creates a new local variable.
 *
 * @param name              name of the variable
 * @param initializer       optional initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created variable declarator
 */
ValaLocalVariable*
vala_local_variable_construct (GType object_type,
                               ValaDataType* variable_type,
                               const gchar* name,
                               ValaExpression* initializer,
                               ValaSourceReference* source_reference)
{
	ValaLocalVariable* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaLocalVariable*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, NULL);
	return self;
}


ValaLocalVariable*
vala_local_variable_new (ValaDataType* variable_type,
                         const gchar* name,
                         ValaExpression* initializer,
                         ValaSourceReference* source_reference)
{
	return vala_local_variable_construct (VALA_TYPE_LOCAL_VARIABLE, variable_type, name, initializer, source_reference);
}


static void
vala_local_variable_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_local_variable (visitor, self);
}


static void
vala_local_variable_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
	}
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}


static void
vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}


static void
vala_local_variable_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type)
{
	ValaLocalVariable * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_local_variable_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaLocalVariable * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean is_initializer_list = FALSE;
	gint initializer_size = 0;
	gboolean _tmp12_ = FALSE;
	ValaExpression* _tmp13_;
	ValaExpression* _tmp14_;
	ValaSemanticAnalyzer* _tmp29_;
	ValaSemanticAnalyzer* _tmp30_;
	ValaSymbol* _tmp31_;
	ValaSymbol* _tmp32_;
	ValaScope* _tmp33_;
	ValaScope* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	ValaDataType* _tmp39_;
	ValaDataType* _tmp40_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp88_;
	ValaDataType* _tmp89_;
	gboolean _tmp90_ = FALSE;
	gboolean _tmp91_ = FALSE;
	gboolean _tmp92_ = FALSE;
	ValaArrayType* _tmp93_;
	gboolean _tmp105_ = FALSE;
	gboolean _tmp106_ = FALSE;
	gboolean _tmp107_ = FALSE;
	ValaArrayType* _tmp108_;
	gboolean _tmp119_ = FALSE;
	ValaExpression* _tmp120_;
	ValaExpression* _tmp121_;
	ValaBlock* block = NULL;
	ValaSemanticAnalyzer* _tmp239_;
	ValaSemanticAnalyzer* _tmp240_;
	ValaSymbol* _tmp241_;
	ValaSymbol* _tmp242_;
	ValaBlock* _tmp243_;
	ValaBlock* _tmp244_;
	gboolean _tmp246_;
	gboolean _tmp247_;
	self = (ValaLocalVariable*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_VOID_TYPE (_tmp7_)) {
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp9_ = _tmp8_;
			vala_report_error (_tmp9_, "'void' not supported as variable type");
		} else {
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			_tmp10_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp11_ = _tmp10_;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp11_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
		}
	}
	is_initializer_list = FALSE;
	initializer_size = -1;
	_tmp13_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		gboolean _tmp15_;
		gboolean _tmp16_;
		_tmp15_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp16_ = _tmp15_;
		_tmp12_ = !_tmp16_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaDataType* _tmp19_;
		ValaDataType* _tmp20_;
		ValaExpression* _tmp21_;
		ValaExpression* _tmp22_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp20_ = _tmp19_;
		vala_expression_set_target_type (_tmp18_, _tmp20_);
		_tmp21_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp22_ = _tmp21_;
		if (VALA_IS_INITIALIZER_LIST (_tmp22_)) {
			ValaExpression* _tmp23_;
			ValaExpression* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			_tmp23_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp26_ = _tmp25_;
			initializer_size = _tmp26_;
			is_initializer_list = TRUE;
		}
		_tmp27_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp28_ = _tmp27_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp28_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
	}
	_tmp29_ = vala_code_context_get_analyzer (context);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_semantic_analyzer_get_current_symbol (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_symbol_get_scope (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp36_ = _tmp35_;
	vala_scope_add (_tmp34_, _tmp36_, (ValaSymbol*) self);
	_tmp37_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp38_ = _tmp37_;
	if (_tmp38_) {
		result = FALSE;
		return result;
	}
	_tmp39_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == NULL) {
		ValaExpression* _tmp41_;
		ValaExpression* _tmp42_;
		ValaExpression* _tmp45_;
		ValaExpression* _tmp46_;
		ValaDataType* _tmp47_;
		ValaDataType* _tmp48_;
		gboolean _tmp51_ = FALSE;
		ValaExpression* _tmp52_;
		ValaExpression* _tmp53_;
		ValaDataType* _tmp54_;
		ValaDataType* _tmp55_;
		ValaExpression* _tmp72_;
		ValaExpression* _tmp73_;
		ValaDataType* _tmp74_;
		ValaDataType* _tmp75_;
		ValaDataType* _tmp76_;
		ValaDataType* _tmp77_;
		ValaDataType* _tmp78_;
		ValaDataType* _tmp79_;
		ValaDataType* _tmp80_;
		ValaDataType* _tmp81_;
		ValaExpression* _tmp82_;
		ValaExpression* _tmp83_;
		ValaDataType* _tmp84_;
		ValaDataType* _tmp85_;
		ValaDataType* _tmp86_;
		ValaDataType* _tmp87_;
		_tmp41_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp42_ = _tmp41_;
		if (_tmp42_ == NULL) {
			ValaSourceReference* _tmp43_;
			ValaSourceReference* _tmp44_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp44_ = _tmp43_;
			vala_report_error (_tmp44_, "var declaration not allowed without initializer");
			result = FALSE;
			return result;
		}
		_tmp45_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp46_ = _tmp45_;
		_tmp47_ = vala_expression_get_value_type (_tmp46_);
		_tmp48_ = _tmp47_;
		if (_tmp48_ == NULL) {
			ValaSourceReference* _tmp49_;
			ValaSourceReference* _tmp50_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp50_ = _tmp49_;
			vala_report_error (_tmp50_, "var declaration not allowed with non-typed initializer");
			result = FALSE;
			return result;
		}
		_tmp52_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_expression_get_value_type (_tmp53_);
		_tmp55_ = _tmp54_;
		if (VALA_IS_FIELD_PROTOTYPE (_tmp55_)) {
			_tmp51_ = TRUE;
		} else {
			ValaExpression* _tmp56_;
			ValaExpression* _tmp57_;
			ValaDataType* _tmp58_;
			ValaDataType* _tmp59_;
			_tmp56_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_expression_get_value_type (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp51_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp59_);
		}
		if (_tmp51_) {
			ValaExpression* _tmp60_;
			ValaExpression* _tmp61_;
			ValaSourceReference* _tmp62_;
			ValaSourceReference* _tmp63_;
			ValaExpression* _tmp64_;
			ValaExpression* _tmp65_;
			ValaSymbol* _tmp66_;
			ValaSymbol* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp60_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp65_ = _tmp64_;
			_tmp66_ = vala_expression_get_symbol_reference (_tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_symbol_get_full_name (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp69_);
			_tmp71_ = _tmp70_;
			vala_report_error (_tmp63_, _tmp71_);
			_g_free0 (_tmp71_);
			_g_free0 (_tmp69_);
			result = FALSE;
			return result;
		}
		_tmp72_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_expression_get_value_type (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_data_type_copy (_tmp75_);
		_tmp77_ = _tmp76_;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp77_);
		_vala_code_node_unref0 (_tmp77_);
		_tmp78_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp79_ = _tmp78_;
		vala_data_type_set_value_owned (_tmp79_, TRUE);
		_tmp80_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp81_ = _tmp80_;
		vala_data_type_set_floating_reference (_tmp81_, FALSE);
		_tmp82_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp83_ = _tmp82_;
		_tmp84_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp85_ = _tmp84_;
		vala_expression_set_target_type (_tmp83_, _tmp85_);
		_tmp86_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp87_ = _tmp86_;
		vala_code_node_check ((ValaCodeNode*) _tmp87_, context);
	}
	_tmp88_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp89_ = _tmp88_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp89_) ? ((ValaArrayType*) _tmp89_) : NULL;
	_tmp93_ = variable_array_type;
	if (_tmp93_ != NULL) {
		ValaArrayType* _tmp94_;
		gboolean _tmp95_;
		gboolean _tmp96_;
		_tmp94_ = variable_array_type;
		_tmp95_ = vala_array_type_get_inline_allocated (_tmp94_);
		_tmp96_ = _tmp95_;
		_tmp92_ = _tmp96_;
	} else {
		_tmp92_ = FALSE;
	}
	if (_tmp92_) {
		ValaExpression* _tmp97_;
		ValaExpression* _tmp98_;
		_tmp97_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp98_ = _tmp97_;
		_tmp91_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp98_);
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		ValaExpression* _tmp99_;
		ValaExpression* _tmp100_;
		ValaInitializerList* _tmp101_;
		ValaInitializerList* _tmp102_;
		_tmp99_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp100_ = _tmp99_;
		_tmp101_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp102_ = _tmp101_;
		_tmp90_ = _tmp102_ == NULL;
	} else {
		_tmp90_ = FALSE;
	}
	if (_tmp90_) {
		ValaSourceReference* _tmp103_;
		ValaSourceReference* _tmp104_;
		_tmp103_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp104_ = _tmp103_;
		vala_report_warning (_tmp104_, "Inline allocated arrays don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp108_ = variable_array_type;
	if (_tmp108_ != NULL) {
		ValaArrayType* _tmp109_;
		gboolean _tmp110_;
		gboolean _tmp111_;
		_tmp109_ = variable_array_type;
		_tmp110_ = vala_array_type_get_inline_allocated (_tmp109_);
		_tmp111_ = _tmp110_;
		_tmp107_ = _tmp111_;
	} else {
		_tmp107_ = FALSE;
	}
	if (_tmp107_) {
		ValaArrayType* _tmp112_;
		ValaExpression* _tmp113_;
		ValaExpression* _tmp114_;
		_tmp112_ = variable_array_type;
		_tmp113_ = vala_array_type_get_length (_tmp112_);
		_tmp114_ = _tmp113_;
		_tmp106_ = _tmp114_ == NULL;
	} else {
		_tmp106_ = FALSE;
	}
	if (_tmp106_) {
		ValaExpression* _tmp115_;
		ValaExpression* _tmp116_;
		_tmp115_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp116_ = _tmp115_;
		_tmp105_ = !VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp116_);
	} else {
		_tmp105_ = FALSE;
	}
	if (_tmp105_) {
		ValaSourceReference* _tmp117_;
		ValaSourceReference* _tmp118_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp118_ = _tmp117_;
		vala_report_error (_tmp118_, "Inline allocated array requires either a given length or an initialize" \
"r");
	}
	_tmp120_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp121_ = _tmp120_;
	if (_tmp121_ != NULL) {
		ValaExpression* _tmp122_;
		ValaExpression* _tmp123_;
		gboolean _tmp124_;
		gboolean _tmp125_;
		_tmp122_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp123_ = _tmp122_;
		_tmp124_ = vala_code_node_get_error ((ValaCodeNode*) _tmp123_);
		_tmp125_ = _tmp124_;
		_tmp119_ = !_tmp125_;
	} else {
		_tmp119_ = FALSE;
	}
	if (_tmp119_) {
		ValaExpression* _tmp126_;
		ValaExpression* _tmp127_;
		ValaDataType* _tmp128_;
		ValaDataType* _tmp129_;
		ValaExpression* _tmp175_;
		ValaExpression* _tmp176_;
		ValaDataType* _tmp177_;
		ValaDataType* _tmp178_;
		ValaDataType* _tmp179_;
		ValaDataType* _tmp180_;
		gboolean _tmp195_ = FALSE;
		gboolean _tmp196_ = FALSE;
		gboolean _tmp197_ = FALSE;
		ValaArrayType* _tmp198_;
		gboolean _tmp214_ = FALSE;
		gboolean _tmp215_ = FALSE;
		ValaArrayType* _tmp216_;
		ValaExpression* _tmp226_;
		ValaExpression* _tmp227_;
		ValaDataType* _tmp228_;
		ValaDataType* _tmp229_;
		_tmp126_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp127_ = _tmp126_;
		_tmp128_ = vala_expression_get_value_type (_tmp127_);
		_tmp129_ = _tmp128_;
		if (_tmp129_ == NULL) {
			gboolean _tmp130_ = FALSE;
			ValaExpression* _tmp131_;
			ValaExpression* _tmp132_;
			gboolean _tmp137_ = FALSE;
			ValaExpression* _tmp138_;
			ValaExpression* _tmp139_;
			ValaSymbol* _tmp140_;
			ValaSymbol* _tmp141_;
			_tmp131_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp132_ = _tmp131_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp132_)) {
				ValaExpression* _tmp133_;
				ValaExpression* _tmp134_;
				_tmp133_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp134_ = _tmp133_;
				_tmp130_ = !VALA_IS_LAMBDA_EXPRESSION (_tmp134_);
			} else {
				_tmp130_ = FALSE;
			}
			if (_tmp130_) {
				ValaSourceReference* _tmp135_;
				ValaSourceReference* _tmp136_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp135_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp136_ = _tmp135_;
				vala_report_error (_tmp136_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
			_tmp138_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp139_ = _tmp138_;
			_tmp140_ = vala_expression_get_symbol_reference (_tmp139_);
			_tmp141_ = _tmp140_;
			if (VALA_IS_METHOD (_tmp141_)) {
				ValaDataType* _tmp142_;
				ValaDataType* _tmp143_;
				_tmp142_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp143_ = _tmp142_;
				_tmp137_ = VALA_IS_DELEGATE_TYPE (_tmp143_);
			} else {
				_tmp137_ = FALSE;
			}
			if (_tmp137_) {
				ValaMethod* m = NULL;
				ValaExpression* _tmp144_;
				ValaExpression* _tmp145_;
				ValaSymbol* _tmp146_;
				ValaSymbol* _tmp147_;
				ValaMethod* _tmp148_;
				ValaDelegateType* dt = NULL;
				ValaDataType* _tmp149_;
				ValaDataType* _tmp150_;
				ValaDelegateType* _tmp151_;
				ValaDelegate* cb = NULL;
				ValaDelegateType* _tmp152_;
				ValaDelegate* _tmp153_;
				ValaDelegate* _tmp154_;
				ValaDelegate* _tmp155_;
				ValaDelegate* _tmp156_;
				ValaMethod* _tmp157_;
				ValaDelegateType* _tmp158_;
				ValaExpression* _tmp169_;
				ValaExpression* _tmp170_;
				ValaDataType* _tmp171_;
				ValaDataType* _tmp172_;
				_tmp144_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp145_ = _tmp144_;
				_tmp146_ = vala_expression_get_symbol_reference (_tmp145_);
				_tmp147_ = _tmp146_;
				_tmp148_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_METHOD, ValaMethod));
				m = _tmp148_;
				_tmp149_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp150_ = _tmp149_;
				_tmp151_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp150_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				dt = _tmp151_;
				_tmp152_ = dt;
				_tmp153_ = vala_delegate_type_get_delegate_symbol (_tmp152_);
				_tmp154_ = _tmp153_;
				_tmp155_ = _vala_code_node_ref0 (_tmp154_);
				cb = _tmp155_;
				_tmp156_ = cb;
				_tmp157_ = m;
				_tmp158_ = dt;
				if (!vala_delegate_matches_method (_tmp156_, _tmp157_, (ValaDataType*) _tmp158_)) {
					ValaSourceReference* _tmp159_;
					ValaSourceReference* _tmp160_;
					ValaMethod* _tmp161_;
					gchar* _tmp162_;
					gchar* _tmp163_;
					ValaDelegate* _tmp164_;
					gchar* _tmp165_;
					gchar* _tmp166_;
					gchar* _tmp167_;
					gchar* _tmp168_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp159_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp160_ = _tmp159_;
					_tmp161_ = m;
					_tmp162_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp161_);
					_tmp163_ = _tmp162_;
					_tmp164_ = cb;
					_tmp165_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp164_);
					_tmp166_ = _tmp165_;
					_tmp167_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp163_, _tmp166_);
					_tmp168_ = _tmp167_;
					vala_report_error (_tmp160_, _tmp168_);
					_g_free0 (_tmp168_);
					_g_free0 (_tmp166_);
					_g_free0 (_tmp163_);
					result = FALSE;
					_vala_code_node_unref0 (cb);
					_vala_code_node_unref0 (dt);
					_vala_code_node_unref0 (m);
					return result;
				}
				_tmp169_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp170_ = _tmp169_;
				_tmp171_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp172_ = _tmp171_;
				vala_expression_set_value_type (_tmp170_, _tmp172_);
				_vala_code_node_unref0 (cb);
				_vala_code_node_unref0 (dt);
				_vala_code_node_unref0 (m);
			} else {
				ValaSourceReference* _tmp173_;
				ValaSourceReference* _tmp174_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp173_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp174_ = _tmp173_;
				vala_report_error (_tmp174_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		}
		_tmp175_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp176_ = _tmp175_;
		_tmp177_ = vala_expression_get_value_type (_tmp176_);
		_tmp178_ = _tmp177_;
		_tmp179_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp180_ = _tmp179_;
		if (!vala_data_type_compatible (_tmp178_, _tmp180_)) {
			ValaSourceReference* _tmp181_;
			ValaSourceReference* _tmp182_;
			ValaExpression* _tmp183_;
			ValaExpression* _tmp184_;
			ValaDataType* _tmp185_;
			ValaDataType* _tmp186_;
			gchar* _tmp187_;
			gchar* _tmp188_;
			ValaDataType* _tmp189_;
			ValaDataType* _tmp190_;
			gchar* _tmp191_;
			gchar* _tmp192_;
			gchar* _tmp193_;
			gchar* _tmp194_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp182_ = _tmp181_;
			_tmp183_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp184_ = _tmp183_;
			_tmp185_ = vala_expression_get_value_type (_tmp184_);
			_tmp186_ = _tmp185_;
			_tmp187_ = vala_code_node_to_string ((ValaCodeNode*) _tmp186_);
			_tmp188_ = _tmp187_;
			_tmp189_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp190_ = _tmp189_;
			_tmp191_ = vala_code_node_to_string ((ValaCodeNode*) _tmp190_);
			_tmp192_ = _tmp191_;
			_tmp193_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp188_, _tmp192_);
			_tmp194_ = _tmp193_;
			vala_report_error (_tmp182_, _tmp194_);
			_g_free0 (_tmp194_);
			_g_free0 (_tmp192_);
			_g_free0 (_tmp188_);
			result = FALSE;
			return result;
		}
		_tmp198_ = variable_array_type;
		if (_tmp198_ != NULL) {
			ValaArrayType* _tmp199_;
			gboolean _tmp200_;
			gboolean _tmp201_;
			_tmp199_ = variable_array_type;
			_tmp200_ = vala_array_type_get_inline_allocated (_tmp199_);
			_tmp201_ = _tmp200_;
			_tmp197_ = _tmp201_;
		} else {
			_tmp197_ = FALSE;
		}
		if (_tmp197_) {
			ValaArrayType* _tmp202_;
			gboolean _tmp203_;
			gboolean _tmp204_;
			_tmp202_ = variable_array_type;
			_tmp203_ = vala_array_type_get_fixed_length (_tmp202_);
			_tmp204_ = _tmp203_;
			_tmp196_ = !_tmp204_;
		} else {
			_tmp196_ = FALSE;
		}
		if (_tmp196_) {
			gboolean _tmp205_;
			_tmp205_ = is_initializer_list;
			_tmp195_ = _tmp205_;
		} else {
			_tmp195_ = FALSE;
		}
		if (_tmp195_) {
			ValaArrayType* _tmp206_;
			gint _tmp207_;
			gchar* _tmp208_;
			gchar* _tmp209_;
			ValaIntegerLiteral* _tmp210_;
			ValaIntegerLiteral* _tmp211_;
			ValaArrayType* _tmp212_;
			ValaArrayType* _tmp213_;
			_tmp206_ = variable_array_type;
			_tmp207_ = initializer_size;
			_tmp208_ = g_strdup_printf ("%i", _tmp207_);
			_tmp209_ = _tmp208_;
			_tmp210_ = vala_integer_literal_new (_tmp209_, NULL);
			_tmp211_ = _tmp210_;
			vala_array_type_set_length (_tmp206_, (ValaExpression*) _tmp211_);
			_vala_code_node_unref0 (_tmp211_);
			_g_free0 (_tmp209_);
			_tmp212_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp212_, TRUE);
			_tmp213_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp213_, FALSE);
		}
		_tmp216_ = variable_array_type;
		if (_tmp216_ != NULL) {
			ValaArrayType* _tmp217_;
			gboolean _tmp218_;
			gboolean _tmp219_;
			_tmp217_ = variable_array_type;
			_tmp218_ = vala_array_type_get_inline_allocated (_tmp217_);
			_tmp219_ = _tmp218_;
			_tmp215_ = _tmp219_;
		} else {
			_tmp215_ = FALSE;
		}
		if (_tmp215_) {
			ValaExpression* _tmp220_;
			ValaExpression* _tmp221_;
			ValaDataType* _tmp222_;
			ValaDataType* _tmp223_;
			_tmp220_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp221_ = _tmp220_;
			_tmp222_ = vala_expression_get_value_type (_tmp221_);
			_tmp223_ = _tmp222_;
			_tmp214_ = VALA_IS_ARRAY_TYPE (_tmp223_) == FALSE;
		} else {
			_tmp214_ = FALSE;
		}
		if (_tmp214_) {
			ValaSourceReference* _tmp224_;
			ValaSourceReference* _tmp225_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp224_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp225_ = _tmp224_;
			vala_report_error (_tmp225_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			return result;
		}
		_tmp226_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp227_ = _tmp226_;
		_tmp228_ = vala_expression_get_value_type (_tmp227_);
		_tmp229_ = _tmp228_;
		if (vala_data_type_is_disposable (_tmp229_)) {
			gboolean _tmp230_ = FALSE;
			ValaDataType* _tmp231_;
			ValaDataType* _tmp232_;
			_tmp231_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp232_ = _tmp231_;
			if (!VALA_IS_POINTER_TYPE (_tmp232_)) {
				ValaDataType* _tmp233_;
				ValaDataType* _tmp234_;
				gboolean _tmp235_;
				gboolean _tmp236_;
				_tmp233_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp234_ = _tmp233_;
				_tmp235_ = vala_data_type_get_value_owned (_tmp234_);
				_tmp236_ = _tmp235_;
				_tmp230_ = !_tmp236_;
			} else {
				_tmp230_ = FALSE;
			}
			if (_tmp230_) {
				ValaSourceReference* _tmp237_;
				ValaSourceReference* _tmp238_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp238_ = _tmp237_;
				vala_report_error (_tmp238_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp239_ = vala_code_context_get_analyzer (context);
	_tmp240_ = _tmp239_;
	_tmp241_ = vala_semantic_analyzer_get_current_symbol (_tmp240_);
	_tmp242_ = _tmp241_;
	_tmp243_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp242_) ? ((ValaBlock*) _tmp242_) : NULL);
	block = _tmp243_;
	_tmp244_ = block;
	if (_tmp244_ != NULL) {
		ValaBlock* _tmp245_;
		_tmp245_ = block;
		vala_block_add_local_variable (_tmp245_, self);
	}
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp246_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp247_ = _tmp246_;
	result = !_tmp247_;
	_vala_code_node_unref0 (block);
	return result;
}


gboolean
vala_local_variable_get_is_result (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_result;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_is_result (ValaLocalVariable* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_result = value;
}


gboolean
vala_local_variable_get_captured (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_captured;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_captured (ValaLocalVariable* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}


gboolean
vala_local_variable_get_init (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_init;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_init (ValaLocalVariable* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_init = value;
}


static void
vala_local_variable_class_init (ValaLocalVariableClass * klass)
{
	vala_local_variable_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_local_variable_finalize;
	g_type_class_add_private (klass, sizeof (ValaLocalVariablePrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_local_variable_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_local_variable_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_local_variable_real_check;
}


static void
vala_local_variable_instance_init (ValaLocalVariable * self)
{
	self->priv = VALA_LOCAL_VARIABLE_GET_PRIVATE (self);
}


static void
vala_local_variable_finalize (ValaCodeNode * obj)
{
	ValaLocalVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
	VALA_CODE_NODE_CLASS (vala_local_variable_parent_class)->finalize (obj);
}


/**
 * Represents a local variable declaration in the source code.
 */
GType
vala_local_variable_get_type (void)
{
	static volatile gsize vala_local_variable_type_id__volatile = 0;
	if (g_once_init_enter (&vala_local_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariable), 0, (GInstanceInitFunc) vala_local_variable_instance_init, NULL };
		GType vala_local_variable_type_id;
		vala_local_variable_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaLocalVariable", &g_define_type_info, 0);
		g_once_init_leave (&vala_local_variable_type_id__volatile, vala_local_variable_type_id);
	}
	return vala_local_variable_type_id__volatile;
}



