/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};


static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                                      ValaEnum* en);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gsize _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		const gchar* res = NULL;
		gsize _tmp27_;
		void* _tmp28_;
		void* ptr = NULL;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		void* _tmp31_;
		const gchar* _tmp44_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = len;
		_tmp24_ = strlen ((const gchar*) separator);
		_tmp25_ = _tmp24_;
		_tmp26_ = i;
		len = _tmp23_ + (_tmp25_ * (_tmp26_ - 1));
		_tmp27_ = len;
		_tmp28_ = g_malloc (_tmp27_);
		res = _tmp28_;
		_tmp29_ = res;
		_tmp30_ = str_array[0];
		_tmp31_ = g_stpcpy ((void*) _tmp29_, (const gchar*) _tmp30_);
		ptr = _tmp31_;
		{
			gboolean _tmp32_ = FALSE;
			i = 1;
			_tmp32_ = TRUE;
			while (TRUE) {
				gint _tmp34_;
				void* _tmp35_;
				void* _tmp36_;
				const gchar* _tmp37_ = NULL;
				gint _tmp38_;
				const gchar* _tmp39_;
				void* _tmp42_;
				void* _tmp43_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = i;
				if (!(_tmp34_ < str_array_length1)) {
					break;
				}
				_tmp35_ = ptr;
				_tmp36_ = g_stpcpy (_tmp35_, (const gchar*) separator);
				ptr = _tmp36_;
				_tmp38_ = i;
				_tmp39_ = str_array[_tmp38_];
				if (_tmp39_ != NULL) {
					gint _tmp40_;
					const gchar* _tmp41_;
					_tmp40_ = i;
					_tmp41_ = str_array[_tmp40_];
					_tmp37_ = (const gchar*) _tmp41_;
				} else {
					_tmp37_ = "";
				}
				_tmp42_ = ptr;
				_tmp43_ = g_stpcpy (_tmp42_, _tmp37_);
				ptr = _tmp43_;
			}
		}
		_tmp44_ = res;
		res = NULL;
		result = (gchar*) _tmp44_;
		return result;
	} else {
		gchar* _tmp45_;
		_tmp45_ = g_strdup ("");
		result = _tmp45_;
		return result;
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}


static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp130_;
	GEqualFunc _tmp131_;
	GEqualFunc _tmp132_;
	ValaHashMap* _tmp133_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp134_;
	ValaHashMap* _tmp135_;
	gboolean _tmp136_ = FALSE;
	ValaMethod* _tmp137_;
	gboolean _tmp272_ = FALSE;
	ValaMethod* _tmp273_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp444_;
	ValaCCodeExpression* _tmp445_;
	ValaMethod* _tmp446_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp470_ = FALSE;
	ValaMethod* _tmp471_;
	gboolean _tmp627_ = FALSE;
	ValaMethod* _tmp628_;
	ValaMethod* _tmp691_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp890_;
	ValaIterator* _tmp891_;
	ValaIterator* _tmp1285_;
	gboolean _tmp1295_ = FALSE;
	gboolean _tmp1296_ = FALSE;
	ValaMethod* _tmp1297_;
	gboolean _tmp1422_ = FALSE;
	ValaDelegate* _tmp1423_;
	gboolean _tmp1520_ = FALSE;
	ValaMethod* _tmp1521_;
	gboolean _tmp1537_;
	gboolean _tmp1538_;
	gboolean _tmp1553_;
	ValaDataType* _tmp1578_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1602_;
	ValaDataType* _tmp1603_;
	ValaDataType* _tmp1604_;
	gboolean _tmp1605_;
	gboolean _tmp1606_ = FALSE;
	ValaDataType* _tmp1607_;
	ValaCCodeFunctionCall* _tmp1636_;
	ValaCCodeFunctionCall* _tmp1637_;
	ValaCCodeExpression* out_param_ref = NULL;
	gboolean _tmp1638_;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1653_;
	ValaCCodeFunctionCall* _tmp1654_;
	ValaCCodeFunctionCall* _tmp1678_;
	gboolean _tmp1702_;
	gboolean _tmp1703_;
	gboolean _tmp1729_;
	gboolean _tmp1730_;
	gboolean _tmp1760_;
	gboolean _tmp1766_ = FALSE;
	gboolean _tmp1767_ = FALSE;
	ValaMethod* _tmp1768_;
	gboolean _tmp1806_ = FALSE;
	gboolean _tmp1807_ = FALSE;
	gboolean _tmp1808_ = FALSE;
	gboolean _tmp1809_ = FALSE;
	gboolean _tmp1810_ = FALSE;
	ValaMethod* _tmp1811_;
	gboolean _tmp1828_ = FALSE;
	gboolean _tmp1829_ = FALSE;
	ValaMethod* _tmp1830_;
	ValaMethod* _tmp1849_;
	gboolean _tmp1966_ = FALSE;
	ValaCodeNode* _tmp1967_;
	ValaCodeNode* _tmp1968_;
	ValaList* _tmp2044_;
	ValaIterator* _tmp2045_;
	gboolean _tmp2197_ = FALSE;
	gboolean _tmp2198_ = FALSE;
	ValaMethod* _tmp2199_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_tostring_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_;
			gboolean _tmp57_;
			_tmp56_ = vala_method_call_get_is_constructv_chainup (expr);
			_tmp57_ = _tmp56_;
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp58_;
				ValaMethod* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				ValaCCodeIdentifier* _tmp62_;
				ValaCCodeIdentifier* _tmp63_;
				_tmp58_ = ccall;
				_tmp59_ = m;
				_tmp60_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_ccode_identifier_new (_tmp61_);
				_tmp63_ = _tmp62_;
				vala_ccode_function_call_set_call (_tmp58_, (ValaCCodeExpression*) _tmp63_);
				_vala_ccode_node_unref0 (_tmp63_);
				_g_free0 (_tmp61_);
			}
		}
	} else {
		ValaDataType* _tmp64_;
		_tmp64_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp65_;
			ValaSignalType* _tmp66_;
			gboolean _tmp67_ = FALSE;
			gboolean _tmp68_ = FALSE;
			ValaMemberAccess* _tmp69_;
			_tmp65_ = itype;
			_tmp66_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp66_;
			_tmp69_ = ma;
			if (_tmp69_ != NULL) {
				ValaMemberAccess* _tmp70_;
				ValaExpression* _tmp71_;
				ValaExpression* _tmp72_;
				_tmp70_ = ma;
				_tmp71_ = vala_member_access_get_inner (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp68_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp68_ = FALSE;
			}
			if (_tmp68_) {
				ValaSignalType* _tmp73_;
				ValaSignal* _tmp74_;
				ValaSignal* _tmp75_;
				gboolean _tmp76_;
				gboolean _tmp77_;
				_tmp73_ = sig_type;
				_tmp74_ = vala_signal_type_get_signal_symbol (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_signal_get_is_virtual (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp67_ = _tmp77_;
			} else {
				_tmp67_ = FALSE;
			}
			if (_tmp67_) {
				ValaSignalType* _tmp78_;
				ValaSignal* _tmp79_;
				ValaSignal* _tmp80_;
				ValaMethod* _tmp81_;
				ValaMethod* _tmp82_;
				ValaMethod* _tmp83_;
				_tmp78_ = sig_type;
				_tmp79_ = vala_signal_type_get_signal_symbol (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = vala_signal_get_default_handler (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = _vala_code_node_ref0 (_tmp82_);
				_vala_code_node_unref0 (m);
				m = _tmp83_;
			} else {
				ValaExpression* _tmp84_;
				ValaExpression* _tmp85_;
				ValaCCodeExpression* _tmp86_;
				_tmp84_ = vala_method_call_get_call (expr);
				_tmp85_ = _tmp84_;
				_tmp86_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp85_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp87_;
			_tmp87_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp88_;
				ValaObjectTypeSymbol* _tmp89_;
				ValaObjectTypeSymbol* _tmp90_;
				ValaClass* _tmp91_;
				ValaClass* _tmp92_;
				ValaCreationMethod* _tmp93_;
				ValaCreationMethod* _tmp94_;
				ValaMethod* _tmp95_;
				ValaMethod* _tmp96_;
				ValaCCodeFile* _tmp97_;
				gchar* real_name = NULL;
				ValaMethod* _tmp98_;
				gchar* _tmp99_;
				gboolean _tmp100_;
				gboolean _tmp101_;
				const gchar* _tmp104_;
				ValaCCodeIdentifier* _tmp105_;
				ValaCCodeIdentifier* _tmp106_;
				ValaCCodeFunctionCall* _tmp107_;
				_tmp88_ = itype;
				_tmp89_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp90_ = _tmp89_;
				_tmp91_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp91_;
				_tmp92_ = cl;
				_tmp93_ = vala_class_get_default_construction_method (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = _vala_code_node_ref0 ((ValaMethod*) _tmp94_);
				_vala_code_node_unref0 (m);
				m = _tmp95_;
				_tmp96_ = m;
				_tmp97_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp96_, _tmp97_);
				_tmp98_ = m;
				_tmp99_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp98_);
				real_name = _tmp99_;
				_tmp100_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp101_ = _tmp100_;
				if (_tmp101_) {
					ValaMethod* _tmp102_;
					gchar* _tmp103_;
					_tmp102_ = m;
					_tmp103_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp103_;
				}
				_tmp104_ = real_name;
				_tmp105_ = vala_ccode_identifier_new (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp106_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp107_;
				_vala_ccode_node_unref0 (_tmp106_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp108_;
				_tmp108_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp109_;
					ValaTypeSymbol* _tmp110_;
					ValaTypeSymbol* _tmp111_;
					ValaStruct* _tmp112_;
					ValaStruct* _tmp113_;
					ValaMethod* _tmp114_;
					ValaMethod* _tmp115_;
					ValaMethod* _tmp116_;
					ValaMethod* _tmp117_;
					ValaCCodeFile* _tmp118_;
					ValaMethod* _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					ValaCCodeIdentifier* _tmp122_;
					ValaCCodeIdentifier* _tmp123_;
					ValaCCodeFunctionCall* _tmp124_;
					_tmp109_ = itype;
					_tmp110_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp111_ = _tmp110_;
					_tmp112_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp112_;
					_tmp113_ = st;
					_tmp114_ = vala_struct_get_default_construction_method (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = _vala_code_node_ref0 (_tmp115_);
					_vala_code_node_unref0 (m);
					m = _tmp116_;
					_tmp117_ = m;
					_tmp118_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp117_, _tmp118_);
					_tmp119_ = m;
					_tmp120_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = vala_ccode_identifier_new (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp123_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp124_;
					_vala_ccode_node_unref0 (_tmp123_);
					_g_free0 (_tmp121_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp125_;
					_tmp125_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp125_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp126_;
						ValaDelegate* _tmp127_;
						ValaDelegate* _tmp128_;
						ValaDelegate* _tmp129_;
						_tmp126_ = itype;
						_tmp127_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp128_ = _tmp127_;
						_tmp129_ = _vala_code_node_ref0 (_tmp128_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp129_;
					}
				}
			}
		}
	}
	_tmp130_ = g_direct_hash;
	_tmp131_ = g_direct_equal;
	_tmp132_ = g_direct_equal;
	_tmp133_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp130_, _tmp131_, _tmp132_);
	in_arg_map = _tmp133_;
	_tmp134_ = in_arg_map;
	_tmp135_ = _vala_map_ref0 (_tmp134_);
	out_arg_map = _tmp135_;
	_tmp137_ = m;
	if (_tmp137_ != NULL) {
		ValaMethod* _tmp138_;
		gboolean _tmp139_;
		gboolean _tmp140_;
		_tmp138_ = m;
		_tmp139_ = vala_method_get_coroutine (_tmp138_);
		_tmp140_ = _tmp139_;
		_tmp136_ = _tmp140_;
	} else {
		_tmp136_ = FALSE;
	}
	if (_tmp136_) {
		ValaMethod* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
		ValaCCodeIdentifier* _tmp144_;
		ValaCCodeIdentifier* _tmp145_;
		ValaCCodeFunctionCall* _tmp146_;
		ValaMethod* _tmp147_;
		gchar* _tmp148_;
		gchar* _tmp149_;
		ValaCCodeIdentifier* _tmp150_;
		ValaCCodeIdentifier* _tmp151_;
		ValaCCodeFunctionCall* _tmp152_;
		ValaMemberAccess* _tmp153_;
		ValaExpression* _tmp154_;
		ValaExpression* _tmp155_;
		gboolean _tmp222_ = FALSE;
		ValaMemberAccess* _tmp223_;
		const gchar* _tmp224_;
		const gchar* _tmp225_;
		_tmp141_ = m;
		_tmp142_ = vala_get_ccode_name ((ValaCodeNode*) _tmp141_);
		_tmp143_ = _tmp142_;
		_tmp144_ = vala_ccode_identifier_new (_tmp143_);
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp145_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp146_;
		_vala_ccode_node_unref0 (_tmp145_);
		_g_free0 (_tmp143_);
		_tmp147_ = m;
		_tmp148_ = vala_get_ccode_finish_name (_tmp147_);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_ccode_identifier_new (_tmp149_);
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp151_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp152_;
		_vala_ccode_node_unref0 (_tmp151_);
		_g_free0 (_tmp149_);
		_tmp153_ = ma;
		_tmp154_ = vala_member_access_get_inner (_tmp153_);
		_tmp155_ = _tmp154_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp155_, VALA_TYPE_BASE_ACCESS)) {
			ValaMethod* _tmp156_;
			ValaMethod* _tmp157_;
			ValaMethod* _tmp158_;
			_tmp156_ = m;
			_tmp157_ = vala_method_get_base_method (_tmp156_);
			_tmp158_ = _tmp157_;
			if (_tmp158_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp159_;
				ValaMethod* _tmp160_;
				ValaMethod* _tmp161_;
				ValaSymbol* _tmp162_;
				ValaSymbol* _tmp163_;
				ValaClass* _tmp164_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaClass* _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				ValaCCodeIdentifier* _tmp170_;
				ValaCCodeIdentifier* _tmp171_;
				ValaCCodeFunctionCall* _tmp172_;
				ValaCCodeFunctionCall* _tmp173_;
				ValaCCodeFunctionCall* _tmp174_;
				ValaClass* _tmp175_;
				ValaClass* _tmp176_;
				gchar* _tmp177_;
				gchar* _tmp178_;
				gchar* _tmp179_;
				gchar* _tmp180_;
				ValaCCodeIdentifier* _tmp181_;
				ValaCCodeIdentifier* _tmp182_;
				ValaCCodeFunctionCall* _tmp183_;
				ValaCCodeFunctionCall* _tmp184_;
				ValaMethod* _tmp185_;
				gchar* _tmp186_;
				gchar* _tmp187_;
				ValaCCodeMemberAccess* _tmp188_;
				ValaCCodeMemberAccess* _tmp189_;
				ValaCCodeFunctionCall* _tmp190_;
				ValaCCodeFunctionCall* _tmp191_;
				ValaMethod* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				ValaCCodeMemberAccess* _tmp195_;
				ValaCCodeMemberAccess* _tmp196_;
				_tmp159_ = m;
				_tmp160_ = vala_method_get_base_method (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, VALA_TYPE_CLASS, ValaClass));
				base_class = _tmp164_;
				_tmp165_ = base_class;
				_tmp166_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp165_, NULL);
				_tmp167_ = _tmp166_;
				_tmp168_ = g_strdup_printf ("%s_CLASS", _tmp167_);
				_tmp169_ = _tmp168_;
				_tmp170_ = vala_ccode_identifier_new (_tmp169_);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp171_);
				_tmp173_ = _tmp172_;
				_vala_ccode_node_unref0 (_tmp171_);
				_g_free0 (_tmp169_);
				_g_free0 (_tmp167_);
				vcast = _tmp173_;
				_tmp174_ = vcast;
				_tmp175_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp176_ = _tmp175_;
				_tmp177_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp176_, NULL);
				_tmp178_ = _tmp177_;
				_tmp179_ = g_strdup_printf ("%s_parent_class", _tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = vala_ccode_identifier_new (_tmp180_);
				_tmp182_ = _tmp181_;
				vala_ccode_function_call_add_argument (_tmp174_, (ValaCCodeExpression*) _tmp182_);
				_vala_ccode_node_unref0 (_tmp182_);
				_g_free0 (_tmp180_);
				_g_free0 (_tmp178_);
				_tmp183_ = async_call;
				_tmp184_ = vcast;
				_tmp185_ = m;
				_tmp186_ = vala_get_ccode_vfunc_name (_tmp185_);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp184_, _tmp187_);
				_tmp189_ = _tmp188_;
				vala_ccode_function_call_set_call (_tmp183_, (ValaCCodeExpression*) _tmp189_);
				_vala_ccode_node_unref0 (_tmp189_);
				_g_free0 (_tmp187_);
				_tmp190_ = finish_call;
				_tmp191_ = vcast;
				_tmp192_ = m;
				_tmp193_ = vala_get_ccode_finish_vfunc_name (_tmp192_);
				_tmp194_ = _tmp193_;
				_tmp195_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp191_, _tmp194_);
				_tmp196_ = _tmp195_;
				vala_ccode_function_call_set_call (_tmp190_, (ValaCCodeExpression*) _tmp196_);
				_vala_ccode_node_unref0 (_tmp196_);
				_g_free0 (_tmp194_);
				_vala_ccode_node_unref0 (vcast);
				_vala_code_node_unref0 (base_class);
			} else {
				ValaMethod* _tmp197_;
				ValaMethod* _tmp198_;
				ValaMethod* _tmp199_;
				_tmp197_ = m;
				_tmp198_ = vala_method_get_base_interface_method (_tmp197_);
				_tmp199_ = _tmp198_;
				if (_tmp199_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp200_;
					ValaMethod* _tmp201_;
					ValaMethod* _tmp202_;
					ValaSymbol* _tmp203_;
					ValaSymbol* _tmp204_;
					ValaInterface* _tmp205_;
					ValaCCodeExpression* vcast = NULL;
					ValaInterface* _tmp206_;
					ValaCCodeExpression* _tmp207_;
					ValaCCodeFunctionCall* _tmp208_;
					ValaCCodeExpression* _tmp209_;
					ValaMethod* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					ValaCCodeMemberAccess* _tmp213_;
					ValaCCodeMemberAccess* _tmp214_;
					ValaCCodeFunctionCall* _tmp215_;
					ValaCCodeExpression* _tmp216_;
					ValaMethod* _tmp217_;
					gchar* _tmp218_;
					gchar* _tmp219_;
					ValaCCodeMemberAccess* _tmp220_;
					ValaCCodeMemberAccess* _tmp221_;
					_tmp200_ = m;
					_tmp201_ = vala_method_get_base_interface_method (_tmp200_);
					_tmp202_ = _tmp201_;
					_tmp203_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp202_);
					_tmp204_ = _tmp203_;
					_tmp205_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_INTERFACE, ValaInterface));
					base_iface = _tmp205_;
					_tmp206_ = base_iface;
					_tmp207_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp206_);
					vcast = _tmp207_;
					_tmp208_ = async_call;
					_tmp209_ = vcast;
					_tmp210_ = m;
					_tmp211_ = vala_get_ccode_vfunc_name (_tmp210_);
					_tmp212_ = _tmp211_;
					_tmp213_ = vala_ccode_member_access_new_pointer (_tmp209_, _tmp212_);
					_tmp214_ = _tmp213_;
					vala_ccode_function_call_set_call (_tmp208_, (ValaCCodeExpression*) _tmp214_);
					_vala_ccode_node_unref0 (_tmp214_);
					_g_free0 (_tmp212_);
					_tmp215_ = finish_call;
					_tmp216_ = vcast;
					_tmp217_ = m;
					_tmp218_ = vala_get_ccode_finish_vfunc_name (_tmp217_);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_ccode_member_access_new_pointer (_tmp216_, _tmp219_);
					_tmp221_ = _tmp220_;
					vala_ccode_function_call_set_call (_tmp215_, (ValaCCodeExpression*) _tmp221_);
					_vala_ccode_node_unref0 (_tmp221_);
					_g_free0 (_tmp219_);
					_vala_ccode_node_unref0 (vcast);
					_vala_code_node_unref0 (base_iface);
				}
			}
		}
		_tmp223_ = ma;
		_tmp224_ = vala_member_access_get_member_name (_tmp223_);
		_tmp225_ = _tmp224_;
		if (g_strcmp0 (_tmp225_, "begin") == 0) {
			ValaMemberAccess* _tmp226_;
			ValaExpression* _tmp227_;
			ValaExpression* _tmp228_;
			ValaSymbol* _tmp229_;
			ValaSymbol* _tmp230_;
			ValaMemberAccess* _tmp231_;
			ValaSymbol* _tmp232_;
			ValaSymbol* _tmp233_;
			_tmp226_ = ma;
			_tmp227_ = vala_member_access_get_inner (_tmp226_);
			_tmp228_ = _tmp227_;
			_tmp229_ = vala_expression_get_symbol_reference (_tmp228_);
			_tmp230_ = _tmp229_;
			_tmp231_ = ma;
			_tmp232_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp231_);
			_tmp233_ = _tmp232_;
			_tmp222_ = _tmp230_ == _tmp233_;
		} else {
			_tmp222_ = FALSE;
		}
		if (_tmp222_) {
			ValaCCodeFunctionCall* _tmp234_;
			ValaCCodeFunctionCall* _tmp235_;
			ValaMethod* _tmp236_;
			ValaList* _tmp237_;
			_tmp234_ = async_call;
			_tmp235_ = _vala_ccode_node_ref0 (_tmp234_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp235_;
			_tmp236_ = m;
			_tmp237_ = vala_method_get_async_begin_parameters (_tmp236_);
			_vala_iterable_unref0 (params);
			params = _tmp237_;
		} else {
			gboolean _tmp238_ = FALSE;
			ValaMemberAccess* _tmp239_;
			const gchar* _tmp240_;
			const gchar* _tmp241_;
			_tmp239_ = ma;
			_tmp240_ = vala_member_access_get_member_name (_tmp239_);
			_tmp241_ = _tmp240_;
			if (g_strcmp0 (_tmp241_, "end") == 0) {
				ValaMemberAccess* _tmp242_;
				ValaExpression* _tmp243_;
				ValaExpression* _tmp244_;
				ValaSymbol* _tmp245_;
				ValaSymbol* _tmp246_;
				ValaMemberAccess* _tmp247_;
				ValaSymbol* _tmp248_;
				ValaSymbol* _tmp249_;
				_tmp242_ = ma;
				_tmp243_ = vala_member_access_get_inner (_tmp242_);
				_tmp244_ = _tmp243_;
				_tmp245_ = vala_expression_get_symbol_reference (_tmp244_);
				_tmp246_ = _tmp245_;
				_tmp247_ = ma;
				_tmp248_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp247_);
				_tmp249_ = _tmp248_;
				_tmp238_ = _tmp246_ == _tmp249_;
			} else {
				_tmp238_ = FALSE;
			}
			if (_tmp238_) {
				ValaCCodeFunctionCall* _tmp250_;
				ValaCCodeFunctionCall* _tmp251_;
				ValaMethod* _tmp252_;
				ValaList* _tmp253_;
				_tmp250_ = finish_call;
				_tmp251_ = _vala_ccode_node_ref0 (_tmp250_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp251_;
				_tmp252_ = m;
				_tmp253_ = vala_method_get_async_end_parameters (_tmp252_);
				_vala_iterable_unref0 (params);
				params = _tmp253_;
			} else {
				gboolean _tmp254_;
				gboolean _tmp255_;
				_tmp254_ = vala_method_call_get_is_yield_expression (expr);
				_tmp255_ = _tmp254_;
				if (!_tmp255_) {
					ValaCCodeFunctionCall* _tmp256_;
					ValaCCodeFunctionCall* _tmp257_;
					ValaMethod* _tmp258_;
					ValaList* _tmp259_;
					_tmp256_ = async_call;
					_tmp257_ = _vala_ccode_node_ref0 (_tmp256_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp257_;
					_tmp258_ = m;
					_tmp259_ = vala_method_get_async_begin_parameters (_tmp258_);
					_vala_iterable_unref0 (params);
					params = _tmp259_;
				} else {
					ValaCCodeFunctionCall* _tmp260_;
					ValaCCodeFunctionCall* _tmp261_;
					GHashFunc _tmp262_;
					GEqualFunc _tmp263_;
					GEqualFunc _tmp264_;
					ValaHashMap* _tmp265_;
					ValaHashMap* _tmp266_;
					ValaMethod* _tmp267_;
					ValaCCodeIdentifier* _tmp268_;
					ValaCCodeIdentifier* _tmp269_;
					ValaCCodeMemberAccess* _tmp270_;
					ValaCCodeMemberAccess* _tmp271_;
					_tmp260_ = finish_call;
					_tmp261_ = _vala_ccode_node_ref0 (_tmp260_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp261_;
					_tmp262_ = g_direct_hash;
					_tmp263_ = g_direct_equal;
					_tmp264_ = g_direct_equal;
					_tmp265_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp262_, _tmp263_, _tmp264_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp265_;
					_tmp266_ = out_arg_map;
					_tmp267_ = m;
					_tmp268_ = vala_ccode_identifier_new ("_data_");
					_tmp269_ = _tmp268_;
					_tmp270_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp269_, "_res_");
					_tmp271_ = _tmp270_;
					vala_map_set ((ValaMap*) _tmp266_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp267_), FALSE)), (ValaCCodeExpression*) _tmp271_);
					_vala_ccode_node_unref0 (_tmp271_);
					_vala_ccode_node_unref0 (_tmp269_);
				}
			}
		}
	}
	_tmp273_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp273_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp274_;
		ValaSymbol* _tmp275_;
		ValaSymbol* _tmp276_;
		_tmp274_ = m;
		_tmp275_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp274_);
		_tmp276_ = _tmp275_;
		_tmp272_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp276_, VALA_TYPE_CLASS);
	} else {
		_tmp272_ = FALSE;
	}
	if (_tmp272_) {
		ValaMethod* _tmp277_;
		ValaSymbol* _tmp278_;
		ValaSymbol* _tmp279_;
		gboolean _tmp280_;
		gboolean _tmp281_;
		ValaClass* _tmp285_;
		ValaClass* _tmp286_;
		gboolean _tmp287_;
		gboolean _tmp288_;
		_tmp277_ = m;
		_tmp278_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp277_);
		_tmp279_ = _tmp278_;
		_tmp280_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp279_, VALA_TYPE_CLASS, ValaClass));
		_tmp281_ = _tmp280_;
		if (!_tmp281_) {
			ValaCCodeFunctionCall* _tmp282_;
			ValaCCodeExpression* _tmp283_;
			ValaCCodeExpression* _tmp284_;
			_tmp282_ = ccall;
			_tmp283_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
			_tmp284_ = _tmp283_;
			vala_ccode_function_call_add_argument (_tmp282_, _tmp284_);
			_vala_ccode_node_unref0 (_tmp284_);
		}
		_tmp285_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp286_ = _tmp285_;
		_tmp287_ = vala_class_get_is_compact (_tmp286_);
		_tmp288_ = _tmp287_;
		if (!_tmp288_) {
			ValaClass* _tmp289_;
			ValaClass* _tmp290_;
			ValaMethod* _tmp291_;
			ValaSymbol* _tmp292_;
			ValaSymbol* _tmp293_;
			_tmp289_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp290_ = _tmp289_;
			_tmp291_ = m;
			_tmp292_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp291_);
			_tmp293_ = _tmp292_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp290_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp293_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp294_;
					ValaClass* _tmp295_;
					ValaList* _tmp296_;
					gint _base_type_size = 0;
					ValaList* _tmp297_;
					gint _tmp298_;
					gint _tmp299_;
					gint _base_type_index = 0;
					_tmp294_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp295_ = _tmp294_;
					_tmp296_ = vala_class_get_base_types (_tmp295_);
					_base_type_list = _tmp296_;
					_tmp297_ = _base_type_list;
					_tmp298_ = vala_collection_get_size ((ValaCollection*) _tmp297_);
					_tmp299_ = _tmp298_;
					_base_type_size = _tmp299_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp300_;
						gint _tmp301_;
						gint _tmp302_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp303_;
						gint _tmp304_;
						gpointer _tmp305_;
						ValaDataType* _tmp306_;
						ValaTypeSymbol* _tmp307_;
						ValaTypeSymbol* _tmp308_;
						_tmp300_ = _base_type_index;
						_base_type_index = _tmp300_ + 1;
						_tmp301_ = _base_type_index;
						_tmp302_ = _base_type_size;
						if (!(_tmp301_ < _tmp302_)) {
							break;
						}
						_tmp303_ = _base_type_list;
						_tmp304_ = _base_type_index;
						_tmp305_ = vala_list_get (_tmp303_, _tmp304_);
						base_type = (ValaDataType*) _tmp305_;
						_tmp306_ = base_type;
						_tmp307_ = vala_data_type_get_data_type (_tmp306_);
						_tmp308_ = _tmp307_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp308_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp309_;
							gchar* _tmp310_;
							gchar* _tmp311_;
							gboolean _tmp312_;
							ValaHashMap* _tmp317_;
							ValaDataType* _tmp318_;
							ValaList* _tmp319_;
							ValaList* _tmp320_;
							ValaList* _tmp321_;
							type_parameters = NULL;
							_tmp309_ = m;
							_tmp310_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp309_);
							_tmp311_ = _tmp310_;
							_tmp312_ = g_strcmp0 (_tmp311_, "g_object_new") == 0;
							_g_free0 (_tmp311_);
							if (_tmp312_) {
								ValaDataType* _tmp313_;
								ValaTypeSymbol* _tmp314_;
								ValaTypeSymbol* _tmp315_;
								ValaList* _tmp316_;
								_tmp313_ = base_type;
								_tmp314_ = vala_data_type_get_data_type (_tmp313_);
								_tmp315_ = _tmp314_;
								_tmp316_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp315_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp316_;
							}
							_tmp317_ = in_arg_map;
							_tmp318_ = base_type;
							_tmp319_ = vala_data_type_get_type_arguments (_tmp318_);
							_tmp320_ = _tmp319_;
							_tmp321_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp317_, _tmp320_, (ValaCodeNode*) expr, TRUE, _tmp321_);
							_vala_iterable_unref0 (_tmp320_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp322_;
				ValaSymbol* _tmp323_;
				ValaSymbol* _tmp324_;
				ValaClass* _tmp325_;
				type_param_index = 0;
				_tmp322_ = m;
				_tmp323_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp322_);
				_tmp324_ = _tmp323_;
				_tmp325_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp324_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp325_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp326_;
					ValaList* _tmp327_;
					gint _type_param_size = 0;
					ValaList* _tmp328_;
					gint _tmp329_;
					gint _tmp330_;
					gint _type_param_index = 0;
					_tmp326_ = cl;
					_tmp327_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp326_);
					_type_param_list = _tmp327_;
					_tmp328_ = _type_param_list;
					_tmp329_ = vala_collection_get_size ((ValaCollection*) _tmp328_);
					_tmp330_ = _tmp329_;
					_type_param_size = _tmp330_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp331_;
						gint _tmp332_;
						gint _tmp333_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp334_;
						gint _tmp335_;
						gpointer _tmp336_;
						ValaHashMap* _tmp337_;
						gint _tmp338_;
						ValaTypeParameter* _tmp339_;
						const gchar* _tmp340_;
						const gchar* _tmp341_;
						gchar* _tmp342_;
						gchar* _tmp343_;
						gchar* _tmp344_;
						gchar* _tmp345_;
						ValaCCodeIdentifier* _tmp346_;
						ValaCCodeIdentifier* _tmp347_;
						ValaHashMap* _tmp348_;
						gint _tmp349_;
						ValaTypeParameter* _tmp350_;
						const gchar* _tmp351_;
						const gchar* _tmp352_;
						gchar* _tmp353_;
						gchar* _tmp354_;
						gchar* _tmp355_;
						gchar* _tmp356_;
						ValaCCodeIdentifier* _tmp357_;
						ValaCCodeIdentifier* _tmp358_;
						ValaHashMap* _tmp359_;
						gint _tmp360_;
						ValaTypeParameter* _tmp361_;
						const gchar* _tmp362_;
						const gchar* _tmp363_;
						gchar* _tmp364_;
						gchar* _tmp365_;
						gchar* _tmp366_;
						gchar* _tmp367_;
						ValaCCodeIdentifier* _tmp368_;
						ValaCCodeIdentifier* _tmp369_;
						gint _tmp370_;
						_tmp331_ = _type_param_index;
						_type_param_index = _tmp331_ + 1;
						_tmp332_ = _type_param_index;
						_tmp333_ = _type_param_size;
						if (!(_tmp332_ < _tmp333_)) {
							break;
						}
						_tmp334_ = _type_param_list;
						_tmp335_ = _type_param_index;
						_tmp336_ = vala_list_get (_tmp334_, _tmp335_);
						type_param = (ValaTypeParameter*) _tmp336_;
						_tmp337_ = in_arg_map;
						_tmp338_ = type_param_index;
						_tmp339_ = type_param;
						_tmp340_ = vala_symbol_get_name ((ValaSymbol*) _tmp339_);
						_tmp341_ = _tmp340_;
						_tmp342_ = g_utf8_strdown (_tmp341_, (gssize) -1);
						_tmp343_ = _tmp342_;
						_tmp344_ = g_strdup_printf ("%s_type", _tmp343_);
						_tmp345_ = _tmp344_;
						_tmp346_ = vala_ccode_identifier_new (_tmp345_);
						_tmp347_ = _tmp346_;
						vala_map_set ((ValaMap*) _tmp337_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp338_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp347_);
						_vala_ccode_node_unref0 (_tmp347_);
						_g_free0 (_tmp345_);
						_g_free0 (_tmp343_);
						_tmp348_ = in_arg_map;
						_tmp349_ = type_param_index;
						_tmp350_ = type_param;
						_tmp351_ = vala_symbol_get_name ((ValaSymbol*) _tmp350_);
						_tmp352_ = _tmp351_;
						_tmp353_ = g_utf8_strdown (_tmp352_, (gssize) -1);
						_tmp354_ = _tmp353_;
						_tmp355_ = g_strdup_printf ("%s_dup_func", _tmp354_);
						_tmp356_ = _tmp355_;
						_tmp357_ = vala_ccode_identifier_new (_tmp356_);
						_tmp358_ = _tmp357_;
						vala_map_set ((ValaMap*) _tmp348_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp349_) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp358_);
						_vala_ccode_node_unref0 (_tmp358_);
						_g_free0 (_tmp356_);
						_g_free0 (_tmp354_);
						_tmp359_ = in_arg_map;
						_tmp360_ = type_param_index;
						_tmp361_ = type_param;
						_tmp362_ = vala_symbol_get_name ((ValaSymbol*) _tmp361_);
						_tmp363_ = _tmp362_;
						_tmp364_ = g_utf8_strdown (_tmp363_, (gssize) -1);
						_tmp365_ = _tmp364_;
						_tmp366_ = g_strdup_printf ("%s_destroy_func", _tmp365_);
						_tmp367_ = _tmp366_;
						_tmp368_ = vala_ccode_identifier_new (_tmp367_);
						_tmp369_ = _tmp368_;
						vala_map_set ((ValaMap*) _tmp359_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp360_) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp369_);
						_vala_ccode_node_unref0 (_tmp369_);
						_g_free0 (_tmp367_);
						_g_free0 (_tmp365_);
						_tmp370_ = type_param_index;
						type_param_index = _tmp370_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp371_;
			ValaClass* _tmp372_;
			ValaClass* _tmp373_;
			ValaClass* _tmp374_;
			ValaClass* _tmp375_;
			_tmp371_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp372_ = _tmp371_;
			_tmp373_ = vala_class_get_base_class (_tmp372_);
			_tmp374_ = _tmp373_;
			_tmp375_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp374_ == _tmp375_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp376_;
				ValaClass* _tmp377_;
				gchar* _tmp378_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp379_;
				ValaCCodeDeclaration* _tmp380_;
				ValaCCodeDeclaration* _tmp381_;
				const gchar* _tmp382_;
				const gchar* _tmp383_;
				const gchar* _tmp384_;
				const gchar* _tmp385_;
				gchar* _tmp386_;
				gchar* _tmp387_;
				ValaCCodeConstant* _tmp388_;
				ValaCCodeConstant* _tmp389_;
				ValaCCodeVariableDeclarator* _tmp390_;
				ValaCCodeVariableDeclarator* _tmp391_;
				ValaCCodeFunction* _tmp392_;
				ValaCCodeFunction* _tmp393_;
				ValaCCodeDeclaration* _tmp394_;
				ValaCCodeFunctionCall* _tmp395_;
				ValaCCodeIdentifier* _tmp396_;
				ValaCCodeIdentifier* _tmp397_;
				ValaCCodeUnaryExpression* _tmp398_;
				ValaCCodeUnaryExpression* _tmp399_;
				ValaCCodeCastExpression* _tmp400_;
				ValaCCodeCastExpression* _tmp401_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp402_;
				ValaCCodeIdentifier* _tmp403_;
				ValaCCodeFunctionCall* _tmp404_;
				ValaCCodeFunctionCall* _tmp405_;
				ValaCCodeFunctionCall* _tmp406_;
				ValaClass* _tmp407_;
				ValaClass* _tmp408_;
				gchar* _tmp409_;
				gchar* _tmp410_;
				ValaCCodeIdentifier* _tmp411_;
				ValaCCodeIdentifier* _tmp412_;
				ValaCCodeFunctionCall* _tmp413_;
				ValaCCodeFunctionCall* _tmp414_;
				_tmp376_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp377_ = _tmp376_;
				_tmp378_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp377_, NULL);
				class_prefix = _tmp378_;
				_tmp379_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp379_;
				_tmp380_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp380_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp381_ = funcs;
				_tmp382_ = class_prefix;
				_tmp383_ = class_prefix;
				_tmp384_ = class_prefix;
				_tmp385_ = class_prefix;
				_tmp386_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp382_, _tmp383_, _tmp384_, _tmp385_);
				_tmp387_ = _tmp386_;
				_tmp388_ = vala_ccode_constant_new (_tmp387_);
				_tmp389_ = _tmp388_;
				_tmp390_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp389_, NULL);
				_tmp391_ = _tmp390_;
				vala_ccode_declaration_add_declarator (_tmp381_, (ValaCCodeDeclarator*) _tmp391_);
				_vala_ccode_node_unref0 (_tmp391_);
				_vala_ccode_node_unref0 (_tmp389_);
				_g_free0 (_tmp387_);
				_tmp392_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp393_ = _tmp392_;
				_tmp394_ = funcs;
				vala_ccode_function_add_statement (_tmp393_, (ValaCCodeNode*) _tmp394_);
				_tmp395_ = ccall;
				_tmp396_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp397_ = _tmp396_;
				_tmp398_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp397_);
				_tmp399_ = _tmp398_;
				_tmp400_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp399_, "GSourceFuncs *");
				_tmp401_ = _tmp400_;
				vala_ccode_function_call_add_argument (_tmp395_, (ValaCCodeExpression*) _tmp401_);
				_vala_ccode_node_unref0 (_tmp401_);
				_vala_ccode_node_unref0 (_tmp399_);
				_vala_ccode_node_unref0 (_tmp397_);
				_tmp402_ = vala_ccode_identifier_new ("sizeof");
				_tmp403_ = _tmp402_;
				_tmp404_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp403_);
				_tmp405_ = _tmp404_;
				_vala_ccode_node_unref0 (_tmp403_);
				csizeof = _tmp405_;
				_tmp406_ = csizeof;
				_tmp407_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp408_ = _tmp407_;
				_tmp409_ = vala_get_ccode_name ((ValaCodeNode*) _tmp408_);
				_tmp410_ = _tmp409_;
				_tmp411_ = vala_ccode_identifier_new (_tmp410_);
				_tmp412_ = _tmp411_;
				vala_ccode_function_call_add_argument (_tmp406_, (ValaCCodeExpression*) _tmp412_);
				_vala_ccode_node_unref0 (_tmp412_);
				_g_free0 (_tmp410_);
				_tmp413_ = ccall;
				_tmp414_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp413_, (ValaCCodeExpression*) _tmp414_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp415_ = FALSE;
		ValaMethod* _tmp416_;
		_tmp416_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp416_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp417_;
			ValaSymbol* _tmp418_;
			ValaSymbol* _tmp419_;
			_tmp417_ = m;
			_tmp418_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp417_);
			_tmp419_ = _tmp418_;
			_tmp415_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp419_, VALA_TYPE_STRUCT);
		} else {
			_tmp415_ = FALSE;
		}
		if (_tmp415_) {
			ValaCCodeFunctionCall* _tmp420_;
			ValaCCodeExpression* _tmp421_;
			ValaCCodeExpression* _tmp422_;
			_tmp420_ = ccall;
			_tmp421_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp422_ = _tmp421_;
			vala_ccode_function_call_add_argument (_tmp420_, _tmp422_);
			_vala_ccode_node_unref0 (_tmp422_);
		} else {
			gboolean _tmp423_ = FALSE;
			gboolean _tmp424_ = FALSE;
			gboolean _tmp425_ = FALSE;
			gboolean _tmp426_ = FALSE;
			ValaMethod* _tmp427_;
			_tmp427_ = m;
			if (_tmp427_ != NULL) {
				ValaMethod* _tmp428_;
				ValaList* _tmp429_;
				ValaList* _tmp430_;
				gint _tmp431_;
				gint _tmp432_;
				_tmp428_ = m;
				_tmp429_ = vala_method_get_type_parameters (_tmp428_);
				_tmp430_ = _tmp429_;
				_tmp431_ = vala_collection_get_size ((ValaCollection*) _tmp430_);
				_tmp432_ = _tmp431_;
				_tmp426_ = _tmp432_ > 0;
				_vala_iterable_unref0 (_tmp430_);
			} else {
				_tmp426_ = FALSE;
			}
			if (_tmp426_) {
				ValaMethod* _tmp433_;
				_tmp433_ = m;
				_tmp425_ = !vala_get_ccode_has_generic_type_parameter (_tmp433_);
			} else {
				_tmp425_ = FALSE;
			}
			if (_tmp425_) {
				ValaMethod* _tmp434_;
				_tmp434_ = m;
				_tmp424_ = !vala_get_ccode_simple_generics (_tmp434_);
			} else {
				_tmp424_ = FALSE;
			}
			if (_tmp424_) {
				gboolean _tmp435_ = FALSE;
				ValaCCodeFunctionCall* _tmp436_;
				ValaCCodeFunctionCall* _tmp437_;
				_tmp436_ = ccall;
				_tmp437_ = finish_call;
				if (_tmp436_ != _tmp437_) {
					_tmp435_ = TRUE;
				} else {
					gboolean _tmp438_;
					gboolean _tmp439_;
					_tmp438_ = vala_method_call_get_is_yield_expression (expr);
					_tmp439_ = _tmp438_;
					_tmp435_ = _tmp439_;
				}
				_tmp423_ = _tmp435_;
			} else {
				_tmp423_ = FALSE;
			}
			if (_tmp423_) {
				ValaHashMap* _tmp440_;
				ValaMemberAccess* _tmp441_;
				ValaList* _tmp442_;
				ValaList* _tmp443_;
				_tmp440_ = in_arg_map;
				_tmp441_ = ma;
				_tmp442_ = vala_member_access_get_type_arguments (_tmp441_);
				_tmp443_ = _tmp442_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp440_, _tmp443_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp443_);
			}
		}
	}
	_tmp444_ = ccall;
	_tmp445_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp444_);
	ccall_expr = _tmp445_;
	_tmp446_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp446_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp447_;
		ValaExpression* _tmp448_;
		ValaExpression* _tmp449_;
		ValaDataType* _tmp450_;
		ValaDataType* _tmp451_;
		ValaArrayType* _tmp452_;
		ValaHashMap* _tmp453_;
		ValaArrayType* _tmp454_;
		ValaDataType* _tmp455_;
		ValaDataType* _tmp456_;
		gchar* _tmp457_;
		gchar* _tmp458_;
		ValaCCodeIdentifier* _tmp459_;
		ValaCCodeIdentifier* _tmp460_;
		_tmp447_ = ma;
		_tmp448_ = vala_member_access_get_inner (_tmp447_);
		_tmp449_ = _tmp448_;
		_tmp450_ = vala_expression_get_value_type (_tmp449_);
		_tmp451_ = _tmp450_;
		_tmp452_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp451_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp452_;
		_tmp453_ = in_arg_map;
		_tmp454_ = array_type;
		_tmp455_ = vala_array_type_get_element_type (_tmp454_);
		_tmp456_ = _tmp455_;
		_tmp457_ = vala_get_ccode_name ((ValaCodeNode*) _tmp456_);
		_tmp458_ = _tmp457_;
		_tmp459_ = vala_ccode_identifier_new (_tmp458_);
		_tmp460_ = _tmp459_;
		vala_map_set ((ValaMap*) _tmp453_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp460_);
		_vala_ccode_node_unref0 (_tmp460_);
		_g_free0 (_tmp458_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp461_;
		_tmp461_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp461_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp462_;
			_tmp462_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp462_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp463_;
				ValaExpression* _tmp464_;
				ValaExpression* _tmp465_;
				ValaTargetValue* _tmp466_;
				ValaTargetValue* _tmp467_;
				ValaTargetValue* _tmp468_;
				ValaTargetValue* _tmp469_;
				_tmp463_ = ma;
				_tmp464_ = vala_member_access_get_inner (_tmp463_);
				_tmp465_ = _tmp464_;
				_tmp466_ = vala_expression_get_target_value (_tmp465_);
				_tmp467_ = _tmp466_;
				_tmp468_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp467_, (ValaCodeNode*) expr);
				_tmp469_ = _tmp468_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp469_);
				_vala_target_value_unref0 (_tmp469_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp471_ = m;
	if (_tmp471_ != NULL) {
		ValaMethod* _tmp472_;
		gboolean _tmp473_;
		gboolean _tmp474_;
		_tmp472_ = m;
		_tmp473_ = vala_method_get_is_async_callback (_tmp472_);
		_tmp474_ = _tmp473_;
		_tmp470_ = _tmp474_;
	} else {
		_tmp470_ = FALSE;
	}
	if (_tmp470_) {
		ValaMethod* _tmp475_;
		ValaMethod* _tmp476_;
		gboolean _tmp477_;
		gboolean _tmp478_;
		ValaHashMap* _tmp492_;
		ValaMethod* _tmp493_;
		ValaCCodeExpression* _tmp494_;
		ValaHashMap* _tmp495_;
		ValaMethod* _tmp496_;
		ValaCCodeExpression* _tmp497_;
		_tmp475_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp476_ = _tmp475_;
		_tmp477_ = vala_method_get_closure (_tmp476_);
		_tmp478_ = _tmp477_;
		if (_tmp478_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp479_;
			ValaSymbol* _tmp480_;
			ValaSymbol* _tmp481_;
			ValaBlock* _tmp482_;
			ValaBlock* _tmp483_;
			ValaBlock* _tmp484_;
			ValaBlock* _tmp485_;
			gchar* _tmp486_;
			gchar* _tmp487_;
			ValaCCodeExpression* _tmp488_;
			ValaCCodeExpression* _tmp489_;
			ValaCCodeMemberAccess* _tmp490_;
			_tmp479_ = m;
			_tmp480_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp479_);
			_tmp481_ = _tmp480_;
			_tmp482_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp481_, VALA_TYPE_METHOD, ValaMethod));
			_tmp483_ = _tmp482_;
			_tmp484_ = _vala_code_node_ref0 (_tmp483_);
			block = _tmp484_;
			_tmp485_ = block;
			_tmp486_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp485_));
			_tmp487_ = _tmp486_;
			_tmp488_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp487_);
			_tmp489_ = _tmp488_;
			_tmp490_ = vala_ccode_member_access_new_pointer (_tmp489_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp490_;
			_vala_ccode_node_unref0 (_tmp489_);
			_g_free0 (_tmp487_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp491_;
			_tmp491_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp491_;
		}
		_tmp492_ = in_arg_map;
		_tmp493_ = m;
		_tmp494_ = instance;
		vala_map_set ((ValaMap*) _tmp492_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp493_), FALSE)), _tmp494_);
		_tmp495_ = out_arg_map;
		_tmp496_ = m;
		_tmp497_ = instance;
		vala_map_set ((ValaMap*) _tmp495_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp496_), FALSE)), _tmp497_);
	} else {
		gboolean _tmp498_ = FALSE;
		gboolean _tmp499_ = FALSE;
		ValaMethod* _tmp500_;
		_tmp500_ = m;
		if (_tmp500_ != NULL) {
			ValaMethod* _tmp501_;
			ValaMemberBinding _tmp502_;
			ValaMemberBinding _tmp503_;
			_tmp501_ = m;
			_tmp502_ = vala_method_get_binding (_tmp501_);
			_tmp503_ = _tmp502_;
			_tmp499_ = _tmp503_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp499_ = FALSE;
		}
		if (_tmp499_) {
			ValaMethod* _tmp504_;
			_tmp504_ = m;
			_tmp498_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp504_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp498_ = FALSE;
		}
		if (_tmp498_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp505_;
			ValaExpression* _tmp506_;
			ValaExpression* _tmp507_;
			ValaTargetValue* _tmp508_;
			ValaTargetValue* _tmp509_;
			ValaTargetValue* _tmp510_;
			gboolean _tmp511_ = FALSE;
			gboolean _tmp512_ = FALSE;
			ValaMemberAccess* _tmp513_;
			const gchar* _tmp514_;
			const gchar* _tmp515_;
			ValaTargetValue* _tmp537_;
			ValaCCodeExpression* _tmp538_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp539_;
			ValaSymbol* _tmp540_;
			ValaSymbol* _tmp541_;
			ValaStruct* _tmp542_;
			gboolean _tmp543_ = FALSE;
			ValaStruct* _tmp544_;
			gboolean _tmp553_;
			gboolean _tmp554_;
			_tmp505_ = ma;
			_tmp506_ = vala_member_access_get_inner (_tmp505_);
			_tmp507_ = _tmp506_;
			_tmp508_ = vala_expression_get_target_value (_tmp507_);
			_tmp509_ = _tmp508_;
			_tmp510_ = _vala_target_value_ref0 (_tmp509_);
			instance_value = _tmp510_;
			_tmp513_ = ma;
			_tmp514_ = vala_member_access_get_member_name (_tmp513_);
			_tmp515_ = _tmp514_;
			if (g_strcmp0 (_tmp515_, "begin") == 0) {
				_tmp512_ = TRUE;
			} else {
				ValaMemberAccess* _tmp516_;
				const gchar* _tmp517_;
				const gchar* _tmp518_;
				_tmp516_ = ma;
				_tmp517_ = vala_member_access_get_member_name (_tmp516_);
				_tmp518_ = _tmp517_;
				_tmp512_ = g_strcmp0 (_tmp518_, "end") == 0;
			}
			if (_tmp512_) {
				ValaMemberAccess* _tmp519_;
				ValaExpression* _tmp520_;
				ValaExpression* _tmp521_;
				ValaSymbol* _tmp522_;
				ValaSymbol* _tmp523_;
				ValaMemberAccess* _tmp524_;
				ValaSymbol* _tmp525_;
				ValaSymbol* _tmp526_;
				_tmp519_ = ma;
				_tmp520_ = vala_member_access_get_inner (_tmp519_);
				_tmp521_ = _tmp520_;
				_tmp522_ = vala_expression_get_symbol_reference (_tmp521_);
				_tmp523_ = _tmp522_;
				_tmp524_ = ma;
				_tmp525_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp524_);
				_tmp526_ = _tmp525_;
				_tmp511_ = _tmp523_ == _tmp526_;
			} else {
				_tmp511_ = FALSE;
			}
			if (_tmp511_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp527_;
				ValaExpression* _tmp528_;
				ValaExpression* _tmp529_;
				ValaMemberAccess* _tmp530_;
				ValaMemberAccess* _tmp531_;
				ValaExpression* _tmp532_;
				ValaExpression* _tmp533_;
				ValaTargetValue* _tmp534_;
				ValaTargetValue* _tmp535_;
				ValaTargetValue* _tmp536_;
				_tmp527_ = ma;
				_tmp528_ = vala_member_access_get_inner (_tmp527_);
				_tmp529_ = _tmp528_;
				_tmp530_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp529_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp530_;
				_tmp531_ = inner_ma;
				_tmp532_ = vala_member_access_get_inner (_tmp531_);
				_tmp533_ = _tmp532_;
				_tmp534_ = vala_expression_get_target_value (_tmp533_);
				_tmp535_ = _tmp534_;
				_tmp536_ = _vala_target_value_ref0 (_tmp535_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp536_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp537_ = instance_value;
			_tmp538_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp537_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp538_;
			_tmp539_ = m;
			_tmp540_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp539_);
			_tmp541_ = _tmp540_;
			_tmp542_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp541_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp541_) : NULL);
			st = _tmp542_;
			_tmp544_ = st;
			if (_tmp544_ != NULL) {
				ValaStruct* _tmp545_;
				_tmp545_ = st;
				_tmp543_ = !vala_struct_is_simple_type (_tmp545_);
			} else {
				_tmp543_ = FALSE;
			}
			if (_tmp543_) {
				ValaTargetValue* _tmp546_;
				ValaTargetValue* _tmp549_;
				ValaCCodeExpression* _tmp550_;
				ValaCCodeExpression* _tmp551_;
				ValaCCodeUnaryExpression* _tmp552_;
				_tmp546_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp546_)) {
					ValaTargetValue* _tmp547_;
					ValaTargetValue* _tmp548_;
					_tmp547_ = instance_value;
					_tmp548_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp547_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp548_;
				}
				_tmp549_ = instance_value;
				_tmp550_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp549_);
				_tmp551_ = _tmp550_;
				_tmp552_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp551_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp552_;
				_vala_ccode_node_unref0 (_tmp551_);
			}
			_tmp553_ = vala_method_call_get_is_yield_expression (expr);
			_tmp554_ = _tmp553_;
			if (_tmp554_) {
				ValaHashMap* _tmp555_;
				ValaMethod* _tmp556_;
				ValaCCodeExpression* _tmp557_;
				ValaMethod* _tmp558_;
				_tmp555_ = in_arg_map;
				_tmp556_ = m;
				_tmp557_ = instance;
				vala_map_set ((ValaMap*) _tmp555_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp556_), FALSE)), _tmp557_);
				_tmp558_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp558_)) {
					ValaHashMap* _tmp559_;
					ValaMethod* _tmp560_;
					ValaCCodeExpression* _tmp561_;
					_tmp559_ = out_arg_map;
					_tmp560_ = m;
					_tmp561_ = instance;
					vala_map_set ((ValaMap*) _tmp559_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp560_), FALSE)), _tmp561_);
				}
			} else {
				gboolean _tmp562_ = FALSE;
				ValaMemberAccess* _tmp563_;
				const gchar* _tmp564_;
				const gchar* _tmp565_;
				_tmp563_ = ma;
				_tmp564_ = vala_member_access_get_member_name (_tmp563_);
				_tmp565_ = _tmp564_;
				if (g_strcmp0 (_tmp565_, "end") != 0) {
					_tmp562_ = TRUE;
				} else {
					ValaMethod* _tmp566_;
					_tmp566_ = m;
					_tmp562_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp566_);
				}
				if (_tmp562_) {
					ValaHashMap* _tmp567_;
					ValaMethod* _tmp568_;
					ValaCCodeExpression* _tmp569_;
					ValaHashMap* _tmp570_;
					ValaMethod* _tmp571_;
					ValaCCodeExpression* _tmp572_;
					_tmp567_ = out_arg_map;
					_tmp568_ = m;
					_tmp569_ = instance;
					vala_map_set ((ValaMap*) _tmp567_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp568_), FALSE)), _tmp569_);
					_tmp570_ = in_arg_map;
					_tmp571_ = m;
					_tmp572_ = instance;
					vala_map_set ((ValaMap*) _tmp570_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp571_), FALSE)), _tmp572_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp573_ = FALSE;
			ValaMethod* _tmp574_;
			_tmp574_ = m;
			if (_tmp574_ != NULL) {
				ValaMethod* _tmp575_;
				ValaMemberBinding _tmp576_;
				ValaMemberBinding _tmp577_;
				_tmp575_ = m;
				_tmp576_ = vala_method_get_binding (_tmp575_);
				_tmp577_ = _tmp576_;
				_tmp573_ = _tmp577_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp573_ = FALSE;
			}
			if (_tmp573_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp578_;
				ValaSymbol* _tmp579_;
				ValaSymbol* _tmp580_;
				ValaClass* _tmp581_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp582_;
				gchar* _tmp583_;
				gchar* _tmp584_;
				gchar* _tmp585_;
				gchar* _tmp586_;
				ValaCCodeIdentifier* _tmp587_;
				ValaCCodeIdentifier* _tmp588_;
				ValaCCodeFunctionCall* _tmp589_;
				ValaCCodeFunctionCall* _tmp590_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp591_;
				ValaExpression* _tmp592_;
				ValaExpression* _tmp593_;
				ValaCCodeFunctionCall* _tmp619_;
				ValaCCodeExpression* _tmp620_;
				ValaHashMap* _tmp621_;
				ValaMethod* _tmp622_;
				ValaCCodeFunctionCall* _tmp623_;
				ValaHashMap* _tmp624_;
				ValaMethod* _tmp625_;
				ValaCCodeFunctionCall* _tmp626_;
				_tmp578_ = m;
				_tmp579_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp578_);
				_tmp580_ = _tmp579_;
				_tmp581_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp580_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp581_;
				_tmp582_ = cl;
				_tmp583_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp582_, NULL);
				_tmp584_ = _tmp583_;
				_tmp585_ = g_strconcat (_tmp584_, "_CLASS", NULL);
				_tmp586_ = _tmp585_;
				_tmp587_ = vala_ccode_identifier_new (_tmp586_);
				_tmp588_ = _tmp587_;
				_tmp589_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp588_);
				_tmp590_ = _tmp589_;
				_vala_ccode_node_unref0 (_tmp588_);
				_g_free0 (_tmp586_);
				_g_free0 (_tmp584_);
				cast = _tmp590_;
				_tmp591_ = ma;
				_tmp592_ = vala_member_access_get_inner (_tmp591_);
				_tmp593_ = _tmp592_;
				if (_tmp593_ == NULL) {
					ValaDataType* _tmp594_;
					ValaDataType* _tmp595_;
					gboolean _tmp596_;
					_tmp594_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp595_ = _tmp594_;
					_tmp596_ = _tmp595_ == NULL;
					_vala_code_node_unref0 (_tmp595_);
					if (_tmp596_) {
						ValaCCodeIdentifier* _tmp597_;
						_tmp597_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp597_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp598_;
						ValaCCodeIdentifier* _tmp599_;
						ValaCCodeFunctionCall* _tmp600_;
						ValaCCodeFunctionCall* _tmp601_;
						ValaCCodeFunctionCall* _tmp602_;
						ValaCCodeExpression* _tmp603_;
						ValaCCodeExpression* _tmp604_;
						ValaCCodeFunctionCall* _tmp605_;
						ValaCCodeExpression* _tmp606_;
						_tmp598_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp599_ = _tmp598_;
						_tmp600_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp599_);
						_tmp601_ = _tmp600_;
						_vala_ccode_node_unref0 (_tmp599_);
						k = _tmp601_;
						_tmp602_ = k;
						_tmp603_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp604_ = _tmp603_;
						vala_ccode_function_call_add_argument (_tmp602_, _tmp604_);
						_vala_ccode_node_unref0 (_tmp604_);
						_tmp605_ = k;
						_tmp606_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp605_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp606_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp607_;
					ValaCCodeIdentifier* _tmp608_;
					ValaCCodeFunctionCall* _tmp609_;
					ValaCCodeFunctionCall* _tmp610_;
					ValaCCodeFunctionCall* _tmp611_;
					ValaMemberAccess* _tmp612_;
					ValaExpression* _tmp613_;
					ValaExpression* _tmp614_;
					ValaCCodeExpression* _tmp615_;
					ValaCCodeExpression* _tmp616_;
					ValaCCodeFunctionCall* _tmp617_;
					ValaCCodeExpression* _tmp618_;
					_tmp607_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp608_ = _tmp607_;
					_tmp609_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp608_);
					_tmp610_ = _tmp609_;
					_vala_ccode_node_unref0 (_tmp608_);
					k = _tmp610_;
					_tmp611_ = k;
					_tmp612_ = ma;
					_tmp613_ = vala_member_access_get_inner (_tmp612_);
					_tmp614_ = _tmp613_;
					_tmp615_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp614_);
					_tmp616_ = _tmp615_;
					vala_ccode_function_call_add_argument (_tmp611_, _tmp616_);
					_vala_ccode_node_unref0 (_tmp616_);
					_tmp617_ = k;
					_tmp618_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp617_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp618_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp619_ = cast;
				_tmp620_ = klass;
				vala_ccode_function_call_add_argument (_tmp619_, _tmp620_);
				_tmp621_ = in_arg_map;
				_tmp622_ = m;
				_tmp623_ = cast;
				vala_map_set ((ValaMap*) _tmp621_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp622_), FALSE)), (ValaCCodeExpression*) _tmp623_);
				_tmp624_ = out_arg_map;
				_tmp625_ = m;
				_tmp626_ = cast;
				vala_map_set ((ValaMap*) _tmp624_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp625_), FALSE)), (ValaCCodeExpression*) _tmp626_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp628_ = m;
	if (_tmp628_ != NULL) {
		ValaMethod* _tmp629_;
		_tmp629_ = m;
		_tmp627_ = vala_get_ccode_has_generic_type_parameter (_tmp629_);
	} else {
		_tmp627_ = FALSE;
	}
	if (_tmp627_) {
		ValaMethod* _tmp630_;
		ValaList* _tmp631_;
		ValaList* _tmp632_;
		gint _tmp633_;
		gint _tmp634_;
		gboolean _tmp635_;
		_tmp630_ = m;
		_tmp631_ = vala_method_get_type_parameters (_tmp630_);
		_tmp632_ = _tmp631_;
		_tmp633_ = vala_collection_get_size ((ValaCollection*) _tmp632_);
		_tmp634_ = _tmp633_;
		_tmp635_ = _tmp634_ > 0;
		_vala_iterable_unref0 (_tmp632_);
		if (_tmp635_) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp636_;
				ValaList* _tmp637_;
				gint _type_arg_size = 0;
				ValaList* _tmp638_;
				gint _tmp639_;
				gint _tmp640_;
				gint _type_arg_index = 0;
				_tmp636_ = ma;
				_tmp637_ = vala_member_access_get_type_arguments (_tmp636_);
				_type_arg_list = _tmp637_;
				_tmp638_ = _type_arg_list;
				_tmp639_ = vala_collection_get_size ((ValaCollection*) _tmp638_);
				_tmp640_ = _tmp639_;
				_type_arg_size = _tmp640_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp641_;
					gint _tmp642_;
					gint _tmp643_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp644_;
					gint _tmp645_;
					gpointer _tmp646_;
					gboolean _tmp647_ = FALSE;
					gboolean _tmp648_ = FALSE;
					gboolean _tmp649_ = FALSE;
					ValaMethod* _tmp650_;
					ValaHashMap* _tmp658_;
					ValaMethod* _tmp659_;
					gint _tmp660_;
					ValaDataType* _tmp661_;
					gchar* _tmp662_;
					gchar* _tmp663_;
					ValaCCodeIdentifier* _tmp664_;
					ValaCCodeIdentifier* _tmp665_;
					gint _tmp666_;
					_tmp641_ = _type_arg_index;
					_type_arg_index = _tmp641_ + 1;
					_tmp642_ = _type_arg_index;
					_tmp643_ = _type_arg_size;
					if (!(_tmp642_ < _tmp643_)) {
						break;
					}
					_tmp644_ = _type_arg_list;
					_tmp645_ = _type_arg_index;
					_tmp646_ = vala_list_get (_tmp644_, _tmp645_);
					type_arg = (ValaDataType*) _tmp646_;
					_tmp650_ = m;
					if (vala_get_ccode_simple_generics (_tmp650_)) {
						ValaDataType* _tmp651_;
						_tmp651_ = type_arg;
						_tmp649_ = vala_data_type_is_real_struct_type (_tmp651_);
					} else {
						_tmp649_ = FALSE;
					}
					if (_tmp649_) {
						ValaDataType* _tmp652_;
						gboolean _tmp653_;
						gboolean _tmp654_;
						_tmp652_ = type_arg;
						_tmp653_ = vala_data_type_get_nullable (_tmp652_);
						_tmp654_ = _tmp653_;
						_tmp648_ = !_tmp654_;
					} else {
						_tmp648_ = FALSE;
					}
					if (_tmp648_) {
						ValaDataType* _tmp655_;
						_tmp655_ = type_arg;
						_tmp647_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp655_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp647_ = FALSE;
					}
					if (_tmp647_) {
						ValaDataType* _tmp656_;
						ValaPointerType* _tmp657_;
						_tmp656_ = type_arg;
						_tmp657_ = vala_pointer_type_new (_tmp656_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp657_;
					}
					_tmp658_ = in_arg_map;
					_tmp659_ = m;
					_tmp660_ = type_param_index;
					_tmp661_ = type_arg;
					_tmp662_ = vala_get_ccode_name ((ValaCodeNode*) _tmp661_);
					_tmp663_ = _tmp662_;
					_tmp664_ = vala_ccode_identifier_new (_tmp663_);
					_tmp665_ = _tmp664_;
					vala_map_set ((ValaMap*) _tmp658_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp659_) + (0.01 * _tmp660_), FALSE)), (ValaCCodeExpression*) _tmp665_);
					_vala_ccode_node_unref0 (_tmp665_);
					_g_free0 (_tmp663_);
					_tmp666_ = type_param_index;
					type_param_index = _tmp666_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp667_;
				ValaExpression* _tmp668_;
				ValaExpression* _tmp669_;
				ValaDataType* _tmp670_;
				ValaDataType* _tmp671_;
				ValaList* _tmp672_;
				gint _type_arg_size = 0;
				ValaList* _tmp673_;
				gint _tmp674_;
				gint _tmp675_;
				gint _type_arg_index = 0;
				_tmp667_ = ma;
				_tmp668_ = vala_member_access_get_inner (_tmp667_);
				_tmp669_ = _tmp668_;
				_tmp670_ = vala_expression_get_value_type (_tmp669_);
				_tmp671_ = _tmp670_;
				_tmp672_ = vala_data_type_get_type_arguments (_tmp671_);
				_type_arg_list = _tmp672_;
				_tmp673_ = _type_arg_list;
				_tmp674_ = vala_collection_get_size ((ValaCollection*) _tmp673_);
				_tmp675_ = _tmp674_;
				_type_arg_size = _tmp675_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp676_;
					gint _tmp677_;
					gint _tmp678_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp679_;
					gint _tmp680_;
					gpointer _tmp681_;
					ValaHashMap* _tmp682_;
					ValaMethod* _tmp683_;
					gint _tmp684_;
					ValaDataType* _tmp685_;
					gchar* _tmp686_;
					gchar* _tmp687_;
					ValaCCodeIdentifier* _tmp688_;
					ValaCCodeIdentifier* _tmp689_;
					gint _tmp690_;
					_tmp676_ = _type_arg_index;
					_type_arg_index = _tmp676_ + 1;
					_tmp677_ = _type_arg_index;
					_tmp678_ = _type_arg_size;
					if (!(_tmp677_ < _tmp678_)) {
						break;
					}
					_tmp679_ = _type_arg_list;
					_tmp680_ = _type_arg_index;
					_tmp681_ = vala_list_get (_tmp679_, _tmp680_);
					type_arg = (ValaDataType*) _tmp681_;
					_tmp682_ = in_arg_map;
					_tmp683_ = m;
					_tmp684_ = type_param_index;
					_tmp685_ = type_arg;
					_tmp686_ = vala_get_ccode_name ((ValaCodeNode*) _tmp685_);
					_tmp687_ = _tmp686_;
					_tmp688_ = vala_ccode_identifier_new (_tmp687_);
					_tmp689_ = _tmp688_;
					vala_map_set ((ValaMap*) _tmp682_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp683_) + (0.01 * _tmp684_), FALSE)), (ValaCCodeExpression*) _tmp689_);
					_vala_ccode_node_unref0 (_tmp689_);
					_g_free0 (_tmp687_);
					_tmp690_ = type_param_index;
					type_param_index = _tmp690_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp691_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp691_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp692_;
		ValaExpression* _tmp693_;
		ValaExpression* _tmp694_;
		ValaDataType* _tmp695_;
		ValaDataType* _tmp696_;
		ValaArrayType* _tmp697_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp698_;
		ValaCCodeIdentifier* _tmp699_;
		ValaCCodeFunctionCall* _tmp700_;
		ValaCCodeFunctionCall* _tmp701_;
		ValaCCodeFunctionCall* _tmp702_;
		ValaArrayType* _tmp703_;
		ValaDataType* _tmp704_;
		ValaDataType* _tmp705_;
		gchar* _tmp706_;
		gchar* _tmp707_;
		ValaCCodeIdentifier* _tmp708_;
		ValaCCodeIdentifier* _tmp709_;
		ValaHashMap* _tmp710_;
		ValaCCodeFunctionCall* _tmp711_;
		_tmp692_ = ma;
		_tmp693_ = vala_member_access_get_inner (_tmp692_);
		_tmp694_ = _tmp693_;
		_tmp695_ = vala_expression_get_value_type (_tmp694_);
		_tmp696_ = _tmp695_;
		_tmp697_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp696_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp697_;
		_tmp698_ = vala_ccode_identifier_new ("sizeof");
		_tmp699_ = _tmp698_;
		_tmp700_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp699_);
		_tmp701_ = _tmp700_;
		_vala_ccode_node_unref0 (_tmp699_);
		csizeof = _tmp701_;
		_tmp702_ = csizeof;
		_tmp703_ = array_type;
		_tmp704_ = vala_array_type_get_element_type (_tmp703_);
		_tmp705_ = _tmp704_;
		_tmp706_ = vala_get_ccode_name ((ValaCodeNode*) _tmp705_);
		_tmp707_ = _tmp706_;
		_tmp708_ = vala_ccode_identifier_new (_tmp707_);
		_tmp709_ = _tmp708_;
		vala_ccode_function_call_add_argument (_tmp702_, (ValaCCodeExpression*) _tmp709_);
		_vala_ccode_node_unref0 (_tmp709_);
		_g_free0 (_tmp707_);
		_tmp710_ = in_arg_map;
		_tmp711_ = csizeof;
		vala_map_set ((ValaMap*) _tmp710_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp711_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp712_;
		_tmp712_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp712_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp713_;
			ValaMethod* _tmp714_;
			ValaMethod* _tmp715_;
			gint param_nr = 0;
			ValaMethod* _tmp786_;
			ValaCCodeBaseModuleEmitContext* _tmp787_;
			_tmp713_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp714_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp713_, (ValaSymbol*) _tmp714_);
			_tmp715_ = m;
			vala_method_clear_parameters (_tmp715_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp716_;
				gint _arg_size = 0;
				ValaList* _tmp717_;
				gint _tmp718_;
				gint _tmp719_;
				gint _arg_index = 0;
				_tmp716_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp716_;
				_tmp717_ = _arg_list;
				_tmp718_ = vala_collection_get_size ((ValaCollection*) _tmp717_);
				_tmp719_ = _tmp718_;
				_arg_size = _tmp719_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp720_;
					gint _tmp721_;
					gint _tmp722_;
					ValaExpression* arg = NULL;
					ValaList* _tmp723_;
					gint _tmp724_;
					gpointer _tmp725_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp726_;
					ValaUnaryExpression* _tmp727_;
					gboolean _tmp728_ = FALSE;
					ValaUnaryExpression* _tmp729_;
					gint _tmp773_;
					_tmp720_ = _arg_index;
					_arg_index = _tmp720_ + 1;
					_tmp721_ = _arg_index;
					_tmp722_ = _arg_size;
					if (!(_tmp721_ < _tmp722_)) {
						break;
					}
					_tmp723_ = _arg_list;
					_tmp724_ = _arg_index;
					_tmp725_ = vala_list_get (_tmp723_, _tmp724_);
					arg = (ValaExpression*) _tmp725_;
					_tmp726_ = arg;
					_tmp727_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp726_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp726_) : NULL);
					unary = _tmp727_;
					_tmp729_ = unary;
					if (_tmp729_ != NULL) {
						ValaUnaryExpression* _tmp730_;
						ValaUnaryOperator _tmp731_;
						ValaUnaryOperator _tmp732_;
						_tmp730_ = unary;
						_tmp731_ = vala_unary_expression_get_operator (_tmp730_);
						_tmp732_ = _tmp731_;
						_tmp728_ = _tmp732_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp728_ = FALSE;
					}
					if (_tmp728_) {
						ValaParameter* param = NULL;
						gint _tmp733_;
						gchar* _tmp734_;
						gchar* _tmp735_;
						ValaUnaryExpression* _tmp736_;
						ValaExpression* _tmp737_;
						ValaExpression* _tmp738_;
						ValaDataType* _tmp739_;
						ValaDataType* _tmp740_;
						ValaParameter* _tmp741_;
						ValaParameter* _tmp742_;
						ValaParameter* _tmp743_;
						ValaMethod* _tmp744_;
						ValaParameter* _tmp745_;
						_tmp733_ = param_nr;
						_tmp734_ = g_strdup_printf ("param%d", _tmp733_);
						_tmp735_ = _tmp734_;
						_tmp736_ = unary;
						_tmp737_ = vala_unary_expression_get_inner (_tmp736_);
						_tmp738_ = _tmp737_;
						_tmp739_ = vala_expression_get_value_type (_tmp738_);
						_tmp740_ = _tmp739_;
						_tmp741_ = vala_parameter_new (_tmp735_, _tmp740_, NULL);
						_tmp742_ = _tmp741_;
						_g_free0 (_tmp735_);
						param = _tmp742_;
						_tmp743_ = param;
						vala_parameter_set_direction (_tmp743_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp744_ = m;
						_tmp745_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp744_, _tmp745_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp746_ = FALSE;
						ValaUnaryExpression* _tmp747_;
						_tmp747_ = unary;
						if (_tmp747_ != NULL) {
							ValaUnaryExpression* _tmp748_;
							ValaUnaryOperator _tmp749_;
							ValaUnaryOperator _tmp750_;
							_tmp748_ = unary;
							_tmp749_ = vala_unary_expression_get_operator (_tmp748_);
							_tmp750_ = _tmp749_;
							_tmp746_ = _tmp750_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp746_ = FALSE;
						}
						if (_tmp746_) {
							ValaParameter* param = NULL;
							gint _tmp751_;
							gchar* _tmp752_;
							gchar* _tmp753_;
							ValaUnaryExpression* _tmp754_;
							ValaExpression* _tmp755_;
							ValaExpression* _tmp756_;
							ValaDataType* _tmp757_;
							ValaDataType* _tmp758_;
							ValaParameter* _tmp759_;
							ValaParameter* _tmp760_;
							ValaParameter* _tmp761_;
							ValaMethod* _tmp762_;
							ValaParameter* _tmp763_;
							_tmp751_ = param_nr;
							_tmp752_ = g_strdup_printf ("param%d", _tmp751_);
							_tmp753_ = _tmp752_;
							_tmp754_ = unary;
							_tmp755_ = vala_unary_expression_get_inner (_tmp754_);
							_tmp756_ = _tmp755_;
							_tmp757_ = vala_expression_get_value_type (_tmp756_);
							_tmp758_ = _tmp757_;
							_tmp759_ = vala_parameter_new (_tmp753_, _tmp758_, NULL);
							_tmp760_ = _tmp759_;
							_g_free0 (_tmp753_);
							param = _tmp760_;
							_tmp761_ = param;
							vala_parameter_set_direction (_tmp761_, VALA_PARAMETER_DIRECTION_REF);
							_tmp762_ = m;
							_tmp763_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp762_, _tmp763_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp764_;
							gint _tmp765_;
							gchar* _tmp766_;
							gchar* _tmp767_;
							ValaExpression* _tmp768_;
							ValaDataType* _tmp769_;
							ValaDataType* _tmp770_;
							ValaParameter* _tmp771_;
							ValaParameter* _tmp772_;
							_tmp764_ = m;
							_tmp765_ = param_nr;
							_tmp766_ = g_strdup_printf ("param%d", _tmp765_);
							_tmp767_ = _tmp766_;
							_tmp768_ = arg;
							_tmp769_ = vala_expression_get_value_type (_tmp768_);
							_tmp770_ = _tmp769_;
							_tmp771_ = vala_parameter_new (_tmp767_, _tmp770_, NULL);
							_tmp772_ = _tmp771_;
							vala_callable_add_parameter ((ValaCallable*) _tmp764_, _tmp772_);
							_vala_code_node_unref0 (_tmp772_);
							_g_free0 (_tmp767_);
						}
					}
					_tmp773_ = param_nr;
					param_nr = _tmp773_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp774_;
				ValaList* _tmp775_;
				gint _param_size = 0;
				ValaList* _tmp776_;
				gint _tmp777_;
				gint _tmp778_;
				gint _param_index = 0;
				_tmp774_ = m;
				_tmp775_ = vala_callable_get_parameters ((ValaCallable*) _tmp774_);
				_param_list = _tmp775_;
				_tmp776_ = _param_list;
				_tmp777_ = vala_collection_get_size ((ValaCollection*) _tmp776_);
				_tmp778_ = _tmp777_;
				_param_size = _tmp778_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp779_;
					gint _tmp780_;
					gint _tmp781_;
					ValaParameter* param = NULL;
					ValaList* _tmp782_;
					gint _tmp783_;
					gpointer _tmp784_;
					ValaParameter* _tmp785_;
					_tmp779_ = _param_index;
					_param_index = _tmp779_ + 1;
					_tmp780_ = _param_index;
					_tmp781_ = _param_size;
					if (!(_tmp780_ < _tmp781_)) {
						break;
					}
					_tmp782_ = _param_list;
					_tmp783_ = _param_index;
					_tmp784_ = vala_list_get (_tmp782_, _tmp783_);
					param = (ValaParameter*) _tmp784_;
					_tmp785_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp785_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp786_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp786_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp787_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp787_);
		} else {
			gboolean _tmp788_ = FALSE;
			ValaMethod* _tmp789_;
			_tmp789_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp789_, VALA_TYPE_CREATION_METHOD)) {
				ValaMethod* _tmp790_;
				ValaSymbol* _tmp791_;
				ValaSymbol* _tmp792_;
				_tmp790_ = m;
				_tmp791_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp790_);
				_tmp792_ = _tmp791_;
				_tmp788_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp792_, VALA_TYPE_CLASS);
			} else {
				_tmp788_ = FALSE;
			}
			if (_tmp788_) {
				ValaCCodeFunction* _tmp793_;
				ValaCCodeFunction* _tmp794_;
				ValaCCodeExpression* _tmp795_;
				ValaCCodeExpression* _tmp796_;
				ValaCCodeFunctionCall* _tmp797_;
				ValaClass* _tmp798_;
				ValaClass* _tmp799_;
				gchar* _tmp800_;
				gchar* _tmp801_;
				gchar* _tmp802_;
				gchar* _tmp803_;
				ValaCCodeCastExpression* _tmp804_;
				ValaCCodeCastExpression* _tmp805_;
				ValaMethod* _tmp806_;
				ValaMethod* _tmp807_;
				ValaBlock* _tmp808_;
				ValaBlock* _tmp809_;
				gboolean _tmp810_;
				gboolean _tmp811_;
				gboolean _tmp838_ = FALSE;
				ValaClass* _tmp839_;
				ValaClass* _tmp840_;
				gboolean _tmp841_;
				gboolean _tmp842_;
				_tmp793_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp794_ = _tmp793_;
				_tmp795_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp796_ = _tmp795_;
				_tmp797_ = ccall;
				_tmp798_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp799_ = _tmp798_;
				_tmp800_ = vala_get_ccode_name ((ValaCodeNode*) _tmp799_);
				_tmp801_ = _tmp800_;
				_tmp802_ = g_strconcat (_tmp801_, "*", NULL);
				_tmp803_ = _tmp802_;
				_tmp804_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp797_, _tmp803_);
				_tmp805_ = _tmp804_;
				vala_ccode_function_add_assignment (_tmp794_, _tmp796_, (ValaCCodeExpression*) _tmp805_);
				_vala_ccode_node_unref0 (_tmp805_);
				_g_free0 (_tmp803_);
				_g_free0 (_tmp801_);
				_vala_ccode_node_unref0 (_tmp796_);
				_tmp806_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp807_ = _tmp806_;
				_tmp808_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp807_);
				_tmp809_ = _tmp808_;
				_tmp810_ = vala_block_get_captured (_tmp809_);
				_tmp811_ = _tmp810_;
				if (_tmp811_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp812_;
					ValaClass* _tmp813_;
					ValaObjectType* _tmp814_;
					ValaObjectType* _tmp815_;
					ValaSourceReference* _tmp816_;
					ValaSourceReference* _tmp817_;
					ValaCCodeExpression* _tmp818_;
					ValaCCodeExpression* _tmp819_;
					ValaCCodeFunctionCall* _tmp820_;
					ValaCCodeFunctionCall* _tmp821_;
					ValaCCodeFunctionCall* _tmp822_;
					ValaCCodeExpression* _tmp823_;
					ValaCCodeExpression* _tmp824_;
					ValaCCodeFunction* _tmp825_;
					ValaCCodeFunction* _tmp826_;
					ValaMethod* _tmp827_;
					ValaMethod* _tmp828_;
					ValaBlock* _tmp829_;
					ValaBlock* _tmp830_;
					gchar* _tmp831_;
					gchar* _tmp832_;
					ValaCCodeExpression* _tmp833_;
					ValaCCodeExpression* _tmp834_;
					ValaCCodeMemberAccess* _tmp835_;
					ValaCCodeMemberAccess* _tmp836_;
					ValaCCodeFunctionCall* _tmp837_;
					_tmp812_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp813_ = _tmp812_;
					_tmp814_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp813_);
					_tmp815_ = _tmp814_;
					_tmp816_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp817_ = _tmp816_;
					_tmp818_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp815_, _tmp817_, FALSE);
					_tmp819_ = _tmp818_;
					_tmp820_ = vala_ccode_function_call_new (_tmp819_);
					_tmp821_ = _tmp820_;
					_vala_ccode_node_unref0 (_tmp819_);
					_vala_code_node_unref0 (_tmp815_);
					ref_call = _tmp821_;
					_tmp822_ = ref_call;
					_tmp823_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp824_ = _tmp823_;
					vala_ccode_function_call_add_argument (_tmp822_, _tmp824_);
					_vala_ccode_node_unref0 (_tmp824_);
					_tmp825_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp826_ = _tmp825_;
					_tmp827_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp828_ = _tmp827_;
					_tmp829_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp828_);
					_tmp830_ = _tmp829_;
					_tmp831_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp830_));
					_tmp832_ = _tmp831_;
					_tmp833_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp832_);
					_tmp834_ = _tmp833_;
					_tmp835_ = vala_ccode_member_access_new_pointer (_tmp834_, "self");
					_tmp836_ = _tmp835_;
					_tmp837_ = ref_call;
					vala_ccode_function_add_assignment (_tmp826_, (ValaCCodeExpression*) _tmp836_, (ValaCCodeExpression*) _tmp837_);
					_vala_ccode_node_unref0 (_tmp836_);
					_vala_ccode_node_unref0 (_tmp834_);
					_g_free0 (_tmp832_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp839_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp840_ = _tmp839_;
				_tmp841_ = vala_class_get_is_compact (_tmp840_);
				_tmp842_ = _tmp841_;
				if (!_tmp842_) {
					ValaClass* _tmp843_;
					ValaClass* _tmp844_;
					ValaList* _tmp845_;
					ValaList* _tmp846_;
					gint _tmp847_;
					gint _tmp848_;
					_tmp843_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp844_ = _tmp843_;
					_tmp845_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp844_);
					_tmp846_ = _tmp845_;
					_tmp847_ = vala_collection_get_size ((ValaCollection*) _tmp846_);
					_tmp848_ = _tmp847_;
					_tmp838_ = _tmp848_ > 0;
					_vala_iterable_unref0 (_tmp846_);
				} else {
					_tmp838_ = FALSE;
				}
				if (_tmp838_) {
					gchar** suffices = NULL;
					gchar* _tmp849_;
					gchar* _tmp850_;
					gchar* _tmp851_;
					gchar** _tmp852_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp849_ = g_strdup ("type");
					_tmp850_ = g_strdup ("dup_func");
					_tmp851_ = g_strdup ("destroy_func");
					_tmp852_ = g_new0 (gchar*, 3 + 1);
					_tmp852_[0] = _tmp849_;
					_tmp852_[1] = _tmp850_;
					_tmp852_[2] = _tmp851_;
					suffices = _tmp852_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp853_;
						ValaClass* _tmp854_;
						ValaList* _tmp855_;
						gint _type_param_size = 0;
						ValaList* _tmp856_;
						gint _tmp857_;
						gint _tmp858_;
						gint _type_param_index = 0;
						_tmp853_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp854_ = _tmp853_;
						_tmp855_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp854_);
						_type_param_list = _tmp855_;
						_tmp856_ = _type_param_list;
						_tmp857_ = vala_collection_get_size ((ValaCollection*) _tmp856_);
						_tmp858_ = _tmp857_;
						_type_param_size = _tmp858_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp859_;
							gint _tmp860_;
							gint _tmp861_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp862_;
							gint _tmp863_;
							gpointer _tmp864_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp865_;
							ValaCCodeIdentifier* _tmp866_;
							ValaCCodeMemberAccess* _tmp867_;
							ValaCCodeMemberAccess* _tmp868_;
							gchar** _tmp869_;
							gint _tmp869__length1;
							_tmp859_ = _type_param_index;
							_type_param_index = _tmp859_ + 1;
							_tmp860_ = _type_param_index;
							_tmp861_ = _type_param_size;
							if (!(_tmp860_ < _tmp861_)) {
								break;
							}
							_tmp862_ = _type_param_list;
							_tmp863_ = _type_param_index;
							_tmp864_ = vala_list_get (_tmp862_, _tmp863_);
							type_param = (ValaTypeParameter*) _tmp864_;
							_tmp865_ = vala_ccode_identifier_new ("self");
							_tmp866_ = _tmp865_;
							_tmp867_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp866_, "priv");
							_tmp868_ = _tmp867_;
							_vala_ccode_node_unref0 (_tmp866_);
							priv_access = _tmp868_;
							_tmp869_ = suffices;
							_tmp869__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp869_;
								suffix_collection_length1 = _tmp869__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp870_;
									gchar* suffix = NULL;
									_tmp870_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp870_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp871_;
										const gchar* _tmp872_;
										const gchar* _tmp873_;
										gchar* _tmp874_;
										gchar* _tmp875_;
										const gchar* _tmp876_;
										gchar* _tmp877_;
										gchar* _tmp878_;
										ValaCCodeIdentifier* _tmp879_;
										ValaCCodeIdentifier* _tmp880_;
										ValaCCodeFunction* _tmp881_;
										ValaCCodeFunction* _tmp882_;
										ValaCCodeMemberAccess* _tmp883_;
										ValaCCodeIdentifier* _tmp884_;
										const gchar* _tmp885_;
										const gchar* _tmp886_;
										ValaCCodeMemberAccess* _tmp887_;
										ValaCCodeMemberAccess* _tmp888_;
										ValaCCodeIdentifier* _tmp889_;
										_tmp871_ = type_param;
										_tmp872_ = vala_symbol_get_name ((ValaSymbol*) _tmp871_);
										_tmp873_ = _tmp872_;
										_tmp874_ = g_utf8_strdown (_tmp873_, (gssize) -1);
										_tmp875_ = _tmp874_;
										_tmp876_ = suffix;
										_tmp877_ = g_strdup_printf ("%s_%s", _tmp875_, _tmp876_);
										_tmp878_ = _tmp877_;
										_tmp879_ = vala_ccode_identifier_new (_tmp878_);
										_tmp880_ = _tmp879_;
										_g_free0 (_tmp878_);
										_g_free0 (_tmp875_);
										param_name = _tmp880_;
										_tmp881_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp882_ = _tmp881_;
										_tmp883_ = priv_access;
										_tmp884_ = param_name;
										_tmp885_ = vala_ccode_identifier_get_name (_tmp884_);
										_tmp886_ = _tmp885_;
										_tmp887_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp883_, _tmp886_);
										_tmp888_ = _tmp887_;
										_tmp889_ = param_name;
										vala_ccode_function_add_assignment (_tmp882_, (ValaCCodeExpression*) _tmp888_, (ValaCCodeExpression*) _tmp889_);
										_vala_ccode_node_unref0 (_tmp888_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp890_ = params;
	_tmp891_ = vala_iterable_iterator ((ValaIterable*) _tmp890_);
	params_it = _tmp891_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp892_;
		gint _arg_size = 0;
		ValaList* _tmp893_;
		gint _tmp894_;
		gint _tmp895_;
		gint _arg_index = 0;
		_tmp892_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp892_;
		_tmp893_ = _arg_list;
		_tmp894_ = vala_collection_get_size ((ValaCollection*) _tmp893_);
		_tmp895_ = _tmp894_;
		_arg_size = _tmp895_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp896_;
			gint _tmp897_;
			gint _tmp898_;
			ValaExpression* arg = NULL;
			ValaList* _tmp899_;
			gint _tmp900_;
			gpointer _tmp901_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp902_;
			ValaCCodeExpression* _tmp903_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp904_;
			ValaHashMap* _tmp905_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp906_;
			gboolean _tmp916_ = FALSE;
			ValaParameter* _tmp917_;
			gdouble _tmp1255_ = 0.0;
			ValaParameter* _tmp1256_;
			gboolean _tmp1259_;
			ValaHashMap* _tmp1260_;
			gint _tmp1261_;
			ValaCCodeExpression* _tmp1262_;
			gboolean _tmp1263_ = FALSE;
			ValaExpression* _tmp1264_;
			gint _tmp1284_;
			_tmp896_ = _arg_index;
			_arg_index = _tmp896_ + 1;
			_tmp897_ = _arg_index;
			_tmp898_ = _arg_size;
			if (!(_tmp897_ < _tmp898_)) {
				break;
			}
			_tmp899_ = _arg_list;
			_tmp900_ = _arg_index;
			_tmp901_ = vala_list_get (_tmp899_, _tmp900_);
			arg = (ValaExpression*) _tmp901_;
			_tmp902_ = arg;
			_tmp903_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp902_);
			cexpr = _tmp903_;
			_tmp904_ = in_arg_map;
			_tmp905_ = _vala_map_ref0 (_tmp904_);
			carg_map = _tmp905_;
			param = NULL;
			_tmp906_ = params_it;
			if (vala_iterator_next (_tmp906_)) {
				ValaIterator* _tmp907_;
				gpointer _tmp908_;
				gboolean _tmp909_ = FALSE;
				ValaParameter* _tmp910_;
				gboolean _tmp911_;
				gboolean _tmp912_;
				_tmp907_ = params_it;
				_tmp908_ = vala_iterator_get (_tmp907_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp908_;
				_tmp910_ = param;
				_tmp911_ = vala_parameter_get_params_array (_tmp910_);
				_tmp912_ = _tmp911_;
				if (_tmp912_) {
					_tmp909_ = TRUE;
				} else {
					ValaParameter* _tmp913_;
					gboolean _tmp914_;
					gboolean _tmp915_;
					_tmp913_ = param;
					_tmp914_ = vala_parameter_get_ellipsis (_tmp913_);
					_tmp915_ = _tmp914_;
					_tmp909_ = _tmp915_;
				}
				ellipsis = _tmp909_;
			}
			_tmp917_ = param;
			if (_tmp917_ != NULL) {
				gboolean _tmp918_;
				_tmp918_ = ellipsis;
				_tmp916_ = !_tmp918_;
			} else {
				_tmp916_ = FALSE;
			}
			if (_tmp916_) {
				ValaParameter* _tmp919_;
				ValaParameterDirection _tmp920_;
				ValaParameterDirection _tmp921_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp924_;
				ValaUnaryExpression* _tmp925_;
				gboolean _tmp926_ = FALSE;
				ValaUnaryExpression* _tmp927_;
				ValaParameter* _tmp1205_;
				gchar* _tmp1206_;
				gchar* _tmp1207_;
				gboolean _tmp1208_;
				_tmp919_ = param;
				_tmp920_ = vala_parameter_get_direction (_tmp919_);
				_tmp921_ = _tmp920_;
				if (_tmp921_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp922_;
					ValaHashMap* _tmp923_;
					_tmp922_ = out_arg_map;
					_tmp923_ = _vala_map_ref0 (_tmp922_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp923_;
				}
				_tmp924_ = arg;
				_tmp925_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp924_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp924_) : NULL);
				unary = _tmp925_;
				_tmp927_ = unary;
				if (_tmp927_ == NULL) {
					_tmp926_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp928_;
					ValaUnaryOperator _tmp929_;
					ValaUnaryOperator _tmp930_;
					_tmp928_ = unary;
					_tmp929_ = vala_unary_expression_get_operator (_tmp928_);
					_tmp930_ = _tmp929_;
					_tmp926_ = _tmp930_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp926_) {
					gboolean _tmp931_ = FALSE;
					gboolean _tmp932_ = FALSE;
					ValaParameter* _tmp933_;
					ValaParameter* _tmp1075_;
					ValaExpression* _tmp1076_;
					ValaCCodeExpression* _tmp1077_;
					ValaCCodeExpression* _tmp1078_;
					_tmp933_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp933_)) {
						ValaParameter* _tmp934_;
						ValaDataType* _tmp935_;
						ValaDataType* _tmp936_;
						_tmp934_ = param;
						_tmp935_ = vala_variable_get_variable_type ((ValaVariable*) _tmp934_);
						_tmp936_ = _tmp935_;
						_tmp932_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp936_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp932_ = FALSE;
					}
					if (_tmp932_) {
						ValaParameter* _tmp937_;
						ValaDataType* _tmp938_;
						ValaDataType* _tmp939_;
						gboolean _tmp940_;
						gboolean _tmp941_;
						_tmp937_ = param;
						_tmp938_ = vala_variable_get_variable_type ((ValaVariable*) _tmp937_);
						_tmp939_ = _tmp938_;
						_tmp940_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp939_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp941_ = _tmp940_;
						_tmp931_ = !_tmp941_;
					} else {
						_tmp931_ = FALSE;
					}
					if (_tmp931_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp942_;
						ValaDataType* _tmp943_;
						ValaDataType* _tmp944_;
						ValaArrayType* _tmp945_;
						_tmp942_ = param;
						_tmp943_ = vala_variable_get_variable_type ((ValaVariable*) _tmp942_);
						_tmp944_ = _tmp943_;
						_tmp945_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp944_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp945_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp946_ = FALSE;
								_tmp946_ = TRUE;
								while (TRUE) {
									gint _tmp948_;
									ValaArrayType* _tmp949_;
									gint _tmp950_;
									gint _tmp951_;
									ValaCCodeExpression* array_length_expr = NULL;
									ValaParameter* _tmp952_;
									gchar* _tmp953_;
									gchar* _tmp954_;
									gboolean _tmp955_;
									ValaHashMap* _tmp974_;
									ValaParameter* _tmp975_;
									gint _tmp976_;
									ValaCCodeExpression* _tmp977_;
									if (!_tmp946_) {
										gint _tmp947_;
										_tmp947_ = dim;
										dim = _tmp947_ + 1;
									}
									_tmp946_ = FALSE;
									_tmp948_ = dim;
									_tmp949_ = array_type;
									_tmp950_ = vala_array_type_get_rank (_tmp949_);
									_tmp951_ = _tmp950_;
									if (!(_tmp948_ <= _tmp951_)) {
										break;
									}
									array_length_expr = NULL;
									_tmp952_ = param;
									_tmp953_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp952_);
									_tmp954_ = _tmp953_;
									_tmp955_ = _tmp954_ != NULL;
									_g_free0 (_tmp954_);
									if (_tmp955_) {
										gchar* length_ctype = NULL;
										ValaParameter* _tmp956_;
										gchar* _tmp957_;
										gboolean _tmp958_ = FALSE;
										ValaUnaryExpression* _tmp959_;
										ValaExpression* _tmp965_;
										gint _tmp966_;
										ValaCCodeExpression* _tmp967_;
										ValaCCodeExpression* _tmp968_;
										const gchar* _tmp969_;
										ValaCCodeCastExpression* _tmp970_;
										_tmp956_ = param;
										_tmp957_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp956_);
										length_ctype = _tmp957_;
										_tmp959_ = unary;
										if (_tmp959_ != NULL) {
											ValaUnaryExpression* _tmp960_;
											ValaUnaryOperator _tmp961_;
											ValaUnaryOperator _tmp962_;
											_tmp960_ = unary;
											_tmp961_ = vala_unary_expression_get_operator (_tmp960_);
											_tmp962_ = _tmp961_;
											_tmp958_ = _tmp962_ == VALA_UNARY_OPERATOR_REF;
										} else {
											_tmp958_ = FALSE;
										}
										if (_tmp958_) {
											const gchar* _tmp963_;
											gchar* _tmp964_;
											_tmp963_ = length_ctype;
											_tmp964_ = g_strdup_printf ("%s*", _tmp963_);
											_g_free0 (length_ctype);
											length_ctype = _tmp964_;
										}
										_tmp965_ = arg;
										_tmp966_ = dim;
										_tmp967_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp965_, _tmp966_);
										_tmp968_ = _tmp967_;
										_tmp969_ = length_ctype;
										_tmp970_ = vala_ccode_cast_expression_new (_tmp968_, _tmp969_);
										_vala_ccode_node_unref0 (array_length_expr);
										array_length_expr = (ValaCCodeExpression*) _tmp970_;
										_vala_ccode_node_unref0 (_tmp968_);
										_g_free0 (length_ctype);
									} else {
										ValaExpression* _tmp971_;
										gint _tmp972_;
										ValaCCodeExpression* _tmp973_;
										_tmp971_ = arg;
										_tmp972_ = dim;
										_tmp973_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp971_, _tmp972_);
										_vala_ccode_node_unref0 (array_length_expr);
										array_length_expr = _tmp973_;
									}
									_tmp974_ = carg_map;
									_tmp975_ = param;
									_tmp976_ = dim;
									_tmp977_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp974_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp975_) + (0.01 * _tmp976_), FALSE)), _tmp977_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp978_;
						ValaDataType* _tmp979_;
						ValaDataType* _tmp980_;
						_tmp978_ = param;
						_tmp979_ = vala_variable_get_variable_type ((ValaVariable*) _tmp978_);
						_tmp980_ = _tmp979_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp980_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp981_;
							ValaDataType* _tmp982_;
							ValaDataType* _tmp983_;
							ValaDelegateType* _tmp984_;
							ValaDelegateType* _tmp985_;
							ValaDelegate* _tmp986_;
							ValaDelegate* _tmp987_;
							gboolean _tmp988_;
							gboolean _tmp989_;
							_tmp981_ = param;
							_tmp982_ = vala_variable_get_variable_type ((ValaVariable*) _tmp981_);
							_tmp983_ = _tmp982_;
							_tmp984_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp983_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp984_;
							_tmp985_ = deleg_type;
							_tmp986_ = vala_delegate_type_get_delegate_symbol (_tmp985_);
							_tmp987_ = _tmp986_;
							_tmp988_ = vala_delegate_get_has_target (_tmp987_);
							_tmp989_ = _tmp988_;
							if (_tmp989_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp990_;
								ValaCCodeExpression* _tmp991_ = NULL;
								ValaCCodeExpression* _tmp992_;
								ValaCCodeExpression* _tmp993_;
								ValaParameter* _tmp994_;
								gchar* _tmp995_;
								gchar* _tmp996_;
								gboolean _tmp997_;
								_tmp990_ = arg;
								_tmp992_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp990_, &_tmp991_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp991_;
								delegate_target = _tmp992_;
								_tmp993_ = delegate_target;
								_vala_assert (_tmp993_ != NULL, "delegate_target != null");
								_tmp994_ = param;
								_tmp995_ = vala_get_ccode_type ((ValaCodeNode*) _tmp994_);
								_tmp996_ = _tmp995_;
								_tmp997_ = g_strcmp0 (_tmp996_, "GClosure*") == 0;
								_g_free0 (_tmp996_);
								if (_tmp997_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp998_;
									ValaCCodeIdentifier* _tmp999_;
									ValaCCodeFunctionCall* _tmp1000_;
									ValaCCodeFunctionCall* _tmp1001_;
									ValaCCodeFunctionCall* _tmp1002_;
									ValaCCodeExpression* _tmp1003_;
									ValaCCodeCastExpression* _tmp1004_;
									ValaCCodeCastExpression* _tmp1005_;
									ValaCCodeFunctionCall* _tmp1006_;
									ValaCCodeExpression* _tmp1007_;
									ValaCCodeFunctionCall* _tmp1008_;
									ValaCCodeExpression* _tmp1009_;
									ValaCCodeCastExpression* _tmp1010_;
									ValaCCodeCastExpression* _tmp1011_;
									ValaCCodeExpression* _tmp1012_;
									ValaCCodeIdentifier* _tmp1013_;
									ValaCCodeIdentifier* _tmp1014_;
									ValaCCodeBinaryExpression* _tmp1015_;
									ValaCCodeBinaryExpression* _tmp1016_;
									ValaCCodeIdentifier* _tmp1017_;
									ValaCCodeIdentifier* _tmp1018_;
									ValaCCodeFunctionCall* _tmp1019_;
									ValaCCodeConditionalExpression* _tmp1020_;
									_tmp998_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp999_ = _tmp998_;
									_tmp1000_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp999_);
									_tmp1001_ = _tmp1000_;
									_vala_ccode_node_unref0 (_tmp999_);
									closure_new = _tmp1001_;
									_tmp1002_ = closure_new;
									_tmp1003_ = cexpr;
									_tmp1004_ = vala_ccode_cast_expression_new (_tmp1003_, "GCallback");
									_tmp1005_ = _tmp1004_;
									vala_ccode_function_call_add_argument (_tmp1002_, (ValaCCodeExpression*) _tmp1005_);
									_vala_ccode_node_unref0 (_tmp1005_);
									_tmp1006_ = closure_new;
									_tmp1007_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp1006_, _tmp1007_);
									_tmp1008_ = closure_new;
									_tmp1009_ = delegate_target_destroy_notify;
									_tmp1010_ = vala_ccode_cast_expression_new (_tmp1009_, "GClosureNotify");
									_tmp1011_ = _tmp1010_;
									vala_ccode_function_call_add_argument (_tmp1008_, (ValaCCodeExpression*) _tmp1011_);
									_vala_ccode_node_unref0 (_tmp1011_);
									_tmp1012_ = cexpr;
									_tmp1013_ = vala_ccode_identifier_new ("NULL");
									_tmp1014_ = _tmp1013_;
									_tmp1015_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1012_, (ValaCCodeExpression*) _tmp1014_);
									_tmp1016_ = _tmp1015_;
									_tmp1017_ = vala_ccode_identifier_new ("NULL");
									_tmp1018_ = _tmp1017_;
									_tmp1019_ = closure_new;
									_tmp1020_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1016_, (ValaCCodeExpression*) _tmp1018_, (ValaCCodeExpression*) _tmp1019_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1020_;
									_vala_ccode_node_unref0 (_tmp1018_);
									_vala_ccode_node_unref0 (_tmp1016_);
									_vala_ccode_node_unref0 (_tmp1014_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaHashMap* _tmp1021_;
									ValaParameter* _tmp1022_;
									ValaCCodeExpression* _tmp1023_;
									ValaDelegateType* _tmp1024_;
									_tmp1021_ = carg_map;
									_tmp1022_ = param;
									_tmp1023_ = delegate_target;
									vala_map_set ((ValaMap*) _tmp1021_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1022_), FALSE)), _tmp1023_);
									_tmp1024_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1024_)) {
										ValaCCodeExpression* _tmp1025_;
										ValaHashMap* _tmp1026_;
										ValaParameter* _tmp1027_;
										ValaCCodeExpression* _tmp1028_;
										_tmp1025_ = delegate_target_destroy_notify;
										_vala_assert (_tmp1025_ != NULL, "delegate_target_destroy_notify != null");
										_tmp1026_ = carg_map;
										_tmp1027_ = param;
										_tmp1028_ = delegate_target_destroy_notify;
										vala_map_set ((ValaMap*) _tmp1026_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1027_) + 0.01, FALSE)), _tmp1028_);
									}
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1029_;
							ValaDataType* _tmp1030_;
							ValaDataType* _tmp1031_;
							_tmp1029_ = param;
							_tmp1030_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1029_);
							_tmp1031_ = _tmp1030_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1031_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1032_;
								ValaParameter* _tmp1033_;
								ValaExpression* _tmp1034_;
								ValaCCodeExpression* _tmp1035_ = NULL;
								ValaCCodeExpression* _tmp1036_;
								ValaCCodeExpression* _tmp1037_;
								_tmp1032_ = carg_map;
								_tmp1033_ = param;
								_tmp1034_ = arg;
								_tmp1036_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1034_, &_tmp1035_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1035_;
								_tmp1037_ = _tmp1036_;
								vala_map_set ((ValaMap*) _tmp1032_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1033_), FALSE)), _tmp1037_);
								_vala_ccode_node_unref0 (_tmp1037_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1038_;
								ValaDataType* _tmp1039_;
								ValaDataType* _tmp1040_;
								_tmp1038_ = param;
								_tmp1039_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1038_);
								_tmp1040_ = _tmp1039_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1040_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1041_ = FALSE;
									ValaMethod* _tmp1042_;
									_tmp1042_ = m;
									if (_tmp1042_ != NULL) {
										ValaMethod* _tmp1043_;
										_tmp1043_ = m;
										_tmp1041_ = vala_get_ccode_simple_generics (_tmp1043_);
									} else {
										_tmp1041_ = FALSE;
									}
									if (_tmp1041_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1044_;
										ValaDataType* _tmp1045_;
										ValaDataType* _tmp1046_;
										ValaGenericType* _tmp1047_;
										gint type_param_index = 0;
										ValaMethod* _tmp1048_;
										ValaGenericType* _tmp1049_;
										ValaTypeParameter* _tmp1050_;
										ValaTypeParameter* _tmp1051_;
										const gchar* _tmp1052_;
										const gchar* _tmp1053_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1054_;
										ValaList* _tmp1055_;
										ValaList* _tmp1056_;
										gint _tmp1057_;
										gpointer _tmp1058_;
										ValaDataType* _tmp1059_;
										ValaParameter* _tmp1060_;
										ValaDataType* _tmp1061_;
										ValaDataType* _tmp1062_;
										gboolean _tmp1063_;
										gboolean _tmp1064_;
										_tmp1044_ = param;
										_tmp1045_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1044_);
										_tmp1046_ = _tmp1045_;
										_tmp1047_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1046_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1047_;
										_tmp1048_ = m;
										_tmp1049_ = generic_type;
										_tmp1050_ = vala_generic_type_get_type_parameter (_tmp1049_);
										_tmp1051_ = _tmp1050_;
										_tmp1052_ = vala_symbol_get_name ((ValaSymbol*) _tmp1051_);
										_tmp1053_ = _tmp1052_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1048_, _tmp1053_);
										_tmp1054_ = ma;
										_tmp1055_ = vala_member_access_get_type_arguments (_tmp1054_);
										_tmp1056_ = _tmp1055_;
										_tmp1057_ = type_param_index;
										_tmp1058_ = vala_list_get (_tmp1056_, _tmp1057_);
										_tmp1059_ = (ValaDataType*) _tmp1058_;
										_vala_iterable_unref0 (_tmp1056_);
										type_arg = _tmp1059_;
										_tmp1060_ = param;
										_tmp1061_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1060_);
										_tmp1062_ = _tmp1061_;
										_tmp1063_ = vala_data_type_get_value_owned (_tmp1062_);
										_tmp1064_ = _tmp1063_;
										if (_tmp1064_) {
											ValaDataType* _tmp1065_;
											_tmp1065_ = type_arg;
											if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1065_)) {
												ValaHashMap* _tmp1066_;
												ValaParameter* _tmp1067_;
												ValaDataType* _tmp1068_;
												ValaCCodeExpression* _tmp1069_;
												ValaCCodeExpression* _tmp1070_;
												_tmp1066_ = carg_map;
												_tmp1067_ = param;
												_tmp1068_ = type_arg;
												_tmp1069_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1068_, FALSE);
												_tmp1070_ = _tmp1069_;
												vala_map_set ((ValaMap*) _tmp1066_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1067_), FALSE)), _tmp1070_);
												_vala_ccode_node_unref0 (_tmp1070_);
											} else {
												ValaHashMap* _tmp1071_;
												ValaParameter* _tmp1072_;
												ValaCCodeConstant* _tmp1073_;
												ValaCCodeConstant* _tmp1074_;
												_tmp1071_ = carg_map;
												_tmp1072_ = param;
												_tmp1073_ = vala_ccode_constant_new ("NULL");
												_tmp1074_ = _tmp1073_;
												vala_map_set ((ValaMap*) _tmp1071_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1072_), FALSE)), (ValaCCodeExpression*) _tmp1074_);
												_vala_ccode_node_unref0 (_tmp1074_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1075_ = param;
					_tmp1076_ = arg;
					_tmp1077_ = cexpr;
					_tmp1078_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1075_, _tmp1076_, _tmp1077_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1078_;
				} else {
					ValaExpression* _tmp1079_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1080_;
					ValaDataType* _tmp1081_;
					ValaDataType* _tmp1082_;
					ValaParameter* _tmp1083_;
					ValaDataType* _tmp1084_;
					ValaDataType* _tmp1085_;
					gboolean _tmp1086_;
					gboolean _tmp1087_;
					ValaLocalVariable* _tmp1088_;
					ValaLocalVariable* _tmp1089_;
					ValaExpression* _tmp1090_;
					ValaLocalVariable* _tmp1091_;
					const gchar* _tmp1092_;
					const gchar* _tmp1093_;
					ValaCCodeExpression* _tmp1094_;
					ValaCCodeExpression* _tmp1095_;
					ValaExpression* _tmp1096_;
					ValaTargetValue* _tmp1097_;
					ValaTargetValue* _tmp1098_;
					ValaExpression* _tmp1099_;
					ValaDataType* _tmp1100_;
					ValaDataType* _tmp1101_;
					ValaExpression* _tmp1102_;
					ValaCCodeExpression* _tmp1103_;
					ValaCCodeExpression* _tmp1104_;
					ValaCCodeUnaryExpression* _tmp1105_;
					gboolean _tmp1106_ = FALSE;
					gboolean _tmp1107_ = FALSE;
					ValaParameter* _tmp1108_;
					_tmp1079_ = arg;
					vala_expression_set_target_value (_tmp1079_, NULL);
					_tmp1080_ = param;
					_tmp1081_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1080_);
					_tmp1082_ = _tmp1081_;
					_tmp1083_ = param;
					_tmp1084_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1083_);
					_tmp1085_ = _tmp1084_;
					_tmp1086_ = vala_data_type_get_value_owned (_tmp1085_);
					_tmp1087_ = _tmp1086_;
					_tmp1088_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1082_, _tmp1087_, NULL, TRUE);
					temp_var = _tmp1088_;
					_tmp1089_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1089_, FALSE);
					_tmp1090_ = arg;
					_tmp1091_ = temp_var;
					_tmp1092_ = vala_symbol_get_name ((ValaSymbol*) _tmp1091_);
					_tmp1093_ = _tmp1092_;
					_tmp1094_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1093_);
					_tmp1095_ = _tmp1094_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1090_, _tmp1095_);
					_vala_ccode_node_unref0 (_tmp1095_);
					_tmp1096_ = arg;
					_tmp1097_ = vala_expression_get_target_value (_tmp1096_);
					_tmp1098_ = _tmp1097_;
					_tmp1099_ = arg;
					_tmp1100_ = vala_expression_get_target_type (_tmp1099_);
					_tmp1101_ = _tmp1100_;
					vala_target_value_set_value_type (_tmp1098_, _tmp1101_);
					_tmp1102_ = arg;
					_tmp1103_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1102_);
					_tmp1104_ = _tmp1103_;
					_tmp1105_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1104_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1105_;
					_vala_ccode_node_unref0 (_tmp1104_);
					_tmp1108_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1108_)) {
						ValaParameter* _tmp1109_;
						ValaDataType* _tmp1110_;
						ValaDataType* _tmp1111_;
						_tmp1109_ = param;
						_tmp1110_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1109_);
						_tmp1111_ = _tmp1110_;
						_tmp1107_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1111_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1107_ = FALSE;
					}
					if (_tmp1107_) {
						ValaParameter* _tmp1112_;
						ValaDataType* _tmp1113_;
						ValaDataType* _tmp1114_;
						gboolean _tmp1115_;
						gboolean _tmp1116_;
						_tmp1112_ = param;
						_tmp1113_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1112_);
						_tmp1114_ = _tmp1113_;
						_tmp1115_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1114_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1116_ = _tmp1115_;
						_tmp1106_ = !_tmp1116_;
					} else {
						_tmp1106_ = FALSE;
					}
					if (_tmp1106_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1117_;
						ValaDataType* _tmp1118_;
						ValaDataType* _tmp1119_;
						ValaArrayType* _tmp1120_;
						ValaDataType* array_length_type = NULL;
						ValaDataType* _tmp1121_;
						ValaDataType* _tmp1122_;
						ValaParameter* _tmp1123_;
						gchar* _tmp1124_;
						gchar* _tmp1125_;
						gboolean _tmp1126_;
						_tmp1117_ = param;
						_tmp1118_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1117_);
						_tmp1119_ = _tmp1118_;
						_tmp1120_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1119_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1120_;
						_tmp1121_ = ((ValaCCodeBaseModule*) self)->int_type;
						_tmp1122_ = _vala_code_node_ref0 (_tmp1121_);
						array_length_type = _tmp1122_;
						_tmp1123_ = param;
						_tmp1124_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1123_);
						_tmp1125_ = _tmp1124_;
						_tmp1126_ = _tmp1125_ != NULL;
						_g_free0 (_tmp1125_);
						if (_tmp1126_) {
							ValaParameter* _tmp1127_;
							gchar* _tmp1128_;
							gchar* _tmp1129_;
							ValaCType* _tmp1130_;
							_tmp1127_ = param;
							_tmp1128_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1127_);
							_tmp1129_ = _tmp1128_;
							_tmp1130_ = vala_ctype_new (_tmp1129_, "0");
							_vala_code_node_unref0 (array_length_type);
							array_length_type = (ValaDataType*) _tmp1130_;
							_g_free0 (_tmp1129_);
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1131_ = FALSE;
								_tmp1131_ = TRUE;
								while (TRUE) {
									gint _tmp1133_;
									ValaArrayType* _tmp1134_;
									gint _tmp1135_;
									gint _tmp1136_;
									ValaLocalVariable* temp_array_length = NULL;
									ValaDataType* _tmp1137_;
									ValaLocalVariable* _tmp1138_;
									ValaLocalVariable* _tmp1139_;
									ValaExpression* _tmp1140_;
									ValaLocalVariable* _tmp1141_;
									const gchar* _tmp1142_;
									const gchar* _tmp1143_;
									ValaCCodeExpression* _tmp1144_;
									ValaCCodeExpression* _tmp1145_;
									ValaHashMap* _tmp1146_;
									ValaParameter* _tmp1147_;
									gint _tmp1148_;
									ValaExpression* _tmp1149_;
									ValaList* _tmp1150_;
									ValaList* _tmp1151_;
									gint _tmp1152_;
									gpointer _tmp1153_;
									ValaCCodeExpression* _tmp1154_;
									ValaCCodeUnaryExpression* _tmp1155_;
									ValaCCodeUnaryExpression* _tmp1156_;
									if (!_tmp1131_) {
										gint _tmp1132_;
										_tmp1132_ = dim;
										dim = _tmp1132_ + 1;
									}
									_tmp1131_ = FALSE;
									_tmp1133_ = dim;
									_tmp1134_ = array_type;
									_tmp1135_ = vala_array_type_get_rank (_tmp1134_);
									_tmp1136_ = _tmp1135_;
									if (!(_tmp1133_ <= _tmp1136_)) {
										break;
									}
									_tmp1137_ = array_length_type;
									_tmp1138_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1137_, TRUE, NULL, FALSE);
									temp_array_length = _tmp1138_;
									_tmp1139_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1139_, FALSE);
									_tmp1140_ = arg;
									_tmp1141_ = temp_array_length;
									_tmp1142_ = vala_symbol_get_name ((ValaSymbol*) _tmp1141_);
									_tmp1143_ = _tmp1142_;
									_tmp1144_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1143_);
									_tmp1145_ = _tmp1144_;
									vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1140_, _tmp1145_);
									_vala_ccode_node_unref0 (_tmp1145_);
									_tmp1146_ = carg_map;
									_tmp1147_ = param;
									_tmp1148_ = dim;
									_tmp1149_ = arg;
									_tmp1150_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1149_);
									_tmp1151_ = _tmp1150_;
									_tmp1152_ = dim;
									_tmp1153_ = vala_list_get (_tmp1151_, _tmp1152_ - 1);
									_tmp1154_ = (ValaCCodeExpression*) _tmp1153_;
									_tmp1155_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1154_);
									_tmp1156_ = _tmp1155_;
									vala_map_set ((ValaMap*) _tmp1146_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1147_) + (0.01 * _tmp1148_), FALSE)), (ValaCCodeExpression*) _tmp1156_);
									_vala_ccode_node_unref0 (_tmp1156_);
									_vala_ccode_node_unref0 (_tmp1154_);
									_vala_iterable_unref0 (_tmp1151_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_vala_code_node_unref0 (array_length_type);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp1157_;
						ValaDataType* _tmp1158_;
						ValaDataType* _tmp1159_;
						_tmp1157_ = param;
						_tmp1158_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1157_);
						_tmp1159_ = _tmp1158_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1159_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1160_;
							ValaDataType* _tmp1161_;
							ValaDataType* _tmp1162_;
							ValaDelegateType* _tmp1163_;
							ValaDelegateType* _tmp1164_;
							ValaDelegate* _tmp1165_;
							ValaDelegate* _tmp1166_;
							gboolean _tmp1167_;
							gboolean _tmp1168_;
							_tmp1160_ = param;
							_tmp1161_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1160_);
							_tmp1162_ = _tmp1161_;
							_tmp1163_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1162_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1163_;
							_tmp1164_ = deleg_type;
							_tmp1165_ = vala_delegate_type_get_delegate_symbol (_tmp1164_);
							_tmp1166_ = _tmp1165_;
							_tmp1167_ = vala_delegate_get_has_target (_tmp1166_);
							_tmp1168_ = _tmp1167_;
							if (_tmp1168_) {
								ValaVoidType* _tmp1169_;
								ValaVoidType* _tmp1170_;
								ValaPointerType* _tmp1171_;
								ValaPointerType* _tmp1172_;
								ValaLocalVariable* _tmp1173_;
								ValaLocalVariable* _tmp1174_;
								ValaExpression* _tmp1175_;
								ValaLocalVariable* _tmp1176_;
								const gchar* _tmp1177_;
								const gchar* _tmp1178_;
								ValaCCodeExpression* _tmp1179_;
								ValaCCodeExpression* _tmp1180_;
								ValaHashMap* _tmp1181_;
								ValaParameter* _tmp1182_;
								ValaExpression* _tmp1183_;
								ValaCCodeExpression* _tmp1184_;
								ValaCCodeExpression* _tmp1185_;
								ValaCCodeUnaryExpression* _tmp1186_;
								ValaCCodeUnaryExpression* _tmp1187_;
								ValaDelegateType* _tmp1188_;
								_tmp1169_ = vala_void_type_new (NULL);
								_tmp1170_ = _tmp1169_;
								_tmp1171_ = vala_pointer_type_new ((ValaDataType*) _tmp1170_, NULL);
								_tmp1172_ = _tmp1171_;
								_tmp1173_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1172_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1173_;
								_vala_code_node_unref0 (_tmp1172_);
								_vala_code_node_unref0 (_tmp1170_);
								_tmp1174_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1174_, FALSE);
								_tmp1175_ = arg;
								_tmp1176_ = temp_var;
								_tmp1177_ = vala_symbol_get_name ((ValaSymbol*) _tmp1176_);
								_tmp1178_ = _tmp1177_;
								_tmp1179_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1178_);
								_tmp1180_ = _tmp1179_;
								vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1175_, _tmp1180_);
								_vala_ccode_node_unref0 (_tmp1180_);
								_tmp1181_ = carg_map;
								_tmp1182_ = param;
								_tmp1183_ = arg;
								_tmp1184_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1183_);
								_tmp1185_ = _tmp1184_;
								_tmp1186_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1185_);
								_tmp1187_ = _tmp1186_;
								vala_map_set ((ValaMap*) _tmp1181_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1182_), FALSE)), (ValaCCodeExpression*) _tmp1187_);
								_vala_ccode_node_unref0 (_tmp1187_);
								_vala_ccode_node_unref0 (_tmp1185_);
								_tmp1188_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1188_)) {
									ValaDataType* _tmp1189_;
									ValaLocalVariable* _tmp1190_;
									ValaLocalVariable* _tmp1191_;
									ValaExpression* _tmp1192_;
									ValaLocalVariable* _tmp1193_;
									const gchar* _tmp1194_;
									const gchar* _tmp1195_;
									ValaCCodeExpression* _tmp1196_;
									ValaCCodeExpression* _tmp1197_;
									ValaHashMap* _tmp1198_;
									ValaParameter* _tmp1199_;
									ValaExpression* _tmp1200_;
									ValaCCodeExpression* _tmp1201_;
									ValaCCodeExpression* _tmp1202_;
									ValaCCodeUnaryExpression* _tmp1203_;
									ValaCCodeUnaryExpression* _tmp1204_;
									_tmp1189_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
									_tmp1190_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1189_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1190_;
									_tmp1191_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1191_, FALSE);
									_tmp1192_ = arg;
									_tmp1193_ = temp_var;
									_tmp1194_ = vala_symbol_get_name ((ValaSymbol*) _tmp1193_);
									_tmp1195_ = _tmp1194_;
									_tmp1196_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1195_);
									_tmp1197_ = _tmp1196_;
									vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1192_, _tmp1197_);
									_vala_ccode_node_unref0 (_tmp1197_);
									_tmp1198_ = carg_map;
									_tmp1199_ = param;
									_tmp1200_ = arg;
									_tmp1201_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1200_);
									_tmp1202_ = _tmp1201_;
									_tmp1203_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1202_);
									_tmp1204_ = _tmp1203_;
									vala_map_set ((ValaMap*) _tmp1198_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1199_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1204_);
									_vala_ccode_node_unref0 (_tmp1204_);
									_vala_ccode_node_unref0 (_tmp1202_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1205_ = param;
				_tmp1206_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1205_);
				_tmp1207_ = _tmp1206_;
				_tmp1208_ = _tmp1207_ != NULL;
				_g_free0 (_tmp1207_);
				if (_tmp1208_) {
					ValaCCodeExpression* _tmp1209_;
					ValaParameter* _tmp1210_;
					gchar* _tmp1211_;
					gchar* _tmp1212_;
					ValaCCodeCastExpression* _tmp1213_;
					_tmp1209_ = cexpr;
					_tmp1210_ = param;
					_tmp1211_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1210_);
					_tmp1212_ = _tmp1211_;
					_tmp1213_ = vala_ccode_cast_expression_new (_tmp1209_, _tmp1212_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1213_;
					_g_free0 (_tmp1212_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1214_;
				ValaUnaryExpression* _tmp1215_;
				gboolean _tmp1216_ = FALSE;
				gboolean _tmp1217_ = FALSE;
				gboolean _tmp1218_;
				_tmp1214_ = arg;
				_tmp1215_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1214_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1214_) : NULL);
				unary = _tmp1215_;
				_tmp1218_ = ellipsis;
				if (_tmp1218_) {
					ValaUnaryExpression* _tmp1219_;
					_tmp1219_ = unary;
					_tmp1217_ = _tmp1219_ != NULL;
				} else {
					_tmp1217_ = FALSE;
				}
				if (_tmp1217_) {
					ValaUnaryExpression* _tmp1220_;
					ValaUnaryOperator _tmp1221_;
					ValaUnaryOperator _tmp1222_;
					_tmp1220_ = unary;
					_tmp1221_ = vala_unary_expression_get_operator (_tmp1220_);
					_tmp1222_ = _tmp1221_;
					_tmp1216_ = _tmp1222_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1216_ = FALSE;
				}
				if (_tmp1216_) {
					ValaHashMap* _tmp1223_;
					ValaHashMap* _tmp1224_;
					ValaExpression* _tmp1225_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1226_;
					ValaDataType* _tmp1227_;
					ValaDataType* _tmp1228_;
					ValaExpression* _tmp1229_;
					ValaDataType* _tmp1230_;
					ValaDataType* _tmp1231_;
					gboolean _tmp1232_;
					gboolean _tmp1233_;
					ValaLocalVariable* _tmp1234_;
					ValaLocalVariable* _tmp1235_;
					ValaExpression* _tmp1236_;
					ValaLocalVariable* _tmp1237_;
					const gchar* _tmp1238_;
					const gchar* _tmp1239_;
					ValaCCodeExpression* _tmp1240_;
					ValaCCodeExpression* _tmp1241_;
					ValaExpression* _tmp1242_;
					ValaTargetValue* _tmp1243_;
					ValaTargetValue* _tmp1244_;
					ValaExpression* _tmp1245_;
					ValaDataType* _tmp1246_;
					ValaDataType* _tmp1247_;
					ValaExpression* _tmp1248_;
					ValaCCodeExpression* _tmp1249_;
					ValaCCodeExpression* _tmp1250_;
					ValaCCodeUnaryExpression* _tmp1251_;
					_tmp1223_ = out_arg_map;
					_tmp1224_ = _vala_map_ref0 (_tmp1223_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1224_;
					_tmp1225_ = arg;
					vala_expression_set_target_value (_tmp1225_, NULL);
					_tmp1226_ = arg;
					_tmp1227_ = vala_expression_get_value_type (_tmp1226_);
					_tmp1228_ = _tmp1227_;
					_tmp1229_ = arg;
					_tmp1230_ = vala_expression_get_value_type (_tmp1229_);
					_tmp1231_ = _tmp1230_;
					_tmp1232_ = vala_data_type_get_value_owned (_tmp1231_);
					_tmp1233_ = _tmp1232_;
					_tmp1234_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1228_, _tmp1233_, NULL, TRUE);
					temp_var = _tmp1234_;
					_tmp1235_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1235_, FALSE);
					_tmp1236_ = arg;
					_tmp1237_ = temp_var;
					_tmp1238_ = vala_symbol_get_name ((ValaSymbol*) _tmp1237_);
					_tmp1239_ = _tmp1238_;
					_tmp1240_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1239_);
					_tmp1241_ = _tmp1240_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1236_, _tmp1241_);
					_vala_ccode_node_unref0 (_tmp1241_);
					_tmp1242_ = arg;
					_tmp1243_ = vala_expression_get_target_value (_tmp1242_);
					_tmp1244_ = _tmp1243_;
					_tmp1245_ = arg;
					_tmp1246_ = vala_expression_get_value_type (_tmp1245_);
					_tmp1247_ = _tmp1246_;
					vala_target_value_set_value_type (_tmp1244_, _tmp1247_);
					_tmp1248_ = arg;
					_tmp1249_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1248_);
					_tmp1250_ = _tmp1249_;
					_tmp1251_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1250_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1251_;
					_vala_ccode_node_unref0 (_tmp1250_);
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1252_;
					ValaCCodeExpression* _tmp1253_;
					ValaCCodeExpression* _tmp1254_;
					_tmp1252_ = arg;
					_tmp1253_ = cexpr;
					_tmp1254_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1252_, _tmp1253_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1254_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1256_ = param;
			if (_tmp1256_ != NULL) {
				ValaParameter* _tmp1257_;
				_tmp1257_ = param;
				_tmp1255_ = vala_get_ccode_pos (_tmp1257_);
			} else {
				gint _tmp1258_;
				_tmp1258_ = i;
				_tmp1255_ = (gdouble) _tmp1258_;
			}
			_tmp1259_ = ellipsis;
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1255_, _tmp1259_);
			_tmp1260_ = carg_map;
			_tmp1261_ = arg_pos;
			_tmp1262_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1260_, (gpointer) ((gintptr) _tmp1261_), _tmp1262_);
			_tmp1264_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1264_, VALA_TYPE_NAMED_ARGUMENT)) {
				gboolean _tmp1265_;
				_tmp1265_ = ellipsis;
				_tmp1263_ = _tmp1265_;
			} else {
				_tmp1263_ = FALSE;
			}
			if (_tmp1263_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1266_;
				ValaNamedArgument* _tmp1267_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1268_;
				const gchar* _tmp1269_;
				const gchar* _tmp1270_;
				gchar** _tmp1271_;
				gchar** _tmp1272_;
				gchar** _tmp1273_;
				gint _tmp1273__length1;
				gchar* _tmp1274_;
				gchar* _tmp1275_;
				ValaHashMap* _tmp1276_;
				gint _tmp1277_;
				gboolean _tmp1278_;
				const gchar* _tmp1279_;
				gchar* _tmp1280_;
				gchar* _tmp1281_;
				ValaCCodeConstant* _tmp1282_;
				ValaCCodeConstant* _tmp1283_;
				_tmp1266_ = arg;
				_tmp1267_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1266_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1267_;
				_tmp1268_ = named_arg;
				_tmp1269_ = vala_named_argument_get_name (_tmp1268_);
				_tmp1270_ = _tmp1269_;
				_tmp1272_ = _tmp1271_ = g_strsplit (_tmp1270_, "_", 0);
				_tmp1273_ = _tmp1272_;
				_tmp1273__length1 = _vala_array_length (_tmp1271_);
				_tmp1274_ = _vala_g_strjoinv ("-", _tmp1273_, _vala_array_length (_tmp1271_));
				_tmp1275_ = _tmp1274_;
				_tmp1273_ = (_vala_array_free (_tmp1273_, _tmp1273__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1275_;
				_tmp1276_ = carg_map;
				_tmp1277_ = i;
				_tmp1278_ = ellipsis;
				_tmp1279_ = name;
				_tmp1280_ = g_strdup_printf ("\"%s\"", _tmp1279_);
				_tmp1281_ = _tmp1280_;
				_tmp1282_ = vala_ccode_constant_new (_tmp1281_);
				_tmp1283_ = _tmp1282_;
				vala_map_set ((ValaMap*) _tmp1276_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1277_ - 0.1, _tmp1278_)), (ValaCCodeExpression*) _tmp1283_);
				_vala_ccode_node_unref0 (_tmp1283_);
				_g_free0 (_tmp1281_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1284_ = i;
			i = _tmp1284_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1285_ = params_it;
	if (vala_iterator_next (_tmp1285_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1286_;
		gpointer _tmp1287_;
		gboolean _tmp1288_ = FALSE;
		ValaParameter* _tmp1289_;
		gboolean _tmp1290_;
		gboolean _tmp1291_;
		_tmp1286_ = params_it;
		_tmp1287_ = vala_iterator_get (_tmp1286_);
		param = (ValaParameter*) _tmp1287_;
		_tmp1289_ = param;
		_tmp1290_ = vala_parameter_get_params_array (_tmp1289_);
		_tmp1291_ = _tmp1290_;
		if (_tmp1291_) {
			_tmp1288_ = TRUE;
		} else {
			ValaParameter* _tmp1292_;
			gboolean _tmp1293_;
			gboolean _tmp1294_;
			_tmp1292_ = param;
			_tmp1293_ = vala_parameter_get_ellipsis (_tmp1292_);
			_tmp1294_ = _tmp1293_;
			_tmp1288_ = _tmp1294_;
		}
		_vala_assert (_tmp1288_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1297_ = m;
	if (_tmp1297_ != NULL) {
		ValaMethod* _tmp1298_;
		ValaDataType* _tmp1299_;
		ValaDataType* _tmp1300_;
		_tmp1298_ = m;
		_tmp1299_ = vala_callable_get_return_type ((ValaCallable*) _tmp1298_);
		_tmp1300_ = _tmp1299_;
		_tmp1296_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1300_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1296_ = FALSE;
	}
	if (_tmp1296_) {
		ValaCCodeFunctionCall* _tmp1301_;
		ValaCCodeFunctionCall* _tmp1302_;
		_tmp1301_ = async_call;
		_tmp1302_ = ccall;
		_tmp1295_ = _tmp1301_ != _tmp1302_;
	} else {
		_tmp1295_ = FALSE;
	}
	if (_tmp1295_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1303_;
		ValaDataType* _tmp1304_;
		ValaDataType* _tmp1305_;
		ValaArrayType* _tmp1306_;
		_tmp1303_ = m;
		_tmp1304_ = vala_callable_get_return_type ((ValaCallable*) _tmp1303_);
		_tmp1305_ = _tmp1304_;
		_tmp1306_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1305_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1306_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1307_ = FALSE;
				_tmp1307_ = TRUE;
				while (TRUE) {
					gint _tmp1309_;
					ValaArrayType* _tmp1310_;
					gint _tmp1311_;
					gint _tmp1312_;
					ValaMethod* _tmp1313_;
					if (!_tmp1307_) {
						gint _tmp1308_;
						_tmp1308_ = dim;
						dim = _tmp1308_ + 1;
					}
					_tmp1307_ = FALSE;
					_tmp1309_ = dim;
					_tmp1310_ = array_type;
					_tmp1311_ = vala_array_type_get_rank (_tmp1310_);
					_tmp1312_ = _tmp1311_;
					if (!(_tmp1309_ <= _tmp1312_)) {
						break;
					}
					_tmp1313_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1313_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1314_;
						ValaDataType* _tmp1315_;
						ValaDataType* _tmp1316_;
						ValaLocalVariable* _tmp1317_;
						ValaLocalVariable* _tmp1318_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1319_;
						const gchar* _tmp1320_;
						const gchar* _tmp1321_;
						ValaCCodeExpression* _tmp1322_;
						ValaLocalVariable* _tmp1323_;
						ValaCCodeExpression* _tmp1324_;
						ValaCCodeExpression* _tmp1325_;
						ValaCCodeAssignment* _tmp1326_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1327_;
						ValaCCodeIdentifier* _tmp1328_;
						ValaCCodeFunctionCall* _tmp1329_;
						ValaCCodeFunctionCall* _tmp1330_;
						ValaCCodeFunctionCall* _tmp1331_;
						ValaCCodeExpression* _tmp1332_;
						ValaCCodeFunctionCall* _tmp1333_;
						_tmp1314_ = itype;
						_tmp1315_ = vala_data_type_get_return_type (_tmp1314_);
						_tmp1316_ = _tmp1315_;
						_tmp1317_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1316_, TRUE, NULL, FALSE);
						_tmp1318_ = _tmp1317_;
						_vala_code_node_unref0 (_tmp1316_);
						temp_var = _tmp1318_;
						_tmp1319_ = temp_var;
						_tmp1320_ = vala_symbol_get_name ((ValaSymbol*) _tmp1319_);
						_tmp1321_ = _tmp1320_;
						_tmp1322_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1321_);
						temp_ref = _tmp1322_;
						_tmp1323_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1323_, FALSE);
						_tmp1324_ = temp_ref;
						_tmp1325_ = ccall_expr;
						_tmp1326_ = vala_ccode_assignment_new (_tmp1324_, _tmp1325_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1326_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1327_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1328_ = _tmp1327_;
						_tmp1329_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1328_);
						_tmp1330_ = _tmp1329_;
						_vala_ccode_node_unref0 (_tmp1328_);
						len_call = _tmp1330_;
						_tmp1331_ = len_call;
						_tmp1332_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1331_, _tmp1332_);
						_tmp1333_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1333_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1334_;
						_tmp1334_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1334_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaMethod* _tmp1335_;
							gchar* _tmp1336_;
							gchar* _tmp1337_;
							gboolean _tmp1338_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1347_;
							const gchar* _tmp1348_;
							const gchar* _tmp1349_;
							ValaCCodeExpression* _tmp1350_;
							ValaLocalVariable* _tmp1351_;
							ValaHashMap* _tmp1352_;
							ValaMethod* _tmp1353_;
							gint _tmp1354_;
							ValaCCodeExpression* _tmp1355_;
							ValaCCodeUnaryExpression* _tmp1356_;
							ValaCCodeUnaryExpression* _tmp1357_;
							ValaCCodeExpression* _tmp1358_;
							_tmp1335_ = m;
							_tmp1336_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1335_);
							_tmp1337_ = _tmp1336_;
							_tmp1338_ = _tmp1337_ == NULL;
							_g_free0 (_tmp1337_);
							if (_tmp1338_) {
								ValaDataType* _tmp1339_;
								ValaLocalVariable* _tmp1340_;
								_tmp1339_ = ((ValaCCodeBaseModule*) self)->int_type;
								_tmp1340_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1339_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1340_;
							} else {
								ValaMethod* _tmp1341_;
								gchar* _tmp1342_;
								gchar* _tmp1343_;
								ValaCType* _tmp1344_;
								ValaCType* _tmp1345_;
								ValaLocalVariable* _tmp1346_;
								_tmp1341_ = m;
								_tmp1342_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1341_);
								_tmp1343_ = _tmp1342_;
								_tmp1344_ = vala_ctype_new (_tmp1343_, "0");
								_tmp1345_ = _tmp1344_;
								_tmp1346_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1345_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1346_;
								_vala_code_node_unref0 (_tmp1345_);
								_g_free0 (_tmp1343_);
							}
							_tmp1347_ = temp_var;
							_tmp1348_ = vala_symbol_get_name ((ValaSymbol*) _tmp1347_);
							_tmp1349_ = _tmp1348_;
							_tmp1350_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1349_);
							temp_ref = _tmp1350_;
							_tmp1351_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1351_, FALSE);
							_tmp1352_ = out_arg_map;
							_tmp1353_ = m;
							_tmp1354_ = dim;
							_tmp1355_ = temp_ref;
							_tmp1356_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1355_);
							_tmp1357_ = _tmp1356_;
							vala_map_set ((ValaMap*) _tmp1352_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1353_) + (0.01 * _tmp1354_), FALSE)), (ValaCCodeExpression*) _tmp1357_);
							_vala_ccode_node_unref0 (_tmp1357_);
							_tmp1358_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1358_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaMethod* _tmp1359_;
							gchar* _tmp1360_;
							gchar* _tmp1361_;
							gboolean _tmp1362_;
							_tmp1359_ = m;
							_tmp1360_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1359_);
							_tmp1361_ = _tmp1360_;
							_tmp1362_ = _tmp1361_ != NULL;
							_g_free0 (_tmp1361_);
							if (_tmp1362_) {
								ValaMethod* _tmp1363_;
								gchar* _tmp1364_;
								gchar* _tmp1365_;
								ValaCCodeConstant* _tmp1366_;
								ValaCCodeConstant* _tmp1367_;
								_tmp1363_ = m;
								_tmp1364_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1363_);
								_tmp1365_ = _tmp1364_;
								_tmp1366_ = vala_ccode_constant_new (_tmp1365_);
								_tmp1367_ = _tmp1366_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1367_);
								_vala_ccode_node_unref0 (_tmp1367_);
								_g_free0 (_tmp1365_);
							} else {
								ValaCCodeConstant* _tmp1368_;
								ValaCCodeConstant* _tmp1369_;
								_tmp1368_ = vala_ccode_constant_new ("-1");
								_tmp1369_ = _tmp1368_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1369_);
								_vala_ccode_node_unref0 (_tmp1369_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1370_ = FALSE;
		gboolean _tmp1371_ = FALSE;
		ValaMethod* _tmp1372_;
		_tmp1372_ = m;
		if (_tmp1372_ != NULL) {
			ValaMethod* _tmp1373_;
			ValaDataType* _tmp1374_;
			ValaDataType* _tmp1375_;
			_tmp1373_ = m;
			_tmp1374_ = vala_callable_get_return_type ((ValaCallable*) _tmp1373_);
			_tmp1375_ = _tmp1374_;
			_tmp1371_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1375_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1371_ = FALSE;
		}
		if (_tmp1371_) {
			ValaCCodeFunctionCall* _tmp1376_;
			ValaCCodeFunctionCall* _tmp1377_;
			_tmp1376_ = async_call;
			_tmp1377_ = ccall;
			_tmp1370_ = _tmp1376_ != _tmp1377_;
		} else {
			_tmp1370_ = FALSE;
		}
		if (_tmp1370_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1378_;
			ValaDataType* _tmp1379_;
			ValaDataType* _tmp1380_;
			ValaDelegateType* _tmp1381_;
			ValaDelegateType* _tmp1382_;
			ValaDelegate* _tmp1383_;
			ValaDelegate* _tmp1384_;
			gboolean _tmp1385_;
			gboolean _tmp1386_;
			_tmp1378_ = m;
			_tmp1379_ = vala_callable_get_return_type ((ValaCallable*) _tmp1378_);
			_tmp1380_ = _tmp1379_;
			_tmp1381_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1380_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1381_;
			_tmp1382_ = deleg_type;
			_tmp1383_ = vala_delegate_type_get_delegate_symbol (_tmp1382_);
			_tmp1384_ = _tmp1383_;
			_tmp1385_ = vala_delegate_get_has_target (_tmp1384_);
			_tmp1386_ = _tmp1385_;
			if (_tmp1386_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1387_;
				ValaVoidType* _tmp1388_;
				ValaPointerType* _tmp1389_;
				ValaPointerType* _tmp1390_;
				ValaLocalVariable* _tmp1391_;
				ValaLocalVariable* _tmp1392_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1393_;
				const gchar* _tmp1394_;
				const gchar* _tmp1395_;
				ValaCCodeExpression* _tmp1396_;
				ValaLocalVariable* _tmp1397_;
				ValaHashMap* _tmp1398_;
				ValaMethod* _tmp1399_;
				ValaCCodeExpression* _tmp1400_;
				ValaCCodeUnaryExpression* _tmp1401_;
				ValaCCodeUnaryExpression* _tmp1402_;
				ValaCCodeExpression* _tmp1403_;
				ValaDelegateType* _tmp1404_;
				_tmp1387_ = vala_void_type_new (NULL);
				_tmp1388_ = _tmp1387_;
				_tmp1389_ = vala_pointer_type_new ((ValaDataType*) _tmp1388_, NULL);
				_tmp1390_ = _tmp1389_;
				_tmp1391_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1390_, TRUE, NULL, TRUE);
				_tmp1392_ = _tmp1391_;
				_vala_code_node_unref0 (_tmp1390_);
				_vala_code_node_unref0 (_tmp1388_);
				temp_var = _tmp1392_;
				_tmp1393_ = temp_var;
				_tmp1394_ = vala_symbol_get_name ((ValaSymbol*) _tmp1393_);
				_tmp1395_ = _tmp1394_;
				_tmp1396_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1395_);
				temp_ref = _tmp1396_;
				_tmp1397_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1397_, FALSE);
				_tmp1398_ = out_arg_map;
				_tmp1399_ = m;
				_tmp1400_ = temp_ref;
				_tmp1401_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1400_);
				_tmp1402_ = _tmp1401_;
				vala_map_set ((ValaMap*) _tmp1398_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1399_), FALSE)), (ValaCCodeExpression*) _tmp1402_);
				_vala_ccode_node_unref0 (_tmp1402_);
				_tmp1403_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1403_);
				_tmp1404_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1404_)) {
					ValaDataType* _tmp1405_;
					ValaLocalVariable* _tmp1406_;
					ValaLocalVariable* _tmp1407_;
					const gchar* _tmp1408_;
					const gchar* _tmp1409_;
					ValaCCodeExpression* _tmp1410_;
					ValaLocalVariable* _tmp1411_;
					ValaHashMap* _tmp1412_;
					ValaMethod* _tmp1413_;
					ValaCCodeExpression* _tmp1414_;
					ValaCCodeUnaryExpression* _tmp1415_;
					ValaCCodeUnaryExpression* _tmp1416_;
					ValaCCodeExpression* _tmp1417_;
					_tmp1405_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1406_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1405_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1406_;
					_tmp1407_ = temp_var;
					_tmp1408_ = vala_symbol_get_name ((ValaSymbol*) _tmp1407_);
					_tmp1409_ = _tmp1408_;
					_tmp1410_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1409_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1410_;
					_tmp1411_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1411_, FALSE);
					_tmp1412_ = out_arg_map;
					_tmp1413_ = m;
					_tmp1414_ = temp_ref;
					_tmp1415_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1414_);
					_tmp1416_ = _tmp1415_;
					vala_map_set ((ValaMap*) _tmp1412_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1413_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1416_);
					_vala_ccode_node_unref0 (_tmp1416_);
					_tmp1417_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1417_);
				} else {
					ValaCCodeConstant* _tmp1418_;
					ValaCCodeConstant* _tmp1419_;
					_tmp1418_ = vala_ccode_constant_new ("NULL");
					_tmp1419_ = _tmp1418_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1419_);
					_vala_ccode_node_unref0 (_tmp1419_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1420_;
				ValaCCodeConstant* _tmp1421_;
				_tmp1420_ = vala_ccode_constant_new ("NULL");
				_tmp1421_ = _tmp1420_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1421_);
				_vala_ccode_node_unref0 (_tmp1421_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1423_ = deleg;
	if (_tmp1423_ != NULL) {
		ValaDelegate* _tmp1424_;
		ValaDataType* _tmp1425_;
		ValaDataType* _tmp1426_;
		_tmp1424_ = deleg;
		_tmp1425_ = vala_callable_get_return_type ((ValaCallable*) _tmp1424_);
		_tmp1426_ = _tmp1425_;
		_tmp1422_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1426_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1422_ = FALSE;
	}
	if (_tmp1422_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1427_;
		ValaDataType* _tmp1428_;
		ValaDataType* _tmp1429_;
		ValaArrayType* _tmp1430_;
		_tmp1427_ = deleg;
		_tmp1428_ = vala_callable_get_return_type ((ValaCallable*) _tmp1427_);
		_tmp1429_ = _tmp1428_;
		_tmp1430_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1429_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1430_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1431_ = FALSE;
				_tmp1431_ = TRUE;
				while (TRUE) {
					gint _tmp1433_;
					ValaArrayType* _tmp1434_;
					gint _tmp1435_;
					gint _tmp1436_;
					ValaDelegate* _tmp1437_;
					if (!_tmp1431_) {
						gint _tmp1432_;
						_tmp1432_ = dim;
						dim = _tmp1432_ + 1;
					}
					_tmp1431_ = FALSE;
					_tmp1433_ = dim;
					_tmp1434_ = array_type;
					_tmp1435_ = vala_array_type_get_rank (_tmp1434_);
					_tmp1436_ = _tmp1435_;
					if (!(_tmp1433_ <= _tmp1436_)) {
						break;
					}
					_tmp1437_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1437_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1438_;
						ValaDataType* _tmp1439_;
						ValaDataType* _tmp1440_;
						ValaLocalVariable* _tmp1441_;
						ValaLocalVariable* _tmp1442_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1443_;
						const gchar* _tmp1444_;
						const gchar* _tmp1445_;
						ValaCCodeExpression* _tmp1446_;
						ValaLocalVariable* _tmp1447_;
						ValaCCodeExpression* _tmp1448_;
						ValaCCodeExpression* _tmp1449_;
						ValaCCodeAssignment* _tmp1450_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1451_;
						ValaCCodeIdentifier* _tmp1452_;
						ValaCCodeFunctionCall* _tmp1453_;
						ValaCCodeFunctionCall* _tmp1454_;
						ValaCCodeFunctionCall* _tmp1455_;
						ValaCCodeExpression* _tmp1456_;
						ValaCCodeFunctionCall* _tmp1457_;
						_tmp1438_ = itype;
						_tmp1439_ = vala_data_type_get_return_type (_tmp1438_);
						_tmp1440_ = _tmp1439_;
						_tmp1441_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1440_, TRUE, NULL, FALSE);
						_tmp1442_ = _tmp1441_;
						_vala_code_node_unref0 (_tmp1440_);
						temp_var = _tmp1442_;
						_tmp1443_ = temp_var;
						_tmp1444_ = vala_symbol_get_name ((ValaSymbol*) _tmp1443_);
						_tmp1445_ = _tmp1444_;
						_tmp1446_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1445_);
						temp_ref = _tmp1446_;
						_tmp1447_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1447_, FALSE);
						_tmp1448_ = temp_ref;
						_tmp1449_ = ccall_expr;
						_tmp1450_ = vala_ccode_assignment_new (_tmp1448_, _tmp1449_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1450_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1451_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1452_ = _tmp1451_;
						_tmp1453_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1452_);
						_tmp1454_ = _tmp1453_;
						_vala_ccode_node_unref0 (_tmp1452_);
						len_call = _tmp1454_;
						_tmp1455_ = len_call;
						_tmp1456_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1455_, _tmp1456_);
						_tmp1457_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1457_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1458_;
						_tmp1458_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1458_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaDataType* _tmp1459_;
							ValaLocalVariable* _tmp1460_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1461_;
							const gchar* _tmp1462_;
							const gchar* _tmp1463_;
							ValaCCodeExpression* _tmp1464_;
							ValaLocalVariable* _tmp1465_;
							ValaHashMap* _tmp1466_;
							ValaDelegate* _tmp1467_;
							gint _tmp1468_;
							ValaCCodeExpression* _tmp1469_;
							ValaCCodeUnaryExpression* _tmp1470_;
							ValaCCodeUnaryExpression* _tmp1471_;
							ValaCCodeExpression* _tmp1472_;
							_tmp1459_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1460_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1459_, TRUE, NULL, TRUE);
							temp_var = _tmp1460_;
							_tmp1461_ = temp_var;
							_tmp1462_ = vala_symbol_get_name ((ValaSymbol*) _tmp1461_);
							_tmp1463_ = _tmp1462_;
							_tmp1464_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1463_);
							temp_ref = _tmp1464_;
							_tmp1465_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1465_, FALSE);
							_tmp1466_ = out_arg_map;
							_tmp1467_ = deleg;
							_tmp1468_ = dim;
							_tmp1469_ = temp_ref;
							_tmp1470_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1469_);
							_tmp1471_ = _tmp1470_;
							vala_map_set ((ValaMap*) _tmp1466_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1467_) + (0.01 * _tmp1468_), FALSE)), (ValaCCodeExpression*) _tmp1471_);
							_vala_ccode_node_unref0 (_tmp1471_);
							_tmp1472_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1472_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1473_;
							ValaCCodeConstant* _tmp1474_;
							_tmp1473_ = vala_ccode_constant_new ("-1");
							_tmp1474_ = _tmp1473_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1474_);
							_vala_ccode_node_unref0 (_tmp1474_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1475_ = FALSE;
		ValaDelegate* _tmp1476_;
		_tmp1476_ = deleg;
		if (_tmp1476_ != NULL) {
			ValaDelegate* _tmp1477_;
			ValaDataType* _tmp1478_;
			ValaDataType* _tmp1479_;
			_tmp1477_ = deleg;
			_tmp1478_ = vala_callable_get_return_type ((ValaCallable*) _tmp1477_);
			_tmp1479_ = _tmp1478_;
			_tmp1475_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1479_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1475_ = FALSE;
		}
		if (_tmp1475_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1480_;
			ValaDataType* _tmp1481_;
			ValaDataType* _tmp1482_;
			ValaDelegateType* _tmp1483_;
			ValaDelegateType* _tmp1484_;
			ValaDelegate* _tmp1485_;
			ValaDelegate* _tmp1486_;
			gboolean _tmp1487_;
			gboolean _tmp1488_;
			_tmp1480_ = deleg;
			_tmp1481_ = vala_callable_get_return_type ((ValaCallable*) _tmp1480_);
			_tmp1482_ = _tmp1481_;
			_tmp1483_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1482_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1483_;
			_tmp1484_ = deleg_type;
			_tmp1485_ = vala_delegate_type_get_delegate_symbol (_tmp1484_);
			_tmp1486_ = _tmp1485_;
			_tmp1487_ = vala_delegate_get_has_target (_tmp1486_);
			_tmp1488_ = _tmp1487_;
			if (_tmp1488_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1489_;
				ValaVoidType* _tmp1490_;
				ValaPointerType* _tmp1491_;
				ValaPointerType* _tmp1492_;
				ValaLocalVariable* _tmp1493_;
				ValaLocalVariable* _tmp1494_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1495_;
				const gchar* _tmp1496_;
				const gchar* _tmp1497_;
				ValaCCodeExpression* _tmp1498_;
				ValaLocalVariable* _tmp1499_;
				ValaHashMap* _tmp1500_;
				ValaDelegate* _tmp1501_;
				ValaCCodeExpression* _tmp1502_;
				ValaCCodeUnaryExpression* _tmp1503_;
				ValaCCodeUnaryExpression* _tmp1504_;
				ValaCCodeExpression* _tmp1505_;
				ValaDelegateType* _tmp1506_;
				_tmp1489_ = vala_void_type_new (NULL);
				_tmp1490_ = _tmp1489_;
				_tmp1491_ = vala_pointer_type_new ((ValaDataType*) _tmp1490_, NULL);
				_tmp1492_ = _tmp1491_;
				_tmp1493_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1492_, TRUE, NULL, TRUE);
				_tmp1494_ = _tmp1493_;
				_vala_code_node_unref0 (_tmp1492_);
				_vala_code_node_unref0 (_tmp1490_);
				temp_var = _tmp1494_;
				_tmp1495_ = temp_var;
				_tmp1496_ = vala_symbol_get_name ((ValaSymbol*) _tmp1495_);
				_tmp1497_ = _tmp1496_;
				_tmp1498_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1497_);
				temp_ref = _tmp1498_;
				_tmp1499_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1499_, FALSE);
				_tmp1500_ = out_arg_map;
				_tmp1501_ = deleg;
				_tmp1502_ = temp_ref;
				_tmp1503_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1502_);
				_tmp1504_ = _tmp1503_;
				vala_map_set ((ValaMap*) _tmp1500_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1501_), FALSE)), (ValaCCodeExpression*) _tmp1504_);
				_vala_ccode_node_unref0 (_tmp1504_);
				_tmp1505_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1505_);
				_tmp1506_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1506_)) {
					ValaDataType* _tmp1507_;
					ValaLocalVariable* _tmp1508_;
					ValaLocalVariable* _tmp1509_;
					const gchar* _tmp1510_;
					const gchar* _tmp1511_;
					ValaCCodeExpression* _tmp1512_;
					ValaLocalVariable* _tmp1513_;
					ValaHashMap* _tmp1514_;
					ValaDelegate* _tmp1515_;
					ValaCCodeExpression* _tmp1516_;
					ValaCCodeUnaryExpression* _tmp1517_;
					ValaCCodeUnaryExpression* _tmp1518_;
					ValaCCodeExpression* _tmp1519_;
					_tmp1507_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1508_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1507_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1508_;
					_tmp1509_ = temp_var;
					_tmp1510_ = vala_symbol_get_name ((ValaSymbol*) _tmp1509_);
					_tmp1511_ = _tmp1510_;
					_tmp1512_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1511_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1512_;
					_tmp1513_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1513_, FALSE);
					_tmp1514_ = out_arg_map;
					_tmp1515_ = deleg;
					_tmp1516_ = temp_ref;
					_tmp1517_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1516_);
					_tmp1518_ = _tmp1517_;
					vala_map_set ((ValaMap*) _tmp1514_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1515_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1518_);
					_vala_ccode_node_unref0 (_tmp1518_);
					_tmp1519_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1519_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1521_ = m;
	if (_tmp1521_ != NULL) {
		ValaMethod* _tmp1522_;
		gboolean _tmp1523_;
		gboolean _tmp1524_;
		_tmp1522_ = m;
		_tmp1523_ = vala_method_get_coroutine (_tmp1522_);
		_tmp1524_ = _tmp1523_;
		_tmp1520_ = _tmp1524_;
	} else {
		_tmp1520_ = FALSE;
	}
	if (_tmp1520_) {
		gboolean _tmp1525_;
		gboolean _tmp1526_;
		_tmp1525_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1526_ = _tmp1525_;
		if (_tmp1526_) {
			ValaHashMap* _tmp1527_;
			ValaMethod* _tmp1528_;
			ValaMethod* _tmp1529_;
			gchar* _tmp1530_;
			gchar* _tmp1531_;
			ValaCCodeIdentifier* _tmp1532_;
			ValaCCodeIdentifier* _tmp1533_;
			ValaHashMap* _tmp1534_;
			ValaCCodeIdentifier* _tmp1535_;
			ValaCCodeIdentifier* _tmp1536_;
			_tmp1527_ = in_arg_map;
			_tmp1528_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1529_ = _tmp1528_;
			_tmp1530_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1529_);
			_tmp1531_ = _tmp1530_;
			_tmp1532_ = vala_ccode_identifier_new (_tmp1531_);
			_tmp1533_ = _tmp1532_;
			vala_map_set ((ValaMap*) _tmp1527_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1533_);
			_vala_ccode_node_unref0 (_tmp1533_);
			_g_free0 (_tmp1531_);
			_tmp1534_ = in_arg_map;
			_tmp1535_ = vala_ccode_identifier_new ("_data_");
			_tmp1536_ = _tmp1535_;
			vala_map_set ((ValaMap*) _tmp1534_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1536_);
			_vala_ccode_node_unref0 (_tmp1536_);
		}
	}
	_tmp1537_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1538_ = _tmp1537_;
	if (_tmp1538_) {
		ValaHashMap* _tmp1539_;
		ValaCCodeExpression* _tmp1540_;
		ValaCCodeExpression* _tmp1541_;
		ValaCCodeUnaryExpression* _tmp1542_;
		ValaCCodeUnaryExpression* _tmp1543_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1539_ = out_arg_map;
		_tmp1540_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1541_ = _tmp1540_;
		_tmp1542_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1541_);
		_tmp1543_ = _tmp1542_;
		vala_map_set ((ValaMap*) _tmp1539_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1543_);
		_vala_ccode_node_unref0 (_tmp1543_);
		_vala_ccode_node_unref0 (_tmp1541_);
	} else {
		gboolean _tmp1544_ = FALSE;
		gboolean _tmp1545_ = FALSE;
		ValaMethod* _tmp1546_;
		_tmp1546_ = m;
		if (_tmp1546_ != NULL) {
			ValaMethod* _tmp1547_;
			_tmp1547_ = m;
			_tmp1545_ = vala_method_has_error_type_parameter (_tmp1547_);
		} else {
			_tmp1545_ = FALSE;
		}
		if (_tmp1545_) {
			ValaCCodeFunctionCall* _tmp1548_;
			ValaCCodeFunctionCall* _tmp1549_;
			_tmp1548_ = async_call;
			_tmp1549_ = ccall;
			_tmp1544_ = _tmp1548_ != _tmp1549_;
		} else {
			_tmp1544_ = FALSE;
		}
		if (_tmp1544_) {
			ValaHashMap* _tmp1550_;
			ValaCCodeConstant* _tmp1551_;
			ValaCCodeConstant* _tmp1552_;
			_tmp1550_ = out_arg_map;
			_tmp1551_ = vala_ccode_constant_new ("NULL");
			_tmp1552_ = _tmp1551_;
			vala_map_set ((ValaMap*) _tmp1550_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1552_);
			_vala_ccode_node_unref0 (_tmp1552_);
		}
	}
	_tmp1553_ = ellipsis;
	if (_tmp1553_) {
		ValaMethod* _tmp1554_;
		_tmp1554_ = m;
		if (_tmp1554_ == NULL) {
			ValaHashMap* _tmp1555_;
			ValaCCodeConstant* _tmp1556_;
			ValaCCodeConstant* _tmp1557_;
			_tmp1555_ = in_arg_map;
			_tmp1556_ = vala_ccode_constant_new ("NULL");
			_tmp1557_ = _tmp1556_;
			vala_map_set ((ValaMap*) _tmp1555_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1557_);
			_vala_ccode_node_unref0 (_tmp1557_);
		} else {
			gboolean _tmp1558_ = FALSE;
			gboolean _tmp1559_ = FALSE;
			gboolean _tmp1560_ = FALSE;
			ValaMethod* _tmp1561_;
			gboolean _tmp1562_;
			gboolean _tmp1563_;
			_tmp1561_ = m;
			_tmp1562_ = vala_method_get_printf_format (_tmp1561_);
			_tmp1563_ = _tmp1562_;
			if (!_tmp1563_) {
				ValaMethod* _tmp1564_;
				gboolean _tmp1565_;
				gboolean _tmp1566_;
				_tmp1564_ = m;
				_tmp1565_ = vala_method_get_scanf_format (_tmp1564_);
				_tmp1566_ = _tmp1565_;
				_tmp1560_ = !_tmp1566_;
			} else {
				_tmp1560_ = FALSE;
			}
			if (_tmp1560_) {
				ValaMethod* _tmp1567_;
				gchar* _tmp1568_;
				gchar* _tmp1569_;
				_tmp1567_ = m;
				_tmp1568_ = vala_get_ccode_sentinel (_tmp1567_);
				_tmp1569_ = _tmp1568_;
				_tmp1559_ = g_strcmp0 (_tmp1569_, "") != 0;
				_g_free0 (_tmp1569_);
			} else {
				_tmp1559_ = FALSE;
			}
			if (_tmp1559_) {
				gboolean _tmp1570_;
				gboolean _tmp1571_;
				_tmp1570_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1571_ = _tmp1570_;
				_tmp1558_ = !_tmp1571_;
			} else {
				_tmp1558_ = FALSE;
			}
			if (_tmp1558_) {
				ValaHashMap* _tmp1572_;
				ValaMethod* _tmp1573_;
				gchar* _tmp1574_;
				gchar* _tmp1575_;
				ValaCCodeConstant* _tmp1576_;
				ValaCCodeConstant* _tmp1577_;
				_tmp1572_ = in_arg_map;
				_tmp1573_ = m;
				_tmp1574_ = vala_get_ccode_sentinel (_tmp1573_);
				_tmp1575_ = _tmp1574_;
				_tmp1576_ = vala_ccode_constant_new (_tmp1575_);
				_tmp1577_ = _tmp1576_;
				vala_map_set ((ValaMap*) _tmp1572_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1577_);
				_vala_ccode_node_unref0 (_tmp1577_);
				_g_free0 (_tmp1575_);
			}
		}
	}
	_tmp1578_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1578_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1579_;
		ValaDelegateType* _tmp1580_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1581_;
		ValaDelegate* _tmp1582_;
		ValaDelegate* _tmp1583_;
		ValaDelegate* _tmp1584_;
		ValaDelegate* _tmp1585_;
		gboolean _tmp1586_;
		gboolean _tmp1587_;
		_tmp1579_ = itype;
		_tmp1580_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1579_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1580_;
		_tmp1581_ = deleg_type;
		_tmp1582_ = vala_delegate_type_get_delegate_symbol (_tmp1581_);
		_tmp1583_ = _tmp1582_;
		_tmp1584_ = _vala_code_node_ref0 (_tmp1583_);
		d = _tmp1584_;
		_tmp1585_ = d;
		_tmp1586_ = vala_delegate_get_has_target (_tmp1585_);
		_tmp1587_ = _tmp1586_;
		if (_tmp1587_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1588_;
			ValaDelegate* _tmp1589_;
			ValaExpression* _tmp1590_;
			ValaExpression* _tmp1591_;
			ValaCCodeExpression* _tmp1592_ = NULL;
			ValaCCodeExpression* _tmp1593_;
			ValaCCodeExpression* _tmp1594_;
			ValaHashMap* _tmp1595_;
			ValaDelegate* _tmp1596_;
			ValaExpression* _tmp1597_;
			ValaExpression* _tmp1598_;
			ValaCCodeExpression* _tmp1599_ = NULL;
			ValaCCodeExpression* _tmp1600_;
			ValaCCodeExpression* _tmp1601_;
			_tmp1588_ = in_arg_map;
			_tmp1589_ = d;
			_tmp1590_ = vala_method_call_get_call (expr);
			_tmp1591_ = _tmp1590_;
			_tmp1593_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1591_, &_tmp1592_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1592_;
			_tmp1594_ = _tmp1593_;
			vala_map_set ((ValaMap*) _tmp1588_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1589_), FALSE)), _tmp1594_);
			_vala_ccode_node_unref0 (_tmp1594_);
			_tmp1595_ = out_arg_map;
			_tmp1596_ = d;
			_tmp1597_ = vala_method_call_get_call (expr);
			_tmp1598_ = _tmp1597_;
			_tmp1600_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1598_, &_tmp1599_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1599_;
			_tmp1601_ = _tmp1600_;
			vala_map_set ((ValaMap*) _tmp1595_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1596_), FALSE)), _tmp1601_);
			_vala_ccode_node_unref0 (_tmp1601_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1602_ = itype;
	_tmp1603_ = vala_data_type_get_return_type (_tmp1602_);
	_tmp1604_ = _tmp1603_;
	_tmp1605_ = vala_data_type_is_real_non_null_struct_type (_tmp1604_);
	_vala_code_node_unref0 (_tmp1604_);
	return_result_via_out_param = _tmp1605_;
	_tmp1607_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1607_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1608_;
		ValaDataType* _tmp1609_;
		ValaDataType* _tmp1610_;
		_tmp1608_ = itype;
		_tmp1609_ = vala_data_type_get_return_type (_tmp1608_);
		_tmp1610_ = _tmp1609_;
		_tmp1606_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1610_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1610_);
	} else {
		_tmp1606_ = FALSE;
	}
	if (_tmp1606_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1611_;
		ValaSignal* _tmp1612_;
		ValaSignal* _tmp1613_;
		ValaSignal* _tmp1614_;
		gboolean _tmp1615_ = FALSE;
		gboolean _tmp1616_ = FALSE;
		ValaMemberAccess* _tmp1617_;
		_tmp1611_ = itype;
		_tmp1612_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1611_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1613_ = _tmp1612_;
		_tmp1614_ = _vala_code_node_ref0 (_tmp1613_);
		sig = _tmp1614_;
		_tmp1617_ = ma;
		if (_tmp1617_ != NULL) {
			ValaMemberAccess* _tmp1618_;
			ValaExpression* _tmp1619_;
			ValaExpression* _tmp1620_;
			_tmp1618_ = ma;
			_tmp1619_ = vala_member_access_get_inner (_tmp1618_);
			_tmp1620_ = _tmp1619_;
			_tmp1616_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1620_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1616_ = FALSE;
		}
		if (_tmp1616_) {
			ValaSignal* _tmp1621_;
			gboolean _tmp1622_;
			gboolean _tmp1623_;
			_tmp1621_ = sig;
			_tmp1622_ = vala_signal_get_is_virtual (_tmp1621_);
			_tmp1623_ = _tmp1622_;
			_tmp1615_ = _tmp1623_;
		} else {
			_tmp1615_ = FALSE;
		}
		if (_tmp1615_) {
		} else {
			gboolean _tmp1624_ = FALSE;
			ValaSignal* _tmp1625_;
			_tmp1625_ = sig;
			if (!vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp1625_)) {
				_tmp1624_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1626_;
				ValaSourceReference* _tmp1627_;
				ValaSourceReference* _tmp1628_;
				ValaSourceFile* _tmp1629_;
				ValaSourceFile* _tmp1630_;
				ValaSignal* _tmp1631_;
				ValaSourceReference* _tmp1632_;
				ValaSourceReference* _tmp1633_;
				ValaSourceFile* _tmp1634_;
				ValaSourceFile* _tmp1635_;
				_tmp1626_ = ma;
				_tmp1627_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1626_);
				_tmp1628_ = _tmp1627_;
				_tmp1629_ = vala_source_reference_get_file (_tmp1628_);
				_tmp1630_ = _tmp1629_;
				_tmp1631_ = sig;
				_tmp1632_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1631_);
				_tmp1633_ = _tmp1632_;
				_tmp1634_ = vala_source_reference_get_file (_tmp1633_);
				_tmp1635_ = _tmp1634_;
				_tmp1624_ = _tmp1630_ == _tmp1635_;
			}
			if (_tmp1624_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1636_ = async_call;
	_tmp1637_ = ccall;
	if (_tmp1636_ == _tmp1637_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	_tmp1638_ = return_result_via_out_param;
	if (_tmp1638_) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1639_;
		ValaDataType* _tmp1640_;
		ValaDataType* _tmp1641_;
		ValaLocalVariable* _tmp1642_;
		ValaLocalVariable* _tmp1643_;
		ValaLocalVariable* _tmp1644_;
		const gchar* _tmp1645_;
		const gchar* _tmp1646_;
		ValaCCodeExpression* _tmp1647_;
		ValaLocalVariable* _tmp1648_;
		ValaHashMap* _tmp1649_;
		ValaCCodeExpression* _tmp1650_;
		ValaCCodeUnaryExpression* _tmp1651_;
		ValaCCodeUnaryExpression* _tmp1652_;
		_tmp1639_ = itype;
		_tmp1640_ = vala_data_type_get_return_type (_tmp1639_);
		_tmp1641_ = _tmp1640_;
		_tmp1642_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1641_, TRUE, NULL, TRUE);
		_tmp1643_ = _tmp1642_;
		_vala_code_node_unref0 (_tmp1641_);
		out_param_var = _tmp1643_;
		_tmp1644_ = out_param_var;
		_tmp1645_ = vala_symbol_get_name ((ValaSymbol*) _tmp1644_);
		_tmp1646_ = _tmp1645_;
		_tmp1647_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1646_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1647_;
		_tmp1648_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1648_, FALSE);
		_tmp1649_ = out_arg_map;
		_tmp1650_ = out_param_ref;
		_tmp1651_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1650_);
		_tmp1652_ = _tmp1651_;
		vala_map_set ((ValaMap*) _tmp1649_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1652_);
		_vala_ccode_node_unref0 (_tmp1652_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1653_ = async_call;
	_tmp1654_ = ccall;
	if (_tmp1653_ != _tmp1654_) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1671_;
			ValaCCodeFunctionCall* _tmp1672_;
			ValaHashMap* _tmp1673_;
			gint _tmp1674_;
			gpointer _tmp1675_;
			ValaCCodeExpression* _tmp1676_;
			gint _tmp1677_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1655_;
				ValaSet* _tmp1656_;
				ValaSet* _tmp1657_;
				ValaIterator* _tmp1658_;
				ValaIterator* _tmp1659_;
				_tmp1655_ = out_arg_map;
				_tmp1656_ = vala_map_get_keys ((ValaMap*) _tmp1655_);
				_tmp1657_ = _tmp1656_;
				_tmp1658_ = vala_iterable_iterator ((ValaIterable*) _tmp1657_);
				_tmp1659_ = _tmp1658_;
				_vala_iterable_unref0 (_tmp1657_);
				_pos_it = _tmp1659_;
				while (TRUE) {
					ValaIterator* _tmp1660_;
					gint pos = 0;
					ValaIterator* _tmp1661_;
					gpointer _tmp1662_;
					gboolean _tmp1663_ = FALSE;
					gint _tmp1664_;
					gint _tmp1665_;
					_tmp1660_ = _pos_it;
					if (!vala_iterator_next (_tmp1660_)) {
						break;
					}
					_tmp1661_ = _pos_it;
					_tmp1662_ = vala_iterator_get (_tmp1661_);
					pos = (gint) ((gintptr) _tmp1662_);
					_tmp1664_ = pos;
					_tmp1665_ = last_pos;
					if (_tmp1664_ > _tmp1665_) {
						gboolean _tmp1666_ = FALSE;
						gint _tmp1667_;
						_tmp1667_ = min_pos;
						if (_tmp1667_ == -1) {
							_tmp1666_ = TRUE;
						} else {
							gint _tmp1668_;
							gint _tmp1669_;
							_tmp1668_ = pos;
							_tmp1669_ = min_pos;
							_tmp1666_ = _tmp1668_ < _tmp1669_;
						}
						_tmp1663_ = _tmp1666_;
					} else {
						_tmp1663_ = FALSE;
					}
					if (_tmp1663_) {
						gint _tmp1670_;
						_tmp1670_ = pos;
						min_pos = _tmp1670_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1671_ = min_pos;
			if (_tmp1671_ == -1) {
				break;
			}
			_tmp1672_ = ccall;
			_tmp1673_ = out_arg_map;
			_tmp1674_ = min_pos;
			_tmp1675_ = vala_map_get ((ValaMap*) _tmp1673_, (gpointer) ((gintptr) _tmp1674_));
			_tmp1676_ = (ValaCCodeExpression*) _tmp1675_;
			vala_ccode_function_call_add_argument (_tmp1672_, _tmp1676_);
			_vala_ccode_node_unref0 (_tmp1676_);
			_tmp1677_ = min_pos;
			last_pos = _tmp1677_;
		}
	}
	_tmp1678_ = async_call;
	if (_tmp1678_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1695_;
			ValaCCodeFunctionCall* _tmp1696_;
			ValaHashMap* _tmp1697_;
			gint _tmp1698_;
			gpointer _tmp1699_;
			ValaCCodeExpression* _tmp1700_;
			gint _tmp1701_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1679_;
				ValaSet* _tmp1680_;
				ValaSet* _tmp1681_;
				ValaIterator* _tmp1682_;
				ValaIterator* _tmp1683_;
				_tmp1679_ = in_arg_map;
				_tmp1680_ = vala_map_get_keys ((ValaMap*) _tmp1679_);
				_tmp1681_ = _tmp1680_;
				_tmp1682_ = vala_iterable_iterator ((ValaIterable*) _tmp1681_);
				_tmp1683_ = _tmp1682_;
				_vala_iterable_unref0 (_tmp1681_);
				_pos_it = _tmp1683_;
				while (TRUE) {
					ValaIterator* _tmp1684_;
					gint pos = 0;
					ValaIterator* _tmp1685_;
					gpointer _tmp1686_;
					gboolean _tmp1687_ = FALSE;
					gint _tmp1688_;
					gint _tmp1689_;
					_tmp1684_ = _pos_it;
					if (!vala_iterator_next (_tmp1684_)) {
						break;
					}
					_tmp1685_ = _pos_it;
					_tmp1686_ = vala_iterator_get (_tmp1685_);
					pos = (gint) ((gintptr) _tmp1686_);
					_tmp1688_ = pos;
					_tmp1689_ = last_pos;
					if (_tmp1688_ > _tmp1689_) {
						gboolean _tmp1690_ = FALSE;
						gint _tmp1691_;
						_tmp1691_ = min_pos;
						if (_tmp1691_ == -1) {
							_tmp1690_ = TRUE;
						} else {
							gint _tmp1692_;
							gint _tmp1693_;
							_tmp1692_ = pos;
							_tmp1693_ = min_pos;
							_tmp1690_ = _tmp1692_ < _tmp1693_;
						}
						_tmp1687_ = _tmp1690_;
					} else {
						_tmp1687_ = FALSE;
					}
					if (_tmp1687_) {
						gint _tmp1694_;
						_tmp1694_ = pos;
						min_pos = _tmp1694_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1695_ = min_pos;
			if (_tmp1695_ == -1) {
				break;
			}
			_tmp1696_ = async_call;
			_tmp1697_ = in_arg_map;
			_tmp1698_ = min_pos;
			_tmp1699_ = vala_map_get ((ValaMap*) _tmp1697_, (gpointer) ((gintptr) _tmp1698_));
			_tmp1700_ = (ValaCCodeExpression*) _tmp1699_;
			vala_ccode_function_call_add_argument (_tmp1696_, _tmp1700_);
			_vala_ccode_node_unref0 (_tmp1700_);
			_tmp1701_ = min_pos;
			last_pos = _tmp1701_;
		}
	}
	_tmp1702_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1703_ = _tmp1702_;
	if (_tmp1703_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1704_;
		gint _tmp1705_;
		ValaCCodeFunction* _tmp1706_;
		ValaCCodeFunction* _tmp1707_;
		ValaCCodeIdentifier* _tmp1708_;
		ValaCCodeIdentifier* _tmp1709_;
		ValaCCodeMemberAccess* _tmp1710_;
		ValaCCodeMemberAccess* _tmp1711_;
		gint _tmp1712_;
		gchar* _tmp1713_;
		gchar* _tmp1714_;
		ValaCCodeConstant* _tmp1715_;
		ValaCCodeConstant* _tmp1716_;
		ValaCCodeFunction* _tmp1717_;
		ValaCCodeFunction* _tmp1718_;
		ValaCCodeFunctionCall* _tmp1719_;
		ValaCCodeFunction* _tmp1720_;
		ValaCCodeFunction* _tmp1721_;
		ValaCCodeConstant* _tmp1722_;
		ValaCCodeConstant* _tmp1723_;
		ValaCCodeFunction* _tmp1724_;
		ValaCCodeFunction* _tmp1725_;
		gint _tmp1726_;
		gchar* _tmp1727_;
		gchar* _tmp1728_;
		_tmp1704_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1705_ = _tmp1704_->next_coroutine_state;
		_tmp1704_->next_coroutine_state = _tmp1705_ + 1;
		state = _tmp1705_;
		_tmp1706_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1707_ = _tmp1706_;
		_tmp1708_ = vala_ccode_identifier_new ("_data_");
		_tmp1709_ = _tmp1708_;
		_tmp1710_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1709_, "_state_");
		_tmp1711_ = _tmp1710_;
		_tmp1712_ = state;
		_tmp1713_ = g_strdup_printf ("%i", _tmp1712_);
		_tmp1714_ = _tmp1713_;
		_tmp1715_ = vala_ccode_constant_new (_tmp1714_);
		_tmp1716_ = _tmp1715_;
		vala_ccode_function_add_assignment (_tmp1707_, (ValaCCodeExpression*) _tmp1711_, (ValaCCodeExpression*) _tmp1716_);
		_vala_ccode_node_unref0 (_tmp1716_);
		_g_free0 (_tmp1714_);
		_vala_ccode_node_unref0 (_tmp1711_);
		_vala_ccode_node_unref0 (_tmp1709_);
		_tmp1717_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1718_ = _tmp1717_;
		_tmp1719_ = async_call;
		vala_ccode_function_add_expression (_tmp1718_, (ValaCCodeExpression*) _tmp1719_);
		_tmp1720_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1721_ = _tmp1720_;
		_tmp1722_ = vala_ccode_constant_new ("FALSE");
		_tmp1723_ = _tmp1722_;
		vala_ccode_function_add_return (_tmp1721_, (ValaCCodeExpression*) _tmp1723_);
		_vala_ccode_node_unref0 (_tmp1723_);
		_tmp1724_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1725_ = _tmp1724_;
		_tmp1726_ = state;
		_tmp1727_ = g_strdup_printf ("_state_%d", _tmp1726_);
		_tmp1728_ = _tmp1727_;
		vala_ccode_function_add_label (_tmp1725_, _tmp1728_);
		_g_free0 (_tmp1728_);
	}
	_tmp1729_ = vala_method_call_get_is_assert (expr);
	_tmp1730_ = _tmp1729_;
	if (_tmp1730_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1731_;
		ValaSourceReference* _tmp1732_;
		ValaSourceLocation _tmp1733_ = {0};
		ValaSourceLocation _tmp1734_;
		gchar* _tmp1735_;
		ValaSourceReference* _tmp1736_;
		ValaSourceReference* _tmp1737_;
		ValaSourceLocation _tmp1738_ = {0};
		ValaSourceLocation _tmp1739_;
		gchar* _tmp1740_;
		ValaSourceReference* _tmp1741_;
		ValaSourceReference* _tmp1742_;
		ValaSourceLocation _tmp1743_ = {0};
		ValaSourceLocation _tmp1744_;
		gchar* _tmp1745_;
		gchar* _tmp1746_;
		ValaCCodeFunctionCall* _tmp1747_;
		ValaCCodeIdentifier* _tmp1748_;
		ValaCCodeIdentifier* _tmp1749_;
		ValaCCodeFunctionCall* _tmp1750_;
		const gchar* _tmp1751_;
		gchar* _tmp1752_;
		gchar* _tmp1753_;
		gchar* _tmp1754_;
		gchar* _tmp1755_;
		gchar* _tmp1756_;
		gchar* _tmp1757_;
		ValaCCodeConstant* _tmp1758_;
		ValaCCodeConstant* _tmp1759_;
		_tmp1731_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1732_ = _tmp1731_;
		vala_source_reference_get_begin (_tmp1732_, &_tmp1733_);
		_tmp1734_ = _tmp1733_;
		_tmp1735_ = _tmp1734_.pos;
		_tmp1736_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1737_ = _tmp1736_;
		vala_source_reference_get_end (_tmp1737_, &_tmp1738_);
		_tmp1739_ = _tmp1738_;
		_tmp1740_ = _tmp1739_.pos;
		_tmp1741_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1742_ = _tmp1741_;
		vala_source_reference_get_begin (_tmp1742_, &_tmp1743_);
		_tmp1744_ = _tmp1743_;
		_tmp1745_ = _tmp1744_.pos;
		_tmp1746_ = string_substring ((const gchar*) _tmp1735_, (glong) 0, (glong) ((gint) (_tmp1740_ - _tmp1745_)));
		message = _tmp1746_;
		_tmp1747_ = ccall;
		_tmp1748_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1749_ = _tmp1748_;
		vala_ccode_function_call_set_call (_tmp1747_, (ValaCCodeExpression*) _tmp1749_);
		_vala_ccode_node_unref0 (_tmp1749_);
		_tmp1750_ = ccall;
		_tmp1751_ = message;
		_tmp1752_ = string_replace (_tmp1751_, "\n", " ");
		_tmp1753_ = _tmp1752_;
		_tmp1754_ = g_strescape (_tmp1753_, "");
		_tmp1755_ = _tmp1754_;
		_tmp1756_ = g_strdup_printf ("\"%s\"", _tmp1755_);
		_tmp1757_ = _tmp1756_;
		_tmp1758_ = vala_ccode_constant_new (_tmp1757_);
		_tmp1759_ = _tmp1758_;
		vala_ccode_function_call_add_argument (_tmp1750_, (ValaCCodeExpression*) _tmp1759_);
		_vala_ccode_node_unref0 (_tmp1759_);
		_g_free0 (_tmp1757_);
		_g_free0 (_tmp1755_);
		_g_free0 (_tmp1753_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	_tmp1760_ = return_result_via_out_param;
	if (_tmp1760_) {
		ValaCCodeFunction* _tmp1761_;
		ValaCCodeFunction* _tmp1762_;
		ValaCCodeExpression* _tmp1763_;
		ValaCCodeExpression* _tmp1764_;
		ValaCCodeExpression* _tmp1765_;
		_tmp1761_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1762_ = _tmp1761_;
		_tmp1763_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1762_, _tmp1763_);
		_tmp1764_ = out_param_ref;
		_tmp1765_ = _vala_ccode_node_ref0 (_tmp1764_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1765_;
	}
	_tmp1768_ = m;
	if (_tmp1768_ != NULL) {
		ValaMethod* _tmp1769_;
		ValaMemberBinding _tmp1770_;
		ValaMemberBinding _tmp1771_;
		_tmp1769_ = m;
		_tmp1770_ = vala_method_get_binding (_tmp1769_);
		_tmp1771_ = _tmp1770_;
		_tmp1767_ = _tmp1771_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1767_ = FALSE;
	}
	if (_tmp1767_) {
		ValaMethod* _tmp1772_;
		gboolean _tmp1773_;
		gboolean _tmp1774_;
		_tmp1772_ = m;
		_tmp1773_ = vala_method_get_returns_modified_pointer (_tmp1772_);
		_tmp1774_ = _tmp1773_;
		_tmp1766_ = _tmp1774_;
	} else {
		_tmp1766_ = FALSE;
	}
	if (_tmp1766_) {
		gboolean _tmp1775_ = FALSE;
		gboolean _tmp1776_ = FALSE;
		ValaMemberAccess* _tmp1777_;
		_tmp1777_ = ma;
		if (_tmp1777_ != NULL) {
			ValaMemberAccess* _tmp1778_;
			ValaExpression* _tmp1779_;
			ValaExpression* _tmp1780_;
			ValaSymbol* _tmp1781_;
			ValaSymbol* _tmp1782_;
			_tmp1778_ = ma;
			_tmp1779_ = vala_member_access_get_inner (_tmp1778_);
			_tmp1780_ = _tmp1779_;
			_tmp1781_ = vala_expression_get_symbol_reference (_tmp1780_);
			_tmp1782_ = _tmp1781_;
			_tmp1776_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1782_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1776_ = FALSE;
		}
		if (_tmp1776_) {
			ValaMemberAccess* _tmp1783_;
			ValaExpression* _tmp1784_;
			ValaExpression* _tmp1785_;
			_tmp1783_ = ma;
			_tmp1784_ = vala_member_access_get_inner (_tmp1783_);
			_tmp1785_ = _tmp1784_;
			_tmp1775_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1785_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1775_ = FALSE;
		}
		if (_tmp1775_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1786_;
			ValaExpression* _tmp1787_;
			ValaExpression* _tmp1788_;
			ValaSymbol* _tmp1789_;
			ValaSymbol* _tmp1790_;
			ValaProperty* _tmp1791_;
			ValaProperty* _tmp1792_;
			ValaMemberAccess* _tmp1793_;
			ValaExpression* _tmp1794_;
			ValaExpression* _tmp1795_;
			ValaExpression* _tmp1796_;
			ValaExpression* _tmp1797_;
			ValaDataType* _tmp1798_;
			ValaDataType* _tmp1799_;
			ValaCCodeExpression* _tmp1800_;
			ValaGLibValue* _tmp1801_;
			ValaGLibValue* _tmp1802_;
			_tmp1786_ = ma;
			_tmp1787_ = vala_member_access_get_inner (_tmp1786_);
			_tmp1788_ = _tmp1787_;
			_tmp1789_ = vala_expression_get_symbol_reference (_tmp1788_);
			_tmp1790_ = _tmp1789_;
			_tmp1791_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1790_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1791_;
			_tmp1792_ = prop;
			_tmp1793_ = ma;
			_tmp1794_ = vala_member_access_get_inner (_tmp1793_);
			_tmp1795_ = _tmp1794_;
			_tmp1796_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1795_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1797_ = _tmp1796_;
			_tmp1798_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1799_ = _tmp1798_;
			_tmp1800_ = ccall_expr;
			_tmp1801_ = vala_glib_value_new (_tmp1799_, _tmp1800_, FALSE);
			_tmp1802_ = _tmp1801_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1792_, _tmp1797_, (ValaTargetValue*) _tmp1802_);
			_vala_target_value_unref0 (_tmp1802_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1803_;
			ValaCCodeExpression* _tmp1804_;
			ValaCCodeAssignment* _tmp1805_;
			_tmp1803_ = instance;
			_tmp1804_ = ccall_expr;
			_tmp1805_ = vala_ccode_assignment_new (_tmp1803_, _tmp1804_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1805_;
		}
	}
	_tmp1811_ = m;
	if (_tmp1811_ != NULL) {
		ValaMethod* _tmp1812_;
		_tmp1812_ = m;
		_tmp1810_ = vala_get_ccode_simple_generics (_tmp1812_);
	} else {
		_tmp1810_ = FALSE;
	}
	if (_tmp1810_) {
		ValaMethod* _tmp1813_;
		ValaDataType* _tmp1814_;
		ValaDataType* _tmp1815_;
		_tmp1813_ = m;
		_tmp1814_ = vala_callable_get_return_type ((ValaCallable*) _tmp1813_);
		_tmp1815_ = _tmp1814_;
		_tmp1809_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1815_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1809_ = FALSE;
	}
	if (_tmp1809_) {
		ValaDataType* _tmp1816_;
		ValaDataType* _tmp1817_;
		_tmp1816_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1817_ = _tmp1816_;
		_tmp1808_ = vala_data_type_is_real_struct_type (_tmp1817_);
	} else {
		_tmp1808_ = FALSE;
	}
	if (_tmp1808_) {
		ValaDataType* _tmp1818_;
		ValaDataType* _tmp1819_;
		gboolean _tmp1820_;
		gboolean _tmp1821_;
		_tmp1818_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1819_ = _tmp1818_;
		_tmp1820_ = vala_data_type_get_nullable (_tmp1819_);
		_tmp1821_ = _tmp1820_;
		_tmp1807_ = !_tmp1821_;
	} else {
		_tmp1807_ = FALSE;
	}
	if (_tmp1807_) {
		ValaDataType* _tmp1822_;
		ValaDataType* _tmp1823_;
		_tmp1822_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1823_ = _tmp1822_;
		_tmp1806_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1823_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1806_ = FALSE;
	}
	if (_tmp1806_) {
		ValaCCodeExpression* _tmp1824_;
		ValaCCodeParenthesizedExpression* _tmp1825_;
		ValaCCodeParenthesizedExpression* _tmp1826_;
		ValaCCodeUnaryExpression* _tmp1827_;
		_tmp1824_ = ccall_expr;
		_tmp1825_ = vala_ccode_parenthesized_expression_new (_tmp1824_);
		_tmp1826_ = _tmp1825_;
		_tmp1827_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1826_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1827_;
		_vala_ccode_node_unref0 (_tmp1826_);
	}
	_tmp1830_ = m;
	if (_tmp1830_ != NULL) {
		ValaMethod* _tmp1831_;
		gchar* _tmp1832_;
		gchar* _tmp1833_;
		_tmp1831_ = m;
		_tmp1832_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1831_);
		_tmp1833_ = _tmp1832_;
		_tmp1829_ = _tmp1833_ != NULL;
		_g_free0 (_tmp1833_);
	} else {
		_tmp1829_ = FALSE;
	}
	if (_tmp1829_) {
		ValaMethod* _tmp1834_;
		gchar* _tmp1835_;
		gchar* _tmp1836_;
		ValaMethod* _tmp1837_;
		ValaDataType* _tmp1838_;
		ValaDataType* _tmp1839_;
		gchar* _tmp1840_;
		gchar* _tmp1841_;
		_tmp1834_ = m;
		_tmp1835_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1834_);
		_tmp1836_ = _tmp1835_;
		_tmp1837_ = m;
		_tmp1838_ = vala_callable_get_return_type ((ValaCallable*) _tmp1837_);
		_tmp1839_ = _tmp1838_;
		_tmp1840_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1839_);
		_tmp1841_ = _tmp1840_;
		_tmp1828_ = g_strcmp0 (_tmp1836_, _tmp1841_) != 0;
		_g_free0 (_tmp1841_);
		_g_free0 (_tmp1836_);
	} else {
		_tmp1828_ = FALSE;
	}
	if (_tmp1828_) {
		ValaCCodeExpression* _tmp1842_;
		ValaMethod* _tmp1843_;
		ValaDataType* _tmp1844_;
		ValaDataType* _tmp1845_;
		gchar* _tmp1846_;
		gchar* _tmp1847_;
		ValaCCodeCastExpression* _tmp1848_;
		_tmp1842_ = ccall_expr;
		_tmp1843_ = m;
		_tmp1844_ = vala_callable_get_return_type ((ValaCallable*) _tmp1843_);
		_tmp1845_ = _tmp1844_;
		_tmp1846_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1845_);
		_tmp1847_ = _tmp1846_;
		_tmp1848_ = vala_ccode_cast_expression_new (_tmp1842_, _tmp1847_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1848_;
		_g_free0 (_tmp1847_);
	}
	_tmp1849_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1849_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1850_;
		ValaList* _tmp1851_;
		ValaIterator* _tmp1852_;
		ValaIterator* _tmp1853_;
		ValaIterator* _tmp1854_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1855_;
		gpointer _tmp1856_;
		ValaExpression* _tmp1857_;
		ValaCCodeExpression* _tmp1858_;
		ValaCCodeExpression* _tmp1859_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1860_;
		ValaLocalVariable* _tmp1861_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1862_;
		const gchar* _tmp1863_;
		const gchar* _tmp1864_;
		ValaCCodeExpression* _tmp1865_;
		ValaLocalVariable* _tmp1866_;
		ValaCCodeFile* _tmp1867_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1868_;
		ValaExpression* _tmp1869_;
		ValaExpression* _tmp1870_;
		ValaCCodeExpression* _tmp1871_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1872_;
		ValaExpression* _tmp1873_;
		ValaExpression* _tmp1874_;
		ValaCCodeExpression* _tmp1875_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1876_;
		ValaExpression* _tmp1877_;
		ValaExpression* _tmp1878_;
		ValaDataType* _tmp1879_;
		ValaDataType* _tmp1880_;
		ValaArrayType* _tmp1881_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1882_;
		ValaDataType* _tmp1883_;
		ValaDataType* _tmp1884_;
		gchar* _tmp1885_;
		gchar* _tmp1886_;
		gchar* _tmp1887_;
		gchar* _tmp1888_;
		ValaCCodeIdentifier* _tmp1889_;
		ValaCCodeIdentifier* _tmp1890_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1891_;
		ValaCCodeExpression* _tmp1892_;
		ValaCCodeBinaryExpression* _tmp1893_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1894_;
		ValaCCodeExpression* _tmp1895_;
		ValaCCodeBinaryExpression* _tmp1896_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1897_;
		ValaCCodeIdentifier* _tmp1898_;
		ValaCCodeFunctionCall* _tmp1899_;
		ValaCCodeFunctionCall* _tmp1900_;
		ValaCCodeFunctionCall* _tmp1901_;
		ValaCCodeExpression* _tmp1902_;
		ValaCCodeExpression* _tmp1903_;
		ValaCCodeBinaryExpression* _tmp1904_;
		ValaCCodeBinaryExpression* _tmp1905_;
		ValaCCodeFunctionCall* _tmp1906_;
		ValaCCodeConstant* _tmp1907_;
		ValaCCodeConstant* _tmp1908_;
		ValaCCodeFunctionCall* _tmp1909_;
		ValaCCodeIdentifier* _tmp1910_;
		ValaCCodeBinaryExpression* _tmp1911_;
		ValaCCodeBinaryExpression* _tmp1912_;
		ValaCCodeBinaryExpression* _tmp1913_;
		ValaCCodeFunction* _tmp1914_;
		ValaCCodeFunction* _tmp1915_;
		ValaCCodeExpression* _tmp1916_;
		ValaCCodeExpression* _tmp1917_;
		ValaCCodeFunction* _tmp1918_;
		ValaCCodeFunction* _tmp1919_;
		ValaCCodeExpression* _tmp1920_;
		ValaCCodeFunction* _tmp1921_;
		ValaCCodeFunction* _tmp1922_;
		ValaCCodeBinaryExpression* _tmp1923_;
		ValaCCodeFunctionCall* _tmp1924_;
		ValaCCodeConstant* _tmp1925_;
		ValaCCodeConstant* _tmp1926_;
		ValaCCodeConditionalExpression* _tmp1927_;
		ValaCCodeConditionalExpression* _tmp1928_;
		ValaCCodeFunction* _tmp1929_;
		ValaCCodeFunction* _tmp1930_;
		ValaMemberAccess* _tmp1931_;
		ValaExpression* _tmp1932_;
		ValaExpression* _tmp1933_;
		ValaCCodeExpression* _tmp1934_;
		ValaCCodeExpression* _tmp1935_;
		ValaCCodeExpression* _tmp1936_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1937_;
		ValaExpression* _tmp1938_;
		ValaExpression* _tmp1939_;
		ValaSymbol* _tmp1940_;
		ValaSymbol* _tmp1941_;
		ValaSymbol* _tmp1942_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1943_;
		ValaLocalVariable* _tmp1944_;
		gboolean _tmp1945_ = FALSE;
		gboolean _tmp1946_ = FALSE;
		ValaSymbol* _tmp1947_;
		_tmp1850_ = vala_method_call_get_argument_list (expr);
		_tmp1851_ = _tmp1850_;
		_tmp1852_ = vala_iterable_iterator ((ValaIterable*) _tmp1851_);
		_tmp1853_ = _tmp1852_;
		_vala_iterable_unref0 (_tmp1851_);
		arg_it = _tmp1853_;
		_tmp1854_ = arg_it;
		vala_iterator_next (_tmp1854_);
		_tmp1855_ = arg_it;
		_tmp1856_ = vala_iterator_get (_tmp1855_);
		_tmp1857_ = (ValaExpression*) _tmp1856_;
		_tmp1858_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1857_);
		_tmp1859_ = _tmp1858_;
		_vala_code_node_unref0 (_tmp1857_);
		new_size = _tmp1859_;
		_tmp1860_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1861_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1860_, TRUE, NULL, FALSE);
		temp_decl = _tmp1861_;
		_tmp1862_ = temp_decl;
		_tmp1863_ = vala_symbol_get_name ((ValaSymbol*) _tmp1862_);
		_tmp1864_ = _tmp1863_;
		_tmp1865_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1864_);
		temp_ref = _tmp1865_;
		_tmp1866_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1866_, FALSE);
		_tmp1867_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1867_, "string.h", FALSE);
		_tmp1868_ = ma;
		_tmp1869_ = vala_member_access_get_inner (_tmp1868_);
		_tmp1870_ = _tmp1869_;
		_tmp1871_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1870_, 1);
		clen = _tmp1871_;
		_tmp1872_ = ma;
		_tmp1873_ = vala_member_access_get_inner (_tmp1872_);
		_tmp1874_ = _tmp1873_;
		_tmp1875_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1874_);
		celems = _tmp1875_;
		_tmp1876_ = ma;
		_tmp1877_ = vala_member_access_get_inner (_tmp1876_);
		_tmp1878_ = _tmp1877_;
		_tmp1879_ = vala_expression_get_value_type (_tmp1878_);
		_tmp1880_ = _tmp1879_;
		_tmp1881_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1880_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1881_;
		_tmp1882_ = array_type;
		_tmp1883_ = vala_array_type_get_element_type (_tmp1882_);
		_tmp1884_ = _tmp1883_;
		_tmp1885_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1884_);
		_tmp1886_ = _tmp1885_;
		_tmp1887_ = g_strdup_printf ("sizeof (%s)", _tmp1886_);
		_tmp1888_ = _tmp1887_;
		_tmp1889_ = vala_ccode_identifier_new (_tmp1888_);
		_tmp1890_ = _tmp1889_;
		_g_free0 (_tmp1888_);
		_g_free0 (_tmp1886_);
		csizeof = _tmp1890_;
		_tmp1891_ = temp_ref;
		_tmp1892_ = clen;
		_tmp1893_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1891_, _tmp1892_);
		cdelta = _tmp1893_;
		_tmp1894_ = temp_ref;
		_tmp1895_ = clen;
		_tmp1896_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1894_, _tmp1895_);
		ccheck = _tmp1896_;
		_tmp1897_ = vala_ccode_identifier_new ("memset");
		_tmp1898_ = _tmp1897_;
		_tmp1899_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1898_);
		_tmp1900_ = _tmp1899_;
		_vala_ccode_node_unref0 (_tmp1898_);
		czero = _tmp1900_;
		_tmp1901_ = czero;
		_tmp1902_ = celems;
		_tmp1903_ = clen;
		_tmp1904_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1902_, _tmp1903_);
		_tmp1905_ = _tmp1904_;
		vala_ccode_function_call_add_argument (_tmp1901_, (ValaCCodeExpression*) _tmp1905_);
		_vala_ccode_node_unref0 (_tmp1905_);
		_tmp1906_ = czero;
		_tmp1907_ = vala_ccode_constant_new ("0");
		_tmp1908_ = _tmp1907_;
		vala_ccode_function_call_add_argument (_tmp1906_, (ValaCCodeExpression*) _tmp1908_);
		_vala_ccode_node_unref0 (_tmp1908_);
		_tmp1909_ = czero;
		_tmp1910_ = csizeof;
		_tmp1911_ = cdelta;
		_tmp1912_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1910_, (ValaCCodeExpression*) _tmp1911_);
		_tmp1913_ = _tmp1912_;
		vala_ccode_function_call_add_argument (_tmp1909_, (ValaCCodeExpression*) _tmp1913_);
		_vala_ccode_node_unref0 (_tmp1913_);
		_tmp1914_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1915_ = _tmp1914_;
		_tmp1916_ = temp_ref;
		_tmp1917_ = new_size;
		vala_ccode_function_add_assignment (_tmp1915_, _tmp1916_, _tmp1917_);
		_tmp1918_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1919_ = _tmp1918_;
		_tmp1920_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1919_, _tmp1920_);
		_tmp1921_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1922_ = _tmp1921_;
		_tmp1923_ = ccheck;
		_tmp1924_ = czero;
		_tmp1925_ = vala_ccode_constant_new ("NULL");
		_tmp1926_ = _tmp1925_;
		_tmp1927_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1923_, (ValaCCodeExpression*) _tmp1924_, (ValaCCodeExpression*) _tmp1926_);
		_tmp1928_ = _tmp1927_;
		vala_ccode_function_add_expression (_tmp1922_, (ValaCCodeExpression*) _tmp1928_);
		_vala_ccode_node_unref0 (_tmp1928_);
		_vala_ccode_node_unref0 (_tmp1926_);
		_tmp1929_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1930_ = _tmp1929_;
		_tmp1931_ = ma;
		_tmp1932_ = vala_member_access_get_inner (_tmp1931_);
		_tmp1933_ = _tmp1932_;
		_tmp1934_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1933_, 1);
		_tmp1935_ = _tmp1934_;
		_tmp1936_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1930_, _tmp1935_, _tmp1936_);
		_vala_ccode_node_unref0 (_tmp1935_);
		_tmp1937_ = ma;
		_tmp1938_ = vala_member_access_get_inner (_tmp1937_);
		_tmp1939_ = _tmp1938_;
		_tmp1940_ = vala_expression_get_symbol_reference (_tmp1939_);
		_tmp1941_ = _tmp1940_;
		_tmp1942_ = _vala_code_node_ref0 (_tmp1941_);
		array_var = _tmp1942_;
		_tmp1943_ = array_var;
		_tmp1944_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1943_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1943_) : NULL);
		array_local = _tmp1944_;
		_tmp1947_ = array_var;
		if (_tmp1947_ != NULL) {
			ValaSymbol* _tmp1948_;
			_tmp1948_ = array_var;
			_tmp1946_ = vala_symbol_is_internal_symbol (_tmp1948_);
		} else {
			_tmp1946_ = FALSE;
		}
		if (_tmp1946_) {
			gboolean _tmp1949_ = FALSE;
			gboolean _tmp1950_ = FALSE;
			ValaSymbol* _tmp1951_;
			_tmp1951_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1951_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1952_;
				gboolean _tmp1953_;
				gboolean _tmp1954_;
				_tmp1952_ = array_local;
				_tmp1953_ = vala_local_variable_get_captured (_tmp1952_);
				_tmp1954_ = _tmp1953_;
				_tmp1950_ = !_tmp1954_;
			} else {
				_tmp1950_ = FALSE;
			}
			if (_tmp1950_) {
				_tmp1949_ = TRUE;
			} else {
				ValaSymbol* _tmp1955_;
				_tmp1955_ = array_var;
				_tmp1949_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1955_, VALA_TYPE_FIELD);
			}
			_tmp1945_ = _tmp1949_;
		} else {
			_tmp1945_ = FALSE;
		}
		if (_tmp1945_) {
			ValaCCodeFunction* _tmp1956_;
			ValaCCodeFunction* _tmp1957_;
			ValaMemberAccess* _tmp1958_;
			ValaExpression* _tmp1959_;
			ValaExpression* _tmp1960_;
			ValaTargetValue* _tmp1961_;
			ValaTargetValue* _tmp1962_;
			ValaCCodeExpression* _tmp1963_;
			ValaCCodeExpression* _tmp1964_;
			ValaCCodeExpression* _tmp1965_;
			_tmp1956_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1957_ = _tmp1956_;
			_tmp1958_ = ma;
			_tmp1959_ = vala_member_access_get_inner (_tmp1958_);
			_tmp1960_ = _tmp1959_;
			_tmp1961_ = vala_expression_get_target_value (_tmp1960_);
			_tmp1962_ = _tmp1961_;
			_tmp1963_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1962_);
			_tmp1964_ = _tmp1963_;
			_tmp1965_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1957_, _tmp1964_, _tmp1965_);
			_vala_ccode_node_unref0 (_tmp1964_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1967_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1968_ = _tmp1967_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1968_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1969_;
		ValaDataType* _tmp1970_;
		_tmp1969_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1970_ = _tmp1969_;
		_tmp1966_ = !vala_data_type_is_disposable (_tmp1970_);
	} else {
		_tmp1966_ = FALSE;
	}
	if (_tmp1966_) {
		gboolean _tmp1971_ = FALSE;
		ValaCCodeExpression* _tmp1972_;
		_tmp1972_ = ccall_expr;
		if (_tmp1972_ != NULL) {
			gboolean _tmp1973_;
			_tmp1973_ = return_result_via_out_param;
			_tmp1971_ = !_tmp1973_;
		} else {
			_tmp1971_ = FALSE;
		}
		if (_tmp1971_) {
			ValaCCodeFunction* _tmp1974_;
			ValaCCodeFunction* _tmp1975_;
			ValaCCodeExpression* _tmp1976_;
			_tmp1974_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1975_ = _tmp1974_;
			_tmp1976_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1975_, _tmp1976_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1977_;
		ValaDataType* _tmp1978_;
		gboolean _tmp1979_ = FALSE;
		ValaDataType* _tmp1980_;
		ValaDataType* _tmp1981_;
		gboolean _tmp2008_ = FALSE;
		ValaMethod* _tmp2009_;
		_tmp1977_ = itype;
		_tmp1978_ = vala_data_type_get_return_type (_tmp1977_);
		result_type = _tmp1978_;
		_tmp1980_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1981_ = _tmp1980_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1981_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1982_;
			ValaDataType* _tmp1983_;
			_tmp1982_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1983_ = _tmp1982_;
			_tmp1979_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1983_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1979_ = FALSE;
		}
		if (_tmp1979_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1984_;
			ValaDataType* _tmp1985_;
			ValaTypeParameter* _tmp1986_;
			ValaTypeParameter* _tmp1987_;
			ValaTypeParameter* _tmp1988_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1989_;
			ValaSymbol* _tmp1990_;
			ValaSymbol* _tmp1991_;
			ValaSymbol* _tmp1992_;
			ValaSymbol* _tmp1993_;
			ValaStruct* _tmp1994_;
			gboolean _tmp1995_ = FALSE;
			ValaTypeParameter* _tmp1996_;
			ValaSymbol* _tmp1997_;
			ValaSymbol* _tmp1998_;
			ValaTypeSymbol* _tmp1999_;
			_tmp1984_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1985_ = _tmp1984_;
			_tmp1986_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1985_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1987_ = _tmp1986_;
			_tmp1988_ = _vala_code_node_ref0 (_tmp1987_);
			type_parameter = _tmp1988_;
			_tmp1989_ = type_parameter;
			_tmp1990_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1989_);
			_tmp1991_ = _tmp1990_;
			_tmp1992_ = vala_symbol_get_parent_symbol (_tmp1991_);
			_tmp1993_ = _tmp1992_;
			_tmp1994_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1993_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1993_) : NULL);
			st = _tmp1994_;
			_tmp1996_ = type_parameter;
			_tmp1997_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1996_);
			_tmp1998_ = _tmp1997_;
			_tmp1999_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1998_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1999_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1995_ = TRUE;
			} else {
				gboolean _tmp2000_ = FALSE;
				ValaStruct* _tmp2001_;
				_tmp2001_ = st;
				if (_tmp2001_ != NULL) {
					ValaStruct* _tmp2002_;
					gchar* _tmp2003_;
					gchar* _tmp2004_;
					_tmp2002_ = st;
					_tmp2003_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2002_);
					_tmp2004_ = _tmp2003_;
					_tmp2000_ = g_strcmp0 (_tmp2004_, "va_list") == 0;
					_g_free0 (_tmp2004_);
				} else {
					_tmp2000_ = FALSE;
				}
				_tmp1995_ = _tmp2000_;
			}
			if (_tmp1995_) {
				ValaDataType* _tmp2005_;
				ValaDataType* _tmp2006_;
				ValaDataType* _tmp2007_;
				_tmp2005_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp2006_ = _tmp2005_;
				_tmp2007_ = _vala_code_node_ref0 (_tmp2006_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp2007_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp2009_ = m;
		if (_tmp2009_ != NULL) {
			ValaMethod* _tmp2010_;
			_tmp2010_ = m;
			_tmp2008_ = vala_method_get_format_arg_index (_tmp2010_) >= 0;
		} else {
			_tmp2008_ = FALSE;
		}
		if (_tmp2008_) {
			ValaCCodeExpression* _tmp2011_;
			_tmp2011_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2011_);
		} else {
			gboolean _tmp2012_ = FALSE;
			ValaMethod* _tmp2013_;
			_tmp2013_ = m;
			if (_tmp2013_ != NULL) {
				ValaMethod* _tmp2014_;
				_tmp2014_ = m;
				_tmp2012_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp2014_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp2012_ = FALSE;
			}
			if (_tmp2012_) {
				ValaCCodeExpression* _tmp2015_;
				_tmp2015_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2015_);
			} else {
				gboolean _tmp2016_ = FALSE;
				gboolean _tmp2017_ = FALSE;
				gboolean _tmp2018_;
				_tmp2018_ = return_result_via_out_param;
				if (!_tmp2018_) {
					_tmp2017_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp2017_ = FALSE;
				}
				if (_tmp2017_) {
					gboolean _tmp2019_ = FALSE;
					ValaDataType* _tmp2020_;
					_tmp2020_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2020_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2021_;
						_tmp2021_ = result_type;
						_tmp2019_ = !vala_data_type_is_disposable (_tmp2021_);
					} else {
						_tmp2019_ = FALSE;
					}
					_tmp2016_ = _tmp2019_;
				} else {
					_tmp2016_ = FALSE;
				}
				if (_tmp2016_) {
					ValaCCodeExpression* _tmp2022_;
					_tmp2022_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2022_);
				} else {
					gboolean _tmp2023_;
					_tmp2023_ = return_result_via_out_param;
					if (!_tmp2023_) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2024_;
						ValaDataType* _tmp2025_;
						gboolean _tmp2026_;
						gboolean _tmp2027_;
						ValaLocalVariable* _tmp2028_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2029_;
						const gchar* _tmp2030_;
						const gchar* _tmp2031_;
						ValaCCodeExpression* _tmp2032_;
						ValaLocalVariable* _tmp2033_;
						ValaCCodeFunction* _tmp2034_;
						ValaCCodeFunction* _tmp2035_;
						ValaCCodeExpression* _tmp2036_;
						ValaCCodeExpression* _tmp2037_;
						ValaCCodeExpression* _tmp2038_;
						ValaTargetValue* _tmp2039_;
						ValaTargetValue* _tmp2040_;
						_tmp2024_ = result_type;
						_tmp2025_ = result_type;
						_tmp2026_ = vala_data_type_get_value_owned (_tmp2025_);
						_tmp2027_ = _tmp2026_;
						_tmp2028_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2024_, _tmp2027_, NULL, FALSE);
						temp_var = _tmp2028_;
						_tmp2029_ = temp_var;
						_tmp2030_ = vala_symbol_get_name ((ValaSymbol*) _tmp2029_);
						_tmp2031_ = _tmp2030_;
						_tmp2032_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2031_);
						temp_ref = _tmp2032_;
						_tmp2033_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2033_, FALSE);
						_tmp2034_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2035_ = _tmp2034_;
						_tmp2036_ = temp_ref;
						_tmp2037_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2035_, _tmp2036_, _tmp2037_);
						_tmp2038_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2038_);
						_tmp2039_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2040_ = _tmp2039_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2040_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2041_;
						ValaTargetValue* _tmp2042_;
						ValaTargetValue* _tmp2043_;
						_tmp2041_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2041_);
						_tmp2042_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2043_ = _tmp2042_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2043_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2044_ = params;
	_tmp2045_ = vala_iterable_iterator ((ValaIterable*) _tmp2044_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2045_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2046_;
		gint _arg_size = 0;
		ValaList* _tmp2047_;
		gint _tmp2048_;
		gint _tmp2049_;
		gint _arg_index = 0;
		_tmp2046_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp2046_;
		_tmp2047_ = _arg_list;
		_tmp2048_ = vala_collection_get_size ((ValaCollection*) _tmp2047_);
		_tmp2049_ = _tmp2048_;
		_arg_size = _tmp2049_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp2050_;
			gint _tmp2051_;
			gint _tmp2052_;
			ValaExpression* arg = NULL;
			ValaList* _tmp2053_;
			gint _tmp2054_;
			gpointer _tmp2055_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2056_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2059_;
			ValaUnaryExpression* _tmp2060_;
			gboolean _tmp2061_ = FALSE;
			ValaUnaryExpression* _tmp2062_;
			gboolean _tmp2116_ = FALSE;
			ValaUnaryExpression* _tmp2117_;
			ValaUnaryExpression* _tmp2121_;
			ValaExpression* _tmp2122_;
			ValaExpression* _tmp2123_;
			ValaDataType* _tmp2124_;
			ValaDataType* _tmp2125_;
			gboolean _tmp2135_ = FALSE;
			ValaMemberAccess* _tmp2136_;
			ValaSymbol* _tmp2137_;
			ValaSymbol* _tmp2138_;
			ValaUnaryExpression* _tmp2154_;
			ValaExpression* _tmp2155_;
			ValaExpression* _tmp2156_;
			ValaTargetValue* _tmp2157_;
			ValaTargetValue* _tmp2158_;
			ValaUnaryExpression* _tmp2159_;
			ValaTargetValue* _tmp2160_;
			ValaTargetValue* _tmp2161_;
			ValaUnaryExpression* _tmp2162_;
			ValaExpression* _tmp2163_;
			ValaExpression* _tmp2164_;
			ValaDataType* _tmp2165_;
			ValaDataType* _tmp2166_;
			ValaExpression* _tmp2167_;
			ValaTargetValue* _tmp2168_;
			ValaTargetValue* _tmp2169_;
			ValaSourceReference* _tmp2170_;
			ValaSourceReference* _tmp2171_;
			gboolean _tmp2172_ = FALSE;
			ValaParameter* _tmp2173_;
			_tmp2050_ = _arg_index;
			_arg_index = _tmp2050_ + 1;
			_tmp2051_ = _arg_index;
			_tmp2052_ = _arg_size;
			if (!(_tmp2051_ < _tmp2052_)) {
				break;
			}
			_tmp2053_ = _arg_list;
			_tmp2054_ = _arg_index;
			_tmp2055_ = vala_list_get (_tmp2053_, _tmp2054_);
			arg = (ValaExpression*) _tmp2055_;
			param = NULL;
			_tmp2056_ = params_it;
			if (vala_iterator_next (_tmp2056_)) {
				ValaIterator* _tmp2057_;
				gpointer _tmp2058_;
				_tmp2057_ = params_it;
				_tmp2058_ = vala_iterator_get (_tmp2057_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2058_;
			}
			_tmp2059_ = arg;
			_tmp2060_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2059_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2059_) : NULL);
			unary = _tmp2060_;
			_tmp2062_ = unary;
			if (_tmp2062_ != NULL) {
				ValaUnaryExpression* _tmp2063_;
				ValaUnaryOperator _tmp2064_;
				ValaUnaryOperator _tmp2065_;
				_tmp2063_ = unary;
				_tmp2064_ = vala_unary_expression_get_operator (_tmp2063_);
				_tmp2065_ = _tmp2064_;
				_tmp2061_ = _tmp2065_ == VALA_UNARY_OPERATOR_REF;
			} else {
				_tmp2061_ = FALSE;
			}
			if (_tmp2061_) {
				gboolean _tmp2066_ = FALSE;
				gboolean _tmp2067_ = FALSE;
				gboolean _tmp2068_ = FALSE;
				ValaParameter* _tmp2069_;
				_tmp2069_ = param;
				if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp2069_)) {
					ValaParameter* _tmp2070_;
					ValaDataType* _tmp2071_;
					ValaDataType* _tmp2072_;
					_tmp2070_ = param;
					_tmp2071_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2070_);
					_tmp2072_ = _tmp2071_;
					_tmp2068_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2072_, VALA_TYPE_ARRAY_TYPE);
				} else {
					_tmp2068_ = FALSE;
				}
				if (_tmp2068_) {
					ValaParameter* _tmp2073_;
					ValaDataType* _tmp2074_;
					ValaDataType* _tmp2075_;
					gboolean _tmp2076_;
					gboolean _tmp2077_;
					_tmp2073_ = param;
					_tmp2074_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2073_);
					_tmp2075_ = _tmp2074_;
					_tmp2076_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2075_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2077_ = _tmp2076_;
					_tmp2067_ = !_tmp2077_;
				} else {
					_tmp2067_ = FALSE;
				}
				if (_tmp2067_) {
					ValaParameter* _tmp2078_;
					ValaDataType* _tmp2079_;
					ValaDataType* _tmp2080_;
					gint _tmp2081_;
					gint _tmp2082_;
					_tmp2078_ = param;
					_tmp2079_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2078_);
					_tmp2080_ = _tmp2079_;
					_tmp2081_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp2080_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2082_ = _tmp2081_;
					_tmp2066_ = _tmp2082_ == 1;
				} else {
					_tmp2066_ = FALSE;
				}
				if (_tmp2066_) {
					ValaSymbol* array_var = NULL;
					ValaUnaryExpression* _tmp2083_;
					ValaExpression* _tmp2084_;
					ValaExpression* _tmp2085_;
					ValaSymbol* _tmp2086_;
					ValaSymbol* _tmp2087_;
					ValaLocalVariable* array_local = NULL;
					ValaSymbol* _tmp2088_;
					gboolean _tmp2089_ = FALSE;
					gboolean _tmp2090_ = FALSE;
					ValaSymbol* _tmp2091_;
					_tmp2083_ = unary;
					_tmp2084_ = vala_unary_expression_get_inner (_tmp2083_);
					_tmp2085_ = _tmp2084_;
					_tmp2086_ = vala_expression_get_symbol_reference (_tmp2085_);
					_tmp2087_ = _tmp2086_;
					array_var = _tmp2087_;
					_tmp2088_ = array_var;
					array_local = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2088_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp2088_) : NULL;
					_tmp2091_ = array_var;
					if (_tmp2091_ != NULL) {
						ValaSymbol* _tmp2092_;
						_tmp2092_ = array_var;
						_tmp2090_ = vala_symbol_is_internal_symbol (_tmp2092_);
					} else {
						_tmp2090_ = FALSE;
					}
					if (_tmp2090_) {
						gboolean _tmp2093_ = FALSE;
						gboolean _tmp2094_ = FALSE;
						ValaLocalVariable* _tmp2095_;
						_tmp2095_ = array_local;
						if (_tmp2095_ != NULL) {
							ValaLocalVariable* _tmp2096_;
							gboolean _tmp2097_;
							gboolean _tmp2098_;
							_tmp2096_ = array_local;
							_tmp2097_ = vala_local_variable_get_captured (_tmp2096_);
							_tmp2098_ = _tmp2097_;
							_tmp2094_ = !_tmp2098_;
						} else {
							_tmp2094_ = FALSE;
						}
						if (_tmp2094_) {
							_tmp2093_ = TRUE;
						} else {
							ValaSymbol* _tmp2099_;
							_tmp2099_ = array_var;
							_tmp2093_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2099_, VALA_TYPE_FIELD);
						}
						_tmp2089_ = _tmp2093_;
					} else {
						_tmp2089_ = FALSE;
					}
					if (_tmp2089_) {
						ValaCCodeFunction* _tmp2100_;
						ValaCCodeFunction* _tmp2101_;
						ValaUnaryExpression* _tmp2102_;
						ValaExpression* _tmp2103_;
						ValaExpression* _tmp2104_;
						ValaTargetValue* _tmp2105_;
						ValaTargetValue* _tmp2106_;
						ValaCCodeExpression* _tmp2107_;
						ValaCCodeExpression* _tmp2108_;
						ValaUnaryExpression* _tmp2109_;
						ValaExpression* _tmp2110_;
						ValaExpression* _tmp2111_;
						ValaTargetValue* _tmp2112_;
						ValaTargetValue* _tmp2113_;
						ValaCCodeExpression* _tmp2114_;
						ValaCCodeExpression* _tmp2115_;
						_tmp2100_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2101_ = _tmp2100_;
						_tmp2102_ = unary;
						_tmp2103_ = vala_unary_expression_get_inner (_tmp2102_);
						_tmp2104_ = _tmp2103_;
						_tmp2105_ = vala_expression_get_target_value (_tmp2104_);
						_tmp2106_ = _tmp2105_;
						_tmp2107_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp2106_);
						_tmp2108_ = _tmp2107_;
						_tmp2109_ = unary;
						_tmp2110_ = vala_unary_expression_get_inner (_tmp2109_);
						_tmp2111_ = _tmp2110_;
						_tmp2112_ = vala_expression_get_target_value (_tmp2111_);
						_tmp2113_ = _tmp2112_;
						_tmp2114_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2113_, 1);
						_tmp2115_ = _tmp2114_;
						vala_ccode_function_add_assignment (_tmp2101_, _tmp2108_, _tmp2115_);
						_vala_ccode_node_unref0 (_tmp2115_);
						_vala_ccode_node_unref0 (_tmp2108_);
					}
				}
			}
			_tmp2117_ = unary;
			if (_tmp2117_ == NULL) {
				_tmp2116_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2118_;
				ValaUnaryOperator _tmp2119_;
				ValaUnaryOperator _tmp2120_;
				_tmp2118_ = unary;
				_tmp2119_ = vala_unary_expression_get_operator (_tmp2118_);
				_tmp2120_ = _tmp2119_;
				_tmp2116_ = _tmp2120_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2116_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2121_ = unary;
			_tmp2122_ = vala_unary_expression_get_inner (_tmp2121_);
			_tmp2123_ = _tmp2122_;
			_tmp2124_ = vala_expression_get_value_type (_tmp2123_);
			_tmp2125_ = _tmp2124_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp2125_)) {
				ValaCCodeFunction* _tmp2126_;
				ValaCCodeFunction* _tmp2127_;
				ValaUnaryExpression* _tmp2128_;
				ValaExpression* _tmp2129_;
				ValaExpression* _tmp2130_;
				ValaTargetValue* _tmp2131_;
				ValaTargetValue* _tmp2132_;
				ValaCCodeExpression* _tmp2133_;
				ValaCCodeExpression* _tmp2134_;
				_tmp2126_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2127_ = _tmp2126_;
				_tmp2128_ = unary;
				_tmp2129_ = vala_unary_expression_get_inner (_tmp2128_);
				_tmp2130_ = _tmp2129_;
				_tmp2131_ = vala_expression_get_target_value (_tmp2130_);
				_tmp2132_ = _tmp2131_;
				_tmp2133_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2132_, FALSE);
				_tmp2134_ = _tmp2133_;
				vala_ccode_function_add_expression (_tmp2127_, _tmp2134_);
				_vala_ccode_node_unref0 (_tmp2134_);
			}
			_tmp2136_ = ma;
			_tmp2137_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2136_);
			_tmp2138_ = _tmp2137_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2138_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2139_;
				ValaTargetValue* _tmp2140_;
				ValaTargetValue* _tmp2141_;
				ValaDataType* _tmp2142_;
				ValaDataType* _tmp2143_;
				_tmp2139_ = unary;
				_tmp2140_ = vala_expression_get_target_value ((ValaExpression*) _tmp2139_);
				_tmp2141_ = _tmp2140_;
				_tmp2142_ = vala_target_value_get_value_type (_tmp2141_);
				_tmp2143_ = _tmp2142_;
				_tmp2135_ = _tmp2143_ == NULL;
			} else {
				_tmp2135_ = FALSE;
			}
			if (_tmp2135_) {
				ValaUnaryExpression* _tmp2144_;
				ValaTargetValue* _tmp2145_;
				ValaTargetValue* _tmp2146_;
				ValaUnaryExpression* _tmp2147_;
				ValaExpression* _tmp2148_;
				ValaExpression* _tmp2149_;
				ValaDataType* _tmp2150_;
				ValaDataType* _tmp2151_;
				ValaDataType* _tmp2152_;
				ValaDataType* _tmp2153_;
				_tmp2144_ = unary;
				_tmp2145_ = vala_expression_get_target_value ((ValaExpression*) _tmp2144_);
				_tmp2146_ = _tmp2145_;
				_tmp2147_ = unary;
				_tmp2148_ = vala_unary_expression_get_inner (_tmp2147_);
				_tmp2149_ = _tmp2148_;
				_tmp2150_ = vala_expression_get_value_type (_tmp2149_);
				_tmp2151_ = _tmp2150_;
				_tmp2152_ = vala_data_type_copy (_tmp2151_);
				_tmp2153_ = _tmp2152_;
				vala_target_value_set_value_type (_tmp2146_, _tmp2153_);
				_vala_code_node_unref0 (_tmp2153_);
			}
			_tmp2154_ = unary;
			_tmp2155_ = vala_unary_expression_get_inner (_tmp2154_);
			_tmp2156_ = _tmp2155_;
			_tmp2157_ = vala_expression_get_target_value (_tmp2156_);
			_tmp2158_ = _tmp2157_;
			_tmp2159_ = unary;
			_tmp2160_ = vala_expression_get_target_value ((ValaExpression*) _tmp2159_);
			_tmp2161_ = _tmp2160_;
			_tmp2162_ = unary;
			_tmp2163_ = vala_unary_expression_get_inner (_tmp2162_);
			_tmp2164_ = _tmp2163_;
			_tmp2165_ = vala_expression_get_value_type (_tmp2164_);
			_tmp2166_ = _tmp2165_;
			_tmp2167_ = arg;
			_tmp2168_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2161_, _tmp2166_, (ValaCodeNode*) _tmp2167_);
			_tmp2169_ = _tmp2168_;
			_tmp2170_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2171_ = _tmp2170_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2158_, _tmp2169_, _tmp2171_);
			_vala_target_value_unref0 (_tmp2169_);
			_tmp2173_ = param;
			if (_tmp2173_ != NULL) {
				ValaParameter* _tmp2174_;
				_tmp2174_ = param;
				_tmp2172_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2174_);
			} else {
				_tmp2172_ = FALSE;
			}
			if (_tmp2172_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2175_;
				ValaCCodeIdentifier* _tmp2176_;
				ValaCCodeFunctionCall* _tmp2177_;
				ValaCCodeFunctionCall* _tmp2178_;
				ValaCCodeFunctionCall* _tmp2179_;
				ValaUnaryExpression* _tmp2180_;
				ValaExpression* _tmp2181_;
				ValaExpression* _tmp2182_;
				ValaTargetValue* _tmp2183_;
				ValaTargetValue* _tmp2184_;
				ValaCCodeExpression* _tmp2185_;
				ValaCCodeExpression* _tmp2186_;
				ValaCCodeFunction* _tmp2187_;
				ValaCCodeFunction* _tmp2188_;
				ValaUnaryExpression* _tmp2189_;
				ValaExpression* _tmp2190_;
				ValaExpression* _tmp2191_;
				ValaTargetValue* _tmp2192_;
				ValaTargetValue* _tmp2193_;
				ValaCCodeExpression* _tmp2194_;
				ValaCCodeExpression* _tmp2195_;
				ValaCCodeFunctionCall* _tmp2196_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2175_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2176_ = _tmp2175_;
				_tmp2177_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2176_);
				_tmp2178_ = _tmp2177_;
				_vala_ccode_node_unref0 (_tmp2176_);
				len_call = _tmp2178_;
				_tmp2179_ = len_call;
				_tmp2180_ = unary;
				_tmp2181_ = vala_unary_expression_get_inner (_tmp2180_);
				_tmp2182_ = _tmp2181_;
				_tmp2183_ = vala_expression_get_target_value (_tmp2182_);
				_tmp2184_ = _tmp2183_;
				_tmp2185_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2184_);
				_tmp2186_ = _tmp2185_;
				vala_ccode_function_call_add_argument (_tmp2179_, _tmp2186_);
				_vala_ccode_node_unref0 (_tmp2186_);
				_tmp2187_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2188_ = _tmp2187_;
				_tmp2189_ = unary;
				_tmp2190_ = vala_unary_expression_get_inner (_tmp2189_);
				_tmp2191_ = _tmp2190_;
				_tmp2192_ = vala_expression_get_target_value (_tmp2191_);
				_tmp2193_ = _tmp2192_;
				_tmp2194_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2193_, 1);
				_tmp2195_ = _tmp2194_;
				_tmp2196_ = len_call;
				vala_ccode_function_add_assignment (_tmp2188_, _tmp2195_, (ValaCCodeExpression*) _tmp2196_);
				_vala_ccode_node_unref0 (_tmp2195_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2199_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2199_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2200_;
		ValaSymbol* _tmp2201_;
		ValaSymbol* _tmp2202_;
		_tmp2200_ = m;
		_tmp2201_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2200_);
		_tmp2202_ = _tmp2201_;
		_tmp2198_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2202_, VALA_TYPE_CLASS);
	} else {
		_tmp2198_ = FALSE;
	}
	if (_tmp2198_) {
		gboolean _tmp2203_ = FALSE;
		gboolean _tmp2204_ = FALSE;
		ValaClass* _tmp2205_;
		ValaClass* _tmp2206_;
		gboolean _tmp2207_;
		gboolean _tmp2208_;
		_tmp2205_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2206_ = _tmp2205_;
		_tmp2207_ = vala_class_get_is_compact (_tmp2206_);
		_tmp2208_ = _tmp2207_;
		if (_tmp2208_) {
			ValaClass* _tmp2209_;
			ValaClass* _tmp2210_;
			ValaClass* _tmp2211_;
			ValaClass* _tmp2212_;
			_tmp2209_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2210_ = _tmp2209_;
			_tmp2211_ = vala_class_get_base_class (_tmp2210_);
			_tmp2212_ = _tmp2211_;
			_tmp2204_ = _tmp2212_ != NULL;
		} else {
			_tmp2204_ = FALSE;
		}
		if (_tmp2204_) {
			_tmp2203_ = TRUE;
		} else {
			ValaClass* _tmp2213_;
			ValaClass* _tmp2214_;
			ValaClass* _tmp2215_;
			ValaClass* _tmp2216_;
			ValaClass* _tmp2217_;
			_tmp2213_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2214_ = _tmp2213_;
			_tmp2215_ = vala_class_get_base_class (_tmp2214_);
			_tmp2216_ = _tmp2215_;
			_tmp2217_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2203_ = _tmp2216_ == _tmp2217_;
		}
		_tmp2197_ = _tmp2203_;
	} else {
		_tmp2197_ = FALSE;
	}
	if (_tmp2197_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2218_;
		ValaClass* _tmp2219_;
		gchar* _tmp2220_;
		gchar* _tmp2221_;
		gchar* _tmp2222_;
		gchar* _tmp2223_;
		ValaCCodeIdentifier* _tmp2224_;
		ValaCCodeIdentifier* _tmp2225_;
		ValaCCodeFunctionCall* _tmp2226_;
		ValaCCodeFunctionCall* _tmp2227_;
		ValaCCodeFunctionCall* _tmp2228_;
		ValaCCodeExpression* _tmp2229_;
		ValaCCodeExpression* _tmp2230_;
		ValaCCodeFunction* _tmp2231_;
		ValaCCodeFunction* _tmp2232_;
		ValaCCodeFunctionCall* _tmp2233_;
		_tmp2218_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2219_ = _tmp2218_;
		_tmp2220_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2219_, NULL);
		_tmp2221_ = _tmp2220_;
		_tmp2222_ = g_strdup_printf ("%s_instance_init", _tmp2221_);
		_tmp2223_ = _tmp2222_;
		_tmp2224_ = vala_ccode_identifier_new (_tmp2223_);
		_tmp2225_ = _tmp2224_;
		_tmp2226_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2225_);
		_tmp2227_ = _tmp2226_;
		_vala_ccode_node_unref0 (_tmp2225_);
		_g_free0 (_tmp2223_);
		_g_free0 (_tmp2221_);
		cinitcall = _tmp2227_;
		_tmp2228_ = cinitcall;
		_tmp2229_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2230_ = _tmp2229_;
		vala_ccode_function_call_add_argument (_tmp2228_, _tmp2230_);
		_vala_ccode_node_unref0 (_tmp2230_);
		_tmp2231_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2232_ = _tmp2231_;
		_tmp2233_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2232_, (ValaCCodeExpression*) _tmp2233_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}


static gchar*
vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                               ValaEnum* en)
{
	gchar* result = NULL;
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeConstant* _tmp53_;
	ValaCCodeFile* _tmp54_;
	ValaCCodeFunction* _tmp55_;
	ValaCCodeFile* _tmp56_;
	ValaCCodeFunction* _tmp57_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaCCodeFunction* _tmp31_;
			ValaEnumValue* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeIdentifier* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaCCodeFunction* _tmp38_;
			ValaEnumValue* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaCCodeConstant* _tmp46_;
			ValaCCodeConstant* _tmp47_;
			_tmp24_ = _enum_value_index;
			_enum_value_index = _tmp24_ + 1;
			_tmp25_ = _enum_value_index;
			_tmp26_ = _enum_value_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _enum_value_list;
			_tmp28_ = _enum_value_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			enum_value = (ValaEnumValue*) _tmp29_;
			_tmp30_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp31_ = _tmp30_;
			_tmp32_ = enum_value;
			_tmp33_ = vala_get_ccode_name ((ValaCodeNode*) _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_identifier_new (_tmp34_);
			_tmp36_ = _tmp35_;
			vala_ccode_function_add_case (_tmp31_, (ValaCCodeExpression*) _tmp36_);
			_vala_ccode_node_unref0 (_tmp36_);
			_g_free0 (_tmp34_);
			_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = enum_value;
			_tmp40_ = vala_get_ccode_name ((ValaCodeNode*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat ("\"", _tmp41_, NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat (_tmp43_, "\"", NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_ccode_constant_new (_tmp45_);
			_tmp47_ = _tmp46_;
			vala_ccode_function_add_return (_tmp38_, (ValaCCodeExpression*) _tmp47_);
			_vala_ccode_node_unref0 (_tmp47_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp48_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp49_ = _tmp48_;
	vala_ccode_function_close (_tmp49_);
	_tmp50_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_ccode_constant_new ("NULL");
	_tmp53_ = _tmp52_;
	vala_ccode_function_add_return (_tmp51_, (ValaCCodeExpression*) _tmp53_);
	_vala_ccode_node_unref0 (_tmp53_);
	_tmp54_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp55_ = function;
	vala_ccode_file_add_function_declaration (_tmp54_, _tmp55_);
	_tmp56_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp57_ = function;
	vala_ccode_file_add_function (_tmp56_, _tmp57_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}


static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaUnaryExpression* _tmp12_;
			_tmp4_ = _arg_index;
			_arg_index = _tmp4_ + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = _arg_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp10_) : NULL;
			_tmp12_ = unary;
			if (_tmp12_ != NULL) {
				gboolean _tmp13_ = FALSE;
				ValaUnaryExpression* _tmp14_;
				ValaUnaryOperator _tmp15_;
				ValaUnaryOperator _tmp16_;
				_tmp14_ = unary;
				_tmp15_ = vala_unary_expression_get_operator (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp13_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp17_;
					ValaUnaryOperator _tmp18_;
					ValaUnaryOperator _tmp19_;
					_tmp17_ = unary;
					_tmp18_ = vala_unary_expression_get_operator (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp13_ = _tmp19_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp11_ = _tmp13_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}


static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}


static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self)
{
}


GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



