/* valabinaryexpression.c generated by valac, the Vala compiler
 * generated from valabinaryexpression.vala, do not modify */

/* valabinaryexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaBinaryExpressionPrivate {
	ValaBinaryOperator _operator;
	gboolean _is_chained;
	ValaExpression* _left;
	ValaExpression* _right;
};


static gpointer vala_binary_expression_parent_class = NULL;

#define VALA_BINARY_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionPrivate))
static void vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                            gboolean value);
static void vala_binary_expression_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                     ValaExpression* old_node,
                                                     ValaExpression* new_node);
static const gchar* vala_binary_expression_get_operator_string (ValaBinaryExpression* self);
static gchar* vala_binary_expression_real_to_string (ValaCodeNode* base);
static gboolean vala_binary_expression_real_is_constant (ValaExpression* base);
static gboolean vala_binary_expression_real_is_pure (ValaExpression* base);
static gboolean vala_binary_expression_real_is_non_null (ValaExpression* base);
static gboolean vala_binary_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym);
static gboolean vala_binary_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_binary_expression_real_emit (ValaCodeNode* base,
                                       ValaCodeGenerator* codegen);
static void vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                        ValaCollection* collection);
static void vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                     ValaCollection* collection);
static void vala_binary_expression_finalize (ValaCodeNode * obj);


/**
 * Creates a new binary expression.
 *
 * @param op      binary operator
 * @param _left   left operand
 * @param _right  right operand
 * @param source  reference to source code
 * @return        newly created binary expression
 */
ValaBinaryExpression*
vala_binary_expression_construct (GType object_type,
                                  ValaBinaryOperator op,
                                  ValaExpression* _left,
                                  ValaExpression* _right,
                                  ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, FALSE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}


ValaBinaryExpression*
vala_binary_expression_new (ValaBinaryOperator op,
                            ValaExpression* _left,
                            ValaExpression* _right,
                            ValaSourceReference* source)
{
	return vala_binary_expression_construct (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}


ValaBinaryExpression*
vala_binary_expression_construct_chained (GType object_type,
                                          ValaBinaryOperator op,
                                          ValaExpression* _left,
                                          ValaExpression* _right,
                                          ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, TRUE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}


ValaBinaryExpression*
vala_binary_expression_new_chained (ValaBinaryOperator op,
                                    ValaExpression* _left,
                                    ValaExpression* _right,
                                    ValaSourceReference* source)
{
	return vala_binary_expression_construct_chained (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}


static void
vala_binary_expression_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_binary_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}


static void
vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                ValaExpression* old_node,
                                                ValaExpression* new_node)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_binary_expression_set_left (self, new_node);
	}
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_binary_expression_set_right (self, new_node);
	}
}


static const gchar*
vala_binary_expression_get_operator_string (ValaBinaryExpression* self)
{
	const gchar* result = NULL;
	ValaBinaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_operator;
	switch (_tmp0_) {
		case VALA_BINARY_OPERATOR_PLUS:
		{
			result = "+";
			return result;
		}
		case VALA_BINARY_OPERATOR_MINUS:
		{
			result = "-";
			return result;
		}
		case VALA_BINARY_OPERATOR_MUL:
		{
			result = "*";
			return result;
		}
		case VALA_BINARY_OPERATOR_DIV:
		{
			result = "/";
			return result;
		}
		case VALA_BINARY_OPERATOR_MOD:
		{
			result = "%";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_LEFT:
		{
			result = "<<";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN:
		{
			result = "<";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN:
		{
			result = ">";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
		{
			result = "<=";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
		{
			result = ">=";
			return result;
		}
		case VALA_BINARY_OPERATOR_EQUALITY:
		{
			result = "==";
			return result;
		}
		case VALA_BINARY_OPERATOR_INEQUALITY:
		{
			result = "!=";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_AND:
		{
			result = "&";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_OR:
		{
			result = "|";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_XOR:
		{
			result = "^";
			return result;
		}
		case VALA_BINARY_OPERATOR_AND:
		{
			result = "&&";
			return result;
		}
		case VALA_BINARY_OPERATOR_OR:
		{
			result = "||";
			return result;
		}
		case VALA_BINARY_OPERATOR_IN:
		{
			result = "in";
			return result;
		}
		case VALA_BINARY_OPERATOR_COALESCE:
		{
			result = "??";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static gchar*
vala_binary_expression_real_to_string (ValaCodeNode* base)
{
	ValaBinaryExpression * self;
	gchar* result = NULL;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaExpression* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	self = (ValaBinaryExpression*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_binary_expression_get_operator_string (self);
	_tmp4_ = self->priv->_right;
	_tmp5_ = vala_code_node_to_string ((ValaCodeNode*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp3_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp2_);
	result = _tmp8_;
	return result;
}


static gboolean
vala_binary_expression_real_is_constant (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_constant (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_constant (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_binary_expression_real_is_pure (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_pure (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_pure (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_binary_expression_real_is_non_null (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_non_null (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_non_null (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_binary_expression_real_is_accessible (ValaExpression* base,
                                           ValaSymbol* sym)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_binary_expression_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaBinaryOperator _tmp126_;
	gboolean _tmp319_ = FALSE;
	gboolean _tmp320_ = FALSE;
	ValaDataType* _tmp321_;
	ValaDataType* _tmp322_;
	ValaExpression* _tmp342_;
	ValaExpression* _tmp343_;
	gboolean _tmp344_ = FALSE;
	gboolean _tmp345_ = FALSE;
	ValaExpression* _tmp346_;
	ValaExpression* _tmp347_;
	ValaDataType* _tmp348_;
	ValaDataType* _tmp349_;
	ValaExpression* _tmp367_;
	ValaExpression* _tmp368_;
	gboolean _tmp369_ = FALSE;
	gboolean _tmp370_ = FALSE;
	ValaExpression* _tmp371_;
	ValaExpression* _tmp372_;
	ValaDataType* _tmp373_;
	ValaDataType* _tmp374_;
	gboolean _tmp392_ = FALSE;
	ValaExpression* _tmp393_;
	ValaExpression* _tmp394_;
	ValaExpression* _tmp397_;
	ValaExpression* _tmp398_;
	ValaDataType* _tmp399_;
	ValaDataType* _tmp400_;
	gboolean _tmp405_ = FALSE;
	ValaBinaryOperator _tmp406_;
	gboolean _tmp415_ = FALSE;
	ValaExpression* _tmp416_;
	ValaExpression* _tmp417_;
	ValaDataType* _tmp418_;
	ValaDataType* _tmp419_;
	gboolean _tmp436_ = FALSE;
	ValaExpression* _tmp437_;
	ValaExpression* _tmp438_;
	ValaDataType* _tmp439_;
	ValaDataType* _tmp440_;
	ValaExpression* _tmp457_;
	ValaExpression* _tmp458_;
	ValaExpression* _tmp459_;
	ValaExpression* _tmp460_;
	ValaDataType* _tmp461_;
	ValaDataType* _tmp462_;
	ValaDataType* _tmp463_;
	ValaDataType* _tmp464_;
	ValaExpression* _tmp465_;
	ValaExpression* _tmp466_;
	ValaDataType* _tmp467_;
	ValaDataType* _tmp468_;
	ValaExpression* _tmp469_;
	ValaExpression* _tmp470_;
	ValaExpression* _tmp471_;
	ValaExpression* _tmp472_;
	ValaDataType* _tmp473_;
	ValaDataType* _tmp474_;
	ValaDataType* _tmp475_;
	ValaDataType* _tmp476_;
	ValaExpression* _tmp477_;
	ValaExpression* _tmp478_;
	ValaDataType* _tmp479_;
	ValaDataType* _tmp480_;
	gboolean _tmp481_ = FALSE;
	ValaExpression* _tmp482_;
	ValaExpression* _tmp483_;
	ValaDataType* _tmp484_;
	ValaDataType* _tmp485_;
	ValaTypeSymbol* _tmp486_;
	ValaTypeSymbol* _tmp487_;
	ValaSemanticAnalyzer* _tmp488_;
	ValaSemanticAnalyzer* _tmp489_;
	ValaDataType* _tmp490_;
	ValaTypeSymbol* _tmp491_;
	ValaTypeSymbol* _tmp492_;
	gboolean _tmp1140_;
	gboolean _tmp1141_;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = vala_code_context_get_analyzer (context);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_symbol (_tmp6_);
	_tmp8_ = _tmp7_;
	if (VALA_IS_BLOCK (_tmp8_)) {
		gboolean _tmp9_ = FALSE;
		ValaBinaryOperator _tmp10_;
		_tmp10_ = self->priv->_operator;
		if (_tmp10_ == VALA_BINARY_OPERATOR_AND) {
			_tmp9_ = TRUE;
		} else {
			ValaBinaryOperator _tmp11_;
			_tmp11_ = self->priv->_operator;
			_tmp9_ = _tmp11_ == VALA_BINARY_OPERATOR_OR;
		}
		_tmp4_ = _tmp9_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaLocalVariable* local = NULL;
		ValaSemanticAnalyzer* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLocalVariable* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaDeclarationStatement* _tmp26_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaMemberAccess* _tmp34_;
		ValaMemberAccess* _tmp35_;
		ValaExpression* _tmp36_;
		ValaExpression* _tmp37_;
		ValaExpression* _tmp38_;
		ValaExpression* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaAssignment* _tmp42_;
		ValaAssignment* _tmp43_;
		ValaExpression* _tmp44_;
		ValaExpression* _tmp45_;
		ValaSourceReference* _tmp46_;
		ValaSourceReference* _tmp47_;
		ValaExpressionStatement* _tmp48_;
		ValaExpressionStatement* _tmp49_;
		ValaExpressionStatement* stmt = NULL;
		ValaLocalVariable* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		ValaSourceReference* _tmp55_;
		ValaSourceReference* _tmp56_;
		ValaMemberAccess* _tmp57_;
		ValaMemberAccess* _tmp58_;
		ValaBinaryOperator _tmp59_;
		ValaExpression* _tmp60_;
		ValaExpression* _tmp61_;
		ValaSourceReference* _tmp62_;
		ValaSourceReference* _tmp63_;
		ValaBooleanLiteral* _tmp64_;
		ValaBooleanLiteral* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaSourceReference* _tmp69_;
		ValaAssignment* _tmp70_;
		ValaAssignment* _tmp71_;
		ValaExpression* _tmp72_;
		ValaExpression* _tmp73_;
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		ValaExpressionStatement* _tmp76_;
		ValaExpressionStatement* _tmp77_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp78_;
		ValaSourceReference* _tmp79_;
		ValaBlock* _tmp80_;
		ValaBlock* false_block = NULL;
		ValaSourceReference* _tmp81_;
		ValaSourceReference* _tmp82_;
		ValaBlock* _tmp83_;
		ValaBinaryOperator _tmp84_;
		ValaIfStatement* if_stmt = NULL;
		ValaExpression* _tmp93_;
		ValaExpression* _tmp94_;
		ValaBlock* _tmp95_;
		ValaBlock* _tmp96_;
		ValaSourceReference* _tmp97_;
		ValaSourceReference* _tmp98_;
		ValaIfStatement* _tmp99_;
		ValaSemanticAnalyzer* _tmp100_;
		ValaSemanticAnalyzer* _tmp101_;
		ValaBlock* _tmp102_;
		ValaDeclarationStatement* _tmp103_;
		ValaSemanticAnalyzer* _tmp104_;
		ValaSemanticAnalyzer* _tmp105_;
		ValaBlock* _tmp106_;
		ValaIfStatement* _tmp107_;
		ValaDeclarationStatement* _tmp108_;
		ValaIfStatement* _tmp109_;
		ValaMemberAccess* ma = NULL;
		ValaLocalVariable* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		ValaSourceReference* _tmp113_;
		ValaSourceReference* _tmp114_;
		ValaMemberAccess* _tmp115_;
		ValaMemberAccess* _tmp116_;
		ValaDataType* _tmp117_;
		ValaDataType* _tmp118_;
		ValaMemberAccess* _tmp119_;
		ValaDataType* _tmp120_;
		ValaDataType* _tmp121_;
		ValaCodeNode* _tmp122_;
		ValaCodeNode* _tmp123_;
		ValaMemberAccess* _tmp124_;
		ValaMemberAccess* _tmp125_;
		_tmp12_ = vala_code_context_get_analyzer (context);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_->bool_type;
		_tmp15_ = vala_data_type_copy (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_code_node_get_temp_name ();
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_local_variable_new (_tmp16_, _tmp18_, NULL, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp18_);
		_vala_code_node_unref0 (_tmp16_);
		local = _tmp22_;
		_tmp23_ = local;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp25_);
		decl = _tmp26_;
		_tmp27_ = local;
		_tmp28_ = vala_symbol_get_name ((ValaSymbol*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_binary_expression_get_right (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_member_access_new_simple (_tmp29_, _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_binary_expression_get_right (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_binary_expression_get_right (self);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_assignment_new ((ValaExpression*) _tmp35_, _tmp37_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_binary_expression_get_right (self);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_statement_new ((ValaExpression*) _tmp43_, _tmp47_);
		_tmp49_ = _tmp48_;
		_vala_code_node_unref0 (_tmp43_);
		_vala_code_node_unref0 (_tmp35_);
		right_stmt = _tmp49_;
		_tmp50_ = local;
		_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_binary_expression_get_left (self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_member_access_new_simple (_tmp52_, _tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = self->priv->_operator;
		_tmp60_ = vala_binary_expression_get_left (self);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_boolean_literal_new (_tmp59_ == VALA_BINARY_OPERATOR_OR, _tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_binary_expression_get_left (self);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_assignment_new ((ValaExpression*) _tmp58_, (ValaExpression*) _tmp65_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_binary_expression_get_left (self);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_expression_statement_new ((ValaExpression*) _tmp71_, _tmp75_);
		_tmp77_ = _tmp76_;
		_vala_code_node_unref0 (_tmp71_);
		_vala_code_node_unref0 (_tmp65_);
		_vala_code_node_unref0 (_tmp58_);
		stmt = _tmp77_;
		_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_block_new (_tmp79_);
		true_block = _tmp80_;
		_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_block_new (_tmp82_);
		false_block = _tmp83_;
		_tmp84_ = self->priv->_operator;
		if (_tmp84_ == VALA_BINARY_OPERATOR_AND) {
			ValaBlock* _tmp85_;
			ValaExpressionStatement* _tmp86_;
			ValaBlock* _tmp87_;
			ValaExpressionStatement* _tmp88_;
			_tmp85_ = true_block;
			_tmp86_ = right_stmt;
			vala_block_add_statement (_tmp85_, (ValaStatement*) _tmp86_);
			_tmp87_ = false_block;
			_tmp88_ = stmt;
			vala_block_add_statement (_tmp87_, (ValaStatement*) _tmp88_);
		} else {
			ValaBlock* _tmp89_;
			ValaExpressionStatement* _tmp90_;
			ValaBlock* _tmp91_;
			ValaExpressionStatement* _tmp92_;
			_tmp89_ = true_block;
			_tmp90_ = stmt;
			vala_block_add_statement (_tmp89_, (ValaStatement*) _tmp90_);
			_tmp91_ = false_block;
			_tmp92_ = right_stmt;
			vala_block_add_statement (_tmp91_, (ValaStatement*) _tmp92_);
		}
		_tmp93_ = vala_binary_expression_get_left (self);
		_tmp94_ = _tmp93_;
		_tmp95_ = true_block;
		_tmp96_ = false_block;
		_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_if_statement_new (_tmp94_, _tmp95_, _tmp96_, _tmp98_);
		if_stmt = _tmp99_;
		_tmp100_ = vala_code_context_get_analyzer (context);
		_tmp101_ = _tmp100_;
		_tmp102_ = _tmp101_->insert_block;
		_tmp103_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp102_, (ValaStatement*) _tmp103_);
		_tmp104_ = vala_code_context_get_analyzer (context);
		_tmp105_ = _tmp104_;
		_tmp106_ = _tmp105_->insert_block;
		_tmp107_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp106_, (ValaStatement*) _tmp107_);
		_tmp108_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp108_, context);
		_tmp109_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp109_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (false_block);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			return result;
		}
		_tmp110_ = local;
		_tmp111_ = vala_symbol_get_name ((ValaSymbol*) _tmp110_);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_member_access_new_simple (_tmp112_, _tmp114_);
		ma = _tmp115_;
		_tmp116_ = ma;
		_tmp117_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp118_ = _tmp117_;
		vala_expression_set_target_type ((ValaExpression*) _tmp116_, _tmp118_);
		_tmp119_ = ma;
		_tmp120_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp121_ = _tmp120_;
		vala_expression_set_formal_target_type ((ValaExpression*) _tmp119_, _tmp121_);
		_tmp122_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp123_ = _tmp122_;
		_tmp124_ = ma;
		vala_code_node_replace_expression (_tmp123_, (ValaExpression*) self, (ValaExpression*) _tmp124_);
		_tmp125_ = ma;
		vala_code_node_check ((ValaCodeNode*) _tmp125_, context);
		result = TRUE;
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (false_block);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp126_ = self->priv->_operator;
	if (_tmp126_ == VALA_BINARY_OPERATOR_COALESCE) {
		ValaExpression* _tmp127_;
		ValaExpression* _tmp128_;
		ValaExpression* _tmp129_;
		ValaExpression* _tmp130_;
		ValaDataType* local_type = NULL;
		gboolean cast_non_null = FALSE;
		gboolean _tmp131_ = FALSE;
		ValaExpression* _tmp132_;
		ValaExpression* _tmp133_;
		ValaDataType* _tmp134_;
		ValaDataType* _tmp135_;
		ValaLocalVariable* local = NULL;
		ValaDataType* _tmp218_;
		gchar* _tmp219_;
		gchar* _tmp220_;
		ValaExpression* _tmp221_;
		ValaExpression* _tmp222_;
		ValaSourceReference* _tmp223_;
		ValaSourceReference* _tmp224_;
		ValaLocalVariable* _tmp225_;
		ValaLocalVariable* _tmp226_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp227_;
		ValaSourceReference* _tmp228_;
		ValaSourceReference* _tmp229_;
		ValaDeclarationStatement* _tmp230_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp231_;
		const gchar* _tmp232_;
		const gchar* _tmp233_;
		ValaExpression* _tmp234_;
		ValaExpression* _tmp235_;
		ValaSourceReference* _tmp236_;
		ValaSourceReference* _tmp237_;
		ValaMemberAccess* _tmp238_;
		ValaMemberAccess* _tmp239_;
		ValaExpression* _tmp240_;
		ValaExpression* _tmp241_;
		ValaExpression* _tmp242_;
		ValaExpression* _tmp243_;
		ValaSourceReference* _tmp244_;
		ValaSourceReference* _tmp245_;
		ValaAssignment* _tmp246_;
		ValaAssignment* _tmp247_;
		ValaExpression* _tmp248_;
		ValaExpression* _tmp249_;
		ValaSourceReference* _tmp250_;
		ValaSourceReference* _tmp251_;
		ValaExpressionStatement* _tmp252_;
		ValaExpressionStatement* _tmp253_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp254_;
		ValaSourceReference* _tmp255_;
		ValaBlock* _tmp256_;
		ValaBlock* _tmp257_;
		ValaExpressionStatement* _tmp258_;
		ValaBinaryExpression* cond = NULL;
		ValaLocalVariable* _tmp259_;
		const gchar* _tmp260_;
		const gchar* _tmp261_;
		ValaExpression* _tmp262_;
		ValaExpression* _tmp263_;
		ValaSourceReference* _tmp264_;
		ValaSourceReference* _tmp265_;
		ValaMemberAccess* _tmp266_;
		ValaMemberAccess* _tmp267_;
		ValaSourceReference* _tmp268_;
		ValaSourceReference* _tmp269_;
		ValaNullLiteral* _tmp270_;
		ValaNullLiteral* _tmp271_;
		ValaSourceReference* _tmp272_;
		ValaSourceReference* _tmp273_;
		ValaBinaryExpression* _tmp274_;
		ValaBinaryExpression* _tmp275_;
		ValaIfStatement* if_stmt = NULL;
		ValaBinaryExpression* _tmp276_;
		ValaBlock* _tmp277_;
		ValaSourceReference* _tmp278_;
		ValaSourceReference* _tmp279_;
		ValaIfStatement* _tmp280_;
		ValaSemanticAnalyzer* _tmp281_;
		ValaSemanticAnalyzer* _tmp282_;
		ValaBlock* _tmp283_;
		ValaDeclarationStatement* _tmp284_;
		ValaSemanticAnalyzer* _tmp285_;
		ValaSemanticAnalyzer* _tmp286_;
		ValaBlock* _tmp287_;
		ValaIfStatement* _tmp288_;
		ValaDeclarationStatement* _tmp289_;
		ValaIfStatement* _tmp290_;
		ValaExpression* replace_expr = NULL;
		ValaLocalVariable* _tmp291_;
		ValaDataType* _tmp292_;
		ValaDataType* _tmp293_;
		ValaExpression* _tmp294_;
		gboolean _tmp295_ = FALSE;
		gboolean _tmp296_;
		ValaCodeNode* _tmp315_;
		ValaCodeNode* _tmp316_;
		ValaExpression* _tmp317_;
		ValaExpression* _tmp318_;
		_tmp127_ = vala_binary_expression_get_left (self);
		_tmp128_ = _tmp127_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp128_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp129_ = vala_binary_expression_get_right (self);
		_tmp130_ = _tmp129_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp130_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		local_type = NULL;
		cast_non_null = FALSE;
		_tmp132_ = vala_binary_expression_get_left (self);
		_tmp133_ = _tmp132_;
		_tmp134_ = vala_expression_get_value_type (_tmp133_);
		_tmp135_ = _tmp134_;
		if (VALA_IS_NULL_TYPE (_tmp135_)) {
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			ValaDataType* _tmp138_;
			ValaDataType* _tmp139_;
			_tmp136_ = vala_binary_expression_get_right (self);
			_tmp137_ = _tmp136_;
			_tmp138_ = vala_expression_get_value_type (_tmp137_);
			_tmp139_ = _tmp138_;
			_tmp131_ = _tmp139_ != NULL;
		} else {
			_tmp131_ = FALSE;
		}
		if (_tmp131_) {
			ValaExpression* _tmp140_;
			ValaExpression* _tmp141_;
			ValaSourceReference* _tmp142_;
			ValaSourceReference* _tmp143_;
			ValaExpression* _tmp144_;
			ValaExpression* _tmp145_;
			ValaDataType* _tmp146_;
			ValaDataType* _tmp147_;
			ValaDataType* _tmp148_;
			ValaDataType* _tmp149_;
			ValaExpression* _tmp150_;
			ValaExpression* _tmp151_;
			ValaDataType* _tmp152_;
			ValaDataType* _tmp153_;
			gboolean _tmp154_;
			gboolean _tmp155_;
			_tmp140_ = vala_binary_expression_get_left (self);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp141_);
			_tmp143_ = _tmp142_;
			vala_report_warning (_tmp143_, "left operand is always null");
			_tmp144_ = vala_binary_expression_get_right (self);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_expression_get_value_type (_tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = vala_data_type_copy (_tmp147_);
			_vala_code_node_unref0 (local_type);
			local_type = _tmp148_;
			_tmp149_ = local_type;
			vala_data_type_set_nullable (_tmp149_, TRUE);
			_tmp150_ = vala_binary_expression_get_right (self);
			_tmp151_ = _tmp150_;
			_tmp152_ = vala_expression_get_value_type (_tmp151_);
			_tmp153_ = _tmp152_;
			_tmp154_ = vala_data_type_get_nullable (_tmp153_);
			_tmp155_ = _tmp154_;
			if (!_tmp155_) {
				cast_non_null = TRUE;
			}
		} else {
			ValaExpression* _tmp156_;
			ValaExpression* _tmp157_;
			ValaDataType* _tmp158_;
			ValaDataType* _tmp159_;
			_tmp156_ = vala_binary_expression_get_left (self);
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_expression_get_value_type (_tmp157_);
			_tmp159_ = _tmp158_;
			if (_tmp159_ != NULL) {
				ValaExpression* _tmp160_;
				ValaExpression* _tmp161_;
				ValaDataType* _tmp162_;
				ValaDataType* _tmp163_;
				ValaDataType* _tmp164_;
				gboolean _tmp165_ = FALSE;
				ValaExpression* _tmp166_;
				ValaExpression* _tmp167_;
				ValaDataType* _tmp168_;
				ValaDataType* _tmp169_;
				gboolean _tmp177_;
				gboolean _tmp178_;
				_tmp160_ = vala_binary_expression_get_left (self);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_expression_get_value_type (_tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = vala_data_type_copy (_tmp163_);
				_vala_code_node_unref0 (local_type);
				local_type = _tmp164_;
				_tmp166_ = vala_binary_expression_get_right (self);
				_tmp167_ = _tmp166_;
				_tmp168_ = vala_expression_get_value_type (_tmp167_);
				_tmp169_ = _tmp168_;
				if (_tmp169_ != NULL) {
					ValaExpression* _tmp170_;
					ValaExpression* _tmp171_;
					ValaDataType* _tmp172_;
					ValaDataType* _tmp173_;
					gboolean _tmp174_;
					gboolean _tmp175_;
					_tmp170_ = vala_binary_expression_get_right (self);
					_tmp171_ = _tmp170_;
					_tmp172_ = vala_expression_get_value_type (_tmp171_);
					_tmp173_ = _tmp172_;
					_tmp174_ = vala_data_type_get_value_owned (_tmp173_);
					_tmp175_ = _tmp174_;
					_tmp165_ = _tmp175_;
				} else {
					_tmp165_ = FALSE;
				}
				if (_tmp165_) {
					ValaDataType* _tmp176_;
					_tmp176_ = local_type;
					vala_data_type_set_value_owned (_tmp176_, TRUE);
				}
				_tmp177_ = vala_code_context_get_experimental_non_null (context);
				_tmp178_ = _tmp177_;
				if (_tmp178_) {
					ValaDataType* _tmp179_;
					gboolean _tmp180_;
					gboolean _tmp181_;
					_tmp179_ = local_type;
					_tmp180_ = vala_data_type_get_nullable (_tmp179_);
					_tmp181_ = _tmp180_;
					if (!_tmp181_) {
						ValaExpression* _tmp182_;
						ValaExpression* _tmp183_;
						ValaSourceReference* _tmp184_;
						ValaSourceReference* _tmp185_;
						gboolean _tmp186_ = FALSE;
						ValaExpression* _tmp187_;
						ValaExpression* _tmp188_;
						ValaDataType* _tmp189_;
						ValaDataType* _tmp190_;
						_tmp182_ = vala_binary_expression_get_left (self);
						_tmp183_ = _tmp182_;
						_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp183_);
						_tmp185_ = _tmp184_;
						vala_report_warning (_tmp185_, "left operand is never null");
						_tmp187_ = vala_binary_expression_get_right (self);
						_tmp188_ = _tmp187_;
						_tmp189_ = vala_expression_get_value_type (_tmp188_);
						_tmp190_ = _tmp189_;
						if (_tmp190_ != NULL) {
							ValaExpression* _tmp191_;
							ValaExpression* _tmp192_;
							ValaDataType* _tmp193_;
							ValaDataType* _tmp194_;
							gboolean _tmp195_;
							gboolean _tmp196_;
							_tmp191_ = vala_binary_expression_get_right (self);
							_tmp192_ = _tmp191_;
							_tmp193_ = vala_expression_get_value_type (_tmp192_);
							_tmp194_ = _tmp193_;
							_tmp195_ = vala_data_type_get_nullable (_tmp194_);
							_tmp196_ = _tmp195_;
							_tmp186_ = _tmp196_;
						} else {
							_tmp186_ = FALSE;
						}
						if (_tmp186_) {
							ValaDataType* _tmp197_;
							_tmp197_ = local_type;
							vala_data_type_set_nullable (_tmp197_, TRUE);
							cast_non_null = TRUE;
						}
					} else {
						gboolean _tmp198_ = FALSE;
						ValaExpression* _tmp199_;
						ValaExpression* _tmp200_;
						ValaDataType* _tmp201_;
						ValaDataType* _tmp202_;
						_tmp199_ = vala_binary_expression_get_right (self);
						_tmp200_ = _tmp199_;
						_tmp201_ = vala_expression_get_value_type (_tmp200_);
						_tmp202_ = _tmp201_;
						if (_tmp202_ != NULL) {
							ValaExpression* _tmp203_;
							ValaExpression* _tmp204_;
							ValaDataType* _tmp205_;
							ValaDataType* _tmp206_;
							gboolean _tmp207_;
							gboolean _tmp208_;
							_tmp203_ = vala_binary_expression_get_right (self);
							_tmp204_ = _tmp203_;
							_tmp205_ = vala_expression_get_value_type (_tmp204_);
							_tmp206_ = _tmp205_;
							_tmp207_ = vala_data_type_get_nullable (_tmp206_);
							_tmp208_ = _tmp207_;
							_tmp198_ = !_tmp208_;
						} else {
							_tmp198_ = FALSE;
						}
						if (_tmp198_) {
							cast_non_null = TRUE;
						}
					}
				}
			} else {
				ValaExpression* _tmp209_;
				ValaExpression* _tmp210_;
				ValaDataType* _tmp211_;
				ValaDataType* _tmp212_;
				_tmp209_ = vala_binary_expression_get_right (self);
				_tmp210_ = _tmp209_;
				_tmp211_ = vala_expression_get_value_type (_tmp210_);
				_tmp212_ = _tmp211_;
				if (_tmp212_ != NULL) {
					ValaExpression* _tmp213_;
					ValaExpression* _tmp214_;
					ValaDataType* _tmp215_;
					ValaDataType* _tmp216_;
					ValaDataType* _tmp217_;
					_tmp213_ = vala_binary_expression_get_right (self);
					_tmp214_ = _tmp213_;
					_tmp215_ = vala_expression_get_value_type (_tmp214_);
					_tmp216_ = _tmp215_;
					_tmp217_ = vala_data_type_copy (_tmp216_);
					_vala_code_node_unref0 (local_type);
					local_type = _tmp217_;
				}
			}
		}
		_tmp218_ = local_type;
		_tmp219_ = vala_code_node_get_temp_name ();
		_tmp220_ = _tmp219_;
		_tmp221_ = vala_binary_expression_get_left (self);
		_tmp222_ = _tmp221_;
		_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp224_ = _tmp223_;
		_tmp225_ = vala_local_variable_new (_tmp218_, _tmp220_, _tmp222_, _tmp224_);
		_tmp226_ = _tmp225_;
		_g_free0 (_tmp220_);
		local = _tmp226_;
		_tmp227_ = local;
		_tmp228_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp229_ = _tmp228_;
		_tmp230_ = vala_declaration_statement_new ((ValaSymbol*) _tmp227_, _tmp229_);
		decl = _tmp230_;
		_tmp231_ = local;
		_tmp232_ = vala_symbol_get_name ((ValaSymbol*) _tmp231_);
		_tmp233_ = _tmp232_;
		_tmp234_ = vala_binary_expression_get_right (self);
		_tmp235_ = _tmp234_;
		_tmp236_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp235_);
		_tmp237_ = _tmp236_;
		_tmp238_ = vala_member_access_new_simple (_tmp233_, _tmp237_);
		_tmp239_ = _tmp238_;
		_tmp240_ = vala_binary_expression_get_right (self);
		_tmp241_ = _tmp240_;
		_tmp242_ = vala_binary_expression_get_right (self);
		_tmp243_ = _tmp242_;
		_tmp244_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp243_);
		_tmp245_ = _tmp244_;
		_tmp246_ = vala_assignment_new ((ValaExpression*) _tmp239_, _tmp241_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp245_);
		_tmp247_ = _tmp246_;
		_tmp248_ = vala_binary_expression_get_right (self);
		_tmp249_ = _tmp248_;
		_tmp250_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp249_);
		_tmp251_ = _tmp250_;
		_tmp252_ = vala_expression_statement_new ((ValaExpression*) _tmp247_, _tmp251_);
		_tmp253_ = _tmp252_;
		_vala_code_node_unref0 (_tmp247_);
		_vala_code_node_unref0 (_tmp239_);
		right_stmt = _tmp253_;
		_tmp254_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp255_ = _tmp254_;
		_tmp256_ = vala_block_new (_tmp255_);
		true_block = _tmp256_;
		_tmp257_ = true_block;
		_tmp258_ = right_stmt;
		vala_block_add_statement (_tmp257_, (ValaStatement*) _tmp258_);
		_tmp259_ = local;
		_tmp260_ = vala_symbol_get_name ((ValaSymbol*) _tmp259_);
		_tmp261_ = _tmp260_;
		_tmp262_ = vala_binary_expression_get_left (self);
		_tmp263_ = _tmp262_;
		_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp263_);
		_tmp265_ = _tmp264_;
		_tmp266_ = vala_member_access_new_simple (_tmp261_, _tmp265_);
		_tmp267_ = _tmp266_;
		_tmp268_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp269_ = _tmp268_;
		_tmp270_ = vala_null_literal_new (_tmp269_);
		_tmp271_ = _tmp270_;
		_tmp272_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp273_ = _tmp272_;
		_tmp274_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_EQUALITY, (ValaExpression*) _tmp267_, (ValaExpression*) _tmp271_, _tmp273_);
		_tmp275_ = _tmp274_;
		_vala_code_node_unref0 (_tmp271_);
		_vala_code_node_unref0 (_tmp267_);
		cond = _tmp275_;
		_tmp276_ = cond;
		_tmp277_ = true_block;
		_tmp278_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp279_ = _tmp278_;
		_tmp280_ = vala_if_statement_new ((ValaExpression*) _tmp276_, _tmp277_, NULL, _tmp279_);
		if_stmt = _tmp280_;
		_tmp281_ = vala_code_context_get_analyzer (context);
		_tmp282_ = _tmp281_;
		_tmp283_ = _tmp282_->insert_block;
		_tmp284_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp283_, (ValaStatement*) _tmp284_);
		_tmp285_ = vala_code_context_get_analyzer (context);
		_tmp286_ = _tmp285_;
		_tmp287_ = _tmp286_->insert_block;
		_tmp288_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp287_, (ValaStatement*) _tmp288_);
		_tmp289_ = decl;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp289_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (cond);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			return result;
		}
		_tmp290_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp290_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (cond);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			return result;
		}
		_tmp291_ = local;
		_tmp292_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp293_ = _tmp292_;
		_tmp294_ = vala_semantic_analyzer_create_temp_access (_tmp291_, _tmp293_);
		replace_expr = _tmp294_;
		_tmp296_ = cast_non_null;
		if (_tmp296_) {
			ValaExpression* _tmp297_;
			ValaDataType* _tmp298_;
			ValaDataType* _tmp299_;
			_tmp297_ = replace_expr;
			_tmp298_ = vala_expression_get_target_type (_tmp297_);
			_tmp299_ = _tmp298_;
			_tmp295_ = _tmp299_ != NULL;
		} else {
			_tmp295_ = FALSE;
		}
		if (_tmp295_) {
			ValaCastExpression* cast = NULL;
			ValaExpression* _tmp300_;
			ValaSourceReference* _tmp301_;
			ValaSourceReference* _tmp302_;
			ValaCastExpression* _tmp303_;
			ValaCastExpression* _tmp304_;
			ValaExpression* _tmp305_;
			ValaDataType* _tmp306_;
			ValaDataType* _tmp307_;
			ValaDataType* _tmp308_;
			ValaDataType* _tmp309_;
			ValaCastExpression* _tmp310_;
			ValaDataType* _tmp311_;
			ValaDataType* _tmp312_;
			ValaCastExpression* _tmp313_;
			ValaExpression* _tmp314_;
			_tmp300_ = replace_expr;
			_tmp301_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp302_ = _tmp301_;
			_tmp303_ = vala_cast_expression_new_non_null (_tmp300_, _tmp302_);
			cast = _tmp303_;
			_tmp304_ = cast;
			_tmp305_ = replace_expr;
			_tmp306_ = vala_expression_get_target_type (_tmp305_);
			_tmp307_ = _tmp306_;
			_tmp308_ = vala_data_type_copy (_tmp307_);
			_tmp309_ = _tmp308_;
			vala_expression_set_target_type ((ValaExpression*) _tmp304_, _tmp309_);
			_vala_code_node_unref0 (_tmp309_);
			_tmp310_ = cast;
			_tmp311_ = vala_expression_get_target_type ((ValaExpression*) _tmp310_);
			_tmp312_ = _tmp311_;
			vala_data_type_set_nullable (_tmp312_, FALSE);
			_tmp313_ = cast;
			_tmp314_ = _vala_code_node_ref0 ((ValaExpression*) _tmp313_);
			_vala_code_node_unref0 (replace_expr);
			replace_expr = _tmp314_;
			_vala_code_node_unref0 (cast);
		}
		_tmp315_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp316_ = _tmp315_;
		_tmp317_ = replace_expr;
		vala_code_node_replace_expression (_tmp316_, (ValaExpression*) self, _tmp317_);
		_tmp318_ = replace_expr;
		vala_code_node_check ((ValaCodeNode*) _tmp318_, context);
		result = TRUE;
		_vala_code_node_unref0 (replace_expr);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (cond);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (local_type);
		return result;
	}
	_tmp321_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp322_ = _tmp321_;
	if (_tmp322_ != NULL) {
		ValaDataType* _tmp323_;
		ValaDataType* _tmp324_;
		ValaTypeSymbol* _tmp325_;
		ValaTypeSymbol* _tmp326_;
		_tmp323_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp324_ = _tmp323_;
		_tmp325_ = vala_data_type_get_data_type (_tmp324_);
		_tmp326_ = _tmp325_;
		_tmp320_ = VALA_IS_ENUM (_tmp326_);
	} else {
		_tmp320_ = FALSE;
	}
	if (_tmp320_) {
		gboolean _tmp327_ = FALSE;
		ValaBinaryOperator _tmp328_;
		_tmp328_ = self->priv->_operator;
		if (_tmp328_ == VALA_BINARY_OPERATOR_BITWISE_AND) {
			_tmp327_ = TRUE;
		} else {
			ValaBinaryOperator _tmp329_;
			_tmp329_ = self->priv->_operator;
			_tmp327_ = _tmp329_ == VALA_BINARY_OPERATOR_BITWISE_OR;
		}
		_tmp319_ = _tmp327_;
	} else {
		_tmp319_ = FALSE;
	}
	if (_tmp319_) {
		ValaExpression* _tmp330_;
		ValaExpression* _tmp331_;
		ValaDataType* _tmp332_;
		ValaDataType* _tmp333_;
		ValaDataType* _tmp334_;
		ValaDataType* _tmp335_;
		ValaExpression* _tmp336_;
		ValaExpression* _tmp337_;
		ValaDataType* _tmp338_;
		ValaDataType* _tmp339_;
		ValaDataType* _tmp340_;
		ValaDataType* _tmp341_;
		_tmp330_ = vala_binary_expression_get_left (self);
		_tmp331_ = _tmp330_;
		_tmp332_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp333_ = _tmp332_;
		_tmp334_ = vala_data_type_copy (_tmp333_);
		_tmp335_ = _tmp334_;
		vala_expression_set_target_type (_tmp331_, _tmp335_);
		_vala_code_node_unref0 (_tmp335_);
		_tmp336_ = vala_binary_expression_get_right (self);
		_tmp337_ = _tmp336_;
		_tmp338_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp339_ = _tmp338_;
		_tmp340_ = vala_data_type_copy (_tmp339_);
		_tmp341_ = _tmp340_;
		vala_expression_set_target_type (_tmp337_, _tmp341_);
		_vala_code_node_unref0 (_tmp341_);
	}
	_tmp342_ = vala_binary_expression_get_left (self);
	_tmp343_ = _tmp342_;
	vala_code_node_check ((ValaCodeNode*) _tmp343_, context);
	_tmp346_ = vala_binary_expression_get_left (self);
	_tmp347_ = _tmp346_;
	_tmp348_ = vala_expression_get_value_type (_tmp347_);
	_tmp349_ = _tmp348_;
	if (_tmp349_ != NULL) {
		ValaExpression* _tmp350_;
		ValaExpression* _tmp351_;
		ValaDataType* _tmp352_;
		ValaDataType* _tmp353_;
		ValaTypeSymbol* _tmp354_;
		ValaTypeSymbol* _tmp355_;
		_tmp350_ = vala_binary_expression_get_left (self);
		_tmp351_ = _tmp350_;
		_tmp352_ = vala_expression_get_value_type (_tmp351_);
		_tmp353_ = _tmp352_;
		_tmp354_ = vala_data_type_get_data_type (_tmp353_);
		_tmp355_ = _tmp354_;
		_tmp345_ = VALA_IS_ENUM (_tmp355_);
	} else {
		_tmp345_ = FALSE;
	}
	if (_tmp345_) {
		gboolean _tmp356_ = FALSE;
		ValaBinaryOperator _tmp357_;
		_tmp357_ = self->priv->_operator;
		if (_tmp357_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp356_ = TRUE;
		} else {
			ValaBinaryOperator _tmp358_;
			_tmp358_ = self->priv->_operator;
			_tmp356_ = _tmp358_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp344_ = _tmp356_;
	} else {
		_tmp344_ = FALSE;
	}
	if (_tmp344_) {
		ValaExpression* _tmp359_;
		ValaExpression* _tmp360_;
		ValaExpression* _tmp361_;
		ValaExpression* _tmp362_;
		ValaDataType* _tmp363_;
		ValaDataType* _tmp364_;
		ValaDataType* _tmp365_;
		ValaDataType* _tmp366_;
		_tmp359_ = vala_binary_expression_get_right (self);
		_tmp360_ = _tmp359_;
		_tmp361_ = vala_binary_expression_get_left (self);
		_tmp362_ = _tmp361_;
		_tmp363_ = vala_expression_get_value_type (_tmp362_);
		_tmp364_ = _tmp363_;
		_tmp365_ = vala_data_type_copy (_tmp364_);
		_tmp366_ = _tmp365_;
		vala_expression_set_target_type (_tmp360_, _tmp366_);
		_vala_code_node_unref0 (_tmp366_);
	}
	_tmp367_ = vala_binary_expression_get_right (self);
	_tmp368_ = _tmp367_;
	vala_code_node_check ((ValaCodeNode*) _tmp368_, context);
	_tmp371_ = vala_binary_expression_get_right (self);
	_tmp372_ = _tmp371_;
	_tmp373_ = vala_expression_get_value_type (_tmp372_);
	_tmp374_ = _tmp373_;
	if (_tmp374_ != NULL) {
		ValaExpression* _tmp375_;
		ValaExpression* _tmp376_;
		ValaDataType* _tmp377_;
		ValaDataType* _tmp378_;
		ValaTypeSymbol* _tmp379_;
		ValaTypeSymbol* _tmp380_;
		_tmp375_ = vala_binary_expression_get_right (self);
		_tmp376_ = _tmp375_;
		_tmp377_ = vala_expression_get_value_type (_tmp376_);
		_tmp378_ = _tmp377_;
		_tmp379_ = vala_data_type_get_data_type (_tmp378_);
		_tmp380_ = _tmp379_;
		_tmp370_ = VALA_IS_ENUM (_tmp380_);
	} else {
		_tmp370_ = FALSE;
	}
	if (_tmp370_) {
		gboolean _tmp381_ = FALSE;
		ValaBinaryOperator _tmp382_;
		_tmp382_ = self->priv->_operator;
		if (_tmp382_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp381_ = TRUE;
		} else {
			ValaBinaryOperator _tmp383_;
			_tmp383_ = self->priv->_operator;
			_tmp381_ = _tmp383_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp369_ = _tmp381_;
	} else {
		_tmp369_ = FALSE;
	}
	if (_tmp369_) {
		ValaExpression* _tmp384_;
		ValaExpression* _tmp385_;
		ValaExpression* _tmp386_;
		ValaExpression* _tmp387_;
		ValaDataType* _tmp388_;
		ValaDataType* _tmp389_;
		ValaDataType* _tmp390_;
		ValaDataType* _tmp391_;
		_tmp384_ = vala_binary_expression_get_left (self);
		_tmp385_ = _tmp384_;
		_tmp386_ = vala_binary_expression_get_right (self);
		_tmp387_ = _tmp386_;
		_tmp388_ = vala_expression_get_value_type (_tmp387_);
		_tmp389_ = _tmp388_;
		_tmp390_ = vala_data_type_copy (_tmp389_);
		_tmp391_ = _tmp390_;
		vala_expression_set_target_type (_tmp385_, _tmp391_);
		_vala_code_node_unref0 (_tmp391_);
	}
	_tmp393_ = vala_binary_expression_get_left (self);
	_tmp394_ = _tmp393_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp394_, context)) {
		_tmp392_ = TRUE;
	} else {
		ValaExpression* _tmp395_;
		ValaExpression* _tmp396_;
		_tmp395_ = vala_binary_expression_get_right (self);
		_tmp396_ = _tmp395_;
		_tmp392_ = !vala_code_node_check ((ValaCodeNode*) _tmp396_, context);
	}
	if (_tmp392_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp397_ = vala_binary_expression_get_left (self);
	_tmp398_ = _tmp397_;
	_tmp399_ = vala_expression_get_value_type (_tmp398_);
	_tmp400_ = _tmp399_;
	if (_tmp400_ == NULL) {
		ValaExpression* _tmp401_;
		ValaExpression* _tmp402_;
		ValaSourceReference* _tmp403_;
		ValaSourceReference* _tmp404_;
		_tmp401_ = vala_binary_expression_get_left (self);
		_tmp402_ = _tmp401_;
		_tmp403_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp402_);
		_tmp404_ = _tmp403_;
		vala_report_error (_tmp404_, "invalid left operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp406_ = self->priv->_operator;
	if (_tmp406_ != VALA_BINARY_OPERATOR_IN) {
		ValaExpression* _tmp407_;
		ValaExpression* _tmp408_;
		ValaDataType* _tmp409_;
		ValaDataType* _tmp410_;
		_tmp407_ = vala_binary_expression_get_right (self);
		_tmp408_ = _tmp407_;
		_tmp409_ = vala_expression_get_value_type (_tmp408_);
		_tmp410_ = _tmp409_;
		_tmp405_ = _tmp410_ == NULL;
	} else {
		_tmp405_ = FALSE;
	}
	if (_tmp405_) {
		ValaExpression* _tmp411_;
		ValaExpression* _tmp412_;
		ValaSourceReference* _tmp413_;
		ValaSourceReference* _tmp414_;
		_tmp411_ = vala_binary_expression_get_right (self);
		_tmp412_ = _tmp411_;
		_tmp413_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp412_);
		_tmp414_ = _tmp413_;
		vala_report_error (_tmp414_, "invalid right operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp416_ = vala_binary_expression_get_left (self);
	_tmp417_ = _tmp416_;
	_tmp418_ = vala_expression_get_value_type (_tmp417_);
	_tmp419_ = _tmp418_;
	if (VALA_IS_FIELD_PROTOTYPE (_tmp419_)) {
		_tmp415_ = TRUE;
	} else {
		ValaExpression* _tmp420_;
		ValaExpression* _tmp421_;
		ValaDataType* _tmp422_;
		ValaDataType* _tmp423_;
		_tmp420_ = vala_binary_expression_get_left (self);
		_tmp421_ = _tmp420_;
		_tmp422_ = vala_expression_get_value_type (_tmp421_);
		_tmp423_ = _tmp422_;
		_tmp415_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp423_);
	}
	if (_tmp415_) {
		ValaExpression* _tmp424_;
		ValaExpression* _tmp425_;
		ValaSourceReference* _tmp426_;
		ValaSourceReference* _tmp427_;
		ValaExpression* _tmp428_;
		ValaExpression* _tmp429_;
		ValaSymbol* _tmp430_;
		ValaSymbol* _tmp431_;
		gchar* _tmp432_;
		gchar* _tmp433_;
		gchar* _tmp434_;
		gchar* _tmp435_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp424_ = vala_binary_expression_get_left (self);
		_tmp425_ = _tmp424_;
		_tmp426_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp425_);
		_tmp427_ = _tmp426_;
		_tmp428_ = vala_binary_expression_get_left (self);
		_tmp429_ = _tmp428_;
		_tmp430_ = vala_expression_get_symbol_reference (_tmp429_);
		_tmp431_ = _tmp430_;
		_tmp432_ = vala_symbol_get_full_name (_tmp431_);
		_tmp433_ = _tmp432_;
		_tmp434_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp433_);
		_tmp435_ = _tmp434_;
		vala_report_error (_tmp427_, _tmp435_);
		_g_free0 (_tmp435_);
		_g_free0 (_tmp433_);
		result = FALSE;
		return result;
	}
	_tmp437_ = vala_binary_expression_get_right (self);
	_tmp438_ = _tmp437_;
	_tmp439_ = vala_expression_get_value_type (_tmp438_);
	_tmp440_ = _tmp439_;
	if (VALA_IS_FIELD_PROTOTYPE (_tmp440_)) {
		_tmp436_ = TRUE;
	} else {
		ValaExpression* _tmp441_;
		ValaExpression* _tmp442_;
		ValaDataType* _tmp443_;
		ValaDataType* _tmp444_;
		_tmp441_ = vala_binary_expression_get_right (self);
		_tmp442_ = _tmp441_;
		_tmp443_ = vala_expression_get_value_type (_tmp442_);
		_tmp444_ = _tmp443_;
		_tmp436_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp444_);
	}
	if (_tmp436_) {
		ValaExpression* _tmp445_;
		ValaExpression* _tmp446_;
		ValaSourceReference* _tmp447_;
		ValaSourceReference* _tmp448_;
		ValaExpression* _tmp449_;
		ValaExpression* _tmp450_;
		ValaSymbol* _tmp451_;
		ValaSymbol* _tmp452_;
		gchar* _tmp453_;
		gchar* _tmp454_;
		gchar* _tmp455_;
		gchar* _tmp456_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp445_ = vala_binary_expression_get_right (self);
		_tmp446_ = _tmp445_;
		_tmp447_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp446_);
		_tmp448_ = _tmp447_;
		_tmp449_ = vala_binary_expression_get_right (self);
		_tmp450_ = _tmp449_;
		_tmp451_ = vala_expression_get_symbol_reference (_tmp450_);
		_tmp452_ = _tmp451_;
		_tmp453_ = vala_symbol_get_full_name (_tmp452_);
		_tmp454_ = _tmp453_;
		_tmp455_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp454_);
		_tmp456_ = _tmp455_;
		vala_report_error (_tmp448_, _tmp456_);
		_g_free0 (_tmp456_);
		_g_free0 (_tmp454_);
		result = FALSE;
		return result;
	}
	_tmp457_ = vala_binary_expression_get_left (self);
	_tmp458_ = _tmp457_;
	_tmp459_ = vala_binary_expression_get_left (self);
	_tmp460_ = _tmp459_;
	_tmp461_ = vala_expression_get_value_type (_tmp460_);
	_tmp462_ = _tmp461_;
	_tmp463_ = vala_data_type_copy (_tmp462_);
	_tmp464_ = _tmp463_;
	vala_expression_set_target_type (_tmp458_, _tmp464_);
	_vala_code_node_unref0 (_tmp464_);
	_tmp465_ = vala_binary_expression_get_left (self);
	_tmp466_ = _tmp465_;
	_tmp467_ = vala_expression_get_target_type (_tmp466_);
	_tmp468_ = _tmp467_;
	vala_data_type_set_value_owned (_tmp468_, FALSE);
	_tmp469_ = vala_binary_expression_get_right (self);
	_tmp470_ = _tmp469_;
	_tmp471_ = vala_binary_expression_get_right (self);
	_tmp472_ = _tmp471_;
	_tmp473_ = vala_expression_get_value_type (_tmp472_);
	_tmp474_ = _tmp473_;
	_tmp475_ = vala_data_type_copy (_tmp474_);
	_tmp476_ = _tmp475_;
	vala_expression_set_target_type (_tmp470_, _tmp476_);
	_vala_code_node_unref0 (_tmp476_);
	_tmp477_ = vala_binary_expression_get_right (self);
	_tmp478_ = _tmp477_;
	_tmp479_ = vala_expression_get_target_type (_tmp478_);
	_tmp480_ = _tmp479_;
	vala_data_type_set_value_owned (_tmp480_, FALSE);
	_tmp482_ = vala_binary_expression_get_left (self);
	_tmp483_ = _tmp482_;
	_tmp484_ = vala_expression_get_value_type (_tmp483_);
	_tmp485_ = _tmp484_;
	_tmp486_ = vala_data_type_get_data_type (_tmp485_);
	_tmp487_ = _tmp486_;
	_tmp488_ = vala_code_context_get_analyzer (context);
	_tmp489_ = _tmp488_;
	_tmp490_ = _tmp489_->string_type;
	_tmp491_ = vala_data_type_get_data_type (_tmp490_);
	_tmp492_ = _tmp491_;
	if (_tmp487_ == _tmp492_) {
		ValaBinaryOperator _tmp493_;
		_tmp493_ = self->priv->_operator;
		_tmp481_ = _tmp493_ == VALA_BINARY_OPERATOR_PLUS;
	} else {
		_tmp481_ = FALSE;
	}
	if (_tmp481_) {
		gboolean _tmp494_ = FALSE;
		ValaExpression* _tmp495_;
		ValaExpression* _tmp496_;
		ValaDataType* _tmp497_;
		ValaDataType* _tmp498_;
		ValaSemanticAnalyzer* _tmp512_;
		ValaSemanticAnalyzer* _tmp513_;
		ValaDataType* _tmp514_;
		ValaDataType* _tmp515_;
		ValaDataType* _tmp516_;
		gboolean _tmp517_ = FALSE;
		ValaExpression* _tmp518_;
		ValaExpression* _tmp519_;
		_tmp495_ = vala_binary_expression_get_right (self);
		_tmp496_ = _tmp495_;
		_tmp497_ = vala_expression_get_value_type (_tmp496_);
		_tmp498_ = _tmp497_;
		if (_tmp498_ == NULL) {
			_tmp494_ = TRUE;
		} else {
			ValaExpression* _tmp499_;
			ValaExpression* _tmp500_;
			ValaDataType* _tmp501_;
			ValaDataType* _tmp502_;
			ValaTypeSymbol* _tmp503_;
			ValaTypeSymbol* _tmp504_;
			ValaSemanticAnalyzer* _tmp505_;
			ValaSemanticAnalyzer* _tmp506_;
			ValaDataType* _tmp507_;
			ValaTypeSymbol* _tmp508_;
			ValaTypeSymbol* _tmp509_;
			_tmp499_ = vala_binary_expression_get_right (self);
			_tmp500_ = _tmp499_;
			_tmp501_ = vala_expression_get_value_type (_tmp500_);
			_tmp502_ = _tmp501_;
			_tmp503_ = vala_data_type_get_data_type (_tmp502_);
			_tmp504_ = _tmp503_;
			_tmp505_ = vala_code_context_get_analyzer (context);
			_tmp506_ = _tmp505_;
			_tmp507_ = _tmp506_->string_type;
			_tmp508_ = vala_data_type_get_data_type (_tmp507_);
			_tmp509_ = _tmp508_;
			_tmp494_ = _tmp504_ != _tmp509_;
		}
		if (_tmp494_) {
			ValaSourceReference* _tmp510_;
			ValaSourceReference* _tmp511_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp510_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp511_ = _tmp510_;
			vala_report_error (_tmp511_, "Operands must be strings");
			result = FALSE;
			return result;
		}
		_tmp512_ = vala_code_context_get_analyzer (context);
		_tmp513_ = _tmp512_;
		_tmp514_ = _tmp513_->string_type;
		_tmp515_ = vala_data_type_copy (_tmp514_);
		_tmp516_ = _tmp515_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp516_);
		_vala_code_node_unref0 (_tmp516_);
		_tmp518_ = vala_binary_expression_get_left (self);
		_tmp519_ = _tmp518_;
		if (vala_expression_is_constant (_tmp519_)) {
			ValaExpression* _tmp520_;
			ValaExpression* _tmp521_;
			_tmp520_ = vala_binary_expression_get_right (self);
			_tmp521_ = _tmp520_;
			_tmp517_ = vala_expression_is_constant (_tmp521_);
		} else {
			_tmp517_ = FALSE;
		}
		if (_tmp517_) {
			ValaDataType* _tmp522_;
			ValaDataType* _tmp523_;
			_tmp522_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp523_ = _tmp522_;
			vala_data_type_set_value_owned (_tmp523_, FALSE);
		} else {
			ValaDataType* _tmp524_;
			ValaDataType* _tmp525_;
			_tmp524_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp525_ = _tmp524_;
			vala_data_type_set_value_owned (_tmp525_, TRUE);
		}
	} else {
		gboolean _tmp526_ = FALSE;
		ValaExpression* _tmp527_;
		ValaExpression* _tmp528_;
		ValaDataType* _tmp529_;
		ValaDataType* _tmp530_;
		_tmp527_ = vala_binary_expression_get_left (self);
		_tmp528_ = _tmp527_;
		_tmp529_ = vala_expression_get_value_type (_tmp528_);
		_tmp530_ = _tmp529_;
		if (VALA_IS_ARRAY_TYPE (_tmp530_)) {
			ValaBinaryOperator _tmp531_;
			_tmp531_ = self->priv->_operator;
			_tmp526_ = _tmp531_ == VALA_BINARY_OPERATOR_PLUS;
		} else {
			_tmp526_ = FALSE;
		}
		if (_tmp526_) {
			ValaArrayType* array_type = NULL;
			ValaExpression* _tmp532_;
			ValaExpression* _tmp533_;
			ValaDataType* _tmp534_;
			ValaDataType* _tmp535_;
			ValaArrayType* _tmp536_;
			ValaArrayType* _tmp537_;
			gboolean _tmp538_;
			gboolean _tmp539_;
			gboolean _tmp542_ = FALSE;
			ValaExpression* _tmp543_;
			ValaExpression* _tmp544_;
			ValaDataType* _tmp545_;
			ValaDataType* _tmp546_;
			ValaExpression* _tmp556_;
			ValaExpression* _tmp557_;
			ValaArrayType* _tmp558_;
			ValaDataType* _tmp559_;
			ValaDataType* _tmp560_;
			ValaDataType* _tmp561_;
			ValaDataType* _tmp562_;
			ValaArrayType* _tmp563_;
			ValaDataType* _tmp564_;
			ValaDataType* _tmp565_;
			ValaDataType* _tmp566_;
			ValaDataType* _tmp567_;
			_tmp532_ = vala_binary_expression_get_left (self);
			_tmp533_ = _tmp532_;
			_tmp534_ = vala_expression_get_value_type (_tmp533_);
			_tmp535_ = _tmp534_;
			_tmp536_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp535_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			array_type = _tmp536_;
			_tmp537_ = array_type;
			_tmp538_ = vala_array_type_get_inline_allocated (_tmp537_);
			_tmp539_ = _tmp538_;
			if (_tmp539_) {
				ValaSourceReference* _tmp540_;
				ValaSourceReference* _tmp541_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp540_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp541_ = _tmp540_;
				vala_report_error (_tmp541_, "Array concatenation not supported for fixed length arrays");
			}
			_tmp543_ = vala_binary_expression_get_right (self);
			_tmp544_ = _tmp543_;
			_tmp545_ = vala_expression_get_value_type (_tmp544_);
			_tmp546_ = _tmp545_;
			if (_tmp546_ == NULL) {
				_tmp542_ = TRUE;
			} else {
				ValaExpression* _tmp547_;
				ValaExpression* _tmp548_;
				ValaDataType* _tmp549_;
				ValaDataType* _tmp550_;
				ValaArrayType* _tmp551_;
				ValaDataType* _tmp552_;
				ValaDataType* _tmp553_;
				_tmp547_ = vala_binary_expression_get_right (self);
				_tmp548_ = _tmp547_;
				_tmp549_ = vala_expression_get_value_type (_tmp548_);
				_tmp550_ = _tmp549_;
				_tmp551_ = array_type;
				_tmp552_ = vala_array_type_get_element_type (_tmp551_);
				_tmp553_ = _tmp552_;
				_tmp542_ = !vala_data_type_compatible (_tmp550_, _tmp553_);
			}
			if (_tmp542_) {
				ValaSourceReference* _tmp554_;
				ValaSourceReference* _tmp555_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp554_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp555_ = _tmp554_;
				vala_report_error (_tmp555_, "Incompatible operand");
				result = FALSE;
				_vala_code_node_unref0 (array_type);
				return result;
			}
			_tmp556_ = vala_binary_expression_get_right (self);
			_tmp557_ = _tmp556_;
			_tmp558_ = array_type;
			_tmp559_ = vala_array_type_get_element_type (_tmp558_);
			_tmp560_ = _tmp559_;
			_tmp561_ = vala_data_type_copy (_tmp560_);
			_tmp562_ = _tmp561_;
			vala_expression_set_target_type (_tmp557_, _tmp562_);
			_vala_code_node_unref0 (_tmp562_);
			_tmp563_ = array_type;
			_tmp564_ = vala_data_type_copy ((ValaDataType*) _tmp563_);
			_tmp565_ = _tmp564_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp565_);
			_vala_code_node_unref0 (_tmp565_);
			_tmp566_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp567_ = _tmp566_;
			vala_data_type_set_value_owned (_tmp567_, TRUE);
			_vala_code_node_unref0 (array_type);
		} else {
			gboolean _tmp568_ = FALSE;
			gboolean _tmp569_ = FALSE;
			gboolean _tmp570_ = FALSE;
			ValaBinaryOperator _tmp571_;
			_tmp571_ = self->priv->_operator;
			if (_tmp571_ == VALA_BINARY_OPERATOR_PLUS) {
				_tmp570_ = TRUE;
			} else {
				ValaBinaryOperator _tmp572_;
				_tmp572_ = self->priv->_operator;
				_tmp570_ = _tmp572_ == VALA_BINARY_OPERATOR_MINUS;
			}
			if (_tmp570_) {
				_tmp569_ = TRUE;
			} else {
				ValaBinaryOperator _tmp573_;
				_tmp573_ = self->priv->_operator;
				_tmp569_ = _tmp573_ == VALA_BINARY_OPERATOR_MUL;
			}
			if (_tmp569_) {
				_tmp568_ = TRUE;
			} else {
				ValaBinaryOperator _tmp574_;
				_tmp574_ = self->priv->_operator;
				_tmp568_ = _tmp574_ == VALA_BINARY_OPERATOR_DIV;
			}
			if (_tmp568_) {
				ValaExpression* _tmp575_;
				ValaExpression* _tmp576_;
				ValaDataType* _tmp577_;
				ValaDataType* _tmp578_;
				ValaDataType* _tmp623_;
				ValaDataType* _tmp624_;
				ValaDataType* _tmp637_;
				ValaDataType* _tmp638_;
				_tmp575_ = vala_binary_expression_get_left (self);
				_tmp576_ = _tmp575_;
				_tmp577_ = vala_expression_get_value_type (_tmp576_);
				_tmp578_ = _tmp577_;
				if (VALA_IS_POINTER_TYPE (_tmp578_)) {
					ValaPointerType* pointer_type = NULL;
					ValaExpression* _tmp579_;
					ValaExpression* _tmp580_;
					ValaDataType* _tmp581_;
					ValaDataType* _tmp582_;
					ValaPointerType* _tmp583_;
					ValaPointerType* _tmp584_;
					ValaDataType* _tmp585_;
					ValaDataType* _tmp586_;
					ValaStruct* offset_type = NULL;
					ValaExpression* _tmp589_;
					ValaExpression* _tmp590_;
					ValaDataType* _tmp591_;
					ValaDataType* _tmp592_;
					ValaTypeSymbol* _tmp593_;
					ValaTypeSymbol* _tmp594_;
					ValaStruct* _tmp595_;
					gboolean _tmp596_ = FALSE;
					ValaStruct* _tmp597_;
					_tmp579_ = vala_binary_expression_get_left (self);
					_tmp580_ = _tmp579_;
					_tmp581_ = vala_expression_get_value_type (_tmp580_);
					_tmp582_ = _tmp581_;
					_tmp583_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp582_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
					pointer_type = _tmp583_;
					_tmp584_ = pointer_type;
					_tmp585_ = vala_pointer_type_get_base_type (_tmp584_);
					_tmp586_ = _tmp585_;
					if (VALA_IS_VOID_TYPE (_tmp586_)) {
						ValaSourceReference* _tmp587_;
						ValaSourceReference* _tmp588_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp587_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp588_ = _tmp587_;
						vala_report_error (_tmp588_, "Pointer arithmetic not supported for `void*'");
						result = FALSE;
						_vala_code_node_unref0 (pointer_type);
						return result;
					}
					_tmp589_ = vala_binary_expression_get_right (self);
					_tmp590_ = _tmp589_;
					_tmp591_ = vala_expression_get_value_type (_tmp590_);
					_tmp592_ = _tmp591_;
					_tmp593_ = vala_data_type_get_data_type (_tmp592_);
					_tmp594_ = _tmp593_;
					_tmp595_ = _vala_code_node_ref0 (VALA_IS_STRUCT (_tmp594_) ? ((ValaStruct*) _tmp594_) : NULL);
					offset_type = _tmp595_;
					_tmp597_ = offset_type;
					if (_tmp597_ != NULL) {
						ValaStruct* _tmp598_;
						_tmp598_ = offset_type;
						_tmp596_ = vala_struct_is_integer_type (_tmp598_);
					} else {
						_tmp596_ = FALSE;
					}
					if (_tmp596_) {
						gboolean _tmp599_ = FALSE;
						ValaBinaryOperator _tmp600_;
						_tmp600_ = self->priv->_operator;
						if (_tmp600_ == VALA_BINARY_OPERATOR_PLUS) {
							_tmp599_ = TRUE;
						} else {
							ValaBinaryOperator _tmp601_;
							_tmp601_ = self->priv->_operator;
							_tmp599_ = _tmp601_ == VALA_BINARY_OPERATOR_MINUS;
						}
						if (_tmp599_) {
							ValaExpression* _tmp602_;
							ValaExpression* _tmp603_;
							ValaDataType* _tmp604_;
							ValaDataType* _tmp605_;
							ValaDataType* _tmp606_;
							ValaDataType* _tmp607_;
							_tmp602_ = vala_binary_expression_get_left (self);
							_tmp603_ = _tmp602_;
							_tmp604_ = vala_expression_get_value_type (_tmp603_);
							_tmp605_ = _tmp604_;
							_tmp606_ = vala_data_type_copy (_tmp605_);
							_tmp607_ = _tmp606_;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp607_);
							_vala_code_node_unref0 (_tmp607_);
						}
					} else {
						ValaExpression* _tmp608_;
						ValaExpression* _tmp609_;
						ValaDataType* _tmp610_;
						ValaDataType* _tmp611_;
						_tmp608_ = vala_binary_expression_get_right (self);
						_tmp609_ = _tmp608_;
						_tmp610_ = vala_expression_get_value_type (_tmp609_);
						_tmp611_ = _tmp610_;
						if (VALA_IS_POINTER_TYPE (_tmp611_)) {
							ValaSemanticAnalyzer* _tmp612_;
							ValaSemanticAnalyzer* _tmp613_;
							ValaDataType* _tmp614_;
							_tmp612_ = vala_code_context_get_analyzer (context);
							_tmp613_ = _tmp612_;
							_tmp614_ = _tmp613_->size_t_type;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp614_);
						}
					}
					_vala_code_node_unref0 (offset_type);
					_vala_code_node_unref0 (pointer_type);
				} else {
					ValaExpression* _tmp615_;
					ValaExpression* _tmp616_;
					ValaDataType* _tmp617_;
					ValaDataType* _tmp618_;
					ValaExpression* _tmp619_;
					ValaExpression* _tmp620_;
					ValaDataType* _tmp621_;
					ValaDataType* _tmp622_;
					_tmp615_ = vala_binary_expression_get_left (self);
					_tmp616_ = _tmp615_;
					_tmp617_ = vala_expression_get_target_type (_tmp616_);
					_tmp618_ = _tmp617_;
					vala_data_type_set_nullable (_tmp618_, FALSE);
					_tmp619_ = vala_binary_expression_get_right (self);
					_tmp620_ = _tmp619_;
					_tmp621_ = vala_expression_get_target_type (_tmp620_);
					_tmp622_ = _tmp621_;
					vala_data_type_set_nullable (_tmp622_, FALSE);
				}
				_tmp623_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp624_ = _tmp623_;
				if (_tmp624_ == NULL) {
					ValaSemanticAnalyzer* _tmp625_;
					ValaSemanticAnalyzer* _tmp626_;
					ValaExpression* _tmp627_;
					ValaExpression* _tmp628_;
					ValaDataType* _tmp629_;
					ValaDataType* _tmp630_;
					ValaExpression* _tmp631_;
					ValaExpression* _tmp632_;
					ValaDataType* _tmp633_;
					ValaDataType* _tmp634_;
					ValaDataType* _tmp635_;
					ValaDataType* _tmp636_;
					_tmp625_ = vala_code_context_get_analyzer (context);
					_tmp626_ = _tmp625_;
					_tmp627_ = vala_binary_expression_get_left (self);
					_tmp628_ = _tmp627_;
					_tmp629_ = vala_expression_get_target_type (_tmp628_);
					_tmp630_ = _tmp629_;
					_tmp631_ = vala_binary_expression_get_right (self);
					_tmp632_ = _tmp631_;
					_tmp633_ = vala_expression_get_target_type (_tmp632_);
					_tmp634_ = _tmp633_;
					_tmp635_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp626_, _tmp630_, _tmp634_);
					_tmp636_ = _tmp635_;
					vala_expression_set_value_type ((ValaExpression*) self, _tmp636_);
					_vala_code_node_unref0 (_tmp636_);
				}
				_tmp637_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp638_ = _tmp637_;
				if (_tmp638_ == NULL) {
					ValaSourceReference* _tmp639_;
					ValaSourceReference* _tmp640_;
					ValaExpression* _tmp641_;
					ValaExpression* _tmp642_;
					ValaDataType* _tmp643_;
					ValaDataType* _tmp644_;
					gchar* _tmp645_;
					gchar* _tmp646_;
					ValaExpression* _tmp647_;
					ValaExpression* _tmp648_;
					ValaDataType* _tmp649_;
					ValaDataType* _tmp650_;
					gchar* _tmp651_;
					gchar* _tmp652_;
					gchar* _tmp653_;
					gchar* _tmp654_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp639_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp640_ = _tmp639_;
					_tmp641_ = vala_binary_expression_get_left (self);
					_tmp642_ = _tmp641_;
					_tmp643_ = vala_expression_get_value_type (_tmp642_);
					_tmp644_ = _tmp643_;
					_tmp645_ = vala_code_node_to_string ((ValaCodeNode*) _tmp644_);
					_tmp646_ = _tmp645_;
					_tmp647_ = vala_binary_expression_get_right (self);
					_tmp648_ = _tmp647_;
					_tmp649_ = vala_expression_get_value_type (_tmp648_);
					_tmp650_ = _tmp649_;
					_tmp651_ = vala_code_node_to_string ((ValaCodeNode*) _tmp650_);
					_tmp652_ = _tmp651_;
					_tmp653_ = g_strdup_printf ("Arithmetic operation not supported for types `%s' and `%s'", _tmp646_, _tmp652_);
					_tmp654_ = _tmp653_;
					vala_report_error (_tmp640_, _tmp654_);
					_g_free0 (_tmp654_);
					_g_free0 (_tmp652_);
					_g_free0 (_tmp646_);
					result = FALSE;
					return result;
				}
			} else {
				gboolean _tmp655_ = FALSE;
				gboolean _tmp656_ = FALSE;
				ValaBinaryOperator _tmp657_;
				_tmp657_ = self->priv->_operator;
				if (_tmp657_ == VALA_BINARY_OPERATOR_MOD) {
					_tmp656_ = TRUE;
				} else {
					ValaBinaryOperator _tmp658_;
					_tmp658_ = self->priv->_operator;
					_tmp656_ = _tmp658_ == VALA_BINARY_OPERATOR_SHIFT_LEFT;
				}
				if (_tmp656_) {
					_tmp655_ = TRUE;
				} else {
					ValaBinaryOperator _tmp659_;
					_tmp659_ = self->priv->_operator;
					_tmp655_ = _tmp659_ == VALA_BINARY_OPERATOR_SHIFT_RIGHT;
				}
				if (_tmp655_) {
					ValaExpression* _tmp660_;
					ValaExpression* _tmp661_;
					ValaDataType* _tmp662_;
					ValaDataType* _tmp663_;
					ValaExpression* _tmp664_;
					ValaExpression* _tmp665_;
					ValaDataType* _tmp666_;
					ValaDataType* _tmp667_;
					ValaSemanticAnalyzer* _tmp668_;
					ValaSemanticAnalyzer* _tmp669_;
					ValaExpression* _tmp670_;
					ValaExpression* _tmp671_;
					ValaDataType* _tmp672_;
					ValaDataType* _tmp673_;
					ValaExpression* _tmp674_;
					ValaExpression* _tmp675_;
					ValaDataType* _tmp676_;
					ValaDataType* _tmp677_;
					ValaDataType* _tmp678_;
					ValaDataType* _tmp679_;
					ValaDataType* _tmp680_;
					ValaDataType* _tmp681_;
					_tmp660_ = vala_binary_expression_get_left (self);
					_tmp661_ = _tmp660_;
					_tmp662_ = vala_expression_get_target_type (_tmp661_);
					_tmp663_ = _tmp662_;
					vala_data_type_set_nullable (_tmp663_, FALSE);
					_tmp664_ = vala_binary_expression_get_right (self);
					_tmp665_ = _tmp664_;
					_tmp666_ = vala_expression_get_target_type (_tmp665_);
					_tmp667_ = _tmp666_;
					vala_data_type_set_nullable (_tmp667_, FALSE);
					_tmp668_ = vala_code_context_get_analyzer (context);
					_tmp669_ = _tmp668_;
					_tmp670_ = vala_binary_expression_get_left (self);
					_tmp671_ = _tmp670_;
					_tmp672_ = vala_expression_get_target_type (_tmp671_);
					_tmp673_ = _tmp672_;
					_tmp674_ = vala_binary_expression_get_right (self);
					_tmp675_ = _tmp674_;
					_tmp676_ = vala_expression_get_target_type (_tmp675_);
					_tmp677_ = _tmp676_;
					_tmp678_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp669_, _tmp673_, _tmp677_);
					_tmp679_ = _tmp678_;
					vala_expression_set_value_type ((ValaExpression*) self, _tmp679_);
					_vala_code_node_unref0 (_tmp679_);
					_tmp680_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp681_ = _tmp680_;
					if (_tmp681_ == NULL) {
						ValaSourceReference* _tmp682_;
						ValaSourceReference* _tmp683_;
						ValaExpression* _tmp684_;
						ValaExpression* _tmp685_;
						ValaDataType* _tmp686_;
						ValaDataType* _tmp687_;
						gchar* _tmp688_;
						gchar* _tmp689_;
						ValaExpression* _tmp690_;
						ValaExpression* _tmp691_;
						ValaDataType* _tmp692_;
						ValaDataType* _tmp693_;
						gchar* _tmp694_;
						gchar* _tmp695_;
						gchar* _tmp696_;
						gchar* _tmp697_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp682_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp683_ = _tmp682_;
						_tmp684_ = vala_binary_expression_get_left (self);
						_tmp685_ = _tmp684_;
						_tmp686_ = vala_expression_get_value_type (_tmp685_);
						_tmp687_ = _tmp686_;
						_tmp688_ = vala_code_node_to_string ((ValaCodeNode*) _tmp687_);
						_tmp689_ = _tmp688_;
						_tmp690_ = vala_binary_expression_get_right (self);
						_tmp691_ = _tmp690_;
						_tmp692_ = vala_expression_get_value_type (_tmp691_);
						_tmp693_ = _tmp692_;
						_tmp694_ = vala_code_node_to_string ((ValaCodeNode*) _tmp693_);
						_tmp695_ = _tmp694_;
						_tmp696_ = g_strdup_printf ("Arithmetic operation not supported for types `%s' and `%s'", _tmp689_, _tmp695_);
						_tmp697_ = _tmp696_;
						vala_report_error (_tmp683_, _tmp697_);
						_g_free0 (_tmp697_);
						_g_free0 (_tmp695_);
						_g_free0 (_tmp689_);
						result = FALSE;
						return result;
					}
				} else {
					gboolean _tmp698_ = FALSE;
					gboolean _tmp699_ = FALSE;
					gboolean _tmp700_ = FALSE;
					ValaBinaryOperator _tmp701_;
					_tmp701_ = self->priv->_operator;
					if (_tmp701_ == VALA_BINARY_OPERATOR_LESS_THAN) {
						_tmp700_ = TRUE;
					} else {
						ValaBinaryOperator _tmp702_;
						_tmp702_ = self->priv->_operator;
						_tmp700_ = _tmp702_ == VALA_BINARY_OPERATOR_GREATER_THAN;
					}
					if (_tmp700_) {
						_tmp699_ = TRUE;
					} else {
						ValaBinaryOperator _tmp703_;
						_tmp703_ = self->priv->_operator;
						_tmp699_ = _tmp703_ == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
					}
					if (_tmp699_) {
						_tmp698_ = TRUE;
					} else {
						ValaBinaryOperator _tmp704_;
						_tmp704_ = self->priv->_operator;
						_tmp698_ = _tmp704_ == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
					}
					if (_tmp698_) {
						gboolean _tmp705_ = FALSE;
						ValaExpression* _tmp706_;
						ValaExpression* _tmp707_;
						ValaDataType* _tmp708_;
						ValaDataType* _tmp709_;
						ValaSemanticAnalyzer* _tmp710_;
						ValaSemanticAnalyzer* _tmp711_;
						ValaDataType* _tmp712_;
						ValaSemanticAnalyzer* _tmp792_;
						ValaSemanticAnalyzer* _tmp793_;
						ValaDataType* _tmp794_;
						_tmp706_ = vala_binary_expression_get_left (self);
						_tmp707_ = _tmp706_;
						_tmp708_ = vala_expression_get_value_type (_tmp707_);
						_tmp709_ = _tmp708_;
						_tmp710_ = vala_code_context_get_analyzer (context);
						_tmp711_ = _tmp710_;
						_tmp712_ = _tmp711_->string_type;
						if (vala_data_type_compatible (_tmp709_, _tmp712_)) {
							ValaExpression* _tmp713_;
							ValaExpression* _tmp714_;
							ValaDataType* _tmp715_;
							ValaDataType* _tmp716_;
							ValaSemanticAnalyzer* _tmp717_;
							ValaSemanticAnalyzer* _tmp718_;
							ValaDataType* _tmp719_;
							_tmp713_ = vala_binary_expression_get_right (self);
							_tmp714_ = _tmp713_;
							_tmp715_ = vala_expression_get_value_type (_tmp714_);
							_tmp716_ = _tmp715_;
							_tmp717_ = vala_code_context_get_analyzer (context);
							_tmp718_ = _tmp717_;
							_tmp719_ = _tmp718_->string_type;
							_tmp705_ = vala_data_type_compatible (_tmp716_, _tmp719_);
						} else {
							_tmp705_ = FALSE;
						}
						if (_tmp705_) {
						} else {
							gboolean _tmp720_ = FALSE;
							ValaExpression* _tmp721_;
							ValaExpression* _tmp722_;
							ValaDataType* _tmp723_;
							ValaDataType* _tmp724_;
							_tmp721_ = vala_binary_expression_get_left (self);
							_tmp722_ = _tmp721_;
							_tmp723_ = vala_expression_get_value_type (_tmp722_);
							_tmp724_ = _tmp723_;
							if (VALA_IS_POINTER_TYPE (_tmp724_)) {
								ValaExpression* _tmp725_;
								ValaExpression* _tmp726_;
								ValaDataType* _tmp727_;
								ValaDataType* _tmp728_;
								_tmp725_ = vala_binary_expression_get_right (self);
								_tmp726_ = _tmp725_;
								_tmp727_ = vala_expression_get_value_type (_tmp726_);
								_tmp728_ = _tmp727_;
								_tmp720_ = VALA_IS_POINTER_TYPE (_tmp728_);
							} else {
								_tmp720_ = FALSE;
							}
							if (_tmp720_) {
							} else {
								ValaDataType* resulting_type = NULL;
								gboolean _tmp729_;
								ValaDataType* _tmp756_;
								gboolean _tmp773_;
								ValaExpression* _tmp779_;
								ValaExpression* _tmp780_;
								ValaDataType* _tmp781_;
								ValaDataType* _tmp782_;
								ValaDataType* _tmp783_;
								ValaExpression* _tmp784_;
								ValaExpression* _tmp785_;
								ValaDataType* _tmp786_;
								ValaDataType* _tmp787_;
								ValaExpression* _tmp788_;
								ValaExpression* _tmp789_;
								ValaDataType* _tmp790_;
								ValaDataType* _tmp791_;
								_tmp729_ = self->priv->_is_chained;
								if (_tmp729_) {
									ValaBinaryExpression* lbe = NULL;
									ValaExpression* _tmp730_;
									ValaExpression* _tmp731_;
									ValaBinaryExpression* _tmp732_;
									ValaSemanticAnalyzer* _tmp733_;
									ValaSemanticAnalyzer* _tmp734_;
									ValaBinaryExpression* _tmp735_;
									ValaExpression* _tmp736_;
									ValaExpression* _tmp737_;
									ValaDataType* _tmp738_;
									ValaDataType* _tmp739_;
									ValaExpression* _tmp740_;
									ValaExpression* _tmp741_;
									ValaDataType* _tmp742_;
									ValaDataType* _tmp743_;
									ValaDataType* _tmp744_;
									_tmp730_ = vala_binary_expression_get_left (self);
									_tmp731_ = _tmp730_;
									_tmp732_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp731_, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression));
									lbe = _tmp732_;
									_tmp733_ = vala_code_context_get_analyzer (context);
									_tmp734_ = _tmp733_;
									_tmp735_ = lbe;
									_tmp736_ = vala_binary_expression_get_right (_tmp735_);
									_tmp737_ = _tmp736_;
									_tmp738_ = vala_expression_get_target_type (_tmp737_);
									_tmp739_ = _tmp738_;
									_tmp740_ = vala_binary_expression_get_right (self);
									_tmp741_ = _tmp740_;
									_tmp742_ = vala_expression_get_target_type (_tmp741_);
									_tmp743_ = _tmp742_;
									_tmp744_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp734_, _tmp739_, _tmp743_);
									_vala_code_node_unref0 (resulting_type);
									resulting_type = _tmp744_;
									_vala_code_node_unref0 (lbe);
								} else {
									ValaSemanticAnalyzer* _tmp745_;
									ValaSemanticAnalyzer* _tmp746_;
									ValaExpression* _tmp747_;
									ValaExpression* _tmp748_;
									ValaDataType* _tmp749_;
									ValaDataType* _tmp750_;
									ValaExpression* _tmp751_;
									ValaExpression* _tmp752_;
									ValaDataType* _tmp753_;
									ValaDataType* _tmp754_;
									ValaDataType* _tmp755_;
									_tmp745_ = vala_code_context_get_analyzer (context);
									_tmp746_ = _tmp745_;
									_tmp747_ = vala_binary_expression_get_left (self);
									_tmp748_ = _tmp747_;
									_tmp749_ = vala_expression_get_target_type (_tmp748_);
									_tmp750_ = _tmp749_;
									_tmp751_ = vala_binary_expression_get_right (self);
									_tmp752_ = _tmp751_;
									_tmp753_ = vala_expression_get_target_type (_tmp752_);
									_tmp754_ = _tmp753_;
									_tmp755_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp746_, _tmp750_, _tmp754_);
									_vala_code_node_unref0 (resulting_type);
									resulting_type = _tmp755_;
								}
								_tmp756_ = resulting_type;
								if (_tmp756_ == NULL) {
									ValaSourceReference* _tmp757_;
									ValaSourceReference* _tmp758_;
									ValaExpression* _tmp759_;
									ValaExpression* _tmp760_;
									ValaDataType* _tmp761_;
									ValaDataType* _tmp762_;
									gchar* _tmp763_;
									gchar* _tmp764_;
									ValaExpression* _tmp765_;
									ValaExpression* _tmp766_;
									ValaDataType* _tmp767_;
									ValaDataType* _tmp768_;
									gchar* _tmp769_;
									gchar* _tmp770_;
									gchar* _tmp771_;
									gchar* _tmp772_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp757_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp758_ = _tmp757_;
									_tmp759_ = vala_binary_expression_get_left (self);
									_tmp760_ = _tmp759_;
									_tmp761_ = vala_expression_get_value_type (_tmp760_);
									_tmp762_ = _tmp761_;
									_tmp763_ = vala_code_node_to_string ((ValaCodeNode*) _tmp762_);
									_tmp764_ = _tmp763_;
									_tmp765_ = vala_binary_expression_get_right (self);
									_tmp766_ = _tmp765_;
									_tmp767_ = vala_expression_get_value_type (_tmp766_);
									_tmp768_ = _tmp767_;
									_tmp769_ = vala_code_node_to_string ((ValaCodeNode*) _tmp768_);
									_tmp770_ = _tmp769_;
									_tmp771_ = g_strdup_printf ("Relational operation not supported for types `%s' and `%s'", _tmp764_, _tmp770_);
									_tmp772_ = _tmp771_;
									vala_report_error (_tmp758_, _tmp772_);
									_g_free0 (_tmp772_);
									_g_free0 (_tmp770_);
									_g_free0 (_tmp764_);
									result = FALSE;
									_vala_code_node_unref0 (resulting_type);
									return result;
								}
								_tmp773_ = self->priv->_is_chained;
								if (!_tmp773_) {
									ValaExpression* _tmp774_;
									ValaExpression* _tmp775_;
									ValaDataType* _tmp776_;
									ValaDataType* _tmp777_;
									ValaDataType* _tmp778_;
									_tmp774_ = vala_binary_expression_get_left (self);
									_tmp775_ = _tmp774_;
									_tmp776_ = resulting_type;
									_tmp777_ = vala_data_type_copy (_tmp776_);
									_tmp778_ = _tmp777_;
									vala_expression_set_target_type (_tmp775_, _tmp778_);
									_vala_code_node_unref0 (_tmp778_);
								}
								_tmp779_ = vala_binary_expression_get_right (self);
								_tmp780_ = _tmp779_;
								_tmp781_ = resulting_type;
								_tmp782_ = vala_data_type_copy (_tmp781_);
								_tmp783_ = _tmp782_;
								vala_expression_set_target_type (_tmp780_, _tmp783_);
								_vala_code_node_unref0 (_tmp783_);
								_tmp784_ = vala_binary_expression_get_left (self);
								_tmp785_ = _tmp784_;
								_tmp786_ = vala_expression_get_target_type (_tmp785_);
								_tmp787_ = _tmp786_;
								vala_data_type_set_nullable (_tmp787_, FALSE);
								_tmp788_ = vala_binary_expression_get_right (self);
								_tmp789_ = _tmp788_;
								_tmp790_ = vala_expression_get_target_type (_tmp789_);
								_tmp791_ = _tmp790_;
								vala_data_type_set_nullable (_tmp791_, FALSE);
								_vala_code_node_unref0 (resulting_type);
							}
						}
						_tmp792_ = vala_code_context_get_analyzer (context);
						_tmp793_ = _tmp792_;
						_tmp794_ = _tmp793_->bool_type;
						vala_expression_set_value_type ((ValaExpression*) self, _tmp794_);
					} else {
						gboolean _tmp795_ = FALSE;
						ValaBinaryOperator _tmp796_;
						_tmp796_ = self->priv->_operator;
						if (_tmp796_ == VALA_BINARY_OPERATOR_EQUALITY) {
							_tmp795_ = TRUE;
						} else {
							ValaBinaryOperator _tmp797_;
							_tmp797_ = self->priv->_operator;
							_tmp795_ = _tmp797_ == VALA_BINARY_OPERATOR_INEQUALITY;
						}
						if (_tmp795_) {
							ValaTypeSymbol* gvalue_type = NULL;
							ValaSemanticAnalyzer* _tmp798_;
							ValaSemanticAnalyzer* _tmp799_;
							ValaStructValueType* _tmp800_;
							ValaTypeSymbol* _tmp801_;
							ValaTypeSymbol* _tmp802_;
							ValaTypeSymbol* _tmp803_;
							gboolean _tmp804_ = FALSE;
							gboolean _tmp805_ = FALSE;
							ValaExpression* _tmp806_;
							ValaExpression* _tmp807_;
							ValaDataType* _tmp808_;
							ValaDataType* _tmp809_;
							ValaTypeSymbol* _tmp810_;
							ValaTypeSymbol* _tmp811_;
							ValaTypeSymbol* _tmp812_;
							gboolean _tmp866_ = FALSE;
							ValaExpression* _tmp867_;
							ValaExpression* _tmp868_;
							ValaDataType* _tmp869_;
							ValaDataType* _tmp870_;
							ValaExpression* _tmp871_;
							ValaExpression* _tmp872_;
							ValaDataType* _tmp873_;
							ValaDataType* _tmp874_;
							ValaDataType* resulting_type = NULL;
							ValaSemanticAnalyzer* _tmp899_;
							ValaSemanticAnalyzer* _tmp900_;
							ValaExpression* _tmp901_;
							ValaExpression* _tmp902_;
							ValaDataType* _tmp903_;
							ValaDataType* _tmp904_;
							ValaExpression* _tmp905_;
							ValaExpression* _tmp906_;
							ValaDataType* _tmp907_;
							ValaDataType* _tmp908_;
							ValaDataType* _tmp909_;
							ValaDataType* _tmp910_;
							ValaExpression* _tmp921_;
							ValaExpression* _tmp922_;
							ValaDataType* _tmp923_;
							ValaDataType* _tmp924_;
							ValaExpression* _tmp925_;
							ValaExpression* _tmp926_;
							ValaDataType* _tmp927_;
							ValaDataType* _tmp928_;
							ValaExpression* _tmp929_;
							ValaExpression* _tmp930_;
							ValaDataType* _tmp931_;
							ValaDataType* _tmp932_;
							gboolean _tmp933_;
							gboolean _tmp934_;
							ValaExpression* _tmp935_;
							ValaExpression* _tmp936_;
							ValaDataType* _tmp937_;
							ValaDataType* _tmp938_;
							gboolean _tmp939_;
							gboolean _tmp940_;
							ValaSemanticAnalyzer* _tmp949_;
							ValaSemanticAnalyzer* _tmp950_;
							ValaDataType* _tmp951_;
							_tmp798_ = vala_code_context_get_analyzer (context);
							_tmp799_ = _tmp798_;
							_tmp800_ = _tmp799_->gvalue_type;
							_tmp801_ = vala_data_type_get_data_type ((ValaDataType*) _tmp800_);
							_tmp802_ = _tmp801_;
							_tmp803_ = _vala_code_node_ref0 (_tmp802_);
							gvalue_type = _tmp803_;
							_tmp806_ = vala_binary_expression_get_left (self);
							_tmp807_ = _tmp806_;
							_tmp808_ = vala_expression_get_target_type (_tmp807_);
							_tmp809_ = _tmp808_;
							_tmp810_ = vala_data_type_get_data_type (_tmp809_);
							_tmp811_ = _tmp810_;
							_tmp812_ = gvalue_type;
							if (_tmp811_ == _tmp812_) {
								ValaExpression* _tmp813_;
								ValaExpression* _tmp814_;
								ValaDataType* _tmp815_;
								ValaDataType* _tmp816_;
								ValaTypeSymbol* _tmp817_;
								ValaTypeSymbol* _tmp818_;
								ValaTypeSymbol* _tmp819_;
								_tmp813_ = vala_binary_expression_get_right (self);
								_tmp814_ = _tmp813_;
								_tmp815_ = vala_expression_get_target_type (_tmp814_);
								_tmp816_ = _tmp815_;
								_tmp817_ = vala_data_type_get_data_type (_tmp816_);
								_tmp818_ = _tmp817_;
								_tmp819_ = gvalue_type;
								_tmp805_ = _tmp818_ != _tmp819_;
							} else {
								_tmp805_ = FALSE;
							}
							if (_tmp805_) {
								_tmp804_ = TRUE;
							} else {
								gboolean _tmp820_ = FALSE;
								ValaExpression* _tmp821_;
								ValaExpression* _tmp822_;
								ValaDataType* _tmp823_;
								ValaDataType* _tmp824_;
								ValaTypeSymbol* _tmp825_;
								ValaTypeSymbol* _tmp826_;
								ValaTypeSymbol* _tmp827_;
								_tmp821_ = vala_binary_expression_get_left (self);
								_tmp822_ = _tmp821_;
								_tmp823_ = vala_expression_get_target_type (_tmp822_);
								_tmp824_ = _tmp823_;
								_tmp825_ = vala_data_type_get_data_type (_tmp824_);
								_tmp826_ = _tmp825_;
								_tmp827_ = gvalue_type;
								if (_tmp826_ != _tmp827_) {
									ValaExpression* _tmp828_;
									ValaExpression* _tmp829_;
									ValaDataType* _tmp830_;
									ValaDataType* _tmp831_;
									ValaTypeSymbol* _tmp832_;
									ValaTypeSymbol* _tmp833_;
									ValaTypeSymbol* _tmp834_;
									_tmp828_ = vala_binary_expression_get_right (self);
									_tmp829_ = _tmp828_;
									_tmp830_ = vala_expression_get_target_type (_tmp829_);
									_tmp831_ = _tmp830_;
									_tmp832_ = vala_data_type_get_data_type (_tmp831_);
									_tmp833_ = _tmp832_;
									_tmp834_ = gvalue_type;
									_tmp820_ = _tmp833_ == _tmp834_;
								} else {
									_tmp820_ = FALSE;
								}
								_tmp804_ = _tmp820_;
							}
							if (_tmp804_) {
								ValaExpression* gvalue_expr = NULL;
								ValaDataType* target_type = NULL;
								ValaExpression* _tmp835_;
								ValaExpression* _tmp836_;
								ValaDataType* _tmp837_;
								ValaDataType* _tmp838_;
								ValaTypeSymbol* _tmp839_;
								ValaTypeSymbol* _tmp840_;
								ValaTypeSymbol* _tmp841_;
								ValaCastExpression* cast_expr = NULL;
								ValaExpression* _tmp858_;
								ValaDataType* _tmp859_;
								ValaExpression* _tmp860_;
								ValaSourceReference* _tmp861_;
								ValaSourceReference* _tmp862_;
								ValaCastExpression* _tmp863_;
								ValaExpression* _tmp864_;
								ValaCastExpression* _tmp865_;
								_tmp835_ = vala_binary_expression_get_left (self);
								_tmp836_ = _tmp835_;
								_tmp837_ = vala_expression_get_target_type (_tmp836_);
								_tmp838_ = _tmp837_;
								_tmp839_ = vala_data_type_get_data_type (_tmp838_);
								_tmp840_ = _tmp839_;
								_tmp841_ = gvalue_type;
								if (_tmp840_ == _tmp841_) {
									ValaExpression* _tmp842_;
									ValaExpression* _tmp843_;
									ValaExpression* _tmp844_;
									ValaExpression* _tmp845_;
									ValaExpression* _tmp846_;
									ValaDataType* _tmp847_;
									ValaDataType* _tmp848_;
									ValaDataType* _tmp849_;
									_tmp842_ = vala_binary_expression_get_left (self);
									_tmp843_ = _tmp842_;
									_tmp844_ = _vala_code_node_ref0 (_tmp843_);
									_vala_code_node_unref0 (gvalue_expr);
									gvalue_expr = _tmp844_;
									_tmp845_ = vala_binary_expression_get_right (self);
									_tmp846_ = _tmp845_;
									_tmp847_ = vala_expression_get_target_type (_tmp846_);
									_tmp848_ = _tmp847_;
									_tmp849_ = _vala_code_node_ref0 (_tmp848_);
									_vala_code_node_unref0 (target_type);
									target_type = _tmp849_;
								} else {
									ValaExpression* _tmp850_;
									ValaExpression* _tmp851_;
									ValaExpression* _tmp852_;
									ValaExpression* _tmp853_;
									ValaExpression* _tmp854_;
									ValaDataType* _tmp855_;
									ValaDataType* _tmp856_;
									ValaDataType* _tmp857_;
									_tmp850_ = vala_binary_expression_get_right (self);
									_tmp851_ = _tmp850_;
									_tmp852_ = _vala_code_node_ref0 (_tmp851_);
									_vala_code_node_unref0 (gvalue_expr);
									gvalue_expr = _tmp852_;
									_tmp853_ = vala_binary_expression_get_left (self);
									_tmp854_ = _tmp853_;
									_tmp855_ = vala_expression_get_target_type (_tmp854_);
									_tmp856_ = _tmp855_;
									_tmp857_ = _vala_code_node_ref0 (_tmp856_);
									_vala_code_node_unref0 (target_type);
									target_type = _tmp857_;
								}
								_tmp858_ = gvalue_expr;
								_tmp859_ = target_type;
								_tmp860_ = gvalue_expr;
								_tmp861_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp860_);
								_tmp862_ = _tmp861_;
								_tmp863_ = vala_cast_expression_new (_tmp858_, _tmp859_, _tmp862_);
								cast_expr = _tmp863_;
								_tmp864_ = gvalue_expr;
								_tmp865_ = cast_expr;
								vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp864_, (ValaExpression*) _tmp865_);
								vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
								result = vala_code_node_check ((ValaCodeNode*) self, context);
								_vala_code_node_unref0 (cast_expr);
								_vala_code_node_unref0 (target_type);
								_vala_code_node_unref0 (gvalue_expr);
								_vala_code_node_unref0 (gvalue_type);
								return result;
							}
							_tmp867_ = vala_binary_expression_get_right (self);
							_tmp868_ = _tmp867_;
							_tmp869_ = vala_expression_get_value_type (_tmp868_);
							_tmp870_ = _tmp869_;
							_tmp871_ = vala_binary_expression_get_left (self);
							_tmp872_ = _tmp871_;
							_tmp873_ = vala_expression_get_value_type (_tmp872_);
							_tmp874_ = _tmp873_;
							if (!vala_data_type_compatible (_tmp870_, _tmp874_)) {
								ValaExpression* _tmp875_;
								ValaExpression* _tmp876_;
								ValaDataType* _tmp877_;
								ValaDataType* _tmp878_;
								ValaExpression* _tmp879_;
								ValaExpression* _tmp880_;
								ValaDataType* _tmp881_;
								ValaDataType* _tmp882_;
								_tmp875_ = vala_binary_expression_get_left (self);
								_tmp876_ = _tmp875_;
								_tmp877_ = vala_expression_get_value_type (_tmp876_);
								_tmp878_ = _tmp877_;
								_tmp879_ = vala_binary_expression_get_right (self);
								_tmp880_ = _tmp879_;
								_tmp881_ = vala_expression_get_value_type (_tmp880_);
								_tmp882_ = _tmp881_;
								_tmp866_ = !vala_data_type_compatible (_tmp878_, _tmp882_);
							} else {
								_tmp866_ = FALSE;
							}
							if (_tmp866_) {
								ValaSourceReference* _tmp883_;
								ValaSourceReference* _tmp884_;
								ValaExpression* _tmp885_;
								ValaExpression* _tmp886_;
								ValaDataType* _tmp887_;
								ValaDataType* _tmp888_;
								gchar* _tmp889_;
								gchar* _tmp890_;
								ValaExpression* _tmp891_;
								ValaExpression* _tmp892_;
								ValaDataType* _tmp893_;
								ValaDataType* _tmp894_;
								gchar* _tmp895_;
								gchar* _tmp896_;
								gchar* _tmp897_;
								gchar* _tmp898_;
								_tmp883_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp884_ = _tmp883_;
								_tmp885_ = vala_binary_expression_get_right (self);
								_tmp886_ = _tmp885_;
								_tmp887_ = vala_expression_get_value_type (_tmp886_);
								_tmp888_ = _tmp887_;
								_tmp889_ = vala_code_node_to_string ((ValaCodeNode*) _tmp888_);
								_tmp890_ = _tmp889_;
								_tmp891_ = vala_binary_expression_get_left (self);
								_tmp892_ = _tmp891_;
								_tmp893_ = vala_expression_get_value_type (_tmp892_);
								_tmp894_ = _tmp893_;
								_tmp895_ = vala_code_node_to_string ((ValaCodeNode*) _tmp894_);
								_tmp896_ = _tmp895_;
								_tmp897_ = g_strdup_printf ("Equality operation: `%s' and `%s' are incompatible", _tmp890_, _tmp896_);
								_tmp898_ = _tmp897_;
								vala_report_error (_tmp884_, _tmp898_);
								_g_free0 (_tmp898_);
								_g_free0 (_tmp896_);
								_g_free0 (_tmp890_);
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_code_node_unref0 (gvalue_type);
								return result;
							}
							_tmp899_ = vala_code_context_get_analyzer (context);
							_tmp900_ = _tmp899_;
							_tmp901_ = vala_binary_expression_get_left (self);
							_tmp902_ = _tmp901_;
							_tmp903_ = vala_expression_get_target_type (_tmp902_);
							_tmp904_ = _tmp903_;
							_tmp905_ = vala_binary_expression_get_right (self);
							_tmp906_ = _tmp905_;
							_tmp907_ = vala_expression_get_target_type (_tmp906_);
							_tmp908_ = _tmp907_;
							_tmp909_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp900_, _tmp904_, _tmp908_);
							resulting_type = _tmp909_;
							_tmp910_ = resulting_type;
							if (_tmp910_ != NULL) {
								ValaExpression* _tmp911_;
								ValaExpression* _tmp912_;
								ValaDataType* _tmp913_;
								ValaDataType* _tmp914_;
								ValaDataType* _tmp915_;
								ValaExpression* _tmp916_;
								ValaExpression* _tmp917_;
								ValaDataType* _tmp918_;
								ValaDataType* _tmp919_;
								ValaDataType* _tmp920_;
								_tmp911_ = vala_binary_expression_get_left (self);
								_tmp912_ = _tmp911_;
								_tmp913_ = resulting_type;
								_tmp914_ = vala_data_type_copy (_tmp913_);
								_tmp915_ = _tmp914_;
								vala_expression_set_target_type (_tmp912_, _tmp915_);
								_vala_code_node_unref0 (_tmp915_);
								_tmp916_ = vala_binary_expression_get_right (self);
								_tmp917_ = _tmp916_;
								_tmp918_ = resulting_type;
								_tmp919_ = vala_data_type_copy (_tmp918_);
								_tmp920_ = _tmp919_;
								vala_expression_set_target_type (_tmp917_, _tmp920_);
								_vala_code_node_unref0 (_tmp920_);
							}
							_tmp921_ = vala_binary_expression_get_left (self);
							_tmp922_ = _tmp921_;
							_tmp923_ = vala_expression_get_target_type (_tmp922_);
							_tmp924_ = _tmp923_;
							vala_data_type_set_value_owned (_tmp924_, FALSE);
							_tmp925_ = vala_binary_expression_get_right (self);
							_tmp926_ = _tmp925_;
							_tmp927_ = vala_expression_get_target_type (_tmp926_);
							_tmp928_ = _tmp927_;
							vala_data_type_set_value_owned (_tmp928_, FALSE);
							_tmp929_ = vala_binary_expression_get_left (self);
							_tmp930_ = _tmp929_;
							_tmp931_ = vala_expression_get_value_type (_tmp930_);
							_tmp932_ = _tmp931_;
							_tmp933_ = vala_data_type_get_nullable (_tmp932_);
							_tmp934_ = _tmp933_;
							_tmp935_ = vala_binary_expression_get_right (self);
							_tmp936_ = _tmp935_;
							_tmp937_ = vala_expression_get_value_type (_tmp936_);
							_tmp938_ = _tmp937_;
							_tmp939_ = vala_data_type_get_nullable (_tmp938_);
							_tmp940_ = _tmp939_;
							if (_tmp934_ != _tmp940_) {
								ValaExpression* _tmp941_;
								ValaExpression* _tmp942_;
								ValaDataType* _tmp943_;
								ValaDataType* _tmp944_;
								ValaExpression* _tmp945_;
								ValaExpression* _tmp946_;
								ValaDataType* _tmp947_;
								ValaDataType* _tmp948_;
								_tmp941_ = vala_binary_expression_get_left (self);
								_tmp942_ = _tmp941_;
								_tmp943_ = vala_expression_get_target_type (_tmp942_);
								_tmp944_ = _tmp943_;
								vala_data_type_set_nullable (_tmp944_, TRUE);
								_tmp945_ = vala_binary_expression_get_right (self);
								_tmp946_ = _tmp945_;
								_tmp947_ = vala_expression_get_target_type (_tmp946_);
								_tmp948_ = _tmp947_;
								vala_data_type_set_nullable (_tmp948_, TRUE);
							}
							_tmp949_ = vala_code_context_get_analyzer (context);
							_tmp950_ = _tmp949_;
							_tmp951_ = _tmp950_->bool_type;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp951_);
							_vala_code_node_unref0 (resulting_type);
							_vala_code_node_unref0 (gvalue_type);
						} else {
							gboolean _tmp952_ = FALSE;
							gboolean _tmp953_ = FALSE;
							ValaBinaryOperator _tmp954_;
							_tmp954_ = self->priv->_operator;
							if (_tmp954_ == VALA_BINARY_OPERATOR_BITWISE_AND) {
								_tmp953_ = TRUE;
							} else {
								ValaBinaryOperator _tmp955_;
								_tmp955_ = self->priv->_operator;
								_tmp953_ = _tmp955_ == VALA_BINARY_OPERATOR_BITWISE_OR;
							}
							if (_tmp953_) {
								_tmp952_ = TRUE;
							} else {
								ValaBinaryOperator _tmp956_;
								_tmp956_ = self->priv->_operator;
								_tmp952_ = _tmp956_ == VALA_BINARY_OPERATOR_BITWISE_XOR;
							}
							if (_tmp952_) {
								ValaExpression* _tmp957_;
								ValaExpression* _tmp958_;
								ValaDataType* _tmp959_;
								ValaDataType* _tmp960_;
								ValaExpression* _tmp961_;
								ValaExpression* _tmp962_;
								ValaDataType* _tmp963_;
								ValaDataType* _tmp964_;
								gboolean _tmp965_ = FALSE;
								ValaExpression* _tmp966_;
								ValaExpression* _tmp967_;
								ValaDataType* _tmp968_;
								ValaDataType* _tmp969_;
								ValaSemanticAnalyzer* _tmp970_;
								ValaSemanticAnalyzer* _tmp971_;
								ValaDataType* _tmp972_;
								_tmp957_ = vala_binary_expression_get_left (self);
								_tmp958_ = _tmp957_;
								_tmp959_ = vala_expression_get_target_type (_tmp958_);
								_tmp960_ = _tmp959_;
								vala_data_type_set_nullable (_tmp960_, FALSE);
								_tmp961_ = vala_binary_expression_get_right (self);
								_tmp962_ = _tmp961_;
								_tmp963_ = vala_expression_get_target_type (_tmp962_);
								_tmp964_ = _tmp963_;
								vala_data_type_set_nullable (_tmp964_, FALSE);
								_tmp966_ = vala_binary_expression_get_left (self);
								_tmp967_ = _tmp966_;
								_tmp968_ = vala_expression_get_value_type (_tmp967_);
								_tmp969_ = _tmp968_;
								_tmp970_ = vala_code_context_get_analyzer (context);
								_tmp971_ = _tmp970_;
								_tmp972_ = _tmp971_->bool_type;
								if (vala_data_type_compatible (_tmp969_, _tmp972_)) {
									ValaExpression* _tmp973_;
									ValaExpression* _tmp974_;
									ValaDataType* _tmp975_;
									ValaDataType* _tmp976_;
									ValaSemanticAnalyzer* _tmp977_;
									ValaSemanticAnalyzer* _tmp978_;
									ValaDataType* _tmp979_;
									_tmp973_ = vala_binary_expression_get_right (self);
									_tmp974_ = _tmp973_;
									_tmp975_ = vala_expression_get_value_type (_tmp974_);
									_tmp976_ = _tmp975_;
									_tmp977_ = vala_code_context_get_analyzer (context);
									_tmp978_ = _tmp977_;
									_tmp979_ = _tmp978_->bool_type;
									_tmp965_ = !vala_data_type_compatible (_tmp976_, _tmp979_);
								} else {
									_tmp965_ = FALSE;
								}
								if (_tmp965_) {
									ValaExpression* _tmp980_;
									ValaExpression* _tmp981_;
									ValaDataType* _tmp982_;
									ValaDataType* _tmp983_;
									ValaDataType* _tmp984_;
									ValaDataType* _tmp985_;
									_tmp980_ = vala_binary_expression_get_right (self);
									_tmp981_ = _tmp980_;
									_tmp982_ = vala_expression_get_target_type (_tmp981_);
									_tmp983_ = _tmp982_;
									_tmp984_ = vala_data_type_copy (_tmp983_);
									_tmp985_ = _tmp984_;
									vala_expression_set_value_type ((ValaExpression*) self, _tmp985_);
									_vala_code_node_unref0 (_tmp985_);
								} else {
									ValaExpression* _tmp986_;
									ValaExpression* _tmp987_;
									ValaDataType* _tmp988_;
									ValaDataType* _tmp989_;
									ValaDataType* _tmp990_;
									ValaDataType* _tmp991_;
									_tmp986_ = vala_binary_expression_get_left (self);
									_tmp987_ = _tmp986_;
									_tmp988_ = vala_expression_get_target_type (_tmp987_);
									_tmp989_ = _tmp988_;
									_tmp990_ = vala_data_type_copy (_tmp989_);
									_tmp991_ = _tmp990_;
									vala_expression_set_value_type ((ValaExpression*) self, _tmp991_);
									_vala_code_node_unref0 (_tmp991_);
								}
							} else {
								gboolean _tmp992_ = FALSE;
								ValaBinaryOperator _tmp993_;
								_tmp993_ = self->priv->_operator;
								if (_tmp993_ == VALA_BINARY_OPERATOR_AND) {
									_tmp992_ = TRUE;
								} else {
									ValaBinaryOperator _tmp994_;
									_tmp994_ = self->priv->_operator;
									_tmp992_ = _tmp994_ == VALA_BINARY_OPERATOR_OR;
								}
								if (_tmp992_) {
									gboolean _tmp995_ = FALSE;
									ValaExpression* _tmp996_;
									ValaExpression* _tmp997_;
									ValaDataType* _tmp998_;
									ValaDataType* _tmp999_;
									ValaSemanticAnalyzer* _tmp1000_;
									ValaSemanticAnalyzer* _tmp1001_;
									ValaDataType* _tmp1002_;
									ValaExpression* _tmp1012_;
									ValaExpression* _tmp1013_;
									ValaDataType* _tmp1014_;
									ValaDataType* _tmp1015_;
									ValaExpression* _tmp1016_;
									ValaExpression* _tmp1017_;
									ValaDataType* _tmp1018_;
									ValaDataType* _tmp1019_;
									ValaSemanticAnalyzer* _tmp1020_;
									ValaSemanticAnalyzer* _tmp1021_;
									ValaDataType* _tmp1022_;
									_tmp996_ = vala_binary_expression_get_left (self);
									_tmp997_ = _tmp996_;
									_tmp998_ = vala_expression_get_value_type (_tmp997_);
									_tmp999_ = _tmp998_;
									_tmp1000_ = vala_code_context_get_analyzer (context);
									_tmp1001_ = _tmp1000_;
									_tmp1002_ = _tmp1001_->bool_type;
									if (!vala_data_type_compatible (_tmp999_, _tmp1002_)) {
										_tmp995_ = TRUE;
									} else {
										ValaExpression* _tmp1003_;
										ValaExpression* _tmp1004_;
										ValaDataType* _tmp1005_;
										ValaDataType* _tmp1006_;
										ValaSemanticAnalyzer* _tmp1007_;
										ValaSemanticAnalyzer* _tmp1008_;
										ValaDataType* _tmp1009_;
										_tmp1003_ = vala_binary_expression_get_right (self);
										_tmp1004_ = _tmp1003_;
										_tmp1005_ = vala_expression_get_value_type (_tmp1004_);
										_tmp1006_ = _tmp1005_;
										_tmp1007_ = vala_code_context_get_analyzer (context);
										_tmp1008_ = _tmp1007_;
										_tmp1009_ = _tmp1008_->bool_type;
										_tmp995_ = !vala_data_type_compatible (_tmp1006_, _tmp1009_);
									}
									if (_tmp995_) {
										ValaSourceReference* _tmp1010_;
										ValaSourceReference* _tmp1011_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp1010_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp1011_ = _tmp1010_;
										vala_report_error (_tmp1011_, "Operands must be boolean");
									}
									_tmp1012_ = vala_binary_expression_get_left (self);
									_tmp1013_ = _tmp1012_;
									_tmp1014_ = vala_expression_get_target_type (_tmp1013_);
									_tmp1015_ = _tmp1014_;
									vala_data_type_set_nullable (_tmp1015_, FALSE);
									_tmp1016_ = vala_binary_expression_get_right (self);
									_tmp1017_ = _tmp1016_;
									_tmp1018_ = vala_expression_get_target_type (_tmp1017_);
									_tmp1019_ = _tmp1018_;
									vala_data_type_set_nullable (_tmp1019_, FALSE);
									_tmp1020_ = vala_code_context_get_analyzer (context);
									_tmp1021_ = _tmp1020_;
									_tmp1022_ = _tmp1021_->bool_type;
									vala_expression_set_value_type ((ValaExpression*) self, _tmp1022_);
								} else {
									ValaBinaryOperator _tmp1023_;
									_tmp1023_ = self->priv->_operator;
									if (_tmp1023_ == VALA_BINARY_OPERATOR_IN) {
										gboolean _tmp1024_ = FALSE;
										ValaExpression* _tmp1025_;
										ValaExpression* _tmp1026_;
										ValaDataType* _tmp1027_;
										ValaDataType* _tmp1028_;
										ValaSemanticAnalyzer* _tmp1029_;
										ValaSemanticAnalyzer* _tmp1030_;
										ValaDataType* _tmp1031_;
										ValaSemanticAnalyzer* _tmp1137_;
										ValaSemanticAnalyzer* _tmp1138_;
										ValaDataType* _tmp1139_;
										_tmp1025_ = vala_binary_expression_get_left (self);
										_tmp1026_ = _tmp1025_;
										_tmp1027_ = vala_expression_get_value_type (_tmp1026_);
										_tmp1028_ = _tmp1027_;
										_tmp1029_ = vala_code_context_get_analyzer (context);
										_tmp1030_ = _tmp1029_;
										_tmp1031_ = _tmp1030_->int_type;
										if (vala_data_type_compatible (_tmp1028_, _tmp1031_)) {
											ValaExpression* _tmp1032_;
											ValaExpression* _tmp1033_;
											ValaDataType* _tmp1034_;
											ValaDataType* _tmp1035_;
											ValaSemanticAnalyzer* _tmp1036_;
											ValaSemanticAnalyzer* _tmp1037_;
											ValaDataType* _tmp1038_;
											_tmp1032_ = vala_binary_expression_get_right (self);
											_tmp1033_ = _tmp1032_;
											_tmp1034_ = vala_expression_get_value_type (_tmp1033_);
											_tmp1035_ = _tmp1034_;
											_tmp1036_ = vala_code_context_get_analyzer (context);
											_tmp1037_ = _tmp1036_;
											_tmp1038_ = _tmp1037_->int_type;
											_tmp1024_ = vala_data_type_compatible (_tmp1035_, _tmp1038_);
										} else {
											_tmp1024_ = FALSE;
										}
										if (_tmp1024_) {
											ValaExpression* _tmp1039_;
											ValaExpression* _tmp1040_;
											ValaDataType* _tmp1041_;
											ValaDataType* _tmp1042_;
											ValaExpression* _tmp1043_;
											ValaExpression* _tmp1044_;
											ValaDataType* _tmp1045_;
											ValaDataType* _tmp1046_;
											_tmp1039_ = vala_binary_expression_get_left (self);
											_tmp1040_ = _tmp1039_;
											_tmp1041_ = vala_expression_get_target_type (_tmp1040_);
											_tmp1042_ = _tmp1041_;
											vala_data_type_set_nullable (_tmp1042_, FALSE);
											_tmp1043_ = vala_binary_expression_get_right (self);
											_tmp1044_ = _tmp1043_;
											_tmp1045_ = vala_expression_get_target_type (_tmp1044_);
											_tmp1046_ = _tmp1045_;
											vala_data_type_set_nullable (_tmp1046_, FALSE);
										} else {
											ValaExpression* _tmp1047_;
											ValaExpression* _tmp1048_;
											ValaDataType* _tmp1049_;
											ValaDataType* _tmp1050_;
											_tmp1047_ = vala_binary_expression_get_right (self);
											_tmp1048_ = _tmp1047_;
											_tmp1049_ = vala_expression_get_value_type (_tmp1048_);
											_tmp1050_ = _tmp1049_;
											if (VALA_IS_ARRAY_TYPE (_tmp1050_)) {
												ValaExpression* _tmp1051_;
												ValaExpression* _tmp1052_;
												ValaDataType* _tmp1053_;
												ValaDataType* _tmp1054_;
												ValaExpression* _tmp1055_;
												ValaExpression* _tmp1056_;
												ValaDataType* _tmp1057_;
												ValaDataType* _tmp1058_;
												ValaDataType* _tmp1059_;
												ValaDataType* _tmp1060_;
												_tmp1051_ = vala_binary_expression_get_left (self);
												_tmp1052_ = _tmp1051_;
												_tmp1053_ = vala_expression_get_value_type (_tmp1052_);
												_tmp1054_ = _tmp1053_;
												_tmp1055_ = vala_binary_expression_get_right (self);
												_tmp1056_ = _tmp1055_;
												_tmp1057_ = vala_expression_get_value_type (_tmp1056_);
												_tmp1058_ = _tmp1057_;
												_tmp1059_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1058_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
												_tmp1060_ = _tmp1059_;
												if (!vala_data_type_compatible (_tmp1054_, _tmp1060_)) {
													ValaSourceReference* _tmp1061_;
													ValaSourceReference* _tmp1062_;
													ValaExpression* _tmp1063_;
													ValaExpression* _tmp1064_;
													ValaDataType* _tmp1065_;
													ValaDataType* _tmp1066_;
													gchar* _tmp1067_;
													gchar* _tmp1068_;
													ValaExpression* _tmp1069_;
													ValaExpression* _tmp1070_;
													ValaDataType* _tmp1071_;
													ValaDataType* _tmp1072_;
													gchar* _tmp1073_;
													gchar* _tmp1074_;
													gchar* _tmp1075_;
													gchar* _tmp1076_;
													_tmp1061_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1062_ = _tmp1061_;
													_tmp1063_ = vala_binary_expression_get_left (self);
													_tmp1064_ = _tmp1063_;
													_tmp1065_ = vala_expression_get_value_type (_tmp1064_);
													_tmp1066_ = _tmp1065_;
													_tmp1067_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1066_);
													_tmp1068_ = _tmp1067_;
													_tmp1069_ = vala_binary_expression_get_right (self);
													_tmp1070_ = _tmp1069_;
													_tmp1071_ = vala_expression_get_value_type (_tmp1070_);
													_tmp1072_ = _tmp1071_;
													_tmp1073_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1072_);
													_tmp1074_ = _tmp1073_;
													_tmp1075_ = g_strdup_printf ("Cannot look for `%s' in `%s'", _tmp1068_, _tmp1074_);
													_tmp1076_ = _tmp1075_;
													vala_report_error (_tmp1062_, _tmp1076_);
													_g_free0 (_tmp1076_);
													_g_free0 (_tmp1074_);
													_g_free0 (_tmp1068_);
												}
											} else {
												ValaMethod* contains_method = NULL;
												ValaExpression* _tmp1077_;
												ValaExpression* _tmp1078_;
												ValaDataType* _tmp1079_;
												ValaDataType* _tmp1080_;
												ValaSymbol* _tmp1081_;
												ValaMethod* _tmp1082_;
												ValaMethod* _tmp1083_;
												ValaMethod* _tmp1094_;
												ValaList* _tmp1095_;
												ValaList* _tmp1096_;
												gint _tmp1097_;
												gint _tmp1098_;
												gboolean _tmp1099_;
												ValaMethod* _tmp1107_;
												ValaDataType* _tmp1108_;
												ValaDataType* _tmp1109_;
												ValaSemanticAnalyzer* _tmp1110_;
												ValaSemanticAnalyzer* _tmp1111_;
												ValaDataType* _tmp1112_;
												ValaMethodCall* contains_call = NULL;
												ValaExpression* _tmp1120_;
												ValaExpression* _tmp1121_;
												ValaSourceReference* _tmp1122_;
												ValaSourceReference* _tmp1123_;
												ValaMemberAccess* _tmp1124_;
												ValaMemberAccess* _tmp1125_;
												ValaSourceReference* _tmp1126_;
												ValaSourceReference* _tmp1127_;
												ValaMethodCall* _tmp1128_;
												ValaMethodCall* _tmp1129_;
												ValaMethodCall* _tmp1130_;
												ValaExpression* _tmp1131_;
												ValaExpression* _tmp1132_;
												ValaCodeNode* _tmp1133_;
												ValaCodeNode* _tmp1134_;
												ValaMethodCall* _tmp1135_;
												ValaMethodCall* _tmp1136_;
												_tmp1077_ = vala_binary_expression_get_right (self);
												_tmp1078_ = _tmp1077_;
												_tmp1079_ = vala_expression_get_value_type (_tmp1078_);
												_tmp1080_ = _tmp1079_;
												_tmp1081_ = vala_data_type_get_member (_tmp1080_, "contains");
												_tmp1082_ = VALA_IS_METHOD (_tmp1081_) ? ((ValaMethod*) _tmp1081_) : NULL;
												if (_tmp1082_ == NULL) {
													_vala_code_node_unref0 (_tmp1081_);
												}
												contains_method = _tmp1082_;
												_tmp1083_ = contains_method;
												if (_tmp1083_ == NULL) {
													ValaSourceReference* _tmp1084_;
													ValaSourceReference* _tmp1085_;
													ValaExpression* _tmp1086_;
													ValaExpression* _tmp1087_;
													ValaDataType* _tmp1088_;
													ValaDataType* _tmp1089_;
													gchar* _tmp1090_;
													gchar* _tmp1091_;
													gchar* _tmp1092_;
													gchar* _tmp1093_;
													_tmp1084_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1085_ = _tmp1084_;
													_tmp1086_ = vala_binary_expression_get_right (self);
													_tmp1087_ = _tmp1086_;
													_tmp1088_ = vala_expression_get_value_type (_tmp1087_);
													_tmp1089_ = _tmp1088_;
													_tmp1090_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1089_);
													_tmp1091_ = _tmp1090_;
													_tmp1092_ = g_strdup_printf ("`%s' does not have a `contains' method", _tmp1091_);
													_tmp1093_ = _tmp1092_;
													vala_report_error (_tmp1085_, _tmp1093_);
													_g_free0 (_tmp1093_);
													_g_free0 (_tmp1091_);
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													result = FALSE;
													_vala_code_node_unref0 (contains_method);
													return result;
												}
												_tmp1094_ = contains_method;
												_tmp1095_ = vala_callable_get_parameters ((ValaCallable*) _tmp1094_);
												_tmp1096_ = _tmp1095_;
												_tmp1097_ = vala_collection_get_size ((ValaCollection*) _tmp1096_);
												_tmp1098_ = _tmp1097_;
												_tmp1099_ = _tmp1098_ != 1;
												_vala_iterable_unref0 (_tmp1096_);
												if (_tmp1099_) {
													ValaSourceReference* _tmp1100_;
													ValaSourceReference* _tmp1101_;
													ValaMethod* _tmp1102_;
													gchar* _tmp1103_;
													gchar* _tmp1104_;
													gchar* _tmp1105_;
													gchar* _tmp1106_;
													_tmp1100_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1101_ = _tmp1100_;
													_tmp1102_ = contains_method;
													_tmp1103_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1102_);
													_tmp1104_ = _tmp1103_;
													_tmp1105_ = g_strdup_printf ("`%s' must have one parameter", _tmp1104_);
													_tmp1106_ = _tmp1105_;
													vala_report_error (_tmp1101_, _tmp1106_);
													_g_free0 (_tmp1106_);
													_g_free0 (_tmp1104_);
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													result = FALSE;
													_vala_code_node_unref0 (contains_method);
													return result;
												}
												_tmp1107_ = contains_method;
												_tmp1108_ = vala_callable_get_return_type ((ValaCallable*) _tmp1107_);
												_tmp1109_ = _tmp1108_;
												_tmp1110_ = vala_code_context_get_analyzer (context);
												_tmp1111_ = _tmp1110_;
												_tmp1112_ = _tmp1111_->bool_type;
												if (!vala_data_type_compatible (_tmp1109_, _tmp1112_)) {
													ValaSourceReference* _tmp1113_;
													ValaSourceReference* _tmp1114_;
													ValaMethod* _tmp1115_;
													gchar* _tmp1116_;
													gchar* _tmp1117_;
													gchar* _tmp1118_;
													gchar* _tmp1119_;
													_tmp1113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1114_ = _tmp1113_;
													_tmp1115_ = contains_method;
													_tmp1116_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1115_);
													_tmp1117_ = _tmp1116_;
													_tmp1118_ = g_strdup_printf ("`%s' must return a boolean value", _tmp1117_);
													_tmp1119_ = _tmp1118_;
													vala_report_error (_tmp1114_, _tmp1119_);
													_g_free0 (_tmp1119_);
													_g_free0 (_tmp1117_);
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													result = FALSE;
													_vala_code_node_unref0 (contains_method);
													return result;
												}
												_tmp1120_ = vala_binary_expression_get_right (self);
												_tmp1121_ = _tmp1120_;
												_tmp1122_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1123_ = _tmp1122_;
												_tmp1124_ = vala_member_access_new (_tmp1121_, "contains", _tmp1123_);
												_tmp1125_ = _tmp1124_;
												_tmp1126_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1127_ = _tmp1126_;
												_tmp1128_ = vala_method_call_new ((ValaExpression*) _tmp1125_, _tmp1127_);
												_tmp1129_ = _tmp1128_;
												_vala_code_node_unref0 (_tmp1125_);
												contains_call = _tmp1129_;
												_tmp1130_ = contains_call;
												_tmp1131_ = vala_binary_expression_get_left (self);
												_tmp1132_ = _tmp1131_;
												vala_method_call_add_argument (_tmp1130_, _tmp1132_);
												_tmp1133_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
												_tmp1134_ = _tmp1133_;
												_tmp1135_ = contains_call;
												vala_code_node_replace_expression (_tmp1134_, (ValaExpression*) self, (ValaExpression*) _tmp1135_);
												_tmp1136_ = contains_call;
												result = vala_code_node_check ((ValaCodeNode*) _tmp1136_, context);
												_vala_code_node_unref0 (contains_call);
												_vala_code_node_unref0 (contains_method);
												return result;
											}
										}
										_tmp1137_ = vala_code_context_get_analyzer (context);
										_tmp1138_ = _tmp1137_;
										_tmp1139_ = _tmp1138_->bool_type;
										vala_expression_set_value_type ((ValaExpression*) self, _tmp1139_);
									} else {
										g_assert_not_reached ();
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp1140_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1141_ = _tmp1140_;
	result = !_tmp1141_;
	return result;
}


static void
vala_binary_expression_real_emit (ValaCodeNode* base,
                                  ValaCodeGenerator* codegen)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	vala_code_visitor_visit_binary_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                   ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
}


static void
vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
}


ValaBinaryOperator
vala_binary_expression_get_operator (ValaBinaryExpression* self)
{
	ValaBinaryOperator result;
	ValaBinaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}


void
vala_binary_expression_set_operator (ValaBinaryExpression* self,
                                     ValaBinaryOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}


ValaExpression*
vala_binary_expression_get_left (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}


void
vala_binary_expression_set_left (ValaBinaryExpression* self,
                                 ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaExpression*
vala_binary_expression_get_right (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}


void
vala_binary_expression_set_right (ValaBinaryExpression* self,
                                  ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


gboolean
vala_binary_expression_get_is_chained (ValaBinaryExpression* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_chained;
	result = _tmp0_;
	return result;
}


static void
vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chained = value;
}


static void
vala_binary_expression_class_init (ValaBinaryExpressionClass * klass)
{
	vala_binary_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_binary_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaBinaryExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_binary_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_binary_expression_real_to_string;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_non_null;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_binary_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_binary_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_binary_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_used_variables;
}


static void
vala_binary_expression_instance_init (ValaBinaryExpression * self)
{
	self->priv = VALA_BINARY_EXPRESSION_GET_PRIVATE (self);
}


static void
vala_binary_expression_finalize (ValaCodeNode * obj)
{
	ValaBinaryExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_binary_expression_parent_class)->finalize (obj);
}


/**
 * Represents an expression with two operands in the source code.
 *
 * Supports +, -, *, /, %, <<, >>, <, >, <=, >=, ==, !=, &, |, ^, &&, ||, ??.
 */
GType
vala_binary_expression_get_type (void)
{
	static volatile gsize vala_binary_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaBinaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_binary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBinaryExpression), 0, (GInstanceInitFunc) vala_binary_expression_instance_init, NULL };
		GType vala_binary_expression_type_id;
		vala_binary_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaBinaryExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_binary_expression_type_id__volatile, vala_binary_expression_type_id);
	}
	return vala_binary_expression_type_id__volatile;
}


GType
vala_binary_operator_get_type (void)
{
	static volatile gsize vala_binary_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_BINARY_OPERATOR_NONE, "VALA_BINARY_OPERATOR_NONE", "none"}, {VALA_BINARY_OPERATOR_PLUS, "VALA_BINARY_OPERATOR_PLUS", "plus"}, {VALA_BINARY_OPERATOR_MINUS, "VALA_BINARY_OPERATOR_MINUS", "minus"}, {VALA_BINARY_OPERATOR_MUL, "VALA_BINARY_OPERATOR_MUL", "mul"}, {VALA_BINARY_OPERATOR_DIV, "VALA_BINARY_OPERATOR_DIV", "div"}, {VALA_BINARY_OPERATOR_MOD, "VALA_BINARY_OPERATOR_MOD", "mod"}, {VALA_BINARY_OPERATOR_SHIFT_LEFT, "VALA_BINARY_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_BINARY_OPERATOR_SHIFT_RIGHT, "VALA_BINARY_OPERATOR_SHIFT_RIGHT", "shift-right"}, {VALA_BINARY_OPERATOR_LESS_THAN, "VALA_BINARY_OPERATOR_LESS_THAN", "less-than"}, {VALA_BINARY_OPERATOR_GREATER_THAN, "VALA_BINARY_OPERATOR_GREATER_THAN", "greater-than"}, {VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL", "less-than-or-equal"}, {VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL", "greater-than-or-equal"}, {VALA_BINARY_OPERATOR_EQUALITY, "VALA_BINARY_OPERATOR_EQUALITY", "equality"}, {VALA_BINARY_OPERATOR_INEQUALITY, "VALA_BINARY_OPERATOR_INEQUALITY", "inequality"}, {VALA_BINARY_OPERATOR_BITWISE_AND, "VALA_BINARY_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_BINARY_OPERATOR_BITWISE_OR, "VALA_BINARY_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_BINARY_OPERATOR_BITWISE_XOR, "VALA_BINARY_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_BINARY_OPERATOR_AND, "VALA_BINARY_OPERATOR_AND", "and"}, {VALA_BINARY_OPERATOR_OR, "VALA_BINARY_OPERATOR_OR", "or"}, {VALA_BINARY_OPERATOR_IN, "VALA_BINARY_OPERATOR_IN", "in"}, {VALA_BINARY_OPERATOR_COALESCE, "VALA_BINARY_OPERATOR_COALESCE", "coalesce"}, {0, NULL, NULL}};
		GType vala_binary_operator_type_id;
		vala_binary_operator_type_id = g_enum_register_static ("ValaBinaryOperator", values);
		g_once_init_leave (&vala_binary_operator_type_id__volatile, vala_binary_operator_type_id);
	}
	return vala_binary_operator_type_id__volatile;
}



